#!/usr/bin/perl

package eBay::API::XML::DataType::ListingDurationDefinitionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingDurationDefinitionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingDurationDefinitionType

=head1 DESCRIPTION

A container node for a set of durations that apply to a certain listing type.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingDurationDefinitionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Duration', 'xs:token', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'durationSetID', 'xs:int', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDuration()

Specifies the length of time an auction can be open, in days. The allowed durations
vary according to the type of listing. The value GTC means Good Til Canceled.

#    Argument: reference to an array  
                      of 'xs:token'

=cut

sub setDuration {
  my $self = shift;
  $self->{'Duration'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDuration()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'xs:token'

=cut

sub getDuration {
  my $self = shift;
  return $self->_getDataTypeArray('Duration');
}




=head2 setDurationSetID()

Identifies the type of listing to which the set of durations applies. The durationSetID value corresponds to the listing types returned in  Category.ListingDuration (also in the call response).

#    Argument: 'xs:int'

=cut

sub setDurationSetID {
  my $self = shift;
  $self->{'durationSetID'} = shift
}

=head2 getDurationSetID()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:int'

=cut

sub getDurationSetID {
  my $self = shift;
  return $self->{'durationSetID'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
