#!/usr/bin/perl

package eBay::API::XML::DataType::StoreThemeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreThemeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreThemeType

=head1 DESCRIPTION

Store theme.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreThemeType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::StoreColorSchemeType;


my @gaProperties = ( [ 'ColorScheme', 'ns:StoreColorSchemeType', ''
	     ,'eBay::API::XML::DataType::StoreColorSchemeType', '1' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'ThemeID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setColorScheme()

Theme color scheme.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreColorSchemeType'

=cut

sub setColorScheme {
  my $self = shift;
  $self->{'ColorScheme'} = shift
}

=head2 getColorScheme()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always
  Context: BasicThemeArray

#    Returns: 'ns:StoreColorSchemeType'

=cut

sub getColorScheme {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ColorScheme'
		,'eBay::API::XML::DataType::StoreColorSchemeType');
}


=head2 setName()

Store theme name. Provides a user-friendly name for the theme.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setThemeID()

Store theme ID (use GetStoreOptions to get the list of valid theme
IDs).

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:int'

=cut

sub setThemeID {
  my $self = shift;
  $self->{'ThemeID'} = shift
}

=head2 getThemeID()

  Calls: GetStore
  Returned: Conditionally

  Calls: GetStoreOptions
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getThemeID {
  my $self = shift;
  return $self->{'ThemeID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
