=begin comment

QueryBuilderApi

Active Query Builder Web API lets create, analyze and modify SQL queries for different database servers using RESTful HTTP requests. Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it's impossible to get transformed SQL that reveals any other data than the data retutned by original query.

OpenAPI spec version: 1.1.0
Contact: development@activedbsoft.com
Generated by: https://github.com/swagger-api/swagger-codegen.git

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package WebApiActiveQueryBuilder::ActiveQueryBuilderApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use WebApiActiveQueryBuilder::ApiClient;
use WebApiActiveQueryBuilder::Configuration;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class   = shift;
    my (%self) = (
        'api_client' => WebApiActiveQueryBuilder::ApiClient->instance,
        @_
    );

    #my $self = {
    #    #api_client => $options->{api_client}
    #    api_client => $default_api_client
    #}; 

    bless \%self, $class;

}


#
# get_fields_post
#
# 
# 
# @param SqlQuery $query todo (required)
{
    my $params = {
    'query' => {
        data_type => 'SqlQuery',
        description => 'todo',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_fields_post' } = { 
    	summary => '',
        params => $params,
        returns => 'ARRAY[Field]',
        };
}
# @return ARRAY[Field]
#
sub get_fields_post {
    my ($self, %args) = @_;

    # verify the required parameter 'query' is set
    unless (exists $args{'query'}) {
      croak("Missing the required parameter 'query' when calling get_fields_post");
    }

    # parse inputs
    my $_resource_path = '/getFields';
    $_resource_path =~ s/{format}/json/; # default format to json

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json', 'text/html');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json', 'text/xml');

    my $_body_data;
    # body params
    if ( exists $args{'query'}) {
        $_body_data = $args{'query'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Field]', $response);
    return $_response_object;
}

#
# transform_post
#
# 
# 
# @param Transform $transform Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it&#39;s impossible to get transformed SQL that reveals any other data than the data retutned by original query. (required)
{
    my $params = {
    'transform' => {
        data_type => 'Transform',
        description => 'Transforms the given SQL query according to the commands provided in this request. You can add constraints, hide some of the resultset columns, chang sorting or limit rows of resultset. All transformations are performed according to the SQL syntax and database schema provided through the registered account at https://webapi.activequerybuilder.com/ identified by the given unique identifier. All transformations can only lead to reorganization or limitation of the resultset data. This means that it&#39;s impossible to get transformed SQL that reveals any other data than the data retutned by original query.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'transform_post' } = { 
    	summary => '',
        params => $params,
        returns => 'Result',
        };
}
# @return Result
#
sub transform_post {
    my ($self, %args) = @_;

    # verify the required parameter 'transform' is set
    unless (exists $args{'transform'}) {
      croak("Missing the required parameter 'transform' when calling transform_post");
    }

    # parse inputs
    my $_resource_path = '/transform';
    $_resource_path =~ s/{format}/json/; # default format to json

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json', 'text/html');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json', 'text/xml');

    my $_body_data;
    # body params
    if ( exists $args{'transform'}) {
        $_body_data = $args{'transform'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Result', $response);
    return $_response_object;
}

1;
