#!/usr/bin/env perl
use strict;
use warnings;
use Data::Dumper;
use File::Slurp;

BEGIN { unshift( @INC, './lib' ) }

BEGIN {
    use Test::Most;
    use_ok('Bio::PanGenome::SampleOrder');
}

ok(my $obj = Bio::PanGenome::SampleOrder->new(
    tree_file        => 't/data/reorder_isolates.tre',
  ), 'initialise sample order object');

is_deeply($obj->ordered_samples(),['query_1', 'query_3','query_4','query_2'],'order of sample names matches the tree');


ok( $obj = Bio::PanGenome::SampleOrder->new(
    tree_file        => 't/data/raxml.tre',
  ), 'initialise sample order object with raxml tree');

is_deeply($obj->ordered_samples(),[
          'efgh_7#3',
          'abcd_4#15',
          'abcd_3#9',
          'abcd_4#17',
          'abcd_3#20',
          'abcd_3#96',
          'abcd_3#7',
          '6753_5#30',
          'abcd_3#8',
          'abcd_3#12',
          'abcd_4#13',
          'abcd_3#4',
          'abcd_3#47',
          'abcd_4#36',
          'abcd_3#90',
          'abcd_3#45',
          'abcd_3#51',
          'abcd_3#76',
          'abcd_4#22',
          'abcd_3#94',
          'abcd_3#72',
          'abcd_3#18',
          'abcd_3#82',
          'abcd_3#88',
          'abcd_3#87',
          'abcd_3#58',
          'abcd_3#85',
          'abcd_4#24',
          'abcd_3#86',
          'abcd_4#38',
          'abcd_3#70',
          'abcd_3#89',
          'abcd_3#19',
          'abcd_3#84',
          'abcd_3#60',
          'abcd_4#21',
          'abcd_3#35',
          'abcd_3#32',
          'abcd_4#20',
          'abcd_3#11',
          'abcd_4#28',
          'abcd_4#27',
          'abcd_3#54',
          'abcd_3#53',
          'abcd_3#43',
          'abcd_3#50',
          'abcd_4#12',
          'abcd_3#15',
          'abcd_3#21',
          'abcd_3#91',
          'abcd_3#73',
          'abcd_3#61',
          'abcd_4#35',
          'abcd_3#17',
          'abcd_3#67',
          'abcd_3#27',
          'abcd_3#13',
          'abcd_3#24',
          'abcd_3#95',
          'abcd_3#23',
          'abcd_3#29',
          'abcd_3#75',
          'abcd_3#25',
          'abcd_4#16',
          'abcd_4#30',
          'abcd_4#26',
          'abcd_3#36',
          'abcd_4#25',
          'abcd_3#64',
          'abcd_3#44',
          'abcd_3#68',
          'abcd_3#69',
          'efgh_7#12',
          'abcd_3#55',
          'abcd_4#1',
          'abcd_3#56',
          'abcd_3#14',
          'abcd_4#7',
          'abcd_4#8',
          'abcd_3#26',
          'abcd_4#9',
          'abcd_4#40',
          'abcd_4#10',
          'abcd_4#6',
          'abcd_4#5',
          'abcd_3#3',
          'abcd_3#33',
          'abcd_3#28',
          'abcd_3#6',
          'abcd_3#16',
          'abcd_3#79',
          'abcd_3#77',
          'abcd_4#41',
          'abcd_4#34',
          'abcd_3#5',
          'abcd_3#74',
          'abcd_3#34',
          'abcd_3#2',
          'abcd_3#22',
          'abcd_4#32',
          'abcd_3#92',
          'abcd_4#19',
          'abcd_4#23',
          'abcd_4#18',
          'abcd_3#37',
          'abcd_3#59',
          'abcd_3#30',
          'abcd_3#1',
          'abcd_4#42',
          'abcd_3#10',
          'abcd_4#37',
          'abcd_3#81',
          'abcd_3#80',
          'abcd_3#83',
          'abcd_4#33',
          'abcd_4#31',
          'abcd_3#71',
          'abcd_3#78',
          'abcd_4#39',
          'abcd_3#41',
          'abcd_4#29',
          'abcd_4#14',
          'abcd_3#31',
          'abcd_3#93',
          'abcd_3#62',
          'abcd_3#48',
          'abcd_3#42',
          'abcd_3#52',
          'abcd_3#57',
          'abcd_3#49',
          'abcd_4#3',
          'abcd_4#2',
          'abcd_3#39',
          'abcd_3#38',
          'abcd_4#11',
          '5749_2#1'
        ],'order of sample names matches the raxml tree');


done_testing();
