#!/bin/sh
#
# A "make dist" equivalent for systems on which "perl Makefile.PL" can't
# work because RT isn't installed.

PACKAGE='RT-Extension-TOTPMFA'
VERSION="$(awk -F = '/^(our|my)?[[:space:]]*\$VERSION[[:space:]]=/{print $2}' lib/RT/Extension/TOTPMFA.pm  | tr -dc '0-9.')"
set -e
rm -rf ${PACKAGE}-${VERSION}
perl -Iinc -MExtUtils::Manifest=manicopy,maniread -e "manicopy(maniread(),'${PACKAGE}-${VERSION}', 'best');"
cd ${PACKAGE}-${VERSION}
perl -Iinc -MExtUtils::Manifest=maniadd -e 'exit unless -e q{META.yml};' \
  -e 'eval { maniadd({q{META.yml} => q{Module YAML meta-data (added by MakeMaker)}}) }' \
  -e '    or die "Could not add META.yml to MANIFEST: ${'\''@'\''}"'
perl -Iinc -MExtUtils::Manifest=maniadd -e 'exit unless -f q{META.json};' \
  -e 'eval { maniadd({q{META.json} => q{Module JSON meta-data (added by MakeMaker)}}) }' \
  -e '    or die "Could not add META.json to MANIFEST: ${'\''@'\''}"'
perl -Iinc -MExtUtils::Manifest=maniadd -e 'eval { maniadd({q{SIGNATURE} => q{Public-key signature (added by MakeMaker)}}) }' \
  -e '    or die "Could not add SIGNATURE to MANIFEST: ${'\''@'\''}"'
touch SIGNATURE
cpansign -s
cd ..
perl -Iinc -I. -MModule::Install::Admin -e "dist_preop(q(${PACKAGE}-${VERSION}))"
tar cvf ${PACKAGE}-${VERSION}.tar ${PACKAGE}-${VERSION}
rm -rf ${PACKAGE}-${VERSION}
gzip --best ${PACKAGE}-${VERSION}.tar
echo "Created ${PACKAGE}-${VERSION}.tar.gz"
perl -Iinc -l -e 'print '\''Warning: Makefile possibly out of date with lib/RT/Extension/TOTPMFA.pm'\''' \
  -e '    if -e '\''lib/RT/Extension/TOTPMFA.pm'\'' and -M '\''lib/RT/Extension/TOTPMFA.pm'\'' < -M '\''Makefile'\'';'
