package main;
use Evo::Base -strict;
use Test::More tests => 5;
use Evo::MDN;
use Test::Fatal;
use Evo::MDN::Util ':all';

my $mdn    = Evo::MDN->new;
my $sender = Evo::Base->new;
my $buggy  = MyBuggy->new;

$mdn->subscribe($buggy, $sender, 1);

ok is_subscribed $buggy, $sender;
ok is_stored $buggy,     $sender;

like exception {
  $mdn->broadcast($sender, 'hello');
},
  qr/Foo/;

ok !is_subscribed $buggy, $sender;
ok !is_stored $buggy,     $sender;

{

  package MyBuggy;
  use Evo::Base -base;
  sub when_message { die "Foo" }
}

done_testing;


