package Evo::Class::XSA;
use Evo;
use parent 'Evo::Class';
use Class::XSAccessor constructor => '_new_xs';
use Evo::Util 'monkey_patch';
use Module::Loaded;

sub _new_pure_hash { bless {%{$_[1]}}, ref $_[0] || $_[0] }

sub init_base {
  my $class = shift;
  my $base  = $class->base;

  # already loaded
  return if is_loaded $base;

  $class->SUPER::init_base;
  monkey_patch $base, new => sub {
    ref $_[1] ? _new_pure_hash(@_) : _new_xs(@_);
  };
}

sub attr_simple {
  my ($class, $target, $attrs) = @_;
  Class::XSAccessor->import(
    class     => $class->base,
    replace   => 1,
    accessors => $attrs,
    chained   => 1
  );
}

1;

# ABSTRACT: Object system backend with Class::XSAccessor

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class::XSA - Object system backend with Class::XSAccessor

=head1 VERSION

version 0.0171

=head1 DESCRIPTION

This class loads automatically if Class::XSAccessor is available

=head2 Internal methods

These methods shouldn't be used directly and can be changed in the future

=head3 init_base
=head3 attr_simple

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
