package Evo::Util;
use Evo;
use parent 'Exporter';
use Symbol();

our @EXPORT_OK = (qw[ monkey_patch ]);
our %EXPORT_TAGS = (all => \@EXPORT_OK);

# copypast from mojo util
my $NAME
  = eval { require Sub::Util; Sub::Util->can('set_subname') } || sub { $_[1] };

sub clear_package {
  my $package = shift or Carp::croak "Define package to clear";

  # @ISA leaks
  no strict 'refs';    ## no critic
  @{"${package}::ISA"} = ();
  Symbol::delete_package $package;
}

sub monkey_patch {
  my ($class, %patch) = @_;
  no strict 'refs';    ## no critic
  no warnings 'redefine';
  *{"${class}::$_"} = $NAME->("${class}::$_", $patch{$_}) for keys %patch;
}

sub camelize {
  my $str = shift;
  return $str if $str =~ /^[A-Z]/;

  # CamelCase words
  return join '::', map {
    join('', map { ucfirst lc } split '_')
  } split '-', $str;
}


# die outside dsl_call (if dsl_stash not exists)
# die if trying to get unexisting value by key
# die if trying to override existing value in the same dsl_call
sub _dsl_stash {
  my ($name, $self, $key, $val) = @_;
  my $dsl_stash = $self->{$name};
  $dsl_stash or Carp::confess 'Using dsl_stash outside station';
  return $dsl_stash unless $key;

  # get
  unless ($val) {
    Carp::confess "Using dsl_stash with wrong key '$key'"
      unless exists $dsl_stash->{$key};
    return $dsl_stash->{$key} unless $val;
  }

  # set, die if already exists
  Carp::confess "Attemt to override existing key '$key'"
    if exists $dsl_stash->{$key};
  $dsl_stash->{$key} = $val;
  $self;
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Util

=head1 VERSION

version 0.0171

=head1 DESCRIPTION

Utilites for package. For internal usage

=head1 METHODS

=head2 run_wrappers

Run wrappers in reverse order passing a last argument to each invocation

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
