package main;
use Evo;
use Test::More;

{

  package My::NotEvo;
  use Evo -loaded;
  sub new { bless {not_evo => 1}, shift }
  sub foo_notevo {'foo'}

  package My::NotEvo2;
  use Evo -loaded;
  sub foo_notevo2 {'foo'}

  package My::Obj;
  use parent 'My::NotEvo';
  use Evo -class;
  has foo_obj => 'foo';

  package My::Child;
  use Evo 'My::Obj', 'My::NotEvo2';
  has foo_child => 'foo';

};

my $obj = My::Obj->new;
ok !$obj->isa('My::Class::Base');
isa_ok($obj, $_) for qw(My::NotEvo My::Obj);

my $child = My::Child->new;
ok !$child->isa('My::Class::Base');
isa_ok($child, $_) for qw(My::NotEvo2 My::NotEvo My::Obj);

is $child->{not_evo}, 1;
is($child->$_, 'foo') for qw(foo_child foo_obj foo_notevo foo_notevo2);

done_testing;
