use Evo;
use Test::More tests => 11;
use Test::Fatal;
use Evo::Dsl;

my $dsl = Evo::Dsl->new;

like exception { $dsl->stash }, qr/outside/, 'dies outside dsl';
like exception { $dsl->stash('foo') }, qr/outside/, 'dies outside dsl';

$dsl->call(
  {foo => 'bar', a => 2, exists => undef},
  sub {

    like exception { $dsl->stash('bad_key') }, qr/wrong key 'bad_key'/,
      'wrong key';

    like exception { $dsl->stash('foo' => 'bad') }, qr/existing key 'foo'/,
      'dies on overrides';

    is $dsl->stash('foo'), 'bar', 'right value';
    is_deeply $dsl->stash, {foo => 'bar', a => 2, exists => undef},
      'right stash';

    is_deeply $dsl->check_stash, {foo => 'bar', a => 2, exists => undef},
      'right check_stash result';
    ok $dsl->check_stash('foo'),    'exists';
    ok $dsl->check_stash('exists'), 'exists';
  }
);

# must not die
ok !$dsl->check_stash, 'lives';
ok !$dsl->check_stash('foo'), 'lives';


1;
