package main;
use Evo;
use Test::More tests => 4;
use Evo::Flow;

my $flow = Evo::Flow->new;
my (@destroyed, @created, $res, $fired);

eval {
  $flow->asap(
    sub {
      my $obj = MyFoo->new;
      $flow->asap(sub { $fired++ });
      $flow->asap(sub {die});
      $flow->asap(sub {$obj});
    },
    sub {
      # not destroyed yet, because it will be uset in station after this one
      ok !@destroyed;
    }
  );
};

ok $fired;
ok scalar @destroyed;
is_deeply [sort @destroyed], [sort @created];

{

  package MyFoo;
  use Evo -class;
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

