use Evo;
use Railway::Train;
use Benchmark ':all';
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};


my $EXPECT = 0.7 * $ENV{TEST_EVO_PERF};
my $N      = 3;
my $L      = 100_000;

my $t = timeit(
  $N,
  sub {
    my $train = Railway::Train->new;
    my $k;
    $train->way->add(sub { $k++ }) for 1 .. $L;
    $train->start();
    ok $k == $L, "$k = $L";
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
