package main;
use Evo;
use Test::More;
use Benchmark ':all';
use Evo::Mdn;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 100_000 * $ENV{TEST_EVO_PERF};
my $N      = 200_000;
my $K;

my $sender = My::Obj->new;
my $mdn    = Evo::Mdn->new;

my $t = timeit(
  $N,
  sub {
    my $me = My::Obj->new;
    $mdn->subscribe($me, $sender, 0, sub { $K++ });
    $mdn->broadcast($sender, 'foo');
  }
);

die unless $K == $N;
diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;

{

  package My::Obj;
  use Evo -class;
}
