use Evo;
use Test::More tests => 3;
use Promises6 qw( deferred );
use Promises6::Util ':const';

# https://github.com/promises-aplus/promises-tests/issues/62
# https://developer.mozilla.org/en-US/docs/Mozilla/JavaScript_code_modules/Promise.jsm/Promise

=pod

 Note: Calling this method with a pending promise as the aValue argument, and then calling it again with another value before the promise is fulfilled or rejected, will have no effect the second time, as the associated promise is already resolved to the pending promise.

=cut

my ($d, $d2, $d3) = (deferred, deferred, deferred);
my $res;

$d->promise->then(sub { $res = shift }, sub {fail});
$d->resolve($d2->promise);
$d2->resolve($d3->promise);

$d2->resolve(33);
$d->resolve(33);
$d2->reject(44);
$d->reject(44);

is $d->state, PENDING, 'state not changed';
is $res, undef, 'promise is already resolved with pending promise';

$d3->resolve('foo');
is $res, 'foo', 'right result';

# already resolved here
$res = undef;
$d2->promise->then(sub { $res = shift });

