use Evo -modern;
use Test::More tests => 1;
use Promises6 ':all';

my ($d, @results);

sub store : prototype() {
  sub($v) { push @results, $v };
}

$d = deferred;

# refers to the same deferred
$d->promise->then(sub($v) {"$v-b1"}, 'bad', 'bad')

  # then-1. optional, if onF/onR is not a function, it must be ignored
  ->then()->then('i', 'i', 'i')->then(store);

# then-6. then may be called multiple times on the same promise.
$d->promise->then(sub($v) {"$v-a1"})->then(store);


# resolution-2, fulfill
$d->promise->then(sub($v) { resolved("$v-c1") })->then(store);

# then-3. rejected
# resolution-2, reject
$d->promise->then(sub { rejected("reason") })

  # then-7.iv, onRejected not a function, reject with same reason
  ->then(sub { }, undef)->then(undef, store);

$d->resolve('S');

# ignore
$d->resolve('bad');
$d->reject('bad');

is_deeply [sort @results], [sort qw(S-a1 S-b1 S-c1 reason)], 'right flow';

done_testing;
