package main;
use Evo -modern;
use Test::More tests => 6;
use Promises6 'deferred';

my ($d, @results, $d_out);

sub store : prototype() {
  sub($v) { push @results, $v };
}

# resolve
($d, $d_out, @results) = (deferred, deferred);
$d->promise->then(sub { Thenable->new })->then(store);
$d->resolve(undef);
ok !scalar @results, 'no results yet';

$d_out->resolve('ok');
is_deeply \@results, ['ok'], 'got results';

# resolved already
($d, $d_out, @results) = (deferred, deferred);
$d->resolve(undef);
$d_out->resolve('ok');
$d->promise->then(sub { Thenable->new })->then(store);

is_deeply \@results, ['ok'], 'got results';


# reject
($d, $d_out, @results) = (deferred, deferred);
$d->promise->then(sub { Thenable->new })->then(undef, store);

$d->resolve(undef);
ok !scalar @results, 'no results yet';

$d_out->reject('reason');
is_deeply \@results, ['reason'], 'got rejects';

# rejected already
($d, $d_out, @results) = (deferred, deferred);
$d->resolve(undef);
$d_out->reject('reason');
$d->promise->then(sub { Thenable->new })->then(undef, store);

is_deeply \@results, ['reason'], 'got rejects';

{

  package Thenable;
  use Evo -class, -modern;
  sub then($self, $f, $r) { $f->($d_out->promise) }

}


done_testing;
