#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2005 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: simplified.pm,v 1.7 2005/03/14 22:01:19 fredo Exp $
#
#=======================================================================

$cmap->{simplified}={
    'g2u' => [
        0x0000, # G+0  U+0000  uni0000,  <control>
        0x0020, # G+1  U+0020  space,  SPACE
        0x0021, # G+2  U+0021  exclam,  EXCLAMATION MARK
        0x0022, # G+3  U+0022  quotedbl,  QUOTATION MARK
        0x0023, # G+4  U+0023  numbersign,  NUMBER SIGN
        0x0024, # G+5  U+0024  dollar,  DOLLAR SIGN
        0x0025, # G+6  U+0025  percent,  PERCENT SIGN
        0x0026, # G+7  U+0026  ampersand,  AMPERSAND
        0x0027, # G+8  U+0027  quotesingle,  APOSTROPHE
        0x0028, # G+9  U+0028  parenleft,  LEFT PARENTHESIS
        0x0029, # G+10  U+0029  parenright,  RIGHT PARENTHESIS
        0x002A, # G+11  U+002A  asterisk,  ASTERISK
        0x002B, # G+12  U+002B  plus,  PLUS SIGN
        0x002C, # G+13  U+002C  comma,  COMMA
        0x002D, # G+14  U+002D  hyphen,  HYPHEN-MINUS
        0x002E, # G+15  U+002E  period,  FULL STOP
        0x002F, # G+16  U+002F  slash,  SOLIDUS
        0x0030, # G+17  U+0030  zero,  DIGIT ZERO
        0x0031, # G+18  U+0031  one,  DIGIT ONE
        0x0032, # G+19  U+0032  two,  DIGIT TWO
        0x0033, # G+20  U+0033  three,  DIGIT THREE
        0x0034, # G+21  U+0034  four,  DIGIT FOUR
        0x0035, # G+22  U+0035  five,  DIGIT FIVE
        0x0036, # G+23  U+0036  six,  DIGIT SIX
        0x0037, # G+24  U+0037  seven,  DIGIT SEVEN
        0x0038, # G+25  U+0038  eight,  DIGIT EIGHT
        0x0039, # G+26  U+0039  nine,  DIGIT NINE
        0x003A, # G+27  U+003A  colon,  COLON
        0x003B, # G+28  U+003B  semicolon,  SEMICOLON
        0x003C, # G+29  U+003C  less,  LESS-THAN SIGN
        0x003D, # G+30  U+003D  equal,  EQUALS SIGN
        0x003E, # G+31  U+003E  greater,  GREATER-THAN SIGN
        0x003F, # G+32  U+003F  question,  QUESTION MARK
        0x0040, # G+33  U+0040  at,  COMMERCIAL AT
        0x0041, # G+34  U+0041  A,  LATIN CAPITAL LETTER A
        0x0042, # G+35  U+0042  B,  LATIN CAPITAL LETTER B
        0x0043, # G+36  U+0043  C,  LATIN CAPITAL LETTER C
        0x0044, # G+37  U+0044  D,  LATIN CAPITAL LETTER D
        0x0045, # G+38  U+0045  E,  LATIN CAPITAL LETTER E
        0x0046, # G+39  U+0046  F,  LATIN CAPITAL LETTER F
        0x0047, # G+40  U+0047  G,  LATIN CAPITAL LETTER G
        0x0048, # G+41  U+0048  H,  LATIN CAPITAL LETTER H
        0x0049, # G+42  U+0049  I,  LATIN CAPITAL LETTER I
        0x004A, # G+43  U+004A  J,  LATIN CAPITAL LETTER J
        0x004B, # G+44  U+004B  K,  LATIN CAPITAL LETTER K
        0x004C, # G+45  U+004C  L,  LATIN CAPITAL LETTER L
        0x004D, # G+46  U+004D  M,  LATIN CAPITAL LETTER M
        0x004E, # G+47  U+004E  N,  LATIN CAPITAL LETTER N
        0x004F, # G+48  U+004F  O,  LATIN CAPITAL LETTER O
        0x0050, # G+49  U+0050  P,  LATIN CAPITAL LETTER P
        0x0051, # G+50  U+0051  Q,  LATIN CAPITAL LETTER Q
        0x0052, # G+51  U+0052  R,  LATIN CAPITAL LETTER R
        0x0053, # G+52  U+0053  S,  LATIN CAPITAL LETTER S
        0x0054, # G+53  U+0054  T,  LATIN CAPITAL LETTER T
        0x0055, # G+54  U+0055  U,  LATIN CAPITAL LETTER U
        0x0056, # G+55  U+0056  V,  LATIN CAPITAL LETTER V
        0x0057, # G+56  U+0057  W,  LATIN CAPITAL LETTER W
        0x0058, # G+57  U+0058  X,  LATIN CAPITAL LETTER X
        0x0059, # G+58  U+0059  Y,  LATIN CAPITAL LETTER Y
        0x005A, # G+59  U+005A  Z,  LATIN CAPITAL LETTER Z
        0x005B, # G+60  U+005B  bracketleft,  LEFT SQUARE BRACKET
        0x005C, # G+61  U+005C  backslash,  REVERSE SOLIDUS
        0x005D, # G+62  U+005D  bracketright,  RIGHT SQUARE BRACKET
        0x005E, # G+63  U+005E  asciicircum,  CIRCUMFLEX ACCENT
        0x005F, # G+64  U+005F  underscore,  LOW LINE
        0x0060, # G+65  U+0060  grave,  GRAVE ACCENT
        0x0061, # G+66  U+0061  a,  LATIN SMALL LETTER A
        0x0062, # G+67  U+0062  b,  LATIN SMALL LETTER B
        0x0063, # G+68  U+0063  c,  LATIN SMALL LETTER C
        0x0064, # G+69  U+0064  d,  LATIN SMALL LETTER D
        0x0065, # G+70  U+0065  e,  LATIN SMALL LETTER E
        0x0066, # G+71  U+0066  f,  LATIN SMALL LETTER F
        0x0067, # G+72  U+0067  g,  LATIN SMALL LETTER G
        0x0068, # G+73  U+0068  h,  LATIN SMALL LETTER H
        0x0069, # G+74  U+0069  i,  LATIN SMALL LETTER I
        0x006A, # G+75  U+006A  j,  LATIN SMALL LETTER J
        0x006B, # G+76  U+006B  k,  LATIN SMALL LETTER K
        0x006C, # G+77  U+006C  l,  LATIN SMALL LETTER L
        0x006D, # G+78  U+006D  m,  LATIN SMALL LETTER M
        0x006E, # G+79  U+006E  n,  LATIN SMALL LETTER N
        0x006F, # G+80  U+006F  o,  LATIN SMALL LETTER O
        0x0070, # G+81  U+0070  p,  LATIN SMALL LETTER P
        0x0071, # G+82  U+0071  q,  LATIN SMALL LETTER Q
        0x0072, # G+83  U+0072  r,  LATIN SMALL LETTER R
        0x0073, # G+84  U+0073  s,  LATIN SMALL LETTER S
        0x0074, # G+85  U+0074  t,  LATIN SMALL LETTER T
        0x0075, # G+86  U+0075  u,  LATIN SMALL LETTER U
        0x0076, # G+87  U+0076  v,  LATIN SMALL LETTER V
        0x0077, # G+88  U+0077  w,  LATIN SMALL LETTER W
        0x0078, # G+89  U+0078  x,  LATIN SMALL LETTER X
        0x0079, # G+90  U+0079  y,  LATIN SMALL LETTER Y
        0x007A, # G+91  U+007A  z,  LATIN SMALL LETTER Z
        0x007B, # G+92  U+007B  braceleft,  LEFT CURLY BRACKET
        0x007C, # G+93  U+007C  bar,  VERTICAL LINE
        0x007D, # G+94  U+007D  braceright,  RIGHT CURLY BRACKET
        0x007E, # G+95  U+007E  asciitilde,  TILDE
        0x3000, # G+96  U+3000  uni3000,  IDEOGRAPHIC SPACE
        0x3001, # G+97  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+98  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0x30FB, # G+99  U+30FB  uni30FB,  KATAKANA MIDDLE DOT
        0x02C9, # G+100  U+02C9  macron,  MODIFIER LETTER MACRON
        0x02C7, # G+101  U+02C7  caron,  CARON
        0x00A8, # G+102  U+00A8  dieresis,  DIAERESIS
        0x3003, # G+103  U+3003  uni3003,  DITTO MARK
        0x3005, # G+104  U+3005  uni3005,  IDEOGRAPHIC ITERATION MARK
        0x2014, # G+105  U+2014  emdash,  EM DASH
        0xFF5E, # G+106  U+FF5E  uniFF5E,  FULLWIDTH TILDE
        0x2016, # G+107  U+2016  uni2016,  DOUBLE VERTICAL LINE
        0x2026, # G+108  U+2026  ellipsis,  HORIZONTAL ELLIPSIS
        0x2018, # G+109  U+2018  quoteleft,  LEFT SINGLE QUOTATION MARK
        0x2019, # G+110  U+2019  quoteright,  RIGHT SINGLE QUOTATION MARK
        0x201C, # G+111  U+201C  quotedblleft,  LEFT DOUBLE QUOTATION MARK
        0x201D, # G+112  U+201D  quotedblright,  RIGHT DOUBLE QUOTATION MARK
        0x3014, # G+113  U+3014  uni3014,  LEFT TORTOISE SHELL BRACKET
        0x3015, # G+114  U+3015  uni3015,  RIGHT TORTOISE SHELL BRACKET
        0x3008, # G+115  U+3008  uni3008,  LEFT ANGLE BRACKET
        0x3009, # G+116  U+3009  uni3009,  RIGHT ANGLE BRACKET
        0x300A, # G+117  U+300A  uni300A,  LEFT DOUBLE ANGLE BRACKET
        0x300B, # G+118  U+300B  uni300B,  RIGHT DOUBLE ANGLE BRACKET
        0x300C, # G+119  U+300C  uni300C,  LEFT CORNER BRACKET
        0x300D, # G+120  U+300D  uni300D,  RIGHT CORNER BRACKET
        0x300E, # G+121  U+300E  uni300E,  LEFT WHITE CORNER BRACKET
        0x300F, # G+122  U+300F  uni300F,  RIGHT WHITE CORNER BRACKET
        0x3016, # G+123  U+3016  uni3016,  LEFT WHITE LENTICULAR BRACKET
        0x3017, # G+124  U+3017  uni3017,  RIGHT WHITE LENTICULAR BRACKET
        0x3010, # G+125  U+3010  uni3010,  LEFT BLACK LENTICULAR BRACKET
        0x3011, # G+126  U+3011  uni3011,  RIGHT BLACK LENTICULAR BRACKET
        0x00B1, # G+127  U+00B1  plusminus,  PLUS-MINUS SIGN
        0x00D7, # G+128  U+00D7  multiply,  MULTIPLICATION SIGN
        0x00F7, # G+129  U+00F7  divide,  DIVISION SIGN
        0x2236, # G+130  U+2236  uni2236,  RATIO
        0x2227, # G+131  U+2227  logicaland,  LOGICAL AND
        0x2228, # G+132  U+2228  logicalor,  LOGICAL OR
        0x2211, # G+133  U+2211  summation,  N-ARY SUMMATION
        0x220F, # G+134  U+220F  product,  N-ARY PRODUCT
        0x222A, # G+135  U+222A  union,  UNION
        0x2229, # G+136  U+2229  intersection,  INTERSECTION
        0x2208, # G+137  U+2208  element,  ELEMENT OF
        0x2237, # G+138  U+2237  uni2237,  PROPORTION
        0x221A, # G+139  U+221A  radical,  SQUARE ROOT
        0x22A5, # G+140  U+22A5  perpendicular,  UP TACK
        0x2225, # G+141  U+2225  uni2225,  PARALLEL TO
        0x2220, # G+142  U+2220  angle,  ANGLE
        0x2312, # G+143  U+2312  uni2312,  ARC
        0x2299, # G+144  U+2299  uni2299,  CIRCLED DOT OPERATOR
        0x222B, # G+145  U+222B  integral,  INTEGRAL
        0x222E, # G+146  U+222E  uni222E,  CONTOUR INTEGRAL
        0x2261, # G+147  U+2261  equivalence,  IDENTICAL TO
        0x224C, # G+148  U+224C  uni224C,  ALL EQUAL TO
        0x2248, # G+149  U+2248  approxequal,  ALMOST EQUAL TO
        0x223D, # G+150  U+223D  uni223D,  REVERSED TILDE
        0x221D, # G+151  U+221D  proportional,  PROPORTIONAL TO
        0x2260, # G+152  U+2260  notequal,  NOT EQUAL TO
        0x226E, # G+153  U+226E  uni226E,  NOT LESS-THAN
        0x226F, # G+154  U+226F  uni226F,  NOT GREATER-THAN
        0x2264, # G+155  U+2264  lessequal,  LESS-THAN OR EQUAL TO
        0x2265, # G+156  U+2265  greaterequal,  GREATER-THAN OR EQUAL TO
        0x221E, # G+157  U+221E  infinity,  INFINITY
        0x2235, # G+158  U+2235  uni2235,  BECAUSE
        0x2234, # G+159  U+2234  therefore,  THEREFORE
        0x2642, # G+160  U+2642  male,  MALE SIGN
        0x2640, # G+161  U+2640  female,  FEMALE SIGN
        0x00B0, # G+162  U+00B0  degree,  DEGREE SIGN
        0x2032, # G+163  U+2032  minute,  PRIME
        0x2033, # G+164  U+2033  second,  DOUBLE PRIME
        0x2103, # G+165  U+2103  uni2103,  DEGREE CELSIUS
        0xFF04, # G+166  U+FF04  uniFF04,  FULLWIDTH DOLLAR SIGN
        0x00A4, # G+167  U+00A4  currency,  CURRENCY SIGN
        0xFFE0, # G+168  U+FFE0  uniFFE0,  FULLWIDTH CENT SIGN
        0xFFE1, # G+169  U+FFE1  uniFFE1,  FULLWIDTH POUND SIGN
        0x2030, # G+170  U+2030  perthousand,  PER MILLE SIGN
        0x00A7, # G+171  U+00A7  section,  SECTION SIGN
        0x2116, # G+172  U+2116  afii61352,  NUMERO SIGN
        0x2606, # G+173  U+2606  uni2606,  WHITE STAR
        0x2605, # G+174  U+2605  a35,  BLACK STAR
        0x25CB, # G+175  U+25CB  circle,  WHITE CIRCLE
        0x25CF, # G+176  U+25CF  H18533,  BLACK CIRCLE
        0x25CE, # G+177  U+25CE  uni25CE,  BULLSEYE
        0x25C7, # G+178  U+25C7  uni25C7,  WHITE DIAMOND
        0x25C6, # G+179  U+25C6  a78,  BLACK DIAMOND
        0x25A1, # G+180  U+25A1  H22073,  WHITE SQUARE
        0x25A0, # G+181  U+25A0  filledbox,  BLACK SQUARE
        0x25B3, # G+182  U+25B3  uni25B3,  WHITE UP-POINTING TRIANGLE
        0x25B2, # G+183  U+25B2  triagup,  BLACK UP-POINTING TRIANGLE
        0x203B, # G+184  U+203B  uni203B,  REFERENCE MARK
        0x2192, # G+185  U+2192  arrowright,  RIGHTWARDS ARROW
        0x2190, # G+186  U+2190  arrowleft,  LEFTWARDS ARROW
        0x2191, # G+187  U+2191  arrowup,  UPWARDS ARROW
        0x2193, # G+188  U+2193  arrowdown,  DOWNWARDS ARROW
        0x3013, # G+189  U+3013  uni3013,  GETA MARK
        0x2488, # G+190  U+2488  uni2488,  DIGIT ONE FULL STOP
        0x2489, # G+191  U+2489  uni2489,  DIGIT TWO FULL STOP
        0x248A, # G+192  U+248A  uni248A,  DIGIT THREE FULL STOP
        0x248B, # G+193  U+248B  uni248B,  DIGIT FOUR FULL STOP
        0x248C, # G+194  U+248C  uni248C,  DIGIT FIVE FULL STOP
        0x248D, # G+195  U+248D  uni248D,  DIGIT SIX FULL STOP
        0x248E, # G+196  U+248E  uni248E,  DIGIT SEVEN FULL STOP
        0x248F, # G+197  U+248F  uni248F,  DIGIT EIGHT FULL STOP
        0x2490, # G+198  U+2490  uni2490,  DIGIT NINE FULL STOP
        0x2491, # G+199  U+2491  uni2491,  NUMBER TEN FULL STOP
        0x2492, # G+200  U+2492  uni2492,  NUMBER ELEVEN FULL STOP
        0x2493, # G+201  U+2493  uni2493,  NUMBER TWELVE FULL STOP
        0x2494, # G+202  U+2494  uni2494,  NUMBER THIRTEEN FULL STOP
        0x2495, # G+203  U+2495  uni2495,  NUMBER FOURTEEN FULL STOP
        0x2496, # G+204  U+2496  uni2496,  NUMBER FIFTEEN FULL STOP
        0x2497, # G+205  U+2497  uni2497,  NUMBER SIXTEEN FULL STOP
        0x2498, # G+206  U+2498  uni2498,  NUMBER SEVENTEEN FULL STOP
        0x2499, # G+207  U+2499  uni2499,  NUMBER EIGHTEEN FULL STOP
        0x249A, # G+208  U+249A  uni249A,  NUMBER NINETEEN FULL STOP
        0x249B, # G+209  U+249B  uni249B,  NUMBER TWENTY FULL STOP
        0x2474, # G+210  U+2474  uni2474,  PARENTHESIZED DIGIT ONE
        0x2475, # G+211  U+2475  uni2475,  PARENTHESIZED DIGIT TWO
        0x2476, # G+212  U+2476  uni2476,  PARENTHESIZED DIGIT THREE
        0x2477, # G+213  U+2477  uni2477,  PARENTHESIZED DIGIT FOUR
        0x2478, # G+214  U+2478  uni2478,  PARENTHESIZED DIGIT FIVE
        0x2479, # G+215  U+2479  uni2479,  PARENTHESIZED DIGIT SIX
        0x247A, # G+216  U+247A  uni247A,  PARENTHESIZED DIGIT SEVEN
        0x247B, # G+217  U+247B  uni247B,  PARENTHESIZED DIGIT EIGHT
        0x247C, # G+218  U+247C  uni247C,  PARENTHESIZED DIGIT NINE
        0x247D, # G+219  U+247D  uni247D,  PARENTHESIZED NUMBER TEN
        0x247E, # G+220  U+247E  uni247E,  PARENTHESIZED NUMBER ELEVEN
        0x247F, # G+221  U+247F  uni247F,  PARENTHESIZED NUMBER TWELVE
        0x2480, # G+222  U+2480  uni2480,  PARENTHESIZED NUMBER THIRTEEN
        0x2481, # G+223  U+2481  uni2481,  PARENTHESIZED NUMBER FOURTEEN
        0x2482, # G+224  U+2482  uni2482,  PARENTHESIZED NUMBER FIFTEEN
        0x2483, # G+225  U+2483  uni2483,  PARENTHESIZED NUMBER SIXTEEN
        0x2484, # G+226  U+2484  uni2484,  PARENTHESIZED NUMBER SEVENTEEN
        0x2485, # G+227  U+2485  uni2485,  PARENTHESIZED NUMBER EIGHTEEN
        0x2486, # G+228  U+2486  uni2486,  PARENTHESIZED NUMBER NINETEEN
        0x2487, # G+229  U+2487  uni2487,  PARENTHESIZED NUMBER TWENTY
        0x2460, # G+230  U+2460  a120,  CIRCLED DIGIT ONE
        0x2461, # G+231  U+2461  a121,  CIRCLED DIGIT TWO
        0x2462, # G+232  U+2462  a122,  CIRCLED DIGIT THREE
        0x2463, # G+233  U+2463  a123,  CIRCLED DIGIT FOUR
        0x2464, # G+234  U+2464  a124,  CIRCLED DIGIT FIVE
        0x2465, # G+235  U+2465  a125,  CIRCLED DIGIT SIX
        0x2466, # G+236  U+2466  a126,  CIRCLED DIGIT SEVEN
        0x2467, # G+237  U+2467  a127,  CIRCLED DIGIT EIGHT
        0x2468, # G+238  U+2468  a128,  CIRCLED DIGIT NINE
        0x2469, # G+239  U+2469  a129,  CIRCLED NUMBER TEN
        0x3220, # G+240  U+3220  uni3220,  PARENTHESIZED IDEOGRAPH ONE
        0x3221, # G+241  U+3221  uni3221,  PARENTHESIZED IDEOGRAPH TWO
        0x3222, # G+242  U+3222  uni3222,  PARENTHESIZED IDEOGRAPH THREE
        0x3223, # G+243  U+3223  uni3223,  PARENTHESIZED IDEOGRAPH FOUR
        0x3224, # G+244  U+3224  uni3224,  PARENTHESIZED IDEOGRAPH FIVE
        0x3225, # G+245  U+3225  uni3225,  PARENTHESIZED IDEOGRAPH SIX
        0x3226, # G+246  U+3226  uni3226,  PARENTHESIZED IDEOGRAPH SEVEN
        0x3227, # G+247  U+3227  uni3227,  PARENTHESIZED IDEOGRAPH EIGHT
        0x3228, # G+248  U+3228  uni3228,  PARENTHESIZED IDEOGRAPH NINE
        0x3229, # G+249  U+3229  uni3229,  PARENTHESIZED IDEOGRAPH TEN
        0x2160, # G+250  U+2160  uni2160,  ROMAN NUMERAL ONE
        0x2161, # G+251  U+2161  uni2161,  ROMAN NUMERAL TWO
        0x2162, # G+252  U+2162  uni2162,  ROMAN NUMERAL THREE
        0x2163, # G+253  U+2163  uni2163,  ROMAN NUMERAL FOUR
        0x2164, # G+254  U+2164  uni2164,  ROMAN NUMERAL FIVE
        0x2165, # G+255  U+2165  uni2165,  ROMAN NUMERAL SIX
        0x2166, # G+256  U+2166  uni2166,  ROMAN NUMERAL SEVEN
        0x2167, # G+257  U+2167  uni2167,  ROMAN NUMERAL EIGHT
        0x2168, # G+258  U+2168  uni2168,  ROMAN NUMERAL NINE
        0x2169, # G+259  U+2169  uni2169,  ROMAN NUMERAL TEN
        0x216A, # G+260  U+216A  uni216A,  ROMAN NUMERAL ELEVEN
        0x216B, # G+261  U+216B  uni216B,  ROMAN NUMERAL TWELVE
        0xFF01, # G+262  U+FF01  uniFF01,  FULLWIDTH EXCLAMATION MARK
        0xFF02, # G+263  U+FF02  uniFF02,  FULLWIDTH QUOTATION MARK
        0xFF03, # G+264  U+FF03  uniFF03,  FULLWIDTH NUMBER SIGN
        0xFFE5, # G+265  U+FFE5  uniFFE5,  FULLWIDTH YEN SIGN
        0xFF05, # G+266  U+FF05  uniFF05,  FULLWIDTH PERCENT SIGN
        0xFF06, # G+267  U+FF06  uniFF06,  FULLWIDTH AMPERSAND
        0xFF07, # G+268  U+FF07  uniFF07,  FULLWIDTH APOSTROPHE
        0xFF08, # G+269  U+FF08  uniFF08,  FULLWIDTH LEFT PARENTHESIS
        0xFF09, # G+270  U+FF09  uniFF09,  FULLWIDTH RIGHT PARENTHESIS
        0xFF0A, # G+271  U+FF0A  uniFF0A,  FULLWIDTH ASTERISK
        0xFF0B, # G+272  U+FF0B  uniFF0B,  FULLWIDTH PLUS SIGN
        0xFF0C, # G+273  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0xFF0D, # G+274  U+FF0D  uniFF0D,  FULLWIDTH HYPHEN-MINUS
        0xFF0E, # G+275  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0xFF0F, # G+276  U+FF0F  uniFF0F,  FULLWIDTH SOLIDUS
        0xFF10, # G+277  U+FF10  uniFF10,  FULLWIDTH DIGIT ZERO
        0xFF11, # G+278  U+FF11  uniFF11,  FULLWIDTH DIGIT ONE
        0xFF12, # G+279  U+FF12  uniFF12,  FULLWIDTH DIGIT TWO
        0xFF13, # G+280  U+FF13  uniFF13,  FULLWIDTH DIGIT THREE
        0xFF14, # G+281  U+FF14  uniFF14,  FULLWIDTH DIGIT FOUR
        0xFF15, # G+282  U+FF15  uniFF15,  FULLWIDTH DIGIT FIVE
        0xFF16, # G+283  U+FF16  uniFF16,  FULLWIDTH DIGIT SIX
        0xFF17, # G+284  U+FF17  uniFF17,  FULLWIDTH DIGIT SEVEN
        0xFF18, # G+285  U+FF18  uniFF18,  FULLWIDTH DIGIT EIGHT
        0xFF19, # G+286  U+FF19  uniFF19,  FULLWIDTH DIGIT NINE
        0xFF1A, # G+287  U+FF1A  uniFF1A,  FULLWIDTH COLON
        0xFF1B, # G+288  U+FF1B  uniFF1B,  FULLWIDTH SEMICOLON
        0xFF1C, # G+289  U+FF1C  uniFF1C,  FULLWIDTH LESS-THAN SIGN
        0xFF1D, # G+290  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0xFF1E, # G+291  U+FF1E  uniFF1E,  FULLWIDTH GREATER-THAN SIGN
        0xFF1F, # G+292  U+FF1F  uniFF1F,  FULLWIDTH QUESTION MARK
        0xFF20, # G+293  U+FF20  uniFF20,  FULLWIDTH COMMERCIAL AT
        0xFF21, # G+294  U+FF21  uniFF21,  FULLWIDTH LATIN CAPITAL LETTER A
        0xFF22, # G+295  U+FF22  uniFF22,  FULLWIDTH LATIN CAPITAL LETTER B
        0xFF23, # G+296  U+FF23  uniFF23,  FULLWIDTH LATIN CAPITAL LETTER C
        0xFF24, # G+297  U+FF24  uniFF24,  FULLWIDTH LATIN CAPITAL LETTER D
        0xFF25, # G+298  U+FF25  uniFF25,  FULLWIDTH LATIN CAPITAL LETTER E
        0xFF26, # G+299  U+FF26  uniFF26,  FULLWIDTH LATIN CAPITAL LETTER F
        0xFF27, # G+300  U+FF27  uniFF27,  FULLWIDTH LATIN CAPITAL LETTER G
        0xFF28, # G+301  U+FF28  uniFF28,  FULLWIDTH LATIN CAPITAL LETTER H
        0xFF29, # G+302  U+FF29  uniFF29,  FULLWIDTH LATIN CAPITAL LETTER I
        0xFF2A, # G+303  U+FF2A  uniFF2A,  FULLWIDTH LATIN CAPITAL LETTER J
        0xFF2B, # G+304  U+FF2B  uniFF2B,  FULLWIDTH LATIN CAPITAL LETTER K
        0xFF2C, # G+305  U+FF2C  uniFF2C,  FULLWIDTH LATIN CAPITAL LETTER L
        0xFF2D, # G+306  U+FF2D  uniFF2D,  FULLWIDTH LATIN CAPITAL LETTER M
        0xFF2E, # G+307  U+FF2E  uniFF2E,  FULLWIDTH LATIN CAPITAL LETTER N
        0xFF2F, # G+308  U+FF2F  uniFF2F,  FULLWIDTH LATIN CAPITAL LETTER O
        0xFF30, # G+309  U+FF30  uniFF30,  FULLWIDTH LATIN CAPITAL LETTER P
        0xFF31, # G+310  U+FF31  uniFF31,  FULLWIDTH LATIN CAPITAL LETTER Q
        0xFF32, # G+311  U+FF32  uniFF32,  FULLWIDTH LATIN CAPITAL LETTER R
        0xFF33, # G+312  U+FF33  uniFF33,  FULLWIDTH LATIN CAPITAL LETTER S
        0xFF34, # G+313  U+FF34  uniFF34,  FULLWIDTH LATIN CAPITAL LETTER T
        0xFF35, # G+314  U+FF35  uniFF35,  FULLWIDTH LATIN CAPITAL LETTER U
        0xFF36, # G+315  U+FF36  uniFF36,  FULLWIDTH LATIN CAPITAL LETTER V
        0xFF37, # G+316  U+FF37  uniFF37,  FULLWIDTH LATIN CAPITAL LETTER W
        0xFF38, # G+317  U+FF38  uniFF38,  FULLWIDTH LATIN CAPITAL LETTER X
        0xFF39, # G+318  U+FF39  uniFF39,  FULLWIDTH LATIN CAPITAL LETTER Y
        0xFF3A, # G+319  U+FF3A  uniFF3A,  FULLWIDTH LATIN CAPITAL LETTER Z
        0xFF3B, # G+320  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3C, # G+321  U+FF3C  uniFF3C,  FULLWIDTH REVERSE SOLIDUS
        0xFF3D, # G+322  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFF3E, # G+323  U+FF3E  uniFF3E,  FULLWIDTH CIRCUMFLEX ACCENT
        0xFF3F, # G+324  U+FF3F  uniFF3F,  FULLWIDTH LOW LINE
        0xFF40, # G+325  U+FF40  uniFF40,  FULLWIDTH GRAVE ACCENT
        0xFF41, # G+326  U+FF41  uniFF41,  FULLWIDTH LATIN SMALL LETTER A
        0xFF42, # G+327  U+FF42  uniFF42,  FULLWIDTH LATIN SMALL LETTER B
        0xFF43, # G+328  U+FF43  uniFF43,  FULLWIDTH LATIN SMALL LETTER C
        0xFF44, # G+329  U+FF44  uniFF44,  FULLWIDTH LATIN SMALL LETTER D
        0xFF45, # G+330  U+FF45  uniFF45,  FULLWIDTH LATIN SMALL LETTER E
        0xFF46, # G+331  U+FF46  uniFF46,  FULLWIDTH LATIN SMALL LETTER F
        0xFF47, # G+332  U+FF47  uniFF47,  FULLWIDTH LATIN SMALL LETTER G
        0xFF48, # G+333  U+FF48  uniFF48,  FULLWIDTH LATIN SMALL LETTER H
        0xFF49, # G+334  U+FF49  uniFF49,  FULLWIDTH LATIN SMALL LETTER I
        0xFF4A, # G+335  U+FF4A  uniFF4A,  FULLWIDTH LATIN SMALL LETTER J
        0xFF4B, # G+336  U+FF4B  uniFF4B,  FULLWIDTH LATIN SMALL LETTER K
        0xFF4C, # G+337  U+FF4C  uniFF4C,  FULLWIDTH LATIN SMALL LETTER L
        0xFF4D, # G+338  U+FF4D  uniFF4D,  FULLWIDTH LATIN SMALL LETTER M
        0xFF4E, # G+339  U+FF4E  uniFF4E,  FULLWIDTH LATIN SMALL LETTER N
        0xFF4F, # G+340  U+FF4F  uniFF4F,  FULLWIDTH LATIN SMALL LETTER O
        0xFF50, # G+341  U+FF50  uniFF50,  FULLWIDTH LATIN SMALL LETTER P
        0xFF51, # G+342  U+FF51  uniFF51,  FULLWIDTH LATIN SMALL LETTER Q
        0xFF52, # G+343  U+FF52  uniFF52,  FULLWIDTH LATIN SMALL LETTER R
        0xFF53, # G+344  U+FF53  uniFF53,  FULLWIDTH LATIN SMALL LETTER S
        0xFF54, # G+345  U+FF54  uniFF54,  FULLWIDTH LATIN SMALL LETTER T
        0xFF55, # G+346  U+FF55  uniFF55,  FULLWIDTH LATIN SMALL LETTER U
        0xFF56, # G+347  U+FF56  uniFF56,  FULLWIDTH LATIN SMALL LETTER V
        0xFF57, # G+348  U+FF57  uniFF57,  FULLWIDTH LATIN SMALL LETTER W
        0xFF58, # G+349  U+FF58  uniFF58,  FULLWIDTH LATIN SMALL LETTER X
        0xFF59, # G+350  U+FF59  uniFF59,  FULLWIDTH LATIN SMALL LETTER Y
        0xFF5A, # G+351  U+FF5A  uniFF5A,  FULLWIDTH LATIN SMALL LETTER Z
        0xFF5B, # G+352  U+FF5B  uniFF5B,  FULLWIDTH LEFT CURLY BRACKET
        0xFF5C, # G+353  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0xFF5D, # G+354  U+FF5D  uniFF5D,  FULLWIDTH RIGHT CURLY BRACKET
        0xFFE3, # G+355  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0x3041, # G+356  U+3041  uni3041,  HIRAGANA LETTER SMALL A
        0x3042, # G+357  U+3042  uni3042,  HIRAGANA LETTER A
        0x3043, # G+358  U+3043  uni3043,  HIRAGANA LETTER SMALL I
        0x3044, # G+359  U+3044  uni3044,  HIRAGANA LETTER I
        0x3045, # G+360  U+3045  uni3045,  HIRAGANA LETTER SMALL U
        0x3046, # G+361  U+3046  uni3046,  HIRAGANA LETTER U
        0x3047, # G+362  U+3047  uni3047,  HIRAGANA LETTER SMALL E
        0x3048, # G+363  U+3048  uni3048,  HIRAGANA LETTER E
        0x3049, # G+364  U+3049  uni3049,  HIRAGANA LETTER SMALL O
        0x304A, # G+365  U+304A  uni304A,  HIRAGANA LETTER O
        0x304B, # G+366  U+304B  uni304B,  HIRAGANA LETTER KA
        0x304C, # G+367  U+304C  uni304C,  HIRAGANA LETTER GA
        0x304D, # G+368  U+304D  uni304D,  HIRAGANA LETTER KI
        0x304E, # G+369  U+304E  uni304E,  HIRAGANA LETTER GI
        0x304F, # G+370  U+304F  uni304F,  HIRAGANA LETTER KU
        0x3050, # G+371  U+3050  uni3050,  HIRAGANA LETTER GU
        0x3051, # G+372  U+3051  uni3051,  HIRAGANA LETTER KE
        0x3052, # G+373  U+3052  uni3052,  HIRAGANA LETTER GE
        0x3053, # G+374  U+3053  uni3053,  HIRAGANA LETTER KO
        0x3054, # G+375  U+3054  uni3054,  HIRAGANA LETTER GO
        0x3055, # G+376  U+3055  uni3055,  HIRAGANA LETTER SA
        0x3056, # G+377  U+3056  uni3056,  HIRAGANA LETTER ZA
        0x3057, # G+378  U+3057  uni3057,  HIRAGANA LETTER SI
        0x3058, # G+379  U+3058  uni3058,  HIRAGANA LETTER ZI
        0x3059, # G+380  U+3059  uni3059,  HIRAGANA LETTER SU
        0x305A, # G+381  U+305A  uni305A,  HIRAGANA LETTER ZU
        0x305B, # G+382  U+305B  uni305B,  HIRAGANA LETTER SE
        0x305C, # G+383  U+305C  uni305C,  HIRAGANA LETTER ZE
        0x305D, # G+384  U+305D  uni305D,  HIRAGANA LETTER SO
        0x305E, # G+385  U+305E  uni305E,  HIRAGANA LETTER ZO
        0x305F, # G+386  U+305F  uni305F,  HIRAGANA LETTER TA
        0x3060, # G+387  U+3060  uni3060,  HIRAGANA LETTER DA
        0x3061, # G+388  U+3061  uni3061,  HIRAGANA LETTER TI
        0x3062, # G+389  U+3062  uni3062,  HIRAGANA LETTER DI
        0x3063, # G+390  U+3063  uni3063,  HIRAGANA LETTER SMALL TU
        0x3064, # G+391  U+3064  uni3064,  HIRAGANA LETTER TU
        0x3065, # G+392  U+3065  uni3065,  HIRAGANA LETTER DU
        0x3066, # G+393  U+3066  uni3066,  HIRAGANA LETTER TE
        0x3067, # G+394  U+3067  uni3067,  HIRAGANA LETTER DE
        0x3068, # G+395  U+3068  uni3068,  HIRAGANA LETTER TO
        0x3069, # G+396  U+3069  uni3069,  HIRAGANA LETTER DO
        0x306A, # G+397  U+306A  uni306A,  HIRAGANA LETTER NA
        0x306B, # G+398  U+306B  uni306B,  HIRAGANA LETTER NI
        0x306C, # G+399  U+306C  uni306C,  HIRAGANA LETTER NU
        0x306D, # G+400  U+306D  uni306D,  HIRAGANA LETTER NE
        0x306E, # G+401  U+306E  uni306E,  HIRAGANA LETTER NO
        0x306F, # G+402  U+306F  uni306F,  HIRAGANA LETTER HA
        0x3070, # G+403  U+3070  uni3070,  HIRAGANA LETTER BA
        0x3071, # G+404  U+3071  uni3071,  HIRAGANA LETTER PA
        0x3072, # G+405  U+3072  uni3072,  HIRAGANA LETTER HI
        0x3073, # G+406  U+3073  uni3073,  HIRAGANA LETTER BI
        0x3074, # G+407  U+3074  uni3074,  HIRAGANA LETTER PI
        0x3075, # G+408  U+3075  uni3075,  HIRAGANA LETTER HU
        0x3076, # G+409  U+3076  uni3076,  HIRAGANA LETTER BU
        0x3077, # G+410  U+3077  uni3077,  HIRAGANA LETTER PU
        0x3078, # G+411  U+3078  uni3078,  HIRAGANA LETTER HE
        0x3079, # G+412  U+3079  uni3079,  HIRAGANA LETTER BE
        0x307A, # G+413  U+307A  uni307A,  HIRAGANA LETTER PE
        0x307B, # G+414  U+307B  uni307B,  HIRAGANA LETTER HO
        0x307C, # G+415  U+307C  uni307C,  HIRAGANA LETTER BO
        0x307D, # G+416  U+307D  uni307D,  HIRAGANA LETTER PO
        0x307E, # G+417  U+307E  uni307E,  HIRAGANA LETTER MA
        0x307F, # G+418  U+307F  uni307F,  HIRAGANA LETTER MI
        0x3080, # G+419  U+3080  uni3080,  HIRAGANA LETTER MU
        0x3081, # G+420  U+3081  uni3081,  HIRAGANA LETTER ME
        0x3082, # G+421  U+3082  uni3082,  HIRAGANA LETTER MO
        0x3083, # G+422  U+3083  uni3083,  HIRAGANA LETTER SMALL YA
        0x3084, # G+423  U+3084  uni3084,  HIRAGANA LETTER YA
        0x3085, # G+424  U+3085  uni3085,  HIRAGANA LETTER SMALL YU
        0x3086, # G+425  U+3086  uni3086,  HIRAGANA LETTER YU
        0x3087, # G+426  U+3087  uni3087,  HIRAGANA LETTER SMALL YO
        0x3088, # G+427  U+3088  uni3088,  HIRAGANA LETTER YO
        0x3089, # G+428  U+3089  uni3089,  HIRAGANA LETTER RA
        0x308A, # G+429  U+308A  uni308A,  HIRAGANA LETTER RI
        0x308B, # G+430  U+308B  uni308B,  HIRAGANA LETTER RU
        0x308C, # G+431  U+308C  uni308C,  HIRAGANA LETTER RE
        0x308D, # G+432  U+308D  uni308D,  HIRAGANA LETTER RO
        0x308E, # G+433  U+308E  uni308E,  HIRAGANA LETTER SMALL WA
        0x308F, # G+434  U+308F  uni308F,  HIRAGANA LETTER WA
        0x3090, # G+435  U+3090  uni3090,  HIRAGANA LETTER WI
        0x3091, # G+436  U+3091  uni3091,  HIRAGANA LETTER WE
        0x3092, # G+437  U+3092  uni3092,  HIRAGANA LETTER WO
        0x3093, # G+438  U+3093  uni3093,  HIRAGANA LETTER N
        0x30A1, # G+439  U+30A1  uni30A1,  KATAKANA LETTER SMALL A
        0x30A2, # G+440  U+30A2  uni30A2,  KATAKANA LETTER A
        0x30A3, # G+441  U+30A3  uni30A3,  KATAKANA LETTER SMALL I
        0x30A4, # G+442  U+30A4  uni30A4,  KATAKANA LETTER I
        0x30A5, # G+443  U+30A5  uni30A5,  KATAKANA LETTER SMALL U
        0x30A6, # G+444  U+30A6  uni30A6,  KATAKANA LETTER U
        0x30A7, # G+445  U+30A7  uni30A7,  KATAKANA LETTER SMALL E
        0x30A8, # G+446  U+30A8  uni30A8,  KATAKANA LETTER E
        0x30A9, # G+447  U+30A9  uni30A9,  KATAKANA LETTER SMALL O
        0x30AA, # G+448  U+30AA  uni30AA,  KATAKANA LETTER O
        0x30AB, # G+449  U+30AB  uni30AB,  KATAKANA LETTER KA
        0x30AC, # G+450  U+30AC  uni30AC,  KATAKANA LETTER GA
        0x30AD, # G+451  U+30AD  uni30AD,  KATAKANA LETTER KI
        0x30AE, # G+452  U+30AE  uni30AE,  KATAKANA LETTER GI
        0x30AF, # G+453  U+30AF  uni30AF,  KATAKANA LETTER KU
        0x30B0, # G+454  U+30B0  uni30B0,  KATAKANA LETTER GU
        0x30B1, # G+455  U+30B1  uni30B1,  KATAKANA LETTER KE
        0x30B2, # G+456  U+30B2  uni30B2,  KATAKANA LETTER GE
        0x30B3, # G+457  U+30B3  uni30B3,  KATAKANA LETTER KO
        0x30B4, # G+458  U+30B4  uni30B4,  KATAKANA LETTER GO
        0x30B5, # G+459  U+30B5  uni30B5,  KATAKANA LETTER SA
        0x30B6, # G+460  U+30B6  uni30B6,  KATAKANA LETTER ZA
        0x30B7, # G+461  U+30B7  uni30B7,  KATAKANA LETTER SI
        0x30B8, # G+462  U+30B8  uni30B8,  KATAKANA LETTER ZI
        0x30B9, # G+463  U+30B9  uni30B9,  KATAKANA LETTER SU
        0x30BA, # G+464  U+30BA  uni30BA,  KATAKANA LETTER ZU
        0x30BB, # G+465  U+30BB  uni30BB,  KATAKANA LETTER SE
        0x30BC, # G+466  U+30BC  uni30BC,  KATAKANA LETTER ZE
        0x30BD, # G+467  U+30BD  uni30BD,  KATAKANA LETTER SO
        0x30BE, # G+468  U+30BE  uni30BE,  KATAKANA LETTER ZO
        0x30BF, # G+469  U+30BF  uni30BF,  KATAKANA LETTER TA
        0x30C0, # G+470  U+30C0  uni30C0,  KATAKANA LETTER DA
        0x30C1, # G+471  U+30C1  uni30C1,  KATAKANA LETTER TI
        0x30C2, # G+472  U+30C2  uni30C2,  KATAKANA LETTER DI
        0x30C3, # G+473  U+30C3  uni30C3,  KATAKANA LETTER SMALL TU
        0x30C4, # G+474  U+30C4  uni30C4,  KATAKANA LETTER TU
        0x30C5, # G+475  U+30C5  uni30C5,  KATAKANA LETTER DU
        0x30C6, # G+476  U+30C6  uni30C6,  KATAKANA LETTER TE
        0x30C7, # G+477  U+30C7  uni30C7,  KATAKANA LETTER DE
        0x30C8, # G+478  U+30C8  uni30C8,  KATAKANA LETTER TO
        0x30C9, # G+479  U+30C9  uni30C9,  KATAKANA LETTER DO
        0x30CA, # G+480  U+30CA  uni30CA,  KATAKANA LETTER NA
        0x30CB, # G+481  U+30CB  uni30CB,  KATAKANA LETTER NI
        0x30CC, # G+482  U+30CC  uni30CC,  KATAKANA LETTER NU
        0x30CD, # G+483  U+30CD  uni30CD,  KATAKANA LETTER NE
        0x30CE, # G+484  U+30CE  uni30CE,  KATAKANA LETTER NO
        0x30CF, # G+485  U+30CF  uni30CF,  KATAKANA LETTER HA
        0x30D0, # G+486  U+30D0  uni30D0,  KATAKANA LETTER BA
        0x30D1, # G+487  U+30D1  uni30D1,  KATAKANA LETTER PA
        0x30D2, # G+488  U+30D2  uni30D2,  KATAKANA LETTER HI
        0x30D3, # G+489  U+30D3  uni30D3,  KATAKANA LETTER BI
        0x30D4, # G+490  U+30D4  uni30D4,  KATAKANA LETTER PI
        0x30D5, # G+491  U+30D5  uni30D5,  KATAKANA LETTER HU
        0x30D6, # G+492  U+30D6  uni30D6,  KATAKANA LETTER BU
        0x30D7, # G+493  U+30D7  uni30D7,  KATAKANA LETTER PU
        0x30D8, # G+494  U+30D8  uni30D8,  KATAKANA LETTER HE
        0x30D9, # G+495  U+30D9  uni30D9,  KATAKANA LETTER BE
        0x30DA, # G+496  U+30DA  uni30DA,  KATAKANA LETTER PE
        0x30DB, # G+497  U+30DB  uni30DB,  KATAKANA LETTER HO
        0x30DC, # G+498  U+30DC  uni30DC,  KATAKANA LETTER BO
        0x30DD, # G+499  U+30DD  uni30DD,  KATAKANA LETTER PO
        0x30DE, # G+500  U+30DE  uni30DE,  KATAKANA LETTER MA
        0x30DF, # G+501  U+30DF  uni30DF,  KATAKANA LETTER MI
        0x30E0, # G+502  U+30E0  uni30E0,  KATAKANA LETTER MU
        0x30E1, # G+503  U+30E1  uni30E1,  KATAKANA LETTER ME
        0x30E2, # G+504  U+30E2  uni30E2,  KATAKANA LETTER MO
        0x30E3, # G+505  U+30E3  uni30E3,  KATAKANA LETTER SMALL YA
        0x30E4, # G+506  U+30E4  uni30E4,  KATAKANA LETTER YA
        0x30E5, # G+507  U+30E5  uni30E5,  KATAKANA LETTER SMALL YU
        0x30E6, # G+508  U+30E6  uni30E6,  KATAKANA LETTER YU
        0x30E7, # G+509  U+30E7  uni30E7,  KATAKANA LETTER SMALL YO
        0x30E8, # G+510  U+30E8  uni30E8,  KATAKANA LETTER YO
        0x30E9, # G+511  U+30E9  uni30E9,  KATAKANA LETTER RA
        0x30EA, # G+512  U+30EA  uni30EA,  KATAKANA LETTER RI
        0x30EB, # G+513  U+30EB  uni30EB,  KATAKANA LETTER RU
        0x30EC, # G+514  U+30EC  uni30EC,  KATAKANA LETTER RE
        0x30ED, # G+515  U+30ED  uni30ED,  KATAKANA LETTER RO
        0x30EE, # G+516  U+30EE  uni30EE,  KATAKANA LETTER SMALL WA
        0x30EF, # G+517  U+30EF  uni30EF,  KATAKANA LETTER WA
        0x30F0, # G+518  U+30F0  uni30F0,  KATAKANA LETTER WI
        0x30F1, # G+519  U+30F1  uni30F1,  KATAKANA LETTER WE
        0x30F2, # G+520  U+30F2  uni30F2,  KATAKANA LETTER WO
        0x30F3, # G+521  U+30F3  uni30F3,  KATAKANA LETTER N
        0x30F4, # G+522  U+30F4  uni30F4,  KATAKANA LETTER VU
        0x30F5, # G+523  U+30F5  uni30F5,  KATAKANA LETTER SMALL KA
        0x30F6, # G+524  U+30F6  uni30F6,  KATAKANA LETTER SMALL KE
        0x0391, # G+525  U+0391  Alpha,  GREEK CAPITAL LETTER ALPHA
        0x0392, # G+526  U+0392  Beta,  GREEK CAPITAL LETTER BETA
        0x0393, # G+527  U+0393  Gamma,  GREEK CAPITAL LETTER GAMMA
        0x0394, # G+528  U+0394  Delta,  GREEK CAPITAL LETTER DELTA
        0x0395, # G+529  U+0395  Epsilon,  GREEK CAPITAL LETTER EPSILON
        0x0396, # G+530  U+0396  Zeta,  GREEK CAPITAL LETTER ZETA
        0x0397, # G+531  U+0397  Eta,  GREEK CAPITAL LETTER ETA
        0x0398, # G+532  U+0398  Theta,  GREEK CAPITAL LETTER THETA
        0x0399, # G+533  U+0399  Iota,  GREEK CAPITAL LETTER IOTA
        0x039A, # G+534  U+039A  Kappa,  GREEK CAPITAL LETTER KAPPA
        0x039B, # G+535  U+039B  Lambda,  GREEK CAPITAL LETTER LAMDA
        0x039C, # G+536  U+039C  Mu,  GREEK CAPITAL LETTER MU
        0x039D, # G+537  U+039D  Nu,  GREEK CAPITAL LETTER NU
        0x039E, # G+538  U+039E  Xi,  GREEK CAPITAL LETTER XI
        0x039F, # G+539  U+039F  Omicron,  GREEK CAPITAL LETTER OMICRON
        0x03A0, # G+540  U+03A0  Pi,  GREEK CAPITAL LETTER PI
        0x03A1, # G+541  U+03A1  Rho,  GREEK CAPITAL LETTER RHO
        0x03A3, # G+542  U+03A3  Sigma,  GREEK CAPITAL LETTER SIGMA
        0x03A4, # G+543  U+03A4  Tau,  GREEK CAPITAL LETTER TAU
        0x03A5, # G+544  U+03A5  Upsilon,  GREEK CAPITAL LETTER UPSILON
        0x03A6, # G+545  U+03A6  Phi,  GREEK CAPITAL LETTER PHI
        0x03A7, # G+546  U+03A7  Chi,  GREEK CAPITAL LETTER CHI
        0x03A8, # G+547  U+03A8  Psi,  GREEK CAPITAL LETTER PSI
        0x03A9, # G+548  U+03A9  Omega,  GREEK CAPITAL LETTER OMEGA
        0x03B1, # G+549  U+03B1  alpha,  GREEK SMALL LETTER ALPHA
        0x03B2, # G+550  U+03B2  beta,  GREEK SMALL LETTER BETA
        0x03B3, # G+551  U+03B3  gamma,  GREEK SMALL LETTER GAMMA
        0x03B4, # G+552  U+03B4  delta,  GREEK SMALL LETTER DELTA
        0x03B5, # G+553  U+03B5  epsilon,  GREEK SMALL LETTER EPSILON
        0x03B6, # G+554  U+03B6  zeta,  GREEK SMALL LETTER ZETA
        0x03B7, # G+555  U+03B7  eta,  GREEK SMALL LETTER ETA
        0x03B8, # G+556  U+03B8  theta,  GREEK SMALL LETTER THETA
        0x03B9, # G+557  U+03B9  iota,  GREEK SMALL LETTER IOTA
        0x03BA, # G+558  U+03BA  kappa,  GREEK SMALL LETTER KAPPA
        0x03BB, # G+559  U+03BB  lambda,  GREEK SMALL LETTER LAMDA
        0x03BC, # G+560  U+03BC  mu,  GREEK SMALL LETTER MU
        0x03BD, # G+561  U+03BD  nu,  GREEK SMALL LETTER NU
        0x03BE, # G+562  U+03BE  xi,  GREEK SMALL LETTER XI
        0x03BF, # G+563  U+03BF  omicron,  GREEK SMALL LETTER OMICRON
        0x03C0, # G+564  U+03C0  pi,  GREEK SMALL LETTER PI
        0x03C1, # G+565  U+03C1  rho,  GREEK SMALL LETTER RHO
        0x03C3, # G+566  U+03C3  sigma,  GREEK SMALL LETTER SIGMA
        0x03C4, # G+567  U+03C4  tau,  GREEK SMALL LETTER TAU
        0x03C5, # G+568  U+03C5  upsilon,  GREEK SMALL LETTER UPSILON
        0x03C6, # G+569  U+03C6  phi,  GREEK SMALL LETTER PHI
        0x03C7, # G+570  U+03C7  chi,  GREEK SMALL LETTER CHI
        0x03C8, # G+571  U+03C8  psi,  GREEK SMALL LETTER PSI
        0x03C9, # G+572  U+03C9  omega,  GREEK SMALL LETTER OMEGA
        0xE78D, # G+573  U+E78D  uniE78D,  
        0xE78E, # G+574  U+E78E  uniE78E,  
        0xE78F, # G+575  U+E78F  uniE78F,  
        0xE790, # G+576  U+E790  uniE790,  
        0xE791, # G+577  U+E791  uniE791,  
        0xE792, # G+578  U+E792  uniE792,  
        0xE793, # G+579  U+E793  uniE793,  
        0xFE35, # G+580  U+FE35  uniFE35,  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
        0xFE36, # G+581  U+FE36  uniFE36,  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
        0xFE39, # G+582  U+FE39  uniFE39,  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
        0xFE3A, # G+583  U+FE3A  uniFE3A,  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
        0xFE3F, # G+584  U+FE3F  uniFE3F,  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
        0xFE40, # G+585  U+FE40  uniFE40,  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
        0xFE3D, # G+586  U+FE3D  uniFE3D,  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
        0xFE3E, # G+587  U+FE3E  uniFE3E,  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
        0xFE41, # G+588  U+FE41  uniFE41,  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
        0xFE42, # G+589  U+FE42  uniFE42,  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
        0xFE43, # G+590  U+FE43  uniFE43,  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
        0xFE44, # G+591  U+FE44  uniFE44,  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
        0xE794, # G+592  U+E794  uniE794,  
        0xE795, # G+593  U+E795  uniE795,  
        0xFE3B, # G+594  U+FE3B  uniFE3B,  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
        0xFE3C, # G+595  U+FE3C  uniFE3C,  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
        0xFE37, # G+596  U+FE37  uniFE37,  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
        0xFE38, # G+597  U+FE38  uniFE38,  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
        0xFE31, # G+598  U+FE31  uniFE31,  PRESENTATION FORM FOR VERTICAL EM DASH
        0xE796, # G+599  U+E796  uniE796,  
        0xFE33, # G+600  U+FE33  uniFE33,  PRESENTATION FORM FOR VERTICAL LOW LINE
        0xFE34, # G+601  U+FE34  uniFE34,  PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
        0x0410, # G+602  U+0410  afii10017,  CYRILLIC CAPITAL LETTER A
        0x0411, # G+603  U+0411  afii10018,  CYRILLIC CAPITAL LETTER BE
        0x0412, # G+604  U+0412  afii10019,  CYRILLIC CAPITAL LETTER VE
        0x0413, # G+605  U+0413  afii10020,  CYRILLIC CAPITAL LETTER GHE
        0x0414, # G+606  U+0414  afii10021,  CYRILLIC CAPITAL LETTER DE
        0x0415, # G+607  U+0415  afii10022,  CYRILLIC CAPITAL LETTER IE
        0x0401, # G+608  U+0401  afii10023,  CYRILLIC CAPITAL LETTER IO
        0x0416, # G+609  U+0416  afii10024,  CYRILLIC CAPITAL LETTER ZHE
        0x0417, # G+610  U+0417  afii10025,  CYRILLIC CAPITAL LETTER ZE
        0x0418, # G+611  U+0418  afii10026,  CYRILLIC CAPITAL LETTER I
        0x0419, # G+612  U+0419  afii10027,  CYRILLIC CAPITAL LETTER SHORT I
        0x041A, # G+613  U+041A  afii10028,  CYRILLIC CAPITAL LETTER KA
        0x041B, # G+614  U+041B  afii10029,  CYRILLIC CAPITAL LETTER EL
        0x041C, # G+615  U+041C  afii10030,  CYRILLIC CAPITAL LETTER EM
        0x041D, # G+616  U+041D  afii10031,  CYRILLIC CAPITAL LETTER EN
        0x041E, # G+617  U+041E  afii10032,  CYRILLIC CAPITAL LETTER O
        0x041F, # G+618  U+041F  afii10033,  CYRILLIC CAPITAL LETTER PE
        0x0420, # G+619  U+0420  afii10034,  CYRILLIC CAPITAL LETTER ER
        0x0421, # G+620  U+0421  afii10035,  CYRILLIC CAPITAL LETTER ES
        0x0422, # G+621  U+0422  afii10036,  CYRILLIC CAPITAL LETTER TE
        0x0423, # G+622  U+0423  afii10037,  CYRILLIC CAPITAL LETTER U
        0x0424, # G+623  U+0424  afii10038,  CYRILLIC CAPITAL LETTER EF
        0x0425, # G+624  U+0425  afii10039,  CYRILLIC CAPITAL LETTER HA
        0x0426, # G+625  U+0426  afii10040,  CYRILLIC CAPITAL LETTER TSE
        0x0427, # G+626  U+0427  afii10041,  CYRILLIC CAPITAL LETTER CHE
        0x0428, # G+627  U+0428  afii10042,  CYRILLIC CAPITAL LETTER SHA
        0x0429, # G+628  U+0429  afii10043,  CYRILLIC CAPITAL LETTER SHCHA
        0x042A, # G+629  U+042A  afii10044,  CYRILLIC CAPITAL LETTER HARD SIGN
        0x042B, # G+630  U+042B  afii10045,  CYRILLIC CAPITAL LETTER YERU
        0x042C, # G+631  U+042C  afii10046,  CYRILLIC CAPITAL LETTER SOFT SIGN
        0x042D, # G+632  U+042D  afii10047,  CYRILLIC CAPITAL LETTER E
        0x042E, # G+633  U+042E  afii10048,  CYRILLIC CAPITAL LETTER YU
        0x042F, # G+634  U+042F  afii10049,  CYRILLIC CAPITAL LETTER YA
        0x0430, # G+635  U+0430  afii10065,  CYRILLIC SMALL LETTER A
        0x0431, # G+636  U+0431  afii10066,  CYRILLIC SMALL LETTER BE
        0x0432, # G+637  U+0432  afii10067,  CYRILLIC SMALL LETTER VE
        0x0433, # G+638  U+0433  afii10068,  CYRILLIC SMALL LETTER GHE
        0x0434, # G+639  U+0434  afii10069,  CYRILLIC SMALL LETTER DE
        0x0435, # G+640  U+0435  afii10070,  CYRILLIC SMALL LETTER IE
        0x0451, # G+641  U+0451  afii10071,  CYRILLIC SMALL LETTER IO
        0x0436, # G+642  U+0436  afii10072,  CYRILLIC SMALL LETTER ZHE
        0x0437, # G+643  U+0437  afii10073,  CYRILLIC SMALL LETTER ZE
        0x0438, # G+644  U+0438  afii10074,  CYRILLIC SMALL LETTER I
        0x0439, # G+645  U+0439  afii10075,  CYRILLIC SMALL LETTER SHORT I
        0x043A, # G+646  U+043A  afii10076,  CYRILLIC SMALL LETTER KA
        0x043B, # G+647  U+043B  afii10077,  CYRILLIC SMALL LETTER EL
        0x043C, # G+648  U+043C  afii10078,  CYRILLIC SMALL LETTER EM
        0x043D, # G+649  U+043D  afii10079,  CYRILLIC SMALL LETTER EN
        0x043E, # G+650  U+043E  afii10080,  CYRILLIC SMALL LETTER O
        0x043F, # G+651  U+043F  afii10081,  CYRILLIC SMALL LETTER PE
        0x0440, # G+652  U+0440  afii10082,  CYRILLIC SMALL LETTER ER
        0x0441, # G+653  U+0441  afii10083,  CYRILLIC SMALL LETTER ES
        0x0442, # G+654  U+0442  afii10084,  CYRILLIC SMALL LETTER TE
        0x0443, # G+655  U+0443  afii10085,  CYRILLIC SMALL LETTER U
        0x0444, # G+656  U+0444  afii10086,  CYRILLIC SMALL LETTER EF
        0x0445, # G+657  U+0445  afii10087,  CYRILLIC SMALL LETTER HA
        0x0446, # G+658  U+0446  afii10088,  CYRILLIC SMALL LETTER TSE
        0x0447, # G+659  U+0447  afii10089,  CYRILLIC SMALL LETTER CHE
        0x0448, # G+660  U+0448  afii10090,  CYRILLIC SMALL LETTER SHA
        0x0449, # G+661  U+0449  afii10091,  CYRILLIC SMALL LETTER SHCHA
        0x044A, # G+662  U+044A  afii10092,  CYRILLIC SMALL LETTER HARD SIGN
        0x044B, # G+663  U+044B  afii10093,  CYRILLIC SMALL LETTER YERU
        0x044C, # G+664  U+044C  afii10094,  CYRILLIC SMALL LETTER SOFT SIGN
        0x044D, # G+665  U+044D  afii10095,  CYRILLIC SMALL LETTER E
        0x044E, # G+666  U+044E  afii10096,  CYRILLIC SMALL LETTER YU
        0x044F, # G+667  U+044F  afii10097,  CYRILLIC SMALL LETTER YA
        0x0101, # G+668  U+0101  amacron,  LATIN SMALL LETTER A WITH MACRON
        0x00E1, # G+669  U+00E1  aacute,  LATIN SMALL LETTER A WITH ACUTE
        0x01CE, # G+670  U+01CE  uni01CE,  LATIN SMALL LETTER A WITH CARON
        0x00E0, # G+671  U+00E0  agrave,  LATIN SMALL LETTER A WITH GRAVE
        0x0113, # G+672  U+0113  emacron,  LATIN SMALL LETTER E WITH MACRON
        0x00E9, # G+673  U+00E9  eacute,  LATIN SMALL LETTER E WITH ACUTE
        0x011B, # G+674  U+011B  ecaron,  LATIN SMALL LETTER E WITH CARON
        0x00E8, # G+675  U+00E8  egrave,  LATIN SMALL LETTER E WITH GRAVE
        0x012B, # G+676  U+012B  imacron,  LATIN SMALL LETTER I WITH MACRON
        0x00ED, # G+677  U+00ED  iacute,  LATIN SMALL LETTER I WITH ACUTE
        0x01D0, # G+678  U+01D0  uni01D0,  LATIN SMALL LETTER I WITH CARON
        0x00EC, # G+679  U+00EC  igrave,  LATIN SMALL LETTER I WITH GRAVE
        0x014D, # G+680  U+014D  omacron,  LATIN SMALL LETTER O WITH MACRON
        0x00F3, # G+681  U+00F3  oacute,  LATIN SMALL LETTER O WITH ACUTE
        0x01D2, # G+682  U+01D2  uni01D2,  LATIN SMALL LETTER O WITH CARON
        0x00F2, # G+683  U+00F2  ograve,  LATIN SMALL LETTER O WITH GRAVE
        0x016B, # G+684  U+016B  umacron,  LATIN SMALL LETTER U WITH MACRON
        0x00FA, # G+685  U+00FA  uacute,  LATIN SMALL LETTER U WITH ACUTE
        0x01D4, # G+686  U+01D4  uni01D4,  LATIN SMALL LETTER U WITH CARON
        0x00F9, # G+687  U+00F9  ugrave,  LATIN SMALL LETTER U WITH GRAVE
        0x01D6, # G+688  U+01D6  uni01D6,  LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
        0x01D8, # G+689  U+01D8  uni01D8,  LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
        0x01DA, # G+690  U+01DA  uni01DA,  LATIN SMALL LETTER U WITH DIAERESIS AND CARON
        0x01DC, # G+691  U+01DC  uni01DC,  LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
        0x00FC, # G+692  U+00FC  udieresis,  LATIN SMALL LETTER U WITH DIAERESIS
        0x00EA, # G+693  U+00EA  ecircumflex,  LATIN SMALL LETTER E WITH CIRCUMFLEX
        0x0251, # G+694  U+0251  uni0251,  LATIN SMALL LETTER ALPHA
        0x1E3F, # G+695  U+1E3F  uni1E3F,  LATIN SMALL LETTER M WITH ACUTE
        0x0144, # G+696  U+0144  nacute,  LATIN SMALL LETTER N WITH ACUTE
        0x0148, # G+697  U+0148  ncaron,  LATIN SMALL LETTER N WITH CARON
        0x01F9, # G+698  U+01F9  uni01F9,  LATIN SMALL LETTER N WITH GRAVE
        0x0261, # G+699  U+0261  uni0261,  LATIN SMALL LETTER SCRIPT G
        0x3105, # G+700  U+3105  uni3105,  BOPOMOFO LETTER B
        0x3106, # G+701  U+3106  uni3106,  BOPOMOFO LETTER P
        0x3107, # G+702  U+3107  uni3107,  BOPOMOFO LETTER M
        0x3108, # G+703  U+3108  uni3108,  BOPOMOFO LETTER F
        0x3109, # G+704  U+3109  uni3109,  BOPOMOFO LETTER D
        0x310A, # G+705  U+310A  uni310A,  BOPOMOFO LETTER T
        0x310B, # G+706  U+310B  uni310B,  BOPOMOFO LETTER N
        0x310C, # G+707  U+310C  uni310C,  BOPOMOFO LETTER L
        0x310D, # G+708  U+310D  uni310D,  BOPOMOFO LETTER G
        0x310E, # G+709  U+310E  uni310E,  BOPOMOFO LETTER K
        0x310F, # G+710  U+310F  uni310F,  BOPOMOFO LETTER H
        0x3110, # G+711  U+3110  uni3110,  BOPOMOFO LETTER J
        0x3111, # G+712  U+3111  uni3111,  BOPOMOFO LETTER Q
        0x3112, # G+713  U+3112  uni3112,  BOPOMOFO LETTER X
        0x3113, # G+714  U+3113  uni3113,  BOPOMOFO LETTER ZH
        0x3114, # G+715  U+3114  uni3114,  BOPOMOFO LETTER CH
        0x3115, # G+716  U+3115  uni3115,  BOPOMOFO LETTER SH
        0x3116, # G+717  U+3116  uni3116,  BOPOMOFO LETTER R
        0x3117, # G+718  U+3117  uni3117,  BOPOMOFO LETTER Z
        0x3118, # G+719  U+3118  uni3118,  BOPOMOFO LETTER C
        0x3119, # G+720  U+3119  uni3119,  BOPOMOFO LETTER S
        0x311A, # G+721  U+311A  uni311A,  BOPOMOFO LETTER A
        0x311B, # G+722  U+311B  uni311B,  BOPOMOFO LETTER O
        0x311C, # G+723  U+311C  uni311C,  BOPOMOFO LETTER E
        0x311D, # G+724  U+311D  uni311D,  BOPOMOFO LETTER EH
        0x311E, # G+725  U+311E  uni311E,  BOPOMOFO LETTER AI
        0x311F, # G+726  U+311F  uni311F,  BOPOMOFO LETTER EI
        0x3120, # G+727  U+3120  uni3120,  BOPOMOFO LETTER AU
        0x3121, # G+728  U+3121  uni3121,  BOPOMOFO LETTER OU
        0x3122, # G+729  U+3122  uni3122,  BOPOMOFO LETTER AN
        0x3123, # G+730  U+3123  uni3123,  BOPOMOFO LETTER EN
        0x3124, # G+731  U+3124  uni3124,  BOPOMOFO LETTER ANG
        0x3125, # G+732  U+3125  uni3125,  BOPOMOFO LETTER ENG
        0x3126, # G+733  U+3126  uni3126,  BOPOMOFO LETTER ER
        0x3127, # G+734  U+3127  uni3127,  BOPOMOFO LETTER I
        0x3128, # G+735  U+3128  uni3128,  BOPOMOFO LETTER U
        0x3129, # G+736  U+3129  uni3129,  BOPOMOFO LETTER IU
        0x0000, # G+737  U+0000  .notdef,  UNDEFINED
        0x2500, # G+738  U+2500  SF100000,  BOX DRAWINGS LIGHT HORIZONTAL
        0x2501, # G+739  U+2501  uni2501,  BOX DRAWINGS HEAVY HORIZONTAL
        0x2502, # G+740  U+2502  SF110000,  BOX DRAWINGS LIGHT VERTICAL
        0x2503, # G+741  U+2503  uni2503,  BOX DRAWINGS HEAVY VERTICAL
        0x2504, # G+742  U+2504  uni2504,  BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
        0x2505, # G+743  U+2505  uni2505,  BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
        0x2506, # G+744  U+2506  uni2506,  BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
        0x2507, # G+745  U+2507  uni2507,  BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
        0x2508, # G+746  U+2508  uni2508,  BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
        0x2509, # G+747  U+2509  uni2509,  BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
        0x250A, # G+748  U+250A  uni250A,  BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
        0x250B, # G+749  U+250B  uni250B,  BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
        0x250C, # G+750  U+250C  SF010000,  BOX DRAWINGS LIGHT DOWN AND RIGHT
        0x250D, # G+751  U+250D  uni250D,  BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
        0x250E, # G+752  U+250E  uni250E,  BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
        0x250F, # G+753  U+250F  uni250F,  BOX DRAWINGS HEAVY DOWN AND RIGHT
        0x2510, # G+754  U+2510  SF030000,  BOX DRAWINGS LIGHT DOWN AND LEFT
        0x2511, # G+755  U+2511  uni2511,  BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
        0x2512, # G+756  U+2512  uni2512,  BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
        0x2513, # G+757  U+2513  uni2513,  BOX DRAWINGS HEAVY DOWN AND LEFT
        0x2514, # G+758  U+2514  SF020000,  BOX DRAWINGS LIGHT UP AND RIGHT
        0x2515, # G+759  U+2515  uni2515,  BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
        0x2516, # G+760  U+2516  uni2516,  BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
        0x2517, # G+761  U+2517  uni2517,  BOX DRAWINGS HEAVY UP AND RIGHT
        0x2518, # G+762  U+2518  SF040000,  BOX DRAWINGS LIGHT UP AND LEFT
        0x2519, # G+763  U+2519  uni2519,  BOX DRAWINGS UP LIGHT AND LEFT HEAVY
        0x251A, # G+764  U+251A  uni251A,  BOX DRAWINGS UP HEAVY AND LEFT LIGHT
        0x251B, # G+765  U+251B  uni251B,  BOX DRAWINGS HEAVY UP AND LEFT
        0x251C, # G+766  U+251C  SF080000,  BOX DRAWINGS LIGHT VERTICAL AND RIGHT
        0x251D, # G+767  U+251D  uni251D,  BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
        0x251E, # G+768  U+251E  uni251E,  BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
        0x251F, # G+769  U+251F  uni251F,  BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
        0x2520, # G+770  U+2520  uni2520,  BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
        0x2521, # G+771  U+2521  uni2521,  BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
        0x2522, # G+772  U+2522  uni2522,  BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
        0x2523, # G+773  U+2523  uni2523,  BOX DRAWINGS HEAVY VERTICAL AND RIGHT
        0x2524, # G+774  U+2524  SF090000,  BOX DRAWINGS LIGHT VERTICAL AND LEFT
        0x2525, # G+775  U+2525  uni2525,  BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
        0x2526, # G+776  U+2526  uni2526,  BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
        0x2527, # G+777  U+2527  uni2527,  BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
        0x2528, # G+778  U+2528  uni2528,  BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
        0x2529, # G+779  U+2529  uni2529,  BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
        0x252A, # G+780  U+252A  uni252A,  BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
        0x252B, # G+781  U+252B  uni252B,  BOX DRAWINGS HEAVY VERTICAL AND LEFT
        0x252C, # G+782  U+252C  SF060000,  BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
        0x252D, # G+783  U+252D  uni252D,  BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
        0x252E, # G+784  U+252E  uni252E,  BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
        0x252F, # G+785  U+252F  uni252F,  BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
        0x2530, # G+786  U+2530  uni2530,  BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
        0x2531, # G+787  U+2531  uni2531,  BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
        0x2532, # G+788  U+2532  uni2532,  BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
        0x2533, # G+789  U+2533  uni2533,  BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
        0x2534, # G+790  U+2534  SF070000,  BOX DRAWINGS LIGHT UP AND HORIZONTAL
        0x2535, # G+791  U+2535  uni2535,  BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
        0x2536, # G+792  U+2536  uni2536,  BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
        0x2537, # G+793  U+2537  uni2537,  BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
        0x2538, # G+794  U+2538  uni2538,  BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
        0x2539, # G+795  U+2539  uni2539,  BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
        0x253A, # G+796  U+253A  uni253A,  BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
        0x253B, # G+797  U+253B  uni253B,  BOX DRAWINGS HEAVY UP AND HORIZONTAL
        0x253C, # G+798  U+253C  SF050000,  BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
        0x253D, # G+799  U+253D  uni253D,  BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
        0x253E, # G+800  U+253E  uni253E,  BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
        0x253F, # G+801  U+253F  uni253F,  BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
        0x2540, # G+802  U+2540  uni2540,  BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
        0x2541, # G+803  U+2541  uni2541,  BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
        0x2542, # G+804  U+2542  uni2542,  BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
        0x2543, # G+805  U+2543  uni2543,  BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
        0x2544, # G+806  U+2544  uni2544,  BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
        0x2545, # G+807  U+2545  uni2545,  BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
        0x2546, # G+808  U+2546  uni2546,  BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
        0x2547, # G+809  U+2547  uni2547,  BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
        0x2548, # G+810  U+2548  uni2548,  BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
        0x2549, # G+811  U+2549  uni2549,  BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
        0x254A, # G+812  U+254A  uni254A,  BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
        0x254B, # G+813  U+254B  uni254B,  BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
        0x0000, # G+814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+897  U+0000  .notdef,  UNDEFINED
        0x0000, # G+898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+939  U+0000  .notdef,  UNDEFINED
        0x554A, # G+940  U+554A  uni554A,  CJK UNIFIED IDEOGRAPH-554A
        0x963F, # G+941  U+963F  uni963F,  CJK UNIFIED IDEOGRAPH-963F
        0x57C3, # G+942  U+57C3  uni57C3,  CJK UNIFIED IDEOGRAPH-57C3
        0x6328, # G+943  U+6328  uni6328,  CJK UNIFIED IDEOGRAPH-6328
        0x54CE, # G+944  U+54CE  uni54CE,  CJK UNIFIED IDEOGRAPH-54CE
        0x5509, # G+945  U+5509  uni5509,  CJK UNIFIED IDEOGRAPH-5509
        0x54C0, # G+946  U+54C0  uni54C0,  CJK UNIFIED IDEOGRAPH-54C0
        0x7691, # G+947  U+7691  uni7691,  CJK UNIFIED IDEOGRAPH-7691
        0x764C, # G+948  U+764C  uni764C,  CJK UNIFIED IDEOGRAPH-764C
        0x853C, # G+949  U+853C  uni853C,  CJK UNIFIED IDEOGRAPH-853C
        0x77EE, # G+950  U+77EE  uni77EE,  CJK UNIFIED IDEOGRAPH-77EE
        0x827E, # G+951  U+827E  uni827E,  CJK UNIFIED IDEOGRAPH-827E
        0x788D, # G+952  U+788D  uni788D,  CJK UNIFIED IDEOGRAPH-788D
        0x7231, # G+953  U+7231  uni7231,  CJK UNIFIED IDEOGRAPH-7231
        0x9698, # G+954  U+9698  uni9698,  CJK UNIFIED IDEOGRAPH-9698
        0x978D, # G+955  U+978D  uni978D,  CJK UNIFIED IDEOGRAPH-978D
        0x6C28, # G+956  U+6C28  uni6C28,  CJK UNIFIED IDEOGRAPH-6C28
        0x5B89, # G+957  U+5B89  uni5B89,  CJK UNIFIED IDEOGRAPH-5B89
        0x4FFA, # G+958  U+4FFA  uni4FFA,  CJK UNIFIED IDEOGRAPH-4FFA
        0x6309, # G+959  U+6309  uni6309,  CJK UNIFIED IDEOGRAPH-6309
        0x6697, # G+960  U+6697  uni6697,  CJK UNIFIED IDEOGRAPH-6697
        0x5CB8, # G+961  U+5CB8  uni5CB8,  CJK UNIFIED IDEOGRAPH-5CB8
        0x80FA, # G+962  U+80FA  uni80FA,  CJK UNIFIED IDEOGRAPH-80FA
        0x6848, # G+963  U+6848  uni6848,  CJK UNIFIED IDEOGRAPH-6848
        0x80AE, # G+964  U+80AE  uni80AE,  CJK UNIFIED IDEOGRAPH-80AE
        0x6602, # G+965  U+6602  uni6602,  CJK UNIFIED IDEOGRAPH-6602
        0x76CE, # G+966  U+76CE  uni76CE,  CJK UNIFIED IDEOGRAPH-76CE
        0x51F9, # G+967  U+51F9  uni51F9,  CJK UNIFIED IDEOGRAPH-51F9
        0x6556, # G+968  U+6556  uni6556,  CJK UNIFIED IDEOGRAPH-6556
        0x71AC, # G+969  U+71AC  uni71AC,  CJK UNIFIED IDEOGRAPH-71AC
        0x7FF1, # G+970  U+7FF1  uni7FF1,  CJK UNIFIED IDEOGRAPH-7FF1
        0x8884, # G+971  U+8884  uni8884,  CJK UNIFIED IDEOGRAPH-8884
        0x50B2, # G+972  U+50B2  uni50B2,  CJK UNIFIED IDEOGRAPH-50B2
        0x5965, # G+973  U+5965  uni5965,  CJK UNIFIED IDEOGRAPH-5965
        0x61CA, # G+974  U+61CA  uni61CA,  CJK UNIFIED IDEOGRAPH-61CA
        0x6FB3, # G+975  U+6FB3  uni6FB3,  CJK UNIFIED IDEOGRAPH-6FB3
        0x82AD, # G+976  U+82AD  uni82AD,  CJK UNIFIED IDEOGRAPH-82AD
        0x634C, # G+977  U+634C  uni634C,  CJK UNIFIED IDEOGRAPH-634C
        0x6252, # G+978  U+6252  uni6252,  CJK UNIFIED IDEOGRAPH-6252
        0x53ED, # G+979  U+53ED  uni53ED,  CJK UNIFIED IDEOGRAPH-53ED
        0x5427, # G+980  U+5427  uni5427,  CJK UNIFIED IDEOGRAPH-5427
        0x7B06, # G+981  U+7B06  uni7B06,  CJK UNIFIED IDEOGRAPH-7B06
        0x2F0B, # G+982  U+2F0B  uni2F0B,  KANGXI RADICAL EIGHT
        0x75A4, # G+983  U+75A4  uni75A4,  CJK UNIFIED IDEOGRAPH-75A4
        0x5DF4, # G+984  U+5DF4  uni5DF4,  CJK UNIFIED IDEOGRAPH-5DF4
        0x62D4, # G+985  U+62D4  uni62D4,  CJK UNIFIED IDEOGRAPH-62D4
        0x8DCB, # G+986  U+8DCB  uni8DCB,  CJK UNIFIED IDEOGRAPH-8DCB
        0x9776, # G+987  U+9776  uni9776,  CJK UNIFIED IDEOGRAPH-9776
        0x628A, # G+988  U+628A  uni628A,  CJK UNIFIED IDEOGRAPH-628A
        0x8019, # G+989  U+8019  uni8019,  CJK UNIFIED IDEOGRAPH-8019
        0x575D, # G+990  U+575D  uni575D,  CJK UNIFIED IDEOGRAPH-575D
        0x9738, # G+991  U+9738  uni9738,  CJK UNIFIED IDEOGRAPH-9738
        0x7F62, # G+992  U+7F62  uni7F62,  CJK UNIFIED IDEOGRAPH-7F62
        0x7238, # G+993  U+7238  uni7238,  CJK UNIFIED IDEOGRAPH-7238
        0x2F69, # G+994  U+2F69  uni2F69,  KANGXI RADICAL WHITE
        0x67CF, # G+995  U+67CF  uni67CF,  CJK UNIFIED IDEOGRAPH-67CF
        0x767E, # G+996  U+767E  uni767E,  CJK UNIFIED IDEOGRAPH-767E
        0x6446, # G+997  U+6446  uni6446,  CJK UNIFIED IDEOGRAPH-6446
        0x4F70, # G+998  U+4F70  uni4F70,  CJK UNIFIED IDEOGRAPH-4F70
        0x8D25, # G+999  U+8D25  uni8D25,  CJK UNIFIED IDEOGRAPH-8D25
        0x62DC, # G+1000  U+62DC  uni62DC,  CJK UNIFIED IDEOGRAPH-62DC
        0x7A17, # G+1001  U+7A17  uni7A17,  CJK UNIFIED IDEOGRAPH-7A17
        0x6591, # G+1002  U+6591  uni6591,  CJK UNIFIED IDEOGRAPH-6591
        0x73ED, # G+1003  U+73ED  uni73ED,  CJK UNIFIED IDEOGRAPH-73ED
        0x642C, # G+1004  U+642C  uni642C,  CJK UNIFIED IDEOGRAPH-642C
        0x6273, # G+1005  U+6273  uni6273,  CJK UNIFIED IDEOGRAPH-6273
        0x822C, # G+1006  U+822C  uni822C,  CJK UNIFIED IDEOGRAPH-822C
        0x9881, # G+1007  U+9881  uni9881,  CJK UNIFIED IDEOGRAPH-9881
        0x677F, # G+1008  U+677F  uni677F,  CJK UNIFIED IDEOGRAPH-677F
        0x7248, # G+1009  U+7248  uni7248,  CJK UNIFIED IDEOGRAPH-7248
        0x626E, # G+1010  U+626E  uni626E,  CJK UNIFIED IDEOGRAPH-626E
        0x62CC, # G+1011  U+62CC  uni62CC,  CJK UNIFIED IDEOGRAPH-62CC
        0x4F34, # G+1012  U+4F34  uni4F34,  CJK UNIFIED IDEOGRAPH-4F34
        0x74E3, # G+1013  U+74E3  uni74E3,  CJK UNIFIED IDEOGRAPH-74E3
        0x534A, # G+1014  U+534A  uni534A,  CJK UNIFIED IDEOGRAPH-534A
        0x529E, # G+1015  U+529E  uni529E,  CJK UNIFIED IDEOGRAPH-529E
        0x7ECA, # G+1016  U+7ECA  uni7ECA,  CJK UNIFIED IDEOGRAPH-7ECA
        0x90A6, # G+1017  U+90A6  uni90A6,  CJK UNIFIED IDEOGRAPH-90A6
        0x5E2E, # G+1018  U+5E2E  uni5E2E,  CJK UNIFIED IDEOGRAPH-5E2E
        0x6886, # G+1019  U+6886  uni6886,  CJK UNIFIED IDEOGRAPH-6886
        0x699C, # G+1020  U+699C  uni699C,  CJK UNIFIED IDEOGRAPH-699C
        0x8180, # G+1021  U+8180  uni8180,  CJK UNIFIED IDEOGRAPH-8180
        0x7ED1, # G+1022  U+7ED1  uni7ED1,  CJK UNIFIED IDEOGRAPH-7ED1
        0x68D2, # G+1023  U+68D2  uni68D2,  CJK UNIFIED IDEOGRAPH-68D2
        0x78C5, # G+1024  U+78C5  uni78C5,  CJK UNIFIED IDEOGRAPH-78C5
        0x868C, # G+1025  U+868C  uni868C,  CJK UNIFIED IDEOGRAPH-868C
        0x9551, # G+1026  U+9551  uni9551,  CJK UNIFIED IDEOGRAPH-9551
        0x508D, # G+1027  U+508D  uni508D,  CJK UNIFIED IDEOGRAPH-508D
        0x8C24, # G+1028  U+8C24  uni8C24,  CJK UNIFIED IDEOGRAPH-8C24
        0x82DE, # G+1029  U+82DE  uni82DE,  CJK UNIFIED IDEOGRAPH-82DE
        0x80DE, # G+1030  U+80DE  uni80DE,  CJK UNIFIED IDEOGRAPH-80DE
        0x5305, # G+1031  U+5305  uni5305,  CJK UNIFIED IDEOGRAPH-5305
        0x8912, # G+1032  U+8912  uni8912,  CJK UNIFIED IDEOGRAPH-8912
        0x5265, # G+1033  U+5265  uni5265,  CJK UNIFIED IDEOGRAPH-5265
        0x8584, # G+1034  U+8584  uni8584,  CJK UNIFIED IDEOGRAPH-8584
        0x96F9, # G+1035  U+96F9  uni96F9,  CJK UNIFIED IDEOGRAPH-96F9
        0x4FDD, # G+1036  U+4FDD  uni4FDD,  CJK UNIFIED IDEOGRAPH-4FDD
        0x5821, # G+1037  U+5821  uni5821,  CJK UNIFIED IDEOGRAPH-5821
        0x9971, # G+1038  U+9971  uni9971,  CJK UNIFIED IDEOGRAPH-9971
        0x5B9D, # G+1039  U+5B9D  uni5B9D,  CJK UNIFIED IDEOGRAPH-5B9D
        0x62B1, # G+1040  U+62B1  uni62B1,  CJK UNIFIED IDEOGRAPH-62B1
        0x62A5, # G+1041  U+62A5  uni62A5,  CJK UNIFIED IDEOGRAPH-62A5
        0x66B4, # G+1042  U+66B4  uni66B4,  CJK UNIFIED IDEOGRAPH-66B4
        0x8C79, # G+1043  U+8C79  uni8C79,  CJK UNIFIED IDEOGRAPH-8C79
        0x9C8D, # G+1044  U+9C8D  uni9C8D,  CJK UNIFIED IDEOGRAPH-9C8D
        0x7206, # G+1045  U+7206  uni7206,  CJK UNIFIED IDEOGRAPH-7206
        0x676F, # G+1046  U+676F  uni676F,  CJK UNIFIED IDEOGRAPH-676F
        0x7891, # G+1047  U+7891  uni7891,  CJK UNIFIED IDEOGRAPH-7891
        0x60B2, # G+1048  U+60B2  uni60B2,  CJK UNIFIED IDEOGRAPH-60B2
        0x5351, # G+1049  U+5351  uni5351,  CJK UNIFIED IDEOGRAPH-5351
        0x5317, # G+1050  U+5317  uni5317,  CJK UNIFIED IDEOGRAPH-5317
        0x8F88, # G+1051  U+8F88  uni8F88,  CJK UNIFIED IDEOGRAPH-8F88
        0x80CC, # G+1052  U+80CC  uni80CC,  CJK UNIFIED IDEOGRAPH-80CC
        0x8D1D, # G+1053  U+8D1D  uni8D1D,  CJK UNIFIED IDEOGRAPH-8D1D
        0x94A1, # G+1054  U+94A1  uni94A1,  CJK UNIFIED IDEOGRAPH-94A1
        0x500D, # G+1055  U+500D  uni500D,  CJK UNIFIED IDEOGRAPH-500D
        0x72C8, # G+1056  U+72C8  uni72C8,  CJK UNIFIED IDEOGRAPH-72C8
        0x5907, # G+1057  U+5907  uni5907,  CJK UNIFIED IDEOGRAPH-5907
        0x60EB, # G+1058  U+60EB  uni60EB,  CJK UNIFIED IDEOGRAPH-60EB
        0x7119, # G+1059  U+7119  uni7119,  CJK UNIFIED IDEOGRAPH-7119
        0x88AB, # G+1060  U+88AB  uni88AB,  CJK UNIFIED IDEOGRAPH-88AB
        0x5954, # G+1061  U+5954  uni5954,  CJK UNIFIED IDEOGRAPH-5954
        0x82EF, # G+1062  U+82EF  uni82EF,  CJK UNIFIED IDEOGRAPH-82EF
        0x672C, # G+1063  U+672C  uni672C,  CJK UNIFIED IDEOGRAPH-672C
        0x7B28, # G+1064  U+7B28  uni7B28,  CJK UNIFIED IDEOGRAPH-7B28
        0x5D29, # G+1065  U+5D29  uni5D29,  CJK UNIFIED IDEOGRAPH-5D29
        0x7EF7, # G+1066  U+7EF7  uni7EF7,  CJK UNIFIED IDEOGRAPH-7EF7
        0x752D, # G+1067  U+752D  uni752D,  CJK UNIFIED IDEOGRAPH-752D
        0x6CF5, # G+1068  U+6CF5  uni6CF5,  CJK UNIFIED IDEOGRAPH-6CF5
        0x8E66, # G+1069  U+8E66  uni8E66,  CJK UNIFIED IDEOGRAPH-8E66
        0x8FF8, # G+1070  U+8FF8  uni8FF8,  CJK UNIFIED IDEOGRAPH-8FF8
        0x903C, # G+1071  U+903C  uni903C,  CJK UNIFIED IDEOGRAPH-903C
        0x2FD0, # G+1072  U+2FD0  uni2FD0,  KANGXI RADICAL NOSE
        0x2F50, # G+1073  U+2F50  uni2F50,  KANGXI RADICAL COMPARE
        0x9119, # G+1074  U+9119  uni9119,  CJK UNIFIED IDEOGRAPH-9119
        0x7B14, # G+1075  U+7B14  uni7B14,  CJK UNIFIED IDEOGRAPH-7B14
        0x5F7C, # G+1076  U+5F7C  uni5F7C,  CJK UNIFIED IDEOGRAPH-5F7C
        0x78A7, # G+1077  U+78A7  uni78A7,  CJK UNIFIED IDEOGRAPH-78A7
        0x84D6, # G+1078  U+84D6  uni84D6,  CJK UNIFIED IDEOGRAPH-84D6
        0x853D, # G+1079  U+853D  uni853D,  CJK UNIFIED IDEOGRAPH-853D
        0x6BD5, # G+1080  U+6BD5  uni6BD5,  CJK UNIFIED IDEOGRAPH-6BD5
        0x6BD9, # G+1081  U+6BD9  uni6BD9,  CJK UNIFIED IDEOGRAPH-6BD9
        0x6BD6, # G+1082  U+6BD6  uni6BD6,  CJK UNIFIED IDEOGRAPH-6BD6
        0x5E01, # G+1083  U+5E01  uni5E01,  CJK UNIFIED IDEOGRAPH-5E01
        0x5E87, # G+1084  U+5E87  uni5E87,  CJK UNIFIED IDEOGRAPH-5E87
        0x75F9, # G+1085  U+75F9  uni75F9,  CJK UNIFIED IDEOGRAPH-75F9
        0x95ED, # G+1086  U+95ED  uni95ED,  CJK UNIFIED IDEOGRAPH-95ED
        0x655D, # G+1087  U+655D  uni655D,  CJK UNIFIED IDEOGRAPH-655D
        0x5F0A, # G+1088  U+5F0A  uni5F0A,  CJK UNIFIED IDEOGRAPH-5F0A
        0x5FC5, # G+1089  U+5FC5  uni5FC5,  CJK UNIFIED IDEOGRAPH-5FC5
        0x8F9F, # G+1090  U+8F9F  uni8F9F,  CJK UNIFIED IDEOGRAPH-8F9F
        0x58C1, # G+1091  U+58C1  uni58C1,  CJK UNIFIED IDEOGRAPH-58C1
        0x81C2, # G+1092  U+81C2  uni81C2,  CJK UNIFIED IDEOGRAPH-81C2
        0x907F, # G+1093  U+907F  uni907F,  CJK UNIFIED IDEOGRAPH-907F
        0x965B, # G+1094  U+965B  uni965B,  CJK UNIFIED IDEOGRAPH-965B
        0x97AD, # G+1095  U+97AD  uni97AD,  CJK UNIFIED IDEOGRAPH-97AD
        0x8FB9, # G+1096  U+8FB9  uni8FB9,  CJK UNIFIED IDEOGRAPH-8FB9
        0x7F16, # G+1097  U+7F16  uni7F16,  CJK UNIFIED IDEOGRAPH-7F16
        0x8D2C, # G+1098  U+8D2C  uni8D2C,  CJK UNIFIED IDEOGRAPH-8D2C
        0x6241, # G+1099  U+6241  uni6241,  CJK UNIFIED IDEOGRAPH-6241
        0x4FBF, # G+1100  U+4FBF  uni4FBF,  CJK UNIFIED IDEOGRAPH-4FBF
        0x53D8, # G+1101  U+53D8  uni53D8,  CJK UNIFIED IDEOGRAPH-53D8
        0x535E, # G+1102  U+535E  uni535E,  CJK UNIFIED IDEOGRAPH-535E
        0x8FA8, # G+1103  U+8FA8  uni8FA8,  CJK UNIFIED IDEOGRAPH-8FA8
        0x8FA9, # G+1104  U+8FA9  uni8FA9,  CJK UNIFIED IDEOGRAPH-8FA9
        0x8FAB, # G+1105  U+8FAB  uni8FAB,  CJK UNIFIED IDEOGRAPH-8FAB
        0x904D, # G+1106  U+904D  uni904D,  CJK UNIFIED IDEOGRAPH-904D
        0x6807, # G+1107  U+6807  uni6807,  CJK UNIFIED IDEOGRAPH-6807
        0x5F6A, # G+1108  U+5F6A  uni5F6A,  CJK UNIFIED IDEOGRAPH-5F6A
        0x8198, # G+1109  U+8198  uni8198,  CJK UNIFIED IDEOGRAPH-8198
        0x8868, # G+1110  U+8868  uni8868,  CJK UNIFIED IDEOGRAPH-8868
        0x9CD6, # G+1111  U+9CD6  uni9CD6,  CJK UNIFIED IDEOGRAPH-9CD6
        0x618B, # G+1112  U+618B  uni618B,  CJK UNIFIED IDEOGRAPH-618B
        0x522B, # G+1113  U+522B  uni522B,  CJK UNIFIED IDEOGRAPH-522B
        0x762A, # G+1114  U+762A  uni762A,  CJK UNIFIED IDEOGRAPH-762A
        0x5F6C, # G+1115  U+5F6C  uni5F6C,  CJK UNIFIED IDEOGRAPH-5F6C
        0x658C, # G+1116  U+658C  uni658C,  CJK UNIFIED IDEOGRAPH-658C
        0x6FD2, # G+1117  U+6FD2  uni6FD2,  CJK UNIFIED IDEOGRAPH-6FD2
        0x6EE8, # G+1118  U+6EE8  uni6EE8,  CJK UNIFIED IDEOGRAPH-6EE8
        0x5BBE, # G+1119  U+5BBE  uni5BBE,  CJK UNIFIED IDEOGRAPH-5BBE
        0x6448, # G+1120  U+6448  uni6448,  CJK UNIFIED IDEOGRAPH-6448
        0x5175, # G+1121  U+5175  uni5175,  CJK UNIFIED IDEOGRAPH-5175
        0x51B0, # G+1122  U+51B0  uni51B0,  CJK UNIFIED IDEOGRAPH-51B0
        0x67C4, # G+1123  U+67C4  uni67C4,  CJK UNIFIED IDEOGRAPH-67C4
        0x4E19, # G+1124  U+4E19  uni4E19,  CJK UNIFIED IDEOGRAPH-4E19
        0x79C9, # G+1125  U+79C9  uni79C9,  CJK UNIFIED IDEOGRAPH-79C9
        0x997C, # G+1126  U+997C  uni997C,  CJK UNIFIED IDEOGRAPH-997C
        0x70B3, # G+1127  U+70B3  uni70B3,  CJK UNIFIED IDEOGRAPH-70B3
        0x75C5, # G+1128  U+75C5  uni75C5,  CJK UNIFIED IDEOGRAPH-75C5
        0x5E76, # G+1129  U+5E76  uni5E76,  CJK UNIFIED IDEOGRAPH-5E76
        0x73BB, # G+1130  U+73BB  uni73BB,  CJK UNIFIED IDEOGRAPH-73BB
        0x83E0, # G+1131  U+83E0  uni83E0,  CJK UNIFIED IDEOGRAPH-83E0
        0x64AD, # G+1132  U+64AD  uni64AD,  CJK UNIFIED IDEOGRAPH-64AD
        0x62E8, # G+1133  U+62E8  uni62E8,  CJK UNIFIED IDEOGRAPH-62E8
        0x94B5, # G+1134  U+94B5  uni94B5,  CJK UNIFIED IDEOGRAPH-94B5
        0x6CE2, # G+1135  U+6CE2  uni6CE2,  CJK UNIFIED IDEOGRAPH-6CE2
        0x535A, # G+1136  U+535A  uni535A,  CJK UNIFIED IDEOGRAPH-535A
        0x52C3, # G+1137  U+52C3  uni52C3,  CJK UNIFIED IDEOGRAPH-52C3
        0x640F, # G+1138  U+640F  uni640F,  CJK UNIFIED IDEOGRAPH-640F
        0x94C2, # G+1139  U+94C2  uni94C2,  CJK UNIFIED IDEOGRAPH-94C2
        0x7B94, # G+1140  U+7B94  uni7B94,  CJK UNIFIED IDEOGRAPH-7B94
        0x4F2F, # G+1141  U+4F2F  uni4F2F,  CJK UNIFIED IDEOGRAPH-4F2F
        0x5E1B, # G+1142  U+5E1B  uni5E1B,  CJK UNIFIED IDEOGRAPH-5E1B
        0x8236, # G+1143  U+8236  uni8236,  CJK UNIFIED IDEOGRAPH-8236
        0x8116, # G+1144  U+8116  uni8116,  CJK UNIFIED IDEOGRAPH-8116
        0x818A, # G+1145  U+818A  uni818A,  CJK UNIFIED IDEOGRAPH-818A
        0x6E24, # G+1146  U+6E24  uni6E24,  CJK UNIFIED IDEOGRAPH-6E24
        0x6CCA, # G+1147  U+6CCA  uni6CCA,  CJK UNIFIED IDEOGRAPH-6CCA
        0x9A73, # G+1148  U+9A73  uni9A73,  CJK UNIFIED IDEOGRAPH-9A73
        0x6355, # G+1149  U+6355  uni6355,  CJK UNIFIED IDEOGRAPH-6355
        0x2F18, # G+1150  U+2F18  uni2F18,  KANGXI RADICAL DIVINATION
        0x54FA, # G+1151  U+54FA  uni54FA,  CJK UNIFIED IDEOGRAPH-54FA
        0x8865, # G+1152  U+8865  uni8865,  CJK UNIFIED IDEOGRAPH-8865
        0x57E0, # G+1153  U+57E0  uni57E0,  CJK UNIFIED IDEOGRAPH-57E0
        0x4E0D, # G+1154  U+4E0D  uni4E0D,  CJK UNIFIED IDEOGRAPH-4E0D
        0x5E03, # G+1155  U+5E03  uni5E03,  CJK UNIFIED IDEOGRAPH-5E03
        0x6B65, # G+1156  U+6B65  uni6B65,  CJK UNIFIED IDEOGRAPH-6B65
        0x7C3F, # G+1157  U+7C3F  uni7C3F,  CJK UNIFIED IDEOGRAPH-7C3F
        0x90E8, # G+1158  U+90E8  uni90E8,  CJK UNIFIED IDEOGRAPH-90E8
        0x6016, # G+1159  U+6016  uni6016,  CJK UNIFIED IDEOGRAPH-6016
        0x64E6, # G+1160  U+64E6  uni64E6,  CJK UNIFIED IDEOGRAPH-64E6
        0x731C, # G+1161  U+731C  uni731C,  CJK UNIFIED IDEOGRAPH-731C
        0x88C1, # G+1162  U+88C1  uni88C1,  CJK UNIFIED IDEOGRAPH-88C1
        0x6750, # G+1163  U+6750  uni6750,  CJK UNIFIED IDEOGRAPH-6750
        0x624D, # G+1164  U+624D  uni624D,  CJK UNIFIED IDEOGRAPH-624D
        0x8D22, # G+1165  U+8D22  uni8D22,  CJK UNIFIED IDEOGRAPH-8D22
        0x776C, # G+1166  U+776C  uni776C,  CJK UNIFIED IDEOGRAPH-776C
        0x8E29, # G+1167  U+8E29  uni8E29,  CJK UNIFIED IDEOGRAPH-8E29
        0x91C7, # G+1168  U+91C7  uni91C7,  CJK UNIFIED IDEOGRAPH-91C7
        0x5F69, # G+1169  U+5F69  uni5F69,  CJK UNIFIED IDEOGRAPH-5F69
        0x83DC, # G+1170  U+83DC  uni83DC,  CJK UNIFIED IDEOGRAPH-83DC
        0x8521, # G+1171  U+8521  uni8521,  CJK UNIFIED IDEOGRAPH-8521
        0x9910, # G+1172  U+9910  uni9910,  CJK UNIFIED IDEOGRAPH-9910
        0x53C2, # G+1173  U+53C2  uni53C2,  CJK UNIFIED IDEOGRAPH-53C2
        0x8695, # G+1174  U+8695  uni8695,  CJK UNIFIED IDEOGRAPH-8695
        0x6B8B, # G+1175  U+6B8B  uni6B8B,  CJK UNIFIED IDEOGRAPH-6B8B
        0x60ED, # G+1176  U+60ED  uni60ED,  CJK UNIFIED IDEOGRAPH-60ED
        0x60E8, # G+1177  U+60E8  uni60E8,  CJK UNIFIED IDEOGRAPH-60E8
        0x707F, # G+1178  U+707F  uni707F,  CJK UNIFIED IDEOGRAPH-707F
        0x82CD, # G+1179  U+82CD  uni82CD,  CJK UNIFIED IDEOGRAPH-82CD
        0x8231, # G+1180  U+8231  uni8231,  CJK UNIFIED IDEOGRAPH-8231
        0x4ED3, # G+1181  U+4ED3  uni4ED3,  CJK UNIFIED IDEOGRAPH-4ED3
        0x6CA7, # G+1182  U+6CA7  uni6CA7,  CJK UNIFIED IDEOGRAPH-6CA7
        0x85CF, # G+1183  U+85CF  uni85CF,  CJK UNIFIED IDEOGRAPH-85CF
        0x64CD, # G+1184  U+64CD  uni64CD,  CJK UNIFIED IDEOGRAPH-64CD
        0x7CD9, # G+1185  U+7CD9  uni7CD9,  CJK UNIFIED IDEOGRAPH-7CD9
        0x69FD, # G+1186  U+69FD  uni69FD,  CJK UNIFIED IDEOGRAPH-69FD
        0x66F9, # G+1187  U+66F9  uni66F9,  CJK UNIFIED IDEOGRAPH-66F9
        0x8349, # G+1188  U+8349  uni8349,  CJK UNIFIED IDEOGRAPH-8349
        0x5395, # G+1189  U+5395  uni5395,  CJK UNIFIED IDEOGRAPH-5395
        0x7B56, # G+1190  U+7B56  uni7B56,  CJK UNIFIED IDEOGRAPH-7B56
        0x4FA7, # G+1191  U+4FA7  uni4FA7,  CJK UNIFIED IDEOGRAPH-4FA7
        0x518C, # G+1192  U+518C  uni518C,  CJK UNIFIED IDEOGRAPH-518C
        0x6D4B, # G+1193  U+6D4B  uni6D4B,  CJK UNIFIED IDEOGRAPH-6D4B
        0x5C42, # G+1194  U+5C42  uni5C42,  CJK UNIFIED IDEOGRAPH-5C42
        0x8E6D, # G+1195  U+8E6D  uni8E6D,  CJK UNIFIED IDEOGRAPH-8E6D
        0x63D2, # G+1196  U+63D2  uni63D2,  CJK UNIFIED IDEOGRAPH-63D2
        0x53C9, # G+1197  U+53C9  uni53C9,  CJK UNIFIED IDEOGRAPH-53C9
        0x832C, # G+1198  U+832C  uni832C,  CJK UNIFIED IDEOGRAPH-832C
        0x8336, # G+1199  U+8336  uni8336,  CJK UNIFIED IDEOGRAPH-8336
        0x67E5, # G+1200  U+67E5  uni67E5,  CJK UNIFIED IDEOGRAPH-67E5
        0x78B4, # G+1201  U+78B4  uni78B4,  CJK UNIFIED IDEOGRAPH-78B4
        0x643D, # G+1202  U+643D  uni643D,  CJK UNIFIED IDEOGRAPH-643D
        0x5BDF, # G+1203  U+5BDF  uni5BDF,  CJK UNIFIED IDEOGRAPH-5BDF
        0x5C94, # G+1204  U+5C94  uni5C94,  CJK UNIFIED IDEOGRAPH-5C94
        0x5DEE, # G+1205  U+5DEE  uni5DEE,  CJK UNIFIED IDEOGRAPH-5DEE
        0x8BE7, # G+1206  U+8BE7  uni8BE7,  CJK UNIFIED IDEOGRAPH-8BE7
        0x62C6, # G+1207  U+62C6  uni62C6,  CJK UNIFIED IDEOGRAPH-62C6
        0x67F4, # G+1208  U+67F4  uni67F4,  CJK UNIFIED IDEOGRAPH-67F4
        0x8C7A, # G+1209  U+8C7A  uni8C7A,  CJK UNIFIED IDEOGRAPH-8C7A
        0x6400, # G+1210  U+6400  uni6400,  CJK UNIFIED IDEOGRAPH-6400
        0x63BA, # G+1211  U+63BA  uni63BA,  CJK UNIFIED IDEOGRAPH-63BA
        0x8749, # G+1212  U+8749  uni8749,  CJK UNIFIED IDEOGRAPH-8749
        0x998B, # G+1213  U+998B  uni998B,  CJK UNIFIED IDEOGRAPH-998B
        0x8C17, # G+1214  U+8C17  uni8C17,  CJK UNIFIED IDEOGRAPH-8C17
        0x7F20, # G+1215  U+7F20  uni7F20,  CJK UNIFIED IDEOGRAPH-7F20
        0x94F2, # G+1216  U+94F2  uni94F2,  CJK UNIFIED IDEOGRAPH-94F2
        0x4EA7, # G+1217  U+4EA7  uni4EA7,  CJK UNIFIED IDEOGRAPH-4EA7
        0x9610, # G+1218  U+9610  uni9610,  CJK UNIFIED IDEOGRAPH-9610
        0x98A4, # G+1219  U+98A4  uni98A4,  CJK UNIFIED IDEOGRAPH-98A4
        0x660C, # G+1220  U+660C  uni660C,  CJK UNIFIED IDEOGRAPH-660C
        0x7316, # G+1221  U+7316  uni7316,  CJK UNIFIED IDEOGRAPH-7316
        0x573A, # G+1222  U+573A  uni573A,  CJK UNIFIED IDEOGRAPH-573A
        0x5C1D, # G+1223  U+5C1D  uni5C1D,  CJK UNIFIED IDEOGRAPH-5C1D
        0x5E38, # G+1224  U+5E38  uni5E38,  CJK UNIFIED IDEOGRAPH-5E38
        0x957F, # G+1225  U+957F  uni957F,  CJK UNIFIED IDEOGRAPH-957F
        0x507F, # G+1226  U+507F  uni507F,  CJK UNIFIED IDEOGRAPH-507F
        0x80A0, # G+1227  U+80A0  uni80A0,  CJK UNIFIED IDEOGRAPH-80A0
        0x2F1A, # G+1228  U+2F1A  uni2F1A,  KANGXI RADICAL CLIFF
        0x655E, # G+1229  U+655E  uni655E,  CJK UNIFIED IDEOGRAPH-655E
        0x7545, # G+1230  U+7545  uni7545,  CJK UNIFIED IDEOGRAPH-7545
        0x5531, # G+1231  U+5531  uni5531,  CJK UNIFIED IDEOGRAPH-5531
        0x5021, # G+1232  U+5021  uni5021,  CJK UNIFIED IDEOGRAPH-5021
        0x8D85, # G+1233  U+8D85  uni8D85,  CJK UNIFIED IDEOGRAPH-8D85
        0x6284, # G+1234  U+6284  uni6284,  CJK UNIFIED IDEOGRAPH-6284
        0x949E, # G+1235  U+949E  uni949E,  CJK UNIFIED IDEOGRAPH-949E
        0x671D, # G+1236  U+671D  uni671D,  CJK UNIFIED IDEOGRAPH-671D
        0x5632, # G+1237  U+5632  uni5632,  CJK UNIFIED IDEOGRAPH-5632
        0x6F6E, # G+1238  U+6F6E  uni6F6E,  CJK UNIFIED IDEOGRAPH-6F6E
        0x5DE2, # G+1239  U+5DE2  uni5DE2,  CJK UNIFIED IDEOGRAPH-5DE2
        0x5435, # G+1240  U+5435  uni5435,  CJK UNIFIED IDEOGRAPH-5435
        0x7092, # G+1241  U+7092  uni7092,  CJK UNIFIED IDEOGRAPH-7092
        0x8F66, # G+1242  U+8F66  uni8F66,  CJK UNIFIED IDEOGRAPH-8F66
        0x626F, # G+1243  U+626F  uni626F,  CJK UNIFIED IDEOGRAPH-626F
        0x64A4, # G+1244  U+64A4  uni64A4,  CJK UNIFIED IDEOGRAPH-64A4
        0x63A3, # G+1245  U+63A3  uni63A3,  CJK UNIFIED IDEOGRAPH-63A3
        0x5F7B, # G+1246  U+5F7B  uni5F7B,  CJK UNIFIED IDEOGRAPH-5F7B
        0x6F88, # G+1247  U+6F88  uni6F88,  CJK UNIFIED IDEOGRAPH-6F88
        0x90F4, # G+1248  U+90F4  uni90F4,  CJK UNIFIED IDEOGRAPH-90F4
        0x2F82, # G+1249  U+2F82  uni2F82,  KANGXI RADICAL MINISTER
        0x2FA0, # G+1250  U+2FA0  uni2FA0,  KANGXI RADICAL MORNING
        0x5C18, # G+1251  U+5C18  uni5C18,  CJK UNIFIED IDEOGRAPH-5C18
        0x6668, # G+1252  U+6668  uni6668,  CJK UNIFIED IDEOGRAPH-6668
        0x5FF1, # G+1253  U+5FF1  uni5FF1,  CJK UNIFIED IDEOGRAPH-5FF1
        0x6C89, # G+1254  U+6C89  uni6C89,  CJK UNIFIED IDEOGRAPH-6C89
        0x9648, # G+1255  U+9648  uni9648,  CJK UNIFIED IDEOGRAPH-9648
        0x8D81, # G+1256  U+8D81  uni8D81,  CJK UNIFIED IDEOGRAPH-8D81
        0x886C, # G+1257  U+886C  uni886C,  CJK UNIFIED IDEOGRAPH-886C
        0x6491, # G+1258  U+6491  uni6491,  CJK UNIFIED IDEOGRAPH-6491
        0x79F0, # G+1259  U+79F0  uni79F0,  CJK UNIFIED IDEOGRAPH-79F0
        0x57CE, # G+1260  U+57CE  uni57CE,  CJK UNIFIED IDEOGRAPH-57CE
        0x6A59, # G+1261  U+6A59  uni6A59,  CJK UNIFIED IDEOGRAPH-6A59
        0x6210, # G+1262  U+6210  uni6210,  CJK UNIFIED IDEOGRAPH-6210
        0x5448, # G+1263  U+5448  uni5448,  CJK UNIFIED IDEOGRAPH-5448
        0x4E58, # G+1264  U+4E58  uni4E58,  CJK UNIFIED IDEOGRAPH-4E58
        0x7A0B, # G+1265  U+7A0B  uni7A0B,  CJK UNIFIED IDEOGRAPH-7A0B
        0x60E9, # G+1266  U+60E9  uni60E9,  CJK UNIFIED IDEOGRAPH-60E9
        0x6F84, # G+1267  U+6F84  uni6F84,  CJK UNIFIED IDEOGRAPH-6F84
        0x8BDA, # G+1268  U+8BDA  uni8BDA,  CJK UNIFIED IDEOGRAPH-8BDA
        0x627F, # G+1269  U+627F  uni627F,  CJK UNIFIED IDEOGRAPH-627F
        0x901E, # G+1270  U+901E  uni901E,  CJK UNIFIED IDEOGRAPH-901E
        0x9A8B, # G+1271  U+9A8B  uni9A8B,  CJK UNIFIED IDEOGRAPH-9A8B
        0x79E4, # G+1272  U+79E4  uni79E4,  CJK UNIFIED IDEOGRAPH-79E4
        0x5403, # G+1273  U+5403  uni5403,  CJK UNIFIED IDEOGRAPH-5403
        0x75F4, # G+1274  U+75F4  uni75F4,  CJK UNIFIED IDEOGRAPH-75F4
        0x6301, # G+1275  U+6301  uni6301,  CJK UNIFIED IDEOGRAPH-6301
        0x5319, # G+1276  U+5319  uni5319,  CJK UNIFIED IDEOGRAPH-5319
        0x6C60, # G+1277  U+6C60  uni6C60,  CJK UNIFIED IDEOGRAPH-6C60
        0x8FDF, # G+1278  U+8FDF  uni8FDF,  CJK UNIFIED IDEOGRAPH-8FDF
        0x5F1B, # G+1279  U+5F1B  uni5F1B,  CJK UNIFIED IDEOGRAPH-5F1B
        0x9A70, # G+1280  U+9A70  uni9A70,  CJK UNIFIED IDEOGRAPH-9A70
        0x803B, # G+1281  U+803B  uni803B,  CJK UNIFIED IDEOGRAPH-803B
        0x9F7F, # G+1282  U+9F7F  uni9F7F,  CJK UNIFIED IDEOGRAPH-9F7F
        0x4F88, # G+1283  U+4F88  uni4F88,  CJK UNIFIED IDEOGRAPH-4F88
        0x5C3A, # G+1284  U+5C3A  uni5C3A,  CJK UNIFIED IDEOGRAPH-5C3A
        0x2F9A, # G+1285  U+2F9A  uni2F9A,  KANGXI RADICAL RED
        0x7FC5, # G+1286  U+7FC5  uni7FC5,  CJK UNIFIED IDEOGRAPH-7FC5
        0x65A5, # G+1287  U+65A5  uni65A5,  CJK UNIFIED IDEOGRAPH-65A5
        0x70BD, # G+1288  U+70BD  uni70BD,  CJK UNIFIED IDEOGRAPH-70BD
        0x5145, # G+1289  U+5145  uni5145,  CJK UNIFIED IDEOGRAPH-5145
        0x51B2, # G+1290  U+51B2  uni51B2,  CJK UNIFIED IDEOGRAPH-51B2
        0x2F8D, # G+1291  U+2F8D  uni2F8D,  KANGXI RADICAL INSECT
        0x5D07, # G+1292  U+5D07  uni5D07,  CJK UNIFIED IDEOGRAPH-5D07
        0x5BA0, # G+1293  U+5BA0  uni5BA0,  CJK UNIFIED IDEOGRAPH-5BA0
        0x62BD, # G+1294  U+62BD  uni62BD,  CJK UNIFIED IDEOGRAPH-62BD
        0x916C, # G+1295  U+916C  uni916C,  CJK UNIFIED IDEOGRAPH-916C
        0x7574, # G+1296  U+7574  uni7574,  CJK UNIFIED IDEOGRAPH-7574
        0x8E0C, # G+1297  U+8E0C  uni8E0C,  CJK UNIFIED IDEOGRAPH-8E0C
        0x7A20, # G+1298  U+7A20  uni7A20,  CJK UNIFIED IDEOGRAPH-7A20
        0x6101, # G+1299  U+6101  uni6101,  CJK UNIFIED IDEOGRAPH-6101
        0x7B79, # G+1300  U+7B79  uni7B79,  CJK UNIFIED IDEOGRAPH-7B79
        0x4EC7, # G+1301  U+4EC7  uni4EC7,  CJK UNIFIED IDEOGRAPH-4EC7
        0x7EF8, # G+1302  U+7EF8  uni7EF8,  CJK UNIFIED IDEOGRAPH-7EF8
        0x7785, # G+1303  U+7785  uni7785,  CJK UNIFIED IDEOGRAPH-7785
        0x4E11, # G+1304  U+4E11  uni4E11,  CJK UNIFIED IDEOGRAPH-4E11
        0x81ED, # G+1305  U+81ED  uni81ED,  CJK UNIFIED IDEOGRAPH-81ED
        0x521D, # G+1306  U+521D  uni521D,  CJK UNIFIED IDEOGRAPH-521D
        0x51FA, # G+1307  U+51FA  uni51FA,  CJK UNIFIED IDEOGRAPH-51FA
        0x6A71, # G+1308  U+6A71  uni6A71,  CJK UNIFIED IDEOGRAPH-6A71
        0x53A8, # G+1309  U+53A8  uni53A8,  CJK UNIFIED IDEOGRAPH-53A8
        0x8E87, # G+1310  U+8E87  uni8E87,  CJK UNIFIED IDEOGRAPH-8E87
        0x9504, # G+1311  U+9504  uni9504,  CJK UNIFIED IDEOGRAPH-9504
        0x96CF, # G+1312  U+96CF  uni96CF,  CJK UNIFIED IDEOGRAPH-96CF
        0x6EC1, # G+1313  U+6EC1  uni6EC1,  CJK UNIFIED IDEOGRAPH-6EC1
        0x9664, # G+1314  U+9664  uni9664,  CJK UNIFIED IDEOGRAPH-9664
        0x695A, # G+1315  U+695A  uni695A,  CJK UNIFIED IDEOGRAPH-695A
        0x7840, # G+1316  U+7840  uni7840,  CJK UNIFIED IDEOGRAPH-7840
        0x50A8, # G+1317  U+50A8  uni50A8,  CJK UNIFIED IDEOGRAPH-50A8
        0x77D7, # G+1318  U+77D7  uni77D7,  CJK UNIFIED IDEOGRAPH-77D7
        0x6410, # G+1319  U+6410  uni6410,  CJK UNIFIED IDEOGRAPH-6410
        0x89E6, # G+1320  U+89E6  uni89E6,  CJK UNIFIED IDEOGRAPH-89E6
        0x5904, # G+1321  U+5904  uni5904,  CJK UNIFIED IDEOGRAPH-5904
        0x63E3, # G+1322  U+63E3  uni63E3,  CJK UNIFIED IDEOGRAPH-63E3
        0x5DDD, # G+1323  U+5DDD  uni5DDD,  CJK UNIFIED IDEOGRAPH-5DDD
        0x7A7F, # G+1324  U+7A7F  uni7A7F,  CJK UNIFIED IDEOGRAPH-7A7F
        0x693D, # G+1325  U+693D  uni693D,  CJK UNIFIED IDEOGRAPH-693D
        0x4F20, # G+1326  U+4F20  uni4F20,  CJK UNIFIED IDEOGRAPH-4F20
        0x8239, # G+1327  U+8239  uni8239,  CJK UNIFIED IDEOGRAPH-8239
        0x5598, # G+1328  U+5598  uni5598,  CJK UNIFIED IDEOGRAPH-5598
        0x4E32, # G+1329  U+4E32  uni4E32,  CJK UNIFIED IDEOGRAPH-4E32
        0x75AE, # G+1330  U+75AE  uni75AE,  CJK UNIFIED IDEOGRAPH-75AE
        0x7A97, # G+1331  U+7A97  uni7A97,  CJK UNIFIED IDEOGRAPH-7A97
        0x5E62, # G+1332  U+5E62  uni5E62,  CJK UNIFIED IDEOGRAPH-5E62
        0x5E8A, # G+1333  U+5E8A  uni5E8A,  CJK UNIFIED IDEOGRAPH-5E8A
        0x95EF, # G+1334  U+95EF  uni95EF,  CJK UNIFIED IDEOGRAPH-95EF
        0x521B, # G+1335  U+521B  uni521B,  CJK UNIFIED IDEOGRAPH-521B
        0x5439, # G+1336  U+5439  uni5439,  CJK UNIFIED IDEOGRAPH-5439
        0x708A, # G+1337  U+708A  uni708A,  CJK UNIFIED IDEOGRAPH-708A
        0x6376, # G+1338  U+6376  uni6376,  CJK UNIFIED IDEOGRAPH-6376
        0x9524, # G+1339  U+9524  uni9524,  CJK UNIFIED IDEOGRAPH-9524
        0x5782, # G+1340  U+5782  uni5782,  CJK UNIFIED IDEOGRAPH-5782
        0x6625, # G+1341  U+6625  uni6625,  CJK UNIFIED IDEOGRAPH-6625
        0x693F, # G+1342  U+693F  uni693F,  CJK UNIFIED IDEOGRAPH-693F
        0x9187, # G+1343  U+9187  uni9187,  CJK UNIFIED IDEOGRAPH-9187
        0x5507, # G+1344  U+5507  uni5507,  CJK UNIFIED IDEOGRAPH-5507
        0x6DF3, # G+1345  U+6DF3  uni6DF3,  CJK UNIFIED IDEOGRAPH-6DF3
        0x7EAF, # G+1346  U+7EAF  uni7EAF,  CJK UNIFIED IDEOGRAPH-7EAF
        0x8822, # G+1347  U+8822  uni8822,  CJK UNIFIED IDEOGRAPH-8822
        0x6233, # G+1348  U+6233  uni6233,  CJK UNIFIED IDEOGRAPH-6233
        0x7EF0, # G+1349  U+7EF0  uni7EF0,  CJK UNIFIED IDEOGRAPH-7EF0
        0x75B5, # G+1350  U+75B5  uni75B5,  CJK UNIFIED IDEOGRAPH-75B5
        0x8328, # G+1351  U+8328  uni8328,  CJK UNIFIED IDEOGRAPH-8328
        0x78C1, # G+1352  U+78C1  uni78C1,  CJK UNIFIED IDEOGRAPH-78C1
        0x96CC, # G+1353  U+96CC  uni96CC,  CJK UNIFIED IDEOGRAPH-96CC
        0x8F9E, # G+1354  U+8F9E  uni8F9E,  CJK UNIFIED IDEOGRAPH-8F9E
        0x6148, # G+1355  U+6148  uni6148,  CJK UNIFIED IDEOGRAPH-6148
        0x74F7, # G+1356  U+74F7  uni74F7,  CJK UNIFIED IDEOGRAPH-74F7
        0x8BCD, # G+1357  U+8BCD  uni8BCD,  CJK UNIFIED IDEOGRAPH-8BCD
        0x6B64, # G+1358  U+6B64  uni6B64,  CJK UNIFIED IDEOGRAPH-6B64
        0x523A, # G+1359  U+523A  uni523A,  CJK UNIFIED IDEOGRAPH-523A
        0x8D50, # G+1360  U+8D50  uni8D50,  CJK UNIFIED IDEOGRAPH-8D50
        0x6B21, # G+1361  U+6B21  uni6B21,  CJK UNIFIED IDEOGRAPH-6B21
        0x806A, # G+1362  U+806A  uni806A,  CJK UNIFIED IDEOGRAPH-806A
        0x8471, # G+1363  U+8471  uni8471,  CJK UNIFIED IDEOGRAPH-8471
        0x56F1, # G+1364  U+56F1  uni56F1,  CJK UNIFIED IDEOGRAPH-56F1
        0x5306, # G+1365  U+5306  uni5306,  CJK UNIFIED IDEOGRAPH-5306
        0x4ECE, # G+1366  U+4ECE  uni4ECE,  CJK UNIFIED IDEOGRAPH-4ECE
        0x4E1B, # G+1367  U+4E1B  uni4E1B,  CJK UNIFIED IDEOGRAPH-4E1B
        0x51D1, # G+1368  U+51D1  uni51D1,  CJK UNIFIED IDEOGRAPH-51D1
        0x7C97, # G+1369  U+7C97  uni7C97,  CJK UNIFIED IDEOGRAPH-7C97
        0x918B, # G+1370  U+918B  uni918B,  CJK UNIFIED IDEOGRAPH-918B
        0x7C07, # G+1371  U+7C07  uni7C07,  CJK UNIFIED IDEOGRAPH-7C07
        0x4FC3, # G+1372  U+4FC3  uni4FC3,  CJK UNIFIED IDEOGRAPH-4FC3
        0x8E7F, # G+1373  U+8E7F  uni8E7F,  CJK UNIFIED IDEOGRAPH-8E7F
        0x7BE1, # G+1374  U+7BE1  uni7BE1,  CJK UNIFIED IDEOGRAPH-7BE1
        0x7A9C, # G+1375  U+7A9C  uni7A9C,  CJK UNIFIED IDEOGRAPH-7A9C
        0x6467, # G+1376  U+6467  uni6467,  CJK UNIFIED IDEOGRAPH-6467
        0x5D14, # G+1377  U+5D14  uni5D14,  CJK UNIFIED IDEOGRAPH-5D14
        0x50AC, # G+1378  U+50AC  uni50AC,  CJK UNIFIED IDEOGRAPH-50AC
        0x8106, # G+1379  U+8106  uni8106,  CJK UNIFIED IDEOGRAPH-8106
        0x7601, # G+1380  U+7601  uni7601,  CJK UNIFIED IDEOGRAPH-7601
        0x7CB9, # G+1381  U+7CB9  uni7CB9,  CJK UNIFIED IDEOGRAPH-7CB9
        0x6DEC, # G+1382  U+6DEC  uni6DEC,  CJK UNIFIED IDEOGRAPH-6DEC
        0x7FE0, # G+1383  U+7FE0  uni7FE0,  CJK UNIFIED IDEOGRAPH-7FE0
        0x6751, # G+1384  U+6751  uni6751,  CJK UNIFIED IDEOGRAPH-6751
        0x5B58, # G+1385  U+5B58  uni5B58,  CJK UNIFIED IDEOGRAPH-5B58
        0x2F28, # G+1386  U+2F28  uni2F28,  KANGXI RADICAL INCH
        0x78CB, # G+1387  U+78CB  uni78CB,  CJK UNIFIED IDEOGRAPH-78CB
        0x64AE, # G+1388  U+64AE  uni64AE,  CJK UNIFIED IDEOGRAPH-64AE
        0x6413, # G+1389  U+6413  uni6413,  CJK UNIFIED IDEOGRAPH-6413
        0x63AA, # G+1390  U+63AA  uni63AA,  CJK UNIFIED IDEOGRAPH-63AA
        0x632B, # G+1391  U+632B  uni632B,  CJK UNIFIED IDEOGRAPH-632B
        0x9519, # G+1392  U+9519  uni9519,  CJK UNIFIED IDEOGRAPH-9519
        0x642D, # G+1393  U+642D  uni642D,  CJK UNIFIED IDEOGRAPH-642D
        0x8FBE, # G+1394  U+8FBE  uni8FBE,  CJK UNIFIED IDEOGRAPH-8FBE
        0x7B54, # G+1395  U+7B54  uni7B54,  CJK UNIFIED IDEOGRAPH-7B54
        0x7629, # G+1396  U+7629  uni7629,  CJK UNIFIED IDEOGRAPH-7629
        0x6253, # G+1397  U+6253  uni6253,  CJK UNIFIED IDEOGRAPH-6253
        0x2F24, # G+1398  U+2F24  uni2F24,  KANGXI RADICAL BIG
        0x5446, # G+1399  U+5446  uni5446,  CJK UNIFIED IDEOGRAPH-5446
        0x2F4D, # G+1400  U+2F4D  uni2F4D,  KANGXI RADICAL DEATH
        0x50A3, # G+1401  U+50A3  uni50A3,  CJK UNIFIED IDEOGRAPH-50A3
        0x6234, # G+1402  U+6234  uni6234,  CJK UNIFIED IDEOGRAPH-6234
        0x5E26, # G+1403  U+5E26  uni5E26,  CJK UNIFIED IDEOGRAPH-5E26
        0x6B86, # G+1404  U+6B86  uni6B86,  CJK UNIFIED IDEOGRAPH-6B86
        0x4EE3, # G+1405  U+4EE3  uni4EE3,  CJK UNIFIED IDEOGRAPH-4EE3
        0x8D37, # G+1406  U+8D37  uni8D37,  CJK UNIFIED IDEOGRAPH-8D37
        0x888B, # G+1407  U+888B  uni888B,  CJK UNIFIED IDEOGRAPH-888B
        0x5F85, # G+1408  U+5F85  uni5F85,  CJK UNIFIED IDEOGRAPH-5F85
        0x902E, # G+1409  U+902E  uni902E,  CJK UNIFIED IDEOGRAPH-902E
        0x6020, # G+1410  U+6020  uni6020,  CJK UNIFIED IDEOGRAPH-6020
        0x803D, # G+1411  U+803D  uni803D,  CJK UNIFIED IDEOGRAPH-803D
        0x62C5, # G+1412  U+62C5  uni62C5,  CJK UNIFIED IDEOGRAPH-62C5
        0x4E39, # G+1413  U+4E39  uni4E39,  CJK UNIFIED IDEOGRAPH-4E39
        0x5355, # G+1414  U+5355  uni5355,  CJK UNIFIED IDEOGRAPH-5355
        0x90F8, # G+1415  U+90F8  uni90F8,  CJK UNIFIED IDEOGRAPH-90F8
        0x63B8, # G+1416  U+63B8  uni63B8,  CJK UNIFIED IDEOGRAPH-63B8
        0x80C6, # G+1417  U+80C6  uni80C6,  CJK UNIFIED IDEOGRAPH-80C6
        0x65E6, # G+1418  U+65E6  uni65E6,  CJK UNIFIED IDEOGRAPH-65E6
        0x6C2E, # G+1419  U+6C2E  uni6C2E,  CJK UNIFIED IDEOGRAPH-6C2E
        0x4F46, # G+1420  U+4F46  uni4F46,  CJK UNIFIED IDEOGRAPH-4F46
        0x60EE, # G+1421  U+60EE  uni60EE,  CJK UNIFIED IDEOGRAPH-60EE
        0x6DE1, # G+1422  U+6DE1  uni6DE1,  CJK UNIFIED IDEOGRAPH-6DE1
        0x8BDE, # G+1423  U+8BDE  uni8BDE,  CJK UNIFIED IDEOGRAPH-8BDE
        0x5F39, # G+1424  U+5F39  uni5F39,  CJK UNIFIED IDEOGRAPH-5F39
        0x86CB, # G+1425  U+86CB  uni86CB,  CJK UNIFIED IDEOGRAPH-86CB
        0x5F53, # G+1426  U+5F53  uni5F53,  CJK UNIFIED IDEOGRAPH-5F53
        0x6321, # G+1427  U+6321  uni6321,  CJK UNIFIED IDEOGRAPH-6321
        0x515A, # G+1428  U+515A  uni515A,  CJK UNIFIED IDEOGRAPH-515A
        0x8361, # G+1429  U+8361  uni8361,  CJK UNIFIED IDEOGRAPH-8361
        0x6863, # G+1430  U+6863  uni6863,  CJK UNIFIED IDEOGRAPH-6863
        0x2F11, # G+1431  U+2F11  uni2F11,  KANGXI RADICAL KNIFE
        0x6363, # G+1432  U+6363  uni6363,  CJK UNIFIED IDEOGRAPH-6363
        0x8E48, # G+1433  U+8E48  uni8E48,  CJK UNIFIED IDEOGRAPH-8E48
        0x5012, # G+1434  U+5012  uni5012,  CJK UNIFIED IDEOGRAPH-5012
        0x5C9B, # G+1435  U+5C9B  uni5C9B,  CJK UNIFIED IDEOGRAPH-5C9B
        0x7977, # G+1436  U+7977  uni7977,  CJK UNIFIED IDEOGRAPH-7977
        0x5BFC, # G+1437  U+5BFC  uni5BFC,  CJK UNIFIED IDEOGRAPH-5BFC
        0x5230, # G+1438  U+5230  uni5230,  CJK UNIFIED IDEOGRAPH-5230
        0x7A3B, # G+1439  U+7A3B  uni7A3B,  CJK UNIFIED IDEOGRAPH-7A3B
        0x60BC, # G+1440  U+60BC  uni60BC,  CJK UNIFIED IDEOGRAPH-60BC
        0x9053, # G+1441  U+9053  uni9053,  CJK UNIFIED IDEOGRAPH-9053
        0x76D7, # G+1442  U+76D7  uni76D7,  CJK UNIFIED IDEOGRAPH-76D7
        0x5FB7, # G+1443  U+5FB7  uni5FB7,  CJK UNIFIED IDEOGRAPH-5FB7
        0x5F97, # G+1444  U+5F97  uni5F97,  CJK UNIFIED IDEOGRAPH-5F97
        0x7684, # G+1445  U+7684  uni7684,  CJK UNIFIED IDEOGRAPH-7684
        0x8E6C, # G+1446  U+8E6C  uni8E6C,  CJK UNIFIED IDEOGRAPH-8E6C
        0x706F, # G+1447  U+706F  uni706F,  CJK UNIFIED IDEOGRAPH-706F
        0x767B, # G+1448  U+767B  uni767B,  CJK UNIFIED IDEOGRAPH-767B
        0x7B49, # G+1449  U+7B49  uni7B49,  CJK UNIFIED IDEOGRAPH-7B49
        0x77AA, # G+1450  U+77AA  uni77AA,  CJK UNIFIED IDEOGRAPH-77AA
        0x51F3, # G+1451  U+51F3  uni51F3,  CJK UNIFIED IDEOGRAPH-51F3
        0x9093, # G+1452  U+9093  uni9093,  CJK UNIFIED IDEOGRAPH-9093
        0x5824, # G+1453  U+5824  uni5824,  CJK UNIFIED IDEOGRAPH-5824
        0x4F4E, # G+1454  U+4F4E  uni4F4E,  CJK UNIFIED IDEOGRAPH-4F4E
        0x6EF4, # G+1455  U+6EF4  uni6EF4,  CJK UNIFIED IDEOGRAPH-6EF4
        0x8FEA, # G+1456  U+8FEA  uni8FEA,  CJK UNIFIED IDEOGRAPH-8FEA
        0x654C, # G+1457  U+654C  uni654C,  CJK UNIFIED IDEOGRAPH-654C
        0x7B1B, # G+1458  U+7B1B  uni7B1B,  CJK UNIFIED IDEOGRAPH-7B1B
        0x72C4, # G+1459  U+72C4  uni72C4,  CJK UNIFIED IDEOGRAPH-72C4
        0x6DA4, # G+1460  U+6DA4  uni6DA4,  CJK UNIFIED IDEOGRAPH-6DA4
        0x7FDF, # G+1461  U+7FDF  uni7FDF,  CJK UNIFIED IDEOGRAPH-7FDF
        0x5AE1, # G+1462  U+5AE1  uni5AE1,  CJK UNIFIED IDEOGRAPH-5AE1
        0x62B5, # G+1463  U+62B5  uni62B5,  CJK UNIFIED IDEOGRAPH-62B5
        0x5E95, # G+1464  U+5E95  uni5E95,  CJK UNIFIED IDEOGRAPH-5E95
        0x5730, # G+1465  U+5730  uni5730,  CJK UNIFIED IDEOGRAPH-5730
        0x8482, # G+1466  U+8482  uni8482,  CJK UNIFIED IDEOGRAPH-8482
        0x7B2C, # G+1467  U+7B2C  uni7B2C,  CJK UNIFIED IDEOGRAPH-7B2C
        0x5E1D, # G+1468  U+5E1D  uni5E1D,  CJK UNIFIED IDEOGRAPH-5E1D
        0x5F1F, # G+1469  U+5F1F  uni5F1F,  CJK UNIFIED IDEOGRAPH-5F1F
        0x9012, # G+1470  U+9012  uni9012,  CJK UNIFIED IDEOGRAPH-9012
        0x7F14, # G+1471  U+7F14  uni7F14,  CJK UNIFIED IDEOGRAPH-7F14
        0x98A0, # G+1472  U+98A0  uni98A0,  CJK UNIFIED IDEOGRAPH-98A0
        0x6382, # G+1473  U+6382  uni6382,  CJK UNIFIED IDEOGRAPH-6382
        0x6EC7, # G+1474  U+6EC7  uni6EC7,  CJK UNIFIED IDEOGRAPH-6EC7
        0x7898, # G+1475  U+7898  uni7898,  CJK UNIFIED IDEOGRAPH-7898
        0x70B9, # G+1476  U+70B9  uni70B9,  CJK UNIFIED IDEOGRAPH-70B9
        0x5178, # G+1477  U+5178  uni5178,  CJK UNIFIED IDEOGRAPH-5178
        0x975B, # G+1478  U+975B  uni975B,  CJK UNIFIED IDEOGRAPH-975B
        0x57AB, # G+1479  U+57AB  uni57AB,  CJK UNIFIED IDEOGRAPH-57AB
        0x7535, # G+1480  U+7535  uni7535,  CJK UNIFIED IDEOGRAPH-7535
        0x4F43, # G+1481  U+4F43  uni4F43,  CJK UNIFIED IDEOGRAPH-4F43
        0x7538, # G+1482  U+7538  uni7538,  CJK UNIFIED IDEOGRAPH-7538
        0x5E97, # G+1483  U+5E97  uni5E97,  CJK UNIFIED IDEOGRAPH-5E97
        0x60E6, # G+1484  U+60E6  uni60E6,  CJK UNIFIED IDEOGRAPH-60E6
        0x5960, # G+1485  U+5960  uni5960,  CJK UNIFIED IDEOGRAPH-5960
        0x6DC0, # G+1486  U+6DC0  uni6DC0,  CJK UNIFIED IDEOGRAPH-6DC0
        0x6BBF, # G+1487  U+6BBF  uni6BBF,  CJK UNIFIED IDEOGRAPH-6BBF
        0x7889, # G+1488  U+7889  uni7889,  CJK UNIFIED IDEOGRAPH-7889
        0x53FC, # G+1489  U+53FC  uni53FC,  CJK UNIFIED IDEOGRAPH-53FC
        0x96D5, # G+1490  U+96D5  uni96D5,  CJK UNIFIED IDEOGRAPH-96D5
        0x51CB, # G+1491  U+51CB  uni51CB,  CJK UNIFIED IDEOGRAPH-51CB
        0x5201, # G+1492  U+5201  uni5201,  CJK UNIFIED IDEOGRAPH-5201
        0x6389, # G+1493  U+6389  uni6389,  CJK UNIFIED IDEOGRAPH-6389
        0x540A, # G+1494  U+540A  uni540A,  CJK UNIFIED IDEOGRAPH-540A
        0x9493, # G+1495  U+9493  uni9493,  CJK UNIFIED IDEOGRAPH-9493
        0x8C03, # G+1496  U+8C03  uni8C03,  CJK UNIFIED IDEOGRAPH-8C03
        0x8DCC, # G+1497  U+8DCC  uni8DCC,  CJK UNIFIED IDEOGRAPH-8DCC
        0x7239, # G+1498  U+7239  uni7239,  CJK UNIFIED IDEOGRAPH-7239
        0x789F, # G+1499  U+789F  uni789F,  CJK UNIFIED IDEOGRAPH-789F
        0x8776, # G+1500  U+8776  uni8776,  CJK UNIFIED IDEOGRAPH-8776
        0x8FED, # G+1501  U+8FED  uni8FED,  CJK UNIFIED IDEOGRAPH-8FED
        0x8C0D, # G+1502  U+8C0D  uni8C0D,  CJK UNIFIED IDEOGRAPH-8C0D
        0x53E0, # G+1503  U+53E0  uni53E0,  CJK UNIFIED IDEOGRAPH-53E0
        0x4E01, # G+1504  U+4E01  uni4E01,  CJK UNIFIED IDEOGRAPH-4E01
        0x76EF, # G+1505  U+76EF  uni76EF,  CJK UNIFIED IDEOGRAPH-76EF
        0x53EE, # G+1506  U+53EE  uni53EE,  CJK UNIFIED IDEOGRAPH-53EE
        0x9489, # G+1507  U+9489  uni9489,  CJK UNIFIED IDEOGRAPH-9489
        0x9876, # G+1508  U+9876  uni9876,  CJK UNIFIED IDEOGRAPH-9876
        0x2FCD, # G+1509  U+2FCD  uni2FCD,  KANGXI RADICAL TRIPOD
        0x952D, # G+1510  U+952D  uni952D,  CJK UNIFIED IDEOGRAPH-952D
        0x5B9A, # G+1511  U+5B9A  uni5B9A,  CJK UNIFIED IDEOGRAPH-5B9A
        0x8BA2, # G+1512  U+8BA2  uni8BA2,  CJK UNIFIED IDEOGRAPH-8BA2
        0x4E22, # G+1513  U+4E22  uni4E22,  CJK UNIFIED IDEOGRAPH-4E22
        0x4E1C, # G+1514  U+4E1C  uni4E1C,  CJK UNIFIED IDEOGRAPH-4E1C
        0x51AC, # G+1515  U+51AC  uni51AC,  CJK UNIFIED IDEOGRAPH-51AC
        0x8463, # G+1516  U+8463  uni8463,  CJK UNIFIED IDEOGRAPH-8463
        0x61C2, # G+1517  U+61C2  uni61C2,  CJK UNIFIED IDEOGRAPH-61C2
        0x52A8, # G+1518  U+52A8  uni52A8,  CJK UNIFIED IDEOGRAPH-52A8
        0x680B, # G+1519  U+680B  uni680B,  CJK UNIFIED IDEOGRAPH-680B
        0x4F97, # G+1520  U+4F97  uni4F97,  CJK UNIFIED IDEOGRAPH-4F97
        0x606B, # G+1521  U+606B  uni606B,  CJK UNIFIED IDEOGRAPH-606B
        0x51BB, # G+1522  U+51BB  uni51BB,  CJK UNIFIED IDEOGRAPH-51BB
        0x6D1E, # G+1523  U+6D1E  uni6D1E,  CJK UNIFIED IDEOGRAPH-6D1E
        0x515C, # G+1524  U+515C  uni515C,  CJK UNIFIED IDEOGRAPH-515C
        0x6296, # G+1525  U+6296  uni6296,  CJK UNIFIED IDEOGRAPH-6296
        0x2F43, # G+1526  U+2F43  uni2F43,  KANGXI RADICAL DIPPER
        0x9661, # G+1527  U+9661  uni9661,  CJK UNIFIED IDEOGRAPH-9661
        0x2F96, # G+1528  U+2F96  uni2F96,  KANGXI RADICAL BEAN
        0x9017, # G+1529  U+9017  uni9017,  CJK UNIFIED IDEOGRAPH-9017
        0x75D8, # G+1530  U+75D8  uni75D8,  CJK UNIFIED IDEOGRAPH-75D8
        0x90FD, # G+1531  U+90FD  uni90FD,  CJK UNIFIED IDEOGRAPH-90FD
        0x7763, # G+1532  U+7763  uni7763,  CJK UNIFIED IDEOGRAPH-7763
        0x6BD2, # G+1533  U+6BD2  uni6BD2,  CJK UNIFIED IDEOGRAPH-6BD2
        0x728A, # G+1534  U+728A  uni728A,  CJK UNIFIED IDEOGRAPH-728A
        0x72EC, # G+1535  U+72EC  uni72EC,  CJK UNIFIED IDEOGRAPH-72EC
        0x8BFB, # G+1536  U+8BFB  uni8BFB,  CJK UNIFIED IDEOGRAPH-8BFB
        0x5835, # G+1537  U+5835  uni5835,  CJK UNIFIED IDEOGRAPH-5835
        0x7779, # G+1538  U+7779  uni7779,  CJK UNIFIED IDEOGRAPH-7779
        0x8D4C, # G+1539  U+8D4C  uni8D4C,  CJK UNIFIED IDEOGRAPH-8D4C
        0x675C, # G+1540  U+675C  uni675C,  CJK UNIFIED IDEOGRAPH-675C
        0x9540, # G+1541  U+9540  uni9540,  CJK UNIFIED IDEOGRAPH-9540
        0x809A, # G+1542  U+809A  uni809A,  CJK UNIFIED IDEOGRAPH-809A
        0x5EA6, # G+1543  U+5EA6  uni5EA6,  CJK UNIFIED IDEOGRAPH-5EA6
        0x6E21, # G+1544  U+6E21  uni6E21,  CJK UNIFIED IDEOGRAPH-6E21
        0x5992, # G+1545  U+5992  uni5992,  CJK UNIFIED IDEOGRAPH-5992
        0x7AEF, # G+1546  U+7AEF  uni7AEF,  CJK UNIFIED IDEOGRAPH-7AEF
        0x77ED, # G+1547  U+77ED  uni77ED,  CJK UNIFIED IDEOGRAPH-77ED
        0x953B, # G+1548  U+953B  uni953B,  CJK UNIFIED IDEOGRAPH-953B
        0x6BB5, # G+1549  U+6BB5  uni6BB5,  CJK UNIFIED IDEOGRAPH-6BB5
        0x65AD, # G+1550  U+65AD  uni65AD,  CJK UNIFIED IDEOGRAPH-65AD
        0x7F0E, # G+1551  U+7F0E  uni7F0E,  CJK UNIFIED IDEOGRAPH-7F0E
        0x5806, # G+1552  U+5806  uni5806,  CJK UNIFIED IDEOGRAPH-5806
        0x5151, # G+1553  U+5151  uni5151,  CJK UNIFIED IDEOGRAPH-5151
        0x961F, # G+1554  U+961F  uni961F,  CJK UNIFIED IDEOGRAPH-961F
        0x5BF9, # G+1555  U+5BF9  uni5BF9,  CJK UNIFIED IDEOGRAPH-5BF9
        0x58A9, # G+1556  U+58A9  uni58A9,  CJK UNIFIED IDEOGRAPH-58A9
        0x5428, # G+1557  U+5428  uni5428,  CJK UNIFIED IDEOGRAPH-5428
        0x8E72, # G+1558  U+8E72  uni8E72,  CJK UNIFIED IDEOGRAPH-8E72
        0x6566, # G+1559  U+6566  uni6566,  CJK UNIFIED IDEOGRAPH-6566
        0x987F, # G+1560  U+987F  uni987F,  CJK UNIFIED IDEOGRAPH-987F
        0x56E4, # G+1561  U+56E4  uni56E4,  CJK UNIFIED IDEOGRAPH-56E4
        0x949D, # G+1562  U+949D  uni949D,  CJK UNIFIED IDEOGRAPH-949D
        0x76FE, # G+1563  U+76FE  uni76FE,  CJK UNIFIED IDEOGRAPH-76FE
        0x9041, # G+1564  U+9041  uni9041,  CJK UNIFIED IDEOGRAPH-9041
        0x6387, # G+1565  U+6387  uni6387,  CJK UNIFIED IDEOGRAPH-6387
        0x54C6, # G+1566  U+54C6  uni54C6,  CJK UNIFIED IDEOGRAPH-54C6
        0x591A, # G+1567  U+591A  uni591A,  CJK UNIFIED IDEOGRAPH-591A
        0x593A, # G+1568  U+593A  uni593A,  CJK UNIFIED IDEOGRAPH-593A
        0x579B, # G+1569  U+579B  uni579B,  CJK UNIFIED IDEOGRAPH-579B
        0x8EB2, # G+1570  U+8EB2  uni8EB2,  CJK UNIFIED IDEOGRAPH-8EB2
        0x6735, # G+1571  U+6735  uni6735,  CJK UNIFIED IDEOGRAPH-6735
        0x8DFA, # G+1572  U+8DFA  uni8DFA,  CJK UNIFIED IDEOGRAPH-8DFA
        0x8235, # G+1573  U+8235  uni8235,  CJK UNIFIED IDEOGRAPH-8235
        0x5241, # G+1574  U+5241  uni5241,  CJK UNIFIED IDEOGRAPH-5241
        0x60F0, # G+1575  U+60F0  uni60F0,  CJK UNIFIED IDEOGRAPH-60F0
        0x5815, # G+1576  U+5815  uni5815,  CJK UNIFIED IDEOGRAPH-5815
        0x86FE, # G+1577  U+86FE  uni86FE,  CJK UNIFIED IDEOGRAPH-86FE
        0x5CE8, # G+1578  U+5CE8  uni5CE8,  CJK UNIFIED IDEOGRAPH-5CE8
        0x9E45, # G+1579  U+9E45  uni9E45,  CJK UNIFIED IDEOGRAPH-9E45
        0x4FC4, # G+1580  U+4FC4  uni4FC4,  CJK UNIFIED IDEOGRAPH-4FC4
        0x989D, # G+1581  U+989D  uni989D,  CJK UNIFIED IDEOGRAPH-989D
        0x8BB9, # G+1582  U+8BB9  uni8BB9,  CJK UNIFIED IDEOGRAPH-8BB9
        0x5A25, # G+1583  U+5A25  uni5A25,  CJK UNIFIED IDEOGRAPH-5A25
        0x6076, # G+1584  U+6076  uni6076,  CJK UNIFIED IDEOGRAPH-6076
        0x5384, # G+1585  U+5384  uni5384,  CJK UNIFIED IDEOGRAPH-5384
        0x627C, # G+1586  U+627C  uni627C,  CJK UNIFIED IDEOGRAPH-627C
        0x904F, # G+1587  U+904F  uni904F,  CJK UNIFIED IDEOGRAPH-904F
        0x9102, # G+1588  U+9102  uni9102,  CJK UNIFIED IDEOGRAPH-9102
        0x997F, # G+1589  U+997F  uni997F,  CJK UNIFIED IDEOGRAPH-997F
        0x6069, # G+1590  U+6069  uni6069,  CJK UNIFIED IDEOGRAPH-6069
        0x2F7D, # G+1591  U+2F7D  uni2F7D,  KANGXI RADICAL AND
        0x2F09, # G+1592  U+2F09  uni2F09,  KANGXI RADICAL LEGS
        0x2F7F, # G+1593  U+2F7F  uni2F7F,  KANGXI RADICAL EAR
        0x5C14, # G+1594  U+5C14  uni5C14,  CJK UNIFIED IDEOGRAPH-5C14
        0x9975, # G+1595  U+9975  uni9975,  CJK UNIFIED IDEOGRAPH-9975
        0x6D31, # G+1596  U+6D31  uni6D31,  CJK UNIFIED IDEOGRAPH-6D31
        0x2F06, # G+1597  U+2F06  uni2F06,  KANGXI RADICAL TWO
        0x8D30, # G+1598  U+8D30  uni8D30,  CJK UNIFIED IDEOGRAPH-8D30
        0x53D1, # G+1599  U+53D1  uni53D1,  CJK UNIFIED IDEOGRAPH-53D1
        0x7F5A, # G+1600  U+7F5A  uni7F5A,  CJK UNIFIED IDEOGRAPH-7F5A
        0x7B4F, # G+1601  U+7B4F  uni7B4F,  CJK UNIFIED IDEOGRAPH-7B4F
        0x4F10, # G+1602  U+4F10  uni4F10,  CJK UNIFIED IDEOGRAPH-4F10
        0x4E4F, # G+1603  U+4E4F  uni4E4F,  CJK UNIFIED IDEOGRAPH-4E4F
        0x9600, # G+1604  U+9600  uni9600,  CJK UNIFIED IDEOGRAPH-9600
        0x6CD5, # G+1605  U+6CD5  uni6CD5,  CJK UNIFIED IDEOGRAPH-6CD5
        0x73D0, # G+1606  U+73D0  uni73D0,  CJK UNIFIED IDEOGRAPH-73D0
        0x85E9, # G+1607  U+85E9  uni85E9,  CJK UNIFIED IDEOGRAPH-85E9
        0x5E06, # G+1608  U+5E06  uni5E06,  CJK UNIFIED IDEOGRAPH-5E06
        0x756A, # G+1609  U+756A  uni756A,  CJK UNIFIED IDEOGRAPH-756A
        0x7FFB, # G+1610  U+7FFB  uni7FFB,  CJK UNIFIED IDEOGRAPH-7FFB
        0x6A0A, # G+1611  U+6A0A  uni6A0A,  CJK UNIFIED IDEOGRAPH-6A0A
        0x77FE, # G+1612  U+77FE  uni77FE,  CJK UNIFIED IDEOGRAPH-77FE
        0x9492, # G+1613  U+9492  uni9492,  CJK UNIFIED IDEOGRAPH-9492
        0x7E41, # G+1614  U+7E41  uni7E41,  CJK UNIFIED IDEOGRAPH-7E41
        0x51E1, # G+1615  U+51E1  uni51E1,  CJK UNIFIED IDEOGRAPH-51E1
        0x70E6, # G+1616  U+70E6  uni70E6,  CJK UNIFIED IDEOGRAPH-70E6
        0x53CD, # G+1617  U+53CD  uni53CD,  CJK UNIFIED IDEOGRAPH-53CD
        0x8FD4, # G+1618  U+8FD4  uni8FD4,  CJK UNIFIED IDEOGRAPH-8FD4
        0x8303, # G+1619  U+8303  uni8303,  CJK UNIFIED IDEOGRAPH-8303
        0x8D29, # G+1620  U+8D29  uni8D29,  CJK UNIFIED IDEOGRAPH-8D29
        0x72AF, # G+1621  U+72AF  uni72AF,  CJK UNIFIED IDEOGRAPH-72AF
        0x996D, # G+1622  U+996D  uni996D,  CJK UNIFIED IDEOGRAPH-996D
        0x6CDB, # G+1623  U+6CDB  uni6CDB,  CJK UNIFIED IDEOGRAPH-6CDB
        0x574A, # G+1624  U+574A  uni574A,  CJK UNIFIED IDEOGRAPH-574A
        0x82B3, # G+1625  U+82B3  uni82B3,  CJK UNIFIED IDEOGRAPH-82B3
        0x2F45, # G+1626  U+2F45  uni2F45,  KANGXI RADICAL SQUARE
        0x80AA, # G+1627  U+80AA  uni80AA,  CJK UNIFIED IDEOGRAPH-80AA
        0x623F, # G+1628  U+623F  uni623F,  CJK UNIFIED IDEOGRAPH-623F
        0x9632, # G+1629  U+9632  uni9632,  CJK UNIFIED IDEOGRAPH-9632
        0x59A8, # G+1630  U+59A8  uni59A8,  CJK UNIFIED IDEOGRAPH-59A8
        0x4EFF, # G+1631  U+4EFF  uni4EFF,  CJK UNIFIED IDEOGRAPH-4EFF
        0x8BBF, # G+1632  U+8BBF  uni8BBF,  CJK UNIFIED IDEOGRAPH-8BBF
        0x7EBA, # G+1633  U+7EBA  uni7EBA,  CJK UNIFIED IDEOGRAPH-7EBA
        0x653E, # G+1634  U+653E  uni653E,  CJK UNIFIED IDEOGRAPH-653E
        0x83F2, # G+1635  U+83F2  uni83F2,  CJK UNIFIED IDEOGRAPH-83F2
        0x2FAE, # G+1636  U+2FAE  uni2FAE,  KANGXI RADICAL WRONG
        0x5561, # G+1637  U+5561  uni5561,  CJK UNIFIED IDEOGRAPH-5561
        0x98DE, # G+1638  U+98DE  uni98DE,  CJK UNIFIED IDEOGRAPH-98DE
        0x80A5, # G+1639  U+80A5  uni80A5,  CJK UNIFIED IDEOGRAPH-80A5
        0x532A, # G+1640  U+532A  uni532A,  CJK UNIFIED IDEOGRAPH-532A
        0x8BFD, # G+1641  U+8BFD  uni8BFD,  CJK UNIFIED IDEOGRAPH-8BFD
        0x5420, # G+1642  U+5420  uni5420,  CJK UNIFIED IDEOGRAPH-5420
        0x80BA, # G+1643  U+80BA  uni80BA,  CJK UNIFIED IDEOGRAPH-80BA
        0x5E9F, # G+1644  U+5E9F  uni5E9F,  CJK UNIFIED IDEOGRAPH-5E9F
        0x6CB8, # G+1645  U+6CB8  uni6CB8,  CJK UNIFIED IDEOGRAPH-6CB8
        0x8D39, # G+1646  U+8D39  uni8D39,  CJK UNIFIED IDEOGRAPH-8D39
        0x82AC, # G+1647  U+82AC  uni82AC,  CJK UNIFIED IDEOGRAPH-82AC
        0x915A, # G+1648  U+915A  uni915A,  CJK UNIFIED IDEOGRAPH-915A
        0x5429, # G+1649  U+5429  uni5429,  CJK UNIFIED IDEOGRAPH-5429
        0x6C1B, # G+1650  U+6C1B  uni6C1B,  CJK UNIFIED IDEOGRAPH-6C1B
        0x5206, # G+1651  U+5206  uni5206,  CJK UNIFIED IDEOGRAPH-5206
        0x7EB7, # G+1652  U+7EB7  uni7EB7,  CJK UNIFIED IDEOGRAPH-7EB7
        0x575F, # G+1653  U+575F  uni575F,  CJK UNIFIED IDEOGRAPH-575F
        0x711A, # G+1654  U+711A  uni711A,  CJK UNIFIED IDEOGRAPH-711A
        0x6C7E, # G+1655  U+6C7E  uni6C7E,  CJK UNIFIED IDEOGRAPH-6C7E
        0x7C89, # G+1656  U+7C89  uni7C89,  CJK UNIFIED IDEOGRAPH-7C89
        0x594B, # G+1657  U+594B  uni594B,  CJK UNIFIED IDEOGRAPH-594B
        0x4EFD, # G+1658  U+4EFD  uni4EFD,  CJK UNIFIED IDEOGRAPH-4EFD
        0x5FFF, # G+1659  U+5FFF  uni5FFF,  CJK UNIFIED IDEOGRAPH-5FFF
        0x6124, # G+1660  U+6124  uni6124,  CJK UNIFIED IDEOGRAPH-6124
        0x7CAA, # G+1661  U+7CAA  uni7CAA,  CJK UNIFIED IDEOGRAPH-7CAA
        0x4E30, # G+1662  U+4E30  uni4E30,  CJK UNIFIED IDEOGRAPH-4E30
        0x5C01, # G+1663  U+5C01  uni5C01,  CJK UNIFIED IDEOGRAPH-5C01
        0x67AB, # G+1664  U+67AB  uni67AB,  CJK UNIFIED IDEOGRAPH-67AB
        0x8702, # G+1665  U+8702  uni8702,  CJK UNIFIED IDEOGRAPH-8702
        0x5CF0, # G+1666  U+5CF0  uni5CF0,  CJK UNIFIED IDEOGRAPH-5CF0
        0x950B, # G+1667  U+950B  uni950B,  CJK UNIFIED IDEOGRAPH-950B
        0x98CE, # G+1668  U+98CE  uni98CE,  CJK UNIFIED IDEOGRAPH-98CE
        0x75AF, # G+1669  U+75AF  uni75AF,  CJK UNIFIED IDEOGRAPH-75AF
        0x70FD, # G+1670  U+70FD  uni70FD,  CJK UNIFIED IDEOGRAPH-70FD
        0x9022, # G+1671  U+9022  uni9022,  CJK UNIFIED IDEOGRAPH-9022
        0x51AF, # G+1672  U+51AF  uni51AF,  CJK UNIFIED IDEOGRAPH-51AF
        0x7F1D, # G+1673  U+7F1D  uni7F1D,  CJK UNIFIED IDEOGRAPH-7F1D
        0x8BBD, # G+1674  U+8BBD  uni8BBD,  CJK UNIFIED IDEOGRAPH-8BBD
        0x5949, # G+1675  U+5949  uni5949,  CJK UNIFIED IDEOGRAPH-5949
        0x51E4, # G+1676  U+51E4  uni51E4,  CJK UNIFIED IDEOGRAPH-51E4
        0x4F5B, # G+1677  U+4F5B  uni4F5B,  CJK UNIFIED IDEOGRAPH-4F5B
        0x5426, # G+1678  U+5426  uni5426,  CJK UNIFIED IDEOGRAPH-5426
        0x592B, # G+1679  U+592B  uni592B,  CJK UNIFIED IDEOGRAPH-592B
        0x6577, # G+1680  U+6577  uni6577,  CJK UNIFIED IDEOGRAPH-6577
        0x80A4, # G+1681  U+80A4  uni80A4,  CJK UNIFIED IDEOGRAPH-80A4
        0x5B75, # G+1682  U+5B75  uni5B75,  CJK UNIFIED IDEOGRAPH-5B75
        0x6276, # G+1683  U+6276  uni6276,  CJK UNIFIED IDEOGRAPH-6276
        0x62C2, # G+1684  U+62C2  uni62C2,  CJK UNIFIED IDEOGRAPH-62C2
        0x8F90, # G+1685  U+8F90  uni8F90,  CJK UNIFIED IDEOGRAPH-8F90
        0x5E45, # G+1686  U+5E45  uni5E45,  CJK UNIFIED IDEOGRAPH-5E45
        0x6C1F, # G+1687  U+6C1F  uni6C1F,  CJK UNIFIED IDEOGRAPH-6C1F
        0x7B26, # G+1688  U+7B26  uni7B26,  CJK UNIFIED IDEOGRAPH-7B26
        0x4F0F, # G+1689  U+4F0F  uni4F0F,  CJK UNIFIED IDEOGRAPH-4F0F
        0x4FD8, # G+1690  U+4FD8  uni4FD8,  CJK UNIFIED IDEOGRAPH-4FD8
        0x670D, # G+1691  U+670D  uni670D,  CJK UNIFIED IDEOGRAPH-670D
        0x6D6E, # G+1692  U+6D6E  uni6D6E,  CJK UNIFIED IDEOGRAPH-6D6E
        0x6DAA, # G+1693  U+6DAA  uni6DAA,  CJK UNIFIED IDEOGRAPH-6DAA
        0x798F, # G+1694  U+798F  uni798F,  CJK UNIFIED IDEOGRAPH-798F
        0x88B1, # G+1695  U+88B1  uni88B1,  CJK UNIFIED IDEOGRAPH-88B1
        0x5F17, # G+1696  U+5F17  uni5F17,  CJK UNIFIED IDEOGRAPH-5F17
        0x752B, # G+1697  U+752B  uni752B,  CJK UNIFIED IDEOGRAPH-752B
        0x629A, # G+1698  U+629A  uni629A,  CJK UNIFIED IDEOGRAPH-629A
        0x8F85, # G+1699  U+8F85  uni8F85,  CJK UNIFIED IDEOGRAPH-8F85
        0x4FEF, # G+1700  U+4FEF  uni4FEF,  CJK UNIFIED IDEOGRAPH-4FEF
        0x91DC, # G+1701  U+91DC  uni91DC,  CJK UNIFIED IDEOGRAPH-91DC
        0x65A7, # G+1702  U+65A7  uni65A7,  CJK UNIFIED IDEOGRAPH-65A7
        0x812F, # G+1703  U+812F  uni812F,  CJK UNIFIED IDEOGRAPH-812F
        0x8151, # G+1704  U+8151  uni8151,  CJK UNIFIED IDEOGRAPH-8151
        0x5E9C, # G+1705  U+5E9C  uni5E9C,  CJK UNIFIED IDEOGRAPH-5E9C
        0x8150, # G+1706  U+8150  uni8150,  CJK UNIFIED IDEOGRAPH-8150
        0x8D74, # G+1707  U+8D74  uni8D74,  CJK UNIFIED IDEOGRAPH-8D74
        0x526F, # G+1708  U+526F  uni526F,  CJK UNIFIED IDEOGRAPH-526F
        0x8986, # G+1709  U+8986  uni8986,  CJK UNIFIED IDEOGRAPH-8986
        0x8D4B, # G+1710  U+8D4B  uni8D4B,  CJK UNIFIED IDEOGRAPH-8D4B
        0x590D, # G+1711  U+590D  uni590D,  CJK UNIFIED IDEOGRAPH-590D
        0x5085, # G+1712  U+5085  uni5085,  CJK UNIFIED IDEOGRAPH-5085
        0x4ED8, # G+1713  U+4ED8  uni4ED8,  CJK UNIFIED IDEOGRAPH-4ED8
        0x2FA9, # G+1714  U+2FA9  uni2FA9,  KANGXI RADICAL MOUND
        0x2F57, # G+1715  U+2F57  uni2F57,  KANGXI RADICAL FATHER
        0x8179, # G+1716  U+8179  uni8179,  CJK UNIFIED IDEOGRAPH-8179
        0x8D1F, # G+1717  U+8D1F  uni8D1F,  CJK UNIFIED IDEOGRAPH-8D1F
        0x5BCC, # G+1718  U+5BCC  uni5BCC,  CJK UNIFIED IDEOGRAPH-5BCC
        0x8BA3, # G+1719  U+8BA3  uni8BA3,  CJK UNIFIED IDEOGRAPH-8BA3
        0x9644, # G+1720  U+9644  uni9644,  CJK UNIFIED IDEOGRAPH-9644
        0x5987, # G+1721  U+5987  uni5987,  CJK UNIFIED IDEOGRAPH-5987
        0x7F1A, # G+1722  U+7F1A  uni7F1A,  CJK UNIFIED IDEOGRAPH-7F1A
        0x5490, # G+1723  U+5490  uni5490,  CJK UNIFIED IDEOGRAPH-5490
        0x5676, # G+1724  U+5676  uni5676,  CJK UNIFIED IDEOGRAPH-5676
        0x560E, # G+1725  U+560E  uni560E,  CJK UNIFIED IDEOGRAPH-560E
        0x8BE5, # G+1726  U+8BE5  uni8BE5,  CJK UNIFIED IDEOGRAPH-8BE5
        0x6539, # G+1727  U+6539  uni6539,  CJK UNIFIED IDEOGRAPH-6539
        0x6982, # G+1728  U+6982  uni6982,  CJK UNIFIED IDEOGRAPH-6982
        0x9499, # G+1729  U+9499  uni9499,  CJK UNIFIED IDEOGRAPH-9499
        0x76D6, # G+1730  U+76D6  uni76D6,  CJK UNIFIED IDEOGRAPH-76D6
        0x6E89, # G+1731  U+6E89  uni6E89,  CJK UNIFIED IDEOGRAPH-6E89
        0x2F32, # G+1732  U+2F32  uni2F32,  KANGXI RADICAL DRY
        0x2F62, # G+1733  U+2F62  uni2F62,  KANGXI RADICAL SWEET
        0x6746, # G+1734  U+6746  uni6746,  CJK UNIFIED IDEOGRAPH-6746
        0x67D1, # G+1735  U+67D1  uni67D1,  CJK UNIFIED IDEOGRAPH-67D1
        0x7AFF, # G+1736  U+7AFF  uni7AFF,  CJK UNIFIED IDEOGRAPH-7AFF
        0x809D, # G+1737  U+809D  uni809D,  CJK UNIFIED IDEOGRAPH-809D
        0x8D76, # G+1738  U+8D76  uni8D76,  CJK UNIFIED IDEOGRAPH-8D76
        0x611F, # G+1739  U+611F  uni611F,  CJK UNIFIED IDEOGRAPH-611F
        0x79C6, # G+1740  U+79C6  uni79C6,  CJK UNIFIED IDEOGRAPH-79C6
        0x6562, # G+1741  U+6562  uni6562,  CJK UNIFIED IDEOGRAPH-6562
        0x8D63, # G+1742  U+8D63  uni8D63,  CJK UNIFIED IDEOGRAPH-8D63
        0x5188, # G+1743  U+5188  uni5188,  CJK UNIFIED IDEOGRAPH-5188
        0x521A, # G+1744  U+521A  uni521A,  CJK UNIFIED IDEOGRAPH-521A
        0x94A2, # G+1745  U+94A2  uni94A2,  CJK UNIFIED IDEOGRAPH-94A2
        0x7F38, # G+1746  U+7F38  uni7F38,  CJK UNIFIED IDEOGRAPH-7F38
        0x809B, # G+1747  U+809B  uni809B,  CJK UNIFIED IDEOGRAPH-809B
        0x7EB2, # G+1748  U+7EB2  uni7EB2,  CJK UNIFIED IDEOGRAPH-7EB2
        0x5C97, # G+1749  U+5C97  uni5C97,  CJK UNIFIED IDEOGRAPH-5C97
        0x6E2F, # G+1750  U+6E2F  uni6E2F,  CJK UNIFIED IDEOGRAPH-6E2F
        0x6760, # G+1751  U+6760  uni6760,  CJK UNIFIED IDEOGRAPH-6760
        0x7BD9, # G+1752  U+7BD9  uni7BD9,  CJK UNIFIED IDEOGRAPH-7BD9
        0x768B, # G+1753  U+768B  uni768B,  CJK UNIFIED IDEOGRAPH-768B
        0x2FBC, # G+1754  U+2FBC  uni2FBC,  KANGXI RADICAL TALL
        0x818F, # G+1755  U+818F  uni818F,  CJK UNIFIED IDEOGRAPH-818F
        0x7F94, # G+1756  U+7F94  uni7F94,  CJK UNIFIED IDEOGRAPH-7F94
        0x7CD5, # G+1757  U+7CD5  uni7CD5,  CJK UNIFIED IDEOGRAPH-7CD5
        0x641E, # G+1758  U+641E  uni641E,  CJK UNIFIED IDEOGRAPH-641E
        0x9550, # G+1759  U+9550  uni9550,  CJK UNIFIED IDEOGRAPH-9550
        0x7A3F, # G+1760  U+7A3F  uni7A3F,  CJK UNIFIED IDEOGRAPH-7A3F
        0x544A, # G+1761  U+544A  uni544A,  CJK UNIFIED IDEOGRAPH-544A
        0x54E5, # G+1762  U+54E5  uni54E5,  CJK UNIFIED IDEOGRAPH-54E5
        0x6B4C, # G+1763  U+6B4C  uni6B4C,  CJK UNIFIED IDEOGRAPH-6B4C
        0x6401, # G+1764  U+6401  uni6401,  CJK UNIFIED IDEOGRAPH-6401
        0x2F3D, # G+1765  U+2F3D  uni2F3D,  KANGXI RADICAL HALBERD
        0x9E3D, # G+1766  U+9E3D  uni9E3D,  CJK UNIFIED IDEOGRAPH-9E3D
        0x80F3, # G+1767  U+80F3  uni80F3,  CJK UNIFIED IDEOGRAPH-80F3
        0x7599, # G+1768  U+7599  uni7599,  CJK UNIFIED IDEOGRAPH-7599
        0x5272, # G+1769  U+5272  uni5272,  CJK UNIFIED IDEOGRAPH-5272
        0x2FB0, # G+1770  U+2FB0  uni2FB0,  KANGXI RADICAL LEATHER
        0x845B, # G+1771  U+845B  uni845B,  CJK UNIFIED IDEOGRAPH-845B
        0x683C, # G+1772  U+683C  uni683C,  CJK UNIFIED IDEOGRAPH-683C
        0x86E4, # G+1773  U+86E4  uni86E4,  CJK UNIFIED IDEOGRAPH-86E4
        0x9601, # G+1774  U+9601  uni9601,  CJK UNIFIED IDEOGRAPH-9601
        0x9694, # G+1775  U+9694  uni9694,  CJK UNIFIED IDEOGRAPH-9694
        0x94EC, # G+1776  U+94EC  uni94EC,  CJK UNIFIED IDEOGRAPH-94EC
        0x4E2A, # G+1777  U+4E2A  uni4E2A,  CJK UNIFIED IDEOGRAPH-4E2A
        0x5404, # G+1778  U+5404  uni5404,  CJK UNIFIED IDEOGRAPH-5404
        0x7ED9, # G+1779  U+7ED9  uni7ED9,  CJK UNIFIED IDEOGRAPH-7ED9
        0x6839, # G+1780  U+6839  uni6839,  CJK UNIFIED IDEOGRAPH-6839
        0x8DDF, # G+1781  U+8DDF  uni8DDF,  CJK UNIFIED IDEOGRAPH-8DDF
        0x8015, # G+1782  U+8015  uni8015,  CJK UNIFIED IDEOGRAPH-8015
        0x66F4, # G+1783  U+66F4  uni66F4,  CJK UNIFIED IDEOGRAPH-66F4
        0x5E9A, # G+1784  U+5E9A  uni5E9A,  CJK UNIFIED IDEOGRAPH-5E9A
        0x7FB9, # G+1785  U+7FB9  uni7FB9,  CJK UNIFIED IDEOGRAPH-7FB9
        0x57C2, # G+1786  U+57C2  uni57C2,  CJK UNIFIED IDEOGRAPH-57C2
        0x803F, # G+1787  U+803F  uni803F,  CJK UNIFIED IDEOGRAPH-803F
        0x6897, # G+1788  U+6897  uni6897,  CJK UNIFIED IDEOGRAPH-6897
        0x2F2F, # G+1789  U+2F2F  uni2F2F,  KANGXI RADICAL WORK
        0x653B, # G+1790  U+653B  uni653B,  CJK UNIFIED IDEOGRAPH-653B
        0x529F, # G+1791  U+529F  uni529F,  CJK UNIFIED IDEOGRAPH-529F
        0x606D, # G+1792  U+606D  uni606D,  CJK UNIFIED IDEOGRAPH-606D
        0x9F9A, # G+1793  U+9F9A  uni9F9A,  CJK UNIFIED IDEOGRAPH-9F9A
        0x4F9B, # G+1794  U+4F9B  uni4F9B,  CJK UNIFIED IDEOGRAPH-4F9B
        0x8EAC, # G+1795  U+8EAC  uni8EAC,  CJK UNIFIED IDEOGRAPH-8EAC
        0x516C, # G+1796  U+516C  uni516C,  CJK UNIFIED IDEOGRAPH-516C
        0x5BAB, # G+1797  U+5BAB  uni5BAB,  CJK UNIFIED IDEOGRAPH-5BAB
        0x2F38, # G+1798  U+2F38  uni2F38,  KANGXI RADICAL BOW
        0x5DE9, # G+1799  U+5DE9  uni5DE9,  CJK UNIFIED IDEOGRAPH-5DE9
        0x6C5E, # G+1800  U+6C5E  uni6C5E,  CJK UNIFIED IDEOGRAPH-6C5E
        0x62F1, # G+1801  U+62F1  uni62F1,  CJK UNIFIED IDEOGRAPH-62F1
        0x8D21, # G+1802  U+8D21  uni8D21,  CJK UNIFIED IDEOGRAPH-8D21
        0x5171, # G+1803  U+5171  uni5171,  CJK UNIFIED IDEOGRAPH-5171
        0x94A9, # G+1804  U+94A9  uni94A9,  CJK UNIFIED IDEOGRAPH-94A9
        0x52FE, # G+1805  U+52FE  uni52FE,  CJK UNIFIED IDEOGRAPH-52FE
        0x6C9F, # G+1806  U+6C9F  uni6C9F,  CJK UNIFIED IDEOGRAPH-6C9F
        0x82DF, # G+1807  U+82DF  uni82DF,  CJK UNIFIED IDEOGRAPH-82DF
        0x72D7, # G+1808  U+72D7  uni72D7,  CJK UNIFIED IDEOGRAPH-72D7
        0x57A2, # G+1809  U+57A2  uni57A2,  CJK UNIFIED IDEOGRAPH-57A2
        0x6784, # G+1810  U+6784  uni6784,  CJK UNIFIED IDEOGRAPH-6784
        0x8D2D, # G+1811  U+8D2D  uni8D2D,  CJK UNIFIED IDEOGRAPH-8D2D
        0x591F, # G+1812  U+591F  uni591F,  CJK UNIFIED IDEOGRAPH-591F
        0x8F9C, # G+1813  U+8F9C  uni8F9C,  CJK UNIFIED IDEOGRAPH-8F9C
        0x83C7, # G+1814  U+83C7  uni83C7,  CJK UNIFIED IDEOGRAPH-83C7
        0x5495, # G+1815  U+5495  uni5495,  CJK UNIFIED IDEOGRAPH-5495
        0x7B8D, # G+1816  U+7B8D  uni7B8D,  CJK UNIFIED IDEOGRAPH-7B8D
        0x4F30, # G+1817  U+4F30  uni4F30,  CJK UNIFIED IDEOGRAPH-4F30
        0x6CBD, # G+1818  U+6CBD  uni6CBD,  CJK UNIFIED IDEOGRAPH-6CBD
        0x5B64, # G+1819  U+5B64  uni5B64,  CJK UNIFIED IDEOGRAPH-5B64
        0x59D1, # G+1820  U+59D1  uni59D1,  CJK UNIFIED IDEOGRAPH-59D1
        0x2FCE, # G+1821  U+2FCE  uni2FCE,  KANGXI RADICAL DRUM
        0x53E4, # G+1822  U+53E4  uni53E4,  CJK UNIFIED IDEOGRAPH-53E4
        0x86CA, # G+1823  U+86CA  uni86CA,  CJK UNIFIED IDEOGRAPH-86CA
        0x2FBB, # G+1824  U+2FBB  uni2FBB,  KANGXI RADICAL BONE
        0x2F95, # G+1825  U+2F95  uni2F95,  KANGXI RADICAL VALLEY
        0x80A1, # G+1826  U+80A1  uni80A1,  CJK UNIFIED IDEOGRAPH-80A1
        0x6545, # G+1827  U+6545  uni6545,  CJK UNIFIED IDEOGRAPH-6545
        0x987E, # G+1828  U+987E  uni987E,  CJK UNIFIED IDEOGRAPH-987E
        0x56FA, # G+1829  U+56FA  uni56FA,  CJK UNIFIED IDEOGRAPH-56FA
        0x96C7, # G+1830  U+96C7  uni96C7,  CJK UNIFIED IDEOGRAPH-96C7
        0x522E, # G+1831  U+522E  uni522E,  CJK UNIFIED IDEOGRAPH-522E
        0x2F60, # G+1832  U+2F60  uni2F60,  KANGXI RADICAL MELON
        0x5250, # G+1833  U+5250  uni5250,  CJK UNIFIED IDEOGRAPH-5250
        0x5BE1, # G+1834  U+5BE1  uni5BE1,  CJK UNIFIED IDEOGRAPH-5BE1
        0x6302, # G+1835  U+6302  uni6302,  CJK UNIFIED IDEOGRAPH-6302
        0x8902, # G+1836  U+8902  uni8902,  CJK UNIFIED IDEOGRAPH-8902
        0x4E56, # G+1837  U+4E56  uni4E56,  CJK UNIFIED IDEOGRAPH-4E56
        0x62D0, # G+1838  U+62D0  uni62D0,  CJK UNIFIED IDEOGRAPH-62D0
        0x602A, # G+1839  U+602A  uni602A,  CJK UNIFIED IDEOGRAPH-602A
        0x68FA, # G+1840  U+68FA  uni68FA,  CJK UNIFIED IDEOGRAPH-68FA
        0x5173, # G+1841  U+5173  uni5173,  CJK UNIFIED IDEOGRAPH-5173
        0x5B98, # G+1842  U+5B98  uni5B98,  CJK UNIFIED IDEOGRAPH-5B98
        0x51A0, # G+1843  U+51A0  uni51A0,  CJK UNIFIED IDEOGRAPH-51A0
        0x89C2, # G+1844  U+89C2  uni89C2,  CJK UNIFIED IDEOGRAPH-89C2
        0x7BA1, # G+1845  U+7BA1  uni7BA1,  CJK UNIFIED IDEOGRAPH-7BA1
        0x9986, # G+1846  U+9986  uni9986,  CJK UNIFIED IDEOGRAPH-9986
        0x7F50, # G+1847  U+7F50  uni7F50,  CJK UNIFIED IDEOGRAPH-7F50
        0x60EF, # G+1848  U+60EF  uni60EF,  CJK UNIFIED IDEOGRAPH-60EF
        0x704C, # G+1849  U+704C  uni704C,  CJK UNIFIED IDEOGRAPH-704C
        0x8D2F, # G+1850  U+8D2F  uni8D2F,  CJK UNIFIED IDEOGRAPH-8D2F
        0x5149, # G+1851  U+5149  uni5149,  CJK UNIFIED IDEOGRAPH-5149
        0x2F34, # G+1852  U+2F34  uni2F34,  KANGXI RADICAL DOTTED CLIFF
        0x901B, # G+1853  U+901B  uni901B,  CJK UNIFIED IDEOGRAPH-901B
        0x7470, # G+1854  U+7470  uni7470,  CJK UNIFIED IDEOGRAPH-7470
        0x89C4, # G+1855  U+89C4  uni89C4,  CJK UNIFIED IDEOGRAPH-89C4
        0x572D, # G+1856  U+572D  uni572D,  CJK UNIFIED IDEOGRAPH-572D
        0x7845, # G+1857  U+7845  uni7845,  CJK UNIFIED IDEOGRAPH-7845
        0x5F52, # G+1858  U+5F52  uni5F52,  CJK UNIFIED IDEOGRAPH-5F52
        0x9F9F, # G+1859  U+9F9F  uni9F9F,  CJK UNIFIED IDEOGRAPH-9F9F
        0x95FA, # G+1860  U+95FA  uni95FA,  CJK UNIFIED IDEOGRAPH-95FA
        0x8F68, # G+1861  U+8F68  uni8F68,  CJK UNIFIED IDEOGRAPH-8F68
        0x2FC1, # G+1862  U+2FC1  uni2FC1,  KANGXI RADICAL GHOST
        0x8BE1, # G+1863  U+8BE1  uni8BE1,  CJK UNIFIED IDEOGRAPH-8BE1
        0x7678, # G+1864  U+7678  uni7678,  CJK UNIFIED IDEOGRAPH-7678
        0x6842, # G+1865  U+6842  uni6842,  CJK UNIFIED IDEOGRAPH-6842
        0x67DC, # G+1866  U+67DC  uni67DC,  CJK UNIFIED IDEOGRAPH-67DC
        0x8DEA, # G+1867  U+8DEA  uni8DEA,  CJK UNIFIED IDEOGRAPH-8DEA
        0x8D35, # G+1868  U+8D35  uni8D35,  CJK UNIFIED IDEOGRAPH-8D35
        0x523D, # G+1869  U+523D  uni523D,  CJK UNIFIED IDEOGRAPH-523D
        0x8F8A, # G+1870  U+8F8A  uni8F8A,  CJK UNIFIED IDEOGRAPH-8F8A
        0x6EDA, # G+1871  U+6EDA  uni6EDA,  CJK UNIFIED IDEOGRAPH-6EDA
        0x68CD, # G+1872  U+68CD  uni68CD,  CJK UNIFIED IDEOGRAPH-68CD
        0x9505, # G+1873  U+9505  uni9505,  CJK UNIFIED IDEOGRAPH-9505
        0x90ED, # G+1874  U+90ED  uni90ED,  CJK UNIFIED IDEOGRAPH-90ED
        0x56FD, # G+1875  U+56FD  uni56FD,  CJK UNIFIED IDEOGRAPH-56FD
        0x679C, # G+1876  U+679C  uni679C,  CJK UNIFIED IDEOGRAPH-679C
        0x88F9, # G+1877  U+88F9  uni88F9,  CJK UNIFIED IDEOGRAPH-88F9
        0x8FC7, # G+1878  U+8FC7  uni8FC7,  CJK UNIFIED IDEOGRAPH-8FC7
        0x54C8, # G+1879  U+54C8  uni54C8,  CJK UNIFIED IDEOGRAPH-54C8
        0x9AB8, # G+1880  U+9AB8  uni9AB8,  CJK UNIFIED IDEOGRAPH-9AB8
        0x5B69, # G+1881  U+5B69  uni5B69,  CJK UNIFIED IDEOGRAPH-5B69
        0x6D77, # G+1882  U+6D77  uni6D77,  CJK UNIFIED IDEOGRAPH-6D77
        0x6C26, # G+1883  U+6C26  uni6C26,  CJK UNIFIED IDEOGRAPH-6C26
        0x4EA5, # G+1884  U+4EA5  uni4EA5,  CJK UNIFIED IDEOGRAPH-4EA5
        0x5BB3, # G+1885  U+5BB3  uni5BB3,  CJK UNIFIED IDEOGRAPH-5BB3
        0x9A87, # G+1886  U+9A87  uni9A87,  CJK UNIFIED IDEOGRAPH-9A87
        0x9163, # G+1887  U+9163  uni9163,  CJK UNIFIED IDEOGRAPH-9163
        0x61A8, # G+1888  U+61A8  uni61A8,  CJK UNIFIED IDEOGRAPH-61A8
        0x90AF, # G+1889  U+90AF  uni90AF,  CJK UNIFIED IDEOGRAPH-90AF
        0x97E9, # G+1890  U+97E9  uni97E9,  CJK UNIFIED IDEOGRAPH-97E9
        0x542B, # G+1891  U+542B  uni542B,  CJK UNIFIED IDEOGRAPH-542B
        0x6DB5, # G+1892  U+6DB5  uni6DB5,  CJK UNIFIED IDEOGRAPH-6DB5
        0x5BD2, # G+1893  U+5BD2  uni5BD2,  CJK UNIFIED IDEOGRAPH-5BD2
        0x51FD, # G+1894  U+51FD  uni51FD,  CJK UNIFIED IDEOGRAPH-51FD
        0x558A, # G+1895  U+558A  uni558A,  CJK UNIFIED IDEOGRAPH-558A
        0x7F55, # G+1896  U+7F55  uni7F55,  CJK UNIFIED IDEOGRAPH-7F55
        0x7FF0, # G+1897  U+7FF0  uni7FF0,  CJK UNIFIED IDEOGRAPH-7FF0
        0x64BC, # G+1898  U+64BC  uni64BC,  CJK UNIFIED IDEOGRAPH-64BC
        0x634D, # G+1899  U+634D  uni634D,  CJK UNIFIED IDEOGRAPH-634D
        0x65F1, # G+1900  U+65F1  uni65F1,  CJK UNIFIED IDEOGRAPH-65F1
        0x61BE, # G+1901  U+61BE  uni61BE,  CJK UNIFIED IDEOGRAPH-61BE
        0x608D, # G+1902  U+608D  uni608D,  CJK UNIFIED IDEOGRAPH-608D
        0x710A, # G+1903  U+710A  uni710A,  CJK UNIFIED IDEOGRAPH-710A
        0x6C57, # G+1904  U+6C57  uni6C57,  CJK UNIFIED IDEOGRAPH-6C57
        0x6C49, # G+1905  U+6C49  uni6C49,  CJK UNIFIED IDEOGRAPH-6C49
        0x592F, # G+1906  U+592F  uni592F,  CJK UNIFIED IDEOGRAPH-592F
        0x676D, # G+1907  U+676D  uni676D,  CJK UNIFIED IDEOGRAPH-676D
        0x822A, # G+1908  U+822A  uni822A,  CJK UNIFIED IDEOGRAPH-822A
        0x58D5, # G+1909  U+58D5  uni58D5,  CJK UNIFIED IDEOGRAPH-58D5
        0x568E, # G+1910  U+568E  uni568E,  CJK UNIFIED IDEOGRAPH-568E
        0x8C6A, # G+1911  U+8C6A  uni8C6A,  CJK UNIFIED IDEOGRAPH-8C6A
        0x6BEB, # G+1912  U+6BEB  uni6BEB,  CJK UNIFIED IDEOGRAPH-6BEB
        0x90DD, # G+1913  U+90DD  uni90DD,  CJK UNIFIED IDEOGRAPH-90DD
        0x597D, # G+1914  U+597D  uni597D,  CJK UNIFIED IDEOGRAPH-597D
        0x8017, # G+1915  U+8017  uni8017,  CJK UNIFIED IDEOGRAPH-8017
        0x53F7, # G+1916  U+53F7  uni53F7,  CJK UNIFIED IDEOGRAPH-53F7
        0x6D69, # G+1917  U+6D69  uni6D69,  CJK UNIFIED IDEOGRAPH-6D69
        0x5475, # G+1918  U+5475  uni5475,  CJK UNIFIED IDEOGRAPH-5475
        0x559D, # G+1919  U+559D  uni559D,  CJK UNIFIED IDEOGRAPH-559D
        0x8377, # G+1920  U+8377  uni8377,  CJK UNIFIED IDEOGRAPH-8377
        0x83CF, # G+1921  U+83CF  uni83CF,  CJK UNIFIED IDEOGRAPH-83CF
        0x6838, # G+1922  U+6838  uni6838,  CJK UNIFIED IDEOGRAPH-6838
        0x2F72, # G+1923  U+2F72  uni2F72,  KANGXI RADICAL GRAIN
        0x548C, # G+1924  U+548C  uni548C,  CJK UNIFIED IDEOGRAPH-548C
        0x4F55, # G+1925  U+4F55  uni4F55,  CJK UNIFIED IDEOGRAPH-4F55
        0x5408, # G+1926  U+5408  uni5408,  CJK UNIFIED IDEOGRAPH-5408
        0x76D2, # G+1927  U+76D2  uni76D2,  CJK UNIFIED IDEOGRAPH-76D2
        0x8C89, # G+1928  U+8C89  uni8C89,  CJK UNIFIED IDEOGRAPH-8C89
        0x9602, # G+1929  U+9602  uni9602,  CJK UNIFIED IDEOGRAPH-9602
        0x6CB3, # G+1930  U+6CB3  uni6CB3,  CJK UNIFIED IDEOGRAPH-6CB3
        0x6DB8, # G+1931  U+6DB8  uni6DB8,  CJK UNIFIED IDEOGRAPH-6DB8
        0x8D6B, # G+1932  U+8D6B  uni8D6B,  CJK UNIFIED IDEOGRAPH-8D6B
        0x8910, # G+1933  U+8910  uni8910,  CJK UNIFIED IDEOGRAPH-8910
        0x9E64, # G+1934  U+9E64  uni9E64,  CJK UNIFIED IDEOGRAPH-9E64
        0x8D3A, # G+1935  U+8D3A  uni8D3A,  CJK UNIFIED IDEOGRAPH-8D3A
        0x563F, # G+1936  U+563F  uni563F,  CJK UNIFIED IDEOGRAPH-563F
        0x2FCA, # G+1937  U+2FCA  uni2FCA,  KANGXI RADICAL BLACK
        0x75D5, # G+1938  U+75D5  uni75D5,  CJK UNIFIED IDEOGRAPH-75D5
        0x5F88, # G+1939  U+5F88  uni5F88,  CJK UNIFIED IDEOGRAPH-5F88
        0x72E0, # G+1940  U+72E0  uni72E0,  CJK UNIFIED IDEOGRAPH-72E0
        0x6068, # G+1941  U+6068  uni6068,  CJK UNIFIED IDEOGRAPH-6068
        0x54FC, # G+1942  U+54FC  uni54FC,  CJK UNIFIED IDEOGRAPH-54FC
        0x4EA8, # G+1943  U+4EA8  uni4EA8,  CJK UNIFIED IDEOGRAPH-4EA8
        0x6A2A, # G+1944  U+6A2A  uni6A2A,  CJK UNIFIED IDEOGRAPH-6A2A
        0x8861, # G+1945  U+8861  uni8861,  CJK UNIFIED IDEOGRAPH-8861
        0x6052, # G+1946  U+6052  uni6052,  CJK UNIFIED IDEOGRAPH-6052
        0x8F70, # G+1947  U+8F70  uni8F70,  CJK UNIFIED IDEOGRAPH-8F70
        0x54C4, # G+1948  U+54C4  uni54C4,  CJK UNIFIED IDEOGRAPH-54C4
        0x70D8, # G+1949  U+70D8  uni70D8,  CJK UNIFIED IDEOGRAPH-70D8
        0x8679, # G+1950  U+8679  uni8679,  CJK UNIFIED IDEOGRAPH-8679
        0x9E3F, # G+1951  U+9E3F  uni9E3F,  CJK UNIFIED IDEOGRAPH-9E3F
        0x6D2A, # G+1952  U+6D2A  uni6D2A,  CJK UNIFIED IDEOGRAPH-6D2A
        0x5B8F, # G+1953  U+5B8F  uni5B8F,  CJK UNIFIED IDEOGRAPH-5B8F
        0x5F18, # G+1954  U+5F18  uni5F18,  CJK UNIFIED IDEOGRAPH-5F18
        0x7EA2, # G+1955  U+7EA2  uni7EA2,  CJK UNIFIED IDEOGRAPH-7EA2
        0x5589, # G+1956  U+5589  uni5589,  CJK UNIFIED IDEOGRAPH-5589
        0x4FAF, # G+1957  U+4FAF  uni4FAF,  CJK UNIFIED IDEOGRAPH-4FAF
        0x7334, # G+1958  U+7334  uni7334,  CJK UNIFIED IDEOGRAPH-7334
        0x543C, # G+1959  U+543C  uni543C,  CJK UNIFIED IDEOGRAPH-543C
        0x539A, # G+1960  U+539A  uni539A,  CJK UNIFIED IDEOGRAPH-539A
        0x5019, # G+1961  U+5019  uni5019,  CJK UNIFIED IDEOGRAPH-5019
        0x540E, # G+1962  U+540E  uni540E,  CJK UNIFIED IDEOGRAPH-540E
        0x547C, # G+1963  U+547C  uni547C,  CJK UNIFIED IDEOGRAPH-547C
        0x4E4E, # G+1964  U+4E4E  uni4E4E,  CJK UNIFIED IDEOGRAPH-4E4E
        0x5FFD, # G+1965  U+5FFD  uni5FFD,  CJK UNIFIED IDEOGRAPH-5FFD
        0x745A, # G+1966  U+745A  uni745A,  CJK UNIFIED IDEOGRAPH-745A
        0x58F6, # G+1967  U+58F6  uni58F6,  CJK UNIFIED IDEOGRAPH-58F6
        0x846B, # G+1968  U+846B  uni846B,  CJK UNIFIED IDEOGRAPH-846B
        0x80E1, # G+1969  U+80E1  uni80E1,  CJK UNIFIED IDEOGRAPH-80E1
        0x8774, # G+1970  U+8774  uni8774,  CJK UNIFIED IDEOGRAPH-8774
        0x72D0, # G+1971  U+72D0  uni72D0,  CJK UNIFIED IDEOGRAPH-72D0
        0x7CCA, # G+1972  U+7CCA  uni7CCA,  CJK UNIFIED IDEOGRAPH-7CCA
        0x6E56, # G+1973  U+6E56  uni6E56,  CJK UNIFIED IDEOGRAPH-6E56
        0x5F27, # G+1974  U+5F27  uni5F27,  CJK UNIFIED IDEOGRAPH-5F27
        0x864E, # G+1975  U+864E  uni864E,  CJK UNIFIED IDEOGRAPH-864E
        0x552C, # G+1976  U+552C  uni552C,  CJK UNIFIED IDEOGRAPH-552C
        0x62A4, # G+1977  U+62A4  uni62A4,  CJK UNIFIED IDEOGRAPH-62A4
        0x4E92, # G+1978  U+4E92  uni4E92,  CJK UNIFIED IDEOGRAPH-4E92
        0x6CAA, # G+1979  U+6CAA  uni6CAA,  CJK UNIFIED IDEOGRAPH-6CAA
        0x6237, # G+1980  U+6237  uni6237,  CJK UNIFIED IDEOGRAPH-6237
        0x82B1, # G+1981  U+82B1  uni82B1,  CJK UNIFIED IDEOGRAPH-82B1
        0x54D7, # G+1982  U+54D7  uni54D7,  CJK UNIFIED IDEOGRAPH-54D7
        0x534E, # G+1983  U+534E  uni534E,  CJK UNIFIED IDEOGRAPH-534E
        0x733E, # G+1984  U+733E  uni733E,  CJK UNIFIED IDEOGRAPH-733E
        0x6ED1, # G+1985  U+6ED1  uni6ED1,  CJK UNIFIED IDEOGRAPH-6ED1
        0x753B, # G+1986  U+753B  uni753B,  CJK UNIFIED IDEOGRAPH-753B
        0x5212, # G+1987  U+5212  uni5212,  CJK UNIFIED IDEOGRAPH-5212
        0x5316, # G+1988  U+5316  uni5316,  CJK UNIFIED IDEOGRAPH-5316
        0x8BDD, # G+1989  U+8BDD  uni8BDD,  CJK UNIFIED IDEOGRAPH-8BDD
        0x69D0, # G+1990  U+69D0  uni69D0,  CJK UNIFIED IDEOGRAPH-69D0
        0x5F8A, # G+1991  U+5F8A  uni5F8A,  CJK UNIFIED IDEOGRAPH-5F8A
        0x6000, # G+1992  U+6000  uni6000,  CJK UNIFIED IDEOGRAPH-6000
        0x6DEE, # G+1993  U+6DEE  uni6DEE,  CJK UNIFIED IDEOGRAPH-6DEE
        0x574F, # G+1994  U+574F  uni574F,  CJK UNIFIED IDEOGRAPH-574F
        0x6B22, # G+1995  U+6B22  uni6B22,  CJK UNIFIED IDEOGRAPH-6B22
        0x73AF, # G+1996  U+73AF  uni73AF,  CJK UNIFIED IDEOGRAPH-73AF
        0x6853, # G+1997  U+6853  uni6853,  CJK UNIFIED IDEOGRAPH-6853
        0x8FD8, # G+1998  U+8FD8  uni8FD8,  CJK UNIFIED IDEOGRAPH-8FD8
        0x7F13, # G+1999  U+7F13  uni7F13,  CJK UNIFIED IDEOGRAPH-7F13
        0x6362, # G+2000  U+6362  uni6362,  CJK UNIFIED IDEOGRAPH-6362
        0x60A3, # G+2001  U+60A3  uni60A3,  CJK UNIFIED IDEOGRAPH-60A3
        0x5524, # G+2002  U+5524  uni5524,  CJK UNIFIED IDEOGRAPH-5524
        0x75EA, # G+2003  U+75EA  uni75EA,  CJK UNIFIED IDEOGRAPH-75EA
        0x8C62, # G+2004  U+8C62  uni8C62,  CJK UNIFIED IDEOGRAPH-8C62
        0x7115, # G+2005  U+7115  uni7115,  CJK UNIFIED IDEOGRAPH-7115
        0x6DA3, # G+2006  U+6DA3  uni6DA3,  CJK UNIFIED IDEOGRAPH-6DA3
        0x5BA6, # G+2007  U+5BA6  uni5BA6,  CJK UNIFIED IDEOGRAPH-5BA6
        0x5E7B, # G+2008  U+5E7B  uni5E7B,  CJK UNIFIED IDEOGRAPH-5E7B
        0x8352, # G+2009  U+8352  uni8352,  CJK UNIFIED IDEOGRAPH-8352
        0x614C, # G+2010  U+614C  uni614C,  CJK UNIFIED IDEOGRAPH-614C
        0x9EC4, # G+2011  U+9EC4  uni9EC4,  CJK UNIFIED IDEOGRAPH-9EC4
        0x78FA, # G+2012  U+78FA  uni78FA,  CJK UNIFIED IDEOGRAPH-78FA
        0x8757, # G+2013  U+8757  uni8757,  CJK UNIFIED IDEOGRAPH-8757
        0x7C27, # G+2014  U+7C27  uni7C27,  CJK UNIFIED IDEOGRAPH-7C27
        0x7687, # G+2015  U+7687  uni7687,  CJK UNIFIED IDEOGRAPH-7687
        0x51F0, # G+2016  U+51F0  uni51F0,  CJK UNIFIED IDEOGRAPH-51F0
        0x60F6, # G+2017  U+60F6  uni60F6,  CJK UNIFIED IDEOGRAPH-60F6
        0x714C, # G+2018  U+714C  uni714C,  CJK UNIFIED IDEOGRAPH-714C
        0x6643, # G+2019  U+6643  uni6643,  CJK UNIFIED IDEOGRAPH-6643
        0x5E4C, # G+2020  U+5E4C  uni5E4C,  CJK UNIFIED IDEOGRAPH-5E4C
        0x604D, # G+2021  U+604D  uni604D,  CJK UNIFIED IDEOGRAPH-604D
        0x8C0E, # G+2022  U+8C0E  uni8C0E,  CJK UNIFIED IDEOGRAPH-8C0E
        0x7070, # G+2023  U+7070  uni7070,  CJK UNIFIED IDEOGRAPH-7070
        0x6325, # G+2024  U+6325  uni6325,  CJK UNIFIED IDEOGRAPH-6325
        0x8F89, # G+2025  U+8F89  uni8F89,  CJK UNIFIED IDEOGRAPH-8F89
        0x5FBD, # G+2026  U+5FBD  uni5FBD,  CJK UNIFIED IDEOGRAPH-5FBD
        0x6062, # G+2027  U+6062  uni6062,  CJK UNIFIED IDEOGRAPH-6062
        0x86D4, # G+2028  U+86D4  uni86D4,  CJK UNIFIED IDEOGRAPH-86D4
        0x56DE, # G+2029  U+56DE  uni56DE,  CJK UNIFIED IDEOGRAPH-56DE
        0x6BC1, # G+2030  U+6BC1  uni6BC1,  CJK UNIFIED IDEOGRAPH-6BC1
        0x6094, # G+2031  U+6094  uni6094,  CJK UNIFIED IDEOGRAPH-6094
        0x6167, # G+2032  U+6167  uni6167,  CJK UNIFIED IDEOGRAPH-6167
        0x5349, # G+2033  U+5349  uni5349,  CJK UNIFIED IDEOGRAPH-5349
        0x60E0, # G+2034  U+60E0  uni60E0,  CJK UNIFIED IDEOGRAPH-60E0
        0x6666, # G+2035  U+6666  uni6666,  CJK UNIFIED IDEOGRAPH-6666
        0x8D3F, # G+2036  U+8D3F  uni8D3F,  CJK UNIFIED IDEOGRAPH-8D3F
        0x79FD, # G+2037  U+79FD  uni79FD,  CJK UNIFIED IDEOGRAPH-79FD
        0x4F1A, # G+2038  U+4F1A  uni4F1A,  CJK UNIFIED IDEOGRAPH-4F1A
        0x70E9, # G+2039  U+70E9  uni70E9,  CJK UNIFIED IDEOGRAPH-70E9
        0x6C47, # G+2040  U+6C47  uni6C47,  CJK UNIFIED IDEOGRAPH-6C47
        0x8BB3, # G+2041  U+8BB3  uni8BB3,  CJK UNIFIED IDEOGRAPH-8BB3
        0x8BF2, # G+2042  U+8BF2  uni8BF2,  CJK UNIFIED IDEOGRAPH-8BF2
        0x7ED8, # G+2043  U+7ED8  uni7ED8,  CJK UNIFIED IDEOGRAPH-7ED8
        0x8364, # G+2044  U+8364  uni8364,  CJK UNIFIED IDEOGRAPH-8364
        0x660F, # G+2045  U+660F  uni660F,  CJK UNIFIED IDEOGRAPH-660F
        0x5A5A, # G+2046  U+5A5A  uni5A5A,  CJK UNIFIED IDEOGRAPH-5A5A
        0x9B42, # G+2047  U+9B42  uni9B42,  CJK UNIFIED IDEOGRAPH-9B42
        0x6D51, # G+2048  U+6D51  uni6D51,  CJK UNIFIED IDEOGRAPH-6D51
        0x6DF7, # G+2049  U+6DF7  uni6DF7,  CJK UNIFIED IDEOGRAPH-6DF7
        0x8C41, # G+2050  U+8C41  uni8C41,  CJK UNIFIED IDEOGRAPH-8C41
        0x6D3B, # G+2051  U+6D3B  uni6D3B,  CJK UNIFIED IDEOGRAPH-6D3B
        0x4F19, # G+2052  U+4F19  uni4F19,  CJK UNIFIED IDEOGRAPH-4F19
        0x2F55, # G+2053  U+2F55  uni2F55,  KANGXI RADICAL FIRE
        0x83B7, # G+2054  U+83B7  uni83B7,  CJK UNIFIED IDEOGRAPH-83B7
        0x6216, # G+2055  U+6216  uni6216,  CJK UNIFIED IDEOGRAPH-6216
        0x60D1, # G+2056  U+60D1  uni60D1,  CJK UNIFIED IDEOGRAPH-60D1
        0x970D, # G+2057  U+970D  uni970D,  CJK UNIFIED IDEOGRAPH-970D
        0x8D27, # G+2058  U+8D27  uni8D27,  CJK UNIFIED IDEOGRAPH-8D27
        0x7978, # G+2059  U+7978  uni7978,  CJK UNIFIED IDEOGRAPH-7978
        0x51FB, # G+2060  U+51FB  uni51FB,  CJK UNIFIED IDEOGRAPH-51FB
        0x573E, # G+2061  U+573E  uni573E,  CJK UNIFIED IDEOGRAPH-573E
        0x57FA, # G+2062  U+57FA  uni57FA,  CJK UNIFIED IDEOGRAPH-57FA
        0x673A, # G+2063  U+673A  uni673A,  CJK UNIFIED IDEOGRAPH-673A
        0x7578, # G+2064  U+7578  uni7578,  CJK UNIFIED IDEOGRAPH-7578
        0x7A3D, # G+2065  U+7A3D  uni7A3D,  CJK UNIFIED IDEOGRAPH-7A3D
        0x79EF, # G+2066  U+79EF  uni79EF,  CJK UNIFIED IDEOGRAPH-79EF
        0x7B95, # G+2067  U+7B95  uni7B95,  CJK UNIFIED IDEOGRAPH-7B95
        0x808C, # G+2068  U+808C  uni808C,  CJK UNIFIED IDEOGRAPH-808C
        0x9965, # G+2069  U+9965  uni9965,  CJK UNIFIED IDEOGRAPH-9965
        0x8FF9, # G+2070  U+8FF9  uni8FF9,  CJK UNIFIED IDEOGRAPH-8FF9
        0x6FC0, # G+2071  U+6FC0  uni6FC0,  CJK UNIFIED IDEOGRAPH-6FC0
        0x8BA5, # G+2072  U+8BA5  uni8BA5,  CJK UNIFIED IDEOGRAPH-8BA5
        0x9E21, # G+2073  U+9E21  uni9E21,  CJK UNIFIED IDEOGRAPH-9E21
        0x59EC, # G+2074  U+59EC  uni59EC,  CJK UNIFIED IDEOGRAPH-59EC
        0x7EE9, # G+2075  U+7EE9  uni7EE9,  CJK UNIFIED IDEOGRAPH-7EE9
        0x7F09, # G+2076  U+7F09  uni7F09,  CJK UNIFIED IDEOGRAPH-7F09
        0x5409, # G+2077  U+5409  uni5409,  CJK UNIFIED IDEOGRAPH-5409
        0x6781, # G+2078  U+6781  uni6781,  CJK UNIFIED IDEOGRAPH-6781
        0x68D8, # G+2079  U+68D8  uni68D8,  CJK UNIFIED IDEOGRAPH-68D8
        0x8F91, # G+2080  U+8F91  uni8F91,  CJK UNIFIED IDEOGRAPH-8F91
        0x7C4D, # G+2081  U+7C4D  uni7C4D,  CJK UNIFIED IDEOGRAPH-7C4D
        0x96C6, # G+2082  U+96C6  uni96C6,  CJK UNIFIED IDEOGRAPH-96C6
        0x53CA, # G+2083  U+53CA  uni53CA,  CJK UNIFIED IDEOGRAPH-53CA
        0x6025, # G+2084  U+6025  uni6025,  CJK UNIFIED IDEOGRAPH-6025
        0x75BE, # G+2085  U+75BE  uni75BE,  CJK UNIFIED IDEOGRAPH-75BE
        0x6C72, # G+2086  U+6C72  uni6C72,  CJK UNIFIED IDEOGRAPH-6C72
        0x5373, # G+2087  U+5373  uni5373,  CJK UNIFIED IDEOGRAPH-5373
        0x5AC9, # G+2088  U+5AC9  uni5AC9,  CJK UNIFIED IDEOGRAPH-5AC9
        0x7EA7, # G+2089  U+7EA7  uni7EA7,  CJK UNIFIED IDEOGRAPH-7EA7
        0x6324, # G+2090  U+6324  uni6324,  CJK UNIFIED IDEOGRAPH-6324
        0x2F0F, # G+2091  U+2F0F  uni2F0F,  KANGXI RADICAL TABLE
        0x810A, # G+2092  U+810A  uni810A,  CJK UNIFIED IDEOGRAPH-810A
        0x2F30, # G+2093  U+2F30  uni2F30,  KANGXI RADICAL ONESELF
        0x84DF, # G+2094  U+84DF  uni84DF,  CJK UNIFIED IDEOGRAPH-84DF
        0x6280, # G+2095  U+6280  uni6280,  CJK UNIFIED IDEOGRAPH-6280
        0x5180, # G+2096  U+5180  uni5180,  CJK UNIFIED IDEOGRAPH-5180
        0x5B63, # G+2097  U+5B63  uni5B63,  CJK UNIFIED IDEOGRAPH-5B63
        0x4F0E, # G+2098  U+4F0E  uni4F0E,  CJK UNIFIED IDEOGRAPH-4F0E
        0x796D, # G+2099  U+796D  uni796D,  CJK UNIFIED IDEOGRAPH-796D
        0x5242, # G+2100  U+5242  uni5242,  CJK UNIFIED IDEOGRAPH-5242
        0x60B8, # G+2101  U+60B8  uni60B8,  CJK UNIFIED IDEOGRAPH-60B8
        0x6D4E, # G+2102  U+6D4E  uni6D4E,  CJK UNIFIED IDEOGRAPH-6D4E
        0x5BC4, # G+2103  U+5BC4  uni5BC4,  CJK UNIFIED IDEOGRAPH-5BC4
        0x5BC2, # G+2104  U+5BC2  uni5BC2,  CJK UNIFIED IDEOGRAPH-5BC2
        0x8BA1, # G+2105  U+8BA1  uni8BA1,  CJK UNIFIED IDEOGRAPH-8BA1
        0x8BB0, # G+2106  U+8BB0  uni8BB0,  CJK UNIFIED IDEOGRAPH-8BB0
        0x65E2, # G+2107  U+65E2  uni65E2,  CJK UNIFIED IDEOGRAPH-65E2
        0x5FCC, # G+2108  U+5FCC  uni5FCC,  CJK UNIFIED IDEOGRAPH-5FCC
        0x9645, # G+2109  U+9645  uni9645,  CJK UNIFIED IDEOGRAPH-9645
        0x5993, # G+2110  U+5993  uni5993,  CJK UNIFIED IDEOGRAPH-5993
        0x7EE7, # G+2111  U+7EE7  uni7EE7,  CJK UNIFIED IDEOGRAPH-7EE7
        0x7EAA, # G+2112  U+7EAA  uni7EAA,  CJK UNIFIED IDEOGRAPH-7EAA
        0x5609, # G+2113  U+5609  uni5609,  CJK UNIFIED IDEOGRAPH-5609
        0x67B7, # G+2114  U+67B7  uni67B7,  CJK UNIFIED IDEOGRAPH-67B7
        0x5939, # G+2115  U+5939  uni5939,  CJK UNIFIED IDEOGRAPH-5939
        0x4F73, # G+2116  U+4F73  uni4F73,  CJK UNIFIED IDEOGRAPH-4F73
        0x5BB6, # G+2117  U+5BB6  uni5BB6,  CJK UNIFIED IDEOGRAPH-5BB6
        0x52A0, # G+2118  U+52A0  uni52A0,  CJK UNIFIED IDEOGRAPH-52A0
        0x835A, # G+2119  U+835A  uni835A,  CJK UNIFIED IDEOGRAPH-835A
        0x988A, # G+2120  U+988A  uni988A,  CJK UNIFIED IDEOGRAPH-988A
        0x8D3E, # G+2121  U+8D3E  uni8D3E,  CJK UNIFIED IDEOGRAPH-8D3E
        0x7532, # G+2122  U+7532  uni7532,  CJK UNIFIED IDEOGRAPH-7532
        0x94BE, # G+2123  U+94BE  uni94BE,  CJK UNIFIED IDEOGRAPH-94BE
        0x5047, # G+2124  U+5047  uni5047,  CJK UNIFIED IDEOGRAPH-5047
        0x7A3C, # G+2125  U+7A3C  uni7A3C,  CJK UNIFIED IDEOGRAPH-7A3C
        0x4EF7, # G+2126  U+4EF7  uni4EF7,  CJK UNIFIED IDEOGRAPH-4EF7
        0x67B6, # G+2127  U+67B6  uni67B6,  CJK UNIFIED IDEOGRAPH-67B6
        0x9A7E, # G+2128  U+9A7E  uni9A7E,  CJK UNIFIED IDEOGRAPH-9A7E
        0x5AC1, # G+2129  U+5AC1  uni5AC1,  CJK UNIFIED IDEOGRAPH-5AC1
        0x6B7C, # G+2130  U+6B7C  uni6B7C,  CJK UNIFIED IDEOGRAPH-6B7C
        0x76D1, # G+2131  U+76D1  uni76D1,  CJK UNIFIED IDEOGRAPH-76D1
        0x575A, # G+2132  U+575A  uni575A,  CJK UNIFIED IDEOGRAPH-575A
        0x5C16, # G+2133  U+5C16  uni5C16,  CJK UNIFIED IDEOGRAPH-5C16
        0x7B3A, # G+2134  U+7B3A  uni7B3A,  CJK UNIFIED IDEOGRAPH-7B3A
        0x95F4, # G+2135  U+95F4  uni95F4,  CJK UNIFIED IDEOGRAPH-95F4
        0x714E, # G+2136  U+714E  uni714E,  CJK UNIFIED IDEOGRAPH-714E
        0x517C, # G+2137  U+517C  uni517C,  CJK UNIFIED IDEOGRAPH-517C
        0x80A9, # G+2138  U+80A9  uni80A9,  CJK UNIFIED IDEOGRAPH-80A9
        0x8270, # G+2139  U+8270  uni8270,  CJK UNIFIED IDEOGRAPH-8270
        0x5978, # G+2140  U+5978  uni5978,  CJK UNIFIED IDEOGRAPH-5978
        0x7F04, # G+2141  U+7F04  uni7F04,  CJK UNIFIED IDEOGRAPH-7F04
        0x8327, # G+2142  U+8327  uni8327,  CJK UNIFIED IDEOGRAPH-8327
        0x68C0, # G+2143  U+68C0  uni68C0,  CJK UNIFIED IDEOGRAPH-68C0
        0x67EC, # G+2144  U+67EC  uni67EC,  CJK UNIFIED IDEOGRAPH-67EC
        0x78B1, # G+2145  U+78B1  uni78B1,  CJK UNIFIED IDEOGRAPH-78B1
        0x7877, # G+2146  U+7877  uni7877,  CJK UNIFIED IDEOGRAPH-7877
        0x62E3, # G+2147  U+62E3  uni62E3,  CJK UNIFIED IDEOGRAPH-62E3
        0x6361, # G+2148  U+6361  uni6361,  CJK UNIFIED IDEOGRAPH-6361
        0x7B80, # G+2149  U+7B80  uni7B80,  CJK UNIFIED IDEOGRAPH-7B80
        0x4FED, # G+2150  U+4FED  uni4FED,  CJK UNIFIED IDEOGRAPH-4FED
        0x526A, # G+2151  U+526A  uni526A,  CJK UNIFIED IDEOGRAPH-526A
        0x51CF, # G+2152  U+51CF  uni51CF,  CJK UNIFIED IDEOGRAPH-51CF
        0x8350, # G+2153  U+8350  uni8350,  CJK UNIFIED IDEOGRAPH-8350
        0x69DB, # G+2154  U+69DB  uni69DB,  CJK UNIFIED IDEOGRAPH-69DB
        0x9274, # G+2155  U+9274  uni9274,  CJK UNIFIED IDEOGRAPH-9274
        0x8DF5, # G+2156  U+8DF5  uni8DF5,  CJK UNIFIED IDEOGRAPH-8DF5
        0x8D31, # G+2157  U+8D31  uni8D31,  CJK UNIFIED IDEOGRAPH-8D31
        0x89C1, # G+2158  U+89C1  uni89C1,  CJK UNIFIED IDEOGRAPH-89C1
        0x952E, # G+2159  U+952E  uni952E,  CJK UNIFIED IDEOGRAPH-952E
        0x7BAD, # G+2160  U+7BAD  uni7BAD,  CJK UNIFIED IDEOGRAPH-7BAD
        0x4EF6, # G+2161  U+4EF6  uni4EF6,  CJK UNIFIED IDEOGRAPH-4EF6
        0x5065, # G+2162  U+5065  uni5065,  CJK UNIFIED IDEOGRAPH-5065
        0x8230, # G+2163  U+8230  uni8230,  CJK UNIFIED IDEOGRAPH-8230
        0x5251, # G+2164  U+5251  uni5251,  CJK UNIFIED IDEOGRAPH-5251
        0x996F, # G+2165  U+996F  uni996F,  CJK UNIFIED IDEOGRAPH-996F
        0x6E10, # G+2166  U+6E10  uni6E10,  CJK UNIFIED IDEOGRAPH-6E10
        0x6E85, # G+2167  U+6E85  uni6E85,  CJK UNIFIED IDEOGRAPH-6E85
        0x6DA7, # G+2168  U+6DA7  uni6DA7,  CJK UNIFIED IDEOGRAPH-6DA7
        0x5EFA, # G+2169  U+5EFA  uni5EFA,  CJK UNIFIED IDEOGRAPH-5EFA
        0x50F5, # G+2170  U+50F5  uni50F5,  CJK UNIFIED IDEOGRAPH-50F5
        0x59DC, # G+2171  U+59DC  uni59DC,  CJK UNIFIED IDEOGRAPH-59DC
        0x5C06, # G+2172  U+5C06  uni5C06,  CJK UNIFIED IDEOGRAPH-5C06
        0x6D46, # G+2173  U+6D46  uni6D46,  CJK UNIFIED IDEOGRAPH-6D46
        0x6C5F, # G+2174  U+6C5F  uni6C5F,  CJK UNIFIED IDEOGRAPH-6C5F
        0x7586, # G+2175  U+7586  uni7586,  CJK UNIFIED IDEOGRAPH-7586
        0x848B, # G+2176  U+848B  uni848B,  CJK UNIFIED IDEOGRAPH-848B
        0x6868, # G+2177  U+6868  uni6868,  CJK UNIFIED IDEOGRAPH-6868
        0x5956, # G+2178  U+5956  uni5956,  CJK UNIFIED IDEOGRAPH-5956
        0x8BB2, # G+2179  U+8BB2  uni8BB2,  CJK UNIFIED IDEOGRAPH-8BB2
        0x5320, # G+2180  U+5320  uni5320,  CJK UNIFIED IDEOGRAPH-5320
        0x9171, # G+2181  U+9171  uni9171,  CJK UNIFIED IDEOGRAPH-9171
        0x964D, # G+2182  U+964D  uni964D,  CJK UNIFIED IDEOGRAPH-964D
        0x8549, # G+2183  U+8549  uni8549,  CJK UNIFIED IDEOGRAPH-8549
        0x6912, # G+2184  U+6912  uni6912,  CJK UNIFIED IDEOGRAPH-6912
        0x7901, # G+2185  U+7901  uni7901,  CJK UNIFIED IDEOGRAPH-7901
        0x7126, # G+2186  U+7126  uni7126,  CJK UNIFIED IDEOGRAPH-7126
        0x80F6, # G+2187  U+80F6  uni80F6,  CJK UNIFIED IDEOGRAPH-80F6
        0x4EA4, # G+2188  U+4EA4  uni4EA4,  CJK UNIFIED IDEOGRAPH-4EA4
        0x90CA, # G+2189  U+90CA  uni90CA,  CJK UNIFIED IDEOGRAPH-90CA
        0x6D47, # G+2190  U+6D47  uni6D47,  CJK UNIFIED IDEOGRAPH-6D47
        0x9A84, # G+2191  U+9A84  uni9A84,  CJK UNIFIED IDEOGRAPH-9A84
        0x5A07, # G+2192  U+5A07  uni5A07,  CJK UNIFIED IDEOGRAPH-5A07
        0x56BC, # G+2193  U+56BC  uni56BC,  CJK UNIFIED IDEOGRAPH-56BC
        0x6405, # G+2194  U+6405  uni6405,  CJK UNIFIED IDEOGRAPH-6405
        0x94F0, # G+2195  U+94F0  uni94F0,  CJK UNIFIED IDEOGRAPH-94F0
        0x77EB, # G+2196  U+77EB  uni77EB,  CJK UNIFIED IDEOGRAPH-77EB
        0x4FA5, # G+2197  U+4FA5  uni4FA5,  CJK UNIFIED IDEOGRAPH-4FA5
        0x811A, # G+2198  U+811A  uni811A,  CJK UNIFIED IDEOGRAPH-811A
        0x72E1, # G+2199  U+72E1  uni72E1,  CJK UNIFIED IDEOGRAPH-72E1
        0x2F93, # G+2200  U+2F93  uni2F93,  KANGXI RADICAL HORN
        0x997A, # G+2201  U+997A  uni997A,  CJK UNIFIED IDEOGRAPH-997A
        0x7F34, # G+2202  U+7F34  uni7F34,  CJK UNIFIED IDEOGRAPH-7F34
        0x7EDE, # G+2203  U+7EDE  uni7EDE,  CJK UNIFIED IDEOGRAPH-7EDE
        0x527F, # G+2204  U+527F  uni527F,  CJK UNIFIED IDEOGRAPH-527F
        0x6559, # G+2205  U+6559  uni6559,  CJK UNIFIED IDEOGRAPH-6559
        0x9175, # G+2206  U+9175  uni9175,  CJK UNIFIED IDEOGRAPH-9175
        0x8F7F, # G+2207  U+8F7F  uni8F7F,  CJK UNIFIED IDEOGRAPH-8F7F
        0x8F83, # G+2208  U+8F83  uni8F83,  CJK UNIFIED IDEOGRAPH-8F83
        0x53EB, # G+2209  U+53EB  uni53EB,  CJK UNIFIED IDEOGRAPH-53EB
        0x7A96, # G+2210  U+7A96  uni7A96,  CJK UNIFIED IDEOGRAPH-7A96
        0x63ED, # G+2211  U+63ED  uni63ED,  CJK UNIFIED IDEOGRAPH-63ED
        0x63A5, # G+2212  U+63A5  uni63A5,  CJK UNIFIED IDEOGRAPH-63A5
        0x7686, # G+2213  U+7686  uni7686,  CJK UNIFIED IDEOGRAPH-7686
        0x79F8, # G+2214  U+79F8  uni79F8,  CJK UNIFIED IDEOGRAPH-79F8
        0x8857, # G+2215  U+8857  uni8857,  CJK UNIFIED IDEOGRAPH-8857
        0x9636, # G+2216  U+9636  uni9636,  CJK UNIFIED IDEOGRAPH-9636
        0x622A, # G+2217  U+622A  uni622A,  CJK UNIFIED IDEOGRAPH-622A
        0x52AB, # G+2218  U+52AB  uni52AB,  CJK UNIFIED IDEOGRAPH-52AB
        0x8282, # G+2219  U+8282  uni8282,  CJK UNIFIED IDEOGRAPH-8282
        0x6854, # G+2220  U+6854  uni6854,  CJK UNIFIED IDEOGRAPH-6854
        0x6770, # G+2221  U+6770  uni6770,  CJK UNIFIED IDEOGRAPH-6770
        0x6377, # G+2222  U+6377  uni6377,  CJK UNIFIED IDEOGRAPH-6377
        0x776B, # G+2223  U+776B  uni776B,  CJK UNIFIED IDEOGRAPH-776B
        0x7AED, # G+2224  U+7AED  uni7AED,  CJK UNIFIED IDEOGRAPH-7AED
        0x6D01, # G+2225  U+6D01  uni6D01,  CJK UNIFIED IDEOGRAPH-6D01
        0x7ED3, # G+2226  U+7ED3  uni7ED3,  CJK UNIFIED IDEOGRAPH-7ED3
        0x89E3, # G+2227  U+89E3  uni89E3,  CJK UNIFIED IDEOGRAPH-89E3
        0x59D0, # G+2228  U+59D0  uni59D0,  CJK UNIFIED IDEOGRAPH-59D0
        0x6212, # G+2229  U+6212  uni6212,  CJK UNIFIED IDEOGRAPH-6212
        0x85C9, # G+2230  U+85C9  uni85C9,  CJK UNIFIED IDEOGRAPH-85C9
        0x82A5, # G+2231  U+82A5  uni82A5,  CJK UNIFIED IDEOGRAPH-82A5
        0x754C, # G+2232  U+754C  uni754C,  CJK UNIFIED IDEOGRAPH-754C
        0x501F, # G+2233  U+501F  uni501F,  CJK UNIFIED IDEOGRAPH-501F
        0x4ECB, # G+2234  U+4ECB  uni4ECB,  CJK UNIFIED IDEOGRAPH-4ECB
        0x75A5, # G+2235  U+75A5  uni75A5,  CJK UNIFIED IDEOGRAPH-75A5
        0x8BEB, # G+2236  U+8BEB  uni8BEB,  CJK UNIFIED IDEOGRAPH-8BEB
        0x5C4A, # G+2237  U+5C4A  uni5C4A,  CJK UNIFIED IDEOGRAPH-5C4A
        0x2F31, # G+2238  U+2F31  uni2F31,  KANGXI RADICAL TURBAN
        0x7B4B, # G+2239  U+7B4B  uni7B4B,  CJK UNIFIED IDEOGRAPH-7B4B
        0x2F44, # G+2240  U+2F44  uni2F44,  KANGXI RADICAL AXE
        0x2FA6, # G+2241  U+2FA6  uni2FA6,  KANGXI RADICAL GOLD
        0x4ECA, # G+2242  U+4ECA  uni4ECA,  CJK UNIFIED IDEOGRAPH-4ECA
        0x6D25, # G+2243  U+6D25  uni6D25,  CJK UNIFIED IDEOGRAPH-6D25
        0x895F, # G+2244  U+895F  uni895F,  CJK UNIFIED IDEOGRAPH-895F
        0x7D27, # G+2245  U+7D27  uni7D27,  CJK UNIFIED IDEOGRAPH-7D27
        0x9526, # G+2246  U+9526  uni9526,  CJK UNIFIED IDEOGRAPH-9526
        0x4EC5, # G+2247  U+4EC5  uni4EC5,  CJK UNIFIED IDEOGRAPH-4EC5
        0x8C28, # G+2248  U+8C28  uni8C28,  CJK UNIFIED IDEOGRAPH-8C28
        0x8FDB, # G+2249  U+8FDB  uni8FDB,  CJK UNIFIED IDEOGRAPH-8FDB
        0x9773, # G+2250  U+9773  uni9773,  CJK UNIFIED IDEOGRAPH-9773
        0x664B, # G+2251  U+664B  uni664B,  CJK UNIFIED IDEOGRAPH-664B
        0x7981, # G+2252  U+7981  uni7981,  CJK UNIFIED IDEOGRAPH-7981
        0x8FD1, # G+2253  U+8FD1  uni8FD1,  CJK UNIFIED IDEOGRAPH-8FD1
        0x70EC, # G+2254  U+70EC  uni70EC,  CJK UNIFIED IDEOGRAPH-70EC
        0x6D78, # G+2255  U+6D78  uni6D78,  CJK UNIFIED IDEOGRAPH-6D78
        0x5C3D, # G+2256  U+5C3D  uni5C3D,  CJK UNIFIED IDEOGRAPH-5C3D
        0x52B2, # G+2257  U+52B2  uni52B2,  CJK UNIFIED IDEOGRAPH-52B2
        0x8346, # G+2258  U+8346  uni8346,  CJK UNIFIED IDEOGRAPH-8346
        0x5162, # G+2259  U+5162  uni5162,  CJK UNIFIED IDEOGRAPH-5162
        0x830E, # G+2260  U+830E  uni830E,  CJK UNIFIED IDEOGRAPH-830E
        0x775B, # G+2261  U+775B  uni775B,  CJK UNIFIED IDEOGRAPH-775B
        0x6676, # G+2262  U+6676  uni6676,  CJK UNIFIED IDEOGRAPH-6676
        0x9CB8, # G+2263  U+9CB8  uni9CB8,  CJK UNIFIED IDEOGRAPH-9CB8
        0x4EAC, # G+2264  U+4EAC  uni4EAC,  CJK UNIFIED IDEOGRAPH-4EAC
        0x60CA, # G+2265  U+60CA  uni60CA,  CJK UNIFIED IDEOGRAPH-60CA
        0x7CBE, # G+2266  U+7CBE  uni7CBE,  CJK UNIFIED IDEOGRAPH-7CBE
        0x7CB3, # G+2267  U+7CB3  uni7CB3,  CJK UNIFIED IDEOGRAPH-7CB3
        0x7ECF, # G+2268  U+7ECF  uni7ECF,  CJK UNIFIED IDEOGRAPH-7ECF
        0x4E95, # G+2269  U+4E95  uni4E95,  CJK UNIFIED IDEOGRAPH-4E95
        0x8B66, # G+2270  U+8B66  uni8B66,  CJK UNIFIED IDEOGRAPH-8B66
        0x666F, # G+2271  U+666F  uni666F,  CJK UNIFIED IDEOGRAPH-666F
        0x9888, # G+2272  U+9888  uni9888,  CJK UNIFIED IDEOGRAPH-9888
        0x9759, # G+2273  U+9759  uni9759,  CJK UNIFIED IDEOGRAPH-9759
        0x5883, # G+2274  U+5883  uni5883,  CJK UNIFIED IDEOGRAPH-5883
        0x656C, # G+2275  U+656C  uni656C,  CJK UNIFIED IDEOGRAPH-656C
        0x955C, # G+2276  U+955C  uni955C,  CJK UNIFIED IDEOGRAPH-955C
        0x5F84, # G+2277  U+5F84  uni5F84,  CJK UNIFIED IDEOGRAPH-5F84
        0x75C9, # G+2278  U+75C9  uni75C9,  CJK UNIFIED IDEOGRAPH-75C9
        0x9756, # G+2279  U+9756  uni9756,  CJK UNIFIED IDEOGRAPH-9756
        0x7ADF, # G+2280  U+7ADF  uni7ADF,  CJK UNIFIED IDEOGRAPH-7ADF
        0x7ADE, # G+2281  U+7ADE  uni7ADE,  CJK UNIFIED IDEOGRAPH-7ADE
        0x51C0, # G+2282  U+51C0  uni51C0,  CJK UNIFIED IDEOGRAPH-51C0
        0x70AF, # G+2283  U+70AF  uni70AF,  CJK UNIFIED IDEOGRAPH-70AF
        0x7A98, # G+2284  U+7A98  uni7A98,  CJK UNIFIED IDEOGRAPH-7A98
        0x63EA, # G+2285  U+63EA  uni63EA,  CJK UNIFIED IDEOGRAPH-63EA
        0x7A76, # G+2286  U+7A76  uni7A76,  CJK UNIFIED IDEOGRAPH-7A76
        0x7EA0, # G+2287  U+7EA0  uni7EA0,  CJK UNIFIED IDEOGRAPH-7EA0
        0x7396, # G+2288  U+7396  uni7396,  CJK UNIFIED IDEOGRAPH-7396
        0x2FB2, # G+2289  U+2FB2  uni2FB2,  KANGXI RADICAL LEEK
        0x4E45, # G+2290  U+4E45  uni4E45,  CJK UNIFIED IDEOGRAPH-4E45
        0x7078, # G+2291  U+7078  uni7078,  CJK UNIFIED IDEOGRAPH-7078
        0x4E5D, # G+2292  U+4E5D  uni4E5D,  CJK UNIFIED IDEOGRAPH-4E5D
        0x9152, # G+2293  U+9152  uni9152,  CJK UNIFIED IDEOGRAPH-9152
        0x53A9, # G+2294  U+53A9  uni53A9,  CJK UNIFIED IDEOGRAPH-53A9
        0x6551, # G+2295  U+6551  uni6551,  CJK UNIFIED IDEOGRAPH-6551
        0x65E7, # G+2296  U+65E7  uni65E7,  CJK UNIFIED IDEOGRAPH-65E7
        0x2F85, # G+2297  U+2F85  uni2F85,  KANGXI RADICAL MORTAR
        0x8205, # G+2298  U+8205  uni8205,  CJK UNIFIED IDEOGRAPH-8205
        0x548E, # G+2299  U+548E  uni548E,  CJK UNIFIED IDEOGRAPH-548E
        0x5C31, # G+2300  U+5C31  uni5C31,  CJK UNIFIED IDEOGRAPH-5C31
        0x759A, # G+2301  U+759A  uni759A,  CJK UNIFIED IDEOGRAPH-759A
        0x97A0, # G+2302  U+97A0  uni97A0,  CJK UNIFIED IDEOGRAPH-97A0
        0x62D8, # G+2303  U+62D8  uni62D8,  CJK UNIFIED IDEOGRAPH-62D8
        0x72D9, # G+2304  U+72D9  uni72D9,  CJK UNIFIED IDEOGRAPH-72D9
        0x75BD, # G+2305  U+75BD  uni75BD,  CJK UNIFIED IDEOGRAPH-75BD
        0x5C45, # G+2306  U+5C45  uni5C45,  CJK UNIFIED IDEOGRAPH-5C45
        0x9A79, # G+2307  U+9A79  uni9A79,  CJK UNIFIED IDEOGRAPH-9A79
        0x83CA, # G+2308  U+83CA  uni83CA,  CJK UNIFIED IDEOGRAPH-83CA
        0x5C40, # G+2309  U+5C40  uni5C40,  CJK UNIFIED IDEOGRAPH-5C40
        0x5480, # G+2310  U+5480  uni5480,  CJK UNIFIED IDEOGRAPH-5480
        0x77E9, # G+2311  U+77E9  uni77E9,  CJK UNIFIED IDEOGRAPH-77E9
        0x4E3E, # G+2312  U+4E3E  uni4E3E,  CJK UNIFIED IDEOGRAPH-4E3E
        0x6CAE, # G+2313  U+6CAE  uni6CAE,  CJK UNIFIED IDEOGRAPH-6CAE
        0x805A, # G+2314  U+805A  uni805A,  CJK UNIFIED IDEOGRAPH-805A
        0x62D2, # G+2315  U+62D2  uni62D2,  CJK UNIFIED IDEOGRAPH-62D2
        0x636E, # G+2316  U+636E  uni636E,  CJK UNIFIED IDEOGRAPH-636E
        0x5DE8, # G+2317  U+5DE8  uni5DE8,  CJK UNIFIED IDEOGRAPH-5DE8
        0x5177, # G+2318  U+5177  uni5177,  CJK UNIFIED IDEOGRAPH-5177
        0x8DDD, # G+2319  U+8DDD  uni8DDD,  CJK UNIFIED IDEOGRAPH-8DDD
        0x8E1E, # G+2320  U+8E1E  uni8E1E,  CJK UNIFIED IDEOGRAPH-8E1E
        0x952F, # G+2321  U+952F  uni952F,  CJK UNIFIED IDEOGRAPH-952F
        0x4FF1, # G+2322  U+4FF1  uni4FF1,  CJK UNIFIED IDEOGRAPH-4FF1
        0x53E5, # G+2323  U+53E5  uni53E5,  CJK UNIFIED IDEOGRAPH-53E5
        0x60E7, # G+2324  U+60E7  uni60E7,  CJK UNIFIED IDEOGRAPH-60E7
        0x70AC, # G+2325  U+70AC  uni70AC,  CJK UNIFIED IDEOGRAPH-70AC
        0x5267, # G+2326  U+5267  uni5267,  CJK UNIFIED IDEOGRAPH-5267
        0x6350, # G+2327  U+6350  uni6350,  CJK UNIFIED IDEOGRAPH-6350
        0x9E43, # G+2328  U+9E43  uni9E43,  CJK UNIFIED IDEOGRAPH-9E43
        0x5A1F, # G+2329  U+5A1F  uni5A1F,  CJK UNIFIED IDEOGRAPH-5A1F
        0x5026, # G+2330  U+5026  uni5026,  CJK UNIFIED IDEOGRAPH-5026
        0x7737, # G+2331  U+7737  uni7737,  CJK UNIFIED IDEOGRAPH-7737
        0x5377, # G+2332  U+5377  uni5377,  CJK UNIFIED IDEOGRAPH-5377
        0x7EE2, # G+2333  U+7EE2  uni7EE2,  CJK UNIFIED IDEOGRAPH-7EE2
        0x6485, # G+2334  U+6485  uni6485,  CJK UNIFIED IDEOGRAPH-6485
        0x652B, # G+2335  U+652B  uni652B,  CJK UNIFIED IDEOGRAPH-652B
        0x6289, # G+2336  U+6289  uni6289,  CJK UNIFIED IDEOGRAPH-6289
        0x6398, # G+2337  U+6398  uni6398,  CJK UNIFIED IDEOGRAPH-6398
        0x5014, # G+2338  U+5014  uni5014,  CJK UNIFIED IDEOGRAPH-5014
        0x7235, # G+2339  U+7235  uni7235,  CJK UNIFIED IDEOGRAPH-7235
        0x89C9, # G+2340  U+89C9  uni89C9,  CJK UNIFIED IDEOGRAPH-89C9
        0x51B3, # G+2341  U+51B3  uni51B3,  CJK UNIFIED IDEOGRAPH-51B3
        0x8BC0, # G+2342  U+8BC0  uni8BC0,  CJK UNIFIED IDEOGRAPH-8BC0
        0x7EDD, # G+2343  U+7EDD  uni7EDD,  CJK UNIFIED IDEOGRAPH-7EDD
        0x5747, # G+2344  U+5747  uni5747,  CJK UNIFIED IDEOGRAPH-5747
        0x83CC, # G+2345  U+83CC  uni83CC,  CJK UNIFIED IDEOGRAPH-83CC
        0x94A7, # G+2346  U+94A7  uni94A7,  CJK UNIFIED IDEOGRAPH-94A7
        0x519B, # G+2347  U+519B  uni519B,  CJK UNIFIED IDEOGRAPH-519B
        0x541B, # G+2348  U+541B  uni541B,  CJK UNIFIED IDEOGRAPH-541B
        0x5CFB, # G+2349  U+5CFB  uni5CFB,  CJK UNIFIED IDEOGRAPH-5CFB
        0x4FCA, # G+2350  U+4FCA  uni4FCA,  CJK UNIFIED IDEOGRAPH-4FCA
        0x7AE3, # G+2351  U+7AE3  uni7AE3,  CJK UNIFIED IDEOGRAPH-7AE3
        0x6D5A, # G+2352  U+6D5A  uni6D5A,  CJK UNIFIED IDEOGRAPH-6D5A
        0x90E1, # G+2353  U+90E1  uni90E1,  CJK UNIFIED IDEOGRAPH-90E1
        0x9A8F, # G+2354  U+9A8F  uni9A8F,  CJK UNIFIED IDEOGRAPH-9A8F
        0x5580, # G+2355  U+5580  uni5580,  CJK UNIFIED IDEOGRAPH-5580
        0x5496, # G+2356  U+5496  uni5496,  CJK UNIFIED IDEOGRAPH-5496
        0x5361, # G+2357  U+5361  uni5361,  CJK UNIFIED IDEOGRAPH-5361
        0x54AF, # G+2358  U+54AF  uni54AF,  CJK UNIFIED IDEOGRAPH-54AF
        0x5F00, # G+2359  U+5F00  uni5F00,  CJK UNIFIED IDEOGRAPH-5F00
        0x63E9, # G+2360  U+63E9  uni63E9,  CJK UNIFIED IDEOGRAPH-63E9
        0x6977, # G+2361  U+6977  uni6977,  CJK UNIFIED IDEOGRAPH-6977
        0x51EF, # G+2362  U+51EF  uni51EF,  CJK UNIFIED IDEOGRAPH-51EF
        0x6168, # G+2363  U+6168  uni6168,  CJK UNIFIED IDEOGRAPH-6168
        0x520A, # G+2364  U+520A  uni520A,  CJK UNIFIED IDEOGRAPH-520A
        0x582A, # G+2365  U+582A  uni582A,  CJK UNIFIED IDEOGRAPH-582A
        0x52D8, # G+2366  U+52D8  uni52D8,  CJK UNIFIED IDEOGRAPH-52D8
        0x574E, # G+2367  U+574E  uni574E,  CJK UNIFIED IDEOGRAPH-574E
        0x780D, # G+2368  U+780D  uni780D,  CJK UNIFIED IDEOGRAPH-780D
        0x770B, # G+2369  U+770B  uni770B,  CJK UNIFIED IDEOGRAPH-770B
        0x5EB7, # G+2370  U+5EB7  uni5EB7,  CJK UNIFIED IDEOGRAPH-5EB7
        0x6177, # G+2371  U+6177  uni6177,  CJK UNIFIED IDEOGRAPH-6177
        0x7CE0, # G+2372  U+7CE0  uni7CE0,  CJK UNIFIED IDEOGRAPH-7CE0
        0x625B, # G+2373  U+625B  uni625B,  CJK UNIFIED IDEOGRAPH-625B
        0x6297, # G+2374  U+6297  uni6297,  CJK UNIFIED IDEOGRAPH-6297
        0x4EA2, # G+2375  U+4EA2  uni4EA2,  CJK UNIFIED IDEOGRAPH-4EA2
        0x7095, # G+2376  U+7095  uni7095,  CJK UNIFIED IDEOGRAPH-7095
        0x8003, # G+2377  U+8003  uni8003,  CJK UNIFIED IDEOGRAPH-8003
        0x62F7, # G+2378  U+62F7  uni62F7,  CJK UNIFIED IDEOGRAPH-62F7
        0x70E4, # G+2379  U+70E4  uni70E4,  CJK UNIFIED IDEOGRAPH-70E4
        0x9760, # G+2380  U+9760  uni9760,  CJK UNIFIED IDEOGRAPH-9760
        0x5777, # G+2381  U+5777  uni5777,  CJK UNIFIED IDEOGRAPH-5777
        0x82DB, # G+2382  U+82DB  uni82DB,  CJK UNIFIED IDEOGRAPH-82DB
        0x67EF, # G+2383  U+67EF  uni67EF,  CJK UNIFIED IDEOGRAPH-67EF
        0x68F5, # G+2384  U+68F5  uni68F5,  CJK UNIFIED IDEOGRAPH-68F5
        0x78D5, # G+2385  U+78D5  uni78D5,  CJK UNIFIED IDEOGRAPH-78D5
        0x9897, # G+2386  U+9897  uni9897,  CJK UNIFIED IDEOGRAPH-9897
        0x79D1, # G+2387  U+79D1  uni79D1,  CJK UNIFIED IDEOGRAPH-79D1
        0x58F3, # G+2388  U+58F3  uni58F3,  CJK UNIFIED IDEOGRAPH-58F3
        0x54B3, # G+2389  U+54B3  uni54B3,  CJK UNIFIED IDEOGRAPH-54B3
        0x53EF, # G+2390  U+53EF  uni53EF,  CJK UNIFIED IDEOGRAPH-53EF
        0x6E34, # G+2391  U+6E34  uni6E34,  CJK UNIFIED IDEOGRAPH-6E34
        0x514B, # G+2392  U+514B  uni514B,  CJK UNIFIED IDEOGRAPH-514B
        0x523B, # G+2393  U+523B  uni523B,  CJK UNIFIED IDEOGRAPH-523B
        0x5BA2, # G+2394  U+5BA2  uni5BA2,  CJK UNIFIED IDEOGRAPH-5BA2
        0x8BFE, # G+2395  U+8BFE  uni8BFE,  CJK UNIFIED IDEOGRAPH-8BFE
        0x80AF, # G+2396  U+80AF  uni80AF,  CJK UNIFIED IDEOGRAPH-80AF
        0x5543, # G+2397  U+5543  uni5543,  CJK UNIFIED IDEOGRAPH-5543
        0x57A6, # G+2398  U+57A6  uni57A6,  CJK UNIFIED IDEOGRAPH-57A6
        0x6073, # G+2399  U+6073  uni6073,  CJK UNIFIED IDEOGRAPH-6073
        0x5751, # G+2400  U+5751  uni5751,  CJK UNIFIED IDEOGRAPH-5751
        0x542D, # G+2401  U+542D  uni542D,  CJK UNIFIED IDEOGRAPH-542D
        0x7A7A, # G+2402  U+7A7A  uni7A7A,  CJK UNIFIED IDEOGRAPH-7A7A
        0x6050, # G+2403  U+6050  uni6050,  CJK UNIFIED IDEOGRAPH-6050
        0x5B54, # G+2404  U+5B54  uni5B54,  CJK UNIFIED IDEOGRAPH-5B54
        0x63A7, # G+2405  U+63A7  uni63A7,  CJK UNIFIED IDEOGRAPH-63A7
        0x62A0, # G+2406  U+62A0  uni62A0,  CJK UNIFIED IDEOGRAPH-62A0
        0x2F1D, # G+2407  U+2F1D  uni2F1D,  KANGXI RADICAL MOUTH
        0x6263, # G+2408  U+6263  uni6263,  CJK UNIFIED IDEOGRAPH-6263
        0x5BC7, # G+2409  U+5BC7  uni5BC7,  CJK UNIFIED IDEOGRAPH-5BC7
        0x67AF, # G+2410  U+67AF  uni67AF,  CJK UNIFIED IDEOGRAPH-67AF
        0x54ED, # G+2411  U+54ED  uni54ED,  CJK UNIFIED IDEOGRAPH-54ED
        0x7A9F, # G+2412  U+7A9F  uni7A9F,  CJK UNIFIED IDEOGRAPH-7A9F
        0x82E6, # G+2413  U+82E6  uni82E6,  CJK UNIFIED IDEOGRAPH-82E6
        0x9177, # G+2414  U+9177  uni9177,  CJK UNIFIED IDEOGRAPH-9177
        0x5E93, # G+2415  U+5E93  uni5E93,  CJK UNIFIED IDEOGRAPH-5E93
        0x88E4, # G+2416  U+88E4  uni88E4,  CJK UNIFIED IDEOGRAPH-88E4
        0x5938, # G+2417  U+5938  uni5938,  CJK UNIFIED IDEOGRAPH-5938
        0x57AE, # G+2418  U+57AE  uni57AE,  CJK UNIFIED IDEOGRAPH-57AE
        0x630E, # G+2419  U+630E  uni630E,  CJK UNIFIED IDEOGRAPH-630E
        0x8DE8, # G+2420  U+8DE8  uni8DE8,  CJK UNIFIED IDEOGRAPH-8DE8
        0x80EF, # G+2421  U+80EF  uni80EF,  CJK UNIFIED IDEOGRAPH-80EF
        0x5757, # G+2422  U+5757  uni5757,  CJK UNIFIED IDEOGRAPH-5757
        0x7B77, # G+2423  U+7B77  uni7B77,  CJK UNIFIED IDEOGRAPH-7B77
        0x4FA9, # G+2424  U+4FA9  uni4FA9,  CJK UNIFIED IDEOGRAPH-4FA9
        0x5FEB, # G+2425  U+5FEB  uni5FEB,  CJK UNIFIED IDEOGRAPH-5FEB
        0x5BBD, # G+2426  U+5BBD  uni5BBD,  CJK UNIFIED IDEOGRAPH-5BBD
        0x6B3E, # G+2427  U+6B3E  uni6B3E,  CJK UNIFIED IDEOGRAPH-6B3E
        0x5321, # G+2428  U+5321  uni5321,  CJK UNIFIED IDEOGRAPH-5321
        0x7B50, # G+2429  U+7B50  uni7B50,  CJK UNIFIED IDEOGRAPH-7B50
        0x72C2, # G+2430  U+72C2  uni72C2,  CJK UNIFIED IDEOGRAPH-72C2
        0x6846, # G+2431  U+6846  uni6846,  CJK UNIFIED IDEOGRAPH-6846
        0x77FF, # G+2432  U+77FF  uni77FF,  CJK UNIFIED IDEOGRAPH-77FF
        0x7736, # G+2433  U+7736  uni7736,  CJK UNIFIED IDEOGRAPH-7736
        0x65F7, # G+2434  U+65F7  uni65F7,  CJK UNIFIED IDEOGRAPH-65F7
        0x51B5, # G+2435  U+51B5  uni51B5,  CJK UNIFIED IDEOGRAPH-51B5
        0x4E8F, # G+2436  U+4E8F  uni4E8F,  CJK UNIFIED IDEOGRAPH-4E8F
        0x76D4, # G+2437  U+76D4  uni76D4,  CJK UNIFIED IDEOGRAPH-76D4
        0x5CBF, # G+2438  U+5CBF  uni5CBF,  CJK UNIFIED IDEOGRAPH-5CBF
        0x7AA5, # G+2439  U+7AA5  uni7AA5,  CJK UNIFIED IDEOGRAPH-7AA5
        0x8475, # G+2440  U+8475  uni8475,  CJK UNIFIED IDEOGRAPH-8475
        0x594E, # G+2441  U+594E  uni594E,  CJK UNIFIED IDEOGRAPH-594E
        0x9B41, # G+2442  U+9B41  uni9B41,  CJK UNIFIED IDEOGRAPH-9B41
        0x5080, # G+2443  U+5080  uni5080,  CJK UNIFIED IDEOGRAPH-5080
        0x9988, # G+2444  U+9988  uni9988,  CJK UNIFIED IDEOGRAPH-9988
        0x6127, # G+2445  U+6127  uni6127,  CJK UNIFIED IDEOGRAPH-6127
        0x6E83, # G+2446  U+6E83  uni6E83,  CJK UNIFIED IDEOGRAPH-6E83
        0x5764, # G+2447  U+5764  uni5764,  CJK UNIFIED IDEOGRAPH-5764
        0x6606, # G+2448  U+6606  uni6606,  CJK UNIFIED IDEOGRAPH-6606
        0x6346, # G+2449  U+6346  uni6346,  CJK UNIFIED IDEOGRAPH-6346
        0x56F0, # G+2450  U+56F0  uni56F0,  CJK UNIFIED IDEOGRAPH-56F0
        0x62EC, # G+2451  U+62EC  uni62EC,  CJK UNIFIED IDEOGRAPH-62EC
        0x6269, # G+2452  U+6269  uni6269,  CJK UNIFIED IDEOGRAPH-6269
        0x5ED3, # G+2453  U+5ED3  uni5ED3,  CJK UNIFIED IDEOGRAPH-5ED3
        0x9614, # G+2454  U+9614  uni9614,  CJK UNIFIED IDEOGRAPH-9614
        0x5783, # G+2455  U+5783  uni5783,  CJK UNIFIED IDEOGRAPH-5783
        0x62C9, # G+2456  U+62C9  uni62C9,  CJK UNIFIED IDEOGRAPH-62C9
        0x5587, # G+2457  U+5587  uni5587,  CJK UNIFIED IDEOGRAPH-5587
        0x8721, # G+2458  U+8721  uni8721,  CJK UNIFIED IDEOGRAPH-8721
        0x814A, # G+2459  U+814A  uni814A,  CJK UNIFIED IDEOGRAPH-814A
        0x8FA3, # G+2460  U+8FA3  uni8FA3,  CJK UNIFIED IDEOGRAPH-8FA3
        0x5566, # G+2461  U+5566  uni5566,  CJK UNIFIED IDEOGRAPH-5566
        0x83B1, # G+2462  U+83B1  uni83B1,  CJK UNIFIED IDEOGRAPH-83B1
        0x6765, # G+2463  U+6765  uni6765,  CJK UNIFIED IDEOGRAPH-6765
        0x8D56, # G+2464  U+8D56  uni8D56,  CJK UNIFIED IDEOGRAPH-8D56
        0x84DD, # G+2465  U+84DD  uni84DD,  CJK UNIFIED IDEOGRAPH-84DD
        0x5A6A, # G+2466  U+5A6A  uni5A6A,  CJK UNIFIED IDEOGRAPH-5A6A
        0x680F, # G+2467  U+680F  uni680F,  CJK UNIFIED IDEOGRAPH-680F
        0x62E6, # G+2468  U+62E6  uni62E6,  CJK UNIFIED IDEOGRAPH-62E6
        0x7BEE, # G+2469  U+7BEE  uni7BEE,  CJK UNIFIED IDEOGRAPH-7BEE
        0x9611, # G+2470  U+9611  uni9611,  CJK UNIFIED IDEOGRAPH-9611
        0x5170, # G+2471  U+5170  uni5170,  CJK UNIFIED IDEOGRAPH-5170
        0x6F9C, # G+2472  U+6F9C  uni6F9C,  CJK UNIFIED IDEOGRAPH-6F9C
        0x8C30, # G+2473  U+8C30  uni8C30,  CJK UNIFIED IDEOGRAPH-8C30
        0x63FD, # G+2474  U+63FD  uni63FD,  CJK UNIFIED IDEOGRAPH-63FD
        0x89C8, # G+2475  U+89C8  uni89C8,  CJK UNIFIED IDEOGRAPH-89C8
        0x61D2, # G+2476  U+61D2  uni61D2,  CJK UNIFIED IDEOGRAPH-61D2
        0x7F06, # G+2477  U+7F06  uni7F06,  CJK UNIFIED IDEOGRAPH-7F06
        0x70C2, # G+2478  U+70C2  uni70C2,  CJK UNIFIED IDEOGRAPH-70C2
        0x6EE5, # G+2479  U+6EE5  uni6EE5,  CJK UNIFIED IDEOGRAPH-6EE5
        0x7405, # G+2480  U+7405  uni7405,  CJK UNIFIED IDEOGRAPH-7405
        0x6994, # G+2481  U+6994  uni6994,  CJK UNIFIED IDEOGRAPH-6994
        0x72FC, # G+2482  U+72FC  uni72FC,  CJK UNIFIED IDEOGRAPH-72FC
        0x5ECA, # G+2483  U+5ECA  uni5ECA,  CJK UNIFIED IDEOGRAPH-5ECA
        0x90CE, # G+2484  U+90CE  uni90CE,  CJK UNIFIED IDEOGRAPH-90CE
        0x6717, # G+2485  U+6717  uni6717,  CJK UNIFIED IDEOGRAPH-6717
        0x6D6A, # G+2486  U+6D6A  uni6D6A,  CJK UNIFIED IDEOGRAPH-6D6A
        0x635E, # G+2487  U+635E  uni635E,  CJK UNIFIED IDEOGRAPH-635E
        0x52B3, # G+2488  U+52B3  uni52B3,  CJK UNIFIED IDEOGRAPH-52B3
        0x7262, # G+2489  U+7262  uni7262,  CJK UNIFIED IDEOGRAPH-7262
        0x2F7C, # G+2490  U+2F7C  uni2F7C,  KANGXI RADICAL OLD
        0x4F6C, # G+2491  U+4F6C  uni4F6C,  CJK UNIFIED IDEOGRAPH-4F6C
        0x59E5, # G+2492  U+59E5  uni59E5,  CJK UNIFIED IDEOGRAPH-59E5
        0x916A, # G+2493  U+916A  uni916A,  CJK UNIFIED IDEOGRAPH-916A
        0x70D9, # G+2494  U+70D9  uni70D9,  CJK UNIFIED IDEOGRAPH-70D9
        0x6D9D, # G+2495  U+6D9D  uni6D9D,  CJK UNIFIED IDEOGRAPH-6D9D
        0x52D2, # G+2496  U+52D2  uni52D2,  CJK UNIFIED IDEOGRAPH-52D2
        0x4E50, # G+2497  U+4E50  uni4E50,  CJK UNIFIED IDEOGRAPH-4E50
        0x96F7, # G+2498  U+96F7  uni96F7,  CJK UNIFIED IDEOGRAPH-96F7
        0x956D, # G+2499  U+956D  uni956D,  CJK UNIFIED IDEOGRAPH-956D
        0x857E, # G+2500  U+857E  uni857E,  CJK UNIFIED IDEOGRAPH-857E
        0x78CA, # G+2501  U+78CA  uni78CA,  CJK UNIFIED IDEOGRAPH-78CA
        0x7D2F, # G+2502  U+7D2F  uni7D2F,  CJK UNIFIED IDEOGRAPH-7D2F
        0x5121, # G+2503  U+5121  uni5121,  CJK UNIFIED IDEOGRAPH-5121
        0x5792, # G+2504  U+5792  uni5792,  CJK UNIFIED IDEOGRAPH-5792
        0x64C2, # G+2505  U+64C2  uni64C2,  CJK UNIFIED IDEOGRAPH-64C2
        0x808B, # G+2506  U+808B  uni808B,  CJK UNIFIED IDEOGRAPH-808B
        0x7C7B, # G+2507  U+7C7B  uni7C7B,  CJK UNIFIED IDEOGRAPH-7C7B
        0x6CEA, # G+2508  U+6CEA  uni6CEA,  CJK UNIFIED IDEOGRAPH-6CEA
        0x68F1, # G+2509  U+68F1  uni68F1,  CJK UNIFIED IDEOGRAPH-68F1
        0x695E, # G+2510  U+695E  uni695E,  CJK UNIFIED IDEOGRAPH-695E
        0x51B7, # G+2511  U+51B7  uni51B7,  CJK UNIFIED IDEOGRAPH-51B7
        0x5398, # G+2512  U+5398  uni5398,  CJK UNIFIED IDEOGRAPH-5398
        0x68A8, # G+2513  U+68A8  uni68A8,  CJK UNIFIED IDEOGRAPH-68A8
        0x7281, # G+2514  U+7281  uni7281,  CJK UNIFIED IDEOGRAPH-7281
        0x9ECE, # G+2515  U+9ECE  uni9ECE,  CJK UNIFIED IDEOGRAPH-9ECE
        0x7BF1, # G+2516  U+7BF1  uni7BF1,  CJK UNIFIED IDEOGRAPH-7BF1
        0x72F8, # G+2517  U+72F8  uni72F8,  CJK UNIFIED IDEOGRAPH-72F8
        0x79BB, # G+2518  U+79BB  uni79BB,  CJK UNIFIED IDEOGRAPH-79BB
        0x6F13, # G+2519  U+6F13  uni6F13,  CJK UNIFIED IDEOGRAPH-6F13
        0x7406, # G+2520  U+7406  uni7406,  CJK UNIFIED IDEOGRAPH-7406
        0x674E, # G+2521  U+674E  uni674E,  CJK UNIFIED IDEOGRAPH-674E
        0x2FA5, # G+2522  U+2FA5  uni2FA5,  KANGXI RADICAL VILLAGE
        0x9CA4, # G+2523  U+9CA4  uni9CA4,  CJK UNIFIED IDEOGRAPH-9CA4
        0x793C, # G+2524  U+793C  uni793C,  CJK UNIFIED IDEOGRAPH-793C
        0x8389, # G+2525  U+8389  uni8389,  CJK UNIFIED IDEOGRAPH-8389
        0x8354, # G+2526  U+8354  uni8354,  CJK UNIFIED IDEOGRAPH-8354
        0x540F, # G+2527  U+540F  uni540F,  CJK UNIFIED IDEOGRAPH-540F
        0x6817, # G+2528  U+6817  uni6817,  CJK UNIFIED IDEOGRAPH-6817
        0x4E3D, # G+2529  U+4E3D  uni4E3D,  CJK UNIFIED IDEOGRAPH-4E3D
        0x5389, # G+2530  U+5389  uni5389,  CJK UNIFIED IDEOGRAPH-5389
        0x52B1, # G+2531  U+52B1  uni52B1,  CJK UNIFIED IDEOGRAPH-52B1
        0x783E, # G+2532  U+783E  uni783E,  CJK UNIFIED IDEOGRAPH-783E
        0x5386, # G+2533  U+5386  uni5386,  CJK UNIFIED IDEOGRAPH-5386
        0x5229, # G+2534  U+5229  uni5229,  CJK UNIFIED IDEOGRAPH-5229
        0x5088, # G+2535  U+5088  uni5088,  CJK UNIFIED IDEOGRAPH-5088
        0x4F8B, # G+2536  U+4F8B  uni4F8B,  CJK UNIFIED IDEOGRAPH-4F8B
        0x4FD0, # G+2537  U+4FD0  uni4FD0,  CJK UNIFIED IDEOGRAPH-4FD0
        0x75E2, # G+2538  U+75E2  uni75E2,  CJK UNIFIED IDEOGRAPH-75E2
        0x2F74, # G+2539  U+2F74  uni2F74,  KANGXI RADICAL STAND
        0x7C92, # G+2540  U+7C92  uni7C92,  CJK UNIFIED IDEOGRAPH-7C92
        0x6CA5, # G+2541  U+6CA5  uni6CA5,  CJK UNIFIED IDEOGRAPH-6CA5
        0x2FAA, # G+2542  U+2FAA  uni2FAA,  KANGXI RADICAL SLAVE
        0x2F12, # G+2543  U+2F12  uni2F12,  KANGXI RADICAL POWER
        0x7483, # G+2544  U+7483  uni7483,  CJK UNIFIED IDEOGRAPH-7483
        0x54E9, # G+2545  U+54E9  uni54E9,  CJK UNIFIED IDEOGRAPH-54E9
        0x4FE9, # G+2546  U+4FE9  uni4FE9,  CJK UNIFIED IDEOGRAPH-4FE9
        0x8054, # G+2547  U+8054  uni8054,  CJK UNIFIED IDEOGRAPH-8054
        0x83B2, # G+2548  U+83B2  uni83B2,  CJK UNIFIED IDEOGRAPH-83B2
        0x8FDE, # G+2549  U+8FDE  uni8FDE,  CJK UNIFIED IDEOGRAPH-8FDE
        0x9570, # G+2550  U+9570  uni9570,  CJK UNIFIED IDEOGRAPH-9570
        0x5EC9, # G+2551  U+5EC9  uni5EC9,  CJK UNIFIED IDEOGRAPH-5EC9
        0x601C, # G+2552  U+601C  uni601C,  CJK UNIFIED IDEOGRAPH-601C
        0x6D9F, # G+2553  U+6D9F  uni6D9F,  CJK UNIFIED IDEOGRAPH-6D9F
        0x5E18, # G+2554  U+5E18  uni5E18,  CJK UNIFIED IDEOGRAPH-5E18
        0x655B, # G+2555  U+655B  uni655B,  CJK UNIFIED IDEOGRAPH-655B
        0x8138, # G+2556  U+8138  uni8138,  CJK UNIFIED IDEOGRAPH-8138
        0x94FE, # G+2557  U+94FE  uni94FE,  CJK UNIFIED IDEOGRAPH-94FE
        0x604B, # G+2558  U+604B  uni604B,  CJK UNIFIED IDEOGRAPH-604B
        0x70BC, # G+2559  U+70BC  uni70BC,  CJK UNIFIED IDEOGRAPH-70BC
        0x7EC3, # G+2560  U+7EC3  uni7EC3,  CJK UNIFIED IDEOGRAPH-7EC3
        0x7CAE, # G+2561  U+7CAE  uni7CAE,  CJK UNIFIED IDEOGRAPH-7CAE
        0x51C9, # G+2562  U+51C9  uni51C9,  CJK UNIFIED IDEOGRAPH-51C9
        0x6881, # G+2563  U+6881  uni6881,  CJK UNIFIED IDEOGRAPH-6881
        0x7CB1, # G+2564  U+7CB1  uni7CB1,  CJK UNIFIED IDEOGRAPH-7CB1
        0x826F, # G+2565  U+826F  uni826F,  CJK UNIFIED IDEOGRAPH-826F
        0x4E24, # G+2566  U+4E24  uni4E24,  CJK UNIFIED IDEOGRAPH-4E24
        0x8F86, # G+2567  U+8F86  uni8F86,  CJK UNIFIED IDEOGRAPH-8F86
        0x91CF, # G+2568  U+91CF  uni91CF,  CJK UNIFIED IDEOGRAPH-91CF
        0x667E, # G+2569  U+667E  uni667E,  CJK UNIFIED IDEOGRAPH-667E
        0x4EAE, # G+2570  U+4EAE  uni4EAE,  CJK UNIFIED IDEOGRAPH-4EAE
        0x8C05, # G+2571  U+8C05  uni8C05,  CJK UNIFIED IDEOGRAPH-8C05
        0x64A9, # G+2572  U+64A9  uni64A9,  CJK UNIFIED IDEOGRAPH-64A9
        0x804A, # G+2573  U+804A  uni804A,  CJK UNIFIED IDEOGRAPH-804A
        0x50DA, # G+2574  U+50DA  uni50DA,  CJK UNIFIED IDEOGRAPH-50DA
        0x7597, # G+2575  U+7597  uni7597,  CJK UNIFIED IDEOGRAPH-7597
        0x71CE, # G+2576  U+71CE  uni71CE,  CJK UNIFIED IDEOGRAPH-71CE
        0x5BE5, # G+2577  U+5BE5  uni5BE5,  CJK UNIFIED IDEOGRAPH-5BE5
        0x8FBD, # G+2578  U+8FBD  uni8FBD,  CJK UNIFIED IDEOGRAPH-8FBD
        0x6F66, # G+2579  U+6F66  uni6F66,  CJK UNIFIED IDEOGRAPH-6F66
        0x4E86, # G+2580  U+4E86  uni4E86,  CJK UNIFIED IDEOGRAPH-4E86
        0x6482, # G+2581  U+6482  uni6482,  CJK UNIFIED IDEOGRAPH-6482
        0x9563, # G+2582  U+9563  uni9563,  CJK UNIFIED IDEOGRAPH-9563
        0x5ED6, # G+2583  U+5ED6  uni5ED6,  CJK UNIFIED IDEOGRAPH-5ED6
        0x6599, # G+2584  U+6599  uni6599,  CJK UNIFIED IDEOGRAPH-6599
        0x5217, # G+2585  U+5217  uni5217,  CJK UNIFIED IDEOGRAPH-5217
        0x88C2, # G+2586  U+88C2  uni88C2,  CJK UNIFIED IDEOGRAPH-88C2
        0x70C8, # G+2587  U+70C8  uni70C8,  CJK UNIFIED IDEOGRAPH-70C8
        0x52A3, # G+2588  U+52A3  uni52A3,  CJK UNIFIED IDEOGRAPH-52A3
        0x730E, # G+2589  U+730E  uni730E,  CJK UNIFIED IDEOGRAPH-730E
        0x7433, # G+2590  U+7433  uni7433,  CJK UNIFIED IDEOGRAPH-7433
        0x6797, # G+2591  U+6797  uni6797,  CJK UNIFIED IDEOGRAPH-6797
        0x78F7, # G+2592  U+78F7  uni78F7,  CJK UNIFIED IDEOGRAPH-78F7
        0x9716, # G+2593  U+9716  uni9716,  CJK UNIFIED IDEOGRAPH-9716
        0x4E34, # G+2594  U+4E34  uni4E34,  CJK UNIFIED IDEOGRAPH-4E34
        0x90BB, # G+2595  U+90BB  uni90BB,  CJK UNIFIED IDEOGRAPH-90BB
        0x9CDE, # G+2596  U+9CDE  uni9CDE,  CJK UNIFIED IDEOGRAPH-9CDE
        0x6DCB, # G+2597  U+6DCB  uni6DCB,  CJK UNIFIED IDEOGRAPH-6DCB
        0x51DB, # G+2598  U+51DB  uni51DB,  CJK UNIFIED IDEOGRAPH-51DB
        0x8D41, # G+2599  U+8D41  uni8D41,  CJK UNIFIED IDEOGRAPH-8D41
        0x541D, # G+2600  U+541D  uni541D,  CJK UNIFIED IDEOGRAPH-541D
        0x62CE, # G+2601  U+62CE  uni62CE,  CJK UNIFIED IDEOGRAPH-62CE
        0x73B2, # G+2602  U+73B2  uni73B2,  CJK UNIFIED IDEOGRAPH-73B2
        0x83F1, # G+2603  U+83F1  uni83F1,  CJK UNIFIED IDEOGRAPH-83F1
        0x96F6, # G+2604  U+96F6  uni96F6,  CJK UNIFIED IDEOGRAPH-96F6
        0x9F84, # G+2605  U+9F84  uni9F84,  CJK UNIFIED IDEOGRAPH-9F84
        0x94C3, # G+2606  U+94C3  uni94C3,  CJK UNIFIED IDEOGRAPH-94C3
        0x4F36, # G+2607  U+4F36  uni4F36,  CJK UNIFIED IDEOGRAPH-4F36
        0x7F9A, # G+2608  U+7F9A  uni7F9A,  CJK UNIFIED IDEOGRAPH-7F9A
        0x51CC, # G+2609  U+51CC  uni51CC,  CJK UNIFIED IDEOGRAPH-51CC
        0x7075, # G+2610  U+7075  uni7075,  CJK UNIFIED IDEOGRAPH-7075
        0x9675, # G+2611  U+9675  uni9675,  CJK UNIFIED IDEOGRAPH-9675
        0x5CAD, # G+2612  U+5CAD  uni5CAD,  CJK UNIFIED IDEOGRAPH-5CAD
        0x9886, # G+2613  U+9886  uni9886,  CJK UNIFIED IDEOGRAPH-9886
        0x53E6, # G+2614  U+53E6  uni53E6,  CJK UNIFIED IDEOGRAPH-53E6
        0x4EE4, # G+2615  U+4EE4  uni4EE4,  CJK UNIFIED IDEOGRAPH-4EE4
        0x6E9C, # G+2616  U+6E9C  uni6E9C,  CJK UNIFIED IDEOGRAPH-6E9C
        0x7409, # G+2617  U+7409  uni7409,  CJK UNIFIED IDEOGRAPH-7409
        0x69B4, # G+2618  U+69B4  uni69B4,  CJK UNIFIED IDEOGRAPH-69B4
        0x786B, # G+2619  U+786B  uni786B,  CJK UNIFIED IDEOGRAPH-786B
        0x998F, # G+2620  U+998F  uni998F,  CJK UNIFIED IDEOGRAPH-998F
        0x7559, # G+2621  U+7559  uni7559,  CJK UNIFIED IDEOGRAPH-7559
        0x5218, # G+2622  U+5218  uni5218,  CJK UNIFIED IDEOGRAPH-5218
        0x7624, # G+2623  U+7624  uni7624,  CJK UNIFIED IDEOGRAPH-7624
        0x6D41, # G+2624  U+6D41  uni6D41,  CJK UNIFIED IDEOGRAPH-6D41
        0x67F3, # G+2625  U+67F3  uni67F3,  CJK UNIFIED IDEOGRAPH-67F3
        0x516D, # G+2626  U+516D  uni516D,  CJK UNIFIED IDEOGRAPH-516D
        0x9F99, # G+2627  U+9F99  uni9F99,  CJK UNIFIED IDEOGRAPH-9F99
        0x804B, # G+2628  U+804B  uni804B,  CJK UNIFIED IDEOGRAPH-804B
        0x5499, # G+2629  U+5499  uni5499,  CJK UNIFIED IDEOGRAPH-5499
        0x7B3C, # G+2630  U+7B3C  uni7B3C,  CJK UNIFIED IDEOGRAPH-7B3C
        0x7ABF, # G+2631  U+7ABF  uni7ABF,  CJK UNIFIED IDEOGRAPH-7ABF
        0x9686, # G+2632  U+9686  uni9686,  CJK UNIFIED IDEOGRAPH-9686
        0x5784, # G+2633  U+5784  uni5784,  CJK UNIFIED IDEOGRAPH-5784
        0x62E2, # G+2634  U+62E2  uni62E2,  CJK UNIFIED IDEOGRAPH-62E2
        0x9647, # G+2635  U+9647  uni9647,  CJK UNIFIED IDEOGRAPH-9647
        0x697C, # G+2636  U+697C  uni697C,  CJK UNIFIED IDEOGRAPH-697C
        0x5A04, # G+2637  U+5A04  uni5A04,  CJK UNIFIED IDEOGRAPH-5A04
        0x6402, # G+2638  U+6402  uni6402,  CJK UNIFIED IDEOGRAPH-6402
        0x7BD3, # G+2639  U+7BD3  uni7BD3,  CJK UNIFIED IDEOGRAPH-7BD3
        0x6F0F, # G+2640  U+6F0F  uni6F0F,  CJK UNIFIED IDEOGRAPH-6F0F
        0x964B, # G+2641  U+964B  uni964B,  CJK UNIFIED IDEOGRAPH-964B
        0x82A6, # G+2642  U+82A6  uni82A6,  CJK UNIFIED IDEOGRAPH-82A6
        0x5362, # G+2643  U+5362  uni5362,  CJK UNIFIED IDEOGRAPH-5362
        0x9885, # G+2644  U+9885  uni9885,  CJK UNIFIED IDEOGRAPH-9885
        0x5E90, # G+2645  U+5E90  uni5E90,  CJK UNIFIED IDEOGRAPH-5E90
        0x7089, # G+2646  U+7089  uni7089,  CJK UNIFIED IDEOGRAPH-7089
        0x63B3, # G+2647  U+63B3  uni63B3,  CJK UNIFIED IDEOGRAPH-63B3
        0x5364, # G+2648  U+5364  uni5364,  CJK UNIFIED IDEOGRAPH-5364
        0x864F, # G+2649  U+864F  uni864F,  CJK UNIFIED IDEOGRAPH-864F
        0x9C81, # G+2650  U+9C81  uni9C81,  CJK UNIFIED IDEOGRAPH-9C81
        0x9E93, # G+2651  U+9E93  uni9E93,  CJK UNIFIED IDEOGRAPH-9E93
        0x788C, # G+2652  U+788C  uni788C,  CJK UNIFIED IDEOGRAPH-788C
        0x9732, # G+2653  U+9732  uni9732,  CJK UNIFIED IDEOGRAPH-9732
        0x8DEF, # G+2654  U+8DEF  uni8DEF,  CJK UNIFIED IDEOGRAPH-8DEF
        0x8D42, # G+2655  U+8D42  uni8D42,  CJK UNIFIED IDEOGRAPH-8D42
        0x2FC5, # G+2656  U+2FC5  uni2FC5,  KANGXI RADICAL DEER
        0x6F5E, # G+2657  U+6F5E  uni6F5E,  CJK UNIFIED IDEOGRAPH-6F5E
        0x7984, # G+2658  U+7984  uni7984,  CJK UNIFIED IDEOGRAPH-7984
        0x5F55, # G+2659  U+5F55  uni5F55,  CJK UNIFIED IDEOGRAPH-5F55
        0x9646, # G+2660  U+9646  uni9646,  CJK UNIFIED IDEOGRAPH-9646
        0x622E, # G+2661  U+622E  uni622E,  CJK UNIFIED IDEOGRAPH-622E
        0x9A74, # G+2662  U+9A74  uni9A74,  CJK UNIFIED IDEOGRAPH-9A74
        0x5415, # G+2663  U+5415  uni5415,  CJK UNIFIED IDEOGRAPH-5415
        0x94DD, # G+2664  U+94DD  uni94DD,  CJK UNIFIED IDEOGRAPH-94DD
        0x4FA3, # G+2665  U+4FA3  uni4FA3,  CJK UNIFIED IDEOGRAPH-4FA3
        0x65C5, # G+2666  U+65C5  uni65C5,  CJK UNIFIED IDEOGRAPH-65C5
        0x5C65, # G+2667  U+5C65  uni5C65,  CJK UNIFIED IDEOGRAPH-5C65
        0x5C61, # G+2668  U+5C61  uni5C61,  CJK UNIFIED IDEOGRAPH-5C61
        0x7F15, # G+2669  U+7F15  uni7F15,  CJK UNIFIED IDEOGRAPH-7F15
        0x8651, # G+2670  U+8651  uni8651,  CJK UNIFIED IDEOGRAPH-8651
        0x6C2F, # G+2671  U+6C2F  uni6C2F,  CJK UNIFIED IDEOGRAPH-6C2F
        0x5F8B, # G+2672  U+5F8B  uni5F8B,  CJK UNIFIED IDEOGRAPH-5F8B
        0x7387, # G+2673  U+7387  uni7387,  CJK UNIFIED IDEOGRAPH-7387
        0x6EE4, # G+2674  U+6EE4  uni6EE4,  CJK UNIFIED IDEOGRAPH-6EE4
        0x7EFF, # G+2675  U+7EFF  uni7EFF,  CJK UNIFIED IDEOGRAPH-7EFF
        0x5CE6, # G+2676  U+5CE6  uni5CE6,  CJK UNIFIED IDEOGRAPH-5CE6
        0x631B, # G+2677  U+631B  uni631B,  CJK UNIFIED IDEOGRAPH-631B
        0x5B6A, # G+2678  U+5B6A  uni5B6A,  CJK UNIFIED IDEOGRAPH-5B6A
        0x6EE6, # G+2679  U+6EE6  uni6EE6,  CJK UNIFIED IDEOGRAPH-6EE6
        0x5375, # G+2680  U+5375  uni5375,  CJK UNIFIED IDEOGRAPH-5375
        0x4E71, # G+2681  U+4E71  uni4E71,  CJK UNIFIED IDEOGRAPH-4E71
        0x63A0, # G+2682  U+63A0  uni63A0,  CJK UNIFIED IDEOGRAPH-63A0
        0x7565, # G+2683  U+7565  uni7565,  CJK UNIFIED IDEOGRAPH-7565
        0x62A1, # G+2684  U+62A1  uni62A1,  CJK UNIFIED IDEOGRAPH-62A1
        0x8F6E, # G+2685  U+8F6E  uni8F6E,  CJK UNIFIED IDEOGRAPH-8F6E
        0x4F26, # G+2686  U+4F26  uni4F26,  CJK UNIFIED IDEOGRAPH-4F26
        0x4ED1, # G+2687  U+4ED1  uni4ED1,  CJK UNIFIED IDEOGRAPH-4ED1
        0x6CA6, # G+2688  U+6CA6  uni6CA6,  CJK UNIFIED IDEOGRAPH-6CA6
        0x7EB6, # G+2689  U+7EB6  uni7EB6,  CJK UNIFIED IDEOGRAPH-7EB6
        0x8BBA, # G+2690  U+8BBA  uni8BBA,  CJK UNIFIED IDEOGRAPH-8BBA
        0x841D, # G+2691  U+841D  uni841D,  CJK UNIFIED IDEOGRAPH-841D
        0x87BA, # G+2692  U+87BA  uni87BA,  CJK UNIFIED IDEOGRAPH-87BA
        0x7F57, # G+2693  U+7F57  uni7F57,  CJK UNIFIED IDEOGRAPH-7F57
        0x903B, # G+2694  U+903B  uni903B,  CJK UNIFIED IDEOGRAPH-903B
        0x9523, # G+2695  U+9523  uni9523,  CJK UNIFIED IDEOGRAPH-9523
        0x7BA9, # G+2696  U+7BA9  uni7BA9,  CJK UNIFIED IDEOGRAPH-7BA9
        0x9AA1, # G+2697  U+9AA1  uni9AA1,  CJK UNIFIED IDEOGRAPH-9AA1
        0x88F8, # G+2698  U+88F8  uni88F8,  CJK UNIFIED IDEOGRAPH-88F8
        0x843D, # G+2699  U+843D  uni843D,  CJK UNIFIED IDEOGRAPH-843D
        0x6D1B, # G+2700  U+6D1B  uni6D1B,  CJK UNIFIED IDEOGRAPH-6D1B
        0x9A86, # G+2701  U+9A86  uni9A86,  CJK UNIFIED IDEOGRAPH-9A86
        0x7EDC, # G+2702  U+7EDC  uni7EDC,  CJK UNIFIED IDEOGRAPH-7EDC
        0x5988, # G+2703  U+5988  uni5988,  CJK UNIFIED IDEOGRAPH-5988
        0x2FC7, # G+2704  U+2FC7  uni2FC7,  KANGXI RADICAL HEMP
        0x739B, # G+2705  U+739B  uni739B,  CJK UNIFIED IDEOGRAPH-739B
        0x7801, # G+2706  U+7801  uni7801,  CJK UNIFIED IDEOGRAPH-7801
        0x8682, # G+2707  U+8682  uni8682,  CJK UNIFIED IDEOGRAPH-8682
        0x9A6C, # G+2708  U+9A6C  uni9A6C,  CJK UNIFIED IDEOGRAPH-9A6C
        0x9A82, # G+2709  U+9A82  uni9A82,  CJK UNIFIED IDEOGRAPH-9A82
        0x561B, # G+2710  U+561B  uni561B,  CJK UNIFIED IDEOGRAPH-561B
        0x5417, # G+2711  U+5417  uni5417,  CJK UNIFIED IDEOGRAPH-5417
        0x57CB, # G+2712  U+57CB  uni57CB,  CJK UNIFIED IDEOGRAPH-57CB
        0x4E70, # G+2713  U+4E70  uni4E70,  CJK UNIFIED IDEOGRAPH-4E70
        0x9EA6, # G+2714  U+9EA6  uni9EA6,  CJK UNIFIED IDEOGRAPH-9EA6
        0x5356, # G+2715  U+5356  uni5356,  CJK UNIFIED IDEOGRAPH-5356
        0x8FC8, # G+2716  U+8FC8  uni8FC8,  CJK UNIFIED IDEOGRAPH-8FC8
        0x8109, # G+2717  U+8109  uni8109,  CJK UNIFIED IDEOGRAPH-8109
        0x7792, # G+2718  U+7792  uni7792,  CJK UNIFIED IDEOGRAPH-7792
        0x9992, # G+2719  U+9992  uni9992,  CJK UNIFIED IDEOGRAPH-9992
        0x86EE, # G+2720  U+86EE  uni86EE,  CJK UNIFIED IDEOGRAPH-86EE
        0x6EE1, # G+2721  U+6EE1  uni6EE1,  CJK UNIFIED IDEOGRAPH-6EE1
        0x8513, # G+2722  U+8513  uni8513,  CJK UNIFIED IDEOGRAPH-8513
        0x66FC, # G+2723  U+66FC  uni66FC,  CJK UNIFIED IDEOGRAPH-66FC
        0x6162, # G+2724  U+6162  uni6162,  CJK UNIFIED IDEOGRAPH-6162
        0x6F2B, # G+2725  U+6F2B  uni6F2B,  CJK UNIFIED IDEOGRAPH-6F2B
        0x8C29, # G+2726  U+8C29  uni8C29,  CJK UNIFIED IDEOGRAPH-8C29
        0x8292, # G+2727  U+8292  uni8292,  CJK UNIFIED IDEOGRAPH-8292
        0x832B, # G+2728  U+832B  uni832B,  CJK UNIFIED IDEOGRAPH-832B
        0x76F2, # G+2729  U+76F2  uni76F2,  CJK UNIFIED IDEOGRAPH-76F2
        0x6C13, # G+2730  U+6C13  uni6C13,  CJK UNIFIED IDEOGRAPH-6C13
        0x5FD9, # G+2731  U+5FD9  uni5FD9,  CJK UNIFIED IDEOGRAPH-5FD9
        0x83BD, # G+2732  U+83BD  uni83BD,  CJK UNIFIED IDEOGRAPH-83BD
        0x732B, # G+2733  U+732B  uni732B,  CJK UNIFIED IDEOGRAPH-732B
        0x8305, # G+2734  U+8305  uni8305,  CJK UNIFIED IDEOGRAPH-8305
        0x951A, # G+2735  U+951A  uni951A,  CJK UNIFIED IDEOGRAPH-951A
        0x2F51, # G+2736  U+2F51  uni2F51,  KANGXI RADICAL FUR
        0x2F6D, # G+2737  U+2F6D  uni2F6D,  KANGXI RADICAL SPEAR
        0x94C6, # G+2738  U+94C6  uni94C6,  CJK UNIFIED IDEOGRAPH-94C6
        0x536F, # G+2739  U+536F  uni536F,  CJK UNIFIED IDEOGRAPH-536F
        0x8302, # G+2740  U+8302  uni8302,  CJK UNIFIED IDEOGRAPH-8302
        0x5192, # G+2741  U+5192  uni5192,  CJK UNIFIED IDEOGRAPH-5192
        0x5E3D, # G+2742  U+5E3D  uni5E3D,  CJK UNIFIED IDEOGRAPH-5E3D
        0x8C8C, # G+2743  U+8C8C  uni8C8C,  CJK UNIFIED IDEOGRAPH-8C8C
        0x8D38, # G+2744  U+8D38  uni8D38,  CJK UNIFIED IDEOGRAPH-8D38
        0x4E48, # G+2745  U+4E48  uni4E48,  CJK UNIFIED IDEOGRAPH-4E48
        0x73AB, # G+2746  U+73AB  uni73AB,  CJK UNIFIED IDEOGRAPH-73AB
        0x679A, # G+2747  U+679A  uni679A,  CJK UNIFIED IDEOGRAPH-679A
        0x6885, # G+2748  U+6885  uni6885,  CJK UNIFIED IDEOGRAPH-6885
        0x9176, # G+2749  U+9176  uni9176,  CJK UNIFIED IDEOGRAPH-9176
        0x9709, # G+2750  U+9709  uni9709,  CJK UNIFIED IDEOGRAPH-9709
        0x7164, # G+2751  U+7164  uni7164,  CJK UNIFIED IDEOGRAPH-7164
        0x6CA1, # G+2752  U+6CA1  uni6CA1,  CJK UNIFIED IDEOGRAPH-6CA1
        0x7709, # G+2753  U+7709  uni7709,  CJK UNIFIED IDEOGRAPH-7709
        0x5A92, # G+2754  U+5A92  uni5A92,  CJK UNIFIED IDEOGRAPH-5A92
        0x9541, # G+2755  U+9541  uni9541,  CJK UNIFIED IDEOGRAPH-9541
        0x6BCF, # G+2756  U+6BCF  uni6BCF,  CJK UNIFIED IDEOGRAPH-6BCF
        0x7F8E, # G+2757  U+7F8E  uni7F8E,  CJK UNIFIED IDEOGRAPH-7F8E
        0x6627, # G+2758  U+6627  uni6627,  CJK UNIFIED IDEOGRAPH-6627
        0x5BD0, # G+2759  U+5BD0  uni5BD0,  CJK UNIFIED IDEOGRAPH-5BD0
        0x59B9, # G+2760  U+59B9  uni59B9,  CJK UNIFIED IDEOGRAPH-59B9
        0x5A9A, # G+2761  U+5A9A  uni5A9A,  CJK UNIFIED IDEOGRAPH-5A9A
        0x95E8, # G+2762  U+95E8  uni95E8,  CJK UNIFIED IDEOGRAPH-95E8
        0x95F7, # G+2763  U+95F7  uni95F7,  CJK UNIFIED IDEOGRAPH-95F7
        0x4EEC, # G+2764  U+4EEC  uni4EEC,  CJK UNIFIED IDEOGRAPH-4EEC
        0x840C, # G+2765  U+840C  uni840C,  CJK UNIFIED IDEOGRAPH-840C
        0x8499, # G+2766  U+8499  uni8499,  CJK UNIFIED IDEOGRAPH-8499
        0x6AAC, # G+2767  U+6AAC  uni6AAC,  CJK UNIFIED IDEOGRAPH-6AAC
        0x76DF, # G+2768  U+76DF  uni76DF,  CJK UNIFIED IDEOGRAPH-76DF
        0x9530, # G+2769  U+9530  uni9530,  CJK UNIFIED IDEOGRAPH-9530
        0x731B, # G+2770  U+731B  uni731B,  CJK UNIFIED IDEOGRAPH-731B
        0x68A6, # G+2771  U+68A6  uni68A6,  CJK UNIFIED IDEOGRAPH-68A6
        0x5B5F, # G+2772  U+5B5F  uni5B5F,  CJK UNIFIED IDEOGRAPH-5B5F
        0x772F, # G+2773  U+772F  uni772F,  CJK UNIFIED IDEOGRAPH-772F
        0x919A, # G+2774  U+919A  uni919A,  CJK UNIFIED IDEOGRAPH-919A
        0x9761, # G+2775  U+9761  uni9761,  CJK UNIFIED IDEOGRAPH-9761
        0x7CDC, # G+2776  U+7CDC  uni7CDC,  CJK UNIFIED IDEOGRAPH-7CDC
        0x8FF7, # G+2777  U+8FF7  uni8FF7,  CJK UNIFIED IDEOGRAPH-8FF7
        0x8C1C, # G+2778  U+8C1C  uni8C1C,  CJK UNIFIED IDEOGRAPH-8C1C
        0x5F25, # G+2779  U+5F25  uni5F25,  CJK UNIFIED IDEOGRAPH-5F25
        0x2F76, # G+2780  U+2F76  uni2F76,  KANGXI RADICAL RICE
        0x79D8, # G+2781  U+79D8  uni79D8,  CJK UNIFIED IDEOGRAPH-79D8
        0x89C5, # G+2782  U+89C5  uni89C5,  CJK UNIFIED IDEOGRAPH-89C5
        0x6CCC, # G+2783  U+6CCC  uni6CCC,  CJK UNIFIED IDEOGRAPH-6CCC
        0x871C, # G+2784  U+871C  uni871C,  CJK UNIFIED IDEOGRAPH-871C
        0x5BC6, # G+2785  U+5BC6  uni5BC6,  CJK UNIFIED IDEOGRAPH-5BC6
        0x5E42, # G+2786  U+5E42  uni5E42,  CJK UNIFIED IDEOGRAPH-5E42
        0x68C9, # G+2787  U+68C9  uni68C9,  CJK UNIFIED IDEOGRAPH-68C9
        0x7720, # G+2788  U+7720  uni7720,  CJK UNIFIED IDEOGRAPH-7720
        0x7EF5, # G+2789  U+7EF5  uni7EF5,  CJK UNIFIED IDEOGRAPH-7EF5
        0x5195, # G+2790  U+5195  uni5195,  CJK UNIFIED IDEOGRAPH-5195
        0x514D, # G+2791  U+514D  uni514D,  CJK UNIFIED IDEOGRAPH-514D
        0x52C9, # G+2792  U+52C9  uni52C9,  CJK UNIFIED IDEOGRAPH-52C9
        0x5A29, # G+2793  U+5A29  uni5A29,  CJK UNIFIED IDEOGRAPH-5A29
        0x7F05, # G+2794  U+7F05  uni7F05,  CJK UNIFIED IDEOGRAPH-7F05
        0x2FAF, # G+2795  U+2FAF  uni2FAF,  KANGXI RADICAL FACE
        0x82D7, # G+2796  U+82D7  uni82D7,  CJK UNIFIED IDEOGRAPH-82D7
        0x63CF, # G+2797  U+63CF  uni63CF,  CJK UNIFIED IDEOGRAPH-63CF
        0x7784, # G+2798  U+7784  uni7784,  CJK UNIFIED IDEOGRAPH-7784
        0x85D0, # G+2799  U+85D0  uni85D0,  CJK UNIFIED IDEOGRAPH-85D0
        0x79D2, # G+2800  U+79D2  uni79D2,  CJK UNIFIED IDEOGRAPH-79D2
        0x6E3A, # G+2801  U+6E3A  uni6E3A,  CJK UNIFIED IDEOGRAPH-6E3A
        0x5E99, # G+2802  U+5E99  uni5E99,  CJK UNIFIED IDEOGRAPH-5E99
        0x5999, # G+2803  U+5999  uni5999,  CJK UNIFIED IDEOGRAPH-5999
        0x8511, # G+2804  U+8511  uni8511,  CJK UNIFIED IDEOGRAPH-8511
        0x706D, # G+2805  U+706D  uni706D,  CJK UNIFIED IDEOGRAPH-706D
        0x6C11, # G+2806  U+6C11  uni6C11,  CJK UNIFIED IDEOGRAPH-6C11
        0x62BF, # G+2807  U+62BF  uni62BF,  CJK UNIFIED IDEOGRAPH-62BF
        0x2F6B, # G+2808  U+2F6B  uni2F6B,  KANGXI RADICAL DISH
        0x654F, # G+2809  U+654F  uni654F,  CJK UNIFIED IDEOGRAPH-654F
        0x60AF, # G+2810  U+60AF  uni60AF,  CJK UNIFIED IDEOGRAPH-60AF
        0x95FD, # G+2811  U+95FD  uni95FD,  CJK UNIFIED IDEOGRAPH-95FD
        0x660E, # G+2812  U+660E  uni660E,  CJK UNIFIED IDEOGRAPH-660E
        0x879F, # G+2813  U+879F  uni879F,  CJK UNIFIED IDEOGRAPH-879F
        0x9E23, # G+2814  U+9E23  uni9E23,  CJK UNIFIED IDEOGRAPH-9E23
        0x94ED, # G+2815  U+94ED  uni94ED,  CJK UNIFIED IDEOGRAPH-94ED
        0x540D, # G+2816  U+540D  uni540D,  CJK UNIFIED IDEOGRAPH-540D
        0x547D, # G+2817  U+547D  uni547D,  CJK UNIFIED IDEOGRAPH-547D
        0x8C2C, # G+2818  U+8C2C  uni8C2C,  CJK UNIFIED IDEOGRAPH-8C2C
        0x6478, # G+2819  U+6478  uni6478,  CJK UNIFIED IDEOGRAPH-6478
        0x6479, # G+2820  U+6479  uni6479,  CJK UNIFIED IDEOGRAPH-6479
        0x8611, # G+2821  U+8611  uni8611,  CJK UNIFIED IDEOGRAPH-8611
        0x6A21, # G+2822  U+6A21  uni6A21,  CJK UNIFIED IDEOGRAPH-6A21
        0x819C, # G+2823  U+819C  uni819C,  CJK UNIFIED IDEOGRAPH-819C
        0x78E8, # G+2824  U+78E8  uni78E8,  CJK UNIFIED IDEOGRAPH-78E8
        0x6469, # G+2825  U+6469  uni6469,  CJK UNIFIED IDEOGRAPH-6469
        0x9B54, # G+2826  U+9B54  uni9B54,  CJK UNIFIED IDEOGRAPH-9B54
        0x62B9, # G+2827  U+62B9  uni62B9,  CJK UNIFIED IDEOGRAPH-62B9
        0x672B, # G+2828  U+672B  uni672B,  CJK UNIFIED IDEOGRAPH-672B
        0x83AB, # G+2829  U+83AB  uni83AB,  CJK UNIFIED IDEOGRAPH-83AB
        0x58A8, # G+2830  U+58A8  uni58A8,  CJK UNIFIED IDEOGRAPH-58A8
        0x9ED8, # G+2831  U+9ED8  uni9ED8,  CJK UNIFIED IDEOGRAPH-9ED8
        0x6CAB, # G+2832  U+6CAB  uni6CAB,  CJK UNIFIED IDEOGRAPH-6CAB
        0x6F20, # G+2833  U+6F20  uni6F20,  CJK UNIFIED IDEOGRAPH-6F20
        0x5BDE, # G+2834  U+5BDE  uni5BDE,  CJK UNIFIED IDEOGRAPH-5BDE
        0x964C, # G+2835  U+964C  uni964C,  CJK UNIFIED IDEOGRAPH-964C
        0x8C0B, # G+2836  U+8C0B  uni8C0B,  CJK UNIFIED IDEOGRAPH-8C0B
        0x725F, # G+2837  U+725F  uni725F,  CJK UNIFIED IDEOGRAPH-725F
        0x67D0, # G+2838  U+67D0  uni67D0,  CJK UNIFIED IDEOGRAPH-67D0
        0x62C7, # G+2839  U+62C7  uni62C7,  CJK UNIFIED IDEOGRAPH-62C7
        0x7261, # G+2840  U+7261  uni7261,  CJK UNIFIED IDEOGRAPH-7261
        0x4EA9, # G+2841  U+4EA9  uni4EA9,  CJK UNIFIED IDEOGRAPH-4EA9
        0x59C6, # G+2842  U+59C6  uni59C6,  CJK UNIFIED IDEOGRAPH-59C6
        0x6BCD, # G+2843  U+6BCD  uni6BCD,  CJK UNIFIED IDEOGRAPH-6BCD
        0x5893, # G+2844  U+5893  uni5893,  CJK UNIFIED IDEOGRAPH-5893
        0x66AE, # G+2845  U+66AE  uni66AE,  CJK UNIFIED IDEOGRAPH-66AE
        0x5E55, # G+2846  U+5E55  uni5E55,  CJK UNIFIED IDEOGRAPH-5E55
        0x52DF, # G+2847  U+52DF  uni52DF,  CJK UNIFIED IDEOGRAPH-52DF
        0x6155, # G+2848  U+6155  uni6155,  CJK UNIFIED IDEOGRAPH-6155
        0x2F4A, # G+2849  U+2F4A  uni2F4A,  KANGXI RADICAL TREE
        0x2F6C, # G+2850  U+2F6C  uni2F6C,  KANGXI RADICAL EYE
        0x7766, # G+2851  U+7766  uni7766,  CJK UNIFIED IDEOGRAPH-7766
        0x7267, # G+2852  U+7267  uni7267,  CJK UNIFIED IDEOGRAPH-7267
        0x7A46, # G+2853  U+7A46  uni7A46,  CJK UNIFIED IDEOGRAPH-7A46
        0x62FF, # G+2854  U+62FF  uni62FF,  CJK UNIFIED IDEOGRAPH-62FF
        0x54EA, # G+2855  U+54EA  uni54EA,  CJK UNIFIED IDEOGRAPH-54EA
        0x5450, # G+2856  U+5450  uni5450,  CJK UNIFIED IDEOGRAPH-5450
        0x94A0, # G+2857  U+94A0  uni94A0,  CJK UNIFIED IDEOGRAPH-94A0
        0x90A3, # G+2858  U+90A3  uni90A3,  CJK UNIFIED IDEOGRAPH-90A3
        0x5A1C, # G+2859  U+5A1C  uni5A1C,  CJK UNIFIED IDEOGRAPH-5A1C
        0x7EB3, # G+2860  U+7EB3  uni7EB3,  CJK UNIFIED IDEOGRAPH-7EB3
        0x6C16, # G+2861  U+6C16  uni6C16,  CJK UNIFIED IDEOGRAPH-6C16
        0x4E43, # G+2862  U+4E43  uni4E43,  CJK UNIFIED IDEOGRAPH-4E43
        0x5976, # G+2863  U+5976  uni5976,  CJK UNIFIED IDEOGRAPH-5976
        0x8010, # G+2864  U+8010  uni8010,  CJK UNIFIED IDEOGRAPH-8010
        0x5948, # G+2865  U+5948  uni5948,  CJK UNIFIED IDEOGRAPH-5948
        0x5357, # G+2866  U+5357  uni5357,  CJK UNIFIED IDEOGRAPH-5357
        0x7537, # G+2867  U+7537  uni7537,  CJK UNIFIED IDEOGRAPH-7537
        0x96BE, # G+2868  U+96BE  uni96BE,  CJK UNIFIED IDEOGRAPH-96BE
        0x56CA, # G+2869  U+56CA  uni56CA,  CJK UNIFIED IDEOGRAPH-56CA
        0x6320, # G+2870  U+6320  uni6320,  CJK UNIFIED IDEOGRAPH-6320
        0x8111, # G+2871  U+8111  uni8111,  CJK UNIFIED IDEOGRAPH-8111
        0x607C, # G+2872  U+607C  uni607C,  CJK UNIFIED IDEOGRAPH-607C
        0x95F9, # G+2873  U+95F9  uni95F9,  CJK UNIFIED IDEOGRAPH-95F9
        0x6DD6, # G+2874  U+6DD6  uni6DD6,  CJK UNIFIED IDEOGRAPH-6DD6
        0x5462, # G+2875  U+5462  uni5462,  CJK UNIFIED IDEOGRAPH-5462
        0x9981, # G+2876  U+9981  uni9981,  CJK UNIFIED IDEOGRAPH-9981
        0x5185, # G+2877  U+5185  uni5185,  CJK UNIFIED IDEOGRAPH-5185
        0x5AE9, # G+2878  U+5AE9  uni5AE9,  CJK UNIFIED IDEOGRAPH-5AE9
        0x80FD, # G+2879  U+80FD  uni80FD,  CJK UNIFIED IDEOGRAPH-80FD
        0x59AE, # G+2880  U+59AE  uni59AE,  CJK UNIFIED IDEOGRAPH-59AE
        0x9713, # G+2881  U+9713  uni9713,  CJK UNIFIED IDEOGRAPH-9713
        0x502A, # G+2882  U+502A  uni502A,  CJK UNIFIED IDEOGRAPH-502A
        0x6CE5, # G+2883  U+6CE5  uni6CE5,  CJK UNIFIED IDEOGRAPH-6CE5
        0x5C3C, # G+2884  U+5C3C  uni5C3C,  CJK UNIFIED IDEOGRAPH-5C3C
        0x62DF, # G+2885  U+62DF  uni62DF,  CJK UNIFIED IDEOGRAPH-62DF
        0x4F60, # G+2886  U+4F60  uni4F60,  CJK UNIFIED IDEOGRAPH-4F60
        0x533F, # G+2887  U+533F  uni533F,  CJK UNIFIED IDEOGRAPH-533F
        0x817B, # G+2888  U+817B  uni817B,  CJK UNIFIED IDEOGRAPH-817B
        0x9006, # G+2889  U+9006  uni9006,  CJK UNIFIED IDEOGRAPH-9006
        0x6EBA, # G+2890  U+6EBA  uni6EBA,  CJK UNIFIED IDEOGRAPH-6EBA
        0x852B, # G+2891  U+852B  uni852B,  CJK UNIFIED IDEOGRAPH-852B
        0x62C8, # G+2892  U+62C8  uni62C8,  CJK UNIFIED IDEOGRAPH-62C8
        0x5E74, # G+2893  U+5E74  uni5E74,  CJK UNIFIED IDEOGRAPH-5E74
        0x78BE, # G+2894  U+78BE  uni78BE,  CJK UNIFIED IDEOGRAPH-78BE
        0x64B5, # G+2895  U+64B5  uni64B5,  CJK UNIFIED IDEOGRAPH-64B5
        0x637B, # G+2896  U+637B  uni637B,  CJK UNIFIED IDEOGRAPH-637B
        0x5FF5, # G+2897  U+5FF5  uni5FF5,  CJK UNIFIED IDEOGRAPH-5FF5
        0x5A18, # G+2898  U+5A18  uni5A18,  CJK UNIFIED IDEOGRAPH-5A18
        0x917F, # G+2899  U+917F  uni917F,  CJK UNIFIED IDEOGRAPH-917F
        0x9E1F, # G+2900  U+9E1F  uni9E1F,  CJK UNIFIED IDEOGRAPH-9E1F
        0x5C3F, # G+2901  U+5C3F  uni5C3F,  CJK UNIFIED IDEOGRAPH-5C3F
        0x634F, # G+2902  U+634F  uni634F,  CJK UNIFIED IDEOGRAPH-634F
        0x8042, # G+2903  U+8042  uni8042,  CJK UNIFIED IDEOGRAPH-8042
        0x5B7D, # G+2904  U+5B7D  uni5B7D,  CJK UNIFIED IDEOGRAPH-5B7D
        0x556E, # G+2905  U+556E  uni556E,  CJK UNIFIED IDEOGRAPH-556E
        0x954A, # G+2906  U+954A  uni954A,  CJK UNIFIED IDEOGRAPH-954A
        0x954D, # G+2907  U+954D  uni954D,  CJK UNIFIED IDEOGRAPH-954D
        0x6D85, # G+2908  U+6D85  uni6D85,  CJK UNIFIED IDEOGRAPH-6D85
        0x60A8, # G+2909  U+60A8  uni60A8,  CJK UNIFIED IDEOGRAPH-60A8
        0x67E0, # G+2910  U+67E0  uni67E0,  CJK UNIFIED IDEOGRAPH-67E0
        0x72DE, # G+2911  U+72DE  uni72DE,  CJK UNIFIED IDEOGRAPH-72DE
        0x51DD, # G+2912  U+51DD  uni51DD,  CJK UNIFIED IDEOGRAPH-51DD
        0x5B81, # G+2913  U+5B81  uni5B81,  CJK UNIFIED IDEOGRAPH-5B81
        0x62E7, # G+2914  U+62E7  uni62E7,  CJK UNIFIED IDEOGRAPH-62E7
        0x6CDE, # G+2915  U+6CDE  uni6CDE,  CJK UNIFIED IDEOGRAPH-6CDE
        0x2F5C, # G+2916  U+2F5C  uni2F5C,  KANGXI RADICAL COW
        0x626D, # G+2917  U+626D  uni626D,  CJK UNIFIED IDEOGRAPH-626D
        0x94AE, # G+2918  U+94AE  uni94AE,  CJK UNIFIED IDEOGRAPH-94AE
        0x7EBD, # G+2919  U+7EBD  uni7EBD,  CJK UNIFIED IDEOGRAPH-7EBD
        0x8113, # G+2920  U+8113  uni8113,  CJK UNIFIED IDEOGRAPH-8113
        0x6D53, # G+2921  U+6D53  uni6D53,  CJK UNIFIED IDEOGRAPH-6D53
        0x519C, # G+2922  U+519C  uni519C,  CJK UNIFIED IDEOGRAPH-519C
        0x5F04, # G+2923  U+5F04  uni5F04,  CJK UNIFIED IDEOGRAPH-5F04
        0x5974, # G+2924  U+5974  uni5974,  CJK UNIFIED IDEOGRAPH-5974
        0x52AA, # G+2925  U+52AA  uni52AA,  CJK UNIFIED IDEOGRAPH-52AA
        0x6012, # G+2926  U+6012  uni6012,  CJK UNIFIED IDEOGRAPH-6012
        0x2F25, # G+2927  U+2F25  uni2F25,  KANGXI RADICAL WOMAN
        0x6696, # G+2928  U+6696  uni6696,  CJK UNIFIED IDEOGRAPH-6696
        0x8650, # G+2929  U+8650  uni8650,  CJK UNIFIED IDEOGRAPH-8650
        0x759F, # G+2930  U+759F  uni759F,  CJK UNIFIED IDEOGRAPH-759F
        0x632A, # G+2931  U+632A  uni632A,  CJK UNIFIED IDEOGRAPH-632A
        0x61E6, # G+2932  U+61E6  uni61E6,  CJK UNIFIED IDEOGRAPH-61E6
        0x7CEF, # G+2933  U+7CEF  uni7CEF,  CJK UNIFIED IDEOGRAPH-7CEF
        0x8BFA, # G+2934  U+8BFA  uni8BFA,  CJK UNIFIED IDEOGRAPH-8BFA
        0x54E6, # G+2935  U+54E6  uni54E6,  CJK UNIFIED IDEOGRAPH-54E6
        0x6B27, # G+2936  U+6B27  uni6B27,  CJK UNIFIED IDEOGRAPH-6B27
        0x9E25, # G+2937  U+9E25  uni9E25,  CJK UNIFIED IDEOGRAPH-9E25
        0x6BB4, # G+2938  U+6BB4  uni6BB4,  CJK UNIFIED IDEOGRAPH-6BB4
        0x85D5, # G+2939  U+85D5  uni85D5,  CJK UNIFIED IDEOGRAPH-85D5
        0x5455, # G+2940  U+5455  uni5455,  CJK UNIFIED IDEOGRAPH-5455
        0x5076, # G+2941  U+5076  uni5076,  CJK UNIFIED IDEOGRAPH-5076
        0x6CA4, # G+2942  U+6CA4  uni6CA4,  CJK UNIFIED IDEOGRAPH-6CA4
        0x556A, # G+2943  U+556A  uni556A,  CJK UNIFIED IDEOGRAPH-556A
        0x8DB4, # G+2944  U+8DB4  uni8DB4,  CJK UNIFIED IDEOGRAPH-8DB4
        0x722C, # G+2945  U+722C  uni722C,  CJK UNIFIED IDEOGRAPH-722C
        0x5E15, # G+2946  U+5E15  uni5E15,  CJK UNIFIED IDEOGRAPH-5E15
        0x6015, # G+2947  U+6015  uni6015,  CJK UNIFIED IDEOGRAPH-6015
        0x7436, # G+2948  U+7436  uni7436,  CJK UNIFIED IDEOGRAPH-7436
        0x62CD, # G+2949  U+62CD  uni62CD,  CJK UNIFIED IDEOGRAPH-62CD
        0x6392, # G+2950  U+6392  uni6392,  CJK UNIFIED IDEOGRAPH-6392
        0x724C, # G+2951  U+724C  uni724C,  CJK UNIFIED IDEOGRAPH-724C
        0x5F98, # G+2952  U+5F98  uni5F98,  CJK UNIFIED IDEOGRAPH-5F98
        0x6E43, # G+2953  U+6E43  uni6E43,  CJK UNIFIED IDEOGRAPH-6E43
        0x6D3E, # G+2954  U+6D3E  uni6D3E,  CJK UNIFIED IDEOGRAPH-6D3E
        0x6500, # G+2955  U+6500  uni6500,  CJK UNIFIED IDEOGRAPH-6500
        0x6F58, # G+2956  U+6F58  uni6F58,  CJK UNIFIED IDEOGRAPH-6F58
        0x76D8, # G+2957  U+76D8  uni76D8,  CJK UNIFIED IDEOGRAPH-76D8
        0x78D0, # G+2958  U+78D0  uni78D0,  CJK UNIFIED IDEOGRAPH-78D0
        0x76FC, # G+2959  U+76FC  uni76FC,  CJK UNIFIED IDEOGRAPH-76FC
        0x7554, # G+2960  U+7554  uni7554,  CJK UNIFIED IDEOGRAPH-7554
        0x5224, # G+2961  U+5224  uni5224,  CJK UNIFIED IDEOGRAPH-5224
        0x53DB, # G+2962  U+53DB  uni53DB,  CJK UNIFIED IDEOGRAPH-53DB
        0x4E53, # G+2963  U+4E53  uni4E53,  CJK UNIFIED IDEOGRAPH-4E53
        0x5E9E, # G+2964  U+5E9E  uni5E9E,  CJK UNIFIED IDEOGRAPH-5E9E
        0x65C1, # G+2965  U+65C1  uni65C1,  CJK UNIFIED IDEOGRAPH-65C1
        0x802A, # G+2966  U+802A  uni802A,  CJK UNIFIED IDEOGRAPH-802A
        0x80D6, # G+2967  U+80D6  uni80D6,  CJK UNIFIED IDEOGRAPH-80D6
        0x629B, # G+2968  U+629B  uni629B,  CJK UNIFIED IDEOGRAPH-629B
        0x5486, # G+2969  U+5486  uni5486,  CJK UNIFIED IDEOGRAPH-5486
        0x5228, # G+2970  U+5228  uni5228,  CJK UNIFIED IDEOGRAPH-5228
        0x70AE, # G+2971  U+70AE  uni70AE,  CJK UNIFIED IDEOGRAPH-70AE
        0x888D, # G+2972  U+888D  uni888D,  CJK UNIFIED IDEOGRAPH-888D
        0x8DD1, # G+2973  U+8DD1  uni8DD1,  CJK UNIFIED IDEOGRAPH-8DD1
        0x6CE1, # G+2974  U+6CE1  uni6CE1,  CJK UNIFIED IDEOGRAPH-6CE1
        0x5478, # G+2975  U+5478  uni5478,  CJK UNIFIED IDEOGRAPH-5478
        0x80DA, # G+2976  U+80DA  uni80DA,  CJK UNIFIED IDEOGRAPH-80DA
        0x57F9, # G+2977  U+57F9  uni57F9,  CJK UNIFIED IDEOGRAPH-57F9
        0x88F4, # G+2978  U+88F4  uni88F4,  CJK UNIFIED IDEOGRAPH-88F4
        0x8D54, # G+2979  U+8D54  uni8D54,  CJK UNIFIED IDEOGRAPH-8D54
        0x966A, # G+2980  U+966A  uni966A,  CJK UNIFIED IDEOGRAPH-966A
        0x914D, # G+2981  U+914D  uni914D,  CJK UNIFIED IDEOGRAPH-914D
        0x4F69, # G+2982  U+4F69  uni4F69,  CJK UNIFIED IDEOGRAPH-4F69
        0x6C9B, # G+2983  U+6C9B  uni6C9B,  CJK UNIFIED IDEOGRAPH-6C9B
        0x55B7, # G+2984  U+55B7  uni55B7,  CJK UNIFIED IDEOGRAPH-55B7
        0x76C6, # G+2985  U+76C6  uni76C6,  CJK UNIFIED IDEOGRAPH-76C6
        0x7830, # G+2986  U+7830  uni7830,  CJK UNIFIED IDEOGRAPH-7830
        0x62A8, # G+2987  U+62A8  uni62A8,  CJK UNIFIED IDEOGRAPH-62A8
        0x70F9, # G+2988  U+70F9  uni70F9,  CJK UNIFIED IDEOGRAPH-70F9
        0x6F8E, # G+2989  U+6F8E  uni6F8E,  CJK UNIFIED IDEOGRAPH-6F8E
        0x5F6D, # G+2990  U+5F6D  uni5F6D,  CJK UNIFIED IDEOGRAPH-5F6D
        0x84EC, # G+2991  U+84EC  uni84EC,  CJK UNIFIED IDEOGRAPH-84EC
        0x68DA, # G+2992  U+68DA  uni68DA,  CJK UNIFIED IDEOGRAPH-68DA
        0x787C, # G+2993  U+787C  uni787C,  CJK UNIFIED IDEOGRAPH-787C
        0x7BF7, # G+2994  U+7BF7  uni7BF7,  CJK UNIFIED IDEOGRAPH-7BF7
        0x81A8, # G+2995  U+81A8  uni81A8,  CJK UNIFIED IDEOGRAPH-81A8
        0x670B, # G+2996  U+670B  uni670B,  CJK UNIFIED IDEOGRAPH-670B
        0x9E4F, # G+2997  U+9E4F  uni9E4F,  CJK UNIFIED IDEOGRAPH-9E4F
        0x6367, # G+2998  U+6367  uni6367,  CJK UNIFIED IDEOGRAPH-6367
        0x78B0, # G+2999  U+78B0  uni78B0,  CJK UNIFIED IDEOGRAPH-78B0
        0x576F, # G+3000  U+576F  uni576F,  CJK UNIFIED IDEOGRAPH-576F
        0x7812, # G+3001  U+7812  uni7812,  CJK UNIFIED IDEOGRAPH-7812
        0x9739, # G+3002  U+9739  uni9739,  CJK UNIFIED IDEOGRAPH-9739
        0x6279, # G+3003  U+6279  uni6279,  CJK UNIFIED IDEOGRAPH-6279
        0x62AB, # G+3004  U+62AB  uni62AB,  CJK UNIFIED IDEOGRAPH-62AB
        0x5288, # G+3005  U+5288  uni5288,  CJK UNIFIED IDEOGRAPH-5288
        0x7435, # G+3006  U+7435  uni7435,  CJK UNIFIED IDEOGRAPH-7435
        0x6BD7, # G+3007  U+6BD7  uni6BD7,  CJK UNIFIED IDEOGRAPH-6BD7
        0x5564, # G+3008  U+5564  uni5564,  CJK UNIFIED IDEOGRAPH-5564
        0x813E, # G+3009  U+813E  uni813E,  CJK UNIFIED IDEOGRAPH-813E
        0x75B2, # G+3010  U+75B2  uni75B2,  CJK UNIFIED IDEOGRAPH-75B2
        0x2F6A, # G+3011  U+2F6A  uni2F6A,  KANGXI RADICAL SKIN
        0x5339, # G+3012  U+5339  uni5339,  CJK UNIFIED IDEOGRAPH-5339
        0x75DE, # G+3013  U+75DE  uni75DE,  CJK UNIFIED IDEOGRAPH-75DE
        0x50FB, # G+3014  U+50FB  uni50FB,  CJK UNIFIED IDEOGRAPH-50FB
        0x5C41, # G+3015  U+5C41  uni5C41,  CJK UNIFIED IDEOGRAPH-5C41
        0x8B6C, # G+3016  U+8B6C  uni8B6C,  CJK UNIFIED IDEOGRAPH-8B6C
        0x7BC7, # G+3017  U+7BC7  uni7BC7,  CJK UNIFIED IDEOGRAPH-7BC7
        0x504F, # G+3018  U+504F  uni504F,  CJK UNIFIED IDEOGRAPH-504F
        0x2F5A, # G+3019  U+2F5A  uni2F5A,  KANGXI RADICAL SLICE
        0x9A97, # G+3020  U+9A97  uni9A97,  CJK UNIFIED IDEOGRAPH-9A97
        0x98D8, # G+3021  U+98D8  uni98D8,  CJK UNIFIED IDEOGRAPH-98D8
        0x6F02, # G+3022  U+6F02  uni6F02,  CJK UNIFIED IDEOGRAPH-6F02
        0x74E2, # G+3023  U+74E2  uni74E2,  CJK UNIFIED IDEOGRAPH-74E2
        0x7968, # G+3024  U+7968  uni7968,  CJK UNIFIED IDEOGRAPH-7968
        0x6487, # G+3025  U+6487  uni6487,  CJK UNIFIED IDEOGRAPH-6487
        0x77A5, # G+3026  U+77A5  uni77A5,  CJK UNIFIED IDEOGRAPH-77A5
        0x62FC, # G+3027  U+62FC  uni62FC,  CJK UNIFIED IDEOGRAPH-62FC
        0x9891, # G+3028  U+9891  uni9891,  CJK UNIFIED IDEOGRAPH-9891
        0x8D2B, # G+3029  U+8D2B  uni8D2B,  CJK UNIFIED IDEOGRAPH-8D2B
        0x54C1, # G+3030  U+54C1  uni54C1,  CJK UNIFIED IDEOGRAPH-54C1
        0x8058, # G+3031  U+8058  uni8058,  CJK UNIFIED IDEOGRAPH-8058
        0x4E52, # G+3032  U+4E52  uni4E52,  CJK UNIFIED IDEOGRAPH-4E52
        0x576A, # G+3033  U+576A  uni576A,  CJK UNIFIED IDEOGRAPH-576A
        0x82F9, # G+3034  U+82F9  uni82F9,  CJK UNIFIED IDEOGRAPH-82F9
        0x840D, # G+3035  U+840D  uni840D,  CJK UNIFIED IDEOGRAPH-840D
        0x5E73, # G+3036  U+5E73  uni5E73,  CJK UNIFIED IDEOGRAPH-5E73
        0x51ED, # G+3037  U+51ED  uni51ED,  CJK UNIFIED IDEOGRAPH-51ED
        0x74F6, # G+3038  U+74F6  uni74F6,  CJK UNIFIED IDEOGRAPH-74F6
        0x8BC4, # G+3039  U+8BC4  uni8BC4,  CJK UNIFIED IDEOGRAPH-8BC4
        0x5C4F, # G+3040  U+5C4F  uni5C4F,  CJK UNIFIED IDEOGRAPH-5C4F
        0x5761, # G+3041  U+5761  uni5761,  CJK UNIFIED IDEOGRAPH-5761
        0x6CFC, # G+3042  U+6CFC  uni6CFC,  CJK UNIFIED IDEOGRAPH-6CFC
        0x9887, # G+3043  U+9887  uni9887,  CJK UNIFIED IDEOGRAPH-9887
        0x5A46, # G+3044  U+5A46  uni5A46,  CJK UNIFIED IDEOGRAPH-5A46
        0x7834, # G+3045  U+7834  uni7834,  CJK UNIFIED IDEOGRAPH-7834
        0x9B44, # G+3046  U+9B44  uni9B44,  CJK UNIFIED IDEOGRAPH-9B44
        0x8FEB, # G+3047  U+8FEB  uni8FEB,  CJK UNIFIED IDEOGRAPH-8FEB
        0x7C95, # G+3048  U+7C95  uni7C95,  CJK UNIFIED IDEOGRAPH-7C95
        0x5256, # G+3049  U+5256  uni5256,  CJK UNIFIED IDEOGRAPH-5256
        0x6251, # G+3050  U+6251  uni6251,  CJK UNIFIED IDEOGRAPH-6251
        0x94FA, # G+3051  U+94FA  uni94FA,  CJK UNIFIED IDEOGRAPH-94FA
        0x4EC6, # G+3052  U+4EC6  uni4EC6,  CJK UNIFIED IDEOGRAPH-4EC6
        0x8386, # G+3053  U+8386  uni8386,  CJK UNIFIED IDEOGRAPH-8386
        0x8461, # G+3054  U+8461  uni8461,  CJK UNIFIED IDEOGRAPH-8461
        0x83E9, # G+3055  U+83E9  uni83E9,  CJK UNIFIED IDEOGRAPH-83E9
        0x84B2, # G+3056  U+84B2  uni84B2,  CJK UNIFIED IDEOGRAPH-84B2
        0x57D4, # G+3057  U+57D4  uni57D4,  CJK UNIFIED IDEOGRAPH-57D4
        0x6734, # G+3058  U+6734  uni6734,  CJK UNIFIED IDEOGRAPH-6734
        0x5703, # G+3059  U+5703  uni5703,  CJK UNIFIED IDEOGRAPH-5703
        0x666E, # G+3060  U+666E  uni666E,  CJK UNIFIED IDEOGRAPH-666E
        0x6D66, # G+3061  U+6D66  uni6D66,  CJK UNIFIED IDEOGRAPH-6D66
        0x8C31, # G+3062  U+8C31  uni8C31,  CJK UNIFIED IDEOGRAPH-8C31
        0x66DD, # G+3063  U+66DD  uni66DD,  CJK UNIFIED IDEOGRAPH-66DD
        0x7011, # G+3064  U+7011  uni7011,  CJK UNIFIED IDEOGRAPH-7011
        0x671F, # G+3065  U+671F  uni671F,  CJK UNIFIED IDEOGRAPH-671F
        0x6B3A, # G+3066  U+6B3A  uni6B3A,  CJK UNIFIED IDEOGRAPH-6B3A
        0x6816, # G+3067  U+6816  uni6816,  CJK UNIFIED IDEOGRAPH-6816
        0x621A, # G+3068  U+621A  uni621A,  CJK UNIFIED IDEOGRAPH-621A
        0x59BB, # G+3069  U+59BB  uni59BB,  CJK UNIFIED IDEOGRAPH-59BB
        0x4E03, # G+3070  U+4E03  uni4E03,  CJK UNIFIED IDEOGRAPH-4E03
        0x51C4, # G+3071  U+51C4  uni51C4,  CJK UNIFIED IDEOGRAPH-51C4
        0x6F06, # G+3072  U+6F06  uni6F06,  CJK UNIFIED IDEOGRAPH-6F06
        0x67D2, # G+3073  U+67D2  uni67D2,  CJK UNIFIED IDEOGRAPH-67D2
        0x6C8F, # G+3074  U+6C8F  uni6C8F,  CJK UNIFIED IDEOGRAPH-6C8F
        0x5176, # G+3075  U+5176  uni5176,  CJK UNIFIED IDEOGRAPH-5176
        0x68CB, # G+3076  U+68CB  uni68CB,  CJK UNIFIED IDEOGRAPH-68CB
        0x5947, # G+3077  U+5947  uni5947,  CJK UNIFIED IDEOGRAPH-5947
        0x6B67, # G+3078  U+6B67  uni6B67,  CJK UNIFIED IDEOGRAPH-6B67
        0x7566, # G+3079  U+7566  uni7566,  CJK UNIFIED IDEOGRAPH-7566
        0x5D0E, # G+3080  U+5D0E  uni5D0E,  CJK UNIFIED IDEOGRAPH-5D0E
        0x8110, # G+3081  U+8110  uni8110,  CJK UNIFIED IDEOGRAPH-8110
        0x9F50, # G+3082  U+9F50  uni9F50,  CJK UNIFIED IDEOGRAPH-9F50
        0x65D7, # G+3083  U+65D7  uni65D7,  CJK UNIFIED IDEOGRAPH-65D7
        0x7948, # G+3084  U+7948  uni7948,  CJK UNIFIED IDEOGRAPH-7948
        0x7941, # G+3085  U+7941  uni7941,  CJK UNIFIED IDEOGRAPH-7941
        0x9A91, # G+3086  U+9A91  uni9A91,  CJK UNIFIED IDEOGRAPH-9A91
        0x8D77, # G+3087  U+8D77  uni8D77,  CJK UNIFIED IDEOGRAPH-8D77
        0x5C82, # G+3088  U+5C82  uni5C82,  CJK UNIFIED IDEOGRAPH-5C82
        0x4E5E, # G+3089  U+4E5E  uni4E5E,  CJK UNIFIED IDEOGRAPH-4E5E
        0x4F01, # G+3090  U+4F01  uni4F01,  CJK UNIFIED IDEOGRAPH-4F01
        0x542F, # G+3091  U+542F  uni542F,  CJK UNIFIED IDEOGRAPH-542F
        0x5951, # G+3092  U+5951  uni5951,  CJK UNIFIED IDEOGRAPH-5951
        0x780C, # G+3093  U+780C  uni780C,  CJK UNIFIED IDEOGRAPH-780C
        0x5668, # G+3094  U+5668  uni5668,  CJK UNIFIED IDEOGRAPH-5668
        0x2F53, # G+3095  U+2F53  uni2F53,  KANGXI RADICAL STEAM
        0x8FC4, # G+3096  U+8FC4  uni8FC4,  CJK UNIFIED IDEOGRAPH-8FC4
        0x5F03, # G+3097  U+5F03  uni5F03,  CJK UNIFIED IDEOGRAPH-5F03
        0x6C7D, # G+3098  U+6C7D  uni6C7D,  CJK UNIFIED IDEOGRAPH-6C7D
        0x6CE3, # G+3099  U+6CE3  uni6CE3,  CJK UNIFIED IDEOGRAPH-6CE3
        0x8BAB, # G+3100  U+8BAB  uni8BAB,  CJK UNIFIED IDEOGRAPH-8BAB
        0x6390, # G+3101  U+6390  uni6390,  CJK UNIFIED IDEOGRAPH-6390
        0x6070, # G+3102  U+6070  uni6070,  CJK UNIFIED IDEOGRAPH-6070
        0x6D3D, # G+3103  U+6D3D  uni6D3D,  CJK UNIFIED IDEOGRAPH-6D3D
        0x7275, # G+3104  U+7275  uni7275,  CJK UNIFIED IDEOGRAPH-7275
        0x6266, # G+3105  U+6266  uni6266,  CJK UNIFIED IDEOGRAPH-6266
        0x948E, # G+3106  U+948E  uni948E,  CJK UNIFIED IDEOGRAPH-948E
        0x94C5, # G+3107  U+94C5  uni94C5,  CJK UNIFIED IDEOGRAPH-94C5
        0x5343, # G+3108  U+5343  uni5343,  CJK UNIFIED IDEOGRAPH-5343
        0x8FC1, # G+3109  U+8FC1  uni8FC1,  CJK UNIFIED IDEOGRAPH-8FC1
        0x7B7E, # G+3110  U+7B7E  uni7B7E,  CJK UNIFIED IDEOGRAPH-7B7E
        0x4EDF, # G+3111  U+4EDF  uni4EDF,  CJK UNIFIED IDEOGRAPH-4EDF
        0x8C26, # G+3112  U+8C26  uni8C26,  CJK UNIFIED IDEOGRAPH-8C26
        0x4E7E, # G+3113  U+4E7E  uni4E7E,  CJK UNIFIED IDEOGRAPH-4E7E
        0x9ED4, # G+3114  U+9ED4  uni9ED4,  CJK UNIFIED IDEOGRAPH-9ED4
        0x94B1, # G+3115  U+94B1  uni94B1,  CJK UNIFIED IDEOGRAPH-94B1
        0x94B3, # G+3116  U+94B3  uni94B3,  CJK UNIFIED IDEOGRAPH-94B3
        0x524D, # G+3117  U+524D  uni524D,  CJK UNIFIED IDEOGRAPH-524D
        0x6F5C, # G+3118  U+6F5C  uni6F5C,  CJK UNIFIED IDEOGRAPH-6F5C
        0x9063, # G+3119  U+9063  uni9063,  CJK UNIFIED IDEOGRAPH-9063
        0x6D45, # G+3120  U+6D45  uni6D45,  CJK UNIFIED IDEOGRAPH-6D45
        0x8C34, # G+3121  U+8C34  uni8C34,  CJK UNIFIED IDEOGRAPH-8C34
        0x5811, # G+3122  U+5811  uni5811,  CJK UNIFIED IDEOGRAPH-5811
        0x5D4C, # G+3123  U+5D4C  uni5D4C,  CJK UNIFIED IDEOGRAPH-5D4C
        0x2F4B, # G+3124  U+2F4B  uni2F4B,  KANGXI RADICAL LACK
        0x6B49, # G+3125  U+6B49  uni6B49,  CJK UNIFIED IDEOGRAPH-6B49
        0x67AA, # G+3126  U+67AA  uni67AA,  CJK UNIFIED IDEOGRAPH-67AA
        0x545B, # G+3127  U+545B  uni545B,  CJK UNIFIED IDEOGRAPH-545B
        0x8154, # G+3128  U+8154  uni8154,  CJK UNIFIED IDEOGRAPH-8154
        0x7F8C, # G+3129  U+7F8C  uni7F8C,  CJK UNIFIED IDEOGRAPH-7F8C
        0x5899, # G+3130  U+5899  uni5899,  CJK UNIFIED IDEOGRAPH-5899
        0x8537, # G+3131  U+8537  uni8537,  CJK UNIFIED IDEOGRAPH-8537
        0x5F3A, # G+3132  U+5F3A  uni5F3A,  CJK UNIFIED IDEOGRAPH-5F3A
        0x62A2, # G+3133  U+62A2  uni62A2,  CJK UNIFIED IDEOGRAPH-62A2
        0x6A47, # G+3134  U+6A47  uni6A47,  CJK UNIFIED IDEOGRAPH-6A47
        0x9539, # G+3135  U+9539  uni9539,  CJK UNIFIED IDEOGRAPH-9539
        0x6572, # G+3136  U+6572  uni6572,  CJK UNIFIED IDEOGRAPH-6572
        0x6084, # G+3137  U+6084  uni6084,  CJK UNIFIED IDEOGRAPH-6084
        0x6865, # G+3138  U+6865  uni6865,  CJK UNIFIED IDEOGRAPH-6865
        0x77A7, # G+3139  U+77A7  uni77A7,  CJK UNIFIED IDEOGRAPH-77A7
        0x4E54, # G+3140  U+4E54  uni4E54,  CJK UNIFIED IDEOGRAPH-4E54
        0x4FA8, # G+3141  U+4FA8  uni4FA8,  CJK UNIFIED IDEOGRAPH-4FA8
        0x5DE7, # G+3142  U+5DE7  uni5DE7,  CJK UNIFIED IDEOGRAPH-5DE7
        0x9798, # G+3143  U+9798  uni9798,  CJK UNIFIED IDEOGRAPH-9798
        0x64AC, # G+3144  U+64AC  uni64AC,  CJK UNIFIED IDEOGRAPH-64AC
        0x7FD8, # G+3145  U+7FD8  uni7FD8,  CJK UNIFIED IDEOGRAPH-7FD8
        0x5CED, # G+3146  U+5CED  uni5CED,  CJK UNIFIED IDEOGRAPH-5CED
        0x4FCF, # G+3147  U+4FCF  uni4FCF,  CJK UNIFIED IDEOGRAPH-4FCF
        0x7A8D, # G+3148  U+7A8D  uni7A8D,  CJK UNIFIED IDEOGRAPH-7A8D
        0x5207, # G+3149  U+5207  uni5207,  CJK UNIFIED IDEOGRAPH-5207
        0x8304, # G+3150  U+8304  uni8304,  CJK UNIFIED IDEOGRAPH-8304
        0x4E14, # G+3151  U+4E14  uni4E14,  CJK UNIFIED IDEOGRAPH-4E14
        0x602F, # G+3152  U+602F  uni602F,  CJK UNIFIED IDEOGRAPH-602F
        0x7A83, # G+3153  U+7A83  uni7A83,  CJK UNIFIED IDEOGRAPH-7A83
        0x94A6, # G+3154  U+94A6  uni94A6,  CJK UNIFIED IDEOGRAPH-94A6
        0x4FB5, # G+3155  U+4FB5  uni4FB5,  CJK UNIFIED IDEOGRAPH-4FB5
        0x4EB2, # G+3156  U+4EB2  uni4EB2,  CJK UNIFIED IDEOGRAPH-4EB2
        0x79E6, # G+3157  U+79E6  uni79E6,  CJK UNIFIED IDEOGRAPH-79E6
        0x7434, # G+3158  U+7434  uni7434,  CJK UNIFIED IDEOGRAPH-7434
        0x52E4, # G+3159  U+52E4  uni52E4,  CJK UNIFIED IDEOGRAPH-52E4
        0x82B9, # G+3160  U+82B9  uni82B9,  CJK UNIFIED IDEOGRAPH-82B9
        0x64D2, # G+3161  U+64D2  uni64D2,  CJK UNIFIED IDEOGRAPH-64D2
        0x79BD, # G+3162  U+79BD  uni79BD,  CJK UNIFIED IDEOGRAPH-79BD
        0x5BDD, # G+3163  U+5BDD  uni5BDD,  CJK UNIFIED IDEOGRAPH-5BDD
        0x6C81, # G+3164  U+6C81  uni6C81,  CJK UNIFIED IDEOGRAPH-6C81
        0x9752, # G+3165  U+9752  uni9752,  CJK UNIFIED IDEOGRAPH-9752
        0x8F7B, # G+3166  U+8F7B  uni8F7B,  CJK UNIFIED IDEOGRAPH-8F7B
        0x6C22, # G+3167  U+6C22  uni6C22,  CJK UNIFIED IDEOGRAPH-6C22
        0x503E, # G+3168  U+503E  uni503E,  CJK UNIFIED IDEOGRAPH-503E
        0x537F, # G+3169  U+537F  uni537F,  CJK UNIFIED IDEOGRAPH-537F
        0x6E05, # G+3170  U+6E05  uni6E05,  CJK UNIFIED IDEOGRAPH-6E05
        0x64CE, # G+3171  U+64CE  uni64CE,  CJK UNIFIED IDEOGRAPH-64CE
        0x6674, # G+3172  U+6674  uni6674,  CJK UNIFIED IDEOGRAPH-6674
        0x6C30, # G+3173  U+6C30  uni6C30,  CJK UNIFIED IDEOGRAPH-6C30
        0x60C5, # G+3174  U+60C5  uni60C5,  CJK UNIFIED IDEOGRAPH-60C5
        0x9877, # G+3175  U+9877  uni9877,  CJK UNIFIED IDEOGRAPH-9877
        0x8BF7, # G+3176  U+8BF7  uni8BF7,  CJK UNIFIED IDEOGRAPH-8BF7
        0x5E86, # G+3177  U+5E86  uni5E86,  CJK UNIFIED IDEOGRAPH-5E86
        0x743C, # G+3178  U+743C  uni743C,  CJK UNIFIED IDEOGRAPH-743C
        0x7A77, # G+3179  U+7A77  uni7A77,  CJK UNIFIED IDEOGRAPH-7A77
        0x79CB, # G+3180  U+79CB  uni79CB,  CJK UNIFIED IDEOGRAPH-79CB
        0x4E18, # G+3181  U+4E18  uni4E18,  CJK UNIFIED IDEOGRAPH-4E18
        0x90B1, # G+3182  U+90B1  uni90B1,  CJK UNIFIED IDEOGRAPH-90B1
        0x7403, # G+3183  U+7403  uni7403,  CJK UNIFIED IDEOGRAPH-7403
        0x6C42, # G+3184  U+6C42  uni6C42,  CJK UNIFIED IDEOGRAPH-6C42
        0x56DA, # G+3185  U+56DA  uni56DA,  CJK UNIFIED IDEOGRAPH-56DA
        0x914B, # G+3186  U+914B  uni914B,  CJK UNIFIED IDEOGRAPH-914B
        0x6CC5, # G+3187  U+6CC5  uni6CC5,  CJK UNIFIED IDEOGRAPH-6CC5
        0x8D8B, # G+3188  U+8D8B  uni8D8B,  CJK UNIFIED IDEOGRAPH-8D8B
        0x533A, # G+3189  U+533A  uni533A,  CJK UNIFIED IDEOGRAPH-533A
        0x86C6, # G+3190  U+86C6  uni86C6,  CJK UNIFIED IDEOGRAPH-86C6
        0x66F2, # G+3191  U+66F2  uni66F2,  CJK UNIFIED IDEOGRAPH-66F2
        0x8EAF, # G+3192  U+8EAF  uni8EAF,  CJK UNIFIED IDEOGRAPH-8EAF
        0x5C48, # G+3193  U+5C48  uni5C48,  CJK UNIFIED IDEOGRAPH-5C48
        0x9A71, # G+3194  U+9A71  uni9A71,  CJK UNIFIED IDEOGRAPH-9A71
        0x6E20, # G+3195  U+6E20  uni6E20,  CJK UNIFIED IDEOGRAPH-6E20
        0x53D6, # G+3196  U+53D6  uni53D6,  CJK UNIFIED IDEOGRAPH-53D6
        0x5A36, # G+3197  U+5A36  uni5A36,  CJK UNIFIED IDEOGRAPH-5A36
        0x9F8B, # G+3198  U+9F8B  uni9F8B,  CJK UNIFIED IDEOGRAPH-9F8B
        0x8DA3, # G+3199  U+8DA3  uni8DA3,  CJK UNIFIED IDEOGRAPH-8DA3
        0x53BB, # G+3200  U+53BB  uni53BB,  CJK UNIFIED IDEOGRAPH-53BB
        0x5708, # G+3201  U+5708  uni5708,  CJK UNIFIED IDEOGRAPH-5708
        0x98A7, # G+3202  U+98A7  uni98A7,  CJK UNIFIED IDEOGRAPH-98A7
        0x6743, # G+3203  U+6743  uni6743,  CJK UNIFIED IDEOGRAPH-6743
        0x919B, # G+3204  U+919B  uni919B,  CJK UNIFIED IDEOGRAPH-919B
        0x6CC9, # G+3205  U+6CC9  uni6CC9,  CJK UNIFIED IDEOGRAPH-6CC9
        0x5168, # G+3206  U+5168  uni5168,  CJK UNIFIED IDEOGRAPH-5168
        0x75CA, # G+3207  U+75CA  uni75CA,  CJK UNIFIED IDEOGRAPH-75CA
        0x62F3, # G+3208  U+62F3  uni62F3,  CJK UNIFIED IDEOGRAPH-62F3
        0x2F5D, # G+3209  U+2F5D  uni2F5D,  KANGXI RADICAL DOG
        0x5238, # G+3210  U+5238  uni5238,  CJK UNIFIED IDEOGRAPH-5238
        0x529D, # G+3211  U+529D  uni529D,  CJK UNIFIED IDEOGRAPH-529D
        0x7F3A, # G+3212  U+7F3A  uni7F3A,  CJK UNIFIED IDEOGRAPH-7F3A
        0x7094, # G+3213  U+7094  uni7094,  CJK UNIFIED IDEOGRAPH-7094
        0x7638, # G+3214  U+7638  uni7638,  CJK UNIFIED IDEOGRAPH-7638
        0x5374, # G+3215  U+5374  uni5374,  CJK UNIFIED IDEOGRAPH-5374
        0x9E4A, # G+3216  U+9E4A  uni9E4A,  CJK UNIFIED IDEOGRAPH-9E4A
        0x69B7, # G+3217  U+69B7  uni69B7,  CJK UNIFIED IDEOGRAPH-69B7
        0x786E, # G+3218  U+786E  uni786E,  CJK UNIFIED IDEOGRAPH-786E
        0x96C0, # G+3219  U+96C0  uni96C0,  CJK UNIFIED IDEOGRAPH-96C0
        0x88D9, # G+3220  U+88D9  uni88D9,  CJK UNIFIED IDEOGRAPH-88D9
        0x7FA4, # G+3221  U+7FA4  uni7FA4,  CJK UNIFIED IDEOGRAPH-7FA4
        0x7136, # G+3222  U+7136  uni7136,  CJK UNIFIED IDEOGRAPH-7136
        0x71C3, # G+3223  U+71C3  uni71C3,  CJK UNIFIED IDEOGRAPH-71C3
        0x5189, # G+3224  U+5189  uni5189,  CJK UNIFIED IDEOGRAPH-5189
        0x67D3, # G+3225  U+67D3  uni67D3,  CJK UNIFIED IDEOGRAPH-67D3
        0x74E4, # G+3226  U+74E4  uni74E4,  CJK UNIFIED IDEOGRAPH-74E4
        0x58E4, # G+3227  U+58E4  uni58E4,  CJK UNIFIED IDEOGRAPH-58E4
        0x6518, # G+3228  U+6518  uni6518,  CJK UNIFIED IDEOGRAPH-6518
        0x56B7, # G+3229  U+56B7  uni56B7,  CJK UNIFIED IDEOGRAPH-56B7
        0x8BA9, # G+3230  U+8BA9  uni8BA9,  CJK UNIFIED IDEOGRAPH-8BA9
        0x9976, # G+3231  U+9976  uni9976,  CJK UNIFIED IDEOGRAPH-9976
        0x6270, # G+3232  U+6270  uni6270,  CJK UNIFIED IDEOGRAPH-6270
        0x7ED5, # G+3233  U+7ED5  uni7ED5,  CJK UNIFIED IDEOGRAPH-7ED5
        0x60F9, # G+3234  U+60F9  uni60F9,  CJK UNIFIED IDEOGRAPH-60F9
        0x70ED, # G+3235  U+70ED  uni70ED,  CJK UNIFIED IDEOGRAPH-70ED
        0x58EC, # G+3236  U+58EC  uni58EC,  CJK UNIFIED IDEOGRAPH-58EC
        0x4EC1, # G+3237  U+4EC1  uni4EC1,  CJK UNIFIED IDEOGRAPH-4EC1
        0x2F08, # G+3238  U+2F08  uni2F08,  KANGXI RADICAL MAN
        0x5FCD, # G+3239  U+5FCD  uni5FCD,  CJK UNIFIED IDEOGRAPH-5FCD
        0x97E7, # G+3240  U+97E7  uni97E7,  CJK UNIFIED IDEOGRAPH-97E7
        0x4EFB, # G+3241  U+4EFB  uni4EFB,  CJK UNIFIED IDEOGRAPH-4EFB
        0x8BA4, # G+3242  U+8BA4  uni8BA4,  CJK UNIFIED IDEOGRAPH-8BA4
        0x5203, # G+3243  U+5203  uni5203,  CJK UNIFIED IDEOGRAPH-5203
        0x598A, # G+3244  U+598A  uni598A,  CJK UNIFIED IDEOGRAPH-598A
        0x7EAB, # G+3245  U+7EAB  uni7EAB,  CJK UNIFIED IDEOGRAPH-7EAB
        0x6254, # G+3246  U+6254  uni6254,  CJK UNIFIED IDEOGRAPH-6254
        0x4ECD, # G+3247  U+4ECD  uni4ECD,  CJK UNIFIED IDEOGRAPH-4ECD
        0x2F47, # G+3248  U+2F47  uni2F47,  KANGXI RADICAL SUN
        0x620E, # G+3249  U+620E  uni620E,  CJK UNIFIED IDEOGRAPH-620E
        0x8338, # G+3250  U+8338  uni8338,  CJK UNIFIED IDEOGRAPH-8338
        0x84C9, # G+3251  U+84C9  uni84C9,  CJK UNIFIED IDEOGRAPH-84C9
        0x8363, # G+3252  U+8363  uni8363,  CJK UNIFIED IDEOGRAPH-8363
        0x878D, # G+3253  U+878D  uni878D,  CJK UNIFIED IDEOGRAPH-878D
        0x7194, # G+3254  U+7194  uni7194,  CJK UNIFIED IDEOGRAPH-7194
        0x6EB6, # G+3255  U+6EB6  uni6EB6,  CJK UNIFIED IDEOGRAPH-6EB6
        0x5BB9, # G+3256  U+5BB9  uni5BB9,  CJK UNIFIED IDEOGRAPH-5BB9
        0x7ED2, # G+3257  U+7ED2  uni7ED2,  CJK UNIFIED IDEOGRAPH-7ED2
        0x5197, # G+3258  U+5197  uni5197,  CJK UNIFIED IDEOGRAPH-5197
        0x63C9, # G+3259  U+63C9  uni63C9,  CJK UNIFIED IDEOGRAPH-63C9
        0x67D4, # G+3260  U+67D4  uni67D4,  CJK UNIFIED IDEOGRAPH-67D4
        0x2F81, # G+3261  U+2F81  uni2F81,  KANGXI RADICAL MEAT
        0x8339, # G+3262  U+8339  uni8339,  CJK UNIFIED IDEOGRAPH-8339
        0x8815, # G+3263  U+8815  uni8815,  CJK UNIFIED IDEOGRAPH-8815
        0x5112, # G+3264  U+5112  uni5112,  CJK UNIFIED IDEOGRAPH-5112
        0x5B7A, # G+3265  U+5B7A  uni5B7A,  CJK UNIFIED IDEOGRAPH-5B7A
        0x5982, # G+3266  U+5982  uni5982,  CJK UNIFIED IDEOGRAPH-5982
        0x8FB1, # G+3267  U+8FB1  uni8FB1,  CJK UNIFIED IDEOGRAPH-8FB1
        0x4E73, # G+3268  U+4E73  uni4E73,  CJK UNIFIED IDEOGRAPH-4E73
        0x6C5D, # G+3269  U+6C5D  uni6C5D,  CJK UNIFIED IDEOGRAPH-6C5D
        0x2F0A, # G+3270  U+2F0A  uni2F0A,  KANGXI RADICAL ENTER
        0x8925, # G+3271  U+8925  uni8925,  CJK UNIFIED IDEOGRAPH-8925
        0x8F6F, # G+3272  U+8F6F  uni8F6F,  CJK UNIFIED IDEOGRAPH-8F6F
        0x962E, # G+3273  U+962E  uni962E,  CJK UNIFIED IDEOGRAPH-962E
        0x854A, # G+3274  U+854A  uni854A,  CJK UNIFIED IDEOGRAPH-854A
        0x745E, # G+3275  U+745E  uni745E,  CJK UNIFIED IDEOGRAPH-745E
        0x9510, # G+3276  U+9510  uni9510,  CJK UNIFIED IDEOGRAPH-9510
        0x95F0, # G+3277  U+95F0  uni95F0,  CJK UNIFIED IDEOGRAPH-95F0
        0x6DA6, # G+3278  U+6DA6  uni6DA6,  CJK UNIFIED IDEOGRAPH-6DA6
        0x82E5, # G+3279  U+82E5  uni82E5,  CJK UNIFIED IDEOGRAPH-82E5
        0x5F31, # G+3280  U+5F31  uni5F31,  CJK UNIFIED IDEOGRAPH-5F31
        0x6492, # G+3281  U+6492  uni6492,  CJK UNIFIED IDEOGRAPH-6492
        0x6D12, # G+3282  U+6D12  uni6D12,  CJK UNIFIED IDEOGRAPH-6D12
        0x8428, # G+3283  U+8428  uni8428,  CJK UNIFIED IDEOGRAPH-8428
        0x816E, # G+3284  U+816E  uni816E,  CJK UNIFIED IDEOGRAPH-816E
        0x9CC3, # G+3285  U+9CC3  uni9CC3,  CJK UNIFIED IDEOGRAPH-9CC3
        0x585E, # G+3286  U+585E  uni585E,  CJK UNIFIED IDEOGRAPH-585E
        0x8D5B, # G+3287  U+8D5B  uni8D5B,  CJK UNIFIED IDEOGRAPH-8D5B
        0x4E09, # G+3288  U+4E09  uni4E09,  CJK UNIFIED IDEOGRAPH-4E09
        0x53C1, # G+3289  U+53C1  uni53C1,  CJK UNIFIED IDEOGRAPH-53C1
        0x4F1E, # G+3290  U+4F1E  uni4F1E,  CJK UNIFIED IDEOGRAPH-4F1E
        0x6563, # G+3291  U+6563  uni6563,  CJK UNIFIED IDEOGRAPH-6563
        0x6851, # G+3292  U+6851  uni6851,  CJK UNIFIED IDEOGRAPH-6851
        0x55D3, # G+3293  U+55D3  uni55D3,  CJK UNIFIED IDEOGRAPH-55D3
        0x4E27, # G+3294  U+4E27  uni4E27,  CJK UNIFIED IDEOGRAPH-4E27
        0x6414, # G+3295  U+6414  uni6414,  CJK UNIFIED IDEOGRAPH-6414
        0x9A9A, # G+3296  U+9A9A  uni9A9A,  CJK UNIFIED IDEOGRAPH-9A9A
        0x626B, # G+3297  U+626B  uni626B,  CJK UNIFIED IDEOGRAPH-626B
        0x5AC2, # G+3298  U+5AC2  uni5AC2,  CJK UNIFIED IDEOGRAPH-5AC2
        0x745F, # G+3299  U+745F  uni745F,  CJK UNIFIED IDEOGRAPH-745F
        0x2F8A, # G+3300  U+2F8A  uni2F8A,  KANGXI RADICAL COLOR
        0x6DA9, # G+3301  U+6DA9  uni6DA9,  CJK UNIFIED IDEOGRAPH-6DA9
        0x68EE, # G+3302  U+68EE  uni68EE,  CJK UNIFIED IDEOGRAPH-68EE
        0x50E7, # G+3303  U+50E7  uni50E7,  CJK UNIFIED IDEOGRAPH-50E7
        0x838E, # G+3304  U+838E  uni838E,  CJK UNIFIED IDEOGRAPH-838E
        0x7802, # G+3305  U+7802  uni7802,  CJK UNIFIED IDEOGRAPH-7802
        0x6740, # G+3306  U+6740  uni6740,  CJK UNIFIED IDEOGRAPH-6740
        0x5239, # G+3307  U+5239  uni5239,  CJK UNIFIED IDEOGRAPH-5239
        0x6C99, # G+3308  U+6C99  uni6C99,  CJK UNIFIED IDEOGRAPH-6C99
        0x7EB1, # G+3309  U+7EB1  uni7EB1,  CJK UNIFIED IDEOGRAPH-7EB1
        0x50BB, # G+3310  U+50BB  uni50BB,  CJK UNIFIED IDEOGRAPH-50BB
        0x5565, # G+3311  U+5565  uni5565,  CJK UNIFIED IDEOGRAPH-5565
        0x715E, # G+3312  U+715E  uni715E,  CJK UNIFIED IDEOGRAPH-715E
        0x7B5B, # G+3313  U+7B5B  uni7B5B,  CJK UNIFIED IDEOGRAPH-7B5B
        0x6652, # G+3314  U+6652  uni6652,  CJK UNIFIED IDEOGRAPH-6652
        0x73CA, # G+3315  U+73CA  uni73CA,  CJK UNIFIED IDEOGRAPH-73CA
        0x82EB, # G+3316  U+82EB  uni82EB,  CJK UNIFIED IDEOGRAPH-82EB
        0x6749, # G+3317  U+6749  uni6749,  CJK UNIFIED IDEOGRAPH-6749
        0x2F2D, # G+3318  U+2F2D  uni2F2D,  KANGXI RADICAL MOUNTAIN
        0x5220, # G+3319  U+5220  uni5220,  CJK UNIFIED IDEOGRAPH-5220
        0x717D, # G+3320  U+717D  uni717D,  CJK UNIFIED IDEOGRAPH-717D
        0x886B, # G+3321  U+886B  uni886B,  CJK UNIFIED IDEOGRAPH-886B
        0x95EA, # G+3322  U+95EA  uni95EA,  CJK UNIFIED IDEOGRAPH-95EA
        0x9655, # G+3323  U+9655  uni9655,  CJK UNIFIED IDEOGRAPH-9655
        0x64C5, # G+3324  U+64C5  uni64C5,  CJK UNIFIED IDEOGRAPH-64C5
        0x8D61, # G+3325  U+8D61  uni8D61,  CJK UNIFIED IDEOGRAPH-8D61
        0x81B3, # G+3326  U+81B3  uni81B3,  CJK UNIFIED IDEOGRAPH-81B3
        0x5584, # G+3327  U+5584  uni5584,  CJK UNIFIED IDEOGRAPH-5584
        0x6C55, # G+3328  U+6C55  uni6C55,  CJK UNIFIED IDEOGRAPH-6C55
        0x6247, # G+3329  U+6247  uni6247,  CJK UNIFIED IDEOGRAPH-6247
        0x7F2E, # G+3330  U+7F2E  uni7F2E,  CJK UNIFIED IDEOGRAPH-7F2E
        0x5892, # G+3331  U+5892  uni5892,  CJK UNIFIED IDEOGRAPH-5892
        0x4F24, # G+3332  U+4F24  uni4F24,  CJK UNIFIED IDEOGRAPH-4F24
        0x5546, # G+3333  U+5546  uni5546,  CJK UNIFIED IDEOGRAPH-5546
        0x8D4F, # G+3334  U+8D4F  uni8D4F,  CJK UNIFIED IDEOGRAPH-8D4F
        0x664C, # G+3335  U+664C  uni664C,  CJK UNIFIED IDEOGRAPH-664C
        0x4E0A, # G+3336  U+4E0A  uni4E0A,  CJK UNIFIED IDEOGRAPH-4E0A
        0x5C1A, # G+3337  U+5C1A  uni5C1A,  CJK UNIFIED IDEOGRAPH-5C1A
        0x88F3, # G+3338  U+88F3  uni88F3,  CJK UNIFIED IDEOGRAPH-88F3
        0x68A2, # G+3339  U+68A2  uni68A2,  CJK UNIFIED IDEOGRAPH-68A2
        0x634E, # G+3340  U+634E  uni634E,  CJK UNIFIED IDEOGRAPH-634E
        0x7A0D, # G+3341  U+7A0D  uni7A0D,  CJK UNIFIED IDEOGRAPH-7A0D
        0x70E7, # G+3342  U+70E7  uni70E7,  CJK UNIFIED IDEOGRAPH-70E7
        0x828D, # G+3343  U+828D  uni828D,  CJK UNIFIED IDEOGRAPH-828D
        0x52FA, # G+3344  U+52FA  uni52FA,  CJK UNIFIED IDEOGRAPH-52FA
        0x97F6, # G+3345  U+97F6  uni97F6,  CJK UNIFIED IDEOGRAPH-97F6
        0x5C11, # G+3346  U+5C11  uni5C11,  CJK UNIFIED IDEOGRAPH-5C11
        0x54E8, # G+3347  U+54E8  uni54E8,  CJK UNIFIED IDEOGRAPH-54E8
        0x90B5, # G+3348  U+90B5  uni90B5,  CJK UNIFIED IDEOGRAPH-90B5
        0x7ECD, # G+3349  U+7ECD  uni7ECD,  CJK UNIFIED IDEOGRAPH-7ECD
        0x5962, # G+3350  U+5962  uni5962,  CJK UNIFIED IDEOGRAPH-5962
        0x8D4A, # G+3351  U+8D4A  uni8D4A,  CJK UNIFIED IDEOGRAPH-8D4A
        0x86C7, # G+3352  U+86C7  uni86C7,  CJK UNIFIED IDEOGRAPH-86C7
        0x2F86, # G+3353  U+2F86  uni2F86,  KANGXI RADICAL TONGUE
        0x820D, # G+3354  U+820D  uni820D,  CJK UNIFIED IDEOGRAPH-820D
        0x8D66, # G+3355  U+8D66  uni8D66,  CJK UNIFIED IDEOGRAPH-8D66
        0x6444, # G+3356  U+6444  uni6444,  CJK UNIFIED IDEOGRAPH-6444
        0x5C04, # G+3357  U+5C04  uni5C04,  CJK UNIFIED IDEOGRAPH-5C04
        0x6151, # G+3358  U+6151  uni6151,  CJK UNIFIED IDEOGRAPH-6151
        0x6D89, # G+3359  U+6D89  uni6D89,  CJK UNIFIED IDEOGRAPH-6D89
        0x793E, # G+3360  U+793E  uni793E,  CJK UNIFIED IDEOGRAPH-793E
        0x8BBE, # G+3361  U+8BBE  uni8BBE,  CJK UNIFIED IDEOGRAPH-8BBE
        0x7837, # G+3362  U+7837  uni7837,  CJK UNIFIED IDEOGRAPH-7837
        0x7533, # G+3363  U+7533  uni7533,  CJK UNIFIED IDEOGRAPH-7533
        0x547B, # G+3364  U+547B  uni547B,  CJK UNIFIED IDEOGRAPH-547B
        0x4F38, # G+3365  U+4F38  uni4F38,  CJK UNIFIED IDEOGRAPH-4F38
        0x2F9D, # G+3366  U+2F9D  uni2F9D,  KANGXI RADICAL BODY
        0x6DF1, # G+3367  U+6DF1  uni6DF1,  CJK UNIFIED IDEOGRAPH-6DF1
        0x5A20, # G+3368  U+5A20  uni5A20,  CJK UNIFIED IDEOGRAPH-5A20
        0x7EC5, # G+3369  U+7EC5  uni7EC5,  CJK UNIFIED IDEOGRAPH-7EC5
        0x795E, # G+3370  U+795E  uni795E,  CJK UNIFIED IDEOGRAPH-795E
        0x6C88, # G+3371  U+6C88  uni6C88,  CJK UNIFIED IDEOGRAPH-6C88
        0x5BA1, # G+3372  U+5BA1  uni5BA1,  CJK UNIFIED IDEOGRAPH-5BA1
        0x5A76, # G+3373  U+5A76  uni5A76,  CJK UNIFIED IDEOGRAPH-5A76
        0x751A, # G+3374  U+751A  uni751A,  CJK UNIFIED IDEOGRAPH-751A
        0x80BE, # G+3375  U+80BE  uni80BE,  CJK UNIFIED IDEOGRAPH-80BE
        0x614E, # G+3376  U+614E  uni614E,  CJK UNIFIED IDEOGRAPH-614E
        0x6E17, # G+3377  U+6E17  uni6E17,  CJK UNIFIED IDEOGRAPH-6E17
        0x58F0, # G+3378  U+58F0  uni58F0,  CJK UNIFIED IDEOGRAPH-58F0
        0x2F63, # G+3379  U+2F63  uni2F63,  KANGXI RADICAL LIFE
        0x7525, # G+3380  U+7525  uni7525,  CJK UNIFIED IDEOGRAPH-7525
        0x7272, # G+3381  U+7272  uni7272,  CJK UNIFIED IDEOGRAPH-7272
        0x5347, # G+3382  U+5347  uni5347,  CJK UNIFIED IDEOGRAPH-5347
        0x7EF3, # G+3383  U+7EF3  uni7EF3,  CJK UNIFIED IDEOGRAPH-7EF3
        0x7701, # G+3384  U+7701  uni7701,  CJK UNIFIED IDEOGRAPH-7701
        0x76DB, # G+3385  U+76DB  uni76DB,  CJK UNIFIED IDEOGRAPH-76DB
        0x5269, # G+3386  U+5269  uni5269,  CJK UNIFIED IDEOGRAPH-5269
        0x80DC, # G+3387  U+80DC  uni80DC,  CJK UNIFIED IDEOGRAPH-80DC
        0x5723, # G+3388  U+5723  uni5723,  CJK UNIFIED IDEOGRAPH-5723
        0x5E08, # G+3389  U+5E08  uni5E08,  CJK UNIFIED IDEOGRAPH-5E08
        0x5931, # G+3390  U+5931  uni5931,  CJK UNIFIED IDEOGRAPH-5931
        0x72EE, # G+3391  U+72EE  uni72EE,  CJK UNIFIED IDEOGRAPH-72EE
        0x65BD, # G+3392  U+65BD  uni65BD,  CJK UNIFIED IDEOGRAPH-65BD
        0x6E7F, # G+3393  U+6E7F  uni6E7F,  CJK UNIFIED IDEOGRAPH-6E7F
        0x8BD7, # G+3394  U+8BD7  uni8BD7,  CJK UNIFIED IDEOGRAPH-8BD7
        0x2F2B, # G+3395  U+2F2B  uni2F2B,  KANGXI RADICAL CORPSE
        0x8671, # G+3396  U+8671  uni8671,  CJK UNIFIED IDEOGRAPH-8671
        0x2F17, # G+3397  U+2F17  uni2F17,  KANGXI RADICAL TEN
        0x2F6F, # G+3398  U+2F6F  uni2F6F,  KANGXI RADICAL STONE
        0x62FE, # G+3399  U+62FE  uni62FE,  CJK UNIFIED IDEOGRAPH-62FE
        0x65F6, # G+3400  U+65F6  uni65F6,  CJK UNIFIED IDEOGRAPH-65F6
        0x4EC0, # G+3401  U+4EC0  uni4EC0,  CJK UNIFIED IDEOGRAPH-4EC0
        0x2FB7, # G+3402  U+2FB7  uni2FB7,  KANGXI RADICAL EAT
        0x8680, # G+3403  U+8680  uni8680,  CJK UNIFIED IDEOGRAPH-8680
        0x5B9E, # G+3404  U+5B9E  uni5B9E,  CJK UNIFIED IDEOGRAPH-5B9E
        0x8BC6, # G+3405  U+8BC6  uni8BC6,  CJK UNIFIED IDEOGRAPH-8BC6
        0x53F2, # G+3406  U+53F2  uni53F2,  CJK UNIFIED IDEOGRAPH-53F2
        0x2F6E, # G+3407  U+2F6E  uni2F6E,  KANGXI RADICAL ARROW
        0x4F7F, # G+3408  U+4F7F  uni4F7F,  CJK UNIFIED IDEOGRAPH-4F7F
        0x5C4E, # G+3409  U+5C4E  uni5C4E,  CJK UNIFIED IDEOGRAPH-5C4E
        0x9A76, # G+3410  U+9A76  uni9A76,  CJK UNIFIED IDEOGRAPH-9A76
        0x59CB, # G+3411  U+59CB  uni59CB,  CJK UNIFIED IDEOGRAPH-59CB
        0x5F0F, # G+3412  U+5F0F  uni5F0F,  CJK UNIFIED IDEOGRAPH-5F0F
        0x2F70, # G+3413  U+2F70  uni2F70,  KANGXI RADICAL SPIRIT
        0x2F20, # G+3414  U+2F20  uni2F20,  KANGXI RADICAL SCHOLAR
        0x4E16, # G+3415  U+4E16  uni4E16,  CJK UNIFIED IDEOGRAPH-4E16
        0x67FF, # G+3416  U+67FF  uni67FF,  CJK UNIFIED IDEOGRAPH-67FF
        0x4E8B, # G+3417  U+4E8B  uni4E8B,  CJK UNIFIED IDEOGRAPH-4E8B
        0x62ED, # G+3418  U+62ED  uni62ED,  CJK UNIFIED IDEOGRAPH-62ED
        0x8A93, # G+3419  U+8A93  uni8A93,  CJK UNIFIED IDEOGRAPH-8A93
        0x901D, # G+3420  U+901D  uni901D,  CJK UNIFIED IDEOGRAPH-901D
        0x52BF, # G+3421  U+52BF  uni52BF,  CJK UNIFIED IDEOGRAPH-52BF
        0x662F, # G+3422  U+662F  uni662F,  CJK UNIFIED IDEOGRAPH-662F
        0x55DC, # G+3423  U+55DC  uni55DC,  CJK UNIFIED IDEOGRAPH-55DC
        0x566C, # G+3424  U+566C  uni566C,  CJK UNIFIED IDEOGRAPH-566C
        0x9002, # G+3425  U+9002  uni9002,  CJK UNIFIED IDEOGRAPH-9002
        0x4ED5, # G+3426  U+4ED5  uni4ED5,  CJK UNIFIED IDEOGRAPH-4ED5
        0x4F8D, # G+3427  U+4F8D  uni4F8D,  CJK UNIFIED IDEOGRAPH-4F8D
        0x91CA, # G+3428  U+91CA  uni91CA,  CJK UNIFIED IDEOGRAPH-91CA
        0x9970, # G+3429  U+9970  uni9970,  CJK UNIFIED IDEOGRAPH-9970
        0x2F52, # G+3430  U+2F52  uni2F52,  KANGXI RADICAL CLAN
        0x5E02, # G+3431  U+5E02  uni5E02,  CJK UNIFIED IDEOGRAPH-5E02
        0x6043, # G+3432  U+6043  uni6043,  CJK UNIFIED IDEOGRAPH-6043
        0x5BA4, # G+3433  U+5BA4  uni5BA4,  CJK UNIFIED IDEOGRAPH-5BA4
        0x89C6, # G+3434  U+89C6  uni89C6,  CJK UNIFIED IDEOGRAPH-89C6
        0x8BD5, # G+3435  U+8BD5  uni8BD5,  CJK UNIFIED IDEOGRAPH-8BD5
        0x6536, # G+3436  U+6536  uni6536,  CJK UNIFIED IDEOGRAPH-6536
        0x2F3F, # G+3437  U+2F3F  uni2F3F,  KANGXI RADICAL HAND
        0x2FB8, # G+3438  U+2FB8  uni2FB8,  KANGXI RADICAL HEAD
        0x5B88, # G+3439  U+5B88  uni5B88,  CJK UNIFIED IDEOGRAPH-5B88
        0x5BFF, # G+3440  U+5BFF  uni5BFF,  CJK UNIFIED IDEOGRAPH-5BFF
        0x6388, # G+3441  U+6388  uni6388,  CJK UNIFIED IDEOGRAPH-6388
        0x552E, # G+3442  U+552E  uni552E,  CJK UNIFIED IDEOGRAPH-552E
        0x53D7, # G+3443  U+53D7  uni53D7,  CJK UNIFIED IDEOGRAPH-53D7
        0x7626, # G+3444  U+7626  uni7626,  CJK UNIFIED IDEOGRAPH-7626
        0x517D, # G+3445  U+517D  uni517D,  CJK UNIFIED IDEOGRAPH-517D
        0x852C, # G+3446  U+852C  uni852C,  CJK UNIFIED IDEOGRAPH-852C
        0x67A2, # G+3447  U+67A2  uni67A2,  CJK UNIFIED IDEOGRAPH-67A2
        0x68B3, # G+3448  U+68B3  uni68B3,  CJK UNIFIED IDEOGRAPH-68B3
        0x6B8A, # G+3449  U+6B8A  uni6B8A,  CJK UNIFIED IDEOGRAPH-6B8A
        0x6292, # G+3450  U+6292  uni6292,  CJK UNIFIED IDEOGRAPH-6292
        0x8F93, # G+3451  U+8F93  uni8F93,  CJK UNIFIED IDEOGRAPH-8F93
        0x53D4, # G+3452  U+53D4  uni53D4,  CJK UNIFIED IDEOGRAPH-53D4
        0x8212, # G+3453  U+8212  uni8212,  CJK UNIFIED IDEOGRAPH-8212
        0x6DD1, # G+3454  U+6DD1  uni6DD1,  CJK UNIFIED IDEOGRAPH-6DD1
        0x758F, # G+3455  U+758F  uni758F,  CJK UNIFIED IDEOGRAPH-758F
        0x4E66, # G+3456  U+4E66  uni4E66,  CJK UNIFIED IDEOGRAPH-4E66
        0x8D4E, # G+3457  U+8D4E  uni8D4E,  CJK UNIFIED IDEOGRAPH-8D4E
        0x5B70, # G+3458  U+5B70  uni5B70,  CJK UNIFIED IDEOGRAPH-5B70
        0x719F, # G+3459  U+719F  uni719F,  CJK UNIFIED IDEOGRAPH-719F
        0x85AF, # G+3460  U+85AF  uni85AF,  CJK UNIFIED IDEOGRAPH-85AF
        0x6691, # G+3461  U+6691  uni6691,  CJK UNIFIED IDEOGRAPH-6691
        0x66D9, # G+3462  U+66D9  uni66D9,  CJK UNIFIED IDEOGRAPH-66D9
        0x7F72, # G+3463  U+7F72  uni7F72,  CJK UNIFIED IDEOGRAPH-7F72
        0x8700, # G+3464  U+8700  uni8700,  CJK UNIFIED IDEOGRAPH-8700
        0x2FC9, # G+3465  U+2FC9  uni2FC9,  KANGXI RADICAL MILLET
        0x2FCF, # G+3466  U+2FCF  uni2FCF,  KANGXI RADICAL RAT
        0x5C5E, # G+3467  U+5C5E  uni5C5E,  CJK UNIFIED IDEOGRAPH-5C5E
        0x672F, # G+3468  U+672F  uni672F,  CJK UNIFIED IDEOGRAPH-672F
        0x8FF0, # G+3469  U+8FF0  uni8FF0,  CJK UNIFIED IDEOGRAPH-8FF0
        0x6811, # G+3470  U+6811  uni6811,  CJK UNIFIED IDEOGRAPH-6811
        0x675F, # G+3471  U+675F  uni675F,  CJK UNIFIED IDEOGRAPH-675F
        0x620D, # G+3472  U+620D  uni620D,  CJK UNIFIED IDEOGRAPH-620D
        0x7AD6, # G+3473  U+7AD6  uni7AD6,  CJK UNIFIED IDEOGRAPH-7AD6
        0x5885, # G+3474  U+5885  uni5885,  CJK UNIFIED IDEOGRAPH-5885
        0x5EB6, # G+3475  U+5EB6  uni5EB6,  CJK UNIFIED IDEOGRAPH-5EB6
        0x6570, # G+3476  U+6570  uni6570,  CJK UNIFIED IDEOGRAPH-6570
        0x6F31, # G+3477  U+6F31  uni6F31,  CJK UNIFIED IDEOGRAPH-6F31
        0x6055, # G+3478  U+6055  uni6055,  CJK UNIFIED IDEOGRAPH-6055
        0x5237, # G+3479  U+5237  uni5237,  CJK UNIFIED IDEOGRAPH-5237
        0x800D, # G+3480  U+800D  uni800D,  CJK UNIFIED IDEOGRAPH-800D
        0x6454, # G+3481  U+6454  uni6454,  CJK UNIFIED IDEOGRAPH-6454
        0x8870, # G+3482  U+8870  uni8870,  CJK UNIFIED IDEOGRAPH-8870
        0x7529, # G+3483  U+7529  uni7529,  CJK UNIFIED IDEOGRAPH-7529
        0x5E05, # G+3484  U+5E05  uni5E05,  CJK UNIFIED IDEOGRAPH-5E05
        0x6813, # G+3485  U+6813  uni6813,  CJK UNIFIED IDEOGRAPH-6813
        0x62F4, # G+3486  U+62F4  uni62F4,  CJK UNIFIED IDEOGRAPH-62F4
        0x971C, # G+3487  U+971C  uni971C,  CJK UNIFIED IDEOGRAPH-971C
        0x53CC, # G+3488  U+53CC  uni53CC,  CJK UNIFIED IDEOGRAPH-53CC
        0x723D, # G+3489  U+723D  uni723D,  CJK UNIFIED IDEOGRAPH-723D
        0x8C01, # G+3490  U+8C01  uni8C01,  CJK UNIFIED IDEOGRAPH-8C01
        0x2F54, # G+3491  U+2F54  uni2F54,  KANGXI RADICAL WATER
        0x7761, # G+3492  U+7761  uni7761,  CJK UNIFIED IDEOGRAPH-7761
        0x7A0E, # G+3493  U+7A0E  uni7A0E,  CJK UNIFIED IDEOGRAPH-7A0E
        0x542E, # G+3494  U+542E  uni542E,  CJK UNIFIED IDEOGRAPH-542E
        0x77AC, # G+3495  U+77AC  uni77AC,  CJK UNIFIED IDEOGRAPH-77AC
        0x987A, # G+3496  U+987A  uni987A,  CJK UNIFIED IDEOGRAPH-987A
        0x821C, # G+3497  U+821C  uni821C,  CJK UNIFIED IDEOGRAPH-821C
        0x8BF4, # G+3498  U+8BF4  uni8BF4,  CJK UNIFIED IDEOGRAPH-8BF4
        0x7855, # G+3499  U+7855  uni7855,  CJK UNIFIED IDEOGRAPH-7855
        0x6714, # G+3500  U+6714  uni6714,  CJK UNIFIED IDEOGRAPH-6714
        0x70C1, # G+3501  U+70C1  uni70C1,  CJK UNIFIED IDEOGRAPH-70C1
        0x65AF, # G+3502  U+65AF  uni65AF,  CJK UNIFIED IDEOGRAPH-65AF
        0x6495, # G+3503  U+6495  uni6495,  CJK UNIFIED IDEOGRAPH-6495
        0x5636, # G+3504  U+5636  uni5636,  CJK UNIFIED IDEOGRAPH-5636
        0x601D, # G+3505  U+601D  uni601D,  CJK UNIFIED IDEOGRAPH-601D
        0x79C1, # G+3506  U+79C1  uni79C1,  CJK UNIFIED IDEOGRAPH-79C1
        0x53F8, # G+3507  U+53F8  uni53F8,  CJK UNIFIED IDEOGRAPH-53F8
        0x4E1D, # G+3508  U+4E1D  uni4E1D,  CJK UNIFIED IDEOGRAPH-4E1D
        0x6B7B, # G+3509  U+6B7B  uni6B7B,  CJK UNIFIED IDEOGRAPH-6B7B
        0x8086, # G+3510  U+8086  uni8086,  CJK UNIFIED IDEOGRAPH-8086
        0x5BFA, # G+3511  U+5BFA  uni5BFA,  CJK UNIFIED IDEOGRAPH-5BFA
        0x55E3, # G+3512  U+55E3  uni55E3,  CJK UNIFIED IDEOGRAPH-55E3
        0x56DB, # G+3513  U+56DB  uni56DB,  CJK UNIFIED IDEOGRAPH-56DB
        0x4F3A, # G+3514  U+4F3A  uni4F3A,  CJK UNIFIED IDEOGRAPH-4F3A
        0x4F3C, # G+3515  U+4F3C  uni4F3C,  CJK UNIFIED IDEOGRAPH-4F3C
        0x9972, # G+3516  U+9972  uni9972,  CJK UNIFIED IDEOGRAPH-9972
        0x5DF3, # G+3517  U+5DF3  uni5DF3,  CJK UNIFIED IDEOGRAPH-5DF3
        0x677E, # G+3518  U+677E  uni677E,  CJK UNIFIED IDEOGRAPH-677E
        0x8038, # G+3519  U+8038  uni8038,  CJK UNIFIED IDEOGRAPH-8038
        0x6002, # G+3520  U+6002  uni6002,  CJK UNIFIED IDEOGRAPH-6002
        0x9882, # G+3521  U+9882  uni9882,  CJK UNIFIED IDEOGRAPH-9882
        0x9001, # G+3522  U+9001  uni9001,  CJK UNIFIED IDEOGRAPH-9001
        0x5B8B, # G+3523  U+5B8B  uni5B8B,  CJK UNIFIED IDEOGRAPH-5B8B
        0x8BBC, # G+3524  U+8BBC  uni8BBC,  CJK UNIFIED IDEOGRAPH-8BBC
        0x8BF5, # G+3525  U+8BF5  uni8BF5,  CJK UNIFIED IDEOGRAPH-8BF5
        0x641C, # G+3526  U+641C  uni641C,  CJK UNIFIED IDEOGRAPH-641C
        0x8258, # G+3527  U+8258  uni8258,  CJK UNIFIED IDEOGRAPH-8258
        0x64DE, # G+3528  U+64DE  uni64DE,  CJK UNIFIED IDEOGRAPH-64DE
        0x55FD, # G+3529  U+55FD  uni55FD,  CJK UNIFIED IDEOGRAPH-55FD
        0x82CF, # G+3530  U+82CF  uni82CF,  CJK UNIFIED IDEOGRAPH-82CF
        0x9165, # G+3531  U+9165  uni9165,  CJK UNIFIED IDEOGRAPH-9165
        0x4FD7, # G+3532  U+4FD7  uni4FD7,  CJK UNIFIED IDEOGRAPH-4FD7
        0x7D20, # G+3533  U+7D20  uni7D20,  CJK UNIFIED IDEOGRAPH-7D20
        0x901F, # G+3534  U+901F  uni901F,  CJK UNIFIED IDEOGRAPH-901F
        0x7C9F, # G+3535  U+7C9F  uni7C9F,  CJK UNIFIED IDEOGRAPH-7C9F
        0x50F3, # G+3536  U+50F3  uni50F3,  CJK UNIFIED IDEOGRAPH-50F3
        0x5851, # G+3537  U+5851  uni5851,  CJK UNIFIED IDEOGRAPH-5851
        0x6EAF, # G+3538  U+6EAF  uni6EAF,  CJK UNIFIED IDEOGRAPH-6EAF
        0x5BBF, # G+3539  U+5BBF  uni5BBF,  CJK UNIFIED IDEOGRAPH-5BBF
        0x8BC9, # G+3540  U+8BC9  uni8BC9,  CJK UNIFIED IDEOGRAPH-8BC9
        0x8083, # G+3541  U+8083  uni8083,  CJK UNIFIED IDEOGRAPH-8083
        0x9178, # G+3542  U+9178  uni9178,  CJK UNIFIED IDEOGRAPH-9178
        0x849C, # G+3543  U+849C  uni849C,  CJK UNIFIED IDEOGRAPH-849C
        0x7B97, # G+3544  U+7B97  uni7B97,  CJK UNIFIED IDEOGRAPH-7B97
        0x867D, # G+3545  U+867D  uni867D,  CJK UNIFIED IDEOGRAPH-867D
        0x968B, # G+3546  U+968B  uni968B,  CJK UNIFIED IDEOGRAPH-968B
        0x968F, # G+3547  U+968F  uni968F,  CJK UNIFIED IDEOGRAPH-968F
        0x7EE5, # G+3548  U+7EE5  uni7EE5,  CJK UNIFIED IDEOGRAPH-7EE5
        0x9AD3, # G+3549  U+9AD3  uni9AD3,  CJK UNIFIED IDEOGRAPH-9AD3
        0x788E, # G+3550  U+788E  uni788E,  CJK UNIFIED IDEOGRAPH-788E
        0x5C81, # G+3551  U+5C81  uni5C81,  CJK UNIFIED IDEOGRAPH-5C81
        0x7A57, # G+3552  U+7A57  uni7A57,  CJK UNIFIED IDEOGRAPH-7A57
        0x9042, # G+3553  U+9042  uni9042,  CJK UNIFIED IDEOGRAPH-9042
        0x96A7, # G+3554  U+96A7  uni96A7,  CJK UNIFIED IDEOGRAPH-96A7
        0x795F, # G+3555  U+795F  uni795F,  CJK UNIFIED IDEOGRAPH-795F
        0x5B59, # G+3556  U+5B59  uni5B59,  CJK UNIFIED IDEOGRAPH-5B59
        0x635F, # G+3557  U+635F  uni635F,  CJK UNIFIED IDEOGRAPH-635F
        0x7B0B, # G+3558  U+7B0B  uni7B0B,  CJK UNIFIED IDEOGRAPH-7B0B
        0x84D1, # G+3559  U+84D1  uni84D1,  CJK UNIFIED IDEOGRAPH-84D1
        0x68AD, # G+3560  U+68AD  uni68AD,  CJK UNIFIED IDEOGRAPH-68AD
        0x5506, # G+3561  U+5506  uni5506,  CJK UNIFIED IDEOGRAPH-5506
        0x7F29, # G+3562  U+7F29  uni7F29,  CJK UNIFIED IDEOGRAPH-7F29
        0x7410, # G+3563  U+7410  uni7410,  CJK UNIFIED IDEOGRAPH-7410
        0x7D22, # G+3564  U+7D22  uni7D22,  CJK UNIFIED IDEOGRAPH-7D22
        0x9501, # G+3565  U+9501  uni9501,  CJK UNIFIED IDEOGRAPH-9501
        0x6240, # G+3566  U+6240  uni6240,  CJK UNIFIED IDEOGRAPH-6240
        0x584C, # G+3567  U+584C  uni584C,  CJK UNIFIED IDEOGRAPH-584C
        0x4ED6, # G+3568  U+4ED6  uni4ED6,  CJK UNIFIED IDEOGRAPH-4ED6
        0x5B83, # G+3569  U+5B83  uni5B83,  CJK UNIFIED IDEOGRAPH-5B83
        0x5979, # G+3570  U+5979  uni5979,  CJK UNIFIED IDEOGRAPH-5979
        0x5854, # G+3571  U+5854  uni5854,  CJK UNIFIED IDEOGRAPH-5854
        0x736D, # G+3572  U+736D  uni736D,  CJK UNIFIED IDEOGRAPH-736D
        0x631E, # G+3573  U+631E  uni631E,  CJK UNIFIED IDEOGRAPH-631E
        0x8E4B, # G+3574  U+8E4B  uni8E4B,  CJK UNIFIED IDEOGRAPH-8E4B
        0x8E0F, # G+3575  U+8E0F  uni8E0F,  CJK UNIFIED IDEOGRAPH-8E0F
        0x80CE, # G+3576  U+80CE  uni80CE,  CJK UNIFIED IDEOGRAPH-80CE
        0x82D4, # G+3577  U+82D4  uni82D4,  CJK UNIFIED IDEOGRAPH-82D4
        0x62AC, # G+3578  U+62AC  uni62AC,  CJK UNIFIED IDEOGRAPH-62AC
        0x53F0, # G+3579  U+53F0  uni53F0,  CJK UNIFIED IDEOGRAPH-53F0
        0x6CF0, # G+3580  U+6CF0  uni6CF0,  CJK UNIFIED IDEOGRAPH-6CF0
        0x915E, # G+3581  U+915E  uni915E,  CJK UNIFIED IDEOGRAPH-915E
        0x592A, # G+3582  U+592A  uni592A,  CJK UNIFIED IDEOGRAPH-592A
        0x6001, # G+3583  U+6001  uni6001,  CJK UNIFIED IDEOGRAPH-6001
        0x6C70, # G+3584  U+6C70  uni6C70,  CJK UNIFIED IDEOGRAPH-6C70
        0x574D, # G+3585  U+574D  uni574D,  CJK UNIFIED IDEOGRAPH-574D
        0x644A, # G+3586  U+644A  uni644A,  CJK UNIFIED IDEOGRAPH-644A
        0x8D2A, # G+3587  U+8D2A  uni8D2A,  CJK UNIFIED IDEOGRAPH-8D2A
        0x762B, # G+3588  U+762B  uni762B,  CJK UNIFIED IDEOGRAPH-762B
        0x6EE9, # G+3589  U+6EE9  uni6EE9,  CJK UNIFIED IDEOGRAPH-6EE9
        0x575B, # G+3590  U+575B  uni575B,  CJK UNIFIED IDEOGRAPH-575B
        0x6A80, # G+3591  U+6A80  uni6A80,  CJK UNIFIED IDEOGRAPH-6A80
        0x75F0, # G+3592  U+75F0  uni75F0,  CJK UNIFIED IDEOGRAPH-75F0
        0x6F6D, # G+3593  U+6F6D  uni6F6D,  CJK UNIFIED IDEOGRAPH-6F6D
        0x8C2D, # G+3594  U+8C2D  uni8C2D,  CJK UNIFIED IDEOGRAPH-8C2D
        0x8C08, # G+3595  U+8C08  uni8C08,  CJK UNIFIED IDEOGRAPH-8C08
        0x5766, # G+3596  U+5766  uni5766,  CJK UNIFIED IDEOGRAPH-5766
        0x6BEF, # G+3597  U+6BEF  uni6BEF,  CJK UNIFIED IDEOGRAPH-6BEF
        0x8892, # G+3598  U+8892  uni8892,  CJK UNIFIED IDEOGRAPH-8892
        0x78B3, # G+3599  U+78B3  uni78B3,  CJK UNIFIED IDEOGRAPH-78B3
        0x63A2, # G+3600  U+63A2  uni63A2,  CJK UNIFIED IDEOGRAPH-63A2
        0x53F9, # G+3601  U+53F9  uni53F9,  CJK UNIFIED IDEOGRAPH-53F9
        0x70AD, # G+3602  U+70AD  uni70AD,  CJK UNIFIED IDEOGRAPH-70AD
        0x6C64, # G+3603  U+6C64  uni6C64,  CJK UNIFIED IDEOGRAPH-6C64
        0x5858, # G+3604  U+5858  uni5858,  CJK UNIFIED IDEOGRAPH-5858
        0x642A, # G+3605  U+642A  uni642A,  CJK UNIFIED IDEOGRAPH-642A
        0x5802, # G+3606  U+5802  uni5802,  CJK UNIFIED IDEOGRAPH-5802
        0x68E0, # G+3607  U+68E0  uni68E0,  CJK UNIFIED IDEOGRAPH-68E0
        0x819B, # G+3608  U+819B  uni819B,  CJK UNIFIED IDEOGRAPH-819B
        0x5510, # G+3609  U+5510  uni5510,  CJK UNIFIED IDEOGRAPH-5510
        0x7CD6, # G+3610  U+7CD6  uni7CD6,  CJK UNIFIED IDEOGRAPH-7CD6
        0x5018, # G+3611  U+5018  uni5018,  CJK UNIFIED IDEOGRAPH-5018
        0x8EBA, # G+3612  U+8EBA  uni8EBA,  CJK UNIFIED IDEOGRAPH-8EBA
        0x6DCC, # G+3613  U+6DCC  uni6DCC,  CJK UNIFIED IDEOGRAPH-6DCC
        0x8D9F, # G+3614  U+8D9F  uni8D9F,  CJK UNIFIED IDEOGRAPH-8D9F
        0x70EB, # G+3615  U+70EB  uni70EB,  CJK UNIFIED IDEOGRAPH-70EB
        0x638F, # G+3616  U+638F  uni638F,  CJK UNIFIED IDEOGRAPH-638F
        0x6D9B, # G+3617  U+6D9B  uni6D9B,  CJK UNIFIED IDEOGRAPH-6D9B
        0x6ED4, # G+3618  U+6ED4  uni6ED4,  CJK UNIFIED IDEOGRAPH-6ED4
        0x7EE6, # G+3619  U+7EE6  uni7EE6,  CJK UNIFIED IDEOGRAPH-7EE6
        0x8404, # G+3620  U+8404  uni8404,  CJK UNIFIED IDEOGRAPH-8404
        0x6843, # G+3621  U+6843  uni6843,  CJK UNIFIED IDEOGRAPH-6843
        0x9003, # G+3622  U+9003  uni9003,  CJK UNIFIED IDEOGRAPH-9003
        0x6DD8, # G+3623  U+6DD8  uni6DD8,  CJK UNIFIED IDEOGRAPH-6DD8
        0x9676, # G+3624  U+9676  uni9676,  CJK UNIFIED IDEOGRAPH-9676
        0x8BA8, # G+3625  U+8BA8  uni8BA8,  CJK UNIFIED IDEOGRAPH-8BA8
        0x5957, # G+3626  U+5957  uni5957,  CJK UNIFIED IDEOGRAPH-5957
        0x7279, # G+3627  U+7279  uni7279,  CJK UNIFIED IDEOGRAPH-7279
        0x85E4, # G+3628  U+85E4  uni85E4,  CJK UNIFIED IDEOGRAPH-85E4
        0x817E, # G+3629  U+817E  uni817E,  CJK UNIFIED IDEOGRAPH-817E
        0x75BC, # G+3630  U+75BC  uni75BC,  CJK UNIFIED IDEOGRAPH-75BC
        0x8A8A, # G+3631  U+8A8A  uni8A8A,  CJK UNIFIED IDEOGRAPH-8A8A
        0x68AF, # G+3632  U+68AF  uni68AF,  CJK UNIFIED IDEOGRAPH-68AF
        0x5254, # G+3633  U+5254  uni5254,  CJK UNIFIED IDEOGRAPH-5254
        0x8E22, # G+3634  U+8E22  uni8E22,  CJK UNIFIED IDEOGRAPH-8E22
        0x9511, # G+3635  U+9511  uni9511,  CJK UNIFIED IDEOGRAPH-9511
        0x63D0, # G+3636  U+63D0  uni63D0,  CJK UNIFIED IDEOGRAPH-63D0
        0x9898, # G+3637  U+9898  uni9898,  CJK UNIFIED IDEOGRAPH-9898
        0x8E44, # G+3638  U+8E44  uni8E44,  CJK UNIFIED IDEOGRAPH-8E44
        0x557C, # G+3639  U+557C  uni557C,  CJK UNIFIED IDEOGRAPH-557C
        0x4F53, # G+3640  U+4F53  uni4F53,  CJK UNIFIED IDEOGRAPH-4F53
        0x66FF, # G+3641  U+66FF  uni66FF,  CJK UNIFIED IDEOGRAPH-66FF
        0x568F, # G+3642  U+568F  uni568F,  CJK UNIFIED IDEOGRAPH-568F
        0x60D5, # G+3643  U+60D5  uni60D5,  CJK UNIFIED IDEOGRAPH-60D5
        0x6D95, # G+3644  U+6D95  uni6D95,  CJK UNIFIED IDEOGRAPH-6D95
        0x5243, # G+3645  U+5243  uni5243,  CJK UNIFIED IDEOGRAPH-5243
        0x5C49, # G+3646  U+5C49  uni5C49,  CJK UNIFIED IDEOGRAPH-5C49
        0x5929, # G+3647  U+5929  uni5929,  CJK UNIFIED IDEOGRAPH-5929
        0x6DFB, # G+3648  U+6DFB  uni6DFB,  CJK UNIFIED IDEOGRAPH-6DFB
        0x586B, # G+3649  U+586B  uni586B,  CJK UNIFIED IDEOGRAPH-586B
        0x2F65, # G+3650  U+2F65  uni2F65,  KANGXI RADICAL FIELD
        0x751C, # G+3651  U+751C  uni751C,  CJK UNIFIED IDEOGRAPH-751C
        0x606C, # G+3652  U+606C  uni606C,  CJK UNIFIED IDEOGRAPH-606C
        0x8214, # G+3653  U+8214  uni8214,  CJK UNIFIED IDEOGRAPH-8214
        0x8146, # G+3654  U+8146  uni8146,  CJK UNIFIED IDEOGRAPH-8146
        0x6311, # G+3655  U+6311  uni6311,  CJK UNIFIED IDEOGRAPH-6311
        0x6761, # G+3656  U+6761  uni6761,  CJK UNIFIED IDEOGRAPH-6761
        0x8FE2, # G+3657  U+8FE2  uni8FE2,  CJK UNIFIED IDEOGRAPH-8FE2
        0x773A, # G+3658  U+773A  uni773A,  CJK UNIFIED IDEOGRAPH-773A
        0x8DF3, # G+3659  U+8DF3  uni8DF3,  CJK UNIFIED IDEOGRAPH-8DF3
        0x8D34, # G+3660  U+8D34  uni8D34,  CJK UNIFIED IDEOGRAPH-8D34
        0x94C1, # G+3661  U+94C1  uni94C1,  CJK UNIFIED IDEOGRAPH-94C1
        0x5E16, # G+3662  U+5E16  uni5E16,  CJK UNIFIED IDEOGRAPH-5E16
        0x5385, # G+3663  U+5385  uni5385,  CJK UNIFIED IDEOGRAPH-5385
        0x542C, # G+3664  U+542C  uni542C,  CJK UNIFIED IDEOGRAPH-542C
        0x70C3, # G+3665  U+70C3  uni70C3,  CJK UNIFIED IDEOGRAPH-70C3
        0x6C40, # G+3666  U+6C40  uni6C40,  CJK UNIFIED IDEOGRAPH-6C40
        0x5EF7, # G+3667  U+5EF7  uni5EF7,  CJK UNIFIED IDEOGRAPH-5EF7
        0x505C, # G+3668  U+505C  uni505C,  CJK UNIFIED IDEOGRAPH-505C
        0x4EAD, # G+3669  U+4EAD  uni4EAD,  CJK UNIFIED IDEOGRAPH-4EAD
        0x5EAD, # G+3670  U+5EAD  uni5EAD,  CJK UNIFIED IDEOGRAPH-5EAD
        0x633A, # G+3671  U+633A  uni633A,  CJK UNIFIED IDEOGRAPH-633A
        0x8247, # G+3672  U+8247  uni8247,  CJK UNIFIED IDEOGRAPH-8247
        0x901A, # G+3673  U+901A  uni901A,  CJK UNIFIED IDEOGRAPH-901A
        0x6850, # G+3674  U+6850  uni6850,  CJK UNIFIED IDEOGRAPH-6850
        0x916E, # G+3675  U+916E  uni916E,  CJK UNIFIED IDEOGRAPH-916E
        0x77B3, # G+3676  U+77B3  uni77B3,  CJK UNIFIED IDEOGRAPH-77B3
        0x540C, # G+3677  U+540C  uni540C,  CJK UNIFIED IDEOGRAPH-540C
        0x94DC, # G+3678  U+94DC  uni94DC,  CJK UNIFIED IDEOGRAPH-94DC
        0x5F64, # G+3679  U+5F64  uni5F64,  CJK UNIFIED IDEOGRAPH-5F64
        0x7AE5, # G+3680  U+7AE5  uni7AE5,  CJK UNIFIED IDEOGRAPH-7AE5
        0x6876, # G+3681  U+6876  uni6876,  CJK UNIFIED IDEOGRAPH-6876
        0x6345, # G+3682  U+6345  uni6345,  CJK UNIFIED IDEOGRAPH-6345
        0x7B52, # G+3683  U+7B52  uni7B52,  CJK UNIFIED IDEOGRAPH-7B52
        0x7EDF, # G+3684  U+7EDF  uni7EDF,  CJK UNIFIED IDEOGRAPH-7EDF
        0x75DB, # G+3685  U+75DB  uni75DB,  CJK UNIFIED IDEOGRAPH-75DB
        0x5077, # G+3686  U+5077  uni5077,  CJK UNIFIED IDEOGRAPH-5077
        0x6295, # G+3687  U+6295  uni6295,  CJK UNIFIED IDEOGRAPH-6295
        0x5934, # G+3688  U+5934  uni5934,  CJK UNIFIED IDEOGRAPH-5934
        0x900F, # G+3689  U+900F  uni900F,  CJK UNIFIED IDEOGRAPH-900F
        0x51F8, # G+3690  U+51F8  uni51F8,  CJK UNIFIED IDEOGRAPH-51F8
        0x79C3, # G+3691  U+79C3  uni79C3,  CJK UNIFIED IDEOGRAPH-79C3
        0x7A81, # G+3692  U+7A81  uni7A81,  CJK UNIFIED IDEOGRAPH-7A81
        0x56FE, # G+3693  U+56FE  uni56FE,  CJK UNIFIED IDEOGRAPH-56FE
        0x5F92, # G+3694  U+5F92  uni5F92,  CJK UNIFIED IDEOGRAPH-5F92
        0x9014, # G+3695  U+9014  uni9014,  CJK UNIFIED IDEOGRAPH-9014
        0x6D82, # G+3696  U+6D82  uni6D82,  CJK UNIFIED IDEOGRAPH-6D82
        0x5C60, # G+3697  U+5C60  uni5C60,  CJK UNIFIED IDEOGRAPH-5C60
        0x2F1F, # G+3698  U+2F1F  uni2F1F,  KANGXI RADICAL EARTH
        0x5410, # G+3699  U+5410  uni5410,  CJK UNIFIED IDEOGRAPH-5410
        0x5154, # G+3700  U+5154  uni5154,  CJK UNIFIED IDEOGRAPH-5154
        0x6E4D, # G+3701  U+6E4D  uni6E4D,  CJK UNIFIED IDEOGRAPH-6E4D
        0x56E2, # G+3702  U+56E2  uni56E2,  CJK UNIFIED IDEOGRAPH-56E2
        0x63A8, # G+3703  U+63A8  uni63A8,  CJK UNIFIED IDEOGRAPH-63A8
        0x9893, # G+3704  U+9893  uni9893,  CJK UNIFIED IDEOGRAPH-9893
        0x817F, # G+3705  U+817F  uni817F,  CJK UNIFIED IDEOGRAPH-817F
        0x8715, # G+3706  U+8715  uni8715,  CJK UNIFIED IDEOGRAPH-8715
        0x892A, # G+3707  U+892A  uni892A,  CJK UNIFIED IDEOGRAPH-892A
        0x9000, # G+3708  U+9000  uni9000,  CJK UNIFIED IDEOGRAPH-9000
        0x541E, # G+3709  U+541E  uni541E,  CJK UNIFIED IDEOGRAPH-541E
        0x5C6F, # G+3710  U+5C6F  uni5C6F,  CJK UNIFIED IDEOGRAPH-5C6F
        0x81C0, # G+3711  U+81C0  uni81C0,  CJK UNIFIED IDEOGRAPH-81C0
        0x62D6, # G+3712  U+62D6  uni62D6,  CJK UNIFIED IDEOGRAPH-62D6
        0x6258, # G+3713  U+6258  uni6258,  CJK UNIFIED IDEOGRAPH-6258
        0x8131, # G+3714  U+8131  uni8131,  CJK UNIFIED IDEOGRAPH-8131
        0x9E35, # G+3715  U+9E35  uni9E35,  CJK UNIFIED IDEOGRAPH-9E35
        0x9640, # G+3716  U+9640  uni9640,  CJK UNIFIED IDEOGRAPH-9640
        0x9A6E, # G+3717  U+9A6E  uni9A6E,  CJK UNIFIED IDEOGRAPH-9A6E
        0x9A7C, # G+3718  U+9A7C  uni9A7C,  CJK UNIFIED IDEOGRAPH-9A7C
        0x692D, # G+3719  U+692D  uni692D,  CJK UNIFIED IDEOGRAPH-692D
        0x59A5, # G+3720  U+59A5  uni59A5,  CJK UNIFIED IDEOGRAPH-59A5
        0x62D3, # G+3721  U+62D3  uni62D3,  CJK UNIFIED IDEOGRAPH-62D3
        0x553E, # G+3722  U+553E  uni553E,  CJK UNIFIED IDEOGRAPH-553E
        0x6316, # G+3723  U+6316  uni6316,  CJK UNIFIED IDEOGRAPH-6316
        0x54C7, # G+3724  U+54C7  uni54C7,  CJK UNIFIED IDEOGRAPH-54C7
        0x86D9, # G+3725  U+86D9  uni86D9,  CJK UNIFIED IDEOGRAPH-86D9
        0x6D3C, # G+3726  U+6D3C  uni6D3C,  CJK UNIFIED IDEOGRAPH-6D3C
        0x5A03, # G+3727  U+5A03  uni5A03,  CJK UNIFIED IDEOGRAPH-5A03
        0x2F61, # G+3728  U+2F61  uni2F61,  KANGXI RADICAL TILE
        0x889C, # G+3729  U+889C  uni889C,  CJK UNIFIED IDEOGRAPH-889C
        0x6B6A, # G+3730  U+6B6A  uni6B6A,  CJK UNIFIED IDEOGRAPH-6B6A
        0x5916, # G+3731  U+5916  uni5916,  CJK UNIFIED IDEOGRAPH-5916
        0x8C4C, # G+3732  U+8C4C  uni8C4C,  CJK UNIFIED IDEOGRAPH-8C4C
        0x5F2F, # G+3733  U+5F2F  uni5F2F,  CJK UNIFIED IDEOGRAPH-5F2F
        0x6E7E, # G+3734  U+6E7E  uni6E7E,  CJK UNIFIED IDEOGRAPH-6E7E
        0x73A9, # G+3735  U+73A9  uni73A9,  CJK UNIFIED IDEOGRAPH-73A9
        0x987D, # G+3736  U+987D  uni987D,  CJK UNIFIED IDEOGRAPH-987D
        0x4E38, # G+3737  U+4E38  uni4E38,  CJK UNIFIED IDEOGRAPH-4E38
        0x70F7, # G+3738  U+70F7  uni70F7,  CJK UNIFIED IDEOGRAPH-70F7
        0x5B8C, # G+3739  U+5B8C  uni5B8C,  CJK UNIFIED IDEOGRAPH-5B8C
        0x7897, # G+3740  U+7897  uni7897,  CJK UNIFIED IDEOGRAPH-7897
        0x633D, # G+3741  U+633D  uni633D,  CJK UNIFIED IDEOGRAPH-633D
        0x665A, # G+3742  U+665A  uni665A,  CJK UNIFIED IDEOGRAPH-665A
        0x7696, # G+3743  U+7696  uni7696,  CJK UNIFIED IDEOGRAPH-7696
        0x60CB, # G+3744  U+60CB  uni60CB,  CJK UNIFIED IDEOGRAPH-60CB
        0x5B9B, # G+3745  U+5B9B  uni5B9B,  CJK UNIFIED IDEOGRAPH-5B9B
        0x5A49, # G+3746  U+5A49  uni5A49,  CJK UNIFIED IDEOGRAPH-5A49
        0x4E07, # G+3747  U+4E07  uni4E07,  CJK UNIFIED IDEOGRAPH-4E07
        0x8155, # G+3748  U+8155  uni8155,  CJK UNIFIED IDEOGRAPH-8155
        0x6C6A, # G+3749  U+6C6A  uni6C6A,  CJK UNIFIED IDEOGRAPH-6C6A
        0x738B, # G+3750  U+738B  uni738B,  CJK UNIFIED IDEOGRAPH-738B
        0x4EA1, # G+3751  U+4EA1  uni4EA1,  CJK UNIFIED IDEOGRAPH-4EA1
        0x6789, # G+3752  U+6789  uni6789,  CJK UNIFIED IDEOGRAPH-6789
        0x2F79, # G+3753  U+2F79  uni2F79,  KANGXI RADICAL NET
        0x5F80, # G+3754  U+5F80  uni5F80,  CJK UNIFIED IDEOGRAPH-5F80
        0x65FA, # G+3755  U+65FA  uni65FA,  CJK UNIFIED IDEOGRAPH-65FA
        0x671B, # G+3756  U+671B  uni671B,  CJK UNIFIED IDEOGRAPH-671B
        0x5FD8, # G+3757  U+5FD8  uni5FD8,  CJK UNIFIED IDEOGRAPH-5FD8
        0x5984, # G+3758  U+5984  uni5984,  CJK UNIFIED IDEOGRAPH-5984
        0x5A01, # G+3759  U+5A01  uni5A01,  CJK UNIFIED IDEOGRAPH-5A01
        0x5DCD, # G+3760  U+5DCD  uni5DCD,  CJK UNIFIED IDEOGRAPH-5DCD
        0x5FAE, # G+3761  U+5FAE  uni5FAE,  CJK UNIFIED IDEOGRAPH-5FAE
        0x5371, # G+3762  U+5371  uni5371,  CJK UNIFIED IDEOGRAPH-5371
        0x97E6, # G+3763  U+97E6  uni97E6,  CJK UNIFIED IDEOGRAPH-97E6
        0x8FDD, # G+3764  U+8FDD  uni8FDD,  CJK UNIFIED IDEOGRAPH-8FDD
        0x6845, # G+3765  U+6845  uni6845,  CJK UNIFIED IDEOGRAPH-6845
        0x56F4, # G+3766  U+56F4  uni56F4,  CJK UNIFIED IDEOGRAPH-56F4
        0x552F, # G+3767  U+552F  uni552F,  CJK UNIFIED IDEOGRAPH-552F
        0x60DF, # G+3768  U+60DF  uni60DF,  CJK UNIFIED IDEOGRAPH-60DF
        0x4E3A, # G+3769  U+4E3A  uni4E3A,  CJK UNIFIED IDEOGRAPH-4E3A
        0x6F4D, # G+3770  U+6F4D  uni6F4D,  CJK UNIFIED IDEOGRAPH-6F4D
        0x7EF4, # G+3771  U+7EF4  uni7EF4,  CJK UNIFIED IDEOGRAPH-7EF4
        0x82C7, # G+3772  U+82C7  uni82C7,  CJK UNIFIED IDEOGRAPH-82C7
        0x840E, # G+3773  U+840E  uni840E,  CJK UNIFIED IDEOGRAPH-840E
        0x59D4, # G+3774  U+59D4  uni59D4,  CJK UNIFIED IDEOGRAPH-59D4
        0x4F1F, # G+3775  U+4F1F  uni4F1F,  CJK UNIFIED IDEOGRAPH-4F1F
        0x4F2A, # G+3776  U+4F2A  uni4F2A,  CJK UNIFIED IDEOGRAPH-4F2A
        0x5C3E, # G+3777  U+5C3E  uni5C3E,  CJK UNIFIED IDEOGRAPH-5C3E
        0x7EAC, # G+3778  U+7EAC  uni7EAC,  CJK UNIFIED IDEOGRAPH-7EAC
        0x672A, # G+3779  U+672A  uni672A,  CJK UNIFIED IDEOGRAPH-672A
        0x851A, # G+3780  U+851A  uni851A,  CJK UNIFIED IDEOGRAPH-851A
        0x5473, # G+3781  U+5473  uni5473,  CJK UNIFIED IDEOGRAPH-5473
        0x754F, # G+3782  U+754F  uni754F,  CJK UNIFIED IDEOGRAPH-754F
        0x80C3, # G+3783  U+80C3  uni80C3,  CJK UNIFIED IDEOGRAPH-80C3
        0x5582, # G+3784  U+5582  uni5582,  CJK UNIFIED IDEOGRAPH-5582
        0x9B4F, # G+3785  U+9B4F  uni9B4F,  CJK UNIFIED IDEOGRAPH-9B4F
        0x4F4D, # G+3786  U+4F4D  uni4F4D,  CJK UNIFIED IDEOGRAPH-4F4D
        0x6E2D, # G+3787  U+6E2D  uni6E2D,  CJK UNIFIED IDEOGRAPH-6E2D
        0x8C13, # G+3788  U+8C13  uni8C13,  CJK UNIFIED IDEOGRAPH-8C13
        0x5C09, # G+3789  U+5C09  uni5C09,  CJK UNIFIED IDEOGRAPH-5C09
        0x6170, # G+3790  U+6170  uni6170,  CJK UNIFIED IDEOGRAPH-6170
        0x536B, # G+3791  U+536B  uni536B,  CJK UNIFIED IDEOGRAPH-536B
        0x761F, # G+3792  U+761F  uni761F,  CJK UNIFIED IDEOGRAPH-761F
        0x6E29, # G+3793  U+6E29  uni6E29,  CJK UNIFIED IDEOGRAPH-6E29
        0x868A, # G+3794  U+868A  uni868A,  CJK UNIFIED IDEOGRAPH-868A
        0x2F42, # G+3795  U+2F42  uni2F42,  KANGXI RADICAL SCRIPT
        0x95FB, # G+3796  U+95FB  uni95FB,  CJK UNIFIED IDEOGRAPH-95FB
        0x7EB9, # G+3797  U+7EB9  uni7EB9,  CJK UNIFIED IDEOGRAPH-7EB9
        0x543B, # G+3798  U+543B  uni543B,  CJK UNIFIED IDEOGRAPH-543B
        0x7A33, # G+3799  U+7A33  uni7A33,  CJK UNIFIED IDEOGRAPH-7A33
        0x7D0A, # G+3800  U+7D0A  uni7D0A,  CJK UNIFIED IDEOGRAPH-7D0A
        0x95EE, # G+3801  U+95EE  uni95EE,  CJK UNIFIED IDEOGRAPH-95EE
        0x55E1, # G+3802  U+55E1  uni55E1,  CJK UNIFIED IDEOGRAPH-55E1
        0x7FC1, # G+3803  U+7FC1  uni7FC1,  CJK UNIFIED IDEOGRAPH-7FC1
        0x74EE, # G+3804  U+74EE  uni74EE,  CJK UNIFIED IDEOGRAPH-74EE
        0x631D, # G+3805  U+631D  uni631D,  CJK UNIFIED IDEOGRAPH-631D
        0x8717, # G+3806  U+8717  uni8717,  CJK UNIFIED IDEOGRAPH-8717
        0x6DA1, # G+3807  U+6DA1  uni6DA1,  CJK UNIFIED IDEOGRAPH-6DA1
        0x7A9D, # G+3808  U+7A9D  uni7A9D,  CJK UNIFIED IDEOGRAPH-7A9D
        0x6211, # G+3809  U+6211  uni6211,  CJK UNIFIED IDEOGRAPH-6211
        0x65A1, # G+3810  U+65A1  uni65A1,  CJK UNIFIED IDEOGRAPH-65A1
        0x5367, # G+3811  U+5367  uni5367,  CJK UNIFIED IDEOGRAPH-5367
        0x63E1, # G+3812  U+63E1  uni63E1,  CJK UNIFIED IDEOGRAPH-63E1
        0x6C83, # G+3813  U+6C83  uni6C83,  CJK UNIFIED IDEOGRAPH-6C83
        0x5DEB, # G+3814  U+5DEB  uni5DEB,  CJK UNIFIED IDEOGRAPH-5DEB
        0x545C, # G+3815  U+545C  uni545C,  CJK UNIFIED IDEOGRAPH-545C
        0x94A8, # G+3816  U+94A8  uni94A8,  CJK UNIFIED IDEOGRAPH-94A8
        0x4E4C, # G+3817  U+4E4C  uni4E4C,  CJK UNIFIED IDEOGRAPH-4E4C
        0x6C61, # G+3818  U+6C61  uni6C61,  CJK UNIFIED IDEOGRAPH-6C61
        0x8BEC, # G+3819  U+8BEC  uni8BEC,  CJK UNIFIED IDEOGRAPH-8BEC
        0x5C4B, # G+3820  U+5C4B  uni5C4B,  CJK UNIFIED IDEOGRAPH-5C4B
        0x2F46, # G+3821  U+2F46  uni2F46,  KANGXI RADICAL NOT
        0x829C, # G+3822  U+829C  uni829C,  CJK UNIFIED IDEOGRAPH-829C
        0x68A7, # G+3823  U+68A7  uni68A7,  CJK UNIFIED IDEOGRAPH-68A7
        0x543E, # G+3824  U+543E  uni543E,  CJK UNIFIED IDEOGRAPH-543E
        0x5434, # G+3825  U+5434  uni5434,  CJK UNIFIED IDEOGRAPH-5434
        0x2F4F, # G+3826  U+2F4F  uni2F4F,  KANGXI RADICAL DO NOT
        0x6B66, # G+3827  U+6B66  uni6B66,  CJK UNIFIED IDEOGRAPH-6B66
        0x4E94, # G+3828  U+4E94  uni4E94,  CJK UNIFIED IDEOGRAPH-4E94
        0x6342, # G+3829  U+6342  uni6342,  CJK UNIFIED IDEOGRAPH-6342
        0x5348, # G+3830  U+5348  uni5348,  CJK UNIFIED IDEOGRAPH-5348
        0x821E, # G+3831  U+821E  uni821E,  CJK UNIFIED IDEOGRAPH-821E
        0x4F0D, # G+3832  U+4F0D  uni4F0D,  CJK UNIFIED IDEOGRAPH-4F0D
        0x4FAE, # G+3833  U+4FAE  uni4FAE,  CJK UNIFIED IDEOGRAPH-4FAE
        0x575E, # G+3834  U+575E  uni575E,  CJK UNIFIED IDEOGRAPH-575E
        0x620A, # G+3835  U+620A  uni620A,  CJK UNIFIED IDEOGRAPH-620A
        0x96FE, # G+3836  U+96FE  uni96FE,  CJK UNIFIED IDEOGRAPH-96FE
        0x6664, # G+3837  U+6664  uni6664,  CJK UNIFIED IDEOGRAPH-6664
        0x7269, # G+3838  U+7269  uni7269,  CJK UNIFIED IDEOGRAPH-7269
        0x52FF, # G+3839  U+52FF  uni52FF,  CJK UNIFIED IDEOGRAPH-52FF
        0x52A1, # G+3840  U+52A1  uni52A1,  CJK UNIFIED IDEOGRAPH-52A1
        0x609F, # G+3841  U+609F  uni609F,  CJK UNIFIED IDEOGRAPH-609F
        0x8BEF, # G+3842  U+8BEF  uni8BEF,  CJK UNIFIED IDEOGRAPH-8BEF
        0x6614, # G+3843  U+6614  uni6614,  CJK UNIFIED IDEOGRAPH-6614
        0x7199, # G+3844  U+7199  uni7199,  CJK UNIFIED IDEOGRAPH-7199
        0x6790, # G+3845  U+6790  uni6790,  CJK UNIFIED IDEOGRAPH-6790
        0x897F, # G+3846  U+897F  uni897F,  CJK UNIFIED IDEOGRAPH-897F
        0x7852, # G+3847  U+7852  uni7852,  CJK UNIFIED IDEOGRAPH-7852
        0x77FD, # G+3848  U+77FD  uni77FD,  CJK UNIFIED IDEOGRAPH-77FD
        0x6670, # G+3849  U+6670  uni6670,  CJK UNIFIED IDEOGRAPH-6670
        0x563B, # G+3850  U+563B  uni563B,  CJK UNIFIED IDEOGRAPH-563B
        0x5438, # G+3851  U+5438  uni5438,  CJK UNIFIED IDEOGRAPH-5438
        0x9521, # G+3852  U+9521  uni9521,  CJK UNIFIED IDEOGRAPH-9521
        0x727A, # G+3853  U+727A  uni727A,  CJK UNIFIED IDEOGRAPH-727A
        0x7A00, # G+3854  U+7A00  uni7A00,  CJK UNIFIED IDEOGRAPH-7A00
        0x606F, # G+3855  U+606F  uni606F,  CJK UNIFIED IDEOGRAPH-606F
        0x5E0C, # G+3856  U+5E0C  uni5E0C,  CJK UNIFIED IDEOGRAPH-5E0C
        0x6089, # G+3857  U+6089  uni6089,  CJK UNIFIED IDEOGRAPH-6089
        0x819D, # G+3858  U+819D  uni819D,  CJK UNIFIED IDEOGRAPH-819D
        0x2F23, # G+3859  U+2F23  uni2F23,  KANGXI RADICAL EVENING
        0x60DC, # G+3860  U+60DC  uni60DC,  CJK UNIFIED IDEOGRAPH-60DC
        0x7184, # G+3861  U+7184  uni7184,  CJK UNIFIED IDEOGRAPH-7184
        0x70EF, # G+3862  U+70EF  uni70EF,  CJK UNIFIED IDEOGRAPH-70EF
        0x6EAA, # G+3863  U+6EAA  uni6EAA,  CJK UNIFIED IDEOGRAPH-6EAA
        0x6C50, # G+3864  U+6C50  uni6C50,  CJK UNIFIED IDEOGRAPH-6C50
        0x7280, # G+3865  U+7280  uni7280,  CJK UNIFIED IDEOGRAPH-7280
        0x6A84, # G+3866  U+6A84  uni6A84,  CJK UNIFIED IDEOGRAPH-6A84
        0x88AD, # G+3867  U+88AD  uni88AD,  CJK UNIFIED IDEOGRAPH-88AD
        0x5E2D, # G+3868  U+5E2D  uni5E2D,  CJK UNIFIED IDEOGRAPH-5E2D
        0x4E60, # G+3869  U+4E60  uni4E60,  CJK UNIFIED IDEOGRAPH-4E60
        0x5AB3, # G+3870  U+5AB3  uni5AB3,  CJK UNIFIED IDEOGRAPH-5AB3
        0x559C, # G+3871  U+559C  uni559C,  CJK UNIFIED IDEOGRAPH-559C
        0x94E3, # G+3872  U+94E3  uni94E3,  CJK UNIFIED IDEOGRAPH-94E3
        0x6D17, # G+3873  U+6D17  uni6D17,  CJK UNIFIED IDEOGRAPH-6D17
        0x7CFB, # G+3874  U+7CFB  uni7CFB,  CJK UNIFIED IDEOGRAPH-7CFB
        0x9699, # G+3875  U+9699  uni9699,  CJK UNIFIED IDEOGRAPH-9699
        0x620F, # G+3876  U+620F  uni620F,  CJK UNIFIED IDEOGRAPH-620F
        0x7EC6, # G+3877  U+7EC6  uni7EC6,  CJK UNIFIED IDEOGRAPH-7EC6
        0x778E, # G+3878  U+778E  uni778E,  CJK UNIFIED IDEOGRAPH-778E
        0x867E, # G+3879  U+867E  uni867E,  CJK UNIFIED IDEOGRAPH-867E
        0x5323, # G+3880  U+5323  uni5323,  CJK UNIFIED IDEOGRAPH-5323
        0x971E, # G+3881  U+971E  uni971E,  CJK UNIFIED IDEOGRAPH-971E
        0x8F96, # G+3882  U+8F96  uni8F96,  CJK UNIFIED IDEOGRAPH-8F96
        0x6687, # G+3883  U+6687  uni6687,  CJK UNIFIED IDEOGRAPH-6687
        0x5CE1, # G+3884  U+5CE1  uni5CE1,  CJK UNIFIED IDEOGRAPH-5CE1
        0x4FA0, # G+3885  U+4FA0  uni4FA0,  CJK UNIFIED IDEOGRAPH-4FA0
        0x72ED, # G+3886  U+72ED  uni72ED,  CJK UNIFIED IDEOGRAPH-72ED
        0x4E0B, # G+3887  U+4E0B  uni4E0B,  CJK UNIFIED IDEOGRAPH-4E0B
        0x53A6, # G+3888  U+53A6  uni53A6,  CJK UNIFIED IDEOGRAPH-53A6
        0x590F, # G+3889  U+590F  uni590F,  CJK UNIFIED IDEOGRAPH-590F
        0x5413, # G+3890  U+5413  uni5413,  CJK UNIFIED IDEOGRAPH-5413
        0x6380, # G+3891  U+6380  uni6380,  CJK UNIFIED IDEOGRAPH-6380
        0x9528, # G+3892  U+9528  uni9528,  CJK UNIFIED IDEOGRAPH-9528
        0x5148, # G+3893  U+5148  uni5148,  CJK UNIFIED IDEOGRAPH-5148
        0x4ED9, # G+3894  U+4ED9  uni4ED9,  CJK UNIFIED IDEOGRAPH-4ED9
        0x9C9C, # G+3895  U+9C9C  uni9C9C,  CJK UNIFIED IDEOGRAPH-9C9C
        0x7EA4, # G+3896  U+7EA4  uni7EA4,  CJK UNIFIED IDEOGRAPH-7EA4
        0x54B8, # G+3897  U+54B8  uni54B8,  CJK UNIFIED IDEOGRAPH-54B8
        0x8D24, # G+3898  U+8D24  uni8D24,  CJK UNIFIED IDEOGRAPH-8D24
        0x8854, # G+3899  U+8854  uni8854,  CJK UNIFIED IDEOGRAPH-8854
        0x8237, # G+3900  U+8237  uni8237,  CJK UNIFIED IDEOGRAPH-8237
        0x95F2, # G+3901  U+95F2  uni95F2,  CJK UNIFIED IDEOGRAPH-95F2
        0x6D8E, # G+3902  U+6D8E  uni6D8E,  CJK UNIFIED IDEOGRAPH-6D8E
        0x5F26, # G+3903  U+5F26  uni5F26,  CJK UNIFIED IDEOGRAPH-5F26
        0x5ACC, # G+3904  U+5ACC  uni5ACC,  CJK UNIFIED IDEOGRAPH-5ACC
        0x663E, # G+3905  U+663E  uni663E,  CJK UNIFIED IDEOGRAPH-663E
        0x9669, # G+3906  U+9669  uni9669,  CJK UNIFIED IDEOGRAPH-9669
        0x73B0, # G+3907  U+73B0  uni73B0,  CJK UNIFIED IDEOGRAPH-73B0
        0x732E, # G+3908  U+732E  uni732E,  CJK UNIFIED IDEOGRAPH-732E
        0x53BF, # G+3909  U+53BF  uni53BF,  CJK UNIFIED IDEOGRAPH-53BF
        0x817A, # G+3910  U+817A  uni817A,  CJK UNIFIED IDEOGRAPH-817A
        0x9985, # G+3911  U+9985  uni9985,  CJK UNIFIED IDEOGRAPH-9985
        0x7FA1, # G+3912  U+7FA1  uni7FA1,  CJK UNIFIED IDEOGRAPH-7FA1
        0x5BAA, # G+3913  U+5BAA  uni5BAA,  CJK UNIFIED IDEOGRAPH-5BAA
        0x9677, # G+3914  U+9677  uni9677,  CJK UNIFIED IDEOGRAPH-9677
        0x9650, # G+3915  U+9650  uni9650,  CJK UNIFIED IDEOGRAPH-9650
        0x7EBF, # G+3916  U+7EBF  uni7EBF,  CJK UNIFIED IDEOGRAPH-7EBF
        0x76F8, # G+3917  U+76F8  uni76F8,  CJK UNIFIED IDEOGRAPH-76F8
        0x53A2, # G+3918  U+53A2  uni53A2,  CJK UNIFIED IDEOGRAPH-53A2
        0x9576, # G+3919  U+9576  uni9576,  CJK UNIFIED IDEOGRAPH-9576
        0x2FB9, # G+3920  U+2FB9  uni2FB9,  KANGXI RADICAL FRAGRANT
        0x7BB1, # G+3921  U+7BB1  uni7BB1,  CJK UNIFIED IDEOGRAPH-7BB1
        0x8944, # G+3922  U+8944  uni8944,  CJK UNIFIED IDEOGRAPH-8944
        0x6E58, # G+3923  U+6E58  uni6E58,  CJK UNIFIED IDEOGRAPH-6E58
        0x4E61, # G+3924  U+4E61  uni4E61,  CJK UNIFIED IDEOGRAPH-4E61
        0x7FD4, # G+3925  U+7FD4  uni7FD4,  CJK UNIFIED IDEOGRAPH-7FD4
        0x7965, # G+3926  U+7965  uni7965,  CJK UNIFIED IDEOGRAPH-7965
        0x8BE6, # G+3927  U+8BE6  uni8BE6,  CJK UNIFIED IDEOGRAPH-8BE6
        0x60F3, # G+3928  U+60F3  uni60F3,  CJK UNIFIED IDEOGRAPH-60F3
        0x54CD, # G+3929  U+54CD  uni54CD,  CJK UNIFIED IDEOGRAPH-54CD
        0x4EAB, # G+3930  U+4EAB  uni4EAB,  CJK UNIFIED IDEOGRAPH-4EAB
        0x9879, # G+3931  U+9879  uni9879,  CJK UNIFIED IDEOGRAPH-9879
        0x5DF7, # G+3932  U+5DF7  uni5DF7,  CJK UNIFIED IDEOGRAPH-5DF7
        0x6A61, # G+3933  U+6A61  uni6A61,  CJK UNIFIED IDEOGRAPH-6A61
        0x50CF, # G+3934  U+50CF  uni50CF,  CJK UNIFIED IDEOGRAPH-50CF
        0x5411, # G+3935  U+5411  uni5411,  CJK UNIFIED IDEOGRAPH-5411
        0x8C61, # G+3936  U+8C61  uni8C61,  CJK UNIFIED IDEOGRAPH-8C61
        0x8427, # G+3937  U+8427  uni8427,  CJK UNIFIED IDEOGRAPH-8427
        0x785D, # G+3938  U+785D  uni785D,  CJK UNIFIED IDEOGRAPH-785D
        0x9704, # G+3939  U+9704  uni9704,  CJK UNIFIED IDEOGRAPH-9704
        0x524A, # G+3940  U+524A  uni524A,  CJK UNIFIED IDEOGRAPH-524A
        0x54EE, # G+3941  U+54EE  uni54EE,  CJK UNIFIED IDEOGRAPH-54EE
        0x56A3, # G+3942  U+56A3  uni56A3,  CJK UNIFIED IDEOGRAPH-56A3
        0x9500, # G+3943  U+9500  uni9500,  CJK UNIFIED IDEOGRAPH-9500
        0x6D88, # G+3944  U+6D88  uni6D88,  CJK UNIFIED IDEOGRAPH-6D88
        0x5BB5, # G+3945  U+5BB5  uni5BB5,  CJK UNIFIED IDEOGRAPH-5BB5
        0x6DC6, # G+3946  U+6DC6  uni6DC6,  CJK UNIFIED IDEOGRAPH-6DC6
        0x6653, # G+3947  U+6653  uni6653,  CJK UNIFIED IDEOGRAPH-6653
        0x2F29, # G+3948  U+2F29  uni2F29,  KANGXI RADICAL SMALL
        0x5B5D, # G+3949  U+5B5D  uni5B5D,  CJK UNIFIED IDEOGRAPH-5B5D
        0x6821, # G+3950  U+6821  uni6821,  CJK UNIFIED IDEOGRAPH-6821
        0x8096, # G+3951  U+8096  uni8096,  CJK UNIFIED IDEOGRAPH-8096
        0x5578, # G+3952  U+5578  uni5578,  CJK UNIFIED IDEOGRAPH-5578
        0x7B11, # G+3953  U+7B11  uni7B11,  CJK UNIFIED IDEOGRAPH-7B11
        0x6548, # G+3954  U+6548  uni6548,  CJK UNIFIED IDEOGRAPH-6548
        0x6954, # G+3955  U+6954  uni6954,  CJK UNIFIED IDEOGRAPH-6954
        0x4E9B, # G+3956  U+4E9B  uni4E9B,  CJK UNIFIED IDEOGRAPH-4E9B
        0x6B47, # G+3957  U+6B47  uni6B47,  CJK UNIFIED IDEOGRAPH-6B47
        0x874E, # G+3958  U+874E  uni874E,  CJK UNIFIED IDEOGRAPH-874E
        0x978B, # G+3959  U+978B  uni978B,  CJK UNIFIED IDEOGRAPH-978B
        0x534F, # G+3960  U+534F  uni534F,  CJK UNIFIED IDEOGRAPH-534F
        0x631F, # G+3961  U+631F  uni631F,  CJK UNIFIED IDEOGRAPH-631F
        0x643A, # G+3962  U+643A  uni643A,  CJK UNIFIED IDEOGRAPH-643A
        0x90AA, # G+3963  U+90AA  uni90AA,  CJK UNIFIED IDEOGRAPH-90AA
        0x659C, # G+3964  U+659C  uni659C,  CJK UNIFIED IDEOGRAPH-659C
        0x80C1, # G+3965  U+80C1  uni80C1,  CJK UNIFIED IDEOGRAPH-80C1
        0x8C10, # G+3966  U+8C10  uni8C10,  CJK UNIFIED IDEOGRAPH-8C10
        0x5199, # G+3967  U+5199  uni5199,  CJK UNIFIED IDEOGRAPH-5199
        0x68B0, # G+3968  U+68B0  uni68B0,  CJK UNIFIED IDEOGRAPH-68B0
        0x5378, # G+3969  U+5378  uni5378,  CJK UNIFIED IDEOGRAPH-5378
        0x87F9, # G+3970  U+87F9  uni87F9,  CJK UNIFIED IDEOGRAPH-87F9
        0x61C8, # G+3971  U+61C8  uni61C8,  CJK UNIFIED IDEOGRAPH-61C8
        0x6CC4, # G+3972  U+6CC4  uni6CC4,  CJK UNIFIED IDEOGRAPH-6CC4
        0x6CFB, # G+3973  U+6CFB  uni6CFB,  CJK UNIFIED IDEOGRAPH-6CFB
        0x8C22, # G+3974  U+8C22  uni8C22,  CJK UNIFIED IDEOGRAPH-8C22
        0x5C51, # G+3975  U+5C51  uni5C51,  CJK UNIFIED IDEOGRAPH-5C51
        0x85AA, # G+3976  U+85AA  uni85AA,  CJK UNIFIED IDEOGRAPH-85AA
        0x82AF, # G+3977  U+82AF  uni82AF,  CJK UNIFIED IDEOGRAPH-82AF
        0x950C, # G+3978  U+950C  uni950C,  CJK UNIFIED IDEOGRAPH-950C
        0x6B23, # G+3979  U+6B23  uni6B23,  CJK UNIFIED IDEOGRAPH-6B23
        0x2F9F, # G+3980  U+2F9F  uni2F9F,  KANGXI RADICAL BITTER
        0x65B0, # G+3981  U+65B0  uni65B0,  CJK UNIFIED IDEOGRAPH-65B0
        0x5FFB, # G+3982  U+5FFB  uni5FFB,  CJK UNIFIED IDEOGRAPH-5FFB
        0x2F3C, # G+3983  U+2F3C  uni2F3C,  KANGXI RADICAL HEART
        0x4FE1, # G+3984  U+4FE1  uni4FE1,  CJK UNIFIED IDEOGRAPH-4FE1
        0x8845, # G+3985  U+8845  uni8845,  CJK UNIFIED IDEOGRAPH-8845
        0x661F, # G+3986  U+661F  uni661F,  CJK UNIFIED IDEOGRAPH-661F
        0x8165, # G+3987  U+8165  uni8165,  CJK UNIFIED IDEOGRAPH-8165
        0x7329, # G+3988  U+7329  uni7329,  CJK UNIFIED IDEOGRAPH-7329
        0x60FA, # G+3989  U+60FA  uni60FA,  CJK UNIFIED IDEOGRAPH-60FA
        0x5174, # G+3990  U+5174  uni5174,  CJK UNIFIED IDEOGRAPH-5174
        0x5211, # G+3991  U+5211  uni5211,  CJK UNIFIED IDEOGRAPH-5211
        0x578B, # G+3992  U+578B  uni578B,  CJK UNIFIED IDEOGRAPH-578B
        0x5F62, # G+3993  U+5F62  uni5F62,  CJK UNIFIED IDEOGRAPH-5F62
        0x90A2, # G+3994  U+90A2  uni90A2,  CJK UNIFIED IDEOGRAPH-90A2
        0x2F8F, # G+3995  U+2F8F  uni2F8F,  KANGXI RADICAL WALK ENCLOSURE
        0x9192, # G+3996  U+9192  uni9192,  CJK UNIFIED IDEOGRAPH-9192
        0x5E78, # G+3997  U+5E78  uni5E78,  CJK UNIFIED IDEOGRAPH-5E78
        0x674F, # G+3998  U+674F  uni674F,  CJK UNIFIED IDEOGRAPH-674F
        0x6027, # G+3999  U+6027  uni6027,  CJK UNIFIED IDEOGRAPH-6027
        0x59D3, # G+4000  U+59D3  uni59D3,  CJK UNIFIED IDEOGRAPH-59D3
        0x5144, # G+4001  U+5144  uni5144,  CJK UNIFIED IDEOGRAPH-5144
        0x51F6, # G+4002  U+51F6  uni51F6,  CJK UNIFIED IDEOGRAPH-51F6
        0x80F8, # G+4003  U+80F8  uni80F8,  CJK UNIFIED IDEOGRAPH-80F8
        0x5308, # G+4004  U+5308  uni5308,  CJK UNIFIED IDEOGRAPH-5308
        0x6C79, # G+4005  U+6C79  uni6C79,  CJK UNIFIED IDEOGRAPH-6C79
        0x96C4, # G+4006  U+96C4  uni96C4,  CJK UNIFIED IDEOGRAPH-96C4
        0x718A, # G+4007  U+718A  uni718A,  CJK UNIFIED IDEOGRAPH-718A
        0x4F11, # G+4008  U+4F11  uni4F11,  CJK UNIFIED IDEOGRAPH-4F11
        0x4FEE, # G+4009  U+4FEE  uni4FEE,  CJK UNIFIED IDEOGRAPH-4FEE
        0x7F9E, # G+4010  U+7F9E  uni7F9E,  CJK UNIFIED IDEOGRAPH-7F9E
        0x673D, # G+4011  U+673D  uni673D,  CJK UNIFIED IDEOGRAPH-673D
        0x55C5, # G+4012  U+55C5  uni55C5,  CJK UNIFIED IDEOGRAPH-55C5
        0x9508, # G+4013  U+9508  uni9508,  CJK UNIFIED IDEOGRAPH-9508
        0x79C0, # G+4014  U+79C0  uni79C0,  CJK UNIFIED IDEOGRAPH-79C0
        0x8896, # G+4015  U+8896  uni8896,  CJK UNIFIED IDEOGRAPH-8896
        0x7EE3, # G+4016  U+7EE3  uni7EE3,  CJK UNIFIED IDEOGRAPH-7EE3
        0x589F, # G+4017  U+589F  uni589F,  CJK UNIFIED IDEOGRAPH-589F
        0x620C, # G+4018  U+620C  uni620C,  CJK UNIFIED IDEOGRAPH-620C
        0x9700, # G+4019  U+9700  uni9700,  CJK UNIFIED IDEOGRAPH-9700
        0x865A, # G+4020  U+865A  uni865A,  CJK UNIFIED IDEOGRAPH-865A
        0x5618, # G+4021  U+5618  uni5618,  CJK UNIFIED IDEOGRAPH-5618
        0x987B, # G+4022  U+987B  uni987B,  CJK UNIFIED IDEOGRAPH-987B
        0x5F90, # G+4023  U+5F90  uni5F90,  CJK UNIFIED IDEOGRAPH-5F90
        0x8BB8, # G+4024  U+8BB8  uni8BB8,  CJK UNIFIED IDEOGRAPH-8BB8
        0x84C4, # G+4025  U+84C4  uni84C4,  CJK UNIFIED IDEOGRAPH-84C4
        0x9157, # G+4026  U+9157  uni9157,  CJK UNIFIED IDEOGRAPH-9157
        0x53D9, # G+4027  U+53D9  uni53D9,  CJK UNIFIED IDEOGRAPH-53D9
        0x65ED, # G+4028  U+65ED  uni65ED,  CJK UNIFIED IDEOGRAPH-65ED
        0x5E8F, # G+4029  U+5E8F  uni5E8F,  CJK UNIFIED IDEOGRAPH-5E8F
        0x755C, # G+4030  U+755C  uni755C,  CJK UNIFIED IDEOGRAPH-755C
        0x6064, # G+4031  U+6064  uni6064,  CJK UNIFIED IDEOGRAPH-6064
        0x7D6E, # G+4032  U+7D6E  uni7D6E,  CJK UNIFIED IDEOGRAPH-7D6E
        0x5A7F, # G+4033  U+5A7F  uni5A7F,  CJK UNIFIED IDEOGRAPH-5A7F
        0x7EEA, # G+4034  U+7EEA  uni7EEA,  CJK UNIFIED IDEOGRAPH-7EEA
        0x7EED, # G+4035  U+7EED  uni7EED,  CJK UNIFIED IDEOGRAPH-7EED
        0x8F69, # G+4036  U+8F69  uni8F69,  CJK UNIFIED IDEOGRAPH-8F69
        0x55A7, # G+4037  U+55A7  uni55A7,  CJK UNIFIED IDEOGRAPH-55A7
        0x5BA3, # G+4038  U+5BA3  uni5BA3,  CJK UNIFIED IDEOGRAPH-5BA3
        0x60AC, # G+4039  U+60AC  uni60AC,  CJK UNIFIED IDEOGRAPH-60AC
        0x65CB, # G+4040  U+65CB  uni65CB,  CJK UNIFIED IDEOGRAPH-65CB
        0x2F5E, # G+4041  U+2F5E  uni2F5E,  KANGXI RADICAL PROFOUND
        0x9009, # G+4042  U+9009  uni9009,  CJK UNIFIED IDEOGRAPH-9009
        0x7663, # G+4043  U+7663  uni7663,  CJK UNIFIED IDEOGRAPH-7663
        0x7729, # G+4044  U+7729  uni7729,  CJK UNIFIED IDEOGRAPH-7729
        0x7EDA, # G+4045  U+7EDA  uni7EDA,  CJK UNIFIED IDEOGRAPH-7EDA
        0x9774, # G+4046  U+9774  uni9774,  CJK UNIFIED IDEOGRAPH-9774
        0x859B, # G+4047  U+859B  uni859B,  CJK UNIFIED IDEOGRAPH-859B
        0x5B66, # G+4048  U+5B66  uni5B66,  CJK UNIFIED IDEOGRAPH-5B66
        0x2F73, # G+4049  U+2F73  uni2F73,  KANGXI RADICAL CAVE
        0x96EA, # G+4050  U+96EA  uni96EA,  CJK UNIFIED IDEOGRAPH-96EA
        0x2F8E, # G+4051  U+2F8E  uni2F8E,  KANGXI RADICAL BLOOD
        0x52CB, # G+4052  U+52CB  uni52CB,  CJK UNIFIED IDEOGRAPH-52CB
        0x718F, # G+4053  U+718F  uni718F,  CJK UNIFIED IDEOGRAPH-718F
        0x5FAA, # G+4054  U+5FAA  uni5FAA,  CJK UNIFIED IDEOGRAPH-5FAA
        0x65EC, # G+4055  U+65EC  uni65EC,  CJK UNIFIED IDEOGRAPH-65EC
        0x8BE2, # G+4056  U+8BE2  uni8BE2,  CJK UNIFIED IDEOGRAPH-8BE2
        0x5BFB, # G+4057  U+5BFB  uni5BFB,  CJK UNIFIED IDEOGRAPH-5BFB
        0x9A6F, # G+4058  U+9A6F  uni9A6F,  CJK UNIFIED IDEOGRAPH-9A6F
        0x5DE1, # G+4059  U+5DE1  uni5DE1,  CJK UNIFIED IDEOGRAPH-5DE1
        0x6B89, # G+4060  U+6B89  uni6B89,  CJK UNIFIED IDEOGRAPH-6B89
        0x6C5B, # G+4061  U+6C5B  uni6C5B,  CJK UNIFIED IDEOGRAPH-6C5B
        0x8BAD, # G+4062  U+8BAD  uni8BAD,  CJK UNIFIED IDEOGRAPH-8BAD
        0x8BAF, # G+4063  U+8BAF  uni8BAF,  CJK UNIFIED IDEOGRAPH-8BAF
        0x900A, # G+4064  U+900A  uni900A,  CJK UNIFIED IDEOGRAPH-900A
        0x8FC5, # G+4065  U+8FC5  uni8FC5,  CJK UNIFIED IDEOGRAPH-8FC5
        0x538B, # G+4066  U+538B  uni538B,  CJK UNIFIED IDEOGRAPH-538B
        0x62BC, # G+4067  U+62BC  uni62BC,  CJK UNIFIED IDEOGRAPH-62BC
        0x9E26, # G+4068  U+9E26  uni9E26,  CJK UNIFIED IDEOGRAPH-9E26
        0x9E2D, # G+4069  U+9E2D  uni9E2D,  CJK UNIFIED IDEOGRAPH-9E2D
        0x5440, # G+4070  U+5440  uni5440,  CJK UNIFIED IDEOGRAPH-5440
        0x4E2B, # G+4071  U+4E2B  uni4E2B,  CJK UNIFIED IDEOGRAPH-4E2B
        0x82BD, # G+4072  U+82BD  uni82BD,  CJK UNIFIED IDEOGRAPH-82BD
        0x2F5B, # G+4073  U+2F5B  uni2F5B,  KANGXI RADICAL FANG
        0x869C, # G+4074  U+869C  uni869C,  CJK UNIFIED IDEOGRAPH-869C
        0x5D16, # G+4075  U+5D16  uni5D16,  CJK UNIFIED IDEOGRAPH-5D16
        0x8859, # G+4076  U+8859  uni8859,  CJK UNIFIED IDEOGRAPH-8859
        0x6DAF, # G+4077  U+6DAF  uni6DAF,  CJK UNIFIED IDEOGRAPH-6DAF
        0x96C5, # G+4078  U+96C5  uni96C5,  CJK UNIFIED IDEOGRAPH-96C5
        0x54D1, # G+4079  U+54D1  uni54D1,  CJK UNIFIED IDEOGRAPH-54D1
        0x4E9A, # G+4080  U+4E9A  uni4E9A,  CJK UNIFIED IDEOGRAPH-4E9A
        0x8BB6, # G+4081  U+8BB6  uni8BB6,  CJK UNIFIED IDEOGRAPH-8BB6
        0x7109, # G+4082  U+7109  uni7109,  CJK UNIFIED IDEOGRAPH-7109
        0x54BD, # G+4083  U+54BD  uni54BD,  CJK UNIFIED IDEOGRAPH-54BD
        0x9609, # G+4084  U+9609  uni9609,  CJK UNIFIED IDEOGRAPH-9609
        0x70DF, # G+4085  U+70DF  uni70DF,  CJK UNIFIED IDEOGRAPH-70DF
        0x6DF9, # G+4086  U+6DF9  uni6DF9,  CJK UNIFIED IDEOGRAPH-6DF9
        0x76D0, # G+4087  U+76D0  uni76D0,  CJK UNIFIED IDEOGRAPH-76D0
        0x4E25, # G+4088  U+4E25  uni4E25,  CJK UNIFIED IDEOGRAPH-4E25
        0x7814, # G+4089  U+7814  uni7814,  CJK UNIFIED IDEOGRAPH-7814
        0x8712, # G+4090  U+8712  uni8712,  CJK UNIFIED IDEOGRAPH-8712
        0x5CA9, # G+4091  U+5CA9  uni5CA9,  CJK UNIFIED IDEOGRAPH-5CA9
        0x5EF6, # G+4092  U+5EF6  uni5EF6,  CJK UNIFIED IDEOGRAPH-5EF6
        0x2F94, # G+4093  U+2F94  uni2F94,  KANGXI RADICAL SPEECH
        0x989C, # G+4094  U+989C  uni989C,  CJK UNIFIED IDEOGRAPH-989C
        0x960E, # G+4095  U+960E  uni960E,  CJK UNIFIED IDEOGRAPH-960E
        0x708E, # G+4096  U+708E  uni708E,  CJK UNIFIED IDEOGRAPH-708E
        0x6CBF, # G+4097  U+6CBF  uni6CBF,  CJK UNIFIED IDEOGRAPH-6CBF
        0x5944, # G+4098  U+5944  uni5944,  CJK UNIFIED IDEOGRAPH-5944
        0x63A9, # G+4099  U+63A9  uni63A9,  CJK UNIFIED IDEOGRAPH-63A9
        0x773C, # G+4100  U+773C  uni773C,  CJK UNIFIED IDEOGRAPH-773C
        0x884D, # G+4101  U+884D  uni884D,  CJK UNIFIED IDEOGRAPH-884D
        0x6F14, # G+4102  U+6F14  uni6F14,  CJK UNIFIED IDEOGRAPH-6F14
        0x8273, # G+4103  U+8273  uni8273,  CJK UNIFIED IDEOGRAPH-8273
        0x5830, # G+4104  U+5830  uni5830,  CJK UNIFIED IDEOGRAPH-5830
        0x71D5, # G+4105  U+71D5  uni71D5,  CJK UNIFIED IDEOGRAPH-71D5
        0x538C, # G+4106  U+538C  uni538C,  CJK UNIFIED IDEOGRAPH-538C
        0x781A, # G+4107  U+781A  uni781A,  CJK UNIFIED IDEOGRAPH-781A
        0x96C1, # G+4108  U+96C1  uni96C1,  CJK UNIFIED IDEOGRAPH-96C1
        0x5501, # G+4109  U+5501  uni5501,  CJK UNIFIED IDEOGRAPH-5501
        0x5F66, # G+4110  U+5F66  uni5F66,  CJK UNIFIED IDEOGRAPH-5F66
        0x7130, # G+4111  U+7130  uni7130,  CJK UNIFIED IDEOGRAPH-7130
        0x5BB4, # G+4112  U+5BB4  uni5BB4,  CJK UNIFIED IDEOGRAPH-5BB4
        0x8C1A, # G+4113  U+8C1A  uni8C1A,  CJK UNIFIED IDEOGRAPH-8C1A
        0x9A8C, # G+4114  U+9A8C  uni9A8C,  CJK UNIFIED IDEOGRAPH-9A8C
        0x6B83, # G+4115  U+6B83  uni6B83,  CJK UNIFIED IDEOGRAPH-6B83
        0x592E, # G+4116  U+592E  uni592E,  CJK UNIFIED IDEOGRAPH-592E
        0x9E2F, # G+4117  U+9E2F  uni9E2F,  CJK UNIFIED IDEOGRAPH-9E2F
        0x79E7, # G+4118  U+79E7  uni79E7,  CJK UNIFIED IDEOGRAPH-79E7
        0x6768, # G+4119  U+6768  uni6768,  CJK UNIFIED IDEOGRAPH-6768
        0x626C, # G+4120  U+626C  uni626C,  CJK UNIFIED IDEOGRAPH-626C
        0x4F6F, # G+4121  U+4F6F  uni4F6F,  CJK UNIFIED IDEOGRAPH-4F6F
        0x75A1, # G+4122  U+75A1  uni75A1,  CJK UNIFIED IDEOGRAPH-75A1
        0x2F7A, # G+4123  U+2F7A  uni2F7A,  KANGXI RADICAL SHEEP
        0x6D0B, # G+4124  U+6D0B  uni6D0B,  CJK UNIFIED IDEOGRAPH-6D0B
        0x9633, # G+4125  U+9633  uni9633,  CJK UNIFIED IDEOGRAPH-9633
        0x6C27, # G+4126  U+6C27  uni6C27,  CJK UNIFIED IDEOGRAPH-6C27
        0x4EF0, # G+4127  U+4EF0  uni4EF0,  CJK UNIFIED IDEOGRAPH-4EF0
        0x75D2, # G+4128  U+75D2  uni75D2,  CJK UNIFIED IDEOGRAPH-75D2
        0x517B, # G+4129  U+517B  uni517B,  CJK UNIFIED IDEOGRAPH-517B
        0x6837, # G+4130  U+6837  uni6837,  CJK UNIFIED IDEOGRAPH-6837
        0x6F3E, # G+4131  U+6F3E  uni6F3E,  CJK UNIFIED IDEOGRAPH-6F3E
        0x9080, # G+4132  U+9080  uni9080,  CJK UNIFIED IDEOGRAPH-9080
        0x8170, # G+4133  U+8170  uni8170,  CJK UNIFIED IDEOGRAPH-8170
        0x5996, # G+4134  U+5996  uni5996,  CJK UNIFIED IDEOGRAPH-5996
        0x7476, # G+4135  U+7476  uni7476,  CJK UNIFIED IDEOGRAPH-7476
        0x6447, # G+4136  U+6447  uni6447,  CJK UNIFIED IDEOGRAPH-6447
        0x5C27, # G+4137  U+5C27  uni5C27,  CJK UNIFIED IDEOGRAPH-5C27
        0x9065, # G+4138  U+9065  uni9065,  CJK UNIFIED IDEOGRAPH-9065
        0x7A91, # G+4139  U+7A91  uni7A91,  CJK UNIFIED IDEOGRAPH-7A91
        0x8C23, # G+4140  U+8C23  uni8C23,  CJK UNIFIED IDEOGRAPH-8C23
        0x59DA, # G+4141  U+59DA  uni59DA,  CJK UNIFIED IDEOGRAPH-59DA
        0x54AC, # G+4142  U+54AC  uni54AC,  CJK UNIFIED IDEOGRAPH-54AC
        0x8200, # G+4143  U+8200  uni8200,  CJK UNIFIED IDEOGRAPH-8200
        0x836F, # G+4144  U+836F  uni836F,  CJK UNIFIED IDEOGRAPH-836F
        0x8981, # G+4145  U+8981  uni8981,  CJK UNIFIED IDEOGRAPH-8981
        0x8000, # G+4146  U+8000  uni8000,  CJK UNIFIED IDEOGRAPH-8000
        0x6930, # G+4147  U+6930  uni6930,  CJK UNIFIED IDEOGRAPH-6930
        0x564E, # G+4148  U+564E  uni564E,  CJK UNIFIED IDEOGRAPH-564E
        0x8036, # G+4149  U+8036  uni8036,  CJK UNIFIED IDEOGRAPH-8036
        0x7237, # G+4150  U+7237  uni7237,  CJK UNIFIED IDEOGRAPH-7237
        0x91CE, # G+4151  U+91CE  uni91CE,  CJK UNIFIED IDEOGRAPH-91CE
        0x51B6, # G+4152  U+51B6  uni51B6,  CJK UNIFIED IDEOGRAPH-51B6
        0x4E5F, # G+4153  U+4E5F  uni4E5F,  CJK UNIFIED IDEOGRAPH-4E5F
        0x9875, # G+4154  U+9875  uni9875,  CJK UNIFIED IDEOGRAPH-9875
        0x6396, # G+4155  U+6396  uni6396,  CJK UNIFIED IDEOGRAPH-6396
        0x4E1A, # G+4156  U+4E1A  uni4E1A,  CJK UNIFIED IDEOGRAPH-4E1A
        0x53F6, # G+4157  U+53F6  uni53F6,  CJK UNIFIED IDEOGRAPH-53F6
        0x66F3, # G+4158  U+66F3  uni66F3,  CJK UNIFIED IDEOGRAPH-66F3
        0x814B, # G+4159  U+814B  uni814B,  CJK UNIFIED IDEOGRAPH-814B
        0x591C, # G+4160  U+591C  uni591C,  CJK UNIFIED IDEOGRAPH-591C
        0x6DB2, # G+4161  U+6DB2  uni6DB2,  CJK UNIFIED IDEOGRAPH-6DB2
        0x2F00, # G+4162  U+2F00  uni2F00,  KANGXI RADICAL ONE
        0x58F9, # G+4163  U+58F9  uni58F9,  CJK UNIFIED IDEOGRAPH-58F9
        0x533B, # G+4164  U+533B  uni533B,  CJK UNIFIED IDEOGRAPH-533B
        0x63D6, # G+4165  U+63D6  uni63D6,  CJK UNIFIED IDEOGRAPH-63D6
        0x94F1, # G+4166  U+94F1  uni94F1,  CJK UNIFIED IDEOGRAPH-94F1
        0x4F9D, # G+4167  U+4F9D  uni4F9D,  CJK UNIFIED IDEOGRAPH-4F9D
        0x4F0A, # G+4168  U+4F0A  uni4F0A,  CJK UNIFIED IDEOGRAPH-4F0A
        0x2F90, # G+4169  U+2F90  uni2F90,  KANGXI RADICAL CLOTHES
        0x9890, # G+4170  U+9890  uni9890,  CJK UNIFIED IDEOGRAPH-9890
        0x5937, # G+4171  U+5937  uni5937,  CJK UNIFIED IDEOGRAPH-5937
        0x9057, # G+4172  U+9057  uni9057,  CJK UNIFIED IDEOGRAPH-9057
        0x79FB, # G+4173  U+79FB  uni79FB,  CJK UNIFIED IDEOGRAPH-79FB
        0x4EEA, # G+4174  U+4EEA  uni4EEA,  CJK UNIFIED IDEOGRAPH-4EEA
        0x80F0, # G+4175  U+80F0  uni80F0,  CJK UNIFIED IDEOGRAPH-80F0
        0x7591, # G+4176  U+7591  uni7591,  CJK UNIFIED IDEOGRAPH-7591
        0x6C82, # G+4177  U+6C82  uni6C82,  CJK UNIFIED IDEOGRAPH-6C82
        0x5B9C, # G+4178  U+5B9C  uni5B9C,  CJK UNIFIED IDEOGRAPH-5B9C
        0x59E8, # G+4179  U+59E8  uni59E8,  CJK UNIFIED IDEOGRAPH-59E8
        0x5F5D, # G+4180  U+5F5D  uni5F5D,  CJK UNIFIED IDEOGRAPH-5F5D
        0x6905, # G+4181  U+6905  uni6905,  CJK UNIFIED IDEOGRAPH-6905
        0x8681, # G+4182  U+8681  uni8681,  CJK UNIFIED IDEOGRAPH-8681
        0x501A, # G+4183  U+501A  uni501A,  CJK UNIFIED IDEOGRAPH-501A
        0x5DF2, # G+4184  U+5DF2  uni5DF2,  CJK UNIFIED IDEOGRAPH-5DF2
        0x2F04, # G+4185  U+2F04  uni2F04,  KANGXI RADICAL SECOND
        0x77E3, # G+4186  U+77E3  uni77E3,  CJK UNIFIED IDEOGRAPH-77E3
        0x4EE5, # G+4187  U+4EE5  uni4EE5,  CJK UNIFIED IDEOGRAPH-4EE5
        0x827A, # G+4188  U+827A  uni827A,  CJK UNIFIED IDEOGRAPH-827A
        0x6291, # G+4189  U+6291  uni6291,  CJK UNIFIED IDEOGRAPH-6291
        0x6613, # G+4190  U+6613  uni6613,  CJK UNIFIED IDEOGRAPH-6613
        0x2FA2, # G+4191  U+2FA2  uni2FA2,  KANGXI RADICAL CITY
        0x5C79, # G+4192  U+5C79  uni5C79,  CJK UNIFIED IDEOGRAPH-5C79
        0x4EBF, # G+4193  U+4EBF  uni4EBF,  CJK UNIFIED IDEOGRAPH-4EBF
        0x5F79, # G+4194  U+5F79  uni5F79,  CJK UNIFIED IDEOGRAPH-5F79
        0x81C6, # G+4195  U+81C6  uni81C6,  CJK UNIFIED IDEOGRAPH-81C6
        0x9038, # G+4196  U+9038  uni9038,  CJK UNIFIED IDEOGRAPH-9038
        0x8084, # G+4197  U+8084  uni8084,  CJK UNIFIED IDEOGRAPH-8084
        0x75AB, # G+4198  U+75AB  uni75AB,  CJK UNIFIED IDEOGRAPH-75AB
        0x4EA6, # G+4199  U+4EA6  uni4EA6,  CJK UNIFIED IDEOGRAPH-4EA6
        0x88D4, # G+4200  U+88D4  uni88D4,  CJK UNIFIED IDEOGRAPH-88D4
        0x610F, # G+4201  U+610F  uni610F,  CJK UNIFIED IDEOGRAPH-610F
        0x6BC5, # G+4202  U+6BC5  uni6BC5,  CJK UNIFIED IDEOGRAPH-6BC5
        0x5FC6, # G+4203  U+5FC6  uni5FC6,  CJK UNIFIED IDEOGRAPH-5FC6
        0x4E49, # G+4204  U+4E49  uni4E49,  CJK UNIFIED IDEOGRAPH-4E49
        0x76CA, # G+4205  U+76CA  uni76CA,  CJK UNIFIED IDEOGRAPH-76CA
        0x6EA2, # G+4206  U+6EA2  uni6EA2,  CJK UNIFIED IDEOGRAPH-6EA2
        0x8BE3, # G+4207  U+8BE3  uni8BE3,  CJK UNIFIED IDEOGRAPH-8BE3
        0x8BAE, # G+4208  U+8BAE  uni8BAE,  CJK UNIFIED IDEOGRAPH-8BAE
        0x8C0A, # G+4209  U+8C0A  uni8C0A,  CJK UNIFIED IDEOGRAPH-8C0A
        0x8BD1, # G+4210  U+8BD1  uni8BD1,  CJK UNIFIED IDEOGRAPH-8BD1
        0x5F02, # G+4211  U+5F02  uni5F02,  CJK UNIFIED IDEOGRAPH-5F02
        0x7FFC, # G+4212  U+7FFC  uni7FFC,  CJK UNIFIED IDEOGRAPH-7FFC
        0x7FCC, # G+4213  U+7FCC  uni7FCC,  CJK UNIFIED IDEOGRAPH-7FCC
        0x7ECE, # G+4214  U+7ECE  uni7ECE,  CJK UNIFIED IDEOGRAPH-7ECE
        0x8335, # G+4215  U+8335  uni8335,  CJK UNIFIED IDEOGRAPH-8335
        0x836B, # G+4216  U+836B  uni836B,  CJK UNIFIED IDEOGRAPH-836B
        0x56E0, # G+4217  U+56E0  uni56E0,  CJK UNIFIED IDEOGRAPH-56E0
        0x6BB7, # G+4218  U+6BB7  uni6BB7,  CJK UNIFIED IDEOGRAPH-6BB7
        0x2FB3, # G+4219  U+2FB3  uni2FB3,  KANGXI RADICAL SOUND
        0x9634, # G+4220  U+9634  uni9634,  CJK UNIFIED IDEOGRAPH-9634
        0x59FB, # G+4221  U+59FB  uni59FB,  CJK UNIFIED IDEOGRAPH-59FB
        0x541F, # G+4222  U+541F  uni541F,  CJK UNIFIED IDEOGRAPH-541F
        0x94F6, # G+4223  U+94F6  uni94F6,  CJK UNIFIED IDEOGRAPH-94F6
        0x6DEB, # G+4224  U+6DEB  uni6DEB,  CJK UNIFIED IDEOGRAPH-6DEB
        0x5BC5, # G+4225  U+5BC5  uni5BC5,  CJK UNIFIED IDEOGRAPH-5BC5
        0x996E, # G+4226  U+996E  uni996E,  CJK UNIFIED IDEOGRAPH-996E
        0x5C39, # G+4227  U+5C39  uni5C39,  CJK UNIFIED IDEOGRAPH-5C39
        0x5F15, # G+4228  U+5F15  uni5F15,  CJK UNIFIED IDEOGRAPH-5F15
        0x9690, # G+4229  U+9690  uni9690,  CJK UNIFIED IDEOGRAPH-9690
        0x5370, # G+4230  U+5370  uni5370,  CJK UNIFIED IDEOGRAPH-5370
        0x82F1, # G+4231  U+82F1  uni82F1,  CJK UNIFIED IDEOGRAPH-82F1
        0x6A31, # G+4232  U+6A31  uni6A31,  CJK UNIFIED IDEOGRAPH-6A31
        0x5A74, # G+4233  U+5A74  uni5A74,  CJK UNIFIED IDEOGRAPH-5A74
        0x9E70, # G+4234  U+9E70  uni9E70,  CJK UNIFIED IDEOGRAPH-9E70
        0x5E94, # G+4235  U+5E94  uni5E94,  CJK UNIFIED IDEOGRAPH-5E94
        0x7F28, # G+4236  U+7F28  uni7F28,  CJK UNIFIED IDEOGRAPH-7F28
        0x83B9, # G+4237  U+83B9  uni83B9,  CJK UNIFIED IDEOGRAPH-83B9
        0x8424, # G+4238  U+8424  uni8424,  CJK UNIFIED IDEOGRAPH-8424
        0x8425, # G+4239  U+8425  uni8425,  CJK UNIFIED IDEOGRAPH-8425
        0x8367, # G+4240  U+8367  uni8367,  CJK UNIFIED IDEOGRAPH-8367
        0x8747, # G+4241  U+8747  uni8747,  CJK UNIFIED IDEOGRAPH-8747
        0x8FCE, # G+4242  U+8FCE  uni8FCE,  CJK UNIFIED IDEOGRAPH-8FCE
        0x8D62, # G+4243  U+8D62  uni8D62,  CJK UNIFIED IDEOGRAPH-8D62
        0x76C8, # G+4244  U+76C8  uni76C8,  CJK UNIFIED IDEOGRAPH-76C8
        0x5F71, # G+4245  U+5F71  uni5F71,  CJK UNIFIED IDEOGRAPH-5F71
        0x9896, # G+4246  U+9896  uni9896,  CJK UNIFIED IDEOGRAPH-9896
        0x786C, # G+4247  U+786C  uni786C,  CJK UNIFIED IDEOGRAPH-786C
        0x6620, # G+4248  U+6620  uni6620,  CJK UNIFIED IDEOGRAPH-6620
        0x54DF, # G+4249  U+54DF  uni54DF,  CJK UNIFIED IDEOGRAPH-54DF
        0x62E5, # G+4250  U+62E5  uni62E5,  CJK UNIFIED IDEOGRAPH-62E5
        0x4F63, # G+4251  U+4F63  uni4F63,  CJK UNIFIED IDEOGRAPH-4F63
        0x81C3, # G+4252  U+81C3  uni81C3,  CJK UNIFIED IDEOGRAPH-81C3
        0x75C8, # G+4253  U+75C8  uni75C8,  CJK UNIFIED IDEOGRAPH-75C8
        0x5EB8, # G+4254  U+5EB8  uni5EB8,  CJK UNIFIED IDEOGRAPH-5EB8
        0x96CD, # G+4255  U+96CD  uni96CD,  CJK UNIFIED IDEOGRAPH-96CD
        0x8E0A, # G+4256  U+8E0A  uni8E0A,  CJK UNIFIED IDEOGRAPH-8E0A
        0x86F9, # G+4257  U+86F9  uni86F9,  CJK UNIFIED IDEOGRAPH-86F9
        0x548F, # G+4258  U+548F  uni548F,  CJK UNIFIED IDEOGRAPH-548F
        0x6CF3, # G+4259  U+6CF3  uni6CF3,  CJK UNIFIED IDEOGRAPH-6CF3
        0x6D8C, # G+4260  U+6D8C  uni6D8C,  CJK UNIFIED IDEOGRAPH-6D8C
        0x6C38, # G+4261  U+6C38  uni6C38,  CJK UNIFIED IDEOGRAPH-6C38
        0x607F, # G+4262  U+607F  uni607F,  CJK UNIFIED IDEOGRAPH-607F
        0x52C7, # G+4263  U+52C7  uni52C7,  CJK UNIFIED IDEOGRAPH-52C7
        0x2F64, # G+4264  U+2F64  uni2F64,  KANGXI RADICAL USE
        0x5E7D, # G+4265  U+5E7D  uni5E7D,  CJK UNIFIED IDEOGRAPH-5E7D
        0x4F18, # G+4266  U+4F18  uni4F18,  CJK UNIFIED IDEOGRAPH-4F18
        0x60A0, # G+4267  U+60A0  uni60A0,  CJK UNIFIED IDEOGRAPH-60A0
        0x5FE7, # G+4268  U+5FE7  uni5FE7,  CJK UNIFIED IDEOGRAPH-5FE7
        0x5C24, # G+4269  U+5C24  uni5C24,  CJK UNIFIED IDEOGRAPH-5C24
        0x7531, # G+4270  U+7531  uni7531,  CJK UNIFIED IDEOGRAPH-7531
        0x90AE, # G+4271  U+90AE  uni90AE,  CJK UNIFIED IDEOGRAPH-90AE
        0x94C0, # G+4272  U+94C0  uni94C0,  CJK UNIFIED IDEOGRAPH-94C0
        0x72B9, # G+4273  U+72B9  uni72B9,  CJK UNIFIED IDEOGRAPH-72B9
        0x6CB9, # G+4274  U+6CB9  uni6CB9,  CJK UNIFIED IDEOGRAPH-6CB9
        0x6E38, # G+4275  U+6E38  uni6E38,  CJK UNIFIED IDEOGRAPH-6E38
        0x2FA3, # G+4276  U+2FA3  uni2FA3,  KANGXI RADICAL WINE
        0x6709, # G+4277  U+6709  uni6709,  CJK UNIFIED IDEOGRAPH-6709
        0x53CB, # G+4278  U+53CB  uni53CB,  CJK UNIFIED IDEOGRAPH-53CB
        0x53F3, # G+4279  U+53F3  uni53F3,  CJK UNIFIED IDEOGRAPH-53F3
        0x4F51, # G+4280  U+4F51  uni4F51,  CJK UNIFIED IDEOGRAPH-4F51
        0x91C9, # G+4281  U+91C9  uni91C9,  CJK UNIFIED IDEOGRAPH-91C9
        0x8BF1, # G+4282  U+8BF1  uni8BF1,  CJK UNIFIED IDEOGRAPH-8BF1
        0x2F1C, # G+4283  U+2F1C  uni2F1C,  KANGXI RADICAL AGAIN
        0x5E7C, # G+4284  U+5E7C  uni5E7C,  CJK UNIFIED IDEOGRAPH-5E7C
        0x8FC2, # G+4285  U+8FC2  uni8FC2,  CJK UNIFIED IDEOGRAPH-8FC2
        0x6DE4, # G+4286  U+6DE4  uni6DE4,  CJK UNIFIED IDEOGRAPH-6DE4
        0x4E8E, # G+4287  U+4E8E  uni4E8E,  CJK UNIFIED IDEOGRAPH-4E8E
        0x76C2, # G+4288  U+76C2  uni76C2,  CJK UNIFIED IDEOGRAPH-76C2
        0x6986, # G+4289  U+6986  uni6986,  CJK UNIFIED IDEOGRAPH-6986
        0x865E, # G+4290  U+865E  uni865E,  CJK UNIFIED IDEOGRAPH-865E
        0x611A, # G+4291  U+611A  uni611A,  CJK UNIFIED IDEOGRAPH-611A
        0x8206, # G+4292  U+8206  uni8206,  CJK UNIFIED IDEOGRAPH-8206
        0x4F59, # G+4293  U+4F59  uni4F59,  CJK UNIFIED IDEOGRAPH-4F59
        0x4FDE, # G+4294  U+4FDE  uni4FDE,  CJK UNIFIED IDEOGRAPH-4FDE
        0x903E, # G+4295  U+903E  uni903E,  CJK UNIFIED IDEOGRAPH-903E
        0x9C7C, # G+4296  U+9C7C  uni9C7C,  CJK UNIFIED IDEOGRAPH-9C7C
        0x6109, # G+4297  U+6109  uni6109,  CJK UNIFIED IDEOGRAPH-6109
        0x6E1D, # G+4298  U+6E1D  uni6E1D,  CJK UNIFIED IDEOGRAPH-6E1D
        0x6E14, # G+4299  U+6E14  uni6E14,  CJK UNIFIED IDEOGRAPH-6E14
        0x9685, # G+4300  U+9685  uni9685,  CJK UNIFIED IDEOGRAPH-9685
        0x4E88, # G+4301  U+4E88  uni4E88,  CJK UNIFIED IDEOGRAPH-4E88
        0x5A31, # G+4302  U+5A31  uni5A31,  CJK UNIFIED IDEOGRAPH-5A31
        0x2FAC, # G+4303  U+2FAC  uni2FAC,  KANGXI RADICAL RAIN
        0x4E0E, # G+4304  U+4E0E  uni4E0E,  CJK UNIFIED IDEOGRAPH-4E0E
        0x5C7F, # G+4305  U+5C7F  uni5C7F,  CJK UNIFIED IDEOGRAPH-5C7F
        0x79B9, # G+4306  U+79B9  uni79B9,  CJK UNIFIED IDEOGRAPH-79B9
        0x5B87, # G+4307  U+5B87  uni5B87,  CJK UNIFIED IDEOGRAPH-5B87
        0x8BED, # G+4308  U+8BED  uni8BED,  CJK UNIFIED IDEOGRAPH-8BED
        0x2F7B, # G+4309  U+2F7B  uni2F7B,  KANGXI RADICAL FEATHER
        0x2F5F, # G+4310  U+2F5F  uni2F5F,  KANGXI RADICAL JADE
        0x57DF, # G+4311  U+57DF  uni57DF,  CJK UNIFIED IDEOGRAPH-57DF
        0x828B, # G+4312  U+828B  uni828B,  CJK UNIFIED IDEOGRAPH-828B
        0x90C1, # G+4313  U+90C1  uni90C1,  CJK UNIFIED IDEOGRAPH-90C1
        0x5401, # G+4314  U+5401  uni5401,  CJK UNIFIED IDEOGRAPH-5401
        0x9047, # G+4315  U+9047  uni9047,  CJK UNIFIED IDEOGRAPH-9047
        0x55BB, # G+4316  U+55BB  uni55BB,  CJK UNIFIED IDEOGRAPH-55BB
        0x5CEA, # G+4317  U+5CEA  uni5CEA,  CJK UNIFIED IDEOGRAPH-5CEA
        0x5FA1, # G+4318  U+5FA1  uni5FA1,  CJK UNIFIED IDEOGRAPH-5FA1
        0x6108, # G+4319  U+6108  uni6108,  CJK UNIFIED IDEOGRAPH-6108
        0x6B32, # G+4320  U+6B32  uni6B32,  CJK UNIFIED IDEOGRAPH-6B32
        0x72F1, # G+4321  U+72F1  uni72F1,  CJK UNIFIED IDEOGRAPH-72F1
        0x80B2, # G+4322  U+80B2  uni80B2,  CJK UNIFIED IDEOGRAPH-80B2
        0x8A89, # G+4323  U+8A89  uni8A89,  CJK UNIFIED IDEOGRAPH-8A89
        0x6D74, # G+4324  U+6D74  uni6D74,  CJK UNIFIED IDEOGRAPH-6D74
        0x5BD3, # G+4325  U+5BD3  uni5BD3,  CJK UNIFIED IDEOGRAPH-5BD3
        0x88D5, # G+4326  U+88D5  uni88D5,  CJK UNIFIED IDEOGRAPH-88D5
        0x9884, # G+4327  U+9884  uni9884,  CJK UNIFIED IDEOGRAPH-9884
        0x8C6B, # G+4328  U+8C6B  uni8C6B,  CJK UNIFIED IDEOGRAPH-8C6B
        0x9A6D, # G+4329  U+9A6D  uni9A6D,  CJK UNIFIED IDEOGRAPH-9A6D
        0x9E33, # G+4330  U+9E33  uni9E33,  CJK UNIFIED IDEOGRAPH-9E33
        0x6E0A, # G+4331  U+6E0A  uni6E0A,  CJK UNIFIED IDEOGRAPH-6E0A
        0x51A4, # G+4332  U+51A4  uni51A4,  CJK UNIFIED IDEOGRAPH-51A4
        0x5143, # G+4333  U+5143  uni5143,  CJK UNIFIED IDEOGRAPH-5143
        0x57A3, # G+4334  U+57A3  uni57A3,  CJK UNIFIED IDEOGRAPH-57A3
        0x8881, # G+4335  U+8881  uni8881,  CJK UNIFIED IDEOGRAPH-8881
        0x539F, # G+4336  U+539F  uni539F,  CJK UNIFIED IDEOGRAPH-539F
        0x63F4, # G+4337  U+63F4  uni63F4,  CJK UNIFIED IDEOGRAPH-63F4
        0x8F95, # G+4338  U+8F95  uni8F95,  CJK UNIFIED IDEOGRAPH-8F95
        0x56ED, # G+4339  U+56ED  uni56ED,  CJK UNIFIED IDEOGRAPH-56ED
        0x5458, # G+4340  U+5458  uni5458,  CJK UNIFIED IDEOGRAPH-5458
        0x5706, # G+4341  U+5706  uni5706,  CJK UNIFIED IDEOGRAPH-5706
        0x733F, # G+4342  U+733F  uni733F,  CJK UNIFIED IDEOGRAPH-733F
        0x6E90, # G+4343  U+6E90  uni6E90,  CJK UNIFIED IDEOGRAPH-6E90
        0x7F18, # G+4344  U+7F18  uni7F18,  CJK UNIFIED IDEOGRAPH-7F18
        0x8FDC, # G+4345  U+8FDC  uni8FDC,  CJK UNIFIED IDEOGRAPH-8FDC
        0x82D1, # G+4346  U+82D1  uni82D1,  CJK UNIFIED IDEOGRAPH-82D1
        0x613F, # G+4347  U+613F  uni613F,  CJK UNIFIED IDEOGRAPH-613F
        0x6028, # G+4348  U+6028  uni6028,  CJK UNIFIED IDEOGRAPH-6028
        0x9662, # G+4349  U+9662  uni9662,  CJK UNIFIED IDEOGRAPH-9662
        0x2F48, # G+4350  U+2F48  uni2F48,  KANGXI RADICAL SAY
        0x7EA6, # G+4351  U+7EA6  uni7EA6,  CJK UNIFIED IDEOGRAPH-7EA6
        0x8D8A, # G+4352  U+8D8A  uni8D8A,  CJK UNIFIED IDEOGRAPH-8D8A
        0x8DC3, # G+4353  U+8DC3  uni8DC3,  CJK UNIFIED IDEOGRAPH-8DC3
        0x94A5, # G+4354  U+94A5  uni94A5,  CJK UNIFIED IDEOGRAPH-94A5
        0x5CB3, # G+4355  U+5CB3  uni5CB3,  CJK UNIFIED IDEOGRAPH-5CB3
        0x7CA4, # G+4356  U+7CA4  uni7CA4,  CJK UNIFIED IDEOGRAPH-7CA4
        0x2F49, # G+4357  U+2F49  uni2F49,  KANGXI RADICAL MOON
        0x60A6, # G+4358  U+60A6  uni60A6,  CJK UNIFIED IDEOGRAPH-60A6
        0x9605, # G+4359  U+9605  uni9605,  CJK UNIFIED IDEOGRAPH-9605
        0x8018, # G+4360  U+8018  uni8018,  CJK UNIFIED IDEOGRAPH-8018
        0x4E91, # G+4361  U+4E91  uni4E91,  CJK UNIFIED IDEOGRAPH-4E91
        0x90E7, # G+4362  U+90E7  uni90E7,  CJK UNIFIED IDEOGRAPH-90E7
        0x5300, # G+4363  U+5300  uni5300,  CJK UNIFIED IDEOGRAPH-5300
        0x9668, # G+4364  U+9668  uni9668,  CJK UNIFIED IDEOGRAPH-9668
        0x5141, # G+4365  U+5141  uni5141,  CJK UNIFIED IDEOGRAPH-5141
        0x8FD0, # G+4366  U+8FD0  uni8FD0,  CJK UNIFIED IDEOGRAPH-8FD0
        0x8574, # G+4367  U+8574  uni8574,  CJK UNIFIED IDEOGRAPH-8574
        0x915D, # G+4368  U+915D  uni915D,  CJK UNIFIED IDEOGRAPH-915D
        0x6655, # G+4369  U+6655  uni6655,  CJK UNIFIED IDEOGRAPH-6655
        0x97F5, # G+4370  U+97F5  uni97F5,  CJK UNIFIED IDEOGRAPH-97F5
        0x5B55, # G+4371  U+5B55  uni5B55,  CJK UNIFIED IDEOGRAPH-5B55
        0x531D, # G+4372  U+531D  uni531D,  CJK UNIFIED IDEOGRAPH-531D
        0x7838, # G+4373  U+7838  uni7838,  CJK UNIFIED IDEOGRAPH-7838
        0x6742, # G+4374  U+6742  uni6742,  CJK UNIFIED IDEOGRAPH-6742
        0x683D, # G+4375  U+683D  uni683D,  CJK UNIFIED IDEOGRAPH-683D
        0x54C9, # G+4376  U+54C9  uni54C9,  CJK UNIFIED IDEOGRAPH-54C9
        0x707E, # G+4377  U+707E  uni707E,  CJK UNIFIED IDEOGRAPH-707E
        0x5BB0, # G+4378  U+5BB0  uni5BB0,  CJK UNIFIED IDEOGRAPH-5BB0
        0x8F7D, # G+4379  U+8F7D  uni8F7D,  CJK UNIFIED IDEOGRAPH-8F7D
        0x518D, # G+4380  U+518D  uni518D,  CJK UNIFIED IDEOGRAPH-518D
        0x5728, # G+4381  U+5728  uni5728,  CJK UNIFIED IDEOGRAPH-5728
        0x54B1, # G+4382  U+54B1  uni54B1,  CJK UNIFIED IDEOGRAPH-54B1
        0x6512, # G+4383  U+6512  uni6512,  CJK UNIFIED IDEOGRAPH-6512
        0x6682, # G+4384  U+6682  uni6682,  CJK UNIFIED IDEOGRAPH-6682
        0x8D5E, # G+4385  U+8D5E  uni8D5E,  CJK UNIFIED IDEOGRAPH-8D5E
        0x8D43, # G+4386  U+8D43  uni8D43,  CJK UNIFIED IDEOGRAPH-8D43
        0x810F, # G+4387  U+810F  uni810F,  CJK UNIFIED IDEOGRAPH-810F
        0x846C, # G+4388  U+846C  uni846C,  CJK UNIFIED IDEOGRAPH-846C
        0x906D, # G+4389  U+906D  uni906D,  CJK UNIFIED IDEOGRAPH-906D
        0x7CDF, # G+4390  U+7CDF  uni7CDF,  CJK UNIFIED IDEOGRAPH-7CDF
        0x51FF, # G+4391  U+51FF  uni51FF,  CJK UNIFIED IDEOGRAPH-51FF
        0x85FB, # G+4392  U+85FB  uni85FB,  CJK UNIFIED IDEOGRAPH-85FB
        0x67A3, # G+4393  U+67A3  uni67A3,  CJK UNIFIED IDEOGRAPH-67A3
        0x65E9, # G+4394  U+65E9  uni65E9,  CJK UNIFIED IDEOGRAPH-65E9
        0x6FA1, # G+4395  U+6FA1  uni6FA1,  CJK UNIFIED IDEOGRAPH-6FA1
        0x86A4, # G+4396  U+86A4  uni86A4,  CJK UNIFIED IDEOGRAPH-86A4
        0x8E81, # G+4397  U+8E81  uni8E81,  CJK UNIFIED IDEOGRAPH-8E81
        0x566A, # G+4398  U+566A  uni566A,  CJK UNIFIED IDEOGRAPH-566A
        0x9020, # G+4399  U+9020  uni9020,  CJK UNIFIED IDEOGRAPH-9020
        0x7682, # G+4400  U+7682  uni7682,  CJK UNIFIED IDEOGRAPH-7682
        0x7076, # G+4401  U+7076  uni7076,  CJK UNIFIED IDEOGRAPH-7076
        0x71E5, # G+4402  U+71E5  uni71E5,  CJK UNIFIED IDEOGRAPH-71E5
        0x8D23, # G+4403  U+8D23  uni8D23,  CJK UNIFIED IDEOGRAPH-8D23
        0x62E9, # G+4404  U+62E9  uni62E9,  CJK UNIFIED IDEOGRAPH-62E9
        0x5219, # G+4405  U+5219  uni5219,  CJK UNIFIED IDEOGRAPH-5219
        0x6CFD, # G+4406  U+6CFD  uni6CFD,  CJK UNIFIED IDEOGRAPH-6CFD
        0x8D3C, # G+4407  U+8D3C  uni8D3C,  CJK UNIFIED IDEOGRAPH-8D3C
        0x600E, # G+4408  U+600E  uni600E,  CJK UNIFIED IDEOGRAPH-600E
        0x589E, # G+4409  U+589E  uni589E,  CJK UNIFIED IDEOGRAPH-589E
        0x618E, # G+4410  U+618E  uni618E,  CJK UNIFIED IDEOGRAPH-618E
        0x66FE, # G+4411  U+66FE  uni66FE,  CJK UNIFIED IDEOGRAPH-66FE
        0x8D60, # G+4412  U+8D60  uni8D60,  CJK UNIFIED IDEOGRAPH-8D60
        0x624E, # G+4413  U+624E  uni624E,  CJK UNIFIED IDEOGRAPH-624E
        0x55B3, # G+4414  U+55B3  uni55B3,  CJK UNIFIED IDEOGRAPH-55B3
        0x6E23, # G+4415  U+6E23  uni6E23,  CJK UNIFIED IDEOGRAPH-6E23
        0x672D, # G+4416  U+672D  uni672D,  CJK UNIFIED IDEOGRAPH-672D
        0x8F67, # G+4417  U+8F67  uni8F67,  CJK UNIFIED IDEOGRAPH-8F67
        0x94E1, # G+4418  U+94E1  uni94E1,  CJK UNIFIED IDEOGRAPH-94E1
        0x95F8, # G+4419  U+95F8  uni95F8,  CJK UNIFIED IDEOGRAPH-95F8
        0x7728, # G+4420  U+7728  uni7728,  CJK UNIFIED IDEOGRAPH-7728
        0x6805, # G+4421  U+6805  uni6805,  CJK UNIFIED IDEOGRAPH-6805
        0x69A8, # G+4422  U+69A8  uni69A8,  CJK UNIFIED IDEOGRAPH-69A8
        0x548B, # G+4423  U+548B  uni548B,  CJK UNIFIED IDEOGRAPH-548B
        0x4E4D, # G+4424  U+4E4D  uni4E4D,  CJK UNIFIED IDEOGRAPH-4E4D
        0x70B8, # G+4425  U+70B8  uni70B8,  CJK UNIFIED IDEOGRAPH-70B8
        0x8BC8, # G+4426  U+8BC8  uni8BC8,  CJK UNIFIED IDEOGRAPH-8BC8
        0x6458, # G+4427  U+6458  uni6458,  CJK UNIFIED IDEOGRAPH-6458
        0x658B, # G+4428  U+658B  uni658B,  CJK UNIFIED IDEOGRAPH-658B
        0x5B85, # G+4429  U+5B85  uni5B85,  CJK UNIFIED IDEOGRAPH-5B85
        0x7A84, # G+4430  U+7A84  uni7A84,  CJK UNIFIED IDEOGRAPH-7A84
        0x503A, # G+4431  U+503A  uni503A,  CJK UNIFIED IDEOGRAPH-503A
        0x5BE8, # G+4432  U+5BE8  uni5BE8,  CJK UNIFIED IDEOGRAPH-5BE8
        0x77BB, # G+4433  U+77BB  uni77BB,  CJK UNIFIED IDEOGRAPH-77BB
        0x6BE1, # G+4434  U+6BE1  uni6BE1,  CJK UNIFIED IDEOGRAPH-6BE1
        0x8A79, # G+4435  U+8A79  uni8A79,  CJK UNIFIED IDEOGRAPH-8A79
        0x7C98, # G+4436  U+7C98  uni7C98,  CJK UNIFIED IDEOGRAPH-7C98
        0x6CBE, # G+4437  U+6CBE  uni6CBE,  CJK UNIFIED IDEOGRAPH-6CBE
        0x76CF, # G+4438  U+76CF  uni76CF,  CJK UNIFIED IDEOGRAPH-76CF
        0x65A9, # G+4439  U+65A9  uni65A9,  CJK UNIFIED IDEOGRAPH-65A9
        0x8F97, # G+4440  U+8F97  uni8F97,  CJK UNIFIED IDEOGRAPH-8F97
        0x5D2D, # G+4441  U+5D2D  uni5D2D,  CJK UNIFIED IDEOGRAPH-5D2D
        0x5C55, # G+4442  U+5C55  uni5C55,  CJK UNIFIED IDEOGRAPH-5C55
        0x8638, # G+4443  U+8638  uni8638,  CJK UNIFIED IDEOGRAPH-8638
        0x6808, # G+4444  U+6808  uni6808,  CJK UNIFIED IDEOGRAPH-6808
        0x5360, # G+4445  U+5360  uni5360,  CJK UNIFIED IDEOGRAPH-5360
        0x6218, # G+4446  U+6218  uni6218,  CJK UNIFIED IDEOGRAPH-6218
        0x7AD9, # G+4447  U+7AD9  uni7AD9,  CJK UNIFIED IDEOGRAPH-7AD9
        0x6E5B, # G+4448  U+6E5B  uni6E5B,  CJK UNIFIED IDEOGRAPH-6E5B
        0x7EFD, # G+4449  U+7EFD  uni7EFD,  CJK UNIFIED IDEOGRAPH-7EFD
        0x6A1F, # G+4450  U+6A1F  uni6A1F,  CJK UNIFIED IDEOGRAPH-6A1F
        0x7AE0, # G+4451  U+7AE0  uni7AE0,  CJK UNIFIED IDEOGRAPH-7AE0
        0x5F70, # G+4452  U+5F70  uni5F70,  CJK UNIFIED IDEOGRAPH-5F70
        0x6F33, # G+4453  U+6F33  uni6F33,  CJK UNIFIED IDEOGRAPH-6F33
        0x5F20, # G+4454  U+5F20  uni5F20,  CJK UNIFIED IDEOGRAPH-5F20
        0x638C, # G+4455  U+638C  uni638C,  CJK UNIFIED IDEOGRAPH-638C
        0x6DA8, # G+4456  U+6DA8  uni6DA8,  CJK UNIFIED IDEOGRAPH-6DA8
        0x6756, # G+4457  U+6756  uni6756,  CJK UNIFIED IDEOGRAPH-6756
        0x4E08, # G+4458  U+4E08  uni4E08,  CJK UNIFIED IDEOGRAPH-4E08
        0x5E10, # G+4459  U+5E10  uni5E10,  CJK UNIFIED IDEOGRAPH-5E10
        0x8D26, # G+4460  U+8D26  uni8D26,  CJK UNIFIED IDEOGRAPH-8D26
        0x4ED7, # G+4461  U+4ED7  uni4ED7,  CJK UNIFIED IDEOGRAPH-4ED7
        0x80C0, # G+4462  U+80C0  uni80C0,  CJK UNIFIED IDEOGRAPH-80C0
        0x7634, # G+4463  U+7634  uni7634,  CJK UNIFIED IDEOGRAPH-7634
        0x969C, # G+4464  U+969C  uni969C,  CJK UNIFIED IDEOGRAPH-969C
        0x62DB, # G+4465  U+62DB  uni62DB,  CJK UNIFIED IDEOGRAPH-62DB
        0x662D, # G+4466  U+662D  uni662D,  CJK UNIFIED IDEOGRAPH-662D
        0x627E, # G+4467  U+627E  uni627E,  CJK UNIFIED IDEOGRAPH-627E
        0x6CBC, # G+4468  U+6CBC  uni6CBC,  CJK UNIFIED IDEOGRAPH-6CBC
        0x8D75, # G+4469  U+8D75  uni8D75,  CJK UNIFIED IDEOGRAPH-8D75
        0x7167, # G+4470  U+7167  uni7167,  CJK UNIFIED IDEOGRAPH-7167
        0x7F69, # G+4471  U+7F69  uni7F69,  CJK UNIFIED IDEOGRAPH-7F69
        0x5146, # G+4472  U+5146  uni5146,  CJK UNIFIED IDEOGRAPH-5146
        0x8087, # G+4473  U+8087  uni8087,  CJK UNIFIED IDEOGRAPH-8087
        0x53EC, # G+4474  U+53EC  uni53EC,  CJK UNIFIED IDEOGRAPH-53EC
        0x906E, # G+4475  U+906E  uni906E,  CJK UNIFIED IDEOGRAPH-906E
        0x6298, # G+4476  U+6298  uni6298,  CJK UNIFIED IDEOGRAPH-6298
        0x54F2, # G+4477  U+54F2  uni54F2,  CJK UNIFIED IDEOGRAPH-54F2
        0x86F0, # G+4478  U+86F0  uni86F0,  CJK UNIFIED IDEOGRAPH-86F0
        0x8F99, # G+4479  U+8F99  uni8F99,  CJK UNIFIED IDEOGRAPH-8F99
        0x8005, # G+4480  U+8005  uni8005,  CJK UNIFIED IDEOGRAPH-8005
        0x9517, # G+4481  U+9517  uni9517,  CJK UNIFIED IDEOGRAPH-9517
        0x8517, # G+4482  U+8517  uni8517,  CJK UNIFIED IDEOGRAPH-8517
        0x8FD9, # G+4483  U+8FD9  uni8FD9,  CJK UNIFIED IDEOGRAPH-8FD9
        0x6D59, # G+4484  U+6D59  uni6D59,  CJK UNIFIED IDEOGRAPH-6D59
        0x73CD, # G+4485  U+73CD  uni73CD,  CJK UNIFIED IDEOGRAPH-73CD
        0x659F, # G+4486  U+659F  uni659F,  CJK UNIFIED IDEOGRAPH-659F
        0x771F, # G+4487  U+771F  uni771F,  CJK UNIFIED IDEOGRAPH-771F
        0x7504, # G+4488  U+7504  uni7504,  CJK UNIFIED IDEOGRAPH-7504
        0x7827, # G+4489  U+7827  uni7827,  CJK UNIFIED IDEOGRAPH-7827
        0x81FB, # G+4490  U+81FB  uni81FB,  CJK UNIFIED IDEOGRAPH-81FB
        0x8D1E, # G+4491  U+8D1E  uni8D1E,  CJK UNIFIED IDEOGRAPH-8D1E
        0x9488, # G+4492  U+9488  uni9488,  CJK UNIFIED IDEOGRAPH-9488
        0x4FA6, # G+4493  U+4FA6  uni4FA6,  CJK UNIFIED IDEOGRAPH-4FA6
        0x6795, # G+4494  U+6795  uni6795,  CJK UNIFIED IDEOGRAPH-6795
        0x75B9, # G+4495  U+75B9  uni75B9,  CJK UNIFIED IDEOGRAPH-75B9
        0x8BCA, # G+4496  U+8BCA  uni8BCA,  CJK UNIFIED IDEOGRAPH-8BCA
        0x9707, # G+4497  U+9707  uni9707,  CJK UNIFIED IDEOGRAPH-9707
        0x632F, # G+4498  U+632F  uni632F,  CJK UNIFIED IDEOGRAPH-632F
        0x9547, # G+4499  U+9547  uni9547,  CJK UNIFIED IDEOGRAPH-9547
        0x9635, # G+4500  U+9635  uni9635,  CJK UNIFIED IDEOGRAPH-9635
        0x84B8, # G+4501  U+84B8  uni84B8,  CJK UNIFIED IDEOGRAPH-84B8
        0x6323, # G+4502  U+6323  uni6323,  CJK UNIFIED IDEOGRAPH-6323
        0x7741, # G+4503  U+7741  uni7741,  CJK UNIFIED IDEOGRAPH-7741
        0x5F81, # G+4504  U+5F81  uni5F81,  CJK UNIFIED IDEOGRAPH-5F81
        0x72F0, # G+4505  U+72F0  uni72F0,  CJK UNIFIED IDEOGRAPH-72F0
        0x4E89, # G+4506  U+4E89  uni4E89,  CJK UNIFIED IDEOGRAPH-4E89
        0x6014, # G+4507  U+6014  uni6014,  CJK UNIFIED IDEOGRAPH-6014
        0x6574, # G+4508  U+6574  uni6574,  CJK UNIFIED IDEOGRAPH-6574
        0x62EF, # G+4509  U+62EF  uni62EF,  CJK UNIFIED IDEOGRAPH-62EF
        0x6B63, # G+4510  U+6B63  uni6B63,  CJK UNIFIED IDEOGRAPH-6B63
        0x653F, # G+4511  U+653F  uni653F,  CJK UNIFIED IDEOGRAPH-653F
        0x5E27, # G+4512  U+5E27  uni5E27,  CJK UNIFIED IDEOGRAPH-5E27
        0x75C7, # G+4513  U+75C7  uni75C7,  CJK UNIFIED IDEOGRAPH-75C7
        0x90D1, # G+4514  U+90D1  uni90D1,  CJK UNIFIED IDEOGRAPH-90D1
        0x8BC1, # G+4515  U+8BC1  uni8BC1,  CJK UNIFIED IDEOGRAPH-8BC1
        0x829D, # G+4516  U+829D  uni829D,  CJK UNIFIED IDEOGRAPH-829D
        0x679D, # G+4517  U+679D  uni679D,  CJK UNIFIED IDEOGRAPH-679D
        0x2F40, # G+4518  U+2F40  uni2F40,  KANGXI RADICAL BRANCH
        0x5431, # G+4519  U+5431  uni5431,  CJK UNIFIED IDEOGRAPH-5431
        0x8718, # G+4520  U+8718  uni8718,  CJK UNIFIED IDEOGRAPH-8718
        0x77E5, # G+4521  U+77E5  uni77E5,  CJK UNIFIED IDEOGRAPH-77E5
        0x80A2, # G+4522  U+80A2  uni80A2,  CJK UNIFIED IDEOGRAPH-80A2
        0x8102, # G+4523  U+8102  uni8102,  CJK UNIFIED IDEOGRAPH-8102
        0x6C41, # G+4524  U+6C41  uni6C41,  CJK UNIFIED IDEOGRAPH-6C41
        0x4E4B, # G+4525  U+4E4B  uni4E4B,  CJK UNIFIED IDEOGRAPH-4E4B
        0x7EC7, # G+4526  U+7EC7  uni7EC7,  CJK UNIFIED IDEOGRAPH-7EC7
        0x804C, # G+4527  U+804C  uni804C,  CJK UNIFIED IDEOGRAPH-804C
        0x76F4, # G+4528  U+76F4  uni76F4,  CJK UNIFIED IDEOGRAPH-76F4
        0x690D, # G+4529  U+690D  uni690D,  CJK UNIFIED IDEOGRAPH-690D
        0x6B96, # G+4530  U+6B96  uni6B96,  CJK UNIFIED IDEOGRAPH-6B96
        0x6267, # G+4531  U+6267  uni6267,  CJK UNIFIED IDEOGRAPH-6267
        0x503C, # G+4532  U+503C  uni503C,  CJK UNIFIED IDEOGRAPH-503C
        0x4F84, # G+4533  U+4F84  uni4F84,  CJK UNIFIED IDEOGRAPH-4F84
        0x5740, # G+4534  U+5740  uni5740,  CJK UNIFIED IDEOGRAPH-5740
        0x6307, # G+4535  U+6307  uni6307,  CJK UNIFIED IDEOGRAPH-6307
        0x2F4C, # G+4536  U+2F4C  uni2F4C,  KANGXI RADICAL STOP
        0x8DBE, # G+4537  U+8DBE  uni8DBE,  CJK UNIFIED IDEOGRAPH-8DBE
        0x53EA, # G+4538  U+53EA  uni53EA,  CJK UNIFIED IDEOGRAPH-53EA
        0x65E8, # G+4539  U+65E8  uni65E8,  CJK UNIFIED IDEOGRAPH-65E8
        0x7EB8, # G+4540  U+7EB8  uni7EB8,  CJK UNIFIED IDEOGRAPH-7EB8
        0x5FD7, # G+4541  U+5FD7  uni5FD7,  CJK UNIFIED IDEOGRAPH-5FD7
        0x631A, # G+4542  U+631A  uni631A,  CJK UNIFIED IDEOGRAPH-631A
        0x63B7, # G+4543  U+63B7  uni63B7,  CJK UNIFIED IDEOGRAPH-63B7
        0x2F84, # G+4544  U+2F84  uni2F84,  KANGXI RADICAL ARRIVE
        0x81F4, # G+4545  U+81F4  uni81F4,  CJK UNIFIED IDEOGRAPH-81F4
        0x7F6E, # G+4546  U+7F6E  uni7F6E,  CJK UNIFIED IDEOGRAPH-7F6E
        0x5E1C, # G+4547  U+5E1C  uni5E1C,  CJK UNIFIED IDEOGRAPH-5E1C
        0x5CD9, # G+4548  U+5CD9  uni5CD9,  CJK UNIFIED IDEOGRAPH-5CD9
        0x5236, # G+4549  U+5236  uni5236,  CJK UNIFIED IDEOGRAPH-5236
        0x667A, # G+4550  U+667A  uni667A,  CJK UNIFIED IDEOGRAPH-667A
        0x79E9, # G+4551  U+79E9  uni79E9,  CJK UNIFIED IDEOGRAPH-79E9
        0x7A1A, # G+4552  U+7A1A  uni7A1A,  CJK UNIFIED IDEOGRAPH-7A1A
        0x8D28, # G+4553  U+8D28  uni8D28,  CJK UNIFIED IDEOGRAPH-8D28
        0x7099, # G+4554  U+7099  uni7099,  CJK UNIFIED IDEOGRAPH-7099
        0x75D4, # G+4555  U+75D4  uni75D4,  CJK UNIFIED IDEOGRAPH-75D4
        0x6EDE, # G+4556  U+6EDE  uni6EDE,  CJK UNIFIED IDEOGRAPH-6EDE
        0x6CBB, # G+4557  U+6CBB  uni6CBB,  CJK UNIFIED IDEOGRAPH-6CBB
        0x7A92, # G+4558  U+7A92  uni7A92,  CJK UNIFIED IDEOGRAPH-7A92
        0x4E2D, # G+4559  U+4E2D  uni4E2D,  CJK UNIFIED IDEOGRAPH-4E2D
        0x76C5, # G+4560  U+76C5  uni76C5,  CJK UNIFIED IDEOGRAPH-76C5
        0x5FE0, # G+4561  U+5FE0  uni5FE0,  CJK UNIFIED IDEOGRAPH-5FE0
        0x949F, # G+4562  U+949F  uni949F,  CJK UNIFIED IDEOGRAPH-949F
        0x8877, # G+4563  U+8877  uni8877,  CJK UNIFIED IDEOGRAPH-8877
        0x7EC8, # G+4564  U+7EC8  uni7EC8,  CJK UNIFIED IDEOGRAPH-7EC8
        0x79CD, # G+4565  U+79CD  uni79CD,  CJK UNIFIED IDEOGRAPH-79CD
        0x80BF, # G+4566  U+80BF  uni80BF,  CJK UNIFIED IDEOGRAPH-80BF
        0x91CD, # G+4567  U+91CD  uni91CD,  CJK UNIFIED IDEOGRAPH-91CD
        0x4EF2, # G+4568  U+4EF2  uni4EF2,  CJK UNIFIED IDEOGRAPH-4EF2
        0x4F17, # G+4569  U+4F17  uni4F17,  CJK UNIFIED IDEOGRAPH-4F17
        0x2F88, # G+4570  U+2F88  uni2F88,  KANGXI RADICAL BOAT
        0x5468, # G+4571  U+5468  uni5468,  CJK UNIFIED IDEOGRAPH-5468
        0x5DDE, # G+4572  U+5DDE  uni5DDE,  CJK UNIFIED IDEOGRAPH-5DDE
        0x6D32, # G+4573  U+6D32  uni6D32,  CJK UNIFIED IDEOGRAPH-6D32
        0x8BCC, # G+4574  U+8BCC  uni8BCC,  CJK UNIFIED IDEOGRAPH-8BCC
        0x7CA5, # G+4575  U+7CA5  uni7CA5,  CJK UNIFIED IDEOGRAPH-7CA5
        0x8F74, # G+4576  U+8F74  uni8F74,  CJK UNIFIED IDEOGRAPH-8F74
        0x8098, # G+4577  U+8098  uni8098,  CJK UNIFIED IDEOGRAPH-8098
        0x5E1A, # G+4578  U+5E1A  uni5E1A,  CJK UNIFIED IDEOGRAPH-5E1A
        0x5492, # G+4579  U+5492  uni5492,  CJK UNIFIED IDEOGRAPH-5492
        0x76B1, # G+4580  U+76B1  uni76B1,  CJK UNIFIED IDEOGRAPH-76B1
        0x5B99, # G+4581  U+5B99  uni5B99,  CJK UNIFIED IDEOGRAPH-5B99
        0x663C, # G+4582  U+663C  uni663C,  CJK UNIFIED IDEOGRAPH-663C
        0x9AA4, # G+4583  U+9AA4  uni9AA4,  CJK UNIFIED IDEOGRAPH-9AA4
        0x73E0, # G+4584  U+73E0  uni73E0,  CJK UNIFIED IDEOGRAPH-73E0
        0x682A, # G+4585  U+682A  uni682A,  CJK UNIFIED IDEOGRAPH-682A
        0x86DB, # G+4586  U+86DB  uni86DB,  CJK UNIFIED IDEOGRAPH-86DB
        0x6731, # G+4587  U+6731  uni6731,  CJK UNIFIED IDEOGRAPH-6731
        0x732A, # G+4588  U+732A  uni732A,  CJK UNIFIED IDEOGRAPH-732A
        0x8BF8, # G+4589  U+8BF8  uni8BF8,  CJK UNIFIED IDEOGRAPH-8BF8
        0x8BDB, # G+4590  U+8BDB  uni8BDB,  CJK UNIFIED IDEOGRAPH-8BDB
        0x9010, # G+4591  U+9010  uni9010,  CJK UNIFIED IDEOGRAPH-9010
        0x2F75, # G+4592  U+2F75  uni2F75,  KANGXI RADICAL BAMBOO
        0x70DB, # G+4593  U+70DB  uni70DB,  CJK UNIFIED IDEOGRAPH-70DB
        0x716E, # G+4594  U+716E  uni716E,  CJK UNIFIED IDEOGRAPH-716E
        0x62C4, # G+4595  U+62C4  uni62C4,  CJK UNIFIED IDEOGRAPH-62C4
        0x77A9, # G+4596  U+77A9  uni77A9,  CJK UNIFIED IDEOGRAPH-77A9
        0x5631, # G+4597  U+5631  uni5631,  CJK UNIFIED IDEOGRAPH-5631
        0x4E3B, # G+4598  U+4E3B  uni4E3B,  CJK UNIFIED IDEOGRAPH-4E3B
        0x8457, # G+4599  U+8457  uni8457,  CJK UNIFIED IDEOGRAPH-8457
        0x67F1, # G+4600  U+67F1  uni67F1,  CJK UNIFIED IDEOGRAPH-67F1
        0x52A9, # G+4601  U+52A9  uni52A9,  CJK UNIFIED IDEOGRAPH-52A9
        0x86C0, # G+4602  U+86C0  uni86C0,  CJK UNIFIED IDEOGRAPH-86C0
        0x8D2E, # G+4603  U+8D2E  uni8D2E,  CJK UNIFIED IDEOGRAPH-8D2E
        0x94F8, # G+4604  U+94F8  uni94F8,  CJK UNIFIED IDEOGRAPH-94F8
        0x7B51, # G+4605  U+7B51  uni7B51,  CJK UNIFIED IDEOGRAPH-7B51
        0x4F4F, # G+4606  U+4F4F  uni4F4F,  CJK UNIFIED IDEOGRAPH-4F4F
        0x6CE8, # G+4607  U+6CE8  uni6CE8,  CJK UNIFIED IDEOGRAPH-6CE8
        0x795D, # G+4608  U+795D  uni795D,  CJK UNIFIED IDEOGRAPH-795D
        0x9A7B, # G+4609  U+9A7B  uni9A7B,  CJK UNIFIED IDEOGRAPH-9A7B
        0x6293, # G+4610  U+6293  uni6293,  CJK UNIFIED IDEOGRAPH-6293
        0x2F56, # G+4611  U+2F56  uni2F56,  KANGXI RADICAL CLAW
        0x62FD, # G+4612  U+62FD  uni62FD,  CJK UNIFIED IDEOGRAPH-62FD
        0x4E13, # G+4613  U+4E13  uni4E13,  CJK UNIFIED IDEOGRAPH-4E13
        0x7816, # G+4614  U+7816  uni7816,  CJK UNIFIED IDEOGRAPH-7816
        0x8F6C, # G+4615  U+8F6C  uni8F6C,  CJK UNIFIED IDEOGRAPH-8F6C
        0x64B0, # G+4616  U+64B0  uni64B0,  CJK UNIFIED IDEOGRAPH-64B0
        0x8D5A, # G+4617  U+8D5A  uni8D5A,  CJK UNIFIED IDEOGRAPH-8D5A
        0x7BC6, # G+4618  U+7BC6  uni7BC6,  CJK UNIFIED IDEOGRAPH-7BC6
        0x6869, # G+4619  U+6869  uni6869,  CJK UNIFIED IDEOGRAPH-6869
        0x5E84, # G+4620  U+5E84  uni5E84,  CJK UNIFIED IDEOGRAPH-5E84
        0x88C5, # G+4621  U+88C5  uni88C5,  CJK UNIFIED IDEOGRAPH-88C5
        0x5986, # G+4622  U+5986  uni5986,  CJK UNIFIED IDEOGRAPH-5986
        0x649E, # G+4623  U+649E  uni649E,  CJK UNIFIED IDEOGRAPH-649E
        0x58EE, # G+4624  U+58EE  uni58EE,  CJK UNIFIED IDEOGRAPH-58EE
        0x72B6, # G+4625  U+72B6  uni72B6,  CJK UNIFIED IDEOGRAPH-72B6
        0x690E, # G+4626  U+690E  uni690E,  CJK UNIFIED IDEOGRAPH-690E
        0x9525, # G+4627  U+9525  uni9525,  CJK UNIFIED IDEOGRAPH-9525
        0x8FFD, # G+4628  U+8FFD  uni8FFD,  CJK UNIFIED IDEOGRAPH-8FFD
        0x8D58, # G+4629  U+8D58  uni8D58,  CJK UNIFIED IDEOGRAPH-8D58
        0x5760, # G+4630  U+5760  uni5760,  CJK UNIFIED IDEOGRAPH-5760
        0x7F00, # G+4631  U+7F00  uni7F00,  CJK UNIFIED IDEOGRAPH-7F00
        0x8C06, # G+4632  U+8C06  uni8C06,  CJK UNIFIED IDEOGRAPH-8C06
        0x51C6, # G+4633  U+51C6  uni51C6,  CJK UNIFIED IDEOGRAPH-51C6
        0x6349, # G+4634  U+6349  uni6349,  CJK UNIFIED IDEOGRAPH-6349
        0x62D9, # G+4635  U+62D9  uni62D9,  CJK UNIFIED IDEOGRAPH-62D9
        0x5353, # G+4636  U+5353  uni5353,  CJK UNIFIED IDEOGRAPH-5353
        0x684C, # G+4637  U+684C  uni684C,  CJK UNIFIED IDEOGRAPH-684C
        0x7422, # G+4638  U+7422  uni7422,  CJK UNIFIED IDEOGRAPH-7422
        0x8301, # G+4639  U+8301  uni8301,  CJK UNIFIED IDEOGRAPH-8301
        0x914C, # G+4640  U+914C  uni914C,  CJK UNIFIED IDEOGRAPH-914C
        0x5544, # G+4641  U+5544  uni5544,  CJK UNIFIED IDEOGRAPH-5544
        0x7740, # G+4642  U+7740  uni7740,  CJK UNIFIED IDEOGRAPH-7740
        0x707C, # G+4643  U+707C  uni707C,  CJK UNIFIED IDEOGRAPH-707C
        0x6D4A, # G+4644  U+6D4A  uni6D4A,  CJK UNIFIED IDEOGRAPH-6D4A
        0x5179, # G+4645  U+5179  uni5179,  CJK UNIFIED IDEOGRAPH-5179
        0x54A8, # G+4646  U+54A8  uni54A8,  CJK UNIFIED IDEOGRAPH-54A8
        0x8D44, # G+4647  U+8D44  uni8D44,  CJK UNIFIED IDEOGRAPH-8D44
        0x59FF, # G+4648  U+59FF  uni59FF,  CJK UNIFIED IDEOGRAPH-59FF
        0x6ECB, # G+4649  U+6ECB  uni6ECB,  CJK UNIFIED IDEOGRAPH-6ECB
        0x6DC4, # G+4650  U+6DC4  uni6DC4,  CJK UNIFIED IDEOGRAPH-6DC4
        0x5B5C, # G+4651  U+5B5C  uni5B5C,  CJK UNIFIED IDEOGRAPH-5B5C
        0x7D2B, # G+4652  U+7D2B  uni7D2B,  CJK UNIFIED IDEOGRAPH-7D2B
        0x4ED4, # G+4653  U+4ED4  uni4ED4,  CJK UNIFIED IDEOGRAPH-4ED4
        0x7C7D, # G+4654  U+7C7D  uni7C7D,  CJK UNIFIED IDEOGRAPH-7C7D
        0x6ED3, # G+4655  U+6ED3  uni6ED3,  CJK UNIFIED IDEOGRAPH-6ED3
        0x2F26, # G+4656  U+2F26  uni2F26,  KANGXI RADICAL CHILD
        0x2F83, # G+4657  U+2F83  uni2F83,  KANGXI RADICAL SELF
        0x6E0D, # G+4658  U+6E0D  uni6E0D,  CJK UNIFIED IDEOGRAPH-6E0D
        0x5B57, # G+4659  U+5B57  uni5B57,  CJK UNIFIED IDEOGRAPH-5B57
        0x9B03, # G+4660  U+9B03  uni9B03,  CJK UNIFIED IDEOGRAPH-9B03
        0x68D5, # G+4661  U+68D5  uni68D5,  CJK UNIFIED IDEOGRAPH-68D5
        0x8E2A, # G+4662  U+8E2A  uni8E2A,  CJK UNIFIED IDEOGRAPH-8E2A
        0x5B97, # G+4663  U+5B97  uni5B97,  CJK UNIFIED IDEOGRAPH-5B97
        0x7EFC, # G+4664  U+7EFC  uni7EFC,  CJK UNIFIED IDEOGRAPH-7EFC
        0x603B, # G+4665  U+603B  uni603B,  CJK UNIFIED IDEOGRAPH-603B
        0x7EB5, # G+4666  U+7EB5  uni7EB5,  CJK UNIFIED IDEOGRAPH-7EB5
        0x90B9, # G+4667  U+90B9  uni90B9,  CJK UNIFIED IDEOGRAPH-90B9
        0x2F9B, # G+4668  U+2F9B  uni2F9B,  KANGXI RADICAL RUN
        0x594F, # G+4669  U+594F  uni594F,  CJK UNIFIED IDEOGRAPH-594F
        0x63CD, # G+4670  U+63CD  uni63CD,  CJK UNIFIED IDEOGRAPH-63CD
        0x79DF, # G+4671  U+79DF  uni79DF,  CJK UNIFIED IDEOGRAPH-79DF
        0x2F9C, # G+4672  U+2F9C  uni2F9C,  KANGXI RADICAL FOOT
        0x5352, # G+4673  U+5352  uni5352,  CJK UNIFIED IDEOGRAPH-5352
        0x65CF, # G+4674  U+65CF  uni65CF,  CJK UNIFIED IDEOGRAPH-65CF
        0x7956, # G+4675  U+7956  uni7956,  CJK UNIFIED IDEOGRAPH-7956
        0x8BC5, # G+4676  U+8BC5  uni8BC5,  CJK UNIFIED IDEOGRAPH-8BC5
        0x963B, # G+4677  U+963B  uni963B,  CJK UNIFIED IDEOGRAPH-963B
        0x7EC4, # G+4678  U+7EC4  uni7EC4,  CJK UNIFIED IDEOGRAPH-7EC4
        0x94BB, # G+4679  U+94BB  uni94BB,  CJK UNIFIED IDEOGRAPH-94BB
        0x7E82, # G+4680  U+7E82  uni7E82,  CJK UNIFIED IDEOGRAPH-7E82
        0x5634, # G+4681  U+5634  uni5634,  CJK UNIFIED IDEOGRAPH-5634
        0x9189, # G+4682  U+9189  uni9189,  CJK UNIFIED IDEOGRAPH-9189
        0x6700, # G+4683  U+6700  uni6700,  CJK UNIFIED IDEOGRAPH-6700
        0x7F6A, # G+4684  U+7F6A  uni7F6A,  CJK UNIFIED IDEOGRAPH-7F6A
        0x5C0A, # G+4685  U+5C0A  uni5C0A,  CJK UNIFIED IDEOGRAPH-5C0A
        0x9075, # G+4686  U+9075  uni9075,  CJK UNIFIED IDEOGRAPH-9075
        0x6628, # G+4687  U+6628  uni6628,  CJK UNIFIED IDEOGRAPH-6628
        0x5DE6, # G+4688  U+5DE6  uni5DE6,  CJK UNIFIED IDEOGRAPH-5DE6
        0x4F50, # G+4689  U+4F50  uni4F50,  CJK UNIFIED IDEOGRAPH-4F50
        0x67DE, # G+4690  U+67DE  uni67DE,  CJK UNIFIED IDEOGRAPH-67DE
        0x505A, # G+4691  U+505A  uni505A,  CJK UNIFIED IDEOGRAPH-505A
        0x4F5C, # G+4692  U+4F5C  uni4F5C,  CJK UNIFIED IDEOGRAPH-4F5C
        0x5750, # G+4693  U+5750  uni5750,  CJK UNIFIED IDEOGRAPH-5750
        0x5EA7, # G+4694  U+5EA7  uni5EA7,  CJK UNIFIED IDEOGRAPH-5EA7
        0x4E8D, # G+4695  U+4E8D  uni4E8D,  CJK UNIFIED IDEOGRAPH-4E8D
        0x4E0C, # G+4696  U+4E0C  uni4E0C,  CJK UNIFIED IDEOGRAPH-4E0C
        0x5140, # G+4697  U+5140  uni5140,  CJK UNIFIED IDEOGRAPH-5140
        0x4E10, # G+4698  U+4E10  uni4E10,  CJK UNIFIED IDEOGRAPH-4E10
        0x5EFF, # G+4699  U+5EFF  uni5EFF,  CJK UNIFIED IDEOGRAPH-5EFF
        0x5345, # G+4700  U+5345  uni5345,  CJK UNIFIED IDEOGRAPH-5345
        0x4E15, # G+4701  U+4E15  uni4E15,  CJK UNIFIED IDEOGRAPH-4E15
        0x4E98, # G+4702  U+4E98  uni4E98,  CJK UNIFIED IDEOGRAPH-4E98
        0x4E1E, # G+4703  U+4E1E  uni4E1E,  CJK UNIFIED IDEOGRAPH-4E1E
        0x2FC0, # G+4704  U+2FC0  uni2FC0,  KANGXI RADICAL CAULDRON
        0x5B6C, # G+4705  U+5B6C  uni5B6C,  CJK UNIFIED IDEOGRAPH-5B6C
        0x5669, # G+4706  U+5669  uni5669,  CJK UNIFIED IDEOGRAPH-5669
        0x2F01, # G+4707  U+2F01  uni2F01,  KANGXI RADICAL LINE
        0x79BA, # G+4708  U+79BA  uni79BA,  CJK UNIFIED IDEOGRAPH-79BA
        0x2F03, # G+4709  U+2F03  uni2F03,  KANGXI RADICAL SLASH
        0x2F14, # G+4710  U+2F14  uni2F14,  KANGXI RADICAL SPOON
        0x4E47, # G+4711  U+4E47  uni4E47,  CJK UNIFIED IDEOGRAPH-4E47
        0x592D, # G+4712  U+592D  uni592D,  CJK UNIFIED IDEOGRAPH-592D
        0x2F58, # G+4713  U+2F58  uni2F58,  KANGXI RADICAL DOUBLE X
        0x536E, # G+4714  U+536E  uni536E,  CJK UNIFIED IDEOGRAPH-536E
        0x6C10, # G+4715  U+6C10  uni6C10,  CJK UNIFIED IDEOGRAPH-6C10
        0x56DF, # G+4716  U+56DF  uni56DF,  CJK UNIFIED IDEOGRAPH-56DF
        0x80E4, # G+4717  U+80E4  uni80E4,  CJK UNIFIED IDEOGRAPH-80E4
        0x9997, # G+4718  U+9997  uni9997,  CJK UNIFIED IDEOGRAPH-9997
        0x6BD3, # G+4719  U+6BD3  uni6BD3,  CJK UNIFIED IDEOGRAPH-6BD3
        0x777E, # G+4720  U+777E  uni777E,  CJK UNIFIED IDEOGRAPH-777E
        0x9F17, # G+4721  U+9F17  uni9F17,  CJK UNIFIED IDEOGRAPH-9F17
        0x2F02, # G+4722  U+2F02  uni2F02,  KANGXI RADICAL DOT
        0x4E9F, # G+4723  U+4E9F  uni4E9F,  CJK UNIFIED IDEOGRAPH-4E9F
        0x9F10, # G+4724  U+9F10  uni9F10,  CJK UNIFIED IDEOGRAPH-9F10
        0x4E5C, # G+4725  U+4E5C  uni4E5C,  CJK UNIFIED IDEOGRAPH-4E5C
        0x4E69, # G+4726  U+4E69  uni4E69,  CJK UNIFIED IDEOGRAPH-4E69
        0x4E93, # G+4727  U+4E93  uni4E93,  CJK UNIFIED IDEOGRAPH-4E93
        0x8288, # G+4728  U+8288  uni8288,  CJK UNIFIED IDEOGRAPH-8288
        0x5B5B, # G+4729  U+5B5B  uni5B5B,  CJK UNIFIED IDEOGRAPH-5B5B
        0x556C, # G+4730  U+556C  uni556C,  CJK UNIFIED IDEOGRAPH-556C
        0x560F, # G+4731  U+560F  uni560F,  CJK UNIFIED IDEOGRAPH-560F
        0x4EC4, # G+4732  U+4EC4  uni4EC4,  CJK UNIFIED IDEOGRAPH-4EC4
        0x538D, # G+4733  U+538D  uni538D,  CJK UNIFIED IDEOGRAPH-538D
        0x539D, # G+4734  U+539D  uni539D,  CJK UNIFIED IDEOGRAPH-539D
        0x53A3, # G+4735  U+53A3  uni53A3,  CJK UNIFIED IDEOGRAPH-53A3
        0x53A5, # G+4736  U+53A5  uni53A5,  CJK UNIFIED IDEOGRAPH-53A5
        0x53AE, # G+4737  U+53AE  uni53AE,  CJK UNIFIED IDEOGRAPH-53AE
        0x9765, # G+4738  U+9765  uni9765,  CJK UNIFIED IDEOGRAPH-9765
        0x8D5D, # G+4739  U+8D5D  uni8D5D,  CJK UNIFIED IDEOGRAPH-8D5D
        0x2F15, # G+4740  U+2F15  uni2F15,  KANGXI RADICAL RIGHT OPEN BOX
        0x53F5, # G+4741  U+53F5  uni53F5,  CJK UNIFIED IDEOGRAPH-53F5
        0x5326, # G+4742  U+5326  uni5326,  CJK UNIFIED IDEOGRAPH-5326
        0x532E, # G+4743  U+532E  uni532E,  CJK UNIFIED IDEOGRAPH-532E
        0x533E, # G+4744  U+533E  uni533E,  CJK UNIFIED IDEOGRAPH-533E
        0x8D5C, # G+4745  U+8D5C  uni8D5C,  CJK UNIFIED IDEOGRAPH-8D5C
        0x5366, # G+4746  U+5366  uni5366,  CJK UNIFIED IDEOGRAPH-5366
        0x5363, # G+4747  U+5363  uni5363,  CJK UNIFIED IDEOGRAPH-5363
        0x5202, # G+4748  U+5202  uni5202,  CJK UNIFIED IDEOGRAPH-5202
        0x5208, # G+4749  U+5208  uni5208,  CJK UNIFIED IDEOGRAPH-5208
        0x520E, # G+4750  U+520E  uni520E,  CJK UNIFIED IDEOGRAPH-520E
        0x522D, # G+4751  U+522D  uni522D,  CJK UNIFIED IDEOGRAPH-522D
        0x5233, # G+4752  U+5233  uni5233,  CJK UNIFIED IDEOGRAPH-5233
        0x523F, # G+4753  U+523F  uni523F,  CJK UNIFIED IDEOGRAPH-523F
        0x5240, # G+4754  U+5240  uni5240,  CJK UNIFIED IDEOGRAPH-5240
        0x524C, # G+4755  U+524C  uni524C,  CJK UNIFIED IDEOGRAPH-524C
        0x525E, # G+4756  U+525E  uni525E,  CJK UNIFIED IDEOGRAPH-525E
        0x5261, # G+4757  U+5261  uni5261,  CJK UNIFIED IDEOGRAPH-5261
        0x525C, # G+4758  U+525C  uni525C,  CJK UNIFIED IDEOGRAPH-525C
        0x84AF, # G+4759  U+84AF  uni84AF,  CJK UNIFIED IDEOGRAPH-84AF
        0x527D, # G+4760  U+527D  uni527D,  CJK UNIFIED IDEOGRAPH-527D
        0x5282, # G+4761  U+5282  uni5282,  CJK UNIFIED IDEOGRAPH-5282
        0x5281, # G+4762  U+5281  uni5281,  CJK UNIFIED IDEOGRAPH-5281
        0x5290, # G+4763  U+5290  uni5290,  CJK UNIFIED IDEOGRAPH-5290
        0x5293, # G+4764  U+5293  uni5293,  CJK UNIFIED IDEOGRAPH-5293
        0x2F0C, # G+4765  U+2F0C  uni2F0C,  KANGXI RADICAL DOWN BOX
        0x7F54, # G+4766  U+7F54  uni7F54,  CJK UNIFIED IDEOGRAPH-7F54
        0x4EBB, # G+4767  U+4EBB  uni4EBB,  CJK UNIFIED IDEOGRAPH-4EBB
        0x4EC3, # G+4768  U+4EC3  uni4EC3,  CJK UNIFIED IDEOGRAPH-4EC3
        0x4EC9, # G+4769  U+4EC9  uni4EC9,  CJK UNIFIED IDEOGRAPH-4EC9
        0x4EC2, # G+4770  U+4EC2  uni4EC2,  CJK UNIFIED IDEOGRAPH-4EC2
        0x4EE8, # G+4771  U+4EE8  uni4EE8,  CJK UNIFIED IDEOGRAPH-4EE8
        0x4EE1, # G+4772  U+4EE1  uni4EE1,  CJK UNIFIED IDEOGRAPH-4EE1
        0x4EEB, # G+4773  U+4EEB  uni4EEB,  CJK UNIFIED IDEOGRAPH-4EEB
        0x4EDE, # G+4774  U+4EDE  uni4EDE,  CJK UNIFIED IDEOGRAPH-4EDE
        0x4F1B, # G+4775  U+4F1B  uni4F1B,  CJK UNIFIED IDEOGRAPH-4F1B
        0x4EF3, # G+4776  U+4EF3  uni4EF3,  CJK UNIFIED IDEOGRAPH-4EF3
        0x4F22, # G+4777  U+4F22  uni4F22,  CJK UNIFIED IDEOGRAPH-4F22
        0x4F64, # G+4778  U+4F64  uni4F64,  CJK UNIFIED IDEOGRAPH-4F64
        0x4EF5, # G+4779  U+4EF5  uni4EF5,  CJK UNIFIED IDEOGRAPH-4EF5
        0x4F25, # G+4780  U+4F25  uni4F25,  CJK UNIFIED IDEOGRAPH-4F25
        0x4F27, # G+4781  U+4F27  uni4F27,  CJK UNIFIED IDEOGRAPH-4F27
        0x4F09, # G+4782  U+4F09  uni4F09,  CJK UNIFIED IDEOGRAPH-4F09
        0x4F2B, # G+4783  U+4F2B  uni4F2B,  CJK UNIFIED IDEOGRAPH-4F2B
        0x4F5E, # G+4784  U+4F5E  uni4F5E,  CJK UNIFIED IDEOGRAPH-4F5E
        0x4F67, # G+4785  U+4F67  uni4F67,  CJK UNIFIED IDEOGRAPH-4F67
        0x6538, # G+4786  U+6538  uni6538,  CJK UNIFIED IDEOGRAPH-6538
        0x4F5A, # G+4787  U+4F5A  uni4F5A,  CJK UNIFIED IDEOGRAPH-4F5A
        0x4F5D, # G+4788  U+4F5D  uni4F5D,  CJK UNIFIED IDEOGRAPH-4F5D
        0x4F5F, # G+4789  U+4F5F  uni4F5F,  CJK UNIFIED IDEOGRAPH-4F5F
        0x4F57, # G+4790  U+4F57  uni4F57,  CJK UNIFIED IDEOGRAPH-4F57
        0x4F32, # G+4791  U+4F32  uni4F32,  CJK UNIFIED IDEOGRAPH-4F32
        0x4F3D, # G+4792  U+4F3D  uni4F3D,  CJK UNIFIED IDEOGRAPH-4F3D
        0x4F76, # G+4793  U+4F76  uni4F76,  CJK UNIFIED IDEOGRAPH-4F76
        0x4F74, # G+4794  U+4F74  uni4F74,  CJK UNIFIED IDEOGRAPH-4F74
        0x4F91, # G+4795  U+4F91  uni4F91,  CJK UNIFIED IDEOGRAPH-4F91
        0x4F89, # G+4796  U+4F89  uni4F89,  CJK UNIFIED IDEOGRAPH-4F89
        0x4F83, # G+4797  U+4F83  uni4F83,  CJK UNIFIED IDEOGRAPH-4F83
        0x4F8F, # G+4798  U+4F8F  uni4F8F,  CJK UNIFIED IDEOGRAPH-4F8F
        0x4F7E, # G+4799  U+4F7E  uni4F7E,  CJK UNIFIED IDEOGRAPH-4F7E
        0x4F7B, # G+4800  U+4F7B  uni4F7B,  CJK UNIFIED IDEOGRAPH-4F7B
        0x4FAA, # G+4801  U+4FAA  uni4FAA,  CJK UNIFIED IDEOGRAPH-4FAA
        0x4F7C, # G+4802  U+4F7C  uni4F7C,  CJK UNIFIED IDEOGRAPH-4F7C
        0x4FAC, # G+4803  U+4FAC  uni4FAC,  CJK UNIFIED IDEOGRAPH-4FAC
        0x4F94, # G+4804  U+4F94  uni4F94,  CJK UNIFIED IDEOGRAPH-4F94
        0x4FE6, # G+4805  U+4FE6  uni4FE6,  CJK UNIFIED IDEOGRAPH-4FE6
        0x4FE8, # G+4806  U+4FE8  uni4FE8,  CJK UNIFIED IDEOGRAPH-4FE8
        0x4FEA, # G+4807  U+4FEA  uni4FEA,  CJK UNIFIED IDEOGRAPH-4FEA
        0x4FC5, # G+4808  U+4FC5  uni4FC5,  CJK UNIFIED IDEOGRAPH-4FC5
        0x4FDA, # G+4809  U+4FDA  uni4FDA,  CJK UNIFIED IDEOGRAPH-4FDA
        0x4FE3, # G+4810  U+4FE3  uni4FE3,  CJK UNIFIED IDEOGRAPH-4FE3
        0x4FDC, # G+4811  U+4FDC  uni4FDC,  CJK UNIFIED IDEOGRAPH-4FDC
        0x4FD1, # G+4812  U+4FD1  uni4FD1,  CJK UNIFIED IDEOGRAPH-4FD1
        0x4FDF, # G+4813  U+4FDF  uni4FDF,  CJK UNIFIED IDEOGRAPH-4FDF
        0x4FF8, # G+4814  U+4FF8  uni4FF8,  CJK UNIFIED IDEOGRAPH-4FF8
        0x5029, # G+4815  U+5029  uni5029,  CJK UNIFIED IDEOGRAPH-5029
        0x504C, # G+4816  U+504C  uni504C,  CJK UNIFIED IDEOGRAPH-504C
        0x4FF3, # G+4817  U+4FF3  uni4FF3,  CJK UNIFIED IDEOGRAPH-4FF3
        0x502C, # G+4818  U+502C  uni502C,  CJK UNIFIED IDEOGRAPH-502C
        0x500F, # G+4819  U+500F  uni500F,  CJK UNIFIED IDEOGRAPH-500F
        0x502E, # G+4820  U+502E  uni502E,  CJK UNIFIED IDEOGRAPH-502E
        0x502D, # G+4821  U+502D  uni502D,  CJK UNIFIED IDEOGRAPH-502D
        0x4FFE, # G+4822  U+4FFE  uni4FFE,  CJK UNIFIED IDEOGRAPH-4FFE
        0x501C, # G+4823  U+501C  uni501C,  CJK UNIFIED IDEOGRAPH-501C
        0x500C, # G+4824  U+500C  uni500C,  CJK UNIFIED IDEOGRAPH-500C
        0x5025, # G+4825  U+5025  uni5025,  CJK UNIFIED IDEOGRAPH-5025
        0x5028, # G+4826  U+5028  uni5028,  CJK UNIFIED IDEOGRAPH-5028
        0x507E, # G+4827  U+507E  uni507E,  CJK UNIFIED IDEOGRAPH-507E
        0x5043, # G+4828  U+5043  uni5043,  CJK UNIFIED IDEOGRAPH-5043
        0x5055, # G+4829  U+5055  uni5055,  CJK UNIFIED IDEOGRAPH-5055
        0x5048, # G+4830  U+5048  uni5048,  CJK UNIFIED IDEOGRAPH-5048
        0x504E, # G+4831  U+504E  uni504E,  CJK UNIFIED IDEOGRAPH-504E
        0x506C, # G+4832  U+506C  uni506C,  CJK UNIFIED IDEOGRAPH-506C
        0x507B, # G+4833  U+507B  uni507B,  CJK UNIFIED IDEOGRAPH-507B
        0x50A5, # G+4834  U+50A5  uni50A5,  CJK UNIFIED IDEOGRAPH-50A5
        0x50A7, # G+4835  U+50A7  uni50A7,  CJK UNIFIED IDEOGRAPH-50A7
        0x50A9, # G+4836  U+50A9  uni50A9,  CJK UNIFIED IDEOGRAPH-50A9
        0x50BA, # G+4837  U+50BA  uni50BA,  CJK UNIFIED IDEOGRAPH-50BA
        0x50D6, # G+4838  U+50D6  uni50D6,  CJK UNIFIED IDEOGRAPH-50D6
        0x5106, # G+4839  U+5106  uni5106,  CJK UNIFIED IDEOGRAPH-5106
        0x50ED, # G+4840  U+50ED  uni50ED,  CJK UNIFIED IDEOGRAPH-50ED
        0x50EC, # G+4841  U+50EC  uni50EC,  CJK UNIFIED IDEOGRAPH-50EC
        0x50E6, # G+4842  U+50E6  uni50E6,  CJK UNIFIED IDEOGRAPH-50E6
        0x50EE, # G+4843  U+50EE  uni50EE,  CJK UNIFIED IDEOGRAPH-50EE
        0x5107, # G+4844  U+5107  uni5107,  CJK UNIFIED IDEOGRAPH-5107
        0x510B, # G+4845  U+510B  uni510B,  CJK UNIFIED IDEOGRAPH-510B
        0x4EDD, # G+4846  U+4EDD  uni4EDD,  CJK UNIFIED IDEOGRAPH-4EDD
        0x6C3D, # G+4847  U+6C3D  uni6C3D,  CJK UNIFIED IDEOGRAPH-6C3D
        0x4F58, # G+4848  U+4F58  uni4F58,  CJK UNIFIED IDEOGRAPH-4F58
        0x4F65, # G+4849  U+4F65  uni4F65,  CJK UNIFIED IDEOGRAPH-4F65
        0x4FCE, # G+4850  U+4FCE  uni4FCE,  CJK UNIFIED IDEOGRAPH-4FCE
        0x2FD5, # G+4851  U+2FD5  uni2FD5,  KANGXI RADICAL FLUTE
        0x6C46, # G+4852  U+6C46  uni6C46,  CJK UNIFIED IDEOGRAPH-6C46
        0x7C74, # G+4853  U+7C74  uni7C74,  CJK UNIFIED IDEOGRAPH-7C74
        0x516E, # G+4854  U+516E  uni516E,  CJK UNIFIED IDEOGRAPH-516E
        0x5DFD, # G+4855  U+5DFD  uni5DFD,  CJK UNIFIED IDEOGRAPH-5DFD
        0x9EC9, # G+4856  U+9EC9  uni9EC9,  CJK UNIFIED IDEOGRAPH-9EC9
        0x9998, # G+4857  U+9998  uni9998,  CJK UNIFIED IDEOGRAPH-9998
        0x5181, # G+4858  U+5181  uni5181,  CJK UNIFIED IDEOGRAPH-5181
        0x5914, # G+4859  U+5914  uni5914,  CJK UNIFIED IDEOGRAPH-5914
        0x2F13, # G+4860  U+2F13  uni2F13,  KANGXI RADICAL WRAP
        0x530D, # G+4861  U+530D  uni530D,  CJK UNIFIED IDEOGRAPH-530D
        0x8A07, # G+4862  U+8A07  uni8A07,  CJK UNIFIED IDEOGRAPH-8A07
        0x5310, # G+4863  U+5310  uni5310,  CJK UNIFIED IDEOGRAPH-5310
        0x51EB, # G+4864  U+51EB  uni51EB,  CJK UNIFIED IDEOGRAPH-51EB
        0x5919, # G+4865  U+5919  uni5919,  CJK UNIFIED IDEOGRAPH-5919
        0x5155, # G+4866  U+5155  uni5155,  CJK UNIFIED IDEOGRAPH-5155
        0x2F07, # G+4867  U+2F07  uni2F07,  KANGXI RADICAL LID
        0x5156, # G+4868  U+5156  uni5156,  CJK UNIFIED IDEOGRAPH-5156
        0x4EB3, # G+4869  U+4EB3  uni4EB3,  CJK UNIFIED IDEOGRAPH-4EB3
        0x886E, # G+4870  U+886E  uni886E,  CJK UNIFIED IDEOGRAPH-886E
        0x88A4, # G+4871  U+88A4  uni88A4,  CJK UNIFIED IDEOGRAPH-88A4
        0x4EB5, # G+4872  U+4EB5  uni4EB5,  CJK UNIFIED IDEOGRAPH-4EB5
        0x8114, # G+4873  U+8114  uni8114,  CJK UNIFIED IDEOGRAPH-8114
        0x88D2, # G+4874  U+88D2  uni88D2,  CJK UNIFIED IDEOGRAPH-88D2
        0x7980, # G+4875  U+7980  uni7980,  CJK UNIFIED IDEOGRAPH-7980
        0x5B34, # G+4876  U+5B34  uni5B34,  CJK UNIFIED IDEOGRAPH-5B34
        0x8803, # G+4877  U+8803  uni8803,  CJK UNIFIED IDEOGRAPH-8803
        0x7FB8, # G+4878  U+7FB8  uni7FB8,  CJK UNIFIED IDEOGRAPH-7FB8
        0x2F0E, # G+4879  U+2F0E  uni2F0E,  KANGXI RADICAL ICE
        0x51B1, # G+4880  U+51B1  uni51B1,  CJK UNIFIED IDEOGRAPH-51B1
        0x51BD, # G+4881  U+51BD  uni51BD,  CJK UNIFIED IDEOGRAPH-51BD
        0x51BC, # G+4882  U+51BC  uni51BC,  CJK UNIFIED IDEOGRAPH-51BC
        0x51C7, # G+4883  U+51C7  uni51C7,  CJK UNIFIED IDEOGRAPH-51C7
        0x2F0D, # G+4884  U+2F0D  uni2F0D,  KANGXI RADICAL COVER
        0x51A2, # G+4885  U+51A2  uni51A2,  CJK UNIFIED IDEOGRAPH-51A2
        0x51A5, # G+4886  U+51A5  uni51A5,  CJK UNIFIED IDEOGRAPH-51A5
        0x8BA0, # G+4887  U+8BA0  uni8BA0,  CJK UNIFIED IDEOGRAPH-8BA0
        0x8BA6, # G+4888  U+8BA6  uni8BA6,  CJK UNIFIED IDEOGRAPH-8BA6
        0x8BA7, # G+4889  U+8BA7  uni8BA7,  CJK UNIFIED IDEOGRAPH-8BA7
        0x8BAA, # G+4890  U+8BAA  uni8BAA,  CJK UNIFIED IDEOGRAPH-8BAA
        0x8BB4, # G+4891  U+8BB4  uni8BB4,  CJK UNIFIED IDEOGRAPH-8BB4
        0x8BB5, # G+4892  U+8BB5  uni8BB5,  CJK UNIFIED IDEOGRAPH-8BB5
        0x8BB7, # G+4893  U+8BB7  uni8BB7,  CJK UNIFIED IDEOGRAPH-8BB7
        0x8BC2, # G+4894  U+8BC2  uni8BC2,  CJK UNIFIED IDEOGRAPH-8BC2
        0x8BC3, # G+4895  U+8BC3  uni8BC3,  CJK UNIFIED IDEOGRAPH-8BC3
        0x8BCB, # G+4896  U+8BCB  uni8BCB,  CJK UNIFIED IDEOGRAPH-8BCB
        0x8BCF, # G+4897  U+8BCF  uni8BCF,  CJK UNIFIED IDEOGRAPH-8BCF
        0x8BCE, # G+4898  U+8BCE  uni8BCE,  CJK UNIFIED IDEOGRAPH-8BCE
        0x8BD2, # G+4899  U+8BD2  uni8BD2,  CJK UNIFIED IDEOGRAPH-8BD2
        0x8BD3, # G+4900  U+8BD3  uni8BD3,  CJK UNIFIED IDEOGRAPH-8BD3
        0x8BD4, # G+4901  U+8BD4  uni8BD4,  CJK UNIFIED IDEOGRAPH-8BD4
        0x8BD6, # G+4902  U+8BD6  uni8BD6,  CJK UNIFIED IDEOGRAPH-8BD6
        0x8BD8, # G+4903  U+8BD8  uni8BD8,  CJK UNIFIED IDEOGRAPH-8BD8
        0x8BD9, # G+4904  U+8BD9  uni8BD9,  CJK UNIFIED IDEOGRAPH-8BD9
        0x8BDC, # G+4905  U+8BDC  uni8BDC,  CJK UNIFIED IDEOGRAPH-8BDC
        0x8BDF, # G+4906  U+8BDF  uni8BDF,  CJK UNIFIED IDEOGRAPH-8BDF
        0x8BE0, # G+4907  U+8BE0  uni8BE0,  CJK UNIFIED IDEOGRAPH-8BE0
        0x8BE4, # G+4908  U+8BE4  uni8BE4,  CJK UNIFIED IDEOGRAPH-8BE4
        0x8BE8, # G+4909  U+8BE8  uni8BE8,  CJK UNIFIED IDEOGRAPH-8BE8
        0x8BE9, # G+4910  U+8BE9  uni8BE9,  CJK UNIFIED IDEOGRAPH-8BE9
        0x8BEE, # G+4911  U+8BEE  uni8BEE,  CJK UNIFIED IDEOGRAPH-8BEE
        0x8BF0, # G+4912  U+8BF0  uni8BF0,  CJK UNIFIED IDEOGRAPH-8BF0
        0x8BF3, # G+4913  U+8BF3  uni8BF3,  CJK UNIFIED IDEOGRAPH-8BF3
        0x8BF6, # G+4914  U+8BF6  uni8BF6,  CJK UNIFIED IDEOGRAPH-8BF6
        0x8BF9, # G+4915  U+8BF9  uni8BF9,  CJK UNIFIED IDEOGRAPH-8BF9
        0x8BFC, # G+4916  U+8BFC  uni8BFC,  CJK UNIFIED IDEOGRAPH-8BFC
        0x8BFF, # G+4917  U+8BFF  uni8BFF,  CJK UNIFIED IDEOGRAPH-8BFF
        0x8C00, # G+4918  U+8C00  uni8C00,  CJK UNIFIED IDEOGRAPH-8C00
        0x8C02, # G+4919  U+8C02  uni8C02,  CJK UNIFIED IDEOGRAPH-8C02
        0x8C04, # G+4920  U+8C04  uni8C04,  CJK UNIFIED IDEOGRAPH-8C04
        0x8C07, # G+4921  U+8C07  uni8C07,  CJK UNIFIED IDEOGRAPH-8C07
        0x8C0C, # G+4922  U+8C0C  uni8C0C,  CJK UNIFIED IDEOGRAPH-8C0C
        0x8C0F, # G+4923  U+8C0F  uni8C0F,  CJK UNIFIED IDEOGRAPH-8C0F
        0x8C11, # G+4924  U+8C11  uni8C11,  CJK UNIFIED IDEOGRAPH-8C11
        0x8C12, # G+4925  U+8C12  uni8C12,  CJK UNIFIED IDEOGRAPH-8C12
        0x8C14, # G+4926  U+8C14  uni8C14,  CJK UNIFIED IDEOGRAPH-8C14
        0x8C15, # G+4927  U+8C15  uni8C15,  CJK UNIFIED IDEOGRAPH-8C15
        0x8C16, # G+4928  U+8C16  uni8C16,  CJK UNIFIED IDEOGRAPH-8C16
        0x8C19, # G+4929  U+8C19  uni8C19,  CJK UNIFIED IDEOGRAPH-8C19
        0x8C1B, # G+4930  U+8C1B  uni8C1B,  CJK UNIFIED IDEOGRAPH-8C1B
        0x8C18, # G+4931  U+8C18  uni8C18,  CJK UNIFIED IDEOGRAPH-8C18
        0x8C1D, # G+4932  U+8C1D  uni8C1D,  CJK UNIFIED IDEOGRAPH-8C1D
        0x8C1F, # G+4933  U+8C1F  uni8C1F,  CJK UNIFIED IDEOGRAPH-8C1F
        0x8C20, # G+4934  U+8C20  uni8C20,  CJK UNIFIED IDEOGRAPH-8C20
        0x8C21, # G+4935  U+8C21  uni8C21,  CJK UNIFIED IDEOGRAPH-8C21
        0x8C25, # G+4936  U+8C25  uni8C25,  CJK UNIFIED IDEOGRAPH-8C25
        0x8C27, # G+4937  U+8C27  uni8C27,  CJK UNIFIED IDEOGRAPH-8C27
        0x8C2A, # G+4938  U+8C2A  uni8C2A,  CJK UNIFIED IDEOGRAPH-8C2A
        0x8C2B, # G+4939  U+8C2B  uni8C2B,  CJK UNIFIED IDEOGRAPH-8C2B
        0x8C2E, # G+4940  U+8C2E  uni8C2E,  CJK UNIFIED IDEOGRAPH-8C2E
        0x8C2F, # G+4941  U+8C2F  uni8C2F,  CJK UNIFIED IDEOGRAPH-8C2F
        0x8C32, # G+4942  U+8C32  uni8C32,  CJK UNIFIED IDEOGRAPH-8C32
        0x8C33, # G+4943  U+8C33  uni8C33,  CJK UNIFIED IDEOGRAPH-8C33
        0x8C35, # G+4944  U+8C35  uni8C35,  CJK UNIFIED IDEOGRAPH-8C35
        0x8C36, # G+4945  U+8C36  uni8C36,  CJK UNIFIED IDEOGRAPH-8C36
        0x2F19, # G+4946  U+2F19  uni2F19,  KANGXI RADICAL SEAL
        0x537A, # G+4947  U+537A  uni537A,  CJK UNIFIED IDEOGRAPH-537A
        0x961D, # G+4948  U+961D  uni961D,  CJK UNIFIED IDEOGRAPH-961D
        0x9622, # G+4949  U+9622  uni9622,  CJK UNIFIED IDEOGRAPH-9622
        0x9621, # G+4950  U+9621  uni9621,  CJK UNIFIED IDEOGRAPH-9621
        0x9631, # G+4951  U+9631  uni9631,  CJK UNIFIED IDEOGRAPH-9631
        0x962A, # G+4952  U+962A  uni962A,  CJK UNIFIED IDEOGRAPH-962A
        0x963D, # G+4953  U+963D  uni963D,  CJK UNIFIED IDEOGRAPH-963D
        0x963C, # G+4954  U+963C  uni963C,  CJK UNIFIED IDEOGRAPH-963C
        0x9642, # G+4955  U+9642  uni9642,  CJK UNIFIED IDEOGRAPH-9642
        0x9649, # G+4956  U+9649  uni9649,  CJK UNIFIED IDEOGRAPH-9649
        0x9654, # G+4957  U+9654  uni9654,  CJK UNIFIED IDEOGRAPH-9654
        0x965F, # G+4958  U+965F  uni965F,  CJK UNIFIED IDEOGRAPH-965F
        0x9667, # G+4959  U+9667  uni9667,  CJK UNIFIED IDEOGRAPH-9667
        0x966C, # G+4960  U+966C  uni966C,  CJK UNIFIED IDEOGRAPH-966C
        0x9672, # G+4961  U+9672  uni9672,  CJK UNIFIED IDEOGRAPH-9672
        0x9674, # G+4962  U+9674  uni9674,  CJK UNIFIED IDEOGRAPH-9674
        0x9688, # G+4963  U+9688  uni9688,  CJK UNIFIED IDEOGRAPH-9688
        0x968D, # G+4964  U+968D  uni968D,  CJK UNIFIED IDEOGRAPH-968D
        0x9697, # G+4965  U+9697  uni9697,  CJK UNIFIED IDEOGRAPH-9697
        0x96B0, # G+4966  U+96B0  uni96B0,  CJK UNIFIED IDEOGRAPH-96B0
        0x9097, # G+4967  U+9097  uni9097,  CJK UNIFIED IDEOGRAPH-9097
        0x909B, # G+4968  U+909B  uni909B,  CJK UNIFIED IDEOGRAPH-909B
        0x909D, # G+4969  U+909D  uni909D,  CJK UNIFIED IDEOGRAPH-909D
        0x9099, # G+4970  U+9099  uni9099,  CJK UNIFIED IDEOGRAPH-9099
        0x90AC, # G+4971  U+90AC  uni90AC,  CJK UNIFIED IDEOGRAPH-90AC
        0x90A1, # G+4972  U+90A1  uni90A1,  CJK UNIFIED IDEOGRAPH-90A1
        0x90B4, # G+4973  U+90B4  uni90B4,  CJK UNIFIED IDEOGRAPH-90B4
        0x90B3, # G+4974  U+90B3  uni90B3,  CJK UNIFIED IDEOGRAPH-90B3
        0x90B6, # G+4975  U+90B6  uni90B6,  CJK UNIFIED IDEOGRAPH-90B6
        0x90BA, # G+4976  U+90BA  uni90BA,  CJK UNIFIED IDEOGRAPH-90BA
        0x90B8, # G+4977  U+90B8  uni90B8,  CJK UNIFIED IDEOGRAPH-90B8
        0x90B0, # G+4978  U+90B0  uni90B0,  CJK UNIFIED IDEOGRAPH-90B0
        0x90CF, # G+4979  U+90CF  uni90CF,  CJK UNIFIED IDEOGRAPH-90CF
        0x90C5, # G+4980  U+90C5  uni90C5,  CJK UNIFIED IDEOGRAPH-90C5
        0x90BE, # G+4981  U+90BE  uni90BE,  CJK UNIFIED IDEOGRAPH-90BE
        0x90D0, # G+4982  U+90D0  uni90D0,  CJK UNIFIED IDEOGRAPH-90D0
        0x90C4, # G+4983  U+90C4  uni90C4,  CJK UNIFIED IDEOGRAPH-90C4
        0x90C7, # G+4984  U+90C7  uni90C7,  CJK UNIFIED IDEOGRAPH-90C7
        0x90D3, # G+4985  U+90D3  uni90D3,  CJK UNIFIED IDEOGRAPH-90D3
        0x90E6, # G+4986  U+90E6  uni90E6,  CJK UNIFIED IDEOGRAPH-90E6
        0x90E2, # G+4987  U+90E2  uni90E2,  CJK UNIFIED IDEOGRAPH-90E2
        0x90DC, # G+4988  U+90DC  uni90DC,  CJK UNIFIED IDEOGRAPH-90DC
        0x90D7, # G+4989  U+90D7  uni90D7,  CJK UNIFIED IDEOGRAPH-90D7
        0x90DB, # G+4990  U+90DB  uni90DB,  CJK UNIFIED IDEOGRAPH-90DB
        0x90EB, # G+4991  U+90EB  uni90EB,  CJK UNIFIED IDEOGRAPH-90EB
        0x90EF, # G+4992  U+90EF  uni90EF,  CJK UNIFIED IDEOGRAPH-90EF
        0x90FE, # G+4993  U+90FE  uni90FE,  CJK UNIFIED IDEOGRAPH-90FE
        0x9104, # G+4994  U+9104  uni9104,  CJK UNIFIED IDEOGRAPH-9104
        0x9122, # G+4995  U+9122  uni9122,  CJK UNIFIED IDEOGRAPH-9122
        0x911E, # G+4996  U+911E  uni911E,  CJK UNIFIED IDEOGRAPH-911E
        0x9123, # G+4997  U+9123  uni9123,  CJK UNIFIED IDEOGRAPH-9123
        0x9131, # G+4998  U+9131  uni9131,  CJK UNIFIED IDEOGRAPH-9131
        0x912F, # G+4999  U+912F  uni912F,  CJK UNIFIED IDEOGRAPH-912F
        0x9139, # G+5000  U+9139  uni9139,  CJK UNIFIED IDEOGRAPH-9139
        0x9143, # G+5001  U+9143  uni9143,  CJK UNIFIED IDEOGRAPH-9143
        0x9146, # G+5002  U+9146  uni9146,  CJK UNIFIED IDEOGRAPH-9146
        0x520D, # G+5003  U+520D  uni520D,  CJK UNIFIED IDEOGRAPH-520D
        0x5942, # G+5004  U+5942  uni5942,  CJK UNIFIED IDEOGRAPH-5942
        0x52A2, # G+5005  U+52A2  uni52A2,  CJK UNIFIED IDEOGRAPH-52A2
        0x52AC, # G+5006  U+52AC  uni52AC,  CJK UNIFIED IDEOGRAPH-52AC
        0x52AD, # G+5007  U+52AD  uni52AD,  CJK UNIFIED IDEOGRAPH-52AD
        0x52BE, # G+5008  U+52BE  uni52BE,  CJK UNIFIED IDEOGRAPH-52BE
        0x54FF, # G+5009  U+54FF  uni54FF,  CJK UNIFIED IDEOGRAPH-54FF
        0x52D0, # G+5010  U+52D0  uni52D0,  CJK UNIFIED IDEOGRAPH-52D0
        0x52D6, # G+5011  U+52D6  uni52D6,  CJK UNIFIED IDEOGRAPH-52D6
        0x52F0, # G+5012  U+52F0  uni52F0,  CJK UNIFIED IDEOGRAPH-52F0
        0x53DF, # G+5013  U+53DF  uni53DF,  CJK UNIFIED IDEOGRAPH-53DF
        0x71EE, # G+5014  U+71EE  uni71EE,  CJK UNIFIED IDEOGRAPH-71EE
        0x77CD, # G+5015  U+77CD  uni77CD,  CJK UNIFIED IDEOGRAPH-77CD
        0x2F35, # G+5016  U+2F35  uni2F35,  KANGXI RADICAL LONG STRIDE
        0x2F10, # G+5017  U+2F10  uni2F10,  KANGXI RADICAL OPEN BOX
        0x51FC, # G+5018  U+51FC  uni51FC,  CJK UNIFIED IDEOGRAPH-51FC
        0x2FBF, # G+5019  U+2FBF  uni2FBF,  KANGXI RADICAL SACRIFICIAL WINE
        0x2F1B, # G+5020  U+2F1B  uni2F1B,  KANGXI RADICAL PRIVATE
        0x5F01, # G+5021  U+5F01  uni5F01,  CJK UNIFIED IDEOGRAPH-5F01
        0x755A, # G+5022  U+755A  uni755A,  CJK UNIFIED IDEOGRAPH-755A
        0x5DEF, # G+5023  U+5DEF  uni5DEF,  CJK UNIFIED IDEOGRAPH-5DEF
        0x574C, # G+5024  U+574C  uni574C,  CJK UNIFIED IDEOGRAPH-574C
        0x57A9, # G+5025  U+57A9  uni57A9,  CJK UNIFIED IDEOGRAPH-57A9
        0x57A1, # G+5026  U+57A1  uni57A1,  CJK UNIFIED IDEOGRAPH-57A1
        0x587E, # G+5027  U+587E  uni587E,  CJK UNIFIED IDEOGRAPH-587E
        0x58BC, # G+5028  U+58BC  uni58BC,  CJK UNIFIED IDEOGRAPH-58BC
        0x58C5, # G+5029  U+58C5  uni58C5,  CJK UNIFIED IDEOGRAPH-58C5
        0x58D1, # G+5030  U+58D1  uni58D1,  CJK UNIFIED IDEOGRAPH-58D1
        0x5729, # G+5031  U+5729  uni5729,  CJK UNIFIED IDEOGRAPH-5729
        0x572C, # G+5032  U+572C  uni572C,  CJK UNIFIED IDEOGRAPH-572C
        0x572A, # G+5033  U+572A  uni572A,  CJK UNIFIED IDEOGRAPH-572A
        0x5733, # G+5034  U+5733  uni5733,  CJK UNIFIED IDEOGRAPH-5733
        0x5739, # G+5035  U+5739  uni5739,  CJK UNIFIED IDEOGRAPH-5739
        0x572E, # G+5036  U+572E  uni572E,  CJK UNIFIED IDEOGRAPH-572E
        0x572F, # G+5037  U+572F  uni572F,  CJK UNIFIED IDEOGRAPH-572F
        0x575C, # G+5038  U+575C  uni575C,  CJK UNIFIED IDEOGRAPH-575C
        0x573B, # G+5039  U+573B  uni573B,  CJK UNIFIED IDEOGRAPH-573B
        0x5742, # G+5040  U+5742  uni5742,  CJK UNIFIED IDEOGRAPH-5742
        0x5769, # G+5041  U+5769  uni5769,  CJK UNIFIED IDEOGRAPH-5769
        0x5785, # G+5042  U+5785  uni5785,  CJK UNIFIED IDEOGRAPH-5785
        0x576B, # G+5043  U+576B  uni576B,  CJK UNIFIED IDEOGRAPH-576B
        0x5786, # G+5044  U+5786  uni5786,  CJK UNIFIED IDEOGRAPH-5786
        0x577C, # G+5045  U+577C  uni577C,  CJK UNIFIED IDEOGRAPH-577C
        0x577B, # G+5046  U+577B  uni577B,  CJK UNIFIED IDEOGRAPH-577B
        0x5768, # G+5047  U+5768  uni5768,  CJK UNIFIED IDEOGRAPH-5768
        0x576D, # G+5048  U+576D  uni576D,  CJK UNIFIED IDEOGRAPH-576D
        0x5776, # G+5049  U+5776  uni5776,  CJK UNIFIED IDEOGRAPH-5776
        0x5773, # G+5050  U+5773  uni5773,  CJK UNIFIED IDEOGRAPH-5773
        0x57AD, # G+5051  U+57AD  uni57AD,  CJK UNIFIED IDEOGRAPH-57AD
        0x57A4, # G+5052  U+57A4  uni57A4,  CJK UNIFIED IDEOGRAPH-57A4
        0x578C, # G+5053  U+578C  uni578C,  CJK UNIFIED IDEOGRAPH-578C
        0x57B2, # G+5054  U+57B2  uni57B2,  CJK UNIFIED IDEOGRAPH-57B2
        0x57CF, # G+5055  U+57CF  uni57CF,  CJK UNIFIED IDEOGRAPH-57CF
        0x57A7, # G+5056  U+57A7  uni57A7,  CJK UNIFIED IDEOGRAPH-57A7
        0x57B4, # G+5057  U+57B4  uni57B4,  CJK UNIFIED IDEOGRAPH-57B4
        0x5793, # G+5058  U+5793  uni5793,  CJK UNIFIED IDEOGRAPH-5793
        0x57A0, # G+5059  U+57A0  uni57A0,  CJK UNIFIED IDEOGRAPH-57A0
        0x57D5, # G+5060  U+57D5  uni57D5,  CJK UNIFIED IDEOGRAPH-57D5
        0x57D8, # G+5061  U+57D8  uni57D8,  CJK UNIFIED IDEOGRAPH-57D8
        0x57DA, # G+5062  U+57DA  uni57DA,  CJK UNIFIED IDEOGRAPH-57DA
        0x57D9, # G+5063  U+57D9  uni57D9,  CJK UNIFIED IDEOGRAPH-57D9
        0x57D2, # G+5064  U+57D2  uni57D2,  CJK UNIFIED IDEOGRAPH-57D2
        0x57B8, # G+5065  U+57B8  uni57B8,  CJK UNIFIED IDEOGRAPH-57B8
        0x57F4, # G+5066  U+57F4  uni57F4,  CJK UNIFIED IDEOGRAPH-57F4
        0x57EF, # G+5067  U+57EF  uni57EF,  CJK UNIFIED IDEOGRAPH-57EF
        0x57F8, # G+5068  U+57F8  uni57F8,  CJK UNIFIED IDEOGRAPH-57F8
        0x57E4, # G+5069  U+57E4  uni57E4,  CJK UNIFIED IDEOGRAPH-57E4
        0x57DD, # G+5070  U+57DD  uni57DD,  CJK UNIFIED IDEOGRAPH-57DD
        0x580B, # G+5071  U+580B  uni580B,  CJK UNIFIED IDEOGRAPH-580B
        0x580D, # G+5072  U+580D  uni580D,  CJK UNIFIED IDEOGRAPH-580D
        0x57FD, # G+5073  U+57FD  uni57FD,  CJK UNIFIED IDEOGRAPH-57FD
        0x57ED, # G+5074  U+57ED  uni57ED,  CJK UNIFIED IDEOGRAPH-57ED
        0x5800, # G+5075  U+5800  uni5800,  CJK UNIFIED IDEOGRAPH-5800
        0x581E, # G+5076  U+581E  uni581E,  CJK UNIFIED IDEOGRAPH-581E
        0x5819, # G+5077  U+5819  uni5819,  CJK UNIFIED IDEOGRAPH-5819
        0x5844, # G+5078  U+5844  uni5844,  CJK UNIFIED IDEOGRAPH-5844
        0x5820, # G+5079  U+5820  uni5820,  CJK UNIFIED IDEOGRAPH-5820
        0x5865, # G+5080  U+5865  uni5865,  CJK UNIFIED IDEOGRAPH-5865
        0x586C, # G+5081  U+586C  uni586C,  CJK UNIFIED IDEOGRAPH-586C
        0x5881, # G+5082  U+5881  uni5881,  CJK UNIFIED IDEOGRAPH-5881
        0x5889, # G+5083  U+5889  uni5889,  CJK UNIFIED IDEOGRAPH-5889
        0x589A, # G+5084  U+589A  uni589A,  CJK UNIFIED IDEOGRAPH-589A
        0x5880, # G+5085  U+5880  uni5880,  CJK UNIFIED IDEOGRAPH-5880
        0x99A8, # G+5086  U+99A8  uni99A8,  CJK UNIFIED IDEOGRAPH-99A8
        0x9F19, # G+5087  U+9F19  uni9F19,  CJK UNIFIED IDEOGRAPH-9F19
        0x61FF, # G+5088  U+61FF  uni61FF,  CJK UNIFIED IDEOGRAPH-61FF
        0x8279, # G+5089  U+8279  uni8279,  CJK UNIFIED IDEOGRAPH-8279
        0x827D, # G+5090  U+827D  uni827D,  CJK UNIFIED IDEOGRAPH-827D
        0x827F, # G+5091  U+827F  uni827F,  CJK UNIFIED IDEOGRAPH-827F
        0x828F, # G+5092  U+828F  uni828F,  CJK UNIFIED IDEOGRAPH-828F
        0x828A, # G+5093  U+828A  uni828A,  CJK UNIFIED IDEOGRAPH-828A
        0x82A8, # G+5094  U+82A8  uni82A8,  CJK UNIFIED IDEOGRAPH-82A8
        0x8284, # G+5095  U+8284  uni8284,  CJK UNIFIED IDEOGRAPH-8284
        0x828E, # G+5096  U+828E  uni828E,  CJK UNIFIED IDEOGRAPH-828E
        0x8291, # G+5097  U+8291  uni8291,  CJK UNIFIED IDEOGRAPH-8291
        0x8297, # G+5098  U+8297  uni8297,  CJK UNIFIED IDEOGRAPH-8297
        0x8299, # G+5099  U+8299  uni8299,  CJK UNIFIED IDEOGRAPH-8299
        0x82AB, # G+5100  U+82AB  uni82AB,  CJK UNIFIED IDEOGRAPH-82AB
        0x82B8, # G+5101  U+82B8  uni82B8,  CJK UNIFIED IDEOGRAPH-82B8
        0x82BE, # G+5102  U+82BE  uni82BE,  CJK UNIFIED IDEOGRAPH-82BE
        0x82B0, # G+5103  U+82B0  uni82B0,  CJK UNIFIED IDEOGRAPH-82B0
        0x82C8, # G+5104  U+82C8  uni82C8,  CJK UNIFIED IDEOGRAPH-82C8
        0x82CA, # G+5105  U+82CA  uni82CA,  CJK UNIFIED IDEOGRAPH-82CA
        0x82E3, # G+5106  U+82E3  uni82E3,  CJK UNIFIED IDEOGRAPH-82E3
        0x8298, # G+5107  U+8298  uni8298,  CJK UNIFIED IDEOGRAPH-8298
        0x82B7, # G+5108  U+82B7  uni82B7,  CJK UNIFIED IDEOGRAPH-82B7
        0x82AE, # G+5109  U+82AE  uni82AE,  CJK UNIFIED IDEOGRAPH-82AE
        0x82CB, # G+5110  U+82CB  uni82CB,  CJK UNIFIED IDEOGRAPH-82CB
        0x82CC, # G+5111  U+82CC  uni82CC,  CJK UNIFIED IDEOGRAPH-82CC
        0x82C1, # G+5112  U+82C1  uni82C1,  CJK UNIFIED IDEOGRAPH-82C1
        0x82A9, # G+5113  U+82A9  uni82A9,  CJK UNIFIED IDEOGRAPH-82A9
        0x82B4, # G+5114  U+82B4  uni82B4,  CJK UNIFIED IDEOGRAPH-82B4
        0x82A1, # G+5115  U+82A1  uni82A1,  CJK UNIFIED IDEOGRAPH-82A1
        0x82AA, # G+5116  U+82AA  uni82AA,  CJK UNIFIED IDEOGRAPH-82AA
        0x829F, # G+5117  U+829F  uni829F,  CJK UNIFIED IDEOGRAPH-829F
        0x82C4, # G+5118  U+82C4  uni82C4,  CJK UNIFIED IDEOGRAPH-82C4
        0x82CE, # G+5119  U+82CE  uni82CE,  CJK UNIFIED IDEOGRAPH-82CE
        0x82A4, # G+5120  U+82A4  uni82A4,  CJK UNIFIED IDEOGRAPH-82A4
        0x82E1, # G+5121  U+82E1  uni82E1,  CJK UNIFIED IDEOGRAPH-82E1
        0x8309, # G+5122  U+8309  uni8309,  CJK UNIFIED IDEOGRAPH-8309
        0x82F7, # G+5123  U+82F7  uni82F7,  CJK UNIFIED IDEOGRAPH-82F7
        0x82E4, # G+5124  U+82E4  uni82E4,  CJK UNIFIED IDEOGRAPH-82E4
        0x830F, # G+5125  U+830F  uni830F,  CJK UNIFIED IDEOGRAPH-830F
        0x8307, # G+5126  U+8307  uni8307,  CJK UNIFIED IDEOGRAPH-8307
        0x82DC, # G+5127  U+82DC  uni82DC,  CJK UNIFIED IDEOGRAPH-82DC
        0x82F4, # G+5128  U+82F4  uni82F4,  CJK UNIFIED IDEOGRAPH-82F4
        0x82D2, # G+5129  U+82D2  uni82D2,  CJK UNIFIED IDEOGRAPH-82D2
        0x82D8, # G+5130  U+82D8  uni82D8,  CJK UNIFIED IDEOGRAPH-82D8
        0x830C, # G+5131  U+830C  uni830C,  CJK UNIFIED IDEOGRAPH-830C
        0x82FB, # G+5132  U+82FB  uni82FB,  CJK UNIFIED IDEOGRAPH-82FB
        0x82D3, # G+5133  U+82D3  uni82D3,  CJK UNIFIED IDEOGRAPH-82D3
        0x8311, # G+5134  U+8311  uni8311,  CJK UNIFIED IDEOGRAPH-8311
        0x831A, # G+5135  U+831A  uni831A,  CJK UNIFIED IDEOGRAPH-831A
        0x8306, # G+5136  U+8306  uni8306,  CJK UNIFIED IDEOGRAPH-8306
        0x8314, # G+5137  U+8314  uni8314,  CJK UNIFIED IDEOGRAPH-8314
        0x8315, # G+5138  U+8315  uni8315,  CJK UNIFIED IDEOGRAPH-8315
        0x82E0, # G+5139  U+82E0  uni82E0,  CJK UNIFIED IDEOGRAPH-82E0
        0x82D5, # G+5140  U+82D5  uni82D5,  CJK UNIFIED IDEOGRAPH-82D5
        0x831C, # G+5141  U+831C  uni831C,  CJK UNIFIED IDEOGRAPH-831C
        0x8351, # G+5142  U+8351  uni8351,  CJK UNIFIED IDEOGRAPH-8351
        0x835B, # G+5143  U+835B  uni835B,  CJK UNIFIED IDEOGRAPH-835B
        0x835C, # G+5144  U+835C  uni835C,  CJK UNIFIED IDEOGRAPH-835C
        0x8308, # G+5145  U+8308  uni8308,  CJK UNIFIED IDEOGRAPH-8308
        0x8392, # G+5146  U+8392  uni8392,  CJK UNIFIED IDEOGRAPH-8392
        0x833C, # G+5147  U+833C  uni833C,  CJK UNIFIED IDEOGRAPH-833C
        0x8334, # G+5148  U+8334  uni8334,  CJK UNIFIED IDEOGRAPH-8334
        0x8331, # G+5149  U+8331  uni8331,  CJK UNIFIED IDEOGRAPH-8331
        0x839B, # G+5150  U+839B  uni839B,  CJK UNIFIED IDEOGRAPH-839B
        0x835E, # G+5151  U+835E  uni835E,  CJK UNIFIED IDEOGRAPH-835E
        0x832F, # G+5152  U+832F  uni832F,  CJK UNIFIED IDEOGRAPH-832F
        0x834F, # G+5153  U+834F  uni834F,  CJK UNIFIED IDEOGRAPH-834F
        0x8347, # G+5154  U+8347  uni8347,  CJK UNIFIED IDEOGRAPH-8347
        0x8343, # G+5155  U+8343  uni8343,  CJK UNIFIED IDEOGRAPH-8343
        0x835F, # G+5156  U+835F  uni835F,  CJK UNIFIED IDEOGRAPH-835F
        0x8340, # G+5157  U+8340  uni8340,  CJK UNIFIED IDEOGRAPH-8340
        0x8317, # G+5158  U+8317  uni8317,  CJK UNIFIED IDEOGRAPH-8317
        0x8360, # G+5159  U+8360  uni8360,  CJK UNIFIED IDEOGRAPH-8360
        0x832D, # G+5160  U+832D  uni832D,  CJK UNIFIED IDEOGRAPH-832D
        0x833A, # G+5161  U+833A  uni833A,  CJK UNIFIED IDEOGRAPH-833A
        0x8333, # G+5162  U+8333  uni8333,  CJK UNIFIED IDEOGRAPH-8333
        0x8366, # G+5163  U+8366  uni8366,  CJK UNIFIED IDEOGRAPH-8366
        0x8365, # G+5164  U+8365  uni8365,  CJK UNIFIED IDEOGRAPH-8365
        0x8368, # G+5165  U+8368  uni8368,  CJK UNIFIED IDEOGRAPH-8368
        0x831B, # G+5166  U+831B  uni831B,  CJK UNIFIED IDEOGRAPH-831B
        0x8369, # G+5167  U+8369  uni8369,  CJK UNIFIED IDEOGRAPH-8369
        0x836C, # G+5168  U+836C  uni836C,  CJK UNIFIED IDEOGRAPH-836C
        0x836A, # G+5169  U+836A  uni836A,  CJK UNIFIED IDEOGRAPH-836A
        0x836D, # G+5170  U+836D  uni836D,  CJK UNIFIED IDEOGRAPH-836D
        0x836E, # G+5171  U+836E  uni836E,  CJK UNIFIED IDEOGRAPH-836E
        0x83B0, # G+5172  U+83B0  uni83B0,  CJK UNIFIED IDEOGRAPH-83B0
        0x8378, # G+5173  U+8378  uni8378,  CJK UNIFIED IDEOGRAPH-8378
        0x83B3, # G+5174  U+83B3  uni83B3,  CJK UNIFIED IDEOGRAPH-83B3
        0x83B4, # G+5175  U+83B4  uni83B4,  CJK UNIFIED IDEOGRAPH-83B4
        0x83A0, # G+5176  U+83A0  uni83A0,  CJK UNIFIED IDEOGRAPH-83A0
        0x83AA, # G+5177  U+83AA  uni83AA,  CJK UNIFIED IDEOGRAPH-83AA
        0x8393, # G+5178  U+8393  uni8393,  CJK UNIFIED IDEOGRAPH-8393
        0x839C, # G+5179  U+839C  uni839C,  CJK UNIFIED IDEOGRAPH-839C
        0x8385, # G+5180  U+8385  uni8385,  CJK UNIFIED IDEOGRAPH-8385
        0x837C, # G+5181  U+837C  uni837C,  CJK UNIFIED IDEOGRAPH-837C
        0x83B6, # G+5182  U+83B6  uni83B6,  CJK UNIFIED IDEOGRAPH-83B6
        0x83A9, # G+5183  U+83A9  uni83A9,  CJK UNIFIED IDEOGRAPH-83A9
        0x837D, # G+5184  U+837D  uni837D,  CJK UNIFIED IDEOGRAPH-837D
        0x83B8, # G+5185  U+83B8  uni83B8,  CJK UNIFIED IDEOGRAPH-83B8
        0x837B, # G+5186  U+837B  uni837B,  CJK UNIFIED IDEOGRAPH-837B
        0x8398, # G+5187  U+8398  uni8398,  CJK UNIFIED IDEOGRAPH-8398
        0x839E, # G+5188  U+839E  uni839E,  CJK UNIFIED IDEOGRAPH-839E
        0x83A8, # G+5189  U+83A8  uni83A8,  CJK UNIFIED IDEOGRAPH-83A8
        0x83BA, # G+5190  U+83BA  uni83BA,  CJK UNIFIED IDEOGRAPH-83BA
        0x83BC, # G+5191  U+83BC  uni83BC,  CJK UNIFIED IDEOGRAPH-83BC
        0x83C1, # G+5192  U+83C1  uni83C1,  CJK UNIFIED IDEOGRAPH-83C1
        0x8401, # G+5193  U+8401  uni8401,  CJK UNIFIED IDEOGRAPH-8401
        0x83E5, # G+5194  U+83E5  uni83E5,  CJK UNIFIED IDEOGRAPH-83E5
        0x83D8, # G+5195  U+83D8  uni83D8,  CJK UNIFIED IDEOGRAPH-83D8
        0x5807, # G+5196  U+5807  uni5807,  CJK UNIFIED IDEOGRAPH-5807
        0x8418, # G+5197  U+8418  uni8418,  CJK UNIFIED IDEOGRAPH-8418
        0x840B, # G+5198  U+840B  uni840B,  CJK UNIFIED IDEOGRAPH-840B
        0x83DD, # G+5199  U+83DD  uni83DD,  CJK UNIFIED IDEOGRAPH-83DD
        0x83FD, # G+5200  U+83FD  uni83FD,  CJK UNIFIED IDEOGRAPH-83FD
        0x83D6, # G+5201  U+83D6  uni83D6,  CJK UNIFIED IDEOGRAPH-83D6
        0x841C, # G+5202  U+841C  uni841C,  CJK UNIFIED IDEOGRAPH-841C
        0x8438, # G+5203  U+8438  uni8438,  CJK UNIFIED IDEOGRAPH-8438
        0x8411, # G+5204  U+8411  uni8411,  CJK UNIFIED IDEOGRAPH-8411
        0x8406, # G+5205  U+8406  uni8406,  CJK UNIFIED IDEOGRAPH-8406
        0x83D4, # G+5206  U+83D4  uni83D4,  CJK UNIFIED IDEOGRAPH-83D4
        0x83DF, # G+5207  U+83DF  uni83DF,  CJK UNIFIED IDEOGRAPH-83DF
        0x840F, # G+5208  U+840F  uni840F,  CJK UNIFIED IDEOGRAPH-840F
        0x8403, # G+5209  U+8403  uni8403,  CJK UNIFIED IDEOGRAPH-8403
        0x83F8, # G+5210  U+83F8  uni83F8,  CJK UNIFIED IDEOGRAPH-83F8
        0x83F9, # G+5211  U+83F9  uni83F9,  CJK UNIFIED IDEOGRAPH-83F9
        0x83EA, # G+5212  U+83EA  uni83EA,  CJK UNIFIED IDEOGRAPH-83EA
        0x83C5, # G+5213  U+83C5  uni83C5,  CJK UNIFIED IDEOGRAPH-83C5
        0x83C0, # G+5214  U+83C0  uni83C0,  CJK UNIFIED IDEOGRAPH-83C0
        0x8426, # G+5215  U+8426  uni8426,  CJK UNIFIED IDEOGRAPH-8426
        0x83F0, # G+5216  U+83F0  uni83F0,  CJK UNIFIED IDEOGRAPH-83F0
        0x83E1, # G+5217  U+83E1  uni83E1,  CJK UNIFIED IDEOGRAPH-83E1
        0x845C, # G+5218  U+845C  uni845C,  CJK UNIFIED IDEOGRAPH-845C
        0x8451, # G+5219  U+8451  uni8451,  CJK UNIFIED IDEOGRAPH-8451
        0x845A, # G+5220  U+845A  uni845A,  CJK UNIFIED IDEOGRAPH-845A
        0x8459, # G+5221  U+8459  uni8459,  CJK UNIFIED IDEOGRAPH-8459
        0x8473, # G+5222  U+8473  uni8473,  CJK UNIFIED IDEOGRAPH-8473
        0x8487, # G+5223  U+8487  uni8487,  CJK UNIFIED IDEOGRAPH-8487
        0x8488, # G+5224  U+8488  uni8488,  CJK UNIFIED IDEOGRAPH-8488
        0x847A, # G+5225  U+847A  uni847A,  CJK UNIFIED IDEOGRAPH-847A
        0x8489, # G+5226  U+8489  uni8489,  CJK UNIFIED IDEOGRAPH-8489
        0x8478, # G+5227  U+8478  uni8478,  CJK UNIFIED IDEOGRAPH-8478
        0x843C, # G+5228  U+843C  uni843C,  CJK UNIFIED IDEOGRAPH-843C
        0x8446, # G+5229  U+8446  uni8446,  CJK UNIFIED IDEOGRAPH-8446
        0x8469, # G+5230  U+8469  uni8469,  CJK UNIFIED IDEOGRAPH-8469
        0x8476, # G+5231  U+8476  uni8476,  CJK UNIFIED IDEOGRAPH-8476
        0x848C, # G+5232  U+848C  uni848C,  CJK UNIFIED IDEOGRAPH-848C
        0x848E, # G+5233  U+848E  uni848E,  CJK UNIFIED IDEOGRAPH-848E
        0x8431, # G+5234  U+8431  uni8431,  CJK UNIFIED IDEOGRAPH-8431
        0x846D, # G+5235  U+846D  uni846D,  CJK UNIFIED IDEOGRAPH-846D
        0x84C1, # G+5236  U+84C1  uni84C1,  CJK UNIFIED IDEOGRAPH-84C1
        0x84CD, # G+5237  U+84CD  uni84CD,  CJK UNIFIED IDEOGRAPH-84CD
        0x84D0, # G+5238  U+84D0  uni84D0,  CJK UNIFIED IDEOGRAPH-84D0
        0x84E6, # G+5239  U+84E6  uni84E6,  CJK UNIFIED IDEOGRAPH-84E6
        0x84BD, # G+5240  U+84BD  uni84BD,  CJK UNIFIED IDEOGRAPH-84BD
        0x84D3, # G+5241  U+84D3  uni84D3,  CJK UNIFIED IDEOGRAPH-84D3
        0x84CA, # G+5242  U+84CA  uni84CA,  CJK UNIFIED IDEOGRAPH-84CA
        0x84BF, # G+5243  U+84BF  uni84BF,  CJK UNIFIED IDEOGRAPH-84BF
        0x84BA, # G+5244  U+84BA  uni84BA,  CJK UNIFIED IDEOGRAPH-84BA
        0x84E0, # G+5245  U+84E0  uni84E0,  CJK UNIFIED IDEOGRAPH-84E0
        0x84A1, # G+5246  U+84A1  uni84A1,  CJK UNIFIED IDEOGRAPH-84A1
        0x84B9, # G+5247  U+84B9  uni84B9,  CJK UNIFIED IDEOGRAPH-84B9
        0x84B4, # G+5248  U+84B4  uni84B4,  CJK UNIFIED IDEOGRAPH-84B4
        0x8497, # G+5249  U+8497  uni8497,  CJK UNIFIED IDEOGRAPH-8497
        0x84E5, # G+5250  U+84E5  uni84E5,  CJK UNIFIED IDEOGRAPH-84E5
        0x84E3, # G+5251  U+84E3  uni84E3,  CJK UNIFIED IDEOGRAPH-84E3
        0x850C, # G+5252  U+850C  uni850C,  CJK UNIFIED IDEOGRAPH-850C
        0x750D, # G+5253  U+750D  uni750D,  CJK UNIFIED IDEOGRAPH-750D
        0x8538, # G+5254  U+8538  uni8538,  CJK UNIFIED IDEOGRAPH-8538
        0x84F0, # G+5255  U+84F0  uni84F0,  CJK UNIFIED IDEOGRAPH-84F0
        0x8539, # G+5256  U+8539  uni8539,  CJK UNIFIED IDEOGRAPH-8539
        0x851F, # G+5257  U+851F  uni851F,  CJK UNIFIED IDEOGRAPH-851F
        0x853A, # G+5258  U+853A  uni853A,  CJK UNIFIED IDEOGRAPH-853A
        0x8556, # G+5259  U+8556  uni8556,  CJK UNIFIED IDEOGRAPH-8556
        0x853B, # G+5260  U+853B  uni853B,  CJK UNIFIED IDEOGRAPH-853B
        0x84FF, # G+5261  U+84FF  uni84FF,  CJK UNIFIED IDEOGRAPH-84FF
        0x84FC, # G+5262  U+84FC  uni84FC,  CJK UNIFIED IDEOGRAPH-84FC
        0x8559, # G+5263  U+8559  uni8559,  CJK UNIFIED IDEOGRAPH-8559
        0x8548, # G+5264  U+8548  uni8548,  CJK UNIFIED IDEOGRAPH-8548
        0x8568, # G+5265  U+8568  uni8568,  CJK UNIFIED IDEOGRAPH-8568
        0x8564, # G+5266  U+8564  uni8564,  CJK UNIFIED IDEOGRAPH-8564
        0x855E, # G+5267  U+855E  uni855E,  CJK UNIFIED IDEOGRAPH-855E
        0x857A, # G+5268  U+857A  uni857A,  CJK UNIFIED IDEOGRAPH-857A
        0x77A2, # G+5269  U+77A2  uni77A2,  CJK UNIFIED IDEOGRAPH-77A2
        0x8543, # G+5270  U+8543  uni8543,  CJK UNIFIED IDEOGRAPH-8543
        0x8572, # G+5271  U+8572  uni8572,  CJK UNIFIED IDEOGRAPH-8572
        0x857B, # G+5272  U+857B  uni857B,  CJK UNIFIED IDEOGRAPH-857B
        0x85A4, # G+5273  U+85A4  uni85A4,  CJK UNIFIED IDEOGRAPH-85A4
        0x85A8, # G+5274  U+85A8  uni85A8,  CJK UNIFIED IDEOGRAPH-85A8
        0x8587, # G+5275  U+8587  uni8587,  CJK UNIFIED IDEOGRAPH-8587
        0x858F, # G+5276  U+858F  uni858F,  CJK UNIFIED IDEOGRAPH-858F
        0x8579, # G+5277  U+8579  uni8579,  CJK UNIFIED IDEOGRAPH-8579
        0x85AE, # G+5278  U+85AE  uni85AE,  CJK UNIFIED IDEOGRAPH-85AE
        0x859C, # G+5279  U+859C  uni859C,  CJK UNIFIED IDEOGRAPH-859C
        0x8585, # G+5280  U+8585  uni8585,  CJK UNIFIED IDEOGRAPH-8585
        0x85B9, # G+5281  U+85B9  uni85B9,  CJK UNIFIED IDEOGRAPH-85B9
        0x85B7, # G+5282  U+85B7  uni85B7,  CJK UNIFIED IDEOGRAPH-85B7
        0x85B0, # G+5283  U+85B0  uni85B0,  CJK UNIFIED IDEOGRAPH-85B0
        0x85D3, # G+5284  U+85D3  uni85D3,  CJK UNIFIED IDEOGRAPH-85D3
        0x85C1, # G+5285  U+85C1  uni85C1,  CJK UNIFIED IDEOGRAPH-85C1
        0x85DC, # G+5286  U+85DC  uni85DC,  CJK UNIFIED IDEOGRAPH-85DC
        0x85FF, # G+5287  U+85FF  uni85FF,  CJK UNIFIED IDEOGRAPH-85FF
        0x8627, # G+5288  U+8627  uni8627,  CJK UNIFIED IDEOGRAPH-8627
        0x8605, # G+5289  U+8605  uni8605,  CJK UNIFIED IDEOGRAPH-8605
        0x8629, # G+5290  U+8629  uni8629,  CJK UNIFIED IDEOGRAPH-8629
        0x8616, # G+5291  U+8616  uni8616,  CJK UNIFIED IDEOGRAPH-8616
        0x863C, # G+5292  U+863C  uni863C,  CJK UNIFIED IDEOGRAPH-863C
        0x2F36, # G+5293  U+2F36  uni2F36,  KANGXI RADICAL TWO HANDS
        0x5F08, # G+5294  U+5F08  uni5F08,  CJK UNIFIED IDEOGRAPH-5F08
        0x593C, # G+5295  U+593C  uni593C,  CJK UNIFIED IDEOGRAPH-593C
        0x5941, # G+5296  U+5941  uni5941,  CJK UNIFIED IDEOGRAPH-5941
        0x8037, # G+5297  U+8037  uni8037,  CJK UNIFIED IDEOGRAPH-8037
        0x5955, # G+5298  U+5955  uni5955,  CJK UNIFIED IDEOGRAPH-5955
        0x595A, # G+5299  U+595A  uni595A,  CJK UNIFIED IDEOGRAPH-595A
        0x5958, # G+5300  U+5958  uni5958,  CJK UNIFIED IDEOGRAPH-5958
        0x530F, # G+5301  U+530F  uni530F,  CJK UNIFIED IDEOGRAPH-530F
        0x2F2A, # G+5302  U+2F2A  uni2F2A,  KANGXI RADICAL LAME
        0x5C25, # G+5303  U+5C25  uni5C25,  CJK UNIFIED IDEOGRAPH-5C25
        0x5C2C, # G+5304  U+5C2C  uni5C2C,  CJK UNIFIED IDEOGRAPH-5C2C
        0x5C34, # G+5305  U+5C34  uni5C34,  CJK UNIFIED IDEOGRAPH-5C34
        0x624C, # G+5306  U+624C  uni624C,  CJK UNIFIED IDEOGRAPH-624C
        0x626A, # G+5307  U+626A  uni626A,  CJK UNIFIED IDEOGRAPH-626A
        0x629F, # G+5308  U+629F  uni629F,  CJK UNIFIED IDEOGRAPH-629F
        0x62BB, # G+5309  U+62BB  uni62BB,  CJK UNIFIED IDEOGRAPH-62BB
        0x62CA, # G+5310  U+62CA  uni62CA,  CJK UNIFIED IDEOGRAPH-62CA
        0x62DA, # G+5311  U+62DA  uni62DA,  CJK UNIFIED IDEOGRAPH-62DA
        0x62D7, # G+5312  U+62D7  uni62D7,  CJK UNIFIED IDEOGRAPH-62D7
        0x62EE, # G+5313  U+62EE  uni62EE,  CJK UNIFIED IDEOGRAPH-62EE
        0x6322, # G+5314  U+6322  uni6322,  CJK UNIFIED IDEOGRAPH-6322
        0x62F6, # G+5315  U+62F6  uni62F6,  CJK UNIFIED IDEOGRAPH-62F6
        0x6339, # G+5316  U+6339  uni6339,  CJK UNIFIED IDEOGRAPH-6339
        0x634B, # G+5317  U+634B  uni634B,  CJK UNIFIED IDEOGRAPH-634B
        0x6343, # G+5318  U+6343  uni6343,  CJK UNIFIED IDEOGRAPH-6343
        0x63AD, # G+5319  U+63AD  uni63AD,  CJK UNIFIED IDEOGRAPH-63AD
        0x63F6, # G+5320  U+63F6  uni63F6,  CJK UNIFIED IDEOGRAPH-63F6
        0x6371, # G+5321  U+6371  uni6371,  CJK UNIFIED IDEOGRAPH-6371
        0x637A, # G+5322  U+637A  uni637A,  CJK UNIFIED IDEOGRAPH-637A
        0x638E, # G+5323  U+638E  uni638E,  CJK UNIFIED IDEOGRAPH-638E
        0x63B4, # G+5324  U+63B4  uni63B4,  CJK UNIFIED IDEOGRAPH-63B4
        0x636D, # G+5325  U+636D  uni636D,  CJK UNIFIED IDEOGRAPH-636D
        0x63AC, # G+5326  U+63AC  uni63AC,  CJK UNIFIED IDEOGRAPH-63AC
        0x638A, # G+5327  U+638A  uni638A,  CJK UNIFIED IDEOGRAPH-638A
        0x6369, # G+5328  U+6369  uni6369,  CJK UNIFIED IDEOGRAPH-6369
        0x63AE, # G+5329  U+63AE  uni63AE,  CJK UNIFIED IDEOGRAPH-63AE
        0x63BC, # G+5330  U+63BC  uni63BC,  CJK UNIFIED IDEOGRAPH-63BC
        0x63F2, # G+5331  U+63F2  uni63F2,  CJK UNIFIED IDEOGRAPH-63F2
        0x63F8, # G+5332  U+63F8  uni63F8,  CJK UNIFIED IDEOGRAPH-63F8
        0x63E0, # G+5333  U+63E0  uni63E0,  CJK UNIFIED IDEOGRAPH-63E0
        0x63FF, # G+5334  U+63FF  uni63FF,  CJK UNIFIED IDEOGRAPH-63FF
        0x63C4, # G+5335  U+63C4  uni63C4,  CJK UNIFIED IDEOGRAPH-63C4
        0x63DE, # G+5336  U+63DE  uni63DE,  CJK UNIFIED IDEOGRAPH-63DE
        0x63CE, # G+5337  U+63CE  uni63CE,  CJK UNIFIED IDEOGRAPH-63CE
        0x6452, # G+5338  U+6452  uni6452,  CJK UNIFIED IDEOGRAPH-6452
        0x63C6, # G+5339  U+63C6  uni63C6,  CJK UNIFIED IDEOGRAPH-63C6
        0x63BE, # G+5340  U+63BE  uni63BE,  CJK UNIFIED IDEOGRAPH-63BE
        0x6445, # G+5341  U+6445  uni6445,  CJK UNIFIED IDEOGRAPH-6445
        0x6441, # G+5342  U+6441  uni6441,  CJK UNIFIED IDEOGRAPH-6441
        0x640B, # G+5343  U+640B  uni640B,  CJK UNIFIED IDEOGRAPH-640B
        0x641B, # G+5344  U+641B  uni641B,  CJK UNIFIED IDEOGRAPH-641B
        0x6420, # G+5345  U+6420  uni6420,  CJK UNIFIED IDEOGRAPH-6420
        0x640C, # G+5346  U+640C  uni640C,  CJK UNIFIED IDEOGRAPH-640C
        0x6426, # G+5347  U+6426  uni6426,  CJK UNIFIED IDEOGRAPH-6426
        0x6421, # G+5348  U+6421  uni6421,  CJK UNIFIED IDEOGRAPH-6421
        0x645E, # G+5349  U+645E  uni645E,  CJK UNIFIED IDEOGRAPH-645E
        0x6484, # G+5350  U+6484  uni6484,  CJK UNIFIED IDEOGRAPH-6484
        0x646D, # G+5351  U+646D  uni646D,  CJK UNIFIED IDEOGRAPH-646D
        0x6496, # G+5352  U+6496  uni6496,  CJK UNIFIED IDEOGRAPH-6496
        0x647A, # G+5353  U+647A  uni647A,  CJK UNIFIED IDEOGRAPH-647A
        0x64B7, # G+5354  U+64B7  uni64B7,  CJK UNIFIED IDEOGRAPH-64B7
        0x64B8, # G+5355  U+64B8  uni64B8,  CJK UNIFIED IDEOGRAPH-64B8
        0x6499, # G+5356  U+6499  uni6499,  CJK UNIFIED IDEOGRAPH-6499
        0x64BA, # G+5357  U+64BA  uni64BA,  CJK UNIFIED IDEOGRAPH-64BA
        0x64C0, # G+5358  U+64C0  uni64C0,  CJK UNIFIED IDEOGRAPH-64C0
        0x64D0, # G+5359  U+64D0  uni64D0,  CJK UNIFIED IDEOGRAPH-64D0
        0x64D7, # G+5360  U+64D7  uni64D7,  CJK UNIFIED IDEOGRAPH-64D7
        0x64E4, # G+5361  U+64E4  uni64E4,  CJK UNIFIED IDEOGRAPH-64E4
        0x64E2, # G+5362  U+64E2  uni64E2,  CJK UNIFIED IDEOGRAPH-64E2
        0x6509, # G+5363  U+6509  uni6509,  CJK UNIFIED IDEOGRAPH-6509
        0x6525, # G+5364  U+6525  uni6525,  CJK UNIFIED IDEOGRAPH-6525
        0x652E, # G+5365  U+652E  uni652E,  CJK UNIFIED IDEOGRAPH-652E
        0x2F37, # G+5366  U+2F37  uni2F37,  KANGXI RADICAL SHOOT
        0x5FD2, # G+5367  U+5FD2  uni5FD2,  CJK UNIFIED IDEOGRAPH-5FD2
        0x7519, # G+5368  U+7519  uni7519,  CJK UNIFIED IDEOGRAPH-7519
        0x5F11, # G+5369  U+5F11  uni5F11,  CJK UNIFIED IDEOGRAPH-5F11
        0x535F, # G+5370  U+535F  uni535F,  CJK UNIFIED IDEOGRAPH-535F
        0x53F1, # G+5371  U+53F1  uni53F1,  CJK UNIFIED IDEOGRAPH-53F1
        0x53FD, # G+5372  U+53FD  uni53FD,  CJK UNIFIED IDEOGRAPH-53FD
        0x53E9, # G+5373  U+53E9  uni53E9,  CJK UNIFIED IDEOGRAPH-53E9
        0x53E8, # G+5374  U+53E8  uni53E8,  CJK UNIFIED IDEOGRAPH-53E8
        0x53FB, # G+5375  U+53FB  uni53FB,  CJK UNIFIED IDEOGRAPH-53FB
        0x5412, # G+5376  U+5412  uni5412,  CJK UNIFIED IDEOGRAPH-5412
        0x5416, # G+5377  U+5416  uni5416,  CJK UNIFIED IDEOGRAPH-5416
        0x5406, # G+5378  U+5406  uni5406,  CJK UNIFIED IDEOGRAPH-5406
        0x544B, # G+5379  U+544B  uni544B,  CJK UNIFIED IDEOGRAPH-544B
        0x5452, # G+5380  U+5452  uni5452,  CJK UNIFIED IDEOGRAPH-5452
        0x5453, # G+5381  U+5453  uni5453,  CJK UNIFIED IDEOGRAPH-5453
        0x5454, # G+5382  U+5454  uni5454,  CJK UNIFIED IDEOGRAPH-5454
        0x5456, # G+5383  U+5456  uni5456,  CJK UNIFIED IDEOGRAPH-5456
        0x5443, # G+5384  U+5443  uni5443,  CJK UNIFIED IDEOGRAPH-5443
        0x5421, # G+5385  U+5421  uni5421,  CJK UNIFIED IDEOGRAPH-5421
        0x5457, # G+5386  U+5457  uni5457,  CJK UNIFIED IDEOGRAPH-5457
        0x5459, # G+5387  U+5459  uni5459,  CJK UNIFIED IDEOGRAPH-5459
        0x5423, # G+5388  U+5423  uni5423,  CJK UNIFIED IDEOGRAPH-5423
        0x5432, # G+5389  U+5432  uni5432,  CJK UNIFIED IDEOGRAPH-5432
        0x5482, # G+5390  U+5482  uni5482,  CJK UNIFIED IDEOGRAPH-5482
        0x5494, # G+5391  U+5494  uni5494,  CJK UNIFIED IDEOGRAPH-5494
        0x5477, # G+5392  U+5477  uni5477,  CJK UNIFIED IDEOGRAPH-5477
        0x5471, # G+5393  U+5471  uni5471,  CJK UNIFIED IDEOGRAPH-5471
        0x5464, # G+5394  U+5464  uni5464,  CJK UNIFIED IDEOGRAPH-5464
        0x549A, # G+5395  U+549A  uni549A,  CJK UNIFIED IDEOGRAPH-549A
        0x549B, # G+5396  U+549B  uni549B,  CJK UNIFIED IDEOGRAPH-549B
        0x5484, # G+5397  U+5484  uni5484,  CJK UNIFIED IDEOGRAPH-5484
        0x5476, # G+5398  U+5476  uni5476,  CJK UNIFIED IDEOGRAPH-5476
        0x5466, # G+5399  U+5466  uni5466,  CJK UNIFIED IDEOGRAPH-5466
        0x549D, # G+5400  U+549D  uni549D,  CJK UNIFIED IDEOGRAPH-549D
        0x54D0, # G+5401  U+54D0  uni54D0,  CJK UNIFIED IDEOGRAPH-54D0
        0x54AD, # G+5402  U+54AD  uni54AD,  CJK UNIFIED IDEOGRAPH-54AD
        0x54C2, # G+5403  U+54C2  uni54C2,  CJK UNIFIED IDEOGRAPH-54C2
        0x54B4, # G+5404  U+54B4  uni54B4,  CJK UNIFIED IDEOGRAPH-54B4
        0x54D2, # G+5405  U+54D2  uni54D2,  CJK UNIFIED IDEOGRAPH-54D2
        0x54A7, # G+5406  U+54A7  uni54A7,  CJK UNIFIED IDEOGRAPH-54A7
        0x54A6, # G+5407  U+54A6  uni54A6,  CJK UNIFIED IDEOGRAPH-54A6
        0x54D3, # G+5408  U+54D3  uni54D3,  CJK UNIFIED IDEOGRAPH-54D3
        0x54D4, # G+5409  U+54D4  uni54D4,  CJK UNIFIED IDEOGRAPH-54D4
        0x5472, # G+5410  U+5472  uni5472,  CJK UNIFIED IDEOGRAPH-5472
        0x54A3, # G+5411  U+54A3  uni54A3,  CJK UNIFIED IDEOGRAPH-54A3
        0x54D5, # G+5412  U+54D5  uni54D5,  CJK UNIFIED IDEOGRAPH-54D5
        0x54BB, # G+5413  U+54BB  uni54BB,  CJK UNIFIED IDEOGRAPH-54BB
        0x54BF, # G+5414  U+54BF  uni54BF,  CJK UNIFIED IDEOGRAPH-54BF
        0x54CC, # G+5415  U+54CC  uni54CC,  CJK UNIFIED IDEOGRAPH-54CC
        0x54D9, # G+5416  U+54D9  uni54D9,  CJK UNIFIED IDEOGRAPH-54D9
        0x54DA, # G+5417  U+54DA  uni54DA,  CJK UNIFIED IDEOGRAPH-54DA
        0x54DC, # G+5418  U+54DC  uni54DC,  CJK UNIFIED IDEOGRAPH-54DC
        0x54A9, # G+5419  U+54A9  uni54A9,  CJK UNIFIED IDEOGRAPH-54A9
        0x54AA, # G+5420  U+54AA  uni54AA,  CJK UNIFIED IDEOGRAPH-54AA
        0x54A4, # G+5421  U+54A4  uni54A4,  CJK UNIFIED IDEOGRAPH-54A4
        0x54DD, # G+5422  U+54DD  uni54DD,  CJK UNIFIED IDEOGRAPH-54DD
        0x54CF, # G+5423  U+54CF  uni54CF,  CJK UNIFIED IDEOGRAPH-54CF
        0x54DE, # G+5424  U+54DE  uni54DE,  CJK UNIFIED IDEOGRAPH-54DE
        0x551B, # G+5425  U+551B  uni551B,  CJK UNIFIED IDEOGRAPH-551B
        0x54E7, # G+5426  U+54E7  uni54E7,  CJK UNIFIED IDEOGRAPH-54E7
        0x5520, # G+5427  U+5520  uni5520,  CJK UNIFIED IDEOGRAPH-5520
        0x54FD, # G+5428  U+54FD  uni54FD,  CJK UNIFIED IDEOGRAPH-54FD
        0x5514, # G+5429  U+5514  uni5514,  CJK UNIFIED IDEOGRAPH-5514
        0x54F3, # G+5430  U+54F3  uni54F3,  CJK UNIFIED IDEOGRAPH-54F3
        0x5522, # G+5431  U+5522  uni5522,  CJK UNIFIED IDEOGRAPH-5522
        0x5523, # G+5432  U+5523  uni5523,  CJK UNIFIED IDEOGRAPH-5523
        0x550F, # G+5433  U+550F  uni550F,  CJK UNIFIED IDEOGRAPH-550F
        0x5511, # G+5434  U+5511  uni5511,  CJK UNIFIED IDEOGRAPH-5511
        0x5527, # G+5435  U+5527  uni5527,  CJK UNIFIED IDEOGRAPH-5527
        0x552A, # G+5436  U+552A  uni552A,  CJK UNIFIED IDEOGRAPH-552A
        0x5567, # G+5437  U+5567  uni5567,  CJK UNIFIED IDEOGRAPH-5567
        0x558F, # G+5438  U+558F  uni558F,  CJK UNIFIED IDEOGRAPH-558F
        0x55B5, # G+5439  U+55B5  uni55B5,  CJK UNIFIED IDEOGRAPH-55B5
        0x5549, # G+5440  U+5549  uni5549,  CJK UNIFIED IDEOGRAPH-5549
        0x556D, # G+5441  U+556D  uni556D,  CJK UNIFIED IDEOGRAPH-556D
        0x5541, # G+5442  U+5541  uni5541,  CJK UNIFIED IDEOGRAPH-5541
        0x5555, # G+5443  U+5555  uni5555,  CJK UNIFIED IDEOGRAPH-5555
        0x553F, # G+5444  U+553F  uni553F,  CJK UNIFIED IDEOGRAPH-553F
        0x5550, # G+5445  U+5550  uni5550,  CJK UNIFIED IDEOGRAPH-5550
        0x553C, # G+5446  U+553C  uni553C,  CJK UNIFIED IDEOGRAPH-553C
        0x5537, # G+5447  U+5537  uni5537,  CJK UNIFIED IDEOGRAPH-5537
        0x5556, # G+5448  U+5556  uni5556,  CJK UNIFIED IDEOGRAPH-5556
        0x5575, # G+5449  U+5575  uni5575,  CJK UNIFIED IDEOGRAPH-5575
        0x5576, # G+5450  U+5576  uni5576,  CJK UNIFIED IDEOGRAPH-5576
        0x5577, # G+5451  U+5577  uni5577,  CJK UNIFIED IDEOGRAPH-5577
        0x5533, # G+5452  U+5533  uni5533,  CJK UNIFIED IDEOGRAPH-5533
        0x5530, # G+5453  U+5530  uni5530,  CJK UNIFIED IDEOGRAPH-5530
        0x555C, # G+5454  U+555C  uni555C,  CJK UNIFIED IDEOGRAPH-555C
        0x558B, # G+5455  U+558B  uni558B,  CJK UNIFIED IDEOGRAPH-558B
        0x55D2, # G+5456  U+55D2  uni55D2,  CJK UNIFIED IDEOGRAPH-55D2
        0x5583, # G+5457  U+5583  uni5583,  CJK UNIFIED IDEOGRAPH-5583
        0x55B1, # G+5458  U+55B1  uni55B1,  CJK UNIFIED IDEOGRAPH-55B1
        0x55B9, # G+5459  U+55B9  uni55B9,  CJK UNIFIED IDEOGRAPH-55B9
        0x5588, # G+5460  U+5588  uni5588,  CJK UNIFIED IDEOGRAPH-5588
        0x5581, # G+5461  U+5581  uni5581,  CJK UNIFIED IDEOGRAPH-5581
        0x559F, # G+5462  U+559F  uni559F,  CJK UNIFIED IDEOGRAPH-559F
        0x557E, # G+5463  U+557E  uni557E,  CJK UNIFIED IDEOGRAPH-557E
        0x55D6, # G+5464  U+55D6  uni55D6,  CJK UNIFIED IDEOGRAPH-55D6
        0x5591, # G+5465  U+5591  uni5591,  CJK UNIFIED IDEOGRAPH-5591
        0x557B, # G+5466  U+557B  uni557B,  CJK UNIFIED IDEOGRAPH-557B
        0x55DF, # G+5467  U+55DF  uni55DF,  CJK UNIFIED IDEOGRAPH-55DF
        0x55BD, # G+5468  U+55BD  uni55BD,  CJK UNIFIED IDEOGRAPH-55BD
        0x55BE, # G+5469  U+55BE  uni55BE,  CJK UNIFIED IDEOGRAPH-55BE
        0x5594, # G+5470  U+5594  uni5594,  CJK UNIFIED IDEOGRAPH-5594
        0x5599, # G+5471  U+5599  uni5599,  CJK UNIFIED IDEOGRAPH-5599
        0x55EA, # G+5472  U+55EA  uni55EA,  CJK UNIFIED IDEOGRAPH-55EA
        0x55F7, # G+5473  U+55F7  uni55F7,  CJK UNIFIED IDEOGRAPH-55F7
        0x55C9, # G+5474  U+55C9  uni55C9,  CJK UNIFIED IDEOGRAPH-55C9
        0x561F, # G+5475  U+561F  uni561F,  CJK UNIFIED IDEOGRAPH-561F
        0x55D1, # G+5476  U+55D1  uni55D1,  CJK UNIFIED IDEOGRAPH-55D1
        0x55EB, # G+5477  U+55EB  uni55EB,  CJK UNIFIED IDEOGRAPH-55EB
        0x55EC, # G+5478  U+55EC  uni55EC,  CJK UNIFIED IDEOGRAPH-55EC
        0x55D4, # G+5479  U+55D4  uni55D4,  CJK UNIFIED IDEOGRAPH-55D4
        0x55E6, # G+5480  U+55E6  uni55E6,  CJK UNIFIED IDEOGRAPH-55E6
        0x55DD, # G+5481  U+55DD  uni55DD,  CJK UNIFIED IDEOGRAPH-55DD
        0x55C4, # G+5482  U+55C4  uni55C4,  CJK UNIFIED IDEOGRAPH-55C4
        0x55EF, # G+5483  U+55EF  uni55EF,  CJK UNIFIED IDEOGRAPH-55EF
        0x55E5, # G+5484  U+55E5  uni55E5,  CJK UNIFIED IDEOGRAPH-55E5
        0x55F2, # G+5485  U+55F2  uni55F2,  CJK UNIFIED IDEOGRAPH-55F2
        0x55F3, # G+5486  U+55F3  uni55F3,  CJK UNIFIED IDEOGRAPH-55F3
        0x55CC, # G+5487  U+55CC  uni55CC,  CJK UNIFIED IDEOGRAPH-55CC
        0x55CD, # G+5488  U+55CD  uni55CD,  CJK UNIFIED IDEOGRAPH-55CD
        0x55E8, # G+5489  U+55E8  uni55E8,  CJK UNIFIED IDEOGRAPH-55E8
        0x55F5, # G+5490  U+55F5  uni55F5,  CJK UNIFIED IDEOGRAPH-55F5
        0x55E4, # G+5491  U+55E4  uni55E4,  CJK UNIFIED IDEOGRAPH-55E4
        0x8F94, # G+5492  U+8F94  uni8F94,  CJK UNIFIED IDEOGRAPH-8F94
        0x561E, # G+5493  U+561E  uni561E,  CJK UNIFIED IDEOGRAPH-561E
        0x5608, # G+5494  U+5608  uni5608,  CJK UNIFIED IDEOGRAPH-5608
        0x560C, # G+5495  U+560C  uni560C,  CJK UNIFIED IDEOGRAPH-560C
        0x5601, # G+5496  U+5601  uni5601,  CJK UNIFIED IDEOGRAPH-5601
        0x5624, # G+5497  U+5624  uni5624,  CJK UNIFIED IDEOGRAPH-5624
        0x5623, # G+5498  U+5623  uni5623,  CJK UNIFIED IDEOGRAPH-5623
        0x55FE, # G+5499  U+55FE  uni55FE,  CJK UNIFIED IDEOGRAPH-55FE
        0x5600, # G+5500  U+5600  uni5600,  CJK UNIFIED IDEOGRAPH-5600
        0x5627, # G+5501  U+5627  uni5627,  CJK UNIFIED IDEOGRAPH-5627
        0x562D, # G+5502  U+562D  uni562D,  CJK UNIFIED IDEOGRAPH-562D
        0x5658, # G+5503  U+5658  uni5658,  CJK UNIFIED IDEOGRAPH-5658
        0x5639, # G+5504  U+5639  uni5639,  CJK UNIFIED IDEOGRAPH-5639
        0x5657, # G+5505  U+5657  uni5657,  CJK UNIFIED IDEOGRAPH-5657
        0x562C, # G+5506  U+562C  uni562C,  CJK UNIFIED IDEOGRAPH-562C
        0x564D, # G+5507  U+564D  uni564D,  CJK UNIFIED IDEOGRAPH-564D
        0x5662, # G+5508  U+5662  uni5662,  CJK UNIFIED IDEOGRAPH-5662
        0x5659, # G+5509  U+5659  uni5659,  CJK UNIFIED IDEOGRAPH-5659
        0x565C, # G+5510  U+565C  uni565C,  CJK UNIFIED IDEOGRAPH-565C
        0x564C, # G+5511  U+564C  uni564C,  CJK UNIFIED IDEOGRAPH-564C
        0x5654, # G+5512  U+5654  uni5654,  CJK UNIFIED IDEOGRAPH-5654
        0x5686, # G+5513  U+5686  uni5686,  CJK UNIFIED IDEOGRAPH-5686
        0x5664, # G+5514  U+5664  uni5664,  CJK UNIFIED IDEOGRAPH-5664
        0x5671, # G+5515  U+5671  uni5671,  CJK UNIFIED IDEOGRAPH-5671
        0x566B, # G+5516  U+566B  uni566B,  CJK UNIFIED IDEOGRAPH-566B
        0x567B, # G+5517  U+567B  uni567B,  CJK UNIFIED IDEOGRAPH-567B
        0x567C, # G+5518  U+567C  uni567C,  CJK UNIFIED IDEOGRAPH-567C
        0x5685, # G+5519  U+5685  uni5685,  CJK UNIFIED IDEOGRAPH-5685
        0x5693, # G+5520  U+5693  uni5693,  CJK UNIFIED IDEOGRAPH-5693
        0x56AF, # G+5521  U+56AF  uni56AF,  CJK UNIFIED IDEOGRAPH-56AF
        0x56D4, # G+5522  U+56D4  uni56D4,  CJK UNIFIED IDEOGRAPH-56D4
        0x2F1E, # G+5523  U+2F1E  uni2F1E,  KANGXI RADICAL ENCLOSURE
        0x56DD, # G+5524  U+56DD  uni56DD,  CJK UNIFIED IDEOGRAPH-56DD
        0x56E1, # G+5525  U+56E1  uni56E1,  CJK UNIFIED IDEOGRAPH-56E1
        0x56F5, # G+5526  U+56F5  uni56F5,  CJK UNIFIED IDEOGRAPH-56F5
        0x56EB, # G+5527  U+56EB  uni56EB,  CJK UNIFIED IDEOGRAPH-56EB
        0x56F9, # G+5528  U+56F9  uni56F9,  CJK UNIFIED IDEOGRAPH-56F9
        0x56FF, # G+5529  U+56FF  uni56FF,  CJK UNIFIED IDEOGRAPH-56FF
        0x5704, # G+5530  U+5704  uni5704,  CJK UNIFIED IDEOGRAPH-5704
        0x570A, # G+5531  U+570A  uni570A,  CJK UNIFIED IDEOGRAPH-570A
        0x5709, # G+5532  U+5709  uni5709,  CJK UNIFIED IDEOGRAPH-5709
        0x571C, # G+5533  U+571C  uni571C,  CJK UNIFIED IDEOGRAPH-571C
        0x5E0F, # G+5534  U+5E0F  uni5E0F,  CJK UNIFIED IDEOGRAPH-5E0F
        0x5E19, # G+5535  U+5E19  uni5E19,  CJK UNIFIED IDEOGRAPH-5E19
        0x5E14, # G+5536  U+5E14  uni5E14,  CJK UNIFIED IDEOGRAPH-5E14
        0x5E11, # G+5537  U+5E11  uni5E11,  CJK UNIFIED IDEOGRAPH-5E11
        0x5E31, # G+5538  U+5E31  uni5E31,  CJK UNIFIED IDEOGRAPH-5E31
        0x5E3B, # G+5539  U+5E3B  uni5E3B,  CJK UNIFIED IDEOGRAPH-5E3B
        0x5E3C, # G+5540  U+5E3C  uni5E3C,  CJK UNIFIED IDEOGRAPH-5E3C
        0x5E37, # G+5541  U+5E37  uni5E37,  CJK UNIFIED IDEOGRAPH-5E37
        0x5E44, # G+5542  U+5E44  uni5E44,  CJK UNIFIED IDEOGRAPH-5E44
        0x5E54, # G+5543  U+5E54  uni5E54,  CJK UNIFIED IDEOGRAPH-5E54
        0x5E5B, # G+5544  U+5E5B  uni5E5B,  CJK UNIFIED IDEOGRAPH-5E5B
        0x5E5E, # G+5545  U+5E5E  uni5E5E,  CJK UNIFIED IDEOGRAPH-5E5E
        0x5E61, # G+5546  U+5E61  uni5E61,  CJK UNIFIED IDEOGRAPH-5E61
        0x5C8C, # G+5547  U+5C8C  uni5C8C,  CJK UNIFIED IDEOGRAPH-5C8C
        0x5C7A, # G+5548  U+5C7A  uni5C7A,  CJK UNIFIED IDEOGRAPH-5C7A
        0x5C8D, # G+5549  U+5C8D  uni5C8D,  CJK UNIFIED IDEOGRAPH-5C8D
        0x5C90, # G+5550  U+5C90  uni5C90,  CJK UNIFIED IDEOGRAPH-5C90
        0x5C96, # G+5551  U+5C96  uni5C96,  CJK UNIFIED IDEOGRAPH-5C96
        0x5C88, # G+5552  U+5C88  uni5C88,  CJK UNIFIED IDEOGRAPH-5C88
        0x5C98, # G+5553  U+5C98  uni5C98,  CJK UNIFIED IDEOGRAPH-5C98
        0x5C99, # G+5554  U+5C99  uni5C99,  CJK UNIFIED IDEOGRAPH-5C99
        0x5C91, # G+5555  U+5C91  uni5C91,  CJK UNIFIED IDEOGRAPH-5C91
        0x5C9A, # G+5556  U+5C9A  uni5C9A,  CJK UNIFIED IDEOGRAPH-5C9A
        0x5C9C, # G+5557  U+5C9C  uni5C9C,  CJK UNIFIED IDEOGRAPH-5C9C
        0x5CB5, # G+5558  U+5CB5  uni5CB5,  CJK UNIFIED IDEOGRAPH-5CB5
        0x5CA2, # G+5559  U+5CA2  uni5CA2,  CJK UNIFIED IDEOGRAPH-5CA2
        0x5CBD, # G+5560  U+5CBD  uni5CBD,  CJK UNIFIED IDEOGRAPH-5CBD
        0x5CAC, # G+5561  U+5CAC  uni5CAC,  CJK UNIFIED IDEOGRAPH-5CAC
        0x5CAB, # G+5562  U+5CAB  uni5CAB,  CJK UNIFIED IDEOGRAPH-5CAB
        0x5CB1, # G+5563  U+5CB1  uni5CB1,  CJK UNIFIED IDEOGRAPH-5CB1
        0x5CA3, # G+5564  U+5CA3  uni5CA3,  CJK UNIFIED IDEOGRAPH-5CA3
        0x5CC1, # G+5565  U+5CC1  uni5CC1,  CJK UNIFIED IDEOGRAPH-5CC1
        0x5CB7, # G+5566  U+5CB7  uni5CB7,  CJK UNIFIED IDEOGRAPH-5CB7
        0x5CC4, # G+5567  U+5CC4  uni5CC4,  CJK UNIFIED IDEOGRAPH-5CC4
        0x5CD2, # G+5568  U+5CD2  uni5CD2,  CJK UNIFIED IDEOGRAPH-5CD2
        0x5CE4, # G+5569  U+5CE4  uni5CE4,  CJK UNIFIED IDEOGRAPH-5CE4
        0x5CCB, # G+5570  U+5CCB  uni5CCB,  CJK UNIFIED IDEOGRAPH-5CCB
        0x5CE5, # G+5571  U+5CE5  uni5CE5,  CJK UNIFIED IDEOGRAPH-5CE5
        0x5D02, # G+5572  U+5D02  uni5D02,  CJK UNIFIED IDEOGRAPH-5D02
        0x5D03, # G+5573  U+5D03  uni5D03,  CJK UNIFIED IDEOGRAPH-5D03
        0x5D27, # G+5574  U+5D27  uni5D27,  CJK UNIFIED IDEOGRAPH-5D27
        0x5D26, # G+5575  U+5D26  uni5D26,  CJK UNIFIED IDEOGRAPH-5D26
        0x5D2E, # G+5576  U+5D2E  uni5D2E,  CJK UNIFIED IDEOGRAPH-5D2E
        0x5D24, # G+5577  U+5D24  uni5D24,  CJK UNIFIED IDEOGRAPH-5D24
        0x5D1E, # G+5578  U+5D1E  uni5D1E,  CJK UNIFIED IDEOGRAPH-5D1E
        0x5D06, # G+5579  U+5D06  uni5D06,  CJK UNIFIED IDEOGRAPH-5D06
        0x5D1B, # G+5580  U+5D1B  uni5D1B,  CJK UNIFIED IDEOGRAPH-5D1B
        0x5D58, # G+5581  U+5D58  uni5D58,  CJK UNIFIED IDEOGRAPH-5D58
        0x5D3E, # G+5582  U+5D3E  uni5D3E,  CJK UNIFIED IDEOGRAPH-5D3E
        0x5D34, # G+5583  U+5D34  uni5D34,  CJK UNIFIED IDEOGRAPH-5D34
        0x5D3D, # G+5584  U+5D3D  uni5D3D,  CJK UNIFIED IDEOGRAPH-5D3D
        0x5D6C, # G+5585  U+5D6C  uni5D6C,  CJK UNIFIED IDEOGRAPH-5D6C
        0x5D5B, # G+5586  U+5D5B  uni5D5B,  CJK UNIFIED IDEOGRAPH-5D5B
        0x5D6F, # G+5587  U+5D6F  uni5D6F,  CJK UNIFIED IDEOGRAPH-5D6F
        0x5D5D, # G+5588  U+5D5D  uni5D5D,  CJK UNIFIED IDEOGRAPH-5D5D
        0x5D6B, # G+5589  U+5D6B  uni5D6B,  CJK UNIFIED IDEOGRAPH-5D6B
        0x5D4B, # G+5590  U+5D4B  uni5D4B,  CJK UNIFIED IDEOGRAPH-5D4B
        0x5D4A, # G+5591  U+5D4A  uni5D4A,  CJK UNIFIED IDEOGRAPH-5D4A
        0x5D69, # G+5592  U+5D69  uni5D69,  CJK UNIFIED IDEOGRAPH-5D69
        0x5D74, # G+5593  U+5D74  uni5D74,  CJK UNIFIED IDEOGRAPH-5D74
        0x5D82, # G+5594  U+5D82  uni5D82,  CJK UNIFIED IDEOGRAPH-5D82
        0x5D99, # G+5595  U+5D99  uni5D99,  CJK UNIFIED IDEOGRAPH-5D99
        0x5D9D, # G+5596  U+5D9D  uni5D9D,  CJK UNIFIED IDEOGRAPH-5D9D
        0x8C73, # G+5597  U+8C73  uni8C73,  CJK UNIFIED IDEOGRAPH-8C73
        0x5DB7, # G+5598  U+5DB7  uni5DB7,  CJK UNIFIED IDEOGRAPH-5DB7
        0x5DC5, # G+5599  U+5DC5  uni5DC5,  CJK UNIFIED IDEOGRAPH-5DC5
        0x2F3B, # G+5600  U+2F3B  uni2F3B,  KANGXI RADICAL STEP
        0x5F77, # G+5601  U+5F77  uni5F77,  CJK UNIFIED IDEOGRAPH-5F77
        0x5F82, # G+5602  U+5F82  uni5F82,  CJK UNIFIED IDEOGRAPH-5F82
        0x5F87, # G+5603  U+5F87  uni5F87,  CJK UNIFIED IDEOGRAPH-5F87
        0x5F89, # G+5604  U+5F89  uni5F89,  CJK UNIFIED IDEOGRAPH-5F89
        0x5F8C, # G+5605  U+5F8C  uni5F8C,  CJK UNIFIED IDEOGRAPH-5F8C
        0x5F95, # G+5606  U+5F95  uni5F95,  CJK UNIFIED IDEOGRAPH-5F95
        0x5F99, # G+5607  U+5F99  uni5F99,  CJK UNIFIED IDEOGRAPH-5F99
        0x5F9C, # G+5608  U+5F9C  uni5F9C,  CJK UNIFIED IDEOGRAPH-5F9C
        0x5FA8, # G+5609  U+5FA8  uni5FA8,  CJK UNIFIED IDEOGRAPH-5FA8
        0x5FAD, # G+5610  U+5FAD  uni5FAD,  CJK UNIFIED IDEOGRAPH-5FAD
        0x5FB5, # G+5611  U+5FB5  uni5FB5,  CJK UNIFIED IDEOGRAPH-5FB5
        0x5FBC, # G+5612  U+5FBC  uni5FBC,  CJK UNIFIED IDEOGRAPH-5FBC
        0x8862, # G+5613  U+8862  uni8862,  CJK UNIFIED IDEOGRAPH-8862
        0x2F3A, # G+5614  U+2F3A  uni2F3A,  KANGXI RADICAL BRISTLE
        0x72AD, # G+5615  U+72AD  uni72AD,  CJK UNIFIED IDEOGRAPH-72AD
        0x72B0, # G+5616  U+72B0  uni72B0,  CJK UNIFIED IDEOGRAPH-72B0
        0x72B4, # G+5617  U+72B4  uni72B4,  CJK UNIFIED IDEOGRAPH-72B4
        0x72B7, # G+5618  U+72B7  uni72B7,  CJK UNIFIED IDEOGRAPH-72B7
        0x72B8, # G+5619  U+72B8  uni72B8,  CJK UNIFIED IDEOGRAPH-72B8
        0x72C3, # G+5620  U+72C3  uni72C3,  CJK UNIFIED IDEOGRAPH-72C3
        0x72C1, # G+5621  U+72C1  uni72C1,  CJK UNIFIED IDEOGRAPH-72C1
        0x72CE, # G+5622  U+72CE  uni72CE,  CJK UNIFIED IDEOGRAPH-72CE
        0x72CD, # G+5623  U+72CD  uni72CD,  CJK UNIFIED IDEOGRAPH-72CD
        0x72D2, # G+5624  U+72D2  uni72D2,  CJK UNIFIED IDEOGRAPH-72D2
        0x72E8, # G+5625  U+72E8  uni72E8,  CJK UNIFIED IDEOGRAPH-72E8
        0x72EF, # G+5626  U+72EF  uni72EF,  CJK UNIFIED IDEOGRAPH-72EF
        0x72E9, # G+5627  U+72E9  uni72E9,  CJK UNIFIED IDEOGRAPH-72E9
        0x72F2, # G+5628  U+72F2  uni72F2,  CJK UNIFIED IDEOGRAPH-72F2
        0x72F4, # G+5629  U+72F4  uni72F4,  CJK UNIFIED IDEOGRAPH-72F4
        0x72F7, # G+5630  U+72F7  uni72F7,  CJK UNIFIED IDEOGRAPH-72F7
        0x7301, # G+5631  U+7301  uni7301,  CJK UNIFIED IDEOGRAPH-7301
        0x72F3, # G+5632  U+72F3  uni72F3,  CJK UNIFIED IDEOGRAPH-72F3
        0x7303, # G+5633  U+7303  uni7303,  CJK UNIFIED IDEOGRAPH-7303
        0x72FA, # G+5634  U+72FA  uni72FA,  CJK UNIFIED IDEOGRAPH-72FA
        0x72FB, # G+5635  U+72FB  uni72FB,  CJK UNIFIED IDEOGRAPH-72FB
        0x7317, # G+5636  U+7317  uni7317,  CJK UNIFIED IDEOGRAPH-7317
        0x7313, # G+5637  U+7313  uni7313,  CJK UNIFIED IDEOGRAPH-7313
        0x7321, # G+5638  U+7321  uni7321,  CJK UNIFIED IDEOGRAPH-7321
        0x730A, # G+5639  U+730A  uni730A,  CJK UNIFIED IDEOGRAPH-730A
        0x731E, # G+5640  U+731E  uni731E,  CJK UNIFIED IDEOGRAPH-731E
        0x731D, # G+5641  U+731D  uni731D,  CJK UNIFIED IDEOGRAPH-731D
        0x7315, # G+5642  U+7315  uni7315,  CJK UNIFIED IDEOGRAPH-7315
        0x7322, # G+5643  U+7322  uni7322,  CJK UNIFIED IDEOGRAPH-7322
        0x7339, # G+5644  U+7339  uni7339,  CJK UNIFIED IDEOGRAPH-7339
        0x7325, # G+5645  U+7325  uni7325,  CJK UNIFIED IDEOGRAPH-7325
        0x732C, # G+5646  U+732C  uni732C,  CJK UNIFIED IDEOGRAPH-732C
        0x7338, # G+5647  U+7338  uni7338,  CJK UNIFIED IDEOGRAPH-7338
        0x7331, # G+5648  U+7331  uni7331,  CJK UNIFIED IDEOGRAPH-7331
        0x7350, # G+5649  U+7350  uni7350,  CJK UNIFIED IDEOGRAPH-7350
        0x734D, # G+5650  U+734D  uni734D,  CJK UNIFIED IDEOGRAPH-734D
        0x7357, # G+5651  U+7357  uni7357,  CJK UNIFIED IDEOGRAPH-7357
        0x7360, # G+5652  U+7360  uni7360,  CJK UNIFIED IDEOGRAPH-7360
        0x736C, # G+5653  U+736C  uni736C,  CJK UNIFIED IDEOGRAPH-736C
        0x736F, # G+5654  U+736F  uni736F,  CJK UNIFIED IDEOGRAPH-736F
        0x737E, # G+5655  U+737E  uni737E,  CJK UNIFIED IDEOGRAPH-737E
        0x2F87, # G+5656  U+2F87  uni2F87,  KANGXI RADICAL OPPOSE
        0x5925, # G+5657  U+5925  uni5925,  CJK UNIFIED IDEOGRAPH-5925
        0x98E7, # G+5658  U+98E7  uni98E7,  CJK UNIFIED IDEOGRAPH-98E7
        0x5924, # G+5659  U+5924  uni5924,  CJK UNIFIED IDEOGRAPH-5924
        0x2F21, # G+5660  U+2F21  uni2F21,  KANGXI RADICAL GO
        0x9963, # G+5661  U+9963  uni9963,  CJK UNIFIED IDEOGRAPH-9963
        0x9967, # G+5662  U+9967  uni9967,  CJK UNIFIED IDEOGRAPH-9967
        0x9968, # G+5663  U+9968  uni9968,  CJK UNIFIED IDEOGRAPH-9968
        0x9969, # G+5664  U+9969  uni9969,  CJK UNIFIED IDEOGRAPH-9969
        0x996A, # G+5665  U+996A  uni996A,  CJK UNIFIED IDEOGRAPH-996A
        0x996B, # G+5666  U+996B  uni996B,  CJK UNIFIED IDEOGRAPH-996B
        0x996C, # G+5667  U+996C  uni996C,  CJK UNIFIED IDEOGRAPH-996C
        0x9974, # G+5668  U+9974  uni9974,  CJK UNIFIED IDEOGRAPH-9974
        0x9977, # G+5669  U+9977  uni9977,  CJK UNIFIED IDEOGRAPH-9977
        0x997D, # G+5670  U+997D  uni997D,  CJK UNIFIED IDEOGRAPH-997D
        0x9980, # G+5671  U+9980  uni9980,  CJK UNIFIED IDEOGRAPH-9980
        0x9984, # G+5672  U+9984  uni9984,  CJK UNIFIED IDEOGRAPH-9984
        0x9987, # G+5673  U+9987  uni9987,  CJK UNIFIED IDEOGRAPH-9987
        0x998A, # G+5674  U+998A  uni998A,  CJK UNIFIED IDEOGRAPH-998A
        0x998D, # G+5675  U+998D  uni998D,  CJK UNIFIED IDEOGRAPH-998D
        0x9990, # G+5676  U+9990  uni9990,  CJK UNIFIED IDEOGRAPH-9990
        0x9991, # G+5677  U+9991  uni9991,  CJK UNIFIED IDEOGRAPH-9991
        0x9993, # G+5678  U+9993  uni9993,  CJK UNIFIED IDEOGRAPH-9993
        0x9994, # G+5679  U+9994  uni9994,  CJK UNIFIED IDEOGRAPH-9994
        0x9995, # G+5680  U+9995  uni9995,  CJK UNIFIED IDEOGRAPH-9995
        0x5E80, # G+5681  U+5E80  uni5E80,  CJK UNIFIED IDEOGRAPH-5E80
        0x5E91, # G+5682  U+5E91  uni5E91,  CJK UNIFIED IDEOGRAPH-5E91
        0x5E8B, # G+5683  U+5E8B  uni5E8B,  CJK UNIFIED IDEOGRAPH-5E8B
        0x5E96, # G+5684  U+5E96  uni5E96,  CJK UNIFIED IDEOGRAPH-5E96
        0x5EA5, # G+5685  U+5EA5  uni5EA5,  CJK UNIFIED IDEOGRAPH-5EA5
        0x5EA0, # G+5686  U+5EA0  uni5EA0,  CJK UNIFIED IDEOGRAPH-5EA0
        0x5EB9, # G+5687  U+5EB9  uni5EB9,  CJK UNIFIED IDEOGRAPH-5EB9
        0x5EB5, # G+5688  U+5EB5  uni5EB5,  CJK UNIFIED IDEOGRAPH-5EB5
        0x5EBE, # G+5689  U+5EBE  uni5EBE,  CJK UNIFIED IDEOGRAPH-5EBE
        0x5EB3, # G+5690  U+5EB3  uni5EB3,  CJK UNIFIED IDEOGRAPH-5EB3
        0x8D53, # G+5691  U+8D53  uni8D53,  CJK UNIFIED IDEOGRAPH-8D53
        0x5ED2, # G+5692  U+5ED2  uni5ED2,  CJK UNIFIED IDEOGRAPH-5ED2
        0x5ED1, # G+5693  U+5ED1  uni5ED1,  CJK UNIFIED IDEOGRAPH-5ED1
        0x5EDB, # G+5694  U+5EDB  uni5EDB,  CJK UNIFIED IDEOGRAPH-5EDB
        0x5EE8, # G+5695  U+5EE8  uni5EE8,  CJK UNIFIED IDEOGRAPH-5EE8
        0x5EEA, # G+5696  U+5EEA  uni5EEA,  CJK UNIFIED IDEOGRAPH-5EEA
        0x81BA, # G+5697  U+81BA  uni81BA,  CJK UNIFIED IDEOGRAPH-81BA
        0x5FC4, # G+5698  U+5FC4  uni5FC4,  CJK UNIFIED IDEOGRAPH-5FC4
        0x5FC9, # G+5699  U+5FC9  uni5FC9,  CJK UNIFIED IDEOGRAPH-5FC9
        0x5FD6, # G+5700  U+5FD6  uni5FD6,  CJK UNIFIED IDEOGRAPH-5FD6
        0x5FCF, # G+5701  U+5FCF  uni5FCF,  CJK UNIFIED IDEOGRAPH-5FCF
        0x6003, # G+5702  U+6003  uni6003,  CJK UNIFIED IDEOGRAPH-6003
        0x5FEE, # G+5703  U+5FEE  uni5FEE,  CJK UNIFIED IDEOGRAPH-5FEE
        0x6004, # G+5704  U+6004  uni6004,  CJK UNIFIED IDEOGRAPH-6004
        0x5FE1, # G+5705  U+5FE1  uni5FE1,  CJK UNIFIED IDEOGRAPH-5FE1
        0x5FE4, # G+5706  U+5FE4  uni5FE4,  CJK UNIFIED IDEOGRAPH-5FE4
        0x5FFE, # G+5707  U+5FFE  uni5FFE,  CJK UNIFIED IDEOGRAPH-5FFE
        0x6005, # G+5708  U+6005  uni6005,  CJK UNIFIED IDEOGRAPH-6005
        0x6006, # G+5709  U+6006  uni6006,  CJK UNIFIED IDEOGRAPH-6006
        0x5FEA, # G+5710  U+5FEA  uni5FEA,  CJK UNIFIED IDEOGRAPH-5FEA
        0x5FED, # G+5711  U+5FED  uni5FED,  CJK UNIFIED IDEOGRAPH-5FED
        0x5FF8, # G+5712  U+5FF8  uni5FF8,  CJK UNIFIED IDEOGRAPH-5FF8
        0x6019, # G+5713  U+6019  uni6019,  CJK UNIFIED IDEOGRAPH-6019
        0x6035, # G+5714  U+6035  uni6035,  CJK UNIFIED IDEOGRAPH-6035
        0x6026, # G+5715  U+6026  uni6026,  CJK UNIFIED IDEOGRAPH-6026
        0x601B, # G+5716  U+601B  uni601B,  CJK UNIFIED IDEOGRAPH-601B
        0x600F, # G+5717  U+600F  uni600F,  CJK UNIFIED IDEOGRAPH-600F
        0x600D, # G+5718  U+600D  uni600D,  CJK UNIFIED IDEOGRAPH-600D
        0x6029, # G+5719  U+6029  uni6029,  CJK UNIFIED IDEOGRAPH-6029
        0x602B, # G+5720  U+602B  uni602B,  CJK UNIFIED IDEOGRAPH-602B
        0x600A, # G+5721  U+600A  uni600A,  CJK UNIFIED IDEOGRAPH-600A
        0x603F, # G+5722  U+603F  uni603F,  CJK UNIFIED IDEOGRAPH-603F
        0x6021, # G+5723  U+6021  uni6021,  CJK UNIFIED IDEOGRAPH-6021
        0x6078, # G+5724  U+6078  uni6078,  CJK UNIFIED IDEOGRAPH-6078
        0x6079, # G+5725  U+6079  uni6079,  CJK UNIFIED IDEOGRAPH-6079
        0x607B, # G+5726  U+607B  uni607B,  CJK UNIFIED IDEOGRAPH-607B
        0x607A, # G+5727  U+607A  uni607A,  CJK UNIFIED IDEOGRAPH-607A
        0x6042, # G+5728  U+6042  uni6042,  CJK UNIFIED IDEOGRAPH-6042
        0x606A, # G+5729  U+606A  uni606A,  CJK UNIFIED IDEOGRAPH-606A
        0x607D, # G+5730  U+607D  uni607D,  CJK UNIFIED IDEOGRAPH-607D
        0x6096, # G+5731  U+6096  uni6096,  CJK UNIFIED IDEOGRAPH-6096
        0x609A, # G+5732  U+609A  uni609A,  CJK UNIFIED IDEOGRAPH-609A
        0x60AD, # G+5733  U+60AD  uni60AD,  CJK UNIFIED IDEOGRAPH-60AD
        0x609D, # G+5734  U+609D  uni609D,  CJK UNIFIED IDEOGRAPH-609D
        0x6083, # G+5735  U+6083  uni6083,  CJK UNIFIED IDEOGRAPH-6083
        0x6092, # G+5736  U+6092  uni6092,  CJK UNIFIED IDEOGRAPH-6092
        0x608C, # G+5737  U+608C  uni608C,  CJK UNIFIED IDEOGRAPH-608C
        0x609B, # G+5738  U+609B  uni609B,  CJK UNIFIED IDEOGRAPH-609B
        0x60EC, # G+5739  U+60EC  uni60EC,  CJK UNIFIED IDEOGRAPH-60EC
        0x60BB, # G+5740  U+60BB  uni60BB,  CJK UNIFIED IDEOGRAPH-60BB
        0x60B1, # G+5741  U+60B1  uni60B1,  CJK UNIFIED IDEOGRAPH-60B1
        0x60DD, # G+5742  U+60DD  uni60DD,  CJK UNIFIED IDEOGRAPH-60DD
        0x60D8, # G+5743  U+60D8  uni60D8,  CJK UNIFIED IDEOGRAPH-60D8
        0x60C6, # G+5744  U+60C6  uni60C6,  CJK UNIFIED IDEOGRAPH-60C6
        0x60DA, # G+5745  U+60DA  uni60DA,  CJK UNIFIED IDEOGRAPH-60DA
        0x60B4, # G+5746  U+60B4  uni60B4,  CJK UNIFIED IDEOGRAPH-60B4
        0x6120, # G+5747  U+6120  uni6120,  CJK UNIFIED IDEOGRAPH-6120
        0x6126, # G+5748  U+6126  uni6126,  CJK UNIFIED IDEOGRAPH-6126
        0x6115, # G+5749  U+6115  uni6115,  CJK UNIFIED IDEOGRAPH-6115
        0x6123, # G+5750  U+6123  uni6123,  CJK UNIFIED IDEOGRAPH-6123
        0x60F4, # G+5751  U+60F4  uni60F4,  CJK UNIFIED IDEOGRAPH-60F4
        0x6100, # G+5752  U+6100  uni6100,  CJK UNIFIED IDEOGRAPH-6100
        0x610E, # G+5753  U+610E  uni610E,  CJK UNIFIED IDEOGRAPH-610E
        0x612B, # G+5754  U+612B  uni612B,  CJK UNIFIED IDEOGRAPH-612B
        0x614A, # G+5755  U+614A  uni614A,  CJK UNIFIED IDEOGRAPH-614A
        0x6175, # G+5756  U+6175  uni6175,  CJK UNIFIED IDEOGRAPH-6175
        0x61AC, # G+5757  U+61AC  uni61AC,  CJK UNIFIED IDEOGRAPH-61AC
        0x6194, # G+5758  U+6194  uni6194,  CJK UNIFIED IDEOGRAPH-6194
        0x61A7, # G+5759  U+61A7  uni61A7,  CJK UNIFIED IDEOGRAPH-61A7
        0x61B7, # G+5760  U+61B7  uni61B7,  CJK UNIFIED IDEOGRAPH-61B7
        0x61D4, # G+5761  U+61D4  uni61D4,  CJK UNIFIED IDEOGRAPH-61D4
        0x61F5, # G+5762  U+61F5  uni61F5,  CJK UNIFIED IDEOGRAPH-61F5
        0x5FDD, # G+5763  U+5FDD  uni5FDD,  CJK UNIFIED IDEOGRAPH-5FDD
        0x96B3, # G+5764  U+96B3  uni96B3,  CJK UNIFIED IDEOGRAPH-96B3
        0x95E9, # G+5765  U+95E9  uni95E9,  CJK UNIFIED IDEOGRAPH-95E9
        0x95EB, # G+5766  U+95EB  uni95EB,  CJK UNIFIED IDEOGRAPH-95EB
        0x95F1, # G+5767  U+95F1  uni95F1,  CJK UNIFIED IDEOGRAPH-95F1
        0x95F3, # G+5768  U+95F3  uni95F3,  CJK UNIFIED IDEOGRAPH-95F3
        0x95F5, # G+5769  U+95F5  uni95F5,  CJK UNIFIED IDEOGRAPH-95F5
        0x95F6, # G+5770  U+95F6  uni95F6,  CJK UNIFIED IDEOGRAPH-95F6
        0x95FC, # G+5771  U+95FC  uni95FC,  CJK UNIFIED IDEOGRAPH-95FC
        0x95FE, # G+5772  U+95FE  uni95FE,  CJK UNIFIED IDEOGRAPH-95FE
        0x9603, # G+5773  U+9603  uni9603,  CJK UNIFIED IDEOGRAPH-9603
        0x9604, # G+5774  U+9604  uni9604,  CJK UNIFIED IDEOGRAPH-9604
        0x9606, # G+5775  U+9606  uni9606,  CJK UNIFIED IDEOGRAPH-9606
        0x9608, # G+5776  U+9608  uni9608,  CJK UNIFIED IDEOGRAPH-9608
        0x960A, # G+5777  U+960A  uni960A,  CJK UNIFIED IDEOGRAPH-960A
        0x960B, # G+5778  U+960B  uni960B,  CJK UNIFIED IDEOGRAPH-960B
        0x960C, # G+5779  U+960C  uni960C,  CJK UNIFIED IDEOGRAPH-960C
        0x960D, # G+5780  U+960D  uni960D,  CJK UNIFIED IDEOGRAPH-960D
        0x960F, # G+5781  U+960F  uni960F,  CJK UNIFIED IDEOGRAPH-960F
        0x9612, # G+5782  U+9612  uni9612,  CJK UNIFIED IDEOGRAPH-9612
        0x9615, # G+5783  U+9615  uni9615,  CJK UNIFIED IDEOGRAPH-9615
        0x9616, # G+5784  U+9616  uni9616,  CJK UNIFIED IDEOGRAPH-9616
        0x9617, # G+5785  U+9617  uni9617,  CJK UNIFIED IDEOGRAPH-9617
        0x9619, # G+5786  U+9619  uni9619,  CJK UNIFIED IDEOGRAPH-9619
        0x961A, # G+5787  U+961A  uni961A,  CJK UNIFIED IDEOGRAPH-961A
        0x4E2C, # G+5788  U+4E2C  uni4E2C,  CJK UNIFIED IDEOGRAPH-4E2C
        0x2F59, # G+5789  U+2F59  uni2F59,  KANGXI RADICAL HALF TREE TRUNK
        0x6215, # G+5790  U+6215  uni6215,  CJK UNIFIED IDEOGRAPH-6215
        0x6C35, # G+5791  U+6C35  uni6C35,  CJK UNIFIED IDEOGRAPH-6C35
        0x6C54, # G+5792  U+6C54  uni6C54,  CJK UNIFIED IDEOGRAPH-6C54
        0x6C5C, # G+5793  U+6C5C  uni6C5C,  CJK UNIFIED IDEOGRAPH-6C5C
        0x6C4A, # G+5794  U+6C4A  uni6C4A,  CJK UNIFIED IDEOGRAPH-6C4A
        0x6CA3, # G+5795  U+6CA3  uni6CA3,  CJK UNIFIED IDEOGRAPH-6CA3
        0x6C85, # G+5796  U+6C85  uni6C85,  CJK UNIFIED IDEOGRAPH-6C85
        0x6C90, # G+5797  U+6C90  uni6C90,  CJK UNIFIED IDEOGRAPH-6C90
        0x6C94, # G+5798  U+6C94  uni6C94,  CJK UNIFIED IDEOGRAPH-6C94
        0x6C8C, # G+5799  U+6C8C  uni6C8C,  CJK UNIFIED IDEOGRAPH-6C8C
        0x6C68, # G+5800  U+6C68  uni6C68,  CJK UNIFIED IDEOGRAPH-6C68
        0x6C69, # G+5801  U+6C69  uni6C69,  CJK UNIFIED IDEOGRAPH-6C69
        0x6C74, # G+5802  U+6C74  uni6C74,  CJK UNIFIED IDEOGRAPH-6C74
        0x6C76, # G+5803  U+6C76  uni6C76,  CJK UNIFIED IDEOGRAPH-6C76
        0x6C86, # G+5804  U+6C86  uni6C86,  CJK UNIFIED IDEOGRAPH-6C86
        0x6CA9, # G+5805  U+6CA9  uni6CA9,  CJK UNIFIED IDEOGRAPH-6CA9
        0x6CD0, # G+5806  U+6CD0  uni6CD0,  CJK UNIFIED IDEOGRAPH-6CD0
        0x6CD4, # G+5807  U+6CD4  uni6CD4,  CJK UNIFIED IDEOGRAPH-6CD4
        0x6CAD, # G+5808  U+6CAD  uni6CAD,  CJK UNIFIED IDEOGRAPH-6CAD
        0x6CF7, # G+5809  U+6CF7  uni6CF7,  CJK UNIFIED IDEOGRAPH-6CF7
        0x6CF8, # G+5810  U+6CF8  uni6CF8,  CJK UNIFIED IDEOGRAPH-6CF8
        0x6CF1, # G+5811  U+6CF1  uni6CF1,  CJK UNIFIED IDEOGRAPH-6CF1
        0x6CD7, # G+5812  U+6CD7  uni6CD7,  CJK UNIFIED IDEOGRAPH-6CD7
        0x6CB2, # G+5813  U+6CB2  uni6CB2,  CJK UNIFIED IDEOGRAPH-6CB2
        0x6CE0, # G+5814  U+6CE0  uni6CE0,  CJK UNIFIED IDEOGRAPH-6CE0
        0x6CD6, # G+5815  U+6CD6  uni6CD6,  CJK UNIFIED IDEOGRAPH-6CD6
        0x6CFA, # G+5816  U+6CFA  uni6CFA,  CJK UNIFIED IDEOGRAPH-6CFA
        0x6CEB, # G+5817  U+6CEB  uni6CEB,  CJK UNIFIED IDEOGRAPH-6CEB
        0x6CEE, # G+5818  U+6CEE  uni6CEE,  CJK UNIFIED IDEOGRAPH-6CEE
        0x6CB1, # G+5819  U+6CB1  uni6CB1,  CJK UNIFIED IDEOGRAPH-6CB1
        0x6CD3, # G+5820  U+6CD3  uni6CD3,  CJK UNIFIED IDEOGRAPH-6CD3
        0x6CEF, # G+5821  U+6CEF  uni6CEF,  CJK UNIFIED IDEOGRAPH-6CEF
        0x6CFE, # G+5822  U+6CFE  uni6CFE,  CJK UNIFIED IDEOGRAPH-6CFE
        0x6D39, # G+5823  U+6D39  uni6D39,  CJK UNIFIED IDEOGRAPH-6D39
        0x6D27, # G+5824  U+6D27  uni6D27,  CJK UNIFIED IDEOGRAPH-6D27
        0x6D0C, # G+5825  U+6D0C  uni6D0C,  CJK UNIFIED IDEOGRAPH-6D0C
        0x6D43, # G+5826  U+6D43  uni6D43,  CJK UNIFIED IDEOGRAPH-6D43
        0x6D48, # G+5827  U+6D48  uni6D48,  CJK UNIFIED IDEOGRAPH-6D48
        0x6D07, # G+5828  U+6D07  uni6D07,  CJK UNIFIED IDEOGRAPH-6D07
        0x6D04, # G+5829  U+6D04  uni6D04,  CJK UNIFIED IDEOGRAPH-6D04
        0x6D19, # G+5830  U+6D19  uni6D19,  CJK UNIFIED IDEOGRAPH-6D19
        0x6D0E, # G+5831  U+6D0E  uni6D0E,  CJK UNIFIED IDEOGRAPH-6D0E
        0x6D2B, # G+5832  U+6D2B  uni6D2B,  CJK UNIFIED IDEOGRAPH-6D2B
        0x6D4D, # G+5833  U+6D4D  uni6D4D,  CJK UNIFIED IDEOGRAPH-6D4D
        0x6D2E, # G+5834  U+6D2E  uni6D2E,  CJK UNIFIED IDEOGRAPH-6D2E
        0x6D35, # G+5835  U+6D35  uni6D35,  CJK UNIFIED IDEOGRAPH-6D35
        0x6D1A, # G+5836  U+6D1A  uni6D1A,  CJK UNIFIED IDEOGRAPH-6D1A
        0x6D4F, # G+5837  U+6D4F  uni6D4F,  CJK UNIFIED IDEOGRAPH-6D4F
        0x6D52, # G+5838  U+6D52  uni6D52,  CJK UNIFIED IDEOGRAPH-6D52
        0x6D54, # G+5839  U+6D54  uni6D54,  CJK UNIFIED IDEOGRAPH-6D54
        0x6D33, # G+5840  U+6D33  uni6D33,  CJK UNIFIED IDEOGRAPH-6D33
        0x6D91, # G+5841  U+6D91  uni6D91,  CJK UNIFIED IDEOGRAPH-6D91
        0x6D6F, # G+5842  U+6D6F  uni6D6F,  CJK UNIFIED IDEOGRAPH-6D6F
        0x6D9E, # G+5843  U+6D9E  uni6D9E,  CJK UNIFIED IDEOGRAPH-6D9E
        0x6DA0, # G+5844  U+6DA0  uni6DA0,  CJK UNIFIED IDEOGRAPH-6DA0
        0x6D5E, # G+5845  U+6D5E  uni6D5E,  CJK UNIFIED IDEOGRAPH-6D5E
        0x6D93, # G+5846  U+6D93  uni6D93,  CJK UNIFIED IDEOGRAPH-6D93
        0x6D94, # G+5847  U+6D94  uni6D94,  CJK UNIFIED IDEOGRAPH-6D94
        0x6D5C, # G+5848  U+6D5C  uni6D5C,  CJK UNIFIED IDEOGRAPH-6D5C
        0x6D60, # G+5849  U+6D60  uni6D60,  CJK UNIFIED IDEOGRAPH-6D60
        0x6D7C, # G+5850  U+6D7C  uni6D7C,  CJK UNIFIED IDEOGRAPH-6D7C
        0x6D63, # G+5851  U+6D63  uni6D63,  CJK UNIFIED IDEOGRAPH-6D63
        0x6E1A, # G+5852  U+6E1A  uni6E1A,  CJK UNIFIED IDEOGRAPH-6E1A
        0x6DC7, # G+5853  U+6DC7  uni6DC7,  CJK UNIFIED IDEOGRAPH-6DC7
        0x6DC5, # G+5854  U+6DC5  uni6DC5,  CJK UNIFIED IDEOGRAPH-6DC5
        0x6DDE, # G+5855  U+6DDE  uni6DDE,  CJK UNIFIED IDEOGRAPH-6DDE
        0x6E0E, # G+5856  U+6E0E  uni6E0E,  CJK UNIFIED IDEOGRAPH-6E0E
        0x6DBF, # G+5857  U+6DBF  uni6DBF,  CJK UNIFIED IDEOGRAPH-6DBF
        0x6DE0, # G+5858  U+6DE0  uni6DE0,  CJK UNIFIED IDEOGRAPH-6DE0
        0x6E11, # G+5859  U+6E11  uni6E11,  CJK UNIFIED IDEOGRAPH-6E11
        0x6DE6, # G+5860  U+6DE6  uni6DE6,  CJK UNIFIED IDEOGRAPH-6DE6
        0x6DDD, # G+5861  U+6DDD  uni6DDD,  CJK UNIFIED IDEOGRAPH-6DDD
        0x6DD9, # G+5862  U+6DD9  uni6DD9,  CJK UNIFIED IDEOGRAPH-6DD9
        0x6E16, # G+5863  U+6E16  uni6E16,  CJK UNIFIED IDEOGRAPH-6E16
        0x6DAB, # G+5864  U+6DAB  uni6DAB,  CJK UNIFIED IDEOGRAPH-6DAB
        0x6E0C, # G+5865  U+6E0C  uni6E0C,  CJK UNIFIED IDEOGRAPH-6E0C
        0x6DAE, # G+5866  U+6DAE  uni6DAE,  CJK UNIFIED IDEOGRAPH-6DAE
        0x6E2B, # G+5867  U+6E2B  uni6E2B,  CJK UNIFIED IDEOGRAPH-6E2B
        0x6E6E, # G+5868  U+6E6E  uni6E6E,  CJK UNIFIED IDEOGRAPH-6E6E
        0x6E4E, # G+5869  U+6E4E  uni6E4E,  CJK UNIFIED IDEOGRAPH-6E4E
        0x6E6B, # G+5870  U+6E6B  uni6E6B,  CJK UNIFIED IDEOGRAPH-6E6B
        0x6EB2, # G+5871  U+6EB2  uni6EB2,  CJK UNIFIED IDEOGRAPH-6EB2
        0x6E5F, # G+5872  U+6E5F  uni6E5F,  CJK UNIFIED IDEOGRAPH-6E5F
        0x6E86, # G+5873  U+6E86  uni6E86,  CJK UNIFIED IDEOGRAPH-6E86
        0x6E53, # G+5874  U+6E53  uni6E53,  CJK UNIFIED IDEOGRAPH-6E53
        0x6E54, # G+5875  U+6E54  uni6E54,  CJK UNIFIED IDEOGRAPH-6E54
        0x6E32, # G+5876  U+6E32  uni6E32,  CJK UNIFIED IDEOGRAPH-6E32
        0x6E25, # G+5877  U+6E25  uni6E25,  CJK UNIFIED IDEOGRAPH-6E25
        0x6E44, # G+5878  U+6E44  uni6E44,  CJK UNIFIED IDEOGRAPH-6E44
        0x6EDF, # G+5879  U+6EDF  uni6EDF,  CJK UNIFIED IDEOGRAPH-6EDF
        0x6EB1, # G+5880  U+6EB1  uni6EB1,  CJK UNIFIED IDEOGRAPH-6EB1
        0x6E98, # G+5881  U+6E98  uni6E98,  CJK UNIFIED IDEOGRAPH-6E98
        0x6EE0, # G+5882  U+6EE0  uni6EE0,  CJK UNIFIED IDEOGRAPH-6EE0
        0x6F2D, # G+5883  U+6F2D  uni6F2D,  CJK UNIFIED IDEOGRAPH-6F2D
        0x6EE2, # G+5884  U+6EE2  uni6EE2,  CJK UNIFIED IDEOGRAPH-6EE2
        0x6EA5, # G+5885  U+6EA5  uni6EA5,  CJK UNIFIED IDEOGRAPH-6EA5
        0x6EA7, # G+5886  U+6EA7  uni6EA7,  CJK UNIFIED IDEOGRAPH-6EA7
        0x6EBD, # G+5887  U+6EBD  uni6EBD,  CJK UNIFIED IDEOGRAPH-6EBD
        0x6EBB, # G+5888  U+6EBB  uni6EBB,  CJK UNIFIED IDEOGRAPH-6EBB
        0x6EB7, # G+5889  U+6EB7  uni6EB7,  CJK UNIFIED IDEOGRAPH-6EB7
        0x6ED7, # G+5890  U+6ED7  uni6ED7,  CJK UNIFIED IDEOGRAPH-6ED7
        0x6EB4, # G+5891  U+6EB4  uni6EB4,  CJK UNIFIED IDEOGRAPH-6EB4
        0x6ECF, # G+5892  U+6ECF  uni6ECF,  CJK UNIFIED IDEOGRAPH-6ECF
        0x6E8F, # G+5893  U+6E8F  uni6E8F,  CJK UNIFIED IDEOGRAPH-6E8F
        0x6EC2, # G+5894  U+6EC2  uni6EC2,  CJK UNIFIED IDEOGRAPH-6EC2
        0x6E9F, # G+5895  U+6E9F  uni6E9F,  CJK UNIFIED IDEOGRAPH-6E9F
        0x6F62, # G+5896  U+6F62  uni6F62,  CJK UNIFIED IDEOGRAPH-6F62
        0x6F46, # G+5897  U+6F46  uni6F46,  CJK UNIFIED IDEOGRAPH-6F46
        0x6F47, # G+5898  U+6F47  uni6F47,  CJK UNIFIED IDEOGRAPH-6F47
        0x6F24, # G+5899  U+6F24  uni6F24,  CJK UNIFIED IDEOGRAPH-6F24
        0x6F15, # G+5900  U+6F15  uni6F15,  CJK UNIFIED IDEOGRAPH-6F15
        0x6EF9, # G+5901  U+6EF9  uni6EF9,  CJK UNIFIED IDEOGRAPH-6EF9
        0x6F2F, # G+5902  U+6F2F  uni6F2F,  CJK UNIFIED IDEOGRAPH-6F2F
        0x6F36, # G+5903  U+6F36  uni6F36,  CJK UNIFIED IDEOGRAPH-6F36
        0x6F4B, # G+5904  U+6F4B  uni6F4B,  CJK UNIFIED IDEOGRAPH-6F4B
        0x6F74, # G+5905  U+6F74  uni6F74,  CJK UNIFIED IDEOGRAPH-6F74
        0x6F2A, # G+5906  U+6F2A  uni6F2A,  CJK UNIFIED IDEOGRAPH-6F2A
        0x6F09, # G+5907  U+6F09  uni6F09,  CJK UNIFIED IDEOGRAPH-6F09
        0x6F29, # G+5908  U+6F29  uni6F29,  CJK UNIFIED IDEOGRAPH-6F29
        0x6F89, # G+5909  U+6F89  uni6F89,  CJK UNIFIED IDEOGRAPH-6F89
        0x6F8D, # G+5910  U+6F8D  uni6F8D,  CJK UNIFIED IDEOGRAPH-6F8D
        0x6F8C, # G+5911  U+6F8C  uni6F8C,  CJK UNIFIED IDEOGRAPH-6F8C
        0x6F78, # G+5912  U+6F78  uni6F78,  CJK UNIFIED IDEOGRAPH-6F78
        0x6F72, # G+5913  U+6F72  uni6F72,  CJK UNIFIED IDEOGRAPH-6F72
        0x6F7C, # G+5914  U+6F7C  uni6F7C,  CJK UNIFIED IDEOGRAPH-6F7C
        0x6F7A, # G+5915  U+6F7A  uni6F7A,  CJK UNIFIED IDEOGRAPH-6F7A
        0x6FD1, # G+5916  U+6FD1  uni6FD1,  CJK UNIFIED IDEOGRAPH-6FD1
        0x6FC9, # G+5917  U+6FC9  uni6FC9,  CJK UNIFIED IDEOGRAPH-6FC9
        0x6FA7, # G+5918  U+6FA7  uni6FA7,  CJK UNIFIED IDEOGRAPH-6FA7
        0x6FB9, # G+5919  U+6FB9  uni6FB9,  CJK UNIFIED IDEOGRAPH-6FB9
        0x6FB6, # G+5920  U+6FB6  uni6FB6,  CJK UNIFIED IDEOGRAPH-6FB6
        0x6FC2, # G+5921  U+6FC2  uni6FC2,  CJK UNIFIED IDEOGRAPH-6FC2
        0x6FE1, # G+5922  U+6FE1  uni6FE1,  CJK UNIFIED IDEOGRAPH-6FE1
        0x6FEE, # G+5923  U+6FEE  uni6FEE,  CJK UNIFIED IDEOGRAPH-6FEE
        0x6FDE, # G+5924  U+6FDE  uni6FDE,  CJK UNIFIED IDEOGRAPH-6FDE
        0x6FE0, # G+5925  U+6FE0  uni6FE0,  CJK UNIFIED IDEOGRAPH-6FE0
        0x6FEF, # G+5926  U+6FEF  uni6FEF,  CJK UNIFIED IDEOGRAPH-6FEF
        0x701A, # G+5927  U+701A  uni701A,  CJK UNIFIED IDEOGRAPH-701A
        0x7023, # G+5928  U+7023  uni7023,  CJK UNIFIED IDEOGRAPH-7023
        0x701B, # G+5929  U+701B  uni701B,  CJK UNIFIED IDEOGRAPH-701B
        0x7039, # G+5930  U+7039  uni7039,  CJK UNIFIED IDEOGRAPH-7039
        0x7035, # G+5931  U+7035  uni7035,  CJK UNIFIED IDEOGRAPH-7035
        0x704F, # G+5932  U+704F  uni704F,  CJK UNIFIED IDEOGRAPH-704F
        0x705E, # G+5933  U+705E  uni705E,  CJK UNIFIED IDEOGRAPH-705E
        0x2F27, # G+5934  U+2F27  uni2F27,  KANGXI RADICAL ROOF
        0x5B84, # G+5935  U+5B84  uni5B84,  CJK UNIFIED IDEOGRAPH-5B84
        0x5B95, # G+5936  U+5B95  uni5B95,  CJK UNIFIED IDEOGRAPH-5B95
        0x5B93, # G+5937  U+5B93  uni5B93,  CJK UNIFIED IDEOGRAPH-5B93
        0x5BA5, # G+5938  U+5BA5  uni5BA5,  CJK UNIFIED IDEOGRAPH-5BA5
        0x5BB8, # G+5939  U+5BB8  uni5BB8,  CJK UNIFIED IDEOGRAPH-5BB8
        0x752F, # G+5940  U+752F  uni752F,  CJK UNIFIED IDEOGRAPH-752F
        0x9A9E, # G+5941  U+9A9E  uni9A9E,  CJK UNIFIED IDEOGRAPH-9A9E
        0x6434, # G+5942  U+6434  uni6434,  CJK UNIFIED IDEOGRAPH-6434
        0x5BE4, # G+5943  U+5BE4  uni5BE4,  CJK UNIFIED IDEOGRAPH-5BE4
        0x5BEE, # G+5944  U+5BEE  uni5BEE,  CJK UNIFIED IDEOGRAPH-5BEE
        0x8930, # G+5945  U+8930  uni8930,  CJK UNIFIED IDEOGRAPH-8930
        0x5BF0, # G+5946  U+5BF0  uni5BF0,  CJK UNIFIED IDEOGRAPH-5BF0
        0x8E47, # G+5947  U+8E47  uni8E47,  CJK UNIFIED IDEOGRAPH-8E47
        0x8B07, # G+5948  U+8B07  uni8B07,  CJK UNIFIED IDEOGRAPH-8B07
        0x8FB6, # G+5949  U+8FB6  uni8FB6,  CJK UNIFIED IDEOGRAPH-8FB6
        0x8FD3, # G+5950  U+8FD3  uni8FD3,  CJK UNIFIED IDEOGRAPH-8FD3
        0x8FD5, # G+5951  U+8FD5  uni8FD5,  CJK UNIFIED IDEOGRAPH-8FD5
        0x8FE5, # G+5952  U+8FE5  uni8FE5,  CJK UNIFIED IDEOGRAPH-8FE5
        0x8FEE, # G+5953  U+8FEE  uni8FEE,  CJK UNIFIED IDEOGRAPH-8FEE
        0x8FE4, # G+5954  U+8FE4  uni8FE4,  CJK UNIFIED IDEOGRAPH-8FE4
        0x8FE9, # G+5955  U+8FE9  uni8FE9,  CJK UNIFIED IDEOGRAPH-8FE9
        0x8FE6, # G+5956  U+8FE6  uni8FE6,  CJK UNIFIED IDEOGRAPH-8FE6
        0x8FF3, # G+5957  U+8FF3  uni8FF3,  CJK UNIFIED IDEOGRAPH-8FF3
        0x8FE8, # G+5958  U+8FE8  uni8FE8,  CJK UNIFIED IDEOGRAPH-8FE8
        0x9005, # G+5959  U+9005  uni9005,  CJK UNIFIED IDEOGRAPH-9005
        0x9004, # G+5960  U+9004  uni9004,  CJK UNIFIED IDEOGRAPH-9004
        0x900B, # G+5961  U+900B  uni900B,  CJK UNIFIED IDEOGRAPH-900B
        0x9026, # G+5962  U+9026  uni9026,  CJK UNIFIED IDEOGRAPH-9026
        0x9011, # G+5963  U+9011  uni9011,  CJK UNIFIED IDEOGRAPH-9011
        0x900D, # G+5964  U+900D  uni900D,  CJK UNIFIED IDEOGRAPH-900D
        0x9016, # G+5965  U+9016  uni9016,  CJK UNIFIED IDEOGRAPH-9016
        0x9021, # G+5966  U+9021  uni9021,  CJK UNIFIED IDEOGRAPH-9021
        0x9035, # G+5967  U+9035  uni9035,  CJK UNIFIED IDEOGRAPH-9035
        0x9036, # G+5968  U+9036  uni9036,  CJK UNIFIED IDEOGRAPH-9036
        0x902D, # G+5969  U+902D  uni902D,  CJK UNIFIED IDEOGRAPH-902D
        0x902F, # G+5970  U+902F  uni902F,  CJK UNIFIED IDEOGRAPH-902F
        0x9044, # G+5971  U+9044  uni9044,  CJK UNIFIED IDEOGRAPH-9044
        0x9051, # G+5972  U+9051  uni9051,  CJK UNIFIED IDEOGRAPH-9051
        0x9052, # G+5973  U+9052  uni9052,  CJK UNIFIED IDEOGRAPH-9052
        0x9050, # G+5974  U+9050  uni9050,  CJK UNIFIED IDEOGRAPH-9050
        0x9068, # G+5975  U+9068  uni9068,  CJK UNIFIED IDEOGRAPH-9068
        0x9058, # G+5976  U+9058  uni9058,  CJK UNIFIED IDEOGRAPH-9058
        0x9062, # G+5977  U+9062  uni9062,  CJK UNIFIED IDEOGRAPH-9062
        0x905B, # G+5978  U+905B  uni905B,  CJK UNIFIED IDEOGRAPH-905B
        0x66B9, # G+5979  U+66B9  uni66B9,  CJK UNIFIED IDEOGRAPH-66B9
        0x9074, # G+5980  U+9074  uni9074,  CJK UNIFIED IDEOGRAPH-9074
        0x907D, # G+5981  U+907D  uni907D,  CJK UNIFIED IDEOGRAPH-907D
        0x9082, # G+5982  U+9082  uni9082,  CJK UNIFIED IDEOGRAPH-9082
        0x9088, # G+5983  U+9088  uni9088,  CJK UNIFIED IDEOGRAPH-9088
        0x9083, # G+5984  U+9083  uni9083,  CJK UNIFIED IDEOGRAPH-9083
        0x908B, # G+5985  U+908B  uni908B,  CJK UNIFIED IDEOGRAPH-908B
        0x2F39, # G+5986  U+2F39  uni2F39,  KANGXI RADICAL SNOUT
        0x5F57, # G+5987  U+5F57  uni5F57,  CJK UNIFIED IDEOGRAPH-5F57
        0x5F56, # G+5988  U+5F56  uni5F56,  CJK UNIFIED IDEOGRAPH-5F56
        0x5F58, # G+5989  U+5F58  uni5F58,  CJK UNIFIED IDEOGRAPH-5F58
        0x5C3B, # G+5990  U+5C3B  uni5C3B,  CJK UNIFIED IDEOGRAPH-5C3B
        0x54AB, # G+5991  U+54AB  uni54AB,  CJK UNIFIED IDEOGRAPH-54AB
        0x5C50, # G+5992  U+5C50  uni5C50,  CJK UNIFIED IDEOGRAPH-5C50
        0x5C59, # G+5993  U+5C59  uni5C59,  CJK UNIFIED IDEOGRAPH-5C59
        0x5B71, # G+5994  U+5B71  uni5B71,  CJK UNIFIED IDEOGRAPH-5B71
        0x5C63, # G+5995  U+5C63  uni5C63,  CJK UNIFIED IDEOGRAPH-5C63
        0x5C66, # G+5996  U+5C66  uni5C66,  CJK UNIFIED IDEOGRAPH-5C66
        0x7FBC, # G+5997  U+7FBC  uni7FBC,  CJK UNIFIED IDEOGRAPH-7FBC
        0x5F2A, # G+5998  U+5F2A  uni5F2A,  CJK UNIFIED IDEOGRAPH-5F2A
        0x5F29, # G+5999  U+5F29  uni5F29,  CJK UNIFIED IDEOGRAPH-5F29
        0x5F2D, # G+6000  U+5F2D  uni5F2D,  CJK UNIFIED IDEOGRAPH-5F2D
        0x8274, # G+6001  U+8274  uni8274,  CJK UNIFIED IDEOGRAPH-8274
        0x5F3C, # G+6002  U+5F3C  uni5F3C,  CJK UNIFIED IDEOGRAPH-5F3C
        0x9B3B, # G+6003  U+9B3B  uni9B3B,  CJK UNIFIED IDEOGRAPH-9B3B
        0x2F2C, # G+6004  U+2F2C  uni2F2C,  KANGXI RADICAL SPROUT
        0x5981, # G+6005  U+5981  uni5981,  CJK UNIFIED IDEOGRAPH-5981
        0x5983, # G+6006  U+5983  uni5983,  CJK UNIFIED IDEOGRAPH-5983
        0x598D, # G+6007  U+598D  uni598D,  CJK UNIFIED IDEOGRAPH-598D
        0x59A9, # G+6008  U+59A9  uni59A9,  CJK UNIFIED IDEOGRAPH-59A9
        0x59AA, # G+6009  U+59AA  uni59AA,  CJK UNIFIED IDEOGRAPH-59AA
        0x59A3, # G+6010  U+59A3  uni59A3,  CJK UNIFIED IDEOGRAPH-59A3
        0x5997, # G+6011  U+5997  uni5997,  CJK UNIFIED IDEOGRAPH-5997
        0x59CA, # G+6012  U+59CA  uni59CA,  CJK UNIFIED IDEOGRAPH-59CA
        0x59AB, # G+6013  U+59AB  uni59AB,  CJK UNIFIED IDEOGRAPH-59AB
        0x599E, # G+6014  U+599E  uni599E,  CJK UNIFIED IDEOGRAPH-599E
        0x59A4, # G+6015  U+59A4  uni59A4,  CJK UNIFIED IDEOGRAPH-59A4
        0x59D2, # G+6016  U+59D2  uni59D2,  CJK UNIFIED IDEOGRAPH-59D2
        0x59B2, # G+6017  U+59B2  uni59B2,  CJK UNIFIED IDEOGRAPH-59B2
        0x59AF, # G+6018  U+59AF  uni59AF,  CJK UNIFIED IDEOGRAPH-59AF
        0x59D7, # G+6019  U+59D7  uni59D7,  CJK UNIFIED IDEOGRAPH-59D7
        0x59BE, # G+6020  U+59BE  uni59BE,  CJK UNIFIED IDEOGRAPH-59BE
        0x5A05, # G+6021  U+5A05  uni5A05,  CJK UNIFIED IDEOGRAPH-5A05
        0x5A06, # G+6022  U+5A06  uni5A06,  CJK UNIFIED IDEOGRAPH-5A06
        0x59DD, # G+6023  U+59DD  uni59DD,  CJK UNIFIED IDEOGRAPH-59DD
        0x5A08, # G+6024  U+5A08  uni5A08,  CJK UNIFIED IDEOGRAPH-5A08
        0x59E3, # G+6025  U+59E3  uni59E3,  CJK UNIFIED IDEOGRAPH-59E3
        0x59D8, # G+6026  U+59D8  uni59D8,  CJK UNIFIED IDEOGRAPH-59D8
        0x59F9, # G+6027  U+59F9  uni59F9,  CJK UNIFIED IDEOGRAPH-59F9
        0x5A0C, # G+6028  U+5A0C  uni5A0C,  CJK UNIFIED IDEOGRAPH-5A0C
        0x5A09, # G+6029  U+5A09  uni5A09,  CJK UNIFIED IDEOGRAPH-5A09
        0x5A32, # G+6030  U+5A32  uni5A32,  CJK UNIFIED IDEOGRAPH-5A32
        0x5A34, # G+6031  U+5A34  uni5A34,  CJK UNIFIED IDEOGRAPH-5A34
        0x5A11, # G+6032  U+5A11  uni5A11,  CJK UNIFIED IDEOGRAPH-5A11
        0x5A23, # G+6033  U+5A23  uni5A23,  CJK UNIFIED IDEOGRAPH-5A23
        0x5A13, # G+6034  U+5A13  uni5A13,  CJK UNIFIED IDEOGRAPH-5A13
        0x5A40, # G+6035  U+5A40  uni5A40,  CJK UNIFIED IDEOGRAPH-5A40
        0x5A67, # G+6036  U+5A67  uni5A67,  CJK UNIFIED IDEOGRAPH-5A67
        0x5A4A, # G+6037  U+5A4A  uni5A4A,  CJK UNIFIED IDEOGRAPH-5A4A
        0x5A55, # G+6038  U+5A55  uni5A55,  CJK UNIFIED IDEOGRAPH-5A55
        0x5A3C, # G+6039  U+5A3C  uni5A3C,  CJK UNIFIED IDEOGRAPH-5A3C
        0x5A62, # G+6040  U+5A62  uni5A62,  CJK UNIFIED IDEOGRAPH-5A62
        0x5A75, # G+6041  U+5A75  uni5A75,  CJK UNIFIED IDEOGRAPH-5A75
        0x80EC, # G+6042  U+80EC  uni80EC,  CJK UNIFIED IDEOGRAPH-80EC
        0x5AAA, # G+6043  U+5AAA  uni5AAA,  CJK UNIFIED IDEOGRAPH-5AAA
        0x5A9B, # G+6044  U+5A9B  uni5A9B,  CJK UNIFIED IDEOGRAPH-5A9B
        0x5A77, # G+6045  U+5A77  uni5A77,  CJK UNIFIED IDEOGRAPH-5A77
        0x5A7A, # G+6046  U+5A7A  uni5A7A,  CJK UNIFIED IDEOGRAPH-5A7A
        0x5ABE, # G+6047  U+5ABE  uni5ABE,  CJK UNIFIED IDEOGRAPH-5ABE
        0x5AEB, # G+6048  U+5AEB  uni5AEB,  CJK UNIFIED IDEOGRAPH-5AEB
        0x5AB2, # G+6049  U+5AB2  uni5AB2,  CJK UNIFIED IDEOGRAPH-5AB2
        0x5AD2, # G+6050  U+5AD2  uni5AD2,  CJK UNIFIED IDEOGRAPH-5AD2
        0x5AD4, # G+6051  U+5AD4  uni5AD4,  CJK UNIFIED IDEOGRAPH-5AD4
        0x5AB8, # G+6052  U+5AB8  uni5AB8,  CJK UNIFIED IDEOGRAPH-5AB8
        0x5AE0, # G+6053  U+5AE0  uni5AE0,  CJK UNIFIED IDEOGRAPH-5AE0
        0x5AE3, # G+6054  U+5AE3  uni5AE3,  CJK UNIFIED IDEOGRAPH-5AE3
        0x5AF1, # G+6055  U+5AF1  uni5AF1,  CJK UNIFIED IDEOGRAPH-5AF1
        0x5AD6, # G+6056  U+5AD6  uni5AD6,  CJK UNIFIED IDEOGRAPH-5AD6
        0x5AE6, # G+6057  U+5AE6  uni5AE6,  CJK UNIFIED IDEOGRAPH-5AE6
        0x5AD8, # G+6058  U+5AD8  uni5AD8,  CJK UNIFIED IDEOGRAPH-5AD8
        0x5ADC, # G+6059  U+5ADC  uni5ADC,  CJK UNIFIED IDEOGRAPH-5ADC
        0x5B09, # G+6060  U+5B09  uni5B09,  CJK UNIFIED IDEOGRAPH-5B09
        0x5B17, # G+6061  U+5B17  uni5B17,  CJK UNIFIED IDEOGRAPH-5B17
        0x5B16, # G+6062  U+5B16  uni5B16,  CJK UNIFIED IDEOGRAPH-5B16
        0x5B32, # G+6063  U+5B32  uni5B32,  CJK UNIFIED IDEOGRAPH-5B32
        0x5B37, # G+6064  U+5B37  uni5B37,  CJK UNIFIED IDEOGRAPH-5B37
        0x5B40, # G+6065  U+5B40  uni5B40,  CJK UNIFIED IDEOGRAPH-5B40
        0x5C15, # G+6066  U+5C15  uni5C15,  CJK UNIFIED IDEOGRAPH-5C15
        0x5C1C, # G+6067  U+5C1C  uni5C1C,  CJK UNIFIED IDEOGRAPH-5C1C
        0x5B5A, # G+6068  U+5B5A  uni5B5A,  CJK UNIFIED IDEOGRAPH-5B5A
        0x5B65, # G+6069  U+5B65  uni5B65,  CJK UNIFIED IDEOGRAPH-5B65
        0x5B73, # G+6070  U+5B73  uni5B73,  CJK UNIFIED IDEOGRAPH-5B73
        0x5B51, # G+6071  U+5B51  uni5B51,  CJK UNIFIED IDEOGRAPH-5B51
        0x5B53, # G+6072  U+5B53  uni5B53,  CJK UNIFIED IDEOGRAPH-5B53
        0x5B62, # G+6073  U+5B62  uni5B62,  CJK UNIFIED IDEOGRAPH-5B62
        0x9A75, # G+6074  U+9A75  uni9A75,  CJK UNIFIED IDEOGRAPH-9A75
        0x9A77, # G+6075  U+9A77  uni9A77,  CJK UNIFIED IDEOGRAPH-9A77
        0x9A78, # G+6076  U+9A78  uni9A78,  CJK UNIFIED IDEOGRAPH-9A78
        0x9A7A, # G+6077  U+9A7A  uni9A7A,  CJK UNIFIED IDEOGRAPH-9A7A
        0x9A7F, # G+6078  U+9A7F  uni9A7F,  CJK UNIFIED IDEOGRAPH-9A7F
        0x9A7D, # G+6079  U+9A7D  uni9A7D,  CJK UNIFIED IDEOGRAPH-9A7D
        0x9A80, # G+6080  U+9A80  uni9A80,  CJK UNIFIED IDEOGRAPH-9A80
        0x9A81, # G+6081  U+9A81  uni9A81,  CJK UNIFIED IDEOGRAPH-9A81
        0x9A85, # G+6082  U+9A85  uni9A85,  CJK UNIFIED IDEOGRAPH-9A85
        0x9A88, # G+6083  U+9A88  uni9A88,  CJK UNIFIED IDEOGRAPH-9A88
        0x9A8A, # G+6084  U+9A8A  uni9A8A,  CJK UNIFIED IDEOGRAPH-9A8A
        0x9A90, # G+6085  U+9A90  uni9A90,  CJK UNIFIED IDEOGRAPH-9A90
        0x9A92, # G+6086  U+9A92  uni9A92,  CJK UNIFIED IDEOGRAPH-9A92
        0x9A93, # G+6087  U+9A93  uni9A93,  CJK UNIFIED IDEOGRAPH-9A93
        0x9A96, # G+6088  U+9A96  uni9A96,  CJK UNIFIED IDEOGRAPH-9A96
        0x9A98, # G+6089  U+9A98  uni9A98,  CJK UNIFIED IDEOGRAPH-9A98
        0x9A9B, # G+6090  U+9A9B  uni9A9B,  CJK UNIFIED IDEOGRAPH-9A9B
        0x9A9C, # G+6091  U+9A9C  uni9A9C,  CJK UNIFIED IDEOGRAPH-9A9C
        0x9A9D, # G+6092  U+9A9D  uni9A9D,  CJK UNIFIED IDEOGRAPH-9A9D
        0x9A9F, # G+6093  U+9A9F  uni9A9F,  CJK UNIFIED IDEOGRAPH-9A9F
        0x9AA0, # G+6094  U+9AA0  uni9AA0,  CJK UNIFIED IDEOGRAPH-9AA0
        0x9AA2, # G+6095  U+9AA2  uni9AA2,  CJK UNIFIED IDEOGRAPH-9AA2
        0x9AA3, # G+6096  U+9AA3  uni9AA3,  CJK UNIFIED IDEOGRAPH-9AA3
        0x9AA5, # G+6097  U+9AA5  uni9AA5,  CJK UNIFIED IDEOGRAPH-9AA5
        0x9AA7, # G+6098  U+9AA7  uni9AA7,  CJK UNIFIED IDEOGRAPH-9AA7
        0x7E9F, # G+6099  U+7E9F  uni7E9F,  CJK UNIFIED IDEOGRAPH-7E9F
        0x7EA1, # G+6100  U+7EA1  uni7EA1,  CJK UNIFIED IDEOGRAPH-7EA1
        0x7EA3, # G+6101  U+7EA3  uni7EA3,  CJK UNIFIED IDEOGRAPH-7EA3
        0x7EA5, # G+6102  U+7EA5  uni7EA5,  CJK UNIFIED IDEOGRAPH-7EA5
        0x7EA8, # G+6103  U+7EA8  uni7EA8,  CJK UNIFIED IDEOGRAPH-7EA8
        0x7EA9, # G+6104  U+7EA9  uni7EA9,  CJK UNIFIED IDEOGRAPH-7EA9
        0x7EAD, # G+6105  U+7EAD  uni7EAD,  CJK UNIFIED IDEOGRAPH-7EAD
        0x7EB0, # G+6106  U+7EB0  uni7EB0,  CJK UNIFIED IDEOGRAPH-7EB0
        0x7EBE, # G+6107  U+7EBE  uni7EBE,  CJK UNIFIED IDEOGRAPH-7EBE
        0x7EC0, # G+6108  U+7EC0  uni7EC0,  CJK UNIFIED IDEOGRAPH-7EC0
        0x7EC1, # G+6109  U+7EC1  uni7EC1,  CJK UNIFIED IDEOGRAPH-7EC1
        0x7EC2, # G+6110  U+7EC2  uni7EC2,  CJK UNIFIED IDEOGRAPH-7EC2
        0x7EC9, # G+6111  U+7EC9  uni7EC9,  CJK UNIFIED IDEOGRAPH-7EC9
        0x7ECB, # G+6112  U+7ECB  uni7ECB,  CJK UNIFIED IDEOGRAPH-7ECB
        0x7ECC, # G+6113  U+7ECC  uni7ECC,  CJK UNIFIED IDEOGRAPH-7ECC
        0x7ED0, # G+6114  U+7ED0  uni7ED0,  CJK UNIFIED IDEOGRAPH-7ED0
        0x7ED4, # G+6115  U+7ED4  uni7ED4,  CJK UNIFIED IDEOGRAPH-7ED4
        0x7ED7, # G+6116  U+7ED7  uni7ED7,  CJK UNIFIED IDEOGRAPH-7ED7
        0x7EDB, # G+6117  U+7EDB  uni7EDB,  CJK UNIFIED IDEOGRAPH-7EDB
        0x7EE0, # G+6118  U+7EE0  uni7EE0,  CJK UNIFIED IDEOGRAPH-7EE0
        0x7EE1, # G+6119  U+7EE1  uni7EE1,  CJK UNIFIED IDEOGRAPH-7EE1
        0x7EE8, # G+6120  U+7EE8  uni7EE8,  CJK UNIFIED IDEOGRAPH-7EE8
        0x7EEB, # G+6121  U+7EEB  uni7EEB,  CJK UNIFIED IDEOGRAPH-7EEB
        0x7EEE, # G+6122  U+7EEE  uni7EEE,  CJK UNIFIED IDEOGRAPH-7EEE
        0x7EEF, # G+6123  U+7EEF  uni7EEF,  CJK UNIFIED IDEOGRAPH-7EEF
        0x7EF1, # G+6124  U+7EF1  uni7EF1,  CJK UNIFIED IDEOGRAPH-7EF1
        0x7EF2, # G+6125  U+7EF2  uni7EF2,  CJK UNIFIED IDEOGRAPH-7EF2
        0x7F0D, # G+6126  U+7F0D  uni7F0D,  CJK UNIFIED IDEOGRAPH-7F0D
        0x7EF6, # G+6127  U+7EF6  uni7EF6,  CJK UNIFIED IDEOGRAPH-7EF6
        0x7EFA, # G+6128  U+7EFA  uni7EFA,  CJK UNIFIED IDEOGRAPH-7EFA
        0x7EFB, # G+6129  U+7EFB  uni7EFB,  CJK UNIFIED IDEOGRAPH-7EFB
        0x7EFE, # G+6130  U+7EFE  uni7EFE,  CJK UNIFIED IDEOGRAPH-7EFE
        0x7F01, # G+6131  U+7F01  uni7F01,  CJK UNIFIED IDEOGRAPH-7F01
        0x7F02, # G+6132  U+7F02  uni7F02,  CJK UNIFIED IDEOGRAPH-7F02
        0x7F03, # G+6133  U+7F03  uni7F03,  CJK UNIFIED IDEOGRAPH-7F03
        0x7F07, # G+6134  U+7F07  uni7F07,  CJK UNIFIED IDEOGRAPH-7F07
        0x7F08, # G+6135  U+7F08  uni7F08,  CJK UNIFIED IDEOGRAPH-7F08
        0x7F0B, # G+6136  U+7F0B  uni7F0B,  CJK UNIFIED IDEOGRAPH-7F0B
        0x7F0C, # G+6137  U+7F0C  uni7F0C,  CJK UNIFIED IDEOGRAPH-7F0C
        0x7F0F, # G+6138  U+7F0F  uni7F0F,  CJK UNIFIED IDEOGRAPH-7F0F
        0x7F11, # G+6139  U+7F11  uni7F11,  CJK UNIFIED IDEOGRAPH-7F11
        0x7F12, # G+6140  U+7F12  uni7F12,  CJK UNIFIED IDEOGRAPH-7F12
        0x7F17, # G+6141  U+7F17  uni7F17,  CJK UNIFIED IDEOGRAPH-7F17
        0x7F19, # G+6142  U+7F19  uni7F19,  CJK UNIFIED IDEOGRAPH-7F19
        0x7F1C, # G+6143  U+7F1C  uni7F1C,  CJK UNIFIED IDEOGRAPH-7F1C
        0x7F1B, # G+6144  U+7F1B  uni7F1B,  CJK UNIFIED IDEOGRAPH-7F1B
        0x7F1F, # G+6145  U+7F1F  uni7F1F,  CJK UNIFIED IDEOGRAPH-7F1F
        0x7F21, # G+6146  U+7F21  uni7F21,  CJK UNIFIED IDEOGRAPH-7F21
        0x7F22, # G+6147  U+7F22  uni7F22,  CJK UNIFIED IDEOGRAPH-7F22
        0x7F23, # G+6148  U+7F23  uni7F23,  CJK UNIFIED IDEOGRAPH-7F23
        0x7F24, # G+6149  U+7F24  uni7F24,  CJK UNIFIED IDEOGRAPH-7F24
        0x7F25, # G+6150  U+7F25  uni7F25,  CJK UNIFIED IDEOGRAPH-7F25
        0x7F26, # G+6151  U+7F26  uni7F26,  CJK UNIFIED IDEOGRAPH-7F26
        0x7F27, # G+6152  U+7F27  uni7F27,  CJK UNIFIED IDEOGRAPH-7F27
        0x7F2A, # G+6153  U+7F2A  uni7F2A,  CJK UNIFIED IDEOGRAPH-7F2A
        0x7F2B, # G+6154  U+7F2B  uni7F2B,  CJK UNIFIED IDEOGRAPH-7F2B
        0x7F2C, # G+6155  U+7F2C  uni7F2C,  CJK UNIFIED IDEOGRAPH-7F2C
        0x7F2D, # G+6156  U+7F2D  uni7F2D,  CJK UNIFIED IDEOGRAPH-7F2D
        0x7F2F, # G+6157  U+7F2F  uni7F2F,  CJK UNIFIED IDEOGRAPH-7F2F
        0x7F30, # G+6158  U+7F30  uni7F30,  CJK UNIFIED IDEOGRAPH-7F30
        0x7F31, # G+6159  U+7F31  uni7F31,  CJK UNIFIED IDEOGRAPH-7F31
        0x7F32, # G+6160  U+7F32  uni7F32,  CJK UNIFIED IDEOGRAPH-7F32
        0x7F33, # G+6161  U+7F33  uni7F33,  CJK UNIFIED IDEOGRAPH-7F33
        0x7F35, # G+6162  U+7F35  uni7F35,  CJK UNIFIED IDEOGRAPH-7F35
        0x2F33, # G+6163  U+2F33  uni2F33,  KANGXI RADICAL SHORT THREAD
        0x757F, # G+6164  U+757F  uni757F,  CJK UNIFIED IDEOGRAPH-757F
        0x2F2E, # G+6165  U+2F2E  uni2F2E,  KANGXI RADICAL RIVER
        0x753E, # G+6166  U+753E  uni753E,  CJK UNIFIED IDEOGRAPH-753E
        0x9095, # G+6167  U+9095  uni9095,  CJK UNIFIED IDEOGRAPH-9095
        0x738E, # G+6168  U+738E  uni738E,  CJK UNIFIED IDEOGRAPH-738E
        0x7391, # G+6169  U+7391  uni7391,  CJK UNIFIED IDEOGRAPH-7391
        0x73AE, # G+6170  U+73AE  uni73AE,  CJK UNIFIED IDEOGRAPH-73AE
        0x73A2, # G+6171  U+73A2  uni73A2,  CJK UNIFIED IDEOGRAPH-73A2
        0x739F, # G+6172  U+739F  uni739F,  CJK UNIFIED IDEOGRAPH-739F
        0x73CF, # G+6173  U+73CF  uni73CF,  CJK UNIFIED IDEOGRAPH-73CF
        0x73C2, # G+6174  U+73C2  uni73C2,  CJK UNIFIED IDEOGRAPH-73C2
        0x73D1, # G+6175  U+73D1  uni73D1,  CJK UNIFIED IDEOGRAPH-73D1
        0x73B7, # G+6176  U+73B7  uni73B7,  CJK UNIFIED IDEOGRAPH-73B7
        0x73B3, # G+6177  U+73B3  uni73B3,  CJK UNIFIED IDEOGRAPH-73B3
        0x73C0, # G+6178  U+73C0  uni73C0,  CJK UNIFIED IDEOGRAPH-73C0
        0x73C9, # G+6179  U+73C9  uni73C9,  CJK UNIFIED IDEOGRAPH-73C9
        0x73C8, # G+6180  U+73C8  uni73C8,  CJK UNIFIED IDEOGRAPH-73C8
        0x73E5, # G+6181  U+73E5  uni73E5,  CJK UNIFIED IDEOGRAPH-73E5
        0x73D9, # G+6182  U+73D9  uni73D9,  CJK UNIFIED IDEOGRAPH-73D9
        0x987C, # G+6183  U+987C  uni987C,  CJK UNIFIED IDEOGRAPH-987C
        0x740A, # G+6184  U+740A  uni740A,  CJK UNIFIED IDEOGRAPH-740A
        0x73E9, # G+6185  U+73E9  uni73E9,  CJK UNIFIED IDEOGRAPH-73E9
        0x73E7, # G+6186  U+73E7  uni73E7,  CJK UNIFIED IDEOGRAPH-73E7
        0x73DE, # G+6187  U+73DE  uni73DE,  CJK UNIFIED IDEOGRAPH-73DE
        0x73BA, # G+6188  U+73BA  uni73BA,  CJK UNIFIED IDEOGRAPH-73BA
        0x73F2, # G+6189  U+73F2  uni73F2,  CJK UNIFIED IDEOGRAPH-73F2
        0x740F, # G+6190  U+740F  uni740F,  CJK UNIFIED IDEOGRAPH-740F
        0x742A, # G+6191  U+742A  uni742A,  CJK UNIFIED IDEOGRAPH-742A
        0x745B, # G+6192  U+745B  uni745B,  CJK UNIFIED IDEOGRAPH-745B
        0x7426, # G+6193  U+7426  uni7426,  CJK UNIFIED IDEOGRAPH-7426
        0x7425, # G+6194  U+7425  uni7425,  CJK UNIFIED IDEOGRAPH-7425
        0x7428, # G+6195  U+7428  uni7428,  CJK UNIFIED IDEOGRAPH-7428
        0x7430, # G+6196  U+7430  uni7430,  CJK UNIFIED IDEOGRAPH-7430
        0x742E, # G+6197  U+742E  uni742E,  CJK UNIFIED IDEOGRAPH-742E
        0x742C, # G+6198  U+742C  uni742C,  CJK UNIFIED IDEOGRAPH-742C
        0x741B, # G+6199  U+741B  uni741B,  CJK UNIFIED IDEOGRAPH-741B
        0x741A, # G+6200  U+741A  uni741A,  CJK UNIFIED IDEOGRAPH-741A
        0x7441, # G+6201  U+7441  uni7441,  CJK UNIFIED IDEOGRAPH-7441
        0x745C, # G+6202  U+745C  uni745C,  CJK UNIFIED IDEOGRAPH-745C
        0x7457, # G+6203  U+7457  uni7457,  CJK UNIFIED IDEOGRAPH-7457
        0x7455, # G+6204  U+7455  uni7455,  CJK UNIFIED IDEOGRAPH-7455
        0x7459, # G+6205  U+7459  uni7459,  CJK UNIFIED IDEOGRAPH-7459
        0x7477, # G+6206  U+7477  uni7477,  CJK UNIFIED IDEOGRAPH-7477
        0x746D, # G+6207  U+746D  uni746D,  CJK UNIFIED IDEOGRAPH-746D
        0x747E, # G+6208  U+747E  uni747E,  CJK UNIFIED IDEOGRAPH-747E
        0x749C, # G+6209  U+749C  uni749C,  CJK UNIFIED IDEOGRAPH-749C
        0x748E, # G+6210  U+748E  uni748E,  CJK UNIFIED IDEOGRAPH-748E
        0x7480, # G+6211  U+7480  uni7480,  CJK UNIFIED IDEOGRAPH-7480
        0x7481, # G+6212  U+7481  uni7481,  CJK UNIFIED IDEOGRAPH-7481
        0x7487, # G+6213  U+7487  uni7487,  CJK UNIFIED IDEOGRAPH-7487
        0x748B, # G+6214  U+748B  uni748B,  CJK UNIFIED IDEOGRAPH-748B
        0x749E, # G+6215  U+749E  uni749E,  CJK UNIFIED IDEOGRAPH-749E
        0x74A8, # G+6216  U+74A8  uni74A8,  CJK UNIFIED IDEOGRAPH-74A8
        0x74A9, # G+6217  U+74A9  uni74A9,  CJK UNIFIED IDEOGRAPH-74A9
        0x7490, # G+6218  U+7490  uni7490,  CJK UNIFIED IDEOGRAPH-7490
        0x74A7, # G+6219  U+74A7  uni74A7,  CJK UNIFIED IDEOGRAPH-74A7
        0x74D2, # G+6220  U+74D2  uni74D2,  CJK UNIFIED IDEOGRAPH-74D2
        0x74BA, # G+6221  U+74BA  uni74BA,  CJK UNIFIED IDEOGRAPH-74BA
        0x97EA, # G+6222  U+97EA  uni97EA,  CJK UNIFIED IDEOGRAPH-97EA
        0x97EB, # G+6223  U+97EB  uni97EB,  CJK UNIFIED IDEOGRAPH-97EB
        0x97EC, # G+6224  U+97EC  uni97EC,  CJK UNIFIED IDEOGRAPH-97EC
        0x674C, # G+6225  U+674C  uni674C,  CJK UNIFIED IDEOGRAPH-674C
        0x6753, # G+6226  U+6753  uni6753,  CJK UNIFIED IDEOGRAPH-6753
        0x675E, # G+6227  U+675E  uni675E,  CJK UNIFIED IDEOGRAPH-675E
        0x6748, # G+6228  U+6748  uni6748,  CJK UNIFIED IDEOGRAPH-6748
        0x6769, # G+6229  U+6769  uni6769,  CJK UNIFIED IDEOGRAPH-6769
        0x67A5, # G+6230  U+67A5  uni67A5,  CJK UNIFIED IDEOGRAPH-67A5
        0x6787, # G+6231  U+6787  uni6787,  CJK UNIFIED IDEOGRAPH-6787
        0x676A, # G+6232  U+676A  uni676A,  CJK UNIFIED IDEOGRAPH-676A
        0x6773, # G+6233  U+6773  uni6773,  CJK UNIFIED IDEOGRAPH-6773
        0x6798, # G+6234  U+6798  uni6798,  CJK UNIFIED IDEOGRAPH-6798
        0x67A7, # G+6235  U+67A7  uni67A7,  CJK UNIFIED IDEOGRAPH-67A7
        0x6775, # G+6236  U+6775  uni6775,  CJK UNIFIED IDEOGRAPH-6775
        0x67A8, # G+6237  U+67A8  uni67A8,  CJK UNIFIED IDEOGRAPH-67A8
        0x679E, # G+6238  U+679E  uni679E,  CJK UNIFIED IDEOGRAPH-679E
        0x67AD, # G+6239  U+67AD  uni67AD,  CJK UNIFIED IDEOGRAPH-67AD
        0x678B, # G+6240  U+678B  uni678B,  CJK UNIFIED IDEOGRAPH-678B
        0x6777, # G+6241  U+6777  uni6777,  CJK UNIFIED IDEOGRAPH-6777
        0x677C, # G+6242  U+677C  uni677C,  CJK UNIFIED IDEOGRAPH-677C
        0x67F0, # G+6243  U+67F0  uni67F0,  CJK UNIFIED IDEOGRAPH-67F0
        0x6809, # G+6244  U+6809  uni6809,  CJK UNIFIED IDEOGRAPH-6809
        0x67D8, # G+6245  U+67D8  uni67D8,  CJK UNIFIED IDEOGRAPH-67D8
        0x680A, # G+6246  U+680A  uni680A,  CJK UNIFIED IDEOGRAPH-680A
        0x67E9, # G+6247  U+67E9  uni67E9,  CJK UNIFIED IDEOGRAPH-67E9
        0x67B0, # G+6248  U+67B0  uni67B0,  CJK UNIFIED IDEOGRAPH-67B0
        0x680C, # G+6249  U+680C  uni680C,  CJK UNIFIED IDEOGRAPH-680C
        0x67D9, # G+6250  U+67D9  uni67D9,  CJK UNIFIED IDEOGRAPH-67D9
        0x67B5, # G+6251  U+67B5  uni67B5,  CJK UNIFIED IDEOGRAPH-67B5
        0x67DA, # G+6252  U+67DA  uni67DA,  CJK UNIFIED IDEOGRAPH-67DA
        0x67B3, # G+6253  U+67B3  uni67B3,  CJK UNIFIED IDEOGRAPH-67B3
        0x67DD, # G+6254  U+67DD  uni67DD,  CJK UNIFIED IDEOGRAPH-67DD
        0x6800, # G+6255  U+6800  uni6800,  CJK UNIFIED IDEOGRAPH-6800
        0x67C3, # G+6256  U+67C3  uni67C3,  CJK UNIFIED IDEOGRAPH-67C3
        0x67B8, # G+6257  U+67B8  uni67B8,  CJK UNIFIED IDEOGRAPH-67B8
        0x67E2, # G+6258  U+67E2  uni67E2,  CJK UNIFIED IDEOGRAPH-67E2
        0x680E, # G+6259  U+680E  uni680E,  CJK UNIFIED IDEOGRAPH-680E
        0x67C1, # G+6260  U+67C1  uni67C1,  CJK UNIFIED IDEOGRAPH-67C1
        0x67FD, # G+6261  U+67FD  uni67FD,  CJK UNIFIED IDEOGRAPH-67FD
        0x6832, # G+6262  U+6832  uni6832,  CJK UNIFIED IDEOGRAPH-6832
        0x6833, # G+6263  U+6833  uni6833,  CJK UNIFIED IDEOGRAPH-6833
        0x6860, # G+6264  U+6860  uni6860,  CJK UNIFIED IDEOGRAPH-6860
        0x6861, # G+6265  U+6861  uni6861,  CJK UNIFIED IDEOGRAPH-6861
        0x684E, # G+6266  U+684E  uni684E,  CJK UNIFIED IDEOGRAPH-684E
        0x6862, # G+6267  U+6862  uni6862,  CJK UNIFIED IDEOGRAPH-6862
        0x6844, # G+6268  U+6844  uni6844,  CJK UNIFIED IDEOGRAPH-6844
        0x6864, # G+6269  U+6864  uni6864,  CJK UNIFIED IDEOGRAPH-6864
        0x6883, # G+6270  U+6883  uni6883,  CJK UNIFIED IDEOGRAPH-6883
        0x681D, # G+6271  U+681D  uni681D,  CJK UNIFIED IDEOGRAPH-681D
        0x6855, # G+6272  U+6855  uni6855,  CJK UNIFIED IDEOGRAPH-6855
        0x6866, # G+6273  U+6866  uni6866,  CJK UNIFIED IDEOGRAPH-6866
        0x6841, # G+6274  U+6841  uni6841,  CJK UNIFIED IDEOGRAPH-6841
        0x6867, # G+6275  U+6867  uni6867,  CJK UNIFIED IDEOGRAPH-6867
        0x6840, # G+6276  U+6840  uni6840,  CJK UNIFIED IDEOGRAPH-6840
        0x683E, # G+6277  U+683E  uni683E,  CJK UNIFIED IDEOGRAPH-683E
        0x684A, # G+6278  U+684A  uni684A,  CJK UNIFIED IDEOGRAPH-684A
        0x6849, # G+6279  U+6849  uni6849,  CJK UNIFIED IDEOGRAPH-6849
        0x6829, # G+6280  U+6829  uni6829,  CJK UNIFIED IDEOGRAPH-6829
        0x68B5, # G+6281  U+68B5  uni68B5,  CJK UNIFIED IDEOGRAPH-68B5
        0x688F, # G+6282  U+688F  uni688F,  CJK UNIFIED IDEOGRAPH-688F
        0x6874, # G+6283  U+6874  uni6874,  CJK UNIFIED IDEOGRAPH-6874
        0x6877, # G+6284  U+6877  uni6877,  CJK UNIFIED IDEOGRAPH-6877
        0x6893, # G+6285  U+6893  uni6893,  CJK UNIFIED IDEOGRAPH-6893
        0x686B, # G+6286  U+686B  uni686B,  CJK UNIFIED IDEOGRAPH-686B
        0x68C2, # G+6287  U+68C2  uni68C2,  CJK UNIFIED IDEOGRAPH-68C2
        0x696E, # G+6288  U+696E  uni696E,  CJK UNIFIED IDEOGRAPH-696E
        0x68FC, # G+6289  U+68FC  uni68FC,  CJK UNIFIED IDEOGRAPH-68FC
        0x691F, # G+6290  U+691F  uni691F,  CJK UNIFIED IDEOGRAPH-691F
        0x6920, # G+6291  U+6920  uni6920,  CJK UNIFIED IDEOGRAPH-6920
        0x68F9, # G+6292  U+68F9  uni68F9,  CJK UNIFIED IDEOGRAPH-68F9
        0x6924, # G+6293  U+6924  uni6924,  CJK UNIFIED IDEOGRAPH-6924
        0x68F0, # G+6294  U+68F0  uni68F0,  CJK UNIFIED IDEOGRAPH-68F0
        0x690B, # G+6295  U+690B  uni690B,  CJK UNIFIED IDEOGRAPH-690B
        0x6901, # G+6296  U+6901  uni6901,  CJK UNIFIED IDEOGRAPH-6901
        0x6957, # G+6297  U+6957  uni6957,  CJK UNIFIED IDEOGRAPH-6957
        0x68E3, # G+6298  U+68E3  uni68E3,  CJK UNIFIED IDEOGRAPH-68E3
        0x6910, # G+6299  U+6910  uni6910,  CJK UNIFIED IDEOGRAPH-6910
        0x6971, # G+6300  U+6971  uni6971,  CJK UNIFIED IDEOGRAPH-6971
        0x6939, # G+6301  U+6939  uni6939,  CJK UNIFIED IDEOGRAPH-6939
        0x6960, # G+6302  U+6960  uni6960,  CJK UNIFIED IDEOGRAPH-6960
        0x6942, # G+6303  U+6942  uni6942,  CJK UNIFIED IDEOGRAPH-6942
        0x695D, # G+6304  U+695D  uni695D,  CJK UNIFIED IDEOGRAPH-695D
        0x6984, # G+6305  U+6984  uni6984,  CJK UNIFIED IDEOGRAPH-6984
        0x696B, # G+6306  U+696B  uni696B,  CJK UNIFIED IDEOGRAPH-696B
        0x6980, # G+6307  U+6980  uni6980,  CJK UNIFIED IDEOGRAPH-6980
        0x6998, # G+6308  U+6998  uni6998,  CJK UNIFIED IDEOGRAPH-6998
        0x6978, # G+6309  U+6978  uni6978,  CJK UNIFIED IDEOGRAPH-6978
        0x6934, # G+6310  U+6934  uni6934,  CJK UNIFIED IDEOGRAPH-6934
        0x69CC, # G+6311  U+69CC  uni69CC,  CJK UNIFIED IDEOGRAPH-69CC
        0x6987, # G+6312  U+6987  uni6987,  CJK UNIFIED IDEOGRAPH-6987
        0x6988, # G+6313  U+6988  uni6988,  CJK UNIFIED IDEOGRAPH-6988
        0x69CE, # G+6314  U+69CE  uni69CE,  CJK UNIFIED IDEOGRAPH-69CE
        0x6989, # G+6315  U+6989  uni6989,  CJK UNIFIED IDEOGRAPH-6989
        0x6966, # G+6316  U+6966  uni6966,  CJK UNIFIED IDEOGRAPH-6966
        0x6963, # G+6317  U+6963  uni6963,  CJK UNIFIED IDEOGRAPH-6963
        0x6979, # G+6318  U+6979  uni6979,  CJK UNIFIED IDEOGRAPH-6979
        0x699B, # G+6319  U+699B  uni699B,  CJK UNIFIED IDEOGRAPH-699B
        0x69A7, # G+6320  U+69A7  uni69A7,  CJK UNIFIED IDEOGRAPH-69A7
        0x69BB, # G+6321  U+69BB  uni69BB,  CJK UNIFIED IDEOGRAPH-69BB
        0x69AB, # G+6322  U+69AB  uni69AB,  CJK UNIFIED IDEOGRAPH-69AB
        0x69AD, # G+6323  U+69AD  uni69AD,  CJK UNIFIED IDEOGRAPH-69AD
        0x69D4, # G+6324  U+69D4  uni69D4,  CJK UNIFIED IDEOGRAPH-69D4
        0x69B1, # G+6325  U+69B1  uni69B1,  CJK UNIFIED IDEOGRAPH-69B1
        0x69C1, # G+6326  U+69C1  uni69C1,  CJK UNIFIED IDEOGRAPH-69C1
        0x69CA, # G+6327  U+69CA  uni69CA,  CJK UNIFIED IDEOGRAPH-69CA
        0x69DF, # G+6328  U+69DF  uni69DF,  CJK UNIFIED IDEOGRAPH-69DF
        0x6995, # G+6329  U+6995  uni6995,  CJK UNIFIED IDEOGRAPH-6995
        0x69E0, # G+6330  U+69E0  uni69E0,  CJK UNIFIED IDEOGRAPH-69E0
        0x698D, # G+6331  U+698D  uni698D,  CJK UNIFIED IDEOGRAPH-698D
        0x69FF, # G+6332  U+69FF  uni69FF,  CJK UNIFIED IDEOGRAPH-69FF
        0x6A2F, # G+6333  U+6A2F  uni6A2F,  CJK UNIFIED IDEOGRAPH-6A2F
        0x69ED, # G+6334  U+69ED  uni69ED,  CJK UNIFIED IDEOGRAPH-69ED
        0x6A17, # G+6335  U+6A17  uni6A17,  CJK UNIFIED IDEOGRAPH-6A17
        0x6A18, # G+6336  U+6A18  uni6A18,  CJK UNIFIED IDEOGRAPH-6A18
        0x6A65, # G+6337  U+6A65  uni6A65,  CJK UNIFIED IDEOGRAPH-6A65
        0x69F2, # G+6338  U+69F2  uni69F2,  CJK UNIFIED IDEOGRAPH-69F2
        0x6A44, # G+6339  U+6A44  uni6A44,  CJK UNIFIED IDEOGRAPH-6A44
        0x6A3E, # G+6340  U+6A3E  uni6A3E,  CJK UNIFIED IDEOGRAPH-6A3E
        0x6AA0, # G+6341  U+6AA0  uni6AA0,  CJK UNIFIED IDEOGRAPH-6AA0
        0x6A50, # G+6342  U+6A50  uni6A50,  CJK UNIFIED IDEOGRAPH-6A50
        0x6A5B, # G+6343  U+6A5B  uni6A5B,  CJK UNIFIED IDEOGRAPH-6A5B
        0x6A35, # G+6344  U+6A35  uni6A35,  CJK UNIFIED IDEOGRAPH-6A35
        0x6A8E, # G+6345  U+6A8E  uni6A8E,  CJK UNIFIED IDEOGRAPH-6A8E
        0x6A79, # G+6346  U+6A79  uni6A79,  CJK UNIFIED IDEOGRAPH-6A79
        0x6A3D, # G+6347  U+6A3D  uni6A3D,  CJK UNIFIED IDEOGRAPH-6A3D
        0x6A28, # G+6348  U+6A28  uni6A28,  CJK UNIFIED IDEOGRAPH-6A28
        0x6A58, # G+6349  U+6A58  uni6A58,  CJK UNIFIED IDEOGRAPH-6A58
        0x6A7C, # G+6350  U+6A7C  uni6A7C,  CJK UNIFIED IDEOGRAPH-6A7C
        0x6A91, # G+6351  U+6A91  uni6A91,  CJK UNIFIED IDEOGRAPH-6A91
        0x6A90, # G+6352  U+6A90  uni6A90,  CJK UNIFIED IDEOGRAPH-6A90
        0x6AA9, # G+6353  U+6AA9  uni6AA9,  CJK UNIFIED IDEOGRAPH-6AA9
        0x6A97, # G+6354  U+6A97  uni6A97,  CJK UNIFIED IDEOGRAPH-6A97
        0x6AAB, # G+6355  U+6AAB  uni6AAB,  CJK UNIFIED IDEOGRAPH-6AAB
        0x7337, # G+6356  U+7337  uni7337,  CJK UNIFIED IDEOGRAPH-7337
        0x7352, # G+6357  U+7352  uni7352,  CJK UNIFIED IDEOGRAPH-7352
        0x6B81, # G+6358  U+6B81  uni6B81,  CJK UNIFIED IDEOGRAPH-6B81
        0x6B82, # G+6359  U+6B82  uni6B82,  CJK UNIFIED IDEOGRAPH-6B82
        0x6B87, # G+6360  U+6B87  uni6B87,  CJK UNIFIED IDEOGRAPH-6B87
        0x6B84, # G+6361  U+6B84  uni6B84,  CJK UNIFIED IDEOGRAPH-6B84
        0x6B92, # G+6362  U+6B92  uni6B92,  CJK UNIFIED IDEOGRAPH-6B92
        0x6B93, # G+6363  U+6B93  uni6B93,  CJK UNIFIED IDEOGRAPH-6B93
        0x6B8D, # G+6364  U+6B8D  uni6B8D,  CJK UNIFIED IDEOGRAPH-6B8D
        0x6B9A, # G+6365  U+6B9A  uni6B9A,  CJK UNIFIED IDEOGRAPH-6B9A
        0x6B9B, # G+6366  U+6B9B  uni6B9B,  CJK UNIFIED IDEOGRAPH-6B9B
        0x6BA1, # G+6367  U+6BA1  uni6BA1,  CJK UNIFIED IDEOGRAPH-6BA1
        0x6BAA, # G+6368  U+6BAA  uni6BAA,  CJK UNIFIED IDEOGRAPH-6BAA
        0x8F6B, # G+6369  U+8F6B  uni8F6B,  CJK UNIFIED IDEOGRAPH-8F6B
        0x8F6D, # G+6370  U+8F6D  uni8F6D,  CJK UNIFIED IDEOGRAPH-8F6D
        0x8F71, # G+6371  U+8F71  uni8F71,  CJK UNIFIED IDEOGRAPH-8F71
        0x8F72, # G+6372  U+8F72  uni8F72,  CJK UNIFIED IDEOGRAPH-8F72
        0x8F73, # G+6373  U+8F73  uni8F73,  CJK UNIFIED IDEOGRAPH-8F73
        0x8F75, # G+6374  U+8F75  uni8F75,  CJK UNIFIED IDEOGRAPH-8F75
        0x8F76, # G+6375  U+8F76  uni8F76,  CJK UNIFIED IDEOGRAPH-8F76
        0x8F78, # G+6376  U+8F78  uni8F78,  CJK UNIFIED IDEOGRAPH-8F78
        0x8F77, # G+6377  U+8F77  uni8F77,  CJK UNIFIED IDEOGRAPH-8F77
        0x8F79, # G+6378  U+8F79  uni8F79,  CJK UNIFIED IDEOGRAPH-8F79
        0x8F7A, # G+6379  U+8F7A  uni8F7A,  CJK UNIFIED IDEOGRAPH-8F7A
        0x8F7C, # G+6380  U+8F7C  uni8F7C,  CJK UNIFIED IDEOGRAPH-8F7C
        0x8F7E, # G+6381  U+8F7E  uni8F7E,  CJK UNIFIED IDEOGRAPH-8F7E
        0x8F81, # G+6382  U+8F81  uni8F81,  CJK UNIFIED IDEOGRAPH-8F81
        0x8F82, # G+6383  U+8F82  uni8F82,  CJK UNIFIED IDEOGRAPH-8F82
        0x8F84, # G+6384  U+8F84  uni8F84,  CJK UNIFIED IDEOGRAPH-8F84
        0x8F87, # G+6385  U+8F87  uni8F87,  CJK UNIFIED IDEOGRAPH-8F87
        0x8F8B, # G+6386  U+8F8B  uni8F8B,  CJK UNIFIED IDEOGRAPH-8F8B
        0x8F8D, # G+6387  U+8F8D  uni8F8D,  CJK UNIFIED IDEOGRAPH-8F8D
        0x8F8E, # G+6388  U+8F8E  uni8F8E,  CJK UNIFIED IDEOGRAPH-8F8E
        0x8F8F, # G+6389  U+8F8F  uni8F8F,  CJK UNIFIED IDEOGRAPH-8F8F
        0x8F98, # G+6390  U+8F98  uni8F98,  CJK UNIFIED IDEOGRAPH-8F98
        0x8F9A, # G+6391  U+8F9A  uni8F9A,  CJK UNIFIED IDEOGRAPH-8F9A
        0x8ECE, # G+6392  U+8ECE  uni8ECE,  CJK UNIFIED IDEOGRAPH-8ECE
        0x620B, # G+6393  U+620B  uni620B,  CJK UNIFIED IDEOGRAPH-620B
        0x6217, # G+6394  U+6217  uni6217,  CJK UNIFIED IDEOGRAPH-6217
        0x621B, # G+6395  U+621B  uni621B,  CJK UNIFIED IDEOGRAPH-621B
        0x621F, # G+6396  U+621F  uni621F,  CJK UNIFIED IDEOGRAPH-621F
        0x6222, # G+6397  U+6222  uni6222,  CJK UNIFIED IDEOGRAPH-6222
        0x6221, # G+6398  U+6221  uni6221,  CJK UNIFIED IDEOGRAPH-6221
        0x6225, # G+6399  U+6225  uni6225,  CJK UNIFIED IDEOGRAPH-6225
        0x6224, # G+6400  U+6224  uni6224,  CJK UNIFIED IDEOGRAPH-6224
        0x622C, # G+6401  U+622C  uni622C,  CJK UNIFIED IDEOGRAPH-622C
        0x81E7, # G+6402  U+81E7  uni81E7,  CJK UNIFIED IDEOGRAPH-81E7
        0x74EF, # G+6403  U+74EF  uni74EF,  CJK UNIFIED IDEOGRAPH-74EF
        0x74F4, # G+6404  U+74F4  uni74F4,  CJK UNIFIED IDEOGRAPH-74F4
        0x74FF, # G+6405  U+74FF  uni74FF,  CJK UNIFIED IDEOGRAPH-74FF
        0x750F, # G+6406  U+750F  uni750F,  CJK UNIFIED IDEOGRAPH-750F
        0x7511, # G+6407  U+7511  uni7511,  CJK UNIFIED IDEOGRAPH-7511
        0x7513, # G+6408  U+7513  uni7513,  CJK UNIFIED IDEOGRAPH-7513
        0x2F41, # G+6409  U+2F41  uni2F41,  KANGXI RADICAL RAP
        0x65EE, # G+6410  U+65EE  uni65EE,  CJK UNIFIED IDEOGRAPH-65EE
        0x65EF, # G+6411  U+65EF  uni65EF,  CJK UNIFIED IDEOGRAPH-65EF
        0x65F0, # G+6412  U+65F0  uni65F0,  CJK UNIFIED IDEOGRAPH-65F0
        0x660A, # G+6413  U+660A  uni660A,  CJK UNIFIED IDEOGRAPH-660A
        0x6619, # G+6414  U+6619  uni6619,  CJK UNIFIED IDEOGRAPH-6619
        0x6772, # G+6415  U+6772  uni6772,  CJK UNIFIED IDEOGRAPH-6772
        0x6603, # G+6416  U+6603  uni6603,  CJK UNIFIED IDEOGRAPH-6603
        0x6615, # G+6417  U+6615  uni6615,  CJK UNIFIED IDEOGRAPH-6615
        0x6600, # G+6418  U+6600  uni6600,  CJK UNIFIED IDEOGRAPH-6600
        0x7085, # G+6419  U+7085  uni7085,  CJK UNIFIED IDEOGRAPH-7085
        0x66F7, # G+6420  U+66F7  uni66F7,  CJK UNIFIED IDEOGRAPH-66F7
        0x661D, # G+6421  U+661D  uni661D,  CJK UNIFIED IDEOGRAPH-661D
        0x6634, # G+6422  U+6634  uni6634,  CJK UNIFIED IDEOGRAPH-6634
        0x6631, # G+6423  U+6631  uni6631,  CJK UNIFIED IDEOGRAPH-6631
        0x6636, # G+6424  U+6636  uni6636,  CJK UNIFIED IDEOGRAPH-6636
        0x6635, # G+6425  U+6635  uni6635,  CJK UNIFIED IDEOGRAPH-6635
        0x8006, # G+6426  U+8006  uni8006,  CJK UNIFIED IDEOGRAPH-8006
        0x665F, # G+6427  U+665F  uni665F,  CJK UNIFIED IDEOGRAPH-665F
        0x6654, # G+6428  U+6654  uni6654,  CJK UNIFIED IDEOGRAPH-6654
        0x6641, # G+6429  U+6641  uni6641,  CJK UNIFIED IDEOGRAPH-6641
        0x664F, # G+6430  U+664F  uni664F,  CJK UNIFIED IDEOGRAPH-664F
        0x6656, # G+6431  U+6656  uni6656,  CJK UNIFIED IDEOGRAPH-6656
        0x6661, # G+6432  U+6661  uni6661,  CJK UNIFIED IDEOGRAPH-6661
        0x6657, # G+6433  U+6657  uni6657,  CJK UNIFIED IDEOGRAPH-6657
        0x6677, # G+6434  U+6677  uni6677,  CJK UNIFIED IDEOGRAPH-6677
        0x6684, # G+6435  U+6684  uni6684,  CJK UNIFIED IDEOGRAPH-6684
        0x668C, # G+6436  U+668C  uni668C,  CJK UNIFIED IDEOGRAPH-668C
        0x66A7, # G+6437  U+66A7  uni66A7,  CJK UNIFIED IDEOGRAPH-66A7
        0x669D, # G+6438  U+669D  uni669D,  CJK UNIFIED IDEOGRAPH-669D
        0x66BE, # G+6439  U+66BE  uni66BE,  CJK UNIFIED IDEOGRAPH-66BE
        0x66DB, # G+6440  U+66DB  uni66DB,  CJK UNIFIED IDEOGRAPH-66DB
        0x66DC, # G+6441  U+66DC  uni66DC,  CJK UNIFIED IDEOGRAPH-66DC
        0x66E6, # G+6442  U+66E6  uni66E6,  CJK UNIFIED IDEOGRAPH-66E6
        0x66E9, # G+6443  U+66E9  uni66E9,  CJK UNIFIED IDEOGRAPH-66E9
        0x8D32, # G+6444  U+8D32  uni8D32,  CJK UNIFIED IDEOGRAPH-8D32
        0x8D33, # G+6445  U+8D33  uni8D33,  CJK UNIFIED IDEOGRAPH-8D33
        0x8D36, # G+6446  U+8D36  uni8D36,  CJK UNIFIED IDEOGRAPH-8D36
        0x8D3B, # G+6447  U+8D3B  uni8D3B,  CJK UNIFIED IDEOGRAPH-8D3B
        0x8D3D, # G+6448  U+8D3D  uni8D3D,  CJK UNIFIED IDEOGRAPH-8D3D
        0x8D40, # G+6449  U+8D40  uni8D40,  CJK UNIFIED IDEOGRAPH-8D40
        0x8D45, # G+6450  U+8D45  uni8D45,  CJK UNIFIED IDEOGRAPH-8D45
        0x8D46, # G+6451  U+8D46  uni8D46,  CJK UNIFIED IDEOGRAPH-8D46
        0x8D48, # G+6452  U+8D48  uni8D48,  CJK UNIFIED IDEOGRAPH-8D48
        0x8D49, # G+6453  U+8D49  uni8D49,  CJK UNIFIED IDEOGRAPH-8D49
        0x8D47, # G+6454  U+8D47  uni8D47,  CJK UNIFIED IDEOGRAPH-8D47
        0x8D4D, # G+6455  U+8D4D  uni8D4D,  CJK UNIFIED IDEOGRAPH-8D4D
        0x8D55, # G+6456  U+8D55  uni8D55,  CJK UNIFIED IDEOGRAPH-8D55
        0x8D59, # G+6457  U+8D59  uni8D59,  CJK UNIFIED IDEOGRAPH-8D59
        0x89C7, # G+6458  U+89C7  uni89C7,  CJK UNIFIED IDEOGRAPH-89C7
        0x89CA, # G+6459  U+89CA  uni89CA,  CJK UNIFIED IDEOGRAPH-89CA
        0x89CB, # G+6460  U+89CB  uni89CB,  CJK UNIFIED IDEOGRAPH-89CB
        0x89CC, # G+6461  U+89CC  uni89CC,  CJK UNIFIED IDEOGRAPH-89CC
        0x89CE, # G+6462  U+89CE  uni89CE,  CJK UNIFIED IDEOGRAPH-89CE
        0x89CF, # G+6463  U+89CF  uni89CF,  CJK UNIFIED IDEOGRAPH-89CF
        0x89D0, # G+6464  U+89D0  uni89D0,  CJK UNIFIED IDEOGRAPH-89D0
        0x89D1, # G+6465  U+89D1  uni89D1,  CJK UNIFIED IDEOGRAPH-89D1
        0x726E, # G+6466  U+726E  uni726E,  CJK UNIFIED IDEOGRAPH-726E
        0x729F, # G+6467  U+729F  uni729F,  CJK UNIFIED IDEOGRAPH-729F
        0x725D, # G+6468  U+725D  uni725D,  CJK UNIFIED IDEOGRAPH-725D
        0x7266, # G+6469  U+7266  uni7266,  CJK UNIFIED IDEOGRAPH-7266
        0x726F, # G+6470  U+726F  uni726F,  CJK UNIFIED IDEOGRAPH-726F
        0x727E, # G+6471  U+727E  uni727E,  CJK UNIFIED IDEOGRAPH-727E
        0x727F, # G+6472  U+727F  uni727F,  CJK UNIFIED IDEOGRAPH-727F
        0x7284, # G+6473  U+7284  uni7284,  CJK UNIFIED IDEOGRAPH-7284
        0x728B, # G+6474  U+728B  uni728B,  CJK UNIFIED IDEOGRAPH-728B
        0x728D, # G+6475  U+728D  uni728D,  CJK UNIFIED IDEOGRAPH-728D
        0x728F, # G+6476  U+728F  uni728F,  CJK UNIFIED IDEOGRAPH-728F
        0x7292, # G+6477  U+7292  uni7292,  CJK UNIFIED IDEOGRAPH-7292
        0x6308, # G+6478  U+6308  uni6308,  CJK UNIFIED IDEOGRAPH-6308
        0x6332, # G+6479  U+6332  uni6332,  CJK UNIFIED IDEOGRAPH-6332
        0x63B0, # G+6480  U+63B0  uni63B0,  CJK UNIFIED IDEOGRAPH-63B0
        0x643F, # G+6481  U+643F  uni643F,  CJK UNIFIED IDEOGRAPH-643F
        0x64D8, # G+6482  U+64D8  uni64D8,  CJK UNIFIED IDEOGRAPH-64D8
        0x8004, # G+6483  U+8004  uni8004,  CJK UNIFIED IDEOGRAPH-8004
        0x6BEA, # G+6484  U+6BEA  uni6BEA,  CJK UNIFIED IDEOGRAPH-6BEA
        0x6BF3, # G+6485  U+6BF3  uni6BF3,  CJK UNIFIED IDEOGRAPH-6BF3
        0x6BFD, # G+6486  U+6BFD  uni6BFD,  CJK UNIFIED IDEOGRAPH-6BFD
        0x6BF5, # G+6487  U+6BF5  uni6BF5,  CJK UNIFIED IDEOGRAPH-6BF5
        0x6BF9, # G+6488  U+6BF9  uni6BF9,  CJK UNIFIED IDEOGRAPH-6BF9
        0x6C05, # G+6489  U+6C05  uni6C05,  CJK UNIFIED IDEOGRAPH-6C05
        0x6C07, # G+6490  U+6C07  uni6C07,  CJK UNIFIED IDEOGRAPH-6C07
        0x6C06, # G+6491  U+6C06  uni6C06,  CJK UNIFIED IDEOGRAPH-6C06
        0x6C0D, # G+6492  U+6C0D  uni6C0D,  CJK UNIFIED IDEOGRAPH-6C0D
        0x6C15, # G+6493  U+6C15  uni6C15,  CJK UNIFIED IDEOGRAPH-6C15
        0x6C18, # G+6494  U+6C18  uni6C18,  CJK UNIFIED IDEOGRAPH-6C18
        0x6C19, # G+6495  U+6C19  uni6C19,  CJK UNIFIED IDEOGRAPH-6C19
        0x6C1A, # G+6496  U+6C1A  uni6C1A,  CJK UNIFIED IDEOGRAPH-6C1A
        0x6C21, # G+6497  U+6C21  uni6C21,  CJK UNIFIED IDEOGRAPH-6C21
        0x6C29, # G+6498  U+6C29  uni6C29,  CJK UNIFIED IDEOGRAPH-6C29
        0x6C24, # G+6499  U+6C24  uni6C24,  CJK UNIFIED IDEOGRAPH-6C24
        0x6C2A, # G+6500  U+6C2A  uni6C2A,  CJK UNIFIED IDEOGRAPH-6C2A
        0x6C32, # G+6501  U+6C32  uni6C32,  CJK UNIFIED IDEOGRAPH-6C32
        0x6535, # G+6502  U+6535  uni6535,  CJK UNIFIED IDEOGRAPH-6535
        0x6555, # G+6503  U+6555  uni6555,  CJK UNIFIED IDEOGRAPH-6555
        0x656B, # G+6504  U+656B  uni656B,  CJK UNIFIED IDEOGRAPH-656B
        0x724D, # G+6505  U+724D  uni724D,  CJK UNIFIED IDEOGRAPH-724D
        0x7252, # G+6506  U+7252  uni7252,  CJK UNIFIED IDEOGRAPH-7252
        0x7256, # G+6507  U+7256  uni7256,  CJK UNIFIED IDEOGRAPH-7256
        0x7230, # G+6508  U+7230  uni7230,  CJK UNIFIED IDEOGRAPH-7230
        0x8662, # G+6509  U+8662  uni8662,  CJK UNIFIED IDEOGRAPH-8662
        0x5216, # G+6510  U+5216  uni5216,  CJK UNIFIED IDEOGRAPH-5216
        0x809F, # G+6511  U+809F  uni809F,  CJK UNIFIED IDEOGRAPH-809F
        0x809C, # G+6512  U+809C  uni809C,  CJK UNIFIED IDEOGRAPH-809C
        0x8093, # G+6513  U+8093  uni8093,  CJK UNIFIED IDEOGRAPH-8093
        0x80BC, # G+6514  U+80BC  uni80BC,  CJK UNIFIED IDEOGRAPH-80BC
        0x670A, # G+6515  U+670A  uni670A,  CJK UNIFIED IDEOGRAPH-670A
        0x80BD, # G+6516  U+80BD  uni80BD,  CJK UNIFIED IDEOGRAPH-80BD
        0x80B1, # G+6517  U+80B1  uni80B1,  CJK UNIFIED IDEOGRAPH-80B1
        0x80AB, # G+6518  U+80AB  uni80AB,  CJK UNIFIED IDEOGRAPH-80AB
        0x80AD, # G+6519  U+80AD  uni80AD,  CJK UNIFIED IDEOGRAPH-80AD
        0x80B4, # G+6520  U+80B4  uni80B4,  CJK UNIFIED IDEOGRAPH-80B4
        0x80B7, # G+6521  U+80B7  uni80B7,  CJK UNIFIED IDEOGRAPH-80B7
        0x80E7, # G+6522  U+80E7  uni80E7,  CJK UNIFIED IDEOGRAPH-80E7
        0x80E8, # G+6523  U+80E8  uni80E8,  CJK UNIFIED IDEOGRAPH-80E8
        0x80E9, # G+6524  U+80E9  uni80E9,  CJK UNIFIED IDEOGRAPH-80E9
        0x80EA, # G+6525  U+80EA  uni80EA,  CJK UNIFIED IDEOGRAPH-80EA
        0x80DB, # G+6526  U+80DB  uni80DB,  CJK UNIFIED IDEOGRAPH-80DB
        0x80C2, # G+6527  U+80C2  uni80C2,  CJK UNIFIED IDEOGRAPH-80C2
        0x80C4, # G+6528  U+80C4  uni80C4,  CJK UNIFIED IDEOGRAPH-80C4
        0x80D9, # G+6529  U+80D9  uni80D9,  CJK UNIFIED IDEOGRAPH-80D9
        0x80CD, # G+6530  U+80CD  uni80CD,  CJK UNIFIED IDEOGRAPH-80CD
        0x80D7, # G+6531  U+80D7  uni80D7,  CJK UNIFIED IDEOGRAPH-80D7
        0x6710, # G+6532  U+6710  uni6710,  CJK UNIFIED IDEOGRAPH-6710
        0x80DD, # G+6533  U+80DD  uni80DD,  CJK UNIFIED IDEOGRAPH-80DD
        0x80EB, # G+6534  U+80EB  uni80EB,  CJK UNIFIED IDEOGRAPH-80EB
        0x80F1, # G+6535  U+80F1  uni80F1,  CJK UNIFIED IDEOGRAPH-80F1
        0x80F4, # G+6536  U+80F4  uni80F4,  CJK UNIFIED IDEOGRAPH-80F4
        0x80ED, # G+6537  U+80ED  uni80ED,  CJK UNIFIED IDEOGRAPH-80ED
        0x810D, # G+6538  U+810D  uni810D,  CJK UNIFIED IDEOGRAPH-810D
        0x810E, # G+6539  U+810E  uni810E,  CJK UNIFIED IDEOGRAPH-810E
        0x80F2, # G+6540  U+80F2  uni80F2,  CJK UNIFIED IDEOGRAPH-80F2
        0x80FC, # G+6541  U+80FC  uni80FC,  CJK UNIFIED IDEOGRAPH-80FC
        0x6715, # G+6542  U+6715  uni6715,  CJK UNIFIED IDEOGRAPH-6715
        0x8112, # G+6543  U+8112  uni8112,  CJK UNIFIED IDEOGRAPH-8112
        0x8C5A, # G+6544  U+8C5A  uni8C5A,  CJK UNIFIED IDEOGRAPH-8C5A
        0x8136, # G+6545  U+8136  uni8136,  CJK UNIFIED IDEOGRAPH-8136
        0x811E, # G+6546  U+811E  uni811E,  CJK UNIFIED IDEOGRAPH-811E
        0x812C, # G+6547  U+812C  uni812C,  CJK UNIFIED IDEOGRAPH-812C
        0x8118, # G+6548  U+8118  uni8118,  CJK UNIFIED IDEOGRAPH-8118
        0x8132, # G+6549  U+8132  uni8132,  CJK UNIFIED IDEOGRAPH-8132
        0x8148, # G+6550  U+8148  uni8148,  CJK UNIFIED IDEOGRAPH-8148
        0x814C, # G+6551  U+814C  uni814C,  CJK UNIFIED IDEOGRAPH-814C
        0x8153, # G+6552  U+8153  uni8153,  CJK UNIFIED IDEOGRAPH-8153
        0x8174, # G+6553  U+8174  uni8174,  CJK UNIFIED IDEOGRAPH-8174
        0x8159, # G+6554  U+8159  uni8159,  CJK UNIFIED IDEOGRAPH-8159
        0x815A, # G+6555  U+815A  uni815A,  CJK UNIFIED IDEOGRAPH-815A
        0x8171, # G+6556  U+8171  uni8171,  CJK UNIFIED IDEOGRAPH-8171
        0x8160, # G+6557  U+8160  uni8160,  CJK UNIFIED IDEOGRAPH-8160
        0x8169, # G+6558  U+8169  uni8169,  CJK UNIFIED IDEOGRAPH-8169
        0x817C, # G+6559  U+817C  uni817C,  CJK UNIFIED IDEOGRAPH-817C
        0x817D, # G+6560  U+817D  uni817D,  CJK UNIFIED IDEOGRAPH-817D
        0x816D, # G+6561  U+816D  uni816D,  CJK UNIFIED IDEOGRAPH-816D
        0x8167, # G+6562  U+8167  uni8167,  CJK UNIFIED IDEOGRAPH-8167
        0x584D, # G+6563  U+584D  uni584D,  CJK UNIFIED IDEOGRAPH-584D
        0x5AB5, # G+6564  U+5AB5  uni5AB5,  CJK UNIFIED IDEOGRAPH-5AB5
        0x8188, # G+6565  U+8188  uni8188,  CJK UNIFIED IDEOGRAPH-8188
        0x8182, # G+6566  U+8182  uni8182,  CJK UNIFIED IDEOGRAPH-8182
        0x8191, # G+6567  U+8191  uni8191,  CJK UNIFIED IDEOGRAPH-8191
        0x6ED5, # G+6568  U+6ED5  uni6ED5,  CJK UNIFIED IDEOGRAPH-6ED5
        0x81A3, # G+6569  U+81A3  uni81A3,  CJK UNIFIED IDEOGRAPH-81A3
        0x81AA, # G+6570  U+81AA  uni81AA,  CJK UNIFIED IDEOGRAPH-81AA
        0x81CC, # G+6571  U+81CC  uni81CC,  CJK UNIFIED IDEOGRAPH-81CC
        0x6726, # G+6572  U+6726  uni6726,  CJK UNIFIED IDEOGRAPH-6726
        0x81CA, # G+6573  U+81CA  uni81CA,  CJK UNIFIED IDEOGRAPH-81CA
        0x81BB, # G+6574  U+81BB  uni81BB,  CJK UNIFIED IDEOGRAPH-81BB
        0x81C1, # G+6575  U+81C1  uni81C1,  CJK UNIFIED IDEOGRAPH-81C1
        0x81A6, # G+6576  U+81A6  uni81A6,  CJK UNIFIED IDEOGRAPH-81A6
        0x6B24, # G+6577  U+6B24  uni6B24,  CJK UNIFIED IDEOGRAPH-6B24
        0x6B37, # G+6578  U+6B37  uni6B37,  CJK UNIFIED IDEOGRAPH-6B37
        0x6B39, # G+6579  U+6B39  uni6B39,  CJK UNIFIED IDEOGRAPH-6B39
        0x6B43, # G+6580  U+6B43  uni6B43,  CJK UNIFIED IDEOGRAPH-6B43
        0x6B46, # G+6581  U+6B46  uni6B46,  CJK UNIFIED IDEOGRAPH-6B46
        0x6B59, # G+6582  U+6B59  uni6B59,  CJK UNIFIED IDEOGRAPH-6B59
        0x98D1, # G+6583  U+98D1  uni98D1,  CJK UNIFIED IDEOGRAPH-98D1
        0x98D2, # G+6584  U+98D2  uni98D2,  CJK UNIFIED IDEOGRAPH-98D2
        0x98D3, # G+6585  U+98D3  uni98D3,  CJK UNIFIED IDEOGRAPH-98D3
        0x98D5, # G+6586  U+98D5  uni98D5,  CJK UNIFIED IDEOGRAPH-98D5
        0x98D9, # G+6587  U+98D9  uni98D9,  CJK UNIFIED IDEOGRAPH-98D9
        0x98DA, # G+6588  U+98DA  uni98DA,  CJK UNIFIED IDEOGRAPH-98DA
        0x2F4E, # G+6589  U+2F4E  uni2F4E,  KANGXI RADICAL WEAPON
        0x5F40, # G+6590  U+5F40  uni5F40,  CJK UNIFIED IDEOGRAPH-5F40
        0x6BC2, # G+6591  U+6BC2  uni6BC2,  CJK UNIFIED IDEOGRAPH-6BC2
        0x89F3, # G+6592  U+89F3  uni89F3,  CJK UNIFIED IDEOGRAPH-89F3
        0x6590, # G+6593  U+6590  uni6590,  CJK UNIFIED IDEOGRAPH-6590
        0x9F51, # G+6594  U+9F51  uni9F51,  CJK UNIFIED IDEOGRAPH-9F51
        0x6593, # G+6595  U+6593  uni6593,  CJK UNIFIED IDEOGRAPH-6593
        0x65BC, # G+6596  U+65BC  uni65BC,  CJK UNIFIED IDEOGRAPH-65BC
        0x65C6, # G+6597  U+65C6  uni65C6,  CJK UNIFIED IDEOGRAPH-65C6
        0x65C4, # G+6598  U+65C4  uni65C4,  CJK UNIFIED IDEOGRAPH-65C4
        0x65C3, # G+6599  U+65C3  uni65C3,  CJK UNIFIED IDEOGRAPH-65C3
        0x65CC, # G+6600  U+65CC  uni65CC,  CJK UNIFIED IDEOGRAPH-65CC
        0x65CE, # G+6601  U+65CE  uni65CE,  CJK UNIFIED IDEOGRAPH-65CE
        0x65D2, # G+6602  U+65D2  uni65D2,  CJK UNIFIED IDEOGRAPH-65D2
        0x65D6, # G+6603  U+65D6  uni65D6,  CJK UNIFIED IDEOGRAPH-65D6
        0x7080, # G+6604  U+7080  uni7080,  CJK UNIFIED IDEOGRAPH-7080
        0x709C, # G+6605  U+709C  uni709C,  CJK UNIFIED IDEOGRAPH-709C
        0x7096, # G+6606  U+7096  uni7096,  CJK UNIFIED IDEOGRAPH-7096
        0x709D, # G+6607  U+709D  uni709D,  CJK UNIFIED IDEOGRAPH-709D
        0x70BB, # G+6608  U+70BB  uni70BB,  CJK UNIFIED IDEOGRAPH-70BB
        0x70C0, # G+6609  U+70C0  uni70C0,  CJK UNIFIED IDEOGRAPH-70C0
        0x70B7, # G+6610  U+70B7  uni70B7,  CJK UNIFIED IDEOGRAPH-70B7
        0x70AB, # G+6611  U+70AB  uni70AB,  CJK UNIFIED IDEOGRAPH-70AB
        0x70B1, # G+6612  U+70B1  uni70B1,  CJK UNIFIED IDEOGRAPH-70B1
        0x70E8, # G+6613  U+70E8  uni70E8,  CJK UNIFIED IDEOGRAPH-70E8
        0x70CA, # G+6614  U+70CA  uni70CA,  CJK UNIFIED IDEOGRAPH-70CA
        0x7110, # G+6615  U+7110  uni7110,  CJK UNIFIED IDEOGRAPH-7110
        0x7113, # G+6616  U+7113  uni7113,  CJK UNIFIED IDEOGRAPH-7113
        0x7116, # G+6617  U+7116  uni7116,  CJK UNIFIED IDEOGRAPH-7116
        0x712F, # G+6618  U+712F  uni712F,  CJK UNIFIED IDEOGRAPH-712F
        0x7131, # G+6619  U+7131  uni7131,  CJK UNIFIED IDEOGRAPH-7131
        0x7173, # G+6620  U+7173  uni7173,  CJK UNIFIED IDEOGRAPH-7173
        0x715C, # G+6621  U+715C  uni715C,  CJK UNIFIED IDEOGRAPH-715C
        0x7168, # G+6622  U+7168  uni7168,  CJK UNIFIED IDEOGRAPH-7168
        0x7145, # G+6623  U+7145  uni7145,  CJK UNIFIED IDEOGRAPH-7145
        0x7172, # G+6624  U+7172  uni7172,  CJK UNIFIED IDEOGRAPH-7172
        0x714A, # G+6625  U+714A  uni714A,  CJK UNIFIED IDEOGRAPH-714A
        0x7178, # G+6626  U+7178  uni7178,  CJK UNIFIED IDEOGRAPH-7178
        0x717A, # G+6627  U+717A  uni717A,  CJK UNIFIED IDEOGRAPH-717A
        0x7198, # G+6628  U+7198  uni7198,  CJK UNIFIED IDEOGRAPH-7198
        0x71B3, # G+6629  U+71B3  uni71B3,  CJK UNIFIED IDEOGRAPH-71B3
        0x71B5, # G+6630  U+71B5  uni71B5,  CJK UNIFIED IDEOGRAPH-71B5
        0x71A8, # G+6631  U+71A8  uni71A8,  CJK UNIFIED IDEOGRAPH-71A8
        0x71A0, # G+6632  U+71A0  uni71A0,  CJK UNIFIED IDEOGRAPH-71A0
        0x71E0, # G+6633  U+71E0  uni71E0,  CJK UNIFIED IDEOGRAPH-71E0
        0x71D4, # G+6634  U+71D4  uni71D4,  CJK UNIFIED IDEOGRAPH-71D4
        0x71E7, # G+6635  U+71E7  uni71E7,  CJK UNIFIED IDEOGRAPH-71E7
        0x71F9, # G+6636  U+71F9  uni71F9,  CJK UNIFIED IDEOGRAPH-71F9
        0x721D, # G+6637  U+721D  uni721D,  CJK UNIFIED IDEOGRAPH-721D
        0x7228, # G+6638  U+7228  uni7228,  CJK UNIFIED IDEOGRAPH-7228
        0x706C, # G+6639  U+706C  uni706C,  CJK UNIFIED IDEOGRAPH-706C
        0x7118, # G+6640  U+7118  uni7118,  CJK UNIFIED IDEOGRAPH-7118
        0x7166, # G+6641  U+7166  uni7166,  CJK UNIFIED IDEOGRAPH-7166
        0x71B9, # G+6642  U+71B9  uni71B9,  CJK UNIFIED IDEOGRAPH-71B9
        0x623E, # G+6643  U+623E  uni623E,  CJK UNIFIED IDEOGRAPH-623E
        0x623D, # G+6644  U+623D  uni623D,  CJK UNIFIED IDEOGRAPH-623D
        0x6243, # G+6645  U+6243  uni6243,  CJK UNIFIED IDEOGRAPH-6243
        0x6248, # G+6646  U+6248  uni6248,  CJK UNIFIED IDEOGRAPH-6248
        0x6249, # G+6647  U+6249  uni6249,  CJK UNIFIED IDEOGRAPH-6249
        0x793B, # G+6648  U+793B  uni793B,  CJK UNIFIED IDEOGRAPH-793B
        0x7940, # G+6649  U+7940  uni7940,  CJK UNIFIED IDEOGRAPH-7940
        0x7946, # G+6650  U+7946  uni7946,  CJK UNIFIED IDEOGRAPH-7946
        0x7949, # G+6651  U+7949  uni7949,  CJK UNIFIED IDEOGRAPH-7949
        0x795B, # G+6652  U+795B  uni795B,  CJK UNIFIED IDEOGRAPH-795B
        0x795C, # G+6653  U+795C  uni795C,  CJK UNIFIED IDEOGRAPH-795C
        0x7953, # G+6654  U+7953  uni7953,  CJK UNIFIED IDEOGRAPH-7953
        0x795A, # G+6655  U+795A  uni795A,  CJK UNIFIED IDEOGRAPH-795A
        0x7962, # G+6656  U+7962  uni7962,  CJK UNIFIED IDEOGRAPH-7962
        0x7957, # G+6657  U+7957  uni7957,  CJK UNIFIED IDEOGRAPH-7957
        0x7960, # G+6658  U+7960  uni7960,  CJK UNIFIED IDEOGRAPH-7960
        0x796F, # G+6659  U+796F  uni796F,  CJK UNIFIED IDEOGRAPH-796F
        0x7967, # G+6660  U+7967  uni7967,  CJK UNIFIED IDEOGRAPH-7967
        0x797A, # G+6661  U+797A  uni797A,  CJK UNIFIED IDEOGRAPH-797A
        0x7985, # G+6662  U+7985  uni7985,  CJK UNIFIED IDEOGRAPH-7985
        0x798A, # G+6663  U+798A  uni798A,  CJK UNIFIED IDEOGRAPH-798A
        0x799A, # G+6664  U+799A  uni799A,  CJK UNIFIED IDEOGRAPH-799A
        0x79A7, # G+6665  U+79A7  uni79A7,  CJK UNIFIED IDEOGRAPH-79A7
        0x79B3, # G+6666  U+79B3  uni79B3,  CJK UNIFIED IDEOGRAPH-79B3
        0x5FD1, # G+6667  U+5FD1  uni5FD1,  CJK UNIFIED IDEOGRAPH-5FD1
        0x5FD0, # G+6668  U+5FD0  uni5FD0,  CJK UNIFIED IDEOGRAPH-5FD0
        0x603C, # G+6669  U+603C  uni603C,  CJK UNIFIED IDEOGRAPH-603C
        0x605D, # G+6670  U+605D  uni605D,  CJK UNIFIED IDEOGRAPH-605D
        0x605A, # G+6671  U+605A  uni605A,  CJK UNIFIED IDEOGRAPH-605A
        0x6067, # G+6672  U+6067  uni6067,  CJK UNIFIED IDEOGRAPH-6067
        0x6041, # G+6673  U+6041  uni6041,  CJK UNIFIED IDEOGRAPH-6041
        0x6059, # G+6674  U+6059  uni6059,  CJK UNIFIED IDEOGRAPH-6059
        0x6063, # G+6675  U+6063  uni6063,  CJK UNIFIED IDEOGRAPH-6063
        0x60AB, # G+6676  U+60AB  uni60AB,  CJK UNIFIED IDEOGRAPH-60AB
        0x6106, # G+6677  U+6106  uni6106,  CJK UNIFIED IDEOGRAPH-6106
        0x610D, # G+6678  U+610D  uni610D,  CJK UNIFIED IDEOGRAPH-610D
        0x615D, # G+6679  U+615D  uni615D,  CJK UNIFIED IDEOGRAPH-615D
        0x61A9, # G+6680  U+61A9  uni61A9,  CJK UNIFIED IDEOGRAPH-61A9
        0x619D, # G+6681  U+619D  uni619D,  CJK UNIFIED IDEOGRAPH-619D
        0x61CB, # G+6682  U+61CB  uni61CB,  CJK UNIFIED IDEOGRAPH-61CB
        0x61D1, # G+6683  U+61D1  uni61D1,  CJK UNIFIED IDEOGRAPH-61D1
        0x6206, # G+6684  U+6206  uni6206,  CJK UNIFIED IDEOGRAPH-6206
        0x8080, # G+6685  U+8080  uni8080,  CJK UNIFIED IDEOGRAPH-8080
        0x2F80, # G+6686  U+2F80  uni2F80,  KANGXI RADICAL BRUSH
        0x6C93, # G+6687  U+6C93  uni6C93,  CJK UNIFIED IDEOGRAPH-6C93
        0x6CF6, # G+6688  U+6CF6  uni6CF6,  CJK UNIFIED IDEOGRAPH-6CF6
        0x6DFC, # G+6689  U+6DFC  uni6DFC,  CJK UNIFIED IDEOGRAPH-6DFC
        0x77F6, # G+6690  U+77F6  uni77F6,  CJK UNIFIED IDEOGRAPH-77F6
        0x77F8, # G+6691  U+77F8  uni77F8,  CJK UNIFIED IDEOGRAPH-77F8
        0x7800, # G+6692  U+7800  uni7800,  CJK UNIFIED IDEOGRAPH-7800
        0x7809, # G+6693  U+7809  uni7809,  CJK UNIFIED IDEOGRAPH-7809
        0x7817, # G+6694  U+7817  uni7817,  CJK UNIFIED IDEOGRAPH-7817
        0x7818, # G+6695  U+7818  uni7818,  CJK UNIFIED IDEOGRAPH-7818
        0x7811, # G+6696  U+7811  uni7811,  CJK UNIFIED IDEOGRAPH-7811
        0x65AB, # G+6697  U+65AB  uni65AB,  CJK UNIFIED IDEOGRAPH-65AB
        0x782D, # G+6698  U+782D  uni782D,  CJK UNIFIED IDEOGRAPH-782D
        0x781C, # G+6699  U+781C  uni781C,  CJK UNIFIED IDEOGRAPH-781C
        0x781D, # G+6700  U+781D  uni781D,  CJK UNIFIED IDEOGRAPH-781D
        0x7839, # G+6701  U+7839  uni7839,  CJK UNIFIED IDEOGRAPH-7839
        0x783A, # G+6702  U+783A  uni783A,  CJK UNIFIED IDEOGRAPH-783A
        0x783B, # G+6703  U+783B  uni783B,  CJK UNIFIED IDEOGRAPH-783B
        0x781F, # G+6704  U+781F  uni781F,  CJK UNIFIED IDEOGRAPH-781F
        0x783C, # G+6705  U+783C  uni783C,  CJK UNIFIED IDEOGRAPH-783C
        0x7825, # G+6706  U+7825  uni7825,  CJK UNIFIED IDEOGRAPH-7825
        0x782C, # G+6707  U+782C  uni782C,  CJK UNIFIED IDEOGRAPH-782C
        0x7823, # G+6708  U+7823  uni7823,  CJK UNIFIED IDEOGRAPH-7823
        0x7829, # G+6709  U+7829  uni7829,  CJK UNIFIED IDEOGRAPH-7829
        0x784E, # G+6710  U+784E  uni784E,  CJK UNIFIED IDEOGRAPH-784E
        0x786D, # G+6711  U+786D  uni786D,  CJK UNIFIED IDEOGRAPH-786D
        0x7856, # G+6712  U+7856  uni7856,  CJK UNIFIED IDEOGRAPH-7856
        0x7857, # G+6713  U+7857  uni7857,  CJK UNIFIED IDEOGRAPH-7857
        0x7826, # G+6714  U+7826  uni7826,  CJK UNIFIED IDEOGRAPH-7826
        0x7850, # G+6715  U+7850  uni7850,  CJK UNIFIED IDEOGRAPH-7850
        0x7847, # G+6716  U+7847  uni7847,  CJK UNIFIED IDEOGRAPH-7847
        0x784C, # G+6717  U+784C  uni784C,  CJK UNIFIED IDEOGRAPH-784C
        0x786A, # G+6718  U+786A  uni786A,  CJK UNIFIED IDEOGRAPH-786A
        0x789B, # G+6719  U+789B  uni789B,  CJK UNIFIED IDEOGRAPH-789B
        0x7893, # G+6720  U+7893  uni7893,  CJK UNIFIED IDEOGRAPH-7893
        0x789A, # G+6721  U+789A  uni789A,  CJK UNIFIED IDEOGRAPH-789A
        0x7887, # G+6722  U+7887  uni7887,  CJK UNIFIED IDEOGRAPH-7887
        0x789C, # G+6723  U+789C  uni789C,  CJK UNIFIED IDEOGRAPH-789C
        0x78A1, # G+6724  U+78A1  uni78A1,  CJK UNIFIED IDEOGRAPH-78A1
        0x78A3, # G+6725  U+78A3  uni78A3,  CJK UNIFIED IDEOGRAPH-78A3
        0x78B2, # G+6726  U+78B2  uni78B2,  CJK UNIFIED IDEOGRAPH-78B2
        0x78B9, # G+6727  U+78B9  uni78B9,  CJK UNIFIED IDEOGRAPH-78B9
        0x78A5, # G+6728  U+78A5  uni78A5,  CJK UNIFIED IDEOGRAPH-78A5
        0x78D4, # G+6729  U+78D4  uni78D4,  CJK UNIFIED IDEOGRAPH-78D4
        0x78D9, # G+6730  U+78D9  uni78D9,  CJK UNIFIED IDEOGRAPH-78D9
        0x78C9, # G+6731  U+78C9  uni78C9,  CJK UNIFIED IDEOGRAPH-78C9
        0x78EC, # G+6732  U+78EC  uni78EC,  CJK UNIFIED IDEOGRAPH-78EC
        0x78F2, # G+6733  U+78F2  uni78F2,  CJK UNIFIED IDEOGRAPH-78F2
        0x7905, # G+6734  U+7905  uni7905,  CJK UNIFIED IDEOGRAPH-7905
        0x78F4, # G+6735  U+78F4  uni78F4,  CJK UNIFIED IDEOGRAPH-78F4
        0x7913, # G+6736  U+7913  uni7913,  CJK UNIFIED IDEOGRAPH-7913
        0x7924, # G+6737  U+7924  uni7924,  CJK UNIFIED IDEOGRAPH-7924
        0x791E, # G+6738  U+791E  uni791E,  CJK UNIFIED IDEOGRAPH-791E
        0x7934, # G+6739  U+7934  uni7934,  CJK UNIFIED IDEOGRAPH-7934
        0x9F9B, # G+6740  U+9F9B  uni9F9B,  CJK UNIFIED IDEOGRAPH-9F9B
        0x2FCB, # G+6741  U+2FCB  uni2FCB,  KANGXI RADICAL EMBROIDERY
        0x9EFB, # G+6742  U+9EFB  uni9EFB,  CJK UNIFIED IDEOGRAPH-9EFB
        0x9EFC, # G+6743  U+9EFC  uni9EFC,  CJK UNIFIED IDEOGRAPH-9EFC
        0x76F1, # G+6744  U+76F1  uni76F1,  CJK UNIFIED IDEOGRAPH-76F1
        0x7704, # G+6745  U+7704  uni7704,  CJK UNIFIED IDEOGRAPH-7704
        0x770D, # G+6746  U+770D  uni770D,  CJK UNIFIED IDEOGRAPH-770D
        0x76F9, # G+6747  U+76F9  uni76F9,  CJK UNIFIED IDEOGRAPH-76F9
        0x7707, # G+6748  U+7707  uni7707,  CJK UNIFIED IDEOGRAPH-7707
        0x7708, # G+6749  U+7708  uni7708,  CJK UNIFIED IDEOGRAPH-7708
        0x771A, # G+6750  U+771A  uni771A,  CJK UNIFIED IDEOGRAPH-771A
        0x7722, # G+6751  U+7722  uni7722,  CJK UNIFIED IDEOGRAPH-7722
        0x7719, # G+6752  U+7719  uni7719,  CJK UNIFIED IDEOGRAPH-7719
        0x772D, # G+6753  U+772D  uni772D,  CJK UNIFIED IDEOGRAPH-772D
        0x7726, # G+6754  U+7726  uni7726,  CJK UNIFIED IDEOGRAPH-7726
        0x7735, # G+6755  U+7735  uni7735,  CJK UNIFIED IDEOGRAPH-7735
        0x7738, # G+6756  U+7738  uni7738,  CJK UNIFIED IDEOGRAPH-7738
        0x7750, # G+6757  U+7750  uni7750,  CJK UNIFIED IDEOGRAPH-7750
        0x7751, # G+6758  U+7751  uni7751,  CJK UNIFIED IDEOGRAPH-7751
        0x7747, # G+6759  U+7747  uni7747,  CJK UNIFIED IDEOGRAPH-7747
        0x7743, # G+6760  U+7743  uni7743,  CJK UNIFIED IDEOGRAPH-7743
        0x775A, # G+6761  U+775A  uni775A,  CJK UNIFIED IDEOGRAPH-775A
        0x7768, # G+6762  U+7768  uni7768,  CJK UNIFIED IDEOGRAPH-7768
        0x7762, # G+6763  U+7762  uni7762,  CJK UNIFIED IDEOGRAPH-7762
        0x7765, # G+6764  U+7765  uni7765,  CJK UNIFIED IDEOGRAPH-7765
        0x777F, # G+6765  U+777F  uni777F,  CJK UNIFIED IDEOGRAPH-777F
        0x778D, # G+6766  U+778D  uni778D,  CJK UNIFIED IDEOGRAPH-778D
        0x777D, # G+6767  U+777D  uni777D,  CJK UNIFIED IDEOGRAPH-777D
        0x7780, # G+6768  U+7780  uni7780,  CJK UNIFIED IDEOGRAPH-7780
        0x778C, # G+6769  U+778C  uni778C,  CJK UNIFIED IDEOGRAPH-778C
        0x7791, # G+6770  U+7791  uni7791,  CJK UNIFIED IDEOGRAPH-7791
        0x779F, # G+6771  U+779F  uni779F,  CJK UNIFIED IDEOGRAPH-779F
        0x77A0, # G+6772  U+77A0  uni77A0,  CJK UNIFIED IDEOGRAPH-77A0
        0x77B0, # G+6773  U+77B0  uni77B0,  CJK UNIFIED IDEOGRAPH-77B0
        0x77B5, # G+6774  U+77B5  uni77B5,  CJK UNIFIED IDEOGRAPH-77B5
        0x77BD, # G+6775  U+77BD  uni77BD,  CJK UNIFIED IDEOGRAPH-77BD
        0x753A, # G+6776  U+753A  uni753A,  CJK UNIFIED IDEOGRAPH-753A
        0x7540, # G+6777  U+7540  uni7540,  CJK UNIFIED IDEOGRAPH-7540
        0x754E, # G+6778  U+754E  uni754E,  CJK UNIFIED IDEOGRAPH-754E
        0x754B, # G+6779  U+754B  uni754B,  CJK UNIFIED IDEOGRAPH-754B
        0x7548, # G+6780  U+7548  uni7548,  CJK UNIFIED IDEOGRAPH-7548
        0x755B, # G+6781  U+755B  uni755B,  CJK UNIFIED IDEOGRAPH-755B
        0x7572, # G+6782  U+7572  uni7572,  CJK UNIFIED IDEOGRAPH-7572
        0x7579, # G+6783  U+7579  uni7579,  CJK UNIFIED IDEOGRAPH-7579
        0x7583, # G+6784  U+7583  uni7583,  CJK UNIFIED IDEOGRAPH-7583
        0x7F58, # G+6785  U+7F58  uni7F58,  CJK UNIFIED IDEOGRAPH-7F58
        0x7F61, # G+6786  U+7F61  uni7F61,  CJK UNIFIED IDEOGRAPH-7F61
        0x7F5F, # G+6787  U+7F5F  uni7F5F,  CJK UNIFIED IDEOGRAPH-7F5F
        0x8A48, # G+6788  U+8A48  uni8A48,  CJK UNIFIED IDEOGRAPH-8A48
        0x7F68, # G+6789  U+7F68  uni7F68,  CJK UNIFIED IDEOGRAPH-7F68
        0x7F74, # G+6790  U+7F74  uni7F74,  CJK UNIFIED IDEOGRAPH-7F74
        0x7F71, # G+6791  U+7F71  uni7F71,  CJK UNIFIED IDEOGRAPH-7F71
        0x7F79, # G+6792  U+7F79  uni7F79,  CJK UNIFIED IDEOGRAPH-7F79
        0x7F81, # G+6793  U+7F81  uni7F81,  CJK UNIFIED IDEOGRAPH-7F81
        0x7F7E, # G+6794  U+7F7E  uni7F7E,  CJK UNIFIED IDEOGRAPH-7F7E
        0x76CD, # G+6795  U+76CD  uni76CD,  CJK UNIFIED IDEOGRAPH-76CD
        0x76E5, # G+6796  U+76E5  uni76E5,  CJK UNIFIED IDEOGRAPH-76E5
        0x8832, # G+6797  U+8832  uni8832,  CJK UNIFIED IDEOGRAPH-8832
        0x9485, # G+6798  U+9485  uni9485,  CJK UNIFIED IDEOGRAPH-9485
        0x9486, # G+6799  U+9486  uni9486,  CJK UNIFIED IDEOGRAPH-9486
        0x9487, # G+6800  U+9487  uni9487,  CJK UNIFIED IDEOGRAPH-9487
        0x948B, # G+6801  U+948B  uni948B,  CJK UNIFIED IDEOGRAPH-948B
        0x948A, # G+6802  U+948A  uni948A,  CJK UNIFIED IDEOGRAPH-948A
        0x948C, # G+6803  U+948C  uni948C,  CJK UNIFIED IDEOGRAPH-948C
        0x948D, # G+6804  U+948D  uni948D,  CJK UNIFIED IDEOGRAPH-948D
        0x948F, # G+6805  U+948F  uni948F,  CJK UNIFIED IDEOGRAPH-948F
        0x9490, # G+6806  U+9490  uni9490,  CJK UNIFIED IDEOGRAPH-9490
        0x9494, # G+6807  U+9494  uni9494,  CJK UNIFIED IDEOGRAPH-9494
        0x9497, # G+6808  U+9497  uni9497,  CJK UNIFIED IDEOGRAPH-9497
        0x9495, # G+6809  U+9495  uni9495,  CJK UNIFIED IDEOGRAPH-9495
        0x949A, # G+6810  U+949A  uni949A,  CJK UNIFIED IDEOGRAPH-949A
        0x949B, # G+6811  U+949B  uni949B,  CJK UNIFIED IDEOGRAPH-949B
        0x949C, # G+6812  U+949C  uni949C,  CJK UNIFIED IDEOGRAPH-949C
        0x94A3, # G+6813  U+94A3  uni94A3,  CJK UNIFIED IDEOGRAPH-94A3
        0x94A4, # G+6814  U+94A4  uni94A4,  CJK UNIFIED IDEOGRAPH-94A4
        0x94AB, # G+6815  U+94AB  uni94AB,  CJK UNIFIED IDEOGRAPH-94AB
        0x94AA, # G+6816  U+94AA  uni94AA,  CJK UNIFIED IDEOGRAPH-94AA
        0x94AD, # G+6817  U+94AD  uni94AD,  CJK UNIFIED IDEOGRAPH-94AD
        0x94AC, # G+6818  U+94AC  uni94AC,  CJK UNIFIED IDEOGRAPH-94AC
        0x94AF, # G+6819  U+94AF  uni94AF,  CJK UNIFIED IDEOGRAPH-94AF
        0x94B0, # G+6820  U+94B0  uni94B0,  CJK UNIFIED IDEOGRAPH-94B0
        0x94B2, # G+6821  U+94B2  uni94B2,  CJK UNIFIED IDEOGRAPH-94B2
        0x94B4, # G+6822  U+94B4  uni94B4,  CJK UNIFIED IDEOGRAPH-94B4
        0x94B6, # G+6823  U+94B6  uni94B6,  CJK UNIFIED IDEOGRAPH-94B6
        0x94B7, # G+6824  U+94B7  uni94B7,  CJK UNIFIED IDEOGRAPH-94B7
        0x94B8, # G+6825  U+94B8  uni94B8,  CJK UNIFIED IDEOGRAPH-94B8
        0x94B9, # G+6826  U+94B9  uni94B9,  CJK UNIFIED IDEOGRAPH-94B9
        0x94BA, # G+6827  U+94BA  uni94BA,  CJK UNIFIED IDEOGRAPH-94BA
        0x94BC, # G+6828  U+94BC  uni94BC,  CJK UNIFIED IDEOGRAPH-94BC
        0x94BD, # G+6829  U+94BD  uni94BD,  CJK UNIFIED IDEOGRAPH-94BD
        0x94BF, # G+6830  U+94BF  uni94BF,  CJK UNIFIED IDEOGRAPH-94BF
        0x94C4, # G+6831  U+94C4  uni94C4,  CJK UNIFIED IDEOGRAPH-94C4
        0x94C8, # G+6832  U+94C8  uni94C8,  CJK UNIFIED IDEOGRAPH-94C8
        0x94C9, # G+6833  U+94C9  uni94C9,  CJK UNIFIED IDEOGRAPH-94C9
        0x94CA, # G+6834  U+94CA  uni94CA,  CJK UNIFIED IDEOGRAPH-94CA
        0x94CB, # G+6835  U+94CB  uni94CB,  CJK UNIFIED IDEOGRAPH-94CB
        0x94CC, # G+6836  U+94CC  uni94CC,  CJK UNIFIED IDEOGRAPH-94CC
        0x94CD, # G+6837  U+94CD  uni94CD,  CJK UNIFIED IDEOGRAPH-94CD
        0x94CE, # G+6838  U+94CE  uni94CE,  CJK UNIFIED IDEOGRAPH-94CE
        0x94D0, # G+6839  U+94D0  uni94D0,  CJK UNIFIED IDEOGRAPH-94D0
        0x94D1, # G+6840  U+94D1  uni94D1,  CJK UNIFIED IDEOGRAPH-94D1
        0x94D2, # G+6841  U+94D2  uni94D2,  CJK UNIFIED IDEOGRAPH-94D2
        0x94D5, # G+6842  U+94D5  uni94D5,  CJK UNIFIED IDEOGRAPH-94D5
        0x94D6, # G+6843  U+94D6  uni94D6,  CJK UNIFIED IDEOGRAPH-94D6
        0x94D7, # G+6844  U+94D7  uni94D7,  CJK UNIFIED IDEOGRAPH-94D7
        0x94D9, # G+6845  U+94D9  uni94D9,  CJK UNIFIED IDEOGRAPH-94D9
        0x94D8, # G+6846  U+94D8  uni94D8,  CJK UNIFIED IDEOGRAPH-94D8
        0x94DB, # G+6847  U+94DB  uni94DB,  CJK UNIFIED IDEOGRAPH-94DB
        0x94DE, # G+6848  U+94DE  uni94DE,  CJK UNIFIED IDEOGRAPH-94DE
        0x94DF, # G+6849  U+94DF  uni94DF,  CJK UNIFIED IDEOGRAPH-94DF
        0x94E0, # G+6850  U+94E0  uni94E0,  CJK UNIFIED IDEOGRAPH-94E0
        0x94E2, # G+6851  U+94E2  uni94E2,  CJK UNIFIED IDEOGRAPH-94E2
        0x94E4, # G+6852  U+94E4  uni94E4,  CJK UNIFIED IDEOGRAPH-94E4
        0x94E5, # G+6853  U+94E5  uni94E5,  CJK UNIFIED IDEOGRAPH-94E5
        0x94E7, # G+6854  U+94E7  uni94E7,  CJK UNIFIED IDEOGRAPH-94E7
        0x94E8, # G+6855  U+94E8  uni94E8,  CJK UNIFIED IDEOGRAPH-94E8
        0x94EA, # G+6856  U+94EA  uni94EA,  CJK UNIFIED IDEOGRAPH-94EA
        0x94E9, # G+6857  U+94E9  uni94E9,  CJK UNIFIED IDEOGRAPH-94E9
        0x94EB, # G+6858  U+94EB  uni94EB,  CJK UNIFIED IDEOGRAPH-94EB
        0x94EE, # G+6859  U+94EE  uni94EE,  CJK UNIFIED IDEOGRAPH-94EE
        0x94EF, # G+6860  U+94EF  uni94EF,  CJK UNIFIED IDEOGRAPH-94EF
        0x94F3, # G+6861  U+94F3  uni94F3,  CJK UNIFIED IDEOGRAPH-94F3
        0x94F4, # G+6862  U+94F4  uni94F4,  CJK UNIFIED IDEOGRAPH-94F4
        0x94F5, # G+6863  U+94F5  uni94F5,  CJK UNIFIED IDEOGRAPH-94F5
        0x94F7, # G+6864  U+94F7  uni94F7,  CJK UNIFIED IDEOGRAPH-94F7
        0x94F9, # G+6865  U+94F9  uni94F9,  CJK UNIFIED IDEOGRAPH-94F9
        0x94FC, # G+6866  U+94FC  uni94FC,  CJK UNIFIED IDEOGRAPH-94FC
        0x94FD, # G+6867  U+94FD  uni94FD,  CJK UNIFIED IDEOGRAPH-94FD
        0x94FF, # G+6868  U+94FF  uni94FF,  CJK UNIFIED IDEOGRAPH-94FF
        0x9503, # G+6869  U+9503  uni9503,  CJK UNIFIED IDEOGRAPH-9503
        0x9502, # G+6870  U+9502  uni9502,  CJK UNIFIED IDEOGRAPH-9502
        0x9506, # G+6871  U+9506  uni9506,  CJK UNIFIED IDEOGRAPH-9506
        0x9507, # G+6872  U+9507  uni9507,  CJK UNIFIED IDEOGRAPH-9507
        0x9509, # G+6873  U+9509  uni9509,  CJK UNIFIED IDEOGRAPH-9509
        0x950A, # G+6874  U+950A  uni950A,  CJK UNIFIED IDEOGRAPH-950A
        0x950D, # G+6875  U+950D  uni950D,  CJK UNIFIED IDEOGRAPH-950D
        0x950E, # G+6876  U+950E  uni950E,  CJK UNIFIED IDEOGRAPH-950E
        0x950F, # G+6877  U+950F  uni950F,  CJK UNIFIED IDEOGRAPH-950F
        0x9512, # G+6878  U+9512  uni9512,  CJK UNIFIED IDEOGRAPH-9512
        0x9513, # G+6879  U+9513  uni9513,  CJK UNIFIED IDEOGRAPH-9513
        0x9514, # G+6880  U+9514  uni9514,  CJK UNIFIED IDEOGRAPH-9514
        0x9515, # G+6881  U+9515  uni9515,  CJK UNIFIED IDEOGRAPH-9515
        0x9516, # G+6882  U+9516  uni9516,  CJK UNIFIED IDEOGRAPH-9516
        0x9518, # G+6883  U+9518  uni9518,  CJK UNIFIED IDEOGRAPH-9518
        0x951B, # G+6884  U+951B  uni951B,  CJK UNIFIED IDEOGRAPH-951B
        0x951D, # G+6885  U+951D  uni951D,  CJK UNIFIED IDEOGRAPH-951D
        0x951E, # G+6886  U+951E  uni951E,  CJK UNIFIED IDEOGRAPH-951E
        0x951F, # G+6887  U+951F  uni951F,  CJK UNIFIED IDEOGRAPH-951F
        0x9522, # G+6888  U+9522  uni9522,  CJK UNIFIED IDEOGRAPH-9522
        0x952A, # G+6889  U+952A  uni952A,  CJK UNIFIED IDEOGRAPH-952A
        0x952B, # G+6890  U+952B  uni952B,  CJK UNIFIED IDEOGRAPH-952B
        0x9529, # G+6891  U+9529  uni9529,  CJK UNIFIED IDEOGRAPH-9529
        0x952C, # G+6892  U+952C  uni952C,  CJK UNIFIED IDEOGRAPH-952C
        0x9531, # G+6893  U+9531  uni9531,  CJK UNIFIED IDEOGRAPH-9531
        0x9532, # G+6894  U+9532  uni9532,  CJK UNIFIED IDEOGRAPH-9532
        0x9534, # G+6895  U+9534  uni9534,  CJK UNIFIED IDEOGRAPH-9534
        0x9536, # G+6896  U+9536  uni9536,  CJK UNIFIED IDEOGRAPH-9536
        0x9537, # G+6897  U+9537  uni9537,  CJK UNIFIED IDEOGRAPH-9537
        0x9538, # G+6898  U+9538  uni9538,  CJK UNIFIED IDEOGRAPH-9538
        0x953C, # G+6899  U+953C  uni953C,  CJK UNIFIED IDEOGRAPH-953C
        0x953E, # G+6900  U+953E  uni953E,  CJK UNIFIED IDEOGRAPH-953E
        0x953F, # G+6901  U+953F  uni953F,  CJK UNIFIED IDEOGRAPH-953F
        0x9542, # G+6902  U+9542  uni9542,  CJK UNIFIED IDEOGRAPH-9542
        0x9535, # G+6903  U+9535  uni9535,  CJK UNIFIED IDEOGRAPH-9535
        0x9544, # G+6904  U+9544  uni9544,  CJK UNIFIED IDEOGRAPH-9544
        0x9545, # G+6905  U+9545  uni9545,  CJK UNIFIED IDEOGRAPH-9545
        0x9546, # G+6906  U+9546  uni9546,  CJK UNIFIED IDEOGRAPH-9546
        0x9549, # G+6907  U+9549  uni9549,  CJK UNIFIED IDEOGRAPH-9549
        0x954C, # G+6908  U+954C  uni954C,  CJK UNIFIED IDEOGRAPH-954C
        0x954E, # G+6909  U+954E  uni954E,  CJK UNIFIED IDEOGRAPH-954E
        0x954F, # G+6910  U+954F  uni954F,  CJK UNIFIED IDEOGRAPH-954F
        0x9552, # G+6911  U+9552  uni9552,  CJK UNIFIED IDEOGRAPH-9552
        0x9553, # G+6912  U+9553  uni9553,  CJK UNIFIED IDEOGRAPH-9553
        0x9554, # G+6913  U+9554  uni9554,  CJK UNIFIED IDEOGRAPH-9554
        0x9556, # G+6914  U+9556  uni9556,  CJK UNIFIED IDEOGRAPH-9556
        0x9557, # G+6915  U+9557  uni9557,  CJK UNIFIED IDEOGRAPH-9557
        0x9558, # G+6916  U+9558  uni9558,  CJK UNIFIED IDEOGRAPH-9558
        0x9559, # G+6917  U+9559  uni9559,  CJK UNIFIED IDEOGRAPH-9559
        0x955B, # G+6918  U+955B  uni955B,  CJK UNIFIED IDEOGRAPH-955B
        0x955E, # G+6919  U+955E  uni955E,  CJK UNIFIED IDEOGRAPH-955E
        0x955F, # G+6920  U+955F  uni955F,  CJK UNIFIED IDEOGRAPH-955F
        0x955D, # G+6921  U+955D  uni955D,  CJK UNIFIED IDEOGRAPH-955D
        0x9561, # G+6922  U+9561  uni9561,  CJK UNIFIED IDEOGRAPH-9561
        0x9562, # G+6923  U+9562  uni9562,  CJK UNIFIED IDEOGRAPH-9562
        0x9564, # G+6924  U+9564  uni9564,  CJK UNIFIED IDEOGRAPH-9564
        0x9565, # G+6925  U+9565  uni9565,  CJK UNIFIED IDEOGRAPH-9565
        0x9566, # G+6926  U+9566  uni9566,  CJK UNIFIED IDEOGRAPH-9566
        0x9567, # G+6927  U+9567  uni9567,  CJK UNIFIED IDEOGRAPH-9567
        0x9568, # G+6928  U+9568  uni9568,  CJK UNIFIED IDEOGRAPH-9568
        0x9569, # G+6929  U+9569  uni9569,  CJK UNIFIED IDEOGRAPH-9569
        0x956A, # G+6930  U+956A  uni956A,  CJK UNIFIED IDEOGRAPH-956A
        0x956B, # G+6931  U+956B  uni956B,  CJK UNIFIED IDEOGRAPH-956B
        0x956C, # G+6932  U+956C  uni956C,  CJK UNIFIED IDEOGRAPH-956C
        0x956F, # G+6933  U+956F  uni956F,  CJK UNIFIED IDEOGRAPH-956F
        0x9571, # G+6934  U+9571  uni9571,  CJK UNIFIED IDEOGRAPH-9571
        0x9572, # G+6935  U+9572  uni9572,  CJK UNIFIED IDEOGRAPH-9572
        0x9573, # G+6936  U+9573  uni9573,  CJK UNIFIED IDEOGRAPH-9573
        0x953A, # G+6937  U+953A  uni953A,  CJK UNIFIED IDEOGRAPH-953A
        0x77E7, # G+6938  U+77E7  uni77E7,  CJK UNIFIED IDEOGRAPH-77E7
        0x77EC, # G+6939  U+77EC  uni77EC,  CJK UNIFIED IDEOGRAPH-77EC
        0x96C9, # G+6940  U+96C9  uni96C9,  CJK UNIFIED IDEOGRAPH-96C9
        0x79D5, # G+6941  U+79D5  uni79D5,  CJK UNIFIED IDEOGRAPH-79D5
        0x79ED, # G+6942  U+79ED  uni79ED,  CJK UNIFIED IDEOGRAPH-79ED
        0x79E3, # G+6943  U+79E3  uni79E3,  CJK UNIFIED IDEOGRAPH-79E3
        0x79EB, # G+6944  U+79EB  uni79EB,  CJK UNIFIED IDEOGRAPH-79EB
        0x7A06, # G+6945  U+7A06  uni7A06,  CJK UNIFIED IDEOGRAPH-7A06
        0x5D47, # G+6946  U+5D47  uni5D47,  CJK UNIFIED IDEOGRAPH-5D47
        0x7A03, # G+6947  U+7A03  uni7A03,  CJK UNIFIED IDEOGRAPH-7A03
        0x7A02, # G+6948  U+7A02  uni7A02,  CJK UNIFIED IDEOGRAPH-7A02
        0x7A1E, # G+6949  U+7A1E  uni7A1E,  CJK UNIFIED IDEOGRAPH-7A1E
        0x7A14, # G+6950  U+7A14  uni7A14,  CJK UNIFIED IDEOGRAPH-7A14
        0x7A39, # G+6951  U+7A39  uni7A39,  CJK UNIFIED IDEOGRAPH-7A39
        0x7A37, # G+6952  U+7A37  uni7A37,  CJK UNIFIED IDEOGRAPH-7A37
        0x7A51, # G+6953  U+7A51  uni7A51,  CJK UNIFIED IDEOGRAPH-7A51
        0x9ECF, # G+6954  U+9ECF  uni9ECF,  CJK UNIFIED IDEOGRAPH-9ECF
        0x99A5, # G+6955  U+99A5  uni99A5,  CJK UNIFIED IDEOGRAPH-99A5
        0x7A70, # G+6956  U+7A70  uni7A70,  CJK UNIFIED IDEOGRAPH-7A70
        0x7688, # G+6957  U+7688  uni7688,  CJK UNIFIED IDEOGRAPH-7688
        0x768E, # G+6958  U+768E  uni768E,  CJK UNIFIED IDEOGRAPH-768E
        0x7693, # G+6959  U+7693  uni7693,  CJK UNIFIED IDEOGRAPH-7693
        0x7699, # G+6960  U+7699  uni7699,  CJK UNIFIED IDEOGRAPH-7699
        0x76A4, # G+6961  U+76A4  uni76A4,  CJK UNIFIED IDEOGRAPH-76A4
        0x74DE, # G+6962  U+74DE  uni74DE,  CJK UNIFIED IDEOGRAPH-74DE
        0x74E0, # G+6963  U+74E0  uni74E0,  CJK UNIFIED IDEOGRAPH-74E0
        0x752C, # G+6964  U+752C  uni752C,  CJK UNIFIED IDEOGRAPH-752C
        0x9E20, # G+6965  U+9E20  uni9E20,  CJK UNIFIED IDEOGRAPH-9E20
        0x9E22, # G+6966  U+9E22  uni9E22,  CJK UNIFIED IDEOGRAPH-9E22
        0x9E28, # G+6967  U+9E28  uni9E28,  CJK UNIFIED IDEOGRAPH-9E28
        0x9E29, # G+6968  U+9E29  uni9E29,  CJK UNIFIED IDEOGRAPH-9E29
        0x9E2A, # G+6969  U+9E2A  uni9E2A,  CJK UNIFIED IDEOGRAPH-9E2A
        0x9E2B, # G+6970  U+9E2B  uni9E2B,  CJK UNIFIED IDEOGRAPH-9E2B
        0x9E2C, # G+6971  U+9E2C  uni9E2C,  CJK UNIFIED IDEOGRAPH-9E2C
        0x9E32, # G+6972  U+9E32  uni9E32,  CJK UNIFIED IDEOGRAPH-9E32
        0x9E31, # G+6973  U+9E31  uni9E31,  CJK UNIFIED IDEOGRAPH-9E31
        0x9E36, # G+6974  U+9E36  uni9E36,  CJK UNIFIED IDEOGRAPH-9E36
        0x9E38, # G+6975  U+9E38  uni9E38,  CJK UNIFIED IDEOGRAPH-9E38
        0x9E37, # G+6976  U+9E37  uni9E37,  CJK UNIFIED IDEOGRAPH-9E37
        0x9E39, # G+6977  U+9E39  uni9E39,  CJK UNIFIED IDEOGRAPH-9E39
        0x9E3A, # G+6978  U+9E3A  uni9E3A,  CJK UNIFIED IDEOGRAPH-9E3A
        0x9E3E, # G+6979  U+9E3E  uni9E3E,  CJK UNIFIED IDEOGRAPH-9E3E
        0x9E41, # G+6980  U+9E41  uni9E41,  CJK UNIFIED IDEOGRAPH-9E41
        0x9E42, # G+6981  U+9E42  uni9E42,  CJK UNIFIED IDEOGRAPH-9E42
        0x9E44, # G+6982  U+9E44  uni9E44,  CJK UNIFIED IDEOGRAPH-9E44
        0x9E46, # G+6983  U+9E46  uni9E46,  CJK UNIFIED IDEOGRAPH-9E46
        0x9E47, # G+6984  U+9E47  uni9E47,  CJK UNIFIED IDEOGRAPH-9E47
        0x9E48, # G+6985  U+9E48  uni9E48,  CJK UNIFIED IDEOGRAPH-9E48
        0x9E49, # G+6986  U+9E49  uni9E49,  CJK UNIFIED IDEOGRAPH-9E49
        0x9E4B, # G+6987  U+9E4B  uni9E4B,  CJK UNIFIED IDEOGRAPH-9E4B
        0x9E4C, # G+6988  U+9E4C  uni9E4C,  CJK UNIFIED IDEOGRAPH-9E4C
        0x9E4E, # G+6989  U+9E4E  uni9E4E,  CJK UNIFIED IDEOGRAPH-9E4E
        0x9E51, # G+6990  U+9E51  uni9E51,  CJK UNIFIED IDEOGRAPH-9E51
        0x9E55, # G+6991  U+9E55  uni9E55,  CJK UNIFIED IDEOGRAPH-9E55
        0x9E57, # G+6992  U+9E57  uni9E57,  CJK UNIFIED IDEOGRAPH-9E57
        0x9E5A, # G+6993  U+9E5A  uni9E5A,  CJK UNIFIED IDEOGRAPH-9E5A
        0x9E5B, # G+6994  U+9E5B  uni9E5B,  CJK UNIFIED IDEOGRAPH-9E5B
        0x9E5C, # G+6995  U+9E5C  uni9E5C,  CJK UNIFIED IDEOGRAPH-9E5C
        0x9E5E, # G+6996  U+9E5E  uni9E5E,  CJK UNIFIED IDEOGRAPH-9E5E
        0x9E63, # G+6997  U+9E63  uni9E63,  CJK UNIFIED IDEOGRAPH-9E63
        0x9E66, # G+6998  U+9E66  uni9E66,  CJK UNIFIED IDEOGRAPH-9E66
        0x9E67, # G+6999  U+9E67  uni9E67,  CJK UNIFIED IDEOGRAPH-9E67
        0x9E68, # G+7000  U+9E68  uni9E68,  CJK UNIFIED IDEOGRAPH-9E68
        0x9E69, # G+7001  U+9E69  uni9E69,  CJK UNIFIED IDEOGRAPH-9E69
        0x9E6A, # G+7002  U+9E6A  uni9E6A,  CJK UNIFIED IDEOGRAPH-9E6A
        0x9E6B, # G+7003  U+9E6B  uni9E6B,  CJK UNIFIED IDEOGRAPH-9E6B
        0x9E6C, # G+7004  U+9E6C  uni9E6C,  CJK UNIFIED IDEOGRAPH-9E6C
        0x9E71, # G+7005  U+9E71  uni9E71,  CJK UNIFIED IDEOGRAPH-9E71
        0x9E6D, # G+7006  U+9E6D  uni9E6D,  CJK UNIFIED IDEOGRAPH-9E6D
        0x9E73, # G+7007  U+9E73  uni9E73,  CJK UNIFIED IDEOGRAPH-9E73
        0x2F67, # G+7008  U+2F67  uni2F67,  KANGXI RADICAL SICKNESS
        0x7594, # G+7009  U+7594  uni7594,  CJK UNIFIED IDEOGRAPH-7594
        0x7596, # G+7010  U+7596  uni7596,  CJK UNIFIED IDEOGRAPH-7596
        0x75A0, # G+7011  U+75A0  uni75A0,  CJK UNIFIED IDEOGRAPH-75A0
        0x759D, # G+7012  U+759D  uni759D,  CJK UNIFIED IDEOGRAPH-759D
        0x75AC, # G+7013  U+75AC  uni75AC,  CJK UNIFIED IDEOGRAPH-75AC
        0x75A3, # G+7014  U+75A3  uni75A3,  CJK UNIFIED IDEOGRAPH-75A3
        0x75B3, # G+7015  U+75B3  uni75B3,  CJK UNIFIED IDEOGRAPH-75B3
        0x75B4, # G+7016  U+75B4  uni75B4,  CJK UNIFIED IDEOGRAPH-75B4
        0x75B8, # G+7017  U+75B8  uni75B8,  CJK UNIFIED IDEOGRAPH-75B8
        0x75C4, # G+7018  U+75C4  uni75C4,  CJK UNIFIED IDEOGRAPH-75C4
        0x75B1, # G+7019  U+75B1  uni75B1,  CJK UNIFIED IDEOGRAPH-75B1
        0x75B0, # G+7020  U+75B0  uni75B0,  CJK UNIFIED IDEOGRAPH-75B0
        0x75C3, # G+7021  U+75C3  uni75C3,  CJK UNIFIED IDEOGRAPH-75C3
        0x75C2, # G+7022  U+75C2  uni75C2,  CJK UNIFIED IDEOGRAPH-75C2
        0x75D6, # G+7023  U+75D6  uni75D6,  CJK UNIFIED IDEOGRAPH-75D6
        0x75CD, # G+7024  U+75CD  uni75CD,  CJK UNIFIED IDEOGRAPH-75CD
        0x75E3, # G+7025  U+75E3  uni75E3,  CJK UNIFIED IDEOGRAPH-75E3
        0x75E8, # G+7026  U+75E8  uni75E8,  CJK UNIFIED IDEOGRAPH-75E8
        0x75E6, # G+7027  U+75E6  uni75E6,  CJK UNIFIED IDEOGRAPH-75E6
        0x75E4, # G+7028  U+75E4  uni75E4,  CJK UNIFIED IDEOGRAPH-75E4
        0x75EB, # G+7029  U+75EB  uni75EB,  CJK UNIFIED IDEOGRAPH-75EB
        0x75E7, # G+7030  U+75E7  uni75E7,  CJK UNIFIED IDEOGRAPH-75E7
        0x7603, # G+7031  U+7603  uni7603,  CJK UNIFIED IDEOGRAPH-7603
        0x75F1, # G+7032  U+75F1  uni75F1,  CJK UNIFIED IDEOGRAPH-75F1
        0x75FC, # G+7033  U+75FC  uni75FC,  CJK UNIFIED IDEOGRAPH-75FC
        0x75FF, # G+7034  U+75FF  uni75FF,  CJK UNIFIED IDEOGRAPH-75FF
        0x7610, # G+7035  U+7610  uni7610,  CJK UNIFIED IDEOGRAPH-7610
        0x7600, # G+7036  U+7600  uni7600,  CJK UNIFIED IDEOGRAPH-7600
        0x7605, # G+7037  U+7605  uni7605,  CJK UNIFIED IDEOGRAPH-7605
        0x760C, # G+7038  U+760C  uni760C,  CJK UNIFIED IDEOGRAPH-760C
        0x7617, # G+7039  U+7617  uni7617,  CJK UNIFIED IDEOGRAPH-7617
        0x760A, # G+7040  U+760A  uni760A,  CJK UNIFIED IDEOGRAPH-760A
        0x7625, # G+7041  U+7625  uni7625,  CJK UNIFIED IDEOGRAPH-7625
        0x7618, # G+7042  U+7618  uni7618,  CJK UNIFIED IDEOGRAPH-7618
        0x7615, # G+7043  U+7615  uni7615,  CJK UNIFIED IDEOGRAPH-7615
        0x7619, # G+7044  U+7619  uni7619,  CJK UNIFIED IDEOGRAPH-7619
        0x761B, # G+7045  U+761B  uni761B,  CJK UNIFIED IDEOGRAPH-761B
        0x763C, # G+7046  U+763C  uni763C,  CJK UNIFIED IDEOGRAPH-763C
        0x7622, # G+7047  U+7622  uni7622,  CJK UNIFIED IDEOGRAPH-7622
        0x7620, # G+7048  U+7620  uni7620,  CJK UNIFIED IDEOGRAPH-7620
        0x7640, # G+7049  U+7640  uni7640,  CJK UNIFIED IDEOGRAPH-7640
        0x762D, # G+7050  U+762D  uni762D,  CJK UNIFIED IDEOGRAPH-762D
        0x7630, # G+7051  U+7630  uni7630,  CJK UNIFIED IDEOGRAPH-7630
        0x763F, # G+7052  U+763F  uni763F,  CJK UNIFIED IDEOGRAPH-763F
        0x7635, # G+7053  U+7635  uni7635,  CJK UNIFIED IDEOGRAPH-7635
        0x7643, # G+7054  U+7643  uni7643,  CJK UNIFIED IDEOGRAPH-7643
        0x763E, # G+7055  U+763E  uni763E,  CJK UNIFIED IDEOGRAPH-763E
        0x7633, # G+7056  U+7633  uni7633,  CJK UNIFIED IDEOGRAPH-7633
        0x764D, # G+7057  U+764D  uni764D,  CJK UNIFIED IDEOGRAPH-764D
        0x765E, # G+7058  U+765E  uni765E,  CJK UNIFIED IDEOGRAPH-765E
        0x7654, # G+7059  U+7654  uni7654,  CJK UNIFIED IDEOGRAPH-7654
        0x765C, # G+7060  U+765C  uni765C,  CJK UNIFIED IDEOGRAPH-765C
        0x7656, # G+7061  U+7656  uni7656,  CJK UNIFIED IDEOGRAPH-7656
        0x766B, # G+7062  U+766B  uni766B,  CJK UNIFIED IDEOGRAPH-766B
        0x766F, # G+7063  U+766F  uni766F,  CJK UNIFIED IDEOGRAPH-766F
        0x7FCA, # G+7064  U+7FCA  uni7FCA,  CJK UNIFIED IDEOGRAPH-7FCA
        0x7AE6, # G+7065  U+7AE6  uni7AE6,  CJK UNIFIED IDEOGRAPH-7AE6
        0x7A78, # G+7066  U+7A78  uni7A78,  CJK UNIFIED IDEOGRAPH-7A78
        0x7A79, # G+7067  U+7A79  uni7A79,  CJK UNIFIED IDEOGRAPH-7A79
        0x7A80, # G+7068  U+7A80  uni7A80,  CJK UNIFIED IDEOGRAPH-7A80
        0x7A86, # G+7069  U+7A86  uni7A86,  CJK UNIFIED IDEOGRAPH-7A86
        0x7A88, # G+7070  U+7A88  uni7A88,  CJK UNIFIED IDEOGRAPH-7A88
        0x7A95, # G+7071  U+7A95  uni7A95,  CJK UNIFIED IDEOGRAPH-7A95
        0x7AA6, # G+7072  U+7AA6  uni7AA6,  CJK UNIFIED IDEOGRAPH-7AA6
        0x7AA0, # G+7073  U+7AA0  uni7AA0,  CJK UNIFIED IDEOGRAPH-7AA0
        0x7AAC, # G+7074  U+7AAC  uni7AAC,  CJK UNIFIED IDEOGRAPH-7AAC
        0x7AA8, # G+7075  U+7AA8  uni7AA8,  CJK UNIFIED IDEOGRAPH-7AA8
        0x7AAD, # G+7076  U+7AAD  uni7AAD,  CJK UNIFIED IDEOGRAPH-7AAD
        0x7AB3, # G+7077  U+7AB3  uni7AB3,  CJK UNIFIED IDEOGRAPH-7AB3
        0x8864, # G+7078  U+8864  uni8864,  CJK UNIFIED IDEOGRAPH-8864
        0x8869, # G+7079  U+8869  uni8869,  CJK UNIFIED IDEOGRAPH-8869
        0x8872, # G+7080  U+8872  uni8872,  CJK UNIFIED IDEOGRAPH-8872
        0x887D, # G+7081  U+887D  uni887D,  CJK UNIFIED IDEOGRAPH-887D
        0x887F, # G+7082  U+887F  uni887F,  CJK UNIFIED IDEOGRAPH-887F
        0x8882, # G+7083  U+8882  uni8882,  CJK UNIFIED IDEOGRAPH-8882
        0x88A2, # G+7084  U+88A2  uni88A2,  CJK UNIFIED IDEOGRAPH-88A2
        0x88C6, # G+7085  U+88C6  uni88C6,  CJK UNIFIED IDEOGRAPH-88C6
        0x88B7, # G+7086  U+88B7  uni88B7,  CJK UNIFIED IDEOGRAPH-88B7
        0x88BC, # G+7087  U+88BC  uni88BC,  CJK UNIFIED IDEOGRAPH-88BC
        0x88C9, # G+7088  U+88C9  uni88C9,  CJK UNIFIED IDEOGRAPH-88C9
        0x88E2, # G+7089  U+88E2  uni88E2,  CJK UNIFIED IDEOGRAPH-88E2
        0x88CE, # G+7090  U+88CE  uni88CE,  CJK UNIFIED IDEOGRAPH-88CE
        0x88E3, # G+7091  U+88E3  uni88E3,  CJK UNIFIED IDEOGRAPH-88E3
        0x88E5, # G+7092  U+88E5  uni88E5,  CJK UNIFIED IDEOGRAPH-88E5
        0x88F1, # G+7093  U+88F1  uni88F1,  CJK UNIFIED IDEOGRAPH-88F1
        0x891A, # G+7094  U+891A  uni891A,  CJK UNIFIED IDEOGRAPH-891A
        0x88FC, # G+7095  U+88FC  uni88FC,  CJK UNIFIED IDEOGRAPH-88FC
        0x88E8, # G+7096  U+88E8  uni88E8,  CJK UNIFIED IDEOGRAPH-88E8
        0x88FE, # G+7097  U+88FE  uni88FE,  CJK UNIFIED IDEOGRAPH-88FE
        0x88F0, # G+7098  U+88F0  uni88F0,  CJK UNIFIED IDEOGRAPH-88F0
        0x8921, # G+7099  U+8921  uni8921,  CJK UNIFIED IDEOGRAPH-8921
        0x8919, # G+7100  U+8919  uni8919,  CJK UNIFIED IDEOGRAPH-8919
        0x8913, # G+7101  U+8913  uni8913,  CJK UNIFIED IDEOGRAPH-8913
        0x891B, # G+7102  U+891B  uni891B,  CJK UNIFIED IDEOGRAPH-891B
        0x890A, # G+7103  U+890A  uni890A,  CJK UNIFIED IDEOGRAPH-890A
        0x8934, # G+7104  U+8934  uni8934,  CJK UNIFIED IDEOGRAPH-8934
        0x892B, # G+7105  U+892B  uni892B,  CJK UNIFIED IDEOGRAPH-892B
        0x8936, # G+7106  U+8936  uni8936,  CJK UNIFIED IDEOGRAPH-8936
        0x8941, # G+7107  U+8941  uni8941,  CJK UNIFIED IDEOGRAPH-8941
        0x8966, # G+7108  U+8966  uni8966,  CJK UNIFIED IDEOGRAPH-8966
        0x897B, # G+7109  U+897B  uni897B,  CJK UNIFIED IDEOGRAPH-897B
        0x2F66, # G+7110  U+2F66  uni2F66,  KANGXI RADICAL BOLT OF CLOTH
        0x80E5, # G+7111  U+80E5  uni80E5,  CJK UNIFIED IDEOGRAPH-80E5
        0x76B2, # G+7112  U+76B2  uni76B2,  CJK UNIFIED IDEOGRAPH-76B2
        0x76B4, # G+7113  U+76B4  uni76B4,  CJK UNIFIED IDEOGRAPH-76B4
        0x77DC, # G+7114  U+77DC  uni77DC,  CJK UNIFIED IDEOGRAPH-77DC
        0x2F7E, # G+7115  U+2F7E  uni2F7E,  KANGXI RADICAL PLOW
        0x8014, # G+7116  U+8014  uni8014,  CJK UNIFIED IDEOGRAPH-8014
        0x8016, # G+7117  U+8016  uni8016,  CJK UNIFIED IDEOGRAPH-8016
        0x801C, # G+7118  U+801C  uni801C,  CJK UNIFIED IDEOGRAPH-801C
        0x8020, # G+7119  U+8020  uni8020,  CJK UNIFIED IDEOGRAPH-8020
        0x8022, # G+7120  U+8022  uni8022,  CJK UNIFIED IDEOGRAPH-8022
        0x8025, # G+7121  U+8025  uni8025,  CJK UNIFIED IDEOGRAPH-8025
        0x8026, # G+7122  U+8026  uni8026,  CJK UNIFIED IDEOGRAPH-8026
        0x8027, # G+7123  U+8027  uni8027,  CJK UNIFIED IDEOGRAPH-8027
        0x8029, # G+7124  U+8029  uni8029,  CJK UNIFIED IDEOGRAPH-8029
        0x8028, # G+7125  U+8028  uni8028,  CJK UNIFIED IDEOGRAPH-8028
        0x8031, # G+7126  U+8031  uni8031,  CJK UNIFIED IDEOGRAPH-8031
        0x800B, # G+7127  U+800B  uni800B,  CJK UNIFIED IDEOGRAPH-800B
        0x8035, # G+7128  U+8035  uni8035,  CJK UNIFIED IDEOGRAPH-8035
        0x8043, # G+7129  U+8043  uni8043,  CJK UNIFIED IDEOGRAPH-8043
        0x8046, # G+7130  U+8046  uni8046,  CJK UNIFIED IDEOGRAPH-8046
        0x804D, # G+7131  U+804D  uni804D,  CJK UNIFIED IDEOGRAPH-804D
        0x8052, # G+7132  U+8052  uni8052,  CJK UNIFIED IDEOGRAPH-8052
        0x8069, # G+7133  U+8069  uni8069,  CJK UNIFIED IDEOGRAPH-8069
        0x8071, # G+7134  U+8071  uni8071,  CJK UNIFIED IDEOGRAPH-8071
        0x8983, # G+7135  U+8983  uni8983,  CJK UNIFIED IDEOGRAPH-8983
        0x9878, # G+7136  U+9878  uni9878,  CJK UNIFIED IDEOGRAPH-9878
        0x9880, # G+7137  U+9880  uni9880,  CJK UNIFIED IDEOGRAPH-9880
        0x9883, # G+7138  U+9883  uni9883,  CJK UNIFIED IDEOGRAPH-9883
        0x9889, # G+7139  U+9889  uni9889,  CJK UNIFIED IDEOGRAPH-9889
        0x988C, # G+7140  U+988C  uni988C,  CJK UNIFIED IDEOGRAPH-988C
        0x988D, # G+7141  U+988D  uni988D,  CJK UNIFIED IDEOGRAPH-988D
        0x988F, # G+7142  U+988F  uni988F,  CJK UNIFIED IDEOGRAPH-988F
        0x9894, # G+7143  U+9894  uni9894,  CJK UNIFIED IDEOGRAPH-9894
        0x989A, # G+7144  U+989A  uni989A,  CJK UNIFIED IDEOGRAPH-989A
        0x989B, # G+7145  U+989B  uni989B,  CJK UNIFIED IDEOGRAPH-989B
        0x989E, # G+7146  U+989E  uni989E,  CJK UNIFIED IDEOGRAPH-989E
        0x989F, # G+7147  U+989F  uni989F,  CJK UNIFIED IDEOGRAPH-989F
        0x98A1, # G+7148  U+98A1  uni98A1,  CJK UNIFIED IDEOGRAPH-98A1
        0x98A2, # G+7149  U+98A2  uni98A2,  CJK UNIFIED IDEOGRAPH-98A2
        0x98A5, # G+7150  U+98A5  uni98A5,  CJK UNIFIED IDEOGRAPH-98A5
        0x98A6, # G+7151  U+98A6  uni98A6,  CJK UNIFIED IDEOGRAPH-98A6
        0x2F8C, # G+7152  U+2F8C  uni2F8C,  KANGXI RADICAL TIGER
        0x8654, # G+7153  U+8654  uni8654,  CJK UNIFIED IDEOGRAPH-8654
        0x866C, # G+7154  U+866C  uni866C,  CJK UNIFIED IDEOGRAPH-866C
        0x866E, # G+7155  U+866E  uni866E,  CJK UNIFIED IDEOGRAPH-866E
        0x867F, # G+7156  U+867F  uni867F,  CJK UNIFIED IDEOGRAPH-867F
        0x867A, # G+7157  U+867A  uni867A,  CJK UNIFIED IDEOGRAPH-867A
        0x867C, # G+7158  U+867C  uni867C,  CJK UNIFIED IDEOGRAPH-867C
        0x867B, # G+7159  U+867B  uni867B,  CJK UNIFIED IDEOGRAPH-867B
        0x86A8, # G+7160  U+86A8  uni86A8,  CJK UNIFIED IDEOGRAPH-86A8
        0x868D, # G+7161  U+868D  uni868D,  CJK UNIFIED IDEOGRAPH-868D
        0x868B, # G+7162  U+868B  uni868B,  CJK UNIFIED IDEOGRAPH-868B
        0x86AC, # G+7163  U+86AC  uni86AC,  CJK UNIFIED IDEOGRAPH-86AC
        0x869D, # G+7164  U+869D  uni869D,  CJK UNIFIED IDEOGRAPH-869D
        0x86A7, # G+7165  U+86A7  uni86A7,  CJK UNIFIED IDEOGRAPH-86A7
        0x86A3, # G+7166  U+86A3  uni86A3,  CJK UNIFIED IDEOGRAPH-86A3
        0x86AA, # G+7167  U+86AA  uni86AA,  CJK UNIFIED IDEOGRAPH-86AA
        0x8693, # G+7168  U+8693  uni8693,  CJK UNIFIED IDEOGRAPH-8693
        0x86A9, # G+7169  U+86A9  uni86A9,  CJK UNIFIED IDEOGRAPH-86A9
        0x86B6, # G+7170  U+86B6  uni86B6,  CJK UNIFIED IDEOGRAPH-86B6
        0x86C4, # G+7171  U+86C4  uni86C4,  CJK UNIFIED IDEOGRAPH-86C4
        0x86B5, # G+7172  U+86B5  uni86B5,  CJK UNIFIED IDEOGRAPH-86B5
        0x86CE, # G+7173  U+86CE  uni86CE,  CJK UNIFIED IDEOGRAPH-86CE
        0x86B0, # G+7174  U+86B0  uni86B0,  CJK UNIFIED IDEOGRAPH-86B0
        0x86BA, # G+7175  U+86BA  uni86BA,  CJK UNIFIED IDEOGRAPH-86BA
        0x86B1, # G+7176  U+86B1  uni86B1,  CJK UNIFIED IDEOGRAPH-86B1
        0x86AF, # G+7177  U+86AF  uni86AF,  CJK UNIFIED IDEOGRAPH-86AF
        0x86C9, # G+7178  U+86C9  uni86C9,  CJK UNIFIED IDEOGRAPH-86C9
        0x86CF, # G+7179  U+86CF  uni86CF,  CJK UNIFIED IDEOGRAPH-86CF
        0x86B4, # G+7180  U+86B4  uni86B4,  CJK UNIFIED IDEOGRAPH-86B4
        0x86E9, # G+7181  U+86E9  uni86E9,  CJK UNIFIED IDEOGRAPH-86E9
        0x86F1, # G+7182  U+86F1  uni86F1,  CJK UNIFIED IDEOGRAPH-86F1
        0x86F2, # G+7183  U+86F2  uni86F2,  CJK UNIFIED IDEOGRAPH-86F2
        0x86ED, # G+7184  U+86ED  uni86ED,  CJK UNIFIED IDEOGRAPH-86ED
        0x86F3, # G+7185  U+86F3  uni86F3,  CJK UNIFIED IDEOGRAPH-86F3
        0x86D0, # G+7186  U+86D0  uni86D0,  CJK UNIFIED IDEOGRAPH-86D0
        0x8713, # G+7187  U+8713  uni8713,  CJK UNIFIED IDEOGRAPH-8713
        0x86DE, # G+7188  U+86DE  uni86DE,  CJK UNIFIED IDEOGRAPH-86DE
        0x86F4, # G+7189  U+86F4  uni86F4,  CJK UNIFIED IDEOGRAPH-86F4
        0x86DF, # G+7190  U+86DF  uni86DF,  CJK UNIFIED IDEOGRAPH-86DF
        0x86D8, # G+7191  U+86D8  uni86D8,  CJK UNIFIED IDEOGRAPH-86D8
        0x86D1, # G+7192  U+86D1  uni86D1,  CJK UNIFIED IDEOGRAPH-86D1
        0x8703, # G+7193  U+8703  uni8703,  CJK UNIFIED IDEOGRAPH-8703
        0x8707, # G+7194  U+8707  uni8707,  CJK UNIFIED IDEOGRAPH-8707
        0x86F8, # G+7195  U+86F8  uni86F8,  CJK UNIFIED IDEOGRAPH-86F8
        0x8708, # G+7196  U+8708  uni8708,  CJK UNIFIED IDEOGRAPH-8708
        0x870A, # G+7197  U+870A  uni870A,  CJK UNIFIED IDEOGRAPH-870A
        0x870D, # G+7198  U+870D  uni870D,  CJK UNIFIED IDEOGRAPH-870D
        0x8709, # G+7199  U+8709  uni8709,  CJK UNIFIED IDEOGRAPH-8709
        0x8723, # G+7200  U+8723  uni8723,  CJK UNIFIED IDEOGRAPH-8723
        0x873B, # G+7201  U+873B  uni873B,  CJK UNIFIED IDEOGRAPH-873B
        0x871E, # G+7202  U+871E  uni871E,  CJK UNIFIED IDEOGRAPH-871E
        0x8725, # G+7203  U+8725  uni8725,  CJK UNIFIED IDEOGRAPH-8725
        0x872E, # G+7204  U+872E  uni872E,  CJK UNIFIED IDEOGRAPH-872E
        0x871A, # G+7205  U+871A  uni871A,  CJK UNIFIED IDEOGRAPH-871A
        0x873E, # G+7206  U+873E  uni873E,  CJK UNIFIED IDEOGRAPH-873E
        0x8748, # G+7207  U+8748  uni8748,  CJK UNIFIED IDEOGRAPH-8748
        0x8734, # G+7208  U+8734  uni8734,  CJK UNIFIED IDEOGRAPH-8734
        0x8731, # G+7209  U+8731  uni8731,  CJK UNIFIED IDEOGRAPH-8731
        0x8729, # G+7210  U+8729  uni8729,  CJK UNIFIED IDEOGRAPH-8729
        0x8737, # G+7211  U+8737  uni8737,  CJK UNIFIED IDEOGRAPH-8737
        0x873F, # G+7212  U+873F  uni873F,  CJK UNIFIED IDEOGRAPH-873F
        0x8782, # G+7213  U+8782  uni8782,  CJK UNIFIED IDEOGRAPH-8782
        0x8722, # G+7214  U+8722  uni8722,  CJK UNIFIED IDEOGRAPH-8722
        0x877D, # G+7215  U+877D  uni877D,  CJK UNIFIED IDEOGRAPH-877D
        0x877E, # G+7216  U+877E  uni877E,  CJK UNIFIED IDEOGRAPH-877E
        0x877B, # G+7217  U+877B  uni877B,  CJK UNIFIED IDEOGRAPH-877B
        0x8760, # G+7218  U+8760  uni8760,  CJK UNIFIED IDEOGRAPH-8760
        0x8770, # G+7219  U+8770  uni8770,  CJK UNIFIED IDEOGRAPH-8770
        0x874C, # G+7220  U+874C  uni874C,  CJK UNIFIED IDEOGRAPH-874C
        0x876E, # G+7221  U+876E  uni876E,  CJK UNIFIED IDEOGRAPH-876E
        0x878B, # G+7222  U+878B  uni878B,  CJK UNIFIED IDEOGRAPH-878B
        0x8753, # G+7223  U+8753  uni8753,  CJK UNIFIED IDEOGRAPH-8753
        0x8763, # G+7224  U+8763  uni8763,  CJK UNIFIED IDEOGRAPH-8763
        0x877C, # G+7225  U+877C  uni877C,  CJK UNIFIED IDEOGRAPH-877C
        0x8764, # G+7226  U+8764  uni8764,  CJK UNIFIED IDEOGRAPH-8764
        0x8759, # G+7227  U+8759  uni8759,  CJK UNIFIED IDEOGRAPH-8759
        0x8765, # G+7228  U+8765  uni8765,  CJK UNIFIED IDEOGRAPH-8765
        0x8793, # G+7229  U+8793  uni8793,  CJK UNIFIED IDEOGRAPH-8793
        0x87AF, # G+7230  U+87AF  uni87AF,  CJK UNIFIED IDEOGRAPH-87AF
        0x87A8, # G+7231  U+87A8  uni87A8,  CJK UNIFIED IDEOGRAPH-87A8
        0x87D2, # G+7232  U+87D2  uni87D2,  CJK UNIFIED IDEOGRAPH-87D2
        0x87C6, # G+7233  U+87C6  uni87C6,  CJK UNIFIED IDEOGRAPH-87C6
        0x8788, # G+7234  U+8788  uni8788,  CJK UNIFIED IDEOGRAPH-8788
        0x8785, # G+7235  U+8785  uni8785,  CJK UNIFIED IDEOGRAPH-8785
        0x87AD, # G+7236  U+87AD  uni87AD,  CJK UNIFIED IDEOGRAPH-87AD
        0x8797, # G+7237  U+8797  uni8797,  CJK UNIFIED IDEOGRAPH-8797
        0x8783, # G+7238  U+8783  uni8783,  CJK UNIFIED IDEOGRAPH-8783
        0x87AB, # G+7239  U+87AB  uni87AB,  CJK UNIFIED IDEOGRAPH-87AB
        0x87E5, # G+7240  U+87E5  uni87E5,  CJK UNIFIED IDEOGRAPH-87E5
        0x87AC, # G+7241  U+87AC  uni87AC,  CJK UNIFIED IDEOGRAPH-87AC
        0x87B5, # G+7242  U+87B5  uni87B5,  CJK UNIFIED IDEOGRAPH-87B5
        0x87B3, # G+7243  U+87B3  uni87B3,  CJK UNIFIED IDEOGRAPH-87B3
        0x87CB, # G+7244  U+87CB  uni87CB,  CJK UNIFIED IDEOGRAPH-87CB
        0x87D3, # G+7245  U+87D3  uni87D3,  CJK UNIFIED IDEOGRAPH-87D3
        0x87BD, # G+7246  U+87BD  uni87BD,  CJK UNIFIED IDEOGRAPH-87BD
        0x87D1, # G+7247  U+87D1  uni87D1,  CJK UNIFIED IDEOGRAPH-87D1
        0x87C0, # G+7248  U+87C0  uni87C0,  CJK UNIFIED IDEOGRAPH-87C0
        0x87CA, # G+7249  U+87CA  uni87CA,  CJK UNIFIED IDEOGRAPH-87CA
        0x87DB, # G+7250  U+87DB  uni87DB,  CJK UNIFIED IDEOGRAPH-87DB
        0x87EA, # G+7251  U+87EA  uni87EA,  CJK UNIFIED IDEOGRAPH-87EA
        0x87E0, # G+7252  U+87E0  uni87E0,  CJK UNIFIED IDEOGRAPH-87E0
        0x87EE, # G+7253  U+87EE  uni87EE,  CJK UNIFIED IDEOGRAPH-87EE
        0x8816, # G+7254  U+8816  uni8816,  CJK UNIFIED IDEOGRAPH-8816
        0x8813, # G+7255  U+8813  uni8813,  CJK UNIFIED IDEOGRAPH-8813
        0x87FE, # G+7256  U+87FE  uni87FE,  CJK UNIFIED IDEOGRAPH-87FE
        0x880A, # G+7257  U+880A  uni880A,  CJK UNIFIED IDEOGRAPH-880A
        0x881B, # G+7258  U+881B  uni881B,  CJK UNIFIED IDEOGRAPH-881B
        0x8821, # G+7259  U+8821  uni8821,  CJK UNIFIED IDEOGRAPH-8821
        0x8839, # G+7260  U+8839  uni8839,  CJK UNIFIED IDEOGRAPH-8839
        0x883C, # G+7261  U+883C  uni883C,  CJK UNIFIED IDEOGRAPH-883C
        0x2F78, # G+7262  U+2F78  uni2F78,  KANGXI RADICAL JAR
        0x7F42, # G+7263  U+7F42  uni7F42,  CJK UNIFIED IDEOGRAPH-7F42
        0x7F44, # G+7264  U+7F44  uni7F44,  CJK UNIFIED IDEOGRAPH-7F44
        0x7F45, # G+7265  U+7F45  uni7F45,  CJK UNIFIED IDEOGRAPH-7F45
        0x8210, # G+7266  U+8210  uni8210,  CJK UNIFIED IDEOGRAPH-8210
        0x7AFA, # G+7267  U+7AFA  uni7AFA,  CJK UNIFIED IDEOGRAPH-7AFA
        0x7AFD, # G+7268  U+7AFD  uni7AFD,  CJK UNIFIED IDEOGRAPH-7AFD
        0x7B08, # G+7269  U+7B08  uni7B08,  CJK UNIFIED IDEOGRAPH-7B08
        0x7B03, # G+7270  U+7B03  uni7B03,  CJK UNIFIED IDEOGRAPH-7B03
        0x7B04, # G+7271  U+7B04  uni7B04,  CJK UNIFIED IDEOGRAPH-7B04
        0x7B15, # G+7272  U+7B15  uni7B15,  CJK UNIFIED IDEOGRAPH-7B15
        0x7B0A, # G+7273  U+7B0A  uni7B0A,  CJK UNIFIED IDEOGRAPH-7B0A
        0x7B2B, # G+7274  U+7B2B  uni7B2B,  CJK UNIFIED IDEOGRAPH-7B2B
        0x7B0F, # G+7275  U+7B0F  uni7B0F,  CJK UNIFIED IDEOGRAPH-7B0F
        0x7B47, # G+7276  U+7B47  uni7B47,  CJK UNIFIED IDEOGRAPH-7B47
        0x7B38, # G+7277  U+7B38  uni7B38,  CJK UNIFIED IDEOGRAPH-7B38
        0x7B2A, # G+7278  U+7B2A  uni7B2A,  CJK UNIFIED IDEOGRAPH-7B2A
        0x7B19, # G+7279  U+7B19  uni7B19,  CJK UNIFIED IDEOGRAPH-7B19
        0x7B2E, # G+7280  U+7B2E  uni7B2E,  CJK UNIFIED IDEOGRAPH-7B2E
        0x7B31, # G+7281  U+7B31  uni7B31,  CJK UNIFIED IDEOGRAPH-7B31
        0x7B20, # G+7282  U+7B20  uni7B20,  CJK UNIFIED IDEOGRAPH-7B20
        0x7B25, # G+7283  U+7B25  uni7B25,  CJK UNIFIED IDEOGRAPH-7B25
        0x7B24, # G+7284  U+7B24  uni7B24,  CJK UNIFIED IDEOGRAPH-7B24
        0x7B33, # G+7285  U+7B33  uni7B33,  CJK UNIFIED IDEOGRAPH-7B33
        0x7B3E, # G+7286  U+7B3E  uni7B3E,  CJK UNIFIED IDEOGRAPH-7B3E
        0x7B1E, # G+7287  U+7B1E  uni7B1E,  CJK UNIFIED IDEOGRAPH-7B1E
        0x7B58, # G+7288  U+7B58  uni7B58,  CJK UNIFIED IDEOGRAPH-7B58
        0x7B5A, # G+7289  U+7B5A  uni7B5A,  CJK UNIFIED IDEOGRAPH-7B5A
        0x7B45, # G+7290  U+7B45  uni7B45,  CJK UNIFIED IDEOGRAPH-7B45
        0x7B75, # G+7291  U+7B75  uni7B75,  CJK UNIFIED IDEOGRAPH-7B75
        0x7B4C, # G+7292  U+7B4C  uni7B4C,  CJK UNIFIED IDEOGRAPH-7B4C
        0x7B5D, # G+7293  U+7B5D  uni7B5D,  CJK UNIFIED IDEOGRAPH-7B5D
        0x7B60, # G+7294  U+7B60  uni7B60,  CJK UNIFIED IDEOGRAPH-7B60
        0x7B6E, # G+7295  U+7B6E  uni7B6E,  CJK UNIFIED IDEOGRAPH-7B6E
        0x7B7B, # G+7296  U+7B7B  uni7B7B,  CJK UNIFIED IDEOGRAPH-7B7B
        0x7B62, # G+7297  U+7B62  uni7B62,  CJK UNIFIED IDEOGRAPH-7B62
        0x7B72, # G+7298  U+7B72  uni7B72,  CJK UNIFIED IDEOGRAPH-7B72
        0x7B71, # G+7299  U+7B71  uni7B71,  CJK UNIFIED IDEOGRAPH-7B71
        0x7B90, # G+7300  U+7B90  uni7B90,  CJK UNIFIED IDEOGRAPH-7B90
        0x7BA6, # G+7301  U+7BA6  uni7BA6,  CJK UNIFIED IDEOGRAPH-7BA6
        0x7BA7, # G+7302  U+7BA7  uni7BA7,  CJK UNIFIED IDEOGRAPH-7BA7
        0x7BB8, # G+7303  U+7BB8  uni7BB8,  CJK UNIFIED IDEOGRAPH-7BB8
        0x7BAC, # G+7304  U+7BAC  uni7BAC,  CJK UNIFIED IDEOGRAPH-7BAC
        0x7B9D, # G+7305  U+7B9D  uni7B9D,  CJK UNIFIED IDEOGRAPH-7B9D
        0x7BA8, # G+7306  U+7BA8  uni7BA8,  CJK UNIFIED IDEOGRAPH-7BA8
        0x7B85, # G+7307  U+7B85  uni7B85,  CJK UNIFIED IDEOGRAPH-7B85
        0x7BAA, # G+7308  U+7BAA  uni7BAA,  CJK UNIFIED IDEOGRAPH-7BAA
        0x7B9C, # G+7309  U+7B9C  uni7B9C,  CJK UNIFIED IDEOGRAPH-7B9C
        0x7BA2, # G+7310  U+7BA2  uni7BA2,  CJK UNIFIED IDEOGRAPH-7BA2
        0x7BAB, # G+7311  U+7BAB  uni7BAB,  CJK UNIFIED IDEOGRAPH-7BAB
        0x7BB4, # G+7312  U+7BB4  uni7BB4,  CJK UNIFIED IDEOGRAPH-7BB4
        0x7BD1, # G+7313  U+7BD1  uni7BD1,  CJK UNIFIED IDEOGRAPH-7BD1
        0x7BC1, # G+7314  U+7BC1  uni7BC1,  CJK UNIFIED IDEOGRAPH-7BC1
        0x7BCC, # G+7315  U+7BCC  uni7BCC,  CJK UNIFIED IDEOGRAPH-7BCC
        0x7BDD, # G+7316  U+7BDD  uni7BDD,  CJK UNIFIED IDEOGRAPH-7BDD
        0x7BDA, # G+7317  U+7BDA  uni7BDA,  CJK UNIFIED IDEOGRAPH-7BDA
        0x7BE5, # G+7318  U+7BE5  uni7BE5,  CJK UNIFIED IDEOGRAPH-7BE5
        0x7BE6, # G+7319  U+7BE6  uni7BE6,  CJK UNIFIED IDEOGRAPH-7BE6
        0x7BEA, # G+7320  U+7BEA  uni7BEA,  CJK UNIFIED IDEOGRAPH-7BEA
        0x7C0C, # G+7321  U+7C0C  uni7C0C,  CJK UNIFIED IDEOGRAPH-7C0C
        0x7BFE, # G+7322  U+7BFE  uni7BFE,  CJK UNIFIED IDEOGRAPH-7BFE
        0x7BFC, # G+7323  U+7BFC  uni7BFC,  CJK UNIFIED IDEOGRAPH-7BFC
        0x7C0F, # G+7324  U+7C0F  uni7C0F,  CJK UNIFIED IDEOGRAPH-7C0F
        0x7C16, # G+7325  U+7C16  uni7C16,  CJK UNIFIED IDEOGRAPH-7C16
        0x7C0B, # G+7326  U+7C0B  uni7C0B,  CJK UNIFIED IDEOGRAPH-7C0B
        0x7C1F, # G+7327  U+7C1F  uni7C1F,  CJK UNIFIED IDEOGRAPH-7C1F
        0x7C2A, # G+7328  U+7C2A  uni7C2A,  CJK UNIFIED IDEOGRAPH-7C2A
        0x7C26, # G+7329  U+7C26  uni7C26,  CJK UNIFIED IDEOGRAPH-7C26
        0x7C38, # G+7330  U+7C38  uni7C38,  CJK UNIFIED IDEOGRAPH-7C38
        0x7C41, # G+7331  U+7C41  uni7C41,  CJK UNIFIED IDEOGRAPH-7C41
        0x7C40, # G+7332  U+7C40  uni7C40,  CJK UNIFIED IDEOGRAPH-7C40
        0x81FE, # G+7333  U+81FE  uni81FE,  CJK UNIFIED IDEOGRAPH-81FE
        0x8201, # G+7334  U+8201  uni8201,  CJK UNIFIED IDEOGRAPH-8201
        0x8202, # G+7335  U+8202  uni8202,  CJK UNIFIED IDEOGRAPH-8202
        0x8204, # G+7336  U+8204  uni8204,  CJK UNIFIED IDEOGRAPH-8204
        0x81EC, # G+7337  U+81EC  uni81EC,  CJK UNIFIED IDEOGRAPH-81EC
        0x8844, # G+7338  U+8844  uni8844,  CJK UNIFIED IDEOGRAPH-8844
        0x8221, # G+7339  U+8221  uni8221,  CJK UNIFIED IDEOGRAPH-8221
        0x8222, # G+7340  U+8222  uni8222,  CJK UNIFIED IDEOGRAPH-8222
        0x8223, # G+7341  U+8223  uni8223,  CJK UNIFIED IDEOGRAPH-8223
        0x822D, # G+7342  U+822D  uni822D,  CJK UNIFIED IDEOGRAPH-822D
        0x822F, # G+7343  U+822F  uni822F,  CJK UNIFIED IDEOGRAPH-822F
        0x8228, # G+7344  U+8228  uni8228,  CJK UNIFIED IDEOGRAPH-8228
        0x822B, # G+7345  U+822B  uni822B,  CJK UNIFIED IDEOGRAPH-822B
        0x8238, # G+7346  U+8238  uni8238,  CJK UNIFIED IDEOGRAPH-8238
        0x823B, # G+7347  U+823B  uni823B,  CJK UNIFIED IDEOGRAPH-823B
        0x8233, # G+7348  U+8233  uni8233,  CJK UNIFIED IDEOGRAPH-8233
        0x8234, # G+7349  U+8234  uni8234,  CJK UNIFIED IDEOGRAPH-8234
        0x823E, # G+7350  U+823E  uni823E,  CJK UNIFIED IDEOGRAPH-823E
        0x8244, # G+7351  U+8244  uni8244,  CJK UNIFIED IDEOGRAPH-8244
        0x8249, # G+7352  U+8249  uni8249,  CJK UNIFIED IDEOGRAPH-8249
        0x824B, # G+7353  U+824B  uni824B,  CJK UNIFIED IDEOGRAPH-824B
        0x824F, # G+7354  U+824F  uni824F,  CJK UNIFIED IDEOGRAPH-824F
        0x825A, # G+7355  U+825A  uni825A,  CJK UNIFIED IDEOGRAPH-825A
        0x825F, # G+7356  U+825F  uni825F,  CJK UNIFIED IDEOGRAPH-825F
        0x8268, # G+7357  U+8268  uni8268,  CJK UNIFIED IDEOGRAPH-8268
        0x887E, # G+7358  U+887E  uni887E,  CJK UNIFIED IDEOGRAPH-887E
        0x8885, # G+7359  U+8885  uni8885,  CJK UNIFIED IDEOGRAPH-8885
        0x8888, # G+7360  U+8888  uni8888,  CJK UNIFIED IDEOGRAPH-8888
        0x88D8, # G+7361  U+88D8  uni88D8,  CJK UNIFIED IDEOGRAPH-88D8
        0x88DF, # G+7362  U+88DF  uni88DF,  CJK UNIFIED IDEOGRAPH-88DF
        0x895E, # G+7363  U+895E  uni895E,  CJK UNIFIED IDEOGRAPH-895E
        0x7F9D, # G+7364  U+7F9D  uni7F9D,  CJK UNIFIED IDEOGRAPH-7F9D
        0x7F9F, # G+7365  U+7F9F  uni7F9F,  CJK UNIFIED IDEOGRAPH-7F9F
        0x7FA7, # G+7366  U+7FA7  uni7FA7,  CJK UNIFIED IDEOGRAPH-7FA7
        0x7FAF, # G+7367  U+7FAF  uni7FAF,  CJK UNIFIED IDEOGRAPH-7FAF
        0x7FB0, # G+7368  U+7FB0  uni7FB0,  CJK UNIFIED IDEOGRAPH-7FB0
        0x7FB2, # G+7369  U+7FB2  uni7FB2,  CJK UNIFIED IDEOGRAPH-7FB2
        0x7C7C, # G+7370  U+7C7C  uni7C7C,  CJK UNIFIED IDEOGRAPH-7C7C
        0x6549, # G+7371  U+6549  uni6549,  CJK UNIFIED IDEOGRAPH-6549
        0x7C91, # G+7372  U+7C91  uni7C91,  CJK UNIFIED IDEOGRAPH-7C91
        0x7C9D, # G+7373  U+7C9D  uni7C9D,  CJK UNIFIED IDEOGRAPH-7C9D
        0x7C9C, # G+7374  U+7C9C  uni7C9C,  CJK UNIFIED IDEOGRAPH-7C9C
        0x7C9E, # G+7375  U+7C9E  uni7C9E,  CJK UNIFIED IDEOGRAPH-7C9E
        0x7CA2, # G+7376  U+7CA2  uni7CA2,  CJK UNIFIED IDEOGRAPH-7CA2
        0x7CB2, # G+7377  U+7CB2  uni7CB2,  CJK UNIFIED IDEOGRAPH-7CB2
        0x7CBC, # G+7378  U+7CBC  uni7CBC,  CJK UNIFIED IDEOGRAPH-7CBC
        0x7CBD, # G+7379  U+7CBD  uni7CBD,  CJK UNIFIED IDEOGRAPH-7CBD
        0x7CC1, # G+7380  U+7CC1  uni7CC1,  CJK UNIFIED IDEOGRAPH-7CC1
        0x7CC7, # G+7381  U+7CC7  uni7CC7,  CJK UNIFIED IDEOGRAPH-7CC7
        0x7CCC, # G+7382  U+7CCC  uni7CCC,  CJK UNIFIED IDEOGRAPH-7CCC
        0x7CCD, # G+7383  U+7CCD  uni7CCD,  CJK UNIFIED IDEOGRAPH-7CCD
        0x7CC8, # G+7384  U+7CC8  uni7CC8,  CJK UNIFIED IDEOGRAPH-7CC8
        0x7CC5, # G+7385  U+7CC5  uni7CC5,  CJK UNIFIED IDEOGRAPH-7CC5
        0x7CD7, # G+7386  U+7CD7  uni7CD7,  CJK UNIFIED IDEOGRAPH-7CD7
        0x7CE8, # G+7387  U+7CE8  uni7CE8,  CJK UNIFIED IDEOGRAPH-7CE8
        0x2F89, # G+7388  U+2F89  uni2F89,  KANGXI RADICAL STOPPING
        0x66A8, # G+7389  U+66A8  uni66A8,  CJK UNIFIED IDEOGRAPH-66A8
        0x7FBF, # G+7390  U+7FBF  uni7FBF,  CJK UNIFIED IDEOGRAPH-7FBF
        0x7FCE, # G+7391  U+7FCE  uni7FCE,  CJK UNIFIED IDEOGRAPH-7FCE
        0x7FD5, # G+7392  U+7FD5  uni7FD5,  CJK UNIFIED IDEOGRAPH-7FD5
        0x7FE5, # G+7393  U+7FE5  uni7FE5,  CJK UNIFIED IDEOGRAPH-7FE5
        0x7FE1, # G+7394  U+7FE1  uni7FE1,  CJK UNIFIED IDEOGRAPH-7FE1
        0x7FE6, # G+7395  U+7FE6  uni7FE6,  CJK UNIFIED IDEOGRAPH-7FE6
        0x7FE9, # G+7396  U+7FE9  uni7FE9,  CJK UNIFIED IDEOGRAPH-7FE9
        0x7FEE, # G+7397  U+7FEE  uni7FEE,  CJK UNIFIED IDEOGRAPH-7FEE
        0x7FF3, # G+7398  U+7FF3  uni7FF3,  CJK UNIFIED IDEOGRAPH-7FF3
        0x2F77, # G+7399  U+2F77  uni2F77,  KANGXI RADICAL SILK
        0x7D77, # G+7400  U+7D77  uni7D77,  CJK UNIFIED IDEOGRAPH-7D77
        0x7DA6, # G+7401  U+7DA6  uni7DA6,  CJK UNIFIED IDEOGRAPH-7DA6
        0x7DAE, # G+7402  U+7DAE  uni7DAE,  CJK UNIFIED IDEOGRAPH-7DAE
        0x7E47, # G+7403  U+7E47  uni7E47,  CJK UNIFIED IDEOGRAPH-7E47
        0x7E9B, # G+7404  U+7E9B  uni7E9B,  CJK UNIFIED IDEOGRAPH-7E9B
        0x9EB8, # G+7405  U+9EB8  uni9EB8,  CJK UNIFIED IDEOGRAPH-9EB8
        0x9EB4, # G+7406  U+9EB4  uni9EB4,  CJK UNIFIED IDEOGRAPH-9EB4
        0x8D73, # G+7407  U+8D73  uni8D73,  CJK UNIFIED IDEOGRAPH-8D73
        0x8D84, # G+7408  U+8D84  uni8D84,  CJK UNIFIED IDEOGRAPH-8D84
        0x8D94, # G+7409  U+8D94  uni8D94,  CJK UNIFIED IDEOGRAPH-8D94
        0x8D91, # G+7410  U+8D91  uni8D91,  CJK UNIFIED IDEOGRAPH-8D91
        0x8DB1, # G+7411  U+8DB1  uni8DB1,  CJK UNIFIED IDEOGRAPH-8DB1
        0x8D67, # G+7412  U+8D67  uni8D67,  CJK UNIFIED IDEOGRAPH-8D67
        0x8D6D, # G+7413  U+8D6D  uni8D6D,  CJK UNIFIED IDEOGRAPH-8D6D
        0x8C47, # G+7414  U+8C47  uni8C47,  CJK UNIFIED IDEOGRAPH-8C47
        0x8C49, # G+7415  U+8C49  uni8C49,  CJK UNIFIED IDEOGRAPH-8C49
        0x914A, # G+7416  U+914A  uni914A,  CJK UNIFIED IDEOGRAPH-914A
        0x9150, # G+7417  U+9150  uni9150,  CJK UNIFIED IDEOGRAPH-9150
        0x914E, # G+7418  U+914E  uni914E,  CJK UNIFIED IDEOGRAPH-914E
        0x914F, # G+7419  U+914F  uni914F,  CJK UNIFIED IDEOGRAPH-914F
        0x9164, # G+7420  U+9164  uni9164,  CJK UNIFIED IDEOGRAPH-9164
        0x9162, # G+7421  U+9162  uni9162,  CJK UNIFIED IDEOGRAPH-9162
        0x9161, # G+7422  U+9161  uni9161,  CJK UNIFIED IDEOGRAPH-9161
        0x9170, # G+7423  U+9170  uni9170,  CJK UNIFIED IDEOGRAPH-9170
        0x9169, # G+7424  U+9169  uni9169,  CJK UNIFIED IDEOGRAPH-9169
        0x916F, # G+7425  U+916F  uni916F,  CJK UNIFIED IDEOGRAPH-916F
        0x917D, # G+7426  U+917D  uni917D,  CJK UNIFIED IDEOGRAPH-917D
        0x917E, # G+7427  U+917E  uni917E,  CJK UNIFIED IDEOGRAPH-917E
        0x9172, # G+7428  U+9172  uni9172,  CJK UNIFIED IDEOGRAPH-9172
        0x9174, # G+7429  U+9174  uni9174,  CJK UNIFIED IDEOGRAPH-9174
        0x9179, # G+7430  U+9179  uni9179,  CJK UNIFIED IDEOGRAPH-9179
        0x918C, # G+7431  U+918C  uni918C,  CJK UNIFIED IDEOGRAPH-918C
        0x9185, # G+7432  U+9185  uni9185,  CJK UNIFIED IDEOGRAPH-9185
        0x9190, # G+7433  U+9190  uni9190,  CJK UNIFIED IDEOGRAPH-9190
        0x918D, # G+7434  U+918D  uni918D,  CJK UNIFIED IDEOGRAPH-918D
        0x9191, # G+7435  U+9191  uni9191,  CJK UNIFIED IDEOGRAPH-9191
        0x91A2, # G+7436  U+91A2  uni91A2,  CJK UNIFIED IDEOGRAPH-91A2
        0x91A3, # G+7437  U+91A3  uni91A3,  CJK UNIFIED IDEOGRAPH-91A3
        0x91AA, # G+7438  U+91AA  uni91AA,  CJK UNIFIED IDEOGRAPH-91AA
        0x91AD, # G+7439  U+91AD  uni91AD,  CJK UNIFIED IDEOGRAPH-91AD
        0x91AE, # G+7440  U+91AE  uni91AE,  CJK UNIFIED IDEOGRAPH-91AE
        0x91AF, # G+7441  U+91AF  uni91AF,  CJK UNIFIED IDEOGRAPH-91AF
        0x91B5, # G+7442  U+91B5  uni91B5,  CJK UNIFIED IDEOGRAPH-91B5
        0x91B4, # G+7443  U+91B4  uni91B4,  CJK UNIFIED IDEOGRAPH-91B4
        0x91BA, # G+7444  U+91BA  uni91BA,  CJK UNIFIED IDEOGRAPH-91BA
        0x2F97, # G+7445  U+2F97  uni2F97,  KANGXI RADICAL PIG
        0x9E7E, # G+7446  U+9E7E  uni9E7E,  CJK UNIFIED IDEOGRAPH-9E7E
        0x8DB8, # G+7447  U+8DB8  uni8DB8,  CJK UNIFIED IDEOGRAPH-8DB8
        0x8DEB, # G+7448  U+8DEB  uni8DEB,  CJK UNIFIED IDEOGRAPH-8DEB
        0x8E05, # G+7449  U+8E05  uni8E05,  CJK UNIFIED IDEOGRAPH-8E05
        0x8E59, # G+7450  U+8E59  uni8E59,  CJK UNIFIED IDEOGRAPH-8E59
        0x8E69, # G+7451  U+8E69  uni8E69,  CJK UNIFIED IDEOGRAPH-8E69
        0x8DB5, # G+7452  U+8DB5  uni8DB5,  CJK UNIFIED IDEOGRAPH-8DB5
        0x8DBF, # G+7453  U+8DBF  uni8DBF,  CJK UNIFIED IDEOGRAPH-8DBF
        0x8DBC, # G+7454  U+8DBC  uni8DBC,  CJK UNIFIED IDEOGRAPH-8DBC
        0x8DBA, # G+7455  U+8DBA  uni8DBA,  CJK UNIFIED IDEOGRAPH-8DBA
        0x8DC4, # G+7456  U+8DC4  uni8DC4,  CJK UNIFIED IDEOGRAPH-8DC4
        0x8DD6, # G+7457  U+8DD6  uni8DD6,  CJK UNIFIED IDEOGRAPH-8DD6
        0x8DD7, # G+7458  U+8DD7  uni8DD7,  CJK UNIFIED IDEOGRAPH-8DD7
        0x8DDA, # G+7459  U+8DDA  uni8DDA,  CJK UNIFIED IDEOGRAPH-8DDA
        0x8DDE, # G+7460  U+8DDE  uni8DDE,  CJK UNIFIED IDEOGRAPH-8DDE
        0x8DCE, # G+7461  U+8DCE  uni8DCE,  CJK UNIFIED IDEOGRAPH-8DCE
        0x8DCF, # G+7462  U+8DCF  uni8DCF,  CJK UNIFIED IDEOGRAPH-8DCF
        0x8DDB, # G+7463  U+8DDB  uni8DDB,  CJK UNIFIED IDEOGRAPH-8DDB
        0x8DC6, # G+7464  U+8DC6  uni8DC6,  CJK UNIFIED IDEOGRAPH-8DC6
        0x8DEC, # G+7465  U+8DEC  uni8DEC,  CJK UNIFIED IDEOGRAPH-8DEC
        0x8DF7, # G+7466  U+8DF7  uni8DF7,  CJK UNIFIED IDEOGRAPH-8DF7
        0x8DF8, # G+7467  U+8DF8  uni8DF8,  CJK UNIFIED IDEOGRAPH-8DF8
        0x8DE3, # G+7468  U+8DE3  uni8DE3,  CJK UNIFIED IDEOGRAPH-8DE3
        0x8DF9, # G+7469  U+8DF9  uni8DF9,  CJK UNIFIED IDEOGRAPH-8DF9
        0x8DFB, # G+7470  U+8DFB  uni8DFB,  CJK UNIFIED IDEOGRAPH-8DFB
        0x8DE4, # G+7471  U+8DE4  uni8DE4,  CJK UNIFIED IDEOGRAPH-8DE4
        0x8E09, # G+7472  U+8E09  uni8E09,  CJK UNIFIED IDEOGRAPH-8E09
        0x8DFD, # G+7473  U+8DFD  uni8DFD,  CJK UNIFIED IDEOGRAPH-8DFD
        0x8E14, # G+7474  U+8E14  uni8E14,  CJK UNIFIED IDEOGRAPH-8E14
        0x8E1D, # G+7475  U+8E1D  uni8E1D,  CJK UNIFIED IDEOGRAPH-8E1D
        0x8E1F, # G+7476  U+8E1F  uni8E1F,  CJK UNIFIED IDEOGRAPH-8E1F
        0x8E2C, # G+7477  U+8E2C  uni8E2C,  CJK UNIFIED IDEOGRAPH-8E2C
        0x8E2E, # G+7478  U+8E2E  uni8E2E,  CJK UNIFIED IDEOGRAPH-8E2E
        0x8E23, # G+7479  U+8E23  uni8E23,  CJK UNIFIED IDEOGRAPH-8E23
        0x8E2F, # G+7480  U+8E2F  uni8E2F,  CJK UNIFIED IDEOGRAPH-8E2F
        0x8E3A, # G+7481  U+8E3A  uni8E3A,  CJK UNIFIED IDEOGRAPH-8E3A
        0x8E40, # G+7482  U+8E40  uni8E40,  CJK UNIFIED IDEOGRAPH-8E40
        0x8E39, # G+7483  U+8E39  uni8E39,  CJK UNIFIED IDEOGRAPH-8E39
        0x8E35, # G+7484  U+8E35  uni8E35,  CJK UNIFIED IDEOGRAPH-8E35
        0x8E3D, # G+7485  U+8E3D  uni8E3D,  CJK UNIFIED IDEOGRAPH-8E3D
        0x8E31, # G+7486  U+8E31  uni8E31,  CJK UNIFIED IDEOGRAPH-8E31
        0x8E49, # G+7487  U+8E49  uni8E49,  CJK UNIFIED IDEOGRAPH-8E49
        0x8E41, # G+7488  U+8E41  uni8E41,  CJK UNIFIED IDEOGRAPH-8E41
        0x8E42, # G+7489  U+8E42  uni8E42,  CJK UNIFIED IDEOGRAPH-8E42
        0x8E51, # G+7490  U+8E51  uni8E51,  CJK UNIFIED IDEOGRAPH-8E51
        0x8E52, # G+7491  U+8E52  uni8E52,  CJK UNIFIED IDEOGRAPH-8E52
        0x8E4A, # G+7492  U+8E4A  uni8E4A,  CJK UNIFIED IDEOGRAPH-8E4A
        0x8E70, # G+7493  U+8E70  uni8E70,  CJK UNIFIED IDEOGRAPH-8E70
        0x8E76, # G+7494  U+8E76  uni8E76,  CJK UNIFIED IDEOGRAPH-8E76
        0x8E7C, # G+7495  U+8E7C  uni8E7C,  CJK UNIFIED IDEOGRAPH-8E7C
        0x8E6F, # G+7496  U+8E6F  uni8E6F,  CJK UNIFIED IDEOGRAPH-8E6F
        0x8E74, # G+7497  U+8E74  uni8E74,  CJK UNIFIED IDEOGRAPH-8E74
        0x8E85, # G+7498  U+8E85  uni8E85,  CJK UNIFIED IDEOGRAPH-8E85
        0x8E8F, # G+7499  U+8E8F  uni8E8F,  CJK UNIFIED IDEOGRAPH-8E8F
        0x8E94, # G+7500  U+8E94  uni8E94,  CJK UNIFIED IDEOGRAPH-8E94
        0x8E90, # G+7501  U+8E90  uni8E90,  CJK UNIFIED IDEOGRAPH-8E90
        0x8E9C, # G+7502  U+8E9C  uni8E9C,  CJK UNIFIED IDEOGRAPH-8E9C
        0x8E9E, # G+7503  U+8E9E  uni8E9E,  CJK UNIFIED IDEOGRAPH-8E9E
        0x2F98, # G+7504  U+2F98  uni2F98,  KANGXI RADICAL BADGER
        0x8C82, # G+7505  U+8C82  uni8C82,  CJK UNIFIED IDEOGRAPH-8C82
        0x8C8A, # G+7506  U+8C8A  uni8C8A,  CJK UNIFIED IDEOGRAPH-8C8A
        0x8C85, # G+7507  U+8C85  uni8C85,  CJK UNIFIED IDEOGRAPH-8C85
        0x8C98, # G+7508  U+8C98  uni8C98,  CJK UNIFIED IDEOGRAPH-8C98
        0x8C94, # G+7509  U+8C94  uni8C94,  CJK UNIFIED IDEOGRAPH-8C94
        0x659B, # G+7510  U+659B  uni659B,  CJK UNIFIED IDEOGRAPH-659B
        0x89D6, # G+7511  U+89D6  uni89D6,  CJK UNIFIED IDEOGRAPH-89D6
        0x89DE, # G+7512  U+89DE  uni89DE,  CJK UNIFIED IDEOGRAPH-89DE
        0x89DA, # G+7513  U+89DA  uni89DA,  CJK UNIFIED IDEOGRAPH-89DA
        0x89DC, # G+7514  U+89DC  uni89DC,  CJK UNIFIED IDEOGRAPH-89DC
        0x89E5, # G+7515  U+89E5  uni89E5,  CJK UNIFIED IDEOGRAPH-89E5
        0x89EB, # G+7516  U+89EB  uni89EB,  CJK UNIFIED IDEOGRAPH-89EB
        0x89EF, # G+7517  U+89EF  uni89EF,  CJK UNIFIED IDEOGRAPH-89EF
        0x8A3E, # G+7518  U+8A3E  uni8A3E,  CJK UNIFIED IDEOGRAPH-8A3E
        0x8B26, # G+7519  U+8B26  uni8B26,  CJK UNIFIED IDEOGRAPH-8B26
        0x9753, # G+7520  U+9753  uni9753,  CJK UNIFIED IDEOGRAPH-9753
        0x96E9, # G+7521  U+96E9  uni96E9,  CJK UNIFIED IDEOGRAPH-96E9
        0x96F3, # G+7522  U+96F3  uni96F3,  CJK UNIFIED IDEOGRAPH-96F3
        0x96EF, # G+7523  U+96EF  uni96EF,  CJK UNIFIED IDEOGRAPH-96EF
        0x9706, # G+7524  U+9706  uni9706,  CJK UNIFIED IDEOGRAPH-9706
        0x9701, # G+7525  U+9701  uni9701,  CJK UNIFIED IDEOGRAPH-9701
        0x9708, # G+7526  U+9708  uni9708,  CJK UNIFIED IDEOGRAPH-9708
        0x970F, # G+7527  U+970F  uni970F,  CJK UNIFIED IDEOGRAPH-970F
        0x970E, # G+7528  U+970E  uni970E,  CJK UNIFIED IDEOGRAPH-970E
        0x972A, # G+7529  U+972A  uni972A,  CJK UNIFIED IDEOGRAPH-972A
        0x972D, # G+7530  U+972D  uni972D,  CJK UNIFIED IDEOGRAPH-972D
        0x9730, # G+7531  U+9730  uni9730,  CJK UNIFIED IDEOGRAPH-9730
        0x973E, # G+7532  U+973E  uni973E,  CJK UNIFIED IDEOGRAPH-973E
        0x9F80, # G+7533  U+9F80  uni9F80,  CJK UNIFIED IDEOGRAPH-9F80
        0x9F83, # G+7534  U+9F83  uni9F83,  CJK UNIFIED IDEOGRAPH-9F83
        0x9F85, # G+7535  U+9F85  uni9F85,  CJK UNIFIED IDEOGRAPH-9F85
        0x9F86, # G+7536  U+9F86  uni9F86,  CJK UNIFIED IDEOGRAPH-9F86
        0x9F87, # G+7537  U+9F87  uni9F87,  CJK UNIFIED IDEOGRAPH-9F87
        0x9F88, # G+7538  U+9F88  uni9F88,  CJK UNIFIED IDEOGRAPH-9F88
        0x9F89, # G+7539  U+9F89  uni9F89,  CJK UNIFIED IDEOGRAPH-9F89
        0x9F8A, # G+7540  U+9F8A  uni9F8A,  CJK UNIFIED IDEOGRAPH-9F8A
        0x9F8C, # G+7541  U+9F8C  uni9F8C,  CJK UNIFIED IDEOGRAPH-9F8C
        0x9EFE, # G+7542  U+9EFE  uni9EFE,  CJK UNIFIED IDEOGRAPH-9EFE
        0x9F0B, # G+7543  U+9F0B  uni9F0B,  CJK UNIFIED IDEOGRAPH-9F0B
        0x9F0D, # G+7544  U+9F0D  uni9F0D,  CJK UNIFIED IDEOGRAPH-9F0D
        0x2FAB, # G+7545  U+2FAB  uni2FAB,  KANGXI RADICAL SHORT TAILED BIRD
        0x96BC, # G+7546  U+96BC  uni96BC,  CJK UNIFIED IDEOGRAPH-96BC
        0x96BD, # G+7547  U+96BD  uni96BD,  CJK UNIFIED IDEOGRAPH-96BD
        0x96CE, # G+7548  U+96CE  uni96CE,  CJK UNIFIED IDEOGRAPH-96CE
        0x96D2, # G+7549  U+96D2  uni96D2,  CJK UNIFIED IDEOGRAPH-96D2
        0x77BF, # G+7550  U+77BF  uni77BF,  CJK UNIFIED IDEOGRAPH-77BF
        0x96E0, # G+7551  U+96E0  uni96E0,  CJK UNIFIED IDEOGRAPH-96E0
        0x928E, # G+7552  U+928E  uni928E,  CJK UNIFIED IDEOGRAPH-928E
        0x92AE, # G+7553  U+92AE  uni92AE,  CJK UNIFIED IDEOGRAPH-92AE
        0x92C8, # G+7554  U+92C8  uni92C8,  CJK UNIFIED IDEOGRAPH-92C8
        0x933E, # G+7555  U+933E  uni933E,  CJK UNIFIED IDEOGRAPH-933E
        0x936A, # G+7556  U+936A  uni936A,  CJK UNIFIED IDEOGRAPH-936A
        0x93CA, # G+7557  U+93CA  uni93CA,  CJK UNIFIED IDEOGRAPH-93CA
        0x938F, # G+7558  U+938F  uni938F,  CJK UNIFIED IDEOGRAPH-938F
        0x943E, # G+7559  U+943E  uni943E,  CJK UNIFIED IDEOGRAPH-943E
        0x946B, # G+7560  U+946B  uni946B,  CJK UNIFIED IDEOGRAPH-946B
        0x9C7F, # G+7561  U+9C7F  uni9C7F,  CJK UNIFIED IDEOGRAPH-9C7F
        0x9C82, # G+7562  U+9C82  uni9C82,  CJK UNIFIED IDEOGRAPH-9C82
        0x9C85, # G+7563  U+9C85  uni9C85,  CJK UNIFIED IDEOGRAPH-9C85
        0x9C86, # G+7564  U+9C86  uni9C86,  CJK UNIFIED IDEOGRAPH-9C86
        0x9C87, # G+7565  U+9C87  uni9C87,  CJK UNIFIED IDEOGRAPH-9C87
        0x9C88, # G+7566  U+9C88  uni9C88,  CJK UNIFIED IDEOGRAPH-9C88
        0x7A23, # G+7567  U+7A23  uni7A23,  CJK UNIFIED IDEOGRAPH-7A23
        0x9C8B, # G+7568  U+9C8B  uni9C8B,  CJK UNIFIED IDEOGRAPH-9C8B
        0x9C8E, # G+7569  U+9C8E  uni9C8E,  CJK UNIFIED IDEOGRAPH-9C8E
        0x9C90, # G+7570  U+9C90  uni9C90,  CJK UNIFIED IDEOGRAPH-9C90
        0x9C91, # G+7571  U+9C91  uni9C91,  CJK UNIFIED IDEOGRAPH-9C91
        0x9C92, # G+7572  U+9C92  uni9C92,  CJK UNIFIED IDEOGRAPH-9C92
        0x9C94, # G+7573  U+9C94  uni9C94,  CJK UNIFIED IDEOGRAPH-9C94
        0x9C95, # G+7574  U+9C95  uni9C95,  CJK UNIFIED IDEOGRAPH-9C95
        0x9C9A, # G+7575  U+9C9A  uni9C9A,  CJK UNIFIED IDEOGRAPH-9C9A
        0x9C9B, # G+7576  U+9C9B  uni9C9B,  CJK UNIFIED IDEOGRAPH-9C9B
        0x9C9E, # G+7577  U+9C9E  uni9C9E,  CJK UNIFIED IDEOGRAPH-9C9E
        0x9C9F, # G+7578  U+9C9F  uni9C9F,  CJK UNIFIED IDEOGRAPH-9C9F
        0x9CA0, # G+7579  U+9CA0  uni9CA0,  CJK UNIFIED IDEOGRAPH-9CA0
        0x9CA1, # G+7580  U+9CA1  uni9CA1,  CJK UNIFIED IDEOGRAPH-9CA1
        0x9CA2, # G+7581  U+9CA2  uni9CA2,  CJK UNIFIED IDEOGRAPH-9CA2
        0x9CA3, # G+7582  U+9CA3  uni9CA3,  CJK UNIFIED IDEOGRAPH-9CA3
        0x9CA5, # G+7583  U+9CA5  uni9CA5,  CJK UNIFIED IDEOGRAPH-9CA5
        0x9CA6, # G+7584  U+9CA6  uni9CA6,  CJK UNIFIED IDEOGRAPH-9CA6
        0x9CA7, # G+7585  U+9CA7  uni9CA7,  CJK UNIFIED IDEOGRAPH-9CA7
        0x9CA8, # G+7586  U+9CA8  uni9CA8,  CJK UNIFIED IDEOGRAPH-9CA8
        0x9CA9, # G+7587  U+9CA9  uni9CA9,  CJK UNIFIED IDEOGRAPH-9CA9
        0x9CAB, # G+7588  U+9CAB  uni9CAB,  CJK UNIFIED IDEOGRAPH-9CAB
        0x9CAD, # G+7589  U+9CAD  uni9CAD,  CJK UNIFIED IDEOGRAPH-9CAD
        0x9CAE, # G+7590  U+9CAE  uni9CAE,  CJK UNIFIED IDEOGRAPH-9CAE
        0x9CB0, # G+7591  U+9CB0  uni9CB0,  CJK UNIFIED IDEOGRAPH-9CB0
        0x9CB1, # G+7592  U+9CB1  uni9CB1,  CJK UNIFIED IDEOGRAPH-9CB1
        0x9CB2, # G+7593  U+9CB2  uni9CB2,  CJK UNIFIED IDEOGRAPH-9CB2
        0x9CB3, # G+7594  U+9CB3  uni9CB3,  CJK UNIFIED IDEOGRAPH-9CB3
        0x9CB4, # G+7595  U+9CB4  uni9CB4,  CJK UNIFIED IDEOGRAPH-9CB4
        0x9CB5, # G+7596  U+9CB5  uni9CB5,  CJK UNIFIED IDEOGRAPH-9CB5
        0x9CB6, # G+7597  U+9CB6  uni9CB6,  CJK UNIFIED IDEOGRAPH-9CB6
        0x9CB7, # G+7598  U+9CB7  uni9CB7,  CJK UNIFIED IDEOGRAPH-9CB7
        0x9CBA, # G+7599  U+9CBA  uni9CBA,  CJK UNIFIED IDEOGRAPH-9CBA
        0x9CBB, # G+7600  U+9CBB  uni9CBB,  CJK UNIFIED IDEOGRAPH-9CBB
        0x9CBC, # G+7601  U+9CBC  uni9CBC,  CJK UNIFIED IDEOGRAPH-9CBC
        0x9CBD, # G+7602  U+9CBD  uni9CBD,  CJK UNIFIED IDEOGRAPH-9CBD
        0x9CC4, # G+7603  U+9CC4  uni9CC4,  CJK UNIFIED IDEOGRAPH-9CC4
        0x9CC5, # G+7604  U+9CC5  uni9CC5,  CJK UNIFIED IDEOGRAPH-9CC5
        0x9CC6, # G+7605  U+9CC6  uni9CC6,  CJK UNIFIED IDEOGRAPH-9CC6
        0x9CC7, # G+7606  U+9CC7  uni9CC7,  CJK UNIFIED IDEOGRAPH-9CC7
        0x9CCA, # G+7607  U+9CCA  uni9CCA,  CJK UNIFIED IDEOGRAPH-9CCA
        0x9CCB, # G+7608  U+9CCB  uni9CCB,  CJK UNIFIED IDEOGRAPH-9CCB
        0x9CCC, # G+7609  U+9CCC  uni9CCC,  CJK UNIFIED IDEOGRAPH-9CCC
        0x9CCD, # G+7610  U+9CCD  uni9CCD,  CJK UNIFIED IDEOGRAPH-9CCD
        0x9CCE, # G+7611  U+9CCE  uni9CCE,  CJK UNIFIED IDEOGRAPH-9CCE
        0x9CCF, # G+7612  U+9CCF  uni9CCF,  CJK UNIFIED IDEOGRAPH-9CCF
        0x9CD0, # G+7613  U+9CD0  uni9CD0,  CJK UNIFIED IDEOGRAPH-9CD0
        0x9CD3, # G+7614  U+9CD3  uni9CD3,  CJK UNIFIED IDEOGRAPH-9CD3
        0x9CD4, # G+7615  U+9CD4  uni9CD4,  CJK UNIFIED IDEOGRAPH-9CD4
        0x9CD5, # G+7616  U+9CD5  uni9CD5,  CJK UNIFIED IDEOGRAPH-9CD5
        0x9CD7, # G+7617  U+9CD7  uni9CD7,  CJK UNIFIED IDEOGRAPH-9CD7
        0x9CD8, # G+7618  U+9CD8  uni9CD8,  CJK UNIFIED IDEOGRAPH-9CD8
        0x9CD9, # G+7619  U+9CD9  uni9CD9,  CJK UNIFIED IDEOGRAPH-9CD9
        0x9CDC, # G+7620  U+9CDC  uni9CDC,  CJK UNIFIED IDEOGRAPH-9CDC
        0x9CDD, # G+7621  U+9CDD  uni9CDD,  CJK UNIFIED IDEOGRAPH-9CDD
        0x9CDF, # G+7622  U+9CDF  uni9CDF,  CJK UNIFIED IDEOGRAPH-9CDF
        0x9CE2, # G+7623  U+9CE2  uni9CE2,  CJK UNIFIED IDEOGRAPH-9CE2
        0x977C, # G+7624  U+977C  uni977C,  CJK UNIFIED IDEOGRAPH-977C
        0x9785, # G+7625  U+9785  uni9785,  CJK UNIFIED IDEOGRAPH-9785
        0x9791, # G+7626  U+9791  uni9791,  CJK UNIFIED IDEOGRAPH-9791
        0x9792, # G+7627  U+9792  uni9792,  CJK UNIFIED IDEOGRAPH-9792
        0x9794, # G+7628  U+9794  uni9794,  CJK UNIFIED IDEOGRAPH-9794
        0x97AF, # G+7629  U+97AF  uni97AF,  CJK UNIFIED IDEOGRAPH-97AF
        0x97AB, # G+7630  U+97AB  uni97AB,  CJK UNIFIED IDEOGRAPH-97AB
        0x97A3, # G+7631  U+97A3  uni97A3,  CJK UNIFIED IDEOGRAPH-97A3
        0x97B2, # G+7632  U+97B2  uni97B2,  CJK UNIFIED IDEOGRAPH-97B2
        0x97B4, # G+7633  U+97B4  uni97B4,  CJK UNIFIED IDEOGRAPH-97B4
        0x9AB1, # G+7634  U+9AB1  uni9AB1,  CJK UNIFIED IDEOGRAPH-9AB1
        0x9AB0, # G+7635  U+9AB0  uni9AB0,  CJK UNIFIED IDEOGRAPH-9AB0
        0x9AB7, # G+7636  U+9AB7  uni9AB7,  CJK UNIFIED IDEOGRAPH-9AB7
        0x9E58, # G+7637  U+9E58  uni9E58,  CJK UNIFIED IDEOGRAPH-9E58
        0x9AB6, # G+7638  U+9AB6  uni9AB6,  CJK UNIFIED IDEOGRAPH-9AB6
        0x9ABA, # G+7639  U+9ABA  uni9ABA,  CJK UNIFIED IDEOGRAPH-9ABA
        0x9ABC, # G+7640  U+9ABC  uni9ABC,  CJK UNIFIED IDEOGRAPH-9ABC
        0x9AC1, # G+7641  U+9AC1  uni9AC1,  CJK UNIFIED IDEOGRAPH-9AC1
        0x9AC0, # G+7642  U+9AC0  uni9AC0,  CJK UNIFIED IDEOGRAPH-9AC0
        0x9AC5, # G+7643  U+9AC5  uni9AC5,  CJK UNIFIED IDEOGRAPH-9AC5
        0x9AC2, # G+7644  U+9AC2  uni9AC2,  CJK UNIFIED IDEOGRAPH-9AC2
        0x9ACB, # G+7645  U+9ACB  uni9ACB,  CJK UNIFIED IDEOGRAPH-9ACB
        0x9ACC, # G+7646  U+9ACC  uni9ACC,  CJK UNIFIED IDEOGRAPH-9ACC
        0x9AD1, # G+7647  U+9AD1  uni9AD1,  CJK UNIFIED IDEOGRAPH-9AD1
        0x9B45, # G+7648  U+9B45  uni9B45,  CJK UNIFIED IDEOGRAPH-9B45
        0x9B43, # G+7649  U+9B43  uni9B43,  CJK UNIFIED IDEOGRAPH-9B43
        0x9B47, # G+7650  U+9B47  uni9B47,  CJK UNIFIED IDEOGRAPH-9B47
        0x9B49, # G+7651  U+9B49  uni9B49,  CJK UNIFIED IDEOGRAPH-9B49
        0x9B48, # G+7652  U+9B48  uni9B48,  CJK UNIFIED IDEOGRAPH-9B48
        0x9B4D, # G+7653  U+9B4D  uni9B4D,  CJK UNIFIED IDEOGRAPH-9B4D
        0x9B51, # G+7654  U+9B51  uni9B51,  CJK UNIFIED IDEOGRAPH-9B51
        0x98E8, # G+7655  U+98E8  uni98E8,  CJK UNIFIED IDEOGRAPH-98E8
        0x990D, # G+7656  U+990D  uni990D,  CJK UNIFIED IDEOGRAPH-990D
        0x992E, # G+7657  U+992E  uni992E,  CJK UNIFIED IDEOGRAPH-992E
        0x9955, # G+7658  U+9955  uni9955,  CJK UNIFIED IDEOGRAPH-9955
        0x9954, # G+7659  U+9954  uni9954,  CJK UNIFIED IDEOGRAPH-9954
        0x2FBD, # G+7660  U+2FBD  uni2FBD,  KANGXI RADICAL HAIR
        0x9AE1, # G+7661  U+9AE1  uni9AE1,  CJK UNIFIED IDEOGRAPH-9AE1
        0x9AE6, # G+7662  U+9AE6  uni9AE6,  CJK UNIFIED IDEOGRAPH-9AE6
        0x9AEF, # G+7663  U+9AEF  uni9AEF,  CJK UNIFIED IDEOGRAPH-9AEF
        0x9AEB, # G+7664  U+9AEB  uni9AEB,  CJK UNIFIED IDEOGRAPH-9AEB
        0x9AFB, # G+7665  U+9AFB  uni9AFB,  CJK UNIFIED IDEOGRAPH-9AFB
        0x9AED, # G+7666  U+9AED  uni9AED,  CJK UNIFIED IDEOGRAPH-9AED
        0x9AF9, # G+7667  U+9AF9  uni9AF9,  CJK UNIFIED IDEOGRAPH-9AF9
        0x9B08, # G+7668  U+9B08  uni9B08,  CJK UNIFIED IDEOGRAPH-9B08
        0x9B0F, # G+7669  U+9B0F  uni9B0F,  CJK UNIFIED IDEOGRAPH-9B0F
        0x9B13, # G+7670  U+9B13  uni9B13,  CJK UNIFIED IDEOGRAPH-9B13
        0x9B1F, # G+7671  U+9B1F  uni9B1F,  CJK UNIFIED IDEOGRAPH-9B1F
        0x9B23, # G+7672  U+9B23  uni9B23,  CJK UNIFIED IDEOGRAPH-9B23
        0x9EBD, # G+7673  U+9EBD  uni9EBD,  CJK UNIFIED IDEOGRAPH-9EBD
        0x9EBE, # G+7674  U+9EBE  uni9EBE,  CJK UNIFIED IDEOGRAPH-9EBE
        0x7E3B, # G+7675  U+7E3B  uni7E3B,  CJK UNIFIED IDEOGRAPH-7E3B
        0x9E82, # G+7676  U+9E82  uni9E82,  CJK UNIFIED IDEOGRAPH-9E82
        0x9E87, # G+7677  U+9E87  uni9E87,  CJK UNIFIED IDEOGRAPH-9E87
        0x9E88, # G+7678  U+9E88  uni9E88,  CJK UNIFIED IDEOGRAPH-9E88
        0x9E8B, # G+7679  U+9E8B  uni9E8B,  CJK UNIFIED IDEOGRAPH-9E8B
        0x9E92, # G+7680  U+9E92  uni9E92,  CJK UNIFIED IDEOGRAPH-9E92
        0x93D6, # G+7681  U+93D6  uni93D6,  CJK UNIFIED IDEOGRAPH-93D6
        0x9E9D, # G+7682  U+9E9D  uni9E9D,  CJK UNIFIED IDEOGRAPH-9E9D
        0x9E9F, # G+7683  U+9E9F  uni9E9F,  CJK UNIFIED IDEOGRAPH-9E9F
        0x9EDB, # G+7684  U+9EDB  uni9EDB,  CJK UNIFIED IDEOGRAPH-9EDB
        0x9EDC, # G+7685  U+9EDC  uni9EDC,  CJK UNIFIED IDEOGRAPH-9EDC
        0x9EDD, # G+7686  U+9EDD  uni9EDD,  CJK UNIFIED IDEOGRAPH-9EDD
        0x9EE0, # G+7687  U+9EE0  uni9EE0,  CJK UNIFIED IDEOGRAPH-9EE0
        0x9EDF, # G+7688  U+9EDF  uni9EDF,  CJK UNIFIED IDEOGRAPH-9EDF
        0x9EE2, # G+7689  U+9EE2  uni9EE2,  CJK UNIFIED IDEOGRAPH-9EE2
        0x9EE9, # G+7690  U+9EE9  uni9EE9,  CJK UNIFIED IDEOGRAPH-9EE9
        0x9EE7, # G+7691  U+9EE7  uni9EE7,  CJK UNIFIED IDEOGRAPH-9EE7
        0x9EE5, # G+7692  U+9EE5  uni9EE5,  CJK UNIFIED IDEOGRAPH-9EE5
        0x9EEA, # G+7693  U+9EEA  uni9EEA,  CJK UNIFIED IDEOGRAPH-9EEA
        0x9EEF, # G+7694  U+9EEF  uni9EEF,  CJK UNIFIED IDEOGRAPH-9EEF
        0x9F22, # G+7695  U+9F22  uni9F22,  CJK UNIFIED IDEOGRAPH-9F22
        0x9F2C, # G+7696  U+9F2C  uni9F2C,  CJK UNIFIED IDEOGRAPH-9F2C
        0x9F2F, # G+7697  U+9F2F  uni9F2F,  CJK UNIFIED IDEOGRAPH-9F2F
        0x9F39, # G+7698  U+9F39  uni9F39,  CJK UNIFIED IDEOGRAPH-9F39
        0x9F37, # G+7699  U+9F37  uni9F37,  CJK UNIFIED IDEOGRAPH-9F37
        0x9F3D, # G+7700  U+9F3D  uni9F3D,  CJK UNIFIED IDEOGRAPH-9F3D
        0x9F3E, # G+7701  U+9F3E  uni9F3E,  CJK UNIFIED IDEOGRAPH-9F3E
        0x9F44, # G+7702  U+9F44  uni9F44,  CJK UNIFIED IDEOGRAPH-9F44
        0x3007, # G+7703  U+3007  uni3007,  IDEOGRAPHIC NUMBER ZERO
        0xFF5E, # G+7704  U+FF5E  uniFF5E,  FULLWIDTH TILDE
        0x0000, # G+7705  U+0000  .notdef,  UNDEFINED
        0x3013, # G+7706  U+3013  uni3013,  GETA MARK
        0xFF0E, # G+7707  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0x2225, # G+7708  U+2225  uni2225,  PARALLEL TO
        0xFF3B, # G+7709  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3D, # G+7710  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFFE3, # G+7711  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0x0000, # G+7712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7716  U+0000  .notdef,  UNDEFINED
        0x769A, # G+7717  U+769A  uni769A,  CJK UNIFIED IDEOGRAPH-769A
        0x85F9, # G+7718  U+85F9  uni85F9,  CJK UNIFIED IDEOGRAPH-85F9
        0x7919, # G+7719  U+7919  uni7919,  CJK UNIFIED IDEOGRAPH-7919
        0x611B, # G+7720  U+611B  uni611B,  CJK UNIFIED IDEOGRAPH-611B
        0x9AAF, # G+7721  U+9AAF  uni9AAF,  CJK UNIFIED IDEOGRAPH-9AAF
        0x8956, # G+7722  U+8956  uni8956,  CJK UNIFIED IDEOGRAPH-8956
        0x58E9, # G+7723  U+58E9  uni58E9,  CJK UNIFIED IDEOGRAPH-58E9
        0x7F77, # G+7724  U+7F77  uni7F77,  CJK UNIFIED IDEOGRAPH-7F77
        0x64FA, # G+7725  U+64FA  uni64FA,  CJK UNIFIED IDEOGRAPH-64FA
        0x6557, # G+7726  U+6557  uni6557,  CJK UNIFIED IDEOGRAPH-6557
        0x9812, # G+7727  U+9812  uni9812,  CJK UNIFIED IDEOGRAPH-9812
        0x8FA6, # G+7728  U+8FA6  uni8FA6,  CJK UNIFIED IDEOGRAPH-8FA6
        0x7D46, # G+7729  U+7D46  uni7D46,  CJK UNIFIED IDEOGRAPH-7D46
        0x5E6B, # G+7730  U+5E6B  uni5E6B,  CJK UNIFIED IDEOGRAPH-5E6B
        0x7D81, # G+7731  U+7D81  uni7D81,  CJK UNIFIED IDEOGRAPH-7D81
        0x938A, # G+7732  U+938A  uni938A,  CJK UNIFIED IDEOGRAPH-938A
        0x8B17, # G+7733  U+8B17  uni8B17,  CJK UNIFIED IDEOGRAPH-8B17
        0x98FD, # G+7734  U+98FD  uni98FD,  CJK UNIFIED IDEOGRAPH-98FD
        0x5BF6, # G+7735  U+5BF6  uni5BF6,  CJK UNIFIED IDEOGRAPH-5BF6
        0x5831, # G+7736  U+5831  uni5831,  CJK UNIFIED IDEOGRAPH-5831
        0x9B91, # G+7737  U+9B91  uni9B91,  CJK UNIFIED IDEOGRAPH-9B91
        0x8F29, # G+7738  U+8F29  uni8F29,  CJK UNIFIED IDEOGRAPH-8F29
        0x2F99, # G+7739  U+2F99  uni2F99,  KANGXI RADICAL SHELL
        0x92C7, # G+7740  U+92C7  uni92C7,  CJK UNIFIED IDEOGRAPH-92C7
        0x72FD, # G+7741  U+72FD  uni72FD,  CJK UNIFIED IDEOGRAPH-72FD
        0x5099, # G+7742  U+5099  uni5099,  CJK UNIFIED IDEOGRAPH-5099
        0x618A, # G+7743  U+618A  uni618A,  CJK UNIFIED IDEOGRAPH-618A
        0x7DB3, # G+7744  U+7DB3  uni7DB3,  CJK UNIFIED IDEOGRAPH-7DB3
        0x7B46, # G+7745  U+7B46  uni7B46,  CJK UNIFIED IDEOGRAPH-7B46
        0x7562, # G+7746  U+7562  uni7562,  CJK UNIFIED IDEOGRAPH-7562
        0x6583, # G+7747  U+6583  uni6583,  CJK UNIFIED IDEOGRAPH-6583
        0x5E63, # G+7748  U+5E63  uni5E63,  CJK UNIFIED IDEOGRAPH-5E63
        0x9589, # G+7749  U+9589  uni9589,  CJK UNIFIED IDEOGRAPH-9589
        0x908A, # G+7750  U+908A  uni908A,  CJK UNIFIED IDEOGRAPH-908A
        0x7DE8, # G+7751  U+7DE8  uni7DE8,  CJK UNIFIED IDEOGRAPH-7DE8
        0x8CB6, # G+7752  U+8CB6  uni8CB6,  CJK UNIFIED IDEOGRAPH-8CB6
        0x8B8A, # G+7753  U+8B8A  uni8B8A,  CJK UNIFIED IDEOGRAPH-8B8A
        0x8FAF, # G+7754  U+8FAF  uni8FAF,  CJK UNIFIED IDEOGRAPH-8FAF
        0x8FAE, # G+7755  U+8FAE  uni8FAE,  CJK UNIFIED IDEOGRAPH-8FAE
        0x6A19, # G+7756  U+6A19  uni6A19,  CJK UNIFIED IDEOGRAPH-6A19
        0x9C49, # G+7757  U+9C49  uni9C49,  CJK UNIFIED IDEOGRAPH-9C49
        0x765F, # G+7758  U+765F  uni765F,  CJK UNIFIED IDEOGRAPH-765F
        0x7015, # G+7759  U+7015  uni7015,  CJK UNIFIED IDEOGRAPH-7015
        0x6FF1, # G+7760  U+6FF1  uni6FF1,  CJK UNIFIED IDEOGRAPH-6FF1
        0x8CD3, # G+7761  U+8CD3  uni8CD3,  CJK UNIFIED IDEOGRAPH-8CD3
        0x64EF, # G+7762  U+64EF  uni64EF,  CJK UNIFIED IDEOGRAPH-64EF
        0x9905, # G+7763  U+9905  uni9905,  CJK UNIFIED IDEOGRAPH-9905
        0x64A5, # G+7764  U+64A5  uni64A5,  CJK UNIFIED IDEOGRAPH-64A5
        0x9262, # G+7765  U+9262  uni9262,  CJK UNIFIED IDEOGRAPH-9262
        0x9251, # G+7766  U+9251  uni9251,  CJK UNIFIED IDEOGRAPH-9251
        0x99C1, # G+7767  U+99C1  uni99C1,  CJK UNIFIED IDEOGRAPH-99C1
        0x88DC, # G+7768  U+88DC  uni88DC,  CJK UNIFIED IDEOGRAPH-88DC
        0x8CA1, # G+7769  U+8CA1  uni8CA1,  CJK UNIFIED IDEOGRAPH-8CA1
        0x53C3, # G+7770  U+53C3  uni53C3,  CJK UNIFIED IDEOGRAPH-53C3
        0x8836, # G+7771  U+8836  uni8836,  CJK UNIFIED IDEOGRAPH-8836
        0x6B98, # G+7772  U+6B98  uni6B98,  CJK UNIFIED IDEOGRAPH-6B98
        0x615A, # G+7773  U+615A  uni615A,  CJK UNIFIED IDEOGRAPH-615A
        0x6158, # G+7774  U+6158  uni6158,  CJK UNIFIED IDEOGRAPH-6158
        0x71E6, # G+7775  U+71E6  uni71E6,  CJK UNIFIED IDEOGRAPH-71E6
        0x84BC, # G+7776  U+84BC  uni84BC,  CJK UNIFIED IDEOGRAPH-84BC
        0x8259, # G+7777  U+8259  uni8259,  CJK UNIFIED IDEOGRAPH-8259
        0x5009, # G+7778  U+5009  uni5009,  CJK UNIFIED IDEOGRAPH-5009
        0x6EC4, # G+7779  U+6EC4  uni6EC4,  CJK UNIFIED IDEOGRAPH-6EC4
        0x53A0, # G+7780  U+53A0  uni53A0,  CJK UNIFIED IDEOGRAPH-53A0
        0x5074, # G+7781  U+5074  uni5074,  CJK UNIFIED IDEOGRAPH-5074
        0x6E2C, # G+7782  U+6E2C  uni6E2C,  CJK UNIFIED IDEOGRAPH-6E2C
        0x5C64, # G+7783  U+5C64  uni5C64,  CJK UNIFIED IDEOGRAPH-5C64
        0x8A6B, # G+7784  U+8A6B  uni8A6B,  CJK UNIFIED IDEOGRAPH-8A6B
        0x6519, # G+7785  U+6519  uni6519,  CJK UNIFIED IDEOGRAPH-6519
        0x647B, # G+7786  U+647B  uni647B,  CJK UNIFIED IDEOGRAPH-647B
        0x87EC, # G+7787  U+87EC  uni87EC,  CJK UNIFIED IDEOGRAPH-87EC
        0x995E, # G+7788  U+995E  uni995E,  CJK UNIFIED IDEOGRAPH-995E
        0x8B92, # G+7789  U+8B92  uni8B92,  CJK UNIFIED IDEOGRAPH-8B92
        0x7E8F, # G+7790  U+7E8F  uni7E8F,  CJK UNIFIED IDEOGRAPH-7E8F
        0x93DF, # G+7791  U+93DF  uni93DF,  CJK UNIFIED IDEOGRAPH-93DF
        0x7523, # G+7792  U+7523  uni7523,  CJK UNIFIED IDEOGRAPH-7523
        0x95E1, # G+7793  U+95E1  uni95E1,  CJK UNIFIED IDEOGRAPH-95E1
        0x986B, # G+7794  U+986B  uni986B,  CJK UNIFIED IDEOGRAPH-986B
        0x5834, # G+7795  U+5834  uni5834,  CJK UNIFIED IDEOGRAPH-5834
        0x5617, # G+7796  U+5617  uni5617,  CJK UNIFIED IDEOGRAPH-5617
        0x2FA7, # G+7797  U+2FA7  uni2FA7,  KANGXI RADICAL LONG
        0x511F, # G+7798  U+511F  uni511F,  CJK UNIFIED IDEOGRAPH-511F
        0x8178, # G+7799  U+8178  uni8178,  CJK UNIFIED IDEOGRAPH-8178
        0x5EE0, # G+7800  U+5EE0  uni5EE0,  CJK UNIFIED IDEOGRAPH-5EE0
        0x66A2, # G+7801  U+66A2  uni66A2,  CJK UNIFIED IDEOGRAPH-66A2
        0x9214, # G+7802  U+9214  uni9214,  CJK UNIFIED IDEOGRAPH-9214
        0x2F9E, # G+7803  U+2F9E  uni2F9E,  KANGXI RADICAL CART
        0x5FB9, # G+7804  U+5FB9  uni5FB9,  CJK UNIFIED IDEOGRAPH-5FB9
        0x5875, # G+7805  U+5875  uni5875,  CJK UNIFIED IDEOGRAPH-5875
        0x9673, # G+7806  U+9673  uni9673,  CJK UNIFIED IDEOGRAPH-9673
        0x896F, # G+7807  U+896F  uni896F,  CJK UNIFIED IDEOGRAPH-896F
        0x7A31, # G+7808  U+7A31  uni7A31,  CJK UNIFIED IDEOGRAPH-7A31
        0x61F2, # G+7809  U+61F2  uni61F2,  CJK UNIFIED IDEOGRAPH-61F2
        0x8AA0, # G+7810  U+8AA0  uni8AA0,  CJK UNIFIED IDEOGRAPH-8AA0
        0x9A01, # G+7811  U+9A01  uni9A01,  CJK UNIFIED IDEOGRAPH-9A01
        0x9072, # G+7812  U+9072  uni9072,  CJK UNIFIED IDEOGRAPH-9072
        0x99B3, # G+7813  U+99B3  uni99B3,  CJK UNIFIED IDEOGRAPH-99B3
        0x2FD2, # G+7814  U+2FD2  uni2FD2,  KANGXI RADICAL TOOTH
        0x71BE, # G+7815  U+71BE  uni71BE,  CJK UNIFIED IDEOGRAPH-71BE
        0x885D, # G+7816  U+885D  uni885D,  CJK UNIFIED IDEOGRAPH-885D
        0x87F2, # G+7817  U+87F2  uni87F2,  CJK UNIFIED IDEOGRAPH-87F2
        0x5BF5, # G+7818  U+5BF5  uni5BF5,  CJK UNIFIED IDEOGRAPH-5BF5
        0x7587, # G+7819  U+7587  uni7587,  CJK UNIFIED IDEOGRAPH-7587
        0x8E8A, # G+7820  U+8E8A  uni8E8A,  CJK UNIFIED IDEOGRAPH-8E8A
        0x7C4C, # G+7821  U+7C4C  uni7C4C,  CJK UNIFIED IDEOGRAPH-7C4C
        0x7DA2, # G+7822  U+7DA2  uni7DA2,  CJK UNIFIED IDEOGRAPH-7DA2
        0x919C, # G+7823  U+919C  uni919C,  CJK UNIFIED IDEOGRAPH-919C
        0x92E4, # G+7824  U+92E4  uni92E4,  CJK UNIFIED IDEOGRAPH-92E4
        0x96DB, # G+7825  U+96DB  uni96DB,  CJK UNIFIED IDEOGRAPH-96DB
        0x790E, # G+7826  U+790E  uni790E,  CJK UNIFIED IDEOGRAPH-790E
        0x5132, # G+7827  U+5132  uni5132,  CJK UNIFIED IDEOGRAPH-5132
        0x89F8, # G+7828  U+89F8  uni89F8,  CJK UNIFIED IDEOGRAPH-89F8
        0x8655, # G+7829  U+8655  uni8655,  CJK UNIFIED IDEOGRAPH-8655
        0x50B3, # G+7830  U+50B3  uni50B3,  CJK UNIFIED IDEOGRAPH-50B3
        0x7621, # G+7831  U+7621  uni7621,  CJK UNIFIED IDEOGRAPH-7621
        0x95D6, # G+7832  U+95D6  uni95D6,  CJK UNIFIED IDEOGRAPH-95D6
        0x5275, # G+7833  U+5275  uni5275,  CJK UNIFIED IDEOGRAPH-5275
        0x9318, # G+7834  U+9318  uni9318,  CJK UNIFIED IDEOGRAPH-9318
        0x7D14, # G+7835  U+7D14  uni7D14,  CJK UNIFIED IDEOGRAPH-7D14
        0x7DBD, # G+7836  U+7DBD  uni7DBD,  CJK UNIFIED IDEOGRAPH-7DBD
        0x8FAD, # G+7837  U+8FAD  uni8FAD,  CJK UNIFIED IDEOGRAPH-8FAD
        0x8A5E, # G+7838  U+8A5E  uni8A5E,  CJK UNIFIED IDEOGRAPH-8A5E
        0x8CDC, # G+7839  U+8CDC  uni8CDC,  CJK UNIFIED IDEOGRAPH-8CDC
        0x8070, # G+7840  U+8070  uni8070,  CJK UNIFIED IDEOGRAPH-8070
        0x5F9E, # G+7841  U+5F9E  uni5F9E,  CJK UNIFIED IDEOGRAPH-5F9E
        0x53E2, # G+7842  U+53E2  uni53E2,  CJK UNIFIED IDEOGRAPH-53E2
        0x8EA5, # G+7843  U+8EA5  uni8EA5,  CJK UNIFIED IDEOGRAPH-8EA5
        0x7AC4, # G+7844  U+7AC4  uni7AC4,  CJK UNIFIED IDEOGRAPH-7AC4
        0x932F, # G+7845  U+932F  uni932F,  CJK UNIFIED IDEOGRAPH-932F
        0x9054, # G+7846  U+9054  uni9054,  CJK UNIFIED IDEOGRAPH-9054
        0x5E36, # G+7847  U+5E36  uni5E36,  CJK UNIFIED IDEOGRAPH-5E36
        0x8CB8, # G+7848  U+8CB8  uni8CB8,  CJK UNIFIED IDEOGRAPH-8CB8
        0x64D4, # G+7849  U+64D4  uni64D4,  CJK UNIFIED IDEOGRAPH-64D4
        0x55AE, # G+7850  U+55AE  uni55AE,  CJK UNIFIED IDEOGRAPH-55AE
        0x9132, # G+7851  U+9132  uni9132,  CJK UNIFIED IDEOGRAPH-9132
        0x64A3, # G+7852  U+64A3  uni64A3,  CJK UNIFIED IDEOGRAPH-64A3
        0x81BD, # G+7853  U+81BD  uni81BD,  CJK UNIFIED IDEOGRAPH-81BD
        0x619A, # G+7854  U+619A  uni619A,  CJK UNIFIED IDEOGRAPH-619A
        0x8A95, # G+7855  U+8A95  uni8A95,  CJK UNIFIED IDEOGRAPH-8A95
        0x5F48, # G+7856  U+5F48  uni5F48,  CJK UNIFIED IDEOGRAPH-5F48
        0x7576, # G+7857  U+7576  uni7576,  CJK UNIFIED IDEOGRAPH-7576
        0x64CB, # G+7858  U+64CB  uni64CB,  CJK UNIFIED IDEOGRAPH-64CB
        0x9EE8, # G+7859  U+9EE8  uni9EE8,  CJK UNIFIED IDEOGRAPH-9EE8
        0x8569, # G+7860  U+8569  uni8569,  CJK UNIFIED IDEOGRAPH-8569
        0x6A94, # G+7861  U+6A94  uni6A94,  CJK UNIFIED IDEOGRAPH-6A94
        0x6417, # G+7862  U+6417  uni6417,  CJK UNIFIED IDEOGRAPH-6417
        0x5CF6, # G+7863  U+5CF6  uni5CF6,  CJK UNIFIED IDEOGRAPH-5CF6
        0x79B1, # G+7864  U+79B1  uni79B1,  CJK UNIFIED IDEOGRAPH-79B1
        0x5C0E, # G+7865  U+5C0E  uni5C0E,  CJK UNIFIED IDEOGRAPH-5C0E
        0x71C8, # G+7866  U+71C8  uni71C8,  CJK UNIFIED IDEOGRAPH-71C8
        0x9127, # G+7867  U+9127  uni9127,  CJK UNIFIED IDEOGRAPH-9127
        0x6575, # G+7868  U+6575  uni6575,  CJK UNIFIED IDEOGRAPH-6575
        0x6ECC, # G+7869  U+6ECC  uni6ECC,  CJK UNIFIED IDEOGRAPH-6ECC
        0x905E, # G+7870  U+905E  uni905E,  CJK UNIFIED IDEOGRAPH-905E
        0x7DE0, # G+7871  U+7DE0  uni7DE0,  CJK UNIFIED IDEOGRAPH-7DE0
        0x985B, # G+7872  U+985B  uni985B,  CJK UNIFIED IDEOGRAPH-985B
        0x9EDE, # G+7873  U+9EDE  uni9EDE,  CJK UNIFIED IDEOGRAPH-9EDE
        0x588A, # G+7874  U+588A  uni588A,  CJK UNIFIED IDEOGRAPH-588A
        0x96FB, # G+7875  U+96FB  uni96FB,  CJK UNIFIED IDEOGRAPH-96FB
        0x6FB1, # G+7876  U+6FB1  uni6FB1,  CJK UNIFIED IDEOGRAPH-6FB1
        0x91E3, # G+7877  U+91E3  uni91E3,  CJK UNIFIED IDEOGRAPH-91E3
        0x8ABF, # G+7878  U+8ABF  uni8ABF,  CJK UNIFIED IDEOGRAPH-8ABF
        0x8ADC, # G+7879  U+8ADC  uni8ADC,  CJK UNIFIED IDEOGRAPH-8ADC
        0x91D8, # G+7880  U+91D8  uni91D8,  CJK UNIFIED IDEOGRAPH-91D8
        0x9802, # G+7881  U+9802  uni9802,  CJK UNIFIED IDEOGRAPH-9802
        0x9320, # G+7882  U+9320  uni9320,  CJK UNIFIED IDEOGRAPH-9320
        0x8A02, # G+7883  U+8A02  uni8A02,  CJK UNIFIED IDEOGRAPH-8A02
        0x6771, # G+7884  U+6771  uni6771,  CJK UNIFIED IDEOGRAPH-6771
        0x52D5, # G+7885  U+52D5  uni52D5,  CJK UNIFIED IDEOGRAPH-52D5
        0x68DF, # G+7886  U+68DF  uni68DF,  CJK UNIFIED IDEOGRAPH-68DF
        0x51CD, # G+7887  U+51CD  uni51CD,  CJK UNIFIED IDEOGRAPH-51CD
        0x2FBE, # G+7888  U+2FBE  uni2FBE,  KANGXI RADICAL FIGHT
        0x72A2, # G+7889  U+72A2  uni72A2,  CJK UNIFIED IDEOGRAPH-72A2
        0x7368, # G+7890  U+7368  uni7368,  CJK UNIFIED IDEOGRAPH-7368
        0x8B80, # G+7891  U+8B80  uni8B80,  CJK UNIFIED IDEOGRAPH-8B80
        0x8CED, # G+7892  U+8CED  uni8CED,  CJK UNIFIED IDEOGRAPH-8CED
        0x934D, # G+7893  U+934D  uni934D,  CJK UNIFIED IDEOGRAPH-934D
        0x935B, # G+7894  U+935B  uni935B,  CJK UNIFIED IDEOGRAPH-935B
        0x65B7, # G+7895  U+65B7  uni65B7,  CJK UNIFIED IDEOGRAPH-65B7
        0x7DDE, # G+7896  U+7DDE  uni7DDE,  CJK UNIFIED IDEOGRAPH-7DDE
        0x968A, # G+7897  U+968A  uni968A,  CJK UNIFIED IDEOGRAPH-968A
        0x5C0D, # G+7898  U+5C0D  uni5C0D,  CJK UNIFIED IDEOGRAPH-5C0D
        0x5678, # G+7899  U+5678  uni5678,  CJK UNIFIED IDEOGRAPH-5678
        0x9813, # G+7900  U+9813  uni9813,  CJK UNIFIED IDEOGRAPH-9813
        0x920D, # G+7901  U+920D  uni920D,  CJK UNIFIED IDEOGRAPH-920D
        0x596A, # G+7902  U+596A  uni596A,  CJK UNIFIED IDEOGRAPH-596A
        0x58AE, # G+7903  U+58AE  uni58AE,  CJK UNIFIED IDEOGRAPH-58AE
        0x9D5D, # G+7904  U+9D5D  uni9D5D,  CJK UNIFIED IDEOGRAPH-9D5D
        0x984D, # G+7905  U+984D  uni984D,  CJK UNIFIED IDEOGRAPH-984D
        0x8A1B, # G+7906  U+8A1B  uni8A1B,  CJK UNIFIED IDEOGRAPH-8A1B
        0x60E1, # G+7907  U+60E1  uni60E1,  CJK UNIFIED IDEOGRAPH-60E1
        0x9913, # G+7908  U+9913  uni9913,  CJK UNIFIED IDEOGRAPH-9913
        0x5152, # G+7909  U+5152  uni5152,  CJK UNIFIED IDEOGRAPH-5152
        0x723E, # G+7910  U+723E  uni723E,  CJK UNIFIED IDEOGRAPH-723E
        0x990C, # G+7911  U+990C  uni990C,  CJK UNIFIED IDEOGRAPH-990C
        0x8CB3, # G+7912  U+8CB3  uni8CB3,  CJK UNIFIED IDEOGRAPH-8CB3
        0x767C, # G+7913  U+767C  uni767C,  CJK UNIFIED IDEOGRAPH-767C
        0x7F70, # G+7914  U+7F70  uni7F70,  CJK UNIFIED IDEOGRAPH-7F70
        0x95A5, # G+7915  U+95A5  uni95A5,  CJK UNIFIED IDEOGRAPH-95A5
        0x792C, # G+7916  U+792C  uni792C,  CJK UNIFIED IDEOGRAPH-792C
        0x91E9, # G+7917  U+91E9  uni91E9,  CJK UNIFIED IDEOGRAPH-91E9
        0x7169, # G+7918  U+7169  uni7169,  CJK UNIFIED IDEOGRAPH-7169
        0x7BC4, # G+7919  U+7BC4  uni7BC4,  CJK UNIFIED IDEOGRAPH-7BC4
        0x8CA9, # G+7920  U+8CA9  uni8CA9,  CJK UNIFIED IDEOGRAPH-8CA9
        0x98EF, # G+7921  U+98EF  uni98EF,  CJK UNIFIED IDEOGRAPH-98EF
        0x8A2A, # G+7922  U+8A2A  uni8A2A,  CJK UNIFIED IDEOGRAPH-8A2A
        0x7D21, # G+7923  U+7D21  uni7D21,  CJK UNIFIED IDEOGRAPH-7D21
        0x2FB6, # G+7924  U+2FB6  uni2FB6,  KANGXI RADICAL FLY
        0x8AB9, # G+7925  U+8AB9  uni8AB9,  CJK UNIFIED IDEOGRAPH-8AB9
        0x5EE2, # G+7926  U+5EE2  uni5EE2,  CJK UNIFIED IDEOGRAPH-5EE2
        0x8CBB, # G+7927  U+8CBB  uni8CBB,  CJK UNIFIED IDEOGRAPH-8CBB
        0x7D1B, # G+7928  U+7D1B  uni7D1B,  CJK UNIFIED IDEOGRAPH-7D1B
        0x58B3, # G+7929  U+58B3  uni58B3,  CJK UNIFIED IDEOGRAPH-58B3
        0x596E, # G+7930  U+596E  uni596E,  CJK UNIFIED IDEOGRAPH-596E
        0x61A4, # G+7931  U+61A4  uni61A4,  CJK UNIFIED IDEOGRAPH-61A4
        0x7CDE, # G+7932  U+7CDE  uni7CDE,  CJK UNIFIED IDEOGRAPH-7CDE
        0x8C50, # G+7933  U+8C50  uni8C50,  CJK UNIFIED IDEOGRAPH-8C50
        0x6953, # G+7934  U+6953  uni6953,  CJK UNIFIED IDEOGRAPH-6953
        0x92D2, # G+7935  U+92D2  uni92D2,  CJK UNIFIED IDEOGRAPH-92D2
        0x2FB5, # G+7936  U+2FB5  uni2FB5,  KANGXI RADICAL WIND
        0x760B, # G+7937  U+760B  uni760B,  CJK UNIFIED IDEOGRAPH-760B
        0x99AE, # G+7938  U+99AE  uni99AE,  CJK UNIFIED IDEOGRAPH-99AE
        0x7E2B, # G+7939  U+7E2B  uni7E2B,  CJK UNIFIED IDEOGRAPH-7E2B
        0x8AF7, # G+7940  U+8AF7  uni8AF7,  CJK UNIFIED IDEOGRAPH-8AF7
        0x9CF3, # G+7941  U+9CF3  uni9CF3,  CJK UNIFIED IDEOGRAPH-9CF3
        0x819A, # G+7942  U+819A  uni819A,  CJK UNIFIED IDEOGRAPH-819A
        0x8F3B, # G+7943  U+8F3B  uni8F3B,  CJK UNIFIED IDEOGRAPH-8F3B
        0x64AB, # G+7944  U+64AB  uni64AB,  CJK UNIFIED IDEOGRAPH-64AB
        0x8F14, # G+7945  U+8F14  uni8F14,  CJK UNIFIED IDEOGRAPH-8F14
        0x8CE6, # G+7946  U+8CE6  uni8CE6,  CJK UNIFIED IDEOGRAPH-8CE6
        0x5FA9, # G+7947  U+5FA9  uni5FA9,  CJK UNIFIED IDEOGRAPH-5FA9
        0x8CA0, # G+7948  U+8CA0  uni8CA0,  CJK UNIFIED IDEOGRAPH-8CA0
        0x8A03, # G+7949  U+8A03  uni8A03,  CJK UNIFIED IDEOGRAPH-8A03
        0x5A66, # G+7950  U+5A66  uni5A66,  CJK UNIFIED IDEOGRAPH-5A66
        0x7E1B, # G+7951  U+7E1B  uni7E1B,  CJK UNIFIED IDEOGRAPH-7E1B
        0x8A72, # G+7952  U+8A72  uni8A72,  CJK UNIFIED IDEOGRAPH-8A72
        0x9223, # G+7953  U+9223  uni9223,  CJK UNIFIED IDEOGRAPH-9223
        0x84CB, # G+7954  U+84CB  uni84CB,  CJK UNIFIED IDEOGRAPH-84CB
        0x5E79, # G+7955  U+5E79  uni5E79,  CJK UNIFIED IDEOGRAPH-5E79
        0x8D95, # G+7956  U+8D95  uni8D95,  CJK UNIFIED IDEOGRAPH-8D95
        0x8D1B, # G+7957  U+8D1B  uni8D1B,  CJK UNIFIED IDEOGRAPH-8D1B
        0x5CA1, # G+7958  U+5CA1  uni5CA1,  CJK UNIFIED IDEOGRAPH-5CA1
        0x525B, # G+7959  U+525B  uni525B,  CJK UNIFIED IDEOGRAPH-525B
        0x92FC, # G+7960  U+92FC  uni92FC,  CJK UNIFIED IDEOGRAPH-92FC
        0x7DB1, # G+7961  U+7DB1  uni7DB1,  CJK UNIFIED IDEOGRAPH-7DB1
        0x5D17, # G+7962  U+5D17  uni5D17,  CJK UNIFIED IDEOGRAPH-5D17
        0x93AC, # G+7963  U+93AC  uni93AC,  CJK UNIFIED IDEOGRAPH-93AC
        0x64F1, # G+7964  U+64F1  uni64F1,  CJK UNIFIED IDEOGRAPH-64F1
        0x9D3F, # G+7965  U+9D3F  uni9D3F,  CJK UNIFIED IDEOGRAPH-9D3F
        0x95A3, # G+7966  U+95A3  uni95A3,  CJK UNIFIED IDEOGRAPH-95A3
        0x927B, # G+7967  U+927B  uni927B,  CJK UNIFIED IDEOGRAPH-927B
        0x500B, # G+7968  U+500B  uni500B,  CJK UNIFIED IDEOGRAPH-500B
        0x7D66, # G+7969  U+7D66  uni7D66,  CJK UNIFIED IDEOGRAPH-7D66
        0x9F94, # G+7970  U+9F94  uni9F94,  CJK UNIFIED IDEOGRAPH-9F94
        0x978F, # G+7971  U+978F  uni978F,  CJK UNIFIED IDEOGRAPH-978F
        0x8CA2, # G+7972  U+8CA2  uni8CA2,  CJK UNIFIED IDEOGRAPH-8CA2
        0x920E, # G+7973  U+920E  uni920E,  CJK UNIFIED IDEOGRAPH-920E
        0x6E9D, # G+7974  U+6E9D  uni6E9D,  CJK UNIFIED IDEOGRAPH-6E9D
        0x69CB, # G+7975  U+69CB  uni69CB,  CJK UNIFIED IDEOGRAPH-69CB
        0x8CFC, # G+7976  U+8CFC  uni8CFC,  CJK UNIFIED IDEOGRAPH-8CFC
        0x8831, # G+7977  U+8831  uni8831,  CJK UNIFIED IDEOGRAPH-8831
        0x9867, # G+7978  U+9867  uni9867,  CJK UNIFIED IDEOGRAPH-9867
        0x526E, # G+7979  U+526E  uni526E,  CJK UNIFIED IDEOGRAPH-526E
        0x95DC, # G+7980  U+95DC  uni95DC,  CJK UNIFIED IDEOGRAPH-95DC
        0x89C0, # G+7981  U+89C0  uni89C0,  CJK UNIFIED IDEOGRAPH-89C0
        0x9928, # G+7982  U+9928  uni9928,  CJK UNIFIED IDEOGRAPH-9928
        0x6163, # G+7983  U+6163  uni6163,  CJK UNIFIED IDEOGRAPH-6163
        0x8CAB, # G+7984  U+8CAB  uni8CAB,  CJK UNIFIED IDEOGRAPH-8CAB
        0x5EE3, # G+7985  U+5EE3  uni5EE3,  CJK UNIFIED IDEOGRAPH-5EE3
        0x898F, # G+7986  U+898F  uni898F,  CJK UNIFIED IDEOGRAPH-898F
        0x6B78, # G+7987  U+6B78  uni6B78,  CJK UNIFIED IDEOGRAPH-6B78
        0x2FD4, # G+7988  U+2FD4  uni2FD4,  KANGXI RADICAL TURTLE
        0x95A8, # G+7989  U+95A8  uni95A8,  CJK UNIFIED IDEOGRAPH-95A8
        0x8ECC, # G+7990  U+8ECC  uni8ECC,  CJK UNIFIED IDEOGRAPH-8ECC
        0x8A6D, # G+7991  U+8A6D  uni8A6D,  CJK UNIFIED IDEOGRAPH-8A6D
        0x6AC3, # G+7992  U+6AC3  uni6AC3,  CJK UNIFIED IDEOGRAPH-6AC3
        0x8CB4, # G+7993  U+8CB4  uni8CB4,  CJK UNIFIED IDEOGRAPH-8CB4
        0x528A, # G+7994  U+528A  uni528A,  CJK UNIFIED IDEOGRAPH-528A
        0x8F25, # G+7995  U+8F25  uni8F25,  CJK UNIFIED IDEOGRAPH-8F25
        0x934B, # G+7996  U+934B  uni934B,  CJK UNIFIED IDEOGRAPH-934B
        0x570B, # G+7997  U+570B  uni570B,  CJK UNIFIED IDEOGRAPH-570B
        0x904E, # G+7998  U+904E  uni904E,  CJK UNIFIED IDEOGRAPH-904E
        0x99ED, # G+7999  U+99ED  uni99ED,  CJK UNIFIED IDEOGRAPH-99ED
        0x97D3, # G+8000  U+97D3  uni97D3,  CJK UNIFIED IDEOGRAPH-97D3
        0x6F22, # G+8001  U+6F22  uni6F22,  CJK UNIFIED IDEOGRAPH-6F22
        0x865F, # G+8002  U+865F  uni865F,  CJK UNIFIED IDEOGRAPH-865F
        0x95A1, # G+8003  U+95A1  uni95A1,  CJK UNIFIED IDEOGRAPH-95A1
        0x9DB4, # G+8004  U+9DB4  uni9DB4,  CJK UNIFIED IDEOGRAPH-9DB4
        0x8CC0, # G+8005  U+8CC0  uni8CC0,  CJK UNIFIED IDEOGRAPH-8CC0
        0x8F5F, # G+8006  U+8F5F  uni8F5F,  CJK UNIFIED IDEOGRAPH-8F5F
        0x9D3B, # G+8007  U+9D3B  uni9D3B,  CJK UNIFIED IDEOGRAPH-9D3B
        0x7D05, # G+8008  U+7D05  uni7D05,  CJK UNIFIED IDEOGRAPH-7D05
        0x58FA, # G+8009  U+58FA  uni58FA,  CJK UNIFIED IDEOGRAPH-58FA
        0x8B77, # G+8010  U+8B77  uni8B77,  CJK UNIFIED IDEOGRAPH-8B77
        0x6EEC, # G+8011  U+6EEC  uni6EEC,  CJK UNIFIED IDEOGRAPH-6EEC
        0x5629, # G+8012  U+5629  uni5629,  CJK UNIFIED IDEOGRAPH-5629
        0x83EF, # G+8013  U+83EF  uni83EF,  CJK UNIFIED IDEOGRAPH-83EF
        0x756B, # G+8014  U+756B  uni756B,  CJK UNIFIED IDEOGRAPH-756B
        0x5283, # G+8015  U+5283  uni5283,  CJK UNIFIED IDEOGRAPH-5283
        0x8A71, # G+8016  U+8A71  uni8A71,  CJK UNIFIED IDEOGRAPH-8A71
        0x61F7, # G+8017  U+61F7  uni61F7,  CJK UNIFIED IDEOGRAPH-61F7
        0x58DE, # G+8018  U+58DE  uni58DE,  CJK UNIFIED IDEOGRAPH-58DE
        0x6B61, # G+8019  U+6B61  uni6B61,  CJK UNIFIED IDEOGRAPH-6B61
        0x74B0, # G+8020  U+74B0  uni74B0,  CJK UNIFIED IDEOGRAPH-74B0
        0x9084, # G+8021  U+9084  uni9084,  CJK UNIFIED IDEOGRAPH-9084
        0x7DE9, # G+8022  U+7DE9  uni7DE9,  CJK UNIFIED IDEOGRAPH-7DE9
        0x8B0A, # G+8023  U+8B0A  uni8B0A,  CJK UNIFIED IDEOGRAPH-8B0A
        0x63EE, # G+8024  U+63EE  uni63EE,  CJK UNIFIED IDEOGRAPH-63EE
        0x8F1D, # G+8025  U+8F1D  uni8F1D,  CJK UNIFIED IDEOGRAPH-8F1D
        0x8CC4, # G+8026  U+8CC4  uni8CC4,  CJK UNIFIED IDEOGRAPH-8CC4
        0x7A62, # G+8027  U+7A62  uni7A62,  CJK UNIFIED IDEOGRAPH-7A62
        0x6703, # G+8028  U+6703  uni6703,  CJK UNIFIED IDEOGRAPH-6703
        0x71F4, # G+8029  U+71F4  uni71F4,  CJK UNIFIED IDEOGRAPH-71F4
        0x532F, # G+8030  U+532F  uni532F,  CJK UNIFIED IDEOGRAPH-532F
        0x8AF1, # G+8031  U+8AF1  uni8AF1,  CJK UNIFIED IDEOGRAPH-8AF1
        0x8AA8, # G+8032  U+8AA8  uni8AA8,  CJK UNIFIED IDEOGRAPH-8AA8
        0x7E6A, # G+8033  U+7E6A  uni7E6A,  CJK UNIFIED IDEOGRAPH-7E6A
        0x8477, # G+8034  U+8477  uni8477,  CJK UNIFIED IDEOGRAPH-8477
        0x6E3E, # G+8035  U+6E3E  uni6E3E,  CJK UNIFIED IDEOGRAPH-6E3E
        0x7372, # G+8036  U+7372  uni7372,  CJK UNIFIED IDEOGRAPH-7372
        0x8CA8, # G+8037  U+8CA8  uni8CA8,  CJK UNIFIED IDEOGRAPH-8CA8
        0x798D, # G+8038  U+798D  uni798D,  CJK UNIFIED IDEOGRAPH-798D
        0x64CA, # G+8039  U+64CA  uni64CA,  CJK UNIFIED IDEOGRAPH-64CA
        0x6A5F, # G+8040  U+6A5F  uni6A5F,  CJK UNIFIED IDEOGRAPH-6A5F
        0x7A4D, # G+8041  U+7A4D  uni7A4D,  CJK UNIFIED IDEOGRAPH-7A4D
        0x9951, # G+8042  U+9951  uni9951,  CJK UNIFIED IDEOGRAPH-9951
        0x8B4F, # G+8043  U+8B4F  uni8B4F,  CJK UNIFIED IDEOGRAPH-8B4F
        0x9DC4, # G+8044  U+9DC4  uni9DC4,  CJK UNIFIED IDEOGRAPH-9DC4
        0x7E3E, # G+8045  U+7E3E  uni7E3E,  CJK UNIFIED IDEOGRAPH-7E3E
        0x7DDD, # G+8046  U+7DDD  uni7DDD,  CJK UNIFIED IDEOGRAPH-7DDD
        0x6975, # G+8047  U+6975  uni6975,  CJK UNIFIED IDEOGRAPH-6975
        0x8F2F, # G+8048  U+8F2F  uni8F2F,  CJK UNIFIED IDEOGRAPH-8F2F
        0x7D1A, # G+8049  U+7D1A  uni7D1A,  CJK UNIFIED IDEOGRAPH-7D1A
        0x64E0, # G+8050  U+64E0  uni64E0,  CJK UNIFIED IDEOGRAPH-64E0
        0x5E7E, # G+8051  U+5E7E  uni5E7E,  CJK UNIFIED IDEOGRAPH-5E7E
        0x858A, # G+8052  U+858A  uni858A,  CJK UNIFIED IDEOGRAPH-858A
        0x5291, # G+8053  U+5291  uni5291,  CJK UNIFIED IDEOGRAPH-5291
        0x6FDF, # G+8054  U+6FDF  uni6FDF,  CJK UNIFIED IDEOGRAPH-6FDF
        0x8A08, # G+8055  U+8A08  uni8A08,  CJK UNIFIED IDEOGRAPH-8A08
        0x8A18, # G+8056  U+8A18  uni8A18,  CJK UNIFIED IDEOGRAPH-8A18
        0x969B, # G+8057  U+969B  uni969B,  CJK UNIFIED IDEOGRAPH-969B
        0x7E7C, # G+8058  U+7E7C  uni7E7C,  CJK UNIFIED IDEOGRAPH-7E7C
        0x7D00, # G+8059  U+7D00  uni7D00,  CJK UNIFIED IDEOGRAPH-7D00
        0x593E, # G+8060  U+593E  uni593E,  CJK UNIFIED IDEOGRAPH-593E
        0x83A2, # G+8061  U+83A2  uni83A2,  CJK UNIFIED IDEOGRAPH-83A2
        0x9830, # G+8062  U+9830  uni9830,  CJK UNIFIED IDEOGRAPH-9830
        0x8CC8, # G+8063  U+8CC8  uni8CC8,  CJK UNIFIED IDEOGRAPH-8CC8
        0x9240, # G+8064  U+9240  uni9240,  CJK UNIFIED IDEOGRAPH-9240
        0x50F9, # G+8065  U+50F9  uni50F9,  CJK UNIFIED IDEOGRAPH-50F9
        0x99D5, # G+8066  U+99D5  uni99D5,  CJK UNIFIED IDEOGRAPH-99D5
        0x6BB2, # G+8067  U+6BB2  uni6BB2,  CJK UNIFIED IDEOGRAPH-6BB2
        0x76E3, # G+8068  U+76E3  uni76E3,  CJK UNIFIED IDEOGRAPH-76E3
        0x5805, # G+8069  U+5805  uni5805,  CJK UNIFIED IDEOGRAPH-5805
        0x7B8B, # G+8070  U+7B8B  uni7B8B,  CJK UNIFIED IDEOGRAPH-7B8B
        0x9593, # G+8071  U+9593  uni9593,  CJK UNIFIED IDEOGRAPH-9593
        0x8271, # G+8072  U+8271  uni8271,  CJK UNIFIED IDEOGRAPH-8271
        0x7DD8, # G+8073  U+7DD8  uni7DD8,  CJK UNIFIED IDEOGRAPH-7DD8
        0x7E6D, # G+8074  U+7E6D  uni7E6D,  CJK UNIFIED IDEOGRAPH-7E6D
        0x6AA2, # G+8075  U+6AA2  uni6AA2,  CJK UNIFIED IDEOGRAPH-6AA2
        0x9E7C, # G+8076  U+9E7C  uni9E7C,  CJK UNIFIED IDEOGRAPH-9E7C
        0x63C0, # G+8077  U+63C0  uni63C0,  CJK UNIFIED IDEOGRAPH-63C0
        0x64BF, # G+8078  U+64BF  uni64BF,  CJK UNIFIED IDEOGRAPH-64BF
        0x7C21, # G+8079  U+7C21  uni7C21,  CJK UNIFIED IDEOGRAPH-7C21
        0x5109, # G+8080  U+5109  uni5109,  CJK UNIFIED IDEOGRAPH-5109
        0x85A6, # G+8081  U+85A6  uni85A6,  CJK UNIFIED IDEOGRAPH-85A6
        0x6ABB, # G+8082  U+6ABB  uni6ABB,  CJK UNIFIED IDEOGRAPH-6ABB
        0x9452, # G+8083  U+9452  uni9452,  CJK UNIFIED IDEOGRAPH-9452
        0x8E10, # G+8084  U+8E10  uni8E10,  CJK UNIFIED IDEOGRAPH-8E10
        0x8CE4, # G+8085  U+8CE4  uni8CE4,  CJK UNIFIED IDEOGRAPH-8CE4
        0x2F92, # G+8086  U+2F92  uni2F92,  KANGXI RADICAL SEE
        0x9375, # G+8087  U+9375  uni9375,  CJK UNIFIED IDEOGRAPH-9375
        0x8266, # G+8088  U+8266  uni8266,  CJK UNIFIED IDEOGRAPH-8266
        0x528D, # G+8089  U+528D  uni528D,  CJK UNIFIED IDEOGRAPH-528D
        0x991E, # G+8090  U+991E  uni991E,  CJK UNIFIED IDEOGRAPH-991E
        0x6F38, # G+8091  U+6F38  uni6F38,  CJK UNIFIED IDEOGRAPH-6F38
        0x6FFA, # G+8092  U+6FFA  uni6FFA,  CJK UNIFIED IDEOGRAPH-6FFA
        0x6F97, # G+8093  U+6F97  uni6F97,  CJK UNIFIED IDEOGRAPH-6F97
        0x5C07, # G+8094  U+5C07  uni5C07,  CJK UNIFIED IDEOGRAPH-5C07
        0x6F3F, # G+8095  U+6F3F  uni6F3F,  CJK UNIFIED IDEOGRAPH-6F3F
        0x8523, # G+8096  U+8523  uni8523,  CJK UNIFIED IDEOGRAPH-8523
        0x69F3, # G+8097  U+69F3  uni69F3,  CJK UNIFIED IDEOGRAPH-69F3
        0x596C, # G+8098  U+596C  uni596C,  CJK UNIFIED IDEOGRAPH-596C
        0x8B1B, # G+8099  U+8B1B  uni8B1B,  CJK UNIFIED IDEOGRAPH-8B1B
        0x91AC, # G+8100  U+91AC  uni91AC,  CJK UNIFIED IDEOGRAPH-91AC
        0x81A0, # G+8101  U+81A0  uni81A0,  CJK UNIFIED IDEOGRAPH-81A0
        0x6F86, # G+8102  U+6F86  uni6F86,  CJK UNIFIED IDEOGRAPH-6F86
        0x9A55, # G+8103  U+9A55  uni9A55,  CJK UNIFIED IDEOGRAPH-9A55
        0x5B0C, # G+8104  U+5B0C  uni5B0C,  CJK UNIFIED IDEOGRAPH-5B0C
        0x652A, # G+8105  U+652A  uni652A,  CJK UNIFIED IDEOGRAPH-652A
        0x9278, # G+8106  U+9278  uni9278,  CJK UNIFIED IDEOGRAPH-9278
        0x77EF, # G+8107  U+77EF  uni77EF,  CJK UNIFIED IDEOGRAPH-77EF
        0x50E5, # G+8108  U+50E5  uni50E5,  CJK UNIFIED IDEOGRAPH-50E5
        0x9903, # G+8109  U+9903  uni9903,  CJK UNIFIED IDEOGRAPH-9903
        0x7E73, # G+8110  U+7E73  uni7E73,  CJK UNIFIED IDEOGRAPH-7E73
        0x7D5E, # G+8111  U+7D5E  uni7D5E,  CJK UNIFIED IDEOGRAPH-7D5E
        0x8F4E, # G+8112  U+8F4E  uni8F4E,  CJK UNIFIED IDEOGRAPH-8F4E
        0x8F03, # G+8113  U+8F03  uni8F03,  CJK UNIFIED IDEOGRAPH-8F03
        0x968E, # G+8114  U+968E  uni968E,  CJK UNIFIED IDEOGRAPH-968E
        0x7BC0, # G+8115  U+7BC0  uni7BC0,  CJK UNIFIED IDEOGRAPH-7BC0
        0x6F54, # G+8116  U+6F54  uni6F54,  CJK UNIFIED IDEOGRAPH-6F54
        0x7D50, # G+8117  U+7D50  uni7D50,  CJK UNIFIED IDEOGRAPH-7D50
        0x8AA1, # G+8118  U+8AA1  uni8AA1,  CJK UNIFIED IDEOGRAPH-8AA1
        0x7DCA, # G+8119  U+7DCA  uni7DCA,  CJK UNIFIED IDEOGRAPH-7DCA
        0x9326, # G+8120  U+9326  uni9326,  CJK UNIFIED IDEOGRAPH-9326
        0x50C5, # G+8121  U+50C5  uni50C5,  CJK UNIFIED IDEOGRAPH-50C5
        0x8B39, # G+8122  U+8B39  uni8B39,  CJK UNIFIED IDEOGRAPH-8B39
        0x9032, # G+8123  U+9032  uni9032,  CJK UNIFIED IDEOGRAPH-9032
        0x71FC, # G+8124  U+71FC  uni71FC,  CJK UNIFIED IDEOGRAPH-71FC
        0x76E1, # G+8125  U+76E1  uni76E1,  CJK UNIFIED IDEOGRAPH-76E1
        0x52C1, # G+8126  U+52C1  uni52C1,  CJK UNIFIED IDEOGRAPH-52C1
        0x8396, # G+8127  U+8396  uni8396,  CJK UNIFIED IDEOGRAPH-8396
        0x9BE8, # G+8128  U+9BE8  uni9BE8,  CJK UNIFIED IDEOGRAPH-9BE8
        0x9A5A, # G+8129  U+9A5A  uni9A5A,  CJK UNIFIED IDEOGRAPH-9A5A
        0x7D93, # G+8130  U+7D93  uni7D93,  CJK UNIFIED IDEOGRAPH-7D93
        0x9838, # G+8131  U+9838  uni9838,  CJK UNIFIED IDEOGRAPH-9838
        0x93E1, # G+8132  U+93E1  uni93E1,  CJK UNIFIED IDEOGRAPH-93E1
        0x5F91, # G+8133  U+5F91  uni5F91,  CJK UNIFIED IDEOGRAPH-5F91
        0x75D9, # G+8134  U+75D9  uni75D9,  CJK UNIFIED IDEOGRAPH-75D9
        0x7AF6, # G+8135  U+7AF6  uni7AF6,  CJK UNIFIED IDEOGRAPH-7AF6
        0x7CFE, # G+8136  U+7CFE  uni7CFE,  CJK UNIFIED IDEOGRAPH-7CFE
        0x820A, # G+8137  U+820A  uni820A,  CJK UNIFIED IDEOGRAPH-820A
        0x99D2, # G+8138  U+99D2  uni99D2,  CJK UNIFIED IDEOGRAPH-99D2
        0x8209, # G+8139  U+8209  uni8209,  CJK UNIFIED IDEOGRAPH-8209
        0x64DA, # G+8140  U+64DA  uni64DA,  CJK UNIFIED IDEOGRAPH-64DA
        0x92F8, # G+8141  U+92F8  uni92F8,  CJK UNIFIED IDEOGRAPH-92F8
        0x61FC, # G+8142  U+61FC  uni61FC,  CJK UNIFIED IDEOGRAPH-61FC
        0x5287, # G+8143  U+5287  uni5287,  CJK UNIFIED IDEOGRAPH-5287
        0x9D51, # G+8144  U+9D51  uni9D51,  CJK UNIFIED IDEOGRAPH-9D51
        0x7D79, # G+8145  U+7D79  uni7D79,  CJK UNIFIED IDEOGRAPH-7D79
        0x89BA, # G+8146  U+89BA  uni89BA,  CJK UNIFIED IDEOGRAPH-89BA
        0x8A23, # G+8147  U+8A23  uni8A23,  CJK UNIFIED IDEOGRAPH-8A23
        0x7D76, # G+8148  U+7D76  uni7D76,  CJK UNIFIED IDEOGRAPH-7D76
        0x921E, # G+8149  U+921E  uni921E,  CJK UNIFIED IDEOGRAPH-921E
        0x8ECD, # G+8150  U+8ECD  uni8ECD,  CJK UNIFIED IDEOGRAPH-8ECD
        0x99FF, # G+8151  U+99FF  uni99FF,  CJK UNIFIED IDEOGRAPH-99FF
        0x958B, # G+8152  U+958B  uni958B,  CJK UNIFIED IDEOGRAPH-958B
        0x51F1, # G+8153  U+51F1  uni51F1,  CJK UNIFIED IDEOGRAPH-51F1
        0x9846, # G+8154  U+9846  uni9846,  CJK UNIFIED IDEOGRAPH-9846
        0x6BBB, # G+8155  U+6BBB  uni6BBB,  CJK UNIFIED IDEOGRAPH-6BBB
        0x8AB2, # G+8156  U+8AB2  uni8AB2,  CJK UNIFIED IDEOGRAPH-8AB2
        0x58BE, # G+8157  U+58BE  uni58BE,  CJK UNIFIED IDEOGRAPH-58BE
        0x61C7, # G+8158  U+61C7  uni61C7,  CJK UNIFIED IDEOGRAPH-61C7
        0x6473, # G+8159  U+6473  uni6473,  CJK UNIFIED IDEOGRAPH-6473
        0x5EAB, # G+8160  U+5EAB  uni5EAB,  CJK UNIFIED IDEOGRAPH-5EAB
        0x8932, # G+8161  U+8932  uni8932,  CJK UNIFIED IDEOGRAPH-8932
        0x8A87, # G+8162  U+8A87  uni8A87,  CJK UNIFIED IDEOGRAPH-8A87
        0x584A, # G+8163  U+584A  uni584A,  CJK UNIFIED IDEOGRAPH-584A
        0x5108, # G+8164  U+5108  uni5108,  CJK UNIFIED IDEOGRAPH-5108
        0x5BEC, # G+8165  U+5BEC  uni5BEC,  CJK UNIFIED IDEOGRAPH-5BEC
        0x7926, # G+8166  U+7926  uni7926,  CJK UNIFIED IDEOGRAPH-7926
        0x66E0, # G+8167  U+66E0  uni66E0,  CJK UNIFIED IDEOGRAPH-66E0
        0x8667, # G+8168  U+8667  uni8667,  CJK UNIFIED IDEOGRAPH-8667
        0x5DCB, # G+8169  U+5DCB  uni5DCB,  CJK UNIFIED IDEOGRAPH-5DCB
        0x7ABA, # G+8170  U+7ABA  uni7ABA,  CJK UNIFIED IDEOGRAPH-7ABA
        0x994B, # G+8171  U+994B  uni994B,  CJK UNIFIED IDEOGRAPH-994B
        0x6F70, # G+8172  U+6F70  uni6F70,  CJK UNIFIED IDEOGRAPH-6F70
        0x64F4, # G+8173  U+64F4  uni64F4,  CJK UNIFIED IDEOGRAPH-64F4
        0x95CA, # G+8174  U+95CA  uni95CA,  CJK UNIFIED IDEOGRAPH-95CA
        0x881F, # G+8175  U+881F  uni881F,  CJK UNIFIED IDEOGRAPH-881F
        0x81D8, # G+8176  U+81D8  uni81D8,  CJK UNIFIED IDEOGRAPH-81D8
        0x840A, # G+8177  U+840A  uni840A,  CJK UNIFIED IDEOGRAPH-840A
        0x4F86, # G+8178  U+4F86  uni4F86,  CJK UNIFIED IDEOGRAPH-4F86
        0x8CF4, # G+8179  U+8CF4  uni8CF4,  CJK UNIFIED IDEOGRAPH-8CF4
        0x85CD, # G+8180  U+85CD  uni85CD,  CJK UNIFIED IDEOGRAPH-85CD
        0x6B04, # G+8181  U+6B04  uni6B04,  CJK UNIFIED IDEOGRAPH-6B04
        0x6514, # G+8182  U+6514  uni6514,  CJK UNIFIED IDEOGRAPH-6514
        0x7C43, # G+8183  U+7C43  uni7C43,  CJK UNIFIED IDEOGRAPH-7C43
        0x95CC, # G+8184  U+95CC  uni95CC,  CJK UNIFIED IDEOGRAPH-95CC
        0x862D, # G+8185  U+862D  uni862D,  CJK UNIFIED IDEOGRAPH-862D
        0x703E, # G+8186  U+703E  uni703E,  CJK UNIFIED IDEOGRAPH-703E
        0x8B95, # G+8187  U+8B95  uni8B95,  CJK UNIFIED IDEOGRAPH-8B95
        0x652C, # G+8188  U+652C  uni652C,  CJK UNIFIED IDEOGRAPH-652C
        0x89BD, # G+8189  U+89BD  uni89BD,  CJK UNIFIED IDEOGRAPH-89BD
        0x61F6, # G+8190  U+61F6  uni61F6,  CJK UNIFIED IDEOGRAPH-61F6
        0x7E9C, # G+8191  U+7E9C  uni7E9C,  CJK UNIFIED IDEOGRAPH-7E9C
        0x721B, # G+8192  U+721B  uni721B,  CJK UNIFIED IDEOGRAPH-721B
        0x6FEB, # G+8193  U+6FEB  uni6FEB,  CJK UNIFIED IDEOGRAPH-6FEB
        0x6488, # G+8194  U+6488  uni6488,  CJK UNIFIED IDEOGRAPH-6488
        0x52DE, # G+8195  U+52DE  uni52DE,  CJK UNIFIED IDEOGRAPH-52DE
        0x6F87, # G+8196  U+6F87  uni6F87,  CJK UNIFIED IDEOGRAPH-6F87
        0x6A02, # G+8197  U+6A02  uni6A02,  CJK UNIFIED IDEOGRAPH-6A02
        0x9433, # G+8198  U+9433  uni9433,  CJK UNIFIED IDEOGRAPH-9433
        0x58D8, # G+8199  U+58D8  uni58D8,  CJK UNIFIED IDEOGRAPH-58D8
        0x985E, # G+8200  U+985E  uni985E,  CJK UNIFIED IDEOGRAPH-985E
        0x7C6C, # G+8201  U+7C6C  uni7C6C,  CJK UNIFIED IDEOGRAPH-7C6C
        0x96E2, # G+8202  U+96E2  uni96E2,  CJK UNIFIED IDEOGRAPH-96E2
        0x7055, # G+8203  U+7055  uni7055,  CJK UNIFIED IDEOGRAPH-7055
        0x88CF, # G+8204  U+88CF  uni88CF,  CJK UNIFIED IDEOGRAPH-88CF
        0x9BC9, # G+8205  U+9BC9  uni9BC9,  CJK UNIFIED IDEOGRAPH-9BC9
        0x79AE, # G+8206  U+79AE  uni79AE,  CJK UNIFIED IDEOGRAPH-79AE
        0x9E97, # G+8207  U+9E97  uni9E97,  CJK UNIFIED IDEOGRAPH-9E97
        0x53B2, # G+8208  U+53B2  uni53B2,  CJK UNIFIED IDEOGRAPH-53B2
        0x52F5, # G+8209  U+52F5  uni52F5,  CJK UNIFIED IDEOGRAPH-52F5
        0x792B, # G+8210  U+792B  uni792B,  CJK UNIFIED IDEOGRAPH-792B
        0x6B77, # G+8211  U+6B77  uni6B77,  CJK UNIFIED IDEOGRAPH-6B77
        0x701D, # G+8212  U+701D  uni701D,  CJK UNIFIED IDEOGRAPH-701D
        0x96B8, # G+8213  U+96B8  uni96B8,  CJK UNIFIED IDEOGRAPH-96B8
        0x5006, # G+8214  U+5006  uni5006,  CJK UNIFIED IDEOGRAPH-5006
        0x806F, # G+8215  U+806F  uni806F,  CJK UNIFIED IDEOGRAPH-806F
        0x84EE, # G+8216  U+84EE  uni84EE,  CJK UNIFIED IDEOGRAPH-84EE
        0x9023, # G+8217  U+9023  uni9023,  CJK UNIFIED IDEOGRAPH-9023
        0x942E, # G+8218  U+942E  uni942E,  CJK UNIFIED IDEOGRAPH-942E
        0x6190, # G+8219  U+6190  uni6190,  CJK UNIFIED IDEOGRAPH-6190
        0x6F23, # G+8220  U+6F23  uni6F23,  CJK UNIFIED IDEOGRAPH-6F23
        0x7C3E, # G+8221  U+7C3E  uni7C3E,  CJK UNIFIED IDEOGRAPH-7C3E
        0x6582, # G+8222  U+6582  uni6582,  CJK UNIFIED IDEOGRAPH-6582
        0x81C9, # G+8223  U+81C9  uni81C9,  CJK UNIFIED IDEOGRAPH-81C9
        0x93C8, # G+8224  U+93C8  uni93C8,  CJK UNIFIED IDEOGRAPH-93C8
        0x6200, # G+8225  U+6200  uni6200,  CJK UNIFIED IDEOGRAPH-6200
        0x7149, # G+8226  U+7149  uni7149,  CJK UNIFIED IDEOGRAPH-7149
        0x7DF4, # G+8227  U+7DF4  uni7DF4,  CJK UNIFIED IDEOGRAPH-7DF4
        0x7CE7, # G+8228  U+7CE7  uni7CE7,  CJK UNIFIED IDEOGRAPH-7CE7
        0x5169, # G+8229  U+5169  uni5169,  CJK UNIFIED IDEOGRAPH-5169
        0x8F1B, # G+8230  U+8F1B  uni8F1B,  CJK UNIFIED IDEOGRAPH-8F1B
        0x8AD2, # G+8231  U+8AD2  uni8AD2,  CJK UNIFIED IDEOGRAPH-8AD2
        0x7642, # G+8232  U+7642  uni7642,  CJK UNIFIED IDEOGRAPH-7642
        0x907C, # G+8233  U+907C  uni907C,  CJK UNIFIED IDEOGRAPH-907C
        0x9410, # G+8234  U+9410  uni9410,  CJK UNIFIED IDEOGRAPH-9410
        0x7375, # G+8235  U+7375  uni7375,  CJK UNIFIED IDEOGRAPH-7375
        0x81E8, # G+8236  U+81E8  uni81E8,  CJK UNIFIED IDEOGRAPH-81E8
        0x9130, # G+8237  U+9130  uni9130,  CJK UNIFIED IDEOGRAPH-9130
        0x9C57, # G+8238  U+9C57  uni9C57,  CJK UNIFIED IDEOGRAPH-9C57
        0x8CC3, # G+8239  U+8CC3  uni8CC3,  CJK UNIFIED IDEOGRAPH-8CC3
        0x9F61, # G+8240  U+9F61  uni9F61,  CJK UNIFIED IDEOGRAPH-9F61
        0x9234, # G+8241  U+9234  uni9234,  CJK UNIFIED IDEOGRAPH-9234
        0x9748, # G+8242  U+9748  uni9748,  CJK UNIFIED IDEOGRAPH-9748
        0x5DBA, # G+8243  U+5DBA  uni5DBA,  CJK UNIFIED IDEOGRAPH-5DBA
        0x9818, # G+8244  U+9818  uni9818,  CJK UNIFIED IDEOGRAPH-9818
        0x993E, # G+8245  U+993E  uni993E,  CJK UNIFIED IDEOGRAPH-993E
        0x5289, # G+8246  U+5289  uni5289,  CJK UNIFIED IDEOGRAPH-5289
        0x2FD3, # G+8247  U+2FD3  uni2FD3,  KANGXI RADICAL DRAGON
        0x807E, # G+8248  U+807E  uni807E,  CJK UNIFIED IDEOGRAPH-807E
        0x56A8, # G+8249  U+56A8  uni56A8,  CJK UNIFIED IDEOGRAPH-56A8
        0x7C60, # G+8250  U+7C60  uni7C60,  CJK UNIFIED IDEOGRAPH-7C60
        0x58DF, # G+8251  U+58DF  uni58DF,  CJK UNIFIED IDEOGRAPH-58DF
        0x650F, # G+8252  U+650F  uni650F,  CJK UNIFIED IDEOGRAPH-650F
        0x96B4, # G+8253  U+96B4  uni96B4,  CJK UNIFIED IDEOGRAPH-96B4
        0x6A13, # G+8254  U+6A13  uni6A13,  CJK UNIFIED IDEOGRAPH-6A13
        0x5A41, # G+8255  U+5A41  uni5A41,  CJK UNIFIED IDEOGRAPH-5A41
        0x645F, # G+8256  U+645F  uni645F,  CJK UNIFIED IDEOGRAPH-645F
        0x7C0D, # G+8257  U+7C0D  uni7C0D,  CJK UNIFIED IDEOGRAPH-7C0D
        0x8606, # G+8258  U+8606  uni8606,  CJK UNIFIED IDEOGRAPH-8606
        0x76E7, # G+8259  U+76E7  uni76E7,  CJK UNIFIED IDEOGRAPH-76E7
        0x9871, # G+8260  U+9871  uni9871,  CJK UNIFIED IDEOGRAPH-9871
        0x5EEC, # G+8261  U+5EEC  uni5EEC,  CJK UNIFIED IDEOGRAPH-5EEC
        0x7210, # G+8262  U+7210  uni7210,  CJK UNIFIED IDEOGRAPH-7210
        0x64C4, # G+8263  U+64C4  uni64C4,  CJK UNIFIED IDEOGRAPH-64C4
        0x6EF7, # G+8264  U+6EF7  uni6EF7,  CJK UNIFIED IDEOGRAPH-6EF7
        0x865C, # G+8265  U+865C  uni865C,  CJK UNIFIED IDEOGRAPH-865C
        0x9B6F, # G+8266  U+9B6F  uni9B6F,  CJK UNIFIED IDEOGRAPH-9B6F
        0x8CC2, # G+8267  U+8CC2  uni8CC2,  CJK UNIFIED IDEOGRAPH-8CC2
        0x9332, # G+8268  U+9332  uni9332,  CJK UNIFIED IDEOGRAPH-9332
        0x9678, # G+8269  U+9678  uni9678,  CJK UNIFIED IDEOGRAPH-9678
        0x9A62, # G+8270  U+9A62  uni9A62,  CJK UNIFIED IDEOGRAPH-9A62
        0x92C1, # G+8271  U+92C1  uni92C1,  CJK UNIFIED IDEOGRAPH-92C1
        0x5C62, # G+8272  U+5C62  uni5C62,  CJK UNIFIED IDEOGRAPH-5C62
        0x7E37, # G+8273  U+7E37  uni7E37,  CJK UNIFIED IDEOGRAPH-7E37
        0x616E, # G+8274  U+616E  uni616E,  CJK UNIFIED IDEOGRAPH-616E
        0x6FFE, # G+8275  U+6FFE  uni6FFE,  CJK UNIFIED IDEOGRAPH-6FFE
        0x7DD1, # G+8276  U+7DD1  uni7DD1,  CJK UNIFIED IDEOGRAPH-7DD1
        0x5DD2, # G+8277  U+5DD2  uni5DD2,  CJK UNIFIED IDEOGRAPH-5DD2
        0x6523, # G+8278  U+6523  uni6523,  CJK UNIFIED IDEOGRAPH-6523
        0x5B7F, # G+8279  U+5B7F  uni5B7F,  CJK UNIFIED IDEOGRAPH-5B7F
        0x7064, # G+8280  U+7064  uni7064,  CJK UNIFIED IDEOGRAPH-7064
        0x4E82, # G+8281  U+4E82  uni4E82,  CJK UNIFIED IDEOGRAPH-4E82
        0x6384, # G+8282  U+6384  uni6384,  CJK UNIFIED IDEOGRAPH-6384
        0x8F2A, # G+8283  U+8F2A  uni8F2A,  CJK UNIFIED IDEOGRAPH-8F2A
        0x502B, # G+8284  U+502B  uni502B,  CJK UNIFIED IDEOGRAPH-502B
        0x4F96, # G+8285  U+4F96  uni4F96,  CJK UNIFIED IDEOGRAPH-4F96
        0x6DEA, # G+8286  U+6DEA  uni6DEA,  CJK UNIFIED IDEOGRAPH-6DEA
        0x7DB8, # G+8287  U+7DB8  uni7DB8,  CJK UNIFIED IDEOGRAPH-7DB8
        0x8AD6, # G+8288  U+8AD6  uni8AD6,  CJK UNIFIED IDEOGRAPH-8AD6
        0x863F, # G+8289  U+863F  uni863F,  CJK UNIFIED IDEOGRAPH-863F
        0x7F85, # G+8290  U+7F85  uni7F85,  CJK UNIFIED IDEOGRAPH-7F85
        0x908F, # G+8291  U+908F  uni908F,  CJK UNIFIED IDEOGRAPH-908F
        0x947C, # G+8292  U+947C  uni947C,  CJK UNIFIED IDEOGRAPH-947C
        0x7C6E, # G+8293  U+7C6E  uni7C6E,  CJK UNIFIED IDEOGRAPH-7C6E
        0x9A3E, # G+8294  U+9A3E  uni9A3E,  CJK UNIFIED IDEOGRAPH-9A3E
        0x99F1, # G+8295  U+99F1  uni99F1,  CJK UNIFIED IDEOGRAPH-99F1
        0x7D61, # G+8296  U+7D61  uni7D61,  CJK UNIFIED IDEOGRAPH-7D61
        0x5ABD, # G+8297  U+5ABD  uni5ABD,  CJK UNIFIED IDEOGRAPH-5ABD
        0x746A, # G+8298  U+746A  uni746A,  CJK UNIFIED IDEOGRAPH-746A
        0x78BC, # G+8299  U+78BC  uni78BC,  CJK UNIFIED IDEOGRAPH-78BC
        0x879E, # G+8300  U+879E  uni879E,  CJK UNIFIED IDEOGRAPH-879E
        0x2FBA, # G+8301  U+2FBA  uni2FBA,  KANGXI RADICAL HORSE
        0x99E1, # G+8302  U+99E1  uni99E1,  CJK UNIFIED IDEOGRAPH-99E1
        0x55CE, # G+8303  U+55CE  uni55CE,  CJK UNIFIED IDEOGRAPH-55CE
        0x8CB7, # G+8304  U+8CB7  uni8CB7,  CJK UNIFIED IDEOGRAPH-8CB7
        0x2FC6, # G+8305  U+2FC6  uni2FC6,  KANGXI RADICAL WHEAT
        0x8CE3, # G+8306  U+8CE3  uni8CE3,  CJK UNIFIED IDEOGRAPH-8CE3
        0x9081, # G+8307  U+9081  uni9081,  CJK UNIFIED IDEOGRAPH-9081
        0x779E, # G+8308  U+779E  uni779E,  CJK UNIFIED IDEOGRAPH-779E
        0x9945, # G+8309  U+9945  uni9945,  CJK UNIFIED IDEOGRAPH-9945
        0x883B, # G+8310  U+883B  uni883B,  CJK UNIFIED IDEOGRAPH-883B
        0x6EFF, # G+8311  U+6EFF  uni6EFF,  CJK UNIFIED IDEOGRAPH-6EFF
        0x8B3E, # G+8312  U+8B3E  uni8B3E,  CJK UNIFIED IDEOGRAPH-8B3E
        0x9328, # G+8313  U+9328  uni9328,  CJK UNIFIED IDEOGRAPH-9328
        0x925A, # G+8314  U+925A  uni925A,  CJK UNIFIED IDEOGRAPH-925A
        0x8CBF, # G+8315  U+8CBF  uni8CBF,  CJK UNIFIED IDEOGRAPH-8CBF
        0x9382, # G+8316  U+9382  uni9382,  CJK UNIFIED IDEOGRAPH-9382
        0x2FA8, # G+8317  U+2FA8  uni2FA8,  KANGXI RADICAL GATE
        0x60B6, # G+8318  U+60B6  uni60B6,  CJK UNIFIED IDEOGRAPH-60B6
        0x5011, # G+8319  U+5011  uni5011,  CJK UNIFIED IDEOGRAPH-5011
        0x9333, # G+8320  U+9333  uni9333,  CJK UNIFIED IDEOGRAPH-9333
        0x5922, # G+8321  U+5922  uni5922,  CJK UNIFIED IDEOGRAPH-5922
        0x8B0E, # G+8322  U+8B0E  uni8B0E,  CJK UNIFIED IDEOGRAPH-8B0E
        0x5F4C, # G+8323  U+5F4C  uni5F4C,  CJK UNIFIED IDEOGRAPH-5F4C
        0x8993, # G+8324  U+8993  uni8993,  CJK UNIFIED IDEOGRAPH-8993
        0x7DBF, # G+8325  U+7DBF  uni7DBF,  CJK UNIFIED IDEOGRAPH-7DBF
        0x7DEC, # G+8326  U+7DEC  uni7DEC,  CJK UNIFIED IDEOGRAPH-7DEC
        0x5EDF, # G+8327  U+5EDF  uni5EDF,  CJK UNIFIED IDEOGRAPH-5EDF
        0x6EC5, # G+8328  U+6EC5  uni6EC5,  CJK UNIFIED IDEOGRAPH-6EC5
        0x61AB, # G+8329  U+61AB  uni61AB,  CJK UNIFIED IDEOGRAPH-61AB
        0x95A9, # G+8330  U+95A9  uni95A9,  CJK UNIFIED IDEOGRAPH-95A9
        0x9CF4, # G+8331  U+9CF4  uni9CF4,  CJK UNIFIED IDEOGRAPH-9CF4
        0x9298, # G+8332  U+9298  uni9298,  CJK UNIFIED IDEOGRAPH-9298
        0x8B2C, # G+8333  U+8B2C  uni8B2C,  CJK UNIFIED IDEOGRAPH-8B2C
        0x8B00, # G+8334  U+8B00  uni8B00,  CJK UNIFIED IDEOGRAPH-8B00
        0x755D, # G+8335  U+755D  uni755D,  CJK UNIFIED IDEOGRAPH-755D
        0x9209, # G+8336  U+9209  uni9209,  CJK UNIFIED IDEOGRAPH-9209
        0x7D0D, # G+8337  U+7D0D  uni7D0D,  CJK UNIFIED IDEOGRAPH-7D0D
        0x96E3, # G+8338  U+96E3  uni96E3,  CJK UNIFIED IDEOGRAPH-96E3
        0x6493, # G+8339  U+6493  uni6493,  CJK UNIFIED IDEOGRAPH-6493
        0x8166, # G+8340  U+8166  uni8166,  CJK UNIFIED IDEOGRAPH-8166
        0x60F1, # G+8341  U+60F1  uni60F1,  CJK UNIFIED IDEOGRAPH-60F1
        0x9B27, # G+8342  U+9B27  uni9B27,  CJK UNIFIED IDEOGRAPH-9B27
        0x9912, # G+8343  U+9912  uni9912,  CJK UNIFIED IDEOGRAPH-9912
        0x64EC, # G+8344  U+64EC  uni64EC,  CJK UNIFIED IDEOGRAPH-64EC
        0x81A9, # G+8345  U+81A9  uni81A9,  CJK UNIFIED IDEOGRAPH-81A9
        0x6506, # G+8346  U+6506  uni6506,  CJK UNIFIED IDEOGRAPH-6506
        0x91C0, # G+8347  U+91C0  uni91C0,  CJK UNIFIED IDEOGRAPH-91C0
        0x2FC3, # G+8348  U+2FC3  uni2FC3,  KANGXI RADICAL BIRD
        0x8076, # G+8349  U+8076  uni8076,  CJK UNIFIED IDEOGRAPH-8076
        0x5699, # G+8350  U+5699  uni5699,  CJK UNIFIED IDEOGRAPH-5699
        0x9477, # G+8351  U+9477  uni9477,  CJK UNIFIED IDEOGRAPH-9477
        0x93B3, # G+8352  U+93B3  uni93B3,  CJK UNIFIED IDEOGRAPH-93B3
        0x6AB8, # G+8353  U+6AB8  uni6AB8,  CJK UNIFIED IDEOGRAPH-6AB8
        0x7370, # G+8354  U+7370  uni7370,  CJK UNIFIED IDEOGRAPH-7370
        0x5BE7, # G+8355  U+5BE7  uni5BE7,  CJK UNIFIED IDEOGRAPH-5BE7
        0x64F0, # G+8356  U+64F0  uni64F0,  CJK UNIFIED IDEOGRAPH-64F0
        0x6FD8, # G+8357  U+6FD8  uni6FD8,  CJK UNIFIED IDEOGRAPH-6FD8
        0x9215, # G+8358  U+9215  uni9215,  CJK UNIFIED IDEOGRAPH-9215
        0x7D10, # G+8359  U+7D10  uni7D10,  CJK UNIFIED IDEOGRAPH-7D10
        0x81BF, # G+8360  U+81BF  uni81BF,  CJK UNIFIED IDEOGRAPH-81BF
        0x6FC3, # G+8361  U+6FC3  uni6FC3,  CJK UNIFIED IDEOGRAPH-6FC3
        0x8FB2, # G+8362  U+8FB2  uni8FB2,  CJK UNIFIED IDEOGRAPH-8FB2
        0x7627, # G+8363  U+7627  uni7627,  CJK UNIFIED IDEOGRAPH-7627
        0x8AFE, # G+8364  U+8AFE  uni8AFE,  CJK UNIFIED IDEOGRAPH-8AFE
        0x6B50, # G+8365  U+6B50  uni6B50,  CJK UNIFIED IDEOGRAPH-6B50
        0x9DD7, # G+8366  U+9DD7  uni9DD7,  CJK UNIFIED IDEOGRAPH-9DD7
        0x6BC6, # G+8367  U+6BC6  uni6BC6,  CJK UNIFIED IDEOGRAPH-6BC6
        0x5614, # G+8368  U+5614  uni5614,  CJK UNIFIED IDEOGRAPH-5614
        0x6F1A, # G+8369  U+6F1A  uni6F1A,  CJK UNIFIED IDEOGRAPH-6F1A
        0x76E4, # G+8370  U+76E4  uni76E4,  CJK UNIFIED IDEOGRAPH-76E4
        0x9F90, # G+8371  U+9F90  uni9F90,  CJK UNIFIED IDEOGRAPH-9F90
        0x8CE0, # G+8372  U+8CE0  uni8CE0,  CJK UNIFIED IDEOGRAPH-8CE0
        0x5674, # G+8373  U+5674  uni5674,  CJK UNIFIED IDEOGRAPH-5674
        0x9D6C, # G+8374  U+9D6C  uni9D6C,  CJK UNIFIED IDEOGRAPH-9D6C
        0x9A19, # G+8375  U+9A19  uni9A19,  CJK UNIFIED IDEOGRAPH-9A19
        0x98C4, # G+8376  U+98C4  uni98C4,  CJK UNIFIED IDEOGRAPH-98C4
        0x983B, # G+8377  U+983B  uni983B,  CJK UNIFIED IDEOGRAPH-983B
        0x8CA7, # G+8378  U+8CA7  uni8CA7,  CJK UNIFIED IDEOGRAPH-8CA7
        0x860B, # G+8379  U+860B  uni860B,  CJK UNIFIED IDEOGRAPH-860B
        0x6191, # G+8380  U+6191  uni6191,  CJK UNIFIED IDEOGRAPH-6191
        0x8A55, # G+8381  U+8A55  uni8A55,  CJK UNIFIED IDEOGRAPH-8A55
        0x6F51, # G+8382  U+6F51  uni6F51,  CJK UNIFIED IDEOGRAPH-6F51
        0x9817, # G+8383  U+9817  uni9817,  CJK UNIFIED IDEOGRAPH-9817
        0x64B2, # G+8384  U+64B2  uni64B2,  CJK UNIFIED IDEOGRAPH-64B2
        0x92EA, # G+8385  U+92EA  uni92EA,  CJK UNIFIED IDEOGRAPH-92EA
        0x50D5, # G+8386  U+50D5  uni50D5,  CJK UNIFIED IDEOGRAPH-50D5
        0x6A38, # G+8387  U+6A38  uni6A38,  CJK UNIFIED IDEOGRAPH-6A38
        0x8B5C, # G+8388  U+8B5C  uni8B5C,  CJK UNIFIED IDEOGRAPH-8B5C
        0x81CD, # G+8389  U+81CD  uni81CD,  CJK UNIFIED IDEOGRAPH-81CD
        0x2FD1, # G+8390  U+2FD1  uni2FD1,  KANGXI RADICAL EVEN
        0x9A0E, # G+8391  U+9A0E  uni9A0E,  CJK UNIFIED IDEOGRAPH-9A0E
        0x8C48, # G+8392  U+8C48  uni8C48,  CJK UNIFIED IDEOGRAPH-8C48
        0x5553, # G+8393  U+5553  uni5553,  CJK UNIFIED IDEOGRAPH-5553
        0x6C23, # G+8394  U+6C23  uni6C23,  CJK UNIFIED IDEOGRAPH-6C23
        0x8A16, # G+8395  U+8A16  uni8A16,  CJK UNIFIED IDEOGRAPH-8A16
        0x727D, # G+8396  U+727D  uni727D,  CJK UNIFIED IDEOGRAPH-727D
        0x91FA, # G+8397  U+91FA  uni91FA,  CJK UNIFIED IDEOGRAPH-91FA
        0x925B, # G+8398  U+925B  uni925B,  CJK UNIFIED IDEOGRAPH-925B
        0x9077, # G+8399  U+9077  uni9077,  CJK UNIFIED IDEOGRAPH-9077
        0x7C3D, # G+8400  U+7C3D  uni7C3D,  CJK UNIFIED IDEOGRAPH-7C3D
        0x8B19, # G+8401  U+8B19  uni8B19,  CJK UNIFIED IDEOGRAPH-8B19
        0x9322, # G+8402  U+9322  uni9322,  CJK UNIFIED IDEOGRAPH-9322
        0x9257, # G+8403  U+9257  uni9257,  CJK UNIFIED IDEOGRAPH-9257
        0x6DFA, # G+8404  U+6DFA  uni6DFA,  CJK UNIFIED IDEOGRAPH-6DFA
        0x8B74, # G+8405  U+8B74  uni8B74,  CJK UNIFIED IDEOGRAPH-8B74
        0x5879, # G+8406  U+5879  uni5879,  CJK UNIFIED IDEOGRAPH-5879
        0x69CD, # G+8407  U+69CD  uni69CD,  CJK UNIFIED IDEOGRAPH-69CD
        0x55C6, # G+8408  U+55C6  uni55C6,  CJK UNIFIED IDEOGRAPH-55C6
        0x58BB, # G+8409  U+58BB  uni58BB,  CJK UNIFIED IDEOGRAPH-58BB
        0x8594, # G+8410  U+8594  uni8594,  CJK UNIFIED IDEOGRAPH-8594
        0x6436, # G+8411  U+6436  uni6436,  CJK UNIFIED IDEOGRAPH-6436
        0x936C, # G+8412  U+936C  uni936C,  CJK UNIFIED IDEOGRAPH-936C
        0x6A4B, # G+8413  U+6A4B  uni6A4B,  CJK UNIFIED IDEOGRAPH-6A4B
        0x55AC, # G+8414  U+55AC  uni55AC,  CJK UNIFIED IDEOGRAPH-55AC
        0x50D1, # G+8415  U+50D1  uni50D1,  CJK UNIFIED IDEOGRAPH-50D1
        0x7FF9, # G+8416  U+7FF9  uni7FF9,  CJK UNIFIED IDEOGRAPH-7FF9
        0x7AC5, # G+8417  U+7AC5  uni7AC5,  CJK UNIFIED IDEOGRAPH-7AC5
        0x7ACA, # G+8418  U+7ACA  uni7ACA,  CJK UNIFIED IDEOGRAPH-7ACA
        0x6B3D, # G+8419  U+6B3D  uni6B3D,  CJK UNIFIED IDEOGRAPH-6B3D
        0x89AA, # G+8420  U+89AA  uni89AA,  CJK UNIFIED IDEOGRAPH-89AA
        0x5BE2, # G+8421  U+5BE2  uni5BE2,  CJK UNIFIED IDEOGRAPH-5BE2
        0x8F15, # G+8422  U+8F15  uni8F15,  CJK UNIFIED IDEOGRAPH-8F15
        0x6C2B, # G+8423  U+6C2B  uni6C2B,  CJK UNIFIED IDEOGRAPH-6C2B
        0x50BE, # G+8424  U+50BE  uni50BE,  CJK UNIFIED IDEOGRAPH-50BE
        0x9803, # G+8425  U+9803  uni9803,  CJK UNIFIED IDEOGRAPH-9803
        0x8ACB, # G+8426  U+8ACB  uni8ACB,  CJK UNIFIED IDEOGRAPH-8ACB
        0x6176, # G+8427  U+6176  uni6176,  CJK UNIFIED IDEOGRAPH-6176
        0x74CA, # G+8428  U+74CA  uni74CA,  CJK UNIFIED IDEOGRAPH-74CA
        0x7AAE, # G+8429  U+7AAE  uni7AAE,  CJK UNIFIED IDEOGRAPH-7AAE
        0x8DA8, # G+8430  U+8DA8  uni8DA8,  CJK UNIFIED IDEOGRAPH-8DA8
        0x5340, # G+8431  U+5340  uni5340,  CJK UNIFIED IDEOGRAPH-5340
        0x8EC0, # G+8432  U+8EC0  uni8EC0,  CJK UNIFIED IDEOGRAPH-8EC0
        0x9A45, # G+8433  U+9A45  uni9A45,  CJK UNIFIED IDEOGRAPH-9A45
        0x9F72, # G+8434  U+9F72  uni9F72,  CJK UNIFIED IDEOGRAPH-9F72
        0x9874, # G+8435  U+9874  uni9874,  CJK UNIFIED IDEOGRAPH-9874
        0x6B0A, # G+8436  U+6B0A  uni6B0A,  CJK UNIFIED IDEOGRAPH-6B0A
        0x52F8, # G+8437  U+52F8  uni52F8,  CJK UNIFIED IDEOGRAPH-52F8
        0x9D72, # G+8438  U+9D72  uni9D72,  CJK UNIFIED IDEOGRAPH-9D72
        0x78BA, # G+8439  U+78BA  uni78BA,  CJK UNIFIED IDEOGRAPH-78BA
        0x8B93, # G+8440  U+8B93  uni8B93,  CJK UNIFIED IDEOGRAPH-8B93
        0x9952, # G+8441  U+9952  uni9952,  CJK UNIFIED IDEOGRAPH-9952
        0x64FE, # G+8442  U+64FE  uni64FE,  CJK UNIFIED IDEOGRAPH-64FE
        0x7E5E, # G+8443  U+7E5E  uni7E5E,  CJK UNIFIED IDEOGRAPH-7E5E
        0x71B1, # G+8444  U+71B1  uni71B1,  CJK UNIFIED IDEOGRAPH-71B1
        0x97CC, # G+8445  U+97CC  uni97CC,  CJK UNIFIED IDEOGRAPH-97CC
        0x8A8D, # G+8446  U+8A8D  uni8A8D,  CJK UNIFIED IDEOGRAPH-8A8D
        0x7D09, # G+8447  U+7D09  uni7D09,  CJK UNIFIED IDEOGRAPH-7D09
        0x69AE, # G+8448  U+69AE  uni69AE,  CJK UNIFIED IDEOGRAPH-69AE
        0x7D68, # G+8449  U+7D68  uni7D68,  CJK UNIFIED IDEOGRAPH-7D68
        0x8EDF, # G+8450  U+8EDF  uni8EDF,  CJK UNIFIED IDEOGRAPH-8EDF
        0x92ED, # G+8451  U+92ED  uni92ED,  CJK UNIFIED IDEOGRAPH-92ED
        0x958F, # G+8452  U+958F  uni958F,  CJK UNIFIED IDEOGRAPH-958F
        0x6F64, # G+8453  U+6F64  uni6F64,  CJK UNIFIED IDEOGRAPH-6F64
        0x7051, # G+8454  U+7051  uni7051,  CJK UNIFIED IDEOGRAPH-7051
        0x85A9, # G+8455  U+85A9  uni85A9,  CJK UNIFIED IDEOGRAPH-85A9
        0x9C13, # G+8456  U+9C13  uni9C13,  CJK UNIFIED IDEOGRAPH-9C13
        0x8CFD, # G+8457  U+8CFD  uni8CFD,  CJK UNIFIED IDEOGRAPH-8CFD
        0x5098, # G+8458  U+5098  uni5098,  CJK UNIFIED IDEOGRAPH-5098
        0x55AA, # G+8459  U+55AA  uni55AA,  CJK UNIFIED IDEOGRAPH-55AA
        0x9A37, # G+8460  U+9A37  uni9A37,  CJK UNIFIED IDEOGRAPH-9A37
        0x6383, # G+8461  U+6383  uni6383,  CJK UNIFIED IDEOGRAPH-6383
        0x6F80, # G+8462  U+6F80  uni6F80,  CJK UNIFIED IDEOGRAPH-6F80
        0x6BBA, # G+8463  U+6BBA  uni6BBA,  CJK UNIFIED IDEOGRAPH-6BBA
        0x7D17, # G+8464  U+7D17  uni7D17,  CJK UNIFIED IDEOGRAPH-7D17
        0x7BE9, # G+8465  U+7BE9  uni7BE9,  CJK UNIFIED IDEOGRAPH-7BE9
        0x66EC, # G+8466  U+66EC  uni66EC,  CJK UNIFIED IDEOGRAPH-66EC
        0x9583, # G+8467  U+9583  uni9583,  CJK UNIFIED IDEOGRAPH-9583
        0x965D, # G+8468  U+965D  uni965D,  CJK UNIFIED IDEOGRAPH-965D
        0x8D0D, # G+8469  U+8D0D  uni8D0D,  CJK UNIFIED IDEOGRAPH-8D0D
        0x7E55, # G+8470  U+7E55  uni7E55,  CJK UNIFIED IDEOGRAPH-7E55
        0x50B7, # G+8471  U+50B7  uni50B7,  CJK UNIFIED IDEOGRAPH-50B7
        0x8CDE, # G+8472  U+8CDE  uni8CDE,  CJK UNIFIED IDEOGRAPH-8CDE
        0x71D2, # G+8473  U+71D2  uni71D2,  CJK UNIFIED IDEOGRAPH-71D2
        0x7D39, # G+8474  U+7D39  uni7D39,  CJK UNIFIED IDEOGRAPH-7D39
        0x8CD2, # G+8475  U+8CD2  uni8CD2,  CJK UNIFIED IDEOGRAPH-8CD2
        0x6368, # G+8476  U+6368  uni6368,  CJK UNIFIED IDEOGRAPH-6368
        0x651D, # G+8477  U+651D  uni651D,  CJK UNIFIED IDEOGRAPH-651D
        0x61FE, # G+8478  U+61FE  uni61FE,  CJK UNIFIED IDEOGRAPH-61FE
        0x8A2D, # G+8479  U+8A2D  uni8A2D,  CJK UNIFIED IDEOGRAPH-8A2D
        0x7D33, # G+8480  U+7D33  uni7D33,  CJK UNIFIED IDEOGRAPH-7D33
        0x5BE9, # G+8481  U+5BE9  uni5BE9,  CJK UNIFIED IDEOGRAPH-5BE9
        0x5B38, # G+8482  U+5B38  uni5B38,  CJK UNIFIED IDEOGRAPH-5B38
        0x814E, # G+8483  U+814E  uni814E,  CJK UNIFIED IDEOGRAPH-814E
        0x6EF2, # G+8484  U+6EF2  uni6EF2,  CJK UNIFIED IDEOGRAPH-6EF2
        0x8072, # G+8485  U+8072  uni8072,  CJK UNIFIED IDEOGRAPH-8072
        0x7E69, # G+8486  U+7E69  uni7E69,  CJK UNIFIED IDEOGRAPH-7E69
        0x52DD, # G+8487  U+52DD  uni52DD,  CJK UNIFIED IDEOGRAPH-52DD
        0x8056, # G+8488  U+8056  uni8056,  CJK UNIFIED IDEOGRAPH-8056
        0x5E2B, # G+8489  U+5E2B  uni5E2B,  CJK UNIFIED IDEOGRAPH-5E2B
        0x7345, # G+8490  U+7345  uni7345,  CJK UNIFIED IDEOGRAPH-7345
        0x6FD5, # G+8491  U+6FD5  uni6FD5,  CJK UNIFIED IDEOGRAPH-6FD5
        0x8A69, # G+8492  U+8A69  uni8A69,  CJK UNIFIED IDEOGRAPH-8A69
        0x6642, # G+8493  U+6642  uni6642,  CJK UNIFIED IDEOGRAPH-6642
        0x8755, # G+8494  U+8755  uni8755,  CJK UNIFIED IDEOGRAPH-8755
        0x5BE6, # G+8495  U+5BE6  uni5BE6,  CJK UNIFIED IDEOGRAPH-5BE6
        0x8B58, # G+8496  U+8B58  uni8B58,  CJK UNIFIED IDEOGRAPH-8B58
        0x99DB, # G+8497  U+99DB  uni99DB,  CJK UNIFIED IDEOGRAPH-99DB
        0x52E2, # G+8498  U+52E2  uni52E2,  CJK UNIFIED IDEOGRAPH-52E2
        0x9069, # G+8499  U+9069  uni9069,  CJK UNIFIED IDEOGRAPH-9069
        0x91CB, # G+8500  U+91CB  uni91CB,  CJK UNIFIED IDEOGRAPH-91CB
        0x98FE, # G+8501  U+98FE  uni98FE,  CJK UNIFIED IDEOGRAPH-98FE
        0x8996, # G+8502  U+8996  uni8996,  CJK UNIFIED IDEOGRAPH-8996
        0x8A66, # G+8503  U+8A66  uni8A66,  CJK UNIFIED IDEOGRAPH-8A66
        0x58FD, # G+8504  U+58FD  uni58FD,  CJK UNIFIED IDEOGRAPH-58FD
        0x7378, # G+8505  U+7378  uni7378,  CJK UNIFIED IDEOGRAPH-7378
        0x6A1E, # G+8506  U+6A1E  uni6A1E,  CJK UNIFIED IDEOGRAPH-6A1E
        0x8F38, # G+8507  U+8F38  uni8F38,  CJK UNIFIED IDEOGRAPH-8F38
        0x66F8, # G+8508  U+66F8  uni66F8,  CJK UNIFIED IDEOGRAPH-66F8
        0x8D16, # G+8509  U+8D16  uni8D16,  CJK UNIFIED IDEOGRAPH-8D16
        0x5C6C, # G+8510  U+5C6C  uni5C6C,  CJK UNIFIED IDEOGRAPH-5C6C
        0x8853, # G+8511  U+8853  uni8853,  CJK UNIFIED IDEOGRAPH-8853
        0x6A39, # G+8512  U+6A39  uni6A39,  CJK UNIFIED IDEOGRAPH-6A39
        0x7AEA, # G+8513  U+7AEA  uni7AEA,  CJK UNIFIED IDEOGRAPH-7AEA
        0x6578, # G+8514  U+6578  uni6578,  CJK UNIFIED IDEOGRAPH-6578
        0x5E25, # G+8515  U+5E25  uni5E25,  CJK UNIFIED IDEOGRAPH-5E25
        0x96D9, # G+8516  U+96D9  uni96D9,  CJK UNIFIED IDEOGRAPH-96D9
        0x8AB0, # G+8517  U+8AB0  uni8AB0,  CJK UNIFIED IDEOGRAPH-8AB0
        0x9806, # G+8518  U+9806  uni9806,  CJK UNIFIED IDEOGRAPH-9806
        0x8AAC, # G+8519  U+8AAC  uni8AAC,  CJK UNIFIED IDEOGRAPH-8AAC
        0x78A9, # G+8520  U+78A9  uni78A9,  CJK UNIFIED IDEOGRAPH-78A9
        0x720D, # G+8521  U+720D  uni720D,  CJK UNIFIED IDEOGRAPH-720D
        0x7D72, # G+8522  U+7D72  uni7D72,  CJK UNIFIED IDEOGRAPH-7D72
        0x98FC, # G+8523  U+98FC  uni98FC,  CJK UNIFIED IDEOGRAPH-98FC
        0x9B06, # G+8524  U+9B06  uni9B06,  CJK UNIFIED IDEOGRAPH-9B06
        0x8073, # G+8525  U+8073  uni8073,  CJK UNIFIED IDEOGRAPH-8073
        0x616B, # G+8526  U+616B  uni616B,  CJK UNIFIED IDEOGRAPH-616B
        0x980C, # G+8527  U+980C  uni980C,  CJK UNIFIED IDEOGRAPH-980C
        0x8A1F, # G+8528  U+8A1F  uni8A1F,  CJK UNIFIED IDEOGRAPH-8A1F
        0x8AA6, # G+8529  U+8AA6  uni8AA6,  CJK UNIFIED IDEOGRAPH-8AA6
        0x64FB, # G+8530  U+64FB  uni64FB,  CJK UNIFIED IDEOGRAPH-64FB
        0x8607, # G+8531  U+8607  uni8607,  CJK UNIFIED IDEOGRAPH-8607
        0x8A34, # G+8532  U+8A34  uni8A34,  CJK UNIFIED IDEOGRAPH-8A34
        0x8085, # G+8533  U+8085  uni8085,  CJK UNIFIED IDEOGRAPH-8085
        0x96D6, # G+8534  U+96D6  uni96D6,  CJK UNIFIED IDEOGRAPH-96D6
        0x96A8, # G+8535  U+96A8  uni96A8,  CJK UNIFIED IDEOGRAPH-96A8
        0x7D8F, # G+8536  U+7D8F  uni7D8F,  CJK UNIFIED IDEOGRAPH-7D8F
        0x6B72, # G+8537  U+6B72  uni6B72,  CJK UNIFIED IDEOGRAPH-6B72
        0x5B6B, # G+8538  U+5B6B  uni5B6B,  CJK UNIFIED IDEOGRAPH-5B6B
        0x640D, # G+8539  U+640D  uni640D,  CJK UNIFIED IDEOGRAPH-640D
        0x7E2E, # G+8540  U+7E2E  uni7E2E,  CJK UNIFIED IDEOGRAPH-7E2E
        0x7463, # G+8541  U+7463  uni7463,  CJK UNIFIED IDEOGRAPH-7463
        0x9396, # G+8542  U+9396  uni9396,  CJK UNIFIED IDEOGRAPH-9396
        0x737A, # G+8543  U+737A  uni737A,  CJK UNIFIED IDEOGRAPH-737A
        0x64BB, # G+8544  U+64BB  uni64BB,  CJK UNIFIED IDEOGRAPH-64BB
        0x81FA, # G+8545  U+81FA  uni81FA,  CJK UNIFIED IDEOGRAPH-81FA
        0x614B, # G+8546  U+614B  uni614B,  CJK UNIFIED IDEOGRAPH-614B
        0x6524, # G+8547  U+6524  uni6524,  CJK UNIFIED IDEOGRAPH-6524
        0x8CAA, # G+8548  U+8CAA  uni8CAA,  CJK UNIFIED IDEOGRAPH-8CAA
        0x7671, # G+8549  U+7671  uni7671,  CJK UNIFIED IDEOGRAPH-7671
        0x7058, # G+8550  U+7058  uni7058,  CJK UNIFIED IDEOGRAPH-7058
        0x58C7, # G+8551  U+58C7  uni58C7,  CJK UNIFIED IDEOGRAPH-58C7
        0x8B5A, # G+8552  U+8B5A  uni8B5A,  CJK UNIFIED IDEOGRAPH-8B5A
        0x8AC7, # G+8553  U+8AC7  uni8AC7,  CJK UNIFIED IDEOGRAPH-8AC7
        0x5606, # G+8554  U+5606  uni5606,  CJK UNIFIED IDEOGRAPH-5606
        0x6E6F, # G+8555  U+6E6F  uni6E6F,  CJK UNIFIED IDEOGRAPH-6E6F
        0x71D9, # G+8556  U+71D9  uni71D9,  CJK UNIFIED IDEOGRAPH-71D9
        0x6FE4, # G+8557  U+6FE4  uni6FE4,  CJK UNIFIED IDEOGRAPH-6FE4
        0x7E27, # G+8558  U+7E27  uni7E27,  CJK UNIFIED IDEOGRAPH-7E27
        0x8A0E, # G+8559  U+8A0E  uni8A0E,  CJK UNIFIED IDEOGRAPH-8A0E
        0x9A30, # G+8560  U+9A30  uni9A30,  CJK UNIFIED IDEOGRAPH-9A30
        0x8B04, # G+8561  U+8B04  uni8B04,  CJK UNIFIED IDEOGRAPH-8B04
        0x92BB, # G+8562  U+92BB  uni92BB,  CJK UNIFIED IDEOGRAPH-92BB
        0x984C, # G+8563  U+984C  uni984C,  CJK UNIFIED IDEOGRAPH-984C
        0x9AD4, # G+8564  U+9AD4  uni9AD4,  CJK UNIFIED IDEOGRAPH-9AD4
        0x689D, # G+8565  U+689D  uni689D,  CJK UNIFIED IDEOGRAPH-689D
        0x8CBC, # G+8566  U+8CBC  uni8CBC,  CJK UNIFIED IDEOGRAPH-8CBC
        0x9435, # G+8567  U+9435  uni9435,  CJK UNIFIED IDEOGRAPH-9435
        0x5EF3, # G+8568  U+5EF3  uni5EF3,  CJK UNIFIED IDEOGRAPH-5EF3
        0x807D, # G+8569  U+807D  uni807D,  CJK UNIFIED IDEOGRAPH-807D
        0x70F4, # G+8570  U+70F4  uni70F4,  CJK UNIFIED IDEOGRAPH-70F4
        0x9285, # G+8571  U+9285  uni9285,  CJK UNIFIED IDEOGRAPH-9285
        0x7D71, # G+8572  U+7D71  uni7D71,  CJK UNIFIED IDEOGRAPH-7D71
        0x982D, # G+8573  U+982D  uni982D,  CJK UNIFIED IDEOGRAPH-982D
        0x5716, # G+8574  U+5716  uni5716,  CJK UNIFIED IDEOGRAPH-5716
        0x5857, # G+8575  U+5857  uni5857,  CJK UNIFIED IDEOGRAPH-5857
        0x5718, # G+8576  U+5718  uni5718,  CJK UNIFIED IDEOGRAPH-5718
        0x983D, # G+8577  U+983D  uni983D,  CJK UNIFIED IDEOGRAPH-983D
        0x9D15, # G+8578  U+9D15  uni9D15,  CJK UNIFIED IDEOGRAPH-9D15
        0x99B1, # G+8579  U+99B1  uni99B1,  CJK UNIFIED IDEOGRAPH-99B1
        0x99DD, # G+8580  U+99DD  uni99DD,  CJK UNIFIED IDEOGRAPH-99DD
        0x6A62, # G+8581  U+6A62  uni6A62,  CJK UNIFIED IDEOGRAPH-6A62
        0x7AAA, # G+8582  U+7AAA  uni7AAA,  CJK UNIFIED IDEOGRAPH-7AAA
        0x896A, # G+8583  U+896A  uni896A,  CJK UNIFIED IDEOGRAPH-896A
        0x5F4E, # G+8584  U+5F4E  uni5F4E,  CJK UNIFIED IDEOGRAPH-5F4E
        0x7063, # G+8585  U+7063  uni7063,  CJK UNIFIED IDEOGRAPH-7063
        0x9811, # G+8586  U+9811  uni9811,  CJK UNIFIED IDEOGRAPH-9811
        0x842C, # G+8587  U+842C  uni842C,  CJK UNIFIED IDEOGRAPH-842C
        0x7DB2, # G+8588  U+7DB2  uni7DB2,  CJK UNIFIED IDEOGRAPH-7DB2
        0x2FB1, # G+8589  U+2FB1  uni2FB1,  KANGXI RADICAL TANNED LEATHER
        0x9055, # G+8590  U+9055  uni9055,  CJK UNIFIED IDEOGRAPH-9055
        0x570D, # G+8591  U+570D  uni570D,  CJK UNIFIED IDEOGRAPH-570D
        0x7232, # G+8592  U+7232  uni7232,  CJK UNIFIED IDEOGRAPH-7232
        0x6FF0, # G+8593  U+6FF0  uni6FF0,  CJK UNIFIED IDEOGRAPH-6FF0
        0x7DAD, # G+8594  U+7DAD  uni7DAD,  CJK UNIFIED IDEOGRAPH-7DAD
        0x8466, # G+8595  U+8466  uni8466,  CJK UNIFIED IDEOGRAPH-8466
        0x5049, # G+8596  U+5049  uni5049,  CJK UNIFIED IDEOGRAPH-5049
        0x50DE, # G+8597  U+50DE  uni50DE,  CJK UNIFIED IDEOGRAPH-50DE
        0x7DEF, # G+8598  U+7DEF  uni7DEF,  CJK UNIFIED IDEOGRAPH-7DEF
        0x8B02, # G+8599  U+8B02  uni8B02,  CJK UNIFIED IDEOGRAPH-8B02
        0x885B, # G+8600  U+885B  uni885B,  CJK UNIFIED IDEOGRAPH-885B
        0x805E, # G+8601  U+805E  uni805E,  CJK UNIFIED IDEOGRAPH-805E
        0x7D0B, # G+8602  U+7D0B  uni7D0B,  CJK UNIFIED IDEOGRAPH-7D0B
        0x7A69, # G+8603  U+7A69  uni7A69,  CJK UNIFIED IDEOGRAPH-7A69
        0x554F, # G+8604  U+554F  uni554F,  CJK UNIFIED IDEOGRAPH-554F
        0x64BE, # G+8605  U+64BE  uni64BE,  CJK UNIFIED IDEOGRAPH-64BE
        0x8778, # G+8606  U+8778  uni8778,  CJK UNIFIED IDEOGRAPH-8778
        0x6E26, # G+8607  U+6E26  uni6E26,  CJK UNIFIED IDEOGRAPH-6E26
        0x7AA9, # G+8608  U+7AA9  uni7AA9,  CJK UNIFIED IDEOGRAPH-7AA9
        0x55DA, # G+8609  U+55DA  uni55DA,  CJK UNIFIED IDEOGRAPH-55DA
        0x93A2, # G+8610  U+93A2  uni93A2,  CJK UNIFIED IDEOGRAPH-93A2
        0x70CF, # G+8611  U+70CF  uni70CF,  CJK UNIFIED IDEOGRAPH-70CF
        0x8AA3, # G+8612  U+8AA3  uni8AA3,  CJK UNIFIED IDEOGRAPH-8AA3
        0x7121, # G+8613  U+7121  uni7121,  CJK UNIFIED IDEOGRAPH-7121
        0x856A, # G+8614  U+856A  uni856A,  CJK UNIFIED IDEOGRAPH-856A
        0x5862, # G+8615  U+5862  uni5862,  CJK UNIFIED IDEOGRAPH-5862
        0x9727, # G+8616  U+9727  uni9727,  CJK UNIFIED IDEOGRAPH-9727
        0x52D9, # G+8617  U+52D9  uni52D9,  CJK UNIFIED IDEOGRAPH-52D9
        0x8AA4, # G+8618  U+8AA4  uni8AA4,  CJK UNIFIED IDEOGRAPH-8AA4
        0x932B, # G+8619  U+932B  uni932B,  CJK UNIFIED IDEOGRAPH-932B
        0x72A7, # G+8620  U+72A7  uni72A7,  CJK UNIFIED IDEOGRAPH-72A7
        0x8972, # G+8621  U+8972  uni8972,  CJK UNIFIED IDEOGRAPH-8972
        0x7FD2, # G+8622  U+7FD2  uni7FD2,  CJK UNIFIED IDEOGRAPH-7FD2
        0x9291, # G+8623  U+9291  uni9291,  CJK UNIFIED IDEOGRAPH-9291
        0x6232, # G+8624  U+6232  uni6232,  CJK UNIFIED IDEOGRAPH-6232
        0x7D30, # G+8625  U+7D30  uni7D30,  CJK UNIFIED IDEOGRAPH-7D30
        0x8766, # G+8626  U+8766  uni8766,  CJK UNIFIED IDEOGRAPH-8766
        0x8F44, # G+8627  U+8F44  uni8F44,  CJK UNIFIED IDEOGRAPH-8F44
        0x5CFD, # G+8628  U+5CFD  uni5CFD,  CJK UNIFIED IDEOGRAPH-5CFD
        0x4FE0, # G+8629  U+4FE0  uni4FE0,  CJK UNIFIED IDEOGRAPH-4FE0
        0x72F9, # G+8630  U+72F9  uni72F9,  CJK UNIFIED IDEOGRAPH-72F9
        0x5687, # G+8631  U+5687  uni5687,  CJK UNIFIED IDEOGRAPH-5687
        0x9341, # G+8632  U+9341  uni9341,  CJK UNIFIED IDEOGRAPH-9341
        0x9BAE, # G+8633  U+9BAE  uni9BAE,  CJK UNIFIED IDEOGRAPH-9BAE
        0x7E96, # G+8634  U+7E96  uni7E96,  CJK UNIFIED IDEOGRAPH-7E96
        0x8CE2, # G+8635  U+8CE2  uni8CE2,  CJK UNIFIED IDEOGRAPH-8CE2
        0x929C, # G+8636  U+929C  uni929C,  CJK UNIFIED IDEOGRAPH-929C
        0x9591, # G+8637  U+9591  uni9591,  CJK UNIFIED IDEOGRAPH-9591
        0x986F, # G+8638  U+986F  uni986F,  CJK UNIFIED IDEOGRAPH-986F
        0x96AA, # G+8639  U+96AA  uni96AA,  CJK UNIFIED IDEOGRAPH-96AA
        0x73FE, # G+8640  U+73FE  uni73FE,  CJK UNIFIED IDEOGRAPH-73FE
        0x737B, # G+8641  U+737B  uni737B,  CJK UNIFIED IDEOGRAPH-737B
        0x7E23, # G+8642  U+7E23  uni7E23,  CJK UNIFIED IDEOGRAPH-7E23
        0x9921, # G+8643  U+9921  uni9921,  CJK UNIFIED IDEOGRAPH-9921
        0x61B2, # G+8644  U+61B2  uni61B2,  CJK UNIFIED IDEOGRAPH-61B2
        0x7DAB, # G+8645  U+7DAB  uni7DAB,  CJK UNIFIED IDEOGRAPH-7DAB
        0x9472, # G+8646  U+9472  uni9472,  CJK UNIFIED IDEOGRAPH-9472
        0x9109, # G+8647  U+9109  uni9109,  CJK UNIFIED IDEOGRAPH-9109
        0x8A73, # G+8648  U+8A73  uni8A73,  CJK UNIFIED IDEOGRAPH-8A73
        0x97FF, # G+8649  U+97FF  uni97FF,  CJK UNIFIED IDEOGRAPH-97FF
        0x9805, # G+8650  U+9805  uni9805,  CJK UNIFIED IDEOGRAPH-9805
        0x856D, # G+8651  U+856D  uni856D,  CJK UNIFIED IDEOGRAPH-856D
        0x56C2, # G+8652  U+56C2  uni56C2,  CJK UNIFIED IDEOGRAPH-56C2
        0x92B7, # G+8653  U+92B7  uni92B7,  CJK UNIFIED IDEOGRAPH-92B7
        0x66C9, # G+8654  U+66C9  uni66C9,  CJK UNIFIED IDEOGRAPH-66C9
        0x562F, # G+8655  U+562F  uni562F,  CJK UNIFIED IDEOGRAPH-562F
        0x5354, # G+8656  U+5354  uni5354,  CJK UNIFIED IDEOGRAPH-5354
        0x633E, # G+8657  U+633E  uni633E,  CJK UNIFIED IDEOGRAPH-633E
        0x8105, # G+8658  U+8105  uni8105,  CJK UNIFIED IDEOGRAPH-8105
        0x8AE7, # G+8659  U+8AE7  uni8AE7,  CJK UNIFIED IDEOGRAPH-8AE7
        0x5BEB, # G+8660  U+5BEB  uni5BEB,  CJK UNIFIED IDEOGRAPH-5BEB
        0x7009, # G+8661  U+7009  uni7009,  CJK UNIFIED IDEOGRAPH-7009
        0x8B1D, # G+8662  U+8B1D  uni8B1D,  CJK UNIFIED IDEOGRAPH-8B1D
        0x92C5, # G+8663  U+92C5  uni92C5,  CJK UNIFIED IDEOGRAPH-92C5
        0x91C1, # G+8664  U+91C1  uni91C1,  CJK UNIFIED IDEOGRAPH-91C1
        0x8208, # G+8665  U+8208  uni8208,  CJK UNIFIED IDEOGRAPH-8208
        0x92B9, # G+8666  U+92B9  uni92B9,  CJK UNIFIED IDEOGRAPH-92B9
        0x7D89, # G+8667  U+7D89  uni7D89,  CJK UNIFIED IDEOGRAPH-7D89
        0x9808, # G+8668  U+9808  uni9808,  CJK UNIFIED IDEOGRAPH-9808
        0x8A31, # G+8669  U+8A31  uni8A31,  CJK UNIFIED IDEOGRAPH-8A31
        0x7DD2, # G+8670  U+7DD2  uni7DD2,  CJK UNIFIED IDEOGRAPH-7DD2
        0x7E8C, # G+8671  U+7E8C  uni7E8C,  CJK UNIFIED IDEOGRAPH-7E8C
        0x8ED2, # G+8672  U+8ED2  uni8ED2,  CJK UNIFIED IDEOGRAPH-8ED2
        0x61F8, # G+8673  U+61F8  uni61F8,  CJK UNIFIED IDEOGRAPH-61F8
        0x9078, # G+8674  U+9078  uni9078,  CJK UNIFIED IDEOGRAPH-9078
        0x766C, # G+8675  U+766C  uni766C,  CJK UNIFIED IDEOGRAPH-766C
        0x7D62, # G+8676  U+7D62  uni7D62,  CJK UNIFIED IDEOGRAPH-7D62
        0x5B78, # G+8677  U+5B78  uni5B78,  CJK UNIFIED IDEOGRAPH-5B78
        0x52DB, # G+8678  U+52DB  uni52DB,  CJK UNIFIED IDEOGRAPH-52DB
        0x8A62, # G+8679  U+8A62  uni8A62,  CJK UNIFIED IDEOGRAPH-8A62
        0x5C0B, # G+8680  U+5C0B  uni5C0B,  CJK UNIFIED IDEOGRAPH-5C0B
        0x99B4, # G+8681  U+99B4  uni99B4,  CJK UNIFIED IDEOGRAPH-99B4
        0x8A13, # G+8682  U+8A13  uni8A13,  CJK UNIFIED IDEOGRAPH-8A13
        0x8A0A, # G+8683  U+8A0A  uni8A0A,  CJK UNIFIED IDEOGRAPH-8A0A
        0x905C, # G+8684  U+905C  uni905C,  CJK UNIFIED IDEOGRAPH-905C
        0x58D3, # G+8685  U+58D3  uni58D3,  CJK UNIFIED IDEOGRAPH-58D3
        0x9D09, # G+8686  U+9D09  uni9D09,  CJK UNIFIED IDEOGRAPH-9D09
        0x9D28, # G+8687  U+9D28  uni9D28,  CJK UNIFIED IDEOGRAPH-9D28
        0x555E, # G+8688  U+555E  uni555E,  CJK UNIFIED IDEOGRAPH-555E
        0x4E9E, # G+8689  U+4E9E  uni4E9E,  CJK UNIFIED IDEOGRAPH-4E9E
        0x8A1D, # G+8690  U+8A1D  uni8A1D,  CJK UNIFIED IDEOGRAPH-8A1D
        0x95B9, # G+8691  U+95B9  uni95B9,  CJK UNIFIED IDEOGRAPH-95B9
        0x9E7D, # G+8692  U+9E7D  uni9E7D,  CJK UNIFIED IDEOGRAPH-9E7D
        0x56B4, # G+8693  U+56B4  uni56B4,  CJK UNIFIED IDEOGRAPH-56B4
        0x9854, # G+8694  U+9854  uni9854,  CJK UNIFIED IDEOGRAPH-9854
        0x95BB, # G+8695  U+95BB  uni95BB,  CJK UNIFIED IDEOGRAPH-95BB
        0x8277, # G+8696  U+8277  uni8277,  CJK UNIFIED IDEOGRAPH-8277
        0x53AD, # G+8697  U+53AD  uni53AD,  CJK UNIFIED IDEOGRAPH-53AD
        0x786F, # G+8698  U+786F  uni786F,  CJK UNIFIED IDEOGRAPH-786F
        0x8AFA, # G+8699  U+8AFA  uni8AFA,  CJK UNIFIED IDEOGRAPH-8AFA
        0x9A57, # G+8700  U+9A57  uni9A57,  CJK UNIFIED IDEOGRAPH-9A57
        0x9D26, # G+8701  U+9D26  uni9D26,  CJK UNIFIED IDEOGRAPH-9D26
        0x694A, # G+8702  U+694A  uni694A,  CJK UNIFIED IDEOGRAPH-694A
        0x63DA, # G+8703  U+63DA  uni63DA,  CJK UNIFIED IDEOGRAPH-63DA
        0x760D, # G+8704  U+760D  uni760D,  CJK UNIFIED IDEOGRAPH-760D
        0x967D, # G+8705  U+967D  uni967D,  CJK UNIFIED IDEOGRAPH-967D
        0x7662, # G+8706  U+7662  uni7662,  CJK UNIFIED IDEOGRAPH-7662
        0x990A, # G+8707  U+990A  uni990A,  CJK UNIFIED IDEOGRAPH-990A
        0x6A23, # G+8708  U+6A23  uni6A23,  CJK UNIFIED IDEOGRAPH-6A23
        0x582F, # G+8709  U+582F  uni582F,  CJK UNIFIED IDEOGRAPH-582F
        0x8B21, # G+8710  U+8B21  uni8B21,  CJK UNIFIED IDEOGRAPH-8B21
        0x85E5, # G+8711  U+85E5  uni85E5,  CJK UNIFIED IDEOGRAPH-85E5
        0x723A, # G+8712  U+723A  uni723A,  CJK UNIFIED IDEOGRAPH-723A
        0x2FB4, # G+8713  U+2FB4  uni2FB4,  KANGXI RADICAL LEAF
        0x696D, # G+8714  U+696D  uni696D,  CJK UNIFIED IDEOGRAPH-696D
        0x8449, # G+8715  U+8449  uni8449,  CJK UNIFIED IDEOGRAPH-8449
        0x91AB, # G+8716  U+91AB  uni91AB,  CJK UNIFIED IDEOGRAPH-91AB
        0x92A5, # G+8717  U+92A5  uni92A5,  CJK UNIFIED IDEOGRAPH-92A5
        0x9824, # G+8718  U+9824  uni9824,  CJK UNIFIED IDEOGRAPH-9824
        0x907A, # G+8719  U+907A  uni907A,  CJK UNIFIED IDEOGRAPH-907A
        0x5100, # G+8720  U+5100  uni5100,  CJK UNIFIED IDEOGRAPH-5100
        0x87FB, # G+8721  U+87FB  uni87FB,  CJK UNIFIED IDEOGRAPH-87FB
        0x85DD, # G+8722  U+85DD  uni85DD,  CJK UNIFIED IDEOGRAPH-85DD
        0x5104, # G+8723  U+5104  uni5104,  CJK UNIFIED IDEOGRAPH-5104
        0x61B6, # G+8724  U+61B6  uni61B6,  CJK UNIFIED IDEOGRAPH-61B6
        0x7FA9, # G+8725  U+7FA9  uni7FA9,  CJK UNIFIED IDEOGRAPH-7FA9
        0x8A63, # G+8726  U+8A63  uni8A63,  CJK UNIFIED IDEOGRAPH-8A63
        0x8B70, # G+8727  U+8B70  uni8B70,  CJK UNIFIED IDEOGRAPH-8B70
        0x8ABC, # G+8728  U+8ABC  uni8ABC,  CJK UNIFIED IDEOGRAPH-8ABC
        0x8B6F, # G+8729  U+8B6F  uni8B6F,  CJK UNIFIED IDEOGRAPH-8B6F
        0x7E79, # G+8730  U+7E79  uni7E79,  CJK UNIFIED IDEOGRAPH-7E79
        0x852D, # G+8731  U+852D  uni852D,  CJK UNIFIED IDEOGRAPH-852D
        0x9670, # G+8732  U+9670  uni9670,  CJK UNIFIED IDEOGRAPH-9670
        0x9280, # G+8733  U+9280  uni9280,  CJK UNIFIED IDEOGRAPH-9280
        0x98F2, # G+8734  U+98F2  uni98F2,  CJK UNIFIED IDEOGRAPH-98F2
        0x96B1, # G+8735  U+96B1  uni96B1,  CJK UNIFIED IDEOGRAPH-96B1
        0x6AFB, # G+8736  U+6AFB  uni6AFB,  CJK UNIFIED IDEOGRAPH-6AFB
        0x5B30, # G+8737  U+5B30  uni5B30,  CJK UNIFIED IDEOGRAPH-5B30
        0x9DF9, # G+8738  U+9DF9  uni9DF9,  CJK UNIFIED IDEOGRAPH-9DF9
        0x61C9, # G+8739  U+61C9  uni61C9,  CJK UNIFIED IDEOGRAPH-61C9
        0x7E93, # G+8740  U+7E93  uni7E93,  CJK UNIFIED IDEOGRAPH-7E93
        0x7469, # G+8741  U+7469  uni7469,  CJK UNIFIED IDEOGRAPH-7469
        0x87A2, # G+8742  U+87A2  uni87A2,  CJK UNIFIED IDEOGRAPH-87A2
        0x71DF, # G+8743  U+71DF  uni71DF,  CJK UNIFIED IDEOGRAPH-71DF
        0x7192, # G+8744  U+7192  uni7192,  CJK UNIFIED IDEOGRAPH-7192
        0x8805, # G+8745  U+8805  uni8805,  CJK UNIFIED IDEOGRAPH-8805
        0x8D0F, # G+8746  U+8D0F  uni8D0F,  CJK UNIFIED IDEOGRAPH-8D0F
        0x7A4E, # G+8747  U+7A4E  uni7A4E,  CJK UNIFIED IDEOGRAPH-7A4E
        0x55B2, # G+8748  U+55B2  uni55B2,  CJK UNIFIED IDEOGRAPH-55B2
        0x64C1, # G+8749  U+64C1  uni64C1,  CJK UNIFIED IDEOGRAPH-64C1
        0x50AD, # G+8750  U+50AD  uni50AD,  CJK UNIFIED IDEOGRAPH-50AD
        0x7670, # G+8751  U+7670  uni7670,  CJK UNIFIED IDEOGRAPH-7670
        0x8E34, # G+8752  U+8E34  uni8E34,  CJK UNIFIED IDEOGRAPH-8E34
        0x512A, # G+8753  U+512A  uni512A,  CJK UNIFIED IDEOGRAPH-512A
        0x6182, # G+8754  U+6182  uni6182,  CJK UNIFIED IDEOGRAPH-6182
        0x90F5, # G+8755  U+90F5  uni90F5,  CJK UNIFIED IDEOGRAPH-90F5
        0x923E, # G+8756  U+923E  uni923E,  CJK UNIFIED IDEOGRAPH-923E
        0x7336, # G+8757  U+7336  uni7336,  CJK UNIFIED IDEOGRAPH-7336
        0x8A98, # G+8758  U+8A98  uni8A98,  CJK UNIFIED IDEOGRAPH-8A98
        0x8F3F, # G+8759  U+8F3F  uni8F3F,  CJK UNIFIED IDEOGRAPH-8F3F
        0x9918, # G+8760  U+9918  uni9918,  CJK UNIFIED IDEOGRAPH-9918
        0x2FC2, # G+8761  U+2FC2  uni2FC2,  KANGXI RADICAL FISH
        0x6F01, # G+8762  U+6F01  uni6F01,  CJK UNIFIED IDEOGRAPH-6F01
        0x8207, # G+8763  U+8207  uni8207,  CJK UNIFIED IDEOGRAPH-8207
        0x5DBC, # G+8764  U+5DBC  uni5DBC,  CJK UNIFIED IDEOGRAPH-5DBC
        0x8A9E, # G+8765  U+8A9E  uni8A9E,  CJK UNIFIED IDEOGRAPH-8A9E
        0x9B31, # G+8766  U+9B31  uni9B31,  CJK UNIFIED IDEOGRAPH-9B31
        0x7344, # G+8767  U+7344  uni7344,  CJK UNIFIED IDEOGRAPH-7344
        0x8B7D, # G+8768  U+8B7D  uni8B7D,  CJK UNIFIED IDEOGRAPH-8B7D
        0x9810, # G+8769  U+9810  uni9810,  CJK UNIFIED IDEOGRAPH-9810
        0x99AD, # G+8770  U+99AD  uni99AD,  CJK UNIFIED IDEOGRAPH-99AD
        0x9D1B, # G+8771  U+9D1B  uni9D1B,  CJK UNIFIED IDEOGRAPH-9D1B
        0x6DF5, # G+8772  U+6DF5  uni6DF5,  CJK UNIFIED IDEOGRAPH-6DF5
        0x8F45, # G+8773  U+8F45  uni8F45,  CJK UNIFIED IDEOGRAPH-8F45
        0x5712, # G+8774  U+5712  uni5712,  CJK UNIFIED IDEOGRAPH-5712
        0x54E1, # G+8775  U+54E1  uni54E1,  CJK UNIFIED IDEOGRAPH-54E1
        0x5713, # G+8776  U+5713  uni5713,  CJK UNIFIED IDEOGRAPH-5713
        0x7DE3, # G+8777  U+7DE3  uni7DE3,  CJK UNIFIED IDEOGRAPH-7DE3
        0x9060, # G+8778  U+9060  uni9060,  CJK UNIFIED IDEOGRAPH-9060
        0x9858, # G+8779  U+9858  uni9858,  CJK UNIFIED IDEOGRAPH-9858
        0x7D04, # G+8780  U+7D04  uni7D04,  CJK UNIFIED IDEOGRAPH-7D04
        0x8E8D, # G+8781  U+8E8D  uni8E8D,  CJK UNIFIED IDEOGRAPH-8E8D
        0x9470, # G+8782  U+9470  uni9470,  CJK UNIFIED IDEOGRAPH-9470
        0x95B2, # G+8783  U+95B2  uni95B2,  CJK UNIFIED IDEOGRAPH-95B2
        0x96F2, # G+8784  U+96F2  uni96F2,  CJK UNIFIED IDEOGRAPH-96F2
        0x9116, # G+8785  U+9116  uni9116,  CJK UNIFIED IDEOGRAPH-9116
        0x9695, # G+8786  U+9695  uni9695,  CJK UNIFIED IDEOGRAPH-9695
        0x904B, # G+8787  U+904B  uni904B,  CJK UNIFIED IDEOGRAPH-904B
        0x85F4, # G+8788  U+85F4  uni85F4,  CJK UNIFIED IDEOGRAPH-85F4
        0x9196, # G+8789  U+9196  uni9196,  CJK UNIFIED IDEOGRAPH-9196
        0x6688, # G+8790  U+6688  uni6688,  CJK UNIFIED IDEOGRAPH-6688
        0x96DC, # G+8791  U+96DC  uni96DC,  CJK UNIFIED IDEOGRAPH-96DC
        0x8F09, # G+8792  U+8F09  uni8F09,  CJK UNIFIED IDEOGRAPH-8F09
        0x6522, # G+8793  U+6522  uni6522,  CJK UNIFIED IDEOGRAPH-6522
        0x66AB, # G+8794  U+66AB  uni66AB,  CJK UNIFIED IDEOGRAPH-66AB
        0x8D0A, # G+8795  U+8D0A  uni8D0A,  CJK UNIFIED IDEOGRAPH-8D0A
        0x8D1C, # G+8796  U+8D1C  uni8D1C,  CJK UNIFIED IDEOGRAPH-8D1C
        0x81DF, # G+8797  U+81DF  uni81DF,  CJK UNIFIED IDEOGRAPH-81DF
        0x947F, # G+8798  U+947F  uni947F,  CJK UNIFIED IDEOGRAPH-947F
        0x68D7, # G+8799  U+68D7  uni68D7,  CJK UNIFIED IDEOGRAPH-68D7
        0x7AC8, # G+8800  U+7AC8  uni7AC8,  CJK UNIFIED IDEOGRAPH-7AC8
        0x8CAC, # G+8801  U+8CAC  uni8CAC,  CJK UNIFIED IDEOGRAPH-8CAC
        0x64C7, # G+8802  U+64C7  uni64C7,  CJK UNIFIED IDEOGRAPH-64C7
        0x5247, # G+8803  U+5247  uni5247,  CJK UNIFIED IDEOGRAPH-5247
        0x6FA4, # G+8804  U+6FA4  uni6FA4,  CJK UNIFIED IDEOGRAPH-6FA4
        0x8CCA, # G+8805  U+8CCA  uni8CCA,  CJK UNIFIED IDEOGRAPH-8CCA
        0x8D08, # G+8806  U+8D08  uni8D08,  CJK UNIFIED IDEOGRAPH-8D08
        0x8ECB, # G+8807  U+8ECB  uni8ECB,  CJK UNIFIED IDEOGRAPH-8ECB
        0x9358, # G+8808  U+9358  uni9358,  CJK UNIFIED IDEOGRAPH-9358
        0x9598, # G+8809  U+9598  uni9598,  CJK UNIFIED IDEOGRAPH-9598
        0x8A50, # G+8810  U+8A50  uni8A50,  CJK UNIFIED IDEOGRAPH-8A50
        0x9F4B, # G+8811  U+9F4B  uni9F4B,  CJK UNIFIED IDEOGRAPH-9F4B
        0x50B5, # G+8812  U+50B5  uni50B5,  CJK UNIFIED IDEOGRAPH-50B5
        0x6C08, # G+8813  U+6C08  uni6C08,  CJK UNIFIED IDEOGRAPH-6C08
        0x76DE, # G+8814  U+76DE  uni76DE,  CJK UNIFIED IDEOGRAPH-76DE
        0x65AC, # G+8815  U+65AC  uni65AC,  CJK UNIFIED IDEOGRAPH-65AC
        0x8F3E, # G+8816  U+8F3E  uni8F3E,  CJK UNIFIED IDEOGRAPH-8F3E
        0x5D84, # G+8817  U+5D84  uni5D84,  CJK UNIFIED IDEOGRAPH-5D84
        0x68E7, # G+8818  U+68E7  uni68E7,  CJK UNIFIED IDEOGRAPH-68E7
        0x6230, # G+8819  U+6230  uni6230,  CJK UNIFIED IDEOGRAPH-6230
        0x7DBB, # G+8820  U+7DBB  uni7DBB,  CJK UNIFIED IDEOGRAPH-7DBB
        0x5F35, # G+8821  U+5F35  uni5F35,  CJK UNIFIED IDEOGRAPH-5F35
        0x6F32, # G+8822  U+6F32  uni6F32,  CJK UNIFIED IDEOGRAPH-6F32
        0x5E33, # G+8823  U+5E33  uni5E33,  CJK UNIFIED IDEOGRAPH-5E33
        0x8CEC, # G+8824  U+8CEC  uni8CEC,  CJK UNIFIED IDEOGRAPH-8CEC
        0x8139, # G+8825  U+8139  uni8139,  CJK UNIFIED IDEOGRAPH-8139
        0x8D99, # G+8826  U+8D99  uni8D99,  CJK UNIFIED IDEOGRAPH-8D99
        0x87C4, # G+8827  U+87C4  uni87C4,  CJK UNIFIED IDEOGRAPH-87C4
        0x8F4D, # G+8828  U+8F4D  uni8F4D,  CJK UNIFIED IDEOGRAPH-8F4D
        0x937A, # G+8829  U+937A  uni937A,  CJK UNIFIED IDEOGRAPH-937A
        0x9019, # G+8830  U+9019  uni9019,  CJK UNIFIED IDEOGRAPH-9019
        0x8C9E, # G+8831  U+8C9E  uni8C9E,  CJK UNIFIED IDEOGRAPH-8C9E
        0x91DD, # G+8832  U+91DD  uni91DD,  CJK UNIFIED IDEOGRAPH-91DD
        0x5075, # G+8833  U+5075  uni5075,  CJK UNIFIED IDEOGRAPH-5075
        0x8A3A, # G+8834  U+8A3A  uni8A3A,  CJK UNIFIED IDEOGRAPH-8A3A
        0x93AE, # G+8835  U+93AE  uni93AE,  CJK UNIFIED IDEOGRAPH-93AE
        0x9663, # G+8836  U+9663  uni9663,  CJK UNIFIED IDEOGRAPH-9663
        0x5E40, # G+8837  U+5E40  uni5E40,  CJK UNIFIED IDEOGRAPH-5E40
        0x7665, # G+8838  U+7665  uni7665,  CJK UNIFIED IDEOGRAPH-7665
        0x912D, # G+8839  U+912D  uni912D,  CJK UNIFIED IDEOGRAPH-912D
        0x8B49, # G+8840  U+8B49  uni8B49,  CJK UNIFIED IDEOGRAPH-8B49
        0x7E54, # G+8841  U+7E54  uni7E54,  CJK UNIFIED IDEOGRAPH-7E54
        0x8077, # G+8842  U+8077  uni8077,  CJK UNIFIED IDEOGRAPH-8077
        0x57F7, # G+8843  U+57F7  uni57F7,  CJK UNIFIED IDEOGRAPH-57F7
        0x8879, # G+8844  U+8879  uni8879,  CJK UNIFIED IDEOGRAPH-8879
        0x7D19, # G+8845  U+7D19  uni7D19,  CJK UNIFIED IDEOGRAPH-7D19
        0x646F, # G+8846  U+646F  uni646F,  CJK UNIFIED IDEOGRAPH-646F
        0x64F2, # G+8847  U+64F2  uni64F2,  CJK UNIFIED IDEOGRAPH-64F2
        0x5E5F, # G+8848  U+5E5F  uni5E5F,  CJK UNIFIED IDEOGRAPH-5E5F
        0x8CEA, # G+8849  U+8CEA  uni8CEA,  CJK UNIFIED IDEOGRAPH-8CEA
        0x6EEF, # G+8850  U+6EEF  uni6EEF,  CJK UNIFIED IDEOGRAPH-6EEF
        0x9418, # G+8851  U+9418  uni9418,  CJK UNIFIED IDEOGRAPH-9418
        0x7D42, # G+8852  U+7D42  uni7D42,  CJK UNIFIED IDEOGRAPH-7D42
        0x7A2E, # G+8853  U+7A2E  uni7A2E,  CJK UNIFIED IDEOGRAPH-7A2E
        0x816B, # G+8854  U+816B  uni816B,  CJK UNIFIED IDEOGRAPH-816B
        0x8846, # G+8855  U+8846  uni8846,  CJK UNIFIED IDEOGRAPH-8846
        0x8B05, # G+8856  U+8B05  uni8B05,  CJK UNIFIED IDEOGRAPH-8B05
        0x8EF8, # G+8857  U+8EF8  uni8EF8,  CJK UNIFIED IDEOGRAPH-8EF8
        0x76BA, # G+8858  U+76BA  uni76BA,  CJK UNIFIED IDEOGRAPH-76BA
        0x665D, # G+8859  U+665D  uni665D,  CJK UNIFIED IDEOGRAPH-665D
        0x9A5F, # G+8860  U+9A5F  uni9A5F,  CJK UNIFIED IDEOGRAPH-9A5F
        0x8AF8, # G+8861  U+8AF8  uni8AF8,  CJK UNIFIED IDEOGRAPH-8AF8
        0x8A85, # G+8862  U+8A85  uni8A85,  CJK UNIFIED IDEOGRAPH-8A85
        0x71ED, # G+8863  U+71ED  uni71ED,  CJK UNIFIED IDEOGRAPH-71ED
        0x77DA, # G+8864  U+77DA  uni77DA,  CJK UNIFIED IDEOGRAPH-77DA
        0x56D1, # G+8865  U+56D1  uni56D1,  CJK UNIFIED IDEOGRAPH-56D1
        0x8CAF, # G+8866  U+8CAF  uni8CAF,  CJK UNIFIED IDEOGRAPH-8CAF
        0x9444, # G+8867  U+9444  uni9444,  CJK UNIFIED IDEOGRAPH-9444
        0x7BC9, # G+8868  U+7BC9  uni7BC9,  CJK UNIFIED IDEOGRAPH-7BC9
        0x99D0, # G+8869  U+99D0  uni99D0,  CJK UNIFIED IDEOGRAPH-99D0
        0x5C08, # G+8870  U+5C08  uni5C08,  CJK UNIFIED IDEOGRAPH-5C08
        0x78DA, # G+8871  U+78DA  uni78DA,  CJK UNIFIED IDEOGRAPH-78DA
        0x8F49, # G+8872  U+8F49  uni8F49,  CJK UNIFIED IDEOGRAPH-8F49
        0x8CFA, # G+8873  U+8CFA  uni8CFA,  CJK UNIFIED IDEOGRAPH-8CFA
        0x6A01, # G+8874  U+6A01  uni6A01,  CJK UNIFIED IDEOGRAPH-6A01
        0x838A, # G+8875  U+838A  uni838A,  CJK UNIFIED IDEOGRAPH-838A
        0x88DD, # G+8876  U+88DD  uni88DD,  CJK UNIFIED IDEOGRAPH-88DD
        0x599D, # G+8877  U+599D  uni599D,  CJK UNIFIED IDEOGRAPH-599D
        0x58EF, # G+8878  U+58EF  uni58EF,  CJK UNIFIED IDEOGRAPH-58EF
        0x72C0, # G+8879  U+72C0  uni72C0,  CJK UNIFIED IDEOGRAPH-72C0
        0x9310, # G+8880  U+9310  uni9310,  CJK UNIFIED IDEOGRAPH-9310
        0x8D05, # G+8881  U+8D05  uni8D05,  CJK UNIFIED IDEOGRAPH-8D05
        0x589C, # G+8882  U+589C  uni589C,  CJK UNIFIED IDEOGRAPH-589C
        0x7DB4, # G+8883  U+7DB4  uni7DB4,  CJK UNIFIED IDEOGRAPH-7DB4
        0x8AC4, # G+8884  U+8AC4  uni8AC4,  CJK UNIFIED IDEOGRAPH-8AC4
        0x6E96, # G+8885  U+6E96  uni6E96,  CJK UNIFIED IDEOGRAPH-6E96
        0x6FC1, # G+8886  U+6FC1  uni6FC1,  CJK UNIFIED IDEOGRAPH-6FC1
        0x8CC7, # G+8887  U+8CC7  uni8CC7,  CJK UNIFIED IDEOGRAPH-8CC7
        0x6F2C, # G+8888  U+6F2C  uni6F2C,  CJK UNIFIED IDEOGRAPH-6F2C
        0x7D9C, # G+8889  U+7D9C  uni7D9C,  CJK UNIFIED IDEOGRAPH-7D9C
        0x7E3D, # G+8890  U+7E3D  uni7E3D,  CJK UNIFIED IDEOGRAPH-7E3D
        0x7E31, # G+8891  U+7E31  uni7E31,  CJK UNIFIED IDEOGRAPH-7E31
        0x9112, # G+8892  U+9112  uni9112,  CJK UNIFIED IDEOGRAPH-9112
        0x8A5B, # G+8893  U+8A5B  uni8A5B,  CJK UNIFIED IDEOGRAPH-8A5B
        0x7D44, # G+8894  U+7D44  uni7D44,  CJK UNIFIED IDEOGRAPH-7D44
        0x947D, # G+8895  U+947D  uni947D,  CJK UNIFIED IDEOGRAPH-947D
        0x55C7, # G+8896  U+55C7  uni55C7,  CJK UNIFIED IDEOGRAPH-55C7
        0x5399, # G+8897  U+5399  uni5399,  CJK UNIFIED IDEOGRAPH-5399
        0x53B4, # G+8898  U+53B4  uni53B4,  CJK UNIFIED IDEOGRAPH-53B4
        0x9768, # G+8899  U+9768  uni9768,  CJK UNIFIED IDEOGRAPH-9768
        0x8D0B, # G+8900  U+8D0B  uni8D0B,  CJK UNIFIED IDEOGRAPH-8D0B
        0x532D, # G+8901  U+532D  uni532D,  CJK UNIFIED IDEOGRAPH-532D
        0x5331, # G+8902  U+5331  uni5331,  CJK UNIFIED IDEOGRAPH-5331
        0x8CFE, # G+8903  U+8CFE  uni8CFE,  CJK UNIFIED IDEOGRAPH-8CFE
        0x5244, # G+8904  U+5244  uni5244,  CJK UNIFIED IDEOGRAPH-5244
        0x528C, # G+8905  U+528C  uni528C,  CJK UNIFIED IDEOGRAPH-528C
        0x5274, # G+8906  U+5274  uni5274,  CJK UNIFIED IDEOGRAPH-5274
        0x50B4, # G+8907  U+50B4  uni50B4,  CJK UNIFIED IDEOGRAPH-50B4
        0x5000, # G+8908  U+5000  uni5000,  CJK UNIFIED IDEOGRAPH-5000
        0x5096, # G+8909  U+5096  uni5096,  CJK UNIFIED IDEOGRAPH-5096
        0x5115, # G+8910  U+5115  uni5115,  CJK UNIFIED IDEOGRAPH-5115
        0x5102, # G+8911  U+5102  uni5102,  CJK UNIFIED IDEOGRAPH-5102
        0x5114, # G+8912  U+5114  uni5114,  CJK UNIFIED IDEOGRAPH-5114
        0x513C, # G+8913  U+513C  uni513C,  CJK UNIFIED IDEOGRAPH-513C
        0x5137, # G+8914  U+5137  uni5137,  CJK UNIFIED IDEOGRAPH-5137
        0x50E8, # G+8915  U+50E8  uni50E8,  CJK UNIFIED IDEOGRAPH-50E8
        0x50C2, # G+8916  U+50C2  uni50C2,  CJK UNIFIED IDEOGRAPH-50C2
        0x513B, # G+8917  U+513B  uni513B,  CJK UNIFIED IDEOGRAPH-513B
        0x5110, # G+8918  U+5110  uni5110,  CJK UNIFIED IDEOGRAPH-5110
        0x513A, # G+8919  U+513A  uni513A,  CJK UNIFIED IDEOGRAPH-513A
        0x50C9, # G+8920  U+50C9  uni50C9,  CJK UNIFIED IDEOGRAPH-50C9
        0x7CF4, # G+8921  U+7CF4  uni7CF4,  CJK UNIFIED IDEOGRAPH-7CF4
        0x9ECC, # G+8922  U+9ECC  uni9ECC,  CJK UNIFIED IDEOGRAPH-9ECC
        0x56C5, # G+8923  U+56C5  uni56C5,  CJK UNIFIED IDEOGRAPH-56C5
        0x9CEC, # G+8924  U+9CEC  uni9CEC,  CJK UNIFIED IDEOGRAPH-9CEC
        0x893B, # G+8925  U+893B  uni893B,  CJK UNIFIED IDEOGRAPH-893B
        0x81E0, # G+8926  U+81E0  uni81E0,  CJK UNIFIED IDEOGRAPH-81E0
        0x8A01, # G+8927  U+8A01  uni8A01,  CJK UNIFIED IDEOGRAPH-8A01
        0x8A10, # G+8928  U+8A10  uni8A10,  CJK UNIFIED IDEOGRAPH-8A10
        0x8A0C, # G+8929  U+8A0C  uni8A0C,  CJK UNIFIED IDEOGRAPH-8A0C
        0x8A15, # G+8930  U+8A15  uni8A15,  CJK UNIFIED IDEOGRAPH-8A15
        0x8B33, # G+8931  U+8B33  uni8B33,  CJK UNIFIED IDEOGRAPH-8B33
        0x8A4E, # G+8932  U+8A4E  uni8A4E,  CJK UNIFIED IDEOGRAPH-8A4E
        0x8A25, # G+8933  U+8A25  uni8A25,  CJK UNIFIED IDEOGRAPH-8A25
        0x8A41, # G+8934  U+8A41  uni8A41,  CJK UNIFIED IDEOGRAPH-8A41
        0x8A36, # G+8935  U+8A36  uni8A36,  CJK UNIFIED IDEOGRAPH-8A36
        0x8A46, # G+8936  U+8A46  uni8A46,  CJK UNIFIED IDEOGRAPH-8A46
        0x8A54, # G+8937  U+8A54  uni8A54,  CJK UNIFIED IDEOGRAPH-8A54
        0x8A58, # G+8938  U+8A58  uni8A58,  CJK UNIFIED IDEOGRAPH-8A58
        0x8A52, # G+8939  U+8A52  uni8A52,  CJK UNIFIED IDEOGRAPH-8A52
        0x8A86, # G+8940  U+8A86  uni8A86,  CJK UNIFIED IDEOGRAPH-8A86
        0x8A84, # G+8941  U+8A84  uni8A84,  CJK UNIFIED IDEOGRAPH-8A84
        0x8A7F, # G+8942  U+8A7F  uni8A7F,  CJK UNIFIED IDEOGRAPH-8A7F
        0x8A70, # G+8943  U+8A70  uni8A70,  CJK UNIFIED IDEOGRAPH-8A70
        0x8A7C, # G+8944  U+8A7C  uni8A7C,  CJK UNIFIED IDEOGRAPH-8A7C
        0x8A75, # G+8945  U+8A75  uni8A75,  CJK UNIFIED IDEOGRAPH-8A75
        0x8A6C, # G+8946  U+8A6C  uni8A6C,  CJK UNIFIED IDEOGRAPH-8A6C
        0x8A6E, # G+8947  U+8A6E  uni8A6E,  CJK UNIFIED IDEOGRAPH-8A6E
        0x8ACD, # G+8948  U+8ACD  uni8ACD,  CJK UNIFIED IDEOGRAPH-8ACD
        0x8AE2, # G+8949  U+8AE2  uni8AE2,  CJK UNIFIED IDEOGRAPH-8AE2
        0x8A61, # G+8950  U+8A61  uni8A61,  CJK UNIFIED IDEOGRAPH-8A61
        0x8A9A, # G+8951  U+8A9A  uni8A9A,  CJK UNIFIED IDEOGRAPH-8A9A
        0x8AA5, # G+8952  U+8AA5  uni8AA5,  CJK UNIFIED IDEOGRAPH-8AA5
        0x8A91, # G+8953  U+8A91  uni8A91,  CJK UNIFIED IDEOGRAPH-8A91
        0x8A92, # G+8954  U+8A92  uni8A92,  CJK UNIFIED IDEOGRAPH-8A92
        0x8ACF, # G+8955  U+8ACF  uni8ACF,  CJK UNIFIED IDEOGRAPH-8ACF
        0x8AD1, # G+8956  U+8AD1  uni8AD1,  CJK UNIFIED IDEOGRAPH-8AD1
        0x8AC9, # G+8957  U+8AC9  uni8AC9,  CJK UNIFIED IDEOGRAPH-8AC9
        0x8ADB, # G+8958  U+8ADB  uni8ADB,  CJK UNIFIED IDEOGRAPH-8ADB
        0x8AD7, # G+8959  U+8AD7  uni8AD7,  CJK UNIFIED IDEOGRAPH-8AD7
        0x8AC2, # G+8960  U+8AC2  uni8AC2,  CJK UNIFIED IDEOGRAPH-8AC2
        0x8AB6, # G+8961  U+8AB6  uni8AB6,  CJK UNIFIED IDEOGRAPH-8AB6
        0x8AF6, # G+8962  U+8AF6  uni8AF6,  CJK UNIFIED IDEOGRAPH-8AF6
        0x8AEB, # G+8963  U+8AEB  uni8AEB,  CJK UNIFIED IDEOGRAPH-8AEB
        0x8B14, # G+8964  U+8B14  uni8B14,  CJK UNIFIED IDEOGRAPH-8B14
        0x8B01, # G+8965  U+8B01  uni8B01,  CJK UNIFIED IDEOGRAPH-8B01
        0x8AE4, # G+8966  U+8AE4  uni8AE4,  CJK UNIFIED IDEOGRAPH-8AE4
        0x8AED, # G+8967  U+8AED  uni8AED,  CJK UNIFIED IDEOGRAPH-8AED
        0x8AFC, # G+8968  U+8AFC  uni8AFC,  CJK UNIFIED IDEOGRAPH-8AFC
        0x8AF3, # G+8969  U+8AF3  uni8AF3,  CJK UNIFIED IDEOGRAPH-8AF3
        0x8AE6, # G+8970  U+8AE6  uni8AE6,  CJK UNIFIED IDEOGRAPH-8AE6
        0x8AEE, # G+8971  U+8AEE  uni8AEE,  CJK UNIFIED IDEOGRAPH-8AEE
        0x8ADE, # G+8972  U+8ADE  uni8ADE,  CJK UNIFIED IDEOGRAPH-8ADE
        0x8B28, # G+8973  U+8B28  uni8B28,  CJK UNIFIED IDEOGRAPH-8B28
        0x8B9C, # G+8974  U+8B9C  uni8B9C,  CJK UNIFIED IDEOGRAPH-8B9C
        0x8B16, # G+8975  U+8B16  uni8B16,  CJK UNIFIED IDEOGRAPH-8B16
        0x8B1A, # G+8976  U+8B1A  uni8B1A,  CJK UNIFIED IDEOGRAPH-8B1A
        0x8B10, # G+8977  U+8B10  uni8B10,  CJK UNIFIED IDEOGRAPH-8B10
        0x8B2B, # G+8978  U+8B2B  uni8B2B,  CJK UNIFIED IDEOGRAPH-8B2B
        0x8B2D, # G+8979  U+8B2D  uni8B2D,  CJK UNIFIED IDEOGRAPH-8B2D
        0x8B56, # G+8980  U+8B56  uni8B56,  CJK UNIFIED IDEOGRAPH-8B56
        0x8B59, # G+8981  U+8B59  uni8B59,  CJK UNIFIED IDEOGRAPH-8B59
        0x8B4E, # G+8982  U+8B4E  uni8B4E,  CJK UNIFIED IDEOGRAPH-8B4E
        0x8B9E, # G+8983  U+8B9E  uni8B9E,  CJK UNIFIED IDEOGRAPH-8B9E
        0x8B6B, # G+8984  U+8B6B  uni8B6B,  CJK UNIFIED IDEOGRAPH-8B6B
        0x8B96, # G+8985  U+8B96  uni8B96,  CJK UNIFIED IDEOGRAPH-8B96
        0x9658, # G+8986  U+9658  uni9658,  CJK UNIFIED IDEOGRAPH-9658
        0x913A, # G+8987  U+913A  uni913A,  CJK UNIFIED IDEOGRAPH-913A
        0x9114, # G+8988  U+9114  uni9114,  CJK UNIFIED IDEOGRAPH-9114
        0x9134, # G+8989  U+9134  uni9134,  CJK UNIFIED IDEOGRAPH-9134
        0x90DF, # G+8990  U+90DF  uni90DF,  CJK UNIFIED IDEOGRAPH-90DF
        0x9136, # G+8991  U+9136  uni9136,  CJK UNIFIED IDEOGRAPH-9136
        0x9106, # G+8992  U+9106  uni9106,  CJK UNIFIED IDEOGRAPH-9106
        0x9148, # G+8993  U+9148  uni9148,  CJK UNIFIED IDEOGRAPH-9148
        0x82BB, # G+8994  U+82BB  uni82BB,  CJK UNIFIED IDEOGRAPH-82BB
        0x52F1, # G+8995  U+52F1  uni52F1,  CJK UNIFIED IDEOGRAPH-52F1
        0x5DF0, # G+8996  U+5DF0  uni5DF0,  CJK UNIFIED IDEOGRAPH-5DF0
        0x580A, # G+8997  U+580A  uni580A,  CJK UNIFIED IDEOGRAPH-580A
        0x58D9, # G+8998  U+58D9  uni58D9,  CJK UNIFIED IDEOGRAPH-58D9
        0x58E2, # G+8999  U+58E2  uni58E2,  CJK UNIFIED IDEOGRAPH-58E2
        0x58E0, # G+9000  U+58E0  uni58E0,  CJK UNIFIED IDEOGRAPH-58E0
        0x58DA, # G+9001  U+58DA  uni58DA,  CJK UNIFIED IDEOGRAPH-58DA
        0x57E1, # G+9002  U+57E1  uni57E1,  CJK UNIFIED IDEOGRAPH-57E1
        0x584F, # G+9003  U+584F  uni584F,  CJK UNIFIED IDEOGRAPH-584F
        0x5816, # G+9004  U+5816  uni5816,  CJK UNIFIED IDEOGRAPH-5816
        0x5852, # G+9005  U+5852  uni5852,  CJK UNIFIED IDEOGRAPH-5852
        0x581D, # G+9006  U+581D  uni581D,  CJK UNIFIED IDEOGRAPH-581D
        0x5864, # G+9007  U+5864  uni5864,  CJK UNIFIED IDEOGRAPH-5864
        0x858C, # G+9008  U+858C  uni858C,  CJK UNIFIED IDEOGRAPH-858C
        0x8553, # G+9009  U+8553  uni8553,  CJK UNIFIED IDEOGRAPH-8553
        0x85F6, # G+9010  U+85F6  uni85F6,  CJK UNIFIED IDEOGRAPH-85F6
        0x83A7, # G+9011  U+83A7  uni83A7,  CJK UNIFIED IDEOGRAPH-83A7
        0x8407, # G+9012  U+8407  uni8407,  CJK UNIFIED IDEOGRAPH-8407
        0x84EF, # G+9013  U+84EF  uni84EF,  CJK UNIFIED IDEOGRAPH-84EF
        0x82E7, # G+9014  U+82E7  uni82E7,  CJK UNIFIED IDEOGRAPH-82E7
        0x8622, # G+9015  U+8622  uni8622,  CJK UNIFIED IDEOGRAPH-8622
        0x8526, # G+9016  U+8526  uni8526,  CJK UNIFIED IDEOGRAPH-8526
        0x584B, # G+9017  U+584B  uni584B,  CJK UNIFIED IDEOGRAPH-584B
        0x7162, # G+9018  U+7162  uni7162,  CJK UNIFIED IDEOGRAPH-7162
        0x8558, # G+9019  U+8558  uni8558,  CJK UNIFIED IDEOGRAPH-8558
        0x84FD, # G+9020  U+84FD  uni84FD,  CJK UNIFIED IDEOGRAPH-84FD
        0x854E, # G+9021  U+854E  uni854E,  CJK UNIFIED IDEOGRAPH-854E
        0x8588, # G+9022  U+8588  uni8588,  CJK UNIFIED IDEOGRAPH-8588
        0x85BA, # G+9023  U+85BA  uni85BA,  CJK UNIFIED IDEOGRAPH-85BA
        0x7296, # G+9024  U+7296  uni7296,  CJK UNIFIED IDEOGRAPH-7296
        0x6ECE, # G+9025  U+6ECE  uni6ECE,  CJK UNIFIED IDEOGRAPH-6ECE
        0x8541, # G+9026  U+8541  uni8541,  CJK UNIFIED IDEOGRAPH-8541
        0x85CE, # G+9027  U+85CE  uni85CE,  CJK UNIFIED IDEOGRAPH-85CE
        0x8552, # G+9028  U+8552  uni8552,  CJK UNIFIED IDEOGRAPH-8552
        0x84C0, # G+9029  U+84C0  uni84C0,  CJK UNIFIED IDEOGRAPH-84C0
        0x8452, # G+9030  U+8452  uni8452,  CJK UNIFIED IDEOGRAPH-8452
        0x8464, # G+9031  U+8464  uni8464,  CJK UNIFIED IDEOGRAPH-8464
        0x8494, # G+9032  U+8494  uni8494,  CJK UNIFIED IDEOGRAPH-8494
        0x8435, # G+9033  U+8435  uni8435,  CJK UNIFIED IDEOGRAPH-8435
        0x859F, # G+9034  U+859F  uni859F,  CJK UNIFIED IDEOGRAPH-859F
        0x8555, # G+9035  U+8555  uni8555,  CJK UNIFIED IDEOGRAPH-8555
        0x9DAF, # G+9036  U+9DAF  uni9DAF,  CJK UNIFIED IDEOGRAPH-9DAF
        0x8493, # G+9037  U+8493  uni8493,  CJK UNIFIED IDEOGRAPH-8493
        0x7E08, # G+9038  U+7E08  uni7E08,  CJK UNIFIED IDEOGRAPH-7E08
        0x8546, # G+9039  U+8546  uni8546,  CJK UNIFIED IDEOGRAPH-8546
        0x8562, # G+9040  U+8562  uni8562,  CJK UNIFIED IDEOGRAPH-8562
        0x851E, # G+9041  U+851E  uni851E,  CJK UNIFIED IDEOGRAPH-851E
        0x9A40, # G+9042  U+9A40  uni9A40,  CJK UNIFIED IDEOGRAPH-9A40
        0x863A, # G+9043  U+863A  uni863A,  CJK UNIFIED IDEOGRAPH-863A
        0x93A3, # G+9044  U+93A3  uni93A3,  CJK UNIFIED IDEOGRAPH-93A3
        0x8577, # G+9045  U+8577  uni8577,  CJK UNIFIED IDEOGRAPH-8577
        0x861E, # G+9046  U+861E  uni861E,  CJK UNIFIED IDEOGRAPH-861E
        0x85FA, # G+9047  U+85FA  uni85FA,  CJK UNIFIED IDEOGRAPH-85FA
        0x8604, # G+9048  U+8604  uni8604,  CJK UNIFIED IDEOGRAPH-8604
        0x85EA, # G+9049  U+85EA  uni85EA,  CJK UNIFIED IDEOGRAPH-85EA
        0x861A, # G+9050  U+861A  uni861A,  CJK UNIFIED IDEOGRAPH-861A
        0x5969, # G+9051  U+5969  uni5969,  CJK UNIFIED IDEOGRAPH-5969
        0x5C37, # G+9052  U+5C37  uni5C37,  CJK UNIFIED IDEOGRAPH-5C37
        0x636B, # G+9053  U+636B  uni636B,  CJK UNIFIED IDEOGRAPH-636B
        0x6476, # G+9054  U+6476  uni6476,  CJK UNIFIED IDEOGRAPH-6476
        0x649F, # G+9055  U+649F  uni649F,  CJK UNIFIED IDEOGRAPH-649F
        0x6451, # G+9056  U+6451  uni6451,  CJK UNIFIED IDEOGRAPH-6451
        0x645C, # G+9057  U+645C  uni645C,  CJK UNIFIED IDEOGRAPH-645C
        0x64B3, # G+9058  U+64B3  uni64B3,  CJK UNIFIED IDEOGRAPH-64B3
        0x6504, # G+9059  U+6504  uni6504,  CJK UNIFIED IDEOGRAPH-6504
        0x6516, # G+9060  U+6516  uni6516,  CJK UNIFIED IDEOGRAPH-6516
        0x64F7, # G+9061  U+64F7  uni64F7,  CJK UNIFIED IDEOGRAPH-64F7
        0x64FC, # G+9062  U+64FC  uni64FC,  CJK UNIFIED IDEOGRAPH-64FC
        0x651B, # G+9063  U+651B  uni651B,  CJK UNIFIED IDEOGRAPH-651B
        0x5630, # G+9064  U+5630  uni5630,  CJK UNIFIED IDEOGRAPH-5630
        0x5638, # G+9065  U+5638  uni5638,  CJK UNIFIED IDEOGRAPH-5638
        0x56C8, # G+9066  U+56C8  uni56C8,  CJK UNIFIED IDEOGRAPH-56C8
        0x56A6, # G+9067  U+56A6  uni56A6,  CJK UNIFIED IDEOGRAPH-56A6
        0x5504, # G+9068  U+5504  uni5504,  CJK UNIFIED IDEOGRAPH-5504
        0x54BC, # G+9069  U+54BC  uni54BC,  CJK UNIFIED IDEOGRAPH-54BC
        0x5680, # G+9070  U+5680  uni5680,  CJK UNIFIED IDEOGRAPH-5680
        0x565D, # G+9071  U+565D  uni565D,  CJK UNIFIED IDEOGRAPH-565D
        0x5660, # G+9072  U+5660  uni5660,  CJK UNIFIED IDEOGRAPH-5660
        0x5635, # G+9073  U+5635  uni5635,  CJK UNIFIED IDEOGRAPH-5635
        0x55F6, # G+9074  U+55F6  uni55F6,  CJK UNIFIED IDEOGRAPH-55F6
        0x5666, # G+9075  U+5666  uni5666,  CJK UNIFIED IDEOGRAPH-5666
        0x5672, # G+9076  U+5672  uni5672,  CJK UNIFIED IDEOGRAPH-5672
        0x568C, # G+9077  U+568C  uni568C,  CJK UNIFIED IDEOGRAPH-568C
        0x5665, # G+9078  U+5665  uni5665,  CJK UNIFIED IDEOGRAPH-5665
        0x561C, # G+9079  U+561C  uni561C,  CJK UNIFIED IDEOGRAPH-561C
        0x562E, # G+9080  U+562E  uni562E,  CJK UNIFIED IDEOGRAPH-562E
        0x55E9, # G+9081  U+55E9  uni55E9,  CJK UNIFIED IDEOGRAPH-55E9
        0x5616, # G+9082  U+5616  uni5616,  CJK UNIFIED IDEOGRAPH-5616
        0x56C0, # G+9083  U+56C0  uni56C0,  CJK UNIFIED IDEOGRAPH-56C0
        0x560D, # G+9084  U+560D  uni560D,  CJK UNIFIED IDEOGRAPH-560D
        0x56B3, # G+9085  U+56B3  uni56B3,  CJK UNIFIED IDEOGRAPH-56B3
        0x56C1, # G+9086  U+56C1  uni56C1,  CJK UNIFIED IDEOGRAPH-56C1
        0x566F, # G+9087  U+566F  uni566F,  CJK UNIFIED IDEOGRAPH-566F
        0x8F61, # G+9088  U+8F61  uni8F61,  CJK UNIFIED IDEOGRAPH-8F61
        0x56B6, # G+9089  U+56B6  uni56B6,  CJK UNIFIED IDEOGRAPH-56B6
        0x5695, # G+9090  U+5695  uni5695,  CJK UNIFIED IDEOGRAPH-5695
        0x5707, # G+9091  U+5707  uni5707,  CJK UNIFIED IDEOGRAPH-5707
        0x5E43, # G+9092  U+5E43  uni5E43,  CJK UNIFIED IDEOGRAPH-5E43
        0x5E6C, # G+9093  U+5E6C  uni5E6C,  CJK UNIFIED IDEOGRAPH-5E6C
        0x5E58, # G+9094  U+5E58  uni5E58,  CJK UNIFIED IDEOGRAPH-5E58
        0x5E57, # G+9095  U+5E57  uni5E57,  CJK UNIFIED IDEOGRAPH-5E57
        0x5D87, # G+9096  U+5D87  uni5D87,  CJK UNIFIED IDEOGRAPH-5D87
        0x5CF4, # G+9097  U+5CF4  uni5CF4,  CJK UNIFIED IDEOGRAPH-5CF4
        0x5D50, # G+9098  U+5D50  uni5D50,  CJK UNIFIED IDEOGRAPH-5D50
        0x5D2C, # G+9099  U+5D2C  uni5D2C,  CJK UNIFIED IDEOGRAPH-5D2C
        0x5DA7, # G+9100  U+5DA7  uni5DA7,  CJK UNIFIED IDEOGRAPH-5DA7
        0x5DA0, # G+9101  U+5DA0  uni5DA0,  CJK UNIFIED IDEOGRAPH-5DA0
        0x5D97, # G+9102  U+5D97  uni5D97,  CJK UNIFIED IDEOGRAPH-5D97
        0x5D0D, # G+9103  U+5D0D  uni5D0D,  CJK UNIFIED IDEOGRAPH-5D0D
        0x5DB8, # G+9104  U+5DB8  uni5DB8,  CJK UNIFIED IDEOGRAPH-5DB8
        0x5D81, # G+9105  U+5D81  uni5D81,  CJK UNIFIED IDEOGRAPH-5D81
        0x5DD4, # G+9106  U+5DD4  uni5DD4,  CJK UNIFIED IDEOGRAPH-5DD4
        0x5FA0, # G+9107  U+5FA0  uni5FA0,  CJK UNIFIED IDEOGRAPH-5FA0
        0x7377, # G+9108  U+7377  uni7377,  CJK UNIFIED IDEOGRAPH-7377
        0x7341, # G+9109  U+7341  uni7341,  CJK UNIFIED IDEOGRAPH-7341
        0x736A, # G+9110  U+736A  uni736A,  CJK UNIFIED IDEOGRAPH-736A
        0x733B, # G+9111  U+733B  uni733B,  CJK UNIFIED IDEOGRAPH-733B
        0x736B, # G+9112  U+736B  uni736B,  CJK UNIFIED IDEOGRAPH-736B
        0x7380, # G+9113  U+7380  uni7380,  CJK UNIFIED IDEOGRAPH-7380
        0x737C, # G+9114  U+737C  uni737C,  CJK UNIFIED IDEOGRAPH-737C
        0x98E0, # G+9115  U+98E0  uni98E0,  CJK UNIFIED IDEOGRAPH-98E0
        0x9933, # G+9116  U+9933  uni9933,  CJK UNIFIED IDEOGRAPH-9933
        0x98E9, # G+9117  U+98E9  uni98E9,  CJK UNIFIED IDEOGRAPH-98E9
        0x993C, # G+9118  U+993C  uni993C,  CJK UNIFIED IDEOGRAPH-993C
        0x98EA, # G+9119  U+98EA  uni98EA,  CJK UNIFIED IDEOGRAPH-98EA
        0x98EB, # G+9120  U+98EB  uni98EB,  CJK UNIFIED IDEOGRAPH-98EB
        0x98ED, # G+9121  U+98ED  uni98ED,  CJK UNIFIED IDEOGRAPH-98ED
        0x98F4, # G+9122  U+98F4  uni98F4,  CJK UNIFIED IDEOGRAPH-98F4
        0x9909, # G+9123  U+9909  uni9909,  CJK UNIFIED IDEOGRAPH-9909
        0x9911, # G+9124  U+9911  uni9911,  CJK UNIFIED IDEOGRAPH-9911
        0x991B, # G+9125  U+991B  uni991B,  CJK UNIFIED IDEOGRAPH-991B
        0x9937, # G+9126  U+9937  uni9937,  CJK UNIFIED IDEOGRAPH-9937
        0x993F, # G+9127  U+993F  uni993F,  CJK UNIFIED IDEOGRAPH-993F
        0x9943, # G+9128  U+9943  uni9943,  CJK UNIFIED IDEOGRAPH-9943
        0x9948, # G+9129  U+9948  uni9948,  CJK UNIFIED IDEOGRAPH-9948
        0x9949, # G+9130  U+9949  uni9949,  CJK UNIFIED IDEOGRAPH-9949
        0x994A, # G+9131  U+994A  uni994A,  CJK UNIFIED IDEOGRAPH-994A
        0x994C, # G+9132  U+994C  uni994C,  CJK UNIFIED IDEOGRAPH-994C
        0x9962, # G+9133  U+9962  uni9962,  CJK UNIFIED IDEOGRAPH-9962
        0x5EE1, # G+9134  U+5EE1  uni5EE1,  CJK UNIFIED IDEOGRAPH-5EE1
        0x8CE1, # G+9135  U+8CE1  uni8CE1,  CJK UNIFIED IDEOGRAPH-8CE1
        0x61FA, # G+9136  U+61FA  uni61FA,  CJK UNIFIED IDEOGRAPH-61FA
        0x61AE, # G+9137  U+61AE  uni61AE,  CJK UNIFIED IDEOGRAPH-61AE
        0x616A, # G+9138  U+616A  uni616A,  CJK UNIFIED IDEOGRAPH-616A
        0x613E, # G+9139  U+613E  uni613E,  CJK UNIFIED IDEOGRAPH-613E
        0x60B5, # G+9140  U+60B5  uni60B5,  CJK UNIFIED IDEOGRAPH-60B5
        0x6134, # G+9141  U+6134  uni6134,  CJK UNIFIED IDEOGRAPH-6134
        0x61CC, # G+9142  U+61CC  uni61CC,  CJK UNIFIED IDEOGRAPH-61CC
        0x615F, # G+9143  U+615F  uni615F,  CJK UNIFIED IDEOGRAPH-615F
        0x61E8, # G+9144  U+61E8  uni61E8,  CJK UNIFIED IDEOGRAPH-61E8
        0x60FB, # G+9145  U+60FB  uni60FB,  CJK UNIFIED IDEOGRAPH-60FB
        0x6137, # G+9146  U+6137  uni6137,  CJK UNIFIED IDEOGRAPH-6137
        0x60F2, # G+9147  U+60F2  uni60F2,  CJK UNIFIED IDEOGRAPH-60F2
        0x6173, # G+9148  U+6173  uni6173,  CJK UNIFIED IDEOGRAPH-6173
        0x611C, # G+9149  U+611C  uni611C,  CJK UNIFIED IDEOGRAPH-611C
        0x6192, # G+9150  U+6192  uni6192,  CJK UNIFIED IDEOGRAPH-6192
        0x9582, # G+9151  U+9582  uni9582,  CJK UNIFIED IDEOGRAPH-9582
        0x9586, # G+9152  U+9586  uni9586,  CJK UNIFIED IDEOGRAPH-9586
        0x95C8, # G+9153  U+95C8  uni95C8,  CJK UNIFIED IDEOGRAPH-95C8
        0x958E, # G+9154  U+958E  uni958E,  CJK UNIFIED IDEOGRAPH-958E
        0x9594, # G+9155  U+9594  uni9594,  CJK UNIFIED IDEOGRAPH-9594
        0x958C, # G+9156  U+958C  uni958C,  CJK UNIFIED IDEOGRAPH-958C
        0x95E5, # G+9157  U+95E5  uni95E5,  CJK UNIFIED IDEOGRAPH-95E5
        0x95AD, # G+9158  U+95AD  uni95AD,  CJK UNIFIED IDEOGRAPH-95AD
        0x95AB, # G+9159  U+95AB  uni95AB,  CJK UNIFIED IDEOGRAPH-95AB
        0x9B2E, # G+9160  U+9B2E  uni9B2E,  CJK UNIFIED IDEOGRAPH-9B2E
        0x95AC, # G+9161  U+95AC  uni95AC,  CJK UNIFIED IDEOGRAPH-95AC
        0x95BE, # G+9162  U+95BE  uni95BE,  CJK UNIFIED IDEOGRAPH-95BE
        0x95B6, # G+9163  U+95B6  uni95B6,  CJK UNIFIED IDEOGRAPH-95B6
        0x9B29, # G+9164  U+9B29  uni9B29,  CJK UNIFIED IDEOGRAPH-9B29
        0x95BF, # G+9165  U+95BF  uni95BF,  CJK UNIFIED IDEOGRAPH-95BF
        0x95BD, # G+9166  U+95BD  uni95BD,  CJK UNIFIED IDEOGRAPH-95BD
        0x95BC, # G+9167  U+95BC  uni95BC,  CJK UNIFIED IDEOGRAPH-95BC
        0x95C3, # G+9168  U+95C3  uni95C3,  CJK UNIFIED IDEOGRAPH-95C3
        0x95CB, # G+9169  U+95CB  uni95CB,  CJK UNIFIED IDEOGRAPH-95CB
        0x95D4, # G+9170  U+95D4  uni95D4,  CJK UNIFIED IDEOGRAPH-95D4
        0x95D0, # G+9171  U+95D0  uni95D0,  CJK UNIFIED IDEOGRAPH-95D0
        0x95D5, # G+9172  U+95D5  uni95D5,  CJK UNIFIED IDEOGRAPH-95D5
        0x95DE, # G+9173  U+95DE  uni95DE,  CJK UNIFIED IDEOGRAPH-95DE
        0x7043, # G+9174  U+7043  uni7043,  CJK UNIFIED IDEOGRAPH-7043
        0x6F59, # G+9175  U+6F59  uni6F59,  CJK UNIFIED IDEOGRAPH-6F59
        0x7027, # G+9176  U+7027  uni7027,  CJK UNIFIED IDEOGRAPH-7027
        0x7018, # G+9177  U+7018  uni7018,  CJK UNIFIED IDEOGRAPH-7018
        0x6FFC, # G+9178  U+6FFC  uni6FFC,  CJK UNIFIED IDEOGRAPH-6FFC
        0x6D87, # G+9179  U+6D87  uni6D87,  CJK UNIFIED IDEOGRAPH-6D87
        0x6D79, # G+9180  U+6D79  uni6D79,  CJK UNIFIED IDEOGRAPH-6D79
        0x6E5E, # G+9181  U+6E5E  uni6E5E,  CJK UNIFIED IDEOGRAPH-6E5E
        0x6FAE, # G+9182  U+6FAE  uni6FAE,  CJK UNIFIED IDEOGRAPH-6FAE
        0x700F, # G+9183  U+700F  uni700F,  CJK UNIFIED IDEOGRAPH-700F
        0x6EF8, # G+9184  U+6EF8  uni6EF8,  CJK UNIFIED IDEOGRAPH-6EF8
        0x6F6F, # G+9185  U+6F6F  uni6F6F,  CJK UNIFIED IDEOGRAPH-6F6F
        0x6DF6, # G+9186  U+6DF6  uni6DF6,  CJK UNIFIED IDEOGRAPH-6DF6
        0x6F7F, # G+9187  U+6F7F  uni6F7F,  CJK UNIFIED IDEOGRAPH-6F7F
        0x7006, # G+9188  U+7006  uni7006,  CJK UNIFIED IDEOGRAPH-7006
        0x6FA0, # G+9189  U+6FA0  uni6FA0,  CJK UNIFIED IDEOGRAPH-6FA0
        0x700B, # G+9190  U+700B  uni700B,  CJK UNIFIED IDEOGRAPH-700B
        0x7067, # G+9191  U+7067  uni7067,  CJK UNIFIED IDEOGRAPH-7067
        0x7044, # G+9192  U+7044  uni7044,  CJK UNIFIED IDEOGRAPH-7044
        0x7005, # G+9193  U+7005  uni7005,  CJK UNIFIED IDEOGRAPH-7005
        0x6F77, # G+9194  U+6F77  uni6F77,  CJK UNIFIED IDEOGRAPH-6F77
        0x7020, # G+9195  U+7020  uni7020,  CJK UNIFIED IDEOGRAPH-7020
        0x701F, # G+9196  U+701F  uni701F,  CJK UNIFIED IDEOGRAPH-701F
        0x7032, # G+9197  U+7032  uni7032,  CJK UNIFIED IDEOGRAPH-7032
        0x7028, # G+9198  U+7028  uni7028,  CJK UNIFIED IDEOGRAPH-7028
        0x705D, # G+9199  U+705D  uni705D,  CJK UNIFIED IDEOGRAPH-705D
        0x9A2B, # G+9200  U+9A2B  uni9A2B,  CJK UNIFIED IDEOGRAPH-9A2B
        0x9087, # G+9201  U+9087  uni9087,  CJK UNIFIED IDEOGRAPH-9087
        0x9015, # G+9202  U+9015  uni9015,  CJK UNIFIED IDEOGRAPH-9015
        0x9090, # G+9203  U+9090  uni9090,  CJK UNIFIED IDEOGRAPH-9090
        0x5C68, # G+9204  U+5C68  uni5C68,  CJK UNIFIED IDEOGRAPH-5C68
        0x5F33, # G+9205  U+5F33  uni5F33,  CJK UNIFIED IDEOGRAPH-5F33
        0x5AF5, # G+9206  U+5AF5  uni5AF5,  CJK UNIFIED IDEOGRAPH-5AF5
        0x5AD7, # G+9207  U+5AD7  uni5AD7,  CJK UNIFIED IDEOGRAPH-5AD7
        0x5B00, # G+9208  U+5B00  uni5B00,  CJK UNIFIED IDEOGRAPH-5B00
        0x5A6D, # G+9209  U+5A6D  uni5A6D,  CJK UNIFIED IDEOGRAPH-5A6D
        0x5B08, # G+9210  U+5B08  uni5B08,  CJK UNIFIED IDEOGRAPH-5B08
        0x5B4C, # G+9211  U+5B4C  uni5B4C,  CJK UNIFIED IDEOGRAPH-5B4C
        0x5AA7, # G+9212  U+5AA7  uni5AA7,  CJK UNIFIED IDEOGRAPH-5AA7
        0x5AFB, # G+9213  U+5AFB  uni5AFB,  CJK UNIFIED IDEOGRAPH-5AFB
        0x5B0B, # G+9214  U+5B0B  uni5B0B,  CJK UNIFIED IDEOGRAPH-5B0B
        0x5B21, # G+9215  U+5B21  uni5B21,  CJK UNIFIED IDEOGRAPH-5B21
        0x5B2A, # G+9216  U+5B2A  uni5B2A,  CJK UNIFIED IDEOGRAPH-5B2A
        0x5B19, # G+9217  U+5B19  uni5B19,  CJK UNIFIED IDEOGRAPH-5B19
        0x99D4, # G+9218  U+99D4  uni99D4,  CJK UNIFIED IDEOGRAPH-99D4
        0x99DF, # G+9219  U+99DF  uni99DF,  CJK UNIFIED IDEOGRAPH-99DF
        0x99D9, # G+9220  U+99D9  uni99D9,  CJK UNIFIED IDEOGRAPH-99D9
        0x9A36, # G+9221  U+9A36  uni9A36,  CJK UNIFIED IDEOGRAPH-9A36
        0x9A5B, # G+9222  U+9A5B  uni9A5B,  CJK UNIFIED IDEOGRAPH-9A5B
        0x99D1, # G+9223  U+99D1  uni99D1,  CJK UNIFIED IDEOGRAPH-99D1
        0x99D8, # G+9224  U+99D8  uni99D8,  CJK UNIFIED IDEOGRAPH-99D8
        0x9A4D, # G+9225  U+9A4D  uni9A4D,  CJK UNIFIED IDEOGRAPH-9A4D
        0x9A4A, # G+9226  U+9A4A  uni9A4A,  CJK UNIFIED IDEOGRAPH-9A4A
        0x99E2, # G+9227  U+99E2  uni99E2,  CJK UNIFIED IDEOGRAPH-99E2
        0x9A6A, # G+9228  U+9A6A  uni9A6A,  CJK UNIFIED IDEOGRAPH-9A6A
        0x9A0F, # G+9229  U+9A0F  uni9A0F,  CJK UNIFIED IDEOGRAPH-9A0F
        0x9A0D, # G+9230  U+9A0D  uni9A0D,  CJK UNIFIED IDEOGRAPH-9A0D
        0x9A05, # G+9231  U+9A05  uni9A05,  CJK UNIFIED IDEOGRAPH-9A05
        0x9A42, # G+9232  U+9A42  uni9A42,  CJK UNIFIED IDEOGRAPH-9A42
        0x9A2D, # G+9233  U+9A2D  uni9A2D,  CJK UNIFIED IDEOGRAPH-9A2D
        0x9A16, # G+9234  U+9A16  uni9A16,  CJK UNIFIED IDEOGRAPH-9A16
        0x9A41, # G+9235  U+9A41  uni9A41,  CJK UNIFIED IDEOGRAPH-9A41
        0x9A2E, # G+9236  U+9A2E  uni9A2E,  CJK UNIFIED IDEOGRAPH-9A2E
        0x9A38, # G+9237  U+9A38  uni9A38,  CJK UNIFIED IDEOGRAPH-9A38
        0x9A43, # G+9238  U+9A43  uni9A43,  CJK UNIFIED IDEOGRAPH-9A43
        0x9A44, # G+9239  U+9A44  uni9A44,  CJK UNIFIED IDEOGRAPH-9A44
        0x9A4F, # G+9240  U+9A4F  uni9A4F,  CJK UNIFIED IDEOGRAPH-9A4F
        0x9A65, # G+9241  U+9A65  uni9A65,  CJK UNIFIED IDEOGRAPH-9A65
        0x9A64, # G+9242  U+9A64  uni9A64,  CJK UNIFIED IDEOGRAPH-9A64
        0x7CF9, # G+9243  U+7CF9  uni7CF9,  CJK UNIFIED IDEOGRAPH-7CF9
        0x7D06, # G+9244  U+7D06  uni7D06,  CJK UNIFIED IDEOGRAPH-7D06
        0x7D02, # G+9245  U+7D02  uni7D02,  CJK UNIFIED IDEOGRAPH-7D02
        0x7D07, # G+9246  U+7D07  uni7D07,  CJK UNIFIED IDEOGRAPH-7D07
        0x7D08, # G+9247  U+7D08  uni7D08,  CJK UNIFIED IDEOGRAPH-7D08
        0x7E8A, # G+9248  U+7E8A  uni7E8A,  CJK UNIFIED IDEOGRAPH-7E8A
        0x7D1C, # G+9249  U+7D1C  uni7D1C,  CJK UNIFIED IDEOGRAPH-7D1C
        0x7D15, # G+9250  U+7D15  uni7D15,  CJK UNIFIED IDEOGRAPH-7D15
        0x7D13, # G+9251  U+7D13  uni7D13,  CJK UNIFIED IDEOGRAPH-7D13
        0x7D3A, # G+9252  U+7D3A  uni7D3A,  CJK UNIFIED IDEOGRAPH-7D3A
        0x7D32, # G+9253  U+7D32  uni7D32,  CJK UNIFIED IDEOGRAPH-7D32
        0x7D31, # G+9254  U+7D31  uni7D31,  CJK UNIFIED IDEOGRAPH-7D31
        0x7E10, # G+9255  U+7E10  uni7E10,  CJK UNIFIED IDEOGRAPH-7E10
        0x7D3C, # G+9256  U+7D3C  uni7D3C,  CJK UNIFIED IDEOGRAPH-7D3C
        0x7D40, # G+9257  U+7D40  uni7D40,  CJK UNIFIED IDEOGRAPH-7D40
        0x7D3F, # G+9258  U+7D3F  uni7D3F,  CJK UNIFIED IDEOGRAPH-7D3F
        0x7D5D, # G+9259  U+7D5D  uni7D5D,  CJK UNIFIED IDEOGRAPH-7D5D
        0x7D4E, # G+9260  U+7D4E  uni7D4E,  CJK UNIFIED IDEOGRAPH-7D4E
        0x7D73, # G+9261  U+7D73  uni7D73,  CJK UNIFIED IDEOGRAPH-7D73
        0x7D86, # G+9262  U+7D86  uni7D86,  CJK UNIFIED IDEOGRAPH-7D86
        0x7D83, # G+9263  U+7D83  uni7D83,  CJK UNIFIED IDEOGRAPH-7D83
        0x7D88, # G+9264  U+7D88  uni7D88,  CJK UNIFIED IDEOGRAPH-7D88
        0x7DBE, # G+9265  U+7DBE  uni7DBE,  CJK UNIFIED IDEOGRAPH-7DBE
        0x7DBA, # G+9266  U+7DBA  uni7DBA,  CJK UNIFIED IDEOGRAPH-7DBA
        0x7DCB, # G+9267  U+7DCB  uni7DCB,  CJK UNIFIED IDEOGRAPH-7DCB
        0x7DD4, # G+9268  U+7DD4  uni7DD4,  CJK UNIFIED IDEOGRAPH-7DD4
        0x7DC4, # G+9269  U+7DC4  uni7DC4,  CJK UNIFIED IDEOGRAPH-7DC4
        0x7D9E, # G+9270  U+7D9E  uni7D9E,  CJK UNIFIED IDEOGRAPH-7D9E
        0x7DAC, # G+9271  U+7DAC  uni7DAC,  CJK UNIFIED IDEOGRAPH-7DAC
        0x7DB9, # G+9272  U+7DB9  uni7DB9,  CJK UNIFIED IDEOGRAPH-7DB9
        0x7DA3, # G+9273  U+7DA3  uni7DA3,  CJK UNIFIED IDEOGRAPH-7DA3
        0x7DB0, # G+9274  U+7DB0  uni7DB0,  CJK UNIFIED IDEOGRAPH-7DB0
        0x7DC7, # G+9275  U+7DC7  uni7DC7,  CJK UNIFIED IDEOGRAPH-7DC7
        0x7DD9, # G+9276  U+7DD9  uni7DD9,  CJK UNIFIED IDEOGRAPH-7DD9
        0x7DD7, # G+9277  U+7DD7  uni7DD7,  CJK UNIFIED IDEOGRAPH-7DD7
        0x7DF9, # G+9278  U+7DF9  uni7DF9,  CJK UNIFIED IDEOGRAPH-7DF9
        0x7DF2, # G+9279  U+7DF2  uni7DF2,  CJK UNIFIED IDEOGRAPH-7DF2
        0x7E62, # G+9280  U+7E62  uni7E62,  CJK UNIFIED IDEOGRAPH-7E62
        0x7DE6, # G+9281  U+7DE6  uni7DE6,  CJK UNIFIED IDEOGRAPH-7DE6
        0x7DF6, # G+9282  U+7DF6  uni7DF6,  CJK UNIFIED IDEOGRAPH-7DF6
        0x7DF1, # G+9283  U+7DF1  uni7DF1,  CJK UNIFIED IDEOGRAPH-7DF1
        0x7E0B, # G+9284  U+7E0B  uni7E0B,  CJK UNIFIED IDEOGRAPH-7E0B
        0x7DE1, # G+9285  U+7DE1  uni7DE1,  CJK UNIFIED IDEOGRAPH-7DE1
        0x7E09, # G+9286  U+7E09  uni7E09,  CJK UNIFIED IDEOGRAPH-7E09
        0x7E1D, # G+9287  U+7E1D  uni7E1D,  CJK UNIFIED IDEOGRAPH-7E1D
        0x7E1F, # G+9288  U+7E1F  uni7E1F,  CJK UNIFIED IDEOGRAPH-7E1F
        0x7E1E, # G+9289  U+7E1E  uni7E1E,  CJK UNIFIED IDEOGRAPH-7E1E
        0x7E2D, # G+9290  U+7E2D  uni7E2D,  CJK UNIFIED IDEOGRAPH-7E2D
        0x7E0A, # G+9291  U+7E0A  uni7E0A,  CJK UNIFIED IDEOGRAPH-7E0A
        0x7E11, # G+9292  U+7E11  uni7E11,  CJK UNIFIED IDEOGRAPH-7E11
        0x7E7D, # G+9293  U+7E7D  uni7E7D,  CJK UNIFIED IDEOGRAPH-7E7D
        0x7E39, # G+9294  U+7E39  uni7E39,  CJK UNIFIED IDEOGRAPH-7E39
        0x7E35, # G+9295  U+7E35  uni7E35,  CJK UNIFIED IDEOGRAPH-7E35
        0x7E32, # G+9296  U+7E32  uni7E32,  CJK UNIFIED IDEOGRAPH-7E32
        0x7E46, # G+9297  U+7E46  uni7E46,  CJK UNIFIED IDEOGRAPH-7E46
        0x7E45, # G+9298  U+7E45  uni7E45,  CJK UNIFIED IDEOGRAPH-7E45
        0x7E88, # G+9299  U+7E88  uni7E88,  CJK UNIFIED IDEOGRAPH-7E88
        0x7E5A, # G+9300  U+7E5A  uni7E5A,  CJK UNIFIED IDEOGRAPH-7E5A
        0x7E52, # G+9301  U+7E52  uni7E52,  CJK UNIFIED IDEOGRAPH-7E52
        0x7E6E, # G+9302  U+7E6E  uni7E6E,  CJK UNIFIED IDEOGRAPH-7E6E
        0x7E7E, # G+9303  U+7E7E  uni7E7E,  CJK UNIFIED IDEOGRAPH-7E7E
        0x7E70, # G+9304  U+7E70  uni7E70,  CJK UNIFIED IDEOGRAPH-7E70
        0x7E6F, # G+9305  U+7E6F  uni7E6F,  CJK UNIFIED IDEOGRAPH-7E6F
        0x7E98, # G+9306  U+7E98  uni7E98,  CJK UNIFIED IDEOGRAPH-7E98
        0x74A3, # G+9307  U+74A3  uni74A3,  CJK UNIFIED IDEOGRAPH-74A3
        0x744B, # G+9308  U+744B  uni744B,  CJK UNIFIED IDEOGRAPH-744B
        0x74CF, # G+9309  U+74CF  uni74CF,  CJK UNIFIED IDEOGRAPH-74CF
        0x980A, # G+9310  U+980A  uni980A,  CJK UNIFIED IDEOGRAPH-980A
        0x74BD, # G+9311  U+74BD  uni74BD,  CJK UNIFIED IDEOGRAPH-74BD
        0x743F, # G+9312  U+743F  uni743F,  CJK UNIFIED IDEOGRAPH-743F
        0x7489, # G+9313  U+7489  uni7489,  CJK UNIFIED IDEOGRAPH-7489
        0x74A6, # G+9314  U+74A6  uni74A6,  CJK UNIFIED IDEOGRAPH-74A6
        0x74D4, # G+9315  U+74D4  uni74D4,  CJK UNIFIED IDEOGRAPH-74D4
        0x74DA, # G+9316  U+74DA  uni74DA,  CJK UNIFIED IDEOGRAPH-74DA
        0x97D9, # G+9317  U+97D9  uni97D9,  CJK UNIFIED IDEOGRAPH-97D9
        0x97DE, # G+9318  U+97DE  uni97DE,  CJK UNIFIED IDEOGRAPH-97DE
        0x97DC, # G+9319  U+97DC  uni97DC,  CJK UNIFIED IDEOGRAPH-97DC
        0x69AA, # G+9320  U+69AA  uni69AA,  CJK UNIFIED IDEOGRAPH-69AA
        0x6AEA, # G+9321  U+6AEA  uni6AEA,  CJK UNIFIED IDEOGRAPH-6AEA
        0x6898, # G+9322  U+6898  uni6898,  CJK UNIFIED IDEOGRAPH-6898
        0x68D6, # G+9323  U+68D6  uni68D6,  CJK UNIFIED IDEOGRAPH-68D6
        0x6A05, # G+9324  U+6A05  uni6A05,  CJK UNIFIED IDEOGRAPH-6A05
        0x689F, # G+9325  U+689F  uni689F,  CJK UNIFIED IDEOGRAPH-689F
        0x6ADB, # G+9326  U+6ADB  uni6ADB,  CJK UNIFIED IDEOGRAPH-6ADB
        0x6AF3, # G+9327  U+6AF3  uni6AF3,  CJK UNIFIED IDEOGRAPH-6AF3
        0x6AE8, # G+9328  U+6AE8  uni6AE8,  CJK UNIFIED IDEOGRAPH-6AE8
        0x6ADF, # G+9329  U+6ADF  uni6ADF,  CJK UNIFIED IDEOGRAPH-6ADF
        0x6A89, # G+9330  U+6A89  uni6A89,  CJK UNIFIED IDEOGRAPH-6A89
        0x690F, # G+9331  U+690F  uni690F,  CJK UNIFIED IDEOGRAPH-690F
        0x6A48, # G+9332  U+6A48  uni6A48,  CJK UNIFIED IDEOGRAPH-6A48
        0x6968, # G+9333  U+6968  uni6968,  CJK UNIFIED IDEOGRAPH-6968
        0x69BF, # G+9334  U+69BF  uni69BF,  CJK UNIFIED IDEOGRAPH-69BF
        0x6A3A, # G+9335  U+6A3A  uni6A3A,  CJK UNIFIED IDEOGRAPH-6A3A
        0x6A9C, # G+9336  U+6A9C  uni6A9C,  CJK UNIFIED IDEOGRAPH-6A9C
        0x6B12, # G+9337  U+6B12  uni6B12,  CJK UNIFIED IDEOGRAPH-6B12
        0x6B1E, # G+9338  U+6B1E  uni6B1E,  CJK UNIFIED IDEOGRAPH-6B1E
        0x6ADD, # G+9339  U+6ADD  uni6ADD,  CJK UNIFIED IDEOGRAPH-6ADD
        0x69E7, # G+9340  U+69E7  uni69E7,  CJK UNIFIED IDEOGRAPH-69E7
        0x6B0F, # G+9341  U+6B0F  uni6B0F,  CJK UNIFIED IDEOGRAPH-6B0F
        0x6B16, # G+9342  U+6B16  uni6B16,  CJK UNIFIED IDEOGRAPH-6B16
        0x6AEC, # G+9343  U+6AEC  uni6AEC,  CJK UNIFIED IDEOGRAPH-6AEC
        0x6ADA, # G+9344  U+6ADA  uni6ADA,  CJK UNIFIED IDEOGRAPH-6ADA
        0x6AF8, # G+9345  U+6AF8  uni6AF8,  CJK UNIFIED IDEOGRAPH-6AF8
        0x6AB3, # G+9346  U+6AB3  uni6AB3,  CJK UNIFIED IDEOGRAPH-6AB3
        0x6AE7, # G+9347  U+6AE7  uni6AE7,  CJK UNIFIED IDEOGRAPH-6AE7
        0x6AA3, # G+9348  U+6AA3  uni6AA3,  CJK UNIFIED IDEOGRAPH-6AA3
        0x6AD3, # G+9349  U+6AD3  uni6AD3,  CJK UNIFIED IDEOGRAPH-6AD3
        0x6ADE, # G+9350  U+6ADE  uni6ADE,  CJK UNIFIED IDEOGRAPH-6ADE
        0x6BA4, # G+9351  U+6BA4  uni6BA4,  CJK UNIFIED IDEOGRAPH-6BA4
        0x6B9E, # G+9352  U+6B9E  uni6B9E,  CJK UNIFIED IDEOGRAPH-6B9E
        0x6BAE, # G+9353  U+6BAE  uni6BAE,  CJK UNIFIED IDEOGRAPH-6BAE
        0x6BAB, # G+9354  U+6BAB  uni6BAB,  CJK UNIFIED IDEOGRAPH-6BAB
        0x6BAF, # G+9355  U+6BAF  uni6BAF,  CJK UNIFIED IDEOGRAPH-6BAF
        0x8ED4, # G+9356  U+8ED4  uni8ED4,  CJK UNIFIED IDEOGRAPH-8ED4
        0x8EDB, # G+9357  U+8EDB  uni8EDB,  CJK UNIFIED IDEOGRAPH-8EDB
        0x8EF2, # G+9358  U+8EF2  uni8EF2,  CJK UNIFIED IDEOGRAPH-8EF2
        0x8EFB, # G+9359  U+8EFB  uni8EFB,  CJK UNIFIED IDEOGRAPH-8EFB
        0x8F64, # G+9360  U+8F64  uni8F64,  CJK UNIFIED IDEOGRAPH-8F64
        0x8EF9, # G+9361  U+8EF9  uni8EF9,  CJK UNIFIED IDEOGRAPH-8EF9
        0x8EFC, # G+9362  U+8EFC  uni8EFC,  CJK UNIFIED IDEOGRAPH-8EFC
        0x8EEB, # G+9363  U+8EEB  uni8EEB,  CJK UNIFIED IDEOGRAPH-8EEB
        0x8EE4, # G+9364  U+8EE4  uni8EE4,  CJK UNIFIED IDEOGRAPH-8EE4
        0x8F62, # G+9365  U+8F62  uni8F62,  CJK UNIFIED IDEOGRAPH-8F62
        0x8EFA, # G+9366  U+8EFA  uni8EFA,  CJK UNIFIED IDEOGRAPH-8EFA
        0x8EFE, # G+9367  U+8EFE  uni8EFE,  CJK UNIFIED IDEOGRAPH-8EFE
        0x8F0A, # G+9368  U+8F0A  uni8F0A,  CJK UNIFIED IDEOGRAPH-8F0A
        0x8F07, # G+9369  U+8F07  uni8F07,  CJK UNIFIED IDEOGRAPH-8F07
        0x8F05, # G+9370  U+8F05  uni8F05,  CJK UNIFIED IDEOGRAPH-8F05
        0x8F12, # G+9371  U+8F12  uni8F12,  CJK UNIFIED IDEOGRAPH-8F12
        0x8F26, # G+9372  U+8F26  uni8F26,  CJK UNIFIED IDEOGRAPH-8F26
        0x8F1E, # G+9373  U+8F1E  uni8F1E,  CJK UNIFIED IDEOGRAPH-8F1E
        0x8F1F, # G+9374  U+8F1F  uni8F1F,  CJK UNIFIED IDEOGRAPH-8F1F
        0x8F1C, # G+9375  U+8F1C  uni8F1C,  CJK UNIFIED IDEOGRAPH-8F1C
        0x8F33, # G+9376  U+8F33  uni8F33,  CJK UNIFIED IDEOGRAPH-8F33
        0x8F46, # G+9377  U+8F46  uni8F46,  CJK UNIFIED IDEOGRAPH-8F46
        0x8F54, # G+9378  U+8F54  uni8F54,  CJK UNIFIED IDEOGRAPH-8F54
        0x6214, # G+9379  U+6214  uni6214,  CJK UNIFIED IDEOGRAPH-6214
        0x6227, # G+9380  U+6227  uni6227,  CJK UNIFIED IDEOGRAPH-6227
        0x750C, # G+9381  U+750C  uni750C,  CJK UNIFIED IDEOGRAPH-750C
        0x66C7, # G+9382  U+66C7  uni66C7,  CJK UNIFIED IDEOGRAPH-66C7
        0x66C4, # G+9383  U+66C4  uni66C4,  CJK UNIFIED IDEOGRAPH-66C4
        0x6689, # G+9384  U+6689  uni6689,  CJK UNIFIED IDEOGRAPH-6689
        0x66D6, # G+9385  U+66D6  uni66D6,  CJK UNIFIED IDEOGRAPH-66D6
        0x8CC1, # G+9386  U+8CC1  uni8CC1,  CJK UNIFIED IDEOGRAPH-8CC1
        0x8CB0, # G+9387  U+8CB0  uni8CB0,  CJK UNIFIED IDEOGRAPH-8CB0
        0x8CBA, # G+9388  U+8CBA  uni8CBA,  CJK UNIFIED IDEOGRAPH-8CBA
        0x8CBD, # G+9389  U+8CBD  uni8CBD,  CJK UNIFIED IDEOGRAPH-8CBD
        0x8D04, # G+9390  U+8D04  uni8D04,  CJK UNIFIED IDEOGRAPH-8D04
        0x8CB2, # G+9391  U+8CB2  uni8CB2,  CJK UNIFIED IDEOGRAPH-8CB2
        0x8CC5, # G+9392  U+8CC5  uni8CC5,  CJK UNIFIED IDEOGRAPH-8CC5
        0x8D10, # G+9393  U+8D10  uni8D10,  CJK UNIFIED IDEOGRAPH-8D10
        0x8CD1, # G+9394  U+8CD1  uni8CD1,  CJK UNIFIED IDEOGRAPH-8CD1
        0x8CDA, # G+9395  U+8CDA  uni8CDA,  CJK UNIFIED IDEOGRAPH-8CDA
        0x8CD5, # G+9396  U+8CD5  uni8CD5,  CJK UNIFIED IDEOGRAPH-8CD5
        0x8CEB, # G+9397  U+8CEB  uni8CEB,  CJK UNIFIED IDEOGRAPH-8CEB
        0x8CE7, # G+9398  U+8CE7  uni8CE7,  CJK UNIFIED IDEOGRAPH-8CE7
        0x8CFB, # G+9399  U+8CFB  uni8CFB,  CJK UNIFIED IDEOGRAPH-8CFB
        0x8998, # G+9400  U+8998  uni8998,  CJK UNIFIED IDEOGRAPH-8998
        0x89AC, # G+9401  U+89AC  uni89AC,  CJK UNIFIED IDEOGRAPH-89AC
        0x89A1, # G+9402  U+89A1  uni89A1,  CJK UNIFIED IDEOGRAPH-89A1
        0x89BF, # G+9403  U+89BF  uni89BF,  CJK UNIFIED IDEOGRAPH-89BF
        0x89A6, # G+9404  U+89A6  uni89A6,  CJK UNIFIED IDEOGRAPH-89A6
        0x89AF, # G+9405  U+89AF  uni89AF,  CJK UNIFIED IDEOGRAPH-89AF
        0x89B2, # G+9406  U+89B2  uni89B2,  CJK UNIFIED IDEOGRAPH-89B2
        0x89B7, # G+9407  U+89B7  uni89B7,  CJK UNIFIED IDEOGRAPH-89B7
        0x6BFF, # G+9408  U+6BFF  uni6BFF,  CJK UNIFIED IDEOGRAPH-6BFF
        0x6C0C, # G+9409  U+6C0C  uni6C0C,  CJK UNIFIED IDEOGRAPH-6C0C
        0x6C2C, # G+9410  U+6C2C  uni6C2C,  CJK UNIFIED IDEOGRAPH-6C2C
        0x7258, # G+9411  U+7258  uni7258,  CJK UNIFIED IDEOGRAPH-7258
        0x6727, # G+9412  U+6727  uni6727,  CJK UNIFIED IDEOGRAPH-6727
        0x8156, # G+9413  U+8156  uni8156,  CJK UNIFIED IDEOGRAPH-8156
        0x81DA, # G+9414  U+81DA  uni81DA,  CJK UNIFIED IDEOGRAPH-81DA
        0x811B, # G+9415  U+811B  uni811B,  CJK UNIFIED IDEOGRAPH-811B
        0x81BE, # G+9416  U+81BE  uni81BE,  CJK UNIFIED IDEOGRAPH-81BE
        0x8161, # G+9417  U+8161  uni8161,  CJK UNIFIED IDEOGRAPH-8161
        0x81CF, # G+9418  U+81CF  uni81CF,  CJK UNIFIED IDEOGRAPH-81CF
        0x6B5F, # G+9419  U+6B5F  uni6B5F,  CJK UNIFIED IDEOGRAPH-6B5F
        0x98AE, # G+9420  U+98AE  uni98AE,  CJK UNIFIED IDEOGRAPH-98AE
        0x98AF, # G+9421  U+98AF  uni98AF,  CJK UNIFIED IDEOGRAPH-98AF
        0x98B6, # G+9422  U+98B6  uni98B6,  CJK UNIFIED IDEOGRAPH-98B6
        0x98BC, # G+9423  U+98BC  uni98BC,  CJK UNIFIED IDEOGRAPH-98BC
        0x98C6, # G+9424  U+98C6  uni98C6,  CJK UNIFIED IDEOGRAPH-98C6
        0x98C8, # G+9425  U+98C8  uni98C8,  CJK UNIFIED IDEOGRAPH-98C8
        0x8F42, # G+9426  U+8F42  uni8F42,  CJK UNIFIED IDEOGRAPH-8F42
        0x9F4F, # G+9427  U+9F4F  uni9F4F,  CJK UNIFIED IDEOGRAPH-9F4F
        0x6595, # G+9428  U+6595  uni6595,  CJK UNIFIED IDEOGRAPH-6595
        0x716C, # G+9429  U+716C  uni716C,  CJK UNIFIED IDEOGRAPH-716C
        0x7152, # G+9430  U+7152  uni7152,  CJK UNIFIED IDEOGRAPH-7152
        0x7197, # G+9431  U+7197  uni7197,  CJK UNIFIED IDEOGRAPH-7197
        0x71C1, # G+9432  U+71C1  uni71C1,  CJK UNIFIED IDEOGRAPH-71C1
        0x71DC, # G+9433  U+71DC  uni71DC,  CJK UNIFIED IDEOGRAPH-71DC
        0x71FE, # G+9434  U+71FE  uni71FE,  CJK UNIFIED IDEOGRAPH-71FE
        0x79B0, # G+9435  U+79B0  uni79B0,  CJK UNIFIED IDEOGRAPH-79B0
        0x798E, # G+9436  U+798E  uni798E,  CJK UNIFIED IDEOGRAPH-798E
        0x79AA, # G+9437  U+79AA  uni79AA,  CJK UNIFIED IDEOGRAPH-79AA
        0x61DF, # G+9438  U+61DF  uni61DF,  CJK UNIFIED IDEOGRAPH-61DF
        0x6164, # G+9439  U+6164  uni6164,  CJK UNIFIED IDEOGRAPH-6164
        0x61E3, # G+9440  U+61E3  uni61E3,  CJK UNIFIED IDEOGRAPH-61E3
        0x6207, # G+9441  U+6207  uni6207,  CJK UNIFIED IDEOGRAPH-6207
        0x6FA9, # G+9442  U+6FA9  uni6FA9,  CJK UNIFIED IDEOGRAPH-6FA9
        0x78EF, # G+9443  U+78EF  uni78EF,  CJK UNIFIED IDEOGRAPH-78EF
        0x78AD, # G+9444  U+78AD  uni78AD,  CJK UNIFIED IDEOGRAPH-78AD
        0x7868, # G+9445  U+7868  uni7868,  CJK UNIFIED IDEOGRAPH-7868
        0x78B8, # G+9446  U+78B8  uni78B8,  CJK UNIFIED IDEOGRAPH-78B8
        0x792A, # G+9447  U+792A  uni792A,  CJK UNIFIED IDEOGRAPH-792A
        0x7931, # G+9448  U+7931  uni7931,  CJK UNIFIED IDEOGRAPH-7931
        0x7864, # G+9449  U+7864  uni7864,  CJK UNIFIED IDEOGRAPH-7864
        0x78FD, # G+9450  U+78FD  uni78FD,  CJK UNIFIED IDEOGRAPH-78FD
        0x78E7, # G+9451  U+78E7  uni78E7,  CJK UNIFIED IDEOGRAPH-78E7
        0x78E3, # G+9452  U+78E3  uni78E3,  CJK UNIFIED IDEOGRAPH-78E3
        0x9F95, # G+9453  U+9F95  uni9F95,  CJK UNIFIED IDEOGRAPH-9F95
        0x7798, # G+9454  U+7798  uni7798,  CJK UNIFIED IDEOGRAPH-7798
        0x775E, # G+9455  U+775E  uni775E,  CJK UNIFIED IDEOGRAPH-775E
        0x77BC, # G+9456  U+77BC  uni77BC,  CJK UNIFIED IDEOGRAPH-77BC
        0x7F86, # G+9457  U+7F86  uni7F86,  CJK UNIFIED IDEOGRAPH-7F86
        0x7F88, # G+9458  U+7F88  uni7F88,  CJK UNIFIED IDEOGRAPH-7F88
        0x91D2, # G+9459  U+91D2  uni91D2,  CJK UNIFIED IDEOGRAPH-91D2
        0x91D3, # G+9460  U+91D3  uni91D3,  CJK UNIFIED IDEOGRAPH-91D3
        0x91D4, # G+9461  U+91D4  uni91D4,  CJK UNIFIED IDEOGRAPH-91D4
        0x91D9, # G+9462  U+91D9  uni91D9,  CJK UNIFIED IDEOGRAPH-91D9
        0x91D7, # G+9463  U+91D7  uni91D7,  CJK UNIFIED IDEOGRAPH-91D7
        0x91D5, # G+9464  U+91D5  uni91D5,  CJK UNIFIED IDEOGRAPH-91D5
        0x91F7, # G+9465  U+91F7  uni91F7,  CJK UNIFIED IDEOGRAPH-91F7
        0x91E7, # G+9466  U+91E7  uni91E7,  CJK UNIFIED IDEOGRAPH-91E7
        0x91E4, # G+9467  U+91E4  uni91E4,  CJK UNIFIED IDEOGRAPH-91E4
        0x9346, # G+9468  U+9346  uni9346,  CJK UNIFIED IDEOGRAPH-9346
        0x91F5, # G+9469  U+91F5  uni91F5,  CJK UNIFIED IDEOGRAPH-91F5
        0x91F9, # G+9470  U+91F9  uni91F9,  CJK UNIFIED IDEOGRAPH-91F9
        0x9208, # G+9471  U+9208  uni9208,  CJK UNIFIED IDEOGRAPH-9208
        0x9226, # G+9472  U+9226  uni9226,  CJK UNIFIED IDEOGRAPH-9226
        0x9245, # G+9473  U+9245  uni9245,  CJK UNIFIED IDEOGRAPH-9245
        0x9211, # G+9474  U+9211  uni9211,  CJK UNIFIED IDEOGRAPH-9211
        0x9210, # G+9475  U+9210  uni9210,  CJK UNIFIED IDEOGRAPH-9210
        0x9201, # G+9476  U+9201  uni9201,  CJK UNIFIED IDEOGRAPH-9201
        0x9227, # G+9477  U+9227  uni9227,  CJK UNIFIED IDEOGRAPH-9227
        0x9204, # G+9478  U+9204  uni9204,  CJK UNIFIED IDEOGRAPH-9204
        0x9225, # G+9479  U+9225  uni9225,  CJK UNIFIED IDEOGRAPH-9225
        0x9200, # G+9480  U+9200  uni9200,  CJK UNIFIED IDEOGRAPH-9200
        0x923A, # G+9481  U+923A  uni923A,  CJK UNIFIED IDEOGRAPH-923A
        0x9266, # G+9482  U+9266  uni9266,  CJK UNIFIED IDEOGRAPH-9266
        0x9237, # G+9483  U+9237  uni9237,  CJK UNIFIED IDEOGRAPH-9237
        0x9233, # G+9484  U+9233  uni9233,  CJK UNIFIED IDEOGRAPH-9233
        0x9255, # G+9485  U+9255  uni9255,  CJK UNIFIED IDEOGRAPH-9255
        0x923D, # G+9486  U+923D  uni923D,  CJK UNIFIED IDEOGRAPH-923D
        0x9238, # G+9487  U+9238  uni9238,  CJK UNIFIED IDEOGRAPH-9238
        0x925E, # G+9488  U+925E  uni925E,  CJK UNIFIED IDEOGRAPH-925E
        0x926C, # G+9489  U+926C  uni926C,  CJK UNIFIED IDEOGRAPH-926C
        0x926D, # G+9490  U+926D  uni926D,  CJK UNIFIED IDEOGRAPH-926D
        0x923F, # G+9491  U+923F  uni923F,  CJK UNIFIED IDEOGRAPH-923F
        0x9460, # G+9492  U+9460  uni9460,  CJK UNIFIED IDEOGRAPH-9460
        0x9230, # G+9493  U+9230  uni9230,  CJK UNIFIED IDEOGRAPH-9230
        0x9249, # G+9494  U+9249  uni9249,  CJK UNIFIED IDEOGRAPH-9249
        0x9248, # G+9495  U+9248  uni9248,  CJK UNIFIED IDEOGRAPH-9248
        0x924D, # G+9496  U+924D  uni924D,  CJK UNIFIED IDEOGRAPH-924D
        0x922E, # G+9497  U+922E  uni922E,  CJK UNIFIED IDEOGRAPH-922E
        0x9239, # G+9498  U+9239  uni9239,  CJK UNIFIED IDEOGRAPH-9239
        0x9438, # G+9499  U+9438  uni9438,  CJK UNIFIED IDEOGRAPH-9438
        0x92AC, # G+9500  U+92AC  uni92AC,  CJK UNIFIED IDEOGRAPH-92AC
        0x92A0, # G+9501  U+92A0  uni92A0,  CJK UNIFIED IDEOGRAPH-92A0
        0x927A, # G+9502  U+927A  uni927A,  CJK UNIFIED IDEOGRAPH-927A
        0x92AA, # G+9503  U+92AA  uni92AA,  CJK UNIFIED IDEOGRAPH-92AA
        0x92EE, # G+9504  U+92EE  uni92EE,  CJK UNIFIED IDEOGRAPH-92EE
        0x92CF, # G+9505  U+92CF  uni92CF,  CJK UNIFIED IDEOGRAPH-92CF
        0x9403, # G+9506  U+9403  uni9403,  CJK UNIFIED IDEOGRAPH-9403
        0x92E3, # G+9507  U+92E3  uni92E3,  CJK UNIFIED IDEOGRAPH-92E3
        0x943A, # G+9508  U+943A  uni943A,  CJK UNIFIED IDEOGRAPH-943A
        0x92B1, # G+9509  U+92B1  uni92B1,  CJK UNIFIED IDEOGRAPH-92B1
        0x92A6, # G+9510  U+92A6  uni92A6,  CJK UNIFIED IDEOGRAPH-92A6
        0x93A7, # G+9511  U+93A7  uni93A7,  CJK UNIFIED IDEOGRAPH-93A7
        0x9296, # G+9512  U+9296  uni9296,  CJK UNIFIED IDEOGRAPH-9296
        0x92CC, # G+9513  U+92CC  uni92CC,  CJK UNIFIED IDEOGRAPH-92CC
        0x92A9, # G+9514  U+92A9  uni92A9,  CJK UNIFIED IDEOGRAPH-92A9
        0x93F5, # G+9515  U+93F5  uni93F5,  CJK UNIFIED IDEOGRAPH-93F5
        0x9293, # G+9516  U+9293  uni9293,  CJK UNIFIED IDEOGRAPH-9293
        0x927F, # G+9517  U+927F  uni927F,  CJK UNIFIED IDEOGRAPH-927F
        0x93A9, # G+9518  U+93A9  uni93A9,  CJK UNIFIED IDEOGRAPH-93A9
        0x929A, # G+9519  U+929A  uni929A,  CJK UNIFIED IDEOGRAPH-929A
        0x931A, # G+9520  U+931A  uni931A,  CJK UNIFIED IDEOGRAPH-931A
        0x92AB, # G+9521  U+92AB  uni92AB,  CJK UNIFIED IDEOGRAPH-92AB
        0x9283, # G+9522  U+9283  uni9283,  CJK UNIFIED IDEOGRAPH-9283
        0x940B, # G+9523  U+940B  uni940B,  CJK UNIFIED IDEOGRAPH-940B
        0x92A8, # G+9524  U+92A8  uni92A8,  CJK UNIFIED IDEOGRAPH-92A8
        0x92A3, # G+9525  U+92A3  uni92A3,  CJK UNIFIED IDEOGRAPH-92A3
        0x9412, # G+9526  U+9412  uni9412,  CJK UNIFIED IDEOGRAPH-9412
        0x9338, # G+9527  U+9338  uni9338,  CJK UNIFIED IDEOGRAPH-9338
        0x92F1, # G+9528  U+92F1  uni92F1,  CJK UNIFIED IDEOGRAPH-92F1
        0x93D7, # G+9529  U+93D7  uni93D7,  CJK UNIFIED IDEOGRAPH-93D7
        0x92E5, # G+9530  U+92E5  uni92E5,  CJK UNIFIED IDEOGRAPH-92E5
        0x92F0, # G+9531  U+92F0  uni92F0,  CJK UNIFIED IDEOGRAPH-92F0
        0x92EF, # G+9532  U+92EF  uni92EF,  CJK UNIFIED IDEOGRAPH-92EF
        0x92E8, # G+9533  U+92E8  uni92E8,  CJK UNIFIED IDEOGRAPH-92E8
        0x92BC, # G+9534  U+92BC  uni92BC,  CJK UNIFIED IDEOGRAPH-92BC
        0x92DD, # G+9535  U+92DD  uni92DD,  CJK UNIFIED IDEOGRAPH-92DD
        0x92F6, # G+9536  U+92F6  uni92F6,  CJK UNIFIED IDEOGRAPH-92F6
        0x9426, # G+9537  U+9426  uni9426,  CJK UNIFIED IDEOGRAPH-9426
        0x9427, # G+9538  U+9427  uni9427,  CJK UNIFIED IDEOGRAPH-9427
        0x92C3, # G+9539  U+92C3  uni92C3,  CJK UNIFIED IDEOGRAPH-92C3
        0x92DF, # G+9540  U+92DF  uni92DF,  CJK UNIFIED IDEOGRAPH-92DF
        0x92E6, # G+9541  U+92E6  uni92E6,  CJK UNIFIED IDEOGRAPH-92E6
        0x9312, # G+9542  U+9312  uni9312,  CJK UNIFIED IDEOGRAPH-9312
        0x9306, # G+9543  U+9306  uni9306,  CJK UNIFIED IDEOGRAPH-9306
        0x9369, # G+9544  U+9369  uni9369,  CJK UNIFIED IDEOGRAPH-9369
        0x931B, # G+9545  U+931B  uni931B,  CJK UNIFIED IDEOGRAPH-931B
        0x9340, # G+9546  U+9340  uni9340,  CJK UNIFIED IDEOGRAPH-9340
        0x9301, # G+9547  U+9301  uni9301,  CJK UNIFIED IDEOGRAPH-9301
        0x9315, # G+9548  U+9315  uni9315,  CJK UNIFIED IDEOGRAPH-9315
        0x932E, # G+9549  U+932E  uni932E,  CJK UNIFIED IDEOGRAPH-932E
        0x9343, # G+9550  U+9343  uni9343,  CJK UNIFIED IDEOGRAPH-9343
        0x9307, # G+9551  U+9307  uni9307,  CJK UNIFIED IDEOGRAPH-9307
        0x9308, # G+9552  U+9308  uni9308,  CJK UNIFIED IDEOGRAPH-9308
        0x931F, # G+9553  U+931F  uni931F,  CJK UNIFIED IDEOGRAPH-931F
        0x9319, # G+9554  U+9319  uni9319,  CJK UNIFIED IDEOGRAPH-9319
        0x9365, # G+9555  U+9365  uni9365,  CJK UNIFIED IDEOGRAPH-9365
        0x9347, # G+9556  U+9347  uni9347,  CJK UNIFIED IDEOGRAPH-9347
        0x9376, # G+9557  U+9376  uni9376,  CJK UNIFIED IDEOGRAPH-9376
        0x9354, # G+9558  U+9354  uni9354,  CJK UNIFIED IDEOGRAPH-9354
        0x9364, # G+9559  U+9364  uni9364,  CJK UNIFIED IDEOGRAPH-9364
        0x93AA, # G+9560  U+93AA  uni93AA,  CJK UNIFIED IDEOGRAPH-93AA
        0x9370, # G+9561  U+9370  uni9370,  CJK UNIFIED IDEOGRAPH-9370
        0x9384, # G+9562  U+9384  uni9384,  CJK UNIFIED IDEOGRAPH-9384
        0x93E4, # G+9563  U+93E4  uni93E4,  CJK UNIFIED IDEOGRAPH-93E4
        0x93D8, # G+9564  U+93D8  uni93D8,  CJK UNIFIED IDEOGRAPH-93D8
        0x9428, # G+9565  U+9428  uni9428,  CJK UNIFIED IDEOGRAPH-9428
        0x9387, # G+9566  U+9387  uni9387,  CJK UNIFIED IDEOGRAPH-9387
        0x93CC, # G+9567  U+93CC  uni93CC,  CJK UNIFIED IDEOGRAPH-93CC
        0x9398, # G+9568  U+9398  uni9398,  CJK UNIFIED IDEOGRAPH-9398
        0x93B8, # G+9569  U+93B8  uni93B8,  CJK UNIFIED IDEOGRAPH-93B8
        0x93BF, # G+9570  U+93BF  uni93BF,  CJK UNIFIED IDEOGRAPH-93BF
        0x93A6, # G+9571  U+93A6  uni93A6,  CJK UNIFIED IDEOGRAPH-93A6
        0x93B0, # G+9572  U+93B0  uni93B0,  CJK UNIFIED IDEOGRAPH-93B0
        0x93B5, # G+9573  U+93B5  uni93B5,  CJK UNIFIED IDEOGRAPH-93B5
        0x944C, # G+9574  U+944C  uni944C,  CJK UNIFIED IDEOGRAPH-944C
        0x93E2, # G+9575  U+93E2  uni93E2,  CJK UNIFIED IDEOGRAPH-93E2
        0x93DC, # G+9576  U+93DC  uni93DC,  CJK UNIFIED IDEOGRAPH-93DC
        0x93DD, # G+9577  U+93DD  uni93DD,  CJK UNIFIED IDEOGRAPH-93DD
        0x93CD, # G+9578  U+93CD  uni93CD,  CJK UNIFIED IDEOGRAPH-93CD
        0x93DE, # G+9579  U+93DE  uni93DE,  CJK UNIFIED IDEOGRAPH-93DE
        0x93C3, # G+9580  U+93C3  uni93C3,  CJK UNIFIED IDEOGRAPH-93C3
        0x93C7, # G+9581  U+93C7  uni93C7,  CJK UNIFIED IDEOGRAPH-93C7
        0x93D1, # G+9582  U+93D1  uni93D1,  CJK UNIFIED IDEOGRAPH-93D1
        0x9414, # G+9583  U+9414  uni9414,  CJK UNIFIED IDEOGRAPH-9414
        0x941D, # G+9584  U+941D  uni941D,  CJK UNIFIED IDEOGRAPH-941D
        0x93F7, # G+9585  U+93F7  uni93F7,  CJK UNIFIED IDEOGRAPH-93F7
        0x9465, # G+9586  U+9465  uni9465,  CJK UNIFIED IDEOGRAPH-9465
        0x9413, # G+9587  U+9413  uni9413,  CJK UNIFIED IDEOGRAPH-9413
        0x946D, # G+9588  U+946D  uni946D,  CJK UNIFIED IDEOGRAPH-946D
        0x9420, # G+9589  U+9420  uni9420,  CJK UNIFIED IDEOGRAPH-9420
        0x9479, # G+9590  U+9479  uni9479,  CJK UNIFIED IDEOGRAPH-9479
        0x93F9, # G+9591  U+93F9  uni93F9,  CJK UNIFIED IDEOGRAPH-93F9
        0x9419, # G+9592  U+9419  uni9419,  CJK UNIFIED IDEOGRAPH-9419
        0x944A, # G+9593  U+944A  uni944A,  CJK UNIFIED IDEOGRAPH-944A
        0x9432, # G+9594  U+9432  uni9432,  CJK UNIFIED IDEOGRAPH-9432
        0x943F, # G+9595  U+943F  uni943F,  CJK UNIFIED IDEOGRAPH-943F
        0x9454, # G+9596  U+9454  uni9454,  CJK UNIFIED IDEOGRAPH-9454
        0x9463, # G+9597  U+9463  uni9463,  CJK UNIFIED IDEOGRAPH-9463
        0x937E, # G+9598  U+937E  uni937E,  CJK UNIFIED IDEOGRAPH-937E
        0x7A61, # G+9599  U+7A61  uni7A61,  CJK UNIFIED IDEOGRAPH-7A61
        0x9CE9, # G+9600  U+9CE9  uni9CE9,  CJK UNIFIED IDEOGRAPH-9CE9
        0x9CF6, # G+9601  U+9CF6  uni9CF6,  CJK UNIFIED IDEOGRAPH-9CF6
        0x9D07, # G+9602  U+9D07  uni9D07,  CJK UNIFIED IDEOGRAPH-9D07
        0x9D06, # G+9603  U+9D06  uni9D06,  CJK UNIFIED IDEOGRAPH-9D06
        0x9D23, # G+9604  U+9D23  uni9D23,  CJK UNIFIED IDEOGRAPH-9D23
        0x9D87, # G+9605  U+9D87  uni9D87,  CJK UNIFIED IDEOGRAPH-9D87
        0x9E15, # G+9606  U+9E15  uni9E15,  CJK UNIFIED IDEOGRAPH-9E15
        0x9D1D, # G+9607  U+9D1D  uni9D1D,  CJK UNIFIED IDEOGRAPH-9D1D
        0x9D1F, # G+9608  U+9D1F  uni9D1F,  CJK UNIFIED IDEOGRAPH-9D1F
        0x9DE5, # G+9609  U+9DE5  uni9DE5,  CJK UNIFIED IDEOGRAPH-9DE5
        0x9D2F, # G+9610  U+9D2F  uni9D2F,  CJK UNIFIED IDEOGRAPH-9D2F
        0x9DD9, # G+9611  U+9DD9  uni9DD9,  CJK UNIFIED IDEOGRAPH-9DD9
        0x9D30, # G+9612  U+9D30  uni9D30,  CJK UNIFIED IDEOGRAPH-9D30
        0x9D42, # G+9613  U+9D42  uni9D42,  CJK UNIFIED IDEOGRAPH-9D42
        0x9E1E, # G+9614  U+9E1E  uni9E1E,  CJK UNIFIED IDEOGRAPH-9E1E
        0x9D53, # G+9615  U+9D53  uni9D53,  CJK UNIFIED IDEOGRAPH-9D53
        0x9E1D, # G+9616  U+9E1D  uni9E1D,  CJK UNIFIED IDEOGRAPH-9E1D
        0x9D60, # G+9617  U+9D60  uni9D60,  CJK UNIFIED IDEOGRAPH-9D60
        0x9D52, # G+9618  U+9D52  uni9D52,  CJK UNIFIED IDEOGRAPH-9D52
        0x9DF3, # G+9619  U+9DF3  uni9DF3,  CJK UNIFIED IDEOGRAPH-9DF3
        0x9D5C, # G+9620  U+9D5C  uni9D5C,  CJK UNIFIED IDEOGRAPH-9D5C
        0x9D61, # G+9621  U+9D61  uni9D61,  CJK UNIFIED IDEOGRAPH-9D61
        0x9D93, # G+9622  U+9D93  uni9D93,  CJK UNIFIED IDEOGRAPH-9D93
        0x9D6A, # G+9623  U+9D6A  uni9D6A,  CJK UNIFIED IDEOGRAPH-9D6A
        0x9D6F, # G+9624  U+9D6F  uni9D6F,  CJK UNIFIED IDEOGRAPH-9D6F
        0x9D89, # G+9625  U+9D89  uni9D89,  CJK UNIFIED IDEOGRAPH-9D89
        0x9D98, # G+9626  U+9D98  uni9D98,  CJK UNIFIED IDEOGRAPH-9D98
        0x9D9A, # G+9627  U+9D9A  uni9D9A,  CJK UNIFIED IDEOGRAPH-9D9A
        0x9DC0, # G+9628  U+9DC0  uni9DC0,  CJK UNIFIED IDEOGRAPH-9DC0
        0x9DA5, # G+9629  U+9DA5  uni9DA5,  CJK UNIFIED IDEOGRAPH-9DA5
        0x9DA9, # G+9630  U+9DA9  uni9DA9,  CJK UNIFIED IDEOGRAPH-9DA9
        0x9DC2, # G+9631  U+9DC2  uni9DC2,  CJK UNIFIED IDEOGRAPH-9DC2
        0x9DBC, # G+9632  U+9DBC  uni9DBC,  CJK UNIFIED IDEOGRAPH-9DBC
        0x9E1A, # G+9633  U+9E1A  uni9E1A,  CJK UNIFIED IDEOGRAPH-9E1A
        0x9DD3, # G+9634  U+9DD3  uni9DD3,  CJK UNIFIED IDEOGRAPH-9DD3
        0x9DDA, # G+9635  U+9DDA  uni9DDA,  CJK UNIFIED IDEOGRAPH-9DDA
        0x9DEF, # G+9636  U+9DEF  uni9DEF,  CJK UNIFIED IDEOGRAPH-9DEF
        0x9DE6, # G+9637  U+9DE6  uni9DE6,  CJK UNIFIED IDEOGRAPH-9DE6
        0x9DF2, # G+9638  U+9DF2  uni9DF2,  CJK UNIFIED IDEOGRAPH-9DF2
        0x9DF8, # G+9639  U+9DF8  uni9DF8,  CJK UNIFIED IDEOGRAPH-9DF8
        0x9E0C, # G+9640  U+9E0C  uni9E0C,  CJK UNIFIED IDEOGRAPH-9E0C
        0x9DFA, # G+9641  U+9DFA  uni9DFA,  CJK UNIFIED IDEOGRAPH-9DFA
        0x9E1B, # G+9642  U+9E1B  uni9E1B,  CJK UNIFIED IDEOGRAPH-9E1B
        0x7664, # G+9643  U+7664  uni7664,  CJK UNIFIED IDEOGRAPH-7664
        0x7658, # G+9644  U+7658  uni7658,  CJK UNIFIED IDEOGRAPH-7658
        0x7667, # G+9645  U+7667  uni7667,  CJK UNIFIED IDEOGRAPH-7667
        0x7602, # G+9646  U+7602  uni7602,  CJK UNIFIED IDEOGRAPH-7602
        0x7646, # G+9647  U+7646  uni7646,  CJK UNIFIED IDEOGRAPH-7646
        0x7647, # G+9648  U+7647  uni7647,  CJK UNIFIED IDEOGRAPH-7647
        0x7649, # G+9649  U+7649  uni7649,  CJK UNIFIED IDEOGRAPH-7649
        0x761E, # G+9650  U+761E  uni761E,  CJK UNIFIED IDEOGRAPH-761E
        0x763B, # G+9651  U+763B  uni763B,  CJK UNIFIED IDEOGRAPH-763B
        0x766D, # G+9652  U+766D  uni766D,  CJK UNIFIED IDEOGRAPH-766D
        0x766E, # G+9653  U+766E  uni766E,  CJK UNIFIED IDEOGRAPH-766E
        0x7669, # G+9654  U+7669  uni7669,  CJK UNIFIED IDEOGRAPH-7669
        0x7672, # G+9655  U+7672  uni7672,  CJK UNIFIED IDEOGRAPH-7672
        0x7AC7, # G+9656  U+7AC7  uni7AC7,  CJK UNIFIED IDEOGRAPH-7AC7
        0x7AB6, # G+9657  U+7AB6  uni7AB6,  CJK UNIFIED IDEOGRAPH-7AB6
        0x8960, # G+9658  U+8960  uni8960,  CJK UNIFIED IDEOGRAPH-8960
        0x8933, # G+9659  U+8933  uni8933,  CJK UNIFIED IDEOGRAPH-8933
        0x895D, # G+9660  U+895D  uni895D,  CJK UNIFIED IDEOGRAPH-895D
        0x8947, # G+9661  U+8947  uni8947,  CJK UNIFIED IDEOGRAPH-8947
        0x8938, # G+9662  U+8938  uni8938,  CJK UNIFIED IDEOGRAPH-8938
        0x8964, # G+9663  U+8964  uni8964,  CJK UNIFIED IDEOGRAPH-8964
        0x76B8, # G+9664  U+76B8  uni76B8,  CJK UNIFIED IDEOGRAPH-76B8
        0x802E, # G+9665  U+802E  uni802E,  CJK UNIFIED IDEOGRAPH-802E
        0x802C, # G+9666  U+802C  uni802C,  CJK UNIFIED IDEOGRAPH-802C
        0x8079, # G+9667  U+8079  uni8079,  CJK UNIFIED IDEOGRAPH-8079
        0x8075, # G+9668  U+8075  uni8075,  CJK UNIFIED IDEOGRAPH-8075
        0x9807, # G+9669  U+9807  uni9807,  CJK UNIFIED IDEOGRAPH-9807
        0x980E, # G+9670  U+980E  uni980E,  CJK UNIFIED IDEOGRAPH-980E
        0x980F, # G+9671  U+980F  uni980F,  CJK UNIFIED IDEOGRAPH-980F
        0x9821, # G+9672  U+9821  uni9821,  CJK UNIFIED IDEOGRAPH-9821
        0x981C, # G+9673  U+981C  uni981C,  CJK UNIFIED IDEOGRAPH-981C
        0x6F41, # G+9674  U+6F41  uni6F41,  CJK UNIFIED IDEOGRAPH-6F41
        0x9826, # G+9675  U+9826  uni9826,  CJK UNIFIED IDEOGRAPH-9826
        0x9837, # G+9676  U+9837  uni9837,  CJK UNIFIED IDEOGRAPH-9837
        0x984E, # G+9677  U+984E  uni984E,  CJK UNIFIED IDEOGRAPH-984E
        0x9853, # G+9678  U+9853  uni9853,  CJK UNIFIED IDEOGRAPH-9853
        0x9873, # G+9679  U+9873  uni9873,  CJK UNIFIED IDEOGRAPH-9873
        0x9862, # G+9680  U+9862  uni9862,  CJK UNIFIED IDEOGRAPH-9862
        0x9859, # G+9681  U+9859  uni9859,  CJK UNIFIED IDEOGRAPH-9859
        0x9865, # G+9682  U+9865  uni9865,  CJK UNIFIED IDEOGRAPH-9865
        0x986C, # G+9683  U+986C  uni986C,  CJK UNIFIED IDEOGRAPH-986C
        0x9870, # G+9684  U+9870  uni9870,  CJK UNIFIED IDEOGRAPH-9870
        0x87E3, # G+9685  U+87E3  uni87E3,  CJK UNIFIED IDEOGRAPH-87E3
        0x8806, # G+9686  U+8806  uni8806,  CJK UNIFIED IDEOGRAPH-8806
        0x8706, # G+9687  U+8706  uni8706,  CJK UNIFIED IDEOGRAPH-8706
        0x8823, # G+9688  U+8823  uni8823,  CJK UNIFIED IDEOGRAPH-8823
        0x87F6, # G+9689  U+87F6  uni87F6,  CJK UNIFIED IDEOGRAPH-87F6
        0x86FA, # G+9690  U+86FA  uni86FA,  CJK UNIFIED IDEOGRAPH-86FA
        0x87EF, # G+9691  U+87EF  uni87EF,  CJK UNIFIED IDEOGRAPH-87EF
        0x8784, # G+9692  U+8784  uni8784,  CJK UNIFIED IDEOGRAPH-8784
        0x8810, # G+9693  U+8810  uni8810,  CJK UNIFIED IDEOGRAPH-8810
        0x87C8, # G+9694  U+87C8  uni87C8,  CJK UNIFIED IDEOGRAPH-87C8
        0x8811, # G+9695  U+8811  uni8811,  CJK UNIFIED IDEOGRAPH-8811
        0x87BB, # G+9696  U+87BB  uni87BB,  CJK UNIFIED IDEOGRAPH-87BB
        0x87CE, # G+9697  U+87CE  uni87CE,  CJK UNIFIED IDEOGRAPH-87CE
        0x7F4C, # G+9698  U+7F4C  uni7F4C,  CJK UNIFIED IDEOGRAPH-7F4C
        0x7BE4, # G+9699  U+7BE4  uni7BE4,  CJK UNIFIED IDEOGRAPH-7BE4
        0x7B67, # G+9700  U+7B67  uni7B67,  CJK UNIFIED IDEOGRAPH-7B67
        0x7C69, # G+9701  U+7C69  uni7C69,  CJK UNIFIED IDEOGRAPH-7C69
        0x7BF3, # G+9702  U+7BF3  uni7BF3,  CJK UNIFIED IDEOGRAPH-7BF3
        0x7C00, # G+9703  U+7C00  uni7C00,  CJK UNIFIED IDEOGRAPH-7C00
        0x7BCB, # G+9704  U+7BCB  uni7BCB,  CJK UNIFIED IDEOGRAPH-7BCB
        0x7C5C, # G+9705  U+7C5C  uni7C5C,  CJK UNIFIED IDEOGRAPH-7C5C
        0x7C1E, # G+9706  U+7C1E  uni7C1E,  CJK UNIFIED IDEOGRAPH-7C1E
        0x7C2B, # G+9707  U+7C2B  uni7C2B,  CJK UNIFIED IDEOGRAPH-7C2B
        0x7C23, # G+9708  U+7C23  uni7C23,  CJK UNIFIED IDEOGRAPH-7C23
        0x7C6A, # G+9709  U+7C6A  uni7C6A,  CJK UNIFIED IDEOGRAPH-7C6A
        0x7C5F, # G+9710  U+7C5F  uni7C5F,  CJK UNIFIED IDEOGRAPH-7C5F
        0x8264, # G+9711  U+8264  uni8264,  CJK UNIFIED IDEOGRAPH-8264
        0x826B, # G+9712  U+826B  uni826B,  CJK UNIFIED IDEOGRAPH-826B
        0x88CA, # G+9713  U+88CA  uni88CA,  CJK UNIFIED IDEOGRAPH-88CA
        0x7FA5, # G+9714  U+7FA5  uni7FA5,  CJK UNIFIED IDEOGRAPH-7FA5
        0x7CF2, # G+9715  U+7CF2  uni7CF2,  CJK UNIFIED IDEOGRAPH-7CF2
        0x7CF6, # G+9716  U+7CF6  uni7CF6,  CJK UNIFIED IDEOGRAPH-7CF6
        0x7CDD, # G+9717  U+7CDD  uni7CDD,  CJK UNIFIED IDEOGRAPH-7CDD
        0x7E36, # G+9718  U+7E36  uni7E36,  CJK UNIFIED IDEOGRAPH-7E36
        0x9EA9, # G+9719  U+9EA9  uni9EA9,  CJK UNIFIED IDEOGRAPH-9EA9
        0x8DB2, # G+9720  U+8DB2  uni8DB2,  CJK UNIFIED IDEOGRAPH-8DB2
        0x91C5, # G+9721  U+91C5  uni91C5,  CJK UNIFIED IDEOGRAPH-91C5
        0x91C3, # G+9722  U+91C3  uni91C3,  CJK UNIFIED IDEOGRAPH-91C3
        0x9E7A, # G+9723  U+9E7A  uni9E7A,  CJK UNIFIED IDEOGRAPH-9E7A
        0x8E89, # G+9724  U+8E89  uni8E89,  CJK UNIFIED IDEOGRAPH-8E89
        0x8E4C, # G+9725  U+8E4C  uni8E4C,  CJK UNIFIED IDEOGRAPH-8E4C
        0x8E92, # G+9726  U+8E92  uni8E92,  CJK UNIFIED IDEOGRAPH-8E92
        0x8E7A, # G+9727  U+8E7A  uni8E7A,  CJK UNIFIED IDEOGRAPH-8E7A
        0x8E55, # G+9728  U+8E55  uni8E55,  CJK UNIFIED IDEOGRAPH-8E55
        0x8E9A, # G+9729  U+8E9A  uni8E9A,  CJK UNIFIED IDEOGRAPH-8E9A
        0x8E8B, # G+9730  U+8E8B  uni8E8B,  CJK UNIFIED IDEOGRAPH-8E8B
        0x8E93, # G+9731  U+8E93  uni8E93,  CJK UNIFIED IDEOGRAPH-8E93
        0x8E91, # G+9732  U+8E91  uni8E91,  CJK UNIFIED IDEOGRAPH-8E91
        0x8EA1, # G+9733  U+8EA1  uni8EA1,  CJK UNIFIED IDEOGRAPH-8EA1
        0x8E63, # G+9734  U+8E63  uni8E63,  CJK UNIFIED IDEOGRAPH-8E63
        0x8EAA, # G+9735  U+8EAA  uni8EAA,  CJK UNIFIED IDEOGRAPH-8EAA
        0x8EA6, # G+9736  U+8EA6  uni8EA6,  CJK UNIFIED IDEOGRAPH-8EA6
        0x89F4, # G+9737  U+89F4  uni89F4,  CJK UNIFIED IDEOGRAPH-89F4
        0x89F6, # G+9738  U+89F6  uni89F6,  CJK UNIFIED IDEOGRAPH-89F6
        0x975A, # G+9739  U+975A  uni975A,  CJK UNIFIED IDEOGRAPH-975A
        0x9742, # G+9740  U+9742  uni9742,  CJK UNIFIED IDEOGRAPH-9742
        0x973D, # G+9741  U+973D  uni973D,  CJK UNIFIED IDEOGRAPH-973D
        0x9744, # G+9742  U+9744  uni9744,  CJK UNIFIED IDEOGRAPH-9744
        0x9F54, # G+9743  U+9F54  uni9F54,  CJK UNIFIED IDEOGRAPH-9F54
        0x9F5F, # G+9744  U+9F5F  uni9F5F,  CJK UNIFIED IDEOGRAPH-9F5F
        0x9F59, # G+9745  U+9F59  uni9F59,  CJK UNIFIED IDEOGRAPH-9F59
        0x9F60, # G+9746  U+9F60  uni9F60,  CJK UNIFIED IDEOGRAPH-9F60
        0x9F5C, # G+9747  U+9F5C  uni9F5C,  CJK UNIFIED IDEOGRAPH-9F5C
        0x9F66, # G+9748  U+9F66  uni9F66,  CJK UNIFIED IDEOGRAPH-9F66
        0x9F6C, # G+9749  U+9F6C  uni9F6C,  CJK UNIFIED IDEOGRAPH-9F6C
        0x9F6A, # G+9750  U+9F6A  uni9F6A,  CJK UNIFIED IDEOGRAPH-9F6A
        0x9F77, # G+9751  U+9F77  uni9F77,  CJK UNIFIED IDEOGRAPH-9F77
        0x2FCC, # G+9752  U+2FCC  uni2FCC,  KANGXI RADICAL FROG
        0x9EFF, # G+9753  U+9EFF  uni9EFF,  CJK UNIFIED IDEOGRAPH-9EFF
        0x9F09, # G+9754  U+9F09  uni9F09,  CJK UNIFIED IDEOGRAPH-9F09
        0x8B8E, # G+9755  U+8B8E  uni8B8E,  CJK UNIFIED IDEOGRAPH-8B8E
        0x947E, # G+9756  U+947E  uni947E,  CJK UNIFIED IDEOGRAPH-947E
        0x93E8, # G+9757  U+93E8  uni93E8,  CJK UNIFIED IDEOGRAPH-93E8
        0x9B77, # G+9758  U+9B77  uni9B77,  CJK UNIFIED IDEOGRAPH-9B77
        0x9B74, # G+9759  U+9B74  uni9B74,  CJK UNIFIED IDEOGRAPH-9B74
        0x9B81, # G+9760  U+9B81  uni9B81,  CJK UNIFIED IDEOGRAPH-9B81
        0x9B83, # G+9761  U+9B83  uni9B83,  CJK UNIFIED IDEOGRAPH-9B83
        0x9B8E, # G+9762  U+9B8E  uni9B8E,  CJK UNIFIED IDEOGRAPH-9B8E
        0x9C78, # G+9763  U+9C78  uni9C78,  CJK UNIFIED IDEOGRAPH-9C78
        0x7A4C, # G+9764  U+7A4C  uni7A4C,  CJK UNIFIED IDEOGRAPH-7A4C
        0x9B92, # G+9765  U+9B92  uni9B92,  CJK UNIFIED IDEOGRAPH-9B92
        0x9C5F, # G+9766  U+9C5F  uni9C5F,  CJK UNIFIED IDEOGRAPH-9C5F
        0x9B90, # G+9767  U+9B90  uni9B90,  CJK UNIFIED IDEOGRAPH-9B90
        0x9BAD, # G+9768  U+9BAD  uni9BAD,  CJK UNIFIED IDEOGRAPH-9BAD
        0x9B9A, # G+9769  U+9B9A  uni9B9A,  CJK UNIFIED IDEOGRAPH-9B9A
        0x9BAA, # G+9770  U+9BAA  uni9BAA,  CJK UNIFIED IDEOGRAPH-9BAA
        0x9B9E, # G+9771  U+9B9E  uni9B9E,  CJK UNIFIED IDEOGRAPH-9B9E
        0x9C6D, # G+9772  U+9C6D  uni9C6D,  CJK UNIFIED IDEOGRAPH-9C6D
        0x9BAB, # G+9773  U+9BAB  uni9BAB,  CJK UNIFIED IDEOGRAPH-9BAB
        0x9B9D, # G+9774  U+9B9D  uni9B9D,  CJK UNIFIED IDEOGRAPH-9B9D
        0x9C58, # G+9775  U+9C58  uni9C58,  CJK UNIFIED IDEOGRAPH-9C58
        0x9BC1, # G+9776  U+9BC1  uni9BC1,  CJK UNIFIED IDEOGRAPH-9BC1
        0x9C7A, # G+9777  U+9C7A  uni9C7A,  CJK UNIFIED IDEOGRAPH-9C7A
        0x9C31, # G+9778  U+9C31  uni9C31,  CJK UNIFIED IDEOGRAPH-9C31
        0x9C39, # G+9779  U+9C39  uni9C39,  CJK UNIFIED IDEOGRAPH-9C39
        0x9C23, # G+9780  U+9C23  uni9C23,  CJK UNIFIED IDEOGRAPH-9C23
        0x9C37, # G+9781  U+9C37  uni9C37,  CJK UNIFIED IDEOGRAPH-9C37
        0x9BC0, # G+9782  U+9BC0  uni9BC0,  CJK UNIFIED IDEOGRAPH-9BC0
        0x9BCA, # G+9783  U+9BCA  uni9BCA,  CJK UNIFIED IDEOGRAPH-9BCA
        0x9BC7, # G+9784  U+9BC7  uni9BC7,  CJK UNIFIED IDEOGRAPH-9BC7
        0x9BFD, # G+9785  U+9BFD  uni9BFD,  CJK UNIFIED IDEOGRAPH-9BFD
        0x9BD6, # G+9786  U+9BD6  uni9BD6,  CJK UNIFIED IDEOGRAPH-9BD6
        0x9BEA, # G+9787  U+9BEA  uni9BEA,  CJK UNIFIED IDEOGRAPH-9BEA
        0x9BEB, # G+9788  U+9BEB  uni9BEB,  CJK UNIFIED IDEOGRAPH-9BEB
        0x9BE1, # G+9789  U+9BE1  uni9BE1,  CJK UNIFIED IDEOGRAPH-9BE1
        0x9BE4, # G+9790  U+9BE4  uni9BE4,  CJK UNIFIED IDEOGRAPH-9BE4
        0x9BE7, # G+9791  U+9BE7  uni9BE7,  CJK UNIFIED IDEOGRAPH-9BE7
        0x9BDD, # G+9792  U+9BDD  uni9BDD,  CJK UNIFIED IDEOGRAPH-9BDD
        0x9BE2, # G+9793  U+9BE2  uni9BE2,  CJK UNIFIED IDEOGRAPH-9BE2
        0x9BF0, # G+9794  U+9BF0  uni9BF0,  CJK UNIFIED IDEOGRAPH-9BF0
        0x9BDB, # G+9795  U+9BDB  uni9BDB,  CJK UNIFIED IDEOGRAPH-9BDB
        0x9BF4, # G+9796  U+9BF4  uni9BF4,  CJK UNIFIED IDEOGRAPH-9BF4
        0x9BD4, # G+9797  U+9BD4  uni9BD4,  CJK UNIFIED IDEOGRAPH-9BD4
        0x9C5D, # G+9798  U+9C5D  uni9C5D,  CJK UNIFIED IDEOGRAPH-9C5D
        0x9C08, # G+9799  U+9C08  uni9C08,  CJK UNIFIED IDEOGRAPH-9C08
        0x9C10, # G+9800  U+9C10  uni9C10,  CJK UNIFIED IDEOGRAPH-9C10
        0x9C0D, # G+9801  U+9C0D  uni9C0D,  CJK UNIFIED IDEOGRAPH-9C0D
        0x9C12, # G+9802  U+9C12  uni9C12,  CJK UNIFIED IDEOGRAPH-9C12
        0x9C09, # G+9803  U+9C09  uni9C09,  CJK UNIFIED IDEOGRAPH-9C09
        0x9BFF, # G+9804  U+9BFF  uni9BFF,  CJK UNIFIED IDEOGRAPH-9BFF
        0x9C20, # G+9805  U+9C20  uni9C20,  CJK UNIFIED IDEOGRAPH-9C20
        0x9C32, # G+9806  U+9C32  uni9C32,  CJK UNIFIED IDEOGRAPH-9C32
        0x9C2D, # G+9807  U+9C2D  uni9C2D,  CJK UNIFIED IDEOGRAPH-9C2D
        0x9C28, # G+9808  U+9C28  uni9C28,  CJK UNIFIED IDEOGRAPH-9C28
        0x9C25, # G+9809  U+9C25  uni9C25,  CJK UNIFIED IDEOGRAPH-9C25
        0x9C29, # G+9810  U+9C29  uni9C29,  CJK UNIFIED IDEOGRAPH-9C29
        0x9C33, # G+9811  U+9C33  uni9C33,  CJK UNIFIED IDEOGRAPH-9C33
        0x9C3E, # G+9812  U+9C3E  uni9C3E,  CJK UNIFIED IDEOGRAPH-9C3E
        0x9C48, # G+9813  U+9C48  uni9C48,  CJK UNIFIED IDEOGRAPH-9C48
        0x9C3B, # G+9814  U+9C3B  uni9C3B,  CJK UNIFIED IDEOGRAPH-9C3B
        0x9C35, # G+9815  U+9C35  uni9C35,  CJK UNIFIED IDEOGRAPH-9C35
        0x9C45, # G+9816  U+9C45  uni9C45,  CJK UNIFIED IDEOGRAPH-9C45
        0x9C56, # G+9817  U+9C56  uni9C56,  CJK UNIFIED IDEOGRAPH-9C56
        0x9C54, # G+9818  U+9C54  uni9C54,  CJK UNIFIED IDEOGRAPH-9C54
        0x9C52, # G+9819  U+9C52  uni9C52,  CJK UNIFIED IDEOGRAPH-9C52
        0x9C67, # G+9820  U+9C67  uni9C67,  CJK UNIFIED IDEOGRAPH-9C67
        0x97C3, # G+9821  U+97C3  uni97C3,  CJK UNIFIED IDEOGRAPH-97C3
        0x97BD, # G+9822  U+97BD  uni97BD,  CJK UNIFIED IDEOGRAPH-97BD
        0x97C9, # G+9823  U+97C9  uni97C9,  CJK UNIFIED IDEOGRAPH-97C9
        0x9DBB, # G+9824  U+9DBB  uni9DBB,  CJK UNIFIED IDEOGRAPH-9DBB
        0x9ACF, # G+9825  U+9ACF  uni9ACF,  CJK UNIFIED IDEOGRAPH-9ACF
        0x9AD6, # G+9826  U+9AD6  uni9AD6,  CJK UNIFIED IDEOGRAPH-9AD6
        0x9AD5, # G+9827  U+9AD5  uni9AD5,  CJK UNIFIED IDEOGRAPH-9AD5
        0x9B58, # G+9828  U+9B58  uni9B58,  CJK UNIFIED IDEOGRAPH-9B58
        0x9B4E, # G+9829  U+9B4E  uni9B4E,  CJK UNIFIED IDEOGRAPH-9B4E
        0x9957, # G+9830  U+9957  uni9957,  CJK UNIFIED IDEOGRAPH-9957
        0x995C, # G+9831  U+995C  uni995C,  CJK UNIFIED IDEOGRAPH-995C
        0x9B22, # G+9832  U+9B22  uni9B22,  CJK UNIFIED IDEOGRAPH-9B22
        0x9EF7, # G+9833  U+9EF7  uni9EF7,  CJK UNIFIED IDEOGRAPH-9EF7
        0x9EF2, # G+9834  U+9EF2  uni9EF2,  CJK UNIFIED IDEOGRAPH-9EF2
        0x896C, # G+9835  U+896C  uni896C,  CJK UNIFIED IDEOGRAPH-896C
        0x95C6, # G+9836  U+95C6  uni95C6,  CJK UNIFIED IDEOGRAPH-95C6
        0x9336, # G+9837  U+9336  uni9336,  CJK UNIFIED IDEOGRAPH-9336
        0x5F46, # G+9838  U+5F46  uni5F46,  CJK UNIFIED IDEOGRAPH-5F46
        0x8514, # G+9839  U+8514  uni8514,  CJK UNIFIED IDEOGRAPH-8514
        0x7E94, # G+9840  U+7E94  uni7E94,  CJK UNIFIED IDEOGRAPH-7E94
        0x9F63, # G+9841  U+9F63  uni9F63,  CJK UNIFIED IDEOGRAPH-9F63
        0x5679, # G+9842  U+5679  uni5679,  CJK UNIFIED IDEOGRAPH-5679
        0x9F15, # G+9843  U+9F15  uni9F15,  CJK UNIFIED IDEOGRAPH-9F15
        0x5641, # G+9844  U+5641  uni5641,  CJK UNIFIED IDEOGRAPH-5641
        0x9AEE, # G+9845  U+9AEE  uni9AEE,  CJK UNIFIED IDEOGRAPH-9AEE
        0x8907, # G+9846  U+8907  uni8907,  CJK UNIFIED IDEOGRAPH-8907
        0x7A40, # G+9847  U+7A40  uni7A40,  CJK UNIFIED IDEOGRAPH-7A40
        0x98B3, # G+9848  U+98B3  uni98B3,  CJK UNIFIED IDEOGRAPH-98B3
        0x95A4, # G+9849  U+95A4  uni95A4,  CJK UNIFIED IDEOGRAPH-95A4
        0x9B0D, # G+9850  U+9B0D  uni9B0D,  CJK UNIFIED IDEOGRAPH-9B0D
        0x8FF4, # G+9851  U+8FF4  uni8FF4,  CJK UNIFIED IDEOGRAPH-8FF4
        0x5F59, # G+9852  U+5F59  uni5F59,  CJK UNIFIED IDEOGRAPH-5F59
        0x7A6B, # G+9853  U+7A6B  uni7A6B,  CJK UNIFIED IDEOGRAPH-7A6B
        0x98E2, # G+9854  U+98E2  uni98E2,  CJK UNIFIED IDEOGRAPH-98E2
        0x50A2, # G+9855  U+50A2  uni50A2,  CJK UNIFIED IDEOGRAPH-50A2
        0x8591, # G+9856  U+8591  uni8591,  CJK UNIFIED IDEOGRAPH-8591
        0x5118, # G+9857  U+5118  uni5118,  CJK UNIFIED IDEOGRAPH-5118
        0x6372, # G+9858  U+6372  uni6372,  CJK UNIFIED IDEOGRAPH-6372
        0x524B, # G+9859  U+524B  uni524B,  CJK UNIFIED IDEOGRAPH-524B
        0x774F, # G+9860  U+774F  uni774F,  CJK UNIFIED IDEOGRAPH-774F
        0x7E8D, # G+9861  U+7E8D  uni7E8D,  CJK UNIFIED IDEOGRAPH-7E8D
        0x66C6, # G+9862  U+66C6  uni66C6,  CJK UNIFIED IDEOGRAPH-66C6
        0x77AD, # G+9863  U+77AD  uni77AD,  CJK UNIFIED IDEOGRAPH-77AD
        0x2FC4, # G+9864  U+2FC4  uni2FC4,  KANGXI RADICAL SALT
        0x56C9, # G+9865  U+56C9  uni56C9,  CJK UNIFIED IDEOGRAPH-56C9
        0x9EF4, # G+9866  U+9EF4  uni9EF4,  CJK UNIFIED IDEOGRAPH-9EF4
        0x6FDB, # G+9867  U+6FDB  uni6FDB,  CJK UNIFIED IDEOGRAPH-6FDB
        0x61DE, # G+9868  U+61DE  uni61DE,  CJK UNIFIED IDEOGRAPH-61DE
        0x77C7, # G+9869  U+77C7  uni77C7,  CJK UNIFIED IDEOGRAPH-77C7
        0x7030, # G+9870  U+7030  uni7030,  CJK UNIFIED IDEOGRAPH-7030
        0x9EB5, # G+9871  U+9EB5  uni9EB5,  CJK UNIFIED IDEOGRAPH-9EB5
        0x884A, # G+9872  U+884A  uni884A,  CJK UNIFIED IDEOGRAPH-884A
        0x95E2, # G+9873  U+95E2  uni95E2,  CJK UNIFIED IDEOGRAPH-95E2
        0x97C6, # G+9874  U+97C6  uni97C6,  CJK UNIFIED IDEOGRAPH-97C6
        0x7C64, # G+9875  U+7C64  uni7C64,  CJK UNIFIED IDEOGRAPH-7C64
        0x7E34, # G+9876  U+7E34  uni7E34,  CJK UNIFIED IDEOGRAPH-7E34
        0x97A6, # G+9877  U+97A6  uni97A6,  CJK UNIFIED IDEOGRAPH-97A6
        0x9EAF, # G+9878  U+9EAF  uni9EAF,  CJK UNIFIED IDEOGRAPH-9EAF
        0x56CC, # G+9879  U+56CC  uni56CC,  CJK UNIFIED IDEOGRAPH-56CC
        0x98B1, # G+9880  U+98B1  uni98B1,  CJK UNIFIED IDEOGRAPH-98B1
        0x6AAF, # G+9881  U+6AAF  uni6AAF,  CJK UNIFIED IDEOGRAPH-6AAF
        0x7F4E, # G+9882  U+7F4E  uni7F4E,  CJK UNIFIED IDEOGRAPH-7F4E
        0x7CF0, # G+9883  U+7CF0  uni7CF0,  CJK UNIFIED IDEOGRAPH-7CF0
        0x4FC2, # G+9884  U+4FC2  uni4FC2,  CJK UNIFIED IDEOGRAPH-4FC2
        0x7E6B, # G+9885  U+7E6B  uni7E6B,  CJK UNIFIED IDEOGRAPH-7E6B
        0x9E79, # G+9886  U+9E79  uni9E79,  CJK UNIFIED IDEOGRAPH-9E79
        0x56AE, # G+9887  U+56AE  uni56AE,  CJK UNIFIED IDEOGRAPH-56AE
        0x9B1A, # G+9888  U+9B1A  uni9B1A,  CJK UNIFIED IDEOGRAPH-9B1A
        0x846F, # G+9889  U+846F  uni846F,  CJK UNIFIED IDEOGRAPH-846F
        0x79A6, # G+9890  U+79A6  uni79A6,  CJK UNIFIED IDEOGRAPH-79A6
        0x7C72, # G+9891  U+7C72  uni7C72,  CJK UNIFIED IDEOGRAPH-7C72
        0x9AD2, # G+9892  U+9AD2  uni9AD2,  CJK UNIFIED IDEOGRAPH-9AD2
        0x96BB, # G+9893  U+96BB  uni96BB,  CJK UNIFIED IDEOGRAPH-96BB
        0x7DFB, # G+9894  U+7DFB  uni7DFB,  CJK UNIFIED IDEOGRAPH-7DFB
        0x88FD, # G+9895  U+88FD  uni88FD,  CJK UNIFIED IDEOGRAPH-88FD
        0x7843, # G+9896  U+7843  uni7843,  CJK UNIFIED IDEOGRAPH-7843
        0x2170, # G+9897  U+2170  uni2170,  SMALL ROMAN NUMERAL ONE
        0x2171, # G+9898  U+2171  uni2171,  SMALL ROMAN NUMERAL TWO
        0x2172, # G+9899  U+2172  uni2172,  SMALL ROMAN NUMERAL THREE
        0x2173, # G+9900  U+2173  uni2173,  SMALL ROMAN NUMERAL FOUR
        0x2174, # G+9901  U+2174  uni2174,  SMALL ROMAN NUMERAL FIVE
        0x2175, # G+9902  U+2175  uni2175,  SMALL ROMAN NUMERAL SIX
        0x2176, # G+9903  U+2176  uni2176,  SMALL ROMAN NUMERAL SEVEN
        0x2177, # G+9904  U+2177  uni2177,  SMALL ROMAN NUMERAL EIGHT
        0x2178, # G+9905  U+2178  uni2178,  SMALL ROMAN NUMERAL NINE
        0x2179, # G+9906  U+2179  uni2179,  SMALL ROMAN NUMERAL TEN
        0x02CA, # G+9907  U+02CA  uni02CA,  MODIFIER LETTER ACUTE ACCENT
        0x02CB, # G+9908  U+02CB  uni02CB,  MODIFIER LETTER GRAVE ACCENT
        0x02D9, # G+9909  U+02D9  dotaccent,  DOT ABOVE
        0x2013, # G+9910  U+2013  endash,  EN DASH
        0x2015, # G+9911  U+2015  afii00208,  HORIZONTAL BAR
        0x2025, # G+9912  U+2025  twodotenleader,  TWO DOT LEADER
        0x2035, # G+9913  U+2035  uni2035,  REVERSED PRIME
        0x2105, # G+9914  U+2105  afii61248,  CARE OF
        0x2109, # G+9915  U+2109  uni2109,  DEGREE FAHRENHEIT
        0x2196, # G+9916  U+2196  uni2196,  NORTH WEST ARROW
        0x2197, # G+9917  U+2197  uni2197,  NORTH EAST ARROW
        0x2198, # G+9918  U+2198  uni2198,  SOUTH EAST ARROW
        0x2199, # G+9919  U+2199  uni2199,  SOUTH WEST ARROW
        0x2215, # G+9920  U+2215  fraction,  DIVISION SLASH
        0x221F, # G+9921  U+221F  orthogonal,  RIGHT ANGLE
        0x2223, # G+9922  U+2223  uni2223,  DIVIDES
        0x2252, # G+9923  U+2252  uni2252,  APPROXIMATELY EQUAL TO OR THE IMAGE OF
        0x2266, # G+9924  U+2266  uni2266,  LESS-THAN OVER EQUAL TO
        0x2267, # G+9925  U+2267  uni2267,  GREATER-THAN OVER EQUAL TO
        0x22BF, # G+9926  U+22BF  uni22BF,  RIGHT TRIANGLE
        0x2550, # G+9927  U+2550  SF430000,  BOX DRAWINGS DOUBLE HORIZONTAL
        0x2551, # G+9928  U+2551  SF240000,  BOX DRAWINGS DOUBLE VERTICAL
        0x2552, # G+9929  U+2552  SF510000,  BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
        0x2553, # G+9930  U+2553  SF520000,  BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
        0x2554, # G+9931  U+2554  SF390000,  BOX DRAWINGS DOUBLE DOWN AND RIGHT
        0x2555, # G+9932  U+2555  SF220000,  BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
        0x2556, # G+9933  U+2556  SF210000,  BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
        0x2557, # G+9934  U+2557  SF250000,  BOX DRAWINGS DOUBLE DOWN AND LEFT
        0x2558, # G+9935  U+2558  SF500000,  BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
        0x2559, # G+9936  U+2559  SF490000,  BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
        0x255A, # G+9937  U+255A  SF380000,  BOX DRAWINGS DOUBLE UP AND RIGHT
        0x255B, # G+9938  U+255B  SF280000,  BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
        0x255C, # G+9939  U+255C  SF270000,  BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
        0x255D, # G+9940  U+255D  SF260000,  BOX DRAWINGS DOUBLE UP AND LEFT
        0x255E, # G+9941  U+255E  SF360000,  BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
        0x255F, # G+9942  U+255F  SF370000,  BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
        0x2560, # G+9943  U+2560  SF420000,  BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
        0x2561, # G+9944  U+2561  SF190000,  BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
        0x2562, # G+9945  U+2562  SF200000,  BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
        0x2563, # G+9946  U+2563  SF230000,  BOX DRAWINGS DOUBLE VERTICAL AND LEFT
        0x2564, # G+9947  U+2564  SF470000,  BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
        0x2565, # G+9948  U+2565  SF480000,  BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
        0x2566, # G+9949  U+2566  SF410000,  BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
        0x2567, # G+9950  U+2567  SF450000,  BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
        0x2568, # G+9951  U+2568  SF460000,  BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
        0x2569, # G+9952  U+2569  SF400000,  BOX DRAWINGS DOUBLE UP AND HORIZONTAL
        0x256A, # G+9953  U+256A  SF540000,  BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
        0x256B, # G+9954  U+256B  SF530000,  BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
        0x256C, # G+9955  U+256C  SF440000,  BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
        0x256D, # G+9956  U+256D  uni256D,  BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
        0x256E, # G+9957  U+256E  uni256E,  BOX DRAWINGS LIGHT ARC DOWN AND LEFT
        0x256F, # G+9958  U+256F  uni256F,  BOX DRAWINGS LIGHT ARC UP AND LEFT
        0x2570, # G+9959  U+2570  uni2570,  BOX DRAWINGS LIGHT ARC UP AND RIGHT
        0x2571, # G+9960  U+2571  uni2571,  BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
        0x2572, # G+9961  U+2572  uni2572,  BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
        0x2573, # G+9962  U+2573  uni2573,  BOX DRAWINGS LIGHT DIAGONAL CROSS
        0x2581, # G+9963  U+2581  uni2581,  LOWER ONE EIGHTH BLOCK
        0x2582, # G+9964  U+2582  uni2582,  LOWER ONE QUARTER BLOCK
        0x2583, # G+9965  U+2583  uni2583,  LOWER THREE EIGHTHS BLOCK
        0x2584, # G+9966  U+2584  dnblock,  LOWER HALF BLOCK
        0x2585, # G+9967  U+2585  uni2585,  LOWER FIVE EIGHTHS BLOCK
        0x2586, # G+9968  U+2586  uni2586,  LOWER THREE QUARTERS BLOCK
        0x2587, # G+9969  U+2587  uni2587,  LOWER SEVEN EIGHTHS BLOCK
        0x2588, # G+9970  U+2588  block,  FULL BLOCK
        0x2589, # G+9971  U+2589  uni2589,  LEFT SEVEN EIGHTHS BLOCK
        0x258A, # G+9972  U+258A  uni258A,  LEFT THREE QUARTERS BLOCK
        0x258B, # G+9973  U+258B  uni258B,  LEFT FIVE EIGHTHS BLOCK
        0x258C, # G+9974  U+258C  lfblock,  LEFT HALF BLOCK
        0x258D, # G+9975  U+258D  uni258D,  LEFT THREE EIGHTHS BLOCK
        0x258E, # G+9976  U+258E  uni258E,  LEFT ONE QUARTER BLOCK
        0x258F, # G+9977  U+258F  uni258F,  LEFT ONE EIGHTH BLOCK
        0x2593, # G+9978  U+2593  dkshade,  DARK SHADE
        0x2594, # G+9979  U+2594  uni2594,  UPPER ONE EIGHTH BLOCK
        0x2595, # G+9980  U+2595  uni2595,  RIGHT ONE EIGHTH BLOCK
        0x25BC, # G+9981  U+25BC  triagdn,  BLACK DOWN-POINTING TRIANGLE
        0x25BD, # G+9982  U+25BD  uni25BD,  WHITE DOWN-POINTING TRIANGLE
        0x25E2, # G+9983  U+25E2  uni25E2,  BLACK LOWER RIGHT TRIANGLE
        0x25E3, # G+9984  U+25E3  uni25E3,  BLACK LOWER LEFT TRIANGLE
        0x25E4, # G+9985  U+25E4  uni25E4,  BLACK UPPER LEFT TRIANGLE
        0x25E5, # G+9986  U+25E5  uni25E5,  BLACK UPPER RIGHT TRIANGLE
        0x2609, # G+9987  U+2609  uni2609,  SUN
        0x2295, # G+9988  U+2295  circleplus,  CIRCLED PLUS
        0x3012, # G+9989  U+3012  uni3012,  POSTAL MARK
        0x301D, # G+9990  U+301D  uni301D,  REVERSED DOUBLE PRIME QUOTATION MARK
        0x301E, # G+9991  U+301E  uni301E,  DOUBLE PRIME QUOTATION MARK
        0x3021, # G+9992  U+3021  uni3021,  HANGZHOU NUMERAL ONE
        0x3022, # G+9993  U+3022  uni3022,  HANGZHOU NUMERAL TWO
        0x3023, # G+9994  U+3023  uni3023,  HANGZHOU NUMERAL THREE
        0x3024, # G+9995  U+3024  uni3024,  HANGZHOU NUMERAL FOUR
        0x3025, # G+9996  U+3025  uni3025,  HANGZHOU NUMERAL FIVE
        0x3026, # G+9997  U+3026  uni3026,  HANGZHOU NUMERAL SIX
        0x3027, # G+9998  U+3027  uni3027,  HANGZHOU NUMERAL SEVEN
        0x3028, # G+9999  U+3028  uni3028,  HANGZHOU NUMERAL EIGHT
        0x3029, # G+10000  U+3029  uni3029,  HANGZHOU NUMERAL NINE
        0x32A3, # G+10001  U+32A3  uni32A3,  CIRCLED IDEOGRAPH CORRECT
        0x338E, # G+10002  U+338E  uni338E,  SQUARE MG
        0x338F, # G+10003  U+338F  uni338F,  SQUARE KG
        0x339C, # G+10004  U+339C  uni339C,  SQUARE MM
        0x339D, # G+10005  U+339D  uni339D,  SQUARE CM
        0x339E, # G+10006  U+339E  uni339E,  SQUARE KM
        0x33A1, # G+10007  U+33A1  uni33A1,  SQUARE M SQUARED
        0x33C4, # G+10008  U+33C4  uni33C4,  SQUARE CC
        0x33CE, # G+10009  U+33CE  uni33CE,  SQUARE KM CAPITAL
        0x33D1, # G+10010  U+33D1  uni33D1,  SQUARE LN
        0x33D2, # G+10011  U+33D2  uni33D2,  SQUARE LOG
        0x33D5, # G+10012  U+33D5  uni33D5,  SQUARE MIL
        0xFE30, # G+10013  U+FE30  uniFE30,  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
        0xFFE2, # G+10014  U+FFE2  uniFFE2,  FULLWIDTH NOT SIGN
        0xFFE4, # G+10015  U+FFE4  uniFFE4,  FULLWIDTH BROKEN BAR
        0x2121, # G+10016  U+2121  uni2121,  TELEPHONE SIGN
        0x3231, # G+10017  U+3231  uni3231,  PARENTHESIZED IDEOGRAPH STOCK
        0x2010, # G+10018  U+2010  uni2010,  HYPHEN
        0x30FC, # G+10019  U+30FC  uni30FC,  KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0x309B, # G+10020  U+309B  uni309B,  KATAKANA-HIRAGANA VOICED SOUND MARK
        0x309C, # G+10021  U+309C  uni309C,  KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
        0x30FD, # G+10022  U+30FD  uni30FD,  KATAKANA ITERATION MARK
        0x30FE, # G+10023  U+30FE  uni30FE,  KATAKANA VOICED ITERATION MARK
        0x3006, # G+10024  U+3006  uni3006,  IDEOGRAPHIC CLOSING MARK
        0x309D, # G+10025  U+309D  uni309D,  HIRAGANA ITERATION MARK
        0x309E, # G+10026  U+309E  uni309E,  HIRAGANA VOICED ITERATION MARK
        0xFE49, # G+10027  U+FE49  uniFE49,  DASHED OVERLINE
        0xFE4A, # G+10028  U+FE4A  uniFE4A,  CENTRELINE OVERLINE
        0xFE4B, # G+10029  U+FE4B  uniFE4B,  WAVY OVERLINE
        0xFE4C, # G+10030  U+FE4C  uniFE4C,  DOUBLE WAVY OVERLINE
        0xFE4D, # G+10031  U+FE4D  uniFE4D,  DASHED LOW LINE
        0xFE4E, # G+10032  U+FE4E  uniFE4E,  CENTRELINE LOW LINE
        0xFE4F, # G+10033  U+FE4F  uniFE4F,  WAVY LOW LINE
        0xFE50, # G+10034  U+FE50  uniFE50,  SMALL COMMA
        0xFE51, # G+10035  U+FE51  uniFE51,  SMALL IDEOGRAPHIC COMMA
        0xFE52, # G+10036  U+FE52  uniFE52,  SMALL FULL STOP
        0xFE54, # G+10037  U+FE54  uniFE54,  SMALL SEMICOLON
        0xFE55, # G+10038  U+FE55  uniFE55,  SMALL COLON
        0xFE56, # G+10039  U+FE56  uniFE56,  SMALL QUESTION MARK
        0xFE57, # G+10040  U+FE57  uniFE57,  SMALL EXCLAMATION MARK
        0xFE59, # G+10041  U+FE59  uniFE59,  SMALL LEFT PARENTHESIS
        0xFE5A, # G+10042  U+FE5A  uniFE5A,  SMALL RIGHT PARENTHESIS
        0xFE5B, # G+10043  U+FE5B  uniFE5B,  SMALL LEFT CURLY BRACKET
        0xFE5C, # G+10044  U+FE5C  uniFE5C,  SMALL RIGHT CURLY BRACKET
        0xFE5D, # G+10045  U+FE5D  uniFE5D,  SMALL LEFT TORTOISE SHELL BRACKET
        0xFE5E, # G+10046  U+FE5E  uniFE5E,  SMALL RIGHT TORTOISE SHELL BRACKET
        0xFE5F, # G+10047  U+FE5F  uniFE5F,  SMALL NUMBER SIGN
        0xFE60, # G+10048  U+FE60  uniFE60,  SMALL AMPERSAND
        0xFE61, # G+10049  U+FE61  uniFE61,  SMALL ASTERISK
        0xFE62, # G+10050  U+FE62  uniFE62,  SMALL PLUS SIGN
        0xFE63, # G+10051  U+FE63  uniFE63,  SMALL HYPHEN-MINUS
        0xFE64, # G+10052  U+FE64  uniFE64,  SMALL LESS-THAN SIGN
        0xFE65, # G+10053  U+FE65  uniFE65,  SMALL GREATER-THAN SIGN
        0xFE66, # G+10054  U+FE66  uniFE66,  SMALL EQUALS SIGN
        0xFE68, # G+10055  U+FE68  uniFE68,  SMALL REVERSE SOLIDUS
        0xFE69, # G+10056  U+FE69  uniFE69,  SMALL DOLLAR SIGN
        0xFE6A, # G+10057  U+FE6A  uniFE6A,  SMALL PERCENT SIGN
        0xFE6B, # G+10058  U+FE6B  uniFE6B,  SMALL COMMERCIAL AT
        0x303E, # G+10059  U+303E  uni303E,  IDEOGRAPHIC VARIATION INDICATOR
        0x2FF0, # G+10060  U+2FF0  uni2FF0,  IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT
        0x2FF1, # G+10061  U+2FF1  uni2FF1,  IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW
        0x2FF2, # G+10062  U+2FF2  uni2FF2,  IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT
        0x2FF3, # G+10063  U+2FF3  uni2FF3,  IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW
        0x2FF4, # G+10064  U+2FF4  uni2FF4,  IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND
        0x2FF5, # G+10065  U+2FF5  uni2FF5,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE
        0x2FF6, # G+10066  U+2FF6  uni2FF6,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW
        0x2FF7, # G+10067  U+2FF7  uni2FF7,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT
        0x2FF8, # G+10068  U+2FF8  uni2FF8,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT
        0x2FF9, # G+10069  U+2FF9  uni2FF9,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT
        0x2FFA, # G+10070  U+2FFA  uni2FFA,  IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT
        0x2FFB, # G+10071  U+2FFB  uni2FFB,  IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
        0x4E02, # G+10072  U+4E02  uni4E02,  CJK UNIFIED IDEOGRAPH-4E02
        0x4E04, # G+10073  U+4E04  uni4E04,  CJK UNIFIED IDEOGRAPH-4E04
        0x4E05, # G+10074  U+4E05  uni4E05,  CJK UNIFIED IDEOGRAPH-4E05
        0x4E06, # G+10075  U+4E06  uni4E06,  CJK UNIFIED IDEOGRAPH-4E06
        0x4E0F, # G+10076  U+4E0F  uni4E0F,  CJK UNIFIED IDEOGRAPH-4E0F
        0x4E12, # G+10077  U+4E12  uni4E12,  CJK UNIFIED IDEOGRAPH-4E12
        0x4E17, # G+10078  U+4E17  uni4E17,  CJK UNIFIED IDEOGRAPH-4E17
        0x4E1F, # G+10079  U+4E1F  uni4E1F,  CJK UNIFIED IDEOGRAPH-4E1F
        0x4E20, # G+10080  U+4E20  uni4E20,  CJK UNIFIED IDEOGRAPH-4E20
        0x4E21, # G+10081  U+4E21  uni4E21,  CJK UNIFIED IDEOGRAPH-4E21
        0x4E23, # G+10082  U+4E23  uni4E23,  CJK UNIFIED IDEOGRAPH-4E23
        0x4E26, # G+10083  U+4E26  uni4E26,  CJK UNIFIED IDEOGRAPH-4E26
        0x4E29, # G+10084  U+4E29  uni4E29,  CJK UNIFIED IDEOGRAPH-4E29
        0x4E2E, # G+10085  U+4E2E  uni4E2E,  CJK UNIFIED IDEOGRAPH-4E2E
        0x4E2F, # G+10086  U+4E2F  uni4E2F,  CJK UNIFIED IDEOGRAPH-4E2F
        0x4E31, # G+10087  U+4E31  uni4E31,  CJK UNIFIED IDEOGRAPH-4E31
        0x4E33, # G+10088  U+4E33  uni4E33,  CJK UNIFIED IDEOGRAPH-4E33
        0x4E35, # G+10089  U+4E35  uni4E35,  CJK UNIFIED IDEOGRAPH-4E35
        0x4E37, # G+10090  U+4E37  uni4E37,  CJK UNIFIED IDEOGRAPH-4E37
        0x4E3C, # G+10091  U+4E3C  uni4E3C,  CJK UNIFIED IDEOGRAPH-4E3C
        0x4E40, # G+10092  U+4E40  uni4E40,  CJK UNIFIED IDEOGRAPH-4E40
        0x4E41, # G+10093  U+4E41  uni4E41,  CJK UNIFIED IDEOGRAPH-4E41
        0x4E42, # G+10094  U+4E42  uni4E42,  CJK UNIFIED IDEOGRAPH-4E42
        0x4E44, # G+10095  U+4E44  uni4E44,  CJK UNIFIED IDEOGRAPH-4E44
        0x4E46, # G+10096  U+4E46  uni4E46,  CJK UNIFIED IDEOGRAPH-4E46
        0x4E4A, # G+10097  U+4E4A  uni4E4A,  CJK UNIFIED IDEOGRAPH-4E4A
        0x4E51, # G+10098  U+4E51  uni4E51,  CJK UNIFIED IDEOGRAPH-4E51
        0x4E55, # G+10099  U+4E55  uni4E55,  CJK UNIFIED IDEOGRAPH-4E55
        0x4E57, # G+10100  U+4E57  uni4E57,  CJK UNIFIED IDEOGRAPH-4E57
        0x4E5A, # G+10101  U+4E5A  uni4E5A,  CJK UNIFIED IDEOGRAPH-4E5A
        0x4E5B, # G+10102  U+4E5B  uni4E5B,  CJK UNIFIED IDEOGRAPH-4E5B
        0x4E62, # G+10103  U+4E62  uni4E62,  CJK UNIFIED IDEOGRAPH-4E62
        0x4E63, # G+10104  U+4E63  uni4E63,  CJK UNIFIED IDEOGRAPH-4E63
        0x4E64, # G+10105  U+4E64  uni4E64,  CJK UNIFIED IDEOGRAPH-4E64
        0x4E65, # G+10106  U+4E65  uni4E65,  CJK UNIFIED IDEOGRAPH-4E65
        0x4E67, # G+10107  U+4E67  uni4E67,  CJK UNIFIED IDEOGRAPH-4E67
        0x4E68, # G+10108  U+4E68  uni4E68,  CJK UNIFIED IDEOGRAPH-4E68
        0x4E6A, # G+10109  U+4E6A  uni4E6A,  CJK UNIFIED IDEOGRAPH-4E6A
        0x4E6B, # G+10110  U+4E6B  uni4E6B,  CJK UNIFIED IDEOGRAPH-4E6B
        0x4E6C, # G+10111  U+4E6C  uni4E6C,  CJK UNIFIED IDEOGRAPH-4E6C
        0x4E6D, # G+10112  U+4E6D  uni4E6D,  CJK UNIFIED IDEOGRAPH-4E6D
        0x4E6E, # G+10113  U+4E6E  uni4E6E,  CJK UNIFIED IDEOGRAPH-4E6E
        0x4E6F, # G+10114  U+4E6F  uni4E6F,  CJK UNIFIED IDEOGRAPH-4E6F
        0x4E72, # G+10115  U+4E72  uni4E72,  CJK UNIFIED IDEOGRAPH-4E72
        0x4E74, # G+10116  U+4E74  uni4E74,  CJK UNIFIED IDEOGRAPH-4E74
        0x4E75, # G+10117  U+4E75  uni4E75,  CJK UNIFIED IDEOGRAPH-4E75
        0x4E76, # G+10118  U+4E76  uni4E76,  CJK UNIFIED IDEOGRAPH-4E76
        0x4E77, # G+10119  U+4E77  uni4E77,  CJK UNIFIED IDEOGRAPH-4E77
        0x4E78, # G+10120  U+4E78  uni4E78,  CJK UNIFIED IDEOGRAPH-4E78
        0x4E79, # G+10121  U+4E79  uni4E79,  CJK UNIFIED IDEOGRAPH-4E79
        0x4E7A, # G+10122  U+4E7A  uni4E7A,  CJK UNIFIED IDEOGRAPH-4E7A
        0x4E7B, # G+10123  U+4E7B  uni4E7B,  CJK UNIFIED IDEOGRAPH-4E7B
        0x4E7C, # G+10124  U+4E7C  uni4E7C,  CJK UNIFIED IDEOGRAPH-4E7C
        0x4E7D, # G+10125  U+4E7D  uni4E7D,  CJK UNIFIED IDEOGRAPH-4E7D
        0x4E7F, # G+10126  U+4E7F  uni4E7F,  CJK UNIFIED IDEOGRAPH-4E7F
        0x4E80, # G+10127  U+4E80  uni4E80,  CJK UNIFIED IDEOGRAPH-4E80
        0x4E81, # G+10128  U+4E81  uni4E81,  CJK UNIFIED IDEOGRAPH-4E81
        0x4E83, # G+10129  U+4E83  uni4E83,  CJK UNIFIED IDEOGRAPH-4E83
        0x4E84, # G+10130  U+4E84  uni4E84,  CJK UNIFIED IDEOGRAPH-4E84
        0x2F05, # G+10131  U+2F05  uni2F05,  KANGXI RADICAL HOOK
        0x4E87, # G+10132  U+4E87  uni4E87,  CJK UNIFIED IDEOGRAPH-4E87
        0x4E8A, # G+10133  U+4E8A  uni4E8A,  CJK UNIFIED IDEOGRAPH-4E8A
        0x4E90, # G+10134  U+4E90  uni4E90,  CJK UNIFIED IDEOGRAPH-4E90
        0x4E96, # G+10135  U+4E96  uni4E96,  CJK UNIFIED IDEOGRAPH-4E96
        0x4E97, # G+10136  U+4E97  uni4E97,  CJK UNIFIED IDEOGRAPH-4E97
        0x4E99, # G+10137  U+4E99  uni4E99,  CJK UNIFIED IDEOGRAPH-4E99
        0x4E9C, # G+10138  U+4E9C  uni4E9C,  CJK UNIFIED IDEOGRAPH-4E9C
        0x4E9D, # G+10139  U+4E9D  uni4E9D,  CJK UNIFIED IDEOGRAPH-4E9D
        0x4EA3, # G+10140  U+4EA3  uni4EA3,  CJK UNIFIED IDEOGRAPH-4EA3
        0x4EAA, # G+10141  U+4EAA  uni4EAA,  CJK UNIFIED IDEOGRAPH-4EAA
        0x4EAF, # G+10142  U+4EAF  uni4EAF,  CJK UNIFIED IDEOGRAPH-4EAF
        0x4EB0, # G+10143  U+4EB0  uni4EB0,  CJK UNIFIED IDEOGRAPH-4EB0
        0x4EB1, # G+10144  U+4EB1  uni4EB1,  CJK UNIFIED IDEOGRAPH-4EB1
        0x4EB4, # G+10145  U+4EB4  uni4EB4,  CJK UNIFIED IDEOGRAPH-4EB4
        0x4EB6, # G+10146  U+4EB6  uni4EB6,  CJK UNIFIED IDEOGRAPH-4EB6
        0x4EB7, # G+10147  U+4EB7  uni4EB7,  CJK UNIFIED IDEOGRAPH-4EB7
        0x4EB8, # G+10148  U+4EB8  uni4EB8,  CJK UNIFIED IDEOGRAPH-4EB8
        0x4EB9, # G+10149  U+4EB9  uni4EB9,  CJK UNIFIED IDEOGRAPH-4EB9
        0x4EBC, # G+10150  U+4EBC  uni4EBC,  CJK UNIFIED IDEOGRAPH-4EBC
        0x4EBD, # G+10151  U+4EBD  uni4EBD,  CJK UNIFIED IDEOGRAPH-4EBD
        0x4EBE, # G+10152  U+4EBE  uni4EBE,  CJK UNIFIED IDEOGRAPH-4EBE
        0x4EC8, # G+10153  U+4EC8  uni4EC8,  CJK UNIFIED IDEOGRAPH-4EC8
        0x4ECC, # G+10154  U+4ECC  uni4ECC,  CJK UNIFIED IDEOGRAPH-4ECC
        0x4ECF, # G+10155  U+4ECF  uni4ECF,  CJK UNIFIED IDEOGRAPH-4ECF
        0x4ED0, # G+10156  U+4ED0  uni4ED0,  CJK UNIFIED IDEOGRAPH-4ED0
        0x4ED2, # G+10157  U+4ED2  uni4ED2,  CJK UNIFIED IDEOGRAPH-4ED2
        0x4EDA, # G+10158  U+4EDA  uni4EDA,  CJK UNIFIED IDEOGRAPH-4EDA
        0x4EDB, # G+10159  U+4EDB  uni4EDB,  CJK UNIFIED IDEOGRAPH-4EDB
        0x4EDC, # G+10160  U+4EDC  uni4EDC,  CJK UNIFIED IDEOGRAPH-4EDC
        0x4EE0, # G+10161  U+4EE0  uni4EE0,  CJK UNIFIED IDEOGRAPH-4EE0
        0x4EE2, # G+10162  U+4EE2  uni4EE2,  CJK UNIFIED IDEOGRAPH-4EE2
        0x4EE6, # G+10163  U+4EE6  uni4EE6,  CJK UNIFIED IDEOGRAPH-4EE6
        0x4EE7, # G+10164  U+4EE7  uni4EE7,  CJK UNIFIED IDEOGRAPH-4EE7
        0x4EE9, # G+10165  U+4EE9  uni4EE9,  CJK UNIFIED IDEOGRAPH-4EE9
        0x4EED, # G+10166  U+4EED  uni4EED,  CJK UNIFIED IDEOGRAPH-4EED
        0x4EEE, # G+10167  U+4EEE  uni4EEE,  CJK UNIFIED IDEOGRAPH-4EEE
        0x4EEF, # G+10168  U+4EEF  uni4EEF,  CJK UNIFIED IDEOGRAPH-4EEF
        0x4EF1, # G+10169  U+4EF1  uni4EF1,  CJK UNIFIED IDEOGRAPH-4EF1
        0x4EF4, # G+10170  U+4EF4  uni4EF4,  CJK UNIFIED IDEOGRAPH-4EF4
        0x4EF8, # G+10171  U+4EF8  uni4EF8,  CJK UNIFIED IDEOGRAPH-4EF8
        0x4EF9, # G+10172  U+4EF9  uni4EF9,  CJK UNIFIED IDEOGRAPH-4EF9
        0x4EFA, # G+10173  U+4EFA  uni4EFA,  CJK UNIFIED IDEOGRAPH-4EFA
        0x4EFC, # G+10174  U+4EFC  uni4EFC,  CJK UNIFIED IDEOGRAPH-4EFC
        0x4EFE, # G+10175  U+4EFE  uni4EFE,  CJK UNIFIED IDEOGRAPH-4EFE
        0x4F00, # G+10176  U+4F00  uni4F00,  CJK UNIFIED IDEOGRAPH-4F00
        0x4F02, # G+10177  U+4F02  uni4F02,  CJK UNIFIED IDEOGRAPH-4F02
        0x4F03, # G+10178  U+4F03  uni4F03,  CJK UNIFIED IDEOGRAPH-4F03
        0x4F04, # G+10179  U+4F04  uni4F04,  CJK UNIFIED IDEOGRAPH-4F04
        0x4F05, # G+10180  U+4F05  uni4F05,  CJK UNIFIED IDEOGRAPH-4F05
        0x4F06, # G+10181  U+4F06  uni4F06,  CJK UNIFIED IDEOGRAPH-4F06
        0x4F07, # G+10182  U+4F07  uni4F07,  CJK UNIFIED IDEOGRAPH-4F07
        0x4F08, # G+10183  U+4F08  uni4F08,  CJK UNIFIED IDEOGRAPH-4F08
        0x4F0B, # G+10184  U+4F0B  uni4F0B,  CJK UNIFIED IDEOGRAPH-4F0B
        0x4F0C, # G+10185  U+4F0C  uni4F0C,  CJK UNIFIED IDEOGRAPH-4F0C
        0x4F12, # G+10186  U+4F12  uni4F12,  CJK UNIFIED IDEOGRAPH-4F12
        0x4F13, # G+10187  U+4F13  uni4F13,  CJK UNIFIED IDEOGRAPH-4F13
        0x4F14, # G+10188  U+4F14  uni4F14,  CJK UNIFIED IDEOGRAPH-4F14
        0x4F15, # G+10189  U+4F15  uni4F15,  CJK UNIFIED IDEOGRAPH-4F15
        0x4F16, # G+10190  U+4F16  uni4F16,  CJK UNIFIED IDEOGRAPH-4F16
        0x4F1C, # G+10191  U+4F1C  uni4F1C,  CJK UNIFIED IDEOGRAPH-4F1C
        0x4F1D, # G+10192  U+4F1D  uni4F1D,  CJK UNIFIED IDEOGRAPH-4F1D
        0x4F21, # G+10193  U+4F21  uni4F21,  CJK UNIFIED IDEOGRAPH-4F21
        0x4F23, # G+10194  U+4F23  uni4F23,  CJK UNIFIED IDEOGRAPH-4F23
        0x4F28, # G+10195  U+4F28  uni4F28,  CJK UNIFIED IDEOGRAPH-4F28
        0x4F29, # G+10196  U+4F29  uni4F29,  CJK UNIFIED IDEOGRAPH-4F29
        0x4F2C, # G+10197  U+4F2C  uni4F2C,  CJK UNIFIED IDEOGRAPH-4F2C
        0x4F2D, # G+10198  U+4F2D  uni4F2D,  CJK UNIFIED IDEOGRAPH-4F2D
        0x4F2E, # G+10199  U+4F2E  uni4F2E,  CJK UNIFIED IDEOGRAPH-4F2E
        0x4F31, # G+10200  U+4F31  uni4F31,  CJK UNIFIED IDEOGRAPH-4F31
        0x4F33, # G+10201  U+4F33  uni4F33,  CJK UNIFIED IDEOGRAPH-4F33
        0x4F35, # G+10202  U+4F35  uni4F35,  CJK UNIFIED IDEOGRAPH-4F35
        0x4F37, # G+10203  U+4F37  uni4F37,  CJK UNIFIED IDEOGRAPH-4F37
        0x4F39, # G+10204  U+4F39  uni4F39,  CJK UNIFIED IDEOGRAPH-4F39
        0x4F3B, # G+10205  U+4F3B  uni4F3B,  CJK UNIFIED IDEOGRAPH-4F3B
        0x4F3E, # G+10206  U+4F3E  uni4F3E,  CJK UNIFIED IDEOGRAPH-4F3E
        0x4F3F, # G+10207  U+4F3F  uni4F3F,  CJK UNIFIED IDEOGRAPH-4F3F
        0x4F40, # G+10208  U+4F40  uni4F40,  CJK UNIFIED IDEOGRAPH-4F40
        0x4F41, # G+10209  U+4F41  uni4F41,  CJK UNIFIED IDEOGRAPH-4F41
        0x4F42, # G+10210  U+4F42  uni4F42,  CJK UNIFIED IDEOGRAPH-4F42
        0x4F44, # G+10211  U+4F44  uni4F44,  CJK UNIFIED IDEOGRAPH-4F44
        0x4F45, # G+10212  U+4F45  uni4F45,  CJK UNIFIED IDEOGRAPH-4F45
        0x4F47, # G+10213  U+4F47  uni4F47,  CJK UNIFIED IDEOGRAPH-4F47
        0x4F48, # G+10214  U+4F48  uni4F48,  CJK UNIFIED IDEOGRAPH-4F48
        0x4F49, # G+10215  U+4F49  uni4F49,  CJK UNIFIED IDEOGRAPH-4F49
        0x4F4A, # G+10216  U+4F4A  uni4F4A,  CJK UNIFIED IDEOGRAPH-4F4A
        0x4F4B, # G+10217  U+4F4B  uni4F4B,  CJK UNIFIED IDEOGRAPH-4F4B
        0x4F4C, # G+10218  U+4F4C  uni4F4C,  CJK UNIFIED IDEOGRAPH-4F4C
        0x4F52, # G+10219  U+4F52  uni4F52,  CJK UNIFIED IDEOGRAPH-4F52
        0x4F54, # G+10220  U+4F54  uni4F54,  CJK UNIFIED IDEOGRAPH-4F54
        0x4F56, # G+10221  U+4F56  uni4F56,  CJK UNIFIED IDEOGRAPH-4F56
        0x4F61, # G+10222  U+4F61  uni4F61,  CJK UNIFIED IDEOGRAPH-4F61
        0x4F62, # G+10223  U+4F62  uni4F62,  CJK UNIFIED IDEOGRAPH-4F62
        0x4F66, # G+10224  U+4F66  uni4F66,  CJK UNIFIED IDEOGRAPH-4F66
        0x4F68, # G+10225  U+4F68  uni4F68,  CJK UNIFIED IDEOGRAPH-4F68
        0x4F6A, # G+10226  U+4F6A  uni4F6A,  CJK UNIFIED IDEOGRAPH-4F6A
        0x4F6B, # G+10227  U+4F6B  uni4F6B,  CJK UNIFIED IDEOGRAPH-4F6B
        0x4F6D, # G+10228  U+4F6D  uni4F6D,  CJK UNIFIED IDEOGRAPH-4F6D
        0x4F6E, # G+10229  U+4F6E  uni4F6E,  CJK UNIFIED IDEOGRAPH-4F6E
        0x4F71, # G+10230  U+4F71  uni4F71,  CJK UNIFIED IDEOGRAPH-4F71
        0x4F72, # G+10231  U+4F72  uni4F72,  CJK UNIFIED IDEOGRAPH-4F72
        0x4F75, # G+10232  U+4F75  uni4F75,  CJK UNIFIED IDEOGRAPH-4F75
        0x4F77, # G+10233  U+4F77  uni4F77,  CJK UNIFIED IDEOGRAPH-4F77
        0x4F78, # G+10234  U+4F78  uni4F78,  CJK UNIFIED IDEOGRAPH-4F78
        0x4F79, # G+10235  U+4F79  uni4F79,  CJK UNIFIED IDEOGRAPH-4F79
        0x4F7A, # G+10236  U+4F7A  uni4F7A,  CJK UNIFIED IDEOGRAPH-4F7A
        0x4F7D, # G+10237  U+4F7D  uni4F7D,  CJK UNIFIED IDEOGRAPH-4F7D
        0x4F80, # G+10238  U+4F80  uni4F80,  CJK UNIFIED IDEOGRAPH-4F80
        0x4F81, # G+10239  U+4F81  uni4F81,  CJK UNIFIED IDEOGRAPH-4F81
        0x4F82, # G+10240  U+4F82  uni4F82,  CJK UNIFIED IDEOGRAPH-4F82
        0x4F85, # G+10241  U+4F85  uni4F85,  CJK UNIFIED IDEOGRAPH-4F85
        0x4F87, # G+10242  U+4F87  uni4F87,  CJK UNIFIED IDEOGRAPH-4F87
        0x4F8A, # G+10243  U+4F8A  uni4F8A,  CJK UNIFIED IDEOGRAPH-4F8A
        0x4F8C, # G+10244  U+4F8C  uni4F8C,  CJK UNIFIED IDEOGRAPH-4F8C
        0x4F8E, # G+10245  U+4F8E  uni4F8E,  CJK UNIFIED IDEOGRAPH-4F8E
        0x4F90, # G+10246  U+4F90  uni4F90,  CJK UNIFIED IDEOGRAPH-4F90
        0x4F92, # G+10247  U+4F92  uni4F92,  CJK UNIFIED IDEOGRAPH-4F92
        0x4F93, # G+10248  U+4F93  uni4F93,  CJK UNIFIED IDEOGRAPH-4F93
        0x4F95, # G+10249  U+4F95  uni4F95,  CJK UNIFIED IDEOGRAPH-4F95
        0x4F98, # G+10250  U+4F98  uni4F98,  CJK UNIFIED IDEOGRAPH-4F98
        0x4F99, # G+10251  U+4F99  uni4F99,  CJK UNIFIED IDEOGRAPH-4F99
        0x4F9A, # G+10252  U+4F9A  uni4F9A,  CJK UNIFIED IDEOGRAPH-4F9A
        0x4F9C, # G+10253  U+4F9C  uni4F9C,  CJK UNIFIED IDEOGRAPH-4F9C
        0x4F9E, # G+10254  U+4F9E  uni4F9E,  CJK UNIFIED IDEOGRAPH-4F9E
        0x4F9F, # G+10255  U+4F9F  uni4F9F,  CJK UNIFIED IDEOGRAPH-4F9F
        0x4FA1, # G+10256  U+4FA1  uni4FA1,  CJK UNIFIED IDEOGRAPH-4FA1
        0x4FA2, # G+10257  U+4FA2  uni4FA2,  CJK UNIFIED IDEOGRAPH-4FA2
        0x4FA4, # G+10258  U+4FA4  uni4FA4,  CJK UNIFIED IDEOGRAPH-4FA4
        0x4FAB, # G+10259  U+4FAB  uni4FAB,  CJK UNIFIED IDEOGRAPH-4FAB
        0x4FAD, # G+10260  U+4FAD  uni4FAD,  CJK UNIFIED IDEOGRAPH-4FAD
        0x4FB0, # G+10261  U+4FB0  uni4FB0,  CJK UNIFIED IDEOGRAPH-4FB0
        0x4FB1, # G+10262  U+4FB1  uni4FB1,  CJK UNIFIED IDEOGRAPH-4FB1
        0x4FB2, # G+10263  U+4FB2  uni4FB2,  CJK UNIFIED IDEOGRAPH-4FB2
        0x4FB3, # G+10264  U+4FB3  uni4FB3,  CJK UNIFIED IDEOGRAPH-4FB3
        0x4FB4, # G+10265  U+4FB4  uni4FB4,  CJK UNIFIED IDEOGRAPH-4FB4
        0x4FB6, # G+10266  U+4FB6  uni4FB6,  CJK UNIFIED IDEOGRAPH-4FB6
        0x4FB7, # G+10267  U+4FB7  uni4FB7,  CJK UNIFIED IDEOGRAPH-4FB7
        0x4FB8, # G+10268  U+4FB8  uni4FB8,  CJK UNIFIED IDEOGRAPH-4FB8
        0x4FB9, # G+10269  U+4FB9  uni4FB9,  CJK UNIFIED IDEOGRAPH-4FB9
        0x4FBA, # G+10270  U+4FBA  uni4FBA,  CJK UNIFIED IDEOGRAPH-4FBA
        0x4FBB, # G+10271  U+4FBB  uni4FBB,  CJK UNIFIED IDEOGRAPH-4FBB
        0x4FBC, # G+10272  U+4FBC  uni4FBC,  CJK UNIFIED IDEOGRAPH-4FBC
        0x4FBD, # G+10273  U+4FBD  uni4FBD,  CJK UNIFIED IDEOGRAPH-4FBD
        0x4FBE, # G+10274  U+4FBE  uni4FBE,  CJK UNIFIED IDEOGRAPH-4FBE
        0x4FC0, # G+10275  U+4FC0  uni4FC0,  CJK UNIFIED IDEOGRAPH-4FC0
        0x4FC1, # G+10276  U+4FC1  uni4FC1,  CJK UNIFIED IDEOGRAPH-4FC1
        0x4FC6, # G+10277  U+4FC6  uni4FC6,  CJK UNIFIED IDEOGRAPH-4FC6
        0x4FC7, # G+10278  U+4FC7  uni4FC7,  CJK UNIFIED IDEOGRAPH-4FC7
        0x4FC8, # G+10279  U+4FC8  uni4FC8,  CJK UNIFIED IDEOGRAPH-4FC8
        0x4FC9, # G+10280  U+4FC9  uni4FC9,  CJK UNIFIED IDEOGRAPH-4FC9
        0x4FCB, # G+10281  U+4FCB  uni4FCB,  CJK UNIFIED IDEOGRAPH-4FCB
        0x4FCC, # G+10282  U+4FCC  uni4FCC,  CJK UNIFIED IDEOGRAPH-4FCC
        0x4FCD, # G+10283  U+4FCD  uni4FCD,  CJK UNIFIED IDEOGRAPH-4FCD
        0x4FD2, # G+10284  U+4FD2  uni4FD2,  CJK UNIFIED IDEOGRAPH-4FD2
        0x4FD3, # G+10285  U+4FD3  uni4FD3,  CJK UNIFIED IDEOGRAPH-4FD3
        0x4FD4, # G+10286  U+4FD4  uni4FD4,  CJK UNIFIED IDEOGRAPH-4FD4
        0x4FD5, # G+10287  U+4FD5  uni4FD5,  CJK UNIFIED IDEOGRAPH-4FD5
        0x4FD6, # G+10288  U+4FD6  uni4FD6,  CJK UNIFIED IDEOGRAPH-4FD6
        0x4FD9, # G+10289  U+4FD9  uni4FD9,  CJK UNIFIED IDEOGRAPH-4FD9
        0x4FDB, # G+10290  U+4FDB  uni4FDB,  CJK UNIFIED IDEOGRAPH-4FDB
        0x4FE2, # G+10291  U+4FE2  uni4FE2,  CJK UNIFIED IDEOGRAPH-4FE2
        0x4FE4, # G+10292  U+4FE4  uni4FE4,  CJK UNIFIED IDEOGRAPH-4FE4
        0x4FE5, # G+10293  U+4FE5  uni4FE5,  CJK UNIFIED IDEOGRAPH-4FE5
        0x4FE7, # G+10294  U+4FE7  uni4FE7,  CJK UNIFIED IDEOGRAPH-4FE7
        0x4FEB, # G+10295  U+4FEB  uni4FEB,  CJK UNIFIED IDEOGRAPH-4FEB
        0x4FEC, # G+10296  U+4FEC  uni4FEC,  CJK UNIFIED IDEOGRAPH-4FEC
        0x4FF0, # G+10297  U+4FF0  uni4FF0,  CJK UNIFIED IDEOGRAPH-4FF0
        0x4FF2, # G+10298  U+4FF2  uni4FF2,  CJK UNIFIED IDEOGRAPH-4FF2
        0x4FF4, # G+10299  U+4FF4  uni4FF4,  CJK UNIFIED IDEOGRAPH-4FF4
        0x4FF5, # G+10300  U+4FF5  uni4FF5,  CJK UNIFIED IDEOGRAPH-4FF5
        0x4FF6, # G+10301  U+4FF6  uni4FF6,  CJK UNIFIED IDEOGRAPH-4FF6
        0x4FF7, # G+10302  U+4FF7  uni4FF7,  CJK UNIFIED IDEOGRAPH-4FF7
        0x4FF9, # G+10303  U+4FF9  uni4FF9,  CJK UNIFIED IDEOGRAPH-4FF9
        0x4FFB, # G+10304  U+4FFB  uni4FFB,  CJK UNIFIED IDEOGRAPH-4FFB
        0x4FFC, # G+10305  U+4FFC  uni4FFC,  CJK UNIFIED IDEOGRAPH-4FFC
        0x4FFD, # G+10306  U+4FFD  uni4FFD,  CJK UNIFIED IDEOGRAPH-4FFD
        0x4FFF, # G+10307  U+4FFF  uni4FFF,  CJK UNIFIED IDEOGRAPH-4FFF
        0x5001, # G+10308  U+5001  uni5001,  CJK UNIFIED IDEOGRAPH-5001
        0x5002, # G+10309  U+5002  uni5002,  CJK UNIFIED IDEOGRAPH-5002
        0x5003, # G+10310  U+5003  uni5003,  CJK UNIFIED IDEOGRAPH-5003
        0x5004, # G+10311  U+5004  uni5004,  CJK UNIFIED IDEOGRAPH-5004
        0x5005, # G+10312  U+5005  uni5005,  CJK UNIFIED IDEOGRAPH-5005
        0x5007, # G+10313  U+5007  uni5007,  CJK UNIFIED IDEOGRAPH-5007
        0x5008, # G+10314  U+5008  uni5008,  CJK UNIFIED IDEOGRAPH-5008
        0x500A, # G+10315  U+500A  uni500A,  CJK UNIFIED IDEOGRAPH-500A
        0x500E, # G+10316  U+500E  uni500E,  CJK UNIFIED IDEOGRAPH-500E
        0x5010, # G+10317  U+5010  uni5010,  CJK UNIFIED IDEOGRAPH-5010
        0x5013, # G+10318  U+5013  uni5013,  CJK UNIFIED IDEOGRAPH-5013
        0x5015, # G+10319  U+5015  uni5015,  CJK UNIFIED IDEOGRAPH-5015
        0x5016, # G+10320  U+5016  uni5016,  CJK UNIFIED IDEOGRAPH-5016
        0x5017, # G+10321  U+5017  uni5017,  CJK UNIFIED IDEOGRAPH-5017
        0x501B, # G+10322  U+501B  uni501B,  CJK UNIFIED IDEOGRAPH-501B
        0x501D, # G+10323  U+501D  uni501D,  CJK UNIFIED IDEOGRAPH-501D
        0x501E, # G+10324  U+501E  uni501E,  CJK UNIFIED IDEOGRAPH-501E
        0x5020, # G+10325  U+5020  uni5020,  CJK UNIFIED IDEOGRAPH-5020
        0x5022, # G+10326  U+5022  uni5022,  CJK UNIFIED IDEOGRAPH-5022
        0x5023, # G+10327  U+5023  uni5023,  CJK UNIFIED IDEOGRAPH-5023
        0x5024, # G+10328  U+5024  uni5024,  CJK UNIFIED IDEOGRAPH-5024
        0x5027, # G+10329  U+5027  uni5027,  CJK UNIFIED IDEOGRAPH-5027
        0x502F, # G+10330  U+502F  uni502F,  CJK UNIFIED IDEOGRAPH-502F
        0x5030, # G+10331  U+5030  uni5030,  CJK UNIFIED IDEOGRAPH-5030
        0x5031, # G+10332  U+5031  uni5031,  CJK UNIFIED IDEOGRAPH-5031
        0x5032, # G+10333  U+5032  uni5032,  CJK UNIFIED IDEOGRAPH-5032
        0x5033, # G+10334  U+5033  uni5033,  CJK UNIFIED IDEOGRAPH-5033
        0x5034, # G+10335  U+5034  uni5034,  CJK UNIFIED IDEOGRAPH-5034
        0x5035, # G+10336  U+5035  uni5035,  CJK UNIFIED IDEOGRAPH-5035
        0x5036, # G+10337  U+5036  uni5036,  CJK UNIFIED IDEOGRAPH-5036
        0x5037, # G+10338  U+5037  uni5037,  CJK UNIFIED IDEOGRAPH-5037
        0x5038, # G+10339  U+5038  uni5038,  CJK UNIFIED IDEOGRAPH-5038
        0x5039, # G+10340  U+5039  uni5039,  CJK UNIFIED IDEOGRAPH-5039
        0x503B, # G+10341  U+503B  uni503B,  CJK UNIFIED IDEOGRAPH-503B
        0x503D, # G+10342  U+503D  uni503D,  CJK UNIFIED IDEOGRAPH-503D
        0x503F, # G+10343  U+503F  uni503F,  CJK UNIFIED IDEOGRAPH-503F
        0x5040, # G+10344  U+5040  uni5040,  CJK UNIFIED IDEOGRAPH-5040
        0x5041, # G+10345  U+5041  uni5041,  CJK UNIFIED IDEOGRAPH-5041
        0x5042, # G+10346  U+5042  uni5042,  CJK UNIFIED IDEOGRAPH-5042
        0x5044, # G+10347  U+5044  uni5044,  CJK UNIFIED IDEOGRAPH-5044
        0x5045, # G+10348  U+5045  uni5045,  CJK UNIFIED IDEOGRAPH-5045
        0x5046, # G+10349  U+5046  uni5046,  CJK UNIFIED IDEOGRAPH-5046
        0x504A, # G+10350  U+504A  uni504A,  CJK UNIFIED IDEOGRAPH-504A
        0x504B, # G+10351  U+504B  uni504B,  CJK UNIFIED IDEOGRAPH-504B
        0x504D, # G+10352  U+504D  uni504D,  CJK UNIFIED IDEOGRAPH-504D
        0x5050, # G+10353  U+5050  uni5050,  CJK UNIFIED IDEOGRAPH-5050
        0x5051, # G+10354  U+5051  uni5051,  CJK UNIFIED IDEOGRAPH-5051
        0x5052, # G+10355  U+5052  uni5052,  CJK UNIFIED IDEOGRAPH-5052
        0x5053, # G+10356  U+5053  uni5053,  CJK UNIFIED IDEOGRAPH-5053
        0x5054, # G+10357  U+5054  uni5054,  CJK UNIFIED IDEOGRAPH-5054
        0x5056, # G+10358  U+5056  uni5056,  CJK UNIFIED IDEOGRAPH-5056
        0x5057, # G+10359  U+5057  uni5057,  CJK UNIFIED IDEOGRAPH-5057
        0x5058, # G+10360  U+5058  uni5058,  CJK UNIFIED IDEOGRAPH-5058
        0x5059, # G+10361  U+5059  uni5059,  CJK UNIFIED IDEOGRAPH-5059
        0x505B, # G+10362  U+505B  uni505B,  CJK UNIFIED IDEOGRAPH-505B
        0x505D, # G+10363  U+505D  uni505D,  CJK UNIFIED IDEOGRAPH-505D
        0x505E, # G+10364  U+505E  uni505E,  CJK UNIFIED IDEOGRAPH-505E
        0x505F, # G+10365  U+505F  uni505F,  CJK UNIFIED IDEOGRAPH-505F
        0x5060, # G+10366  U+5060  uni5060,  CJK UNIFIED IDEOGRAPH-5060
        0x5061, # G+10367  U+5061  uni5061,  CJK UNIFIED IDEOGRAPH-5061
        0x5062, # G+10368  U+5062  uni5062,  CJK UNIFIED IDEOGRAPH-5062
        0x5063, # G+10369  U+5063  uni5063,  CJK UNIFIED IDEOGRAPH-5063
        0x5064, # G+10370  U+5064  uni5064,  CJK UNIFIED IDEOGRAPH-5064
        0x5066, # G+10371  U+5066  uni5066,  CJK UNIFIED IDEOGRAPH-5066
        0x5067, # G+10372  U+5067  uni5067,  CJK UNIFIED IDEOGRAPH-5067
        0x5068, # G+10373  U+5068  uni5068,  CJK UNIFIED IDEOGRAPH-5068
        0x5069, # G+10374  U+5069  uni5069,  CJK UNIFIED IDEOGRAPH-5069
        0x506A, # G+10375  U+506A  uni506A,  CJK UNIFIED IDEOGRAPH-506A
        0x506B, # G+10376  U+506B  uni506B,  CJK UNIFIED IDEOGRAPH-506B
        0x506D, # G+10377  U+506D  uni506D,  CJK UNIFIED IDEOGRAPH-506D
        0x506E, # G+10378  U+506E  uni506E,  CJK UNIFIED IDEOGRAPH-506E
        0x506F, # G+10379  U+506F  uni506F,  CJK UNIFIED IDEOGRAPH-506F
        0x5070, # G+10380  U+5070  uni5070,  CJK UNIFIED IDEOGRAPH-5070
        0x5071, # G+10381  U+5071  uni5071,  CJK UNIFIED IDEOGRAPH-5071
        0x5072, # G+10382  U+5072  uni5072,  CJK UNIFIED IDEOGRAPH-5072
        0x5073, # G+10383  U+5073  uni5073,  CJK UNIFIED IDEOGRAPH-5073
        0x5078, # G+10384  U+5078  uni5078,  CJK UNIFIED IDEOGRAPH-5078
        0x5079, # G+10385  U+5079  uni5079,  CJK UNIFIED IDEOGRAPH-5079
        0x507A, # G+10386  U+507A  uni507A,  CJK UNIFIED IDEOGRAPH-507A
        0x507C, # G+10387  U+507C  uni507C,  CJK UNIFIED IDEOGRAPH-507C
        0x507D, # G+10388  U+507D  uni507D,  CJK UNIFIED IDEOGRAPH-507D
        0x5081, # G+10389  U+5081  uni5081,  CJK UNIFIED IDEOGRAPH-5081
        0x5082, # G+10390  U+5082  uni5082,  CJK UNIFIED IDEOGRAPH-5082
        0x5083, # G+10391  U+5083  uni5083,  CJK UNIFIED IDEOGRAPH-5083
        0x5084, # G+10392  U+5084  uni5084,  CJK UNIFIED IDEOGRAPH-5084
        0x5086, # G+10393  U+5086  uni5086,  CJK UNIFIED IDEOGRAPH-5086
        0x5087, # G+10394  U+5087  uni5087,  CJK UNIFIED IDEOGRAPH-5087
        0x5089, # G+10395  U+5089  uni5089,  CJK UNIFIED IDEOGRAPH-5089
        0x508A, # G+10396  U+508A  uni508A,  CJK UNIFIED IDEOGRAPH-508A
        0x508B, # G+10397  U+508B  uni508B,  CJK UNIFIED IDEOGRAPH-508B
        0x508C, # G+10398  U+508C  uni508C,  CJK UNIFIED IDEOGRAPH-508C
        0x508E, # G+10399  U+508E  uni508E,  CJK UNIFIED IDEOGRAPH-508E
        0x508F, # G+10400  U+508F  uni508F,  CJK UNIFIED IDEOGRAPH-508F
        0x5090, # G+10401  U+5090  uni5090,  CJK UNIFIED IDEOGRAPH-5090
        0x5091, # G+10402  U+5091  uni5091,  CJK UNIFIED IDEOGRAPH-5091
        0x5092, # G+10403  U+5092  uni5092,  CJK UNIFIED IDEOGRAPH-5092
        0x5093, # G+10404  U+5093  uni5093,  CJK UNIFIED IDEOGRAPH-5093
        0x5094, # G+10405  U+5094  uni5094,  CJK UNIFIED IDEOGRAPH-5094
        0x5095, # G+10406  U+5095  uni5095,  CJK UNIFIED IDEOGRAPH-5095
        0x5097, # G+10407  U+5097  uni5097,  CJK UNIFIED IDEOGRAPH-5097
        0x509A, # G+10408  U+509A  uni509A,  CJK UNIFIED IDEOGRAPH-509A
        0x509B, # G+10409  U+509B  uni509B,  CJK UNIFIED IDEOGRAPH-509B
        0x509C, # G+10410  U+509C  uni509C,  CJK UNIFIED IDEOGRAPH-509C
        0x509D, # G+10411  U+509D  uni509D,  CJK UNIFIED IDEOGRAPH-509D
        0x509E, # G+10412  U+509E  uni509E,  CJK UNIFIED IDEOGRAPH-509E
        0x509F, # G+10413  U+509F  uni509F,  CJK UNIFIED IDEOGRAPH-509F
        0x50A0, # G+10414  U+50A0  uni50A0,  CJK UNIFIED IDEOGRAPH-50A0
        0x50A1, # G+10415  U+50A1  uni50A1,  CJK UNIFIED IDEOGRAPH-50A1
        0x50A4, # G+10416  U+50A4  uni50A4,  CJK UNIFIED IDEOGRAPH-50A4
        0x50A6, # G+10417  U+50A6  uni50A6,  CJK UNIFIED IDEOGRAPH-50A6
        0x50AA, # G+10418  U+50AA  uni50AA,  CJK UNIFIED IDEOGRAPH-50AA
        0x50AB, # G+10419  U+50AB  uni50AB,  CJK UNIFIED IDEOGRAPH-50AB
        0x50AE, # G+10420  U+50AE  uni50AE,  CJK UNIFIED IDEOGRAPH-50AE
        0x50AF, # G+10421  U+50AF  uni50AF,  CJK UNIFIED IDEOGRAPH-50AF
        0x50B0, # G+10422  U+50B0  uni50B0,  CJK UNIFIED IDEOGRAPH-50B0
        0x50B1, # G+10423  U+50B1  uni50B1,  CJK UNIFIED IDEOGRAPH-50B1
        0x50B6, # G+10424  U+50B6  uni50B6,  CJK UNIFIED IDEOGRAPH-50B6
        0x50B8, # G+10425  U+50B8  uni50B8,  CJK UNIFIED IDEOGRAPH-50B8
        0x50B9, # G+10426  U+50B9  uni50B9,  CJK UNIFIED IDEOGRAPH-50B9
        0x50BC, # G+10427  U+50BC  uni50BC,  CJK UNIFIED IDEOGRAPH-50BC
        0x50BD, # G+10428  U+50BD  uni50BD,  CJK UNIFIED IDEOGRAPH-50BD
        0x50BF, # G+10429  U+50BF  uni50BF,  CJK UNIFIED IDEOGRAPH-50BF
        0x50C0, # G+10430  U+50C0  uni50C0,  CJK UNIFIED IDEOGRAPH-50C0
        0x50C1, # G+10431  U+50C1  uni50C1,  CJK UNIFIED IDEOGRAPH-50C1
        0x50C3, # G+10432  U+50C3  uni50C3,  CJK UNIFIED IDEOGRAPH-50C3
        0x50C4, # G+10433  U+50C4  uni50C4,  CJK UNIFIED IDEOGRAPH-50C4
        0x50C6, # G+10434  U+50C6  uni50C6,  CJK UNIFIED IDEOGRAPH-50C6
        0x50C7, # G+10435  U+50C7  uni50C7,  CJK UNIFIED IDEOGRAPH-50C7
        0x50C8, # G+10436  U+50C8  uni50C8,  CJK UNIFIED IDEOGRAPH-50C8
        0x50CA, # G+10437  U+50CA  uni50CA,  CJK UNIFIED IDEOGRAPH-50CA
        0x50CB, # G+10438  U+50CB  uni50CB,  CJK UNIFIED IDEOGRAPH-50CB
        0x50CC, # G+10439  U+50CC  uni50CC,  CJK UNIFIED IDEOGRAPH-50CC
        0x50CD, # G+10440  U+50CD  uni50CD,  CJK UNIFIED IDEOGRAPH-50CD
        0x50CE, # G+10441  U+50CE  uni50CE,  CJK UNIFIED IDEOGRAPH-50CE
        0x50D0, # G+10442  U+50D0  uni50D0,  CJK UNIFIED IDEOGRAPH-50D0
        0x50D2, # G+10443  U+50D2  uni50D2,  CJK UNIFIED IDEOGRAPH-50D2
        0x50D3, # G+10444  U+50D3  uni50D3,  CJK UNIFIED IDEOGRAPH-50D3
        0x50D4, # G+10445  U+50D4  uni50D4,  CJK UNIFIED IDEOGRAPH-50D4
        0x50D7, # G+10446  U+50D7  uni50D7,  CJK UNIFIED IDEOGRAPH-50D7
        0x50D8, # G+10447  U+50D8  uni50D8,  CJK UNIFIED IDEOGRAPH-50D8
        0x50D9, # G+10448  U+50D9  uni50D9,  CJK UNIFIED IDEOGRAPH-50D9
        0x50DB, # G+10449  U+50DB  uni50DB,  CJK UNIFIED IDEOGRAPH-50DB
        0x50DC, # G+10450  U+50DC  uni50DC,  CJK UNIFIED IDEOGRAPH-50DC
        0x50DD, # G+10451  U+50DD  uni50DD,  CJK UNIFIED IDEOGRAPH-50DD
        0x50DF, # G+10452  U+50DF  uni50DF,  CJK UNIFIED IDEOGRAPH-50DF
        0x50E0, # G+10453  U+50E0  uni50E0,  CJK UNIFIED IDEOGRAPH-50E0
        0x50E1, # G+10454  U+50E1  uni50E1,  CJK UNIFIED IDEOGRAPH-50E1
        0x50E2, # G+10455  U+50E2  uni50E2,  CJK UNIFIED IDEOGRAPH-50E2
        0x50E3, # G+10456  U+50E3  uni50E3,  CJK UNIFIED IDEOGRAPH-50E3
        0x50E4, # G+10457  U+50E4  uni50E4,  CJK UNIFIED IDEOGRAPH-50E4
        0x50E9, # G+10458  U+50E9  uni50E9,  CJK UNIFIED IDEOGRAPH-50E9
        0x50EA, # G+10459  U+50EA  uni50EA,  CJK UNIFIED IDEOGRAPH-50EA
        0x50EB, # G+10460  U+50EB  uni50EB,  CJK UNIFIED IDEOGRAPH-50EB
        0x50EF, # G+10461  U+50EF  uni50EF,  CJK UNIFIED IDEOGRAPH-50EF
        0x50F0, # G+10462  U+50F0  uni50F0,  CJK UNIFIED IDEOGRAPH-50F0
        0x50F1, # G+10463  U+50F1  uni50F1,  CJK UNIFIED IDEOGRAPH-50F1
        0x50F2, # G+10464  U+50F2  uni50F2,  CJK UNIFIED IDEOGRAPH-50F2
        0x50F4, # G+10465  U+50F4  uni50F4,  CJK UNIFIED IDEOGRAPH-50F4
        0x50F6, # G+10466  U+50F6  uni50F6,  CJK UNIFIED IDEOGRAPH-50F6
        0x50F7, # G+10467  U+50F7  uni50F7,  CJK UNIFIED IDEOGRAPH-50F7
        0x50F8, # G+10468  U+50F8  uni50F8,  CJK UNIFIED IDEOGRAPH-50F8
        0x50FA, # G+10469  U+50FA  uni50FA,  CJK UNIFIED IDEOGRAPH-50FA
        0x50FC, # G+10470  U+50FC  uni50FC,  CJK UNIFIED IDEOGRAPH-50FC
        0x50FD, # G+10471  U+50FD  uni50FD,  CJK UNIFIED IDEOGRAPH-50FD
        0x50FE, # G+10472  U+50FE  uni50FE,  CJK UNIFIED IDEOGRAPH-50FE
        0x50FF, # G+10473  U+50FF  uni50FF,  CJK UNIFIED IDEOGRAPH-50FF
        0x5101, # G+10474  U+5101  uni5101,  CJK UNIFIED IDEOGRAPH-5101
        0x5103, # G+10475  U+5103  uni5103,  CJK UNIFIED IDEOGRAPH-5103
        0x5105, # G+10476  U+5105  uni5105,  CJK UNIFIED IDEOGRAPH-5105
        0x510A, # G+10477  U+510A  uni510A,  CJK UNIFIED IDEOGRAPH-510A
        0x510C, # G+10478  U+510C  uni510C,  CJK UNIFIED IDEOGRAPH-510C
        0x510D, # G+10479  U+510D  uni510D,  CJK UNIFIED IDEOGRAPH-510D
        0x510E, # G+10480  U+510E  uni510E,  CJK UNIFIED IDEOGRAPH-510E
        0x510F, # G+10481  U+510F  uni510F,  CJK UNIFIED IDEOGRAPH-510F
        0x5111, # G+10482  U+5111  uni5111,  CJK UNIFIED IDEOGRAPH-5111
        0x5113, # G+10483  U+5113  uni5113,  CJK UNIFIED IDEOGRAPH-5113
        0x5116, # G+10484  U+5116  uni5116,  CJK UNIFIED IDEOGRAPH-5116
        0x5117, # G+10485  U+5117  uni5117,  CJK UNIFIED IDEOGRAPH-5117
        0x5119, # G+10486  U+5119  uni5119,  CJK UNIFIED IDEOGRAPH-5119
        0x511A, # G+10487  U+511A  uni511A,  CJK UNIFIED IDEOGRAPH-511A
        0x511B, # G+10488  U+511B  uni511B,  CJK UNIFIED IDEOGRAPH-511B
        0x511C, # G+10489  U+511C  uni511C,  CJK UNIFIED IDEOGRAPH-511C
        0x511D, # G+10490  U+511D  uni511D,  CJK UNIFIED IDEOGRAPH-511D
        0x511E, # G+10491  U+511E  uni511E,  CJK UNIFIED IDEOGRAPH-511E
        0x5120, # G+10492  U+5120  uni5120,  CJK UNIFIED IDEOGRAPH-5120
        0x5122, # G+10493  U+5122  uni5122,  CJK UNIFIED IDEOGRAPH-5122
        0x5123, # G+10494  U+5123  uni5123,  CJK UNIFIED IDEOGRAPH-5123
        0x5124, # G+10495  U+5124  uni5124,  CJK UNIFIED IDEOGRAPH-5124
        0x5125, # G+10496  U+5125  uni5125,  CJK UNIFIED IDEOGRAPH-5125
        0x5126, # G+10497  U+5126  uni5126,  CJK UNIFIED IDEOGRAPH-5126
        0x5127, # G+10498  U+5127  uni5127,  CJK UNIFIED IDEOGRAPH-5127
        0x5128, # G+10499  U+5128  uni5128,  CJK UNIFIED IDEOGRAPH-5128
        0x5129, # G+10500  U+5129  uni5129,  CJK UNIFIED IDEOGRAPH-5129
        0x512B, # G+10501  U+512B  uni512B,  CJK UNIFIED IDEOGRAPH-512B
        0x512C, # G+10502  U+512C  uni512C,  CJK UNIFIED IDEOGRAPH-512C
        0x512D, # G+10503  U+512D  uni512D,  CJK UNIFIED IDEOGRAPH-512D
        0x512E, # G+10504  U+512E  uni512E,  CJK UNIFIED IDEOGRAPH-512E
        0x512F, # G+10505  U+512F  uni512F,  CJK UNIFIED IDEOGRAPH-512F
        0x5130, # G+10506  U+5130  uni5130,  CJK UNIFIED IDEOGRAPH-5130
        0x5131, # G+10507  U+5131  uni5131,  CJK UNIFIED IDEOGRAPH-5131
        0x5133, # G+10508  U+5133  uni5133,  CJK UNIFIED IDEOGRAPH-5133
        0x5134, # G+10509  U+5134  uni5134,  CJK UNIFIED IDEOGRAPH-5134
        0x5135, # G+10510  U+5135  uni5135,  CJK UNIFIED IDEOGRAPH-5135
        0x5136, # G+10511  U+5136  uni5136,  CJK UNIFIED IDEOGRAPH-5136
        0x5138, # G+10512  U+5138  uni5138,  CJK UNIFIED IDEOGRAPH-5138
        0x5139, # G+10513  U+5139  uni5139,  CJK UNIFIED IDEOGRAPH-5139
        0x513D, # G+10514  U+513D  uni513D,  CJK UNIFIED IDEOGRAPH-513D
        0x513E, # G+10515  U+513E  uni513E,  CJK UNIFIED IDEOGRAPH-513E
        0x5142, # G+10516  U+5142  uni5142,  CJK UNIFIED IDEOGRAPH-5142
        0x5147, # G+10517  U+5147  uni5147,  CJK UNIFIED IDEOGRAPH-5147
        0x514A, # G+10518  U+514A  uni514A,  CJK UNIFIED IDEOGRAPH-514A
        0x514C, # G+10519  U+514C  uni514C,  CJK UNIFIED IDEOGRAPH-514C
        0x514E, # G+10520  U+514E  uni514E,  CJK UNIFIED IDEOGRAPH-514E
        0x514F, # G+10521  U+514F  uni514F,  CJK UNIFIED IDEOGRAPH-514F
        0x5150, # G+10522  U+5150  uni5150,  CJK UNIFIED IDEOGRAPH-5150
        0x5153, # G+10523  U+5153  uni5153,  CJK UNIFIED IDEOGRAPH-5153
        0x5157, # G+10524  U+5157  uni5157,  CJK UNIFIED IDEOGRAPH-5157
        0x5158, # G+10525  U+5158  uni5158,  CJK UNIFIED IDEOGRAPH-5158
        0x5159, # G+10526  U+5159  uni5159,  CJK UNIFIED IDEOGRAPH-5159
        0x515B, # G+10527  U+515B  uni515B,  CJK UNIFIED IDEOGRAPH-515B
        0x515D, # G+10528  U+515D  uni515D,  CJK UNIFIED IDEOGRAPH-515D
        0x515E, # G+10529  U+515E  uni515E,  CJK UNIFIED IDEOGRAPH-515E
        0x515F, # G+10530  U+515F  uni515F,  CJK UNIFIED IDEOGRAPH-515F
        0x5160, # G+10531  U+5160  uni5160,  CJK UNIFIED IDEOGRAPH-5160
        0x5161, # G+10532  U+5161  uni5161,  CJK UNIFIED IDEOGRAPH-5161
        0x5163, # G+10533  U+5163  uni5163,  CJK UNIFIED IDEOGRAPH-5163
        0x5164, # G+10534  U+5164  uni5164,  CJK UNIFIED IDEOGRAPH-5164
        0x5166, # G+10535  U+5166  uni5166,  CJK UNIFIED IDEOGRAPH-5166
        0x5167, # G+10536  U+5167  uni5167,  CJK UNIFIED IDEOGRAPH-5167
        0x516A, # G+10537  U+516A  uni516A,  CJK UNIFIED IDEOGRAPH-516A
        0x516F, # G+10538  U+516F  uni516F,  CJK UNIFIED IDEOGRAPH-516F
        0x5172, # G+10539  U+5172  uni5172,  CJK UNIFIED IDEOGRAPH-5172
        0x517A, # G+10540  U+517A  uni517A,  CJK UNIFIED IDEOGRAPH-517A
        0x517E, # G+10541  U+517E  uni517E,  CJK UNIFIED IDEOGRAPH-517E
        0x517F, # G+10542  U+517F  uni517F,  CJK UNIFIED IDEOGRAPH-517F
        0x5183, # G+10543  U+5183  uni5183,  CJK UNIFIED IDEOGRAPH-5183
        0x5184, # G+10544  U+5184  uni5184,  CJK UNIFIED IDEOGRAPH-5184
        0x5186, # G+10545  U+5186  uni5186,  CJK UNIFIED IDEOGRAPH-5186
        0x5187, # G+10546  U+5187  uni5187,  CJK UNIFIED IDEOGRAPH-5187
        0x518A, # G+10547  U+518A  uni518A,  CJK UNIFIED IDEOGRAPH-518A
        0x518B, # G+10548  U+518B  uni518B,  CJK UNIFIED IDEOGRAPH-518B
        0x518E, # G+10549  U+518E  uni518E,  CJK UNIFIED IDEOGRAPH-518E
        0x518F, # G+10550  U+518F  uni518F,  CJK UNIFIED IDEOGRAPH-518F
        0x5190, # G+10551  U+5190  uni5190,  CJK UNIFIED IDEOGRAPH-5190
        0x5191, # G+10552  U+5191  uni5191,  CJK UNIFIED IDEOGRAPH-5191
        0x5193, # G+10553  U+5193  uni5193,  CJK UNIFIED IDEOGRAPH-5193
        0x5194, # G+10554  U+5194  uni5194,  CJK UNIFIED IDEOGRAPH-5194
        0x5198, # G+10555  U+5198  uni5198,  CJK UNIFIED IDEOGRAPH-5198
        0x519A, # G+10556  U+519A  uni519A,  CJK UNIFIED IDEOGRAPH-519A
        0x519D, # G+10557  U+519D  uni519D,  CJK UNIFIED IDEOGRAPH-519D
        0x519E, # G+10558  U+519E  uni519E,  CJK UNIFIED IDEOGRAPH-519E
        0x519F, # G+10559  U+519F  uni519F,  CJK UNIFIED IDEOGRAPH-519F
        0x51A1, # G+10560  U+51A1  uni51A1,  CJK UNIFIED IDEOGRAPH-51A1
        0x51A3, # G+10561  U+51A3  uni51A3,  CJK UNIFIED IDEOGRAPH-51A3
        0x51A6, # G+10562  U+51A6  uni51A6,  CJK UNIFIED IDEOGRAPH-51A6
        0x51A7, # G+10563  U+51A7  uni51A7,  CJK UNIFIED IDEOGRAPH-51A7
        0x51A8, # G+10564  U+51A8  uni51A8,  CJK UNIFIED IDEOGRAPH-51A8
        0x51A9, # G+10565  U+51A9  uni51A9,  CJK UNIFIED IDEOGRAPH-51A9
        0x51AA, # G+10566  U+51AA  uni51AA,  CJK UNIFIED IDEOGRAPH-51AA
        0x51AD, # G+10567  U+51AD  uni51AD,  CJK UNIFIED IDEOGRAPH-51AD
        0x51AE, # G+10568  U+51AE  uni51AE,  CJK UNIFIED IDEOGRAPH-51AE
        0x51B4, # G+10569  U+51B4  uni51B4,  CJK UNIFIED IDEOGRAPH-51B4
        0x51B8, # G+10570  U+51B8  uni51B8,  CJK UNIFIED IDEOGRAPH-51B8
        0x51B9, # G+10571  U+51B9  uni51B9,  CJK UNIFIED IDEOGRAPH-51B9
        0x51BA, # G+10572  U+51BA  uni51BA,  CJK UNIFIED IDEOGRAPH-51BA
        0x51BE, # G+10573  U+51BE  uni51BE,  CJK UNIFIED IDEOGRAPH-51BE
        0x51BF, # G+10574  U+51BF  uni51BF,  CJK UNIFIED IDEOGRAPH-51BF
        0x51C1, # G+10575  U+51C1  uni51C1,  CJK UNIFIED IDEOGRAPH-51C1
        0x51C2, # G+10576  U+51C2  uni51C2,  CJK UNIFIED IDEOGRAPH-51C2
        0x51C3, # G+10577  U+51C3  uni51C3,  CJK UNIFIED IDEOGRAPH-51C3
        0x51C5, # G+10578  U+51C5  uni51C5,  CJK UNIFIED IDEOGRAPH-51C5
        0x51C8, # G+10579  U+51C8  uni51C8,  CJK UNIFIED IDEOGRAPH-51C8
        0x51CA, # G+10580  U+51CA  uni51CA,  CJK UNIFIED IDEOGRAPH-51CA
        0x51CE, # G+10581  U+51CE  uni51CE,  CJK UNIFIED IDEOGRAPH-51CE
        0x51D0, # G+10582  U+51D0  uni51D0,  CJK UNIFIED IDEOGRAPH-51D0
        0x51D2, # G+10583  U+51D2  uni51D2,  CJK UNIFIED IDEOGRAPH-51D2
        0x51D3, # G+10584  U+51D3  uni51D3,  CJK UNIFIED IDEOGRAPH-51D3
        0x51D4, # G+10585  U+51D4  uni51D4,  CJK UNIFIED IDEOGRAPH-51D4
        0x51D5, # G+10586  U+51D5  uni51D5,  CJK UNIFIED IDEOGRAPH-51D5
        0x51D6, # G+10587  U+51D6  uni51D6,  CJK UNIFIED IDEOGRAPH-51D6
        0x51D7, # G+10588  U+51D7  uni51D7,  CJK UNIFIED IDEOGRAPH-51D7
        0x51D8, # G+10589  U+51D8  uni51D8,  CJK UNIFIED IDEOGRAPH-51D8
        0x51D9, # G+10590  U+51D9  uni51D9,  CJK UNIFIED IDEOGRAPH-51D9
        0x51DA, # G+10591  U+51DA  uni51DA,  CJK UNIFIED IDEOGRAPH-51DA
        0x51DC, # G+10592  U+51DC  uni51DC,  CJK UNIFIED IDEOGRAPH-51DC
        0x51DE, # G+10593  U+51DE  uni51DE,  CJK UNIFIED IDEOGRAPH-51DE
        0x51DF, # G+10594  U+51DF  uni51DF,  CJK UNIFIED IDEOGRAPH-51DF
        0x51E2, # G+10595  U+51E2  uni51E2,  CJK UNIFIED IDEOGRAPH-51E2
        0x51E3, # G+10596  U+51E3  uni51E3,  CJK UNIFIED IDEOGRAPH-51E3
        0x51E5, # G+10597  U+51E5  uni51E5,  CJK UNIFIED IDEOGRAPH-51E5
        0x51E6, # G+10598  U+51E6  uni51E6,  CJK UNIFIED IDEOGRAPH-51E6
        0x51E7, # G+10599  U+51E7  uni51E7,  CJK UNIFIED IDEOGRAPH-51E7
        0x51E8, # G+10600  U+51E8  uni51E8,  CJK UNIFIED IDEOGRAPH-51E8
        0x51E9, # G+10601  U+51E9  uni51E9,  CJK UNIFIED IDEOGRAPH-51E9
        0x51EA, # G+10602  U+51EA  uni51EA,  CJK UNIFIED IDEOGRAPH-51EA
        0x51EC, # G+10603  U+51EC  uni51EC,  CJK UNIFIED IDEOGRAPH-51EC
        0x51EE, # G+10604  U+51EE  uni51EE,  CJK UNIFIED IDEOGRAPH-51EE
        0x51F2, # G+10605  U+51F2  uni51F2,  CJK UNIFIED IDEOGRAPH-51F2
        0x51F4, # G+10606  U+51F4  uni51F4,  CJK UNIFIED IDEOGRAPH-51F4
        0x51F7, # G+10607  U+51F7  uni51F7,  CJK UNIFIED IDEOGRAPH-51F7
        0x51FE, # G+10608  U+51FE  uni51FE,  CJK UNIFIED IDEOGRAPH-51FE
        0x5204, # G+10609  U+5204  uni5204,  CJK UNIFIED IDEOGRAPH-5204
        0x5205, # G+10610  U+5205  uni5205,  CJK UNIFIED IDEOGRAPH-5205
        0x5209, # G+10611  U+5209  uni5209,  CJK UNIFIED IDEOGRAPH-5209
        0x520B, # G+10612  U+520B  uni520B,  CJK UNIFIED IDEOGRAPH-520B
        0x520C, # G+10613  U+520C  uni520C,  CJK UNIFIED IDEOGRAPH-520C
        0x520F, # G+10614  U+520F  uni520F,  CJK UNIFIED IDEOGRAPH-520F
        0x5210, # G+10615  U+5210  uni5210,  CJK UNIFIED IDEOGRAPH-5210
        0x5213, # G+10616  U+5213  uni5213,  CJK UNIFIED IDEOGRAPH-5213
        0x5214, # G+10617  U+5214  uni5214,  CJK UNIFIED IDEOGRAPH-5214
        0x5215, # G+10618  U+5215  uni5215,  CJK UNIFIED IDEOGRAPH-5215
        0x521C, # G+10619  U+521C  uni521C,  CJK UNIFIED IDEOGRAPH-521C
        0x521E, # G+10620  U+521E  uni521E,  CJK UNIFIED IDEOGRAPH-521E
        0x521F, # G+10621  U+521F  uni521F,  CJK UNIFIED IDEOGRAPH-521F
        0x5221, # G+10622  U+5221  uni5221,  CJK UNIFIED IDEOGRAPH-5221
        0x5222, # G+10623  U+5222  uni5222,  CJK UNIFIED IDEOGRAPH-5222
        0x5223, # G+10624  U+5223  uni5223,  CJK UNIFIED IDEOGRAPH-5223
        0x5225, # G+10625  U+5225  uni5225,  CJK UNIFIED IDEOGRAPH-5225
        0x5226, # G+10626  U+5226  uni5226,  CJK UNIFIED IDEOGRAPH-5226
        0x5227, # G+10627  U+5227  uni5227,  CJK UNIFIED IDEOGRAPH-5227
        0x522A, # G+10628  U+522A  uni522A,  CJK UNIFIED IDEOGRAPH-522A
        0x522C, # G+10629  U+522C  uni522C,  CJK UNIFIED IDEOGRAPH-522C
        0x522F, # G+10630  U+522F  uni522F,  CJK UNIFIED IDEOGRAPH-522F
        0x5231, # G+10631  U+5231  uni5231,  CJK UNIFIED IDEOGRAPH-5231
        0x5232, # G+10632  U+5232  uni5232,  CJK UNIFIED IDEOGRAPH-5232
        0x5234, # G+10633  U+5234  uni5234,  CJK UNIFIED IDEOGRAPH-5234
        0x5235, # G+10634  U+5235  uni5235,  CJK UNIFIED IDEOGRAPH-5235
        0x523C, # G+10635  U+523C  uni523C,  CJK UNIFIED IDEOGRAPH-523C
        0x523E, # G+10636  U+523E  uni523E,  CJK UNIFIED IDEOGRAPH-523E
        0x5245, # G+10637  U+5245  uni5245,  CJK UNIFIED IDEOGRAPH-5245
        0x5246, # G+10638  U+5246  uni5246,  CJK UNIFIED IDEOGRAPH-5246
        0x5248, # G+10639  U+5248  uni5248,  CJK UNIFIED IDEOGRAPH-5248
        0x5249, # G+10640  U+5249  uni5249,  CJK UNIFIED IDEOGRAPH-5249
        0x524E, # G+10641  U+524E  uni524E,  CJK UNIFIED IDEOGRAPH-524E
        0x524F, # G+10642  U+524F  uni524F,  CJK UNIFIED IDEOGRAPH-524F
        0x5252, # G+10643  U+5252  uni5252,  CJK UNIFIED IDEOGRAPH-5252
        0x5253, # G+10644  U+5253  uni5253,  CJK UNIFIED IDEOGRAPH-5253
        0x5255, # G+10645  U+5255  uni5255,  CJK UNIFIED IDEOGRAPH-5255
        0x5257, # G+10646  U+5257  uni5257,  CJK UNIFIED IDEOGRAPH-5257
        0x5258, # G+10647  U+5258  uni5258,  CJK UNIFIED IDEOGRAPH-5258
        0x5259, # G+10648  U+5259  uni5259,  CJK UNIFIED IDEOGRAPH-5259
        0x525A, # G+10649  U+525A  uni525A,  CJK UNIFIED IDEOGRAPH-525A
        0x525D, # G+10650  U+525D  uni525D,  CJK UNIFIED IDEOGRAPH-525D
        0x525F, # G+10651  U+525F  uni525F,  CJK UNIFIED IDEOGRAPH-525F
        0x5260, # G+10652  U+5260  uni5260,  CJK UNIFIED IDEOGRAPH-5260
        0x5262, # G+10653  U+5262  uni5262,  CJK UNIFIED IDEOGRAPH-5262
        0x5263, # G+10654  U+5263  uni5263,  CJK UNIFIED IDEOGRAPH-5263
        0x5264, # G+10655  U+5264  uni5264,  CJK UNIFIED IDEOGRAPH-5264
        0x5266, # G+10656  U+5266  uni5266,  CJK UNIFIED IDEOGRAPH-5266
        0x5268, # G+10657  U+5268  uni5268,  CJK UNIFIED IDEOGRAPH-5268
        0x526B, # G+10658  U+526B  uni526B,  CJK UNIFIED IDEOGRAPH-526B
        0x526C, # G+10659  U+526C  uni526C,  CJK UNIFIED IDEOGRAPH-526C
        0x526D, # G+10660  U+526D  uni526D,  CJK UNIFIED IDEOGRAPH-526D
        0x5270, # G+10661  U+5270  uni5270,  CJK UNIFIED IDEOGRAPH-5270
        0x5271, # G+10662  U+5271  uni5271,  CJK UNIFIED IDEOGRAPH-5271
        0x5273, # G+10663  U+5273  uni5273,  CJK UNIFIED IDEOGRAPH-5273
        0x5276, # G+10664  U+5276  uni5276,  CJK UNIFIED IDEOGRAPH-5276
        0x5277, # G+10665  U+5277  uni5277,  CJK UNIFIED IDEOGRAPH-5277
        0x5278, # G+10666  U+5278  uni5278,  CJK UNIFIED IDEOGRAPH-5278
        0x5279, # G+10667  U+5279  uni5279,  CJK UNIFIED IDEOGRAPH-5279
        0x527A, # G+10668  U+527A  uni527A,  CJK UNIFIED IDEOGRAPH-527A
        0x527B, # G+10669  U+527B  uni527B,  CJK UNIFIED IDEOGRAPH-527B
        0x527C, # G+10670  U+527C  uni527C,  CJK UNIFIED IDEOGRAPH-527C
        0x527E, # G+10671  U+527E  uni527E,  CJK UNIFIED IDEOGRAPH-527E
        0x5280, # G+10672  U+5280  uni5280,  CJK UNIFIED IDEOGRAPH-5280
        0x5284, # G+10673  U+5284  uni5284,  CJK UNIFIED IDEOGRAPH-5284
        0x5285, # G+10674  U+5285  uni5285,  CJK UNIFIED IDEOGRAPH-5285
        0x5286, # G+10675  U+5286  uni5286,  CJK UNIFIED IDEOGRAPH-5286
        0x528B, # G+10676  U+528B  uni528B,  CJK UNIFIED IDEOGRAPH-528B
        0x528E, # G+10677  U+528E  uni528E,  CJK UNIFIED IDEOGRAPH-528E
        0x528F, # G+10678  U+528F  uni528F,  CJK UNIFIED IDEOGRAPH-528F
        0x5292, # G+10679  U+5292  uni5292,  CJK UNIFIED IDEOGRAPH-5292
        0x5294, # G+10680  U+5294  uni5294,  CJK UNIFIED IDEOGRAPH-5294
        0x5295, # G+10681  U+5295  uni5295,  CJK UNIFIED IDEOGRAPH-5295
        0x5296, # G+10682  U+5296  uni5296,  CJK UNIFIED IDEOGRAPH-5296
        0x5297, # G+10683  U+5297  uni5297,  CJK UNIFIED IDEOGRAPH-5297
        0x5298, # G+10684  U+5298  uni5298,  CJK UNIFIED IDEOGRAPH-5298
        0x5299, # G+10685  U+5299  uni5299,  CJK UNIFIED IDEOGRAPH-5299
        0x529A, # G+10686  U+529A  uni529A,  CJK UNIFIED IDEOGRAPH-529A
        0x529C, # G+10687  U+529C  uni529C,  CJK UNIFIED IDEOGRAPH-529C
        0x52A4, # G+10688  U+52A4  uni52A4,  CJK UNIFIED IDEOGRAPH-52A4
        0x52A5, # G+10689  U+52A5  uni52A5,  CJK UNIFIED IDEOGRAPH-52A5
        0x52A6, # G+10690  U+52A6  uni52A6,  CJK UNIFIED IDEOGRAPH-52A6
        0x52A7, # G+10691  U+52A7  uni52A7,  CJK UNIFIED IDEOGRAPH-52A7
        0x52AE, # G+10692  U+52AE  uni52AE,  CJK UNIFIED IDEOGRAPH-52AE
        0x52AF, # G+10693  U+52AF  uni52AF,  CJK UNIFIED IDEOGRAPH-52AF
        0x52B0, # G+10694  U+52B0  uni52B0,  CJK UNIFIED IDEOGRAPH-52B0
        0x52B4, # G+10695  U+52B4  uni52B4,  CJK UNIFIED IDEOGRAPH-52B4
        0x52B5, # G+10696  U+52B5  uni52B5,  CJK UNIFIED IDEOGRAPH-52B5
        0x52B6, # G+10697  U+52B6  uni52B6,  CJK UNIFIED IDEOGRAPH-52B6
        0x52B7, # G+10698  U+52B7  uni52B7,  CJK UNIFIED IDEOGRAPH-52B7
        0x52B8, # G+10699  U+52B8  uni52B8,  CJK UNIFIED IDEOGRAPH-52B8
        0x52B9, # G+10700  U+52B9  uni52B9,  CJK UNIFIED IDEOGRAPH-52B9
        0x52BA, # G+10701  U+52BA  uni52BA,  CJK UNIFIED IDEOGRAPH-52BA
        0x52BB, # G+10702  U+52BB  uni52BB,  CJK UNIFIED IDEOGRAPH-52BB
        0x52BC, # G+10703  U+52BC  uni52BC,  CJK UNIFIED IDEOGRAPH-52BC
        0x52BD, # G+10704  U+52BD  uni52BD,  CJK UNIFIED IDEOGRAPH-52BD
        0x52C0, # G+10705  U+52C0  uni52C0,  CJK UNIFIED IDEOGRAPH-52C0
        0x52C2, # G+10706  U+52C2  uni52C2,  CJK UNIFIED IDEOGRAPH-52C2
        0x52C4, # G+10707  U+52C4  uni52C4,  CJK UNIFIED IDEOGRAPH-52C4
        0x52C5, # G+10708  U+52C5  uni52C5,  CJK UNIFIED IDEOGRAPH-52C5
        0x52C6, # G+10709  U+52C6  uni52C6,  CJK UNIFIED IDEOGRAPH-52C6
        0x52C8, # G+10710  U+52C8  uni52C8,  CJK UNIFIED IDEOGRAPH-52C8
        0x52CA, # G+10711  U+52CA  uni52CA,  CJK UNIFIED IDEOGRAPH-52CA
        0x52CC, # G+10712  U+52CC  uni52CC,  CJK UNIFIED IDEOGRAPH-52CC
        0x52CD, # G+10713  U+52CD  uni52CD,  CJK UNIFIED IDEOGRAPH-52CD
        0x52CE, # G+10714  U+52CE  uni52CE,  CJK UNIFIED IDEOGRAPH-52CE
        0x52CF, # G+10715  U+52CF  uni52CF,  CJK UNIFIED IDEOGRAPH-52CF
        0x52D1, # G+10716  U+52D1  uni52D1,  CJK UNIFIED IDEOGRAPH-52D1
        0x52D3, # G+10717  U+52D3  uni52D3,  CJK UNIFIED IDEOGRAPH-52D3
        0x52D4, # G+10718  U+52D4  uni52D4,  CJK UNIFIED IDEOGRAPH-52D4
        0x52D7, # G+10719  U+52D7  uni52D7,  CJK UNIFIED IDEOGRAPH-52D7
        0x52DA, # G+10720  U+52DA  uni52DA,  CJK UNIFIED IDEOGRAPH-52DA
        0x52DC, # G+10721  U+52DC  uni52DC,  CJK UNIFIED IDEOGRAPH-52DC
        0x52E0, # G+10722  U+52E0  uni52E0,  CJK UNIFIED IDEOGRAPH-52E0
        0x52E1, # G+10723  U+52E1  uni52E1,  CJK UNIFIED IDEOGRAPH-52E1
        0x52E3, # G+10724  U+52E3  uni52E3,  CJK UNIFIED IDEOGRAPH-52E3
        0x52E5, # G+10725  U+52E5  uni52E5,  CJK UNIFIED IDEOGRAPH-52E5
        0x52E6, # G+10726  U+52E6  uni52E6,  CJK UNIFIED IDEOGRAPH-52E6
        0x52E7, # G+10727  U+52E7  uni52E7,  CJK UNIFIED IDEOGRAPH-52E7
        0x52E8, # G+10728  U+52E8  uni52E8,  CJK UNIFIED IDEOGRAPH-52E8
        0x52E9, # G+10729  U+52E9  uni52E9,  CJK UNIFIED IDEOGRAPH-52E9
        0x52EA, # G+10730  U+52EA  uni52EA,  CJK UNIFIED IDEOGRAPH-52EA
        0x52EB, # G+10731  U+52EB  uni52EB,  CJK UNIFIED IDEOGRAPH-52EB
        0x52EC, # G+10732  U+52EC  uni52EC,  CJK UNIFIED IDEOGRAPH-52EC
        0x52ED, # G+10733  U+52ED  uni52ED,  CJK UNIFIED IDEOGRAPH-52ED
        0x52EE, # G+10734  U+52EE  uni52EE,  CJK UNIFIED IDEOGRAPH-52EE
        0x52EF, # G+10735  U+52EF  uni52EF,  CJK UNIFIED IDEOGRAPH-52EF
        0x52F2, # G+10736  U+52F2  uni52F2,  CJK UNIFIED IDEOGRAPH-52F2
        0x52F3, # G+10737  U+52F3  uni52F3,  CJK UNIFIED IDEOGRAPH-52F3
        0x52F4, # G+10738  U+52F4  uni52F4,  CJK UNIFIED IDEOGRAPH-52F4
        0x52F6, # G+10739  U+52F6  uni52F6,  CJK UNIFIED IDEOGRAPH-52F6
        0x52F7, # G+10740  U+52F7  uni52F7,  CJK UNIFIED IDEOGRAPH-52F7
        0x52FB, # G+10741  U+52FB  uni52FB,  CJK UNIFIED IDEOGRAPH-52FB
        0x52FC, # G+10742  U+52FC  uni52FC,  CJK UNIFIED IDEOGRAPH-52FC
        0x52FD, # G+10743  U+52FD  uni52FD,  CJK UNIFIED IDEOGRAPH-52FD
        0x5301, # G+10744  U+5301  uni5301,  CJK UNIFIED IDEOGRAPH-5301
        0x5302, # G+10745  U+5302  uni5302,  CJK UNIFIED IDEOGRAPH-5302
        0x5303, # G+10746  U+5303  uni5303,  CJK UNIFIED IDEOGRAPH-5303
        0x5304, # G+10747  U+5304  uni5304,  CJK UNIFIED IDEOGRAPH-5304
        0x5307, # G+10748  U+5307  uni5307,  CJK UNIFIED IDEOGRAPH-5307
        0x5309, # G+10749  U+5309  uni5309,  CJK UNIFIED IDEOGRAPH-5309
        0x530A, # G+10750  U+530A  uni530A,  CJK UNIFIED IDEOGRAPH-530A
        0x530B, # G+10751  U+530B  uni530B,  CJK UNIFIED IDEOGRAPH-530B
        0x530C, # G+10752  U+530C  uni530C,  CJK UNIFIED IDEOGRAPH-530C
        0x530E, # G+10753  U+530E  uni530E,  CJK UNIFIED IDEOGRAPH-530E
        0x5311, # G+10754  U+5311  uni5311,  CJK UNIFIED IDEOGRAPH-5311
        0x5312, # G+10755  U+5312  uni5312,  CJK UNIFIED IDEOGRAPH-5312
        0x5313, # G+10756  U+5313  uni5313,  CJK UNIFIED IDEOGRAPH-5313
        0x5314, # G+10757  U+5314  uni5314,  CJK UNIFIED IDEOGRAPH-5314
        0x5318, # G+10758  U+5318  uni5318,  CJK UNIFIED IDEOGRAPH-5318
        0x531B, # G+10759  U+531B  uni531B,  CJK UNIFIED IDEOGRAPH-531B
        0x531C, # G+10760  U+531C  uni531C,  CJK UNIFIED IDEOGRAPH-531C
        0x531E, # G+10761  U+531E  uni531E,  CJK UNIFIED IDEOGRAPH-531E
        0x531F, # G+10762  U+531F  uni531F,  CJK UNIFIED IDEOGRAPH-531F
        0x5322, # G+10763  U+5322  uni5322,  CJK UNIFIED IDEOGRAPH-5322
        0x5324, # G+10764  U+5324  uni5324,  CJK UNIFIED IDEOGRAPH-5324
        0x5325, # G+10765  U+5325  uni5325,  CJK UNIFIED IDEOGRAPH-5325
        0x5327, # G+10766  U+5327  uni5327,  CJK UNIFIED IDEOGRAPH-5327
        0x5328, # G+10767  U+5328  uni5328,  CJK UNIFIED IDEOGRAPH-5328
        0x5329, # G+10768  U+5329  uni5329,  CJK UNIFIED IDEOGRAPH-5329
        0x532B, # G+10769  U+532B  uni532B,  CJK UNIFIED IDEOGRAPH-532B
        0x532C, # G+10770  U+532C  uni532C,  CJK UNIFIED IDEOGRAPH-532C
        0x5330, # G+10771  U+5330  uni5330,  CJK UNIFIED IDEOGRAPH-5330
        0x5332, # G+10772  U+5332  uni5332,  CJK UNIFIED IDEOGRAPH-5332
        0x5333, # G+10773  U+5333  uni5333,  CJK UNIFIED IDEOGRAPH-5333
        0x5334, # G+10774  U+5334  uni5334,  CJK UNIFIED IDEOGRAPH-5334
        0x5335, # G+10775  U+5335  uni5335,  CJK UNIFIED IDEOGRAPH-5335
        0x5336, # G+10776  U+5336  uni5336,  CJK UNIFIED IDEOGRAPH-5336
        0x5337, # G+10777  U+5337  uni5337,  CJK UNIFIED IDEOGRAPH-5337
        0x2F16, # G+10778  U+2F16  uni2F16,  KANGXI RADICAL HIDING ENCLOSURE
        0x533C, # G+10779  U+533C  uni533C,  CJK UNIFIED IDEOGRAPH-533C
        0x533D, # G+10780  U+533D  uni533D,  CJK UNIFIED IDEOGRAPH-533D
        0x5342, # G+10781  U+5342  uni5342,  CJK UNIFIED IDEOGRAPH-5342
        0x5344, # G+10782  U+5344  uni5344,  CJK UNIFIED IDEOGRAPH-5344
        0x5346, # G+10783  U+5346  uni5346,  CJK UNIFIED IDEOGRAPH-5346
        0x534B, # G+10784  U+534B  uni534B,  CJK UNIFIED IDEOGRAPH-534B
        0x534C, # G+10785  U+534C  uni534C,  CJK UNIFIED IDEOGRAPH-534C
        0x534D, # G+10786  U+534D  uni534D,  CJK UNIFIED IDEOGRAPH-534D
        0x5350, # G+10787  U+5350  uni5350,  CJK UNIFIED IDEOGRAPH-5350
        0x5358, # G+10788  U+5358  uni5358,  CJK UNIFIED IDEOGRAPH-5358
        0x5359, # G+10789  U+5359  uni5359,  CJK UNIFIED IDEOGRAPH-5359
        0x535B, # G+10790  U+535B  uni535B,  CJK UNIFIED IDEOGRAPH-535B
        0x535D, # G+10791  U+535D  uni535D,  CJK UNIFIED IDEOGRAPH-535D
        0x5365, # G+10792  U+5365  uni5365,  CJK UNIFIED IDEOGRAPH-5365
        0x5368, # G+10793  U+5368  uni5368,  CJK UNIFIED IDEOGRAPH-5368
        0x536A, # G+10794  U+536A  uni536A,  CJK UNIFIED IDEOGRAPH-536A
        0x536C, # G+10795  U+536C  uni536C,  CJK UNIFIED IDEOGRAPH-536C
        0x536D, # G+10796  U+536D  uni536D,  CJK UNIFIED IDEOGRAPH-536D
        0x5372, # G+10797  U+5372  uni5372,  CJK UNIFIED IDEOGRAPH-5372
        0x5376, # G+10798  U+5376  uni5376,  CJK UNIFIED IDEOGRAPH-5376
        0x5379, # G+10799  U+5379  uni5379,  CJK UNIFIED IDEOGRAPH-5379
        0x537B, # G+10800  U+537B  uni537B,  CJK UNIFIED IDEOGRAPH-537B
        0x537C, # G+10801  U+537C  uni537C,  CJK UNIFIED IDEOGRAPH-537C
        0x537D, # G+10802  U+537D  uni537D,  CJK UNIFIED IDEOGRAPH-537D
        0x537E, # G+10803  U+537E  uni537E,  CJK UNIFIED IDEOGRAPH-537E
        0x5380, # G+10804  U+5380  uni5380,  CJK UNIFIED IDEOGRAPH-5380
        0x5381, # G+10805  U+5381  uni5381,  CJK UNIFIED IDEOGRAPH-5381
        0x5383, # G+10806  U+5383  uni5383,  CJK UNIFIED IDEOGRAPH-5383
        0x5387, # G+10807  U+5387  uni5387,  CJK UNIFIED IDEOGRAPH-5387
        0x5388, # G+10808  U+5388  uni5388,  CJK UNIFIED IDEOGRAPH-5388
        0x538A, # G+10809  U+538A  uni538A,  CJK UNIFIED IDEOGRAPH-538A
        0x538E, # G+10810  U+538E  uni538E,  CJK UNIFIED IDEOGRAPH-538E
        0x538F, # G+10811  U+538F  uni538F,  CJK UNIFIED IDEOGRAPH-538F
        0x5390, # G+10812  U+5390  uni5390,  CJK UNIFIED IDEOGRAPH-5390
        0x5391, # G+10813  U+5391  uni5391,  CJK UNIFIED IDEOGRAPH-5391
        0x5392, # G+10814  U+5392  uni5392,  CJK UNIFIED IDEOGRAPH-5392
        0x5393, # G+10815  U+5393  uni5393,  CJK UNIFIED IDEOGRAPH-5393
        0x5394, # G+10816  U+5394  uni5394,  CJK UNIFIED IDEOGRAPH-5394
        0x5396, # G+10817  U+5396  uni5396,  CJK UNIFIED IDEOGRAPH-5396
        0x5397, # G+10818  U+5397  uni5397,  CJK UNIFIED IDEOGRAPH-5397
        0x539B, # G+10819  U+539B  uni539B,  CJK UNIFIED IDEOGRAPH-539B
        0x539C, # G+10820  U+539C  uni539C,  CJK UNIFIED IDEOGRAPH-539C
        0x539E, # G+10821  U+539E  uni539E,  CJK UNIFIED IDEOGRAPH-539E
        0x53A1, # G+10822  U+53A1  uni53A1,  CJK UNIFIED IDEOGRAPH-53A1
        0x53A4, # G+10823  U+53A4  uni53A4,  CJK UNIFIED IDEOGRAPH-53A4
        0x53A7, # G+10824  U+53A7  uni53A7,  CJK UNIFIED IDEOGRAPH-53A7
        0x53AA, # G+10825  U+53AA  uni53AA,  CJK UNIFIED IDEOGRAPH-53AA
        0x53AB, # G+10826  U+53AB  uni53AB,  CJK UNIFIED IDEOGRAPH-53AB
        0x53AC, # G+10827  U+53AC  uni53AC,  CJK UNIFIED IDEOGRAPH-53AC
        0x53AF, # G+10828  U+53AF  uni53AF,  CJK UNIFIED IDEOGRAPH-53AF
        0x53B0, # G+10829  U+53B0  uni53B0,  CJK UNIFIED IDEOGRAPH-53B0
        0x53B1, # G+10830  U+53B1  uni53B1,  CJK UNIFIED IDEOGRAPH-53B1
        0x53B3, # G+10831  U+53B3  uni53B3,  CJK UNIFIED IDEOGRAPH-53B3
        0x53B5, # G+10832  U+53B5  uni53B5,  CJK UNIFIED IDEOGRAPH-53B5
        0x53B7, # G+10833  U+53B7  uni53B7,  CJK UNIFIED IDEOGRAPH-53B7
        0x53B8, # G+10834  U+53B8  uni53B8,  CJK UNIFIED IDEOGRAPH-53B8
        0x53B9, # G+10835  U+53B9  uni53B9,  CJK UNIFIED IDEOGRAPH-53B9
        0x53BA, # G+10836  U+53BA  uni53BA,  CJK UNIFIED IDEOGRAPH-53BA
        0x53BC, # G+10837  U+53BC  uni53BC,  CJK UNIFIED IDEOGRAPH-53BC
        0x53BD, # G+10838  U+53BD  uni53BD,  CJK UNIFIED IDEOGRAPH-53BD
        0x53BE, # G+10839  U+53BE  uni53BE,  CJK UNIFIED IDEOGRAPH-53BE
        0x53C0, # G+10840  U+53C0  uni53C0,  CJK UNIFIED IDEOGRAPH-53C0
        0x53C4, # G+10841  U+53C4  uni53C4,  CJK UNIFIED IDEOGRAPH-53C4
        0x53C5, # G+10842  U+53C5  uni53C5,  CJK UNIFIED IDEOGRAPH-53C5
        0x53C6, # G+10843  U+53C6  uni53C6,  CJK UNIFIED IDEOGRAPH-53C6
        0x53C7, # G+10844  U+53C7  uni53C7,  CJK UNIFIED IDEOGRAPH-53C7
        0x53CE, # G+10845  U+53CE  uni53CE,  CJK UNIFIED IDEOGRAPH-53CE
        0x53CF, # G+10846  U+53CF  uni53CF,  CJK UNIFIED IDEOGRAPH-53CF
        0x53D0, # G+10847  U+53D0  uni53D0,  CJK UNIFIED IDEOGRAPH-53D0
        0x53D2, # G+10848  U+53D2  uni53D2,  CJK UNIFIED IDEOGRAPH-53D2
        0x53D3, # G+10849  U+53D3  uni53D3,  CJK UNIFIED IDEOGRAPH-53D3
        0x53D5, # G+10850  U+53D5  uni53D5,  CJK UNIFIED IDEOGRAPH-53D5
        0x53DA, # G+10851  U+53DA  uni53DA,  CJK UNIFIED IDEOGRAPH-53DA
        0x53DC, # G+10852  U+53DC  uni53DC,  CJK UNIFIED IDEOGRAPH-53DC
        0x53DD, # G+10853  U+53DD  uni53DD,  CJK UNIFIED IDEOGRAPH-53DD
        0x53DE, # G+10854  U+53DE  uni53DE,  CJK UNIFIED IDEOGRAPH-53DE
        0x53E1, # G+10855  U+53E1  uni53E1,  CJK UNIFIED IDEOGRAPH-53E1
        0x53E7, # G+10856  U+53E7  uni53E7,  CJK UNIFIED IDEOGRAPH-53E7
        0x53F4, # G+10857  U+53F4  uni53F4,  CJK UNIFIED IDEOGRAPH-53F4
        0x53FA, # G+10858  U+53FA  uni53FA,  CJK UNIFIED IDEOGRAPH-53FA
        0x53FE, # G+10859  U+53FE  uni53FE,  CJK UNIFIED IDEOGRAPH-53FE
        0x53FF, # G+10860  U+53FF  uni53FF,  CJK UNIFIED IDEOGRAPH-53FF
        0x5400, # G+10861  U+5400  uni5400,  CJK UNIFIED IDEOGRAPH-5400
        0x5402, # G+10862  U+5402  uni5402,  CJK UNIFIED IDEOGRAPH-5402
        0x5405, # G+10863  U+5405  uni5405,  CJK UNIFIED IDEOGRAPH-5405
        0x5407, # G+10864  U+5407  uni5407,  CJK UNIFIED IDEOGRAPH-5407
        0x540B, # G+10865  U+540B  uni540B,  CJK UNIFIED IDEOGRAPH-540B
        0x5414, # G+10866  U+5414  uni5414,  CJK UNIFIED IDEOGRAPH-5414
        0x5418, # G+10867  U+5418  uni5418,  CJK UNIFIED IDEOGRAPH-5418
        0x5419, # G+10868  U+5419  uni5419,  CJK UNIFIED IDEOGRAPH-5419
        0x541A, # G+10869  U+541A  uni541A,  CJK UNIFIED IDEOGRAPH-541A
        0x541C, # G+10870  U+541C  uni541C,  CJK UNIFIED IDEOGRAPH-541C
        0x5422, # G+10871  U+5422  uni5422,  CJK UNIFIED IDEOGRAPH-5422
        0x5424, # G+10872  U+5424  uni5424,  CJK UNIFIED IDEOGRAPH-5424
        0x5425, # G+10873  U+5425  uni5425,  CJK UNIFIED IDEOGRAPH-5425
        0x542A, # G+10874  U+542A  uni542A,  CJK UNIFIED IDEOGRAPH-542A
        0x5430, # G+10875  U+5430  uni5430,  CJK UNIFIED IDEOGRAPH-5430
        0x5433, # G+10876  U+5433  uni5433,  CJK UNIFIED IDEOGRAPH-5433
        0x5436, # G+10877  U+5436  uni5436,  CJK UNIFIED IDEOGRAPH-5436
        0x5437, # G+10878  U+5437  uni5437,  CJK UNIFIED IDEOGRAPH-5437
        0x543A, # G+10879  U+543A  uni543A,  CJK UNIFIED IDEOGRAPH-543A
        0x543D, # G+10880  U+543D  uni543D,  CJK UNIFIED IDEOGRAPH-543D
        0x543F, # G+10881  U+543F  uni543F,  CJK UNIFIED IDEOGRAPH-543F
        0x5441, # G+10882  U+5441  uni5441,  CJK UNIFIED IDEOGRAPH-5441
        0x5442, # G+10883  U+5442  uni5442,  CJK UNIFIED IDEOGRAPH-5442
        0x5444, # G+10884  U+5444  uni5444,  CJK UNIFIED IDEOGRAPH-5444
        0x5445, # G+10885  U+5445  uni5445,  CJK UNIFIED IDEOGRAPH-5445
        0x5447, # G+10886  U+5447  uni5447,  CJK UNIFIED IDEOGRAPH-5447
        0x5449, # G+10887  U+5449  uni5449,  CJK UNIFIED IDEOGRAPH-5449
        0x544C, # G+10888  U+544C  uni544C,  CJK UNIFIED IDEOGRAPH-544C
        0x544D, # G+10889  U+544D  uni544D,  CJK UNIFIED IDEOGRAPH-544D
        0x544E, # G+10890  U+544E  uni544E,  CJK UNIFIED IDEOGRAPH-544E
        0x544F, # G+10891  U+544F  uni544F,  CJK UNIFIED IDEOGRAPH-544F
        0x5451, # G+10892  U+5451  uni5451,  CJK UNIFIED IDEOGRAPH-5451
        0x545A, # G+10893  U+545A  uni545A,  CJK UNIFIED IDEOGRAPH-545A
        0x545D, # G+10894  U+545D  uni545D,  CJK UNIFIED IDEOGRAPH-545D
        0x545E, # G+10895  U+545E  uni545E,  CJK UNIFIED IDEOGRAPH-545E
        0x545F, # G+10896  U+545F  uni545F,  CJK UNIFIED IDEOGRAPH-545F
        0x5460, # G+10897  U+5460  uni5460,  CJK UNIFIED IDEOGRAPH-5460
        0x5461, # G+10898  U+5461  uni5461,  CJK UNIFIED IDEOGRAPH-5461
        0x5463, # G+10899  U+5463  uni5463,  CJK UNIFIED IDEOGRAPH-5463
        0x5465, # G+10900  U+5465  uni5465,  CJK UNIFIED IDEOGRAPH-5465
        0x5467, # G+10901  U+5467  uni5467,  CJK UNIFIED IDEOGRAPH-5467
        0x5469, # G+10902  U+5469  uni5469,  CJK UNIFIED IDEOGRAPH-5469
        0x546A, # G+10903  U+546A  uni546A,  CJK UNIFIED IDEOGRAPH-546A
        0x546B, # G+10904  U+546B  uni546B,  CJK UNIFIED IDEOGRAPH-546B
        0x546C, # G+10905  U+546C  uni546C,  CJK UNIFIED IDEOGRAPH-546C
        0x546D, # G+10906  U+546D  uni546D,  CJK UNIFIED IDEOGRAPH-546D
        0x546E, # G+10907  U+546E  uni546E,  CJK UNIFIED IDEOGRAPH-546E
        0x546F, # G+10908  U+546F  uni546F,  CJK UNIFIED IDEOGRAPH-546F
        0x5470, # G+10909  U+5470  uni5470,  CJK UNIFIED IDEOGRAPH-5470
        0x5474, # G+10910  U+5474  uni5474,  CJK UNIFIED IDEOGRAPH-5474
        0x5479, # G+10911  U+5479  uni5479,  CJK UNIFIED IDEOGRAPH-5479
        0x547A, # G+10912  U+547A  uni547A,  CJK UNIFIED IDEOGRAPH-547A
        0x547E, # G+10913  U+547E  uni547E,  CJK UNIFIED IDEOGRAPH-547E
        0x547F, # G+10914  U+547F  uni547F,  CJK UNIFIED IDEOGRAPH-547F
        0x5481, # G+10915  U+5481  uni5481,  CJK UNIFIED IDEOGRAPH-5481
        0x5483, # G+10916  U+5483  uni5483,  CJK UNIFIED IDEOGRAPH-5483
        0x5485, # G+10917  U+5485  uni5485,  CJK UNIFIED IDEOGRAPH-5485
        0x5487, # G+10918  U+5487  uni5487,  CJK UNIFIED IDEOGRAPH-5487
        0x5488, # G+10919  U+5488  uni5488,  CJK UNIFIED IDEOGRAPH-5488
        0x5489, # G+10920  U+5489  uni5489,  CJK UNIFIED IDEOGRAPH-5489
        0x548A, # G+10921  U+548A  uni548A,  CJK UNIFIED IDEOGRAPH-548A
        0x548D, # G+10922  U+548D  uni548D,  CJK UNIFIED IDEOGRAPH-548D
        0x5491, # G+10923  U+5491  uni5491,  CJK UNIFIED IDEOGRAPH-5491
        0x5493, # G+10924  U+5493  uni5493,  CJK UNIFIED IDEOGRAPH-5493
        0x5497, # G+10925  U+5497  uni5497,  CJK UNIFIED IDEOGRAPH-5497
        0x5498, # G+10926  U+5498  uni5498,  CJK UNIFIED IDEOGRAPH-5498
        0x549C, # G+10927  U+549C  uni549C,  CJK UNIFIED IDEOGRAPH-549C
        0x549E, # G+10928  U+549E  uni549E,  CJK UNIFIED IDEOGRAPH-549E
        0x549F, # G+10929  U+549F  uni549F,  CJK UNIFIED IDEOGRAPH-549F
        0x54A0, # G+10930  U+54A0  uni54A0,  CJK UNIFIED IDEOGRAPH-54A0
        0x54A1, # G+10931  U+54A1  uni54A1,  CJK UNIFIED IDEOGRAPH-54A1
        0x54A2, # G+10932  U+54A2  uni54A2,  CJK UNIFIED IDEOGRAPH-54A2
        0x54A5, # G+10933  U+54A5  uni54A5,  CJK UNIFIED IDEOGRAPH-54A5
        0x54AE, # G+10934  U+54AE  uni54AE,  CJK UNIFIED IDEOGRAPH-54AE
        0x54B0, # G+10935  U+54B0  uni54B0,  CJK UNIFIED IDEOGRAPH-54B0
        0x54B2, # G+10936  U+54B2  uni54B2,  CJK UNIFIED IDEOGRAPH-54B2
        0x54B5, # G+10937  U+54B5  uni54B5,  CJK UNIFIED IDEOGRAPH-54B5
        0x54B6, # G+10938  U+54B6  uni54B6,  CJK UNIFIED IDEOGRAPH-54B6
        0x54B7, # G+10939  U+54B7  uni54B7,  CJK UNIFIED IDEOGRAPH-54B7
        0x54B9, # G+10940  U+54B9  uni54B9,  CJK UNIFIED IDEOGRAPH-54B9
        0x54BA, # G+10941  U+54BA  uni54BA,  CJK UNIFIED IDEOGRAPH-54BA
        0x54BE, # G+10942  U+54BE  uni54BE,  CJK UNIFIED IDEOGRAPH-54BE
        0x54C3, # G+10943  U+54C3  uni54C3,  CJK UNIFIED IDEOGRAPH-54C3
        0x54C5, # G+10944  U+54C5  uni54C5,  CJK UNIFIED IDEOGRAPH-54C5
        0x54CA, # G+10945  U+54CA  uni54CA,  CJK UNIFIED IDEOGRAPH-54CA
        0x54CB, # G+10946  U+54CB  uni54CB,  CJK UNIFIED IDEOGRAPH-54CB
        0x54D6, # G+10947  U+54D6  uni54D6,  CJK UNIFIED IDEOGRAPH-54D6
        0x54D8, # G+10948  U+54D8  uni54D8,  CJK UNIFIED IDEOGRAPH-54D8
        0x54DB, # G+10949  U+54DB  uni54DB,  CJK UNIFIED IDEOGRAPH-54DB
        0x54E0, # G+10950  U+54E0  uni54E0,  CJK UNIFIED IDEOGRAPH-54E0
        0x54E2, # G+10951  U+54E2  uni54E2,  CJK UNIFIED IDEOGRAPH-54E2
        0x54E3, # G+10952  U+54E3  uni54E3,  CJK UNIFIED IDEOGRAPH-54E3
        0x54E4, # G+10953  U+54E4  uni54E4,  CJK UNIFIED IDEOGRAPH-54E4
        0x54EB, # G+10954  U+54EB  uni54EB,  CJK UNIFIED IDEOGRAPH-54EB
        0x54EC, # G+10955  U+54EC  uni54EC,  CJK UNIFIED IDEOGRAPH-54EC
        0x54EF, # G+10956  U+54EF  uni54EF,  CJK UNIFIED IDEOGRAPH-54EF
        0x54F0, # G+10957  U+54F0  uni54F0,  CJK UNIFIED IDEOGRAPH-54F0
        0x54F1, # G+10958  U+54F1  uni54F1,  CJK UNIFIED IDEOGRAPH-54F1
        0x54F4, # G+10959  U+54F4  uni54F4,  CJK UNIFIED IDEOGRAPH-54F4
        0x54F5, # G+10960  U+54F5  uni54F5,  CJK UNIFIED IDEOGRAPH-54F5
        0x54F6, # G+10961  U+54F6  uni54F6,  CJK UNIFIED IDEOGRAPH-54F6
        0x54F7, # G+10962  U+54F7  uni54F7,  CJK UNIFIED IDEOGRAPH-54F7
        0x54F8, # G+10963  U+54F8  uni54F8,  CJK UNIFIED IDEOGRAPH-54F8
        0x54F9, # G+10964  U+54F9  uni54F9,  CJK UNIFIED IDEOGRAPH-54F9
        0x54FB, # G+10965  U+54FB  uni54FB,  CJK UNIFIED IDEOGRAPH-54FB
        0x54FE, # G+10966  U+54FE  uni54FE,  CJK UNIFIED IDEOGRAPH-54FE
        0x5500, # G+10967  U+5500  uni5500,  CJK UNIFIED IDEOGRAPH-5500
        0x5502, # G+10968  U+5502  uni5502,  CJK UNIFIED IDEOGRAPH-5502
        0x5503, # G+10969  U+5503  uni5503,  CJK UNIFIED IDEOGRAPH-5503
        0x5505, # G+10970  U+5505  uni5505,  CJK UNIFIED IDEOGRAPH-5505
        0x5508, # G+10971  U+5508  uni5508,  CJK UNIFIED IDEOGRAPH-5508
        0x550A, # G+10972  U+550A  uni550A,  CJK UNIFIED IDEOGRAPH-550A
        0x550B, # G+10973  U+550B  uni550B,  CJK UNIFIED IDEOGRAPH-550B
        0x550C, # G+10974  U+550C  uni550C,  CJK UNIFIED IDEOGRAPH-550C
        0x550D, # G+10975  U+550D  uni550D,  CJK UNIFIED IDEOGRAPH-550D
        0x550E, # G+10976  U+550E  uni550E,  CJK UNIFIED IDEOGRAPH-550E
        0x5512, # G+10977  U+5512  uni5512,  CJK UNIFIED IDEOGRAPH-5512
        0x5513, # G+10978  U+5513  uni5513,  CJK UNIFIED IDEOGRAPH-5513
        0x5515, # G+10979  U+5515  uni5515,  CJK UNIFIED IDEOGRAPH-5515
        0x5516, # G+10980  U+5516  uni5516,  CJK UNIFIED IDEOGRAPH-5516
        0x5517, # G+10981  U+5517  uni5517,  CJK UNIFIED IDEOGRAPH-5517
        0x5518, # G+10982  U+5518  uni5518,  CJK UNIFIED IDEOGRAPH-5518
        0x5519, # G+10983  U+5519  uni5519,  CJK UNIFIED IDEOGRAPH-5519
        0x551A, # G+10984  U+551A  uni551A,  CJK UNIFIED IDEOGRAPH-551A
        0x551C, # G+10985  U+551C  uni551C,  CJK UNIFIED IDEOGRAPH-551C
        0x551D, # G+10986  U+551D  uni551D,  CJK UNIFIED IDEOGRAPH-551D
        0x551E, # G+10987  U+551E  uni551E,  CJK UNIFIED IDEOGRAPH-551E
        0x551F, # G+10988  U+551F  uni551F,  CJK UNIFIED IDEOGRAPH-551F
        0x5521, # G+10989  U+5521  uni5521,  CJK UNIFIED IDEOGRAPH-5521
        0x5525, # G+10990  U+5525  uni5525,  CJK UNIFIED IDEOGRAPH-5525
        0x5526, # G+10991  U+5526  uni5526,  CJK UNIFIED IDEOGRAPH-5526
        0x5528, # G+10992  U+5528  uni5528,  CJK UNIFIED IDEOGRAPH-5528
        0x5529, # G+10993  U+5529  uni5529,  CJK UNIFIED IDEOGRAPH-5529
        0x552B, # G+10994  U+552B  uni552B,  CJK UNIFIED IDEOGRAPH-552B
        0x552D, # G+10995  U+552D  uni552D,  CJK UNIFIED IDEOGRAPH-552D
        0x5532, # G+10996  U+5532  uni5532,  CJK UNIFIED IDEOGRAPH-5532
        0x5534, # G+10997  U+5534  uni5534,  CJK UNIFIED IDEOGRAPH-5534
        0x5535, # G+10998  U+5535  uni5535,  CJK UNIFIED IDEOGRAPH-5535
        0x5536, # G+10999  U+5536  uni5536,  CJK UNIFIED IDEOGRAPH-5536
        0x5538, # G+11000  U+5538  uni5538,  CJK UNIFIED IDEOGRAPH-5538
        0x5539, # G+11001  U+5539  uni5539,  CJK UNIFIED IDEOGRAPH-5539
        0x553A, # G+11002  U+553A  uni553A,  CJK UNIFIED IDEOGRAPH-553A
        0x553B, # G+11003  U+553B  uni553B,  CJK UNIFIED IDEOGRAPH-553B
        0x553D, # G+11004  U+553D  uni553D,  CJK UNIFIED IDEOGRAPH-553D
        0x5540, # G+11005  U+5540  uni5540,  CJK UNIFIED IDEOGRAPH-5540
        0x5542, # G+11006  U+5542  uni5542,  CJK UNIFIED IDEOGRAPH-5542
        0x5545, # G+11007  U+5545  uni5545,  CJK UNIFIED IDEOGRAPH-5545
        0x5547, # G+11008  U+5547  uni5547,  CJK UNIFIED IDEOGRAPH-5547
        0x5548, # G+11009  U+5548  uni5548,  CJK UNIFIED IDEOGRAPH-5548
        0x554B, # G+11010  U+554B  uni554B,  CJK UNIFIED IDEOGRAPH-554B
        0x554C, # G+11011  U+554C  uni554C,  CJK UNIFIED IDEOGRAPH-554C
        0x554D, # G+11012  U+554D  uni554D,  CJK UNIFIED IDEOGRAPH-554D
        0x554E, # G+11013  U+554E  uni554E,  CJK UNIFIED IDEOGRAPH-554E
        0x5551, # G+11014  U+5551  uni5551,  CJK UNIFIED IDEOGRAPH-5551
        0x5552, # G+11015  U+5552  uni5552,  CJK UNIFIED IDEOGRAPH-5552
        0x5554, # G+11016  U+5554  uni5554,  CJK UNIFIED IDEOGRAPH-5554
        0x5557, # G+11017  U+5557  uni5557,  CJK UNIFIED IDEOGRAPH-5557
        0x5558, # G+11018  U+5558  uni5558,  CJK UNIFIED IDEOGRAPH-5558
        0x5559, # G+11019  U+5559  uni5559,  CJK UNIFIED IDEOGRAPH-5559
        0x555A, # G+11020  U+555A  uni555A,  CJK UNIFIED IDEOGRAPH-555A
        0x555B, # G+11021  U+555B  uni555B,  CJK UNIFIED IDEOGRAPH-555B
        0x555D, # G+11022  U+555D  uni555D,  CJK UNIFIED IDEOGRAPH-555D
        0x555F, # G+11023  U+555F  uni555F,  CJK UNIFIED IDEOGRAPH-555F
        0x5560, # G+11024  U+5560  uni5560,  CJK UNIFIED IDEOGRAPH-5560
        0x5562, # G+11025  U+5562  uni5562,  CJK UNIFIED IDEOGRAPH-5562
        0x5563, # G+11026  U+5563  uni5563,  CJK UNIFIED IDEOGRAPH-5563
        0x5568, # G+11027  U+5568  uni5568,  CJK UNIFIED IDEOGRAPH-5568
        0x5569, # G+11028  U+5569  uni5569,  CJK UNIFIED IDEOGRAPH-5569
        0x556B, # G+11029  U+556B  uni556B,  CJK UNIFIED IDEOGRAPH-556B
        0x556F, # G+11030  U+556F  uni556F,  CJK UNIFIED IDEOGRAPH-556F
        0x5570, # G+11031  U+5570  uni5570,  CJK UNIFIED IDEOGRAPH-5570
        0x5571, # G+11032  U+5571  uni5571,  CJK UNIFIED IDEOGRAPH-5571
        0x5572, # G+11033  U+5572  uni5572,  CJK UNIFIED IDEOGRAPH-5572
        0x5573, # G+11034  U+5573  uni5573,  CJK UNIFIED IDEOGRAPH-5573
        0x5574, # G+11035  U+5574  uni5574,  CJK UNIFIED IDEOGRAPH-5574
        0x5579, # G+11036  U+5579  uni5579,  CJK UNIFIED IDEOGRAPH-5579
        0x557A, # G+11037  U+557A  uni557A,  CJK UNIFIED IDEOGRAPH-557A
        0x557D, # G+11038  U+557D  uni557D,  CJK UNIFIED IDEOGRAPH-557D
        0x557F, # G+11039  U+557F  uni557F,  CJK UNIFIED IDEOGRAPH-557F
        0x5585, # G+11040  U+5585  uni5585,  CJK UNIFIED IDEOGRAPH-5585
        0x5586, # G+11041  U+5586  uni5586,  CJK UNIFIED IDEOGRAPH-5586
        0x558C, # G+11042  U+558C  uni558C,  CJK UNIFIED IDEOGRAPH-558C
        0x558D, # G+11043  U+558D  uni558D,  CJK UNIFIED IDEOGRAPH-558D
        0x558E, # G+11044  U+558E  uni558E,  CJK UNIFIED IDEOGRAPH-558E
        0x5590, # G+11045  U+5590  uni5590,  CJK UNIFIED IDEOGRAPH-5590
        0x5592, # G+11046  U+5592  uni5592,  CJK UNIFIED IDEOGRAPH-5592
        0x5593, # G+11047  U+5593  uni5593,  CJK UNIFIED IDEOGRAPH-5593
        0x5595, # G+11048  U+5595  uni5595,  CJK UNIFIED IDEOGRAPH-5595
        0x5596, # G+11049  U+5596  uni5596,  CJK UNIFIED IDEOGRAPH-5596
        0x5597, # G+11050  U+5597  uni5597,  CJK UNIFIED IDEOGRAPH-5597
        0x559A, # G+11051  U+559A  uni559A,  CJK UNIFIED IDEOGRAPH-559A
        0x559B, # G+11052  U+559B  uni559B,  CJK UNIFIED IDEOGRAPH-559B
        0x559E, # G+11053  U+559E  uni559E,  CJK UNIFIED IDEOGRAPH-559E
        0x55A0, # G+11054  U+55A0  uni55A0,  CJK UNIFIED IDEOGRAPH-55A0
        0x55A1, # G+11055  U+55A1  uni55A1,  CJK UNIFIED IDEOGRAPH-55A1
        0x55A2, # G+11056  U+55A2  uni55A2,  CJK UNIFIED IDEOGRAPH-55A2
        0x55A3, # G+11057  U+55A3  uni55A3,  CJK UNIFIED IDEOGRAPH-55A3
        0x55A4, # G+11058  U+55A4  uni55A4,  CJK UNIFIED IDEOGRAPH-55A4
        0x55A5, # G+11059  U+55A5  uni55A5,  CJK UNIFIED IDEOGRAPH-55A5
        0x55A6, # G+11060  U+55A6  uni55A6,  CJK UNIFIED IDEOGRAPH-55A6
        0x55A8, # G+11061  U+55A8  uni55A8,  CJK UNIFIED IDEOGRAPH-55A8
        0x55A9, # G+11062  U+55A9  uni55A9,  CJK UNIFIED IDEOGRAPH-55A9
        0x55AB, # G+11063  U+55AB  uni55AB,  CJK UNIFIED IDEOGRAPH-55AB
        0x55AD, # G+11064  U+55AD  uni55AD,  CJK UNIFIED IDEOGRAPH-55AD
        0x55AF, # G+11065  U+55AF  uni55AF,  CJK UNIFIED IDEOGRAPH-55AF
        0x55B0, # G+11066  U+55B0  uni55B0,  CJK UNIFIED IDEOGRAPH-55B0
        0x55B4, # G+11067  U+55B4  uni55B4,  CJK UNIFIED IDEOGRAPH-55B4
        0x55B6, # G+11068  U+55B6  uni55B6,  CJK UNIFIED IDEOGRAPH-55B6
        0x55B8, # G+11069  U+55B8  uni55B8,  CJK UNIFIED IDEOGRAPH-55B8
        0x55BA, # G+11070  U+55BA  uni55BA,  CJK UNIFIED IDEOGRAPH-55BA
        0x55BC, # G+11071  U+55BC  uni55BC,  CJK UNIFIED IDEOGRAPH-55BC
        0x55BF, # G+11072  U+55BF  uni55BF,  CJK UNIFIED IDEOGRAPH-55BF
        0x55C0, # G+11073  U+55C0  uni55C0,  CJK UNIFIED IDEOGRAPH-55C0
        0x55C1, # G+11074  U+55C1  uni55C1,  CJK UNIFIED IDEOGRAPH-55C1
        0x55C2, # G+11075  U+55C2  uni55C2,  CJK UNIFIED IDEOGRAPH-55C2
        0x55C3, # G+11076  U+55C3  uni55C3,  CJK UNIFIED IDEOGRAPH-55C3
        0x55C8, # G+11077  U+55C8  uni55C8,  CJK UNIFIED IDEOGRAPH-55C8
        0x55CA, # G+11078  U+55CA  uni55CA,  CJK UNIFIED IDEOGRAPH-55CA
        0x55CB, # G+11079  U+55CB  uni55CB,  CJK UNIFIED IDEOGRAPH-55CB
        0x55CF, # G+11080  U+55CF  uni55CF,  CJK UNIFIED IDEOGRAPH-55CF
        0x55D0, # G+11081  U+55D0  uni55D0,  CJK UNIFIED IDEOGRAPH-55D0
        0x55D5, # G+11082  U+55D5  uni55D5,  CJK UNIFIED IDEOGRAPH-55D5
        0x55D7, # G+11083  U+55D7  uni55D7,  CJK UNIFIED IDEOGRAPH-55D7
        0x55D8, # G+11084  U+55D8  uni55D8,  CJK UNIFIED IDEOGRAPH-55D8
        0x55D9, # G+11085  U+55D9  uni55D9,  CJK UNIFIED IDEOGRAPH-55D9
        0x55DB, # G+11086  U+55DB  uni55DB,  CJK UNIFIED IDEOGRAPH-55DB
        0x55DE, # G+11087  U+55DE  uni55DE,  CJK UNIFIED IDEOGRAPH-55DE
        0x55E0, # G+11088  U+55E0  uni55E0,  CJK UNIFIED IDEOGRAPH-55E0
        0x55E2, # G+11089  U+55E2  uni55E2,  CJK UNIFIED IDEOGRAPH-55E2
        0x55E7, # G+11090  U+55E7  uni55E7,  CJK UNIFIED IDEOGRAPH-55E7
        0x55ED, # G+11091  U+55ED  uni55ED,  CJK UNIFIED IDEOGRAPH-55ED
        0x55EE, # G+11092  U+55EE  uni55EE,  CJK UNIFIED IDEOGRAPH-55EE
        0x55F0, # G+11093  U+55F0  uni55F0,  CJK UNIFIED IDEOGRAPH-55F0
        0x55F1, # G+11094  U+55F1  uni55F1,  CJK UNIFIED IDEOGRAPH-55F1
        0x55F4, # G+11095  U+55F4  uni55F4,  CJK UNIFIED IDEOGRAPH-55F4
        0x55F8, # G+11096  U+55F8  uni55F8,  CJK UNIFIED IDEOGRAPH-55F8
        0x55F9, # G+11097  U+55F9  uni55F9,  CJK UNIFIED IDEOGRAPH-55F9
        0x55FA, # G+11098  U+55FA  uni55FA,  CJK UNIFIED IDEOGRAPH-55FA
        0x55FB, # G+11099  U+55FB  uni55FB,  CJK UNIFIED IDEOGRAPH-55FB
        0x55FC, # G+11100  U+55FC  uni55FC,  CJK UNIFIED IDEOGRAPH-55FC
        0x55FF, # G+11101  U+55FF  uni55FF,  CJK UNIFIED IDEOGRAPH-55FF
        0x5602, # G+11102  U+5602  uni5602,  CJK UNIFIED IDEOGRAPH-5602
        0x5603, # G+11103  U+5603  uni5603,  CJK UNIFIED IDEOGRAPH-5603
        0x5604, # G+11104  U+5604  uni5604,  CJK UNIFIED IDEOGRAPH-5604
        0x5605, # G+11105  U+5605  uni5605,  CJK UNIFIED IDEOGRAPH-5605
        0x5607, # G+11106  U+5607  uni5607,  CJK UNIFIED IDEOGRAPH-5607
        0x560A, # G+11107  U+560A  uni560A,  CJK UNIFIED IDEOGRAPH-560A
        0x560B, # G+11108  U+560B  uni560B,  CJK UNIFIED IDEOGRAPH-560B
        0x5610, # G+11109  U+5610  uni5610,  CJK UNIFIED IDEOGRAPH-5610
        0x5611, # G+11110  U+5611  uni5611,  CJK UNIFIED IDEOGRAPH-5611
        0x5612, # G+11111  U+5612  uni5612,  CJK UNIFIED IDEOGRAPH-5612
        0x5613, # G+11112  U+5613  uni5613,  CJK UNIFIED IDEOGRAPH-5613
        0x5615, # G+11113  U+5615  uni5615,  CJK UNIFIED IDEOGRAPH-5615
        0x5619, # G+11114  U+5619  uni5619,  CJK UNIFIED IDEOGRAPH-5619
        0x561A, # G+11115  U+561A  uni561A,  CJK UNIFIED IDEOGRAPH-561A
        0x561D, # G+11116  U+561D  uni561D,  CJK UNIFIED IDEOGRAPH-561D
        0x5620, # G+11117  U+5620  uni5620,  CJK UNIFIED IDEOGRAPH-5620
        0x5621, # G+11118  U+5621  uni5621,  CJK UNIFIED IDEOGRAPH-5621
        0x5622, # G+11119  U+5622  uni5622,  CJK UNIFIED IDEOGRAPH-5622
        0x5625, # G+11120  U+5625  uni5625,  CJK UNIFIED IDEOGRAPH-5625
        0x5626, # G+11121  U+5626  uni5626,  CJK UNIFIED IDEOGRAPH-5626
        0x5628, # G+11122  U+5628  uni5628,  CJK UNIFIED IDEOGRAPH-5628
        0x562A, # G+11123  U+562A  uni562A,  CJK UNIFIED IDEOGRAPH-562A
        0x562B, # G+11124  U+562B  uni562B,  CJK UNIFIED IDEOGRAPH-562B
        0x5633, # G+11125  U+5633  uni5633,  CJK UNIFIED IDEOGRAPH-5633
        0x5637, # G+11126  U+5637  uni5637,  CJK UNIFIED IDEOGRAPH-5637
        0x563A, # G+11127  U+563A  uni563A,  CJK UNIFIED IDEOGRAPH-563A
        0x563C, # G+11128  U+563C  uni563C,  CJK UNIFIED IDEOGRAPH-563C
        0x563D, # G+11129  U+563D  uni563D,  CJK UNIFIED IDEOGRAPH-563D
        0x563E, # G+11130  U+563E  uni563E,  CJK UNIFIED IDEOGRAPH-563E
        0x5640, # G+11131  U+5640  uni5640,  CJK UNIFIED IDEOGRAPH-5640
        0x5642, # G+11132  U+5642  uni5642,  CJK UNIFIED IDEOGRAPH-5642
        0x5643, # G+11133  U+5643  uni5643,  CJK UNIFIED IDEOGRAPH-5643
        0x5644, # G+11134  U+5644  uni5644,  CJK UNIFIED IDEOGRAPH-5644
        0x5645, # G+11135  U+5645  uni5645,  CJK UNIFIED IDEOGRAPH-5645
        0x5646, # G+11136  U+5646  uni5646,  CJK UNIFIED IDEOGRAPH-5646
        0x5647, # G+11137  U+5647  uni5647,  CJK UNIFIED IDEOGRAPH-5647
        0x5648, # G+11138  U+5648  uni5648,  CJK UNIFIED IDEOGRAPH-5648
        0x5649, # G+11139  U+5649  uni5649,  CJK UNIFIED IDEOGRAPH-5649
        0x564A, # G+11140  U+564A  uni564A,  CJK UNIFIED IDEOGRAPH-564A
        0x564B, # G+11141  U+564B  uni564B,  CJK UNIFIED IDEOGRAPH-564B
        0x564F, # G+11142  U+564F  uni564F,  CJK UNIFIED IDEOGRAPH-564F
        0x5650, # G+11143  U+5650  uni5650,  CJK UNIFIED IDEOGRAPH-5650
        0x5651, # G+11144  U+5651  uni5651,  CJK UNIFIED IDEOGRAPH-5651
        0x5652, # G+11145  U+5652  uni5652,  CJK UNIFIED IDEOGRAPH-5652
        0x5653, # G+11146  U+5653  uni5653,  CJK UNIFIED IDEOGRAPH-5653
        0x5655, # G+11147  U+5655  uni5655,  CJK UNIFIED IDEOGRAPH-5655
        0x5656, # G+11148  U+5656  uni5656,  CJK UNIFIED IDEOGRAPH-5656
        0x565A, # G+11149  U+565A  uni565A,  CJK UNIFIED IDEOGRAPH-565A
        0x565B, # G+11150  U+565B  uni565B,  CJK UNIFIED IDEOGRAPH-565B
        0x565E, # G+11151  U+565E  uni565E,  CJK UNIFIED IDEOGRAPH-565E
        0x565F, # G+11152  U+565F  uni565F,  CJK UNIFIED IDEOGRAPH-565F
        0x5661, # G+11153  U+5661  uni5661,  CJK UNIFIED IDEOGRAPH-5661
        0x5663, # G+11154  U+5663  uni5663,  CJK UNIFIED IDEOGRAPH-5663
        0x5667, # G+11155  U+5667  uni5667,  CJK UNIFIED IDEOGRAPH-5667
        0x566D, # G+11156  U+566D  uni566D,  CJK UNIFIED IDEOGRAPH-566D
        0x566E, # G+11157  U+566E  uni566E,  CJK UNIFIED IDEOGRAPH-566E
        0x5670, # G+11158  U+5670  uni5670,  CJK UNIFIED IDEOGRAPH-5670
        0x5673, # G+11159  U+5673  uni5673,  CJK UNIFIED IDEOGRAPH-5673
        0x5675, # G+11160  U+5675  uni5675,  CJK UNIFIED IDEOGRAPH-5675
        0x5677, # G+11161  U+5677  uni5677,  CJK UNIFIED IDEOGRAPH-5677
        0x567A, # G+11162  U+567A  uni567A,  CJK UNIFIED IDEOGRAPH-567A
        0x567D, # G+11163  U+567D  uni567D,  CJK UNIFIED IDEOGRAPH-567D
        0x567E, # G+11164  U+567E  uni567E,  CJK UNIFIED IDEOGRAPH-567E
        0x567F, # G+11165  U+567F  uni567F,  CJK UNIFIED IDEOGRAPH-567F
        0x5681, # G+11166  U+5681  uni5681,  CJK UNIFIED IDEOGRAPH-5681
        0x5682, # G+11167  U+5682  uni5682,  CJK UNIFIED IDEOGRAPH-5682
        0x5683, # G+11168  U+5683  uni5683,  CJK UNIFIED IDEOGRAPH-5683
        0x5684, # G+11169  U+5684  uni5684,  CJK UNIFIED IDEOGRAPH-5684
        0x5688, # G+11170  U+5688  uni5688,  CJK UNIFIED IDEOGRAPH-5688
        0x5689, # G+11171  U+5689  uni5689,  CJK UNIFIED IDEOGRAPH-5689
        0x568A, # G+11172  U+568A  uni568A,  CJK UNIFIED IDEOGRAPH-568A
        0x568B, # G+11173  U+568B  uni568B,  CJK UNIFIED IDEOGRAPH-568B
        0x568D, # G+11174  U+568D  uni568D,  CJK UNIFIED IDEOGRAPH-568D
        0x5690, # G+11175  U+5690  uni5690,  CJK UNIFIED IDEOGRAPH-5690
        0x5691, # G+11176  U+5691  uni5691,  CJK UNIFIED IDEOGRAPH-5691
        0x5692, # G+11177  U+5692  uni5692,  CJK UNIFIED IDEOGRAPH-5692
        0x5694, # G+11178  U+5694  uni5694,  CJK UNIFIED IDEOGRAPH-5694
        0x5696, # G+11179  U+5696  uni5696,  CJK UNIFIED IDEOGRAPH-5696
        0x5697, # G+11180  U+5697  uni5697,  CJK UNIFIED IDEOGRAPH-5697
        0x5698, # G+11181  U+5698  uni5698,  CJK UNIFIED IDEOGRAPH-5698
        0x569A, # G+11182  U+569A  uni569A,  CJK UNIFIED IDEOGRAPH-569A
        0x569B, # G+11183  U+569B  uni569B,  CJK UNIFIED IDEOGRAPH-569B
        0x569C, # G+11184  U+569C  uni569C,  CJK UNIFIED IDEOGRAPH-569C
        0x569D, # G+11185  U+569D  uni569D,  CJK UNIFIED IDEOGRAPH-569D
        0x569E, # G+11186  U+569E  uni569E,  CJK UNIFIED IDEOGRAPH-569E
        0x569F, # G+11187  U+569F  uni569F,  CJK UNIFIED IDEOGRAPH-569F
        0x56A0, # G+11188  U+56A0  uni56A0,  CJK UNIFIED IDEOGRAPH-56A0
        0x56A1, # G+11189  U+56A1  uni56A1,  CJK UNIFIED IDEOGRAPH-56A1
        0x56A2, # G+11190  U+56A2  uni56A2,  CJK UNIFIED IDEOGRAPH-56A2
        0x56A4, # G+11191  U+56A4  uni56A4,  CJK UNIFIED IDEOGRAPH-56A4
        0x56A5, # G+11192  U+56A5  uni56A5,  CJK UNIFIED IDEOGRAPH-56A5
        0x56A7, # G+11193  U+56A7  uni56A7,  CJK UNIFIED IDEOGRAPH-56A7
        0x56A9, # G+11194  U+56A9  uni56A9,  CJK UNIFIED IDEOGRAPH-56A9
        0x56AA, # G+11195  U+56AA  uni56AA,  CJK UNIFIED IDEOGRAPH-56AA
        0x56AB, # G+11196  U+56AB  uni56AB,  CJK UNIFIED IDEOGRAPH-56AB
        0x56AC, # G+11197  U+56AC  uni56AC,  CJK UNIFIED IDEOGRAPH-56AC
        0x56AD, # G+11198  U+56AD  uni56AD,  CJK UNIFIED IDEOGRAPH-56AD
        0x56B0, # G+11199  U+56B0  uni56B0,  CJK UNIFIED IDEOGRAPH-56B0
        0x56B1, # G+11200  U+56B1  uni56B1,  CJK UNIFIED IDEOGRAPH-56B1
        0x56B2, # G+11201  U+56B2  uni56B2,  CJK UNIFIED IDEOGRAPH-56B2
        0x56B5, # G+11202  U+56B5  uni56B5,  CJK UNIFIED IDEOGRAPH-56B5
        0x56B8, # G+11203  U+56B8  uni56B8,  CJK UNIFIED IDEOGRAPH-56B8
        0x56B9, # G+11204  U+56B9  uni56B9,  CJK UNIFIED IDEOGRAPH-56B9
        0x56BA, # G+11205  U+56BA  uni56BA,  CJK UNIFIED IDEOGRAPH-56BA
        0x56BB, # G+11206  U+56BB  uni56BB,  CJK UNIFIED IDEOGRAPH-56BB
        0x56BD, # G+11207  U+56BD  uni56BD,  CJK UNIFIED IDEOGRAPH-56BD
        0x56BE, # G+11208  U+56BE  uni56BE,  CJK UNIFIED IDEOGRAPH-56BE
        0x56BF, # G+11209  U+56BF  uni56BF,  CJK UNIFIED IDEOGRAPH-56BF
        0x56C3, # G+11210  U+56C3  uni56C3,  CJK UNIFIED IDEOGRAPH-56C3
        0x56C4, # G+11211  U+56C4  uni56C4,  CJK UNIFIED IDEOGRAPH-56C4
        0x56C6, # G+11212  U+56C6  uni56C6,  CJK UNIFIED IDEOGRAPH-56C6
        0x56C7, # G+11213  U+56C7  uni56C7,  CJK UNIFIED IDEOGRAPH-56C7
        0x56CB, # G+11214  U+56CB  uni56CB,  CJK UNIFIED IDEOGRAPH-56CB
        0x56CD, # G+11215  U+56CD  uni56CD,  CJK UNIFIED IDEOGRAPH-56CD
        0x56CE, # G+11216  U+56CE  uni56CE,  CJK UNIFIED IDEOGRAPH-56CE
        0x56CF, # G+11217  U+56CF  uni56CF,  CJK UNIFIED IDEOGRAPH-56CF
        0x56D0, # G+11218  U+56D0  uni56D0,  CJK UNIFIED IDEOGRAPH-56D0
        0x56D2, # G+11219  U+56D2  uni56D2,  CJK UNIFIED IDEOGRAPH-56D2
        0x56D3, # G+11220  U+56D3  uni56D3,  CJK UNIFIED IDEOGRAPH-56D3
        0x56D5, # G+11221  U+56D5  uni56D5,  CJK UNIFIED IDEOGRAPH-56D5
        0x56D6, # G+11222  U+56D6  uni56D6,  CJK UNIFIED IDEOGRAPH-56D6
        0x56D8, # G+11223  U+56D8  uni56D8,  CJK UNIFIED IDEOGRAPH-56D8
        0x56D9, # G+11224  U+56D9  uni56D9,  CJK UNIFIED IDEOGRAPH-56D9
        0x56DC, # G+11225  U+56DC  uni56DC,  CJK UNIFIED IDEOGRAPH-56DC
        0x56E3, # G+11226  U+56E3  uni56E3,  CJK UNIFIED IDEOGRAPH-56E3
        0x56E5, # G+11227  U+56E5  uni56E5,  CJK UNIFIED IDEOGRAPH-56E5
        0x56E6, # G+11228  U+56E6  uni56E6,  CJK UNIFIED IDEOGRAPH-56E6
        0x56E7, # G+11229  U+56E7  uni56E7,  CJK UNIFIED IDEOGRAPH-56E7
        0x56E8, # G+11230  U+56E8  uni56E8,  CJK UNIFIED IDEOGRAPH-56E8
        0x56E9, # G+11231  U+56E9  uni56E9,  CJK UNIFIED IDEOGRAPH-56E9
        0x56EA, # G+11232  U+56EA  uni56EA,  CJK UNIFIED IDEOGRAPH-56EA
        0x56EC, # G+11233  U+56EC  uni56EC,  CJK UNIFIED IDEOGRAPH-56EC
        0x56EE, # G+11234  U+56EE  uni56EE,  CJK UNIFIED IDEOGRAPH-56EE
        0x56EF, # G+11235  U+56EF  uni56EF,  CJK UNIFIED IDEOGRAPH-56EF
        0x56F2, # G+11236  U+56F2  uni56F2,  CJK UNIFIED IDEOGRAPH-56F2
        0x56F3, # G+11237  U+56F3  uni56F3,  CJK UNIFIED IDEOGRAPH-56F3
        0x56F6, # G+11238  U+56F6  uni56F6,  CJK UNIFIED IDEOGRAPH-56F6
        0x56F7, # G+11239  U+56F7  uni56F7,  CJK UNIFIED IDEOGRAPH-56F7
        0x56F8, # G+11240  U+56F8  uni56F8,  CJK UNIFIED IDEOGRAPH-56F8
        0x56FB, # G+11241  U+56FB  uni56FB,  CJK UNIFIED IDEOGRAPH-56FB
        0x56FC, # G+11242  U+56FC  uni56FC,  CJK UNIFIED IDEOGRAPH-56FC
        0x5700, # G+11243  U+5700  uni5700,  CJK UNIFIED IDEOGRAPH-5700
        0x5701, # G+11244  U+5701  uni5701,  CJK UNIFIED IDEOGRAPH-5701
        0x5702, # G+11245  U+5702  uni5702,  CJK UNIFIED IDEOGRAPH-5702
        0x5705, # G+11246  U+5705  uni5705,  CJK UNIFIED IDEOGRAPH-5705
        0x570C, # G+11247  U+570C  uni570C,  CJK UNIFIED IDEOGRAPH-570C
        0x570E, # G+11248  U+570E  uni570E,  CJK UNIFIED IDEOGRAPH-570E
        0x570F, # G+11249  U+570F  uni570F,  CJK UNIFIED IDEOGRAPH-570F
        0x5710, # G+11250  U+5710  uni5710,  CJK UNIFIED IDEOGRAPH-5710
        0x5711, # G+11251  U+5711  uni5711,  CJK UNIFIED IDEOGRAPH-5711
        0x5714, # G+11252  U+5714  uni5714,  CJK UNIFIED IDEOGRAPH-5714
        0x5715, # G+11253  U+5715  uni5715,  CJK UNIFIED IDEOGRAPH-5715
        0x5717, # G+11254  U+5717  uni5717,  CJK UNIFIED IDEOGRAPH-5717
        0x5719, # G+11255  U+5719  uni5719,  CJK UNIFIED IDEOGRAPH-5719
        0x571A, # G+11256  U+571A  uni571A,  CJK UNIFIED IDEOGRAPH-571A
        0x571B, # G+11257  U+571B  uni571B,  CJK UNIFIED IDEOGRAPH-571B
        0x571D, # G+11258  U+571D  uni571D,  CJK UNIFIED IDEOGRAPH-571D
        0x571E, # G+11259  U+571E  uni571E,  CJK UNIFIED IDEOGRAPH-571E
        0x5720, # G+11260  U+5720  uni5720,  CJK UNIFIED IDEOGRAPH-5720
        0x5721, # G+11261  U+5721  uni5721,  CJK UNIFIED IDEOGRAPH-5721
        0x5722, # G+11262  U+5722  uni5722,  CJK UNIFIED IDEOGRAPH-5722
        0x5724, # G+11263  U+5724  uni5724,  CJK UNIFIED IDEOGRAPH-5724
        0x5725, # G+11264  U+5725  uni5725,  CJK UNIFIED IDEOGRAPH-5725
        0x5726, # G+11265  U+5726  uni5726,  CJK UNIFIED IDEOGRAPH-5726
        0x5727, # G+11266  U+5727  uni5727,  CJK UNIFIED IDEOGRAPH-5727
        0x572B, # G+11267  U+572B  uni572B,  CJK UNIFIED IDEOGRAPH-572B
        0x5731, # G+11268  U+5731  uni5731,  CJK UNIFIED IDEOGRAPH-5731
        0x5732, # G+11269  U+5732  uni5732,  CJK UNIFIED IDEOGRAPH-5732
        0x5734, # G+11270  U+5734  uni5734,  CJK UNIFIED IDEOGRAPH-5734
        0x5735, # G+11271  U+5735  uni5735,  CJK UNIFIED IDEOGRAPH-5735
        0x5736, # G+11272  U+5736  uni5736,  CJK UNIFIED IDEOGRAPH-5736
        0x5737, # G+11273  U+5737  uni5737,  CJK UNIFIED IDEOGRAPH-5737
        0x5738, # G+11274  U+5738  uni5738,  CJK UNIFIED IDEOGRAPH-5738
        0x573C, # G+11275  U+573C  uni573C,  CJK UNIFIED IDEOGRAPH-573C
        0x573D, # G+11276  U+573D  uni573D,  CJK UNIFIED IDEOGRAPH-573D
        0x573F, # G+11277  U+573F  uni573F,  CJK UNIFIED IDEOGRAPH-573F
        0x5741, # G+11278  U+5741  uni5741,  CJK UNIFIED IDEOGRAPH-5741
        0x5743, # G+11279  U+5743  uni5743,  CJK UNIFIED IDEOGRAPH-5743
        0x5744, # G+11280  U+5744  uni5744,  CJK UNIFIED IDEOGRAPH-5744
        0x5745, # G+11281  U+5745  uni5745,  CJK UNIFIED IDEOGRAPH-5745
        0x5746, # G+11282  U+5746  uni5746,  CJK UNIFIED IDEOGRAPH-5746
        0x5748, # G+11283  U+5748  uni5748,  CJK UNIFIED IDEOGRAPH-5748
        0x5749, # G+11284  U+5749  uni5749,  CJK UNIFIED IDEOGRAPH-5749
        0x574B, # G+11285  U+574B  uni574B,  CJK UNIFIED IDEOGRAPH-574B
        0x5752, # G+11286  U+5752  uni5752,  CJK UNIFIED IDEOGRAPH-5752
        0x5753, # G+11287  U+5753  uni5753,  CJK UNIFIED IDEOGRAPH-5753
        0x5754, # G+11288  U+5754  uni5754,  CJK UNIFIED IDEOGRAPH-5754
        0x5755, # G+11289  U+5755  uni5755,  CJK UNIFIED IDEOGRAPH-5755
        0x5756, # G+11290  U+5756  uni5756,  CJK UNIFIED IDEOGRAPH-5756
        0x5758, # G+11291  U+5758  uni5758,  CJK UNIFIED IDEOGRAPH-5758
        0x5759, # G+11292  U+5759  uni5759,  CJK UNIFIED IDEOGRAPH-5759
        0x5762, # G+11293  U+5762  uni5762,  CJK UNIFIED IDEOGRAPH-5762
        0x5763, # G+11294  U+5763  uni5763,  CJK UNIFIED IDEOGRAPH-5763
        0x5765, # G+11295  U+5765  uni5765,  CJK UNIFIED IDEOGRAPH-5765
        0x5767, # G+11296  U+5767  uni5767,  CJK UNIFIED IDEOGRAPH-5767
        0x576C, # G+11297  U+576C  uni576C,  CJK UNIFIED IDEOGRAPH-576C
        0x576E, # G+11298  U+576E  uni576E,  CJK UNIFIED IDEOGRAPH-576E
        0x5770, # G+11299  U+5770  uni5770,  CJK UNIFIED IDEOGRAPH-5770
        0x5771, # G+11300  U+5771  uni5771,  CJK UNIFIED IDEOGRAPH-5771
        0x5772, # G+11301  U+5772  uni5772,  CJK UNIFIED IDEOGRAPH-5772
        0x5774, # G+11302  U+5774  uni5774,  CJK UNIFIED IDEOGRAPH-5774
        0x5775, # G+11303  U+5775  uni5775,  CJK UNIFIED IDEOGRAPH-5775
        0x5778, # G+11304  U+5778  uni5778,  CJK UNIFIED IDEOGRAPH-5778
        0x5779, # G+11305  U+5779  uni5779,  CJK UNIFIED IDEOGRAPH-5779
        0x577A, # G+11306  U+577A  uni577A,  CJK UNIFIED IDEOGRAPH-577A
        0x577D, # G+11307  U+577D  uni577D,  CJK UNIFIED IDEOGRAPH-577D
        0x577E, # G+11308  U+577E  uni577E,  CJK UNIFIED IDEOGRAPH-577E
        0x577F, # G+11309  U+577F  uni577F,  CJK UNIFIED IDEOGRAPH-577F
        0x5780, # G+11310  U+5780  uni5780,  CJK UNIFIED IDEOGRAPH-5780
        0x5781, # G+11311  U+5781  uni5781,  CJK UNIFIED IDEOGRAPH-5781
        0x5787, # G+11312  U+5787  uni5787,  CJK UNIFIED IDEOGRAPH-5787
        0x5788, # G+11313  U+5788  uni5788,  CJK UNIFIED IDEOGRAPH-5788
        0x5789, # G+11314  U+5789  uni5789,  CJK UNIFIED IDEOGRAPH-5789
        0x578A, # G+11315  U+578A  uni578A,  CJK UNIFIED IDEOGRAPH-578A
        0x578D, # G+11316  U+578D  uni578D,  CJK UNIFIED IDEOGRAPH-578D
        0x578E, # G+11317  U+578E  uni578E,  CJK UNIFIED IDEOGRAPH-578E
        0x578F, # G+11318  U+578F  uni578F,  CJK UNIFIED IDEOGRAPH-578F
        0x5790, # G+11319  U+5790  uni5790,  CJK UNIFIED IDEOGRAPH-5790
        0x5791, # G+11320  U+5791  uni5791,  CJK UNIFIED IDEOGRAPH-5791
        0x5794, # G+11321  U+5794  uni5794,  CJK UNIFIED IDEOGRAPH-5794
        0x5795, # G+11322  U+5795  uni5795,  CJK UNIFIED IDEOGRAPH-5795
        0x5796, # G+11323  U+5796  uni5796,  CJK UNIFIED IDEOGRAPH-5796
        0x5797, # G+11324  U+5797  uni5797,  CJK UNIFIED IDEOGRAPH-5797
        0x5798, # G+11325  U+5798  uni5798,  CJK UNIFIED IDEOGRAPH-5798
        0x5799, # G+11326  U+5799  uni5799,  CJK UNIFIED IDEOGRAPH-5799
        0x579A, # G+11327  U+579A  uni579A,  CJK UNIFIED IDEOGRAPH-579A
        0x579C, # G+11328  U+579C  uni579C,  CJK UNIFIED IDEOGRAPH-579C
        0x579D, # G+11329  U+579D  uni579D,  CJK UNIFIED IDEOGRAPH-579D
        0x579E, # G+11330  U+579E  uni579E,  CJK UNIFIED IDEOGRAPH-579E
        0x579F, # G+11331  U+579F  uni579F,  CJK UNIFIED IDEOGRAPH-579F
        0x57A5, # G+11332  U+57A5  uni57A5,  CJK UNIFIED IDEOGRAPH-57A5
        0x57A8, # G+11333  U+57A8  uni57A8,  CJK UNIFIED IDEOGRAPH-57A8
        0x57AA, # G+11334  U+57AA  uni57AA,  CJK UNIFIED IDEOGRAPH-57AA
        0x57AC, # G+11335  U+57AC  uni57AC,  CJK UNIFIED IDEOGRAPH-57AC
        0x57AF, # G+11336  U+57AF  uni57AF,  CJK UNIFIED IDEOGRAPH-57AF
        0x57B0, # G+11337  U+57B0  uni57B0,  CJK UNIFIED IDEOGRAPH-57B0
        0x57B1, # G+11338  U+57B1  uni57B1,  CJK UNIFIED IDEOGRAPH-57B1
        0x57B3, # G+11339  U+57B3  uni57B3,  CJK UNIFIED IDEOGRAPH-57B3
        0x57B5, # G+11340  U+57B5  uni57B5,  CJK UNIFIED IDEOGRAPH-57B5
        0x57B6, # G+11341  U+57B6  uni57B6,  CJK UNIFIED IDEOGRAPH-57B6
        0x57B7, # G+11342  U+57B7  uni57B7,  CJK UNIFIED IDEOGRAPH-57B7
        0x57B9, # G+11343  U+57B9  uni57B9,  CJK UNIFIED IDEOGRAPH-57B9
        0x57BA, # G+11344  U+57BA  uni57BA,  CJK UNIFIED IDEOGRAPH-57BA
        0x57BB, # G+11345  U+57BB  uni57BB,  CJK UNIFIED IDEOGRAPH-57BB
        0x57BC, # G+11346  U+57BC  uni57BC,  CJK UNIFIED IDEOGRAPH-57BC
        0x57BD, # G+11347  U+57BD  uni57BD,  CJK UNIFIED IDEOGRAPH-57BD
        0x57BE, # G+11348  U+57BE  uni57BE,  CJK UNIFIED IDEOGRAPH-57BE
        0x57BF, # G+11349  U+57BF  uni57BF,  CJK UNIFIED IDEOGRAPH-57BF
        0x57C0, # G+11350  U+57C0  uni57C0,  CJK UNIFIED IDEOGRAPH-57C0
        0x57C1, # G+11351  U+57C1  uni57C1,  CJK UNIFIED IDEOGRAPH-57C1
        0x57C4, # G+11352  U+57C4  uni57C4,  CJK UNIFIED IDEOGRAPH-57C4
        0x57C5, # G+11353  U+57C5  uni57C5,  CJK UNIFIED IDEOGRAPH-57C5
        0x57C6, # G+11354  U+57C6  uni57C6,  CJK UNIFIED IDEOGRAPH-57C6
        0x57C7, # G+11355  U+57C7  uni57C7,  CJK UNIFIED IDEOGRAPH-57C7
        0x57C8, # G+11356  U+57C8  uni57C8,  CJK UNIFIED IDEOGRAPH-57C8
        0x57C9, # G+11357  U+57C9  uni57C9,  CJK UNIFIED IDEOGRAPH-57C9
        0x57CA, # G+11358  U+57CA  uni57CA,  CJK UNIFIED IDEOGRAPH-57CA
        0x57CC, # G+11359  U+57CC  uni57CC,  CJK UNIFIED IDEOGRAPH-57CC
        0x57CD, # G+11360  U+57CD  uni57CD,  CJK UNIFIED IDEOGRAPH-57CD
        0x57D0, # G+11361  U+57D0  uni57D0,  CJK UNIFIED IDEOGRAPH-57D0
        0x57D1, # G+11362  U+57D1  uni57D1,  CJK UNIFIED IDEOGRAPH-57D1
        0x57D3, # G+11363  U+57D3  uni57D3,  CJK UNIFIED IDEOGRAPH-57D3
        0x57D6, # G+11364  U+57D6  uni57D6,  CJK UNIFIED IDEOGRAPH-57D6
        0x57D7, # G+11365  U+57D7  uni57D7,  CJK UNIFIED IDEOGRAPH-57D7
        0x57DB, # G+11366  U+57DB  uni57DB,  CJK UNIFIED IDEOGRAPH-57DB
        0x57DC, # G+11367  U+57DC  uni57DC,  CJK UNIFIED IDEOGRAPH-57DC
        0x57DE, # G+11368  U+57DE  uni57DE,  CJK UNIFIED IDEOGRAPH-57DE
        0x57E2, # G+11369  U+57E2  uni57E2,  CJK UNIFIED IDEOGRAPH-57E2
        0x57E3, # G+11370  U+57E3  uni57E3,  CJK UNIFIED IDEOGRAPH-57E3
        0x57E5, # G+11371  U+57E5  uni57E5,  CJK UNIFIED IDEOGRAPH-57E5
        0x57E6, # G+11372  U+57E6  uni57E6,  CJK UNIFIED IDEOGRAPH-57E6
        0x57E7, # G+11373  U+57E7  uni57E7,  CJK UNIFIED IDEOGRAPH-57E7
        0x57E8, # G+11374  U+57E8  uni57E8,  CJK UNIFIED IDEOGRAPH-57E8
        0x57E9, # G+11375  U+57E9  uni57E9,  CJK UNIFIED IDEOGRAPH-57E9
        0x57EA, # G+11376  U+57EA  uni57EA,  CJK UNIFIED IDEOGRAPH-57EA
        0x57EB, # G+11377  U+57EB  uni57EB,  CJK UNIFIED IDEOGRAPH-57EB
        0x57EC, # G+11378  U+57EC  uni57EC,  CJK UNIFIED IDEOGRAPH-57EC
        0x57EE, # G+11379  U+57EE  uni57EE,  CJK UNIFIED IDEOGRAPH-57EE
        0x57F0, # G+11380  U+57F0  uni57F0,  CJK UNIFIED IDEOGRAPH-57F0
        0x57F1, # G+11381  U+57F1  uni57F1,  CJK UNIFIED IDEOGRAPH-57F1
        0x57F2, # G+11382  U+57F2  uni57F2,  CJK UNIFIED IDEOGRAPH-57F2
        0x57F3, # G+11383  U+57F3  uni57F3,  CJK UNIFIED IDEOGRAPH-57F3
        0x57F5, # G+11384  U+57F5  uni57F5,  CJK UNIFIED IDEOGRAPH-57F5
        0x57F6, # G+11385  U+57F6  uni57F6,  CJK UNIFIED IDEOGRAPH-57F6
        0x57FB, # G+11386  U+57FB  uni57FB,  CJK UNIFIED IDEOGRAPH-57FB
        0x57FC, # G+11387  U+57FC  uni57FC,  CJK UNIFIED IDEOGRAPH-57FC
        0x57FE, # G+11388  U+57FE  uni57FE,  CJK UNIFIED IDEOGRAPH-57FE
        0x57FF, # G+11389  U+57FF  uni57FF,  CJK UNIFIED IDEOGRAPH-57FF
        0x5801, # G+11390  U+5801  uni5801,  CJK UNIFIED IDEOGRAPH-5801
        0x5803, # G+11391  U+5803  uni5803,  CJK UNIFIED IDEOGRAPH-5803
        0x5804, # G+11392  U+5804  uni5804,  CJK UNIFIED IDEOGRAPH-5804
        0x5808, # G+11393  U+5808  uni5808,  CJK UNIFIED IDEOGRAPH-5808
        0x5809, # G+11394  U+5809  uni5809,  CJK UNIFIED IDEOGRAPH-5809
        0x580C, # G+11395  U+580C  uni580C,  CJK UNIFIED IDEOGRAPH-580C
        0x580E, # G+11396  U+580E  uni580E,  CJK UNIFIED IDEOGRAPH-580E
        0x580F, # G+11397  U+580F  uni580F,  CJK UNIFIED IDEOGRAPH-580F
        0x5810, # G+11398  U+5810  uni5810,  CJK UNIFIED IDEOGRAPH-5810
        0x5812, # G+11399  U+5812  uni5812,  CJK UNIFIED IDEOGRAPH-5812
        0x5813, # G+11400  U+5813  uni5813,  CJK UNIFIED IDEOGRAPH-5813
        0x5814, # G+11401  U+5814  uni5814,  CJK UNIFIED IDEOGRAPH-5814
        0x5817, # G+11402  U+5817  uni5817,  CJK UNIFIED IDEOGRAPH-5817
        0x5818, # G+11403  U+5818  uni5818,  CJK UNIFIED IDEOGRAPH-5818
        0x581A, # G+11404  U+581A  uni581A,  CJK UNIFIED IDEOGRAPH-581A
        0x581B, # G+11405  U+581B  uni581B,  CJK UNIFIED IDEOGRAPH-581B
        0x581C, # G+11406  U+581C  uni581C,  CJK UNIFIED IDEOGRAPH-581C
        0x581F, # G+11407  U+581F  uni581F,  CJK UNIFIED IDEOGRAPH-581F
        0x5822, # G+11408  U+5822  uni5822,  CJK UNIFIED IDEOGRAPH-5822
        0x5823, # G+11409  U+5823  uni5823,  CJK UNIFIED IDEOGRAPH-5823
        0x5825, # G+11410  U+5825  uni5825,  CJK UNIFIED IDEOGRAPH-5825
        0x5826, # G+11411  U+5826  uni5826,  CJK UNIFIED IDEOGRAPH-5826
        0x5827, # G+11412  U+5827  uni5827,  CJK UNIFIED IDEOGRAPH-5827
        0x5828, # G+11413  U+5828  uni5828,  CJK UNIFIED IDEOGRAPH-5828
        0x5829, # G+11414  U+5829  uni5829,  CJK UNIFIED IDEOGRAPH-5829
        0x582B, # G+11415  U+582B  uni582B,  CJK UNIFIED IDEOGRAPH-582B
        0x582C, # G+11416  U+582C  uni582C,  CJK UNIFIED IDEOGRAPH-582C
        0x582D, # G+11417  U+582D  uni582D,  CJK UNIFIED IDEOGRAPH-582D
        0x582E, # G+11418  U+582E  uni582E,  CJK UNIFIED IDEOGRAPH-582E
        0x5832, # G+11419  U+5832  uni5832,  CJK UNIFIED IDEOGRAPH-5832
        0x5833, # G+11420  U+5833  uni5833,  CJK UNIFIED IDEOGRAPH-5833
        0x5836, # G+11421  U+5836  uni5836,  CJK UNIFIED IDEOGRAPH-5836
        0x5837, # G+11422  U+5837  uni5837,  CJK UNIFIED IDEOGRAPH-5837
        0x5838, # G+11423  U+5838  uni5838,  CJK UNIFIED IDEOGRAPH-5838
        0x5839, # G+11424  U+5839  uni5839,  CJK UNIFIED IDEOGRAPH-5839
        0x583A, # G+11425  U+583A  uni583A,  CJK UNIFIED IDEOGRAPH-583A
        0x583B, # G+11426  U+583B  uni583B,  CJK UNIFIED IDEOGRAPH-583B
        0x583C, # G+11427  U+583C  uni583C,  CJK UNIFIED IDEOGRAPH-583C
        0x583D, # G+11428  U+583D  uni583D,  CJK UNIFIED IDEOGRAPH-583D
        0x583E, # G+11429  U+583E  uni583E,  CJK UNIFIED IDEOGRAPH-583E
        0x583F, # G+11430  U+583F  uni583F,  CJK UNIFIED IDEOGRAPH-583F
        0x5840, # G+11431  U+5840  uni5840,  CJK UNIFIED IDEOGRAPH-5840
        0x5841, # G+11432  U+5841  uni5841,  CJK UNIFIED IDEOGRAPH-5841
        0x5842, # G+11433  U+5842  uni5842,  CJK UNIFIED IDEOGRAPH-5842
        0x5843, # G+11434  U+5843  uni5843,  CJK UNIFIED IDEOGRAPH-5843
        0x5845, # G+11435  U+5845  uni5845,  CJK UNIFIED IDEOGRAPH-5845
        0x5846, # G+11436  U+5846  uni5846,  CJK UNIFIED IDEOGRAPH-5846
        0x5847, # G+11437  U+5847  uni5847,  CJK UNIFIED IDEOGRAPH-5847
        0x5848, # G+11438  U+5848  uni5848,  CJK UNIFIED IDEOGRAPH-5848
        0x5849, # G+11439  U+5849  uni5849,  CJK UNIFIED IDEOGRAPH-5849
        0x584E, # G+11440  U+584E  uni584E,  CJK UNIFIED IDEOGRAPH-584E
        0x5850, # G+11441  U+5850  uni5850,  CJK UNIFIED IDEOGRAPH-5850
        0x5853, # G+11442  U+5853  uni5853,  CJK UNIFIED IDEOGRAPH-5853
        0x5855, # G+11443  U+5855  uni5855,  CJK UNIFIED IDEOGRAPH-5855
        0x5856, # G+11444  U+5856  uni5856,  CJK UNIFIED IDEOGRAPH-5856
        0x5859, # G+11445  U+5859  uni5859,  CJK UNIFIED IDEOGRAPH-5859
        0x585A, # G+11446  U+585A  uni585A,  CJK UNIFIED IDEOGRAPH-585A
        0x585B, # G+11447  U+585B  uni585B,  CJK UNIFIED IDEOGRAPH-585B
        0x585C, # G+11448  U+585C  uni585C,  CJK UNIFIED IDEOGRAPH-585C
        0x585D, # G+11449  U+585D  uni585D,  CJK UNIFIED IDEOGRAPH-585D
        0x585F, # G+11450  U+585F  uni585F,  CJK UNIFIED IDEOGRAPH-585F
        0x5860, # G+11451  U+5860  uni5860,  CJK UNIFIED IDEOGRAPH-5860
        0x5861, # G+11452  U+5861  uni5861,  CJK UNIFIED IDEOGRAPH-5861
        0x5863, # G+11453  U+5863  uni5863,  CJK UNIFIED IDEOGRAPH-5863
        0x5866, # G+11454  U+5866  uni5866,  CJK UNIFIED IDEOGRAPH-5866
        0x5867, # G+11455  U+5867  uni5867,  CJK UNIFIED IDEOGRAPH-5867
        0x5868, # G+11456  U+5868  uni5868,  CJK UNIFIED IDEOGRAPH-5868
        0x5869, # G+11457  U+5869  uni5869,  CJK UNIFIED IDEOGRAPH-5869
        0x586A, # G+11458  U+586A  uni586A,  CJK UNIFIED IDEOGRAPH-586A
        0x586D, # G+11459  U+586D  uni586D,  CJK UNIFIED IDEOGRAPH-586D
        0x586E, # G+11460  U+586E  uni586E,  CJK UNIFIED IDEOGRAPH-586E
        0x586F, # G+11461  U+586F  uni586F,  CJK UNIFIED IDEOGRAPH-586F
        0x5870, # G+11462  U+5870  uni5870,  CJK UNIFIED IDEOGRAPH-5870
        0x5871, # G+11463  U+5871  uni5871,  CJK UNIFIED IDEOGRAPH-5871
        0x5872, # G+11464  U+5872  uni5872,  CJK UNIFIED IDEOGRAPH-5872
        0x5873, # G+11465  U+5873  uni5873,  CJK UNIFIED IDEOGRAPH-5873
        0x5874, # G+11466  U+5874  uni5874,  CJK UNIFIED IDEOGRAPH-5874
        0x5876, # G+11467  U+5876  uni5876,  CJK UNIFIED IDEOGRAPH-5876
        0x5877, # G+11468  U+5877  uni5877,  CJK UNIFIED IDEOGRAPH-5877
        0x5878, # G+11469  U+5878  uni5878,  CJK UNIFIED IDEOGRAPH-5878
        0x587A, # G+11470  U+587A  uni587A,  CJK UNIFIED IDEOGRAPH-587A
        0x587B, # G+11471  U+587B  uni587B,  CJK UNIFIED IDEOGRAPH-587B
        0x587C, # G+11472  U+587C  uni587C,  CJK UNIFIED IDEOGRAPH-587C
        0x587D, # G+11473  U+587D  uni587D,  CJK UNIFIED IDEOGRAPH-587D
        0x587F, # G+11474  U+587F  uni587F,  CJK UNIFIED IDEOGRAPH-587F
        0x5882, # G+11475  U+5882  uni5882,  CJK UNIFIED IDEOGRAPH-5882
        0x5884, # G+11476  U+5884  uni5884,  CJK UNIFIED IDEOGRAPH-5884
        0x5886, # G+11477  U+5886  uni5886,  CJK UNIFIED IDEOGRAPH-5886
        0x5887, # G+11478  U+5887  uni5887,  CJK UNIFIED IDEOGRAPH-5887
        0x5888, # G+11479  U+5888  uni5888,  CJK UNIFIED IDEOGRAPH-5888
        0x588B, # G+11480  U+588B  uni588B,  CJK UNIFIED IDEOGRAPH-588B
        0x588C, # G+11481  U+588C  uni588C,  CJK UNIFIED IDEOGRAPH-588C
        0x588D, # G+11482  U+588D  uni588D,  CJK UNIFIED IDEOGRAPH-588D
        0x588E, # G+11483  U+588E  uni588E,  CJK UNIFIED IDEOGRAPH-588E
        0x588F, # G+11484  U+588F  uni588F,  CJK UNIFIED IDEOGRAPH-588F
        0x5890, # G+11485  U+5890  uni5890,  CJK UNIFIED IDEOGRAPH-5890
        0x5891, # G+11486  U+5891  uni5891,  CJK UNIFIED IDEOGRAPH-5891
        0x5894, # G+11487  U+5894  uni5894,  CJK UNIFIED IDEOGRAPH-5894
        0x5895, # G+11488  U+5895  uni5895,  CJK UNIFIED IDEOGRAPH-5895
        0x5896, # G+11489  U+5896  uni5896,  CJK UNIFIED IDEOGRAPH-5896
        0x5897, # G+11490  U+5897  uni5897,  CJK UNIFIED IDEOGRAPH-5897
        0x5898, # G+11491  U+5898  uni5898,  CJK UNIFIED IDEOGRAPH-5898
        0x589B, # G+11492  U+589B  uni589B,  CJK UNIFIED IDEOGRAPH-589B
        0x589D, # G+11493  U+589D  uni589D,  CJK UNIFIED IDEOGRAPH-589D
        0x58A0, # G+11494  U+58A0  uni58A0,  CJK UNIFIED IDEOGRAPH-58A0
        0x58A1, # G+11495  U+58A1  uni58A1,  CJK UNIFIED IDEOGRAPH-58A1
        0x58A2, # G+11496  U+58A2  uni58A2,  CJK UNIFIED IDEOGRAPH-58A2
        0x58A3, # G+11497  U+58A3  uni58A3,  CJK UNIFIED IDEOGRAPH-58A3
        0x58A4, # G+11498  U+58A4  uni58A4,  CJK UNIFIED IDEOGRAPH-58A4
        0x58A5, # G+11499  U+58A5  uni58A5,  CJK UNIFIED IDEOGRAPH-58A5
        0x58A6, # G+11500  U+58A6  uni58A6,  CJK UNIFIED IDEOGRAPH-58A6
        0x58A7, # G+11501  U+58A7  uni58A7,  CJK UNIFIED IDEOGRAPH-58A7
        0x58AA, # G+11502  U+58AA  uni58AA,  CJK UNIFIED IDEOGRAPH-58AA
        0x58AB, # G+11503  U+58AB  uni58AB,  CJK UNIFIED IDEOGRAPH-58AB
        0x58AC, # G+11504  U+58AC  uni58AC,  CJK UNIFIED IDEOGRAPH-58AC
        0x58AD, # G+11505  U+58AD  uni58AD,  CJK UNIFIED IDEOGRAPH-58AD
        0x58AF, # G+11506  U+58AF  uni58AF,  CJK UNIFIED IDEOGRAPH-58AF
        0x58B0, # G+11507  U+58B0  uni58B0,  CJK UNIFIED IDEOGRAPH-58B0
        0x58B1, # G+11508  U+58B1  uni58B1,  CJK UNIFIED IDEOGRAPH-58B1
        0x58B2, # G+11509  U+58B2  uni58B2,  CJK UNIFIED IDEOGRAPH-58B2
        0x58B4, # G+11510  U+58B4  uni58B4,  CJK UNIFIED IDEOGRAPH-58B4
        0x58B5, # G+11511  U+58B5  uni58B5,  CJK UNIFIED IDEOGRAPH-58B5
        0x58B6, # G+11512  U+58B6  uni58B6,  CJK UNIFIED IDEOGRAPH-58B6
        0x58B7, # G+11513  U+58B7  uni58B7,  CJK UNIFIED IDEOGRAPH-58B7
        0x58B8, # G+11514  U+58B8  uni58B8,  CJK UNIFIED IDEOGRAPH-58B8
        0x58B9, # G+11515  U+58B9  uni58B9,  CJK UNIFIED IDEOGRAPH-58B9
        0x58BA, # G+11516  U+58BA  uni58BA,  CJK UNIFIED IDEOGRAPH-58BA
        0x58BD, # G+11517  U+58BD  uni58BD,  CJK UNIFIED IDEOGRAPH-58BD
        0x58BF, # G+11518  U+58BF  uni58BF,  CJK UNIFIED IDEOGRAPH-58BF
        0x58C0, # G+11519  U+58C0  uni58C0,  CJK UNIFIED IDEOGRAPH-58C0
        0x58C2, # G+11520  U+58C2  uni58C2,  CJK UNIFIED IDEOGRAPH-58C2
        0x58C3, # G+11521  U+58C3  uni58C3,  CJK UNIFIED IDEOGRAPH-58C3
        0x58C4, # G+11522  U+58C4  uni58C4,  CJK UNIFIED IDEOGRAPH-58C4
        0x58C6, # G+11523  U+58C6  uni58C6,  CJK UNIFIED IDEOGRAPH-58C6
        0x58C8, # G+11524  U+58C8  uni58C8,  CJK UNIFIED IDEOGRAPH-58C8
        0x58C9, # G+11525  U+58C9  uni58C9,  CJK UNIFIED IDEOGRAPH-58C9
        0x58CA, # G+11526  U+58CA  uni58CA,  CJK UNIFIED IDEOGRAPH-58CA
        0x58CB, # G+11527  U+58CB  uni58CB,  CJK UNIFIED IDEOGRAPH-58CB
        0x58CC, # G+11528  U+58CC  uni58CC,  CJK UNIFIED IDEOGRAPH-58CC
        0x58CD, # G+11529  U+58CD  uni58CD,  CJK UNIFIED IDEOGRAPH-58CD
        0x58CE, # G+11530  U+58CE  uni58CE,  CJK UNIFIED IDEOGRAPH-58CE
        0x58CF, # G+11531  U+58CF  uni58CF,  CJK UNIFIED IDEOGRAPH-58CF
        0x58D0, # G+11532  U+58D0  uni58D0,  CJK UNIFIED IDEOGRAPH-58D0
        0x58D2, # G+11533  U+58D2  uni58D2,  CJK UNIFIED IDEOGRAPH-58D2
        0x58D4, # G+11534  U+58D4  uni58D4,  CJK UNIFIED IDEOGRAPH-58D4
        0x58D6, # G+11535  U+58D6  uni58D6,  CJK UNIFIED IDEOGRAPH-58D6
        0x58D7, # G+11536  U+58D7  uni58D7,  CJK UNIFIED IDEOGRAPH-58D7
        0x58DB, # G+11537  U+58DB  uni58DB,  CJK UNIFIED IDEOGRAPH-58DB
        0x58DC, # G+11538  U+58DC  uni58DC,  CJK UNIFIED IDEOGRAPH-58DC
        0x58DD, # G+11539  U+58DD  uni58DD,  CJK UNIFIED IDEOGRAPH-58DD
        0x58E1, # G+11540  U+58E1  uni58E1,  CJK UNIFIED IDEOGRAPH-58E1
        0x58E3, # G+11541  U+58E3  uni58E3,  CJK UNIFIED IDEOGRAPH-58E3
        0x58E5, # G+11542  U+58E5  uni58E5,  CJK UNIFIED IDEOGRAPH-58E5
        0x58E6, # G+11543  U+58E6  uni58E6,  CJK UNIFIED IDEOGRAPH-58E6
        0x58E7, # G+11544  U+58E7  uni58E7,  CJK UNIFIED IDEOGRAPH-58E7
        0x58E8, # G+11545  U+58E8  uni58E8,  CJK UNIFIED IDEOGRAPH-58E8
        0x58EA, # G+11546  U+58EA  uni58EA,  CJK UNIFIED IDEOGRAPH-58EA
        0x58ED, # G+11547  U+58ED  uni58ED,  CJK UNIFIED IDEOGRAPH-58ED
        0x58F1, # G+11548  U+58F1  uni58F1,  CJK UNIFIED IDEOGRAPH-58F1
        0x58F2, # G+11549  U+58F2  uni58F2,  CJK UNIFIED IDEOGRAPH-58F2
        0x58F4, # G+11550  U+58F4  uni58F4,  CJK UNIFIED IDEOGRAPH-58F4
        0x58F5, # G+11551  U+58F5  uni58F5,  CJK UNIFIED IDEOGRAPH-58F5
        0x58F7, # G+11552  U+58F7  uni58F7,  CJK UNIFIED IDEOGRAPH-58F7
        0x58F8, # G+11553  U+58F8  uni58F8,  CJK UNIFIED IDEOGRAPH-58F8
        0x58FB, # G+11554  U+58FB  uni58FB,  CJK UNIFIED IDEOGRAPH-58FB
        0x58FC, # G+11555  U+58FC  uni58FC,  CJK UNIFIED IDEOGRAPH-58FC
        0x58FE, # G+11556  U+58FE  uni58FE,  CJK UNIFIED IDEOGRAPH-58FE
        0x58FF, # G+11557  U+58FF  uni58FF,  CJK UNIFIED IDEOGRAPH-58FF
        0x5900, # G+11558  U+5900  uni5900,  CJK UNIFIED IDEOGRAPH-5900
        0x5901, # G+11559  U+5901  uni5901,  CJK UNIFIED IDEOGRAPH-5901
        0x5903, # G+11560  U+5903  uni5903,  CJK UNIFIED IDEOGRAPH-5903
        0x5905, # G+11561  U+5905  uni5905,  CJK UNIFIED IDEOGRAPH-5905
        0x5906, # G+11562  U+5906  uni5906,  CJK UNIFIED IDEOGRAPH-5906
        0x5908, # G+11563  U+5908  uni5908,  CJK UNIFIED IDEOGRAPH-5908
        0x5909, # G+11564  U+5909  uni5909,  CJK UNIFIED IDEOGRAPH-5909
        0x2F22, # G+11565  U+2F22  uni2F22,  KANGXI RADICAL GO SLOWLY
        0x590B, # G+11566  U+590B  uni590B,  CJK UNIFIED IDEOGRAPH-590B
        0x590C, # G+11567  U+590C  uni590C,  CJK UNIFIED IDEOGRAPH-590C
        0x590E, # G+11568  U+590E  uni590E,  CJK UNIFIED IDEOGRAPH-590E
        0x5910, # G+11569  U+5910  uni5910,  CJK UNIFIED IDEOGRAPH-5910
        0x5911, # G+11570  U+5911  uni5911,  CJK UNIFIED IDEOGRAPH-5911
        0x5912, # G+11571  U+5912  uni5912,  CJK UNIFIED IDEOGRAPH-5912
        0x5913, # G+11572  U+5913  uni5913,  CJK UNIFIED IDEOGRAPH-5913
        0x5917, # G+11573  U+5917  uni5917,  CJK UNIFIED IDEOGRAPH-5917
        0x5918, # G+11574  U+5918  uni5918,  CJK UNIFIED IDEOGRAPH-5918
        0x591B, # G+11575  U+591B  uni591B,  CJK UNIFIED IDEOGRAPH-591B
        0x591D, # G+11576  U+591D  uni591D,  CJK UNIFIED IDEOGRAPH-591D
        0x591E, # G+11577  U+591E  uni591E,  CJK UNIFIED IDEOGRAPH-591E
        0x5920, # G+11578  U+5920  uni5920,  CJK UNIFIED IDEOGRAPH-5920
        0x5921, # G+11579  U+5921  uni5921,  CJK UNIFIED IDEOGRAPH-5921
        0x5923, # G+11580  U+5923  uni5923,  CJK UNIFIED IDEOGRAPH-5923
        0x5926, # G+11581  U+5926  uni5926,  CJK UNIFIED IDEOGRAPH-5926
        0x5928, # G+11582  U+5928  uni5928,  CJK UNIFIED IDEOGRAPH-5928
        0x592C, # G+11583  U+592C  uni592C,  CJK UNIFIED IDEOGRAPH-592C
        0x5930, # G+11584  U+5930  uni5930,  CJK UNIFIED IDEOGRAPH-5930
        0x5932, # G+11585  U+5932  uni5932,  CJK UNIFIED IDEOGRAPH-5932
        0x5933, # G+11586  U+5933  uni5933,  CJK UNIFIED IDEOGRAPH-5933
        0x5935, # G+11587  U+5935  uni5935,  CJK UNIFIED IDEOGRAPH-5935
        0x5936, # G+11588  U+5936  uni5936,  CJK UNIFIED IDEOGRAPH-5936
        0x593B, # G+11589  U+593B  uni593B,  CJK UNIFIED IDEOGRAPH-593B
        0x593D, # G+11590  U+593D  uni593D,  CJK UNIFIED IDEOGRAPH-593D
        0x593F, # G+11591  U+593F  uni593F,  CJK UNIFIED IDEOGRAPH-593F
        0x5940, # G+11592  U+5940  uni5940,  CJK UNIFIED IDEOGRAPH-5940
        0x5943, # G+11593  U+5943  uni5943,  CJK UNIFIED IDEOGRAPH-5943
        0x5945, # G+11594  U+5945  uni5945,  CJK UNIFIED IDEOGRAPH-5945
        0x5946, # G+11595  U+5946  uni5946,  CJK UNIFIED IDEOGRAPH-5946
        0x594A, # G+11596  U+594A  uni594A,  CJK UNIFIED IDEOGRAPH-594A
        0x594C, # G+11597  U+594C  uni594C,  CJK UNIFIED IDEOGRAPH-594C
        0x594D, # G+11598  U+594D  uni594D,  CJK UNIFIED IDEOGRAPH-594D
        0x5950, # G+11599  U+5950  uni5950,  CJK UNIFIED IDEOGRAPH-5950
        0x5952, # G+11600  U+5952  uni5952,  CJK UNIFIED IDEOGRAPH-5952
        0x5953, # G+11601  U+5953  uni5953,  CJK UNIFIED IDEOGRAPH-5953
        0x5959, # G+11602  U+5959  uni5959,  CJK UNIFIED IDEOGRAPH-5959
        0x595B, # G+11603  U+595B  uni595B,  CJK UNIFIED IDEOGRAPH-595B
        0x595C, # G+11604  U+595C  uni595C,  CJK UNIFIED IDEOGRAPH-595C
        0x595D, # G+11605  U+595D  uni595D,  CJK UNIFIED IDEOGRAPH-595D
        0x595E, # G+11606  U+595E  uni595E,  CJK UNIFIED IDEOGRAPH-595E
        0x595F, # G+11607  U+595F  uni595F,  CJK UNIFIED IDEOGRAPH-595F
        0x5961, # G+11608  U+5961  uni5961,  CJK UNIFIED IDEOGRAPH-5961
        0x5963, # G+11609  U+5963  uni5963,  CJK UNIFIED IDEOGRAPH-5963
        0x5964, # G+11610  U+5964  uni5964,  CJK UNIFIED IDEOGRAPH-5964
        0x5966, # G+11611  U+5966  uni5966,  CJK UNIFIED IDEOGRAPH-5966
        0x5967, # G+11612  U+5967  uni5967,  CJK UNIFIED IDEOGRAPH-5967
        0x5968, # G+11613  U+5968  uni5968,  CJK UNIFIED IDEOGRAPH-5968
        0x596B, # G+11614  U+596B  uni596B,  CJK UNIFIED IDEOGRAPH-596B
        0x596D, # G+11615  U+596D  uni596D,  CJK UNIFIED IDEOGRAPH-596D
        0x596F, # G+11616  U+596F  uni596F,  CJK UNIFIED IDEOGRAPH-596F
        0x5970, # G+11617  U+5970  uni5970,  CJK UNIFIED IDEOGRAPH-5970
        0x5971, # G+11618  U+5971  uni5971,  CJK UNIFIED IDEOGRAPH-5971
        0x5972, # G+11619  U+5972  uni5972,  CJK UNIFIED IDEOGRAPH-5972
        0x5975, # G+11620  U+5975  uni5975,  CJK UNIFIED IDEOGRAPH-5975
        0x5977, # G+11621  U+5977  uni5977,  CJK UNIFIED IDEOGRAPH-5977
        0x597A, # G+11622  U+597A  uni597A,  CJK UNIFIED IDEOGRAPH-597A
        0x597B, # G+11623  U+597B  uni597B,  CJK UNIFIED IDEOGRAPH-597B
        0x597C, # G+11624  U+597C  uni597C,  CJK UNIFIED IDEOGRAPH-597C
        0x597E, # G+11625  U+597E  uni597E,  CJK UNIFIED IDEOGRAPH-597E
        0x597F, # G+11626  U+597F  uni597F,  CJK UNIFIED IDEOGRAPH-597F
        0x5980, # G+11627  U+5980  uni5980,  CJK UNIFIED IDEOGRAPH-5980
        0x5985, # G+11628  U+5985  uni5985,  CJK UNIFIED IDEOGRAPH-5985
        0x5989, # G+11629  U+5989  uni5989,  CJK UNIFIED IDEOGRAPH-5989
        0x598B, # G+11630  U+598B  uni598B,  CJK UNIFIED IDEOGRAPH-598B
        0x598C, # G+11631  U+598C  uni598C,  CJK UNIFIED IDEOGRAPH-598C
        0x598E, # G+11632  U+598E  uni598E,  CJK UNIFIED IDEOGRAPH-598E
        0x598F, # G+11633  U+598F  uni598F,  CJK UNIFIED IDEOGRAPH-598F
        0x5990, # G+11634  U+5990  uni5990,  CJK UNIFIED IDEOGRAPH-5990
        0x5991, # G+11635  U+5991  uni5991,  CJK UNIFIED IDEOGRAPH-5991
        0x5994, # G+11636  U+5994  uni5994,  CJK UNIFIED IDEOGRAPH-5994
        0x5995, # G+11637  U+5995  uni5995,  CJK UNIFIED IDEOGRAPH-5995
        0x5998, # G+11638  U+5998  uni5998,  CJK UNIFIED IDEOGRAPH-5998
        0x599A, # G+11639  U+599A  uni599A,  CJK UNIFIED IDEOGRAPH-599A
        0x599B, # G+11640  U+599B  uni599B,  CJK UNIFIED IDEOGRAPH-599B
        0x599C, # G+11641  U+599C  uni599C,  CJK UNIFIED IDEOGRAPH-599C
        0x599F, # G+11642  U+599F  uni599F,  CJK UNIFIED IDEOGRAPH-599F
        0x59A0, # G+11643  U+59A0  uni59A0,  CJK UNIFIED IDEOGRAPH-59A0
        0x59A1, # G+11644  U+59A1  uni59A1,  CJK UNIFIED IDEOGRAPH-59A1
        0x59A2, # G+11645  U+59A2  uni59A2,  CJK UNIFIED IDEOGRAPH-59A2
        0x59A6, # G+11646  U+59A6  uni59A6,  CJK UNIFIED IDEOGRAPH-59A6
        0x59A7, # G+11647  U+59A7  uni59A7,  CJK UNIFIED IDEOGRAPH-59A7
        0x59AC, # G+11648  U+59AC  uni59AC,  CJK UNIFIED IDEOGRAPH-59AC
        0x59AD, # G+11649  U+59AD  uni59AD,  CJK UNIFIED IDEOGRAPH-59AD
        0x59B0, # G+11650  U+59B0  uni59B0,  CJK UNIFIED IDEOGRAPH-59B0
        0x59B1, # G+11651  U+59B1  uni59B1,  CJK UNIFIED IDEOGRAPH-59B1
        0x59B3, # G+11652  U+59B3  uni59B3,  CJK UNIFIED IDEOGRAPH-59B3
        0x59B4, # G+11653  U+59B4  uni59B4,  CJK UNIFIED IDEOGRAPH-59B4
        0x59B5, # G+11654  U+59B5  uni59B5,  CJK UNIFIED IDEOGRAPH-59B5
        0x59B6, # G+11655  U+59B6  uni59B6,  CJK UNIFIED IDEOGRAPH-59B6
        0x59B7, # G+11656  U+59B7  uni59B7,  CJK UNIFIED IDEOGRAPH-59B7
        0x59B8, # G+11657  U+59B8  uni59B8,  CJK UNIFIED IDEOGRAPH-59B8
        0x59BA, # G+11658  U+59BA  uni59BA,  CJK UNIFIED IDEOGRAPH-59BA
        0x59BC, # G+11659  U+59BC  uni59BC,  CJK UNIFIED IDEOGRAPH-59BC
        0x59BD, # G+11660  U+59BD  uni59BD,  CJK UNIFIED IDEOGRAPH-59BD
        0x59BF, # G+11661  U+59BF  uni59BF,  CJK UNIFIED IDEOGRAPH-59BF
        0x59C0, # G+11662  U+59C0  uni59C0,  CJK UNIFIED IDEOGRAPH-59C0
        0x59C1, # G+11663  U+59C1  uni59C1,  CJK UNIFIED IDEOGRAPH-59C1
        0x59C2, # G+11664  U+59C2  uni59C2,  CJK UNIFIED IDEOGRAPH-59C2
        0x59C3, # G+11665  U+59C3  uni59C3,  CJK UNIFIED IDEOGRAPH-59C3
        0x59C4, # G+11666  U+59C4  uni59C4,  CJK UNIFIED IDEOGRAPH-59C4
        0x59C5, # G+11667  U+59C5  uni59C5,  CJK UNIFIED IDEOGRAPH-59C5
        0x59C7, # G+11668  U+59C7  uni59C7,  CJK UNIFIED IDEOGRAPH-59C7
        0x59C8, # G+11669  U+59C8  uni59C8,  CJK UNIFIED IDEOGRAPH-59C8
        0x59C9, # G+11670  U+59C9  uni59C9,  CJK UNIFIED IDEOGRAPH-59C9
        0x59CC, # G+11671  U+59CC  uni59CC,  CJK UNIFIED IDEOGRAPH-59CC
        0x59CD, # G+11672  U+59CD  uni59CD,  CJK UNIFIED IDEOGRAPH-59CD
        0x59CE, # G+11673  U+59CE  uni59CE,  CJK UNIFIED IDEOGRAPH-59CE
        0x59CF, # G+11674  U+59CF  uni59CF,  CJK UNIFIED IDEOGRAPH-59CF
        0x59D5, # G+11675  U+59D5  uni59D5,  CJK UNIFIED IDEOGRAPH-59D5
        0x59D6, # G+11676  U+59D6  uni59D6,  CJK UNIFIED IDEOGRAPH-59D6
        0x59D9, # G+11677  U+59D9  uni59D9,  CJK UNIFIED IDEOGRAPH-59D9
        0x59DB, # G+11678  U+59DB  uni59DB,  CJK UNIFIED IDEOGRAPH-59DB
        0x59DE, # G+11679  U+59DE  uni59DE,  CJK UNIFIED IDEOGRAPH-59DE
        0x59DF, # G+11680  U+59DF  uni59DF,  CJK UNIFIED IDEOGRAPH-59DF
        0x59E0, # G+11681  U+59E0  uni59E0,  CJK UNIFIED IDEOGRAPH-59E0
        0x59E1, # G+11682  U+59E1  uni59E1,  CJK UNIFIED IDEOGRAPH-59E1
        0x59E2, # G+11683  U+59E2  uni59E2,  CJK UNIFIED IDEOGRAPH-59E2
        0x59E4, # G+11684  U+59E4  uni59E4,  CJK UNIFIED IDEOGRAPH-59E4
        0x59E6, # G+11685  U+59E6  uni59E6,  CJK UNIFIED IDEOGRAPH-59E6
        0x59E7, # G+11686  U+59E7  uni59E7,  CJK UNIFIED IDEOGRAPH-59E7
        0x59E9, # G+11687  U+59E9  uni59E9,  CJK UNIFIED IDEOGRAPH-59E9
        0x59EA, # G+11688  U+59EA  uni59EA,  CJK UNIFIED IDEOGRAPH-59EA
        0x59EB, # G+11689  U+59EB  uni59EB,  CJK UNIFIED IDEOGRAPH-59EB
        0x59ED, # G+11690  U+59ED  uni59ED,  CJK UNIFIED IDEOGRAPH-59ED
        0x59EE, # G+11691  U+59EE  uni59EE,  CJK UNIFIED IDEOGRAPH-59EE
        0x59EF, # G+11692  U+59EF  uni59EF,  CJK UNIFIED IDEOGRAPH-59EF
        0x59F0, # G+11693  U+59F0  uni59F0,  CJK UNIFIED IDEOGRAPH-59F0
        0x59F1, # G+11694  U+59F1  uni59F1,  CJK UNIFIED IDEOGRAPH-59F1
        0x59F2, # G+11695  U+59F2  uni59F2,  CJK UNIFIED IDEOGRAPH-59F2
        0x59F3, # G+11696  U+59F3  uni59F3,  CJK UNIFIED IDEOGRAPH-59F3
        0x59F4, # G+11697  U+59F4  uni59F4,  CJK UNIFIED IDEOGRAPH-59F4
        0x59F5, # G+11698  U+59F5  uni59F5,  CJK UNIFIED IDEOGRAPH-59F5
        0x59F6, # G+11699  U+59F6  uni59F6,  CJK UNIFIED IDEOGRAPH-59F6
        0x59F7, # G+11700  U+59F7  uni59F7,  CJK UNIFIED IDEOGRAPH-59F7
        0x59F8, # G+11701  U+59F8  uni59F8,  CJK UNIFIED IDEOGRAPH-59F8
        0x59FA, # G+11702  U+59FA  uni59FA,  CJK UNIFIED IDEOGRAPH-59FA
        0x59FC, # G+11703  U+59FC  uni59FC,  CJK UNIFIED IDEOGRAPH-59FC
        0x59FD, # G+11704  U+59FD  uni59FD,  CJK UNIFIED IDEOGRAPH-59FD
        0x59FE, # G+11705  U+59FE  uni59FE,  CJK UNIFIED IDEOGRAPH-59FE
        0x5A00, # G+11706  U+5A00  uni5A00,  CJK UNIFIED IDEOGRAPH-5A00
        0x5A02, # G+11707  U+5A02  uni5A02,  CJK UNIFIED IDEOGRAPH-5A02
        0x5A0A, # G+11708  U+5A0A  uni5A0A,  CJK UNIFIED IDEOGRAPH-5A0A
        0x5A0B, # G+11709  U+5A0B  uni5A0B,  CJK UNIFIED IDEOGRAPH-5A0B
        0x5A0D, # G+11710  U+5A0D  uni5A0D,  CJK UNIFIED IDEOGRAPH-5A0D
        0x5A0E, # G+11711  U+5A0E  uni5A0E,  CJK UNIFIED IDEOGRAPH-5A0E
        0x5A0F, # G+11712  U+5A0F  uni5A0F,  CJK UNIFIED IDEOGRAPH-5A0F
        0x5A10, # G+11713  U+5A10  uni5A10,  CJK UNIFIED IDEOGRAPH-5A10
        0x5A12, # G+11714  U+5A12  uni5A12,  CJK UNIFIED IDEOGRAPH-5A12
        0x5A14, # G+11715  U+5A14  uni5A14,  CJK UNIFIED IDEOGRAPH-5A14
        0x5A15, # G+11716  U+5A15  uni5A15,  CJK UNIFIED IDEOGRAPH-5A15
        0x5A16, # G+11717  U+5A16  uni5A16,  CJK UNIFIED IDEOGRAPH-5A16
        0x5A17, # G+11718  U+5A17  uni5A17,  CJK UNIFIED IDEOGRAPH-5A17
        0x5A19, # G+11719  U+5A19  uni5A19,  CJK UNIFIED IDEOGRAPH-5A19
        0x5A1A, # G+11720  U+5A1A  uni5A1A,  CJK UNIFIED IDEOGRAPH-5A1A
        0x5A1B, # G+11721  U+5A1B  uni5A1B,  CJK UNIFIED IDEOGRAPH-5A1B
        0x5A1D, # G+11722  U+5A1D  uni5A1D,  CJK UNIFIED IDEOGRAPH-5A1D
        0x5A1E, # G+11723  U+5A1E  uni5A1E,  CJK UNIFIED IDEOGRAPH-5A1E
        0x5A21, # G+11724  U+5A21  uni5A21,  CJK UNIFIED IDEOGRAPH-5A21
        0x5A22, # G+11725  U+5A22  uni5A22,  CJK UNIFIED IDEOGRAPH-5A22
        0x5A24, # G+11726  U+5A24  uni5A24,  CJK UNIFIED IDEOGRAPH-5A24
        0x5A26, # G+11727  U+5A26  uni5A26,  CJK UNIFIED IDEOGRAPH-5A26
        0x5A27, # G+11728  U+5A27  uni5A27,  CJK UNIFIED IDEOGRAPH-5A27
        0x5A28, # G+11729  U+5A28  uni5A28,  CJK UNIFIED IDEOGRAPH-5A28
        0x5A2A, # G+11730  U+5A2A  uni5A2A,  CJK UNIFIED IDEOGRAPH-5A2A
        0x5A2B, # G+11731  U+5A2B  uni5A2B,  CJK UNIFIED IDEOGRAPH-5A2B
        0x5A2C, # G+11732  U+5A2C  uni5A2C,  CJK UNIFIED IDEOGRAPH-5A2C
        0x5A2D, # G+11733  U+5A2D  uni5A2D,  CJK UNIFIED IDEOGRAPH-5A2D
        0x5A2E, # G+11734  U+5A2E  uni5A2E,  CJK UNIFIED IDEOGRAPH-5A2E
        0x5A2F, # G+11735  U+5A2F  uni5A2F,  CJK UNIFIED IDEOGRAPH-5A2F
        0x5A30, # G+11736  U+5A30  uni5A30,  CJK UNIFIED IDEOGRAPH-5A30
        0x5A33, # G+11737  U+5A33  uni5A33,  CJK UNIFIED IDEOGRAPH-5A33
        0x5A35, # G+11738  U+5A35  uni5A35,  CJK UNIFIED IDEOGRAPH-5A35
        0x5A37, # G+11739  U+5A37  uni5A37,  CJK UNIFIED IDEOGRAPH-5A37
        0x5A38, # G+11740  U+5A38  uni5A38,  CJK UNIFIED IDEOGRAPH-5A38
        0x5A39, # G+11741  U+5A39  uni5A39,  CJK UNIFIED IDEOGRAPH-5A39
        0x5A3A, # G+11742  U+5A3A  uni5A3A,  CJK UNIFIED IDEOGRAPH-5A3A
        0x5A3B, # G+11743  U+5A3B  uni5A3B,  CJK UNIFIED IDEOGRAPH-5A3B
        0x5A3D, # G+11744  U+5A3D  uni5A3D,  CJK UNIFIED IDEOGRAPH-5A3D
        0x5A3E, # G+11745  U+5A3E  uni5A3E,  CJK UNIFIED IDEOGRAPH-5A3E
        0x5A3F, # G+11746  U+5A3F  uni5A3F,  CJK UNIFIED IDEOGRAPH-5A3F
        0x5A42, # G+11747  U+5A42  uni5A42,  CJK UNIFIED IDEOGRAPH-5A42
        0x5A43, # G+11748  U+5A43  uni5A43,  CJK UNIFIED IDEOGRAPH-5A43
        0x5A44, # G+11749  U+5A44  uni5A44,  CJK UNIFIED IDEOGRAPH-5A44
        0x5A45, # G+11750  U+5A45  uni5A45,  CJK UNIFIED IDEOGRAPH-5A45
        0x5A47, # G+11751  U+5A47  uni5A47,  CJK UNIFIED IDEOGRAPH-5A47
        0x5A48, # G+11752  U+5A48  uni5A48,  CJK UNIFIED IDEOGRAPH-5A48
        0x5A4B, # G+11753  U+5A4B  uni5A4B,  CJK UNIFIED IDEOGRAPH-5A4B
        0x5A4C, # G+11754  U+5A4C  uni5A4C,  CJK UNIFIED IDEOGRAPH-5A4C
        0x5A4D, # G+11755  U+5A4D  uni5A4D,  CJK UNIFIED IDEOGRAPH-5A4D
        0x5A4E, # G+11756  U+5A4E  uni5A4E,  CJK UNIFIED IDEOGRAPH-5A4E
        0x5A4F, # G+11757  U+5A4F  uni5A4F,  CJK UNIFIED IDEOGRAPH-5A4F
        0x5A50, # G+11758  U+5A50  uni5A50,  CJK UNIFIED IDEOGRAPH-5A50
        0x5A51, # G+11759  U+5A51  uni5A51,  CJK UNIFIED IDEOGRAPH-5A51
        0x5A52, # G+11760  U+5A52  uni5A52,  CJK UNIFIED IDEOGRAPH-5A52
        0x5A53, # G+11761  U+5A53  uni5A53,  CJK UNIFIED IDEOGRAPH-5A53
        0x5A54, # G+11762  U+5A54  uni5A54,  CJK UNIFIED IDEOGRAPH-5A54
        0x5A56, # G+11763  U+5A56  uni5A56,  CJK UNIFIED IDEOGRAPH-5A56
        0x5A57, # G+11764  U+5A57  uni5A57,  CJK UNIFIED IDEOGRAPH-5A57
        0x5A58, # G+11765  U+5A58  uni5A58,  CJK UNIFIED IDEOGRAPH-5A58
        0x5A59, # G+11766  U+5A59  uni5A59,  CJK UNIFIED IDEOGRAPH-5A59
        0x5A5B, # G+11767  U+5A5B  uni5A5B,  CJK UNIFIED IDEOGRAPH-5A5B
        0x5A5C, # G+11768  U+5A5C  uni5A5C,  CJK UNIFIED IDEOGRAPH-5A5C
        0x5A5D, # G+11769  U+5A5D  uni5A5D,  CJK UNIFIED IDEOGRAPH-5A5D
        0x5A5E, # G+11770  U+5A5E  uni5A5E,  CJK UNIFIED IDEOGRAPH-5A5E
        0x5A5F, # G+11771  U+5A5F  uni5A5F,  CJK UNIFIED IDEOGRAPH-5A5F
        0x5A60, # G+11772  U+5A60  uni5A60,  CJK UNIFIED IDEOGRAPH-5A60
        0x5A61, # G+11773  U+5A61  uni5A61,  CJK UNIFIED IDEOGRAPH-5A61
        0x5A63, # G+11774  U+5A63  uni5A63,  CJK UNIFIED IDEOGRAPH-5A63
        0x5A64, # G+11775  U+5A64  uni5A64,  CJK UNIFIED IDEOGRAPH-5A64
        0x5A65, # G+11776  U+5A65  uni5A65,  CJK UNIFIED IDEOGRAPH-5A65
        0x5A68, # G+11777  U+5A68  uni5A68,  CJK UNIFIED IDEOGRAPH-5A68
        0x5A69, # G+11778  U+5A69  uni5A69,  CJK UNIFIED IDEOGRAPH-5A69
        0x5A6B, # G+11779  U+5A6B  uni5A6B,  CJK UNIFIED IDEOGRAPH-5A6B
        0x5A6C, # G+11780  U+5A6C  uni5A6C,  CJK UNIFIED IDEOGRAPH-5A6C
        0x5A6E, # G+11781  U+5A6E  uni5A6E,  CJK UNIFIED IDEOGRAPH-5A6E
        0x5A6F, # G+11782  U+5A6F  uni5A6F,  CJK UNIFIED IDEOGRAPH-5A6F
        0x5A70, # G+11783  U+5A70  uni5A70,  CJK UNIFIED IDEOGRAPH-5A70
        0x5A71, # G+11784  U+5A71  uni5A71,  CJK UNIFIED IDEOGRAPH-5A71
        0x5A72, # G+11785  U+5A72  uni5A72,  CJK UNIFIED IDEOGRAPH-5A72
        0x5A73, # G+11786  U+5A73  uni5A73,  CJK UNIFIED IDEOGRAPH-5A73
        0x5A78, # G+11787  U+5A78  uni5A78,  CJK UNIFIED IDEOGRAPH-5A78
        0x5A79, # G+11788  U+5A79  uni5A79,  CJK UNIFIED IDEOGRAPH-5A79
        0x5A7B, # G+11789  U+5A7B  uni5A7B,  CJK UNIFIED IDEOGRAPH-5A7B
        0x5A7C, # G+11790  U+5A7C  uni5A7C,  CJK UNIFIED IDEOGRAPH-5A7C
        0x5A7D, # G+11791  U+5A7D  uni5A7D,  CJK UNIFIED IDEOGRAPH-5A7D
        0x5A7E, # G+11792  U+5A7E  uni5A7E,  CJK UNIFIED IDEOGRAPH-5A7E
        0x5A80, # G+11793  U+5A80  uni5A80,  CJK UNIFIED IDEOGRAPH-5A80
        0x5A81, # G+11794  U+5A81  uni5A81,  CJK UNIFIED IDEOGRAPH-5A81
        0x5A82, # G+11795  U+5A82  uni5A82,  CJK UNIFIED IDEOGRAPH-5A82
        0x5A83, # G+11796  U+5A83  uni5A83,  CJK UNIFIED IDEOGRAPH-5A83
        0x5A84, # G+11797  U+5A84  uni5A84,  CJK UNIFIED IDEOGRAPH-5A84
        0x5A85, # G+11798  U+5A85  uni5A85,  CJK UNIFIED IDEOGRAPH-5A85
        0x5A86, # G+11799  U+5A86  uni5A86,  CJK UNIFIED IDEOGRAPH-5A86
        0x5A87, # G+11800  U+5A87  uni5A87,  CJK UNIFIED IDEOGRAPH-5A87
        0x5A88, # G+11801  U+5A88  uni5A88,  CJK UNIFIED IDEOGRAPH-5A88
        0x5A89, # G+11802  U+5A89  uni5A89,  CJK UNIFIED IDEOGRAPH-5A89
        0x5A8A, # G+11803  U+5A8A  uni5A8A,  CJK UNIFIED IDEOGRAPH-5A8A
        0x5A8B, # G+11804  U+5A8B  uni5A8B,  CJK UNIFIED IDEOGRAPH-5A8B
        0x5A8C, # G+11805  U+5A8C  uni5A8C,  CJK UNIFIED IDEOGRAPH-5A8C
        0x5A8D, # G+11806  U+5A8D  uni5A8D,  CJK UNIFIED IDEOGRAPH-5A8D
        0x5A8E, # G+11807  U+5A8E  uni5A8E,  CJK UNIFIED IDEOGRAPH-5A8E
        0x5A8F, # G+11808  U+5A8F  uni5A8F,  CJK UNIFIED IDEOGRAPH-5A8F
        0x5A90, # G+11809  U+5A90  uni5A90,  CJK UNIFIED IDEOGRAPH-5A90
        0x5A91, # G+11810  U+5A91  uni5A91,  CJK UNIFIED IDEOGRAPH-5A91
        0x5A93, # G+11811  U+5A93  uni5A93,  CJK UNIFIED IDEOGRAPH-5A93
        0x5A94, # G+11812  U+5A94  uni5A94,  CJK UNIFIED IDEOGRAPH-5A94
        0x5A95, # G+11813  U+5A95  uni5A95,  CJK UNIFIED IDEOGRAPH-5A95
        0x5A96, # G+11814  U+5A96  uni5A96,  CJK UNIFIED IDEOGRAPH-5A96
        0x5A97, # G+11815  U+5A97  uni5A97,  CJK UNIFIED IDEOGRAPH-5A97
        0x5A98, # G+11816  U+5A98  uni5A98,  CJK UNIFIED IDEOGRAPH-5A98
        0x5A99, # G+11817  U+5A99  uni5A99,  CJK UNIFIED IDEOGRAPH-5A99
        0x5A9C, # G+11818  U+5A9C  uni5A9C,  CJK UNIFIED IDEOGRAPH-5A9C
        0x5A9D, # G+11819  U+5A9D  uni5A9D,  CJK UNIFIED IDEOGRAPH-5A9D
        0x5A9E, # G+11820  U+5A9E  uni5A9E,  CJK UNIFIED IDEOGRAPH-5A9E
        0x5A9F, # G+11821  U+5A9F  uni5A9F,  CJK UNIFIED IDEOGRAPH-5A9F
        0x5AA0, # G+11822  U+5AA0  uni5AA0,  CJK UNIFIED IDEOGRAPH-5AA0
        0x5AA1, # G+11823  U+5AA1  uni5AA1,  CJK UNIFIED IDEOGRAPH-5AA1
        0x5AA2, # G+11824  U+5AA2  uni5AA2,  CJK UNIFIED IDEOGRAPH-5AA2
        0x5AA3, # G+11825  U+5AA3  uni5AA3,  CJK UNIFIED IDEOGRAPH-5AA3
        0x5AA4, # G+11826  U+5AA4  uni5AA4,  CJK UNIFIED IDEOGRAPH-5AA4
        0x5AA5, # G+11827  U+5AA5  uni5AA5,  CJK UNIFIED IDEOGRAPH-5AA5
        0x5AA6, # G+11828  U+5AA6  uni5AA6,  CJK UNIFIED IDEOGRAPH-5AA6
        0x5AA8, # G+11829  U+5AA8  uni5AA8,  CJK UNIFIED IDEOGRAPH-5AA8
        0x5AA9, # G+11830  U+5AA9  uni5AA9,  CJK UNIFIED IDEOGRAPH-5AA9
        0x5AAB, # G+11831  U+5AAB  uni5AAB,  CJK UNIFIED IDEOGRAPH-5AAB
        0x5AAC, # G+11832  U+5AAC  uni5AAC,  CJK UNIFIED IDEOGRAPH-5AAC
        0x5AAD, # G+11833  U+5AAD  uni5AAD,  CJK UNIFIED IDEOGRAPH-5AAD
        0x5AAE, # G+11834  U+5AAE  uni5AAE,  CJK UNIFIED IDEOGRAPH-5AAE
        0x5AAF, # G+11835  U+5AAF  uni5AAF,  CJK UNIFIED IDEOGRAPH-5AAF
        0x5AB0, # G+11836  U+5AB0  uni5AB0,  CJK UNIFIED IDEOGRAPH-5AB0
        0x5AB1, # G+11837  U+5AB1  uni5AB1,  CJK UNIFIED IDEOGRAPH-5AB1
        0x5AB4, # G+11838  U+5AB4  uni5AB4,  CJK UNIFIED IDEOGRAPH-5AB4
        0x5AB6, # G+11839  U+5AB6  uni5AB6,  CJK UNIFIED IDEOGRAPH-5AB6
        0x5AB7, # G+11840  U+5AB7  uni5AB7,  CJK UNIFIED IDEOGRAPH-5AB7
        0x5AB9, # G+11841  U+5AB9  uni5AB9,  CJK UNIFIED IDEOGRAPH-5AB9
        0x5ABA, # G+11842  U+5ABA  uni5ABA,  CJK UNIFIED IDEOGRAPH-5ABA
        0x5ABB, # G+11843  U+5ABB  uni5ABB,  CJK UNIFIED IDEOGRAPH-5ABB
        0x5ABC, # G+11844  U+5ABC  uni5ABC,  CJK UNIFIED IDEOGRAPH-5ABC
        0x5ABF, # G+11845  U+5ABF  uni5ABF,  CJK UNIFIED IDEOGRAPH-5ABF
        0x5AC0, # G+11846  U+5AC0  uni5AC0,  CJK UNIFIED IDEOGRAPH-5AC0
        0x5AC3, # G+11847  U+5AC3  uni5AC3,  CJK UNIFIED IDEOGRAPH-5AC3
        0x5AC4, # G+11848  U+5AC4  uni5AC4,  CJK UNIFIED IDEOGRAPH-5AC4
        0x5AC5, # G+11849  U+5AC5  uni5AC5,  CJK UNIFIED IDEOGRAPH-5AC5
        0x5AC6, # G+11850  U+5AC6  uni5AC6,  CJK UNIFIED IDEOGRAPH-5AC6
        0x5AC7, # G+11851  U+5AC7  uni5AC7,  CJK UNIFIED IDEOGRAPH-5AC7
        0x5AC8, # G+11852  U+5AC8  uni5AC8,  CJK UNIFIED IDEOGRAPH-5AC8
        0x5ACA, # G+11853  U+5ACA  uni5ACA,  CJK UNIFIED IDEOGRAPH-5ACA
        0x5ACB, # G+11854  U+5ACB  uni5ACB,  CJK UNIFIED IDEOGRAPH-5ACB
        0x5ACD, # G+11855  U+5ACD  uni5ACD,  CJK UNIFIED IDEOGRAPH-5ACD
        0x5ACE, # G+11856  U+5ACE  uni5ACE,  CJK UNIFIED IDEOGRAPH-5ACE
        0x5ACF, # G+11857  U+5ACF  uni5ACF,  CJK UNIFIED IDEOGRAPH-5ACF
        0x5AD0, # G+11858  U+5AD0  uni5AD0,  CJK UNIFIED IDEOGRAPH-5AD0
        0x5AD1, # G+11859  U+5AD1  uni5AD1,  CJK UNIFIED IDEOGRAPH-5AD1
        0x5AD3, # G+11860  U+5AD3  uni5AD3,  CJK UNIFIED IDEOGRAPH-5AD3
        0x5AD5, # G+11861  U+5AD5  uni5AD5,  CJK UNIFIED IDEOGRAPH-5AD5
        0x5AD9, # G+11862  U+5AD9  uni5AD9,  CJK UNIFIED IDEOGRAPH-5AD9
        0x5ADA, # G+11863  U+5ADA  uni5ADA,  CJK UNIFIED IDEOGRAPH-5ADA
        0x5ADB, # G+11864  U+5ADB  uni5ADB,  CJK UNIFIED IDEOGRAPH-5ADB
        0x5ADD, # G+11865  U+5ADD  uni5ADD,  CJK UNIFIED IDEOGRAPH-5ADD
        0x5ADE, # G+11866  U+5ADE  uni5ADE,  CJK UNIFIED IDEOGRAPH-5ADE
        0x5ADF, # G+11867  U+5ADF  uni5ADF,  CJK UNIFIED IDEOGRAPH-5ADF
        0x5AE2, # G+11868  U+5AE2  uni5AE2,  CJK UNIFIED IDEOGRAPH-5AE2
        0x5AE4, # G+11869  U+5AE4  uni5AE4,  CJK UNIFIED IDEOGRAPH-5AE4
        0x5AE5, # G+11870  U+5AE5  uni5AE5,  CJK UNIFIED IDEOGRAPH-5AE5
        0x5AE7, # G+11871  U+5AE7  uni5AE7,  CJK UNIFIED IDEOGRAPH-5AE7
        0x5AE8, # G+11872  U+5AE8  uni5AE8,  CJK UNIFIED IDEOGRAPH-5AE8
        0x5AEA, # G+11873  U+5AEA  uni5AEA,  CJK UNIFIED IDEOGRAPH-5AEA
        0x5AEC, # G+11874  U+5AEC  uni5AEC,  CJK UNIFIED IDEOGRAPH-5AEC
        0x5AED, # G+11875  U+5AED  uni5AED,  CJK UNIFIED IDEOGRAPH-5AED
        0x5AEE, # G+11876  U+5AEE  uni5AEE,  CJK UNIFIED IDEOGRAPH-5AEE
        0x5AEF, # G+11877  U+5AEF  uni5AEF,  CJK UNIFIED IDEOGRAPH-5AEF
        0x5AF0, # G+11878  U+5AF0  uni5AF0,  CJK UNIFIED IDEOGRAPH-5AF0
        0x5AF2, # G+11879  U+5AF2  uni5AF2,  CJK UNIFIED IDEOGRAPH-5AF2
        0x5AF3, # G+11880  U+5AF3  uni5AF3,  CJK UNIFIED IDEOGRAPH-5AF3
        0x5AF4, # G+11881  U+5AF4  uni5AF4,  CJK UNIFIED IDEOGRAPH-5AF4
        0x5AF6, # G+11882  U+5AF6  uni5AF6,  CJK UNIFIED IDEOGRAPH-5AF6
        0x5AF7, # G+11883  U+5AF7  uni5AF7,  CJK UNIFIED IDEOGRAPH-5AF7
        0x5AF8, # G+11884  U+5AF8  uni5AF8,  CJK UNIFIED IDEOGRAPH-5AF8
        0x5AF9, # G+11885  U+5AF9  uni5AF9,  CJK UNIFIED IDEOGRAPH-5AF9
        0x5AFA, # G+11886  U+5AFA  uni5AFA,  CJK UNIFIED IDEOGRAPH-5AFA
        0x5AFC, # G+11887  U+5AFC  uni5AFC,  CJK UNIFIED IDEOGRAPH-5AFC
        0x5AFD, # G+11888  U+5AFD  uni5AFD,  CJK UNIFIED IDEOGRAPH-5AFD
        0x5AFE, # G+11889  U+5AFE  uni5AFE,  CJK UNIFIED IDEOGRAPH-5AFE
        0x5AFF, # G+11890  U+5AFF  uni5AFF,  CJK UNIFIED IDEOGRAPH-5AFF
        0x5B01, # G+11891  U+5B01  uni5B01,  CJK UNIFIED IDEOGRAPH-5B01
        0x5B02, # G+11892  U+5B02  uni5B02,  CJK UNIFIED IDEOGRAPH-5B02
        0x5B03, # G+11893  U+5B03  uni5B03,  CJK UNIFIED IDEOGRAPH-5B03
        0x5B04, # G+11894  U+5B04  uni5B04,  CJK UNIFIED IDEOGRAPH-5B04
        0x5B05, # G+11895  U+5B05  uni5B05,  CJK UNIFIED IDEOGRAPH-5B05
        0x5B06, # G+11896  U+5B06  uni5B06,  CJK UNIFIED IDEOGRAPH-5B06
        0x5B07, # G+11897  U+5B07  uni5B07,  CJK UNIFIED IDEOGRAPH-5B07
        0x5B0A, # G+11898  U+5B0A  uni5B0A,  CJK UNIFIED IDEOGRAPH-5B0A
        0x5B0D, # G+11899  U+5B0D  uni5B0D,  CJK UNIFIED IDEOGRAPH-5B0D
        0x5B0E, # G+11900  U+5B0E  uni5B0E,  CJK UNIFIED IDEOGRAPH-5B0E
        0x5B0F, # G+11901  U+5B0F  uni5B0F,  CJK UNIFIED IDEOGRAPH-5B0F
        0x5B10, # G+11902  U+5B10  uni5B10,  CJK UNIFIED IDEOGRAPH-5B10
        0x5B11, # G+11903  U+5B11  uni5B11,  CJK UNIFIED IDEOGRAPH-5B11
        0x5B12, # G+11904  U+5B12  uni5B12,  CJK UNIFIED IDEOGRAPH-5B12
        0x5B13, # G+11905  U+5B13  uni5B13,  CJK UNIFIED IDEOGRAPH-5B13
        0x5B14, # G+11906  U+5B14  uni5B14,  CJK UNIFIED IDEOGRAPH-5B14
        0x5B15, # G+11907  U+5B15  uni5B15,  CJK UNIFIED IDEOGRAPH-5B15
        0x5B18, # G+11908  U+5B18  uni5B18,  CJK UNIFIED IDEOGRAPH-5B18
        0x5B1A, # G+11909  U+5B1A  uni5B1A,  CJK UNIFIED IDEOGRAPH-5B1A
        0x5B1B, # G+11910  U+5B1B  uni5B1B,  CJK UNIFIED IDEOGRAPH-5B1B
        0x5B1C, # G+11911  U+5B1C  uni5B1C,  CJK UNIFIED IDEOGRAPH-5B1C
        0x5B1D, # G+11912  U+5B1D  uni5B1D,  CJK UNIFIED IDEOGRAPH-5B1D
        0x5B1E, # G+11913  U+5B1E  uni5B1E,  CJK UNIFIED IDEOGRAPH-5B1E
        0x5B1F, # G+11914  U+5B1F  uni5B1F,  CJK UNIFIED IDEOGRAPH-5B1F
        0x5B20, # G+11915  U+5B20  uni5B20,  CJK UNIFIED IDEOGRAPH-5B20
        0x5B22, # G+11916  U+5B22  uni5B22,  CJK UNIFIED IDEOGRAPH-5B22
        0x5B23, # G+11917  U+5B23  uni5B23,  CJK UNIFIED IDEOGRAPH-5B23
        0x5B24, # G+11918  U+5B24  uni5B24,  CJK UNIFIED IDEOGRAPH-5B24
        0x5B25, # G+11919  U+5B25  uni5B25,  CJK UNIFIED IDEOGRAPH-5B25
        0x5B26, # G+11920  U+5B26  uni5B26,  CJK UNIFIED IDEOGRAPH-5B26
        0x5B27, # G+11921  U+5B27  uni5B27,  CJK UNIFIED IDEOGRAPH-5B27
        0x5B28, # G+11922  U+5B28  uni5B28,  CJK UNIFIED IDEOGRAPH-5B28
        0x5B29, # G+11923  U+5B29  uni5B29,  CJK UNIFIED IDEOGRAPH-5B29
        0x5B2B, # G+11924  U+5B2B  uni5B2B,  CJK UNIFIED IDEOGRAPH-5B2B
        0x5B2C, # G+11925  U+5B2C  uni5B2C,  CJK UNIFIED IDEOGRAPH-5B2C
        0x5B2D, # G+11926  U+5B2D  uni5B2D,  CJK UNIFIED IDEOGRAPH-5B2D
        0x5B2E, # G+11927  U+5B2E  uni5B2E,  CJK UNIFIED IDEOGRAPH-5B2E
        0x5B2F, # G+11928  U+5B2F  uni5B2F,  CJK UNIFIED IDEOGRAPH-5B2F
        0x5B31, # G+11929  U+5B31  uni5B31,  CJK UNIFIED IDEOGRAPH-5B31
        0x5B33, # G+11930  U+5B33  uni5B33,  CJK UNIFIED IDEOGRAPH-5B33
        0x5B35, # G+11931  U+5B35  uni5B35,  CJK UNIFIED IDEOGRAPH-5B35
        0x5B36, # G+11932  U+5B36  uni5B36,  CJK UNIFIED IDEOGRAPH-5B36
        0x5B39, # G+11933  U+5B39  uni5B39,  CJK UNIFIED IDEOGRAPH-5B39
        0x5B3A, # G+11934  U+5B3A  uni5B3A,  CJK UNIFIED IDEOGRAPH-5B3A
        0x5B3B, # G+11935  U+5B3B  uni5B3B,  CJK UNIFIED IDEOGRAPH-5B3B
        0x5B3C, # G+11936  U+5B3C  uni5B3C,  CJK UNIFIED IDEOGRAPH-5B3C
        0x5B3D, # G+11937  U+5B3D  uni5B3D,  CJK UNIFIED IDEOGRAPH-5B3D
        0x5B3E, # G+11938  U+5B3E  uni5B3E,  CJK UNIFIED IDEOGRAPH-5B3E
        0x5B3F, # G+11939  U+5B3F  uni5B3F,  CJK UNIFIED IDEOGRAPH-5B3F
        0x5B41, # G+11940  U+5B41  uni5B41,  CJK UNIFIED IDEOGRAPH-5B41
        0x5B42, # G+11941  U+5B42  uni5B42,  CJK UNIFIED IDEOGRAPH-5B42
        0x5B43, # G+11942  U+5B43  uni5B43,  CJK UNIFIED IDEOGRAPH-5B43
        0x5B44, # G+11943  U+5B44  uni5B44,  CJK UNIFIED IDEOGRAPH-5B44
        0x5B45, # G+11944  U+5B45  uni5B45,  CJK UNIFIED IDEOGRAPH-5B45
        0x5B46, # G+11945  U+5B46  uni5B46,  CJK UNIFIED IDEOGRAPH-5B46
        0x5B47, # G+11946  U+5B47  uni5B47,  CJK UNIFIED IDEOGRAPH-5B47
        0x5B48, # G+11947  U+5B48  uni5B48,  CJK UNIFIED IDEOGRAPH-5B48
        0x5B49, # G+11948  U+5B49  uni5B49,  CJK UNIFIED IDEOGRAPH-5B49
        0x5B4A, # G+11949  U+5B4A  uni5B4A,  CJK UNIFIED IDEOGRAPH-5B4A
        0x5B4B, # G+11950  U+5B4B  uni5B4B,  CJK UNIFIED IDEOGRAPH-5B4B
        0x5B4D, # G+11951  U+5B4D  uni5B4D,  CJK UNIFIED IDEOGRAPH-5B4D
        0x5B4E, # G+11952  U+5B4E  uni5B4E,  CJK UNIFIED IDEOGRAPH-5B4E
        0x5B4F, # G+11953  U+5B4F  uni5B4F,  CJK UNIFIED IDEOGRAPH-5B4F
        0x5B52, # G+11954  U+5B52  uni5B52,  CJK UNIFIED IDEOGRAPH-5B52
        0x5B56, # G+11955  U+5B56  uni5B56,  CJK UNIFIED IDEOGRAPH-5B56
        0x5B5E, # G+11956  U+5B5E  uni5B5E,  CJK UNIFIED IDEOGRAPH-5B5E
        0x5B60, # G+11957  U+5B60  uni5B60,  CJK UNIFIED IDEOGRAPH-5B60
        0x5B61, # G+11958  U+5B61  uni5B61,  CJK UNIFIED IDEOGRAPH-5B61
        0x5B67, # G+11959  U+5B67  uni5B67,  CJK UNIFIED IDEOGRAPH-5B67
        0x5B68, # G+11960  U+5B68  uni5B68,  CJK UNIFIED IDEOGRAPH-5B68
        0x5B6D, # G+11961  U+5B6D  uni5B6D,  CJK UNIFIED IDEOGRAPH-5B6D
        0x5B6E, # G+11962  U+5B6E  uni5B6E,  CJK UNIFIED IDEOGRAPH-5B6E
        0x5B6F, # G+11963  U+5B6F  uni5B6F,  CJK UNIFIED IDEOGRAPH-5B6F
        0x5B72, # G+11964  U+5B72  uni5B72,  CJK UNIFIED IDEOGRAPH-5B72
        0x5B74, # G+11965  U+5B74  uni5B74,  CJK UNIFIED IDEOGRAPH-5B74
        0x5B76, # G+11966  U+5B76  uni5B76,  CJK UNIFIED IDEOGRAPH-5B76
        0x5B77, # G+11967  U+5B77  uni5B77,  CJK UNIFIED IDEOGRAPH-5B77
        0x5B79, # G+11968  U+5B79  uni5B79,  CJK UNIFIED IDEOGRAPH-5B79
        0x5B7B, # G+11969  U+5B7B  uni5B7B,  CJK UNIFIED IDEOGRAPH-5B7B
        0x5B7C, # G+11970  U+5B7C  uni5B7C,  CJK UNIFIED IDEOGRAPH-5B7C
        0x5B7E, # G+11971  U+5B7E  uni5B7E,  CJK UNIFIED IDEOGRAPH-5B7E
        0x5B82, # G+11972  U+5B82  uni5B82,  CJK UNIFIED IDEOGRAPH-5B82
        0x5B86, # G+11973  U+5B86  uni5B86,  CJK UNIFIED IDEOGRAPH-5B86
        0x5B8A, # G+11974  U+5B8A  uni5B8A,  CJK UNIFIED IDEOGRAPH-5B8A
        0x5B8D, # G+11975  U+5B8D  uni5B8D,  CJK UNIFIED IDEOGRAPH-5B8D
        0x5B8E, # G+11976  U+5B8E  uni5B8E,  CJK UNIFIED IDEOGRAPH-5B8E
        0x5B90, # G+11977  U+5B90  uni5B90,  CJK UNIFIED IDEOGRAPH-5B90
        0x5B91, # G+11978  U+5B91  uni5B91,  CJK UNIFIED IDEOGRAPH-5B91
        0x5B92, # G+11979  U+5B92  uni5B92,  CJK UNIFIED IDEOGRAPH-5B92
        0x5B94, # G+11980  U+5B94  uni5B94,  CJK UNIFIED IDEOGRAPH-5B94
        0x5B96, # G+11981  U+5B96  uni5B96,  CJK UNIFIED IDEOGRAPH-5B96
        0x5B9F, # G+11982  U+5B9F  uni5B9F,  CJK UNIFIED IDEOGRAPH-5B9F
        0x5BA7, # G+11983  U+5BA7  uni5BA7,  CJK UNIFIED IDEOGRAPH-5BA7
        0x5BA8, # G+11984  U+5BA8  uni5BA8,  CJK UNIFIED IDEOGRAPH-5BA8
        0x5BA9, # G+11985  U+5BA9  uni5BA9,  CJK UNIFIED IDEOGRAPH-5BA9
        0x5BAC, # G+11986  U+5BAC  uni5BAC,  CJK UNIFIED IDEOGRAPH-5BAC
        0x5BAD, # G+11987  U+5BAD  uni5BAD,  CJK UNIFIED IDEOGRAPH-5BAD
        0x5BAE, # G+11988  U+5BAE  uni5BAE,  CJK UNIFIED IDEOGRAPH-5BAE
        0x5BAF, # G+11989  U+5BAF  uni5BAF,  CJK UNIFIED IDEOGRAPH-5BAF
        0x5BB1, # G+11990  U+5BB1  uni5BB1,  CJK UNIFIED IDEOGRAPH-5BB1
        0x5BB2, # G+11991  U+5BB2  uni5BB2,  CJK UNIFIED IDEOGRAPH-5BB2
        0x5BB7, # G+11992  U+5BB7  uni5BB7,  CJK UNIFIED IDEOGRAPH-5BB7
        0x5BBA, # G+11993  U+5BBA  uni5BBA,  CJK UNIFIED IDEOGRAPH-5BBA
        0x5BBB, # G+11994  U+5BBB  uni5BBB,  CJK UNIFIED IDEOGRAPH-5BBB
        0x5BBC, # G+11995  U+5BBC  uni5BBC,  CJK UNIFIED IDEOGRAPH-5BBC
        0x5BC0, # G+11996  U+5BC0  uni5BC0,  CJK UNIFIED IDEOGRAPH-5BC0
        0x5BC1, # G+11997  U+5BC1  uni5BC1,  CJK UNIFIED IDEOGRAPH-5BC1
        0x5BC3, # G+11998  U+5BC3  uni5BC3,  CJK UNIFIED IDEOGRAPH-5BC3
        0x5BC8, # G+11999  U+5BC8  uni5BC8,  CJK UNIFIED IDEOGRAPH-5BC8
        0x5BC9, # G+12000  U+5BC9  uni5BC9,  CJK UNIFIED IDEOGRAPH-5BC9
        0x5BCA, # G+12001  U+5BCA  uni5BCA,  CJK UNIFIED IDEOGRAPH-5BCA
        0x5BCB, # G+12002  U+5BCB  uni5BCB,  CJK UNIFIED IDEOGRAPH-5BCB
        0x5BCD, # G+12003  U+5BCD  uni5BCD,  CJK UNIFIED IDEOGRAPH-5BCD
        0x5BCE, # G+12004  U+5BCE  uni5BCE,  CJK UNIFIED IDEOGRAPH-5BCE
        0x5BCF, # G+12005  U+5BCF  uni5BCF,  CJK UNIFIED IDEOGRAPH-5BCF
        0x5BD1, # G+12006  U+5BD1  uni5BD1,  CJK UNIFIED IDEOGRAPH-5BD1
        0x5BD4, # G+12007  U+5BD4  uni5BD4,  CJK UNIFIED IDEOGRAPH-5BD4
        0x5BD5, # G+12008  U+5BD5  uni5BD5,  CJK UNIFIED IDEOGRAPH-5BD5
        0x5BD6, # G+12009  U+5BD6  uni5BD6,  CJK UNIFIED IDEOGRAPH-5BD6
        0x5BD7, # G+12010  U+5BD7  uni5BD7,  CJK UNIFIED IDEOGRAPH-5BD7
        0x5BD8, # G+12011  U+5BD8  uni5BD8,  CJK UNIFIED IDEOGRAPH-5BD8
        0x5BD9, # G+12012  U+5BD9  uni5BD9,  CJK UNIFIED IDEOGRAPH-5BD9
        0x5BDA, # G+12013  U+5BDA  uni5BDA,  CJK UNIFIED IDEOGRAPH-5BDA
        0x5BDB, # G+12014  U+5BDB  uni5BDB,  CJK UNIFIED IDEOGRAPH-5BDB
        0x5BDC, # G+12015  U+5BDC  uni5BDC,  CJK UNIFIED IDEOGRAPH-5BDC
        0x5BE0, # G+12016  U+5BE0  uni5BE0,  CJK UNIFIED IDEOGRAPH-5BE0
        0x5BE3, # G+12017  U+5BE3  uni5BE3,  CJK UNIFIED IDEOGRAPH-5BE3
        0x5BEA, # G+12018  U+5BEA  uni5BEA,  CJK UNIFIED IDEOGRAPH-5BEA
        0x5BED, # G+12019  U+5BED  uni5BED,  CJK UNIFIED IDEOGRAPH-5BED
        0x5BEF, # G+12020  U+5BEF  uni5BEF,  CJK UNIFIED IDEOGRAPH-5BEF
        0x5BF1, # G+12021  U+5BF1  uni5BF1,  CJK UNIFIED IDEOGRAPH-5BF1
        0x5BF2, # G+12022  U+5BF2  uni5BF2,  CJK UNIFIED IDEOGRAPH-5BF2
        0x5BF3, # G+12023  U+5BF3  uni5BF3,  CJK UNIFIED IDEOGRAPH-5BF3
        0x5BF4, # G+12024  U+5BF4  uni5BF4,  CJK UNIFIED IDEOGRAPH-5BF4
        0x5BF7, # G+12025  U+5BF7  uni5BF7,  CJK UNIFIED IDEOGRAPH-5BF7
        0x5BFD, # G+12026  U+5BFD  uni5BFD,  CJK UNIFIED IDEOGRAPH-5BFD
        0x5BFE, # G+12027  U+5BFE  uni5BFE,  CJK UNIFIED IDEOGRAPH-5BFE
        0x5C00, # G+12028  U+5C00  uni5C00,  CJK UNIFIED IDEOGRAPH-5C00
        0x5C02, # G+12029  U+5C02  uni5C02,  CJK UNIFIED IDEOGRAPH-5C02
        0x5C03, # G+12030  U+5C03  uni5C03,  CJK UNIFIED IDEOGRAPH-5C03
        0x5C05, # G+12031  U+5C05  uni5C05,  CJK UNIFIED IDEOGRAPH-5C05
        0x5C0C, # G+12032  U+5C0C  uni5C0C,  CJK UNIFIED IDEOGRAPH-5C0C
        0x5C10, # G+12033  U+5C10  uni5C10,  CJK UNIFIED IDEOGRAPH-5C10
        0x5C12, # G+12034  U+5C12  uni5C12,  CJK UNIFIED IDEOGRAPH-5C12
        0x5C13, # G+12035  U+5C13  uni5C13,  CJK UNIFIED IDEOGRAPH-5C13
        0x5C17, # G+12036  U+5C17  uni5C17,  CJK UNIFIED IDEOGRAPH-5C17
        0x5C19, # G+12037  U+5C19  uni5C19,  CJK UNIFIED IDEOGRAPH-5C19
        0x5C1B, # G+12038  U+5C1B  uni5C1B,  CJK UNIFIED IDEOGRAPH-5C1B
        0x5C1E, # G+12039  U+5C1E  uni5C1E,  CJK UNIFIED IDEOGRAPH-5C1E
        0x5C1F, # G+12040  U+5C1F  uni5C1F,  CJK UNIFIED IDEOGRAPH-5C1F
        0x5C20, # G+12041  U+5C20  uni5C20,  CJK UNIFIED IDEOGRAPH-5C20
        0x5C21, # G+12042  U+5C21  uni5C21,  CJK UNIFIED IDEOGRAPH-5C21
        0x5C23, # G+12043  U+5C23  uni5C23,  CJK UNIFIED IDEOGRAPH-5C23
        0x5C26, # G+12044  U+5C26  uni5C26,  CJK UNIFIED IDEOGRAPH-5C26
        0x5C28, # G+12045  U+5C28  uni5C28,  CJK UNIFIED IDEOGRAPH-5C28
        0x5C29, # G+12046  U+5C29  uni5C29,  CJK UNIFIED IDEOGRAPH-5C29
        0x5C2A, # G+12047  U+5C2A  uni5C2A,  CJK UNIFIED IDEOGRAPH-5C2A
        0x5C2B, # G+12048  U+5C2B  uni5C2B,  CJK UNIFIED IDEOGRAPH-5C2B
        0x5C2D, # G+12049  U+5C2D  uni5C2D,  CJK UNIFIED IDEOGRAPH-5C2D
        0x5C2E, # G+12050  U+5C2E  uni5C2E,  CJK UNIFIED IDEOGRAPH-5C2E
        0x5C2F, # G+12051  U+5C2F  uni5C2F,  CJK UNIFIED IDEOGRAPH-5C2F
        0x5C30, # G+12052  U+5C30  uni5C30,  CJK UNIFIED IDEOGRAPH-5C30
        0x5C32, # G+12053  U+5C32  uni5C32,  CJK UNIFIED IDEOGRAPH-5C32
        0x5C33, # G+12054  U+5C33  uni5C33,  CJK UNIFIED IDEOGRAPH-5C33
        0x5C35, # G+12055  U+5C35  uni5C35,  CJK UNIFIED IDEOGRAPH-5C35
        0x5C36, # G+12056  U+5C36  uni5C36,  CJK UNIFIED IDEOGRAPH-5C36
        0x5C43, # G+12057  U+5C43  uni5C43,  CJK UNIFIED IDEOGRAPH-5C43
        0x5C44, # G+12058  U+5C44  uni5C44,  CJK UNIFIED IDEOGRAPH-5C44
        0x5C46, # G+12059  U+5C46  uni5C46,  CJK UNIFIED IDEOGRAPH-5C46
        0x5C47, # G+12060  U+5C47  uni5C47,  CJK UNIFIED IDEOGRAPH-5C47
        0x5C4C, # G+12061  U+5C4C  uni5C4C,  CJK UNIFIED IDEOGRAPH-5C4C
        0x5C4D, # G+12062  U+5C4D  uni5C4D,  CJK UNIFIED IDEOGRAPH-5C4D
        0x5C52, # G+12063  U+5C52  uni5C52,  CJK UNIFIED IDEOGRAPH-5C52
        0x5C53, # G+12064  U+5C53  uni5C53,  CJK UNIFIED IDEOGRAPH-5C53
        0x5C54, # G+12065  U+5C54  uni5C54,  CJK UNIFIED IDEOGRAPH-5C54
        0x5C56, # G+12066  U+5C56  uni5C56,  CJK UNIFIED IDEOGRAPH-5C56
        0x5C57, # G+12067  U+5C57  uni5C57,  CJK UNIFIED IDEOGRAPH-5C57
        0x5C58, # G+12068  U+5C58  uni5C58,  CJK UNIFIED IDEOGRAPH-5C58
        0x5C5A, # G+12069  U+5C5A  uni5C5A,  CJK UNIFIED IDEOGRAPH-5C5A
        0x5C5B, # G+12070  U+5C5B  uni5C5B,  CJK UNIFIED IDEOGRAPH-5C5B
        0x5C5C, # G+12071  U+5C5C  uni5C5C,  CJK UNIFIED IDEOGRAPH-5C5C
        0x5C5D, # G+12072  U+5C5D  uni5C5D,  CJK UNIFIED IDEOGRAPH-5C5D
        0x5C5F, # G+12073  U+5C5F  uni5C5F,  CJK UNIFIED IDEOGRAPH-5C5F
        0x5C67, # G+12074  U+5C67  uni5C67,  CJK UNIFIED IDEOGRAPH-5C67
        0x5C69, # G+12075  U+5C69  uni5C69,  CJK UNIFIED IDEOGRAPH-5C69
        0x5C6A, # G+12076  U+5C6A  uni5C6A,  CJK UNIFIED IDEOGRAPH-5C6A
        0x5C6B, # G+12077  U+5C6B  uni5C6B,  CJK UNIFIED IDEOGRAPH-5C6B
        0x5C6D, # G+12078  U+5C6D  uni5C6D,  CJK UNIFIED IDEOGRAPH-5C6D
        0x5C70, # G+12079  U+5C70  uni5C70,  CJK UNIFIED IDEOGRAPH-5C70
        0x5C72, # G+12080  U+5C72  uni5C72,  CJK UNIFIED IDEOGRAPH-5C72
        0x5C73, # G+12081  U+5C73  uni5C73,  CJK UNIFIED IDEOGRAPH-5C73
        0x5C74, # G+12082  U+5C74  uni5C74,  CJK UNIFIED IDEOGRAPH-5C74
        0x5C75, # G+12083  U+5C75  uni5C75,  CJK UNIFIED IDEOGRAPH-5C75
        0x5C76, # G+12084  U+5C76  uni5C76,  CJK UNIFIED IDEOGRAPH-5C76
        0x5C77, # G+12085  U+5C77  uni5C77,  CJK UNIFIED IDEOGRAPH-5C77
        0x5C78, # G+12086  U+5C78  uni5C78,  CJK UNIFIED IDEOGRAPH-5C78
        0x5C7B, # G+12087  U+5C7B  uni5C7B,  CJK UNIFIED IDEOGRAPH-5C7B
        0x5C7C, # G+12088  U+5C7C  uni5C7C,  CJK UNIFIED IDEOGRAPH-5C7C
        0x5C7D, # G+12089  U+5C7D  uni5C7D,  CJK UNIFIED IDEOGRAPH-5C7D
        0x5C7E, # G+12090  U+5C7E  uni5C7E,  CJK UNIFIED IDEOGRAPH-5C7E
        0x5C80, # G+12091  U+5C80  uni5C80,  CJK UNIFIED IDEOGRAPH-5C80
        0x5C83, # G+12092  U+5C83  uni5C83,  CJK UNIFIED IDEOGRAPH-5C83
        0x5C84, # G+12093  U+5C84  uni5C84,  CJK UNIFIED IDEOGRAPH-5C84
        0x5C85, # G+12094  U+5C85  uni5C85,  CJK UNIFIED IDEOGRAPH-5C85
        0x5C86, # G+12095  U+5C86  uni5C86,  CJK UNIFIED IDEOGRAPH-5C86
        0x5C87, # G+12096  U+5C87  uni5C87,  CJK UNIFIED IDEOGRAPH-5C87
        0x5C89, # G+12097  U+5C89  uni5C89,  CJK UNIFIED IDEOGRAPH-5C89
        0x5C8A, # G+12098  U+5C8A  uni5C8A,  CJK UNIFIED IDEOGRAPH-5C8A
        0x5C8B, # G+12099  U+5C8B  uni5C8B,  CJK UNIFIED IDEOGRAPH-5C8B
        0x5C8E, # G+12100  U+5C8E  uni5C8E,  CJK UNIFIED IDEOGRAPH-5C8E
        0x5C8F, # G+12101  U+5C8F  uni5C8F,  CJK UNIFIED IDEOGRAPH-5C8F
        0x5C92, # G+12102  U+5C92  uni5C92,  CJK UNIFIED IDEOGRAPH-5C92
        0x5C93, # G+12103  U+5C93  uni5C93,  CJK UNIFIED IDEOGRAPH-5C93
        0x5C95, # G+12104  U+5C95  uni5C95,  CJK UNIFIED IDEOGRAPH-5C95
        0x5C9D, # G+12105  U+5C9D  uni5C9D,  CJK UNIFIED IDEOGRAPH-5C9D
        0x5C9E, # G+12106  U+5C9E  uni5C9E,  CJK UNIFIED IDEOGRAPH-5C9E
        0x5C9F, # G+12107  U+5C9F  uni5C9F,  CJK UNIFIED IDEOGRAPH-5C9F
        0x5CA0, # G+12108  U+5CA0  uni5CA0,  CJK UNIFIED IDEOGRAPH-5CA0
        0x5CA4, # G+12109  U+5CA4  uni5CA4,  CJK UNIFIED IDEOGRAPH-5CA4
        0x5CA5, # G+12110  U+5CA5  uni5CA5,  CJK UNIFIED IDEOGRAPH-5CA5
        0x5CA6, # G+12111  U+5CA6  uni5CA6,  CJK UNIFIED IDEOGRAPH-5CA6
        0x5CA7, # G+12112  U+5CA7  uni5CA7,  CJK UNIFIED IDEOGRAPH-5CA7
        0x5CA8, # G+12113  U+5CA8  uni5CA8,  CJK UNIFIED IDEOGRAPH-5CA8
        0x5CAA, # G+12114  U+5CAA  uni5CAA,  CJK UNIFIED IDEOGRAPH-5CAA
        0x5CAE, # G+12115  U+5CAE  uni5CAE,  CJK UNIFIED IDEOGRAPH-5CAE
        0x5CAF, # G+12116  U+5CAF  uni5CAF,  CJK UNIFIED IDEOGRAPH-5CAF
        0x5CB0, # G+12117  U+5CB0  uni5CB0,  CJK UNIFIED IDEOGRAPH-5CB0
        0x5CB2, # G+12118  U+5CB2  uni5CB2,  CJK UNIFIED IDEOGRAPH-5CB2
        0x5CB4, # G+12119  U+5CB4  uni5CB4,  CJK UNIFIED IDEOGRAPH-5CB4
        0x5CB6, # G+12120  U+5CB6  uni5CB6,  CJK UNIFIED IDEOGRAPH-5CB6
        0x5CB9, # G+12121  U+5CB9  uni5CB9,  CJK UNIFIED IDEOGRAPH-5CB9
        0x5CBA, # G+12122  U+5CBA  uni5CBA,  CJK UNIFIED IDEOGRAPH-5CBA
        0x5CBB, # G+12123  U+5CBB  uni5CBB,  CJK UNIFIED IDEOGRAPH-5CBB
        0x5CBC, # G+12124  U+5CBC  uni5CBC,  CJK UNIFIED IDEOGRAPH-5CBC
        0x5CBE, # G+12125  U+5CBE  uni5CBE,  CJK UNIFIED IDEOGRAPH-5CBE
        0x5CC0, # G+12126  U+5CC0  uni5CC0,  CJK UNIFIED IDEOGRAPH-5CC0
        0x5CC2, # G+12127  U+5CC2  uni5CC2,  CJK UNIFIED IDEOGRAPH-5CC2
        0x5CC3, # G+12128  U+5CC3  uni5CC3,  CJK UNIFIED IDEOGRAPH-5CC3
        0x5CC5, # G+12129  U+5CC5  uni5CC5,  CJK UNIFIED IDEOGRAPH-5CC5
        0x5CC6, # G+12130  U+5CC6  uni5CC6,  CJK UNIFIED IDEOGRAPH-5CC6
        0x5CC7, # G+12131  U+5CC7  uni5CC7,  CJK UNIFIED IDEOGRAPH-5CC7
        0x5CC8, # G+12132  U+5CC8  uni5CC8,  CJK UNIFIED IDEOGRAPH-5CC8
        0x5CC9, # G+12133  U+5CC9  uni5CC9,  CJK UNIFIED IDEOGRAPH-5CC9
        0x5CCA, # G+12134  U+5CCA  uni5CCA,  CJK UNIFIED IDEOGRAPH-5CCA
        0x5CCC, # G+12135  U+5CCC  uni5CCC,  CJK UNIFIED IDEOGRAPH-5CCC
        0x5CCD, # G+12136  U+5CCD  uni5CCD,  CJK UNIFIED IDEOGRAPH-5CCD
        0x5CCE, # G+12137  U+5CCE  uni5CCE,  CJK UNIFIED IDEOGRAPH-5CCE
        0x5CCF, # G+12138  U+5CCF  uni5CCF,  CJK UNIFIED IDEOGRAPH-5CCF
        0x5CD0, # G+12139  U+5CD0  uni5CD0,  CJK UNIFIED IDEOGRAPH-5CD0
        0x5CD1, # G+12140  U+5CD1  uni5CD1,  CJK UNIFIED IDEOGRAPH-5CD1
        0x5CD3, # G+12141  U+5CD3  uni5CD3,  CJK UNIFIED IDEOGRAPH-5CD3
        0x5CD4, # G+12142  U+5CD4  uni5CD4,  CJK UNIFIED IDEOGRAPH-5CD4
        0x5CD5, # G+12143  U+5CD5  uni5CD5,  CJK UNIFIED IDEOGRAPH-5CD5
        0x5CD6, # G+12144  U+5CD6  uni5CD6,  CJK UNIFIED IDEOGRAPH-5CD6
        0x5CD7, # G+12145  U+5CD7  uni5CD7,  CJK UNIFIED IDEOGRAPH-5CD7
        0x5CD8, # G+12146  U+5CD8  uni5CD8,  CJK UNIFIED IDEOGRAPH-5CD8
        0x5CDA, # G+12147  U+5CDA  uni5CDA,  CJK UNIFIED IDEOGRAPH-5CDA
        0x5CDB, # G+12148  U+5CDB  uni5CDB,  CJK UNIFIED IDEOGRAPH-5CDB
        0x5CDC, # G+12149  U+5CDC  uni5CDC,  CJK UNIFIED IDEOGRAPH-5CDC
        0x5CDD, # G+12150  U+5CDD  uni5CDD,  CJK UNIFIED IDEOGRAPH-5CDD
        0x5CDE, # G+12151  U+5CDE  uni5CDE,  CJK UNIFIED IDEOGRAPH-5CDE
        0x5CDF, # G+12152  U+5CDF  uni5CDF,  CJK UNIFIED IDEOGRAPH-5CDF
        0x5CE0, # G+12153  U+5CE0  uni5CE0,  CJK UNIFIED IDEOGRAPH-5CE0
        0x5CE2, # G+12154  U+5CE2  uni5CE2,  CJK UNIFIED IDEOGRAPH-5CE2
        0x5CE3, # G+12155  U+5CE3  uni5CE3,  CJK UNIFIED IDEOGRAPH-5CE3
        0x5CE7, # G+12156  U+5CE7  uni5CE7,  CJK UNIFIED IDEOGRAPH-5CE7
        0x5CE9, # G+12157  U+5CE9  uni5CE9,  CJK UNIFIED IDEOGRAPH-5CE9
        0x5CEB, # G+12158  U+5CEB  uni5CEB,  CJK UNIFIED IDEOGRAPH-5CEB
        0x5CEC, # G+12159  U+5CEC  uni5CEC,  CJK UNIFIED IDEOGRAPH-5CEC
        0x5CEE, # G+12160  U+5CEE  uni5CEE,  CJK UNIFIED IDEOGRAPH-5CEE
        0x5CEF, # G+12161  U+5CEF  uni5CEF,  CJK UNIFIED IDEOGRAPH-5CEF
        0x5CF1, # G+12162  U+5CF1  uni5CF1,  CJK UNIFIED IDEOGRAPH-5CF1
        0x5CF2, # G+12163  U+5CF2  uni5CF2,  CJK UNIFIED IDEOGRAPH-5CF2
        0x5CF3, # G+12164  U+5CF3  uni5CF3,  CJK UNIFIED IDEOGRAPH-5CF3
        0x5CF5, # G+12165  U+5CF5  uni5CF5,  CJK UNIFIED IDEOGRAPH-5CF5
        0x5CF7, # G+12166  U+5CF7  uni5CF7,  CJK UNIFIED IDEOGRAPH-5CF7
        0x5CF8, # G+12167  U+5CF8  uni5CF8,  CJK UNIFIED IDEOGRAPH-5CF8
        0x5CF9, # G+12168  U+5CF9  uni5CF9,  CJK UNIFIED IDEOGRAPH-5CF9
        0x5CFA, # G+12169  U+5CFA  uni5CFA,  CJK UNIFIED IDEOGRAPH-5CFA
        0x5CFC, # G+12170  U+5CFC  uni5CFC,  CJK UNIFIED IDEOGRAPH-5CFC
        0x5CFE, # G+12171  U+5CFE  uni5CFE,  CJK UNIFIED IDEOGRAPH-5CFE
        0x5CFF, # G+12172  U+5CFF  uni5CFF,  CJK UNIFIED IDEOGRAPH-5CFF
        0x5D00, # G+12173  U+5D00  uni5D00,  CJK UNIFIED IDEOGRAPH-5D00
        0x5D01, # G+12174  U+5D01  uni5D01,  CJK UNIFIED IDEOGRAPH-5D01
        0x5D04, # G+12175  U+5D04  uni5D04,  CJK UNIFIED IDEOGRAPH-5D04
        0x5D05, # G+12176  U+5D05  uni5D05,  CJK UNIFIED IDEOGRAPH-5D05
        0x5D08, # G+12177  U+5D08  uni5D08,  CJK UNIFIED IDEOGRAPH-5D08
        0x5D09, # G+12178  U+5D09  uni5D09,  CJK UNIFIED IDEOGRAPH-5D09
        0x5D0A, # G+12179  U+5D0A  uni5D0A,  CJK UNIFIED IDEOGRAPH-5D0A
        0x5D0B, # G+12180  U+5D0B  uni5D0B,  CJK UNIFIED IDEOGRAPH-5D0B
        0x5D0C, # G+12181  U+5D0C  uni5D0C,  CJK UNIFIED IDEOGRAPH-5D0C
        0x5D0F, # G+12182  U+5D0F  uni5D0F,  CJK UNIFIED IDEOGRAPH-5D0F
        0x5D10, # G+12183  U+5D10  uni5D10,  CJK UNIFIED IDEOGRAPH-5D10
        0x5D11, # G+12184  U+5D11  uni5D11,  CJK UNIFIED IDEOGRAPH-5D11
        0x5D12, # G+12185  U+5D12  uni5D12,  CJK UNIFIED IDEOGRAPH-5D12
        0x5D13, # G+12186  U+5D13  uni5D13,  CJK UNIFIED IDEOGRAPH-5D13
        0x5D15, # G+12187  U+5D15  uni5D15,  CJK UNIFIED IDEOGRAPH-5D15
        0x5D18, # G+12188  U+5D18  uni5D18,  CJK UNIFIED IDEOGRAPH-5D18
        0x5D19, # G+12189  U+5D19  uni5D19,  CJK UNIFIED IDEOGRAPH-5D19
        0x5D1A, # G+12190  U+5D1A  uni5D1A,  CJK UNIFIED IDEOGRAPH-5D1A
        0x5D1C, # G+12191  U+5D1C  uni5D1C,  CJK UNIFIED IDEOGRAPH-5D1C
        0x5D1D, # G+12192  U+5D1D  uni5D1D,  CJK UNIFIED IDEOGRAPH-5D1D
        0x5D1F, # G+12193  U+5D1F  uni5D1F,  CJK UNIFIED IDEOGRAPH-5D1F
        0x5D20, # G+12194  U+5D20  uni5D20,  CJK UNIFIED IDEOGRAPH-5D20
        0x5D21, # G+12195  U+5D21  uni5D21,  CJK UNIFIED IDEOGRAPH-5D21
        0x5D22, # G+12196  U+5D22  uni5D22,  CJK UNIFIED IDEOGRAPH-5D22
        0x5D23, # G+12197  U+5D23  uni5D23,  CJK UNIFIED IDEOGRAPH-5D23
        0x5D25, # G+12198  U+5D25  uni5D25,  CJK UNIFIED IDEOGRAPH-5D25
        0x5D28, # G+12199  U+5D28  uni5D28,  CJK UNIFIED IDEOGRAPH-5D28
        0x5D2A, # G+12200  U+5D2A  uni5D2A,  CJK UNIFIED IDEOGRAPH-5D2A
        0x5D2B, # G+12201  U+5D2B  uni5D2B,  CJK UNIFIED IDEOGRAPH-5D2B
        0x5D2F, # G+12202  U+5D2F  uni5D2F,  CJK UNIFIED IDEOGRAPH-5D2F
        0x5D30, # G+12203  U+5D30  uni5D30,  CJK UNIFIED IDEOGRAPH-5D30
        0x5D31, # G+12204  U+5D31  uni5D31,  CJK UNIFIED IDEOGRAPH-5D31
        0x5D32, # G+12205  U+5D32  uni5D32,  CJK UNIFIED IDEOGRAPH-5D32
        0x5D33, # G+12206  U+5D33  uni5D33,  CJK UNIFIED IDEOGRAPH-5D33
        0x5D35, # G+12207  U+5D35  uni5D35,  CJK UNIFIED IDEOGRAPH-5D35
        0x5D36, # G+12208  U+5D36  uni5D36,  CJK UNIFIED IDEOGRAPH-5D36
        0x5D37, # G+12209  U+5D37  uni5D37,  CJK UNIFIED IDEOGRAPH-5D37
        0x5D38, # G+12210  U+5D38  uni5D38,  CJK UNIFIED IDEOGRAPH-5D38
        0x5D39, # G+12211  U+5D39  uni5D39,  CJK UNIFIED IDEOGRAPH-5D39
        0x5D3A, # G+12212  U+5D3A  uni5D3A,  CJK UNIFIED IDEOGRAPH-5D3A
        0x5D3B, # G+12213  U+5D3B  uni5D3B,  CJK UNIFIED IDEOGRAPH-5D3B
        0x5D3C, # G+12214  U+5D3C  uni5D3C,  CJK UNIFIED IDEOGRAPH-5D3C
        0x5D3F, # G+12215  U+5D3F  uni5D3F,  CJK UNIFIED IDEOGRAPH-5D3F
        0x5D40, # G+12216  U+5D40  uni5D40,  CJK UNIFIED IDEOGRAPH-5D40
        0x5D41, # G+12217  U+5D41  uni5D41,  CJK UNIFIED IDEOGRAPH-5D41
        0x5D42, # G+12218  U+5D42  uni5D42,  CJK UNIFIED IDEOGRAPH-5D42
        0x5D43, # G+12219  U+5D43  uni5D43,  CJK UNIFIED IDEOGRAPH-5D43
        0x5D44, # G+12220  U+5D44  uni5D44,  CJK UNIFIED IDEOGRAPH-5D44
        0x5D45, # G+12221  U+5D45  uni5D45,  CJK UNIFIED IDEOGRAPH-5D45
        0x5D46, # G+12222  U+5D46  uni5D46,  CJK UNIFIED IDEOGRAPH-5D46
        0x5D48, # G+12223  U+5D48  uni5D48,  CJK UNIFIED IDEOGRAPH-5D48
        0x5D49, # G+12224  U+5D49  uni5D49,  CJK UNIFIED IDEOGRAPH-5D49
        0x5D4D, # G+12225  U+5D4D  uni5D4D,  CJK UNIFIED IDEOGRAPH-5D4D
        0x5D4E, # G+12226  U+5D4E  uni5D4E,  CJK UNIFIED IDEOGRAPH-5D4E
        0x5D4F, # G+12227  U+5D4F  uni5D4F,  CJK UNIFIED IDEOGRAPH-5D4F
        0x5D51, # G+12228  U+5D51  uni5D51,  CJK UNIFIED IDEOGRAPH-5D51
        0x5D52, # G+12229  U+5D52  uni5D52,  CJK UNIFIED IDEOGRAPH-5D52
        0x5D53, # G+12230  U+5D53  uni5D53,  CJK UNIFIED IDEOGRAPH-5D53
        0x5D54, # G+12231  U+5D54  uni5D54,  CJK UNIFIED IDEOGRAPH-5D54
        0x5D55, # G+12232  U+5D55  uni5D55,  CJK UNIFIED IDEOGRAPH-5D55
        0x5D56, # G+12233  U+5D56  uni5D56,  CJK UNIFIED IDEOGRAPH-5D56
        0x5D57, # G+12234  U+5D57  uni5D57,  CJK UNIFIED IDEOGRAPH-5D57
        0x5D59, # G+12235  U+5D59  uni5D59,  CJK UNIFIED IDEOGRAPH-5D59
        0x5D5A, # G+12236  U+5D5A  uni5D5A,  CJK UNIFIED IDEOGRAPH-5D5A
        0x5D5C, # G+12237  U+5D5C  uni5D5C,  CJK UNIFIED IDEOGRAPH-5D5C
        0x5D5E, # G+12238  U+5D5E  uni5D5E,  CJK UNIFIED IDEOGRAPH-5D5E
        0x5D5F, # G+12239  U+5D5F  uni5D5F,  CJK UNIFIED IDEOGRAPH-5D5F
        0x5D60, # G+12240  U+5D60  uni5D60,  CJK UNIFIED IDEOGRAPH-5D60
        0x5D61, # G+12241  U+5D61  uni5D61,  CJK UNIFIED IDEOGRAPH-5D61
        0x5D62, # G+12242  U+5D62  uni5D62,  CJK UNIFIED IDEOGRAPH-5D62
        0x5D63, # G+12243  U+5D63  uni5D63,  CJK UNIFIED IDEOGRAPH-5D63
        0x5D64, # G+12244  U+5D64  uni5D64,  CJK UNIFIED IDEOGRAPH-5D64
        0x5D65, # G+12245  U+5D65  uni5D65,  CJK UNIFIED IDEOGRAPH-5D65
        0x5D66, # G+12246  U+5D66  uni5D66,  CJK UNIFIED IDEOGRAPH-5D66
        0x5D67, # G+12247  U+5D67  uni5D67,  CJK UNIFIED IDEOGRAPH-5D67
        0x5D68, # G+12248  U+5D68  uni5D68,  CJK UNIFIED IDEOGRAPH-5D68
        0x5D6A, # G+12249  U+5D6A  uni5D6A,  CJK UNIFIED IDEOGRAPH-5D6A
        0x5D6D, # G+12250  U+5D6D  uni5D6D,  CJK UNIFIED IDEOGRAPH-5D6D
        0x5D6E, # G+12251  U+5D6E  uni5D6E,  CJK UNIFIED IDEOGRAPH-5D6E
        0x5D70, # G+12252  U+5D70  uni5D70,  CJK UNIFIED IDEOGRAPH-5D70
        0x5D71, # G+12253  U+5D71  uni5D71,  CJK UNIFIED IDEOGRAPH-5D71
        0x5D72, # G+12254  U+5D72  uni5D72,  CJK UNIFIED IDEOGRAPH-5D72
        0x5D73, # G+12255  U+5D73  uni5D73,  CJK UNIFIED IDEOGRAPH-5D73
        0x5D75, # G+12256  U+5D75  uni5D75,  CJK UNIFIED IDEOGRAPH-5D75
        0x5D76, # G+12257  U+5D76  uni5D76,  CJK UNIFIED IDEOGRAPH-5D76
        0x5D77, # G+12258  U+5D77  uni5D77,  CJK UNIFIED IDEOGRAPH-5D77
        0x5D78, # G+12259  U+5D78  uni5D78,  CJK UNIFIED IDEOGRAPH-5D78
        0x5D79, # G+12260  U+5D79  uni5D79,  CJK UNIFIED IDEOGRAPH-5D79
        0x5D7A, # G+12261  U+5D7A  uni5D7A,  CJK UNIFIED IDEOGRAPH-5D7A
        0x5D7B, # G+12262  U+5D7B  uni5D7B,  CJK UNIFIED IDEOGRAPH-5D7B
        0x5D7C, # G+12263  U+5D7C  uni5D7C,  CJK UNIFIED IDEOGRAPH-5D7C
        0x5D7D, # G+12264  U+5D7D  uni5D7D,  CJK UNIFIED IDEOGRAPH-5D7D
        0x5D7E, # G+12265  U+5D7E  uni5D7E,  CJK UNIFIED IDEOGRAPH-5D7E
        0x5D7F, # G+12266  U+5D7F  uni5D7F,  CJK UNIFIED IDEOGRAPH-5D7F
        0x5D80, # G+12267  U+5D80  uni5D80,  CJK UNIFIED IDEOGRAPH-5D80
        0x5D83, # G+12268  U+5D83  uni5D83,  CJK UNIFIED IDEOGRAPH-5D83
        0x5D85, # G+12269  U+5D85  uni5D85,  CJK UNIFIED IDEOGRAPH-5D85
        0x5D86, # G+12270  U+5D86  uni5D86,  CJK UNIFIED IDEOGRAPH-5D86
        0x5D88, # G+12271  U+5D88  uni5D88,  CJK UNIFIED IDEOGRAPH-5D88
        0x5D89, # G+12272  U+5D89  uni5D89,  CJK UNIFIED IDEOGRAPH-5D89
        0x5D8A, # G+12273  U+5D8A  uni5D8A,  CJK UNIFIED IDEOGRAPH-5D8A
        0x5D8B, # G+12274  U+5D8B  uni5D8B,  CJK UNIFIED IDEOGRAPH-5D8B
        0x5D8C, # G+12275  U+5D8C  uni5D8C,  CJK UNIFIED IDEOGRAPH-5D8C
        0x5D8D, # G+12276  U+5D8D  uni5D8D,  CJK UNIFIED IDEOGRAPH-5D8D
        0x5D8E, # G+12277  U+5D8E  uni5D8E,  CJK UNIFIED IDEOGRAPH-5D8E
        0x5D8F, # G+12278  U+5D8F  uni5D8F,  CJK UNIFIED IDEOGRAPH-5D8F
        0x5D90, # G+12279  U+5D90  uni5D90,  CJK UNIFIED IDEOGRAPH-5D90
        0x5D91, # G+12280  U+5D91  uni5D91,  CJK UNIFIED IDEOGRAPH-5D91
        0x5D92, # G+12281  U+5D92  uni5D92,  CJK UNIFIED IDEOGRAPH-5D92
        0x5D93, # G+12282  U+5D93  uni5D93,  CJK UNIFIED IDEOGRAPH-5D93
        0x5D94, # G+12283  U+5D94  uni5D94,  CJK UNIFIED IDEOGRAPH-5D94
        0x5D95, # G+12284  U+5D95  uni5D95,  CJK UNIFIED IDEOGRAPH-5D95
        0x5D96, # G+12285  U+5D96  uni5D96,  CJK UNIFIED IDEOGRAPH-5D96
        0x5D98, # G+12286  U+5D98  uni5D98,  CJK UNIFIED IDEOGRAPH-5D98
        0x5D9A, # G+12287  U+5D9A  uni5D9A,  CJK UNIFIED IDEOGRAPH-5D9A
        0x5D9B, # G+12288  U+5D9B  uni5D9B,  CJK UNIFIED IDEOGRAPH-5D9B
        0x5D9C, # G+12289  U+5D9C  uni5D9C,  CJK UNIFIED IDEOGRAPH-5D9C
        0x5D9E, # G+12290  U+5D9E  uni5D9E,  CJK UNIFIED IDEOGRAPH-5D9E
        0x5D9F, # G+12291  U+5D9F  uni5D9F,  CJK UNIFIED IDEOGRAPH-5D9F
        0x5DA1, # G+12292  U+5DA1  uni5DA1,  CJK UNIFIED IDEOGRAPH-5DA1
        0x5DA2, # G+12293  U+5DA2  uni5DA2,  CJK UNIFIED IDEOGRAPH-5DA2
        0x5DA3, # G+12294  U+5DA3  uni5DA3,  CJK UNIFIED IDEOGRAPH-5DA3
        0x5DA4, # G+12295  U+5DA4  uni5DA4,  CJK UNIFIED IDEOGRAPH-5DA4
        0x5DA5, # G+12296  U+5DA5  uni5DA5,  CJK UNIFIED IDEOGRAPH-5DA5
        0x5DA6, # G+12297  U+5DA6  uni5DA6,  CJK UNIFIED IDEOGRAPH-5DA6
        0x5DA8, # G+12298  U+5DA8  uni5DA8,  CJK UNIFIED IDEOGRAPH-5DA8
        0x5DA9, # G+12299  U+5DA9  uni5DA9,  CJK UNIFIED IDEOGRAPH-5DA9
        0x5DAA, # G+12300  U+5DAA  uni5DAA,  CJK UNIFIED IDEOGRAPH-5DAA
        0x5DAB, # G+12301  U+5DAB  uni5DAB,  CJK UNIFIED IDEOGRAPH-5DAB
        0x5DAC, # G+12302  U+5DAC  uni5DAC,  CJK UNIFIED IDEOGRAPH-5DAC
        0x5DAD, # G+12303  U+5DAD  uni5DAD,  CJK UNIFIED IDEOGRAPH-5DAD
        0x5DAE, # G+12304  U+5DAE  uni5DAE,  CJK UNIFIED IDEOGRAPH-5DAE
        0x5DAF, # G+12305  U+5DAF  uni5DAF,  CJK UNIFIED IDEOGRAPH-5DAF
        0x5DB0, # G+12306  U+5DB0  uni5DB0,  CJK UNIFIED IDEOGRAPH-5DB0
        0x5DB1, # G+12307  U+5DB1  uni5DB1,  CJK UNIFIED IDEOGRAPH-5DB1
        0x5DB2, # G+12308  U+5DB2  uni5DB2,  CJK UNIFIED IDEOGRAPH-5DB2
        0x5DB3, # G+12309  U+5DB3  uni5DB3,  CJK UNIFIED IDEOGRAPH-5DB3
        0x5DB4, # G+12310  U+5DB4  uni5DB4,  CJK UNIFIED IDEOGRAPH-5DB4
        0x5DB5, # G+12311  U+5DB5  uni5DB5,  CJK UNIFIED IDEOGRAPH-5DB5
        0x5DB6, # G+12312  U+5DB6  uni5DB6,  CJK UNIFIED IDEOGRAPH-5DB6
        0x5DB9, # G+12313  U+5DB9  uni5DB9,  CJK UNIFIED IDEOGRAPH-5DB9
        0x5DBB, # G+12314  U+5DBB  uni5DBB,  CJK UNIFIED IDEOGRAPH-5DBB
        0x5DBD, # G+12315  U+5DBD  uni5DBD,  CJK UNIFIED IDEOGRAPH-5DBD
        0x5DBE, # G+12316  U+5DBE  uni5DBE,  CJK UNIFIED IDEOGRAPH-5DBE
        0x5DBF, # G+12317  U+5DBF  uni5DBF,  CJK UNIFIED IDEOGRAPH-5DBF
        0x5DC0, # G+12318  U+5DC0  uni5DC0,  CJK UNIFIED IDEOGRAPH-5DC0
        0x5DC1, # G+12319  U+5DC1  uni5DC1,  CJK UNIFIED IDEOGRAPH-5DC1
        0x5DC2, # G+12320  U+5DC2  uni5DC2,  CJK UNIFIED IDEOGRAPH-5DC2
        0x5DC3, # G+12321  U+5DC3  uni5DC3,  CJK UNIFIED IDEOGRAPH-5DC3
        0x5DC4, # G+12322  U+5DC4  uni5DC4,  CJK UNIFIED IDEOGRAPH-5DC4
        0x5DC6, # G+12323  U+5DC6  uni5DC6,  CJK UNIFIED IDEOGRAPH-5DC6
        0x5DC7, # G+12324  U+5DC7  uni5DC7,  CJK UNIFIED IDEOGRAPH-5DC7
        0x5DC8, # G+12325  U+5DC8  uni5DC8,  CJK UNIFIED IDEOGRAPH-5DC8
        0x5DC9, # G+12326  U+5DC9  uni5DC9,  CJK UNIFIED IDEOGRAPH-5DC9
        0x5DCA, # G+12327  U+5DCA  uni5DCA,  CJK UNIFIED IDEOGRAPH-5DCA
        0x5DCC, # G+12328  U+5DCC  uni5DCC,  CJK UNIFIED IDEOGRAPH-5DCC
        0x5DCE, # G+12329  U+5DCE  uni5DCE,  CJK UNIFIED IDEOGRAPH-5DCE
        0x5DCF, # G+12330  U+5DCF  uni5DCF,  CJK UNIFIED IDEOGRAPH-5DCF
        0x5DD0, # G+12331  U+5DD0  uni5DD0,  CJK UNIFIED IDEOGRAPH-5DD0
        0x5DD1, # G+12332  U+5DD1  uni5DD1,  CJK UNIFIED IDEOGRAPH-5DD1
        0x5DD3, # G+12333  U+5DD3  uni5DD3,  CJK UNIFIED IDEOGRAPH-5DD3
        0x5DD5, # G+12334  U+5DD5  uni5DD5,  CJK UNIFIED IDEOGRAPH-5DD5
        0x5DD6, # G+12335  U+5DD6  uni5DD6,  CJK UNIFIED IDEOGRAPH-5DD6
        0x5DD7, # G+12336  U+5DD7  uni5DD7,  CJK UNIFIED IDEOGRAPH-5DD7
        0x5DD8, # G+12337  U+5DD8  uni5DD8,  CJK UNIFIED IDEOGRAPH-5DD8
        0x5DD9, # G+12338  U+5DD9  uni5DD9,  CJK UNIFIED IDEOGRAPH-5DD9
        0x5DDA, # G+12339  U+5DDA  uni5DDA,  CJK UNIFIED IDEOGRAPH-5DDA
        0x5DDC, # G+12340  U+5DDC  uni5DDC,  CJK UNIFIED IDEOGRAPH-5DDC
        0x5DDF, # G+12341  U+5DDF  uni5DDF,  CJK UNIFIED IDEOGRAPH-5DDF
        0x5DE0, # G+12342  U+5DE0  uni5DE0,  CJK UNIFIED IDEOGRAPH-5DE0
        0x5DE3, # G+12343  U+5DE3  uni5DE3,  CJK UNIFIED IDEOGRAPH-5DE3
        0x5DE4, # G+12344  U+5DE4  uni5DE4,  CJK UNIFIED IDEOGRAPH-5DE4
        0x5DEA, # G+12345  U+5DEA  uni5DEA,  CJK UNIFIED IDEOGRAPH-5DEA
        0x5DEC, # G+12346  U+5DEC  uni5DEC,  CJK UNIFIED IDEOGRAPH-5DEC
        0x5DED, # G+12347  U+5DED  uni5DED,  CJK UNIFIED IDEOGRAPH-5DED
        0x5DF5, # G+12348  U+5DF5  uni5DF5,  CJK UNIFIED IDEOGRAPH-5DF5
        0x5DF6, # G+12349  U+5DF6  uni5DF6,  CJK UNIFIED IDEOGRAPH-5DF6
        0x5DF8, # G+12350  U+5DF8  uni5DF8,  CJK UNIFIED IDEOGRAPH-5DF8
        0x5DF9, # G+12351  U+5DF9  uni5DF9,  CJK UNIFIED IDEOGRAPH-5DF9
        0x5DFA, # G+12352  U+5DFA  uni5DFA,  CJK UNIFIED IDEOGRAPH-5DFA
        0x5DFB, # G+12353  U+5DFB  uni5DFB,  CJK UNIFIED IDEOGRAPH-5DFB
        0x5DFC, # G+12354  U+5DFC  uni5DFC,  CJK UNIFIED IDEOGRAPH-5DFC
        0x5DFF, # G+12355  U+5DFF  uni5DFF,  CJK UNIFIED IDEOGRAPH-5DFF
        0x5E00, # G+12356  U+5E00  uni5E00,  CJK UNIFIED IDEOGRAPH-5E00
        0x5E04, # G+12357  U+5E04  uni5E04,  CJK UNIFIED IDEOGRAPH-5E04
        0x5E07, # G+12358  U+5E07  uni5E07,  CJK UNIFIED IDEOGRAPH-5E07
        0x5E09, # G+12359  U+5E09  uni5E09,  CJK UNIFIED IDEOGRAPH-5E09
        0x5E0A, # G+12360  U+5E0A  uni5E0A,  CJK UNIFIED IDEOGRAPH-5E0A
        0x5E0B, # G+12361  U+5E0B  uni5E0B,  CJK UNIFIED IDEOGRAPH-5E0B
        0x5E0D, # G+12362  U+5E0D  uni5E0D,  CJK UNIFIED IDEOGRAPH-5E0D
        0x5E0E, # G+12363  U+5E0E  uni5E0E,  CJK UNIFIED IDEOGRAPH-5E0E
        0x5E12, # G+12364  U+5E12  uni5E12,  CJK UNIFIED IDEOGRAPH-5E12
        0x5E13, # G+12365  U+5E13  uni5E13,  CJK UNIFIED IDEOGRAPH-5E13
        0x5E17, # G+12366  U+5E17  uni5E17,  CJK UNIFIED IDEOGRAPH-5E17
        0x5E1E, # G+12367  U+5E1E  uni5E1E,  CJK UNIFIED IDEOGRAPH-5E1E
        0x5E1F, # G+12368  U+5E1F  uni5E1F,  CJK UNIFIED IDEOGRAPH-5E1F
        0x5E20, # G+12369  U+5E20  uni5E20,  CJK UNIFIED IDEOGRAPH-5E20
        0x5E21, # G+12370  U+5E21  uni5E21,  CJK UNIFIED IDEOGRAPH-5E21
        0x5E22, # G+12371  U+5E22  uni5E22,  CJK UNIFIED IDEOGRAPH-5E22
        0x5E23, # G+12372  U+5E23  uni5E23,  CJK UNIFIED IDEOGRAPH-5E23
        0x5E24, # G+12373  U+5E24  uni5E24,  CJK UNIFIED IDEOGRAPH-5E24
        0x5E28, # G+12374  U+5E28  uni5E28,  CJK UNIFIED IDEOGRAPH-5E28
        0x5E29, # G+12375  U+5E29  uni5E29,  CJK UNIFIED IDEOGRAPH-5E29
        0x5E2A, # G+12376  U+5E2A  uni5E2A,  CJK UNIFIED IDEOGRAPH-5E2A
        0x5E2C, # G+12377  U+5E2C  uni5E2C,  CJK UNIFIED IDEOGRAPH-5E2C
        0x5E2F, # G+12378  U+5E2F  uni5E2F,  CJK UNIFIED IDEOGRAPH-5E2F
        0x5E30, # G+12379  U+5E30  uni5E30,  CJK UNIFIED IDEOGRAPH-5E30
        0x5E32, # G+12380  U+5E32  uni5E32,  CJK UNIFIED IDEOGRAPH-5E32
        0x5E34, # G+12381  U+5E34  uni5E34,  CJK UNIFIED IDEOGRAPH-5E34
        0x5E35, # G+12382  U+5E35  uni5E35,  CJK UNIFIED IDEOGRAPH-5E35
        0x5E39, # G+12383  U+5E39  uni5E39,  CJK UNIFIED IDEOGRAPH-5E39
        0x5E3A, # G+12384  U+5E3A  uni5E3A,  CJK UNIFIED IDEOGRAPH-5E3A
        0x5E3E, # G+12385  U+5E3E  uni5E3E,  CJK UNIFIED IDEOGRAPH-5E3E
        0x5E3F, # G+12386  U+5E3F  uni5E3F,  CJK UNIFIED IDEOGRAPH-5E3F
        0x5E41, # G+12387  U+5E41  uni5E41,  CJK UNIFIED IDEOGRAPH-5E41
        0x5E46, # G+12388  U+5E46  uni5E46,  CJK UNIFIED IDEOGRAPH-5E46
        0x5E47, # G+12389  U+5E47  uni5E47,  CJK UNIFIED IDEOGRAPH-5E47
        0x5E48, # G+12390  U+5E48  uni5E48,  CJK UNIFIED IDEOGRAPH-5E48
        0x5E49, # G+12391  U+5E49  uni5E49,  CJK UNIFIED IDEOGRAPH-5E49
        0x5E4A, # G+12392  U+5E4A  uni5E4A,  CJK UNIFIED IDEOGRAPH-5E4A
        0x5E4B, # G+12393  U+5E4B  uni5E4B,  CJK UNIFIED IDEOGRAPH-5E4B
        0x5E4D, # G+12394  U+5E4D  uni5E4D,  CJK UNIFIED IDEOGRAPH-5E4D
        0x5E4E, # G+12395  U+5E4E  uni5E4E,  CJK UNIFIED IDEOGRAPH-5E4E
        0x5E4F, # G+12396  U+5E4F  uni5E4F,  CJK UNIFIED IDEOGRAPH-5E4F
        0x5E50, # G+12397  U+5E50  uni5E50,  CJK UNIFIED IDEOGRAPH-5E50
        0x5E51, # G+12398  U+5E51  uni5E51,  CJK UNIFIED IDEOGRAPH-5E51
        0x5E52, # G+12399  U+5E52  uni5E52,  CJK UNIFIED IDEOGRAPH-5E52
        0x5E53, # G+12400  U+5E53  uni5E53,  CJK UNIFIED IDEOGRAPH-5E53
        0x5E56, # G+12401  U+5E56  uni5E56,  CJK UNIFIED IDEOGRAPH-5E56
        0x5E59, # G+12402  U+5E59  uni5E59,  CJK UNIFIED IDEOGRAPH-5E59
        0x5E5A, # G+12403  U+5E5A  uni5E5A,  CJK UNIFIED IDEOGRAPH-5E5A
        0x5E5C, # G+12404  U+5E5C  uni5E5C,  CJK UNIFIED IDEOGRAPH-5E5C
        0x5E5D, # G+12405  U+5E5D  uni5E5D,  CJK UNIFIED IDEOGRAPH-5E5D
        0x5E60, # G+12406  U+5E60  uni5E60,  CJK UNIFIED IDEOGRAPH-5E60
        0x5E64, # G+12407  U+5E64  uni5E64,  CJK UNIFIED IDEOGRAPH-5E64
        0x5E65, # G+12408  U+5E65  uni5E65,  CJK UNIFIED IDEOGRAPH-5E65
        0x5E66, # G+12409  U+5E66  uni5E66,  CJK UNIFIED IDEOGRAPH-5E66
        0x5E67, # G+12410  U+5E67  uni5E67,  CJK UNIFIED IDEOGRAPH-5E67
        0x5E68, # G+12411  U+5E68  uni5E68,  CJK UNIFIED IDEOGRAPH-5E68
        0x5E69, # G+12412  U+5E69  uni5E69,  CJK UNIFIED IDEOGRAPH-5E69
        0x5E6A, # G+12413  U+5E6A  uni5E6A,  CJK UNIFIED IDEOGRAPH-5E6A
        0x5E6D, # G+12414  U+5E6D  uni5E6D,  CJK UNIFIED IDEOGRAPH-5E6D
        0x5E6E, # G+12415  U+5E6E  uni5E6E,  CJK UNIFIED IDEOGRAPH-5E6E
        0x5E6F, # G+12416  U+5E6F  uni5E6F,  CJK UNIFIED IDEOGRAPH-5E6F
        0x5E70, # G+12417  U+5E70  uni5E70,  CJK UNIFIED IDEOGRAPH-5E70
        0x5E71, # G+12418  U+5E71  uni5E71,  CJK UNIFIED IDEOGRAPH-5E71
        0x5E75, # G+12419  U+5E75  uni5E75,  CJK UNIFIED IDEOGRAPH-5E75
        0x5E77, # G+12420  U+5E77  uni5E77,  CJK UNIFIED IDEOGRAPH-5E77
        0x5E81, # G+12421  U+5E81  uni5E81,  CJK UNIFIED IDEOGRAPH-5E81
        0x5E82, # G+12422  U+5E82  uni5E82,  CJK UNIFIED IDEOGRAPH-5E82
        0x5E83, # G+12423  U+5E83  uni5E83,  CJK UNIFIED IDEOGRAPH-5E83
        0x5E85, # G+12424  U+5E85  uni5E85,  CJK UNIFIED IDEOGRAPH-5E85
        0x5E88, # G+12425  U+5E88  uni5E88,  CJK UNIFIED IDEOGRAPH-5E88
        0x5E89, # G+12426  U+5E89  uni5E89,  CJK UNIFIED IDEOGRAPH-5E89
        0x5E8C, # G+12427  U+5E8C  uni5E8C,  CJK UNIFIED IDEOGRAPH-5E8C
        0x5E8D, # G+12428  U+5E8D  uni5E8D,  CJK UNIFIED IDEOGRAPH-5E8D
        0x5E8E, # G+12429  U+5E8E  uni5E8E,  CJK UNIFIED IDEOGRAPH-5E8E
        0x5E92, # G+12430  U+5E92  uni5E92,  CJK UNIFIED IDEOGRAPH-5E92
        0x5E98, # G+12431  U+5E98  uni5E98,  CJK UNIFIED IDEOGRAPH-5E98
        0x5E9B, # G+12432  U+5E9B  uni5E9B,  CJK UNIFIED IDEOGRAPH-5E9B
        0x5E9D, # G+12433  U+5E9D  uni5E9D,  CJK UNIFIED IDEOGRAPH-5E9D
        0x5EA1, # G+12434  U+5EA1  uni5EA1,  CJK UNIFIED IDEOGRAPH-5EA1
        0x5EA2, # G+12435  U+5EA2  uni5EA2,  CJK UNIFIED IDEOGRAPH-5EA2
        0x5EA3, # G+12436  U+5EA3  uni5EA3,  CJK UNIFIED IDEOGRAPH-5EA3
        0x5EA4, # G+12437  U+5EA4  uni5EA4,  CJK UNIFIED IDEOGRAPH-5EA4
        0x5EA8, # G+12438  U+5EA8  uni5EA8,  CJK UNIFIED IDEOGRAPH-5EA8
        0x5EA9, # G+12439  U+5EA9  uni5EA9,  CJK UNIFIED IDEOGRAPH-5EA9
        0x5EAA, # G+12440  U+5EAA  uni5EAA,  CJK UNIFIED IDEOGRAPH-5EAA
        0x5EAC, # G+12441  U+5EAC  uni5EAC,  CJK UNIFIED IDEOGRAPH-5EAC
        0x5EAE, # G+12442  U+5EAE  uni5EAE,  CJK UNIFIED IDEOGRAPH-5EAE
        0x5EAF, # G+12443  U+5EAF  uni5EAF,  CJK UNIFIED IDEOGRAPH-5EAF
        0x5EB0, # G+12444  U+5EB0  uni5EB0,  CJK UNIFIED IDEOGRAPH-5EB0
        0x5EB1, # G+12445  U+5EB1  uni5EB1,  CJK UNIFIED IDEOGRAPH-5EB1
        0x5EB2, # G+12446  U+5EB2  uni5EB2,  CJK UNIFIED IDEOGRAPH-5EB2
        0x5EB4, # G+12447  U+5EB4  uni5EB4,  CJK UNIFIED IDEOGRAPH-5EB4
        0x5EBA, # G+12448  U+5EBA  uni5EBA,  CJK UNIFIED IDEOGRAPH-5EBA
        0x5EBB, # G+12449  U+5EBB  uni5EBB,  CJK UNIFIED IDEOGRAPH-5EBB
        0x5EBC, # G+12450  U+5EBC  uni5EBC,  CJK UNIFIED IDEOGRAPH-5EBC
        0x5EBD, # G+12451  U+5EBD  uni5EBD,  CJK UNIFIED IDEOGRAPH-5EBD
        0x5EBF, # G+12452  U+5EBF  uni5EBF,  CJK UNIFIED IDEOGRAPH-5EBF
        0x5EC0, # G+12453  U+5EC0  uni5EC0,  CJK UNIFIED IDEOGRAPH-5EC0
        0x5EC1, # G+12454  U+5EC1  uni5EC1,  CJK UNIFIED IDEOGRAPH-5EC1
        0x5EC2, # G+12455  U+5EC2  uni5EC2,  CJK UNIFIED IDEOGRAPH-5EC2
        0x5EC3, # G+12456  U+5EC3  uni5EC3,  CJK UNIFIED IDEOGRAPH-5EC3
        0x5EC4, # G+12457  U+5EC4  uni5EC4,  CJK UNIFIED IDEOGRAPH-5EC4
        0x5EC5, # G+12458  U+5EC5  uni5EC5,  CJK UNIFIED IDEOGRAPH-5EC5
        0x5EC6, # G+12459  U+5EC6  uni5EC6,  CJK UNIFIED IDEOGRAPH-5EC6
        0x5EC7, # G+12460  U+5EC7  uni5EC7,  CJK UNIFIED IDEOGRAPH-5EC7
        0x5EC8, # G+12461  U+5EC8  uni5EC8,  CJK UNIFIED IDEOGRAPH-5EC8
        0x5ECB, # G+12462  U+5ECB  uni5ECB,  CJK UNIFIED IDEOGRAPH-5ECB
        0x5ECC, # G+12463  U+5ECC  uni5ECC,  CJK UNIFIED IDEOGRAPH-5ECC
        0x5ECD, # G+12464  U+5ECD  uni5ECD,  CJK UNIFIED IDEOGRAPH-5ECD
        0x5ECE, # G+12465  U+5ECE  uni5ECE,  CJK UNIFIED IDEOGRAPH-5ECE
        0x5ECF, # G+12466  U+5ECF  uni5ECF,  CJK UNIFIED IDEOGRAPH-5ECF
        0x5ED0, # G+12467  U+5ED0  uni5ED0,  CJK UNIFIED IDEOGRAPH-5ED0
        0x5ED4, # G+12468  U+5ED4  uni5ED4,  CJK UNIFIED IDEOGRAPH-5ED4
        0x5ED5, # G+12469  U+5ED5  uni5ED5,  CJK UNIFIED IDEOGRAPH-5ED5
        0x5ED7, # G+12470  U+5ED7  uni5ED7,  CJK UNIFIED IDEOGRAPH-5ED7
        0x5ED8, # G+12471  U+5ED8  uni5ED8,  CJK UNIFIED IDEOGRAPH-5ED8
        0x5ED9, # G+12472  U+5ED9  uni5ED9,  CJK UNIFIED IDEOGRAPH-5ED9
        0x5EDA, # G+12473  U+5EDA  uni5EDA,  CJK UNIFIED IDEOGRAPH-5EDA
        0x5EDC, # G+12474  U+5EDC  uni5EDC,  CJK UNIFIED IDEOGRAPH-5EDC
        0x5EDD, # G+12475  U+5EDD  uni5EDD,  CJK UNIFIED IDEOGRAPH-5EDD
        0x5EDE, # G+12476  U+5EDE  uni5EDE,  CJK UNIFIED IDEOGRAPH-5EDE
        0x5EE4, # G+12477  U+5EE4  uni5EE4,  CJK UNIFIED IDEOGRAPH-5EE4
        0x5EE5, # G+12478  U+5EE5  uni5EE5,  CJK UNIFIED IDEOGRAPH-5EE5
        0x5EE6, # G+12479  U+5EE6  uni5EE6,  CJK UNIFIED IDEOGRAPH-5EE6
        0x5EE7, # G+12480  U+5EE7  uni5EE7,  CJK UNIFIED IDEOGRAPH-5EE7
        0x5EE9, # G+12481  U+5EE9  uni5EE9,  CJK UNIFIED IDEOGRAPH-5EE9
        0x5EEB, # G+12482  U+5EEB  uni5EEB,  CJK UNIFIED IDEOGRAPH-5EEB
        0x5EED, # G+12483  U+5EED  uni5EED,  CJK UNIFIED IDEOGRAPH-5EED
        0x5EEE, # G+12484  U+5EEE  uni5EEE,  CJK UNIFIED IDEOGRAPH-5EEE
        0x5EEF, # G+12485  U+5EEF  uni5EEF,  CJK UNIFIED IDEOGRAPH-5EEF
        0x5EF0, # G+12486  U+5EF0  uni5EF0,  CJK UNIFIED IDEOGRAPH-5EF0
        0x5EF1, # G+12487  U+5EF1  uni5EF1,  CJK UNIFIED IDEOGRAPH-5EF1
        0x5EF2, # G+12488  U+5EF2  uni5EF2,  CJK UNIFIED IDEOGRAPH-5EF2
        0x5EF5, # G+12489  U+5EF5  uni5EF5,  CJK UNIFIED IDEOGRAPH-5EF5
        0x5EF8, # G+12490  U+5EF8  uni5EF8,  CJK UNIFIED IDEOGRAPH-5EF8
        0x5EF9, # G+12491  U+5EF9  uni5EF9,  CJK UNIFIED IDEOGRAPH-5EF9
        0x5EFB, # G+12492  U+5EFB  uni5EFB,  CJK UNIFIED IDEOGRAPH-5EFB
        0x5EFC, # G+12493  U+5EFC  uni5EFC,  CJK UNIFIED IDEOGRAPH-5EFC
        0x5EFD, # G+12494  U+5EFD  uni5EFD,  CJK UNIFIED IDEOGRAPH-5EFD
        0x5F05, # G+12495  U+5F05  uni5F05,  CJK UNIFIED IDEOGRAPH-5F05
        0x5F06, # G+12496  U+5F06  uni5F06,  CJK UNIFIED IDEOGRAPH-5F06
        0x5F07, # G+12497  U+5F07  uni5F07,  CJK UNIFIED IDEOGRAPH-5F07
        0x5F09, # G+12498  U+5F09  uni5F09,  CJK UNIFIED IDEOGRAPH-5F09
        0x5F0C, # G+12499  U+5F0C  uni5F0C,  CJK UNIFIED IDEOGRAPH-5F0C
        0x5F0D, # G+12500  U+5F0D  uni5F0D,  CJK UNIFIED IDEOGRAPH-5F0D
        0x5F0E, # G+12501  U+5F0E  uni5F0E,  CJK UNIFIED IDEOGRAPH-5F0E
        0x5F10, # G+12502  U+5F10  uni5F10,  CJK UNIFIED IDEOGRAPH-5F10
        0x5F12, # G+12503  U+5F12  uni5F12,  CJK UNIFIED IDEOGRAPH-5F12
        0x5F14, # G+12504  U+5F14  uni5F14,  CJK UNIFIED IDEOGRAPH-5F14
        0x5F16, # G+12505  U+5F16  uni5F16,  CJK UNIFIED IDEOGRAPH-5F16
        0x5F19, # G+12506  U+5F19  uni5F19,  CJK UNIFIED IDEOGRAPH-5F19
        0x5F1A, # G+12507  U+5F1A  uni5F1A,  CJK UNIFIED IDEOGRAPH-5F1A
        0x5F1C, # G+12508  U+5F1C  uni5F1C,  CJK UNIFIED IDEOGRAPH-5F1C
        0x5F1D, # G+12509  U+5F1D  uni5F1D,  CJK UNIFIED IDEOGRAPH-5F1D
        0x5F1E, # G+12510  U+5F1E  uni5F1E,  CJK UNIFIED IDEOGRAPH-5F1E
        0x5F21, # G+12511  U+5F21  uni5F21,  CJK UNIFIED IDEOGRAPH-5F21
        0x5F22, # G+12512  U+5F22  uni5F22,  CJK UNIFIED IDEOGRAPH-5F22
        0x5F23, # G+12513  U+5F23  uni5F23,  CJK UNIFIED IDEOGRAPH-5F23
        0x5F24, # G+12514  U+5F24  uni5F24,  CJK UNIFIED IDEOGRAPH-5F24
        0x5F28, # G+12515  U+5F28  uni5F28,  CJK UNIFIED IDEOGRAPH-5F28
        0x5F2B, # G+12516  U+5F2B  uni5F2B,  CJK UNIFIED IDEOGRAPH-5F2B
        0x5F2C, # G+12517  U+5F2C  uni5F2C,  CJK UNIFIED IDEOGRAPH-5F2C
        0x5F2E, # G+12518  U+5F2E  uni5F2E,  CJK UNIFIED IDEOGRAPH-5F2E
        0x5F30, # G+12519  U+5F30  uni5F30,  CJK UNIFIED IDEOGRAPH-5F30
        0x5F32, # G+12520  U+5F32  uni5F32,  CJK UNIFIED IDEOGRAPH-5F32
        0x5F34, # G+12521  U+5F34  uni5F34,  CJK UNIFIED IDEOGRAPH-5F34
        0x5F36, # G+12522  U+5F36  uni5F36,  CJK UNIFIED IDEOGRAPH-5F36
        0x5F37, # G+12523  U+5F37  uni5F37,  CJK UNIFIED IDEOGRAPH-5F37
        0x5F38, # G+12524  U+5F38  uni5F38,  CJK UNIFIED IDEOGRAPH-5F38
        0x5F3B, # G+12525  U+5F3B  uni5F3B,  CJK UNIFIED IDEOGRAPH-5F3B
        0x5F3D, # G+12526  U+5F3D  uni5F3D,  CJK UNIFIED IDEOGRAPH-5F3D
        0x5F3E, # G+12527  U+5F3E  uni5F3E,  CJK UNIFIED IDEOGRAPH-5F3E
        0x5F3F, # G+12528  U+5F3F  uni5F3F,  CJK UNIFIED IDEOGRAPH-5F3F
        0x5F41, # G+12529  U+5F41  uni5F41,  CJK UNIFIED IDEOGRAPH-5F41
        0x5F42, # G+12530  U+5F42  uni5F42,  CJK UNIFIED IDEOGRAPH-5F42
        0x5F43, # G+12531  U+5F43  uni5F43,  CJK UNIFIED IDEOGRAPH-5F43
        0x5F44, # G+12532  U+5F44  uni5F44,  CJK UNIFIED IDEOGRAPH-5F44
        0x5F45, # G+12533  U+5F45  uni5F45,  CJK UNIFIED IDEOGRAPH-5F45
        0x5F47, # G+12534  U+5F47  uni5F47,  CJK UNIFIED IDEOGRAPH-5F47
        0x5F49, # G+12535  U+5F49  uni5F49,  CJK UNIFIED IDEOGRAPH-5F49
        0x5F4A, # G+12536  U+5F4A  uni5F4A,  CJK UNIFIED IDEOGRAPH-5F4A
        0x5F4B, # G+12537  U+5F4B  uni5F4B,  CJK UNIFIED IDEOGRAPH-5F4B
        0x5F4D, # G+12538  U+5F4D  uni5F4D,  CJK UNIFIED IDEOGRAPH-5F4D
        0x5F4F, # G+12539  U+5F4F  uni5F4F,  CJK UNIFIED IDEOGRAPH-5F4F
        0x5F51, # G+12540  U+5F51  uni5F51,  CJK UNIFIED IDEOGRAPH-5F51
        0x5F54, # G+12541  U+5F54  uni5F54,  CJK UNIFIED IDEOGRAPH-5F54
        0x5F5A, # G+12542  U+5F5A  uni5F5A,  CJK UNIFIED IDEOGRAPH-5F5A
        0x5F5B, # G+12543  U+5F5B  uni5F5B,  CJK UNIFIED IDEOGRAPH-5F5B
        0x5F5C, # G+12544  U+5F5C  uni5F5C,  CJK UNIFIED IDEOGRAPH-5F5C
        0x5F5E, # G+12545  U+5F5E  uni5F5E,  CJK UNIFIED IDEOGRAPH-5F5E
        0x5F5F, # G+12546  U+5F5F  uni5F5F,  CJK UNIFIED IDEOGRAPH-5F5F
        0x5F60, # G+12547  U+5F60  uni5F60,  CJK UNIFIED IDEOGRAPH-5F60
        0x5F63, # G+12548  U+5F63  uni5F63,  CJK UNIFIED IDEOGRAPH-5F63
        0x5F65, # G+12549  U+5F65  uni5F65,  CJK UNIFIED IDEOGRAPH-5F65
        0x5F67, # G+12550  U+5F67  uni5F67,  CJK UNIFIED IDEOGRAPH-5F67
        0x5F68, # G+12551  U+5F68  uni5F68,  CJK UNIFIED IDEOGRAPH-5F68
        0x5F6B, # G+12552  U+5F6B  uni5F6B,  CJK UNIFIED IDEOGRAPH-5F6B
        0x5F6E, # G+12553  U+5F6E  uni5F6E,  CJK UNIFIED IDEOGRAPH-5F6E
        0x5F6F, # G+12554  U+5F6F  uni5F6F,  CJK UNIFIED IDEOGRAPH-5F6F
        0x5F72, # G+12555  U+5F72  uni5F72,  CJK UNIFIED IDEOGRAPH-5F72
        0x5F74, # G+12556  U+5F74  uni5F74,  CJK UNIFIED IDEOGRAPH-5F74
        0x5F75, # G+12557  U+5F75  uni5F75,  CJK UNIFIED IDEOGRAPH-5F75
        0x5F76, # G+12558  U+5F76  uni5F76,  CJK UNIFIED IDEOGRAPH-5F76
        0x5F78, # G+12559  U+5F78  uni5F78,  CJK UNIFIED IDEOGRAPH-5F78
        0x5F7A, # G+12560  U+5F7A  uni5F7A,  CJK UNIFIED IDEOGRAPH-5F7A
        0x5F7D, # G+12561  U+5F7D  uni5F7D,  CJK UNIFIED IDEOGRAPH-5F7D
        0x5F7E, # G+12562  U+5F7E  uni5F7E,  CJK UNIFIED IDEOGRAPH-5F7E
        0x5F7F, # G+12563  U+5F7F  uni5F7F,  CJK UNIFIED IDEOGRAPH-5F7F
        0x5F83, # G+12564  U+5F83  uni5F83,  CJK UNIFIED IDEOGRAPH-5F83
        0x5F86, # G+12565  U+5F86  uni5F86,  CJK UNIFIED IDEOGRAPH-5F86
        0x5F8D, # G+12566  U+5F8D  uni5F8D,  CJK UNIFIED IDEOGRAPH-5F8D
        0x5F8E, # G+12567  U+5F8E  uni5F8E,  CJK UNIFIED IDEOGRAPH-5F8E
        0x5F8F, # G+12568  U+5F8F  uni5F8F,  CJK UNIFIED IDEOGRAPH-5F8F
        0x5F93, # G+12569  U+5F93  uni5F93,  CJK UNIFIED IDEOGRAPH-5F93
        0x5F94, # G+12570  U+5F94  uni5F94,  CJK UNIFIED IDEOGRAPH-5F94
        0x5F96, # G+12571  U+5F96  uni5F96,  CJK UNIFIED IDEOGRAPH-5F96
        0x5F9A, # G+12572  U+5F9A  uni5F9A,  CJK UNIFIED IDEOGRAPH-5F9A
        0x5F9B, # G+12573  U+5F9B  uni5F9B,  CJK UNIFIED IDEOGRAPH-5F9B
        0x5F9D, # G+12574  U+5F9D  uni5F9D,  CJK UNIFIED IDEOGRAPH-5F9D
        0x5F9F, # G+12575  U+5F9F  uni5F9F,  CJK UNIFIED IDEOGRAPH-5F9F
        0x5FA2, # G+12576  U+5FA2  uni5FA2,  CJK UNIFIED IDEOGRAPH-5FA2
        0x5FA3, # G+12577  U+5FA3  uni5FA3,  CJK UNIFIED IDEOGRAPH-5FA3
        0x5FA4, # G+12578  U+5FA4  uni5FA4,  CJK UNIFIED IDEOGRAPH-5FA4
        0x5FA5, # G+12579  U+5FA5  uni5FA5,  CJK UNIFIED IDEOGRAPH-5FA5
        0x5FA6, # G+12580  U+5FA6  uni5FA6,  CJK UNIFIED IDEOGRAPH-5FA6
        0x5FA7, # G+12581  U+5FA7  uni5FA7,  CJK UNIFIED IDEOGRAPH-5FA7
        0x5FAB, # G+12582  U+5FAB  uni5FAB,  CJK UNIFIED IDEOGRAPH-5FAB
        0x5FAC, # G+12583  U+5FAC  uni5FAC,  CJK UNIFIED IDEOGRAPH-5FAC
        0x5FAF, # G+12584  U+5FAF  uni5FAF,  CJK UNIFIED IDEOGRAPH-5FAF
        0x5FB0, # G+12585  U+5FB0  uni5FB0,  CJK UNIFIED IDEOGRAPH-5FB0
        0x5FB1, # G+12586  U+5FB1  uni5FB1,  CJK UNIFIED IDEOGRAPH-5FB1
        0x5FB2, # G+12587  U+5FB2  uni5FB2,  CJK UNIFIED IDEOGRAPH-5FB2
        0x5FB3, # G+12588  U+5FB3  uni5FB3,  CJK UNIFIED IDEOGRAPH-5FB3
        0x5FB4, # G+12589  U+5FB4  uni5FB4,  CJK UNIFIED IDEOGRAPH-5FB4
        0x5FB6, # G+12590  U+5FB6  uni5FB6,  CJK UNIFIED IDEOGRAPH-5FB6
        0x5FB8, # G+12591  U+5FB8  uni5FB8,  CJK UNIFIED IDEOGRAPH-5FB8
        0x5FBA, # G+12592  U+5FBA  uni5FBA,  CJK UNIFIED IDEOGRAPH-5FBA
        0x5FBB, # G+12593  U+5FBB  uni5FBB,  CJK UNIFIED IDEOGRAPH-5FBB
        0x5FBE, # G+12594  U+5FBE  uni5FBE,  CJK UNIFIED IDEOGRAPH-5FBE
        0x5FBF, # G+12595  U+5FBF  uni5FBF,  CJK UNIFIED IDEOGRAPH-5FBF
        0x5FC0, # G+12596  U+5FC0  uni5FC0,  CJK UNIFIED IDEOGRAPH-5FC0
        0x5FC1, # G+12597  U+5FC1  uni5FC1,  CJK UNIFIED IDEOGRAPH-5FC1
        0x5FC2, # G+12598  U+5FC2  uni5FC2,  CJK UNIFIED IDEOGRAPH-5FC2
        0x5FC7, # G+12599  U+5FC7  uni5FC7,  CJK UNIFIED IDEOGRAPH-5FC7
        0x5FC8, # G+12600  U+5FC8  uni5FC8,  CJK UNIFIED IDEOGRAPH-5FC8
        0x5FCA, # G+12601  U+5FCA  uni5FCA,  CJK UNIFIED IDEOGRAPH-5FCA
        0x5FCB, # G+12602  U+5FCB  uni5FCB,  CJK UNIFIED IDEOGRAPH-5FCB
        0x5FCE, # G+12603  U+5FCE  uni5FCE,  CJK UNIFIED IDEOGRAPH-5FCE
        0x5FD3, # G+12604  U+5FD3  uni5FD3,  CJK UNIFIED IDEOGRAPH-5FD3
        0x5FD4, # G+12605  U+5FD4  uni5FD4,  CJK UNIFIED IDEOGRAPH-5FD4
        0x5FD5, # G+12606  U+5FD5  uni5FD5,  CJK UNIFIED IDEOGRAPH-5FD5
        0x5FDA, # G+12607  U+5FDA  uni5FDA,  CJK UNIFIED IDEOGRAPH-5FDA
        0x5FDB, # G+12608  U+5FDB  uni5FDB,  CJK UNIFIED IDEOGRAPH-5FDB
        0x5FDC, # G+12609  U+5FDC  uni5FDC,  CJK UNIFIED IDEOGRAPH-5FDC
        0x5FDE, # G+12610  U+5FDE  uni5FDE,  CJK UNIFIED IDEOGRAPH-5FDE
        0x5FDF, # G+12611  U+5FDF  uni5FDF,  CJK UNIFIED IDEOGRAPH-5FDF
        0x5FE2, # G+12612  U+5FE2  uni5FE2,  CJK UNIFIED IDEOGRAPH-5FE2
        0x5FE3, # G+12613  U+5FE3  uni5FE3,  CJK UNIFIED IDEOGRAPH-5FE3
        0x5FE5, # G+12614  U+5FE5  uni5FE5,  CJK UNIFIED IDEOGRAPH-5FE5
        0x5FE6, # G+12615  U+5FE6  uni5FE6,  CJK UNIFIED IDEOGRAPH-5FE6
        0x5FE8, # G+12616  U+5FE8  uni5FE8,  CJK UNIFIED IDEOGRAPH-5FE8
        0x5FE9, # G+12617  U+5FE9  uni5FE9,  CJK UNIFIED IDEOGRAPH-5FE9
        0x5FEC, # G+12618  U+5FEC  uni5FEC,  CJK UNIFIED IDEOGRAPH-5FEC
        0x5FEF, # G+12619  U+5FEF  uni5FEF,  CJK UNIFIED IDEOGRAPH-5FEF
        0x5FF0, # G+12620  U+5FF0  uni5FF0,  CJK UNIFIED IDEOGRAPH-5FF0
        0x5FF2, # G+12621  U+5FF2  uni5FF2,  CJK UNIFIED IDEOGRAPH-5FF2
        0x5FF3, # G+12622  U+5FF3  uni5FF3,  CJK UNIFIED IDEOGRAPH-5FF3
        0x5FF4, # G+12623  U+5FF4  uni5FF4,  CJK UNIFIED IDEOGRAPH-5FF4
        0x5FF6, # G+12624  U+5FF6  uni5FF6,  CJK UNIFIED IDEOGRAPH-5FF6
        0x5FF7, # G+12625  U+5FF7  uni5FF7,  CJK UNIFIED IDEOGRAPH-5FF7
        0x5FF9, # G+12626  U+5FF9  uni5FF9,  CJK UNIFIED IDEOGRAPH-5FF9
        0x5FFA, # G+12627  U+5FFA  uni5FFA,  CJK UNIFIED IDEOGRAPH-5FFA
        0x5FFC, # G+12628  U+5FFC  uni5FFC,  CJK UNIFIED IDEOGRAPH-5FFC
        0x6007, # G+12629  U+6007  uni6007,  CJK UNIFIED IDEOGRAPH-6007
        0x6008, # G+12630  U+6008  uni6008,  CJK UNIFIED IDEOGRAPH-6008
        0x6009, # G+12631  U+6009  uni6009,  CJK UNIFIED IDEOGRAPH-6009
        0x600B, # G+12632  U+600B  uni600B,  CJK UNIFIED IDEOGRAPH-600B
        0x600C, # G+12633  U+600C  uni600C,  CJK UNIFIED IDEOGRAPH-600C
        0x6010, # G+12634  U+6010  uni6010,  CJK UNIFIED IDEOGRAPH-6010
        0x6011, # G+12635  U+6011  uni6011,  CJK UNIFIED IDEOGRAPH-6011
        0x6013, # G+12636  U+6013  uni6013,  CJK UNIFIED IDEOGRAPH-6013
        0x6017, # G+12637  U+6017  uni6017,  CJK UNIFIED IDEOGRAPH-6017
        0x6018, # G+12638  U+6018  uni6018,  CJK UNIFIED IDEOGRAPH-6018
        0x601A, # G+12639  U+601A  uni601A,  CJK UNIFIED IDEOGRAPH-601A
        0x601E, # G+12640  U+601E  uni601E,  CJK UNIFIED IDEOGRAPH-601E
        0x601F, # G+12641  U+601F  uni601F,  CJK UNIFIED IDEOGRAPH-601F
        0x6022, # G+12642  U+6022  uni6022,  CJK UNIFIED IDEOGRAPH-6022
        0x6023, # G+12643  U+6023  uni6023,  CJK UNIFIED IDEOGRAPH-6023
        0x6024, # G+12644  U+6024  uni6024,  CJK UNIFIED IDEOGRAPH-6024
        0x602C, # G+12645  U+602C  uni602C,  CJK UNIFIED IDEOGRAPH-602C
        0x602D, # G+12646  U+602D  uni602D,  CJK UNIFIED IDEOGRAPH-602D
        0x602E, # G+12647  U+602E  uni602E,  CJK UNIFIED IDEOGRAPH-602E
        0x6030, # G+12648  U+6030  uni6030,  CJK UNIFIED IDEOGRAPH-6030
        0x6031, # G+12649  U+6031  uni6031,  CJK UNIFIED IDEOGRAPH-6031
        0x6032, # G+12650  U+6032  uni6032,  CJK UNIFIED IDEOGRAPH-6032
        0x6033, # G+12651  U+6033  uni6033,  CJK UNIFIED IDEOGRAPH-6033
        0x6034, # G+12652  U+6034  uni6034,  CJK UNIFIED IDEOGRAPH-6034
        0x6036, # G+12653  U+6036  uni6036,  CJK UNIFIED IDEOGRAPH-6036
        0x6037, # G+12654  U+6037  uni6037,  CJK UNIFIED IDEOGRAPH-6037
        0x6038, # G+12655  U+6038  uni6038,  CJK UNIFIED IDEOGRAPH-6038
        0x6039, # G+12656  U+6039  uni6039,  CJK UNIFIED IDEOGRAPH-6039
        0x603A, # G+12657  U+603A  uni603A,  CJK UNIFIED IDEOGRAPH-603A
        0x603D, # G+12658  U+603D  uni603D,  CJK UNIFIED IDEOGRAPH-603D
        0x603E, # G+12659  U+603E  uni603E,  CJK UNIFIED IDEOGRAPH-603E
        0x6040, # G+12660  U+6040  uni6040,  CJK UNIFIED IDEOGRAPH-6040
        0x6044, # G+12661  U+6044  uni6044,  CJK UNIFIED IDEOGRAPH-6044
        0x6045, # G+12662  U+6045  uni6045,  CJK UNIFIED IDEOGRAPH-6045
        0x6046, # G+12663  U+6046  uni6046,  CJK UNIFIED IDEOGRAPH-6046
        0x6047, # G+12664  U+6047  uni6047,  CJK UNIFIED IDEOGRAPH-6047
        0x6048, # G+12665  U+6048  uni6048,  CJK UNIFIED IDEOGRAPH-6048
        0x6049, # G+12666  U+6049  uni6049,  CJK UNIFIED IDEOGRAPH-6049
        0x604A, # G+12667  U+604A  uni604A,  CJK UNIFIED IDEOGRAPH-604A
        0x604C, # G+12668  U+604C  uni604C,  CJK UNIFIED IDEOGRAPH-604C
        0x604E, # G+12669  U+604E  uni604E,  CJK UNIFIED IDEOGRAPH-604E
        0x604F, # G+12670  U+604F  uni604F,  CJK UNIFIED IDEOGRAPH-604F
        0x6051, # G+12671  U+6051  uni6051,  CJK UNIFIED IDEOGRAPH-6051
        0x6053, # G+12672  U+6053  uni6053,  CJK UNIFIED IDEOGRAPH-6053
        0x6054, # G+12673  U+6054  uni6054,  CJK UNIFIED IDEOGRAPH-6054
        0x6056, # G+12674  U+6056  uni6056,  CJK UNIFIED IDEOGRAPH-6056
        0x6057, # G+12675  U+6057  uni6057,  CJK UNIFIED IDEOGRAPH-6057
        0x6058, # G+12676  U+6058  uni6058,  CJK UNIFIED IDEOGRAPH-6058
        0x605B, # G+12677  U+605B  uni605B,  CJK UNIFIED IDEOGRAPH-605B
        0x605C, # G+12678  U+605C  uni605C,  CJK UNIFIED IDEOGRAPH-605C
        0x605E, # G+12679  U+605E  uni605E,  CJK UNIFIED IDEOGRAPH-605E
        0x605F, # G+12680  U+605F  uni605F,  CJK UNIFIED IDEOGRAPH-605F
        0x6060, # G+12681  U+6060  uni6060,  CJK UNIFIED IDEOGRAPH-6060
        0x6061, # G+12682  U+6061  uni6061,  CJK UNIFIED IDEOGRAPH-6061
        0x6065, # G+12683  U+6065  uni6065,  CJK UNIFIED IDEOGRAPH-6065
        0x6066, # G+12684  U+6066  uni6066,  CJK UNIFIED IDEOGRAPH-6066
        0x606E, # G+12685  U+606E  uni606E,  CJK UNIFIED IDEOGRAPH-606E
        0x6071, # G+12686  U+6071  uni6071,  CJK UNIFIED IDEOGRAPH-6071
        0x6072, # G+12687  U+6072  uni6072,  CJK UNIFIED IDEOGRAPH-6072
        0x6074, # G+12688  U+6074  uni6074,  CJK UNIFIED IDEOGRAPH-6074
        0x6075, # G+12689  U+6075  uni6075,  CJK UNIFIED IDEOGRAPH-6075
        0x6077, # G+12690  U+6077  uni6077,  CJK UNIFIED IDEOGRAPH-6077
        0x607E, # G+12691  U+607E  uni607E,  CJK UNIFIED IDEOGRAPH-607E
        0x6080, # G+12692  U+6080  uni6080,  CJK UNIFIED IDEOGRAPH-6080
        0x6081, # G+12693  U+6081  uni6081,  CJK UNIFIED IDEOGRAPH-6081
        0x6082, # G+12694  U+6082  uni6082,  CJK UNIFIED IDEOGRAPH-6082
        0x6085, # G+12695  U+6085  uni6085,  CJK UNIFIED IDEOGRAPH-6085
        0x6086, # G+12696  U+6086  uni6086,  CJK UNIFIED IDEOGRAPH-6086
        0x6087, # G+12697  U+6087  uni6087,  CJK UNIFIED IDEOGRAPH-6087
        0x6088, # G+12698  U+6088  uni6088,  CJK UNIFIED IDEOGRAPH-6088
        0x608A, # G+12699  U+608A  uni608A,  CJK UNIFIED IDEOGRAPH-608A
        0x608B, # G+12700  U+608B  uni608B,  CJK UNIFIED IDEOGRAPH-608B
        0x608E, # G+12701  U+608E  uni608E,  CJK UNIFIED IDEOGRAPH-608E
        0x608F, # G+12702  U+608F  uni608F,  CJK UNIFIED IDEOGRAPH-608F
        0x6090, # G+12703  U+6090  uni6090,  CJK UNIFIED IDEOGRAPH-6090
        0x6091, # G+12704  U+6091  uni6091,  CJK UNIFIED IDEOGRAPH-6091
        0x6093, # G+12705  U+6093  uni6093,  CJK UNIFIED IDEOGRAPH-6093
        0x6095, # G+12706  U+6095  uni6095,  CJK UNIFIED IDEOGRAPH-6095
        0x6097, # G+12707  U+6097  uni6097,  CJK UNIFIED IDEOGRAPH-6097
        0x6098, # G+12708  U+6098  uni6098,  CJK UNIFIED IDEOGRAPH-6098
        0x6099, # G+12709  U+6099  uni6099,  CJK UNIFIED IDEOGRAPH-6099
        0x609C, # G+12710  U+609C  uni609C,  CJK UNIFIED IDEOGRAPH-609C
        0x609E, # G+12711  U+609E  uni609E,  CJK UNIFIED IDEOGRAPH-609E
        0x60A1, # G+12712  U+60A1  uni60A1,  CJK UNIFIED IDEOGRAPH-60A1
        0x60A2, # G+12713  U+60A2  uni60A2,  CJK UNIFIED IDEOGRAPH-60A2
        0x60A4, # G+12714  U+60A4  uni60A4,  CJK UNIFIED IDEOGRAPH-60A4
        0x60A5, # G+12715  U+60A5  uni60A5,  CJK UNIFIED IDEOGRAPH-60A5
        0x60A7, # G+12716  U+60A7  uni60A7,  CJK UNIFIED IDEOGRAPH-60A7
        0x60A9, # G+12717  U+60A9  uni60A9,  CJK UNIFIED IDEOGRAPH-60A9
        0x60AA, # G+12718  U+60AA  uni60AA,  CJK UNIFIED IDEOGRAPH-60AA
        0x60AE, # G+12719  U+60AE  uni60AE,  CJK UNIFIED IDEOGRAPH-60AE
        0x60B0, # G+12720  U+60B0  uni60B0,  CJK UNIFIED IDEOGRAPH-60B0
        0x60B3, # G+12721  U+60B3  uni60B3,  CJK UNIFIED IDEOGRAPH-60B3
        0x60B7, # G+12722  U+60B7  uni60B7,  CJK UNIFIED IDEOGRAPH-60B7
        0x60B9, # G+12723  U+60B9  uni60B9,  CJK UNIFIED IDEOGRAPH-60B9
        0x60BA, # G+12724  U+60BA  uni60BA,  CJK UNIFIED IDEOGRAPH-60BA
        0x60BD, # G+12725  U+60BD  uni60BD,  CJK UNIFIED IDEOGRAPH-60BD
        0x60BE, # G+12726  U+60BE  uni60BE,  CJK UNIFIED IDEOGRAPH-60BE
        0x60BF, # G+12727  U+60BF  uni60BF,  CJK UNIFIED IDEOGRAPH-60BF
        0x60C0, # G+12728  U+60C0  uni60C0,  CJK UNIFIED IDEOGRAPH-60C0
        0x60C1, # G+12729  U+60C1  uni60C1,  CJK UNIFIED IDEOGRAPH-60C1
        0x60C2, # G+12730  U+60C2  uni60C2,  CJK UNIFIED IDEOGRAPH-60C2
        0x60C3, # G+12731  U+60C3  uni60C3,  CJK UNIFIED IDEOGRAPH-60C3
        0x60C4, # G+12732  U+60C4  uni60C4,  CJK UNIFIED IDEOGRAPH-60C4
        0x60C7, # G+12733  U+60C7  uni60C7,  CJK UNIFIED IDEOGRAPH-60C7
        0x60C8, # G+12734  U+60C8  uni60C8,  CJK UNIFIED IDEOGRAPH-60C8
        0x60C9, # G+12735  U+60C9  uni60C9,  CJK UNIFIED IDEOGRAPH-60C9
        0x60CC, # G+12736  U+60CC  uni60CC,  CJK UNIFIED IDEOGRAPH-60CC
        0x60CD, # G+12737  U+60CD  uni60CD,  CJK UNIFIED IDEOGRAPH-60CD
        0x60CE, # G+12738  U+60CE  uni60CE,  CJK UNIFIED IDEOGRAPH-60CE
        0x60CF, # G+12739  U+60CF  uni60CF,  CJK UNIFIED IDEOGRAPH-60CF
        0x60D0, # G+12740  U+60D0  uni60D0,  CJK UNIFIED IDEOGRAPH-60D0
        0x60D2, # G+12741  U+60D2  uni60D2,  CJK UNIFIED IDEOGRAPH-60D2
        0x60D3, # G+12742  U+60D3  uni60D3,  CJK UNIFIED IDEOGRAPH-60D3
        0x60D4, # G+12743  U+60D4  uni60D4,  CJK UNIFIED IDEOGRAPH-60D4
        0x60D6, # G+12744  U+60D6  uni60D6,  CJK UNIFIED IDEOGRAPH-60D6
        0x60D7, # G+12745  U+60D7  uni60D7,  CJK UNIFIED IDEOGRAPH-60D7
        0x60D9, # G+12746  U+60D9  uni60D9,  CJK UNIFIED IDEOGRAPH-60D9
        0x60DB, # G+12747  U+60DB  uni60DB,  CJK UNIFIED IDEOGRAPH-60DB
        0x60DE, # G+12748  U+60DE  uni60DE,  CJK UNIFIED IDEOGRAPH-60DE
        0x60E2, # G+12749  U+60E2  uni60E2,  CJK UNIFIED IDEOGRAPH-60E2
        0x60E3, # G+12750  U+60E3  uni60E3,  CJK UNIFIED IDEOGRAPH-60E3
        0x60E4, # G+12751  U+60E4  uni60E4,  CJK UNIFIED IDEOGRAPH-60E4
        0x60E5, # G+12752  U+60E5  uni60E5,  CJK UNIFIED IDEOGRAPH-60E5
        0x60EA, # G+12753  U+60EA  uni60EA,  CJK UNIFIED IDEOGRAPH-60EA
        0x60F5, # G+12754  U+60F5  uni60F5,  CJK UNIFIED IDEOGRAPH-60F5
        0x60F7, # G+12755  U+60F7  uni60F7,  CJK UNIFIED IDEOGRAPH-60F7
        0x60F8, # G+12756  U+60F8  uni60F8,  CJK UNIFIED IDEOGRAPH-60F8
        0x60FC, # G+12757  U+60FC  uni60FC,  CJK UNIFIED IDEOGRAPH-60FC
        0x60FD, # G+12758  U+60FD  uni60FD,  CJK UNIFIED IDEOGRAPH-60FD
        0x60FE, # G+12759  U+60FE  uni60FE,  CJK UNIFIED IDEOGRAPH-60FE
        0x60FF, # G+12760  U+60FF  uni60FF,  CJK UNIFIED IDEOGRAPH-60FF
        0x6102, # G+12761  U+6102  uni6102,  CJK UNIFIED IDEOGRAPH-6102
        0x6103, # G+12762  U+6103  uni6103,  CJK UNIFIED IDEOGRAPH-6103
        0x6104, # G+12763  U+6104  uni6104,  CJK UNIFIED IDEOGRAPH-6104
        0x6105, # G+12764  U+6105  uni6105,  CJK UNIFIED IDEOGRAPH-6105
        0x6107, # G+12765  U+6107  uni6107,  CJK UNIFIED IDEOGRAPH-6107
        0x610A, # G+12766  U+610A  uni610A,  CJK UNIFIED IDEOGRAPH-610A
        0x610B, # G+12767  U+610B  uni610B,  CJK UNIFIED IDEOGRAPH-610B
        0x610C, # G+12768  U+610C  uni610C,  CJK UNIFIED IDEOGRAPH-610C
        0x6110, # G+12769  U+6110  uni6110,  CJK UNIFIED IDEOGRAPH-6110
        0x6111, # G+12770  U+6111  uni6111,  CJK UNIFIED IDEOGRAPH-6111
        0x6112, # G+12771  U+6112  uni6112,  CJK UNIFIED IDEOGRAPH-6112
        0x6113, # G+12772  U+6113  uni6113,  CJK UNIFIED IDEOGRAPH-6113
        0x6114, # G+12773  U+6114  uni6114,  CJK UNIFIED IDEOGRAPH-6114
        0x6116, # G+12774  U+6116  uni6116,  CJK UNIFIED IDEOGRAPH-6116
        0x6117, # G+12775  U+6117  uni6117,  CJK UNIFIED IDEOGRAPH-6117
        0x6118, # G+12776  U+6118  uni6118,  CJK UNIFIED IDEOGRAPH-6118
        0x6119, # G+12777  U+6119  uni6119,  CJK UNIFIED IDEOGRAPH-6119
        0x611D, # G+12778  U+611D  uni611D,  CJK UNIFIED IDEOGRAPH-611D
        0x611E, # G+12779  U+611E  uni611E,  CJK UNIFIED IDEOGRAPH-611E
        0x6121, # G+12780  U+6121  uni6121,  CJK UNIFIED IDEOGRAPH-6121
        0x6122, # G+12781  U+6122  uni6122,  CJK UNIFIED IDEOGRAPH-6122
        0x6125, # G+12782  U+6125  uni6125,  CJK UNIFIED IDEOGRAPH-6125
        0x6128, # G+12783  U+6128  uni6128,  CJK UNIFIED IDEOGRAPH-6128
        0x6129, # G+12784  U+6129  uni6129,  CJK UNIFIED IDEOGRAPH-6129
        0x612A, # G+12785  U+612A  uni612A,  CJK UNIFIED IDEOGRAPH-612A
        0x612C, # G+12786  U+612C  uni612C,  CJK UNIFIED IDEOGRAPH-612C
        0x612D, # G+12787  U+612D  uni612D,  CJK UNIFIED IDEOGRAPH-612D
        0x612E, # G+12788  U+612E  uni612E,  CJK UNIFIED IDEOGRAPH-612E
        0x612F, # G+12789  U+612F  uni612F,  CJK UNIFIED IDEOGRAPH-612F
        0x6130, # G+12790  U+6130  uni6130,  CJK UNIFIED IDEOGRAPH-6130
        0x6131, # G+12791  U+6131  uni6131,  CJK UNIFIED IDEOGRAPH-6131
        0x6132, # G+12792  U+6132  uni6132,  CJK UNIFIED IDEOGRAPH-6132
        0x6133, # G+12793  U+6133  uni6133,  CJK UNIFIED IDEOGRAPH-6133
        0x6135, # G+12794  U+6135  uni6135,  CJK UNIFIED IDEOGRAPH-6135
        0x6136, # G+12795  U+6136  uni6136,  CJK UNIFIED IDEOGRAPH-6136
        0x6138, # G+12796  U+6138  uni6138,  CJK UNIFIED IDEOGRAPH-6138
        0x6139, # G+12797  U+6139  uni6139,  CJK UNIFIED IDEOGRAPH-6139
        0x613A, # G+12798  U+613A  uni613A,  CJK UNIFIED IDEOGRAPH-613A
        0x613B, # G+12799  U+613B  uni613B,  CJK UNIFIED IDEOGRAPH-613B
        0x613C, # G+12800  U+613C  uni613C,  CJK UNIFIED IDEOGRAPH-613C
        0x613D, # G+12801  U+613D  uni613D,  CJK UNIFIED IDEOGRAPH-613D
        0x6140, # G+12802  U+6140  uni6140,  CJK UNIFIED IDEOGRAPH-6140
        0x6141, # G+12803  U+6141  uni6141,  CJK UNIFIED IDEOGRAPH-6141
        0x6142, # G+12804  U+6142  uni6142,  CJK UNIFIED IDEOGRAPH-6142
        0x6143, # G+12805  U+6143  uni6143,  CJK UNIFIED IDEOGRAPH-6143
        0x6144, # G+12806  U+6144  uni6144,  CJK UNIFIED IDEOGRAPH-6144
        0x6145, # G+12807  U+6145  uni6145,  CJK UNIFIED IDEOGRAPH-6145
        0x6146, # G+12808  U+6146  uni6146,  CJK UNIFIED IDEOGRAPH-6146
        0x6147, # G+12809  U+6147  uni6147,  CJK UNIFIED IDEOGRAPH-6147
        0x6149, # G+12810  U+6149  uni6149,  CJK UNIFIED IDEOGRAPH-6149
        0x614D, # G+12811  U+614D  uni614D,  CJK UNIFIED IDEOGRAPH-614D
        0x614F, # G+12812  U+614F  uni614F,  CJK UNIFIED IDEOGRAPH-614F
        0x6150, # G+12813  U+6150  uni6150,  CJK UNIFIED IDEOGRAPH-6150
        0x6152, # G+12814  U+6152  uni6152,  CJK UNIFIED IDEOGRAPH-6152
        0x6153, # G+12815  U+6153  uni6153,  CJK UNIFIED IDEOGRAPH-6153
        0x6154, # G+12816  U+6154  uni6154,  CJK UNIFIED IDEOGRAPH-6154
        0x6156, # G+12817  U+6156  uni6156,  CJK UNIFIED IDEOGRAPH-6156
        0x6157, # G+12818  U+6157  uni6157,  CJK UNIFIED IDEOGRAPH-6157
        0x6159, # G+12819  U+6159  uni6159,  CJK UNIFIED IDEOGRAPH-6159
        0x615B, # G+12820  U+615B  uni615B,  CJK UNIFIED IDEOGRAPH-615B
        0x615C, # G+12821  U+615C  uni615C,  CJK UNIFIED IDEOGRAPH-615C
        0x615E, # G+12822  U+615E  uni615E,  CJK UNIFIED IDEOGRAPH-615E
        0x6160, # G+12823  U+6160  uni6160,  CJK UNIFIED IDEOGRAPH-6160
        0x6161, # G+12824  U+6161  uni6161,  CJK UNIFIED IDEOGRAPH-6161
        0x6165, # G+12825  U+6165  uni6165,  CJK UNIFIED IDEOGRAPH-6165
        0x6166, # G+12826  U+6166  uni6166,  CJK UNIFIED IDEOGRAPH-6166
        0x6169, # G+12827  U+6169  uni6169,  CJK UNIFIED IDEOGRAPH-6169
        0x616C, # G+12828  U+616C  uni616C,  CJK UNIFIED IDEOGRAPH-616C
        0x616D, # G+12829  U+616D  uni616D,  CJK UNIFIED IDEOGRAPH-616D
        0x616F, # G+12830  U+616F  uni616F,  CJK UNIFIED IDEOGRAPH-616F
        0x6171, # G+12831  U+6171  uni6171,  CJK UNIFIED IDEOGRAPH-6171
        0x6172, # G+12832  U+6172  uni6172,  CJK UNIFIED IDEOGRAPH-6172
        0x6174, # G+12833  U+6174  uni6174,  CJK UNIFIED IDEOGRAPH-6174
        0x6178, # G+12834  U+6178  uni6178,  CJK UNIFIED IDEOGRAPH-6178
        0x6179, # G+12835  U+6179  uni6179,  CJK UNIFIED IDEOGRAPH-6179
        0x617A, # G+12836  U+617A  uni617A,  CJK UNIFIED IDEOGRAPH-617A
        0x617B, # G+12837  U+617B  uni617B,  CJK UNIFIED IDEOGRAPH-617B
        0x617C, # G+12838  U+617C  uni617C,  CJK UNIFIED IDEOGRAPH-617C
        0x617D, # G+12839  U+617D  uni617D,  CJK UNIFIED IDEOGRAPH-617D
        0x617E, # G+12840  U+617E  uni617E,  CJK UNIFIED IDEOGRAPH-617E
        0x617F, # G+12841  U+617F  uni617F,  CJK UNIFIED IDEOGRAPH-617F
        0x6180, # G+12842  U+6180  uni6180,  CJK UNIFIED IDEOGRAPH-6180
        0x6181, # G+12843  U+6181  uni6181,  CJK UNIFIED IDEOGRAPH-6181
        0x6183, # G+12844  U+6183  uni6183,  CJK UNIFIED IDEOGRAPH-6183
        0x6184, # G+12845  U+6184  uni6184,  CJK UNIFIED IDEOGRAPH-6184
        0x6185, # G+12846  U+6185  uni6185,  CJK UNIFIED IDEOGRAPH-6185
        0x6186, # G+12847  U+6186  uni6186,  CJK UNIFIED IDEOGRAPH-6186
        0x6187, # G+12848  U+6187  uni6187,  CJK UNIFIED IDEOGRAPH-6187
        0x6188, # G+12849  U+6188  uni6188,  CJK UNIFIED IDEOGRAPH-6188
        0x6189, # G+12850  U+6189  uni6189,  CJK UNIFIED IDEOGRAPH-6189
        0x618C, # G+12851  U+618C  uni618C,  CJK UNIFIED IDEOGRAPH-618C
        0x618D, # G+12852  U+618D  uni618D,  CJK UNIFIED IDEOGRAPH-618D
        0x618F, # G+12853  U+618F  uni618F,  CJK UNIFIED IDEOGRAPH-618F
        0x6193, # G+12854  U+6193  uni6193,  CJK UNIFIED IDEOGRAPH-6193
        0x6195, # G+12855  U+6195  uni6195,  CJK UNIFIED IDEOGRAPH-6195
        0x6196, # G+12856  U+6196  uni6196,  CJK UNIFIED IDEOGRAPH-6196
        0x6197, # G+12857  U+6197  uni6197,  CJK UNIFIED IDEOGRAPH-6197
        0x6198, # G+12858  U+6198  uni6198,  CJK UNIFIED IDEOGRAPH-6198
        0x6199, # G+12859  U+6199  uni6199,  CJK UNIFIED IDEOGRAPH-6199
        0x619B, # G+12860  U+619B  uni619B,  CJK UNIFIED IDEOGRAPH-619B
        0x619C, # G+12861  U+619C  uni619C,  CJK UNIFIED IDEOGRAPH-619C
        0x619E, # G+12862  U+619E  uni619E,  CJK UNIFIED IDEOGRAPH-619E
        0x619F, # G+12863  U+619F  uni619F,  CJK UNIFIED IDEOGRAPH-619F
        0x61A0, # G+12864  U+61A0  uni61A0,  CJK UNIFIED IDEOGRAPH-61A0
        0x61A1, # G+12865  U+61A1  uni61A1,  CJK UNIFIED IDEOGRAPH-61A1
        0x61A2, # G+12866  U+61A2  uni61A2,  CJK UNIFIED IDEOGRAPH-61A2
        0x61A3, # G+12867  U+61A3  uni61A3,  CJK UNIFIED IDEOGRAPH-61A3
        0x61A5, # G+12868  U+61A5  uni61A5,  CJK UNIFIED IDEOGRAPH-61A5
        0x61A6, # G+12869  U+61A6  uni61A6,  CJK UNIFIED IDEOGRAPH-61A6
        0x61AA, # G+12870  U+61AA  uni61AA,  CJK UNIFIED IDEOGRAPH-61AA
        0x61AD, # G+12871  U+61AD  uni61AD,  CJK UNIFIED IDEOGRAPH-61AD
        0x61AF, # G+12872  U+61AF  uni61AF,  CJK UNIFIED IDEOGRAPH-61AF
        0x61B0, # G+12873  U+61B0  uni61B0,  CJK UNIFIED IDEOGRAPH-61B0
        0x61B1, # G+12874  U+61B1  uni61B1,  CJK UNIFIED IDEOGRAPH-61B1
        0x61B3, # G+12875  U+61B3  uni61B3,  CJK UNIFIED IDEOGRAPH-61B3
        0x61B4, # G+12876  U+61B4  uni61B4,  CJK UNIFIED IDEOGRAPH-61B4
        0x61B5, # G+12877  U+61B5  uni61B5,  CJK UNIFIED IDEOGRAPH-61B5
        0x61B8, # G+12878  U+61B8  uni61B8,  CJK UNIFIED IDEOGRAPH-61B8
        0x61B9, # G+12879  U+61B9  uni61B9,  CJK UNIFIED IDEOGRAPH-61B9
        0x61BA, # G+12880  U+61BA  uni61BA,  CJK UNIFIED IDEOGRAPH-61BA
        0x61BB, # G+12881  U+61BB  uni61BB,  CJK UNIFIED IDEOGRAPH-61BB
        0x61BC, # G+12882  U+61BC  uni61BC,  CJK UNIFIED IDEOGRAPH-61BC
        0x61BD, # G+12883  U+61BD  uni61BD,  CJK UNIFIED IDEOGRAPH-61BD
        0x61BF, # G+12884  U+61BF  uni61BF,  CJK UNIFIED IDEOGRAPH-61BF
        0x61C0, # G+12885  U+61C0  uni61C0,  CJK UNIFIED IDEOGRAPH-61C0
        0x61C1, # G+12886  U+61C1  uni61C1,  CJK UNIFIED IDEOGRAPH-61C1
        0x61C3, # G+12887  U+61C3  uni61C3,  CJK UNIFIED IDEOGRAPH-61C3
        0x61C4, # G+12888  U+61C4  uni61C4,  CJK UNIFIED IDEOGRAPH-61C4
        0x61C5, # G+12889  U+61C5  uni61C5,  CJK UNIFIED IDEOGRAPH-61C5
        0x61C6, # G+12890  U+61C6  uni61C6,  CJK UNIFIED IDEOGRAPH-61C6
        0x61CD, # G+12891  U+61CD  uni61CD,  CJK UNIFIED IDEOGRAPH-61CD
        0x61CE, # G+12892  U+61CE  uni61CE,  CJK UNIFIED IDEOGRAPH-61CE
        0x61CF, # G+12893  U+61CF  uni61CF,  CJK UNIFIED IDEOGRAPH-61CF
        0x61D0, # G+12894  U+61D0  uni61D0,  CJK UNIFIED IDEOGRAPH-61D0
        0x61D3, # G+12895  U+61D3  uni61D3,  CJK UNIFIED IDEOGRAPH-61D3
        0x61D5, # G+12896  U+61D5  uni61D5,  CJK UNIFIED IDEOGRAPH-61D5
        0x61D6, # G+12897  U+61D6  uni61D6,  CJK UNIFIED IDEOGRAPH-61D6
        0x61D7, # G+12898  U+61D7  uni61D7,  CJK UNIFIED IDEOGRAPH-61D7
        0x61D8, # G+12899  U+61D8  uni61D8,  CJK UNIFIED IDEOGRAPH-61D8
        0x61D9, # G+12900  U+61D9  uni61D9,  CJK UNIFIED IDEOGRAPH-61D9
        0x61DA, # G+12901  U+61DA  uni61DA,  CJK UNIFIED IDEOGRAPH-61DA
        0x61DB, # G+12902  U+61DB  uni61DB,  CJK UNIFIED IDEOGRAPH-61DB
        0x61DC, # G+12903  U+61DC  uni61DC,  CJK UNIFIED IDEOGRAPH-61DC
        0x61DD, # G+12904  U+61DD  uni61DD,  CJK UNIFIED IDEOGRAPH-61DD
        0x61E0, # G+12905  U+61E0  uni61E0,  CJK UNIFIED IDEOGRAPH-61E0
        0x61E1, # G+12906  U+61E1  uni61E1,  CJK UNIFIED IDEOGRAPH-61E1
        0x61E2, # G+12907  U+61E2  uni61E2,  CJK UNIFIED IDEOGRAPH-61E2
        0x61E4, # G+12908  U+61E4  uni61E4,  CJK UNIFIED IDEOGRAPH-61E4
        0x61E5, # G+12909  U+61E5  uni61E5,  CJK UNIFIED IDEOGRAPH-61E5
        0x61E7, # G+12910  U+61E7  uni61E7,  CJK UNIFIED IDEOGRAPH-61E7
        0x61E9, # G+12911  U+61E9  uni61E9,  CJK UNIFIED IDEOGRAPH-61E9
        0x61EA, # G+12912  U+61EA  uni61EA,  CJK UNIFIED IDEOGRAPH-61EA
        0x61EB, # G+12913  U+61EB  uni61EB,  CJK UNIFIED IDEOGRAPH-61EB
        0x61EC, # G+12914  U+61EC  uni61EC,  CJK UNIFIED IDEOGRAPH-61EC
        0x61ED, # G+12915  U+61ED  uni61ED,  CJK UNIFIED IDEOGRAPH-61ED
        0x61EE, # G+12916  U+61EE  uni61EE,  CJK UNIFIED IDEOGRAPH-61EE
        0x61EF, # G+12917  U+61EF  uni61EF,  CJK UNIFIED IDEOGRAPH-61EF
        0x61F0, # G+12918  U+61F0  uni61F0,  CJK UNIFIED IDEOGRAPH-61F0
        0x61F1, # G+12919  U+61F1  uni61F1,  CJK UNIFIED IDEOGRAPH-61F1
        0x61F3, # G+12920  U+61F3  uni61F3,  CJK UNIFIED IDEOGRAPH-61F3
        0x61F4, # G+12921  U+61F4  uni61F4,  CJK UNIFIED IDEOGRAPH-61F4
        0x61F9, # G+12922  U+61F9  uni61F9,  CJK UNIFIED IDEOGRAPH-61F9
        0x61FB, # G+12923  U+61FB  uni61FB,  CJK UNIFIED IDEOGRAPH-61FB
        0x61FD, # G+12924  U+61FD  uni61FD,  CJK UNIFIED IDEOGRAPH-61FD
        0x6201, # G+12925  U+6201  uni6201,  CJK UNIFIED IDEOGRAPH-6201
        0x6202, # G+12926  U+6202  uni6202,  CJK UNIFIED IDEOGRAPH-6202
        0x6203, # G+12927  U+6203  uni6203,  CJK UNIFIED IDEOGRAPH-6203
        0x6204, # G+12928  U+6204  uni6204,  CJK UNIFIED IDEOGRAPH-6204
        0x6205, # G+12929  U+6205  uni6205,  CJK UNIFIED IDEOGRAPH-6205
        0x6209, # G+12930  U+6209  uni6209,  CJK UNIFIED IDEOGRAPH-6209
        0x6213, # G+12931  U+6213  uni6213,  CJK UNIFIED IDEOGRAPH-6213
        0x6219, # G+12932  U+6219  uni6219,  CJK UNIFIED IDEOGRAPH-6219
        0x621C, # G+12933  U+621C  uni621C,  CJK UNIFIED IDEOGRAPH-621C
        0x621D, # G+12934  U+621D  uni621D,  CJK UNIFIED IDEOGRAPH-621D
        0x621E, # G+12935  U+621E  uni621E,  CJK UNIFIED IDEOGRAPH-621E
        0x6220, # G+12936  U+6220  uni6220,  CJK UNIFIED IDEOGRAPH-6220
        0x6223, # G+12937  U+6223  uni6223,  CJK UNIFIED IDEOGRAPH-6223
        0x6226, # G+12938  U+6226  uni6226,  CJK UNIFIED IDEOGRAPH-6226
        0x6228, # G+12939  U+6228  uni6228,  CJK UNIFIED IDEOGRAPH-6228
        0x6229, # G+12940  U+6229  uni6229,  CJK UNIFIED IDEOGRAPH-6229
        0x622B, # G+12941  U+622B  uni622B,  CJK UNIFIED IDEOGRAPH-622B
        0x622D, # G+12942  U+622D  uni622D,  CJK UNIFIED IDEOGRAPH-622D
        0x622F, # G+12943  U+622F  uni622F,  CJK UNIFIED IDEOGRAPH-622F
        0x6231, # G+12944  U+6231  uni6231,  CJK UNIFIED IDEOGRAPH-6231
        0x6235, # G+12945  U+6235  uni6235,  CJK UNIFIED IDEOGRAPH-6235
        0x2F3E, # G+12946  U+2F3E  uni2F3E,  KANGXI RADICAL DOOR
        0x6238, # G+12947  U+6238  uni6238,  CJK UNIFIED IDEOGRAPH-6238
        0x6239, # G+12948  U+6239  uni6239,  CJK UNIFIED IDEOGRAPH-6239
        0x623A, # G+12949  U+623A  uni623A,  CJK UNIFIED IDEOGRAPH-623A
        0x623B, # G+12950  U+623B  uni623B,  CJK UNIFIED IDEOGRAPH-623B
        0x623C, # G+12951  U+623C  uni623C,  CJK UNIFIED IDEOGRAPH-623C
        0x6242, # G+12952  U+6242  uni6242,  CJK UNIFIED IDEOGRAPH-6242
        0x6244, # G+12953  U+6244  uni6244,  CJK UNIFIED IDEOGRAPH-6244
        0x6245, # G+12954  U+6245  uni6245,  CJK UNIFIED IDEOGRAPH-6245
        0x6246, # G+12955  U+6246  uni6246,  CJK UNIFIED IDEOGRAPH-6246
        0x624A, # G+12956  U+624A  uni624A,  CJK UNIFIED IDEOGRAPH-624A
        0x624F, # G+12957  U+624F  uni624F,  CJK UNIFIED IDEOGRAPH-624F
        0x6250, # G+12958  U+6250  uni6250,  CJK UNIFIED IDEOGRAPH-6250
        0x6255, # G+12959  U+6255  uni6255,  CJK UNIFIED IDEOGRAPH-6255
        0x6256, # G+12960  U+6256  uni6256,  CJK UNIFIED IDEOGRAPH-6256
        0x6257, # G+12961  U+6257  uni6257,  CJK UNIFIED IDEOGRAPH-6257
        0x6259, # G+12962  U+6259  uni6259,  CJK UNIFIED IDEOGRAPH-6259
        0x625A, # G+12963  U+625A  uni625A,  CJK UNIFIED IDEOGRAPH-625A
        0x625C, # G+12964  U+625C  uni625C,  CJK UNIFIED IDEOGRAPH-625C
        0x625D, # G+12965  U+625D  uni625D,  CJK UNIFIED IDEOGRAPH-625D
        0x625E, # G+12966  U+625E  uni625E,  CJK UNIFIED IDEOGRAPH-625E
        0x625F, # G+12967  U+625F  uni625F,  CJK UNIFIED IDEOGRAPH-625F
        0x6260, # G+12968  U+6260  uni6260,  CJK UNIFIED IDEOGRAPH-6260
        0x6261, # G+12969  U+6261  uni6261,  CJK UNIFIED IDEOGRAPH-6261
        0x6262, # G+12970  U+6262  uni6262,  CJK UNIFIED IDEOGRAPH-6262
        0x6264, # G+12971  U+6264  uni6264,  CJK UNIFIED IDEOGRAPH-6264
        0x6265, # G+12972  U+6265  uni6265,  CJK UNIFIED IDEOGRAPH-6265
        0x6268, # G+12973  U+6268  uni6268,  CJK UNIFIED IDEOGRAPH-6268
        0x6271, # G+12974  U+6271  uni6271,  CJK UNIFIED IDEOGRAPH-6271
        0x6272, # G+12975  U+6272  uni6272,  CJK UNIFIED IDEOGRAPH-6272
        0x6274, # G+12976  U+6274  uni6274,  CJK UNIFIED IDEOGRAPH-6274
        0x6275, # G+12977  U+6275  uni6275,  CJK UNIFIED IDEOGRAPH-6275
        0x6277, # G+12978  U+6277  uni6277,  CJK UNIFIED IDEOGRAPH-6277
        0x6278, # G+12979  U+6278  uni6278,  CJK UNIFIED IDEOGRAPH-6278
        0x627A, # G+12980  U+627A  uni627A,  CJK UNIFIED IDEOGRAPH-627A
        0x627B, # G+12981  U+627B  uni627B,  CJK UNIFIED IDEOGRAPH-627B
        0x627D, # G+12982  U+627D  uni627D,  CJK UNIFIED IDEOGRAPH-627D
        0x6281, # G+12983  U+6281  uni6281,  CJK UNIFIED IDEOGRAPH-6281
        0x6282, # G+12984  U+6282  uni6282,  CJK UNIFIED IDEOGRAPH-6282
        0x6283, # G+12985  U+6283  uni6283,  CJK UNIFIED IDEOGRAPH-6283
        0x6285, # G+12986  U+6285  uni6285,  CJK UNIFIED IDEOGRAPH-6285
        0x6286, # G+12987  U+6286  uni6286,  CJK UNIFIED IDEOGRAPH-6286
        0x6287, # G+12988  U+6287  uni6287,  CJK UNIFIED IDEOGRAPH-6287
        0x6288, # G+12989  U+6288  uni6288,  CJK UNIFIED IDEOGRAPH-6288
        0x628B, # G+12990  U+628B  uni628B,  CJK UNIFIED IDEOGRAPH-628B
        0x628C, # G+12991  U+628C  uni628C,  CJK UNIFIED IDEOGRAPH-628C
        0x628D, # G+12992  U+628D  uni628D,  CJK UNIFIED IDEOGRAPH-628D
        0x628E, # G+12993  U+628E  uni628E,  CJK UNIFIED IDEOGRAPH-628E
        0x628F, # G+12994  U+628F  uni628F,  CJK UNIFIED IDEOGRAPH-628F
        0x6290, # G+12995  U+6290  uni6290,  CJK UNIFIED IDEOGRAPH-6290
        0x6294, # G+12996  U+6294  uni6294,  CJK UNIFIED IDEOGRAPH-6294
        0x6299, # G+12997  U+6299  uni6299,  CJK UNIFIED IDEOGRAPH-6299
        0x629C, # G+12998  U+629C  uni629C,  CJK UNIFIED IDEOGRAPH-629C
        0x629D, # G+12999  U+629D  uni629D,  CJK UNIFIED IDEOGRAPH-629D
        0x629E, # G+13000  U+629E  uni629E,  CJK UNIFIED IDEOGRAPH-629E
        0x62A3, # G+13001  U+62A3  uni62A3,  CJK UNIFIED IDEOGRAPH-62A3
        0x62A6, # G+13002  U+62A6  uni62A6,  CJK UNIFIED IDEOGRAPH-62A6
        0x62A7, # G+13003  U+62A7  uni62A7,  CJK UNIFIED IDEOGRAPH-62A7
        0x62A9, # G+13004  U+62A9  uni62A9,  CJK UNIFIED IDEOGRAPH-62A9
        0x62AA, # G+13005  U+62AA  uni62AA,  CJK UNIFIED IDEOGRAPH-62AA
        0x62AD, # G+13006  U+62AD  uni62AD,  CJK UNIFIED IDEOGRAPH-62AD
        0x62AE, # G+13007  U+62AE  uni62AE,  CJK UNIFIED IDEOGRAPH-62AE
        0x62AF, # G+13008  U+62AF  uni62AF,  CJK UNIFIED IDEOGRAPH-62AF
        0x62B0, # G+13009  U+62B0  uni62B0,  CJK UNIFIED IDEOGRAPH-62B0
        0x62B2, # G+13010  U+62B2  uni62B2,  CJK UNIFIED IDEOGRAPH-62B2
        0x62B3, # G+13011  U+62B3  uni62B3,  CJK UNIFIED IDEOGRAPH-62B3
        0x62B4, # G+13012  U+62B4  uni62B4,  CJK UNIFIED IDEOGRAPH-62B4
        0x62B6, # G+13013  U+62B6  uni62B6,  CJK UNIFIED IDEOGRAPH-62B6
        0x62B7, # G+13014  U+62B7  uni62B7,  CJK UNIFIED IDEOGRAPH-62B7
        0x62B8, # G+13015  U+62B8  uni62B8,  CJK UNIFIED IDEOGRAPH-62B8
        0x62BA, # G+13016  U+62BA  uni62BA,  CJK UNIFIED IDEOGRAPH-62BA
        0x62BE, # G+13017  U+62BE  uni62BE,  CJK UNIFIED IDEOGRAPH-62BE
        0x62C0, # G+13018  U+62C0  uni62C0,  CJK UNIFIED IDEOGRAPH-62C0
        0x62C1, # G+13019  U+62C1  uni62C1,  CJK UNIFIED IDEOGRAPH-62C1
        0x62C3, # G+13020  U+62C3  uni62C3,  CJK UNIFIED IDEOGRAPH-62C3
        0x62CB, # G+13021  U+62CB  uni62CB,  CJK UNIFIED IDEOGRAPH-62CB
        0x62CF, # G+13022  U+62CF  uni62CF,  CJK UNIFIED IDEOGRAPH-62CF
        0x62D1, # G+13023  U+62D1  uni62D1,  CJK UNIFIED IDEOGRAPH-62D1
        0x62D5, # G+13024  U+62D5  uni62D5,  CJK UNIFIED IDEOGRAPH-62D5
        0x62DD, # G+13025  U+62DD  uni62DD,  CJK UNIFIED IDEOGRAPH-62DD
        0x62DE, # G+13026  U+62DE  uni62DE,  CJK UNIFIED IDEOGRAPH-62DE
        0x62E0, # G+13027  U+62E0  uni62E0,  CJK UNIFIED IDEOGRAPH-62E0
        0x62E1, # G+13028  U+62E1  uni62E1,  CJK UNIFIED IDEOGRAPH-62E1
        0x62E4, # G+13029  U+62E4  uni62E4,  CJK UNIFIED IDEOGRAPH-62E4
        0x62EA, # G+13030  U+62EA  uni62EA,  CJK UNIFIED IDEOGRAPH-62EA
        0x62EB, # G+13031  U+62EB  uni62EB,  CJK UNIFIED IDEOGRAPH-62EB
        0x62F0, # G+13032  U+62F0  uni62F0,  CJK UNIFIED IDEOGRAPH-62F0
        0x62F2, # G+13033  U+62F2  uni62F2,  CJK UNIFIED IDEOGRAPH-62F2
        0x62F5, # G+13034  U+62F5  uni62F5,  CJK UNIFIED IDEOGRAPH-62F5
        0x62F8, # G+13035  U+62F8  uni62F8,  CJK UNIFIED IDEOGRAPH-62F8
        0x62F9, # G+13036  U+62F9  uni62F9,  CJK UNIFIED IDEOGRAPH-62F9
        0x62FA, # G+13037  U+62FA  uni62FA,  CJK UNIFIED IDEOGRAPH-62FA
        0x62FB, # G+13038  U+62FB  uni62FB,  CJK UNIFIED IDEOGRAPH-62FB
        0x6300, # G+13039  U+6300  uni6300,  CJK UNIFIED IDEOGRAPH-6300
        0x6303, # G+13040  U+6303  uni6303,  CJK UNIFIED IDEOGRAPH-6303
        0x6304, # G+13041  U+6304  uni6304,  CJK UNIFIED IDEOGRAPH-6304
        0x6305, # G+13042  U+6305  uni6305,  CJK UNIFIED IDEOGRAPH-6305
        0x6306, # G+13043  U+6306  uni6306,  CJK UNIFIED IDEOGRAPH-6306
        0x630A, # G+13044  U+630A  uni630A,  CJK UNIFIED IDEOGRAPH-630A
        0x630B, # G+13045  U+630B  uni630B,  CJK UNIFIED IDEOGRAPH-630B
        0x630C, # G+13046  U+630C  uni630C,  CJK UNIFIED IDEOGRAPH-630C
        0x630D, # G+13047  U+630D  uni630D,  CJK UNIFIED IDEOGRAPH-630D
        0x630F, # G+13048  U+630F  uni630F,  CJK UNIFIED IDEOGRAPH-630F
        0x6310, # G+13049  U+6310  uni6310,  CJK UNIFIED IDEOGRAPH-6310
        0x6312, # G+13050  U+6312  uni6312,  CJK UNIFIED IDEOGRAPH-6312
        0x6313, # G+13051  U+6313  uni6313,  CJK UNIFIED IDEOGRAPH-6313
        0x6314, # G+13052  U+6314  uni6314,  CJK UNIFIED IDEOGRAPH-6314
        0x6315, # G+13053  U+6315  uni6315,  CJK UNIFIED IDEOGRAPH-6315
        0x6317, # G+13054  U+6317  uni6317,  CJK UNIFIED IDEOGRAPH-6317
        0x6318, # G+13055  U+6318  uni6318,  CJK UNIFIED IDEOGRAPH-6318
        0x6319, # G+13056  U+6319  uni6319,  CJK UNIFIED IDEOGRAPH-6319
        0x631C, # G+13057  U+631C  uni631C,  CJK UNIFIED IDEOGRAPH-631C
        0x6326, # G+13058  U+6326  uni6326,  CJK UNIFIED IDEOGRAPH-6326
        0x6327, # G+13059  U+6327  uni6327,  CJK UNIFIED IDEOGRAPH-6327
        0x6329, # G+13060  U+6329  uni6329,  CJK UNIFIED IDEOGRAPH-6329
        0x632C, # G+13061  U+632C  uni632C,  CJK UNIFIED IDEOGRAPH-632C
        0x632D, # G+13062  U+632D  uni632D,  CJK UNIFIED IDEOGRAPH-632D
        0x632E, # G+13063  U+632E  uni632E,  CJK UNIFIED IDEOGRAPH-632E
        0x6330, # G+13064  U+6330  uni6330,  CJK UNIFIED IDEOGRAPH-6330
        0x6331, # G+13065  U+6331  uni6331,  CJK UNIFIED IDEOGRAPH-6331
        0x6333, # G+13066  U+6333  uni6333,  CJK UNIFIED IDEOGRAPH-6333
        0x6334, # G+13067  U+6334  uni6334,  CJK UNIFIED IDEOGRAPH-6334
        0x6335, # G+13068  U+6335  uni6335,  CJK UNIFIED IDEOGRAPH-6335
        0x6336, # G+13069  U+6336  uni6336,  CJK UNIFIED IDEOGRAPH-6336
        0x6337, # G+13070  U+6337  uni6337,  CJK UNIFIED IDEOGRAPH-6337
        0x6338, # G+13071  U+6338  uni6338,  CJK UNIFIED IDEOGRAPH-6338
        0x633B, # G+13072  U+633B  uni633B,  CJK UNIFIED IDEOGRAPH-633B
        0x633C, # G+13073  U+633C  uni633C,  CJK UNIFIED IDEOGRAPH-633C
        0x633F, # G+13074  U+633F  uni633F,  CJK UNIFIED IDEOGRAPH-633F
        0x6340, # G+13075  U+6340  uni6340,  CJK UNIFIED IDEOGRAPH-6340
        0x6341, # G+13076  U+6341  uni6341,  CJK UNIFIED IDEOGRAPH-6341
        0x6344, # G+13077  U+6344  uni6344,  CJK UNIFIED IDEOGRAPH-6344
        0x6347, # G+13078  U+6347  uni6347,  CJK UNIFIED IDEOGRAPH-6347
        0x6348, # G+13079  U+6348  uni6348,  CJK UNIFIED IDEOGRAPH-6348
        0x634A, # G+13080  U+634A  uni634A,  CJK UNIFIED IDEOGRAPH-634A
        0x6351, # G+13081  U+6351  uni6351,  CJK UNIFIED IDEOGRAPH-6351
        0x6352, # G+13082  U+6352  uni6352,  CJK UNIFIED IDEOGRAPH-6352
        0x6353, # G+13083  U+6353  uni6353,  CJK UNIFIED IDEOGRAPH-6353
        0x6354, # G+13084  U+6354  uni6354,  CJK UNIFIED IDEOGRAPH-6354
        0x6356, # G+13085  U+6356  uni6356,  CJK UNIFIED IDEOGRAPH-6356
        0x6357, # G+13086  U+6357  uni6357,  CJK UNIFIED IDEOGRAPH-6357
        0x6358, # G+13087  U+6358  uni6358,  CJK UNIFIED IDEOGRAPH-6358
        0x6359, # G+13088  U+6359  uni6359,  CJK UNIFIED IDEOGRAPH-6359
        0x635A, # G+13089  U+635A  uni635A,  CJK UNIFIED IDEOGRAPH-635A
        0x635B, # G+13090  U+635B  uni635B,  CJK UNIFIED IDEOGRAPH-635B
        0x635C, # G+13091  U+635C  uni635C,  CJK UNIFIED IDEOGRAPH-635C
        0x635D, # G+13092  U+635D  uni635D,  CJK UNIFIED IDEOGRAPH-635D
        0x6360, # G+13093  U+6360  uni6360,  CJK UNIFIED IDEOGRAPH-6360
        0x6364, # G+13094  U+6364  uni6364,  CJK UNIFIED IDEOGRAPH-6364
        0x6365, # G+13095  U+6365  uni6365,  CJK UNIFIED IDEOGRAPH-6365
        0x6366, # G+13096  U+6366  uni6366,  CJK UNIFIED IDEOGRAPH-6366
        0x636A, # G+13097  U+636A  uni636A,  CJK UNIFIED IDEOGRAPH-636A
        0x636C, # G+13098  U+636C  uni636C,  CJK UNIFIED IDEOGRAPH-636C
        0x636F, # G+13099  U+636F  uni636F,  CJK UNIFIED IDEOGRAPH-636F
        0x6370, # G+13100  U+6370  uni6370,  CJK UNIFIED IDEOGRAPH-6370
        0x6373, # G+13101  U+6373  uni6373,  CJK UNIFIED IDEOGRAPH-6373
        0x6374, # G+13102  U+6374  uni6374,  CJK UNIFIED IDEOGRAPH-6374
        0x6375, # G+13103  U+6375  uni6375,  CJK UNIFIED IDEOGRAPH-6375
        0x6378, # G+13104  U+6378  uni6378,  CJK UNIFIED IDEOGRAPH-6378
        0x6379, # G+13105  U+6379  uni6379,  CJK UNIFIED IDEOGRAPH-6379
        0x637C, # G+13106  U+637C  uni637C,  CJK UNIFIED IDEOGRAPH-637C
        0x637D, # G+13107  U+637D  uni637D,  CJK UNIFIED IDEOGRAPH-637D
        0x637E, # G+13108  U+637E  uni637E,  CJK UNIFIED IDEOGRAPH-637E
        0x637F, # G+13109  U+637F  uni637F,  CJK UNIFIED IDEOGRAPH-637F
        0x6381, # G+13110  U+6381  uni6381,  CJK UNIFIED IDEOGRAPH-6381
        0x6385, # G+13111  U+6385  uni6385,  CJK UNIFIED IDEOGRAPH-6385
        0x6386, # G+13112  U+6386  uni6386,  CJK UNIFIED IDEOGRAPH-6386
        0x638B, # G+13113  U+638B  uni638B,  CJK UNIFIED IDEOGRAPH-638B
        0x638D, # G+13114  U+638D  uni638D,  CJK UNIFIED IDEOGRAPH-638D
        0x6391, # G+13115  U+6391  uni6391,  CJK UNIFIED IDEOGRAPH-6391
        0x6393, # G+13116  U+6393  uni6393,  CJK UNIFIED IDEOGRAPH-6393
        0x6394, # G+13117  U+6394  uni6394,  CJK UNIFIED IDEOGRAPH-6394
        0x6395, # G+13118  U+6395  uni6395,  CJK UNIFIED IDEOGRAPH-6395
        0x6397, # G+13119  U+6397  uni6397,  CJK UNIFIED IDEOGRAPH-6397
        0x6399, # G+13120  U+6399  uni6399,  CJK UNIFIED IDEOGRAPH-6399
        0x639A, # G+13121  U+639A  uni639A,  CJK UNIFIED IDEOGRAPH-639A
        0x639B, # G+13122  U+639B  uni639B,  CJK UNIFIED IDEOGRAPH-639B
        0x639C, # G+13123  U+639C  uni639C,  CJK UNIFIED IDEOGRAPH-639C
        0x639D, # G+13124  U+639D  uni639D,  CJK UNIFIED IDEOGRAPH-639D
        0x639E, # G+13125  U+639E  uni639E,  CJK UNIFIED IDEOGRAPH-639E
        0x639F, # G+13126  U+639F  uni639F,  CJK UNIFIED IDEOGRAPH-639F
        0x63A1, # G+13127  U+63A1  uni63A1,  CJK UNIFIED IDEOGRAPH-63A1
        0x63A4, # G+13128  U+63A4  uni63A4,  CJK UNIFIED IDEOGRAPH-63A4
        0x63A6, # G+13129  U+63A6  uni63A6,  CJK UNIFIED IDEOGRAPH-63A6
        0x63AB, # G+13130  U+63AB  uni63AB,  CJK UNIFIED IDEOGRAPH-63AB
        0x63AF, # G+13131  U+63AF  uni63AF,  CJK UNIFIED IDEOGRAPH-63AF
        0x63B1, # G+13132  U+63B1  uni63B1,  CJK UNIFIED IDEOGRAPH-63B1
        0x63B2, # G+13133  U+63B2  uni63B2,  CJK UNIFIED IDEOGRAPH-63B2
        0x63B5, # G+13134  U+63B5  uni63B5,  CJK UNIFIED IDEOGRAPH-63B5
        0x63B6, # G+13135  U+63B6  uni63B6,  CJK UNIFIED IDEOGRAPH-63B6
        0x63B9, # G+13136  U+63B9  uni63B9,  CJK UNIFIED IDEOGRAPH-63B9
        0x63BB, # G+13137  U+63BB  uni63BB,  CJK UNIFIED IDEOGRAPH-63BB
        0x63BD, # G+13138  U+63BD  uni63BD,  CJK UNIFIED IDEOGRAPH-63BD
        0x63BF, # G+13139  U+63BF  uni63BF,  CJK UNIFIED IDEOGRAPH-63BF
        0x63C1, # G+13140  U+63C1  uni63C1,  CJK UNIFIED IDEOGRAPH-63C1
        0x63C2, # G+13141  U+63C2  uni63C2,  CJK UNIFIED IDEOGRAPH-63C2
        0x63C3, # G+13142  U+63C3  uni63C3,  CJK UNIFIED IDEOGRAPH-63C3
        0x63C5, # G+13143  U+63C5  uni63C5,  CJK UNIFIED IDEOGRAPH-63C5
        0x63C7, # G+13144  U+63C7  uni63C7,  CJK UNIFIED IDEOGRAPH-63C7
        0x63C8, # G+13145  U+63C8  uni63C8,  CJK UNIFIED IDEOGRAPH-63C8
        0x63CA, # G+13146  U+63CA  uni63CA,  CJK UNIFIED IDEOGRAPH-63CA
        0x63CB, # G+13147  U+63CB  uni63CB,  CJK UNIFIED IDEOGRAPH-63CB
        0x63CC, # G+13148  U+63CC  uni63CC,  CJK UNIFIED IDEOGRAPH-63CC
        0x63D1, # G+13149  U+63D1  uni63D1,  CJK UNIFIED IDEOGRAPH-63D1
        0x63D3, # G+13150  U+63D3  uni63D3,  CJK UNIFIED IDEOGRAPH-63D3
        0x63D4, # G+13151  U+63D4  uni63D4,  CJK UNIFIED IDEOGRAPH-63D4
        0x63D5, # G+13152  U+63D5  uni63D5,  CJK UNIFIED IDEOGRAPH-63D5
        0x63D7, # G+13153  U+63D7  uni63D7,  CJK UNIFIED IDEOGRAPH-63D7
        0x63D8, # G+13154  U+63D8  uni63D8,  CJK UNIFIED IDEOGRAPH-63D8
        0x63D9, # G+13155  U+63D9  uni63D9,  CJK UNIFIED IDEOGRAPH-63D9
        0x63DB, # G+13156  U+63DB  uni63DB,  CJK UNIFIED IDEOGRAPH-63DB
        0x63DC, # G+13157  U+63DC  uni63DC,  CJK UNIFIED IDEOGRAPH-63DC
        0x63DD, # G+13158  U+63DD  uni63DD,  CJK UNIFIED IDEOGRAPH-63DD
        0x63DF, # G+13159  U+63DF  uni63DF,  CJK UNIFIED IDEOGRAPH-63DF
        0x63E2, # G+13160  U+63E2  uni63E2,  CJK UNIFIED IDEOGRAPH-63E2
        0x63E4, # G+13161  U+63E4  uni63E4,  CJK UNIFIED IDEOGRAPH-63E4
        0x63E5, # G+13162  U+63E5  uni63E5,  CJK UNIFIED IDEOGRAPH-63E5
        0x63E6, # G+13163  U+63E6  uni63E6,  CJK UNIFIED IDEOGRAPH-63E6
        0x63E7, # G+13164  U+63E7  uni63E7,  CJK UNIFIED IDEOGRAPH-63E7
        0x63E8, # G+13165  U+63E8  uni63E8,  CJK UNIFIED IDEOGRAPH-63E8
        0x63EB, # G+13166  U+63EB  uni63EB,  CJK UNIFIED IDEOGRAPH-63EB
        0x63EC, # G+13167  U+63EC  uni63EC,  CJK UNIFIED IDEOGRAPH-63EC
        0x63EF, # G+13168  U+63EF  uni63EF,  CJK UNIFIED IDEOGRAPH-63EF
        0x63F0, # G+13169  U+63F0  uni63F0,  CJK UNIFIED IDEOGRAPH-63F0
        0x63F1, # G+13170  U+63F1  uni63F1,  CJK UNIFIED IDEOGRAPH-63F1
        0x63F3, # G+13171  U+63F3  uni63F3,  CJK UNIFIED IDEOGRAPH-63F3
        0x63F5, # G+13172  U+63F5  uni63F5,  CJK UNIFIED IDEOGRAPH-63F5
        0x63F7, # G+13173  U+63F7  uni63F7,  CJK UNIFIED IDEOGRAPH-63F7
        0x63F9, # G+13174  U+63F9  uni63F9,  CJK UNIFIED IDEOGRAPH-63F9
        0x63FA, # G+13175  U+63FA  uni63FA,  CJK UNIFIED IDEOGRAPH-63FA
        0x63FB, # G+13176  U+63FB  uni63FB,  CJK UNIFIED IDEOGRAPH-63FB
        0x63FC, # G+13177  U+63FC  uni63FC,  CJK UNIFIED IDEOGRAPH-63FC
        0x63FE, # G+13178  U+63FE  uni63FE,  CJK UNIFIED IDEOGRAPH-63FE
        0x6403, # G+13179  U+6403  uni6403,  CJK UNIFIED IDEOGRAPH-6403
        0x6404, # G+13180  U+6404  uni6404,  CJK UNIFIED IDEOGRAPH-6404
        0x6406, # G+13181  U+6406  uni6406,  CJK UNIFIED IDEOGRAPH-6406
        0x6407, # G+13182  U+6407  uni6407,  CJK UNIFIED IDEOGRAPH-6407
        0x6408, # G+13183  U+6408  uni6408,  CJK UNIFIED IDEOGRAPH-6408
        0x6409, # G+13184  U+6409  uni6409,  CJK UNIFIED IDEOGRAPH-6409
        0x640A, # G+13185  U+640A  uni640A,  CJK UNIFIED IDEOGRAPH-640A
        0x640E, # G+13186  U+640E  uni640E,  CJK UNIFIED IDEOGRAPH-640E
        0x6411, # G+13187  U+6411  uni6411,  CJK UNIFIED IDEOGRAPH-6411
        0x6412, # G+13188  U+6412  uni6412,  CJK UNIFIED IDEOGRAPH-6412
        0x6415, # G+13189  U+6415  uni6415,  CJK UNIFIED IDEOGRAPH-6415
        0x6416, # G+13190  U+6416  uni6416,  CJK UNIFIED IDEOGRAPH-6416
        0x6418, # G+13191  U+6418  uni6418,  CJK UNIFIED IDEOGRAPH-6418
        0x6419, # G+13192  U+6419  uni6419,  CJK UNIFIED IDEOGRAPH-6419
        0x641A, # G+13193  U+641A  uni641A,  CJK UNIFIED IDEOGRAPH-641A
        0x641D, # G+13194  U+641D  uni641D,  CJK UNIFIED IDEOGRAPH-641D
        0x641F, # G+13195  U+641F  uni641F,  CJK UNIFIED IDEOGRAPH-641F
        0x6422, # G+13196  U+6422  uni6422,  CJK UNIFIED IDEOGRAPH-6422
        0x6423, # G+13197  U+6423  uni6423,  CJK UNIFIED IDEOGRAPH-6423
        0x6424, # G+13198  U+6424  uni6424,  CJK UNIFIED IDEOGRAPH-6424
        0x6425, # G+13199  U+6425  uni6425,  CJK UNIFIED IDEOGRAPH-6425
        0x6427, # G+13200  U+6427  uni6427,  CJK UNIFIED IDEOGRAPH-6427
        0x6428, # G+13201  U+6428  uni6428,  CJK UNIFIED IDEOGRAPH-6428
        0x6429, # G+13202  U+6429  uni6429,  CJK UNIFIED IDEOGRAPH-6429
        0x642B, # G+13203  U+642B  uni642B,  CJK UNIFIED IDEOGRAPH-642B
        0x642E, # G+13204  U+642E  uni642E,  CJK UNIFIED IDEOGRAPH-642E
        0x642F, # G+13205  U+642F  uni642F,  CJK UNIFIED IDEOGRAPH-642F
        0x6430, # G+13206  U+6430  uni6430,  CJK UNIFIED IDEOGRAPH-6430
        0x6431, # G+13207  U+6431  uni6431,  CJK UNIFIED IDEOGRAPH-6431
        0x6432, # G+13208  U+6432  uni6432,  CJK UNIFIED IDEOGRAPH-6432
        0x6433, # G+13209  U+6433  uni6433,  CJK UNIFIED IDEOGRAPH-6433
        0x6435, # G+13210  U+6435  uni6435,  CJK UNIFIED IDEOGRAPH-6435
        0x6437, # G+13211  U+6437  uni6437,  CJK UNIFIED IDEOGRAPH-6437
        0x6438, # G+13212  U+6438  uni6438,  CJK UNIFIED IDEOGRAPH-6438
        0x6439, # G+13213  U+6439  uni6439,  CJK UNIFIED IDEOGRAPH-6439
        0x643B, # G+13214  U+643B  uni643B,  CJK UNIFIED IDEOGRAPH-643B
        0x643C, # G+13215  U+643C  uni643C,  CJK UNIFIED IDEOGRAPH-643C
        0x643E, # G+13216  U+643E  uni643E,  CJK UNIFIED IDEOGRAPH-643E
        0x6440, # G+13217  U+6440  uni6440,  CJK UNIFIED IDEOGRAPH-6440
        0x6442, # G+13218  U+6442  uni6442,  CJK UNIFIED IDEOGRAPH-6442
        0x6443, # G+13219  U+6443  uni6443,  CJK UNIFIED IDEOGRAPH-6443
        0x6449, # G+13220  U+6449  uni6449,  CJK UNIFIED IDEOGRAPH-6449
        0x644B, # G+13221  U+644B  uni644B,  CJK UNIFIED IDEOGRAPH-644B
        0x644C, # G+13222  U+644C  uni644C,  CJK UNIFIED IDEOGRAPH-644C
        0x644D, # G+13223  U+644D  uni644D,  CJK UNIFIED IDEOGRAPH-644D
        0x644E, # G+13224  U+644E  uni644E,  CJK UNIFIED IDEOGRAPH-644E
        0x644F, # G+13225  U+644F  uni644F,  CJK UNIFIED IDEOGRAPH-644F
        0x6450, # G+13226  U+6450  uni6450,  CJK UNIFIED IDEOGRAPH-6450
        0x6453, # G+13227  U+6453  uni6453,  CJK UNIFIED IDEOGRAPH-6453
        0x6455, # G+13228  U+6455  uni6455,  CJK UNIFIED IDEOGRAPH-6455
        0x6456, # G+13229  U+6456  uni6456,  CJK UNIFIED IDEOGRAPH-6456
        0x6457, # G+13230  U+6457  uni6457,  CJK UNIFIED IDEOGRAPH-6457
        0x6459, # G+13231  U+6459  uni6459,  CJK UNIFIED IDEOGRAPH-6459
        0x645A, # G+13232  U+645A  uni645A,  CJK UNIFIED IDEOGRAPH-645A
        0x645B, # G+13233  U+645B  uni645B,  CJK UNIFIED IDEOGRAPH-645B
        0x645D, # G+13234  U+645D  uni645D,  CJK UNIFIED IDEOGRAPH-645D
        0x6460, # G+13235  U+6460  uni6460,  CJK UNIFIED IDEOGRAPH-6460
        0x6461, # G+13236  U+6461  uni6461,  CJK UNIFIED IDEOGRAPH-6461
        0x6462, # G+13237  U+6462  uni6462,  CJK UNIFIED IDEOGRAPH-6462
        0x6463, # G+13238  U+6463  uni6463,  CJK UNIFIED IDEOGRAPH-6463
        0x6464, # G+13239  U+6464  uni6464,  CJK UNIFIED IDEOGRAPH-6464
        0x6465, # G+13240  U+6465  uni6465,  CJK UNIFIED IDEOGRAPH-6465
        0x6466, # G+13241  U+6466  uni6466,  CJK UNIFIED IDEOGRAPH-6466
        0x6468, # G+13242  U+6468  uni6468,  CJK UNIFIED IDEOGRAPH-6468
        0x646A, # G+13243  U+646A  uni646A,  CJK UNIFIED IDEOGRAPH-646A
        0x646B, # G+13244  U+646B  uni646B,  CJK UNIFIED IDEOGRAPH-646B
        0x646C, # G+13245  U+646C  uni646C,  CJK UNIFIED IDEOGRAPH-646C
        0x646E, # G+13246  U+646E  uni646E,  CJK UNIFIED IDEOGRAPH-646E
        0x6470, # G+13247  U+6470  uni6470,  CJK UNIFIED IDEOGRAPH-6470
        0x6471, # G+13248  U+6471  uni6471,  CJK UNIFIED IDEOGRAPH-6471
        0x6472, # G+13249  U+6472  uni6472,  CJK UNIFIED IDEOGRAPH-6472
        0x6474, # G+13250  U+6474  uni6474,  CJK UNIFIED IDEOGRAPH-6474
        0x6475, # G+13251  U+6475  uni6475,  CJK UNIFIED IDEOGRAPH-6475
        0x6477, # G+13252  U+6477  uni6477,  CJK UNIFIED IDEOGRAPH-6477
        0x647C, # G+13253  U+647C  uni647C,  CJK UNIFIED IDEOGRAPH-647C
        0x647D, # G+13254  U+647D  uni647D,  CJK UNIFIED IDEOGRAPH-647D
        0x647E, # G+13255  U+647E  uni647E,  CJK UNIFIED IDEOGRAPH-647E
        0x647F, # G+13256  U+647F  uni647F,  CJK UNIFIED IDEOGRAPH-647F
        0x6480, # G+13257  U+6480  uni6480,  CJK UNIFIED IDEOGRAPH-6480
        0x6481, # G+13258  U+6481  uni6481,  CJK UNIFIED IDEOGRAPH-6481
        0x6483, # G+13259  U+6483  uni6483,  CJK UNIFIED IDEOGRAPH-6483
        0x6486, # G+13260  U+6486  uni6486,  CJK UNIFIED IDEOGRAPH-6486
        0x6489, # G+13261  U+6489  uni6489,  CJK UNIFIED IDEOGRAPH-6489
        0x648A, # G+13262  U+648A  uni648A,  CJK UNIFIED IDEOGRAPH-648A
        0x648B, # G+13263  U+648B  uni648B,  CJK UNIFIED IDEOGRAPH-648B
        0x648C, # G+13264  U+648C  uni648C,  CJK UNIFIED IDEOGRAPH-648C
        0x648D, # G+13265  U+648D  uni648D,  CJK UNIFIED IDEOGRAPH-648D
        0x648E, # G+13266  U+648E  uni648E,  CJK UNIFIED IDEOGRAPH-648E
        0x648F, # G+13267  U+648F  uni648F,  CJK UNIFIED IDEOGRAPH-648F
        0x6490, # G+13268  U+6490  uni6490,  CJK UNIFIED IDEOGRAPH-6490
        0x6494, # G+13269  U+6494  uni6494,  CJK UNIFIED IDEOGRAPH-6494
        0x6497, # G+13270  U+6497  uni6497,  CJK UNIFIED IDEOGRAPH-6497
        0x6498, # G+13271  U+6498  uni6498,  CJK UNIFIED IDEOGRAPH-6498
        0x649A, # G+13272  U+649A  uni649A,  CJK UNIFIED IDEOGRAPH-649A
        0x649B, # G+13273  U+649B  uni649B,  CJK UNIFIED IDEOGRAPH-649B
        0x649C, # G+13274  U+649C  uni649C,  CJK UNIFIED IDEOGRAPH-649C
        0x649D, # G+13275  U+649D  uni649D,  CJK UNIFIED IDEOGRAPH-649D
        0x64A0, # G+13276  U+64A0  uni64A0,  CJK UNIFIED IDEOGRAPH-64A0
        0x64A1, # G+13277  U+64A1  uni64A1,  CJK UNIFIED IDEOGRAPH-64A1
        0x64A2, # G+13278  U+64A2  uni64A2,  CJK UNIFIED IDEOGRAPH-64A2
        0x64A6, # G+13279  U+64A6  uni64A6,  CJK UNIFIED IDEOGRAPH-64A6
        0x64A7, # G+13280  U+64A7  uni64A7,  CJK UNIFIED IDEOGRAPH-64A7
        0x64A8, # G+13281  U+64A8  uni64A8,  CJK UNIFIED IDEOGRAPH-64A8
        0x64AA, # G+13282  U+64AA  uni64AA,  CJK UNIFIED IDEOGRAPH-64AA
        0x64AF, # G+13283  U+64AF  uni64AF,  CJK UNIFIED IDEOGRAPH-64AF
        0x64B1, # G+13284  U+64B1  uni64B1,  CJK UNIFIED IDEOGRAPH-64B1
        0x64B4, # G+13285  U+64B4  uni64B4,  CJK UNIFIED IDEOGRAPH-64B4
        0x64B6, # G+13286  U+64B6  uni64B6,  CJK UNIFIED IDEOGRAPH-64B6
        0x64B9, # G+13287  U+64B9  uni64B9,  CJK UNIFIED IDEOGRAPH-64B9
        0x64BD, # G+13288  U+64BD  uni64BD,  CJK UNIFIED IDEOGRAPH-64BD
        0x64C3, # G+13289  U+64C3  uni64C3,  CJK UNIFIED IDEOGRAPH-64C3
        0x64C6, # G+13290  U+64C6  uni64C6,  CJK UNIFIED IDEOGRAPH-64C6
        0x64C8, # G+13291  U+64C8  uni64C8,  CJK UNIFIED IDEOGRAPH-64C8
        0x64C9, # G+13292  U+64C9  uni64C9,  CJK UNIFIED IDEOGRAPH-64C9
        0x64CC, # G+13293  U+64CC  uni64CC,  CJK UNIFIED IDEOGRAPH-64CC
        0x64CF, # G+13294  U+64CF  uni64CF,  CJK UNIFIED IDEOGRAPH-64CF
        0x64D1, # G+13295  U+64D1  uni64D1,  CJK UNIFIED IDEOGRAPH-64D1
        0x64D3, # G+13296  U+64D3  uni64D3,  CJK UNIFIED IDEOGRAPH-64D3
        0x64D5, # G+13297  U+64D5  uni64D5,  CJK UNIFIED IDEOGRAPH-64D5
        0x64D6, # G+13298  U+64D6  uni64D6,  CJK UNIFIED IDEOGRAPH-64D6
        0x64D9, # G+13299  U+64D9  uni64D9,  CJK UNIFIED IDEOGRAPH-64D9
        0x64DB, # G+13300  U+64DB  uni64DB,  CJK UNIFIED IDEOGRAPH-64DB
        0x64DC, # G+13301  U+64DC  uni64DC,  CJK UNIFIED IDEOGRAPH-64DC
        0x64DD, # G+13302  U+64DD  uni64DD,  CJK UNIFIED IDEOGRAPH-64DD
        0x64DF, # G+13303  U+64DF  uni64DF,  CJK UNIFIED IDEOGRAPH-64DF
        0x64E1, # G+13304  U+64E1  uni64E1,  CJK UNIFIED IDEOGRAPH-64E1
        0x64E3, # G+13305  U+64E3  uni64E3,  CJK UNIFIED IDEOGRAPH-64E3
        0x64E5, # G+13306  U+64E5  uni64E5,  CJK UNIFIED IDEOGRAPH-64E5
        0x64E7, # G+13307  U+64E7  uni64E7,  CJK UNIFIED IDEOGRAPH-64E7
        0x64E8, # G+13308  U+64E8  uni64E8,  CJK UNIFIED IDEOGRAPH-64E8
        0x64E9, # G+13309  U+64E9  uni64E9,  CJK UNIFIED IDEOGRAPH-64E9
        0x64EA, # G+13310  U+64EA  uni64EA,  CJK UNIFIED IDEOGRAPH-64EA
        0x64EB, # G+13311  U+64EB  uni64EB,  CJK UNIFIED IDEOGRAPH-64EB
        0x64ED, # G+13312  U+64ED  uni64ED,  CJK UNIFIED IDEOGRAPH-64ED
        0x64EE, # G+13313  U+64EE  uni64EE,  CJK UNIFIED IDEOGRAPH-64EE
        0x64F3, # G+13314  U+64F3  uni64F3,  CJK UNIFIED IDEOGRAPH-64F3
        0x64F5, # G+13315  U+64F5  uni64F5,  CJK UNIFIED IDEOGRAPH-64F5
        0x64F6, # G+13316  U+64F6  uni64F6,  CJK UNIFIED IDEOGRAPH-64F6
        0x64F8, # G+13317  U+64F8  uni64F8,  CJK UNIFIED IDEOGRAPH-64F8
        0x64F9, # G+13318  U+64F9  uni64F9,  CJK UNIFIED IDEOGRAPH-64F9
        0x64FD, # G+13319  U+64FD  uni64FD,  CJK UNIFIED IDEOGRAPH-64FD
        0x64FF, # G+13320  U+64FF  uni64FF,  CJK UNIFIED IDEOGRAPH-64FF
        0x6501, # G+13321  U+6501  uni6501,  CJK UNIFIED IDEOGRAPH-6501
        0x6502, # G+13322  U+6502  uni6502,  CJK UNIFIED IDEOGRAPH-6502
        0x6503, # G+13323  U+6503  uni6503,  CJK UNIFIED IDEOGRAPH-6503
        0x6505, # G+13324  U+6505  uni6505,  CJK UNIFIED IDEOGRAPH-6505
        0x6507, # G+13325  U+6507  uni6507,  CJK UNIFIED IDEOGRAPH-6507
        0x6508, # G+13326  U+6508  uni6508,  CJK UNIFIED IDEOGRAPH-6508
        0x650A, # G+13327  U+650A  uni650A,  CJK UNIFIED IDEOGRAPH-650A
        0x650B, # G+13328  U+650B  uni650B,  CJK UNIFIED IDEOGRAPH-650B
        0x650C, # G+13329  U+650C  uni650C,  CJK UNIFIED IDEOGRAPH-650C
        0x650D, # G+13330  U+650D  uni650D,  CJK UNIFIED IDEOGRAPH-650D
        0x650E, # G+13331  U+650E  uni650E,  CJK UNIFIED IDEOGRAPH-650E
        0x6510, # G+13332  U+6510  uni6510,  CJK UNIFIED IDEOGRAPH-6510
        0x6511, # G+13333  U+6511  uni6511,  CJK UNIFIED IDEOGRAPH-6511
        0x6513, # G+13334  U+6513  uni6513,  CJK UNIFIED IDEOGRAPH-6513
        0x6515, # G+13335  U+6515  uni6515,  CJK UNIFIED IDEOGRAPH-6515
        0x6517, # G+13336  U+6517  uni6517,  CJK UNIFIED IDEOGRAPH-6517
        0x651A, # G+13337  U+651A  uni651A,  CJK UNIFIED IDEOGRAPH-651A
        0x651C, # G+13338  U+651C  uni651C,  CJK UNIFIED IDEOGRAPH-651C
        0x651E, # G+13339  U+651E  uni651E,  CJK UNIFIED IDEOGRAPH-651E
        0x651F, # G+13340  U+651F  uni651F,  CJK UNIFIED IDEOGRAPH-651F
        0x6520, # G+13341  U+6520  uni6520,  CJK UNIFIED IDEOGRAPH-6520
        0x6521, # G+13342  U+6521  uni6521,  CJK UNIFIED IDEOGRAPH-6521
        0x6526, # G+13343  U+6526  uni6526,  CJK UNIFIED IDEOGRAPH-6526
        0x6527, # G+13344  U+6527  uni6527,  CJK UNIFIED IDEOGRAPH-6527
        0x6528, # G+13345  U+6528  uni6528,  CJK UNIFIED IDEOGRAPH-6528
        0x6529, # G+13346  U+6529  uni6529,  CJK UNIFIED IDEOGRAPH-6529
        0x652D, # G+13347  U+652D  uni652D,  CJK UNIFIED IDEOGRAPH-652D
        0x6530, # G+13348  U+6530  uni6530,  CJK UNIFIED IDEOGRAPH-6530
        0x6531, # G+13349  U+6531  uni6531,  CJK UNIFIED IDEOGRAPH-6531
        0x6532, # G+13350  U+6532  uni6532,  CJK UNIFIED IDEOGRAPH-6532
        0x6533, # G+13351  U+6533  uni6533,  CJK UNIFIED IDEOGRAPH-6533
        0x6537, # G+13352  U+6537  uni6537,  CJK UNIFIED IDEOGRAPH-6537
        0x653A, # G+13353  U+653A  uni653A,  CJK UNIFIED IDEOGRAPH-653A
        0x653C, # G+13354  U+653C  uni653C,  CJK UNIFIED IDEOGRAPH-653C
        0x653D, # G+13355  U+653D  uni653D,  CJK UNIFIED IDEOGRAPH-653D
        0x6540, # G+13356  U+6540  uni6540,  CJK UNIFIED IDEOGRAPH-6540
        0x6541, # G+13357  U+6541  uni6541,  CJK UNIFIED IDEOGRAPH-6541
        0x6542, # G+13358  U+6542  uni6542,  CJK UNIFIED IDEOGRAPH-6542
        0x6543, # G+13359  U+6543  uni6543,  CJK UNIFIED IDEOGRAPH-6543
        0x6544, # G+13360  U+6544  uni6544,  CJK UNIFIED IDEOGRAPH-6544
        0x6546, # G+13361  U+6546  uni6546,  CJK UNIFIED IDEOGRAPH-6546
        0x6547, # G+13362  U+6547  uni6547,  CJK UNIFIED IDEOGRAPH-6547
        0x654A, # G+13363  U+654A  uni654A,  CJK UNIFIED IDEOGRAPH-654A
        0x654B, # G+13364  U+654B  uni654B,  CJK UNIFIED IDEOGRAPH-654B
        0x654D, # G+13365  U+654D  uni654D,  CJK UNIFIED IDEOGRAPH-654D
        0x654E, # G+13366  U+654E  uni654E,  CJK UNIFIED IDEOGRAPH-654E
        0x6550, # G+13367  U+6550  uni6550,  CJK UNIFIED IDEOGRAPH-6550
        0x6552, # G+13368  U+6552  uni6552,  CJK UNIFIED IDEOGRAPH-6552
        0x6553, # G+13369  U+6553  uni6553,  CJK UNIFIED IDEOGRAPH-6553
        0x6554, # G+13370  U+6554  uni6554,  CJK UNIFIED IDEOGRAPH-6554
        0x6558, # G+13371  U+6558  uni6558,  CJK UNIFIED IDEOGRAPH-6558
        0x655A, # G+13372  U+655A  uni655A,  CJK UNIFIED IDEOGRAPH-655A
        0x655C, # G+13373  U+655C  uni655C,  CJK UNIFIED IDEOGRAPH-655C
        0x655F, # G+13374  U+655F  uni655F,  CJK UNIFIED IDEOGRAPH-655F
        0x6560, # G+13375  U+6560  uni6560,  CJK UNIFIED IDEOGRAPH-6560
        0x6561, # G+13376  U+6561  uni6561,  CJK UNIFIED IDEOGRAPH-6561
        0x6564, # G+13377  U+6564  uni6564,  CJK UNIFIED IDEOGRAPH-6564
        0x6565, # G+13378  U+6565  uni6565,  CJK UNIFIED IDEOGRAPH-6565
        0x6567, # G+13379  U+6567  uni6567,  CJK UNIFIED IDEOGRAPH-6567
        0x6568, # G+13380  U+6568  uni6568,  CJK UNIFIED IDEOGRAPH-6568
        0x6569, # G+13381  U+6569  uni6569,  CJK UNIFIED IDEOGRAPH-6569
        0x656A, # G+13382  U+656A  uni656A,  CJK UNIFIED IDEOGRAPH-656A
        0x656D, # G+13383  U+656D  uni656D,  CJK UNIFIED IDEOGRAPH-656D
        0x656E, # G+13384  U+656E  uni656E,  CJK UNIFIED IDEOGRAPH-656E
        0x656F, # G+13385  U+656F  uni656F,  CJK UNIFIED IDEOGRAPH-656F
        0x6571, # G+13386  U+6571  uni6571,  CJK UNIFIED IDEOGRAPH-6571
        0x6573, # G+13387  U+6573  uni6573,  CJK UNIFIED IDEOGRAPH-6573
        0x6576, # G+13388  U+6576  uni6576,  CJK UNIFIED IDEOGRAPH-6576
        0x6579, # G+13389  U+6579  uni6579,  CJK UNIFIED IDEOGRAPH-6579
        0x657A, # G+13390  U+657A  uni657A,  CJK UNIFIED IDEOGRAPH-657A
        0x657B, # G+13391  U+657B  uni657B,  CJK UNIFIED IDEOGRAPH-657B
        0x657C, # G+13392  U+657C  uni657C,  CJK UNIFIED IDEOGRAPH-657C
        0x657D, # G+13393  U+657D  uni657D,  CJK UNIFIED IDEOGRAPH-657D
        0x657E, # G+13394  U+657E  uni657E,  CJK UNIFIED IDEOGRAPH-657E
        0x657F, # G+13395  U+657F  uni657F,  CJK UNIFIED IDEOGRAPH-657F
        0x6580, # G+13396  U+6580  uni6580,  CJK UNIFIED IDEOGRAPH-6580
        0x6581, # G+13397  U+6581  uni6581,  CJK UNIFIED IDEOGRAPH-6581
        0x6584, # G+13398  U+6584  uni6584,  CJK UNIFIED IDEOGRAPH-6584
        0x6585, # G+13399  U+6585  uni6585,  CJK UNIFIED IDEOGRAPH-6585
        0x6586, # G+13400  U+6586  uni6586,  CJK UNIFIED IDEOGRAPH-6586
        0x6588, # G+13401  U+6588  uni6588,  CJK UNIFIED IDEOGRAPH-6588
        0x6589, # G+13402  U+6589  uni6589,  CJK UNIFIED IDEOGRAPH-6589
        0x658A, # G+13403  U+658A  uni658A,  CJK UNIFIED IDEOGRAPH-658A
        0x658D, # G+13404  U+658D  uni658D,  CJK UNIFIED IDEOGRAPH-658D
        0x658E, # G+13405  U+658E  uni658E,  CJK UNIFIED IDEOGRAPH-658E
        0x658F, # G+13406  U+658F  uni658F,  CJK UNIFIED IDEOGRAPH-658F
        0x6592, # G+13407  U+6592  uni6592,  CJK UNIFIED IDEOGRAPH-6592
        0x6594, # G+13408  U+6594  uni6594,  CJK UNIFIED IDEOGRAPH-6594
        0x6596, # G+13409  U+6596  uni6596,  CJK UNIFIED IDEOGRAPH-6596
        0x6598, # G+13410  U+6598  uni6598,  CJK UNIFIED IDEOGRAPH-6598
        0x659A, # G+13411  U+659A  uni659A,  CJK UNIFIED IDEOGRAPH-659A
        0x659D, # G+13412  U+659D  uni659D,  CJK UNIFIED IDEOGRAPH-659D
        0x659E, # G+13413  U+659E  uni659E,  CJK UNIFIED IDEOGRAPH-659E
        0x65A0, # G+13414  U+65A0  uni65A0,  CJK UNIFIED IDEOGRAPH-65A0
        0x65A2, # G+13415  U+65A2  uni65A2,  CJK UNIFIED IDEOGRAPH-65A2
        0x65A3, # G+13416  U+65A3  uni65A3,  CJK UNIFIED IDEOGRAPH-65A3
        0x65A6, # G+13417  U+65A6  uni65A6,  CJK UNIFIED IDEOGRAPH-65A6
        0x65A8, # G+13418  U+65A8  uni65A8,  CJK UNIFIED IDEOGRAPH-65A8
        0x65AA, # G+13419  U+65AA  uni65AA,  CJK UNIFIED IDEOGRAPH-65AA
        0x65AE, # G+13420  U+65AE  uni65AE,  CJK UNIFIED IDEOGRAPH-65AE
        0x65B1, # G+13421  U+65B1  uni65B1,  CJK UNIFIED IDEOGRAPH-65B1
        0x65B2, # G+13422  U+65B2  uni65B2,  CJK UNIFIED IDEOGRAPH-65B2
        0x65B3, # G+13423  U+65B3  uni65B3,  CJK UNIFIED IDEOGRAPH-65B3
        0x65B4, # G+13424  U+65B4  uni65B4,  CJK UNIFIED IDEOGRAPH-65B4
        0x65B5, # G+13425  U+65B5  uni65B5,  CJK UNIFIED IDEOGRAPH-65B5
        0x65B6, # G+13426  U+65B6  uni65B6,  CJK UNIFIED IDEOGRAPH-65B6
        0x65B8, # G+13427  U+65B8  uni65B8,  CJK UNIFIED IDEOGRAPH-65B8
        0x65BA, # G+13428  U+65BA  uni65BA,  CJK UNIFIED IDEOGRAPH-65BA
        0x65BB, # G+13429  U+65BB  uni65BB,  CJK UNIFIED IDEOGRAPH-65BB
        0x65BE, # G+13430  U+65BE  uni65BE,  CJK UNIFIED IDEOGRAPH-65BE
        0x65BF, # G+13431  U+65BF  uni65BF,  CJK UNIFIED IDEOGRAPH-65BF
        0x65C0, # G+13432  U+65C0  uni65C0,  CJK UNIFIED IDEOGRAPH-65C0
        0x65C2, # G+13433  U+65C2  uni65C2,  CJK UNIFIED IDEOGRAPH-65C2
        0x65C7, # G+13434  U+65C7  uni65C7,  CJK UNIFIED IDEOGRAPH-65C7
        0x65C8, # G+13435  U+65C8  uni65C8,  CJK UNIFIED IDEOGRAPH-65C8
        0x65C9, # G+13436  U+65C9  uni65C9,  CJK UNIFIED IDEOGRAPH-65C9
        0x65CA, # G+13437  U+65CA  uni65CA,  CJK UNIFIED IDEOGRAPH-65CA
        0x65CD, # G+13438  U+65CD  uni65CD,  CJK UNIFIED IDEOGRAPH-65CD
        0x65D0, # G+13439  U+65D0  uni65D0,  CJK UNIFIED IDEOGRAPH-65D0
        0x65D1, # G+13440  U+65D1  uni65D1,  CJK UNIFIED IDEOGRAPH-65D1
        0x65D3, # G+13441  U+65D3  uni65D3,  CJK UNIFIED IDEOGRAPH-65D3
        0x65D4, # G+13442  U+65D4  uni65D4,  CJK UNIFIED IDEOGRAPH-65D4
        0x65D5, # G+13443  U+65D5  uni65D5,  CJK UNIFIED IDEOGRAPH-65D5
        0x65D8, # G+13444  U+65D8  uni65D8,  CJK UNIFIED IDEOGRAPH-65D8
        0x65D9, # G+13445  U+65D9  uni65D9,  CJK UNIFIED IDEOGRAPH-65D9
        0x65DA, # G+13446  U+65DA  uni65DA,  CJK UNIFIED IDEOGRAPH-65DA
        0x65DB, # G+13447  U+65DB  uni65DB,  CJK UNIFIED IDEOGRAPH-65DB
        0x65DC, # G+13448  U+65DC  uni65DC,  CJK UNIFIED IDEOGRAPH-65DC
        0x65DD, # G+13449  U+65DD  uni65DD,  CJK UNIFIED IDEOGRAPH-65DD
        0x65DE, # G+13450  U+65DE  uni65DE,  CJK UNIFIED IDEOGRAPH-65DE
        0x65DF, # G+13451  U+65DF  uni65DF,  CJK UNIFIED IDEOGRAPH-65DF
        0x65E1, # G+13452  U+65E1  uni65E1,  CJK UNIFIED IDEOGRAPH-65E1
        0x65E3, # G+13453  U+65E3  uni65E3,  CJK UNIFIED IDEOGRAPH-65E3
        0x65E4, # G+13454  U+65E4  uni65E4,  CJK UNIFIED IDEOGRAPH-65E4
        0x65EA, # G+13455  U+65EA  uni65EA,  CJK UNIFIED IDEOGRAPH-65EA
        0x65EB, # G+13456  U+65EB  uni65EB,  CJK UNIFIED IDEOGRAPH-65EB
        0x65F2, # G+13457  U+65F2  uni65F2,  CJK UNIFIED IDEOGRAPH-65F2
        0x65F3, # G+13458  U+65F3  uni65F3,  CJK UNIFIED IDEOGRAPH-65F3
        0x65F4, # G+13459  U+65F4  uni65F4,  CJK UNIFIED IDEOGRAPH-65F4
        0x65F5, # G+13460  U+65F5  uni65F5,  CJK UNIFIED IDEOGRAPH-65F5
        0x65F8, # G+13461  U+65F8  uni65F8,  CJK UNIFIED IDEOGRAPH-65F8
        0x65F9, # G+13462  U+65F9  uni65F9,  CJK UNIFIED IDEOGRAPH-65F9
        0x65FB, # G+13463  U+65FB  uni65FB,  CJK UNIFIED IDEOGRAPH-65FB
        0x65FC, # G+13464  U+65FC  uni65FC,  CJK UNIFIED IDEOGRAPH-65FC
        0x65FD, # G+13465  U+65FD  uni65FD,  CJK UNIFIED IDEOGRAPH-65FD
        0x65FE, # G+13466  U+65FE  uni65FE,  CJK UNIFIED IDEOGRAPH-65FE
        0x65FF, # G+13467  U+65FF  uni65FF,  CJK UNIFIED IDEOGRAPH-65FF
        0x6601, # G+13468  U+6601  uni6601,  CJK UNIFIED IDEOGRAPH-6601
        0x6604, # G+13469  U+6604  uni6604,  CJK UNIFIED IDEOGRAPH-6604
        0x6605, # G+13470  U+6605  uni6605,  CJK UNIFIED IDEOGRAPH-6605
        0x6607, # G+13471  U+6607  uni6607,  CJK UNIFIED IDEOGRAPH-6607
        0x6608, # G+13472  U+6608  uni6608,  CJK UNIFIED IDEOGRAPH-6608
        0x6609, # G+13473  U+6609  uni6609,  CJK UNIFIED IDEOGRAPH-6609
        0x660B, # G+13474  U+660B  uni660B,  CJK UNIFIED IDEOGRAPH-660B
        0x660D, # G+13475  U+660D  uni660D,  CJK UNIFIED IDEOGRAPH-660D
        0x6610, # G+13476  U+6610  uni6610,  CJK UNIFIED IDEOGRAPH-6610
        0x6611, # G+13477  U+6611  uni6611,  CJK UNIFIED IDEOGRAPH-6611
        0x6612, # G+13478  U+6612  uni6612,  CJK UNIFIED IDEOGRAPH-6612
        0x6616, # G+13479  U+6616  uni6616,  CJK UNIFIED IDEOGRAPH-6616
        0x6617, # G+13480  U+6617  uni6617,  CJK UNIFIED IDEOGRAPH-6617
        0x6618, # G+13481  U+6618  uni6618,  CJK UNIFIED IDEOGRAPH-6618
        0x661A, # G+13482  U+661A  uni661A,  CJK UNIFIED IDEOGRAPH-661A
        0x661B, # G+13483  U+661B  uni661B,  CJK UNIFIED IDEOGRAPH-661B
        0x661C, # G+13484  U+661C  uni661C,  CJK UNIFIED IDEOGRAPH-661C
        0x661E, # G+13485  U+661E  uni661E,  CJK UNIFIED IDEOGRAPH-661E
        0x6621, # G+13486  U+6621  uni6621,  CJK UNIFIED IDEOGRAPH-6621
        0x6622, # G+13487  U+6622  uni6622,  CJK UNIFIED IDEOGRAPH-6622
        0x6623, # G+13488  U+6623  uni6623,  CJK UNIFIED IDEOGRAPH-6623
        0x6624, # G+13489  U+6624  uni6624,  CJK UNIFIED IDEOGRAPH-6624
        0x6626, # G+13490  U+6626  uni6626,  CJK UNIFIED IDEOGRAPH-6626
        0x6629, # G+13491  U+6629  uni6629,  CJK UNIFIED IDEOGRAPH-6629
        0x662A, # G+13492  U+662A  uni662A,  CJK UNIFIED IDEOGRAPH-662A
        0x662B, # G+13493  U+662B  uni662B,  CJK UNIFIED IDEOGRAPH-662B
        0x662C, # G+13494  U+662C  uni662C,  CJK UNIFIED IDEOGRAPH-662C
        0x662E, # G+13495  U+662E  uni662E,  CJK UNIFIED IDEOGRAPH-662E
        0x6630, # G+13496  U+6630  uni6630,  CJK UNIFIED IDEOGRAPH-6630
        0x6632, # G+13497  U+6632  uni6632,  CJK UNIFIED IDEOGRAPH-6632
        0x6633, # G+13498  U+6633  uni6633,  CJK UNIFIED IDEOGRAPH-6633
        0x6637, # G+13499  U+6637  uni6637,  CJK UNIFIED IDEOGRAPH-6637
        0x6638, # G+13500  U+6638  uni6638,  CJK UNIFIED IDEOGRAPH-6638
        0x6639, # G+13501  U+6639  uni6639,  CJK UNIFIED IDEOGRAPH-6639
        0x663A, # G+13502  U+663A  uni663A,  CJK UNIFIED IDEOGRAPH-663A
        0x663B, # G+13503  U+663B  uni663B,  CJK UNIFIED IDEOGRAPH-663B
        0x663D, # G+13504  U+663D  uni663D,  CJK UNIFIED IDEOGRAPH-663D
        0x663F, # G+13505  U+663F  uni663F,  CJK UNIFIED IDEOGRAPH-663F
        0x6640, # G+13506  U+6640  uni6640,  CJK UNIFIED IDEOGRAPH-6640
        0x6644, # G+13507  U+6644  uni6644,  CJK UNIFIED IDEOGRAPH-6644
        0x6645, # G+13508  U+6645  uni6645,  CJK UNIFIED IDEOGRAPH-6645
        0x6646, # G+13509  U+6646  uni6646,  CJK UNIFIED IDEOGRAPH-6646
        0x6647, # G+13510  U+6647  uni6647,  CJK UNIFIED IDEOGRAPH-6647
        0x6648, # G+13511  U+6648  uni6648,  CJK UNIFIED IDEOGRAPH-6648
        0x6649, # G+13512  U+6649  uni6649,  CJK UNIFIED IDEOGRAPH-6649
        0x664A, # G+13513  U+664A  uni664A,  CJK UNIFIED IDEOGRAPH-664A
        0x664D, # G+13514  U+664D  uni664D,  CJK UNIFIED IDEOGRAPH-664D
        0x664E, # G+13515  U+664E  uni664E,  CJK UNIFIED IDEOGRAPH-664E
        0x6650, # G+13516  U+6650  uni6650,  CJK UNIFIED IDEOGRAPH-6650
        0x6651, # G+13517  U+6651  uni6651,  CJK UNIFIED IDEOGRAPH-6651
        0x6658, # G+13518  U+6658  uni6658,  CJK UNIFIED IDEOGRAPH-6658
        0x6659, # G+13519  U+6659  uni6659,  CJK UNIFIED IDEOGRAPH-6659
        0x665B, # G+13520  U+665B  uni665B,  CJK UNIFIED IDEOGRAPH-665B
        0x665C, # G+13521  U+665C  uni665C,  CJK UNIFIED IDEOGRAPH-665C
        0x665E, # G+13522  U+665E  uni665E,  CJK UNIFIED IDEOGRAPH-665E
        0x6660, # G+13523  U+6660  uni6660,  CJK UNIFIED IDEOGRAPH-6660
        0x6662, # G+13524  U+6662  uni6662,  CJK UNIFIED IDEOGRAPH-6662
        0x6663, # G+13525  U+6663  uni6663,  CJK UNIFIED IDEOGRAPH-6663
        0x6665, # G+13526  U+6665  uni6665,  CJK UNIFIED IDEOGRAPH-6665
        0x6667, # G+13527  U+6667  uni6667,  CJK UNIFIED IDEOGRAPH-6667
        0x6669, # G+13528  U+6669  uni6669,  CJK UNIFIED IDEOGRAPH-6669
        0x666A, # G+13529  U+666A  uni666A,  CJK UNIFIED IDEOGRAPH-666A
        0x666B, # G+13530  U+666B  uni666B,  CJK UNIFIED IDEOGRAPH-666B
        0x666C, # G+13531  U+666C  uni666C,  CJK UNIFIED IDEOGRAPH-666C
        0x666D, # G+13532  U+666D  uni666D,  CJK UNIFIED IDEOGRAPH-666D
        0x6671, # G+13533  U+6671  uni6671,  CJK UNIFIED IDEOGRAPH-6671
        0x6672, # G+13534  U+6672  uni6672,  CJK UNIFIED IDEOGRAPH-6672
        0x6673, # G+13535  U+6673  uni6673,  CJK UNIFIED IDEOGRAPH-6673
        0x6675, # G+13536  U+6675  uni6675,  CJK UNIFIED IDEOGRAPH-6675
        0x6678, # G+13537  U+6678  uni6678,  CJK UNIFIED IDEOGRAPH-6678
        0x6679, # G+13538  U+6679  uni6679,  CJK UNIFIED IDEOGRAPH-6679
        0x667B, # G+13539  U+667B  uni667B,  CJK UNIFIED IDEOGRAPH-667B
        0x667C, # G+13540  U+667C  uni667C,  CJK UNIFIED IDEOGRAPH-667C
        0x667D, # G+13541  U+667D  uni667D,  CJK UNIFIED IDEOGRAPH-667D
        0x667F, # G+13542  U+667F  uni667F,  CJK UNIFIED IDEOGRAPH-667F
        0x6680, # G+13543  U+6680  uni6680,  CJK UNIFIED IDEOGRAPH-6680
        0x6681, # G+13544  U+6681  uni6681,  CJK UNIFIED IDEOGRAPH-6681
        0x6683, # G+13545  U+6683  uni6683,  CJK UNIFIED IDEOGRAPH-6683
        0x6685, # G+13546  U+6685  uni6685,  CJK UNIFIED IDEOGRAPH-6685
        0x6686, # G+13547  U+6686  uni6686,  CJK UNIFIED IDEOGRAPH-6686
        0x668A, # G+13548  U+668A  uni668A,  CJK UNIFIED IDEOGRAPH-668A
        0x668B, # G+13549  U+668B  uni668B,  CJK UNIFIED IDEOGRAPH-668B
        0x668D, # G+13550  U+668D  uni668D,  CJK UNIFIED IDEOGRAPH-668D
        0x668E, # G+13551  U+668E  uni668E,  CJK UNIFIED IDEOGRAPH-668E
        0x668F, # G+13552  U+668F  uni668F,  CJK UNIFIED IDEOGRAPH-668F
        0x6690, # G+13553  U+6690  uni6690,  CJK UNIFIED IDEOGRAPH-6690
        0x6692, # G+13554  U+6692  uni6692,  CJK UNIFIED IDEOGRAPH-6692
        0x6693, # G+13555  U+6693  uni6693,  CJK UNIFIED IDEOGRAPH-6693
        0x6694, # G+13556  U+6694  uni6694,  CJK UNIFIED IDEOGRAPH-6694
        0x6695, # G+13557  U+6695  uni6695,  CJK UNIFIED IDEOGRAPH-6695
        0x6698, # G+13558  U+6698  uni6698,  CJK UNIFIED IDEOGRAPH-6698
        0x6699, # G+13559  U+6699  uni6699,  CJK UNIFIED IDEOGRAPH-6699
        0x669A, # G+13560  U+669A  uni669A,  CJK UNIFIED IDEOGRAPH-669A
        0x669B, # G+13561  U+669B  uni669B,  CJK UNIFIED IDEOGRAPH-669B
        0x669C, # G+13562  U+669C  uni669C,  CJK UNIFIED IDEOGRAPH-669C
        0x669E, # G+13563  U+669E  uni669E,  CJK UNIFIED IDEOGRAPH-669E
        0x669F, # G+13564  U+669F  uni669F,  CJK UNIFIED IDEOGRAPH-669F
        0x66A0, # G+13565  U+66A0  uni66A0,  CJK UNIFIED IDEOGRAPH-66A0
        0x66A1, # G+13566  U+66A1  uni66A1,  CJK UNIFIED IDEOGRAPH-66A1
        0x66A3, # G+13567  U+66A3  uni66A3,  CJK UNIFIED IDEOGRAPH-66A3
        0x66A4, # G+13568  U+66A4  uni66A4,  CJK UNIFIED IDEOGRAPH-66A4
        0x66A5, # G+13569  U+66A5  uni66A5,  CJK UNIFIED IDEOGRAPH-66A5
        0x66A6, # G+13570  U+66A6  uni66A6,  CJK UNIFIED IDEOGRAPH-66A6
        0x66A9, # G+13571  U+66A9  uni66A9,  CJK UNIFIED IDEOGRAPH-66A9
        0x66AA, # G+13572  U+66AA  uni66AA,  CJK UNIFIED IDEOGRAPH-66AA
        0x66AC, # G+13573  U+66AC  uni66AC,  CJK UNIFIED IDEOGRAPH-66AC
        0x66AD, # G+13574  U+66AD  uni66AD,  CJK UNIFIED IDEOGRAPH-66AD
        0x66AF, # G+13575  U+66AF  uni66AF,  CJK UNIFIED IDEOGRAPH-66AF
        0x66B0, # G+13576  U+66B0  uni66B0,  CJK UNIFIED IDEOGRAPH-66B0
        0x66B1, # G+13577  U+66B1  uni66B1,  CJK UNIFIED IDEOGRAPH-66B1
        0x66B2, # G+13578  U+66B2  uni66B2,  CJK UNIFIED IDEOGRAPH-66B2
        0x66B3, # G+13579  U+66B3  uni66B3,  CJK UNIFIED IDEOGRAPH-66B3
        0x66B5, # G+13580  U+66B5  uni66B5,  CJK UNIFIED IDEOGRAPH-66B5
        0x66B6, # G+13581  U+66B6  uni66B6,  CJK UNIFIED IDEOGRAPH-66B6
        0x66B7, # G+13582  U+66B7  uni66B7,  CJK UNIFIED IDEOGRAPH-66B7
        0x66B8, # G+13583  U+66B8  uni66B8,  CJK UNIFIED IDEOGRAPH-66B8
        0x66BA, # G+13584  U+66BA  uni66BA,  CJK UNIFIED IDEOGRAPH-66BA
        0x66BB, # G+13585  U+66BB  uni66BB,  CJK UNIFIED IDEOGRAPH-66BB
        0x66BC, # G+13586  U+66BC  uni66BC,  CJK UNIFIED IDEOGRAPH-66BC
        0x66BD, # G+13587  U+66BD  uni66BD,  CJK UNIFIED IDEOGRAPH-66BD
        0x66BF, # G+13588  U+66BF  uni66BF,  CJK UNIFIED IDEOGRAPH-66BF
        0x66C0, # G+13589  U+66C0  uni66C0,  CJK UNIFIED IDEOGRAPH-66C0
        0x66C1, # G+13590  U+66C1  uni66C1,  CJK UNIFIED IDEOGRAPH-66C1
        0x66C2, # G+13591  U+66C2  uni66C2,  CJK UNIFIED IDEOGRAPH-66C2
        0x66C3, # G+13592  U+66C3  uni66C3,  CJK UNIFIED IDEOGRAPH-66C3
        0x66C5, # G+13593  U+66C5  uni66C5,  CJK UNIFIED IDEOGRAPH-66C5
        0x66C8, # G+13594  U+66C8  uni66C8,  CJK UNIFIED IDEOGRAPH-66C8
        0x66CA, # G+13595  U+66CA  uni66CA,  CJK UNIFIED IDEOGRAPH-66CA
        0x66CB, # G+13596  U+66CB  uni66CB,  CJK UNIFIED IDEOGRAPH-66CB
        0x66CC, # G+13597  U+66CC  uni66CC,  CJK UNIFIED IDEOGRAPH-66CC
        0x66CD, # G+13598  U+66CD  uni66CD,  CJK UNIFIED IDEOGRAPH-66CD
        0x66CE, # G+13599  U+66CE  uni66CE,  CJK UNIFIED IDEOGRAPH-66CE
        0x66CF, # G+13600  U+66CF  uni66CF,  CJK UNIFIED IDEOGRAPH-66CF
        0x66D0, # G+13601  U+66D0  uni66D0,  CJK UNIFIED IDEOGRAPH-66D0
        0x66D1, # G+13602  U+66D1  uni66D1,  CJK UNIFIED IDEOGRAPH-66D1
        0x66D2, # G+13603  U+66D2  uni66D2,  CJK UNIFIED IDEOGRAPH-66D2
        0x66D3, # G+13604  U+66D3  uni66D3,  CJK UNIFIED IDEOGRAPH-66D3
        0x66D4, # G+13605  U+66D4  uni66D4,  CJK UNIFIED IDEOGRAPH-66D4
        0x66D5, # G+13606  U+66D5  uni66D5,  CJK UNIFIED IDEOGRAPH-66D5
        0x66D7, # G+13607  U+66D7  uni66D7,  CJK UNIFIED IDEOGRAPH-66D7
        0x66D8, # G+13608  U+66D8  uni66D8,  CJK UNIFIED IDEOGRAPH-66D8
        0x66DA, # G+13609  U+66DA  uni66DA,  CJK UNIFIED IDEOGRAPH-66DA
        0x66DE, # G+13610  U+66DE  uni66DE,  CJK UNIFIED IDEOGRAPH-66DE
        0x66DF, # G+13611  U+66DF  uni66DF,  CJK UNIFIED IDEOGRAPH-66DF
        0x66E1, # G+13612  U+66E1  uni66E1,  CJK UNIFIED IDEOGRAPH-66E1
        0x66E2, # G+13613  U+66E2  uni66E2,  CJK UNIFIED IDEOGRAPH-66E2
        0x66E3, # G+13614  U+66E3  uni66E3,  CJK UNIFIED IDEOGRAPH-66E3
        0x66E4, # G+13615  U+66E4  uni66E4,  CJK UNIFIED IDEOGRAPH-66E4
        0x66E5, # G+13616  U+66E5  uni66E5,  CJK UNIFIED IDEOGRAPH-66E5
        0x66E7, # G+13617  U+66E7  uni66E7,  CJK UNIFIED IDEOGRAPH-66E7
        0x66E8, # G+13618  U+66E8  uni66E8,  CJK UNIFIED IDEOGRAPH-66E8
        0x66EA, # G+13619  U+66EA  uni66EA,  CJK UNIFIED IDEOGRAPH-66EA
        0x66EB, # G+13620  U+66EB  uni66EB,  CJK UNIFIED IDEOGRAPH-66EB
        0x66ED, # G+13621  U+66ED  uni66ED,  CJK UNIFIED IDEOGRAPH-66ED
        0x66EE, # G+13622  U+66EE  uni66EE,  CJK UNIFIED IDEOGRAPH-66EE
        0x66EF, # G+13623  U+66EF  uni66EF,  CJK UNIFIED IDEOGRAPH-66EF
        0x66F1, # G+13624  U+66F1  uni66F1,  CJK UNIFIED IDEOGRAPH-66F1
        0x66F5, # G+13625  U+66F5  uni66F5,  CJK UNIFIED IDEOGRAPH-66F5
        0x66F6, # G+13626  U+66F6  uni66F6,  CJK UNIFIED IDEOGRAPH-66F6
        0x66FA, # G+13627  U+66FA  uni66FA,  CJK UNIFIED IDEOGRAPH-66FA
        0x66FB, # G+13628  U+66FB  uni66FB,  CJK UNIFIED IDEOGRAPH-66FB
        0x66FD, # G+13629  U+66FD  uni66FD,  CJK UNIFIED IDEOGRAPH-66FD
        0x6701, # G+13630  U+6701  uni6701,  CJK UNIFIED IDEOGRAPH-6701
        0x6702, # G+13631  U+6702  uni6702,  CJK UNIFIED IDEOGRAPH-6702
        0x6704, # G+13632  U+6704  uni6704,  CJK UNIFIED IDEOGRAPH-6704
        0x6705, # G+13633  U+6705  uni6705,  CJK UNIFIED IDEOGRAPH-6705
        0x6706, # G+13634  U+6706  uni6706,  CJK UNIFIED IDEOGRAPH-6706
        0x6707, # G+13635  U+6707  uni6707,  CJK UNIFIED IDEOGRAPH-6707
        0x670C, # G+13636  U+670C  uni670C,  CJK UNIFIED IDEOGRAPH-670C
        0x670E, # G+13637  U+670E  uni670E,  CJK UNIFIED IDEOGRAPH-670E
        0x670F, # G+13638  U+670F  uni670F,  CJK UNIFIED IDEOGRAPH-670F
        0x6711, # G+13639  U+6711  uni6711,  CJK UNIFIED IDEOGRAPH-6711
        0x6712, # G+13640  U+6712  uni6712,  CJK UNIFIED IDEOGRAPH-6712
        0x6713, # G+13641  U+6713  uni6713,  CJK UNIFIED IDEOGRAPH-6713
        0x6716, # G+13642  U+6716  uni6716,  CJK UNIFIED IDEOGRAPH-6716
        0x6718, # G+13643  U+6718  uni6718,  CJK UNIFIED IDEOGRAPH-6718
        0x6719, # G+13644  U+6719  uni6719,  CJK UNIFIED IDEOGRAPH-6719
        0x671A, # G+13645  U+671A  uni671A,  CJK UNIFIED IDEOGRAPH-671A
        0x671C, # G+13646  U+671C  uni671C,  CJK UNIFIED IDEOGRAPH-671C
        0x671E, # G+13647  U+671E  uni671E,  CJK UNIFIED IDEOGRAPH-671E
        0x6720, # G+13648  U+6720  uni6720,  CJK UNIFIED IDEOGRAPH-6720
        0x6721, # G+13649  U+6721  uni6721,  CJK UNIFIED IDEOGRAPH-6721
        0x6722, # G+13650  U+6722  uni6722,  CJK UNIFIED IDEOGRAPH-6722
        0x6723, # G+13651  U+6723  uni6723,  CJK UNIFIED IDEOGRAPH-6723
        0x6724, # G+13652  U+6724  uni6724,  CJK UNIFIED IDEOGRAPH-6724
        0x6725, # G+13653  U+6725  uni6725,  CJK UNIFIED IDEOGRAPH-6725
        0x6729, # G+13654  U+6729  uni6729,  CJK UNIFIED IDEOGRAPH-6729
        0x672E, # G+13655  U+672E  uni672E,  CJK UNIFIED IDEOGRAPH-672E
        0x6730, # G+13656  U+6730  uni6730,  CJK UNIFIED IDEOGRAPH-6730
        0x6732, # G+13657  U+6732  uni6732,  CJK UNIFIED IDEOGRAPH-6732
        0x6733, # G+13658  U+6733  uni6733,  CJK UNIFIED IDEOGRAPH-6733
        0x6736, # G+13659  U+6736  uni6736,  CJK UNIFIED IDEOGRAPH-6736
        0x6737, # G+13660  U+6737  uni6737,  CJK UNIFIED IDEOGRAPH-6737
        0x6738, # G+13661  U+6738  uni6738,  CJK UNIFIED IDEOGRAPH-6738
        0x6739, # G+13662  U+6739  uni6739,  CJK UNIFIED IDEOGRAPH-6739
        0x673B, # G+13663  U+673B  uni673B,  CJK UNIFIED IDEOGRAPH-673B
        0x673C, # G+13664  U+673C  uni673C,  CJK UNIFIED IDEOGRAPH-673C
        0x673E, # G+13665  U+673E  uni673E,  CJK UNIFIED IDEOGRAPH-673E
        0x673F, # G+13666  U+673F  uni673F,  CJK UNIFIED IDEOGRAPH-673F
        0x6741, # G+13667  U+6741  uni6741,  CJK UNIFIED IDEOGRAPH-6741
        0x6744, # G+13668  U+6744  uni6744,  CJK UNIFIED IDEOGRAPH-6744
        0x6745, # G+13669  U+6745  uni6745,  CJK UNIFIED IDEOGRAPH-6745
        0x6747, # G+13670  U+6747  uni6747,  CJK UNIFIED IDEOGRAPH-6747
        0x674A, # G+13671  U+674A  uni674A,  CJK UNIFIED IDEOGRAPH-674A
        0x674B, # G+13672  U+674B  uni674B,  CJK UNIFIED IDEOGRAPH-674B
        0x674D, # G+13673  U+674D  uni674D,  CJK UNIFIED IDEOGRAPH-674D
        0x6752, # G+13674  U+6752  uni6752,  CJK UNIFIED IDEOGRAPH-6752
        0x6754, # G+13675  U+6754  uni6754,  CJK UNIFIED IDEOGRAPH-6754
        0x6755, # G+13676  U+6755  uni6755,  CJK UNIFIED IDEOGRAPH-6755
        0x6757, # G+13677  U+6757  uni6757,  CJK UNIFIED IDEOGRAPH-6757
        0x6758, # G+13678  U+6758  uni6758,  CJK UNIFIED IDEOGRAPH-6758
        0x6759, # G+13679  U+6759  uni6759,  CJK UNIFIED IDEOGRAPH-6759
        0x675A, # G+13680  U+675A  uni675A,  CJK UNIFIED IDEOGRAPH-675A
        0x675B, # G+13681  U+675B  uni675B,  CJK UNIFIED IDEOGRAPH-675B
        0x675D, # G+13682  U+675D  uni675D,  CJK UNIFIED IDEOGRAPH-675D
        0x6762, # G+13683  U+6762  uni6762,  CJK UNIFIED IDEOGRAPH-6762
        0x6763, # G+13684  U+6763  uni6763,  CJK UNIFIED IDEOGRAPH-6763
        0x6764, # G+13685  U+6764  uni6764,  CJK UNIFIED IDEOGRAPH-6764
        0x6766, # G+13686  U+6766  uni6766,  CJK UNIFIED IDEOGRAPH-6766
        0x6767, # G+13687  U+6767  uni6767,  CJK UNIFIED IDEOGRAPH-6767
        0x676B, # G+13688  U+676B  uni676B,  CJK UNIFIED IDEOGRAPH-676B
        0x676C, # G+13689  U+676C  uni676C,  CJK UNIFIED IDEOGRAPH-676C
        0x676E, # G+13690  U+676E  uni676E,  CJK UNIFIED IDEOGRAPH-676E
        0x6774, # G+13691  U+6774  uni6774,  CJK UNIFIED IDEOGRAPH-6774
        0x6776, # G+13692  U+6776  uni6776,  CJK UNIFIED IDEOGRAPH-6776
        0x6778, # G+13693  U+6778  uni6778,  CJK UNIFIED IDEOGRAPH-6778
        0x6779, # G+13694  U+6779  uni6779,  CJK UNIFIED IDEOGRAPH-6779
        0x677A, # G+13695  U+677A  uni677A,  CJK UNIFIED IDEOGRAPH-677A
        0x677B, # G+13696  U+677B  uni677B,  CJK UNIFIED IDEOGRAPH-677B
        0x677D, # G+13697  U+677D  uni677D,  CJK UNIFIED IDEOGRAPH-677D
        0x6780, # G+13698  U+6780  uni6780,  CJK UNIFIED IDEOGRAPH-6780
        0x6782, # G+13699  U+6782  uni6782,  CJK UNIFIED IDEOGRAPH-6782
        0x6783, # G+13700  U+6783  uni6783,  CJK UNIFIED IDEOGRAPH-6783
        0x6785, # G+13701  U+6785  uni6785,  CJK UNIFIED IDEOGRAPH-6785
        0x6786, # G+13702  U+6786  uni6786,  CJK UNIFIED IDEOGRAPH-6786
        0x6788, # G+13703  U+6788  uni6788,  CJK UNIFIED IDEOGRAPH-6788
        0x678A, # G+13704  U+678A  uni678A,  CJK UNIFIED IDEOGRAPH-678A
        0x678C, # G+13705  U+678C  uni678C,  CJK UNIFIED IDEOGRAPH-678C
        0x678D, # G+13706  U+678D  uni678D,  CJK UNIFIED IDEOGRAPH-678D
        0x678E, # G+13707  U+678E  uni678E,  CJK UNIFIED IDEOGRAPH-678E
        0x678F, # G+13708  U+678F  uni678F,  CJK UNIFIED IDEOGRAPH-678F
        0x6791, # G+13709  U+6791  uni6791,  CJK UNIFIED IDEOGRAPH-6791
        0x6792, # G+13710  U+6792  uni6792,  CJK UNIFIED IDEOGRAPH-6792
        0x6793, # G+13711  U+6793  uni6793,  CJK UNIFIED IDEOGRAPH-6793
        0x6794, # G+13712  U+6794  uni6794,  CJK UNIFIED IDEOGRAPH-6794
        0x6796, # G+13713  U+6796  uni6796,  CJK UNIFIED IDEOGRAPH-6796
        0x6799, # G+13714  U+6799  uni6799,  CJK UNIFIED IDEOGRAPH-6799
        0x679B, # G+13715  U+679B  uni679B,  CJK UNIFIED IDEOGRAPH-679B
        0x679F, # G+13716  U+679F  uni679F,  CJK UNIFIED IDEOGRAPH-679F
        0x67A0, # G+13717  U+67A0  uni67A0,  CJK UNIFIED IDEOGRAPH-67A0
        0x67A1, # G+13718  U+67A1  uni67A1,  CJK UNIFIED IDEOGRAPH-67A1
        0x67A4, # G+13719  U+67A4  uni67A4,  CJK UNIFIED IDEOGRAPH-67A4
        0x67A6, # G+13720  U+67A6  uni67A6,  CJK UNIFIED IDEOGRAPH-67A6
        0x67A9, # G+13721  U+67A9  uni67A9,  CJK UNIFIED IDEOGRAPH-67A9
        0x67AC, # G+13722  U+67AC  uni67AC,  CJK UNIFIED IDEOGRAPH-67AC
        0x67AE, # G+13723  U+67AE  uni67AE,  CJK UNIFIED IDEOGRAPH-67AE
        0x67B1, # G+13724  U+67B1  uni67B1,  CJK UNIFIED IDEOGRAPH-67B1
        0x67B2, # G+13725  U+67B2  uni67B2,  CJK UNIFIED IDEOGRAPH-67B2
        0x67B4, # G+13726  U+67B4  uni67B4,  CJK UNIFIED IDEOGRAPH-67B4
        0x67B9, # G+13727  U+67B9  uni67B9,  CJK UNIFIED IDEOGRAPH-67B9
        0x67BA, # G+13728  U+67BA  uni67BA,  CJK UNIFIED IDEOGRAPH-67BA
        0x67BB, # G+13729  U+67BB  uni67BB,  CJK UNIFIED IDEOGRAPH-67BB
        0x67BC, # G+13730  U+67BC  uni67BC,  CJK UNIFIED IDEOGRAPH-67BC
        0x67BD, # G+13731  U+67BD  uni67BD,  CJK UNIFIED IDEOGRAPH-67BD
        0x67BE, # G+13732  U+67BE  uni67BE,  CJK UNIFIED IDEOGRAPH-67BE
        0x67BF, # G+13733  U+67BF  uni67BF,  CJK UNIFIED IDEOGRAPH-67BF
        0x67C0, # G+13734  U+67C0  uni67C0,  CJK UNIFIED IDEOGRAPH-67C0
        0x67C2, # G+13735  U+67C2  uni67C2,  CJK UNIFIED IDEOGRAPH-67C2
        0x67C5, # G+13736  U+67C5  uni67C5,  CJK UNIFIED IDEOGRAPH-67C5
        0x67C6, # G+13737  U+67C6  uni67C6,  CJK UNIFIED IDEOGRAPH-67C6
        0x67C7, # G+13738  U+67C7  uni67C7,  CJK UNIFIED IDEOGRAPH-67C7
        0x67C8, # G+13739  U+67C8  uni67C8,  CJK UNIFIED IDEOGRAPH-67C8
        0x67C9, # G+13740  U+67C9  uni67C9,  CJK UNIFIED IDEOGRAPH-67C9
        0x67CA, # G+13741  U+67CA  uni67CA,  CJK UNIFIED IDEOGRAPH-67CA
        0x67CB, # G+13742  U+67CB  uni67CB,  CJK UNIFIED IDEOGRAPH-67CB
        0x67CC, # G+13743  U+67CC  uni67CC,  CJK UNIFIED IDEOGRAPH-67CC
        0x67CD, # G+13744  U+67CD  uni67CD,  CJK UNIFIED IDEOGRAPH-67CD
        0x67CE, # G+13745  U+67CE  uni67CE,  CJK UNIFIED IDEOGRAPH-67CE
        0x67D5, # G+13746  U+67D5  uni67D5,  CJK UNIFIED IDEOGRAPH-67D5
        0x67D6, # G+13747  U+67D6  uni67D6,  CJK UNIFIED IDEOGRAPH-67D6
        0x67D7, # G+13748  U+67D7  uni67D7,  CJK UNIFIED IDEOGRAPH-67D7
        0x67DB, # G+13749  U+67DB  uni67DB,  CJK UNIFIED IDEOGRAPH-67DB
        0x67DF, # G+13750  U+67DF  uni67DF,  CJK UNIFIED IDEOGRAPH-67DF
        0x67E1, # G+13751  U+67E1  uni67E1,  CJK UNIFIED IDEOGRAPH-67E1
        0x67E3, # G+13752  U+67E3  uni67E3,  CJK UNIFIED IDEOGRAPH-67E3
        0x67E4, # G+13753  U+67E4  uni67E4,  CJK UNIFIED IDEOGRAPH-67E4
        0x67E6, # G+13754  U+67E6  uni67E6,  CJK UNIFIED IDEOGRAPH-67E6
        0x67E7, # G+13755  U+67E7  uni67E7,  CJK UNIFIED IDEOGRAPH-67E7
        0x67E8, # G+13756  U+67E8  uni67E8,  CJK UNIFIED IDEOGRAPH-67E8
        0x67EA, # G+13757  U+67EA  uni67EA,  CJK UNIFIED IDEOGRAPH-67EA
        0x67EB, # G+13758  U+67EB  uni67EB,  CJK UNIFIED IDEOGRAPH-67EB
        0x67ED, # G+13759  U+67ED  uni67ED,  CJK UNIFIED IDEOGRAPH-67ED
        0x67EE, # G+13760  U+67EE  uni67EE,  CJK UNIFIED IDEOGRAPH-67EE
        0x67F2, # G+13761  U+67F2  uni67F2,  CJK UNIFIED IDEOGRAPH-67F2
        0x67F5, # G+13762  U+67F5  uni67F5,  CJK UNIFIED IDEOGRAPH-67F5
        0x67F6, # G+13763  U+67F6  uni67F6,  CJK UNIFIED IDEOGRAPH-67F6
        0x67F7, # G+13764  U+67F7  uni67F7,  CJK UNIFIED IDEOGRAPH-67F7
        0x67F8, # G+13765  U+67F8  uni67F8,  CJK UNIFIED IDEOGRAPH-67F8
        0x67F9, # G+13766  U+67F9  uni67F9,  CJK UNIFIED IDEOGRAPH-67F9
        0x67FA, # G+13767  U+67FA  uni67FA,  CJK UNIFIED IDEOGRAPH-67FA
        0x67FB, # G+13768  U+67FB  uni67FB,  CJK UNIFIED IDEOGRAPH-67FB
        0x67FC, # G+13769  U+67FC  uni67FC,  CJK UNIFIED IDEOGRAPH-67FC
        0x67FE, # G+13770  U+67FE  uni67FE,  CJK UNIFIED IDEOGRAPH-67FE
        0x6801, # G+13771  U+6801  uni6801,  CJK UNIFIED IDEOGRAPH-6801
        0x6802, # G+13772  U+6802  uni6802,  CJK UNIFIED IDEOGRAPH-6802
        0x6803, # G+13773  U+6803  uni6803,  CJK UNIFIED IDEOGRAPH-6803
        0x6804, # G+13774  U+6804  uni6804,  CJK UNIFIED IDEOGRAPH-6804
        0x6806, # G+13775  U+6806  uni6806,  CJK UNIFIED IDEOGRAPH-6806
        0x680D, # G+13776  U+680D  uni680D,  CJK UNIFIED IDEOGRAPH-680D
        0x6810, # G+13777  U+6810  uni6810,  CJK UNIFIED IDEOGRAPH-6810
        0x6812, # G+13778  U+6812  uni6812,  CJK UNIFIED IDEOGRAPH-6812
        0x6814, # G+13779  U+6814  uni6814,  CJK UNIFIED IDEOGRAPH-6814
        0x6815, # G+13780  U+6815  uni6815,  CJK UNIFIED IDEOGRAPH-6815
        0x6818, # G+13781  U+6818  uni6818,  CJK UNIFIED IDEOGRAPH-6818
        0x6819, # G+13782  U+6819  uni6819,  CJK UNIFIED IDEOGRAPH-6819
        0x681A, # G+13783  U+681A  uni681A,  CJK UNIFIED IDEOGRAPH-681A
        0x681B, # G+13784  U+681B  uni681B,  CJK UNIFIED IDEOGRAPH-681B
        0x681C, # G+13785  U+681C  uni681C,  CJK UNIFIED IDEOGRAPH-681C
        0x681E, # G+13786  U+681E  uni681E,  CJK UNIFIED IDEOGRAPH-681E
        0x681F, # G+13787  U+681F  uni681F,  CJK UNIFIED IDEOGRAPH-681F
        0x6820, # G+13788  U+6820  uni6820,  CJK UNIFIED IDEOGRAPH-6820
        0x6822, # G+13789  U+6822  uni6822,  CJK UNIFIED IDEOGRAPH-6822
        0x6823, # G+13790  U+6823  uni6823,  CJK UNIFIED IDEOGRAPH-6823
        0x6824, # G+13791  U+6824  uni6824,  CJK UNIFIED IDEOGRAPH-6824
        0x6825, # G+13792  U+6825  uni6825,  CJK UNIFIED IDEOGRAPH-6825
        0x6826, # G+13793  U+6826  uni6826,  CJK UNIFIED IDEOGRAPH-6826
        0x6827, # G+13794  U+6827  uni6827,  CJK UNIFIED IDEOGRAPH-6827
        0x6828, # G+13795  U+6828  uni6828,  CJK UNIFIED IDEOGRAPH-6828
        0x682B, # G+13796  U+682B  uni682B,  CJK UNIFIED IDEOGRAPH-682B
        0x682C, # G+13797  U+682C  uni682C,  CJK UNIFIED IDEOGRAPH-682C
        0x682D, # G+13798  U+682D  uni682D,  CJK UNIFIED IDEOGRAPH-682D
        0x682E, # G+13799  U+682E  uni682E,  CJK UNIFIED IDEOGRAPH-682E
        0x682F, # G+13800  U+682F  uni682F,  CJK UNIFIED IDEOGRAPH-682F
        0x6830, # G+13801  U+6830  uni6830,  CJK UNIFIED IDEOGRAPH-6830
        0x6831, # G+13802  U+6831  uni6831,  CJK UNIFIED IDEOGRAPH-6831
        0x6834, # G+13803  U+6834  uni6834,  CJK UNIFIED IDEOGRAPH-6834
        0x6835, # G+13804  U+6835  uni6835,  CJK UNIFIED IDEOGRAPH-6835
        0x6836, # G+13805  U+6836  uni6836,  CJK UNIFIED IDEOGRAPH-6836
        0x683A, # G+13806  U+683A  uni683A,  CJK UNIFIED IDEOGRAPH-683A
        0x683B, # G+13807  U+683B  uni683B,  CJK UNIFIED IDEOGRAPH-683B
        0x683F, # G+13808  U+683F  uni683F,  CJK UNIFIED IDEOGRAPH-683F
        0x6847, # G+13809  U+6847  uni6847,  CJK UNIFIED IDEOGRAPH-6847
        0x684B, # G+13810  U+684B  uni684B,  CJK UNIFIED IDEOGRAPH-684B
        0x684D, # G+13811  U+684D  uni684D,  CJK UNIFIED IDEOGRAPH-684D
        0x684F, # G+13812  U+684F  uni684F,  CJK UNIFIED IDEOGRAPH-684F
        0x6852, # G+13813  U+6852  uni6852,  CJK UNIFIED IDEOGRAPH-6852
        0x6856, # G+13814  U+6856  uni6856,  CJK UNIFIED IDEOGRAPH-6856
        0x6857, # G+13815  U+6857  uni6857,  CJK UNIFIED IDEOGRAPH-6857
        0x6858, # G+13816  U+6858  uni6858,  CJK UNIFIED IDEOGRAPH-6858
        0x6859, # G+13817  U+6859  uni6859,  CJK UNIFIED IDEOGRAPH-6859
        0x685A, # G+13818  U+685A  uni685A,  CJK UNIFIED IDEOGRAPH-685A
        0x685B, # G+13819  U+685B  uni685B,  CJK UNIFIED IDEOGRAPH-685B
        0x685C, # G+13820  U+685C  uni685C,  CJK UNIFIED IDEOGRAPH-685C
        0x685D, # G+13821  U+685D  uni685D,  CJK UNIFIED IDEOGRAPH-685D
        0x685E, # G+13822  U+685E  uni685E,  CJK UNIFIED IDEOGRAPH-685E
        0x685F, # G+13823  U+685F  uni685F,  CJK UNIFIED IDEOGRAPH-685F
        0x686A, # G+13824  U+686A  uni686A,  CJK UNIFIED IDEOGRAPH-686A
        0x686C, # G+13825  U+686C  uni686C,  CJK UNIFIED IDEOGRAPH-686C
        0x686D, # G+13826  U+686D  uni686D,  CJK UNIFIED IDEOGRAPH-686D
        0x686E, # G+13827  U+686E  uni686E,  CJK UNIFIED IDEOGRAPH-686E
        0x686F, # G+13828  U+686F  uni686F,  CJK UNIFIED IDEOGRAPH-686F
        0x6870, # G+13829  U+6870  uni6870,  CJK UNIFIED IDEOGRAPH-6870
        0x6871, # G+13830  U+6871  uni6871,  CJK UNIFIED IDEOGRAPH-6871
        0x6872, # G+13831  U+6872  uni6872,  CJK UNIFIED IDEOGRAPH-6872
        0x6873, # G+13832  U+6873  uni6873,  CJK UNIFIED IDEOGRAPH-6873
        0x6875, # G+13833  U+6875  uni6875,  CJK UNIFIED IDEOGRAPH-6875
        0x6878, # G+13834  U+6878  uni6878,  CJK UNIFIED IDEOGRAPH-6878
        0x6879, # G+13835  U+6879  uni6879,  CJK UNIFIED IDEOGRAPH-6879
        0x687A, # G+13836  U+687A  uni687A,  CJK UNIFIED IDEOGRAPH-687A
        0x687B, # G+13837  U+687B  uni687B,  CJK UNIFIED IDEOGRAPH-687B
        0x687C, # G+13838  U+687C  uni687C,  CJK UNIFIED IDEOGRAPH-687C
        0x687D, # G+13839  U+687D  uni687D,  CJK UNIFIED IDEOGRAPH-687D
        0x687E, # G+13840  U+687E  uni687E,  CJK UNIFIED IDEOGRAPH-687E
        0x687F, # G+13841  U+687F  uni687F,  CJK UNIFIED IDEOGRAPH-687F
        0x6880, # G+13842  U+6880  uni6880,  CJK UNIFIED IDEOGRAPH-6880
        0x6882, # G+13843  U+6882  uni6882,  CJK UNIFIED IDEOGRAPH-6882
        0x6884, # G+13844  U+6884  uni6884,  CJK UNIFIED IDEOGRAPH-6884
        0x6887, # G+13845  U+6887  uni6887,  CJK UNIFIED IDEOGRAPH-6887
        0x6888, # G+13846  U+6888  uni6888,  CJK UNIFIED IDEOGRAPH-6888
        0x6889, # G+13847  U+6889  uni6889,  CJK UNIFIED IDEOGRAPH-6889
        0x688A, # G+13848  U+688A  uni688A,  CJK UNIFIED IDEOGRAPH-688A
        0x688B, # G+13849  U+688B  uni688B,  CJK UNIFIED IDEOGRAPH-688B
        0x688C, # G+13850  U+688C  uni688C,  CJK UNIFIED IDEOGRAPH-688C
        0x688D, # G+13851  U+688D  uni688D,  CJK UNIFIED IDEOGRAPH-688D
        0x688E, # G+13852  U+688E  uni688E,  CJK UNIFIED IDEOGRAPH-688E
        0x6890, # G+13853  U+6890  uni6890,  CJK UNIFIED IDEOGRAPH-6890
        0x6891, # G+13854  U+6891  uni6891,  CJK UNIFIED IDEOGRAPH-6891
        0x6892, # G+13855  U+6892  uni6892,  CJK UNIFIED IDEOGRAPH-6892
        0x6894, # G+13856  U+6894  uni6894,  CJK UNIFIED IDEOGRAPH-6894
        0x6895, # G+13857  U+6895  uni6895,  CJK UNIFIED IDEOGRAPH-6895
        0x6896, # G+13858  U+6896  uni6896,  CJK UNIFIED IDEOGRAPH-6896
        0x6899, # G+13859  U+6899  uni6899,  CJK UNIFIED IDEOGRAPH-6899
        0x689A, # G+13860  U+689A  uni689A,  CJK UNIFIED IDEOGRAPH-689A
        0x689B, # G+13861  U+689B  uni689B,  CJK UNIFIED IDEOGRAPH-689B
        0x689C, # G+13862  U+689C  uni689C,  CJK UNIFIED IDEOGRAPH-689C
        0x689E, # G+13863  U+689E  uni689E,  CJK UNIFIED IDEOGRAPH-689E
        0x68A0, # G+13864  U+68A0  uni68A0,  CJK UNIFIED IDEOGRAPH-68A0
        0x68A1, # G+13865  U+68A1  uni68A1,  CJK UNIFIED IDEOGRAPH-68A1
        0x68A3, # G+13866  U+68A3  uni68A3,  CJK UNIFIED IDEOGRAPH-68A3
        0x68A4, # G+13867  U+68A4  uni68A4,  CJK UNIFIED IDEOGRAPH-68A4
        0x68A5, # G+13868  U+68A5  uni68A5,  CJK UNIFIED IDEOGRAPH-68A5
        0x68A9, # G+13869  U+68A9  uni68A9,  CJK UNIFIED IDEOGRAPH-68A9
        0x68AA, # G+13870  U+68AA  uni68AA,  CJK UNIFIED IDEOGRAPH-68AA
        0x68AB, # G+13871  U+68AB  uni68AB,  CJK UNIFIED IDEOGRAPH-68AB
        0x68AC, # G+13872  U+68AC  uni68AC,  CJK UNIFIED IDEOGRAPH-68AC
        0x68AE, # G+13873  U+68AE  uni68AE,  CJK UNIFIED IDEOGRAPH-68AE
        0x68B1, # G+13874  U+68B1  uni68B1,  CJK UNIFIED IDEOGRAPH-68B1
        0x68B2, # G+13875  U+68B2  uni68B2,  CJK UNIFIED IDEOGRAPH-68B2
        0x68B4, # G+13876  U+68B4  uni68B4,  CJK UNIFIED IDEOGRAPH-68B4
        0x68B6, # G+13877  U+68B6  uni68B6,  CJK UNIFIED IDEOGRAPH-68B6
        0x68B7, # G+13878  U+68B7  uni68B7,  CJK UNIFIED IDEOGRAPH-68B7
        0x68B8, # G+13879  U+68B8  uni68B8,  CJK UNIFIED IDEOGRAPH-68B8
        0x68B9, # G+13880  U+68B9  uni68B9,  CJK UNIFIED IDEOGRAPH-68B9
        0x68BA, # G+13881  U+68BA  uni68BA,  CJK UNIFIED IDEOGRAPH-68BA
        0x68BB, # G+13882  U+68BB  uni68BB,  CJK UNIFIED IDEOGRAPH-68BB
        0x68BC, # G+13883  U+68BC  uni68BC,  CJK UNIFIED IDEOGRAPH-68BC
        0x68BD, # G+13884  U+68BD  uni68BD,  CJK UNIFIED IDEOGRAPH-68BD
        0x68BE, # G+13885  U+68BE  uni68BE,  CJK UNIFIED IDEOGRAPH-68BE
        0x68BF, # G+13886  U+68BF  uni68BF,  CJK UNIFIED IDEOGRAPH-68BF
        0x68C1, # G+13887  U+68C1  uni68C1,  CJK UNIFIED IDEOGRAPH-68C1
        0x68C3, # G+13888  U+68C3  uni68C3,  CJK UNIFIED IDEOGRAPH-68C3
        0x68C4, # G+13889  U+68C4  uni68C4,  CJK UNIFIED IDEOGRAPH-68C4
        0x68C5, # G+13890  U+68C5  uni68C5,  CJK UNIFIED IDEOGRAPH-68C5
        0x68C6, # G+13891  U+68C6  uni68C6,  CJK UNIFIED IDEOGRAPH-68C6
        0x68C7, # G+13892  U+68C7  uni68C7,  CJK UNIFIED IDEOGRAPH-68C7
        0x68C8, # G+13893  U+68C8  uni68C8,  CJK UNIFIED IDEOGRAPH-68C8
        0x68CA, # G+13894  U+68CA  uni68CA,  CJK UNIFIED IDEOGRAPH-68CA
        0x68CC, # G+13895  U+68CC  uni68CC,  CJK UNIFIED IDEOGRAPH-68CC
        0x68CE, # G+13896  U+68CE  uni68CE,  CJK UNIFIED IDEOGRAPH-68CE
        0x68CF, # G+13897  U+68CF  uni68CF,  CJK UNIFIED IDEOGRAPH-68CF
        0x68D0, # G+13898  U+68D0  uni68D0,  CJK UNIFIED IDEOGRAPH-68D0
        0x68D1, # G+13899  U+68D1  uni68D1,  CJK UNIFIED IDEOGRAPH-68D1
        0x68D3, # G+13900  U+68D3  uni68D3,  CJK UNIFIED IDEOGRAPH-68D3
        0x68D4, # G+13901  U+68D4  uni68D4,  CJK UNIFIED IDEOGRAPH-68D4
        0x68D9, # G+13902  U+68D9  uni68D9,  CJK UNIFIED IDEOGRAPH-68D9
        0x68DB, # G+13903  U+68DB  uni68DB,  CJK UNIFIED IDEOGRAPH-68DB
        0x68DC, # G+13904  U+68DC  uni68DC,  CJK UNIFIED IDEOGRAPH-68DC
        0x68DD, # G+13905  U+68DD  uni68DD,  CJK UNIFIED IDEOGRAPH-68DD
        0x68DE, # G+13906  U+68DE  uni68DE,  CJK UNIFIED IDEOGRAPH-68DE
        0x68E1, # G+13907  U+68E1  uni68E1,  CJK UNIFIED IDEOGRAPH-68E1
        0x68E2, # G+13908  U+68E2  uni68E2,  CJK UNIFIED IDEOGRAPH-68E2
        0x68E4, # G+13909  U+68E4  uni68E4,  CJK UNIFIED IDEOGRAPH-68E4
        0x68E5, # G+13910  U+68E5  uni68E5,  CJK UNIFIED IDEOGRAPH-68E5
        0x68E6, # G+13911  U+68E6  uni68E6,  CJK UNIFIED IDEOGRAPH-68E6
        0x68E8, # G+13912  U+68E8  uni68E8,  CJK UNIFIED IDEOGRAPH-68E8
        0x68E9, # G+13913  U+68E9  uni68E9,  CJK UNIFIED IDEOGRAPH-68E9
        0x68EA, # G+13914  U+68EA  uni68EA,  CJK UNIFIED IDEOGRAPH-68EA
        0x68EB, # G+13915  U+68EB  uni68EB,  CJK UNIFIED IDEOGRAPH-68EB
        0x68EC, # G+13916  U+68EC  uni68EC,  CJK UNIFIED IDEOGRAPH-68EC
        0x68ED, # G+13917  U+68ED  uni68ED,  CJK UNIFIED IDEOGRAPH-68ED
        0x68EF, # G+13918  U+68EF  uni68EF,  CJK UNIFIED IDEOGRAPH-68EF
        0x68F2, # G+13919  U+68F2  uni68F2,  CJK UNIFIED IDEOGRAPH-68F2
        0x68F3, # G+13920  U+68F3  uni68F3,  CJK UNIFIED IDEOGRAPH-68F3
        0x68F4, # G+13921  U+68F4  uni68F4,  CJK UNIFIED IDEOGRAPH-68F4
        0x68F6, # G+13922  U+68F6  uni68F6,  CJK UNIFIED IDEOGRAPH-68F6
        0x68F7, # G+13923  U+68F7  uni68F7,  CJK UNIFIED IDEOGRAPH-68F7
        0x68F8, # G+13924  U+68F8  uni68F8,  CJK UNIFIED IDEOGRAPH-68F8
        0x68FB, # G+13925  U+68FB  uni68FB,  CJK UNIFIED IDEOGRAPH-68FB
        0x68FD, # G+13926  U+68FD  uni68FD,  CJK UNIFIED IDEOGRAPH-68FD
        0x68FE, # G+13927  U+68FE  uni68FE,  CJK UNIFIED IDEOGRAPH-68FE
        0x68FF, # G+13928  U+68FF  uni68FF,  CJK UNIFIED IDEOGRAPH-68FF
        0x6900, # G+13929  U+6900  uni6900,  CJK UNIFIED IDEOGRAPH-6900
        0x6902, # G+13930  U+6902  uni6902,  CJK UNIFIED IDEOGRAPH-6902
        0x6903, # G+13931  U+6903  uni6903,  CJK UNIFIED IDEOGRAPH-6903
        0x6904, # G+13932  U+6904  uni6904,  CJK UNIFIED IDEOGRAPH-6904
        0x6906, # G+13933  U+6906  uni6906,  CJK UNIFIED IDEOGRAPH-6906
        0x6907, # G+13934  U+6907  uni6907,  CJK UNIFIED IDEOGRAPH-6907
        0x6908, # G+13935  U+6908  uni6908,  CJK UNIFIED IDEOGRAPH-6908
        0x6909, # G+13936  U+6909  uni6909,  CJK UNIFIED IDEOGRAPH-6909
        0x690A, # G+13937  U+690A  uni690A,  CJK UNIFIED IDEOGRAPH-690A
        0x690C, # G+13938  U+690C  uni690C,  CJK UNIFIED IDEOGRAPH-690C
        0x6911, # G+13939  U+6911  uni6911,  CJK UNIFIED IDEOGRAPH-6911
        0x6913, # G+13940  U+6913  uni6913,  CJK UNIFIED IDEOGRAPH-6913
        0x6914, # G+13941  U+6914  uni6914,  CJK UNIFIED IDEOGRAPH-6914
        0x6915, # G+13942  U+6915  uni6915,  CJK UNIFIED IDEOGRAPH-6915
        0x6916, # G+13943  U+6916  uni6916,  CJK UNIFIED IDEOGRAPH-6916
        0x6917, # G+13944  U+6917  uni6917,  CJK UNIFIED IDEOGRAPH-6917
        0x6918, # G+13945  U+6918  uni6918,  CJK UNIFIED IDEOGRAPH-6918
        0x6919, # G+13946  U+6919  uni6919,  CJK UNIFIED IDEOGRAPH-6919
        0x691A, # G+13947  U+691A  uni691A,  CJK UNIFIED IDEOGRAPH-691A
        0x691B, # G+13948  U+691B  uni691B,  CJK UNIFIED IDEOGRAPH-691B
        0x691C, # G+13949  U+691C  uni691C,  CJK UNIFIED IDEOGRAPH-691C
        0x691D, # G+13950  U+691D  uni691D,  CJK UNIFIED IDEOGRAPH-691D
        0x691E, # G+13951  U+691E  uni691E,  CJK UNIFIED IDEOGRAPH-691E
        0x6921, # G+13952  U+6921  uni6921,  CJK UNIFIED IDEOGRAPH-6921
        0x6922, # G+13953  U+6922  uni6922,  CJK UNIFIED IDEOGRAPH-6922
        0x6923, # G+13954  U+6923  uni6923,  CJK UNIFIED IDEOGRAPH-6923
        0x6925, # G+13955  U+6925  uni6925,  CJK UNIFIED IDEOGRAPH-6925
        0x6926, # G+13956  U+6926  uni6926,  CJK UNIFIED IDEOGRAPH-6926
        0x6927, # G+13957  U+6927  uni6927,  CJK UNIFIED IDEOGRAPH-6927
        0x6928, # G+13958  U+6928  uni6928,  CJK UNIFIED IDEOGRAPH-6928
        0x6929, # G+13959  U+6929  uni6929,  CJK UNIFIED IDEOGRAPH-6929
        0x692A, # G+13960  U+692A  uni692A,  CJK UNIFIED IDEOGRAPH-692A
        0x692B, # G+13961  U+692B  uni692B,  CJK UNIFIED IDEOGRAPH-692B
        0x692C, # G+13962  U+692C  uni692C,  CJK UNIFIED IDEOGRAPH-692C
        0x692E, # G+13963  U+692E  uni692E,  CJK UNIFIED IDEOGRAPH-692E
        0x692F, # G+13964  U+692F  uni692F,  CJK UNIFIED IDEOGRAPH-692F
        0x6931, # G+13965  U+6931  uni6931,  CJK UNIFIED IDEOGRAPH-6931
        0x6932, # G+13966  U+6932  uni6932,  CJK UNIFIED IDEOGRAPH-6932
        0x6933, # G+13967  U+6933  uni6933,  CJK UNIFIED IDEOGRAPH-6933
        0x6935, # G+13968  U+6935  uni6935,  CJK UNIFIED IDEOGRAPH-6935
        0x6936, # G+13969  U+6936  uni6936,  CJK UNIFIED IDEOGRAPH-6936
        0x6937, # G+13970  U+6937  uni6937,  CJK UNIFIED IDEOGRAPH-6937
        0x6938, # G+13971  U+6938  uni6938,  CJK UNIFIED IDEOGRAPH-6938
        0x693A, # G+13972  U+693A  uni693A,  CJK UNIFIED IDEOGRAPH-693A
        0x693B, # G+13973  U+693B  uni693B,  CJK UNIFIED IDEOGRAPH-693B
        0x693C, # G+13974  U+693C  uni693C,  CJK UNIFIED IDEOGRAPH-693C
        0x693E, # G+13975  U+693E  uni693E,  CJK UNIFIED IDEOGRAPH-693E
        0x6940, # G+13976  U+6940  uni6940,  CJK UNIFIED IDEOGRAPH-6940
        0x6941, # G+13977  U+6941  uni6941,  CJK UNIFIED IDEOGRAPH-6941
        0x6943, # G+13978  U+6943  uni6943,  CJK UNIFIED IDEOGRAPH-6943
        0x6944, # G+13979  U+6944  uni6944,  CJK UNIFIED IDEOGRAPH-6944
        0x6945, # G+13980  U+6945  uni6945,  CJK UNIFIED IDEOGRAPH-6945
        0x6946, # G+13981  U+6946  uni6946,  CJK UNIFIED IDEOGRAPH-6946
        0x6947, # G+13982  U+6947  uni6947,  CJK UNIFIED IDEOGRAPH-6947
        0x6948, # G+13983  U+6948  uni6948,  CJK UNIFIED IDEOGRAPH-6948
        0x6949, # G+13984  U+6949  uni6949,  CJK UNIFIED IDEOGRAPH-6949
        0x694B, # G+13985  U+694B  uni694B,  CJK UNIFIED IDEOGRAPH-694B
        0x694C, # G+13986  U+694C  uni694C,  CJK UNIFIED IDEOGRAPH-694C
        0x694D, # G+13987  U+694D  uni694D,  CJK UNIFIED IDEOGRAPH-694D
        0x694E, # G+13988  U+694E  uni694E,  CJK UNIFIED IDEOGRAPH-694E
        0x694F, # G+13989  U+694F  uni694F,  CJK UNIFIED IDEOGRAPH-694F
        0x6950, # G+13990  U+6950  uni6950,  CJK UNIFIED IDEOGRAPH-6950
        0x6951, # G+13991  U+6951  uni6951,  CJK UNIFIED IDEOGRAPH-6951
        0x6952, # G+13992  U+6952  uni6952,  CJK UNIFIED IDEOGRAPH-6952
        0x6955, # G+13993  U+6955  uni6955,  CJK UNIFIED IDEOGRAPH-6955
        0x6956, # G+13994  U+6956  uni6956,  CJK UNIFIED IDEOGRAPH-6956
        0x6958, # G+13995  U+6958  uni6958,  CJK UNIFIED IDEOGRAPH-6958
        0x6959, # G+13996  U+6959  uni6959,  CJK UNIFIED IDEOGRAPH-6959
        0x695B, # G+13997  U+695B  uni695B,  CJK UNIFIED IDEOGRAPH-695B
        0x695C, # G+13998  U+695C  uni695C,  CJK UNIFIED IDEOGRAPH-695C
        0x695F, # G+13999  U+695F  uni695F,  CJK UNIFIED IDEOGRAPH-695F
        0x6961, # G+14000  U+6961  uni6961,  CJK UNIFIED IDEOGRAPH-6961
        0x6962, # G+14001  U+6962  uni6962,  CJK UNIFIED IDEOGRAPH-6962
        0x6964, # G+14002  U+6964  uni6964,  CJK UNIFIED IDEOGRAPH-6964
        0x6965, # G+14003  U+6965  uni6965,  CJK UNIFIED IDEOGRAPH-6965
        0x6967, # G+14004  U+6967  uni6967,  CJK UNIFIED IDEOGRAPH-6967
        0x6969, # G+14005  U+6969  uni6969,  CJK UNIFIED IDEOGRAPH-6969
        0x696A, # G+14006  U+696A  uni696A,  CJK UNIFIED IDEOGRAPH-696A
        0x696C, # G+14007  U+696C  uni696C,  CJK UNIFIED IDEOGRAPH-696C
        0x696F, # G+14008  U+696F  uni696F,  CJK UNIFIED IDEOGRAPH-696F
        0x6970, # G+14009  U+6970  uni6970,  CJK UNIFIED IDEOGRAPH-6970
        0x6972, # G+14010  U+6972  uni6972,  CJK UNIFIED IDEOGRAPH-6972
        0x6973, # G+14011  U+6973  uni6973,  CJK UNIFIED IDEOGRAPH-6973
        0x6974, # G+14012  U+6974  uni6974,  CJK UNIFIED IDEOGRAPH-6974
        0x6976, # G+14013  U+6976  uni6976,  CJK UNIFIED IDEOGRAPH-6976
        0x697A, # G+14014  U+697A  uni697A,  CJK UNIFIED IDEOGRAPH-697A
        0x697B, # G+14015  U+697B  uni697B,  CJK UNIFIED IDEOGRAPH-697B
        0x697D, # G+14016  U+697D  uni697D,  CJK UNIFIED IDEOGRAPH-697D
        0x697E, # G+14017  U+697E  uni697E,  CJK UNIFIED IDEOGRAPH-697E
        0x697F, # G+14018  U+697F  uni697F,  CJK UNIFIED IDEOGRAPH-697F
        0x6981, # G+14019  U+6981  uni6981,  CJK UNIFIED IDEOGRAPH-6981
        0x6983, # G+14020  U+6983  uni6983,  CJK UNIFIED IDEOGRAPH-6983
        0x6985, # G+14021  U+6985  uni6985,  CJK UNIFIED IDEOGRAPH-6985
        0x698A, # G+14022  U+698A  uni698A,  CJK UNIFIED IDEOGRAPH-698A
        0x698B, # G+14023  U+698B  uni698B,  CJK UNIFIED IDEOGRAPH-698B
        0x698C, # G+14024  U+698C  uni698C,  CJK UNIFIED IDEOGRAPH-698C
        0x698E, # G+14025  U+698E  uni698E,  CJK UNIFIED IDEOGRAPH-698E
        0x698F, # G+14026  U+698F  uni698F,  CJK UNIFIED IDEOGRAPH-698F
        0x6990, # G+14027  U+6990  uni6990,  CJK UNIFIED IDEOGRAPH-6990
        0x6991, # G+14028  U+6991  uni6991,  CJK UNIFIED IDEOGRAPH-6991
        0x6992, # G+14029  U+6992  uni6992,  CJK UNIFIED IDEOGRAPH-6992
        0x6993, # G+14030  U+6993  uni6993,  CJK UNIFIED IDEOGRAPH-6993
        0x6996, # G+14031  U+6996  uni6996,  CJK UNIFIED IDEOGRAPH-6996
        0x6997, # G+14032  U+6997  uni6997,  CJK UNIFIED IDEOGRAPH-6997
        0x6999, # G+14033  U+6999  uni6999,  CJK UNIFIED IDEOGRAPH-6999
        0x699A, # G+14034  U+699A  uni699A,  CJK UNIFIED IDEOGRAPH-699A
        0x699D, # G+14035  U+699D  uni699D,  CJK UNIFIED IDEOGRAPH-699D
        0x699E, # G+14036  U+699E  uni699E,  CJK UNIFIED IDEOGRAPH-699E
        0x699F, # G+14037  U+699F  uni699F,  CJK UNIFIED IDEOGRAPH-699F
        0x69A0, # G+14038  U+69A0  uni69A0,  CJK UNIFIED IDEOGRAPH-69A0
        0x69A1, # G+14039  U+69A1  uni69A1,  CJK UNIFIED IDEOGRAPH-69A1
        0x69A2, # G+14040  U+69A2  uni69A2,  CJK UNIFIED IDEOGRAPH-69A2
        0x69A3, # G+14041  U+69A3  uni69A3,  CJK UNIFIED IDEOGRAPH-69A3
        0x69A4, # G+14042  U+69A4  uni69A4,  CJK UNIFIED IDEOGRAPH-69A4
        0x69A5, # G+14043  U+69A5  uni69A5,  CJK UNIFIED IDEOGRAPH-69A5
        0x69A6, # G+14044  U+69A6  uni69A6,  CJK UNIFIED IDEOGRAPH-69A6
        0x69A9, # G+14045  U+69A9  uni69A9,  CJK UNIFIED IDEOGRAPH-69A9
        0x69AC, # G+14046  U+69AC  uni69AC,  CJK UNIFIED IDEOGRAPH-69AC
        0x69AF, # G+14047  U+69AF  uni69AF,  CJK UNIFIED IDEOGRAPH-69AF
        0x69B0, # G+14048  U+69B0  uni69B0,  CJK UNIFIED IDEOGRAPH-69B0
        0x69B2, # G+14049  U+69B2  uni69B2,  CJK UNIFIED IDEOGRAPH-69B2
        0x69B3, # G+14050  U+69B3  uni69B3,  CJK UNIFIED IDEOGRAPH-69B3
        0x69B5, # G+14051  U+69B5  uni69B5,  CJK UNIFIED IDEOGRAPH-69B5
        0x69B6, # G+14052  U+69B6  uni69B6,  CJK UNIFIED IDEOGRAPH-69B6
        0x69B8, # G+14053  U+69B8  uni69B8,  CJK UNIFIED IDEOGRAPH-69B8
        0x69B9, # G+14054  U+69B9  uni69B9,  CJK UNIFIED IDEOGRAPH-69B9
        0x69BA, # G+14055  U+69BA  uni69BA,  CJK UNIFIED IDEOGRAPH-69BA
        0x69BC, # G+14056  U+69BC  uni69BC,  CJK UNIFIED IDEOGRAPH-69BC
        0x69BD, # G+14057  U+69BD  uni69BD,  CJK UNIFIED IDEOGRAPH-69BD
        0x69BE, # G+14058  U+69BE  uni69BE,  CJK UNIFIED IDEOGRAPH-69BE
        0x69C0, # G+14059  U+69C0  uni69C0,  CJK UNIFIED IDEOGRAPH-69C0
        0x69C2, # G+14060  U+69C2  uni69C2,  CJK UNIFIED IDEOGRAPH-69C2
        0x69C3, # G+14061  U+69C3  uni69C3,  CJK UNIFIED IDEOGRAPH-69C3
        0x69C4, # G+14062  U+69C4  uni69C4,  CJK UNIFIED IDEOGRAPH-69C4
        0x69C5, # G+14063  U+69C5  uni69C5,  CJK UNIFIED IDEOGRAPH-69C5
        0x69C6, # G+14064  U+69C6  uni69C6,  CJK UNIFIED IDEOGRAPH-69C6
        0x69C7, # G+14065  U+69C7  uni69C7,  CJK UNIFIED IDEOGRAPH-69C7
        0x69C8, # G+14066  U+69C8  uni69C8,  CJK UNIFIED IDEOGRAPH-69C8
        0x69C9, # G+14067  U+69C9  uni69C9,  CJK UNIFIED IDEOGRAPH-69C9
        0x69CF, # G+14068  U+69CF  uni69CF,  CJK UNIFIED IDEOGRAPH-69CF
        0x69D1, # G+14069  U+69D1  uni69D1,  CJK UNIFIED IDEOGRAPH-69D1
        0x69D2, # G+14070  U+69D2  uni69D2,  CJK UNIFIED IDEOGRAPH-69D2
        0x69D3, # G+14071  U+69D3  uni69D3,  CJK UNIFIED IDEOGRAPH-69D3
        0x69D5, # G+14072  U+69D5  uni69D5,  CJK UNIFIED IDEOGRAPH-69D5
        0x69D6, # G+14073  U+69D6  uni69D6,  CJK UNIFIED IDEOGRAPH-69D6
        0x69D7, # G+14074  U+69D7  uni69D7,  CJK UNIFIED IDEOGRAPH-69D7
        0x69D8, # G+14075  U+69D8  uni69D8,  CJK UNIFIED IDEOGRAPH-69D8
        0x69D9, # G+14076  U+69D9  uni69D9,  CJK UNIFIED IDEOGRAPH-69D9
        0x69DA, # G+14077  U+69DA  uni69DA,  CJK UNIFIED IDEOGRAPH-69DA
        0x69DC, # G+14078  U+69DC  uni69DC,  CJK UNIFIED IDEOGRAPH-69DC
        0x69DD, # G+14079  U+69DD  uni69DD,  CJK UNIFIED IDEOGRAPH-69DD
        0x69DE, # G+14080  U+69DE  uni69DE,  CJK UNIFIED IDEOGRAPH-69DE
        0x69E1, # G+14081  U+69E1  uni69E1,  CJK UNIFIED IDEOGRAPH-69E1
        0x69E2, # G+14082  U+69E2  uni69E2,  CJK UNIFIED IDEOGRAPH-69E2
        0x69E3, # G+14083  U+69E3  uni69E3,  CJK UNIFIED IDEOGRAPH-69E3
        0x69E4, # G+14084  U+69E4  uni69E4,  CJK UNIFIED IDEOGRAPH-69E4
        0x69E5, # G+14085  U+69E5  uni69E5,  CJK UNIFIED IDEOGRAPH-69E5
        0x69E6, # G+14086  U+69E6  uni69E6,  CJK UNIFIED IDEOGRAPH-69E6
        0x69E8, # G+14087  U+69E8  uni69E8,  CJK UNIFIED IDEOGRAPH-69E8
        0x69E9, # G+14088  U+69E9  uni69E9,  CJK UNIFIED IDEOGRAPH-69E9
        0x69EA, # G+14089  U+69EA  uni69EA,  CJK UNIFIED IDEOGRAPH-69EA
        0x69EB, # G+14090  U+69EB  uni69EB,  CJK UNIFIED IDEOGRAPH-69EB
        0x69EC, # G+14091  U+69EC  uni69EC,  CJK UNIFIED IDEOGRAPH-69EC
        0x69EE, # G+14092  U+69EE  uni69EE,  CJK UNIFIED IDEOGRAPH-69EE
        0x69EF, # G+14093  U+69EF  uni69EF,  CJK UNIFIED IDEOGRAPH-69EF
        0x69F0, # G+14094  U+69F0  uni69F0,  CJK UNIFIED IDEOGRAPH-69F0
        0x69F1, # G+14095  U+69F1  uni69F1,  CJK UNIFIED IDEOGRAPH-69F1
        0x69F4, # G+14096  U+69F4  uni69F4,  CJK UNIFIED IDEOGRAPH-69F4
        0x69F5, # G+14097  U+69F5  uni69F5,  CJK UNIFIED IDEOGRAPH-69F5
        0x69F6, # G+14098  U+69F6  uni69F6,  CJK UNIFIED IDEOGRAPH-69F6
        0x69F7, # G+14099  U+69F7  uni69F7,  CJK UNIFIED IDEOGRAPH-69F7
        0x69F8, # G+14100  U+69F8  uni69F8,  CJK UNIFIED IDEOGRAPH-69F8
        0x69F9, # G+14101  U+69F9  uni69F9,  CJK UNIFIED IDEOGRAPH-69F9
        0x69FA, # G+14102  U+69FA  uni69FA,