package Text::PDF::API::Encoding::AdobeZapfDingbats;

sub new {
	my $class=shift(@_);
	my %defaults=@_;
	my $this={};
	bless($this);
	my ($line,@vals,$data);
	$this->{'e2u'}=();
	$this->{'u2e'}=();
	seek(DATA,0,0);
	while($line=<DATA>) {
		($data)=split(/\#+/,$line);
		if(!$data){next;}
		@vals=split(/\s+/,$data);
		$this->{'e2u'}{hex($vals[1])}=hex($vals[0]);
		$this->{'u2e'}{hex($vals[0])}=hex($vals[1]);
	}
	return $this;
}

1;

__DATA__
#
#  Name:             Adobe Zapf Dingbats Encoding to Unicode
#  Unicode version:  2.0
#  Table version:    0.2
#  Date:             30 March 1999
#  
#  Copyright (c) 1991-1999 Unicode, Inc. All Rights reserved.
#  
#  This file is provided as-is by Unicode, Inc. (The Unicode Consortium). No
#  claims are made as to fitness for any particular purpose. No warranties of
#  any kind are expressed or implied. The recipient agrees to determine
#  applicability of information provided. If this file has been provided on
#  magnetic media by Unicode, Inc., the sole remedy for any claim will be
#  exchange of defective media within 90 days of receipt.
#  
#  Contact <unicode-inc@unicode.org> with any questions or comments.
#
0020	20	# SPACE	# space
2701	21	# UPPER BLADE SCISSORS	# a1
2702	22	# BLACK SCISSORS	# a2
2703	23	# LOWER BLADE SCISSORS	# a202
2704	24	# WHITE SCISSORS	# a3
260E	25	# BLACK TELEPHONE	# a4
2706	26	# TELEPHONE LOCATION SIGN	# a5
2707	27	# TAPE DRIVE	# a119
2708	28	# AIRPLANE	# a118
2709	29	# ENVELOPE	# a117
261B	2A	# BLACK RIGHT POINTING INDEX	# a11
261E	2B	# WHITE RIGHT POINTING INDEX	# a12
270C	2C	# VICTORY HAND	# a13
270D	2D	# WRITING HAND	# a14
270E	2E	# LOWER RIGHT PENCIL	# a15
270F	2F	# PENCIL	# a16
2710	30	# UPPER RIGHT PENCIL	# a105
2711	31	# WHITE NIB	# a17
2712	32	# BLACK NIB	# a18
2713	33	# CHECK MARK	# a19
2714	34	# HEAVY CHECK MARK	# a20
2715	35	# MULTIPLICATION X	# a21
2716	36	# HEAVY MULTIPLICATION X	# a22
2717	37	# BALLOT X	# a23
2718	38	# HEAVY BALLOT X	# a24
2719	39	# OUTLINED GREEK CROSS	# a25
271A	3A	# HEAVY GREEK CROSS	# a26
271B	3B	# OPEN CENTRE CROSS	# a27
271C	3C	# HEAVY OPEN CENTRE CROSS	# a28
271D	3D	# LATIN CROSS	# a6
271E	3E	# SHADOWED WHITE LATIN CROSS	# a7
271F	3F	# OUTLINED LATIN CROSS	# a8
2720	40	# MALTESE CROSS	# a9
2721	41	# STAR OF DAVID	# a10
2722	42	# FOUR TEARDROP-SPOKED ASTERISK	# a29
2723	43	# FOUR BALLOON-SPOKED ASTERISK	# a30
2724	44	# HEAVY FOUR BALLOON-SPOKED ASTERISK	# a31
2725	45	# FOUR CLUB-SPOKED ASTERISK	# a32
2726	46	# BLACK FOUR POINTED STAR	# a33
2727	47	# WHITE FOUR POINTED STAR	# a34
2605	48	# BLACK STAR	# a35
2729	49	# STRESS OUTLINED WHITE STAR	# a36
272A	4A	# CIRCLED WHITE STAR	# a37
272B	4B	# OPEN CENTRE BLACK STAR	# a38
272C	4C	# BLACK CENTRE WHITE STAR	# a39
272D	4D	# OUTLINED BLACK STAR	# a40
272E	4E	# HEAVY OUTLINED BLACK STAR	# a41
272F	4F	# PINWHEEL STAR	# a42
2730	50	# SHADOWED WHITE STAR	# a43
2731	51	# HEAVY ASTERISK	# a44
2732	52	# OPEN CENTRE ASTERISK	# a45
2733	53	# EIGHT SPOKED ASTERISK	# a46
2734	54	# EIGHT POINTED BLACK STAR	# a47
2735	55	# EIGHT POINTED PINWHEEL STAR	# a48
2736	56	# SIX POINTED BLACK STAR	# a49
2737	57	# EIGHT POINTED RECTILINEAR BLACK STAR	# a50
2738	58	# HEAVY EIGHT POINTED RECTILINEAR BLACK STAR	# a51
2739	59	# TWELVE POINTED BLACK STAR	# a52
273A	5A	# SIXTEEN POINTED ASTERISK	# a53
273B	5B	# TEARDROP-SPOKED ASTERISK	# a54
273C	5C	# OPEN CENTRE TEARDROP-SPOKED ASTERISK	# a55
273D	5D	# HEAVY TEARDROP-SPOKED ASTERISK	# a56
273E	5E	# SIX PETALLED BLACK AND WHITE FLORETTE	# a57
273F	5F	# BLACK FLORETTE	# a58
2740	60	# WHITE FLORETTE	# a59
2741	61	# EIGHT PETALLED OUTLINED BLACK FLORETTE	# a60
2742	62	# CIRCLED OPEN CENTRE EIGHT POINTED STAR	# a61
2743	63	# HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK	# a62
2744	64	# SNOWFLAKE	# a63
2745	65	# TIGHT TRIFOLIATE SNOWFLAKE	# a64
2746	66	# HEAVY CHEVRON SNOWFLAKE	# a65
2747	67	# SPARKLE	# a66
2748	68	# HEAVY SPARKLE	# a67
2749	69	# BALLOON-SPOKED ASTERISK	# a68
274A	6A	# EIGHT TEARDROP-SPOKED PROPELLER ASTERISK	# a69
274B	6B	# HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK	# a70
25CF	6C	# BLACK CIRCLE	# a71
274D	6D	# SHADOWED WHITE CIRCLE	# a72
25A0	6E	# BLACK SQUARE	# a73
274F	6F	# LOWER RIGHT DROP-SHADOWED WHITE SQUARE	# a74
2750	70	# UPPER RIGHT DROP-SHADOWED WHITE SQUARE	# a203
2751	71	# LOWER RIGHT SHADOWED WHITE SQUARE	# a75
2752	72	# UPPER RIGHT SHADOWED WHITE SQUARE	# a204
25B2	73	# BLACK UP-POINTING TRIANGLE	# a76
25BC	74	# BLACK DOWN-POINTING TRIANGLE	# a77
25C6	75	# BLACK DIAMOND	# a78
2756	76	# BLACK DIAMOND MINUS WHITE X	# a79
25D7	77	# RIGHT HALF BLACK CIRCLE	# a81
2758	78	# LIGHT VERTICAL BAR	# a82
2759	79	# MEDIUM VERTICAL BAR	# a83
275A	7A	# HEAVY VERTICAL BAR	# a84
275B	7B	# HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT	# a97
275C	7C	# HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT	# a98
275D	7D	# HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT	# a99
275E	7E	# HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT	# a100
F8D7	80	# MEDIUM LEFT PARENTHESIS ORNAMENT	# a89 (CUS)
F8D8	81	# MEDIUM RIGHT PARENTHESIS ORNAMENT	# a90 (CUS)
F8D9	82	# MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT	# a93 (CUS)
F8DA	83	# MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT	# a94 (CUS)
F8DB	84	# MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT	# a91 (CUS)
F8DC	85	# MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT	# a92 (CUS)
F8DD	86	# HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT	# a205 (CUS)
F8DE	87	# HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT	# a85 (CUS)
F8DF	88	# HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT	# a206 (CUS)
F8E0	89	# HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT	# a86 (CUS)
F8E1	8A	# LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT	# a87 (CUS)
F8E2	8B	# LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT	# a88 (CUS)
F8E3	8C	# MEDIUM LEFT CURLY BRACKET ORNAMENT	# a95 (CUS)
F8E4	8D	# MEDIUM RIGHT CURLY BRACKET ORNAMENT	# a96 (CUS)
2761	A1	# CURVED STEM PARAGRAPH SIGN ORNAMENT	# a101
2762	A2	# HEAVY EXCLAMATION MARK ORNAMENT	# a102
2763	A3	# HEAVY HEART EXCLAMATION MARK ORNAMENT	# a103
2764	A4	# HEAVY BLACK HEART	# a104
2765	A5	# ROTATED HEAVY BLACK HEART BULLET	# a106
2766	A6	# FLORAL HEART	# a107
2767	A7	# ROTATED FLORAL HEART BULLET	# a108
2663	A8	# BLACK CLUB SUIT	# a112
2666	A9	# BLACK DIAMOND SUIT	# a111
2665	AA	# BLACK HEART SUIT	# a110
2660	AB	# BLACK SPADE SUIT	# a109
2460	AC	# CIRCLED DIGIT ONE	# a120
2461	AD	# CIRCLED DIGIT TWO	# a121
2462	AE	# CIRCLED DIGIT THREE	# a122
2463	AF	# CIRCLED DIGIT FOUR	# a123
2464	B0	# CIRCLED DIGIT FIVE	# a124
2465	B1	# CIRCLED DIGIT SIX	# a125
2466	B2	# CIRCLED DIGIT SEVEN	# a126
2467	B3	# CIRCLED DIGIT EIGHT	# a127
2468	B4	# CIRCLED DIGIT NINE	# a128
2469	B5	# CIRCLED NUMBER TEN	# a129
2776	B6	# DINGBAT NEGATIVE CIRCLED DIGIT ONE	# a130
2777	B7	# DINGBAT NEGATIVE CIRCLED DIGIT TWO	# a131
2778	B8	# DINGBAT NEGATIVE CIRCLED DIGIT THREE	# a132
2779	B9	# DINGBAT NEGATIVE CIRCLED DIGIT FOUR	# a133
277A	BA	# DINGBAT NEGATIVE CIRCLED DIGIT FIVE	# a134
277B	BB	# DINGBAT NEGATIVE CIRCLED DIGIT SIX	# a135
277C	BC	# DINGBAT NEGATIVE CIRCLED DIGIT SEVEN	# a136
277D	BD	# DINGBAT NEGATIVE CIRCLED DIGIT EIGHT	# a137
277E	BE	# DINGBAT NEGATIVE CIRCLED DIGIT NINE	# a138
277F	BF	# DINGBAT NEGATIVE CIRCLED NUMBER TEN	# a139
2780	C0	# DINGBAT CIRCLED SANS-SERIF DIGIT ONE	# a140
2781	C1	# DINGBAT CIRCLED SANS-SERIF DIGIT TWO	# a141
2782	C2	# DINGBAT CIRCLED SANS-SERIF DIGIT THREE	# a142
2783	C3	# DINGBAT CIRCLED SANS-SERIF DIGIT FOUR	# a143
2784	C4	# DINGBAT CIRCLED SANS-SERIF DIGIT FIVE	# a144
2785	C5	# DINGBAT CIRCLED SANS-SERIF DIGIT SIX	# a145
2786	C6	# DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN	# a146
2787	C7	# DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT	# a147
2788	C8	# DINGBAT CIRCLED SANS-SERIF DIGIT NINE	# a148
2789	C9	# DINGBAT CIRCLED SANS-SERIF NUMBER TEN	# a149
278A	CA	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE	# a150
278B	CB	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO	# a151
278C	CC	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE	# a152
278D	CD	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR	# a153
278E	CE	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE	# a154
278F	CF	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX	# a155
2790	D0	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN	# a156
2791	D1	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT	# a157
2792	D2	# DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE	# a158
2793	D3	# DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN	# a159
2794	D4	# HEAVY WIDE-HEADED RIGHTWARDS ARROW	# a160
2192	D5	# RIGHTWARDS ARROW	# a161
2194	D6	# LEFT RIGHT ARROW	# a163
2195	D7	# UP DOWN ARROW	# a164
2798	D8	# HEAVY SOUTH EAST ARROW	# a196
2799	D9	# HEAVY RIGHTWARDS ARROW	# a165
279A	DA	# HEAVY NORTH EAST ARROW	# a192
279B	DB	# DRAFTING POINT RIGHTWARDS ARROW	# a166
279C	DC	# HEAVY ROUND-TIPPED RIGHTWARDS ARROW	# a167
279D	DD	# TRIANGLE-HEADED RIGHTWARDS ARROW	# a168
279E	DE	# HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW	# a169
279F	DF	# DASHED TRIANGLE-HEADED RIGHTWARDS ARROW	# a170
27A0	E0	# HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW	# a171
27A1	E1	# BLACK RIGHTWARDS ARROW	# a172
27A2	E2	# THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD	# a173
27A3	E3	# THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD	# a162
27A4	E4	# BLACK RIGHTWARDS ARROWHEAD	# a174
27A5	E5	# HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW	# a175
27A6	E6	# HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW	# a176
27A7	E7	# SQUAT BLACK RIGHTWARDS ARROW	# a177
27A8	E8	# HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW	# a178
27A9	E9	# RIGHT-SHADED WHITE RIGHTWARDS ARROW	# a179
27AA	EA	# LEFT-SHADED WHITE RIGHTWARDS ARROW	# a193
27AB	EB	# BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW	# a180
27AC	EC	# FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW	# a199
27AD	ED	# HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW	# a181
27AE	EE	# HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW	# a200
27AF	EF	# NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW	# a182
27B1	F1	# NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW	# a201
27B2	F2	# CIRCLED HEAVY WHITE RIGHTWARDS ARROW	# a183
27B3	F3	# WHITE-FEATHERED RIGHTWARDS ARROW	# a184
27B4	F4	# BLACK-FEATHERED SOUTH EAST ARROW	# a197
27B5	F5	# BLACK-FEATHERED RIGHTWARDS ARROW	# a185
27B6	F6	# BLACK-FEATHERED NORTH EAST ARROW	# a194
27B7	F7	# HEAVY BLACK-FEATHERED SOUTH EAST ARROW	# a198
27B8	F8	# HEAVY BLACK-FEATHERED RIGHTWARDS ARROW	# a186
27B9	F9	# HEAVY BLACK-FEATHERED NORTH EAST ARROW	# a195
27BA	FA	# TEARDROP-BARBED RIGHTWARDS ARROW	# a187
27BB	FB	# HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW	# a188
27BC	FC	# WEDGE-TAILED RIGHTWARDS ARROW	# a189
27BD	FD	# HEAVY WEDGE-TAILED RIGHTWARDS ARROW	# a190
27BE	FE	# OPEN-OUTLINED RIGHTWARDS ARROW	# a191
