use Text::PDF::API::Color;
use Text::PDF::API;

        $f=5;
        $pdf=Text::PDF::API->new(pagesize=>'a4', 'compression'=>1);
        $pdf->newFont('Helvetica-Bold');
        $pdf->useFont('Helvetica-Bold',$f);
	$ff=Text::PDF::API::Color->new();
	@colors=sort keys %col;
	while($color=shift @colors) {
        	$pdf->newpage();
		foreach $x (50,150,250,350,450) {
			foreach $y (50,210,370,530,690) {
				print "$color\n";
				$c=$col{$color};
				$r=(($c&0xff0000)>>16)/255;
				$g=(($c&0xff00)>>8)/255;
				$b=($c&0xff)/255;
				$ff->setRGB($r,$g,$b);	
				$pdf->setColorFill(0);
				($c1,$c2)=split(/\-\-/,$color);
				$c3=sprintf('RGB=%02X.%02X.%02X',map{$_*255}($ff->asRGB));
				$c4=sprintf('CMYK=%02X.%02X.%02X.%02X',map{$_*255}($ff->asCMYK));
				$pdf->showTextXY($x,$y-($f),$c1);	
				$pdf->showTextXY($x,$y-($f*2),$c2);
				$pdf->showTextXY($x,$y-($f*3),$c3);
				$pdf->showTextXY($x,$y+102,$c4);
				$pdf->setColorFill($ff->asRGB);
				$pdf->rect($x,$y,80,50);
				$pdf->closefill;
				$pdf->setColorFill($ff->asCMYK);
				$pdf->rect($x,$y+50,80,50);
				$pdf->closefill;
				$color=shift @colors;
			}
		}
		
        	$pdf->endpage();
	}

        $pdf->saveas("$0.pdf");
        $pdf->end;


BEGIN {
%col=(
'FOCOLTONE Colors -- 1000' => 0x321E0F ,
'FOCOLTONE Colors -- 1001' => 0x321E0F ,
'FOCOLTONE Colors -- 1002' => 0x32000F ,
'FOCOLTONE Colors -- 1003' => 0x321E00 ,
'FOCOLTONE Colors -- 1004' => 0x001E0F ,
'FOCOLTONE Colors -- 1005' => 0x32000F ,
'FOCOLTONE Colors -- 1006' => 0x321E00 ,
'FOCOLTONE Colors -- 1007' => 0x001E0F ,
'FOCOLTONE Colors -- 1008' => 0x320000 ,
'FOCOLTONE Colors -- 1009' => 0x001E00 ,
'FOCOLTONE Colors -- 1010' => 0x00000F ,
'FOCOLTONE Colors -- 1011' => 0x00000F ,
'FOCOLTONE Colors -- 1012' => 0x001E00 ,
'FOCOLTONE Colors -- 1013' => 0x320000 ,
'FOCOLTONE Colors -- 1014' => 0x0F2814 ,
'FOCOLTONE Colors -- 1015' => 0x0F2814 ,
'FOCOLTONE Colors -- 1016' => 0x0F0014 ,
'FOCOLTONE Colors -- 1017' => 0x0F2800 ,
'FOCOLTONE Colors -- 1018' => 0x002814 ,
'FOCOLTONE Colors -- 1019' => 0x0F0014 ,
'FOCOLTONE Colors -- 1020' => 0x0F2800 ,
'FOCOLTONE Colors -- 1021' => 0x002814 ,
'FOCOLTONE Colors -- 1022' => 0x0F0000 ,
'FOCOLTONE Colors -- 1023' => 0x002800 ,
'FOCOLTONE Colors -- 1024' => 0x000014 ,
'FOCOLTONE Colors -- 1025' => 0x000014 ,
'FOCOLTONE Colors -- 1026' => 0x002800 ,
'FOCOLTONE Colors -- 1027' => 0x0F0000 ,
'FOCOLTONE Colors -- 1028' => 0x14321E ,
'FOCOLTONE Colors -- 1029' => 0x14321E ,
'FOCOLTONE Colors -- 1030' => 0x14001E ,
'FOCOLTONE Colors -- 1031' => 0x143200 ,
'FOCOLTONE Colors -- 1032' => 0x00321E ,
'FOCOLTONE Colors -- 1033' => 0x14001E ,
'FOCOLTONE Colors -- 1034' => 0x143200 ,
'FOCOLTONE Colors -- 1035' => 0x00321E ,
'FOCOLTONE Colors -- 1036' => 0x140000 ,
'FOCOLTONE Colors -- 1037' => 0x003200 ,
'FOCOLTONE Colors -- 1038' => 0x00001E ,
'FOCOLTONE Colors -- 1039' => 0x00001E ,
'FOCOLTONE Colors -- 1040' => 0x003200 ,
'FOCOLTONE Colors -- 1041' => 0x140000 ,
'FOCOLTONE Colors -- 1042' => 0x1E0F28 ,
'FOCOLTONE Colors -- 1043' => 0x1E0F28 ,
'FOCOLTONE Colors -- 1044' => 0x1E0028 ,
'FOCOLTONE Colors -- 1045' => 0x1E0F00 ,
'FOCOLTONE Colors -- 1046' => 0x000F28 ,
'FOCOLTONE Colors -- 1047' => 0x1E0028 ,
'FOCOLTONE Colors -- 1048' => 0x1E0F00 ,
'FOCOLTONE Colors -- 1049' => 0x000F28 ,
'FOCOLTONE Colors -- 1050' => 0x1E0000 ,
'FOCOLTONE Colors -- 1051' => 0x000F00 ,
'FOCOLTONE Colors -- 1052' => 0x000028 ,
'FOCOLTONE Colors -- 1053' => 0x000028 ,
'FOCOLTONE Colors -- 1054' => 0x000F00 ,
'FOCOLTONE Colors -- 1055' => 0x1E0000 ,
'FOCOLTONE Colors -- 1056' => 0x281432 ,
'FOCOLTONE Colors -- 1057' => 0x281432 ,
'FOCOLTONE Colors -- 1058' => 0x280032 ,
'FOCOLTONE Colors -- 1059' => 0x281400 ,
'FOCOLTONE Colors -- 1060' => 0x001432 ,
'FOCOLTONE Colors -- 1061' => 0x280032 ,
'FOCOLTONE Colors -- 1062' => 0x281400 ,
'FOCOLTONE Colors -- 1063' => 0x001432 ,
'FOCOLTONE Colors -- 1064' => 0x280000 ,
'FOCOLTONE Colors -- 1065' => 0x001400 ,
'FOCOLTONE Colors -- 1066' => 0x000032 ,
'FOCOLTONE Colors -- 1067' => 0x000032 ,
'FOCOLTONE Colors -- 1068' => 0x001400 ,
'FOCOLTONE Colors -- 1069' => 0x280000 ,
'FOCOLTONE Colors -- 1070' => 0x000064 ,
'FOCOLTONE Colors -- 1071' => 0x006400 ,
'FOCOLTONE Colors -- 1072' => 0x640000 ,
'FOCOLTONE Colors -- 1073' => 0x000000 ,
'FOCOLTONE Colors -- 1074' => 0x006464 ,
'FOCOLTONE Colors -- 1075' => 0x640064 ,
'FOCOLTONE Colors -- 1076' => 0x646400 ,
'FOCOLTONE Colors -- 1077' => 0x000064 ,
'FOCOLTONE Colors -- 1078' => 0x006400 ,
'FOCOLTONE Colors -- 1079' => 0x640000 ,
'FOCOLTONE Colors -- 1080' => 0x006464 ,
'FOCOLTONE Colors -- 1081' => 0x640064 ,
'FOCOLTONE Colors -- 1082' => 0x646400 ,
'FOCOLTONE Colors -- 1083' => 0x000000 ,
'FOCOLTONE Colors -- 1084' => 0x321E64 ,
'FOCOLTONE Colors -- 1085' => 0x321E64 ,
'FOCOLTONE Colors -- 1086' => 0x320064 ,
'FOCOLTONE Colors -- 1087' => 0x001E64 ,
'FOCOLTONE Colors -- 1088' => 0x320064 ,
'FOCOLTONE Colors -- 1089' => 0x001E64 ,
'FOCOLTONE Colors -- 1090' => 0x0F2864 ,
'FOCOLTONE Colors -- 1091' => 0x0F2864 ,
'FOCOLTONE Colors -- 1092' => 0x0F0064 ,
'FOCOLTONE Colors -- 1093' => 0x002864 ,
'FOCOLTONE Colors -- 1094' => 0x0F0064 ,
'FOCOLTONE Colors -- 1095' => 0x002864 ,
'FOCOLTONE Colors -- 1096' => 0x143264 ,
'FOCOLTONE Colors -- 1097' => 0x143264 ,
'FOCOLTONE Colors -- 1098' => 0x140064 ,
'FOCOLTONE Colors -- 1099' => 0x003264 ,
'FOCOLTONE Colors -- 1100' => 0x140064 ,
'FOCOLTONE Colors -- 1101' => 0x003264 ,
'FOCOLTONE Colors -- 1102' => 0x1E0F64 ,
'FOCOLTONE Colors -- 1103' => 0x1E0F64 ,
'FOCOLTONE Colors -- 1104' => 0x1E0064 ,
'FOCOLTONE Colors -- 1105' => 0x000F64 ,
'FOCOLTONE Colors -- 1106' => 0x1E0064 ,
'FOCOLTONE Colors -- 1107' => 0x000F64 ,
'FOCOLTONE Colors -- 1108' => 0x281464 ,
'FOCOLTONE Colors -- 1109' => 0x281464 ,
'FOCOLTONE Colors -- 1110' => 0x280064 ,
'FOCOLTONE Colors -- 1111' => 0x001464 ,
'FOCOLTONE Colors -- 1112' => 0x280064 ,
'FOCOLTONE Colors -- 1113' => 0x001464 ,
'FOCOLTONE Colors -- 1114' => 0x32640F ,
'FOCOLTONE Colors -- 1115' => 0x32640F ,
'FOCOLTONE Colors -- 1116' => 0x326400 ,
'FOCOLTONE Colors -- 1117' => 0x00640F ,
'FOCOLTONE Colors -- 1118' => 0x326400 ,
'FOCOLTONE Colors -- 1119' => 0x00640F ,
'FOCOLTONE Colors -- 1120' => 0x0F6414 ,
'FOCOLTONE Colors -- 1121' => 0x0F6414 ,
'FOCOLTONE Colors -- 1122' => 0x0F6400 ,
'FOCOLTONE Colors -- 1123' => 0x006414 ,
'FOCOLTONE Colors -- 1124' => 0x0F6400 ,
'FOCOLTONE Colors -- 1125' => 0x006414 ,
'FOCOLTONE Colors -- 1126' => 0x14641E ,
'FOCOLTONE Colors -- 1127' => 0x14641E ,
'FOCOLTONE Colors -- 1128' => 0x146400 ,
'FOCOLTONE Colors -- 1129' => 0x00641E ,
'FOCOLTONE Colors -- 1130' => 0x146400 ,
'FOCOLTONE Colors -- 1131' => 0x00641E ,
'FOCOLTONE Colors -- 1132' => 0x1E6428 ,
'FOCOLTONE Colors -- 1133' => 0x1E6428 ,
'FOCOLTONE Colors -- 1134' => 0x1E6400 ,
'FOCOLTONE Colors -- 1135' => 0x006428 ,
'FOCOLTONE Colors -- 1136' => 0x1E6400 ,
'FOCOLTONE Colors -- 1137' => 0x006428 ,
'FOCOLTONE Colors -- 1138' => 0x286432 ,
'FOCOLTONE Colors -- 1139' => 0x286432 ,
'FOCOLTONE Colors -- 1140' => 0x286400 ,
'FOCOLTONE Colors -- 1141' => 0x006432 ,
'FOCOLTONE Colors -- 1142' => 0x286400 ,
'FOCOLTONE Colors -- 1143' => 0x006432 ,
'FOCOLTONE Colors -- 1144' => 0x641E0F ,
'FOCOLTONE Colors -- 1145' => 0x641E0F ,
'FOCOLTONE Colors -- 1146' => 0x64000F ,
'FOCOLTONE Colors -- 1147' => 0x641E00 ,
'FOCOLTONE Colors -- 1148' => 0x64000F ,
'FOCOLTONE Colors -- 1149' => 0x641E00 ,
'FOCOLTONE Colors -- 1150' => 0x642814 ,
'FOCOLTONE Colors -- 1151' => 0x642814 ,
'FOCOLTONE Colors -- 1152' => 0x640014 ,
'FOCOLTONE Colors -- 1153' => 0x642800 ,
'FOCOLTONE Colors -- 1154' => 0x640014 ,
'FOCOLTONE Colors -- 1155' => 0x642800 ,
'FOCOLTONE Colors -- 1156' => 0x64321E ,
'FOCOLTONE Colors -- 1157' => 0x64321E ,
'FOCOLTONE Colors -- 1158' => 0x64001E ,
'FOCOLTONE Colors -- 1159' => 0x643200 ,
'FOCOLTONE Colors -- 1160' => 0x64001E ,
'FOCOLTONE Colors -- 1161' => 0x643200 ,
'FOCOLTONE Colors -- 1162' => 0x640F28 ,
'FOCOLTONE Colors -- 1163' => 0x640F28 ,
'FOCOLTONE Colors -- 1164' => 0x640028 ,
'FOCOLTONE Colors -- 1165' => 0x640F00 ,
'FOCOLTONE Colors -- 1166' => 0x640028 ,
'FOCOLTONE Colors -- 1167' => 0x640F00 ,
'FOCOLTONE Colors -- 1168' => 0x641432 ,
'FOCOLTONE Colors -- 1169' => 0x641432 ,
'FOCOLTONE Colors -- 1170' => 0x640032 ,
'FOCOLTONE Colors -- 1171' => 0x641400 ,
'FOCOLTONE Colors -- 1172' => 0x640032 ,
'FOCOLTONE Colors -- 1173' => 0x641400 ,
'FOCOLTONE Colors -- 2174' => 0x412D19 ,
'FOCOLTONE Colors -- 2175' => 0x412D19 ,
'FOCOLTONE Colors -- 2176' => 0x410019 ,
'FOCOLTONE Colors -- 2177' => 0x412D00 ,
'FOCOLTONE Colors -- 2178' => 0x002D19 ,
'FOCOLTONE Colors -- 2179' => 0x410019 ,
'FOCOLTONE Colors -- 2180' => 0x412D00 ,
'FOCOLTONE Colors -- 2181' => 0x002D19 ,
'FOCOLTONE Colors -- 2182' => 0x410000 ,
'FOCOLTONE Colors -- 2183' => 0x002D00 ,
'FOCOLTONE Colors -- 2184' => 0x000019 ,
'FOCOLTONE Colors -- 2185' => 0x000019 ,
'FOCOLTONE Colors -- 2186' => 0x002D00 ,
'FOCOLTONE Colors -- 2187' => 0x410000 ,
'FOCOLTONE Colors -- 2188' => 0x46372D ,
'FOCOLTONE Colors -- 2189' => 0x46372D ,
'FOCOLTONE Colors -- 2190' => 0x46002D ,
'FOCOLTONE Colors -- 2191' => 0x463700 ,
'FOCOLTONE Colors -- 2192' => 0x00372D ,
'FOCOLTONE Colors -- 2193' => 0x46002D ,
'FOCOLTONE Colors -- 2194' => 0x463700 ,
'FOCOLTONE Colors -- 2195' => 0x00372D ,
'FOCOLTONE Colors -- 2196' => 0x460000 ,
'FOCOLTONE Colors -- 2197' => 0x003700 ,
'FOCOLTONE Colors -- 2198' => 0x00002D ,
'FOCOLTONE Colors -- 2199' => 0x00002D ,
'FOCOLTONE Colors -- 2200' => 0x003700 ,
'FOCOLTONE Colors -- 2201' => 0x460000 ,
'FOCOLTONE Colors -- 2202' => 0x194137 ,
'FOCOLTONE Colors -- 2203' => 0x194137 ,
'FOCOLTONE Colors -- 2204' => 0x190037 ,
'FOCOLTONE Colors -- 2205' => 0x194100 ,
'FOCOLTONE Colors -- 2206' => 0x004137 ,
'FOCOLTONE Colors -- 2207' => 0x190037 ,
'FOCOLTONE Colors -- 2208' => 0x194100 ,
'FOCOLTONE Colors -- 2209' => 0x004137 ,
'FOCOLTONE Colors -- 2210' => 0x190000 ,
'FOCOLTONE Colors -- 2211' => 0x004100 ,
'FOCOLTONE Colors -- 2212' => 0x000037 ,
'FOCOLTONE Colors -- 2213' => 0x000037 ,
'FOCOLTONE Colors -- 2214' => 0x004100 ,
'FOCOLTONE Colors -- 2215' => 0x190000 ,
'FOCOLTONE Colors -- 2216' => 0x2D4641 ,
'FOCOLTONE Colors -- 2217' => 0x2D4641 ,
'FOCOLTONE Colors -- 2218' => 0x2D0041 ,
'FOCOLTONE Colors -- 2219' => 0x2D4600 ,
'FOCOLTONE Colors -- 2220' => 0x004641 ,
'FOCOLTONE Colors -- 2221' => 0x2D0041 ,
'FOCOLTONE Colors -- 2222' => 0x2D4600 ,
'FOCOLTONE Colors -- 2223' => 0x004641 ,
'FOCOLTONE Colors -- 2224' => 0x2D0000 ,
'FOCOLTONE Colors -- 2225' => 0x004600 ,
'FOCOLTONE Colors -- 2226' => 0x000041 ,
'FOCOLTONE Colors -- 2227' => 0x000041 ,
'FOCOLTONE Colors -- 2228' => 0x004600 ,
'FOCOLTONE Colors -- 2229' => 0x2D0000 ,
'FOCOLTONE Colors -- 2230' => 0x371946 ,
'FOCOLTONE Colors -- 2231' => 0x371946 ,
'FOCOLTONE Colors -- 2232' => 0x370046 ,
'FOCOLTONE Colors -- 2233' => 0x371900 ,
'FOCOLTONE Colors -- 2234' => 0x001946 ,
'FOCOLTONE Colors -- 2235' => 0x370046 ,
'FOCOLTONE Colors -- 2236' => 0x371900 ,
'FOCOLTONE Colors -- 2237' => 0x001946 ,
'FOCOLTONE Colors -- 2238' => 0x370000 ,
'FOCOLTONE Colors -- 2239' => 0x001900 ,
'FOCOLTONE Colors -- 2240' => 0x000046 ,
'FOCOLTONE Colors -- 2241' => 0x000046 ,
'FOCOLTONE Colors -- 2242' => 0x001900 ,
'FOCOLTONE Colors -- 2243' => 0x370000 ,
'FOCOLTONE Colors -- 2244' => 0x000064 ,
'FOCOLTONE Colors -- 2245' => 0x006400 ,
'FOCOLTONE Colors -- 2246' => 0x640000 ,
'FOCOLTONE Colors -- 2247' => 0x006464 ,
'FOCOLTONE Colors -- 2248' => 0x640064 ,
'FOCOLTONE Colors -- 2249' => 0x646400 ,
'FOCOLTONE Colors -- 2250' => 0x000000 ,
'FOCOLTONE Colors -- 2251' => 0x412D64 ,
'FOCOLTONE Colors -- 2252' => 0x412D64 ,
'FOCOLTONE Colors -- 2253' => 0x410064 ,
'FOCOLTONE Colors -- 2254' => 0x002D64 ,
'FOCOLTONE Colors -- 2255' => 0x410064 ,
'FOCOLTONE Colors -- 2256' => 0x002D64 ,
'FOCOLTONE Colors -- 2257' => 0x463764 ,
'FOCOLTONE Colors -- 2258' => 0x463764 ,
'FOCOLTONE Colors -- 2259' => 0x460064 ,
'FOCOLTONE Colors -- 2260' => 0x003764 ,
'FOCOLTONE Colors -- 2261' => 0x460064 ,
'FOCOLTONE Colors -- 2262' => 0x003764 ,
'FOCOLTONE Colors -- 2263' => 0x194164 ,
'FOCOLTONE Colors -- 2264' => 0x194164 ,
'FOCOLTONE Colors -- 2265' => 0x190064 ,
'FOCOLTONE Colors -- 2266' => 0x004164 ,
'FOCOLTONE Colors -- 2267' => 0x190064 ,
'FOCOLTONE Colors -- 2268' => 0x004164 ,
'FOCOLTONE Colors -- 2269' => 0x2D4664 ,
'FOCOLTONE Colors -- 2270' => 0x2D4664 ,
'FOCOLTONE Colors -- 2271' => 0x2D0064 ,
'FOCOLTONE Colors -- 2272' => 0x004664 ,
'FOCOLTONE Colors -- 2273' => 0x2D0064 ,
'FOCOLTONE Colors -- 2274' => 0x004664 ,
'FOCOLTONE Colors -- 2275' => 0x371964 ,
'FOCOLTONE Colors -- 2276' => 0x371964 ,
'FOCOLTONE Colors -- 2277' => 0x370064 ,
'FOCOLTONE Colors -- 2278' => 0x001964 ,
'FOCOLTONE Colors -- 2279' => 0x370064 ,
'FOCOLTONE Colors -- 2280' => 0x001964 ,
'FOCOLTONE Colors -- 2281' => 0x416419 ,
'FOCOLTONE Colors -- 2282' => 0x416419 ,
'FOCOLTONE Colors -- 2283' => 0x416400 ,
'FOCOLTONE Colors -- 2284' => 0x006419 ,
'FOCOLTONE Colors -- 2285' => 0x416400 ,
'FOCOLTONE Colors -- 2286' => 0x006419 ,
'FOCOLTONE Colors -- 2287' => 0x46642D ,
'FOCOLTONE Colors -- 2288' => 0x46642D ,
'FOCOLTONE Colors -- 2289' => 0x466400 ,
'FOCOLTONE Colors -- 2290' => 0x00642D ,
'FOCOLTONE Colors -- 2291' => 0x466400 ,
'FOCOLTONE Colors -- 2292' => 0x00642D ,
'FOCOLTONE Colors -- 2293' => 0x196437 ,
'FOCOLTONE Colors -- 2294' => 0x196437 ,
'FOCOLTONE Colors -- 2295' => 0x196400 ,
'FOCOLTONE Colors -- 2296' => 0x006437 ,
'FOCOLTONE Colors -- 2297' => 0x196400 ,
'FOCOLTONE Colors -- 2298' => 0x006437 ,
'FOCOLTONE Colors -- 2299' => 0x2D6441 ,
'FOCOLTONE Colors -- 2300' => 0x2D6441 ,
'FOCOLTONE Colors -- 2301' => 0x2D6400 ,
'FOCOLTONE Colors -- 2302' => 0x006441 ,
'FOCOLTONE Colors -- 2303' => 0x2D6400 ,
'FOCOLTONE Colors -- 2304' => 0x006441 ,
'FOCOLTONE Colors -- 2305' => 0x376446 ,
'FOCOLTONE Colors -- 2306' => 0x376446 ,
'FOCOLTONE Colors -- 2307' => 0x376400 ,
'FOCOLTONE Colors -- 2308' => 0x006446 ,
'FOCOLTONE Colors -- 2309' => 0x376400 ,
'FOCOLTONE Colors -- 2310' => 0x006446 ,
'FOCOLTONE Colors -- 2311' => 0x642D19 ,
'FOCOLTONE Colors -- 2312' => 0x642D19 ,
'FOCOLTONE Colors -- 2313' => 0x640019 ,
'FOCOLTONE Colors -- 2314' => 0x642D00 ,
'FOCOLTONE Colors -- 2315' => 0x640019 ,
'FOCOLTONE Colors -- 2316' => 0x642D00 ,
'FOCOLTONE Colors -- 2317' => 0x64372D ,
'FOCOLTONE Colors -- 2318' => 0x64372D ,
'FOCOLTONE Colors -- 2319' => 0x64002D ,
'FOCOLTONE Colors -- 2320' => 0x643700 ,
'FOCOLTONE Colors -- 2321' => 0x64002D ,
'FOCOLTONE Colors -- 2322' => 0x643700 ,
'FOCOLTONE Colors -- 2323' => 0x644137 ,
'FOCOLTONE Colors -- 2324' => 0x644137 ,
'FOCOLTONE Colors -- 2325' => 0x640037 ,
'FOCOLTONE Colors -- 2326' => 0x644100 ,
'FOCOLTONE Colors -- 2327' => 0x640037 ,
'FOCOLTONE Colors -- 2328' => 0x643700 ,
'FOCOLTONE Colors -- 2329' => 0x644641 ,
'FOCOLTONE Colors -- 2330' => 0x644641 ,
'FOCOLTONE Colors -- 2331' => 0x640041 ,
'FOCOLTONE Colors -- 2332' => 0x644600 ,
'FOCOLTONE Colors -- 2333' => 0x640041 ,
'FOCOLTONE Colors -- 2334' => 0x644600 ,
'FOCOLTONE Colors -- 2335' => 0x641946 ,
'FOCOLTONE Colors -- 2336' => 0x641946 ,
'FOCOLTONE Colors -- 2337' => 0x640046 ,
'FOCOLTONE Colors -- 2338' => 0x641900 ,
'FOCOLTONE Colors -- 2339' => 0x640046 ,
'FOCOLTONE Colors -- 2340' => 0x641900 ,
'FOCOLTONE Colors -- 3341' => 0x3C4B23 ,
'FOCOLTONE Colors -- 3342' => 0x3C4B23 ,
'FOCOLTONE Colors -- 3343' => 0x3C0023 ,
'FOCOLTONE Colors -- 3344' => 0x3C4B00 ,
'FOCOLTONE Colors -- 3345' => 0x004B23 ,
'FOCOLTONE Colors -- 3346' => 0x3C0023 ,
'FOCOLTONE Colors -- 3347' => 0x3C4B00 ,
'FOCOLTONE Colors -- 3348' => 0x004B23 ,
'FOCOLTONE Colors -- 3349' => 0x3C0000 ,
'FOCOLTONE Colors -- 3350' => 0x004B00 ,
'FOCOLTONE Colors -- 3351' => 0x000023 ,
'FOCOLTONE Colors -- 3352' => 0x000023 ,
'FOCOLTONE Colors -- 3353' => 0x004B00 ,
'FOCOLTONE Colors -- 3354' => 0x3C0000 ,
'FOCOLTONE Colors -- 3355' => 0x4B503C ,
'FOCOLTONE Colors -- 3356' => 0x4B503C ,
'FOCOLTONE Colors -- 3357' => 0x4B003C ,
'FOCOLTONE Colors -- 3358' => 0x4B5000 ,
'FOCOLTONE Colors -- 3359' => 0x00503C ,
'FOCOLTONE Colors -- 3360' => 0x4B003C ,
'FOCOLTONE Colors -- 3361' => 0x4B5000 ,
'FOCOLTONE Colors -- 3362' => 0x00503C ,
'FOCOLTONE Colors -- 3363' => 0x4B0000 ,
'FOCOLTONE Colors -- 3364' => 0x005000 ,
'FOCOLTONE Colors -- 3365' => 0x00003C ,
'FOCOLTONE Colors -- 3366' => 0x00003C ,
'FOCOLTONE Colors -- 3367' => 0x005000 ,
'FOCOLTONE Colors -- 3368' => 0x4B0000 ,
'FOCOLTONE Colors -- 3369' => 0x50554B ,
'FOCOLTONE Colors -- 3370' => 0x50554B ,
'FOCOLTONE Colors -- 3371' => 0x50004B ,
'FOCOLTONE Colors -- 3372' => 0x505500 ,
'FOCOLTONE Colors -- 3373' => 0x00554B ,
'FOCOLTONE Colors -- 3374' => 0x50004B ,
'FOCOLTONE Colors -- 3375' => 0x505500 ,
'FOCOLTONE Colors -- 3376' => 0x00554B ,
'FOCOLTONE Colors -- 3377' => 0x500000 ,
'FOCOLTONE Colors -- 3378' => 0x005500 ,
'FOCOLTONE Colors -- 3379' => 0x00004B ,
'FOCOLTONE Colors -- 3380' => 0x00004B ,
'FOCOLTONE Colors -- 3381' => 0x005500 ,
'FOCOLTONE Colors -- 3382' => 0x500000 ,
'FOCOLTONE Colors -- 3383' => 0x552350 ,
'FOCOLTONE Colors -- 3384' => 0x552350 ,
'FOCOLTONE Colors -- 3385' => 0x550050 ,
'FOCOLTONE Colors -- 3386' => 0x552300 ,
'FOCOLTONE Colors -- 3387' => 0x002350 ,
'FOCOLTONE Colors -- 3388' => 0x550050 ,
'FOCOLTONE Colors -- 3389' => 0x552300 ,
'FOCOLTONE Colors -- 3390' => 0x002350 ,
'FOCOLTONE Colors -- 3391' => 0x550000 ,
'FOCOLTONE Colors -- 3392' => 0x002300 ,
'FOCOLTONE Colors -- 3393' => 0x000050 ,
'FOCOLTONE Colors -- 3394' => 0x000050 ,
'FOCOLTONE Colors -- 3395' => 0x002300 ,
'FOCOLTONE Colors -- 3396' => 0x550000 ,
'FOCOLTONE Colors -- 3397' => 0x233C55 ,
'FOCOLTONE Colors -- 3398' => 0x233C55 ,
'FOCOLTONE Colors -- 3399' => 0x230055 ,
'FOCOLTONE Colors -- 3400' => 0x233C00 ,
'FOCOLTONE Colors -- 3401' => 0x003C55 ,
'FOCOLTONE Colors -- 3402' => 0x230055 ,
'FOCOLTONE Colors -- 3403' => 0x233C00 ,
'FOCOLTONE Colors -- 3404' => 0x003C55 ,
'FOCOLTONE Colors -- 3405' => 0x230000 ,
'FOCOLTONE Colors -- 3406' => 0x003C00 ,
'FOCOLTONE Colors -- 3407' => 0x000055 ,
'FOCOLTONE Colors -- 3408' => 0x000055 ,
'FOCOLTONE Colors -- 3409' => 0x003C00 ,
'FOCOLTONE Colors -- 3410' => 0x230000 ,
'FOCOLTONE Colors -- 3411' => 0x000064 ,
'FOCOLTONE Colors -- 3412' => 0x006400 ,
'FOCOLTONE Colors -- 3413' => 0x640000 ,
'FOCOLTONE Colors -- 3414' => 0x006464 ,
'FOCOLTONE Colors -- 3415' => 0x640064 ,
'FOCOLTONE Colors -- 3416' => 0x646400 ,
'FOCOLTONE Colors -- 3417' => 0x000000 ,
'FOCOLTONE Colors -- 3418' => 0x3C4B64 ,
'FOCOLTONE Colors -- 3419' => 0x3C4B64 ,
'FOCOLTONE Colors -- 3420' => 0x3C0064 ,
'FOCOLTONE Colors -- 3421' => 0x004B64 ,
'FOCOLTONE Colors -- 3422' => 0x3C0064 ,
'FOCOLTONE Colors -- 3423' => 0x004B64 ,
'FOCOLTONE Colors -- 3424' => 0x4B5064 ,
'FOCOLTONE Colors -- 3425' => 0x4B5064 ,
'FOCOLTONE Colors -- 3426' => 0x4B0064 ,
'FOCOLTONE Colors -- 3427' => 0x005064 ,
'FOCOLTONE Colors -- 3428' => 0x4B0064 ,
'FOCOLTONE Colors -- 3429' => 0x005064 ,
'FOCOLTONE Colors -- 3430' => 0x505564 ,
'FOCOLTONE Colors -- 3431' => 0x505564 ,
'FOCOLTONE Colors -- 3432' => 0x500064 ,
'FOCOLTONE Colors -- 3433' => 0x005564 ,
'FOCOLTONE Colors -- 3434' => 0x500064 ,
'FOCOLTONE Colors -- 3435' => 0x005564 ,
'FOCOLTONE Colors -- 3436' => 0x552364 ,
'FOCOLTONE Colors -- 3437' => 0x552364 ,
'FOCOLTONE Colors -- 3438' => 0x550064 ,
'FOCOLTONE Colors -- 3439' => 0x002364 ,
'FOCOLTONE Colors -- 3440' => 0x550064 ,
'FOCOLTONE Colors -- 3441' => 0x002364 ,
'FOCOLTONE Colors -- 3442' => 0x233C64 ,
'FOCOLTONE Colors -- 3443' => 0x233C64 ,
'FOCOLTONE Colors -- 3444' => 0x230064 ,
'FOCOLTONE Colors -- 3445' => 0x003C64 ,
'FOCOLTONE Colors -- 3446' => 0x230064 ,
'FOCOLTONE Colors -- 3447' => 0x003C64 ,
'FOCOLTONE Colors -- 3448' => 0x3C6423 ,
'FOCOLTONE Colors -- 3449' => 0x3C6423 ,
'FOCOLTONE Colors -- 3450' => 0x3C6400 ,
'FOCOLTONE Colors -- 3451' => 0x006423 ,
'FOCOLTONE Colors -- 3452' => 0x3C6400 ,
'FOCOLTONE Colors -- 3453' => 0x006423 ,
'FOCOLTONE Colors -- 3454' => 0x4B643C ,
'FOCOLTONE Colors -- 3455' => 0x4B643C ,
'FOCOLTONE Colors -- 3456' => 0x4B6400 ,
'FOCOLTONE Colors -- 3457' => 0x00643C ,
'FOCOLTONE Colors -- 3458' => 0x4B6400 ,
'FOCOLTONE Colors -- 3459' => 0x00643C ,
'FOCOLTONE Colors -- 3460' => 0x50644B ,
'FOCOLTONE Colors -- 3461' => 0x50644B ,
'FOCOLTONE Colors -- 3462' => 0x506400 ,
'FOCOLTONE Colors -- 3463' => 0x00644B ,
'FOCOLTONE Colors -- 3464' => 0x506400 ,
'FOCOLTONE Colors -- 3465' => 0x00644B ,
'FOCOLTONE Colors -- 3466' => 0x556450 ,
'FOCOLTONE Colors -- 3467' => 0x556450 ,
'FOCOLTONE Colors -- 3468' => 0x556400 ,
'FOCOLTONE Colors -- 3469' => 0x006450 ,
'FOCOLTONE Colors -- 3470' => 0x556400 ,
'FOCOLTONE Colors -- 3471' => 0x006450 ,
'FOCOLTONE Colors -- 3472' => 0x236455 ,
'FOCOLTONE Colors -- 3473' => 0x236455 ,
'FOCOLTONE Colors -- 3474' => 0x236400 ,
'FOCOLTONE Colors -- 3475' => 0x006455 ,
'FOCOLTONE Colors -- 3476' => 0x236400 ,
'FOCOLTONE Colors -- 3477' => 0x006455 ,
'FOCOLTONE Colors -- 3478' => 0x644B23 ,
'FOCOLTONE Colors -- 3479' => 0x644B23 ,
'FOCOLTONE Colors -- 3480' => 0x640023 ,
'FOCOLTONE Colors -- 3481' => 0x644B00 ,
'FOCOLTONE Colors -- 3482' => 0x640023 ,
'FOCOLTONE Colors -- 3483' => 0x644B00 ,
'FOCOLTONE Colors -- 3484' => 0x64503C ,
'FOCOLTONE Colors -- 3485' => 0x64503C ,
'FOCOLTONE Colors -- 3486' => 0x64003C ,
'FOCOLTONE Colors -- 3487' => 0x645000 ,
'FOCOLTONE Colors -- 3488' => 0x64003C ,
'FOCOLTONE Colors -- 3489' => 0x645000 ,
'FOCOLTONE Colors -- 3490' => 0x64554B ,
'FOCOLTONE Colors -- 3491' => 0x64554B ,
'FOCOLTONE Colors -- 3492' => 0x64004B ,
'FOCOLTONE Colors -- 3493' => 0x645500 ,
'FOCOLTONE Colors -- 3494' => 0x64004B ,
'FOCOLTONE Colors -- 3495' => 0x645500 ,
'FOCOLTONE Colors -- 3496' => 0x642350 ,
'FOCOLTONE Colors -- 3497' => 0x642350 ,
'FOCOLTONE Colors -- 3498' => 0x640050 ,
'FOCOLTONE Colors -- 3499' => 0x642300 ,
'FOCOLTONE Colors -- 3500' => 0x640050 ,
'FOCOLTONE Colors -- 3501' => 0x642300 ,
'FOCOLTONE Colors -- 3502' => 0x643C55 ,
'FOCOLTONE Colors -- 3503' => 0x643C55 ,
'FOCOLTONE Colors -- 3504' => 0x640055 ,
'FOCOLTONE Colors -- 3505' => 0x643C00 ,
'FOCOLTONE Colors -- 3506' => 0x640055 ,
'FOCOLTONE Colors -- 3507' => 0x643C00 ,
'FOCOLTONE Colors -- 4000' => 0x050505 ,
'FOCOLTONE Colors -- 4001' => 0x050505 ,
'FOCOLTONE Colors -- 4002' => 0x050005 ,
'FOCOLTONE Colors -- 4003' => 0x050500 ,
'FOCOLTONE Colors -- 4004' => 0x000505 ,
'FOCOLTONE Colors -- 4005' => 0x050005 ,
'FOCOLTONE Colors -- 4006' => 0x050500 ,
'FOCOLTONE Colors -- 4007' => 0x000505 ,
'FOCOLTONE Colors -- 4008' => 0x050000 ,
'FOCOLTONE Colors -- 4009' => 0x000500 ,
'FOCOLTONE Colors -- 4010' => 0x000005 ,
'FOCOLTONE Colors -- 4011' => 0x000005 ,
'FOCOLTONE Colors -- 4012' => 0x000500 ,
'FOCOLTONE Colors -- 4013' => 0x050000 ,
'FOCOLTONE Colors -- 4014' => 0x0A0A0A ,
'FOCOLTONE Colors -- 4015' => 0x0A0A0A ,
'FOCOLTONE Colors -- 4016' => 0x0A000A ,
'FOCOLTONE Colors -- 4017' => 0x0A0A00 ,
'FOCOLTONE Colors -- 4018' => 0x000A0A ,
'FOCOLTONE Colors -- 4019' => 0x0A000A ,
'FOCOLTONE Colors -- 4020' => 0x0A0A00 ,
'FOCOLTONE Colors -- 4021' => 0x000A0A ,
'FOCOLTONE Colors -- 4022' => 0x0A0000 ,
'FOCOLTONE Colors -- 4023' => 0x000A00 ,
'FOCOLTONE Colors -- 4024' => 0x00000A ,
'FOCOLTONE Colors -- 4025' => 0x00000A ,
'FOCOLTONE Colors -- 4026' => 0x000A00 ,
'FOCOLTONE Colors -- 4027' => 0x0A0000 ,
'FOCOLTONE Colors -- 4028' => 0x0F0F0F ,
'FOCOLTONE Colors -- 4029' => 0x0F0F0F ,
'FOCOLTONE Colors -- 4030' => 0x0F000F ,
'FOCOLTONE Colors -- 4031' => 0x0F0F00 ,
'FOCOLTONE Colors -- 4032' => 0x000F0F ,
'FOCOLTONE Colors -- 4033' => 0x0F000F ,
'FOCOLTONE Colors -- 4034' => 0x0F0F00 ,
'FOCOLTONE Colors -- 4035' => 0x000F0F ,
'FOCOLTONE Colors -- 4036' => 0x0F0000 ,
'FOCOLTONE Colors -- 4037' => 0x000F00 ,
'FOCOLTONE Colors -- 4038' => 0x00000F ,
'FOCOLTONE Colors -- 4039' => 0x141414 ,
'FOCOLTONE Colors -- 4040' => 0x141414 ,
'FOCOLTONE Colors -- 4041' => 0x140014 ,
'FOCOLTONE Colors -- 4042' => 0x141400 ,
'FOCOLTONE Colors -- 4043' => 0x001414 ,
'FOCOLTONE Colors -- 4044' => 0x140014 ,
'FOCOLTONE Colors -- 4045' => 0x141400 ,
'FOCOLTONE Colors -- 4046' => 0x001414 ,
'FOCOLTONE Colors -- 4047' => 0x140000 ,
'FOCOLTONE Colors -- 4048' => 0x001400 ,
'FOCOLTONE Colors -- 4049' => 0x000014 ,
'FOCOLTONE Colors -- 4050' => 0x191919 ,
'FOCOLTONE Colors -- 4051' => 0x191919 ,
'FOCOLTONE Colors -- 4052' => 0x190019 ,
'FOCOLTONE Colors -- 4053' => 0x191900 ,
'FOCOLTONE Colors -- 4054' => 0x001919 ,
'FOCOLTONE Colors -- 4055' => 0x190019 ,
'FOCOLTONE Colors -- 4056' => 0x191900 ,
'FOCOLTONE Colors -- 4057' => 0x001919 ,
'FOCOLTONE Colors -- 4058' => 0x190000 ,
'FOCOLTONE Colors -- 4059' => 0x001900 ,
'FOCOLTONE Colors -- 4060' => 0x000019 ,
'FOCOLTONE Colors -- 4061' => 0x000000 ,
'FOCOLTONE Colors -- 4062' => 0x000000 ,
'FOCOLTONE Colors -- 4063' => 0x000000 ,
'FOCOLTONE Colors -- 4064' => 0x000000 ,
'FOCOLTONE Colors -- 5000' => 0x1E1E1E ,
'FOCOLTONE Colors -- 5001' => 0x1E1E1E ,
'FOCOLTONE Colors -- 5002' => 0x1E001E ,
'FOCOLTONE Colors -- 5003' => 0x1E1E00 ,
'FOCOLTONE Colors -- 5004' => 0x001E1E ,
'FOCOLTONE Colors -- 5005' => 0x1E001E ,
'FOCOLTONE Colors -- 5006' => 0x1E1E00 ,
'FOCOLTONE Colors -- 5007' => 0x001E1E ,
'FOCOLTONE Colors -- 5008' => 0x1E0000 ,
'FOCOLTONE Colors -- 5009' => 0x001E00 ,
'FOCOLTONE Colors -- 5010' => 0x00001E ,
'FOCOLTONE Colors -- 5011' => 0x232323 ,
'FOCOLTONE Colors -- 5012' => 0x232323 ,
'FOCOLTONE Colors -- 5013' => 0x230023 ,
'FOCOLTONE Colors -- 5014' => 0x232300 ,
'FOCOLTONE Colors -- 5015' => 0x002323 ,
'FOCOLTONE Colors -- 5016' => 0x230023 ,
'FOCOLTONE Colors -- 5017' => 0x232300 ,
'FOCOLTONE Colors -- 5018' => 0x002323 ,
'FOCOLTONE Colors -- 5019' => 0x230000 ,
'FOCOLTONE Colors -- 5020' => 0x002300 ,
'FOCOLTONE Colors -- 5021' => 0x000023 ,
'FOCOLTONE Colors -- 5022' => 0x282828 ,
'FOCOLTONE Colors -- 5023' => 0x282828 ,
'FOCOLTONE Colors -- 5024' => 0x280028 ,
'FOCOLTONE Colors -- 5025' => 0x282800 ,
'FOCOLTONE Colors -- 5026' => 0x002828 ,
'FOCOLTONE Colors -- 5027' => 0x280028 ,
'FOCOLTONE Colors -- 5028' => 0x282800 ,
'FOCOLTONE Colors -- 5029' => 0x002828 ,
'FOCOLTONE Colors -- 5030' => 0x280000 ,
'FOCOLTONE Colors -- 5031' => 0x002800 ,
'FOCOLTONE Colors -- 5032' => 0x000028 ,
'FOCOLTONE Colors -- 5033' => 0x2D2D2D ,
'FOCOLTONE Colors -- 5034' => 0x2D2D2D ,
'FOCOLTONE Colors -- 5035' => 0x2D002D ,
'FOCOLTONE Colors -- 5036' => 0x2D2D00 ,
'FOCOLTONE Colors -- 5037' => 0x002D2D ,
'FOCOLTONE Colors -- 5038' => 0x2D002D ,
'FOCOLTONE Colors -- 5039' => 0x2D2D00 ,
'FOCOLTONE Colors -- 5040' => 0x002D2D ,
'FOCOLTONE Colors -- 5041' => 0x2D0000 ,
'FOCOLTONE Colors -- 5042' => 0x002D00 ,
'FOCOLTONE Colors -- 5043' => 0x00002D ,
'FOCOLTONE Colors -- 5044' => 0x323232 ,
'FOCOLTONE Colors -- 5045' => 0x323232 ,
'FOCOLTONE Colors -- 5046' => 0x320032 ,
'FOCOLTONE Colors -- 5047' => 0x323200 ,
'FOCOLTONE Colors -- 5048' => 0x003232 ,
'FOCOLTONE Colors -- 5049' => 0x320032 ,
'FOCOLTONE Colors -- 5050' => 0x323200 ,
'FOCOLTONE Colors -- 5051' => 0x003232 ,
'FOCOLTONE Colors -- 5052' => 0x320000 ,
'FOCOLTONE Colors -- 5053' => 0x003200 ,
'FOCOLTONE Colors -- 5054' => 0x000032 ,
'FOCOLTONE Colors -- 5055' => 0x000000 ,
'FOCOLTONE Colors -- 5056' => 0x000000 ,
'FOCOLTONE Colors -- 5057' => 0x000000 ,
'FOCOLTONE Colors -- 6000' => 0x373737 ,
'FOCOLTONE Colors -- 6001' => 0x373737 ,
'FOCOLTONE Colors -- 6002' => 0x370037 ,
'FOCOLTONE Colors -- 6003' => 0x373700 ,
'FOCOLTONE Colors -- 6004' => 0x003737 ,
'FOCOLTONE Colors -- 6005' => 0x370037 ,
'FOCOLTONE Colors -- 6006' => 0x373700 ,
'FOCOLTONE Colors -- 6007' => 0x003737 ,
'FOCOLTONE Colors -- 6008' => 0x370000 ,
'FOCOLTONE Colors -- 6009' => 0x003700 ,
'FOCOLTONE Colors -- 6010' => 0x000037 ,
'FOCOLTONE Colors -- 6011' => 0x3C3C3C ,
'FOCOLTONE Colors -- 6012' => 0x3C3C3C ,
'FOCOLTONE Colors -- 6013' => 0x3C003C ,
'FOCOLTONE Colors -- 6014' => 0x3C3C00 ,
'FOCOLTONE Colors -- 6015' => 0x003C3C ,
'FOCOLTONE Colors -- 6016' => 0x3C003C ,
'FOCOLTONE Colors -- 6017' => 0x3C3C00 ,
'FOCOLTONE Colors -- 6018' => 0x003C3C ,
'FOCOLTONE Colors -- 6019' => 0x3C0000 ,
'FOCOLTONE Colors -- 6020' => 0x003C00 ,
'FOCOLTONE Colors -- 6021' => 0x00003C ,
'FOCOLTONE Colors -- 6022' => 0x414141 ,
'FOCOLTONE Colors -- 6023' => 0x414141 ,
'FOCOLTONE Colors -- 6024' => 0x410041 ,
'FOCOLTONE Colors -- 6025' => 0x414100 ,
'FOCOLTONE Colors -- 6026' => 0x004141 ,
'FOCOLTONE Colors -- 6027' => 0x410041 ,
'FOCOLTONE Colors -- 6028' => 0x414100 ,
'FOCOLTONE Colors -- 6029' => 0x004141 ,
'FOCOLTONE Colors -- 6030' => 0x410000 ,
'FOCOLTONE Colors -- 6031' => 0x004100 ,
'FOCOLTONE Colors -- 6032' => 0x000041 ,
'FOCOLTONE Colors -- 6033' => 0x464646 ,
'FOCOLTONE Colors -- 6034' => 0x464646 ,
'FOCOLTONE Colors -- 6035' => 0x460046 ,
'FOCOLTONE Colors -- 6036' => 0x464600 ,
'FOCOLTONE Colors -- 6037' => 0x004646 ,
'FOCOLTONE Colors -- 6038' => 0x460046 ,
'FOCOLTONE Colors -- 6039' => 0x464600 ,
'FOCOLTONE Colors -- 6040' => 0x004646 ,
'FOCOLTONE Colors -- 6041' => 0x460000 ,
'FOCOLTONE Colors -- 6042' => 0x004600 ,
'FOCOLTONE Colors -- 6043' => 0x000046 ,
'FOCOLTONE Colors -- 6044' => 0x4B4B4B ,
'FOCOLTONE Colors -- 6045' => 0x4B4B4B ,
'FOCOLTONE Colors -- 6046' => 0x4B004B ,
'FOCOLTONE Colors -- 6047' => 0x4B4B00 ,
'FOCOLTONE Colors -- 6048' => 0x004B4B ,
'FOCOLTONE Colors -- 6049' => 0x4B004B ,
'FOCOLTONE Colors -- 6050' => 0x4B4B00 ,
'FOCOLTONE Colors -- 6051' => 0x004B4B ,
'FOCOLTONE Colors -- 6052' => 0x4B0000 ,
'FOCOLTONE Colors -- 6053' => 0x004B00 ,
'FOCOLTONE Colors -- 6054' => 0x00004B ,
'FOCOLTONE Colors -- 6055' => 0x000000 ,
'FOCOLTONE Colors -- 6056' => 0x000000 ,
'FOCOLTONE Colors -- 6057' => 0x000000 ,
'FOCOLTONE Colors -- 6058' => 0x000000 ,
'FOCOLTONE Colors -- 6059' => 0x000000 ,
'FOCOLTONE Colors -- 7000' => 0x000064 ,
'FOCOLTONE Colors -- 7001' => 0x006400 ,
'FOCOLTONE Colors -- 7002' => 0x640000 ,
'FOCOLTONE Colors -- 7003' => 0x006464 ,
'FOCOLTONE Colors -- 7004' => 0x640064 ,
'FOCOLTONE Colors -- 7005' => 0x646400 ,
'FOCOLTONE Colors -- 7006' => 0x000064 ,
'FOCOLTONE Colors -- 7007' => 0x006400 ,
'FOCOLTONE Colors -- 7008' => 0x640000 ,
'FOCOLTONE Colors -- 7009' => 0x006464 ,
'FOCOLTONE Colors -- 7010' => 0x640064 ,
'FOCOLTONE Colors -- 7011' => 0x646400 ,
'FOCOLTONE Colors -- 7012' => 0x000064 ,
'FOCOLTONE Colors -- 7013' => 0x006400 ,
'FOCOLTONE Colors -- 7014' => 0x640000 ,
'FOCOLTONE Colors -- 7015' => 0x006464 ,
'FOCOLTONE Colors -- 7016' => 0x640064 ,
'FOCOLTONE Colors -- 7017' => 0x646400 ,
'FOCOLTONE Colors -- 7018' => 0x000064 ,
'FOCOLTONE Colors -- 7019' => 0x006400 ,
'FOCOLTONE Colors -- 7020' => 0x640000 ,
'FOCOLTONE Colors -- 7021' => 0x006464 ,
'FOCOLTONE Colors -- 7022' => 0x640064 ,
'FOCOLTONE Colors -- 7023' => 0x646400 ,
'FOCOLTONE Colors -- 7024' => 0x000064 ,
'FOCOLTONE Colors -- 7025' => 0x006400 ,
'FOCOLTONE Colors -- 7026' => 0x640000 ,
'FOCOLTONE Colors -- 7027' => 0x006464 ,
'FOCOLTONE Colors -- 7028' => 0x640064 ,
'FOCOLTONE Colors -- 7029' => 0x646400 ,
'FOCOLTONE Colors -- 7030' => 0x000064 ,
'FOCOLTONE Colors -- 7031' => 0x006400 ,
'FOCOLTONE Colors -- 7032' => 0x640000 ,
'FOCOLTONE Colors -- 7033' => 0x006464 ,
'FOCOLTONE Colors -- 7034' => 0x640064 ,
'FOCOLTONE Colors -- 7035' => 0x646400 ,
'FOCOLTONE Colors -- 7036' => 0x000064 ,
'FOCOLTONE Colors -- 7037' => 0x006400 ,
'FOCOLTONE Colors -- 7038' => 0x640000 ,
'FOCOLTONE Colors -- 7039' => 0x006464 ,
'FOCOLTONE Colors -- 7040' => 0x640064 ,
'FOCOLTONE Colors -- 7041' => 0x646400 ,
'FOCOLTONE Colors -- 7042' => 0x000064 ,
'FOCOLTONE Colors -- 7043' => 0x006400 ,
'FOCOLTONE Colors -- 7044' => 0x640000 ,
'FOCOLTONE Colors -- 7045' => 0x006464 ,
'FOCOLTONE Colors -- 7046' => 0x640064 ,
'FOCOLTONE Colors -- 7047' => 0x646400 ,
'FOCOLTONE Colors -- 7048' => 0x000064 ,
'FOCOLTONE Colors -- 7049' => 0x006400 ,
'FOCOLTONE Colors -- 7050' => 0x640000 ,
'FOCOLTONE Colors -- 7051' => 0x006464 ,
'FOCOLTONE Colors -- 7052' => 0x640064 ,
'FOCOLTONE Colors -- 7053' => 0x646400 ,
'FOCOLTONE Colors -- 7054' => 0x000064 ,
'FOCOLTONE Colors -- 7055' => 0x006400 ,
'FOCOLTONE Colors -- 7056' => 0x640000 ,
'FOCOLTONE Colors -- 7057' => 0x006464 ,
'FOCOLTONE Colors -- 7058' => 0x640064 ,
'FOCOLTONE Colors -- 7059' => 0x646400 ,
'FOCOLTONE Colors -- 7060' => 0x000064 ,
'FOCOLTONE Colors -- 7061' => 0x006400 ,
'FOCOLTONE Colors -- 7062' => 0x640000 ,
'FOCOLTONE Colors -- 7063' => 0x006464 ,
'FOCOLTONE Colors -- 7064' => 0x640064 ,
'FOCOLTONE Colors -- 7065' => 0x646400 ,
'FOCOLTONE Colors -- 7066' => 0x000064 ,
'FOCOLTONE Colors -- 7067' => 0x006400 ,
'FOCOLTONE Colors -- 7068' => 0x640000 ,
'FOCOLTONE Colors -- 7069' => 0x006464 ,
'FOCOLTONE Colors -- 7070' => 0x640064 ,
'FOCOLTONE Colors -- 7071' => 0x646400 ,
'TOYO COLOR FINDER -- 0001pc*' => 0x035A21 ,
'TOYO COLOR FINDER -- 0002pc*' => 0x006414 ,
'TOYO COLOR FINDER -- 0003pc*' => 0x006408 ,
'TOYO COLOR FINDER -- 0004pc' => 0x065423 ,
'TOYO COLOR FINDER -- 0005pc*' => 0x0F461E ,
'TOYO COLOR FINDER -- 0006pc*' => 0x004B05 ,
'TOYO COLOR FINDER -- 0007pc*' => 0x056411 ,
'TOYO COLOR FINDER -- 0008pc*' => 0x02640F ,
'TOYO COLOR FINDER -- 0009pc*' => 0x085A0D ,
'TOYO COLOR FINDER -- 0010pc*' => 0x025500 ,
'TOYO COLOR FINDER -- 0011pc*' => 0x035F02 ,
'TOYO COLOR FINDER -- 0012pc*' => 0x004600 ,
'TOYO COLOR FINDER -- 0013pc*' => 0x013C00 ,
'TOYO COLOR FINDER -- 0014pc*' => 0x023302 ,
'TOYO COLOR FINDER -- 0015pc*' => 0x002D03 ,
'TOYO COLOR FINDER -- 0016pc*' => 0x002A00 ,
'TOYO COLOR FINDER -- 0017pc*' => 0x001B00 ,
'TOYO COLOR FINDER -- 0018pc*' => 0x002900 ,
'TOYO COLOR FINDER -- 0019pc*' => 0x004400 ,
'TOYO COLOR FINDER -- 0020pc' => 0x076019 ,
'TOYO COLOR FINDER -- 0021pc' => 0x13602B ,
'TOYO COLOR FINDER -- 0022pc*' => 0x1D5F20 ,
'TOYO COLOR FINDER -- 0023pc*' => 0x036403 ,
'TOYO COLOR FINDER -- 0024pc*' => 0x035F02 ,
'TOYO COLOR FINDER -- 0025pc*' => 0x126405 ,
'TOYO COLOR FINDER -- 0026pc*' => 0x126405 ,
'TOYO COLOR FINDER -- 0027pc*' => 0x236416 ,
'TOYO COLOR FINDER -- 0028pc*' => 0x32621E ,
'TOYO COLOR FINDER -- 0029pc' => 0x0F5F0A ,
'TOYO COLOR FINDER -- 0030pc*' => 0x036400 ,
'TOYO COLOR FINDER -- 0031pc*' => 0x005500 ,
'TOYO COLOR FINDER -- 0032pc' => 0x115411 ,
'TOYO COLOR FINDER -- 0033pc' => 0x315D2A ,
'TOYO COLOR FINDER -- 0034pc*' => 0x1C6402 ,
'TOYO COLOR FINDER -- 0035pc*' => 0x32640A ,
'TOYO COLOR FINDER -- 0036pc*' => 0x266400 ,
'TOYO COLOR FINDER -- 0037pc' => 0x1E5523 ,
'TOYO COLOR FINDER -- 0038pc*' => 0x0A5800 ,
'TOYO COLOR FINDER -- 0039pc*' => 0x0B5D00 ,
'TOYO COLOR FINDER -- 0040pc*' => 0x064100 ,
'TOYO COLOR FINDER -- 0041pc*' => 0x0F4600 ,
'TOYO COLOR FINDER -- 0042pc' => 0x044900 ,
'TOYO COLOR FINDER -- 0043pc*' => 0x1C4B00 ,
'TOYO COLOR FINDER -- 0044pc*' => 0x2D5A00 ,
'TOYO COLOR FINDER -- 0045pc' => 0x356404 ,
'TOYO COLOR FINDER -- 0046pc*' => 0x376400 ,
'TOYO COLOR FINDER -- 0047pc' => 0x0A3C00 ,
'TOYO COLOR FINDER -- 0048pc*' => 0x002800 ,
'TOYO COLOR FINDER -- 0049pc*' => 0x0C2500 ,
'TOYO COLOR FINDER -- 0050pc*' => 0x072000 ,
'TOYO COLOR FINDER -- 0051pc*' => 0x0F2600 ,
'TOYO COLOR FINDER -- 0052pc' => 0x051802 ,
'TOYO COLOR FINDER -- 0053pc*' => 0x071E01 ,
'TOYO COLOR FINDER -- 0054pc*' => 0x0A1C01 ,
'TOYO COLOR FINDER -- 0055pc*' => 0x0F1E00 ,
'TOYO COLOR FINDER -- 0056pc*' => 0x1A2D00 ,
'TOYO COLOR FINDER -- 0057pc*' => 0x143200 ,
'TOYO COLOR FINDER -- 0058pc' => 0x0A4605 ,
'TOYO COLOR FINDER -- 0059pc*' => 0x1B3700 ,
'TOYO COLOR FINDER -- 0060pc*' => 0x1B3C00 ,
'TOYO COLOR FINDER -- 0061pc' => 0x235F00 ,
'TOYO COLOR FINDER -- 0062pc' => 0x195505 ,
'TOYO COLOR FINDER -- 0063pc*' => 0x3C6400 ,
'TOYO COLOR FINDER -- 0064pc*' => 0x416400 ,
'TOYO COLOR FINDER -- 0065pc*' => 0x3A5F05 ,
'TOYO COLOR FINDER -- 0066pc' => 0x325F0A ,
'TOYO COLOR FINDER -- 0067pc' => 0x3C640F ,
'TOYO COLOR FINDER -- 0068pc' => 0x3C5B11 ,
'TOYO COLOR FINDER -- 0069pc*' => 0x466400 ,
'TOYO COLOR FINDER -- 0070pc*' => 0x4B6400 ,
'TOYO COLOR FINDER -- 0071pc*' => 0x476400 ,
'TOYO COLOR FINDER -- 0072pc*' => 0x436400 ,
'TOYO COLOR FINDER -- 0073pc*' => 0x4A5F00 ,
'TOYO COLOR FINDER -- 0074pc*' => 0x233A00 ,
'TOYO COLOR FINDER -- 0075pc*' => 0x3E5A00 ,
'TOYO COLOR FINDER -- 0076pc*' => 0x415A00 ,
'TOYO COLOR FINDER -- 0077pc*' => 0x3E5500 ,
'TOYO COLOR FINDER -- 0078pc*' => 0x3E5000 ,
'TOYO COLOR FINDER -- 0079pc*' => 0x324600 ,
'TOYO COLOR FINDER -- 0080pc*' => 0x354600 ,
'TOYO COLOR FINDER -- 0081pc*' => 0x333C00 ,
'TOYO COLOR FINDER -- 0082pc*' => 0x263700 ,
'TOYO COLOR FINDER -- 0083pc*' => 0x233500 ,
'TOYO COLOR FINDER -- 0084pc*' => 0x1E2800 ,
'TOYO COLOR FINDER -- 0085pc*' => 0x434D00 ,
'TOYO COLOR FINDER -- 0086pc*' => 0x435000 ,
'TOYO COLOR FINDER -- 0087pc*' => 0x4B5500 ,
'TOYO COLOR FINDER -- 0088pc*' => 0x4B5800 ,
'TOYO COLOR FINDER -- 0089pc' => 0x46640A ,
'TOYO COLOR FINDER -- 0090pc' => 0x4B640F ,
'TOYO COLOR FINDER -- 0091pc' => 0x4B640A ,
'TOYO COLOR FINDER -- 0092pc' => 0x325514 ,
'TOYO COLOR FINDER -- 0093pc' => 0x415B0F ,
'TOYO COLOR FINDER -- 0094pc' => 0x4B641E ,
'TOYO COLOR FINDER -- 0095pc' => 0x465F19 ,
'TOYO COLOR FINDER -- 0096pc' => 0x556419 ,
'TOYO COLOR FINDER -- 0097pc' => 0x465F05 ,
'TOYO COLOR FINDER -- 0098pc*' => 0x576400 ,
'TOYO COLOR FINDER -- 0099pc*' => 0x576400 ,
'TOYO COLOR FINDER -- 0100pc*' => 0x525F00 ,
'TOYO COLOR FINDER -- 0101pc*' => 0x5A5F00 ,
'TOYO COLOR FINDER -- 0102pc*' => 0x555A00 ,
'TOYO COLOR FINDER -- 0103pc*' => 0x5A5800 ,
'TOYO COLOR FINDER -- 0104pc*' => 0x373B00 ,
'TOYO COLOR FINDER -- 0105pc*' => 0x353900 ,
'TOYO COLOR FINDER -- 0106pc*' => 0x414100 ,
'TOYO COLOR FINDER -- 0107pc*' => 0x413E00 ,
'TOYO COLOR FINDER -- 0108pc*' => 0x283100 ,
'TOYO COLOR FINDER -- 0109pc*' => 0x373400 ,
'TOYO COLOR FINDER -- 0110pc*' => 0x574600 ,
'TOYO COLOR FINDER -- 0111pc*' => 0x574900 ,
'TOYO COLOR FINDER -- 0112pc*' => 0x554600 ,
'TOYO COLOR FINDER -- 0113pc*' => 0x605000 ,
'TOYO COLOR FINDER -- 0114pc' => 0x485514 ,
'TOYO COLOR FINDER -- 0115pc' => 0x465F14 ,
'TOYO COLOR FINDER -- 0116pc' => 0x4F5515 ,
'TOYO COLOR FINDER -- 0117pc' => 0x465A00 ,
'TOYO COLOR FINDER -- 0118pc' => 0x4B5A05 ,
'TOYO COLOR FINDER -- 0119pc*' => 0x5A5202 ,
'TOYO COLOR FINDER -- 0120pc*' => 0x5F5000 ,
'TOYO COLOR FINDER -- 0121pc' => 0x555505 ,
'TOYO COLOR FINDER -- 0122pc*' => 0x645000 ,
'TOYO COLOR FINDER -- 0123pc' => 0x5F5A0F ,
'TOYO COLOR FINDER -- 0124pc' => 0x464B00 ,
'TOYO COLOR FINDER -- 0125pc*' => 0x644600 ,
'TOYO COLOR FINDER -- 0126pc*' => 0x5A3C00 ,
'TOYO COLOR FINDER -- 0127pc*' => 0x5A3A00 ,
'TOYO COLOR FINDER -- 0128pc*' => 0x644500 ,
'TOYO COLOR FINDER -- 0129pc*' => 0x4B3A00 ,
'TOYO COLOR FINDER -- 0130pc*' => 0x4B3700 ,
'TOYO COLOR FINDER -- 0131pc*' => 0x3E3100 ,
'TOYO COLOR FINDER -- 0132pc*' => 0x413300 ,
'TOYO COLOR FINDER -- 0133pc*' => 0x1B1B03 ,
'TOYO COLOR FINDER -- 0134pc*' => 0x1E2100 ,
'TOYO COLOR FINDER -- 0135pc*' => 0x211600 ,
'TOYO COLOR FINDER -- 0136pc*' => 0x2B2900 ,
'TOYO COLOR FINDER -- 0137pc*' => 0x2E2300 ,
'TOYO COLOR FINDER -- 0138pc*' => 0x272000 ,
'TOYO COLOR FINDER -- 0139pc*' => 0x473700 ,
'TOYO COLOR FINDER -- 0140pc' => 0x5F550A ,
'TOYO COLOR FINDER -- 0141pc' => 0x3C3700 ,
'TOYO COLOR FINDER -- 0142pc*' => 0x503F00 ,
'TOYO COLOR FINDER -- 0143pc*' => 0x583E00 ,
'TOYO COLOR FINDER -- 0144pc*' => 0x5F3F00 ,
'TOYO COLOR FINDER -- 0145pc*' => 0x5F3300 ,
'TOYO COLOR FINDER -- 0146pc*' => 0x5A3500 ,
'TOYO COLOR FINDER -- 0147pc*' => 0x623500 ,
'TOYO COLOR FINDER -- 0148pc*' => 0x643400 ,
'TOYO COLOR FINDER -- 0149pc*' => 0x461E00 ,
'TOYO COLOR FINDER -- 0150pc*' => 0x412600 ,
'TOYO COLOR FINDER -- 0151pc*' => 0x3E1E00 ,
'TOYO COLOR FINDER -- 0152pc' => 0x463700 ,
'TOYO COLOR FINDER -- 0153pc*' => 0x623F00 ,
'TOYO COLOR FINDER -- 0154pc*' => 0x643E00 ,
'TOYO COLOR FINDER -- 0155pc*' => 0x5A3A00 ,
'TOYO COLOR FINDER -- 0156pc' => 0x5A4605 ,
'TOYO COLOR FINDER -- 0157pc' => 0x5F410F ,
'TOYO COLOR FINDER -- 0158pc' => 0x504105 ,
'TOYO COLOR FINDER -- 0159pc' => 0x5F3205 ,
'TOYO COLOR FINDER -- 0160pc' => 0x553200 ,
'TOYO COLOR FINDER -- 0161pc*' => 0x602E00 ,
'TOYO COLOR FINDER -- 0162pc*' => 0x642100 ,
'TOYO COLOR FINDER -- 0163pc*' => 0x642300 ,
'TOYO COLOR FINDER -- 0164pc*' => 0x641E00 ,
'TOYO COLOR FINDER -- 0165pc*' => 0x642D00 ,
'TOYO COLOR FINDER -- 0166pc' => 0x553C19 ,
'TOYO COLOR FINDER -- 0167pc' => 0x554119 ,
'TOYO COLOR FINDER -- 0168pc*' => 0x3A2500 ,
'TOYO COLOR FINDER -- 0169pc*' => 0x3A1E00 ,
'TOYO COLOR FINDER -- 0170pc*' => 0x411C00 ,
'TOYO COLOR FINDER -- 0171pc*' => 0x3C1E00 ,
'TOYO COLOR FINDER -- 0172pc*' => 0x371C00 ,
'TOYO COLOR FINDER -- 0173pc*' => 0x371C00 ,
'TOYO COLOR FINDER -- 0174pc*' => 0x411F01 ,
'TOYO COLOR FINDER -- 0175pc*' => 0x461900 ,
'TOYO COLOR FINDER -- 0176pc*' => 0x3A1200 ,
'TOYO COLOR FINDER -- 0177pc*' => 0x642400 ,
'TOYO COLOR FINDER -- 0178pc*' => 0x642200 ,
'TOYO COLOR FINDER -- 0179pc' => 0x5F2300 ,
'TOYO COLOR FINDER -- 0180pc*' => 0x642200 ,
'TOYO COLOR FINDER -- 0181pc' => 0x642D0F ,
'TOYO COLOR FINDER -- 0182pc' => 0x611E08 ,
'TOYO COLOR FINDER -- 0183pc*' => 0x5F1600 ,
'TOYO COLOR FINDER -- 0184pc*' => 0x480F01 ,
'TOYO COLOR FINDER -- 0185pc' => 0x280400 ,
'TOYO COLOR FINDER -- 0186pc' => 0x360600 ,
'TOYO COLOR FINDER -- 0187pc*' => 0x641700 ,
'TOYO COLOR FINDER -- 0188pc*' => 0x641400 ,
'TOYO COLOR FINDER -- 0189pc*' => 0x641000 ,
'TOYO COLOR FINDER -- 0190pc*' => 0x551000 ,
'TOYO COLOR FINDER -- 0191pc*' => 0x5C0F00 ,
'TOYO COLOR FINDER -- 0192pc*' => 0x640A00 ,
'TOYO COLOR FINDER -- 0193pc' => 0x5F150B ,
'TOYO COLOR FINDER -- 0194pc' => 0x610F0C ,
'TOYO COLOR FINDER -- 0195pc' => 0x5A2D14 ,
'TOYO COLOR FINDER -- 0196pc' => 0x632222 ,
'TOYO COLOR FINDER -- 0197pc' => 0x632A2A ,
'TOYO COLOR FINDER -- 0198pc' => 0x501E15 ,
'TOYO COLOR FINDER -- 0199pc' => 0x470600 ,
'TOYO COLOR FINDER -- 0200pc*' => 0x640400 ,
'TOYO COLOR FINDER -- 0201pc*' => 0x640101 ,
'TOYO COLOR FINDER -- 0202pc' => 0x5A0500 ,
'TOYO COLOR FINDER -- 0203pc*' => 0x5A0002 ,
'TOYO COLOR FINDER -- 0204pc' => 0x430100 ,
'TOYO COLOR FINDER -- 0205pc' => 0x360500 ,
'TOYO COLOR FINDER -- 0206pc' => 0x4C0300 ,
'TOYO COLOR FINDER -- 0207pc*' => 0x470002 ,
'TOYO COLOR FINDER -- 0208pc*' => 0x4E0402 ,
'TOYO COLOR FINDER -- 0209pc*' => 0x3E0204 ,
'TOYO COLOR FINDER -- 0210pc*' => 0x1E0202 ,
'TOYO COLOR FINDER -- 0211pc' => 0x2D0000 ,
'TOYO COLOR FINDER -- 0212pc*' => 0x450007 ,
'TOYO COLOR FINDER -- 0213pc' => 0x3C0006 ,
'TOYO COLOR FINDER -- 0214pc*' => 0x630105 ,
'TOYO COLOR FINDER -- 0215pc' => 0x560A11 ,
'TOYO COLOR FINDER -- 0216pc*' => 0x640E17 ,
'TOYO COLOR FINDER -- 0217pc' => 0x641B28 ,
'TOYO COLOR FINDER -- 0218pc' => 0x641528 ,
'TOYO COLOR FINDER -- 0219pc' => 0x642036 ,
'TOYO COLOR FINDER -- 0220pc' => 0x640623 ,
'TOYO COLOR FINDER -- 0221pc*' => 0x5F0016 ,
'TOYO COLOR FINDER -- 0222pc*' => 0x64001C ,
'TOYO COLOR FINDER -- 0223pc*' => 0x620018 ,
'TOYO COLOR FINDER -- 0224pc*' => 0x5F0011 ,
'TOYO COLOR FINDER -- 0225pc*' => 0x5C000F ,
'TOYO COLOR FINDER -- 0226pc*' => 0x5C0211 ,
'TOYO COLOR FINDER -- 0227pc*' => 0x5A020A ,
'TOYO COLOR FINDER -- 0228pc*' => 0x4E0014 ,
'TOYO COLOR FINDER -- 0229pc*' => 0x37020F ,
'TOYO COLOR FINDER -- 0230pc*' => 0x4E000F ,
'TOYO COLOR FINDER -- 0231pc*' => 0x440012 ,
'TOYO COLOR FINDER -- 0232pc*' => 0x520021 ,
'TOYO COLOR FINDER -- 0233pc' => 0x5B002C ,
'TOYO COLOR FINDER -- 0234pc' => 0x610D38 ,
'TOYO COLOR FINDER -- 0235pc' => 0x4B032F ,
'TOYO COLOR FINDER -- 0236pc' => 0x47041F ,
'TOYO COLOR FINDER -- 0237pc*' => 0x550114 ,
'TOYO COLOR FINDER -- 0238pc*' => 0x550019 ,
'TOYO COLOR FINDER -- 0239pc*' => 0x370019 ,
'TOYO COLOR FINDER -- 0240pc*' => 0x3E001C ,
'TOYO COLOR FINDER -- 0241pc*' => 0x46001C ,
'TOYO COLOR FINDER -- 0242pc*' => 0x46001E ,
'TOYO COLOR FINDER -- 0243pc*' => 0x460020 ,
'TOYO COLOR FINDER -- 0244pc*' => 0x600028 ,
'TOYO COLOR FINDER -- 0245pc*' => 0x60002B ,
'TOYO COLOR FINDER -- 0246pc*' => 0x60002F ,
'TOYO COLOR FINDER -- 0247pc' => 0x560640 ,
'TOYO COLOR FINDER -- 0248pc*' => 0x550026 ,
'TOYO COLOR FINDER -- 0249pc*' => 0x410029 ,
'TOYO COLOR FINDER -- 0250pc*' => 0x3C0026 ,
'TOYO COLOR FINDER -- 0251pc*' => 0x410020 ,
'TOYO COLOR FINDER -- 0252pc*' => 0x3C0028 ,
'TOYO COLOR FINDER -- 0253pc' => 0x490033 ,
'TOYO COLOR FINDER -- 0254pc' => 0x511246 ,
'TOYO COLOR FINDER -- 0255pc' => 0x551145 ,
'TOYO COLOR FINDER -- 0256pc' => 0x620049 ,
'TOYO COLOR FINDER -- 0257pc' => 0x5B004E ,
'TOYO COLOR FINDER -- 0258pc*' => 0x5A002F ,
'TOYO COLOR FINDER -- 0259pc*' => 0x5A0031 ,
'TOYO COLOR FINDER -- 0260pc*' => 0x5A0039 ,
'TOYO COLOR FINDER -- 0261pc*' => 0x5D003C ,
'TOYO COLOR FINDER -- 0262pc' => 0x561554 ,
'TOYO COLOR FINDER -- 0263pc' => 0x4C1954 ,
'TOYO COLOR FINDER -- 0264pc' => 0x580F5A ,
'TOYO COLOR FINDER -- 0265pc' => 0x560559 ,
'TOYO COLOR FINDER -- 0266pc*' => 0x5A0056 ,
'TOYO COLOR FINDER -- 0267pc' => 0x47064B ,
'TOYO COLOR FINDER -- 0268pc*' => 0x46003A ,
'TOYO COLOR FINDER -- 0269pc*' => 0x320030 ,
'TOYO COLOR FINDER -- 0270pc*' => 0x370032 ,
'TOYO COLOR FINDER -- 0271pc*' => 0x370132 ,
'TOYO COLOR FINDER -- 0272pc*' => 0x520049 ,
'TOYO COLOR FINDER -- 0273pc*' => 0x530050 ,
'TOYO COLOR FINDER -- 0274pc*' => 0x550054 ,
'TOYO COLOR FINDER -- 0275pc' => 0x57145F ,
'TOYO COLOR FINDER -- 0276pc' => 0x3F0F4B ,
'TOYO COLOR FINDER -- 0277pc*' => 0x490246 ,
'TOYO COLOR FINDER -- 0278pc*' => 0x340033 ,
'TOYO COLOR FINDER -- 0279pc*' => 0x260021 ,
'TOYO COLOR FINDER -- 0280pc*' => 0x580050 ,
'TOYO COLOR FINDER -- 0281pc*' => 0x5A0058 ,
'TOYO COLOR FINDER -- 0282pc*' => 0x5F005C ,
'TOYO COLOR FINDER -- 0283pc' => 0x4B1155 ,
'TOYO COLOR FINDER -- 0284pc' => 0x540264 ,
'TOYO COLOR FINDER -- 0285pc*' => 0x55005F ,
'TOYO COLOR FINDER -- 0286pc' => 0x551F64 ,
'TOYO COLOR FINDER -- 0287pc' => 0x4F2064 ,
'TOYO COLOR FINDER -- 0288pc*' => 0x46003F ,
'TOYO COLOR FINDER -- 0289pc*' => 0x32003C ,
'TOYO COLOR FINDER -- 0290pc*' => 0x320346 ,
'TOYO COLOR FINDER -- 0291pc*' => 0x440047 ,
'TOYO COLOR FINDER -- 0292pc*' => 0x460349 ,
'TOYO COLOR FINDER -- 0293pc*' => 0x46034B ,
'TOYO COLOR FINDER -- 0294pc' => 0x4F1A64 ,
'TOYO COLOR FINDER -- 0295pc*' => 0x4D0354 ,
'TOYO COLOR FINDER -- 0296pc' => 0x430060 ,
'TOYO COLOR FINDER -- 0297pc*' => 0x40005A ,
'TOYO COLOR FINDER -- 0298pc' => 0x460F64 ,
'TOYO COLOR FINDER -- 0299pc' => 0x461E64 ,
'TOYO COLOR FINDER -- 0300pc' => 0x410064 ,
'TOYO COLOR FINDER -- 0301pc*' => 0x3A0250 ,
'TOYO COLOR FINDER -- 0302pc*' => 0x3A024B ,
'TOYO COLOR FINDER -- 0303pc*' => 0x3A024D ,
'TOYO COLOR FINDER -- 0304pc*' => 0x260028 ,
'TOYO COLOR FINDER -- 0305pc*' => 0x1E0027 ,
'TOYO COLOR FINDER -- 0306pc*' => 0x1C0022 ,
'TOYO COLOR FINDER -- 0307pc*' => 0x200032 ,
'TOYO COLOR FINDER -- 0308pc*' => 0x3F045A ,
'TOYO COLOR FINDER -- 0309pc*' => 0x3F045A ,
'TOYO COLOR FINDER -- 0310pc*' => 0x37025C ,
'TOYO COLOR FINDER -- 0311pc' => 0x350557 ,
'TOYO COLOR FINDER -- 0312pc' => 0x330A4F ,
'TOYO COLOR FINDER -- 0313pc*' => 0x340052 ,
'TOYO COLOR FINDER -- 0314pc*' => 0x0F001C ,
'TOYO COLOR FINDER -- 0315pc*' => 0x1B0028 ,
'TOYO COLOR FINDER -- 0316pc*' => 0x220035 ,
'TOYO COLOR FINDER -- 0317pc*' => 0x280037 ,
'TOYO COLOR FINDER -- 0318pc*' => 0x340057 ,
'TOYO COLOR FINDER -- 0319pc' => 0x370F5F ,
'TOYO COLOR FINDER -- 0320pc' => 0x330D5C ,
'TOYO COLOR FINDER -- 0321pc' => 0x452364 ,
'TOYO COLOR FINDER -- 0322pc' => 0x463C64 ,
'TOYO COLOR FINDER -- 0323pc*' => 0x471E5A ,
'TOYO COLOR FINDER -- 0324pc' => 0x3C0264 ,
'TOYO COLOR FINDER -- 0325pc*' => 0x380050 ,
'TOYO COLOR FINDER -- 0326pc*' => 0x32005A ,
'TOYO COLOR FINDER -- 0327pc*' => 0x200044 ,
'TOYO COLOR FINDER -- 0328pc*' => 0x230049 ,
'TOYO COLOR FINDER -- 0329pc*' => 0x33005F ,
'TOYO COLOR FINDER -- 0330pc*' => 0x441462 ,
'TOYO COLOR FINDER -- 0331pc*' => 0x320062 ,
'TOYO COLOR FINDER -- 0332pc*' => 0x350064 ,
'TOYO COLOR FINDER -- 0333pc' => 0x32145F ,
'TOYO COLOR FINDER -- 0334pc*' => 0x330064 ,
'TOYO COLOR FINDER -- 0335pc' => 0x341464 ,
'TOYO COLOR FINDER -- 0336pc' => 0x280D63 ,
'TOYO COLOR FINDER -- 0337pc*' => 0x2D0064 ,
'TOYO COLOR FINDER -- 0338pc*' => 0x2F0062 ,
'TOYO COLOR FINDER -- 0339pc*' => 0x16003E ,
'TOYO COLOR FINDER -- 0340pc*' => 0x160037 ,
'TOYO COLOR FINDER -- 0341pc*' => 0x0E031C ,
'TOYO COLOR FINDER -- 0342pc*' => 0x14002A ,
'TOYO COLOR FINDER -- 0343pc*' => 0x14003A ,
'TOYO COLOR FINDER -- 0344pc*' => 0x190046 ,
'TOYO COLOR FINDER -- 0345pc*' => 0x200046 ,
'TOYO COLOR FINDER -- 0346pc*' => 0x17003A ,
'TOYO COLOR FINDER -- 0347pc*' => 0x230058 ,
'TOYO COLOR FINDER -- 0348pc*' => 0x270064 ,
'TOYO COLOR FINDER -- 0349pc*' => 0x1E005A ,
'TOYO COLOR FINDER -- 0350pc*' => 0x20005F ,
'TOYO COLOR FINDER -- 0351pc' => 0x282364 ,
'TOYO COLOR FINDER -- 0352pc*' => 0x2D1464 ,
'TOYO COLOR FINDER -- 0353pc*' => 0x250764 ,
'TOYO COLOR FINDER -- 0354pc' => 0x190563 ,
'TOYO COLOR FINDER -- 0355pc' => 0x282163 ,
'TOYO COLOR FINDER -- 0356pc' => 0x232364 ,
'TOYO COLOR FINDER -- 0357pc*' => 0x110564 ,
'TOYO COLOR FINDER -- 0358pc' => 0x1E0F5F ,
'TOYO COLOR FINDER -- 0359pc*' => 0x120050 ,
'TOYO COLOR FINDER -- 0360pc*' => 0x0E003A ,
'TOYO COLOR FINDER -- 0361pc*' => 0x070036 ,
'TOYO COLOR FINDER -- 0362pc*' => 0x0A0061 ,
'TOYO COLOR FINDER -- 0363pc' => 0x140064 ,
'TOYO COLOR FINDER -- 0364pc*' => 0x120064 ,
'TOYO COLOR FINDER -- 0365pc*' => 0x150764 ,
'TOYO COLOR FINDER -- 0366pc*' => 0x232361 ,
'TOYO COLOR FINDER -- 0367pc*' => 0x0F0061 ,
'TOYO COLOR FINDER -- 0368pc*' => 0x0D0050 ,
'TOYO COLOR FINDER -- 0369pc*' => 0x080128 ,
'TOYO COLOR FINDER -- 0370pc*' => 0x080125 ,
'TOYO COLOR FINDER -- 0371pc' => 0x0F0550 ,
'TOYO COLOR FINDER -- 0372pc' => 0x0F145F ,
'TOYO COLOR FINDER -- 0373pc' => 0x141460 ,
'TOYO COLOR FINDER -- 0374pc*' => 0x0E0264 ,
'TOYO COLOR FINDER -- 0375pc' => 0x0A0564 ,
'TOYO COLOR FINDER -- 0376pc' => 0x050563 ,
'TOYO COLOR FINDER -- 0377pc*' => 0x0F1064 ,
'TOYO COLOR FINDER -- 0378pc' => 0x0E1664 ,
'TOYO COLOR FINDER -- 0379pc*' => 0x103664 ,
'TOYO COLOR FINDER -- 0380pc*' => 0x0A1464 ,
'TOYO COLOR FINDER -- 0381pc*' => 0x0A1164 ,
'TOYO COLOR FINDER -- 0382pc*' => 0x020D64 ,
'TOYO COLOR FINDER -- 0383pc*' => 0x060264 ,
'TOYO COLOR FINDER -- 0384pc*' => 0x050362 ,
'TOYO COLOR FINDER -- 0385pc*' => 0x030044 ,
'TOYO COLOR FINDER -- 0386pc' => 0x0A003C ,
'TOYO COLOR FINDER -- 0387pc*' => 0x08001F ,
'TOYO COLOR FINDER -- 0388pc*' => 0x08002D ,
'TOYO COLOR FINDER -- 0389pc*' => 0x080050 ,
'TOYO COLOR FINDER -- 0390pc' => 0x000050 ,
'TOYO COLOR FINDER -- 0391pc' => 0x0A145A ,
'TOYO COLOR FINDER -- 0392pc*' => 0x050041 ,
'TOYO COLOR FINDER -- 0393pc*' => 0x04003A ,
'TOYO COLOR FINDER -- 0394pc*' => 0x050025 ,
'TOYO COLOR FINDER -- 0395pc' => 0x00003C ,
'TOYO COLOR FINDER -- 0396pc' => 0x00053C ,
'TOYO COLOR FINDER -- 0397pc' => 0x020532 ,
'TOYO COLOR FINDER -- 0398pc' => 0x00001E ,
'TOYO COLOR FINDER -- 0399pc' => 0x000F50 ,
'TOYO COLOR FINDER -- 0400pc' => 0x021163 ,
'TOYO COLOR FINDER -- 0401pc' => 0x102D5E ,
'TOYO COLOR FINDER -- 0402pc' => 0x15335A ,
'TOYO COLOR FINDER -- 0403pc*' => 0x011A5F ,
'TOYO COLOR FINDER -- 0404pc*' => 0x001964 ,
'TOYO COLOR FINDER -- 0405pc*' => 0x052A5F ,
'TOYO COLOR FINDER -- 0406pc*' => 0x053264 ,
'TOYO COLOR FINDER -- 0407pc' => 0x042E64 ,
'TOYO COLOR FINDER -- 0408pc' => 0x053964 ,
'TOYO COLOR FINDER -- 0409pc' => 0x0D3A62 ,
'TOYO COLOR FINDER -- 0410pc' => 0x001E5A ,
'TOYO COLOR FINDER -- 0411pc*' => 0x000D58 ,
'TOYO COLOR FINDER -- 0412pc*' => 0x022B5F ,
'TOYO COLOR FINDER -- 0413pc*' => 0x003E5F ,
'TOYO COLOR FINDER -- 0414pc*' => 0x053564 ,
'TOYO COLOR FINDER -- 0415pc*' => 0x011E5A ,
'TOYO COLOR FINDER -- 0416pc*' => 0x02365A ,
'TOYO COLOR FINDER -- 0417pc*' => 0x053A5A ,
'TOYO COLOR FINDER -- 0418pc*' => 0x053964 ,
'TOYO COLOR FINDER -- 0419pc*' => 0x052450 ,
'TOYO COLOR FINDER -- 0420pc' => 0x001441 ,
'TOYO COLOR FINDER -- 0421pc' => 0x000A3A ,
'TOYO COLOR FINDER -- 0422pc' => 0x000931 ,
'TOYO COLOR FINDER -- 0423pc' => 0x010526 ,
'TOYO COLOR FINDER -- 0424pc' => 0x000C32 ,
'TOYO COLOR FINDER -- 0425pc' => 0x000C31 ,
'TOYO COLOR FINDER -- 0426pc' => 0x010C2D ,
'TOYO COLOR FINDER -- 0427pc*' => 0x052846 ,
'TOYO COLOR FINDER -- 0428pc*' => 0x052B49 ,
'TOYO COLOR FINDER -- 0429pc' => 0x093759 ,
'TOYO COLOR FINDER -- 0430pc' => 0x0C2246 ,
'TOYO COLOR FINDER -- 0431pc' => 0x00325F ,
'TOYO COLOR FINDER -- 0432pc*' => 0x074064 ,
'TOYO COLOR FINDER -- 0433pc*' => 0x053C5F ,
'TOYO COLOR FINDER -- 0434pc*' => 0x023A5F ,
'TOYO COLOR FINDER -- 0435pc*' => 0x023E5F ,
'TOYO COLOR FINDER -- 0436pc*' => 0x022150 ,
'TOYO COLOR FINDER -- 0437pc*' => 0x011741 ,
'TOYO COLOR FINDER -- 0438pc' => 0x00102D ,
'TOYO COLOR FINDER -- 0439pc*' => 0x051E37 ,
'TOYO COLOR FINDER -- 0440pc*' => 0x052D46 ,
'TOYO COLOR FINDER -- 0441pc*' => 0x053E5F ,
'TOYO COLOR FINDER -- 0442pc*' => 0x02385F ,
'TOYO COLOR FINDER -- 0443pc*' => 0x023857 ,
'TOYO COLOR FINDER -- 0444pc*' => 0x023444 ,
'TOYO COLOR FINDER -- 0445pc*' => 0x052E41 ,
'TOYO COLOR FINDER -- 0446pc*' => 0x031E3C ,
'TOYO COLOR FINDER -- 0447pc*' => 0x032D41 ,
'TOYO COLOR FINDER -- 0448pc*' => 0x013E50 ,
'TOYO COLOR FINDER -- 0449pc*' => 0x024B54 ,
'TOYO COLOR FINDER -- 0450pc*' => 0x024E54 ,
'TOYO COLOR FINDER -- 0451pc' => 0x013E54 ,
'TOYO COLOR FINDER -- 0452pc*' => 0x032D3C ,
'TOYO COLOR FINDER -- 0453pc*' => 0x03323A ,
'TOYO COLOR FINDER -- 0454pc' => 0x021A2A ,
'TOYO COLOR FINDER -- 0455pc' => 0x001623 ,
'TOYO COLOR FINDER -- 0456pc' => 0x00232D ,
'TOYO COLOR FINDER -- 0457pc*' => 0x033234 ,
'TOYO COLOR FINDER -- 0458pc*' => 0x033C34 ,
'TOYO COLOR FINDER -- 0459pc*' => 0x025555 ,
'TOYO COLOR FINDER -- 0460pc*' => 0x025558 ,
'TOYO COLOR FINDER -- 0461pc' => 0x005F5E ,
'TOYO COLOR FINDER -- 0462pc*' => 0x055757 ,
'TOYO COLOR FINDER -- 0463pc*' => 0x025755 ,
'TOYO COLOR FINDER -- 0464pc*' => 0x033930 ,
'TOYO COLOR FINDER -- 0465pc*' => 0x052725 ,
'TOYO COLOR FINDER -- 0466pc*' => 0x0A231E ,
'TOYO COLOR FINDER -- 0467pc*' => 0x0A352B ,
'TOYO COLOR FINDER -- 0468pc*' => 0x0A382D ,
'TOYO COLOR FINDER -- 0469pc' => 0x003538 ,
'TOYO COLOR FINDER -- 0470pc' => 0x094346 ,
'TOYO COLOR FINDER -- 0471pc' => 0x0F4144 ,
'TOYO COLOR FINDER -- 0472pc*' => 0x052825 ,
'TOYO COLOR FINDER -- 0473pc*' => 0x031610 ,
'TOYO COLOR FINDER -- 0474pc*' => 0x02241E ,
'TOYO COLOR FINDER -- 0475pc*' => 0x053028 ,
'TOYO COLOR FINDER -- 0476pc*' => 0x04504E ,
'TOYO COLOR FINDER -- 0477pc*' => 0x055C4B ,
'TOYO COLOR FINDER -- 0478pc' => 0x0C5550 ,
'TOYO COLOR FINDER -- 0479pc' => 0x0A544B ,
'TOYO COLOR FINDER -- 0480pc*' => 0x0A5244 ,
'TOYO COLOR FINDER -- 0481pc*' => 0x0A4B3E ,
'TOYO COLOR FINDER -- 0482pc*' => 0x03321E ,
'TOYO COLOR FINDER -- 0483pc*' => 0x083223 ,
'TOYO COLOR FINDER -- 0484pc*' => 0x01190B ,
'TOYO COLOR FINDER -- 0485pc*' => 0x01170B ,
'TOYO COLOR FINDER -- 0486pc*' => 0x02301E ,
'TOYO COLOR FINDER -- 0487pc*' => 0x022E1E ,
'TOYO COLOR FINDER -- 0488pc' => 0x03342D ,
'TOYO COLOR FINDER -- 0489pc*' => 0x083728 ,
'TOYO COLOR FINDER -- 0490pc*' => 0x05563F ,
'TOYO COLOR FINDER -- 0491pc*' => 0x0A5544 ,
'TOYO COLOR FINDER -- 0492pc*' => 0x035F3E ,
'TOYO COLOR FINDER -- 0493pc*' => 0x054B3A ,
'TOYO COLOR FINDER -- 0494pc*' => 0x056341 ,
'TOYO COLOR FINDER -- 0495pc*' => 0x07643C ,
'TOYO COLOR FINDER -- 0496pc' => 0x00553B ,
'TOYO COLOR FINDER -- 0497pc*' => 0x034D3C ,
'TOYO COLOR FINDER -- 0498pc' => 0x003E2C ,
'TOYO COLOR FINDER -- 0499pc*' => 0x02351E ,
'TOYO COLOR FINDER -- 0500pc*' => 0x113E26 ,
'TOYO COLOR FINDER -- 0501pc*' => 0x023205 ,
'TOYO COLOR FINDER -- 0502pc*' => 0x012D05 ,
'TOYO COLOR FINDER -- 0503pc*' => 0x012505 ,
'TOYO COLOR FINDER -- 0504pc*' => 0x011E09 ,
'TOYO COLOR FINDER -- 0505pc*' => 0x002500 ,
'TOYO COLOR FINDER -- 0506pc*' => 0x002B00 ,
'TOYO COLOR FINDER -- 0507pc*' => 0x003700 ,
'TOYO COLOR FINDER -- 0508pc*' => 0x00521E ,
'TOYO COLOR FINDER -- 0509pc*' => 0x03641A ,
'TOYO COLOR FINDER -- 0510pc*' => 0x036418 ,
'TOYO COLOR FINDER -- 0511pc*' => 0x055A37 ,
'TOYO COLOR FINDER -- 0512pc*' => 0x035326 ,
'TOYO COLOR FINDER -- 0513pc*' => 0x006416 ,
'TOYO COLOR FINDER -- 0514pc*' => 0x036423 ,
'TOYO COLOR FINDER -- 0515pc' => 0x005528 ,
'TOYO COLOR FINDER -- 0516pc' => 0x005120 ,
'TOYO COLOR FINDER -- 0517pc*' => 0x005000 ,
'TOYO COLOR FINDER -- 0518pc*' => 0x004600 ,
'TOYO COLOR FINDER -- 0519pc*' => 0x024600 ,
'TOYO COLOR FINDER -- 0520pc*' => 0x1E4600 ,
'TOYO COLOR FINDER -- 0521pc*' => 0x393002 ,
'TOYO COLOR FINDER -- 0522pc*' => 0x412A00 ,
'TOYO COLOR FINDER -- 0523pc*' => 0x411B00 ,
'TOYO COLOR FINDER -- 0524pc*' => 0x4D000C ,
'TOYO COLOR FINDER -- 0525pc*' => 0x550037 ,
'TOYO COLOR FINDER -- 0526pc*' => 0x000061 ,
'TOYO COLOR FINDER -- 0527pc' => 0x28321E ,
'TOYO COLOR FINDER -- 0528pc' => 0x14230A ,
'TOYO COLOR FINDER -- 0529pc' => 0x1E3109 ,
'TOYO COLOR FINDER -- 0530pc' => 0x1E3700 ,
'TOYO COLOR FINDER -- 0531pc*' => 0x3D3A00 ,
'TOYO COLOR FINDER -- 0532pc*' => 0x393302 ,
'TOYO COLOR FINDER -- 0533pc' => 0x282800 ,
'TOYO COLOR FINDER -- 0534pc*' => 0x2C2D02 ,
'TOYO COLOR FINDER -- 0535pc' => 0x333011 ,
'TOYO COLOR FINDER -- 0536pc' => 0x25310F ,
'TOYO COLOR FINDER -- 0537pc' => 0x0A170A ,
'TOYO COLOR FINDER -- 0538pc' => 0x312B0F ,
'TOYO COLOR FINDER -- 0539pc' => 0x322503 ,
'TOYO COLOR FINDER -- 0540pc' => 0x342807 ,
'TOYO COLOR FINDER -- 0541pc' => 0x232001 ,
'TOYO COLOR FINDER -- 0542pc' => 0x382B0B ,
'TOYO COLOR FINDER -- 0543pc' => 0x332211 ,
'TOYO COLOR FINDER -- 0544pc' => 0x373C0F ,
'TOYO COLOR FINDER -- 0545pc' => 0x363D3A ,
'TOYO COLOR FINDER -- 0546pc' => 0x363934 ,
'TOYO COLOR FINDER -- 0547pc' => 0x313228 ,
'TOYO COLOR FINDER -- 0548pc' => 0x232520 ,
'TOYO COLOR FINDER -- 0549pc' => 0x1A1B1E ,
'TOYO COLOR FINDER -- 0550pc' => 0x16160E ,
'TOYO COLOR FINDER -- 0551pc' => 0x1A1516 ,
'TOYO COLOR FINDER -- 0552pc' => 0x0E0F08 ,
'TOYO COLOR FINDER -- 0553pc' => 0x0B0D07 ,
'TOYO COLOR FINDER -- 0554pc' => 0x0A0A04 ,
'TOYO COLOR FINDER -- 0555pc' => 0x050F00 ,
'TOYO COLOR FINDER -- 0556pc*' => 0x0B1200 ,
'TOYO COLOR FINDER -- 0557pc' => 0x070F00 ,
'TOYO COLOR FINDER -- 0558pc' => 0x070D00 ,
'TOYO COLOR FINDER -- 0559pc' => 0x0F0D00 ,
'TOYO COLOR FINDER -- 0560pc' => 0x111205 ,
'TOYO COLOR FINDER -- 0561pc' => 0x0A0803 ,
'TOYO COLOR FINDER -- 0562pc' => 0x0A0801 ,
'TOYO COLOR FINDER -- 0563pc' => 0x0B0700 ,
'TOYO COLOR FINDER -- 0564pc' => 0x140F03 ,
'TOYO COLOR FINDER -- 0565pc' => 0x100C00 ,
'TOYO COLOR FINDER -- 0566pc' => 0x150C00 ,
'TOYO COLOR FINDER -- 0567pc*' => 0x1A0B03 ,
'TOYO COLOR FINDER -- 0568pc' => 0x0F0500 ,
'TOYO COLOR FINDER -- 0569pc' => 0x1D1300 ,
'TOYO COLOR FINDER -- 0570pc' => 0x1C1500 ,
'TOYO COLOR FINDER -- 0571pc' => 0x1D1902 ,
'TOYO COLOR FINDER -- 0572pc' => 0x181509 ,
'TOYO COLOR FINDER -- 0573pc' => 0x1E0F00 ,
'TOYO COLOR FINDER -- 0574pc' => 0x190F00 ,
'TOYO COLOR FINDER -- 0575pc' => 0x28170B ,
'TOYO COLOR FINDER -- 0576pc' => 0x191408 ,
'TOYO COLOR FINDER -- 0577pc' => 0x150F05 ,
'TOYO COLOR FINDER -- 0578pc' => 0x19190F ,
'TOYO COLOR FINDER -- 0579pc' => 0x1C170A ,
'TOYO COLOR FINDER -- 0580pc' => 0x1E2111 ,
'TOYO COLOR FINDER -- 0581pc' => 0x372305 ,
'TOYO COLOR FINDER -- 0582pc' => 0x321E0A ,
'TOYO COLOR FINDER -- 0583pc' => 0x37280F ,
'TOYO COLOR FINDER -- 0584pc' => 0x46280F ,
'TOYO COLOR FINDER -- 0585pc' => 0x322114 ,
'TOYO COLOR FINDER -- 0586pc' => 0x312525 ,
'TOYO COLOR FINDER -- 0587pc' => 0x3D2D2A ,
'TOYO COLOR FINDER -- 0588pc' => 0x333031 ,
'TOYO COLOR FINDER -- 0589pc' => 0x231A1E ,
'TOYO COLOR FINDER -- 0590pc' => 0x3B2923 ,
'TOYO COLOR FINDER -- 0591pc' => 0x19141E ,
'TOYO COLOR FINDER -- 0592pc' => 0x231919 ,
'TOYO COLOR FINDER -- 0593pc' => 0x33190C ,
'TOYO COLOR FINDER -- 0594pc' => 0x19110C ,
'TOYO COLOR FINDER -- 0595pc' => 0x191416 ,
'TOYO COLOR FINDER -- 0596pc' => 0x0F0709 ,
'TOYO COLOR FINDER -- 0597pc' => 0x14090A ,
'TOYO COLOR FINDER -- 0598pc' => 0x1B100A ,
'TOYO COLOR FINDER -- 0599pc' => 0x180300 ,
'TOYO COLOR FINDER -- 0600pc' => 0x130200 ,
'TOYO COLOR FINDER -- 0601pc' => 0x130000 ,
'TOYO COLOR FINDER -- 0602pc' => 0x110000 ,
'TOYO COLOR FINDER -- 0603pc' => 0x100000 ,
'TOYO COLOR FINDER -- 0604pc' => 0x15070A ,
'TOYO COLOR FINDER -- 0605pc' => 0x230403 ,
'TOYO COLOR FINDER -- 0606pc' => 0x340D0B ,
'TOYO COLOR FINDER -- 0607pc' => 0x32070E ,
'TOYO COLOR FINDER -- 0608pc' => 0x330F15 ,
'TOYO COLOR FINDER -- 0609pc' => 0x3F1E2F ,
'TOYO COLOR FINDER -- 0610pc' => 0x321E2C ,
'TOYO COLOR FINDER -- 0611pc' => 0x231823 ,
'TOYO COLOR FINDER -- 0612pc' => 0x37091D ,
'TOYO COLOR FINDER -- 0613pc' => 0x370019 ,
'TOYO COLOR FINDER -- 0614pc' => 0x36001A ,
'TOYO COLOR FINDER -- 0615pc' => 0x360827 ,
'TOYO COLOR FINDER -- 0616pc' => 0x361430 ,
'TOYO COLOR FINDER -- 0617pc' => 0x250819 ,
'TOYO COLOR FINDER -- 0618pc' => 0x1E0614 ,
'TOYO COLOR FINDER -- 0619pc' => 0x120A11 ,
'TOYO COLOR FINDER -- 0620pc' => 0x0C0005 ,
'TOYO COLOR FINDER -- 0621pc' => 0x140005 ,
'TOYO COLOR FINDER -- 0622pc*' => 0x19000B ,
'TOYO COLOR FINDER -- 0623pc' => 0x12000B ,
'TOYO COLOR FINDER -- 0624pc*' => 0x140013 ,
'TOYO COLOR FINDER -- 0625pc*' => 0x2D0026 ,
'TOYO COLOR FINDER -- 0626pc*' => 0x1E001E ,
'TOYO COLOR FINDER -- 0627pc' => 0x090208 ,
'TOYO COLOR FINDER -- 0628pc' => 0x0F0211 ,
'TOYO COLOR FINDER -- 0629pc' => 0x100616 ,
'TOYO COLOR FINDER -- 0630pc' => 0x1D0D27 ,
'TOYO COLOR FINDER -- 0631pc' => 0x1E0C2D ,
'TOYO COLOR FINDER -- 0632pc' => 0x2F0D34 ,
'TOYO COLOR FINDER -- 0633pc' => 0x37003F ,
'TOYO COLOR FINDER -- 0634pc' => 0x1E0D33 ,
'TOYO COLOR FINDER -- 0635pc' => 0x330A3C ,
'TOYO COLOR FINDER -- 0636pc' => 0x2D0D3D ,
'TOYO COLOR FINDER -- 0637pc' => 0x260A44 ,
'TOYO COLOR FINDER -- 0638pc' => 0x371B4A ,
'TOYO COLOR FINDER -- 0639pc' => 0x371150 ,
'TOYO COLOR FINDER -- 0640pc' => 0x330C4E ,
'TOYO COLOR FINDER -- 0641pc' => 0x320050 ,
'TOYO COLOR FINDER -- 0642pc' => 0x33124B ,
'TOYO COLOR FINDER -- 0643pc' => 0x2D0A4B ,
'TOYO COLOR FINDER -- 0644pc' => 0x28133D ,
'TOYO COLOR FINDER -- 0645pc' => 0x2D023F ,
'TOYO COLOR FINDER -- 0646pc' => 0x1E0032 ,
'TOYO COLOR FINDER -- 0647pc' => 0x1A033A ,
'TOYO COLOR FINDER -- 0648pc' => 0x12051D ,
'TOYO COLOR FINDER -- 0649pc' => 0x140028 ,
'TOYO COLOR FINDER -- 0650pc' => 0x0D0014 ,
'TOYO COLOR FINDER -- 0651pc' => 0x0A000F ,
'TOYO COLOR FINDER -- 0652pc*' => 0x100019 ,
'TOYO COLOR FINDER -- 0653pc' => 0x171534 ,
'TOYO COLOR FINDER -- 0654pc' => 0x151528 ,
'TOYO COLOR FINDER -- 0655pc' => 0x0F002D ,
'TOYO COLOR FINDER -- 0656pc' => 0x23034B ,
'TOYO COLOR FINDER -- 0657pc' => 0x2E1B4B ,
'TOYO COLOR FINDER -- 0658pc' => 0x271450 ,
'TOYO COLOR FINDER -- 0659pc' => 0x25164B ,
'TOYO COLOR FINDER -- 0660pc' => 0x1E264B ,
'TOYO COLOR FINDER -- 0661pc' => 0x23233F ,
'TOYO COLOR FINDER -- 0662pc' => 0x13072C ,
'TOYO COLOR FINDER -- 0663pc*' => 0x0A001C ,
'TOYO COLOR FINDER -- 0664pc*' => 0x0F002A ,
'TOYO COLOR FINDER -- 0665pc*' => 0x0F002D ,
'TOYO COLOR FINDER -- 0666pc*' => 0x11033C ,
'TOYO COLOR FINDER -- 0667pc' => 0x0F0330 ,
'TOYO COLOR FINDER -- 0668pc' => 0x150A40 ,
'TOYO COLOR FINDER -- 0669pc' => 0x1A114F ,
'TOYO COLOR FINDER -- 0670pc' => 0x28235A ,
'TOYO COLOR FINDER -- 0671pc' => 0x1A1A56 ,
'TOYO COLOR FINDER -- 0672pc' => 0x14194B ,
'TOYO COLOR FINDER -- 0673pc' => 0x191E41 ,
'TOYO COLOR FINDER -- 0674pc' => 0x0F0731 ,
'TOYO COLOR FINDER -- 0675pc' => 0x0F0D2E ,
'TOYO COLOR FINDER -- 0676pc' => 0x0C0518 ,
'TOYO COLOR FINDER -- 0677pc' => 0x090516 ,
'TOYO COLOR FINDER -- 0678pc' => 0x0F0F29 ,
'TOYO COLOR FINDER -- 0679pc' => 0x0E0537 ,
'TOYO COLOR FINDER -- 0680pc' => 0x141946 ,
'TOYO COLOR FINDER -- 0681pc' => 0x192850 ,
'TOYO COLOR FINDER -- 0682pc' => 0x14194B ,
'TOYO COLOR FINDER -- 0683pc' => 0x0F0F4B ,
'TOYO COLOR FINDER -- 0684pc' => 0x131953 ,
'TOYO COLOR FINDER -- 0685pc' => 0x0F1937 ,
'TOYO COLOR FINDER -- 0686pc' => 0x0E133B ,
'TOYO COLOR FINDER -- 0687pc' => 0x09154A ,
'TOYO COLOR FINDER -- 0688pc' => 0x162546 ,
'TOYO COLOR FINDER -- 0689pc' => 0x132146 ,
'TOYO COLOR FINDER -- 0690pc' => 0x0A143B ,
'TOYO COLOR FINDER -- 0691pc' => 0x05001B ,
'TOYO COLOR FINDER -- 0692pc' => 0x000019 ,
'TOYO COLOR FINDER -- 0693pc' => 0x040614 ,
'TOYO COLOR FINDER -- 0694pc' => 0x05070F ,
'TOYO COLOR FINDER -- 0695pc' => 0x050720 ,
'TOYO COLOR FINDER -- 0696pc' => 0x05091E ,
'TOYO COLOR FINDER -- 0697pc' => 0x0B122F ,
'TOYO COLOR FINDER -- 0698pc' => 0x0A1436 ,
'TOYO COLOR FINDER -- 0699pc' => 0x0F2543 ,
'TOYO COLOR FINDER -- 0700pc' => 0x163251 ,
'TOYO COLOR FINDER -- 0701pc' => 0x132D42 ,
'TOYO COLOR FINDER -- 0702pc' => 0x193346 ,
'TOYO COLOR FINDER -- 0703pc' => 0x132535 ,
'TOYO COLOR FINDER -- 0704pc' => 0x060F1B ,
'TOYO COLOR FINDER -- 0705pc' => 0x040814 ,
'TOYO COLOR FINDER -- 0706pc' => 0x02060F ,
'TOYO COLOR FINDER -- 0707pc' => 0x040706 ,
'TOYO COLOR FINDER -- 0708pc' => 0x060909 ,
'TOYO COLOR FINDER -- 0709pc' => 0x060C0A ,
'TOYO COLOR FINDER -- 0710pc' => 0x010C0B ,
'TOYO COLOR FINDER -- 0711pc' => 0x051A20 ,
'TOYO COLOR FINDER -- 0712pc' => 0x0C3942 ,
'TOYO COLOR FINDER -- 0713pc' => 0x092D36 ,
'TOYO COLOR FINDER -- 0714pc' => 0x103535 ,
'TOYO COLOR FINDER -- 0715pc' => 0x1A3337 ,
'TOYO COLOR FINDER -- 0716pc' => 0x233C3C ,
'TOYO COLOR FINDER -- 0717pc' => 0x0B151C ,
'TOYO COLOR FINDER -- 0718pc' => 0x031919 ,
'TOYO COLOR FINDER -- 0719pc' => 0x040F06 ,
'TOYO COLOR FINDER -- 0720pc' => 0x010D05 ,
'TOYO COLOR FINDER -- 0721pc' => 0x010F00 ,
'TOYO COLOR FINDER -- 0722pc' => 0x020A00 ,
'TOYO COLOR FINDER -- 0723pc' => 0x010900 ,
'TOYO COLOR FINDER -- 0724pc*' => 0x021A01 ,
'TOYO COLOR FINDER -- 0725pc' => 0x082121 ,
'TOYO COLOR FINDER -- 0726pc' => 0x09362F ,
'TOYO COLOR FINDER -- 0727pc' => 0x024023 ,
'TOYO COLOR FINDER -- 0728pc' => 0x043319 ,
'TOYO COLOR FINDER -- 0729pc' => 0x003A0A ,
'TOYO COLOR FINDER -- 0730pc' => 0x0F3429 ,
'TOYO COLOR FINDER -- 0731pc' => 0x143923 ,
'TOYO COLOR FINDER -- 0732pc' => 0x0F3214 ,
'TOYO COLOR FINDER -- 0733pc' => 0x0B1316 ,
'TOYO COLOR FINDER -- 0734pc' => 0x0F140D ,
'TOYO COLOR FINDER -- 0735pc' => 0x090D08 ,
'TOYO COLOR FINDER -- 0736pc' => 0x070F04 ,
'TOYO COLOR FINDER -- 0737pc' => 0x042802 ,
'TOYO COLOR FINDER -- 0738pc' => 0x052E04 ,
'TOYO COLOR FINDER -- 0739pc' => 0x092B0B ,
'TOYO COLOR FINDER -- 0740pc' => 0x0F370F ,
'TOYO COLOR FINDER -- 0741pc' => 0x14320B ,
'TOYO COLOR FINDER -- 0742pc' => 0x1B2F0C ,
'TOYO COLOR FINDER -- 0743pc' => 0x0F1E0A ,
'TOYO COLOR FINDER -- 0744pc' => 0x23312A ,
'TOYO COLOR FINDER -- 0745pc' => 0x283732 ,
'TOYO COLOR FINDER -- 0746pc' => 0x283728 ,
'TOYO COLOR FINDER -- 0747pc' => 0x1A292A ,
'TOYO COLOR FINDER -- 0748pc' => 0x090400 ,
'TOYO COLOR FINDER -- 0749pc' => 0x0A0502 ,
'TOYO COLOR FINDER -- 0750pc' => 0x0E0403 ,
'TOYO COLOR FINDER -- 0751pc' => 0x050307 ,
'TOYO COLOR FINDER -- 0752pc' => 0x010302 ,
'TOYO COLOR FINDER -- 0753pc' => 0x09060A ,
'TOYO COLOR FINDER -- 0754pc' => 0x09080A ,
'TOYO COLOR FINDER -- 0755pc' => 0x080D0B ,
'TOYO COLOR FINDER -- 0756pc' => 0x0C0A0A ,
'TOYO COLOR FINDER -- 0757pc' => 0x0C060B ,
'TOYO COLOR FINDER -- 0758pc' => 0x0A0007 ,
'TOYO COLOR FINDER -- 0759pc' => 0x10060C ,
'TOYO COLOR FINDER -- 0760pc' => 0x110A0F ,
'TOYO COLOR FINDER -- 0761pc' => 0x0D080E ,
'TOYO COLOR FINDER -- 0762pc' => 0x05070B ,
'TOYO COLOR FINDER -- 0763pc' => 0x0C0A0D ,
'TOYO COLOR FINDER -- 0764pc' => 0x10090D ,
'TOYO COLOR FINDER -- 0765pc' => 0x100C18 ,
'TOYO COLOR FINDER -- 0766pc' => 0x100918 ,
'TOYO COLOR FINDER -- 0767pc' => 0x11120F ,
'TOYO COLOR FINDER -- 0768pc' => 0x10131C ,
'TOYO COLOR FINDER -- 0769pc' => 0x0E0C17 ,
'TOYO COLOR FINDER -- 0770pc' => 0x141514 ,
'TOYO COLOR FINDER -- 0771pc' => 0x0E1219 ,
'TOYO COLOR FINDER -- 0772pc' => 0x131315 ,
'TOYO COLOR FINDER -- 0773pc' => 0x13141A ,
'TOYO COLOR FINDER -- 0774pc' => 0x121320 ,
'TOYO COLOR FINDER -- 0775pc' => 0x131424 ,
'TOYO COLOR FINDER -- 0776pc' => 0x1A1E2A ,
'TOYO COLOR FINDER -- 0777pc' => 0x0F1926 ,
'TOYO COLOR FINDER -- 0778pc' => 0x161E2E ,
'TOYO COLOR FINDER -- 0779pc' => 0x191D25 ,
'TOYO COLOR FINDER -- 0780pc' => 0x191731 ,
'TOYO COLOR FINDER -- 0781pc' => 0x16192F ,
'TOYO COLOR FINDER -- 0782pc' => 0x231E25 ,
'TOYO COLOR FINDER -- 0783pc' => 0x1E2326 ,
'TOYO COLOR FINDER -- 0784pc' => 0x0E1126 ,
'TOYO COLOR FINDER -- 0785pc' => 0x131A27 ,
'TOYO COLOR FINDER -- 0786pc' => 0x191D32 ,
'TOYO COLOR FINDER -- 0787pc' => 0x1A2331 ,
'TOYO COLOR FINDER -- 0788pc' => 0x182032 ,
'TOYO COLOR FINDER -- 0789pc' => 0x282D32 ,
'TOYO COLOR FINDER -- 0790pc' => 0x171E2D ,
'TOYO COLOR FINDER -- 0791pc' => 0x1C1E37 ,
'TOYO COLOR FINDER -- 0792pc' => 0x050003 ,
'TOYO COLOR FINDER -- 0793pc' => 0x00000A ,
'TOYO COLOR FINDER -- 0794pc' => 0x050202 ,
'TOYO COLOR FINDER -- 0795pc' => 0x160B00 ,
'TOYO COLOR FINDER -- 0796pc' => 0x0B0000 ,
'TOYO COLOR FINDER -- 0797pc' => 0x35363C ,
'TOYO COLOR FINDER -- 0798pc' => 0x415A4B ,
'TOYO COLOR FINDER -- 0799pc' => 0x476456 ,
'TOYO COLOR FINDER -- 0800pc' => 0x223900 ,
'TOYO COLOR FINDER -- 0801pc' => 0x224200 ,
'TOYO COLOR FINDER -- 0802pc' => 0x416449 ,
'TOYO COLOR FINDER -- 0803pc' => 0x3C643A ,
'TOYO COLOR FINDER -- 0804pc' => 0x3C6431 ,
'TOYO COLOR FINDER -- 0805pc' => 0x375A23 ,
'TOYO COLOR FINDER -- 0806pc' => 0x355421 ,
'TOYO COLOR FINDER -- 0807pc' => 0x41643D ,
'TOYO COLOR FINDER -- 0808pc' => 0x3C6434 ,
'TOYO COLOR FINDER -- 0809pc' => 0x4B6417 ,
'TOYO COLOR FINDER -- 0810pc' => 0x556437 ,
'TOYO COLOR FINDER -- 0811pc' => 0x4B5F23 ,
'TOYO COLOR FINDER -- 0812pc' => 0x556249 ,
'TOYO COLOR FINDER -- 0813pc' => 0x2F2900 ,
'TOYO COLOR FINDER -- 0814pc' => 0x282800 ,
'TOYO COLOR FINDER -- 0815pc' => 0x343300 ,
'TOYO COLOR FINDER -- 0816pc' => 0x1D2200 ,
'TOYO COLOR FINDER -- 0817pc' => 0x323C37 ,
'TOYO COLOR FINDER -- 0818pc' => 0x1D1700 ,
'TOYO COLOR FINDER -- 0819pc' => 0x171700 ,
'TOYO COLOR FINDER -- 0820pc' => 0x171D00 ,
'TOYO COLOR FINDER -- 0821pc' => 0x323200 ,
'TOYO COLOR FINDER -- 0822pc' => 0x5F594B ,
'TOYO COLOR FINDER -- 0823pc' => 0x3E473C ,
'TOYO COLOR FINDER -- 0824pc' => 0x5A5F4B ,
'TOYO COLOR FINDER -- 0825pc' => 0x505F4B ,
'TOYO COLOR FINDER -- 0826pc' => 0x505C32 ,
'TOYO COLOR FINDER -- 0827pc' => 0x433900 ,
'TOYO COLOR FINDER -- 0828pc' => 0x645A4B ,
'TOYO COLOR FINDER -- 0829pc' => 0x49483C ,
'TOYO COLOR FINDER -- 0830pc' => 0x555A4D ,
'TOYO COLOR FINDER -- 0831pc' => 0x585F26 ,
'TOYO COLOR FINDER -- 0832pc' => 0x505A2D ,
'TOYO COLOR FINDER -- 0833pc' => 0x525A2F ,
'TOYO COLOR FINDER -- 0834pc' => 0x4B5920 ,
'TOYO COLOR FINDER -- 0835pc' => 0x3D4427 ,
'TOYO COLOR FINDER -- 0836pc' => 0x4B5414 ,
'TOYO COLOR FINDER -- 0837pc' => 0x5F5A32 ,
'TOYO COLOR FINDER -- 0838pc' => 0x5A5A41 ,
'TOYO COLOR FINDER -- 0839pc' => 0x645A32 ,
'TOYO COLOR FINDER -- 0840pc' => 0x645A1E ,
'TOYO COLOR FINDER -- 0841pc' => 0x5A501E ,
'TOYO COLOR FINDER -- 0842pc' => 0x554B37 ,
'TOYO COLOR FINDER -- 0843pc' => 0x644D37 ,
'TOYO COLOR FINDER -- 0844pc*' => 0x584332 ,
'TOYO COLOR FINDER -- 0845pc' => 0x64503F ,
'TOYO COLOR FINDER -- 0846pc' => 0x644632 ,
'TOYO COLOR FINDER -- 0847pc' => 0x5F3C1E ,
'TOYO COLOR FINDER -- 0848pc' => 0x3C1400 ,
'TOYO COLOR FINDER -- 0849pc' => 0x280A00 ,
'TOYO COLOR FINDER -- 0850pc' => 0x260F00 ,
'TOYO COLOR FINDER -- 0851pc' => 0x323432 ,
'TOYO COLOR FINDER -- 0852pc' => 0x281900 ,
'TOYO COLOR FINDER -- 0853pc' => 0x645A55 ,
'TOYO COLOR FINDER -- 0854pc' => 0x645550 ,
'TOYO COLOR FINDER -- 0855pc' => 0x5F4137 ,
'TOYO COLOR FINDER -- 0856pc' => 0x643939 ,
'TOYO COLOR FINDER -- 0857pc' => 0x643723 ,
'TOYO COLOR FINDER -- 0858pc' => 0x642D1E ,
'TOYO COLOR FINDER -- 0859pc' => 0x642D2D ,
'TOYO COLOR FINDER -- 0860pc' => 0x4A2E30 ,
'TOYO COLOR FINDER -- 0861pc' => 0x322D32 ,
'TOYO COLOR FINDER -- 0862pc' => 0x373237 ,
'TOYO COLOR FINDER -- 0863pc' => 0x37373C ,
'TOYO COLOR FINDER -- 0864pc' => 0x503C3C ,
'TOYO COLOR FINDER -- 0865pc*' => 0x643A3F ,
'TOYO COLOR FINDER -- 0866pc*' => 0x643A3C ,
'TOYO COLOR FINDER -- 0867pc' => 0x5F3C3C ,
'TOYO COLOR FINDER -- 0868pc' => 0x4B4141 ,
'TOYO COLOR FINDER -- 0869pc' => 0x370F05 ,
'TOYO COLOR FINDER -- 0870pc' => 0x50414B ,
'TOYO COLOR FINDER -- 0871pc' => 0x643243 ,
'TOYO COLOR FINDER -- 0872pc' => 0x642543 ,
'TOYO COLOR FINDER -- 0873pc' => 0x561D37 ,
'TOYO COLOR FINDER -- 0874pc' => 0x39283B ,
'TOYO COLOR FINDER -- 0875pc' => 0x3C323C ,
'TOYO COLOR FINDER -- 0876pc' => 0x5F2D4B ,
'TOYO COLOR FINDER -- 0877pc*' => 0x642D48 ,
'TOYO COLOR FINDER -- 0878pc' => 0x644650 ,
'TOYO COLOR FINDER -- 0879pc' => 0x5F4655 ,
'TOYO COLOR FINDER -- 0880pc' => 0x64415A ,
'TOYO COLOR FINDER -- 0881pc' => 0x613057 ,
'TOYO COLOR FINDER -- 0882pc' => 0x55425A ,
'TOYO COLOR FINDER -- 0883pc' => 0x513A5F ,
'TOYO COLOR FINDER -- 0884pc' => 0x532F5F ,
'TOYO COLOR FINDER -- 0885pc' => 0x2D0032 ,
'TOYO COLOR FINDER -- 0886pc' => 0x413C5A ,
'TOYO COLOR FINDER -- 0887pc' => 0x362856 ,
'TOYO COLOR FINDER -- 0888pc' => 0x373250 ,
'TOYO COLOR FINDER -- 0889pc' => 0x1E0028 ,
'TOYO COLOR FINDER -- 0890pc' => 0x4F3364 ,
'TOYO COLOR FINDER -- 0891pc' => 0x543664 ,
'TOYO COLOR FINDER -- 0892pc' => 0x555564 ,
'TOYO COLOR FINDER -- 0893pc' => 0x3C005A ,
'TOYO COLOR FINDER -- 0894pc' => 0x4B5064 ,
'TOYO COLOR FINDER -- 0895pc' => 0x462864 ,
'TOYO COLOR FINDER -- 0896pc' => 0x414164 ,
'TOYO COLOR FINDER -- 0897pc' => 0x3C2364 ,
'TOYO COLOR FINDER -- 0898pc' => 0x35285A ,
'TOYO COLOR FINDER -- 0899pc' => 0x362D5A ,
'TOYO COLOR FINDER -- 0900pc' => 0x331959 ,
'TOYO COLOR FINDER -- 0901pc' => 0x37415A ,
'TOYO COLOR FINDER -- 0902pc' => 0x415564 ,
'TOYO COLOR FINDER -- 0903pc' => 0x4B5F64 ,
'TOYO COLOR FINDER -- 0904pc' => 0x373463 ,
'TOYO COLOR FINDER -- 0905pc' => 0x32375F ,
'TOYO COLOR FINDER -- 0906pc' => 0x32325F ,
'TOYO COLOR FINDER -- 0907pc' => 0x322F5F ,
'TOYO COLOR FINDER -- 0908pc' => 0x30225D ,
'TOYO COLOR FINDER -- 0909pc' => 0x323C5A ,
'TOYO COLOR FINDER -- 0910pc' => 0x323C64 ,
'TOYO COLOR FINDER -- 0911pc' => 0x415A64 ,
'TOYO COLOR FINDER -- 0912pc*' => 0x264164 ,
'TOYO COLOR FINDER -- 0913pc' => 0x375564 ,
'TOYO COLOR FINDER -- 0914pc*' => 0x284164 ,
'TOYO COLOR FINDER -- 0915pc*' => 0x283D64 ,
'TOYO COLOR FINDER -- 0916pc' => 0x284664 ,
'TOYO COLOR FINDER -- 0917pc' => 0x28465F ,
'TOYO COLOR FINDER -- 0918pc' => 0x284B64 ,
'TOYO COLOR FINDER -- 0919pc' => 0x465F64 ,
'TOYO COLOR FINDER -- 0920pc' => 0x262D56 ,
'TOYO COLOR FINDER -- 0921pc' => 0x284155 ,
'TOYO COLOR FINDER -- 0922pc' => 0x2D4B5A ,
'TOYO COLOR FINDER -- 0923pc' => 0x2D4C5B ,
'TOYO COLOR FINDER -- 0924pc' => 0x00054D ,
'TOYO COLOR FINDER -- 0925pc' => 0x415F64 ,
'TOYO COLOR FINDER -- 0926pc' => 0x235064 ,
'TOYO COLOR FINDER -- 0927pc' => 0x325264 ,
'TOYO COLOR FINDER -- 0928pc' => 0x284D64 ,
'TOYO COLOR FINDER -- 0929pc' => 0x254C64 ,
'TOYO COLOR FINDER -- 0930pc*' => 0x1E425F ,
'TOYO COLOR FINDER -- 0931pc' => 0x125063 ,
'TOYO COLOR FINDER -- 0932pc' => 0x145A64 ,
'TOYO COLOR FINDER -- 0933pc' => 0x0B5864 ,
'TOYO COLOR FINDER -- 0934pc' => 0x235964 ,
'TOYO COLOR FINDER -- 0935pc' => 0x1C495E ,
'TOYO COLOR FINDER -- 0936pc' => 0x001E3C ,
'TOYO COLOR FINDER -- 0937pc' => 0x00235A ,
'TOYO COLOR FINDER -- 0938pc' => 0x00214D ,
'TOYO COLOR FINDER -- 0939pc' => 0x00294D ,
'TOYO COLOR FINDER -- 0940pc' => 0x285A64 ,
'TOYO COLOR FINDER -- 0941pc' => 0x235A5F ,
'TOYO COLOR FINDER -- 0942pc' => 0x1A5D64 ,
'TOYO COLOR FINDER -- 0943pc' => 0x325F5F ,
'TOYO COLOR FINDER -- 0944pc' => 0x002F53 ,
'TOYO COLOR FINDER -- 0945pc' => 0x002B50 ,
'TOYO COLOR FINDER -- 0946pc' => 0x001E4B ,
'TOYO COLOR FINDER -- 0947pc' => 0x003949 ,
'TOYO COLOR FINDER -- 0948pc' => 0x136064 ,
'TOYO COLOR FINDER -- 0949pc' => 0x1D5159 ,
'TOYO COLOR FINDER -- 0950pc' => 0x235257 ,
'TOYO COLOR FINDER -- 0951pc' => 0x002F2F ,
'TOYO COLOR FINDER -- 0952pc' => 0x003246 ,
'TOYO COLOR FINDER -- 0953pc' => 0x1A5E5B ,
'TOYO COLOR FINDER -- 0954pc' => 0x0A645B ,
'TOYO COLOR FINDER -- 0955pc' => 0x001E28 ,
'TOYO COLOR FINDER -- 0956pc' => 0x183D4C ,
'TOYO COLOR FINDER -- 0957pc' => 0x15404E ,
'TOYO COLOR FINDER -- 0958pc' => 0x003232 ,
'TOYO COLOR FINDER -- 0959pc' => 0x1E615A ,
'TOYO COLOR FINDER -- 0960pc' => 0x0E6356 ,
'TOYO COLOR FINDER -- 0961pc' => 0x235E56 ,
'TOYO COLOR FINDER -- 0962pc' => 0x005346 ,
'TOYO COLOR FINDER -- 0963pc' => 0x003228 ,
'TOYO COLOR FINDER -- 0964pc' => 0x002E28 ,
'TOYO COLOR FINDER -- 0965pc' => 0x002800 ,
'TOYO COLOR FINDER -- 0966pc' => 0x144E3D ,
'TOYO COLOR FINDER -- 0967pc' => 0x135645 ,
'TOYO COLOR FINDER -- 0968pc' => 0x195A43 ,
'TOYO COLOR FINDER -- 0969pc' => 0x005028 ,
'TOYO COLOR FINDER -- 0970pc' => 0x004932 ,
'TOYO COLOR FINDER -- 0971pc' => 0x175E4C ,
'TOYO COLOR FINDER -- 0972pc' => 0x14643A ,
'TOYO COLOR FINDER -- 0973pc' => 0x106430 ,
'TOYO COLOR FINDER -- 0974pc' => 0x145434 ,
'TOYO COLOR FINDER -- 0975pc' => 0x2D5640 ,
'TOYO COLOR FINDER -- 0976pc' => 0x1E6446 ,
'TOYO COLOR FINDER -- 0977pc' => 0x00490D ,
'TOYO COLOR FINDER -- 0978pc' => 0x003205 ,
'TOYO COLOR FINDER -- 0979pc' => 0x13442A ,
'TOYO COLOR FINDER -- 0980pc' => 0x1B5129 ,
'TOYO COLOR FINDER -- 0981pc*' => 0x415F39 ,
'TOYO COLOR FINDER -- 0982pc*' => 0x256428 ,
'TOYO COLOR FINDER -- 0983pc*' => 0x346426 ,
'TOYO COLOR FINDER -- 0984pc' => 0x2E4A28 ,
'TOYO COLOR FINDER -- 0985pc' => 0x2D4637 ,
'TOYO COLOR FINDER -- 0986pc' => 0x375041 ,
'TOYO COLOR FINDER -- 0987pc' => 0x1E501E ,
'TOYO COLOR FINDER -- 0988pc' => 0x282D3C ,
'TOYO COLOR FINDER -- 0989pc' => 0x040206 ,
'TOYO COLOR FINDER -- 0990pc' => 0x000014 ,
'TOYO COLOR FINDER -- 0991pc' => 0x070007 ,
'TOYO COLOR FINDER -- 0992pc' => 0x464146 ,
'TOYO COLOR FINDER -- 0993pc' => 0x141405 ,
'TOYO COLOR FINDER -- 0994pc' => 0x07070A ,
'TOYO COLOR FINDER -- 0995pc' => 0x080603 ,
'TOYO COLOR FINDER -- 0996pc' => 0x080505 ,
'TOYO COLOR FINDER -- 0997pc' => 0x020014 ,
'TOYO COLOR FINDER -- 0998pc' => 0x040617 ,
'TOYO COLOR FINDER -- 0999pc' => 0x1C0006 ,
'TOYO COLOR FINDER -- 1000pc' => 0x000C0C ,
'TOYO COLOR FINDER -- 1001pc' => 0x070505 ,
'TOYO COLOR FINDER -- 1002pc' => 0x0B1100 ,
'TOYO COLOR FINDER -- 1003pc' => 0x050500 ,
'TOYO COLOR FINDER -- 1004pc' => 0x050500 ,
'TOYO COLOR FINDER -- 1005pc' => 0x000517 ,
'TOYO COLOR FINDER -- 1006pc' => 0x0B0B00 ,
'TOYO COLOR FINDER -- 1007pc' => 0x050500 ,
'TOYO COLOR FINDER -- 1008pc' => 0x000A1E ,
'TOYO COLOR FINDER -- 1009pc' => 0x221600 ,
'TOYO COLOR FINDER -- 1010pc' => 0x0F000A ,
'TOYO COLOR FINDER -- 1011pc' => 0x2E002E ,
'TOYO COLOR FINDER -- 1012pc' => 0x2E0039 ,
'TOYO COLOR FINDER -- 1013pc' => 0x060500 ,
'TOYO COLOR FINDER -- 1014pc' => 0x0B1100 ,
'TOYO COLOR FINDER -- 1015pc' => 0x000B0C ,
'TOYO COLOR FINDER -- 1016pc' => 0x001111 ,
'TOYO COLOR FINDER -- 1017pc' => 0x280016 ,
'TOYO COLOR FINDER -- 1018pc' => 0x060500 ,
'TOYO COLOR FINDER -- 1019pc' => 0x171600 ,
'TOYO COLOR FINDER -- 1020pc' => 0x060000 ,
'TOYO COLOR FINDER -- 1021pc*' => 0x5B5C61 ,
'TOYO COLOR FINDER -- 1022pc*' => 0x0F0D16 ,
'TOYO COLOR FINDER -- 1023pc*' => 0x100016 ,
'TOYO COLOR FINDER -- 1024pc*' => 0x101200 ,
'TOYO COLOR FINDER -- 1025pc*' => 0x150A05 ,
'TOYO COLOR FINDER -- 1026pc*' => 0x1D0A03 ,
'TOYO COLOR FINDER -- 1027pc*' => 0x202620 ,
'TOYO COLOR FINDER -- 1028pc*' => 0x1B2323 ,
'TOYO COLOR FINDER -- 1029pc*' => 0x30141E ,
'TOYO COLOR FINDER -- 1030pc*' => 0x231424 ,
'TOYO COLOR FINDER -- 1031pc*' => 0x23192D ,
'TOYO COLOR FINDER -- 1032pc*' => 0x200C2D ,
'TOYO COLOR FINDER -- 1033pc*' => 0x1C1C2E ,
'TOYO COLOR FINDER -- 1034pc*' => 0x141539 ,
'TOYO COLOR FINDER -- 1035pc*' => 0x141534 ,
'TOYO COLOR FINDER -- 1036pc*' => 0x122035 ,
'TOYO COLOR FINDER -- 1037pc*' => 0x0A192E ,
'TOYO COLOR FINDER -- 1038pc*' => 0x061919 ,
'TOYO COLOR FINDER -- 1039pc*' => 0x0F2D1E ,
'TOYO COLOR FINDER -- 1040pc*' => 0x0F2D19 ,
'TOYO COLOR FINDER -- 1041pc*' => 0x06370A ,
'TOYO COLOR FINDER -- 1042pc*' => 0x16131C ,
'TOYO COLOR FINDER -- 1043pc*' => 0x0B0F1C ,
'TOYO COLOR FINDER -- 1044pc*' => 0x232B2C ,
'TOYO COLOR FINDER -- 1045pc*' => 0x232B2C ,
'TOYO COLOR FINDER -- 1046pc*' => 0x1C1C28 ,
'TOYO COLOR FINDER -- 1047pc*' => 0x1E232A ,
'TOYO COLOR FINDER -- 1048pc*' => 0x232027 ,
'TOYO COLOR FINDER -- 1049pc*' => 0x37241E ,
'TOYO COLOR FINDER -- 1050pc*' => 0x34281E ,
'HKS Colors -- HKS 01K 010%  K 0%' => 0xF7F3E5 ,
'HKS Colors -- HKS 02K 010%  K 0%' => 0xF7F4DA ,
'HKS Colors -- HKS 03K 010%  K 0%' => 0xFAF6D1 ,
'HKS Colors -- HKS 04K 010%  K 0%' => 0xF7EFD8 ,
'HKS Colors -- HKS 05K 010%  K 0%' => 0xFCEFD7 ,
'HKS Colors -- HKS 06K 010%  K 0%' => 0xFAE3D4 ,
'HKS Colors -- HKS 07K 010%  K 0%' => 0xFFDED5 ,
'HKS Colors -- HKS 08K 010%  K 0%' => 0xFDDDD8 ,
'HKS Colors -- HKS 10K 010%  K 0%' => 0xF7DADD ,
'HKS Colors -- HKS 11K 010%  K 0%' => 0xFDE5E3 ,
'HKS Colors -- HKS 12K 010%  K 0%' => 0xF6DCDE ,
'HKS Colors -- HKS 13K 010%  K 0%' => 0xF7D6DD ,
'HKS Colors -- HKS 14K 010%  K 0%' => 0xF4DBE0 ,
'HKS Colors -- HKS 15K 010%  K 0%' => 0xF0D6DE ,
'HKS Colors -- HKS 16K 010%  K 0%' => 0xEDD7E1 ,
'HKS Colors -- HKS 17K 010%  K 0%' => 0xEFDAE6 ,
'HKS Colors -- HKS 18K 010%  K 0%' => 0xE4D0DE ,
'HKS Colors -- HKS 21K 010%  K 0%' => 0xFCE4EE ,
'HKS Colors -- HKS 22K 010%  K 0%' => 0xF7D6DD ,
'HKS Colors -- HKS 23K 010%  K 0%' => 0xF5D4E1 ,
'HKS Colors -- HKS 24K 010%  K 0%' => 0xF3D3E2 ,
'HKS Colors -- HKS 25K 010%  K 0%' => 0xF1D3E5 ,
'HKS Colors -- HKS 26K 010%  K 0%' => 0xF0D3E7 ,
'HKS Colors -- HKS 27K 010%  K 0%' => 0xF5D5ED ,
'HKS Colors -- HKS 28K 010%  K 0%' => 0xF0DBEB ,
'HKS Colors -- HKS 29K 010%  K 0%' => 0xE8D6EA ,
'HKS Colors -- HKS 31K 010%  K 0%' => 0xF3D8EC ,
'HKS Colors -- HKS 32K 010%  K 0%' => 0xEDCAE3 ,
'HKS Colors -- HKS 33K 010%  K 0%' => 0xEAD6F4 ,
'HKS Colors -- HKS 34K 010%  K 0%' => 0xE3D8EC ,
'HKS Colors -- HKS 35K 010%  K 0%' => 0xDBD7EA ,
'HKS Colors -- HKS 36K 010%  K 0%' => 0xDED5EC ,
'HKS Colors -- HKS 37K 010%  K 0%' => 0xDDD8E7 ,
'HKS Colors -- HKS 38K 010%  K 0%' => 0xD0D4DD ,
'HKS Colors -- HKS 39K 010%  K 0%' => 0xDADEF5 ,
'HKS Colors -- HKS 40K 010%  K 0%' => 0xDCE4F0 ,
'HKS Colors -- HKS 41K 010%  K 0%' => 0xCFD4E0 ,
'HKS Colors -- HKS 42K 010%  K 0%' => 0xDBD8F0 ,
'HKS Colors -- HKS 43K 010%  K 0%' => 0xD7D9F5 ,
'HKS Colors -- HKS 44K 010%  K 0%' => 0xD9E0F1 ,
'HKS Colors -- HKS 45K 010%  K 0%' => 0xE3DDEE ,
'HKS Colors -- HKS 46K 010%  K 0%' => 0xD7E0EF ,
'HKS Colors -- HKS 47K 010%  K 0%' => 0xD6E6F6 ,
'HKS Colors -- HKS 48K 010%  K 0%' => 0xD1E6F5 ,
'HKS Colors -- HKS 49K 010%  K 0%' => 0xCDE2EF ,
'HKS Colors -- HKS 50K 010%  K 0%' => 0xE2EDF6 ,
'HKS Colors -- HKS 51K 010%  K 0%' => 0xDBE7ED ,
'HKS Colors -- HKS 52K 010%  K 0%' => 0xD1E4E4 ,
'HKS Colors -- HKS 53K 010%  K 0%' => 0xD4EDE8 ,
'HKS Colors -- HKS 54K 010%  K 0%' => 0xCFE3DD ,
'HKS Colors -- HKS 55K 010%  K 0%' => 0xD6E4E3 ,
'HKS Colors -- HKS 56K 010%  K 0%' => 0xD0DCDE ,
'HKS Colors -- HKS 57K 010%  K 0%' => 0xD4E3DC ,
'HKS Colors -- HKS 58K 010%  K 0%' => 0xD6DCDA ,
'HKS Colors -- HKS 59K 010%  K 0%' => 0xD1E1E5 ,
'HKS Colors -- HKS 60K 010%  K 0%' => 0xDDE7D9 ,
'HKS Colors -- HKS 61K 010%  K 0%' => 0xD9DBD8 ,
'HKS Colors -- HKS 62K 010%  K 0%' => 0xDBDBD0 ,
'HKS Colors -- HKS 63K 010%  K 0%' => 0xDBE3DB ,
'HKS Colors -- HKS 64K 010%  K 0%' => 0xDAE7DB ,
'HKS Colors -- HKS 65K 010%  K 0%' => 0xDBEAD5 ,
'HKS Colors -- HKS 66K 010%  K 0%' => 0xE1ECD8 ,
'HKS Colors -- HKS 67K 010%  K 0%' => 0xE2EFD4 ,
'HKS Colors -- HKS 68K 010%  K 0%' => 0xF6F0E1 ,
'HKS Colors -- HKS 69K 010%  K 0%' => 0xF5F1DE ,
'HKS Colors -- HKS 71K 010%  K 0%' => 0xF6EBE0 ,
'HKS Colors -- HKS 72K 010%  K 0%' => 0xF3E5D6 ,
'HKS Colors -- HKS 73K 010%  K 0%' => 0xECE2D9 ,
'HKS Colors -- HKS 74K 010%  K 0%' => 0xE5DBD6 ,
'HKS Colors -- HKS 75K 010%  K 0%' => 0xE0DBD7 ,
'HKS Colors -- HKS 76K 010%  K 0%' => 0xDDDADA ,
'HKS Colors -- HKS 77K 010%  K 0%' => 0xDDD6D6 ,
'HKS Colors -- HKS 78K 010%  K 0%' => 0xE3D6D7 ,
'HKS Colors -- HKS 81K 010%  K 0%' => 0xEDDAD8 ,
'HKS Colors -- HKS 82K 010%  K 0%' => 0xEAD7D7 ,
'HKS Colors -- HKS 83K 010%  K 0%' => 0xE2D8DB ,
'HKS Colors -- HKS 84K 010%  K 0%' => 0xE1D7D9 ,
'HKS Colors -- HKS 88K 010%  K 0%' => 0xD8D6D9 ,
'HKS Colors -- HKS 89K 010%  K 0%' => 0xECE8EA ,
'HKS Colors -- HKS 90K 010%  K 0%' => 0xDBD6DA ,
'HKS Colors -- HKS 91K 010%  K 0%' => 0xEBE8EC ,
'HKS Colors -- HKS 92K 010%  K 0%' => 0xE2E0E3 ,
'HKS Colors -- HKS 93K 010%  K 0%' => 0xDEDCE3 ,
'HKS Colors -- HKS 95K 010%  K 0%' => 0xE8E5EA ,
'HKS Colors -- HKS 96K 010%  K 0%' => 0xE8E5EA ,
'HKS Colors -- HKS 97K 010%  K 0%' => 0xD8D6D9 ,
'HKS Colors -- HKS 01K 020%  K 0%' => 0xF6F0D3 ,
'HKS Colors -- HKS 02K 020%  K 0%' => 0xF6F1C2 ,
'HKS Colors -- HKS 03K 020%  K 0%' => 0xF9F4B1 ,
'HKS Colors -- HKS 04K 020%  K 0%' => 0xF6EBBB ,
'HKS Colors -- HKS 05K 020%  K 0%' => 0xFEE8BC ,
'HKS Colors -- HKS 06K 020%  K 0%' => 0xFDD7B9 ,
'HKS Colors -- HKS 07K 020%  K 0%' => 0xFFCBB9 ,
'HKS Colors -- HKS 08K 020%  K 0%' => 0xFEC9BE ,
'HKS Colors -- HKS 10K 020%  K 0%' => 0xF9C3C4 ,
'HKS Colors -- HKS 11K 020%  K 0%' => 0xFED7CF ,
'HKS Colors -- HKS 12K 020%  K 0%' => 0xF3C5C9 ,
'HKS Colors -- HKS 13K 020%  K 0%' => 0xF6B9C5 ,
'HKS Colors -- HKS 14K 020%  K 0%' => 0xF0C4CA ,
'HKS Colors -- HKS 15K 020%  K 0%' => 0xE8BCCB ,
'HKS Colors -- HKS 16K 020%  K 0%' => 0xE2B9C9 ,
'HKS Colors -- HKS 17K 020%  K 0%' => 0xE3BECF ,
'HKS Colors -- HKS 18K 020%  K 0%' => 0xD1AFC4 ,
'HKS Colors -- HKS 21K 020%  K 0%' => 0xF9D5E0 ,
'HKS Colors -- HKS 22K 020%  K 0%' => 0xF6BDC7 ,
'HKS Colors -- HKS 23K 020%  K 0%' => 0xEFB9CB ,
'HKS Colors -- HKS 24K 020%  K 0%' => 0xEAB4CC ,
'HKS Colors -- HKS 25K 020%  K 0%' => 0xEBB8D6 ,
'HKS Colors -- HKS 26K 020%  K 0%' => 0xE7B7D9 ,
'HKS Colors -- HKS 27K 020%  K 0%' => 0xF6BAE1 ,
'HKS Colors -- HKS 28K 020%  K 0%' => 0xE6C5D8 ,
'HKS Colors -- HKS 29K 020%  K 0%' => 0xDABDE0 ,
'HKS Colors -- HKS 31K 020%  K 0%' => 0xECBADD ,
'HKS Colors -- HKS 32K 020%  K 0%' => 0xE3A9CF ,
'HKS Colors -- HKS 33K 020%  K 0%' => 0xE0BAEA ,
'HKS Colors -- HKS 34K 020%  K 0%' => 0xD1C0DD ,
'HKS Colors -- HKS 35K 020%  K 0%' => 0xC4BEDE ,
'HKS Colors -- HKS 36K 020%  K 0%' => 0xCBBBDE ,
'HKS Colors -- HKS 37K 020%  K 0%' => 0xCAC1D9 ,
'HKS Colors -- HKS 38K 020%  K 0%' => 0xB4BAC9 ,
'HKS Colors -- HKS 39K 020%  K 0%' => 0xC2CCF0 ,
'HKS Colors -- HKS 40K 020%  K 0%' => 0xC6D8EA ,
'HKS Colors -- HKS 41K 020%  K 0%' => 0xB5BBCD ,
'HKS Colors -- HKS 42K 020%  K 0%' => 0xC2C1E5 ,
'HKS Colors -- HKS 43K 020%  K 0%' => 0xBAC1EE ,
'HKS Colors -- HKS 44K 020%  K 0%' => 0xBDCCEA ,
'HKS Colors -- HKS 45K 020%  K 0%' => 0xCFCBE5 ,
'HKS Colors -- HKS 46K 020%  K 0%' => 0xBED0E4 ,
'HKS Colors -- HKS 47K 020%  K 0%' => 0xBDDAF4 ,
'HKS Colors -- HKS 48K 020%  K 0%' => 0xB2D8EC ,
'HKS Colors -- HKS 49K 020%  K 0%' => 0xAFD1E8 ,
'HKS Colors -- HKS 50K 020%  K 0%' => 0xCEE5F3 ,
'HKS Colors -- HKS 51K 020%  K 0%' => 0xC1DCE3 ,
'HKS Colors -- HKS 52K 020%  K 0%' => 0xB5D6D5 ,
'HKS Colors -- HKS 53K 020%  K 0%' => 0xB7E6DC ,
'HKS Colors -- HKS 54K 020%  K 0%' => 0xB0D6C9 ,
'HKS Colors -- HKS 55K 020%  K 0%' => 0xBAD5CD ,
'HKS Colors -- HKS 56K 020%  K 0%' => 0xB3C9C9 ,
'HKS Colors -- HKS 57K 020%  K 0%' => 0xBAD6C7 ,
'HKS Colors -- HKS 58K 020%  K 0%' => 0xBCC7BE ,
'HKS Colors -- HKS 59K 020%  K 0%' => 0xB0CFD4 ,
'HKS Colors -- HKS 60K 020%  K 0%' => 0xC4DBBE ,
'HKS Colors -- HKS 61K 020%  K 0%' => 0xBDC9C0 ,
'HKS Colors -- HKS 62K 020%  K 0%' => 0xCACBB8 ,
'HKS Colors -- HKS 63K 020%  K 0%' => 0xC2CFBB ,
'HKS Colors -- HKS 64K 020%  K 0%' => 0xC3DDC2 ,
'HKS Colors -- HKS 65K 020%  K 0%' => 0xC6E3B9 ,
'HKS Colors -- HKS 66K 020%  K 0%' => 0xD0E6BB ,
'HKS Colors -- HKS 67K 020%  K 0%' => 0xD3EAB5 ,
'HKS Colors -- HKS 68K 020%  K 0%' => 0xEEEBCA ,
'HKS Colors -- HKS 69K 020%  K 0%' => 0xEFEFC4 ,
'HKS Colors -- HKS 71K 020%  K 0%' => 0xF4DDC6 ,
'HKS Colors -- HKS 72K 020%  K 0%' => 0xEED7BA ,
'HKS Colors -- HKS 73K 020%  K 0%' => 0xE2D1C1 ,
'HKS Colors -- HKS 74K 020%  K 0%' => 0xD8CABD ,
'HKS Colors -- HKS 75K 020%  K 0%' => 0xD4CDC3 ,
'HKS Colors -- HKS 76K 020%  K 0%' => 0xCBC3C0 ,
'HKS Colors -- HKS 77K 020%  K 0%' => 0xCAC0C0 ,
'HKS Colors -- HKS 78K 020%  K 0%' => 0xD3BCBB ,
'HKS Colors -- HKS 81K 020%  K 0%' => 0xE7C5BC ,
'HKS Colors -- HKS 82K 020%  K 0%' => 0xDDC1BE ,
'HKS Colors -- HKS 83K 020%  K 0%' => 0xD3C2C4 ,
'HKS Colors -- HKS 84K 020%  K 0%' => 0xCBBEC3 ,
'HKS Colors -- HKS 88K 020%  K 0%' => 0xC2C0C3 ,
'HKS Colors -- HKS 89K 020%  K 0%' => 0xE1DCDB ,
'HKS Colors -- HKS 90K 020%  K 0%' => 0xC4BEC3 ,
'HKS Colors -- HKS 91K 020%  K 0%' => 0xDCDDE0 ,
'HKS Colors -- HKS 92K 020%  K 0%' => 0xD0CED1 ,
'HKS Colors -- HKS 93K 020%  K 0%' => 0xC6C5CE ,
'HKS Colors -- HKS 95K 020%  K 0%' => 0xDBD8D9 ,
'HKS Colors -- HKS 96K 020%  K 0%' => 0xDBD8DC ,
'HKS Colors -- HKS 97K 020%  K 0%' => 0xC0C1C3 ,
'HKS Colors -- HKS 01K 030%  K 0%' => 0xF6EDC5 ,
'HKS Colors -- HKS 02K 030%  K 0%' => 0xF4F0AA ,
'HKS Colors -- HKS 03K 030%  K 0%' => 0xFAF49B ,
'HKS Colors -- HKS 04K 030%  K 0%' => 0xF8E7A7 ,
'HKS Colors -- HKS 05K 030%  K 0%' => 0xFDE2A0 ,
'HKS Colors -- HKS 06K 030%  K 0%' => 0xFECFA7 ,
'HKS Colors -- HKS 07K 030%  K 0%' => 0xFFBEA5 ,
'HKS Colors -- HKS 08K 030%  K 0%' => 0xFFB8A9 ,
'HKS Colors -- HKS 10K 030%  K 0%' => 0xF7AEAB ,
'HKS Colors -- HKS 11K 030%  K 0%' => 0xFECCC3 ,
'HKS Colors -- HKS 12K 030%  K 0%' => 0xF0B0B4 ,
'HKS Colors -- HKS 13K 030%  K 0%' => 0xF5A3B1 ,
'HKS Colors -- HKS 14K 030%  K 0%' => 0xEBAEB4 ,
'HKS Colors -- HKS 15K 030%  K 0%' => 0xE3A6B4 ,
'HKS Colors -- HKS 16K 030%  K 0%' => 0xD7A0B1 ,
'HKS Colors -- HKS 17K 030%  K 0%' => 0xD9A6BC ,
'HKS Colors -- HKS 18K 030%  K 0%' => 0xC194B0 ,
'HKS Colors -- HKS 21K 030%  K 0%' => 0xF9C4D3 ,
'HKS Colors -- HKS 22K 030%  K 0%' => 0xF9A9B7 ,
'HKS Colors -- HKS 23K 030%  K 0%' => 0xEDA2B8 ,
'HKS Colors -- HKS 24K 030%  K 0%' => 0xE29AB7 ,
'HKS Colors -- HKS 25K 030%  K 0%' => 0xE5A2C5 ,
'HKS Colors -- HKS 26K 030%  K 0%' => 0xE19CC9 ,
'HKS Colors -- HKS 27K 030%  K 0%' => 0xF1A3D5 ,
'HKS Colors -- HKS 28K 030%  K 0%' => 0xDCAAC5 ,
'HKS Colors -- HKS 29K 030%  K 0%' => 0xCEA8D1 ,
'HKS Colors -- HKS 31K 030%  K 0%' => 0xE7A3D3 ,
'HKS Colors -- HKS 32K 030%  K 0%' => 0xDE98C4 ,
'HKS Colors -- HKS 33K 030%  K 0%' => 0xD3A4E4 ,
'HKS Colors -- HKS 34K 030%  K 0%' => 0xC1ADD7 ,
'HKS Colors -- HKS 35K 030%  K 0%' => 0xB5ABD5 ,
'HKS Colors -- HKS 36K 030%  K 0%' => 0xBBA9D7 ,
'HKS Colors -- HKS 37K 030%  K 0%' => 0xBAADCC ,
'HKS Colors -- HKS 38K 030%  K 0%' => 0x9EA8B8 ,
'HKS Colors -- HKS 39K 030%  K 0%' => 0xABBBEB ,
'HKS Colors -- HKS 40K 030%  K 0%' => 0xB0CBE2 ,
'HKS Colors -- HKS 41K 030%  K 0%' => 0xA4ABBE ,
'HKS Colors -- HKS 42K 030%  K 0%' => 0xA9ABDD ,
'HKS Colors -- HKS 43K 030%  K 0%' => 0x9AA9E8 ,
'HKS Colors -- HKS 44K 030%  K 0%' => 0xAABCE3 ,
'HKS Colors -- HKS 45K 030%  K 0%' => 0xBDB9DB ,
'HKS Colors -- HKS 46K 030%  K 0%' => 0xA8C4DD ,
'HKS Colors -- HKS 47K 030%  K 0%' => 0xA4CEEF ,
'HKS Colors -- HKS 48K 030%  K 0%' => 0x98CEE8 ,
'HKS Colors -- HKS 49K 030%  K 0%' => 0x94C4E3 ,
'HKS Colors -- HKS 50K 030%  K 0%' => 0xBCE1F3 ,
'HKS Colors -- HKS 51K 030%  K 0%' => 0xADD4D9 ,
'HKS Colors -- HKS 52K 030%  K 0%' => 0x9ECBC6 ,
'HKS Colors -- HKS 53K 030%  K 0%' => 0x9AE1D0 ,
'HKS Colors -- HKS 54K 030%  K 0%' => 0x97CBB7 ,
'HKS Colors -- HKS 55K 030%  K 0%' => 0xA1C6BB ,
'HKS Colors -- HKS 56K 030%  K 0%' => 0xA0BBBB ,
'HKS Colors -- HKS 57K 030%  K 0%' => 0xA4CAB4 ,
'HKS Colors -- HKS 58K 030%  K 0%' => 0xA3B5A8 ,
'HKS Colors -- HKS 59K 030%  K 0%' => 0x98C4C7 ,
'HKS Colors -- HKS 60K 030%  K 0%' => 0xB7D5AE ,
'HKS Colors -- HKS 61K 030%  K 0%' => 0xADBAAE ,
'HKS Colors -- HKS 62K 030%  K 0%' => 0xB9BAA0 ,
'HKS Colors -- HKS 63K 030%  K 0%' => 0xB0C5A9 ,
'HKS Colors -- HKS 64K 030%  K 0%' => 0xAED6AF ,
'HKS Colors -- HKS 65K 030%  K 0%' => 0xB4DEA6 ,
'HKS Colors -- HKS 66K 030%  K 0%' => 0xC0E1A3 ,
'HKS Colors -- HKS 67K 030%  K 0%' => 0xC4E6A0 ,
'HKS Colors -- HKS 68K 030%  K 0%' => 0xE8E4B3 ,
'HKS Colors -- HKS 69K 030%  K 0%' => 0xEDECAE ,
'HKS Colors -- HKS 71K 030%  K 0%' => 0xF0D4B1 ,
'HKS Colors -- HKS 72K 030%  K 0%' => 0xEAC9A3 ,
'HKS Colors -- HKS 73K 030%  K 0%' => 0xDAC5AE ,
'HKS Colors -- HKS 74K 030%  K 0%' => 0xC9B8A5 ,
'HKS Colors -- HKS 75K 030%  K 0%' => 0xC7C0B2 ,
'HKS Colors -- HKS 76K 030%  K 0%' => 0xB7AEA9 ,
'HKS Colors -- HKS 77K 030%  K 0%' => 0xBAAFAD ,
'HKS Colors -- HKS 78K 030%  K 0%' => 0xC1A8A6 ,
'HKS Colors -- HKS 81K 030%  K 0%' => 0xE0B2A6 ,
'HKS Colors -- HKS 82K 030%  K 0%' => 0xD5AEAA ,
'HKS Colors -- HKS 83K 030%  K 0%' => 0xC3AFB0 ,
'HKS Colors -- HKS 84K 030%  K 0%' => 0xBEAFB1 ,
'HKS Colors -- HKS 88K 030%  K 0%' => 0xAFADB0 ,
'HKS Colors -- HKS 89K 030%  K 0%' => 0xD9D4CF ,
'HKS Colors -- HKS 90K 030%  K 0%' => 0xB7B1B5 ,
'HKS Colors -- HKS 91K 030%  K 0%' => 0xD3D4D6 ,
'HKS Colors -- HKS 92K 030%  K 0%' => 0xC0C1C3 ,
'HKS Colors -- HKS 93K 030%  K 0%' => 0xAFB1B9 ,
'HKS Colors -- HKS 95K 030%  K 0%' => 0xCFCFCF ,
'HKS Colors -- HKS 96K 030%  K 0%' => 0xCFCDD0 ,
'HKS Colors -- HKS 97K 030%  K 0%' => 0xB2B3B5 ,
'HKS Colors -- HKS 01K 040%  K 0%' => 0xF6ECB7 ,
'HKS Colors -- HKS 02K 040%  K 0%' => 0xF3EE93 ,
'HKS Colors -- HKS 03K 040%  K 0%' => 0xFAF07F ,
'HKS Colors -- HKS 04K 040%  K 0%' => 0xF9E387 ,
'HKS Colors -- HKS 05K 040%  K 0%' => 0xFFDC85 ,
'HKS Colors -- HKS 06K 040%  K 0%' => 0xFFC48E ,
'HKS Colors -- HKS 07K 040%  K 0%' => 0xFFAF8A ,
'HKS Colors -- HKS 08K 040%  K 0%' => 0xFFA996 ,
'HKS Colors -- HKS 10K 040%  K 0%' => 0xF99692 ,
'HKS Colors -- HKS 11K 040%  K 0%' => 0xFDC1B3 ,
'HKS Colors -- HKS 12K 040%  K 0%' => 0xEE9498 ,
'HKS Colors -- HKS 13K 040%  K 0%' => 0xF58898 ,
'HKS Colors -- HKS 14K 040%  K 0%' => 0xE89198 ,
'HKS Colors -- HKS 15K 040%  K 0%' => 0xDC8DA1 ,
'HKS Colors -- HKS 16K 040%  K 0%' => 0xCA7E96 ,
'HKS Colors -- HKS 17K 040%  K 0%' => 0xCE89A5 ,
'HKS Colors -- HKS 18K 040%  K 0%' => 0xB1779A ,
'HKS Colors -- HKS 21K 040%  K 0%' => 0xF9B4C6 ,
'HKS Colors -- HKS 22K 040%  K 0%' => 0xF691A0 ,
'HKS Colors -- HKS 23K 040%  K 0%' => 0xE884A2 ,
'HKS Colors -- HKS 24K 040%  K 0%' => 0xDA7DA2 ,
'HKS Colors -- HKS 25K 040%  K 0%' => 0xDD81B1 ,
'HKS Colors -- HKS 26K 040%  K 0%' => 0xD87FB8 ,
'HKS Colors -- HKS 27K 040%  K 0%' => 0xEF89CC ,
'HKS Colors -- HKS 28K 040%  K 0%' => 0xD18AAF ,
'HKS Colors -- HKS 29K 040%  K 0%' => 0xC28FC6 ,
'HKS Colors -- HKS 31K 040%  K 0%' => 0xDD88C2 ,
'HKS Colors -- HKS 32K 040%  K 0%' => 0xD87FB8 ,
'HKS Colors -- HKS 33K 040%  K 0%' => 0xCB8BDD ,
'HKS Colors -- HKS 34K 040%  K 0%' => 0xB49BCD ,
'HKS Colors -- HKS 35K 040%  K 0%' => 0xA59BCB ,
'HKS Colors -- HKS 36K 040%  K 0%' => 0xAD93CD ,
'HKS Colors -- HKS 37K 040%  K 0%' => 0xA798C1 ,
'HKS Colors -- HKS 38K 040%  K 0%' => 0x8A94A7 ,
'HKS Colors -- HKS 39K 040%  K 0%' => 0x96A9E4 ,
'HKS Colors -- HKS 40K 040%  K 0%' => 0x9BBEDA ,
'HKS Colors -- HKS 41K 040%  K 0%' => 0x8B97AD ,
'HKS Colors -- HKS 42K 040%  K 0%' => 0x9497D7 ,
'HKS Colors -- HKS 43K 040%  K 0%' => 0x8797E4 ,
'HKS Colors -- HKS 44K 040%  K 0%' => 0x8FAADD ,
'HKS Colors -- HKS 45K 040%  K 0%' => 0xAAA6D3 ,
'HKS Colors -- HKS 46K 040%  K 0%' => 0x99BAD9 ,
'HKS Colors -- HKS 47K 040%  K 0%' => 0x8DC5ED ,
'HKS Colors -- HKS 48K 040%  K 0%' => 0x7DC3E2 ,
'HKS Colors -- HKS 49K 040%  K 0%' => 0x77B5DB ,
'HKS Colors -- HKS 50K 040%  K 0%' => 0xA8DAF1 ,
'HKS Colors -- HKS 51K 040%  K 0%' => 0x96CAD1 ,
'HKS Colors -- HKS 52K 040%  K 0%' => 0x85C0B8 ,
'HKS Colors -- HKS 53K 040%  K 0%' => 0x7DDAC4 ,
'HKS Colors -- HKS 54K 040%  K 0%' => 0x7EC2A5 ,
'HKS Colors -- HKS 55K 040%  K 0%' => 0x82B7A8 ,
'HKS Colors -- HKS 56K 040%  K 0%' => 0x8DB1AE ,
'HKS Colors -- HKS 57K 040%  K 0%' => 0x8BBEA1 ,
'HKS Colors -- HKS 58K 040%  K 0%' => 0x90A794 ,
'HKS Colors -- HKS 59K 040%  K 0%' => 0x7EB8BD ,
'HKS Colors -- HKS 60K 040%  K 0%' => 0xA5CB98 ,
'HKS Colors -- HKS 61K 040%  K 0%' => 0x9AAA99 ,
'HKS Colors -- HKS 62K 040%  K 0%' => 0xAEB091 ,
'HKS Colors -- HKS 63K 040%  K 0%' => 0xA3BB98 ,
'HKS Colors -- HKS 64K 040%  K 0%' => 0x98CD97 ,
'HKS Colors -- HKS 65K 040%  K 0%' => 0xA4D88E ,
'HKS Colors -- HKS 66K 040%  K 0%' => 0xAFD985 ,
'HKS Colors -- HKS 67K 040%  K 0%' => 0xB9E388 ,
'HKS Colors -- HKS 68K 040%  K 0%' => 0xE5DE9C ,
'HKS Colors -- HKS 69K 040%  K 0%' => 0xE8E896 ,
'HKS Colors -- HKS 71K 040%  K 0%' => 0xEDCA9A ,
'HKS Colors -- HKS 72K 040%  K 0%' => 0xE4BD8E ,
'HKS Colors -- HKS 73K 040%  K 0%' => 0xD4B99A ,
'HKS Colors -- HKS 74K 040%  K 0%' => 0xBDA890 ,
'HKS Colors -- HKS 75K 040%  K 0%' => 0xB8AE9A ,
'HKS Colors -- HKS 76K 040%  K 0%' => 0x96897E ,
'HKS Colors -- HKS 77K 040%  K 0%' => 0xA89A94 ,
'HKS Colors -- HKS 78K 040%  K 0%' => 0xB49691 ,
'HKS Colors -- HKS 81K 040%  K 0%' => 0xD9A08F ,
'HKS Colors -- HKS 82K 040%  K 0%' => 0xCD9E97 ,
'HKS Colors -- HKS 83K 040%  K 0%' => 0xB49B99 ,
'HKS Colors -- HKS 84K 040%  K 0%' => 0xAB979A ,
'HKS Colors -- HKS 88K 040%  K 0%' => 0x99979A ,
'HKS Colors -- HKS 89K 040%  K 0%' => 0xD3CDC6 ,
'HKS Colors -- HKS 90K 040%  K 0%' => 0xA39DA2 ,
'HKS Colors -- HKS 91K 040%  K 0%' => 0xC2C6C7 ,
'HKS Colors -- HKS 92K 040%  K 0%' => 0xB1B1B3 ,
'HKS Colors -- HKS 93K 040%  K 0%' => 0x989BA4 ,
'HKS Colors -- HKS 95K 040%  K 0%' => 0xC6C5C3 ,
'HKS Colors -- HKS 96K 040%  K 0%' => 0xC3C0C1 ,
'HKS Colors -- HKS 97K 040%  K 0%' => 0x9CA0A1 ,
'HKS Colors -- HKS 01K 050%  K 0%' => 0xF7EBA8 ,
'HKS Colors -- HKS 02K 050%  K 0%' => 0xF1EC7C ,
'HKS Colors -- HKS 03K 050%  K 0%' => 0xF9EE68 ,
'HKS Colors -- HKS 04K 050%  K 0%' => 0xF8E068 ,
'HKS Colors -- HKS 05K 050%  K 0%' => 0xFFD96F ,
'HKS Colors -- HKS 06K 050%  K 0%' => 0xFFBA74 ,
'HKS Colors -- HKS 07K 050%  K 0%' => 0xFFA070 ,
'HKS Colors -- HKS 08K 050%  K 0%' => 0xFF9B81 ,
'HKS Colors -- HKS 10K 050%  K 0%' => 0xF87F77 ,
'HKS Colors -- HKS 11K 050%  K 0%' => 0xFFB8A9 ,
'HKS Colors -- HKS 12K 050%  K 0%' => 0xEC7B7D ,
'HKS Colors -- HKS 13K 050%  K 0%' => 0xF46A7E ,
'HKS Colors -- HKS 14K 050%  K 0%' => 0xE37B80 ,
'HKS Colors -- HKS 15K 050%  K 0%' => 0xD7748A ,
'HKS Colors -- HKS 16K 050%  K 0%' => 0xC0637D ,
'HKS Colors -- HKS 17K 050%  K 0%' => 0xC56F91 ,
'HKS Colors -- HKS 18K 050%  K 0%' => 0xA46387 ,
'HKS Colors -- HKS 21K 050%  K 0%' => 0xFCA7BE ,
'HKS Colors -- HKS 22K 050%  K 0%' => 0xF78090 ,
'HKS Colors -- HKS 23K 050%  K 0%' => 0xE66B8F ,
'HKS Colors -- HKS 24K 050%  K 0%' => 0xD66996 ,
'HKS Colors -- HKS 25K 050%  K 0%' => 0xD869A2 ,
'HKS Colors -- HKS 26K 050%  K 0%' => 0xD068AA ,
'HKS Colors -- HKS 27K 050%  K 0%' => 0xED6FC1 ,
'HKS Colors -- HKS 28K 050%  K 0%' => 0xCA72A0 ,
'HKS Colors -- HKS 29K 050%  K 0%' => 0xB77CBD ,
'HKS Colors -- HKS 31K 050%  K 0%' => 0xDC6DB8 ,
'HKS Colors -- HKS 32K 050%  K 0%' => 0xD36BAA ,
'HKS Colors -- HKS 33K 050%  K 0%' => 0xC376D6 ,
'HKS Colors -- HKS 34K 050%  K 0%' => 0xA584C2 ,
'HKS Colors -- HKS 35K 050%  K 0%' => 0x9386C2 ,
'HKS Colors -- HKS 36K 050%  K 0%' => 0x9E80C4 ,
'HKS Colors -- HKS 37K 050%  K 0%' => 0x9785B4 ,
'HKS Colors -- HKS 38K 050%  K 0%' => 0x748299 ,
'HKS Colors -- HKS 39K 050%  K 0%' => 0x7F9AE1 ,
'HKS Colors -- HKS 40K 050%  K 0%' => 0x87B4D5 ,
'HKS Colors -- HKS 41K 050%  K 0%' => 0x77859D ,
'HKS Colors -- HKS 42K 050%  K 0%' => 0x7F84CF ,
'HKS Colors -- HKS 43K 050%  K 0%' => 0x7586E1 ,
'HKS Colors -- HKS 44K 050%  K 0%' => 0x7B9BD6 ,
'HKS Colors -- HKS 45K 050%  K 0%' => 0x9C99CE ,
'HKS Colors -- HKS 46K 050%  K 0%' => 0x89B0D3 ,
'HKS Colors -- HKS 47K 050%  K 0%' => 0x74BBEA ,
'HKS Colors -- HKS 48K 050%  K 0%' => 0x60BADD ,
'HKS Colors -- HKS 49K 050%  K 0%' => 0x5CABD6 ,
'HKS Colors -- HKS 50K 050%  K 0%' => 0x97D5ED ,
'HKS Colors -- HKS 51K 050%  K 0%' => 0x7FC2C7 ,
'HKS Colors -- HKS 52K 050%  K 0%' => 0x6FB5AE ,
'HKS Colors -- HKS 53K 050%  K 0%' => 0x63D4BA ,
'HKS Colors -- HKS 54K 050%  K 0%' => 0x60B793 ,
'HKS Colors -- HKS 55K 050%  K 0%' => 0x69A996 ,
'HKS Colors -- HKS 56K 050%  K 0%' => 0x78A4A0 ,
'HKS Colors -- HKS 57K 050%  K 0%' => 0x71B18B ,
'HKS Colors -- HKS 58K 050%  K 0%' => 0x7C987F ,
'HKS Colors -- HKS 59K 050%  K 0%' => 0x68AEB2 ,
'HKS Colors -- HKS 60K 050%  K 0%' => 0x92C485 ,
'HKS Colors -- HKS 61K 050%  K 0%' => 0x889C86 ,
'HKS Colors -- HKS 62K 050%  K 0%' => 0xA2A57C ,
'HKS Colors -- HKS 63K 050%  K 0%' => 0x92B185 ,
'HKS Colors -- HKS 64K 050%  K 0%' => 0x85C580 ,
'HKS Colors -- HKS 65K 050%  K 0%' => 0x93D578 ,
'HKS Colors -- HKS 66K 050%  K 0%' => 0xA1D56E ,
'HKS Colors -- HKS 67K 050%  K 0%' => 0xAEE074 ,
'HKS Colors -- HKS 68K 050%  K 0%' => 0xE1DB89 ,
'HKS Colors -- HKS 69K 050%  K 0%' => 0xE3E680 ,
'HKS Colors -- HKS 71K 050%  K 0%' => 0xEBC288 ,
'HKS Colors -- HKS 72K 050%  K 0%' => 0xE2B378 ,
'HKS Colors -- HKS 73K 050%  K 0%' => 0xCCAF88 ,
'HKS Colors -- HKS 74K 050%  K 0%' => 0xB49B7E ,
'HKS Colors -- HKS 75K 050%  K 0%' => 0xAAA387 ,
'HKS Colors -- HKS 76K 050%  K 0%' => 0x847566 ,
'HKS Colors -- HKS 77K 050%  K 0%' => 0x9A877F ,
'HKS Colors -- HKS 78K 050%  K 0%' => 0xA9857D ,
'HKS Colors -- HKS 81K 050%  K 0%' => 0xD6927F ,
'HKS Colors -- HKS 82K 050%  K 0%' => 0xC58F86 ,
'HKS Colors -- HKS 83K 050%  K 0%' => 0xA68785 ,
'HKS Colors -- HKS 84K 050%  K 0%' => 0x9C8485 ,
'HKS Colors -- HKS 88K 050%  K 0%' => 0x828285 ,
'HKS Colors -- HKS 89K 050%  K 0%' => 0xCCC5BC ,
'HKS Colors -- HKS 90K 050%  K 0%' => 0x938E90 ,
'HKS Colors -- HKS 91K 050%  K 0%' => 0xB9C0BD ,
'HKS Colors -- HKS 92K 050%  K 0%' => 0xA5A5A8 ,
'HKS Colors -- HKS 93K 050%  K 0%' => 0x848790 ,
'HKS Colors -- HKS 95K 050%  K 0%' => 0xBCBBB9 ,
'HKS Colors -- HKS 96K 050%  K 0%' => 0xB5B5B5 ,
'HKS Colors -- HKS 97K 050%  K 0%' => 0x8A8E8D ,
'HKS Colors -- HKS 01K 060%  K 0%' => 0xF5E897 ,
'HKS Colors -- HKS 02K 060%  K 0%' => 0xF1E85B ,
'HKS Colors -- HKS 03K 060%  K 0%' => 0xF9ED46 ,
'HKS Colors -- HKS 04K 060%  K 0%' => 0xF7D939 ,
'HKS Colors -- HKS 05K 060%  K 0%' => 0xFFD453 ,
'HKS Colors -- HKS 06K 060%  K 0%' => 0xFFAE57 ,
'HKS Colors -- HKS 07K 060%  K 0%' => 0xFF8E52 ,
'HKS Colors -- HKS 08K 060%  K 0%' => 0xFF8663 ,
'HKS Colors -- HKS 10K 060%  K 0%' => 0xF75F52 ,
'HKS Colors -- HKS 11K 060%  K 0%' => 0xFFAB97 ,
'HKS Colors -- HKS 12K 060%  K 0%' => 0xE7585B ,
'HKS Colors -- HKS 13K 060%  K 0%' => 0xF0445C ,
'HKS Colors -- HKS 14K 060%  K 0%' => 0xDE5B60 ,
'HKS Colors -- HKS 15K 060%  K 0%' => 0xCE4F6B ,
'HKS Colors -- HKS 16K 060%  K 0%' => 0xB33E60 ,
'HKS Colors -- HKS 17K 060%  K 0%' => 0xB94373 ,
'HKS Colors -- HKS 18K 060%  K 0%' => 0x943E6B ,
'HKS Colors -- HKS 21K 060%  K 0%' => 0xFC98B0 ,
'HKS Colors -- HKS 22K 060%  K 0%' => 0xF56074 ,
'HKS Colors -- HKS 23K 060%  K 0%' => 0xE24F78 ,
'HKS Colors -- HKS 24K 060%  K 0%' => 0xD05284 ,
'HKS Colors -- HKS 25K 060%  K 0%' => 0xD3498F ,
'HKS Colors -- HKS 26K 060%  K 0%' => 0xC74397 ,
'HKS Colors -- HKS 27K 060%  K 0%' => 0xE649B3 ,
'HKS Colors -- HKS 28K 060%  K 0%' => 0xC04F87 ,
'HKS Colors -- HKS 29K 060%  K 0%' => 0xAE64B0 ,
'HKS Colors -- HKS 31K 060%  K 0%' => 0xD44EA7 ,
'HKS Colors -- HKS 32K 060%  K 0%' => 0xCA3C92 ,
'HKS Colors -- HKS 33K 060%  K 0%' => 0xB758CF ,
'HKS Colors -- HKS 34K 060%  K 0%' => 0x8E61B0 ,
'HKS Colors -- HKS 35K 060%  K 0%' => 0x7664AE ,
'HKS Colors -- HKS 36K 060%  K 0%' => 0x8963B8 ,
'HKS Colors -- HKS 37K 060%  K 0%' => 0x806AA5 ,
'HKS Colors -- HKS 38K 060%  K 0%' => 0x586880 ,
'HKS Colors -- HKS 39K 060%  K 0%' => 0x6888DB ,
'HKS Colors -- HKS 40K 060%  K 0%' => 0x68A4CD ,
'HKS Colors -- HKS 41K 060%  K 0%' => 0x606E89 ,
'HKS Colors -- HKS 42K 060%  K 0%' => 0x676BC4 ,
'HKS Colors -- HKS 43K 060%  K 0%' => 0x566DDB ,
'HKS Colors -- HKS 44K 060%  K 0%' => 0x5C87CE ,
'HKS Colors -- HKS 45K 060%  K 0%' => 0x8782C3 ,
'HKS Colors -- HKS 46K 060%  K 0%' => 0x78A5CD ,
'HKS Colors -- HKS 47K 060%  K 0%' => 0x4BA9E4 ,
'HKS Colors -- HKS 48K 060%  K 0%' => 0x35AED8 ,
'HKS Colors -- HKS 49K 060%  K 0%' => 0x369DCF ,
'HKS Colors -- HKS 50K 060%  K 0%' => 0x80CDED ,
'HKS Colors -- HKS 51K 060%  K 0%' => 0x61B5C0 ,
'HKS Colors -- HKS 52K 060%  K 0%' => 0x4BA699 ,
'HKS Colors -- HKS 53K 060%  K 0%' => 0x34CDAA ,
'HKS Colors -- HKS 54K 060%  K 0%' => 0x2EA778 ,
'HKS Colors -- HKS 55K 060%  K 0%' => 0x4A9A80 ,
'HKS Colors -- HKS 56K 060%  K 0%' => 0x5C9189 ,
'HKS Colors -- HKS 57K 060%  K 0%' => 0x41A069 ,
'HKS Colors -- HKS 58K 060%  K 0%' => 0x5C7F5F ,
'HKS Colors -- HKS 59K 060%  K 0%' => 0x47A1A3 ,
'HKS Colors -- HKS 60K 060%  K 0%' => 0x7AB565 ,
'HKS Colors -- HKS 61K 060%  K 0%' => 0x698566 ,
'HKS Colors -- HKS 62K 060%  K 0%' => 0x898F5D ,
'HKS Colors -- HKS 63K 060%  K 0%' => 0x7BA068 ,
'HKS Colors -- HKS 64K 060%  K 0%' => 0x64B95B ,
'HKS Colors -- HKS 65K 060%  K 0%' => 0x7BCC5D ,
'HKS Colors -- HKS 66K 060%  K 0%' => 0x8DCC47 ,
'HKS Colors -- HKS 67K 060%  K 0%' => 0xA3DC5E ,
'HKS Colors -- HKS 68K 060%  K 0%' => 0xDCD56D ,
'HKS Colors -- HKS 69K 060%  K 0%' => 0xE0E360 ,
'HKS Colors -- HKS 71K 060%  K 0%' => 0xE8B870 ,
'HKS Colors -- HKS 72K 060%  K 0%' => 0xDDA356 ,
'HKS Colors -- HKS 73K 060%  K 0%' => 0xC29D6D ,
'HKS Colors -- HKS 74K 060%  K 0%' => 0xA58760 ,
'HKS Colors -- HKS 75K 060%  K 0%' => 0x9B8D69 ,
'HKS Colors -- HKS 76K 060%  K 0%' => 0x6E5D4A ,
'HKS Colors -- HKS 77K 060%  K 0%' => 0x866E61 ,
'HKS Colors -- HKS 78K 060%  K 0%' => 0x986D63 ,
'HKS Colors -- HKS 81K 060%  K 0%' => 0xCE7F65 ,
'HKS Colors -- HKS 82K 060%  K 0%' => 0xBB776A ,
'HKS Colors -- HKS 83K 060%  K 0%' => 0x90645F ,
'HKS Colors -- HKS 84K 060%  K 0%' => 0x805F5F ,
'HKS Colors -- HKS 88K 060%  K 0%' => 0x69696B ,
'HKS Colors -- HKS 89K 060%  K 0%' => 0xC2BAAF ,
'HKS Colors -- HKS 90K 060%  K 0%' => 0x7C7476 ,
'HKS Colors -- HKS 91K 060%  K 0%' => 0xAAB4B1 ,
'HKS Colors -- HKS 92K 060%  K 0%' => 0x8F9394 ,
'HKS Colors -- HKS 93K 060%  K 0%' => 0x686F77 ,
'HKS Colors -- HKS 95K 060%  K 0%' => 0xB0AFA9 ,
'HKS Colors -- HKS 96K 060%  K 0%' => 0xA5A4A2 ,
'HKS Colors -- HKS 97K 060%  K 0%' => 0x747875 ,
'HKS Colors -- HKS 01K 070%  K 0%' => 0xF6E68A ,
'HKS Colors -- HKS 02K 070%  K 0%' => 0xF1E842 ,
'HKS Colors -- HKS 03K 070%  K 0%' => 0xF9ED24 ,
'HKS Colors -- HKS 04K 070%  K 0%' => 0xF8D413 ,
'HKS Colors -- HKS 05K 070%  K 0%' => 0xFFCD33 ,
'HKS Colors -- HKS 06K 070%  K 0%' => 0xFFA43E ,
'HKS Colors -- HKS 07K 070%  K 0%' => 0xFF7E33 ,
'HKS Colors -- HKS 08K 070%  K 0%' => 0xFF754A ,
'HKS Colors -- HKS 10K 070%  K 0%' => 0xF64934 ,
'HKS Colors -- HKS 11K 070%  K 0%' => 0xFFA38A ,
'HKS Colors -- HKS 12K 070%  K 0%' => 0xE64041 ,
'HKS Colors -- HKS 13K 070%  K 0%' => 0xEF2643 ,
'HKS Colors -- HKS 14K 070%  K 0%' => 0xDA444B ,
'HKS Colors -- HKS 15K 070%  K 0%' => 0xC73658 ,
'HKS Colors -- HKS 16K 070%  K 0%' => 0xA92A4D ,
'HKS Colors -- HKS 17K 070%  K 0%' => 0xB02B60 ,
'HKS Colors -- HKS 18K 070%  K 0%' => 0x87295A ,
'HKS Colors -- HKS 21K 070%  K 0%' => 0xFA8BA6 ,
'HKS Colors -- HKS 22K 070%  K 0%' => 0xF54B60 ,
'HKS Colors -- HKS 23K 070%  K 0%' => 0xDD3667 ,
'HKS Colors -- HKS 24K 070%  K 0%' => 0xCA4076 ,
'HKS Colors -- HKS 25K 070%  K 0%' => 0xD0307F ,
'HKS Colors -- HKS 26K 070%  K 0%' => 0xC02288 ,
'HKS Colors -- HKS 27K 070%  K 0%' => 0xE42BA9 ,
'HKS Colors -- HKS 28K 070%  K 0%' => 0xB73377 ,
'HKS Colors -- HKS 29K 070%  K 0%' => 0xA453A8 ,
'HKS Colors -- HKS 31K 070%  K 0%' => 0xCE369D ,
'HKS Colors -- HKS 32K 070%  K 0%' => 0xC21C82 ,
'HKS Colors -- HKS 33K 070%  K 0%' => 0xAF40C9 ,
'HKS Colors -- HKS 34K 070%  K 0%' => 0x7C47A4 ,
'HKS Colors -- HKS 35K 070%  K 0%' => 0x5E499D ,
'HKS Colors -- HKS 36K 070%  K 0%' => 0x7449A9 ,
'HKS Colors -- HKS 37K 070%  K 0%' => 0x725798 ,
'HKS Colors -- HKS 38K 070%  K 0%' => 0x43536E ,
'HKS Colors -- HKS 39K 070%  K 0%' => 0x577AD7 ,
'HKS Colors -- HKS 40K 070%  K 0%' => 0x5699C5 ,
'HKS Colors -- HKS 41K 070%  K 0%' => 0x4B5A77 ,
'HKS Colors -- HKS 42K 070%  K 0%' => 0x575ABC ,
'HKS Colors -- HKS 43K 070%  K 0%' => 0x415BD6 ,
'HKS Colors -- HKS 44K 070%  K 0%' => 0x4475C9 ,
'HKS Colors -- HKS 45K 070%  K 0%' => 0x7873B9 ,
'HKS Colors -- HKS 46K 070%  K 0%' => 0x679AC4 ,
'HKS Colors -- HKS 47K 070%  K 0%' => 0x2BA0E1 ,
'HKS Colors -- HKS 48K 070%  K 0%' => 0x16A5D4 ,
'HKS Colors -- HKS 49K 070%  K 0%' => 0x1691C6 ,
'HKS Colors -- HKS 50K 070%  K 0%' => 0x6FC7EB ,
'HKS Colors -- HKS 51K 070%  K 0%' => 0x4AABB4 ,
'HKS Colors -- HKS 52K 070%  K 0%' => 0x2B9B8A ,
'HKS Colors -- HKS 53K 070%  K 0%' => 0x07C69E ,
'HKS Colors -- HKS 54K 070%  K 0%' => 0x009D65 ,
'HKS Colors -- HKS 55K 070%  K 0%' => 0x298B6E ,
'HKS Colors -- HKS 56K 070%  K 0%' => 0x428077 ,
'HKS Colors -- HKS 57K 070%  K 0%' => 0x249353 ,
'HKS Colors -- HKS 58K 070%  K 0%' => 0x476F4B ,
'HKS Colors -- HKS 59K 070%  K 0%' => 0x269496 ,
'HKS Colors -- HKS 60K 070%  K 0%' => 0x61A94A ,
'HKS Colors -- HKS 61K 070%  K 0%' => 0x4D6F4A ,
'HKS Colors -- HKS 62K 070%  K 0%' => 0x7A7F46 ,
'HKS Colors -- HKS 63K 070%  K 0%' => 0x638E4B ,
'HKS Colors -- HKS 64K 070%  K 0%' => 0x46AD3D ,
'HKS Colors -- HKS 65K 070%  K 0%' => 0x66C340 ,
'HKS Colors -- HKS 66K 070%  K 0%' => 0x7CC726 ,
'HKS Colors -- HKS 67K 070%  K 0%' => 0x92D83D ,
'HKS Colors -- HKS 68K 070%  K 0%' => 0xD9CE57 ,
'HKS Colors -- HKS 69K 070%  K 0%' => 0xDCDE49 ,
'HKS Colors -- HKS 71K 070%  K 0%' => 0xE3AD58 ,
'HKS Colors -- HKS 72K 070%  K 0%' => 0xD6963B ,
'HKS Colors -- HKS 73K 070%  K 0%' => 0xB89054 ,
'HKS Colors -- HKS 74K 070%  K 0%' => 0x9B7B4D ,
'HKS Colors -- HKS 75K 070%  K 0%' => 0x908058 ,
'HKS Colors -- HKS 76K 070%  K 0%' => 0x614E3B ,
'HKS Colors -- HKS 77K 070%  K 0%' => 0x745B4A ,
'HKS Colors -- HKS 78K 070%  K 0%' => 0x8A584C ,
'HKS Colors -- HKS 81K 070%  K 0%' => 0xCA7053 ,
'HKS Colors -- HKS 82K 070%  K 0%' => 0xB16757 ,
'HKS Colors -- HKS 83K 070%  K 0%' => 0x82534B ,
'HKS Colors -- HKS 84K 070%  K 0%' => 0x724A47 ,
'HKS Colors -- HKS 88K 070%  K 0%' => 0x575757 ,
'HKS Colors -- HKS 89K 070%  K 0%' => 0xBAB1A2 ,
'HKS Colors -- HKS 90K 070%  K 0%' => 0x685F60 ,
'HKS Colors -- HKS 91K 070%  K 0%' => 0xA2AAA8 ,
'HKS Colors -- HKS 92K 070%  K 0%' => 0x818586 ,
'HKS Colors -- HKS 93K 070%  K 0%' => 0x5A6069 ,
'HKS Colors -- HKS 95K 070%  K 0%' => 0xA3A49C ,
'HKS Colors -- HKS 96K 070%  K 0%' => 0x979693 ,
'HKS Colors -- HKS 97K 070%  K 0%' => 0x5E635F ,
'HKS Colors -- HKS 01K 080%  K 0%' => 0xF7E374 ,
'HKS Colors -- HKS 02K 080%  K 0%' => 0xEEE414 ,
'HKS Colors -- HKS 03K 080%  K 0%' => 0xFCEC00 ,
'HKS Colors -- HKS 04K 080%  K 0%' => 0xFACD00 ,
'HKS Colors -- HKS 05K 080%  K 0%' => 0xFFC500 ,
'HKS Colors -- HKS 06K 080%  K 0%' => 0xFF9211 ,
'HKS Colors -- HKS 07K 080%  K 0%' => 0xFF6B00 ,
'HKS Colors -- HKS 08K 080%  K 0%' => 0xFF6128 ,
'HKS Colors -- HKS 10K 080%  K 0%' => 0xF4351E ,
'HKS Colors -- HKS 11K 080%  K 0%' => 0xFF947A ,
'HKS Colors -- HKS 12K 080%  K 0%' => 0xE12425 ,
'HKS Colors -- HKS 13K 080%  K 0%' => 0xEC0D2F ,
'HKS Colors -- HKS 14K 080%  K 0%' => 0xD62B36 ,
'HKS Colors -- HKS 15K 080%  K 0%' => 0xC01941 ,
'HKS Colors -- HKS 16K 080%  K 0%' => 0xA0183B ,
'HKS Colors -- HKS 17K 080%  K 0%' => 0xA6124E ,
'HKS Colors -- HKS 18K 080%  K 0%' => 0x760E42 ,
'HKS Colors -- HKS 21K 080%  K 0%' => 0xF87C9A ,
'HKS Colors -- HKS 22K 080%  K 0%' => 0xF02E45 ,
'HKS Colors -- HKS 23K 080%  K 0%' => 0xDB1652 ,
'HKS Colors -- HKS 24K 080%  K 0%' => 0xC42966 ,
'HKS Colors -- HKS 25K 080%  K 0%' => 0xCA026D ,
'HKS Colors -- HKS 26K 080%  K 0%' => 0xB7007A ,
'HKS Colors -- HKS 27K 080%  K 0%' => 0xE1009B ,
'HKS Colors -- HKS 28K 080%  K 0%' => 0xAD1463 ,
'HKS Colors -- HKS 29K 080%  K 0%' => 0x983999 ,
'HKS Colors -- HKS 31K 080%  K 0%' => 0xC5128F ,
'HKS Colors -- HKS 32K 080%  K 0%' => 0xB8006F ,
'HKS Colors -- HKS 33K 080%  K 0%' => 0xA41ABC ,
'HKS Colors -- HKS 34K 080%  K 0%' => 0x6A2B93 ,
'HKS Colors -- HKS 35K 080%  K 0%' => 0x4A318D ,
'HKS Colors -- HKS 36K 080%  K 0%' => 0x602B98 ,
'HKS Colors -- HKS 37K 080%  K 0%' => 0x5D3984 ,
'HKS Colors -- HKS 38K 080%  K 0%' => 0x243856 ,
'HKS Colors -- HKS 39K 080%  K 0%' => 0x3B68D0 ,
'HKS Colors -- HKS 40K 080%  K 0%' => 0x3C8BBD ,
'HKS Colors -- HKS 41K 080%  K 0%' => 0x314263 ,
'HKS Colors -- HKS 42K 080%  K 0%' => 0x3C41AF ,
'HKS Colors -- HKS 43K 080%  K 0%' => 0x2E46CF ,
'HKS Colors -- HKS 44K 080%  K 0%' => 0x2663BD ,
'HKS Colors -- HKS 45K 080%  K 0%' => 0x6660B0 ,
'HKS Colors -- HKS 46K 080%  K 0%' => 0x4D8BBB ,
'HKS Colors -- HKS 47K 080%  K 0%' => 0x0093DC ,
'HKS Colors -- HKS 48K 080%  K 0%' => 0x009CCD ,
'HKS Colors -- HKS 49K 080%  K 0%' => 0x0087C1 ,
'HKS Colors -- HKS 50K 080%  K 0%' => 0x54C0E5 ,
'HKS Colors -- HKS 51K 080%  K 0%' => 0x24A0A9 ,
'HKS Colors -- HKS 52K 080%  K 0%' => 0x008E7B ,
'HKS Colors -- HKS 53K 080%  K 0%' => 0x00C097 ,
'HKS Colors -- HKS 54K 080%  K 0%' => 0x009058 ,
'HKS Colors -- HKS 55K 080%  K 0%' => 0x007856 ,
'HKS Colors -- HKS 56K 080%  K 0%' => 0x216D5E ,
'HKS Colors -- HKS 57K 080%  K 0%' => 0x00843E ,
'HKS Colors -- HKS 58K 080%  K 0%' => 0x335F35 ,
'HKS Colors -- HKS 59K 080%  K 0%' => 0x008687 ,
'HKS Colors -- HKS 60K 080%  K 0%' => 0x419827 ,
'HKS Colors -- HKS 61K 080%  K 0%' => 0x32562E ,
'HKS Colors -- HKS 62K 080%  K 0%' => 0x656B29 ,
'HKS Colors -- HKS 63K 080%  K 0%' => 0x477A2D ,
'HKS Colors -- HKS 64K 080%  K 0%' => 0x2FA328 ,
'HKS Colors -- HKS 65K 080%  K 0%' => 0x47B819 ,
'HKS Colors -- HKS 66K 080%  K 0%' => 0x6EC102 ,
'HKS Colors -- HKS 67K 080%  K 0%' => 0x7DCE11 ,
'HKS Colors -- HKS 68K 080%  K 0%' => 0xD0C533 ,
'HKS Colors -- HKS 69K 080%  K 0%' => 0xD7DA24 ,
'HKS Colors -- HKS 71K 080%  K 0%' => 0xDDA13B ,
'HKS Colors -- HKS 72K 080%  K 0%' => 0xD08518 ,
'HKS Colors -- HKS 73K 080%  K 0%' => 0xAF7E39 ,
'HKS Colors -- HKS 74K 080%  K 0%' => 0x8D6935 ,
'HKS Colors -- HKS 75K 080%  K 0%' => 0x7B6A36 ,
'HKS Colors -- HKS 76K 080%  K 0%' => 0x52402A ,
'HKS Colors -- HKS 77K 080%  K 0%' => 0x61432F ,
'HKS Colors -- HKS 78K 080%  K 0%' => 0x76402F ,
'HKS Colors -- HKS 81K 080%  K 0%' => 0xC05B35 ,
'HKS Colors -- HKS 82K 080%  K 0%' => 0xA34D38 ,
'HKS Colors -- HKS 83K 080%  K 0%' => 0x733C32 ,
'HKS Colors -- HKS 84K 080%  K 0%' => 0x613633 ,
'HKS Colors -- HKS 88K 080%  K 0%' => 0x3D3D3D ,
'HKS Colors -- HKS 89K 080%  K 0%' => 0xAFA694 ,
'HKS Colors -- HKS 90K 080%  K 0%' => 0x4C4342 ,
'HKS Colors -- HKS 91K 080%  K 0%' => 0x96A19D ,
'HKS Colors -- HKS 92K 080%  K 0%' => 0x6F7273 ,
'HKS Colors -- HKS 93K 080%  K 0%' => 0x494E56 ,
'HKS Colors -- HKS 95K 080%  K 0%' => 0x97978D ,
'HKS Colors -- HKS 96K 080%  K 0%' => 0x878681 ,
'HKS Colors -- HKS 97K 080%  K 0%' => 0x424742 ,
'HKS Colors -- HKS 01K 090%  K 0%' => 0xF6E163 ,
'HKS Colors -- HKS 02K 090%  K 0%' => 0xEEE200 ,
'HKS Colors -- HKS 03K 090%  K 0%' => 0xFAEA00 ,
'HKS Colors -- HKS 04K 090%  K 0%' => 0xFDC700 ,
'HKS Colors -- HKS 05K 090%  K 0%' => 0xFFC000 ,
'HKS Colors -- HKS 06K 090%  K 0%' => 0xFF8A00 ,
'HKS Colors -- HKS 07K 090%  K 0%' => 0xFF6300 ,
'HKS Colors -- HKS 08K 090%  K 0%' => 0xFD510D ,
'HKS Colors -- HKS 10K 090%  K 0%' => 0xF3270E ,
'HKS Colors -- HKS 11K 090%  K 0%' => 0xFF8667 ,
'HKS Colors -- HKS 12K 090%  K 0%' => 0xDB0910 ,
'HKS Colors -- HKS 13K 090%  K 0%' => 0xE80021 ,
'HKS Colors -- HKS 14K 090%  K 0%' => 0xD01B26 ,
'HKS Colors -- HKS 15K 090%  K 0%' => 0xBA002E ,
'HKS Colors -- HKS 16K 090%  K 0%' => 0x960B2D ,
'HKS Colors -- HKS 17K 090%  K 0%' => 0x9A003B ,
'HKS Colors -- HKS 18K 090%  K 0%' => 0x6B0234 ,
'HKS Colors -- HKS 21K 090%  K 0%' => 0xF76D8F ,
'HKS Colors -- HKS 22K 090%  K 0%' => 0xED182F ,
'HKS Colors -- HKS 23K 090%  K 0%' => 0xD50041 ,
'HKS Colors -- HKS 24K 090%  K 0%' => 0xBC0F55 ,
'HKS Colors -- HKS 25K 090%  K 0%' => 0xC30060 ,
'HKS Colors -- HKS 26K 090%  K 0%' => 0xB0006E ,
'HKS Colors -- HKS 27K 090%  K 0%' => 0xDA0093 ,
'HKS Colors -- HKS 28K 090%  K 0%' => 0xA3004F ,
'HKS Colors -- HKS 29K 090%  K 0%' => 0x871387 ,
'HKS Colors -- HKS 31K 090%  K 0%' => 0xBD0082 ,
'HKS Colors -- HKS 32K 090%  K 0%' => 0xAF0061 ,
'HKS Colors -- HKS 33K 090%  K 0%' => 0x9A00B0 ,
'HKS Colors -- HKS 34K 090%  K 0%' => 0x5C1786 ,
'HKS Colors -- HKS 35K 090%  K 0%' => 0x3C2380 ,
'HKS Colors -- HKS 36K 090%  K 0%' => 0x4F198A ,
'HKS Colors -- HKS 37K 090%  K 0%' => 0x492074 ,
'HKS Colors -- HKS 38K 090%  K 0%' => 0x132642 ,
'HKS Colors -- HKS 39K 090%  K 0%' => 0x2758CA ,
'HKS Colors -- HKS 40K 090%  K 0%' => 0x187BB1 ,
'HKS Colors -- HKS 41K 090%  K 0%' => 0x1B2D4D ,
'HKS Colors -- HKS 42K 090%  K 0%' => 0x2529A4 ,
'HKS Colors -- HKS 43K 090%  K 0%' => 0x1E2FC5 ,
'HKS Colors -- HKS 44K 090%  K 0%' => 0x0B51B2 ,
'HKS Colors -- HKS 45K 090%  K 0%' => 0x544CA4 ,
'HKS Colors -- HKS 46K 090%  K 0%' => 0x367DB4 ,
'HKS Colors -- HKS 47K 090%  K 0%' => 0x008BD6 ,
'HKS Colors -- HKS 48K 090%  K 0%' => 0x0094C4 ,
'HKS Colors -- HKS 49K 090%  K 0%' => 0x007DB5 ,
'HKS Colors -- HKS 50K 090%  K 0%' => 0x3AB8E3 ,
'HKS Colors -- HKS 51K 090%  K 0%' => 0x00939B ,
'HKS Colors -- HKS 52K 090%  K 0%' => 0x00816E ,
'HKS Colors -- HKS 53K 090%  K 0%' => 0x00B98F ,
'HKS Colors -- HKS 54K 090%  K 0%' => 0x008652 ,
'HKS Colors -- HKS 55K 090%  K 0%' => 0x006B4A ,
'HKS Colors -- HKS 56K 090%  K 0%' => 0x005242 ,
'HKS Colors -- HKS 57K 090%  K 0%' => 0x007838 ,
'HKS Colors -- HKS 58K 090%  K 0%' => 0x245227 ,
'HKS Colors -- HKS 59K 090%  K 0%' => 0x007777 ,
'HKS Colors -- HKS 60K 090%  K 0%' => 0x288A08 ,
'HKS Colors -- HKS 61K 090%  K 0%' => 0x1E451C ,
'HKS Colors -- HKS 62K 090%  K 0%' => 0x51570E ,
'HKS Colors -- HKS 63K 090%  K 0%' => 0x346B1D ,
'HKS Colors -- HKS 64K 090%  K 0%' => 0x179816 ,
'HKS Colors -- HKS 65K 090%  K 0%' => 0x34AE00 ,
'HKS Colors -- HKS 66K 090%  K 0%' => 0x66BB00 ,
'HKS Colors -- HKS 67K 090%  K 0%' => 0x6FC600 ,
'HKS Colors -- HKS 68K 090%  K 0%' => 0xCBBC0A ,
'HKS Colors -- HKS 69K 090%  K 0%' => 0xD3D500 ,
'HKS Colors -- HKS 71K 090%  K 0%' => 0xDA9727 ,
'HKS Colors -- HKS 72K 090%  K 0%' => 0xCB7705 ,
'HKS Colors -- HKS 73K 090%  K 0%' => 0xA36E22 ,
'HKS Colors -- HKS 74K 090%  K 0%' => 0x7E5722 ,
'HKS Colors -- HKS 75K 090%  K 0%' => 0x6E5A22 ,
'HKS Colors -- HKS 76K 090%  K 0%' => 0x463321 ,
'HKS Colors -- HKS 77K 090%  K 0%' => 0x51311D ,
'HKS Colors -- HKS 78K 090%  K 0%' => 0x6A3222 ,
'HKS Colors -- HKS 81K 090%  K 0%' => 0xBA4C25 ,
'HKS Colors -- HKS 82K 090%  K 0%' => 0x973B22 ,
'HKS Colors -- HKS 83K 090%  K 0%' => 0x682F26 ,
'HKS Colors -- HKS 84K 090%  K 0%' => 0x562927 ,
'HKS Colors -- HKS 88K 090%  K 0%' => 0x242422 ,
'HKS Colors -- HKS 89K 090%  K 0%' => 0xA39A87 ,
'HKS Colors -- HKS 90K 090%  K 0%' => 0x332A28 ,
'HKS Colors -- HKS 91K 090%  K 0%' => 0x909A94 ,
'HKS Colors -- HKS 92K 090%  K 0%' => 0x5E6160 ,
'HKS Colors -- HKS 93K 090%  K 0%' => 0x3C424A ,
'HKS Colors -- HKS 95K 090%  K 0%' => 0x8A8A80 ,
'HKS Colors -- HKS 96K 090%  K 0%' => 0x75736E ,
'HKS Colors -- HKS 97K 090%  K 0%' => 0x292F27 ,
'HKS Colors -- HKS 01K 100%  K 0%' => 0xF5D94A ,
'HKS Colors -- HKS 02K 100%  K 0%' => 0xEDD600 ,
'HKS Colors -- HKS 03K 100%  K 0%' => 0xFDE000 ,
'HKS Colors -- HKS 04K 100%  K 0%' => 0xFABE00 ,
'HKS Colors -- HKS 05K 100%  K 0%' => 0xFFB400 ,
'HKS Colors -- HKS 06K 100%  K 0%' => 0xFF7B00 ,
'HKS Colors -- HKS 07K 100%  K 0%' => 0xFF5500 ,
'HKS Colors -- HKS 08K 100%  K 0%' => 0xF93900 ,
'HKS Colors -- HKS 10K 100%  K 0%' => 0xEF2202 ,
'HKS Colors -- HKS 11K 100%  K 0%' => 0xFF7C5A ,
'HKS Colors -- HKS 12K 100%  K 0%' => 0xDB090D ,
'HKS Colors -- HKS 13K 100%  K 0%' => 0xE00016 ,
'HKS Colors -- HKS 14K 100%  K 0%' => 0xCB0016 ,
'HKS Colors -- HKS 15K 100%  K 0%' => 0xB20022 ,
'HKS Colors -- HKS 16K 100%  K 0%' => 0x84051E ,
'HKS Colors -- HKS 17K 100%  K 0%' => 0x7F0023 ,
'HKS Colors -- HKS 18K 100%  K 0%' => 0x4E021A ,
'HKS Colors -- HKS 21K 100%  K 0%' => 0xF9547B ,
'HKS Colors -- HKS 22K 100%  K 0%' => 0xE7071E ,
'HKS Colors -- HKS 23K 100%  K 0%' => 0xCD002E ,
'HKS Colors -- HKS 24K 100%  K 0%' => 0xA60034 ,
'HKS Colors -- HKS 25K 100%  K 0%' => 0xB80047 ,
'HKS Colors -- HKS 26K 100%  K 0%' => 0xA00055 ,
'HKS Colors -- HKS 27K 100%  K 0%' => 0xC90075 ,
'HKS Colors -- HKS 28K 100%  K 0%' => 0x93003B ,
'HKS Colors -- HKS 29K 100%  K 0%' => 0x73006D ,
'HKS Colors -- HKS 31K 100%  K 0%' => 0xA90069 ,
'HKS Colors -- HKS 32K 100%  K 0%' => 0xA70051 ,
'HKS Colors -- HKS 33K 100%  K 0%' => 0x8F009E ,
'HKS Colors -- HKS 34K 100%  K 0%' => 0x53027B ,
'HKS Colors -- HKS 35K 100%  K 0%' => 0x341477 ,
'HKS Colors -- HKS 36K 100%  K 0%' => 0x400075 ,
'HKS Colors -- HKS 37K 100%  K 0%' => 0x360761 ,
'HKS Colors -- HKS 38K 100%  K 0%' => 0x0A172D ,
'HKS Colors -- HKS 39K 100%  K 0%' => 0x123CB7 ,
'HKS Colors -- HKS 40K 100%  K 0%' => 0x006DA4 ,
'HKS Colors -- HKS 41K 100%  K 0%' => 0x0F1B38 ,
'HKS Colors -- HKS 42K 100%  K 0%' => 0x19198A ,
'HKS Colors -- HKS 43K 100%  K 0%' => 0x1410B8 ,
'HKS Colors -- HKS 44K 100%  K 0%' => 0x003EA2 ,
'HKS Colors -- HKS 45K 100%  K 0%' => 0x35308A ,
'HKS Colors -- HKS 46K 100%  K 0%' => 0x0965A1 ,
'HKS Colors -- HKS 47K 100%  K 0%' => 0x007CCD ,
'HKS Colors -- HKS 48K 100%  K 0%' => 0x0080B3 ,
'HKS Colors -- HKS 49K 100%  K 0%' => 0x0068A3 ,
'HKS Colors -- HKS 50K 100%  K 0%' => 0x07A8D9 ,
'HKS Colors -- HKS 51K 100%  K 0%' => 0x00858A ,
'HKS Colors -- HKS 52K 100%  K 0%' => 0x007665 ,
'HKS Colors -- HKS 53K 100%  K 0%' => 0x00AD80 ,
'HKS Colors -- HKS 54K 100%  K 0%' => 0x007744 ,
'HKS Colors -- HKS 55K 100%  K 0%' => 0x005E3E ,
'HKS Colors -- HKS 56K 100%  K 0%' => 0x004333 ,
'HKS Colors -- HKS 57K 100%  K 0%' => 0x006D31 ,
'HKS Colors -- HKS 58K 100%  K 0%' => 0x19461B ,
'HKS Colors -- HKS 59K 100%  K 0%' => 0x00615E ,
'HKS Colors -- HKS 60K 100%  K 0%' => 0x0F7500 ,
'HKS Colors -- HKS 61K 100%  K 0%' => 0x123412 ,
'HKS Colors -- HKS 62K 100%  K 0%' => 0x3D4306 ,
'HKS Colors -- HKS 63K 100%  K 0%' => 0x205808 ,
'HKS Colors -- HKS 64K 100%  K 0%' => 0x00820D ,
'HKS Colors -- HKS 65K 100%  K 0%' => 0x1A9D00 ,
'HKS Colors -- HKS 66K 100%  K 0%' => 0x5BB200 ,
'HKS Colors -- HKS 67K 100%  K 0%' => 0x56BA00 ,
'HKS Colors -- HKS 68K 100%  K 0%' => 0xC3AF00 ,
'HKS Colors -- HKS 69K 100%  K 0%' => 0xC9CA00 ,
'HKS Colors -- HKS 71K 100%  K 0%' => 0xD18509 ,
'HKS Colors -- HKS 72K 100%  K 0%' => 0xC36A00 ,
'HKS Colors -- HKS 73K 100%  K 0%' => 0x995E12 ,
'HKS Colors -- HKS 74K 100%  K 0%' => 0x6E4511 ,
'HKS Colors -- HKS 75K 100%  K 0%' => 0x5A450F ,
'HKS Colors -- HKS 76K 100%  K 0%' => 0x362617 ,
'HKS Colors -- HKS 77K 100%  K 0%' => 0x3B2112 ,
'HKS Colors -- HKS 78K 100%  K 0%' => 0x562112 ,
'HKS Colors -- HKS 81K 100%  K 0%' => 0xA9340E ,
'HKS Colors -- HKS 82K 100%  K 0%' => 0x80230D ,
'HKS Colors -- HKS 83K 100%  K 0%' => 0x581E18 ,
'HKS Colors -- HKS 84K 100%  K 0%' => 0x411A17 ,
'HKS Colors -- HKS 88K 100%  K 0%' => 0x0F0F0D ,
'HKS Colors -- HKS 89K 100%  K 0%' => 0x918771 ,
'HKS Colors -- HKS 90K 100%  K 0%' => 0x211919 ,
'HKS Colors -- HKS 91K 100%  K 0%' => 0x858F87 ,
'HKS Colors -- HKS 92K 100%  K 0%' => 0x4E5454 ,
'HKS Colors -- HKS 93K 100%  K 0%' => 0x30363E ,
'HKS Colors -- HKS 95K 100%  K 0%' => 0x7A7B6D ,
'HKS Colors -- HKS 96K 100%  K 0%' => 0x63635A ,
'HKS Colors -- HKS 97K 100%  K 0%' => 0x1C221A ,
'HKS Colors -- HKS 01K 010%  K 10%' => 0xD7D4CA ,
'HKS Colors -- HKS 02K 010%  K 10%' => 0xD8D6C3 ,
'HKS Colors -- HKS 03K 010%  K 10%' => 0xD9D8BC ,
'HKS Colors -- HKS 04K 010%  K 10%' => 0xD7D1C3 ,
'HKS Colors -- HKS 05K 010%  K 10%' => 0xDAD4BE ,
'HKS Colors -- HKS 06K 010%  K 10%' => 0xD4C3B8 ,
'HKS Colors -- HKS 07K 010%  K 10%' => 0xD9BEB7 ,
'HKS Colors -- HKS 08K 010%  K 10%' => 0xD5BBB9 ,
'HKS Colors -- HKS 10K 010%  K 10%' => 0xD8C0C2 ,
'HKS Colors -- HKS 11K 010%  K 10%' => 0xDBC9C9 ,
'HKS Colors -- HKS 12K 010%  K 10%' => 0xD5C1C4 ,
'HKS Colors -- HKS 13K 010%  K 10%' => 0xD7B8C2 ,
'HKS Colors -- HKS 14K 010%  K 10%' => 0xD1BEC4 ,
'HKS Colors -- HKS 15K 010%  K 10%' => 0xD0BAC4 ,
'HKS Colors -- HKS 16K 010%  K 10%' => 0xCEBBC4 ,
'HKS Colors -- HKS 17K 010%  K 10%' => 0xCEBCC7 ,
'HKS Colors -- HKS 18K 010%  K 10%' => 0xCABCC9 ,
'HKS Colors -- HKS 21K 010%  K 10%' => 0xD8C5CE ,
'HKS Colors -- HKS 22K 010%  K 10%' => 0xD7BDC5 ,
'HKS Colors -- HKS 23K 010%  K 10%' => 0xD5BCC6 ,
'HKS Colors -- HKS 24K 010%  K 10%' => 0xD3B7C5 ,
'HKS Colors -- HKS 25K 010%  K 10%' => 0xD4BCCC ,
'HKS Colors -- HKS 26K 010%  K 10%' => 0xCFBACC ,
'HKS Colors -- HKS 27K 010%  K 10%' => 0xD4B8CC ,
'HKS Colors -- HKS 28K 010%  K 10%' => 0xCBBAC7 ,
'HKS Colors -- HKS 29K 010%  K 10%' => 0xCBBBCE ,
'HKS Colors -- HKS 31K 010%  K 10%' => 0xD4BDCF ,
'HKS Colors -- HKS 32K 010%  K 10%' => 0xCEB8CA ,
'HKS Colors -- HKS 33K 010%  K 10%' => 0xCEBDD6 ,
'HKS Colors -- HKS 34K 010%  K 10%' => 0xC1B9CC ,
'HKS Colors -- HKS 35K 010%  K 10%' => 0xC3BED0 ,
'HKS Colors -- HKS 36K 010%  K 10%' => 0xC4BCCF ,
'HKS Colors -- HKS 37K 010%  K 10%' => 0xC9C3CF ,
'HKS Colors -- HKS 38K 010%  K 10%' => 0xBBBEC7 ,
'HKS Colors -- HKS 39K 010%  K 10%' => 0xC2C4D7 ,
'HKS Colors -- HKS 40K 010%  K 10%' => 0xC3CBD6 ,
'HKS Colors -- HKS 41K 010%  K 10%' => 0xB8BBC5 ,
'HKS Colors -- HKS 42K 010%  K 10%' => 0xBCBCCF ,
'HKS Colors -- HKS 43K 010%  K 10%' => 0xB8BCD4 ,
'HKS Colors -- HKS 44K 010%  K 10%' => 0xBDC4D5 ,
'HKS Colors -- HKS 45K 010%  K 10%' => 0xC4C2D0 ,
'HKS Colors -- HKS 46K 010%  K 10%' => 0xBEC6D1 ,
'HKS Colors -- HKS 47K 010%  K 10%' => 0xBDCAD7 ,
'HKS Colors -- HKS 48K 010%  K 10%' => 0xB7C9D4 ,
'HKS Colors -- HKS 49K 010%  K 10%' => 0xB3C4D3 ,
'HKS Colors -- HKS 50K 010%  K 10%' => 0xC5CFD8 ,
'HKS Colors -- HKS 51K 010%  K 10%' => 0xBECBCF ,
'HKS Colors -- HKS 52K 010%  K 10%' => 0xB7C6CA ,
'HKS Colors -- HKS 53K 010%  K 10%' => 0xBDCFCF ,
'HKS Colors -- HKS 54K 010%  K 10%' => 0xB5C9C3 ,
'HKS Colors -- HKS 55K 010%  K 10%' => 0xB9C7C6 ,
'HKS Colors -- HKS 56K 010%  K 10%' => 0xB8C3C5 ,
'HKS Colors -- HKS 57K 010%  K 10%' => 0xB5C5BD ,
'HKS Colors -- HKS 58K 010%  K 10%' => 0xC0C3C2 ,
'HKS Colors -- HKS 59K 010%  K 10%' => 0xBAC6CB ,
'HKS Colors -- HKS 60K 010%  K 10%' => 0xC3CBC0 ,
'HKS Colors -- HKS 61K 010%  K 10%' => 0xB9BDBE ,
'HKS Colors -- HKS 62K 010%  K 10%' => 0xC0C0B8 ,
'HKS Colors -- HKS 63K 010%  K 10%' => 0xC0C5C1 ,
'HKS Colors -- HKS 64K 010%  K 10%' => 0xBECCC0 ,
'HKS Colors -- HKS 65K 010%  K 10%' => 0xC2CDBC ,
'HKS Colors -- HKS 66K 010%  K 10%' => 0xC6D1BD ,
'HKS Colors -- HKS 67K 010%  K 10%' => 0xCBD3C0 ,
'HKS Colors -- HKS 68K 010%  K 10%' => 0xD6D1C5 ,
'HKS Colors -- HKS 69K 010%  K 10%' => 0xD6D4C4 ,
'HKS Colors -- HKS 71K 010%  K 10%' => 0xD4CAC2 ,
'HKS Colors -- HKS 72K 010%  K 10%' => 0xCEC4BC ,
'HKS Colors -- HKS 73K 010%  K 10%' => 0xCEC6C3 ,
'HKS Colors -- HKS 74K 010%  K 10%' => 0xC9C4C3 ,
'HKS Colors -- HKS 75K 010%  K 10%' => 0xC6C1BD ,
'HKS Colors -- HKS 76K 010%  K 10%' => 0xC4C1C2 ,
'HKS Colors -- HKS 77K 010%  K 10%' => 0xC4BDC0 ,
'HKS Colors -- HKS 78K 010%  K 10%' => 0xC7BCBD ,
'HKS Colors -- HKS 81K 010%  K 10%' => 0xD3C1C1 ,
'HKS Colors -- HKS 82K 010%  K 10%' => 0xCEC0C2 ,
'HKS Colors -- HKS 83K 010%  K 10%' => 0xC7BEC1 ,
'HKS Colors -- HKS 84K 010%  K 10%' => 0xC3BCBE ,
'HKS Colors -- HKS 88K 010%  K 10%' => 0xD8D6D9 ,
'HKS Colors -- HKS 89K 010%  K 10%' => 0xCECBCC ,
'HKS Colors -- HKS 90K 010%  K 10%' => 0xBCBABD ,
'HKS Colors -- HKS 91K 010%  K 10%' => 0xCFCDD0 ,
'HKS Colors -- HKS 92K 010%  K 10%' => 0xC7C5CC ,
'HKS Colors -- HKS 93K 010%  K 10%' => 0xC2C0C6 ,
'HKS Colors -- HKS 95K 010%  K 10%' => 0xC9C5C9 ,
'HKS Colors -- HKS 96K 010%  K 10%' => 0xCFCDD0 ,
'HKS Colors -- HKS 97K 010%  K 10%' => 0xBABBBD ,
'HKS Colors -- HKS 01K 020%  K 10%' => 0xD8D4BC ,
'HKS Colors -- HKS 02K 020%  K 10%' => 0xD7D6B0 ,
'HKS Colors -- HKS 03K 020%  K 10%' => 0xDAD6A5 ,
'HKS Colors -- HKS 04K 020%  K 10%' => 0xD4CDA9 ,
'HKS Colors -- HKS 05K 020%  K 10%' => 0xDCCDA9 ,
'HKS Colors -- HKS 06K 020%  K 10%' => 0xD5B89E ,
'HKS Colors -- HKS 07K 020%  K 10%' => 0xD9AFA1 ,
'HKS Colors -- HKS 08K 020%  K 10%' => 0xD7ABA3 ,
'HKS Colors -- HKS 10K 020%  K 10%' => 0xD8ADAE ,
'HKS Colors -- HKS 11K 020%  K 10%' => 0xD9BCB8 ,
'HKS Colors -- HKS 12K 020%  K 10%' => 0xD3AEB2 ,
'HKS Colors -- HKS 13K 020%  K 10%' => 0xD5A0A9 ,
'HKS Colors -- HKS 14K 020%  K 10%' => 0xCFABB1 ,
'HKS Colors -- HKS 15K 020%  K 10%' => 0xCAA7B2 ,
'HKS Colors -- HKS 16K 020%  K 10%' => 0xC4A4B1 ,
'HKS Colors -- HKS 17K 020%  K 10%' => 0xC6A8B7 ,
'HKS Colors -- HKS 18K 020%  K 10%' => 0xBAA2B1 ,
'HKS Colors -- HKS 21K 020%  K 10%' => 0xD8B9C5 ,
'HKS Colors -- HKS 22K 020%  K 10%' => 0xD7AAB3 ,
'HKS Colors -- HKS 23K 020%  K 10%' => 0xD0A6B7 ,
'HKS Colors -- HKS 24K 020%  K 10%' => 0xCA9BAF ,
'HKS Colors -- HKS 25K 020%  K 10%' => 0xCEA6BD ,
'HKS Colors -- HKS 26K 020%  K 10%' => 0xC9A3BE ,
'HKS Colors -- HKS 27K 020%  K 10%' => 0xD1A2C4 ,
'HKS Colors -- HKS 28K 020%  K 10%' => 0xC2A4B8 ,
'HKS Colors -- HKS 29K 020%  K 10%' => 0xBDA5C2 ,
'HKS Colors -- HKS 31K 020%  K 10%' => 0xCEA4C2 ,
'HKS Colors -- HKS 32K 020%  K 10%' => 0xC69DBA ,
'HKS Colors -- HKS 33K 020%  K 10%' => 0xC2A2CE ,
'HKS Colors -- HKS 34K 020%  K 10%' => 0xB4A6C2 ,
'HKS Colors -- HKS 35K 020%  K 10%' => 0xAEA9C2 ,
'HKS Colors -- HKS 36K 020%  K 10%' => 0xB4A7C6 ,
'HKS Colors -- HKS 37K 020%  K 10%' => 0xB5B0C4 ,
'HKS Colors -- HKS 38K 020%  K 10%' => 0xA3A8B7 ,
'HKS Colors -- HKS 39K 020%  K 10%' => 0xA9B4D1 ,
'HKS Colors -- HKS 40K 020%  K 10%' => 0xAEBECC ,
'HKS Colors -- HKS 41K 020%  K 10%' => 0xA1A6B3 ,
'HKS Colors -- HKS 42K 020%  K 10%' => 0xA8AACA ,
'HKS Colors -- HKS 43K 020%  K 10%' => 0xA1A8CE ,
'HKS Colors -- HKS 44K 020%  K 10%' => 0xA6B2CC ,
'HKS Colors -- HKS 45K 020%  K 10%' => 0xB4B2C9 ,
'HKS Colors -- HKS 46K 020%  K 10%' => 0xA8B9C9 ,
'HKS Colors -- HKS 47K 020%  K 10%' => 0xA3BDD4 ,
'HKS Colors -- HKS 48K 020%  K 10%' => 0xA1BECE ,
'HKS Colors -- HKS 49K 020%  K 10%' => 0x9AB7CC ,
'HKS Colors -- HKS 50K 020%  K 10%' => 0xB3CAD4 ,
'HKS Colors -- HKS 51K 020%  K 10%' => 0xA6C2C7 ,
'HKS Colors -- HKS 52K 020%  K 10%' => 0x9EBABA ,
'HKS Colors -- HKS 53K 020%  K 10%' => 0xA4CBC2 ,
'HKS Colors -- HKS 54K 020%  K 10%' => 0x9ABDB1 ,
'HKS Colors -- HKS 55K 020%  K 10%' => 0x9CB5B0 ,
'HKS Colors -- HKS 56K 020%  K 10%' => 0xA3B4B4 ,
'HKS Colors -- HKS 57K 020%  K 10%' => 0x9CB8A8 ,
'HKS Colors -- HKS 58K 020%  K 10%' => 0xABB4AF ,
'HKS Colors -- HKS 59K 020%  K 10%' => 0x9DB8BD ,
'HKS Colors -- HKS 60K 020%  K 10%' => 0xB0C1AB ,
'HKS Colors -- HKS 61K 020%  K 10%' => 0xA6ADA6 ,
'HKS Colors -- HKS 62K 020%  K 10%' => 0xAEAFA0 ,
'HKS Colors -- HKS 63K 020%  K 10%' => 0xABB8AA ,
'HKS Colors -- HKS 64K 020%  K 10%' => 0xA8C0A9 ,
'HKS Colors -- HKS 65K 020%  K 10%' => 0xAEC6A7 ,
'HKS Colors -- HKS 66K 020%  K 10%' => 0xB7CCA3 ,
'HKS Colors -- HKS 67K 020%  K 10%' => 0xBED0A8 ,
'HKS Colors -- HKS 68K 020%  K 10%' => 0xCFCEB2 ,
'HKS Colors -- HKS 69K 020%  K 10%' => 0xD1D1B0 ,
'HKS Colors -- HKS 71K 020%  K 10%' => 0xD1C1AE ,
'HKS Colors -- HKS 72K 020%  K 10%' => 0xCABAA7 ,
'HKS Colors -- HKS 73K 020%  K 10%' => 0xC4B9AD ,
'HKS Colors -- HKS 74K 020%  K 10%' => 0xBDB3AB ,
'HKS Colors -- HKS 75K 020%  K 10%' => 0xB8B4AA ,
'HKS Colors -- HKS 76K 020%  K 10%' => 0xB2AEAD ,
'HKS Colors -- HKS 77K 020%  K 10%' => 0xB2ABAB ,
'HKS Colors -- HKS 78K 020%  K 10%' => 0xBAA9A9 ,
'HKS Colors -- HKS 81K 020%  K 10%' => 0xCAADA6 ,
'HKS Colors -- HKS 82K 020%  K 10%' => 0xC4ABA8 ,
'HKS Colors -- HKS 83K 020%  K 10%' => 0xBBAEAF ,
'HKS Colors -- HKS 84K 020%  K 10%' => 0xB1A5A8 ,
'HKS Colors -- HKS 88K 020%  K 10%' => 0xC2C0C3 ,
'HKS Colors -- HKS 89K 020%  K 10%' => 0xC5C1C0 ,
'HKS Colors -- HKS 90K 020%  K 10%' => 0xA7A5A8 ,
'HKS Colors -- HKS 91K 020%  K 10%' => 0xC4C5C7 ,
'HKS Colors -- HKS 92K 020%  K 10%' => 0xB4B5B8 ,
'HKS Colors -- HKS 93K 020%  K 10%' => 0xAAAEB4 ,
'HKS Colors -- HKS 95K 020%  K 10%' => 0xBCBCBC ,
'HKS Colors -- HKS 96K 020%  K 10%' => 0xC0BDC1 ,
'HKS Colors -- HKS 97K 020%  K 10%' => 0xA8A9AB ,
'HKS Colors -- HKS 01K 030%  K 10%' => 0xD8D1AF ,
'HKS Colors -- HKS 02K 030%  K 10%' => 0xD6D49E ,
'HKS Colors -- HKS 03K 030%  K 10%' => 0xD8D693 ,
'HKS Colors -- HKS 04K 030%  K 10%' => 0xD4CB96 ,
'HKS Colors -- HKS 05K 030%  K 10%' => 0xDBC997 ,
'HKS Colors -- HKS 06K 030%  K 10%' => 0xD7AE8D ,
'HKS Colors -- HKS 07K 030%  K 10%' => 0xDDA58F ,
'HKS Colors -- HKS 08K 030%  K 10%' => 0xD7A194 ,
'HKS Colors -- HKS 10K 030%  K 10%' => 0xD8A09D ,
'HKS Colors -- HKS 11K 030%  K 10%' => 0xDAB5AF ,
'HKS Colors -- HKS 12K 030%  K 10%' => 0xD09CA1 ,
'HKS Colors -- HKS 13K 030%  K 10%' => 0xD48D98 ,
'HKS Colors -- HKS 14K 030%  K 10%' => 0xCB999E ,
'HKS Colors -- HKS 15K 030%  K 10%' => 0xC292A0 ,
'HKS Colors -- HKS 16K 030%  K 10%' => 0xBB8F9D ,
'HKS Colors -- HKS 17K 030%  K 10%' => 0xBD96A7 ,
'HKS Colors -- HKS 18K 030%  K 10%' => 0xAE8FA3 ,
'HKS Colors -- HKS 21K 030%  K 10%' => 0xD8ADBB ,
'HKS Colors -- HKS 22K 030%  K 10%' => 0xD79BA4 ,
'HKS Colors -- HKS 23K 030%  K 10%' => 0xCF93A7 ,
'HKS Colors -- HKS 24K 030%  K 10%' => 0xC587A4 ,
'HKS Colors -- HKS 25K 030%  K 10%' => 0xC991B0 ,
'HKS Colors -- HKS 26K 030%  K 10%' => 0xC491B3 ,
'HKS Colors -- HKS 27K 030%  K 10%' => 0xCF93BB ,
'HKS Colors -- HKS 28K 030%  K 10%' => 0xBA8FA7 ,
'HKS Colors -- HKS 29K 030%  K 10%' => 0xB597BA ,
'HKS Colors -- HKS 31K 030%  K 10%' => 0xCC92BA ,
'HKS Colors -- HKS 32K 030%  K 10%' => 0xC28BAF ,
'HKS Colors -- HKS 33K 030%  K 10%' => 0xB88EC7 ,
'HKS Colors -- HKS 34K 030%  K 10%' => 0xA797BA ,
'HKS Colors -- HKS 35K 030%  K 10%' => 0xA29ABB ,
'HKS Colors -- HKS 36K 030%  K 10%' => 0xA597C0 ,
'HKS Colors -- HKS 37K 030%  K 10%' => 0xA69EB9 ,
'HKS Colors -- HKS 38K 030%  K 10%' => 0x919AA8 ,
'HKS Colors -- HKS 39K 030%  K 10%' => 0x9AA8CF ,
'HKS Colors -- HKS 40K 030%  K 10%' => 0xA1B5C7 ,
'HKS Colors -- HKS 41K 030%  K 10%' => 0x9399A8 ,
'HKS Colors -- HKS 42K 030%  K 10%' => 0x9B9CC3 ,
'HKS Colors -- HKS 43K 030%  K 10%' => 0x8E98CC ,
'HKS Colors -- HKS 44K 030%  K 10%' => 0x94A5C7 ,
'HKS Colors -- HKS 45K 030%  K 10%' => 0xA6A4C2 ,
'HKS Colors -- HKS 46K 030%  K 10%' => 0x9BB0C4 ,
'HKS Colors -- HKS 47K 030%  K 10%' => 0x92B5D0 ,
'HKS Colors -- HKS 48K 030%  K 10%' => 0x8BB5CA ,
'HKS Colors -- HKS 49K 030%  K 10%' => 0x82ABC5 ,
'HKS Colors -- HKS 50K 030%  K 10%' => 0xA7C5D3 ,
'HKS Colors -- HKS 51K 030%  K 10%' => 0x94B9BE ,
'HKS Colors -- HKS 52K 030%  K 10%' => 0x8DB1AE ,
'HKS Colors -- HKS 53K 030%  K 10%' => 0x8BC5B8 ,
'HKS Colors -- HKS 54K 030%  K 10%' => 0x80B2A0 ,
'HKS Colors -- HKS 55K 030%  K 10%' => 0x85A9A2 ,
'HKS Colors -- HKS 56K 030%  K 10%' => 0x92A8A7 ,
'HKS Colors -- HKS 57K 030%  K 10%' => 0x88AF9A ,
'HKS Colors -- HKS 58K 030%  K 10%' => 0x9AA79D ,
'HKS Colors -- HKS 59K 030%  K 10%' => 0x8AAEB3 ,
'HKS Colors -- HKS 60K 030%  K 10%' => 0xA4BB9C ,
'HKS Colors -- HKS 61K 030%  K 10%' => 0x98A499 ,
'HKS Colors -- HKS 62K 030%  K 10%' => 0xA2A48D ,
'HKS Colors -- HKS 63K 030%  K 10%' => 0xA0B09C ,
'HKS Colors -- HKS 64K 030%  K 10%' => 0x99BB98 ,
'HKS Colors -- HKS 65K 030%  K 10%' => 0xA2C297 ,
'HKS Colors -- HKS 66K 030%  K 10%' => 0xAAC78E ,
'HKS Colors -- HKS 67K 030%  K 10%' => 0xB0CB93 ,
'HKS Colors -- HKS 68K 030%  K 10%' => 0xCDC7A2 ,
'HKS Colors -- HKS 69K 030%  K 10%' => 0xCED09E ,
'HKS Colors -- HKS 71K 030%  K 10%' => 0xCEB9A0 ,
'HKS Colors -- HKS 72K 030%  K 10%' => 0xC7B197 ,
'HKS Colors -- HKS 73K 030%  K 10%' => 0xC0B09D ,
'HKS Colors -- HKS 74K 030%  K 10%' => 0xB3A99D ,
'HKS Colors -- HKS 75K 030%  K 10%' => 0xB0AB9E ,
'HKS Colors -- HKS 76K 030%  K 10%' => 0xA49D9C ,
'HKS Colors -- HKS 77K 030%  K 10%' => 0xA89D9C ,
'HKS Colors -- HKS 78K 030%  K 10%' => 0xAA9796 ,
'HKS Colors -- HKS 81K 030%  K 10%' => 0xC7A096 ,
'HKS Colors -- HKS 82K 030%  K 10%' => 0xBE9E9A ,
'HKS Colors -- HKS 83K 030%  K 10%' => 0xAF9E9E ,
'HKS Colors -- HKS 84K 030%  K 10%' => 0xA59698 ,
'HKS Colors -- HKS 88K 030%  K 10%' => 0xB0AEB1 ,
'HKS Colors -- HKS 89K 030%  K 10%' => 0xBEBAB9 ,
'HKS Colors -- HKS 90K 030%  K 10%' => 0x9A989B ,
'HKS Colors -- HKS 91K 030%  K 10%' => 0xBEC0C2 ,
'HKS Colors -- HKS 92K 030%  K 10%' => 0xA8A9AE ,
'HKS Colors -- HKS 93K 030%  K 10%' => 0x9EA1A7 ,
'HKS Colors -- HKS 95K 030%  K 10%' => 0xB4B4B4 ,
'HKS Colors -- HKS 96K 030%  K 10%' => 0xB7B4B8 ,
'HKS Colors -- HKS 97K 030%  K 10%' => 0x9B9C9E ,
'HKS Colors -- HKS 01K 040%  K 10%' => 0xD7D0A4 ,
'HKS Colors -- HKS 02K 040%  K 10%' => 0xD6D38B ,
'HKS Colors -- HKS 03K 040%  K 10%' => 0xD8D477 ,
'HKS Colors -- HKS 04K 040%  K 10%' => 0xD3C573 ,
'HKS Colors -- HKS 05K 040%  K 10%' => 0xDEC47D ,
'HKS Colors -- HKS 06K 040%  K 10%' => 0xDAA87A ,
'HKS Colors -- HKS 07K 040%  K 10%' => 0xDC9677 ,
'HKS Colors -- HKS 08K 040%  K 10%' => 0xD79382 ,
'HKS Colors -- HKS 10K 040%  K 10%' => 0xD98A88 ,
'HKS Colors -- HKS 11K 040%  K 10%' => 0xDAAFA5 ,
'HKS Colors -- HKS 12K 040%  K 10%' => 0xCD8788 ,
'HKS Colors -- HKS 13K 040%  K 10%' => 0xD57482 ,
'HKS Colors -- HKS 14K 040%  K 10%' => 0xC78489 ,
'HKS Colors -- HKS 15K 040%  K 10%' => 0xBD7B8D ,
'HKS Colors -- HKS 16K 040%  K 10%' => 0xB3788A ,
'HKS Colors -- HKS 17K 040%  K 10%' => 0xB77F97 ,
'HKS Colors -- HKS 18K 040%  K 10%' => 0xA1758F ,
'HKS Colors -- HKS 21K 040%  K 10%' => 0xD9A1B0 ,
'HKS Colors -- HKS 22K 040%  K 10%' => 0xD98894 ,
'HKS Colors -- HKS 23K 040%  K 10%' => 0xCA7B93 ,
'HKS Colors -- HKS 24K 040%  K 10%' => 0xC16F92 ,
'HKS Colors -- HKS 25K 040%  K 10%' => 0xC47AA2 ,
'HKS Colors -- HKS 26K 040%  K 10%' => 0xC07BA8 ,
'HKS Colors -- HKS 27K 040%  K 10%' => 0xCE7DB1 ,
'HKS Colors -- HKS 28K 040%  K 10%' => 0xB37899 ,
'HKS Colors -- HKS 29K 040%  K 10%' => 0xAD82B1 ,
'HKS Colors -- HKS 31K 040%  K 10%' => 0xC57BAE ,
'HKS Colors -- HKS 32K 040%  K 10%' => 0xC077A4 ,
'HKS Colors -- HKS 33K 040%  K 10%' => 0xB07BC1 ,
'HKS Colors -- HKS 34K 040%  K 10%' => 0x9B82B2 ,
'HKS Colors -- HKS 35K 040%  K 10%' => 0x938BB3 ,
'HKS Colors -- HKS 36K 040%  K 10%' => 0x9881B5 ,
'HKS Colors -- HKS 37K 040%  K 10%' => 0x988DAE ,
'HKS Colors -- HKS 38K 040%  K 10%' => 0x7C8799 ,
'HKS Colors -- HKS 39K 040%  K 10%' => 0x879BCB ,
'HKS Colors -- HKS 40K 040%  K 10%' => 0x8EAAC2 ,
'HKS Colors -- HKS 41K 040%  K 10%' => 0x7D889B ,
'HKS Colors -- HKS 42K 040%  K 10%' => 0x8789BB ,
'HKS Colors -- HKS 43K 040%  K 10%' => 0x7B88C9 ,
'HKS Colors -- HKS 44K 040%  K 10%' => 0x8098C2 ,
'HKS Colors -- HKS 45K 040%  K 10%' => 0x9693BA ,
'HKS Colors -- HKS 46K 040%  K 10%' => 0x88A4BD ,
'HKS Colors -- HKS 47K 040%  K 10%' => 0x7BABCD ,
'HKS Colors -- HKS 48K 040%  K 10%' => 0x75AEC9 ,
'HKS Colors -- HKS 49K 040%  K 10%' => 0x6BA1C1 ,
'HKS Colors -- HKS 50K 040%  K 10%' => 0x98BED1 ,
'HKS Colors -- HKS 51K 040%  K 10%' => 0x7FB2B9 ,
'HKS Colors -- HKS 52K 040%  K 10%' => 0x7AA9A4 ,
'HKS Colors -- HKS 53K 040%  K 10%' => 0x74C0AE ,
'HKS Colors -- HKS 54K 040%  K 10%' => 0x68A98E ,
'HKS Colors -- HKS 55K 040%  K 10%' => 0x709D91 ,
'HKS Colors -- HKS 56K 040%  K 10%' => 0x7D9C9B ,
'HKS Colors -- HKS 57K 040%  K 10%' => 0x72A588 ,
'HKS Colors -- HKS 58K 040%  K 10%' => 0x879989 ,
'HKS Colors -- HKS 59K 040%  K 10%' => 0x72A2A6 ,
'HKS Colors -- HKS 60K 040%  K 10%' => 0x94B58E ,
'HKS Colors -- HKS 61K 040%  K 10%' => 0x829385 ,
'HKS Colors -- HKS 62K 040%  K 10%' => 0x979A7C ,
'HKS Colors -- HKS 63K 040%  K 10%' => 0x8FA588 ,
'HKS Colors -- HKS 64K 040%  K 10%' => 0x85B282 ,
'HKS Colors -- HKS 65K 040%  K 10%' => 0x92BD80 ,
'HKS Colors -- HKS 66K 040%  K 10%' => 0x9EC275 ,
'HKS Colors -- HKS 67K 040%  K 10%' => 0xA5C97B ,
'HKS Colors -- HKS 68K 040%  K 10%' => 0xCAC48F ,
'HKS Colors -- HKS 69K 040%  K 10%' => 0xCDCE8B ,
'HKS Colors -- HKS 71K 040%  K 10%' => 0xCAB18E ,
'HKS Colors -- HKS 72K 040%  K 10%' => 0xC3A782 ,
'HKS Colors -- HKS 73K 040%  K 10%' => 0xB9A48D ,
'HKS Colors -- HKS 74K 040%  K 10%' => 0xAB9C8A ,
'HKS Colors -- HKS 75K 040%  K 10%' => 0xA49D89 ,
'HKS Colors -- HKS 76K 040%  K 10%' => 0x8F8782 ,
'HKS Colors -- HKS 77K 040%  K 10%' => 0x9A8D89 ,
'HKS Colors -- HKS 78K 040%  K 10%' => 0xA28784 ,
'HKS Colors -- HKS 81K 040%  K 10%' => 0xC29184 ,
'HKS Colors -- HKS 82K 040%  K 10%' => 0xB78F88 ,
'HKS Colors -- HKS 83K 040%  K 10%' => 0xA18A8A ,
'HKS Colors -- HKS 84K 040%  K 10%' => 0x948286 ,
'HKS Colors -- HKS 88K 040%  K 10%' => 0x969397 ,
'HKS Colors -- HKS 89K 040%  K 10%' => 0xB9B3AD ,
'HKS Colors -- HKS 90K 040%  K 10%' => 0x898488 ,
'HKS Colors -- HKS 91K 040%  K 10%' => 0xB5B9BB ,
'HKS Colors -- HKS 92K 040%  K 10%' => 0x9B9C9E ,
'HKS Colors -- HKS 93K 040%  K 10%' => 0x8B8F94 ,
'HKS Colors -- HKS 95K 040%  K 10%' => 0xABAAA8 ,
'HKS Colors -- HKS 96K 040%  K 10%' => 0xAAAAAA ,
'HKS Colors -- HKS 97K 040%  K 10%' => 0x888B8A ,
'HKS Colors -- HKS 01K 050%  K 10%' => 0xD5CE98 ,
'HKS Colors -- HKS 02K 050%  K 10%' => 0xD6D073 ,
'HKS Colors -- HKS 03K 050%  K 10%' => 0xD8D363 ,
'HKS Colors -- HKS 04K 050%  K 10%' => 0xD1C15B ,
'HKS Colors -- HKS 05K 050%  K 10%' => 0xDBBD68 ,
'HKS Colors -- HKS 06K 050%  K 10%' => 0xD79E65 ,
'HKS Colors -- HKS 07K 050%  K 10%' => 0xDD8A61 ,
'HKS Colors -- HKS 08K 050%  K 10%' => 0xD78871 ,
'HKS Colors -- HKS 10K 050%  K 10%' => 0xD87B75 ,
'HKS Colors -- HKS 11K 050%  K 10%' => 0xDAA79B ,
'HKS Colors -- HKS 12K 050%  K 10%' => 0xCB7474 ,
'HKS Colors -- HKS 13K 050%  K 10%' => 0xD16172 ,
'HKS Colors -- HKS 14K 050%  K 10%' => 0xC47277 ,
'HKS Colors -- HKS 15K 050%  K 10%' => 0xB9657A ,
'HKS Colors -- HKS 16K 050%  K 10%' => 0xAD677B ,
'HKS Colors -- HKS 17K 050%  K 10%' => 0xB06D88 ,
'HKS Colors -- HKS 18K 050%  K 10%' => 0x965F7D ,
'HKS Colors -- HKS 21K 050%  K 10%' => 0xD898AA ,
'HKS Colors -- HKS 22K 050%  K 10%' => 0xD77887 ,
'HKS Colors -- HKS 23K 050%  K 10%' => 0xC96785 ,
'HKS Colors -- HKS 24K 050%  K 10%' => 0xBC5F85 ,
'HKS Colors -- HKS 25K 050%  K 10%' => 0xC06596 ,
'HKS Colors -- HKS 26K 050%  K 10%' => 0xB9659C ,
'HKS Colors -- HKS 27K 050%  K 10%' => 0xCD68AB ,
'HKS Colors -- HKS 28K 050%  K 10%' => 0xAE658B ,
'HKS Colors -- HKS 29K 050%  K 10%' => 0xA472A9 ,
'HKS Colors -- HKS 31K 050%  K 10%' => 0xC269A5 ,
'HKS Colors -- HKS 32K 050%  K 10%' => 0xB76198 ,
'HKS Colors -- HKS 33K 050%  K 10%' => 0xAB6ABE ,
'HKS Colors -- HKS 34K 050%  K 10%' => 0x8F72A9 ,
'HKS Colors -- HKS 35K 050%  K 10%' => 0x847AAB ,
'HKS Colors -- HKS 36K 050%  K 10%' => 0x886FAE ,
'HKS Colors -- HKS 37K 050%  K 10%' => 0x8B7DA4 ,
'HKS Colors -- HKS 38K 050%  K 10%' => 0x6A778A ,
'HKS Colors -- HKS 39K 050%  K 10%' => 0x778BC5 ,
'HKS Colors -- HKS 40K 050%  K 10%' => 0x7DA3BE ,
'HKS Colors -- HKS 41K 050%  K 10%' => 0x6F7A8E ,
'HKS Colors -- HKS 42K 050%  K 10%' => 0x777AB5 ,
'HKS Colors -- HKS 43K 050%  K 10%' => 0x6778C4 ,
'HKS Colors -- HKS 44K 050%  K 10%' => 0x708BBD ,
'HKS Colors -- HKS 45K 050%  K 10%' => 0x8984B2 ,
'HKS Colors -- HKS 46K 050%  K 10%' => 0x769BB9 ,
'HKS Colors -- HKS 47K 050%  K 10%' => 0x65A3CC ,
'HKS Colors -- HKS 48K 050%  K 10%' => 0x5EA6C4 ,
'HKS Colors -- HKS 49K 050%  K 10%' => 0x5598BB ,
'HKS Colors -- HKS 50K 050%  K 10%' => 0x88BACF ,
'HKS Colors -- HKS 51K 050%  K 10%' => 0x6EA9B0 ,
'HKS Colors -- HKS 52K 050%  K 10%' => 0x66A098 ,
'HKS Colors -- HKS 53K 050%  K 10%' => 0x5FBCA5 ,
'HKS Colors -- HKS 54K 050%  K 10%' => 0x52A281 ,
'HKS Colors -- HKS 55K 050%  K 10%' => 0x5B9384 ,
'HKS Colors -- HKS 56K 050%  K 10%' => 0x6B938F ,
'HKS Colors -- HKS 57K 050%  K 10%' => 0x5F9A77 ,
'HKS Colors -- HKS 58K 050%  K 10%' => 0x788F7C ,
'HKS Colors -- HKS 59K 050%  K 10%' => 0x5D999C ,
'HKS Colors -- HKS 60K 050%  K 10%' => 0x86AF7B ,
'HKS Colors -- HKS 61K 050%  K 10%' => 0x738773 ,
'HKS Colors -- HKS 62K 050%  K 10%' => 0x8D906D ,
'HKS Colors -- HKS 63K 050%  K 10%' => 0x829C77 ,
'HKS Colors -- HKS 64K 050%  K 10%' => 0x75AD72 ,
'HKS Colors -- HKS 65K 050%  K 10%' => 0x82B86E ,
'HKS Colors -- HKS 66K 050%  K 10%' => 0x93BE65 ,
'HKS Colors -- HKS 67K 050%  K 10%' => 0x9DC66B ,
'HKS Colors -- HKS 68K 050%  K 10%' => 0xC5C07C ,
'HKS Colors -- HKS 69K 050%  K 10%' => 0xC7CB78 ,
'HKS Colors -- HKS 71K 050%  K 10%' => 0xC7A97C ,
'HKS Colors -- HKS 72K 050%  K 10%' => 0xC19D6F ,
'HKS Colors -- HKS 73K 050%  K 10%' => 0xB49B7C ,
'HKS Colors -- HKS 74K 050%  K 10%' => 0xA28F77 ,
'HKS Colors -- HKS 75K 050%  K 10%' => 0x9B9378 ,
'HKS Colors -- HKS 76K 050%  K 10%' => 0x7C736A ,
'HKS Colors -- HKS 77K 050%  K 10%' => 0x8B7A72 ,
'HKS Colors -- HKS 78K 050%  K 10%' => 0x987874 ,
'HKS Colors -- HKS 81K 050%  K 10%' => 0xBB8170 ,
'HKS Colors -- HKS 82K 050%  K 10%' => 0xB28177 ,
'HKS Colors -- HKS 83K 050%  K 10%' => 0x977C7B ,
'HKS Colors -- HKS 84K 050%  K 10%' => 0x866F6F ,
'HKS Colors -- HKS 88K 050%  K 10%' => 0x808082 ,
'HKS Colors -- HKS 89K 050%  K 10%' => 0xB1ABA5 ,
'HKS Colors -- HKS 90K 050%  K 10%' => 0x7B7577 ,
'HKS Colors -- HKS 91K 050%  K 10%' => 0xB0B3B2 ,
'HKS Colors -- HKS 92K 050%  K 10%' => 0x919294 ,
'HKS Colors -- HKS 93K 050%  K 10%' => 0x7A7D86 ,
'HKS Colors -- HKS 95K 050%  K 10%' => 0xA5A4A2 ,
'HKS Colors -- HKS 96K 050%  K 10%' => 0xA1A1A1 ,
'HKS Colors -- HKS 97K 050%  K 10%' => 0x7A7D7C ,
'HKS Colors -- HKS 01K 060%  K 10%' => 0xD6CD88 ,
'HKS Colors -- HKS 02K 060%  K 10%' => 0xD5CF51 ,
'HKS Colors -- HKS 03K 060%  K 10%' => 0xD9D040 ,
'HKS Colors -- HKS 04K 060%  K 10%' => 0xD3BC32 ,
'HKS Colors -- HKS 05K 060%  K 10%' => 0xDEB946 ,
'HKS Colors -- HKS 06K 060%  K 10%' => 0xDB9347 ,
'HKS Colors -- HKS 07K 060%  K 10%' => 0xE17740 ,
'HKS Colors -- HKS 08K 060%  K 10%' => 0xDA7354 ,
'HKS Colors -- HKS 10K 060%  K 10%' => 0xD8645B ,
'HKS Colors -- HKS 11K 060%  K 10%' => 0xDB9989 ,
'HKS Colors -- HKS 12K 060%  K 10%' => 0xCA5756 ,
'HKS Colors -- HKS 13K 060%  K 10%' => 0xD13C51 ,
'HKS Colors -- HKS 14K 060%  K 10%' => 0xC0585E ,
'HKS Colors -- HKS 15K 060%  K 10%' => 0xB34B63 ,
'HKS Colors -- HKS 16K 060%  K 10%' => 0xA1465F ,
'HKS Colors -- HKS 17K 060%  K 10%' => 0xA64B71 ,
'HKS Colors -- HKS 18K 060%  K 10%' => 0x854065 ,
'HKS Colors -- HKS 21K 060%  K 10%' => 0xD889A0 ,
'HKS Colors -- HKS 22K 060%  K 10%' => 0xD65868 ,
'HKS Colors -- HKS 23K 060%  K 10%' => 0xC44E70 ,
'HKS Colors -- HKS 24K 060%  K 10%' => 0xB74776 ,
'HKS Colors -- HKS 25K 060%  K 10%' => 0xB94684 ,
'HKS Colors -- HKS 26K 060%  K 10%' => 0xB04289 ,
'HKS Colors -- HKS 27K 060%  K 10%' => 0xCA4CA2 ,
'HKS Colors -- HKS 28K 060%  K 10%' => 0xA64676 ,
'HKS Colors -- HKS 29K 060%  K 10%' => 0x9A5D9D ,
'HKS Colors -- HKS 31K 060%  K 10%' => 0xBA4D99 ,
'HKS Colors -- HKS 32K 060%  K 10%' => 0xAE347F ,
'HKS Colors -- HKS 33K 060%  K 10%' => 0xA24DB4 ,
'HKS Colors -- HKS 34K 060%  K 10%' => 0x7E579D ,
'HKS Colors -- HKS 35K 060%  K 10%' => 0x6A5C9B ,
'HKS Colors -- HKS 36K 060%  K 10%' => 0x734DA0 ,
'HKS Colors -- HKS 37K 060%  K 10%' => 0x766393 ,
'HKS Colors -- HKS 38K 060%  K 10%' => 0x4F5F76 ,
'HKS Colors -- HKS 39K 060%  K 10%' => 0x5F7BC2 ,
'HKS Colors -- HKS 40K 060%  K 10%' => 0x6194B5 ,
'HKS Colors -- HKS 41K 060%  K 10%' => 0x55617A ,
'HKS Colors -- HKS 42K 060%  K 10%' => 0x5D61AA ,
'HKS Colors -- HKS 43K 060%  K 10%' => 0x4B61BE ,
'HKS Colors -- HKS 44K 060%  K 10%' => 0x547AB4 ,
'HKS Colors -- HKS 45K 060%  K 10%' => 0x7673A8 ,
'HKS Colors -- HKS 46K 060%  K 10%' => 0x618DAF ,
'HKS Colors -- HKS 47K 060%  K 10%' => 0x3E92C4 ,
'HKS Colors -- HKS 48K 060%  K 10%' => 0x3B99BC ,
'HKS Colors -- HKS 49K 060%  K 10%' => 0x3389B4 ,
'HKS Colors -- HKS 50K 060%  K 10%' => 0x72B3CC ,
'HKS Colors -- HKS 51K 060%  K 10%' => 0x57A1A6 ,
'HKS Colors -- HKS 52K 060%  K 10%' => 0x439288 ,
'HKS Colors -- HKS 53K 060%  K 10%' => 0x3DB79A ,
'HKS Colors -- HKS 54K 060%  K 10%' => 0x259468 ,
'HKS Colors -- HKS 55K 060%  K 10%' => 0x3C866F ,
'HKS Colors -- HKS 56K 060%  K 10%' => 0x4E7F78 ,
'HKS Colors -- HKS 57K 060%  K 10%' => 0x388B5A ,
'HKS Colors -- HKS 58K 060%  K 10%' => 0x5D7A60 ,
'HKS Colors -- HKS 59K 060%  K 10%' => 0x3D8A8D ,
'HKS Colors -- HKS 60K 060%  K 10%' => 0x6FA35F ,
'HKS Colors -- HKS 61K 060%  K 10%' => 0x5A7257 ,
'HKS Colors -- HKS 62K 060%  K 10%' => 0x787F51 ,
'HKS Colors -- HKS 63K 060%  K 10%' => 0x6E8E60 ,
'HKS Colors -- HKS 64K 060%  K 10%' => 0x5AA151 ,
'HKS Colors -- HKS 65K 060%  K 10%' => 0x70B154 ,
'HKS Colors -- HKS 66K 060%  K 10%' => 0x87B94B ,
'HKS Colors -- HKS 67K 060%  K 10%' => 0x8FC355 ,
'HKS Colors -- HKS 68K 060%  K 10%' => 0xC1B960 ,
'HKS Colors -- HKS 69K 060%  K 10%' => 0xC6C75D ,
'HKS Colors -- HKS 71K 060%  K 10%' => 0xC49D5F ,
'HKS Colors -- HKS 72K 060%  K 10%' => 0xBC8D49 ,
'HKS Colors -- HKS 73K 060%  K 10%' => 0xA98B5F ,
'HKS Colors -- HKS 74K 060%  K 10%' => 0x927A5A ,
'HKS Colors -- HKS 75K 060%  K 10%' => 0x8B8160 ,
'HKS Colors -- HKS 76K 060%  K 10%' => 0x605446 ,
'HKS Colors -- HKS 77K 060%  K 10%' => 0x746054 ,
'HKS Colors -- HKS 78K 060%  K 10%' => 0x845E55 ,
'HKS Colors -- HKS 81K 060%  K 10%' => 0xB5715A ,
'HKS Colors -- HKS 82K 060%  K 10%' => 0xA76F63 ,
'HKS Colors -- HKS 83K 060%  K 10%' => 0x7E5652 ,
'HKS Colors -- HKS 84K 060%  K 10%' => 0x70514E ,
'HKS Colors -- HKS 88K 060%  K 10%' => 0x6A6A6D ,
'HKS Colors -- HKS 89K 060%  K 10%' => 0xA7A196 ,
'HKS Colors -- HKS 90K 060%  K 10%' => 0x676364 ,
'HKS Colors -- HKS 91K 060%  K 10%' => 0xA4A9A8 ,
'HKS Colors -- HKS 92K 060%  K 10%' => 0x7E8182 ,
'HKS Colors -- HKS 93K 060%  K 10%' => 0x61676E ,
'HKS Colors -- HKS 95K 060%  K 10%' => 0x9A9993 ,
'HKS Colors -- HKS 96K 060%  K 10%' => 0x90908D ,
'HKS Colors -- HKS 97K 060%  K 10%' => 0x656966 ,
'HKS Colors -- HKS 01K 070%  K 10%' => 0xD6CA7C ,
'HKS Colors -- HKS 02K 070%  K 10%' => 0xD1CB35 ,
'HKS Colors -- HKS 03K 070%  K 10%' => 0xD7CE1E ,
'HKS Colors -- HKS 04K 070%  K 10%' => 0xD4B70A ,
'HKS Colors -- HKS 05K 070%  K 10%' => 0xDDB226 ,
'HKS Colors -- HKS 06K 070%  K 10%' => 0xDC882B ,
'HKS Colors -- HKS 07K 070%  K 10%' => 0xE16B25 ,
'HKS Colors -- HKS 08K 070%  K 10%' => 0xD9663E ,
'HKS Colors -- HKS 10K 070%  K 10%' => 0xD55143 ,
'HKS Colors -- HKS 11K 070%  K 10%' => 0xDA907D ,
'HKS Colors -- HKS 12K 070%  K 10%' => 0xC64243 ,
'HKS Colors -- HKS 13K 070%  K 10%' => 0xCD243B ,
'HKS Colors -- HKS 14K 070%  K 10%' => 0xBB4346 ,
'HKS Colors -- HKS 15K 070%  K 10%' => 0xAD3952 ,
'HKS Colors -- HKS 16K 070%  K 10%' => 0x9A3551 ,
'HKS Colors -- HKS 17K 070%  K 10%' => 0x9D355E ,
'HKS Colors -- HKS 18K 070%  K 10%' => 0x7C2D54 ,
'HKS Colors -- HKS 21K 070%  K 10%' => 0xD67E96 ,
'HKS Colors -- HKS 22K 070%  K 10%' => 0xD54457 ,
'HKS Colors -- HKS 23K 070%  K 10%' => 0xC13960 ,
'HKS Colors -- HKS 24K 070%  K 10%' => 0xB3366A ,
'HKS Colors -- HKS 25K 070%  K 10%' => 0xB43077 ,
'HKS Colors -- HKS 26K 070%  K 10%' => 0xA92A7E ,
'HKS Colors -- HKS 27K 070%  K 10%' => 0xC63399 ,
'HKS Colors -- HKS 28K 070%  K 10%' => 0xA03269 ,
'HKS Colors -- HKS 29K 070%  K 10%' => 0x904B94 ,
'HKS Colors -- HKS 31K 070%  K 10%' => 0xB5388E ,
'HKS Colors -- HKS 32K 070%  K 10%' => 0xA7166E ,
'HKS Colors -- HKS 33K 070%  K 10%' => 0x9A38B0 ,
'HKS Colors -- HKS 34K 070%  K 10%' => 0x704190 ,
'HKS Colors -- HKS 35K 070%  K 10%' => 0x56458E ,
'HKS Colors -- HKS 36K 070%  K 10%' => 0x633693 ,
'HKS Colors -- HKS 37K 070%  K 10%' => 0x684F87 ,
'HKS Colors -- HKS 38K 070%  K 10%' => 0x3A4A64 ,
'HKS Colors -- HKS 39K 070%  K 10%' => 0x4C6DBC ,
'HKS Colors -- HKS 40K 070%  K 10%' => 0x4E8AB1 ,
'HKS Colors -- HKS 41K 070%  K 10%' => 0x404D68 ,
'HKS Colors -- HKS 42K 070%  K 10%' => 0x4D53A4 ,
'HKS Colors -- HKS 43K 070%  K 10%' => 0x3A51B8 ,
'HKS Colors -- HKS 44K 070%  K 10%' => 0x3E6AAF ,
'HKS Colors -- HKS 45K 070%  K 10%' => 0x6763A1 ,
'HKS Colors -- HKS 46K 070%  K 10%' => 0x4F81A8 ,
'HKS Colors -- HKS 47K 070%  K 10%' => 0x248BC4 ,
'HKS Colors -- HKS 48K 070%  K 10%' => 0x1E93B9 ,
'HKS Colors -- HKS 49K 070%  K 10%' => 0x1B80AF ,
'HKS Colors -- HKS 50K 070%  K 10%' => 0x64AECA ,
'HKS Colors -- HKS 51K 070%  K 10%' => 0x449A9E ,
'HKS Colors -- HKS 52K 070%  K 10%' => 0x2A887B ,
'HKS Colors -- HKS 53K 070%  K 10%' => 0x19B18E ,
'HKS Colors -- HKS 54K 070%  K 10%' => 0x008B5A ,
'HKS Colors -- HKS 55K 070%  K 10%' => 0x257B63 ,
'HKS Colors -- HKS 56K 070%  K 10%' => 0x336E64 ,
'HKS Colors -- HKS 57K 070%  K 10%' => 0x1C8147 ,
'HKS Colors -- HKS 58K 070%  K 10%' => 0x446746 ,
'HKS Colors -- HKS 59K 070%  K 10%' => 0x1E8080 ,
'HKS Colors -- HKS 60K 070%  K 10%' => 0x589844 ,
'HKS Colors -- HKS 61K 070%  K 10%' => 0x405E3D ,
'HKS Colors -- HKS 62K 070%  K 10%' => 0x686E38 ,
'HKS Colors -- HKS 63K 070%  K 10%' => 0x567D44 ,
'HKS Colors -- HKS 64K 070%  K 10%' => 0x419739 ,
'HKS Colors -- HKS 65K 070%  K 10%' => 0x55A832 ,
'HKS Colors -- HKS 66K 070%  K 10%' => 0x7AB335 ,
'HKS Colors -- HKS 67K 070%  K 10%' => 0x7EBC34 ,
'HKS Colors -- HKS 68K 070%  K 10%' => 0xBDB54C ,
'HKS Colors -- HKS 69K 070%  K 10%' => 0xC1C446 ,
'HKS Colors -- HKS 71K 070%  K 10%' => 0xC3944C ,
'HKS Colors -- HKS 72K 070%  K 10%' => 0xB88132 ,
'HKS Colors -- HKS 73K 070%  K 10%' => 0xA3804C ,
'HKS Colors -- HKS 74K 070%  K 10%' => 0x876D46 ,
'HKS Colors -- HKS 75K 070%  K 10%' => 0x7F744E ,
'HKS Colors -- HKS 76K 070%  K 10%' => 0x4F4132 ,
'HKS Colors -- HKS 77K 070%  K 10%' => 0x654C3C ,
'HKS Colors -- HKS 78K 070%  K 10%' => 0x754B40 ,
'HKS Colors -- HKS 81K 070%  K 10%' => 0xAD5F41 ,
'HKS Colors -- HKS 82K 070%  K 10%' => 0xA15F4F ,
'HKS Colors -- HKS 83K 070%  K 10%' => 0x70433B ,
'HKS Colors -- HKS 84K 070%  K 10%' => 0x603D3A ,
'HKS Colors -- HKS 88K 070%  K 10%' => 0x555555 ,
'HKS Colors -- HKS 89K 070%  K 10%' => 0xA1998D ,
'HKS Colors -- HKS 90K 070%  K 10%' => 0x544C4D ,
'HKS Colors -- HKS 91K 070%  K 10%' => 0x9BA19E ,
'HKS Colors -- HKS 92K 070%  K 10%' => 0x707374 ,
'HKS Colors -- HKS 93K 070%  K 10%' => 0x52565D ,
'HKS Colors -- HKS 95K 070%  K 10%' => 0x8E8F87 ,
'HKS Colors -- HKS 96K 070%  K 10%' => 0x868480 ,
'HKS Colors -- HKS 97K 070%  K 10%' => 0x545855 ,
'HKS Colors -- HKS 01K 080%  K 10%' => 0xD3C667 ,
'HKS Colors -- HKS 02K 080%  K 10%' => 0xD0C603 ,
'HKS Colors -- HKS 03K 080%  K 10%' => 0xD7CB00 ,
'HKS Colors -- HKS 04K 080%  K 10%' => 0xD4B100 ,
'HKS Colors -- HKS 05K 080%  K 10%' => 0xDEAB00 ,
'HKS Colors -- HKS 06K 080%  K 10%' => 0xDB7800 ,
'HKS Colors -- HKS 07K 080%  K 10%' => 0xE05D00 ,
'HKS Colors -- HKS 08K 080%  K 10%' => 0xD75424 ,
'HKS Colors -- HKS 10K 080%  K 10%' => 0xD53A29 ,
'HKS Colors -- HKS 11K 080%  K 10%' => 0xDA826A ,
'HKS Colors -- HKS 12K 080%  K 10%' => 0xC22927 ,
'HKS Colors -- HKS 13K 080%  K 10%' => 0xCA0E28 ,
'HKS Colors -- HKS 14K 080%  K 10%' => 0xB4292F ,
'HKS Colors -- HKS 15K 080%  K 10%' => 0xA81A3A ,
'HKS Colors -- HKS 16K 080%  K 10%' => 0x8F1C3A ,
'HKS Colors -- HKS 17K 080%  K 10%' => 0x931949 ,
'HKS Colors -- HKS 18K 080%  K 10%' => 0x6B123D ,
'HKS Colors -- HKS 21K 080%  K 10%' => 0xD66E89 ,
'HKS Colors -- HKS 22K 080%  K 10%' => 0xD32B41 ,
'HKS Colors -- HKS 23K 080%  K 10%' => 0xBC1B4C ,
'HKS Colors -- HKS 24K 080%  K 10%' => 0xAE225B ,
'HKS Colors -- HKS 25K 080%  K 10%' => 0xB01167 ,
'HKS Colors -- HKS 26K 080%  K 10%' => 0xA20A6E ,
'HKS Colors -- HKS 27K 080%  K 10%' => 0xC30A8B ,
'HKS Colors -- HKS 28K 080%  K 10%' => 0x971256 ,
'HKS Colors -- HKS 29K 080%  K 10%' => 0x823185 ,
'HKS Colors -- HKS 31K 080%  K 10%' => 0xAF1681 ,
'HKS Colors -- HKS 32K 080%  K 10%' => 0x9E005D ,
'HKS Colors -- HKS 33K 080%  K 10%' => 0x8D16A4 ,
'HKS Colors -- HKS 34K 080%  K 10%' => 0x5E2782 ,
'HKS Colors -- HKS 35K 080%  K 10%' => 0x432E7F ,
'HKS Colors -- HKS 36K 080%  K 10%' => 0x532285 ,
'HKS Colors -- HKS 37K 080%  K 10%' => 0x523577 ,
'HKS Colors -- HKS 38K 080%  K 10%' => 0x1E2F4A ,
'HKS Colors -- HKS 39K 080%  K 10%' => 0x345CB5 ,
'HKS Colors -- HKS 40K 080%  K 10%' => 0x337DA6 ,
'HKS Colors -- HKS 41K 080%  K 10%' => 0x273653 ,
'HKS Colors -- HKS 42K 080%  K 10%' => 0x333999 ,
'HKS Colors -- HKS 43K 080%  K 10%' => 0x273EB3 ,
'HKS Colors -- HKS 44K 080%  K 10%' => 0x245AA6 ,
'HKS Colors -- HKS 45K 080%  K 10%' => 0x555298 ,
'HKS Colors -- HKS 46K 080%  K 10%' => 0x3673A1 ,
'HKS Colors -- HKS 47K 080%  K 10%' => 0x007FBD ,
'HKS Colors -- HKS 48K 080%  K 10%' => 0x0089B2 ,
'HKS Colors -- HKS 49K 080%  K 10%' => 0x0075A6 ,
'HKS Colors -- HKS 50K 080%  K 10%' => 0x4CA8C7 ,
'HKS Colors -- HKS 51K 080%  K 10%' => 0x208D92 ,
'HKS Colors -- HKS 52K 080%  K 10%' => 0x007867 ,
'HKS Colors -- HKS 53K 080%  K 10%' => 0x00A782 ,
'HKS Colors -- HKS 54K 080%  K 10%' => 0x007E4F ,
'HKS Colors -- HKS 55K 080%  K 10%' => 0x006A4C ,
'HKS Colors -- HKS 56K 080%  K 10%' => 0x0B584B ,
'HKS Colors -- HKS 57K 080%  K 10%' => 0x007435 ,
'HKS Colors -- HKS 58K 080%  K 10%' => 0x29522A ,
'HKS Colors -- HKS 59K 080%  K 10%' => 0x007172 ,
'HKS Colors -- HKS 60K 080%  K 10%' => 0x3E8925 ,
'HKS Colors -- HKS 61K 080%  K 10%' => 0x244623 ,
'HKS Colors -- HKS 62K 080%  K 10%' => 0x555B19 ,
'HKS Colors -- HKS 63K 080%  K 10%' => 0x3A6824 ,
'HKS Colors -- HKS 64K 080%  K 10%' => 0x288E22 ,
'HKS Colors -- HKS 65K 080%  K 10%' => 0x3CA10F ,
'HKS Colors -- HKS 66K 080%  K 10%' => 0x6AAD13 ,
'HKS Colors -- HKS 67K 080%  K 10%' => 0x6AB301 ,
'HKS Colors -- HKS 68K 080%  K 10%' => 0xB7AE2E ,
'HKS Colors -- HKS 69K 080%  K 10%' => 0xBCC025 ,
'HKS Colors -- HKS 71K 080%  K 10%' => 0xBC8730 ,
'HKS Colors -- HKS 72K 080%  K 10%' => 0xB27417 ,
'HKS Colors -- HKS 73K 080%  K 10%' => 0x997032 ,
'HKS Colors -- HKS 74K 080%  K 10%' => 0x78582B ,
'HKS Colors -- HKS 75K 080%  K 10%' => 0x6F5F31 ,
'HKS Colors -- HKS 76K 080%  K 10%' => 0x403020 ,
'HKS Colors -- HKS 77K 080%  K 10%' => 0x513423 ,
'HKS Colors -- HKS 78K 080%  K 10%' => 0x653427 ,
'HKS Colors -- HKS 81K 080%  K 10%' => 0xA64C29 ,
'HKS Colors -- HKS 82K 080%  K 10%' => 0x974A35 ,
'HKS Colors -- HKS 83K 080%  K 10%' => 0x643229 ,
'HKS Colors -- HKS 84K 080%  K 10%' => 0x532B28 ,
'HKS Colors -- HKS 88K 080%  K 10%' => 0x3C3B3A ,
'HKS Colors -- HKS 89K 080%  K 10%' => 0x989081 ,
'HKS Colors -- HKS 90K 080%  K 10%' => 0x3C3232 ,
'HKS Colors -- HKS 91K 080%  K 10%' => 0x8D9693 ,
'HKS Colors -- HKS 92K 080%  K 10%' => 0x5E6160 ,
'HKS Colors -- HKS 93K 080%  K 10%' => 0x41464F ,
'HKS Colors -- HKS 95K 080%  K 10%' => 0x82847D ,
'HKS Colors -- HKS 96K 080%  K 10%' => 0x767471 ,
'HKS Colors -- HKS 97K 080%  K 10%' => 0x393E39 ,
'HKS Colors -- HKS 01K 090%  K 10%' => 0xD5C255 ,
'HKS Colors -- HKS 02K 090%  K 10%' => 0xCFC400 ,
'HKS Colors -- HKS 03K 090%  K 10%' => 0xD8C900 ,
'HKS Colors -- HKS 04K 090%  K 10%' => 0xD7AD00 ,
'HKS Colors -- HKS 05K 090%  K 10%' => 0xE0A400 ,
'HKS Colors -- HKS 06K 090%  K 10%' => 0xDE7500 ,
'HKS Colors -- HKS 07K 090%  K 10%' => 0xE05500 ,
'HKS Colors -- HKS 08K 090%  K 10%' => 0xD7440A ,
'HKS Colors -- HKS 10K 090%  K 10%' => 0xD12610 ,
'HKS Colors -- HKS 11K 090%  K 10%' => 0xDA765C ,
'HKS Colors -- HKS 12K 090%  K 10%' => 0xC01417 ,
'HKS Colors -- HKS 13K 090%  K 10%' => 0xC7001B ,
'HKS Colors -- HKS 14K 090%  K 10%' => 0xB1141E ,
'HKS Colors -- HKS 15K 090%  K 10%' => 0xA00025 ,
'HKS Colors -- HKS 16K 090%  K 10%' => 0x810B25 ,
'HKS Colors -- HKS 17K 090%  K 10%' => 0x860033 ,
'HKS Colors -- HKS 18K 090%  K 10%' => 0x5D022B ,
'HKS Colors -- HKS 21K 090%  K 10%' => 0xD45F7C ,
'HKS Colors -- HKS 22K 090%  K 10%' => 0xCD192A ,
'HKS Colors -- HKS 23K 090%  K 10%' => 0xB70036 ,
'HKS Colors -- HKS 24K 090%  K 10%' => 0xA40B47 ,
'HKS Colors -- HKS 25K 090%  K 10%' => 0xA80055 ,
'HKS Colors -- HKS 26K 090%  K 10%' => 0x98005F ,
'HKS Colors -- HKS 27K 090%  K 10%' => 0xB8007D ,
'HKS Colors -- HKS 28K 090%  K 10%' => 0x8B0043 ,
'HKS Colors -- HKS 29K 090%  K 10%' => 0x761376 ,
'HKS Colors -- HKS 31K 090%  K 10%' => 0xA50072 ,
'HKS Colors -- HKS 32K 090%  K 10%' => 0x960052 ,
'HKS Colors -- HKS 33K 090%  K 10%' => 0x850099 ,
'HKS Colors -- HKS 34K 090%  K 10%' => 0x4E1473 ,
'HKS Colors -- HKS 35K 090%  K 10%' => 0x352071 ,
'HKS Colors -- HKS 36K 090%  K 10%' => 0x45137A ,
'HKS Colors -- HKS 37K 090%  K 10%' => 0x401B66 ,
'HKS Colors -- HKS 38K 090%  K 10%' => 0x102139 ,
'HKS Colors -- HKS 39K 090%  K 10%' => 0x204CAF ,
'HKS Colors -- HKS 40K 090%  K 10%' => 0x126F9C ,
'HKS Colors -- HKS 41K 090%  K 10%' => 0x162643 ,
'HKS Colors -- HKS 42K 090%  K 10%' => 0x1D238D ,
'HKS Colors -- HKS 43K 090%  K 10%' => 0x172AAA ,
'HKS Colors -- HKS 44K 090%  K 10%' => 0x124B9D ,
'HKS Colors -- HKS 45K 090%  K 10%' => 0x45408E ,
'HKS Colors -- HKS 46K 090%  K 10%' => 0x276999 ,
'HKS Colors -- HKS 47K 090%  K 10%' => 0x007AB8 ,
'HKS Colors -- HKS 48K 090%  K 10%' => 0x0080A9 ,
'HKS Colors -- HKS 49K 090%  K 10%' => 0x006B9B ,
'HKS Colors -- HKS 50K 090%  K 10%' => 0x33A0C3 ,
'HKS Colors -- HKS 51K 090%  K 10%' => 0x008188 ,
'HKS Colors -- HKS 52K 090%  K 10%' => 0x006D5C ,
'HKS Colors -- HKS 53K 090%  K 10%' => 0x00A17B ,
'HKS Colors -- HKS 54K 090%  K 10%' => 0x007444 ,
'HKS Colors -- HKS 55K 090%  K 10%' => 0x005B3E ,
'HKS Colors -- HKS 56K 090%  K 10%' => 0x00473A ,
'HKS Colors -- HKS 57K 090%  K 10%' => 0x006930 ,
'HKS Colors -- HKS 58K 090%  K 10%' => 0x1E4622 ,
'HKS Colors -- HKS 59K 090%  K 10%' => 0x006363 ,
'HKS Colors -- HKS 60K 090%  K 10%' => 0x267C08 ,
'HKS Colors -- HKS 61K 090%  K 10%' => 0x193A18 ,
'HKS Colors -- HKS 62K 090%  K 10%' => 0x474D0D ,
'HKS Colors -- HKS 63K 090%  K 10%' => 0x2B5C17 ,
'HKS Colors -- HKS 64K 090%  K 10%' => 0x108211 ,
'HKS Colors -- HKS 65K 090%  K 10%' => 0x2E9900 ,
'HKS Colors -- HKS 66K 090%  K 10%' => 0x5DA500 ,
'HKS Colors -- HKS 67K 090%  K 10%' => 0x5EAB00 ,
'HKS Colors -- HKS 68K 090%  K 10%' => 0xB2A50B ,
'HKS Colors -- HKS 69K 090%  K 10%' => 0xB7B900 ,
'HKS Colors -- HKS 71K 090%  K 10%' => 0xBA7F1E ,
'HKS Colors -- HKS 72K 090%  K 10%' => 0xAF6702 ,
'HKS Colors -- HKS 73K 090%  K 10%' => 0x90601C ,
'HKS Colors -- HKS 74K 090%  K 10%' => 0x6E4A1A ,
'HKS Colors -- HKS 75K 090%  K 10%' => 0x635321 ,
'HKS Colors -- HKS 76K 090%  K 10%' => 0x362819 ,
'HKS Colors -- HKS 77K 090%  K 10%' => 0x442617 ,
'HKS Colors -- HKS 78K 090%  K 10%' => 0x5B281A ,
'HKS Colors -- HKS 81K 090%  K 10%' => 0xA0401C ,
'HKS Colors -- HKS 82K 090%  K 10%' => 0x883821 ,
'HKS Colors -- HKS 83K 090%  K 10%' => 0x5A2620 ,
'HKS Colors -- HKS 84K 090%  K 10%' => 0x492422 ,
'HKS Colors -- HKS 88K 090%  K 10%' => 0x22211D ,
'HKS Colors -- HKS 89K 090%  K 10%' => 0x8F8776 ,
'HKS Colors -- HKS 90K 090%  K 10%' => 0x2B2422 ,
'HKS Colors -- HKS 91K 090%  K 10%' => 0x828A86 ,
'HKS Colors -- HKS 92K 090%  K 10%' => 0x535554 ,
'HKS Colors -- HKS 93K 090%  K 10%' => 0x353B43 ,
'HKS Colors -- HKS 95K 090%  K 10%' => 0x7A7A71 ,
'HKS Colors -- HKS 96K 090%  K 10%' => 0x67655F ,
'HKS Colors -- HKS 97K 090%  K 10%' => 0x252A24 ,
'HKS Colors -- HKS 01K 100%  K 10%' => 0xD1BD45 ,
'HKS Colors -- HKS 02K 100%  K 10%' => 0xCDC200 ,
'HKS Colors -- HKS 03K 100%  K 10%' => 0xD8C500 ,
'HKS Colors -- HKS 04K 100%  K 10%' => 0xD9AA00 ,
'HKS Colors -- HKS 05K 100%  K 10%' => 0xDEA000 ,
'HKS Colors -- HKS 06K 100%  K 10%' => 0xE07000 ,
'HKS Colors -- HKS 07K 100%  K 10%' => 0xDE4E00 ,
'HKS Colors -- HKS 08K 100%  K 10%' => 0xD83A00 ,
'HKS Colors -- HKS 10K 100%  K 10%' => 0xCE1D03 ,
'HKS Colors -- HKS 11K 100%  K 10%' => 0xDB6D51 ,
'HKS Colors -- HKS 12K 100%  K 10%' => 0xBD090E ,
'HKS Colors -- HKS 13K 100%  K 10%' => 0xC40014 ,
'HKS Colors -- HKS 14K 100%  K 10%' => 0xAF0616 ,
'HKS Colors -- HKS 15K 100%  K 10%' => 0x99001D ,
'HKS Colors -- HKS 16K 100%  K 10%' => 0x77051C ,
'HKS Colors -- HKS 17K 100%  K 10%' => 0x7C0027 ,
'HKS Colors -- HKS 18K 100%  K 10%' => 0x52001E ,
'HKS Colors -- HKS 21K 100%  K 10%' => 0xD05270 ,
'HKS Colors -- HKS 22K 100%  K 10%' => 0xCB0E21 ,
'HKS Colors -- HKS 23K 100%  K 10%' => 0xB2002E ,
'HKS Colors -- HKS 24K 100%  K 10%' => 0x9C003A ,
'HKS Colors -- HKS 25K 100%  K 10%' => 0xA40049 ,
'HKS Colors -- HKS 26K 100%  K 10%' => 0x8F0054 ,
'HKS Colors -- HKS 27K 100%  K 10%' => 0xB30074 ,
'HKS Colors -- HKS 28K 100%  K 10%' => 0x840036 ,
'HKS Colors -- HKS 29K 100%  K 10%' => 0x6D0068 ,
'HKS Colors -- HKS 31K 100%  K 10%' => 0x9C0067 ,
'HKS Colors -- HKS 32K 100%  K 10%' => 0x92004B ,
'HKS Colors -- HKS 33K 100%  K 10%' => 0x7F008F ,
'HKS Colors -- HKS 34K 100%  K 10%' => 0x490A6D ,
'HKS Colors -- HKS 35K 100%  K 10%' => 0x2D1869 ,
'HKS Colors -- HKS 36K 100%  K 10%' => 0x3D0B72 ,
'HKS Colors -- HKS 37K 100%  K 10%' => 0x320F56 ,
'HKS Colors -- HKS 38K 100%  K 10%' => 0x0B192F ,
'HKS Colors -- HKS 39K 100%  K 10%' => 0x1742A7 ,
'HKS Colors -- HKS 40K 100%  K 10%' => 0x006192 ,
'HKS Colors -- HKS 41K 100%  K 10%' => 0x0F1C38 ,
'HKS Colors -- HKS 42K 100%  K 10%' => 0x171882 ,
'HKS Colors -- HKS 43K 100%  K 10%' => 0x111EA4 ,
'HKS Colors -- HKS 44K 100%  K 10%' => 0x004197 ,
'HKS Colors -- HKS 45K 100%  K 10%' => 0x363181 ,
'HKS Colors -- HKS 46K 100%  K 10%' => 0x176091 ,
'HKS Colors -- HKS 47K 100%  K 10%' => 0x0071B2 ,
'HKS Colors -- HKS 48K 100%  K 10%' => 0x007BA4 ,
'HKS Colors -- HKS 49K 100%  K 10%' => 0x006493 ,
'HKS Colors -- HKS 50K 100%  K 10%' => 0x219AC1 ,
'HKS Colors -- HKS 51K 100%  K 10%' => 0x00787F ,
'HKS Colors -- HKS 52K 100%  K 10%' => 0x006654 ,
'HKS Colors -- HKS 53K 100%  K 10%' => 0x009B77 ,
'HKS Colors -- HKS 54K 100%  K 10%' => 0x006D40 ,
'HKS Colors -- HKS 55K 100%  K 10%' => 0x005234 ,
'HKS Colors -- HKS 56K 100%  K 10%' => 0x003B2E ,
'HKS Colors -- HKS 57K 100%  K 10%' => 0x005F29 ,
'HKS Colors -- HKS 58K 100%  K 10%' => 0x173D1B ,
'HKS Colors -- HKS 59K 100%  K 10%' => 0x005A57 ,
'HKS Colors -- HKS 60K 100%  K 10%' => 0x177300 ,
'HKS Colors -- HKS 61K 100%  K 10%' => 0x113112 ,
'HKS Colors -- HKS 62K 100%  K 10%' => 0x3C4207 ,
'HKS Colors -- HKS 63K 100%  K 10%' => 0x22530F ,
'HKS Colors -- HKS 64K 100%  K 10%' => 0x007A08 ,
'HKS Colors -- HKS 65K 100%  K 10%' => 0x229000 ,
'HKS Colors -- HKS 66K 100%  K 10%' => 0x57A300 ,
'HKS Colors -- HKS 67K 100%  K 10%' => 0x55A600 ,
'HKS Colors -- HKS 68K 100%  K 10%' => 0xAB9D00 ,
'HKS Colors -- HKS 69K 100%  K 10%' => 0xB2B300 ,
'HKS Colors -- HKS 71K 100%  K 10%' => 0xB77A16 ,
'HKS Colors -- HKS 72K 100%  K 10%' => 0xA85E00 ,
'HKS Colors -- HKS 73K 100%  K 10%' => 0x885612 ,
'HKS Colors -- HKS 74K 100%  K 10%' => 0x643E11 ,
'HKS Colors -- HKS 75K 100%  K 10%' => 0x574616 ,
'HKS Colors -- HKS 76K 100%  K 10%' => 0x332517 ,
'HKS Colors -- HKS 77K 100%  K 10%' => 0x3B2112 ,
'HKS Colors -- HKS 78K 100%  K 10%' => 0x512013 ,
'HKS Colors -- HKS 81K 100%  K 10%' => 0x9A3814 ,
'HKS Colors -- HKS 82K 100%  K 10%' => 0x7C2813 ,
'HKS Colors -- HKS 83K 100%  K 10%' => 0x552119 ,
'HKS Colors -- HKS 84K 100%  K 10%' => 0x421D1A ,
'HKS Colors -- HKS 88K 100%  K 10%' => 0x0F0E0B ,
'HKS Colors -- HKS 89K 100%  K 10%' => 0x877E6D ,
'HKS Colors -- HKS 90K 100%  K 10%' => 0x221A18 ,
'HKS Colors -- HKS 91K 100%  K 10%' => 0x76807B ,
'HKS Colors -- HKS 92K 100%  K 10%' => 0x4A4E4D ,
'HKS Colors -- HKS 93K 100%  K 10%' => 0x2F343B ,
'HKS Colors -- HKS 95K 100%  K 10%' => 0x727269 ,
'HKS Colors -- HKS 96K 100%  K 10%' => 0x585A53 ,
'HKS Colors -- HKS 97K 100%  K 10%' => 0x1C221C ,
'HKS Colors -- HKS 01K 010%  K 30%' => 0xA9A7A0 ,
'HKS Colors -- HKS 02K 010%  K 30%' => 0xA7A69A ,
'HKS Colors -- HKS 03K 010%  K 30%' => 0xA9A998 ,
'HKS Colors -- HKS 04K 010%  K 30%' => 0xA3A296 ,
'HKS Colors -- HKS 05K 010%  K 30%' => 0xA7A394 ,
'HKS Colors -- HKS 06K 010%  K 30%' => 0x9B9188 ,
'HKS Colors -- HKS 07K 010%  K 30%' => 0xA18F8A ,
'HKS Colors -- HKS 08K 010%  K 30%' => 0x9D8D8A ,
'HKS Colors -- HKS 10K 010%  K 30%' => 0xA29396 ,
'HKS Colors -- HKS 11K 010%  K 30%' => 0xA79D9E ,
'HKS Colors -- HKS 12K 010%  K 30%' => 0x9E9094 ,
'HKS Colors -- HKS 13K 010%  K 30%' => 0xA18D92 ,
'HKS Colors -- HKS 14K 010%  K 30%' => 0x998E91 ,
'HKS Colors -- HKS 15K 010%  K 30%' => 0x988A91 ,
'HKS Colors -- HKS 16K 010%  K 30%' => 0x988A91 ,
'HKS Colors -- HKS 17K 010%  K 30%' => 0x9C8F98 ,
'HKS Colors -- HKS 18K 010%  K 30%' => 0x978D94 ,
'HKS Colors -- HKS 21K 010%  K 30%' => 0xA1979E ,
'HKS Colors -- HKS 22K 010%  K 30%' => 0xA8939A ,
'HKS Colors -- HKS 23K 010%  K 30%' => 0x9D8D94 ,
'HKS Colors -- HKS 24K 010%  K 30%' => 0x9C8994 ,
'HKS Colors -- HKS 25K 010%  K 30%' => 0xA2929E ,
'HKS Colors -- HKS 26K 010%  K 30%' => 0x9D8F9A ,
'HKS Colors -- HKS 27K 010%  K 30%' => 0x9B8A99 ,
'HKS Colors -- HKS 28K 010%  K 30%' => 0x91878F ,
'HKS Colors -- HKS 29K 010%  K 30%' => 0x938B98 ,
'HKS Colors -- HKS 31K 010%  K 30%' => 0x9D8F9A ,
'HKS Colors -- HKS 32K 010%  K 30%' => 0x9C8B9A ,
'HKS Colors -- HKS 33K 010%  K 30%' => 0x9B8FA2 ,
'HKS Colors -- HKS 34K 010%  K 30%' => 0x938F9C ,
'HKS Colors -- HKS 35K 010%  K 30%' => 0x9796A5 ,
'HKS Colors -- HKS 36K 010%  K 30%' => 0x9792A3 ,
'HKS Colors -- HKS 37K 010%  K 30%' => 0x94929C ,
'HKS Colors -- HKS 38K 010%  K 30%' => 0x999CA5 ,
'HKS Colors -- HKS 39K 010%  K 30%' => 0x9196A4 ,
'HKS Colors -- HKS 40K 010%  K 30%' => 0x8E949C ,
'HKS Colors -- HKS 41K 010%  K 30%' => 0x8E919A ,
'HKS Colors -- HKS 42K 010%  K 30%' => 0x8D8F9D ,
'HKS Colors -- HKS 43K 010%  K 30%' => 0x8D8FA0 ,
'HKS Colors -- HKS 44K 010%  K 30%' => 0x8E92A0 ,
'HKS Colors -- HKS 45K 010%  K 30%' => 0x93929E ,
'HKS Colors -- HKS 46K 010%  K 30%' => 0x9298A1 ,
'HKS Colors -- HKS 47K 010%  K 30%' => 0x8D97A0 ,
'HKS Colors -- HKS 48K 010%  K 30%' => 0x89969E ,
'HKS Colors -- HKS 49K 010%  K 30%' => 0x849199 ,
'HKS Colors -- HKS 50K 010%  K 30%' => 0x949CA2 ,
'HKS Colors -- HKS 51K 010%  K 30%' => 0x8D999C ,
'HKS Colors -- HKS 52K 010%  K 30%' => 0x8D9A9D ,
'HKS Colors -- HKS 53K 010%  K 30%' => 0x919EA0 ,
'HKS Colors -- HKS 54K 010%  K 30%' => 0x8D9B97 ,
'HKS Colors -- HKS 55K 010%  K 30%' => 0x8D9998 ,
'HKS Colors -- HKS 56K 010%  K 30%' => 0x929A9D ,
'HKS Colors -- HKS 57K 010%  K 30%' => 0x8A9992 ,
'HKS Colors -- HKS 58K 010%  K 30%' => 0x909392 ,
'HKS Colors -- HKS 59K 010%  K 30%' => 0x8D999C ,
'HKS Colors -- HKS 60K 010%  K 30%' => 0x969D97 ,
'HKS Colors -- HKS 61K 010%  K 30%' => 0x8E9193 ,
'HKS Colors -- HKS 62K 010%  K 30%' => 0x91938E ,
'HKS Colors -- HKS 63K 010%  K 30%' => 0x929893 ,
'HKS Colors -- HKS 64K 010%  K 30%' => 0x939D94 ,
'HKS Colors -- HKS 65K 010%  K 30%' => 0x98A197 ,
'HKS Colors -- HKS 66K 010%  K 30%' => 0x98A091 ,
'HKS Colors -- HKS 67K 010%  K 30%' => 0xA2A99B ,
'HKS Colors -- HKS 68K 010%  K 30%' => 0xA1A197 ,
'HKS Colors -- HKS 69K 010%  K 30%' => 0xA5A59B ,
'HKS Colors -- HKS 71K 010%  K 30%' => 0x9B9790 ,
'HKS Colors -- HKS 72K 010%  K 30%' => 0x97918B ,
'HKS Colors -- HKS 73K 010%  K 30%' => 0x9B9792 ,
'HKS Colors -- HKS 74K 010%  K 30%' => 0x9A9794 ,
'HKS Colors -- HKS 75K 010%  K 30%' => 0x999997 ,
'HKS Colors -- HKS 76K 010%  K 30%' => 0x99979A ,
'HKS Colors -- HKS 77K 010%  K 30%' => 0x989696 ,
'HKS Colors -- HKS 78K 010%  K 30%' => 0x9E989A ,
'HKS Colors -- HKS 81K 010%  K 30%' => 0xA09697 ,
'HKS Colors -- HKS 82K 010%  K 30%' => 0xA49899 ,
'HKS Colors -- HKS 83K 010%  K 30%' => 0x999394 ,
'HKS Colors -- HKS 84K 010%  K 30%' => 0x969094 ,
'HKS Colors -- HKS 88K 010%  K 30%' => 0xD9D7DA ,
'HKS Colors -- HKS 89K 010%  K 30%' => 0x9D9DA0 ,
'HKS Colors -- HKS 90K 010%  K 30%' => 0x929197 ,
'HKS Colors -- HKS 91K 010%  K 30%' => 0xA0A2A6 ,
'HKS Colors -- HKS 92K 010%  K 30%' => 0x9A9BA0 ,
'HKS Colors -- HKS 93K 010%  K 30%' => 0x919297 ,
'HKS Colors -- HKS 95K 010%  K 30%' => 0x97979A ,
'HKS Colors -- HKS 96K 010%  K 30%' => 0x9A9B9D ,
'HKS Colors -- HKS 97K 010%  K 30%' => 0x8D8D8F ,
'HKS Colors -- HKS 01K 020%  K 30%' => 0xA9A797 ,
'HKS Colors -- HKS 02K 020%  K 30%' => 0xA8A98D ,
'HKS Colors -- HKS 03K 020%  K 30%' => 0xAAA884 ,
'HKS Colors -- HKS 04K 020%  K 30%' => 0xA19B81 ,
'HKS Colors -- HKS 05K 020%  K 30%' => 0xA79E84 ,
'HKS Colors -- HKS 06K 020%  K 30%' => 0x9C8A78 ,
'HKS Colors -- HKS 07K 020%  K 30%' => 0xA28277 ,
'HKS Colors -- HKS 08K 020%  K 30%' => 0x9D807C ,
'HKS Colors -- HKS 10K 020%  K 30%' => 0xA68787 ,
'HKS Colors -- HKS 11K 020%  K 30%' => 0xA89493 ,
'HKS Colors -- HKS 12K 020%  K 30%' => 0x9B8084 ,
'HKS Colors -- HKS 13K 020%  K 30%' => 0xA27C84 ,
'HKS Colors -- HKS 14K 020%  K 30%' => 0x987D80 ,
'HKS Colors -- HKS 15K 020%  K 30%' => 0x947C84 ,
'HKS Colors -- HKS 16K 020%  K 30%' => 0x947C86 ,
'HKS Colors -- HKS 17K 020%  K 30%' => 0x947F8A ,
'HKS Colors -- HKS 18K 020%  K 30%' => 0x8D7B87 ,
'HKS Colors -- HKS 21K 020%  K 30%' => 0xA08D94 ,
'HKS Colors -- HKS 22K 020%  K 30%' => 0xA6868E ,
'HKS Colors -- HKS 23K 020%  K 30%' => 0x9C7E89 ,
'HKS Colors -- HKS 24K 020%  K 30%' => 0x997686 ,
'HKS Colors -- HKS 25K 020%  K 30%' => 0x9E8296 ,
'HKS Colors -- HKS 26K 020%  K 30%' => 0x987D91 ,
'HKS Colors -- HKS 27K 020%  K 30%' => 0x9D7A93 ,
'HKS Colors -- HKS 28K 020%  K 30%' => 0x8B7885 ,
'HKS Colors -- HKS 29K 020%  K 30%' => 0x8D7C91 ,
'HKS Colors -- HKS 31K 020%  K 30%' => 0x9A7C91 ,
'HKS Colors -- HKS 32K 020%  K 30%' => 0x9B7D92 ,
'HKS Colors -- HKS 33K 020%  K 30%' => 0x937C9B ,
'HKS Colors -- HKS 34K 020%  K 30%' => 0x897E96 ,
'HKS Colors -- HKS 35K 020%  K 30%' => 0x898499 ,
'HKS Colors -- HKS 36K 020%  K 30%' => 0x8B829B ,
'HKS Colors -- HKS 37K 020%  K 30%' => 0x878493 ,
'HKS Colors -- HKS 38K 020%  K 30%' => 0x848893 ,
'HKS Colors -- HKS 39K 020%  K 30%' => 0x8189A0 ,
'HKS Colors -- HKS 40K 020%  K 30%' => 0x82919B ,
'HKS Colors -- HKS 41K 020%  K 30%' => 0x7D808B ,
'HKS Colors -- HKS 42K 020%  K 30%' => 0x7F8199 ,
'HKS Colors -- HKS 43K 020%  K 30%' => 0x7B819C ,
'HKS Colors -- HKS 44K 020%  K 30%' => 0x7D889B ,
'HKS Colors -- HKS 45K 020%  K 30%' => 0x878798 ,
'HKS Colors -- HKS 46K 020%  K 30%' => 0x8792A1 ,
'HKS Colors -- HKS 47K 020%  K 30%' => 0x7B8E9E ,
'HKS Colors -- HKS 48K 020%  K 30%' => 0x78919D ,
'HKS Colors -- HKS 49K 020%  K 30%' => 0x728797 ,
'HKS Colors -- HKS 50K 020%  K 30%' => 0x8999A1 ,
'HKS Colors -- HKS 51K 020%  K 30%' => 0x7E9397 ,
'HKS Colors -- HKS 52K 020%  K 30%' => 0x7C9293 ,
'HKS Colors -- HKS 53K 020%  K 30%' => 0x7F9D98 ,
'HKS Colors -- HKS 54K 020%  K 30%' => 0x779388 ,
'HKS Colors -- HKS 55K 020%  K 30%' => 0x788E89 ,
'HKS Colors -- HKS 56K 020%  K 30%' => 0x7F9090 ,
'HKS Colors -- HKS 57K 020%  K 30%' => 0x779084 ,
'HKS Colors -- HKS 58K 020%  K 30%' => 0x818985 ,
'HKS Colors -- HKS 59K 020%  K 30%' => 0x7B8F93 ,
'HKS Colors -- HKS 60K 020%  K 30%' => 0x8A9887 ,
'HKS Colors -- HKS 61K 020%  K 30%' => 0x808882 ,
'HKS Colors -- HKS 62K 020%  K 30%' => 0x86887C ,
'HKS Colors -- HKS 63K 020%  K 30%' => 0x868F85 ,
'HKS Colors -- HKS 64K 020%  K 30%' => 0x859886 ,
'HKS Colors -- HKS 65K 020%  K 30%' => 0x879B81 ,
'HKS Colors -- HKS 66K 020%  K 30%' => 0x8D9C7D ,
'HKS Colors -- HKS 67K 020%  K 30%' => 0x96A585 ,
'HKS Colors -- HKS 68K 020%  K 30%' => 0xA09E8B ,
'HKS Colors -- HKS 69K 020%  K 30%' => 0xA1A389 ,
'HKS Colors -- HKS 71K 020%  K 30%' => 0x988E82 ,
'HKS Colors -- HKS 72K 020%  K 30%' => 0x93887B ,
'HKS Colors -- HKS 73K 020%  K 30%' => 0x978E87 ,
'HKS Colors -- HKS 74K 020%  K 30%' => 0x918B86 ,
'HKS Colors -- HKS 75K 020%  K 30%' => 0x918F89 ,
'HKS Colors -- HKS 76K 020%  K 30%' => 0x8E8A8B ,
'HKS Colors -- HKS 77K 020%  K 30%' => 0x8E8787 ,
'HKS Colors -- HKS 78K 020%  K 30%' => 0x948889 ,
'HKS Colors -- HKS 81K 020%  K 30%' => 0x9C8885 ,
'HKS Colors -- HKS 82K 020%  K 30%' => 0x9D8A89 ,
'HKS Colors -- HKS 83K 020%  K 30%' => 0x8F8789 ,
'HKS Colors -- HKS 84K 020%  K 30%' => 0x898084 ,
'HKS Colors -- HKS 88K 020%  K 30%' => 0xC4C1C5 ,
'HKS Colors -- HKS 89K 020%  K 30%' => 0x949494 ,
'HKS Colors -- HKS 90K 020%  K 30%' => 0x828186 ,
'HKS Colors -- HKS 91K 020%  K 30%' => 0x9A9B9D ,
'HKS Colors -- HKS 92K 020%  K 30%' => 0x8F9196 ,
'HKS Colors -- HKS 93K 020%  K 30%' => 0x85878B ,
'HKS Colors -- HKS 95K 020%  K 30%' => 0x8F9092 ,
'HKS Colors -- HKS 96K 020%  K 30%' => 0x919294 ,
'HKS Colors -- HKS 97K 020%  K 30%' => 0x818184 ,
'HKS Colors -- HKS 01K 030%  K 30%' => 0xA8A78E ,
'HKS Colors -- HKS 02K 030%  K 30%' => 0xA7A77D ,
'HKS Colors -- HKS 03K 030%  K 30%' => 0xABA976 ,
'HKS Colors -- HKS 04K 030%  K 30%' => 0xA09A72 ,
'HKS Colors -- HKS 05K 030%  K 30%' => 0xAA9E76 ,
'HKS Colors -- HKS 06K 030%  K 30%' => 0x9E8469 ,
'HKS Colors -- HKS 07K 030%  K 30%' => 0xA27C6D ,
'HKS Colors -- HKS 08K 030%  K 30%' => 0x9D7A71 ,
'HKS Colors -- HKS 10K 030%  K 30%' => 0xA57B7B ,
'HKS Colors -- HKS 11K 030%  K 30%' => 0xA88E8A ,
'HKS Colors -- HKS 12K 030%  K 30%' => 0x997577 ,
'HKS Colors -- HKS 13K 030%  K 30%' => 0xA26D75 ,
'HKS Colors -- HKS 14K 030%  K 30%' => 0x997478 ,
'HKS Colors -- HKS 15K 030%  K 30%' => 0x906D76 ,
'HKS Colors -- HKS 16K 030%  K 30%' => 0x8A6B75 ,
'HKS Colors -- HKS 17K 030%  K 30%' => 0x90717F ,
'HKS Colors -- HKS 18K 030%  K 30%' => 0x866E7C ,
'HKS Colors -- HKS 21K 030%  K 30%' => 0xA2868F ,
'HKS Colors -- HKS 22K 030%  K 30%' => 0xA77A81 ,
'HKS Colors -- HKS 23K 030%  K 30%' => 0x9C717F ,
'HKS Colors -- HKS 24K 030%  K 30%' => 0x97667A ,
'HKS Colors -- HKS 25K 030%  K 30%' => 0x9C748D ,
'HKS Colors -- HKS 26K 030%  K 30%' => 0x947089 ,
'HKS Colors -- HKS 27K 030%  K 30%' => 0x9E7291 ,
'HKS Colors -- HKS 28K 030%  K 30%' => 0x87697A ,
'HKS Colors -- HKS 29K 030%  K 30%' => 0x896F8D ,
'HKS Colors -- HKS 31K 030%  K 30%' => 0x99708E ,
'HKS Colors -- HKS 32K 030%  K 30%' => 0x976D88 ,
'HKS Colors -- HKS 33K 030%  K 30%' => 0x8E6F9A ,
'HKS Colors -- HKS 34K 030%  K 30%' => 0x857793 ,
'HKS Colors -- HKS 35K 030%  K 30%' => 0x807B97 ,
'HKS Colors -- HKS 36K 030%  K 30%' => 0x827697 ,
'HKS Colors -- HKS 37K 030%  K 30%' => 0x7E778B ,
'HKS Colors -- HKS 38K 030%  K 30%' => 0x757D88 ,
'HKS Colors -- HKS 39K 030%  K 30%' => 0x76819D ,
'HKS Colors -- HKS 40K 030%  K 30%' => 0x7A8B9A ,
'HKS Colors -- HKS 41K 030%  K 30%' => 0x727682 ,
'HKS Colors -- HKS 42K 030%  K 30%' => 0x747694 ,
'HKS Colors -- HKS 43K 030%  K 30%' => 0x6D759A ,
'HKS Colors -- HKS 44K 030%  K 30%' => 0x737F98 ,
'HKS Colors -- HKS 45K 030%  K 30%' => 0x7E7D96 ,
'HKS Colors -- HKS 46K 030%  K 30%' => 0x7A899A ,
'HKS Colors -- HKS 47K 030%  K 30%' => 0x6D889D ,
'HKS Colors -- HKS 48K 030%  K 30%' => 0x6A8999 ,
'HKS Colors -- HKS 49K 030%  K 30%' => 0x618092 ,
'HKS Colors -- HKS 50K 030%  K 30%' => 0x7E96A1 ,
'HKS Colors -- HKS 51K 030%  K 30%' => 0x738E92 ,
'HKS Colors -- HKS 52K 030%  K 30%' => 0x6D8A89 ,
'HKS Colors -- HKS 53K 030%  K 30%' => 0x709C92 ,
'HKS Colors -- HKS 54K 030%  K 30%' => 0x678B7D ,
'HKS Colors -- HKS 55K 030%  K 30%' => 0x66857E ,
'HKS Colors -- HKS 56K 030%  K 30%' => 0x738585 ,
'HKS Colors -- HKS 57K 030%  K 30%' => 0x698775 ,
'HKS Colors -- HKS 58K 030%  K 30%' => 0x78827B ,
'HKS Colors -- HKS 59K 030%  K 30%' => 0x6A878A ,
'HKS Colors -- HKS 60K 030%  K 30%' => 0x81967F ,
'HKS Colors -- HKS 61K 030%  K 30%' => 0x768078 ,
'HKS Colors -- HKS 62K 030%  K 30%' => 0x7C7F6F ,
'HKS Colors -- HKS 63K 030%  K 30%' => 0x7C8878 ,
'HKS Colors -- HKS 64K 030%  K 30%' => 0x779378 ,
'HKS Colors -- HKS 65K 030%  K 30%' => 0x7F9977 ,
'HKS Colors -- HKS 66K 030%  K 30%' => 0x859A6B ,
'HKS Colors -- HKS 67K 030%  K 30%' => 0x8DA277 ,
'HKS Colors -- HKS 68K 030%  K 30%' => 0xA09C7F ,
'HKS Colors -- HKS 69K 030%  K 30%' => 0xA2A37D ,
'HKS Colors -- HKS 71K 030%  K 30%' => 0x978976 ,
'HKS Colors -- HKS 72K 030%  K 30%' => 0x91816F ,
'HKS Colors -- HKS 73K 030%  K 30%' => 0x92877A ,
'HKS Colors -- HKS 74K 030%  K 30%' => 0x8A8178 ,
'HKS Colors -- HKS 75K 030%  K 30%' => 0x8B887D ,
'HKS Colors -- HKS 76K 030%  K 30%' => 0x827E7D ,
'HKS Colors -- HKS 77K 030%  K 30%' => 0x847D7A ,
'HKS Colors -- HKS 78K 030%  K 30%' => 0x8A7A78 ,
'HKS Colors -- HKS 81K 030%  K 30%' => 0x9B7E77 ,
'HKS Colors -- HKS 82K 030%  K 30%' => 0x9A807D ,
'HKS Colors -- HKS 83K 030%  K 30%' => 0x897D7F ,
'HKS Colors -- HKS 84K 030%  K 30%' => 0x7E7477 ,
'HKS Colors -- HKS 88K 030%  K 30%' => 0xAEABAF ,
'HKS Colors -- HKS 89K 030%  K 30%' => 0x90908D ,
'HKS Colors -- HKS 90K 030%  K 30%' => 0x777577 ,
'HKS Colors -- HKS 91K 030%  K 30%' => 0x969698 ,
'HKS Colors -- HKS 92K 030%  K 30%' => 0x868789 ,
'HKS Colors -- HKS 93K 030%  K 30%' => 0x7A7C82 ,
'HKS Colors -- HKS 95K 030%  K 30%' => 0x878787 ,
'HKS Colors -- HKS 96K 030%  K 30%' => 0x8D8D8F ,
'HKS Colors -- HKS 97K 030%  K 30%' => 0x77787B ,
'HKS Colors -- HKS 01K 040%  K 30%' => 0xA9A584 ,
'HKS Colors -- HKS 02K 040%  K 30%' => 0xA8A76F ,
'HKS Colors -- HKS 03K 040%  K 30%' => 0xAAA764 ,
'HKS Colors -- HKS 04K 040%  K 30%' => 0x9E975B ,
'HKS Colors -- HKS 05K 040%  K 30%' => 0xAA9863 ,
'HKS Colors -- HKS 06K 040%  K 30%' => 0xA07E5E ,
'HKS Colors -- HKS 07K 040%  K 30%' => 0xA1715B ,
'HKS Colors -- HKS 08K 040%  K 30%' => 0x9E7063 ,
'HKS Colors -- HKS 10K 040%  K 30%' => 0xA76E6B ,
'HKS Colors -- HKS 11K 040%  K 30%' => 0xA68880 ,
'HKS Colors -- HKS 12K 040%  K 30%' => 0x986567 ,
'HKS Colors -- HKS 13K 040%  K 30%' => 0xA05B66 ,
'HKS Colors -- HKS 14K 040%  K 30%' => 0x946568 ,
'HKS Colors -- HKS 15K 040%  K 30%' => 0x8A5B67 ,
'HKS Colors -- HKS 16K 040%  K 30%' => 0x875E6B ,
'HKS Colors -- HKS 17K 040%  K 30%' => 0x8A6374 ,
'HKS Colors -- HKS 18K 040%  K 30%' => 0x7D5D70 ,
'HKS Colors -- HKS 21K 040%  K 30%' => 0xA37C89 ,
'HKS Colors -- HKS 22K 040%  K 30%' => 0xA96E76 ,
'HKS Colors -- HKS 23K 040%  K 30%' => 0x985E70 ,
'HKS Colors -- HKS 24K 040%  K 30%' => 0x935770 ,
'HKS Colors -- HKS 25K 040%  K 30%' => 0x98607E ,
'HKS Colors -- HKS 26K 040%  K 30%' => 0x915E7E ,
'HKS Colors -- HKS 27K 040%  K 30%' => 0x9A6088 ,
'HKS Colors -- HKS 28K 040%  K 30%' => 0x82586F ,
'HKS Colors -- HKS 29K 040%  K 30%' => 0x816386 ,
'HKS Colors -- HKS 31K 040%  K 30%' => 0x945F84 ,
'HKS Colors -- HKS 32K 040%  K 30%' => 0x925D7F ,
'HKS Colors -- HKS 33K 040%  K 30%' => 0x876196 ,
'HKS Colors -- HKS 34K 040%  K 30%' => 0x7A698B ,
'HKS Colors -- HKS 35K 040%  K 30%' => 0x746F8E ,
'HKS Colors -- HKS 36K 040%  K 30%' => 0x75678E ,
'HKS Colors -- HKS 37K 040%  K 30%' => 0x736B84 ,
'HKS Colors -- HKS 38K 040%  K 30%' => 0x676F7C ,
'HKS Colors -- HKS 39K 040%  K 30%' => 0x677599 ,
'HKS Colors -- HKS 40K 040%  K 30%' => 0x6F8597 ,
'HKS Colors -- HKS 41K 040%  K 30%' => 0x646D7C ,
'HKS Colors -- HKS 42K 040%  K 30%' => 0x66698F ,
'HKS Colors -- HKS 43K 040%  K 30%' => 0x5E6999 ,
'HKS Colors -- HKS 44K 040%  K 30%' => 0x607393 ,
'HKS Colors -- HKS 45K 040%  K 30%' => 0x73728F ,
'HKS Colors -- HKS 46K 040%  K 30%' => 0x6B8296 ,
'HKS Colors -- HKS 47K 040%  K 30%' => 0x5B819A ,
'HKS Colors -- HKS 48K 040%  K 30%' => 0x5A8498 ,
'HKS Colors -- HKS 49K 040%  K 30%' => 0x537A8F ,
'HKS Colors -- HKS 50K 040%  K 30%' => 0x7392A0 ,
'HKS Colors -- HKS 51K 040%  K 30%' => 0x64878B ,
'HKS Colors -- HKS 52K 040%  K 30%' => 0x5A7F7B ,
'HKS Colors -- HKS 53K 040%  K 30%' => 0x5D988A ,
'HKS Colors -- HKS 54K 040%  K 30%' => 0x558672 ,
'HKS Colors -- HKS 55K 040%  K 30%' => 0x577D73 ,
'HKS Colors -- HKS 56K 040%  K 30%' => 0x677E7C ,
'HKS Colors -- HKS 57K 040%  K 30%' => 0x5D816B ,
'HKS Colors -- HKS 58K 040%  K 30%' => 0x6D7A70 ,
'HKS Colors -- HKS 59K 040%  K 30%' => 0x587E81 ,
'HKS Colors -- HKS 60K 040%  K 30%' => 0x758F70 ,
'HKS Colors -- HKS 61K 040%  K 30%' => 0x69766B ,
'HKS Colors -- HKS 62K 040%  K 30%' => 0x747861 ,
'HKS Colors -- HKS 63K 040%  K 30%' => 0x72826E ,
'HKS Colors -- HKS 64K 040%  K 30%' => 0x6A8D67 ,
'HKS Colors -- HKS 65K 040%  K 30%' => 0x749669 ,
'HKS Colors -- HKS 66K 040%  K 30%' => 0x7B965B ,
'HKS Colors -- HKS 67K 040%  K 30%' => 0x85A166 ,
'HKS Colors -- HKS 68K 040%  K 30%' => 0x9B9870 ,
'HKS Colors -- HKS 69K 040%  K 30%' => 0xA0A06D ,
'HKS Colors -- HKS 71K 040%  K 30%' => 0x928169 ,
'HKS Colors -- HKS 72K 040%  K 30%' => 0x8D7A60 ,
'HKS Colors -- HKS 73K 040%  K 30%' => 0x8D7E6B ,
'HKS Colors -- HKS 74K 040%  K 30%' => 0x81776B ,
'HKS Colors -- HKS 75K 040%  K 30%' => 0x827E70 ,
'HKS Colors -- HKS 76K 040%  K 30%' => 0x746E6B ,
'HKS Colors -- HKS 77K 040%  K 30%' => 0x7A706D ,
'HKS Colors -- HKS 78K 040%  K 30%' => 0x816D6B ,
'HKS Colors -- HKS 81K 040%  K 30%' => 0x977368 ,
'HKS Colors -- HKS 82K 040%  K 30%' => 0x93746E ,
'HKS Colors -- HKS 83K 040%  K 30%' => 0x806F70 ,
'HKS Colors -- HKS 84K 040%  K 30%' => 0x76696B ,
'HKS Colors -- HKS 88K 040%  K 30%' => 0x99979A ,
'HKS Colors -- HKS 89K 040%  K 30%' => 0x8A8985 ,
'HKS Colors -- HKS 90K 040%  K 30%' => 0x6D6B6E ,
'HKS Colors -- HKS 91K 040%  K 30%' => 0x8E9193 ,
'HKS Colors -- HKS 92K 040%  K 30%' => 0x7C7D7F ,
'HKS Colors -- HKS 93K 040%  K 30%' => 0x6D6F75 ,
'HKS Colors -- HKS 95K 040%  K 30%' => 0x82817F ,
'HKS Colors -- HKS 96K 040%  K 30%' => 0x878787 ,
'HKS Colors -- HKS 97K 040%  K 30%' => 0x696D6E ,
'HKS Colors -- HKS 01K 050%  K 30%' => 0xA7A57C ,
'HKS Colors -- HKS 02K 050%  K 30%' => 0xA6A45C ,
'HKS Colors -- HKS 03K 050%  K 30%' => 0xABA651 ,
'HKS Colors -- HKS 04K 050%  K 30%' => 0x9D9246 ,
'HKS Colors -- HKS 05K 050%  K 30%' => 0xAA9653 ,
'HKS Colors -- HKS 06K 050%  K 30%' => 0xA1774D ,
'HKS Colors -- HKS 07K 050%  K 30%' => 0xA3684A ,
'HKS Colors -- HKS 08K 050%  K 30%' => 0x9C6553 ,
'HKS Colors -- HKS 10K 050%  K 30%' => 0xA9635F ,
'HKS Colors -- HKS 11K 050%  K 30%' => 0xA78278 ,
'HKS Colors -- HKS 12K 050%  K 30%' => 0x985758 ,
'HKS Colors -- HKS 13K 050%  K 30%' => 0xA14A57 ,
'HKS Colors -- HKS 14K 050%  K 30%' => 0x92585B ,
'HKS Colors -- HKS 15K 050%  K 30%' => 0x874D5B ,
'HKS Colors -- HKS 16K 050%  K 30%' => 0x824D5E ,
'HKS Colors -- HKS 17K 050%  K 30%' => 0x875369 ,
'HKS Colors -- HKS 18K 050%  K 30%' => 0x72495F ,
'HKS Colors -- HKS 21K 050%  K 30%' => 0xA07180 ,
'HKS Colors -- HKS 22K 050%  K 30%' => 0xA85F69 ,
'HKS Colors -- HKS 23K 050%  K 30%' => 0x964D63 ,
'HKS Colors -- HKS 24K 050%  K 30%' => 0x8F4966 ,
'HKS Colors -- HKS 25K 050%  K 30%' => 0x965176 ,
'HKS Colors -- HKS 26K 050%  K 30%' => 0x8B4E77 ,
'HKS Colors -- HKS 27K 050%  K 30%' => 0x995282 ,
'HKS Colors -- HKS 28K 050%  K 30%' => 0x7D4765 ,
'HKS Colors -- HKS 29K 050%  K 30%' => 0x7B567F ,
'HKS Colors -- HKS 31K 050%  K 30%' => 0x924F7D ,
'HKS Colors -- HKS 32K 050%  K 30%' => 0x8F4D75 ,
'HKS Colors -- HKS 33K 050%  K 30%' => 0x815490 ,
'HKS Colors -- HKS 34K 050%  K 30%' => 0x715C86 ,
'HKS Colors -- HKS 35K 050%  K 30%' => 0x686388 ,
'HKS Colors -- HKS 36K 050%  K 30%' => 0x6D5687 ,
'HKS Colors -- HKS 37K 050%  K 30%' => 0x6A5E7C ,
'HKS Colors -- HKS 38K 050%  K 30%' => 0x586172 ,
'HKS Colors -- HKS 39K 050%  K 30%' => 0x5B6B94 ,
'HKS Colors -- HKS 40K 050%  K 30%' => 0x607E91 ,
'HKS Colors -- HKS 41K 050%  K 30%' => 0x586172 ,
'HKS Colors -- HKS 42K 050%  K 30%' => 0x5A5E8A ,
'HKS Colors -- HKS 43K 050%  K 30%' => 0x4F5D94 ,
'HKS Colors -- HKS 44K 050%  K 30%' => 0x54698E ,
'HKS Colors -- HKS 45K 050%  K 30%' => 0x696789 ,
'HKS Colors -- HKS 46K 050%  K 30%' => 0x607C92 ,
'HKS Colors -- HKS 47K 050%  K 30%' => 0x4D7D9B ,
'HKS Colors -- HKS 48K 050%  K 30%' => 0x4A7E93 ,
'HKS Colors -- HKS 49K 050%  K 30%' => 0x43738D ,
'HKS Colors -- HKS 50K 050%  K 30%' => 0x698F9C ,
'HKS Colors -- HKS 51K 050%  K 30%' => 0x568186 ,
'HKS Colors -- HKS 52K 050%  K 30%' => 0x517E78 ,
'HKS Colors -- HKS 53K 050%  K 30%' => 0x4C9481 ,
'HKS Colors -- HKS 54K 050%  K 30%' => 0x417E66 ,
'HKS Colors -- HKS 55K 050%  K 30%' => 0x457468 ,
'HKS Colors -- HKS 56K 050%  K 30%' => 0x577571 ,
'HKS Colors -- HKS 57K 050%  K 30%' => 0x49775C ,
'HKS Colors -- HKS 58K 050%  K 30%' => 0x607264 ,
'HKS Colors -- HKS 59K 050%  K 30%' => 0x4A777B ,
'HKS Colors -- HKS 60K 050%  K 30%' => 0x6A8963 ,
'HKS Colors -- HKS 61K 050%  K 30%' => 0x5E6D5E ,
'HKS Colors -- HKS 62K 050%  K 30%' => 0x6B7155 ,
'HKS Colors -- HKS 63K 050%  K 30%' => 0x677B61 ,
'HKS Colors -- HKS 64K 050%  K 30%' => 0x5C8658 ,
'HKS Colors -- HKS 65K 050%  K 30%' => 0x699158 ,
'HKS Colors -- HKS 66K 050%  K 30%' => 0x72944D ,
'HKS Colors -- HKS 67K 050%  K 30%' => 0x7C9D58 ,
'HKS Colors -- HKS 68K 050%  K 30%' => 0x989461 ,
'HKS Colors -- HKS 69K 050%  K 30%' => 0x999C5D ,
'HKS Colors -- HKS 71K 050%  K 30%' => 0x947E5D ,
'HKS Colors -- HKS 72K 050%  K 30%' => 0x8A7351 ,
'HKS Colors -- HKS 73K 050%  K 30%' => 0x897861 ,
'HKS Colors -- HKS 74K 050%  K 30%' => 0x7D6F5D ,
'HKS Colors -- HKS 75K 050%  K 30%' => 0x7C7561 ,
'HKS Colors -- HKS 76K 050%  K 30%' => 0x655E5A ,
'HKS Colors -- HKS 77K 050%  K 30%' => 0x70635E ,
'HKS Colors -- HKS 78K 050%  K 30%' => 0x77615E ,
'HKS Colors -- HKS 81K 050%  K 30%' => 0x94685B ,
'HKS Colors -- HKS 82K 050%  K 30%' => 0x916D65 ,
'HKS Colors -- HKS 83K 050%  K 30%' => 0x75615F ,
'HKS Colors -- HKS 84K 050%  K 30%' => 0x685657 ,
'HKS Colors -- HKS 88K 050%  K 30%' => 0x828285 ,
'HKS Colors -- HKS 89K 050%  K 30%' => 0x86847E ,
'HKS Colors -- HKS 90K 050%  K 30%' => 0x605C5D ,
'HKS Colors -- HKS 91K 050%  K 30%' => 0x878B8D ,
'HKS Colors -- HKS 92K 050%  K 30%' => 0x747476 ,
'HKS Colors -- HKS 93K 050%  K 30%' => 0x5E6066 ,
'HKS Colors -- HKS 95K 050%  K 30%' => 0x7B7B78 ,
'HKS Colors -- HKS 96K 050%  K 30%' => 0x7D7D7D ,
'HKS Colors -- HKS 97K 050%  K 30%' => 0x5E6160 ,
'HKS Colors -- HKS 01K 060%  K 30%' => 0xA8A26E ,
'HKS Colors -- HKS 02K 060%  K 30%' => 0xA6A241 ,
'HKS Colors -- HKS 03K 060%  K 30%' => 0xAAA535 ,
'HKS Colors -- HKS 04K 060%  K 30%' => 0x9C8F29 ,
'HKS Colors -- HKS 05K 060%  K 30%' => 0xA99039 ,
'HKS Colors -- HKS 06K 060%  K 30%' => 0xA16F35 ,
'HKS Colors -- HKS 07K 060%  K 30%' => 0xA35A32 ,
'HKS Colors -- HKS 08K 060%  K 30%' => 0x9E563E ,
'HKS Colors -- HKS 10K 060%  K 30%' => 0xA74E45 ,
'HKS Colors -- HKS 11K 060%  K 30%' => 0xA6786D ,
'HKS Colors -- HKS 12K 060%  K 30%' => 0x944343 ,
'HKS Colors -- HKS 13K 060%  K 30%' => 0x9E2D3E ,
'HKS Colors -- HKS 14K 060%  K 30%' => 0x8D4345 ,
'HKS Colors -- HKS 15K 060%  K 30%' => 0x813847 ,
'HKS Colors -- HKS 16K 060%  K 30%' => 0x783549 ,
'HKS Colors -- HKS 17K 060%  K 30%' => 0x7D3954 ,
'HKS Colors -- HKS 18K 060%  K 30%' => 0x67314C ,
'HKS Colors -- HKS 21K 060%  K 30%' => 0xA16A7A ,
'HKS Colors -- HKS 22K 060%  K 30%' => 0xA64A57 ,
'HKS Colors -- HKS 23K 060%  K 30%' => 0x933D57 ,
'HKS Colors -- HKS 24K 060%  K 30%' => 0x8D385C ,
'HKS Colors -- HKS 25K 060%  K 30%' => 0x903867 ,
'HKS Colors -- HKS 26K 060%  K 30%' => 0x853569 ,
'HKS Colors -- HKS 27K 060%  K 30%' => 0x973A7B ,
'HKS Colors -- HKS 28K 060%  K 30%' => 0x78355B ,
'HKS Colors -- HKS 29K 060%  K 30%' => 0x734576 ,
'HKS Colors -- HKS 31K 060%  K 30%' => 0x8D3A72 ,
'HKS Colors -- HKS 32K 060%  K 30%' => 0x882F66 ,
'HKS Colors -- HKS 33K 060%  K 30%' => 0x7B3E89 ,
'HKS Colors -- HKS 34K 060%  K 30%' => 0x63467C ,
'HKS Colors -- HKS 35K 060%  K 30%' => 0x544A7B ,
'HKS Colors -- HKS 36K 060%  K 30%' => 0x5D407F ,
'HKS Colors -- HKS 37K 060%  K 30%' => 0x5A4A70 ,
'HKS Colors -- HKS 38K 060%  K 30%' => 0x404C5E ,
'HKS Colors -- HKS 39K 060%  K 30%' => 0x455D90 ,
'HKS Colors -- HKS 40K 060%  K 30%' => 0x4C728D ,
'HKS Colors -- HKS 41K 060%  K 30%' => 0x424C5F ,
'HKS Colors -- HKS 42K 060%  K 30%' => 0x474A82 ,
'HKS Colors -- HKS 43K 060%  K 30%' => 0x3A4B8F ,
'HKS Colors -- HKS 44K 060%  K 30%' => 0x3D5B87 ,
'HKS Colors -- HKS 45K 060%  K 30%' => 0x58557F ,
'HKS Colors -- HKS 46K 060%  K 30%' => 0x4E728D ,
'HKS Colors -- HKS 47K 060%  K 30%' => 0x307196 ,
'HKS Colors -- HKS 48K 060%  K 30%' => 0x2E7690 ,
'HKS Colors -- HKS 49K 060%  K 30%' => 0x296A88 ,
'HKS Colors -- HKS 50K 060%  K 30%' => 0x5A8A9C ,
'HKS Colors -- HKS 51K 060%  K 30%' => 0x417A7F ,
'HKS Colors -- HKS 52K 060%  K 30%' => 0x347168 ,
'HKS Colors -- HKS 53K 060%  K 30%' => 0x318E77 ,
'HKS Colors -- HKS 54K 060%  K 30%' => 0x217454 ,
'HKS Colors -- HKS 55K 060%  K 30%' => 0x2F6857 ,
'HKS Colors -- HKS 56K 060%  K 30%' => 0x3B655E ,
'HKS Colors -- HKS 57K 060%  K 30%' => 0x2B6E46 ,
'HKS Colors -- HKS 58K 060%  K 30%' => 0x47604B ,
'HKS Colors -- HKS 59K 060%  K 30%' => 0x2D6B6D ,
'HKS Colors -- HKS 60K 060%  K 30%' => 0x58804B ,
'HKS Colors -- HKS 61K 060%  K 30%' => 0x445A46 ,
'HKS Colors -- HKS 62K 060%  K 30%' => 0x5F6440 ,
'HKS Colors -- HKS 63K 060%  K 30%' => 0x536D45 ,
'HKS Colors -- HKS 64K 060%  K 30%' => 0x457D3E ,
'HKS Colors -- HKS 65K 060%  K 30%' => 0x568940 ,
'HKS Colors -- HKS 66K 060%  K 30%' => 0x688F3A ,
'HKS Colors -- HKS 67K 060%  K 30%' => 0x729942 ,
'HKS Colors -- HKS 68K 060%  K 30%' => 0x918E4C ,
'HKS Colors -- HKS 69K 060%  K 30%' => 0x999B4A ,
'HKS Colors -- HKS 71K 060%  K 30%' => 0x907549 ,
'HKS Colors -- HKS 72K 060%  K 30%' => 0x876838 ,
'HKS Colors -- HKS 73K 060%  K 30%' => 0x846B4B ,
'HKS Colors -- HKS 74K 060%  K 30%' => 0x6F5D44 ,
'HKS Colors -- HKS 75K 060%  K 30%' => 0x70684E ,
'HKS Colors -- HKS 76K 060%  K 30%' => 0x4D4339 ,
'HKS Colors -- HKS 77K 060%  K 30%' => 0x5B4B41 ,
'HKS Colors -- HKS 78K 060%  K 30%' => 0x6A4B44 ,
'HKS Colors -- HKS 81K 060%  K 30%' => 0x8B5644 ,
'HKS Colors -- HKS 82K 060%  K 30%' => 0x875A4F ,
'HKS Colors -- HKS 83K 060%  K 30%' => 0x64443E ,
'HKS Colors -- HKS 84K 060%  K 30%' => 0x563D3C ,
'HKS Colors -- HKS 88K 060%  K 30%' => 0x6B6B6B ,
'HKS Colors -- HKS 89K 060%  K 30%' => 0x7F7D74 ,
'HKS Colors -- HKS 90K 060%  K 30%' => 0x524D4E ,
'HKS Colors -- HKS 91K 060%  K 30%' => 0x818482 ,
'HKS Colors -- HKS 92K 060%  K 30%' => 0x636667 ,
'HKS Colors -- HKS 93K 060%  K 30%' => 0x4C5155 ,
'HKS Colors -- HKS 95K 060%  K 30%' => 0x737470 ,
'HKS Colors -- HKS 96K 060%  K 30%' => 0x737270 ,
'HKS Colors -- HKS 97K 060%  K 30%' => 0x4E5352 ,
'HKS Colors -- HKS 01K 070%  K 30%' => 0xA7A063 ,
'HKS Colors -- HKS 02K 070%  K 30%' => 0xA29E30 ,
'HKS Colors -- HKS 03K 070%  K 30%' => 0xA8A320 ,
'HKS Colors -- HKS 04K 070%  K 30%' => 0x9E8D12 ,
'HKS Colors -- HKS 05K 070%  K 30%' => 0xAA8D23 ,
'HKS Colors -- HKS 06K 070%  K 30%' => 0xA46822 ,
'HKS Colors -- HKS 07K 070%  K 30%' => 0xA35220 ,
'HKS Colors -- HKS 08K 070%  K 30%' => 0x9E4B2E ,
'HKS Colors -- HKS 10K 070%  K 30%' => 0xA54035 ,
'HKS Colors -- HKS 11K 070%  K 30%' => 0xA67063 ,
'HKS Colors -- HKS 12K 070%  K 30%' => 0x943433 ,
'HKS Colors -- HKS 13K 070%  K 30%' => 0x9C1E2F ,
'HKS Colors -- HKS 14K 070%  K 30%' => 0x8A3538 ,
'HKS Colors -- HKS 15K 070%  K 30%' => 0x7F2A3C ,
'HKS Colors -- HKS 16K 070%  K 30%' => 0x73283C ,
'HKS Colors -- HKS 17K 070%  K 30%' => 0x762846 ,
'HKS Colors -- HKS 18K 070%  K 30%' => 0x612341 ,
'HKS Colors -- HKS 21K 070%  K 30%' => 0x9E6071 ,
'HKS Colors -- HKS 22K 070%  K 30%' => 0xA53947 ,
'HKS Colors -- HKS 23K 070%  K 30%' => 0x8F2B49 ,
'HKS Colors -- HKS 24K 070%  K 30%' => 0x882E53 ,
'HKS Colors -- HKS 25K 070%  K 30%' => 0x89295D ,
'HKS Colors -- HKS 26K 070%  K 30%' => 0x812460 ,
'HKS Colors -- HKS 27K 070%  K 30%' => 0x922972 ,
'HKS Colors -- HKS 28K 070%  K 30%' => 0x74274E ,
'HKS Colors -- HKS 29K 070%  K 30%' => 0x6B366F ,
'HKS Colors -- HKS 31K 070%  K 30%' => 0x872A6B ,
'HKS Colors -- HKS 32K 070%  K 30%' => 0x811758 ,
'HKS Colors -- HKS 33K 070%  K 30%' => 0x732D86 ,
'HKS Colors -- HKS 34K 070%  K 30%' => 0x573372 ,
'HKS Colors -- HKS 35K 070%  K 30%' => 0x443671 ,
'HKS Colors -- HKS 36K 070%  K 30%' => 0x4D2D73 ,
'HKS Colors -- HKS 37K 070%  K 30%' => 0x4D3C66 ,
'HKS Colors -- HKS 38K 070%  K 30%' => 0x2F3C51 ,
'HKS Colors -- HKS 39K 070%  K 30%' => 0x39528B ,
'HKS Colors -- HKS 40K 070%  K 30%' => 0x3B6985 ,
'HKS Colors -- HKS 41K 070%  K 30%' => 0x333E54 ,
'HKS Colors -- HKS 42K 070%  K 30%' => 0x3A3D7A ,
'HKS Colors -- HKS 43K 070%  K 30%' => 0x2B3E8E ,
'HKS Colors -- HKS 44K 070%  K 30%' => 0x305284 ,
'HKS Colors -- HKS 45K 070%  K 30%' => 0x514D7D ,
'HKS Colors -- HKS 46K 070%  K 30%' => 0x406988 ,
'HKS Colors -- HKS 47K 070%  K 30%' => 0x226A93 ,
'HKS Colors -- HKS 48K 070%  K 30%' => 0x19718F ,
'HKS Colors -- HKS 49K 070%  K 30%' => 0x176385 ,
'HKS Colors -- HKS 50K 070%  K 30%' => 0x4D869A ,
'HKS Colors -- HKS 51K 070%  K 30%' => 0x33757B ,
'HKS Colors -- HKS 52K 070%  K 30%' => 0x22685D ,
'HKS Colors -- HKS 53K 070%  K 30%' => 0x1B866B ,
'HKS Colors -- HKS 54K 070%  K 30%' => 0x056B45 ,
'HKS Colors -- HKS 55K 070%  K 30%' => 0x1E604C ,
'HKS Colors -- HKS 56K 070%  K 30%' => 0x28584F ,
'HKS Colors -- HKS 57K 070%  K 30%' => 0x176536 ,
'HKS Colors -- HKS 58K 070%  K 30%' => 0x385239 ,
'HKS Colors -- HKS 59K 070%  K 30%' => 0x196365 ,
'HKS Colors -- HKS 60K 070%  K 30%' => 0x477738 ,
'HKS Colors -- HKS 61K 070%  K 30%' => 0x334A31 ,
'HKS Colors -- HKS 62K 070%  K 30%' => 0x52562A ,
'HKS Colors -- HKS 63K 070%  K 30%' => 0x416031 ,
'HKS Colors -- HKS 64K 070%  K 30%' => 0x34742D ,
'HKS Colors -- HKS 65K 070%  K 30%' => 0x45842A ,
'HKS Colors -- HKS 66K 070%  K 30%' => 0x5E8A29 ,
'HKS Colors -- HKS 67K 070%  K 30%' => 0x67942D ,
'HKS Colors -- HKS 68K 070%  K 30%' => 0x918A3D ,
'HKS Colors -- HKS 69K 070%  K 30%' => 0x939638 ,
'HKS Colors -- HKS 71K 070%  K 30%' => 0x8D6F38 ,
'HKS Colors -- HKS 72K 070%  K 30%' => 0x825F26 ,
'HKS Colors -- HKS 73K 070%  K 30%' => 0x7B613A ,
'HKS Colors -- HKS 74K 070%  K 30%' => 0x685335 ,
'HKS Colors -- HKS 75K 070%  K 30%' => 0x655C3D ,
'HKS Colors -- HKS 76K 070%  K 30%' => 0x3E3428 ,
'HKS Colors -- HKS 77K 070%  K 30%' => 0x513C31 ,
'HKS Colors -- HKS 78K 070%  K 30%' => 0x603D35 ,
'HKS Colors -- HKS 81K 070%  K 30%' => 0x884B35 ,
'HKS Colors -- HKS 82K 070%  K 30%' => 0x804E42 ,
'HKS Colors -- HKS 83K 070%  K 30%' => 0x583530 ,
'HKS Colors -- HKS 84K 070%  K 30%' => 0x4B2F2E ,
'HKS Colors -- HKS 88K 070%  K 30%' => 0x565656 ,
'HKS Colors -- HKS 89K 070%  K 30%' => 0x78756B ,
'HKS Colors -- HKS 90K 070%  K 30%' => 0x433E3D ,
'HKS Colors -- HKS 91K 070%  K 30%' => 0x757B7A ,
'HKS Colors -- HKS 92K 070%  K 30%' => 0x585C5D ,
'HKS Colors -- HKS 93K 070%  K 30%' => 0x40454B ,
'HKS Colors -- HKS 95K 070%  K 30%' => 0x6B6D67 ,
'HKS Colors -- HKS 96K 070%  K 30%' => 0x6A6967 ,
'HKS Colors -- HKS 97K 070%  K 30%' => 0x424542 ,
'HKS Colors -- HKS 01K 080%  K 30%' => 0xA49C53 ,
'HKS Colors -- HKS 02K 080%  K 30%' => 0xA09B0E ,
'HKS Colors -- HKS 03K 080%  K 30%' => 0xA79E00 ,
'HKS Colors -- HKS 04K 080%  K 30%' => 0x9E8700 ,
'HKS Colors -- HKS 05K 080%  K 30%' => 0xA98500 ,
'HKS Colors -- HKS 06K 080%  K 30%' => 0xA45E03 ,
'HKS Colors -- HKS 07K 080%  K 30%' => 0xA34501 ,
'HKS Colors -- HKS 08K 080%  K 30%' => 0xA0401C ,
'HKS Colors -- HKS 10K 080%  K 30%' => 0xA22E21 ,
'HKS Colors -- HKS 11K 080%  K 30%' => 0xA66755 ,
'HKS Colors -- HKS 12K 080%  K 30%' => 0x8E2220 ,
'HKS Colors -- HKS 13K 080%  K 30%' => 0x9A0D20 ,
'HKS Colors -- HKS 14K 080%  K 30%' => 0x862224 ,
'HKS Colors -- HKS 15K 080%  K 30%' => 0x7B172E ,
'HKS Colors -- HKS 16K 080%  K 30%' => 0x6A1429 ,
'HKS Colors -- HKS 17K 080%  K 30%' => 0x6E1435 ,
'HKS Colors -- HKS 18K 080%  K 30%' => 0x551131 ,
'HKS Colors -- HKS 21K 080%  K 30%' => 0x9B5467 ,
'HKS Colors -- HKS 22K 080%  K 30%' => 0x9E2331 ,
'HKS Colors -- HKS 23K 080%  K 30%' => 0x8A193A ,
'HKS Colors -- HKS 24K 080%  K 30%' => 0x821C44 ,
'HKS Colors -- HKS 25K 080%  K 30%' => 0x850F4F ,
'HKS Colors -- HKS 26K 080%  K 30%' => 0x7B0B55 ,
'HKS Colors -- HKS 27K 080%  K 30%' => 0x8B0B66 ,
'HKS Colors -- HKS 28K 080%  K 30%' => 0x6D103D ,
'HKS Colors -- HKS 29K 080%  K 30%' => 0x5F2460 ,
'HKS Colors -- HKS 31K 080%  K 30%' => 0x81145F ,
'HKS Colors -- HKS 32K 080%  K 30%' => 0x780046 ,
'HKS Colors -- HKS 33K 080%  K 30%' => 0x68117A ,
'HKS Colors -- HKS 34K 080%  K 30%' => 0x4A1E67 ,
'HKS Colors -- HKS 35K 080%  K 30%' => 0x342466 ,
'HKS Colors -- HKS 36K 080%  K 30%' => 0x411A67 ,
'HKS Colors -- HKS 37K 080%  K 30%' => 0x3E2958 ,
'HKS Colors -- HKS 38K 080%  K 30%' => 0x18253A ,
'HKS Colors -- HKS 39K 080%  K 30%' => 0x274486 ,
'HKS Colors -- HKS 40K 080%  K 30%' => 0x27607F ,
'HKS Colors -- HKS 41K 080%  K 30%' => 0x202D44 ,
'HKS Colors -- HKS 42K 080%  K 30%' => 0x252971 ,
'HKS Colors -- HKS 43K 080%  K 30%' => 0x1C2F87 ,
'HKS Colors -- HKS 44K 080%  K 30%' => 0x1A427C ,
'HKS Colors -- HKS 45K 080%  K 30%' => 0x413C70 ,
'HKS Colors -- HKS 46K 080%  K 30%' => 0x2D5E81 ,
'HKS Colors -- HKS 47K 080%  K 30%' => 0x005F8B ,
'HKS Colors -- HKS 48K 080%  K 30%' => 0x006887 ,
'HKS Colors -- HKS 49K 080%  K 30%' => 0x00587D ,
'HKS Colors -- HKS 50K 080%  K 30%' => 0x3B7F96 ,
'HKS Colors -- HKS 51K 080%  K 30%' => 0x1A6D71 ,
'HKS Colors -- HKS 52K 080%  K 30%' => 0x005B4E ,
'HKS Colors -- HKS 53K 080%  K 30%' => 0x007E63 ,
'HKS Colors -- HKS 54K 080%  K 30%' => 0x00603B ,
'HKS Colors -- HKS 55K 080%  K 30%' => 0x00533A ,
'HKS Colors -- HKS 56K 080%  K 30%' => 0x0E473D ,
'HKS Colors -- HKS 57K 080%  K 30%' => 0x005B28 ,
'HKS Colors -- HKS 58K 080%  K 30%' => 0x224124 ,
'HKS Colors -- HKS 59K 080%  K 30%' => 0x005556 ,
'HKS Colors -- HKS 60K 080%  K 30%' => 0x306D1E ,
'HKS Colors -- HKS 61K 080%  K 30%' => 0x1D391C ,
'HKS Colors -- HKS 62K 080%  K 30%' => 0x414616 ,
'HKS Colors -- HKS 63K 080%  K 30%' => 0x2F541D ,
'HKS Colors -- HKS 64K 080%  K 30%' => 0x216B1C ,
'HKS Colors -- HKS 65K 080%  K 30%' => 0x307E0E ,
'HKS Colors -- HKS 66K 080%  K 30%' => 0x538511 ,
'HKS Colors -- HKS 67K 080%  K 30%' => 0x548D0B ,
'HKS Colors -- HKS 68K 080%  K 30%' => 0x898224 ,
'HKS Colors -- HKS 69K 080%  K 30%' => 0x8F911D ,
'HKS Colors -- HKS 71K 080%  K 30%' => 0x886424 ,
'HKS Colors -- HKS 72K 080%  K 30%' => 0x815612 ,
'HKS Colors -- HKS 73K 080%  K 30%' => 0x775626 ,
'HKS Colors -- HKS 74K 080%  K 30%' => 0x5D4524 ,
'HKS Colors -- HKS 75K 080%  K 30%' => 0x574D28 ,
'HKS Colors -- HKS 76K 080%  K 30%' => 0x31261A ,
'HKS Colors -- HKS 77K 080%  K 30%' => 0x412A1D ,
'HKS Colors -- HKS 78K 080%  K 30%' => 0x522920 ,
'HKS Colors -- HKS 81K 080%  K 30%' => 0x823D22 ,
'HKS Colors -- HKS 82K 080%  K 30%' => 0x76392A ,
'HKS Colors -- HKS 83K 080%  K 30%' => 0x4D2620 ,
'HKS Colors -- HKS 84K 080%  K 30%' => 0x402321 ,
'HKS Colors -- HKS 88K 080%  K 30%' => 0x3D3C3B ,
'HKS Colors -- HKS 89K 080%  K 30%' => 0x747064 ,
'HKS Colors -- HKS 90K 080%  K 30%' => 0x322B2A ,
'HKS Colors -- HKS 91K 080%  K 30%' => 0x6D7270 ,
'HKS Colors -- HKS 92K 080%  K 30%' => 0x4B4E4D ,
'HKS Colors -- HKS 93K 080%  K 30%' => 0x33383D ,
'HKS Colors -- HKS 95K 080%  K 30%' => 0x65665F ,
'HKS Colors -- HKS 96K 080%  K 30%' => 0x5C5B57 ,
'HKS Colors -- HKS 97K 080%  K 30%' => 0x2E322E ,
'HKS Colors -- HKS 01K 090%  K 30%' => 0xA09642 ,
'HKS Colors -- HKS 02K 090%  K 30%' => 0x9C9400 ,
'HKS Colors -- HKS 03K 090%  K 30%' => 0xA49A00 ,
'HKS Colors -- HKS 04K 090%  K 30%' => 0x9E8200 ,
'HKS Colors -- HKS 05K 090%  K 30%' => 0xA57D00 ,
'HKS Colors -- HKS 06K 090%  K 30%' => 0xA45800 ,
'HKS Colors -- HKS 07K 090%  K 30%' => 0xA13C00 ,
'HKS Colors -- HKS 08K 090%  K 30%' => 0x9C3409 ,
'HKS Colors -- HKS 10K 090%  K 30%' => 0x9B200E ,
'HKS Colors -- HKS 11K 090%  K 30%' => 0xA35B45 ,
'HKS Colors -- HKS 12K 090%  K 30%' => 0x8B1211 ,
'HKS Colors -- HKS 13K 090%  K 30%' => 0x920616 ,
'HKS Colors -- HKS 14K 090%  K 30%' => 0x7E1217 ,
'HKS Colors -- HKS 15K 090%  K 30%' => 0x73061D ,
'HKS Colors -- HKS 16K 090%  K 30%' => 0x5F0B1D ,
'HKS Colors -- HKS 17K 090%  K 30%' => 0x610525 ,
'HKS Colors -- HKS 18K 090%  K 30%' => 0x470622 ,
'HKS Colors -- HKS 21K 090%  K 30%' => 0x904457 ,
'HKS Colors -- HKS 22K 090%  K 30%' => 0x991622 ,
'HKS Colors -- HKS 23K 090%  K 30%' => 0x85032A ,
'HKS Colors -- HKS 24K 090%  K 30%' => 0x760E35 ,
'HKS Colors -- HKS 25K 090%  K 30%' => 0x7A003C ,
'HKS Colors -- HKS 26K 090%  K 30%' => 0x6B0043 ,
'HKS Colors -- HKS 27K 090%  K 30%' => 0x7F0057 ,
'HKS Colors -- HKS 28K 090%  K 30%' => 0x640030 ,
'HKS Colors -- HKS 29K 090%  K 30%' => 0x510F52 ,
'HKS Colors -- HKS 31K 090%  K 30%' => 0x74004F ,
'HKS Colors -- HKS 32K 090%  K 30%' => 0x71003C ,
'HKS Colors -- HKS 33K 090%  K 30%' => 0x5D006F ,
'HKS Colors -- HKS 34K 090%  K 30%' => 0x3D105A ,
'HKS Colors -- HKS 35K 090%  K 30%' => 0x28195A ,
'HKS Colors -- HKS 36K 090%  K 30%' => 0x350F5D ,
'HKS Colors -- HKS 37K 090%  K 30%' => 0x2F1449 ,
'HKS Colors -- HKS 38K 090%  K 30%' => 0x0D1B2F ,
'HKS Colors -- HKS 39K 090%  K 30%' => 0x17387E ,
'HKS Colors -- HKS 40K 090%  K 30%' => 0x0D5173 ,
'HKS Colors -- HKS 41K 090%  K 30%' => 0x121E35 ,
'HKS Colors -- HKS 42K 090%  K 30%' => 0x161A64 ,
'HKS Colors -- HKS 43K 090%  K 30%' => 0x0E2181 ,
'HKS Colors -- HKS 44K 090%  K 30%' => 0x0D3570 ,
'HKS Colors -- HKS 45K 090%  K 30%' => 0x332F68 ,
'HKS Colors -- HKS 46K 090%  K 30%' => 0x1C5276 ,
'HKS Colors -- HKS 47K 090%  K 30%' => 0x005681 ,
'HKS Colors -- HKS 48K 090%  K 30%' => 0x005E7C ,
'HKS Colors -- HKS 49K 090%  K 30%' => 0x004F74 ,
'HKS Colors -- HKS 50K 090%  K 30%' => 0x28748D ,
'HKS Colors -- HKS 51K 090%  K 30%' => 0x006167 ,
'HKS Colors -- HKS 52K 090%  K 30%' => 0x004C41 ,
'HKS Colors -- HKS 53K 090%  K 30%' => 0x006F55 ,
'HKS Colors -- HKS 54K 090%  K 30%' => 0x005532 ,
'HKS Colors -- HKS 55K 090%  K 30%' => 0x00412A ,
'HKS Colors -- HKS 56K 090%  K 30%' => 0x00382D ,
'HKS Colors -- HKS 57K 090%  K 30%' => 0x005123 ,
'HKS Colors -- HKS 58K 090%  K 30%' => 0x19381C ,
'HKS Colors -- HKS 59K 090%  K 30%' => 0x004949 ,
'HKS Colors -- HKS 60K 090%  K 30%' => 0x1E5F09 ,
'HKS Colors -- HKS 61K 090%  K 30%' => 0x162F14 ,
'HKS Colors -- HKS 62K 090%  K 30%' => 0x343A0A ,
'HKS Colors -- HKS 63K 090%  K 30%' => 0x224511 ,
'HKS Colors -- HKS 64K 090%  K 30%' => 0x0F5F0E ,
'HKS Colors -- HKS 65K 090%  K 30%' => 0x257500 ,
'HKS Colors -- HKS 66K 090%  K 30%' => 0x467A00 ,
'HKS Colors -- HKS 67K 090%  K 30%' => 0x468100 ,
'HKS Colors -- HKS 68K 090%  K 30%' => 0x817A0B ,
'HKS Colors -- HKS 69K 090%  K 30%' => 0x858700 ,
'HKS Colors -- HKS 71K 090%  K 30%' => 0x825C17 ,
'HKS Colors -- HKS 72K 090%  K 30%' => 0x7C4B03 ,
'HKS Colors -- HKS 73K 090%  K 30%' => 0x6D4916 ,
'HKS Colors -- HKS 74K 090%  K 30%' => 0x543916 ,
'HKS Colors -- HKS 75K 090%  K 30%' => 0x4B401A ,
'HKS Colors -- HKS 76K 090%  K 30%' => 0x281E13 ,
'HKS Colors -- HKS 77K 090%  K 30%' => 0x331D11 ,
'HKS Colors -- HKS 78K 090%  K 30%' => 0x472014 ,
'HKS Colors -- HKS 81K 090%  K 30%' => 0x7C3118 ,
'HKS Colors -- HKS 82K 090%  K 30%' => 0x6B2A1B ,
'HKS Colors -- HKS 83K 090%  K 30%' => 0x451E17 ,
'HKS Colors -- HKS 84K 090%  K 30%' => 0x3A1B19 ,
'HKS Colors -- HKS 88K 090%  K 30%' => 0x242421 ,
'HKS Colors -- HKS 89K 090%  K 30%' => 0x6D685B ,
'HKS Colors -- HKS 90K 090%  K 30%' => 0x231D1C ,
'HKS Colors -- HKS 91K 090%  K 30%' => 0x5D645F ,
'HKS Colors -- HKS 92K 090%  K 30%' => 0x404241 ,
'HKS Colors -- HKS 93K 090%  K 30%' => 0x292E33 ,
'HKS Colors -- HKS 95K 090%  K 30%' => 0x5C5D56 ,
'HKS Colors -- HKS 96K 090%  K 30%' => 0x514E49 ,
'HKS Colors -- HKS 97K 090%  K 30%' => 0x212520 ,
'HKS Colors -- HKS 01K 100%  K 30%' => 0x9B9038 ,
'HKS Colors -- HKS 02K 100%  K 30%' => 0x979000 ,
'HKS Colors -- HKS 03K 100%  K 30%' => 0xA09400 ,
'HKS Colors -- HKS 04K 100%  K 30%' => 0xA08000 ,
'HKS Colors -- HKS 05K 100%  K 30%' => 0xA17500 ,
'HKS Colors -- HKS 06K 100%  K 30%' => 0xA55400 ,
'HKS Colors -- HKS 07K 100%  K 30%' => 0x9C3600 ,
'HKS Colors -- HKS 08K 100%  K 30%' => 0x9A2B00 ,
'HKS Colors -- HKS 10K 100%  K 30%' => 0x961705 ,
'HKS Colors -- HKS 11K 100%  K 30%' => 0xA0533D ,
'HKS Colors -- HKS 12K 100%  K 30%' => 0x840A0D ,
'HKS Colors -- HKS 13K 100%  K 30%' => 0x8E000F ,
'HKS Colors -- HKS 14K 100%  K 30%' => 0x760910 ,
'HKS Colors -- HKS 15K 100%  K 30%' => 0x6D0014 ,
'HKS Colors -- HKS 16K 100%  K 30%' => 0x560916 ,
'HKS Colors -- HKS 17K 100%  K 30%' => 0x58001B ,
'HKS Colors -- HKS 18K 100%  K 30%' => 0x3B0517 ,
'HKS Colors -- HKS 21K 100%  K 30%' => 0x8B394D ,
'HKS Colors -- HKS 22K 100%  K 30%' => 0x910B17 ,
'HKS Colors -- HKS 23K 100%  K 30%' => 0x78001E ,
'HKS Colors -- HKS 24K 100%  K 30%' => 0x6E062A ,
'HKS Colors -- HKS 25K 100%  K 30%' => 0x740033 ,
'HKS Colors -- HKS 26K 100%  K 30%' => 0x5F0036 ,
'HKS Colors -- HKS 27K 100%  K 30%' => 0x74004C ,
'HKS Colors -- HKS 28K 100%  K 30%' => 0x5C0024 ,
'HKS Colors -- HKS 29K 100%  K 30%' => 0x440342 ,
'HKS Colors -- HKS 31K 100%  K 30%' => 0x6E0047 ,
'HKS Colors -- HKS 32K 100%  K 30%' => 0x6B0036 ,
'HKS Colors -- HKS 33K 100%  K 30%' => 0x570065 ,
'HKS Colors -- HKS 34K 100%  K 30%' => 0x350852 ,
'HKS Colors -- HKS 35K 100%  K 30%' => 0x22114F ,
'HKS Colors -- HKS 36K 100%  K 30%' => 0x2F0954 ,
'HKS Colors -- HKS 37K 100%  K 30%' => 0x240A3C ,
'HKS Colors -- HKS 38K 100%  K 30%' => 0x091426 ,
'HKS Colors -- HKS 39K 100%  K 30%' => 0x0F2E75 ,
'HKS Colors -- HKS 40K 100%  K 30%' => 0x004669 ,
'HKS Colors -- HKS 41K 100%  K 30%' => 0x0B172D ,
'HKS Colors -- HKS 42K 100%  K 30%' => 0x0D1058 ,
'HKS Colors -- HKS 43K 100%  K 30%' => 0x0D1778 ,
'HKS Colors -- HKS 44K 100%  K 30%' => 0x002A64 ,
'HKS Colors -- HKS 45K 100%  K 30%' => 0x26245E ,
'HKS Colors -- HKS 46K 100%  K 30%' => 0x124A70 ,
'HKS Colors -- HKS 47K 100%  K 30%' => 0x004E7A ,
'HKS Colors -- HKS 48K 100%  K 30%' => 0x005571 ,
'HKS Colors -- HKS 49K 100%  K 30%' => 0x004568 ,
'HKS Colors -- HKS 50K 100%  K 30%' => 0x1B6F87 ,
'HKS Colors -- HKS 51K 100%  K 30%' => 0x005A5E ,
'HKS Colors -- HKS 52K 100%  K 30%' => 0x00493B ,
'HKS Colors -- HKS 53K 100%  K 30%' => 0x00664D ,
'HKS Colors -- HKS 54K 100%  K 30%' => 0x004A2A ,
'HKS Colors -- HKS 55K 100%  K 30%' => 0x003A25 ,
'HKS Colors -- HKS 56K 100%  K 30%' => 0x002D23 ,
'HKS Colors -- HKS 57K 100%  K 30%' => 0x00461E ,
'HKS Colors -- HKS 58K 100%  K 30%' => 0x112F14 ,
'HKS Colors -- HKS 59K 100%  K 30%' => 0x003C3B ,
'HKS Colors -- HKS 60K 100%  K 30%' => 0x115601 ,
'HKS Colors -- HKS 61K 100%  K 30%' => 0x0E260F ,
'HKS Colors -- HKS 62K 100%  K 30%' => 0x2D3106 ,
'HKS Colors -- HKS 63K 100%  K 30%' => 0x1B3E0F ,
'HKS Colors -- HKS 64K 100%  K 30%' => 0x025607 ,
'HKS Colors -- HKS 65K 100%  K 30%' => 0x196D00 ,
'HKS Colors -- HKS 66K 100%  K 30%' => 0x3D7200 ,
'HKS Colors -- HKS 67K 100%  K 30%' => 0x3E7A00 ,
'HKS Colors -- HKS 68K 100%  K 30%' => 0x7B7100 ,
'HKS Colors -- HKS 69K 100%  K 30%' => 0x7E7E00 ,
'HKS Colors -- HKS 71K 100%  K 30%' => 0x7D5510 ,
'HKS Colors -- HKS 72K 100%  K 30%' => 0x7A4500 ,
'HKS Colors -- HKS 73K 100%  K 30%' => 0x66410F ,
'HKS Colors -- HKS 74K 100%  K 30%' => 0x4B300E ,
'HKS Colors -- HKS 75K 100%  K 30%' => 0x433510 ,
'HKS Colors -- HKS 76K 100%  K 30%' => 0x241A0F ,
'HKS Colors -- HKS 77K 100%  K 30%' => 0x2D180D ,
'HKS Colors -- HKS 78K 100%  K 30%' => 0x40180F ,
'HKS Colors -- HKS 81K 100%  K 30%' => 0x73290F ,
'HKS Colors -- HKS 82K 100%  K 30%' => 0x5F1D0E ,
'HKS Colors -- HKS 83K 100%  K 30%' => 0x411913 ,
'HKS Colors -- HKS 84K 100%  K 30%' => 0x321613 ,
'HKS Colors -- HKS 88K 100%  K 30%' => 0x0F0F0D ,
'HKS Colors -- HKS 89K 100%  K 30%' => 0x666152 ,
'HKS Colors -- HKS 90K 100%  K 30%' => 0x1B1614 ,
'HKS Colors -- HKS 91K 100%  K 30%' => 0x535A55 ,
'HKS Colors -- HKS 92K 100%  K 30%' => 0x393B3A ,
'HKS Colors -- HKS 93K 100%  K 30%' => 0x23272D ,
'HKS Colors -- HKS 95K 100%  K 30%' => 0x57574F ,
'HKS Colors -- HKS 96K 100%  K 30%' => 0x42433D ,
'HKS Colors -- HKS 97K 100%  K 30%' => 0x171B17 ,
'HKS Colors -- HKS 01K 010%  K 50%' => 0x7D7C77 ,
'HKS Colors -- HKS 02K 010%  K 50%' => 0x787870 ,
'HKS Colors -- HKS 03K 010%  K 50%' => 0x7F7E70 ,
'HKS Colors -- HKS 04K 010%  K 50%' => 0x76766E ,
'HKS Colors -- HKS 05K 010%  K 50%' => 0x767369 ,
'HKS Colors -- HKS 06K 010%  K 50%' => 0x6F6760 ,
'HKS Colors -- HKS 07K 010%  K 50%' => 0x685E5B ,
'HKS Colors -- HKS 08K 010%  K 50%' => 0x69605F ,
'HKS Colors -- HKS 10K 010%  K 50%' => 0x716668 ,
'HKS Colors -- HKS 11K 010%  K 50%' => 0x7C7374 ,
'HKS Colors -- HKS 12K 010%  K 50%' => 0x685F60 ,
'HKS Colors -- HKS 13K 010%  K 50%' => 0x6A5E61 ,
'HKS Colors -- HKS 14K 010%  K 50%' => 0x655D5F ,
'HKS Colors -- HKS 15K 010%  K 50%' => 0x5F575A ,
'HKS Colors -- HKS 16K 010%  K 50%' => 0x645D61 ,
'HKS Colors -- HKS 17K 010%  K 50%' => 0x665F64 ,
'HKS Colors -- HKS 18K 010%  K 50%' => 0x635C63 ,
'HKS Colors -- HKS 21K 010%  K 50%' => 0x6A6468 ,
'HKS Colors -- HKS 22K 010%  K 50%' => 0x786B70 ,
'HKS Colors -- HKS 23K 010%  K 50%' => 0x6A6166 ,
'HKS Colors -- HKS 24K 010%  K 50%' => 0x706469 ,
'HKS Colors -- HKS 25K 010%  K 50%' => 0x756A72 ,
'HKS Colors -- HKS 26K 010%  K 50%' => 0x6A6369 ,
'HKS Colors -- HKS 27K 010%  K 50%' => 0x6D5F6A ,
'HKS Colors -- HKS 28K 010%  K 50%' => 0x5E575B ,
'HKS Colors -- HKS 29K 010%  K 50%' => 0x645E67 ,
'HKS Colors -- HKS 31K 010%  K 50%' => 0x6D6169 ,
'HKS Colors -- HKS 32K 010%  K 50%' => 0x716670 ,
'HKS Colors -- HKS 33K 010%  K 50%' => 0x6B6570 ,
'HKS Colors -- HKS 34K 010%  K 50%' => 0x6D6874 ,
'HKS Colors -- HKS 35K 010%  K 50%' => 0x706E7A ,
'HKS Colors -- HKS 36K 010%  K 50%' => 0x6B6773 ,
'HKS Colors -- HKS 37K 010%  K 50%' => 0x68676F ,
'HKS Colors -- HKS 38K 010%  K 50%' => 0x73757B ,
'HKS Colors -- HKS 39K 010%  K 50%' => 0x666973 ,
'HKS Colors -- HKS 40K 010%  K 50%' => 0x5E6367 ,
'HKS Colors -- HKS 41K 010%  K 50%' => 0x676970 ,
'HKS Colors -- HKS 42K 010%  K 50%' => 0x61636D ,
'HKS Colors -- HKS 43K 010%  K 50%' => 0x5F636D ,
'HKS Colors -- HKS 44K 010%  K 50%' => 0x5E6068 ,
'HKS Colors -- HKS 45K 010%  K 50%' => 0x616167 ,
'HKS Colors -- HKS 46K 010%  K 50%' => 0x666A6F ,
'HKS Colors -- HKS 47K 010%  K 50%' => 0x5E666D ,
'HKS Colors -- HKS 48K 010%  K 50%' => 0x586368 ,
'HKS Colors -- HKS 49K 010%  K 50%' => 0x5B6369 ,
'HKS Colors -- HKS 50K 010%  K 50%' => 0x686D70 ,
'HKS Colors -- HKS 51K 010%  K 50%' => 0x64696D ,
'HKS Colors -- HKS 52K 010%  K 50%' => 0x646D6F ,
'HKS Colors -- HKS 53K 010%  K 50%' => 0x5C6766 ,
'HKS Colors -- HKS 54K 010%  K 50%' => 0x5F6A67 ,
'HKS Colors -- HKS 55K 010%  K 50%' => 0x5E6767 ,
'HKS Colors -- HKS 56K 010%  K 50%' => 0x6E7476 ,
'HKS Colors -- HKS 57K 010%  K 50%' => 0x636965 ,
'HKS Colors -- HKS 58K 010%  K 50%' => 0x686B6A ,
'HKS Colors -- HKS 59K 010%  K 50%' => 0x60696B ,
'HKS Colors -- HKS 60K 010%  K 50%' => 0x6E7470 ,
'HKS Colors -- HKS 61K 010%  K 50%' => 0x686B6D ,
'HKS Colors -- HKS 62K 010%  K 50%' => 0x6B6D67 ,
'HKS Colors -- HKS 63K 010%  K 50%' => 0x6A706B ,
'HKS Colors -- HKS 64K 010%  K 50%' => 0x697069 ,
'HKS Colors -- HKS 65K 010%  K 50%' => 0x6F776F ,
'HKS Colors -- HKS 66K 010%  K 50%' => 0x64695F ,
'HKS Colors -- HKS 67K 010%  K 50%' => 0x7B8276 ,
'HKS Colors -- HKS 68K 010%  K 50%' => 0x6F7069 ,
'HKS Colors -- HKS 69K 010%  K 50%' => 0x74756F ,
'HKS Colors -- HKS 71K 010%  K 50%' => 0x696563 ,
'HKS Colors -- HKS 72K 010%  K 50%' => 0x635E5C ,
'HKS Colors -- HKS 73K 010%  K 50%' => 0x6F6B69 ,
'HKS Colors -- HKS 74K 010%  K 50%' => 0x6B6869 ,
'HKS Colors -- HKS 75K 010%  K 50%' => 0x706F6D ,
'HKS Colors -- HKS 76K 010%  K 50%' => 0x6E6E70 ,
'HKS Colors -- HKS 77K 010%  K 50%' => 0x696667 ,
'HKS Colors -- HKS 78K 010%  K 50%' => 0x757071 ,
'HKS Colors -- HKS 81K 010%  K 50%' => 0x716B6B ,
'HKS Colors -- HKS 82K 010%  K 50%' => 0x787071 ,
'HKS Colors -- HKS 83K 010%  K 50%' => 0x6E6D6F ,
'HKS Colors -- HKS 84K 010%  K 50%' => 0x69676A ,
'HKS Colors -- HKS 88K 010%  K 50%' => 0xD9D7DA ,
'HKS Colors -- HKS 89K 010%  K 50%' => 0x707070 ,
'HKS Colors -- HKS 90K 010%  K 50%' => 0x69696B ,
'HKS Colors -- HKS 91K 010%  K 50%' => 0x74767A ,
'HKS Colors -- HKS 92K 010%  K 50%' => 0x75777B ,
'HKS Colors -- HKS 93K 010%  K 50%' => 0x636468 ,
'HKS Colors -- HKS 95K 010%  K 50%' => 0x6D6D6F ,
'HKS Colors -- HKS 96K 010%  K 50%' => 0x6D6D6F ,
'HKS Colors -- HKS 97K 010%  K 50%' => 0x656668 ,
'HKS Colors -- HKS 01K 020%  K 50%' => 0x7C7B70 ,
'HKS Colors -- HKS 02K 020%  K 50%' => 0x7A7A66 ,
'HKS Colors -- HKS 03K 020%  K 50%' => 0x7C7C61 ,
'HKS Colors -- HKS 04K 020%  K 50%' => 0x706E5D ,
'HKS Colors -- HKS 05K 020%  K 50%' => 0x7B7460 ,
'HKS Colors -- HKS 06K 020%  K 50%' => 0x6B5F52 ,
'HKS Colors -- HKS 07K 020%  K 50%' => 0x695751 ,
'HKS Colors -- HKS 08K 020%  K 50%' => 0x6A5854 ,
'HKS Colors -- HKS 10K 020%  K 50%' => 0x756060 ,
'HKS Colors -- HKS 11K 020%  K 50%' => 0x7B6F6B ,
'HKS Colors -- HKS 12K 020%  K 50%' => 0x685758 ,
'HKS Colors -- HKS 13K 020%  K 50%' => 0x6F5558 ,
'HKS Colors -- HKS 14K 020%  K 50%' => 0x665556 ,
'HKS Colors -- HKS 15K 020%  K 50%' => 0x604F55 ,
'HKS Colors -- HKS 16K 020%  K 50%' => 0x5F5256 ,
'HKS Colors -- HKS 17K 020%  K 50%' => 0x64565C ,
'HKS Colors -- HKS 18K 020%  K 50%' => 0x5F545C ,
'HKS Colors -- HKS 21K 020%  K 50%' => 0x6E6167 ,
'HKS Colors -- HKS 22K 020%  K 50%' => 0x7B6469 ,
'HKS Colors -- HKS 23K 020%  K 50%' => 0x68555D ,
'HKS Colors -- HKS 24K 020%  K 50%' => 0x6A535E ,
'HKS Colors -- HKS 25K 020%  K 50%' => 0x735E6B ,
'HKS Colors -- HKS 26K 020%  K 50%' => 0x6A5663 ,
'HKS Colors -- HKS 27K 020%  K 50%' => 0x6B5565 ,
'HKS Colors -- HKS 28K 020%  K 50%' => 0x574A51 ,
'HKS Colors -- HKS 29K 020%  K 50%' => 0x605563 ,
'HKS Colors -- HKS 31K 020%  K 50%' => 0x685564 ,
'HKS Colors -- HKS 32K 020%  K 50%' => 0x6B5767 ,
'HKS Colors -- HKS 33K 020%  K 50%' => 0x645468 ,
'HKS Colors -- HKS 34K 020%  K 50%' => 0x645F70 ,
'HKS Colors -- HKS 35K 020%  K 50%' => 0x656172 ,
'HKS Colors -- HKS 36K 020%  K 50%' => 0x656071 ,
'HKS Colors -- HKS 37K 020%  K 50%' => 0x615F68 ,
'HKS Colors -- HKS 38K 020%  K 50%' => 0x65676F ,
'HKS Colors -- HKS 39K 020%  K 50%' => 0x5C606F ,
'HKS Colors -- HKS 40K 020%  K 50%' => 0x5B6369 ,
'HKS Colors -- HKS 41K 020%  K 50%' => 0x5C5E66 ,
'HKS Colors -- HKS 42K 020%  K 50%' => 0x585867 ,
'HKS Colors -- HKS 43K 020%  K 50%' => 0x55586A ,
'HKS Colors -- HKS 44K 020%  K 50%' => 0x525A66 ,
'HKS Colors -- HKS 45K 020%  K 50%' => 0x5B5A65 ,
'HKS Colors -- HKS 46K 020%  K 50%' => 0x5F6770 ,
'HKS Colors -- HKS 47K 020%  K 50%' => 0x55656F ,
'HKS Colors -- HKS 48K 020%  K 50%' => 0x53646B ,
'HKS Colors -- HKS 49K 020%  K 50%' => 0x4F5E66 ,
'HKS Colors -- HKS 50K 020%  K 50%' => 0x5F6A70 ,
'HKS Colors -- HKS 51K 020%  K 50%' => 0x556466 ,
'HKS Colors -- HKS 52K 020%  K 50%' => 0x576867 ,
'HKS Colors -- HKS 53K 020%  K 50%' => 0x546965 ,
'HKS Colors -- HKS 54K 020%  K 50%' => 0x52655D ,
'HKS Colors -- HKS 55K 020%  K 50%' => 0x556560 ,
'HKS Colors -- HKS 56K 020%  K 50%' => 0x5E6A6A ,
'HKS Colors -- HKS 57K 020%  K 50%' => 0x58675E ,
'HKS Colors -- HKS 58K 020%  K 50%' => 0x5C635E ,
'HKS Colors -- HKS 59K 020%  K 50%' => 0x526063 ,
'HKS Colors -- HKS 60K 020%  K 50%' => 0x687267 ,
'HKS Colors -- HKS 61K 020%  K 50%' => 0x5E635F ,
'HKS Colors -- HKS 62K 020%  K 50%' => 0x60635A ,
'HKS Colors -- HKS 63K 020%  K 50%' => 0x636860 ,
'HKS Colors -- HKS 64K 020%  K 50%' => 0x5D6B5F ,
'HKS Colors -- HKS 65K 020%  K 50%' => 0x697766 ,
'HKS Colors -- HKS 66K 020%  K 50%' => 0x606954 ,
'HKS Colors -- HKS 67K 020%  K 50%' => 0x73806A ,
'HKS Colors -- HKS 68K 020%  K 50%' => 0x706F60 ,
'HKS Colors -- HKS 69K 020%  K 50%' => 0x747565 ,
'HKS Colors -- HKS 71K 020%  K 50%' => 0x645E56 ,
'HKS Colors -- HKS 72K 020%  K 50%' => 0x615B53 ,
'HKS Colors -- HKS 73K 020%  K 50%' => 0x6A6661 ,
'HKS Colors -- HKS 74K 020%  K 50%' => 0x66615F ,
'HKS Colors -- HKS 75K 020%  K 50%' => 0x6A6965 ,
'HKS Colors -- HKS 76K 020%  K 50%' => 0x676465 ,
'HKS Colors -- HKS 77K 020%  K 50%' => 0x615F5F ,
'HKS Colors -- HKS 78K 020%  K 50%' => 0x706767 ,
'HKS Colors -- HKS 81K 020%  K 50%' => 0x736563 ,
'HKS Colors -- HKS 82K 020%  K 50%' => 0x756A69 ,
'HKS Colors -- HKS 83K 020%  K 50%' => 0x676364 ,
'HKS Colors -- HKS 84K 020%  K 50%' => 0x615D5E ,
'HKS Colors -- HKS 88K 020%  K 50%' => 0xC2C0C3 ,
'HKS Colors -- HKS 89K 020%  K 50%' => 0x6B6B6B ,
'HKS Colors -- HKS 90K 020%  K 50%' => 0x5E5D5F ,
'HKS Colors -- HKS 91K 020%  K 50%' => 0x707072 ,
'HKS Colors -- HKS 92K 020%  K 50%' => 0x6D6D6F ,
'HKS Colors -- HKS 93K 020%  K 50%' => 0x5B5C60 ,
'HKS Colors -- HKS 95K 020%  K 50%' => 0x666666 ,
'HKS Colors -- HKS 96K 020%  K 50%' => 0x6B6B6E ,
'HKS Colors -- HKS 97K 020%  K 50%' => 0x5C5C5E ,
'HKS Colors -- HKS 01K 030%  K 50%' => 0x7A7767 ,
'HKS Colors -- HKS 02K 030%  K 50%' => 0x777658 ,
'HKS Colors -- HKS 03K 030%  K 50%' => 0x7D7D57 ,
'HKS Colors -- HKS 04K 030%  K 50%' => 0x6D694E ,
'HKS Colors -- HKS 05K 030%  K 50%' => 0x776F53 ,
'HKS Colors -- HKS 06K 030%  K 50%' => 0x675744 ,
'HKS Colors -- HKS 07K 030%  K 50%' => 0x695146 ,
'HKS Colors -- HKS 08K 030%  K 50%' => 0x664E47 ,
'HKS Colors -- HKS 10K 030%  K 50%' => 0x765855 ,
'HKS Colors -- HKS 11K 030%  K 50%' => 0x786764 ,
'HKS Colors -- HKS 12K 030%  K 50%' => 0x684E4E ,
'HKS Colors -- HKS 13K 030%  K 50%' => 0x6B4A4E ,
'HKS Colors -- HKS 14K 030%  K 50%' => 0x644A4C ,
'HKS Colors -- HKS 15K 030%  K 50%' => 0x5A4247 ,
'HKS Colors -- HKS 16K 030%  K 50%' => 0x5A454C ,
'HKS Colors -- HKS 17K 030%  K 50%' => 0x5C474F ,
'HKS Colors -- HKS 18K 030%  K 50%' => 0x584651 ,
'HKS Colors -- HKS 21K 030%  K 50%' => 0x6B5B60 ,
'HKS Colors -- HKS 22K 030%  K 50%' => 0x76575D ,
'HKS Colors -- HKS 23K 030%  K 50%' => 0x684C55 ,
'HKS Colors -- HKS 24K 030%  K 50%' => 0x674756 ,
'HKS Colors -- HKS 25K 030%  K 50%' => 0x6B515F ,
'HKS Colors -- HKS 26K 030%  K 50%' => 0x5B4453 ,
'HKS Colors -- HKS 27K 030%  K 50%' => 0x684A5E ,
'HKS Colors -- HKS 28K 030%  K 50%' => 0x534049 ,
'HKS Colors -- HKS 29K 030%  K 50%' => 0x5F4D5F ,
'HKS Colors -- HKS 31K 030%  K 50%' => 0x64495C ,
'HKS Colors -- HKS 32K 030%  K 50%' => 0x6A4E63 ,
'HKS Colors -- HKS 33K 030%  K 50%' => 0x5E4A65 ,
'HKS Colors -- HKS 34K 030%  K 50%' => 0x5D556A ,
'HKS Colors -- HKS 35K 030%  K 50%' => 0x5A566A ,
'HKS Colors -- HKS 36K 030%  K 50%' => 0x5C5469 ,
'HKS Colors -- HKS 37K 030%  K 50%' => 0x54515E ,
'HKS Colors -- HKS 38K 030%  K 50%' => 0x565C65 ,
'HKS Colors -- HKS 39K 030%  K 50%' => 0x4F576A ,
'HKS Colors -- HKS 40K 030%  K 50%' => 0x525D67 ,
'HKS Colors -- HKS 41K 030%  K 50%' => 0x4F535C ,
'HKS Colors -- HKS 42K 030%  K 50%' => 0x4E5165 ,
'HKS Colors -- HKS 43K 030%  K 50%' => 0x464C63 ,
'HKS Colors -- HKS 44K 030%  K 50%' => 0x475160 ,
'HKS Colors -- HKS 45K 030%  K 50%' => 0x535360 ,
'HKS Colors -- HKS 46K 030%  K 50%' => 0x535F6A ,
'HKS Colors -- HKS 47K 030%  K 50%' => 0x475B69 ,
'HKS Colors -- HKS 48K 030%  K 50%' => 0x465E68 ,
'HKS Colors -- HKS 49K 030%  K 50%' => 0x435763 ,
'HKS Colors -- HKS 50K 030%  K 50%' => 0x55646A ,
'HKS Colors -- HKS 51K 030%  K 50%' => 0x4C6064 ,
'HKS Colors -- HKS 52K 030%  K 50%' => 0x4A5F5D ,
'HKS Colors -- HKS 53K 030%  K 50%' => 0x4A655E ,
'HKS Colors -- HKS 54K 030%  K 50%' => 0x435C52 ,
'HKS Colors -- HKS 55K 030%  K 50%' => 0x495C56 ,
'HKS Colors -- HKS 56K 030%  K 50%' => 0x566464 ,
'HKS Colors -- HKS 57K 030%  K 50%' => 0x4A6054 ,
'HKS Colors -- HKS 58K 030%  K 50%' => 0x545D57 ,
'HKS Colors -- HKS 59K 030%  K 50%' => 0x455858 ,
'HKS Colors -- HKS 60K 030%  K 50%' => 0x606E5D ,
'HKS Colors -- HKS 61K 030%  K 50%' => 0x545D56 ,
'HKS Colors -- HKS 62K 030%  K 50%' => 0x5A5B4E ,
'HKS Colors -- HKS 63K 030%  K 50%' => 0x586357 ,
'HKS Colors -- HKS 64K 030%  K 50%' => 0x52634F ,
'HKS Colors -- HKS 65K 030%  K 50%' => 0x5C7056 ,
'HKS Colors -- HKS 66K 030%  K 50%' => 0x566545 ,
'HKS Colors -- HKS 67K 030%  K 50%' => 0x687756 ,
'HKS Colors -- HKS 68K 030%  K 50%' => 0x6D6B56 ,
'HKS Colors -- HKS 69K 030%  K 50%' => 0x71725A ,
'HKS Colors -- HKS 71K 030%  K 50%' => 0x5F584C ,
'HKS Colors -- HKS 72K 030%  K 50%' => 0x5A5144 ,
'HKS Colors -- HKS 73K 030%  K 50%' => 0x645E56 ,
'HKS Colors -- HKS 74K 030%  K 50%' => 0x5D5852 ,
'HKS Colors -- HKS 75K 030%  K 50%' => 0x64615A ,
'HKS Colors -- HKS 76K 030%  K 50%' => 0x5C5A58 ,
'HKS Colors -- HKS 77K 030%  K 50%' => 0x5C5656 ,
'HKS Colors -- HKS 78K 030%  K 50%' => 0x685D5C ,
'HKS Colors -- HKS 81K 030%  K 50%' => 0x6D5852 ,
'HKS Colors -- HKS 82K 030%  K 50%' => 0x715F5C ,
'HKS Colors -- HKS 83K 030%  K 50%' => 0x5E5556 ,
'HKS Colors -- HKS 84K 030%  K 50%' => 0x5B5456 ,
'HKS Colors -- HKS 88K 030%  K 50%' => 0xAEABAF ,
'HKS Colors -- HKS 89K 030%  K 50%' => 0x63615F ,
'HKS Colors -- HKS 90K 030%  K 50%' => 0x555355 ,
'HKS Colors -- HKS 91K 030%  K 50%' => 0x69696B ,
'HKS Colors -- HKS 92K 030%  K 50%' => 0x636365 ,
'HKS Colors -- HKS 93K 030%  K 50%' => 0x525356 ,
'HKS Colors -- HKS 95K 030%  K 50%' => 0x5D5D5D ,
'HKS Colors -- HKS 96K 030%  K 50%' => 0x636466 ,
'HKS Colors -- HKS 97K 030%  K 50%' => 0x515354 ,
'HKS Colors -- HKS 01K 040%  K 50%' => 0x7A7860 ,
'HKS Colors -- HKS 02K 040%  K 50%' => 0x77774F ,
'HKS Colors -- HKS 03K 040%  K 50%' => 0x7D7B4B ,
'HKS Colors -- HKS 04K 040%  K 50%' => 0x6D6741 ,
'HKS Colors -- HKS 05K 040%  K 50%' => 0x786E47 ,
'HKS Colors -- HKS 06K 040%  K 50%' => 0x685540 ,
'HKS Colors -- HKS 07K 040%  K 50%' => 0x66493B ,
'HKS Colors -- HKS 08K 040%  K 50%' => 0x664A42 ,
'HKS Colors -- HKS 10K 040%  K 50%' => 0x774F4D ,
'HKS Colors -- HKS 11K 040%  K 50%' => 0x75605D ,
'HKS Colors -- HKS 12K 040%  K 50%' => 0x644342 ,
'HKS Colors -- HKS 13K 040%  K 50%' => 0x6B3D43 ,
'HKS Colors -- HKS 14K 040%  K 50%' => 0x614142 ,
'HKS Colors -- HKS 15K 040%  K 50%' => 0x5B3A42 ,
'HKS Colors -- HKS 16K 040%  K 50%' => 0x563B42 ,
'HKS Colors -- HKS 17K 040%  K 50%' => 0x583E49 ,
'HKS Colors -- HKS 18K 040%  K 50%' => 0x543D4A ,
'HKS Colors -- HKS 21K 040%  K 50%' => 0x6B535B ,
'HKS Colors -- HKS 22K 040%  K 50%' => 0x784F57 ,
'HKS Colors -- HKS 23K 040%  K 50%' => 0x66414B ,
'HKS Colors -- HKS 24K 040%  K 50%' => 0x633A4A ,
'HKS Colors -- HKS 25K 040%  K 50%' => 0x694357 ,
'HKS Colors -- HKS 26K 040%  K 50%' => 0x5C3A4F ,
'HKS Colors -- HKS 27K 040%  K 50%' => 0x673E5A ,
'HKS Colors -- HKS 28K 040%  K 50%' => 0x513543 ,
'HKS Colors -- HKS 29K 040%  K 50%' => 0x58445B ,
'HKS Colors -- HKS 31K 040%  K 50%' => 0x633E56 ,
'HKS Colors -- HKS 32K 040%  K 50%' => 0x68435C ,
'HKS Colors -- HKS 33K 040%  K 50%' => 0x5B4364 ,
'HKS Colors -- HKS 34K 040%  K 50%' => 0x564A65 ,
'HKS Colors -- HKS 35K 040%  K 50%' => 0x534E66 ,
'HKS Colors -- HKS 36K 040%  K 50%' => 0x534964 ,
'HKS Colors -- HKS 37K 040%  K 50%' => 0x4D4656 ,
'HKS Colors -- HKS 38K 040%  K 50%' => 0x4A515B ,
'HKS Colors -- HKS 39K 040%  K 50%' => 0x464F66 ,
'HKS Colors -- HKS 40K 040%  K 50%' => 0x4A5863 ,
'HKS Colors -- HKS 41K 040%  K 50%' => 0x444B55 ,
'HKS Colors -- HKS 42K 040%  K 50%' => 0x43445E ,
'HKS Colors -- HKS 43K 040%  K 50%' => 0x3C4361 ,
'HKS Colors -- HKS 44K 040%  K 50%' => 0x3D4A5C ,
'HKS Colors -- HKS 45K 040%  K 50%' => 0x4B4A5C ,
'HKS Colors -- HKS 46K 040%  K 50%' => 0x4C5D6B ,
'HKS Colors -- HKS 47K 040%  K 50%' => 0x3D5767 ,
'HKS Colors -- HKS 48K 040%  K 50%' => 0x3A5761 ,
'HKS Colors -- HKS 49K 040%  K 50%' => 0x36525E ,
'HKS Colors -- HKS 50K 040%  K 50%' => 0x4E6168 ,
'HKS Colors -- HKS 51K 040%  K 50%' => 0x425C5D ,
'HKS Colors -- HKS 52K 040%  K 50%' => 0x405855 ,
'HKS Colors -- HKS 53K 040%  K 50%' => 0x3D665B ,
'HKS Colors -- HKS 54K 040%  K 50%' => 0x385A4A ,
'HKS Colors -- HKS 55K 040%  K 50%' => 0x3B554D ,
'HKS Colors -- HKS 56K 040%  K 50%' => 0x475A58 ,
'HKS Colors -- HKS 57K 040%  K 50%' => 0x435D4D ,
'HKS Colors -- HKS 58K 040%  K 50%' => 0x4A554D ,
'HKS Colors -- HKS 59K 040%  K 50%' => 0x3A5455 ,
'HKS Colors -- HKS 60K 040%  K 50%' => 0x576A52 ,
'HKS Colors -- HKS 61K 040%  K 50%' => 0x4B554C ,
'HKS Colors -- HKS 62K 040%  K 50%' => 0x535544 ,
'HKS Colors -- HKS 63K 040%  K 50%' => 0x515D4D ,
'HKS Colors -- HKS 64K 040%  K 50%' => 0x465F44 ,
'HKS Colors -- HKS 65K 040%  K 50%' => 0x566E4B ,
'HKS Colors -- HKS 66K 040%  K 50%' => 0x52653C ,
'HKS Colors -- HKS 67K 040%  K 50%' => 0x61754B ,
'HKS Colors -- HKS 68K 040%  K 50%' => 0x68684B ,
'HKS Colors -- HKS 69K 040%  K 50%' => 0x70704D ,
'HKS Colors -- HKS 71K 040%  K 50%' => 0x5C5243 ,
'HKS Colors -- HKS 72K 040%  K 50%' => 0x584E3E ,
'HKS Colors -- HKS 73K 040%  K 50%' => 0x60574C ,
'HKS Colors -- HKS 74K 040%  K 50%' => 0x58514A ,
'HKS Colors -- HKS 75K 040%  K 50%' => 0x5D5A4E ,
'HKS Colors -- HKS 76K 040%  K 50%' => 0x524E4D ,
'HKS Colors -- HKS 77K 040%  K 50%' => 0x544E4C ,
'HKS Colors -- HKS 78K 040%  K 50%' => 0x615352 ,
'HKS Colors -- HKS 81K 040%  K 50%' => 0x69524B ,
'HKS Colors -- HKS 82K 040%  K 50%' => 0x6D5652 ,
'HKS Colors -- HKS 83K 040%  K 50%' => 0x5A4E4E ,
'HKS Colors -- HKS 84K 040%  K 50%' => 0x514647 ,
'HKS Colors -- HKS 88K 040%  K 50%' => 0x99979A ,
'HKS Colors -- HKS 89K 040%  K 50%' => 0x5D5C5A ,
'HKS Colors -- HKS 90K 040%  K 50%' => 0x4B4A4C ,
'HKS Colors -- HKS 91K 040%  K 50%' => 0x616566 ,
'HKS Colors -- HKS 92K 040%  K 50%' => 0x5A5A5C ,
'HKS Colors -- HKS 93K 040%  K 50%' => 0x4B4C4F ,
'HKS Colors -- HKS 95K 040%  K 50%' => 0x555555 ,
'HKS Colors -- HKS 96K 040%  K 50%' => 0x606060 ,
'HKS Colors -- HKS 97K 040%  K 50%' => 0x494B4A ,
'HKS Colors -- HKS 01K 050%  K 50%' => 0x7A775B ,
'HKS Colors -- HKS 02K 050%  K 50%' => 0x757544 ,
'HKS Colors -- HKS 03K 050%  K 50%' => 0x7B783C ,
'HKS Colors -- HKS 04K 050%  K 50%' => 0x6A6431 ,
'HKS Colors -- HKS 05K 050%  K 50%' => 0x756939 ,
'HKS Colors -- HKS 06K 050%  K 50%' => 0x6B5234 ,
'HKS Colors -- HKS 07K 050%  K 50%' => 0x64422F ,
'HKS Colors -- HKS 08K 050%  K 50%' => 0x644136 ,
'HKS Colors -- HKS 10K 050%  K 50%' => 0x744440 ,
'HKS Colors -- HKS 11K 050%  K 50%' => 0x735C55 ,
'HKS Colors -- HKS 12K 050%  K 50%' => 0x663C3B ,
'HKS Colors -- HKS 13K 050%  K 50%' => 0x6A3139 ,
'HKS Colors -- HKS 14K 050%  K 50%' => 0x5D3638 ,
'HKS Colors -- HKS 15K 050%  K 50%' => 0x5A313A ,
'HKS Colors -- HKS 16K 050%  K 50%' => 0x52313B ,
'HKS Colors -- HKS 17K 050%  K 50%' => 0x573543 ,
'HKS Colors -- HKS 18K 050%  K 50%' => 0x4D3140 ,
'HKS Colors -- HKS 21K 050%  K 50%' => 0x694D56 ,
'HKS Colors -- HKS 22K 050%  K 50%' => 0x76444C ,
'HKS Colors -- HKS 23K 050%  K 50%' => 0x653845 ,
'HKS Colors -- HKS 24K 050%  K 50%' => 0x603244 ,
'HKS Colors -- HKS 25K 050%  K 50%' => 0x653852 ,
'HKS Colors -- HKS 26K 050%  K 50%' => 0x5A314A ,
'HKS Colors -- HKS 27K 050%  K 50%' => 0x653657 ,
'HKS Colors -- HKS 28K 050%  K 50%' => 0x4E2D3D ,
'HKS Colors -- HKS 29K 050%  K 50%' => 0x543B57 ,
'HKS Colors -- HKS 31K 050%  K 50%' => 0x5F3451 ,
'HKS Colors -- HKS 32K 050%  K 50%' => 0x663956 ,
'HKS Colors -- HKS 33K 050%  K 50%' => 0x56395E ,
'HKS Colors -- HKS 34K 050%  K 50%' => 0x51405F ,
'HKS Colors -- HKS 35K 050%  K 50%' => 0x4B4561 ,
'HKS Colors -- HKS 36K 050%  K 50%' => 0x4C3D5F ,
'HKS Colors -- HKS 37K 050%  K 50%' => 0x443C51 ,
'HKS Colors -- HKS 38K 050%  K 50%' => 0x424955 ,
'HKS Colors -- HKS 39K 050%  K 50%' => 0x3C4763 ,
'HKS Colors -- HKS 40K 050%  K 50%' => 0x405461 ,
'HKS Colors -- HKS 41K 050%  K 50%' => 0x3E4551 ,
'HKS Colors -- HKS 42K 050%  K 50%' => 0x3C3D5A ,
'HKS Colors -- HKS 43K 050%  K 50%' => 0x313C5F ,
'HKS Colors -- HKS 44K 050%  K 50%' => 0x35445B ,
'HKS Colors -- HKS 45K 050%  K 50%' => 0x44435A ,
'HKS Colors -- HKS 46K 050%  K 50%' => 0x425665 ,
'HKS Colors -- HKS 47K 050%  K 50%' => 0x315163 ,
'HKS Colors -- HKS 48K 050%  K 50%' => 0x325563 ,
'HKS Colors -- HKS 49K 050%  K 50%' => 0x2B4C5C ,
'HKS Colors -- HKS 50K 050%  K 50%' => 0x445D65 ,
'HKS Colors -- HKS 51K 050%  K 50%' => 0x3A585A ,
'HKS Colors -- HKS 52K 050%  K 50%' => 0x35534F ,
'HKS Colors -- HKS 53K 050%  K 50%' => 0x326054 ,
'HKS Colors -- HKS 54K 050%  K 50%' => 0x295141 ,
'HKS Colors -- HKS 55K 050%  K 50%' => 0x2F4E43 ,
'HKS Colors -- HKS 56K 050%  K 50%' => 0x3E5654 ,
'HKS Colors -- HKS 57K 050%  K 50%' => 0x345541 ,
'HKS Colors -- HKS 58K 050%  K 50%' => 0x455147 ,
'HKS Colors -- HKS 59K 050%  K 50%' => 0x2D4C4D ,
'HKS Colors -- HKS 60K 050%  K 50%' => 0x4E6547 ,
'HKS Colors -- HKS 61K 050%  K 50%' => 0x424D42 ,
'HKS Colors -- HKS 62K 050%  K 50%' => 0x4D513C ,
'HKS Colors -- HKS 63K 050%  K 50%' => 0x4A5844 ,
'HKS Colors -- HKS 64K 050%  K 50%' => 0x3E5B3B ,
'HKS Colors -- HKS 65K 050%  K 50%' => 0x4D6A41 ,
'HKS Colors -- HKS 66K 050%  K 50%' => 0x4C6131 ,
'HKS Colors -- HKS 67K 050%  K 50%' => 0x5C723E ,
'HKS Colors -- HKS 68K 050%  K 50%' => 0x646340 ,
'HKS Colors -- HKS 69K 050%  K 50%' => 0x6B6D42 ,
'HKS Colors -- HKS 71K 050%  K 50%' => 0x5A4D38 ,
'HKS Colors -- HKS 72K 050%  K 50%' => 0x584A33 ,
'HKS Colors -- HKS 73K 050%  K 50%' => 0x5E5443 ,
'HKS Colors -- HKS 74K 050%  K 50%' => 0x52493C ,
'HKS Colors -- HKS 75K 050%  K 50%' => 0x585445 ,
'HKS Colors -- HKS 76K 050%  K 50%' => 0x45423D ,
'HKS Colors -- HKS 77K 050%  K 50%' => 0x4D4542 ,
'HKS Colors -- HKS 78K 050%  K 50%' => 0x5D4A45 ,
'HKS Colors -- HKS 81K 050%  K 50%' => 0x694A41 ,
'HKS Colors -- HKS 82K 050%  K 50%' => 0x6B4F4A ,
'HKS Colors -- HKS 83K 050%  K 50%' => 0x524342 ,
'HKS Colors -- HKS 84K 050%  K 50%' => 0x493D3D ,
'HKS Colors -- HKS 88K 050%  K 50%' => 0x828285 ,
'HKS Colors -- HKS 89K 050%  K 50%' => 0x5C5B57 ,
'HKS Colors -- HKS 90K 050%  K 50%' => 0x444242 ,
'HKS Colors -- HKS 91K 050%  K 50%' => 0x5E6163 ,
'HKS Colors -- HKS 92K 050%  K 50%' => 0x535455 ,
'HKS Colors -- HKS 93K 050%  K 50%' => 0x434447 ,
'HKS Colors -- HKS 95K 050%  K 50%' => 0x52524F ,
'HKS Colors -- HKS 96K 050%  K 50%' => 0x5A5A5A ,
'HKS Colors -- HKS 97K 050%  K 50%' => 0x424544 ,
'HKS Colors -- HKS 01K 060%  K 50%' => 0x7A7753 ,
'HKS Colors -- HKS 02K 060%  K 50%' => 0x757330 ,
'HKS Colors -- HKS 03K 060%  K 50%' => 0x7C7829 ,
'HKS Colors -- HKS 04K 060%  K 50%' => 0x6D6421 ,
'HKS Colors -- HKS 05K 060%  K 50%' => 0x786829 ,
'HKS Colors -- HKS 06K 060%  K 50%' => 0x6B4B25 ,
'HKS Colors -- HKS 07K 060%  K 50%' => 0x663A21 ,
'HKS Colors -- HKS 08K 060%  K 50%' => 0x663929 ,
'HKS Colors -- HKS 10K 060%  K 50%' => 0x763931 ,
'HKS Colors -- HKS 11K 060%  K 50%' => 0x75564E ,
'HKS Colors -- HKS 12K 060%  K 50%' => 0x662F2E ,
'HKS Colors -- HKS 13K 060%  K 50%' => 0x6D212B ,
'HKS Colors -- HKS 14K 060%  K 50%' => 0x5B2A2D ,
'HKS Colors -- HKS 15K 060%  K 50%' => 0x562530 ,
'HKS Colors -- HKS 16K 060%  K 50%' => 0x4F242E ,
'HKS Colors -- HKS 17K 060%  K 50%' => 0x522434 ,
'HKS Colors -- HKS 18K 060%  K 50%' => 0x462233 ,
'HKS Colors -- HKS 21K 060%  K 50%' => 0x694751 ,
'HKS Colors -- HKS 22K 060%  K 50%' => 0x7A3640 ,
'HKS Colors -- HKS 23K 060%  K 50%' => 0x632B3B ,
'HKS Colors -- HKS 24K 060%  K 50%' => 0x5E273C ,
'HKS Colors -- HKS 25K 060%  K 50%' => 0x632846 ,
'HKS Colors -- HKS 26K 060%  K 50%' => 0x532141 ,
'HKS Colors -- HKS 27K 060%  K 50%' => 0x61274F ,
'HKS Colors -- HKS 28K 060%  K 50%' => 0x4C2235 ,
'HKS Colors -- HKS 29K 060%  K 50%' => 0x4C2E4C ,
'HKS Colors -- HKS 31K 060%  K 50%' => 0x5C264A ,
'HKS Colors -- HKS 32K 060%  K 50%' => 0x612247 ,
'HKS Colors -- HKS 33K 060%  K 50%' => 0x4F295B ,
'HKS Colors -- HKS 34K 060%  K 50%' => 0x47335B ,
'HKS Colors -- HKS 35K 060%  K 50%' => 0x3D355B ,
'HKS Colors -- HKS 36K 060%  K 50%' => 0x432D5A ,
'HKS Colors -- HKS 37K 060%  K 50%' => 0x393049 ,
'HKS Colors -- HKS 38K 060%  K 50%' => 0x303845 ,
'HKS Colors -- HKS 39K 060%  K 50%' => 0x2E3C5D ,
'HKS Colors -- HKS 40K 060%  K 50%' => 0x324E5F ,
'HKS Colors -- HKS 41K 060%  K 50%' => 0x2F3644 ,
'HKS Colors -- HKS 42K 060%  K 50%' => 0x2D3054 ,
'HKS Colors -- HKS 43K 060%  K 50%' => 0x25305D ,
'HKS Colors -- HKS 44K 060%  K 50%' => 0x273A55 ,
'HKS Colors -- HKS 45K 060%  K 50%' => 0x3C3B56 ,
'HKS Colors -- HKS 46K 060%  K 50%' => 0x344E60 ,
'HKS Colors -- HKS 47K 060%  K 50%' => 0x214B63 ,
'HKS Colors -- HKS 48K 060%  K 50%' => 0x205160 ,
'HKS Colors -- HKS 49K 060%  K 50%' => 0x1B4658 ,
'HKS Colors -- HKS 50K 060%  K 50%' => 0x3B5B65 ,
'HKS Colors -- HKS 51K 060%  K 50%' => 0x2D5354 ,
'HKS Colors -- HKS 52K 060%  K 50%' => 0x224A43 ,
'HKS Colors -- HKS 53K 060%  K 50%' => 0x215B4A ,
'HKS Colors -- HKS 54K 060%  K 50%' => 0x174A33 ,
'HKS Colors -- HKS 55K 060%  K 50%' => 0x1E4436 ,
'HKS Colors -- HKS 56K 060%  K 50%' => 0x284944 ,
'HKS Colors -- HKS 57K 060%  K 50%' => 0x1E4C30 ,
'HKS Colors -- HKS 58K 060%  K 50%' => 0x314333 ,
'HKS Colors -- HKS 59K 060%  K 50%' => 0x194344 ,
'HKS Colors -- HKS 60K 060%  K 50%' => 0x405E35 ,
'HKS Colors -- HKS 61K 060%  K 50%' => 0x30402F ,
'HKS Colors -- HKS 62K 060%  K 50%' => 0x42462B ,
'HKS Colors -- HKS 63K 060%  K 50%' => 0x3C4E32 ,
'HKS Colors -- HKS 64K 060%  K 50%' => 0x2E5128 ,
'HKS Colors -- HKS 65K 060%  K 50%' => 0x41662F ,
'HKS Colors -- HKS 66K 060%  K 50%' => 0x455D24 ,
'HKS Colors -- HKS 67K 060%  K 50%' => 0x53702F ,
'HKS Colors -- HKS 68K 060%  K 50%' => 0x615F33 ,
'HKS Colors -- HKS 69K 060%  K 50%' => 0x6A6B35 ,
'HKS Colors -- HKS 71K 060%  K 50%' => 0x5B4B2E ,
'HKS Colors -- HKS 72K 060%  K 50%' => 0x564223 ,
'HKS Colors -- HKS 73K 060%  K 50%' => 0x5B4C33 ,
'HKS Colors -- HKS 74K 060%  K 50%' => 0x4C402E ,
'HKS Colors -- HKS 75K 060%  K 50%' => 0x514B38 ,
'HKS Colors -- HKS 76K 060%  K 50%' => 0x352F27 ,
'HKS Colors -- HKS 77K 060%  K 50%' => 0x423630 ,
'HKS Colors -- HKS 78K 060%  K 50%' => 0x523A35 ,
'HKS Colors -- HKS 81K 060%  K 50%' => 0x633D30 ,
'HKS Colors -- HKS 82K 060%  K 50%' => 0x66433B ,
'HKS Colors -- HKS 83K 060%  K 50%' => 0x46312E ,
'HKS Colors -- HKS 84K 060%  K 50%' => 0x402E2D ,
'HKS Colors -- HKS 88K 060%  K 50%' => 0x6A6A6D ,
'HKS Colors -- HKS 89K 060%  K 50%' => 0x53524C ,
'HKS Colors -- HKS 90K 060%  K 50%' => 0x3A3536 ,
'HKS Colors -- HKS 91K 060%  K 50%' => 0x5A5C5B ,
'HKS Colors -- HKS 92K 060%  K 50%' => 0x474A49 ,
'HKS Colors -- HKS 93K 060%  K 50%' => 0x35393B ,
'HKS Colors -- HKS 95K 060%  K 50%' => 0x4E4E4C ,
'HKS Colors -- HKS 96K 060%  K 50%' => 0x535351 ,
'HKS Colors -- HKS 97K 060%  K 50%' => 0x383936 ,
'HKS Colors -- HKS 01K 070%  K 50%' => 0x757247 ,
'HKS Colors -- HKS 02K 070%  K 50%' => 0x737024 ,
'HKS Colors -- HKS 03K 070%  K 50%' => 0x76741A ,
'HKS Colors -- HKS 04K 070%  K 50%' => 0x6A5F0F ,
'HKS Colors -- HKS 05K 070%  K 50%' => 0x75631C ,
'HKS Colors -- HKS 06K 070%  K 50%' => 0x6B4618 ,
'HKS Colors -- HKS 07K 070%  K 50%' => 0x653216 ,
'HKS Colors -- HKS 08K 070%  K 50%' => 0x64311D ,
'HKS Colors -- HKS 10K 070%  K 50%' => 0x712E25 ,
'HKS Colors -- HKS 11K 070%  K 50%' => 0x724F45 ,
'HKS Colors -- HKS 12K 070%  K 50%' => 0x5F2321 ,
'HKS Colors -- HKS 13K 070%  K 50%' => 0x66141E ,
'HKS Colors -- HKS 14K 070%  K 50%' => 0x572222 ,
'HKS Colors -- HKS 15K 070%  K 50%' => 0x511D27 ,
'HKS Colors -- HKS 16K 070%  K 50%' => 0x4A1B26 ,
'HKS Colors -- HKS 17K 070%  K 50%' => 0x4B1A2B ,
'HKS Colors -- HKS 18K 070%  K 50%' => 0x40182A ,
'HKS Colors -- HKS 21K 070%  K 50%' => 0x643E4A ,
'HKS Colors -- HKS 22K 070%  K 50%' => 0x712830 ,
'HKS Colors -- HKS 23K 070%  K 50%' => 0x5E2031 ,
'HKS Colors -- HKS 24K 070%  K 50%' => 0x581E35 ,
'HKS Colors -- HKS 25K 070%  K 50%' => 0x5D1D3D ,
'HKS Colors -- HKS 26K 070%  K 50%' => 0x4E1638 ,
'HKS Colors -- HKS 27K 070%  K 50%' => 0x5C1A46 ,
'HKS Colors -- HKS 28K 070%  K 50%' => 0x47192F ,
'HKS Colors -- HKS 29K 070%  K 50%' => 0x452446 ,
'HKS Colors -- HKS 31K 070%  K 50%' => 0x561C43 ,
'HKS Colors -- HKS 32K 070%  K 50%' => 0x580F3C ,
'HKS Colors -- HKS 33K 070%  K 50%' => 0x491D53 ,
'HKS Colors -- HKS 34K 070%  K 50%' => 0x402753 ,
'HKS Colors -- HKS 35K 070%  K 50%' => 0x302651 ,
'HKS Colors -- HKS 36K 070%  K 50%' => 0x362052 ,
'HKS Colors -- HKS 37K 070%  K 50%' => 0x332741 ,
'HKS Colors -- HKS 38K 070%  K 50%' => 0x222A39 ,
'HKS Colors -- HKS 39K 070%  K 50%' => 0x233458 ,
'HKS Colors -- HKS 40K 070%  K 50%' => 0x274557 ,
'HKS Colors -- HKS 41K 070%  K 50%' => 0x242D3C ,
'HKS Colors -- HKS 42K 070%  K 50%' => 0x25274E ,
'HKS Colors -- HKS 43K 070%  K 50%' => 0x1C295A ,
'HKS Colors -- HKS 44K 070%  K 50%' => 0x1B3252 ,
'HKS Colors -- HKS 45K 070%  K 50%' => 0x33314F ,
'HKS Colors -- HKS 46K 070%  K 50%' => 0x2B465B ,
'HKS Colors -- HKS 47K 070%  K 50%' => 0x12425B ,
'HKS Colors -- HKS 48K 070%  K 50%' => 0x114758 ,
'HKS Colors -- HKS 49K 070%  K 50%' => 0x0F3D52 ,
'HKS Colors -- HKS 50K 070%  K 50%' => 0x335661 ,
'HKS Colors -- HKS 51K 070%  K 50%' => 0x234D4F ,
'HKS Colors -- HKS 52K 070%  K 50%' => 0x14423A ,
'HKS Colors -- HKS 53K 070%  K 50%' => 0x145241 ,
'HKS Colors -- HKS 54K 070%  K 50%' => 0x09422A ,
'HKS Colors -- HKS 55K 070%  K 50%' => 0x113C2E ,
'HKS Colors -- HKS 56K 070%  K 50%' => 0x1C403A ,
'HKS Colors -- HKS 57K 070%  K 50%' => 0x114526 ,
'HKS Colors -- HKS 58K 070%  K 50%' => 0x243825 ,
'HKS Colors -- HKS 59K 070%  K 50%' => 0x0E3C3C ,
'HKS Colors -- HKS 60K 070%  K 50%' => 0x315526 ,
'HKS Colors -- HKS 61K 070%  K 50%' => 0x223321 ,
'HKS Colors -- HKS 62K 070%  K 50%' => 0x383B1D ,
'HKS Colors -- HKS 63K 070%  K 50%' => 0x2B4321 ,
'HKS Colors -- HKS 64K 070%  K 50%' => 0x21471C ,
'HKS Colors -- HKS 65K 070%  K 50%' => 0x315E1C ,
'HKS Colors -- HKS 66K 070%  K 50%' => 0x3C5418 ,
'HKS Colors -- HKS 67K 070%  K 50%' => 0x4A6820 ,
'HKS Colors -- HKS 68K 070%  K 50%' => 0x5B5726 ,
'HKS Colors -- HKS 69K 070%  K 50%' => 0x656727 ,
'HKS Colors -- HKS 71K 070%  K 50%' => 0x564423 ,
'HKS Colors -- HKS 72K 070%  K 50%' => 0x533C19 ,
'HKS Colors -- HKS 73K 070%  K 50%' => 0x554428 ,
'HKS Colors -- HKS 74K 070%  K 50%' => 0x453624 ,
'HKS Colors -- HKS 75K 070%  K 50%' => 0x464029 ,
'HKS Colors -- HKS 76K 070%  K 50%' => 0x2D241C ,
'HKS Colors -- HKS 77K 070%  K 50%' => 0x382A23 ,
'HKS Colors -- HKS 78K 070%  K 50%' => 0x472D27 ,
'HKS Colors -- HKS 81K 070%  K 50%' => 0x5D3425 ,
'HKS Colors -- HKS 82K 070%  K 50%' => 0x5E382E ,
'HKS Colors -- HKS 83K 070%  K 50%' => 0x402522 ,
'HKS Colors -- HKS 84K 070%  K 50%' => 0x352221 ,
'HKS Colors -- HKS 88K 070%  K 50%' => 0x565656 ,
'HKS Colors -- HKS 89K 070%  K 50%' => 0x4F4D46 ,
'HKS Colors -- HKS 90K 070%  K 50%' => 0x302B2B ,
'HKS Colors -- HKS 91K 070%  K 50%' => 0x525454 ,
'HKS Colors -- HKS 92K 070%  K 50%' => 0x3E4141 ,
'HKS Colors -- HKS 93K 070%  K 50%' => 0x2B3033 ,
'HKS Colors -- HKS 95K 070%  K 50%' => 0x4B4C47 ,
'HKS Colors -- HKS 96K 070%  K 50%' => 0x4C4B4A ,
'HKS Colors -- HKS 97K 070%  K 50%' => 0x2D302D ,
'HKS Colors -- HKS 01K 080%  K 50%' => 0x74703C ,
'HKS Colors -- HKS 02K 080%  K 50%' => 0x726F0F ,
'HKS Colors -- HKS 03K 080%  K 50%' => 0x757100 ,
'HKS Colors -- HKS 04K 080%  K 50%' => 0x6F5F00 ,
'HKS Colors -- HKS 05K 080%  K 50%' => 0x735C03 ,
'HKS Colors -- HKS 06K 080%  K 50%' => 0x6F3E02 ,
'HKS Colors -- HKS 07K 080%  K 50%' => 0x632903 ,
'HKS Colors -- HKS 08K 080%  K 50%' => 0x632812 ,
'HKS Colors -- HKS 10K 080%  K 50%' => 0x6D2016 ,
'HKS Colors -- HKS 11K 080%  K 50%' => 0x71473A ,
'HKS Colors -- HKS 12K 080%  K 50%' => 0x5D1814 ,
'HKS Colors -- HKS 13K 080%  K 50%' => 0x640B16 ,
'HKS Colors -- HKS 14K 080%  K 50%' => 0x531718 ,
'HKS Colors -- HKS 15K 080%  K 50%' => 0x4B111C ,
'HKS Colors -- HKS 16K 080%  K 50%' => 0x43111C ,
'HKS Colors -- HKS 17K 080%  K 50%' => 0x460F24 ,
'HKS Colors -- HKS 18K 080%  K 50%' => 0x360B20 ,
'HKS Colors -- HKS 21K 080%  K 50%' => 0x5F3643 ,
'HKS Colors -- HKS 22K 080%  K 50%' => 0x6E1A24 ,
'HKS Colors -- HKS 23K 080%  K 50%' => 0x571426 ,
'HKS Colors -- HKS 24K 080%  K 50%' => 0x55132E ,
'HKS Colors -- HKS 25K 080%  K 50%' => 0x540D32 ,
'HKS Colors -- HKS 26K 080%  K 50%' => 0x490A32 ,
'HKS Colors -- HKS 27K 080%  K 50%' => 0x55093E ,
'HKS Colors -- HKS 28K 080%  K 50%' => 0x410B26 ,
'HKS Colors -- HKS 29K 080%  K 50%' => 0x3A183B ,
'HKS Colors -- HKS 31K 080%  K 50%' => 0x4F0E3A ,
'HKS Colors -- HKS 32K 080%  K 50%' => 0x550032 ,
'HKS Colors -- HKS 33K 080%  K 50%' => 0x420E4D ,
'HKS Colors -- HKS 34K 080%  K 50%' => 0x34174A ,
'HKS Colors -- HKS 35K 080%  K 50%' => 0x231945 ,
'HKS Colors -- HKS 36K 080%  K 50%' => 0x2D1147 ,
'HKS Colors -- HKS 37K 080%  K 50%' => 0x251834 ,
'HKS Colors -- HKS 38K 080%  K 50%' => 0x101B2B ,
'HKS Colors -- HKS 39K 080%  K 50%' => 0x162951 ,
'HKS Colors -- HKS 40K 080%  K 50%' => 0x183D52 ,
'HKS Colors -- HKS 41K 080%  K 50%' => 0x182132 ,
'HKS Colors -- HKS 42K 080%  K 50%' => 0x181A45 ,
'HKS Colors -- HKS 43K 080%  K 50%' => 0x121E57 ,
'HKS Colors -- HKS 44K 080%  K 50%' => 0x0F2645 ,
'HKS Colors -- HKS 45K 080%  K 50%' => 0x282645 ,
'HKS Colors -- HKS 46K 080%  K 50%' => 0x1E3E55 ,
'HKS Colors -- HKS 47K 080%  K 50%' => 0x003C57 ,
'HKS Colors -- HKS 48K 080%  K 50%' => 0x004154 ,
'HKS Colors -- HKS 49K 080%  K 50%' => 0x003951 ,
'HKS Colors -- HKS 50K 080%  K 50%' => 0x274E5B ,
'HKS Colors -- HKS 51K 080%  K 50%' => 0x134549 ,
'HKS Colors -- HKS 52K 080%  K 50%' => 0x00382F ,
'HKS Colors -- HKS 53K 080%  K 50%' => 0x004A38 ,
'HKS Colors -- HKS 54K 080%  K 50%' => 0x003A23 ,
'HKS Colors -- HKS 55K 080%  K 50%' => 0x003223 ,
'HKS Colors -- HKS 56K 080%  K 50%' => 0x09322A ,
'HKS Colors -- HKS 57K 080%  K 50%' => 0x003E1B ,
'HKS Colors -- HKS 58K 080%  K 50%' => 0x162B17 ,
'HKS Colors -- HKS 59K 080%  K 50%' => 0x003332 ,
'HKS Colors -- HKS 60K 080%  K 50%' => 0x234B14 ,
'HKS Colors -- HKS 61K 080%  K 50%' => 0x162713 ,
'HKS Colors -- HKS 62K 080%  K 50%' => 0x2B2F0E ,
'HKS Colors -- HKS 63K 080%  K 50%' => 0x1E3913 ,
'HKS Colors -- HKS 64K 080%  K 50%' => 0x174311 ,
'HKS Colors -- HKS 65K 080%  K 50%' => 0x24580B ,
'HKS Colors -- HKS 66K 080%  K 50%' => 0x34510B ,
'HKS Colors -- HKS 67K 080%  K 50%' => 0x3B6307 ,
'HKS Colors -- HKS 68K 080%  K 50%' => 0x555318 ,
'HKS Colors -- HKS 69K 080%  K 50%' => 0x5F6014 ,
'HKS Colors -- HKS 71K 080%  K 50%' => 0x543E17 ,
'HKS Colors -- HKS 72K 080%  K 50%' => 0x54380D ,
'HKS Colors -- HKS 73K 080%  K 50%' => 0x523C1B ,
'HKS Colors -- HKS 74K 080%  K 50%' => 0x3D2E18 ,
'HKS Colors -- HKS 75K 080%  K 50%' => 0x3B331A ,
'HKS Colors -- HKS 76K 080%  K 50%' => 0x221A13 ,
'HKS Colors -- HKS 77K 080%  K 50%' => 0x2D1D14 ,
'HKS Colors -- HKS 78K 080%  K 50%' => 0x3E2017 ,
'HKS Colors -- HKS 81K 080%  K 50%' => 0x5A2917 ,
'HKS Colors -- HKS 82K 080%  K 50%' => 0x54291E ,
'HKS Colors -- HKS 83K 080%  K 50%' => 0x361A16 ,
'HKS Colors -- HKS 84K 080%  K 50%' => 0x2E1918 ,
'HKS Colors -- HKS 88K 080%  K 50%' => 0x3D3D3D ,
'HKS Colors -- HKS 89K 080%  K 50%' => 0x4E4B42 ,
'HKS Colors -- HKS 90K 080%  K 50%' => 0x242120 ,
'HKS Colors -- HKS 91K 080%  K 50%' => 0x474C4B ,
'HKS Colors -- HKS 92K 080%  K 50%' => 0x323434 ,
'HKS Colors -- HKS 93K 080%  K 50%' => 0x232629 ,
'HKS Colors -- HKS 95K 080%  K 50%' => 0x444542 ,
'HKS Colors -- HKS 96K 080%  K 50%' => 0x41413C ,
'HKS Colors -- HKS 97K 080%  K 50%' => 0x212422 ,
'HKS Colors -- HKS 01K 090%  K 50%' => 0x6F6A31 ,
'HKS Colors -- HKS 02K 090%  K 50%' => 0x6B6700 ,
'HKS Colors -- HKS 03K 090%  K 50%' => 0x716B00 ,
'HKS Colors -- HKS 04K 090%  K 50%' => 0x6E5B00 ,
'HKS Colors -- HKS 05K 090%  K 50%' => 0x6E5300 ,
'HKS Colors -- HKS 06K 090%  K 50%' => 0x723B00 ,
'HKS Colors -- HKS 07K 090%  K 50%' => 0x602300 ,
'HKS Colors -- HKS 08K 090%  K 50%' => 0x602107 ,
'HKS Colors -- HKS 10K 090%  K 50%' => 0x67160A ,
'HKS Colors -- HKS 11K 090%  K 50%' => 0x6E4031 ,
'HKS Colors -- HKS 12K 090%  K 50%' => 0x550E0E ,
'HKS Colors -- HKS 13K 090%  K 50%' => 0x5B070F ,
'HKS Colors -- HKS 14K 090%  K 50%' => 0x4B0E0F ,
'HKS Colors -- HKS 15K 090%  K 50%' => 0x440813 ,
'HKS Colors -- HKS 16K 090%  K 50%' => 0x390A12 ,
'HKS Colors -- HKS 17K 090%  K 50%' => 0x3B0617 ,
'HKS Colors -- HKS 18K 090%  K 50%' => 0x2A0713 ,
'HKS Colors -- HKS 21K 090%  K 50%' => 0x562935 ,
'HKS Colors -- HKS 22K 090%  K 50%' => 0x661018 ,
'HKS Colors -- HKS 23K 090%  K 50%' => 0x4D0A1B ,
'HKS Colors -- HKS 24K 090%  K 50%' => 0x450D21 ,
'HKS Colors -- HKS 25K 090%  K 50%' => 0x4A0325 ,
'HKS Colors -- HKS 26K 090%  K 50%' => 0x3A0224 ,
'HKS Colors -- HKS 27K 090%  K 50%' => 0x4A0032 ,
'HKS Colors -- HKS 28K 090%  K 50%' => 0x34061A ,
'HKS Colors -- HKS 29K 090%  K 50%' => 0x300B2E ,
'HKS Colors -- HKS 31K 090%  K 50%' => 0x40022A ,
'HKS Colors -- HKS 32K 090%  K 50%' => 0x4B0027 ,
'HKS Colors -- HKS 33K 090%  K 50%' => 0x380041 ,
'HKS Colors -- HKS 34K 090%  K 50%' => 0x2A0B40 ,
'HKS Colors -- HKS 35K 090%  K 50%' => 0x1C103C ,
'HKS Colors -- HKS 36K 090%  K 50%' => 0x250A40 ,
'HKS Colors -- HKS 37K 090%  K 50%' => 0x1A0B28 ,
'HKS Colors -- HKS 38K 090%  K 50%' => 0x0A1424 ,
'HKS Colors -- HKS 39K 090%  K 50%' => 0x0F2247 ,
'HKS Colors -- HKS 40K 090%  K 50%' => 0x093145 ,
'HKS Colors -- HKS 41K 090%  K 50%' => 0x0B1729 ,
'HKS Colors -- HKS 42K 090%  K 50%' => 0x0D103A ,
'HKS Colors -- HKS 43K 090%  K 50%' => 0x091652 ,
'HKS Colors -- HKS 44K 090%  K 50%' => 0x061D3C ,
'HKS Colors -- HKS 45K 090%  K 50%' => 0x1C1B3B ,
'HKS Colors -- HKS 46K 090%  K 50%' => 0x13364D ,
'HKS Colors -- HKS 47K 090%  K 50%' => 0x00324C ,
'HKS Colors -- HKS 48K 090%  K 50%' => 0x00384B ,
'HKS Colors -- HKS 49K 090%  K 50%' => 0x002F45 ,
'HKS Colors -- HKS 50K 090%  K 50%' => 0x1A434F ,
'HKS Colors -- HKS 51K 090%  K 50%' => 0x053B3D ,
'HKS Colors -- HKS 52K 090%  K 50%' => 0x003229 ,
'HKS Colors -- HKS 53K 090%  K 50%' => 0x00402F ,
'HKS Colors -- HKS 54K 090%  K 50%' => 0x00321B ,
'HKS Colors -- HKS 55K 090%  K 50%' => 0x002819 ,
'HKS Colors -- HKS 56K 090%  K 50%' => 0x00261E ,
'HKS Colors -- HKS 57K 090%  K 50%' => 0x003414 ,
'HKS Colors -- HKS 58K 090%  K 50%' => 0x102613 ,
'HKS Colors -- HKS 59K 090%  K 50%' => 0x002726 ,
'HKS Colors -- HKS 60K 090%  K 50%' => 0x144106 ,
'HKS Colors -- HKS 61K 090%  K 50%' => 0x0F210F ,
'HKS Colors -- HKS 62K 090%  K 50%' => 0x242707 ,
'HKS Colors -- HKS 63K 090%  K 50%' => 0x18310D ,
'HKS Colors -- HKS 64K 090%  K 50%' => 0x0D3A0B ,
'HKS Colors -- HKS 65K 090%  K 50%' => 0x185100 ,
'HKS Colors -- HKS 66K 090%  K 50%' => 0x2A4700 ,
'HKS Colors -- HKS 67K 090%  K 50%' => 0x305700 ,
'HKS Colors -- HKS 68K 090%  K 50%' => 0x4D470A ,
'HKS Colors -- HKS 69K 090%  K 50%' => 0x545305 ,
'HKS Colors -- HKS 71K 090%  K 50%' => 0x513910 ,
'HKS Colors -- HKS 72K 090%  K 50%' => 0x523205 ,
'HKS Colors -- HKS 73K 090%  K 50%' => 0x4D3310 ,
'HKS Colors -- HKS 74K 090%  K 50%' => 0x35250E ,
'HKS Colors -- HKS 75K 090%  K 50%' => 0x342B11 ,
'HKS Colors -- HKS 76K 090%  K 50%' => 0x1A130D ,
'HKS Colors -- HKS 77K 090%  K 50%' => 0x24140D ,
'HKS Colors -- HKS 78K 090%  K 50%' => 0x341710 ,
'HKS Colors -- HKS 81K 090%  K 50%' => 0x552210 ,
'HKS Colors -- HKS 82K 090%  K 50%' => 0x4C1D12 ,
'HKS Colors -- HKS 83K 090%  K 50%' => 0x2F1410 ,
'HKS Colors -- HKS 84K 090%  K 50%' => 0x271312 ,
'HKS Colors -- HKS 88K 090%  K 50%' => 0x252524 ,
'HKS Colors -- HKS 89K 090%  K 50%' => 0x4A463C ,
'HKS Colors -- HKS 90K 090%  K 50%' => 0x1C1616 ,
'HKS Colors -- HKS 91K 090%  K 50%' => 0x3B403E ,
'HKS Colors -- HKS 92K 090%  K 50%' => 0x2D2F2E ,
'HKS Colors -- HKS 93K 090%  K 50%' => 0x1D2124 ,
'HKS Colors -- HKS 95K 090%  K 50%' => 0x40403A ,
'HKS Colors -- HKS 96K 090%  K 50%' => 0x353432 ,
'HKS Colors -- HKS 97K 090%  K 50%' => 0x181A17 ,
'HKS Colors -- HKS 01K 100%  K 50%' => 0x696428 ,
'HKS Colors -- HKS 02K 100%  K 50%' => 0x666000 ,
'HKS Colors -- HKS 03K 100%  K 50%' => 0x696100 ,
'HKS Colors -- HKS 04K 100%  K 50%' => 0x6D5700 ,
'HKS Colors -- HKS 05K 100%  K 50%' => 0x664B00 ,
'HKS Colors -- HKS 06K 100%  K 50%' => 0x713800 ,
'HKS Colors -- HKS 07K 100%  K 50%' => 0x5C1E00 ,
'HKS Colors -- HKS 08K 100%  K 50%' => 0x5F1B01 ,
'HKS Colors -- HKS 10K 100%  K 50%' => 0x5F1006 ,
'HKS Colors -- HKS 11K 100%  K 50%' => 0x6A3829 ,
'HKS Colors -- HKS 12K 100%  K 50%' => 0x4F0A0A ,
'HKS Colors -- HKS 13K 100%  K 50%' => 0x540509 ,
'HKS Colors -- HKS 14K 100%  K 50%' => 0x43070A ,
'HKS Colors -- HKS 15K 100%  K 50%' => 0x3E060F ,
'HKS Colors -- HKS 16K 100%  K 50%' => 0x30090F ,
'HKS Colors -- HKS 17K 100%  K 50%' => 0x300611 ,
'HKS Colors -- HKS 18K 100%  K 50%' => 0x24060E ,
'HKS Colors -- HKS 21K 100%  K 50%' => 0x4A2029 ,
'HKS Colors -- HKS 22K 100%  K 50%' => 0x5E0A11 ,
'HKS Colors -- HKS 23K 100%  K 50%' => 0x470614 ,
'HKS Colors -- HKS 24K 100%  K 50%' => 0x3D0819 ,
'HKS Colors -- HKS 25K 100%  K 50%' => 0x430220 ,
'HKS Colors -- HKS 26K 100%  K 50%' => 0x33011D ,
'HKS Colors -- HKS 27K 100%  K 50%' => 0x400029 ,
'HKS Colors -- HKS 28K 100%  K 50%' => 0x300313 ,
'HKS Colors -- HKS 29K 100%  K 50%' => 0x260624 ,
'HKS Colors -- HKS 31K 100%  K 50%' => 0x360023 ,
'HKS Colors -- HKS 32K 100%  K 50%' => 0x440021 ,
'HKS Colors -- HKS 33K 100%  K 50%' => 0x300036 ,
'HKS Colors -- HKS 34K 100%  K 50%' => 0x240636 ,
'HKS Colors -- HKS 35K 100%  K 50%' => 0x170B35 ,
'HKS Colors -- HKS 36K 100%  K 50%' => 0x1D0635 ,
'HKS Colors -- HKS 37K 100%  K 50%' => 0x140822 ,
'HKS Colors -- HKS 38K 100%  K 50%' => 0x070F1D ,
'HKS Colors -- HKS 39K 100%  K 50%' => 0x07193E ,
'HKS Colors -- HKS 40K 100%  K 50%' => 0x00293E ,
'HKS Colors -- HKS 41K 100%  K 50%' => 0x081021 ,
'HKS Colors -- HKS 42K 100%  K 50%' => 0x080931 ,
'HKS Colors -- HKS 43K 100%  K 50%' => 0x070F4C ,
'HKS Colors -- HKS 44K 100%  K 50%' => 0x011735 ,
'HKS Colors -- HKS 45K 100%  K 50%' => 0x161434 ,
'HKS Colors -- HKS 46K 100%  K 50%' => 0x0E3249 ,
'HKS Colors -- HKS 47K 100%  K 50%' => 0x002942 ,
'HKS Colors -- HKS 48K 100%  K 50%' => 0x002F3E ,
'HKS Colors -- HKS 49K 100%  K 50%' => 0x00263A ,
'HKS Colors -- HKS 50K 100%  K 50%' => 0x10404C ,
'HKS Colors -- HKS 51K 100%  K 50%' => 0x003234 ,
'HKS Colors -- HKS 52K 100%  K 50%' => 0x002A22 ,
'HKS Colors -- HKS 53K 100%  K 50%' => 0x003526 ,
'HKS Colors -- HKS 54K 100%  K 50%' => 0x002916 ,
'HKS Colors -- HKS 55K 100%  K 50%' => 0x002012 ,
'HKS Colors -- HKS 56K 100%  K 50%' => 0x001D16 ,
'HKS Colors -- HKS 57K 100%  K 50%' => 0x002B10 ,
'HKS Colors -- HKS 58K 100%  K 50%' => 0x0B1E0F ,
'HKS Colors -- HKS 59K 100%  K 50%' => 0x001D1C ,
'HKS Colors -- HKS 60K 100%  K 50%' => 0x0B3905 ,
'HKS Colors -- HKS 61K 100%  K 50%' => 0x091A0B ,
'HKS Colors -- HKS 62K 100%  K 50%' => 0x1B1E05 ,
'HKS Colors -- HKS 63K 100%  K 50%' => 0x112908 ,
'HKS Colors -- HKS 64K 100%  K 50%' => 0x063107 ,
'HKS Colors -- HKS 65K 100%  K 50%' => 0x104B00 ,
'HKS Colors -- HKS 66K 100%  K 50%' => 0x244000 ,
'HKS Colors -- HKS 67K 100%  K 50%' => 0x264E00 ,
'HKS Colors -- HKS 68K 100%  K 50%' => 0x443E03 ,
'HKS Colors -- HKS 69K 100%  K 50%' => 0x4A4A00 ,
'HKS Colors -- HKS 71K 100%  K 50%' => 0x4D330A ,
'HKS Colors -- HKS 72K 100%  K 50%' => 0x4E2B00 ,
'HKS Colors -- HKS 73K 100%  K 50%' => 0x452D0A ,
'HKS Colors -- HKS 74K 100%  K 50%' => 0x2F1D08 ,
'HKS Colors -- HKS 75K 100%  K 50%' => 0x2D240B ,
'HKS Colors -- HKS 76K 100%  K 50%' => 0x17100A ,
'HKS Colors -- HKS 77K 100%  K 50%' => 0x1D100A ,
'HKS Colors -- HKS 78K 100%  K 50%' => 0x2D100A ,
'HKS Colors -- HKS 81K 100%  K 50%' => 0x4E1B0B ,
'HKS Colors -- HKS 82K 100%  K 50%' => 0x42140A ,
'HKS Colors -- HKS 83K 100%  K 50%' => 0x2A100D ,
'HKS Colors -- HKS 84K 100%  K 50%' => 0x220F0E ,
'HKS Colors -- HKS 88K 100%  K 50%' => 0x0F0F0D ,
'HKS Colors -- HKS 89K 100%  K 50%' => 0x444136 ,
'HKS Colors -- HKS 90K 100%  K 50%' => 0x16100F ,
'HKS Colors -- HKS 91K 100%  K 50%' => 0x333634 ,
'HKS Colors -- HKS 92K 100%  K 50%' => 0x262827 ,
'HKS Colors -- HKS 93K 100%  K 50%' => 0x191C20 ,
'HKS Colors -- HKS 95K 100%  K 50%' => 0x3C3D38 ,
'HKS Colors -- HKS 96K 100%  K 50%' => 0x2E2D2A ,
'HKS Colors -- HKS 97K 100%  K 50%' => 0x111412 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 871 CVU' => 0x1A027A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 872 CVU' => 0x190579 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 873 CVU' => 0x18067D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 874 CVU' => 0x180978 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 875 CVU' => 0x170C76 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 876 CVU' => 0x160F78 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 877 CVU' => 0xFFFF92 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8001 CVU' => 0x02008C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8002 CVU' => 0x070288 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8003 CVU' => 0x0A0485 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8004 CVU' => 0x0F0585 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8005 CVU' => 0x13087A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8020 CVU' => 0x08078E ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8021 CVU' => 0x0D0B84 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8022 CVU' => 0x161487 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8023 CVU' => 0x1C1A84 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8040 CVU' => 0x020492 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8041 CVU' => 0x060888 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8042 CVU' => 0x090D85 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8043 CVU' => 0x0D1281 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8060 CVU' => 0xFF0989 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8061 CVU' => 0x001088 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8062 CVU' => 0x021583 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8063 CVU' => 0x051D80 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8080 CVU' => 0xFB0787 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8081 CVU' => 0xF5177B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8082 CVU' => 0xF31F75 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8083 CVU' => 0xF12772 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8100 CVU' => 0xF70B87 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8101 CVU' => 0xF2147B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8102 CVU' => 0xEF1A71 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8103 CVU' => 0xEB246C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8120 CVU' => 0xFB0492 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8121 CVU' => 0xF50A83 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8122 CVU' => 0xF10F79 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8123 CVU' => 0xEC1571 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8140 CVU' => 0xF30882 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8141 CVU' => 0xEF0B7A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8142 CVU' => 0xE8106D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8143 CVU' => 0xE31462 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8160 CVU' => 0xF7028B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8161 CVU' => 0xF10482 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8162 CVU' => 0xE6096D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8163 CVU' => 0xE30B62 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8180 CVU' => 0xF8FE8A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8181 CVU' => 0xECFE79 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8182 CVU' => 0xE4FF6E ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8183 CVU' => 0xDE0262 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8200 CVU' => 0xF6FA85 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8201 CVU' => 0xF0F683 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8202 CVU' => 0xEBF579 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8203 CVU' => 0xE4F373 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8220 CVU' => 0xF7F68E ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8221 CVU' => 0xF3F486 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8222 CVU' => 0xEFF080 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8223 CVU' => 0xE9EC7A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8240 CVU' => 0xFCFC8D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8241 CVU' => 0xF6F388 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8242 CVU' => 0xF3EF82 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8243 CVU' => 0xF0EB7B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8260 CVU' => 0xFAF492 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8261 CVU' => 0xF8F18F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8262 CVU' => 0xF6EC86 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8263 CVU' => 0xF4E683 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8280 CVU' => 0xFEF6A1 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8281 CVU' => 0xFEF295 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8282 CVU' => 0xFEEC90 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8283 CVU' => 0xFEE58C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8300 CVU' => 0x03F796 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8301 CVU' => 0x06F296 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8302 CVU' => 0x09EC91 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8303 CVU' => 0x0CE58B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8320 CVU' => 0x05FC94 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8321 CVU' => 0x0EF493 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8322 CVU' => 0x14EF92 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8323 CVU' => 0x1AE990 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8340 CVU' => 0x0EFA96 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8341 CVU' => 0x15F896 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8342 CVU' => 0x1CF596 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8343 CVU' => 0x26F09D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8360 CVU' => 0x10FC92 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8361 CVU' => 0x19FB96 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8362 CVU' => 0x21FB98 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8363 CVU' => 0x2BFA9A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8380 CVU' => 0x08FF96 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8381 CVU' => 0x10FF98 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8382 CVU' => 0x160095 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8383 CVU' => 0x1E0293 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8400 CVU' => 0x00008D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8401 CVU' => 0x010083 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8402 CVU' => 0x020179 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8403 CVU' => 0x03016B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8420 CVU' => 0x020290 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8421 CVU' => 0x010382 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8422 CVU' => 0x020478 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8423 CVU' => 0x02056C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8440 CVU' => 0x030A8D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8441 CVU' => 0x050F8B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8442 CVU' => 0x081582 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8443 CVU' => 0x0D1E80 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8460 CVU' => 0xFD0489 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8461 CVU' => 0xFC077D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8462 CVU' => 0xFB0B78 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8463 CVU' => 0xFB0D6B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8480 CVU' => 0xF0FA66 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8481 CVU' => 0xF3FF65 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8482 CVU' => 0xEFFA52 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8483 CVU' => 0xE8FE43 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8500 CVU' => 0x00F97F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8501 CVU' => 0x03F46F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8502 CVU' => 0xFAF863 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8503 CVU' => 0xFAFE3F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8520 CVU' => 0x0CFE77 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8521 CVU' => 0x0D0151 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8522 CVU' => 0x09FF47 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8523 CVU' => 0x05FC3C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8540 CVU' => 0x0A1C59 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8541 CVU' => 0x0B1151 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8542 CVU' => 0x0D1544 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8543 CVU' => 0x011441 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8560 CVU' => 0x12125C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8561 CVU' => 0x0F1354 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8562 CVU' => 0x0C154B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8563 CVU' => 0x10134C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8580 CVU' => 0x1E0E72 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8581 CVU' => 0x1A0E64 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8582 CVU' => 0x1A0F5C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8583 CVU' => 0x190F4D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8600 CVU' => 0x01025D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8601 CVU' => 0x07054A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8602 CVU' => 0x04043D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8603 CVU' => 0xFF0334 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8620 CVU' => 0x140862 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8621 CVU' => 0x100755 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8622 CVU' => 0x0D064B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8623 CVU' => 0x09043F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8640 CVU' => 0x2A0983 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8641 CVU' => 0x34088C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8642 CVU' => 0x3C0798 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8643 CVU' => 0x430899 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8660 CVU' => 0x26047D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8661 CVU' => 0x32FE85 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8662 CVU' => 0x31FB82 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8663 CVU' => 0x37F48A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8680 CVU' => 0x1EFD75 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8681 CVU' => 0x24F87C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8682 CVU' => 0x28EE80 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8683 CVU' => 0x2DE582 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8700 CVU' => 0x16F978 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8701 CVU' => 0x1BF373 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8702 CVU' => 0x1CEA75 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8703 CVU' => 0x1EE076 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8720 CVU' => 0x0BF26A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8721 CVU' => 0x0FEF6F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8722 CVU' => 0x0BE870 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8723 CVU' => 0x0EDF73 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8740 CVU' => 0x05F361 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8741 CVU' => 0x03E66E ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8742 CVU' => 0x00E86A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8743 CVU' => 0xFBE363 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8760 CVU' => 0xFDEE5F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8761 CVU' => 0xF5EA5A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8762 CVU' => 0xF6F35C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8763 CVU' => 0xEEF351 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8780 CVU' => 0xF30844 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8781 CVU' => 0xF50542 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8782 CVU' => 0xE50B3B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8783 CVU' => 0xE5073D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8800 CVU' => 0xF3124A ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8801 CVU' => 0xF10F49 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8802 CVU' => 0xE7123F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8803 CVU' => 0xE51846 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8820 CVU' => 0x061E5C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8821 CVU' => 0xFC2757 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8822 CVU' => 0xF7194F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8823 CVU' => 0xED1D44 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8840 CVU' => 0x0A215D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8841 CVU' => 0x032A5B ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8842 CVU' => 0xFD3257 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8843 CVU' => 0xF62E52 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8860 CVU' => 0x132369 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8861 CVU' => 0x0B2667 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8862 CVU' => 0x0C2D60 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8863 CVU' => 0x083764 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8880 CVU' => 0x101E6D ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8881 CVU' => 0x092972 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8882 CVU' => 0x092F67 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8883 CVU' => 0x173161 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8900 CVU' => 0x1D1E6F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8901 CVU' => 0x202774 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8902 CVU' => 0x1A2775 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8903 CVU' => 0x1C3079 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8920 CVU' => 0x1B176F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8921 CVU' => 0x292678 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8922 CVU' => 0x362A7E ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8923 CVU' => 0x2E2D76 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8940 CVU' => 0x221473 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8941 CVU' => 0x2A1A77 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8942 CVU' => 0x33217F ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8943 CVU' => 0x3C2787 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8960 CVU' => 0x2A0C82 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8961 CVU' => 0x2D157C ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8962 CVU' => 0x411692 ,
'PANTONE Metallic Colors - Unvarnished -- PANTONE 8963 CVU' => 0x3E2089 ,
'SpectraMaster Colors -- BS001' => 0xF9F5E4 ,
'SpectraMaster Colors -- BS002' => 0xF6EBD8 ,
'SpectraMaster Colors -- BS003' => 0xF4E3CC ,
'SpectraMaster Colors -- BS004' => 0xF2DCBF ,
'SpectraMaster Colors -- BS005' => 0xFAF3D5 ,
'SpectraMaster Colors -- BS006' => 0xF9F0CA ,
'SpectraMaster Colors -- BS007' => 0xF8F0C0 ,
'SpectraMaster Colors -- BS008' => 0xF5E6C0 ,
'SpectraMaster Colors -- BS009' => 0xEFD8B3 ,
'SpectraMaster Colors -- BS010' => 0xEBD5A6 ,
'SpectraMaster Colors -- BS011' => 0xE8D399 ,
'SpectraMaster Colors -- BS012' => 0xE7D28D ,
'SpectraMaster Colors -- BS013' => 0xF1DDB3 ,
'SpectraMaster Colors -- BS014' => 0xEEDCA7 ,
'SpectraMaster Colors -- BS015' => 0xEDDD9A ,
'SpectraMaster Colors -- BS016' => 0xECDD8E ,
'SpectraMaster Colors -- BS017' => 0xF3E5B3 ,
'SpectraMaster Colors -- BS018' => 0xF1E5A6 ,
'SpectraMaster Colors -- BS019' => 0xF1E59A ,
'SpectraMaster Colors -- BS020' => 0xF1E58D ,
'SpectraMaster Colors -- BS021' => 0xF7EEB4 ,
'SpectraMaster Colors -- BS022' => 0xF5EDA6 ,
'SpectraMaster Colors -- BS023' => 0xF5ED9A ,
'SpectraMaster Colors -- BS024' => 0xF5ED8C ,
'SpectraMaster Colors -- BS025' => 0xF2E681 ,
'SpectraMaster Colors -- BS026' => 0xF2E673 ,
'SpectraMaster Colors -- BS027' => 0xF2E766 ,
'SpectraMaster Colors -- BS028' => 0xF2E759 ,
'SpectraMaster Colors -- BS029' => 0xF6EE7F ,
'SpectraMaster Colors -- BS030' => 0xF7EF72 ,
'SpectraMaster Colors -- BS031' => 0xF7EF65 ,
'SpectraMaster Colors -- BS032' => 0xF6F058 ,
'SpectraMaster Colors -- BS033' => 0xE5D181 ,
'SpectraMaster Colors -- BS034' => 0xE5D174 ,
'SpectraMaster Colors -- BS035' => 0xE5D167 ,
'SpectraMaster Colors -- BS036' => 0xE6D35B ,
'SpectraMaster Colors -- BS037' => 0xECDD81 ,
'SpectraMaster Colors -- BS038' => 0xECDD74 ,
'SpectraMaster Colors -- BS039' => 0xECDD68 ,
'SpectraMaster Colors -- BS040' => 0xECDD5A ,
'SpectraMaster Colors -- BS041' => 0xE8D54F ,
'SpectraMaster Colors -- BS042' => 0xEAD842 ,
'SpectraMaster Colors -- BS043' => 0xEDDD35 ,
'SpectraMaster Colors -- BS044' => 0xF2E534 ,
'SpectraMaster Colors -- BS045' => 0xF2E74C ,
'SpectraMaster Colors -- BS046' => 0xF2E640 ,
'SpectraMaster Colors -- BS047' => 0xF7EE33 ,
'SpectraMaster Colors -- BS048' => 0xF4E91B ,
'SpectraMaster Colors -- BS049' => 0xE5D84F ,
'SpectraMaster Colors -- BS050' => 0xE8DB42 ,
'SpectraMaster Colors -- BS051' => 0xEBDF35 ,
'SpectraMaster Colors -- BS052' => 0xF2EB1B ,
'SpectraMaster Colors -- BS053' => 0xF0E84C ,
'SpectraMaster Colors -- BS054' => 0xF0E740 ,
'SpectraMaster Colors -- BS055' => 0xF5EF33 ,
'SpectraMaster Colors -- BS056' => 0xF9F518 ,
'SpectraMaster Colors -- BS057' => 0xE2D581 ,
'SpectraMaster Colors -- BS058' => 0xE1D574 ,
'SpectraMaster Colors -- BS059' => 0xE2D668 ,
'SpectraMaster Colors -- BS060' => 0xE3D65B ,
'SpectraMaster Colors -- BS061' => 0xE9E081 ,
'SpectraMaster Colors -- BS062' => 0xE9E075 ,
'SpectraMaster Colors -- BS063' => 0xE9DF68 ,
'SpectraMaster Colors -- BS064' => 0xE9DF5B ,
'SpectraMaster Colors -- BS065' => 0xEDDAB4 ,
'SpectraMaster Colors -- BS066' => 0xE9D8A6 ,
'SpectraMaster Colors -- BS067' => 0xE5D79A ,
'SpectraMaster Colors -- BS068' => 0xE3D68D ,
'SpectraMaster Colors -- BS069' => 0xF2E7B4 ,
'SpectraMaster Colors -- BS070' => 0xEBDEA7 ,
'SpectraMaster Colors -- BS071' => 0xEADF9A ,
'SpectraMaster Colors -- BS072' => 0xE9E08E ,
'SpectraMaster Colors -- BS073' => 0xF7F6E3 ,
'SpectraMaster Colors -- BS074' => 0xF5EDD8 ,
'SpectraMaster Colors -- BS075' => 0xF3E5CD ,
'SpectraMaster Colors -- BS076' => 0xF0DFC0 ,
'SpectraMaster Colors -- BS077' => 0xFDFCE2 ,
'SpectraMaster Colors -- BS078' => 0xF9F4D5 ,
'SpectraMaster Colors -- BS079' => 0xF8F1CB ,
'SpectraMaster Colors -- BS080' => 0xF3E8C0 ,
'SpectraMaster Colors -- BS081' => 0xF3EFD8 ,
'SpectraMaster Colors -- BS082' => 0xF1E8CD ,
'SpectraMaster Colors -- BS083' => 0xF1E9C0 ,
'SpectraMaster Colors -- BS084' => 0xEEE1C1 ,
'SpectraMaster Colors -- BS085' => 0xF7F8E4 ,
'SpectraMaster Colors -- BS086' => 0xF7F4D6 ,
'SpectraMaster Colors -- BS087' => 0xF6F2CB ,
'SpectraMaster Colors -- BS088' => 0xF6F1C0 ,
'SpectraMaster Colors -- BS089' => 0xEADEB4 ,
'SpectraMaster Colors -- BS090' => 0xE6DBA7 ,
'SpectraMaster Colors -- BS091' => 0xE2DA99 ,
'SpectraMaster Colors -- BS092' => 0xE0D88D ,
'SpectraMaster Colors -- BS093' => 0xEBE1B2 ,
'SpectraMaster Colors -- BS094' => 0xE8E0A7 ,
'SpectraMaster Colors -- BS095' => 0xE7E19A ,
'SpectraMaster Colors -- BS096' => 0xE6E18E ,
'SpectraMaster Colors -- BS097' => 0xEFE8B2 ,
'SpectraMaster Colors -- BS098' => 0xEEE8A6 ,
'SpectraMaster Colors -- BS099' => 0xEDE99A ,
'SpectraMaster Colors -- BS100' => 0xECE98E ,
'SpectraMaster Colors -- BS101' => 0xF4F0B1 ,
'SpectraMaster Colors -- BS102' => 0xF2F0A7 ,
'SpectraMaster Colors -- BS103' => 0xF1EF99 ,
'SpectraMaster Colors -- BS104' => 0xF2F08E ,
'SpectraMaster Colors -- BS105' => 0xEDEA82 ,
'SpectraMaster Colors -- BS106' => 0xEEEA74 ,
'SpectraMaster Colors -- BS107' => 0xEEEA67 ,
'SpectraMaster Colors -- BS108' => 0xEDEA59 ,
'SpectraMaster Colors -- BS109' => 0xF3F181 ,
'SpectraMaster Colors -- BS110' => 0xF4F174 ,
'SpectraMaster Colors -- BS111' => 0xF4F266 ,
'SpectraMaster Colors -- BS112' => 0xF4F259 ,
'SpectraMaster Colors -- BS113' => 0xDFD881 ,
'SpectraMaster Colors -- BS114' => 0xDED873 ,
'SpectraMaster Colors -- BS115' => 0xDFD867 ,
'SpectraMaster Colors -- BS116' => 0xE0D95B ,
'SpectraMaster Colors -- BS117' => 0xE6E282 ,
'SpectraMaster Colors -- BS118' => 0xE6E174 ,
'SpectraMaster Colors -- BS119' => 0xE6E168 ,
'SpectraMaster Colors -- BS120' => 0xE6E15B ,
'SpectraMaster Colors -- BS121' => 0xE3DB4F ,
'SpectraMaster Colors -- BS122' => 0xE6DE42 ,
'SpectraMaster Colors -- BS123' => 0xE9E235 ,
'SpectraMaster Colors -- BS124' => 0xF1EB1C ,
'SpectraMaster Colors -- BS125' => 0xEEEA4C ,
'SpectraMaster Colors -- BS126' => 0xEEE940 ,
'SpectraMaster Colors -- BS127' => 0xF3F13F ,
'SpectraMaster Colors -- BS128' => 0xF4F033 ,
'SpectraMaster Colors -- BS129' => 0xE0DE4F ,
'SpectraMaster Colors -- BS130' => 0xE3E043 ,
'SpectraMaster Colors -- BS131' => 0xE7E435 ,
'SpectraMaster Colors -- BS132' => 0xEFEE1B ,
'SpectraMaster Colors -- BS133' => 0xECEC4B ,
'SpectraMaster Colors -- BS134' => 0xECEB40 ,
'SpectraMaster Colors -- BS135' => 0xF2F133 ,
'SpectraMaster Colors -- BS136' => 0xF7F718 ,
'SpectraMaster Colors -- BS137' => 0xDBDA80 ,
'SpectraMaster Colors -- BS138' => 0xDBDB74 ,
'SpectraMaster Colors -- BS139' => 0xDCDB68 ,
'SpectraMaster Colors -- BS140' => 0xDEDC5C ,
'SpectraMaster Colors -- BS141' => 0xE3E481 ,
'SpectraMaster Colors -- BS142' => 0xE3E475 ,
'SpectraMaster Colors -- BS143' => 0xE4E467 ,
'SpectraMaster Colors -- BS144' => 0xE4E35B ,
'SpectraMaster Colors -- BS145' => 0xE7DFB3 ,
'SpectraMaster Colors -- BS146' => 0xE3DEA6 ,
'SpectraMaster Colors -- BS147' => 0xDFDC99 ,
'SpectraMaster Colors -- BS148' => 0xDCDB8D ,
'SpectraMaster Colors -- BS149' => 0xEEEAB3 ,
'SpectraMaster Colors -- BS150' => 0xE6E3A6 ,
'SpectraMaster Colors -- BS151' => 0xE4E399 ,
'SpectraMaster Colors -- BS152' => 0xE4E48E ,
'SpectraMaster Colors -- BS153' => 0xF5F7E1 ,
'SpectraMaster Colors -- BS154' => 0xF2F1D8 ,
'SpectraMaster Colors -- BS155' => 0xEFEBCC ,
'SpectraMaster Colors -- BS156' => 0xECE4C1 ,
'SpectraMaster Colors -- BS157' => 0xFAFAE0 ,
'SpectraMaster Colors -- BS158' => 0xF6F5D6 ,
'SpectraMaster Colors -- BS159' => 0xF5F3CC ,
'SpectraMaster Colors -- BS160' => 0xEFEBC0 ,
'SpectraMaster Colors -- BS161' => 0xF6F7E1 ,
'SpectraMaster Colors -- BS162' => 0xF4F6D7 ,
'SpectraMaster Colors -- BS163' => 0xECEDCD ,
'SpectraMaster Colors -- BS164' => 0xE9E7C1 ,
'SpectraMaster Colors -- BS165' => 0xF4F6D6 ,
'SpectraMaster Colors -- BS166' => 0xF4F4CC ,
'SpectraMaster Colors -- BS167' => 0xF3F4BD ,
'SpectraMaster Colors -- BS168' => 0xEDECC0 ,
'SpectraMaster Colors -- BS169' => 0xE4E2B3 ,
'SpectraMaster Colors -- BS170' => 0xDFE0A5 ,
'SpectraMaster Colors -- BS171' => 0xDCDF99 ,
'SpectraMaster Colors -- BS172' => 0xDADE8D ,
'SpectraMaster Colors -- BS173' => 0xE7E6B3 ,
'SpectraMaster Colors -- BS174' => 0xE3E5A5 ,
'SpectraMaster Colors -- BS175' => 0xE2E69A ,
'SpectraMaster Colors -- BS176' => 0xE1E68D ,
'SpectraMaster Colors -- BS177' => 0xECECB3 ,
'SpectraMaster Colors -- BS178' => 0xEAECA6 ,
'SpectraMaster Colors -- BS179' => 0xE9EC99 ,
'SpectraMaster Colors -- BS180' => 0xE8ED8E ,
'SpectraMaster Colors -- BS181' => 0xF2F5B3 ,
'SpectraMaster Colors -- BS182' => 0xF1F0A5 ,
'SpectraMaster Colors -- BS183' => 0xEFF39A ,
'SpectraMaster Colors -- BS184' => 0xEFF38D ,
'SpectraMaster Colors -- BS185' => 0xE9ED81 ,
'SpectraMaster Colors -- BS186' => 0xEAED75 ,
'SpectraMaster Colors -- BS187' => 0xEAEE67 ,
'SpectraMaster Colors -- BS188' => 0xEAEE59 ,
'SpectraMaster Colors -- BS189' => 0xF1F481 ,
'SpectraMaster Colors -- BS190' => 0xF2F474 ,
'SpectraMaster Colors -- BS191' => 0xF2F466 ,
'SpectraMaster Colors -- BS192' => 0xF2F459 ,
'SpectraMaster Colors -- BS193' => 0xD8DD81 ,
'SpectraMaster Colors -- BS194' => 0xD8DD74 ,
'SpectraMaster Colors -- BS195' => 0xD9DE67 ,
'SpectraMaster Colors -- BS196' => 0xDBDF5B ,
'SpectraMaster Colors -- BS197' => 0xE1E682 ,
'SpectraMaster Colors -- BS198' => 0xE1E675 ,
'SpectraMaster Colors -- BS199' => 0xE1E667 ,
'SpectraMaster Colors -- BS200' => 0xE1E65A ,
'SpectraMaster Colors -- BS201' => 0xDDE14F ,
'SpectraMaster Colors -- BS202' => 0xE1E342 ,
'SpectraMaster Colors -- BS203' => 0xE4E536 ,
'SpectraMaster Colors -- BS204' => 0xEEEF1B ,
'SpectraMaster Colors -- BS205' => 0xEAED4C ,
'SpectraMaster Colors -- BS206' => 0xEAED40 ,
'SpectraMaster Colors -- BS207' => 0xF1F43E ,
'SpectraMaster Colors -- BS208' => 0xF1F332 ,
'SpectraMaster Colors -- BS209' => 0xDBE44F ,
'SpectraMaster Colors -- BS210' => 0xDEE542 ,
'SpectraMaster Colors -- BS211' => 0xE3E835 ,
'SpectraMaster Colors -- BS212' => 0xE7EC29 ,
'SpectraMaster Colors -- BS213' => 0xE9EF4B ,
'SpectraMaster Colors -- BS214' => 0xE9EF3F ,
'SpectraMaster Colors -- BS215' => 0xF0F432 ,
'SpectraMaster Colors -- BS216' => 0xEDF11B ,
'SpectraMaster Colors -- BS217' => 0xD5E081 ,
'SpectraMaster Colors -- BS218' => 0xD5E074 ,
'SpectraMaster Colors -- BS219' => 0xD6E167 ,
'SpectraMaster Colors -- BS220' => 0xD8E25B ,
'SpectraMaster Colors -- BS221' => 0xDFE981 ,
'SpectraMaster Colors -- BS222' => 0xDEE975 ,
'SpectraMaster Colors -- BS223' => 0xDEE967 ,
'SpectraMaster Colors -- BS224' => 0xDFE95A ,
'SpectraMaster Colors -- BS225' => 0xE1E6B3 ,
'SpectraMaster Colors -- BS226' => 0xDCE3A5 ,
'SpectraMaster Colors -- BS227' => 0xD8E297 ,
'SpectraMaster Colors -- BS228' => 0xD6E18C ,
'SpectraMaster Colors -- BS229' => 0xE6EAB2 ,
'SpectraMaster Colors -- BS230' => 0xE3E9A3 ,
'SpectraMaster Colors -- BS231' => 0xE0E89A ,
'SpectraMaster Colors -- BS232' => 0xDFE88D ,
'SpectraMaster Colors -- BS233' => 0xF1F4D7 ,
'SpectraMaster Colors -- BS234' => 0xE9EFCC ,
'SpectraMaster Colors -- BS235' => 0xEBEFBF ,
'SpectraMaster Colors -- BS236' => 0xE6EAC1 ,
'SpectraMaster Colors -- BS237' => 0xF8F8E4 ,
'SpectraMaster Colors -- BS238' => 0xF6FAD4 ,
'SpectraMaster Colors -- BS239' => 0xF2F7CA ,
'SpectraMaster Colors -- BS240' => 0xF2F6BE ,
'SpectraMaster Colors -- BS241' => 0xEEF6D6 ,
'SpectraMaster Colors -- BS242' => 0xE7F3CA ,
'SpectraMaster Colors -- BS243' => 0xE9F2BF ,
'SpectraMaster Colors -- BS244' => 0xE0EEBE ,
'SpectraMaster Colors -- BS245' => 0xF5FCE1 ,
'SpectraMaster Colors -- BS246' => 0xF7FAD6 ,
'SpectraMaster Colors -- BS247' => 0xF2F8CB ,
'SpectraMaster Colors -- BS248' => 0xF2F8BF ,
'SpectraMaster Colors -- BS249' => 0xDDE9B3 ,
'SpectraMaster Colors -- BS250' => 0xD8E7A5 ,
'SpectraMaster Colors -- BS251' => 0xD5E598 ,
'SpectraMaster Colors -- BS252' => 0xD3E48C ,
'SpectraMaster Colors -- BS253' => 0xE1ECB2 ,
'SpectraMaster Colors -- BS254' => 0xDFEBA5 ,
'SpectraMaster Colors -- BS255' => 0xDDEA97 ,
'SpectraMaster Colors -- BS256' => 0xDDEA8A ,
'SpectraMaster Colors -- BS257' => 0xE9F1B4 ,
'SpectraMaster Colors -- BS258' => 0xE6F0A3 ,
'SpectraMaster Colors -- BS259' => 0xE6F098 ,
'SpectraMaster Colors -- BS260' => 0xE6F08A ,
'SpectraMaster Colors -- BS261' => 0xF1F8B4 ,
'SpectraMaster Colors -- BS262' => 0xEFF7A5 ,
'SpectraMaster Colors -- BS263' => 0xEEF598 ,
'SpectraMaster Colors -- BS264' => 0xEFF58B ,
'SpectraMaster Colors -- BS265' => 0xE7F07F ,
'SpectraMaster Colors -- BS266' => 0xE7F174 ,
'SpectraMaster Colors -- BS267' => 0xE7F267 ,
'SpectraMaster Colors -- BS268' => 0xE7F25A ,
'SpectraMaster Colors -- BS269' => 0xEFF57D ,
'SpectraMaster Colors -- BS270' => 0xEFF671 ,
'SpectraMaster Colors -- BS271' => 0xEFF667 ,
'SpectraMaster Colors -- BS272' => 0xEFF75A ,
'SpectraMaster Colors -- BS273' => 0xD2E480 ,
'SpectraMaster Colors -- BS274' => 0xD2E474 ,
'SpectraMaster Colors -- BS275' => 0xD3E467 ,
'SpectraMaster Colors -- BS276' => 0xD5E65C ,
'SpectraMaster Colors -- BS277' => 0xDDEB7F ,
'SpectraMaster Colors -- BS278' => 0xDDEB74 ,
'SpectraMaster Colors -- BS279' => 0xDCEB67 ,
'SpectraMaster Colors -- BS280' => 0xDDEC5A ,
'SpectraMaster Colors -- BS281' => 0xD8E74F ,
'SpectraMaster Colors -- BS282' => 0xDCE842 ,
'SpectraMaster Colors -- BS283' => 0xE0EB35 ,
'SpectraMaster Colors -- BS284' => 0xEBF21A ,
'SpectraMaster Colors -- BS285' => 0xE7F14B ,
'SpectraMaster Colors -- BS286' => 0xE7F140 ,
'SpectraMaster Colors -- BS287' => 0xEFF73F ,
'SpectraMaster Colors -- BS288' => 0xEFF631 ,
'SpectraMaster Colors -- BS289' => 0xD5EA4F ,
'SpectraMaster Colors -- BS290' => 0xD9EB42 ,
'SpectraMaster Colors -- BS291' => 0xDEEE35 ,
'SpectraMaster Colors -- BS292' => 0xEAF41B ,
'SpectraMaster Colors -- BS293' => 0xE7F358 ,
'SpectraMaster Colors -- BS294' => 0xE7F34B ,
'SpectraMaster Colors -- BS295' => 0xE6F33E ,
'SpectraMaster Colors -- BS296' => 0xE6F332 ,
'SpectraMaster Colors -- BS297' => 0xCFE780 ,
'SpectraMaster Colors -- BS298' => 0xCFE774 ,
'SpectraMaster Colors -- BS299' => 0xD0E866 ,
'SpectraMaster Colors -- BS300' => 0xD2E95A ,
'SpectraMaster Colors -- BS301' => 0xDBEF81 ,
'SpectraMaster Colors -- BS302' => 0xDCEF73 ,
'SpectraMaster Colors -- BS303' => 0xDCEE64 ,
'SpectraMaster Colors -- BS304' => 0xDCEE58 ,
'SpectraMaster Colors -- BS305' => 0xDBEDB2 ,
'SpectraMaster Colors -- BS306' => 0xD7EAA7 ,
'SpectraMaster Colors -- BS307' => 0xD3E99C ,
'SpectraMaster Colors -- BS308' => 0xCFE88F ,
'SpectraMaster Colors -- BS309' => 0xE7F3A9 ,
'SpectraMaster Colors -- BS310' => 0xDDEDA8 ,
'SpectraMaster Colors -- BS311' => 0xDCED9C ,
'SpectraMaster Colors -- BS312' => 0xDCEF90 ,
'SpectraMaster Colors -- BS313' => 0xEEF9D4 ,
'SpectraMaster Colors -- BS314' => 0xE7F6CA ,
'SpectraMaster Colors -- BS315' => 0xE1F2BE ,
'SpectraMaster Colors -- BS316' => 0xE9F5B7 ,
'SpectraMaster Colors -- BS317' => 0xF8FCE4 ,
'SpectraMaster Colors -- BS318' => 0xF5FCD4 ,
'SpectraMaster Colors -- BS319' => 0xF0F9CA ,
'SpectraMaster Colors -- BS320' => 0xF1F9C1 ,
'SpectraMaster Colors -- BS321' => 0xEEFBD5 ,
'SpectraMaster Colors -- BS322' => 0xE9F9CD ,
'SpectraMaster Colors -- BS323' => 0xEAF8C1 ,
'SpectraMaster Colors -- BS324' => 0xE2F6C0 ,
'SpectraMaster Colors -- BS325' => 0xF7FDE3 ,
'SpectraMaster Colors -- BS326' => 0xF6FCD6 ,
'SpectraMaster Colors -- BS327' => 0xF0FCCC ,
'SpectraMaster Colors -- BS328' => 0xF1FCC1 ,
'SpectraMaster Colors -- BS329' => 0xDCF2B5 ,
'SpectraMaster Colors -- BS330' => 0xD6EFA6 ,
'SpectraMaster Colors -- BS331' => 0xD3EE9C ,
'SpectraMaster Colors -- BS332' => 0xCFEE91 ,
'SpectraMaster Colors -- BS333' => 0xE2F4B6 ,
'SpectraMaster Colors -- BS334' => 0xDFF2AA ,
'SpectraMaster Colors -- BS335' => 0xDBF398 ,
'SpectraMaster Colors -- BS336' => 0xDBF28C ,
'SpectraMaster Colors -- BS337' => 0xE7F9B4 ,
'SpectraMaster Colors -- BS338' => 0xE6F7A7 ,
'SpectraMaster Colors -- BS339' => 0xE5F698 ,
'SpectraMaster Colors -- BS340' => 0xE5F68C ,
'SpectraMaster Colors -- BS341' => 0xF0FCB4 ,
'SpectraMaster Colors -- BS342' => 0xEEFBA7 ,
'SpectraMaster Colors -- BS343' => 0xEDF99A ,
'SpectraMaster Colors -- BS344' => 0xEDF88C ,
'SpectraMaster Colors -- BS345' => 0xE5F580 ,
'SpectraMaster Colors -- BS346' => 0xE6F674 ,
'SpectraMaster Colors -- BS347' => 0xE6F667 ,
'SpectraMaster Colors -- BS348' => 0xE6F75C ,
'SpectraMaster Colors -- BS349' => 0xEEF880 ,
'SpectraMaster Colors -- BS350' => 0xEEF974 ,
'SpectraMaster Colors -- BS351' => 0xEEFA67 ,
'SpectraMaster Colors -- BS352' => 0xEEFA5B ,
'SpectraMaster Colors -- BS353' => 0xCCED81 ,
'SpectraMaster Colors -- BS354' => 0xCBEA73 ,
'SpectraMaster Colors -- BS355' => 0xCDEB67 ,
'SpectraMaster Colors -- BS356' => 0xCFEC5A ,
'SpectraMaster Colors -- BS357' => 0xDBF281 ,
'SpectraMaster Colors -- BS358' => 0xDBF276 ,
'SpectraMaster Colors -- BS359' => 0xDBF268 ,
'SpectraMaster Colors -- BS360' => 0xDBF35B ,
'SpectraMaster Colors -- BS361' => 0xD2ED4F ,
'SpectraMaster Colors -- BS362' => 0xD7EF42 ,
'SpectraMaster Colors -- BS363' => 0xDCF035 ,
'SpectraMaster Colors -- BS364' => 0xE9F61A ,
'SpectraMaster Colors -- BS365' => 0xDAF14C ,
'SpectraMaster Colors -- BS366' => 0xE5F640 ,
'SpectraMaster Colors -- BS367' => 0xE5F532 ,
'SpectraMaster Colors -- BS368' => 0xEEF933 ,
'SpectraMaster Colors -- BS369' => 0xCFF14E ,
'SpectraMaster Colors -- BS370' => 0xD4F242 ,
'SpectraMaster Colors -- BS371' => 0xD9F336 ,
'SpectraMaster Colors -- BS372' => 0xE7F819 ,
'SpectraMaster Colors -- BS373' => 0xDAF44B ,
'SpectraMaster Colors -- BS374' => 0xE5F840 ,
'SpectraMaster Colors -- BS375' => 0xE4F832 ,
'SpectraMaster Colors -- BS376' => 0xF4FD19 ,
'SpectraMaster Colors -- BS377' => 0xCBF381 ,
'SpectraMaster Colors -- BS378' => 0xCAF172 ,
'SpectraMaster Colors -- BS379' => 0xCAF065 ,
'SpectraMaster Colors -- BS380' => 0xCCF05B ,
'SpectraMaster Colors -- BS381' => 0xD8F682 ,
'SpectraMaster Colors -- BS382' => 0xD9F674 ,
'SpectraMaster Colors -- BS383' => 0xD9F563 ,
'SpectraMaster Colors -- BS384' => 0xDAF458 ,
'SpectraMaster Colors -- BS385' => 0xDEF7B6 ,
'SpectraMaster Colors -- BS386' => 0xD8F4AA ,
'SpectraMaster Colors -- BS387' => 0xD3F29E ,
'SpectraMaster Colors -- BS388' => 0xCFF390 ,
'SpectraMaster Colors -- BS389' => 0xE7F9B7 ,
'SpectraMaster Colors -- BS390' => 0xE5F8AA ,
'SpectraMaster Colors -- BS391' => 0xDAF59E ,
'SpectraMaster Colors -- BS392' => 0xD9F690 ,
'SpectraMaster Colors -- BS393' => 0xF6FFE1 ,
'SpectraMaster Colors -- BS394' => 0xEFFDD5 ,
'SpectraMaster Colors -- BS395' => 0xE8FBCB ,
'SpectraMaster Colors -- BS396' => 0xE2F9C0 ,
'SpectraMaster Colors -- BS397' => 0xF5FDD5 ,
'SpectraMaster Colors -- BS398' => 0xF6FECA ,
'SpectraMaster Colors -- BS399' => 0xF1FDCB ,
'SpectraMaster Colors -- BS400' => 0xEFFDC0 ,
'SpectraMaster Colors -- BS401' => 0xF600E1 ,
'SpectraMaster Colors -- BS402' => 0xEFFED5 ,
'SpectraMaster Colors -- BS403' => 0xE9FECB ,
'SpectraMaster Colors -- BS404' => 0xE3FCC1 ,
'SpectraMaster Colors -- BS405' => 0xF4FFD4 ,
'SpectraMaster Colors -- BS406' => 0xF1FDCB ,
'SpectraMaster Colors -- BS407' => 0xF000C1 ,
'SpectraMaster Colors -- BS408' => 0xEF00B6 ,
'SpectraMaster Colors -- BS409' => 0xDFFCB7 ,
'SpectraMaster Colors -- BS410' => 0xD9F8AB ,
'SpectraMaster Colors -- BS411' => 0xD3F79D ,
'SpectraMaster Colors -- BS412' => 0xCEF88F ,
'SpectraMaster Colors -- BS413' => 0xE7FCB8 ,
'SpectraMaster Colors -- BS414' => 0xE5FFA8 ,
'SpectraMaster Colors -- BS415' => 0xD9F89E ,
'SpectraMaster Colors -- BS416' => 0xD9F991 ,
'SpectraMaster Colors -- BS417' => 0xCBF882 ,
'SpectraMaster Colors -- BS418' => 0xC9F673 ,
'SpectraMaster Colors -- BS419' => 0xC9F566 ,
'SpectraMaster Colors -- BS420' => 0xC9F55A ,
'SpectraMaster Colors -- BS421' => 0xD9FA82 ,
'SpectraMaster Colors -- BS422' => 0xDAFA77 ,
'SpectraMaster Colors -- BS423' => 0xDAFA6B ,
'SpectraMaster Colors -- BS424' => 0xDAFA5D ,
'SpectraMaster Colors -- BS425' => 0xE5FD9B ,
'SpectraMaster Colors -- BS426' => 0xE4FB8E ,
'SpectraMaster Colors -- BS427' => 0xE5FB82 ,
'SpectraMaster Colors -- BS428' => 0xE5FB75 ,
'SpectraMaster Colors -- BS429' => 0xEDFE9A ,
'SpectraMaster Colors -- BS430' => 0xEDFC8D ,
'SpectraMaster Colors -- BS431' => 0xEEFC81 ,
'SpectraMaster Colors -- BS432' => 0xEEFC74 ,
'SpectraMaster Colors -- BS433' => 0xE5FB69 ,
'SpectraMaster Colors -- BS434' => 0xE5FC5C ,
'SpectraMaster Colors -- BS435' => 0xE4FC4F ,
'SpectraMaster Colors -- BS436' => 0xE3FC42 ,
'SpectraMaster Colors -- BS437' => 0xEDFD68 ,
'SpectraMaster Colors -- BS438' => 0xEDFD5B ,
'SpectraMaster Colors -- BS439' => 0xECFD4D ,
'SpectraMaster Colors -- BS440' => 0xECFD3F ,
'SpectraMaster Colors -- BS441' => 0xCCF64D ,
'SpectraMaster Colors -- BS442' => 0xD1F642 ,
'SpectraMaster Colors -- BS443' => 0xD7F735 ,
'SpectraMaster Colors -- BS444' => 0xE5FA1A ,
'SpectraMaster Colors -- BS445' => 0xD9FA4E ,
'SpectraMaster Colors -- BS446' => 0xD9F940 ,
'SpectraMaster Colors -- BS447' => 0xE4FB34 ,
'SpectraMaster Colors -- BS448' => 0xECFD17 ,
'SpectraMaster Colors -- BS449' => 0xCAFB4E ,
'SpectraMaster Colors -- BS450' => 0xCEFB41 ,
'SpectraMaster Colors -- BS451' => 0xD4FB35 ,
'SpectraMaster Colors -- BS452' => 0xE4FD19 ,
'SpectraMaster Colors -- BS453' => 0xD9FB4D ,
'SpectraMaster Colors -- BS454' => 0xE4FD40 ,
'SpectraMaster Colors -- BS455' => 0xE4FD34 ,
'SpectraMaster Colors -- BS456' => 0xECFF18 ,
'SpectraMaster Colors -- BS457' => 0xCBFD83 ,
'SpectraMaster Colors -- BS458' => 0xC8FC72 ,
'SpectraMaster Colors -- BS459' => 0xC7FB65 ,
'SpectraMaster Colors -- BS460' => 0xC8FA5A ,
'SpectraMaster Colors -- BS461' => 0xD8FD83 ,
'SpectraMaster Colors -- BS462' => 0xD8FC75 ,
'SpectraMaster Colors -- BS463' => 0xD8FC66 ,
'SpectraMaster Colors -- BS464' => 0xD9FB59 ,
'SpectraMaster Colors -- BS465' => 0xDFFEB8 ,
'SpectraMaster Colors -- BS466' => 0xDAFDAC ,
'SpectraMaster Colors -- BS467' => 0xD4FC9D ,
'SpectraMaster Colors -- BS468' => 0xCFFC91 ,
'SpectraMaster Colors -- BS469' => 0xE6FEB7 ,
'SpectraMaster Colors -- BS470' => 0xE6FEAC ,
'SpectraMaster Colors -- BS471' => 0xD9FC9E ,
'SpectraMaster Colors -- BS472' => 0xD8FC90 ,
'SpectraMaster Colors -- BS473' => 0xF700E2 ,
'SpectraMaster Colors -- BS474' => 0xEFFFD5 ,
'SpectraMaster Colors -- BS475' => 0xE9FFCB ,
'SpectraMaster Colors -- BS476' => 0xE4FFC2 ,
'SpectraMaster Colors -- BS477' => 0xF5FFD5 ,
'SpectraMaster Colors -- BS478' => 0xF6FFCB ,
'SpectraMaster Colors -- BS479' => 0xEFFFC1 ,
'SpectraMaster Colors -- BS480' => 0xEFFFB7 ,
'SpectraMaster Colors -- BS481' => 0xF600E0 ,
'SpectraMaster Colors -- BS482' => 0xEF00D5 ,
'SpectraMaster Colors -- BS483' => 0xEA00CB ,
'SpectraMaster Colors -- BS484' => 0xE500C2 ,
'SpectraMaster Colors -- BS485' => 0xF300CC ,
'SpectraMaster Colors -- BS486' => 0xF003C2 ,
'SpectraMaster Colors -- BS487' => 0xEF03B6 ,
'SpectraMaster Colors -- BS488' => 0xEE03A9 ,
'SpectraMaster Colors -- BS489' => 0xDF00B8 ,
'SpectraMaster Colors -- BS490' => 0xDA00AD ,
'SpectraMaster Colors -- BS491' => 0xD4009E ,
'SpectraMaster Colors -- BS492' => 0xCF0090 ,
'SpectraMaster Colors -- BS493' => 0xE700B9 ,
'SpectraMaster Colors -- BS494' => 0xE500AB ,
'SpectraMaster Colors -- BS495' => 0xD9009E ,
'SpectraMaster Colors -- BS496' => 0xD7008E ,
'SpectraMaster Colors -- BS497' => 0xCB0083 ,
'SpectraMaster Colors -- BS498' => 0xC90075 ,
'SpectraMaster Colors -- BS499' => 0xC7FF66 ,
'SpectraMaster Colors -- BS500' => 0xC7FF5A ,
'SpectraMaster Colors -- BS501' => 0xD70084 ,
'SpectraMaster Colors -- BS502' => 0xD70075 ,
'SpectraMaster Colors -- BS503' => 0xD8FF68 ,
'SpectraMaster Colors -- BS504' => 0xD9005E ,
'SpectraMaster Colors -- BS505' => 0xE5029C ,
'SpectraMaster Colors -- BS506' => 0xE4008F ,
'SpectraMaster Colors -- BS507' => 0xE40082 ,
'SpectraMaster Colors -- BS508' => 0xE50076 ,
'SpectraMaster Colors -- BS509' => 0xEE019C ,
'SpectraMaster Colors -- BS510' => 0xED008E ,
'SpectraMaster Colors -- BS511' => 0xEE0081 ,
'SpectraMaster Colors -- BS512' => 0xEE0074 ,
'SpectraMaster Colors -- BS513' => 0xE4005C ,
'SpectraMaster Colors -- BS514' => 0xE3004F ,
'SpectraMaster Colors -- BS515' => 0xE30042 ,
'SpectraMaster Colors -- BS516' => 0xE30035 ,
'SpectraMaster Colors -- BS517' => 0xED005B ,
'SpectraMaster Colors -- BS518' => 0xEC004E ,
'SpectraMaster Colors -- BS519' => 0xEC0041 ,
'SpectraMaster Colors -- BS520' => 0xEC0036 ,
'SpectraMaster Colors -- BS521' => 0xC9FF4E ,
'SpectraMaster Colors -- BS522' => 0xCCFF41 ,
'SpectraMaster Colors -- BS523' => 0xD1FF35 ,
'SpectraMaster Colors -- BS524' => 0xE1FF1B ,
'SpectraMaster Colors -- BS525' => 0xD8004F ,
'SpectraMaster Colors -- BS526' => 0xD80041 ,
'SpectraMaster Colors -- BS527' => 0xD90035 ,
'SpectraMaster Colors -- BS528' => 0xED001C ,
'SpectraMaster Colors -- BS529' => 0xC8024F ,
'SpectraMaster Colors -- BS530' => 0xCB0342 ,
'SpectraMaster Colors -- BS531' => 0xCF0334 ,
'SpectraMaster Colors -- BS532' => 0xE20319 ,
'SpectraMaster Colors -- BS533' => 0xD9024C ,
'SpectraMaster Colors -- BS534' => 0xDA0142 ,
'SpectraMaster Colors -- BS535' => 0xE40135 ,
'SpectraMaster Colors -- BS536' => 0xEB0118 ,
'SpectraMaster Colors -- BS537' => 0xCC0484 ,
'SpectraMaster Colors -- BS538' => 0xC90376 ,
'SpectraMaster Colors -- BS539' => 0xC70367 ,
'SpectraMaster Colors -- BS540' => 0xC6025B ,
'SpectraMaster Colors -- BS541' => 0xD60280 ,
'SpectraMaster Colors -- BS542' => 0xD80276 ,
'SpectraMaster Colors -- BS543' => 0xD80168 ,
'SpectraMaster Colors -- BS544' => 0xD8015A ,
'SpectraMaster Colors -- BS545' => 0xE003B8 ,
'SpectraMaster Colors -- BS546' => 0xDA04AC ,
'SpectraMaster Colors -- BS547' => 0xD4039E ,
'SpectraMaster Colors -- BS548' => 0xCF0390 ,
'SpectraMaster Colors -- BS549' => 0xE602B7 ,
'SpectraMaster Colors -- BS550' => 0xE602AD ,
'SpectraMaster Colors -- BS551' => 0xD9039E ,
'SpectraMaster Colors -- BS552' => 0xD80290 ,
'SpectraMaster Colors -- BS553' => 0xF900E5 ,
'SpectraMaster Colors -- BS554' => 0xEF01D4 ,
'SpectraMaster Colors -- BS555' => 0xE902CB ,
'SpectraMaster Colors -- BS556' => 0xE402C2 ,
'SpectraMaster Colors -- BS557' => 0xF701D3 ,
'SpectraMaster Colors -- BS558' => 0xF200CB ,
'SpectraMaster Colors -- BS559' => 0xEF01C0 ,
'SpectraMaster Colors -- BS560' => 0xEE01B4 ,
'SpectraMaster Colors -- BS561' => 0xF703E2 ,
'SpectraMaster Colors -- BS562' => 0xF002D6 ,
'SpectraMaster Colors -- BS563' => 0xE904CA ,
'SpectraMaster Colors -- BS564' => 0xE504C2 ,
'SpectraMaster Colors -- BS565' => 0xF201CB ,
'SpectraMaster Colors -- BS566' => 0xF001C3 ,
'SpectraMaster Colors -- BS567' => 0xF007B6 ,
'SpectraMaster Colors -- BS568' => 0xED05A8 ,
'SpectraMaster Colors -- BS569' => 0xE006B8 ,
'SpectraMaster Colors -- BS570' => 0xDA08AB ,
'SpectraMaster Colors -- BS571' => 0xD4089D ,
'SpectraMaster Colors -- BS572' => 0xD00791 ,
'SpectraMaster Colors -- BS573' => 0xE704B7 ,
'SpectraMaster Colors -- BS574' => 0xE505AA ,
'SpectraMaster Colors -- BS575' => 0xDA069E ,
'SpectraMaster Colors -- BS576' => 0xD90591 ,
'SpectraMaster Colors -- BS577' => 0xE4059D ,
'SpectraMaster Colors -- BS578' => 0xE50790 ,
'SpectraMaster Colors -- BS579' => 0xE50583 ,
'SpectraMaster Colors -- BS580' => 0xE50477 ,
'SpectraMaster Colors -- BS581' => 0xEE059C ,
'SpectraMaster Colors -- BS582' => 0xEE038F ,
'SpectraMaster Colors -- BS583' => 0xEE0382 ,
'SpectraMaster Colors -- BS584' => 0xEE0375 ,
'SpectraMaster Colors -- BS585' => 0xCD0785 ,
'SpectraMaster Colors -- BS586' => 0xC80875 ,
'SpectraMaster Colors -- BS587' => 0xC60767 ,
'SpectraMaster Colors -- BS588' => 0xC6085A ,
'SpectraMaster Colors -- BS589' => 0xD80583 ,
'SpectraMaster Colors -- BS590' => 0xD70574 ,
'SpectraMaster Colors -- BS591' => 0xD90569 ,
'SpectraMaster Colors -- BS592' => 0xD9055A ,
'SpectraMaster Colors -- BS593' => 0xE5056A ,
'SpectraMaster Colors -- BS594' => 0xE5055D ,
'SpectraMaster Colors -- BS595' => 0xE40550 ,
'SpectraMaster Colors -- BS596' => 0xE30542 ,
'SpectraMaster Colors -- BS597' => 0xED0368 ,
'SpectraMaster Colors -- BS598' => 0xED035C ,
'SpectraMaster Colors -- BS599' => 0xEC0350 ,
'SpectraMaster Colors -- BS600' => 0xEC0341 ,
'SpectraMaster Colors -- BS601' => 0xC6084E ,
'SpectraMaster Colors -- BS602' => 0xC80842 ,
'SpectraMaster Colors -- BS603' => 0xCD0734 ,
'SpectraMaster Colors -- BS604' => 0xD90534 ,
'SpectraMaster Colors -- BS605' => 0xDB0450 ,
'SpectraMaster Colors -- BS606' => 0xD90540 ,
'SpectraMaster Colors -- BS607' => 0xE30535 ,
'SpectraMaster Colors -- BS608' => 0xE3071C ,
'SpectraMaster Colors -- BS609' => 0xC60D50 ,
'SpectraMaster Colors -- BS610' => 0xC80D43 ,
'SpectraMaster Colors -- BS611' => 0xCC0D35 ,
'SpectraMaster Colors -- BS612' => 0xDA0A1A ,
'SpectraMaster Colors -- BS613' => 0xDA084E ,
'SpectraMaster Colors -- BS614' => 0xDA0841 ,
'SpectraMaster Colors -- BS615' => 0xDA0834 ,
'SpectraMaster Colors -- BS616' => 0xE40619 ,
'SpectraMaster Colors -- BS617' => 0xCC0C82 ,
'SpectraMaster Colors -- BS618' => 0xC90C77 ,
'SpectraMaster Colors -- BS619' => 0xC60D67 ,
'SpectraMaster Colors -- BS620' => 0xC60D5C ,
'SpectraMaster Colors -- BS621' => 0xD90884 ,
'SpectraMaster Colors -- BS622' => 0xD90877 ,
'SpectraMaster Colors -- BS623' => 0xCC0B69 ,
'SpectraMaster Colors -- BS624' => 0xCC0B5B ,
'SpectraMaster Colors -- BS625' => 0xDF09B5 ,
'SpectraMaster Colors -- BS626' => 0xDB0BAA ,
'SpectraMaster Colors -- BS627' => 0xD60B9E ,
'SpectraMaster Colors -- BS628' => 0xD00B90 ,
'SpectraMaster Colors -- BS629' => 0xE707B6 ,
'SpectraMaster Colors -- BS630' => 0xE607AA ,
'SpectraMaster Colors -- BS631' => 0xDB0A9E ,
'SpectraMaster Colors -- BS632' => 0xD90990 ,
'SpectraMaster Colors -- BS633' => 0xF703E1 ,
'SpectraMaster Colors -- BS634' => 0xEF03D5 ,
'SpectraMaster Colors -- BS635' => 0xE806C9 ,
'SpectraMaster Colors -- BS636' => 0xE507C1 ,
'SpectraMaster Colors -- BS637' => 0xF702D3 ,
'SpectraMaster Colors -- BS638' => 0xF302CA ,
'SpectraMaster Colors -- BS639' => 0xEF04C0 ,
'SpectraMaster Colors -- BS640' => 0xEE04B4 ,
'SpectraMaster Colors -- BS641' => 0xF403D4 ,
'SpectraMaster Colors -- BS642' => 0xF204C9 ,
'SpectraMaster Colors -- BS643' => 0xF705C2 ,
'SpectraMaster Colors -- BS644' => 0xEE05BE ,
'SpectraMaster Colors -- BS645' => 0xF604E0 ,
'SpectraMaster Colors -- BS646' => 0xEF05D4 ,
'SpectraMaster Colors -- BS647' => 0xE907C9 ,
'SpectraMaster Colors -- BS648' => 0xE40ABE ,
'SpectraMaster Colors -- BS649' => 0xE609B4 ,
'SpectraMaster Colors -- BS650' => 0xE509A7 ,
'SpectraMaster Colors -- BS651' => 0xDB0D9C ,
'SpectraMaster Colors -- BS652' => 0xDA0C8F ,
'SpectraMaster Colors -- BS653' => 0xDF0CB3 ,
'SpectraMaster Colors -- BS654' => 0xDB0EA9 ,
'SpectraMaster Colors -- BS655' => 0xD50F9C ,
'SpectraMaster Colors -- BS656' => 0xD11090 ,
'SpectraMaster Colors -- BS657' => 0xF00AB6 ,
'SpectraMaster Colors -- BS658' => 0xF0099D ,
'SpectraMaster Colors -- BS659' => 0xEF078F ,
'SpectraMaster Colors -- BS660' => 0xEF0682 ,
'SpectraMaster Colors -- BS661' => 0xF00AAA ,
'SpectraMaster Colors -- BS662' => 0xE5099B ,
'SpectraMaster Colors -- BS663' => 0xE4088E ,
'SpectraMaster Colors -- BS664' => 0xE70B84 ,
'SpectraMaster Colors -- BS665' => 0xEF0675 ,
'SpectraMaster Colors -- BS666' => 0xEE0668 ,
'SpectraMaster Colors -- BS667' => 0xEE065B ,
'SpectraMaster Colors -- BS668' => 0xE6095D ,
'SpectraMaster Colors -- BS669' => 0xE60A77 ,
'SpectraMaster Colors -- BS670' => 0xE60A6A ,
'SpectraMaster Colors -- BS671' => 0xDA0C67 ,
'SpectraMaster Colors -- BS672' => 0xDA0C5A ,
'SpectraMaster Colors -- BS673' => 0xDA0B84 ,
'SpectraMaster Colors -- BS674' => 0xDC0A77 ,
'SpectraMaster Colors -- BS675' => 0xCD1069 ,
'SpectraMaster Colors -- BS676' => 0xCC105A ,
'SpectraMaster Colors -- BS677' => 0xCC1182 ,
'SpectraMaster Colors -- BS678' => 0xCA1177 ,
'SpectraMaster Colors -- BS679' => 0xC7116A ,
'SpectraMaster Colors -- BS680' => 0xC5125B ,
'SpectraMaster Colors -- BS681' => 0xCD114D ,
'SpectraMaster Colors -- BS682' => 0xDB0C41 ,
'SpectraMaster Colors -- BS683' => 0xDB0C34 ,
'SpectraMaster Colors -- BS684' => 0xE50819 ,
'SpectraMaster Colors -- BS685' => 0xC61250 ,
'SpectraMaster Colors -- BS686' => 0xC61341 ,
'SpectraMaster Colors -- BS687' => 0xCB1236 ,
'SpectraMaster Colors -- BS688' => 0xD80F1A ,
'SpectraMaster Colors -- BS689' => 0xED064E ,
'SpectraMaster Colors -- BS690' => 0xED0641 ,
'SpectraMaster Colors -- BS691' => 0xED0634 ,
'SpectraMaster Colors -- BS692' => 0xEC071C ,
'SpectraMaster Colors -- BS693' => 0xDB0C4E ,
'SpectraMaster Colors -- BS694' => 0xE50950 ,
'SpectraMaster Colors -- BS695' => 0xE40941 ,
'SpectraMaster Colors -- BS696' => 0xE40934 ,
'SpectraMaster Colors -- BS697' => 0xDC104E ,
'SpectraMaster Colors -- BS698' => 0xDC0F42 ,
'SpectraMaster Colors -- BS699' => 0xE60B41 ,
'SpectraMaster Colors -- BS700' => 0xE50B34 ,
'SpectraMaster Colors -- BS701' => 0xC71842 ,
'SpectraMaster Colors -- BS702' => 0xCA1735 ,
'SpectraMaster Colors -- BS703' => 0xD91219 ,
'SpectraMaster Colors -- BS704' => 0xE60A19 ,
'SpectraMaster Colors -- BS705' => 0xDB1076 ,
'SpectraMaster Colors -- BS706' => 0xDC0F6B ,
'SpectraMaster Colors -- BS707' => 0xDC0F5D ,
'SpectraMaster Colors -- BS708' => 0xCF144E ,
'SpectraMaster Colors -- BS709' => 0xCA1676 ,
'SpectraMaster Colors -- BS710' => 0xC71768 ,
'SpectraMaster Colors -- BS711' => 0xC6185A ,
'SpectraMaster Colors -- BS712' => 0xC6184F ,
'SpectraMaster Colors -- BS713' => 0xE80BA8 ,
'SpectraMaster Colors -- BS714' => 0xDC109B ,
'SpectraMaster Colors -- BS715' => 0xDB108D ,
'SpectraMaster Colors -- BS716' => 0xDB1082 ,
'SpectraMaster Colors -- BS717' => 0xDA11A6 ,
'SpectraMaster Colors -- BS718' => 0xD51398 ,
'SpectraMaster Colors -- BS719' => 0xD1148F ,
'SpectraMaster Colors -- BS720' => 0xCE1584 ,
'SpectraMaster Colors -- BS721' => 0xF007BE ,
'SpectraMaster Colors -- BS722' => 0xF007B4 ,
'SpectraMaster Colors -- BS723' => 0xE80AB4 ,
'SpectraMaster Colors -- BS724' => 0xE60C9A ,
'SpectraMaster Colors -- BS725' => 0xEF07D4 ,
'SpectraMaster Colors -- BS726' => 0xE909C8 ,
'SpectraMaster Colors -- BS727' => 0xE50BBF ,
'SpectraMaster Colors -- BS728' => 0xE00EB3 ,
'SpectraMaster Colors -- BS729' => 0xF803E4 ,
'SpectraMaster Colors -- BS730' => 0xF107BE ,
'SpectraMaster Colors -- BS731' => 0xF10CB6 ,
'SpectraMaster Colors -- BS732' => 0xEA0CB4 ,
'SpectraMaster Colors -- BS733' => 0xF007D5 ,
'SpectraMaster Colors -- BS734' => 0xEB0AC8 ,
'SpectraMaster Colors -- BS735' => 0xE60DBE ,
'SpectraMaster Colors -- BS736' => 0xE210B2 ,
'SpectraMaster Colors -- BS737' => 0xE90DA7 ,
'SpectraMaster Colors -- BS738' => 0xE70E9B ,
'SpectraMaster Colors -- BS739' => 0xDE138F ,
'SpectraMaster Colors -- BS740' => 0xDE1284 ,
'SpectraMaster Colors -- BS741' => 0xDE13A6 ,
'SpectraMaster Colors -- BS742' => 0xDA1699 ,
'SpectraMaster Colors -- BS743' => 0xD7168F ,
'SpectraMaster Colors -- BS744' => 0xD11880 ,
'SpectraMaster Colors -- BS745' => 0xDD1275 ,
'SpectraMaster Colors -- BS746' => 0xDD1269 ,
'SpectraMaster Colors -- BS747' => 0xDE125C ,
'SpectraMaster Colors -- BS748' => 0xDE124E ,
'SpectraMaster Colors -- BS749' => 0xCD1976 ,
'SpectraMaster Colors -- BS750' => 0xC91C6A ,
'SpectraMaster Colors -- BS751' => 0xC81D60 ,
'SpectraMaster Colors -- BS752' => 0xC71F50 ,
'SpectraMaster Colors -- BS753' => 0xF10D9C ,
'SpectraMaster Colors -- BS754' => 0xF10B90 ,
'SpectraMaster Colors -- BS755' => 0xF10A82 ,
'SpectraMaster Colors -- BS756' => 0xF00A75 ,
'SpectraMaster Colors -- BS757' => 0xF20EAA ,
'SpectraMaster Colors -- BS758' => 0xE60E8E ,
'SpectraMaster Colors -- BS759' => 0xE91184 ,
'SpectraMaster Colors -- BS760' => 0xE80F77 ,
'SpectraMaster Colors -- BS761' => 0xEF0969 ,
'SpectraMaster Colors -- BS762' => 0xEF095C ,
'SpectraMaster Colors -- BS763' => 0xEF094E ,
'SpectraMaster Colors -- BS764' => 0xEF0941 ,
'SpectraMaster Colors -- BS765' => 0xE80E6B ,
'SpectraMaster Colors -- BS766' => 0xE70E5D ,
'SpectraMaster Colors -- BS767' => 0xE70E50 ,
'SpectraMaster Colors -- BS768' => 0xE70E42 ,
'SpectraMaster Colors -- BS769' => 0xDD1341 ,
'SpectraMaster Colors -- BS770' => 0xDD1334 ,
'SpectraMaster Colors -- BS771' => 0xE60E35 ,
'SpectraMaster Colors -- BS772' => 0xE70D1A ,
'SpectraMaster Colors -- BS773' => 0xC91F42 ,
'SpectraMaster Colors -- BS774' => 0xCB1C35 ,
'SpectraMaster Colors -- BS775' => 0xD11927 ,
'SpectraMaster Colors -- BS776' => 0xDA151A ,
'SpectraMaster Colors -- BS777' => 0xE80F3F ,
'SpectraMaster Colors -- BS778' => 0xE81032 ,
'SpectraMaster Colors -- BS779' => 0xDE1633 ,
'SpectraMaster Colors -- BS780' => 0xE71019 ,
'SpectraMaster Colors -- BS781' => 0xD11F41 ,
'SpectraMaster Colors -- BS782' => 0xDE1640 ,
'SpectraMaster Colors -- BS783' => 0xD41D35 ,
'SpectraMaster Colors -- BS784' => 0xDF171B ,
'SpectraMaster Colors -- BS785' => 0xDF1476 ,
'SpectraMaster Colors -- BS786' => 0xDF1567 ,
'SpectraMaster Colors -- BS787' => 0xDF155B ,
'SpectraMaster Colors -- BS788' => 0xDF154D ,
'SpectraMaster Colors -- BS789' => 0xD41B77 ,
'SpectraMaster Colors -- BS790' => 0xD11D6A ,
'SpectraMaster Colors -- BS791' => 0xD01E5D ,
'SpectraMaster Colors -- BS792' => 0xD01E4F ,
'SpectraMaster Colors -- BS793' => 0xEA0EA9 ,
'SpectraMaster Colors -- BS794' => 0xE9109B ,
'SpectraMaster Colors -- BS795' => 0xE0168F ,
'SpectraMaster Colors -- BS796' => 0xDF1582 ,
'SpectraMaster Colors -- BS797' => 0xE115A8 ,
'SpectraMaster Colors -- BS798' => 0xDD1899 ,
'SpectraMaster Colors -- BS799' => 0xDA1A8E ,
'SpectraMaster Colors -- BS800' => 0xD71B82 ,
'SpectraMaster Colors -- BS801' => 0xF704E1 ,
'SpectraMaster Colors -- BS802' => 0xF109BE ,
'SpectraMaster Colors -- BS803' => 0xF109B3 ,
'SpectraMaster Colors -- BS804' => 0xF00AA8 ,
'SpectraMaster Colors -- BS805' => 0xF009D3 ,
'SpectraMaster Colors -- BS806' => 0xEC0CC8 ,
'SpectraMaster Colors -- BS807' => 0xE80FBE ,
'SpectraMaster Colors -- BS808' => 0xE412B3 ,
'SpectraMaster Colors -- BS901' => 0xC9FF4E ,
'SpectraMaster Colors -- BS902' => 0xCAFB4E ,
'SpectraMaster Colors -- BS903' => 0xD1F642 ,
'SpectraMaster Colors -- BS904' => 0xD1FF35 ,
'SpectraMaster Colors -- BS905' => 0xC9F673 ,
'SpectraMaster Colors -- BS906' => 0xCAF066 ,
'SpectraMaster Colors -- BS907' => 0xD2E95B ,
'SpectraMaster Colors -- BS908' => 0xC7FF5A ,
'SpectraMaster Colors -- BS909' => 0xDED874 ,
'SpectraMaster Colors -- BS910' => 0xD9DE68 ,
'SpectraMaster Colors -- BS911' => 0xD6E167 ,
'SpectraMaster Colors -- BS912' => 0xDEDC5C ,
'SpectraMaster Colors -- BS913' => 0xD2E474 ,
'SpectraMaster Colors -- BS914' => 0xCAED69 ,
'SpectraMaster Colors -- BS915' => 0xCDEB67 ,
'SpectraMaster Colors -- BS916' => 0xD0E766 ,
'SpectraMaster Colors -- DS001' => 0x000002 ,
'SpectraMaster Colors -- DS002' => 0x000004 ,
'SpectraMaster Colors -- DS003' => 0xFF0009 ,
'SpectraMaster Colors -- DS004' => 0x000106 ,
'SpectraMaster Colors -- DS005' => 0x010107 ,
'SpectraMaster Colors -- DS006' => 0x000007 ,
'SpectraMaster Colors -- DS007' => 0x000007 ,
'SpectraMaster Colors -- DS008' => 0xFD0007 ,
'SpectraMaster Colors -- DS009' => 0xF6080C ,
'SpectraMaster Colors -- DS010' => 0x010A0A ,
'SpectraMaster Colors -- DS011' => 0x04040C ,
'SpectraMaster Colors -- DS012' => 0x02000C ,
'SpectraMaster Colors -- DS013' => 0x01FF0C ,
'SpectraMaster Colors -- DS014' => 0x00FD0C ,
'SpectraMaster Colors -- DS015' => 0xFBFD0A ,
'SpectraMaster Colors -- DS016' => 0xF3010A ,
'SpectraMaster Colors -- DS017' => 0x00007F ,
'SpectraMaster Colors -- DS018' => 0x000071 ,
'SpectraMaster Colors -- DS019' => 0x000065 ,
'SpectraMaster Colors -- DS020' => 0x000057 ,
'SpectraMaster Colors -- DS021' => 0x00004A ,
'SpectraMaster Colors -- DS022' => 0x00003F ,
'SpectraMaster Colors -- DS023' => 0x000031 ,
'SpectraMaster Colors -- DS024' => 0x000018 ,
'SpectraMaster Colors -- DS025' => 0xFC0381 ,
'SpectraMaster Colors -- DS026' => 0xFC0373 ,
'SpectraMaster Colors -- DS027' => 0xFC0365 ,
'SpectraMaster Colors -- DS028' => 0xFC0359 ,
'SpectraMaster Colors -- DS029' => 0xFC034C ,
'SpectraMaster Colors -- DS030' => 0xFB053D ,
'SpectraMaster Colors -- DS031' => 0xFC0333 ,
'SpectraMaster Colors -- DS032' => 0xFC0319 ,
'SpectraMaster Colors -- DS033' => 0xF70782 ,
'SpectraMaster Colors -- DS034' => 0xF70773 ,
'SpectraMaster Colors -- DS035' => 0xF70766 ,
'SpectraMaster Colors -- DS036' => 0xF70758 ,
'SpectraMaster Colors -- DS037' => 0xF6074D ,
'SpectraMaster Colors -- DS038' => 0xF50844 ,
'SpectraMaster Colors -- DS039' => 0xF70733 ,
'SpectraMaster Colors -- DS040' => 0xF6081B ,
'SpectraMaster Colors -- DS041' => 0xFC0A81 ,
'SpectraMaster Colors -- DS042' => 0xFB0A73 ,
'SpectraMaster Colors -- DS043' => 0xFB0A66 ,
'SpectraMaster Colors -- DS044' => 0xFB0B5A ,
'SpectraMaster Colors -- DS045' => 0xFC0B4D ,
'SpectraMaster Colors -- DS046' => 0xFC0B40 ,
'SpectraMaster Colors -- DS047' => 0xFD0B34 ,
'SpectraMaster Colors -- DS048' => 0xFC0B18 ,
'SpectraMaster Colors -- DS049' => 0x00047F ,
'SpectraMaster Colors -- DS050' => 0x000472 ,
'SpectraMaster Colors -- DS051' => 0x000565 ,
'SpectraMaster Colors -- DS052' => 0x000558 ,
'SpectraMaster Colors -- DS053' => 0x00054B ,
'SpectraMaster Colors -- DS054' => 0x01053E ,
'SpectraMaster Colors -- DS055' => 0x010532 ,
'SpectraMaster Colors -- DS056' => 0x010516 ,
'SpectraMaster Colors -- DS057' => 0x000A7F ,
'SpectraMaster Colors -- DS058' => 0x000A73 ,
'SpectraMaster Colors -- DS059' => 0x000A67 ,
'SpectraMaster Colors -- DS060' => 0x000A59 ,
'SpectraMaster Colors -- DS061' => 0x010B4C ,
'SpectraMaster Colors -- DS062' => 0x010B3F ,
'SpectraMaster Colors -- DS063' => 0x020A33 ,
'SpectraMaster Colors -- DS064' => 0x020B18 ,
'SpectraMaster Colors -- DS065' => 0x04097D ,
'SpectraMaster Colors -- DS066' => 0x030972 ,
'SpectraMaster Colors -- DS067' => 0x040965 ,
'SpectraMaster Colors -- DS068' => 0x04095B ,
'SpectraMaster Colors -- DS069' => 0x050A4C ,
'SpectraMaster Colors -- DS070' => 0x060A40 ,
'SpectraMaster Colors -- DS071' => 0x060A32 ,
'SpectraMaster Colors -- DS072' => 0x060A17 ,
'SpectraMaster Colors -- DS073' => 0x030380 ,
'SpectraMaster Colors -- DS074' => 0x030372 ,
'SpectraMaster Colors -- DS075' => 0x030366 ,
'SpectraMaster Colors -- DS076' => 0x030359 ,
'SpectraMaster Colors -- DS077' => 0x03034B ,
'SpectraMaster Colors -- DS078' => 0x03033F ,
'SpectraMaster Colors -- DS079' => 0x030330 ,
'SpectraMaster Colors -- DS080' => 0x040319 ,
'SpectraMaster Colors -- DS081' => 0x08077F ,
'SpectraMaster Colors -- DS082' => 0x080772 ,
'SpectraMaster Colors -- DS083' => 0x080766 ,
'SpectraMaster Colors -- DS084' => 0x080758 ,
'SpectraMaster Colors -- DS085' => 0x08074B ,
'SpectraMaster Colors -- DS086' => 0x08073F ,
'SpectraMaster Colors -- DS087' => 0x080732 ,
'SpectraMaster Colors -- DS088' => 0x090818 ,
'SpectraMaster Colors -- DS089' => 0x0A0380 ,
'SpectraMaster Colors -- DS090' => 0x0A0372 ,
'SpectraMaster Colors -- DS091' => 0x0A0365 ,
'SpectraMaster Colors -- DS092' => 0x0A0458 ,
'SpectraMaster Colors -- DS093' => 0x0A044B ,
'SpectraMaster Colors -- DS094' => 0x0A033F ,
'SpectraMaster Colors -- DS095' => 0x0A0332 ,
'SpectraMaster Colors -- DS096' => 0x0B0418 ,
'SpectraMaster Colors -- DS097' => 0x04007F ,
'SpectraMaster Colors -- DS098' => 0x040072 ,
'SpectraMaster Colors -- DS099' => 0x040066 ,
'SpectraMaster Colors -- DS100' => 0x040059 ,
'SpectraMaster Colors -- DS101' => 0x04004B ,
'SpectraMaster Colors -- DS102' => 0x04003F ,
'SpectraMaster Colors -- DS103' => 0x040032 ,
'SpectraMaster Colors -- DS104' => 0x050019 ,
'SpectraMaster Colors -- DS105' => 0x0B0080 ,
'SpectraMaster Colors -- DS106' => 0x0A0073 ,
'SpectraMaster Colors -- DS107' => 0x0A0066 ,
'SpectraMaster Colors -- DS108' => 0x0A0059 ,
'SpectraMaster Colors -- DS109' => 0x0B004C ,
'SpectraMaster Colors -- DS110' => 0x0B003F ,
'SpectraMaster Colors -- DS111' => 0x0B0033 ,
'SpectraMaster Colors -- DS112' => 0x0C0019 ,
'SpectraMaster Colors -- DS113' => 0x0AFD80 ,
'SpectraMaster Colors -- DS114' => 0x0AFD73 ,
'SpectraMaster Colors -- DS115' => 0x0AFC66 ,
'SpectraMaster Colors -- DS116' => 0x0BFC5A ,
'SpectraMaster Colors -- DS117' => 0x0BFC4D ,
'SpectraMaster Colors -- DS118' => 0x0BFD40 ,
'SpectraMaster Colors -- DS119' => 0x0BFD35 ,
'SpectraMaster Colors -- DS120' => 0x0BFC18 ,
'SpectraMaster Colors -- DS121' => 0x02FD7F ,
'SpectraMaster Colors -- DS122' => 0x02FD71 ,
'SpectraMaster Colors -- DS123' => 0x03FC66 ,
'SpectraMaster Colors -- DS124' => 0x03FC59 ,
'SpectraMaster Colors -- DS125' => 0x03FC4D ,
'SpectraMaster Colors -- DS126' => 0x03FC40 ,
'SpectraMaster Colors -- DS127' => 0x03FD32 ,
'SpectraMaster Colors -- DS128' => 0x03FC19 ,
'SpectraMaster Colors -- DS129' => 0x07F880 ,
'SpectraMaster Colors -- DS130' => 0x07F874 ,
'SpectraMaster Colors -- DS131' => 0x07F768 ,
'SpectraMaster Colors -- DS132' => 0x07F759 ,
'SpectraMaster Colors -- DS133' => 0x07F74C ,
'SpectraMaster Colors -- DS134' => 0x08F740 ,
'SpectraMaster Colors -- DS135' => 0x08F832 ,
'SpectraMaster Colors -- DS136' => 0x07F71A ,
'SpectraMaster Colors -- DS137' => 0x02F580 ,
'SpectraMaster Colors -- DS138' => 0x01F574 ,
'SpectraMaster Colors -- DS139' => 0x01F567 ,
'SpectraMaster Colors -- DS140' => 0x02F45A ,
'SpectraMaster Colors -- DS141' => 0x02F44D ,
'SpectraMaster Colors -- DS142' => 0x02F442 ,
'SpectraMaster Colors -- DS143' => 0x02F436 ,
'SpectraMaster Colors -- DS144' => 0x01F319 ,
'SpectraMaster Colors -- DS145' => 0xFFFB80 ,
'SpectraMaster Colors -- DS146' => 0xFFFB73 ,
'SpectraMaster Colors -- DS147' => 0xFFFB66 ,
'SpectraMaster Colors -- DS148' => 0xFFFB58 ,
'SpectraMaster Colors -- DS149' => 0xFFFB4C ,
'SpectraMaster Colors -- DS150' => 0xFFFB3F ,
'SpectraMaster Colors -- DS151' => 0xFFFB32 ,
'SpectraMaster Colors -- DS152' => 0xFFFB18 ,
'SpectraMaster Colors -- DS153' => 0xFEF57F ,
'SpectraMaster Colors -- DS154' => 0xFEF472 ,
'SpectraMaster Colors -- DS155' => 0xFEF465 ,
'SpectraMaster Colors -- DS156' => 0xFEF458 ,
'SpectraMaster Colors -- DS157' => 0xFEF44C ,
'SpectraMaster Colors -- DS158' => 0xFEF43F ,
'SpectraMaster Colors -- DS159' => 0xFFF431 ,
'SpectraMaster Colors -- DS160' => 0xFEF318 ,
'SpectraMaster Colors -- DS161' => 0xFAF57F ,
'SpectraMaster Colors -- DS162' => 0xFAF671 ,
'SpectraMaster Colors -- DS163' => 0xFAF665 ,
'SpectraMaster Colors -- DS164' => 0xFAF658 ,
'SpectraMaster Colors -- DS165' => 0xFAF64A ,
'SpectraMaster Colors -- DS166' => 0xFAF63E ,
'SpectraMaster Colors -- DS167' => 0xFBF633 ,
'SpectraMaster Colors -- DS168' => 0xFAF518 ,
'SpectraMaster Colors -- DS169' => 0xFCFD80 ,
'SpectraMaster Colors -- DS170' => 0xFDFD73 ,
'SpectraMaster Colors -- DS171' => 0xFCFD66 ,
'SpectraMaster Colors -- DS172' => 0xFCFD58 ,
'SpectraMaster Colors -- DS173' => 0xFCFD4C ,
'SpectraMaster Colors -- DS174' => 0xFCFD3F ,
'SpectraMaster Colors -- DS175' => 0xFCFE31 ,
'SpectraMaster Colors -- DS176' => 0xFDFD18 ,
'SpectraMaster Colors -- DS177' => 0xF7F980 ,
'SpectraMaster Colors -- DS178' => 0xF8F974 ,
'SpectraMaster Colors -- DS179' => 0xF8F966 ,
'SpectraMaster Colors -- DS180' => 0xF7F959 ,
'SpectraMaster Colors -- DS181' => 0xF7F94C ,
'SpectraMaster Colors -- DS182' => 0xF7F93E ,
'SpectraMaster Colors -- DS183' => 0xF7F932 ,
'SpectraMaster Colors -- DS184' => 0xF7F719 ,
'SpectraMaster Colors -- DS185' => 0xF5FB7F ,
'SpectraMaster Colors -- DS186' => 0xF5FC73 ,
'SpectraMaster Colors -- DS187' => 0xF5FC65 ,
'SpectraMaster Colors -- DS188' => 0xF5FC59 ,
'SpectraMaster Colors -- DS189' => 0xF5FD4C ,
'SpectraMaster Colors -- DS190' => 0xF4FC3F ,
'SpectraMaster Colors -- DS191' => 0xF5FC32 ,
'SpectraMaster Colors -- DS192' => 0xF4FB18 ,
'SpectraMaster Colors -- DS193' => 0xFB007F ,
'SpectraMaster Colors -- DS194' => 0xFA0072 ,
'SpectraMaster Colors -- DS195' => 0xFB0065 ,
'SpectraMaster Colors -- DS196' => 0xFB0059 ,
'SpectraMaster Colors -- DS197' => 0xFB004B ,
'SpectraMaster Colors -- DS198' => 0xFA003E ,
'SpectraMaster Colors -- DS199' => 0xFB0031 ,
'SpectraMaster Colors -- DS200' => 0xFB0019 ,
'SpectraMaster Colors -- DS201' => 0xF50080 ,
'SpectraMaster Colors -- DS202' => 0xF40073 ,
'SpectraMaster Colors -- DS203' => 0xF40066 ,
'SpectraMaster Colors -- DS204' => 0xF40059 ,
'SpectraMaster Colors -- DS205' => 0xF4004D ,
'SpectraMaster Colors -- DS206' => 0xF40040 ,
'SpectraMaster Colors -- DS207' => 0xF40033 ,
'SpectraMaster Colors -- DS208' => 0xF4001A ,
'SpectraMaster Colors -- DS209' => 0xF60380 ,
'SpectraMaster Colors -- DS210' => 0xF50373 ,
'SpectraMaster Colors -- DS211' => 0xF50366 ,
'SpectraMaster Colors -- DS212' => 0xF50359 ,
'SpectraMaster Colors -- DS213' => 0xF4034C ,
'SpectraMaster Colors -- DS214' => 0xF40340 ,
'SpectraMaster Colors -- DS215' => 0xF40433 ,
'SpectraMaster Colors -- DS216' => 0xF4041A ,
'SpectraMaster Colors -- GS001' => 0x11FBE3 ,
'SpectraMaster Colors -- GS002' => 0x1AF8E4 ,
'SpectraMaster Colors -- GS003' => 0x23F3E4 ,
'SpectraMaster Colors -- GS004' => 0x3AE9E1 ,
'SpectraMaster Colors -- GS005' => 0x0EF9D7 ,
'SpectraMaster Colors -- GS006' => 0x18F6D5 ,
'SpectraMaster Colors -- GS007' => 0x24F2D6 ,
'SpectraMaster Colors -- GS008' => 0x32EDD5 ,
'SpectraMaster Colors -- GS009' => 0x51E3D4 ,
'SpectraMaster Colors -- GS010' => 0x5FE1C7 ,
'SpectraMaster Colors -- GS011' => 0x4EE3BD ,
'SpectraMaster Colors -- GS012' => 0x51E2B1 ,
'SpectraMaster Colors -- GS013' => 0x3CE8D6 ,
'SpectraMaster Colors -- GS014' => 0x48E5C9 ,
'SpectraMaster Colors -- GS015' => 0x43EABD ,
'SpectraMaster Colors -- GS016' => 0x42EAAE ,
'SpectraMaster Colors -- GS017' => 0x4EE3A6 ,
'SpectraMaster Colors -- GS018' => 0x49E497 ,
'SpectraMaster Colors -- GS019' => 0x50E18B ,
'SpectraMaster Colors -- GS020' => 0x55DE7E ,
'SpectraMaster Colors -- GS021' => 0x43EAA4 ,
'SpectraMaster Colors -- GS022' => 0x40E699 ,
'SpectraMaster Colors -- GS023' => 0x43EB8E ,
'SpectraMaster Colors -- GS024' => 0x43E57E ,
'SpectraMaster Colors -- GS025' => 0x42E9C8 ,
'SpectraMaster Colors -- GS026' => 0x34EEBE ,
'SpectraMaster Colors -- GS027' => 0x34EEB1 ,
'SpectraMaster Colors -- GS028' => 0x35EEA4 ,
'SpectraMaster Colors -- GS029' => 0x33EECB ,
'SpectraMaster Colors -- GS030' => 0x26F2BF ,
'SpectraMaster Colors -- GS031' => 0x28F2B4 ,
'SpectraMaster Colors -- GS032' => 0x24F2A7 ,
'SpectraMaster Colors -- GS033' => 0x24F3CA ,
'SpectraMaster Colors -- GS034' => 0x19F7C3 ,
'SpectraMaster Colors -- GS035' => 0x19F6B6 ,
'SpectraMaster Colors -- GS036' => 0x1AF6A9 ,
'SpectraMaster Colors -- GS037' => 0x18F6CD ,
'SpectraMaster Colors -- GS038' => 0x10F8C2 ,
'SpectraMaster Colors -- GS039' => 0x11F8B6 ,
'SpectraMaster Colors -- GS040' => 0x12FAA9 ,
'SpectraMaster Colors -- GS041' => 0x1AF79C ,
'SpectraMaster Colors -- GS042' => 0x1BF78E ,
'SpectraMaster Colors -- GS043' => 0x1BF781 ,
'SpectraMaster Colors -- GS044' => 0x1CF774 ,
'SpectraMaster Colors -- GS045' => 0x12FA9B ,
'SpectraMaster Colors -- GS046' => 0x11FB8E ,
'SpectraMaster Colors -- GS047' => 0x12FA81 ,
'SpectraMaster Colors -- GS048' => 0x12FA74 ,
'SpectraMaster Colors -- GS049' => 0x35EE99 ,
'SpectraMaster Colors -- GS050' => 0x34EE8C ,
'SpectraMaster Colors -- GS051' => 0x34EE81 ,
'SpectraMaster Colors -- GS052' => 0x4CE373 ,
'SpectraMaster Colors -- GS053' => 0x24F29B ,
'SpectraMaster Colors -- GS054' => 0x25F28D ,
'SpectraMaster Colors -- GS055' => 0x26F381 ,
'SpectraMaster Colors -- GS056' => 0x33EF75 ,
'SpectraMaster Colors -- GS057' => 0x3CE767 ,
'SpectraMaster Colors -- GS058' => 0x36ED5B ,
'SpectraMaster Colors -- GS059' => 0x2CEF4D ,
'SpectraMaster Colors -- GS060' => 0x21F43C ,
'SpectraMaster Colors -- GS061' => 0x27F475 ,
'SpectraMaster Colors -- GS062' => 0x27F469 ,
'SpectraMaster Colors -- GS063' => 0x25F15A ,
'SpectraMaster Colors -- GS064' => 0x1AF631 ,
'SpectraMaster Colors -- GS065' => 0x1CF767 ,
'SpectraMaster Colors -- GS066' => 0x1CF75C ,
'SpectraMaster Colors -- GS067' => 0x1AF64D ,
'SpectraMaster Colors -- GS068' => 0x12FA32 ,
'SpectraMaster Colors -- GS069' => 0x12FA67 ,
'SpectraMaster Colors -- GS070' => 0x12FA5A ,
'SpectraMaster Colors -- GS071' => 0x12FA4D ,
'SpectraMaster Colors -- GS072' => 0x12F924 ,
'SpectraMaster Colors -- GS073' => 0x35E45A ,
'SpectraMaster Colors -- GS074' => 0x2BE84B ,
'SpectraMaster Colors -- GS075' => 0x21ED3D ,
'SpectraMaster Colors -- GS076' => 0x18F32F ,
'SpectraMaster Colors -- GS077' => 0x23ED5A ,
'SpectraMaster Colors -- GS078' => 0x19F24E ,
'SpectraMaster Colors -- GS079' => 0x10F840 ,
'SpectraMaster Colors -- GS080' => 0x0FF832 ,
'SpectraMaster Colors -- GS081' => 0x41DC8B ,
'SpectraMaster Colors -- GS082' => 0x46DA7F ,
'SpectraMaster Colors -- GS083' => 0x4BD873 ,
'SpectraMaster Colors -- GS084' => 0x3BDE66 ,
'SpectraMaster Colors -- GS085' => 0x3EDD8C ,
'SpectraMaster Colors -- GS086' => 0x3DDD7F ,
'SpectraMaster Colors -- GS087' => 0x40DE72 ,
'SpectraMaster Colors -- GS088' => 0x30E774 ,
'SpectraMaster Colors -- GS089' => 0x5CD9BD ,
'SpectraMaster Colors -- GS090' => 0x48D9B0 ,
'SpectraMaster Colors -- GS091' => 0x4AD9A6 ,
'SpectraMaster Colors -- GS092' => 0x46DA99 ,
'SpectraMaster Colors -- GS093' => 0x45DCBE ,
'SpectraMaster Colors -- GS094' => 0x3FDFB3 ,
'SpectraMaster Colors -- GS095' => 0x3EDEA4 ,
'SpectraMaster Colors -- GS096' => 0x3EDD97 ,
'SpectraMaster Colors -- GS097' => 0x23ECE0 ,
'SpectraMaster Colors -- GS098' => 0x3BDFD6 ,
'SpectraMaster Colors -- GS099' => 0x3DDFCA ,
'SpectraMaster Colors -- GS100' => 0x49D9C9 ,
'SpectraMaster Colors -- GS101' => 0x18F3E3 ,
'SpectraMaster Colors -- GS102' => 0x2FE6E0 ,
'SpectraMaster Colors -- GS103' => 0x30E8D5 ,
'SpectraMaster Colors -- GS104' => 0x32E8CB ,
'SpectraMaster Colors -- GS105' => 0x1EE7E2 ,
'SpectraMaster Colors -- GS106' => 0x22E9D5 ,
'SpectraMaster Colors -- GS107' => 0x22EACC ,
'SpectraMaster Colors -- GS108' => 0x2FDDD5 ,
'SpectraMaster Colors -- GS109' => 0x0DF4DF ,
'SpectraMaster Colors -- GS110' => 0x16EEDF ,
'SpectraMaster Colors -- GS111' => 0x0DF5D7 ,
'SpectraMaster Colors -- GS112' => 0x17EFD5 ,
'SpectraMaster Colors -- GS113' => 0x3BD6CC ,
'SpectraMaster Colors -- GS114' => 0x53D4BD ,
'SpectraMaster Colors -- GS115' => 0x3FD3B1 ,
'SpectraMaster Colors -- GS116' => 0x42D1A5 ,
'SpectraMaster Colors -- GS117' => 0x2CE0CB ,
'SpectraMaster Colors -- GS118' => 0x3CD5BE ,
'SpectraMaster Colors -- GS119' => 0x3AD6B2 ,
'SpectraMaster Colors -- GS120' => 0x39D7A3 ,
'SpectraMaster Colors -- GS121' => 0x42D098 ,
'SpectraMaster Colors -- GS122' => 0x3DD38B ,
'SpectraMaster Colors -- GS123' => 0x39D780 ,
'SpectraMaster Colors -- GS124' => 0x3CD573 ,
'SpectraMaster Colors -- GS125' => 0x38D696 ,
'SpectraMaster Colors -- GS126' => 0x39D68A ,
'SpectraMaster Colors -- GS127' => 0x39D57F ,
'SpectraMaster Colors -- GS128' => 0x38D572 ,
'SpectraMaster Colors -- GS129' => 0x17F0CA ,
'SpectraMaster Colors -- GS130' => 0x16F1C2 ,
'SpectraMaster Colors -- GS131' => 0x17F0B6 ,
'SpectraMaster Colors -- GS132' => 0x17EFA8 ,
'SpectraMaster Colors -- GS133' => 0x0DF5CD ,
'SpectraMaster Colors -- GS134' => 0x0EF4C1 ,
'SpectraMaster Colors -- GS135' => 0x0FF4B6 ,
'SpectraMaster Colors -- GS136' => 0x10F5A9 ,
'SpectraMaster Colors -- GS137' => 0x2CE0BF ,
'SpectraMaster Colors -- GS138' => 0x2FE2B2 ,
'SpectraMaster Colors -- GS139' => 0x2EE1A4 ,
'SpectraMaster Colors -- GS140' => 0x2EE197 ,
'SpectraMaster Colors -- GS141' => 0x22E9C0 ,
'SpectraMaster Colors -- GS142' => 0x23E9B4 ,
'SpectraMaster Colors -- GS143' => 0x22E8A5 ,
'SpectraMaster Colors -- GS144' => 0x20E99B ,
'SpectraMaster Colors -- GS145' => 0x2DE08B ,
'SpectraMaster Colors -- GS146' => 0x2DE07F ,
'SpectraMaster Colors -- GS147' => 0x2CE074 ,
'SpectraMaster Colors -- GS148' => 0x3DD364 ,
'SpectraMaster Colors -- GS149' => 0x21E98F ,
'SpectraMaster Colors -- GS150' => 0x21EA80 ,
'SpectraMaster Colors -- GS151' => 0x22EA74 ,
'SpectraMaster Colors -- GS152' => 0x2CE068 ,
'SpectraMaster Colors -- GS153' => 0x17EF9C ,
'SpectraMaster Colors -- GS154' => 0x17F08E ,
'SpectraMaster Colors -- GS155' => 0x18F081 ,
'SpectraMaster Colors -- GS156' => 0x18F074 ,
'SpectraMaster Colors -- GS157' => 0x10F59C ,
'SpectraMaster Colors -- GS158' => 0x10F68E ,
'SpectraMaster Colors -- GS159' => 0x10F681 ,
'SpectraMaster Colors -- GS160' => 0x10F675 ,
'SpectraMaster Colors -- GS161' => 0x22EB69 ,
'SpectraMaster Colors -- GS162' => 0x20E85A ,
'SpectraMaster Colors -- GS163' => 0x19F15B ,
'SpectraMaster Colors -- GS164' => 0x17EF4E ,
'SpectraMaster Colors -- GS165' => 0x19F168 ,
'SpectraMaster Colors -- GS166' => 0x10F568 ,
'SpectraMaster Colors -- GS167' => 0x11F55B ,
'SpectraMaster Colors -- GS168' => 0x11F54E ,
'SpectraMaster Colors -- GS169' => 0x34DC5A ,
'SpectraMaster Colors -- GS170' => 0x21E83D ,
'SpectraMaster Colors -- GS171' => 0x18EF2F ,
'SpectraMaster Colors -- GS172' => 0x10F522 ,
'SpectraMaster Colors -- GS173' => 0x2AE24C ,
'SpectraMaster Colors -- GS174' => 0x11F542 ,
'SpectraMaster Colors -- GS175' => 0x10F534 ,
'SpectraMaster Colors -- GS176' => 0x09FA29 ,
'SpectraMaster Colors -- GS177' => 0x29DB4B ,
'SpectraMaster Colors -- GS178' => 0x20E23E ,
'SpectraMaster Colors -- GS179' => 0x17EB2E ,
'SpectraMaster Colors -- GS180' => 0x0FF221 ,
'SpectraMaster Colors -- GS181' => 0x1CE54F ,
'SpectraMaster Colors -- GS182' => 0x14EC42 ,
'SpectraMaster Colors -- GS183' => 0x0EF238 ,
'SpectraMaster Colors -- GS184' => 0x09F816 ,
'SpectraMaster Colors -- GS185' => 0x36CD7F ,
'SpectraMaster Colors -- GS186' => 0x31D173 ,
'SpectraMaster Colors -- GS187' => 0x31D166 ,
'SpectraMaster Colors -- GS188' => 0x33D359 ,
'SpectraMaster Colors -- GS189' => 0x28DB7F ,
'SpectraMaster Colors -- GS190' => 0x33CF74 ,
'SpectraMaster Colors -- GS191' => 0x28DB69 ,
'SpectraMaster Colors -- GS192' => 0x1DE45B ,
'SpectraMaster Colors -- GS193' => 0x3EC5B0 ,
'SpectraMaster Colors -- GS194' => 0x38CBA4 ,
'SpectraMaster Colors -- GS195' => 0x3AC998 ,
'SpectraMaster Colors -- GS196' => 0x3BC98C ,
'SpectraMaster Colors -- GS197' => 0x34CFB1 ,
'SpectraMaster Colors -- GS198' => 0x2ADCA5 ,
'SpectraMaster Colors -- GS199' => 0x29DB98 ,
'SpectraMaster Colors -- GS200' => 0x28DB8C ,
'SpectraMaster Colors -- GS201' => 0x17E7E2 ,
'SpectraMaster Colors -- GS202' => 0x25DBD6 ,
'SpectraMaster Colors -- GS203' => 0x2FD3CA ,
'SpectraMaster Colors -- GS204' => 0x37CCBE ,
'SpectraMaster Colors -- GS205' => 0x0CF2DF ,
'SpectraMaster Colors -- GS206' => 0x1FE5D5 ,
'SpectraMaster Colors -- GS207' => 0x27DACB ,
'SpectraMaster Colors -- GS208' => 0x27DABF ,
'SpectraMaster Colors -- GS209' => 0x23DBD5 ,
'SpectraMaster Colors -- GS210' => 0x2DD5CC ,
'SpectraMaster Colors -- GS211' => 0x26D9C0 ,
'SpectraMaster Colors -- GS212' => 0x35CCBE ,
'SpectraMaster Colors -- GS213' => 0x15E5DF ,
'SpectraMaster Colors -- GS214' => 0x1BE1D4 ,
'SpectraMaster Colors -- GS215' => 0x1BE2CB ,
'SpectraMaster Colors -- GS216' => 0x1BE2BF ,
'SpectraMaster Colors -- GS217' => 0x0AF2D7 ,
'SpectraMaster Colors -- GS218' => 0x12EAD4 ,
'SpectraMaster Colors -- GS219' => 0x13EACB ,
'SpectraMaster Colors -- GS220' => 0x11ECC1 ,
'SpectraMaster Colors -- GS221' => 0x06F7D6 ,
'SpectraMaster Colors -- GS222' => 0x0AF0DF ,
'SpectraMaster Colors -- GS223' => 0x0AF2CD ,
'SpectraMaster Colors -- GS224' => 0x0AF1C1 ,
'SpectraMaster Colors -- GS225' => 0x3BC5B0 ,
'SpectraMaster Colors -- GS226' => 0x3FC0A5 ,
'SpectraMaster Colors -- GS227' => 0x41BE99 ,
'SpectraMaster Colors -- GS228' => 0x42BC8D ,
'SpectraMaster Colors -- GS229' => 0x2ED1B3 ,
'SpectraMaster Colors -- GS230' => 0x2FCCA5 ,
'SpectraMaster Colors -- GS231' => 0x2ECB97 ,
'SpectraMaster Colors -- GS232' => 0x2ECA8A ,
'SpectraMaster Colors -- GS233' => 0x24D7B3 ,
'SpectraMaster Colors -- GS234' => 0x23D6A5 ,
'SpectraMaster Colors -- GS235' => 0x22D698 ,
'SpectraMaster Colors -- GS236' => 0x22D68B ,
'SpectraMaster Colors -- GS237' => 0x1BE1B5 ,
'SpectraMaster Colors -- GS238' => 0x1AE0A7 ,
'SpectraMaster Colors -- GS239' => 0x19E19A ,
'SpectraMaster Colors -- GS240' => 0x1AE28F ,
'SpectraMaster Colors -- GS241' => 0x12EAB5 ,
'SpectraMaster Colors -- GS242' => 0x12E8A8 ,
'SpectraMaster Colors -- GS243' => 0x12E99B ,
'SpectraMaster Colors -- GS244' => 0x12EB8F ,
'SpectraMaster Colors -- GS245' => 0x0CF0B6 ,
'SpectraMaster Colors -- GS246' => 0x0CEFA9 ,
'SpectraMaster Colors -- GS247' => 0x0CF19B ,
'SpectraMaster Colors -- GS248' => 0x0CF18E ,
'SpectraMaster Colors -- GS249' => 0x42BC82 ,
'SpectraMaster Colors -- GS250' => 0x3DBF75 ,
'SpectraMaster Colors -- GS251' => 0x35C46B ,
'SpectraMaster Colors -- GS252' => 0x2DCB5F ,
'SpectraMaster Colors -- GS253' => 0x2DCA7F ,
'SpectraMaster Colors -- GS254' => 0x2DCB75 ,
'SpectraMaster Colors -- GS255' => 0x22D768 ,
'SpectraMaster Colors -- GS256' => 0x1BE35B ,
'SpectraMaster Colors -- GS257' => 0x23D57E ,
'SpectraMaster Colors -- GS258' => 0x22D571 ,
'SpectraMaster Colors -- GS259' => 0x22D768 ,
'SpectraMaster Colors -- GS260' => 0x2DCB5E ,
'SpectraMaster Colors -- GS261' => 0x1AE282 ,
'SpectraMaster Colors -- GS262' => 0x1AE275 ,
'SpectraMaster Colors -- GS263' => 0x1AE369 ,
'SpectraMaster Colors -- GS264' => 0x1BE35B ,
'SpectraMaster Colors -- GS265' => 0x13EA83 ,
'SpectraMaster Colors -- GS266' => 0x13EB74 ,
'SpectraMaster Colors -- GS267' => 0x13EB69 ,
'SpectraMaster Colors -- GS268' => 0x13EB5B ,
'SpectraMaster Colors -- GS269' => 0x0CF281 ,
'SpectraMaster Colors -- GS270' => 0x0CF275 ,
'SpectraMaster Colors -- GS271' => 0x0DF268 ,
'SpectraMaster Colors -- GS272' => 0x0CF25A ,
'SpectraMaster Colors -- GS273' => 0x24D252 ,
'SpectraMaster Colors -- GS274' => 0x1CDB44 ,
'SpectraMaster Colors -- GS275' => 0x14E537 ,
'SpectraMaster Colors -- GS276' => 0x0CEF37 ,
'SpectraMaster Colors -- GS277' => 0x13EB4F ,
'SpectraMaster Colors -- GS278' => 0x0CF24D ,
'SpectraMaster Colors -- GS279' => 0x0DF141 ,
'SpectraMaster Colors -- GS280' => 0x08F61C ,
'SpectraMaster Colors -- GS281' => 0x1CD351 ,
'SpectraMaster Colors -- GS282' => 0x1CD246 ,
'SpectraMaster Colors -- GS283' => 0x14DE37 ,
'SpectraMaster Colors -- GS284' => 0x0AEE35 ,
'SpectraMaster Colors -- GS285' => 0x1DD35C ,
'SpectraMaster Colors -- GS286' => 0x15DF50 ,
'SpectraMaster Colors -- GS287' => 0x0FE642 ,
'SpectraMaster Colors -- GS288' => 0x07F31B ,
'SpectraMaster Colors -- GS289' => 0x34B581 ,
'SpectraMaster Colors -- GS290' => 0x34B575 ,
'SpectraMaster Colors -- GS291' => 0x32B669 ,
'SpectraMaster Colors -- GS292' => 0x2CBE5F ,
'SpectraMaster Colors -- GS293' => 0x26C68C ,
'SpectraMaster Colors -- GS294' => 0x27C681 ,
'SpectraMaster Colors -- GS295' => 0x26C576 ,
'SpectraMaster Colors -- GS296' => 0x26C668 ,
'SpectraMaster Colors -- GS297' => 0x2BC3B2 ,
'SpectraMaster Colors -- GS298' => 0x2FBCA3 ,
'SpectraMaster Colors -- GS299' => 0x31B794 ,
'SpectraMaster Colors -- GS300' => 0x32B58A ,
'SpectraMaster Colors -- GS301' => 0x1ED4B5 ,
'SpectraMaster Colors -- GS302' => 0x1CD3A7 ,
'SpectraMaster Colors -- GS303' => 0x1CD399 ,
'SpectraMaster Colors -- GS304' => 0x26C699 ,
'SpectraMaster Colors -- GS305' => 0x10E6DF ,
'SpectraMaster Colors -- GS306' => 0x1BDAD4 ,
'SpectraMaster Colors -- GS307' => 0x22D2CA ,
'SpectraMaster Colors -- GS308' => 0x26CBBF ,
'SpectraMaster Colors -- GS309' => 0x09EEDF ,
'SpectraMaster Colors -- GS310' => 0x0FE8D4 ,
'SpectraMaster Colors -- GS311' => 0x17DFCA ,
'SpectraMaster Colors -- GS312' => 0x1FD4C0 ,
'SpectraMaster Colors -- GS313' => 0x0BE6DF ,
'SpectraMaster Colors -- GS314' => 0x14DAD4 ,
'SpectraMaster Colors -- GS315' => 0x18D3CB ,
'SpectraMaster Colors -- GS316' => 0x1BCBC0 ,
'SpectraMaster Colors -- GS317' => 0x07EDE0 ,
'SpectraMaster Colors -- GS318' => 0x0CE6D4 ,
'SpectraMaster Colors -- GS319' => 0x13DBCA ,
'SpectraMaster Colors -- GS320' => 0x12DCC0 ,
'SpectraMaster Colors -- GS321' => 0x07F0D7 ,
'SpectraMaster Colors -- GS322' => 0x06F0CD ,
'SpectraMaster Colors -- GS323' => 0x06EEC1 ,
'SpectraMaster Colors -- GS324' => 0x0BE7C1 ,
'SpectraMaster Colors -- GS325' => 0x07EEB5 ,
'SpectraMaster Colors -- GS326' => 0x08EEA8 ,
'SpectraMaster Colors -- GS327' => 0x08EE9B ,
'SpectraMaster Colors -- GS328' => 0x08EF8E ,
'SpectraMaster Colors -- GS329' => 0x11DBB4 ,
'SpectraMaster Colors -- GS330' => 0x11DEA8 ,
'SpectraMaster Colors -- GS331' => 0x12DC9C ,
'SpectraMaster Colors -- GS332' => 0x11DC8F ,
'SpectraMaster Colors -- GS333' => 0x0CE6B5 ,
'SpectraMaster Colors -- GS334' => 0x0DE6AA ,
'SpectraMaster Colors -- GS335' => 0x0DE69C ,
'SpectraMaster Colors -- GS336' => 0x0CE78F ,
'SpectraMaster Colors -- GS337' => 0x1DC3B4 ,
'SpectraMaster Colors -- GS338' => 0x20BBA5 ,
'SpectraMaster Colors -- GS339' => 0x22B697 ,
'SpectraMaster Colors -- GS340' => 0x25B38B ,
'SpectraMaster Colors -- GS341' => 0x17D0B5 ,
'SpectraMaster Colors -- GS342' => 0x16D0A9 ,
'SpectraMaster Colors -- GS343' => 0x15D09A ,
'SpectraMaster Colors -- GS344' => 0x15D08C ,
'SpectraMaster Colors -- GS345' => 0x26B17E ,
'SpectraMaster Colors -- GS346' => 0x26B172 ,
'SpectraMaster Colors -- GS347' => 0x25B366 ,
'SpectraMaster Colors -- GS348' => 0x25B55B ,
'SpectraMaster Colors -- GS349' => 0x16D081 ,
'SpectraMaster Colors -- GS350' => 0x16D073 ,
'SpectraMaster Colors -- GS351' => 0x17D068 ,
'SpectraMaster Colors -- GS352' => 0x18D05C ,
'SpectraMaster Colors -- GS353' => 0x11DC82 ,
'SpectraMaster Colors -- GS354' => 0x11DC75 ,
'SpectraMaster Colors -- GS355' => 0x11DD68 ,
'SpectraMaster Colors -- GS356' => 0x11DC5B ,
'SpectraMaster Colors -- GS357' => 0x0CE781 ,
'SpectraMaster Colors -- GS358' => 0x0CE774 ,
'SpectraMaster Colors -- GS359' => 0x0CE768 ,
'SpectraMaster Colors -- GS360' => 0x0CE75C ,
'SpectraMaster Colors -- GS361' => 0x08EF80 ,
'SpectraMaster Colors -- GS362' => 0x08EF73 ,
'SpectraMaster Colors -- GS363' => 0x08EF66 ,
'SpectraMaster Colors -- GS364' => 0x08EF59 ,
'SpectraMaster Colors -- GS365' => 0x09EE4E ,
'SpectraMaster Colors -- GS366' => 0x0CE64E ,
'SpectraMaster Colors -- GS367' => 0x0DE642 ,
'SpectraMaster Colors -- GS368' => 0x08EE41 ,
'SpectraMaster Colors -- GS369' => 0x20BC50 ,
'SpectraMaster Colors -- GS370' => 0x1BC746 ,
'SpectraMaster Colors -- GS371' => 0x14D438 ,
'SpectraMaster Colors -- GS372' => 0x09EE34 ,
'SpectraMaster Colors -- GS373' => 0x17D050 ,
'SpectraMaster Colors -- GS374' => 0x12DC4E ,
'SpectraMaster Colors -- GS375' => 0x11DC41 ,
'SpectraMaster Colors -- GS376' => 0x07F01C ,
'SpectraMaster Colors -- GS377' => 0x17B94D ,
'SpectraMaster Colors -- GS378' => 0x16BD41 ,
'SpectraMaster Colors -- GS379' => 0x11CB37 ,
'SpectraMaster Colors -- GS380' => 0x09E434 ,
'SpectraMaster Colors -- GS381' => 0x11CE5B ,
'SpectraMaster Colors -- GS382' => 0x11CD50 ,
'SpectraMaster Colors -- GS383' => 0x0CDB41 ,
'SpectraMaster Colors -- GS384' => 0x05EE1A ,
'SpectraMaster Colors -- GS385' => 0x18B17D ,
'SpectraMaster Colors -- GS386' => 0x19B172 ,
'SpectraMaster Colors -- GS387' => 0x19B265 ,
'SpectraMaster Colors -- GS388' => 0x18B559 ,
'SpectraMaster Colors -- GS389' => 0x0ECF8E ,
'SpectraMaster Colors -- GS390' => 0x0FCF82 ,
'SpectraMaster Colors -- GS391' => 0x10CF75 ,
'SpectraMaster Colors -- GS392' => 0x11CE66 ,
'SpectraMaster Colors -- GS393' => 0x13C4B4 ,
'SpectraMaster Colors -- GS394' => 0x15BCA6 ,
'SpectraMaster Colors -- GS395' => 0x16B799 ,
'SpectraMaster Colors -- GS396' => 0x17B38C ,
'SpectraMaster Colors -- GS397' => 0x0CD9B3 ,
'SpectraMaster Colors -- GS398' => 0x10CDB5 ,
'SpectraMaster Colors -- GS399' => 0x0FCEA8 ,
'SpectraMaster Colors -- GS400' => 0x0FCE9B ,
'SpectraMaster Colors -- GS401' => 0x07E7E0 ,
'SpectraMaster Colors -- GS402' => 0x0DDBD5 ,
'SpectraMaster Colors -- GS403' => 0x10D4CB ,
'SpectraMaster Colors -- GS404' => 0x12CBC0 ,
'SpectraMaster Colors -- GS405' => 0x05ECE0 ,
'SpectraMaster Colors -- GS406' => 0x09E4D4 ,
'SpectraMaster Colors -- GS407' => 0x09E4CA ,
'SpectraMaster Colors -- GS408' => 0x0DD9C0 ,
'SpectraMaster Colors -- GS409' => 0x05E8E0 ,
'SpectraMaster Colors -- GS410' => 0x07DDD6 ,
'SpectraMaster Colors -- GS411' => 0x09D3CA ,
'SpectraMaster Colors -- GS412' => 0x0ACBBF ,
'SpectraMaster Colors -- GS413' => 0x01F4E2 ,
'SpectraMaster Colors -- GS414' => 0x05E4D5 ,
'SpectraMaster Colors -- GS415' => 0x04E6CC ,
'SpectraMaster Colors -- GS416' => 0x07D8BF ,
'SpectraMaster Colors -- GS417' => 0x02EFD8 ,
'SpectraMaster Colors -- GS418' => 0x02EECC ,
'SpectraMaster Colors -- GS419' => 0x02EDC1 ,
'SpectraMaster Colors -- GS420' => 0x04E5C1 ,
'SpectraMaster Colors -- GS421' => 0x03EAB7 ,
'SpectraMaster Colors -- GS422' => 0x04ECA8 ,
'SpectraMaster Colors -- GS423' => 0x04ED9B ,
'SpectraMaster Colors -- GS424' => 0x04ED8E ,
'SpectraMaster Colors -- GS425' => 0x07D8B3 ,
'SpectraMaster Colors -- GS426' => 0x08D9A8 ,
'SpectraMaster Colors -- GS427' => 0x08D99D ,
'SpectraMaster Colors -- GS428' => 0x08D98E ,
'SpectraMaster Colors -- GS429' => 0x05E4B5 ,
'SpectraMaster Colors -- GS430' => 0x06E3A9 ,
'SpectraMaster Colors -- GS431' => 0x06E49B ,
'SpectraMaster Colors -- GS432' => 0x05E48E ,
'SpectraMaster Colors -- GS433' => 0x0BC4B3 ,
'SpectraMaster Colors -- GS434' => 0x0BBDA7 ,
'SpectraMaster Colors -- GS435' => 0x0BB899 ,
'SpectraMaster Colors -- GS436' => 0x0CB48B ,
'SpectraMaster Colors -- GS437' => 0x09D0B6 ,
'SpectraMaster Colors -- GS438' => 0x09CCA8 ,
'SpectraMaster Colors -- GS439' => 0x09CC9A ,
'SpectraMaster Colors -- GS440' => 0x08CC8E ,
'SpectraMaster Colors -- GS441' => 0x0DB27E ,
'SpectraMaster Colors -- GS442' => 0x0DB272 ,
'SpectraMaster Colors -- GS443' => 0x0DB366 ,
'SpectraMaster Colors -- GS444' => 0x0DB658 ,
'SpectraMaster Colors -- GS445' => 0x09CB82 ,
'SpectraMaster Colors -- GS446' => 0x09CB74 ,
'SpectraMaster Colors -- GS447' => 0x0ACB68 ,
'SpectraMaster Colors -- GS448' => 0x0ACC5A ,
'SpectraMaster Colors -- GS449' => 0x07D881 ,
'SpectraMaster Colors -- GS450' => 0x07D974 ,
'SpectraMaster Colors -- GS451' => 0x07D968 ,
'SpectraMaster Colors -- GS452' => 0x07D95B ,
'SpectraMaster Colors -- GS453' => 0x05E481 ,
'SpectraMaster Colors -- GS454' => 0x04E473 ,
'SpectraMaster Colors -- GS455' => 0x04E467 ,
'SpectraMaster Colors -- GS456' => 0x05E45B ,
'SpectraMaster Colors -- GS457' => 0x03EE81 ,
'SpectraMaster Colors -- GS458' => 0x03ED74 ,
'SpectraMaster Colors -- GS459' => 0x03ED67 ,
'SpectraMaster Colors -- GS460' => 0x03ED5C ,
'SpectraMaster Colors -- GS461' => 0x03ED50 ,
'SpectraMaster Colors -- GS462' => 0x05E34E ,
'SpectraMaster Colors -- GS463' => 0x05E341 ,
'SpectraMaster Colors -- GS464' => 0x04ED41 ,
'SpectraMaster Colors -- GS465' => 0x0CBA4D ,
'SpectraMaster Colors -- GS466' => 0x0BC042 ,
'SpectraMaster Colors -- GS467' => 0x0AC536 ,
'SpectraMaster Colors -- GS468' => 0x05E234 ,
'SpectraMaster Colors -- GS469' => 0x08D84E ,
'SpectraMaster Colors -- GS470' => 0x08D841 ,
'SpectraMaster Colors -- GS471' => 0x07DA34 ,
'SpectraMaster Colors -- GS472' => 0x04EA1B ,
'SpectraMaster Colors -- GS473' => 0x05BC4B ,
'SpectraMaster Colors -- GS474' => 0x05C141 ,
'SpectraMaster Colors -- GS475' => 0x05C736 ,
'SpectraMaster Colors -- GS476' => 0x02E61B ,
'SpectraMaster Colors -- GS477' => 0x04D84D ,
'SpectraMaster Colors -- GS478' => 0x04D940 ,
'SpectraMaster Colors -- GS479' => 0x03E334 ,
'SpectraMaster Colors -- GS480' => 0x00F319 ,
'SpectraMaster Colors -- GS481' => 0x06B37E ,
'SpectraMaster Colors -- GS482' => 0x06B371 ,
'SpectraMaster Colors -- GS483' => 0x06B564 ,
'SpectraMaster Colors -- GS484' => 0x05B858 ,
'SpectraMaster Colors -- GS485' => 0x04CB7F ,
'SpectraMaster Colors -- GS486' => 0x05CB72 ,
'SpectraMaster Colors -- GS487' => 0x05CB67 ,
'SpectraMaster Colors -- GS488' => 0x06CB59 ,
'SpectraMaster Colors -- GS489' => 0x06C5B4 ,
'SpectraMaster Colors -- GS490' => 0x06BEA7 ,
'SpectraMaster Colors -- GS491' => 0x06B999 ,
'SpectraMaster Colors -- GS492' => 0x06B58C ,
'SpectraMaster Colors -- GS493' => 0x03D7B2 ,
'SpectraMaster Colors -- GS494' => 0x05CBA7 ,
'SpectraMaster Colors -- GS495' => 0x05CB9A ,
'SpectraMaster Colors -- GS496' => 0x04CA8F ,
'SpectraMaster Colors -- GS497' => 0x03E9E0 ,
'SpectraMaster Colors -- GS498' => 0x04DED6 ,
'SpectraMaster Colors -- GS499' => 0x04D6CC ,
'SpectraMaster Colors -- GS500' => 0x05CEC1 ,
'SpectraMaster Colors -- GS501' => 0x00F4E1 ,
'SpectraMaster Colors -- GS502' => 0x01EDD5 ,
'SpectraMaster Colors -- GS503' => 0x02E4CA ,
'SpectraMaster Colors -- GS504' => 0x03D8BF ,
'SpectraMaster Colors -- GS505' => 0x01E9E1 ,
'SpectraMaster Colors -- GS506' => 0x00DFD7 ,
'SpectraMaster Colors -- GS507' => 0x00D6CC ,
'SpectraMaster Colors -- GS508' => 0x00CEC1 ,
'SpectraMaster Colors -- GS509' => 0x00EED7 ,
'SpectraMaster Colors -- GS510' => 0x00E5D9 ,
'SpectraMaster Colors -- GS511' => 0x00E5CD ,
'SpectraMaster Colors -- GS512' => 0x00D9BF ,
'SpectraMaster Colors -- GS513' => 0x00EECC ,
'SpectraMaster Colors -- GS514' => 0x00E4C0 ,
'SpectraMaster Colors -- GS515' => 0x00E5CD ,
'SpectraMaster Colors -- GS516' => 0x00ECC1 ,
'SpectraMaster Colors -- GS517' => 0x00EBB4 ,
'SpectraMaster Colors -- GS518' => 0x00EBA7 ,
'SpectraMaster Colors -- GS519' => 0x00EB99 ,
'SpectraMaster Colors -- GS520' => 0x00EC8C ,
'SpectraMaster Colors -- GS521' => 0x01D9B4 ,
'SpectraMaster Colors -- GS522' => 0x01D7A7 ,
'SpectraMaster Colors -- GS523' => 0x01D89B ,
'SpectraMaster Colors -- GS524' => 0x01D78C ,
'SpectraMaster Colors -- GS525' => 0x00E2B4 ,
'SpectraMaster Colors -- GS526' => 0x01E2A8 ,
'SpectraMaster Colors -- GS527' => 0x01E399 ,
'SpectraMaster Colors -- GS528' => 0x00E38C ,
'SpectraMaster Colors -- GS529' => 0x00C6B4 ,
'SpectraMaster Colors -- GS530' => 0x01BFA6 ,
'SpectraMaster Colors -- GS531' => 0x01BB99 ,
'SpectraMaster Colors -- GS532' => 0x00B98B ,
'SpectraMaster Colors -- GS533' => 0x01CBB2 ,
'SpectraMaster Colors -- GS534' => 0x01CAA5 ,
'SpectraMaster Colors -- GS535' => 0x01C998 ,
'SpectraMaster Colors -- GS536' => 0x01C98C ,
'SpectraMaster Colors -- GS537' => 0x00B87E ,
'SpectraMaster Colors -- GS538' => 0x00B971 ,
'SpectraMaster Colors -- GS539' => 0x00BA64 ,
'SpectraMaster Colors -- GS540' => 0x00BD57 ,
'SpectraMaster Colors -- GS541' => 0x00CA7F ,
'SpectraMaster Colors -- GS542' => 0x00CA71 ,
'SpectraMaster Colors -- GS543' => 0x00CB66 ,
'SpectraMaster Colors -- GS544' => 0x01CE59 ,
'SpectraMaster Colors -- GS545' => 0x00D77E ,
'SpectraMaster Colors -- GS546' => 0x00D870 ,
'SpectraMaster Colors -- GS547' => 0x00D864 ,
'SpectraMaster Colors -- GS548' => 0x00D857 ,
'SpectraMaster Colors -- GS549' => 0x00E37E ,
'SpectraMaster Colors -- GS550' => 0x00E371 ,
'SpectraMaster Colors -- GS551' => 0x00E365 ,
'SpectraMaster Colors -- GS552' => 0x00E359 ,
'SpectraMaster Colors -- GS553' => 0x00ED7F ,
'SpectraMaster Colors -- GS554' => 0x00ED71 ,
'SpectraMaster Colors -- GS555' => 0x00EC64 ,
'SpectraMaster Colors -- GS556' => 0x00EC58 ,
'SpectraMaster Colors -- GS557' => 0x00EC4C ,
'SpectraMaster Colors -- GS558' => 0x00E24C ,
'SpectraMaster Colors -- GS559' => 0x00E240 ,
'SpectraMaster Colors -- GS560' => 0x00EB3F ,
'SpectraMaster Colors -- GS561' => 0x00C14A ,
'SpectraMaster Colors -- GS562' => 0x00C53F ,
'SpectraMaster Colors -- GS563' => 0x00D832 ,
'SpectraMaster Colors -- GS564' => 0x00EB33 ,
'SpectraMaster Colors -- GS565' => 0x01D74B ,
'SpectraMaster Colors -- GS566' => 0x01D73F ,
'SpectraMaster Colors -- GS567' => 0x00E233 ,
'SpectraMaster Colors -- GS568' => 0x00E11C ,
'SpectraMaster Colors -- GS569' => 0xFBC54C ,
'SpectraMaster Colors -- GS570' => 0xFCCA3E ,
'SpectraMaster Colors -- GS571' => 0xFDD032 ,
'SpectraMaster Colors -- GS572' => 0xFEE01B ,
'SpectraMaster Colors -- GS573' => 0xFED74D ,
'SpectraMaster Colors -- GS574' => 0xFED840 ,
'SpectraMaster Colors -- GS575' => 0xFEE232 ,
'SpectraMaster Colors -- GS576' => 0xFFF41A ,
'SpectraMaster Colors -- GS577' => 0xFABE7F ,
'SpectraMaster Colors -- GS578' => 0xFABE72 ,
'SpectraMaster Colors -- GS579' => 0xFABF65 ,
'SpectraMaster Colors -- GS580' => 0xFBC158 ,
'SpectraMaster Colors -- GS581' => 0xFCCB82 ,
'SpectraMaster Colors -- GS582' => 0xFCCB74 ,
'SpectraMaster Colors -- GS583' => 0xFCCB67 ,
'SpectraMaster Colors -- GS584' => 0xFED85A ,
'SpectraMaster Colors -- GS585' => 0xFEC9B3 ,
'SpectraMaster Colors -- GS586' => 0xFDC4A6 ,
'SpectraMaster Colors -- GS587' => 0xFCC19A ,
'SpectraMaster Colors -- GS588' => 0xFBBE8C ,
'SpectraMaster Colors -- GS589' => 0xFDD8B2 ,
'SpectraMaster Colors -- GS590' => 0xFDD7A6 ,
'SpectraMaster Colors -- GS591' => 0xFDCB9C ,
'SpectraMaster Colors -- GS592' => 0xFCCB8E ,
'SpectraMaster Colors -- GS593' => 0xFFF2E2 ,
'SpectraMaster Colors -- GS594' => 0xFFDFD6 ,
'SpectraMaster Colors -- GS595' => 0xFED9CB ,
'SpectraMaster Colors -- GS596' => 0xFECFBE ,
'SpectraMaster Colors -- GS597' => 0xFFF3E2 ,
'SpectraMaster Colors -- GS598' => 0xFFEED7 ,
'SpectraMaster Colors -- GS599' => 0xFEE5CC ,
'SpectraMaster Colors -- GS600' => 0xFED9BE ,
'SpectraMaster Colors -- GS601' => 0xFEEFE4 ,
'SpectraMaster Colors -- GS602' => 0xFDE2D7 ,
'SpectraMaster Colors -- GS603' => 0xFCD9CA ,
'SpectraMaster Colors -- GS604' => 0xFBD2BE ,
'SpectraMaster Colors -- GS605' => 0xFEEFD6 ,
'SpectraMaster Colors -- GS606' => 0xFEEFCA ,
'SpectraMaster Colors -- GS607' => 0xFDE6CA ,
'SpectraMaster Colors -- GS608' => 0xFCE4C0 ,
'SpectraMaster Colors -- GS609' => 0xFBE3B3 ,
'SpectraMaster Colors -- GS610' => 0xFBE1A7 ,
'SpectraMaster Colors -- GS611' => 0xFBE19A ,
'SpectraMaster Colors -- GS612' => 0xFCE18D ,
'SpectraMaster Colors -- GS613' => 0xFDEAB2 ,
'SpectraMaster Colors -- GS614' => 0xFDEBA5 ,
'SpectraMaster Colors -- GS615' => 0xFEEC99 ,
'SpectraMaster Colors -- GS616' => 0xFEEC8C ,
'SpectraMaster Colors -- GS617' => 0xFBCDB4 ,
'SpectraMaster Colors -- GS618' => 0xF9C8A7 ,
'SpectraMaster Colors -- GS619' => 0xF8C59A ,
'SpectraMaster Colors -- GS620' => 0xF6C38D ,
'SpectraMaster Colors -- GS621' => 0xFBD8B4 ,
'SpectraMaster Colors -- GS622' => 0xFCD7AA ,
'SpectraMaster Colors -- GS623' => 0xFAD89A ,
'SpectraMaster Colors -- GS624' => 0xFAD88E ,
'SpectraMaster Colors -- GS625' => 0xF4C381 ,
'SpectraMaster Colors -- GS626' => 0xF5C273 ,
'SpectraMaster Colors -- GS627' => 0xF5C466 ,
'SpectraMaster Colors -- GS628' => 0xF5C559 ,
'SpectraMaster Colors -- GS629' => 0xFAD881 ,
'SpectraMaster Colors -- GS630' => 0xFAD974 ,
'SpectraMaster Colors -- GS631' => 0xFAD967 ,
'SpectraMaster Colors -- GS632' => 0xFAD85A ,
'SpectraMaster Colors -- GS633' => 0xFCE280 ,
'SpectraMaster Colors -- GS634' => 0xFCE373 ,
'SpectraMaster Colors -- GS635' => 0xFBE465 ,
'SpectraMaster Colors -- GS636' => 0xFBE458 ,
'SpectraMaster Colors -- GS637' => 0xFDEC7F ,
'SpectraMaster Colors -- GS638' => 0xFDEC72 ,
'SpectraMaster Colors -- GS639' => 0xFDED65 ,
'SpectraMaster Colors -- GS640' => 0xFDEC57 ,
'SpectraMaster Colors -- GS641' => 0xF6C94C ,
'SpectraMaster Colors -- GS642' => 0xF7CE3F ,
'SpectraMaster Colors -- GS643' => 0xF8D333 ,
'SpectraMaster Colors -- GS644' => 0xFEEC32 ,
'SpectraMaster Colors -- GS645' => 0xFAD74D ,
'SpectraMaster Colors -- GS646' => 0xFCE340 ,
'SpectraMaster Colors -- GS647' => 0xFDE333 ,
'SpectraMaster Colors -- GS648' => 0xFDE41A ,
'SpectraMaster Colors -- GS649' => 0xF2CC4D ,
'SpectraMaster Colors -- GS650' => 0xF3D141 ,
'SpectraMaster Colors -- GS651' => 0xF5D634 ,
'SpectraMaster Colors -- GS652' => 0xFBE71B ,
'SpectraMaster Colors -- GS653' => 0xF7D84E ,
'SpectraMaster Colors -- GS654' => 0xFAE340 ,
'SpectraMaster Colors -- GS655' => 0xFAE233 ,
'SpectraMaster Colors -- GS656' => 0xFDF418 ,
'SpectraMaster Colors -- GS657' => 0xF0C67F ,
'SpectraMaster Colors -- GS658' => 0xF0C773 ,
'SpectraMaster Colors -- GS659' => 0xF0C767 ,
'SpectraMaster Colors -- GS660' => 0xF1C95A ,
'SpectraMaster Colors -- GS661' => 0xF6D981 ,
'SpectraMaster Colors -- GS662' => 0xF6DA73 ,
'SpectraMaster Colors -- GS663' => 0xF6D967 ,
'SpectraMaster Colors -- GS664' => 0xF6D95A ,
'SpectraMaster Colors -- GS665' => 0xF7D0B2 ,
'SpectraMaster Colors -- GS666' => 0xF5CCA7 ,
'SpectraMaster Colors -- GS667' => 0xF3C99A ,
'SpectraMaster Colors -- GS668' => 0xF0C98B ,
'SpectraMaster Colors -- GS669' => 0xF8D8B4 ,
'SpectraMaster Colors -- GS670' => 0xF7D8A7 ,
'SpectraMaster Colors -- GS671' => 0xF6D89A ,
'SpectraMaster Colors -- GS672' => 0xF6D98E ,
'SpectraMaster Colors -- GS673' => 0xFCF1E3 ,
'SpectraMaster Colors -- GS674' => 0xFBE6D6 ,
'SpectraMaster Colors -- GS675' => 0xFADBCB ,
'SpectraMaster Colors -- GS676' => 0xF9D5BF ,
'SpectraMaster Colors -- GS677' => 0xFDF3E3 ,
'SpectraMaster Colors -- GS678' => 0xFDEED5 ,
'SpectraMaster Colors -- GS679' => 0xFBE6CB ,
'SpectraMaster Colors -- GS680' => 0xFBE5C0 ,
'SpectraMaster Colors -- GS681' => 0xFBF2E4 ,
'SpectraMaster Colors -- GS682' => 0xF9E7D7 ,
'SpectraMaster Colors -- GS683' => 0xF8DECC ,
'SpectraMaster Colors -- GS684' => 0xF7D7C0 ,
'SpectraMaster Colors -- GS685' => 0xFBEED6 ,
'SpectraMaster Colors -- GS686' => 0xFBEFCA ,
'SpectraMaster Colors -- GS687' => 0xF9E5CB ,
'SpectraMaster Colors -- GS688' => 0xF9E4C0 ,
'SpectraMaster Colors -- GS689' => 0xF8E3B4 ,
'SpectraMaster Colors -- GS690' => 0xF6E2A5 ,
'SpectraMaster Colors -- GS691' => 0xF6E299 ,
'SpectraMaster Colors -- GS692' => 0xF6E28D ,
'SpectraMaster Colors -- GS693' => 0xFAECB2 ,
'SpectraMaster Colors -- GS694' => 0xF9EBA6 ,
'SpectraMaster Colors -- GS695' => 0xF8EA9A ,
'SpectraMaster Colors -- GS696' => 0xF9EB8D ,
'SpectraMaster Colors -- GS697' => 0xF4D2B3 ,
'SpectraMaster Colors -- GS698' => 0xF2CFA6 ,
'SpectraMaster Colors -- GS699' => 0xEFCD99 ,
'SpectraMaster Colors -- GS700' => 0xEDCB8C ,
'SpectraMaster Colors -- GS701' => 0xF5D8B3 ,
'SpectraMaster Colors -- GS702' => 0xF4D8A6 ,
'SpectraMaster Colors -- GS703' => 0xF3D99B ,
'SpectraMaster Colors -- GS704' => 0xF3DA8E ,
'SpectraMaster Colors -- GS705' => 0xECCB80 ,
'SpectraMaster Colors -- GS706' => 0xECCA73 ,
'SpectraMaster Colors -- GS707' => 0xECCB66 ,
'SpectraMaster Colors -- GS708' => 0xEDCD5A ,
'SpectraMaster Colors -- GS709' => 0xF3D784 ,
'SpectraMaster Colors -- GS710' => 0xF3DA74 ,
'SpectraMaster Colors -- GS711' => 0xF3DA67 ,
'SpectraMaster Colors -- GS712' => 0xF3DA5B ,
'SpectraMaster Colors -- GS713' => 0xF6E380 ,
'SpectraMaster Colors -- GS714' => 0xF7E472 ,
'SpectraMaster Colors -- GS715' => 0xF6E665 ,
'SpectraMaster Colors -- GS716' => 0xF6E659 ,
'SpectraMaster Colors -- GS717' => 0xF9EC7F ,
'SpectraMaster Colors -- GS718' => 0xFAED71 ,
'SpectraMaster Colors -- GS719' => 0xF9EE65 ,
'SpectraMaster Colors -- GS720' => 0xF9EE57 ,
'SpectraMaster Colors -- GS721' => 0xEFCF4E ,
'SpectraMaster Colors -- GS722' => 0xF0D341 ,
'SpectraMaster Colors -- GS723' => 0xF2D934 ,
'SpectraMaster Colors -- GS724' => 0xFAED34 ,
'SpectraMaster Colors -- GS725' => 0xF3D94E ,
'SpectraMaster Colors -- GS726' => 0xF7E441 ,
'SpectraMaster Colors -- GS727' => 0xF7E434 ,
'SpectraMaster Colors -- GS728' => 0xF8E61A ,
'SpectraMaster Colors -- GS729' => 0xEBD24F ,
'SpectraMaster Colors -- GS730' => 0xEDD642 ,
'SpectraMaster Colors -- GS731' => 0xEFDB34 ,
'SpectraMaster Colors -- GS732' => 0xF5E919 ,
'SpectraMaster Colors -- GS733' => 0xF4E64C ,
'SpectraMaster Colors -- GS734' => 0xF4E540 ,
'SpectraMaster Colors -- GS735' => 0xF4E434 ,
'SpectraMaster Colors -- GS736' => 0xFBF519 ,
'SpectraMaster Colors -- GS737' => 0xE8CE80 ,
'SpectraMaster Colors -- GS738' => 0xE8CE73 ,
'SpectraMaster Colors -- GS739' => 0xE8CE68 ,
'SpectraMaster Colors -- GS740' => 0xEAD05B ,
'SpectraMaster Colors -- GS741' => 0xF0DC81 ,
'SpectraMaster Colors -- GS742' => 0xF0DC74 ,
'SpectraMaster Colors -- GS743' => 0xF0DC67 ,
'SpectraMaster Colors -- GS744' => 0xEFDC5A ,
'SpectraMaster Colors -- GS745' => 0xF1D5B3 ,
'SpectraMaster Colors -- GS746' => 0xEFD2A6 ,
'SpectraMaster Colors -- GS747' => 0xEBD099 ,
'SpectraMaster Colors -- GS748' => 0xE9CE8C ,
'SpectraMaster Colors -- GS749' => 0xF5E5B2 ,
'SpectraMaster Colors -- GS750' => 0xF1DBA7 ,
'SpectraMaster Colors -- GS751' => 0xF0DB9A ,
'SpectraMaster Colors -- GS752' => 0xF0DC8D ,
'SpectraMaster Colors -- GS753' => 0xF9F4E4 ,
'SpectraMaster Colors -- GS754' => 0xF8E9D8 ,
'SpectraMaster Colors -- GS755' => 0xF6E1CC ,
'SpectraMaster Colors -- GS756' => 0xF4DAC0 ,
'SpectraMaster Colors -- GS757' => 0xFCF8E2 ,
'SpectraMaster Colors -- GS758' => 0xFAEED6 ,
'SpectraMaster Colors -- GS759' => 0xFAF0CB ,
'SpectraMaster Colors -- GS760' => 0xF7E6C1 ,
'SpectraMaster Colors -- GS901' => 0x00B87E ,
'SpectraMaster Colors -- GS902' => 0x00BD57 ,
'SpectraMaster Colors -- GS903' => 0x00C14A ,
'SpectraMaster Colors -- GS904' => 0x00D732 ,
'SpectraMaster Colors -- GS905' => 0x0DB366 ,
'SpectraMaster Colors -- GS906' => 0x0CBA4D ,
'SpectraMaster Colors -- GS907' => 0x0BBF42 ,
'SpectraMaster Colors -- GS908' => 0x11CB37 ,
'SpectraMaster Colors -- GS909' => 0x18B559 ,
'SpectraMaster Colors -- GS910' => 0x25D252 ,
'SpectraMaster Colors -- GS911' => 0x1CD246 ,
'SpectraMaster Colors -- GS912' => 0x0CDA41 ,
'SpectraMaster Colors -- GS913' => 0x25B366 ,
'SpectraMaster Colors -- GS914' => 0x20BC51 ,
'SpectraMaster Colors -- GS915' => 0x12CD50 ,
'SpectraMaster Colors -- GS916' => 0x08D841 ,
'SpectraMaster Colors -- LS001' => 0x0200F4 ,
'SpectraMaster Colors -- LS002' => 0x0000E6 ,
'SpectraMaster Colors -- LS003' => 0x0000F0 ,
'SpectraMaster Colors -- LS004' => 0xFF00EC ,
'SpectraMaster Colors -- LS005' => 0x0100EF ,
'SpectraMaster Colors -- LS006' => 0x0100EC ,
'SpectraMaster Colors -- LS007' => 0x0000F1 ,
'SpectraMaster Colors -- LS008' => 0xFE00EB ,
'SpectraMaster Colors -- LS009' => 0x0100EB ,
'SpectraMaster Colors -- LS010' => 0x0300EB ,
'SpectraMaster Colors -- LS011' => 0x0500ED ,
'SpectraMaster Colors -- LS012' => 0x0700ED ,
'SpectraMaster Colors -- LS013' => 0x0100EF ,
'SpectraMaster Colors -- LS014' => 0x0400F2 ,
'SpectraMaster Colors -- LS015' => 0x0500E8 ,
'SpectraMaster Colors -- LS016' => 0x0900E8 ,
'SpectraMaster Colors -- LS017' => 0x0301E8 ,
'SpectraMaster Colors -- LS018' => 0x0202E9 ,
'SpectraMaster Colors -- LS019' => 0x0403EE ,
'SpectraMaster Colors -- LS020' => 0x0803EB ,
'SpectraMaster Colors -- LS021' => 0xFD01E8 ,
'SpectraMaster Colors -- LS022' => 0xFD00E9 ,
'SpectraMaster Colors -- LS023' => 0x0002EE ,
'SpectraMaster Colors -- LS024' => 0x0004EE ,
'SpectraMaster Colors -- LS025' => 0xFEFCEB ,
'SpectraMaster Colors -- LS026' => 0xFDFFE9 ,
'SpectraMaster Colors -- LS027' => 0xFCFDE9 ,
'SpectraMaster Colors -- LS028' => 0x00FEED ,
'SpectraMaster Colors -- LS029' => 0xFFFDEA ,
'SpectraMaster Colors -- LS030' => 0x00FCF0 ,
'SpectraMaster Colors -- LS031' => 0x01FDE7 ,
'SpectraMaster Colors -- LS032' => 0x00FCE8 ,
'SpectraMaster Colors -- LS033' => 0x0000E0 ,
'SpectraMaster Colors -- LS034' => 0x0000D6 ,
'SpectraMaster Colors -- LS035' => 0x0000CC ,
'SpectraMaster Colors -- LS036' => 0x0000BF ,
'SpectraMaster Colors -- LS037' => 0x0000B2 ,
'SpectraMaster Colors -- LS038' => 0xFF00A5 ,
'SpectraMaster Colors -- LS039' => 0xFF0099 ,
'SpectraMaster Colors -- LS040' => 0xFF008C ,
'SpectraMaster Colors -- LS041' => 0xF903E1 ,
'SpectraMaster Colors -- LS042' => 0xFC02D5 ,
'SpectraMaster Colors -- LS043' => 0xFC02CA ,
'SpectraMaster Colors -- LS044' => 0xFC03C0 ,
'SpectraMaster Colors -- LS045' => 0xFC03B4 ,
'SpectraMaster Colors -- LS046' => 0xFC03A7 ,
'SpectraMaster Colors -- LS047' => 0xFC029B ,
'SpectraMaster Colors -- LS048' => 0xFC038E ,
'SpectraMaster Colors -- LS049' => 0xF606DE ,
'SpectraMaster Colors -- LS050' => 0xF606D3 ,
'SpectraMaster Colors -- LS051' => 0xF807CC ,
'SpectraMaster Colors -- LS052' => 0xF808C1 ,
'SpectraMaster Colors -- LS053' => 0xF809B4 ,
'SpectraMaster Colors -- LS054' => 0xF809A9 ,
'SpectraMaster Colors -- LS055' => 0xF8079A ,
'SpectraMaster Colors -- LS056' => 0xF80790 ,
'SpectraMaster Colors -- LS057' => 0xFC0AE1 ,
'SpectraMaster Colors -- LS058' => 0xFC09D6 ,
'SpectraMaster Colors -- LS059' => 0xFC09CB ,
'SpectraMaster Colors -- LS060' => 0xFB09BE ,
'SpectraMaster Colors -- LS061' => 0xFB0AB4 ,
'SpectraMaster Colors -- LS062' => 0xFC0BA8 ,
'SpectraMaster Colors -- LS063' => 0xFD0A9B ,
'SpectraMaster Colors -- LS064' => 0xFC0A8D ,
'SpectraMaster Colors -- LS065' => 0x0005E2 ,
'SpectraMaster Colors -- LS066' => 0x0004D6 ,
'SpectraMaster Colors -- LS067' => 0x0004CB ,
'SpectraMaster Colors -- LS068' => 0x0005C0 ,
'SpectraMaster Colors -- LS069' => 0x0005B3 ,
'SpectraMaster Colors -- LS070' => 0x0005A6 ,
'SpectraMaster Colors -- LS071' => 0x000599 ,
'SpectraMaster Colors -- LS072' => 0x00058B ,
'SpectraMaster Colors -- LS073' => 0x010CE0 ,
'SpectraMaster Colors -- LS074' => 0x010AD7 ,
'SpectraMaster Colors -- LS075' => 0x0009CB ,
'SpectraMaster Colors -- LS076' => 0x000ABF ,
'SpectraMaster Colors -- LS077' => 0x010BB3 ,
'SpectraMaster Colors -- LS078' => 0x020CA6 ,
'SpectraMaster Colors -- LS079' => 0x010B99 ,
'SpectraMaster Colors -- LS080' => 0x010B8C ,
'SpectraMaster Colors -- LS081' => 0x060BE3 ,
'SpectraMaster Colors -- LS082' => 0x0408D7 ,
'SpectraMaster Colors -- LS083' => 0x0408CC ,
'SpectraMaster Colors -- LS084' => 0x0509BF ,
'SpectraMaster Colors -- LS085' => 0x050BB2 ,
'SpectraMaster Colors -- LS086' => 0x060BA5 ,
'SpectraMaster Colors -- LS087' => 0x050A98 ,
'SpectraMaster Colors -- LS088' => 0x040A8B ,
'SpectraMaster Colors -- LS089' => 0x0302E4 ,
'SpectraMaster Colors -- LS090' => 0x0302D9 ,
'SpectraMaster Colors -- LS091' => 0x0303CD ,
'SpectraMaster Colors -- LS092' => 0x0304C1 ,
'SpectraMaster Colors -- LS093' => 0x0304B4 ,
'SpectraMaster Colors -- LS094' => 0x0303A7 ,
'SpectraMaster Colors -- LS095' => 0x03039A ,
'SpectraMaster Colors -- LS096' => 0x03038C ,
'SpectraMaster Colors -- LS097' => 0x0A0AE4 ,
'SpectraMaster Colors -- LS098' => 0x0706DA ,
'SpectraMaster Colors -- LS099' => 0x0807CE ,
'SpectraMaster Colors -- LS100' => 0x0708C2 ,
'SpectraMaster Colors -- LS101' => 0x0808B5 ,
'SpectraMaster Colors -- LS102' => 0x0808A8 ,
'SpectraMaster Colors -- LS103' => 0x08079A ,
'SpectraMaster Colors -- LS104' => 0x08078D ,
'SpectraMaster Colors -- LS105' => 0x0A03E5 ,
'SpectraMaster Colors -- LS106' => 0x0902DA ,
'SpectraMaster Colors -- LS107' => 0x0903D0 ,
'SpectraMaster Colors -- LS108' => 0x0904C3 ,
'SpectraMaster Colors -- LS109' => 0x0904B5 ,
'SpectraMaster Colors -- LS110' => 0x0A04A8 ,
'SpectraMaster Colors -- LS111' => 0x0A039A ,
'SpectraMaster Colors -- LS112' => 0x0A038C ,
'SpectraMaster Colors -- LS113' => 0x0500E2 ,
'SpectraMaster Colors -- LS114' => 0x0400D8 ,
'SpectraMaster Colors -- LS115' => 0x0400CC ,
'SpectraMaster Colors -- LS116' => 0x0300C2 ,
'SpectraMaster Colors -- LS117' => 0x0300B4 ,
'SpectraMaster Colors -- LS118' => 0x0300A6 ,
'SpectraMaster Colors -- LS119' => 0x04009A ,
'SpectraMaster Colors -- LS120' => 0x04008C ,
'SpectraMaster Colors -- LS121' => 0x0B00E3 ,
'SpectraMaster Colors -- LS122' => 0x0A00D8 ,
'SpectraMaster Colors -- LS123' => 0x0900CD ,
'SpectraMaster Colors -- LS124' => 0x0900C3 ,
'SpectraMaster Colors -- LS125' => 0x0A00B4 ,
'SpectraMaster Colors -- LS126' => 0x0B00A7 ,
'SpectraMaster Colors -- LS127' => 0x0B009A ,
'SpectraMaster Colors -- LS128' => 0x0B008D ,
'SpectraMaster Colors -- LS129' => 0x0AFBE3 ,
'SpectraMaster Colors -- LS130' => 0x09FBD6 ,
'SpectraMaster Colors -- LS131' => 0x08FBCC ,
'SpectraMaster Colors -- LS132' => 0x09FBC1 ,
'SpectraMaster Colors -- LS133' => 0x0AFBB5 ,
'SpectraMaster Colors -- LS134' => 0x0AFCA8 ,
'SpectraMaster Colors -- LS135' => 0x0AFD9B ,
'SpectraMaster Colors -- LS136' => 0x0AFD8D ,
'SpectraMaster Colors -- LS137' => 0x02FCE1 ,
'SpectraMaster Colors -- LS138' => 0x02FCD5 ,
'SpectraMaster Colors -- LS139' => 0x02FCCB ,
'SpectraMaster Colors -- LS140' => 0x02FBC1 ,
'SpectraMaster Colors -- LS141' => 0x03FBB5 ,
'SpectraMaster Colors -- LS142' => 0x03FCA8 ,
'SpectraMaster Colors -- LS143' => 0x03FC9A ,
'SpectraMaster Colors -- LS144' => 0x03FC8D ,
'SpectraMaster Colors -- LS145' => 0x07F6E2 ,
'SpectraMaster Colors -- LS146' => 0x06F7D6 ,
'SpectraMaster Colors -- LS147' => 0x06F7CC ,
'SpectraMaster Colors -- LS148' => 0x05F6C1 ,
'SpectraMaster Colors -- LS149' => 0x07F6B5 ,
'SpectraMaster Colors -- LS150' => 0x07F6A8 ,
'SpectraMaster Colors -- LS151' => 0x07F79B ,
'SpectraMaster Colors -- LS152' => 0x07F78E ,
'SpectraMaster Colors -- LS153' => 0x01F4E2 ,
'SpectraMaster Colors -- LS154' => 0x01F5D6 ,
'SpectraMaster Colors -- LS155' => 0x01F4CB ,
'SpectraMaster Colors -- LS156' => 0x01F4C0 ,
'SpectraMaster Colors -- LS157' => 0x02F3B4 ,
'SpectraMaster Colors -- LS158' => 0x01F4A7 ,
'SpectraMaster Colors -- LS159' => 0x02F49A ,
'SpectraMaster Colors -- LS160' => 0x02F58D ,
'SpectraMaster Colors -- LS161' => 0x00FBE1 ,
'SpectraMaster Colors -- LS162' => 0xFFFBD5 ,
'SpectraMaster Colors -- LS163' => 0xFFFBCB ,
'SpectraMaster Colors -- LS164' => 0xFFFAC0 ,
'SpectraMaster Colors -- LS165' => 0xFFFAB3 ,
'SpectraMaster Colors -- LS166' => 0xFFFAA7 ,
'SpectraMaster Colors -- LS167' => 0xFFFA99 ,
'SpectraMaster Colors -- LS168' => 0xFFFB8C ,
'SpectraMaster Colors -- LS169' => 0xFEF3E2 ,
'SpectraMaster Colors -- LS170' => 0xFFF5D4 ,
'SpectraMaster Colors -- LS171' => 0xFEF5CA ,
'SpectraMaster Colors -- LS172' => 0xFEF3BF ,
'SpectraMaster Colors -- LS173' => 0xFEF3B3 ,
'SpectraMaster Colors -- LS174' => 0xFEF3A5 ,
'SpectraMaster Colors -- LS175' => 0xFFF499 ,
'SpectraMaster Colors -- LS176' => 0xFFF48C ,
'SpectraMaster Colors -- LS177' => 0xF9F5E4 ,
'SpectraMaster Colors -- LS178' => 0xFCF6D5 ,
'SpectraMaster Colors -- LS179' => 0xFCF7C9 ,
'SpectraMaster Colors -- LS180' => 0xFBF6BF ,
'SpectraMaster Colors -- LS181' => 0xFAF6B4 ,
'SpectraMaster Colors -- LS182' => 0xF9F5A8 ,
'SpectraMaster Colors -- LS183' => 0xF8F49A ,
'SpectraMaster Colors -- LS184' => 0xF9F58D ,
'SpectraMaster Colors -- LS185' => 0xFCFBE2 ,
'SpectraMaster Colors -- LS186' => 0xFDFDD4 ,
'SpectraMaster Colors -- LS187' => 0xFDFDC9 ,
'SpectraMaster Colors -- LS188' => 0xFDFEC0 ,
'SpectraMaster Colors -- LS189' => 0xFCFEB5 ,
'SpectraMaster Colors -- LS190' => 0xFCFEA7 ,
'SpectraMaster Colors -- LS191' => 0xFCFD98 ,
'SpectraMaster Colors -- LS192' => 0xFCFD8D ,
'SpectraMaster Colors -- LS193' => 0xF6F7E1 ,
'SpectraMaster Colors -- LS194' => 0xF8F9D4 ,
'SpectraMaster Colors -- LS195' => 0xF9FAC9 ,
'SpectraMaster Colors -- LS196' => 0xF9FBBE ,
'SpectraMaster Colors -- LS197' => 0xF8FAB4 ,
'SpectraMaster Colors -- LS198' => 0xF7F9A6 ,
'SpectraMaster Colors -- LS199' => 0xF6F898 ,
'SpectraMaster Colors -- LS200' => 0xF6F88D ,
'SpectraMaster Colors -- LS201' => 0xF7FDE3 ,
'SpectraMaster Colors -- LS202' => 0xF6FCD6 ,
'SpectraMaster Colors -- LS203' => 0xF7FECB ,
'SpectraMaster Colors -- LS204' => 0xF7FEC0 ,
'SpectraMaster Colors -- LS205' => 0xF6FEB5 ,
'SpectraMaster Colors -- LS206' => 0xF5FEA7 ,
'SpectraMaster Colors -- LS207' => 0xF5FD9A ,
'SpectraMaster Colors -- LS208' => 0xF5FC8C ,
'SpectraMaster Colors -- LS209' => 0xFA00E2 ,
'SpectraMaster Colors -- LS210' => 0xFB00D5 ,
'SpectraMaster Colors -- LS211' => 0xFC00CA ,
'SpectraMaster Colors -- LS212' => 0xFB00BF ,
'SpectraMaster Colors -- LS213' => 0xFB01B4 ,
'SpectraMaster Colors -- LS214' => 0xFB01A8 ,
'SpectraMaster Colors -- LS215' => 0xFB009B ,
'SpectraMaster Colors -- LS216' => 0xFB008D ,
'SpectraMaster Colors -- LS217' => 0xF600E0 ,
'SpectraMaster Colors -- LS218' => 0xF400D4 ,
'SpectraMaster Colors -- LS219' => 0xF600CB ,
'SpectraMaster Colors -- LS220' => 0xF601C1 ,
'SpectraMaster Colors -- LS221' => 0xF602B5 ,
'SpectraMaster Colors -- LS222' => 0xF602A9 ,
'SpectraMaster Colors -- LS223' => 0xF5009B ,
'SpectraMaster Colors -- LS224' => 0xF5008C ,
'SpectraMaster Colors -- LS225' => 0xF604E0 ,
'SpectraMaster Colors -- LS226' => 0xF403D4 ,
'SpectraMaster Colors -- LS227' => 0xF704CC ,
'SpectraMaster Colors -- LS228' => 0xF705C1 ,
'SpectraMaster Colors -- LS229' => 0xF706B6 ,
'SpectraMaster Colors -- LS230' => 0xF606A9 ,
'SpectraMaster Colors -- LS231' => 0xF7059C ,
'SpectraMaster Colors -- LS232' => 0xF6048E ,
'SpectraMaster Colors -- RS001' => 0xF905E3 ,
'SpectraMaster Colors -- RS002' => 0xF209D4 ,
'SpectraMaster Colors -- RS003' => 0xED0DC8 ,
'SpectraMaster Colors -- RS004' => 0xE910BE ,
'SpectraMaster Colors -- RS005' => 0xF20ABF ,
'SpectraMaster Colors -- RS006' => 0xF30FB5 ,
'SpectraMaster Colors -- RS007' => 0xEE0EB5 ,
'SpectraMaster Colors -- RS008' => 0xE613B3 ,
'SpectraMaster Colors -- RS009' => 0xEB11A7 ,
'SpectraMaster Colors -- RS010' => 0xEA129B ,
'SpectraMaster Colors -- RS011' => 0xE4178E ,
'SpectraMaster Colors -- RS012' => 0xE11982 ,
'SpectraMaster Colors -- RS013' => 0xE317A7 ,
'SpectraMaster Colors -- RS014' => 0xE01B9B ,
'SpectraMaster Colors -- RS015' => 0xDD1D8E ,
'SpectraMaster Colors -- RS016' => 0xDB1E84 ,
'SpectraMaster Colors -- RS017' => 0xF30F9E ,
'SpectraMaster Colors -- RS018' => 0xF30F90 ,
'SpectraMaster Colors -- RS019' => 0xF30D82 ,
'SpectraMaster Colors -- RS020' => 0xF20D75 ,
'SpectraMaster Colors -- RS021' => 0xF310AA ,
'SpectraMaster Colors -- RS022' => 0xE9128E ,
'SpectraMaster Colors -- RS023' => 0xEC1685 ,
'SpectraMaster Colors -- RS024' => 0xEB1477 ,
'SpectraMaster Colors -- RS025' => 0xF10C68 ,
'SpectraMaster Colors -- RS026' => 0xF10C5B ,
'SpectraMaster Colors -- RS027' => 0xF10C4E ,
'SpectraMaster Colors -- RS028' => 0xF00C41 ,
'SpectraMaster Colors -- RS029' => 0xEA136A ,
'SpectraMaster Colors -- RS030' => 0xEA125D ,
'SpectraMaster Colors -- RS031' => 0xEA124F ,
'SpectraMaster Colors -- RS032' => 0xEA1241 ,
'SpectraMaster Colors -- RS033' => 0xE21876 ,
'SpectraMaster Colors -- RS034' => 0xE21769 ,
'SpectraMaster Colors -- RS035' => 0xE1185A ,
'SpectraMaster Colors -- RS036' => 0xE1174D ,
'SpectraMaster Colors -- RS037' => 0xD82076 ,
'SpectraMaster Colors -- RS038' => 0xD6206A ,
'SpectraMaster Colors -- RS039' => 0xD5215C ,
'SpectraMaster Colors -- RS040' => 0xD5224E ,
'SpectraMaster Colors -- RS041' => 0xE11840 ,
'SpectraMaster Colors -- RS042' => 0xE31733 ,
'SpectraMaster Colors -- RS043' => 0xF00C34 ,
'SpectraMaster Colors -- RS044' => 0xF10C19 ,
'SpectraMaster Colors -- RS045' => 0xD62141 ,
'SpectraMaster Colors -- RS046' => 0xD92035 ,
'SpectraMaster Colors -- RS047' => 0xEA1133 ,
'SpectraMaster Colors -- RS048' => 0xE2191B ,
'SpectraMaster Colors -- RS049' => 0xED143D ,
'SpectraMaster Colors -- RS050' => 0xED1331 ,
'SpectraMaster Colors -- RS051' => 0xF30D32 ,
'SpectraMaster Colors -- RS052' => 0xF20E19 ,
'SpectraMaster Colors -- RS053' => 0xEC154B ,
'SpectraMaster Colors -- RS054' => 0xDC2541 ,
'SpectraMaster Colors -- RS055' => 0xDE2334 ,
'SpectraMaster Colors -- RS056' => 0xE61B1A ,
'SpectraMaster Colors -- RS057' => 0xE51C76 ,
'SpectraMaster Colors -- RS058' => 0xE51C68 ,
'SpectraMaster Colors -- RS059' => 0xE51D5A ,
'SpectraMaster Colors -- RS060' => 0xE41D4D ,
'SpectraMaster Colors -- RS061' => 0xDE2678 ,
'SpectraMaster Colors -- RS062' => 0xDC276A ,
'SpectraMaster Colors -- RS063' => 0xDC275B ,
'SpectraMaster Colors -- RS064' => 0xDC274E ,
'SpectraMaster Colors -- RS065' => 0xED13A8 ,
'SpectraMaster Colors -- RS066' => 0xEC149C ,
'SpectraMaster Colors -- RS067' => 0xE61C8F ,
'SpectraMaster Colors -- RS068' => 0xE61C83 ,
'SpectraMaster Colors -- RS069' => 0xE61BA8 ,
'SpectraMaster Colors -- RS070' => 0xE31F9B ,
'SpectraMaster Colors -- RS071' => 0xE1238E ,
'SpectraMaster Colors -- RS072' => 0xE02483 ,
'SpectraMaster Colors -- RS073' => 0xEF0FC8 ,
'SpectraMaster Colors -- RS074' => 0xF40BBF ,
'SpectraMaster Colors -- RS075' => 0xF40BB5 ,
'SpectraMaster Colors -- RS076' => 0xF20CA9 ,
'SpectraMaster Colors -- RS077' => 0xEB13BE ,
'SpectraMaster Colors -- RS078' => 0xEE11B6 ,
'SpectraMaster Colors -- RS079' => 0xE917B4 ,
'SpectraMaster Colors -- RS080' => 0xEB148F ,
'SpectraMaster Colors -- RS081' => 0xFA08E2 ,
'SpectraMaster Colors -- RS082' => 0xF60DCB ,
'SpectraMaster Colors -- RS083' => 0xF50EC1 ,
'SpectraMaster Colors -- RS084' => 0xF40FB5 ,
'SpectraMaster Colors -- RS085' => 0xF40BD6 ,
'SpectraMaster Colors -- RS086' => 0xF50ED5 ,
'SpectraMaster Colors -- RS087' => 0xF213CB ,
'SpectraMaster Colors -- RS088' => 0xEE17BF ,
'SpectraMaster Colors -- RS089' => 0xF014B4 ,
'SpectraMaster Colors -- RS090' => 0xEF15A8 ,
'SpectraMaster Colors -- RS091' => 0xEE189D ,
'SpectraMaster Colors -- RS092' => 0xE8208E ,
'SpectraMaster Colors -- RS093' => 0xEB1CB3 ,
'SpectraMaster Colors -- RS094' => 0xE820A5 ,
'SpectraMaster Colors -- RS095' => 0xE52499 ,
'SpectraMaster Colors -- RS096' => 0xE4288D ,
'SpectraMaster Colors -- RS097' => 0xE92081 ,
'SpectraMaster Colors -- RS098' => 0xE92074 ,
'SpectraMaster Colors -- RS099' => 0xE92167 ,
'SpectraMaster Colors -- RS100' => 0xE92059 ,
'SpectraMaster Colors -- RS101' => 0xE32A82 ,
'SpectraMaster Colors -- RS102' => 0xE22D75 ,
'SpectraMaster Colors -- RS103' => 0xE22E6A ,
'SpectraMaster Colors -- RS104' => 0xE12E5B ,
'SpectraMaster Colors -- RS105' => 0xF50F9D ,
'SpectraMaster Colors -- RS106' => 0xF50F90 ,
'SpectraMaster Colors -- RS107' => 0xF50F80 ,
'SpectraMaster Colors -- RS108' => 0xF40F74 ,
'SpectraMaster Colors -- RS109' => 0xF40FA9 ,
'SpectraMaster Colors -- RS110' => 0xEF1791 ,
'SpectraMaster Colors -- RS111' => 0xEF1782 ,
'SpectraMaster Colors -- RS112' => 0xEF1773 ,
'SpectraMaster Colors -- RS113' => 0xF40F66 ,
'SpectraMaster Colors -- RS114' => 0xF50F59 ,
'SpectraMaster Colors -- RS115' => 0xF5104C ,
'SpectraMaster Colors -- RS116' => 0xF51032 ,
'SpectraMaster Colors -- RS117' => 0xEF1764 ,
'SpectraMaster Colors -- RS118' => 0xEF1757 ,
'SpectraMaster Colors -- RS119' => 0xEF174A ,
'SpectraMaster Colors -- RS120' => 0xF5103F ,
'SpectraMaster Colors -- RS121' => 0xE9204C ,
'SpectraMaster Colors -- RS122' => 0xEF163D ,
'SpectraMaster Colors -- RS123' => 0xF0162F ,
'SpectraMaster Colors -- RS124' => 0xF31018 ,
'SpectraMaster Colors -- RS125' => 0xE12C4E ,
'SpectraMaster Colors -- RS126' => 0xE22A41 ,
'SpectraMaster Colors -- RS127' => 0xE32734 ,
'SpectraMaster Colors -- RS128' => 0xEA1D1A ,
'SpectraMaster Colors -- RS129' => 0xF2194D ,
'SpectraMaster Colors -- RS130' => 0xF11940 ,
'SpectraMaster Colors -- RS131' => 0xF11932 ,
'SpectraMaster Colors -- RS132' => 0xF71032 ,
'SpectraMaster Colors -- RS133' => 0xE82F41 ,
'SpectraMaster Colors -- RS134' => 0xEA2B35 ,
'SpectraMaster Colors -- RS135' => 0xEE201B ,
'SpectraMaster Colors -- RS136' => 0xF51218 ,
'SpectraMaster Colors -- RS137' => 0xEC2375 ,
'SpectraMaster Colors -- RS138' => 0xEC2368 ,
'SpectraMaster Colors -- RS139' => 0xEC245B ,
'SpectraMaster Colors -- RS140' => 0xED244C ,
'SpectraMaster Colors -- RS141' => 0xE63274 ,
'SpectraMaster Colors -- RS142' => 0xE63467 ,
'SpectraMaster Colors -- RS143' => 0xE6345A ,
'SpectraMaster Colors -- RS144' => 0xE7324D ,
'SpectraMaster Colors -- RS145' => 0xF118A8 ,
'SpectraMaster Colors -- RS146' => 0xEC2399 ,
'SpectraMaster Colors -- RS147' => 0xEC228D ,
'SpectraMaster Colors -- RS148' => 0xEC2281 ,
'SpectraMaster Colors -- RS149' => 0xEA26A5 ,
'SpectraMaster Colors -- RS150' => 0xE82A97 ,
'SpectraMaster Colors -- RS151' => 0xE72E8D ,
'SpectraMaster Colors -- RS152' => 0xE63180 ,
'SpectraMaster Colors -- RS153' => 0xF70FCA ,
'SpectraMaster Colors -- RS154' => 0xF70FC0 ,
'SpectraMaster Colors -- RS155' => 0xF217B5 ,
'SpectraMaster Colors -- RS156' => 0xF1189B ,
'SpectraMaster Colors -- RS157' => 0xF610D5 ,
'SpectraMaster Colors -- RS158' => 0xF317CA ,
'SpectraMaster Colors -- RS159' => 0xF01EBE ,
'SpectraMaster Colors -- RS160' => 0xED23B3 ,
'SpectraMaster Colors -- RS161' => 0xFB0AE1 ,
'SpectraMaster Colors -- RS162' => 0xF90FCC ,
'SpectraMaster Colors -- RS163' => 0xF910C0 ,
'SpectraMaster Colors -- RS164' => 0xF31DB4 ,
'SpectraMaster Colors -- RS165' => 0xF912D4 ,
'SpectraMaster Colors -- RS166' => 0xF718CA ,
'SpectraMaster Colors -- RS167' => 0xF41EC0 ,
'SpectraMaster Colors -- RS168' => 0xF224B3 ,
'SpectraMaster Colors -- RS169' => 0xF025A7 ,
'SpectraMaster Colors -- RS170' => 0xF1249B ,
'SpectraMaster Colors -- RS171' => 0xEC318C ,
'SpectraMaster Colors -- RS172' => 0xEC3180 ,
'SpectraMaster Colors -- RS173' => 0xEF2BA6 ,
'SpectraMaster Colors -- RS174' => 0xEC3198 ,
'SpectraMaster Colors -- RS175' => 0xEB368C ,
'SpectraMaster Colors -- RS176' => 0xEA397E ,
'SpectraMaster Colors -- RS177' => 0xF811B3 ,
'SpectraMaster Colors -- RS178' => 0xF912A8 ,
'SpectraMaster Colors -- RS179' => 0xF9129B ,
'SpectraMaster Colors -- RS180' => 0xFA118E ,
'SpectraMaster Colors -- RS181' => 0xF419B2 ,
'SpectraMaster Colors -- RS182' => 0xF51AA8 ,
'SpectraMaster Colors -- RS183' => 0xF7189D ,
'SpectraMaster Colors -- RS184' => 0xF61A8E ,
'SpectraMaster Colors -- RS185' => 0xF61A81 ,
'SpectraMaster Colors -- RS186' => 0xF61A74 ,
'SpectraMaster Colors -- RS187' => 0xF61A66 ,
'SpectraMaster Colors -- RS188' => 0xF61B5A ,
'SpectraMaster Colors -- RS189' => 0xF1248E ,
'SpectraMaster Colors -- RS190' => 0xF22581 ,
'SpectraMaster Colors -- RS191' => 0xF22574 ,
'SpectraMaster Colors -- RS192' => 0xF22567 ,
'SpectraMaster Colors -- RS193' => 0xF91173 ,
'SpectraMaster Colors -- RS194' => 0xF91259 ,
'SpectraMaster Colors -- RS195' => 0xF9124D ,
'SpectraMaster Colors -- RS196' => 0xF91233 ,
'SpectraMaster Colors -- RS197' => 0xF91180 ,
'SpectraMaster Colors -- RS198' => 0xF91166 ,
'SpectraMaster Colors -- RS199' => 0xF61B4D ,
'SpectraMaster Colors -- RS200' => 0xF91240 ,
'SpectraMaster Colors -- RS201' => 0xEC3174 ,
'SpectraMaster Colors -- RS202' => 0xEC3267 ,
'SpectraMaster Colors -- RS203' => 0xF2265B ,
'SpectraMaster Colors -- RS204' => 0xF2264F ,
'SpectraMaster Colors -- RS205' => 0xEA3A72 ,
'SpectraMaster Colors -- RS206' => 0xEA3A65 ,
'SpectraMaster Colors -- RS207' => 0xEB3858 ,
'SpectraMaster Colors -- RS208' => 0xEC374C ,
'SpectraMaster Colors -- RS209' => 0xF61C40 ,
'SpectraMaster Colors -- RS210' => 0xF22740 ,
'SpectraMaster Colors -- RS211' => 0xF61B32 ,
'SpectraMaster Colors -- RS212' => 0xF81417 ,
'SpectraMaster Colors -- RS213' => 0xEE3340 ,
'SpectraMaster Colors -- RS214' => 0xEF2F34 ,
'SpectraMaster Colors -- RS215' => 0xF12928 ,
'SpectraMaster Colors -- RS216' => 0xF3221B ,
'SpectraMaster Colors -- RS217' => 0xF91C4D ,
'SpectraMaster Colors -- RS218' => 0xF91C41 ,
'SpectraMaster Colors -- RS219' => 0xF91A33 ,
'SpectraMaster Colors -- RS220' => 0xFA1318 ,
'SpectraMaster Colors -- RS221' => 0xF62742 ,
'SpectraMaster Colors -- RS222' => 0xF3373F ,
'SpectraMaster Colors -- RS223' => 0xF53234 ,
'SpectraMaster Colors -- RS224' => 0xF7241B ,
'SpectraMaster Colors -- RS225' => 0xF43375 ,
'SpectraMaster Colors -- RS226' => 0xF3346A ,
'SpectraMaster Colors -- RS227' => 0xF7265D ,
'SpectraMaster Colors -- RS228' => 0xF72750 ,
'SpectraMaster Colors -- RS229' => 0xF03F74 ,
'SpectraMaster Colors -- RS230' => 0xF03F62 ,
'SpectraMaster Colors -- RS231' => 0xF13F57 ,
'SpectraMaster Colors -- RS232' => 0xF23C4B ,
'SpectraMaster Colors -- RS233' => 0xF527A6 ,
'SpectraMaster Colors -- RS234' => 0xF5279A ,
'SpectraMaster Colors -- RS235' => 0xF5268D ,
'SpectraMaster Colors -- RS236' => 0xF62681 ,
'SpectraMaster Colors -- RS237' => 0xF42CA6 ,
'SpectraMaster Colors -- RS238' => 0xF33299 ,
'SpectraMaster Colors -- RS239' => 0xF2368E ,
'SpectraMaster Colors -- RS240' => 0xF23B82 ,
'SpectraMaster Colors -- RS241' => 0xFF0BD7 ,
'SpectraMaster Colors -- RS242' => 0xFD11CB ,
'SpectraMaster Colors -- RS243' => 0xFD11BE ,
'SpectraMaster Colors -- RS244' => 0xFD12B3 ,
'SpectraMaster Colors -- RS245' => 0xFF0CE2 ,
'SpectraMaster Colors -- RS246' => 0xFF12D8 ,
'SpectraMaster Colors -- RS247' => 0xFE19CC ,
'SpectraMaster Colors -- RS248' => 0xFD22BD ,
'SpectraMaster Colors -- RS249' => 0xFE0BE2 ,
'SpectraMaster Colors -- RS250' => 0xFC11CA ,
'SpectraMaster Colors -- RS251' => 0xFB12C0 ,
'SpectraMaster Colors -- RS252' => 0xF819B5 ,
'SpectraMaster Colors -- RS253' => 0xFD14D4 ,
'SpectraMaster Colors -- RS254' => 0xFB19CB ,
'SpectraMaster Colors -- RS255' => 0xF81FBF ,
'SpectraMaster Colors -- RS256' => 0xF625B3 ,
'SpectraMaster Colors -- RS257' => 0xFC29B1 ,
'SpectraMaster Colors -- RS258' => 0xFC2699 ,
'SpectraMaster Colors -- RS259' => 0xFC268D ,
'SpectraMaster Colors -- RS260' => 0xFD2681 ,
'SpectraMaster Colors -- RS261' => 0xFA2FA4 ,
'SpectraMaster Colors -- RS262' => 0xFA339A ,
'SpectraMaster Colors -- RS263' => 0xFB388E ,
'SpectraMaster Colors -- RS264' => 0xFB3C82 ,
'SpectraMaster Colors -- RS265' => 0xFE13A6 ,
'SpectraMaster Colors -- RS266' => 0xFF139A ,
'SpectraMaster Colors -- RS267' => 0xFF128D ,
'SpectraMaster Colors -- RS268' => 0xFD137F ,
'SpectraMaster Colors -- RS269' => 0xFC1AB1 ,
'SpectraMaster Colors -- RS270' => 0xFD1BA6 ,
'SpectraMaster Colors -- RS271' => 0xFE1B99 ,
'SpectraMaster Colors -- RS272' => 0xFE1C8D ,
'SpectraMaster Colors -- RS273' => 0xFE1273 ,
'SpectraMaster Colors -- RS274' => 0xFE1B74 ,
'SpectraMaster Colors -- RS275' => 0xFD1C67 ,
'SpectraMaster Colors -- RS276' => 0xFD1D5C ,
'SpectraMaster Colors -- RS277' => 0xFE1B80 ,
'SpectraMaster Colors -- RS278' => 0xFC2774 ,
'SpectraMaster Colors -- RS279' => 0xFC276A ,
'SpectraMaster Colors -- RS280' => 0xFD285B ,
'SpectraMaster Colors -- RS281' => 0xFE1366 ,
'SpectraMaster Colors -- RS282' => 0xFE135A ,
'SpectraMaster Colors -- RS283' => 0xFE134D ,
'SpectraMaster Colors -- RS284' => 0xFE1341 ,
'SpectraMaster Colors -- RS285' => 0xFE1D4E ,
'SpectraMaster Colors -- RS286' => 0xFC2850 ,
'SpectraMaster Colors -- RS287' => 0xFD2941 ,
'SpectraMaster Colors -- RS288' => 0xFE1D41 ,
'SpectraMaster Colors -- RS289' => 0xFB3474 ,
'SpectraMaster Colors -- RS290' => 0xFB3468 ,
'SpectraMaster Colors -- RS291' => 0xFB355D ,
'SpectraMaster Colors -- RS292' => 0xFB354C ,
'SpectraMaster Colors -- RS293' => 0xFA4076 ,
'SpectraMaster Colors -- RS294' => 0xF84267 ,
'SpectraMaster Colors -- RS295' => 0xF94357 ,
'SpectraMaster Colors -- RS296' => 0xFA3D4C ,
'SpectraMaster Colors -- RS297' => 0xFE1D33 ,
'SpectraMaster Colors -- RS298' => 0xFC2026 ,
'SpectraMaster Colors -- RS299' => 0xFE1332 ,
'SpectraMaster Colors -- RS300' => 0xFD1517 ,
'SpectraMaster Colors -- RS301' => 0xFA343E ,
'SpectraMaster Colors -- RS302' => 0xFC3133 ,
'SpectraMaster Colors -- RS303' => 0xFC2832 ,
'SpectraMaster Colors -- RS304' => 0xFC1F19 ,
'SpectraMaster Colors -- RS305' => 0x00284B ,
'SpectraMaster Colors -- RS306' => 0x00283F ,
'SpectraMaster Colors -- RS307' => 0x002733 ,
'SpectraMaster Colors -- RS308' => 0x001319 ,
'SpectraMaster Colors -- RS309' => 0x01394E ,
'SpectraMaster Colors -- RS310' => 0x013B40 ,
'SpectraMaster Colors -- RS311' => 0x013133 ,
'SpectraMaster Colors -- RS312' => 0x011F16 ,
'SpectraMaster Colors -- RS313' => 0x002966 ,
'SpectraMaster Colors -- RS314' => 0x003671 ,
'SpectraMaster Colors -- RS315' => 0x013567 ,
'SpectraMaster Colors -- RS316' => 0x01375B ,
'SpectraMaster Colors -- RS317' => 0x002873 ,
'SpectraMaster Colors -- RS318' => 0x024175 ,
'SpectraMaster Colors -- RS319' => 0x014368 ,
'SpectraMaster Colors -- RS320' => 0x004458 ,
'SpectraMaster Colors -- RS321' => 0x0027A4 ,
'SpectraMaster Colors -- RS322' => 0x002799 ,
'SpectraMaster Colors -- RS323' => 0x00278D ,
'SpectraMaster Colors -- RS324' => 0x00357F ,
'SpectraMaster Colors -- RS325' => 0x012FA5 ,
'SpectraMaster Colors -- RS326' => 0x023599 ,
'SpectraMaster Colors -- RS327' => 0x023C8A ,
'SpectraMaster Colors -- RS328' => 0x023F80 ,
'SpectraMaster Colors -- RS329' => 0x000CE2 ,
'SpectraMaster Colors -- RS330' => 0x0012CA ,
'SpectraMaster Colors -- RS331' => 0x001CBC ,
'SpectraMaster Colors -- RS332' => 0x001CB0 ,
'SpectraMaster Colors -- RS333' => 0x0012D7 ,
'SpectraMaster Colors -- RS334' => 0x001ACA ,
'SpectraMaster Colors -- RS335' => 0x0022BC ,
'SpectraMaster Colors -- RS336' => 0x0029B0 ,
'SpectraMaster Colors -- RS337' => 0x010CE0 ,
'SpectraMaster Colors -- RS338' => 0x0111CB ,
'SpectraMaster Colors -- RS339' => 0x0112BD ,
'SpectraMaster Colors -- RS340' => 0x031BB1 ,
'SpectraMaster Colors -- RS341' => 0x0312D7 ,
'SpectraMaster Colors -- RS342' => 0x0319CA ,
'SpectraMaster Colors -- RS343' => 0x0421BC ,
'SpectraMaster Colors -- RS344' => 0x0628B0 ,
'SpectraMaster Colors -- RS345' => 0x0626A4 ,
'SpectraMaster Colors -- RS346' => 0x062699 ,
'SpectraMaster Colors -- RS347' => 0x05268D ,
'SpectraMaster Colors -- RS348' => 0x083480 ,
'SpectraMaster Colors -- RS349' => 0x082EA4 ,
'SpectraMaster Colors -- RS350' => 0x09339A ,
'SpectraMaster Colors -- RS351' => 0x0A398D ,
'SpectraMaster Colors -- RS352' => 0x0A3F7F ,
'SpectraMaster Colors -- RS353' => 0x0212B2 ,
'SpectraMaster Colors -- RS354' => 0x0411A9 ,
'SpectraMaster Colors -- RS355' => 0x031399 ,
'SpectraMaster Colors -- RS356' => 0x02138D ,
'SpectraMaster Colors -- RS357' => 0x041BA5 ,
'SpectraMaster Colors -- RS358' => 0x041C98 ,
'SpectraMaster Colors -- RS359' => 0x041A8D ,
'SpectraMaster Colors -- RS360' => 0x031B81 ,
'SpectraMaster Colors -- RS361' => 0x031B74 ,
'SpectraMaster Colors -- RS362' => 0x041B67 ,
'SpectraMaster Colors -- RS363' => 0x041C5A ,
'SpectraMaster Colors -- RS364' => 0x041C4D ,
'SpectraMaster Colors -- RS365' => 0x052674 ,
'SpectraMaster Colors -- RS366' => 0x052668 ,
'SpectraMaster Colors -- RS367' => 0x062759 ,
'SpectraMaster Colors -- RS368' => 0x06284C ,
'SpectraMaster Colors -- RS369' => 0x021174 ,
'SpectraMaster Colors -- RS370' => 0x02125A ,
'SpectraMaster Colors -- RS371' => 0x021341 ,
'SpectraMaster Colors -- RS372' => 0x021519 ,
'SpectraMaster Colors -- RS373' => 0x021180 ,
'SpectraMaster Colors -- RS374' => 0x011266 ,
'SpectraMaster Colors -- RS375' => 0x02124C ,
'SpectraMaster Colors -- RS376' => 0x021333 ,
'SpectraMaster Colors -- RS377' => 0x041C40 ,
'SpectraMaster Colors -- RS378' => 0x041C33 ,
'SpectraMaster Colors -- RS379' => 0x062733 ,
'SpectraMaster Colors -- RS380' => 0x031E18 ,
'SpectraMaster Colors -- RS381' => 0x07343E ,
'SpectraMaster Colors -- RS382' => 0x062840 ,
'SpectraMaster Colors -- RS383' => 0x083233 ,
'SpectraMaster Colors -- RS384' => 0x052117 ,
'SpectraMaster Colors -- RS385' => 0x082630 ,
'SpectraMaster Colors -- RS386' => 0x09263E ,
'SpectraMaster Colors -- RS387' => 0x09274D ,
'SpectraMaster Colors -- RS388' => 0x051416 ,
'SpectraMaster Colors -- RS389' => 0x0D373F ,
'SpectraMaster Colors -- RS390' => 0x0D343F ,
'SpectraMaster Colors -- RS391' => 0x0D3733 ,
'SpectraMaster Colors -- RS392' => 0x071B17 ,
'SpectraMaster Colors -- RS393' => 0x083573 ,
'SpectraMaster Colors -- RS394' => 0x083566 ,
'SpectraMaster Colors -- RS395' => 0x083559 ,
'SpectraMaster Colors -- RS396' => 0x08354C ,
'SpectraMaster Colors -- RS397' => 0x0B4372 ,
'SpectraMaster Colors -- RS398' => 0x0A4566 ,
'SpectraMaster Colors -- RS399' => 0x0A4559 ,
'SpectraMaster Colors -- RS400' => 0x093F4C ,
'SpectraMaster Colors -- RS401' => 0x0C3473 ,
'SpectraMaster Colors -- RS402' => 0x0D3467 ,
'SpectraMaster Colors -- RS403' => 0x0D345A ,
'SpectraMaster Colors -- RS404' => 0x0D354B ,
'SpectraMaster Colors -- RS405' => 0x114272 ,
'SpectraMaster Colors -- RS406' => 0x103F66 ,
'SpectraMaster Colors -- RS407' => 0x104658 ,
'SpectraMaster Colors -- RS408' => 0x0F3F4B ,
'SpectraMaster Colors -- RS409' => 0x0926A4 ,
'SpectraMaster Colors -- RS410' => 0x0A2699 ,
'SpectraMaster Colors -- RS411' => 0x09268D ,
'SpectraMaster Colors -- RS412' => 0x0D3480 ,
'SpectraMaster Colors -- RS413' => 0x0C2DA5 ,
'SpectraMaster Colors -- RS414' => 0x0E329A ,
'SpectraMaster Colors -- RS415' => 0x0E388D ,
'SpectraMaster Colors -- RS416' => 0x0F3E7F ,
'SpectraMaster Colors -- RS417' => 0x030AE3 ,
'SpectraMaster Colors -- RS418' => 0x0311CA ,
'SpectraMaster Colors -- RS419' => 0x0313BD ,
'SpectraMaster Colors -- RS420' => 0x061CAF ,
'SpectraMaster Colors -- RS421' => 0x0412D6 ,
'SpectraMaster Colors -- RS422' => 0x0819CA ,
'SpectraMaster Colors -- RS423' => 0x0B20BE ,
'SpectraMaster Colors -- RS424' => 0x0E27B2 ,
'SpectraMaster Colors -- RS425' => 0x040BE3 ,
'SpectraMaster Colors -- RS426' => 0x0410CB ,
'SpectraMaster Colors -- RS427' => 0x0411BF ,
'SpectraMaster Colors -- RS428' => 0x081BB0 ,
'SpectraMaster Colors -- RS429' => 0x0613D6 ,
'SpectraMaster Colors -- RS430' => 0x081BC8 ,
'SpectraMaster Colors -- RS431' => 0x0A22BB ,
'SpectraMaster Colors -- RS432' => 0x0E28B0 ,
'SpectraMaster Colors -- RS433' => 0x0A26A2 ,
'SpectraMaster Colors -- RS434' => 0x0A2597 ,
'SpectraMaster Colors -- RS435' => 0x15318F ,
'SpectraMaster Colors -- RS436' => 0x123581 ,
'SpectraMaster Colors -- RS437' => 0x102EA5 ,
'SpectraMaster Colors -- RS438' => 0x123499 ,
'SpectraMaster Colors -- RS439' => 0x13398C ,
'SpectraMaster Colors -- RS440' => 0x153E7F ,
'SpectraMaster Colors -- RS441' => 0x091B99 ,
'SpectraMaster Colors -- RS442' => 0x091A8C ,
'SpectraMaster Colors -- RS443' => 0x091A7F ,
'SpectraMaster Colors -- RS444' => 0x091A73 ,
'SpectraMaster Colors -- RS445' => 0x091BA4 ,
'SpectraMaster Colors -- RS446' => 0x0C258C ,
'SpectraMaster Colors -- RS447' => 0x0B2580 ,
'SpectraMaster Colors -- RS448' => 0x0C2572 ,
'SpectraMaster Colors -- RS449' => 0x0C2565 ,
'SpectraMaster Colors -- RS450' => 0x0D2659 ,
'SpectraMaster Colors -- RS451' => 0x0D264C ,
'SpectraMaster Colors -- RS452' => 0x0C2641 ,
'SpectraMaster Colors -- RS453' => 0x092780 ,
'SpectraMaster Colors -- RS454' => 0x0A2874 ,
'SpectraMaster Colors -- RS455' => 0x0A2868 ,
'SpectraMaster Colors -- RS456' => 0x09275B ,
'SpectraMaster Colors -- RS457' => 0x06118C ,
'SpectraMaster Colors -- RS458' => 0x051172 ,
'SpectraMaster Colors -- RS459' => 0x051259 ,
'SpectraMaster Colors -- RS460' => 0x061240 ,
'SpectraMaster Colors -- RS461' => 0x061299 ,
'SpectraMaster Colors -- RS462' => 0x05127E ,
'SpectraMaster Colors -- RS463' => 0x051166 ,
'SpectraMaster Colors -- RS464' => 0x05124D ,
'SpectraMaster Colors -- RS465' => 0x1B383D ,
'SpectraMaster Colors -- RS466' => 0x14244F ,
'SpectraMaster Colors -- RS467' => 0x10243F ,
'SpectraMaster Colors -- RS468' => 0x0A1D19 ,
'SpectraMaster Colors -- RS469' => 0x091B33 ,
'SpectraMaster Colors -- RS470' => 0x0B1A33 ,
'SpectraMaster Colors -- RS471' => 0x051233 ,
'SpectraMaster Colors -- RS472' => 0x091518 ,
'SpectraMaster Colors -- RS473' => 0x113274 ,
'SpectraMaster Colors -- RS474' => 0x113267 ,
'SpectraMaster Colors -- RS475' => 0x103358 ,
'SpectraMaster Colors -- RS476' => 0x11334B ,
'SpectraMaster Colors -- RS477' => 0x174273 ,
'SpectraMaster Colors -- RS478' => 0x174657 ,
'SpectraMaster Colors -- RS479' => 0x17444B ,
'SpectraMaster Colors -- RS480' => 0x153D3F ,
'SpectraMaster Colors -- RS481' => 0x153175 ,
'SpectraMaster Colors -- RS482' => 0x193168 ,
'SpectraMaster Colors -- RS483' => 0x16315A ,
'SpectraMaster Colors -- RS484' => 0x16314B ,
'SpectraMaster Colors -- RS485' => 0x1E4273 ,
'SpectraMaster Colors -- RS486' => 0x204565 ,
'SpectraMaster Colors -- RS487' => 0x1E4158 ,
'SpectraMaster Colors -- RS488' => 0x1F454A ,
'SpectraMaster Colors -- RS489' => 0x16313D ,
'SpectraMaster Colors -- RS490' => 0x10323F ,
'SpectraMaster Colors -- RS491' => 0x103231 ,
'SpectraMaster Colors -- RS492' => 0x0D2633 ,
'SpectraMaster Colors -- RS493' => 0x10248D ,
'SpectraMaster Colors -- RS494' => 0x102481 ,
'SpectraMaster Colors -- RS495' => 0x10255A ,
'SpectraMaster Colors -- RS496' => 0x152D31 ,
'SpectraMaster Colors -- RS497' => 0x1023A4 ,
'SpectraMaster Colors -- RS498' => 0x102399 ,
'SpectraMaster Colors -- RS499' => 0x15308D ,
'SpectraMaster Colors -- RS500' => 0x13317F ,
'SpectraMaster Colors -- RS501' => 0x152EA5 ,
'SpectraMaster Colors -- RS502' => 0x173499 ,
'SpectraMaster Colors -- RS503' => 0x193A8C ,
'SpectraMaster Colors -- RS504' => 0x1B3F7F ,
'SpectraMaster Colors -- RS505' => 0x050BE2 ,
'SpectraMaster Colors -- RS506' => 0x0610CB ,
'SpectraMaster Colors -- RS507' => 0x0A19BC ,
'SpectraMaster Colors -- RS508' => 0x0B1AB0 ,
'SpectraMaster Colors -- RS509' => 0x0812D7 ,
'SpectraMaster Colors -- RS510' => 0x0A19CA ,
'SpectraMaster Colors -- RS511' => 0x0E22BA ,
'SpectraMaster Colors -- RS512' => 0x1228B0 ,
'SpectraMaster Colors -- RS513' => 0x0A12D5 ,
'SpectraMaster Colors -- RS514' => 0x0D19CA ,
'SpectraMaster Colors -- RS515' => 0x1221BC ,
'SpectraMaster Colors -- RS516' => 0x1628B0 ,
'SpectraMaster Colors -- RS517' => 0x060BE3 ,
'SpectraMaster Colors -- RS518' => 0x080FCA ,
'SpectraMaster Colors -- RS519' => 0x0D18BD ,
'SpectraMaster Colors -- RS520' => 0x0E19B1 ,
'SpectraMaster Colors -- RS521' => 0x0A11B3 ,
'SpectraMaster Colors -- RS522' => 0x0E1AA5 ,
'SpectraMaster Colors -- RS523' => 0x0E1998 ,
'SpectraMaster Colors -- RS524' => 0x12228C ,
'SpectraMaster Colors -- RS525' => 0x0A11A5 ,
'SpectraMaster Colors -- RS526' => 0x091198 ,
'SpectraMaster Colors -- RS527' => 0x09118B ,
'SpectraMaster Colors -- RS528' => 0x0D198B ,
'SpectraMaster Colors -- RS529' => 0x1A2EA4 ,
'SpectraMaster Colors -- RS530' => 0x1C339A ,
'SpectraMaster Colors -- RS531' => 0x1F3A8D ,
'SpectraMaster Colors -- RS532' => 0x223F7F ,
'SpectraMaster Colors -- RS533' => 0x1321A5 ,
'SpectraMaster Colors -- RS534' => 0x132299 ,
'SpectraMaster Colors -- RS535' => 0x192E8D ,
'SpectraMaster Colors -- RS536' => 0x1A2E80 ,
'SpectraMaster Colors -- RS537' => 0x132280 ,
'SpectraMaster Colors -- RS538' => 0x132272 ,
'SpectraMaster Colors -- RS539' => 0x132265 ,
'SpectraMaster Colors -- RS540' => 0x142358 ,
'SpectraMaster Colors -- RS541' => 0x0D187F ,
'SpectraMaster Colors -- RS542' => 0x0E1874 ,
'SpectraMaster Colors -- RS543' => 0x0E1866 ,
'SpectraMaster Colors -- RS544' => 0x0E1959 ,
'SpectraMaster Colors -- RS545' => 0x264272 ,
'SpectraMaster Colors -- RS546' => 0x274666 ,
'SpectraMaster Colors -- RS547' => 0x284758 ,
'SpectraMaster Colors -- RS548' => 0x243F4B ,
'SpectraMaster Colors -- RS549' => 0x1A2E73 ,
'SpectraMaster Colors -- RS550' => 0x193063 ,
'SpectraMaster Colors -- RS551' => 0x192F57 ,
'SpectraMaster Colors -- RS552' => 0x192F4B ,
'SpectraMaster Colors -- RS553' => 0x08107E ,
'SpectraMaster Colors -- RS554' => 0x081066 ,
'SpectraMaster Colors -- RS555' => 0x09104C ,
'SpectraMaster Colors -- RS556' => 0x091032 ,
'SpectraMaster Colors -- RS557' => 0x081072 ,
'SpectraMaster Colors -- RS558' => 0x09105A ,
'SpectraMaster Colors -- RS559' => 0x091040 ,
'SpectraMaster Colors -- RS560' => 0x0A1418 ,
'SpectraMaster Colors -- RS561' => 0x13234B ,
'SpectraMaster Colors -- RS562' => 0x142333 ,
'SpectraMaster Colors -- RS563' => 0x1B2D32 ,
'SpectraMaster Colors -- RS564' => 0x1F383E ,
'SpectraMaster Colors -- RS565' => 0x0E194C ,
'SpectraMaster Colors -- RS566' => 0x0E1940 ,
'SpectraMaster Colors -- RS567' => 0x13233F ,
'SpectraMaster Colors -- RS568' => 0x192E3F ,
'SpectraMaster Colors -- RS569' => 0x1F2C67 ,
'SpectraMaster Colors -- RS570' => 0x17215A ,
'SpectraMaster Colors -- RS571' => 0x24353E ,
'SpectraMaster Colors -- RS572' => 0x1C2931 ,
'SpectraMaster Colors -- RS573' => 0x1F2D5A ,
'SpectraMaster Colors -- RS574' => 0x17214D ,
'SpectraMaster Colors -- RS575' => 0x17213F ,
'SpectraMaster Colors -- RS576' => 0x0C1931 ,
'SpectraMaster Colors -- RS577' => 0x2F4371 ,
'SpectraMaster Colors -- RS578' => 0x324864 ,
'SpectraMaster Colors -- RS579' => 0x344B59 ,
'SpectraMaster Colors -- RS580' => 0x2F414C ,
'SpectraMaster Colors -- RS581' => 0x1F2C73 ,
'SpectraMaster Colors -- RS582' => 0x273966 ,
'SpectraMaster Colors -- RS583' => 0x283958 ,
'SpectraMaster Colors -- RS584' => 0x1F2D4C ,
'SpectraMaster Colors -- RS585' => 0x1F2FA4 ,
'SpectraMaster Colors -- RS586' => 0x223499 ,
'SpectraMaster Colors -- RS587' => 0x273B8B ,
'SpectraMaster Colors -- RS588' => 0x2B407F ,
'SpectraMaster Colors -- RS589' => 0x161FA5 ,
'SpectraMaster Colors -- RS590' => 0x1D2B99 ,
'SpectraMaster Colors -- RS591' => 0x1D2B8D ,
'SpectraMaster Colors -- RS592' => 0x1E2C7F ,
'SpectraMaster Colors -- RS593' => 0x0C12D5 ,
'SpectraMaster Colors -- RS594' => 0x111AC9 ,
'SpectraMaster Colors -- RS595' => 0x1722BC ,
'SpectraMaster Colors -- RS596' => 0x1B29B0 ,
'SpectraMaster Colors -- RS597' => 0x070CE1 ,
'SpectraMaster Colors -- RS598' => 0x090FCA ,
'SpectraMaster Colors -- RS599' => 0x0F17BD ,
'SpectraMaster Colors -- RS600' => 0x1620B0 ,
'SpectraMaster Colors -- RS601' => 0x0F13D6 ,
'SpectraMaster Colors -- RS602' => 0x161BCA ,
'SpectraMaster Colors -- RS603' => 0x1C22BD ,
'SpectraMaster Colors -- RS604' => 0x2229B0 ,
'SpectraMaster Colors -- RS605' => 0x080BE2 ,
'SpectraMaster Colors -- RS606' => 0x0B0FCC ,
'SpectraMaster Colors -- RS607' => 0x1016BD ,
'SpectraMaster Colors -- RS608' => 0x191EB0 ,
'SpectraMaster Colors -- RS609' => 0x2730A4 ,
'SpectraMaster Colors -- RS610' => 0x2C3796 ,
'SpectraMaster Colors -- RS611' => 0x36428B ,
'SpectraMaster Colors -- RS612' => 0x3A4681 ,
'SpectraMaster Colors -- RS613' => 0x2027A4 ,
'SpectraMaster Colors -- RS614' => 0x212798 ,
'SpectraMaster Colors -- RS615' => 0x21288B ,
'SpectraMaster Colors -- RS616' => 0x2B347E ,
'SpectraMaster Colors -- RS617' => 0x191F99 ,
'SpectraMaster Colors -- RS618' => 0x21287E ,
'SpectraMaster Colors -- RS619' => 0x232A72 ,
'SpectraMaster Colors -- RS620' => 0x232A64 ,
'SpectraMaster Colors -- RS621' => 0x1A1F8D ,
'SpectraMaster Colors -- RS622' => 0x191F7F ,
'SpectraMaster Colors -- RS623' => 0x191F72 ,
'SpectraMaster Colors -- RS624' => 0x1A1F64 ,
'SpectraMaster Colors -- RS625' => 0x2B3572 ,
'SpectraMaster Colors -- RS626' => 0x3C4972 ,
'SpectraMaster Colors -- RS627' => 0x3C4A65 ,
'SpectraMaster Colors -- RS628' => 0x414D59 ,
'SpectraMaster Colors -- RS629' => 0x2B3564 ,
'SpectraMaster Colors -- RS630' => 0x2C3557 ,
'SpectraMaster Colors -- RS631' => 0x313949 ,
'SpectraMaster Colors -- RS632' => 0x29313E ,
'SpectraMaster Colors -- RS633' => 0x1116B3 ,
'SpectraMaster Colors -- RS634' => 0x181DA5 ,
'SpectraMaster Colors -- RS635' => 0x1116A7 ,
'SpectraMaster Colors -- RS636' => 0x121699 ,
'SpectraMaster Colors -- RS637' => 0x0B10C0 ,
'SpectraMaster Colors -- RS638' => 0x0C10B4 ,
'SpectraMaster Colors -- RS639' => 0x0C0FA7 ,
'SpectraMaster Colors -- RS640' => 0x0C0F9A ,
'SpectraMaster Colors -- RS641' => 0x12168C ,
'SpectraMaster Colors -- RS642' => 0x12167F ,
'SpectraMaster Colors -- RS643' => 0x121672 ,
'SpectraMaster Colors -- RS644' => 0x121664 ,
'SpectraMaster Colors -- RS645' => 0x0C0F8C ,
'SpectraMaster Colors -- RS646' => 0x0C0F7F ,
'SpectraMaster Colors -- RS647' => 0x0C0F72 ,
'SpectraMaster Colors -- RS648' => 0x0C0F65 ,
'SpectraMaster Colors -- RS649' => 0x121656 ,
'SpectraMaster Colors -- RS650' => 0x12163F ,
'SpectraMaster Colors -- RS651' => 0x111633 ,
'SpectraMaster Colors -- RS652' => 0x0C0F33 ,
'SpectraMaster Colors -- RS653' => 0x13164C ,
'SpectraMaster Colors -- RS654' => 0x0C0F57 ,
'SpectraMaster Colors -- RS655' => 0x0C0F3F ,
'SpectraMaster Colors -- RS656' => 0x0D1019 ,
'SpectraMaster Colors -- RS657' => 0x212957 ,
'SpectraMaster Colors -- RS658' => 0x21294A ,
'SpectraMaster Colors -- RS659' => 0x22283F ,
'SpectraMaster Colors -- RS660' => 0x1F2431 ,
'SpectraMaster Colors -- RS661' => 0x1A1E57 ,
'SpectraMaster Colors -- RS662' => 0x1A1F4B ,
'SpectraMaster Colors -- RS663' => 0x191F3F ,
'SpectraMaster Colors -- RS664' => 0x1A1F33 ,
'SpectraMaster Colors -- RS665' => 0x262766 ,
'SpectraMaster Colors -- RS666' => 0x262759 ,
'SpectraMaster Colors -- RS667' => 0x2A2B3E ,
'SpectraMaster Colors -- RS668' => 0x202031 ,
'SpectraMaster Colors -- RS669' => 0x1C1D4C ,
'SpectraMaster Colors -- RS670' => 0x1C1C3F ,
'SpectraMaster Colors -- RS671' => 0x151433 ,
'SpectraMaster Colors -- RS672' => 0x0D0E19 ,
'SpectraMaster Colors -- RS673' => 0x4A4B71 ,
'SpectraMaster Colors -- RS674' => 0x4B4B65 ,
'SpectraMaster Colors -- RS675' => 0x404057 ,
'SpectraMaster Colors -- RS676' => 0x35354A ,
'SpectraMaster Colors -- RS677' => 0x303171 ,
'SpectraMaster Colors -- RS678' => 0x313265 ,
'SpectraMaster Colors -- RS679' => 0x313258 ,
'SpectraMaster Colors -- RS680' => 0x26274B ,
'SpectraMaster Colors -- RS681' => 0x1315BF ,
'SpectraMaster Colors -- RS682' => 0x1C1EA4 ,
'SpectraMaster Colors -- RS683' => 0x25268C ,
'SpectraMaster Colors -- RS684' => 0x26267E ,
'SpectraMaster Colors -- RS685' => 0x1414B1 ,
'SpectraMaster Colors -- RS686' => 0x1C1C97 ,
'SpectraMaster Colors -- RS687' => 0x1C1C8B ,
'SpectraMaster Colors -- RS688' => 0x272771 ,
'SpectraMaster Colors -- RS689' => 0x2F31A4 ,
'SpectraMaster Colors -- RS690' => 0x363797 ,
'SpectraMaster Colors -- RS691' => 0x40418B ,
'SpectraMaster Colors -- RS692' => 0x47477F ,
'SpectraMaster Colors -- RS693' => 0x2526A4 ,
'SpectraMaster Colors -- RS694' => 0x262799 ,
'SpectraMaster Colors -- RS695' => 0x31318C ,
'SpectraMaster Colors -- RS696' => 0x31317F ,
'SpectraMaster Colors -- RS697' => 0x1012D8 ,
'SpectraMaster Colors -- RS698' => 0x181BCA ,
'SpectraMaster Colors -- RS699' => 0x2123BD ,
'SpectraMaster Colors -- RS700' => 0x292BAF ,
'SpectraMaster Colors -- RS701' => 0x0C0CD7 ,
'SpectraMaster Colors -- RS702' => 0x1213CB ,
'SpectraMaster Colors -- RS703' => 0x1C1CBC ,
'SpectraMaster Colors -- RS704' => 0x1C1DB0 ,
'SpectraMaster Colors -- RS901' => 0x3D4854 ,
'SpectraMaster Colors -- RS902' => 0x354752 ,
'SpectraMaster Colors -- RS903' => 0x374252 ,
'SpectraMaster Colors -- RS904' => 0x3D4650 ,
'SpectraMaster Colors -- RS905' => 0x3A444E ,
'SpectraMaster Colors -- RS906' => 0x3E464F ,
'SpectraMaster Colors -- RS907' => 0x3D4A52 ,
'SpectraMaster Colors -- RS908' => 0x3E4D5A ,
'SpectraMaster Colors -- RS909' => 0x34464F ,
'SpectraMaster Colors -- RS910' => 0x314148 ,
'SpectraMaster Colors -- RS911' => 0x3A4950 ,
'SpectraMaster Colors -- RS912' => 0x36454D ,
'SpectraMaster Colors -- RS913' => 0x364647 ,
'SpectraMaster Colors -- RS914' => 0x2F4342 ,
'SpectraMaster Colors -- RS915' => 0x2F3F42 ,
'SpectraMaster Colors -- RS916' => 0x314240 ,
'SpectraMaster Colors -- YS001' => 0x1311D8 ,
'SpectraMaster Colors -- YS002' => 0x1611CB ,
'SpectraMaster Colors -- YS003' => 0x1E19CA ,
'SpectraMaster Colors -- YS004' => 0x1213C0 ,
'SpectraMaster Colors -- YS005' => 0x0C0AE3 ,
'SpectraMaster Colors -- YS006' => 0x0E0CD8 ,
'SpectraMaster Colors -- YS007' => 0x0C0CCE ,
'SpectraMaster Colors -- YS008' => 0x0D0DC1 ,
'SpectraMaster Colors -- YS009' => 0x2521BC ,
'SpectraMaster Colors -- YS010' => 0x2D29B1 ,
'SpectraMaster Colors -- YS011' => 0x3E34A2 ,
'SpectraMaster Colors -- YS012' => 0x453A97 ,
'SpectraMaster Colors -- YS013' => 0x1E19BC ,
'SpectraMaster Colors -- YS014' => 0x1E1BB1 ,
'SpectraMaster Colors -- YS015' => 0x2823A5 ,
'SpectraMaster Colors -- YS016' => 0x342D99 ,
'SpectraMaster Colors -- YS017' => 0x4E4289 ,
'SpectraMaster Colors -- YS018' => 0x55477E ,
'SpectraMaster Colors -- YS019' => 0x574972 ,
'SpectraMaster Colors -- YS020' => 0x4C3F64 ,
'SpectraMaster Colors -- YS021' => 0x352E8D ,
'SpectraMaster Colors -- YS022' => 0x352E81 ,
'SpectraMaster Colors -- YS023' => 0x342E72 ,
'SpectraMaster Colors -- YS024' => 0x362D65 ,
'SpectraMaster Colors -- YS025' => 0x1513B4 ,
'SpectraMaster Colors -- YS026' => 0x1E1AA6 ,
'SpectraMaster Colors -- YS027' => 0x16129A ,
'SpectraMaster Colors -- YS028' => 0x16128D ,
'SpectraMaster Colors -- YS029' => 0x0D0DB5 ,
'SpectraMaster Colors -- YS030' => 0x1613A7 ,
'SpectraMaster Colors -- YS031' => 0x0E0C9A ,
'SpectraMaster Colors -- YS032' => 0x0F0C8D ,
'SpectraMaster Colors -- YS033' => 0x29249A ,
'SpectraMaster Colors -- YS034' => 0x29248E ,
'SpectraMaster Colors -- YS035' => 0x292380 ,
'SpectraMaster Colors -- YS036' => 0x292373 ,
'SpectraMaster Colors -- YS037' => 0x1F1A9A ,
'SpectraMaster Colors -- YS038' => 0x1F1A8E ,
'SpectraMaster Colors -- YS039' => 0x1E1A80 ,
'SpectraMaster Colors -- YS040' => 0x1E1A72 ,
'SpectraMaster Colors -- YS041' => 0x161280 ,
'SpectraMaster Colors -- YS042' => 0x161372 ,
'SpectraMaster Colors -- YS043' => 0x161365 ,
'SpectraMaster Colors -- YS044' => 0x161357 ,
'SpectraMaster Colors -- YS045' => 0x0F0C80 ,
'SpectraMaster Colors -- YS046' => 0x0E0C72 ,
'SpectraMaster Colors -- YS047' => 0x0E0D66 ,
'SpectraMaster Colors -- YS048' => 0x0E0D57 ,
'SpectraMaster Colors -- YS049' => 0x292365 ,
'SpectraMaster Colors -- YS050' => 0x292259 ,
'SpectraMaster Colors -- YS051' => 0x362E4B ,
'SpectraMaster Colors -- YS052' => 0x2B253E ,
'SpectraMaster Colors -- YS053' => 0x1C1864 ,
'SpectraMaster Colors -- YS054' => 0x1F1A57 ,
'SpectraMaster Colors -- YS055' => 0x29234C ,
'SpectraMaster Colors -- YS056' => 0x1E1A3F ,
'SpectraMaster Colors -- YS057' => 0x1E1A4B ,
'SpectraMaster Colors -- YS058' => 0x16133E ,
'SpectraMaster Colors -- YS059' => 0x211B31 ,
'SpectraMaster Colors -- YS060' => 0x161331 ,
'SpectraMaster Colors -- YS061' => 0x16134B ,
'SpectraMaster Colors -- YS062' => 0x0E0C3D ,
'SpectraMaster Colors -- YS063' => 0x0E0C31 ,
'SpectraMaster Colors -- YS064' => 0x0E0C19 ,
'SpectraMaster Colors -- YS065' => 0x36274C ,
'SpectraMaster Colors -- YS066' => 0x2C1E40 ,
'SpectraMaster Colors -- YS067' => 0x211731 ,
'SpectraMaster Colors -- YS068' => 0x181026 ,
'SpectraMaster Colors -- YS069' => 0x1F174C ,
'SpectraMaster Colors -- YS070' => 0x21173F ,
'SpectraMaster Colors -- YS071' => 0x181033 ,
'SpectraMaster Colors -- YS072' => 0x0E0A19 ,
'SpectraMaster Colors -- YS073' => 0x5B3F7E ,
'SpectraMaster Colors -- YS074' => 0x523871 ,
'SpectraMaster Colors -- YS075' => 0x493365 ,
'SpectraMaster Colors -- YS076' => 0x402D59 ,
'SpectraMaster Colors -- YS077' => 0x382A81 ,
'SpectraMaster Colors -- YS078' => 0x382A73 ,
'SpectraMaster Colors -- YS079' => 0x372A65 ,
'SpectraMaster Colors -- YS080' => 0x2B2058 ,
'SpectraMaster Colors -- YS081' => 0x3928AF ,
'SpectraMaster Colors -- YS082' => 0x4632A4 ,
'SpectraMaster Colors -- YS083' => 0x523998 ,
'SpectraMaster Colors -- YS084' => 0x5B408B ,
'SpectraMaster Colors -- YS085' => 0x2A1FB1 ,
'SpectraMaster Colors -- YS086' => 0x2A20A6 ,
'SpectraMaster Colors -- YS087' => 0x382899 ,
'SpectraMaster Colors -- YS088' => 0x38298D ,
'SpectraMaster Colors -- YS089' => 0x0B0AE4 ,
'SpectraMaster Colors -- YS090' => 0x1510D9 ,
'SpectraMaster Colors -- YS091' => 0x2218CA ,
'SpectraMaster Colors -- YS092' => 0x2E21BB ,
'SpectraMaster Colors -- YS093' => 0x0A07E3 ,
'SpectraMaster Colors -- YS094' => 0x0F0BD8 ,
'SpectraMaster Colors -- YS095' => 0x170FCB ,
'SpectraMaster Colors -- YS096' => 0x2016BD ,
'SpectraMaster Colors -- YS097' => 0x0E0AE3 ,
'SpectraMaster Colors -- YS098' => 0x190FD9 ,
'SpectraMaster Colors -- YS099' => 0x2516CC ,
'SpectraMaster Colors -- YS100' => 0x3520BC ,
'SpectraMaster Colors -- YS101' => 0x0E08DB ,
'SpectraMaster Colors -- YS102' => 0x0E09CF ,
'SpectraMaster Colors -- YS103' => 0x190DCB ,
'SpectraMaster Colors -- YS104' => 0x2113BE ,
'SpectraMaster Colors -- YS105' => 0x4929B2 ,
'SpectraMaster Colors -- YS106' => 0x5632A3 ,
'SpectraMaster Colors -- YS107' => 0x613899 ,
'SpectraMaster Colors -- YS108' => 0x64388C ,
'SpectraMaster Colors -- YS109' => 0x2C1BB1 ,
'SpectraMaster Colors -- YS110' => 0x3D23A5 ,
'SpectraMaster Colors -- YS111' => 0x3B2399 ,
'SpectraMaster Colors -- YS112' => 0x4F2D8B ,
'SpectraMaster Colors -- YS113' => 0x5A327E ,
'SpectraMaster Colors -- YS114' => 0x502D71 ,
'SpectraMaster Colors -- YS115' => 0x472965 ,
'SpectraMaster Colors -- YS116' => 0x3D2558 ,
'SpectraMaster Colors -- YS117' => 0x3B2480 ,
'SpectraMaster Colors -- YS118' => 0x3B2573 ,
'SpectraMaster Colors -- YS119' => 0x2E1E68 ,
'SpectraMaster Colors -- YS120' => 0x2D1D5A ,
'SpectraMaster Colors -- YS121' => 0x170FC0 ,
'SpectraMaster Colors -- YS122' => 0x2114B3 ,
'SpectraMaster Colors -- YS123' => 0x2D1CA7 ,
'SpectraMaster Colors -- YS124' => 0x2E1D9B ,
'SpectraMaster Colors -- YS125' => 0x0E0AC3 ,
'SpectraMaster Colors -- YS126' => 0x180FB5 ,
'SpectraMaster Colors -- YS127' => 0x2214A7 ,
'SpectraMaster Colors -- YS128' => 0x23149A ,
'SpectraMaster Colors -- YS129' => 0x190FA7 ,
'SpectraMaster Colors -- YS130' => 0x190E9A ,
'SpectraMaster Colors -- YS131' => 0x190E8D ,
'SpectraMaster Colors -- YS132' => 0x190E80 ,
'SpectraMaster Colors -- YS133' => 0x100AA8 ,
'SpectraMaster Colors -- YS134' => 0x11099A ,
'SpectraMaster Colors -- YS135' => 0x11098D ,
'SpectraMaster Colors -- YS136' => 0x110980 ,
'SpectraMaster Colors -- YS137' => 0x2F1A8E ,
'SpectraMaster Colors -- YS138' => 0x3B248D ,
'SpectraMaster Colors -- YS139' => 0x2F1A81 ,
'SpectraMaster Colors -- YS140' => 0x2F1B73 ,
'SpectraMaster Colors -- YS141' => 0x23148D ,
'SpectraMaster Colors -- YS142' => 0x231480 ,
'SpectraMaster Colors -- YS143' => 0x231473 ,
'SpectraMaster Colors -- YS144' => 0x231465 ,
'SpectraMaster Colors -- YS145' => 0x190E73 ,
'SpectraMaster Colors -- YS146' => 0x190F58 ,
'SpectraMaster Colors -- YS147' => 0x231458 ,
'SpectraMaster Colors -- YS148' => 0x190E4B ,
'SpectraMaster Colors -- YS149' => 0x100973 ,
'SpectraMaster Colors -- YS150' => 0x190E66 ,
'SpectraMaster Colors -- YS151' => 0x10094A ,
'SpectraMaster Colors -- YS152' => 0x10093E ,
'SpectraMaster Colors -- YS153' => 0x34204B ,
'SpectraMaster Colors -- YS154' => 0x2A1A3E ,
'SpectraMaster Colors -- YS155' => 0x201331 ,
'SpectraMaster Colors -- YS156' => 0x100932 ,
'SpectraMaster Colors -- YS157' => 0x21154C ,
'SpectraMaster Colors -- YS158' => 0x180F40 ,
'SpectraMaster Colors -- YS159' => 0x180E33 ,
'SpectraMaster Colors -- YS160' => 0x0E0919 ,
'SpectraMaster Colors -- YS161' => 0x331A4C ,
'SpectraMaster Colors -- YS162' => 0x28143E ,
'SpectraMaster Colors -- YS163' => 0x1F1031 ,
'SpectraMaster Colors -- YS164' => 0x160B25 ,
'SpectraMaster Colors -- YS165' => 0x23124C ,
'SpectraMaster Colors -- YS166' => 0x190C40 ,
'SpectraMaster Colors -- YS167' => 0x110833 ,
'SpectraMaster Colors -- YS168' => 0x0C061A ,
'SpectraMaster Colors -- YS169' => 0x5A2880 ,
'SpectraMaster Colors -- YS170' => 0x502472 ,
'SpectraMaster Colors -- YS171' => 0x462165 ,
'SpectraMaster Colors -- YS172' => 0x3C1E58 ,
'SpectraMaster Colors -- YS173' => 0x3E1F80 ,
'SpectraMaster Colors -- YS174' => 0x311975 ,
'SpectraMaster Colors -- YS175' => 0x301967 ,
'SpectraMaster Colors -- YS176' => 0x24125A ,
'SpectraMaster Colors -- YS177' => 0x5829B1 ,
'SpectraMaster Colors -- YS178' => 0x6530A6 ,
'SpectraMaster Colors -- YS179' => 0x6D3398 ,
'SpectraMaster Colors -- YS180' => 0x642D8D ,
'SpectraMaster Colors -- YS181' => 0x3F1DB0 ,
'SpectraMaster Colors -- YS182' => 0x421DA6 ,
'SpectraMaster Colors -- YS183' => 0x522599 ,
'SpectraMaster Colors -- YS184' => 0x401C8C ,
'SpectraMaster Colors -- YS185' => 0x0E0AE3 ,
'SpectraMaster Colors -- YS186' => 0x1F0FD7 ,
'SpectraMaster Colors -- YS187' => 0x2C16CB ,
'SpectraMaster Colors -- YS188' => 0x4221BE ,
'SpectraMaster Colors -- YS189' => 0x0A05E2 ,
'SpectraMaster Colors -- YS190' => 0x190CD7 ,
'SpectraMaster Colors -- YS191' => 0x230FCB ,
'SpectraMaster Colors -- YS192' => 0x3118BF ,
'SpectraMaster Colors -- YS193' => 0x1008E3 ,
'SpectraMaster Colors -- YS194' => 0x230DD8 ,
'SpectraMaster Colors -- YS195' => 0x3B18CB ,
'SpectraMaster Colors -- YS196' => 0x5621BD ,
'SpectraMaster Colors -- YS197' => 0x1809CF ,
'SpectraMaster Colors -- YS198' => 0x1A08D7 ,
'SpectraMaster Colors -- YS199' => 0x240CCB ,
'SpectraMaster Colors -- YS200' => 0x4118BD ,
'SpectraMaster Colors -- YS201' => 0x6A29B1 ,
'SpectraMaster Colors -- YS202' => 0x762BA6 ,
'SpectraMaster Colors -- YS203' => 0x6D2899 ,
'SpectraMaster Colors -- YS204' => 0x63238C ,
'SpectraMaster Colors -- YS205' => 0x4319B3 ,
'SpectraMaster Colors -- YS206' => 0x5320A5 ,
'SpectraMaster Colors -- YS207' => 0x541F99 ,
'SpectraMaster Colors -- YS208' => 0x421790 ,
'SpectraMaster Colors -- YS209' => 0x3313BF ,
'SpectraMaster Colors -- YS210' => 0x3112B4 ,
'SpectraMaster Colors -- YS211' => 0x3F17A6 ,
'SpectraMaster Colors -- YS212' => 0x40189A ,
'SpectraMaster Colors -- YS213' => 0x240EC1 ,
'SpectraMaster Colors -- YS214' => 0x250EB5 ,
'SpectraMaster Colors -- YS215' => 0x3212A8 ,
'SpectraMaster Colors -- YS216' => 0x32129B ,
'SpectraMaster Colors -- YS217' => 0x1A0AC2 ,
'SpectraMaster Colors -- YS218' => 0x1207B6 ,
'SpectraMaster Colors -- YS219' => 0x260EA8 ,
'SpectraMaster Colors -- YS220' => 0x260D9C ,
'SpectraMaster Colors -- YS221' => 0x1107C3 ,
'SpectraMaster Colors -- YS222' => 0x1206A8 ,
'SpectraMaster Colors -- YS223' => 0x1B0AA8 ,
'SpectraMaster Colors -- YS224' => 0x1B099A ,
'SpectraMaster Colors -- YS225' => 0x33128F ,
'SpectraMaster Colors -- YS226' => 0x331282 ,
'SpectraMaster Colors -- YS227' => 0x260E74 ,
'SpectraMaster Colors -- YS228' => 0x260E66 ,
'SpectraMaster Colors -- YS229' => 0x260D8F ,
'SpectraMaster Colors -- YS230' => 0x260D81 ,
'SpectraMaster Colors -- YS231' => 0x1B0A73 ,
'SpectraMaster Colors -- YS232' => 0x1B0A66 ,
'SpectraMaster Colors -- YS233' => 0x1B098E ,
'SpectraMaster Colors -- YS234' => 0x1B0981 ,
'SpectraMaster Colors -- YS235' => 0x120673 ,
'SpectraMaster Colors -- YS236' => 0x1B0A58 ,
'SpectraMaster Colors -- YS237' => 0x12068D ,
'SpectraMaster Colors -- YS238' => 0x120680 ,
'SpectraMaster Colors -- YS239' => 0x120665 ,
'SpectraMaster Colors -- YS240' => 0x120659 ,
'SpectraMaster Colors -- YS241' => 0x591F80 ,
'SpectraMaster Colors -- YS242' => 0x4F1B73 ,
'SpectraMaster Colors -- YS243' => 0x441865 ,
'SpectraMaster Colors -- YS244' => 0x3A1859 ,
'SpectraMaster Colors -- YS245' => 0x43197F ,
'SpectraMaster Colors -- YS246' => 0x331274 ,
'SpectraMaster Colors -- YS247' => 0x311466 ,
'SpectraMaster Colors -- YS248' => 0x240E59 ,
'SpectraMaster Colors -- YS249' => 0x31144B ,
'SpectraMaster Colors -- YS250' => 0x270F3D ,
'SpectraMaster Colors -- YS251' => 0x1E0C30 ,
'SpectraMaster Colors -- YS252' => 0x110633 ,
'SpectraMaster Colors -- YS253' => 0x12064B ,
'SpectraMaster Colors -- YS254' => 0x1B0A4B ,
'SpectraMaster Colors -- YS255' => 0x190A3F ,
'SpectraMaster Colors -- YS256' => 0x150824 ,
'SpectraMaster Colors -- YS257' => 0x2F0D4B ,
'SpectraMaster Colors -- YS258' => 0x260A3D ,
'SpectraMaster Colors -- YS259' => 0x1D0830 ,
'SpectraMaster Colors -- YS260' => 0x150624 ,
'SpectraMaster Colors -- YS261' => 0x1B074D ,
'SpectraMaster Colors -- YS262' => 0x1B073F ,
'SpectraMaster Colors -- YS263' => 0x120534 ,
'SpectraMaster Colors -- YS264' => 0x0C0318 ,
'SpectraMaster Colors -- YS265' => 0x591781 ,
'SpectraMaster Colors -- YS266' => 0x4E1472 ,
'SpectraMaster Colors -- YS267' => 0x451266 ,
'SpectraMaster Colors -- YS268' => 0x391159 ,
'SpectraMaster Colors -- YS269' => 0x41137F ,
'SpectraMaster Colors -- YS270' => 0x330F74 ,
'SpectraMaster Colors -- YS271' => 0x260A67 ,
'SpectraMaster Colors -- YS272' => 0x250A5A ,
'SpectraMaster Colors -- YS273' => 0x7E22AF ,
'SpectraMaster Colors -- YS274' => 0x761FA5 ,
'SpectraMaster Colors -- YS275' => 0x6D1F9A ,
'SpectraMaster Colors -- YS276' => 0x631A8D ,
'SpectraMaster Colors -- YS277' => 0x5717B2 ,
'SpectraMaster Colors -- YS278' => 0x5817A5 ,
'SpectraMaster Colors -- YS279' => 0x411299 ,
'SpectraMaster Colors -- YS280' => 0x41128C ,
'SpectraMaster Colors -- YS281' => 0x1309E3 ,
'SpectraMaster Colors -- YS282' => 0x290CD8 ,
'SpectraMaster Colors -- YS283' => 0x5C19CA ,
'SpectraMaster Colors -- YS284' => 0x7A22BC ,
'SpectraMaster Colors -- YS285' => 0x1106E3 ,
'SpectraMaster Colors -- YS286' => 0x1A07D7 ,
'SpectraMaster Colors -- YS287' => 0x350FCD ,
'SpectraMaster Colors -- YS288' => 0x4513C1 ,
'SpectraMaster Colors -- YS289' => 0x1907E2 ,
'SpectraMaster Colors -- YS290' => 0x1A04DA ,
'SpectraMaster Colors -- YS291' => 0x2606D6 ,
'SpectraMaster Colors -- YS292' => 0x420ED9 ,
'SpectraMaster Colors -- YS293' => 0x1203E5 ,
'SpectraMaster Colors -- YS294' => 0x0F02DA ,
'SpectraMaster Colors -- YS295' => 0x2605CB ,
'SpectraMaster Colors -- YS296' => 0x350ACD ,
'SpectraMaster Colors -- YS297' => 0x6E12CA ,
'SpectraMaster Colors -- YS298' => 0x7F16BB ,
'SpectraMaster Colors -- YS299' => 0x7F16B1 ,
'SpectraMaster Colors -- YS300' => 0x7616A6 ,
'SpectraMaster Colors -- YS301' => 0x450DCD ,
'SpectraMaster Colors -- YS302' => 0x6D12BE ,
'SpectraMaster Colors -- YS303' => 0x5811B2 ,
'SpectraMaster Colors -- YS304' => 0x5811A6 ,
'SpectraMaster Colors -- YS305' => 0x450CC0 ,
'SpectraMaster Colors -- YS306' => 0x460CB4 ,
'SpectraMaster Colors -- YS307' => 0x430CA6 ,
'SpectraMaster Colors -- YS308' => 0x6C149A ,
'SpectraMaster Colors -- YS309' => 0x3208C0 ,
'SpectraMaster Colors -- YS310' => 0x330AB4 ,
'SpectraMaster Colors -- YS311' => 0x330AA7 ,
'SpectraMaster Colors -- YS312' => 0x430C99 ,
'SpectraMaster Colors -- YS313' => 0x1B04CE ,
'SpectraMaster Colors -- YS314' => 0x2808C2 ,
'SpectraMaster Colors -- YS315' => 0x2808B6 ,
'SpectraMaster Colors -- YS316' => 0x1D05B5 ,
'SpectraMaster Colors -- YS317' => 0x1102D0 ,
'SpectraMaster Colors -- YS318' => 0x1D05C3 ,
'SpectraMaster Colors -- YS319' => 0x1203C2 ,
'SpectraMaster Colors -- YS320' => 0x1303B5 ,
'SpectraMaster Colors -- YS321' => 0x430D8C ,
'SpectraMaster Colors -- YS322' => 0x590E82 ,
'SpectraMaster Colors -- YS323' => 0x4A0F72 ,
'SpectraMaster Colors -- YS324' => 0x420D66 ,
'SpectraMaster Colors -- YS325' => 0x350B8F ,
'SpectraMaster Colors -- YS326' => 0x350A81 ,
'SpectraMaster Colors -- YS327' => 0x350A74 ,
'SpectraMaster Colors -- YS328' => 0x340A66 ,
'SpectraMaster Colors -- YS329' => 0x2807A8 ,
'SpectraMaster Colors -- YS330' => 0x27069B ,
'SpectraMaster Colors -- YS331' => 0x27068E ,
'SpectraMaster Colors -- YS332' => 0x280681 ,
'SpectraMaster Colors -- YS333' => 0x1D05A8 ,
'SpectraMaster Colors -- YS334' => 0x1C049A ,
'SpectraMaster Colors -- YS335' => 0x1C048F ,
'SpectraMaster Colors -- YS336' => 0x1D0482 ,
'SpectraMaster Colors -- YS337' => 0x280675 ,
'SpectraMaster Colors -- YS338' => 0x1D0467 ,
'SpectraMaster Colors -- YS339' => 0x3A0A58 ,
'SpectraMaster Colors -- YS340' => 0x31094B ,
'SpectraMaster Colors -- YS341' => 0x1D0474 ,
'SpectraMaster Colors -- YS342' => 0x130267 ,
'SpectraMaster Colors -- YS343' => 0x260659 ,
'SpectraMaster Colors -- YS344' => 0x130359 ,
'SpectraMaster Colors -- YS345' => 0x1B044D ,
'SpectraMaster Colors -- YS346' => 0x26063E ,
'SpectraMaster Colors -- YS347' => 0x1D0531 ,
'SpectraMaster Colors -- YS348' => 0x140424 ,
'SpectraMaster Colors -- YS349' => 0x13034C ,
'SpectraMaster Colors -- YS350' => 0x120340 ,
'SpectraMaster Colors -- YS351' => 0x120333 ,
'SpectraMaster Colors -- YS352' => 0x0C0218 ,
'SpectraMaster Colors -- YS353' => 0x2E044C ,
'SpectraMaster Colors -- YS354' => 0x25023E ,
'SpectraMaster Colors -- YS355' => 0x1C0231 ,
'SpectraMaster Colors -- YS356' => 0x140124 ,
'SpectraMaster Colors -- YS357' => 0x1C014D ,
'SpectraMaster Colors -- YS358' => 0x130141 ,
'SpectraMaster Colors -- YS359' => 0x130134 ,
'SpectraMaster Colors -- YS360' => 0x0C0118 ,
'SpectraMaster Colors -- YS361' => 0x570680 ,
'SpectraMaster Colors -- YS362' => 0x4A0873 ,
'SpectraMaster Colors -- YS363' => 0x410767 ,
'SpectraMaster Colors -- YS364' => 0x38055A ,
'SpectraMaster Colors -- YS365' => 0x360581 ,
'SpectraMaster Colors -- YS366' => 0x350573 ,
'SpectraMaster Colors -- YS367' => 0x280267 ,
'SpectraMaster Colors -- YS368' => 0x270259 ,
'SpectraMaster Colors -- YS369' => 0x7D07B0 ,
'SpectraMaster Colors -- YS370' => 0x7303A2 ,
'SpectraMaster Colors -- YS371' => 0x6C0999 ,
'SpectraMaster Colors -- YS372' => 0x61088B ,
'SpectraMaster Colors -- YS373' => 0x5805B2 ,
'SpectraMaster Colors -- YS374' => 0x5705A4 ,
'SpectraMaster Colors -- YS375' => 0x430698 ,
'SpectraMaster Colors -- YS376' => 0x44078C ,
'SpectraMaster Colors -- YS377' => 0x2304E3 ,
'SpectraMaster Colors -- YS378' => 0x6107D8 ,
'SpectraMaster Colors -- YS379' => 0x7209CA ,
'SpectraMaster Colors -- YS380' => 0x6A08BD ,
'SpectraMaster Colors -- YS381' => 0x1C04E5 ,
'SpectraMaster Colors -- YS382' => 0x4404D8 ,
'SpectraMaster Colors -- YS383' => 0x5606CB ,
'SpectraMaster Colors -- YS384' => 0x5807C0 ,
'SpectraMaster Colors -- YS385' => 0x1C00E5 ,
'SpectraMaster Colors -- YS386' => 0x26FFD5 ,
'SpectraMaster Colors -- YS387' => 0x3800E3 ,
'SpectraMaster Colors -- YS388' => 0x4500D9 ,
'SpectraMaster Colors -- YS389' => 0x10FFE4 ,
'SpectraMaster Colors -- YS390' => 0x18FFD8 ,
'SpectraMaster Colors -- YS391' => 0x2500E0 ,
'SpectraMaster Colors -- YS392' => 0x3600D8 ,
'SpectraMaster Colors -- YS393' => 0x5CFAD5 ,
'SpectraMaster Colors -- YS394' => 0x6600C9 ,
'SpectraMaster Colors -- YS395' => 0x6000BE ,
'SpectraMaster Colors -- YS396' => 0x6AFDB0 ,
'SpectraMaster Colors -- YS397' => 0x4500CC ,
'SpectraMaster Colors -- YS398' => 0x4700C0 ,
'SpectraMaster Colors -- YS399' => 0x4700B4 ,
'SpectraMaster Colors -- YS400' => 0x75FFA6 ,
'SpectraMaster Colors -- YS401' => 0x6BFF9B ,
'SpectraMaster Colors -- YS402' => 0x63008E ,
'SpectraMaster Colors -- YS403' => 0x590081 ,
'SpectraMaster Colors -- YS404' => 0x430065 ,
'SpectraMaster Colors -- YS405' => 0x440198 ,
'SpectraMaster Colors -- YS406' => 0x44018B ,
'SpectraMaster Colors -- YS407' => 0x4C0071 ,
'SpectraMaster Colors -- YS408' => 0x290069 ,
'SpectraMaster Colors -- YS409' => 0x3600CB ,
'SpectraMaster Colors -- YS410' => 0x3300C0 ,
'SpectraMaster Colors -- YS411' => 0x3400B4 ,
'SpectraMaster Colors -- YS412' => 0x3501A8 ,
'SpectraMaster Colors -- YS413' => 0x2600C9 ,
'SpectraMaster Colors -- YS414' => 0x26FFC1 ,
'SpectraMaster Colors -- YS415' => 0x2600B7 ,
'SpectraMaster Colors -- YS416' => 0x2600A8 ,
'SpectraMaster Colors -- YS417' => 0x19FFCD ,
'SpectraMaster Colors -- YS418' => 0x1A00C2 ,
'SpectraMaster Colors -- YS419' => 0x1B00B7 ,
'SpectraMaster Colors -- YS420' => 0x1C00AA ,
'SpectraMaster Colors -- YS421' => 0x10FFCD ,
'SpectraMaster Colors -- YS422' => 0x1100C2 ,
'SpectraMaster Colors -- YS423' => 0x1300B6 ,
'SpectraMaster Colors -- YS424' => 0x1C009B ,
'SpectraMaster Colors -- YS425' => 0x35019A ,
'SpectraMaster Colors -- YS426' => 0x34FE8C ,
'SpectraMaster Colors -- YS427' => 0x350082 ,
'SpectraMaster Colors -- YS428' => 0x350072 ,
'SpectraMaster Colors -- YS429' => 0x27009B ,
'SpectraMaster Colors -- YS430' => 0x27008D ,
'SpectraMaster Colors -- YS431' => 0x280081 ,
'SpectraMaster Colors -- YS432' => 0x290075 ,
'SpectraMaster Colors -- YS433' => 0x1C0080 ,
'SpectraMaster Colors -- YS434' => 0x1D0074 ,
'SpectraMaster Colors -- YS435' => 0x1D0067 ,
'SpectraMaster Colors -- YS436' => 0x1D005C ,
'SpectraMaster Colors -- YS437' => 0x120080 ,
'SpectraMaster Colors -- YS438' => 0x130073 ,
'SpectraMaster Colors -- YS439' => 0x130067 ,
'SpectraMaster Colors -- YS440' => 0x13005B ,
'SpectraMaster Colors -- YS441' => 0x370059 ,
'SpectraMaster Colors -- YS442' => 0x2D004B ,
'SpectraMaster Colors -- YS443' => 0x24003E ,
'SpectraMaster Colors -- YS444' => 0x130034 ,
'SpectraMaster Colors -- YS445' => 0x270059 ,
'SpectraMaster Colors -- YS446' => 0x1C004D ,
'SpectraMaster Colors -- YS447' => 0x1C0031 ,
'SpectraMaster Colors -- YS448' => 0x0B0018 ,
'SpectraMaster Colors -- YS449' => 0x2CFC4B ,
'SpectraMaster Colors -- YS450' => 0x24FC3E ,
'SpectraMaster Colors -- YS451' => 0x1BFD31 ,
'SpectraMaster Colors -- YS452' => 0x14FE25 ,
'SpectraMaster Colors -- YS453' => 0x1CFD4C ,
'SpectraMaster Colors -- YS454' => 0x13FE40 ,
'SpectraMaster Colors -- YS455' => 0x13FE33 ,
'SpectraMaster Colors -- YS456' => 0x0BFF18 ,
'SpectraMaster Colors -- YS457' => 0x62F68E ,
'SpectraMaster Colors -- YS458' => 0x4CF872 ,
'SpectraMaster Colors -- YS459' => 0x3FFC66 ,
'SpectraMaster Colors -- YS460' => 0x36FC59 ,
'SpectraMaster Colors -- YS461' => 0x46F87F ,
'SpectraMaster Colors -- YS462' => 0x35FD71 ,
'SpectraMaster Colors -- YS463' => 0x27FD64 ,
'SpectraMaster Colors -- YS464' => 0x27FD58 ,
'SpectraMaster Colors -- YS465' => 0x59F7B1 ,
'SpectraMaster Colors -- YS466' => 0x68F6A5 ,
'SpectraMaster Colors -- YS467' => 0x6CF59B ,
'SpectraMaster Colors -- YS468' => 0x62F68F ,
'SpectraMaster Colors -- YS469' => 0x43FAB1 ,
'SpectraMaster Colors -- YS470' => 0x5AF6A6 ,
'SpectraMaster Colors -- YS471' => 0x44FB96 ,
'SpectraMaster Colors -- YS472' => 0x44FC8A ,
'SpectraMaster Colors -- YS473' => 0x43FCE2 ,
'SpectraMaster Colors -- YS474' => 0x5AF6D4 ,
'SpectraMaster Colors -- YS475' => 0x5EF7C8 ,
'SpectraMaster Colors -- YS476' => 0x58F8BE ,
'SpectraMaster Colors -- YS477' => 0x38FBE2 ,
'SpectraMaster Colors -- YS478' => 0x45FBD5 ,
'SpectraMaster Colors -- YS479' => 0x57F7C9 ,
'SpectraMaster Colors -- YS480' => 0x47FABF ,
'SpectraMaster Colors -- YS481' => 0x1CFBE2 ,
'SpectraMaster Colors -- YS482' => 0x4DF0E1 ,
'SpectraMaster Colors -- YS483' => 0x4BF2D7 ,
'SpectraMaster Colors -- YS484' => 0x37F7D7 ,
'SpectraMaster Colors -- YS485' => 0x10FCE1 ,
'SpectraMaster Colors -- YS486' => 0x34F0DD ,
'SpectraMaster Colors -- YS487' => 0x42F2D3 ,
'SpectraMaster Colors -- YS488' => 0x1BFAD4 ,
'SpectraMaster Colors -- YS489' => 0x53F0C9 ,
'SpectraMaster Colors -- YS490' => 0x56F0BD ,
'SpectraMaster Colors -- YS491' => 0x4CF2B2 ,
'SpectraMaster Colors -- YS492' => 0x57F0A5 ,
'SpectraMaster Colors -- YS493' => 0x46F2C9 ,
'SpectraMaster Colors -- YS494' => 0x47F3BF ,
'SpectraMaster Colors -- YS495' => 0x47F4B2 ,
'SpectraMaster Colors -- YS496' => 0x59F0A4 ,
'SpectraMaster Colors -- YS497' => 0x62ED99 ,
'SpectraMaster Colors -- YS498' => 0x61ED8E ,
'SpectraMaster Colors -- YS499' => 0x57EE80 ,
'SpectraMaster Colors -- YS500' => 0x4CF073 ,
'SpectraMaster Colors -- YS501' => 0x48F599 ,
'SpectraMaster Colors -- YS502' => 0x46F58D ,
'SpectraMaster Colors -- YS503' => 0x46F581 ,
'SpectraMaster Colors -- YS504' => 0x35F670 ,
'SpectraMaster Colors -- YS505' => 0x37F8CB ,
'SpectraMaster Colors -- YS506' => 0x37F7BF ,
'SpectraMaster Colors -- YS507' => 0x25F9B6 ,
'SpectraMaster Colors -- YS508' => 0x48F5A6 ,
'SpectraMaster Colors -- YS509' => 0x25F9C7 ,
'SpectraMaster Colors -- YS510' => 0x26F9BD ,
'SpectraMaster Colors -- YS511' => 0x1BFBA9 ,
'SpectraMaster Colors -- YS512' => 0x25F8A9 ,
'SpectraMaster Colors -- YS513' => 0x19FACC ,
'SpectraMaster Colors -- YS514' => 0x1AFBC2 ,
'SpectraMaster Colors -- YS515' => 0x1BFAB6 ,
'SpectraMaster Colors -- YS516' => 0x12FCB6 ,
'SpectraMaster Colors -- YS517' => 0x10FCD7 ,
'SpectraMaster Colors -- YS518' => 0x10FCCD ,
'SpectraMaster Colors -- YS519' => 0x11FCC2 ,
'SpectraMaster Colors -- YS520' => 0x13FDA9 ,
'SpectraMaster Colors -- YS521' => 0x36F899 ,
'SpectraMaster Colors -- YS522' => 0x36F78B ,
'SpectraMaster Colors -- YS523' => 0x34F77D ,
'SpectraMaster Colors -- YS524' => 0x41F363 ,
'SpectraMaster Colors -- YS525' => 0x26F89A ,
'SpectraMaster Colors -- YS526' => 0x27F98D ,
'SpectraMaster Colors -- YS527' => 0x28F981 ,
'SpectraMaster Colors -- YS528' => 0x29FA75 ,
'SpectraMaster Colors -- YS529' => 0x1BFC9C ,
'SpectraMaster Colors -- YS530' => 0x1CFC8D ,
'SpectraMaster Colors -- YS531' => 0x1CFC81 ,
'SpectraMaster Colors -- YS532' => 0x1DFC73 ,
'SpectraMaster Colors -- YS533' => 0x12FE9C ,
'SpectraMaster Colors -- YS534' => 0x12FE8E ,
'SpectraMaster Colors -- YS535' => 0x13FD80 ,
'SpectraMaster Colors -- YS536' => 0x13FD73 ,
'SpectraMaster Colors -- YS537' => 0x29FB69 ,
'SpectraMaster Colors -- YS538' => 0x1DFC5C ,
'SpectraMaster Colors -- YS539' => 0x34F858 ,
'SpectraMaster Colors -- YS540' => 0x12FD5A ,
'SpectraMaster Colors -- YS541' => 0x1DFC68 ,
'SpectraMaster Colors -- YS542' => 0x13FD67 ,
'SpectraMaster Colors -- YS543' => 0x27F957 ,
'SpectraMaster Colors -- YS544' => 0x13FD4E ,
'SpectraMaster Colors -- YS545' => 0x2BF84A ,
'SpectraMaster Colors -- YS546' => 0x23F93D ,
'SpectraMaster Colors -- YS547' => 0x1BFB31 ,
'SpectraMaster Colors -- YS548' => 0x13FC24 ,
'SpectraMaster Colors -- YS549' => 0x1CFB4C ,
'SpectraMaster Colors -- YS550' => 0x13FC41 ,
'SpectraMaster Colors -- YS551' => 0x13FC34 ,
'SpectraMaster Colors -- YS552' => 0x0BFE18 ,
'SpectraMaster Colors -- YS553' => 0x2AF549 ,
'SpectraMaster Colors -- YS554' => 0x22F63F ,
'SpectraMaster Colors -- YS555' => 0x1AF930 ,
'SpectraMaster Colors -- YS556' => 0x13FB24 ,
'SpectraMaster Colors -- YS557' => 0x1BF94B ,
'SpectraMaster Colors -- YS558' => 0x12FB41 ,
'SpectraMaster Colors -- YS559' => 0x13FB33 ,
'SpectraMaster Colors -- YS560' => 0x0BFD17 ,
'SpectraMaster Colors -- YS561' => 0x36F38D ,
'SpectraMaster Colors -- YS562' => 0x55E67E ,
'SpectraMaster Colors -- YS563' => 0x4CEA73 ,
'SpectraMaster Colors -- YS564' => 0x36F25B ,
'SpectraMaster Colors -- YS565' => 0x36F382 ,
'SpectraMaster Colors -- YS566' => 0x44EB7E ,
'SpectraMaster Colors -- YS567' => 0x3EF166 ,
'SpectraMaster Colors -- YS568' => 0x25F756 ,
'SpectraMaster Colors -- YS569' => 0x54E9B1 ,
'SpectraMaster Colors -- YS570' => 0x4BEBA5 ,
'SpectraMaster Colors -- YS571' => 0x54E897 ,
'SpectraMaster Colors -- YS572' => 0x5DE58B ,
'SpectraMaster Colors -- YS573' => 0x44EFAE ,
'SpectraMaster Colors -- YS574' => 0x44EFA3 ,
'SpectraMaster Colors -- YS575' => 0x45EF99 ,
'SpectraMaster Colors -- YS576' => 0x44F08D ,
'SpectraMaster Colors -- YS577' => 0x3FECE2 ,
'SpectraMaster Colors -- YS578' => 0x57E7D3 ,
'SpectraMaster Colors -- YS579' => 0x4EEAC9 ,
'SpectraMaster Colors -- YS580' => 0x52E9BD ,
'SpectraMaster Colors -- YS581' => 0x32F2E1 ,
'SpectraMaster Colors -- YS582' => 0x42EDD4 ,
'SpectraMaster Colors -- YS583' => 0x43EDC8 ,
'SpectraMaster Colors -- YS584' => 0x43EEBB ,
'SpectraMaster Colors -- YS901' => 0x7107D4 ,
'SpectraMaster Colors -- YS902' => 0x750DCD ,
'SpectraMaster Colors -- YS903' => 0x6107D8 ,
'SpectraMaster Colors -- YS904' => 0x650CCB ,
'SpectraMaster Colors -- YS905' => 0x5AF7D4 ,
'SpectraMaster Colors -- YS906' => 0x6400C6 ,
'SpectraMaster Colors -- YS907' => 0x7209CA ,
'SpectraMaster Colors -- YS908' => 0x700AC8 ,
'SpectraMaster Colors -- YS909' => 0x580DC8 ,
'SpectraMaster Colors -- YS910' => 0x650DC8 ,
'SpectraMaster Colors -- YS911' => 0x6E13CA ,
'SpectraMaster Colors -- YS912' => 0x6D13BE ,
'SpectraMaster Colors -- YS913' => 0x6017BE ,
'SpectraMaster Colors -- YS914' => 0x7414BD ,
'SpectraMaster Colors -- YS915' => 0x5C19CA ,
'SpectraMaster Colors -- YS916' => 0x6B26A7 ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Yellow CVC' => 0x63FFE7 ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Orange CVC' => 0x5637AE ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Magenta CVC' => 0xFA4F83 ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Cyan CVC' => 0xCCDC80 ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Green CVC' => 0x22B599 ,
'PANTONE Hexachrome - Coated -- PANTONE Hexachrome Black CVC' => 0xFF001C ,
'PANTONE Hexachrome - Coated -- UNASSIGNED' => 0x0000FF ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-1 CVC' => 0x51FBE9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-2 CVC' => 0x50FBE8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-3 CVC' => 0x49FBEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-4 CVC' => 0x48FBEB ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-5 CVC' => 0x3EFBEC ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-6 CVC' => 0x29FCEE ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-7 CVC' => 0x13FEF1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-8 CVC' => 0x51FDE7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-9 CVC' => 0x4EFBEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-10 CVC' => 0x44FBEB ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-11 CVC' => 0x3EFBEC ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-12 CVC' => 0x34FBED ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-13 CVC' => 0x1EFDEF ,
'PANTONE Hexachrome - Coated -- PANTONE H 10-14 CVC' => 0x0EFFF1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-1 CVC' => 0x47FBD2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-2 CVC' => 0x46FBD2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-3 CVC' => 0x43FBDC ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-4 CVC' => 0x41FBDC ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-5 CVC' => 0x3CFBE3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-6 CVC' => 0x28FCE6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-7 CVC' => 0x11FEE8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-8 CVC' => 0x42FCC3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-9 CVC' => 0x3EFAC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-10 CVC' => 0x38FBCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-11 CVC' => 0x34FBCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-12 CVC' => 0x2CFBD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-13 CVC' => 0x19FDD6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 15-14 CVC' => 0x0BFFE3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-1 CVC' => 0x35FBA3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-2 CVC' => 0x3CFBB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-3 CVC' => 0x34FBB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-4 CVC' => 0x39FBC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-5 CVC' => 0x31FBC3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-6 CVC' => 0x22FCCE ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-7 CVC' => 0x0EFED8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-8 CVC' => 0x25FC78 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-9 CVC' => 0x28FB88 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-10 CVC' => 0x27FB93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-11 CVC' => 0x28FBA0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-12 CVC' => 0x24FBB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-13 CVC' => 0x16FDC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 20-14 CVC' => 0x0AFFD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-1 CVC' => 0x5203E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-2 CVC' => 0x4E00E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-3 CVC' => 0x4700E6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-4 CVC' => 0x4100E6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-5 CVC' => 0x35FDEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-6 CVC' => 0x24FFEC ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-7 CVC' => 0x1400EE ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-8 CVC' => 0x5209DC ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-9 CVC' => 0x4F06DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-10 CVC' => 0x4B04E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-11 CVC' => 0x4504E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-12 CVC' => 0x3C03E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-13 CVC' => 0x3201E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 25-14 CVC' => 0x1EFFED ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-1 CVC' => 0x4801CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-2 CVC' => 0x43FFCE ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-3 CVC' => 0x41FFD7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-4 CVC' => 0x3AFFD8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-5 CVC' => 0x33FDE2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-6 CVC' => 0x24FEE4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-7 CVC' => 0x1300E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-8 CVC' => 0x4305BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-9 CVC' => 0x4002BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-10 CVC' => 0x4002C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-11 CVC' => 0x3A00C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-12 CVC' => 0x3401CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-13 CVC' => 0x2CFFD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 30-14 CVC' => 0x1CFEDE ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-1 CVC' => 0x37FFA1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-2 CVC' => 0x3AFEB2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-3 CVC' => 0x33FEB2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-4 CVC' => 0x33FEC1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-5 CVC' => 0x2AFDC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-6 CVC' => 0x1EFECC ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-7 CVC' => 0x1000D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-8 CVC' => 0x290079 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-9 CVC' => 0x2B0088 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-10 CVC' => 0x2DFF94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-11 CVC' => 0x2DFF9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-12 CVC' => 0x2C00B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-13 CVC' => 0x28FFC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 35-14 CVC' => 0x18FECC ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-1 CVC' => 0x5210D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-2 CVC' => 0x510ED7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-3 CVC' => 0x4C0ADB ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-4 CVC' => 0x4508DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-5 CVC' => 0x3A05E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-6 CVC' => 0x2D04E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-7 CVC' => 0x1E02E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-8 CVC' => 0x5319CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-9 CVC' => 0x5016CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-10 CVC' => 0x4813D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-11 CVC' => 0x4311D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-12 CVC' => 0x3E0ED9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-13 CVC' => 0x360BDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 40-14 CVC' => 0x2609E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-1 CVC' => 0x460CBE ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-2 CVC' => 0x460AC1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-3 CVC' => 0x4508CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-4 CVC' => 0x3D06D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-5 CVC' => 0x3705D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-6 CVC' => 0x2A03DA ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-7 CVC' => 0x1C02E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-8 CVC' => 0x4312AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-9 CVC' => 0x4010AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-10 CVC' => 0x3B0FB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-11 CVC' => 0x370CBA ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-12 CVC' => 0x350BC3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-13 CVC' => 0x2E09C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 45-14 CVC' => 0x2207D4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-1 CVC' => 0x340793 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-2 CVC' => 0x3A07A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-3 CVC' => 0x3705A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-4 CVC' => 0x3504BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-5 CVC' => 0x2F03BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-6 CVC' => 0x2602C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-7 CVC' => 0x1A01D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-8 CVC' => 0x27096A ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-9 CVC' => 0x2A0976 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-10 CVC' => 0x2A0884 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-11 CVC' => 0x2B0892 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-12 CVC' => 0x2E08A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-13 CVC' => 0x2B07B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 50-14 CVC' => 0x2006C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-1 CVC' => 0x5824C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-2 CVC' => 0x5220C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-3 CVC' => 0x4A1BCA ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-4 CVC' => 0x4618CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-5 CVC' => 0x4215D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-6 CVC' => 0x3D0FD8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-7 CVC' => 0x330BDB ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-8 CVC' => 0x5B2BB9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-9 CVC' => 0x5527BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-10 CVC' => 0x5125C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-11 CVC' => 0x4D22C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-12 CVC' => 0x451CCB ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-13 CVC' => 0x3D15D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 55-14 CVC' => 0x310FDA ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-1 CVC' => 0x4A1DAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-2 CVC' => 0x4719B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-3 CVC' => 0x4517BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-4 CVC' => 0x4015C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-5 CVC' => 0x3E13CA ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-6 CVC' => 0x3A0DCF ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-7 CVC' => 0x310BD2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-8 CVC' => 0x482199 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-9 CVC' => 0x441D9C ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-10 CVC' => 0x431CA7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-11 CVC' => 0x4019AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-12 CVC' => 0x3E17B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-13 CVC' => 0x3611BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 60-14 CVC' => 0x2E0ECB ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-1 CVC' => 0x391387 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-2 CVC' => 0x3D1497 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-3 CVC' => 0x36109C ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-4 CVC' => 0x3811AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-5 CVC' => 0x350FAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-6 CVC' => 0x330ABB ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-7 CVC' => 0x2D09C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-8 CVC' => 0x2C1262 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-9 CVC' => 0x2E126E ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-10 CVC' => 0x2F1278 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-11 CVC' => 0x311285 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-12 CVC' => 0x341199 ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-13 CVC' => 0x310FAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 65-14 CVC' => 0x280BBC ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-1 CVC' => 0x5F36AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-2 CVC' => 0x5B31B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-3 CVC' => 0x4E25C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-4 CVC' => 0x3D1BCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-5 CVC' => 0x2A10DA ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-6 CVC' => 0x1F0BE1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-7 CVC' => 0x1206E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-8 CVC' => 0x5F36AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-9 CVC' => 0x552BBA ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-10 CVC' => 0x4620C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-11 CVC' => 0x3114D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-12 CVC' => 0x230EDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-13 CVC' => 0x1809E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 70-14 CVC' => 0x0D04EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-1 CVC' => 0x552F9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-2 CVC' => 0x5129A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-3 CVC' => 0x4922B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-4 CVC' => 0x3918C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-5 CVC' => 0x2710D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-6 CVC' => 0x1D0AD9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-7 CVC' => 0x1106E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-8 CVC' => 0x4E2B90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-9 CVC' => 0x45219C ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-10 CVC' => 0x3B1AAE ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-11 CVC' => 0x280FBC ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-12 CVC' => 0x1F0BC8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-13 CVC' => 0x1607CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 75-14 CVC' => 0x0C04DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-1 CVC' => 0x3F2177 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-2 CVC' => 0x43228A ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-3 CVC' => 0x3B1A93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-4 CVC' => 0x3314AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-5 CVC' => 0x220CB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-6 CVC' => 0x1A09C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-7 CVC' => 0x0F05D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-8 CVC' => 0x2B1859 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-9 CVC' => 0x2D146C ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-10 CVC' => 0x2A107E ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-11 CVC' => 0x200B97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-12 CVC' => 0x1A08AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-13 CVC' => 0x1306BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 80-14 CVC' => 0x0A03CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-1 CVC' => 0x5C35AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-2 CVC' => 0x5831B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-3 CVC' => 0x522BBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-4 CVC' => 0x4C25C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-5 CVC' => 0x4320C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-6 CVC' => 0x381BCE ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-7 CVC' => 0x2C15D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-8 CVC' => 0x5A37AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-9 CVC' => 0x5633B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-10 CVC' => 0x4C2BBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-11 CVC' => 0x4525C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-12 CVC' => 0x3C20C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-13 CVC' => 0x351DCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 85-14 CVC' => 0x2D18D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-1 CVC' => 0x502E9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-2 CVC' => 0x4B28A3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-3 CVC' => 0x4A25B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-4 CVC' => 0x4420B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-5 CVC' => 0x3E1DC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-6 CVC' => 0x3619C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-7 CVC' => 0x2A14CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-8 CVC' => 0x482B91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-9 CVC' => 0x452994 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-10 CVC' => 0x4022A3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-11 CVC' => 0x391DA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-12 CVC' => 0x341AB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-13 CVC' => 0x2F19B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 90-14 CVC' => 0x2916C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-1 CVC' => 0x3D2379 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-2 CVC' => 0x41228C ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-3 CVC' => 0x3C1D92 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-4 CVC' => 0x3C1BA4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-5 CVC' => 0x3518A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-6 CVC' => 0x3015B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-7 CVC' => 0x2711BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-8 CVC' => 0x2A195B ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-9 CVC' => 0x2E1B66 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-10 CVC' => 0x2D1678 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-11 CVC' => 0x2D1589 ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-12 CVC' => 0x2D159A ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-13 CVC' => 0x2C16AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 95-14 CVC' => 0x2613B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-1 CVC' => 0x5937AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-2 CVC' => 0x5533B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-3 CVC' => 0x4B2ABD ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-4 CVC' => 0x4326C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-5 CVC' => 0x3920C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-6 CVC' => 0x311CCE ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-7 CVC' => 0x2313D9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-8 CVC' => 0x5637AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-9 CVC' => 0x5335B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-10 CVC' => 0x4B2FB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-11 CVC' => 0x3E26C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-12 CVC' => 0x3420C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-13 CVC' => 0x2819D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 100-14 CVC' => 0x1A10DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-1 CVC' => 0x4E309C ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-2 CVC' => 0x4A2CA1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-3 CVC' => 0x4325B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-4 CVC' => 0x3D22B7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-5 CVC' => 0x371EC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-6 CVC' => 0x2F1AC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-7 CVC' => 0x2111D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-8 CVC' => 0x452B91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-9 CVC' => 0x432A95 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-10 CVC' => 0x3F26A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-11 CVC' => 0x341FAA ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-12 CVC' => 0x2E1BB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-13 CVC' => 0x2215BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 105-14 CVC' => 0x180ED1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-1 CVC' => 0x392279 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-2 CVC' => 0x3E238A ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-3 CVC' => 0x361C93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-4 CVC' => 0x341BA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-5 CVC' => 0x2D18AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-6 CVC' => 0x2916B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-7 CVC' => 0x1E0FC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-8 CVC' => 0x27195B ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-9 CVC' => 0x2C1B67 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-10 CVC' => 0x2C1976 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-11 CVC' => 0x291787 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-12 CVC' => 0x26159B ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-13 CVC' => 0x2012B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 110-14 CVC' => 0x160CC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-1 CVC' => 0x5336AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-2 CVC' => 0x4F32B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-3 CVC' => 0x462CBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-4 CVC' => 0x3B25C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-5 CVC' => 0x2E1ECC ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-6 CVC' => 0x2619D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-7 CVC' => 0x1811DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-8 CVC' => 0x5136AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-9 CVC' => 0x4D32B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-10 CVC' => 0x3F29BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-11 CVC' => 0x3523C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-12 CVC' => 0x271BD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-13 CVC' => 0x1B13DA ,
'PANTONE Hexachrome - Coated -- PANTONE H 115-14 CVC' => 0x100AE4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-1 CVC' => 0x482F9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-2 CVC' => 0x452BA2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-3 CVC' => 0x4028B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-4 CVC' => 0x3521B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-5 CVC' => 0x2C1CC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-6 CVC' => 0x2517CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-7 CVC' => 0x160FD6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-8 CVC' => 0x412B92 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-9 CVC' => 0x3E2797 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-10 CVC' => 0x3521A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-11 CVC' => 0x2C1CAE ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-12 CVC' => 0x2116BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-13 CVC' => 0x170FC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 120-14 CVC' => 0x0E09D7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-1 CVC' => 0x352278 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-2 CVC' => 0x38238A ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-3 CVC' => 0x321E91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-4 CVC' => 0x2D1BA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-5 CVC' => 0x2416AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-6 CVC' => 0x1E13B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-7 CVC' => 0x140DC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-8 CVC' => 0x25185A ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-9 CVC' => 0x281968 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-10 CVC' => 0x251678 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-11 CVC' => 0x221489 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-12 CVC' => 0x1C11A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-13 CVC' => 0x140DB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 125-14 CVC' => 0x0D08C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-1 CVC' => 0x4A31B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-2 CVC' => 0x4A31B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-3 CVC' => 0x3D28BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-4 CVC' => 0x3725C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-5 CVC' => 0x2B1FCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-6 CVC' => 0x1B14D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-7 CVC' => 0x0D0AE7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-8 CVC' => 0x4831B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-9 CVC' => 0x442DBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-10 CVC' => 0x3826C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-11 CVC' => 0x3021C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-12 CVC' => 0x241AD1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-13 CVC' => 0x140FDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 130-14 CVC' => 0x0907EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-1 CVC' => 0x422BA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-2 CVC' => 0x402AAA ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-3 CVC' => 0x3825B7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-4 CVC' => 0x3222BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-5 CVC' => 0x2A1DC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-6 CVC' => 0x1A13D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-7 CVC' => 0x0D09DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-8 CVC' => 0x3C289F ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-9 CVC' => 0x3924A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-10 CVC' => 0x301FAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-11 CVC' => 0x281BB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-12 CVC' => 0x1F16C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-13 CVC' => 0x100CCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 135-14 CVC' => 0x0806DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-1 CVC' => 0x311F89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-2 CVC' => 0x352295 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-3 CVC' => 0x2E1D99 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-4 CVC' => 0x2E1DA7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-5 CVC' => 0x2418AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-6 CVC' => 0x1711BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-7 CVC' => 0x0B08D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-8 CVC' => 0x231669 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-9 CVC' => 0x251774 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-10 CVC' => 0x221581 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-11 CVC' => 0x21148D ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-12 CVC' => 0x1A11A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-13 CVC' => 0x100BBE ,
'PANTONE Hexachrome - Coated -- PANTONE H 140-14 CVC' => 0x0705CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-1 CVC' => 0x4432B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-2 CVC' => 0x402EB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-3 CVC' => 0x3528BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-4 CVC' => 0x2E25C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-5 CVC' => 0x241CCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-6 CVC' => 0x1714D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-7 CVC' => 0x0C0DE3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-8 CVC' => 0x4136A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-9 CVC' => 0x3D32B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-10 CVC' => 0x382EB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-11 CVC' => 0x3028BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-12 CVC' => 0x2623C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-13 CVC' => 0x1F1CCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 145-14 CVC' => 0x1311DC ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-1 CVC' => 0x3D2DA3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-2 CVC' => 0x3A29A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-3 CVC' => 0x3326B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-4 CVC' => 0x2B22B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-5 CVC' => 0x231BC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-6 CVC' => 0x1713D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-7 CVC' => 0x0B0CDB ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-8 CVC' => 0x362C94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-9 CVC' => 0x342998 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-10 CVC' => 0x3127A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-11 CVC' => 0x2A22A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-12 CVC' => 0x211EB1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-13 CVC' => 0x1B18BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 150-14 CVC' => 0x1210D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-1 CVC' => 0x2E2284 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-2 CVC' => 0x312293 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-3 CVC' => 0x281D96 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-4 CVC' => 0x261DA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-5 CVC' => 0x1C16AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-6 CVC' => 0x1310BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-7 CVC' => 0x0A0BCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-8 CVC' => 0x201A64 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-9 CVC' => 0x211A6D ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-10 CVC' => 0x211A78 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-11 CVC' => 0x1F1887 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-12 CVC' => 0x1C1898 ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-13 CVC' => 0x1815AE ,
'PANTONE Hexachrome - Coated -- PANTONE H 155-14 CVC' => 0x100EC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-1 CVC' => 0x463BA1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-2 CVC' => 0x453AA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-3 CVC' => 0x3D34AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-4 CVC' => 0x322DB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-5 CVC' => 0x2726BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-6 CVC' => 0x1B1EC9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-7 CVC' => 0x1114D7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-8 CVC' => 0x423F99 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-9 CVC' => 0x3D3C9E ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-10 CVC' => 0x3036A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-11 CVC' => 0x2832AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-12 CVC' => 0x222DB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-13 CVC' => 0x1D27BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 160-14 CVC' => 0x121EC9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-1 CVC' => 0x3E3595 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-2 CVC' => 0x3E3398 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-3 CVC' => 0x3931A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-4 CVC' => 0x2E2AAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-5 CVC' => 0x2625B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-6 CVC' => 0x1A1DC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-7 CVC' => 0x0F13D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-8 CVC' => 0x373486 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-9 CVC' => 0x34328A ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-10 CVC' => 0x292F96 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-11 CVC' => 0x242C9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-12 CVC' => 0x1E28A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-13 CVC' => 0x1922AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 165-14 CVC' => 0x0F1BC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-1 CVC' => 0x2F2879 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-2 CVC' => 0x342C86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-3 CVC' => 0x30288C ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-4 CVC' => 0x2A259C ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-5 CVC' => 0x201FA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-6 CVC' => 0x181AB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-7 CVC' => 0x0E11C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-8 CVC' => 0x20205A ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-9 CVC' => 0x222367 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-10 CVC' => 0x1F2274 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-11 CVC' => 0x1D237E ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-12 CVC' => 0x1A2290 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-13 CVC' => 0x1820A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 170-14 CVC' => 0x0E18B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-1 CVC' => 0x3E4391 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-2 CVC' => 0x394095 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-3 CVC' => 0x2F3C9C ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-4 CVC' => 0x2939A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-5 CVC' => 0x2235A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-6 CVC' => 0x202DB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-7 CVC' => 0x1A26BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-8 CVC' => 0x39468A ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-9 CVC' => 0x30448E ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-10 CVC' => 0x294291 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-11 CVC' => 0x244095 ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-12 CVC' => 0x203B9E ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-13 CVC' => 0x1A32AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 175-14 CVC' => 0x1327BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-1 CVC' => 0x363C85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-2 CVC' => 0x323A89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-3 CVC' => 0x293895 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-4 CVC' => 0x243599 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-5 CVC' => 0x1F32A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-6 CVC' => 0x1E2AAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-7 CVC' => 0x1823B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-8 CVC' => 0x303B75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-9 CVC' => 0x27397A ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-10 CVC' => 0x233A80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-11 CVC' => 0x1E3884 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-12 CVC' => 0x1B3490 ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-13 CVC' => 0x172D9C ,
'PANTONE Hexachrome - Coated -- PANTONE H 180-14 CVC' => 0x1124B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-1 CVC' => 0x292E6C ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-2 CVC' => 0x2A3279 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-3 CVC' => 0x222E80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-4 CVC' => 0x202F8C ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-5 CVC' => 0x1B2B91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-6 CVC' => 0x1B269F ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-7 CVC' => 0x1521AE ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-8 CVC' => 0x1C2551 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-9 CVC' => 0x1A295B ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-10 CVC' => 0x182B64 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-11 CVC' => 0x182D6B ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-12 CVC' => 0x162D7E ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-13 CVC' => 0x142994 ,
'PANTONE Hexachrome - Coated -- PANTONE H 185-14 CVC' => 0x1021A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-1 CVC' => 0x314884 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-2 CVC' => 0x2B4689 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-3 CVC' => 0x223F97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-4 CVC' => 0x1735A8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-5 CVC' => 0x0D26BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-6 CVC' => 0x091BCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-7 CVC' => 0x0510DC ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-8 CVC' => 0x2F4886 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-9 CVC' => 0x254291 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-10 CVC' => 0x1C3B9E ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-11 CVC' => 0x112BB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-12 CVC' => 0x0B21C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-13 CVC' => 0x0717D4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 190-14 CVC' => 0x040BE3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-1 CVC' => 0x2B417B ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-2 CVC' => 0x253F7F ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-3 CVC' => 0x1F3B90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-4 CVC' => 0x1531A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-5 CVC' => 0x0D24B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-6 CVC' => 0x081AC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-7 CVC' => 0x040FD5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-8 CVC' => 0x263D76 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-9 CVC' => 0x1F3880 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-10 CVC' => 0x173390 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-11 CVC' => 0x0E24A3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-12 CVC' => 0x091CB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-13 CVC' => 0x0513C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 195-14 CVC' => 0x030AD8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-1 CVC' => 0x1F3363 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-2 CVC' => 0x1F3771 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-3 CVC' => 0x19317A ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-4 CVC' => 0x132C91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-5 CVC' => 0x0B1FA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-6 CVC' => 0x0717B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-7 CVC' => 0x040EC8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-8 CVC' => 0x17274F ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-9 CVC' => 0x14275D ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-10 CVC' => 0x10256D ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-11 CVC' => 0x0A1E84 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-12 CVC' => 0x08189F ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-13 CVC' => 0x0512B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 200-14 CVC' => 0x0309CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-1 CVC' => 0x284886 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-2 CVC' => 0x24458B ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-3 CVC' => 0x214291 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-4 CVC' => 0x1E3F94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-5 CVC' => 0x163B9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-6 CVC' => 0x0F33A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-7 CVC' => 0x0929B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-8 CVC' => 0x1B4786 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-9 CVC' => 0x18468A ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-10 CVC' => 0x134194 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-11 CVC' => 0x103D9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-12 CVC' => 0x0D39A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-13 CVC' => 0x0634A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 205-14 CVC' => 0x042CB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-1 CVC' => 0x22417B ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-2 CVC' => 0x1F3E81 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-3 CVC' => 0x1D3E8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-4 CVC' => 0x193B8F ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-5 CVC' => 0x14389A ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-6 CVC' => 0x0E31A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-7 CVC' => 0x0927B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-8 CVC' => 0x163E75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-9 CVC' => 0x133C77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-10 CVC' => 0x0F3984 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-11 CVC' => 0x0D368A ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-12 CVC' => 0x0B3394 ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-13 CVC' => 0x042F9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 210-14 CVC' => 0x0429AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-1 CVC' => 0x1A3563 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-2 CVC' => 0x1A3671 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-3 CVC' => 0x173475 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-4 CVC' => 0x143483 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-5 CVC' => 0x103188 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-6 CVC' => 0x0B2C97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-7 CVC' => 0x0724A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-8 CVC' => 0x0C284F ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-9 CVC' => 0x0A2B57 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-10 CVC' => 0x092B63 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-11 CVC' => 0x082B70 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-12 CVC' => 0x082C80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-13 CVC' => 0x032D90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 215-14 CVC' => 0x0226A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-1 CVC' => 0x144889 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-2 CVC' => 0x0F468D ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-3 CVC' => 0x0D4098 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-4 CVC' => 0x093BA0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-5 CVC' => 0x0636A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-6 CVC' => 0x0332AE ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-7 CVC' => 0x0424C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-8 CVC' => 0x08498A ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-9 CVC' => 0x03498C ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-10 CVC' => 0x004593 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-11 CVC' => 0xFD3DA0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-12 CVC' => 0xFD36AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-13 CVC' => 0xFD2CB8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 220-14 CVC' => 0xFE1CCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-1 CVC' => 0x0F427D ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-2 CVC' => 0x0C4081 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-3 CVC' => 0x0A3C90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-4 CVC' => 0x083897 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-5 CVC' => 0x0635A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-6 CVC' => 0x032FAA ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-7 CVC' => 0x0322BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-8 CVC' => 0x033E78 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-9 CVC' => 0x003D7A ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-10 CVC' => 0xFD3C85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-11 CVC' => 0xFB348F ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-12 CVC' => 0xFB309B ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-13 CVC' => 0xFC26A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 225-14 CVC' => 0xFE1AC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-1 CVC' => 0x093364 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-2 CVC' => 0x093771 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-3 CVC' => 0x06317A ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-4 CVC' => 0x053188 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-5 CVC' => 0x032D8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-6 CVC' => 0x01299B ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-7 CVC' => 0x021DB2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-8 CVC' => 0x00274E ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-9 CVC' => 0xFF2B56 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-10 CVC' => 0xFD2C62 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-11 CVC' => 0xFC2A72 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-12 CVC' => 0xFC2885 ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-13 CVC' => 0xFC239B ,
'PANTONE Hexachrome - Coated -- PANTONE H 230-14 CVC' => 0xFD18B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-1 CVC' => 0x014A8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-2 CVC' => 0xFD488E ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-3 CVC' => 0xFB4397 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-4 CVC' => 0xFA3CA2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-5 CVC' => 0xFC33AE ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-6 CVC' => 0xFA2BB9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-7 CVC' => 0xFB1BCD ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-8 CVC' => 0xFA4B8B ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-9 CVC' => 0xF64990 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-10 CVC' => 0xF6409D ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-11 CVC' => 0xF839A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-12 CVC' => 0xF62EB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-13 CVC' => 0xFA20C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 235-14 CVC' => 0xFE12D9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-1 CVC' => 0xFF437E ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-2 CVC' => 0xFB4182 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-3 CVC' => 0xFA3F8F ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-4 CVC' => 0xF9389A ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-5 CVC' => 0xFB31A8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-6 CVC' => 0xFA29B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-7 CVC' => 0xFB1AC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-8 CVC' => 0xF83F77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-9 CVC' => 0xF63D7A ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-10 CVC' => 0xF6388A ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-11 CVC' => 0xF73193 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-12 CVC' => 0xF729A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-13 CVC' => 0xFA1DB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 240-14 CVC' => 0xFE11CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-1 CVC' => 0xFD3563 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-2 CVC' => 0xFA3870 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-3 CVC' => 0xF93377 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-4 CVC' => 0xF9318B ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-5 CVC' => 0xFB2A93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-6 CVC' => 0xFA24A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-7 CVC' => 0xFB18B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-8 CVC' => 0xF9284B ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-9 CVC' => 0xF72A56 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-10 CVC' => 0xF72966 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-11 CVC' => 0xF82676 ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-12 CVC' => 0xF7218D ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-13 CVC' => 0xFA19AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 245-14 CVC' => 0xFE0EC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-1 CVC' => 0xF6507F ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-2 CVC' => 0xF64F81 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-3 CVC' => 0xF24890 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-4 CVC' => 0xF2429A ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-5 CVC' => 0xF336AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-6 CVC' => 0xF723C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-7 CVC' => 0xFC10DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-8 CVC' => 0xF44E7E ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-9 CVC' => 0xF34D86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-10 CVC' => 0xF24398 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-11 CVC' => 0xF23AA4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-12 CVC' => 0xF42EB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-13 CVC' => 0xF91AD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 250-14 CVC' => 0xFE0CE3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-1 CVC' => 0xF54874 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-2 CVC' => 0xF44875 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-3 CVC' => 0xF24389 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-4 CVC' => 0xF13E92 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-5 CVC' => 0xF334A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-6 CVC' => 0xF721BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-7 CVC' => 0xFC0FD7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-8 CVC' => 0xF3436B ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-9 CVC' => 0xF34274 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-10 CVC' => 0xF23B86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-11 CVC' => 0xF33292 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-12 CVC' => 0xF429A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-13 CVC' => 0xFA15C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 255-14 CVC' => 0xFE09D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-1 CVC' => 0xF5395A ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-2 CVC' => 0xF43E65 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-3 CVC' => 0xF23871 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-4 CVC' => 0xF23880 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-5 CVC' => 0xF32E8F ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-6 CVC' => 0xF71EAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-7 CVC' => 0xFC0ECA ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-8 CVC' => 0xF62A41 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-9 CVC' => 0xF52D4D ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-10 CVC' => 0xF42A60 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-11 CVC' => 0xF42873 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-12 CVC' => 0xF5238C ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-13 CVC' => 0xF915B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 260-14 CVC' => 0xFD09C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-1 CVC' => 0xF04B79 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-2 CVC' => 0xF04A80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-3 CVC' => 0xEE4191 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-4 CVC' => 0xEF389E ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-5 CVC' => 0xF22EAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-6 CVC' => 0xF61DC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-7 CVC' => 0xFA0FDA ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-8 CVC' => 0xEC4772 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-9 CVC' => 0xEC467A ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-10 CVC' => 0xEC4188 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-11 CVC' => 0xED3A96 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-12 CVC' => 0xEE2FA3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-13 CVC' => 0xF226B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 265-14 CVC' => 0xF818CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-1 CVC' => 0xF0456E ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-2 CVC' => 0xF04376 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-3 CVC' => 0xEE3D89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-4 CVC' => 0xEF3594 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-5 CVC' => 0xF22DAA ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-6 CVC' => 0xF61CC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-7 CVC' => 0xFA0ED2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-8 CVC' => 0xEC3D60 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-9 CVC' => 0xEC3C67 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-10 CVC' => 0xEC3A75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-11 CVC' => 0xEE3284 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-12 CVC' => 0xEF2996 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-13 CVC' => 0xF321A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 270-14 CVC' => 0xF816C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-1 CVC' => 0xF13655 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-2 CVC' => 0xF03A64 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-3 CVC' => 0xF03271 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-4 CVC' => 0xF02E86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-5 CVC' => 0xF32596 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-6 CVC' => 0xF718AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-7 CVC' => 0xFB0CC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-8 CVC' => 0xF2273B ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-9 CVC' => 0xF12A45 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-10 CVC' => 0xF02A55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-11 CVC' => 0xF02869 ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-12 CVC' => 0xF0237F ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-13 CVC' => 0xF31F9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 275-14 CVC' => 0xF914B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-1 CVC' => 0xE54073 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-2 CVC' => 0xE63F7C ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-3 CVC' => 0xE7398A ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-4 CVC' => 0xEB2F9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-5 CVC' => 0xEE28AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-6 CVC' => 0xF21EBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-7 CVC' => 0xF713CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-8 CVC' => 0xDD3966 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-9 CVC' => 0xDE3476 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-10 CVC' => 0xE2298B ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-11 CVC' => 0xE52694 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-12 CVC' => 0xE822A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-13 CVC' => 0xEB1FAB ,
'PANTONE Hexachrome - Coated -- PANTONE H 280-14 CVC' => 0xF113C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-1 CVC' => 0xE63B6A ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-2 CVC' => 0xE83A74 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-3 CVC' => 0xE83684 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-4 CVC' => 0xEB2D94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-5 CVC' => 0xED27A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-6 CVC' => 0xF11EB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-7 CVC' => 0xF613C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-8 CVC' => 0xE0315A ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-9 CVC' => 0xE22E68 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-10 CVC' => 0xE5257E ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-11 CVC' => 0xE72286 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-12 CVC' => 0xEA2094 ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-13 CVC' => 0xED1C9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 285-14 CVC' => 0xF112B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-1 CVC' => 0xE92E55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-2 CVC' => 0xE93265 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-3 CVC' => 0xEA2D6F ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-4 CVC' => 0xEC2986 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-5 CVC' => 0xEF2292 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-6 CVC' => 0xF21AA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-7 CVC' => 0xF611BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-8 CVC' => 0xEA1F39 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-9 CVC' => 0xE92149 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-10 CVC' => 0xEA1B5C ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-11 CVC' => 0xEB1B6C ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-12 CVC' => 0xEC1B7F ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-13 CVC' => 0xEE1993 ,
'PANTONE Hexachrome - Coated -- PANTONE H 290-14 CVC' => 0xF210AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-1 CVC' => 0xD33058 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-2 CVC' => 0xD72E69 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-3 CVC' => 0xDC257F ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-4 CVC' => 0xDF2189 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-5 CVC' => 0xE21E94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-6 CVC' => 0xE8219F ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-7 CVC' => 0xEB1BAC ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-8 CVC' => 0xCA2649 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-9 CVC' => 0xD02360 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-10 CVC' => 0xD31D6E ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-11 CVC' => 0xD81B7C ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-12 CVC' => 0xDC1A89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-13 CVC' => 0xE3189B ,
'PANTONE Hexachrome - Coated -- PANTONE H 295-14 CVC' => 0xEA14AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-1 CVC' => 0xD72D51 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-2 CVC' => 0xDA2A61 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-3 CVC' => 0xDD2379 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-4 CVC' => 0xE02083 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-5 CVC' => 0xE31E90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-6 CVC' => 0xE8219B ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-7 CVC' => 0xEC1AA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-8 CVC' => 0xD12140 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-9 CVC' => 0xD61E55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-10 CVC' => 0xD81A65 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-11 CVC' => 0xDC1870 ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-12 CVC' => 0xE0177F ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-13 CVC' => 0xE6158E ,
'PANTONE Hexachrome - Coated -- PANTONE H 300-14 CVC' => 0xEC12A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-1 CVC' => 0xDE2441 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-2 CVC' => 0xDE2556 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-3 CVC' => 0xE21D67 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-4 CVC' => 0xE31D77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-5 CVC' => 0xE61982 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-6 CVC' => 0xEA1D8E ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-7 CVC' => 0xED189E ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-8 CVC' => 0xE1152A ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-9 CVC' => 0xE1153C ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-10 CVC' => 0xE1134B ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-11 CVC' => 0xE2135B ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-12 CVC' => 0xE31370 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-13 CVC' => 0xE71486 ,
'PANTONE Hexachrome - Coated -- PANTONE H 305-14 CVC' => 0xEC129B ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-1 CVC' => 0xC52438 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-2 CVC' => 0xCA2050 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-3 CVC' => 0xD51975 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-4 CVC' => 0xE01295 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-5 CVC' => 0xEB0CB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-6 CVC' => 0xF208C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-7 CVC' => 0xF905DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-8 CVC' => 0xC6243D ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-9 CVC' => 0xD11B67 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-10 CVC' => 0xDA1684 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-11 CVC' => 0xE70FAB ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-12 CVC' => 0xEE0BBF ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-13 CVC' => 0xF507D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 310-14 CVC' => 0xFB04E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-1 CVC' => 0xC92035 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-2 CVC' => 0xCF1D4C ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-3 CVC' => 0xD7196F ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-4 CVC' => 0xE1128D ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-5 CVC' => 0xEB0CB0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-6 CVC' => 0xF208C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-7 CVC' => 0xF905D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-8 CVC' => 0xCD1F38 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-9 CVC' => 0xD6195A ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-10 CVC' => 0xDE1476 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-11 CVC' => 0xE90D98 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-12 CVC' => 0xEF0AAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-13 CVC' => 0xF606C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 315-14 CVC' => 0xFB04D7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-1 CVC' => 0xD51C2E ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-2 CVC' => 0xD41A41 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-3 CVC' => 0xDC155E ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-4 CVC' => 0xE31080 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-5 CVC' => 0xEC0B9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-6 CVC' => 0xF208B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-7 CVC' => 0xF904C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-8 CVC' => 0xE11325 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-9 CVC' => 0xE2113F ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-10 CVC' => 0xE60F58 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-11 CVC' => 0xED0A7A ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-12 CVC' => 0xF10897 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-13 CVC' => 0xF505B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 320-14 CVC' => 0xFB03C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-1 CVC' => 0xC41A43 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-2 CVC' => 0xCB1959 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-3 CVC' => 0xD1166B ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-4 CVC' => 0xD51479 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-5 CVC' => 0xDA1088 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-6 CVC' => 0xE00B9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-7 CVC' => 0xE807B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-8 CVC' => 0xC60A55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-9 CVC' => 0xCA0764 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-10 CVC' => 0xD3087B ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-11 CVC' => 0xD70787 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-12 CVC' => 0xDB0692 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-13 CVC' => 0xE000A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 325-14 CVC' => 0xE600B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-1 CVC' => 0xC91740 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-2 CVC' => 0xCF1654 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-3 CVC' => 0xD31567 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-4 CVC' => 0xD71373 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-5 CVC' => 0xDB1084 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-6 CVC' => 0xE10C97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-7 CVC' => 0xE908AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-8 CVC' => 0xCD094A ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-9 CVC' => 0xD10658 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-10 CVC' => 0xD8076F ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-11 CVC' => 0xDC067A ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-12 CVC' => 0xDF0687 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-13 CVC' => 0xE2FF93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 330-14 CVC' => 0xE701A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-1 CVC' => 0xD31234 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-2 CVC' => 0xD41349 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-3 CVC' => 0xD91157 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-4 CVC' => 0xDA1168 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-5 CVC' => 0xDF0E75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-6 CVC' => 0xE40A8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-7 CVC' => 0xEA07A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-8 CVC' => 0xE00530 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-9 CVC' => 0xDE033D ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-10 CVC' => 0xE10552 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-11 CVC' => 0xE20562 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-12 CVC' => 0xE30477 ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-13 CVC' => 0xE4FF8B ,
'PANTONE Hexachrome - Coated -- PANTONE H 335-14 CVC' => 0xE9009E ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-1 CVC' => 0xC7005E ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-2 CVC' => 0xCBFD6B ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-3 CVC' => 0xD3FF80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-4 CVC' => 0xD8FD8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-5 CVC' => 0xDDFD9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-6 CVC' => 0xE3FDA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-7 CVC' => 0xED00C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-8 CVC' => 0xC9F26C ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-9 CVC' => 0xCBEF73 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-10 CVC' => 0xD0EE80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-11 CVC' => 0xD8EF97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-12 CVC' => 0xDFF3A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-13 CVC' => 0xE8F7BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 340-14 CVC' => 0xF1FBD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-1 CVC' => 0xCBFE58 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-2 CVC' => 0xCFFD63 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-3 CVC' => 0xD5FF78 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-4 CVC' => 0xD9FE85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-5 CVC' => 0xDEFD96 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-6 CVC' => 0xE4FEA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-7 CVC' => 0xED01BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-8 CVC' => 0xD0F260 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-9 CVC' => 0xD2EF66 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-10 CVC' => 0xD5EF75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-11 CVC' => 0xDDF186 ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-12 CVC' => 0xE3F59B ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-13 CVC' => 0xEAF9AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 345-14 CVC' => 0xF2FBC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-1 CVC' => 0xD5FF47 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-2 CVC' => 0xD4FD57 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-3 CVC' => 0xDB0066 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-4 CVC' => 0xDDFE7A ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-5 CVC' => 0xE2FE85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-6 CVC' => 0xE6FE98 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-7 CVC' => 0xEE01B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-8 CVC' => 0xE0F63E ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-9 CVC' => 0xDEF249 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-10 CVC' => 0xDFF256 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-11 CVC' => 0xE3F36C ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-12 CVC' => 0xE6F584 ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-13 CVC' => 0xEBF99F ,
'PANTONE Hexachrome - Coated -- PANTONE H 350-14 CVC' => 0xF3FDB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-1 CVC' => 0xCAEA75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-2 CVC' => 0xCEE880 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-3 CVC' => 0xD3E98C ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-4 CVC' => 0xDAEC9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-5 CVC' => 0xE1F2AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-6 CVC' => 0xE8F4BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-7 CVC' => 0xF1F7D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-8 CVC' => 0xCCE37C ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-9 CVC' => 0xD0E187 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-10 CVC' => 0xD7E697 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-11 CVC' => 0xDDEBA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-12 CVC' => 0xE6EEBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-13 CVC' => 0xEFF5CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 355-14 CVC' => 0xF7FCDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-1 CVC' => 0xCFEC6A ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-2 CVC' => 0xD3EA77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-3 CVC' => 0xD6EB85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-4 CVC' => 0xDCEE95 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-5 CVC' => 0xE2F3A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-6 CVC' => 0xE8F4B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-7 CVC' => 0xF2F7CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-8 CVC' => 0xD3E66B ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-9 CVC' => 0xD6E474 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-10 CVC' => 0xDCE987 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-11 CVC' => 0xE1ED94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-12 CVC' => 0xE8EFA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-13 CVC' => 0xF1F6BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 360-14 CVC' => 0xF7FCD1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-1 CVC' => 0xD8EE55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-2 CVC' => 0xD8EC66 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-3 CVC' => 0xDCEC71 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-4 CVC' => 0xE0EF88 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-5 CVC' => 0xE6F595 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-6 CVC' => 0xEBF6A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-7 CVC' => 0xF3F9C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-8 CVC' => 0xE3ED44 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-9 CVC' => 0xE2EA52 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-10 CVC' => 0xE5ED65 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-11 CVC' => 0xE7F079 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-12 CVC' => 0xECF295 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-13 CVC' => 0xF2F8B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 365-14 CVC' => 0xF8FCC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-1 CVC' => 0xCCDC7F ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-2 CVC' => 0xD0DB8C ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-3 CVC' => 0xDAE1A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-4 CVC' => 0xDFE5AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-5 CVC' => 0xE7EBBE ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-6 CVC' => 0xF1F3D4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-7 CVC' => 0xFAFBE5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-8 CVC' => 0xCDDA80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-9 CVC' => 0xD4DD95 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-10 CVC' => 0xDDE4AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-11 CVC' => 0xE4E8B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-12 CVC' => 0xECEFC9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-13 CVC' => 0xF6F7DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 370-14 CVC' => 0xFCFDE9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-1 CVC' => 0xCFDD77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-2 CVC' => 0xD4DD83 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-3 CVC' => 0xDCE39E ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-4 CVC' => 0xE1E7A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-5 CVC' => 0xE8ECBA ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-6 CVC' => 0xF2F4D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-7 CVC' => 0xFBFBE1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-8 CVC' => 0xD3DD72 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-9 CVC' => 0xDAE085 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-10 CVC' => 0xE2E79D ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-11 CVC' => 0xE8EBA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-12 CVC' => 0xEEF1BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-13 CVC' => 0xF7F9CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 375-14 CVC' => 0xFDFDE2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-1 CVC' => 0xD8E261 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-2 CVC' => 0xD9E073 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-3 CVC' => 0xE1E686 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-4 CVC' => 0xE4E899 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-5 CVC' => 0xEAEEA7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-6 CVC' => 0xF3F5BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-7 CVC' => 0xFBFCD6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-8 CVC' => 0xE1E74C ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-9 CVC' => 0xE3E75D ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-10 CVC' => 0xE8EB74 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-11 CVC' => 0xEBEE88 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-12 CVC' => 0xEFF2A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-13 CVC' => 0xF7F8C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 380-14 CVC' => 0xFDFDD3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-1 CVC' => 0xD0D87E ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-2 CVC' => 0xD6DA94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-3 CVC' => 0xE0E1A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-4 CVC' => 0xE6E5B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-5 CVC' => 0xECEDC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-6 CVC' => 0xF5F4D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-7 CVC' => 0xFBF9E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-8 CVC' => 0xD3D57C ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-9 CVC' => 0xD9D790 ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-10 CVC' => 0xDEDC9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-11 CVC' => 0xE5E2AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-12 CVC' => 0xECE7BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-13 CVC' => 0xF0EDCA ,
'PANTONE Hexachrome - Coated -- PANTONE H 385-14 CVC' => 0xF6F5DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-1 CVC' => 0xD3DA75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-2 CVC' => 0xD9DC88 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-3 CVC' => 0xE1E1A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-4 CVC' => 0xE7E6AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-5 CVC' => 0xEDEEC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-6 CVC' => 0xF5F4D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-7 CVC' => 0xFBF9DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-8 CVC' => 0xD8D96F ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-9 CVC' => 0xDEDB7F ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-10 CVC' => 0xE2DF90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-11 CVC' => 0xE8E49E ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-12 CVC' => 0xEEEAB0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-13 CVC' => 0xF1EEB9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 390-14 CVC' => 0xF7F6D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-1 CVC' => 0xDAE060 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-2 CVC' => 0xDDDF78 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-3 CVC' => 0xE5E587 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-4 CVC' => 0xE9E89D ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-5 CVC' => 0xEFEFAC ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-6 CVC' => 0xF5F5C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-7 CVC' => 0xFBFAD2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-8 CVC' => 0xE4E549 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-9 CVC' => 0xE6E35A ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-10 CVC' => 0xE8E56B ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-11 CVC' => 0xEBE981 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-12 CVC' => 0xF0EC98 ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-13 CVC' => 0xF2EFAE ,
'PANTONE Hexachrome - Coated -- PANTONE H 395-14 CVC' => 0xF7F6C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-1 CVC' => 0xD9D082 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-2 CVC' => 0xDBD388 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-3 CVC' => 0xDED795 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-4 CVC' => 0xE5DFA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-5 CVC' => 0xEBE5B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-6 CVC' => 0xF3EDCB ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-7 CVC' => 0xF9F4DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-8 CVC' => 0xE1CB80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-9 CVC' => 0xE5CE8E ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-10 CVC' => 0xEBD69F ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-11 CVC' => 0xECDBA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-12 CVC' => 0xEFE0B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-13 CVC' => 0xF2E6C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 400-14 CVC' => 0xF8EED1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-1 CVC' => 0xDCD379 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-2 CVC' => 0xDED580 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-3 CVC' => 0xE0DA91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-4 CVC' => 0xE7E1A3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-5 CVC' => 0xECE7B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-6 CVC' => 0xF3EEC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-7 CVC' => 0xF9F5D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-8 CVC' => 0xE4D072 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-9 CVC' => 0xE9D47F ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-10 CVC' => 0xEDDA93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-11 CVC' => 0xEFDF9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-12 CVC' => 0xF1E3AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-13 CVC' => 0xF4E9B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 405-14 CVC' => 0xF9EFCA ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-1 CVC' => 0xE2DB62 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-2 CVC' => 0xE1DA6F ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-3 CVC' => 0xE4DE79 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-4 CVC' => 0xE8E394 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-5 CVC' => 0xEEE9A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-6 CVC' => 0xF3EEB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-7 CVC' => 0xF8F5C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-8 CVC' => 0xECE049 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-9 CVC' => 0xEEDF59 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-10 CVC' => 0xF0E26D ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-11 CVC' => 0xF0E37D ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-12 CVC' => 0xF2E691 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-13 CVC' => 0xF4E9A8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 410-14 CVC' => 0xF8EFBB ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-1 CVC' => 0xEAC47B ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-2 CVC' => 0xEDC789 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-3 CVC' => 0xF0D09B ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-4 CVC' => 0xF1D5A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-5 CVC' => 0xF3DBAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-6 CVC' => 0xF2E2B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-7 CVC' => 0xF5E7C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-8 CVC' => 0xF6BC76 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-9 CVC' => 0xF9C18A ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-10 CVC' => 0xF8C793 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-11 CVC' => 0xF8CD9E ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-12 CVC' => 0xF7D4AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-13 CVC' => 0xF8DDB9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 415-14 CVC' => 0xF8E7C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-1 CVC' => 0xEBC873 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-2 CVC' => 0xEECB7F ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-3 CVC' => 0xF0D294 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-4 CVC' => 0xF1D69C ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-5 CVC' => 0xF3DCAC ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-6 CVC' => 0xF2E3B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-7 CVC' => 0xF5E8BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-8 CVC' => 0xF7C467 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-9 CVC' => 0xF9C878 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-10 CVC' => 0xF8CC86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-11 CVC' => 0xF8D28F ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-12 CVC' => 0xF8D79D ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-13 CVC' => 0xF8E0AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 420-14 CVC' => 0xF9E8BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-1 CVC' => 0xEED25D ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-2 CVC' => 0xEED16F ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-3 CVC' => 0xF1D97D ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-4 CVC' => 0xF2DA90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-5 CVC' => 0xF4DF99 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-6 CVC' => 0xF2E5A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-7 CVC' => 0xF5E9B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-8 CVC' => 0xF8D943 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-9 CVC' => 0xF9D754 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-10 CVC' => 0xF9D763 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-11 CVC' => 0xF8D973 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-12 CVC' => 0xF8DC89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-13 CVC' => 0xF8E1A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 425-14 CVC' => 0xF8EAB2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-1 CVC' => 0x03B66A ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-2 CVC' => 0xFFBC85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-3 CVC' => 0xFDCA9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-4 CVC' => 0xFCD9B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-5 CVC' => 0xFDE6CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-6 CVC' => 0xFDEED7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-7 CVC' => 0xFFF7E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-8 CVC' => 0x02B775 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-9 CVC' => 0xFBC695 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-10 CVC' => 0xFCD3AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-11 CVC' => 0xFDE3C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-12 CVC' => 0xFDEBD2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-13 CVC' => 0xFEF3DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 430-14 CVC' => 0x00FAE8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-1 CVC' => 0x02BA65 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-2 CVC' => 0xFEC17D ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-3 CVC' => 0xFDCE9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-4 CVC' => 0xFCDBAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-5 CVC' => 0xFCE8C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-6 CVC' => 0xFEEFD3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-7 CVC' => 0xFFF7DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-8 CVC' => 0x02BE6A ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-9 CVC' => 0xFCCC86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-10 CVC' => 0xFDD79E ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-11 CVC' => 0xFDE6B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-12 CVC' => 0xFDEDC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-13 CVC' => 0xFFF4D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 435-14 CVC' => 0x00FAE0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-1 CVC' => 0x00C654 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-2 CVC' => 0xFEC76E ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-3 CVC' => 0xFDD486 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-4 CVC' => 0xFCDEA1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-5 CVC' => 0xFDEAB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-6 CVC' => 0xFEF1C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-7 CVC' => 0xFFF8D5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-8 CVC' => 0xFFD446 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-9 CVC' => 0xFCD961 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-10 CVC' => 0xFCE078 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-11 CVC' => 0xFDEA94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-12 CVC' => 0xFDF0AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-13 CVC' => 0xFEF5C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 440-14 CVC' => 0xFFFBD3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-1 CVC' => 0x0CB57B ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-2 CVC' => 0x05BD8C ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-3 CVC' => 0x02C59A ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-4 CVC' => 0x01CBA3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-5 CVC' => 0x00D1AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-6 CVC' => 0x00D9B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-7 CVC' => 0x00E3C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-8 CVC' => 0x12B484 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-9 CVC' => 0x0EBB92 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-10 CVC' => 0x08C8A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-11 CVC' => 0x06CEAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-12 CVC' => 0x04D4B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-13 CVC' => 0x06D9BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 445-14 CVC' => 0x04E0C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-1 CVC' => 0x0AB973 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-2 CVC' => 0x03C285 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-3 CVC' => 0x01C894 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-4 CVC' => 0x00CD9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-5 CVC' => 0x00D3A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-6 CVC' => 0xFFDAB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-7 CVC' => 0x00E3C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-8 CVC' => 0x10BC77 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-9 CVC' => 0x0CC282 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-10 CVC' => 0x07CD97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-11 CVC' => 0x04D39E ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-12 CVC' => 0x03D7A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-13 CVC' => 0x05DBB0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 450-14 CVC' => 0x03E1BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-1 CVC' => 0x08C55F ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-2 CVC' => 0x03C877 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-3 CVC' => 0x01CF80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-4 CVC' => 0x00D190 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-5 CVC' => 0xFFD798 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-6 CVC' => 0xFFDDA8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-7 CVC' => 0xFFE6BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-8 CVC' => 0x09D24F ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-9 CVC' => 0x08D15E ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-10 CVC' => 0x04D872 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-11 CVC' => 0x03D982 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-12 CVC' => 0x03DC94 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-13 CVC' => 0x04DDA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 455-14 CVC' => 0x03E3B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-1 CVC' => 0x1AB389 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-2 CVC' => 0x15BA97 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-3 CVC' => 0x0CC8AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-4 CVC' => 0x0ACEB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-5 CVC' => 0x08D5BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-6 CVC' => 0x07DCC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-7 CVC' => 0x03E8D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-8 CVC' => 0x1DB592 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-9 CVC' => 0x1CB797 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-10 CVC' => 0x16C0A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-11 CVC' => 0x10CDB8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-12 CVC' => 0x0BD7C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-13 CVC' => 0x08E2CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 460-14 CVC' => 0x04EEDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-1 CVC' => 0x18B881 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-2 CVC' => 0x13BF8F ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-3 CVC' => 0x0BCBA5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-4 CVC' => 0x09D1AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-5 CVC' => 0x07D7B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-6 CVC' => 0x06DEC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-7 CVC' => 0x02E8CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-8 CVC' => 0x1ABB82 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-9 CVC' => 0x18BE89 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-10 CVC' => 0x13C79C ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-11 CVC' => 0x0DD4AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-12 CVC' => 0x0ADCB8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-13 CVC' => 0x06E5C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 465-14 CVC' => 0x04EFD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-1 CVC' => 0x12C46A ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-2 CVC' => 0x10C57E ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-3 CVC' => 0x08D390 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-4 CVC' => 0x08D49F ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-5 CVC' => 0x06DAA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-6 CVC' => 0x05E0B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-7 CVC' => 0x02EAC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-8 CVC' => 0x0FD256 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-9 CVC' => 0x11CE64 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-10 CVC' => 0x0ED379 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-11 CVC' => 0x0ADB8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-12 CVC' => 0x09E0A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-13 CVC' => 0x06E6B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 470-14 CVC' => 0x04EFC8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-1 CVC' => 0x1EB594 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-2 CVC' => 0x1ABBA2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-3 CVC' => 0x15C5AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-4 CVC' => 0x10D1BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-5 CVC' => 0x0BDAC7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-6 CVC' => 0x09E2D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-7 CVC' => 0x06EEDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-8 CVC' => 0x20B597 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-9 CVC' => 0x1CBCA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-10 CVC' => 0x14CBB8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-11 CVC' => 0x0FD4C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-12 CVC' => 0x0CDFCF ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-13 CVC' => 0x07EADB ,
'PANTONE Hexachrome - Coated -- PANTONE H 475-14 CVC' => 0x04F4E6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-1 CVC' => 0x1CBA8B ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-2 CVC' => 0x18C198 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-3 CVC' => 0x14C7A8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-4 CVC' => 0x0FD2B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-5 CVC' => 0x0BDAC2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-6 CVC' => 0x09E2CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-7 CVC' => 0x06EED9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-8 CVC' => 0x1CBD87 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-9 CVC' => 0x18C393 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-10 CVC' => 0x11D0A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-11 CVC' => 0x0DD9B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-12 CVC' => 0x0BE1C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-13 CVC' => 0x06ECCB ,
'PANTONE Hexachrome - Coated -- PANTONE H 480-14 CVC' => 0x03F5DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-1 CVC' => 0x16C572 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-2 CVC' => 0x15C686 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-3 CVC' => 0x11D093 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-4 CVC' => 0x0DD7A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-5 CVC' => 0x09E0B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-6 CVC' => 0x07E5BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-7 CVC' => 0x05F0CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-8 CVC' => 0x11D259 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-9 CVC' => 0x11D36B ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-10 CVC' => 0x0CDB80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-11 CVC' => 0x0AE093 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-12 CVC' => 0x09E6AA ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-13 CVC' => 0x05EEC1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 485-14 CVC' => 0x02F6CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-1 CVC' => 0x22B498 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-2 CVC' => 0x20B8A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-3 CVC' => 0x19C5B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-4 CVC' => 0x16CBBC ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-5 CVC' => 0x12D4C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-6 CVC' => 0x0BE5D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-7 CVC' => 0x05F4E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-8 CVC' => 0x23B499 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-9 CVC' => 0x1EBBA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-10 CVC' => 0x16CABA ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-11 CVC' => 0x13D1C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-12 CVC' => 0x0FDACD ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-13 CVC' => 0x08ECDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 490-14 CVC' => 0x04F8EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-1 CVC' => 0x1FBA8E ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-2 CVC' => 0x1DBD95 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-3 CVC' => 0x17C8AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-4 CVC' => 0x15CEB3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-5 CVC' => 0x11D5BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-6 CVC' => 0x0AE5D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-7 CVC' => 0x05F5DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-8 CVC' => 0x1EBD87 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-9 CVC' => 0x19C493 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-10 CVC' => 0x13D0A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-11 CVC' => 0x10D7AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-12 CVC' => 0x0CE0BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-13 CVC' => 0x06EFCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 495-14 CVC' => 0x03F9DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-1 CVC' => 0x19C775 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-2 CVC' => 0x19C484 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-3 CVC' => 0x13D192 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-4 CVC' => 0x12D3A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-5 CVC' => 0x0EDCAB ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-6 CVC' => 0x09E9BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-7 CVC' => 0x04F7D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-8 CVC' => 0x13D35E ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-9 CVC' => 0x12D46C ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-10 CVC' => 0x0EDB7E ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-11 CVC' => 0x0DDF8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-12 CVC' => 0x0BE4A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-13 CVC' => 0x06F1C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 500-14 CVC' => 0x03FAD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-1 CVC' => 0x25B498 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-2 CVC' => 0x20BAA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-3 CVC' => 0x1AC8B8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-4 CVC' => 0x17D0C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-5 CVC' => 0x11DACC ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-6 CVC' => 0x0BE8DA ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-7 CVC' => 0x08F3E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-8 CVC' => 0x25B599 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-9 CVC' => 0x22BBA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-10 CVC' => 0x1EC5B4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-11 CVC' => 0x19CDBE ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-12 CVC' => 0x17D6C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-13 CVC' => 0x11DFD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 505-14 CVC' => 0x0AEBDC ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-1 CVC' => 0x21BA8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-2 CVC' => 0x1DC09A ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-3 CVC' => 0x18CCAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-4 CVC' => 0x15D3B7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-5 CVC' => 0x10DCC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-6 CVC' => 0x0BE9D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-7 CVC' => 0x08F4DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-8 CVC' => 0x21BD85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-9 CVC' => 0x1EC390 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-10 CVC' => 0x1ACCA0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-11 CVC' => 0x16D4A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-12 CVC' => 0x14DAB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-13 CVC' => 0x0EE3BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 510-14 CVC' => 0x0AECD0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-1 CVC' => 0x1BC573 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-2 CVC' => 0x1AC787 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-3 CVC' => 0x14D494 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-4 CVC' => 0x13D8A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-5 CVC' => 0x0DE1AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-6 CVC' => 0x09ECC1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-7 CVC' => 0x06F5D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-8 CVC' => 0x16D05D ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-9 CVC' => 0x15D26B ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-10 CVC' => 0x13D77C ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-11 CVC' => 0x12DB8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-12 CVC' => 0x11DF9E ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-13 CVC' => 0x0EE5B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 515-14 CVC' => 0x08EFC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-1 CVC' => 0x28B69B ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-2 CVC' => 0x27B69C ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-3 CVC' => 0x22BFAB ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-4 CVC' => 0x1CCBBA ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-5 CVC' => 0x19D4C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-6 CVC' => 0x13E0D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-7 CVC' => 0x0DECDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-8 CVC' => 0x2CB79B ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-9 CVC' => 0x2ABAA1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-10 CVC' => 0x26C8B6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-11 CVC' => 0x22CEBD ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-12 CVC' => 0x1ED3C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-13 CVC' => 0x1ADACB ,
'PANTONE Hexachrome - Coated -- PANTONE H 520-14 CVC' => 0x14E7D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-1 CVC' => 0x23BC90 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-2 CVC' => 0x23BD91 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-3 CVC' => 0x21C2A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-4 CVC' => 0x1BCDB0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-5 CVC' => 0x18D4BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-6 CVC' => 0x13E0C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-7 CVC' => 0x0DECD6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-8 CVC' => 0x26C087 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-9 CVC' => 0x24C38C ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-10 CVC' => 0x21CEA2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-11 CVC' => 0x1ED4A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-12 CVC' => 0x1BD8B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-13 CVC' => 0x17DFB9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 525-14 CVC' => 0x12E9CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-1 CVC' => 0x1DC875 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-2 CVC' => 0x1FC480 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-3 CVC' => 0x1BCB8B ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-4 CVC' => 0x19D2A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-5 CVC' => 0x15DAA7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-6 CVC' => 0x10E3B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-7 CVC' => 0x0BEEC9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-8 CVC' => 0x19D35D ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-9 CVC' => 0x1AD267 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-10 CVC' => 0x19D97D ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-11 CVC' => 0x18DB8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-12 CVC' => 0x18DC99 ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-13 CVC' => 0x16E0AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 530-14 CVC' => 0x11EABD ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-1 CVC' => 0x31B799 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-2 CVC' => 0x2FBA9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-3 CVC' => 0x2CC7B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-4 CVC' => 0x29CCBA ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-5 CVC' => 0x25D2C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-6 CVC' => 0x1ED5C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-7 CVC' => 0x19DFCE ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-8 CVC' => 0x35B897 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-9 CVC' => 0x35BEA4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-10 CVC' => 0x34C6B1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-11 CVC' => 0x32CCB8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-12 CVC' => 0x2BD1C0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-13 CVC' => 0x23D9C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 535-14 CVC' => 0x1BE2D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-1 CVC' => 0x2CBD8C ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-2 CVC' => 0x2BBF93 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-3 CVC' => 0x28CAAB ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-4 CVC' => 0x26CFB1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-5 CVC' => 0x23D4BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-6 CVC' => 0x1CD7BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-7 CVC' => 0x17E0C9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-8 CVC' => 0x2DC184 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-9 CVC' => 0x2DC78F ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-10 CVC' => 0x2ECE9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-11 CVC' => 0x2AD3A5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-12 CVC' => 0x26D7B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-13 CVC' => 0x1FDDB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 540-14 CVC' => 0x18E5C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-1 CVC' => 0x23C874 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-2 CVC' => 0x25C682 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-3 CVC' => 0x22D291 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-4 CVC' => 0x22D5A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-5 CVC' => 0x1EDAA6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-6 CVC' => 0x1ADCAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-7 CVC' => 0x16E2BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-8 CVC' => 0x1FD35E ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-9 CVC' => 0x22D46B ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-10 CVC' => 0x23D97B ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-11 CVC' => 0x23DA87 ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-12 CVC' => 0x21DC9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-13 CVC' => 0x1EE0AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 545-14 CVC' => 0x17E6BB ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-1 CVC' => 0x38BB9A ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-2 CVC' => 0x38C0A6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-3 CVC' => 0x33CBB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-4 CVC' => 0x2AD7C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-5 CVC' => 0x1FE4D4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-6 CVC' => 0x17ECDE ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-7 CVC' => 0x0EF6E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-8 CVC' => 0x38BC9D ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-9 CVC' => 0x36C8B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-10 CVC' => 0x2FD2BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-11 CVC' => 0x23E0D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-12 CVC' => 0x1CE7D9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-13 CVC' => 0x13F1E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 550-14 CVC' => 0x0AF9EB ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-1 CVC' => 0x33C18F ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-2 CVC' => 0x33C69A ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-3 CVC' => 0x30CEAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-4 CVC' => 0x28DABC ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-5 CVC' => 0x1FE4CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-6 CVC' => 0x16EDD7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-7 CVC' => 0x0CF6E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-8 CVC' => 0x31C58A ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-9 CVC' => 0x2ED09B ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-10 CVC' => 0x29D8AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-11 CVC' => 0x1EE4B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-12 CVC' => 0x18EBC6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-13 CVC' => 0x0FF3CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 555-14 CVC' => 0x08FADE ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-1 CVC' => 0x29CB75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-2 CVC' => 0x2CCC87 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-3 CVC' => 0x28D694 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-4 CVC' => 0x23DDA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-5 CVC' => 0x19E8B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-6 CVC' => 0x13F0C4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-7 CVC' => 0x0BF7D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-8 CVC' => 0x1FD75E ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-9 CVC' => 0x21DC72 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-10 CVC' => 0x1EE182 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-11 CVC' => 0x17E996 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-12 CVC' => 0x14EDA9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-13 CVC' => 0x0EF3BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 560-14 CVC' => 0x07FACD ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-1 CVC' => 0x3CC2A7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-2 CVC' => 0x3AC8B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-3 CVC' => 0x38CBB6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-4 CVC' => 0x34D0BC ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-5 CVC' => 0x30D5C2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-6 CVC' => 0x2BDECD ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-7 CVC' => 0x23E7D7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-8 CVC' => 0x41CFB7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-9 CVC' => 0x41D3BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-10 CVC' => 0x3AD8C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-11 CVC' => 0x36DBC9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-12 CVC' => 0x31DDCC ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-13 CVC' => 0x2FE6D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 565-14 CVC' => 0x27EBDC ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-1 CVC' => 0x36C79A ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-2 CVC' => 0x34CDA2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-3 CVC' => 0x33CEAD ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-4 CVC' => 0x30D3B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-5 CVC' => 0x2DD7BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-6 CVC' => 0x29E0C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-7 CVC' => 0x22E8D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-8 CVC' => 0x38D69F ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-9 CVC' => 0x36DAA4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-10 CVC' => 0x32DDAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-11 CVC' => 0x2EE0B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-12 CVC' => 0x2BE2BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-13 CVC' => 0x29E9C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 570-14 CVC' => 0x24ECCF ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-1 CVC' => 0x2CD27F ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-2 CVC' => 0x2ED390 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-3 CVC' => 0x2BD793 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-4 CVC' => 0x2BD8A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-5 CVC' => 0x27DCA8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-6 CVC' => 0x24E3B5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-7 CVC' => 0x1FEAC3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-8 CVC' => 0x25E36D ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-9 CVC' => 0x27E478 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-10 CVC' => 0x25E685 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-11 CVC' => 0x26E691 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-12 CVC' => 0x25E6A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-13 CVC' => 0x26EAB5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 575-14 CVC' => 0x21EDBF ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-1 CVC' => 0x4DD9BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-2 CVC' => 0x4ADCC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-3 CVC' => 0x40E0CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-4 CVC' => 0x39E3D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-5 CVC' => 0x34E7D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-6 CVC' => 0x2DEBDB ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-7 CVC' => 0x20EFDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-8 CVC' => 0x53E6CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-9 CVC' => 0x52E9D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-10 CVC' => 0x4AECD8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-11 CVC' => 0x3EEEDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-12 CVC' => 0x34F0E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-13 CVC' => 0x29F3E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 580-14 CVC' => 0x1BF7E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-1 CVC' => 0x45DDAE ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-2 CVC' => 0x42E0B3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-3 CVC' => 0x3AE2C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-4 CVC' => 0x36E5C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-5 CVC' => 0x31E7CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-6 CVC' => 0x2AEBD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-7 CVC' => 0x1EEFD8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-8 CVC' => 0x45EAAF ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-9 CVC' => 0x43ECB2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-10 CVC' => 0x3FEEBE ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-11 CVC' => 0x33F1C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-12 CVC' => 0x2CF2CA ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-13 CVC' => 0x23F4CE ,
'PANTONE Hexachrome - Coated -- PANTONE H 585-14 CVC' => 0x18F8DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-1 CVC' => 0x35E489 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-2 CVC' => 0x38E59B ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-3 CVC' => 0x2EE8A2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-4 CVC' => 0x2EE9B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-5 CVC' => 0x29EBB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-6 CVC' => 0x25EEC0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-7 CVC' => 0x1BF1CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-8 CVC' => 0x2AF171 ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-9 CVC' => 0x2EF17E ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-10 CVC' => 0x2DF28C ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-11 CVC' => 0x28F39B ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-12 CVC' => 0x25F3AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-13 CVC' => 0x1FF5BF ,
'PANTONE Hexachrome - Coated -- PANTONE H 590-14 CVC' => 0x15F8CB ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-1 CVC' => 0x56EDD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-2 CVC' => 0x51EFDA ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-3 CVC' => 0x48F1DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-4 CVC' => 0x3CF2E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-5 CVC' => 0x30F2E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-6 CVC' => 0x28F6E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-7 CVC' => 0x19FAED ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-8 CVC' => 0x59F4DC ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-9 CVC' => 0x53F6E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-10 CVC' => 0x44F5E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-11 CVC' => 0x39F5E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-12 CVC' => 0x2DF9EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-13 CVC' => 0x1EFAEB ,
'PANTONE Hexachrome - Coated -- PANTONE H 595-14 CVC' => 0x10FBED ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-1 CVC' => 0x4CEEBF ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-2 CVC' => 0x48F0C3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-3 CVC' => 0x43F1D0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-4 CVC' => 0x38F3D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-5 CVC' => 0x2EF3DA ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-6 CVC' => 0x25F6DE ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-7 CVC' => 0x18FAE4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-8 CVC' => 0x4AF5BA ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-9 CVC' => 0x44F7BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-10 CVC' => 0x39F6C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-11 CVC' => 0x2FF6C8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-12 CVC' => 0x27F9D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-13 CVC' => 0x19FAD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 600-14 CVC' => 0x0EFCDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-1 CVC' => 0x3AF296 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-2 CVC' => 0x3CF2A8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-3 CVC' => 0x34F3AB ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-4 CVC' => 0x2FF4BD ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-5 CVC' => 0x26F4BE ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-6 CVC' => 0x22F6C5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-7 CVC' => 0x15FBD4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-8 CVC' => 0x2CF777 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-9 CVC' => 0x2EF883 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-10 CVC' => 0x29F891 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-11 CVC' => 0x25F79F ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-12 CVC' => 0x20F9B2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-13 CVC' => 0x18FAC5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 605-14 CVC' => 0x0EFCCF ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-1 CVC' => 0x2411A9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-2 CVC' => 0x2E15A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-3 CVC' => 0x3619A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-4 CVC' => 0x3B1C9F ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-5 CVC' => 0x401F9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-6 CVC' => 0x452398 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-7 CVC' => 0x472496 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-8 CVC' => 0x1E0D99 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-9 CVC' => 0x281195 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-10 CVC' => 0x2F1594 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-11 CVC' => 0x361991 ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-12 CVC' => 0x391B8F ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-13 CVC' => 0x3D1E8D ,
'PANTONE Hexachrome - Coated -- PANTONE H 610-14 CVC' => 0x40208A ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-1 CVC' => 0x1E0C8A ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-2 CVC' => 0x260F87 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-3 CVC' => 0x2C1288 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-4 CVC' => 0x311586 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-5 CVC' => 0x351885 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-6 CVC' => 0x391B82 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-7 CVC' => 0x3B1C80 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-8 CVC' => 0x1A0B7D ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-9 CVC' => 0x200E7B ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-10 CVC' => 0x27117B ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-11 CVC' => 0x2B137A ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-12 CVC' => 0x2F1778 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-13 CVC' => 0x331A75 ,
'PANTONE Hexachrome - Coated -- PANTONE H 615-14 CVC' => 0x331977 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-1 CVC' => 0x1F0F66 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-2 CVC' => 0x231068 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-3 CVC' => 0x271368 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-4 CVC' => 0x2A1568 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-5 CVC' => 0x2D166B ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-6 CVC' => 0x2E166C ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-7 CVC' => 0x30156D ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-8 CVC' => 0x150A58 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-9 CVC' => 0x190C59 ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-10 CVC' => 0x1E0F5A ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-11 CVC' => 0x21115A ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-12 CVC' => 0x24125C ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-13 CVC' => 0x25125D ,
'PANTONE Hexachrome - Coated -- PANTONE H 620-14 CVC' => 0x28125F ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-1 CVC' => 0x1613A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-2 CVC' => 0x1C1A9B ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-3 CVC' => 0x212094 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-4 CVC' => 0x25258F ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-5 CVC' => 0x282B85 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-6 CVC' => 0x2B307D ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-7 CVC' => 0x2C3379 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-8 CVC' => 0x141193 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-9 CVC' => 0x19168C ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-10 CVC' => 0x1E1D86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-11 CVC' => 0x212280 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-12 CVC' => 0x252779 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-13 CVC' => 0x272C73 ,
'PANTONE Hexachrome - Coated -- PANTONE H 625-14 CVC' => 0x282E6F ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-1 CVC' => 0x0F0F86 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-2 CVC' => 0x141482 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-3 CVC' => 0x171A7C ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-4 CVC' => 0x1B2076 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-5 CVC' => 0x1D2471 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-6 CVC' => 0x20286C ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-7 CVC' => 0x232B67 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-8 CVC' => 0x0E0F73 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-9 CVC' => 0x121470 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-10 CVC' => 0x17196D ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-11 CVC' => 0x191E68 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-12 CVC' => 0x1C2364 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-13 CVC' => 0x1E2661 ,
'PANTONE Hexachrome - Coated -- PANTONE H 630-14 CVC' => 0x1F285F ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-1 CVC' => 0x0C0C69 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-2 CVC' => 0x110F68 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-3 CVC' => 0x151365 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-4 CVC' => 0x171762 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-5 CVC' => 0x191C5E ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-6 CVC' => 0x1C205B ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-7 CVC' => 0x1D2259 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-8 CVC' => 0x0B0A50 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-9 CVC' => 0x0F0D53 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-10 CVC' => 0x121053 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-11 CVC' => 0x141453 ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-12 CVC' => 0x16184F ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-13 CVC' => 0x181B4C ,
'PANTONE Hexachrome - Coated -- PANTONE H 635-14 CVC' => 0x191D4B ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-1 CVC' => 0x0100EE ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-2 CVC' => 0x0100E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-3 CVC' => 0x0000D3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-4 CVC' => 0x0000C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-5 CVC' => 0x000098 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-6 CVC' => 0x000073 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-7 CVC' => 0x00003D ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-8 CVC' => 0x0100E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-9 CVC' => 0x0100D9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-10 CVC' => 0x0000CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-11 CVC' => 0x0000AD ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-12 CVC' => 0x000087 ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-13 CVC' => 0x00005C ,
'PANTONE Hexachrome - Coated -- PANTONE H 640-14 CVC' => 0x000032 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-1 CVC' => 0x0300E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-2 CVC' => 0x0A01DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-3 CVC' => 0x0900CF ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-4 CVC' => 0x0A02B9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-5 CVC' => 0x0A02A1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-6 CVC' => 0x0F0289 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-7 CVC' => 0x0F0168 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-8 CVC' => 0x0502E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-9 CVC' => 0x0903D9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-10 CVC' => 0x0B02CC ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-11 CVC' => 0x0D03B7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-12 CVC' => 0x0D04A0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-13 CVC' => 0x110687 ,
'PANTONE Hexachrome - Coated -- PANTONE H 645-14 CVC' => 0x0D0369 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-1 CVC' => 0x0302E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-2 CVC' => 0x0708D2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-3 CVC' => 0x0607C7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-4 CVC' => 0x0409B0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-5 CVC' => 0x030A96 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-6 CVC' => 0x080E7B ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-7 CVC' => 0x090D5C ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-8 CVC' => 0x0003E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-9 CVC' => 0xFB09CD ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-10 CVC' => 0xFB08C1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-11 CVC' => 0xFA05AC ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-12 CVC' => 0xF90693 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-13 CVC' => 0xF60C73 ,
'PANTONE Hexachrome - Coated -- PANTONE H 650-14 CVC' => 0xF60E55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-1 CVC' => 0x00FFE4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-2 CVC' => 0xFDF9D1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-3 CVC' => 0xFDFAC4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-4 CVC' => 0xFDF8AF ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-5 CVC' => 0xFEF796 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-6 CVC' => 0xFCF279 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-7 CVC' => 0xFBF35B ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-8 CVC' => 0x02FEE5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-9 CVC' => 0x05F7D4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-10 CVC' => 0x09F8C6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-11 CVC' => 0x05FAB4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-12 CVC' => 0x06F99B ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-13 CVC' => 0x09F481 ,
'PANTONE Hexachrome - Coated -- PANTONE H 655-14 CVC' => 0x07F361 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-1 CVC' => 0x0AFE57 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-2 CVC' => 0x0EFD57 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-3 CVC' => 0x14FC53 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-4 CVC' => 0x0F0448 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-5 CVC' => 0x110345 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-6 CVC' => 0x100342 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-7 CVC' => 0x14043C ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-8 CVC' => 0x0F0150 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-9 CVC' => 0x0C034E ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-10 CVC' => 0x0F0548 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-11 CVC' => 0x0F0643 ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-12 CVC' => 0x0F063E ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-13 CVC' => 0x0E063A ,
'PANTONE Hexachrome - Coated -- PANTONE H 660-14 CVC' => 0x100737 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-1 CVC' => 0x0B054D ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-2 CVC' => 0x100946 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-3 CVC' => 0x130C41 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-4 CVC' => 0x060F3A ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-5 CVC' => 0x0B0E36 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-6 CVC' => 0x0D0E32 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-7 CVC' => 0x070F30 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-8 CVC' => 0xFB1041 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-9 CVC' => 0xF91739 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-10 CVC' => 0xF91B2E ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-11 CVC' => 0xF50930 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-12 CVC' => 0xF50E29 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-13 CVC' => 0xF61121 ,
'PANTONE Hexachrome - Coated -- PANTONE H 665-14 CVC' => 0xF50826 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-1 CVC' => 0xFBFB36 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-2 CVC' => 0xF6F730 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-3 CVC' => 0xF0F22B ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-4 CVC' => 0xFDF336 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-5 CVC' => 0xF9EF33 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-6 CVC' => 0xF2EC2F ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-7 CVC' => 0xFCEB3B ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-8 CVC' => 0x02F838 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-9 CVC' => 0x04F237 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-10 CVC' => 0x07E833 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-11 CVC' => 0x09F640 ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-12 CVC' => 0x0AF03F ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-13 CVC' => 0x0CE53A ,
'PANTONE Hexachrome - Coated -- PANTONE H 670-14 CVC' => 0x0EF148 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-1 CVC' => 0x4602A4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-2 CVC' => 0x3C0193 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-3 CVC' => 0x340085 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-4 CVC' => 0x2FFF7B ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-5 CVC' => 0x29FF6C ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-6 CVC' => 0x23FF5F ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-7 CVC' => 0x1BFE4E ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-8 CVC' => 0x3C2686 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-9 CVC' => 0x342178 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-10 CVC' => 0x2E1E6C ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-11 CVC' => 0x291B62 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-12 CVC' => 0x241858 ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-13 CVC' => 0x1E144D ,
'PANTONE Hexachrome - Coated -- PANTONE H 675-14 CVC' => 0x171041 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-1 CVC' => 0x253861 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-2 CVC' => 0x213257 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-3 CVC' => 0x1D2D4F ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-4 CVC' => 0x1B2A48 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-5 CVC' => 0x192643 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-6 CVC' => 0x15213B ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-7 CVC' => 0x111A31 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-8 CVC' => 0xF93C65 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-9 CVC' => 0xFB365A ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-10 CVC' => 0xFB3252 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-11 CVC' => 0xFB2E4B ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-12 CVC' => 0xFC2B44 ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-13 CVC' => 0xFC253B ,
'PANTONE Hexachrome - Coated -- PANTONE H 680-14 CVC' => 0xFD1E30 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-1 CVC' => 0xCF1A30 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-2 CVC' => 0xD3192D ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-3 CVC' => 0xD71729 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-4 CVC' => 0xDA1626 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-5 CVC' => 0xDE1323 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-6 CVC' => 0xE21120 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-7 CVC' => 0xE80E1C ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-8 CVC' => 0xD8EA5F ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-9 CVC' => 0xDBF054 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-10 CVC' => 0xDEF14B ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-11 CVC' => 0xE1F246 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-12 CVC' => 0xE3F341 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-13 CVC' => 0xE7F439 ,
'PANTONE Hexachrome - Coated -- PANTONE H 685-14 CVC' => 0xECF72F ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-1 CVC' => 0x04C35F ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-2 CVC' => 0x02C859 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-3 CVC' => 0x01CE51 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-4 CVC' => 0x00D24B ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-5 CVC' => 0xFFD645 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-6 CVC' => 0xFEDA3F ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-7 CVC' => 0xFEE234 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-8 CVC' => 0x16C67A ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-9 CVC' => 0x12CC6E ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-10 CVC' => 0x10D165 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-11 CVC' => 0x0ED55D ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-12 CVC' => 0x0CDA55 ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-13 CVC' => 0x0ADE4A ,
'PANTONE Hexachrome - Coated -- PANTONE H 690-14 CVC' => 0x07E53F ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-1 CVC' => 0x30CF7C ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-2 CVC' => 0x2BD472 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-3 CVC' => 0x27D86A ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-4 CVC' => 0x23DB61 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-5 CVC' => 0x1FDF59 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-6 CVC' => 0x1CE350 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-7 CVC' => 0x15E943 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-8 CVC' => 0x40F39E ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-9 CVC' => 0x37F48C ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-10 CVC' => 0x30F57F ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-11 CVC' => 0x2AF674 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-12 CVC' => 0x25F768 ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-13 CVC' => 0x20F85D ,
'PANTONE Hexachrome - Coated -- PANTONE H 695-14 CVC' => 0x19F94C ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-1 CVC' => 0x0500F2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-2 CVC' => 0x08FFF2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-3 CVC' => 0x0EFEF1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-4 CVC' => 0x0602F0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-5 CVC' => 0x0901F0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-6 CVC' => 0x0C01EF ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-7 CVC' => 0x0F00EF ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-8 CVC' => 0x0400EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-9 CVC' => 0x08FFEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-10 CVC' => 0x0CFEEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-11 CVC' => 0x0602E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-12 CVC' => 0x0901E8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-13 CVC' => 0x0B01E8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 700-14 CVC' => 0x0D00E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-1 CVC' => 0x0C04EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-2 CVC' => 0x0F03EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-3 CVC' => 0x0E05EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-4 CVC' => 0x0C07E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-5 CVC' => 0x0F07E8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-6 CVC' => 0x1106E8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-7 CVC' => 0x1306E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-8 CVC' => 0x0804E6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-9 CVC' => 0x0E03E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-10 CVC' => 0x1004E3 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-11 CVC' => 0x0A06E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-12 CVC' => 0x0D05E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-13 CVC' => 0x1005E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 705-14 CVC' => 0x1105E1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-1 CVC' => 0x0604EE ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-2 CVC' => 0x0604ED ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-3 CVC' => 0x0A08E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-4 CVC' => 0x0305EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-5 CVC' => 0x0506EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-6 CVC' => 0x0708E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-7 CVC' => 0x0909E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-8 CVC' => 0x030AE5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-9 CVC' => 0x060CE1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-10 CVC' => 0x020DE0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-11 CVC' => 0xFF0EDF ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-12 CVC' => 0x010FDD ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-13 CVC' => 0x0310DC ,
'PANTONE Hexachrome - Coated -- PANTONE H 710-14 CVC' => 0x0511DB ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-1 CVC' => 0x0104EE ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-2 CVC' => 0xFF08E8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-3 CVC' => 0xFD0EE0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-4 CVC' => 0xFF02EB ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-5 CVC' => 0xFD06E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-6 CVC' => 0xFC0AE1 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-7 CVC' => 0xFB0DDE ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-8 CVC' => 0xFD00E7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-9 CVC' => 0xFA08DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-10 CVC' => 0xFA03DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-11 CVC' => 0xFAFEE2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-12 CVC' => 0xF802DD ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-13 CVC' => 0xF706D8 ,
'PANTONE Hexachrome - Coated -- PANTONE H 715-14 CVC' => 0xF709D6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-1 CVC' => 0x00FFEF ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-2 CVC' => 0xFEFDEB ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-3 CVC' => 0xFBFAE6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-4 CVC' => 0x01FDED ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-5 CVC' => 0xFFFBE9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-6 CVC' => 0xFDFAE7 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-7 CVC' => 0xFCF9E5 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-8 CVC' => 0x02FAEA ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-9 CVC' => 0xFEF6E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-10 CVC' => 0x01F5E4 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-11 CVC' => 0x03F5E6 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-12 CVC' => 0x01F4E2 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-13 CVC' => 0x00F3E0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 720-14 CVC' => 0xFFF3DF ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-1 CVC' => 0x02FEF0 ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-2 CVC' => 0x03FBED ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-3 CVC' => 0x05F6E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-4 CVC' => 0x05FDEF ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-5 CVC' => 0x06FAED ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-6 CVC' => 0x07F8EA ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-7 CVC' => 0x07F7E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-8 CVC' => 0x09FDEF ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-9 CVC' => 0x0BF6E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-10 CVC' => 0x0DF9EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-11 CVC' => 0x0EFCEE ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-12 CVC' => 0x0FF9EC ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-13 CVC' => 0x0FF6E9 ,
'PANTONE Hexachrome - Coated -- PANTONE H 725-14 CVC' => 0x0FF5E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Yellow CVU' => 0x53FFEB ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Orange CVU' => 0x3E31B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Magenta CVU' => 0xFA448E ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Cyan CVU' => 0xD4E690 ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Green CVU' => 0x18C69D ,
'PANTONE Hexachrome - Uncoated -- PANTONE Hexachrome Black CVU' => 0x01024B ,
'PANTONE Hexachrome - Uncoated -- UNASSIGNED' => 0x0000FF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-1 CVU' => 0x5300E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-2 CVU' => 0x4EFEEC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-3 CVU' => 0x40FCEE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-4 CVU' => 0x3CFCEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-5 CVU' => 0x35FCEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-6 CVU' => 0x27FCF2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-7 CVU' => 0x14FEF3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-8 CVU' => 0x5303E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-9 CVU' => 0x4AFDED ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-10 CVU' => 0x3CFCEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-11 CVU' => 0x36FBF0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-12 CVU' => 0x2EFCF1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-13 CVU' => 0x1EFDF3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 10-14 CVU' => 0x0FFEF3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-1 CVU' => 0x43FECD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-2 CVU' => 0x3DFDCE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-3 CVU' => 0x37FCDB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-4 CVU' => 0x32FCDB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-5 CVU' => 0x31FCE4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-6 CVU' => 0x23FCE6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-7 CVU' => 0x13FEE8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-8 CVU' => 0x3AFFBB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-9 CVU' => 0x32FCBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-10 CVU' => 0x2BFCC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-11 CVU' => 0x26FCC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-12 CVU' => 0x22FCCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-13 CVU' => 0x15FDD2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 15-14 CVU' => 0x0DFEE2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-1 CVU' => 0x28FD9B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-2 CVU' => 0x2DFCAC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-3 CVU' => 0x23FCAB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-4 CVU' => 0x26FCB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-5 CVU' => 0x21FCBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-6 CVU' => 0x1AFDC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-7 CVU' => 0x0FFED3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-8 CVU' => 0x18FE7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-9 CVU' => 0x18FD84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-10 CVU' => 0x15FD8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-11 CVU' => 0x16FD97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-12 CVU' => 0x17FDAA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-13 CVU' => 0x12FEBE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 20-14 CVU' => 0x0AFFCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-1 CVU' => 0x5009E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-2 CVU' => 0x4A04E7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-3 CVU' => 0x3E03E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-4 CVU' => 0x3702E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-5 CVU' => 0x2FFFEE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-6 CVU' => 0x24FFEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-7 CVU' => 0x1601F0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-8 CVU' => 0x4F10DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-9 CVU' => 0x480BE0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-10 CVU' => 0x4008E3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-11 CVU' => 0x3A06E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-12 CVU' => 0x3405E7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-13 CVU' => 0x2D03EB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 25-14 CVU' => 0x1E00F0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-1 CVU' => 0x4105C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-2 CVU' => 0x3A01C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-3 CVU' => 0x3401D6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-4 CVU' => 0x2E01D5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-5 CVU' => 0x2BFFE2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-6 CVU' => 0x20FFE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-7 CVU' => 0x1400E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-8 CVU' => 0x3807B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-9 CVU' => 0x3104B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-10 CVU' => 0x2E04BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-11 CVU' => 0x2802BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-12 CVU' => 0x2603C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-13 CVU' => 0x2101C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 30-14 CVU' => 0x1AFFDB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-1 CVU' => 0x290198 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-2 CVU' => 0x2AFFA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-3 CVU' => 0x21FFA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-4 CVU' => 0x2200B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-5 CVU' => 0x1DFEBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-6 CVU' => 0x18FFC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-7 CVU' => 0x1000D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-8 CVU' => 0x1A007A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-9 CVU' => 0x190081 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-10 CVU' => 0x180088 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-11 CVU' => 0x180092 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-12 CVU' => 0x1A01A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-13 CVU' => 0x1B00B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 35-14 CVU' => 0x15FFC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-1 CVU' => 0x4A14D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-2 CVU' => 0x4C11D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-3 CVU' => 0x490DDD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-4 CVU' => 0x4209E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-5 CVU' => 0x3907E4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-6 CVU' => 0x2D05E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-7 CVU' => 0x1F03EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-8 CVU' => 0x491BCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-9 CVU' => 0x4919D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-10 CVU' => 0x4215D6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-11 CVU' => 0x3F12D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-12 CVU' => 0x3A0FDD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-13 CVU' => 0x320CE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 40-14 CVU' => 0x2709E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-1 CVU' => 0x3B0DBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-2 CVU' => 0x3D0BBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-3 CVU' => 0x400ACC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-4 CVU' => 0x3907D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-5 CVU' => 0x3405DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-6 CVU' => 0x2804DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-7 CVU' => 0x1C03E2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-8 CVU' => 0x3410A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-9 CVU' => 0x340EAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-10 CVU' => 0x320DB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-11 CVU' => 0x2F0BB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-12 CVU' => 0x2E0AC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-13 CVU' => 0x2708C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 45-14 CVU' => 0x2007D5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-1 CVU' => 0x250591 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-2 CVU' => 0x2D06A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-3 CVU' => 0x2C04A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-4 CVU' => 0x2D04B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-5 CVU' => 0x2602B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-6 CVU' => 0x2002C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-7 CVU' => 0x1701CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-8 CVU' => 0x170472 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-9 CVU' => 0x1C057C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-10 CVU' => 0x1D0588 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-11 CVU' => 0x1F0593 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-12 CVU' => 0x2105A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-13 CVU' => 0x2205B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 50-14 CVU' => 0x1B05C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-1 CVU' => 0x4825C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-2 CVU' => 0x4820CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-3 CVU' => 0x431CCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-4 CVU' => 0x4119D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-5 CVU' => 0x3C16D5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-6 CVU' => 0x3810DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-7 CVU' => 0x300CE0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-8 CVU' => 0x482CBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-9 CVU' => 0x4727C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-10 CVU' => 0x4424C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-11 CVU' => 0x4221CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-12 CVU' => 0x3D1CCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-13 CVU' => 0x3716D6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 55-14 CVU' => 0x2E0FDD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-1 CVU' => 0x391AAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-2 CVU' => 0x3A17B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-3 CVU' => 0x3B16C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-4 CVU' => 0x3914C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-5 CVU' => 0x3713CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-6 CVU' => 0x330DD3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-7 CVU' => 0x2C0AD6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-8 CVU' => 0x311C97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-9 CVU' => 0x31189D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-10 CVU' => 0x3318A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-11 CVU' => 0x3115AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-12 CVU' => 0x3013B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-13 CVU' => 0x2B0EBB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 60-14 CVU' => 0x280CCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-1 CVU' => 0x240D87 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-2 CVU' => 0x2C0F98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-3 CVU' => 0x280C9D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-4 CVU' => 0x2D0EAB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-5 CVU' => 0x290CAC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-6 CVU' => 0x2909B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-7 CVU' => 0x2508C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-8 CVU' => 0x180B6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-9 CVU' => 0x1C0B76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-10 CVU' => 0x1E0B80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-11 CVU' => 0x210C8A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-12 CVU' => 0x240C9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-13 CVU' => 0x250CAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 65-14 CVU' => 0x2109BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-1 CVU' => 0x4634B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-2 CVU' => 0x462FB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-3 CVU' => 0x4125C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-4 CVU' => 0x371BD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-5 CVU' => 0x2812DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-6 CVU' => 0x1F0CE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-7 CVU' => 0x1407EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-8 CVU' => 0x4633B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-9 CVU' => 0x4428C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-10 CVU' => 0x3D20CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-11 CVU' => 0x2F15D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-12 CVU' => 0x240FDF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-13 CVU' => 0x1A0AE6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 70-14 CVU' => 0x0F05EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-1 CVU' => 0x38289D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-2 CVU' => 0x3A24A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-3 CVU' => 0x3A1FB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-4 CVU' => 0x3017C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-5 CVU' => 0x250FD4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-6 CVU' => 0x1C0BDA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-7 CVU' => 0x1306E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-8 CVU' => 0x332394 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-9 CVU' => 0x311BA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-10 CVU' => 0x2F16AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-11 CVU' => 0x230EBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-12 CVU' => 0x1C0BC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-13 CVU' => 0x1507CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 75-14 CVU' => 0x0D04DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-1 CVU' => 0x25187B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-2 CVU' => 0x2B1A8C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-3 CVU' => 0x281396 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-4 CVU' => 0x2710AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-5 CVU' => 0x1B0AB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-6 CVU' => 0x1607C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-7 CVU' => 0x0F05D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-8 CVU' => 0x170E66 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-9 CVU' => 0x1A0C75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-10 CVU' => 0x1A0A82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-11 CVU' => 0x170894 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-12 CVU' => 0x1406A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-13 CVU' => 0x1105BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 80-14 CVU' => 0x0903CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-1 CVU' => 0x4634B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-2 CVU' => 0x442FB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-3 CVU' => 0x422AC0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-4 CVU' => 0x3F25C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-5 CVU' => 0x3920CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-6 CVU' => 0x321BD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-7 CVU' => 0x2A16D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-8 CVU' => 0x4434B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-9 CVU' => 0x4432B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-10 CVU' => 0x4029C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-11 CVU' => 0x3B25C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-12 CVU' => 0x3620CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-13 CVU' => 0x311DCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 85-14 CVU' => 0x2A19D5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-1 CVU' => 0x38299E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-2 CVU' => 0x3724A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-3 CVU' => 0x3A23B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-4 CVU' => 0x371EB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-5 CVU' => 0x351CC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-6 CVU' => 0x2E18C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-7 CVU' => 0x2613CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-8 CVU' => 0x312493 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-9 CVU' => 0x302295 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-10 CVU' => 0x301EA5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-11 CVU' => 0x2C19AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-12 CVU' => 0x2B17B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-13 CVU' => 0x2716B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 90-14 CVU' => 0x2414C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-1 CVU' => 0x23187C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-2 CVU' => 0x2A1A8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-3 CVU' => 0x281693 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-4 CVU' => 0x2C17A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-5 CVU' => 0x2713A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-6 CVU' => 0x2512B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-7 CVU' => 0x200FBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-8 CVU' => 0x170F68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-9 CVU' => 0x1A116F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-10 CVU' => 0x1C0F7D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-11 CVU' => 0x1D0F89 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-12 CVU' => 0x1F109A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-13 CVU' => 0x2213A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 95-14 CVU' => 0x1F11B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-1 CVU' => 0x4334B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-2 CVU' => 0x4230B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-3 CVU' => 0x3D28C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-4 CVU' => 0x3A24C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-5 CVU' => 0x3520CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-6 CVU' => 0x2F1CD0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-7 CVU' => 0x2413DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-8 CVU' => 0x4234B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-9 CVU' => 0x4232B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-10 CVU' => 0x3F2DBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-11 CVU' => 0x3826C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-12 CVU' => 0x3120CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-13 CVU' => 0x291AD4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 100-14 CVU' => 0x1D11DE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-1 CVU' => 0x3629A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-2 CVU' => 0x3626A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-3 CVU' => 0x3622B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-4 CVU' => 0x331FBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-5 CVU' => 0x311DC4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-6 CVU' => 0x2C1AC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-7 CVU' => 0x2211D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-8 CVU' => 0x302497 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-9 CVU' => 0x30239A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-10 CVU' => 0x3021A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-11 CVU' => 0x2A1BAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-12 CVU' => 0x2819B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-13 CVU' => 0x2113BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 105-14 CVU' => 0x190ED1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-1 CVU' => 0x231980 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-2 CVU' => 0x291C8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-3 CVU' => 0x261697 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-4 CVU' => 0x2917A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-5 CVU' => 0x2615AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-6 CVU' => 0x2413B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-7 CVU' => 0x1E0EC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-8 CVU' => 0x160F69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-9 CVU' => 0x1B1273 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-10 CVU' => 0x1C127D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-11 CVU' => 0x1D118B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-12 CVU' => 0x1E119D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-13 CVU' => 0x1D10B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 110-14 CVU' => 0x160BC0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-1 CVU' => 0x4334B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-2 CVU' => 0x4030B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-3 CVU' => 0x3C2BC0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-4 CVU' => 0x3625C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-5 CVU' => 0x2E1ECE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-6 CVU' => 0x2619D3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-7 CVU' => 0x1A11DE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-8 CVU' => 0x4234B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-9 CVU' => 0x3F30B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-10 CVU' => 0x3828C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-11 CVU' => 0x3323C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-12 CVU' => 0x281CD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-13 CVU' => 0x1E14DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 115-14 CVU' => 0x130BE6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-1 CVU' => 0x362AA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-2 CVU' => 0x3526A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-3 CVU' => 0x3525B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-4 CVU' => 0x2F1FBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-5 CVU' => 0x2B1CC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-6 CVU' => 0x2418CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-7 CVU' => 0x1910D6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-8 CVU' => 0x302595 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-9 CVU' => 0x2E219A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-10 CVU' => 0x2B1EA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-11 CVU' => 0x2719AE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-12 CVU' => 0x2115BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-13 CVU' => 0x180FC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 120-14 CVU' => 0x120AD6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-1 CVU' => 0x231A80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-2 CVU' => 0x281D90 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-3 CVU' => 0x251894 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-4 CVU' => 0x2618A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-5 CVU' => 0x2114AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-6 CVU' => 0x1D12B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-7 CVU' => 0x150DC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-8 CVU' => 0x17106A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-9 CVU' => 0x1A1175 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-10 CVU' => 0x1A1082 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-11 CVU' => 0x1B108E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-12 CVU' => 0x190FA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-13 CVU' => 0x140CB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 125-14 CVU' => 0x0E08C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-1 CVU' => 0x3F32B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-2 CVU' => 0x3F31B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-3 CVU' => 0x3728C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-4 CVU' => 0x3124C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-5 CVU' => 0x2A1FCE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-6 CVU' => 0x1E16D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-7 CVU' => 0x100BE6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-8 CVU' => 0x3F33B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-9 CVU' => 0x3C2EBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-10 CVU' => 0x3325C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-11 CVU' => 0x2D20CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-12 CVU' => 0x251AD3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-13 CVU' => 0x1710E0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 130-14 CVU' => 0x0C08EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-1 CVU' => 0x3529A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-2 CVU' => 0x3528A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-3 CVU' => 0x3123B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-4 CVU' => 0x2D20BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-5 CVU' => 0x271CC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-6 CVU' => 0x1C14D1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-7 CVU' => 0x0E0ADE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-8 CVU' => 0x2F259A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-9 CVU' => 0x2D21A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-10 CVU' => 0x281CAF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-11 CVU' => 0x2318B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-12 CVU' => 0x1E14BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-13 CVU' => 0x130DC9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 135-14 CVU' => 0x0A07DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-1 CVU' => 0x231A85 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-2 CVU' => 0x281E92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-3 CVU' => 0x231899 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-4 CVU' => 0x2519A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-5 CVU' => 0x1F14AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-6 CVU' => 0x1810BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-7 CVU' => 0x0D08CE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-8 CVU' => 0x150E6B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-9 CVU' => 0x181076 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-10 CVU' => 0x170E82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-11 CVU' => 0x180E8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-12 CVU' => 0x160EA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-13 CVU' => 0x110AB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 140-14 CVU' => 0x0906C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-1 CVU' => 0x3B33B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-2 CVU' => 0x392FB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-3 CVU' => 0x3028C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-4 CVU' => 0x2A24C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-5 CVU' => 0x241CD0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-6 CVU' => 0x1915D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-7 CVU' => 0x0F0EE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-8 CVU' => 0x3735AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-9 CVU' => 0x3632B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-10 CVU' => 0x312DB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-11 CVU' => 0x2B27C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-12 CVU' => 0x2423C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-13 CVU' => 0x1F1DCE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 145-14 CVU' => 0x1613DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-1 CVU' => 0x312AA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-2 CVU' => 0x2F26A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-3 CVU' => 0x2B23B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-4 CVU' => 0x251FB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-5 CVU' => 0x211AC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-6 CVU' => 0x1714D1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-7 CVU' => 0x0E0ED9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-8 CVU' => 0x292794 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-9 CVU' => 0x282498 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-10 CVU' => 0x2622A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-11 CVU' => 0x211DA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-12 CVU' => 0x1D1BB3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-13 CVU' => 0x1916BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 150-14 CVU' => 0x1310CE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-1 CVU' => 0x201B82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-2 CVU' => 0x251D91 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-3 CVU' => 0x1F1797 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-4 CVU' => 0x1E18A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-5 CVU' => 0x1912AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-6 CVU' => 0x120EBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-7 CVU' => 0x0C0BCA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-8 CVU' => 0x141169 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-9 CVU' => 0x151272 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-10 CVU' => 0x16127D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-11 CVU' => 0x161289 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-12 CVU' => 0x16129A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-13 CVU' => 0x1512AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 155-14 CVU' => 0x100DBE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-1 CVU' => 0x3637A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-2 CVU' => 0x3636AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-3 CVU' => 0x3231B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-4 CVU' => 0x2A2ABA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-5 CVU' => 0x2325C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-6 CVU' => 0x1B1ECC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-7 CVU' => 0x1315D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-8 CVU' => 0x303AA0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-9 CVU' => 0x2D37A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-10 CVU' => 0x2632AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-11 CVU' => 0x222FB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-12 CVU' => 0x1F2BB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-13 CVU' => 0x1B25C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 160-14 CVU' => 0x131DCB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-1 CVU' => 0x2C2D96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-2 CVU' => 0x2C2C9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-3 CVU' => 0x2C2BA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-4 CVU' => 0x2525B0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-5 CVU' => 0x2022BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-6 CVU' => 0x191BC5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-7 CVU' => 0x1113D1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-8 CVU' => 0x232A88 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-9 CVU' => 0x22288D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-10 CVU' => 0x1E2699 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-11 CVU' => 0x1A239C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-12 CVU' => 0x1922A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-13 CVU' => 0x161EAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 165-14 CVU' => 0x1119C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-1 CVU' => 0x1D1C7A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-2 CVU' => 0x212187 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-3 CVU' => 0x201E8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-4 CVU' => 0x1F1D9E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-5 CVU' => 0x1A19A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-6 CVU' => 0x1516B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-7 CVU' => 0x0F10C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-8 CVU' => 0x101262 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-9 CVU' => 0x12146C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-10 CVU' => 0x111575 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-11 CVU' => 0x121781 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-12 CVU' => 0x12198F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-13 CVU' => 0x131AA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 170-14 CVU' => 0x0E15B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-1 CVU' => 0x2A3D97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-2 CVU' => 0x293A9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-3 CVU' => 0x2336A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-4 CVU' => 0x1F34A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-5 CVU' => 0x1C31AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-6 CVU' => 0x1C2AB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-7 CVU' => 0x1924C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-8 CVU' => 0x253F8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-9 CVU' => 0x213C95 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-10 CVU' => 0x1E3B9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-11 CVU' => 0x1B399E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-12 CVU' => 0x1935A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-13 CVU' => 0x162EB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 175-14 CVU' => 0x1425C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-1 CVU' => 0x223289 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-2 CVU' => 0x21308E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-3 CVU' => 0x1E2F9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-4 CVU' => 0x1B2E9F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-5 CVU' => 0x192DA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-6 CVU' => 0x1A27B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-7 CVU' => 0x1621BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-8 CVU' => 0x1A2E7A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-9 CVU' => 0x172C7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-10 CVU' => 0x162D88 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-11 CVU' => 0x142B8C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-12 CVU' => 0x132B96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-13 CVU' => 0x1225A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 180-14 CVU' => 0x1121B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-1 CVU' => 0x162071 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-2 CVU' => 0x19247D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-3 CVU' => 0x152184 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-4 CVU' => 0x162590 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-5 CVU' => 0x132294 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-6 CVU' => 0x161FA2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-7 CVU' => 0x141DAE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-8 CVU' => 0x0C155B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-9 CVU' => 0x0C1763 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-10 CVU' => 0x0C1A6C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-11 CVU' => 0x0D1D75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-12 CVU' => 0x0E2084 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-13 CVU' => 0x0F2196 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 185-14 CVU' => 0x0E1CA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-1 CVU' => 0x26408D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-2 CVU' => 0x223E92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-3 CVU' => 0x1D399C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-4 CVU' => 0x1732AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-5 CVU' => 0x1027BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-6 CVU' => 0x0C1ECA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-7 CVU' => 0x0812DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-8 CVU' => 0x263F8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-9 CVU' => 0x1E3B99 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-10 CVU' => 0x1936A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-11 CVU' => 0x122BB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-12 CVU' => 0x0D22C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-13 CVU' => 0x0919D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 190-14 CVU' => 0x060DE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-1 CVU' => 0x1F3581 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-2 CVU' => 0x1C3485 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-3 CVU' => 0x183396 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-4 CVU' => 0x132DA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-5 CVU' => 0x0E24B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-6 CVU' => 0x0A1CC5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-7 CVU' => 0x0711D4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-8 CVU' => 0x1B307C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-9 CVU' => 0x162C85 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-10 CVU' => 0x132B92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-11 CVU' => 0x0D21A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-12 CVU' => 0x0A1BB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-13 CVU' => 0x0814C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 195-14 CVU' => 0x060CD5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-1 CVU' => 0x13226A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-2 CVU' => 0x152876 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-3 CVU' => 0x112580 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-4 CVU' => 0x102494 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-5 CVU' => 0x0A1BA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-6 CVU' => 0x0917B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-7 CVU' => 0x070FC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-8 CVU' => 0x0C145C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-9 CVU' => 0x0C1767 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-10 CVU' => 0x0B1873 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-11 CVU' => 0x091686 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-12 CVU' => 0x08159B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-13 CVU' => 0x0712B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 200-14 CVU' => 0x040AC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-1 CVU' => 0x203F8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-2 CVU' => 0x1D3E93 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-3 CVU' => 0x1A3C98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-4 CVU' => 0x193A9D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-5 CVU' => 0x1437A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-6 CVU' => 0x1032AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-7 CVU' => 0x0C2AB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-8 CVU' => 0x173F92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-9 CVU' => 0x133E93 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-10 CVU' => 0x113A9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-11 CVU' => 0x1039A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-12 CVU' => 0x0E36A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-13 CVU' => 0x0833AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 205-14 CVU' => 0x072CB6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-1 CVU' => 0x193583 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-2 CVU' => 0x163387 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-3 CVU' => 0x163590 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-4 CVU' => 0x143395 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-5 CVU' => 0x12339E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-6 CVU' => 0x0F2EA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-7 CVU' => 0x0B27B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-8 CVU' => 0x0F2F7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-9 CVU' => 0x0C2F7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-10 CVU' => 0x0C2F8A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-11 CVU' => 0x0B2D8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-12 CVU' => 0x0B2C97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-13 CVU' => 0x062A9B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 210-14 CVU' => 0x0627AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-1 CVU' => 0x10236D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-2 CVU' => 0x112878 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-3 CVU' => 0x0F267C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-4 CVU' => 0x102B88 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-5 CVU' => 0x0D288D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-6 CVU' => 0x0C2699 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-7 CVU' => 0x0922A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-8 CVU' => 0x07165F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-9 CVU' => 0x061964 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-10 CVU' => 0x061B6E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-11 CVU' => 0x061E78 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-12 CVU' => 0x072284 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-13 CVU' => 0x052593 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 215-14 CVU' => 0x0522A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-1 CVU' => 0x12408B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-2 CVU' => 0x0F408D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-3 CVU' => 0x0E3B9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-4 CVU' => 0x0C38A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-5 CVU' => 0x0934AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-6 CVU' => 0x072FB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-7 CVU' => 0x0623C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-8 CVU' => 0x0A418C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-9 CVU' => 0x07418D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-10 CVU' => 0x043F96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-11 CVU' => 0x0239A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-12 CVU' => 0x0033AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-13 CVU' => 0x002ABA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 220-14 CVU' => 0x001DCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-1 CVU' => 0x0C377F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-2 CVU' => 0x0A3682 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-3 CVU' => 0x0B3592 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-4 CVU' => 0x09319B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-5 CVU' => 0x0831A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-6 CVU' => 0x062CAB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-7 CVU' => 0x0621BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-8 CVU' => 0x043179 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-9 CVU' => 0x023179 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-10 CVU' => 0x013286 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-11 CVU' => 0xFF2D92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-12 CVU' => 0x002B9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-13 CVU' => 0x0022AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 225-14 CVU' => 0x001AC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-1 CVU' => 0x072468 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-2 CVU' => 0x072A72 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-3 CVU' => 0x06267D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-4 CVU' => 0x06298C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-5 CVU' => 0x052593 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-6 CVU' => 0x04249E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-7 CVU' => 0x051CB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-8 CVU' => 0x01165B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-9 CVU' => 0x001B60 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-10 CVU' => 0xFF1D6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-11 CVU' => 0xFF1E7A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-12 CVU' => 0xFF2089 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-13 CVU' => 0xFF1E9F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 230-14 CVU' => 0x0016B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-1 CVU' => 0x06428C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-2 CVU' => 0x04428E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-3 CVU' => 0x003E99 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-4 CVU' => 0xFE38A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-5 CVU' => 0xFF31B0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-6 CVU' => 0xFD2BBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-7 CVU' => 0xFD1DCE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-8 CVU' => 0x01438D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-9 CVU' => 0xFE438F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-10 CVU' => 0xFC3C9E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-11 CVU' => 0xFC36A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-12 CVU' => 0xF92DB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-13 CVU' => 0xFC21C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 235-14 CVU' => 0x0013DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-1 CVU' => 0x02377F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-2 CVU' => 0x013782 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-3 CVU' => 0xFF3890 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-4 CVU' => 0xFD339C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-5 CVU' => 0xFE2EAA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-6 CVU' => 0xFD27B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-7 CVU' => 0xFD1AC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-8 CVU' => 0xFE3279 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-9 CVU' => 0xFC327B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-10 CVU' => 0xFA308B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-11 CVU' => 0xFB2A97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-12 CVU' => 0xF925A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-13 CVU' => 0xFC1AB6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 240-14 CVU' => 0xFF10CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-1 CVU' => 0xFF2569 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-2 CVU' => 0xFF2B73 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-3 CVU' => 0xFE287B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-4 CVU' => 0xFD298F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-5 CVU' => 0xFE2397 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-6 CVU' => 0xFD20A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-7 CVU' => 0xFD15BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-8 CVU' => 0xFE175B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-9 CVU' => 0xFC1B61 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-10 CVU' => 0xFC1C6E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-11 CVU' => 0xFC1C7D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-12 CVU' => 0xFB1B91 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-13 CVU' => 0xFC16AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 245-14 CVU' => 0x000DBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-1 CVU' => 0xFA448F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-2 CVU' => 0xFA4390 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-3 CVU' => 0xF83F9B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-4 CVU' => 0xF73BA2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-5 CVU' => 0xF634AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-6 CVU' => 0xF826C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-7 CVU' => 0xFD13DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-8 CVU' => 0xF8418D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-9 CVU' => 0xF94295 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-10 CVU' => 0xF73CA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-11 CVU' => 0xF637A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-12 CVU' => 0xF72EB6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-13 CVU' => 0xFA1DCE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 250-14 CVU' => 0xFF0EE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-1 CVU' => 0xF93A83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-2 CVU' => 0xF93983 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-3 CVU' => 0xF73892 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-4 CVU' => 0xF63698 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-5 CVU' => 0xF631A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-6 CVU' => 0xF923BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-7 CVU' => 0xFD11D3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-8 CVU' => 0xF82E7C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-9 CVU' => 0xF83280 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-10 CVU' => 0xF72F8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-11 CVU' => 0xF72B96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-12 CVU' => 0xF825A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-13 CVU' => 0xFB17B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 255-14 CVU' => 0xFF0BD4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-1 CVU' => 0xF9256D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-2 CVU' => 0xF82D74 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-3 CVU' => 0xF8297C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-4 CVU' => 0xF72C88 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-5 CVU' => 0xF72692 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-6 CVU' => 0xFA1CA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-7 CVU' => 0xFD10C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-8 CVU' => 0xFB195D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-9 CVU' => 0xFA1C64 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-10 CVU' => 0xFA1C70 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-11 CVU' => 0xF91D7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-12 CVU' => 0xF91D8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-13 CVU' => 0xFC14AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 260-14 CVU' => 0xFF0AC4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-1 CVU' => 0xF43C87 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-2 CVU' => 0xF53C8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-3 CVU' => 0xF33798 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-4 CVU' => 0xF232A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-5 CVU' => 0xF52DB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-6 CVU' => 0xF71FC4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-7 CVU' => 0xFB11D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-8 CVU' => 0xF03681 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-9 CVU' => 0xF03688 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-10 CVU' => 0xF03590 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-11 CVU' => 0xF0319B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-12 CVU' => 0xF12AA6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-13 CVU' => 0xF325B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 265-14 CVU' => 0xF81BCA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-1 CVU' => 0xF4337C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-2 CVU' => 0xF53382 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-3 CVU' => 0xF23290 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-4 CVU' => 0xF22D98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-5 CVU' => 0xF52AAB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-6 CVU' => 0xF71DBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-7 CVU' => 0xFB10CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-8 CVU' => 0xF22A73 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-9 CVU' => 0xF32A77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-10 CVU' => 0xF22B80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-11 CVU' => 0xF3278A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-12 CVU' => 0xF22296 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-13 CVU' => 0xF51EA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 270-14 CVU' => 0xF917BF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-1 CVU' => 0xF62468 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-2 CVU' => 0xF62973 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-3 CVU' => 0xF6257B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-4 CVU' => 0xF52589 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-5 CVU' => 0xF72097 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-6 CVU' => 0xF917AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-7 CVU' => 0xFC0DC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-8 CVU' => 0xF91659 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-9 CVU' => 0xF91860 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-10 CVU' => 0xF71A68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-11 CVU' => 0xF71B74 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-12 CVU' => 0xF61A84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-13 CVU' => 0xF61B98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 275-14 CVU' => 0xFA14B0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-1 CVU' => 0xEE3076 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-2 CVU' => 0xF03379 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-3 CVU' => 0xEF3483 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-4 CVU' => 0xEF3093 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-5 CVU' => 0xEF2BA0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-6 CVU' => 0xF223B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-7 CVU' => 0xF618C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-8 CVU' => 0xE8276D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-9 CVU' => 0xE82975 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-10 CVU' => 0xE72684 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-11 CVU' => 0xE8258D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-12 CVU' => 0xEA2399 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-13 CVU' => 0xEC21A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 280-14 CVU' => 0xF117B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-1 CVU' => 0xEF2A6F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-2 CVU' => 0xF12D71 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-3 CVU' => 0xF0307D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-4 CVU' => 0xEF2C8B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-5 CVU' => 0xF0289B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-6 CVU' => 0xF221AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-7 CVU' => 0xF716C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-8 CVU' => 0xEC1F64 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-9 CVU' => 0xED216A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-10 CVU' => 0xEB2079 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-11 CVU' => 0xED1F82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-12 CVU' => 0xEE1E8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-13 CVU' => 0xF01B98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 285-14 CVU' => 0xF214AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-1 CVU' => 0xF41E60 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-2 CVU' => 0xF32467 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-3 CVU' => 0xF3246D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-4 CVU' => 0xF2267F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-5 CVU' => 0xF3218A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-6 CVU' => 0xF41B9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-7 CVU' => 0xF813B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-8 CVU' => 0xF61154 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-9 CVU' => 0xF51559 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-10 CVU' => 0xF31464 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-11 CVU' => 0xF2166D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-12 CVU' => 0xF2177D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-13 CVU' => 0xF1188E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 290-14 CVU' => 0xF412A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-1 CVU' => 0xE21D65 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-2 CVU' => 0xE3216B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-3 CVU' => 0xE3207A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-4 CVU' => 0xE41F84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-5 CVU' => 0xE61D8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-6 CVU' => 0xEA219A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-7 CVU' => 0xED1DA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-8 CVU' => 0xDD145C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-9 CVU' => 0xDD1768 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-10 CVU' => 0xDD1772 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-11 CVU' => 0xDF187A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-12 CVU' => 0xE11886 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-13 CVU' => 0xE61897 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 295-14 CVU' => 0xEB16AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-1 CVU' => 0xE61961 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-2 CVU' => 0xE71D66 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-3 CVU' => 0xE51D77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-4 CVU' => 0xE61D7E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-5 CVU' => 0xE71C8B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-6 CVU' => 0xEB2095 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-7 CVU' => 0xEE1CA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-8 CVU' => 0xE41056 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-9 CVU' => 0xE51260 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-10 CVU' => 0xE41369 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-11 CVU' => 0xE51371 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-12 CVU' => 0xE6147E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-13 CVU' => 0xEB148B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 300-14 CVU' => 0xEE13A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-1 CVU' => 0xEE1357 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-2 CVU' => 0xEC185F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-3 CVU' => 0xEC1669 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-4 CVU' => 0xEB1876 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-5 CVU' => 0xEC167E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-6 CVU' => 0xEE1A8A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-7 CVU' => 0xF0179A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-8 CVU' => 0xF30A4D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-9 CVU' => 0xF10B53 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-10 CVU' => 0xEF0C5A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-11 CVU' => 0xED0E64 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-12 CVU' => 0xEC1071 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-13 CVU' => 0xED1284 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 305-14 CVU' => 0xF01196 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-1 CVU' => 0xDB105B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-2 CVU' => 0xDB1168 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-3 CVU' => 0xDD127E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-4 CVU' => 0xE31196 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-5 CVU' => 0xEC0EB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-6 CVU' => 0xF20BC4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-7 CVU' => 0xF907D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-8 CVU' => 0xDB115D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-9 CVU' => 0xDB1175 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-10 CVU' => 0xE01289 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-11 CVU' => 0xE810A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-12 CVU' => 0xEE0DBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-13 CVU' => 0xF50ACD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 310-14 CVU' => 0xFC05E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-1 CVU' => 0xE00E58 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-2 CVU' => 0xDF0E64 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-3 CVU' => 0xE0107A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-4 CVU' => 0xE61090 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-5 CVU' => 0xED0DAD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-6 CVU' => 0xF20ABE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-7 CVU' => 0xFA06D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-8 CVU' => 0xE20D59 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-9 CVU' => 0xE40E6C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-10 CVU' => 0xE60E7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-11 CVU' => 0xEE0C98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-12 CVU' => 0xF20AAC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-13 CVU' => 0xF707BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 315-14 CVU' => 0xFD04D5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-1 CVU' => 0xE90A52 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-2 CVU' => 0xE60C5E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-3 CVU' => 0xE90C6E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-4 CVU' => 0xEA0D85 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-5 CVU' => 0xF10A9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-6 CVU' => 0xF508AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-7 CVU' => 0xFA05C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-8 CVU' => 0xF2084E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-9 CVU' => 0xF1095C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-10 CVU' => 0xF1096A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-11 CVU' => 0xF40881 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-12 CVU' => 0xF50897 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-13 CVU' => 0xF806AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 320-14 CVU' => 0xFD04C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-1 CVU' => 0xD80C62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-2 CVU' => 0xD90E6D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-3 CVU' => 0xDB0E78 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-4 CVU' => 0xE00E7E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-5 CVU' => 0xE00E8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-6 CVU' => 0xE40B9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-7 CVU' => 0xE908AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-8 CVU' => 0xD6056D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-9 CVU' => 0xD70474 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-10 CVU' => 0xDB0684 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-11 CVU' => 0xDE068E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-12 CVU' => 0xE00797 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-13 CVU' => 0xE302A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 325-14 CVU' => 0xE802AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-1 CVU' => 0xDD0A5F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-2 CVU' => 0xDE0B69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-3 CVU' => 0xDE0D75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-4 CVU' => 0xE00E7D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-5 CVU' => 0xE10D89 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-6 CVU' => 0xE50B97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-7 CVU' => 0xEA08A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-8 CVU' => 0xDF0365 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-9 CVU' => 0xE0026B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-10 CVU' => 0xE2047A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-11 CVU' => 0xE50581 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-12 CVU' => 0xE6058C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-13 CVU' => 0xE80095 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 330-14 CVU' => 0xEA02A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-1 CVU' => 0xE80856 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-2 CVU' => 0xE50961 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-3 CVU' => 0xE70A69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-4 CVU' => 0xE60B76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-5 CVU' => 0xE80B7E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-6 CVU' => 0xEA098E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-7 CVU' => 0xEE07A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-8 CVU' => 0xF00353 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-9 CVU' => 0xF00353 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-10 CVU' => 0xEE0366 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-11 CVU' => 0xED0471 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-12 CVU' => 0xEC047D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-13 CVU' => 0xEB018D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 335-14 CVU' => 0xED019B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-1 CVU' => 0xD60174 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-2 CVU' => 0xD8017C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-3 CVU' => 0xDB0288 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-4 CVU' => 0xDD0091 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-5 CVU' => 0xE0019C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-6 CVU' => 0xE5FFA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-7 CVU' => 0xEC03BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-8 CVU' => 0xD6F97F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-9 CVU' => 0xD7F784 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-10 CVU' => 0xD8F58C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-11 CVU' => 0xDDF59A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-12 CVU' => 0xE1F7A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-13 CVU' => 0xE9F9B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 340-14 CVU' => 0xF1FCCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-1 CVU' => 0xDC006F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-2 CVU' => 0xDE0076 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-3 CVU' => 0xDE0282 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-4 CVU' => 0xE0008A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-5 CVU' => 0xE20097 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-6 CVU' => 0xE6FFA4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-7 CVU' => 0xEE02B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-8 CVU' => 0xE0F874 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-9 CVU' => 0xE1F778 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-10 CVU' => 0xE0F682 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-11 CVU' => 0xE4F68C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-12 CVU' => 0xE7F89A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-13 CVU' => 0xEDFAA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 345-14 CVU' => 0xF3FDC0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-1 CVU' => 0xE80062 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-2 CVU' => 0xE5006C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-3 CVU' => 0xE80175 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-4 CVU' => 0xE6007F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-5 CVU' => 0xE90088 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-6 CVU' => 0xEBFF96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-7 CVU' => 0xF003A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-8 CVU' => 0xF1FD5B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-9 CVU' => 0xEFFB62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-10 CVU' => 0xEDFA6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-11 CVU' => 0xEDF976 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-12 CVU' => 0xEEF988 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-13 CVU' => 0xF0FB9E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 350-14 CVU' => 0xF5FDB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-1 CVU' => 0xD6F385 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-2 CVU' => 0xD8F18E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-3 CVU' => 0xDAF195 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-4 CVU' => 0xDEF1A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-5 CVU' => 0xE3F5AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-6 CVU' => 0xE8F5BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-7 CVU' => 0xF1F7D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-8 CVU' => 0xD6ED8C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-9 CVU' => 0xD9EB96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-10 CVU' => 0xDCED9F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-11 CVU' => 0xE0EFA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-12 CVU' => 0xE7EFBB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-13 CVU' => 0xEFF5CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 355-14 CVU' => 0xF7FCDB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-1 CVU' => 0xDCF47C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-2 CVU' => 0xDEF383 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-3 CVU' => 0xDEF28F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-4 CVU' => 0xE1F397 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-5 CVU' => 0xE5F6A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-6 CVU' => 0xEAF6B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-7 CVU' => 0xF3F8C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-8 CVU' => 0xE0F07C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-9 CVU' => 0xE3EF84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-10 CVU' => 0xE4F090 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-11 CVU' => 0xE7F195 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-12 CVU' => 0xECF2A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-13 CVU' => 0xF3F8B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 360-14 CVU' => 0xF9FCCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-1 CVU' => 0xE8F76B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-2 CVU' => 0xE6F578 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-3 CVU' => 0xE8F57C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-4 CVU' => 0xE8F48C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-5 CVU' => 0xECF796 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-6 CVU' => 0xEFF7A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-7 CVU' => 0xF6F9BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-8 CVU' => 0xF2F85F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-9 CVU' => 0xF0F668 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-10 CVU' => 0xF1F674 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-11 CVU' => 0xF0F67E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-12 CVU' => 0xF2F593 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-13 CVU' => 0xF5F8AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 365-14 CVU' => 0xFAFDBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-1 CVU' => 0xD5E68F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-2 CVU' => 0xD6E694 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-3 CVU' => 0xDEE7A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-4 CVU' => 0xE2E9B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-5 CVU' => 0xE8ECC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-6 CVU' => 0xF1F3D3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-7 CVU' => 0xFBFAE5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-8 CVU' => 0xD6E68D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-9 CVU' => 0xD8E699 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-10 CVU' => 0xE0E8AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-11 CVU' => 0xE6EBBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-12 CVU' => 0xECEFC9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-13 CVU' => 0xF6F6DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 370-14 CVU' => 0xFDFCEA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-1 CVU' => 0xDBE885 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-2 CVU' => 0xDCE88A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-3 CVU' => 0xE0E8A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-4 CVU' => 0xE5EAAB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-5 CVU' => 0xE9EDBB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-6 CVU' => 0xF2F3CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-7 CVU' => 0xFCFBDF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-8 CVU' => 0xDFE97F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-9 CVU' => 0xE1E98A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-10 CVU' => 0xE6EB9E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-11 CVU' => 0xECEFAA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-12 CVU' => 0xF0F2BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-13 CVU' => 0xF9F8CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 375-14 CVU' => 0xFEFDDE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-1 CVU' => 0xE6EE71 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-2 CVU' => 0xE3EB7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-3 CVU' => 0xE9ED8B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-4 CVU' => 0xEAED9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-5 CVU' => 0xEEF0A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-6 CVU' => 0xF5F5BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-7 CVU' => 0xFCFBD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-8 CVU' => 0xF0F55E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-9 CVU' => 0xEFF36A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-10 CVU' => 0xF1F37C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-11 CVU' => 0xF2F48E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-12 CVU' => 0xF4F5A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-13 CVU' => 0xFAF9BF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 380-14 CVU' => 0xFEFDCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-1 CVU' => 0xD9E48C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-2 CVU' => 0xDBE398 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-3 CVU' => 0xE2E5AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-4 CVU' => 0xE8E8B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-5 CVU' => 0xECEDC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-6 CVU' => 0xF5F3D6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-7 CVU' => 0xFCF8E3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-8 CVU' => 0xDCE18B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-9 CVU' => 0xDEE197 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-10 CVU' => 0xE3E2A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-11 CVU' => 0xE8E6B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-12 CVU' => 0xEEE9C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-13 CVU' => 0xF1EDCB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 385-14 CVU' => 0xF7F4DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-1 CVU' => 0xDEE683 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-2 CVU' => 0xE0E68E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-3 CVU' => 0xE6E7A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-4 CVU' => 0xEBEAAF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-5 CVU' => 0xEEEEC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-6 CVU' => 0xF6F3D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-7 CVU' => 0xFDF9DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-8 CVU' => 0xE3E67D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-9 CVU' => 0xE5E787 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-10 CVU' => 0xE8E796 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-11 CVU' => 0xEDEAA3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-12 CVU' => 0xF1ECB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-13 CVU' => 0xF4F0B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 390-14 CVU' => 0xF8F6D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-1 CVU' => 0xE8ED70 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-2 CVU' => 0xE6EB7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-3 CVU' => 0xECED8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-4 CVU' => 0xEEEDA2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-5 CVU' => 0xF3F2AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-6 CVU' => 0xF7F5BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-7 CVU' => 0xFDFAD0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-8 CVU' => 0xF1F45D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-9 CVU' => 0xF0F168 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-10 CVU' => 0xF1F077 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-11 CVU' => 0xF3F088 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-12 CVU' => 0xF4F19C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-13 CVU' => 0xF5F2AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 395-14 CVU' => 0xFAF7C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-1 CVU' => 0xE1DD8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-2 CVU' => 0xE1DE93 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-3 CVU' => 0xE3E09D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-4 CVU' => 0xE8E3AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-5 CVU' => 0xEDE7BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-6 CVU' => 0xF3ECCA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-7 CVU' => 0xF9F2D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-8 CVU' => 0xE7DA8C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-9 CVU' => 0xE9DA97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-10 CVU' => 0xEEDDA6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-11 CVU' => 0xEFDFAC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-12 CVU' => 0xF1E2B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-13 CVU' => 0xF4E6C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 400-14 CVU' => 0xFAECD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-1 CVU' => 0xE5E286 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-2 CVU' => 0xE5E289 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-3 CVU' => 0xE5E296 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-4 CVU' => 0xEAE6A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-5 CVU' => 0xEEE8B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-6 CVU' => 0xF4EDC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-7 CVU' => 0xFAF3D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-8 CVU' => 0xECE17F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-9 CVU' => 0xEEE287 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-10 CVU' => 0xF1E397 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-11 CVU' => 0xF2E59D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-12 CVU' => 0xF3E7A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-13 CVU' => 0xF6EBB3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 405-14 CVU' => 0xFBEEC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-1 CVU' => 0xEDEA72 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-2 CVU' => 0xEBE87B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-3 CVU' => 0xECE981 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-4 CVU' => 0xEDE995 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-5 CVU' => 0xF1EDA0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-6 CVU' => 0xF6F0B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-7 CVU' => 0xFAF4C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-8 CVU' => 0xF5F15F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-9 CVU' => 0xF5EF69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-10 CVU' => 0xF6EE77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-11 CVU' => 0xF6ED83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-12 CVU' => 0xF5EC93 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-13 CVU' => 0xF7EDA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 410-14 CVU' => 0xFBF1BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-1 CVU' => 0xEDD689 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-2 CVU' => 0xEFD693 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-3 CVU' => 0xF2D9A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-4 CVU' => 0xF3DBA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-5 CVU' => 0xF5DEB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-6 CVU' => 0xF3E3BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-7 CVU' => 0xF6E8C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-8 CVU' => 0xF5D284 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-9 CVU' => 0xF8D295 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-10 CVU' => 0xF9D49D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-11 CVU' => 0xF9D6A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-12 CVU' => 0xF9DAAF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-13 CVU' => 0xFADFBB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 415-14 CVU' => 0xFAE6C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-1 CVU' => 0xF0DB80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-2 CVU' => 0xF1DC89 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-3 CVU' => 0xF3DC9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-4 CVU' => 0xF4DEA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-5 CVU' => 0xF6E0AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-6 CVU' => 0xF4E4B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-7 CVU' => 0xF7E8C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-8 CVU' => 0xF6DB77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-9 CVU' => 0xF9DC83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-10 CVU' => 0xF9DC8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-11 CVU' => 0xFADE94 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-12 CVU' => 0xFAE0A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-13 CVU' => 0xFAE5AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 420-14 CVU' => 0xFBE9BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-1 CVU' => 0xF4E66E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-2 CVU' => 0xF3E37C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-3 CVU' => 0xF6E685 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-4 CVU' => 0xF6E494 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-5 CVU' => 0xF7E79B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-6 CVU' => 0xF6E9A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-7 CVU' => 0xF8ECB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-8 CVU' => 0xFAEE5A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-9 CVU' => 0xFBEB67 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-10 CVU' => 0xFBEA71 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-11 CVU' => 0xFBE87D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-12 CVU' => 0xFBE78D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-13 CVU' => 0xFBE8A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 425-14 CVU' => 0xFCECB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-1 CVU' => 0xFDD178 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-2 CVU' => 0xFBD08A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-3 CVU' => 0xFDD4A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-4 CVU' => 0xFEDBB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-5 CVU' => 0xFEE5CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-6 CVU' => 0xFFEDD6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-7 CVU' => 0x00F5E3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-8 CVU' => 0xFCD07F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-9 CVU' => 0xFAD39A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-10 CVU' => 0xFDD8AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-11 CVU' => 0xFEE2C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-12 CVU' => 0xFEE9D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-13 CVU' => 0xFFF1DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 430-14 CVU' => 0x01F9E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-1 CVU' => 0xFCD672 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-2 CVU' => 0xFAD681 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-3 CVU' => 0xFCD89E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-4 CVU' => 0xFDDFB0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-5 CVU' => 0xFEE8C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-6 CVU' => 0xFFEED0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-7 CVU' => 0x01F7DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-8 CVU' => 0xFCD875 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-9 CVU' => 0xFBDC8A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-10 CVU' => 0xFDE09F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-11 CVU' => 0xFEE9B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-12 CVU' => 0xFFEDBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-13 CVU' => 0x00F4CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 435-14 CVU' => 0x01FBDD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-1 CVU' => 0xFCE163 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-2 CVU' => 0xFBDE74 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-3 CVU' => 0xFDE288 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-4 CVU' => 0xFEE4A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-5 CVU' => 0xFEEDAE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-6 CVU' => 0xFFF2BF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-7 CVU' => 0x01F8CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-8 CVU' => 0xFCEC58 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-9 CVU' => 0xFCEB69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-10 CVU' => 0xFDEC7C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-11 CVU' => 0xFFF093 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-12 CVU' => 0xFFF2A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-13 CVU' => 0x00F5BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 440-14 CVU' => 0x01FBCD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-1 CVU' => 0x03CB85 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-2 CVU' => 0x00CE92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-3 CVU' => 0x01D0A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-4 CVU' => 0x01D3A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-5 CVU' => 0x00D6B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-6 CVU' => 0x01DCBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-7 CVU' => 0x02E3CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-8 CVU' => 0x0AC990 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-9 CVU' => 0x09CB98 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-10 CVU' => 0x06D1AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-11 CVU' => 0x06D4B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-12 CVU' => 0x04D7B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-13 CVU' => 0x07DAC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 445-14 CVU' => 0x05E1CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-1 CVU' => 0x02D27D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-2 CVU' => 0xFFD58A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-3 CVU' => 0x00D59A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-4 CVU' => 0x00D7A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-5 CVU' => 0x01D9AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-6 CVU' => 0x01DEB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-7 CVU' => 0x02E4C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-8 CVU' => 0x07D480 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-9 CVU' => 0x06D686 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-10 CVU' => 0x05DA9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-11 CVU' => 0x04DDA0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-12 CVU' => 0x03DEA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-13 CVU' => 0x05E1B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 450-14 CVU' => 0x05E4C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-1 CVU' => 0x01E06B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-2 CVU' => 0xFFDD7C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-3 CVU' => 0xFFDF85 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-4 CVU' => 0x00DD95 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-5 CVU' => 0x00E09B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-6 CVU' => 0x01E3A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-7 CVU' => 0x02E8B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-8 CVU' => 0x02EB5E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-9 CVU' => 0x02E868 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-10 CVU' => 0x02E879 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-11 CVU' => 0x03E786 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-12 CVU' => 0x02E695 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-13 CVU' => 0x05E3A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 455-14 CVU' => 0x04E7B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-1 CVU' => 0x10C791 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-2 CVU' => 0x0FC99E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-3 CVU' => 0x0BCFAF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-4 CVU' => 0x0BD3B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-5 CVU' => 0x0AD7BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-6 CVU' => 0x09DCC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-7 CVU' => 0x05E6D4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-8 CVU' => 0x13C696 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-9 CVU' => 0x14C79E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-10 CVU' => 0x12CBAC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-11 CVU' => 0x0FD2BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-12 CVU' => 0x0DD9C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-13 CVU' => 0x09E1D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 460-14 CVU' => 0x06EBDC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-1 CVU' => 0x0DCE88 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-2 CVU' => 0x0CD094 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-3 CVU' => 0x0AD4A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-4 CVU' => 0x09D8B0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-5 CVU' => 0x09DAB9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-6 CVU' => 0x08DFC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-7 CVU' => 0x04E8CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-8 CVU' => 0x0FD188 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-9 CVU' => 0x0FD28D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-10 CVU' => 0x0ED49E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-11 CVU' => 0x0CDBAA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-12 CVU' => 0x0AE0B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-13 CVU' => 0x08E6C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 465-14 CVU' => 0x06EED2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-1 CVU' => 0x08DC73 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-2 CVU' => 0x09D984 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-3 CVU' => 0x07DF92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-4 CVU' => 0x07DEA1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-5 CVU' => 0x06E2A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-6 CVU' => 0x06E4B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-7 CVU' => 0x03ECC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-8 CVU' => 0x06E962 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-9 CVU' => 0x07E56C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-10 CVU' => 0x08E47C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-11 CVU' => 0x08E68F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-12 CVU' => 0x08E7A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-13 CVU' => 0x07EAB5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 470-14 CVU' => 0x05F0C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-1 CVU' => 0x15C59A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-2 CVU' => 0x14C8A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-3 CVU' => 0x12CDB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-4 CVU' => 0x0FD5C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-5 CVU' => 0x0DDBC9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-6 CVU' => 0x0BE2D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-7 CVU' => 0x08ECDF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-8 CVU' => 0x17C59D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-9 CVU' => 0x16C8A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-10 CVU' => 0x12D0BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-11 CVU' => 0x10D6C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-12 CVU' => 0x0EDECF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-13 CVU' => 0x0AE8DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 475-14 CVU' => 0x06F2E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-1 CVU' => 0x12CD90 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-2 CVU' => 0x11D09B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-3 CVU' => 0x11D1AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-4 CVU' => 0x0ED8B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-5 CVU' => 0x0CDDC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-6 CVU' => 0x0BE3CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-7 CVU' => 0x08EDD7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-8 CVU' => 0x12D18B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-9 CVU' => 0x11D495 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-10 CVU' => 0x0FD9A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-11 CVU' => 0x0CDFB0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-12 CVU' => 0x0BE4BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-13 CVU' => 0x08EDC8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 480-14 CVU' => 0x05F5D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-1 CVU' => 0x0CDC79 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-2 CVU' => 0x0DD889 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-3 CVU' => 0x0CDD94 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-4 CVU' => 0x0BDEA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-5 CVU' => 0x09E4AE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-6 CVU' => 0x08E8BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-7 CVU' => 0x06F0CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-8 CVU' => 0x07E865 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-9 CVU' => 0x08E771 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-10 CVU' => 0x09E783 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-11 CVU' => 0x09E893 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-12 CVU' => 0x09EAA6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-13 CVU' => 0x07EFBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 485-14 CVU' => 0x04F6CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-1 CVU' => 0x18C79E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-2 CVU' => 0x18C7A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-3 CVU' => 0x15CDB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-4 CVU' => 0x14D1BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-5 CVU' => 0x12D5C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-6 CVU' => 0x0DE2D4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-7 CVU' => 0x08F1E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-8 CVU' => 0x18C69E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-9 CVU' => 0x17C8AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-10 CVU' => 0x14D0BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-11 CVU' => 0x12D4C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-12 CVU' => 0x10DBCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-13 CVU' => 0x0AEADD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 490-14 CVU' => 0x06F6E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-1 CVU' => 0x13D08F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-2 CVU' => 0x13D193 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-3 CVU' => 0x12D4AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-4 CVU' => 0x11D7AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-5 CVU' => 0x10D9BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-6 CVU' => 0x0CE4CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-7 CVU' => 0x07F2DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-8 CVU' => 0x11D587 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-9 CVU' => 0x10D88F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-10 CVU' => 0x0FDCA2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-11 CVU' => 0x0DE1A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-12 CVU' => 0x0CE4B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-13 CVU' => 0x08EFC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 495-14 CVU' => 0x05F8D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-1 CVU' => 0x0BE173 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-2 CVU' => 0x0DDD7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-3 CVU' => 0x0CE28B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-4 CVU' => 0x0DE099 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-5 CVU' => 0x0BE59F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-6 CVU' => 0x09EBB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-7 CVU' => 0x06F5C7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-8 CVU' => 0x05EE5F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-9 CVU' => 0x06ED68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-10 CVU' => 0x07EE77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-11 CVU' => 0x07EE83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-12 CVU' => 0x08ED96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-13 CVU' => 0x06F3B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 500-14 CVU' => 0x04FAC3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-1 CVU' => 0x19C69D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-2 CVU' => 0x19C8A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-3 CVU' => 0x17CFBA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-4 CVU' => 0x16D4C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-5 CVU' => 0x12DBCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-6 CVU' => 0x0EE5D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-7 CVU' => 0x0BF1E4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-8 CVU' => 0x1BC69C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-9 CVU' => 0x1BC8A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-10 CVU' => 0x19CDB5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-11 CVU' => 0x18D1BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-12 CVU' => 0x17D7C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-13 CVU' => 0x13DDCF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 505-14 CVU' => 0x0DE9DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-1 CVU' => 0x15D08F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-2 CVU' => 0x14D297 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-3 CVU' => 0x14D5AE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-4 CVU' => 0x13DAB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-5 CVU' => 0x10DDC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-6 CVU' => 0x0DE8CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-7 CVU' => 0x0AF2DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-8 CVU' => 0x13D585 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-9 CVU' => 0x13D78D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-10 CVU' => 0x13DA9D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-11 CVU' => 0x11DFA4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-12 CVU' => 0x11E0AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-13 CVU' => 0x0EE6B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 510-14 CVU' => 0x0BECCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-1 CVU' => 0x0CE172 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-2 CVU' => 0x0FDD83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-3 CVU' => 0x0DE48E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-4 CVU' => 0x0EE2A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-5 CVU' => 0x0CE7A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-6 CVU' => 0x0AEDB7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-7 CVU' => 0x08F4C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-8 CVU' => 0x07EE5F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-9 CVU' => 0x08EC68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-10 CVU' => 0x09EC74 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-11 CVU' => 0x0AEB82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-12 CVU' => 0x0CEA94 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-13 CVU' => 0x0CEAA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 515-14 CVU' => 0x0AF0BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-1 CVU' => 0x1DC7A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-2 CVU' => 0x1CC7A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-3 CVU' => 0x1CCCB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-4 CVU' => 0x19D3C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-5 CVU' => 0x17D8C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-6 CVU' => 0x14E0D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-7 CVU' => 0x0FEBDE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-8 CVU' => 0x1FC79F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-9 CVU' => 0x20C9A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-10 CVU' => 0x21D0BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-11 CVU' => 0x1FD4C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-12 CVU' => 0x1DD7C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-13 CVU' => 0x19DCCD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 520-14 CVU' => 0x16E6D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-1 CVU' => 0x17D28F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-2 CVU' => 0x16D393 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-3 CVU' => 0x18D3A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-4 CVU' => 0x16D9B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-5 CVU' => 0x15DCBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-6 CVU' => 0x12E3C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-7 CVU' => 0x0EEDD5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-8 CVU' => 0x16D885 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-9 CVU' => 0x16DB8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-10 CVU' => 0x18DEA0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-11 CVU' => 0x16E1A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-12 CVU' => 0x16E2AF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-13 CVU' => 0x13E6B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 525-14 CVU' => 0x12EBCA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-1 CVU' => 0x0DE470 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-2 CVU' => 0x0FDF7D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-3 CVU' => 0x0FE388 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-4 CVU' => 0x10E29C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-5 CVU' => 0x0FE6A0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-6 CVU' => 0x0EEAB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-7 CVU' => 0x0BF1C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-8 CVU' => 0x07F15C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-9 CVU' => 0x09EF65 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-10 CVU' => 0x0CEF75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-11 CVU' => 0x0DED82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-12 CVU' => 0x0FEB92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-13 CVU' => 0x10E9A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 530-14 CVU' => 0x0EF0B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-1 CVU' => 0x22C89D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-2 CVU' => 0x24CAA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-3 CVU' => 0x25D1BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-4 CVU' => 0x23D4C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-5 CVU' => 0x21D7C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-6 CVU' => 0x1CD9C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-7 CVU' => 0x19E0D1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-8 CVU' => 0x26CA99 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-9 CVU' => 0x29CCAA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-10 CVU' => 0x2BD1B8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-11 CVU' => 0x2AD4BD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-12 CVU' => 0x26D7C4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-13 CVU' => 0x22DBCA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 535-14 CVU' => 0x1CE2D4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-1 CVU' => 0x1CD38D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-2 CVU' => 0x1CD496 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-3 CVU' => 0x20D7AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-4 CVU' => 0x1FDAB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-5 CVU' => 0x1FDBBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-6 CVU' => 0x1ADCC0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-7 CVU' => 0x17E2C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-8 CVU' => 0x1BDA80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-9 CVU' => 0x1DDC8D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-10 CVU' => 0x1FDE9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-11 CVU' => 0x1EE0A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-12 CVU' => 0x1EE0AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-13 CVU' => 0x1AE4B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 540-14 CVU' => 0x18E7C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-1 CVU' => 0x10E371 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-2 CVU' => 0x15DF82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-3 CVU' => 0x15E58C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-4 CVU' => 0x18E29D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-5 CVU' => 0x16E5A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-6 CVU' => 0x14E4AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-7 CVU' => 0x14E7B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-8 CVU' => 0x0BEF5C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-9 CVU' => 0x0EEE68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-10 CVU' => 0x10EE75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-11 CVU' => 0x13EC81 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-12 CVU' => 0x16E992 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-13 CVU' => 0x17E8A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 545-14 CVU' => 0x14EBB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-1 CVU' => 0x2ACC9C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-2 CVU' => 0x2CCDA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-3 CVU' => 0x2BD3BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-4 CVU' => 0x26DBC9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-5 CVU' => 0x1FE5D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-6 CVU' => 0x18EDE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-7 CVU' => 0x0FF6E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-8 CVU' => 0x2BCC9F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-9 CVU' => 0x2CD0B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-10 CVU' => 0x28D7C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-11 CVU' => 0x21E2D3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-12 CVU' => 0x1CE9DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-13 CVU' => 0x14F1E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 550-14 CVU' => 0x0BF9EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-1 CVU' => 0x22D58C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-2 CVU' => 0x24D897 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-3 CVU' => 0x25DAAF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-4 CVU' => 0x21E1BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-5 CVU' => 0x1CE8CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-6 CVU' => 0x15F0D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-7 CVU' => 0x0EF7DE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-8 CVU' => 0x1FDB86 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-9 CVU' => 0x1EE096 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-10 CVU' => 0x1EE3A6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-11 CVU' => 0x18EBB2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-12 CVU' => 0x14EFBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-13 CVU' => 0x0FF5C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 555-14 CVU' => 0x0AFAD9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-1 CVU' => 0x14E66F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-2 CVU' => 0x1AE280 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-3 CVU' => 0x18E78B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-4 CVU' => 0x19E8A1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-5 CVU' => 0x13F0AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-6 CVU' => 0x10F4BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-7 CVU' => 0x0CF8C9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-8 CVU' => 0x0BF15D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-9 CVU' => 0x0EF16A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-10 CVU' => 0x0FF178 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-11 CVU' => 0x0EF489 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-12 CVU' => 0x0EF59E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-13 CVU' => 0x0CF8B5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 560-14 CVU' => 0x07FCBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-1 CVU' => 0x30CFA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-2 CVU' => 0x30D2B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-3 CVU' => 0x2FD3BA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-4 CVU' => 0x2DD7C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-5 CVU' => 0x2ADBC9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-6 CVU' => 0x28E3D3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-7 CVU' => 0x23E9DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-8 CVU' => 0x38D7B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-9 CVU' => 0x38DABD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-10 CVU' => 0x33DCC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-11 CVU' => 0x30DECC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-12 CVU' => 0x2DE1D0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-13 CVU' => 0x2DE9DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 565-14 CVU' => 0x27ECDF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-1 CVU' => 0x27D896 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-2 CVU' => 0x27DB9F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-3 CVU' => 0x28DAAE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-4 CVU' => 0x26DDB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-5 CVU' => 0x27DFC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-6 CVU' => 0x24E6CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-7 CVU' => 0x20EBD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-8 CVU' => 0x28E496 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-9 CVU' => 0x28E69A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-10 CVU' => 0x26E6A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-11 CVU' => 0x22E8AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-12 CVU' => 0x22E9B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-13 CVU' => 0x21EEBD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 570-14 CVU' => 0x21EFCC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-1 CVU' => 0x18E877 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-2 CVU' => 0x1CE588 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-3 CVU' => 0x1AE78C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-4 CVU' => 0x1EE59D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-5 CVU' => 0x1CE8A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-6 CVU' => 0x1CEBB1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-7 CVU' => 0x1AEFBF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-8 CVU' => 0x0FF565 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-9 CVU' => 0x12F46D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-10 CVU' => 0x13F37B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-11 CVU' => 0x15F287 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-12 CVU' => 0x18F098 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-13 CVU' => 0x1DF2AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 575-14 CVU' => 0x1AF3B9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-1 CVU' => 0x3EDEC1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-2 CVU' => 0x3DE0C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-3 CVU' => 0x36E1CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-4 CVU' => 0x34E4D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-5 CVU' => 0x30E7D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-6 CVU' => 0x2DEBDC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-7 CVU' => 0x23EFE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-8 CVU' => 0x45E8CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-9 CVU' => 0x45EAD1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-10 CVU' => 0x41ECD8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-11 CVU' => 0x3AEEDD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-12 CVU' => 0x33F0E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-13 CVU' => 0x2AF2E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 580-14 CVU' => 0x1FF6EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-1 CVU' => 0x31E7A8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-2 CVU' => 0x30E7AB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-3 CVU' => 0x2EE5BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-4 CVU' => 0x2CE8C1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-5 CVU' => 0x2CE9CD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-6 CVU' => 0x28EDD2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-7 CVU' => 0x1FF1D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-8 CVU' => 0x2EF0A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-9 CVU' => 0x2EF1A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-10 CVU' => 0x2FF1B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-11 CVU' => 0x28F3B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-12 CVU' => 0x27F4C2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-13 CVU' => 0x1FF6C6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 585-14 CVU' => 0x19F8D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-1 CVU' => 0x1DF17F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-2 CVU' => 0x21EF8E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-3 CVU' => 0x1EEF95 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-4 CVU' => 0x21EEA7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-5 CVU' => 0x1FF0AA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-6 CVU' => 0x1FF1B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-7 CVU' => 0x19F3C3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-8 CVU' => 0x10F965 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-9 CVU' => 0x14F96F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-10 CVU' => 0x17F87C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-11 CVU' => 0x18F88B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-12 CVU' => 0x1BF79F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-13 CVU' => 0x1AF7B4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 590-14 CVU' => 0x14FAC2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-1 CVU' => 0x49EFD5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-2 CVU' => 0x47F0DA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-3 CVU' => 0x41F1DF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-4 CVU' => 0x3AF2E3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-5 CVU' => 0x31F2E4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-6 CVU' => 0x2BF6E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-7 CVU' => 0x1EFAEE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-8 CVU' => 0x4EF6DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-9 CVU' => 0x4EF6DE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-10 CVU' => 0x40F6E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-11 CVU' => 0x39F5E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-12 CVU' => 0x30F9EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-13 CVU' => 0x22FAED ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 595-14 CVU' => 0x16FBEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-1 CVU' => 0x39F2B6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-2 CVU' => 0x37F3BB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-3 CVU' => 0x38F2CB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-4 CVU' => 0x32F4CE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-5 CVU' => 0x2DF3D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-6 CVU' => 0x27F6DC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-7 CVU' => 0x1BFAE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-8 CVU' => 0x34F8AC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-9 CVU' => 0x31F9AE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-10 CVU' => 0x2DF8BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-11 CVU' => 0x28F7BC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-12 CVU' => 0x24FACA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-13 CVU' => 0x1AFBCD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 600-14 CVU' => 0x12FBDA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-1 CVU' => 0x21F787 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-2 CVU' => 0x28F79A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-3 CVU' => 0x24F89F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-4 CVU' => 0x25F6B2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-5 CVU' => 0x1FF7B3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-6 CVU' => 0x1EF8C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-7 CVU' => 0x15FBCD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-8 CVU' => 0x12FC69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-9 CVU' => 0x15FC74 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-10 CVU' => 0x16FB83 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-11 CVU' => 0x18FB92 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-12 CVU' => 0x19FCA8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-13 CVU' => 0x15FCBC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 605-14 CVU' => 0x0EFCC5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-1 CVU' => 0x1E0DA9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-2 CVU' => 0x2410A4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-3 CVU' => 0x26119D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-4 CVU' => 0x2C159F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-5 CVU' => 0x2C169B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-6 CVU' => 0x2D1899 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-7 CVU' => 0x2E1897 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-8 CVU' => 0x190A9D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-9 CVU' => 0x1E0C99 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-10 CVU' => 0x220F95 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-11 CVU' => 0x251094 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-12 CVU' => 0x26128F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-13 CVU' => 0x27138D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 610-14 CVU' => 0x27138C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-1 CVU' => 0x16088E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-2 CVU' => 0x1A098B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-3 CVU' => 0x1D0B89 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-4 CVU' => 0x1F0C87 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-5 CVU' => 0x200D84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-6 CVU' => 0x210F82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-7 CVU' => 0x220F81 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-8 CVU' => 0x130887 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-9 CVU' => 0x160983 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-10 CVU' => 0x190A82 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-11 CVU' => 0x1B0C80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-12 CVU' => 0x1D0D7E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-13 CVU' => 0x1D0E7A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 615-14 CVU' => 0x1D0E7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-1 CVU' => 0x150979 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-2 CVU' => 0x170A79 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-3 CVU' => 0x180B76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-4 CVU' => 0x190C76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-5 CVU' => 0x1A0C75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-6 CVU' => 0x1B0C76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-7 CVU' => 0x1B0B75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-8 CVU' => 0x0F0671 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-9 CVU' => 0x110770 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-10 CVU' => 0x14096F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-11 CVU' => 0x14096D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-12 CVU' => 0x150A6E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-13 CVU' => 0x16096F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 620-14 CVU' => 0x16096E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-1 CVU' => 0x1412A5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-2 CVU' => 0x17169E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-3 CVU' => 0x191A97 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-4 CVU' => 0x1A1E90 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-5 CVU' => 0x1A2289 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-6 CVU' => 0x192483 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-7 CVU' => 0x182680 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-8 CVU' => 0x120E9A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-9 CVU' => 0x141294 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-10 CVU' => 0x16168E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-11 CVU' => 0x161987 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-12 CVU' => 0x161D80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-13 CVU' => 0x161F7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 625-14 CVU' => 0x152078 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-1 CVU' => 0x0D0C8F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-2 CVU' => 0x100F8B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-3 CVU' => 0x111384 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-4 CVU' => 0x12167F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-5 CVU' => 0x111979 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-6 CVU' => 0x111B76 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-7 CVU' => 0x111C71 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-8 CVU' => 0x0D0B84 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-9 CVU' => 0x0E0E7F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-10 CVU' => 0x0F1179 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-11 CVU' => 0x0F1475 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-12 CVU' => 0x0F1670 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-13 CVU' => 0x10186D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 630-14 CVU' => 0x0F196C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-1 CVU' => 0x0B097D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-2 CVU' => 0x0D0A7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-3 CVU' => 0x0F0D77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-4 CVU' => 0x0F0F72 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-5 CVU' => 0x0F126F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-6 CVU' => 0x0F136A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-7 CVU' => 0x0E1469 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-8 CVU' => 0x0A076F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-9 CVU' => 0x0B086D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-10 CVU' => 0x0C0A6C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-11 CVU' => 0x0D0C6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-12 CVU' => 0x0D0E67 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-13 CVU' => 0x0D0F64 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 635-14 CVU' => 0x0C1062 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-1 CVU' => 0x0300EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-2 CVU' => 0x0300DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-3 CVU' => 0x0200CF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-4 CVU' => 0x0200BE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-5 CVU' => 0x02009C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-6 CVU' => 0x020185 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-7 CVU' => 0x020168 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-8 CVU' => 0x0300E7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-9 CVU' => 0x0200D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-10 CVU' => 0x0200C8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-11 CVU' => 0x0200AD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-12 CVU' => 0x020093 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-13 CVU' => 0x02017A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 640-14 CVU' => 0x020163 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-1 CVU' => 0x0600E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-2 CVU' => 0x0D00D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-3 CVU' => 0x0B00CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-4 CVU' => 0x0A02B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-5 CVU' => 0x0B02A3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-6 CVU' => 0x0E0291 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-7 CVU' => 0x0B017D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-8 CVU' => 0x0802E4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-9 CVU' => 0x0B03D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-10 CVU' => 0x0C02CA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-11 CVU' => 0x0D03B7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-12 CVU' => 0x0E04A2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-13 CVU' => 0x0F0591 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 645-14 CVU' => 0x0B027F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-1 CVU' => 0x0502E4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-2 CVU' => 0x0808D2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-3 CVU' => 0x0707C5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-4 CVU' => 0x0508B1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-5 CVU' => 0x05099F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-6 CVU' => 0x080B8B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-7 CVU' => 0x09097A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-8 CVU' => 0x0204E2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-9 CVU' => 0xFE09CC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-10 CVU' => 0xFE08C0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-11 CVU' => 0xFD07AE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-12 CVU' => 0xFD059E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-13 CVU' => 0xFB0888 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 650-14 CVU' => 0xFC0A75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-1 CVU' => 0x01FFE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-2 CVU' => 0xFEFBD2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-3 CVU' => 0xFFFCC6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-4 CVU' => 0x00FCB4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-5 CVU' => 0x00FBA2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-6 CVU' => 0xFFF990 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-7 CVU' => 0xFEFB7B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-8 CVU' => 0x03FFE4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-9 CVU' => 0x07FAD6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-10 CVU' => 0x0AFBC7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-11 CVU' => 0x07FCB8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-12 CVU' => 0x07FCA6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-13 CVU' => 0x08FA96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 655-14 CVU' => 0x06FA80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-1 CVU' => 0x07FF6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-2 CVU' => 0x09FE68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-3 CVU' => 0x0BFE66 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-4 CVU' => 0x0A0263 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-5 CVU' => 0x0B0162 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-6 CVU' => 0x0B0162 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-7 CVU' => 0x0D0262 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-8 CVU' => 0x0A0067 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-9 CVU' => 0x090266 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-10 CVU' => 0x0A0362 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-11 CVU' => 0x0B0361 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-12 CVU' => 0x0B0361 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-13 CVU' => 0x0B035F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 660-14 CVU' => 0x0D0460 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-1 CVU' => 0x080366 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-2 CVU' => 0x0B0562 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-3 CVU' => 0x0C055F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-4 CVU' => 0x05085C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-5 CVU' => 0x07085B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-6 CVU' => 0x09085A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-7 CVU' => 0x06095A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-8 CVU' => 0xFF0861 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-9 CVU' => 0xFE0C59 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-10 CVU' => 0xFE0E54 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-11 CVU' => 0xFD055A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-12 CVU' => 0xFC0856 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-13 CVU' => 0xFC0B51 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 665-14 CVU' => 0xFB0658 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-1 CVU' => 0xFFFF62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-2 CVU' => 0xFDFE5C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-3 CVU' => 0xFBFD57 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-4 CVU' => 0x00FD5F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-5 CVU' => 0xFDFB5C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-6 CVU' => 0xFAF959 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-7 CVU' => 0xFEF863 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-8 CVU' => 0x02FE65 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-9 CVU' => 0x02FB60 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-10 CVU' => 0x02F759 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-11 CVU' => 0x05FC63 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-12 CVU' => 0x05F962 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-13 CVU' => 0x05F45D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 670-14 CVU' => 0x08F96A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-1 CVU' => 0x3001A9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-2 CVU' => 0x280196 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-3 CVU' => 0x230089 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-4 CVU' => 0x1DFF80 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-5 CVU' => 0x17FF78 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-6 CVU' => 0x13FF72 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-7 CVU' => 0x0FFF6A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-8 CVU' => 0x2A1D96 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-9 CVU' => 0x241888 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-10 CVU' => 0x1F157F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-11 CVU' => 0x1B1277 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-12 CVU' => 0x170F70 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-13 CVU' => 0x140D68 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 675-14 CVU' => 0x110A63 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-1 CVU' => 0x122971 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-2 CVU' => 0x0F2268 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-3 CVU' => 0x0C1E62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-4 CVU' => 0x0B1A5E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-5 CVU' => 0x0A175B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-6 CVU' => 0x091459 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-7 CVU' => 0x081055 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-8 CVU' => 0xFE2C75 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-9 CVU' => 0xFF256C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-10 CVU' => 0xFF2064 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-11 CVU' => 0xFF1C61 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-12 CVU' => 0xFF1A5E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-13 CVU' => 0xFF165B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 680-14 CVU' => 0xFF1357 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-1 CVU' => 0xE80D5B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-2 CVU' => 0xEC0C58 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-3 CVU' => 0xEF0B55 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-4 CVU' => 0xF10B53 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-5 CVU' => 0xF30A53 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-6 CVU' => 0xF40A51 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-7 CVU' => 0xF7094F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-8 CVU' => 0xE7F47B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-9 CVU' => 0xECF873 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-10 CVU' => 0xEDF972 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-11 CVU' => 0xF2FB69 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-12 CVU' => 0xF3FC66 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-13 CVU' => 0xF5FC62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 685-14 CVU' => 0xF7FE5E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-1 CVU' => 0xFEE075 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-2 CVU' => 0xFDE570 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-3 CVU' => 0xFEE96A ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-4 CVU' => 0xFDED66 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-5 CVU' => 0xFEEF62 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-6 CVU' => 0xFEF15E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-7 CVU' => 0xFEF35C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-8 CVU' => 0x0BDF89 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-9 CVU' => 0x08E580 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-10 CVU' => 0x06EA78 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-11 CVU' => 0x05ED72 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-12 CVU' => 0x04F06D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-13 CVU' => 0x04F269 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 690-14 CVU' => 0x03F462 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-1 CVU' => 0x1CE189 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-2 CVU' => 0x18E67F ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-3 CVU' => 0x15EB77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-4 CVU' => 0x12EE71 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-5 CVU' => 0x0FF06D ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-6 CVU' => 0x0CF268 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-7 CVU' => 0x0AF463 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-8 CVU' => 0x2AF7A7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-9 CVU' => 0x24F896 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-10 CVU' => 0x1FF98B ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-11 CVU' => 0x19FA81 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-12 CVU' => 0x15FB7C ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-13 CVU' => 0x12FB77 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 695-14 CVU' => 0x0DFC6E ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-1 CVU' => 0x0700F5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-2 CVU' => 0x0AFFF4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-3 CVU' => 0x0FFEF4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-4 CVU' => 0x0802F2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-5 CVU' => 0x0C01F2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-6 CVU' => 0x0F01F2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-7 CVU' => 0x1101F1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-8 CVU' => 0x0600ED ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-9 CVU' => 0x09FFEC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-10 CVU' => 0x0EFEEB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-11 CVU' => 0x0702E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-12 CVU' => 0x0B01E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-13 CVU' => 0x0E00E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 700-14 CVU' => 0x0F00E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-1 CVU' => 0x0E04EF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-2 CVU' => 0x1103EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-3 CVU' => 0x1006EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-4 CVU' => 0x0F07EB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-5 CVU' => 0x1207EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-6 CVU' => 0x1407EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-7 CVU' => 0x1607EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-8 CVU' => 0x0A04E7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-9 CVU' => 0x0F03E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-10 CVU' => 0x1105E3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-11 CVU' => 0x0D06E2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-12 CVU' => 0x1006E0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-13 CVU' => 0x1206E0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 705-14 CVU' => 0x1306E0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-1 CVU' => 0x0905EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-2 CVU' => 0x0805EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-3 CVU' => 0x0C08EA ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-4 CVU' => 0x0406EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-5 CVU' => 0x0708E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-6 CVU' => 0x090AE7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-7 CVU' => 0x0B0BE5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-8 CVU' => 0x060CE4 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-9 CVU' => 0x080EE1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-10 CVU' => 0x0410DF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-11 CVU' => 0x0011DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-12 CVU' => 0x0312DB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-13 CVU' => 0x0614D9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 710-14 CVU' => 0x0714D8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-1 CVU' => 0x0204EF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-2 CVU' => 0x0009E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-3 CVU' => 0xFE10DF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-4 CVU' => 0x0003EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-5 CVU' => 0xFF08E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-6 CVU' => 0xFD0CE0 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-7 CVU' => 0xFC0FDB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-8 CVU' => 0xFF01E9 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-9 CVU' => 0xFC0ADD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-10 CVU' => 0xFB04DF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-11 CVU' => 0xFBFEE3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-12 CVU' => 0xFA03DD ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-13 CVU' => 0xF907D7 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 715-14 CVU' => 0xF80AD3 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-1 CVU' => 0x02FFF2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-2 CVU' => 0x00FDEE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-3 CVU' => 0xFCFBE8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-4 CVU' => 0x03FDEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-5 CVU' => 0x01FBEC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-6 CVU' => 0xFFFAE8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-7 CVU' => 0xFEF9E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-8 CVU' => 0x04FAED ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-9 CVU' => 0x00F7E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-10 CVU' => 0x02F6E6 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-11 CVU' => 0x05F6E8 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-12 CVU' => 0x03F5E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-13 CVU' => 0x03F4E5 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 720-14 CVU' => 0x01F3E1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-1 CVU' => 0x04FEF2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-2 CVU' => 0x05FBEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-3 CVU' => 0x06F7EB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-4 CVU' => 0x07FDF2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-5 CVU' => 0x08FBEF ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-6 CVU' => 0x08F8ED ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-7 CVU' => 0x09F7EB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-8 CVU' => 0x0BFDF2 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-9 CVU' => 0x09F7EB ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-10 CVU' => 0x0EF9EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-11 CVU' => 0x0FFCF1 ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-12 CVU' => 0x10F9EE ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-13 CVU' => 0x10F7EC ,
'PANTONE Hexachrome - Uncoated -- PANTONE H 725-14 CVU' => 0x10F5EA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Yellow  0131 CVU' => 0x27FAF1 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Red 0331 CVU' => 0x0821CB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Magenta 0521 CVU' => 0xF71DCB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Violet 0631 CVU' => 0xE814B5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Blue 0821 CVU' => 0xEAE6C5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Green 0921 CVU' => 0x01DFD8 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE Black 0961 CVU' => 0x0501A3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9140 CVU' => 0x10FFF2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9020 CVU' => 0x12FDF1 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9021 CVU' => 0x0504ED ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9022 CVU' => 0x0403ED ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9023 CVU' => 0x0103EC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9040 CVU' => 0x02FDEF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9041 CVU' => 0x05FDF0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9042 CVU' => 0x04FFEF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9043 CVU' => 0x0500EF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9060 CVU' => 0x08FFF3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9061 CVU' => 0x0700F2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9062 CVU' => 0x05FFF2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9063 CVU' => 0x08FEF2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9080 CVU' => 0x0700E9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9100 CVU' => 0x07FFEC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9101 CVU' => 0x07FFE5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9081 CVU' => 0x0700E3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9102 CVU' => 0x06FFDA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9103 CVU' => 0x05FFD4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9082 CVU' => 0x0801DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9083 CVU' => 0x0701D5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9141 CVU' => 0x13FEF2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9142 CVU' => 0x14FFE8 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9143 CVU' => 0x1000E1 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9120 CVU' => 0x15FDF3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9121 CVU' => 0x19FCF2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9122 CVU' => 0x16FDE7 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9123 CVU' => 0x12FEDB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9180 CVU' => 0x0D03EE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9181 CVU' => 0x0F04ED ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9182 CVU' => 0x0F03E5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9160 CVU' => 0x1301EE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9161 CVU' => 0x1201E4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9162 CVU' => 0x0E01E0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9163 CVU' => 0x0C01DB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9200 CVU' => 0x1005EB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9201 CVU' => 0x1106E9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9220 CVU' => 0x0B04EC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9221 CVU' => 0x0B05E5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9183 CVU' => 0x0C03E2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9202 CVU' => 0x0E04E3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9203 CVU' => 0x0E04D7 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9240 CVU' => 0x0805EC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9241 CVU' => 0x0906E7 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9260 CVU' => 0x080AE7 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9242 CVU' => 0x0906DF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9222 CVU' => 0x0B05DD ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9223 CVU' => 0x0A04D9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9243 CVU' => 0x0906D9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9280 CVU' => 0x0506ED ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9281 CVU' => 0x0508E6 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9282 CVU' => 0x0508E2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9283 CVU' => 0x0507DE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9261 CVU' => 0x090BDD ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9262 CVU' => 0x0809DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9263 CVU' => 0x0708D4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9300 CVU' => 0x0309E9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9301 CVU' => 0x030AE1 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9320 CVU' => 0x0206EB ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9302 CVU' => 0x030BD8 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9303 CVU' => 0x0409D4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9321 CVU' => 0x0207E6 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9322 CVU' => 0x0207E0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9340 CVU' => 0x0004E8 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9341 CVU' => 0x0005E4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9342 CVU' => 0xFF05DE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9343 CVU' => 0xFF06DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9360 CVU' => 0xFA06DE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9361 CVU' => 0xF907D5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9323 CVU' => 0x0307D7 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9400 CVU' => 0xFBFBE0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9380 CVU' => 0xFC00E2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9381 CVU' => 0xF901D4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9382 CVU' => 0xF701D0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9383 CVU' => 0xF901CA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9362 CVU' => 0xFA06CE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9363 CVU' => 0xFB06CA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9401 CVU' => 0xF8FADA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9402 CVU' => 0xF8FBD4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9403 CVU' => 0xFAFBD0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9420 CVU' => 0xF6F6D5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9421 CVU' => 0xF8F8D3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9422 CVU' => 0xFAF9CF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9423 CVU' => 0xFBFAC6 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9460 CVU' => 0xFEF7E9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9440 CVU' => 0xF9F5DE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9461 CVU' => 0xFBF3DC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9441 CVU' => 0xF6F3DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9442 CVU' => 0xF7F5D2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9443 CVU' => 0xFAF6CD ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9462 CVU' => 0xFBF3D3 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9480 CVU' => 0xFFF2E5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9481 CVU' => 0xFDF2E4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9482 CVU' => 0xFEF2DD ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9500 CVU' => 0xFFEEE4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9501 CVU' => 0xFFF0DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9483 CVU' => 0x00F7D5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9463 CVU' => 0xFDF6D4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9541 CVU' => 0x06F8E9 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9520 CVU' => 0x04F8EF ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9521 CVU' => 0x04F7EA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9522 CVU' => 0x04F8E5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9523 CVU' => 0x04F9DE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9502 CVU' => 0x00F3D4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9503 CVU' => 0x02F6D0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9540 CVU' => 0x07F8EE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9560 CVU' => 0x09F8EC ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9561 CVU' => 0x0BF6E5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9562 CVU' => 0x0AF7E0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9563 CVU' => 0x09FAD5 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9542 CVU' => 0x06FBE2 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9543 CVU' => 0x06F9DA ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9600 CVU' => 0x10FCF0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9580 CVU' => 0x09FCF0 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9581 CVU' => 0x0AFCED ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9582 CVU' => 0x0AFDE1 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9602 CVU' => 0x10FCDE ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9603 CVU' => 0x0EFDD4 ,
'PANTONE Pastel Colors - Uncoated -- PANTONE 9583 CVU' => 0x0BFDDA ,
'PANTONE Pastel Colors - Coated -- PANTONE Yellow  0131 CVC' => 0x1FFBEE ,
'PANTONE Pastel Colors - Coated -- PANTONE Red 0331 CVC' => 0x061DCE ,
'PANTONE Pastel Colors - Coated -- PANTONE Magenta 0521 CVC' => 0xF819CE ,
'PANTONE Pastel Colors - Coated -- PANTONE Violet 0631 CVC' => 0xEA14BC ,
'PANTONE Pastel Colors - Coated -- PANTONE Blue 0821 CVC' => 0xEDE8CA ,
'PANTONE Pastel Colors - Coated -- PANTONE Green 0921 CVC' => 0x01E7DD ,
'PANTONE Pastel Colors - Coated -- PANTONE Black 0961 CVC' => 0x0702AA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9140 CVC' => 0x0AFFF0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9020 CVC' => 0x0DFEEF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9021 CVC' => 0x0303EE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9022 CVC' => 0x0203ED ,
'PANTONE Pastel Colors - Coated -- PANTONE 9023 CVC' => 0x0102ED ,
'PANTONE Pastel Colors - Coated -- PANTONE 9040 CVC' => 0x01FEEE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9041 CVC' => 0x03FEEE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9042 CVC' => 0x0200EE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9043 CVC' => 0x0301EF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9060 CVC' => 0x0500F1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9061 CVC' => 0x0401F0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9062 CVC' => 0x0300F0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9063 CVC' => 0x0300F0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9080 CVC' => 0x0501E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9100 CVC' => 0x0500EA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9101 CVC' => 0x0400E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9081 CVC' => 0x0401E3 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9102 CVC' => 0x04FFE1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9103 CVC' => 0x03FFDB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9082 CVC' => 0x0501E0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9083 CVC' => 0x0501D9 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9141 CVC' => 0x0CFFF0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9142 CVC' => 0x0BFFEC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9143 CVC' => 0x0C00E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9120 CVC' => 0x10FDF0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9121 CVC' => 0x15FCF0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9122 CVC' => 0x13FDE5 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9123 CVC' => 0x11FEDC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9180 CVC' => 0x0902ED ,
'PANTONE Pastel Colors - Coated -- PANTONE 9181 CVC' => 0x0A03EC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9182 CVC' => 0x0A02E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9160 CVC' => 0x0E01ED ,
'PANTONE Pastel Colors - Coated -- PANTONE 9161 CVC' => 0x0D01E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9162 CVC' => 0x0A01E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9163 CVC' => 0x0901E1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9200 CVC' => 0x0B03EB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9201 CVC' => 0x0C04EA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9220 CVC' => 0x0904EA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9221 CVC' => 0x0904E5 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9183 CVC' => 0x0902E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9202 CVC' => 0x0B03E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9203 CVC' => 0x0B03DD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9240 CVC' => 0x0504EC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9241 CVC' => 0x0505E8 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9260 CVC' => 0x0508E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9242 CVC' => 0x0706DF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9222 CVC' => 0x0905DC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9223 CVC' => 0x0804DA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9243 CVC' => 0x0706D8 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9280 CVC' => 0x0304EC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9281 CVC' => 0x0304EC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9282 CVC' => 0x0306E6 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9283 CVC' => 0x0305E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9261 CVC' => 0x0608E1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9262 CVC' => 0x0608DD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9263 CVC' => 0x0607D9 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9300 CVC' => 0x0207E9 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9301 CVC' => 0x0208E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9320 CVC' => 0x0008E6 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9302 CVC' => 0x0209DD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9303 CVC' => 0x0208D9 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9321 CVC' => 0x0009DF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9322 CVC' => 0x0008DC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9340 CVC' => 0xFE05E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9341 CVC' => 0xFE05E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9342 CVC' => 0xFE06DC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9343 CVC' => 0xFD06D7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9360 CVC' => 0xF906DE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9361 CVC' => 0xF906DA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9323 CVC' => 0x0107D8 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9400 CVC' => 0xFCFDE4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9380 CVC' => 0xFC01E5 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9381 CVC' => 0xFA01DD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9382 CVC' => 0xF801D7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9383 CVC' => 0xFA01D5 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9362 CVC' => 0xF906D1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9363 CVC' => 0xFB06CD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9401 CVC' => 0xF9FDE0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9402 CVC' => 0xF9FCDA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9403 CVC' => 0xFAFCD8 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9420 CVC' => 0xF9FAE0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9421 CVC' => 0xF9FBDB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9422 CVC' => 0xFBFBD7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9423 CVC' => 0xFCFCD2 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9460 CVC' => 0xFDF9E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9440 CVC' => 0xFBF9E2 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9461 CVC' => 0xFAF4DB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9441 CVC' => 0xF9F7DF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9442 CVC' => 0xF9F8DB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9443 CVC' => 0xFAF8D4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9462 CVC' => 0xFAF5D5 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9480 CVC' => 0xFEF7E7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9481 CVC' => 0xFEF6E6 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9482 CVC' => 0xFEF6E0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9500 CVC' => 0xFFF3E4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9501 CVC' => 0xFFF3DC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9483 CVC' => 0x00F9DB ,
'PANTONE Pastel Colors - Coated -- PANTONE 9463 CVC' => 0xFDF7D3 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9541 CVC' => 0x04FBEA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9520 CVC' => 0x02F9EC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9521 CVC' => 0x02FAEA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9522 CVC' => 0x03FAE4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9523 CVC' => 0x03FADE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9502 CVC' => 0x00F5D6 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9503 CVC' => 0x01F8D4 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9540 CVC' => 0x04FBEE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9560 CVC' => 0x07FBEE ,
'PANTONE Pastel Colors - Coated -- PANTONE 9561 CVC' => 0x08FAE7 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9562 CVC' => 0x08FBE3 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9563 CVC' => 0x08FCDC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9542 CVC' => 0x05FCE3 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9543 CVC' => 0x05FBDD ,
'PANTONE Pastel Colors - Coated -- PANTONE 9600 CVC' => 0x0FFCEC ,
'PANTONE Pastel Colors - Coated -- PANTONE 9580 CVC' => 0x08FDEF ,
'PANTONE Pastel Colors - Coated -- PANTONE 9581 CVC' => 0x0AFDEA ,
'PANTONE Pastel Colors - Coated -- PANTONE 9582 CVC' => 0x09FEE0 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9602 CVC' => 0x0DFDE1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9603 CVC' => 0x0DFDE1 ,
'PANTONE Pastel Colors - Coated -- PANTONE 9583 CVC' => 0x0AFDDC ,
);
}
