package Geo::Postcodes::NO;

use Geo::Postcodes;
use base qw(Geo::Postcodes);

my @ISA = ('Geo::Postcodes', 'Exporter');

use strict;
use warnings;

require Exporter;

my %EXPORT_TAGS = ( 'all' => [ qw(legal valid postnr2poststed borough_no_of kommunenr2kommune
  postnr2kommune postnr2fylke kommunenr2fylke postnr2kategori) ] );

my @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

my @EXPORT = qw( );

our $VERSION = '0.01';

# Preloaded methods go here.

## Private Variables ############################################################

my (%poststed, %postkommune, %kommunenavn, %kategori);

my @fylker = (undef,        # 00 
  "STFOLD",                # 01
  "AKERSHUS",               # 02
  "OSLO",                   # 03
  "HEDMARK",                # 04
  "OPPLAND",                # 05
  "BUSKERUD",               # 06
  "VESTFOLD",               # 07
  "TELEMARK",               # 08
  "AUST-AGDER",             # 09
  "VEST-AGDER",             # 10
  "ROGALAND",               # 11
  "HORDALAND",              # 12
  undef,                    # 13
  "SOGN OG FJORDANE",       # 14
  "MRE OG ROMSDAL",        # 15
  "SR-TRNDELAG",          # 16
  "NORD-TRNDELAG",         # 17
  "NORDLAND",               # 18
  "TROMS",                  # 19
  "FINNMARK",               # 20
  "SVALBARD *",             # 21
  "JAN MAYEN *",            # 22
  "KONTINENTALSOKKELEN *"); # 23

my %kategorinavn;

$kategorinavn{B} = 'Bde gateadresser og postbokser';
$kategorinavn{F} = 'Flere bruksomrder (felles)';
$kategorinavn{G} = 'Gateadresser';
$kategorinavn{K} = 'Kunde med eget postnummer';
$kategorinavn{P} = 'Postbokser';
$kategorinavn{S} = 'Serviceboks';

## OO Methods ###################################################################

my %borough_number_of;

sub new
{
  my $class      = shift;
  my $postnr     = shift;

  return undef unless valid($postnr);

  my $self = bless \(my $dummy), $class;

  $Geo::Postcodes::postcode_of  {$self} = $postnr;
  $Geo::Postcodes::location_of  {$self} = location_of($postnr);
  $Geo::Postcodes::borough_of   {$self} = borough_of($postnr);
  $Geo::Postcodes::county_of    {$self} = county_of($postnr);
  $Geo::Postcodes::type_of      {$self} = type_of($postnr);

  $borough_number_of{$self} = borough_number_of($postnr);

  # my $super = $class->can("SUPER::new");
  # goto &$super($class, $postnr, $self) if $super;
  # These two lines should make the 5 Geo-lines superfluous.

  return $self;
}

sub DESTROY {
  my $dead_body = $_[0];

  delete $Geo::Postcodes::postcode_of  {$dead_body};
  delete $Geo::Postcodes::location_of  {$dead_body};
  delete $Geo::Postcodes::borough_of   {$dead_body};
  delete $Geo::Postcodes::county_of    {$dead_body};
  delete $Geo::Postcodes::type_of      {$dead_body};

  delete $borough_number_of{$dead_body};
  ## my $super = $dead_body->can("SUPER::DESTROY");
  ## goto &$super if $super;
}

sub borough_no
{
  my $self = shift;
  return $borough_number_of{$self};
}

## Global Procedures ############################################################

sub legal # Is it a legal code, i.e. something that follows the syntax rule.
{
  my $postcode = shift;
  return 0 unless defined $postcode;
  return 0 unless $postcode =~ /^\d\d\d\d$/;
  return 1;
}

sub valid # Is the code in actual use.
{
  my $postcode = shift;
  return 0 unless legal($postcode);

  return 1 if exists $poststed{$postcode};
  return 0;
}

sub location_of
{
  my $postnr = shift;
  return unless defined $postnr;

  return $poststed{$postnr} if exists $poststed{$postnr};
  return;
}

sub borough_number_of
{
  my $postnr = shift;
  return unless defined $postnr;

  exists $postkommune{$postnr} ? $postkommune{$postnr} : undef;
}

sub kommunenr2kommune
{
  my $kommunenr = shift;
  return unless defined $kommunenr;

  exists $kommunenavn{$kommunenr} ? $kommunenavn{$kommunenr} : undef;
}

sub borough_of
{
  my $postnr    = shift;
  return unless defined $postnr;

  my $kommunenr = borough_number_of($postnr);
  return unless $kommunenr; # Ulovlig kommunenummer.

  return kommunenr2kommune($kommunenr);
}

sub county_of
{
  my $postnr    = shift;
  return unless defined $postnr;

  my $kommunenr = borough_number_of($postnr);
  return unless $kommunenr; # Ulovlig kommunenummer.

  return kommunenr2fylke($kommunenr);
}

sub kommunenr2fylke
{
  my $kommunenr = shift;
  return unless defined $kommunenr;
  return unless exists $kommunenavn{$kommunenr};

  $kommunenr =~ /(\d\d)/; # De to frste sifrene.
  my $fylkenr = $1;

  exists $fylker[$fylkenr] ? $fylker[$fylkenr] : undef;
}

sub type_of
{
  my $postnr    = shift;
  return unless defined $postnr;
  return unless exists $kategori{$postnr};
  
  my $kategorikode = $kategori{$postnr};

  return $kategorinavn{$kategorikode} if exists $kategorinavn{$kategorikode};
  return;
}

## bin/mkpostalinfo begin
## This data structure was auto generated on Mon Jul 10 11:32:40 2006. Do NOT edit it!

$postkommune{'0001'} = '0301'; $kategori{'0001'} = 'K'; $poststed{'0001'} = 'OSLO';
$postkommune{'0010'} = '0301'; $kategori{'0010'} = 'F'; $poststed{'0010'} = 'OSLO';
$postkommune{'0014'} = '0301'; $kategori{'0014'} = 'K'; $poststed{'0014'} = 'OSLO';
$postkommune{'0015'} = '0301'; $kategori{'0015'} = 'K'; $poststed{'0015'} = 'OSLO';
$postkommune{'0016'} = '0301'; $kategori{'0016'} = 'K'; $poststed{'0016'} = 'OSLO';
$postkommune{'0017'} = '0301'; $kategori{'0017'} = 'K'; $poststed{'0017'} = 'OSLO';
$postkommune{'0018'} = '0301'; $kategori{'0018'} = 'K'; $poststed{'0018'} = 'OSLO';
$postkommune{'0020'} = '0301'; $kategori{'0020'} = 'K'; $poststed{'0020'} = 'OSLO';
$postkommune{'0021'} = '0301'; $kategori{'0021'} = 'K'; $poststed{'0021'} = 'OSLO';
$postkommune{'0022'} = '0301'; $kategori{'0022'} = 'K'; $poststed{'0022'} = 'OSLO';
$postkommune{'0023'} = '0301'; $kategori{'0023'} = 'F'; $poststed{'0023'} = 'OSLO';
$postkommune{'0024'} = '0301'; $kategori{'0024'} = 'K'; $poststed{'0024'} = 'OSLO';
$postkommune{'0025'} = '0301'; $kategori{'0025'} = 'K'; $poststed{'0025'} = 'OSLO';
$postkommune{'0026'} = '0301'; $kategori{'0026'} = 'F'; $poststed{'0026'} = 'OSLO';
$postkommune{'0027'} = '0301'; $kategori{'0027'} = 'F'; $poststed{'0027'} = 'OSLO';
$postkommune{'0028'} = '0301'; $kategori{'0028'} = 'P'; $poststed{'0028'} = 'OSLO';
$postkommune{'0030'} = '0301'; $kategori{'0030'} = 'P'; $poststed{'0030'} = 'OSLO';
$postkommune{'0031'} = '0301'; $kategori{'0031'} = 'P'; $poststed{'0031'} = 'OSLO';
$postkommune{'0032'} = '0301'; $kategori{'0032'} = 'P'; $poststed{'0032'} = 'OSLO';
$postkommune{'0033'} = '0301'; $kategori{'0033'} = 'P'; $poststed{'0033'} = 'OSLO';
$postkommune{'0034'} = '0301'; $kategori{'0034'} = 'P'; $poststed{'0034'} = 'OSLO';
$postkommune{'0037'} = '0301'; $kategori{'0037'} = 'K'; $poststed{'0037'} = 'OSLO';
$postkommune{'0040'} = '0301'; $kategori{'0040'} = 'K'; $poststed{'0040'} = 'OSLO';
$postkommune{'0041'} = '0301'; $kategori{'0041'} = 'K'; $poststed{'0041'} = 'OSLO';
$postkommune{'0042'} = '0301'; $kategori{'0042'} = 'K'; $poststed{'0042'} = 'OSLO';
$postkommune{'0043'} = '0301'; $kategori{'0043'} = 'K'; $poststed{'0043'} = 'OSLO';
$postkommune{'0045'} = '0301'; $kategori{'0045'} = 'K'; $poststed{'0045'} = 'OSLO';
$postkommune{'0046'} = '0301'; $kategori{'0046'} = 'K'; $poststed{'0046'} = 'OSLO';
$postkommune{'0047'} = '0301'; $kategori{'0047'} = 'K'; $poststed{'0047'} = 'OSLO';
$postkommune{'0048'} = '0301'; $kategori{'0048'} = 'K'; $poststed{'0048'} = 'OSLO';
$postkommune{'0050'} = '0301'; $kategori{'0050'} = 'G'; $poststed{'0050'} = 'OSLO';
$postkommune{'0051'} = '0301'; $kategori{'0051'} = 'P'; $poststed{'0051'} = 'OSLO';
$postkommune{'0055'} = '0301'; $kategori{'0055'} = 'K'; $poststed{'0055'} = 'OSLO';
$postkommune{'0080'} = '0301'; $kategori{'0080'} = 'K'; $poststed{'0080'} = 'OSLO';
$postkommune{'0081'} = '0301'; $kategori{'0081'} = 'K'; $poststed{'0081'} = 'OSLO';
$postkommune{'0101'} = '0301'; $kategori{'0101'} = 'P'; $poststed{'0101'} = 'OSLO';
$postkommune{'0102'} = '0301'; $kategori{'0102'} = 'P'; $poststed{'0102'} = 'OSLO';
$postkommune{'0103'} = '0301'; $kategori{'0103'} = 'P'; $poststed{'0103'} = 'OSLO';
$postkommune{'0104'} = '0301'; $kategori{'0104'} = 'P'; $poststed{'0104'} = 'OSLO';
$postkommune{'0105'} = '0301'; $kategori{'0105'} = 'P'; $poststed{'0105'} = 'OSLO';
$postkommune{'0106'} = '0301'; $kategori{'0106'} = 'P'; $poststed{'0106'} = 'OSLO';
$postkommune{'0107'} = '0301'; $kategori{'0107'} = 'P'; $poststed{'0107'} = 'OSLO';
$postkommune{'0110'} = '0301'; $kategori{'0110'} = 'P'; $poststed{'0110'} = 'OSLO';
$postkommune{'0111'} = '0301'; $kategori{'0111'} = 'P'; $poststed{'0111'} = 'OSLO';
$postkommune{'0112'} = '0301'; $kategori{'0112'} = 'P'; $poststed{'0112'} = 'OSLO';
$postkommune{'0113'} = '0301'; $kategori{'0113'} = 'P'; $poststed{'0113'} = 'OSLO';
$postkommune{'0114'} = '0301'; $kategori{'0114'} = 'P'; $poststed{'0114'} = 'OSLO';
$postkommune{'0115'} = '0301'; $kategori{'0115'} = 'P'; $poststed{'0115'} = 'OSLO';
$postkommune{'0116'} = '0301'; $kategori{'0116'} = 'P'; $poststed{'0116'} = 'OSLO';
$postkommune{'0117'} = '0301'; $kategori{'0117'} = 'P'; $poststed{'0117'} = 'OSLO';
$postkommune{'0118'} = '0301'; $kategori{'0118'} = 'P'; $poststed{'0118'} = 'OSLO';
$postkommune{'0119'} = '0301'; $kategori{'0119'} = 'P'; $poststed{'0119'} = 'OSLO';
$postkommune{'0120'} = '0301'; $kategori{'0120'} = 'P'; $poststed{'0120'} = 'OSLO';
$postkommune{'0121'} = '0301'; $kategori{'0121'} = 'P'; $poststed{'0121'} = 'OSLO';
$postkommune{'0122'} = '0301'; $kategori{'0122'} = 'P'; $poststed{'0122'} = 'OSLO';
$postkommune{'0123'} = '0301'; $kategori{'0123'} = 'P'; $poststed{'0123'} = 'OSLO';
$postkommune{'0124'} = '0301'; $kategori{'0124'} = 'P'; $poststed{'0124'} = 'OSLO';
$postkommune{'0125'} = '0301'; $kategori{'0125'} = 'P'; $poststed{'0125'} = 'OSLO';
$postkommune{'0128'} = '0301'; $kategori{'0128'} = 'K'; $poststed{'0128'} = 'OSLO';
$postkommune{'0129'} = '0301'; $kategori{'0129'} = 'P'; $poststed{'0129'} = 'OSLO';
$postkommune{'0130'} = '0301'; $kategori{'0130'} = 'P'; $poststed{'0130'} = 'OSLO';
$postkommune{'0131'} = '0301'; $kategori{'0131'} = 'P'; $poststed{'0131'} = 'OSLO';
$postkommune{'0133'} = '0301'; $kategori{'0133'} = 'P'; $poststed{'0133'} = 'OSLO';
$postkommune{'0134'} = '0301'; $kategori{'0134'} = 'P'; $poststed{'0134'} = 'OSLO';
$postkommune{'0135'} = '0301'; $kategori{'0135'} = 'P'; $poststed{'0135'} = 'OSLO';
$postkommune{'0136'} = '0301'; $kategori{'0136'} = 'P'; $poststed{'0136'} = 'OSLO';
$postkommune{'0137'} = '0301'; $kategori{'0137'} = 'P'; $poststed{'0137'} = 'OSLO';
$postkommune{'0138'} = '0301'; $kategori{'0138'} = 'P'; $poststed{'0138'} = 'OSLO';
$postkommune{'0139'} = '0301'; $kategori{'0139'} = 'G'; $poststed{'0139'} = 'OSLO';
$postkommune{'0150'} = '0301'; $kategori{'0150'} = 'G'; $poststed{'0150'} = 'OSLO';
$postkommune{'0151'} = '0301'; $kategori{'0151'} = 'G'; $poststed{'0151'} = 'OSLO';
$postkommune{'0152'} = '0301'; $kategori{'0152'} = 'G'; $poststed{'0152'} = 'OSLO';
$postkommune{'0153'} = '0301'; $kategori{'0153'} = 'G'; $poststed{'0153'} = 'OSLO';
$postkommune{'0154'} = '0301'; $kategori{'0154'} = 'G'; $poststed{'0154'} = 'OSLO';
$postkommune{'0155'} = '0301'; $kategori{'0155'} = 'G'; $poststed{'0155'} = 'OSLO';
$postkommune{'0157'} = '0301'; $kategori{'0157'} = 'G'; $poststed{'0157'} = 'OSLO';
$postkommune{'0158'} = '0301'; $kategori{'0158'} = 'G'; $poststed{'0158'} = 'OSLO';
$postkommune{'0159'} = '0301'; $kategori{'0159'} = 'G'; $poststed{'0159'} = 'OSLO';
$postkommune{'0160'} = '0301'; $kategori{'0160'} = 'G'; $poststed{'0160'} = 'OSLO';
$postkommune{'0161'} = '0301'; $kategori{'0161'} = 'G'; $poststed{'0161'} = 'OSLO';
$postkommune{'0162'} = '0301'; $kategori{'0162'} = 'G'; $poststed{'0162'} = 'OSLO';
$postkommune{'0164'} = '0301'; $kategori{'0164'} = 'G'; $poststed{'0164'} = 'OSLO';
$postkommune{'0165'} = '0301'; $kategori{'0165'} = 'G'; $poststed{'0165'} = 'OSLO';
$postkommune{'0166'} = '0301'; $kategori{'0166'} = 'G'; $poststed{'0166'} = 'OSLO';
$postkommune{'0167'} = '0301'; $kategori{'0167'} = 'G'; $poststed{'0167'} = 'OSLO';
$postkommune{'0168'} = '0301'; $kategori{'0168'} = 'G'; $poststed{'0168'} = 'OSLO';
$postkommune{'0169'} = '0301'; $kategori{'0169'} = 'G'; $poststed{'0169'} = 'OSLO';
$postkommune{'0170'} = '0301'; $kategori{'0170'} = 'G'; $poststed{'0170'} = 'OSLO';
$postkommune{'0171'} = '0301'; $kategori{'0171'} = 'G'; $poststed{'0171'} = 'OSLO';
$postkommune{'0172'} = '0301'; $kategori{'0172'} = 'G'; $poststed{'0172'} = 'OSLO';
$postkommune{'0173'} = '0301'; $kategori{'0173'} = 'G'; $poststed{'0173'} = 'OSLO';
$postkommune{'0174'} = '0301'; $kategori{'0174'} = 'G'; $poststed{'0174'} = 'OSLO';
$postkommune{'0175'} = '0301'; $kategori{'0175'} = 'G'; $poststed{'0175'} = 'OSLO';
$postkommune{'0176'} = '0301'; $kategori{'0176'} = 'G'; $poststed{'0176'} = 'OSLO';
$postkommune{'0177'} = '0301'; $kategori{'0177'} = 'G'; $poststed{'0177'} = 'OSLO';
$postkommune{'0178'} = '0301'; $kategori{'0178'} = 'G'; $poststed{'0178'} = 'OSLO';
$postkommune{'0179'} = '0301'; $kategori{'0179'} = 'G'; $poststed{'0179'} = 'OSLO';
$postkommune{'0180'} = '0301'; $kategori{'0180'} = 'G'; $poststed{'0180'} = 'OSLO';
$postkommune{'0181'} = '0301'; $kategori{'0181'} = 'G'; $poststed{'0181'} = 'OSLO';
$postkommune{'0182'} = '0301'; $kategori{'0182'} = 'G'; $poststed{'0182'} = 'OSLO';
$postkommune{'0183'} = '0301'; $kategori{'0183'} = 'G'; $poststed{'0183'} = 'OSLO';
$postkommune{'0184'} = '0301'; $kategori{'0184'} = 'G'; $poststed{'0184'} = 'OSLO';
$postkommune{'0185'} = '0301'; $kategori{'0185'} = 'G'; $poststed{'0185'} = 'OSLO';
$postkommune{'0186'} = '0301'; $kategori{'0186'} = 'G'; $poststed{'0186'} = 'OSLO';
$postkommune{'0187'} = '0301'; $kategori{'0187'} = 'G'; $poststed{'0187'} = 'OSLO';
$postkommune{'0188'} = '0301'; $kategori{'0188'} = 'G'; $poststed{'0188'} = 'OSLO';
$postkommune{'0190'} = '0301'; $kategori{'0190'} = 'G'; $poststed{'0190'} = 'OSLO';
$postkommune{'0191'} = '0301'; $kategori{'0191'} = 'G'; $poststed{'0191'} = 'OSLO';
$postkommune{'0192'} = '0301'; $kategori{'0192'} = 'G'; $poststed{'0192'} = 'OSLO';
$postkommune{'0193'} = '0301'; $kategori{'0193'} = 'G'; $poststed{'0193'} = 'OSLO';
$postkommune{'0196'} = '0301'; $kategori{'0196'} = 'G'; $poststed{'0196'} = 'OSLO';
$postkommune{'0198'} = '0301'; $kategori{'0198'} = 'G'; $poststed{'0198'} = 'OSLO';
$postkommune{'0201'} = '0301'; $kategori{'0201'} = 'P'; $poststed{'0201'} = 'OSLO';
$postkommune{'0202'} = '0301'; $kategori{'0202'} = 'P'; $poststed{'0202'} = 'OSLO';
$postkommune{'0203'} = '0301'; $kategori{'0203'} = 'P'; $poststed{'0203'} = 'OSLO';
$postkommune{'0204'} = '0301'; $kategori{'0204'} = 'P'; $poststed{'0204'} = 'OSLO';
$postkommune{'0207'} = '0301'; $kategori{'0207'} = 'P'; $poststed{'0207'} = 'OSLO';
$postkommune{'0208'} = '0301'; $kategori{'0208'} = 'P'; $poststed{'0208'} = 'OSLO';
$postkommune{'0211'} = '0301'; $kategori{'0211'} = 'P'; $poststed{'0211'} = 'OSLO';
$postkommune{'0212'} = '0301'; $kategori{'0212'} = 'P'; $poststed{'0212'} = 'OSLO';
$postkommune{'0213'} = '0301'; $kategori{'0213'} = 'P'; $poststed{'0213'} = 'OSLO';
$postkommune{'0214'} = '0301'; $kategori{'0214'} = 'P'; $poststed{'0214'} = 'OSLO';
$postkommune{'0215'} = '0301'; $kategori{'0215'} = 'P'; $poststed{'0215'} = 'OSLO';
$postkommune{'0216'} = '0301'; $kategori{'0216'} = 'P'; $poststed{'0216'} = 'OSLO';
$postkommune{'0218'} = '0301'; $kategori{'0218'} = 'P'; $poststed{'0218'} = 'OSLO';
$postkommune{'0230'} = '0301'; $kategori{'0230'} = 'P'; $poststed{'0230'} = 'OSLO';
$postkommune{'0240'} = '0301'; $kategori{'0240'} = 'K'; $poststed{'0240'} = 'OSLO';
$postkommune{'0242'} = '0301'; $kategori{'0242'} = 'K'; $poststed{'0242'} = 'OSLO';
$postkommune{'0244'} = '0301'; $kategori{'0244'} = 'K'; $poststed{'0244'} = 'OSLO';
$postkommune{'0245'} = '0301'; $kategori{'0245'} = 'K'; $poststed{'0245'} = 'OSLO';
$postkommune{'0246'} = '0301'; $kategori{'0246'} = 'K'; $poststed{'0246'} = 'OSLO';
$postkommune{'0247'} = '0301'; $kategori{'0247'} = 'K'; $poststed{'0247'} = 'OSLO';
$postkommune{'0250'} = '0301'; $kategori{'0250'} = 'G'; $poststed{'0250'} = 'OSLO';
$postkommune{'0251'} = '0301'; $kategori{'0251'} = 'G'; $poststed{'0251'} = 'OSLO';
$postkommune{'0253'} = '0301'; $kategori{'0253'} = 'G'; $poststed{'0253'} = 'OSLO';
$postkommune{'0254'} = '0301'; $kategori{'0254'} = 'G'; $poststed{'0254'} = 'OSLO';
$postkommune{'0255'} = '0301'; $kategori{'0255'} = 'G'; $poststed{'0255'} = 'OSLO';
$postkommune{'0256'} = '0301'; $kategori{'0256'} = 'G'; $poststed{'0256'} = 'OSLO';
$postkommune{'0257'} = '0301'; $kategori{'0257'} = 'G'; $poststed{'0257'} = 'OSLO';
$postkommune{'0258'} = '0301'; $kategori{'0258'} = 'G'; $poststed{'0258'} = 'OSLO';
$postkommune{'0259'} = '0301'; $kategori{'0259'} = 'G'; $poststed{'0259'} = 'OSLO';
$postkommune{'0260'} = '0301'; $kategori{'0260'} = 'G'; $poststed{'0260'} = 'OSLO';
$postkommune{'0262'} = '0301'; $kategori{'0262'} = 'G'; $poststed{'0262'} = 'OSLO';
$postkommune{'0263'} = '0301'; $kategori{'0263'} = 'G'; $poststed{'0263'} = 'OSLO';
$postkommune{'0264'} = '0301'; $kategori{'0264'} = 'G'; $poststed{'0264'} = 'OSLO';
$postkommune{'0265'} = '0301'; $kategori{'0265'} = 'G'; $poststed{'0265'} = 'OSLO';
$postkommune{'0266'} = '0301'; $kategori{'0266'} = 'G'; $poststed{'0266'} = 'OSLO';
$postkommune{'0267'} = '0301'; $kategori{'0267'} = 'G'; $poststed{'0267'} = 'OSLO';
$postkommune{'0268'} = '0301'; $kategori{'0268'} = 'G'; $poststed{'0268'} = 'OSLO';
$postkommune{'0270'} = '0301'; $kategori{'0270'} = 'G'; $poststed{'0270'} = 'OSLO';
$postkommune{'0271'} = '0301'; $kategori{'0271'} = 'G'; $poststed{'0271'} = 'OSLO';
$postkommune{'0272'} = '0301'; $kategori{'0272'} = 'G'; $poststed{'0272'} = 'OSLO';
$postkommune{'0273'} = '0301'; $kategori{'0273'} = 'G'; $poststed{'0273'} = 'OSLO';
$postkommune{'0274'} = '0301'; $kategori{'0274'} = 'G'; $poststed{'0274'} = 'OSLO';
$postkommune{'0275'} = '0301'; $kategori{'0275'} = 'G'; $poststed{'0275'} = 'OSLO';
$postkommune{'0276'} = '0301'; $kategori{'0276'} = 'G'; $poststed{'0276'} = 'OSLO';
$postkommune{'0277'} = '0301'; $kategori{'0277'} = 'G'; $poststed{'0277'} = 'OSLO';
$postkommune{'0278'} = '0301'; $kategori{'0278'} = 'G'; $poststed{'0278'} = 'OSLO';
$postkommune{'0279'} = '0301'; $kategori{'0279'} = 'G'; $poststed{'0279'} = 'OSLO';
$postkommune{'0280'} = '0301'; $kategori{'0280'} = 'G'; $poststed{'0280'} = 'OSLO';
$postkommune{'0281'} = '0301'; $kategori{'0281'} = 'G'; $poststed{'0281'} = 'OSLO';
$postkommune{'0282'} = '0301'; $kategori{'0282'} = 'G'; $poststed{'0282'} = 'OSLO';
$postkommune{'0283'} = '0301'; $kategori{'0283'} = 'G'; $poststed{'0283'} = 'OSLO';
$postkommune{'0284'} = '0301'; $kategori{'0284'} = 'G'; $poststed{'0284'} = 'OSLO';
$postkommune{'0286'} = '0301'; $kategori{'0286'} = 'G'; $poststed{'0286'} = 'OSLO';
$postkommune{'0287'} = '0301'; $kategori{'0287'} = 'G'; $poststed{'0287'} = 'OSLO';
$postkommune{'0301'} = '0301'; $kategori{'0301'} = 'P'; $poststed{'0301'} = 'OSLO';
$postkommune{'0302'} = '0301'; $kategori{'0302'} = 'P'; $poststed{'0302'} = 'OSLO';
$postkommune{'0303'} = '0301'; $kategori{'0303'} = 'P'; $poststed{'0303'} = 'OSLO';
$postkommune{'0304'} = '0301'; $kategori{'0304'} = 'P'; $poststed{'0304'} = 'OSLO';
$postkommune{'0305'} = '0301'; $kategori{'0305'} = 'P'; $poststed{'0305'} = 'OSLO';
$postkommune{'0306'} = '0301'; $kategori{'0306'} = 'P'; $poststed{'0306'} = 'OSLO';
$postkommune{'0307'} = '0301'; $kategori{'0307'} = 'P'; $poststed{'0307'} = 'OSLO';
$postkommune{'0308'} = '0301'; $kategori{'0308'} = 'P'; $poststed{'0308'} = 'OSLO';
$postkommune{'0309'} = '0301'; $kategori{'0309'} = 'P'; $poststed{'0309'} = 'OSLO';
$postkommune{'0310'} = '0301'; $kategori{'0310'} = 'F'; $poststed{'0310'} = 'OSLO';
$postkommune{'0311'} = '0301'; $kategori{'0311'} = 'P'; $poststed{'0311'} = 'OSLO';
$postkommune{'0313'} = '0301'; $kategori{'0313'} = 'B'; $poststed{'0313'} = 'OSLO';
$postkommune{'0314'} = '0301'; $kategori{'0314'} = 'P'; $poststed{'0314'} = 'OSLO';
$postkommune{'0315'} = '0301'; $kategori{'0315'} = 'P'; $poststed{'0315'} = 'OSLO';
$postkommune{'0316'} = '0301'; $kategori{'0316'} = 'P'; $poststed{'0316'} = 'OSLO';
$postkommune{'0317'} = '0301'; $kategori{'0317'} = 'P'; $poststed{'0317'} = 'OSLO';
$postkommune{'0318'} = '0301'; $kategori{'0318'} = 'P'; $poststed{'0318'} = 'OSLO';
$postkommune{'0319'} = '0301'; $kategori{'0319'} = 'P'; $poststed{'0319'} = 'OSLO';
$postkommune{'0320'} = '0301'; $kategori{'0320'} = 'G'; $poststed{'0320'} = 'OSLO';
$postkommune{'0323'} = '0301'; $kategori{'0323'} = 'P'; $poststed{'0323'} = 'OSLO';
$postkommune{'0330'} = '0301'; $kategori{'0330'} = 'P'; $poststed{'0330'} = 'OSLO';
$postkommune{'0340'} = '0301'; $kategori{'0340'} = 'F'; $poststed{'0340'} = 'OSLO';
$postkommune{'0341'} = '0301'; $kategori{'0341'} = 'K'; $poststed{'0341'} = 'OSLO';
$postkommune{'0342'} = '0301'; $kategori{'0342'} = 'K'; $poststed{'0342'} = 'OSLO';
$postkommune{'0349'} = '0301'; $kategori{'0349'} = 'F'; $poststed{'0349'} = 'OSLO';
$postkommune{'0350'} = '0301'; $kategori{'0350'} = 'G'; $poststed{'0350'} = 'OSLO';
$postkommune{'0351'} = '0301'; $kategori{'0351'} = 'G'; $poststed{'0351'} = 'OSLO';
$postkommune{'0352'} = '0301'; $kategori{'0352'} = 'G'; $poststed{'0352'} = 'OSLO';
$postkommune{'0353'} = '0301'; $kategori{'0353'} = 'G'; $poststed{'0353'} = 'OSLO';
$postkommune{'0354'} = '0301'; $kategori{'0354'} = 'G'; $poststed{'0354'} = 'OSLO';
$postkommune{'0355'} = '0301'; $kategori{'0355'} = 'G'; $poststed{'0355'} = 'OSLO';
$postkommune{'0356'} = '0301'; $kategori{'0356'} = 'G'; $poststed{'0356'} = 'OSLO';
$postkommune{'0357'} = '0301'; $kategori{'0357'} = 'G'; $poststed{'0357'} = 'OSLO';
$postkommune{'0358'} = '0301'; $kategori{'0358'} = 'G'; $poststed{'0358'} = 'OSLO';
$postkommune{'0359'} = '0301'; $kategori{'0359'} = 'G'; $poststed{'0359'} = 'OSLO';
$postkommune{'0360'} = '0301'; $kategori{'0360'} = 'G'; $poststed{'0360'} = 'OSLO';
$postkommune{'0361'} = '0301'; $kategori{'0361'} = 'G'; $poststed{'0361'} = 'OSLO';
$postkommune{'0362'} = '0301'; $kategori{'0362'} = 'G'; $poststed{'0362'} = 'OSLO';
$postkommune{'0363'} = '0301'; $kategori{'0363'} = 'G'; $poststed{'0363'} = 'OSLO';
$postkommune{'0364'} = '0301'; $kategori{'0364'} = 'G'; $poststed{'0364'} = 'OSLO';
$postkommune{'0365'} = '0301'; $kategori{'0365'} = 'G'; $poststed{'0365'} = 'OSLO';
$postkommune{'0366'} = '0301'; $kategori{'0366'} = 'G'; $poststed{'0366'} = 'OSLO';
$postkommune{'0367'} = '0301'; $kategori{'0367'} = 'G'; $poststed{'0367'} = 'OSLO';
$postkommune{'0368'} = '0301'; $kategori{'0368'} = 'G'; $poststed{'0368'} = 'OSLO';
$postkommune{'0369'} = '0301'; $kategori{'0369'} = 'G'; $poststed{'0369'} = 'OSLO';
$postkommune{'0370'} = '0301'; $kategori{'0370'} = 'G'; $poststed{'0370'} = 'OSLO';
$postkommune{'0371'} = '0301'; $kategori{'0371'} = 'G'; $poststed{'0371'} = 'OSLO';
$postkommune{'0372'} = '0301'; $kategori{'0372'} = 'G'; $poststed{'0372'} = 'OSLO';
$postkommune{'0373'} = '0301'; $kategori{'0373'} = 'G'; $poststed{'0373'} = 'OSLO';
$postkommune{'0374'} = '0301'; $kategori{'0374'} = 'G'; $poststed{'0374'} = 'OSLO';
$postkommune{'0375'} = '0301'; $kategori{'0375'} = 'G'; $poststed{'0375'} = 'OSLO';
$postkommune{'0376'} = '0301'; $kategori{'0376'} = 'G'; $poststed{'0376'} = 'OSLO';
$postkommune{'0377'} = '0301'; $kategori{'0377'} = 'G'; $poststed{'0377'} = 'OSLO';
$postkommune{'0378'} = '0301'; $kategori{'0378'} = 'G'; $poststed{'0378'} = 'OSLO';
$postkommune{'0379'} = '0301'; $kategori{'0379'} = 'G'; $poststed{'0379'} = 'OSLO';
$postkommune{'0380'} = '0301'; $kategori{'0380'} = 'G'; $poststed{'0380'} = 'OSLO';
$postkommune{'0381'} = '0301'; $kategori{'0381'} = 'G'; $poststed{'0381'} = 'OSLO';
$postkommune{'0382'} = '0301'; $kategori{'0382'} = 'G'; $poststed{'0382'} = 'OSLO';
$postkommune{'0383'} = '0301'; $kategori{'0383'} = 'G'; $poststed{'0383'} = 'OSLO';
$postkommune{'0401'} = '0301'; $kategori{'0401'} = 'P'; $poststed{'0401'} = 'OSLO';
$postkommune{'0402'} = '0301'; $kategori{'0402'} = 'P'; $poststed{'0402'} = 'OSLO';
$postkommune{'0403'} = '0301'; $kategori{'0403'} = 'P'; $poststed{'0403'} = 'OSLO';
$postkommune{'0404'} = '0301'; $kategori{'0404'} = 'P'; $poststed{'0404'} = 'OSLO';
$postkommune{'0405'} = '0301'; $kategori{'0405'} = 'P'; $poststed{'0405'} = 'OSLO';
$postkommune{'0406'} = '0301'; $kategori{'0406'} = 'P'; $poststed{'0406'} = 'OSLO';
$postkommune{'0407'} = '0301'; $kategori{'0407'} = 'K'; $poststed{'0407'} = 'OSLO';
$postkommune{'0408'} = '0301'; $kategori{'0408'} = 'P'; $poststed{'0408'} = 'OSLO';
$postkommune{'0409'} = '0301'; $kategori{'0409'} = 'P'; $poststed{'0409'} = 'OSLO';
$postkommune{'0410'} = '0301'; $kategori{'0410'} = 'P'; $poststed{'0410'} = 'OSLO';
$postkommune{'0411'} = '0301'; $kategori{'0411'} = 'P'; $poststed{'0411'} = 'OSLO';
$postkommune{'0412'} = '0301'; $kategori{'0412'} = 'P'; $poststed{'0412'} = 'OSLO';
$postkommune{'0413'} = '0301'; $kategori{'0413'} = 'P'; $poststed{'0413'} = 'OSLO';
$postkommune{'0415'} = '0301'; $kategori{'0415'} = 'P'; $poststed{'0415'} = 'OSLO';
$postkommune{'0421'} = '0301'; $kategori{'0421'} = 'P'; $poststed{'0421'} = 'OSLO';
$postkommune{'0422'} = '0301'; $kategori{'0422'} = 'P'; $poststed{'0422'} = 'OSLO';
$postkommune{'0423'} = '0301'; $kategori{'0423'} = 'P'; $poststed{'0423'} = 'OSLO';
$postkommune{'0426'} = '0301'; $kategori{'0426'} = 'P'; $poststed{'0426'} = 'OSLO';
$postkommune{'0440'} = '0301'; $kategori{'0440'} = 'K'; $poststed{'0440'} = 'OSLO';
$postkommune{'0441'} = '0301'; $kategori{'0441'} = 'K'; $poststed{'0441'} = 'OSLO';
$postkommune{'0442'} = '0301'; $kategori{'0442'} = 'K'; $poststed{'0442'} = 'OSLO';
$postkommune{'0445'} = '0301'; $kategori{'0445'} = 'K'; $poststed{'0445'} = 'OSLO';
$postkommune{'0450'} = '0301'; $kategori{'0450'} = 'G'; $poststed{'0450'} = 'OSLO';
$postkommune{'0451'} = '0301'; $kategori{'0451'} = 'G'; $poststed{'0451'} = 'OSLO';
$postkommune{'0452'} = '0301'; $kategori{'0452'} = 'G'; $poststed{'0452'} = 'OSLO';
$postkommune{'0454'} = '0301'; $kategori{'0454'} = 'G'; $poststed{'0454'} = 'OSLO';
$postkommune{'0455'} = '0301'; $kategori{'0455'} = 'G'; $poststed{'0455'} = 'OSLO';
$postkommune{'0456'} = '0301'; $kategori{'0456'} = 'G'; $poststed{'0456'} = 'OSLO';
$postkommune{'0457'} = '0301'; $kategori{'0457'} = 'G'; $poststed{'0457'} = 'OSLO';
$postkommune{'0458'} = '0301'; $kategori{'0458'} = 'G'; $poststed{'0458'} = 'OSLO';
$postkommune{'0459'} = '0301'; $kategori{'0459'} = 'G'; $poststed{'0459'} = 'OSLO';
$postkommune{'0460'} = '0301'; $kategori{'0460'} = 'G'; $poststed{'0460'} = 'OSLO';
$postkommune{'0461'} = '0301'; $kategori{'0461'} = 'G'; $poststed{'0461'} = 'OSLO';
$postkommune{'0462'} = '0301'; $kategori{'0462'} = 'G'; $poststed{'0462'} = 'OSLO';
$postkommune{'0463'} = '0301'; $kategori{'0463'} = 'G'; $poststed{'0463'} = 'OSLO';
$postkommune{'0464'} = '0301'; $kategori{'0464'} = 'G'; $poststed{'0464'} = 'OSLO';
$postkommune{'0465'} = '0301'; $kategori{'0465'} = 'G'; $poststed{'0465'} = 'OSLO';
$postkommune{'0467'} = '0301'; $kategori{'0467'} = 'G'; $poststed{'0467'} = 'OSLO';
$postkommune{'0468'} = '0301'; $kategori{'0468'} = 'G'; $poststed{'0468'} = 'OSLO';
$postkommune{'0469'} = '0301'; $kategori{'0469'} = 'G'; $poststed{'0469'} = 'OSLO';
$postkommune{'0470'} = '0301'; $kategori{'0470'} = 'G'; $poststed{'0470'} = 'OSLO';
$postkommune{'0472'} = '0301'; $kategori{'0472'} = 'G'; $poststed{'0472'} = 'OSLO';
$postkommune{'0473'} = '0301'; $kategori{'0473'} = 'G'; $poststed{'0473'} = 'OSLO';
$postkommune{'0474'} = '0301'; $kategori{'0474'} = 'G'; $poststed{'0474'} = 'OSLO';
$postkommune{'0475'} = '0301'; $kategori{'0475'} = 'G'; $poststed{'0475'} = 'OSLO';
$postkommune{'0476'} = '0301'; $kategori{'0476'} = 'G'; $poststed{'0476'} = 'OSLO';
$postkommune{'0477'} = '0301'; $kategori{'0477'} = 'G'; $poststed{'0477'} = 'OSLO';
$postkommune{'0478'} = '0301'; $kategori{'0478'} = 'G'; $poststed{'0478'} = 'OSLO';
$postkommune{'0479'} = '0301'; $kategori{'0479'} = 'G'; $poststed{'0479'} = 'OSLO';
$postkommune{'0480'} = '0301'; $kategori{'0480'} = 'G'; $poststed{'0480'} = 'OSLO';
$postkommune{'0481'} = '0301'; $kategori{'0481'} = 'G'; $poststed{'0481'} = 'OSLO';
$postkommune{'0482'} = '0301'; $kategori{'0482'} = 'G'; $poststed{'0482'} = 'OSLO';
$postkommune{'0483'} = '0301'; $kategori{'0483'} = 'G'; $poststed{'0483'} = 'OSLO';
$postkommune{'0484'} = '0301'; $kategori{'0484'} = 'G'; $poststed{'0484'} = 'OSLO';
$postkommune{'0485'} = '0301'; $kategori{'0485'} = 'G'; $poststed{'0485'} = 'OSLO';
$postkommune{'0486'} = '0301'; $kategori{'0486'} = 'G'; $poststed{'0486'} = 'OSLO';
$postkommune{'0487'} = '0301'; $kategori{'0487'} = 'G'; $poststed{'0487'} = 'OSLO';
$postkommune{'0488'} = '0301'; $kategori{'0488'} = 'G'; $poststed{'0488'} = 'OSLO';
$postkommune{'0489'} = '0301'; $kategori{'0489'} = 'G'; $poststed{'0489'} = 'OSLO';
$postkommune{'0490'} = '0301'; $kategori{'0490'} = 'G'; $poststed{'0490'} = 'OSLO';
$postkommune{'0491'} = '0301'; $kategori{'0491'} = 'G'; $poststed{'0491'} = 'OSLO';
$postkommune{'0492'} = '0301'; $kategori{'0492'} = 'G'; $poststed{'0492'} = 'OSLO';
$postkommune{'0493'} = '0301'; $kategori{'0493'} = 'G'; $poststed{'0493'} = 'OSLO';
$postkommune{'0494'} = '0301'; $kategori{'0494'} = 'G'; $poststed{'0494'} = 'OSLO';
$postkommune{'0495'} = '0301'; $kategori{'0495'} = 'G'; $poststed{'0495'} = 'OSLO';
$postkommune{'0496'} = '0301'; $kategori{'0496'} = 'G'; $poststed{'0496'} = 'OSLO';
$postkommune{'0501'} = '0301'; $kategori{'0501'} = 'P'; $poststed{'0501'} = 'OSLO';
$postkommune{'0502'} = '0301'; $kategori{'0502'} = 'P'; $poststed{'0502'} = 'OSLO';
$postkommune{'0503'} = '0301'; $kategori{'0503'} = 'P'; $poststed{'0503'} = 'OSLO';
$postkommune{'0504'} = '0301'; $kategori{'0504'} = 'P'; $poststed{'0504'} = 'OSLO';
$postkommune{'0505'} = '0301'; $kategori{'0505'} = 'P'; $poststed{'0505'} = 'OSLO';
$postkommune{'0506'} = '0301'; $kategori{'0506'} = 'P'; $poststed{'0506'} = 'OSLO';
$postkommune{'0508'} = '0301'; $kategori{'0508'} = 'P'; $poststed{'0508'} = 'OSLO';
$postkommune{'0509'} = '0301'; $kategori{'0509'} = 'P'; $poststed{'0509'} = 'OSLO';
$postkommune{'0510'} = '0301'; $kategori{'0510'} = 'P'; $poststed{'0510'} = 'OSLO';
$postkommune{'0511'} = '0301'; $kategori{'0511'} = 'P'; $poststed{'0511'} = 'OSLO';
$postkommune{'0512'} = '0301'; $kategori{'0512'} = 'P'; $poststed{'0512'} = 'OSLO';
$postkommune{'0513'} = '0301'; $kategori{'0513'} = 'P'; $poststed{'0513'} = 'OSLO';
$postkommune{'0514'} = '0301'; $kategori{'0514'} = 'F'; $poststed{'0514'} = 'OSLO';
$postkommune{'0515'} = '0301'; $kategori{'0515'} = 'P'; $poststed{'0515'} = 'OSLO';
$postkommune{'0516'} = '0301'; $kategori{'0516'} = 'P'; $poststed{'0516'} = 'OSLO';
$postkommune{'0517'} = '0301'; $kategori{'0517'} = 'P'; $poststed{'0517'} = 'OSLO';
$postkommune{'0518'} = '0301'; $kategori{'0518'} = 'P'; $poststed{'0518'} = 'OSLO';
$postkommune{'0520'} = '0301'; $kategori{'0520'} = 'P'; $poststed{'0520'} = 'OSLO';
$postkommune{'0540'} = '0301'; $kategori{'0540'} = 'K'; $poststed{'0540'} = 'OSLO';
$postkommune{'0550'} = '0301'; $kategori{'0550'} = 'G'; $poststed{'0550'} = 'OSLO';
$postkommune{'0551'} = '0301'; $kategori{'0551'} = 'G'; $poststed{'0551'} = 'OSLO';
$postkommune{'0552'} = '0301'; $kategori{'0552'} = 'G'; $poststed{'0552'} = 'OSLO';
$postkommune{'0553'} = '0301'; $kategori{'0553'} = 'G'; $poststed{'0553'} = 'OSLO';
$postkommune{'0554'} = '0301'; $kategori{'0554'} = 'G'; $poststed{'0554'} = 'OSLO';
$postkommune{'0555'} = '0301'; $kategori{'0555'} = 'G'; $poststed{'0555'} = 'OSLO';
$postkommune{'0556'} = '0301'; $kategori{'0556'} = 'G'; $poststed{'0556'} = 'OSLO';
$postkommune{'0557'} = '0301'; $kategori{'0557'} = 'G'; $poststed{'0557'} = 'OSLO';
$postkommune{'0558'} = '0301'; $kategori{'0558'} = 'G'; $poststed{'0558'} = 'OSLO';
$postkommune{'0559'} = '0301'; $kategori{'0559'} = 'G'; $poststed{'0559'} = 'OSLO';
$postkommune{'0560'} = '0301'; $kategori{'0560'} = 'G'; $poststed{'0560'} = 'OSLO';
$postkommune{'0561'} = '0301'; $kategori{'0561'} = 'G'; $poststed{'0561'} = 'OSLO';
$postkommune{'0562'} = '0301'; $kategori{'0562'} = 'G'; $poststed{'0562'} = 'OSLO';
$postkommune{'0563'} = '0301'; $kategori{'0563'} = 'G'; $poststed{'0563'} = 'OSLO';
$postkommune{'0564'} = '0301'; $kategori{'0564'} = 'G'; $poststed{'0564'} = 'OSLO';
$postkommune{'0565'} = '0301'; $kategori{'0565'} = 'G'; $poststed{'0565'} = 'OSLO';
$postkommune{'0566'} = '0301'; $kategori{'0566'} = 'G'; $poststed{'0566'} = 'OSLO';
$postkommune{'0567'} = '0301'; $kategori{'0567'} = 'G'; $poststed{'0567'} = 'OSLO';
$postkommune{'0568'} = '0301'; $kategori{'0568'} = 'G'; $poststed{'0568'} = 'OSLO';
$postkommune{'0569'} = '0301'; $kategori{'0569'} = 'G'; $poststed{'0569'} = 'OSLO';
$postkommune{'0570'} = '0301'; $kategori{'0570'} = 'G'; $poststed{'0570'} = 'OSLO';
$postkommune{'0571'} = '0301'; $kategori{'0571'} = 'G'; $poststed{'0571'} = 'OSLO';
$postkommune{'0572'} = '0301'; $kategori{'0572'} = 'G'; $poststed{'0572'} = 'OSLO';
$postkommune{'0573'} = '0301'; $kategori{'0573'} = 'G'; $poststed{'0573'} = 'OSLO';
$postkommune{'0574'} = '0301'; $kategori{'0574'} = 'G'; $poststed{'0574'} = 'OSLO';
$postkommune{'0575'} = '0301'; $kategori{'0575'} = 'G'; $poststed{'0575'} = 'OSLO';
$postkommune{'0576'} = '0301'; $kategori{'0576'} = 'G'; $poststed{'0576'} = 'OSLO';
$postkommune{'0577'} = '0301'; $kategori{'0577'} = 'G'; $poststed{'0577'} = 'OSLO';
$postkommune{'0578'} = '0301'; $kategori{'0578'} = 'G'; $poststed{'0578'} = 'OSLO';
$postkommune{'0579'} = '0301'; $kategori{'0579'} = 'G'; $poststed{'0579'} = 'OSLO';
$postkommune{'0580'} = '0301'; $kategori{'0580'} = 'G'; $poststed{'0580'} = 'OSLO';
$postkommune{'0581'} = '0301'; $kategori{'0581'} = 'G'; $poststed{'0581'} = 'OSLO';
$postkommune{'0582'} = '0301'; $kategori{'0582'} = 'G'; $poststed{'0582'} = 'OSLO';
$postkommune{'0583'} = '0301'; $kategori{'0583'} = 'G'; $poststed{'0583'} = 'OSLO';
$postkommune{'0584'} = '0301'; $kategori{'0584'} = 'G'; $poststed{'0584'} = 'OSLO';
$postkommune{'0585'} = '0301'; $kategori{'0585'} = 'G'; $poststed{'0585'} = 'OSLO';
$postkommune{'0586'} = '0301'; $kategori{'0586'} = 'G'; $poststed{'0586'} = 'OSLO';
$postkommune{'0587'} = '0301'; $kategori{'0587'} = 'G'; $poststed{'0587'} = 'OSLO';
$postkommune{'0588'} = '0301'; $kategori{'0588'} = 'G'; $poststed{'0588'} = 'OSLO';
$postkommune{'0589'} = '0301'; $kategori{'0589'} = 'G'; $poststed{'0589'} = 'OSLO';
$postkommune{'0590'} = '0301'; $kategori{'0590'} = 'G'; $poststed{'0590'} = 'OSLO';
$postkommune{'0591'} = '0301'; $kategori{'0591'} = 'G'; $poststed{'0591'} = 'OSLO';
$postkommune{'0592'} = '0301'; $kategori{'0592'} = 'G'; $poststed{'0592'} = 'OSLO';
$postkommune{'0593'} = '0301'; $kategori{'0593'} = 'G'; $poststed{'0593'} = 'OSLO';
$postkommune{'0594'} = '0301'; $kategori{'0594'} = 'G'; $poststed{'0594'} = 'OSLO';
$postkommune{'0595'} = '0301'; $kategori{'0595'} = 'G'; $poststed{'0595'} = 'OSLO';
$postkommune{'0596'} = '0301'; $kategori{'0596'} = 'G'; $poststed{'0596'} = 'OSLO';
$postkommune{'0597'} = '0301'; $kategori{'0597'} = 'G'; $poststed{'0597'} = 'OSLO';
$postkommune{'0598'} = '0301'; $kategori{'0598'} = 'G'; $poststed{'0598'} = 'OSLO';
$postkommune{'0601'} = '0301'; $kategori{'0601'} = 'P'; $poststed{'0601'} = 'OSLO';
$postkommune{'0602'} = '0301'; $kategori{'0602'} = 'P'; $poststed{'0602'} = 'OSLO';
$postkommune{'0603'} = '0301'; $kategori{'0603'} = 'P'; $poststed{'0603'} = 'OSLO';
$postkommune{'0604'} = '0301'; $kategori{'0604'} = 'P'; $poststed{'0604'} = 'OSLO';
$postkommune{'0605'} = '0301'; $kategori{'0605'} = 'P'; $poststed{'0605'} = 'OSLO';
$postkommune{'0606'} = '0301'; $kategori{'0606'} = 'P'; $poststed{'0606'} = 'OSLO';
$postkommune{'0607'} = '0301'; $kategori{'0607'} = 'P'; $poststed{'0607'} = 'OSLO';
$postkommune{'0608'} = '0301'; $kategori{'0608'} = 'P'; $poststed{'0608'} = 'OSLO';
$postkommune{'0609'} = '0301'; $kategori{'0609'} = 'P'; $poststed{'0609'} = 'OSLO';
$postkommune{'0610'} = '0301'; $kategori{'0610'} = 'K'; $poststed{'0610'} = 'OSLO';
$postkommune{'0611'} = '0301'; $kategori{'0611'} = 'P'; $poststed{'0611'} = 'OSLO';
$postkommune{'0612'} = '0301'; $kategori{'0612'} = 'P'; $poststed{'0612'} = 'OSLO';
$postkommune{'0613'} = '0301'; $kategori{'0613'} = 'P'; $poststed{'0613'} = 'OSLO';
$postkommune{'0614'} = '0301'; $kategori{'0614'} = 'P'; $poststed{'0614'} = 'OSLO';
$postkommune{'0616'} = '0301'; $kategori{'0616'} = 'P'; $poststed{'0616'} = 'OSLO';
$postkommune{'0617'} = '0301'; $kategori{'0617'} = 'P'; $poststed{'0617'} = 'OSLO';
$postkommune{'0618'} = '0301'; $kategori{'0618'} = 'P'; $poststed{'0618'} = 'OSLO';
$postkommune{'0619'} = '0301'; $kategori{'0619'} = 'P'; $poststed{'0619'} = 'OSLO';
$postkommune{'0620'} = '0301'; $kategori{'0620'} = 'P'; $poststed{'0620'} = 'OSLO';
$postkommune{'0621'} = '0301'; $kategori{'0621'} = 'P'; $poststed{'0621'} = 'OSLO';
$postkommune{'0622'} = '0301'; $kategori{'0622'} = 'P'; $poststed{'0622'} = 'OSLO';
$postkommune{'0623'} = '0301'; $kategori{'0623'} = 'P'; $poststed{'0623'} = 'OSLO';
$postkommune{'0624'} = '0301'; $kategori{'0624'} = 'P'; $poststed{'0624'} = 'OSLO';
$postkommune{'0626'} = '0301'; $kategori{'0626'} = 'P'; $poststed{'0626'} = 'OSLO';
$postkommune{'0630'} = '0301'; $kategori{'0630'} = 'K'; $poststed{'0630'} = 'OSLO';
$postkommune{'0640'} = '0301'; $kategori{'0640'} = 'K'; $poststed{'0640'} = 'OSLO';
$postkommune{'0650'} = '0301'; $kategori{'0650'} = 'G'; $poststed{'0650'} = 'OSLO';
$postkommune{'0651'} = '0301'; $kategori{'0651'} = 'G'; $poststed{'0651'} = 'OSLO';
$postkommune{'0652'} = '0301'; $kategori{'0652'} = 'G'; $poststed{'0652'} = 'OSLO';
$postkommune{'0653'} = '0301'; $kategori{'0653'} = 'G'; $poststed{'0653'} = 'OSLO';
$postkommune{'0654'} = '0301'; $kategori{'0654'} = 'G'; $poststed{'0654'} = 'OSLO';
$postkommune{'0655'} = '0301'; $kategori{'0655'} = 'G'; $poststed{'0655'} = 'OSLO';
$postkommune{'0656'} = '0301'; $kategori{'0656'} = 'G'; $poststed{'0656'} = 'OSLO';
$postkommune{'0657'} = '0301'; $kategori{'0657'} = 'G'; $poststed{'0657'} = 'OSLO';
$postkommune{'0658'} = '0301'; $kategori{'0658'} = 'G'; $poststed{'0658'} = 'OSLO';
$postkommune{'0659'} = '0301'; $kategori{'0659'} = 'G'; $poststed{'0659'} = 'OSLO';
$postkommune{'0660'} = '0301'; $kategori{'0660'} = 'G'; $poststed{'0660'} = 'OSLO';
$postkommune{'0661'} = '0301'; $kategori{'0661'} = 'G'; $poststed{'0661'} = 'OSLO';
$postkommune{'0662'} = '0301'; $kategori{'0662'} = 'G'; $poststed{'0662'} = 'OSLO';
$postkommune{'0663'} = '0301'; $kategori{'0663'} = 'G'; $poststed{'0663'} = 'OSLO';
$postkommune{'0664'} = '0301'; $kategori{'0664'} = 'G'; $poststed{'0664'} = 'OSLO';
$postkommune{'0665'} = '0301'; $kategori{'0665'} = 'G'; $poststed{'0665'} = 'OSLO';
$postkommune{'0666'} = '0301'; $kategori{'0666'} = 'G'; $poststed{'0666'} = 'OSLO';
$postkommune{'0667'} = '0301'; $kategori{'0667'} = 'G'; $poststed{'0667'} = 'OSLO';
$postkommune{'0668'} = '0301'; $kategori{'0668'} = 'G'; $poststed{'0668'} = 'OSLO';
$postkommune{'0669'} = '0301'; $kategori{'0669'} = 'G'; $poststed{'0669'} = 'OSLO';
$postkommune{'0670'} = '0301'; $kategori{'0670'} = 'G'; $poststed{'0670'} = 'OSLO';
$postkommune{'0671'} = '0301'; $kategori{'0671'} = 'G'; $poststed{'0671'} = 'OSLO';
$postkommune{'0672'} = '0301'; $kategori{'0672'} = 'G'; $poststed{'0672'} = 'OSLO';
$postkommune{'0673'} = '0301'; $kategori{'0673'} = 'G'; $poststed{'0673'} = 'OSLO';
$postkommune{'0674'} = '0301'; $kategori{'0674'} = 'G'; $poststed{'0674'} = 'OSLO';
$postkommune{'0675'} = '0301'; $kategori{'0675'} = 'G'; $poststed{'0675'} = 'OSLO';
$postkommune{'0676'} = '0301'; $kategori{'0676'} = 'G'; $poststed{'0676'} = 'OSLO';
$postkommune{'0677'} = '0301'; $kategori{'0677'} = 'G'; $poststed{'0677'} = 'OSLO';
$postkommune{'0678'} = '0301'; $kategori{'0678'} = 'G'; $poststed{'0678'} = 'OSLO';
$postkommune{'0679'} = '0301'; $kategori{'0679'} = 'G'; $poststed{'0679'} = 'OSLO';
$postkommune{'0680'} = '0301'; $kategori{'0680'} = 'G'; $poststed{'0680'} = 'OSLO';
$postkommune{'0681'} = '0301'; $kategori{'0681'} = 'G'; $poststed{'0681'} = 'OSLO';
$postkommune{'0682'} = '0301'; $kategori{'0682'} = 'G'; $poststed{'0682'} = 'OSLO';
$postkommune{'0683'} = '0301'; $kategori{'0683'} = 'G'; $poststed{'0683'} = 'OSLO';
$postkommune{'0684'} = '0301'; $kategori{'0684'} = 'G'; $poststed{'0684'} = 'OSLO';
$postkommune{'0685'} = '0301'; $kategori{'0685'} = 'G'; $poststed{'0685'} = 'OSLO';
$postkommune{'0686'} = '0301'; $kategori{'0686'} = 'G'; $poststed{'0686'} = 'OSLO';
$postkommune{'0687'} = '0301'; $kategori{'0687'} = 'G'; $poststed{'0687'} = 'OSLO';
$postkommune{'0688'} = '0301'; $kategori{'0688'} = 'G'; $poststed{'0688'} = 'OSLO';
$postkommune{'0689'} = '0301'; $kategori{'0689'} = 'G'; $poststed{'0689'} = 'OSLO';
$postkommune{'0690'} = '0301'; $kategori{'0690'} = 'G'; $poststed{'0690'} = 'OSLO';
$postkommune{'0691'} = '0301'; $kategori{'0691'} = 'G'; $poststed{'0691'} = 'OSLO';
$postkommune{'0692'} = '0301'; $kategori{'0692'} = 'G'; $poststed{'0692'} = 'OSLO';
$postkommune{'0693'} = '0301'; $kategori{'0693'} = 'G'; $poststed{'0693'} = 'OSLO';
$postkommune{'0694'} = '0301'; $kategori{'0694'} = 'G'; $poststed{'0694'} = 'OSLO';
$postkommune{'0701'} = '0301'; $kategori{'0701'} = 'P'; $poststed{'0701'} = 'OSLO';
$postkommune{'0702'} = '0301'; $kategori{'0702'} = 'P'; $poststed{'0702'} = 'OSLO';
$postkommune{'0705'} = '0301'; $kategori{'0705'} = 'P'; $poststed{'0705'} = 'OSLO';
$postkommune{'0710'} = '0301'; $kategori{'0710'} = 'P'; $poststed{'0710'} = 'OSLO';
$postkommune{'0712'} = '0301'; $kategori{'0712'} = 'P'; $poststed{'0712'} = 'OSLO';
$postkommune{'0750'} = '0301'; $kategori{'0750'} = 'G'; $poststed{'0750'} = 'OSLO';
$postkommune{'0751'} = '0301'; $kategori{'0751'} = 'G'; $poststed{'0751'} = 'OSLO';
$postkommune{'0752'} = '0301'; $kategori{'0752'} = 'G'; $poststed{'0752'} = 'OSLO';
$postkommune{'0753'} = '0301'; $kategori{'0753'} = 'G'; $poststed{'0753'} = 'OSLO';
$postkommune{'0754'} = '0301'; $kategori{'0754'} = 'G'; $poststed{'0754'} = 'OSLO';
$postkommune{'0755'} = '0301'; $kategori{'0755'} = 'G'; $poststed{'0755'} = 'OSLO';
$postkommune{'0756'} = '0301'; $kategori{'0756'} = 'G'; $poststed{'0756'} = 'OSLO';
$postkommune{'0757'} = '0301'; $kategori{'0757'} = 'G'; $poststed{'0757'} = 'OSLO';
$postkommune{'0758'} = '0301'; $kategori{'0758'} = 'G'; $poststed{'0758'} = 'OSLO';
$postkommune{'0759'} = '0301'; $kategori{'0759'} = 'G'; $poststed{'0759'} = 'OSLO';
$postkommune{'0760'} = '0301'; $kategori{'0760'} = 'G'; $poststed{'0760'} = 'OSLO';
$postkommune{'0763'} = '0301'; $kategori{'0763'} = 'G'; $poststed{'0763'} = 'OSLO';
$postkommune{'0764'} = '0301'; $kategori{'0764'} = 'G'; $poststed{'0764'} = 'OSLO';
$postkommune{'0765'} = '0301'; $kategori{'0765'} = 'G'; $poststed{'0765'} = 'OSLO';
$postkommune{'0766'} = '0301'; $kategori{'0766'} = 'G'; $poststed{'0766'} = 'OSLO';
$postkommune{'0767'} = '0301'; $kategori{'0767'} = 'G'; $poststed{'0767'} = 'OSLO';
$postkommune{'0768'} = '0301'; $kategori{'0768'} = 'G'; $poststed{'0768'} = 'OSLO';
$postkommune{'0770'} = '0301'; $kategori{'0770'} = 'G'; $poststed{'0770'} = 'OSLO';
$postkommune{'0771'} = '0301'; $kategori{'0771'} = 'G'; $poststed{'0771'} = 'OSLO';
$postkommune{'0772'} = '0301'; $kategori{'0772'} = 'G'; $poststed{'0772'} = 'OSLO';
$postkommune{'0773'} = '0301'; $kategori{'0773'} = 'G'; $poststed{'0773'} = 'OSLO';
$postkommune{'0774'} = '0301'; $kategori{'0774'} = 'G'; $poststed{'0774'} = 'OSLO';
$postkommune{'0775'} = '0301'; $kategori{'0775'} = 'G'; $poststed{'0775'} = 'OSLO';
$postkommune{'0776'} = '0301'; $kategori{'0776'} = 'G'; $poststed{'0776'} = 'OSLO';
$postkommune{'0777'} = '0301'; $kategori{'0777'} = 'G'; $poststed{'0777'} = 'OSLO';
$postkommune{'0778'} = '0301'; $kategori{'0778'} = 'G'; $poststed{'0778'} = 'OSLO';
$postkommune{'0779'} = '0301'; $kategori{'0779'} = 'G'; $poststed{'0779'} = 'OSLO';
$postkommune{'0781'} = '0301'; $kategori{'0781'} = 'G'; $poststed{'0781'} = 'OSLO';
$postkommune{'0782'} = '0301'; $kategori{'0782'} = 'G'; $poststed{'0782'} = 'OSLO';
$postkommune{'0783'} = '0301'; $kategori{'0783'} = 'G'; $poststed{'0783'} = 'OSLO';
$postkommune{'0784'} = '0301'; $kategori{'0784'} = 'G'; $poststed{'0784'} = 'OSLO';
$postkommune{'0785'} = '0301'; $kategori{'0785'} = 'G'; $poststed{'0785'} = 'OSLO';
$postkommune{'0786'} = '0301'; $kategori{'0786'} = 'G'; $poststed{'0786'} = 'OSLO';
$postkommune{'0787'} = '0301'; $kategori{'0787'} = 'G'; $poststed{'0787'} = 'OSLO';
$postkommune{'0788'} = '0301'; $kategori{'0788'} = 'G'; $poststed{'0788'} = 'OSLO';
$postkommune{'0789'} = '0301'; $kategori{'0789'} = 'G'; $poststed{'0789'} = 'OSLO';
$postkommune{'0790'} = '0301'; $kategori{'0790'} = 'G'; $poststed{'0790'} = 'OSLO';
$postkommune{'0791'} = '0301'; $kategori{'0791'} = 'G'; $poststed{'0791'} = 'OSLO';
$postkommune{'0801'} = '0301'; $kategori{'0801'} = 'P'; $poststed{'0801'} = 'OSLO';
$postkommune{'0805'} = '0301'; $kategori{'0805'} = 'P'; $poststed{'0805'} = 'OSLO';
$postkommune{'0806'} = '0301'; $kategori{'0806'} = 'P'; $poststed{'0806'} = 'OSLO';
$postkommune{'0807'} = '0301'; $kategori{'0807'} = 'P'; $poststed{'0807'} = 'OSLO';
$postkommune{'0840'} = '0301'; $kategori{'0840'} = 'K'; $poststed{'0840'} = 'OSLO';
$postkommune{'0850'} = '0301'; $kategori{'0850'} = 'G'; $poststed{'0850'} = 'OSLO';
$postkommune{'0851'} = '0301'; $kategori{'0851'} = 'G'; $poststed{'0851'} = 'OSLO';
$postkommune{'0852'} = '0301'; $kategori{'0852'} = 'G'; $poststed{'0852'} = 'OSLO';
$postkommune{'0853'} = '0301'; $kategori{'0853'} = 'G'; $poststed{'0853'} = 'OSLO';
$postkommune{'0854'} = '0301'; $kategori{'0854'} = 'G'; $poststed{'0854'} = 'OSLO';
$postkommune{'0855'} = '0301'; $kategori{'0855'} = 'G'; $poststed{'0855'} = 'OSLO';
$postkommune{'0856'} = '0301'; $kategori{'0856'} = 'G'; $poststed{'0856'} = 'OSLO';
$postkommune{'0857'} = '0301'; $kategori{'0857'} = 'G'; $poststed{'0857'} = 'OSLO';
$postkommune{'0858'} = '0301'; $kategori{'0858'} = 'G'; $poststed{'0858'} = 'OSLO';
$postkommune{'0860'} = '0301'; $kategori{'0860'} = 'G'; $poststed{'0860'} = 'OSLO';
$postkommune{'0861'} = '0301'; $kategori{'0861'} = 'G'; $poststed{'0861'} = 'OSLO';
$postkommune{'0862'} = '0301'; $kategori{'0862'} = 'G'; $poststed{'0862'} = 'OSLO';
$postkommune{'0863'} = '0301'; $kategori{'0863'} = 'G'; $poststed{'0863'} = 'OSLO';
$postkommune{'0864'} = '0301'; $kategori{'0864'} = 'G'; $poststed{'0864'} = 'OSLO';
$postkommune{'0870'} = '0301'; $kategori{'0870'} = 'G'; $poststed{'0870'} = 'OSLO';
$postkommune{'0871'} = '0301'; $kategori{'0871'} = 'G'; $poststed{'0871'} = 'OSLO';
$postkommune{'0872'} = '0301'; $kategori{'0872'} = 'G'; $poststed{'0872'} = 'OSLO';
$postkommune{'0873'} = '0301'; $kategori{'0873'} = 'G'; $poststed{'0873'} = 'OSLO';
$postkommune{'0874'} = '0301'; $kategori{'0874'} = 'G'; $poststed{'0874'} = 'OSLO';
$postkommune{'0875'} = '0301'; $kategori{'0875'} = 'G'; $poststed{'0875'} = 'OSLO';
$postkommune{'0876'} = '0301'; $kategori{'0876'} = 'G'; $poststed{'0876'} = 'OSLO';
$postkommune{'0877'} = '0301'; $kategori{'0877'} = 'G'; $poststed{'0877'} = 'OSLO';
$postkommune{'0880'} = '0301'; $kategori{'0880'} = 'G'; $poststed{'0880'} = 'OSLO';
$postkommune{'0881'} = '0301'; $kategori{'0881'} = 'G'; $poststed{'0881'} = 'OSLO';
$postkommune{'0882'} = '0301'; $kategori{'0882'} = 'G'; $poststed{'0882'} = 'OSLO';
$postkommune{'0883'} = '0301'; $kategori{'0883'} = 'G'; $poststed{'0883'} = 'OSLO';
$postkommune{'0884'} = '0301'; $kategori{'0884'} = 'G'; $poststed{'0884'} = 'OSLO';
$postkommune{'0890'} = '0301'; $kategori{'0890'} = 'G'; $poststed{'0890'} = 'OSLO';
$postkommune{'0891'} = '0301'; $kategori{'0891'} = 'G'; $poststed{'0891'} = 'OSLO';
$postkommune{'0901'} = '0301'; $kategori{'0901'} = 'P'; $poststed{'0901'} = 'OSLO';
$postkommune{'0902'} = '0301'; $kategori{'0902'} = 'P'; $poststed{'0902'} = 'OSLO';
$postkommune{'0903'} = '0301'; $kategori{'0903'} = 'P'; $poststed{'0903'} = 'OSLO';
$postkommune{'0904'} = '0301'; $kategori{'0904'} = 'P'; $poststed{'0904'} = 'OSLO';
$postkommune{'0905'} = '0301'; $kategori{'0905'} = 'P'; $poststed{'0905'} = 'OSLO';
$postkommune{'0907'} = '0301'; $kategori{'0907'} = 'P'; $poststed{'0907'} = 'OSLO';
$postkommune{'0908'} = '0301'; $kategori{'0908'} = 'P'; $poststed{'0908'} = 'OSLO';
$postkommune{'0913'} = '0301'; $kategori{'0913'} = 'P'; $poststed{'0913'} = 'OSLO';
$postkommune{'0915'} = '0301'; $kategori{'0915'} = 'P'; $poststed{'0915'} = 'OSLO';
$postkommune{'0950'} = '0301'; $kategori{'0950'} = 'G'; $poststed{'0950'} = 'OSLO';
$postkommune{'0951'} = '0301'; $kategori{'0951'} = 'G'; $poststed{'0951'} = 'OSLO';
$postkommune{'0952'} = '0301'; $kategori{'0952'} = 'G'; $poststed{'0952'} = 'OSLO';
$postkommune{'0953'} = '0301'; $kategori{'0953'} = 'G'; $poststed{'0953'} = 'OSLO';
$postkommune{'0954'} = '0301'; $kategori{'0954'} = 'G'; $poststed{'0954'} = 'OSLO';
$postkommune{'0955'} = '0301'; $kategori{'0955'} = 'G'; $poststed{'0955'} = 'OSLO';
$postkommune{'0956'} = '0301'; $kategori{'0956'} = 'G'; $poststed{'0956'} = 'OSLO';
$postkommune{'0957'} = '0301'; $kategori{'0957'} = 'G'; $poststed{'0957'} = 'OSLO';
$postkommune{'0958'} = '0301'; $kategori{'0958'} = 'G'; $poststed{'0958'} = 'OSLO';
$postkommune{'0959'} = '0301'; $kategori{'0959'} = 'G'; $poststed{'0959'} = 'OSLO';
$postkommune{'0960'} = '0301'; $kategori{'0960'} = 'G'; $poststed{'0960'} = 'OSLO';
$postkommune{'0962'} = '0301'; $kategori{'0962'} = 'G'; $poststed{'0962'} = 'OSLO';
$postkommune{'0963'} = '0301'; $kategori{'0963'} = 'G'; $poststed{'0963'} = 'OSLO';
$postkommune{'0964'} = '0301'; $kategori{'0964'} = 'G'; $poststed{'0964'} = 'OSLO';
$postkommune{'0968'} = '0301'; $kategori{'0968'} = 'G'; $poststed{'0968'} = 'OSLO';
$postkommune{'0969'} = '0301'; $kategori{'0969'} = 'G'; $poststed{'0969'} = 'OSLO';
$postkommune{'0970'} = '0301'; $kategori{'0970'} = 'G'; $poststed{'0970'} = 'OSLO';
$postkommune{'0971'} = '0301'; $kategori{'0971'} = 'G'; $poststed{'0971'} = 'OSLO';
$postkommune{'0972'} = '0301'; $kategori{'0972'} = 'G'; $poststed{'0972'} = 'OSLO';
$postkommune{'0973'} = '0301'; $kategori{'0973'} = 'G'; $poststed{'0973'} = 'OSLO';
$postkommune{'0975'} = '0301'; $kategori{'0975'} = 'G'; $poststed{'0975'} = 'OSLO';
$postkommune{'0976'} = '0301'; $kategori{'0976'} = 'G'; $poststed{'0976'} = 'OSLO';
$postkommune{'0977'} = '0301'; $kategori{'0977'} = 'G'; $poststed{'0977'} = 'OSLO';
$postkommune{'0978'} = '0301'; $kategori{'0978'} = 'G'; $poststed{'0978'} = 'OSLO';
$postkommune{'0979'} = '0301'; $kategori{'0979'} = 'G'; $poststed{'0979'} = 'OSLO';
$postkommune{'0980'} = '0301'; $kategori{'0980'} = 'G'; $poststed{'0980'} = 'OSLO';
$postkommune{'0981'} = '0301'; $kategori{'0981'} = 'G'; $poststed{'0981'} = 'OSLO';
$postkommune{'0982'} = '0301'; $kategori{'0982'} = 'G'; $poststed{'0982'} = 'OSLO';
$postkommune{'0983'} = '0301'; $kategori{'0983'} = 'G'; $poststed{'0983'} = 'OSLO';
$postkommune{'0984'} = '0301'; $kategori{'0984'} = 'G'; $poststed{'0984'} = 'OSLO';
$postkommune{'0985'} = '0301'; $kategori{'0985'} = 'G'; $poststed{'0985'} = 'OSLO';
$postkommune{'0986'} = '0301'; $kategori{'0986'} = 'G'; $poststed{'0986'} = 'OSLO';
$postkommune{'0987'} = '0301'; $kategori{'0987'} = 'G'; $poststed{'0987'} = 'OSLO';
$postkommune{'0988'} = '0301'; $kategori{'0988'} = 'G'; $poststed{'0988'} = 'OSLO';
$postkommune{'1001'} = '0301'; $kategori{'1001'} = 'P'; $poststed{'1001'} = 'OSLO';
$postkommune{'1003'} = '0301'; $kategori{'1003'} = 'P'; $poststed{'1003'} = 'OSLO';
$postkommune{'1005'} = '0301'; $kategori{'1005'} = 'P'; $poststed{'1005'} = 'OSLO';
$postkommune{'1006'} = '0301'; $kategori{'1006'} = 'P'; $poststed{'1006'} = 'OSLO';
$postkommune{'1007'} = '0301'; $kategori{'1007'} = 'P'; $poststed{'1007'} = 'OSLO';
$postkommune{'1008'} = '0301'; $kategori{'1008'} = 'P'; $poststed{'1008'} = 'OSLO';
$postkommune{'1009'} = '0301'; $kategori{'1009'} = 'P'; $poststed{'1009'} = 'OSLO';
$postkommune{'1011'} = '0301'; $kategori{'1011'} = 'P'; $poststed{'1011'} = 'OSLO';
$postkommune{'1051'} = '0301'; $kategori{'1051'} = 'G'; $poststed{'1051'} = 'OSLO';
$postkommune{'1052'} = '0301'; $kategori{'1052'} = 'G'; $poststed{'1052'} = 'OSLO';
$postkommune{'1053'} = '0301'; $kategori{'1053'} = 'G'; $poststed{'1053'} = 'OSLO';
$postkommune{'1054'} = '0301'; $kategori{'1054'} = 'G'; $poststed{'1054'} = 'OSLO';
$postkommune{'1055'} = '0301'; $kategori{'1055'} = 'G'; $poststed{'1055'} = 'OSLO';
$postkommune{'1056'} = '0301'; $kategori{'1056'} = 'G'; $poststed{'1056'} = 'OSLO';
$postkommune{'1061'} = '0301'; $kategori{'1061'} = 'G'; $poststed{'1061'} = 'OSLO';
$postkommune{'1062'} = '0301'; $kategori{'1062'} = 'G'; $poststed{'1062'} = 'OSLO';
$postkommune{'1063'} = '0301'; $kategori{'1063'} = 'G'; $poststed{'1063'} = 'OSLO';
$postkommune{'1064'} = '0301'; $kategori{'1064'} = 'G'; $poststed{'1064'} = 'OSLO';
$postkommune{'1065'} = '0301'; $kategori{'1065'} = 'G'; $poststed{'1065'} = 'OSLO';
$postkommune{'1067'} = '0301'; $kategori{'1067'} = 'G'; $poststed{'1067'} = 'OSLO';
$postkommune{'1068'} = '0301'; $kategori{'1068'} = 'G'; $poststed{'1068'} = 'OSLO';
$postkommune{'1069'} = '0301'; $kategori{'1069'} = 'G'; $poststed{'1069'} = 'OSLO';
$postkommune{'1071'} = '0301'; $kategori{'1071'} = 'G'; $poststed{'1071'} = 'OSLO';
$postkommune{'1081'} = '0301'; $kategori{'1081'} = 'G'; $poststed{'1081'} = 'OSLO';
$postkommune{'1083'} = '0301'; $kategori{'1083'} = 'G'; $poststed{'1083'} = 'OSLO';
$postkommune{'1084'} = '0301'; $kategori{'1084'} = 'G'; $poststed{'1084'} = 'OSLO';
$postkommune{'1086'} = '0301'; $kategori{'1086'} = 'G'; $poststed{'1086'} = 'OSLO';
$postkommune{'1087'} = '0301'; $kategori{'1087'} = 'G'; $poststed{'1087'} = 'OSLO';
$postkommune{'1088'} = '0301'; $kategori{'1088'} = 'G'; $poststed{'1088'} = 'OSLO';
$postkommune{'1089'} = '0301'; $kategori{'1089'} = 'G'; $poststed{'1089'} = 'OSLO';
$postkommune{'1101'} = '0301'; $kategori{'1101'} = 'P'; $poststed{'1101'} = 'OSLO';
$postkommune{'1109'} = '0301'; $kategori{'1109'} = 'P'; $poststed{'1109'} = 'OSLO';
$postkommune{'1112'} = '0301'; $kategori{'1112'} = 'P'; $poststed{'1112'} = 'OSLO';
$postkommune{'1150'} = '0301'; $kategori{'1150'} = 'G'; $poststed{'1150'} = 'OSLO';
$postkommune{'1151'} = '0301'; $kategori{'1151'} = 'G'; $poststed{'1151'} = 'OSLO';
$postkommune{'1152'} = '0301'; $kategori{'1152'} = 'G'; $poststed{'1152'} = 'OSLO';
$postkommune{'1153'} = '0301'; $kategori{'1153'} = 'G'; $poststed{'1153'} = 'OSLO';
$postkommune{'1154'} = '0301'; $kategori{'1154'} = 'G'; $poststed{'1154'} = 'OSLO';
$postkommune{'1155'} = '0301'; $kategori{'1155'} = 'G'; $poststed{'1155'} = 'OSLO';
$postkommune{'1156'} = '0301'; $kategori{'1156'} = 'G'; $poststed{'1156'} = 'OSLO';
$postkommune{'1157'} = '0301'; $kategori{'1157'} = 'G'; $poststed{'1157'} = 'OSLO';
$postkommune{'1158'} = '0301'; $kategori{'1158'} = 'G'; $poststed{'1158'} = 'OSLO';
$postkommune{'1160'} = '0301'; $kategori{'1160'} = 'G'; $poststed{'1160'} = 'OSLO';
$postkommune{'1161'} = '0301'; $kategori{'1161'} = 'G'; $poststed{'1161'} = 'OSLO';
$postkommune{'1162'} = '0301'; $kategori{'1162'} = 'G'; $poststed{'1162'} = 'OSLO';
$postkommune{'1163'} = '0301'; $kategori{'1163'} = 'G'; $poststed{'1163'} = 'OSLO';
$postkommune{'1164'} = '0301'; $kategori{'1164'} = 'G'; $poststed{'1164'} = 'OSLO';
$postkommune{'1165'} = '0301'; $kategori{'1165'} = 'G'; $poststed{'1165'} = 'OSLO';
$postkommune{'1166'} = '0301'; $kategori{'1166'} = 'G'; $poststed{'1166'} = 'OSLO';
$postkommune{'1167'} = '0301'; $kategori{'1167'} = 'G'; $poststed{'1167'} = 'OSLO';
$postkommune{'1168'} = '0301'; $kategori{'1168'} = 'G'; $poststed{'1168'} = 'OSLO';
$postkommune{'1169'} = '0301'; $kategori{'1169'} = 'G'; $poststed{'1169'} = 'OSLO';
$postkommune{'1170'} = '0301'; $kategori{'1170'} = 'G'; $poststed{'1170'} = 'OSLO';
$postkommune{'1172'} = '0301'; $kategori{'1172'} = 'G'; $poststed{'1172'} = 'OSLO';
$postkommune{'1176'} = '0301'; $kategori{'1176'} = 'G'; $poststed{'1176'} = 'OSLO';
$postkommune{'1177'} = '0301'; $kategori{'1177'} = 'G'; $poststed{'1177'} = 'OSLO';
$postkommune{'1178'} = '0301'; $kategori{'1178'} = 'G'; $poststed{'1178'} = 'OSLO';
$postkommune{'1179'} = '0301'; $kategori{'1179'} = 'G'; $poststed{'1179'} = 'OSLO';
$postkommune{'1181'} = '0301'; $kategori{'1181'} = 'G'; $poststed{'1181'} = 'OSLO';
$postkommune{'1182'} = '0301'; $kategori{'1182'} = 'G'; $poststed{'1182'} = 'OSLO';
$postkommune{'1184'} = '0301'; $kategori{'1184'} = 'G'; $poststed{'1184'} = 'OSLO';
$postkommune{'1185'} = '0301'; $kategori{'1185'} = 'G'; $poststed{'1185'} = 'OSLO';
$postkommune{'1187'} = '0301'; $kategori{'1187'} = 'G'; $poststed{'1187'} = 'OSLO';
$postkommune{'1188'} = '0301'; $kategori{'1188'} = 'G'; $poststed{'1188'} = 'OSLO';
$postkommune{'1189'} = '0301'; $kategori{'1189'} = 'G'; $poststed{'1189'} = 'OSLO';
$postkommune{'1201'} = '0301'; $kategori{'1201'} = 'P'; $poststed{'1201'} = 'OSLO';
$postkommune{'1202'} = '0301'; $kategori{'1202'} = 'P'; $poststed{'1202'} = 'OSLO';
$postkommune{'1203'} = '0301'; $kategori{'1203'} = 'P'; $poststed{'1203'} = 'OSLO';
$postkommune{'1204'} = '0301'; $kategori{'1204'} = 'P'; $poststed{'1204'} = 'OSLO';
$postkommune{'1205'} = '0301'; $kategori{'1205'} = 'P'; $poststed{'1205'} = 'OSLO';
$postkommune{'1206'} = '0301'; $kategori{'1206'} = 'P'; $poststed{'1206'} = 'OSLO';
$postkommune{'1207'} = '0301'; $kategori{'1207'} = 'P'; $poststed{'1207'} = 'OSLO';
$postkommune{'1214'} = '0301'; $kategori{'1214'} = 'P'; $poststed{'1214'} = 'OSLO';
$postkommune{'1215'} = '0301'; $kategori{'1215'} = 'P'; $poststed{'1215'} = 'OSLO';
$postkommune{'1250'} = '0301'; $kategori{'1250'} = 'G'; $poststed{'1250'} = 'OSLO';
$postkommune{'1251'} = '0301'; $kategori{'1251'} = 'G'; $poststed{'1251'} = 'OSLO';
$postkommune{'1252'} = '0301'; $kategori{'1252'} = 'G'; $poststed{'1252'} = 'OSLO';
$postkommune{'1253'} = '0301'; $kategori{'1253'} = 'G'; $poststed{'1253'} = 'OSLO';
$postkommune{'1254'} = '0301'; $kategori{'1254'} = 'G'; $poststed{'1254'} = 'OSLO';
$postkommune{'1255'} = '0301'; $kategori{'1255'} = 'G'; $poststed{'1255'} = 'OSLO';
$postkommune{'1256'} = '0301'; $kategori{'1256'} = 'G'; $poststed{'1256'} = 'OSLO';
$postkommune{'1257'} = '0301'; $kategori{'1257'} = 'G'; $poststed{'1257'} = 'OSLO';
$postkommune{'1258'} = '0301'; $kategori{'1258'} = 'G'; $poststed{'1258'} = 'OSLO';
$postkommune{'1259'} = '0301'; $kategori{'1259'} = 'G'; $poststed{'1259'} = 'OSLO';
$postkommune{'1262'} = '0301'; $kategori{'1262'} = 'G'; $poststed{'1262'} = 'OSLO';
$postkommune{'1263'} = '0301'; $kategori{'1263'} = 'G'; $poststed{'1263'} = 'OSLO';
$postkommune{'1266'} = '0301'; $kategori{'1266'} = 'G'; $poststed{'1266'} = 'OSLO';
$postkommune{'1270'} = '0301'; $kategori{'1270'} = 'G'; $poststed{'1270'} = 'OSLO';
$postkommune{'1271'} = '0301'; $kategori{'1271'} = 'G'; $poststed{'1271'} = 'OSLO';
$postkommune{'1272'} = '0301'; $kategori{'1272'} = 'G'; $poststed{'1272'} = 'OSLO';
$postkommune{'1273'} = '0301'; $kategori{'1273'} = 'G'; $poststed{'1273'} = 'OSLO';
$postkommune{'1274'} = '0301'; $kategori{'1274'} = 'G'; $poststed{'1274'} = 'OSLO';
$postkommune{'1275'} = '0301'; $kategori{'1275'} = 'G'; $poststed{'1275'} = 'OSLO';
$postkommune{'1277'} = '0301'; $kategori{'1277'} = 'G'; $poststed{'1277'} = 'OSLO';
$postkommune{'1278'} = '0301'; $kategori{'1278'} = 'G'; $poststed{'1278'} = 'OSLO';
$postkommune{'1279'} = '0301'; $kategori{'1279'} = 'G'; $poststed{'1279'} = 'OSLO';
$postkommune{'1281'} = '0301'; $kategori{'1281'} = 'G'; $poststed{'1281'} = 'OSLO';
$postkommune{'1283'} = '0301'; $kategori{'1283'} = 'G'; $poststed{'1283'} = 'OSLO';
$postkommune{'1284'} = '0301'; $kategori{'1284'} = 'G'; $poststed{'1284'} = 'OSLO';
$postkommune{'1285'} = '0301'; $kategori{'1285'} = 'G'; $poststed{'1285'} = 'OSLO';
$postkommune{'1286'} = '0301'; $kategori{'1286'} = 'G'; $poststed{'1286'} = 'OSLO';
$postkommune{'1290'} = '0301'; $kategori{'1290'} = 'G'; $poststed{'1290'} = 'OSLO';
$postkommune{'1291'} = '0301'; $kategori{'1291'} = 'G'; $poststed{'1291'} = 'OSLO';
$postkommune{'1294'} = '0301'; $kategori{'1294'} = 'G'; $poststed{'1294'} = 'OSLO';
$postkommune{'1295'} = '0301'; $kategori{'1295'} = 'G'; $poststed{'1295'} = 'OSLO';
$postkommune{'1300'} = '0219'; $kategori{'1300'} = 'P'; $poststed{'1300'} = 'SANDVIKA';
$postkommune{'1301'} = '0219'; $kategori{'1301'} = 'P'; $poststed{'1301'} = 'SANDVIKA';
$postkommune{'1302'} = '0219'; $kategori{'1302'} = 'P'; $poststed{'1302'} = 'SANDVIKA';
$postkommune{'1303'} = '0219'; $kategori{'1303'} = 'P'; $poststed{'1303'} = 'SANDVIKA';
$postkommune{'1304'} = '0219'; $kategori{'1304'} = 'K'; $poststed{'1304'} = 'SANDVIKA';
$postkommune{'1305'} = '0219'; $kategori{'1305'} = 'P'; $poststed{'1305'} = 'HASLUM';
$postkommune{'1306'} = '0219'; $kategori{'1306'} = 'P'; $poststed{'1306'} = 'BRUM POSTTERMINAL';
$postkommune{'1309'} = '0219'; $kategori{'1309'} = 'P'; $poststed{'1309'} = 'RUD';
$postkommune{'1311'} = '0219'; $kategori{'1311'} = 'K'; $poststed{'1311'} = 'KUNSTSENTRET HVIKODDEN';
$postkommune{'1312'} = '0219'; $kategori{'1312'} = 'P'; $poststed{'1312'} = 'SLEPENDEN';
$postkommune{'1313'} = '0219'; $kategori{'1313'} = 'P'; $poststed{'1313'} = 'VYENENGA';
$postkommune{'1314'} = '0219'; $kategori{'1314'} = 'P'; $poststed{'1314'} = 'VYENENGA';
$postkommune{'1316'} = '0219'; $kategori{'1316'} = 'P'; $poststed{'1316'} = 'EIKSMARKA';
$postkommune{'1317'} = '0219'; $kategori{'1317'} = 'P'; $poststed{'1317'} = 'BRUMS VERK';
$postkommune{'1318'} = '0219'; $kategori{'1318'} = 'P'; $poststed{'1318'} = 'BEKKESTUA';
$postkommune{'1319'} = '0219'; $kategori{'1319'} = 'P'; $poststed{'1319'} = 'BEKKESTUA';
$postkommune{'1321'} = '0219'; $kategori{'1321'} = 'P'; $poststed{'1321'} = 'STABEKK';
$postkommune{'1322'} = '0219'; $kategori{'1322'} = 'P'; $poststed{'1322'} = 'HVIK';
$postkommune{'1323'} = '0219'; $kategori{'1323'} = 'P'; $poststed{'1323'} = 'HVIK';
$postkommune{'1324'} = '0219'; $kategori{'1324'} = 'P'; $poststed{'1324'} = 'LYSAKER';
$postkommune{'1325'} = '0219'; $kategori{'1325'} = 'P'; $poststed{'1325'} = 'LYSAKER';
$postkommune{'1326'} = '0219'; $kategori{'1326'} = 'P'; $poststed{'1326'} = 'LYSAKER';
$postkommune{'1327'} = '0219'; $kategori{'1327'} = 'P'; $poststed{'1327'} = 'LYSAKER';
$postkommune{'1330'} = '0219'; $kategori{'1330'} = 'P'; $poststed{'1330'} = 'FORNEBU';
$postkommune{'1331'} = '0219'; $kategori{'1331'} = 'K'; $poststed{'1331'} = 'FORNEBU';
$postkommune{'1332'} = '0219'; $kategori{'1332'} = 'P'; $poststed{'1332'} = 'STERS';
$postkommune{'1333'} = '0219'; $kategori{'1333'} = 'P'; $poststed{'1333'} = 'KOLSS';
$postkommune{'1334'} = '0219'; $kategori{'1334'} = 'P'; $poststed{'1334'} = 'RYKKINN';
$postkommune{'1335'} = '0219'; $kategori{'1335'} = 'P'; $poststed{'1335'} = 'SNARYA';
$postkommune{'1336'} = '0219'; $kategori{'1336'} = 'G'; $poststed{'1336'} = 'SANDVIKA';
$postkommune{'1337'} = '0219'; $kategori{'1337'} = 'G'; $poststed{'1337'} = 'SANDVIKA';
$postkommune{'1338'} = '0219'; $kategori{'1338'} = 'G'; $poststed{'1338'} = 'SANDVIKA';
$postkommune{'1339'} = '0219'; $kategori{'1339'} = 'G'; $poststed{'1339'} = 'VYENENGA';
$postkommune{'1340'} = '0219'; $kategori{'1340'} = 'G'; $poststed{'1340'} = 'SKUI';
$postkommune{'1341'} = '0219'; $kategori{'1341'} = 'G'; $poststed{'1341'} = 'SLEPENDEN';
$postkommune{'1344'} = '0219'; $kategori{'1344'} = 'G'; $poststed{'1344'} = 'HASLUM';
$postkommune{'1346'} = '0219'; $kategori{'1346'} = 'G'; $poststed{'1346'} = 'GJETTUM';
$postkommune{'1348'} = '0219'; $kategori{'1348'} = 'G'; $poststed{'1348'} = 'RYKKINN';
$postkommune{'1349'} = '0219'; $kategori{'1349'} = 'G'; $poststed{'1349'} = 'RYKKINN';
$postkommune{'1350'} = '0219'; $kategori{'1350'} = 'B'; $poststed{'1350'} = 'LOMMEDALEN';
$postkommune{'1351'} = '0219'; $kategori{'1351'} = 'G'; $poststed{'1351'} = 'RUD';
$postkommune{'1352'} = '0219'; $kategori{'1352'} = 'G'; $poststed{'1352'} = 'KOLSS';
$postkommune{'1353'} = '0219'; $kategori{'1353'} = 'G'; $poststed{'1353'} = 'BRUMS VERK';
$postkommune{'1354'} = '0219'; $kategori{'1354'} = 'G'; $poststed{'1354'} = 'BRUMS VERK';
$postkommune{'1356'} = '0219'; $kategori{'1356'} = 'G'; $poststed{'1356'} = 'BEKKESTUA';
$postkommune{'1357'} = '0219'; $kategori{'1357'} = 'G'; $poststed{'1357'} = 'BEKKESTUA';
$postkommune{'1358'} = '0219'; $kategori{'1358'} = 'G'; $poststed{'1358'} = 'JAR';
$postkommune{'1359'} = '0219'; $kategori{'1359'} = 'G'; $poststed{'1359'} = 'EIKSMARKA';
$postkommune{'1361'} = '0219'; $kategori{'1361'} = 'G'; $poststed{'1361'} = 'STERS';
$postkommune{'1362'} = '0219'; $kategori{'1362'} = 'G'; $poststed{'1362'} = 'HOSLE';
$postkommune{'1363'} = '0219'; $kategori{'1363'} = 'G'; $poststed{'1363'} = 'HVIK';
$postkommune{'1365'} = '0219'; $kategori{'1365'} = 'G'; $poststed{'1365'} = 'BLOMMENHOLM';
$postkommune{'1366'} = '0219'; $kategori{'1366'} = 'G'; $poststed{'1366'} = 'LYSAKER';
$postkommune{'1367'} = '0219'; $kategori{'1367'} = 'G'; $poststed{'1367'} = 'SNARYA';
$postkommune{'1368'} = '0219'; $kategori{'1368'} = 'G'; $poststed{'1368'} = 'STABEKK';
$postkommune{'1369'} = '0219'; $kategori{'1369'} = 'G'; $poststed{'1369'} = 'STABEKK';
$postkommune{'1371'} = '0220'; $kategori{'1371'} = 'P'; $poststed{'1371'} = 'ASKER';
$postkommune{'1372'} = '0220'; $kategori{'1372'} = 'P'; $poststed{'1372'} = 'ASKER';
$postkommune{'1373'} = '0220'; $kategori{'1373'} = 'P'; $poststed{'1373'} = 'ASKER';
$postkommune{'1375'} = '0220'; $kategori{'1375'} = 'P'; $poststed{'1375'} = 'BILLINGSTAD';
$postkommune{'1376'} = '0220'; $kategori{'1376'} = 'P'; $poststed{'1376'} = 'BILLINGSTAD';
$postkommune{'1377'} = '0220'; $kategori{'1377'} = 'P'; $poststed{'1377'} = 'BILLINGSTAD';
$postkommune{'1378'} = '0220'; $kategori{'1378'} = 'P'; $poststed{'1378'} = 'NESBRU';
$postkommune{'1379'} = '0220'; $kategori{'1379'} = 'P'; $poststed{'1379'} = 'NESBRU';
$postkommune{'1380'} = '0220'; $kategori{'1380'} = 'P'; $poststed{'1380'} = 'HEGGEDAL';
$postkommune{'1381'} = '0220'; $kategori{'1381'} = 'P'; $poststed{'1381'} = 'VETTRE';
$postkommune{'1383'} = '0220'; $kategori{'1383'} = 'G'; $poststed{'1383'} = 'ASKER';
$postkommune{'1384'} = '0220'; $kategori{'1384'} = 'G'; $poststed{'1384'} = 'ASKER';
$postkommune{'1385'} = '0220'; $kategori{'1385'} = 'G'; $poststed{'1385'} = 'ASKER';
$postkommune{'1386'} = '0220'; $kategori{'1386'} = 'G'; $poststed{'1386'} = 'ASKER';
$postkommune{'1387'} = '0220'; $kategori{'1387'} = 'G'; $poststed{'1387'} = 'ASKER';
$postkommune{'1388'} = '0220'; $kategori{'1388'} = 'G'; $poststed{'1388'} = 'BORGEN';
$postkommune{'1389'} = '0220'; $kategori{'1389'} = 'G'; $poststed{'1389'} = 'HEGGEDAL';
$postkommune{'1390'} = '0220'; $kategori{'1390'} = 'G'; $poststed{'1390'} = 'VOLLEN';
$postkommune{'1391'} = '0220'; $kategori{'1391'} = 'G'; $poststed{'1391'} = 'VOLLEN';
$postkommune{'1392'} = '0220'; $kategori{'1392'} = 'G'; $poststed{'1392'} = 'VETTRE';
$postkommune{'1393'} = '0220'; $kategori{'1393'} = 'P'; $poststed{'1393'} = 'VOLLEN';
$postkommune{'1394'} = '0220'; $kategori{'1394'} = 'G'; $poststed{'1394'} = 'NESBRU';
$postkommune{'1395'} = '0220'; $kategori{'1395'} = 'G'; $poststed{'1395'} = 'HVALSTAD';
$postkommune{'1396'} = '0220'; $kategori{'1396'} = 'G'; $poststed{'1396'} = 'BILLINGSTAD';
$postkommune{'1397'} = '0220'; $kategori{'1397'} = 'G'; $poststed{'1397'} = 'NESYA';
$postkommune{'1399'} = '0220'; $kategori{'1399'} = 'P'; $poststed{'1399'} = 'ASKER';
$postkommune{'1400'} = '0213'; $kategori{'1400'} = 'G'; $poststed{'1400'} = 'SKI';
$postkommune{'1401'} = '0213'; $kategori{'1401'} = 'P'; $poststed{'1401'} = 'SKI';
$postkommune{'1402'} = '0213'; $kategori{'1402'} = 'P'; $poststed{'1402'} = 'SKI';
$postkommune{'1403'} = '0213'; $kategori{'1403'} = 'P'; $poststed{'1403'} = 'LANGHUS';
$postkommune{'1404'} = '0213'; $kategori{'1404'} = 'B'; $poststed{'1404'} = 'SIGGERUD';
$postkommune{'1405'} = '0213'; $kategori{'1405'} = 'G'; $poststed{'1405'} = 'LANGHUS';
$postkommune{'1406'} = '0213'; $kategori{'1406'} = 'G'; $poststed{'1406'} = 'SKI';
$postkommune{'1407'} = '0214'; $kategori{'1407'} = 'B'; $poststed{'1407'} = 'VINTERBRO';
$postkommune{'1408'} = '0213'; $kategori{'1408'} = 'G'; $poststed{'1408'} = 'KRKSTAD';
$postkommune{'1409'} = '0213'; $kategori{'1409'} = 'G'; $poststed{'1409'} = 'SKOTBU';
$postkommune{'1410'} = '0217'; $kategori{'1410'} = 'G'; $poststed{'1410'} = 'KOLBOTN';
$postkommune{'1411'} = '0217'; $kategori{'1411'} = 'P'; $poststed{'1411'} = 'KOLBOTN';
$postkommune{'1412'} = '0217'; $kategori{'1412'} = 'G'; $poststed{'1412'} = 'SOFIEMYR';
$postkommune{'1413'} = '0217'; $kategori{'1413'} = 'B'; $poststed{'1413'} = 'TRNSEN';
$postkommune{'1414'} = '0217'; $kategori{'1414'} = 'G'; $poststed{'1414'} = 'TROLLSEN';
$postkommune{'1415'} = '0217'; $kategori{'1415'} = 'G'; $poststed{'1415'} = 'OPPEGRD';
$postkommune{'1416'} = '0217'; $kategori{'1416'} = 'P'; $poststed{'1416'} = 'OPPEGRD';
$postkommune{'1417'} = '0217'; $kategori{'1417'} = 'P'; $poststed{'1417'} = 'SOFIEMYR';
$postkommune{'1419'} = '0217'; $kategori{'1419'} = 'P'; $poststed{'1419'} = 'OPPEGRD';
$postkommune{'1420'} = '0217'; $kategori{'1420'} = 'G'; $poststed{'1420'} = 'SVARTSKOG';
$postkommune{'1421'} = '0217'; $kategori{'1421'} = 'P'; $poststed{'1421'} = 'TROLLSEN';
$postkommune{'1430'} = '0214'; $kategori{'1430'} = 'G'; $poststed{'1430'} = 'S';
$postkommune{'1431'} = '0214'; $kategori{'1431'} = 'P'; $poststed{'1431'} = 'S';
$postkommune{'1432'} = '0214'; $kategori{'1432'} = 'F'; $poststed{'1432'} = 'S';
$postkommune{'1440'} = '0215'; $kategori{'1440'} = 'G'; $poststed{'1440'} = 'DRBAK';
$postkommune{'1441'} = '0215'; $kategori{'1441'} = 'P'; $poststed{'1441'} = 'DRBAK';
$postkommune{'1442'} = '0215'; $kategori{'1442'} = 'P'; $poststed{'1442'} = 'DRBAK';
$postkommune{'1443'} = '0215'; $kategori{'1443'} = 'G'; $poststed{'1443'} = 'OSCARSBORG';
$postkommune{'1444'} = '0215'; $kategori{'1444'} = 'K'; $poststed{'1444'} = 'SKIPHELLE';
$postkommune{'1445'} = '0215'; $kategori{'1445'} = 'G'; $poststed{'1445'} = 'HEER';
$postkommune{'1450'} = '0216'; $kategori{'1450'} = 'G'; $poststed{'1450'} = 'NESODDTANGEN';
$postkommune{'1451'} = '0216'; $kategori{'1451'} = 'P'; $poststed{'1451'} = 'NESODDTANGEN';
$postkommune{'1453'} = '0216'; $kategori{'1453'} = 'G'; $poststed{'1453'} = 'BJRNEMYR';
$postkommune{'1454'} = '0216'; $kategori{'1454'} = 'B'; $poststed{'1454'} = 'FAGERSTRAND';
$postkommune{'1455'} = '0215'; $kategori{'1455'} = 'G'; $poststed{'1455'} = 'NORDRE FROGN';
$postkommune{'1458'} = '0216'; $kategori{'1458'} = 'G'; $poststed{'1458'} = 'FJELLSTRAND';
$postkommune{'1459'} = '0216'; $kategori{'1459'} = 'P'; $poststed{'1459'} = 'FJELLSTRAND';
$postkommune{'1470'} = '0230'; $kategori{'1470'} = 'G'; $poststed{'1470'} = 'LRENSKOG';
$postkommune{'1471'} = '0230'; $kategori{'1471'} = 'P'; $poststed{'1471'} = 'LRENSKOG';
$postkommune{'1472'} = '0230'; $kategori{'1472'} = 'G'; $poststed{'1472'} = 'FJELLHAMAR';
$postkommune{'1473'} = '0230'; $kategori{'1473'} = 'G'; $poststed{'1473'} = 'LRENSKOG';
$postkommune{'1474'} = '0230'; $kategori{'1474'} = 'G'; $poststed{'1474'} = 'NORDBYHAGEN';
$postkommune{'1475'} = '0230'; $kategori{'1475'} = 'B'; $poststed{'1475'} = 'FINSTADJORDET';
$postkommune{'1476'} = '0230'; $kategori{'1476'} = 'B'; $poststed{'1476'} = 'RASTA';
$postkommune{'1477'} = '0230'; $kategori{'1477'} = 'P'; $poststed{'1477'} = 'FJELLHAMAR';
$postkommune{'1478'} = '0230'; $kategori{'1478'} = 'K'; $poststed{'1478'} = 'LRENSKOG';
$postkommune{'1480'} = '0233'; $kategori{'1480'} = 'G'; $poststed{'1480'} = 'SLATTUM';
$postkommune{'1481'} = '0233'; $kategori{'1481'} = 'G'; $poststed{'1481'} = 'HAGAN';
$postkommune{'1482'} = '0233'; $kategori{'1482'} = 'B'; $poststed{'1482'} = 'NITTEDAL';
$postkommune{'1483'} = '0233'; $kategori{'1483'} = 'P'; $poststed{'1483'} = 'SKYTTA';
$postkommune{'1484'} = '0233'; $kategori{'1484'} = 'G'; $poststed{'1484'} = 'HAKADAL';
$postkommune{'1485'} = '0233'; $kategori{'1485'} = 'P'; $poststed{'1485'} = 'HAKADAL';
$postkommune{'1487'} = '0233'; $kategori{'1487'} = 'B'; $poststed{'1487'} = 'HAKADAL';
$postkommune{'1488'} = '0233'; $kategori{'1488'} = 'G'; $poststed{'1488'} = 'HAKADAL';
$postkommune{'1501'} = '0104'; $kategori{'1501'} = 'P'; $poststed{'1501'} = 'MOSS';
$postkommune{'1502'} = '0104'; $kategori{'1502'} = 'P'; $poststed{'1502'} = 'MOSS';
$postkommune{'1503'} = '0104'; $kategori{'1503'} = 'P'; $poststed{'1503'} = 'MOSS';
$postkommune{'1506'} = '0104'; $kategori{'1506'} = 'P'; $poststed{'1506'} = 'MOSS';
$postkommune{'1509'} = '0104'; $kategori{'1509'} = 'P'; $poststed{'1509'} = 'MOSS';
$postkommune{'1510'} = '0104'; $kategori{'1510'} = 'P'; $poststed{'1510'} = 'MOSS';
$postkommune{'1511'} = '0104'; $kategori{'1511'} = 'G'; $poststed{'1511'} = 'MOSS';
$postkommune{'1512'} = '0104'; $kategori{'1512'} = 'G'; $poststed{'1512'} = 'MOSS';
$postkommune{'1513'} = '0104'; $kategori{'1513'} = 'G'; $poststed{'1513'} = 'MOSS';
$postkommune{'1514'} = '0104'; $kategori{'1514'} = 'G'; $poststed{'1514'} = 'MOSS';
$postkommune{'1515'} = '0104'; $kategori{'1515'} = 'G'; $poststed{'1515'} = 'MOSS';
$postkommune{'1516'} = '0104'; $kategori{'1516'} = 'G'; $poststed{'1516'} = 'MOSS';
$postkommune{'1517'} = '0104'; $kategori{'1517'} = 'G'; $poststed{'1517'} = 'MOSS';
$postkommune{'1518'} = '0104'; $kategori{'1518'} = 'G'; $poststed{'1518'} = 'MOSS';
$postkommune{'1519'} = '0104'; $kategori{'1519'} = 'G'; $poststed{'1519'} = 'MOSS';
$postkommune{'1520'} = '0136'; $kategori{'1520'} = 'P'; $poststed{'1520'} = 'MOSS';
$postkommune{'1521'} = '0136'; $kategori{'1521'} = 'P'; $poststed{'1521'} = 'MOSS';
$postkommune{'1522'} = '0136'; $kategori{'1522'} = 'P'; $poststed{'1522'} = 'MOSS';
$postkommune{'1523'} = '0104'; $kategori{'1523'} = 'G'; $poststed{'1523'} = 'MOSS';
$postkommune{'1524'} = '0104'; $kategori{'1524'} = 'G'; $poststed{'1524'} = 'MOSS';
$postkommune{'1525'} = '0136'; $kategori{'1525'} = 'G'; $poststed{'1525'} = 'MOSS';
$postkommune{'1526'} = '0136'; $kategori{'1526'} = 'G'; $poststed{'1526'} = 'MOSS';
$postkommune{'1528'} = '0136'; $kategori{'1528'} = 'G'; $poststed{'1528'} = 'MOSS';
$postkommune{'1529'} = '0136'; $kategori{'1529'} = 'G'; $poststed{'1529'} = 'MOSS';
$postkommune{'1530'} = '0104'; $kategori{'1530'} = 'G'; $poststed{'1530'} = 'MOSS';
$postkommune{'1531'} = '0104'; $kategori{'1531'} = 'G'; $poststed{'1531'} = 'MOSS';
$postkommune{'1532'} = '0104'; $kategori{'1532'} = 'G'; $poststed{'1532'} = 'MOSS';
$postkommune{'1533'} = '0104'; $kategori{'1533'} = 'G'; $poststed{'1533'} = 'MOSS';
$postkommune{'1534'} = '0104'; $kategori{'1534'} = 'G'; $poststed{'1534'} = 'MOSS';
$postkommune{'1535'} = '0104'; $kategori{'1535'} = 'G'; $poststed{'1535'} = 'MOSS';
$postkommune{'1536'} = '0104'; $kategori{'1536'} = 'G'; $poststed{'1536'} = 'MOSS';
$postkommune{'1537'} = '0104'; $kategori{'1537'} = 'G'; $poststed{'1537'} = 'MOSS';
$postkommune{'1538'} = '0104'; $kategori{'1538'} = 'G'; $poststed{'1538'} = 'MOSS';
$postkommune{'1539'} = '0104'; $kategori{'1539'} = 'G'; $poststed{'1539'} = 'MOSS';
$postkommune{'1540'} = '0211'; $kategori{'1540'} = 'G'; $poststed{'1540'} = 'VESTBY';
$postkommune{'1541'} = '0211'; $kategori{'1541'} = 'P'; $poststed{'1541'} = 'VESTBY';
$postkommune{'1545'} = '0211'; $kategori{'1545'} = 'G'; $poststed{'1545'} = 'HVITSTEN';
$postkommune{'1550'} = '0211'; $kategori{'1550'} = 'B'; $poststed{'1550'} = 'HLEN';
$postkommune{'1555'} = '0211'; $kategori{'1555'} = 'G'; $poststed{'1555'} = 'SON';
$postkommune{'1556'} = '0211'; $kategori{'1556'} = 'P'; $poststed{'1556'} = 'SON';
$postkommune{'1560'} = '0136'; $kategori{'1560'} = 'B'; $poststed{'1560'} = 'LARKOLLEN';
$postkommune{'1570'} = '0136'; $kategori{'1570'} = 'G'; $poststed{'1570'} = 'DILLING';
$postkommune{'1580'} = '0136'; $kategori{'1580'} = 'G'; $poststed{'1580'} = 'RYGGE';
$postkommune{'1581'} = '0136'; $kategori{'1581'} = 'P'; $poststed{'1581'} = 'RYGGE';
$postkommune{'1590'} = '0136'; $kategori{'1590'} = 'K'; $poststed{'1590'} = 'RYGGE FLYSTASJON';
$postkommune{'1591'} = '0137'; $kategori{'1591'} = 'G'; $poststed{'1591'} = 'SPERREBOTN';
$postkommune{'1592'} = '0137'; $kategori{'1592'} = 'B'; $poststed{'1592'} = 'VLER I STFOLD';
$postkommune{'1593'} = '0137'; $kategori{'1593'} = 'B'; $poststed{'1593'} = 'SVINNDAL';
$postkommune{'1596'} = '0104'; $kategori{'1596'} = 'G'; $poststed{'1596'} = 'MOSS';
$postkommune{'1597'} = '0104'; $kategori{'1597'} = 'G'; $poststed{'1597'} = 'MOSS';
$postkommune{'1598'} = '0104'; $kategori{'1598'} = 'G'; $poststed{'1598'} = 'MOSS';
$postkommune{'1599'} = '0104'; $kategori{'1599'} = 'G'; $poststed{'1599'} = 'MOSS';
$postkommune{'1601'} = '0106'; $kategori{'1601'} = 'P'; $poststed{'1601'} = 'FREDRIKSTAD';
$postkommune{'1602'} = '0106'; $kategori{'1602'} = 'S'; $poststed{'1602'} = 'FREDRIKSTAD';
$postkommune{'1603'} = '0106'; $kategori{'1603'} = 'K'; $poststed{'1603'} = 'FREDRIKSTAD';
$postkommune{'1604'} = '0106'; $kategori{'1604'} = 'G'; $poststed{'1604'} = 'FREDRIKSTAD';
$postkommune{'1605'} = '0106'; $kategori{'1605'} = 'G'; $poststed{'1605'} = 'FREDRIKSTAD';
$postkommune{'1606'} = '0106'; $kategori{'1606'} = 'G'; $poststed{'1606'} = 'FREDRIKSTAD';
$postkommune{'1607'} = '0106'; $kategori{'1607'} = 'G'; $poststed{'1607'} = 'FREDRIKSTAD';
$postkommune{'1608'} = '0106'; $kategori{'1608'} = 'G'; $poststed{'1608'} = 'FREDRIKSTAD';
$postkommune{'1609'} = '0106'; $kategori{'1609'} = 'P'; $poststed{'1609'} = 'FREDRIKSTAD';
$postkommune{'1610'} = '0106'; $kategori{'1610'} = 'G'; $poststed{'1610'} = 'FREDRIKSTAD';
$postkommune{'1612'} = '0106'; $kategori{'1612'} = 'P'; $poststed{'1612'} = 'FREDRIKSTAD';
$postkommune{'1613'} = '0106'; $kategori{'1613'} = 'G'; $poststed{'1613'} = 'FREDRIKSTAD';
$postkommune{'1614'} = '0106'; $kategori{'1614'} = 'G'; $poststed{'1614'} = 'FREDRIKSTAD';
$postkommune{'1615'} = '0106'; $kategori{'1615'} = 'G'; $poststed{'1615'} = 'FREDRIKSTAD';
$postkommune{'1616'} = '0106'; $kategori{'1616'} = 'P'; $poststed{'1616'} = 'FREDRIKSTAD';
$postkommune{'1617'} = '0106'; $kategori{'1617'} = 'G'; $poststed{'1617'} = 'FREDRIKSTAD';
$postkommune{'1618'} = '0106'; $kategori{'1618'} = 'G'; $poststed{'1618'} = 'FREDRIKSTAD';
$postkommune{'1619'} = '0106'; $kategori{'1619'} = 'G'; $poststed{'1619'} = 'FREDRIKSTAD';
$postkommune{'1620'} = '0106'; $kategori{'1620'} = 'P'; $poststed{'1620'} = 'GRESSVIK';
$postkommune{'1621'} = '0106'; $kategori{'1621'} = 'B'; $poststed{'1621'} = 'GRESSVIK';
$postkommune{'1624'} = '0106'; $kategori{'1624'} = 'G'; $poststed{'1624'} = 'GRESSVIK';
$postkommune{'1625'} = '0106'; $kategori{'1625'} = 'P'; $poststed{'1625'} = 'MANSTAD';
$postkommune{'1626'} = '0106'; $kategori{'1626'} = 'G'; $poststed{'1626'} = 'MANSTAD';
$postkommune{'1628'} = '0106'; $kategori{'1628'} = 'G'; $poststed{'1628'} = 'ENGELSVIKEN';
$postkommune{'1629'} = '0106'; $kategori{'1629'} = 'P'; $poststed{'1629'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1630'} = '0106'; $kategori{'1630'} = 'G'; $poststed{'1630'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1632'} = '0106'; $kategori{'1632'} = 'G'; $poststed{'1632'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1633'} = '0106'; $kategori{'1633'} = 'G'; $poststed{'1633'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1634'} = '0106'; $kategori{'1634'} = 'G'; $poststed{'1634'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1636'} = '0106'; $kategori{'1636'} = 'G'; $poststed{'1636'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1637'} = '0106'; $kategori{'1637'} = 'G'; $poststed{'1637'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1638'} = '0106'; $kategori{'1638'} = 'P'; $poststed{'1638'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1639'} = '0106'; $kategori{'1639'} = 'G'; $poststed{'1639'} = 'GAMLE FREDRIKSTAD';
$postkommune{'1640'} = '0135'; $kategori{'1640'} = 'G'; $poststed{'1640'} = 'RDE';
$postkommune{'1641'} = '0135'; $kategori{'1641'} = 'P'; $poststed{'1641'} = 'RDE';
$postkommune{'1642'} = '0135'; $kategori{'1642'} = 'B'; $poststed{'1642'} = 'SALTNES';
$postkommune{'1650'} = '0106'; $kategori{'1650'} = 'P'; $poststed{'1650'} = 'SELLEBAKK';
$postkommune{'1651'} = '0106'; $kategori{'1651'} = 'G'; $poststed{'1651'} = 'SELLEBAKK';
$postkommune{'1653'} = '0106'; $kategori{'1653'} = 'G'; $poststed{'1653'} = 'SELLEBAKK';
$postkommune{'1654'} = '0106'; $kategori{'1654'} = 'G'; $poststed{'1654'} = 'SELLEBAKK';
$postkommune{'1655'} = '0106'; $kategori{'1655'} = 'G'; $poststed{'1655'} = 'SELLEBAKK';
$postkommune{'1657'} = '0106'; $kategori{'1657'} = 'G'; $poststed{'1657'} = 'TORP';
$postkommune{'1658'} = '0106'; $kategori{'1658'} = 'G'; $poststed{'1658'} = 'TORP';
$postkommune{'1659'} = '0106'; $kategori{'1659'} = 'G'; $poststed{'1659'} = 'TORP';
$postkommune{'1661'} = '0106'; $kategori{'1661'} = 'G'; $poststed{'1661'} = 'ROLVSY';
$postkommune{'1662'} = '0106'; $kategori{'1662'} = 'P'; $poststed{'1662'} = 'ROLVSY';
$postkommune{'1663'} = '0106'; $kategori{'1663'} = 'G'; $poststed{'1663'} = 'ROLVSY';
$postkommune{'1664'} = '0106'; $kategori{'1664'} = 'G'; $poststed{'1664'} = 'ROLVSY';
$postkommune{'1665'} = '0106'; $kategori{'1665'} = 'G'; $poststed{'1665'} = 'ROLVSY';
$postkommune{'1666'} = '0106'; $kategori{'1666'} = 'G'; $poststed{'1666'} = 'ROLVSY';
$postkommune{'1667'} = '0106'; $kategori{'1667'} = 'G'; $poststed{'1667'} = 'ROLVSY';
$postkommune{'1670'} = '0106'; $kategori{'1670'} = 'P'; $poststed{'1670'} = 'KRKERY';
$postkommune{'1671'} = '0106'; $kategori{'1671'} = 'G'; $poststed{'1671'} = 'KRKERY';
$postkommune{'1672'} = '0106'; $kategori{'1672'} = 'G'; $poststed{'1672'} = 'KRKERY';
$postkommune{'1673'} = '0106'; $kategori{'1673'} = 'G'; $poststed{'1673'} = 'KRKERY';
$postkommune{'1675'} = '0106'; $kategori{'1675'} = 'G'; $poststed{'1675'} = 'KRKERY';
$postkommune{'1676'} = '0106'; $kategori{'1676'} = 'G'; $poststed{'1676'} = 'KRKERY';
$postkommune{'1678'} = '0106'; $kategori{'1678'} = 'G'; $poststed{'1678'} = 'KRKERY';
$postkommune{'1679'} = '0106'; $kategori{'1679'} = 'G'; $poststed{'1679'} = 'KRKERY';
$postkommune{'1680'} = '0111'; $kategori{'1680'} = 'G'; $poststed{'1680'} = 'SKJRHALLEN';
$postkommune{'1682'} = '0111'; $kategori{'1682'} = 'P'; $poststed{'1682'} = 'SKJRHALLEN';
$postkommune{'1683'} = '0111'; $kategori{'1683'} = 'P'; $poststed{'1683'} = 'VESTERY';
$postkommune{'1684'} = '0111'; $kategori{'1684'} = 'G'; $poststed{'1684'} = 'VESTERY';
$postkommune{'1690'} = '0111'; $kategori{'1690'} = 'G'; $poststed{'1690'} = 'HERFL';
$postkommune{'1692'} = '0111'; $kategori{'1692'} = 'G'; $poststed{'1692'} = 'NEDGRDEN';
$postkommune{'1701'} = '0105'; $kategori{'1701'} = 'P'; $poststed{'1701'} = 'SARPSBORG';
$postkommune{'1702'} = '0105'; $kategori{'1702'} = 'P'; $poststed{'1702'} = 'SARPSBORG';
$postkommune{'1703'} = '0105'; $kategori{'1703'} = 'P'; $poststed{'1703'} = 'SARPSBORG';
$postkommune{'1704'} = '0105'; $kategori{'1704'} = 'P'; $poststed{'1704'} = 'SARPSBORG';
$postkommune{'1705'} = '0105'; $kategori{'1705'} = 'P'; $poststed{'1705'} = 'SARPSBORG';
$postkommune{'1706'} = '0105'; $kategori{'1706'} = 'G'; $poststed{'1706'} = 'SARPSBORG';
$postkommune{'1707'} = '0105'; $kategori{'1707'} = 'G'; $poststed{'1707'} = 'SARPSBORG';
$postkommune{'1708'} = '0105'; $kategori{'1708'} = 'G'; $poststed{'1708'} = 'SARPSBORG';
$postkommune{'1709'} = '0105'; $kategori{'1709'} = 'G'; $poststed{'1709'} = 'SARPSBORG';
$postkommune{'1710'} = '0105'; $kategori{'1710'} = 'G'; $poststed{'1710'} = 'SARPSBORG';
$postkommune{'1711'} = '0105'; $kategori{'1711'} = 'G'; $poststed{'1711'} = 'SARPSBORG';
$postkommune{'1712'} = '0105'; $kategori{'1712'} = 'G'; $poststed{'1712'} = 'GRLUM';
$postkommune{'1713'} = '0105'; $kategori{'1713'} = 'P'; $poststed{'1713'} = 'GRLUM';
$postkommune{'1714'} = '0105'; $kategori{'1714'} = 'S'; $poststed{'1714'} = 'SARPSBORG';
$postkommune{'1715'} = '0105'; $kategori{'1715'} = 'G'; $poststed{'1715'} = 'YVEN';
$postkommune{'1718'} = '0105'; $kategori{'1718'} = 'G'; $poststed{'1718'} = 'GREKER';
$postkommune{'1719'} = '0105'; $kategori{'1719'} = 'G'; $poststed{'1719'} = 'GREKER';
$postkommune{'1720'} = '0105'; $kategori{'1720'} = 'P'; $poststed{'1720'} = 'GREKER';
$postkommune{'1721'} = '0105'; $kategori{'1721'} = 'G'; $poststed{'1721'} = 'SARPSBORG';
$postkommune{'1722'} = '0105'; $kategori{'1722'} = 'G'; $poststed{'1722'} = 'SARPSBORG';
$postkommune{'1723'} = '0105'; $kategori{'1723'} = 'G'; $poststed{'1723'} = 'SARPSBORG';
$postkommune{'1724'} = '0105'; $kategori{'1724'} = 'G'; $poststed{'1724'} = 'SARPSBORG';
$postkommune{'1725'} = '0105'; $kategori{'1725'} = 'G'; $poststed{'1725'} = 'SARPSBORG';
$postkommune{'1726'} = '0105'; $kategori{'1726'} = 'G'; $poststed{'1726'} = 'SARPSBORG';
$postkommune{'1727'} = '0105'; $kategori{'1727'} = 'G'; $poststed{'1727'} = 'SARPSBORG';
$postkommune{'1730'} = '0105'; $kategori{'1730'} = 'B'; $poststed{'1730'} = 'ISE';
$postkommune{'1733'} = '0105'; $kategori{'1733'} = 'P'; $poststed{'1733'} = 'HAFSLUNDSY';
$postkommune{'1734'} = '0105'; $kategori{'1734'} = 'G'; $poststed{'1734'} = 'HAFSLUNDSY';
$postkommune{'1735'} = '0105'; $kategori{'1735'} = 'G'; $poststed{'1735'} = 'VARTEIG';
$postkommune{'1738'} = '0105'; $kategori{'1738'} = 'G'; $poststed{'1738'} = 'BORGENHAUGEN';
$postkommune{'1739'} = '0105'; $kategori{'1739'} = 'G'; $poststed{'1739'} = 'BORGENHAUGEN';
$postkommune{'1740'} = '0105'; $kategori{'1740'} = 'P'; $poststed{'1740'} = 'BORGENHAUGEN';
$postkommune{'1742'} = '0105'; $kategori{'1742'} = 'P'; $poststed{'1742'} = 'KLAVESTADHAUGEN';
$postkommune{'1743'} = '0105'; $kategori{'1743'} = 'G'; $poststed{'1743'} = 'KLAVESTADHAUGEN';
$postkommune{'1745'} = '0105'; $kategori{'1745'} = 'P'; $poststed{'1745'} = 'SKJEBERG';
$postkommune{'1746'} = '0105'; $kategori{'1746'} = 'G'; $poststed{'1746'} = 'SKJEBERG';
$postkommune{'1747'} = '0105'; $kategori{'1747'} = 'G'; $poststed{'1747'} = 'SKJEBERG';
$postkommune{'1751'} = '0101'; $kategori{'1751'} = 'P'; $poststed{'1751'} = 'HALDEN';
$postkommune{'1752'} = '0101'; $kategori{'1752'} = 'P'; $poststed{'1752'} = 'HALDEN';
$postkommune{'1753'} = '0101'; $kategori{'1753'} = 'P'; $poststed{'1753'} = 'HALDEN';
$postkommune{'1754'} = '0101'; $kategori{'1754'} = 'P'; $poststed{'1754'} = 'HALDEN';
$postkommune{'1756'} = '0101'; $kategori{'1756'} = 'K'; $poststed{'1756'} = 'HALDEN';
$postkommune{'1757'} = '0101'; $kategori{'1757'} = 'K'; $poststed{'1757'} = 'HALDEN';
$postkommune{'1758'} = '0101'; $kategori{'1758'} = 'K'; $poststed{'1758'} = 'HALDEN';
$postkommune{'1760'} = '0101'; $kategori{'1760'} = 'P'; $poststed{'1760'} = 'HALDEN';
$postkommune{'1761'} = '0101'; $kategori{'1761'} = 'P'; $poststed{'1761'} = 'HALDEN';
$postkommune{'1763'} = '0101'; $kategori{'1763'} = 'G'; $poststed{'1763'} = 'HALDEN';
$postkommune{'1764'} = '0101'; $kategori{'1764'} = 'G'; $poststed{'1764'} = 'HALDEN';
$postkommune{'1765'} = '0101'; $kategori{'1765'} = 'G'; $poststed{'1765'} = 'HALDEN';
$postkommune{'1766'} = '0101'; $kategori{'1766'} = 'G'; $poststed{'1766'} = 'HALDEN';
$postkommune{'1767'} = '0101'; $kategori{'1767'} = 'G'; $poststed{'1767'} = 'HALDEN';
$postkommune{'1768'} = '0101'; $kategori{'1768'} = 'G'; $poststed{'1768'} = 'HALDEN';
$postkommune{'1769'} = '0101'; $kategori{'1769'} = 'G'; $poststed{'1769'} = 'HALDEN';
$postkommune{'1771'} = '0101'; $kategori{'1771'} = 'G'; $poststed{'1771'} = 'HALDEN';
$postkommune{'1772'} = '0101'; $kategori{'1772'} = 'G'; $poststed{'1772'} = 'HALDEN';
$postkommune{'1776'} = '0101'; $kategori{'1776'} = 'G'; $poststed{'1776'} = 'HALDEN';
$postkommune{'1777'} = '0101'; $kategori{'1777'} = 'G'; $poststed{'1777'} = 'HALDEN';
$postkommune{'1778'} = '0101'; $kategori{'1778'} = 'G'; $poststed{'1778'} = 'HALDEN';
$postkommune{'1779'} = '0101'; $kategori{'1779'} = 'G'; $poststed{'1779'} = 'HALDEN';
$postkommune{'1781'} = '0101'; $kategori{'1781'} = 'G'; $poststed{'1781'} = 'HALDEN';
$postkommune{'1782'} = '0101'; $kategori{'1782'} = 'G'; $poststed{'1782'} = 'HALDEN';
$postkommune{'1783'} = '0101'; $kategori{'1783'} = 'G'; $poststed{'1783'} = 'HALDEN';
$postkommune{'1784'} = '0101'; $kategori{'1784'} = 'G'; $poststed{'1784'} = 'HALDEN';
$postkommune{'1785'} = '0101'; $kategori{'1785'} = 'G'; $poststed{'1785'} = 'HALDEN';
$postkommune{'1786'} = '0101'; $kategori{'1786'} = 'G'; $poststed{'1786'} = 'HALDEN';
$postkommune{'1787'} = '0101'; $kategori{'1787'} = 'P'; $poststed{'1787'} = 'BERG I STFOLD';
$postkommune{'1788'} = '0101'; $kategori{'1788'} = 'G'; $poststed{'1788'} = 'BERG I STFOLD';
$postkommune{'1789'} = '0101'; $kategori{'1789'} = 'G'; $poststed{'1789'} = 'BERG I STFOLD';
$postkommune{'1790'} = '0101'; $kategori{'1790'} = 'P'; $poststed{'1790'} = 'TISTEDAL';
$postkommune{'1791'} = '0101'; $kategori{'1791'} = 'G'; $poststed{'1791'} = 'TISTEDAL';
$postkommune{'1792'} = '0101'; $kategori{'1792'} = 'G'; $poststed{'1792'} = 'TISTEDAL';
$postkommune{'1793'} = '0101'; $kategori{'1793'} = 'G'; $poststed{'1793'} = 'TISTEDAL';
$postkommune{'1794'} = '0101'; $kategori{'1794'} = 'G'; $poststed{'1794'} = 'SPONVIKA';
$postkommune{'1796'} = '0101'; $kategori{'1796'} = 'G'; $poststed{'1796'} = 'KORNSJ';
$postkommune{'1798'} = '0118'; $kategori{'1798'} = 'G'; $poststed{'1798'} = 'AREMARK';
$postkommune{'1799'} = '0118'; $kategori{'1799'} = 'P'; $poststed{'1799'} = 'AREMARK';
$postkommune{'1801'} = '0124'; $kategori{'1801'} = 'P'; $poststed{'1801'} = 'ASKIM';
$postkommune{'1802'} = '0124'; $kategori{'1802'} = 'P'; $poststed{'1802'} = 'ASKIM';
$postkommune{'1803'} = '0124'; $kategori{'1803'} = 'P'; $poststed{'1803'} = 'ASKIM';
$postkommune{'1804'} = '0123'; $kategori{'1804'} = 'P'; $poststed{'1804'} = 'SPYDEBERG';
$postkommune{'1805'} = '0138'; $kategori{'1805'} = 'P'; $poststed{'1805'} = 'TOMTER';
$postkommune{'1806'} = '0127'; $kategori{'1806'} = 'P'; $poststed{'1806'} = 'SKIPTVET';
$postkommune{'1807'} = '0124'; $kategori{'1807'} = 'G'; $poststed{'1807'} = 'ASKIM';
$postkommune{'1808'} = '0124'; $kategori{'1808'} = 'G'; $poststed{'1808'} = 'ASKIM';
$postkommune{'1809'} = '0124'; $kategori{'1809'} = 'G'; $poststed{'1809'} = 'ASKIM';
$postkommune{'1811'} = '0124'; $kategori{'1811'} = 'G'; $poststed{'1811'} = 'ASKIM';
$postkommune{'1812'} = '0124'; $kategori{'1812'} = 'G'; $poststed{'1812'} = 'ASKIM';
$postkommune{'1813'} = '0124'; $kategori{'1813'} = 'G'; $poststed{'1813'} = 'ASKIM';
$postkommune{'1814'} = '0124'; $kategori{'1814'} = 'G'; $poststed{'1814'} = 'ASKIM';
$postkommune{'1815'} = '0124'; $kategori{'1815'} = 'G'; $poststed{'1815'} = 'ASKIM';
$postkommune{'1816'} = '0127'; $kategori{'1816'} = 'G'; $poststed{'1816'} = 'SKIPTVET';
$postkommune{'1820'} = '0123'; $kategori{'1820'} = 'G'; $poststed{'1820'} = 'SPYDEBERG';
$postkommune{'1823'} = '0138'; $kategori{'1823'} = 'G'; $poststed{'1823'} = 'KNAPSTAD';
$postkommune{'1825'} = '0138'; $kategori{'1825'} = 'G'; $poststed{'1825'} = 'TOMTER';
$postkommune{'1827'} = '0138'; $kategori{'1827'} = 'B'; $poststed{'1827'} = 'HOBL';
$postkommune{'1830'} = '0124'; $kategori{'1830'} = 'G'; $poststed{'1830'} = 'ASKIM';
$postkommune{'1831'} = '0124'; $kategori{'1831'} = 'G'; $poststed{'1831'} = 'ASKIM';
$postkommune{'1832'} = '0124'; $kategori{'1832'} = 'G'; $poststed{'1832'} = 'ASKIM';
$postkommune{'1850'} = '0125'; $kategori{'1850'} = 'G'; $poststed{'1850'} = 'MYSEN';
$postkommune{'1851'} = '0125'; $kategori{'1851'} = 'P'; $poststed{'1851'} = 'MYSEN';
$postkommune{'1859'} = '0125'; $kategori{'1859'} = 'G'; $poststed{'1859'} = 'SLITU';
$postkommune{'1860'} = '0122'; $kategori{'1860'} = 'G'; $poststed{'1860'} = 'TRGSTAD';
$postkommune{'1861'} = '0122'; $kategori{'1861'} = 'P'; $poststed{'1861'} = 'TRGSTAD';
$postkommune{'1866'} = '0122'; $kategori{'1866'} = 'G'; $poststed{'1866'} = 'BSTAD';
$postkommune{'1867'} = '0122'; $kategori{'1867'} = 'P'; $poststed{'1867'} = 'BSTAD';
$postkommune{'1870'} = '0119'; $kategori{'1870'} = 'G'; $poststed{'1870'} = 'RJE';
$postkommune{'1871'} = '0119'; $kategori{'1871'} = 'P'; $poststed{'1871'} = 'RJE';
$postkommune{'1875'} = '0119'; $kategori{'1875'} = 'G'; $poststed{'1875'} = 'OTTEID';
$postkommune{'1878'} = '0125'; $kategori{'1878'} = 'G'; $poststed{'1878'} = 'HRLAND';
$postkommune{'1880'} = '0125'; $kategori{'1880'} = 'G'; $poststed{'1880'} = 'EIDSBERG';
$postkommune{'1890'} = '0128'; $kategori{'1890'} = 'G'; $poststed{'1890'} = 'RAKKESTAD';
$postkommune{'1891'} = '0128'; $kategori{'1891'} = 'P'; $poststed{'1891'} = 'RAKKESTAD';
$postkommune{'1892'} = '0128'; $kategori{'1892'} = 'G'; $poststed{'1892'} = 'DEGERNES';
$postkommune{'1893'} = '0128'; $kategori{'1893'} = 'P'; $poststed{'1893'} = 'DEGERNES';
$postkommune{'1900'} = '0227'; $kategori{'1900'} = 'G'; $poststed{'1900'} = 'FETSUND';
$postkommune{'1901'} = '0227'; $kategori{'1901'} = 'P'; $poststed{'1901'} = 'FETSUND';
$postkommune{'1903'} = '0227'; $kategori{'1903'} = 'G'; $poststed{'1903'} = 'GAN';
$postkommune{'1910'} = '0227'; $kategori{'1910'} = 'G'; $poststed{'1910'} = 'ENEBAKKNESET';
$postkommune{'1911'} = '0229'; $kategori{'1911'} = 'B'; $poststed{'1911'} = 'FLATEBY';
$postkommune{'1912'} = '0229'; $kategori{'1912'} = 'B'; $poststed{'1912'} = 'ENEBAKK';
$postkommune{'1914'} = '0229'; $kategori{'1914'} = 'B'; $poststed{'1914'} = 'YTRE ENEBAKK';
$postkommune{'1920'} = '0226'; $kategori{'1920'} = 'G'; $poststed{'1920'} = 'SRUMSAND';
$postkommune{'1921'} = '0226'; $kategori{'1921'} = 'P'; $poststed{'1921'} = 'SRUMSAND';
$postkommune{'1923'} = '0226'; $kategori{'1923'} = 'B'; $poststed{'1923'} = 'SRUM';
$postkommune{'1925'} = '0226'; $kategori{'1925'} = 'G'; $poststed{'1925'} = 'BLAKER';
$postkommune{'1927'} = '0226'; $kategori{'1927'} = 'G'; $poststed{'1927'} = 'RNSFOSS';
$postkommune{'1929'} = '0236'; $kategori{'1929'} = 'B'; $poststed{'1929'} = 'AULI';
$postkommune{'1930'} = '0221'; $kategori{'1930'} = 'B'; $poststed{'1930'} = 'AURSKOG';
$postkommune{'1940'} = '0221'; $kategori{'1940'} = 'G'; $poststed{'1940'} = 'BJRKELANGEN';
$postkommune{'1941'} = '0221'; $kategori{'1941'} = 'P'; $poststed{'1941'} = 'BJRKELANGEN';
$postkommune{'1950'} = '0121'; $kategori{'1950'} = 'G'; $poststed{'1950'} = 'RMSKOG';
$postkommune{'1954'} = '0221'; $kategori{'1954'} = 'G'; $poststed{'1954'} = 'SETSKOG';
$postkommune{'1960'} = '0221'; $kategori{'1960'} = 'B'; $poststed{'1960'} = 'LKEN';
$postkommune{'1963'} = '0221'; $kategori{'1963'} = 'G'; $poststed{'1963'} = 'FOSSER';
$postkommune{'1970'} = '0221'; $kategori{'1970'} = 'B'; $poststed{'1970'} = 'HEMNES';
$postkommune{'2000'} = '0231'; $kategori{'2000'} = 'G'; $poststed{'2000'} = 'LILLESTRM';
$postkommune{'2001'} = '0231'; $kategori{'2001'} = 'P'; $poststed{'2001'} = 'LILLESTRM';
$postkommune{'2003'} = '0231'; $kategori{'2003'} = 'G'; $poststed{'2003'} = 'LILLESTRM';
$postkommune{'2004'} = '0231'; $kategori{'2004'} = 'G'; $poststed{'2004'} = 'LILLESTRM';
$postkommune{'2005'} = '0228'; $kategori{'2005'} = 'B'; $poststed{'2005'} = 'RLINGEN';
$postkommune{'2006'} = '0228'; $kategori{'2006'} = 'B'; $poststed{'2006'} = 'LVENSTAD';
$postkommune{'2007'} = '0231'; $kategori{'2007'} = 'G'; $poststed{'2007'} = 'KJELLER';
$postkommune{'2008'} = '0228'; $kategori{'2008'} = 'G'; $poststed{'2008'} = 'FJERDINGBY';
$postkommune{'2009'} = '0228'; $kategori{'2009'} = 'G'; $poststed{'2009'} = 'NORDBY';
$postkommune{'2010'} = '0231'; $kategori{'2010'} = 'G'; $poststed{'2010'} = 'STRMMEN';
$postkommune{'2011'} = '0231'; $kategori{'2011'} = 'P'; $poststed{'2011'} = 'STRMMEN';
$postkommune{'2012'} = '0231'; $kategori{'2012'} = 'P'; $poststed{'2012'} = 'LILLESTRM';
$postkommune{'2013'} = '0231'; $kategori{'2013'} = 'G'; $poststed{'2013'} = 'SKJETTEN';
$postkommune{'2014'} = '0228'; $kategori{'2014'} = 'G'; $poststed{'2014'} = 'BLYSTADLIA';
$postkommune{'2015'} = '0231'; $kategori{'2015'} = 'G'; $poststed{'2015'} = 'LEIRSUND';
$postkommune{'2016'} = '0226'; $kategori{'2016'} = 'B'; $poststed{'2016'} = 'FROGNER';
$postkommune{'2019'} = '0231'; $kategori{'2019'} = 'G'; $poststed{'2019'} = 'SKEDSMOKORSET';
$postkommune{'2020'} = '0231'; $kategori{'2020'} = 'G'; $poststed{'2020'} = 'SKEDSMOKORSET';
$postkommune{'2021'} = '0231'; $kategori{'2021'} = 'P'; $poststed{'2021'} = 'SKEDSMOKORSET';
$postkommune{'2022'} = '0234'; $kategori{'2022'} = 'G'; $poststed{'2022'} = 'GJERDRUM';
$postkommune{'2024'} = '0234'; $kategori{'2024'} = 'P'; $poststed{'2024'} = 'GJERDRUM';
$postkommune{'2025'} = '0228'; $kategori{'2025'} = 'P'; $poststed{'2025'} = 'FJERDINGBY';
$postkommune{'2026'} = '0231'; $kategori{'2026'} = 'P'; $poststed{'2026'} = 'SKJETTEN';
$postkommune{'2027'} = '0231'; $kategori{'2027'} = 'P'; $poststed{'2027'} = 'KJELLER';
$postkommune{'2030'} = '0238'; $kategori{'2030'} = 'G'; $poststed{'2030'} = 'NANNESTAD';
$postkommune{'2031'} = '0238'; $kategori{'2031'} = 'P'; $poststed{'2031'} = 'NANNESTAD';
$postkommune{'2032'} = '0238'; $kategori{'2032'} = 'B'; $poststed{'2032'} = 'MAURA';
$postkommune{'2033'} = '0238'; $kategori{'2033'} = 'G'; $poststed{'2033'} = 'SGREINA';
$postkommune{'2034'} = '0238'; $kategori{'2034'} = 'B'; $poststed{'2034'} = 'HOLTER';
$postkommune{'2040'} = '0235'; $kategori{'2040'} = 'G'; $poststed{'2040'} = 'KLFTA';
$postkommune{'2041'} = '0235'; $kategori{'2041'} = 'P'; $poststed{'2041'} = 'KLFTA';
$postkommune{'2050'} = '0235'; $kategori{'2050'} = 'G'; $poststed{'2050'} = 'JESSHEIM';
$postkommune{'2051'} = '0235'; $kategori{'2051'} = 'P'; $poststed{'2051'} = 'JESSHEIM';
$postkommune{'2052'} = '0235'; $kategori{'2052'} = 'G'; $poststed{'2052'} = 'JESSHEIM';
$postkommune{'2054'} = '0235'; $kategori{'2054'} = 'G'; $poststed{'2054'} = 'MOGREINA';
$postkommune{'2055'} = '0235'; $kategori{'2055'} = 'G'; $poststed{'2055'} = 'NORDKISA';
$postkommune{'2056'} = '0235'; $kategori{'2056'} = 'G'; $poststed{'2056'} = 'ALGARHEIM';
$postkommune{'2057'} = '0235'; $kategori{'2057'} = 'P'; $poststed{'2057'} = 'JESSHEIM';
$postkommune{'2058'} = '0235'; $kategori{'2058'} = 'K'; $poststed{'2058'} = 'SESSVOLLMOEN';
$postkommune{'2059'} = '0235'; $kategori{'2059'} = 'K'; $poststed{'2059'} = 'TRANDUM';
$postkommune{'2060'} = '0235'; $kategori{'2060'} = 'G'; $poststed{'2060'} = 'GARDERMOEN';
$postkommune{'2061'} = '0235'; $kategori{'2061'} = 'P'; $poststed{'2061'} = 'GARDERMOEN';
$postkommune{'2065'} = '0235'; $kategori{'2065'} = 'P'; $poststed{'2065'} = 'GARDERMOEN';
$postkommune{'2070'} = '0237'; $kategori{'2070'} = 'G'; $poststed{'2070'} = 'RHOLT';
$postkommune{'2071'} = '0237'; $kategori{'2071'} = 'P'; $poststed{'2071'} = 'RHOLT';
$postkommune{'2072'} = '0237'; $kategori{'2072'} = 'G'; $poststed{'2072'} = 'DAL';
$postkommune{'2073'} = '0237'; $kategori{'2073'} = 'G'; $poststed{'2073'} = 'BN';
$postkommune{'2074'} = '0237'; $kategori{'2074'} = 'G'; $poststed{'2074'} = 'EIDSVOLL VERK';
$postkommune{'2076'} = '0237'; $kategori{'2076'} = 'P'; $poststed{'2076'} = 'DAL';
$postkommune{'2080'} = '0237'; $kategori{'2080'} = 'G'; $poststed{'2080'} = 'EIDSVOLL';
$postkommune{'2081'} = '0237'; $kategori{'2081'} = 'P'; $poststed{'2081'} = 'EIDSVOLL';
$postkommune{'2090'} = '0239'; $kategori{'2090'} = 'G'; $poststed{'2090'} = 'HURDAL';
$postkommune{'2091'} = '0239'; $kategori{'2091'} = 'P'; $poststed{'2091'} = 'HURDAL';
$postkommune{'2092'} = '0237'; $kategori{'2092'} = 'B'; $poststed{'2092'} = 'MINNESUND';
$postkommune{'2093'} = '0237'; $kategori{'2093'} = 'G'; $poststed{'2093'} = 'FEIRING';
$postkommune{'2100'} = '0419'; $kategori{'2100'} = 'G'; $poststed{'2100'} = 'SKARNES';
$postkommune{'2101'} = '0419'; $kategori{'2101'} = 'P'; $poststed{'2101'} = 'SKARNES';
$postkommune{'2110'} = '0419'; $kategori{'2110'} = 'G'; $poststed{'2110'} = 'SLSTAD';
$postkommune{'2114'} = '0419'; $kategori{'2114'} = 'G'; $poststed{'2114'} = 'DISEN';
$postkommune{'2116'} = '0419'; $kategori{'2116'} = 'G'; $poststed{'2116'} = 'SANDER';
$postkommune{'2120'} = '0418'; $kategori{'2120'} = 'B'; $poststed{'2120'} = 'SAGSTUA';
$postkommune{'2123'} = '0418'; $kategori{'2123'} = 'G'; $poststed{'2123'} = 'BRUVOLL';
$postkommune{'2130'} = '0418'; $kategori{'2130'} = 'B'; $poststed{'2130'} = 'KNAPPER';
$postkommune{'2133'} = '0418'; $kategori{'2133'} = 'B'; $poststed{'2133'} = 'GARDVIK';
$postkommune{'2134'} = '0418'; $kategori{'2134'} = 'G'; $poststed{'2134'} = 'AUSTVATN';
$postkommune{'2150'} = '0236'; $kategori{'2150'} = 'G'; $poststed{'2150'} = 'RNES';
$postkommune{'2151'} = '0236'; $kategori{'2151'} = 'P'; $poststed{'2151'} = 'RNES';
$postkommune{'2160'} = '0236'; $kategori{'2160'} = 'B'; $poststed{'2160'} = 'VORMSUND';
$postkommune{'2162'} = '0236'; $kategori{'2162'} = 'G'; $poststed{'2162'} = 'BRRUD';
$postkommune{'2164'} = '0236'; $kategori{'2164'} = 'B'; $poststed{'2164'} = 'SKOGBYGDA';
$postkommune{'2165'} = '0236'; $kategori{'2165'} = 'B'; $poststed{'2165'} = 'HVAM';
$postkommune{'2166'} = '0236'; $kategori{'2166'} = 'G'; $poststed{'2166'} = 'OPPAKER';
$postkommune{'2170'} = '0236'; $kategori{'2170'} = 'B'; $poststed{'2170'} = 'FENSTAD';
$postkommune{'2201'} = '0402'; $kategori{'2201'} = 'P'; $poststed{'2201'} = 'KONGSVINGER';
$postkommune{'2202'} = '0402'; $kategori{'2202'} = 'P'; $poststed{'2202'} = 'KONGSVINGER';
$postkommune{'2203'} = '0402'; $kategori{'2203'} = 'P'; $poststed{'2203'} = 'KONGSVINGER';
$postkommune{'2204'} = '0402'; $kategori{'2204'} = 'P'; $poststed{'2204'} = 'KONGSVINGER';
$postkommune{'2205'} = '0402'; $kategori{'2205'} = 'P'; $poststed{'2205'} = 'KONGSVINGER';
$postkommune{'2206'} = '0402'; $kategori{'2206'} = 'P'; $poststed{'2206'} = 'KONGSVINGER';
$postkommune{'2208'} = '0402'; $kategori{'2208'} = 'G'; $poststed{'2208'} = 'KONGSVINGER';
$postkommune{'2209'} = '0402'; $kategori{'2209'} = 'G'; $poststed{'2209'} = 'KONGSVINGER';
$postkommune{'2210'} = '0402'; $kategori{'2210'} = 'G'; $poststed{'2210'} = 'GRANLI';
$postkommune{'2211'} = '0402'; $kategori{'2211'} = 'G'; $poststed{'2211'} = 'KONGSVINGER';
$postkommune{'2212'} = '0402'; $kategori{'2212'} = 'G'; $poststed{'2212'} = 'KONGSVINGER';
$postkommune{'2213'} = '0402'; $kategori{'2213'} = 'G'; $poststed{'2213'} = 'KONGSVINGER';
$postkommune{'2214'} = '0402'; $kategori{'2214'} = 'G'; $poststed{'2214'} = 'KONGSVINGER';
$postkommune{'2216'} = '0402'; $kategori{'2216'} = 'B'; $poststed{'2216'} = 'ROVERUD';
$postkommune{'2217'} = '0402'; $kategori{'2217'} = 'G'; $poststed{'2217'} = 'HOKKSEN';
$postkommune{'2218'} = '0402'; $kategori{'2218'} = 'G'; $poststed{'2218'} = 'LUNDERSTER';
$postkommune{'2219'} = '0402'; $kategori{'2219'} = 'G'; $poststed{'2219'} = 'BRANDVAL';
$postkommune{'2220'} = '0420'; $kategori{'2220'} = 'G'; $poststed{'2220'} = 'BOGEN';
$postkommune{'2223'} = '0419'; $kategori{'2223'} = 'G'; $poststed{'2223'} = 'GALTERUD';
$postkommune{'2224'} = '0402'; $kategori{'2224'} = 'B'; $poststed{'2224'} = 'AUSTMARKA';
$postkommune{'2225'} = '0402'; $kategori{'2225'} = 'K'; $poststed{'2225'} = 'KONGSVINGER';
$postkommune{'2226'} = '0402'; $kategori{'2226'} = 'S'; $poststed{'2226'} = 'KONGSVINGER';
$postkommune{'2230'} = '0420'; $kategori{'2230'} = 'B'; $poststed{'2230'} = 'SKOTTERUD';
$postkommune{'2232'} = '0420'; $kategori{'2232'} = 'G'; $poststed{'2232'} = 'TOBL';
$postkommune{'2233'} = '0420'; $kategori{'2233'} = 'G'; $poststed{'2233'} = 'VESTMARKA';
$postkommune{'2235'} = '0420'; $kategori{'2235'} = 'G'; $poststed{'2235'} = 'MATRAND';
$postkommune{'2240'} = '0420'; $kategori{'2240'} = 'B'; $poststed{'2240'} = 'MAGNOR';
$postkommune{'2242'} = '0420'; $kategori{'2242'} = 'G'; $poststed{'2242'} = 'MOROKULIEN';
$postkommune{'2256'} = '0423'; $kategori{'2256'} = 'B'; $poststed{'2256'} = 'GRUE FINNSKOG';
$postkommune{'2260'} = '0423'; $kategori{'2260'} = 'G'; $poststed{'2260'} = 'KIRKENR';
$postkommune{'2261'} = '0423'; $kategori{'2261'} = 'P'; $poststed{'2261'} = 'KIRKENR';
$postkommune{'2264'} = '0423'; $kategori{'2264'} = 'G'; $poststed{'2264'} = 'GRINDER';
$postkommune{'2265'} = '0423'; $kategori{'2265'} = 'G'; $poststed{'2265'} = 'NAMN';
$postkommune{'2266'} = '0425'; $kategori{'2266'} = 'G'; $poststed{'2266'} = 'ARNEBERG';
$postkommune{'2270'} = '0425'; $kategori{'2270'} = 'G'; $poststed{'2270'} = 'FLISA';
$postkommune{'2271'} = '0425'; $kategori{'2271'} = 'P'; $poststed{'2271'} = 'FLISA';
$postkommune{'2280'} = '0425'; $kategori{'2280'} = 'G'; $poststed{'2280'} = 'GJESSEN';
$postkommune{'2283'} = '0425'; $kategori{'2283'} = 'G'; $poststed{'2283'} = 'SNES FINNSKOG';
$postkommune{'2301'} = '0403'; $kategori{'2301'} = 'P'; $poststed{'2301'} = 'HAMAR';
$postkommune{'2302'} = '0403'; $kategori{'2302'} = 'P'; $poststed{'2302'} = 'HAMAR';
$postkommune{'2303'} = '0403'; $kategori{'2303'} = 'P'; $poststed{'2303'} = 'HAMAR';
$postkommune{'2304'} = '0403'; $kategori{'2304'} = 'P'; $poststed{'2304'} = 'HAMAR';
$postkommune{'2305'} = '0403'; $kategori{'2305'} = 'P'; $poststed{'2305'} = 'HAMAR';
$postkommune{'2306'} = '0403'; $kategori{'2306'} = 'P'; $poststed{'2306'} = 'HAMAR';
$postkommune{'2307'} = '0403'; $kategori{'2307'} = 'P'; $poststed{'2307'} = 'HAMAR';
$postkommune{'2308'} = '0403'; $kategori{'2308'} = 'P'; $poststed{'2308'} = 'HAMAR';
$postkommune{'2309'} = '0403'; $kategori{'2309'} = 'P'; $poststed{'2309'} = 'HAMAR';
$postkommune{'2312'} = '0417'; $kategori{'2312'} = 'B'; $poststed{'2312'} = 'OTTESTAD';
$postkommune{'2315'} = '0403'; $kategori{'2315'} = 'G'; $poststed{'2315'} = 'HAMAR';
$postkommune{'2316'} = '0403'; $kategori{'2316'} = 'G'; $poststed{'2316'} = 'HAMAR';
$postkommune{'2317'} = '0403'; $kategori{'2317'} = 'G'; $poststed{'2317'} = 'HAMAR';
$postkommune{'2318'} = '0403'; $kategori{'2318'} = 'B'; $poststed{'2318'} = 'HAMAR';
$postkommune{'2319'} = '0403'; $kategori{'2319'} = 'G'; $poststed{'2319'} = 'HAMAR';
$postkommune{'2320'} = '0412'; $kategori{'2320'} = 'B'; $poststed{'2320'} = 'FURNES';
$postkommune{'2321'} = '0403'; $kategori{'2321'} = 'G'; $poststed{'2321'} = 'HAMAR';
$postkommune{'2322'} = '0403'; $kategori{'2322'} = 'B'; $poststed{'2322'} = 'RIDABU';
$postkommune{'2323'} = '0403'; $kategori{'2323'} = 'G'; $poststed{'2323'} = 'INGEBERG';
$postkommune{'2324'} = '0403'; $kategori{'2324'} = 'B'; $poststed{'2324'} = 'VANG P HEDMARK';
$postkommune{'2325'} = '0403'; $kategori{'2325'} = 'K'; $poststed{'2325'} = 'HAMAR';
$postkommune{'2326'} = '0403'; $kategori{'2326'} = 'S'; $poststed{'2326'} = 'HAMAR';
$postkommune{'2330'} = '0417'; $kategori{'2330'} = 'B'; $poststed{'2330'} = 'VALLSET';
$postkommune{'2332'} = '0417'; $kategori{'2332'} = 'G'; $poststed{'2332'} = 'SVANG';
$postkommune{'2334'} = '0417'; $kategori{'2334'} = 'B'; $poststed{'2334'} = 'ROMEDAL';
$postkommune{'2335'} = '0417'; $kategori{'2335'} = 'G'; $poststed{'2335'} = 'STANGE';
$postkommune{'2336'} = '0417'; $kategori{'2336'} = 'P'; $poststed{'2336'} = 'STANGE';
$postkommune{'2337'} = '0417'; $kategori{'2337'} = 'B'; $poststed{'2337'} = 'TANGEN';
$postkommune{'2338'} = '0417'; $kategori{'2338'} = 'G'; $poststed{'2338'} = 'ESPA';
$postkommune{'2340'} = '0415'; $kategori{'2340'} = 'G'; $poststed{'2340'} = 'LTEN';
$postkommune{'2341'} = '0415'; $kategori{'2341'} = 'P'; $poststed{'2341'} = 'LTEN';
$postkommune{'2344'} = '0417'; $kategori{'2344'} = 'B'; $poststed{'2344'} = 'ILSENG';
$postkommune{'2345'} = '0415'; $kategori{'2345'} = 'G'; $poststed{'2345'} = 'DALSBRUK';
$postkommune{'2350'} = '0412'; $kategori{'2350'} = 'B'; $poststed{'2350'} = 'NES P HEDMARK';
$postkommune{'2353'} = '0412'; $kategori{'2353'} = 'B'; $poststed{'2353'} = 'STAVSJ';
$postkommune{'2355'} = '0412'; $kategori{'2355'} = 'G'; $poststed{'2355'} = 'GAUPEN';
$postkommune{'2360'} = '0412'; $kategori{'2360'} = 'B'; $poststed{'2360'} = 'RUDSHGDA';
$postkommune{'2364'} = '0412'; $kategori{'2364'} = 'G'; $poststed{'2364'} = 'NROSET';
$postkommune{'2365'} = '0412'; $kategori{'2365'} = 'G'; $poststed{'2365'} = 'SMARKA';
$postkommune{'2372'} = '0412'; $kategori{'2372'} = 'B'; $poststed{'2372'} = 'BRTTUM';
$postkommune{'2380'} = '0412'; $kategori{'2380'} = 'G'; $poststed{'2380'} = 'BRUMUNDDAL';
$postkommune{'2381'} = '0412'; $kategori{'2381'} = 'P'; $poststed{'2381'} = 'BRUMUNDDAL';
$postkommune{'2390'} = '0412'; $kategori{'2390'} = 'G'; $poststed{'2390'} = 'MOELV';
$postkommune{'2391'} = '0412'; $kategori{'2391'} = 'P'; $poststed{'2391'} = 'MOELV';
$postkommune{'2401'} = '0427'; $kategori{'2401'} = 'P'; $poststed{'2401'} = 'ELVERUM';
$postkommune{'2402'} = '0427'; $kategori{'2402'} = 'P'; $poststed{'2402'} = 'ELVERUM';
$postkommune{'2403'} = '0427'; $kategori{'2403'} = 'P'; $poststed{'2403'} = 'ELVERUM';
$postkommune{'2405'} = '0427'; $kategori{'2405'} = 'P'; $poststed{'2405'} = 'ELVERUM';
$postkommune{'2406'} = '0427'; $kategori{'2406'} = 'G'; $poststed{'2406'} = 'ELVERUM';
$postkommune{'2407'} = '0427'; $kategori{'2407'} = 'B'; $poststed{'2407'} = 'ELVERUM';
$postkommune{'2408'} = '0427'; $kategori{'2408'} = 'G'; $poststed{'2408'} = 'ELVERUM';
$postkommune{'2409'} = '0427'; $kategori{'2409'} = 'B'; $poststed{'2409'} = 'ELVERUM';
$postkommune{'2410'} = '0427'; $kategori{'2410'} = 'B'; $poststed{'2410'} = 'HERNES';
$postkommune{'2411'} = '0427'; $kategori{'2411'} = 'G'; $poststed{'2411'} = 'ELVERUM';
$postkommune{'2412'} = '0427'; $kategori{'2412'} = 'G'; $poststed{'2412'} = 'SRSKOGBYGDA';
$postkommune{'2415'} = '0427'; $kategori{'2415'} = 'B'; $poststed{'2415'} = 'HERADSBYGD';
$postkommune{'2416'} = '0427'; $kategori{'2416'} = 'G'; $poststed{'2416'} = 'JMNA';
$postkommune{'2418'} = '0427'; $kategori{'2418'} = 'S'; $poststed{'2418'} = 'ELVERUM';
$postkommune{'2420'} = '0428'; $kategori{'2420'} = 'G'; $poststed{'2420'} = 'TRYSIL';
$postkommune{'2421'} = '0428'; $kategori{'2421'} = 'P'; $poststed{'2421'} = 'TRYSIL';
$postkommune{'2422'} = '0428'; $kategori{'2422'} = 'B'; $poststed{'2422'} = 'NYBERGSUND';
$postkommune{'2423'} = '0428'; $kategori{'2423'} = 'B'; $poststed{'2423'} = 'STBY';
$postkommune{'2425'} = '0428'; $kategori{'2425'} = 'B'; $poststed{'2425'} = 'LJRDALEN';
$postkommune{'2427'} = '0428'; $kategori{'2427'} = 'G'; $poststed{'2427'} = 'PLASSEN';
$postkommune{'2428'} = '0428'; $kategori{'2428'} = 'B'; $poststed{'2428'} = 'SRE OSEN';
$postkommune{'2429'} = '0428'; $kategori{'2429'} = 'G'; $poststed{'2429'} = 'TRBERGET';
$postkommune{'2430'} = '0428'; $kategori{'2430'} = 'B'; $poststed{'2430'} = 'JORDET';
$postkommune{'2432'} = '0428'; $kategori{'2432'} = 'G'; $poststed{'2432'} = 'SLETTS';
$postkommune{'2435'} = '0426'; $kategori{'2435'} = 'B'; $poststed{'2435'} = 'BRASKEREIDFOSS';
$postkommune{'2436'} = '0426'; $kategori{'2436'} = 'B'; $poststed{'2436'} = 'VLER I SOLR';
$postkommune{'2437'} = '0426'; $kategori{'2437'} = 'K'; $poststed{'2437'} = 'HASLEMOEN';
$postkommune{'2438'} = '0426'; $kategori{'2438'} = 'G'; $poststed{'2438'} = 'GRAVBERGET';
$postkommune{'2440'} = '0434'; $kategori{'2440'} = 'B'; $poststed{'2440'} = 'ENGERDAL';
$postkommune{'2443'} = '0434'; $kategori{'2443'} = 'B'; $poststed{'2443'} = 'DREVSJ';
$postkommune{'2446'} = '0434'; $kategori{'2446'} = 'G'; $poststed{'2446'} = 'ELG';
$postkommune{'2448'} = '0434'; $kategori{'2448'} = 'G'; $poststed{'2448'} = 'SMDALEN';
$postkommune{'2450'} = '0429'; $kategori{'2450'} = 'G'; $poststed{'2450'} = 'RENA';
$postkommune{'2451'} = '0429'; $kategori{'2451'} = 'P'; $poststed{'2451'} = 'RENA';
$postkommune{'2460'} = '0429'; $kategori{'2460'} = 'B'; $poststed{'2460'} = 'OSEN';
$postkommune{'2476'} = '0430'; $kategori{'2476'} = 'G'; $poststed{'2476'} = 'ATNA';
$postkommune{'2477'} = '0430'; $kategori{'2477'} = 'G'; $poststed{'2477'} = 'SOLLIA';
$postkommune{'2478'} = '0432'; $kategori{'2478'} = 'G'; $poststed{'2478'} = 'HANESTAD';
$postkommune{'2480'} = '0430'; $kategori{'2480'} = 'G'; $poststed{'2480'} = 'KOPPANG';
$postkommune{'2481'} = '0430'; $kategori{'2481'} = 'P'; $poststed{'2481'} = 'KOPPANG';
$postkommune{'2485'} = '0432'; $kategori{'2485'} = 'B'; $poststed{'2485'} = 'RENDALEN';
$postkommune{'2500'} = '0437'; $kategori{'2500'} = 'G'; $poststed{'2500'} = 'TYNSET';
$postkommune{'2501'} = '0437'; $kategori{'2501'} = 'P'; $poststed{'2501'} = 'TYNSET';
$postkommune{'2510'} = '0437'; $kategori{'2510'} = 'G'; $poststed{'2510'} = 'TYLLDALEN';
$postkommune{'2512'} = '0437'; $kategori{'2512'} = 'B'; $poststed{'2512'} = 'KVIKNE';
$postkommune{'2540'} = '0436'; $kategori{'2540'} = 'B'; $poststed{'2540'} = 'TOLGA';
$postkommune{'2542'} = '0436'; $kategori{'2542'} = 'G'; $poststed{'2542'} = 'VINGELEN';
$postkommune{'2544'} = '0436'; $kategori{'2544'} = 'G'; $poststed{'2544'} = 'VERSJDALEN';
$postkommune{'2550'} = '0441'; $kategori{'2550'} = 'B'; $poststed{'2550'} = 'OS I STERDALEN';
$postkommune{'2552'} = '0441'; $kategori{'2552'} = 'G'; $poststed{'2552'} = 'DALSBYGDA';
$postkommune{'2555'} = '0441'; $kategori{'2555'} = 'G'; $poststed{'2555'} = 'TUFSINGDALEN';
$postkommune{'2560'} = '0438'; $kategori{'2560'} = 'G'; $poststed{'2560'} = 'ALVDAL';
$postkommune{'2561'} = '0438'; $kategori{'2561'} = 'P'; $poststed{'2561'} = 'ALVDAL';
$postkommune{'2580'} = '0439'; $kategori{'2580'} = 'G'; $poststed{'2580'} = 'FOLLDAL';
$postkommune{'2581'} = '0439'; $kategori{'2581'} = 'P'; $poststed{'2581'} = 'FOLLDAL';
$postkommune{'2582'} = '0439'; $kategori{'2582'} = 'G'; $poststed{'2582'} = 'GRIMSBU';
$postkommune{'2584'} = '0439'; $kategori{'2584'} = 'G'; $poststed{'2584'} = 'DALHOLEN';
$postkommune{'2601'} = '0501'; $kategori{'2601'} = 'P'; $poststed{'2601'} = 'LILLEHAMMER';
$postkommune{'2602'} = '0501'; $kategori{'2602'} = 'P'; $poststed{'2602'} = 'LILLEHAMMER';
$postkommune{'2603'} = '0501'; $kategori{'2603'} = 'P'; $poststed{'2603'} = 'LILLEHAMMER';
$postkommune{'2604'} = '0501'; $kategori{'2604'} = 'P'; $poststed{'2604'} = 'LILLEHAMMER';
$postkommune{'2605'} = '0501'; $kategori{'2605'} = 'P'; $poststed{'2605'} = 'LILLEHAMMER';
$postkommune{'2606'} = '0501'; $kategori{'2606'} = 'P'; $poststed{'2606'} = 'LILLEHAMMER';
$postkommune{'2607'} = '0501'; $kategori{'2607'} = 'B'; $poststed{'2607'} = 'VINGROM';
$postkommune{'2608'} = '0501'; $kategori{'2608'} = 'B'; $poststed{'2608'} = 'LILLEHAMMER';
$postkommune{'2609'} = '0501'; $kategori{'2609'} = 'B'; $poststed{'2609'} = 'LILLEHAMMER';
$postkommune{'2610'} = '0412'; $kategori{'2610'} = 'B'; $poststed{'2610'} = 'MESNALI';
$postkommune{'2611'} = '0501'; $kategori{'2611'} = 'B'; $poststed{'2611'} = 'LILLEHAMMER';
$postkommune{'2612'} = '0412'; $kategori{'2612'} = 'B'; $poststed{'2612'} = 'SJUSJEN';
$postkommune{'2613'} = '0501'; $kategori{'2613'} = 'G'; $poststed{'2613'} = 'LILLEHAMMER';
$postkommune{'2614'} = '0501'; $kategori{'2614'} = 'G'; $poststed{'2614'} = 'LILLEHAMMER';
$postkommune{'2615'} = '0501'; $kategori{'2615'} = 'G'; $poststed{'2615'} = 'LILLEHAMMER';
$postkommune{'2616'} = '0412'; $kategori{'2616'} = 'G'; $poststed{'2616'} = 'LISMARKA';
$postkommune{'2617'} = '0501'; $kategori{'2617'} = 'K'; $poststed{'2617'} = 'LILLEHAMMER';
$postkommune{'2618'} = '0501'; $kategori{'2618'} = 'G'; $poststed{'2618'} = 'LILLEHAMMER';
$postkommune{'2619'} = '0501'; $kategori{'2619'} = 'G'; $poststed{'2619'} = 'LILLEHAMMER';
$postkommune{'2624'} = '0501'; $kategori{'2624'} = 'B'; $poststed{'2624'} = 'LILLEHAMMER';
$postkommune{'2625'} = '0501'; $kategori{'2625'} = 'B'; $poststed{'2625'} = 'FBERG';
$postkommune{'2626'} = '0501'; $kategori{'2626'} = 'S'; $poststed{'2626'} = 'LILLEHAMMER';
$postkommune{'2629'} = '0501'; $kategori{'2629'} = 'K'; $poststed{'2629'} = 'LILLEHAMMER';
$postkommune{'2630'} = '0520'; $kategori{'2630'} = 'G'; $poststed{'2630'} = 'RINGEBU';
$postkommune{'2631'} = '0520'; $kategori{'2631'} = 'P'; $poststed{'2631'} = 'RINGEBU';
$postkommune{'2632'} = '0520'; $kategori{'2632'} = 'G'; $poststed{'2632'} = 'VENABYGD';
$postkommune{'2633'} = '0520'; $kategori{'2633'} = 'P'; $poststed{'2633'} = 'FVANG';
$postkommune{'2634'} = '0520'; $kategori{'2634'} = 'G'; $poststed{'2634'} = 'FVANG';
$postkommune{'2635'} = '0521'; $kategori{'2635'} = 'B'; $poststed{'2635'} = 'TRETTEN';
$postkommune{'2636'} = '0521'; $kategori{'2636'} = 'G'; $poststed{'2636'} = 'YER';
$postkommune{'2637'} = '0521'; $kategori{'2637'} = 'P'; $poststed{'2637'} = 'YER';
$postkommune{'2639'} = '0516'; $kategori{'2639'} = 'P'; $poststed{'2639'} = 'VINSTRA';
$postkommune{'2640'} = '0516'; $kategori{'2640'} = 'G'; $poststed{'2640'} = 'VINSTRA';
$postkommune{'2642'} = '0516'; $kategori{'2642'} = 'B'; $poststed{'2642'} = 'KVAM';
$postkommune{'2643'} = '0516'; $kategori{'2643'} = 'B'; $poststed{'2643'} = 'SKBU';
$postkommune{'2645'} = '0519'; $kategori{'2645'} = 'P'; $poststed{'2645'} = 'SR-FRON';
$postkommune{'2646'} = '0519'; $kategori{'2646'} = 'G'; $poststed{'2646'} = 'GL';
$postkommune{'2647'} = '0519'; $kategori{'2647'} = 'G'; $poststed{'2647'} = 'SR-FRON';
$postkommune{'2648'} = '0519'; $kategori{'2648'} = 'P'; $poststed{'2648'} = 'SR-FRON';
$postkommune{'2649'} = '0522'; $kategori{'2649'} = 'P'; $poststed{'2649'} = 'STRE GAUSDAL';
$postkommune{'2651'} = '0522'; $kategori{'2651'} = 'G'; $poststed{'2651'} = 'STRE GAUSDAL';
$postkommune{'2652'} = '0522'; $kategori{'2652'} = 'G'; $poststed{'2652'} = 'SVINGVOLL';
$postkommune{'2653'} = '0522'; $kategori{'2653'} = 'B'; $poststed{'2653'} = 'VESTRE GAUSDAL';
$postkommune{'2656'} = '0522'; $kategori{'2656'} = 'B'; $poststed{'2656'} = 'FOLLEBU';
$postkommune{'2657'} = '0522'; $kategori{'2657'} = 'G'; $poststed{'2657'} = 'SVATSUM';
$postkommune{'2658'} = '0519'; $kategori{'2658'} = 'G'; $poststed{'2658'} = 'ESPEDALEN';
$postkommune{'2659'} = '0511'; $kategori{'2659'} = 'P'; $poststed{'2659'} = 'DOMBS';
$postkommune{'2660'} = '0511'; $kategori{'2660'} = 'G'; $poststed{'2660'} = 'DOMBS';
$postkommune{'2661'} = '0511'; $kategori{'2661'} = 'G'; $poststed{'2661'} = 'HJERKINN';
$postkommune{'2662'} = '0511'; $kategori{'2662'} = 'G'; $poststed{'2662'} = 'DOVRE';
$postkommune{'2663'} = '0511'; $kategori{'2663'} = 'G'; $poststed{'2663'} = 'DOVRESKOGEN';
$postkommune{'2664'} = '0511'; $kategori{'2664'} = 'P'; $poststed{'2664'} = 'DOVRE';
$postkommune{'2665'} = '0512'; $kategori{'2665'} = 'B'; $poststed{'2665'} = 'LESJA';
$postkommune{'2666'} = '0512'; $kategori{'2666'} = 'G'; $poststed{'2666'} = 'LORA';
$postkommune{'2667'} = '0512'; $kategori{'2667'} = 'G'; $poststed{'2667'} = 'LESJAVERK';
$postkommune{'2668'} = '0512'; $kategori{'2668'} = 'G'; $poststed{'2668'} = 'LESJASKOG';
$postkommune{'2669'} = '0512'; $kategori{'2669'} = 'G'; $poststed{'2669'} = 'BJORLI';
$postkommune{'2670'} = '0517'; $kategori{'2670'} = 'G'; $poststed{'2670'} = 'OTTA';
$postkommune{'2672'} = '0517'; $kategori{'2672'} = 'B'; $poststed{'2672'} = 'SEL';
$postkommune{'2673'} = '0517'; $kategori{'2673'} = 'G'; $poststed{'2673'} = 'HVRINGEN';
$postkommune{'2674'} = '0517'; $kategori{'2674'} = 'G'; $poststed{'2674'} = 'MYSUSTER';
$postkommune{'2675'} = '0517'; $kategori{'2675'} = 'P'; $poststed{'2675'} = 'OTTA';
$postkommune{'2676'} = '0517'; $kategori{'2676'} = 'B'; $poststed{'2676'} = 'HEIDAL';
$postkommune{'2677'} = '0517'; $kategori{'2677'} = 'G'; $poststed{'2677'} = 'NEDRE HEIDAL';
$postkommune{'2680'} = '0515'; $kategori{'2680'} = 'G'; $poststed{'2680'} = 'VG';
$postkommune{'2682'} = '0515'; $kategori{'2682'} = 'B'; $poststed{'2682'} = 'LALM';
$postkommune{'2683'} = '0515'; $kategori{'2683'} = 'G'; $poststed{'2683'} = 'TESSANDEN';
$postkommune{'2684'} = '0515'; $kategori{'2684'} = 'P'; $poststed{'2684'} = 'VG';
$postkommune{'2685'} = '0514'; $kategori{'2685'} = 'G'; $poststed{'2685'} = 'GARMO';
$postkommune{'2686'} = '0514'; $kategori{'2686'} = 'G'; $poststed{'2686'} = 'LOM';
$postkommune{'2687'} = '0514'; $kategori{'2687'} = 'G'; $poststed{'2687'} = 'BVERDALEN';
$postkommune{'2688'} = '0514'; $kategori{'2688'} = 'P'; $poststed{'2688'} = 'LOM';
$postkommune{'2690'} = '0513'; $kategori{'2690'} = 'G'; $poststed{'2690'} = 'SKJK';
$postkommune{'2693'} = '0513'; $kategori{'2693'} = 'G'; $poststed{'2693'} = 'NORDBERG';
$postkommune{'2694'} = '0513'; $kategori{'2694'} = 'P'; $poststed{'2694'} = 'SKJK';
$postkommune{'2695'} = '0513'; $kategori{'2695'} = 'G'; $poststed{'2695'} = 'GROTLI';
$postkommune{'2711'} = '0534'; $kategori{'2711'} = 'P'; $poststed{'2711'} = 'GRAN';
$postkommune{'2712'} = '0534'; $kategori{'2712'} = 'P'; $poststed{'2712'} = 'BRANDBU';
$postkommune{'2713'} = '0533'; $kategori{'2713'} = 'P'; $poststed{'2713'} = 'ROA';
$postkommune{'2714'} = '0534'; $kategori{'2714'} = 'P'; $poststed{'2714'} = 'JAREN';
$postkommune{'2715'} = '0533'; $kategori{'2715'} = 'P'; $poststed{'2715'} = 'LUNNER';
$postkommune{'2716'} = '0533'; $kategori{'2716'} = 'P'; $poststed{'2716'} = 'HARESTUA';
$postkommune{'2717'} = '0533'; $kategori{'2717'} = 'P'; $poststed{'2717'} = 'GRUA';
$postkommune{'2718'} = '0534'; $kategori{'2718'} = 'P'; $poststed{'2718'} = 'BRANDBU';
$postkommune{'2720'} = '0533'; $kategori{'2720'} = 'G'; $poststed{'2720'} = 'GRINDVOLL';
$postkommune{'2730'} = '0533'; $kategori{'2730'} = 'G'; $poststed{'2730'} = 'LUNNER';
$postkommune{'2740'} = '0533'; $kategori{'2740'} = 'G'; $poststed{'2740'} = 'ROA';
$postkommune{'2742'} = '0533'; $kategori{'2742'} = 'G'; $poststed{'2742'} = 'GRUA';
$postkommune{'2743'} = '0533'; $kategori{'2743'} = 'G'; $poststed{'2743'} = 'HARESTUA';
$postkommune{'2750'} = '0534'; $kategori{'2750'} = 'G'; $poststed{'2750'} = 'GRAN';
$postkommune{'2760'} = '0534'; $kategori{'2760'} = 'G'; $poststed{'2760'} = 'BRANDBU';
$postkommune{'2770'} = '0534'; $kategori{'2770'} = 'G'; $poststed{'2770'} = 'JAREN';
$postkommune{'2801'} = '0502'; $kategori{'2801'} = 'P'; $poststed{'2801'} = 'GJVIK';
$postkommune{'2802'} = '0502'; $kategori{'2802'} = 'P'; $poststed{'2802'} = 'GJVIK';
$postkommune{'2803'} = '0502'; $kategori{'2803'} = 'P'; $poststed{'2803'} = 'GJVIK';
$postkommune{'2804'} = '0502'; $kategori{'2804'} = 'P'; $poststed{'2804'} = 'GJVIK';
$postkommune{'2805'} = '0502'; $kategori{'2805'} = 'P'; $poststed{'2805'} = 'GJVIK';
$postkommune{'2806'} = '0502'; $kategori{'2806'} = 'P'; $poststed{'2806'} = 'GJVIK';
$postkommune{'2807'} = '0502'; $kategori{'2807'} = 'P'; $poststed{'2807'} = 'HUNNDALEN';
$postkommune{'2808'} = '0502'; $kategori{'2808'} = 'S'; $poststed{'2808'} = 'GJVIK';
$postkommune{'2809'} = '0502'; $kategori{'2809'} = 'S'; $poststed{'2809'} = 'GJVIK';
$postkommune{'2810'} = '0502'; $kategori{'2810'} = 'S'; $poststed{'2810'} = 'GJVIK';
$postkommune{'2811'} = '0502'; $kategori{'2811'} = 'P'; $poststed{'2811'} = 'HUNNDALEN';
$postkommune{'2815'} = '0502'; $kategori{'2815'} = 'G'; $poststed{'2815'} = 'GJVIK';
$postkommune{'2816'} = '0502'; $kategori{'2816'} = 'G'; $poststed{'2816'} = 'GJVIK';
$postkommune{'2817'} = '0502'; $kategori{'2817'} = 'G'; $poststed{'2817'} = 'GJVIK';
$postkommune{'2818'} = '0502'; $kategori{'2818'} = 'G'; $poststed{'2818'} = 'GJVIK';
$postkommune{'2819'} = '0502'; $kategori{'2819'} = 'B'; $poststed{'2819'} = 'GJVIK';
$postkommune{'2821'} = '0502'; $kategori{'2821'} = 'G'; $poststed{'2821'} = 'GJVIK';
$postkommune{'2822'} = '0502'; $kategori{'2822'} = 'G'; $poststed{'2822'} = 'BYBRUA';
$postkommune{'2825'} = '0502'; $kategori{'2825'} = 'G'; $poststed{'2825'} = 'GJVIK';
$postkommune{'2827'} = '0502'; $kategori{'2827'} = 'G'; $poststed{'2827'} = 'HUNNDALEN';
$postkommune{'2830'} = '0529'; $kategori{'2830'} = 'G'; $poststed{'2830'} = 'RAUFOSS';
$postkommune{'2831'} = '0529'; $kategori{'2831'} = 'P'; $poststed{'2831'} = 'RAUFOSS';
$postkommune{'2832'} = '0502'; $kategori{'2832'} = 'P'; $poststed{'2832'} = 'BIRI';
$postkommune{'2836'} = '0502'; $kategori{'2836'} = 'B'; $poststed{'2836'} = 'BIRI';
$postkommune{'2837'} = '0502'; $kategori{'2837'} = 'G'; $poststed{'2837'} = 'BIRISTRAND';
$postkommune{'2838'} = '0502'; $kategori{'2838'} = 'B'; $poststed{'2838'} = 'SNERTINGDAL';
$postkommune{'2839'} = '0502'; $kategori{'2839'} = 'G'; $poststed{'2839'} = 'VRE SNERTINGDAL';
$postkommune{'2840'} = '0529'; $kategori{'2840'} = 'G'; $poststed{'2840'} = 'REINSVOLL';
$postkommune{'2843'} = '0529'; $kategori{'2843'} = 'G'; $poststed{'2843'} = 'EINA';
$postkommune{'2846'} = '0529'; $kategori{'2846'} = 'B'; $poststed{'2846'} = 'BVERBRU';
$postkommune{'2847'} = '0528'; $kategori{'2847'} = 'B'; $poststed{'2847'} = 'KOLBU';
$postkommune{'2848'} = '0528'; $kategori{'2848'} = 'G'; $poststed{'2848'} = 'SKREIA';
$postkommune{'2849'} = '0528'; $kategori{'2849'} = 'G'; $poststed{'2849'} = 'KAPP';
$postkommune{'2850'} = '0528'; $kategori{'2850'} = 'G'; $poststed{'2850'} = 'LENA';
$postkommune{'2851'} = '0528'; $kategori{'2851'} = 'P'; $poststed{'2851'} = 'LENA';
$postkommune{'2853'} = '0529'; $kategori{'2853'} = 'P'; $poststed{'2853'} = 'REINSVOLL';
$postkommune{'2854'} = '0529'; $kategori{'2854'} = 'P'; $poststed{'2854'} = 'EINA';
$postkommune{'2857'} = '0528'; $kategori{'2857'} = 'P'; $poststed{'2857'} = 'SKREIA';
$postkommune{'2858'} = '0528'; $kategori{'2858'} = 'P'; $poststed{'2858'} = 'KAPP';
$postkommune{'2860'} = '0536'; $kategori{'2860'} = 'G'; $poststed{'2860'} = 'HOV';
$postkommune{'2861'} = '0536'; $kategori{'2861'} = 'G'; $poststed{'2861'} = 'LANDSBYGDA';
$postkommune{'2862'} = '0536'; $kategori{'2862'} = 'G'; $poststed{'2862'} = 'FLUBERG';
$postkommune{'2864'} = '0536'; $kategori{'2864'} = 'G'; $poststed{'2864'} = 'FALL';
$postkommune{'2866'} = '0536'; $kategori{'2866'} = 'G'; $poststed{'2866'} = 'ENGER';
$postkommune{'2867'} = '0536'; $kategori{'2867'} = 'P'; $poststed{'2867'} = 'HOV';
$postkommune{'2870'} = '0538'; $kategori{'2870'} = 'G'; $poststed{'2870'} = 'DOKKA';
$postkommune{'2879'} = '0536'; $kategori{'2879'} = 'G'; $poststed{'2879'} = 'ODNES';
$postkommune{'2880'} = '0538'; $kategori{'2880'} = 'B'; $poststed{'2880'} = 'NORD-TORPA';
$postkommune{'2881'} = '0538'; $kategori{'2881'} = 'G'; $poststed{'2881'} = 'AUST-TORPA';
$postkommune{'2882'} = '0538'; $kategori{'2882'} = 'P'; $poststed{'2882'} = 'DOKKA';
$postkommune{'2890'} = '0541'; $kategori{'2890'} = 'G'; $poststed{'2890'} = 'ETNEDAL';
$postkommune{'2893'} = '0541'; $kategori{'2893'} = 'P'; $poststed{'2893'} = 'ETNEDAL';
$postkommune{'2900'} = '0542'; $kategori{'2900'} = 'G'; $poststed{'2900'} = 'FAGERNES';
$postkommune{'2901'} = '0542'; $kategori{'2901'} = 'P'; $poststed{'2901'} = 'FAGERNES';
$postkommune{'2907'} = '0542'; $kategori{'2907'} = 'P'; $poststed{'2907'} = 'LEIRA I VALDRES';
$postkommune{'2910'} = '0542'; $kategori{'2910'} = 'B'; $poststed{'2910'} = 'AURDAL';
$postkommune{'2917'} = '0542'; $kategori{'2917'} = 'G'; $poststed{'2917'} = 'SKRAUTVL';
$postkommune{'2918'} = '0542'; $kategori{'2918'} = 'G'; $poststed{'2918'} = 'ULNES';
$postkommune{'2920'} = '0542'; $kategori{'2920'} = 'G'; $poststed{'2920'} = 'LEIRA I VALDRES';
$postkommune{'2923'} = '0542'; $kategori{'2923'} = 'G'; $poststed{'2923'} = 'TISLEIDALEN';
$postkommune{'2929'} = '0540'; $kategori{'2929'} = 'P'; $poststed{'2929'} = 'BAGN';
$postkommune{'2930'} = '0540'; $kategori{'2930'} = 'G'; $poststed{'2930'} = 'BAGN';
$postkommune{'2933'} = '0540'; $kategori{'2933'} = 'G'; $poststed{'2933'} = 'REINLI';
$postkommune{'2936'} = '0540'; $kategori{'2936'} = 'G'; $poststed{'2936'} = 'BEGNADALEN';
$postkommune{'2937'} = '0540'; $kategori{'2937'} = 'G'; $poststed{'2937'} = 'BEGNA';
$postkommune{'2939'} = '0544'; $kategori{'2939'} = 'P'; $poststed{'2939'} = 'HEGGENES';
$postkommune{'2940'} = '0544'; $kategori{'2940'} = 'G'; $poststed{'2940'} = 'HEGGENES';
$postkommune{'2943'} = '0544'; $kategori{'2943'} = 'G'; $poststed{'2943'} = 'ROGNE';
$postkommune{'2950'} = '0544'; $kategori{'2950'} = 'G'; $poststed{'2950'} = 'SKAMMESTEIN';
$postkommune{'2952'} = '0544'; $kategori{'2952'} = 'G'; $poststed{'2952'} = 'BEITO';
$postkommune{'2953'} = '0544'; $kategori{'2953'} = 'B'; $poststed{'2953'} = 'BEITOSTLEN';
$postkommune{'2959'} = '0543'; $kategori{'2959'} = 'P'; $poststed{'2959'} = 'RN';
$postkommune{'2960'} = '0543'; $kategori{'2960'} = 'G'; $poststed{'2960'} = 'RN';
$postkommune{'2966'} = '0543'; $kategori{'2966'} = 'B'; $poststed{'2966'} = 'SLIDRE';
$postkommune{'2967'} = '0543'; $kategori{'2967'} = 'G'; $poststed{'2967'} = 'LOMEN';
$postkommune{'2973'} = '0545'; $kategori{'2973'} = 'B'; $poststed{'2973'} = 'RYFOSS';
$postkommune{'2974'} = '0545'; $kategori{'2974'} = 'P'; $poststed{'2974'} = 'VANG I VALDRES';
$postkommune{'2975'} = '0545'; $kategori{'2975'} = 'G'; $poststed{'2975'} = 'VANG I VALDRES';
$postkommune{'2977'} = '0545'; $kategori{'2977'} = 'G'; $poststed{'2977'} = 'YE';
$postkommune{'2985'} = '0545'; $kategori{'2985'} = 'G'; $poststed{'2985'} = 'TYINKRYSSET';
$postkommune{'3001'} = '0602'; $kategori{'3001'} = 'P'; $poststed{'3001'} = 'DRAMMEN';
$postkommune{'3002'} = '0602'; $kategori{'3002'} = 'P'; $poststed{'3002'} = 'DRAMMEN';
$postkommune{'3003'} = '0602'; $kategori{'3003'} = 'P'; $poststed{'3003'} = 'DRAMMEN';
$postkommune{'3004'} = '0602'; $kategori{'3004'} = 'F'; $poststed{'3004'} = 'DRAMMEN';
$postkommune{'3005'} = '0602'; $kategori{'3005'} = 'P'; $poststed{'3005'} = 'DRAMMEN';
$postkommune{'3006'} = '0602'; $kategori{'3006'} = 'P'; $poststed{'3006'} = 'DRAMMEN';
$postkommune{'3007'} = '0602'; $kategori{'3007'} = 'P'; $poststed{'3007'} = 'DRAMMEN';
$postkommune{'3008'} = '0602'; $kategori{'3008'} = 'F'; $poststed{'3008'} = 'DRAMMEN';
$postkommune{'3011'} = '0602'; $kategori{'3011'} = 'G'; $poststed{'3011'} = 'DRAMMEN';
$postkommune{'3012'} = '0602'; $kategori{'3012'} = 'G'; $poststed{'3012'} = 'DRAMMEN';
$postkommune{'3013'} = '0602'; $kategori{'3013'} = 'G'; $poststed{'3013'} = 'DRAMMEN';
$postkommune{'3014'} = '0602'; $kategori{'3014'} = 'G'; $poststed{'3014'} = 'DRAMMEN';
$postkommune{'3015'} = '0602'; $kategori{'3015'} = 'G'; $poststed{'3015'} = 'DRAMMEN';
$postkommune{'3016'} = '0602'; $kategori{'3016'} = 'G'; $poststed{'3016'} = 'DRAMMEN';
$postkommune{'3017'} = '0602'; $kategori{'3017'} = 'G'; $poststed{'3017'} = 'DRAMMEN';
$postkommune{'3018'} = '0602'; $kategori{'3018'} = 'G'; $poststed{'3018'} = 'DRAMMEN';
$postkommune{'3019'} = '0602'; $kategori{'3019'} = 'G'; $poststed{'3019'} = 'DRAMMEN';
$postkommune{'3020'} = '0602'; $kategori{'3020'} = 'K'; $poststed{'3020'} = 'DRAMMEN';
$postkommune{'3021'} = '0602'; $kategori{'3021'} = 'G'; $poststed{'3021'} = 'DRAMMEN';
$postkommune{'3022'} = '0602'; $kategori{'3022'} = 'G'; $poststed{'3022'} = 'DRAMMEN';
$postkommune{'3023'} = '0602'; $kategori{'3023'} = 'B'; $poststed{'3023'} = 'DRAMMEN';
$postkommune{'3024'} = '0602'; $kategori{'3024'} = 'B'; $poststed{'3024'} = 'DRAMMEN';
$postkommune{'3025'} = '0602'; $kategori{'3025'} = 'G'; $poststed{'3025'} = 'DRAMMEN';
$postkommune{'3026'} = '0602'; $kategori{'3026'} = 'G'; $poststed{'3026'} = 'DRAMMEN';
$postkommune{'3027'} = '0602'; $kategori{'3027'} = 'G'; $poststed{'3027'} = 'DRAMMEN';
$postkommune{'3028'} = '0602'; $kategori{'3028'} = 'B'; $poststed{'3028'} = 'DRAMMEN';
$postkommune{'3029'} = '0602'; $kategori{'3029'} = 'G'; $poststed{'3029'} = 'DRAMMEN';
$postkommune{'3030'} = '0602'; $kategori{'3030'} = 'G'; $poststed{'3030'} = 'DRAMMEN';
$postkommune{'3031'} = '0602'; $kategori{'3031'} = 'G'; $poststed{'3031'} = 'DRAMMEN';
$postkommune{'3032'} = '0602'; $kategori{'3032'} = 'G'; $poststed{'3032'} = 'DRAMMEN';
$postkommune{'3033'} = '0602'; $kategori{'3033'} = 'G'; $poststed{'3033'} = 'DRAMMEN';
$postkommune{'3034'} = '0602'; $kategori{'3034'} = 'B'; $poststed{'3034'} = 'DRAMMEN';
$postkommune{'3035'} = '0602'; $kategori{'3035'} = 'G'; $poststed{'3035'} = 'DRAMMEN';
$postkommune{'3036'} = '0602'; $kategori{'3036'} = 'G'; $poststed{'3036'} = 'DRAMMEN';
$postkommune{'3037'} = '0602'; $kategori{'3037'} = 'G'; $poststed{'3037'} = 'DRAMMEN';
$postkommune{'3038'} = '0602'; $kategori{'3038'} = 'B'; $poststed{'3038'} = 'DRAMMEN';
$postkommune{'3039'} = '0602'; $kategori{'3039'} = 'G'; $poststed{'3039'} = 'DRAMMEN';
$postkommune{'3040'} = '0602'; $kategori{'3040'} = 'G'; $poststed{'3040'} = 'DRAMMEN';
$postkommune{'3041'} = '0602'; $kategori{'3041'} = 'G'; $poststed{'3041'} = 'DRAMMEN';
$postkommune{'3042'} = '0602'; $kategori{'3042'} = 'G'; $poststed{'3042'} = 'DRAMMEN';
$postkommune{'3043'} = '0602'; $kategori{'3043'} = 'G'; $poststed{'3043'} = 'DRAMMEN';
$postkommune{'3044'} = '0602'; $kategori{'3044'} = 'G'; $poststed{'3044'} = 'DRAMMEN';
$postkommune{'3045'} = '0602'; $kategori{'3045'} = 'G'; $poststed{'3045'} = 'DRAMMEN';
$postkommune{'3046'} = '0602'; $kategori{'3046'} = 'G'; $poststed{'3046'} = 'DRAMMEN';
$postkommune{'3047'} = '0602'; $kategori{'3047'} = 'G'; $poststed{'3047'} = 'DRAMMEN';
$postkommune{'3048'} = '0602'; $kategori{'3048'} = 'G'; $poststed{'3048'} = 'DRAMMEN';
$postkommune{'3050'} = '0625'; $kategori{'3050'} = 'G'; $poststed{'3050'} = 'MJNDALEN';
$postkommune{'3051'} = '0625'; $kategori{'3051'} = 'P'; $poststed{'3051'} = 'MJNDALEN';
$postkommune{'3053'} = '0625'; $kategori{'3053'} = 'G'; $poststed{'3053'} = 'STEINBERG';
$postkommune{'3054'} = '0625'; $kategori{'3054'} = 'P'; $poststed{'3054'} = 'KROKSTADELVA';
$postkommune{'3055'} = '0625'; $kategori{'3055'} = 'G'; $poststed{'3055'} = 'KROKSTADELVA';
$postkommune{'3056'} = '0625'; $kategori{'3056'} = 'P'; $poststed{'3056'} = 'SOLBERGELVA';
$postkommune{'3057'} = '0625'; $kategori{'3057'} = 'G'; $poststed{'3057'} = 'SOLBERGELVA';
$postkommune{'3058'} = '0625'; $kategori{'3058'} = 'G'; $poststed{'3058'} = 'SOLBERGMOEN';
$postkommune{'3060'} = '0711'; $kategori{'3060'} = 'G'; $poststed{'3060'} = 'SVELVIK';
$postkommune{'3061'} = '0711'; $kategori{'3061'} = 'P'; $poststed{'3061'} = 'SVELVIK';
$postkommune{'3070'} = '0713'; $kategori{'3070'} = 'G'; $poststed{'3070'} = 'SANDE I VESTFOLD';
$postkommune{'3071'} = '0713'; $kategori{'3071'} = 'P'; $poststed{'3071'} = 'SANDE I VESTFOLD';
$postkommune{'3075'} = '0711'; $kategori{'3075'} = 'G'; $poststed{'3075'} = 'BERGER';
$postkommune{'3080'} = '0702'; $kategori{'3080'} = 'G'; $poststed{'3080'} = 'HOLMESTRAND';
$postkommune{'3081'} = '0702'; $kategori{'3081'} = 'P'; $poststed{'3081'} = 'HOLMESTRAND';
$postkommune{'3087'} = '0702'; $kategori{'3087'} = 'P'; $poststed{'3087'} = 'BOTNE';
$postkommune{'3088'} = '0702'; $kategori{'3088'} = 'P'; $poststed{'3088'} = 'BOTNE';
$postkommune{'3090'} = '0714'; $kategori{'3090'} = 'B'; $poststed{'3090'} = 'HOF';
$postkommune{'3092'} = '0714'; $kategori{'3092'} = 'G'; $poststed{'3092'} = 'SUNDBYFOSS';
$postkommune{'3095'} = '0714'; $kategori{'3095'} = 'B'; $poststed{'3095'} = 'EIDSFOSS';
$postkommune{'3101'} = '0704'; $kategori{'3101'} = 'P'; $poststed{'3101'} = 'TNSBERG';
$postkommune{'3103'} = '0704'; $kategori{'3103'} = 'P'; $poststed{'3103'} = 'TNSBERG';
$postkommune{'3104'} = '0704'; $kategori{'3104'} = 'P'; $poststed{'3104'} = 'TNSBERG';
$postkommune{'3105'} = '0704'; $kategori{'3105'} = 'P'; $poststed{'3105'} = 'TNSBERG';
$postkommune{'3106'} = '0722'; $kategori{'3106'} = 'P'; $poststed{'3106'} = 'TNSBERG';
$postkommune{'3107'} = '0704'; $kategori{'3107'} = 'P'; $poststed{'3107'} = 'SEM';
$postkommune{'3108'} = '0720'; $kategori{'3108'} = 'P'; $poststed{'3108'} = 'VEAR';
$postkommune{'3109'} = '0704'; $kategori{'3109'} = 'P'; $poststed{'3109'} = 'TNSBERG';
$postkommune{'3110'} = '0704'; $kategori{'3110'} = 'G'; $poststed{'3110'} = 'TNSBERG';
$postkommune{'3111'} = '0704'; $kategori{'3111'} = 'G'; $poststed{'3111'} = 'TNSBERG';
$postkommune{'3112'} = '0704'; $kategori{'3112'} = 'G'; $poststed{'3112'} = 'TNSBERG';
$postkommune{'3113'} = '0704'; $kategori{'3113'} = 'B'; $poststed{'3113'} = 'TNSBERG';
$postkommune{'3114'} = '0704'; $kategori{'3114'} = 'G'; $poststed{'3114'} = 'TNSBERG';
$postkommune{'3115'} = '0722'; $kategori{'3115'} = 'G'; $poststed{'3115'} = 'TNSBERG';
$postkommune{'3116'} = '0704'; $kategori{'3116'} = 'G'; $poststed{'3116'} = 'TNSBERG';
$postkommune{'3117'} = '0704'; $kategori{'3117'} = 'G'; $poststed{'3117'} = 'TNSBERG';
$postkommune{'3118'} = '0704'; $kategori{'3118'} = 'G'; $poststed{'3118'} = 'TNSBERG';
$postkommune{'3119'} = '0704'; $kategori{'3119'} = 'P'; $poststed{'3119'} = 'TNSBERG';
$postkommune{'3120'} = '0722'; $kategori{'3120'} = 'G'; $poststed{'3120'} = 'TNSBERG';
$postkommune{'3121'} = '0722'; $kategori{'3121'} = 'G'; $poststed{'3121'} = 'TNSBERG';
$postkommune{'3122'} = '0704'; $kategori{'3122'} = 'G'; $poststed{'3122'} = 'TNSBERG';
$postkommune{'3123'} = '0704'; $kategori{'3123'} = 'G'; $poststed{'3123'} = 'TNSBERG';
$postkommune{'3124'} = '0704'; $kategori{'3124'} = 'G'; $poststed{'3124'} = 'TNSBERG';
$postkommune{'3125'} = '0704'; $kategori{'3125'} = 'G'; $poststed{'3125'} = 'TNSBERG';
$postkommune{'3126'} = '0704'; $kategori{'3126'} = 'G'; $poststed{'3126'} = 'TNSBERG';
$postkommune{'3131'} = '0722'; $kategori{'3131'} = 'P'; $poststed{'3131'} = 'HUSYSUND';
$postkommune{'3132'} = '0722'; $kategori{'3132'} = 'G'; $poststed{'3132'} = 'HUSYSUND';
$postkommune{'3133'} = '0722'; $kategori{'3133'} = 'G'; $poststed{'3133'} = 'DUKEN';
$postkommune{'3135'} = '0722'; $kategori{'3135'} = 'G'; $poststed{'3135'} = 'TORD';
$postkommune{'3137'} = '0722'; $kategori{'3137'} = 'P'; $poststed{'3137'} = 'TORD';
$postkommune{'3138'} = '0722'; $kategori{'3138'} = 'B'; $poststed{'3138'} = 'SKALLESTAD';
$postkommune{'3140'} = '0722'; $kategori{'3140'} = 'G'; $poststed{'3140'} = 'BORGHEIM';
$postkommune{'3141'} = '0722'; $kategori{'3141'} = 'P'; $poststed{'3141'} = 'KJPMANNSKJR';
$postkommune{'3142'} = '0722'; $kategori{'3142'} = 'G'; $poststed{'3142'} = 'VESTSKOGEN';
$postkommune{'3143'} = '0722'; $kategori{'3143'} = 'G'; $poststed{'3143'} = 'KJPMANNSKJR';
$postkommune{'3144'} = '0722'; $kategori{'3144'} = 'B'; $poststed{'3144'} = 'VEIERLAND';
$postkommune{'3145'} = '0723'; $kategori{'3145'} = 'G'; $poststed{'3145'} = 'TJME';
$postkommune{'3147'} = '0723'; $kategori{'3147'} = 'G'; $poststed{'3147'} = 'VERDENS ENDE';
$postkommune{'3148'} = '0723'; $kategori{'3148'} = 'G'; $poststed{'3148'} = 'HVASSER';
$postkommune{'3150'} = '0704'; $kategori{'3150'} = 'G'; $poststed{'3150'} = 'TOLVSRD';
$postkommune{'3151'} = '0704'; $kategori{'3151'} = 'G'; $poststed{'3151'} = 'TOLVSRD';
$postkommune{'3152'} = '0704'; $kategori{'3152'} = 'G'; $poststed{'3152'} = 'TOLVSRD';
$postkommune{'3153'} = '0704'; $kategori{'3153'} = 'G'; $poststed{'3153'} = 'TOLVSRD';
$postkommune{'3154'} = '0704'; $kategori{'3154'} = 'G'; $poststed{'3154'} = 'TOLVSRD';
$postkommune{'3157'} = '0704'; $kategori{'3157'} = 'G'; $poststed{'3157'} = 'BARKKER';
$postkommune{'3158'} = '0719'; $kategori{'3158'} = 'G'; $poststed{'3158'} = 'ANDEBU';
$postkommune{'3159'} = '0720'; $kategori{'3159'} = 'B'; $poststed{'3159'} = 'MELSOMVIK';
$postkommune{'3160'} = '0720'; $kategori{'3160'} = 'G'; $poststed{'3160'} = 'STOKKE';
$postkommune{'3161'} = '0720'; $kategori{'3161'} = 'P'; $poststed{'3161'} = 'STOKKE';
$postkommune{'3162'} = '0719'; $kategori{'3162'} = 'P'; $poststed{'3162'} = 'ANDEBU';
$postkommune{'3163'} = '0722'; $kategori{'3163'} = 'P'; $poststed{'3163'} = 'BORGHEIM';
$postkommune{'3164'} = '0716'; $kategori{'3164'} = 'P'; $poststed{'3164'} = 'REVETAL';
$postkommune{'3165'} = '0723'; $kategori{'3165'} = 'P'; $poststed{'3165'} = 'TJME';
$postkommune{'3166'} = '0704'; $kategori{'3166'} = 'P'; $poststed{'3166'} = 'TOLVSRD';
$postkommune{'3167'} = '0701'; $kategori{'3167'} = 'P'; $poststed{'3167'} = 'SGRDSTRAND';
$postkommune{'3168'} = '0720'; $kategori{'3168'} = 'P'; $poststed{'3168'} = 'MELSOMVIK';
$postkommune{'3169'} = '0720'; $kategori{'3169'} = 'K'; $poststed{'3169'} = 'STOKKE';
$postkommune{'3170'} = '0704'; $kategori{'3170'} = 'G'; $poststed{'3170'} = 'SEM';
$postkommune{'3171'} = '0704'; $kategori{'3171'} = 'G'; $poststed{'3171'} = 'SEM';
$postkommune{'3172'} = '0704'; $kategori{'3172'} = 'G'; $poststed{'3172'} = 'VEAR';
$postkommune{'3173'} = '0720'; $kategori{'3173'} = 'G'; $poststed{'3173'} = 'VEAR';
$postkommune{'3174'} = '0716'; $kategori{'3174'} = 'G'; $poststed{'3174'} = 'REVETAL';
$postkommune{'3175'} = '0716'; $kategori{'3175'} = 'G'; $poststed{'3175'} = 'RAMNES';
$postkommune{'3177'} = '0716'; $kategori{'3177'} = 'P'; $poststed{'3177'} = 'VLE';
$postkommune{'3178'} = '0716'; $kategori{'3178'} = 'G'; $poststed{'3178'} = 'VLE';
$postkommune{'3179'} = '0701'; $kategori{'3179'} = 'G'; $poststed{'3179'} = 'SGRDSTRAND';
$postkommune{'3180'} = '0701'; $kategori{'3180'} = 'B'; $poststed{'3180'} = 'NYKIRKE';
$postkommune{'3181'} = '0701'; $kategori{'3181'} = 'G'; $poststed{'3181'} = 'HORTEN';
$postkommune{'3182'} = '0701'; $kategori{'3182'} = 'G'; $poststed{'3182'} = 'HORTEN';
$postkommune{'3183'} = '0701'; $kategori{'3183'} = 'G'; $poststed{'3183'} = 'HORTEN';
$postkommune{'3184'} = '0701'; $kategori{'3184'} = 'B'; $poststed{'3184'} = 'BORRE';
$postkommune{'3185'} = '0701'; $kategori{'3185'} = 'G'; $poststed{'3185'} = 'SKOPPUM';
$postkommune{'3186'} = '0701'; $kategori{'3186'} = 'G'; $poststed{'3186'} = 'HORTEN';
$postkommune{'3187'} = '0701'; $kategori{'3187'} = 'G'; $poststed{'3187'} = 'HORTEN';
$postkommune{'3188'} = '0701'; $kategori{'3188'} = 'G'; $poststed{'3188'} = 'HORTEN';
$postkommune{'3189'} = '0701'; $kategori{'3189'} = 'G'; $poststed{'3189'} = 'HORTEN';
$postkommune{'3191'} = '0701'; $kategori{'3191'} = 'P'; $poststed{'3191'} = 'HORTEN';
$postkommune{'3192'} = '0701'; $kategori{'3192'} = 'P'; $poststed{'3192'} = 'HORTEN';
$postkommune{'3193'} = '0701'; $kategori{'3193'} = 'P'; $poststed{'3193'} = 'HORTEN';
$postkommune{'3194'} = '0701'; $kategori{'3194'} = 'P'; $poststed{'3194'} = 'HORTEN';
$postkommune{'3195'} = '0701'; $kategori{'3195'} = 'P'; $poststed{'3195'} = 'SKOPPUM';
$postkommune{'3196'} = '0701'; $kategori{'3196'} = 'P'; $poststed{'3196'} = 'HORTEN';
$postkommune{'3197'} = '0701'; $kategori{'3197'} = 'K'; $poststed{'3197'} = 'HORTEN';
$postkommune{'3201'} = '0706'; $kategori{'3201'} = 'P'; $poststed{'3201'} = 'SANDEFJORD';
$postkommune{'3202'} = '0706'; $kategori{'3202'} = 'P'; $poststed{'3202'} = 'SANDEFJORD';
$postkommune{'3203'} = '0706'; $kategori{'3203'} = 'P'; $poststed{'3203'} = 'SANDEFJORD';
$postkommune{'3204'} = '0706'; $kategori{'3204'} = 'P'; $poststed{'3204'} = 'SANDEFJORD';
$postkommune{'3205'} = '0706'; $kategori{'3205'} = 'P'; $poststed{'3205'} = 'SANDEFJORD';
$postkommune{'3206'} = '0706'; $kategori{'3206'} = 'P'; $poststed{'3206'} = 'SANDEFJORD';
$postkommune{'3207'} = '0706'; $kategori{'3207'} = 'P'; $poststed{'3207'} = 'SANDEFJORD';
$postkommune{'3208'} = '0706'; $kategori{'3208'} = 'G'; $poststed{'3208'} = 'SANDEFJORD';
$postkommune{'3209'} = '0706'; $kategori{'3209'} = 'B'; $poststed{'3209'} = 'SANDEFJORD';
$postkommune{'3210'} = '0706'; $kategori{'3210'} = 'G'; $poststed{'3210'} = 'SANDEFJORD';
$postkommune{'3211'} = '0706'; $kategori{'3211'} = 'G'; $poststed{'3211'} = 'SANDEFJORD';
$postkommune{'3212'} = '0706'; $kategori{'3212'} = 'G'; $poststed{'3212'} = 'SANDEFJORD';
$postkommune{'3213'} = '0706'; $kategori{'3213'} = 'G'; $poststed{'3213'} = 'SANDEFJORD';
$postkommune{'3214'} = '0706'; $kategori{'3214'} = 'G'; $poststed{'3214'} = 'SANDEFJORD';
$postkommune{'3215'} = '0706'; $kategori{'3215'} = 'G'; $poststed{'3215'} = 'SANDEFJORD';
$postkommune{'3216'} = '0706'; $kategori{'3216'} = 'G'; $poststed{'3216'} = 'SANDEFJORD';
$postkommune{'3217'} = '0706'; $kategori{'3217'} = 'G'; $poststed{'3217'} = 'SANDEFJORD';
$postkommune{'3218'} = '0706'; $kategori{'3218'} = 'G'; $poststed{'3218'} = 'SANDEFJORD';
$postkommune{'3219'} = '0706'; $kategori{'3219'} = 'G'; $poststed{'3219'} = 'SANDEFJORD';
$postkommune{'3220'} = '0706'; $kategori{'3220'} = 'G'; $poststed{'3220'} = 'SANDEFJORD';
$postkommune{'3221'} = '0706'; $kategori{'3221'} = 'G'; $poststed{'3221'} = 'SANDEFJORD';
$postkommune{'3222'} = '0706'; $kategori{'3222'} = 'G'; $poststed{'3222'} = 'SANDEFJORD';
$postkommune{'3223'} = '0706'; $kategori{'3223'} = 'G'; $poststed{'3223'} = 'SANDEFJORD';
$postkommune{'3224'} = '0706'; $kategori{'3224'} = 'G'; $poststed{'3224'} = 'SANDEFJORD';
$postkommune{'3225'} = '0706'; $kategori{'3225'} = 'G'; $poststed{'3225'} = 'SANDEFJORD';
$postkommune{'3226'} = '0706'; $kategori{'3226'} = 'B'; $poststed{'3226'} = 'SANDEFJORD';
$postkommune{'3227'} = '0706'; $kategori{'3227'} = 'G'; $poststed{'3227'} = 'SANDEFJORD';
$postkommune{'3228'} = '0706'; $kategori{'3228'} = 'G'; $poststed{'3228'} = 'SANDEFJORD';
$postkommune{'3229'} = '0706'; $kategori{'3229'} = 'G'; $poststed{'3229'} = 'SANDEFJORD';
$postkommune{'3230'} = '0706'; $kategori{'3230'} = 'G'; $poststed{'3230'} = 'SANDEFJORD';
$postkommune{'3231'} = '0706'; $kategori{'3231'} = 'G'; $poststed{'3231'} = 'SANDEFJORD';
$postkommune{'3232'} = '0706'; $kategori{'3232'} = 'G'; $poststed{'3232'} = 'SANDEFJORD';
$postkommune{'3233'} = '0706'; $kategori{'3233'} = 'G'; $poststed{'3233'} = 'SANDEFJORD';
$postkommune{'3234'} = '0706'; $kategori{'3234'} = 'G'; $poststed{'3234'} = 'SANDEFJORD';
$postkommune{'3235'} = '0706'; $kategori{'3235'} = 'G'; $poststed{'3235'} = 'SANDEFJORD';
$postkommune{'3236'} = '0706'; $kategori{'3236'} = 'G'; $poststed{'3236'} = 'SANDEFJORD';
$postkommune{'3237'} = '0706'; $kategori{'3237'} = 'G'; $poststed{'3237'} = 'SANDEFJORD';
$postkommune{'3238'} = '0706'; $kategori{'3238'} = 'G'; $poststed{'3238'} = 'SANDEFJORD';
$postkommune{'3239'} = '0706'; $kategori{'3239'} = 'G'; $poststed{'3239'} = 'SANDEFJORD';
$postkommune{'3240'} = '0706'; $kategori{'3240'} = 'P'; $poststed{'3240'} = 'SANDEFJORD';
$postkommune{'3241'} = '0706'; $kategori{'3241'} = 'G'; $poststed{'3241'} = 'SANDEFJORD';
$postkommune{'3242'} = '0706'; $kategori{'3242'} = 'G'; $poststed{'3242'} = 'SANDEFJORD';
$postkommune{'3243'} = '0719'; $kategori{'3243'} = 'G'; $poststed{'3243'} = 'KODAL';
$postkommune{'3244'} = '0706'; $kategori{'3244'} = 'G'; $poststed{'3244'} = 'SANDEFJORD';
$postkommune{'3245'} = '0719'; $kategori{'3245'} = 'P'; $poststed{'3245'} = 'KODAL';
$postkommune{'3246'} = '0706'; $kategori{'3246'} = 'P'; $poststed{'3246'} = 'SANDEFJORD';
$postkommune{'3247'} = '0706'; $kategori{'3247'} = 'K'; $poststed{'3247'} = 'SANDEFJORD';
$postkommune{'3248'} = '0706'; $kategori{'3248'} = 'K'; $poststed{'3248'} = 'SANDEFJORD';
$postkommune{'3251'} = '0709'; $kategori{'3251'} = 'P'; $poststed{'3251'} = 'LARVIK';
$postkommune{'3252'} = '0709'; $kategori{'3252'} = 'P'; $poststed{'3252'} = 'LARVIK';
$postkommune{'3253'} = '0709'; $kategori{'3253'} = 'P'; $poststed{'3253'} = 'LARVIK';
$postkommune{'3254'} = '0709'; $kategori{'3254'} = 'P'; $poststed{'3254'} = 'LARVIK';
$postkommune{'3255'} = '0709'; $kategori{'3255'} = 'P'; $poststed{'3255'} = 'LARVIK';
$postkommune{'3256'} = '0709'; $kategori{'3256'} = 'G'; $poststed{'3256'} = 'LARVIK';
$postkommune{'3257'} = '0709'; $kategori{'3257'} = 'G'; $poststed{'3257'} = 'LARVIK';
$postkommune{'3258'} = '0709'; $kategori{'3258'} = 'G'; $poststed{'3258'} = 'LARVIK';
$postkommune{'3259'} = '0709'; $kategori{'3259'} = 'G'; $poststed{'3259'} = 'LARVIK';
$postkommune{'3260'} = '0709'; $kategori{'3260'} = 'G'; $poststed{'3260'} = 'LARVIK';
$postkommune{'3261'} = '0709'; $kategori{'3261'} = 'G'; $poststed{'3261'} = 'LARVIK';
$postkommune{'3262'} = '0709'; $kategori{'3262'} = 'G'; $poststed{'3262'} = 'LARVIK';
$postkommune{'3263'} = '0709'; $kategori{'3263'} = 'G'; $poststed{'3263'} = 'LARVIK';
$postkommune{'3264'} = '0709'; $kategori{'3264'} = 'G'; $poststed{'3264'} = 'LARVIK';
$postkommune{'3265'} = '0709'; $kategori{'3265'} = 'G'; $poststed{'3265'} = 'LARVIK';
$postkommune{'3267'} = '0709'; $kategori{'3267'} = 'G'; $poststed{'3267'} = 'LARVIK';
$postkommune{'3268'} = '0709'; $kategori{'3268'} = 'G'; $poststed{'3268'} = 'LARVIK';
$postkommune{'3269'} = '0709'; $kategori{'3269'} = 'G'; $poststed{'3269'} = 'LARVIK';
$postkommune{'3270'} = '0709'; $kategori{'3270'} = 'G'; $poststed{'3270'} = 'LARVIK';
$postkommune{'3271'} = '0709'; $kategori{'3271'} = 'G'; $poststed{'3271'} = 'LARVIK';
$postkommune{'3274'} = '0709'; $kategori{'3274'} = 'G'; $poststed{'3274'} = 'LARVIK';
$postkommune{'3275'} = '0728'; $kategori{'3275'} = 'G'; $poststed{'3275'} = 'SVARSTAD';
$postkommune{'3276'} = '0728'; $kategori{'3276'} = 'P'; $poststed{'3276'} = 'SVARSTAD';
$postkommune{'3277'} = '0728'; $kategori{'3277'} = 'G'; $poststed{'3277'} = 'STEINSHOLT';
$postkommune{'3280'} = '0709'; $kategori{'3280'} = 'G'; $poststed{'3280'} = 'TJODALYNG';
$postkommune{'3281'} = '0709'; $kategori{'3281'} = 'P'; $poststed{'3281'} = 'TJODALYNG';
$postkommune{'3282'} = '0709'; $kategori{'3282'} = 'G'; $poststed{'3282'} = 'KVELDE';
$postkommune{'3284'} = '0709'; $kategori{'3284'} = 'P'; $poststed{'3284'} = 'KVELDE';
$postkommune{'3285'} = '0709'; $kategori{'3285'} = 'P'; $poststed{'3285'} = 'LARVIK';
$postkommune{'3290'} = '0709'; $kategori{'3290'} = 'G'; $poststed{'3290'} = 'STAVERN';
$postkommune{'3291'} = '0709'; $kategori{'3291'} = 'P'; $poststed{'3291'} = 'STAVERN';
$postkommune{'3292'} = '0709'; $kategori{'3292'} = 'G'; $poststed{'3292'} = 'STAVERN';
$postkommune{'3294'} = '0709'; $kategori{'3294'} = 'G'; $poststed{'3294'} = 'STAVERN';
$postkommune{'3295'} = '0709'; $kategori{'3295'} = 'G'; $poststed{'3295'} = 'HELGEROA';
$postkommune{'3296'} = '0709'; $kategori{'3296'} = 'G'; $poststed{'3296'} = 'NEVLUNGHAMN';
$postkommune{'3297'} = '0709'; $kategori{'3297'} = 'P'; $poststed{'3297'} = 'HELGEROA';
$postkommune{'3300'} = '0624'; $kategori{'3300'} = 'G'; $poststed{'3300'} = 'HOKKSUND';
$postkommune{'3301'} = '0624'; $kategori{'3301'} = 'P'; $poststed{'3301'} = 'HOKKSUND';
$postkommune{'3320'} = '0624'; $kategori{'3320'} = 'G'; $poststed{'3320'} = 'VESTFOSSEN';
$postkommune{'3321'} = '0624'; $kategori{'3321'} = 'P'; $poststed{'3321'} = 'VESTFOSSEN';
$postkommune{'3322'} = '0624'; $kategori{'3322'} = 'G'; $poststed{'3322'} = 'DARBU';
$postkommune{'3330'} = '0624'; $kategori{'3330'} = 'G'; $poststed{'3330'} = 'SKOTSELV';
$postkommune{'3331'} = '0624'; $kategori{'3331'} = 'P'; $poststed{'3331'} = 'SKOTSELV';
$postkommune{'3340'} = '0623'; $kategori{'3340'} = 'G'; $poststed{'3340'} = 'MOT';
$postkommune{'3341'} = '0623'; $kategori{'3341'} = 'P'; $poststed{'3341'} = 'MOT';
$postkommune{'3342'} = '0623'; $kategori{'3342'} = 'P'; $poststed{'3342'} = 'MOT';
$postkommune{'3350'} = '0621'; $kategori{'3350'} = 'G'; $poststed{'3350'} = 'PRESTFOSS';
$postkommune{'3351'} = '0621'; $kategori{'3351'} = 'P'; $poststed{'3351'} = 'PRESTFOSS';
$postkommune{'3355'} = '0621'; $kategori{'3355'} = 'G'; $poststed{'3355'} = 'SOLUMSMOEN';
$postkommune{'3358'} = '0621'; $kategori{'3358'} = 'G'; $poststed{'3358'} = 'NEDRE EGGEDAL';
$postkommune{'3359'} = '0621'; $kategori{'3359'} = 'B'; $poststed{'3359'} = 'EGGEDAL';
$postkommune{'3360'} = '0623'; $kategori{'3360'} = 'G'; $poststed{'3360'} = 'GEITHUS';
$postkommune{'3361'} = '0623'; $kategori{'3361'} = 'P'; $poststed{'3361'} = 'GEITHUS';
$postkommune{'3370'} = '0623'; $kategori{'3370'} = 'G'; $poststed{'3370'} = 'VIKERSUND';
$postkommune{'3371'} = '0623'; $kategori{'3371'} = 'P'; $poststed{'3371'} = 'VIKERSUND';
$postkommune{'3387'} = '0623'; $kategori{'3387'} = 'G'; $poststed{'3387'} = 'SNARUM';
$postkommune{'3400'} = '0626'; $kategori{'3400'} = 'G'; $poststed{'3400'} = 'LIER';
$postkommune{'3401'} = '0626'; $kategori{'3401'} = 'P'; $poststed{'3401'} = 'LIER';
$postkommune{'3407'} = '0626'; $kategori{'3407'} = 'P'; $poststed{'3407'} = 'TRANBY';
$postkommune{'3408'} = '0626'; $kategori{'3408'} = 'G'; $poststed{'3408'} = 'TRANBY';
$postkommune{'3410'} = '0626'; $kategori{'3410'} = 'G'; $poststed{'3410'} = 'SYLLING';
$postkommune{'3411'} = '0626'; $kategori{'3411'} = 'P'; $poststed{'3411'} = 'SYLLING';
$postkommune{'3412'} = '0626'; $kategori{'3412'} = 'P'; $poststed{'3412'} = 'LIERSTRANDA';
$postkommune{'3420'} = '0626'; $kategori{'3420'} = 'G'; $poststed{'3420'} = 'LIERSKOGEN';
$postkommune{'3421'} = '0626'; $kategori{'3421'} = 'P'; $poststed{'3421'} = 'LIERSKOGEN';
$postkommune{'3425'} = '0626'; $kategori{'3425'} = 'G'; $poststed{'3425'} = 'REISTAD';
$postkommune{'3428'} = '0626'; $kategori{'3428'} = 'P'; $poststed{'3428'} = 'LIER';
$postkommune{'3430'} = '0627'; $kategori{'3430'} = 'G'; $poststed{'3430'} = 'SPIKKESTAD';
$postkommune{'3431'} = '0627'; $kategori{'3431'} = 'P'; $poststed{'3431'} = 'SPIKKESTAD';
$postkommune{'3440'} = '0627'; $kategori{'3440'} = 'G'; $poststed{'3440'} = 'RYKEN';
$postkommune{'3441'} = '0627'; $kategori{'3441'} = 'P'; $poststed{'3441'} = 'RYKEN';
$postkommune{'3442'} = '0627'; $kategori{'3442'} = 'G'; $poststed{'3442'} = 'HYGGEN';
$postkommune{'3470'} = '0627'; $kategori{'3470'} = 'G'; $poststed{'3470'} = 'SLEMMESTAD';
$postkommune{'3471'} = '0627'; $kategori{'3471'} = 'P'; $poststed{'3471'} = 'SLEMMESTAD';
$postkommune{'3472'} = '0627'; $kategori{'3472'} = 'G'; $poststed{'3472'} = 'BDALEN';
$postkommune{'3474'} = '0627'; $kategori{'3474'} = 'G'; $poststed{'3474'} = 'ROS';
$postkommune{'3475'} = '0628'; $kategori{'3475'} = 'G'; $poststed{'3475'} = 'STRE';
$postkommune{'3476'} = '0628'; $kategori{'3476'} = 'P'; $poststed{'3476'} = 'STRE';
$postkommune{'3477'} = '0627'; $kategori{'3477'} = 'G'; $poststed{'3477'} = 'BTST';
$postkommune{'3478'} = '0627'; $kategori{'3478'} = 'B'; $poststed{'3478'} = 'NRSNES';
$postkommune{'3480'} = '0628'; $kategori{'3480'} = 'B'; $poststed{'3480'} = 'FILTVET';
$postkommune{'3481'} = '0628'; $kategori{'3481'} = 'P'; $poststed{'3481'} = 'TOFTE';
$postkommune{'3482'} = '0628'; $kategori{'3482'} = 'G'; $poststed{'3482'} = 'TOFTE';
$postkommune{'3483'} = '0628'; $kategori{'3483'} = 'G'; $poststed{'3483'} = 'KANA';
$postkommune{'3484'} = '0628'; $kategori{'3484'} = 'G'; $poststed{'3484'} = 'HOLMSBU';
$postkommune{'3490'} = '0628'; $kategori{'3490'} = 'G'; $poststed{'3490'} = 'KLOKKARSTUA';
$postkommune{'3491'} = '0628'; $kategori{'3491'} = 'P'; $poststed{'3491'} = 'KLOKKARSTUA';
$postkommune{'3501'} = '0605'; $kategori{'3501'} = 'P'; $poststed{'3501'} = 'HNEFOSS';
$postkommune{'3502'} = '0605'; $kategori{'3502'} = 'P'; $poststed{'3502'} = 'HNEFOSS';
$postkommune{'3503'} = '0605'; $kategori{'3503'} = 'P'; $poststed{'3503'} = 'HNEFOSS';
$postkommune{'3504'} = '0605'; $kategori{'3504'} = 'S'; $poststed{'3504'} = 'HNEFOSS';
$postkommune{'3505'} = '0605'; $kategori{'3505'} = 'K'; $poststed{'3505'} = 'HNEFOSS';
$postkommune{'3506'} = '0605'; $kategori{'3506'} = 'K'; $poststed{'3506'} = 'HNEFOSS';
$postkommune{'3507'} = '0605'; $kategori{'3507'} = 'K'; $poststed{'3507'} = 'HNEFOSS';
$postkommune{'3510'} = '0605'; $kategori{'3510'} = 'G'; $poststed{'3510'} = 'HNEFOSS';
$postkommune{'3511'} = '0605'; $kategori{'3511'} = 'G'; $poststed{'3511'} = 'HNEFOSS';
$postkommune{'3512'} = '0605'; $kategori{'3512'} = 'G'; $poststed{'3512'} = 'HNEFOSS';
$postkommune{'3513'} = '0605'; $kategori{'3513'} = 'G'; $poststed{'3513'} = 'HNEFOSS';
$postkommune{'3514'} = '0605'; $kategori{'3514'} = 'G'; $poststed{'3514'} = 'HNEFOSS';
$postkommune{'3515'} = '0605'; $kategori{'3515'} = 'G'; $poststed{'3515'} = 'HNEFOSS';
$postkommune{'3516'} = '0605'; $kategori{'3516'} = 'G'; $poststed{'3516'} = 'HNEFOSS';
$postkommune{'3517'} = '0605'; $kategori{'3517'} = 'G'; $poststed{'3517'} = 'HNEFOSS';
$postkommune{'3518'} = '0605'; $kategori{'3518'} = 'G'; $poststed{'3518'} = 'HNEFOSS';
$postkommune{'3519'} = '0605'; $kategori{'3519'} = 'G'; $poststed{'3519'} = 'HNEFOSS';
$postkommune{'3520'} = '0532'; $kategori{'3520'} = 'G'; $poststed{'3520'} = 'JEVNAKER';
$postkommune{'3521'} = '0532'; $kategori{'3521'} = 'P'; $poststed{'3521'} = 'JEVNAKER';
$postkommune{'3522'} = '0534'; $kategori{'3522'} = 'G'; $poststed{'3522'} = 'BJONEROA';
$postkommune{'3523'} = '0605'; $kategori{'3523'} = 'P'; $poststed{'3523'} = 'NES I DAL';
$postkommune{'3524'} = '0605'; $kategori{'3524'} = 'G'; $poststed{'3524'} = 'NES I DAL';
$postkommune{'3525'} = '0605'; $kategori{'3525'} = 'G'; $poststed{'3525'} = 'HALLINGBY';
$postkommune{'3526'} = '0605'; $kategori{'3526'} = 'P'; $poststed{'3526'} = 'HALLINGBY';
$postkommune{'3528'} = '0540'; $kategori{'3528'} = 'G'; $poststed{'3528'} = 'HEDALEN';
$postkommune{'3529'} = '0612'; $kategori{'3529'} = 'P'; $poststed{'3529'} = 'RYSE';
$postkommune{'3530'} = '0612'; $kategori{'3530'} = 'G'; $poststed{'3530'} = 'RYSE';
$postkommune{'3531'} = '0612'; $kategori{'3531'} = 'B'; $poststed{'3531'} = 'KROKKLEIVA';
$postkommune{'3533'} = '0605'; $kategori{'3533'} = 'B'; $poststed{'3533'} = 'TYRISTRAND';
$postkommune{'3534'} = '0605'; $kategori{'3534'} = 'B'; $poststed{'3534'} = 'SOKNA';
$postkommune{'3535'} = '0622'; $kategori{'3535'} = 'G'; $poststed{'3535'} = 'KRDEREN';
$postkommune{'3536'} = '0622'; $kategori{'3536'} = 'B'; $poststed{'3536'} = 'NORESUND';
$postkommune{'3537'} = '0622'; $kategori{'3537'} = 'P'; $poststed{'3537'} = 'KRDEREN';
$postkommune{'3538'} = '0612'; $kategori{'3538'} = 'G'; $poststed{'3538'} = 'SOLLIHGDA';
$postkommune{'3539'} = '0615'; $kategori{'3539'} = 'B'; $poststed{'3539'} = 'FL';
$postkommune{'3540'} = '0616'; $kategori{'3540'} = 'G'; $poststed{'3540'} = 'NESBYEN';
$postkommune{'3541'} = '0616'; $kategori{'3541'} = 'P'; $poststed{'3541'} = 'NESBYEN';
$postkommune{'3550'} = '0617'; $kategori{'3550'} = 'G'; $poststed{'3550'} = 'GOL';
$postkommune{'3551'} = '0617'; $kategori{'3551'} = 'P'; $poststed{'3551'} = 'GOL';
$postkommune{'3560'} = '0618'; $kategori{'3560'} = 'G'; $poststed{'3560'} = 'HEMSEDAL';
$postkommune{'3561'} = '0618'; $kategori{'3561'} = 'P'; $poststed{'3561'} = 'HEMSEDAL';
$postkommune{'3570'} = '0619'; $kategori{'3570'} = 'G'; $poststed{'3570'} = 'L';
$postkommune{'3571'} = '0619'; $kategori{'3571'} = 'P'; $poststed{'3571'} = 'L';
$postkommune{'3575'} = '0620'; $kategori{'3575'} = 'P'; $poststed{'3575'} = 'HOL';
$postkommune{'3576'} = '0620'; $kategori{'3576'} = 'G'; $poststed{'3576'} = 'HOL';
$postkommune{'3577'} = '0620'; $kategori{'3577'} = 'G'; $poststed{'3577'} = 'HOVET';
$postkommune{'3579'} = '0619'; $kategori{'3579'} = 'G'; $poststed{'3579'} = 'TORPO';
$postkommune{'3580'} = '0620'; $kategori{'3580'} = 'G'; $poststed{'3580'} = 'GEILO';
$postkommune{'3581'} = '0620'; $kategori{'3581'} = 'P'; $poststed{'3581'} = 'GEILO';
$postkommune{'3593'} = '0620'; $kategori{'3593'} = 'B'; $poststed{'3593'} = 'USTAOSET';
$postkommune{'3595'} = '0620'; $kategori{'3595'} = 'B'; $poststed{'3595'} = 'HAUGASTL';
$postkommune{'3596'} = '1232'; $kategori{'3596'} = 'G'; $poststed{'3596'} = 'HALNE FJELLSTOVA';
$postkommune{'3598'} = '1232'; $kategori{'3598'} = 'G'; $poststed{'3598'} = 'DYRANUT';
$postkommune{'3599'} = '1232'; $kategori{'3599'} = 'G'; $poststed{'3599'} = 'SANDHAUG';
$postkommune{'3601'} = '0604'; $kategori{'3601'} = 'S'; $poststed{'3601'} = 'KONGSBERG';
$postkommune{'3602'} = '0604'; $kategori{'3602'} = 'P'; $poststed{'3602'} = 'KONGSBERG';
$postkommune{'3603'} = '0604'; $kategori{'3603'} = 'P'; $poststed{'3603'} = 'KONGSBERG';
$postkommune{'3604'} = '0604'; $kategori{'3604'} = 'P'; $poststed{'3604'} = 'KONGSBERG';
$postkommune{'3605'} = '0604'; $kategori{'3605'} = 'P'; $poststed{'3605'} = 'KONGSBERG';
$postkommune{'3606'} = '0604'; $kategori{'3606'} = 'P'; $poststed{'3606'} = 'KONGSBERG';
$postkommune{'3608'} = '0604'; $kategori{'3608'} = 'K'; $poststed{'3608'} = 'HEISTADMOEN';
$postkommune{'3610'} = '0604'; $kategori{'3610'} = 'B'; $poststed{'3610'} = 'KONGSBERG';
$postkommune{'3611'} = '0604'; $kategori{'3611'} = 'G'; $poststed{'3611'} = 'KONGSBERG';
$postkommune{'3612'} = '0604'; $kategori{'3612'} = 'G'; $poststed{'3612'} = 'KONGSBERG';
$postkommune{'3613'} = '0604'; $kategori{'3613'} = 'G'; $poststed{'3613'} = 'KONGSBERG';
$postkommune{'3614'} = '0604'; $kategori{'3614'} = 'G'; $poststed{'3614'} = 'KONGSBERG';
$postkommune{'3615'} = '0604'; $kategori{'3615'} = 'G'; $poststed{'3615'} = 'KONGSBERG';
$postkommune{'3616'} = '0604'; $kategori{'3616'} = 'G'; $poststed{'3616'} = 'KONGSBERG';
$postkommune{'3617'} = '0604'; $kategori{'3617'} = 'G'; $poststed{'3617'} = 'KONGSBERG';
$postkommune{'3618'} = '0604'; $kategori{'3618'} = 'B'; $poststed{'3618'} = 'SKOLLENBORG';
$postkommune{'3619'} = '0604'; $kategori{'3619'} = 'G'; $poststed{'3619'} = 'SKOLLENBORG';
$postkommune{'3620'} = '0631'; $kategori{'3620'} = 'G'; $poststed{'3620'} = 'FLESBERG';
$postkommune{'3621'} = '0631'; $kategori{'3621'} = 'P'; $poststed{'3621'} = 'LAMPELAND';
$postkommune{'3622'} = '0631'; $kategori{'3622'} = 'G'; $poststed{'3622'} = 'SVENE';
$postkommune{'3623'} = '0631'; $kategori{'3623'} = 'G'; $poststed{'3623'} = 'LAMPELAND';
$postkommune{'3624'} = '0631'; $kategori{'3624'} = 'G'; $poststed{'3624'} = 'LYNGDAL I NUMEDAL';
$postkommune{'3626'} = '0632'; $kategori{'3626'} = 'G'; $poststed{'3626'} = 'ROLLAG';
$postkommune{'3627'} = '0632'; $kategori{'3627'} = 'P'; $poststed{'3627'} = 'VEGGLI';
$postkommune{'3628'} = '0632'; $kategori{'3628'} = 'G'; $poststed{'3628'} = 'VEGGLI';
$postkommune{'3629'} = '0633'; $kategori{'3629'} = 'B'; $poststed{'3629'} = 'NORE';
$postkommune{'3630'} = '0633'; $kategori{'3630'} = 'G'; $poststed{'3630'} = 'RDBERG';
$postkommune{'3631'} = '0633'; $kategori{'3631'} = 'P'; $poststed{'3631'} = 'RDBERG';
$postkommune{'3632'} = '0633'; $kategori{'3632'} = 'G'; $poststed{'3632'} = 'UVDAL';
$postkommune{'3646'} = '0604'; $kategori{'3646'} = 'P'; $poststed{'3646'} = 'HVITTINGFOSS';
$postkommune{'3647'} = '0604'; $kategori{'3647'} = 'G'; $poststed{'3647'} = 'HVITTINGFOSS';
$postkommune{'3648'} = '0604'; $kategori{'3648'} = 'G'; $poststed{'3648'} = 'PASSEBEKK';
$postkommune{'3650'} = '0826'; $kategori{'3650'} = 'G'; $poststed{'3650'} = 'TINN AUSTBYGD';
$postkommune{'3652'} = '0826'; $kategori{'3652'} = 'G'; $poststed{'3652'} = 'HOVIN I TELEMARK';
$postkommune{'3656'} = '0826'; $kategori{'3656'} = 'G'; $poststed{'3656'} = 'ATR';
$postkommune{'3658'} = '0826'; $kategori{'3658'} = 'G'; $poststed{'3658'} = 'MILAND';
$postkommune{'3660'} = '0826'; $kategori{'3660'} = 'G'; $poststed{'3660'} = 'RJUKAN';
$postkommune{'3661'} = '0826'; $kategori{'3661'} = 'P'; $poststed{'3661'} = 'RJUKAN';
$postkommune{'3665'} = '0827'; $kategori{'3665'} = 'P'; $poststed{'3665'} = 'SAULAND';
$postkommune{'3666'} = '0826'; $kategori{'3666'} = 'P'; $poststed{'3666'} = 'TINN AUSTBYGD';
$postkommune{'3671'} = '0807'; $kategori{'3671'} = 'P'; $poststed{'3671'} = 'NOTODDEN';
$postkommune{'3672'} = '0807'; $kategori{'3672'} = 'P'; $poststed{'3672'} = 'NOTODDEN';
$postkommune{'3673'} = '0807'; $kategori{'3673'} = 'P'; $poststed{'3673'} = 'NOTODDEN';
$postkommune{'3674'} = '0807'; $kategori{'3674'} = 'G'; $poststed{'3674'} = 'NOTODDEN';
$postkommune{'3675'} = '0807'; $kategori{'3675'} = 'G'; $poststed{'3675'} = 'NOTODDEN';
$postkommune{'3676'} = '0807'; $kategori{'3676'} = 'G'; $poststed{'3676'} = 'NOTODDEN';
$postkommune{'3677'} = '0807'; $kategori{'3677'} = 'G'; $poststed{'3677'} = 'NOTODDEN';
$postkommune{'3678'} = '0807'; $kategori{'3678'} = 'G'; $poststed{'3678'} = 'NOTODDEN';
$postkommune{'3679'} = '0807'; $kategori{'3679'} = 'G'; $poststed{'3679'} = 'NOTODDEN';
$postkommune{'3680'} = '0807'; $kategori{'3680'} = 'G'; $poststed{'3680'} = 'NOTODDEN';
$postkommune{'3681'} = '0807'; $kategori{'3681'} = 'G'; $poststed{'3681'} = 'NOTODDEN';
$postkommune{'3683'} = '0807'; $kategori{'3683'} = 'G'; $poststed{'3683'} = 'NOTODDEN';
$postkommune{'3684'} = '0807'; $kategori{'3684'} = 'G'; $poststed{'3684'} = 'NOTODDEN';
$postkommune{'3690'} = '0827'; $kategori{'3690'} = 'G'; $poststed{'3690'} = 'HJARTDAL';
$postkommune{'3691'} = '0807'; $kategori{'3691'} = 'G'; $poststed{'3691'} = 'GRANSHERAD';
$postkommune{'3692'} = '0827'; $kategori{'3692'} = 'G'; $poststed{'3692'} = 'SAULAND';
$postkommune{'3697'} = '0827'; $kategori{'3697'} = 'G'; $poststed{'3697'} = 'TUDDAL';
$postkommune{'3699'} = '0826'; $kategori{'3699'} = 'G'; $poststed{'3699'} = 'GAUSTATOPPEN TURISTHYTTE';
$postkommune{'3701'} = '0806'; $kategori{'3701'} = 'P'; $poststed{'3701'} = 'SKIEN';
$postkommune{'3702'} = '0806'; $kategori{'3702'} = 'P'; $poststed{'3702'} = 'SKIEN';
$postkommune{'3703'} = '0806'; $kategori{'3703'} = 'P'; $poststed{'3703'} = 'SKIEN';
$postkommune{'3704'} = '0806'; $kategori{'3704'} = 'P'; $poststed{'3704'} = 'SKIEN';
$postkommune{'3705'} = '0806'; $kategori{'3705'} = 'P'; $poststed{'3705'} = 'SKIEN';
$postkommune{'3706'} = '0806'; $kategori{'3706'} = 'K'; $poststed{'3706'} = 'SKIEN';
$postkommune{'3707'} = '0806'; $kategori{'3707'} = 'P'; $poststed{'3707'} = 'SKIEN';
$postkommune{'3708'} = '0806'; $kategori{'3708'} = 'K'; $poststed{'3708'} = 'SKIEN';
$postkommune{'3709'} = '0806'; $kategori{'3709'} = 'K'; $poststed{'3709'} = 'SKIEN';
$postkommune{'3710'} = '0806'; $kategori{'3710'} = 'F'; $poststed{'3710'} = 'SKIEN';
$postkommune{'3711'} = '0806'; $kategori{'3711'} = 'G'; $poststed{'3711'} = 'SKIEN';
$postkommune{'3712'} = '0806'; $kategori{'3712'} = 'G'; $poststed{'3712'} = 'SKIEN';
$postkommune{'3713'} = '0806'; $kategori{'3713'} = 'G'; $poststed{'3713'} = 'SKIEN';
$postkommune{'3714'} = '0806'; $kategori{'3714'} = 'G'; $poststed{'3714'} = 'SKIEN';
$postkommune{'3715'} = '0806'; $kategori{'3715'} = 'G'; $poststed{'3715'} = 'SKIEN';
$postkommune{'3716'} = '0806'; $kategori{'3716'} = 'G'; $poststed{'3716'} = 'SKIEN';
$postkommune{'3717'} = '0806'; $kategori{'3717'} = 'G'; $poststed{'3717'} = 'SKIEN';
$postkommune{'3718'} = '0806'; $kategori{'3718'} = 'G'; $poststed{'3718'} = 'SKIEN';
$postkommune{'3719'} = '0806'; $kategori{'3719'} = 'G'; $poststed{'3719'} = 'SKIEN';
$postkommune{'3720'} = '0806'; $kategori{'3720'} = 'G'; $poststed{'3720'} = 'SKIEN';
$postkommune{'3721'} = '0806'; $kategori{'3721'} = 'G'; $poststed{'3721'} = 'SKIEN';
$postkommune{'3722'} = '0806'; $kategori{'3722'} = 'G'; $poststed{'3722'} = 'SKIEN';
$postkommune{'3723'} = '0806'; $kategori{'3723'} = 'G'; $poststed{'3723'} = 'SKIEN';
$postkommune{'3724'} = '0806'; $kategori{'3724'} = 'G'; $poststed{'3724'} = 'SKIEN';
$postkommune{'3725'} = '0806'; $kategori{'3725'} = 'G'; $poststed{'3725'} = 'SKIEN';
$postkommune{'3726'} = '0806'; $kategori{'3726'} = 'G'; $poststed{'3726'} = 'SKIEN';
$postkommune{'3727'} = '0806'; $kategori{'3727'} = 'G'; $poststed{'3727'} = 'SKIEN';
$postkommune{'3728'} = '0806'; $kategori{'3728'} = 'G'; $poststed{'3728'} = 'SKIEN';
$postkommune{'3729'} = '0806'; $kategori{'3729'} = 'G'; $poststed{'3729'} = 'SKIEN';
$postkommune{'3730'} = '0806'; $kategori{'3730'} = 'G'; $poststed{'3730'} = 'SKIEN';
$postkommune{'3731'} = '0806'; $kategori{'3731'} = 'G'; $poststed{'3731'} = 'SKIEN';
$postkommune{'3732'} = '0806'; $kategori{'3732'} = 'G'; $poststed{'3732'} = 'SKIEN';
$postkommune{'3733'} = '0806'; $kategori{'3733'} = 'G'; $poststed{'3733'} = 'SKIEN';
$postkommune{'3734'} = '0806'; $kategori{'3734'} = 'G'; $poststed{'3734'} = 'SKIEN';
$postkommune{'3735'} = '0806'; $kategori{'3735'} = 'G'; $poststed{'3735'} = 'SKIEN';
$postkommune{'3736'} = '0806'; $kategori{'3736'} = 'G'; $poststed{'3736'} = 'SKIEN';
$postkommune{'3737'} = '0806'; $kategori{'3737'} = 'G'; $poststed{'3737'} = 'SKIEN';
$postkommune{'3738'} = '0806'; $kategori{'3738'} = 'G'; $poststed{'3738'} = 'SKIEN';
$postkommune{'3739'} = '0806'; $kategori{'3739'} = 'G'; $poststed{'3739'} = 'SKIEN';
$postkommune{'3740'} = '0806'; $kategori{'3740'} = 'G'; $poststed{'3740'} = 'SKIEN';
$postkommune{'3741'} = '0806'; $kategori{'3741'} = 'G'; $poststed{'3741'} = 'SKIEN';
$postkommune{'3742'} = '0806'; $kategori{'3742'} = 'G'; $poststed{'3742'} = 'SKIEN';
$postkommune{'3743'} = '0806'; $kategori{'3743'} = 'G'; $poststed{'3743'} = 'SKIEN';
$postkommune{'3744'} = '0806'; $kategori{'3744'} = 'G'; $poststed{'3744'} = 'SKIEN';
$postkommune{'3746'} = '0806'; $kategori{'3746'} = 'G'; $poststed{'3746'} = 'SKIEN';
$postkommune{'3747'} = '0806'; $kategori{'3747'} = 'G'; $poststed{'3747'} = 'SKIEN';
$postkommune{'3748'} = '0811'; $kategori{'3748'} = 'G'; $poststed{'3748'} = 'SILJAN';
$postkommune{'3749'} = '0811'; $kategori{'3749'} = 'P'; $poststed{'3749'} = 'SILJAN';
$postkommune{'3750'} = '0817'; $kategori{'3750'} = 'G'; $poststed{'3750'} = 'DRANGEDAL';
$postkommune{'3753'} = '0817'; $kategori{'3753'} = 'G'; $poststed{'3753'} = 'TRDAL';
$postkommune{'3760'} = '0817'; $kategori{'3760'} = 'G'; $poststed{'3760'} = 'NESLANDSVATN';
$postkommune{'3766'} = '0815'; $kategori{'3766'} = 'G'; $poststed{'3766'} = 'SANNIDAL';
$postkommune{'3770'} = '0815'; $kategori{'3770'} = 'G'; $poststed{'3770'} = 'KRAGER';
$postkommune{'3780'} = '0815'; $kategori{'3780'} = 'G'; $poststed{'3780'} = 'SKTY';
$postkommune{'3781'} = '0815'; $kategori{'3781'} = 'G'; $poststed{'3781'} = 'JOMFRULAND';
$postkommune{'3782'} = '0815'; $kategori{'3782'} = 'G'; $poststed{'3782'} = 'KRAGER SOMMERRUTE';
$postkommune{'3783'} = '0815'; $kategori{'3783'} = 'G'; $poststed{'3783'} = 'KRAGER SKJRGRDSRUTE';
$postkommune{'3784'} = '0815'; $kategori{'3784'} = 'G'; $poststed{'3784'} = 'LANGY GRUVER';
$postkommune{'3785'} = '0806'; $kategori{'3785'} = 'P'; $poststed{'3785'} = 'SKIEN';
$postkommune{'3786'} = '0806'; $kategori{'3786'} = 'P'; $poststed{'3786'} = 'SKIEN';
$postkommune{'3787'} = '0806'; $kategori{'3787'} = 'P'; $poststed{'3787'} = 'SKIEN';
$postkommune{'3788'} = '0815'; $kategori{'3788'} = 'G'; $poststed{'3788'} = 'STABBESTAD';
$postkommune{'3789'} = '0815'; $kategori{'3789'} = 'P'; $poststed{'3789'} = 'KRAGER';
$postkommune{'3790'} = '0815'; $kategori{'3790'} = 'G'; $poststed{'3790'} = 'HELLE';
$postkommune{'3791'} = '0815'; $kategori{'3791'} = 'P'; $poststed{'3791'} = 'KRAGER';
$postkommune{'3792'} = '0806'; $kategori{'3792'} = 'P'; $poststed{'3792'} = 'SKIEN';
$postkommune{'3793'} = '0815'; $kategori{'3793'} = 'P'; $poststed{'3793'} = 'SANNIDAL';
$postkommune{'3794'} = '0815'; $kategori{'3794'} = 'P'; $poststed{'3794'} = 'HELLE';
$postkommune{'3795'} = '0817'; $kategori{'3795'} = 'P'; $poststed{'3795'} = 'DRANGEDAL';
$postkommune{'3796'} = '0806'; $kategori{'3796'} = 'P'; $poststed{'3796'} = 'SKIEN';
$postkommune{'3797'} = '0806'; $kategori{'3797'} = 'P'; $poststed{'3797'} = 'SKIEN';
$postkommune{'3798'} = '0806'; $kategori{'3798'} = 'P'; $poststed{'3798'} = 'SKIEN';
$postkommune{'3800'} = '0821'; $kategori{'3800'} = 'G'; $poststed{'3800'} = 'B I TELEMARK';
$postkommune{'3810'} = '0822'; $kategori{'3810'} = 'G'; $poststed{'3810'} = 'GVARV';
$postkommune{'3812'} = '0822'; $kategori{'3812'} = 'G'; $poststed{'3812'} = 'AKKERHAUGEN';
$postkommune{'3820'} = '0822'; $kategori{'3820'} = 'G'; $poststed{'3820'} = 'NORDAGUTU';
$postkommune{'3825'} = '0819'; $kategori{'3825'} = 'G'; $poststed{'3825'} = 'LUNDE';
$postkommune{'3830'} = '0819'; $kategori{'3830'} = 'G'; $poststed{'3830'} = 'ULEFOSS';
$postkommune{'3831'} = '0819'; $kategori{'3831'} = 'P'; $poststed{'3831'} = 'ULEFOSS';
$postkommune{'3832'} = '0819'; $kategori{'3832'} = 'P'; $poststed{'3832'} = 'LUNDE';
$postkommune{'3833'} = '0821'; $kategori{'3833'} = 'P'; $poststed{'3833'} = 'B I TELEMARK';
$postkommune{'3834'} = '0822'; $kategori{'3834'} = 'P'; $poststed{'3834'} = 'GVARV';
$postkommune{'3835'} = '0828'; $kategori{'3835'} = 'P'; $poststed{'3835'} = 'SELJORD';
$postkommune{'3836'} = '0829'; $kategori{'3836'} = 'P'; $poststed{'3836'} = 'KVITESEID';
$postkommune{'3840'} = '0828'; $kategori{'3840'} = 'G'; $poststed{'3840'} = 'SELJORD';
$postkommune{'3841'} = '0828'; $kategori{'3841'} = 'G'; $poststed{'3841'} = 'FLATDAL';
$postkommune{'3848'} = '0829'; $kategori{'3848'} = 'G'; $poststed{'3848'} = 'MORGEDAL';
$postkommune{'3849'} = '0829'; $kategori{'3849'} = 'G'; $poststed{'3849'} = 'VRLIOSEN';
$postkommune{'3850'} = '0829'; $kategori{'3850'} = 'G'; $poststed{'3850'} = 'KVITESEID';
$postkommune{'3853'} = '0829'; $kategori{'3853'} = 'B'; $poststed{'3853'} = 'VRDAL';
$postkommune{'3854'} = '0830'; $kategori{'3854'} = 'G'; $poststed{'3854'} = 'NISSEDAL';
$postkommune{'3855'} = '0830'; $kategori{'3855'} = 'G'; $poststed{'3855'} = 'TREUNGEN';
$postkommune{'3864'} = '0834'; $kategori{'3864'} = 'G'; $poststed{'3864'} = 'RAULAND';
$postkommune{'3870'} = '0831'; $kategori{'3870'} = 'G'; $poststed{'3870'} = 'FYRESDAL';
$postkommune{'3880'} = '0833'; $kategori{'3880'} = 'G'; $poststed{'3880'} = 'DALEN';
$postkommune{'3882'} = '0833'; $kategori{'3882'} = 'G'; $poststed{'3882'} = 'MDALS VERK';
$postkommune{'3883'} = '0830'; $kategori{'3883'} = 'P'; $poststed{'3883'} = 'TREUNGEN';
$postkommune{'3884'} = '0834'; $kategori{'3884'} = 'P'; $poststed{'3884'} = 'RAULAND';
$postkommune{'3885'} = '0831'; $kategori{'3885'} = 'P'; $poststed{'3885'} = 'FYRESDAL';
$postkommune{'3886'} = '0833'; $kategori{'3886'} = 'P'; $poststed{'3886'} = 'DALEN';
$postkommune{'3887'} = '0834'; $kategori{'3887'} = 'P'; $poststed{'3887'} = 'VINJE';
$postkommune{'3888'} = '0834'; $kategori{'3888'} = 'P'; $poststed{'3888'} = 'EDLAND';
$postkommune{'3890'} = '0834'; $kategori{'3890'} = 'G'; $poststed{'3890'} = 'VINJE';
$postkommune{'3891'} = '0833'; $kategori{'3891'} = 'G'; $poststed{'3891'} = 'HYDALSMO';
$postkommune{'3893'} = '0834'; $kategori{'3893'} = 'G'; $poststed{'3893'} = 'VINJESVINGEN';
$postkommune{'3895'} = '0834'; $kategori{'3895'} = 'G'; $poststed{'3895'} = 'EDLAND';
$postkommune{'3901'} = '0805'; $kategori{'3901'} = 'P'; $poststed{'3901'} = 'PORSGRUNN';
$postkommune{'3902'} = '0805'; $kategori{'3902'} = 'P'; $poststed{'3902'} = 'PORSGRUNN';
$postkommune{'3903'} = '0805'; $kategori{'3903'} = 'P'; $poststed{'3903'} = 'PORSGRUNN';
$postkommune{'3904'} = '0805'; $kategori{'3904'} = 'P'; $poststed{'3904'} = 'PORSGRUNN';
$postkommune{'3905'} = '0805'; $kategori{'3905'} = 'P'; $poststed{'3905'} = 'PORSGRUNN';
$postkommune{'3906'} = '0805'; $kategori{'3906'} = 'P'; $poststed{'3906'} = 'PORSGRUNN';
$postkommune{'3908'} = '0805'; $kategori{'3908'} = 'K'; $poststed{'3908'} = 'PORSGRUNN';
$postkommune{'3910'} = '0805'; $kategori{'3910'} = 'G'; $poststed{'3910'} = 'PORSGRUNN';
$postkommune{'3911'} = '0805'; $kategori{'3911'} = 'G'; $poststed{'3911'} = 'PORSGRUNN';
$postkommune{'3912'} = '0805'; $kategori{'3912'} = 'G'; $poststed{'3912'} = 'PORSGRUNN';
$postkommune{'3913'} = '0805'; $kategori{'3913'} = 'G'; $poststed{'3913'} = 'PORSGRUNN';
$postkommune{'3914'} = '0805'; $kategori{'3914'} = 'G'; $poststed{'3914'} = 'PORSGRUNN';
$postkommune{'3915'} = '0805'; $kategori{'3915'} = 'G'; $poststed{'3915'} = 'PORSGRUNN';
$postkommune{'3916'} = '0805'; $kategori{'3916'} = 'G'; $poststed{'3916'} = 'PORSGRUNN';
$postkommune{'3917'} = '0805'; $kategori{'3917'} = 'G'; $poststed{'3917'} = 'PORSGRUNN';
$postkommune{'3918'} = '0805'; $kategori{'3918'} = 'G'; $poststed{'3918'} = 'PORSGRUNN';
$postkommune{'3919'} = '0805'; $kategori{'3919'} = 'G'; $poststed{'3919'} = 'PORSGRUNN';
$postkommune{'3920'} = '0805'; $kategori{'3920'} = 'G'; $poststed{'3920'} = 'PORSGRUNN';
$postkommune{'3921'} = '0805'; $kategori{'3921'} = 'G'; $poststed{'3921'} = 'PORSGRUNN';
$postkommune{'3922'} = '0805'; $kategori{'3922'} = 'G'; $poststed{'3922'} = 'PORSGRUNN';
$postkommune{'3924'} = '0805'; $kategori{'3924'} = 'G'; $poststed{'3924'} = 'PORSGRUNN';
$postkommune{'3925'} = '0805'; $kategori{'3925'} = 'G'; $poststed{'3925'} = 'PORSGRUNN';
$postkommune{'3928'} = '0805'; $kategori{'3928'} = 'G'; $poststed{'3928'} = 'PORSGRUNN';
$postkommune{'3929'} = '0805'; $kategori{'3929'} = 'G'; $poststed{'3929'} = 'PORSGRUNN';
$postkommune{'3930'} = '0805'; $kategori{'3930'} = 'G'; $poststed{'3930'} = 'PORSGRUNN';
$postkommune{'3931'} = '0805'; $kategori{'3931'} = 'G'; $poststed{'3931'} = 'PORSGRUNN';
$postkommune{'3932'} = '0805'; $kategori{'3932'} = 'G'; $poststed{'3932'} = 'PORSGRUNN';
$postkommune{'3933'} = '0805'; $kategori{'3933'} = 'G'; $poststed{'3933'} = 'PORSGRUNN';
$postkommune{'3936'} = '0805'; $kategori{'3936'} = 'G'; $poststed{'3936'} = 'PORSGRUNN';
$postkommune{'3937'} = '0805'; $kategori{'3937'} = 'G'; $poststed{'3937'} = 'PORSGRUNN';
$postkommune{'3939'} = '0805'; $kategori{'3939'} = 'P'; $poststed{'3939'} = 'PORSGRUNN';
$postkommune{'3940'} = '0805'; $kategori{'3940'} = 'G'; $poststed{'3940'} = 'PORSGRUNN';
$postkommune{'3941'} = '0805'; $kategori{'3941'} = 'G'; $poststed{'3941'} = 'PORSGRUNN';
$postkommune{'3942'} = '0805'; $kategori{'3942'} = 'G'; $poststed{'3942'} = 'PORSGRUNN';
$postkommune{'3943'} = '0805'; $kategori{'3943'} = 'G'; $poststed{'3943'} = 'PORSGRUNN';
$postkommune{'3944'} = '0805'; $kategori{'3944'} = 'G'; $poststed{'3944'} = 'PORSGRUNN';
$postkommune{'3945'} = '0805'; $kategori{'3945'} = 'K'; $poststed{'3945'} = 'PORSGRUNN';
$postkommune{'3946'} = '0805'; $kategori{'3946'} = 'G'; $poststed{'3946'} = 'PORSGRUNN';
$postkommune{'3947'} = '0805'; $kategori{'3947'} = 'G'; $poststed{'3947'} = 'LANGANGEN';
$postkommune{'3948'} = '0805'; $kategori{'3948'} = 'G'; $poststed{'3948'} = 'PORSGRUNN';
$postkommune{'3949'} = '0805'; $kategori{'3949'} = 'G'; $poststed{'3949'} = 'PORSGRUNN';
$postkommune{'3950'} = '0805'; $kategori{'3950'} = 'G'; $poststed{'3950'} = 'BREVIK';
$postkommune{'3960'} = '0814'; $kategori{'3960'} = 'G'; $poststed{'3960'} = 'STATHELLE';
$postkommune{'3965'} = '0814'; $kategori{'3965'} = 'G'; $poststed{'3965'} = 'HERRE';
$postkommune{'3966'} = '0814'; $kategori{'3966'} = 'K'; $poststed{'3966'} = 'STATHELLE';
$postkommune{'3967'} = '0814'; $kategori{'3967'} = 'G'; $poststed{'3967'} = 'BAMBLE SOMMERRUTE';
$postkommune{'3970'} = '0814'; $kategori{'3970'} = 'G'; $poststed{'3970'} = 'LANGESUND';
$postkommune{'3991'} = '0805'; $kategori{'3991'} = 'P'; $poststed{'3991'} = 'BREVIK';
$postkommune{'3993'} = '0814'; $kategori{'3993'} = 'P'; $poststed{'3993'} = 'LANGESUND';
$postkommune{'3994'} = '0814'; $kategori{'3994'} = 'P'; $poststed{'3994'} = 'LANGESUND';
$postkommune{'3995'} = '0814'; $kategori{'3995'} = 'P'; $poststed{'3995'} = 'STATHELLE';
$postkommune{'3996'} = '0805'; $kategori{'3996'} = 'P'; $poststed{'3996'} = 'PORSGRUNN';
$postkommune{'3997'} = '0805'; $kategori{'3997'} = 'P'; $poststed{'3997'} = 'PORSGRUNN';
$postkommune{'3998'} = '0805'; $kategori{'3998'} = 'P'; $poststed{'3998'} = 'PORSGRUNN';
$postkommune{'3999'} = '0814'; $kategori{'3999'} = 'P'; $poststed{'3999'} = 'HERRE';
$postkommune{'4001'} = '1103'; $kategori{'4001'} = 'P'; $poststed{'4001'} = 'STAVANGER';
$postkommune{'4002'} = '1103'; $kategori{'4002'} = 'P'; $poststed{'4002'} = 'STAVANGER';
$postkommune{'4003'} = '1103'; $kategori{'4003'} = 'P'; $poststed{'4003'} = 'STAVANGER';
$postkommune{'4004'} = '1103'; $kategori{'4004'} = 'P'; $poststed{'4004'} = 'STAVANGER';
$postkommune{'4005'} = '1103'; $kategori{'4005'} = 'G'; $poststed{'4005'} = 'STAVANGER';
$postkommune{'4006'} = '1103'; $kategori{'4006'} = 'G'; $poststed{'4006'} = 'STAVANGER';
$postkommune{'4007'} = '1103'; $kategori{'4007'} = 'G'; $poststed{'4007'} = 'STAVANGER';
$postkommune{'4008'} = '1103'; $kategori{'4008'} = 'G'; $poststed{'4008'} = 'STAVANGER';
$postkommune{'4009'} = '1103'; $kategori{'4009'} = 'G'; $poststed{'4009'} = 'STAVANGER';
$postkommune{'4010'} = '1103'; $kategori{'4010'} = 'G'; $poststed{'4010'} = 'STAVANGER';
$postkommune{'4011'} = '1103'; $kategori{'4011'} = 'G'; $poststed{'4011'} = 'STAVANGER';
$postkommune{'4012'} = '1103'; $kategori{'4012'} = 'G'; $poststed{'4012'} = 'STAVANGER';
$postkommune{'4013'} = '1103'; $kategori{'4013'} = 'G'; $poststed{'4013'} = 'STAVANGER';
$postkommune{'4014'} = '1103'; $kategori{'4014'} = 'G'; $poststed{'4014'} = 'STAVANGER';
$postkommune{'4015'} = '1103'; $kategori{'4015'} = 'G'; $poststed{'4015'} = 'STAVANGER';
$postkommune{'4016'} = '1103'; $kategori{'4016'} = 'G'; $poststed{'4016'} = 'STAVANGER';
$postkommune{'4017'} = '1103'; $kategori{'4017'} = 'G'; $poststed{'4017'} = 'STAVANGER';
$postkommune{'4018'} = '1103'; $kategori{'4018'} = 'G'; $poststed{'4018'} = 'STAVANGER';
$postkommune{'4019'} = '1103'; $kategori{'4019'} = 'G'; $poststed{'4019'} = 'STAVANGER';
$postkommune{'4020'} = '1103'; $kategori{'4020'} = 'G'; $poststed{'4020'} = 'STAVANGER';
$postkommune{'4021'} = '1103'; $kategori{'4021'} = 'G'; $poststed{'4021'} = 'STAVANGER';
$postkommune{'4022'} = '1103'; $kategori{'4022'} = 'G'; $poststed{'4022'} = 'STAVANGER';
$postkommune{'4023'} = '1103'; $kategori{'4023'} = 'G'; $poststed{'4023'} = 'STAVANGER';
$postkommune{'4024'} = '1103'; $kategori{'4024'} = 'G'; $poststed{'4024'} = 'STAVANGER';
$postkommune{'4025'} = '1103'; $kategori{'4025'} = 'G'; $poststed{'4025'} = 'STAVANGER';
$postkommune{'4026'} = '1103'; $kategori{'4026'} = 'G'; $poststed{'4026'} = 'STAVANGER';
$postkommune{'4027'} = '1103'; $kategori{'4027'} = 'G'; $poststed{'4027'} = 'STAVANGER';
$postkommune{'4028'} = '1103'; $kategori{'4028'} = 'G'; $poststed{'4028'} = 'STAVANGER';
$postkommune{'4029'} = '1103'; $kategori{'4029'} = 'G'; $poststed{'4029'} = 'STAVANGER';
$postkommune{'4032'} = '1103'; $kategori{'4032'} = 'G'; $poststed{'4032'} = 'STAVANGER';
$postkommune{'4033'} = '1103'; $kategori{'4033'} = 'G'; $poststed{'4033'} = 'STAVANGER';
$postkommune{'4034'} = '1103'; $kategori{'4034'} = 'G'; $poststed{'4034'} = 'STAVANGER';
$postkommune{'4035'} = '1103'; $kategori{'4035'} = 'K'; $poststed{'4035'} = 'STAVANGER';
$postkommune{'4036'} = '1103'; $kategori{'4036'} = 'K'; $poststed{'4036'} = 'STAVANGER';
$postkommune{'4041'} = '1103'; $kategori{'4041'} = 'G'; $poststed{'4041'} = 'HAFRSFJORD';
$postkommune{'4042'} = '1103'; $kategori{'4042'} = 'G'; $poststed{'4042'} = 'HAFRSFJORD';
$postkommune{'4043'} = '1103'; $kategori{'4043'} = 'G'; $poststed{'4043'} = 'HAFRSFJORD';
$postkommune{'4044'} = '1103'; $kategori{'4044'} = 'G'; $poststed{'4044'} = 'HAFRSFJORD';
$postkommune{'4045'} = '1103'; $kategori{'4045'} = 'G'; $poststed{'4045'} = 'HAFRSFJORD';
$postkommune{'4046'} = '1103'; $kategori{'4046'} = 'G'; $poststed{'4046'} = 'HAFRSFJORD';
$postkommune{'4047'} = '1103'; $kategori{'4047'} = 'G'; $poststed{'4047'} = 'HAFRSFJORD';
$postkommune{'4048'} = '1103'; $kategori{'4048'} = 'G'; $poststed{'4048'} = 'HAFRSFJORD';
$postkommune{'4049'} = '1103'; $kategori{'4049'} = 'G'; $poststed{'4049'} = 'HAFRSFJORD';
$postkommune{'4050'} = '1124'; $kategori{'4050'} = 'G'; $poststed{'4050'} = 'SOLA';
$postkommune{'4052'} = '1124'; $kategori{'4052'} = 'G'; $poststed{'4052'} = 'RYNEBERG';
$postkommune{'4053'} = '1124'; $kategori{'4053'} = 'G'; $poststed{'4053'} = 'RGE';
$postkommune{'4054'} = '1124'; $kategori{'4054'} = 'B'; $poststed{'4054'} = 'TJELTA';
$postkommune{'4055'} = '1124'; $kategori{'4055'} = 'B'; $poststed{'4055'} = 'STAVANGER LUFTHAVN';
$postkommune{'4056'} = '1124'; $kategori{'4056'} = 'G'; $poststed{'4056'} = 'TANANGER';
$postkommune{'4059'} = '1124'; $kategori{'4059'} = 'P'; $poststed{'4059'} = 'RYNEBERG';
$postkommune{'4064'} = '1103'; $kategori{'4064'} = 'P'; $poststed{'4064'} = 'STAVANGER';
$postkommune{'4065'} = '1103'; $kategori{'4065'} = 'P'; $poststed{'4065'} = 'STAVANGER';
$postkommune{'4066'} = '1103'; $kategori{'4066'} = 'P'; $poststed{'4066'} = 'STAVANGER';
$postkommune{'4067'} = '1103'; $kategori{'4067'} = 'P'; $poststed{'4067'} = 'STAVANGER';
$postkommune{'4068'} = '1103'; $kategori{'4068'} = 'P'; $poststed{'4068'} = 'STAVANGER';
$postkommune{'4069'} = '1103'; $kategori{'4069'} = 'P'; $poststed{'4069'} = 'STAVANGER';
$postkommune{'4070'} = '1127'; $kategori{'4070'} = 'G'; $poststed{'4070'} = 'RANDABERG';
$postkommune{'4076'} = '1103'; $kategori{'4076'} = 'B'; $poststed{'4076'} = 'VASSY';
$postkommune{'4078'} = '1103'; $kategori{'4078'} = 'P'; $poststed{'4078'} = 'STAVANGER';
$postkommune{'4079'} = '1103'; $kategori{'4079'} = 'P'; $poststed{'4079'} = 'STAVANGER';
$postkommune{'4081'} = '1103'; $kategori{'4081'} = 'P'; $poststed{'4081'} = 'STAVANGER';
$postkommune{'4082'} = '1103'; $kategori{'4082'} = 'P'; $poststed{'4082'} = 'STAVANGER';
$postkommune{'4084'} = '1103'; $kategori{'4084'} = 'P'; $poststed{'4084'} = 'STAVANGER';
$postkommune{'4085'} = '1103'; $kategori{'4085'} = 'G'; $poststed{'4085'} = 'HUNDVG';
$postkommune{'4086'} = '1103'; $kategori{'4086'} = 'P'; $poststed{'4086'} = 'HUNDVG';
$postkommune{'4087'} = '1103'; $kategori{'4087'} = 'P'; $poststed{'4087'} = 'STAVANGER';
$postkommune{'4088'} = '1103'; $kategori{'4088'} = 'P'; $poststed{'4088'} = 'STAVANGER';
$postkommune{'4089'} = '1103'; $kategori{'4089'} = 'P'; $poststed{'4089'} = 'HAFRSFJORD';
$postkommune{'4090'} = '1103'; $kategori{'4090'} = 'P'; $poststed{'4090'} = 'HAFRSFJORD';
$postkommune{'4092'} = '1103'; $kategori{'4092'} = 'P'; $poststed{'4092'} = 'STAVANGER';
$postkommune{'4093'} = '1103'; $kategori{'4093'} = 'P'; $poststed{'4093'} = 'STAVANGER';
$postkommune{'4094'} = '1103'; $kategori{'4094'} = 'P'; $poststed{'4094'} = 'STAVANGER';
$postkommune{'4095'} = '1103'; $kategori{'4095'} = 'P'; $poststed{'4095'} = 'STAVANGER';
$postkommune{'4096'} = '1127'; $kategori{'4096'} = 'P'; $poststed{'4096'} = 'RANDABERG';
$postkommune{'4097'} = '1124'; $kategori{'4097'} = 'P'; $poststed{'4097'} = 'SOLA';
$postkommune{'4098'} = '1124'; $kategori{'4098'} = 'P'; $poststed{'4098'} = 'TANANGER';
$postkommune{'4100'} = '1130'; $kategori{'4100'} = 'G'; $poststed{'4100'} = 'JRPELAND';
$postkommune{'4102'} = '1130'; $kategori{'4102'} = 'G'; $poststed{'4102'} = 'IDSE';
$postkommune{'4110'} = '1129'; $kategori{'4110'} = 'G'; $poststed{'4110'} = 'FORSAND';
$postkommune{'4119'} = '1129'; $kategori{'4119'} = 'P'; $poststed{'4119'} = 'FORSAND';
$postkommune{'4120'} = '1130'; $kategori{'4120'} = 'G'; $poststed{'4120'} = 'TAU';
$postkommune{'4122'} = '1130'; $kategori{'4122'} = 'G'; $poststed{'4122'} = 'FISK';
$postkommune{'4123'} = '1130'; $kategori{'4123'} = 'G'; $poststed{'4123'} = 'SR-HIDLE';
$postkommune{'4124'} = '1130'; $kategori{'4124'} = 'P'; $poststed{'4124'} = 'TAU';
$postkommune{'4126'} = '1130'; $kategori{'4126'} = 'P'; $poststed{'4126'} = 'JRPELAND';
$postkommune{'4127'} = '1129'; $kategori{'4127'} = 'B'; $poststed{'4127'} = 'LYSEBOTN';
$postkommune{'4128'} = '1129'; $kategori{'4128'} = 'G'; $poststed{'4128'} = 'FLYRLI';
$postkommune{'4129'} = '1129'; $kategori{'4129'} = 'G'; $poststed{'4129'} = 'SONGESAND';
$postkommune{'4130'} = '1133'; $kategori{'4130'} = 'G'; $poststed{'4130'} = 'HJELMELAND';
$postkommune{'4134'} = '1133'; $kategori{'4134'} = 'G'; $poststed{'4134'} = 'JSENFJORDEN';
$postkommune{'4137'} = '1133'; $kategori{'4137'} = 'G'; $poststed{'4137'} = 'RDAL I RYFYLKE';
$postkommune{'4139'} = '1133'; $kategori{'4139'} = 'G'; $poststed{'4139'} = 'FISTER';
$postkommune{'4146'} = '1133'; $kategori{'4146'} = 'G'; $poststed{'4146'} = 'SKIFTUN';
$postkommune{'4148'} = '1133'; $kategori{'4148'} = 'P'; $poststed{'4148'} = 'HJELMELAND';
$postkommune{'4150'} = '1142'; $kategori{'4150'} = 'G'; $poststed{'4150'} = 'RENNESY';
$postkommune{'4152'} = '1142'; $kategori{'4152'} = 'G'; $poststed{'4152'} = 'VESTRE MY';
$postkommune{'4153'} = '1142'; $kategori{'4153'} = 'G'; $poststed{'4153'} = 'BRIMSE';
$postkommune{'4154'} = '1103'; $kategori{'4154'} = 'G'; $poststed{'4154'} = 'AUSTRE MY';
$postkommune{'4156'} = '1142'; $kategori{'4156'} = 'G'; $poststed{'4156'} = 'MOSTERY';
$postkommune{'4158'} = '1142'; $kategori{'4158'} = 'G'; $poststed{'4158'} = 'BRU';
$postkommune{'4159'} = '1142'; $kategori{'4159'} = 'P'; $poststed{'4159'} = 'RENNESY';
$postkommune{'4160'} = '1141'; $kategori{'4160'} = 'G'; $poststed{'4160'} = 'FINNY';
$postkommune{'4161'} = '1141'; $kategori{'4161'} = 'P'; $poststed{'4161'} = 'FINNY';
$postkommune{'4163'} = '1141'; $kategori{'4163'} = 'G'; $poststed{'4163'} = 'TALGJE';
$postkommune{'4164'} = '1141'; $kategori{'4164'} = 'G'; $poststed{'4164'} = 'FOGN';
$postkommune{'4167'} = '1133'; $kategori{'4167'} = 'G'; $poststed{'4167'} = 'HELGY I RYFYLKE';
$postkommune{'4168'} = '1141'; $kategori{'4168'} = 'G'; $poststed{'4168'} = 'BYRE';
$postkommune{'4169'} = '1141'; $kategori{'4169'} = 'G'; $poststed{'4169'} = 'SRBOKN';
$postkommune{'4170'} = '1141'; $kategori{'4170'} = 'G'; $poststed{'4170'} = 'SJERNARY';
$postkommune{'4173'} = '1141'; $kategori{'4173'} = 'G'; $poststed{'4173'} = 'NORD-HIDLE';
$postkommune{'4174'} = '1141'; $kategori{'4174'} = 'B'; $poststed{'4174'} = 'HELGYSUND';
$postkommune{'4180'} = '1144'; $kategori{'4180'} = 'B'; $poststed{'4180'} = 'KVITSY';
$postkommune{'4182'} = '1141'; $kategori{'4182'} = 'B'; $poststed{'4182'} = 'SKARTVEIT';
$postkommune{'4187'} = '1141'; $kategori{'4187'} = 'G'; $poststed{'4187'} = 'OMBO';
$postkommune{'4198'} = '1134'; $kategori{'4198'} = 'G'; $poststed{'4198'} = 'FOLDY';
$postkommune{'4200'} = '1135'; $kategori{'4200'} = 'G'; $poststed{'4200'} = 'SAUDA';
$postkommune{'4201'} = '1135'; $kategori{'4201'} = 'P'; $poststed{'4201'} = 'SAUDA';
$postkommune{'4208'} = '1135'; $kategori{'4208'} = 'G'; $poststed{'4208'} = 'SAUDASJEN';
$postkommune{'4209'} = '1134'; $kategori{'4209'} = 'G'; $poststed{'4209'} = 'VANVIK';
$postkommune{'4230'} = '1134'; $kategori{'4230'} = 'G'; $poststed{'4230'} = 'SAND';
$postkommune{'4233'} = '1134'; $kategori{'4233'} = 'B'; $poststed{'4233'} = 'ERFJORD';
$postkommune{'4234'} = '1134'; $kategori{'4234'} = 'G'; $poststed{'4234'} = 'JELSA';
$postkommune{'4235'} = '1134'; $kategori{'4235'} = 'G'; $poststed{'4235'} = 'HEBNES';
$postkommune{'4237'} = '1134'; $kategori{'4237'} = 'G'; $poststed{'4237'} = 'SULDALSOSEN';
$postkommune{'4239'} = '1134'; $kategori{'4239'} = 'P'; $poststed{'4239'} = 'SAND';
$postkommune{'4240'} = '1134'; $kategori{'4240'} = 'P'; $poststed{'4240'} = 'SULDALSOSEN';
$postkommune{'4244'} = '1134'; $kategori{'4244'} = 'B'; $poststed{'4244'} = 'NESFLATEN';
$postkommune{'4250'} = '1149'; $kategori{'4250'} = 'G'; $poststed{'4250'} = 'KOPERVIK';
$postkommune{'4260'} = '1149'; $kategori{'4260'} = 'G'; $poststed{'4260'} = 'TORVASTAD';
$postkommune{'4262'} = '1149'; $kategori{'4262'} = 'G'; $poststed{'4262'} = 'AVALDSNES';
$postkommune{'4264'} = '1149'; $kategori{'4264'} = 'B'; $poststed{'4264'} = 'KVALAVG';
$postkommune{'4265'} = '1149'; $kategori{'4265'} = 'G'; $poststed{'4265'} = 'HVIK';
$postkommune{'4270'} = '1149'; $kategori{'4270'} = 'G'; $poststed{'4270'} = 'KREHAMN';
$postkommune{'4272'} = '1149'; $kategori{'4272'} = 'B'; $poststed{'4272'} = 'SANDVE';
$postkommune{'4274'} = '1149'; $kategori{'4274'} = 'B'; $poststed{'4274'} = 'STOL';
$postkommune{'4275'} = '1149'; $kategori{'4275'} = 'B'; $poststed{'4275'} = 'SVELANDSVIK';
$postkommune{'4276'} = '1149'; $kategori{'4276'} = 'G'; $poststed{'4276'} = 'VEDAVGEN';
$postkommune{'4280'} = '1149'; $kategori{'4280'} = 'G'; $poststed{'4280'} = 'SKUDENESHAVN';
$postkommune{'4291'} = '1149'; $kategori{'4291'} = 'P'; $poststed{'4291'} = 'KOPERVIK';
$postkommune{'4294'} = '1149'; $kategori{'4294'} = 'P'; $poststed{'4294'} = 'KOPERVIK';
$postkommune{'4295'} = '1149'; $kategori{'4295'} = 'P'; $poststed{'4295'} = 'VEDAVGEN';
$postkommune{'4296'} = '1149'; $kategori{'4296'} = 'P'; $poststed{'4296'} = 'KREHAMN';
$postkommune{'4297'} = '1149'; $kategori{'4297'} = 'P'; $poststed{'4297'} = 'SKUDENESHAVN';
$postkommune{'4298'} = '1149'; $kategori{'4298'} = 'P'; $poststed{'4298'} = 'TORVASTAD';
$postkommune{'4299'} = '1149'; $kategori{'4299'} = 'P'; $poststed{'4299'} = 'AVALDSNES';
$postkommune{'4301'} = '1102'; $kategori{'4301'} = 'P'; $poststed{'4301'} = 'SANDNES';
$postkommune{'4302'} = '1102'; $kategori{'4302'} = 'P'; $poststed{'4302'} = 'SANDNES';
$postkommune{'4303'} = '1102'; $kategori{'4303'} = 'P'; $poststed{'4303'} = 'SANDNES';
$postkommune{'4304'} = '1102'; $kategori{'4304'} = 'P'; $poststed{'4304'} = 'SANDNES';
$postkommune{'4305'} = '1102'; $kategori{'4305'} = 'P'; $poststed{'4305'} = 'SANDNES';
$postkommune{'4306'} = '1102'; $kategori{'4306'} = 'G'; $poststed{'4306'} = 'SANDNES';
$postkommune{'4307'} = '1102'; $kategori{'4307'} = 'G'; $poststed{'4307'} = 'SANDNES';
$postkommune{'4308'} = '1102'; $kategori{'4308'} = 'B'; $poststed{'4308'} = 'SANDNES';
$postkommune{'4309'} = '1102'; $kategori{'4309'} = 'G'; $poststed{'4309'} = 'SANDNES';
$postkommune{'4310'} = '1102'; $kategori{'4310'} = 'G'; $poststed{'4310'} = 'HOMMERSK';
$postkommune{'4311'} = '1102'; $kategori{'4311'} = 'G'; $poststed{'4311'} = 'HOMMERSK';
$postkommune{'4312'} = '1102'; $kategori{'4312'} = 'G'; $poststed{'4312'} = 'SANDNES';
$postkommune{'4313'} = '1102'; $kategori{'4313'} = 'G'; $poststed{'4313'} = 'SANDNES';
$postkommune{'4314'} = '1102'; $kategori{'4314'} = 'G'; $poststed{'4314'} = 'SANDNES';
$postkommune{'4315'} = '1102'; $kategori{'4315'} = 'G'; $poststed{'4315'} = 'SANDNES';
$postkommune{'4316'} = '1102'; $kategori{'4316'} = 'G'; $poststed{'4316'} = 'SANDNES';
$postkommune{'4317'} = '1102'; $kategori{'4317'} = 'G'; $poststed{'4317'} = 'SANDNES';
$postkommune{'4318'} = '1102'; $kategori{'4318'} = 'G'; $poststed{'4318'} = 'SANDNES';
$postkommune{'4319'} = '1102'; $kategori{'4319'} = 'G'; $poststed{'4319'} = 'SANDNES';
$postkommune{'4321'} = '1102'; $kategori{'4321'} = 'G'; $poststed{'4321'} = 'SANDNES';
$postkommune{'4322'} = '1102'; $kategori{'4322'} = 'G'; $poststed{'4322'} = 'SANDNES';
$postkommune{'4323'} = '1102'; $kategori{'4323'} = 'G'; $poststed{'4323'} = 'SANDNES';
$postkommune{'4324'} = '1102'; $kategori{'4324'} = 'G'; $poststed{'4324'} = 'SANDNES';
$postkommune{'4325'} = '1102'; $kategori{'4325'} = 'G'; $poststed{'4325'} = 'SANDNES';
$postkommune{'4326'} = '1102'; $kategori{'4326'} = 'G'; $poststed{'4326'} = 'SANDNES';
$postkommune{'4327'} = '1102'; $kategori{'4327'} = 'G'; $poststed{'4327'} = 'SANDNES';
$postkommune{'4328'} = '1102'; $kategori{'4328'} = 'G'; $poststed{'4328'} = 'SANDNES';
$postkommune{'4329'} = '1102'; $kategori{'4329'} = 'G'; $poststed{'4329'} = 'SANDNES';
$postkommune{'4330'} = '1122'; $kategori{'4330'} = 'G'; $poststed{'4330'} = 'LGRD';
$postkommune{'4332'} = '1102'; $kategori{'4332'} = 'G'; $poststed{'4332'} = 'FIGGJO';
$postkommune{'4333'} = '1122'; $kategori{'4333'} = 'B'; $poststed{'4333'} = 'OLTEDAL';
$postkommune{'4335'} = '1122'; $kategori{'4335'} = 'G'; $poststed{'4335'} = 'DIRDAL';
$postkommune{'4339'} = '1122'; $kategori{'4339'} = 'P'; $poststed{'4339'} = 'LGRD';
$postkommune{'4340'} = '1121'; $kategori{'4340'} = 'G'; $poststed{'4340'} = 'BRYNE';
$postkommune{'4342'} = '1121'; $kategori{'4342'} = 'G'; $poststed{'4342'} = 'UNDHEIM';
$postkommune{'4343'} = '1120'; $kategori{'4343'} = 'G'; $poststed{'4343'} = 'ORRE';
$postkommune{'4348'} = '1121'; $kategori{'4348'} = 'P'; $poststed{'4348'} = 'BRYNE';
$postkommune{'4349'} = '1121'; $kategori{'4349'} = 'P'; $poststed{'4349'} = 'BRYNE';
$postkommune{'4352'} = '1120'; $kategori{'4352'} = 'G'; $poststed{'4352'} = 'KLEPPE';
$postkommune{'4353'} = '1120'; $kategori{'4353'} = 'G'; $poststed{'4353'} = 'KLEPP STASJON';
$postkommune{'4354'} = '1120'; $kategori{'4354'} = 'G'; $poststed{'4354'} = 'VOLL';
$postkommune{'4355'} = '1121'; $kategori{'4355'} = 'G'; $poststed{'4355'} = 'KVERNALAND';
$postkommune{'4356'} = '1121'; $kategori{'4356'} = 'P'; $poststed{'4356'} = 'KVERNALAND';
$postkommune{'4357'} = '1120'; $kategori{'4357'} = 'P'; $poststed{'4357'} = 'KLEPP STASJON';
$postkommune{'4358'} = '1120'; $kategori{'4358'} = 'P'; $poststed{'4358'} = 'KLEPPE';
$postkommune{'4360'} = '1119'; $kategori{'4360'} = 'G'; $poststed{'4360'} = 'VARHAUG';
$postkommune{'4362'} = '1119'; $kategori{'4362'} = 'G'; $poststed{'4362'} = 'VIGRESTAD';
$postkommune{'4363'} = '1119'; $kategori{'4363'} = 'G'; $poststed{'4363'} = 'BRUSAND';
$postkommune{'4364'} = '1119'; $kategori{'4364'} = 'B'; $poststed{'4364'} = 'SIREVG';
$postkommune{'4365'} = '1119'; $kategori{'4365'} = 'G'; $poststed{'4365'} = 'NRB';
$postkommune{'4367'} = '1119'; $kategori{'4367'} = 'P'; $poststed{'4367'} = 'NRB';
$postkommune{'4368'} = '1119'; $kategori{'4368'} = 'P'; $poststed{'4368'} = 'VARHAUG';
$postkommune{'4369'} = '1119'; $kategori{'4369'} = 'P'; $poststed{'4369'} = 'VIGRESTAD';
$postkommune{'4370'} = '1101'; $kategori{'4370'} = 'B'; $poststed{'4370'} = 'EGERSUND';
$postkommune{'4375'} = '1101'; $kategori{'4375'} = 'G'; $poststed{'4375'} = 'HELLVIK';
$postkommune{'4376'} = '1101'; $kategori{'4376'} = 'B'; $poststed{'4376'} = 'HELLELAND';
$postkommune{'4379'} = '1101'; $kategori{'4379'} = 'P'; $poststed{'4379'} = 'EGERSUND';
$postkommune{'4380'} = '1111'; $kategori{'4380'} = 'G'; $poststed{'4380'} = 'HAUGE I DALANE';
$postkommune{'4381'} = '1111'; $kategori{'4381'} = 'P'; $poststed{'4381'} = 'HAUGE I DALANE';
$postkommune{'4387'} = '1114'; $kategori{'4387'} = 'G'; $poststed{'4387'} = 'BJERKREIM';
$postkommune{'4389'} = '1114'; $kategori{'4389'} = 'B'; $poststed{'4389'} = 'VIKES';
$postkommune{'4391'} = '1102'; $kategori{'4391'} = 'P'; $poststed{'4391'} = 'SANDNES';
$postkommune{'4392'} = '1102'; $kategori{'4392'} = 'P'; $poststed{'4392'} = 'SANDNES';
$postkommune{'4393'} = '1102'; $kategori{'4393'} = 'P'; $poststed{'4393'} = 'SANDNES';
$postkommune{'4395'} = '1102'; $kategori{'4395'} = 'P'; $poststed{'4395'} = 'HOMMERSK';
$postkommune{'4396'} = '1102'; $kategori{'4396'} = 'P'; $poststed{'4396'} = 'SANDNES';
$postkommune{'4397'} = '1102'; $kategori{'4397'} = 'P'; $poststed{'4397'} = 'SANDNES';
$postkommune{'4398'} = '1102'; $kategori{'4398'} = 'P'; $poststed{'4398'} = 'SANDNES';
$postkommune{'4400'} = '1004'; $kategori{'4400'} = 'G'; $poststed{'4400'} = 'FLEKKEFJORD';
$postkommune{'4401'} = '1004'; $kategori{'4401'} = 'P'; $poststed{'4401'} = 'FLEKKEFJORD';
$postkommune{'4402'} = '1004'; $kategori{'4402'} = 'P'; $poststed{'4402'} = 'FLEKKEFJORD';
$postkommune{'4403'} = '1004'; $kategori{'4403'} = 'P'; $poststed{'4403'} = 'FLEKKEFJORD';
$postkommune{'4420'} = '1004'; $kategori{'4420'} = 'G'; $poststed{'4420'} = 'NA-SIRA';
$postkommune{'4432'} = '1004'; $kategori{'4432'} = 'G'; $poststed{'4432'} = 'HIDRASUND';
$postkommune{'4434'} = '1004'; $kategori{'4434'} = 'G'; $poststed{'4434'} = 'ANDABELY';
$postkommune{'4436'} = '1004'; $kategori{'4436'} = 'G'; $poststed{'4436'} = 'GYLAND';
$postkommune{'4438'} = '1004'; $kategori{'4438'} = 'B'; $poststed{'4438'} = 'SIRA';
$postkommune{'4440'} = '1046'; $kategori{'4440'} = 'G'; $poststed{'4440'} = 'TONSTAD';
$postkommune{'4441'} = '1046'; $kategori{'4441'} = 'P'; $poststed{'4441'} = 'TONSTAD';
$postkommune{'4443'} = '1046'; $kategori{'4443'} = 'G'; $poststed{'4443'} = 'TJRHOM';
$postkommune{'4460'} = '1112'; $kategori{'4460'} = 'G'; $poststed{'4460'} = 'MOI';
$postkommune{'4462'} = '1112'; $kategori{'4462'} = 'G'; $poststed{'4462'} = 'HOVSHERAD';
$postkommune{'4463'} = '1112'; $kategori{'4463'} = 'G'; $poststed{'4463'} = 'UALAND';
$postkommune{'4465'} = '1112'; $kategori{'4465'} = 'P'; $poststed{'4465'} = 'MOI';
$postkommune{'4473'} = '1037'; $kategori{'4473'} = 'G'; $poststed{'4473'} = 'KVINLOG';
$postkommune{'4480'} = '1037'; $kategori{'4480'} = 'G'; $poststed{'4480'} = 'KVINESDAL';
$postkommune{'4484'} = '1037'; $kategori{'4484'} = 'G'; $poststed{'4484'} = 'YESTRANDA';
$postkommune{'4485'} = '1037'; $kategori{'4485'} = 'B'; $poststed{'4485'} = 'FEDA';
$postkommune{'4490'} = '1037'; $kategori{'4490'} = 'P'; $poststed{'4490'} = 'KVINESDAL';
$postkommune{'4491'} = '1037'; $kategori{'4491'} = 'P'; $poststed{'4491'} = 'KVINESDAL';
$postkommune{'4492'} = '1037'; $kategori{'4492'} = 'P'; $poststed{'4492'} = 'KVINESDAL';
$postkommune{'4501'} = '1002'; $kategori{'4501'} = 'P'; $poststed{'4501'} = 'MANDAL';
$postkommune{'4502'} = '1002'; $kategori{'4502'} = 'P'; $poststed{'4502'} = 'MANDAL';
$postkommune{'4503'} = '1002'; $kategori{'4503'} = 'P'; $poststed{'4503'} = 'MANDAL';
$postkommune{'4504'} = '1002'; $kategori{'4504'} = 'P'; $poststed{'4504'} = 'MANDAL';
$postkommune{'4505'} = '1002'; $kategori{'4505'} = 'P'; $poststed{'4505'} = 'MANDAL';
$postkommune{'4506'} = '1002'; $kategori{'4506'} = 'P'; $poststed{'4506'} = 'MANDAL';
$postkommune{'4509'} = '1002'; $kategori{'4509'} = 'S'; $poststed{'4509'} = 'MANDAL';
$postkommune{'4512'} = '1029'; $kategori{'4512'} = 'G'; $poststed{'4512'} = 'LINDESNES';
$postkommune{'4513'} = '1002'; $kategori{'4513'} = 'G'; $poststed{'4513'} = 'MANDAL';
$postkommune{'4514'} = '1002'; $kategori{'4514'} = 'G'; $poststed{'4514'} = 'MANDAL';
$postkommune{'4515'} = '1002'; $kategori{'4515'} = 'G'; $poststed{'4515'} = 'MANDAL';
$postkommune{'4516'} = '1002'; $kategori{'4516'} = 'G'; $poststed{'4516'} = 'MANDAL';
$postkommune{'4517'} = '1002'; $kategori{'4517'} = 'G'; $poststed{'4517'} = 'MANDAL';
$postkommune{'4519'} = '1002'; $kategori{'4519'} = 'G'; $poststed{'4519'} = 'HOLUM';
$postkommune{'4520'} = '1029'; $kategori{'4520'} = 'G'; $poststed{'4520'} = 'SR-AUDNEDAL';
$postkommune{'4521'} = '1029'; $kategori{'4521'} = 'B'; $poststed{'4521'} = 'SPANGEREID';
$postkommune{'4523'} = '1029'; $kategori{'4523'} = 'P'; $poststed{'4523'} = 'SR-AUDNEDAL';
$postkommune{'4524'} = '1029'; $kategori{'4524'} = 'P'; $poststed{'4524'} = 'SR-AUDNEDAL';
$postkommune{'4525'} = '1027'; $kategori{'4525'} = 'B'; $poststed{'4525'} = 'KONSMO';
$postkommune{'4528'} = '1027'; $kategori{'4528'} = 'G'; $poststed{'4528'} = 'KOLLUNGTVEIT';
$postkommune{'4529'} = '1027'; $kategori{'4529'} = 'G'; $poststed{'4529'} = 'BYREMO';
$postkommune{'4532'} = '1021'; $kategori{'4532'} = 'G'; $poststed{'4532'} = 'YSLEB';
$postkommune{'4534'} = '1021'; $kategori{'4534'} = 'B'; $poststed{'4534'} = 'MARNARDAL';
$postkommune{'4536'} = '1021'; $kategori{'4536'} = 'G'; $poststed{'4536'} = 'BJELLAND';
$postkommune{'4540'} = '1026'; $kategori{'4540'} = 'B'; $poststed{'4540'} = 'SERAL';
$postkommune{'4544'} = '1026'; $kategori{'4544'} = 'G'; $poststed{'4544'} = 'FOSSDAL';
$postkommune{'4550'} = '1003'; $kategori{'4550'} = 'G'; $poststed{'4550'} = 'FARSUND';
$postkommune{'4551'} = '1003'; $kategori{'4551'} = 'P'; $poststed{'4551'} = 'FARSUND';
$postkommune{'4552'} = '1003'; $kategori{'4552'} = 'P'; $poststed{'4552'} = 'FARSUND';
$postkommune{'4553'} = '1003'; $kategori{'4553'} = 'P'; $poststed{'4553'} = 'FARSUND';
$postkommune{'4554'} = '1003'; $kategori{'4554'} = 'P'; $poststed{'4554'} = 'FARSUND';
$postkommune{'4557'} = '1003'; $kategori{'4557'} = 'P'; $poststed{'4557'} = 'VANSE';
$postkommune{'4558'} = '1003'; $kategori{'4558'} = 'P'; $poststed{'4558'} = 'VANSE';
$postkommune{'4560'} = '1003'; $kategori{'4560'} = 'G'; $poststed{'4560'} = 'VANSE';
$postkommune{'4563'} = '1003'; $kategori{'4563'} = 'G'; $poststed{'4563'} = 'BORHAUG';
$postkommune{'4575'} = '1032'; $kategori{'4575'} = 'P'; $poststed{'4575'} = 'LYNGDAL';
$postkommune{'4576'} = '1032'; $kategori{'4576'} = 'P'; $poststed{'4576'} = 'LYNGDAL';
$postkommune{'4577'} = '1032'; $kategori{'4577'} = 'P'; $poststed{'4577'} = 'LYNGDAL';
$postkommune{'4579'} = '1032'; $kategori{'4579'} = 'P'; $poststed{'4579'} = 'LYNGDAL';
$postkommune{'4580'} = '1032'; $kategori{'4580'} = 'G'; $poststed{'4580'} = 'LYNGDAL';
$postkommune{'4586'} = '1032'; $kategori{'4586'} = 'G'; $poststed{'4586'} = 'KORSHAMN';
$postkommune{'4588'} = '1032'; $kategori{'4588'} = 'G'; $poststed{'4588'} = 'KVS';
$postkommune{'4590'} = '1034'; $kategori{'4590'} = 'G'; $poststed{'4590'} = 'SNARTEMO';
$postkommune{'4595'} = '1034'; $kategori{'4595'} = 'G'; $poststed{'4595'} = 'TINGVATN';
$postkommune{'4596'} = '1034'; $kategori{'4596'} = 'B'; $poststed{'4596'} = 'EIKEN';
$postkommune{'4604'} = '1001'; $kategori{'4604'} = 'S'; $poststed{'4604'} = 'KRISTIANSAND S';
$postkommune{'4605'} = '1001'; $kategori{'4605'} = 'S'; $poststed{'4605'} = 'KRISTIANSAND S';
$postkommune{'4606'} = '1001'; $kategori{'4606'} = 'S'; $poststed{'4606'} = 'KRISTIANSAND S';
$postkommune{'4609'} = '1001'; $kategori{'4609'} = 'G'; $poststed{'4609'} = 'KARDEMOMME BY';
$postkommune{'4610'} = '1001'; $kategori{'4610'} = 'G'; $poststed{'4610'} = 'KRISTIANSAND S';
$postkommune{'4611'} = '1001'; $kategori{'4611'} = 'G'; $poststed{'4611'} = 'KRISTIANSAND S';
$postkommune{'4612'} = '1001'; $kategori{'4612'} = 'G'; $poststed{'4612'} = 'KRISTIANSAND S';
$postkommune{'4613'} = '1001'; $kategori{'4613'} = 'G'; $poststed{'4613'} = 'KRISTIANSAND S';
$postkommune{'4614'} = '1001'; $kategori{'4614'} = 'G'; $poststed{'4614'} = 'KRISTIANSAND S';
$postkommune{'4615'} = '1001'; $kategori{'4615'} = 'G'; $poststed{'4615'} = 'KRISTIANSAND S';
$postkommune{'4616'} = '1001'; $kategori{'4616'} = 'G'; $poststed{'4616'} = 'KRISTIANSAND S';
$postkommune{'4617'} = '1001'; $kategori{'4617'} = 'G'; $poststed{'4617'} = 'KRISTIANSAND S';
$postkommune{'4618'} = '1001'; $kategori{'4618'} = 'B'; $poststed{'4618'} = 'KRISTIANSAND S';
$postkommune{'4619'} = '1001'; $kategori{'4619'} = 'G'; $poststed{'4619'} = 'MOSBY';
$postkommune{'4620'} = '1001'; $kategori{'4620'} = 'G'; $poststed{'4620'} = 'KRISTIANSAND S';
$postkommune{'4621'} = '1001'; $kategori{'4621'} = 'G'; $poststed{'4621'} = 'KRISTIANSAND S';
$postkommune{'4622'} = '1001'; $kategori{'4622'} = 'G'; $poststed{'4622'} = 'KRISTIANSAND S';
$postkommune{'4623'} = '1001'; $kategori{'4623'} = 'G'; $poststed{'4623'} = 'KRISTIANSAND S';
$postkommune{'4624'} = '1001'; $kategori{'4624'} = 'G'; $poststed{'4624'} = 'KRISTIANSAND S';
$postkommune{'4625'} = '1001'; $kategori{'4625'} = 'G'; $poststed{'4625'} = 'FLEKKERY';
$postkommune{'4626'} = '1001'; $kategori{'4626'} = 'B'; $poststed{'4626'} = 'KRISTIANSAND S';
$postkommune{'4628'} = '1001'; $kategori{'4628'} = 'G'; $poststed{'4628'} = 'KRISTIANSAND S';
$postkommune{'4629'} = '1001'; $kategori{'4629'} = 'B'; $poststed{'4629'} = 'KRISTIANSAND S';
$postkommune{'4630'} = '1001'; $kategori{'4630'} = 'G'; $poststed{'4630'} = 'KRISTIANSAND S';
$postkommune{'4631'} = '1001'; $kategori{'4631'} = 'G'; $poststed{'4631'} = 'KRISTIANSAND S';
$postkommune{'4632'} = '1001'; $kategori{'4632'} = 'G'; $poststed{'4632'} = 'KRISTIANSAND S';
$postkommune{'4633'} = '1001'; $kategori{'4633'} = 'G'; $poststed{'4633'} = 'KRISTIANSAND S';
$postkommune{'4634'} = '1001'; $kategori{'4634'} = 'B'; $poststed{'4634'} = 'KRISTIANSAND S';
$postkommune{'4635'} = '1001'; $kategori{'4635'} = 'G'; $poststed{'4635'} = 'KRISTIANSAND S';
$postkommune{'4636'} = '1001'; $kategori{'4636'} = 'G'; $poststed{'4636'} = 'KRISTIANSAND S';
$postkommune{'4637'} = '1001'; $kategori{'4637'} = 'G'; $poststed{'4637'} = 'KRISTIANSAND S';
$postkommune{'4638'} = '1001'; $kategori{'4638'} = 'G'; $poststed{'4638'} = 'KRISTIANSAND S';
$postkommune{'4639'} = '1001'; $kategori{'4639'} = 'B'; $poststed{'4639'} = 'KRISTIANSAND S';
$postkommune{'4640'} = '1018'; $kategori{'4640'} = 'B'; $poststed{'4640'} = 'SGNE';
$postkommune{'4645'} = '1017'; $kategori{'4645'} = 'G'; $poststed{'4645'} = 'NODELAND';
$postkommune{'4646'} = '1017'; $kategori{'4646'} = 'B'; $poststed{'4646'} = 'FINSLAND';
$postkommune{'4647'} = '1017'; $kategori{'4647'} = 'B'; $poststed{'4647'} = 'BRENNSEN';
$postkommune{'4651'} = '1001'; $kategori{'4651'} = 'P'; $poststed{'4651'} = 'HAMRESANDEN';
$postkommune{'4656'} = '1001'; $kategori{'4656'} = 'G'; $poststed{'4656'} = 'HAMRESANDEN';
$postkommune{'4657'} = '1001'; $kategori{'4657'} = 'G'; $poststed{'4657'} = 'KJEVIK';
$postkommune{'4658'} = '1001'; $kategori{'4658'} = 'G'; $poststed{'4658'} = 'TVEIT';
$postkommune{'4659'} = '1001'; $kategori{'4659'} = 'P'; $poststed{'4659'} = 'KRISTIANSAND S';
$postkommune{'4661'} = '1001'; $kategori{'4661'} = 'P'; $poststed{'4661'} = 'KRISTIANSAND S';
$postkommune{'4662'} = '1001'; $kategori{'4662'} = 'P'; $poststed{'4662'} = 'KRISTIANSAND S';
$postkommune{'4663'} = '1001'; $kategori{'4663'} = 'P'; $poststed{'4663'} = 'KRISTIANSAND S';
$postkommune{'4664'} = '1001'; $kategori{'4664'} = 'P'; $poststed{'4664'} = 'KRISTIANSAND S';
$postkommune{'4665'} = '1001'; $kategori{'4665'} = 'P'; $poststed{'4665'} = 'KRISTIANSAND S';
$postkommune{'4666'} = '1001'; $kategori{'4666'} = 'P'; $poststed{'4666'} = 'KRISTIANSAND S';
$postkommune{'4671'} = '1001'; $kategori{'4671'} = 'P'; $poststed{'4671'} = 'MOSBY';
$postkommune{'4672'} = '1001'; $kategori{'4672'} = 'P'; $poststed{'4672'} = 'KRISTIANSAND S';
$postkommune{'4673'} = '1001'; $kategori{'4673'} = 'P'; $poststed{'4673'} = 'KRISTIANSAND S';
$postkommune{'4674'} = '1001'; $kategori{'4674'} = 'P'; $poststed{'4674'} = 'KRISTIANSAND S';
$postkommune{'4675'} = '1001'; $kategori{'4675'} = 'P'; $poststed{'4675'} = 'KRISTIANSAND S';
$postkommune{'4676'} = '1001'; $kategori{'4676'} = 'P'; $poststed{'4676'} = 'KRISTIANSAND S';
$postkommune{'4677'} = '1001'; $kategori{'4677'} = 'P'; $poststed{'4677'} = 'KRISTIANSAND S';
$postkommune{'4678'} = '1001'; $kategori{'4678'} = 'P'; $poststed{'4678'} = 'KRISTIANSAND S';
$postkommune{'4679'} = '1001'; $kategori{'4679'} = 'P'; $poststed{'4679'} = 'FLEKKERY';
$postkommune{'4682'} = '1018'; $kategori{'4682'} = 'P'; $poststed{'4682'} = 'SGNE';
$postkommune{'4683'} = '1018'; $kategori{'4683'} = 'P'; $poststed{'4683'} = 'SGNE';
$postkommune{'4685'} = '1017'; $kategori{'4685'} = 'P'; $poststed{'4685'} = 'NODELAND';
$postkommune{'4686'} = '1001'; $kategori{'4686'} = 'P'; $poststed{'4686'} = 'KRISTIANSAND S';
$postkommune{'4687'} = '1001'; $kategori{'4687'} = 'P'; $poststed{'4687'} = 'KRISTIANSAND S';
$postkommune{'4688'} = '1001'; $kategori{'4688'} = 'P'; $poststed{'4688'} = 'KRISTIANSAND S';
$postkommune{'4689'} = '1001'; $kategori{'4689'} = 'P'; $poststed{'4689'} = 'KRISTIANSAND S';
$postkommune{'4691'} = '1001'; $kategori{'4691'} = 'P'; $poststed{'4691'} = 'KRISTIANSAND S';
$postkommune{'4693'} = '1001'; $kategori{'4693'} = 'P'; $poststed{'4693'} = 'KRISTIANSAND S';
$postkommune{'4696'} = '1001'; $kategori{'4696'} = 'P'; $poststed{'4696'} = 'KRISTIANSAND S';
$postkommune{'4697'} = '1001'; $kategori{'4697'} = 'P'; $poststed{'4697'} = 'KRISTIANSAND S';
$postkommune{'4699'} = '1001'; $kategori{'4699'} = 'P'; $poststed{'4699'} = 'TVEIT';
$postkommune{'4700'} = '1014'; $kategori{'4700'} = 'G'; $poststed{'4700'} = 'VENNESLA';
$postkommune{'4701'} = '1014'; $kategori{'4701'} = 'P'; $poststed{'4701'} = 'VENNESLA';
$postkommune{'4702'} = '1014'; $kategori{'4702'} = 'P'; $poststed{'4702'} = 'VENNESLA';
$postkommune{'4703'} = '1014'; $kategori{'4703'} = 'P'; $poststed{'4703'} = 'VENNESLA';
$postkommune{'4705'} = '1014'; $kategori{'4705'} = 'P'; $poststed{'4705'} = 'VREB';
$postkommune{'4715'} = '1014'; $kategori{'4715'} = 'G'; $poststed{'4715'} = 'VREB';
$postkommune{'4720'} = '1014'; $kategori{'4720'} = 'B'; $poststed{'4720'} = 'HGELAND';
$postkommune{'4724'} = '0935'; $kategori{'4724'} = 'B'; $poststed{'4724'} = 'IVELAND';
$postkommune{'4730'} = '0935'; $kategori{'4730'} = 'G'; $poststed{'4730'} = 'VATNESTRM';
$postkommune{'4733'} = '0937'; $kategori{'4733'} = 'P'; $poststed{'4733'} = 'EVJE';
$postkommune{'4734'} = '0937'; $kategori{'4734'} = 'P'; $poststed{'4734'} = 'EVJE';
$postkommune{'4735'} = '0937'; $kategori{'4735'} = 'B'; $poststed{'4735'} = 'EVJE';
$postkommune{'4737'} = '0937'; $kategori{'4737'} = 'G'; $poststed{'4737'} = 'HORNNES';
$postkommune{'4741'} = '0938'; $kategori{'4741'} = 'G'; $poststed{'4741'} = 'BYGLANDSFJORD';
$postkommune{'4742'} = '0938'; $kategori{'4742'} = 'B'; $poststed{'4742'} = 'GRENDI';
$postkommune{'4745'} = '0938'; $kategori{'4745'} = 'B'; $poststed{'4745'} = 'BYGLAND';
$postkommune{'4747'} = '0940'; $kategori{'4747'} = 'B'; $poststed{'4747'} = 'VALLE';
$postkommune{'4748'} = '0940'; $kategori{'4748'} = 'B'; $poststed{'4748'} = 'RYSSTAD';
$postkommune{'4754'} = '0941'; $kategori{'4754'} = 'G'; $poststed{'4754'} = 'BYKLE';
$postkommune{'4755'} = '0941'; $kategori{'4755'} = 'B'; $poststed{'4755'} = 'HOVDEN I SETESDAL';
$postkommune{'4760'} = '0928'; $kategori{'4760'} = 'G'; $poststed{'4760'} = 'BIRKELAND';
$postkommune{'4766'} = '0928'; $kategori{'4766'} = 'G'; $poststed{'4766'} = 'HEREFOSS';
$postkommune{'4768'} = '0928'; $kategori{'4768'} = 'G'; $poststed{'4768'} = 'ENGESLAND';
$postkommune{'4770'} = '0926'; $kategori{'4770'} = 'B'; $poststed{'4770'} = 'HVG';
$postkommune{'4780'} = '0926'; $kategori{'4780'} = 'G'; $poststed{'4780'} = 'BREKKEST';
$postkommune{'4790'} = '0926'; $kategori{'4790'} = 'G'; $poststed{'4790'} = 'LILLESAND';
$postkommune{'4791'} = '0926'; $kategori{'4791'} = 'P'; $poststed{'4791'} = 'LILLESAND';
$postkommune{'4792'} = '0926'; $kategori{'4792'} = 'P'; $poststed{'4792'} = 'LILLESAND';
$postkommune{'4794'} = '0926'; $kategori{'4794'} = 'P'; $poststed{'4794'} = 'LILLESAND';
$postkommune{'4795'} = '0928'; $kategori{'4795'} = 'P'; $poststed{'4795'} = 'BIRKELAND';
$postkommune{'4801'} = '0906'; $kategori{'4801'} = 'P'; $poststed{'4801'} = 'ARENDAL';
$postkommune{'4802'} = '0906'; $kategori{'4802'} = 'P'; $poststed{'4802'} = 'ARENDAL';
$postkommune{'4803'} = '0906'; $kategori{'4803'} = 'P'; $poststed{'4803'} = 'ARENDAL';
$postkommune{'4804'} = '0906'; $kategori{'4804'} = 'P'; $poststed{'4804'} = 'ARENDAL';
$postkommune{'4808'} = '0906'; $kategori{'4808'} = 'S'; $poststed{'4808'} = 'ARENDAL';
$postkommune{'4809'} = '0906'; $kategori{'4809'} = 'S'; $poststed{'4809'} = 'ARENDAL';
$postkommune{'4810'} = '0906'; $kategori{'4810'} = 'G'; $poststed{'4810'} = 'EYDEHAVN';
$postkommune{'4812'} = '0906'; $kategori{'4812'} = 'G'; $poststed{'4812'} = 'KONGSHAVN';
$postkommune{'4815'} = '0906'; $kategori{'4815'} = 'G'; $poststed{'4815'} = 'SALTRD';
$postkommune{'4816'} = '0906'; $kategori{'4816'} = 'G'; $poststed{'4816'} = 'KOLBJRNSVIK';
$postkommune{'4817'} = '0906'; $kategori{'4817'} = 'G'; $poststed{'4817'} = 'HIS';
$postkommune{'4818'} = '0906'; $kategori{'4818'} = 'G'; $poststed{'4818'} = 'FRVIK';
$postkommune{'4820'} = '0919'; $kategori{'4820'} = 'G'; $poststed{'4820'} = 'FROLAND';
$postkommune{'4821'} = '0906'; $kategori{'4821'} = 'B'; $poststed{'4821'} = 'RYKENE';
$postkommune{'4823'} = '0906'; $kategori{'4823'} = 'G'; $poststed{'4823'} = 'NEDENES';
$postkommune{'4824'} = '0906'; $kategori{'4824'} = 'G'; $poststed{'4824'} = 'BJORBEKK';
$postkommune{'4825'} = '0906'; $kategori{'4825'} = 'G'; $poststed{'4825'} = 'ARENDAL';
$postkommune{'4827'} = '0919'; $kategori{'4827'} = 'G'; $poststed{'4827'} = 'FROLANDS VERK';
$postkommune{'4828'} = '0919'; $kategori{'4828'} = 'G'; $poststed{'4828'} = 'MJVATN';
$postkommune{'4830'} = '0919'; $kategori{'4830'} = 'G'; $poststed{'4830'} = 'HYNNEKLEIV';
$postkommune{'4832'} = '0919'; $kategori{'4832'} = 'G'; $poststed{'4832'} = 'MYKLAND';
$postkommune{'4834'} = '0919'; $kategori{'4834'} = 'G'; $poststed{'4834'} = 'RISDAL';
$postkommune{'4836'} = '0906'; $kategori{'4836'} = 'G'; $poststed{'4836'} = 'ARENDAL';
$postkommune{'4838'} = '0906'; $kategori{'4838'} = 'G'; $poststed{'4838'} = 'ARENDAL';
$postkommune{'4839'} = '0906'; $kategori{'4839'} = 'G'; $poststed{'4839'} = 'ARENDAL';
$postkommune{'4841'} = '0906'; $kategori{'4841'} = 'G'; $poststed{'4841'} = 'ARENDAL';
$postkommune{'4842'} = '0906'; $kategori{'4842'} = 'G'; $poststed{'4842'} = 'ARENDAL';
$postkommune{'4843'} = '0906'; $kategori{'4843'} = 'G'; $poststed{'4843'} = 'ARENDAL';
$postkommune{'4844'} = '0906'; $kategori{'4844'} = 'G'; $poststed{'4844'} = 'ARENDAL';
$postkommune{'4846'} = '0906'; $kategori{'4846'} = 'G'; $poststed{'4846'} = 'ARENDAL';
$postkommune{'4847'} = '0906'; $kategori{'4847'} = 'G'; $poststed{'4847'} = 'ARENDAL';
$postkommune{'4848'} = '0906'; $kategori{'4848'} = 'G'; $poststed{'4848'} = 'ARENDAL';
$postkommune{'4849'} = '0906'; $kategori{'4849'} = 'G'; $poststed{'4849'} = 'ARENDAL';
$postkommune{'4851'} = '0906'; $kategori{'4851'} = 'P'; $poststed{'4851'} = 'SALTRD';
$postkommune{'4852'} = '0906'; $kategori{'4852'} = 'P'; $poststed{'4852'} = 'FRVIK';
$postkommune{'4853'} = '0906'; $kategori{'4853'} = 'P'; $poststed{'4853'} = 'HIS';
$postkommune{'4854'} = '0906'; $kategori{'4854'} = 'P'; $poststed{'4854'} = 'NEDENES';
$postkommune{'4855'} = '0919'; $kategori{'4855'} = 'P'; $poststed{'4855'} = 'FROLAND';
$postkommune{'4856'} = '0906'; $kategori{'4856'} = 'P'; $poststed{'4856'} = 'ARENDAL';
$postkommune{'4857'} = '0906'; $kategori{'4857'} = 'P'; $poststed{'4857'} = 'ARENDAL';
$postkommune{'4858'} = '0906'; $kategori{'4858'} = 'P'; $poststed{'4858'} = 'ARENDAL';
$postkommune{'4859'} = '0906'; $kategori{'4859'} = 'P'; $poststed{'4859'} = 'ARENDAL';
$postkommune{'4861'} = '0906'; $kategori{'4861'} = 'P'; $poststed{'4861'} = 'ARENDAL';
$postkommune{'4862'} = '0906'; $kategori{'4862'} = 'P'; $poststed{'4862'} = 'EYDEHAVN';
$postkommune{'4863'} = '0929'; $kategori{'4863'} = 'B'; $poststed{'4863'} = 'NELAUG';
$postkommune{'4864'} = '0929'; $kategori{'4864'} = 'P'; $poststed{'4864'} = 'MLI';
$postkommune{'4865'} = '0929'; $kategori{'4865'} = 'G'; $poststed{'4865'} = 'MLI';
$postkommune{'4868'} = '0929'; $kategori{'4868'} = 'G'; $poststed{'4868'} = 'SELSVATN';
$postkommune{'4869'} = '0929'; $kategori{'4869'} = 'G'; $poststed{'4869'} = 'DLEMO';
$postkommune{'4870'} = '0904'; $kategori{'4870'} = 'G'; $poststed{'4870'} = 'FEVIK';
$postkommune{'4876'} = '0904'; $kategori{'4876'} = 'G'; $poststed{'4876'} = 'GRIMSTAD';
$postkommune{'4877'} = '0904'; $kategori{'4877'} = 'G'; $poststed{'4877'} = 'GRIMSTAD';
$postkommune{'4878'} = '0904'; $kategori{'4878'} = 'G'; $poststed{'4878'} = 'GRIMSTAD';
$postkommune{'4879'} = '0904'; $kategori{'4879'} = 'G'; $poststed{'4879'} = 'GRIMSTAD';
$postkommune{'4884'} = '0904'; $kategori{'4884'} = 'P'; $poststed{'4884'} = 'GRIMSTAD';
$postkommune{'4885'} = '0904'; $kategori{'4885'} = 'G'; $poststed{'4885'} = 'GRIMSTAD';
$postkommune{'4886'} = '0904'; $kategori{'4886'} = 'G'; $poststed{'4886'} = 'GRIMSTAD';
$postkommune{'4887'} = '0904'; $kategori{'4887'} = 'G'; $poststed{'4887'} = 'GRIMSTAD';
$postkommune{'4888'} = '0904'; $kategori{'4888'} = 'G'; $poststed{'4888'} = 'HOMBORSUND';
$postkommune{'4889'} = '0904'; $kategori{'4889'} = 'P'; $poststed{'4889'} = 'FEVIK';
$postkommune{'4891'} = '0904'; $kategori{'4891'} = 'P'; $poststed{'4891'} = 'GRIMSTAD';
$postkommune{'4892'} = '0904'; $kategori{'4892'} = 'P'; $poststed{'4892'} = 'GRIMSTAD';
$postkommune{'4894'} = '0904'; $kategori{'4894'} = 'K'; $poststed{'4894'} = 'GRIMSTAD';
$postkommune{'4895'} = '0904'; $kategori{'4895'} = 'K'; $poststed{'4895'} = 'GRIMSTAD';
$postkommune{'4896'} = '0904'; $kategori{'4896'} = 'K'; $poststed{'4896'} = 'GRIMSTAD';
$postkommune{'4898'} = '0904'; $kategori{'4898'} = 'S'; $poststed{'4898'} = 'GRIMSTAD';
$postkommune{'4900'} = '0914'; $kategori{'4900'} = 'G'; $poststed{'4900'} = 'TVEDESTRAND';
$postkommune{'4901'} = '0914'; $kategori{'4901'} = 'P'; $poststed{'4901'} = 'TVEDESTRAND';
$postkommune{'4902'} = '0914'; $kategori{'4902'} = 'P'; $poststed{'4902'} = 'TVEDESTRAND';
$postkommune{'4909'} = '0914'; $kategori{'4909'} = 'G'; $poststed{'4909'} = 'SONGE';
$postkommune{'4910'} = '0914'; $kategori{'4910'} = 'B'; $poststed{'4910'} = 'LYNGR';
$postkommune{'4912'} = '0914'; $kategori{'4912'} = 'G'; $poststed{'4912'} = 'GJEVING';
$postkommune{'4915'} = '0914'; $kategori{'4915'} = 'G'; $poststed{'4915'} = 'VESTRE SANDYA';
$postkommune{'4916'} = '0914'; $kategori{'4916'} = 'G'; $poststed{'4916'} = 'BORY';
$postkommune{'4920'} = '0906'; $kategori{'4920'} = 'B'; $poststed{'4920'} = 'STAUB';
$postkommune{'4934'} = '0914'; $kategori{'4934'} = 'G'; $poststed{'4934'} = 'NESGRENDA';
$postkommune{'4950'} = '0901'; $kategori{'4950'} = 'G'; $poststed{'4950'} = 'RISR';
$postkommune{'4951'} = '0901'; $kategori{'4951'} = 'P'; $poststed{'4951'} = 'RISR';
$postkommune{'4952'} = '0901'; $kategori{'4952'} = 'P'; $poststed{'4952'} = 'RISR';
$postkommune{'4953'} = '0901'; $kategori{'4953'} = 'P'; $poststed{'4953'} = 'RISR';
$postkommune{'4955'} = '0901'; $kategori{'4955'} = 'P'; $poststed{'4955'} = 'RISR';
$postkommune{'4971'} = '0911'; $kategori{'4971'} = 'P'; $poststed{'4971'} = 'SUNDEBRU';
$postkommune{'4972'} = '0911'; $kategori{'4972'} = 'P'; $poststed{'4972'} = 'GJERSTAD';
$postkommune{'4973'} = '0912'; $kategori{'4973'} = 'P'; $poststed{'4973'} = 'VEGRSHEI';
$postkommune{'4974'} = '0901'; $kategori{'4974'} = 'P'; $poststed{'4974'} = 'SNDELED';
$postkommune{'4980'} = '0911'; $kategori{'4980'} = 'G'; $poststed{'4980'} = 'GJERSTAD';
$postkommune{'4985'} = '0912'; $kategori{'4985'} = 'G'; $poststed{'4985'} = 'VEGRSHEI';
$postkommune{'4990'} = '0901'; $kategori{'4990'} = 'G'; $poststed{'4990'} = 'SNDELED';
$postkommune{'4993'} = '0911'; $kategori{'4993'} = 'G'; $poststed{'4993'} = 'SUNDEBRU';
$postkommune{'4994'} = '0901'; $kategori{'4994'} = 'G'; $poststed{'4994'} = 'AKLAND';
$postkommune{'5003'} = '1201'; $kategori{'5003'} = 'B'; $poststed{'5003'} = 'BERGEN';
$postkommune{'5004'} = '1201'; $kategori{'5004'} = 'G'; $poststed{'5004'} = 'BERGEN';
$postkommune{'5005'} = '1201'; $kategori{'5005'} = 'G'; $poststed{'5005'} = 'BERGEN';
$postkommune{'5006'} = '1201'; $kategori{'5006'} = 'B'; $poststed{'5006'} = 'BERGEN';
$postkommune{'5007'} = '1201'; $kategori{'5007'} = 'G'; $poststed{'5007'} = 'BERGEN';
$postkommune{'5008'} = '1201'; $kategori{'5008'} = 'G'; $poststed{'5008'} = 'BERGEN';
$postkommune{'5009'} = '1201'; $kategori{'5009'} = 'G'; $poststed{'5009'} = 'BERGEN';
$postkommune{'5010'} = '1201'; $kategori{'5010'} = 'G'; $poststed{'5010'} = 'BERGEN';
$postkommune{'5011'} = '1201'; $kategori{'5011'} = 'G'; $poststed{'5011'} = 'BERGEN';
$postkommune{'5012'} = '1201'; $kategori{'5012'} = 'G'; $poststed{'5012'} = 'BERGEN';
$postkommune{'5013'} = '1201'; $kategori{'5013'} = 'G'; $poststed{'5013'} = 'BERGEN';
$postkommune{'5014'} = '1201'; $kategori{'5014'} = 'G'; $poststed{'5014'} = 'BERGEN';
$postkommune{'5015'} = '1201'; $kategori{'5015'} = 'G'; $poststed{'5015'} = 'BERGEN';
$postkommune{'5016'} = '1201'; $kategori{'5016'} = 'G'; $poststed{'5016'} = 'BERGEN';
$postkommune{'5017'} = '1201'; $kategori{'5017'} = 'G'; $poststed{'5017'} = 'BERGEN';
$postkommune{'5018'} = '1201'; $kategori{'5018'} = 'G'; $poststed{'5018'} = 'BERGEN';
$postkommune{'5019'} = '1201'; $kategori{'5019'} = 'G'; $poststed{'5019'} = 'BERGEN';
$postkommune{'5020'} = '1201'; $kategori{'5020'} = 'S'; $poststed{'5020'} = 'BERGEN';
$postkommune{'5021'} = '1201'; $kategori{'5021'} = 'K'; $poststed{'5021'} = 'BERGEN';
$postkommune{'5031'} = '1201'; $kategori{'5031'} = 'G'; $poststed{'5031'} = 'BERGEN';
$postkommune{'5032'} = '1201'; $kategori{'5032'} = 'G'; $poststed{'5032'} = 'BERGEN';
$postkommune{'5033'} = '1201'; $kategori{'5033'} = 'G'; $poststed{'5033'} = 'BERGEN';
$postkommune{'5034'} = '1201'; $kategori{'5034'} = 'G'; $poststed{'5034'} = 'BERGEN';
$postkommune{'5035'} = '1201'; $kategori{'5035'} = 'B'; $poststed{'5035'} = 'BERGEN';
$postkommune{'5036'} = '1201'; $kategori{'5036'} = 'G'; $poststed{'5036'} = 'BERGEN';
$postkommune{'5037'} = '1201'; $kategori{'5037'} = 'G'; $poststed{'5037'} = 'BERGEN';
$postkommune{'5038'} = '1201'; $kategori{'5038'} = 'G'; $poststed{'5038'} = 'BERGEN';
$postkommune{'5039'} = '1201'; $kategori{'5039'} = 'G'; $poststed{'5039'} = 'BERGEN';
$postkommune{'5041'} = '1201'; $kategori{'5041'} = 'F'; $poststed{'5041'} = 'BERGEN';
$postkommune{'5042'} = '1201'; $kategori{'5042'} = 'G'; $poststed{'5042'} = 'BERGEN';
$postkommune{'5043'} = '1201'; $kategori{'5043'} = 'G'; $poststed{'5043'} = 'BERGEN';
$postkommune{'5045'} = '1201'; $kategori{'5045'} = 'F'; $poststed{'5045'} = 'BERGEN';
$postkommune{'5052'} = '1201'; $kategori{'5052'} = 'G'; $poststed{'5052'} = 'BERGEN';
$postkommune{'5053'} = '1201'; $kategori{'5053'} = 'G'; $poststed{'5053'} = 'BERGEN';
$postkommune{'5054'} = '1201'; $kategori{'5054'} = 'G'; $poststed{'5054'} = 'BERGEN';
$postkommune{'5055'} = '1201'; $kategori{'5055'} = 'G'; $poststed{'5055'} = 'BERGEN';
$postkommune{'5056'} = '1201'; $kategori{'5056'} = 'G'; $poststed{'5056'} = 'BERGEN';
$postkommune{'5057'} = '1201'; $kategori{'5057'} = 'G'; $poststed{'5057'} = 'BERGEN';
$postkommune{'5058'} = '1201'; $kategori{'5058'} = 'G'; $poststed{'5058'} = 'BERGEN';
$postkommune{'5059'} = '1201'; $kategori{'5059'} = 'G'; $poststed{'5059'} = 'BERGEN';
$postkommune{'5063'} = '1201'; $kategori{'5063'} = 'G'; $poststed{'5063'} = 'BERGEN';
$postkommune{'5067'} = '1201'; $kategori{'5067'} = 'G'; $poststed{'5067'} = 'BERGEN';
$postkommune{'5068'} = '1201'; $kategori{'5068'} = 'G'; $poststed{'5068'} = 'BERGEN';
$postkommune{'5072'} = '1201'; $kategori{'5072'} = 'G'; $poststed{'5072'} = 'BERGEN';
$postkommune{'5073'} = '1201'; $kategori{'5073'} = 'G'; $poststed{'5073'} = 'BERGEN';
$postkommune{'5075'} = '1201'; $kategori{'5075'} = 'F'; $poststed{'5075'} = 'BERGEN';
$postkommune{'5081'} = '1201'; $kategori{'5081'} = 'G'; $poststed{'5081'} = 'BERGEN';
$postkommune{'5089'} = '1201'; $kategori{'5089'} = 'G'; $poststed{'5089'} = 'BERGEN';
$postkommune{'5093'} = '1201'; $kategori{'5093'} = 'G'; $poststed{'5093'} = 'BERGEN';
$postkommune{'5094'} = '1201'; $kategori{'5094'} = 'G'; $poststed{'5094'} = 'BERGEN';
$postkommune{'5096'} = '1201'; $kategori{'5096'} = 'G'; $poststed{'5096'} = 'BERGEN';
$postkommune{'5097'} = '1201'; $kategori{'5097'} = 'G'; $poststed{'5097'} = 'BERGEN';
$postkommune{'5098'} = '1201'; $kategori{'5098'} = 'G'; $poststed{'5098'} = 'BERGEN';
$postkommune{'5099'} = '1201'; $kategori{'5099'} = 'G'; $poststed{'5099'} = 'BERGEN';
$postkommune{'5101'} = '1201'; $kategori{'5101'} = 'G'; $poststed{'5101'} = 'EIDSVGNESET';
$postkommune{'5104'} = '1201'; $kategori{'5104'} = 'G'; $poststed{'5104'} = 'EIDSVG I SANE';
$postkommune{'5105'} = '1201'; $kategori{'5105'} = 'G'; $poststed{'5105'} = 'EIDSVG I SANE';
$postkommune{'5106'} = '1201'; $kategori{'5106'} = 'G'; $poststed{'5106'} = 'VRE ERVIK';
$postkommune{'5107'} = '1201'; $kategori{'5107'} = 'G'; $poststed{'5107'} = 'SALHUS';
$postkommune{'5108'} = '1201'; $kategori{'5108'} = 'G'; $poststed{'5108'} = 'HORDVIK';
$postkommune{'5109'} = '1201'; $kategori{'5109'} = 'G'; $poststed{'5109'} = 'HYLKJE';
$postkommune{'5111'} = '1201'; $kategori{'5111'} = 'G'; $poststed{'5111'} = 'BREISTEIN';
$postkommune{'5113'} = '1201'; $kategori{'5113'} = 'B'; $poststed{'5113'} = 'TERTNES';
$postkommune{'5114'} = '1201'; $kategori{'5114'} = 'G'; $poststed{'5114'} = 'TERTNES';
$postkommune{'5115'} = '1201'; $kategori{'5115'} = 'G'; $poststed{'5115'} = 'ULSET';
$postkommune{'5116'} = '1201'; $kategori{'5116'} = 'G'; $poststed{'5116'} = 'ULSET';
$postkommune{'5117'} = '1201'; $kategori{'5117'} = 'G'; $poststed{'5117'} = 'ULSET';
$postkommune{'5118'} = '1201'; $kategori{'5118'} = 'G'; $poststed{'5118'} = 'ULSET';
$postkommune{'5119'} = '1201'; $kategori{'5119'} = 'G'; $poststed{'5119'} = 'ULSET';
$postkommune{'5121'} = '1201'; $kategori{'5121'} = 'G'; $poststed{'5121'} = 'ULSET';
$postkommune{'5122'} = '1201'; $kategori{'5122'} = 'G'; $poststed{'5122'} = 'MORVIK';
$postkommune{'5124'} = '1201'; $kategori{'5124'} = 'B'; $poststed{'5124'} = 'MORVIK';
$postkommune{'5131'} = '1201'; $kategori{'5131'} = 'G'; $poststed{'5131'} = 'NYBORG';
$postkommune{'5132'} = '1201'; $kategori{'5132'} = 'G'; $poststed{'5132'} = 'NYBORG';
$postkommune{'5134'} = '1201'; $kategori{'5134'} = 'G'; $poststed{'5134'} = 'FLAKTVEIT';
$postkommune{'5135'} = '1201'; $kategori{'5135'} = 'G'; $poststed{'5135'} = 'FLAKTVEIT';
$postkommune{'5136'} = '1201'; $kategori{'5136'} = 'G'; $poststed{'5136'} = 'MJLKEREN';
$postkommune{'5137'} = '1201'; $kategori{'5137'} = 'G'; $poststed{'5137'} = 'MJLKEREN';
$postkommune{'5141'} = '1201'; $kategori{'5141'} = 'B'; $poststed{'5141'} = 'FYLLINGSDALEN';
$postkommune{'5142'} = '1201'; $kategori{'5142'} = 'G'; $poststed{'5142'} = 'FYLLINGSDALEN';
$postkommune{'5143'} = '1201'; $kategori{'5143'} = 'G'; $poststed{'5143'} = 'FYLLINGSDALEN';
$postkommune{'5144'} = '1201'; $kategori{'5144'} = 'G'; $poststed{'5144'} = 'FYLLINGSDALEN';
$postkommune{'5145'} = '1201'; $kategori{'5145'} = 'G'; $poststed{'5145'} = 'FYLLINGSDALEN';
$postkommune{'5146'} = '1201'; $kategori{'5146'} = 'G'; $poststed{'5146'} = 'FYLLINGSDALEN';
$postkommune{'5147'} = '1201'; $kategori{'5147'} = 'G'; $poststed{'5147'} = 'FYLLINGSDALEN';
$postkommune{'5148'} = '1201'; $kategori{'5148'} = 'G'; $poststed{'5148'} = 'FYLLINGSDALEN';
$postkommune{'5151'} = '1201'; $kategori{'5151'} = 'G'; $poststed{'5151'} = 'STRAUMSGREND';
$postkommune{'5152'} = '1201'; $kategori{'5152'} = 'G'; $poststed{'5152'} = 'BNES';
$postkommune{'5155'} = '1201'; $kategori{'5155'} = 'G'; $poststed{'5155'} = 'BNES';
$postkommune{'5161'} = '1201'; $kategori{'5161'} = 'G'; $poststed{'5161'} = 'LAKSEVG';
$postkommune{'5162'} = '1201'; $kategori{'5162'} = 'G'; $poststed{'5162'} = 'LAKSEVG';
$postkommune{'5163'} = '1201'; $kategori{'5163'} = 'G'; $poststed{'5163'} = 'LAKSEVG';
$postkommune{'5164'} = '1201'; $kategori{'5164'} = 'G'; $poststed{'5164'} = 'LAKSEVG';
$postkommune{'5171'} = '1201'; $kategori{'5171'} = 'B'; $poststed{'5171'} = 'LODDEFJORD';
$postkommune{'5172'} = '1201'; $kategori{'5172'} = 'G'; $poststed{'5172'} = 'LODDEFJORD';
$postkommune{'5173'} = '1201'; $kategori{'5173'} = 'G'; $poststed{'5173'} = 'LODDEFJORD';
$postkommune{'5174'} = '1201'; $kategori{'5174'} = 'B'; $poststed{'5174'} = 'MATHOPEN';
$postkommune{'5177'} = '1246'; $kategori{'5177'} = 'G'; $poststed{'5177'} = 'BJRYHAMN';
$postkommune{'5178'} = '1201'; $kategori{'5178'} = 'G'; $poststed{'5178'} = 'LODDEFJORD';
$postkommune{'5179'} = '1201'; $kategori{'5179'} = 'G'; $poststed{'5179'} = 'GODVIK';
$postkommune{'5183'} = '1201'; $kategori{'5183'} = 'G'; $poststed{'5183'} = 'OLSVIK';
$postkommune{'5184'} = '1201'; $kategori{'5184'} = 'G'; $poststed{'5184'} = 'OLSVIK';
$postkommune{'5200'} = '1243'; $kategori{'5200'} = 'G'; $poststed{'5200'} = 'OS';
$postkommune{'5201'} = '1243'; $kategori{'5201'} = 'P'; $poststed{'5201'} = 'OS';
$postkommune{'5202'} = '1243'; $kategori{'5202'} = 'P'; $poststed{'5202'} = 'OS';
$postkommune{'5203'} = '1243'; $kategori{'5203'} = 'P'; $poststed{'5203'} = 'OS';
$postkommune{'5206'} = '1243'; $kategori{'5206'} = 'P'; $poststed{'5206'} = 'OS';
$postkommune{'5207'} = '1243'; $kategori{'5207'} = 'P'; $poststed{'5207'} = 'SFTELAND';
$postkommune{'5212'} = '1243'; $kategori{'5212'} = 'G'; $poststed{'5212'} = 'SFTELAND';
$postkommune{'5215'} = '1243'; $kategori{'5215'} = 'B'; $poststed{'5215'} = 'LYSEKLOSTER';
$postkommune{'5216'} = '1243'; $kategori{'5216'} = 'B'; $poststed{'5216'} = 'LEPSY';
$postkommune{'5217'} = '1243'; $kategori{'5217'} = 'G'; $poststed{'5217'} = 'HAGAVIK';
$postkommune{'5218'} = '1243'; $kategori{'5218'} = 'G'; $poststed{'5218'} = 'NORDSTRNO';
$postkommune{'5219'} = '1243'; $kategori{'5219'} = 'G'; $poststed{'5219'} = 'SKORPO FERIEHEIM';
$postkommune{'5221'} = '1201'; $kategori{'5221'} = 'G'; $poststed{'5221'} = 'NESTTUN';
$postkommune{'5222'} = '1201'; $kategori{'5222'} = 'G'; $poststed{'5222'} = 'NESTTUN';
$postkommune{'5223'} = '1201'; $kategori{'5223'} = 'G'; $poststed{'5223'} = 'NESTTUN';
$postkommune{'5224'} = '1201'; $kategori{'5224'} = 'G'; $poststed{'5224'} = 'NESTTUN';
$postkommune{'5225'} = '1201'; $kategori{'5225'} = 'G'; $poststed{'5225'} = 'NESTTUN';
$postkommune{'5226'} = '1201'; $kategori{'5226'} = 'G'; $poststed{'5226'} = 'NESTTUN';
$postkommune{'5227'} = '1201'; $kategori{'5227'} = 'G'; $poststed{'5227'} = 'NESTTUN';
$postkommune{'5229'} = '1201'; $kategori{'5229'} = 'G'; $poststed{'5229'} = 'KALANDSEIDET';
$postkommune{'5231'} = '1201'; $kategori{'5231'} = 'G'; $poststed{'5231'} = 'PARADIS';
$postkommune{'5232'} = '1201'; $kategori{'5232'} = 'G'; $poststed{'5232'} = 'PARADIS';
$postkommune{'5235'} = '1201'; $kategori{'5235'} = 'G'; $poststed{'5235'} = 'RDAL';
$postkommune{'5236'} = '1201'; $kategori{'5236'} = 'B'; $poststed{'5236'} = 'RDAL';
$postkommune{'5238'} = '1201'; $kategori{'5238'} = 'G'; $poststed{'5238'} = 'RDAL';
$postkommune{'5239'} = '1201'; $kategori{'5239'} = 'G'; $poststed{'5239'} = 'RDAL';
$postkommune{'5243'} = '1201'; $kategori{'5243'} = 'G'; $poststed{'5243'} = 'FANA';
$postkommune{'5244'} = '1201'; $kategori{'5244'} = 'G'; $poststed{'5244'} = 'FANA';
$postkommune{'5251'} = '1201'; $kategori{'5251'} = 'B'; $poststed{'5251'} = 'SREIDGREND';
$postkommune{'5252'} = '1201'; $kategori{'5252'} = 'G'; $poststed{'5252'} = 'SREIDGREND';
$postkommune{'5253'} = '1201'; $kategori{'5253'} = 'G'; $poststed{'5253'} = 'SANDSLI';
$postkommune{'5254'} = '1201'; $kategori{'5254'} = 'G'; $poststed{'5254'} = 'SANDSLI';
$postkommune{'5257'} = '1201'; $kategori{'5257'} = 'G'; $poststed{'5257'} = 'KOKSTAD';
$postkommune{'5258'} = '1201'; $kategori{'5258'} = 'G'; $poststed{'5258'} = 'BLOMSTERDALEN';
$postkommune{'5259'} = '1201'; $kategori{'5259'} = 'B'; $poststed{'5259'} = 'HJELLESTAD';
$postkommune{'5260'} = '1201'; $kategori{'5260'} = 'G'; $poststed{'5260'} = 'INDRE ARNA';
$postkommune{'5261'} = '1201'; $kategori{'5261'} = 'G'; $poststed{'5261'} = 'INDRE ARNA';
$postkommune{'5262'} = '1201'; $kategori{'5262'} = 'G'; $poststed{'5262'} = 'ARNATVEIT';
$postkommune{'5263'} = '1201'; $kategori{'5263'} = 'G'; $poststed{'5263'} = 'TRENGEREID';
$postkommune{'5264'} = '1201'; $kategori{'5264'} = 'G'; $poststed{'5264'} = 'GARNES';
$postkommune{'5265'} = '1201'; $kategori{'5265'} = 'G'; $poststed{'5265'} = 'YTRE ARNA';
$postkommune{'5267'} = '1201'; $kategori{'5267'} = 'G'; $poststed{'5267'} = 'ESPELAND';
$postkommune{'5268'} = '1201'; $kategori{'5268'} = 'B'; $poststed{'5268'} = 'HAUKELAND';
$postkommune{'5281'} = '1253'; $kategori{'5281'} = 'G'; $poststed{'5281'} = 'VALESTRANDSFOSSEN';
$postkommune{'5282'} = '1253'; $kategori{'5282'} = 'G'; $poststed{'5282'} = 'LONEVG';
$postkommune{'5283'} = '1253'; $kategori{'5283'} = 'G'; $poststed{'5283'} = 'FOTLANDSVG';
$postkommune{'5284'} = '1253'; $kategori{'5284'} = 'G'; $poststed{'5284'} = 'TYSSEBOTNEN';
$postkommune{'5285'} = '1253'; $kategori{'5285'} = 'G'; $poststed{'5285'} = 'BRUVIK';
$postkommune{'5286'} = '1253'; $kategori{'5286'} = 'G'; $poststed{'5286'} = 'HAUS';
$postkommune{'5291'} = '1253'; $kategori{'5291'} = 'P'; $poststed{'5291'} = 'VALESTRANDSFOSSEN';
$postkommune{'5293'} = '1253'; $kategori{'5293'} = 'P'; $poststed{'5293'} = 'LONEVG';
$postkommune{'5299'} = '1253'; $kategori{'5299'} = 'P'; $poststed{'5299'} = 'HAUS';
$postkommune{'5300'} = '1247'; $kategori{'5300'} = 'G'; $poststed{'5300'} = 'KLEPPEST';
$postkommune{'5302'} = '1247'; $kategori{'5302'} = 'G'; $poststed{'5302'} = 'STRUSSHAMN';
$postkommune{'5303'} = '1247'; $kategori{'5303'} = 'G'; $poststed{'5303'} = 'FOLLESE';
$postkommune{'5304'} = '1247'; $kategori{'5304'} = 'G'; $poststed{'5304'} = 'HETLEVIK';
$postkommune{'5305'} = '1247'; $kategori{'5305'} = 'G'; $poststed{'5305'} = 'FLORVG';
$postkommune{'5306'} = '1247'; $kategori{'5306'} = 'G'; $poststed{'5306'} = 'ERDAL';
$postkommune{'5307'} = '1247'; $kategori{'5307'} = 'G'; $poststed{'5307'} = 'ASK';
$postkommune{'5310'} = '1247'; $kategori{'5310'} = 'G'; $poststed{'5310'} = 'HAUGLANDSHELLA';
$postkommune{'5314'} = '1247'; $kategori{'5314'} = 'B'; $poststed{'5314'} = 'KJERRGARDEN';
$postkommune{'5315'} = '1247'; $kategori{'5315'} = 'G'; $poststed{'5315'} = 'HERDLA';
$postkommune{'5318'} = '1247'; $kategori{'5318'} = 'P'; $poststed{'5318'} = 'STRUSSHAMN';
$postkommune{'5319'} = '1247'; $kategori{'5319'} = 'P'; $poststed{'5319'} = 'KLEPPEST';
$postkommune{'5321'} = '1247'; $kategori{'5321'} = 'P'; $poststed{'5321'} = 'KLEPPEST';
$postkommune{'5322'} = '1247'; $kategori{'5322'} = 'P'; $poststed{'5322'} = 'KLEPPEST';
$postkommune{'5323'} = '1247'; $kategori{'5323'} = 'P'; $poststed{'5323'} = 'KLEPPEST';
$postkommune{'5325'} = '1247'; $kategori{'5325'} = 'P'; $poststed{'5325'} = 'FOLLESE';
$postkommune{'5326'} = '1247'; $kategori{'5326'} = 'P'; $poststed{'5326'} = 'ASK';
$postkommune{'5327'} = '1247'; $kategori{'5327'} = 'P'; $poststed{'5327'} = 'HAUGLANDSHELLA';
$postkommune{'5329'} = '1247'; $kategori{'5329'} = 'P'; $poststed{'5329'} = 'FLORVG';
$postkommune{'5331'} = '1259'; $kategori{'5331'} = 'P'; $poststed{'5331'} = 'RONG';
$postkommune{'5333'} = '1259'; $kategori{'5333'} = 'P'; $poststed{'5333'} = 'TJELDST';
$postkommune{'5334'} = '1259'; $kategori{'5334'} = 'G'; $poststed{'5334'} = 'HELLESY';
$postkommune{'5335'} = '1259'; $kategori{'5335'} = 'B'; $poststed{'5335'} = 'HERNAR';
$postkommune{'5336'} = '1259'; $kategori{'5336'} = 'G'; $poststed{'5336'} = 'TJELDST';
$postkommune{'5337'} = '1259'; $kategori{'5337'} = 'G'; $poststed{'5337'} = 'RONG';
$postkommune{'5341'} = '1246'; $kategori{'5341'} = 'P'; $poststed{'5341'} = 'STRAUME';
$postkommune{'5342'} = '1246'; $kategori{'5342'} = 'P'; $poststed{'5342'} = 'STRAUME';
$postkommune{'5343'} = '1246'; $kategori{'5343'} = 'P'; $poststed{'5343'} = 'STRAUME';
$postkommune{'5345'} = '1246'; $kategori{'5345'} = 'P'; $poststed{'5345'} = 'KNARREVIK';
$postkommune{'5346'} = '1246'; $kategori{'5346'} = 'P'; $poststed{'5346'} = 'GOTNES';
$postkommune{'5347'} = '1246'; $kategori{'5347'} = 'B'; $poststed{'5347'} = 'KYSTBASEN GOTNES';
$postkommune{'5350'} = '1246'; $kategori{'5350'} = 'G'; $poststed{'5350'} = 'BRATTHOLMEN';
$postkommune{'5353'} = '1246'; $kategori{'5353'} = 'G'; $poststed{'5353'} = 'STRAUME';
$postkommune{'5355'} = '1246'; $kategori{'5355'} = 'G'; $poststed{'5355'} = 'KNARREVIK';
$postkommune{'5357'} = '1246'; $kategori{'5357'} = 'G'; $poststed{'5357'} = 'FJELL';
$postkommune{'5358'} = '1246'; $kategori{'5358'} = 'P'; $poststed{'5358'} = 'FJELL';
$postkommune{'5363'} = '1246'; $kategori{'5363'} = 'G'; $poststed{'5363'} = 'GOTNES';
$postkommune{'5365'} = '1246'; $kategori{'5365'} = 'G'; $poststed{'5365'} = 'TURY';
$postkommune{'5366'} = '1246'; $kategori{'5366'} = 'G'; $poststed{'5366'} = 'MISJE';
$postkommune{'5371'} = '1245'; $kategori{'5371'} = 'P'; $poststed{'5371'} = 'SKOGSVG';
$postkommune{'5373'} = '1245'; $kategori{'5373'} = 'P'; $poststed{'5373'} = 'KLOKKARVIK';
$postkommune{'5374'} = '1245'; $kategori{'5374'} = 'P'; $poststed{'5374'} = 'STEINSLAND';
$postkommune{'5378'} = '1245'; $kategori{'5378'} = 'G'; $poststed{'5378'} = 'KLOKKARVIK';
$postkommune{'5379'} = '1245'; $kategori{'5379'} = 'G'; $poststed{'5379'} = 'STEINSLAND';
$postkommune{'5380'} = '1245'; $kategori{'5380'} = 'G'; $poststed{'5380'} = 'TLAVG';
$postkommune{'5381'} = '1245'; $kategori{'5381'} = 'G'; $poststed{'5381'} = 'GLESVR';
$postkommune{'5382'} = '1245'; $kategori{'5382'} = 'G'; $poststed{'5382'} = 'SKOGSVG';
$postkommune{'5384'} = '1244'; $kategori{'5384'} = 'G'; $poststed{'5384'} = 'TORANGSVG';
$postkommune{'5385'} = '1244'; $kategori{'5385'} = 'G'; $poststed{'5385'} = 'BAKKASUND';
$postkommune{'5387'} = '1244'; $kategori{'5387'} = 'B'; $poststed{'5387'} = 'MKSTER';
$postkommune{'5388'} = '1244'; $kategori{'5388'} = 'G'; $poststed{'5388'} = 'LITLAKALSY';
$postkommune{'5392'} = '1244'; $kategori{'5392'} = 'G'; $poststed{'5392'} = 'STOREB';
$postkommune{'5393'} = '1244'; $kategori{'5393'} = 'P'; $poststed{'5393'} = 'STOREB';
$postkommune{'5394'} = '1244'; $kategori{'5394'} = 'G'; $poststed{'5394'} = 'KOLBEINSVIK';
$postkommune{'5396'} = '1244'; $kategori{'5396'} = 'G'; $poststed{'5396'} = 'VESTRE VINNESVG';
$postkommune{'5397'} = '1244'; $kategori{'5397'} = 'G'; $poststed{'5397'} = 'BEKKJARVIK';
$postkommune{'5398'} = '1244'; $kategori{'5398'} = 'G'; $poststed{'5398'} = 'STOLMEN';
$postkommune{'5399'} = '1244'; $kategori{'5399'} = 'P'; $poststed{'5399'} = 'BEKKJARVIK';
$postkommune{'5401'} = '1221'; $kategori{'5401'} = 'P'; $poststed{'5401'} = 'STORD';
$postkommune{'5402'} = '1221'; $kategori{'5402'} = 'P'; $poststed{'5402'} = 'STORD';
$postkommune{'5403'} = '1221'; $kategori{'5403'} = 'P'; $poststed{'5403'} = 'STORD';
$postkommune{'5404'} = '1221'; $kategori{'5404'} = 'P'; $poststed{'5404'} = 'STORD';
$postkommune{'5405'} = '1221'; $kategori{'5405'} = 'P'; $poststed{'5405'} = 'STORD';
$postkommune{'5406'} = '1221'; $kategori{'5406'} = 'P'; $poststed{'5406'} = 'STORD';
$postkommune{'5407'} = '1221'; $kategori{'5407'} = 'P'; $poststed{'5407'} = 'STORD';
$postkommune{'5408'} = '1221'; $kategori{'5408'} = 'P'; $poststed{'5408'} = 'SAGVG';
$postkommune{'5409'} = '1221'; $kategori{'5409'} = 'S'; $poststed{'5409'} = 'STORD';
$postkommune{'5410'} = '1221'; $kategori{'5410'} = 'G'; $poststed{'5410'} = 'SAGVG';
$postkommune{'5411'} = '1221'; $kategori{'5411'} = 'G'; $poststed{'5411'} = 'STORD';
$postkommune{'5412'} = '1221'; $kategori{'5412'} = 'G'; $poststed{'5412'} = 'STORD';
$postkommune{'5414'} = '1221'; $kategori{'5414'} = 'G'; $poststed{'5414'} = 'STORD';
$postkommune{'5415'} = '1221'; $kategori{'5415'} = 'G'; $poststed{'5415'} = 'STORD';
$postkommune{'5416'} = '1221'; $kategori{'5416'} = 'G'; $poststed{'5416'} = 'STORD';
$postkommune{'5417'} = '1221'; $kategori{'5417'} = 'G'; $poststed{'5417'} = 'STORD';
$postkommune{'5418'} = '1222'; $kategori{'5418'} = 'P'; $poststed{'5418'} = 'FITJAR';
$postkommune{'5419'} = '1222'; $kategori{'5419'} = 'G'; $poststed{'5419'} = 'FITJAR';
$postkommune{'5420'} = '1219'; $kategori{'5420'} = 'G'; $poststed{'5420'} = 'RUBBESTADNESET';
$postkommune{'5423'} = '1219'; $kategori{'5423'} = 'G'; $poststed{'5423'} = 'BRANDASUND';
$postkommune{'5427'} = '1219'; $kategori{'5427'} = 'G'; $poststed{'5427'} = 'URANGSVG';
$postkommune{'5428'} = '1219'; $kategori{'5428'} = 'G'; $poststed{'5428'} = 'FOLDRYHAMN';
$postkommune{'5430'} = '1219'; $kategori{'5430'} = 'G'; $poststed{'5430'} = 'BREMNES';
$postkommune{'5437'} = '1219'; $kategori{'5437'} = 'G'; $poststed{'5437'} = 'FINNS';
$postkommune{'5440'} = '1219'; $kategori{'5440'} = 'G'; $poststed{'5440'} = 'MOSTERHAMN';
$postkommune{'5443'} = '1219'; $kategori{'5443'} = 'G'; $poststed{'5443'} = 'BMLO';
$postkommune{'5444'} = '1219'; $kategori{'5444'} = 'B'; $poststed{'5444'} = 'ESPEVR';
$postkommune{'5445'} = '1219'; $kategori{'5445'} = 'P'; $poststed{'5445'} = 'BREMNES';
$postkommune{'5447'} = '1219'; $kategori{'5447'} = 'P'; $poststed{'5447'} = 'MOSTERHAMN';
$postkommune{'5449'} = '1219'; $kategori{'5449'} = 'P'; $poststed{'5449'} = 'BMLO';
$postkommune{'5450'} = '1224'; $kategori{'5450'} = 'G'; $poststed{'5450'} = 'SUNDE I SUNNHORDLAND';
$postkommune{'5451'} = '1224'; $kategori{'5451'} = 'B'; $poststed{'5451'} = 'VALEN';
$postkommune{'5452'} = '1224'; $kategori{'5452'} = 'G'; $poststed{'5452'} = 'SANDVOLL';
$postkommune{'5453'} = '1224'; $kategori{'5453'} = 'G'; $poststed{'5453'} = 'UTKER';
$postkommune{'5454'} = '1224'; $kategori{'5454'} = 'G'; $poststed{'5454'} = 'SBVIK';
$postkommune{'5455'} = '1224'; $kategori{'5455'} = 'G'; $poststed{'5455'} = 'HALSNY KLOSTER';
$postkommune{'5457'} = '1224'; $kategori{'5457'} = 'G'; $poststed{'5457'} = 'HYLANDSBYGD';
$postkommune{'5458'} = '1224'; $kategori{'5458'} = 'G'; $poststed{'5458'} = 'ARNAVIK';
$postkommune{'5459'} = '1224'; $kategori{'5459'} = 'G'; $poststed{'5459'} = 'FJELBERG';
$postkommune{'5460'} = '1224'; $kategori{'5460'} = 'G'; $poststed{'5460'} = 'HUSNES';
$postkommune{'5462'} = '1224'; $kategori{'5462'} = 'B'; $poststed{'5462'} = 'HERYSUNDET';
$postkommune{'5463'} = '1224'; $kategori{'5463'} = 'G'; $poststed{'5463'} = 'USKEDALEN';
$postkommune{'5464'} = '1224'; $kategori{'5464'} = 'G'; $poststed{'5464'} = 'DIMMELSVIK';
$postkommune{'5465'} = '1224'; $kategori{'5465'} = 'P'; $poststed{'5465'} = 'USKEDALEN';
$postkommune{'5470'} = '1224'; $kategori{'5470'} = 'G'; $poststed{'5470'} = 'ROSENDAL';
$postkommune{'5472'} = '1224'; $kategori{'5472'} = 'G'; $poststed{'5472'} = 'SEIMSFOSS';
$postkommune{'5473'} = '1224'; $kategori{'5473'} = 'G'; $poststed{'5473'} = 'SNILSTVEITY';
$postkommune{'5474'} = '1224'; $kategori{'5474'} = 'G'; $poststed{'5474'} = 'LFALLSTRAND';
$postkommune{'5475'} = '1224'; $kategori{'5475'} = 'G'; $poststed{'5475'} = 'NES';
$postkommune{'5476'} = '1224'; $kategori{'5476'} = 'G'; $poststed{'5476'} = 'MAURANGER';
$postkommune{'5480'} = '1224'; $kategori{'5480'} = 'P'; $poststed{'5480'} = 'HUSNES';
$postkommune{'5484'} = '1224'; $kategori{'5484'} = 'P'; $poststed{'5484'} = 'SBVIK';
$postkommune{'5486'} = '1224'; $kategori{'5486'} = 'P'; $poststed{'5486'} = 'ROSENDAL';
$postkommune{'5497'} = '1221'; $kategori{'5497'} = 'G'; $poststed{'5497'} = 'HUGLO';
$postkommune{'5498'} = '1224'; $kategori{'5498'} = 'G'; $poststed{'5498'} = 'MATRE';
$postkommune{'5499'} = '1224'; $kategori{'5499'} = 'G'; $poststed{'5499'} = 'KRA';
$postkommune{'5501'} = '1106'; $kategori{'5501'} = 'P'; $poststed{'5501'} = 'HAUGESUND';
$postkommune{'5502'} = '1106'; $kategori{'5502'} = 'P'; $poststed{'5502'} = 'HAUGESUND';
$postkommune{'5503'} = '1106'; $kategori{'5503'} = 'P'; $poststed{'5503'} = 'HAUGESUND';
$postkommune{'5504'} = '1106'; $kategori{'5504'} = 'P'; $poststed{'5504'} = 'HAUGESUND';
$postkommune{'5505'} = '1106'; $kategori{'5505'} = 'P'; $poststed{'5505'} = 'HAUGESUND';
$postkommune{'5506'} = '1106'; $kategori{'5506'} = 'P'; $poststed{'5506'} = 'HAUGESUND';
$postkommune{'5507'} = '1106'; $kategori{'5507'} = 'P'; $poststed{'5507'} = 'HAUGESUND';
$postkommune{'5508'} = '1149'; $kategori{'5508'} = 'P'; $poststed{'5508'} = 'KARMSUND';
$postkommune{'5509'} = '1106'; $kategori{'5509'} = 'P'; $poststed{'5509'} = 'HAUGESUND';
$postkommune{'5511'} = '1106'; $kategori{'5511'} = 'P'; $poststed{'5511'} = 'HAUGESUND';
$postkommune{'5514'} = '1106'; $kategori{'5514'} = 'G'; $poststed{'5514'} = 'HAUGESUND';
$postkommune{'5515'} = '1106'; $kategori{'5515'} = 'G'; $poststed{'5515'} = 'HAUGESUND';
$postkommune{'5516'} = '1106'; $kategori{'5516'} = 'G'; $poststed{'5516'} = 'HAUGESUND';
$postkommune{'5517'} = '1106'; $kategori{'5517'} = 'G'; $poststed{'5517'} = 'HAUGESUND';
$postkommune{'5518'} = '1106'; $kategori{'5518'} = 'B'; $poststed{'5518'} = 'HAUGESUND';
$postkommune{'5519'} = '1106'; $kategori{'5519'} = 'G'; $poststed{'5519'} = 'HAUGESUND';
$postkommune{'5521'} = '1106'; $kategori{'5521'} = 'G'; $poststed{'5521'} = 'HAUGESUND';
$postkommune{'5522'} = '1106'; $kategori{'5522'} = 'G'; $poststed{'5522'} = 'HAUGESUND';
$postkommune{'5523'} = '1106'; $kategori{'5523'} = 'G'; $poststed{'5523'} = 'HAUGESUND';
$postkommune{'5525'} = '1106'; $kategori{'5525'} = 'G'; $poststed{'5525'} = 'HAUGESUND';
$postkommune{'5527'} = '1106'; $kategori{'5527'} = 'G'; $poststed{'5527'} = 'HAUGESUND';
$postkommune{'5528'} = '1106'; $kategori{'5528'} = 'G'; $poststed{'5528'} = 'HAUGESUND';
$postkommune{'5529'} = '1106'; $kategori{'5529'} = 'G'; $poststed{'5529'} = 'HAUGESUND';
$postkommune{'5531'} = '1106'; $kategori{'5531'} = 'G'; $poststed{'5531'} = 'HAUGESUND';
$postkommune{'5532'} = '1106'; $kategori{'5532'} = 'G'; $poststed{'5532'} = 'HAUGESUND';
$postkommune{'5533'} = '1106'; $kategori{'5533'} = 'G'; $poststed{'5533'} = 'HAUGESUND';
$postkommune{'5534'} = '1106'; $kategori{'5534'} = 'G'; $poststed{'5534'} = 'HAUGESUND';
$postkommune{'5535'} = '1106'; $kategori{'5535'} = 'G'; $poststed{'5535'} = 'HAUGESUND';
$postkommune{'5536'} = '1106'; $kategori{'5536'} = 'G'; $poststed{'5536'} = 'HAUGESUND';
$postkommune{'5537'} = '1106'; $kategori{'5537'} = 'G'; $poststed{'5537'} = 'HAUGESUND';
$postkommune{'5538'} = '1106'; $kategori{'5538'} = 'G'; $poststed{'5538'} = 'HAUGESUND';
$postkommune{'5541'} = '1149'; $kategori{'5541'} = 'G'; $poststed{'5541'} = 'KOLNES';
$postkommune{'5542'} = '1149'; $kategori{'5542'} = 'G'; $poststed{'5542'} = 'KARMSUND';
$postkommune{'5544'} = '1149'; $kategori{'5544'} = 'P'; $poststed{'5544'} = 'VORMEDAL';
$postkommune{'5545'} = '1149'; $kategori{'5545'} = 'G'; $poststed{'5545'} = 'VORMEDAL';
$postkommune{'5546'} = '1149'; $kategori{'5546'} = 'G'; $poststed{'5546'} = 'RYKSUND';
$postkommune{'5547'} = '1151'; $kategori{'5547'} = 'B'; $poststed{'5547'} = 'UTSIRA';
$postkommune{'5548'} = '1149'; $kategori{'5548'} = 'B'; $poststed{'5548'} = 'FEY';
$postkommune{'5549'} = '1106'; $kategori{'5549'} = 'B'; $poststed{'5549'} = 'RVR';
$postkommune{'5550'} = '1216'; $kategori{'5550'} = 'G'; $poststed{'5550'} = 'SVEIO';
$postkommune{'5551'} = '1216'; $kategori{'5551'} = 'G'; $poststed{'5551'} = 'AUKLANDSHAMN';
$postkommune{'5554'} = '1216'; $kategori{'5554'} = 'B'; $poststed{'5554'} = 'VALEVG';
$postkommune{'5555'} = '1216'; $kategori{'5555'} = 'B'; $poststed{'5555'} = 'FRDE I HORDALAND';
$postkommune{'5559'} = '1216'; $kategori{'5559'} = 'P'; $poststed{'5559'} = 'SVEIO';
$postkommune{'5560'} = '1146'; $kategori{'5560'} = 'B'; $poststed{'5560'} = 'NEDSTRAND';
$postkommune{'5561'} = '1145'; $kategori{'5561'} = 'B'; $poststed{'5561'} = 'BOKN';
$postkommune{'5563'} = '1146'; $kategori{'5563'} = 'G'; $poststed{'5563'} = 'FRRESFJORDEN';
$postkommune{'5565'} = '1146'; $kategori{'5565'} = 'G'; $poststed{'5565'} = 'TYSVRVG';
$postkommune{'5566'} = '1146'; $kategori{'5566'} = 'G'; $poststed{'5566'} = 'HERVIK';
$postkommune{'5567'} = '1146'; $kategori{'5567'} = 'B'; $poststed{'5567'} = 'SKJOLDASTRAUMEN';
$postkommune{'5568'} = '1160'; $kategori{'5568'} = 'G'; $poststed{'5568'} = 'VIKEBYGD';
$postkommune{'5570'} = '1146'; $kategori{'5570'} = 'G'; $poststed{'5570'} = 'AKSDAL';
$postkommune{'5574'} = '1160'; $kategori{'5574'} = 'B'; $poststed{'5574'} = 'SKJOLD';
$postkommune{'5575'} = '1146'; $kategori{'5575'} = 'P'; $poststed{'5575'} = 'AKSDAL';
$postkommune{'5576'} = '1160'; $kategori{'5576'} = 'B'; $poststed{'5576'} = 'VRE VATS';
$postkommune{'5578'} = '1160'; $kategori{'5578'} = 'B'; $poststed{'5578'} = 'NEDRE VATS';
$postkommune{'5580'} = '1160'; $kategori{'5580'} = 'G'; $poststed{'5580'} = 'LEN';
$postkommune{'5582'} = '1160'; $kategori{'5582'} = 'B'; $poststed{'5582'} = 'LENSVG';
$postkommune{'5583'} = '1160'; $kategori{'5583'} = 'G'; $poststed{'5583'} = 'VIKEDAL';
$postkommune{'5584'} = '1160'; $kategori{'5584'} = 'B'; $poststed{'5584'} = 'BJOA';
$postkommune{'5585'} = '1160'; $kategori{'5585'} = 'G'; $poststed{'5585'} = 'SANDEID';
$postkommune{'5586'} = '1160'; $kategori{'5586'} = 'P'; $poststed{'5586'} = 'VIKEDAL';
$postkommune{'5588'} = '1160'; $kategori{'5588'} = 'P'; $poststed{'5588'} = 'LEN';
$postkommune{'5589'} = '1160'; $kategori{'5589'} = 'P'; $poststed{'5589'} = 'SANDEID';
$postkommune{'5590'} = '1211'; $kategori{'5590'} = 'G'; $poststed{'5590'} = 'ETNE';
$postkommune{'5591'} = '1211'; $kategori{'5591'} = 'P'; $poststed{'5591'} = 'ETNE';
$postkommune{'5593'} = '1211'; $kategori{'5593'} = 'G'; $poststed{'5593'} = 'SKNEVIK';
$postkommune{'5594'} = '1211'; $kategori{'5594'} = 'P'; $poststed{'5594'} = 'SKNEVIK';
$postkommune{'5595'} = '1146'; $kategori{'5595'} = 'P'; $poststed{'5595'} = 'FRRESFJORDEN';
$postkommune{'5596'} = '1211'; $kategori{'5596'} = 'G'; $poststed{'5596'} = 'MARKHUS';
$postkommune{'5598'} = '1211'; $kategori{'5598'} = 'G'; $poststed{'5598'} = 'FJRA';
$postkommune{'5600'} = '1238'; $kategori{'5600'} = 'G'; $poststed{'5600'} = 'NORHEIMSUND';
$postkommune{'5601'} = '1238'; $kategori{'5601'} = 'P'; $poststed{'5601'} = 'NORHEIMSUND';
$postkommune{'5602'} = '1238'; $kategori{'5602'} = 'P'; $poststed{'5602'} = 'NORHEIMSUND';
$postkommune{'5604'} = '1238'; $kategori{'5604'} = 'P'; $poststed{'5604'} = 'YSTESE';
$postkommune{'5605'} = '1238'; $kategori{'5605'} = 'P'; $poststed{'5605'} = 'LVIK';
$postkommune{'5610'} = '1238'; $kategori{'5610'} = 'G'; $poststed{'5610'} = 'YSTESE';
$postkommune{'5612'} = '1238'; $kategori{'5612'} = 'G'; $poststed{'5612'} = 'STEINST';
$postkommune{'5614'} = '1238'; $kategori{'5614'} = 'G'; $poststed{'5614'} = 'LVIK';
$postkommune{'5620'} = '1238'; $kategori{'5620'} = 'G'; $poststed{'5620'} = 'TRVIKBYGD';
$postkommune{'5626'} = '1227'; $kategori{'5626'} = 'G'; $poststed{'5626'} = 'KYSNESSTRAND';
$postkommune{'5627'} = '1227'; $kategori{'5627'} = 'G'; $poststed{'5627'} = 'JONDAL';
$postkommune{'5628'} = '1227'; $kategori{'5628'} = 'G'; $poststed{'5628'} = 'HERAND';
$postkommune{'5629'} = '1227'; $kategori{'5629'} = 'P'; $poststed{'5629'} = 'JONDAL';
$postkommune{'5630'} = '1238'; $kategori{'5630'} = 'B'; $poststed{'5630'} = 'STRANDEBARM';
$postkommune{'5632'} = '1238'; $kategori{'5632'} = 'B'; $poststed{'5632'} = 'OMASTRAND';
$postkommune{'5635'} = '1224'; $kategori{'5635'} = 'B'; $poststed{'5635'} = 'HATLESTRAND';
$postkommune{'5636'} = '1224'; $kategori{'5636'} = 'G'; $poststed{'5636'} = 'VARALDSY';
$postkommune{'5637'} = '1224'; $kategori{'5637'} = 'G'; $poststed{'5637'} = 'LVE';
$postkommune{'5640'} = '1241'; $kategori{'5640'} = 'G'; $poststed{'5640'} = 'EIKELANDSOSEN';
$postkommune{'5641'} = '1241'; $kategori{'5641'} = 'B'; $poststed{'5641'} = 'FUSA';
$postkommune{'5642'} = '1241'; $kategori{'5642'} = 'G'; $poststed{'5642'} = 'HOLMEFJORD';
$postkommune{'5643'} = '1241'; $kategori{'5643'} = 'G'; $poststed{'5643'} = 'STRANDVIK';
$postkommune{'5645'} = '1241'; $kategori{'5645'} = 'B'; $poststed{'5645'} = 'SVAREID';
$postkommune{'5646'} = '1241'; $kategori{'5646'} = 'G'; $poststed{'5646'} = 'NORDTVEITGREND';
$postkommune{'5647'} = '1241'; $kategori{'5647'} = 'G'; $poststed{'5647'} = 'BALDERSHEIM';
$postkommune{'5649'} = '1241'; $kategori{'5649'} = 'P'; $poststed{'5649'} = 'EIKELANDSOSEN';
$postkommune{'5650'} = '1242'; $kategori{'5650'} = 'B'; $poststed{'5650'} = 'TYSSE';
$postkommune{'5652'} = '1242'; $kategori{'5652'} = 'G'; $poststed{'5652'} = 'RLAND';
$postkommune{'5653'} = '1242'; $kategori{'5653'} = 'P'; $poststed{'5653'} = 'RLAND';
$postkommune{'5680'} = '1223'; $kategori{'5680'} = 'G'; $poststed{'5680'} = 'TYSNES';
$postkommune{'5682'} = '1223'; $kategori{'5682'} = 'G'; $poststed{'5682'} = 'GODYSUND';
$postkommune{'5683'} = '1223'; $kategori{'5683'} = 'G'; $poststed{'5683'} = 'REKSTEREN';
$postkommune{'5685'} = '1223'; $kategori{'5685'} = 'G'; $poststed{'5685'} = 'UGGDAL';
$postkommune{'5687'} = '1223'; $kategori{'5687'} = 'G'; $poststed{'5687'} = 'FLATRKER';
$postkommune{'5690'} = '1223'; $kategori{'5690'} = 'G'; $poststed{'5690'} = 'LUNDEGREND';
$postkommune{'5693'} = '1223'; $kategori{'5693'} = 'G'; $poststed{'5693'} = 'RBAKKA';
$postkommune{'5694'} = '1223'; $kategori{'5694'} = 'G'; $poststed{'5694'} = 'ONARHEIM';
$postkommune{'5695'} = '1223'; $kategori{'5695'} = 'P'; $poststed{'5695'} = 'UGGDAL';
$postkommune{'5696'} = '1223'; $kategori{'5696'} = 'P'; $poststed{'5696'} = 'TYSNES';
$postkommune{'5700'} = '1235'; $kategori{'5700'} = 'B'; $poststed{'5700'} = 'VOSS';
$postkommune{'5701'} = '1235'; $kategori{'5701'} = 'P'; $poststed{'5701'} = 'VOSS';
$postkommune{'5702'} = '1235'; $kategori{'5702'} = 'P'; $poststed{'5702'} = 'VOSS';
$postkommune{'5703'} = '1235'; $kategori{'5703'} = 'P'; $poststed{'5703'} = 'VOSS';
$postkommune{'5707'} = '1235'; $kategori{'5707'} = 'G'; $poststed{'5707'} = 'EVANGER';
$postkommune{'5710'} = '1235'; $kategori{'5710'} = 'B'; $poststed{'5710'} = 'SKULESTADMO';
$postkommune{'5712'} = '1235'; $kategori{'5712'} = 'P'; $poststed{'5712'} = 'VOSSESTRAND';
$postkommune{'5713'} = '1235'; $kategori{'5713'} = 'G'; $poststed{'5713'} = 'VOSSESTRAND';
$postkommune{'5715'} = '1235'; $kategori{'5715'} = 'G'; $poststed{'5715'} = 'STALHEIM';
$postkommune{'5718'} = '1421'; $kategori{'5718'} = 'G'; $poststed{'5718'} = 'MYRDAL';
$postkommune{'5719'} = '1233'; $kategori{'5719'} = 'B'; $poststed{'5719'} = 'FINSE';
$postkommune{'5721'} = '1251'; $kategori{'5721'} = 'P'; $poststed{'5721'} = 'DALEKVAM';
$postkommune{'5722'} = '1251'; $kategori{'5722'} = 'G'; $poststed{'5722'} = 'DALEKVAM';
$postkommune{'5723'} = '1235'; $kategori{'5723'} = 'G'; $poststed{'5723'} = 'BOLSTADYRI';
$postkommune{'5724'} = '1251'; $kategori{'5724'} = 'B'; $poststed{'5724'} = 'STANGHELLE';
$postkommune{'5725'} = '1251'; $kategori{'5725'} = 'G'; $poststed{'5725'} = 'VAKSDAL';
$postkommune{'5726'} = '1251'; $kategori{'5726'} = 'P'; $poststed{'5726'} = 'VAKSDAL';
$postkommune{'5727'} = '1251'; $kategori{'5727'} = 'B'; $poststed{'5727'} = 'STAMNES';
$postkommune{'5728'} = '1251'; $kategori{'5728'} = 'G'; $poststed{'5728'} = 'EIDSLANDET';
$postkommune{'5729'} = '1252'; $kategori{'5729'} = 'B'; $poststed{'5729'} = 'MODALEN';
$postkommune{'5730'} = '1233'; $kategori{'5730'} = 'G'; $poststed{'5730'} = 'ULVIK';
$postkommune{'5731'} = '1233'; $kategori{'5731'} = 'P'; $poststed{'5731'} = 'ULVIK';
$postkommune{'5733'} = '1234'; $kategori{'5733'} = 'P'; $poststed{'5733'} = 'GRANVIN';
$postkommune{'5734'} = '1233'; $kategori{'5734'} = 'G'; $poststed{'5734'} = 'VALLAVIK';
$postkommune{'5736'} = '1234'; $kategori{'5736'} = 'G'; $poststed{'5736'} = 'GRANVIN';
$postkommune{'5741'} = '1421'; $kategori{'5741'} = 'P'; $poststed{'5741'} = 'AURLAND';
$postkommune{'5742'} = '1421'; $kategori{'5742'} = 'P'; $poststed{'5742'} = 'FLM';
$postkommune{'5743'} = '1421'; $kategori{'5743'} = 'G'; $poststed{'5743'} = 'FLM';
$postkommune{'5745'} = '1421'; $kategori{'5745'} = 'G'; $poststed{'5745'} = 'AURLAND';
$postkommune{'5746'} = '1421'; $kategori{'5746'} = 'B'; $poststed{'5746'} = 'UNDREDAL';
$postkommune{'5747'} = '1421'; $kategori{'5747'} = 'B'; $poststed{'5747'} = 'GUDVANGEN';
$postkommune{'5748'} = '1421'; $kategori{'5748'} = 'G'; $poststed{'5748'} = 'STYVI';
$postkommune{'5749'} = '1421'; $kategori{'5749'} = 'G'; $poststed{'5749'} = 'BAKKA';
$postkommune{'5750'} = '1228'; $kategori{'5750'} = 'G'; $poststed{'5750'} = 'ODDA';
$postkommune{'5751'} = '1228'; $kategori{'5751'} = 'P'; $poststed{'5751'} = 'ODDA';
$postkommune{'5760'} = '1228'; $kategori{'5760'} = 'B'; $poststed{'5760'} = 'RLDAL';
$postkommune{'5763'} = '1228'; $kategori{'5763'} = 'G'; $poststed{'5763'} = 'SKARE';
$postkommune{'5770'} = '1228'; $kategori{'5770'} = 'G'; $poststed{'5770'} = 'TYSSEDAL';
$postkommune{'5773'} = '1231'; $kategori{'5773'} = 'G'; $poststed{'5773'} = 'HOVLAND';
$postkommune{'5776'} = '1231'; $kategori{'5776'} = 'B'; $poststed{'5776'} = 'N';
$postkommune{'5777'} = '1231'; $kategori{'5777'} = 'G'; $poststed{'5777'} = 'GRIMO';
$postkommune{'5778'} = '1231'; $kategori{'5778'} = 'G'; $poststed{'5778'} = 'UTNE';
$postkommune{'5779'} = '1231'; $kategori{'5779'} = 'P'; $poststed{'5779'} = 'UTNE';
$postkommune{'5780'} = '1231'; $kategori{'5780'} = 'G'; $poststed{'5780'} = 'KINSARVIK';
$postkommune{'5781'} = '1231'; $kategori{'5781'} = 'G'; $poststed{'5781'} = 'LOFTHUS';
$postkommune{'5782'} = '1231'; $kategori{'5782'} = 'P'; $poststed{'5782'} = 'KINSARVIK';
$postkommune{'5783'} = '1232'; $kategori{'5783'} = 'G'; $poststed{'5783'} = 'EIDFJORD';
$postkommune{'5784'} = '1232'; $kategori{'5784'} = 'G'; $poststed{'5784'} = 'VRE EIDFJORD';
$postkommune{'5785'} = '1232'; $kategori{'5785'} = 'G'; $poststed{'5785'} = 'VRINGSFOSS';
$postkommune{'5786'} = '1232'; $kategori{'5786'} = 'P'; $poststed{'5786'} = 'EIDFJORD';
$postkommune{'5787'} = '1231'; $kategori{'5787'} = 'P'; $poststed{'5787'} = 'LOFTHUS';
$postkommune{'5788'} = '1231'; $kategori{'5788'} = 'K'; $poststed{'5788'} = 'KINSARVIK';
$postkommune{'5803'} = '1201'; $kategori{'5803'} = 'P'; $poststed{'5803'} = 'BERGEN';
$postkommune{'5804'} = '1201'; $kategori{'5804'} = 'P'; $poststed{'5804'} = 'BERGEN';
$postkommune{'5805'} = '1201'; $kategori{'5805'} = 'P'; $poststed{'5805'} = 'BERGEN';
$postkommune{'5806'} = '1201'; $kategori{'5806'} = 'P'; $poststed{'5806'} = 'BERGEN';
$postkommune{'5807'} = '1201'; $kategori{'5807'} = 'P'; $poststed{'5807'} = 'BERGEN';
$postkommune{'5808'} = '1201'; $kategori{'5808'} = 'P'; $poststed{'5808'} = 'BERGEN';
$postkommune{'5809'} = '1201'; $kategori{'5809'} = 'P'; $poststed{'5809'} = 'BERGEN';
$postkommune{'5811'} = '1201'; $kategori{'5811'} = 'P'; $poststed{'5811'} = 'BERGEN';
$postkommune{'5812'} = '1201'; $kategori{'5812'} = 'P'; $poststed{'5812'} = 'BERGEN';
$postkommune{'5815'} = '1201'; $kategori{'5815'} = 'P'; $poststed{'5815'} = 'BERGEN';
$postkommune{'5816'} = '1201'; $kategori{'5816'} = 'P'; $poststed{'5816'} = 'BERGEN';
$postkommune{'5817'} = '1201'; $kategori{'5817'} = 'P'; $poststed{'5817'} = 'BERGEN';
$postkommune{'5818'} = '1201'; $kategori{'5818'} = 'P'; $poststed{'5818'} = 'BERGEN';
$postkommune{'5819'} = '1201'; $kategori{'5819'} = 'P'; $poststed{'5819'} = 'BERGEN';
$postkommune{'5821'} = '1201'; $kategori{'5821'} = 'P'; $poststed{'5821'} = 'BERGEN';
$postkommune{'5822'} = '1201'; $kategori{'5822'} = 'P'; $poststed{'5822'} = 'BERGEN';
$postkommune{'5824'} = '1201'; $kategori{'5824'} = 'P'; $poststed{'5824'} = 'BERGEN';
$postkommune{'5825'} = '1201'; $kategori{'5825'} = 'P'; $poststed{'5825'} = 'BERGEN';
$postkommune{'5828'} = '1201'; $kategori{'5828'} = 'P'; $poststed{'5828'} = 'BERGEN';
$postkommune{'5829'} = '1201'; $kategori{'5829'} = 'P'; $poststed{'5829'} = 'BERGEN';
$postkommune{'5835'} = '1201'; $kategori{'5835'} = 'P'; $poststed{'5835'} = 'BERGEN';
$postkommune{'5836'} = '1201'; $kategori{'5836'} = 'P'; $poststed{'5836'} = 'BERGEN';
$postkommune{'5838'} = '1201'; $kategori{'5838'} = 'P'; $poststed{'5838'} = 'BERGEN';
$postkommune{'5845'} = '1201'; $kategori{'5845'} = 'P'; $poststed{'5845'} = 'BERGEN';
$postkommune{'5847'} = '1201'; $kategori{'5847'} = 'P'; $poststed{'5847'} = 'BERGEN';
$postkommune{'5848'} = '1201'; $kategori{'5848'} = 'P'; $poststed{'5848'} = 'BERGEN';
$postkommune{'5849'} = '1201'; $kategori{'5849'} = 'P'; $poststed{'5849'} = 'BERGEN';
$postkommune{'5851'} = '1201'; $kategori{'5851'} = 'P'; $poststed{'5851'} = 'BERGEN';
$postkommune{'5852'} = '1201'; $kategori{'5852'} = 'P'; $poststed{'5852'} = 'BERGEN';
$postkommune{'5853'} = '1201'; $kategori{'5853'} = 'P'; $poststed{'5853'} = 'BERGEN';
$postkommune{'5854'} = '1201'; $kategori{'5854'} = 'P'; $poststed{'5854'} = 'BERGEN';
$postkommune{'5857'} = '1201'; $kategori{'5857'} = 'P'; $poststed{'5857'} = 'BERGEN';
$postkommune{'5858'} = '1201'; $kategori{'5858'} = 'P'; $poststed{'5858'} = 'BERGEN';
$postkommune{'5859'} = '1201'; $kategori{'5859'} = 'P'; $poststed{'5859'} = 'BERGEN';
$postkommune{'5861'} = '1201'; $kategori{'5861'} = 'P'; $poststed{'5861'} = 'BERGEN';
$postkommune{'5862'} = '1201'; $kategori{'5862'} = 'P'; $poststed{'5862'} = 'BERGEN';
$postkommune{'5863'} = '1201'; $kategori{'5863'} = 'P'; $poststed{'5863'} = 'BERGEN';
$postkommune{'5864'} = '1201'; $kategori{'5864'} = 'P'; $poststed{'5864'} = 'BERGEN';
$postkommune{'5868'} = '1201'; $kategori{'5868'} = 'P'; $poststed{'5868'} = 'BERGEN';
$postkommune{'5869'} = '1201'; $kategori{'5869'} = 'P'; $poststed{'5869'} = 'BERGEN';
$postkommune{'5871'} = '1201'; $kategori{'5871'} = 'P'; $poststed{'5871'} = 'BERGEN';
$postkommune{'5872'} = '1201'; $kategori{'5872'} = 'P'; $poststed{'5872'} = 'BERGEN';
$postkommune{'5873'} = '1201'; $kategori{'5873'} = 'P'; $poststed{'5873'} = 'BERGEN';
$postkommune{'5876'} = '1201'; $kategori{'5876'} = 'P'; $poststed{'5876'} = 'BERGEN';
$postkommune{'5877'} = '1201'; $kategori{'5877'} = 'P'; $poststed{'5877'} = 'BERGEN';
$postkommune{'5878'} = '1201'; $kategori{'5878'} = 'P'; $poststed{'5878'} = 'BERGEN';
$postkommune{'5879'} = '1201'; $kategori{'5879'} = 'P'; $poststed{'5879'} = 'BERGEN';
$postkommune{'5881'} = '1201'; $kategori{'5881'} = 'P'; $poststed{'5881'} = 'BERGEN';
$postkommune{'5882'} = '1201'; $kategori{'5882'} = 'P'; $poststed{'5882'} = 'BERGEN';
$postkommune{'5883'} = '1201'; $kategori{'5883'} = 'P'; $poststed{'5883'} = 'BERGEN';
$postkommune{'5884'} = '1201'; $kategori{'5884'} = 'P'; $poststed{'5884'} = 'BERGEN';
$postkommune{'5886'} = '1201'; $kategori{'5886'} = 'P'; $poststed{'5886'} = 'BERGEN';
$postkommune{'5888'} = '1201'; $kategori{'5888'} = 'P'; $poststed{'5888'} = 'BERGEN';
$postkommune{'5889'} = '1201'; $kategori{'5889'} = 'P'; $poststed{'5889'} = 'BERGEN';
$postkommune{'5892'} = '1201'; $kategori{'5892'} = 'P'; $poststed{'5892'} = 'BERGEN';
$postkommune{'5893'} = '1201'; $kategori{'5893'} = 'P'; $poststed{'5893'} = 'BERGEN';
$postkommune{'5896'} = '1201'; $kategori{'5896'} = 'P'; $poststed{'5896'} = 'BERGEN';
$postkommune{'5899'} = '1201'; $kategori{'5899'} = 'P'; $poststed{'5899'} = 'BERGEN';
$postkommune{'5902'} = '1263'; $kategori{'5902'} = 'P'; $poststed{'5902'} = 'ISDALST';
$postkommune{'5903'} = '1263'; $kategori{'5903'} = 'P'; $poststed{'5903'} = 'ISDALST';
$postkommune{'5904'} = '1263'; $kategori{'5904'} = 'P'; $poststed{'5904'} = 'ISDALST';
$postkommune{'5906'} = '1256'; $kategori{'5906'} = 'P'; $poststed{'5906'} = 'FREKHAUG';
$postkommune{'5907'} = '1263'; $kategori{'5907'} = 'P'; $poststed{'5907'} = 'ALVERSUND';
$postkommune{'5908'} = '1263'; $kategori{'5908'} = 'P'; $poststed{'5908'} = 'ISDALST';
$postkommune{'5911'} = '1263'; $kategori{'5911'} = 'G'; $poststed{'5911'} = 'ALVERSUND';
$postkommune{'5912'} = '1263'; $kategori{'5912'} = 'G'; $poststed{'5912'} = 'SEIM';
$postkommune{'5913'} = '1263'; $kategori{'5913'} = 'G'; $poststed{'5913'} = 'EIKANGERVG';
$postkommune{'5914'} = '1263'; $kategori{'5914'} = 'G'; $poststed{'5914'} = 'ISDALST';
$postkommune{'5915'} = '1263'; $kategori{'5915'} = 'G'; $poststed{'5915'} = 'HJELMS';
$postkommune{'5917'} = '1256'; $kategori{'5917'} = 'B'; $poststed{'5917'} = 'ROSSLAND';
$postkommune{'5918'} = '1256'; $kategori{'5918'} = 'G'; $poststed{'5918'} = 'FREKHAUG';
$postkommune{'5931'} = '1260'; $kategori{'5931'} = 'P'; $poststed{'5931'} = 'MANGER';
$postkommune{'5936'} = '1260'; $kategori{'5936'} = 'G'; $poststed{'5936'} = 'MANGER';
$postkommune{'5937'} = '1260'; $kategori{'5937'} = 'B'; $poststed{'5937'} = 'BVGEN';
$postkommune{'5938'} = '1260'; $kategori{'5938'} = 'B'; $poststed{'5938'} = 'SBVGEN';
$postkommune{'5939'} = '1260'; $kategori{'5939'} = 'G'; $poststed{'5939'} = 'SLETTA';
$postkommune{'5941'} = '1264'; $kategori{'5941'} = 'P'; $poststed{'5941'} = 'AUSTRHEIM';
$postkommune{'5943'} = '1264'; $kategori{'5943'} = 'G'; $poststed{'5943'} = 'AUSTRHEIM';
$postkommune{'5947'} = '1265'; $kategori{'5947'} = 'G'; $poststed{'5947'} = 'FEDJE';
$postkommune{'5948'} = '1265'; $kategori{'5948'} = 'P'; $poststed{'5948'} = 'FEDJE';
$postkommune{'5951'} = '1263'; $kategori{'5951'} = 'P'; $poststed{'5951'} = 'LINDS';
$postkommune{'5953'} = '1264'; $kategori{'5953'} = 'B'; $poststed{'5953'} = 'FONNES';
$postkommune{'5954'} = '1263'; $kategori{'5954'} = 'G'; $poststed{'5954'} = 'MONGSTAD';
$postkommune{'5955'} = '1263'; $kategori{'5955'} = 'G'; $poststed{'5955'} = 'LINDS';
$postkommune{'5956'} = '1263'; $kategori{'5956'} = 'G'; $poststed{'5956'} = 'VGSEIDET';
$postkommune{'5957'} = '1263'; $kategori{'5957'} = 'B'; $poststed{'5957'} = 'MYKING';
$postkommune{'5960'} = '1411'; $kategori{'5960'} = 'B'; $poststed{'5960'} = 'DALSYRA';
$postkommune{'5961'} = '1411'; $kategori{'5961'} = 'B'; $poststed{'5961'} = 'BREKKE';
$postkommune{'5962'} = '1416'; $kategori{'5962'} = 'B'; $poststed{'5962'} = 'BJORDAL';
$postkommune{'5966'} = '1411'; $kategori{'5966'} = 'G'; $poststed{'5966'} = 'EIVINDVIK';
$postkommune{'5967'} = '1411'; $kategori{'5967'} = 'P'; $poststed{'5967'} = 'EIVINDVIK';
$postkommune{'5970'} = '1411'; $kategori{'5970'} = 'G'; $poststed{'5970'} = 'BYRKNESY';
$postkommune{'5977'} = '1411'; $kategori{'5977'} = 'G'; $poststed{'5977'} = 'NNELAND';
$postkommune{'5978'} = '1411'; $kategori{'5978'} = 'G'; $poststed{'5978'} = 'MJMNA';
$postkommune{'5979'} = '1411'; $kategori{'5979'} = 'P'; $poststed{'5979'} = 'BYRKNESY';
$postkommune{'5981'} = '1266'; $kategori{'5981'} = 'G'; $poststed{'5981'} = 'MASFJORDNES';
$postkommune{'5983'} = '1266'; $kategori{'5983'} = 'B'; $poststed{'5983'} = 'HAUGSVR';
$postkommune{'5984'} = '1266'; $kategori{'5984'} = 'G'; $poststed{'5984'} = 'MATREDAL';
$postkommune{'5986'} = '1266'; $kategori{'5986'} = 'G'; $poststed{'5986'} = 'HOSTELAND';
$postkommune{'5987'} = '1266'; $kategori{'5987'} = 'P'; $poststed{'5987'} = 'HOSTELAND';
$postkommune{'5991'} = '1263'; $kategori{'5991'} = 'P'; $poststed{'5991'} = 'OSTEREIDET';
$postkommune{'5993'} = '1263'; $kategori{'5993'} = 'G'; $poststed{'5993'} = 'OSTEREIDET';
$postkommune{'5994'} = '1263'; $kategori{'5994'} = 'G'; $poststed{'5994'} = 'VIKANES';
$postkommune{'6001'} = '1504'; $kategori{'6001'} = 'P'; $poststed{'6001'} = 'LESUND';
$postkommune{'6002'} = '1504'; $kategori{'6002'} = 'G'; $poststed{'6002'} = 'LESUND';
$postkommune{'6003'} = '1504'; $kategori{'6003'} = 'G'; $poststed{'6003'} = 'LESUND';
$postkommune{'6004'} = '1504'; $kategori{'6004'} = 'G'; $poststed{'6004'} = 'LESUND';
$postkommune{'6005'} = '1504'; $kategori{'6005'} = 'G'; $poststed{'6005'} = 'LESUND';
$postkommune{'6006'} = '1504'; $kategori{'6006'} = 'G'; $poststed{'6006'} = 'LESUND';
$postkommune{'6007'} = '1504'; $kategori{'6007'} = 'G'; $poststed{'6007'} = 'LESUND';
$postkommune{'6008'} = '1504'; $kategori{'6008'} = 'G'; $poststed{'6008'} = 'LESUND';
$postkommune{'6009'} = '1504'; $kategori{'6009'} = 'G'; $poststed{'6009'} = 'LESUND';
$postkommune{'6010'} = '1504'; $kategori{'6010'} = 'G'; $poststed{'6010'} = 'LESUND';
$postkommune{'6011'} = '1504'; $kategori{'6011'} = 'G'; $poststed{'6011'} = 'LESUND';
$postkommune{'6012'} = '1504'; $kategori{'6012'} = 'G'; $poststed{'6012'} = 'LESUND';
$postkommune{'6013'} = '1504'; $kategori{'6013'} = 'G'; $poststed{'6013'} = 'LESUND';
$postkommune{'6014'} = '1504'; $kategori{'6014'} = 'G'; $poststed{'6014'} = 'LESUND';
$postkommune{'6015'} = '1504'; $kategori{'6015'} = 'G'; $poststed{'6015'} = 'LESUND';
$postkommune{'6016'} = '1504'; $kategori{'6016'} = 'G'; $poststed{'6016'} = 'LESUND';
$postkommune{'6017'} = '1504'; $kategori{'6017'} = 'G'; $poststed{'6017'} = 'LESUND';
$postkommune{'6018'} = '1504'; $kategori{'6018'} = 'G'; $poststed{'6018'} = 'LESUND';
$postkommune{'6019'} = '1504'; $kategori{'6019'} = 'G'; $poststed{'6019'} = 'LESUND';
$postkommune{'6020'} = '1504'; $kategori{'6020'} = 'G'; $poststed{'6020'} = 'LESUND';
$postkommune{'6021'} = '1504'; $kategori{'6021'} = 'P'; $poststed{'6021'} = 'LESUND';
$postkommune{'6022'} = '1504'; $kategori{'6022'} = 'P'; $poststed{'6022'} = 'LESUND';
$postkommune{'6023'} = '1504'; $kategori{'6023'} = 'P'; $poststed{'6023'} = 'LESUND';
$postkommune{'6024'} = '1504'; $kategori{'6024'} = 'P'; $poststed{'6024'} = 'LESUND';
$postkommune{'6025'} = '1504'; $kategori{'6025'} = 'S'; $poststed{'6025'} = 'LESUND';
$postkommune{'6026'} = '1504'; $kategori{'6026'} = 'K'; $poststed{'6026'} = 'LESUND';
$postkommune{'6028'} = '1504'; $kategori{'6028'} = 'P'; $poststed{'6028'} = 'LESUND';
$postkommune{'6030'} = '1531'; $kategori{'6030'} = 'G'; $poststed{'6030'} = 'LANGEVG';
$postkommune{'6035'} = '1531'; $kategori{'6035'} = 'G'; $poststed{'6035'} = 'FISKARSTRAND';
$postkommune{'6036'} = '1531'; $kategori{'6036'} = 'G'; $poststed{'6036'} = 'MAUSEIDVG';
$postkommune{'6037'} = '1531'; $kategori{'6037'} = 'B'; $poststed{'6037'} = 'EIDSNES';
$postkommune{'6038'} = '1531'; $kategori{'6038'} = 'P'; $poststed{'6038'} = 'FISKARSTRAND';
$postkommune{'6039'} = '1531'; $kategori{'6039'} = 'P'; $poststed{'6039'} = 'LANGEVG';
$postkommune{'6040'} = '1532'; $kategori{'6040'} = 'G'; $poststed{'6040'} = 'VIGRA';
$postkommune{'6045'} = '1504'; $kategori{'6045'} = 'P'; $poststed{'6045'} = 'LESUND';
$postkommune{'6046'} = '1504'; $kategori{'6046'} = 'P'; $poststed{'6046'} = 'LESUND';
$postkommune{'6050'} = '1532'; $kategori{'6050'} = 'G'; $poststed{'6050'} = 'VALDERYA';
$postkommune{'6051'} = '1532'; $kategori{'6051'} = 'P'; $poststed{'6051'} = 'VALDERYA';
$postkommune{'6052'} = '1532'; $kategori{'6052'} = 'G'; $poststed{'6052'} = 'GISKE';
$postkommune{'6055'} = '1532'; $kategori{'6055'} = 'B'; $poststed{'6055'} = 'GODYA';
$postkommune{'6057'} = '1504'; $kategori{'6057'} = 'G'; $poststed{'6057'} = 'ELLINGSY';
$postkommune{'6058'} = '1532'; $kategori{'6058'} = 'P'; $poststed{'6058'} = 'VALDERYA';
$postkommune{'6059'} = '1532'; $kategori{'6059'} = 'P'; $poststed{'6059'} = 'VIGRA';
$postkommune{'6060'} = '1517'; $kategori{'6060'} = 'G'; $poststed{'6060'} = 'HAREID';
$postkommune{'6062'} = '1517'; $kategori{'6062'} = 'G'; $poststed{'6062'} = 'BRANDAL';
$postkommune{'6063'} = '1517'; $kategori{'6063'} = 'B'; $poststed{'6063'} = 'HJRUNGAVG';
$postkommune{'6064'} = '1516'; $kategori{'6064'} = 'B'; $poststed{'6064'} = 'HADDAL';
$postkommune{'6065'} = '1516'; $kategori{'6065'} = 'G'; $poststed{'6065'} = 'ULSTEINVIK';
$postkommune{'6067'} = '1516'; $kategori{'6067'} = 'P'; $poststed{'6067'} = 'ULSTEINVIK';
$postkommune{'6069'} = '1517'; $kategori{'6069'} = 'P'; $poststed{'6069'} = 'HAREID';
$postkommune{'6070'} = '1515'; $kategori{'6070'} = 'G'; $poststed{'6070'} = 'TJRVG';
$postkommune{'6076'} = '1515'; $kategori{'6076'} = 'B'; $poststed{'6076'} = 'MOLDTUSTRANDA';
$postkommune{'6080'} = '1515'; $kategori{'6080'} = 'B'; $poststed{'6080'} = 'GURSKY';
$postkommune{'6082'} = '1514'; $kategori{'6082'} = 'G'; $poststed{'6082'} = 'GURSKEN';
$postkommune{'6083'} = '1514'; $kategori{'6083'} = 'B'; $poststed{'6083'} = 'GJERDSVIKA';
$postkommune{'6084'} = '1514'; $kategori{'6084'} = 'G'; $poststed{'6084'} = 'LARSNES';
$postkommune{'6085'} = '1514'; $kategori{'6085'} = 'P'; $poststed{'6085'} = 'LARSNES';
$postkommune{'6087'} = '1514'; $kategori{'6087'} = 'B'; $poststed{'6087'} = 'KVAMSY';
$postkommune{'6089'} = '1514'; $kategori{'6089'} = 'B'; $poststed{'6089'} = 'SANDSHAMN';
$postkommune{'6090'} = '1515'; $kategori{'6090'} = 'G'; $poststed{'6090'} = 'FOSNAVG';
$postkommune{'6092'} = '1515'; $kategori{'6092'} = 'G'; $poststed{'6092'} = 'EGGESBNES';
$postkommune{'6094'} = '1515'; $kategori{'6094'} = 'G'; $poststed{'6094'} = 'LEINY';
$postkommune{'6095'} = '1515'; $kategori{'6095'} = 'G'; $poststed{'6095'} = 'BLANDET';
$postkommune{'6096'} = '1515'; $kategori{'6096'} = 'G'; $poststed{'6096'} = 'RUNDE';
$postkommune{'6098'} = '1515'; $kategori{'6098'} = 'G'; $poststed{'6098'} = 'NERLANDSY';
$postkommune{'6099'} = '1515'; $kategori{'6099'} = 'P'; $poststed{'6099'} = 'FOSNAVG';
$postkommune{'6100'} = '1519'; $kategori{'6100'} = 'G'; $poststed{'6100'} = 'VOLDA';
$postkommune{'6101'} = '1519'; $kategori{'6101'} = 'P'; $poststed{'6101'} = 'VOLDA';
$postkommune{'6110'} = '1519'; $kategori{'6110'} = 'G'; $poststed{'6110'} = 'AUSTEFJORDEN';
$postkommune{'6120'} = '1519'; $kategori{'6120'} = 'G'; $poststed{'6120'} = 'FOLKESTAD';
$postkommune{'6133'} = '1519'; $kategori{'6133'} = 'B'; $poststed{'6133'} = 'LAUVSTAD';
$postkommune{'6139'} = '1511'; $kategori{'6139'} = 'P'; $poststed{'6139'} = 'FISKBYGD';
$postkommune{'6140'} = '1511'; $kategori{'6140'} = 'B'; $poststed{'6140'} = 'SYVDE';
$postkommune{'6141'} = '1511'; $kategori{'6141'} = 'G'; $poststed{'6141'} = 'ROVDE';
$postkommune{'6142'} = '1511'; $kategori{'6142'} = 'G'; $poststed{'6142'} = 'EIDS';
$postkommune{'6143'} = '1511'; $kategori{'6143'} = 'G'; $poststed{'6143'} = 'FISKBYGD';
$postkommune{'6144'} = '1511'; $kategori{'6144'} = 'G'; $poststed{'6144'} = 'SYLTE';
$postkommune{'6146'} = '1511'; $kategori{'6146'} = 'B'; $poststed{'6146'} = 'HEIM';
$postkommune{'6149'} = '1511'; $kategori{'6149'} = 'G'; $poststed{'6149'} = 'RAM';
$postkommune{'6150'} = '1520'; $kategori{'6150'} = 'G'; $poststed{'6150'} = 'RSTA';
$postkommune{'6151'} = '1520'; $kategori{'6151'} = 'P'; $poststed{'6151'} = 'RSTA';
$postkommune{'6160'} = '1520'; $kategori{'6160'} = 'G'; $poststed{'6160'} = 'HOVDEBYGDA';
$postkommune{'6161'} = '1520'; $kategori{'6161'} = 'P'; $poststed{'6161'} = 'HOVDEBYGDA';
$postkommune{'6165'} = '1520'; $kategori{'6165'} = 'G'; $poststed{'6165'} = 'SB';
$postkommune{'6166'} = '1520'; $kategori{'6166'} = 'P'; $poststed{'6166'} = 'SB';
$postkommune{'6170'} = '1520'; $kategori{'6170'} = 'B'; $poststed{'6170'} = 'VARTDAL';
$postkommune{'6174'} = '1520'; $kategori{'6174'} = 'G'; $poststed{'6174'} = 'BARSTADVIK';
$postkommune{'6183'} = '1520'; $kategori{'6183'} = 'G'; $poststed{'6183'} = 'TRANDAL';
$postkommune{'6184'} = '1520'; $kategori{'6184'} = 'G'; $poststed{'6184'} = 'STORESTANDAL';
$postkommune{'6190'} = '1520'; $kategori{'6190'} = 'G'; $poststed{'6190'} = 'BJRKE';
$postkommune{'6196'} = '1520'; $kategori{'6196'} = 'G'; $poststed{'6196'} = 'NORANGSFJORDEN';
$postkommune{'6200'} = '1525'; $kategori{'6200'} = 'G'; $poststed{'6200'} = 'STRANDA';
$postkommune{'6201'} = '1525'; $kategori{'6201'} = 'P'; $poststed{'6201'} = 'STRANDA';
$postkommune{'6210'} = '1524'; $kategori{'6210'} = 'B'; $poststed{'6210'} = 'VALLDAL';
$postkommune{'6212'} = '1525'; $kategori{'6212'} = 'G'; $poststed{'6212'} = 'LIABYGDA';
$postkommune{'6213'} = '1524'; $kategori{'6213'} = 'G'; $poststed{'6213'} = 'TAFJORD';
$postkommune{'6214'} = '1524'; $kategori{'6214'} = 'G'; $poststed{'6214'} = 'NORDDAL';
$postkommune{'6215'} = '1524'; $kategori{'6215'} = 'B'; $poststed{'6215'} = 'EIDSDAL';
$postkommune{'6216'} = '1525'; $kategori{'6216'} = 'B'; $poststed{'6216'} = 'GEIRANGER';
$postkommune{'6218'} = '1525'; $kategori{'6218'} = 'B'; $poststed{'6218'} = 'HELLESYLT';
$postkommune{'6220'} = '1528'; $kategori{'6220'} = 'G'; $poststed{'6220'} = 'STRAUMGJERDE';
$postkommune{'6222'} = '1528'; $kategori{'6222'} = 'B'; $poststed{'6222'} = 'IKORNNES';
$postkommune{'6224'} = '1528'; $kategori{'6224'} = 'G'; $poststed{'6224'} = 'HUNDEIDVIK';
$postkommune{'6230'} = '1528'; $kategori{'6230'} = 'G'; $poststed{'6230'} = 'SYKKYLVEN';
$postkommune{'6238'} = '1528'; $kategori{'6238'} = 'P'; $poststed{'6238'} = 'STRAUMGJERDE';
$postkommune{'6239'} = '1528'; $kategori{'6239'} = 'P'; $poststed{'6239'} = 'SYKKYLVEN';
$postkommune{'6240'} = '1523'; $kategori{'6240'} = 'G'; $poststed{'6240'} = 'RSKOG';
$postkommune{'6249'} = '1523'; $kategori{'6249'} = 'P'; $poststed{'6249'} = 'RSKOG';
$postkommune{'6250'} = '1526'; $kategori{'6250'} = 'G'; $poststed{'6250'} = 'STORDAL';
$postkommune{'6259'} = '1526'; $kategori{'6259'} = 'P'; $poststed{'6259'} = 'STORDAL';
$postkommune{'6260'} = '1529'; $kategori{'6260'} = 'G'; $poststed{'6260'} = 'SKODJE';
$postkommune{'6263'} = '1529'; $kategori{'6263'} = 'P'; $poststed{'6263'} = 'SKODJE';
$postkommune{'6264'} = '1534'; $kategori{'6264'} = 'G'; $poststed{'6264'} = 'TENNFJORD';
$postkommune{'6265'} = '1534'; $kategori{'6265'} = 'G'; $poststed{'6265'} = 'VATNE';
$postkommune{'6270'} = '1534'; $kategori{'6270'} = 'G'; $poststed{'6270'} = 'BRATTVG';
$postkommune{'6272'} = '1534'; $kategori{'6272'} = 'G'; $poststed{'6272'} = 'HILDRE';
$postkommune{'6280'} = '1534'; $kategori{'6280'} = 'G'; $poststed{'6280'} = 'SVIK';
$postkommune{'6281'} = '1534'; $kategori{'6281'} = 'P'; $poststed{'6281'} = 'SVIK';
$postkommune{'6282'} = '1534'; $kategori{'6282'} = 'P'; $poststed{'6282'} = 'BRATTVG';
$postkommune{'6283'} = '1534'; $kategori{'6283'} = 'P'; $poststed{'6283'} = 'VATNE';
$postkommune{'6285'} = '1534'; $kategori{'6285'} = 'G'; $poststed{'6285'} = 'STOREKALVY';
$postkommune{'6290'} = '1534'; $kategori{'6290'} = 'B'; $poststed{'6290'} = 'HARAMSY';
$postkommune{'6292'} = '1534'; $kategori{'6292'} = 'G'; $poststed{'6292'} = 'KJERSTAD';
$postkommune{'6293'} = '1534'; $kategori{'6293'} = 'G'; $poststed{'6293'} = 'LONGVA';
$postkommune{'6294'} = '1534'; $kategori{'6294'} = 'G'; $poststed{'6294'} = 'FJRTOFT';
$postkommune{'6300'} = '1539'; $kategori{'6300'} = 'G'; $poststed{'6300'} = 'NDALSNES';
$postkommune{'6301'} = '1539'; $kategori{'6301'} = 'P'; $poststed{'6301'} = 'NDALSNES';
$postkommune{'6310'} = '1539'; $kategori{'6310'} = 'G'; $poststed{'6310'} = 'VEBLUNGSNES';
$postkommune{'6315'} = '1539'; $kategori{'6315'} = 'G'; $poststed{'6315'} = 'INNFJORDEN';
$postkommune{'6320'} = '1539'; $kategori{'6320'} = 'G'; $poststed{'6320'} = 'ISFJORDEN';
$postkommune{'6330'} = '1539'; $kategori{'6330'} = 'B'; $poststed{'6330'} = 'VERMA';
$postkommune{'6339'} = '1539'; $kategori{'6339'} = 'P'; $poststed{'6339'} = 'ISFJORDEN';
$postkommune{'6350'} = '1539'; $kategori{'6350'} = 'G'; $poststed{'6350'} = 'EIDSBYGDA';
$postkommune{'6360'} = '1539'; $kategori{'6360'} = 'B'; $poststed{'6360'} = 'FARNES';
$postkommune{'6363'} = '1539'; $kategori{'6363'} = 'G'; $poststed{'6363'} = 'MITTET';
$postkommune{'6364'} = '1543'; $kategori{'6364'} = 'B'; $poststed{'6364'} = 'VISTDAL';
$postkommune{'6386'} = '1539'; $kategori{'6386'} = 'B'; $poststed{'6386'} = 'MNDALEN';
$postkommune{'6387'} = '1539'; $kategori{'6387'} = 'B'; $poststed{'6387'} = 'VGSTRANDA';
$postkommune{'6390'} = '1535'; $kategori{'6390'} = 'G'; $poststed{'6390'} = 'VESTNES';
$postkommune{'6391'} = '1535'; $kategori{'6391'} = 'G'; $poststed{'6391'} = 'TRESFJORD';
$postkommune{'6392'} = '1535'; $kategori{'6392'} = 'G'; $poststed{'6392'} = 'VIKEBUKT';
$postkommune{'6393'} = '1535'; $kategori{'6393'} = 'G'; $poststed{'6393'} = 'TOMREFJORD';
$postkommune{'6394'} = '1535'; $kategori{'6394'} = 'B'; $poststed{'6394'} = 'FIKSDAL';
$postkommune{'6395'} = '1535'; $kategori{'6395'} = 'G'; $poststed{'6395'} = 'REKDAL';
$postkommune{'6396'} = '1535'; $kategori{'6396'} = 'P'; $poststed{'6396'} = 'VIKEBUKT';
$postkommune{'6397'} = '1535'; $kategori{'6397'} = 'P'; $poststed{'6397'} = 'TRESFJORD';
$postkommune{'6398'} = '1535'; $kategori{'6398'} = 'P'; $poststed{'6398'} = 'TOMREFJORD';
$postkommune{'6399'} = '1535'; $kategori{'6399'} = 'P'; $poststed{'6399'} = 'VESTNES';
$postkommune{'6401'} = '1502'; $kategori{'6401'} = 'P'; $poststed{'6401'} = 'MOLDE';
$postkommune{'6402'} = '1502'; $kategori{'6402'} = 'P'; $poststed{'6402'} = 'MOLDE';
$postkommune{'6403'} = '1502'; $kategori{'6403'} = 'P'; $poststed{'6403'} = 'MOLDE';
$postkommune{'6404'} = '1502'; $kategori{'6404'} = 'K'; $poststed{'6404'} = 'MOLDE';
$postkommune{'6405'} = '1502'; $kategori{'6405'} = 'S'; $poststed{'6405'} = 'MOLDE';
$postkommune{'6407'} = '1502'; $kategori{'6407'} = 'K'; $poststed{'6407'} = 'MOLDE';
$postkommune{'6408'} = '1548'; $kategori{'6408'} = 'G'; $poststed{'6408'} = 'AUREOSEN';
$postkommune{'6409'} = '1547'; $kategori{'6409'} = 'G'; $poststed{'6409'} = 'MOLDE';
$postkommune{'6410'} = '1502'; $kategori{'6410'} = 'P'; $poststed{'6410'} = 'MOLDE';
$postkommune{'6411'} = '1502'; $kategori{'6411'} = 'G'; $poststed{'6411'} = 'MOLDE';
$postkommune{'6412'} = '1502'; $kategori{'6412'} = 'G'; $poststed{'6412'} = 'MOLDE';
$postkommune{'6413'} = '1502'; $kategori{'6413'} = 'G'; $poststed{'6413'} = 'MOLDE';
$postkommune{'6414'} = '1502'; $kategori{'6414'} = 'G'; $poststed{'6414'} = 'MOLDE';
$postkommune{'6415'} = '1502'; $kategori{'6415'} = 'G'; $poststed{'6415'} = 'MOLDE';
$postkommune{'6416'} = '1502'; $kategori{'6416'} = 'G'; $poststed{'6416'} = 'MOLDE';
$postkommune{'6418'} = '1502'; $kategori{'6418'} = 'G'; $poststed{'6418'} = 'SEKKEN';
$postkommune{'6419'} = '1502'; $kategori{'6419'} = 'G'; $poststed{'6419'} = 'MOLDE';
$postkommune{'6421'} = '1502'; $kategori{'6421'} = 'G'; $poststed{'6421'} = 'MOLDE';
$postkommune{'6422'} = '1502'; $kategori{'6422'} = 'G'; $poststed{'6422'} = 'MOLDE';
$postkommune{'6425'} = '1502'; $kategori{'6425'} = 'G'; $poststed{'6425'} = 'MOLDE';
$postkommune{'6429'} = '1502'; $kategori{'6429'} = 'G'; $poststed{'6429'} = 'MOLDE';
$postkommune{'6430'} = '1548'; $kategori{'6430'} = 'B'; $poststed{'6430'} = 'BUD';
$postkommune{'6433'} = '1548'; $kategori{'6433'} = 'B'; $poststed{'6433'} = 'HUSTAD';
$postkommune{'6440'} = '1548'; $kategori{'6440'} = 'G'; $poststed{'6440'} = 'ELNESVGEN';
$postkommune{'6443'} = '1548'; $kategori{'6443'} = 'G'; $poststed{'6443'} = 'TORNES I ROMSDAL';
$postkommune{'6444'} = '1548'; $kategori{'6444'} = 'G'; $poststed{'6444'} = 'FARSTAD';
$postkommune{'6445'} = '1548'; $kategori{'6445'} = 'G'; $poststed{'6445'} = 'MALMEFJORDEN';
$postkommune{'6447'} = '1548'; $kategori{'6447'} = 'P'; $poststed{'6447'} = 'ELNESVGEN';
$postkommune{'6450'} = '1502'; $kategori{'6450'} = 'G'; $poststed{'6450'} = 'HJELSET';
$postkommune{'6453'} = '1502'; $kategori{'6453'} = 'B'; $poststed{'6453'} = 'KLEIVE';
$postkommune{'6454'} = '1502'; $kategori{'6454'} = 'P'; $poststed{'6454'} = 'HJELSET';
$postkommune{'6455'} = '1502'; $kategori{'6455'} = 'G'; $poststed{'6455'} = 'KORTGARDEN';
$postkommune{'6456'} = '1502'; $kategori{'6456'} = 'B'; $poststed{'6456'} = 'SKLA';
$postkommune{'6457'} = '1502'; $kategori{'6457'} = 'G'; $poststed{'6457'} = 'BOLSYA';
$postkommune{'6460'} = '1543'; $kategori{'6460'} = 'B'; $poststed{'6460'} = 'EIDSVG I ROMSDAL';
$postkommune{'6462'} = '1543'; $kategori{'6462'} = 'G'; $poststed{'6462'} = 'RAUDSAND';
$postkommune{'6470'} = '1543'; $kategori{'6470'} = 'B'; $poststed{'6470'} = 'ERESFJORD';
$postkommune{'6472'} = '1543'; $kategori{'6472'} = 'B'; $poststed{'6472'} = 'EIKESDAL';
$postkommune{'6475'} = '1545'; $kategori{'6475'} = 'G'; $poststed{'6475'} = 'MIDSUND';
$postkommune{'6476'} = '1545'; $kategori{'6476'} = 'P'; $poststed{'6476'} = 'MIDSUND';
$postkommune{'6480'} = '1547'; $kategori{'6480'} = 'G'; $poststed{'6480'} = 'AUKRA';
$postkommune{'6481'} = '1547'; $kategori{'6481'} = 'P'; $poststed{'6481'} = 'AUKRA';
$postkommune{'6483'} = '1546'; $kategori{'6483'} = 'B'; $poststed{'6483'} = 'ONA';
$postkommune{'6484'} = '1546'; $kategori{'6484'} = 'G'; $poststed{'6484'} = 'SANDY';
$postkommune{'6486'} = '1546'; $kategori{'6486'} = 'B'; $poststed{'6486'} = 'ORTEN';
$postkommune{'6487'} = '1546'; $kategori{'6487'} = 'B'; $poststed{'6487'} = 'HARY';
$postkommune{'6488'} = '1546'; $kategori{'6488'} = 'G'; $poststed{'6488'} = 'MYKLEBOST';
$postkommune{'6490'} = '1551'; $kategori{'6490'} = 'G'; $poststed{'6490'} = 'EIDE';
$postkommune{'6493'} = '1551'; $kategori{'6493'} = 'G'; $poststed{'6493'} = 'LYNGSTAD';
$postkommune{'6494'} = '1551'; $kategori{'6494'} = 'G'; $poststed{'6494'} = 'VEVANG';
$postkommune{'6499'} = '1551'; $kategori{'6499'} = 'P'; $poststed{'6499'} = 'EIDE';
$postkommune{'6501'} = '1503'; $kategori{'6501'} = 'P'; $poststed{'6501'} = 'KRISTIANSUND N';
$postkommune{'6502'} = '1503'; $kategori{'6502'} = 'P'; $poststed{'6502'} = 'KRISTIANSUND N';
$postkommune{'6503'} = '1503'; $kategori{'6503'} = 'P'; $poststed{'6503'} = 'KRISTIANSUND N';
$postkommune{'6504'} = '1503'; $kategori{'6504'} = 'S'; $poststed{'6504'} = 'KRISTIANSUND N';
$postkommune{'6506'} = '1503'; $kategori{'6506'} = 'P'; $poststed{'6506'} = 'KRISTIANSUND N';
$postkommune{'6507'} = '1503'; $kategori{'6507'} = 'G'; $poststed{'6507'} = 'KRISTIANSUND N';
$postkommune{'6508'} = '1503'; $kategori{'6508'} = 'G'; $poststed{'6508'} = 'KRISTIANSUND N';
$postkommune{'6509'} = '1503'; $kategori{'6509'} = 'G'; $poststed{'6509'} = 'KRISTIANSUND N';
$postkommune{'6510'} = '1503'; $kategori{'6510'} = 'G'; $poststed{'6510'} = 'KRISTIANSUND N';
$postkommune{'6511'} = '1503'; $kategori{'6511'} = 'G'; $poststed{'6511'} = 'KRISTIANSUND N';
$postkommune{'6512'} = '1503'; $kategori{'6512'} = 'G'; $poststed{'6512'} = 'KRISTIANSUND N';
$postkommune{'6514'} = '1503'; $kategori{'6514'} = 'G'; $poststed{'6514'} = 'KRISTIANSUND N';
$postkommune{'6515'} = '1503'; $kategori{'6515'} = 'G'; $poststed{'6515'} = 'KRISTIANSUND N';
$postkommune{'6516'} = '1503'; $kategori{'6516'} = 'G'; $poststed{'6516'} = 'KRISTIANSUND N';
$postkommune{'6517'} = '1503'; $kategori{'6517'} = 'G'; $poststed{'6517'} = 'KRISTIANSUND N';
$postkommune{'6518'} = '1503'; $kategori{'6518'} = 'G'; $poststed{'6518'} = 'KRISTIANSUND N';
$postkommune{'6520'} = '1556'; $kategori{'6520'} = 'B'; $poststed{'6520'} = 'FREI';
$postkommune{'6523'} = '1556'; $kategori{'6523'} = 'B'; $poststed{'6523'} = 'FREI';
$postkommune{'6529'} = '1556'; $kategori{'6529'} = 'P'; $poststed{'6529'} = 'FREI';
$postkommune{'6530'} = '1554'; $kategori{'6530'} = 'B'; $poststed{'6530'} = 'AVERY';
$postkommune{'6538'} = '1554'; $kategori{'6538'} = 'P'; $poststed{'6538'} = 'AVERY';
$postkommune{'6539'} = '1554'; $kategori{'6539'} = 'P'; $poststed{'6539'} = 'AVERY';
$postkommune{'6570'} = '1573'; $kategori{'6570'} = 'G'; $poststed{'6570'} = 'SMLA';
$postkommune{'6571'} = '1573'; $kategori{'6571'} = 'P'; $poststed{'6571'} = 'SMLA';
$postkommune{'6590'} = '1576'; $kategori{'6590'} = 'B'; $poststed{'6590'} = 'TUSTNA';
$postkommune{'6600'} = '1563'; $kategori{'6600'} = 'G'; $poststed{'6600'} = 'SUNNDALSRA';
$postkommune{'6601'} = '1563'; $kategori{'6601'} = 'P'; $poststed{'6601'} = 'SUNNDALSRA';
$postkommune{'6610'} = '1563'; $kategori{'6610'} = 'G'; $poststed{'6610'} = 'KSENDAL';
$postkommune{'6611'} = '1563'; $kategori{'6611'} = 'G'; $poststed{'6611'} = 'FURUGRENDA';
$postkommune{'6612'} = '1563'; $kategori{'6612'} = 'G'; $poststed{'6612'} = 'GRA';
$postkommune{'6613'} = '1563'; $kategori{'6613'} = 'B'; $poststed{'6613'} = 'GJRA';
$postkommune{'6620'} = '1563'; $kategori{'6620'} = 'B'; $poststed{'6620'} = 'LVUNDEID';
$postkommune{'6622'} = '1563'; $kategori{'6622'} = 'B'; $poststed{'6622'} = 'LVUNDFJORD';
$postkommune{'6628'} = '1560'; $kategori{'6628'} = 'B'; $poststed{'6628'} = 'MEISINGSET';
$postkommune{'6629'} = '1560'; $kategori{'6629'} = 'G'; $poststed{'6629'} = 'TORJULVGEN';
$postkommune{'6630'} = '1560'; $kategori{'6630'} = 'B'; $poststed{'6630'} = 'TINGVOLL';
$postkommune{'6631'} = '1557'; $kategori{'6631'} = 'B'; $poststed{'6631'} = 'BATNFJORDSRA';
$postkommune{'6633'} = '1557'; $kategori{'6633'} = 'G'; $poststed{'6633'} = 'GJEMNES';
$postkommune{'6636'} = '1557'; $kategori{'6636'} = 'G'; $poststed{'6636'} = 'ANGVIK';
$postkommune{'6637'} = '1557'; $kategori{'6637'} = 'G'; $poststed{'6637'} = 'FLEMMA';
$postkommune{'6638'} = '1557'; $kategori{'6638'} = 'G'; $poststed{'6638'} = 'OSMARKA';
$postkommune{'6639'} = '1557'; $kategori{'6639'} = 'B'; $poststed{'6639'} = 'TORVIKBUKT';
$postkommune{'6640'} = '1566'; $kategori{'6640'} = 'G'; $poststed{'6640'} = 'KVANNE';
$postkommune{'6642'} = '1566'; $kategori{'6642'} = 'G'; $poststed{'6642'} = 'STANGVIK';
$postkommune{'6643'} = '1566'; $kategori{'6643'} = 'G'; $poststed{'6643'} = 'BFJORDEN';
$postkommune{'6644'} = '1566'; $kategori{'6644'} = 'B'; $poststed{'6644'} = 'BVERFJORD';
$postkommune{'6645'} = '1566'; $kategori{'6645'} = 'B'; $poststed{'6645'} = 'TODALEN';
$postkommune{'6650'} = '1566'; $kategori{'6650'} = 'G'; $poststed{'6650'} = 'SURNADAL';
$postkommune{'6652'} = '1566'; $kategori{'6652'} = 'G'; $poststed{'6652'} = 'SURNA';
$postkommune{'6653'} = '1566'; $kategori{'6653'} = 'G'; $poststed{'6653'} = 'VRE SURNADAL';
$postkommune{'6655'} = '1566'; $kategori{'6655'} = 'G'; $poststed{'6655'} = 'VINDLA';
$postkommune{'6656'} = '1566'; $kategori{'6656'} = 'P'; $poststed{'6656'} = 'SURNADAL';
$postkommune{'6657'} = '1567'; $kategori{'6657'} = 'G'; $poststed{'6657'} = 'RINDAL';
$postkommune{'6658'} = '1567'; $kategori{'6658'} = 'G'; $poststed{'6658'} = 'RINDALSSKOGEN';
$postkommune{'6659'} = '1567'; $kategori{'6659'} = 'P'; $poststed{'6659'} = 'RINDAL';
$postkommune{'6670'} = '1560'; $kategori{'6670'} = 'B'; $poststed{'6670'} = 'YDEGARD';
$postkommune{'6674'} = '1560'; $kategori{'6674'} = 'G'; $poststed{'6674'} = 'KVISVIK';
$postkommune{'6680'} = '1571'; $kategori{'6680'} = 'G'; $poststed{'6680'} = 'HALSANAUSTAN';
$postkommune{'6683'} = '1571'; $kategori{'6683'} = 'G'; $poststed{'6683'} = 'VGLAND';
$postkommune{'6686'} = '1571'; $kategori{'6686'} = 'G'; $poststed{'6686'} = 'VALSYBOTN';
$postkommune{'6687'} = '1571'; $kategori{'6687'} = 'G'; $poststed{'6687'} = 'VALSYFJORD';
$postkommune{'6688'} = '1571'; $kategori{'6688'} = 'P'; $poststed{'6688'} = 'VGLAND';
$postkommune{'6689'} = '1576'; $kategori{'6689'} = 'P'; $poststed{'6689'} = 'AURE';
$postkommune{'6690'} = '1576'; $kategori{'6690'} = 'G'; $poststed{'6690'} = 'AURE';
$postkommune{'6693'} = '1576'; $kategori{'6693'} = 'G'; $poststed{'6693'} = 'MJOSUNDET';
$postkommune{'6694'} = '1576'; $kategori{'6694'} = 'G'; $poststed{'6694'} = 'FOLDFJORDEN';
$postkommune{'6697'} = '1576'; $kategori{'6697'} = 'G'; $poststed{'6697'} = 'VIHALS';
$postkommune{'6698'} = '1576'; $kategori{'6698'} = 'G'; $poststed{'6698'} = 'LESUND';
$postkommune{'6699'} = '1576'; $kategori{'6699'} = 'G'; $poststed{'6699'} = 'KJRSVIKBUGEN';
$postkommune{'6700'} = '1439'; $kategori{'6700'} = 'G'; $poststed{'6700'} = 'MLY';
$postkommune{'6701'} = '1439'; $kategori{'6701'} = 'P'; $poststed{'6701'} = 'MLY';
$postkommune{'6702'} = '1439'; $kategori{'6702'} = 'P'; $poststed{'6702'} = 'MLY';
$postkommune{'6703'} = '1439'; $kategori{'6703'} = 'P'; $poststed{'6703'} = 'MLY';
$postkommune{'6704'} = '1439'; $kategori{'6704'} = 'P'; $poststed{'6704'} = 'DEKNEPOLLEN';
$postkommune{'6706'} = '1439'; $kategori{'6706'} = 'S'; $poststed{'6706'} = 'MLY';
$postkommune{'6707'} = '1439'; $kategori{'6707'} = 'P'; $poststed{'6707'} = 'RAUDEBERG';
$postkommune{'6708'} = '1439'; $kategori{'6708'} = 'P'; $poststed{'6708'} = 'BRYGGJA';
$postkommune{'6710'} = '1439'; $kategori{'6710'} = 'G'; $poststed{'6710'} = 'RAUDEBERG';
$postkommune{'6711'} = '1439'; $kategori{'6711'} = 'G'; $poststed{'6711'} = 'BRYGGJA';
$postkommune{'6713'} = '1439'; $kategori{'6713'} = 'G'; $poststed{'6713'} = 'ALMENNINGEN';
$postkommune{'6714'} = '1439'; $kategori{'6714'} = 'G'; $poststed{'6714'} = 'SILDA';
$postkommune{'6715'} = '1441'; $kategori{'6715'} = 'G'; $poststed{'6715'} = 'BARMEN';
$postkommune{'6716'} = '1439'; $kategori{'6716'} = 'G'; $poststed{'6716'} = 'HUSEVG';
$postkommune{'6717'} = '1441'; $kategori{'6717'} = 'G'; $poststed{'6717'} = 'FLATRAKET';
$postkommune{'6718'} = '1439'; $kategori{'6718'} = 'G'; $poststed{'6718'} = 'DEKNEPOLLEN';
$postkommune{'6719'} = '1438'; $kategori{'6719'} = 'G'; $poststed{'6719'} = 'SKATESTRAUMEN';
$postkommune{'6721'} = '1438'; $kategori{'6721'} = 'P'; $poststed{'6721'} = 'SVELGEN';
$postkommune{'6723'} = '1438'; $kategori{'6723'} = 'G'; $poststed{'6723'} = 'SVELGEN';
$postkommune{'6726'} = '1438'; $kategori{'6726'} = 'P'; $poststed{'6726'} = 'BREMANGER';
$postkommune{'6727'} = '1438'; $kategori{'6727'} = 'G'; $poststed{'6727'} = 'BREMANGER';
$postkommune{'6728'} = '1438'; $kategori{'6728'} = 'P'; $poststed{'6728'} = 'KALVG';
$postkommune{'6729'} = '1438'; $kategori{'6729'} = 'G'; $poststed{'6729'} = 'KALVG';
$postkommune{'6730'} = '1438'; $kategori{'6730'} = 'G'; $poststed{'6730'} = 'DAVIK';
$postkommune{'6731'} = '1438'; $kategori{'6731'} = 'P'; $poststed{'6731'} = 'DAVIK';
$postkommune{'6734'} = '1438'; $kategori{'6734'} = 'G'; $poststed{'6734'} = 'RUGSUND';
$postkommune{'6737'} = '1438'; $kategori{'6737'} = 'G'; $poststed{'6737'} = 'LFOTEN';
$postkommune{'6740'} = '1441'; $kategori{'6740'} = 'G'; $poststed{'6740'} = 'SELJE';
$postkommune{'6741'} = '1441'; $kategori{'6741'} = 'P'; $poststed{'6741'} = 'SELJE';
$postkommune{'6750'} = '1441'; $kategori{'6750'} = 'G'; $poststed{'6750'} = 'STADLANDET';
$postkommune{'6751'} = '1441'; $kategori{'6751'} = 'P'; $poststed{'6751'} = 'STADLANDET';
$postkommune{'6761'} = '1444'; $kategori{'6761'} = 'P'; $poststed{'6761'} = 'HORNINDAL';
$postkommune{'6763'} = '1444'; $kategori{'6763'} = 'G'; $poststed{'6763'} = 'HORNINDAL';
$postkommune{'6770'} = '1443'; $kategori{'6770'} = 'G'; $poststed{'6770'} = 'NORDFJORDEID';
$postkommune{'6771'} = '1443'; $kategori{'6771'} = 'P'; $poststed{'6771'} = 'NORDFJORDEID';
$postkommune{'6772'} = '1443'; $kategori{'6772'} = 'P'; $poststed{'6772'} = 'NORDFJORDEID';
$postkommune{'6776'} = '1443'; $kategori{'6776'} = 'G'; $poststed{'6776'} = 'KJLSDALEN';
$postkommune{'6777'} = '1443'; $kategori{'6777'} = 'G'; $poststed{'6777'} = 'STRHEIM';
$postkommune{'6778'} = '1443'; $kategori{'6778'} = 'G'; $poststed{'6778'} = 'LOTE';
$postkommune{'6779'} = '1443'; $kategori{'6779'} = 'G'; $poststed{'6779'} = 'HOLMYANE';
$postkommune{'6781'} = '1449'; $kategori{'6781'} = 'P'; $poststed{'6781'} = 'STRYN';
$postkommune{'6782'} = '1449'; $kategori{'6782'} = 'P'; $poststed{'6782'} = 'STRYN';
$postkommune{'6783'} = '1449'; $kategori{'6783'} = 'G'; $poststed{'6783'} = 'STRYN';
$postkommune{'6784'} = '1449'; $kategori{'6784'} = 'P'; $poststed{'6784'} = 'OLDEN';
$postkommune{'6788'} = '1449'; $kategori{'6788'} = 'G'; $poststed{'6788'} = 'OLDEN';
$postkommune{'6789'} = '1449'; $kategori{'6789'} = 'B'; $poststed{'6789'} = 'LOEN';
$postkommune{'6791'} = '1449'; $kategori{'6791'} = 'G'; $poststed{'6791'} = 'OLDEDALEN';
$postkommune{'6792'} = '1449'; $kategori{'6792'} = 'G'; $poststed{'6792'} = 'BRIKSDALSBRE';
$postkommune{'6793'} = '1449'; $kategori{'6793'} = 'B'; $poststed{'6793'} = 'INNVIK';
$postkommune{'6795'} = '1449'; $kategori{'6795'} = 'G'; $poststed{'6795'} = 'BLAKSTER';
$postkommune{'6796'} = '1449'; $kategori{'6796'} = 'G'; $poststed{'6796'} = 'HOPLAND';
$postkommune{'6797'} = '1449'; $kategori{'6797'} = 'G'; $poststed{'6797'} = 'UTVIK';
$postkommune{'6798'} = '1449'; $kategori{'6798'} = 'G'; $poststed{'6798'} = 'HJELLEDALEN';
$postkommune{'6799'} = '1449'; $kategori{'6799'} = 'G'; $poststed{'6799'} = 'OPPSTRYN';
$postkommune{'6800'} = '1432'; $kategori{'6800'} = 'B'; $poststed{'6800'} = 'FRDE';
$postkommune{'6801'} = '1432'; $kategori{'6801'} = 'P'; $poststed{'6801'} = 'FRDE';
$postkommune{'6802'} = '1432'; $kategori{'6802'} = 'P'; $poststed{'6802'} = 'FRDE';
$postkommune{'6803'} = '1432'; $kategori{'6803'} = 'P'; $poststed{'6803'} = 'FRDE';
$postkommune{'6804'} = '1432'; $kategori{'6804'} = 'P'; $poststed{'6804'} = 'FRDE';
$postkommune{'6805'} = '1432'; $kategori{'6805'} = 'P'; $poststed{'6805'} = 'FRDE';
$postkommune{'6806'} = '1433'; $kategori{'6806'} = 'P'; $poststed{'6806'} = 'NAUSTDAL';
$postkommune{'6807'} = '1432'; $kategori{'6807'} = 'S'; $poststed{'6807'} = 'FRDE';
$postkommune{'6816'} = '1433'; $kategori{'6816'} = 'P'; $poststed{'6816'} = 'NAUSTDAL';
$postkommune{'6817'} = '1433'; $kategori{'6817'} = 'G'; $poststed{'6817'} = 'NAUSTDAL';
$postkommune{'6818'} = '1432'; $kategori{'6818'} = 'G'; $poststed{'6818'} = 'HAUKEDALEN';
$postkommune{'6819'} = '1432'; $kategori{'6819'} = 'G'; $poststed{'6819'} = 'HOLSEN';
$postkommune{'6821'} = '1445'; $kategori{'6821'} = 'P'; $poststed{'6821'} = 'SANDANE';
$postkommune{'6822'} = '1445'; $kategori{'6822'} = 'P'; $poststed{'6822'} = 'SANDANE';
$postkommune{'6823'} = '1445'; $kategori{'6823'} = 'G'; $poststed{'6823'} = 'SANDANE';
$postkommune{'6826'} = '1445'; $kategori{'6826'} = 'B'; $poststed{'6826'} = 'BYRKJELO';
$postkommune{'6827'} = '1445'; $kategori{'6827'} = 'G'; $poststed{'6827'} = 'BREIM';
$postkommune{'6828'} = '1445'; $kategori{'6828'} = 'G'; $poststed{'6828'} = 'HESTENESYRA';
$postkommune{'6829'} = '1445'; $kategori{'6829'} = 'B'; $poststed{'6829'} = 'HYEN';
$postkommune{'6841'} = '1431'; $kategori{'6841'} = 'P'; $poststed{'6841'} = 'SKEI I JLSTER';
$postkommune{'6843'} = '1431'; $kategori{'6843'} = 'G'; $poststed{'6843'} = 'SKEI I JLSTER';
$postkommune{'6847'} = '1431'; $kategori{'6847'} = 'B'; $poststed{'6847'} = 'VASSENDEN';
$postkommune{'6848'} = '1420'; $kategori{'6848'} = 'B'; $poststed{'6848'} = 'FJRLAND';
$postkommune{'6851'} = '1420'; $kategori{'6851'} = 'P'; $poststed{'6851'} = 'SOGNDAL';
$postkommune{'6852'} = '1420'; $kategori{'6852'} = 'P'; $poststed{'6852'} = 'SOGNDAL';
$postkommune{'6853'} = '1420'; $kategori{'6853'} = 'P'; $poststed{'6853'} = 'SOGNDAL';
$postkommune{'6854'} = '1420'; $kategori{'6854'} = 'B'; $poststed{'6854'} = 'KAUPANGER';
$postkommune{'6855'} = '1422'; $kategori{'6855'} = 'G'; $poststed{'6855'} = 'FRNNINGEN';
$postkommune{'6856'} = '1420'; $kategori{'6856'} = 'G'; $poststed{'6856'} = 'SOGNDAL';
$postkommune{'6858'} = '1420'; $kategori{'6858'} = 'G'; $poststed{'6858'} = 'FARDAL';
$postkommune{'6859'} = '1420'; $kategori{'6859'} = 'G'; $poststed{'6859'} = 'SLINDE';
$postkommune{'6861'} = '1419'; $kategori{'6861'} = 'P'; $poststed{'6861'} = 'LEIKANGER';
$postkommune{'6863'} = '1419'; $kategori{'6863'} = 'G'; $poststed{'6863'} = 'LEIKANGER';
$postkommune{'6866'} = '1426'; $kategori{'6866'} = 'P'; $poststed{'6866'} = 'GAUPNE';
$postkommune{'6868'} = '1426'; $kategori{'6868'} = 'G'; $poststed{'6868'} = 'GAUPNE';
$postkommune{'6869'} = '1426'; $kategori{'6869'} = 'B'; $poststed{'6869'} = 'HAFSLO';
$postkommune{'6870'} = '1426'; $kategori{'6870'} = 'G'; $poststed{'6870'} = 'ORNES';
$postkommune{'6871'} = '1426'; $kategori{'6871'} = 'G'; $poststed{'6871'} = 'JOSTEDAL';
$postkommune{'6872'} = '1426'; $kategori{'6872'} = 'B'; $poststed{'6872'} = 'LUSTER';
$postkommune{'6873'} = '1426'; $kategori{'6873'} = 'G'; $poststed{'6873'} = 'MARIFJRA';
$postkommune{'6875'} = '1426'; $kategori{'6875'} = 'G'; $poststed{'6875'} = 'HYHEIMSVIK';
$postkommune{'6876'} = '1426'; $kategori{'6876'} = 'G'; $poststed{'6876'} = 'SKJOLDEN';
$postkommune{'6877'} = '1426'; $kategori{'6877'} = 'G'; $poststed{'6877'} = 'FORTUN';
$postkommune{'6878'} = '1426'; $kategori{'6878'} = 'G'; $poststed{'6878'} = 'VEITASTROND';
$postkommune{'6879'} = '1426'; $kategori{'6879'} = 'G'; $poststed{'6879'} = 'SOLVORN';
$postkommune{'6881'} = '1424'; $kategori{'6881'} = 'P'; $poststed{'6881'} = 'RDALSTANGEN';
$postkommune{'6882'} = '1424'; $kategori{'6882'} = 'P'; $poststed{'6882'} = 'VRE RDAL';
$postkommune{'6884'} = '1424'; $kategori{'6884'} = 'G'; $poststed{'6884'} = 'VRE RDAL';
$postkommune{'6885'} = '1424'; $kategori{'6885'} = 'G'; $poststed{'6885'} = 'RDALSTANGEN';
$postkommune{'6886'} = '1422'; $kategori{'6886'} = 'P'; $poststed{'6886'} = 'LRDAL';
$postkommune{'6887'} = '1422'; $kategori{'6887'} = 'G'; $poststed{'6887'} = 'LRDAL';
$postkommune{'6888'} = '1422'; $kategori{'6888'} = 'G'; $poststed{'6888'} = 'STEINKLEPP';
$postkommune{'6891'} = '1417'; $kategori{'6891'} = 'P'; $poststed{'6891'} = 'VIK I SOGN';
$postkommune{'6893'} = '1417'; $kategori{'6893'} = 'G'; $poststed{'6893'} = 'VIK I SOGN';
$postkommune{'6894'} = '1417'; $kategori{'6894'} = 'G'; $poststed{'6894'} = 'VANGSNES';
$postkommune{'6895'} = '1417'; $kategori{'6895'} = 'G'; $poststed{'6895'} = 'FEIOS';
$postkommune{'6896'} = '1417'; $kategori{'6896'} = 'G'; $poststed{'6896'} = 'FRESVIK';
$postkommune{'6898'} = '1418'; $kategori{'6898'} = 'P'; $poststed{'6898'} = 'BALESTRAND';
$postkommune{'6899'} = '1418'; $kategori{'6899'} = 'G'; $poststed{'6899'} = 'BALESTRAND';
$postkommune{'6900'} = '1401'; $kategori{'6900'} = 'G'; $poststed{'6900'} = 'FLOR';
$postkommune{'6901'} = '1401'; $kategori{'6901'} = 'P'; $poststed{'6901'} = 'FLOR';
$postkommune{'6902'} = '1401'; $kategori{'6902'} = 'P'; $poststed{'6902'} = 'FLOR';
$postkommune{'6903'} = '1401'; $kategori{'6903'} = 'P'; $poststed{'6903'} = 'FLOR';
$postkommune{'6909'} = '1401'; $kategori{'6909'} = 'P'; $poststed{'6909'} = 'FLOR';
$postkommune{'6912'} = '1401'; $kategori{'6912'} = 'G'; $poststed{'6912'} = 'KINN';
$postkommune{'6914'} = '1401'; $kategori{'6914'} = 'G'; $poststed{'6914'} = 'SVANYBUKT';
$postkommune{'6915'} = '1401'; $kategori{'6915'} = 'G'; $poststed{'6915'} = 'ROGNALDSVG';
$postkommune{'6916'} = '1401'; $kategori{'6916'} = 'G'; $poststed{'6916'} = 'BAREKSTAD';
$postkommune{'6917'} = '1401'; $kategori{'6917'} = 'G'; $poststed{'6917'} = 'BATALDEN';
$postkommune{'6918'} = '1401'; $kategori{'6918'} = 'G'; $poststed{'6918'} = 'SR-SKORPA';
$postkommune{'6919'} = '1401'; $kategori{'6919'} = 'G'; $poststed{'6919'} = 'TANSY';
$postkommune{'6921'} = '1412'; $kategori{'6921'} = 'P'; $poststed{'6921'} = 'HARDBAKKE';
$postkommune{'6924'} = '1412'; $kategori{'6924'} = 'G'; $poststed{'6924'} = 'HARDBAKKE';
$postkommune{'6926'} = '1412'; $kategori{'6926'} = 'G'; $poststed{'6926'} = 'KRAKHELLA';
$postkommune{'6927'} = '1412'; $kategori{'6927'} = 'G'; $poststed{'6927'} = 'YTRYGREND';
$postkommune{'6928'} = '1412'; $kategori{'6928'} = 'G'; $poststed{'6928'} = 'KOLGROV';
$postkommune{'6929'} = '1412'; $kategori{'6929'} = 'G'; $poststed{'6929'} = 'HERSVIKBYGDA';
$postkommune{'6939'} = '1401'; $kategori{'6939'} = 'P'; $poststed{'6939'} = 'STAVANG';
$postkommune{'6940'} = '1401'; $kategori{'6940'} = 'G'; $poststed{'6940'} = 'EIKEFJORD';
$postkommune{'6941'} = '1401'; $kategori{'6941'} = 'P'; $poststed{'6941'} = 'EIKEFJORD';
$postkommune{'6942'} = '1401'; $kategori{'6942'} = 'G'; $poststed{'6942'} = 'SVORTEVIK';
$postkommune{'6944'} = '1401'; $kategori{'6944'} = 'G'; $poststed{'6944'} = 'STAVANG';
$postkommune{'6946'} = '1416'; $kategori{'6946'} = 'P'; $poststed{'6946'} = 'LAVIK';
$postkommune{'6947'} = '1416'; $kategori{'6947'} = 'G'; $poststed{'6947'} = 'LAVIK';
$postkommune{'6951'} = '1413'; $kategori{'6951'} = 'P'; $poststed{'6951'} = 'LEIRVIK I SOGN';
$postkommune{'6953'} = '1413'; $kategori{'6953'} = 'G'; $poststed{'6953'} = 'LEIRVIK I SOGN';
$postkommune{'6957'} = '1413'; $kategori{'6957'} = 'G'; $poststed{'6957'} = 'HYLLESTAD';
$postkommune{'6958'} = '1413'; $kategori{'6958'} = 'B'; $poststed{'6958'} = 'SRBVG';
$postkommune{'6961'} = '1429'; $kategori{'6961'} = 'P'; $poststed{'6961'} = 'DALE I SUNNFJORD';
$postkommune{'6963'} = '1429'; $kategori{'6963'} = 'G'; $poststed{'6963'} = 'DALE I SUNNFJORD';
$postkommune{'6964'} = '1429'; $kategori{'6964'} = 'G'; $poststed{'6964'} = 'KORSSUND';
$postkommune{'6966'} = '1429'; $kategori{'6966'} = 'G'; $poststed{'6966'} = 'GUDDAL';
$postkommune{'6967'} = '1429'; $kategori{'6967'} = 'G'; $poststed{'6967'} = 'HELLEVIK I FJALER';
$postkommune{'6968'} = '1429'; $kategori{'6968'} = 'B'; $poststed{'6968'} = 'FLEKKE';
$postkommune{'6969'} = '1429'; $kategori{'6969'} = 'G'; $poststed{'6969'} = 'STRAUMSNES';
$postkommune{'6971'} = '1430'; $kategori{'6971'} = 'P'; $poststed{'6971'} = 'SANDE I SUNNFJORD';
$postkommune{'6973'} = '1430'; $kategori{'6973'} = 'G'; $poststed{'6973'} = 'SANDE I SUNNFJORD';
$postkommune{'6975'} = '1430'; $kategori{'6975'} = 'G'; $poststed{'6975'} = 'SKILBREI';
$postkommune{'6977'} = '1430'; $kategori{'6977'} = 'B'; $poststed{'6977'} = 'BYGSTAD';
$postkommune{'6978'} = '1430'; $kategori{'6978'} = 'G'; $poststed{'6978'} = 'VIKSDALEN';
$postkommune{'6980'} = '1428'; $kategori{'6980'} = 'G'; $poststed{'6980'} = 'ASKVOLL';
$postkommune{'6981'} = '1428'; $kategori{'6981'} = 'P'; $poststed{'6981'} = 'HOLMEDAL';
$postkommune{'6982'} = '1428'; $kategori{'6982'} = 'G'; $poststed{'6982'} = 'HOLMEDAL';
$postkommune{'6983'} = '1428'; $kategori{'6983'} = 'B'; $poststed{'6983'} = 'KVAMMEN';
$postkommune{'6984'} = '1428'; $kategori{'6984'} = 'G'; $poststed{'6984'} = 'STONGFJORDEN';
$postkommune{'6985'} = '1428'; $kategori{'6985'} = 'B'; $poststed{'6985'} = 'ATLY';
$postkommune{'6986'} = '1428'; $kategori{'6986'} = 'G'; $poststed{'6986'} = 'VRLANDET';
$postkommune{'6987'} = '1428'; $kategori{'6987'} = 'G'; $poststed{'6987'} = 'BULANDET';
$postkommune{'6988'} = '1428'; $kategori{'6988'} = 'P'; $poststed{'6988'} = 'ASKVOLL';
$postkommune{'6991'} = '1416'; $kategori{'6991'} = 'P'; $poststed{'6991'} = 'HYANGER';
$postkommune{'6993'} = '1416'; $kategori{'6993'} = 'G'; $poststed{'6993'} = 'HYANGER';
$postkommune{'6995'} = '1416'; $kategori{'6995'} = 'G'; $poststed{'6995'} = 'KYRKJEB';
$postkommune{'6996'} = '1416'; $kategori{'6996'} = 'B'; $poststed{'6996'} = 'VADHEIM';
$postkommune{'7003'} = '1601'; $kategori{'7003'} = 'K'; $poststed{'7003'} = 'TRONDHEIM';
$postkommune{'7004'} = '1601'; $kategori{'7004'} = 'S'; $poststed{'7004'} = 'TRONDHEIM';
$postkommune{'7005'} = '1601'; $kategori{'7005'} = 'S'; $poststed{'7005'} = 'TRONDHEIM';
$postkommune{'7006'} = '1601'; $kategori{'7006'} = 'K'; $poststed{'7006'} = 'TRONDHEIM';
$postkommune{'7007'} = '1601'; $kategori{'7007'} = 'K'; $poststed{'7007'} = 'TRONDHEIM';
$postkommune{'7010'} = '1601'; $kategori{'7010'} = 'G'; $poststed{'7010'} = 'TRONDHEIM';
$postkommune{'7011'} = '1601'; $kategori{'7011'} = 'G'; $poststed{'7011'} = 'TRONDHEIM';
$postkommune{'7012'} = '1601'; $kategori{'7012'} = 'G'; $poststed{'7012'} = 'TRONDHEIM';
$postkommune{'7013'} = '1601'; $kategori{'7013'} = 'G'; $poststed{'7013'} = 'TRONDHEIM';
$postkommune{'7014'} = '1601'; $kategori{'7014'} = 'B'; $poststed{'7014'} = 'TRONDHEIM';
$postkommune{'7015'} = '1601'; $kategori{'7015'} = 'G'; $poststed{'7015'} = 'TRONDHEIM';
$postkommune{'7016'} = '1601'; $kategori{'7016'} = 'G'; $poststed{'7016'} = 'TRONDHEIM';
$postkommune{'7018'} = '1601'; $kategori{'7018'} = 'B'; $poststed{'7018'} = 'TRONDHEIM';
$postkommune{'7019'} = '1601'; $kategori{'7019'} = 'G'; $poststed{'7019'} = 'TRONDHEIM';
$postkommune{'7020'} = '1601'; $kategori{'7020'} = 'G'; $poststed{'7020'} = 'TRONDHEIM';
$postkommune{'7021'} = '1601'; $kategori{'7021'} = 'G'; $poststed{'7021'} = 'TRONDHEIM';
$postkommune{'7022'} = '1601'; $kategori{'7022'} = 'G'; $poststed{'7022'} = 'TRONDHEIM';
$postkommune{'7023'} = '1601'; $kategori{'7023'} = 'G'; $poststed{'7023'} = 'TRONDHEIM';
$postkommune{'7024'} = '1601'; $kategori{'7024'} = 'G'; $poststed{'7024'} = 'TRONDHEIM';
$postkommune{'7025'} = '1601'; $kategori{'7025'} = 'B'; $poststed{'7025'} = 'TRONDHEIM';
$postkommune{'7026'} = '1601'; $kategori{'7026'} = 'G'; $poststed{'7026'} = 'TRONDHEIM';
$postkommune{'7027'} = '1601'; $kategori{'7027'} = 'G'; $poststed{'7027'} = 'TRONDHEIM';
$postkommune{'7028'} = '1601'; $kategori{'7028'} = 'G'; $poststed{'7028'} = 'TRONDHEIM';
$postkommune{'7029'} = '1601'; $kategori{'7029'} = 'G'; $poststed{'7029'} = 'TRONDHEIM';
$postkommune{'7030'} = '1601'; $kategori{'7030'} = 'G'; $poststed{'7030'} = 'TRONDHEIM';
$postkommune{'7031'} = '1601'; $kategori{'7031'} = 'B'; $poststed{'7031'} = 'TRONDHEIM';
$postkommune{'7032'} = '1601'; $kategori{'7032'} = 'G'; $poststed{'7032'} = 'TRONDHEIM';
$postkommune{'7033'} = '1601'; $kategori{'7033'} = 'G'; $poststed{'7033'} = 'TRONDHEIM';
$postkommune{'7034'} = '1601'; $kategori{'7034'} = 'G'; $poststed{'7034'} = 'TRONDHEIM';
$postkommune{'7036'} = '1601'; $kategori{'7036'} = 'B'; $poststed{'7036'} = 'TRONDHEIM';
$postkommune{'7037'} = '1601'; $kategori{'7037'} = 'B'; $poststed{'7037'} = 'TRONDHEIM';
$postkommune{'7038'} = '1601'; $kategori{'7038'} = 'G'; $poststed{'7038'} = 'TRONDHEIM';
$postkommune{'7039'} = '1601'; $kategori{'7039'} = 'B'; $poststed{'7039'} = 'TRONDHEIM';
$postkommune{'7040'} = '1601'; $kategori{'7040'} = 'G'; $poststed{'7040'} = 'TRONDHEIM';
$postkommune{'7041'} = '1601'; $kategori{'7041'} = 'G'; $poststed{'7041'} = 'TRONDHEIM';
$postkommune{'7042'} = '1601'; $kategori{'7042'} = 'G'; $poststed{'7042'} = 'TRONDHEIM';
$postkommune{'7043'} = '1601'; $kategori{'7043'} = 'G'; $poststed{'7043'} = 'TRONDHEIM';
$postkommune{'7044'} = '1601'; $kategori{'7044'} = 'G'; $poststed{'7044'} = 'TRONDHEIM';
$postkommune{'7045'} = '1601'; $kategori{'7045'} = 'B'; $poststed{'7045'} = 'TRONDHEIM';
$postkommune{'7046'} = '1601'; $kategori{'7046'} = 'G'; $poststed{'7046'} = 'TRONDHEIM';
$postkommune{'7047'} = '1601'; $kategori{'7047'} = 'G'; $poststed{'7047'} = 'TRONDHEIM';
$postkommune{'7048'} = '1601'; $kategori{'7048'} = 'G'; $poststed{'7048'} = 'TRONDHEIM';
$postkommune{'7049'} = '1601'; $kategori{'7049'} = 'G'; $poststed{'7049'} = 'TRONDHEIM';
$postkommune{'7050'} = '1601'; $kategori{'7050'} = 'G'; $poststed{'7050'} = 'TRONDHEIM';
$postkommune{'7051'} = '1601'; $kategori{'7051'} = 'B'; $poststed{'7051'} = 'TRONDHEIM';
$postkommune{'7052'} = '1601'; $kategori{'7052'} = 'B'; $poststed{'7052'} = 'TRONDHEIM';
$postkommune{'7053'} = '1601'; $kategori{'7053'} = 'G'; $poststed{'7053'} = 'RANHEIM';
$postkommune{'7054'} = '1601'; $kategori{'7054'} = 'G'; $poststed{'7054'} = 'RANHEIM';
$postkommune{'7056'} = '1601'; $kategori{'7056'} = 'G'; $poststed{'7056'} = 'RANHEIM';
$postkommune{'7057'} = '1601'; $kategori{'7057'} = 'G'; $poststed{'7057'} = 'JONSVATNET';
$postkommune{'7058'} = '1601'; $kategori{'7058'} = 'G'; $poststed{'7058'} = 'JAKOBSLI';
$postkommune{'7059'} = '1601'; $kategori{'7059'} = 'G'; $poststed{'7059'} = 'JAKOBSLI';
$postkommune{'7070'} = '1601'; $kategori{'7070'} = 'B'; $poststed{'7070'} = 'BOSBERG';
$postkommune{'7072'} = '1601'; $kategori{'7072'} = 'G'; $poststed{'7072'} = 'HEIMDAL';
$postkommune{'7074'} = '1601'; $kategori{'7074'} = 'B'; $poststed{'7074'} = 'SPONGDAL';
$postkommune{'7075'} = '1601'; $kategori{'7075'} = 'G'; $poststed{'7075'} = 'TILLER';
$postkommune{'7078'} = '1601'; $kategori{'7078'} = 'G'; $poststed{'7078'} = 'SAUPSTAD';
$postkommune{'7079'} = '1601'; $kategori{'7079'} = 'G'; $poststed{'7079'} = 'FLATSEN';
$postkommune{'7080'} = '1601'; $kategori{'7080'} = 'G'; $poststed{'7080'} = 'HEIMDAL';
$postkommune{'7081'} = '1601'; $kategori{'7081'} = 'B'; $poststed{'7081'} = 'SJETNEMARKA';
$postkommune{'7082'} = '1601'; $kategori{'7082'} = 'B'; $poststed{'7082'} = 'KATTEM';
$postkommune{'7083'} = '1601'; $kategori{'7083'} = 'B'; $poststed{'7083'} = 'LEINSTRAND';
$postkommune{'7088'} = '1601'; $kategori{'7088'} = 'G'; $poststed{'7088'} = 'HEIMDAL';
$postkommune{'7089'} = '1601'; $kategori{'7089'} = 'G'; $poststed{'7089'} = 'HEIMDAL';
$postkommune{'7091'} = '1601'; $kategori{'7091'} = 'B'; $poststed{'7091'} = 'TILLER';
$postkommune{'7092'} = '1601'; $kategori{'7092'} = 'G'; $poststed{'7092'} = 'TILLER';
$postkommune{'7097'} = '1601'; $kategori{'7097'} = 'G'; $poststed{'7097'} = 'SAUPSTAD';
$postkommune{'7098'} = '1601'; $kategori{'7098'} = 'G'; $poststed{'7098'} = 'SAUPSTAD';
$postkommune{'7099'} = '1601'; $kategori{'7099'} = 'G'; $poststed{'7099'} = 'FLATSEN';
$postkommune{'7100'} = '1624'; $kategori{'7100'} = 'G'; $poststed{'7100'} = 'RISSA';
$postkommune{'7101'} = '1624'; $kategori{'7101'} = 'P'; $poststed{'7101'} = 'RISSA';
$postkommune{'7105'} = '1624'; $kategori{'7105'} = 'G'; $poststed{'7105'} = 'STADSBYGD';
$postkommune{'7110'} = '1624'; $kategori{'7110'} = 'B'; $poststed{'7110'} = 'FEVG';
$postkommune{'7112'} = '1624'; $kategori{'7112'} = 'B'; $poststed{'7112'} = 'HASSELVIKA';
$postkommune{'7113'} = '1624'; $kategori{'7113'} = 'B'; $poststed{'7113'} = 'HUSBYSJEN';
$postkommune{'7114'} = '1624'; $kategori{'7114'} = 'B'; $poststed{'7114'} = 'RKVG';
$postkommune{'7119'} = '1624'; $kategori{'7119'} = 'P'; $poststed{'7119'} = 'STADSBYGD';
$postkommune{'7120'} = '1718'; $kategori{'7120'} = 'G'; $poststed{'7120'} = 'LEKSVIK';
$postkommune{'7121'} = '1718'; $kategori{'7121'} = 'P'; $poststed{'7121'} = 'LEKSVIK';
$postkommune{'7125'} = '1718'; $kategori{'7125'} = 'G'; $poststed{'7125'} = 'VANVIKAN';
$postkommune{'7126'} = '1718'; $kategori{'7126'} = 'P'; $poststed{'7126'} = 'VANVIKAN';
$postkommune{'7127'} = '1621'; $kategori{'7127'} = 'P'; $poststed{'7127'} = 'OPPHAUG';
$postkommune{'7128'} = '1621'; $kategori{'7128'} = 'P'; $poststed{'7128'} = 'UTHAUG';
$postkommune{'7129'} = '1621'; $kategori{'7129'} = 'P'; $poststed{'7129'} = 'BREKSTAD';
$postkommune{'7130'} = '1621'; $kategori{'7130'} = 'G'; $poststed{'7130'} = 'BREKSTAD';
$postkommune{'7140'} = '1621'; $kategori{'7140'} = 'G'; $poststed{'7140'} = 'OPPHAUG';
$postkommune{'7142'} = '1621'; $kategori{'7142'} = 'G'; $poststed{'7142'} = 'UTHAUG';
$postkommune{'7150'} = '1621'; $kategori{'7150'} = 'B'; $poststed{'7150'} = 'STORFOSNA';
$postkommune{'7152'} = '1621'; $kategori{'7152'} = 'G'; $poststed{'7152'} = 'KRKVG';
$postkommune{'7153'} = '1621'; $kategori{'7153'} = 'G'; $poststed{'7153'} = 'GARTEN';
$postkommune{'7156'} = '1622'; $kategori{'7156'} = 'G'; $poststed{'7156'} = 'LEKSA';
$postkommune{'7159'} = '1627'; $kategori{'7159'} = 'P'; $poststed{'7159'} = 'BJUGN';
$postkommune{'7160'} = '1627'; $kategori{'7160'} = 'G'; $poststed{'7160'} = 'BJUGN';
$postkommune{'7165'} = '1627'; $kategori{'7165'} = 'G'; $poststed{'7165'} = 'OKSVOLL';
$postkommune{'7166'} = '1627'; $kategori{'7166'} = 'G'; $poststed{'7166'} = 'TARVA';
$postkommune{'7167'} = '1627'; $kategori{'7167'} = 'G'; $poststed{'7167'} = 'VALLERSUND';
$postkommune{'7168'} = '1627'; $kategori{'7168'} = 'B'; $poststed{'7168'} = 'LYSYSUNDET';
$postkommune{'7169'} = '1630'; $kategori{'7169'} = 'P'; $poststed{'7169'} = 'FJORD';
$postkommune{'7170'} = '1630'; $kategori{'7170'} = 'B'; $poststed{'7170'} = 'FJORD';
$postkommune{'7176'} = '1630'; $kategori{'7176'} = 'G'; $poststed{'7176'} = 'LINESYA';
$postkommune{'7177'} = '1630'; $kategori{'7177'} = 'B'; $poststed{'7177'} = 'REVSNES';
$postkommune{'7178'} = '1630'; $kategori{'7178'} = 'B'; $poststed{'7178'} = 'STOKKY';
$postkommune{'7180'} = '1632'; $kategori{'7180'} = 'B'; $poststed{'7180'} = 'ROAN';
$postkommune{'7190'} = '1632'; $kategori{'7190'} = 'B'; $poststed{'7190'} = 'BESSAKER';
$postkommune{'7194'} = '1632'; $kategori{'7194'} = 'B'; $poststed{'7194'} = 'BRANDSFJORD';
$postkommune{'7200'} = '1612'; $kategori{'7200'} = 'G'; $poststed{'7200'} = 'KYRKSTERRA';
$postkommune{'7201'} = '1612'; $kategori{'7201'} = 'P'; $poststed{'7201'} = 'KYRKSTERRA';
$postkommune{'7203'} = '1612'; $kategori{'7203'} = 'G'; $poststed{'7203'} = 'VINJERA';
$postkommune{'7206'} = '1612'; $kategori{'7206'} = 'G'; $poststed{'7206'} = 'HELLANDSJEN';
$postkommune{'7211'} = '1653'; $kategori{'7211'} = 'P'; $poststed{'7211'} = 'KORSVEGEN';
$postkommune{'7212'} = '1653'; $kategori{'7212'} = 'G'; $poststed{'7212'} = 'KORSVEGEN';
$postkommune{'7213'} = '1653'; $kategori{'7213'} = 'G'; $poststed{'7213'} = 'GSBAKKEN';
$postkommune{'7221'} = '1653'; $kategori{'7221'} = 'P'; $poststed{'7221'} = 'MELHUS';
$postkommune{'7223'} = '1653'; $kategori{'7223'} = 'P'; $poststed{'7223'} = 'MELHUS';
$postkommune{'7224'} = '1653'; $kategori{'7224'} = 'G'; $poststed{'7224'} = 'MELHUS';
$postkommune{'7227'} = '1653'; $kategori{'7227'} = 'G'; $poststed{'7227'} = 'GIMSE';
$postkommune{'7228'} = '1653'; $kategori{'7228'} = 'G'; $poststed{'7228'} = 'KVL';
$postkommune{'7231'} = '1653'; $kategori{'7231'} = 'P'; $poststed{'7231'} = 'LUNDAMO';
$postkommune{'7232'} = '1653'; $kategori{'7232'} = 'G'; $poststed{'7232'} = 'LUNDAMO';
$postkommune{'7234'} = '1653'; $kategori{'7234'} = 'G'; $poststed{'7234'} = 'LER';
$postkommune{'7235'} = '1653'; $kategori{'7235'} = 'P'; $poststed{'7235'} = 'LER';
$postkommune{'7236'} = '1653'; $kategori{'7236'} = 'G'; $poststed{'7236'} = 'HOVIN I GAULDAL';
$postkommune{'7238'} = '1653'; $kategori{'7238'} = 'P'; $poststed{'7238'} = 'HOVIN I GAULDAL';
$postkommune{'7239'} = '1617'; $kategori{'7239'} = 'P'; $poststed{'7239'} = 'HITRA';
$postkommune{'7240'} = '1617'; $kategori{'7240'} = 'G'; $poststed{'7240'} = 'HITRA';
$postkommune{'7241'} = '1617'; $kategori{'7241'} = 'G'; $poststed{'7241'} = 'ANSNES';
$postkommune{'7242'} = '1617'; $kategori{'7242'} = 'B'; $poststed{'7242'} = 'KNARRLAGSUND';
$postkommune{'7243'} = '1617'; $kategori{'7243'} = 'B'; $poststed{'7243'} = 'KVENVR';
$postkommune{'7246'} = '1617'; $kategori{'7246'} = 'G'; $poststed{'7246'} = 'SANDSTAD';
$postkommune{'7247'} = '1617'; $kategori{'7247'} = 'G'; $poststed{'7247'} = 'HESTVIKA';
$postkommune{'7250'} = '1617'; $kategori{'7250'} = 'G'; $poststed{'7250'} = 'MELANDSJ';
$postkommune{'7252'} = '1617'; $kategori{'7252'} = 'G'; $poststed{'7252'} = 'DOLMY';
$postkommune{'7255'} = '1613'; $kategori{'7255'} = 'G'; $poststed{'7255'} = 'SUNDLANDET';
$postkommune{'7256'} = '1613'; $kategori{'7256'} = 'G'; $poststed{'7256'} = 'HEMNSKJELA';
$postkommune{'7257'} = '1613'; $kategori{'7257'} = 'G'; $poststed{'7257'} = 'SNILLFJORD';
$postkommune{'7259'} = '1613'; $kategori{'7259'} = 'P'; $poststed{'7259'} = 'SNILLFJORD';
$postkommune{'7260'} = '1620'; $kategori{'7260'} = 'G'; $poststed{'7260'} = 'SISTRANDA';
$postkommune{'7261'} = '1620'; $kategori{'7261'} = 'P'; $poststed{'7261'} = 'SISTRANDA';
$postkommune{'7263'} = '1620'; $kategori{'7263'} = 'G'; $poststed{'7263'} = 'HAMARVIK';
$postkommune{'7264'} = '1620'; $kategori{'7264'} = 'P'; $poststed{'7264'} = 'HAMARVIK';
$postkommune{'7266'} = '1620'; $kategori{'7266'} = 'G'; $poststed{'7266'} = 'KVERVA';
$postkommune{'7268'} = '1620'; $kategori{'7268'} = 'G'; $poststed{'7268'} = 'TITRAN';
$postkommune{'7270'} = '1620'; $kategori{'7270'} = 'G'; $poststed{'7270'} = 'DYRVIK';
$postkommune{'7273'} = '1620'; $kategori{'7273'} = 'B'; $poststed{'7273'} = 'NORDDYRY';
$postkommune{'7280'} = '1620'; $kategori{'7280'} = 'B'; $poststed{'7280'} = 'SULA';
$postkommune{'7282'} = '1620'; $kategori{'7282'} = 'G'; $poststed{'7282'} = 'BOGYVR';
$postkommune{'7284'} = '1620'; $kategori{'7284'} = 'B'; $poststed{'7284'} = 'MAUSUND';
$postkommune{'7285'} = '1620'; $kategori{'7285'} = 'G'; $poststed{'7285'} = 'GJSINGEN';
$postkommune{'7286'} = '1620'; $kategori{'7286'} = 'G'; $poststed{'7286'} = 'SRBURY';
$postkommune{'7287'} = '1620'; $kategori{'7287'} = 'G'; $poststed{'7287'} = 'SAUY';
$postkommune{'7288'} = '1648'; $kategori{'7288'} = 'G'; $poststed{'7288'} = 'SOKNEDAL';
$postkommune{'7289'} = '1648'; $kategori{'7289'} = 'P'; $poststed{'7289'} = 'SOKNEDAL';
$postkommune{'7290'} = '1648'; $kategori{'7290'} = 'G'; $poststed{'7290'} = 'STREN';
$postkommune{'7291'} = '1648'; $kategori{'7291'} = 'P'; $poststed{'7291'} = 'STREN';
$postkommune{'7295'} = '1648'; $kategori{'7295'} = 'G'; $poststed{'7295'} = 'ROGNES';
$postkommune{'7298'} = '1648'; $kategori{'7298'} = 'G'; $poststed{'7298'} = 'BUDALEN';
$postkommune{'7300'} = '1638'; $kategori{'7300'} = 'G'; $poststed{'7300'} = 'ORKANGER';
$postkommune{'7301'} = '1638'; $kategori{'7301'} = 'P'; $poststed{'7301'} = 'ORKANGER';
$postkommune{'7302'} = '1638'; $kategori{'7302'} = 'P'; $poststed{'7302'} = 'ORKANGER';
$postkommune{'7310'} = '1638'; $kategori{'7310'} = 'G'; $poststed{'7310'} = 'GJLME';
$postkommune{'7315'} = '1622'; $kategori{'7315'} = 'P'; $poststed{'7315'} = 'LENSVIK';
$postkommune{'7316'} = '1622'; $kategori{'7316'} = 'G'; $poststed{'7316'} = 'LENSVIK';
$postkommune{'7318'} = '1622'; $kategori{'7318'} = 'G'; $poststed{'7318'} = 'AGDENES';
$postkommune{'7319'} = '1622'; $kategori{'7319'} = 'P'; $poststed{'7319'} = 'AGDENES';
$postkommune{'7320'} = '1638'; $kategori{'7320'} = 'G'; $poststed{'7320'} = 'FANNREM';
$postkommune{'7321'} = '1638'; $kategori{'7321'} = 'P'; $poststed{'7321'} = 'FANNREM';
$postkommune{'7327'} = '1638'; $kategori{'7327'} = 'G'; $poststed{'7327'} = 'SVORKMO';
$postkommune{'7329'} = '1638'; $kategori{'7329'} = 'P'; $poststed{'7329'} = 'SVORKMO';
$postkommune{'7331'} = '1636'; $kategori{'7331'} = 'P'; $poststed{'7331'} = 'LKKEN VERK';
$postkommune{'7332'} = '1636'; $kategori{'7332'} = 'G'; $poststed{'7332'} = 'LKKEN VERK';
$postkommune{'7333'} = '1636'; $kategori{'7333'} = 'P'; $poststed{'7333'} = 'STORS';
$postkommune{'7334'} = '1636'; $kategori{'7334'} = 'G'; $poststed{'7334'} = 'STORS';
$postkommune{'7335'} = '1636'; $kategori{'7335'} = 'G'; $poststed{'7335'} = 'JERPSTAD';
$postkommune{'7336'} = '1636'; $kategori{'7336'} = 'G'; $poststed{'7336'} = 'MELDAL';
$postkommune{'7338'} = '1636'; $kategori{'7338'} = 'P'; $poststed{'7338'} = 'MELDAL';
$postkommune{'7340'} = '1634'; $kategori{'7340'} = 'G'; $poststed{'7340'} = 'OPPDAL';
$postkommune{'7341'} = '1634'; $kategori{'7341'} = 'P'; $poststed{'7341'} = 'OPPDAL';
$postkommune{'7342'} = '1634'; $kategori{'7342'} = 'G'; $poststed{'7342'} = 'LNSET';
$postkommune{'7343'} = '1634'; $kategori{'7343'} = 'G'; $poststed{'7343'} = 'VOGNILL';
$postkommune{'7345'} = '1634'; $kategori{'7345'} = 'G'; $poststed{'7345'} = 'DRIVA';
$postkommune{'7350'} = '1657'; $kategori{'7350'} = 'G'; $poststed{'7350'} = 'BUVIKA';
$postkommune{'7351'} = '1657'; $kategori{'7351'} = 'P'; $poststed{'7351'} = 'BUVIKA';
$postkommune{'7353'} = '1657'; $kategori{'7353'} = 'G'; $poststed{'7353'} = 'BRSA';
$postkommune{'7354'} = '1657'; $kategori{'7354'} = 'G'; $poststed{'7354'} = 'VIGGJA';
$postkommune{'7355'} = '1657'; $kategori{'7355'} = 'G'; $poststed{'7355'} = 'EGGKLEIVA';
$postkommune{'7357'} = '1657'; $kategori{'7357'} = 'B'; $poststed{'7357'} = 'SKAUN';
$postkommune{'7358'} = '1657'; $kategori{'7358'} = 'P'; $poststed{'7358'} = 'BRSA';
$postkommune{'7361'} = '1640'; $kategori{'7361'} = 'P'; $poststed{'7361'} = 'RROS';
$postkommune{'7366'} = '1640'; $kategori{'7366'} = 'S'; $poststed{'7366'} = 'RROS';
$postkommune{'7370'} = '1640'; $kategori{'7370'} = 'G'; $poststed{'7370'} = 'BREKKEBYGD';
$postkommune{'7372'} = '1640'; $kategori{'7372'} = 'G'; $poststed{'7372'} = 'GLMOS';
$postkommune{'7374'} = '1640'; $kategori{'7374'} = 'G'; $poststed{'7374'} = 'RROS';
$postkommune{'7380'} = '1644'; $kategori{'7380'} = 'G'; $poststed{'7380'} = 'LEN';
$postkommune{'7383'} = '1644'; $kategori{'7383'} = 'G'; $poststed{'7383'} = 'HALTDALEN';
$postkommune{'7384'} = '1644'; $kategori{'7384'} = 'P'; $poststed{'7384'} = 'LEN';
$postkommune{'7386'} = '1648'; $kategori{'7386'} = 'P'; $poststed{'7386'} = 'SINGSS';
$postkommune{'7387'} = '1648'; $kategori{'7387'} = 'B'; $poststed{'7387'} = 'SINGSS';
$postkommune{'7391'} = '1635'; $kategori{'7391'} = 'G'; $poststed{'7391'} = 'RENNEBU';
$postkommune{'7392'} = '1635'; $kategori{'7392'} = 'G'; $poststed{'7392'} = 'RENNEBU';
$postkommune{'7393'} = '1635'; $kategori{'7393'} = 'G'; $poststed{'7393'} = 'RENNEBU';
$postkommune{'7397'} = '1635'; $kategori{'7397'} = 'G'; $poststed{'7397'} = 'RENNEBU';
$postkommune{'7398'} = '1635'; $kategori{'7398'} = 'G'; $poststed{'7398'} = 'RENNEBU';
$postkommune{'7399'} = '1635'; $kategori{'7399'} = 'P'; $poststed{'7399'} = 'RENNEBU';
$postkommune{'7400'} = '1601'; $kategori{'7400'} = 'P'; $poststed{'7400'} = 'TRONDHEIM';
$postkommune{'7401'} = '1601'; $kategori{'7401'} = 'P'; $poststed{'7401'} = 'TRONDHEIM';
$postkommune{'7402'} = '1601'; $kategori{'7402'} = 'P'; $poststed{'7402'} = 'TRONDHEIM';
$postkommune{'7403'} = '1601'; $kategori{'7403'} = 'P'; $poststed{'7403'} = 'TRONDHEIM';
$postkommune{'7404'} = '1601'; $kategori{'7404'} = 'P'; $poststed{'7404'} = 'TRONDHEIM';
$postkommune{'7405'} = '1601'; $kategori{'7405'} = 'P'; $poststed{'7405'} = 'TRONDHEIM';
$postkommune{'7406'} = '1601'; $kategori{'7406'} = 'P'; $poststed{'7406'} = 'TRONDHEIM';
$postkommune{'7407'} = '1601'; $kategori{'7407'} = 'P'; $poststed{'7407'} = 'TRONDHEIM';
$postkommune{'7408'} = '1601'; $kategori{'7408'} = 'P'; $poststed{'7408'} = 'TRONDHEIM';
$postkommune{'7409'} = '1601'; $kategori{'7409'} = 'P'; $poststed{'7409'} = 'TRONDHEIM';
$postkommune{'7410'} = '1601'; $kategori{'7410'} = 'P'; $poststed{'7410'} = 'TRONDHEIM';
$postkommune{'7411'} = '1601'; $kategori{'7411'} = 'P'; $poststed{'7411'} = 'TRONDHEIM';
$postkommune{'7412'} = '1601'; $kategori{'7412'} = 'P'; $poststed{'7412'} = 'TRONDHEIM';
$postkommune{'7413'} = '1601'; $kategori{'7413'} = 'P'; $poststed{'7413'} = 'TRONDHEIM';
$postkommune{'7414'} = '1601'; $kategori{'7414'} = 'P'; $poststed{'7414'} = 'TRONDHEIM';
$postkommune{'7415'} = '1601'; $kategori{'7415'} = 'P'; $poststed{'7415'} = 'TRONDHEIM';
$postkommune{'7416'} = '1601'; $kategori{'7416'} = 'P'; $poststed{'7416'} = 'TRONDHEIM';
$postkommune{'7417'} = '1601'; $kategori{'7417'} = 'P'; $poststed{'7417'} = 'TRONDHEIM';
$postkommune{'7418'} = '1601'; $kategori{'7418'} = 'P'; $poststed{'7418'} = 'TRONDHEIM';
$postkommune{'7419'} = '1601'; $kategori{'7419'} = 'P'; $poststed{'7419'} = 'TRONDHEIM';
$postkommune{'7420'} = '1601'; $kategori{'7420'} = 'P'; $poststed{'7420'} = 'TRONDHEIM';
$postkommune{'7421'} = '1601'; $kategori{'7421'} = 'P'; $poststed{'7421'} = 'TRONDHEIM';
$postkommune{'7423'} = '1601'; $kategori{'7423'} = 'P'; $poststed{'7423'} = 'TRONDHEIM';
$postkommune{'7424'} = '1601'; $kategori{'7424'} = 'P'; $poststed{'7424'} = 'TRONDHEIM';
$postkommune{'7425'} = '1601'; $kategori{'7425'} = 'P'; $poststed{'7425'} = 'TRONDHEIM';
$postkommune{'7426'} = '1601'; $kategori{'7426'} = 'P'; $poststed{'7426'} = 'TRONDHEIM';
$postkommune{'7427'} = '1601'; $kategori{'7427'} = 'P'; $poststed{'7427'} = 'TRONDHEIM';
$postkommune{'7428'} = '1601'; $kategori{'7428'} = 'P'; $poststed{'7428'} = 'TRONDHEIM';
$postkommune{'7429'} = '1601'; $kategori{'7429'} = 'P'; $poststed{'7429'} = 'TRONDHEIM';
$postkommune{'7430'} = '1601'; $kategori{'7430'} = 'P'; $poststed{'7430'} = 'TRONDHEIM';
$postkommune{'7431'} = '1601'; $kategori{'7431'} = 'P'; $poststed{'7431'} = 'TRONDHEIM';
$postkommune{'7432'} = '1601'; $kategori{'7432'} = 'P'; $poststed{'7432'} = 'TRONDHEIM';
$postkommune{'7433'} = '1601'; $kategori{'7433'} = 'P'; $poststed{'7433'} = 'TRONDHEIM';
$postkommune{'7434'} = '1601'; $kategori{'7434'} = 'P'; $poststed{'7434'} = 'TRONDHEIM';
$postkommune{'7435'} = '1601'; $kategori{'7435'} = 'P'; $poststed{'7435'} = 'TRONDHEIM';
$postkommune{'7436'} = '1601'; $kategori{'7436'} = 'P'; $poststed{'7436'} = 'TRONDHEIM';
$postkommune{'7437'} = '1601'; $kategori{'7437'} = 'P'; $poststed{'7437'} = 'TRONDHEIM';
$postkommune{'7438'} = '1601'; $kategori{'7438'} = 'P'; $poststed{'7438'} = 'TRONDHEIM';
$postkommune{'7439'} = '1601'; $kategori{'7439'} = 'P'; $poststed{'7439'} = 'TRONDHEIM';
$postkommune{'7440'} = '1601'; $kategori{'7440'} = 'P'; $poststed{'7440'} = 'TRONDHEIM';
$postkommune{'7441'} = '1601'; $kategori{'7441'} = 'P'; $poststed{'7441'} = 'TRONDHEIM';
$postkommune{'7442'} = '1601'; $kategori{'7442'} = 'P'; $poststed{'7442'} = 'TRONDHEIM';
$postkommune{'7443'} = '1601'; $kategori{'7443'} = 'P'; $poststed{'7443'} = 'TRONDHEIM';
$postkommune{'7444'} = '1601'; $kategori{'7444'} = 'P'; $poststed{'7444'} = 'TRONDHEIM';
$postkommune{'7445'} = '1601'; $kategori{'7445'} = 'P'; $poststed{'7445'} = 'TRONDHEIM';
$postkommune{'7446'} = '1601'; $kategori{'7446'} = 'P'; $poststed{'7446'} = 'TRONDHEIM';
$postkommune{'7447'} = '1601'; $kategori{'7447'} = 'P'; $poststed{'7447'} = 'TRONDHEIM';
$postkommune{'7448'} = '1601'; $kategori{'7448'} = 'P'; $poststed{'7448'} = 'TRONDHEIM';
$postkommune{'7449'} = '1601'; $kategori{'7449'} = 'P'; $poststed{'7449'} = 'TRONDHEIM';
$postkommune{'7450'} = '1601'; $kategori{'7450'} = 'P'; $poststed{'7450'} = 'TRONDHEIM';
$postkommune{'7451'} = '1601'; $kategori{'7451'} = 'P'; $poststed{'7451'} = 'TRONDHEIM';
$postkommune{'7452'} = '1601'; $kategori{'7452'} = 'P'; $poststed{'7452'} = 'TRONDHEIM';
$postkommune{'7453'} = '1601'; $kategori{'7453'} = 'P'; $poststed{'7453'} = 'TRONDHEIM';
$postkommune{'7456'} = '1601'; $kategori{'7456'} = 'P'; $poststed{'7456'} = 'TRONDHEIM';
$postkommune{'7457'} = '1601'; $kategori{'7457'} = 'P'; $poststed{'7457'} = 'TRONDHEIM';
$postkommune{'7458'} = '1601'; $kategori{'7458'} = 'P'; $poststed{'7458'} = 'TRONDHEIM';
$postkommune{'7459'} = '1601'; $kategori{'7459'} = 'P'; $poststed{'7459'} = 'TRONDHEIM';
$postkommune{'7462'} = '1601'; $kategori{'7462'} = 'S'; $poststed{'7462'} = 'TRONDHEIM';
$postkommune{'7463'} = '1601'; $kategori{'7463'} = 'S'; $poststed{'7463'} = 'TRONDHEIM';
$postkommune{'7464'} = '1601'; $kategori{'7464'} = 'K'; $poststed{'7464'} = 'TRONDHEIM';
$postkommune{'7465'} = '1601'; $kategori{'7465'} = 'K'; $poststed{'7465'} = 'TRONDHEIM';
$postkommune{'7466'} = '1601'; $kategori{'7466'} = 'K'; $poststed{'7466'} = 'TRONDHEIM';
$postkommune{'7467'} = '1601'; $kategori{'7467'} = 'K'; $poststed{'7467'} = 'TRONDHEIM';
$postkommune{'7468'} = '1601'; $kategori{'7468'} = 'K'; $poststed{'7468'} = 'TRONDHEIM';
$postkommune{'7469'} = '1601'; $kategori{'7469'} = 'K'; $poststed{'7469'} = 'TRONDHEIM';
$postkommune{'7472'} = '1601'; $kategori{'7472'} = 'P'; $poststed{'7472'} = 'TRONDHEIM';
$postkommune{'7473'} = '1601'; $kategori{'7473'} = 'P'; $poststed{'7473'} = 'TRONDHEIM';
$postkommune{'7474'} = '1601'; $kategori{'7474'} = 'P'; $poststed{'7474'} = 'TRONDHEIM';
$postkommune{'7475'} = '1601'; $kategori{'7475'} = 'P'; $poststed{'7475'} = 'TRONDHEIM';
$postkommune{'7476'} = '1601'; $kategori{'7476'} = 'P'; $poststed{'7476'} = 'TRONDHEIM';
$postkommune{'7477'} = '1601'; $kategori{'7477'} = 'P'; $poststed{'7477'} = 'TRONDHEIM';
$postkommune{'7478'} = '1601'; $kategori{'7478'} = 'P'; $poststed{'7478'} = 'TRONDHEIM';
$postkommune{'7479'} = '1601'; $kategori{'7479'} = 'P'; $poststed{'7479'} = 'TRONDHEIM';
$postkommune{'7481'} = '1601'; $kategori{'7481'} = 'P'; $poststed{'7481'} = 'TRONDHEIM';
$postkommune{'7483'} = '1601'; $kategori{'7483'} = 'S'; $poststed{'7483'} = 'TRONDHEIM';
$postkommune{'7484'} = '1601'; $kategori{'7484'} = 'S'; $poststed{'7484'} = 'TRONDHEIM';
$postkommune{'7485'} = '1601'; $kategori{'7485'} = 'S'; $poststed{'7485'} = 'TRONDHEIM';
$postkommune{'7486'} = '1601'; $kategori{'7486'} = 'S'; $poststed{'7486'} = 'TRONDHEIM';
$postkommune{'7488'} = '1601'; $kategori{'7488'} = 'S'; $poststed{'7488'} = 'TRONDHEIM';
$postkommune{'7489'} = '1601'; $kategori{'7489'} = 'S'; $poststed{'7489'} = 'TRONDHEIM';
$postkommune{'7491'} = '1601'; $kategori{'7491'} = 'S'; $poststed{'7491'} = 'TRONDHEIM';
$postkommune{'7492'} = '1601'; $kategori{'7492'} = 'S'; $poststed{'7492'} = 'TRONDHEIM';
$postkommune{'7493'} = '1601'; $kategori{'7493'} = 'S'; $poststed{'7493'} = 'TRONDHEIM';
$postkommune{'7495'} = '1601'; $kategori{'7495'} = 'S'; $poststed{'7495'} = 'TRONDHEIM';
$postkommune{'7496'} = '1601'; $kategori{'7496'} = 'S'; $poststed{'7496'} = 'TRONDHEIM';
$postkommune{'7498'} = '1601'; $kategori{'7498'} = 'S'; $poststed{'7498'} = 'TRONDHEIM';
$postkommune{'7499'} = '1601'; $kategori{'7499'} = 'S'; $poststed{'7499'} = 'TRONDHEIM';
$postkommune{'7500'} = '1714'; $kategori{'7500'} = 'G'; $poststed{'7500'} = 'STJRDAL';
$postkommune{'7501'} = '1714'; $kategori{'7501'} = 'P'; $poststed{'7501'} = 'STJRDAL';
$postkommune{'7506'} = '1714'; $kategori{'7506'} = 'S'; $poststed{'7506'} = 'STJRDAL';
$postkommune{'7508'} = '1714'; $kategori{'7508'} = 'P'; $poststed{'7508'} = 'STJRDAL';
$postkommune{'7510'} = '1714'; $kategori{'7510'} = 'B'; $poststed{'7510'} = 'SKATVAL';
$postkommune{'7517'} = '1714'; $kategori{'7517'} = 'G'; $poststed{'7517'} = 'HELL';
$postkommune{'7519'} = '1714'; $kategori{'7519'} = 'G'; $poststed{'7519'} = 'ELVARLI';
$postkommune{'7520'} = '1714'; $kategori{'7520'} = 'G'; $poststed{'7520'} = 'HEGRA';
$postkommune{'7525'} = '1714'; $kategori{'7525'} = 'G'; $poststed{'7525'} = 'FLORNES';
$postkommune{'7529'} = '1714'; $kategori{'7529'} = 'P'; $poststed{'7529'} = 'HEGRA';
$postkommune{'7530'} = '1711'; $kategori{'7530'} = 'G'; $poststed{'7530'} = 'MERKER';
$postkommune{'7531'} = '1711'; $kategori{'7531'} = 'P'; $poststed{'7531'} = 'MERKER';
$postkommune{'7533'} = '1711'; $kategori{'7533'} = 'G'; $poststed{'7533'} = 'KOPPER';
$postkommune{'7540'} = '1662'; $kategori{'7540'} = 'G'; $poststed{'7540'} = 'KLBU';
$postkommune{'7541'} = '1662'; $kategori{'7541'} = 'P'; $poststed{'7541'} = 'KLBU';
$postkommune{'7549'} = '1662'; $kategori{'7549'} = 'G'; $poststed{'7549'} = 'TANEM';
$postkommune{'7550'} = '1663'; $kategori{'7550'} = 'G'; $poststed{'7550'} = 'HOMMELVIK';
$postkommune{'7551'} = '1663'; $kategori{'7551'} = 'P'; $poststed{'7551'} = 'HOMMELVIK';
$postkommune{'7560'} = '1663'; $kategori{'7560'} = 'G'; $poststed{'7560'} = 'VIKHAMMER';
$postkommune{'7562'} = '1663'; $kategori{'7562'} = 'G'; $poststed{'7562'} = 'HUNDHAMAREN';
$postkommune{'7563'} = '1663'; $kategori{'7563'} = 'G'; $poststed{'7563'} = 'MALVIK';
$postkommune{'7566'} = '1663'; $kategori{'7566'} = 'P'; $poststed{'7566'} = 'VIKHAMMER';
$postkommune{'7570'} = '1714'; $kategori{'7570'} = 'P'; $poststed{'7570'} = 'HELL';
$postkommune{'7580'} = '1664'; $kategori{'7580'} = 'G'; $poststed{'7580'} = 'SELBU';
$postkommune{'7581'} = '1664'; $kategori{'7581'} = 'P'; $poststed{'7581'} = 'SELBU';
$postkommune{'7583'} = '1664'; $kategori{'7583'} = 'P'; $poststed{'7583'} = 'SELBU';
$postkommune{'7584'} = '1664'; $kategori{'7584'} = 'G'; $poststed{'7584'} = 'SELBUSTRAND';
$postkommune{'7586'} = '1664'; $kategori{'7586'} = 'P'; $poststed{'7586'} = 'SELBUSTRAND';
$postkommune{'7590'} = '1665'; $kategori{'7590'} = 'G'; $poststed{'7590'} = 'TYDAL';
$postkommune{'7591'} = '1665'; $kategori{'7591'} = 'P'; $poststed{'7591'} = 'TYDAL';
$postkommune{'7596'} = '1664'; $kategori{'7596'} = 'G'; $poststed{'7596'} = 'FLAKNAN';
$postkommune{'7600'} = '1719'; $kategori{'7600'} = 'G'; $poststed{'7600'} = 'LEVANGER';
$postkommune{'7601'} = '1719'; $kategori{'7601'} = 'P'; $poststed{'7601'} = 'LEVANGER';
$postkommune{'7609'} = '1719'; $kategori{'7609'} = 'S'; $poststed{'7609'} = 'LEVANGER';
$postkommune{'7610'} = '1719'; $kategori{'7610'} = 'P'; $poststed{'7610'} = 'LEVANGER';
$postkommune{'7619'} = '1719'; $kategori{'7619'} = 'P'; $poststed{'7619'} = 'SKOGN';
$postkommune{'7620'} = '1719'; $kategori{'7620'} = 'G'; $poststed{'7620'} = 'SKOGN';
$postkommune{'7622'} = '1719'; $kategori{'7622'} = 'G'; $poststed{'7622'} = 'MARKABYGDA';
$postkommune{'7623'} = '1719'; $kategori{'7623'} = 'G'; $poststed{'7623'} = 'RONGLAN';
$postkommune{'7624'} = '1719'; $kategori{'7624'} = 'G'; $poststed{'7624'} = 'EKNE';
$postkommune{'7629'} = '1719'; $kategori{'7629'} = 'G'; $poststed{'7629'} = 'YTTERY';
$postkommune{'7630'} = '1719'; $kategori{'7630'} = 'G'; $poststed{'7630'} = 'SEN';
$postkommune{'7631'} = '1719'; $kategori{'7631'} = 'P'; $poststed{'7631'} = 'SEN';
$postkommune{'7632'} = '1719'; $kategori{'7632'} = 'G'; $poststed{'7632'} = 'SENFJORD';
$postkommune{'7633'} = '1717'; $kategori{'7633'} = 'G'; $poststed{'7633'} = 'FROSTA';
$postkommune{'7634'} = '1717'; $kategori{'7634'} = 'P'; $poststed{'7634'} = 'FROSTA';
$postkommune{'7650'} = '1721'; $kategori{'7650'} = 'G'; $poststed{'7650'} = 'VERDAL';
$postkommune{'7651'} = '1721'; $kategori{'7651'} = 'P'; $poststed{'7651'} = 'VERDAL';
$postkommune{'7658'} = '1721'; $kategori{'7658'} = 'P'; $poststed{'7658'} = 'VERDAL';
$postkommune{'7659'} = '1721'; $kategori{'7659'} = 'S'; $poststed{'7659'} = 'VERDAL';
$postkommune{'7660'} = '1721'; $kategori{'7660'} = 'B'; $poststed{'7660'} = 'VUKU';
$postkommune{'7663'} = '1721'; $kategori{'7663'} = 'G'; $poststed{'7663'} = 'STIKLESTAD';
$postkommune{'7670'} = '1729'; $kategori{'7670'} = 'G'; $poststed{'7670'} = 'INDERY';
$postkommune{'7671'} = '1729'; $kategori{'7671'} = 'P'; $poststed{'7671'} = 'INDERY';
$postkommune{'7690'} = '1723'; $kategori{'7690'} = 'B'; $poststed{'7690'} = 'MOSVIK';
$postkommune{'7701'} = '1702'; $kategori{'7701'} = 'P'; $poststed{'7701'} = 'STEINKJER';
$postkommune{'7702'} = '1702'; $kategori{'7702'} = 'P'; $poststed{'7702'} = 'STEINKJER';
$postkommune{'7703'} = '1702'; $kategori{'7703'} = 'P'; $poststed{'7703'} = 'STEINKJER';
$postkommune{'7704'} = '1702'; $kategori{'7704'} = 'P'; $poststed{'7704'} = 'STEINKJER';
$postkommune{'7705'} = '1702'; $kategori{'7705'} = 'P'; $poststed{'7705'} = 'STEINKJER';
$postkommune{'7707'} = '1702'; $kategori{'7707'} = 'P'; $poststed{'7707'} = 'STEINKJER';
$postkommune{'7708'} = '1702'; $kategori{'7708'} = 'P'; $poststed{'7708'} = 'STEINKJER';
$postkommune{'7709'} = '1702'; $kategori{'7709'} = 'P'; $poststed{'7709'} = 'STEINKJER';
$postkommune{'7710'} = '1702'; $kategori{'7710'} = 'B'; $poststed{'7710'} = 'SPARBU';
$postkommune{'7711'} = '1702'; $kategori{'7711'} = 'G'; $poststed{'7711'} = 'STEINKJER';
$postkommune{'7712'} = '1702'; $kategori{'7712'} = 'G'; $poststed{'7712'} = 'STEINKJER';
$postkommune{'7713'} = '1702'; $kategori{'7713'} = 'G'; $poststed{'7713'} = 'STEINKJER';
$postkommune{'7715'} = '1702'; $kategori{'7715'} = 'G'; $poststed{'7715'} = 'STEINKJER';
$postkommune{'7716'} = '1702'; $kategori{'7716'} = 'G'; $poststed{'7716'} = 'STEINKJER';
$postkommune{'7717'} = '1702'; $kategori{'7717'} = 'G'; $poststed{'7717'} = 'STEINKJER';
$postkommune{'7718'} = '1702'; $kategori{'7718'} = 'G'; $poststed{'7718'} = 'STEINKJER';
$postkommune{'7724'} = '1702'; $kategori{'7724'} = 'G'; $poststed{'7724'} = 'STEINKJER';
$postkommune{'7725'} = '1702'; $kategori{'7725'} = 'G'; $poststed{'7725'} = 'STEINKJER';
$postkommune{'7726'} = '1702'; $kategori{'7726'} = 'P'; $poststed{'7726'} = 'STEINKJER';
$postkommune{'7728'} = '1702'; $kategori{'7728'} = 'S'; $poststed{'7728'} = 'STEINKJER';
$postkommune{'7729'} = '1702'; $kategori{'7729'} = 'S'; $poststed{'7729'} = 'STEINKJER';
$postkommune{'7730'} = '1702'; $kategori{'7730'} = 'G'; $poststed{'7730'} = 'BEITSTAD';
$postkommune{'7732'} = '1702'; $kategori{'7732'} = 'G'; $poststed{'7732'} = 'STEINKJER';
$postkommune{'7734'} = '1702'; $kategori{'7734'} = 'K'; $poststed{'7734'} = 'STEINKJER';
$postkommune{'7735'} = '1702'; $kategori{'7735'} = 'K'; $poststed{'7735'} = 'STEINKJER';
$postkommune{'7736'} = '1702'; $kategori{'7736'} = 'K'; $poststed{'7736'} = 'STEINKJER';
$postkommune{'7737'} = '1702'; $kategori{'7737'} = 'K'; $poststed{'7737'} = 'STEINKJER';
$postkommune{'7738'} = '1702'; $kategori{'7738'} = 'K'; $poststed{'7738'} = 'STEINKJER';
$postkommune{'7739'} = '1702'; $kategori{'7739'} = 'P'; $poststed{'7739'} = 'BEITSTAD';
$postkommune{'7740'} = '1633'; $kategori{'7740'} = 'B'; $poststed{'7740'} = 'STEINSDALEN';
$postkommune{'7742'} = '1633'; $kategori{'7742'} = 'B'; $poststed{'7742'} = 'YTTERVG';
$postkommune{'7744'} = '1633'; $kategori{'7744'} = 'G'; $poststed{'7744'} = 'HEPSY';
$postkommune{'7745'} = '1749'; $kategori{'7745'} = 'G'; $poststed{'7745'} = 'OPPLAND';
$postkommune{'7746'} = '1749'; $kategori{'7746'} = 'G'; $poststed{'7746'} = 'HASVG';
$postkommune{'7748'} = '1633'; $kategori{'7748'} = 'B'; $poststed{'7748'} = 'STERVIK';
$postkommune{'7750'} = '1725'; $kategori{'7750'} = 'G'; $poststed{'7750'} = 'NAMDALSEID';
$postkommune{'7751'} = '1725'; $kategori{'7751'} = 'P'; $poststed{'7751'} = 'NAMDALSEID';
$postkommune{'7760'} = '1736'; $kategori{'7760'} = 'G'; $poststed{'7760'} = 'SNSA';
$postkommune{'7761'} = '1736'; $kategori{'7761'} = 'P'; $poststed{'7761'} = 'SNSA';
$postkommune{'7770'} = '1749'; $kategori{'7770'} = 'G'; $poststed{'7770'} = 'FLATANGER';
$postkommune{'7771'} = '1749'; $kategori{'7771'} = 'P'; $poststed{'7771'} = 'FLATANGER';
$postkommune{'7777'} = '1725'; $kategori{'7777'} = 'B'; $poststed{'7777'} = 'NORD-STATLAND';
$postkommune{'7790'} = '1724'; $kategori{'7790'} = 'G'; $poststed{'7790'} = 'MALM';
$postkommune{'7791'} = '1724'; $kategori{'7791'} = 'P'; $poststed{'7791'} = 'MALM';
$postkommune{'7796'} = '1724'; $kategori{'7796'} = 'B'; $poststed{'7796'} = 'FOLLAFOSS';
$postkommune{'7797'} = '1724'; $kategori{'7797'} = 'G'; $poststed{'7797'} = 'VERRABOTN';
$postkommune{'7800'} = '1703'; $kategori{'7800'} = 'G'; $poststed{'7800'} = 'NAMSOS';
$postkommune{'7801'} = '1703'; $kategori{'7801'} = 'P'; $poststed{'7801'} = 'NAMSOS';
$postkommune{'7808'} = '1703'; $kategori{'7808'} = 'P'; $poststed{'7808'} = 'NAMSOS';
$postkommune{'7809'} = '1703'; $kategori{'7809'} = 'S'; $poststed{'7809'} = 'NAMSOS';
$postkommune{'7817'} = '1748'; $kategori{'7817'} = 'G'; $poststed{'7817'} = 'SALSNES';
$postkommune{'7818'} = '1751'; $kategori{'7818'} = 'G'; $poststed{'7818'} = 'LUND';
$postkommune{'7819'} = '1703'; $kategori{'7819'} = 'G'; $poststed{'7819'} = 'FOSSLANDSOSEN';
$postkommune{'7820'} = '1703'; $kategori{'7820'} = 'B'; $poststed{'7820'} = 'SPILLUM';
$postkommune{'7822'} = '1703'; $kategori{'7822'} = 'B'; $poststed{'7822'} = 'BANGSUND';
$postkommune{'7856'} = '1748'; $kategori{'7856'} = 'G'; $poststed{'7856'} = 'JA';
$postkommune{'7860'} = '1744'; $kategori{'7860'} = 'G'; $poststed{'7860'} = 'SKAGE I NAMDALEN';
$postkommune{'7863'} = '1744'; $kategori{'7863'} = 'G'; $poststed{'7863'} = 'OVERHALLA';
$postkommune{'7864'} = '1744'; $kategori{'7864'} = 'P'; $poststed{'7864'} = 'OVERHALLA';
$postkommune{'7869'} = '1744'; $kategori{'7869'} = 'P'; $poststed{'7869'} = 'SKAGE I NAMDALEN';
$postkommune{'7870'} = '1742'; $kategori{'7870'} = 'G'; $poststed{'7870'} = 'GRONG';
$postkommune{'7871'} = '1742'; $kategori{'7871'} = 'P'; $poststed{'7871'} = 'GRONG';
$postkommune{'7873'} = '1742'; $kategori{'7873'} = 'B'; $poststed{'7873'} = 'HARRAN';
$postkommune{'7882'} = '1738'; $kategori{'7882'} = 'B'; $poststed{'7882'} = 'NORDLI';
$postkommune{'7884'} = '1738'; $kategori{'7884'} = 'B'; $poststed{'7884'} = 'SRLI';
$postkommune{'7890'} = '1740'; $kategori{'7890'} = 'B'; $poststed{'7890'} = 'NAMSSKOGAN';
$postkommune{'7892'} = '1740'; $kategori{'7892'} = 'B'; $poststed{'7892'} = 'TRONES';
$postkommune{'7893'} = '1740'; $kategori{'7893'} = 'G'; $poststed{'7893'} = 'SKOROVATN';
$postkommune{'7896'} = '1740'; $kategori{'7896'} = 'G'; $poststed{'7896'} = 'BREKKVASSELV';
$postkommune{'7898'} = '1739'; $kategori{'7898'} = 'B'; $poststed{'7898'} = 'LIMINGEN';
$postkommune{'7900'} = '1750'; $kategori{'7900'} = 'B'; $poststed{'7900'} = 'RRVIK';
$postkommune{'7901'} = '1750'; $kategori{'7901'} = 'P'; $poststed{'7901'} = 'RRVIK';
$postkommune{'7940'} = '1751'; $kategori{'7940'} = 'B'; $poststed{'7940'} = 'OTTERSY';
$postkommune{'7944'} = '1751'; $kategori{'7944'} = 'G'; $poststed{'7944'} = 'INDRE NRY';
$postkommune{'7950'} = '1751'; $kategori{'7950'} = 'G'; $poststed{'7950'} = 'ABELVR';
$postkommune{'7960'} = '1751'; $kategori{'7960'} = 'G'; $poststed{'7960'} = 'SALSBRUKET';
$postkommune{'7970'} = '1751'; $kategori{'7970'} = 'G'; $poststed{'7970'} = 'KOLVEREID';
$postkommune{'7971'} = '1751'; $kategori{'7971'} = 'P'; $poststed{'7971'} = 'KOLVEREID';
$postkommune{'7973'} = '1751'; $kategori{'7973'} = 'G'; $poststed{'7973'} = 'GJERDINGA';
$postkommune{'7976'} = '1743'; $kategori{'7976'} = 'G'; $poststed{'7976'} = 'KONGSMOEN';
$postkommune{'7977'} = '1743'; $kategori{'7977'} = 'B'; $poststed{'7977'} = 'HYLANDET';
$postkommune{'7980'} = '1811'; $kategori{'7980'} = 'B'; $poststed{'7980'} = 'TERRK';
$postkommune{'7981'} = '1811'; $kategori{'7981'} = 'G'; $poststed{'7981'} = 'HARANGSFJORD';
$postkommune{'7982'} = '1811'; $kategori{'7982'} = 'B'; $poststed{'7982'} = 'BINDALSEIDET';
$postkommune{'7985'} = '1751'; $kategori{'7985'} = 'B'; $poststed{'7985'} = 'FOLDEREID';
$postkommune{'7990'} = '1751'; $kategori{'7990'} = 'G'; $poststed{'7990'} = 'NAUSTBUKTA';
$postkommune{'7993'} = '1755'; $kategori{'7993'} = 'G'; $poststed{'7993'} = 'GUTVIK';
$postkommune{'7994'} = '1755'; $kategori{'7994'} = 'B'; $poststed{'7994'} = 'LEKA';
$postkommune{'8001'} = '1804'; $kategori{'8001'} = 'P'; $poststed{'8001'} = 'BOD';
$postkommune{'8002'} = '1804'; $kategori{'8002'} = 'S'; $poststed{'8002'} = 'BOD';
$postkommune{'8003'} = '1804'; $kategori{'8003'} = 'G'; $poststed{'8003'} = 'BOD';
$postkommune{'8004'} = '1804'; $kategori{'8004'} = 'G'; $poststed{'8004'} = 'BOD';
$postkommune{'8005'} = '1804'; $kategori{'8005'} = 'G'; $poststed{'8005'} = 'BOD';
$postkommune{'8006'} = '1804'; $kategori{'8006'} = 'G'; $poststed{'8006'} = 'BOD';
$postkommune{'8007'} = '1804'; $kategori{'8007'} = 'G'; $poststed{'8007'} = 'BOD';
$postkommune{'8008'} = '1804'; $kategori{'8008'} = 'G'; $poststed{'8008'} = 'BOD';
$postkommune{'8009'} = '1804'; $kategori{'8009'} = 'G'; $poststed{'8009'} = 'BOD';
$postkommune{'8010'} = '1804'; $kategori{'8010'} = 'G'; $poststed{'8010'} = 'BOD';
$postkommune{'8011'} = '1804'; $kategori{'8011'} = 'G'; $poststed{'8011'} = 'BOD';
$postkommune{'8012'} = '1804'; $kategori{'8012'} = 'G'; $poststed{'8012'} = 'BOD';
$postkommune{'8013'} = '1804'; $kategori{'8013'} = 'G'; $poststed{'8013'} = 'BOD';
$postkommune{'8014'} = '1804'; $kategori{'8014'} = 'G'; $poststed{'8014'} = 'BOD';
$postkommune{'8015'} = '1804'; $kategori{'8015'} = 'G'; $poststed{'8015'} = 'BOD';
$postkommune{'8016'} = '1804'; $kategori{'8016'} = 'G'; $poststed{'8016'} = 'BOD';
$postkommune{'8019'} = '1804'; $kategori{'8019'} = 'G'; $poststed{'8019'} = 'BOD';
$postkommune{'8020'} = '1804'; $kategori{'8020'} = 'G'; $poststed{'8020'} = 'BOD';
$postkommune{'8021'} = '1804'; $kategori{'8021'} = 'G'; $poststed{'8021'} = 'BOD';
$postkommune{'8022'} = '1804'; $kategori{'8022'} = 'G'; $poststed{'8022'} = 'BOD';
$postkommune{'8023'} = '1804'; $kategori{'8023'} = 'G'; $poststed{'8023'} = 'BOD';
$postkommune{'8026'} = '1804'; $kategori{'8026'} = 'G'; $poststed{'8026'} = 'BOD';
$postkommune{'8027'} = '1804'; $kategori{'8027'} = 'G'; $poststed{'8027'} = 'BOD';
$postkommune{'8028'} = '1804'; $kategori{'8028'} = 'G'; $poststed{'8028'} = 'BOD';
$postkommune{'8029'} = '1804'; $kategori{'8029'} = 'G'; $poststed{'8029'} = 'BOD';
$postkommune{'8030'} = '1804'; $kategori{'8030'} = 'G'; $poststed{'8030'} = 'BOD';
$postkommune{'8031'} = '1804'; $kategori{'8031'} = 'P'; $poststed{'8031'} = 'BOD';
$postkommune{'8032'} = '1804'; $kategori{'8032'} = 'P'; $poststed{'8032'} = 'BOD';
$postkommune{'8037'} = '1804'; $kategori{'8037'} = 'S'; $poststed{'8037'} = 'BOD';
$postkommune{'8038'} = '1804'; $kategori{'8038'} = 'S'; $poststed{'8038'} = 'BOD';
$postkommune{'8039'} = '1804'; $kategori{'8039'} = 'S'; $poststed{'8039'} = 'BOD';
$postkommune{'8041'} = '1804'; $kategori{'8041'} = 'S'; $poststed{'8041'} = 'BOD';
$postkommune{'8047'} = '1804'; $kategori{'8047'} = 'K'; $poststed{'8047'} = 'BOD';
$postkommune{'8048'} = '1804'; $kategori{'8048'} = 'K'; $poststed{'8048'} = 'BOD';
$postkommune{'8049'} = '1804'; $kategori{'8049'} = 'K'; $poststed{'8049'} = 'BOD';
$postkommune{'8050'} = '1804'; $kategori{'8050'} = 'G'; $poststed{'8050'} = 'TVERLANDET';
$postkommune{'8056'} = '1804'; $kategori{'8056'} = 'B'; $poststed{'8056'} = 'SALTSTRAUMEN';
$postkommune{'8058'} = '1804'; $kategori{'8058'} = 'P'; $poststed{'8058'} = 'TVERLANDET';
$postkommune{'8063'} = '1857'; $kategori{'8063'} = 'B'; $poststed{'8063'} = 'VRY';
$postkommune{'8064'} = '1856'; $kategori{'8064'} = 'B'; $poststed{'8064'} = 'RST';
$postkommune{'8070'} = '1804'; $kategori{'8070'} = 'G'; $poststed{'8070'} = 'BOD';
$postkommune{'8071'} = '1804'; $kategori{'8071'} = 'G'; $poststed{'8071'} = 'BOD';
$postkommune{'8072'} = '1804'; $kategori{'8072'} = 'G'; $poststed{'8072'} = 'BOD';
$postkommune{'8073'} = '1804'; $kategori{'8073'} = 'G'; $poststed{'8073'} = 'BOD';
$postkommune{'8074'} = '1804'; $kategori{'8074'} = 'G'; $poststed{'8074'} = 'BOD';
$postkommune{'8075'} = '1804'; $kategori{'8075'} = 'G'; $poststed{'8075'} = 'BOD';
$postkommune{'8076'} = '1804'; $kategori{'8076'} = 'G'; $poststed{'8076'} = 'BOD';
$postkommune{'8079'} = '1804'; $kategori{'8079'} = 'G'; $poststed{'8079'} = 'BOD';
$postkommune{'8084'} = '1804'; $kategori{'8084'} = 'P'; $poststed{'8084'} = 'BOD';
$postkommune{'8086'} = '1804'; $kategori{'8086'} = 'P'; $poststed{'8086'} = 'BOD';
$postkommune{'8087'} = '1804'; $kategori{'8087'} = 'P'; $poststed{'8087'} = 'BOD';
$postkommune{'8088'} = '1804'; $kategori{'8088'} = 'P'; $poststed{'8088'} = 'BOD';
$postkommune{'8089'} = '1804'; $kategori{'8089'} = 'P'; $poststed{'8089'} = 'BOD';
$postkommune{'8091'} = '1804'; $kategori{'8091'} = 'P'; $poststed{'8091'} = 'BOD';
$postkommune{'8092'} = '1804'; $kategori{'8092'} = 'P'; $poststed{'8092'} = 'BOD';
$postkommune{'8093'} = '1804'; $kategori{'8093'} = 'B'; $poststed{'8093'} = 'KJERRINGY';
$postkommune{'8094'} = '1838'; $kategori{'8094'} = 'B'; $poststed{'8094'} = 'FLEINVR';
$postkommune{'8095'} = '1804'; $kategori{'8095'} = 'B'; $poststed{'8095'} = 'HELLIGVR';
$postkommune{'8096'} = '1804'; $kategori{'8096'} = 'G'; $poststed{'8096'} = 'BLIKSVR';
$postkommune{'8097'} = '1804'; $kategori{'8097'} = 'G'; $poststed{'8097'} = 'GIVR';
$postkommune{'8098'} = '1804'; $kategori{'8098'} = 'G'; $poststed{'8098'} = 'LANDEGODE';
$postkommune{'8099'} = '2211'; $kategori{'8099'} = 'G'; $poststed{'8099'} = 'JAN MAYEN';
$postkommune{'8100'} = '1804'; $kategori{'8100'} = 'G'; $poststed{'8100'} = 'MISVR';
$postkommune{'8102'} = '1804'; $kategori{'8102'} = 'G'; $poststed{'8102'} = 'SKJERSTAD';
$postkommune{'8103'} = '1804'; $kategori{'8103'} = 'G'; $poststed{'8103'} = 'BREIVIK I SALTEN';
$postkommune{'8108'} = '1804'; $kategori{'8108'} = 'P'; $poststed{'8108'} = 'MISVR';
$postkommune{'8110'} = '1839'; $kategori{'8110'} = 'G'; $poststed{'8110'} = 'MOLDJORD';
$postkommune{'8114'} = '1839'; $kategori{'8114'} = 'G'; $poststed{'8114'} = 'TOLL';
$postkommune{'8118'} = '1839'; $kategori{'8118'} = 'P'; $poststed{'8118'} = 'MOLDJORD';
$postkommune{'8120'} = '1838'; $kategori{'8120'} = 'G'; $poststed{'8120'} = 'NYGRDSJEN';
$postkommune{'8128'} = '1839'; $kategori{'8128'} = 'G'; $poststed{'8128'} = 'YTRE BEIARN';
$postkommune{'8130'} = '1838'; $kategori{'8130'} = 'G'; $poststed{'8130'} = 'SANDHORNY';
$postkommune{'8135'} = '1838'; $kategori{'8135'} = 'B'; $poststed{'8135'} = 'SRARNY';
$postkommune{'8136'} = '1838'; $kategori{'8136'} = 'G'; $poststed{'8136'} = 'NORDARNY';
$postkommune{'8138'} = '1838'; $kategori{'8138'} = 'P'; $poststed{'8138'} = 'INNDYR';
$postkommune{'8140'} = '1838'; $kategori{'8140'} = 'G'; $poststed{'8140'} = 'INNDYR';
$postkommune{'8145'} = '1838'; $kategori{'8145'} = 'G'; $poststed{'8145'} = 'STORVIK';
$postkommune{'8146'} = '1837'; $kategori{'8146'} = 'G'; $poststed{'8146'} = 'REIP';
$postkommune{'8149'} = '1837'; $kategori{'8149'} = 'G'; $poststed{'8149'} = 'NEVERDAL';
$postkommune{'8150'} = '1837'; $kategori{'8150'} = 'G'; $poststed{'8150'} = 'RNES';
$postkommune{'8151'} = '1837'; $kategori{'8151'} = 'P'; $poststed{'8151'} = 'RNES';
$postkommune{'8157'} = '1837'; $kategori{'8157'} = 'G'; $poststed{'8157'} = 'MELY';
$postkommune{'8158'} = '1837'; $kategori{'8158'} = 'B'; $poststed{'8158'} = 'BOLGA';
$postkommune{'8159'} = '1837'; $kategori{'8159'} = 'B'; $poststed{'8159'} = 'STTT';
$postkommune{'8160'} = '1837'; $kategori{'8160'} = 'G'; $poststed{'8160'} = 'GLOMFJORD';
$postkommune{'8161'} = '1837'; $kategori{'8161'} = 'P'; $poststed{'8161'} = 'GLOMFJORD';
$postkommune{'8168'} = '1837'; $kategori{'8168'} = 'P'; $poststed{'8168'} = 'ENGAVGEN';
$postkommune{'8170'} = '1837'; $kategori{'8170'} = 'G'; $poststed{'8170'} = 'ENGAVGEN';
$postkommune{'8171'} = '1837'; $kategori{'8171'} = 'G'; $poststed{'8171'} = 'SVARTISEN GRD';
$postkommune{'8178'} = '1837'; $kategori{'8178'} = 'B'; $poststed{'8178'} = 'HALSA';
$postkommune{'8181'} = '1836'; $kategori{'8181'} = 'B'; $poststed{'8181'} = 'MYKEN';
$postkommune{'8182'} = '1836'; $kategori{'8182'} = 'G'; $poststed{'8182'} = 'MELFJORDBOTN';
$postkommune{'8184'} = '1837'; $kategori{'8184'} = 'G'; $poststed{'8184'} = 'GSKARDET';
$postkommune{'8185'} = '1836'; $kategori{'8185'} = 'B'; $poststed{'8185'} = 'VGAHOLMEN';
$postkommune{'8186'} = '1836'; $kategori{'8186'} = 'G'; $poststed{'8186'} = 'TJONGSFJORDEN';
$postkommune{'8187'} = '1836'; $kategori{'8187'} = 'B'; $poststed{'8187'} = 'JEKTVIK';
$postkommune{'8188'} = '1836'; $kategori{'8188'} = 'G'; $poststed{'8188'} = 'NORDVERNES';
$postkommune{'8189'} = '1836'; $kategori{'8189'} = 'G'; $poststed{'8189'} = 'GJERSVIKGRENDA';
$postkommune{'8190'} = '1836'; $kategori{'8190'} = 'B'; $poststed{'8190'} = 'SRFJORDEN';
$postkommune{'8193'} = '1836'; $kategori{'8193'} = 'B'; $poststed{'8193'} = 'RDY';
$postkommune{'8195'} = '1836'; $kategori{'8195'} = 'B'; $poststed{'8195'} = 'GJERY';
$postkommune{'8196'} = '1836'; $kategori{'8196'} = 'B'; $poststed{'8196'} = 'SELSYVIK';
$postkommune{'8197'} = '1836'; $kategori{'8197'} = 'G'; $poststed{'8197'} = 'STORSELSY';
$postkommune{'8198'} = '1836'; $kategori{'8198'} = 'G'; $poststed{'8198'} = 'NORDNESY';
$postkommune{'8200'} = '1841'; $kategori{'8200'} = 'G'; $poststed{'8200'} = 'FAUSKE';
$postkommune{'8201'} = '1841'; $kategori{'8201'} = 'P'; $poststed{'8201'} = 'FAUSKE';
$postkommune{'8202'} = '1841'; $kategori{'8202'} = 'P'; $poststed{'8202'} = 'FAUSKE';
$postkommune{'8205'} = '1841'; $kategori{'8205'} = 'S'; $poststed{'8205'} = 'FAUSKE';
$postkommune{'8210'} = '1841'; $kategori{'8210'} = 'G'; $poststed{'8210'} = 'FAUSKE';
$postkommune{'8215'} = '1841'; $kategori{'8215'} = 'G'; $poststed{'8215'} = 'VALNESFJORD';
$postkommune{'8220'} = '1845'; $kategori{'8220'} = 'G'; $poststed{'8220'} = 'RSVIK';
$postkommune{'8226'} = '1845'; $kategori{'8226'} = 'G'; $poststed{'8226'} = 'STRAUMEN';
$postkommune{'8230'} = '1841'; $kategori{'8230'} = 'G'; $poststed{'8230'} = 'SULITJELMA';
$postkommune{'8231'} = '1841'; $kategori{'8231'} = 'P'; $poststed{'8231'} = 'SULITJELMA';
$postkommune{'8232'} = '1845'; $kategori{'8232'} = 'P'; $poststed{'8232'} = 'STRAUMEN';
$postkommune{'8233'} = '1841'; $kategori{'8233'} = 'P'; $poststed{'8233'} = 'VALNESFJORD';
$postkommune{'8250'} = '1840'; $kategori{'8250'} = 'G'; $poststed{'8250'} = 'ROGNAN';
$postkommune{'8251'} = '1840'; $kategori{'8251'} = 'P'; $poststed{'8251'} = 'ROGNAN';
$postkommune{'8255'} = '1840'; $kategori{'8255'} = 'G'; $poststed{'8255'} = 'RKLAND';
$postkommune{'8256'} = '1840'; $kategori{'8256'} = 'P'; $poststed{'8256'} = 'RKLAND';
$postkommune{'8260'} = '1849'; $kategori{'8260'} = 'G'; $poststed{'8260'} = 'INNHAVET';
$postkommune{'8261'} = '1849'; $kategori{'8261'} = 'P'; $poststed{'8261'} = 'INNHAVET';
$postkommune{'8264'} = '1845'; $kategori{'8264'} = 'G'; $poststed{'8264'} = 'ENGAN';
$postkommune{'8266'} = '1845'; $kategori{'8266'} = 'G'; $poststed{'8266'} = 'MRSVIKBOTN';
$postkommune{'8270'} = '1850'; $kategori{'8270'} = 'G'; $poststed{'8270'} = 'DRAG';
$postkommune{'8271'} = '1850'; $kategori{'8271'} = 'P'; $poststed{'8271'} = 'DRAG';
$postkommune{'8273'} = '1850'; $kategori{'8273'} = 'G'; $poststed{'8273'} = 'NEVERVIK';
$postkommune{'8274'} = '1850'; $kategori{'8274'} = 'G'; $poststed{'8274'} = 'MUSKEN';
$postkommune{'8275'} = '1850'; $kategori{'8275'} = 'G'; $poststed{'8275'} = 'STORJORD I TYSFJORD';
$postkommune{'8276'} = '1849'; $kategori{'8276'} = 'G'; $poststed{'8276'} = 'ULVSVG';
$postkommune{'8281'} = '1848'; $kategori{'8281'} = 'P'; $poststed{'8281'} = 'LEINESFJORD';
$postkommune{'8283'} = '1848'; $kategori{'8283'} = 'G'; $poststed{'8283'} = 'LEINESFJORD';
$postkommune{'8285'} = '1848'; $kategori{'8285'} = 'G'; $poststed{'8285'} = 'LEINES';
$postkommune{'8286'} = '1848'; $kategori{'8286'} = 'G'; $poststed{'8286'} = 'NORDFOLD';
$postkommune{'8288'} = '1848'; $kategori{'8288'} = 'G'; $poststed{'8288'} = 'BOGY';
$postkommune{'8289'} = '1848'; $kategori{'8289'} = 'B'; $poststed{'8289'} = 'VG';
$postkommune{'8290'} = '1849'; $kategori{'8290'} = 'B'; $poststed{'8290'} = 'SKUTVIK';
$postkommune{'8294'} = '1849'; $kategori{'8294'} = 'G'; $poststed{'8294'} = 'HAMARY';
$postkommune{'8297'} = '1849'; $kategori{'8297'} = 'G'; $poststed{'8297'} = 'TRANY';
$postkommune{'8298'} = '1849'; $kategori{'8298'} = 'P'; $poststed{'8298'} = 'HAMARY';
$postkommune{'8300'} = '1865'; $kategori{'8300'} = 'G'; $poststed{'8300'} = 'SVOLVR';
$postkommune{'8301'} = '1865'; $kategori{'8301'} = 'P'; $poststed{'8301'} = 'SVOLVR';
$postkommune{'8305'} = '1865'; $kategori{'8305'} = 'S'; $poststed{'8305'} = 'SVOLVR';
$postkommune{'8309'} = '1865'; $kategori{'8309'} = 'P'; $poststed{'8309'} = 'KABELVG';
$postkommune{'8310'} = '1865'; $kategori{'8310'} = 'G'; $poststed{'8310'} = 'KABELVG';
$postkommune{'8311'} = '1865'; $kategori{'8311'} = 'P'; $poststed{'8311'} = 'HENNINGSVR';
$postkommune{'8312'} = '1865'; $kategori{'8312'} = 'G'; $poststed{'8312'} = 'HENNINGSVR';
$postkommune{'8313'} = '1865'; $kategori{'8313'} = 'G'; $poststed{'8313'} = 'KLEPPSTAD';
$postkommune{'8314'} = '1865'; $kategori{'8314'} = 'G'; $poststed{'8314'} = 'GIMSYSAND';
$postkommune{'8315'} = '1865'; $kategori{'8315'} = 'G'; $poststed{'8315'} = 'LAUKVIK';
$postkommune{'8316'} = '1865'; $kategori{'8316'} = 'G'; $poststed{'8316'} = 'LAUPSTAD';
$postkommune{'8317'} = '1866'; $kategori{'8317'} = 'G'; $poststed{'8317'} = 'STRNSTAD';
$postkommune{'8320'} = '1865'; $kategori{'8320'} = 'B'; $poststed{'8320'} = 'SKROVA';
$postkommune{'8322'} = '1865'; $kategori{'8322'} = 'G'; $poststed{'8322'} = 'BRETTESNES';
$postkommune{'8323'} = '1865'; $kategori{'8323'} = 'G'; $poststed{'8323'} = 'STORFJELL';
$postkommune{'8324'} = '1865'; $kategori{'8324'} = 'G'; $poststed{'8324'} = 'DIGERMULEN';
$postkommune{'8325'} = '1866'; $kategori{'8325'} = 'G'; $poststed{'8325'} = 'TENGELFJORD';
$postkommune{'8328'} = '1865'; $kategori{'8328'} = 'G'; $poststed{'8328'} = 'STOREMOLLA';
$postkommune{'8340'} = '1860'; $kategori{'8340'} = 'G'; $poststed{'8340'} = 'STAMSUND';
$postkommune{'8352'} = '1860'; $kategori{'8352'} = 'G'; $poststed{'8352'} = 'SENNESVIK';
$postkommune{'8360'} = '1860'; $kategori{'8360'} = 'B'; $poststed{'8360'} = 'BSTAD';
$postkommune{'8370'} = '1860'; $kategori{'8370'} = 'G'; $poststed{'8370'} = 'LEKNES';
$postkommune{'8372'} = '1860'; $kategori{'8372'} = 'G'; $poststed{'8372'} = 'GRAVDAL';
$postkommune{'8373'} = '1860'; $kategori{'8373'} = 'B'; $poststed{'8373'} = 'BALLSTAD';
$postkommune{'8375'} = '1860'; $kategori{'8375'} = 'S'; $poststed{'8375'} = 'LEKNES';
$postkommune{'8376'} = '1860'; $kategori{'8376'} = 'P'; $poststed{'8376'} = 'LEKNES';
$postkommune{'8377'} = '1860'; $kategori{'8377'} = 'P'; $poststed{'8377'} = 'GRAVDAL';
$postkommune{'8378'} = '1860'; $kategori{'8378'} = 'P'; $poststed{'8378'} = 'STAMSUND';
$postkommune{'8380'} = '1859'; $kategori{'8380'} = 'G'; $poststed{'8380'} = 'RAMBERG';
$postkommune{'8382'} = '1859'; $kategori{'8382'} = 'G'; $poststed{'8382'} = 'NAPP';
$postkommune{'8384'} = '1859'; $kategori{'8384'} = 'G'; $poststed{'8384'} = 'SUND I LOFOTEN';
$postkommune{'8387'} = '1859'; $kategori{'8387'} = 'G'; $poststed{'8387'} = 'FREDVANG';
$postkommune{'8388'} = '1859'; $kategori{'8388'} = 'P'; $poststed{'8388'} = 'RAMBERG';
$postkommune{'8390'} = '1874'; $kategori{'8390'} = 'G'; $poststed{'8390'} = 'REINE';
$postkommune{'8392'} = '1874'; $kategori{'8392'} = 'G'; $poststed{'8392'} = 'SRVGEN';
$postkommune{'8393'} = '1874'; $kategori{'8393'} = 'P'; $poststed{'8393'} = 'SRVGEN';
$postkommune{'8398'} = '1874'; $kategori{'8398'} = 'P'; $poststed{'8398'} = 'REINE';
$postkommune{'8400'} = '1870'; $kategori{'8400'} = 'G'; $poststed{'8400'} = 'SORTLAND';
$postkommune{'8401'} = '1870'; $kategori{'8401'} = 'P'; $poststed{'8401'} = 'SORTLAND';
$postkommune{'8405'} = '1870'; $kategori{'8405'} = 'S'; $poststed{'8405'} = 'SORTLAND';
$postkommune{'8407'} = '1870'; $kategori{'8407'} = 'G'; $poststed{'8407'} = 'GODFJORD';
$postkommune{'8408'} = '1868'; $kategori{'8408'} = 'G'; $poststed{'8408'} = 'SANDSET';
$postkommune{'8409'} = '1911'; $kategori{'8409'} = 'G'; $poststed{'8409'} = 'GULLESFJORD';
$postkommune{'8413'} = '1866'; $kategori{'8413'} = 'G'; $poststed{'8413'} = 'KVITNES';
$postkommune{'8414'} = '1866'; $kategori{'8414'} = 'G'; $poststed{'8414'} = 'HENNES';
$postkommune{'8415'} = '1866'; $kategori{'8415'} = 'P'; $poststed{'8415'} = 'HENNES';
$postkommune{'8426'} = '1868'; $kategori{'8426'} = 'G'; $poststed{'8426'} = 'BARKESTAD';
$postkommune{'8428'} = '1868'; $kategori{'8428'} = 'G'; $poststed{'8428'} = 'TUNSTAD';
$postkommune{'8430'} = '1868'; $kategori{'8430'} = 'G'; $poststed{'8430'} = 'MYRE';
$postkommune{'8432'} = '1868'; $kategori{'8432'} = 'G'; $poststed{'8432'} = 'ALSVG';
$postkommune{'8438'} = '1868'; $kategori{'8438'} = 'G'; $poststed{'8438'} = 'ST';
$postkommune{'8439'} = '1868'; $kategori{'8439'} = 'P'; $poststed{'8439'} = 'MYRE';
$postkommune{'8445'} = '1866'; $kategori{'8445'} = 'G'; $poststed{'8445'} = 'MELBU';
$postkommune{'8446'} = '1866'; $kategori{'8446'} = 'S'; $poststed{'8446'} = 'MELBU';
$postkommune{'8447'} = '1866'; $kategori{'8447'} = 'G'; $poststed{'8447'} = 'LONKAN';
$postkommune{'8448'} = '1866'; $kategori{'8448'} = 'G'; $poststed{'8448'} = 'MYRLAND';
$postkommune{'8450'} = '1866'; $kategori{'8450'} = 'B'; $poststed{'8450'} = 'STOKMARKNES';
$postkommune{'8452'} = '1866'; $kategori{'8452'} = 'S'; $poststed{'8452'} = 'STOKMARKNES';
$postkommune{'8455'} = '1866'; $kategori{'8455'} = 'P'; $poststed{'8455'} = 'STOKMARKNES';
$postkommune{'8459'} = '1866'; $kategori{'8459'} = 'P'; $poststed{'8459'} = 'MELBU';
$postkommune{'8465'} = '1867'; $kategori{'8465'} = 'P'; $poststed{'8465'} = 'STRAUMSJEN';
$postkommune{'8469'} = '1867'; $kategori{'8469'} = 'P'; $poststed{'8469'} = 'B I VESTERLEN';
$postkommune{'8470'} = '1867'; $kategori{'8470'} = 'G'; $poststed{'8470'} = 'B I VESTERLEN';
$postkommune{'8475'} = '1867'; $kategori{'8475'} = 'G'; $poststed{'8475'} = 'STRAUMSJEN';
$postkommune{'8480'} = '1871'; $kategori{'8480'} = 'G'; $poststed{'8480'} = 'ANDENES';
$postkommune{'8481'} = '1871'; $kategori{'8481'} = 'G'; $poststed{'8481'} = 'BLEIK';
$postkommune{'8483'} = '1871'; $kategori{'8483'} = 'P'; $poststed{'8483'} = 'ANDENES';
$postkommune{'8484'} = '1871'; $kategori{'8484'} = 'G'; $poststed{'8484'} = 'RISYHAMN';
$postkommune{'8485'} = '1871'; $kategori{'8485'} = 'G'; $poststed{'8485'} = 'DVERBERG';
$postkommune{'8488'} = '1871'; $kategori{'8488'} = 'G'; $poststed{'8488'} = 'NSS';
$postkommune{'8489'} = '1871'; $kategori{'8489'} = 'G'; $poststed{'8489'} = 'NORDMELA';
$postkommune{'8493'} = '1871'; $kategori{'8493'} = 'P'; $poststed{'8493'} = 'RISYHAMN';
$postkommune{'8501'} = '1805'; $kategori{'8501'} = 'P'; $poststed{'8501'} = 'NARVIK';
$postkommune{'8502'} = '1805'; $kategori{'8502'} = 'P'; $poststed{'8502'} = 'NARVIK';
$postkommune{'8503'} = '1805'; $kategori{'8503'} = 'P'; $poststed{'8503'} = 'NARVIK';
$postkommune{'8504'} = '1805'; $kategori{'8504'} = 'P'; $poststed{'8504'} = 'NARVIK';
$postkommune{'8505'} = '1805'; $kategori{'8505'} = 'P'; $poststed{'8505'} = 'NARVIK';
$postkommune{'8506'} = '1805'; $kategori{'8506'} = 'P'; $poststed{'8506'} = 'NARVIK';
$postkommune{'8507'} = '1805'; $kategori{'8507'} = 'P'; $poststed{'8507'} = 'NARVIK';
$postkommune{'8508'} = '1805'; $kategori{'8508'} = 'P'; $poststed{'8508'} = 'NARVIK';
$postkommune{'8509'} = '1805'; $kategori{'8509'} = 'P'; $poststed{'8509'} = 'NARVIK';
$postkommune{'8510'} = '1805'; $kategori{'8510'} = 'P'; $poststed{'8510'} = 'NARVIK';
$postkommune{'8512'} = '1805'; $kategori{'8512'} = 'S'; $poststed{'8512'} = 'NARVIK';
$postkommune{'8513'} = '1805'; $kategori{'8513'} = 'P'; $poststed{'8513'} = 'ANKENESSTRAND';
$postkommune{'8514'} = '1805'; $kategori{'8514'} = 'G'; $poststed{'8514'} = 'NARVIK';
$postkommune{'8515'} = '1805'; $kategori{'8515'} = 'G'; $poststed{'8515'} = 'NARVIK';
$postkommune{'8516'} = '1805'; $kategori{'8516'} = 'G'; $poststed{'8516'} = 'NARVIK';
$postkommune{'8517'} = '1805'; $kategori{'8517'} = 'G'; $poststed{'8517'} = 'NARVIK';
$postkommune{'8518'} = '1805'; $kategori{'8518'} = 'P'; $poststed{'8518'} = 'NARVIK';
$postkommune{'8520'} = '1805'; $kategori{'8520'} = 'G'; $poststed{'8520'} = 'ANKENESSTRAND';
$postkommune{'8522'} = '1805'; $kategori{'8522'} = 'G'; $poststed{'8522'} = 'BEISFJORD';
$postkommune{'8523'} = '1805'; $kategori{'8523'} = 'G'; $poststed{'8523'} = 'ELVEGARD';
$postkommune{'8530'} = '1805'; $kategori{'8530'} = 'G'; $poststed{'8530'} = 'BJERKVIK';
$postkommune{'8531'} = '1805'; $kategori{'8531'} = 'P'; $poststed{'8531'} = 'BJERKVIK';
$postkommune{'8533'} = '1853'; $kategori{'8533'} = 'G'; $poststed{'8533'} = 'BOGEN I OFOTEN';
$postkommune{'8534'} = '1853'; $kategori{'8534'} = 'G'; $poststed{'8534'} = 'LILAND';
$postkommune{'8535'} = '1853'; $kategori{'8535'} = 'G'; $poststed{'8535'} = 'TRSTAD';
$postkommune{'8536'} = '1853'; $kategori{'8536'} = 'G'; $poststed{'8536'} = 'EVENES';
$postkommune{'8539'} = '1853'; $kategori{'8539'} = 'P'; $poststed{'8539'} = 'BOGEN I OFOTEN';
$postkommune{'8540'} = '1854'; $kategori{'8540'} = 'G'; $poststed{'8540'} = 'BALLANGEN';
$postkommune{'8542'} = '1854'; $kategori{'8542'} = 'P'; $poststed{'8542'} = 'KJELDEBOTN';
$postkommune{'8543'} = '1854'; $kategori{'8543'} = 'G'; $poststed{'8543'} = 'KJELDEBOTN';
$postkommune{'8546'} = '1854'; $kategori{'8546'} = 'P'; $poststed{'8546'} = 'BALLANGEN';
$postkommune{'8550'} = '1851'; $kategori{'8550'} = 'G'; $poststed{'8550'} = 'LDINGEN';
$postkommune{'8551'} = '1851'; $kategori{'8551'} = 'P'; $poststed{'8551'} = 'LDINGEN';
$postkommune{'8581'} = '1851'; $kategori{'8581'} = 'G'; $poststed{'8581'} = 'VESTBYGD';
$postkommune{'8587'} = '1850'; $kategori{'8587'} = 'G'; $poststed{'8587'} = 'STOR';
$postkommune{'8590'} = '1850'; $kategori{'8590'} = 'G'; $poststed{'8590'} = 'KJPSVIK';
$postkommune{'8591'} = '1850'; $kategori{'8591'} = 'P'; $poststed{'8591'} = 'KJPSVIK';
$postkommune{'8601'} = '1833'; $kategori{'8601'} = 'P'; $poststed{'8601'} = 'MO I RANA';
$postkommune{'8602'} = '1833'; $kategori{'8602'} = 'P'; $poststed{'8602'} = 'MO I RANA';
$postkommune{'8603'} = '1833'; $kategori{'8603'} = 'P'; $poststed{'8603'} = 'MO I RANA';
$postkommune{'8604'} = '1833'; $kategori{'8604'} = 'P'; $poststed{'8604'} = 'MO I RANA';
$postkommune{'8605'} = '1833'; $kategori{'8605'} = 'K'; $poststed{'8605'} = 'MO I RANA';
$postkommune{'8606'} = '1833'; $kategori{'8606'} = 'K'; $poststed{'8606'} = 'MO I RANA';
$postkommune{'8607'} = '1833'; $kategori{'8607'} = 'S'; $poststed{'8607'} = 'MO I RANA';
$postkommune{'8608'} = '1833'; $kategori{'8608'} = 'P'; $poststed{'8608'} = 'MO I RANA';
$postkommune{'8610'} = '1833'; $kategori{'8610'} = 'G'; $poststed{'8610'} = 'MO I RANA';
$postkommune{'8613'} = '1833'; $kategori{'8613'} = 'G'; $poststed{'8613'} = 'MO I RANA';
$postkommune{'8614'} = '1833'; $kategori{'8614'} = 'G'; $poststed{'8614'} = 'MO I RANA';
$postkommune{'8615'} = '1833'; $kategori{'8615'} = 'G'; $poststed{'8615'} = 'SKONSENG';
$postkommune{'8616'} = '1833'; $kategori{'8616'} = 'B'; $poststed{'8616'} = 'MO I RANA';
$postkommune{'8617'} = '1833'; $kategori{'8617'} = 'G'; $poststed{'8617'} = 'DALSGRENDA';
$postkommune{'8618'} = '1833'; $kategori{'8618'} = 'B'; $poststed{'8618'} = 'MO I RANA';
$postkommune{'8622'} = '1833'; $kategori{'8622'} = 'G'; $poststed{'8622'} = 'MO I RANA';
$postkommune{'8624'} = '1833'; $kategori{'8624'} = 'G'; $poststed{'8624'} = 'MO I RANA';
$postkommune{'8626'} = '1833'; $kategori{'8626'} = 'G'; $poststed{'8626'} = 'MO I RANA';
$postkommune{'8629'} = '1833'; $kategori{'8629'} = 'G'; $poststed{'8629'} = 'SVARTISDAL';
$postkommune{'8630'} = '1833'; $kategori{'8630'} = 'G'; $poststed{'8630'} = 'STORFORSHEI';
$postkommune{'8634'} = '1833'; $kategori{'8634'} = 'K'; $poststed{'8634'} = 'MO I RANA';
$postkommune{'8635'} = '1833'; $kategori{'8635'} = 'K'; $poststed{'8635'} = 'POLARSIRKELEN';
$postkommune{'8638'} = '1833'; $kategori{'8638'} = 'P'; $poststed{'8638'} = 'STORFORSHEI';
$postkommune{'8640'} = '1832'; $kategori{'8640'} = 'G'; $poststed{'8640'} = 'HEMNESBERGET';
$postkommune{'8641'} = '1832'; $kategori{'8641'} = 'P'; $poststed{'8641'} = 'HEMNESBERGET';
$postkommune{'8642'} = '1832'; $kategori{'8642'} = 'B'; $poststed{'8642'} = 'FINNEIDFJORD';
$postkommune{'8643'} = '1832'; $kategori{'8643'} = 'B'; $poststed{'8643'} = 'BJERKA';
$postkommune{'8646'} = '1832'; $kategori{'8646'} = 'G'; $poststed{'8646'} = 'KORGEN';
$postkommune{'8647'} = '1832'; $kategori{'8647'} = 'G'; $poststed{'8647'} = 'BLEIKVASSLIA';
$postkommune{'8648'} = '1832'; $kategori{'8648'} = 'P'; $poststed{'8648'} = 'KORGEN';
$postkommune{'8651'} = '1824'; $kategori{'8651'} = 'P'; $poststed{'8651'} = 'MOSJEN';
$postkommune{'8654'} = '1824'; $kategori{'8654'} = 'S'; $poststed{'8654'} = 'MOSJEN';
$postkommune{'8655'} = '1824'; $kategori{'8655'} = 'F'; $poststed{'8655'} = 'MOSJEN';
$postkommune{'8656'} = '1824'; $kategori{'8656'} = 'G'; $poststed{'8656'} = 'MOSJEN';
$postkommune{'8657'} = '1824'; $kategori{'8657'} = 'G'; $poststed{'8657'} = 'MOSJEN';
$postkommune{'8658'} = '1824'; $kategori{'8658'} = 'G'; $poststed{'8658'} = 'MOSJEN';
$postkommune{'8659'} = '1824'; $kategori{'8659'} = 'G'; $poststed{'8659'} = 'MOSJEN';
$postkommune{'8661'} = '1824'; $kategori{'8661'} = 'G'; $poststed{'8661'} = 'MOSJEN';
$postkommune{'8663'} = '1824'; $kategori{'8663'} = 'G'; $poststed{'8663'} = 'MOSJEN';
$postkommune{'8664'} = '1824'; $kategori{'8664'} = 'G'; $poststed{'8664'} = 'MOSJEN';
$postkommune{'8665'} = '1824'; $kategori{'8665'} = 'G'; $poststed{'8665'} = 'MOSJEN';
$postkommune{'8672'} = '1824'; $kategori{'8672'} = 'G'; $poststed{'8672'} = 'ELSFJORD';
$postkommune{'8680'} = '1825'; $kategori{'8680'} = 'G'; $poststed{'8680'} = 'TROFORS';
$postkommune{'8681'} = '1825'; $kategori{'8681'} = 'P'; $poststed{'8681'} = 'TROFORS';
$postkommune{'8690'} = '1826'; $kategori{'8690'} = 'G'; $poststed{'8690'} = 'HATTFJELLDAL';
$postkommune{'8691'} = '1826'; $kategori{'8691'} = 'P'; $poststed{'8691'} = 'HATTFJELLDAL';
$postkommune{'8700'} = '1828'; $kategori{'8700'} = 'G'; $poststed{'8700'} = 'NESNA';
$postkommune{'8701'} = '1828'; $kategori{'8701'} = 'P'; $poststed{'8701'} = 'NESNA';
$postkommune{'8720'} = '1828'; $kategori{'8720'} = 'G'; $poststed{'8720'} = 'VIKHOLMEN';
$postkommune{'8723'} = '1828'; $kategori{'8723'} = 'G'; $poststed{'8723'} = 'HUSBY';
$postkommune{'8724'} = '1828'; $kategori{'8724'} = 'G'; $poststed{'8724'} = 'SAURA';
$postkommune{'8725'} = '1833'; $kategori{'8725'} = 'G'; $poststed{'8725'} = 'UTSKARPEN';
$postkommune{'8726'} = '1833'; $kategori{'8726'} = 'P'; $poststed{'8726'} = 'UTSKARPEN';
$postkommune{'8730'} = '1834'; $kategori{'8730'} = 'G'; $poststed{'8730'} = 'BRATLAND';
$postkommune{'8732'} = '1834'; $kategori{'8732'} = 'G'; $poststed{'8732'} = 'ALDRA';
$postkommune{'8733'} = '1834'; $kategori{'8733'} = 'G'; $poststed{'8733'} = 'STUVLAND';
$postkommune{'8735'} = '1834'; $kategori{'8735'} = 'G'; $poststed{'8735'} = 'STOKKVGEN';
$postkommune{'8740'} = '1834'; $kategori{'8740'} = 'G'; $poststed{'8740'} = 'NORD-SOLVR';
$postkommune{'8742'} = '1835'; $kategori{'8742'} = 'B'; $poststed{'8742'} = 'SELVR';
$postkommune{'8743'} = '1834'; $kategori{'8743'} = 'B'; $poststed{'8743'} = 'INDRE KVARY';
$postkommune{'8750'} = '1834'; $kategori{'8750'} = 'G'; $poststed{'8750'} = 'TONNES';
$postkommune{'8752'} = '1834'; $kategori{'8752'} = 'G'; $poststed{'8752'} = 'KONSVIKOSEN';
$postkommune{'8753'} = '1834'; $kategori{'8753'} = 'P'; $poststed{'8753'} = 'KONSVIKOSEN';
$postkommune{'8754'} = '1836'; $kategori{'8754'} = 'G'; $poststed{'8754'} = 'RESVIK';
$postkommune{'8762'} = '1834'; $kategori{'8762'} = 'B'; $poststed{'8762'} = 'SLENESET';
$postkommune{'8764'} = '1834'; $kategori{'8764'} = 'B'; $poststed{'8764'} = 'LOVUND';
$postkommune{'8766'} = '1834'; $kategori{'8766'} = 'G'; $poststed{'8766'} = 'LURY';
$postkommune{'8767'} = '1834'; $kategori{'8767'} = 'P'; $poststed{'8767'} = 'LURY';
$postkommune{'8770'} = '1835'; $kategori{'8770'} = 'B'; $poststed{'8770'} = 'TRNA';
$postkommune{'8800'} = '1820'; $kategori{'8800'} = 'G'; $poststed{'8800'} = 'SANDNESSJEN';
$postkommune{'8801'} = '1820'; $kategori{'8801'} = 'P'; $poststed{'8801'} = 'SANDNESSJEN';
$postkommune{'8805'} = '1820'; $kategori{'8805'} = 'S'; $poststed{'8805'} = 'SANDNESSJEN';
$postkommune{'8813'} = '1827'; $kategori{'8813'} = 'G'; $poststed{'8813'} = 'KOPARDAL';
$postkommune{'8820'} = '1827'; $kategori{'8820'} = 'G'; $poststed{'8820'} = 'DNNA';
$postkommune{'8826'} = '1827'; $kategori{'8826'} = 'G'; $poststed{'8826'} = 'NORDYVGEN';
$postkommune{'8827'} = '1827'; $kategori{'8827'} = 'P'; $poststed{'8827'} = 'DNNA';
$postkommune{'8830'} = '1827'; $kategori{'8830'} = 'B'; $poststed{'8830'} = 'VANDVE';
$postkommune{'8842'} = '1818'; $kategori{'8842'} = 'G'; $poststed{'8842'} = 'BRASY';
$postkommune{'8844'} = '1818'; $kategori{'8844'} = 'B'; $poststed{'8844'} = 'SANDVR';
$postkommune{'8850'} = '1818'; $kategori{'8850'} = 'G'; $poststed{'8850'} = 'HERY';
$postkommune{'8851'} = '1818'; $kategori{'8851'} = 'P'; $poststed{'8851'} = 'HERY';
$postkommune{'8852'} = '1818'; $kategori{'8852'} = 'P'; $poststed{'8852'} = 'HERY';
$postkommune{'8854'} = '1820'; $kategori{'8854'} = 'G'; $poststed{'8854'} = 'AUSTB';
$postkommune{'8860'} = '1820'; $kategori{'8860'} = 'B'; $poststed{'8860'} = 'TJTTA';
$postkommune{'8865'} = '1820'; $kategori{'8865'} = 'B'; $poststed{'8865'} = 'TRO';
$postkommune{'8870'} = '1816'; $kategori{'8870'} = 'G'; $poststed{'8870'} = 'VISTHUS';
$postkommune{'8880'} = '1820'; $kategori{'8880'} = 'B'; $poststed{'8880'} = 'BRYVGEN';
$postkommune{'8883'} = '1824'; $kategori{'8883'} = 'G'; $poststed{'8883'} = 'HUSVIKA';
$postkommune{'8890'} = '1822'; $kategori{'8890'} = 'G'; $poststed{'8890'} = 'LEIRFJORD';
$postkommune{'8891'} = '1822'; $kategori{'8891'} = 'P'; $poststed{'8891'} = 'LEIRFJORD';
$postkommune{'8892'} = '1822'; $kategori{'8892'} = 'G'; $poststed{'8892'} = 'SUNDY';
$postkommune{'8900'} = '1813'; $kategori{'8900'} = 'G'; $poststed{'8900'} = 'BRNNYSUND';
$postkommune{'8901'} = '1813'; $kategori{'8901'} = 'P'; $poststed{'8901'} = 'BRNNYSUND';
$postkommune{'8905'} = '1813'; $kategori{'8905'} = 'S'; $poststed{'8905'} = 'BRNNYSUND';
$postkommune{'8910'} = '1813'; $kategori{'8910'} = 'K'; $poststed{'8910'} = 'BRNNYSUND';
$postkommune{'8920'} = '1812'; $kategori{'8920'} = 'G'; $poststed{'8920'} = 'SMNA';
$postkommune{'8921'} = '1812'; $kategori{'8921'} = 'P'; $poststed{'8921'} = 'SMNA';
$postkommune{'8922'} = '1812'; $kategori{'8922'} = 'P'; $poststed{'8922'} = 'SMNA';
$postkommune{'8960'} = '1813'; $kategori{'8960'} = 'G'; $poststed{'8960'} = 'HOMMELST';
$postkommune{'8961'} = '1813'; $kategori{'8961'} = 'P'; $poststed{'8961'} = 'HOMMELST';
$postkommune{'8976'} = '1816'; $kategori{'8976'} = 'B'; $poststed{'8976'} = 'VEVELSTAD';
$postkommune{'8978'} = '1816'; $kategori{'8978'} = 'G'; $poststed{'8978'} = 'HESSTUN';
$postkommune{'8980'} = '1815'; $kategori{'8980'} = 'G'; $poststed{'8980'} = 'VEGA';
$postkommune{'8981'} = '1815'; $kategori{'8981'} = 'P'; $poststed{'8981'} = 'VEGA';
$postkommune{'8985'} = '1815'; $kategori{'8985'} = 'B'; $poststed{'8985'} = 'YLVINGEN';
$postkommune{'9006'} = '1902'; $kategori{'9006'} = 'G'; $poststed{'9006'} = 'TROMS';
$postkommune{'9007'} = '1902'; $kategori{'9007'} = 'G'; $poststed{'9007'} = 'TROMS';
$postkommune{'9008'} = '1902'; $kategori{'9008'} = 'G'; $poststed{'9008'} = 'TROMS';
$postkommune{'9009'} = '1902'; $kategori{'9009'} = 'G'; $poststed{'9009'} = 'TROMS';
$postkommune{'9010'} = '1902'; $kategori{'9010'} = 'G'; $poststed{'9010'} = 'TROMS';
$postkommune{'9011'} = '1902'; $kategori{'9011'} = 'G'; $poststed{'9011'} = 'TROMS';
$postkommune{'9012'} = '1902'; $kategori{'9012'} = 'G'; $poststed{'9012'} = 'TROMS';
$postkommune{'9013'} = '1902'; $kategori{'9013'} = 'B'; $poststed{'9013'} = 'TROMS';
$postkommune{'9014'} = '1902'; $kategori{'9014'} = 'G'; $poststed{'9014'} = 'TROMS';
$postkommune{'9015'} = '1902'; $kategori{'9015'} = 'G'; $poststed{'9015'} = 'TROMS';
$postkommune{'9016'} = '1902'; $kategori{'9016'} = 'G'; $poststed{'9016'} = 'TROMS';
$postkommune{'9017'} = '1902'; $kategori{'9017'} = 'G'; $poststed{'9017'} = 'TROMS';
$postkommune{'9018'} = '1902'; $kategori{'9018'} = 'G'; $poststed{'9018'} = 'TROMS';
$postkommune{'9019'} = '1902'; $kategori{'9019'} = 'G'; $poststed{'9019'} = 'TROMS';
$postkommune{'9020'} = '1902'; $kategori{'9020'} = 'G'; $poststed{'9020'} = 'TROMSDALEN';
$postkommune{'9022'} = '1902'; $kategori{'9022'} = 'G'; $poststed{'9022'} = 'KROKELVDALEN';
$postkommune{'9024'} = '1902'; $kategori{'9024'} = 'G'; $poststed{'9024'} = 'TOMASJORD';
$postkommune{'9027'} = '1902'; $kategori{'9027'} = 'G'; $poststed{'9027'} = 'RAMFJORDBOTN';
$postkommune{'9030'} = '1902'; $kategori{'9030'} = 'G'; $poststed{'9030'} = 'SJURSNES';
$postkommune{'9034'} = '1902'; $kategori{'9034'} = 'G'; $poststed{'9034'} = 'OLDERVIK';
$postkommune{'9037'} = '1902'; $kategori{'9037'} = 'K'; $poststed{'9037'} = 'TROMS';
$postkommune{'9038'} = '1902'; $kategori{'9038'} = 'K'; $poststed{'9038'} = 'TROMS';
$postkommune{'9040'} = '1933'; $kategori{'9040'} = 'G'; $poststed{'9040'} = 'NORDKJOSBOTN';
$postkommune{'9042'} = '1933'; $kategori{'9042'} = 'G'; $poststed{'9042'} = 'LAKSVATN';
$postkommune{'9043'} = '1902'; $kategori{'9043'} = 'G'; $poststed{'9043'} = 'JVIK';
$postkommune{'9046'} = '1939'; $kategori{'9046'} = 'G'; $poststed{'9046'} = 'OTEREN';
$postkommune{'9049'} = '1933'; $kategori{'9049'} = 'P'; $poststed{'9049'} = 'NORDKJOSBOTN';
$postkommune{'9050'} = '1933'; $kategori{'9050'} = 'G'; $poststed{'9050'} = 'STORSTEINNES';
$postkommune{'9054'} = '1933'; $kategori{'9054'} = 'G'; $poststed{'9054'} = 'MALANGSEIDET';
$postkommune{'9055'} = '1933'; $kategori{'9055'} = 'G'; $poststed{'9055'} = 'MEISTERVIK';
$postkommune{'9056'} = '1933'; $kategori{'9056'} = 'G'; $poststed{'9056'} = 'MORTENHALS';
$postkommune{'9057'} = '1902'; $kategori{'9057'} = 'B'; $poststed{'9057'} = 'VIKRAN';
$postkommune{'9059'} = '1933'; $kategori{'9059'} = 'P'; $poststed{'9059'} = 'STORSTEINNES';
$postkommune{'9060'} = '1938'; $kategori{'9060'} = 'G'; $poststed{'9060'} = 'LYNGSEIDET';
$postkommune{'9062'} = '1938'; $kategori{'9062'} = 'G'; $poststed{'9062'} = 'FURUFLATEN';
$postkommune{'9064'} = '1938'; $kategori{'9064'} = 'G'; $poststed{'9064'} = 'SVENSBY';
$postkommune{'9068'} = '1938'; $kategori{'9068'} = 'G'; $poststed{'9068'} = 'NORD-LENANGEN';
$postkommune{'9069'} = '1938'; $kategori{'9069'} = 'P'; $poststed{'9069'} = 'LYNGSEIDET';
$postkommune{'9100'} = '1902'; $kategori{'9100'} = 'G'; $poststed{'9100'} = 'KVALYSLETTA';
$postkommune{'9103'} = '1902'; $kategori{'9103'} = 'G'; $poststed{'9103'} = 'SKULSFJORD';
$postkommune{'9106'} = '1902'; $kategori{'9106'} = 'G'; $poststed{'9106'} = 'STRAUMSBUKTA';
$postkommune{'9107'} = '1902'; $kategori{'9107'} = 'G'; $poststed{'9107'} = 'TROMVIK';
$postkommune{'9110'} = '1902'; $kategori{'9110'} = 'G'; $poststed{'9110'} = 'SOMMARY';
$postkommune{'9118'} = '1902'; $kategori{'9118'} = 'G'; $poststed{'9118'} = 'BRENSHOLMEN';
$postkommune{'9119'} = '1902'; $kategori{'9119'} = 'P'; $poststed{'9119'} = 'SOMMARY';
$postkommune{'9120'} = '1902'; $kategori{'9120'} = 'G'; $poststed{'9120'} = 'VENGSY';
$postkommune{'9128'} = '1902'; $kategori{'9128'} = 'G'; $poststed{'9128'} = 'TUSSY';
$postkommune{'9130'} = '1936'; $kategori{'9130'} = 'G'; $poststed{'9130'} = 'HANSNES';
$postkommune{'9131'} = '1902'; $kategori{'9131'} = 'G'; $poststed{'9131'} = 'KRVIK';
$postkommune{'9132'} = '1936'; $kategori{'9132'} = 'G'; $poststed{'9132'} = 'STAKKVIK';
$postkommune{'9134'} = '1936'; $kategori{'9134'} = 'P'; $poststed{'9134'} = 'HANSNES';
$postkommune{'9135'} = '1936'; $kategori{'9135'} = 'G'; $poststed{'9135'} = 'VANNVG';
$postkommune{'9136'} = '1936'; $kategori{'9136'} = 'G'; $poststed{'9136'} = 'VANNAREID';
$postkommune{'9137'} = '1936'; $kategori{'9137'} = 'P'; $poststed{'9137'} = 'VANNVG';
$postkommune{'9138'} = '1936'; $kategori{'9138'} = 'B'; $poststed{'9138'} = 'KARLSY';
$postkommune{'9140'} = '1936'; $kategori{'9140'} = 'G'; $poststed{'9140'} = 'REBBENES';
$postkommune{'9141'} = '1902'; $kategori{'9141'} = 'G'; $poststed{'9141'} = 'MJLVIK';
$postkommune{'9142'} = '1939'; $kategori{'9142'} = 'P'; $poststed{'9142'} = 'SKIBOTN';
$postkommune{'9143'} = '1939'; $kategori{'9143'} = 'G'; $poststed{'9143'} = 'SKIBOTN';
$postkommune{'9144'} = '1940'; $kategori{'9144'} = 'B'; $poststed{'9144'} = 'SAMUELSBERG';
$postkommune{'9146'} = '1940'; $kategori{'9146'} = 'G'; $poststed{'9146'} = 'OLDERDALEN';
$postkommune{'9147'} = '1940'; $kategori{'9147'} = 'B'; $poststed{'9147'} = 'BIRTAVARRE';
$postkommune{'9148'} = '1940'; $kategori{'9148'} = 'P'; $poststed{'9148'} = 'OLDERDALEN';
$postkommune{'9151'} = '1942'; $kategori{'9151'} = 'G'; $poststed{'9151'} = 'STORSLETT';
$postkommune{'9152'} = '1942'; $kategori{'9152'} = 'B'; $poststed{'9152'} = 'SRKJOSEN';
$postkommune{'9153'} = '1942'; $kategori{'9153'} = 'G'; $poststed{'9153'} = 'ROTSUND';
$postkommune{'9156'} = '1942'; $kategori{'9156'} = 'P'; $poststed{'9156'} = 'STORSLETT';
$postkommune{'9159'} = '1942'; $kategori{'9159'} = 'B'; $poststed{'9159'} = 'HAVNNES';
$postkommune{'9161'} = '1943'; $kategori{'9161'} = 'G'; $poststed{'9161'} = 'BURFJORD';
$postkommune{'9162'} = '1943'; $kategori{'9162'} = 'G'; $poststed{'9162'} = 'SRSTRAUMEN';
$postkommune{'9163'} = '1943'; $kategori{'9163'} = 'G'; $poststed{'9163'} = 'JKELFJORD';
$postkommune{'9164'} = '1943'; $kategori{'9164'} = 'G'; $poststed{'9164'} = 'KVNANGSFJELLET';
$postkommune{'9169'} = '1943'; $kategori{'9169'} = 'P'; $poststed{'9169'} = 'BURFJORD';
$postkommune{'9170'} = '2111'; $kategori{'9170'} = 'G'; $poststed{'9170'} = 'LONGYEARBYEN';
$postkommune{'9171'} = '2111'; $kategori{'9171'} = 'F'; $poststed{'9171'} = 'LONGYEARBYEN';
$postkommune{'9172'} = '2111'; $kategori{'9172'} = 'G'; $poststed{'9172'} = 'ISFJORD P SVALBARD';
$postkommune{'9173'} = '2111'; $kategori{'9173'} = 'B'; $poststed{'9173'} = 'NY-LESUND';
$postkommune{'9174'} = '2131'; $kategori{'9174'} = 'G'; $poststed{'9174'} = 'HOPEN';
$postkommune{'9175'} = '2111'; $kategori{'9175'} = 'G'; $poststed{'9175'} = 'SVEAGRUVA';
$postkommune{'9176'} = '2121'; $kategori{'9176'} = 'G'; $poststed{'9176'} = 'BJRNYA';
$postkommune{'9177'} = '2111'; $kategori{'9177'} = 'G'; $poststed{'9177'} = 'HORNSUND';
$postkommune{'9178'} = '2111'; $kategori{'9178'} = 'G'; $poststed{'9178'} = 'BARENTSBURG';
$postkommune{'9179'} = '2111'; $kategori{'9179'} = 'G'; $poststed{'9179'} = 'PYRAMIDEN';
$postkommune{'9180'} = '1941'; $kategori{'9180'} = 'G'; $poststed{'9180'} = 'SKJERVY';
$postkommune{'9181'} = '1942'; $kategori{'9181'} = 'G'; $poststed{'9181'} = 'HAMNEIDET';
$postkommune{'9182'} = '1943'; $kategori{'9182'} = 'G'; $poststed{'9182'} = 'SEGLVIK';
$postkommune{'9184'} = '1943'; $kategori{'9184'} = 'B'; $poststed{'9184'} = 'REINFJORD';
$postkommune{'9185'} = '1943'; $kategori{'9185'} = 'G'; $poststed{'9185'} = 'SPILDRA';
$postkommune{'9186'} = '1943'; $kategori{'9186'} = 'G'; $poststed{'9186'} = 'ANDSNES';
$postkommune{'9189'} = '1941'; $kategori{'9189'} = 'P'; $poststed{'9189'} = 'SKJERVY';
$postkommune{'9190'} = '1941'; $kategori{'9190'} = 'G'; $poststed{'9190'} = 'AKKARVIK';
$postkommune{'9192'} = '1941'; $kategori{'9192'} = 'G'; $poststed{'9192'} = 'ARNYHAMN';
$postkommune{'9193'} = '1941'; $kategori{'9193'} = 'G'; $poststed{'9193'} = 'NIKKEBY';
$postkommune{'9194'} = '1941'; $kategori{'9194'} = 'G'; $poststed{'9194'} = 'LAUKSLETTA';
$postkommune{'9195'} = '1941'; $kategori{'9195'} = 'B'; $poststed{'9195'} = 'RVIKSAND';
$postkommune{'9197'} = '1941'; $kategori{'9197'} = 'G'; $poststed{'9197'} = 'ULYBUKT';
$postkommune{'9251'} = '1902'; $kategori{'9251'} = 'P'; $poststed{'9251'} = 'TROMS';
$postkommune{'9252'} = '1902'; $kategori{'9252'} = 'P'; $poststed{'9252'} = 'TROMS';
$postkommune{'9253'} = '1902'; $kategori{'9253'} = 'P'; $poststed{'9253'} = 'TROMS';
$postkommune{'9254'} = '1902'; $kategori{'9254'} = 'P'; $poststed{'9254'} = 'TROMS';
$postkommune{'9255'} = '1902'; $kategori{'9255'} = 'P'; $poststed{'9255'} = 'TROMS';
$postkommune{'9256'} = '1902'; $kategori{'9256'} = 'P'; $poststed{'9256'} = 'TROMS';
$postkommune{'9257'} = '1902'; $kategori{'9257'} = 'P'; $poststed{'9257'} = 'TROMS';
$postkommune{'9258'} = '1902'; $kategori{'9258'} = 'P'; $poststed{'9258'} = 'TROMS';
$postkommune{'9259'} = '1902'; $kategori{'9259'} = 'P'; $poststed{'9259'} = 'TROMS';
$postkommune{'9260'} = '1902'; $kategori{'9260'} = 'P'; $poststed{'9260'} = 'TROMS';
$postkommune{'9261'} = '1902'; $kategori{'9261'} = 'P'; $poststed{'9261'} = 'TROMS';
$postkommune{'9262'} = '1902'; $kategori{'9262'} = 'P'; $poststed{'9262'} = 'TROMS';
$postkommune{'9263'} = '1902'; $kategori{'9263'} = 'P'; $poststed{'9263'} = 'TROMS';
$postkommune{'9265'} = '1902'; $kategori{'9265'} = 'P'; $poststed{'9265'} = 'TROMS';
$postkommune{'9266'} = '1902'; $kategori{'9266'} = 'P'; $poststed{'9266'} = 'TROMS';
$postkommune{'9267'} = '1902'; $kategori{'9267'} = 'P'; $poststed{'9267'} = 'TROMS';
$postkommune{'9268'} = '1902'; $kategori{'9268'} = 'P'; $poststed{'9268'} = 'TROMS';
$postkommune{'9269'} = '1902'; $kategori{'9269'} = 'P'; $poststed{'9269'} = 'TROMS';
$postkommune{'9270'} = '1902'; $kategori{'9270'} = 'P'; $poststed{'9270'} = 'TROMS';
$postkommune{'9271'} = '1902'; $kategori{'9271'} = 'P'; $poststed{'9271'} = 'TROMS';
$postkommune{'9272'} = '1902'; $kategori{'9272'} = 'P'; $poststed{'9272'} = 'TROMS';
$postkommune{'9273'} = '1902'; $kategori{'9273'} = 'P'; $poststed{'9273'} = 'TROMS';
$postkommune{'9274'} = '1902'; $kategori{'9274'} = 'P'; $poststed{'9274'} = 'TROMS';
$postkommune{'9275'} = '1902'; $kategori{'9275'} = 'P'; $poststed{'9275'} = 'TROMS';
$postkommune{'9276'} = '1902'; $kategori{'9276'} = 'P'; $poststed{'9276'} = 'TROMS';
$postkommune{'9277'} = '1902'; $kategori{'9277'} = 'P'; $poststed{'9277'} = 'TROMS';
$postkommune{'9278'} = '1902'; $kategori{'9278'} = 'P'; $poststed{'9278'} = 'TROMS';
$postkommune{'9279'} = '1902'; $kategori{'9279'} = 'P'; $poststed{'9279'} = 'TROMS';
$postkommune{'9280'} = '1902'; $kategori{'9280'} = 'P'; $poststed{'9280'} = 'TROMS';
$postkommune{'9281'} = '1902'; $kategori{'9281'} = 'P'; $poststed{'9281'} = 'TROMS';
$postkommune{'9282'} = '1902'; $kategori{'9282'} = 'P'; $poststed{'9282'} = 'TROMS';
$postkommune{'9283'} = '1902'; $kategori{'9283'} = 'P'; $poststed{'9283'} = 'TROMS';
$postkommune{'9284'} = '1902'; $kategori{'9284'} = 'P'; $poststed{'9284'} = 'TROMS';
$postkommune{'9285'} = '1902'; $kategori{'9285'} = 'P'; $poststed{'9285'} = 'TROMS';
$postkommune{'9286'} = '1902'; $kategori{'9286'} = 'P'; $poststed{'9286'} = 'TROMS';
$postkommune{'9287'} = '1902'; $kategori{'9287'} = 'P'; $poststed{'9287'} = 'TROMS';
$postkommune{'9288'} = '1902'; $kategori{'9288'} = 'P'; $poststed{'9288'} = 'TROMS';
$postkommune{'9290'} = '1902'; $kategori{'9290'} = 'K'; $poststed{'9290'} = 'TROMS';
$postkommune{'9291'} = '1902'; $kategori{'9291'} = 'S'; $poststed{'9291'} = 'TROMS';
$postkommune{'9292'} = '1902'; $kategori{'9292'} = 'S'; $poststed{'9292'} = 'TROMS';
$postkommune{'9293'} = '1902'; $kategori{'9293'} = 'S'; $poststed{'9293'} = 'TROMS';
$postkommune{'9294'} = '1902'; $kategori{'9294'} = 'S'; $poststed{'9294'} = 'TROMS';
$postkommune{'9296'} = '1902'; $kategori{'9296'} = 'S'; $poststed{'9296'} = 'TROMS';
$postkommune{'9297'} = '1902'; $kategori{'9297'} = 'K'; $poststed{'9297'} = 'TROMS';
$postkommune{'9298'} = '1902'; $kategori{'9298'} = 'K'; $poststed{'9298'} = 'TROMS';
$postkommune{'9299'} = '1902'; $kategori{'9299'} = 'K'; $poststed{'9299'} = 'TROMS';
$postkommune{'9300'} = '1931'; $kategori{'9300'} = 'G'; $poststed{'9300'} = 'FINNSNES';
$postkommune{'9302'} = '1931'; $kategori{'9302'} = 'G'; $poststed{'9302'} = 'ROSSFJORDSTRAUMEN';
$postkommune{'9303'} = '1931'; $kategori{'9303'} = 'G'; $poststed{'9303'} = 'SILSAND';
$postkommune{'9304'} = '1927'; $kategori{'9304'} = 'G'; $poststed{'9304'} = 'VANGSVIK';
$postkommune{'9305'} = '1931'; $kategori{'9305'} = 'P'; $poststed{'9305'} = 'FINNSNES';
$postkommune{'9306'} = '1931'; $kategori{'9306'} = 'S'; $poststed{'9306'} = 'FINNSNES';
$postkommune{'9310'} = '1925'; $kategori{'9310'} = 'G'; $poststed{'9310'} = 'SRREISA';
$postkommune{'9311'} = '1926'; $kategori{'9311'} = 'G'; $poststed{'9311'} = 'BRSTADBOTN';
$postkommune{'9315'} = '1925'; $kategori{'9315'} = 'P'; $poststed{'9315'} = 'SRREISA';
$postkommune{'9316'} = '1926'; $kategori{'9316'} = 'P'; $poststed{'9316'} = 'BRSTADBOTN';
$postkommune{'9321'} = '1924'; $kategori{'9321'} = 'G'; $poststed{'9321'} = 'MOEN';
$postkommune{'9322'} = '1924'; $kategori{'9322'} = 'G'; $poststed{'9322'} = 'KARLSTAD';
$postkommune{'9325'} = '1924'; $kategori{'9325'} = 'G'; $poststed{'9325'} = 'BARDUFOSS';
$postkommune{'9326'} = '1924'; $kategori{'9326'} = 'P'; $poststed{'9326'} = 'BARDUFOSS';
$postkommune{'9327'} = '1924'; $kategori{'9327'} = 'P'; $poststed{'9327'} = 'BARDUFOSS';
$postkommune{'9329'} = '1924'; $kategori{'9329'} = 'P'; $poststed{'9329'} = 'MOEN';
$postkommune{'9334'} = '1924'; $kategori{'9334'} = 'G'; $poststed{'9334'} = 'VERBYGD';
$postkommune{'9335'} = '1924'; $kategori{'9335'} = 'P'; $poststed{'9335'} = 'VERBYGD';
$postkommune{'9336'} = '1924'; $kategori{'9336'} = 'G'; $poststed{'9336'} = 'RUNDHAUG';
$postkommune{'9350'} = '1923'; $kategori{'9350'} = 'G'; $poststed{'9350'} = 'SJVEGAN';
$postkommune{'9355'} = '1923'; $kategori{'9355'} = 'P'; $poststed{'9355'} = 'SJVEGAN';
$postkommune{'9357'} = '1920'; $kategori{'9357'} = 'G'; $poststed{'9357'} = 'TENNEVOLL';
$postkommune{'9358'} = '1920'; $kategori{'9358'} = 'P'; $poststed{'9358'} = 'TENNEVOLL';
$postkommune{'9360'} = '1922'; $kategori{'9360'} = 'G'; $poststed{'9360'} = 'BARDU';
$postkommune{'9365'} = '1922'; $kategori{'9365'} = 'P'; $poststed{'9365'} = 'BARDU';
$postkommune{'9370'} = '1931'; $kategori{'9370'} = 'P'; $poststed{'9370'} = 'SILSAND';
$postkommune{'9372'} = '1931'; $kategori{'9372'} = 'G'; $poststed{'9372'} = 'GIBOSTAD';
$postkommune{'9373'} = '1931'; $kategori{'9373'} = 'G'; $poststed{'9373'} = 'BOTNHAMN';
$postkommune{'9379'} = '1928'; $kategori{'9379'} = 'P'; $poststed{'9379'} = 'GRYLLEFJORD';
$postkommune{'9380'} = '1928'; $kategori{'9380'} = 'G'; $poststed{'9380'} = 'GRYLLEFJORD';
$postkommune{'9381'} = '1928'; $kategori{'9381'} = 'G'; $poststed{'9381'} = 'TORSKEN';
$postkommune{'9382'} = '1931'; $kategori{'9382'} = 'P'; $poststed{'9382'} = 'GIBOSTAD';
$postkommune{'9384'} = '1929'; $kategori{'9384'} = 'P'; $poststed{'9384'} = 'SKALAND';
$postkommune{'9385'} = '1929'; $kategori{'9385'} = 'G'; $poststed{'9385'} = 'SKALAND';
$postkommune{'9386'} = '1929'; $kategori{'9386'} = 'G'; $poststed{'9386'} = 'SENJAHOPEN';
$postkommune{'9387'} = '1929'; $kategori{'9387'} = 'P'; $poststed{'9387'} = 'SENJAHOPEN';
$postkommune{'9388'} = '1931'; $kategori{'9388'} = 'B'; $poststed{'9388'} = 'FJORDGARD';
$postkommune{'9389'} = '1931'; $kategori{'9389'} = 'B'; $poststed{'9389'} = 'HUSY I SENJA';
$postkommune{'9391'} = '1927'; $kategori{'9391'} = 'P'; $poststed{'9391'} = 'STONGLANDSEIDET';
$postkommune{'9392'} = '1927'; $kategori{'9392'} = 'G'; $poststed{'9392'} = 'STONGLANDSEIDET';
$postkommune{'9393'} = '1928'; $kategori{'9393'} = 'G'; $poststed{'9393'} = 'FLAKSTADVG';
$postkommune{'9395'} = '1928'; $kategori{'9395'} = 'B'; $poststed{'9395'} = 'KALDFARNES';
$postkommune{'9402'} = '1901'; $kategori{'9402'} = 'G'; $poststed{'9402'} = 'HARSTAD';
$postkommune{'9403'} = '1901'; $kategori{'9403'} = 'G'; $poststed{'9403'} = 'HARSTAD';
$postkommune{'9404'} = '1901'; $kategori{'9404'} = 'G'; $poststed{'9404'} = 'HARSTAD';
$postkommune{'9405'} = '1901'; $kategori{'9405'} = 'G'; $poststed{'9405'} = 'HARSTAD';
$postkommune{'9406'} = '1901'; $kategori{'9406'} = 'G'; $poststed{'9406'} = 'HARSTAD';
$postkommune{'9407'} = '1901'; $kategori{'9407'} = 'G'; $poststed{'9407'} = 'HARSTAD';
$postkommune{'9408'} = '1901'; $kategori{'9408'} = 'G'; $poststed{'9408'} = 'HARSTAD';
$postkommune{'9409'} = '1901'; $kategori{'9409'} = 'G'; $poststed{'9409'} = 'HARSTAD';
$postkommune{'9411'} = '1901'; $kategori{'9411'} = 'G'; $poststed{'9411'} = 'HARSTAD';
$postkommune{'9414'} = '1901'; $kategori{'9414'} = 'G'; $poststed{'9414'} = 'HARSTAD';
$postkommune{'9415'} = '1901'; $kategori{'9415'} = 'B'; $poststed{'9415'} = 'HARSTAD';
$postkommune{'9419'} = '1901'; $kategori{'9419'} = 'G'; $poststed{'9419'} = 'SRVIK';
$postkommune{'9420'} = '1901'; $kategori{'9420'} = 'B'; $poststed{'9420'} = 'LUNDENES';
$postkommune{'9423'} = '1901'; $kategori{'9423'} = 'G'; $poststed{'9423'} = 'GRTAVR';
$postkommune{'9424'} = '1901'; $kategori{'9424'} = 'G'; $poststed{'9424'} = 'KJTTA';
$postkommune{'9425'} = '1915'; $kategori{'9425'} = 'B'; $poststed{'9425'} = 'SANDSY';
$postkommune{'9426'} = '1915'; $kategori{'9426'} = 'B'; $poststed{'9426'} = 'BJARKY';
$postkommune{'9427'} = '1915'; $kategori{'9427'} = 'G'; $poststed{'9427'} = 'MELYVR';
$postkommune{'9430'} = '1901'; $kategori{'9430'} = 'G'; $poststed{'9430'} = 'SANDTORG';
$postkommune{'9436'} = '1852'; $kategori{'9436'} = 'G'; $poststed{'9436'} = 'KONGSVIK';
$postkommune{'9439'} = '1913'; $kategori{'9439'} = 'P'; $poststed{'9439'} = 'EVENSKJER';
$postkommune{'9440'} = '1913'; $kategori{'9440'} = 'G'; $poststed{'9440'} = 'EVENSKJER';
$postkommune{'9441'} = '1852'; $kategori{'9441'} = 'G'; $poststed{'9441'} = 'FJELLDAL';
$postkommune{'9442'} = '1852'; $kategori{'9442'} = 'G'; $poststed{'9442'} = 'RAMSUND';
$postkommune{'9443'} = '1852'; $kategori{'9443'} = 'G'; $poststed{'9443'} = 'MYKLEBOSTAD';
$postkommune{'9444'} = '1852'; $kategori{'9444'} = 'G'; $poststed{'9444'} = 'HOL I TJELDSUND';
$postkommune{'9445'} = '1913'; $kategori{'9445'} = 'G'; $poststed{'9445'} = 'TOVIK';
$postkommune{'9446'} = '1913'; $kategori{'9446'} = 'G'; $poststed{'9446'} = 'GROVFJORD';
$postkommune{'9447'} = '1913'; $kategori{'9447'} = 'P'; $poststed{'9447'} = 'GROVFJORD';
$postkommune{'9448'} = '1852'; $kategori{'9448'} = 'P'; $poststed{'9448'} = 'RAMSUND';
$postkommune{'9450'} = '1917'; $kategori{'9450'} = 'G'; $poststed{'9450'} = 'HAMNVIK';
$postkommune{'9451'} = '1917'; $kategori{'9451'} = 'P'; $poststed{'9451'} = 'HAMNVIK';
$postkommune{'9453'} = '1917'; $kategori{'9453'} = 'G'; $poststed{'9453'} = 'KRKRHAMN';
$postkommune{'9454'} = '1917'; $kategori{'9454'} = 'G'; $poststed{'9454'} = 'NSTAD';
$postkommune{'9455'} = '1917'; $kategori{'9455'} = 'B'; $poststed{'9455'} = 'ENGENES';
$postkommune{'9470'} = '1919'; $kategori{'9470'} = 'G'; $poststed{'9470'} = 'GRATANGEN';
$postkommune{'9471'} = '1919'; $kategori{'9471'} = 'P'; $poststed{'9471'} = 'GRATANGEN';
$postkommune{'9475'} = '1911'; $kategori{'9475'} = 'G'; $poststed{'9475'} = 'BORKENES';
$postkommune{'9476'} = '1911'; $kategori{'9476'} = 'P'; $poststed{'9476'} = 'BORKENES';
$postkommune{'9479'} = '1901'; $kategori{'9479'} = 'S'; $poststed{'9479'} = 'HARSTAD';
$postkommune{'9480'} = '1901'; $kategori{'9480'} = 'S'; $poststed{'9480'} = 'HARSTAD';
$postkommune{'9481'} = '1901'; $kategori{'9481'} = 'P'; $poststed{'9481'} = 'HARSTAD';
$postkommune{'9482'} = '1901'; $kategori{'9482'} = 'P'; $poststed{'9482'} = 'HARSTAD';
$postkommune{'9483'} = '1901'; $kategori{'9483'} = 'P'; $poststed{'9483'} = 'HARSTAD';
$postkommune{'9484'} = '1901'; $kategori{'9484'} = 'P'; $poststed{'9484'} = 'HARSTAD';
$postkommune{'9485'} = '1901'; $kategori{'9485'} = 'P'; $poststed{'9485'} = 'HARSTAD';
$postkommune{'9486'} = '1901'; $kategori{'9486'} = 'P'; $poststed{'9486'} = 'HARSTAD';
$postkommune{'9487'} = '1901'; $kategori{'9487'} = 'P'; $poststed{'9487'} = 'HARSTAD';
$postkommune{'9488'} = '1901'; $kategori{'9488'} = 'P'; $poststed{'9488'} = 'HARSTAD';
$postkommune{'9489'} = '1901'; $kategori{'9489'} = 'P'; $poststed{'9489'} = 'HARSTAD';
$postkommune{'9496'} = '1901'; $kategori{'9496'} = 'P'; $poststed{'9496'} = 'HARSTAD';
$postkommune{'9497'} = '1901'; $kategori{'9497'} = 'P'; $poststed{'9497'} = 'HARSTAD';
$postkommune{'9498'} = '1901'; $kategori{'9498'} = 'P'; $poststed{'9498'} = 'HARSTAD';
$postkommune{'9499'} = '1901'; $kategori{'9499'} = 'P'; $poststed{'9499'} = 'HARSTAD';
$postkommune{'9501'} = '2012'; $kategori{'9501'} = 'P'; $poststed{'9501'} = 'ALTA';
$postkommune{'9502'} = '2012'; $kategori{'9502'} = 'P'; $poststed{'9502'} = 'ALTA';
$postkommune{'9503'} = '2012'; $kategori{'9503'} = 'P'; $poststed{'9503'} = 'ALTA';
$postkommune{'9504'} = '2012'; $kategori{'9504'} = 'P'; $poststed{'9504'} = 'ALTA';
$postkommune{'9505'} = '2012'; $kategori{'9505'} = 'P'; $poststed{'9505'} = 'ALTA';
$postkommune{'9506'} = '2012'; $kategori{'9506'} = 'P'; $poststed{'9506'} = 'ALTA';
$postkommune{'9507'} = '2012'; $kategori{'9507'} = 'P'; $poststed{'9507'} = 'ALTA';
$postkommune{'9508'} = '2012'; $kategori{'9508'} = 'P'; $poststed{'9508'} = 'ALTA';
$postkommune{'9509'} = '2012'; $kategori{'9509'} = 'F'; $poststed{'9509'} = 'ALTA';
$postkommune{'9510'} = '2012'; $kategori{'9510'} = 'G'; $poststed{'9510'} = 'ALTA';
$postkommune{'9511'} = '2012'; $kategori{'9511'} = 'G'; $poststed{'9511'} = 'ALTA';
$postkommune{'9512'} = '2012'; $kategori{'9512'} = 'G'; $poststed{'9512'} = 'ALTA';
$postkommune{'9513'} = '2012'; $kategori{'9513'} = 'G'; $poststed{'9513'} = 'ALTA';
$postkommune{'9514'} = '2012'; $kategori{'9514'} = 'G'; $poststed{'9514'} = 'ALTA';
$postkommune{'9515'} = '2012'; $kategori{'9515'} = 'G'; $poststed{'9515'} = 'ALTA';
$postkommune{'9516'} = '2012'; $kategori{'9516'} = 'G'; $poststed{'9516'} = 'ALTA';
$postkommune{'9517'} = '2012'; $kategori{'9517'} = 'G'; $poststed{'9517'} = 'ALTA';
$postkommune{'9518'} = '2012'; $kategori{'9518'} = 'G'; $poststed{'9518'} = 'ALTA';
$postkommune{'9519'} = '2012'; $kategori{'9519'} = 'G'; $poststed{'9519'} = 'KVIBY';
$postkommune{'9520'} = '2011'; $kategori{'9520'} = 'G'; $poststed{'9520'} = 'KAUTOKEINO';
$postkommune{'9521'} = '2011'; $kategori{'9521'} = 'P'; $poststed{'9521'} = 'KAUTOKEINO';
$postkommune{'9525'} = '2011'; $kategori{'9525'} = 'B'; $poststed{'9525'} = 'MAZE';
$postkommune{'9526'} = '2011'; $kategori{'9526'} = 'G'; $poststed{'9526'} = 'SUOLOVUOPMI';
$postkommune{'9531'} = '2012'; $kategori{'9531'} = 'B'; $poststed{'9531'} = 'KVALFJORD';
$postkommune{'9532'} = '2012'; $kategori{'9532'} = 'B'; $poststed{'9532'} = 'HAKKSTABBEN';
$postkommune{'9533'} = '2012'; $kategori{'9533'} = 'B'; $poststed{'9533'} = 'KONGSHUS';
$postkommune{'9536'} = '2012'; $kategori{'9536'} = 'G'; $poststed{'9536'} = 'KORSFJORDEN';
$postkommune{'9540'} = '2012'; $kategori{'9540'} = 'G'; $poststed{'9540'} = 'TALVIK';
$postkommune{'9545'} = '2012'; $kategori{'9545'} = 'G'; $poststed{'9545'} = 'LANGFJORDBOTN';
$postkommune{'9550'} = '2014'; $kategori{'9550'} = 'G'; $poststed{'9550'} = 'KSFJORD';
$postkommune{'9551'} = '2014'; $kategori{'9551'} = 'P'; $poststed{'9551'} = 'KSFJORD';
$postkommune{'9580'} = '2014'; $kategori{'9580'} = 'B'; $poststed{'9580'} = 'BERGSFJORD';
$postkommune{'9582'} = '2014'; $kategori{'9582'} = 'G'; $poststed{'9582'} = 'NUVSVG';
$postkommune{'9583'} = '2014'; $kategori{'9583'} = 'B'; $poststed{'9583'} = 'LANGFJORDHAMN';
$postkommune{'9584'} = '2014'; $kategori{'9584'} = 'B'; $poststed{'9584'} = 'SR-TVERRFJORD';
$postkommune{'9585'} = '2014'; $kategori{'9585'} = 'G'; $poststed{'9585'} = 'SANDLAND';
$postkommune{'9586'} = '2014'; $kategori{'9586'} = 'G'; $poststed{'9586'} = 'LOPPA';
$postkommune{'9587'} = '2014'; $kategori{'9587'} = 'G'; $poststed{'9587'} = 'SKAVNAKK';
$postkommune{'9590'} = '2015'; $kategori{'9590'} = 'B'; $poststed{'9590'} = 'HASVIK';
$postkommune{'9593'} = '2015'; $kategori{'9593'} = 'B'; $poststed{'9593'} = 'BREIVIKBOTN';
$postkommune{'9595'} = '2015'; $kategori{'9595'} = 'B'; $poststed{'9595'} = 'SRVR';
$postkommune{'9600'} = '2004'; $kategori{'9600'} = 'B'; $poststed{'9600'} = 'HAMMERFEST';
$postkommune{'9609'} = '2004'; $kategori{'9609'} = 'G'; $poststed{'9609'} = 'HNSEBY';
$postkommune{'9610'} = '2004'; $kategori{'9610'} = 'B'; $poststed{'9610'} = 'RYPEFJORD';
$postkommune{'9613'} = '2004'; $kategori{'9613'} = 'S'; $poststed{'9613'} = 'HAMMERFEST';
$postkommune{'9615'} = '2004'; $kategori{'9615'} = 'P'; $poststed{'9615'} = 'HAMMERFEST';
$postkommune{'9616'} = '2004'; $kategori{'9616'} = 'P'; $poststed{'9616'} = 'HAMMERFEST';
$postkommune{'9620'} = '2017'; $kategori{'9620'} = 'G'; $poststed{'9620'} = 'KVALSUND';
$postkommune{'9621'} = '2017'; $kategori{'9621'} = 'P'; $poststed{'9621'} = 'KVALSUND';
$postkommune{'9624'} = '2017'; $kategori{'9624'} = 'G'; $poststed{'9624'} = 'REVSNESHAMN';
$postkommune{'9650'} = '2004'; $kategori{'9650'} = 'B'; $poststed{'9650'} = 'AKKARFJORD';
$postkommune{'9653'} = '2004'; $kategori{'9653'} = 'G'; $poststed{'9653'} = 'HELLEFJORD';
$postkommune{'9657'} = '2004'; $kategori{'9657'} = 'B'; $poststed{'9657'} = 'KRHAMN';
$postkommune{'9664'} = '2004'; $kategori{'9664'} = 'B'; $poststed{'9664'} = 'SANDYBOTN';
$postkommune{'9670'} = '2018'; $kategori{'9670'} = 'B'; $poststed{'9670'} = 'TUFJORD';
$postkommune{'9672'} = '2018'; $kategori{'9672'} = 'B'; $poststed{'9672'} = 'INGY';
$postkommune{'9690'} = '2018'; $kategori{'9690'} = 'G'; $poststed{'9690'} = 'HAVYSUND';
$postkommune{'9691'} = '2018'; $kategori{'9691'} = 'P'; $poststed{'9691'} = 'HAVYSUND';
$postkommune{'9692'} = '2018'; $kategori{'9692'} = 'B'; $poststed{'9692'} = 'MSY';
$postkommune{'9700'} = '2020'; $kategori{'9700'} = 'G'; $poststed{'9700'} = 'LAKSELV';
$postkommune{'9709'} = '2020'; $kategori{'9709'} = 'G'; $poststed{'9709'} = 'PORSANGMOEN';
$postkommune{'9710'} = '2020'; $kategori{'9710'} = 'G'; $poststed{'9710'} = 'INDRE BILLEFJORD';
$postkommune{'9711'} = '2020'; $kategori{'9711'} = 'P'; $poststed{'9711'} = 'LAKSELV';
$postkommune{'9712'} = '2020'; $kategori{'9712'} = 'S'; $poststed{'9712'} = 'LAKSELV';
$postkommune{'9713'} = '2020'; $kategori{'9713'} = 'B'; $poststed{'9713'} = 'RUSSENES';
$postkommune{'9714'} = '2018'; $kategori{'9714'} = 'G'; $poststed{'9714'} = 'SNEFJORD';
$postkommune{'9715'} = '2017'; $kategori{'9715'} = 'G'; $poststed{'9715'} = 'KOKELV';
$postkommune{'9716'} = '2020'; $kategori{'9716'} = 'B'; $poststed{'9716'} = 'BRSELV';
$postkommune{'9717'} = '2022'; $kategori{'9717'} = 'B'; $poststed{'9717'} = 'VEIDNESKLUBBEN';
$postkommune{'9722'} = '2020'; $kategori{'9722'} = 'B'; $poststed{'9722'} = 'SKOGANVARRE';
$postkommune{'9730'} = '2021'; $kategori{'9730'} = 'G'; $poststed{'9730'} = 'KARASJOK';
$postkommune{'9735'} = '2021'; $kategori{'9735'} = 'P'; $poststed{'9735'} = 'KARASJOK';
$postkommune{'9740'} = '2022'; $kategori{'9740'} = 'B'; $poststed{'9740'} = 'LEBESBY';
$postkommune{'9742'} = '2022'; $kategori{'9742'} = 'B'; $poststed{'9742'} = 'KUNES';
$postkommune{'9750'} = '2019'; $kategori{'9750'} = 'G'; $poststed{'9750'} = 'HONNINGSVG';
$postkommune{'9751'} = '2019'; $kategori{'9751'} = 'P'; $poststed{'9751'} = 'HONNINGSVG';
$postkommune{'9755'} = '2019'; $kategori{'9755'} = 'S'; $poststed{'9755'} = 'HONNINGSVG';
$postkommune{'9760'} = '2019'; $kategori{'9760'} = 'G'; $poststed{'9760'} = 'NORDVGEN';
$postkommune{'9763'} = '2019'; $kategori{'9763'} = 'B'; $poststed{'9763'} = 'SKARSVG';
$postkommune{'9764'} = '2019'; $kategori{'9764'} = 'G'; $poststed{'9764'} = 'NORDKAPP';
$postkommune{'9765'} = '2019'; $kategori{'9765'} = 'B'; $poststed{'9765'} = 'GJESVR';
$postkommune{'9768'} = '2019'; $kategori{'9768'} = 'G'; $poststed{'9768'} = 'REPVG';
$postkommune{'9770'} = '2023'; $kategori{'9770'} = 'B'; $poststed{'9770'} = 'MEHAMN';
$postkommune{'9771'} = '2023'; $kategori{'9771'} = 'B'; $poststed{'9771'} = 'SKJNES';
$postkommune{'9772'} = '2023'; $kategori{'9772'} = 'G'; $poststed{'9772'} = 'LANGFJORDNES';
$postkommune{'9773'} = '2023'; $kategori{'9773'} = 'B'; $poststed{'9773'} = 'NERVEI';
$postkommune{'9775'} = '2023'; $kategori{'9775'} = 'B'; $poststed{'9775'} = 'GAMVIK';
$postkommune{'9782'} = '2022'; $kategori{'9782'} = 'B'; $poststed{'9782'} = 'DYFJORD';
$postkommune{'9783'} = '2022'; $kategori{'9783'} = 'G'; $poststed{'9783'} = 'NORDMANNSET I LAKSEFJORD';
$postkommune{'9790'} = '2022'; $kategori{'9790'} = 'B'; $poststed{'9790'} = 'KJLLEFJORD';
$postkommune{'9800'} = '2003'; $kategori{'9800'} = 'G'; $poststed{'9800'} = 'VADS';
$postkommune{'9802'} = '2003'; $kategori{'9802'} = 'G'; $poststed{'9802'} = 'VESTRE JAKOBSELV';
$postkommune{'9810'} = '2003'; $kategori{'9810'} = 'P'; $poststed{'9810'} = 'VESTRE JAKOBSELV';
$postkommune{'9811'} = '2003'; $kategori{'9811'} = 'P'; $poststed{'9811'} = 'VADS';
$postkommune{'9815'} = '2003'; $kategori{'9815'} = 'S'; $poststed{'9815'} = 'VADS';
$postkommune{'9820'} = '2027'; $kategori{'9820'} = 'P'; $poststed{'9820'} = 'VARANGERBOTN';
$postkommune{'9826'} = '2025'; $kategori{'9826'} = 'G'; $poststed{'9826'} = 'SIRMA';
$postkommune{'9840'} = '2027'; $kategori{'9840'} = 'G'; $poststed{'9840'} = 'VARANGERBOTN';
$postkommune{'9845'} = '2025'; $kategori{'9845'} = 'G'; $poststed{'9845'} = 'TANA';
$postkommune{'9846'} = '2025'; $kategori{'9846'} = 'P'; $poststed{'9846'} = 'TANA';
$postkommune{'9900'} = '2030'; $kategori{'9900'} = 'G'; $poststed{'9900'} = 'KIRKENES';
$postkommune{'9910'} = '2030'; $kategori{'9910'} = 'G'; $poststed{'9910'} = 'BJRNEVATN';
$postkommune{'9912'} = '2030'; $kategori{'9912'} = 'G'; $poststed{'9912'} = 'HESSENG';
$postkommune{'9914'} = '2030'; $kategori{'9914'} = 'P'; $poststed{'9914'} = 'BJRNEVATN';
$postkommune{'9915'} = '2030'; $kategori{'9915'} = 'P'; $poststed{'9915'} = 'KIRKENES';
$postkommune{'9916'} = '2030'; $kategori{'9916'} = 'P'; $poststed{'9916'} = 'HESSENG';
$postkommune{'9917'} = '2030'; $kategori{'9917'} = 'S'; $poststed{'9917'} = 'KIRKENES';
$postkommune{'9925'} = '2030'; $kategori{'9925'} = 'G'; $poststed{'9925'} = 'SVANVIK';
$postkommune{'9930'} = '2030'; $kategori{'9930'} = 'G'; $poststed{'9930'} = 'NEIDEN';
$postkommune{'9934'} = '2030'; $kategori{'9934'} = 'G'; $poststed{'9934'} = 'BUGYFJORD';
$postkommune{'9935'} = '2030'; $kategori{'9935'} = 'B'; $poststed{'9935'} = 'BUGYNES';
$postkommune{'9950'} = '2002'; $kategori{'9950'} = 'G'; $poststed{'9950'} = 'VARD';
$postkommune{'9951'} = '2002'; $kategori{'9951'} = 'P'; $poststed{'9951'} = 'VARD';
$postkommune{'9960'} = '2002'; $kategori{'9960'} = 'B'; $poststed{'9960'} = 'KIBERG';
$postkommune{'9980'} = '2024'; $kategori{'9980'} = 'G'; $poststed{'9980'} = 'BERLEVG';
$postkommune{'9981'} = '2024'; $kategori{'9981'} = 'P'; $poststed{'9981'} = 'BERLEVG';
$postkommune{'9982'} = '2024'; $kategori{'9982'} = 'B'; $poststed{'9982'} = 'KONGSFJORD';
$postkommune{'9990'} = '2028'; $kategori{'9990'} = 'G'; $poststed{'9990'} = 'BTSFJORD';
$postkommune{'9991'} = '2028'; $kategori{'9991'} = 'P'; $poststed{'9991'} = 'BTSFJORD';

$kommunenavn{'0101'} = 'HALDEN';
$kommunenavn{'0104'} = 'MOSS';
$kommunenavn{'0105'} = 'SARPSBORG';
$kommunenavn{'0106'} = 'FREDRIKSTAD';
$kommunenavn{'0111'} = 'HVALER';
$kommunenavn{'0118'} = 'AREMARK';
$kommunenavn{'0119'} = 'MARKER';
$kommunenavn{'0121'} = 'RMSKOG';
$kommunenavn{'0122'} = 'TRGSTAD';
$kommunenavn{'0123'} = 'SPYDEBERG';
$kommunenavn{'0124'} = 'ASKIM';
$kommunenavn{'0125'} = 'EIDSBERG';
$kommunenavn{'0127'} = 'SKIPTVET';
$kommunenavn{'0128'} = 'RAKKESTAD';
$kommunenavn{'0135'} = 'RDE';
$kommunenavn{'0136'} = 'RYGGE';
$kommunenavn{'0137'} = 'VLER';
$kommunenavn{'0138'} = 'HOBL';
$kommunenavn{'0211'} = 'VESTBY';
$kommunenavn{'0213'} = 'SKI';
$kommunenavn{'0214'} = 'S';
$kommunenavn{'0215'} = 'FROGN';
$kommunenavn{'0216'} = 'NESODDEN';
$kommunenavn{'0217'} = 'OPPEGRD';
$kommunenavn{'0219'} = 'BRUM';
$kommunenavn{'0220'} = 'ASKER';
$kommunenavn{'0221'} = 'AURSKOG HLAND';
$kommunenavn{'0226'} = 'SRUM';
$kommunenavn{'0227'} = 'FET';
$kommunenavn{'0228'} = 'RLINGEN';
$kommunenavn{'0229'} = 'ENEBAKK';
$kommunenavn{'0230'} = 'LRENSKOG';
$kommunenavn{'0231'} = 'SKEDSMO';
$kommunenavn{'0233'} = 'NITTEDAL';
$kommunenavn{'0234'} = 'GJERDRUM';
$kommunenavn{'0235'} = 'ULLENSAKER';
$kommunenavn{'0236'} = 'NES';
$kommunenavn{'0237'} = 'EIDSVOLL';
$kommunenavn{'0238'} = 'NANNESTAD';
$kommunenavn{'0239'} = 'HURDAL';
$kommunenavn{'0301'} = 'OSLO';
$kommunenavn{'0402'} = 'KONGSVINGER';
$kommunenavn{'0403'} = 'HAMAR';
$kommunenavn{'0412'} = 'RINGSAKER';
$kommunenavn{'0415'} = 'LTEN';
$kommunenavn{'0417'} = 'STANGE';
$kommunenavn{'0418'} = 'NORD-ODAL';
$kommunenavn{'0419'} = 'SR-ODAL';
$kommunenavn{'0420'} = 'EIDSKOG';
$kommunenavn{'0423'} = 'GRUE';
$kommunenavn{'0425'} = 'SNES';
$kommunenavn{'0426'} = 'VLER';
$kommunenavn{'0427'} = 'ELVERUM';
$kommunenavn{'0428'} = 'TRYSIL';
$kommunenavn{'0429'} = 'MOT';
$kommunenavn{'0430'} = 'STOR-ELVDAL';
$kommunenavn{'0432'} = 'RENDALEN';
$kommunenavn{'0434'} = 'ENGERDAL';
$kommunenavn{'0436'} = 'TOLGA';
$kommunenavn{'0437'} = 'TYNSET';
$kommunenavn{'0438'} = 'ALVDAL';
$kommunenavn{'0439'} = 'FOLLDAL';
$kommunenavn{'0441'} = 'OS (HEDMARK)';
$kommunenavn{'0501'} = 'LILLEHAMMER';
$kommunenavn{'0502'} = 'GJVIK';
$kommunenavn{'0511'} = 'DOVRE';
$kommunenavn{'0512'} = 'LESJA';
$kommunenavn{'0513'} = 'SKJK';
$kommunenavn{'0514'} = 'LOM';
$kommunenavn{'0515'} = 'VG';
$kommunenavn{'0516'} = 'NORD-FRON';
$kommunenavn{'0517'} = 'SEL';
$kommunenavn{'0519'} = 'SR-FRON';
$kommunenavn{'0520'} = 'RINGEBU';
$kommunenavn{'0521'} = 'YER';
$kommunenavn{'0522'} = 'GAUSDAL';
$kommunenavn{'0528'} = 'STRE TOTEN';
$kommunenavn{'0529'} = 'VESTRE TOTEN';
$kommunenavn{'0532'} = 'JEVNAKER';
$kommunenavn{'0533'} = 'LUNNER';
$kommunenavn{'0534'} = 'GRAN';
$kommunenavn{'0536'} = 'SNDRE LAND';
$kommunenavn{'0538'} = 'NORDRE LAND';
$kommunenavn{'0540'} = 'SR-AURDAL';
$kommunenavn{'0541'} = 'ETNEDAL';
$kommunenavn{'0542'} = 'NORD-AURDAL';
$kommunenavn{'0543'} = 'VESTRE SLIDRE';
$kommunenavn{'0544'} = 'YSTRE SLIDRE';
$kommunenavn{'0545'} = 'VANG';
$kommunenavn{'0602'} = 'DRAMMEN';
$kommunenavn{'0604'} = 'KONGSBERG';
$kommunenavn{'0605'} = 'RINGERIKE';
$kommunenavn{'0612'} = 'HOLE';
$kommunenavn{'0615'} = 'FL';
$kommunenavn{'0616'} = 'NES';
$kommunenavn{'0617'} = 'GOL';
$kommunenavn{'0618'} = 'HEMSEDAL';
$kommunenavn{'0619'} = 'L';
$kommunenavn{'0620'} = 'HOL';
$kommunenavn{'0621'} = 'SIGDAL';
$kommunenavn{'0622'} = 'KRDSHERAD';
$kommunenavn{'0623'} = 'MODUM';
$kommunenavn{'0624'} = 'VRE EIKER';
$kommunenavn{'0625'} = 'NEDRE EIKER';
$kommunenavn{'0626'} = 'LIER';
$kommunenavn{'0627'} = 'RYKEN';
$kommunenavn{'0628'} = 'HURUM';
$kommunenavn{'0631'} = 'FLESBERG';
$kommunenavn{'0632'} = 'ROLLAG';
$kommunenavn{'0633'} = 'NORE OG UVDAL';
$kommunenavn{'0701'} = 'HORTEN';
$kommunenavn{'0702'} = 'HOLMESTRAND';
$kommunenavn{'0704'} = 'TNSBERG';
$kommunenavn{'0706'} = 'SANDEFJORD';
$kommunenavn{'0709'} = 'LARVIK';
$kommunenavn{'0711'} = 'SVELVIK';
$kommunenavn{'0713'} = 'SANDE (V.)';
$kommunenavn{'0714'} = 'HOF';
$kommunenavn{'0716'} = 'RE';
$kommunenavn{'0719'} = 'ANDEBU';
$kommunenavn{'0720'} = 'STOKKE';
$kommunenavn{'0722'} = 'NTTERY';
$kommunenavn{'0723'} = 'TJME';
$kommunenavn{'0728'} = 'LARDAL';
$kommunenavn{'0805'} = 'PORSGRUNN';
$kommunenavn{'0806'} = 'SKIEN';
$kommunenavn{'0807'} = 'NOTODDEN';
$kommunenavn{'0811'} = 'SILJAN';
$kommunenavn{'0814'} = 'BAMBLE';
$kommunenavn{'0815'} = 'KRAGER';
$kommunenavn{'0817'} = 'DRANGEDAL';
$kommunenavn{'0819'} = 'NOME';
$kommunenavn{'0821'} = 'B (TEL.)';
$kommunenavn{'0822'} = 'SAUHERAD';
$kommunenavn{'0826'} = 'TINN';
$kommunenavn{'0827'} = 'HJARTDAL';
$kommunenavn{'0828'} = 'SELJORD';
$kommunenavn{'0829'} = 'KVITESEID';
$kommunenavn{'0830'} = 'NISSEDAL';
$kommunenavn{'0831'} = 'FYRESDAL';
$kommunenavn{'0833'} = 'TOKKE';
$kommunenavn{'0834'} = 'VINJE';
$kommunenavn{'0901'} = 'RISR';
$kommunenavn{'0904'} = 'GRIMSTAD';
$kommunenavn{'0906'} = 'ARENDAL';
$kommunenavn{'0911'} = 'GJERSTAD';
$kommunenavn{'0912'} = 'VEGRSHEI';
$kommunenavn{'0914'} = 'TVEDESTRAND';
$kommunenavn{'0919'} = 'FROLAND';
$kommunenavn{'0926'} = 'LILLESAND';
$kommunenavn{'0928'} = 'BIRKENES';
$kommunenavn{'0929'} = 'MLI';
$kommunenavn{'0935'} = 'IVELAND';
$kommunenavn{'0937'} = 'EVJE OG HORNNES';
$kommunenavn{'0938'} = 'BYGLAND';
$kommunenavn{'0940'} = 'VALLE';
$kommunenavn{'0941'} = 'BYKLE';
$kommunenavn{'1001'} = 'KRISTIANSAND';
$kommunenavn{'1002'} = 'MANDAL';
$kommunenavn{'1003'} = 'FARSUND';
$kommunenavn{'1004'} = 'FLEKKEFJORD';
$kommunenavn{'1014'} = 'VENNESLA';
$kommunenavn{'1017'} = 'SONGDALEN';
$kommunenavn{'1018'} = 'SGNE';
$kommunenavn{'1021'} = 'MARNARDAL';
$kommunenavn{'1026'} = 'SERAL';
$kommunenavn{'1027'} = 'AUDNEDAL';
$kommunenavn{'1029'} = 'LINDESNES';
$kommunenavn{'1032'} = 'LYNGDAL';
$kommunenavn{'1034'} = 'HGEBOSTAD';
$kommunenavn{'1037'} = 'KVINESDAL';
$kommunenavn{'1046'} = 'SIRDAL';
$kommunenavn{'1101'} = 'EIGERSUND';
$kommunenavn{'1102'} = 'SANDNES';
$kommunenavn{'1103'} = 'STAVANGER';
$kommunenavn{'1106'} = 'HAUGESUND';
$kommunenavn{'1111'} = 'SOKNDAL';
$kommunenavn{'1112'} = 'LUND';
$kommunenavn{'1114'} = 'BJERKREIM';
$kommunenavn{'1119'} = 'H';
$kommunenavn{'1120'} = 'KLEPP';
$kommunenavn{'1121'} = 'TIME';
$kommunenavn{'1122'} = 'GJESDAL';
$kommunenavn{'1124'} = 'SOLA';
$kommunenavn{'1127'} = 'RANDABERG';
$kommunenavn{'1129'} = 'FORSAND';
$kommunenavn{'1130'} = 'STRAND';
$kommunenavn{'1133'} = 'HJELMELAND';
$kommunenavn{'1134'} = 'SULDAL';
$kommunenavn{'1135'} = 'SAUDA';
$kommunenavn{'1141'} = 'FINNY';
$kommunenavn{'1142'} = 'RENNESY';
$kommunenavn{'1144'} = 'KVITSY';
$kommunenavn{'1145'} = 'BOKN';
$kommunenavn{'1146'} = 'TYSVR';
$kommunenavn{'1149'} = 'KARMY';
$kommunenavn{'1151'} = 'UTSIRA';
$kommunenavn{'1160'} = 'VINDAFJORD';
$kommunenavn{'1201'} = 'BERGEN';
$kommunenavn{'1211'} = 'ETNE';
$kommunenavn{'1216'} = 'SVEIO';
$kommunenavn{'1219'} = 'BMLO';
$kommunenavn{'1221'} = 'STORD';
$kommunenavn{'1222'} = 'FITJAR';
$kommunenavn{'1223'} = 'TYSNES';
$kommunenavn{'1224'} = 'KVINNHERAD';
$kommunenavn{'1227'} = 'JONDAL';
$kommunenavn{'1228'} = 'ODDA';
$kommunenavn{'1231'} = 'ULLENSVANG';
$kommunenavn{'1232'} = 'EIDFJORD';
$kommunenavn{'1233'} = 'ULVIK';
$kommunenavn{'1234'} = 'GRANVIN';
$kommunenavn{'1235'} = 'VOSS';
$kommunenavn{'1238'} = 'KVAM';
$kommunenavn{'1241'} = 'FUSA';
$kommunenavn{'1242'} = 'SAMNANGER';
$kommunenavn{'1243'} = 'OS (HORDALAND)';
$kommunenavn{'1244'} = 'AUSTEVOLL';
$kommunenavn{'1245'} = 'SUND';
$kommunenavn{'1246'} = 'FJELL';
$kommunenavn{'1247'} = 'ASKY';
$kommunenavn{'1251'} = 'VAKSDAL';
$kommunenavn{'1252'} = 'MODALEN';
$kommunenavn{'1253'} = 'OSTERY';
$kommunenavn{'1256'} = 'MELAND';
$kommunenavn{'1259'} = 'YGARDEN';
$kommunenavn{'1260'} = 'RADY';
$kommunenavn{'1263'} = 'LINDS';
$kommunenavn{'1264'} = 'AUSTRHEIM';
$kommunenavn{'1265'} = 'FEDJE';
$kommunenavn{'1266'} = 'MASFJORDEN';
$kommunenavn{'1401'} = 'FLORA';
$kommunenavn{'1411'} = 'GULEN';
$kommunenavn{'1412'} = 'SOLUND';
$kommunenavn{'1413'} = 'HYLLESTAD';
$kommunenavn{'1416'} = 'HYANGER';
$kommunenavn{'1417'} = 'VIK';
$kommunenavn{'1418'} = 'BALESTRAND';
$kommunenavn{'1419'} = 'LEIKANGER';
$kommunenavn{'1420'} = 'SOGNDAL';
$kommunenavn{'1421'} = 'AURLAND';
$kommunenavn{'1422'} = 'LRDAL';
$kommunenavn{'1424'} = 'RDAL';
$kommunenavn{'1426'} = 'LUSTER';
$kommunenavn{'1428'} = 'ASKVOLL';
$kommunenavn{'1429'} = 'FJALER';
$kommunenavn{'1430'} = 'GAULAR';
$kommunenavn{'1431'} = 'JLSTER';
$kommunenavn{'1432'} = 'FRDE';
$kommunenavn{'1433'} = 'NAUSTDAL';
$kommunenavn{'1438'} = 'BREMANGER';
$kommunenavn{'1439'} = 'VGSY';
$kommunenavn{'1441'} = 'SELJE';
$kommunenavn{'1443'} = 'EID';
$kommunenavn{'1444'} = 'HORNINDAL';
$kommunenavn{'1445'} = 'GLOPPEN';
$kommunenavn{'1449'} = 'STRYN';
$kommunenavn{'1502'} = 'MOLDE';
$kommunenavn{'1503'} = 'KRISTIANSUND';
$kommunenavn{'1504'} = 'LESUND';
$kommunenavn{'1511'} = 'VANYLVEN';
$kommunenavn{'1514'} = 'SANDE (M.R.)';
$kommunenavn{'1515'} = 'HERY (M.R.)';
$kommunenavn{'1516'} = 'ULSTEIN';
$kommunenavn{'1517'} = 'HAREID';
$kommunenavn{'1519'} = 'VOLDA';
$kommunenavn{'1520'} = 'RSTA';
$kommunenavn{'1523'} = 'RSKOG';
$kommunenavn{'1524'} = 'NORDDAL';
$kommunenavn{'1525'} = 'STRANDA';
$kommunenavn{'1526'} = 'STORDAL';
$kommunenavn{'1528'} = 'SYKKYLVEN';
$kommunenavn{'1529'} = 'SKODJE';
$kommunenavn{'1531'} = 'SULA';
$kommunenavn{'1532'} = 'GISKE';
$kommunenavn{'1534'} = 'HARAM';
$kommunenavn{'1535'} = 'VESTNES';
$kommunenavn{'1539'} = 'RAUMA';
$kommunenavn{'1543'} = 'NESSET';
$kommunenavn{'1545'} = 'MIDSUND';
$kommunenavn{'1546'} = 'SANDY';
$kommunenavn{'1547'} = 'AUKRA';
$kommunenavn{'1548'} = 'FRNA';
$kommunenavn{'1551'} = 'EIDE';
$kommunenavn{'1554'} = 'AVERY';
$kommunenavn{'1556'} = 'FREI';
$kommunenavn{'1557'} = 'GJEMNES';
$kommunenavn{'1560'} = 'TINGVOLL';
$kommunenavn{'1563'} = 'SUNNDAL';
$kommunenavn{'1566'} = 'SURNADAL';
$kommunenavn{'1567'} = 'RINDAL';
$kommunenavn{'1571'} = 'HALSA';
$kommunenavn{'1573'} = 'SMLA';
$kommunenavn{'1576'} = 'AURE';
$kommunenavn{'1601'} = 'TRONDHEIM';
$kommunenavn{'1612'} = 'HEMNE';
$kommunenavn{'1613'} = 'SNILLFJORD';
$kommunenavn{'1617'} = 'HITRA';
$kommunenavn{'1620'} = 'FRYA';
$kommunenavn{'1621'} = 'RLAND';
$kommunenavn{'1622'} = 'AGDENES';
$kommunenavn{'1624'} = 'RISSA';
$kommunenavn{'1627'} = 'BJUGN';
$kommunenavn{'1630'} = 'FJORD';
$kommunenavn{'1632'} = 'ROAN';
$kommunenavn{'1633'} = 'OSEN';
$kommunenavn{'1634'} = 'OPPDAL';
$kommunenavn{'1635'} = 'RENNEBU';
$kommunenavn{'1636'} = 'MELDAL';
$kommunenavn{'1638'} = 'ORKDAL';
$kommunenavn{'1640'} = 'RROS';
$kommunenavn{'1644'} = 'HOLTLEN';
$kommunenavn{'1648'} = 'MIDTRE GAULDAL';
$kommunenavn{'1653'} = 'MELHUS';
$kommunenavn{'1657'} = 'SKAUN';
$kommunenavn{'1662'} = 'KLBU';
$kommunenavn{'1663'} = 'MALVIK';
$kommunenavn{'1664'} = 'SELBU';
$kommunenavn{'1665'} = 'TYDAL';
$kommunenavn{'1702'} = 'STEINKJER';
$kommunenavn{'1703'} = 'NAMSOS';
$kommunenavn{'1711'} = 'MERKER';
$kommunenavn{'1714'} = 'STJRDAL';
$kommunenavn{'1717'} = 'FROSTA';
$kommunenavn{'1718'} = 'LEKSVIK';
$kommunenavn{'1719'} = 'LEVANGER';
$kommunenavn{'1721'} = 'VERDAL';
$kommunenavn{'1723'} = 'MOSVIK';
$kommunenavn{'1724'} = 'VERRAN';
$kommunenavn{'1725'} = 'NAMDALSEID';
$kommunenavn{'1729'} = 'INDERY';
$kommunenavn{'1736'} = 'SNSA';
$kommunenavn{'1738'} = 'LIERNE';
$kommunenavn{'1739'} = 'RYRVIK';
$kommunenavn{'1740'} = 'NAMSSKOGAN';
$kommunenavn{'1742'} = 'GRONG';
$kommunenavn{'1743'} = 'HYLANDET';
$kommunenavn{'1744'} = 'OVERHALLA';
$kommunenavn{'1748'} = 'FOSNES';
$kommunenavn{'1749'} = 'FLATANGER';
$kommunenavn{'1750'} = 'VIKNA';
$kommunenavn{'1751'} = 'NRY';
$kommunenavn{'1755'} = 'LEKA';
$kommunenavn{'1804'} = 'BOD';
$kommunenavn{'1805'} = 'NARVIK';
$kommunenavn{'1811'} = 'BINDAL';
$kommunenavn{'1812'} = 'SMNA';
$kommunenavn{'1813'} = 'BRNNY';
$kommunenavn{'1815'} = 'VEGA';
$kommunenavn{'1816'} = 'VEVELSTAD';
$kommunenavn{'1818'} = 'HERY (N.)';
$kommunenavn{'1820'} = 'ALSTAHAUG';
$kommunenavn{'1822'} = 'LEIRFJORD';
$kommunenavn{'1824'} = 'VEFSN';
$kommunenavn{'1825'} = 'GRANE';
$kommunenavn{'1826'} = 'HATTFJELLDAL';
$kommunenavn{'1827'} = 'DNNA';
$kommunenavn{'1828'} = 'NESNA';
$kommunenavn{'1832'} = 'HEMNES';
$kommunenavn{'1833'} = 'RANA';
$kommunenavn{'1834'} = 'LURY';
$kommunenavn{'1835'} = 'TRNA';
$kommunenavn{'1836'} = 'RDY';
$kommunenavn{'1837'} = 'MELY';
$kommunenavn{'1838'} = 'GILDESKL';
$kommunenavn{'1839'} = 'BEIARN';
$kommunenavn{'1840'} = 'SALTDAL';
$kommunenavn{'1841'} = 'FAUSKE';
$kommunenavn{'1845'} = 'SRFOLD';
$kommunenavn{'1848'} = 'STEIGEN';
$kommunenavn{'1849'} = 'HAMARY';
$kommunenavn{'1850'} = 'TYSFJORD';
$kommunenavn{'1851'} = 'LDINGEN';
$kommunenavn{'1852'} = 'TJELDSUND';
$kommunenavn{'1853'} = 'EVENES';
$kommunenavn{'1854'} = 'BALLANGEN';
$kommunenavn{'1856'} = 'RST';
$kommunenavn{'1857'} = 'VRY';
$kommunenavn{'1859'} = 'FLAKSTAD';
$kommunenavn{'1860'} = 'VESTVGY';
$kommunenavn{'1865'} = 'VGAN';
$kommunenavn{'1866'} = 'HADSEL';
$kommunenavn{'1867'} = 'B (N.)';
$kommunenavn{'1868'} = 'KSNES';
$kommunenavn{'1870'} = 'SORTLAND';
$kommunenavn{'1871'} = 'ANDY';
$kommunenavn{'1874'} = 'MOSKENES';
$kommunenavn{'1901'} = 'HARSTAD';
$kommunenavn{'1902'} = 'TROMS';
$kommunenavn{'1911'} = 'KVFJORD';
$kommunenavn{'1913'} = 'SKNLAND';
$kommunenavn{'1915'} = 'BJARKY';
$kommunenavn{'1917'} = 'IBESTAD';
$kommunenavn{'1919'} = 'GRATANGEN';
$kommunenavn{'1920'} = 'LAVANGEN';
$kommunenavn{'1922'} = 'BARDU';
$kommunenavn{'1923'} = 'SALANGEN';
$kommunenavn{'1924'} = 'MLSELV';
$kommunenavn{'1925'} = 'SRREISA';
$kommunenavn{'1926'} = 'DYRY';
$kommunenavn{'1927'} = 'TRANY';
$kommunenavn{'1928'} = 'TORSKEN';
$kommunenavn{'1929'} = 'BERG';
$kommunenavn{'1931'} = 'LENVIK';
$kommunenavn{'1933'} = 'BALSFJORD';
$kommunenavn{'1936'} = 'KARLSY';
$kommunenavn{'1938'} = 'LYNGEN';
$kommunenavn{'1939'} = 'STORFJORD';
$kommunenavn{'1940'} = 'GIVUOTNA KFJORD';
$kommunenavn{'1941'} = 'SKJERVY';
$kommunenavn{'1942'} = 'NORDREISA';
$kommunenavn{'1943'} = 'KVNANGEN';
$kommunenavn{'2002'} = 'VARD';
$kommunenavn{'2003'} = 'VADS';
$kommunenavn{'2004'} = 'HAMMERFEST';
$kommunenavn{'2011'} = 'GUOVDAGEAIDNU KAUTOKEINO';
$kommunenavn{'2012'} = 'ALTA';
$kommunenavn{'2014'} = 'LOPPA';
$kommunenavn{'2015'} = 'HASVIK';
$kommunenavn{'2017'} = 'KVALSUND';
$kommunenavn{'2018'} = 'MSY';
$kommunenavn{'2019'} = 'NORDKAPP';
$kommunenavn{'2020'} = 'PORSANGER PORSNGU PORSANKI';
$kommunenavn{'2021'} = 'KARASJOHKA KARASJOK';
$kommunenavn{'2022'} = 'LEBESBY';
$kommunenavn{'2023'} = 'GAMVIK';
$kommunenavn{'2024'} = 'BERLEVG';
$kommunenavn{'2025'} = 'DEATNU TANA';
$kommunenavn{'2027'} = 'UNJARGGA NESSEBY';
$kommunenavn{'2028'} = 'BTSFJORD';
$kommunenavn{'2030'} = 'SR-VARANGER';
$kommunenavn{'2111'} = 'SPITSBERGEN';
$kommunenavn{'2121'} = 'BJRNYA';
$kommunenavn{'2131'} = 'HOPEN';
$kommunenavn{'2211'} = 'JAN MAYEN';

## bin/mkpostalinfo end

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

Geo::postcodes::NO - Norwegian postal codes with names

=head1 SYNOPSIS

This module can be used object oriented, or as procedures.
Take your pick.

=head2 OBJECT ORIENTED

use Geo::postcodes::NO qw(valid);

my $pnr = '1178'; # My postal code.

if (valid($pnr)) # A valid postal code?
{
  my $P = Geo::postcodes::NO-E<gt>new($pnr);

  print "Postcode"        '" . $P->$pnr              . "'.\n";
  print "Postal location: '" . $P->location_of       . "'.\n";
  print "Borough number:  '" . $P->borough_number_of . "'.\n";
  print "Borough:         '" . $P->borough_of        . "'.\n";
  print "County:          '" . $P->county            . "'.\n";
  print "Postcode type:   '" . $P->type              . "'.\n"; 
}

The test for a valid postal code can also be expressed this way:

my $P = Geo::postcodes::NO-E<gt>new($pnr);

if ($P) { ... }

=head2 PROCEDURES

use Geo::postcodes::NO ':all';

my $postcode = "1178";

if (valid($postcode))
{
  print "Postcode"        '" . $postcode . "'.\n";
  print "Postal location: '" . location_of($postcode). "'.\n";
  print "Borough number:  '" . borough_number_of($postcode). "'.\n";
  print "Borough:         '" . borough_of($postcode). "'.\n";
  print "County:          '" . county_of($postcode). "'.\n";
  print "Postcode type:   '" . type_of($postcode). "'.\n"; 
}

=head1 ABSTRACT

Geo::postcodes::NO - Perl extension for the mapping between norwegian postal
codes, postal names, and the local administrative entities of boroughs
(kommuner) and counties (fylker).

=head1 DESCRIPTION

Tired og entering the postal name all the time? This is not necessary, as
it is uniquely defined from the postal code. Request the postal code only,
and use this library to get the postal name.

The library can also tell you in which borough (kommune) by name or number
and county (fylke) by name the postal code is located. The borough number
can be handy, as it is used when reporting wages and tax to the Norwegian
Tax Administration 

=head2 EXPORT

None by default.

The procedures can be imported individually, or I<en block> with 
B<use Geo::postcodes::NO ':all';>.

=head1 DEPENDENCIES

This module is a subclass of Geo::Postcodes, which must be installed separately.

=head1 PROCEDURES

Note that the I<xxx_of> procedures return I<undef> when passed an illegal
argument.

=head2 legal

C<my $boolean = Geo::postcodes::NO::legal($number);>

Do we have a legal postal code; a code that follows the syntax rules?

=head2 valid

C<my $boolean = Geo::postcodes::NO::valid($number);>

Do we have a valid postal code; a code in actual use?

=head2 location_of

C<my $poststed = Geo::postcodes::NO::location_of($number);>

The postal location associated with the specified postal code.

=head2 borough_number_of

C<my $kommunenr = Geo::postcodes::NO::borough_number_of($number);>

The number of the borough (kommune) where the postal code is located.

=head2 kommunenr2kommune

C<my $kommune = Geo::postcodes::NO::kommunenr2kommune($number);>

The name of the borough (kommune), given the borough number.

=head2 borough_of

C<my $kommune = Geo::postcodes::NO::borough_of($number);>

The name of the borough (kommune) where the postal code is located.

=head2 county_of

C<my $fylke = Geo::postcodes::NO::county_of($number);>

The name of the county (fylke) where the postal code is located.

=head2 kommunenr2fylke

C<my $fylke = Geo::postcodes::NO::kommunenr2fylke($number);>

The name of the county (fylke) where the specified borough number
(kommune nummer) is located.

=head2 type_of

C<my $kategori = Geo::postcodes::NO::type_of($number);>

What kind of postal code is this. Possible values are: I<"Bde gateadresser
og postbokser">, I<"Flere bruksomrder (felles)">, I<"Gateadresser">, I<"Kunde
med eget postnummer">, I<"Postbokser">, and I<"Serviceboks">.

This information is not especially useful.

=head1 METHODS

=head2 new

C<my $P = Geo::postcodes::NO-E<gt>new($number);>

Create a new postal code object. 

The constructor will return I<undef> when passed an illegal postal code.
Legal postal codes consist of four digits, and must also be in use.

Either check the postal code with C<legal> before this call,
or test it afterwards; C<if ($P) { ... }>.

=head2 postcode

C<my $postcode = $P-E<gt>postcode;>

The postal code.

=head2 location

C<my $location = $P-E<gt>location;>

The postal place associated with the specified postal code.

=head2 borough_no

C<my $borough_number = $P-E<gt>borough_no;>

The number of the borough (kommune) where the postal code is located.

=head2 borough

C<my $borough = $P-E<gt>borough;>

The name of the borough (kommune) where the postal code is located.

=head2 county

C<my $county = $P-E<gt>county;>

The name of the county (fylke) where the postal code is located.

=head2 type

C<my $postal_type = $P-E<gt>type;>

See the description of the procedure I<type_of> above.

=head1 CAVEAT

This module uses "inside out objects".

=head2 POSTCODES

Norwegain postcodes are four digit numbers, in the interval "0000"
to "9999" (and this means that "0010" is legal, while "10" is not).

Use I<legal> to check for legal postcodes, and I<valid> to check if
the postcode is actually in use. C<Geo::postcodes::NO->new($postcode)>
will return I<undef> if passed an illegal or invalif postcode. 

Attempts to access the methods of a non-existent postal code object will
result in a runtime error. This can be avoided by checking if the postal
code is legal, before creating the object; C<valid($postcode)>
returns true or false.

=head2 LEGAL BOROUGH NUMBERS

Borough (Kommune) numbers are also four digit numbers, in the interval
"0101" to "2399". The two first digits identifies the county (fylke).

=head2 CHARACTER SET

The library was written using the ISO-8859-1 (iso-latin1) character set, and the
special norwegian letters '', '' and '' occur regularly in the postal places
and borough and county names. Usage of other character set may cause havoc.
Unicode is not tested.

Note that all names are given in UPPER CASE. This is courtesy of the norwegian
postal services. 

=head1 SEE ALSO

The latest version of this library should always be available on CPAN, 
but see also the library home page; L<http://bbop.org/perl/GeoPostcodes>.

=head1 AUTHOR

Arne Sommer, E<lt>arne@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Arne Sommer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
