#
#  Makefile.PL for WebMod::Constant
#
package WebMod::Constant;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#==============================================================================


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',

    PM					   =>  {
	'Constant.pm'			   =>  '$(INST_LIBDIR)/Constant.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Constant/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Constant/LICENSE',
    },

    'dist'				   =>  {
	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz',
    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Constant.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );


