#  Makefile.PL
#
package WebDyne;


#  Compiler Pragma
#
use strict  qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',

    PM					   =>  {

	'WebDyne.pm'			   =>  '$(INST_LIBDIR)/WebDyne.pm',
	'WebDyne_Compile.pm'		   =>  '$(INST_LIBDIR)/WebDyne/Compile.pm',
	'WebDyne_HTML_TreeBuilder.pm'	   =>  '$(INST_LIBDIR)/WebDyne/HTML/TreeBuilder.pm',
	'WebDyne_FakeRequest.pm'	   =>  '$(INST_LIBDIR)/WebDyne/FakeRequest.pm',
	'WebDyne_Static.pm'	   	   =>  '$(INST_LIBDIR)/WebDyne/Static.pm',
	'WebDyne_Cache.pm'	   	   =>  '$(INST_LIBDIR)/WebDyne/Cache.pm',
	'Constant.pm'			   =>  '$(INST_LIBDIR)/WebDyne/Constant.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/WebDyne/VERSION.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/WebDyne/LICENSE'

    },

    EXE_FILES				   =>  [

    	'support/wdcompile',
    	'support/wdrender',
    	'support/wddump'

       ],

    'dist'				   =>  {

	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz'

    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },

    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'WebDyne.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );

