#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebDyne::Err.
#
#  WebDyne::Err is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Err.pm,v 1.21 2006/05/25 16:51:26 aspeer Exp $
#
package WebDyne::Err;


#  Compiler Pragma
#
use strict qw(vars);
use vars   qw($VERSION $REVISION);


#  Webmod Modules.
#
use WebMod::Base qw(:all);
use WebDyne::Constant;
use WebDyne::Err::Constant;


#  External modules
#
use HTTP::Status qw(is_success is_error RC_INTERNAL_SERVER_ERROR);
use File::Spec;


#  Version information in a formate suitable for CPAN etc. Must be
#  all on one line
#
$VERSION = eval { require WebDyne::Err::VERSION; do $INC{'WebDyne/Err/VERSION.pm'}};


#  Release information
#
$REVISION= (qw$Revision: 1.21 $)[1];


#  Debug
#
debug("%s loaded, version $VERSION, revision $REVISION", __PACKAGE__);


#  Package wide vars
#
my %Package;


#  And done
#
1;


#------------------------------------------------------------------------------


sub err_html {


    #  Output errors to browser.
    #
    my ($self, $errstr)=@_;


    #  Debug
    #
    debug("in error routine self $self, errstr $errstr");


    #  Get errstr from stack if not supplied, or add if it
    #  has been
    #
    $errstr ? err($errstr) : ($errstr=errstr() || do {err($_='undefined error from handler'); $_});
    debug("final errstr $errstr");


    #  Try to get CGI object from class, or create if not present - may
    #  not have been initialised before error occured); Same with request
    #  object, not fatal if not present. Also make sure we get main 
    #  request object for error handling
    #
    my ($r, $cgi_or);
    if ($r=eval { $self->{'_r'} }) {


	#  Used to make r=r_main if in subrequest
	#
	#if ((my $r_main=$r->main() || $r) ne $r) {$r=$r_main }


	#  Now just return err if subrequest
	#
	if ((my $r_main=$r->main() || $r) ne $r) { return err()  }


	#  Not subrequest, get CGI object
	#
	$cgi_or=$self->{'_CGI'} || CGI->new();
    }
    debug("r $r, cgi_or $cgi_or");


    #  Print errstr and exit immediately if FakeRequest (ie command line), or
    #  no request object yet
    #
    if ((ref($r) eq 'WebDyne::FakeRequest') || !$r) {
	print(errdump({

	    File    =>	eval { $r->filename() } || 'unknown (no request object)'

	}));
	CORE::exit 0;

    };


    #  Log the error
    #
    $r->log_error($errstr);


    #  Status cannot be success
    #
    is_success($r->status()) && do { $r->status(RC_INTERNAL_SERVER_ERROR) };
    debug("status $r %s", $r->status());


    #  Do not run any more handlers
    #
    $r->set_handlers( PerlHandler=>undef );


    #  Kill this Apache process afterwards to make sure it does not behave
    #  badly after this error, if that is what the user has configured
    #
    $r->register_cleanup(sub { CORE::exit() }) if
	$WEBDYNE_ERROR_EXIT;


    #  Error can be text or HTML, must be text if in Safe eval mode
    #
    if ($WEBDYNE_ERROR_TEXT || $WEBDYNE_EVAL_SAFE) {


	#  Text error, set content type
	#
	debug("update $r content_type");
	$r->content_type('text/plain');


	#  Push error
	#
	my $err_text=errdump({

	    'URI'  =>	$r->uri()

	   });


	#  Clear error stack and $@ so this render works without errors
	#
	errclr();eval undef;


	#  Print error and return
	#
        $r->print($err_text);
        return &Apache::OK;


    }
    else {


	#  Get error paramaters, not very transparent
	#
	my %param=(

	    errstr	=> $errstr,
	    errstack_ar	=> [@{&WebMod::Err::errstack()}], #makes copy of array ref, org is destroyed below

	   );


	#  Clear error stack and $@ so this render works without errors
	#
	errclr();eval undef;


	#  Only compile container once if we can help it
	#
	$self->inode('__ERROR__');
        my $container_ar=($Package{'container_ar'} ||= $self->compile({ 

            srce	=> $WEBDYNE_ERR_TEMPLATE,
	    nofilter	=> 1,

	   })) || die('fatal problem in error handler during compile, giving up !');



	#  Get the data portion of the container (meta info not needed) and render
	#
	my $data_ar=$container_ar->[1];
        my $html_sr=$self->render({

	    data    => $data_ar,
	    param   => \%param

	   }) || die ('fatal problem in error handler during render, giving up !');


	#  Set custom handler
	#
	$r->custom_response($r->status, ${$html_sr});


	#  And return. 
	#
	debug('return status %s', $r->status());
	return $r->status;

    }


}
