#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of WebDyne::State.
#
#  WebDyne::Session is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: State.pm,v 1.2 2006/05/17 08:42:16 aspeer Exp $
#
package WebDyne::State;


#  Compiler Pragma
#
use strict qw(vars);
use vars   qw($VERSION $REVISION @ISA);


#  Webmod Modules.
#
use WebMod::Base qw(:all);


#  Version information in a format suitable for CPAN etc. Must be
#  all on one line
#
$VERSION = eval { require WebDyne::State::VERSION; do $INC{'WebDyne/State/VERSION.pm'}};


#  Release information
#
$REVISION= (qw$Revision: 1.2 $)[1];


#  Debug
#
debug("%s loaded, version $VERSION, revision $REVISION", __PACKAGE__);


#  Class hash ref for package wide storage
#
my %Package;


#  And done
#
1;


#------------------------------------------------------------------------------


sub login {


    #  Log a user in, creating a state entry for them
    #
    my ($self, $param_hr)=@_;


    #  Get user from params
    #
    my $user=(ref($param_hr) ? $param_hr->{'user'} : $param_hr) ||
	return err('no user specified');


    #  Startup state storage
    #
    $self->state_store({ user=>$user }) ||
	return err();


    #  Update cache
    #
    $self->{'_user'}=$user;


    #  Debug
    #
    debug("logged in as user $user");


    #  Done
    #
    return \undef;

}


sub user {


    #  Return usename for this session
    #
    my $self=shift();


    #  Var to hold user id
    #
    my $user;


    #  Try and fetch, but do not create cache ref if not present,
    #  and no user set.
    #
    if (exists $self->{'_user'}) {


	#  Cache entry exists, get from there
	#
	$user=$self->{'_user'};


    }
    else {


	#  Does not exist. Get from statedb and save into cache
	#
	$user=${ $self->state_fetch({ user=>1 }) ||
		     return err() };
	$self->{'_user'}=$user;

    }


    # Debug
    #
    debug("returning stored user $user");


    #  No username given, return whatever is in the statedb
    #
    return \$user;

}


sub logout {


    #  Erase username set for this session
    #
    my $self=shift();


    #  Debug
    #
    debug('in logout code');


    #  If username spec'd, delete
    #
    if (my $user=${$self->user() || return err()}) {


	#  Undef in cache, not delete
	#
	$self->{'_user'}=undef;


	#  Debug
	#
	debug("deleting state for user $user");


	#  Delete state info
	#
	$self->state_delete() || return err();


    }
    else {

	debug('no user logged in at this time')

    }


    #  All done
    #
    return \undef;

}



