#  Package
#
package WebMod::Log;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;


#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				  =>  __PACKAGE__,
    VERSION_FROM			  =>  'VERSION.pm',

    PM					  =>  {
	'Log.pm'			  =>  '$(INST_LIBDIR)/Log.pm',
	'Log_File.pm'			  =>  '$(INST_LIBDIR)/Log/File.pm',
	'Log_Syslog.pm'			  =>  '$(INST_LIBDIR)/Log/Syslog.pm',
	'Log_Print.pm'			  =>  '$(INST_LIBDIR)/Log/Print.pm',
	'Log_Null.pm'			  =>  '$(INST_LIBDIR)/Log/Null.pm',
	'VERSION.pm'			  =>  '$(INST_LIBDIR)/Log/VERSION.pm',
	'LICENSE'			  =>  '$(INST_LIBDIR)/Log/LICENSE',
	'Constant.pm'			  =>  '$(INST_LIBDIR)/Log/Constant.pm',
    },

    'dist'				  =>  {
	COMPRESS			  =>  'gzip -9f',
	SUFFIX				  =>  '.gz',
    },

    'depend'				  =>  {
	Makefile			  =>  '$(VERSION_FROM)',
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Log.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );

