/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLabel
extends ClickableElement {
    private static final long serialVersionUID = -3007176633287091652L;
    public static final String TAG_NAME = "label";

    HtmlLabel(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final String getForAttribute() {
        return this.getAttributeValue("for");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }

    @Override
    public void blur() {
        ClickableElement element = this.getReferencedElement();
        if (element != null) {
            element.blur();
        }
    }

    @Override
    public void focus() {
        ClickableElement element = this.getReferencedElement();
        if (element != null) {
            element.focus();
        }
    }

    public ClickableElement getReferencedElement() {
        block5: {
            String elementId = this.getForAttribute();
            if (!ATTRIBUTE_NOT_DEFINED.equals(elementId)) {
                try {
                    HtmlElement element = this.getHtmlElementById(elementId);
                    if (element instanceof ClickableElement) {
                        return (ClickableElement)element;
                    }
                    break block5;
                }
                catch (ElementNotFoundException e) {
                    return null;
                }
            }
            for (DomNode element : this.getChildren()) {
                if (!(element instanceof HtmlInput)) continue;
                return (HtmlInput)element;
            }
        }
        return null;
    }

    public Page click() throws IOException {
        Object page = super.click();
        ClickableElement element = this.getReferencedElement();
        Object response = element != null ? element.click() : page;
        return response;
    }
}

