/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import java.io.IOException;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlOption
extends ClickableElement
implements DisabledElement {
    private static final long serialVersionUID = 8995198439134305753L;
    public static final String TAG_NAME = "option";
    private final boolean initialSelectedState_ = this.isAttributeDefined("selected");

    HtmlOption(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public boolean isSelected() {
        return this.isAttributeDefined("selected");
    }

    public Page setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return this.getPage();
        }
        HtmlSelect select = this.getEnclosingSelect();
        if (select != null) {
            if (!select.isMultipleSelectEnabled() && select.getOptionSize() == 1) {
                selected = true;
            }
            return select.setSelectedAttribute(this, selected);
        }
        this.setSelectedInternal(selected);
        return this.getPage();
    }

    @Override
    public void insertBefore(DomNode newNode) throws IllegalStateException {
        HtmlOption option;
        super.insertBefore(newNode);
        if (newNode instanceof HtmlOption && (option = (HtmlOption)newNode).isSelected()) {
            this.getEnclosingSelect().setSelectedAttribute(option, true);
        }
    }

    public HtmlSelect getEnclosingSelect() {
        return (HtmlSelect)this.getEnclosingElement("select");
    }

    public void reset() {
        this.setSelectedInternal(this.initialSelectedState_);
    }

    public final String getSelectedAttribute() {
        return this.getAttributeValue("selected");
    }

    public final boolean isDefaultSelected() {
        return this.initialSelectedState_;
    }

    @Override
    public final boolean isDisabled() {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_PREVENT_DISABLED)) {
            return false;
        }
        return this.isAttributeDefined("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getLabelAttribute() {
        return this.getAttributeValue("label");
    }

    public final void setLabelAttribute(String newLabel) {
        this.setAttributeValue("label", newLabel);
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }

    public final void setValueAttribute(String newValue) {
        this.setAttributeValue("value", newValue);
    }

    @Override
    protected Page doClickAction(Page defaultPage) throws IOException {
        if (!this.isSelected()) {
            return this.setSelected(true);
        }
        return defaultPage;
    }

    @Override
    public DomNode appendChild(Node node) {
        DomNode addedNode = super.appendChild(node);
        if (this.getAttributeValue("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttributeValue("value", this.asText());
        }
        return addedNode;
    }

    void setSelectedInternal(boolean selected) {
        if (selected) {
            this.setAttributeValue("selected", "selected");
        } else {
            this.removeAttribute("selected");
        }
    }

    @Override
    public String asText() {
        if (this.getLabelAttribute() != ATTRIBUTE_NOT_DEFINED) {
            return this.getLabelAttribute();
        }
        return super.asText();
    }
}

