/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class TextRange
extends SimpleScriptable {
    private static final long serialVersionUID = -3763822832184277966L;
    private boolean collapsed_ = false;

    public Object jsxGet_text() {
        if (this.collapsed_) {
            return "";
        }
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        Range selection = page.getSelection();
        if (selection.getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                return input.getValueAttribute().substring(input.getSelectionStart(), input.getSelectionEnd());
            }
            if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                return input.getText().substring(input.getSelectionStart(), input.getSelectionEnd());
            }
        }
        return "";
    }

    public void jsxSet_text(String text) {
        this.collapsed_ = false;
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        Range selection = page.getSelection();
        if (selection.getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                String oldValue = input.getValueAttribute();
                input.setValueAttribute(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                String oldValue = input.getText();
                input.setText(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
            }
        }
    }

    public Object jsxFunction_duplicate() {
        TextRange range = new TextRange();
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype());
        return range;
    }

    public Object jsxFunction_parentElement() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        Range selection = page.getSelection();
        Node child = selection.getEndContainer();
        for (Node parent = selection.getStartContainer(); parent != null; parent = parent.getParentNode()) {
            if (!this.isChildOf(child, parent)) continue;
            return parent;
        }
        return null;
    }

    private boolean isChildOf(Node child, Node parent) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParentNode();
        }
        return false;
    }

    public void jsxFunction_collapse() {
        this.collapsed_ = true;
    }

    public void jsxFunction_select() {
    }

    public int jsxFunction_moveStart(String unit, Object count) {
        HtmlPage page;
        Range selection;
        if ("characters".equals(unit)) {
            this.getLog().info((Object)("moveStart('" + unit + "' is not yet supported."));
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if ((selection = (page = (HtmlPage)this.getWindow().getDomNodeOrDie()).getSelection()).getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                selection.setStart(input, selection.getStartOffset() + c);
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                selection.setStart(input, selection.getStartOffset() + c);
            }
        }
        return c;
    }

    public int jsxFunction_moveEnd(String unit, Object count) {
        HtmlPage page;
        Range selection;
        if ("characters".equals(unit)) {
            this.getLog().info((Object)("moveStart('" + unit + "' is not yet supported."));
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if ((selection = (page = (HtmlPage)this.getWindow().getDomNodeOrDie()).getSelection()).getStartContainer() == selection.getEndContainer()) {
            if (selection.getStartContainer() instanceof HtmlTextInput) {
                HtmlTextInput input = (HtmlTextInput)selection.getStartContainer();
                selection.setEnd(input, selection.getEndOffset() + c);
            } else if (selection.getStartContainer() instanceof HtmlTextArea) {
                HtmlTextArea input = (HtmlTextArea)selection.getStartContainer();
                selection.setEnd(input, selection.getEndOffset() + c);
            }
        }
        return c;
    }
}

