/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class Element
extends EventNode {
    private NamedNodeMap attributes_;
    private Map<String, HTMLCollection> elementsByTagName_;

    public HTMLCollection jsxFunction_selectNodes(final String expression) {
        final DomElement domNode = this.getDomNodeOrDie();
        boolean attributeChangeSensitive = expression.contains("@");
        String description = "Element.selectNodes('" + expression + "')";
        HTMLCollection collection = new HTMLCollection(domNode, attributeChangeSensitive, description){

            @Override
            protected List<Object> computeElements() {
                ArrayList<Object> list = new ArrayList<Object>(domNode.getByXPath(expression));
                return list;
            }
        };
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public final String jsxGet_tagName() {
        return this.jsxGet_nodeName();
    }

    public Object jsxGet_attributes() {
        if (this.attributes_ == null) {
            this.attributes_ = this.createAttributesObject();
        }
        return this.attributes_;
    }

    protected NamedNodeMap createAttributesObject() {
        return new NamedNodeMap(this.getDomNodeOrDie());
    }

    public Object jsxFunction_getAttribute(String attributeName, Integer flags) {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_36);
        attributeName = this.fixAttributeName(attributeName);
        Object value = ie && flags != null && flags == 2 && "style".equalsIgnoreCase(attributeName) ? "" : this.getDomNodeOrDie().getAttribute(attributeName);
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = null;
            if (ie) {
                for (Element object = this; object != null; object = object.getPrototype()) {
                    Object property = object.get(attributeName, (Scriptable)this);
                    if (property == NOT_FOUND) continue;
                    value = property;
                    break;
                }
            }
        }
        return value;
    }

    protected String fixAttributeName(String attributeName) {
        return attributeName;
    }

    public void jsxFunction_setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection;
        final String tagNameLC = tagName.toLowerCase();
        if (this.elementsByTagName_ == null) {
            this.elementsByTagName_ = new HashMap<String, HTMLCollection>();
        }
        if ((collection = this.elementsByTagName_.get(tagNameLC)) != null) {
            return collection;
        }
        DomElement node = this.getDomNodeOrDie();
        String description = "Element.getElementsByTagName('" + tagNameLC + "')";
        collection = "*".equals(tagName) ? new HTMLCollection(node, false, description){

            protected boolean isMatching(DomNode node) {
                return true;
            }
        } : new HTMLCollection(node, false, description){

            protected boolean isMatching(DomNode node) {
                return tagNameLC.equalsIgnoreCase(node.getLocalName());
            }
        };
        this.elementsByTagName_.put(tagName, collection);
        return collection;
    }

    public Object jsxFunction_getAttributeNode(String name) {
        Map<String, DomAttr> attributes = this.getDomNodeOrDie().getAttributesMap();
        for (DomAttr attr : attributes.values()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getScriptObject();
        }
        return null;
    }

    public String jsxGet_text() {
        StringBuilder buffer = new StringBuilder();
        this.toText(this.getDomNodeOrDie(), buffer);
        return buffer.toString();
    }

    private void toText(DomNode node, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 10: 
            case 12: {
                return;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                buffer.append(node.getNodeValue());
                break;
            }
        }
        for (DomNode child : node.getChildren()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.toText(child, buffer);
                    break;
                }
                case 3: 
                case 4: {
                    buffer.append(child.getNodeValue());
                    break;
                }
            }
        }
    }

    public Object jsxFunction_getElementsByTagNameNS(Object namespaceURI, final String localName) {
        String description = "Element.getElementsByTagNameNS('" + namespaceURI + "', '" + localName + "')";
        DomElement domNode = this.getDomNodeOrDie();
        final String prefix = namespaceURI != null && !"*".equals("*") ? XmlUtil.lookupPrefix(domNode, Context.toString((Object)namespaceURI)) : null;
        HTMLCollection collection = new HTMLCollection(domNode, false, description){

            protected boolean isMatching(DomNode node) {
                if (!localName.equals(node.getLocalName())) {
                    return false;
                }
                if (prefix == null) {
                    return true;
                }
                return true;
            }
        };
        return collection;
    }

    public boolean jsxFunction_hasAttribute(String name) {
        return this.getDomNodeOrDie().hasAttribute(name);
    }

    public DomElement getDomNodeOrDie() {
        return (DomElement)super.getDomNodeOrDie();
    }

    public void jsxFunction_removeAttribute(String name) {
        this.getDomNodeOrDie().removeAttribute(name);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_37)) {
            this.delete(name);
        }
    }
}

