/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WebWindowImpl
implements WebWindow {
    private static final long serialVersionUID = 1272747208915903553L;
    private static final Log LOG = LogFactory.getLog(WebWindowImpl.class);
    private WebClient webClient_;
    private Page enclosedPage_;
    private Object scriptObject_;
    private JavaScriptJobManager jobManager_;
    private final List<WebWindowImpl> childWindows_ = new ArrayList<WebWindowImpl>();
    private String name_ = "";
    private final History history_ = new History(this);
    private boolean closed_;
    private int innerHeight_ = 605;
    private int outerHeight_ = this.innerHeight_ + 150;
    private int innerWidth_ = 1256;
    private int outerWidth_ = this.innerWidth_ + 8;

    @Deprecated
    protected WebWindowImpl() {
    }

    public WebWindowImpl(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.jobManager_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptJobManager(this);
    }

    protected void performRegistration() {
        this.webClient_.registerWebWindow(this);
    }

    @Override
    public WebClient getWebClient() {
        return this.webClient_;
    }

    @Override
    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    @Override
    public void setEnclosedPage(Page page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setEnclosedPage: " + page));
        }
        if (page == this.enclosedPage_) {
            return;
        }
        this.destroyChildren();
        this.enclosedPage_ = page;
        this.history_.addPage(page);
        if (this.isJavaScriptInitializationNeeded()) {
            this.webClient_.initialize(this);
        }
        this.webClient_.initialize(page);
    }

    protected abstract boolean isJavaScriptInitializationNeeded();

    @Override
    public void setScriptObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public Object getScriptObject() {
        return this.scriptObject_;
    }

    @Override
    public JavaScriptJobManager getJobManager() {
        return this.jobManager_;
    }

    public void setJobManager(JavaScriptJobManager jobManager) {
        this.jobManager_ = jobManager;
    }

    public void addChildWindow(FrameWindow child) {
        this.childWindows_.add(child);
    }

    void destroyChildren() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"destroyChildren");
        }
        this.getJobManager().removeAllJobs();
        ListIterator<WebWindowImpl> iter = this.childWindows_.listIterator();
        while (iter.hasNext()) {
            WebWindowImpl window = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("closing child window: " + window));
            }
            window.setClosed();
            window.getJobManager().shutdown();
            Page page = window.getEnclosedPage();
            if (page instanceof HtmlPage) {
                ((HtmlPage)page).cleanUp();
            }
            window.destroyChildren();
            iter.remove();
        }
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public History getHistory() {
        return this.history_;
    }

    @Override
    public boolean isClosed() {
        return this.closed_;
    }

    protected void setClosed() {
        this.closed_ = true;
    }

    @Override
    public int getInnerWidth() {
        return this.innerWidth_;
    }

    @Override
    public void setInnerWidth(int innerWidth) {
        this.innerWidth_ = innerWidth;
    }

    @Override
    public int getOuterWidth() {
        return this.outerWidth_;
    }

    @Override
    public void setOuterWidth(int outerWidth) {
        this.outerWidth_ = outerWidth;
    }

    @Override
    public int getInnerHeight() {
        return this.innerHeight_;
    }

    @Override
    public void setInnerHeight(int innerHeight) {
        this.innerHeight_ = innerHeight;
    }

    @Override
    public int getOuterHeight() {
        return this.outerHeight_;
    }

    @Override
    public void setOuterHeight(int outerHeight) {
        this.outerHeight_ = outerHeight;
    }
}

