/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class HtmlTextArea
extends HtmlElement
implements DisabledElement,
SubmittableElement,
SelectableTextInput,
FormFieldWithNameHistory {
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;
    private String valueAtFocus_;
    private String originalName_;
    private Collection<String> previousNames_ = Collections.emptySet();
    private final SelectionDelegate selectionDelegate_ = new SelectionDelegate(this);
    private final DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(){

        @Override
        void typeDone(String newValue, int newCursorPosition) {
            HtmlTextArea.this.setTextInternal(newValue);
            HtmlTextArea.this.setSelectionStart(newCursorPosition);
            HtmlTextArea.this.setSelectionEnd(newCursorPosition);
        }

        @Override
        protected boolean acceptChar(char c) {
            return super.acceptChar(c) || c == '\n' || c == '\r';
        }
    };

    HtmlTextArea(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = this.readValue();
        }
    }

    @Override
    public final String getText() {
        return this.readValue();
    }

    private String readValue() {
        StringBuilder buffer = new StringBuilder();
        for (DomNode node : this.getChildren()) {
            if (!(node instanceof DomText)) continue;
            buffer.append(((DomText)node).getData());
        }
        if (buffer.length() > 0 && buffer.charAt(0) == '\n') {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    @Override
    public final void setText(String newValue) {
        this.initDefaultValue();
        this.setTextInternal(newValue);
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    private void setTextInternal(String newValue) {
        this.initDefaultValue();
        DomText child = (DomText)this.getFirstChild();
        if (child == null) {
            DomText newChild = new DomText((SgmlPage)this.getPage(), newValue);
            this.appendChild(newChild);
        } else {
            child.setData(newValue);
        }
        this.setSelectionStart(newValue.length());
        this.setSelectionEnd(newValue.length());
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String text = this.getText();
        text = text.replace("\r\n", "\n").replace("\n", "\r\n");
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), text)};
    }

    @Override
    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_DEFAULT_IS_CHECKED) && this.getText().equals(this.getDefaultValue())) {
            this.setTextInternal(defaultValue);
        }
        this.defaultValue_ = defaultValue;
    }

    @Override
    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getRowsAttribute() {
        return this.getAttribute("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttribute("cols");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttribute("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttribute("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttribute("onchange");
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(StringEscapeUtils.escapeXml((String)this.getText()));
        printWriter.print("</textarea>");
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this.doTypeProcessor_.doType(this.getText(), this.getSelectionStart(), this.getSelectionEnd(), c, shiftKey, ctrlKey, altKey);
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.getText();
    }

    @Override
    void removeFocus() {
        super.removeFocus();
        if (!this.valueAtFocus_.equals(this.getText())) {
            HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = null;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    protected Object clone() throws CloneNotSupportedException {
        return new HtmlTextArea(this.getNamespaceURI(), this.getQualifiedName(), (SgmlPage)this.getPage(), this.getAttributesMap());
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("name".equals(qualifiedName)) {
            if (this.previousNames_.isEmpty()) {
                this.previousNames_ = new HashSet<String>();
            }
            this.previousNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getPreviousNames() {
        return this.previousNames_;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }
}

