/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlCanvas;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.CanvasRenderingContext2D;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClasses={HtmlCanvas.class}, browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
public class HTMLCanvasElement
extends HTMLElement {
    @Override
    @JsxGetter
    public int getWidth() {
        return this.getCurrentStyle().getCalculatedWidth(false, false);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @Override
    @JsxGetter
    public int getHeight() {
        return this.getCurrentStyle().getCalculatedHeight(false, false);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.getDomNodeOrDie().setAttribute("height", height);
    }

    @JsxFunction
    public Object getContext(String contextId) {
        if ("2d".equals(contextId)) {
            CanvasRenderingContext2D context = new CanvasRenderingContext2D();
            context.setParentScope(this.getParentScope());
            context.setPrototype(this.getPrototype(context.getClass()));
            return context;
        }
        return null;
    }

    @JsxFunction
    public String toDataURL(String type) {
        return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAACWCAYAAABkW7XSAAAAxUlEQVR4nO3BMQEAAADCoPVPbQhfoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOA1v9QAATX68/0AAAAASUVORK5CYII=";
    }
}

