# Copyright (C) 2001 Rob Brown (rob@roobik.com)
# rpm SPEC file configured to override the default
# installation, yet without rpm conflicts.

use strict;

my $output = $0;
my $p = $1 if $output =~ m%([^/]*)$%;
$output =~ s/\.PL$//;

unless (do "./Ping.pm") {
  die $@ if $@;
  die "./Ping.pm: $!";
}

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Net::Ping::VERSION/g;

open SPEC, ">$output" or die "$output: $!";
print SPEC "# Automatically generated by $p\n";
print SPEC $_;
close SPEC;

__DATA__
%define perlmod Net-Ping
Summary:	%{perlmod} perl module
Name:		perl-%{perlmod}
Version:	@VERSION@
Release:	1
License:	GPL
Group:		Development/Languages/Perl
Source0:	http://www.cpan.org./authors/id/B/BB/BBB/%{perlmod}-%{version}.tar.gz
Packager:	Rob Brown <bbb@cpan.org>
Prefix: 	/usr
BuildRequires:	perl
Requires:	perl
BuildRoot:	/var/tmp/%{name}-%{version}-root
Provides:	%{perlmod}

%description
%{perlmod} Perl Module

%prep
%setup -q -n %{perlmod}-%{version}

%build
perl Makefile.PL
make
make test

%install
rm -rf $RPM_BUILD_ROOT
make PREFIX=$RPM_BUILD_ROOT%{prefix} install
find $RPM_BUILD_ROOT%{prefix} -type f -print | perl -p -e "s@^$RPM_BUILD_ROOT(.*)@\$1*@g" | grep -v perllocal.pod | grep -v packlist > %{name}-filelist

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}-filelist
%defattr(-,root,root)

%post

%changelog
* Sat Apr 06 2002 Rob Brown <bbb@cpan.org>
- Hack to let this version override the default
* Thu Nov 15 2001 Rob Brown <bbb@cpan.org>
- initial creation
