package Acme::MetaSyntactic::planets;
use strict;
use Acme::MetaSyntactic::Locale;
our @ISA = qw( Acme::MetaSyntactic::Locale );
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::planets - The planets theme

=head1 DESCRIPTION

The nine planets of our solar system.

The status of the newly discovered Kuiper belt object (2003 UB313) is
still not determined (and therefore, not officially named), and hence,
not classified as a planet.

=head1 CONTRIBUTOR

Abigail

Introduced in version 0.63, published on February 27, 2006.

Made multilingual in version 0.73, published on May 8, 2006.

Updated to 42 languages by Abigail in version 0.74, published on May 15, 2006.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::Locale>.

=cut

__DATA__
# default
en
# names af
Mercurius Venus Aarde Mars Jupiter Saturnus Uranus Neptunus Pluto
# names als
Merkur Venus Erde Mars Jupiter Saturn Uranus Neptun Pluto
# names bs
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun Pluton
# names ca
Mercuri Venus Terra Mart Jupiter Saturn Ura Neptu Pluto
# names da
Merkur Venus Jorden Mars Jupiter Saturn Uranus Neptun Pluto
# names de
Merkur Venus Erde Mars Jupiter Saturn Uranus Neptun Pluto
# names en
Mercury Venus Earth Mars Jupiter Saturn Uranus Neptune Pluto
# names eo
Merkuro Venuso Tero Marso Jupitero Saturno Urano Neptuno Plutono
# names es
Mercurio Venus Tierra Marte Jupiter Saturno Urano Neptuno Pluton
# names et
Merkuur Veenus Maa Marss Jupiter Saturn Neptuun Uraan Pluuto
# names eu
Mercurius Artizar Lurra Mars Jupiter Saturno Uranus Neptuno Pluton
# names fi
Merkurius Venus Maa Mars Jupiter Saturnus Uranus Neptunus Pluto
# names fr
Mercure Venus Terre Mars Jupiter Saturne Uranus Neptune Pluton
# names fur
Mercuri Bielestele Tiere Mart Gjiove Saturni Nettun Uran Pluton
# names gl
Mercurio Venus Terra Marte Xupiter Saturno Urano Neptuno Pluton
# names hr
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun Pluton
# names hu
Merkur Venusz Fold Mars Jupiter Szaturnusz Uranusz Neptunusz Pluto
# names ia
Mercurio Venus Terra Marte Jupiter Saturno Urano Neptuno Pluton
# names id
Merkurius Venus Bumi Mars Jupiter Saturnus Neptunus Uranus Pluto
# names it
Mercurio Venere Terra Marte Giove Saturno Uranio Nettuno Plutone
# names ku
Tir Gelawej Erd Behram Bercis Keywan Uranus Neptun Pluton
# names kw
Mergher Gwener Norvys Meurth Yow Sadorn Ouranos Nevyon Plouton
# names la
Mercurius Venus Terra Mars Iuppiter Saturnus Uranus Neptunus Pluto 
# names lb
Merkur Venus Aerd Mars Jupiter Saturn Uranus Neptun Pluto
# names lt
Merkurijus Venera Zeme Marsas Jupiteris Saturnas Uranas Neptunas Plutonas
# name ms
Utarid Zuhrah Bumi Marikh Musytari Zuhal Uranus Neptun Pluto
# names mt
Merkurju Venere Dinja Marte Gove Saturnu Uranju Nettunu Plutone
# names nap
Mercurio Venere Terra Marte Giove Saturno Urano Nettuno Plutone
# names nds
Merkur Venus Eer Mars Jupiter Saturn Uranus Neptun Pluto
# names nl
Mercurius Venus Aarde Mars Jupiter Saturnus Uranus Neptunus Pluto
# names nn
Merkur Venus Jorda Mars Jupiter Saturn Uranus Neptun Pluto
# names no
Merkur Venus Jorden Mars Jupiter Saturn Uranus Neptun Pluto
# names nrm
Mertchure Venus Terre Mars Jupiter Saturne Uranus Nepteune Pliuton
# names pam
Mercury Venus Yatu Jupiter Saturn Uranus Neptune Pluto
# names pl
Merkury Wenus Ziemia Mars Jowisz Saturn Uran Neptun Pluton
# names pt
Mercurio Venus Terre Marte Jupiter Saturno Urano Netuno Plutao
# names ro
Mercur Venus Pamant Marte Jupiter Saturn Uranus Neptun Pluto
# names scn
Mercuriu Veniri Terra Marti Giovi Saturnu Uranu Nettunu Plutoni
# names sh
Merkur Venera Zemlja Mars Jupiter Saturn Uran Neptun Pluton
# names sv
Merkurius Venus Jorden Mars Jupiter Saturnus Uranus Neptunus Pluto
# names tl
Merkuryo Venus Daigdig Marte Jupiter Saturno Urano Neptuno Pluto
# names tpi
Makuri Vinas Graun Mas Jupita Saten Yuranas Neptun Pluto
# names tr
Merkur Venus Yer Mars Jupiter Saturn Uranus Neptun Pluton
