#!/usr/bin/perl -w
use strict;
use CGI;
my $cgi  = CGI->new;

my $auth = TRAuth->new($cgi);
# $auth->set_template(delete_all => 1);
   $auth->check_user;
   $auth->screen(content => "Bu program kullanabilirsiniz", 
                 title   => "Eriim onayland");

# Translate the interface to turkish
package TRAuth;
use CGI::Auth::Basic;

sub new {
   my $class = shift;
   my $cgi   = shift;
   CGI::Auth::Basic->fatal_header("Content-Type: text/html; charset=ISO-8859-9\n\n");
   %CGI::Auth::Basic::ERROR = error();
   my $auth = CGI::Auth::Basic->new(cgi_object     => $cgi, 
                                    file           => "./password.txt",
                                    http_charset   => 'ISO-8859-9',
                                    setup_pfile    => 1,
                                    logoff_param   => 'cik',
                                    changep_param  => 'parola_degistir',
                                    cookie_id      => 'parolakurabiyesi',
                                    cookie_timeout => '1h',
                                    chmod_value    => 0644,
                                    );

   $auth->set_template(template());
   $auth->set_title(title());
   return $auth;
}

sub template {
   return 
login_form => qq~

<span class="error"><?PAGE_FORM_ERROR?></span>
<form action="<?PROGRAM?>" method="post">

<table border="0" cellpadding="0" cellspacing="0">
 <tr><td class="darktable">
  <table border="0" cellpadding="4" cellspacing="1">
 <tr>
   <td class="titletable" colspan="3">Bu zellii kullanabilmek iin balanmalsnz</td>
 </tr>
 <tr>
  <td class="lighttable">Bu program kullanmak iin <i>gereken</i> parolay girin:</td>
  <td class="lighttable"><input type="password" name="<?COOKIE_ID?>"></td>
  <td class="lighttable" align="right"><input type="submit" name="submit" value="Balan"></td>
 </tr>
</table>
</td> </tr>
</table>
</form>
   ~,

change_pass_form => qq~
<span class="error"><?PAGE_FORM_ERROR?></span>
<form action="<?PROGRAM?>" method="post">

<table border="0" cellpadding="0" cellspacing="0">
 <tr><td class="darktable">
  <table border="0" cellpadding="4" cellspacing="1">
 <tr>
   <td class="titletable" colspan="3">
   3 ile 32 karakter arasnda bir parola girin. Boluk kullanmayn!</td>
 </tr>
 <tr>
  <td class="lighttable">Yeni parolanz girin:</td>
  <td class="lighttable"><input type="password" name="<?COOKIE_ID?>_new"></td>
  <td class="lighttable" align="right">
  <input type="submit" name="submit" value="Parolay deitir">
  <input type="hidden" name="change_password" value="ok"></td>
  <input type="hidden" name="<?CHANGEP_PARAM?>" value="1"></td>

 </tr>
</table>
</td> </tr>
</table>
</form>

~,

screen => qq~<html>
   <head>
    <?PAGE_REFRESH?>
    <title>CGI::Auth::Basic - Trke >> <?PAGE_TITLE?></title>
    <style>
      body       {font-family: Verdana, sans; font-size: 10pt}
      td         {font-family: Verdana, sans; font-size: 10pt}
     .darktable  { background: black;   }
     .lighttable { background: white;   }
     .titletable { background: #dedede; }
     .error      { color = red; font-weight: bold}
     .small      { font-size: 8pt}
    </style>
   </head>
   <body>
      <?PAGE_LOGOFF_LINK?>
      <?PAGE_CONTENT?>
      <?PAGE_INLINE_REFRESH?>
   </body>
   </html>~,

   logoff_link => qq~
   <span class="small">[<a href="<?PROGRAM?>?<?LOGOFF_PARAM?>=1">k</a>
   - <a href="<?PROGRAM?>?<?CHANGEP_PARAM?>=1">Parolay deitir</a>]</span> ~,

   ;
}

sub title {
return 
   login_form       => 'Balan',
   cookie_error     => 'Geersiz kurabiye',
   login_success    => 'Balant baarl',
   logged_off       => 'k yaptnz',
   change_pass_form => 'Parolay deitir',
   password_created => 'Parola oluturuldu',
   password_changed => 'Parola baaryla deitirildi',
   error            => 'Hata',
   ;
}

sub error {
return 
   INVALID_OPTION    => "Seenekler 'parametre => deer' biiminde olmal!",
   CGI_OBJECT        => "almak iin bir CGI nesnesine ihtiyacm var!!!",
   FILE_READ         => "Parola dosyas alamyor: ",
   NO_PASSWORD       => "Herhangi bir parola belirtilmedi (veya parola dosyas bulunamyor)!",
   UPDATE_PFILE      => "Parola dosyanz bo ve geerli ayarlarnz bu kodun dosyay gncellemesine izin vermiyor! Ltfen parola dosyanz gncelleyin.",
   ILLEGAL_PASSWORD  => "Geersiz parola! Kabul edilmedi. Geri dnn ve yeni bir tane girin",
   FILE_WRITE        => "Parola dosyas gncelleme iin alamyor: ",
   UNKNOWN_METHOD    => "'<b>%s</b>' adnda bir metod yok. Kodunuzu denetleyin.",
   EMPTY_FORM_PFIELD => "Herhangi bir parola ayarlamadnz (parola dosyas bo)!",
   WRONG_PASSWORD    => "<p>Yanl Parola!</p>",
   INVALID_COOKIE    => "Kurabiyeniz geersiz bilgi ieriyor ve bu kurabiye program tarafndan silindi.",
   ;
}

__END__
