package main;

use utf8;
use strict;
use warnings;

use Test::More ('import' => [qw/ isa_ok is ok use_ok /], 'tests' => 19);
BEGIN { use_ok('Linux::Sys::CPU::Affinity') };

my $ca;
my @cpus;

# check the empty constructor
$ca = Linux::Sys::CPU::Affinity->new();
is($ca->cpu_count(), 0, "Checking the CPU_COUNT for empty set in the constructor");
isa_ok($ca, 'Linux::Sys::CPU::Affinity', 'Checking the class name');

# check the non-empty constructor
@cpus = (0 .. 2);
$ca = Linux::Sys::CPU::Affinity->new(\@cpus);
is($ca->cpu_count(), scalar(@cpus), "Checking the CPU_COUNT for non-empty set in the constructor");
ok($ca->cpu_isset(2), "Checking the CPU_ISSET for existing CPU in the set");
ok(! $ca->cpu_isset(21), "Checking the CPU_ISSET for non-existing CPU in the set");

is($ca->cpu_clr(2), undef, "Checking the return value for CPU_CLR method");
ok(! $ca->cpu_isset(2), "Checking the CPU_CLR result in the set by using CPU_ISSET");
is($ca->cpu_count(), scalar(@cpus) - 1, "Checking the CPU_CLR result in the set by using CPU_COUNT");

is($ca->cpu_set(2), undef, "Checking the return value for CPU_SET method");
ok($ca->cpu_isset(2), "Checking the CPU_SET result in the set by using CPU_ISSET");
is($ca->cpu_count(), scalar(@cpus), "Checking the CPU_CLR result in the set by using CPU_COUNT");

is($ca->cpu_zero(), undef, "Checking the return value for CPU_ZERO method");
is($ca->cpu_count(), 0, "Checking the CPU_ZERO result in the set by using CPU_COUNT");

@cpus = (2 .. 5);
is($ca->reset(\@cpus), undef, "Checking the return value for 'reset' method with non-empty list");
is($ca->cpu_count(), scalar(@cpus), "Checking the non-empty 'reset' result in the set by using CPU_COUNT");

is($ca->reset(), undef, "Checking the return value for 'reset' method with empty list");
is($ca->cpu_count(), 0, "Checking the empty 'reset' result in the set by using CPU_COUNT");

$ca->reset(\@cpus);

is($ca->set_affinity($$), 0, "Checking the return value for 'set_affinity' method");

1;
__END__
