package REST::Cypher::Exception {
$REST::Cypher::Exception::VERSION = '0.0.3';
use strict;
    use warnings;

    use Moo;
    with 'Throwable';

    use overload
        q{""}    => 'as_string',
        fallback => 1;

    sub as_string {
        my ($self) = @_;
        return $self->message;
    }
}

package REST::Cypher::Exception::Response {
    use Moo;
    extends 'REST::Cypher::Exception';

    has response => ( is => 'ro', required => 1 );
    has error    => ( is => 'ro', required => 1, lazy => 1, builder => '_build_error' );

    sub BUILD {
        my $self = shift;

        # force ->error to be built
        warn "failed a lazy build"
            unless $self->error;
    }

    sub _build_error {
        my $self = shift;
        $self->{error} = {
            code        => $self->response->code,
            message     => $self->response->message,
            as_string   => $self->response->as_string,
        };
    }

    sub message {
        return $_[0]->error->{message};
    }
}

1;
{
  $REST::Cypher::Exception::DIST = 'REST-Cypher';
}

__END__

=pod

=encoding UTF-8

=head1 NAME

REST::Cypher::Exception

=head1 VERSION

version 0.0.3

=head2 as_string

This method in L<REST::Cypher::Exception> allows easy stringification of
thrown exceptions.

It returns the current value of I<message>.

=head1 AUTHOR

Chisel <chisel@chizography.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Chisel Wright.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
