# Copyright (C) 2008, The Perl Foundation.
# $Id: /mirror/trunk/languages/lua/src/lib/base64.pir 27030 2008-04-18T20:32:33.272450Z fperrad  $

=head1 NAME

lib/base64.pir - base64 library

=head1 DESCRIPTION

See original on L<http://www.tecgraf.puc-rio.br/~lhf/ftp/lua/#lbase64/>

This implementation is based on F<runtime/parrot/library/MIME/Base64.pir>.

=head2 Functions

=over 4

=cut

.HLL 'Lua', 'lua_group'
.namespace [ 'Lua::base64'; 'Lua' ]

.sub '__onload' :anon :load
#    print "__onload base64\n"
    .const .Sub entry = 'luaopen_base64'
    set_hll_global 'luaopen_base64', entry
.end

.const string MYNAME = 'base64'

.sub 'luaopen_base64'

#    print "luaopen_base64\n"
    load_bytecode 'MIME/Base64.pir'

    .local pmc _lua__GLOBAL
    _lua__GLOBAL = get_hll_global '_G'

    new $P1, 'LuaString'

    .local pmc _base64
    new _base64, 'LuaTable'
    set $P1, MYNAME
    _lua__GLOBAL[$P1] = _base64

    lua_register($P1, _base64)

    .const .Sub _base64_decode = 'decode'
    _base64_decode.'setfenv'(_lua__GLOBAL)
    set $P1, 'decode'
    _base64[$P1] = _base64_decode

    .const .Sub _base64_encode = 'encode'
    _base64_encode.'setfenv'(_lua__GLOBAL)
    set $P1, 'encode'
    _base64[$P1] = _base64_encode

    new $P2, 'LuaString'

#    set $P2, "Copyright (C) 2008, The Perl Foundation"
#    set $P1, "_COPYRIGHT"
#    _base64[$P1] = $P2

    set $P2, "base64 library for Lua on Parrot"
#    set $P1, "_DESCRIPTION"
    set $P1, "version"
    _base64[$P1] = $P2

#    set $P2, "base64 ???"
#    set $P1, "_VERSION"
#    _base64[$P1] = $P2

    .return (_base64)
.end


=item C<base64.decode (s)>

=cut

.sub 'decode' :anon
    .param pmc s :optional
    .param pmc extra :slurpy
    .local pmc res
    $S1 = lua_checkstring(1, s)
    $P0 = get_hll_global ['MIME'; 'Base64'], 'decode_base64'
    $S0 = $P0($S1)
    new res, 'LuaString'
    set res, $S0
    .return (res)
.end


=item C<base64.encode (s)>

=cut

.sub 'encode' :anon
    .param pmc s :optional
    .param pmc extra :slurpy
    .local pmc res
    $S1 = lua_checkstring(1, s)
    $P0 = get_hll_global ['MIME'; 'Base64'], 'encode_base64'
    $S0 = $P0($S1)
    new res, 'LuaString'
    set res, $S0
    .return (res)
.end


=back

=head1 AUTHORS

Francois Perrad

=cut


# Local Variables:
#   mode: pir
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4 ft=pir:
