#! perl
# Copyright (C) 2007, The Perl Foundation.
# $Id: /mirror/trunk/t/steps/auto_gcc-11.t 27234 2008-04-29T02:17:08.473457Z jkeenan  $
# auto_gcc-11.t

use strict;
use warnings;
use Test::More tests =>  12;
use Carp;
use lib qw( lib t/configure/testlib );
use_ok('config::init::defaults');
use_ok('config::auto::gcc');
use Parrot::Configure;
use Parrot::Configure::Options qw( process_options );
use Parrot::Configure::Test qw( test_step_thru_runstep);

my $args = process_options( {
    argv            => [ q{--maintainer}, q{--cage} ],
    mode            => q{configure},
} );

my $conf = Parrot::Configure->new();

test_step_thru_runstep($conf, q{init::defaults}, $args);

my ($task, $step_name, $step, $ret);
my $pkg = q{auto::gcc};

$conf->add_steps($pkg);
$conf->options->set(%{$args});
$task = $conf->steps->[1];
$step_name   = $task->step;

$step = $step_name->new();
ok(defined $step, "$step_name constructor returned defined value");
isa_ok($step, $step_name);


my $gnucref = {};
$gnucref->{__GNUC__} = q{3};
$gnucref->{__GNUC_MINOR__} = q{1};
$conf->data->set( ccwarn => q{-Wfoobar -Wnofoobaz} );
ok($step->_evaluate_gcc($conf, $gnucref),
    "_evaluate_gcc() returned true value");
ok(defined $conf->data->get( 'gccversion' ),
    "gccversion defined as expected");
is($step->result(), q{yes}, "Got expected result");


pass("Completed all tests in $0");

################### DOCUMENTATION ###################

=head1 NAME

auto_gcc-11.t - test config::auto::gcc

=head1 SYNOPSIS

    % prove t/steps/auto_gcc-11.t

=head1 DESCRIPTION

The files in this directory test functionality used by F<Configure.pl>.

The tests in this file test subroutines exported by config::auto::gcc.

=head1 AUTHOR

James E Keenan

=head1 SEE ALSO

config::auto::gcc, F<Configure.pl>.

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
