use 5.14.0;
use warnings;

use Moops;

our $VERSION = '0.1001'; # VERSION
# PODNAME: Stenciller.pm
library Types::Stenciller

extends Types::Standard, Types::TypeTiny, Types::Path::Tiny

declares Stencil, Renderer, Stenciller

{

    class_type Stenciller => { class => 'Stenciller::Wrap' };
    class_type Stencil    => { class => 'Stenciller::Stencil' };

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stenciller.pm

=head1 VERSION

Version 0.1001, released 2015-01-15.

=head1 SYNOPSIS

    use Types::Stenciller -types;

=head1 DESCRIPTION

Defines a few types used in the C<Stenciller> namespace.

:splint classname Types::Stenciller

=head1 TYPES

=over 4



=back

* C<Stencil> is a L<Stenciller::Stencil>
* C<Stenciller> is a L<Stenciller>

=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
