use Stenciller::Standard;

# VERSION
# ABSTRACT: A plugin that doesn't transforme the text the text
# PODNAME: Stenciller::Plugin::ToUnparsedText

class Stenciller::Plugin::ToUnparsedText using Moose with Stenciller::Transformer {

    method transform {
        my @out = $self->stenciller->all_header_lines;

        STENCIL:
        foreach my $stencil ($self->stenciller->all_stencils) {
            push @out => $stencil->all_before_input,
                         $stencil->all_input,
                         $stencil->all_between,
                         $stencil->all_output,
                         $stencil->all_after_output;
        }
        return join "\n" => @out;
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stenciller::Plugin::ToUnparsedText - A plugin that doesn't transforme the text the text

=head1 VERSION

Version 0.1100, released 2015-01-16.

=head1 SYNOPSIS

    use Stenciller;
    my $stenciller = Stenciller->new(filepath => 't/corpus/test-1.stencil');
    my $content = $stenciller->transforme('ToUnparsedText');

=head1 DESCRIPTION

This plugin to L<Stenciller> basically returns all text content of the stencils.



=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
