package OpenInteract::SQLInstall::Base;

# $Id: Base.pm,v 1.4 2001/07/13 14:37:04 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Base::ISA = qw( OpenInteract::SQLInstall );

my %files = (
   tables   => [ 'sessions.sql', 'object_track.sql', 'object_keys.sql' ],
   security => [ 'install_security.dat' ],
);

%HANDLERS = (
   create_structure => { '_default_' => [ 'create_structure', 
                                          { table_file_list => $files{tables} } ] },
   install_security => { '_default_' => [ 'install_data',
                                          { data_file_list => $files{security} } ] },
);

1;

__END__

=pod

=head1 NAME

OpenInteract::SQLInstall::Base - SQL installer for the base package

=head1 DESCRIPTION

SQL installer for the base package. Just create the tables 'sessions'
and 'object_track' and set the various security options.

=head1 BUGS 

None known.

=head1 TO DO

Nothing.

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
