package OpenInteract::User;

# $Id: User.pm,v 1.4 2001/08/12 05:37:44 lachoy Exp $

use strict;
use SPOPS::Secure qw( :level :scope );

$OpenInteract::User::VERSION = sprintf("%d.%02d", q$Revision: 1.4 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::User::crypt_password = undef;


sub _class_initialize {
    my ( $class, $CONFIG ) = @_;
    no strict 'refs';
    my $R = OpenInteract::Request->instance;
    $R->DEBUG && $R->scrib( 1, "Set $class to use crypt ($CONFIG->{login}->{crypt_password})" );
    ${ $class . '::crypt_password' } = $CONFIG->{login}->{crypt_password};
}



sub make_public {
    my ( $self ) = @_;
    my $R = OpenInteract::Request->instance;

 # First find the public group

    my $groups = eval { $R->group->fetch_group({ where => 'name = ?',
                                                 value => [ 'public' ] }) };
    if ( my $public = $groups->[0] ) {

        # Then add the user to it

        eval { $self->group_add( [ $public->{group_id} ] ); };
        if ( $@ ) {
            OpenInteract::Error->set( SPOPS::Error->get );
            $OpenInteract::Error::user_msg = 'Cannot make user part of public group.';
            die $OpenInteract::Error::user_msg;
        }

        # Then ensure the public can see (for now) this user

        eval { $self->set_security({ scope    => SEC_SCOPE_GROUP,
                                     scope_id => $public->{group_id},
                                     level    => SEC_LEVEL_READ }) };
        if ( $@ ) {
            OpenInteract::Error->set( SPOPS::Error->get );
            $OpenInteract::Error::user_msg = 'User is part of public group, but public group cannot see user.';
            die $OpenInteract::Error::user_msg;
        }
    }
    return 1;
}


sub full_name { return join ' ', $_[0]->{first_name}, $_[0]->{last_name} }


sub increment_login {
    my ( $self ) = @_;
    $self->{last_login} = $self->now;
    $self->{num_logins}++;
    eval { $self->save };
    if ( $@ ) {
        OpenInteract::Error->set( SPOPS::Error->get );
        $OpenInteract::Error::user_msg = 'Cannot incremement login number or set the login date to now.';
        die $OpenInteract::Error::user_msg;
    }
    return 1;
}



sub check_password {
    my ( $self, $check_pw ) = @_;
    return undef unless ( $check_pw );
    my $R = OpenInteract::Request->instance;
    my $exist_pw = $self->{password};
    no strict 'refs';
    my $class = ref $self;
    my $use_crypt = ${ $class . '::crypt_password' };
    if ( $use_crypt ) {
        $R->DEBUG && $R->scrib( 1, "Checking using the crypt() function." );
        return ( crypt( $check_pw, $exist_pw ) eq $exist_pw );
    } 
    return ( $check_pw eq $exist_pw );
}

1;

__END__

=pod

=head1 NAME

OpenInteract::User - Create and manipulate users. 

=head1 SYNOPSIS

  use OpenInteract::User;
  $user = OpenInteract::User->new();

  # Increment the user's login total
  $user->increment_login();
  print "Username: $user->{username}\n";
  
=head1 DESCRIPTION

=head1 METHODS

B<full_name()>

Returns the full name -- it is accessed often enough that we just made
an alias for concatenating the first and last names.

B<increment_login()>

Increments the number of logins for this user and sets the lastlogin
date to today.

B<check_password( $pw )>

Return a 1 if the password matches what is in the database, a 0 if
not.

=head1 TO DO

=head1 BUGS

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
