#!/usr/bin/perl

# $Id: results_manage.pl,v 1.2 2001/07/15 20:20:56 lachoy Exp $

use strict;
use lib qw( .. );
use Data::Dumper  qw( Dumper );
use OpenInteract::Startup;
use OpenInteract::ResultsManage;

{
    my $usage = "Usage: $0 --website_dir=/path/to/my_site";
 
    # Setup the OI environment

    my $R = OpenInteract::Startup->setup_static_environment_options( $usage );

    # Fetch some SPOPS objects -- just do some template objects since
    # we know they're there

    my $template_list = $R->sitetemplate->fetch_group({ order => 'name, package' });
    my $results = OpenInteract::ResultsManage->new();    
    my $search_id = $results->save( $template_list );
    print "Search ID: $search_id\n";

    $results->clear();

    # Now retrieve items 10 - 19 from the saved search

    $results->{search_id} = $search_id;
    $results->{min}       = 10;
    $results->{max}       = 19;
    my $iter = $results->retrieve({ return => 'iterator' });
    print "Displaying objects:\n";
    while ( my $obj = $iter->get_next ) {
        print "Object is of class: ", ref $obj, " with ID: ", $obj->id, "\n";
    }

    $results->clear();

    # Save the same results, but this time force them to be 'mixed'

    my $search_id_mix = $results->save( $template_list, { force_mixed => 1 } );
    print "Search ID (mixed): $search_id_mix\n";

    $results->clear();

    # Now retrieve items 10 - 19 from the saved search, using a
    # different calling format...

    $results->{search_id} = $search_id_mix;
    my $iter_mix = $results->retrieve({ min => 10, max => 19,
                                        return => 'iterator' });
    print "Displaying objects (mixed):\n";
    while ( my $obj = $iter_mix->get_next ) {
        print "Object is of class: ", ref $obj, " with ID: ", $obj->id, "\n";
    }

    $R->db->disconnect;
}
