package OpenInteract::User::LDAP;

# $Id: LDAP.pm,v 1.3 2001/08/27 17:05:43 lachoy Exp $

use strict;

$OpenInteract::User::LDAP::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

########################################
# Normal
########################################

sub full_name { return $_[0]->{cn} }

# To check the password for this user, we try to bind with the
# password in the object and the object's DN. First we need to grab a
# new connection...

sub check_password {
    my ( $self, $check_passwd ) = @_;
    my $connect_info = $self->connection_info;
    my $ldap = eval { OpenInteract::LDAP->connect( $connect_info ) };
    if ( $@ ) {
        OpenInteract::Error->set({
               user_msg   => 'Cannot connect to LDAP directory to check password.',
               system_msg => $@,
               type       => 'db' });
        die $OpenInteract::Error::user_msg;
    }
    my $bind_info = { bind_dn       => $self->dn,
                      bind_password => $check_passwd };
    eval { OpenInteract::LDAP->bind( $ldap, $bind_info ) };
    return ( ! $@ );
}

# Cheating because 'fetch_by' isn't done yet and we need this for
# OpenInteract::Auth...

sub fetch_by_login_name {
    my ( $class, $login_name, $p ) = @_;
    my $login_field = $class->CONFIG->{field_map}{login_name} || 'login_name';
    $p->{filter} = "$login_field=$login_name";
    return $class->fetch( undef, $p )
}

1;
