package OpenInteract::SQLInstall::Page;

# $Id: Page.pm,v 1.2 2001/10/29 05:13:01 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Page::ISA = qw( OpenInteract::SQLInstall );

my %files = (
  tables   => [ 'page.sql', 'page_content.sql', 'content_type.sql' ],
  data     => [ 'content_types.dat', 'page.dat' ],
  security => [ 'install_security.dat' ],
);

%HANDLERS = (
  create_structure => { '_default_' => [ 'create_structure',
                                         { table_file_list => $files{tables} } ] },
  install_data     => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{data} } ] },
  install_security => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{security} } ] },
);

1;
