use strict;
use warnings;

use ExtUtils::MakeMaker;
use Alien::Base::Wrapper qw( Alien::LibXMLSec Alien::Libxml2 !export );

WriteMakefile(
    NAME => 'XML::LibXMLSec',
    LICENSE => 'perl_5',
    AUTHOR => 'Gianni Ceccarelli <gianni.ceccarelli@broadbean.com>',
    ABSTRACT_FROM => 'lib/XML/LibXMLSec.pm',
    VERSION_FROM => 'lib/XML/LibXMLSec.pm',
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => '0',
        'Alien::Base::Wrapper' => '1.51',
        'Alien::LibXMLSec' => '0.007',
        'Alien::Libxml2' => '0.17',
    },
    Alien::Base::Wrapper->mm_args,
    PREREQ_PM => {
        'XML::LibXML' => 0,
    },
    TEST_REQUIRES => {
        'Test::More' => 0,
    },
    test => {
        RECURSIVE_TEST_FILES=>1,
    },
    MAGICXS => 1, # make sure we compile all the XS/C files
    META_MERGE => {
        "meta-spec" => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url => 'git://bitbucket.org/broadbean/p5-xml-libxmlsec.git',
                web => 'https://bitbucket.org/broadbean/p5-xml-libxmlsec',
            },
        },
    },
);
