# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210204173827;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6473930", "Waihi",
"6498825", "Maungaturoto",
"6433951", "Timaru",
"6496994", "Dargaville",
"6433993", "Te\ Anau",
"6436613", "Wanaka",
"6472149", "Whangamata",
"6435952", "Christchurch",
"6434277", "Ranfurly",
"6434404", "Alexandra",
"6468821", "Featherston",
"6439008", "Timaru",
"6465616", "Hawera",
"64338", "Christchurch",
"6466508", "Napier\/Wairoa",
"6439326", "Rangiora",
"6439736", "Riverton",
"6439709", "Motueka",
"6436583", "Te\ Anau",
"644924", "Wellington",
"6499461", "Whangarei",
"6469576", "Dannevirke",
"6499451", "Warkworth",
"6432812", "Haast",
"6473332", "Rotorua",
"6475615", "Waihi",
"6499423", "Great\ Barrier\ Island",
"6478076", "Te\ Awamutu",
"6472613", "Putaruru\/Tokoroa",
"649600", "Auckland",
"6499043", "Hibiscus\ Coast",
"6432654", "Blenheim",
"6432639", "Edendale",
"6432606", "Dunedin",
"6432664", "Christchurch",
"643453", "Dunedin",
"6499066", "Helensville",
"6439341", "Fairlie",
"643304", "Ashburton\/Akaroa\/Chatham\ Islands",
"6435950", "Christchurch",
"6449084", "Wellington",
"6499004", "Hibiscus\ Coast",
"649423", "Warkworth",
"6443333", "Paraparaumu",
"6432637", "Winton",
"649818", "Auckland",
"646656", "Levin",
"6437445", "Fox\ Glacier",
"6439707", "Takaka",
"644810", "Wellington",
"6473932", "Rotorua",
"644817", "Wellington",
"644210", "Wellington",
"6439318", "Lumsden",
"6436998", "Blenheim",
"6439531", "Timaru",
"649218", "Auckland",
"643434", "Oamaru",
"643465", "Palmerston",
"6434236", "Amberley",
"6434279", "Twizel",
"6437481", "Invercargill",
"643466", "Dunedin",
"6472147", "Paeroa",
"64953", "Auckland",
"6478998", "Hamilton",
"6449741", "Paraparaumu",
"649631", "Auckland",
"6432810", "Franz\ Josef",
"643288", "Christchurch",
"646214", "Gisborne",
"6495563", "Whangarei",
"6474651", "Otorohanga",
"647374", "Taupo",
"644913", "Wellington",
"6494704", "Whangarei",
"6439450", "Invercargill",
"6462119", "Wairoa",
"6432737", "Palmerston",
"6432999", "Invercargill",
"644589", "Wellington",
"6439278", "Invercargill",
"6479007", "Whakatane",
"647857", "Hamilton",
"647850", "Hamilton",
"643943", "Christchurch",
"6468262", "Napier",
"644436", "Wellington",
"649982", "Whangarei",
"6468252", "Dannevirke",
"6435687", "Lumsden",
"6462120", "Palmerston\ North",
"6434992", "Ranfurly",
"6469283", "Opunake",
"6495588", "Hibiscus\ Coast",
"6472828", "Tauranga",
"6435517", "Lawrence",
"6439723", "Blenheim",
"6439333", "Franz\ Josef",
"6472600", "Hamilton",
"646845", "Napier\/Hastings",
"644464", "Wellington",
"644904", "Paraparaumu",
"6496882", "Auckland",
"6499479", "Pukekohe",
"643657", "Queenstown",
"6439761", "Kurow",
"6472457", "Rotorua",
"6439751", "Culverden",
"649963", "Auckland",
"6468250", "Stratford",
"6468815", "Pahiatua",
"6499477", "Pukekohe",
"649403", "Kawakawa",
"6468260", "Featherston",
"6443709", "Paraparaumu",
"6472459", "Rotorua",
"6436568", "Roxburgh",
"6434990", "Queenstown",
"6462815", "Wairoa",
"6462122", "Palmerston\ North",
"643484", "Dunedin",
"6494315", "Warkworth",
"6479708", "Thames",
"6467553", "New\ Plymouth",
"6462604", "Ohakune",
"6435519", "Twizel",
"6436655", "Westport",
"6439452", "Gore",
"6477883", "Hamilton",
"643926", "Christchurch",
"6434223", "Otautau",
"6472816", "Morrinsville",
"649956", "Auckland",
"6479009", "Hamilton",
"647211", "Hamilton",
"6496880", "Auckland",
"6475621", "Tauranga",
"643925", "Christchurch",
"6439885", "Fox\ Glacier",
"6463901", "Gisborne",
"647386", "Taupo",
"6432803", "Otautau",
"6472124", "Matamata",
"644555", "Wellington",
"6435689", "Otautau",
"6468888", "Masterton",
"6436638", "Kurow",
"647544", "Tauranga",
"6472602", "Hamilton",
"6479293", "Hamilton",
"6434293", "Haast",
"644496", "Wellington",
"6447771", "Paraparaumu",
"6466004", "Waipukurau",
"644495", "Wellington",
"6468991", "Gisborne",
"6432739", "Balclutha",
"6432997", "Edendale",
"6432754", "Tokanui",
"6472194", "Whakatane",
"6434261", "Balclutha",
"647870", "Te\ Awamutu",
"647877", "Te\ Kuiti",
"6463906", "Napier",
"647372", "Taupo",
"6495533", "Whangarei",
"6439050", "Geraldine",
"6475626", "Taupo",
"6472811", "Tauranga",
"6496997", "Hibiscus\ Coast",
"6439060", "Greymouth",
"643463", "Palmerston",
"6434274", "Kurow",
"643903", "Christchurch",
"6434266", "Palmerston",
"6437448", "Haast",
"64687", "Napier\/Hastings",
"6468996", "Napier",
"649984", "Auckland",
"6436995", "Westport",
"6439315", "Tokanui",
"6435542", "Riverton",
"649638", "Auckland",
"6462623", "Stratford",
"6465625", "Gisborne",
"644462", "Wellington",
"646653", "Wanganui",
"644902", "Paraparaumu",
"6439743", "Christchurch",
"643455", "Dunedin",
"644909", "Wellington",
"649426", "Hibiscus\ Coast",
"6439523", "Balclutha",
"643456", "Dunedin",
"6469272", "Featherston",
"6499009", "Auckland",
"649211", "Auckland",
"6478995", "Matamata",
"6469202", "Levin",
"649425", "Warkworth",
"6469303", "Waipukurau",
"649811", "Auckland",
"6498816", "Great\ Barrier\ Island",
"6468693", "Gisborne",
"6466550", "New\ Plymouth",
"6432657", "Motueka",
"6439863", "Motueka",
"6499007", "Kaikohe",
"643482", "Dunedin",
"647982", "Hamilton",
"6439853", "Amberley",
"6435540", "Edendale",
"6432634", "Invercargill",
"6432659", "Takaka",
"6432669", "Rangiora",
"6439766", "Balclutha",
"647989", "Taupo",
"6439005", "Invercargill",
"6439075", "Takaka",
"643489", "Dunedin",
"6439756", "Akaroa",
"6439704", "Murchison",
"6439052", "Mt\ Cook",
"6469200", "Gisborne",
"6469270", "Marton",
"6472144", "Matamata",
"6466552", "New\ Plymouth",
"6434243", "Akaroa",
"647549", "Tauranga",
"6478144", "Tauranga",
"646378", "Masterton",
"6475618", "Opotiki",
"647542", "Tauranga",
"6496999", "Auckland",
"6436683", "Rangiora",
"644576", "Wellington",
"6469468", "Featherston",
"6466009", "Waiouru",
"643231", "Invercargill",
"6436502", "Amberley",
"6493932", "Dargaville",
"644493", "Wellington",
"6435690", "Motueka",
"6468818", "Opunake",
"6432734", "Waimate",
"6434231", "Christchurch",
"6462818", "New\ Plymouth",
"6436565", "Twizel",
"6437486", "Tokanui",
"6472199", "Opotiki",
"647218", "Tauranga",
"6433943", "Amberley",
"649953", "Auckland",
"6478129", "Matamata",
"6479004", "Te\ Awamutu",
"6474656", "Te\ Awamutu",
"643923", "Nelson",
"6472129", "Whangamata",
"6435684", "Winton",
"6436658", "Fox\ Glacier",
"6479752", "Rotorua",
"644922", "Wellington",
"6435514", "Palmerston",
"6462609", "Pahiatua",
"6436635", "Fairlie",
"6468885", "New\ Plymouth",
"6437773", "Dunedin",
"6466990", "Mokau",
"643552", "Dunedin",
"6499630", "Pukekohe",
"6469310", "Wanganui",
"6499061", "Hibiscus\ Coast",
"6439346", "Christchurch",
"649965", "Auckland",
"649405", "Kaikohe",
"6469002", "Hawera",
"649966", "Auckland",
"6439536", "Waimate",
"649406", "Kaitaia",
"646368", "Levin",
"649640", "Auckland",
"6498881", "Hibiscus\ Coast",
"647867", "Thames",
"6499466", "Kaikohe",
"64992", "Auckland",
"6469571", "Palmerston\ North",
"6496013", "Whangarei",
"643751", "Fox\ Glacier",
"643439", "Oamaru",
"6499474", "Helensville",
"6499456", "Kaikohe",
"646590", "Palmerston\ North",
"6479750", "Tauranga",
"6439321", "Amberley",
"643302", "Ashburton\/Akaroa\/Chatham\ Islands",
"647362", "Rotorua",
"6439731", "Gore",
"6435692", "Takaka",
"6493930", "Whangarei",
"6462607", "Taihape",
"6436500", "Christchurch",
"643432", "Oamaru",
"6439275", "Nelson",
"646843", "Napier\/Hastings",
"6475823", "Hamilton",
"6478071", "Otorohanga",
"6499552", "Dargaville",
"6469000", "New\ Plymouth",
"643946", "Invercargill",
"643667", "Christchurch",
"6492006", "Helensville",
"643660", "Christchurch",
"6499819", "Helensville",
"6433956", "Dunedin",
"6472127", "Paeroa",
"644916", "Wellington",
"6479842", "Matamata",
"6465611", "Napier",
"644915", "Wellington",
"6466007", "Stratford",
"6472197", "Tauranga",
"643768", "Greymouth",
"6432994", "Otautau",
"6468826", "Levin",
"6469312", "Ohakune",
"6432757", "Lumsden",
"6466992", "Hawera",
"6462114", "Waipukurau",
"6478070", "Morrinsville",
"6439319", "Otautau",
"6436999", "Nelson",
"6434232", "Ashburton",
"6462423", "Gisborne",
"6436501", "Akaroa",
"643419", "Balclutha",
"6493931", "Whangarei",
"6439730", "Invercargill",
"6439320", "Akaroa",
"6479751", "Tauranga",
"643412", "Balclutha",
"6469570", "Palmerston\ North",
"6499062", "Hibiscus\ Coast",
"646967", "New\ Plymouth",
"646839", "Napier\/Hastings",
"6478999", "Hamilton",
"6499005", "Auckland",
"6465610", "Napier",
"6498882", "Whangarei",
"649220", "Auckland",
"643250", "Christchurch",
"643443", "Wanaka",
"6439007", "Dunedin",
"6434278", "Roxburgh",
"6496513", "Whangarei",
"646273", "Hawera",
"6469001", "New\ Plymouth",
"649820", "Auckland",
"649827", "Auckland",
"6437444", "Takaka",
"6439322", "Culverden",
"6472803", "Waihi",
"6437473", "Milton",
"649914", "Auckland",
"644777", "Wellington",
"6439732", "Otautau",
"6472148", "Waihi",
"6469572", "Palmerston\ North",
"647926", "Tauranga",
"6465627", "Levin",
"6432816", "Waimate",
"647838", "Hamilton",
"6439079", "Murchison",
"643425", "Dunedin",
"647925", "Tauranga",
"643211", "Invercargill",
"6439009", "Greymouth",
"6435663", "Twizel",
"6434230", "Christchurch",
"6432655", "Nelson",
"6499551", "Whangarei",
"6478072", "Paeroa",
"6479230", "Opotiki",
"6439293", "Blenheim",
"6435691", "Murchison",
"6478997", "Morrinsville",
"6475614", "Thames",
"6432713", "Ashburton",
"6432638", "Tokanui",
"643984", "Blenheim",
"6496995", "Maungaturoto",
"6498880", "Helensville",
"649881", "Auckland",
"649903", "Auckland",
"646759", "New\ Plymouth",
"6498824", "Kawakawa",
"649281", "Auckland",
"64944", "Auckland",
"6435533", "Murchison",
"6436997", "Motueka",
"6469311", "Palmerston\ North",
"6466991", "Wanganui",
"6435956", "Christchurch",
"6499631", "Pukekohe",
"6439317", "Gore",
"6466509", "Napier\/Waipukurau",
"6479841", "Huntly",
"6434405", "Alexandra",
"6466579", "Featherston",
"6465612", "Waipukurau",
"6439708", "Murchison",
"646752", "New\ Plymouth",
"6472812", "Tauranga",
"6472125", "Huntly",
"6468243", "Napier",
"6439884", "Franz\ Josef",
"6443990", "Paraparaumu",
"6479709", "Matamata",
"6435518", "Milton",
"6443708", "Paraparaumu",
"6472195", "Rotorua",
"6472606", "Huntly",
"6472458", "Rotorua",
"6436569", "Alexandra",
"647533", "Tauranga",
"6435541", "Te\ Anau",
"6432755", "Edendale",
"649291", "Auckland",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6466005", "Mokau",
"646348", "Wanganui",
"6432738", "Oamaru",
"6462814", "Hawera",
"6494314", "Warkworth",
"649585", "Auckland",
"646764", "Stratford",
"6473993", "Te\ Awamutu",
"649473", "Auckland",
"646387", "Waiouru",
"6468814", "Dannevirke",
"6462126", "Pahiatua",
"6472827", "Tauranga",
"6473923", "Otorohanga",
"6436654", "Tokanui",
"649200", "Auckland",
"6435688", "Queenstown",
"6468889", "Levin",
"6436639", "Oamaru",
"649439", "Dargaville",
"6462605", "Marton",
"6469271", "Pahiatua",
"6439277", "Invercargill",
"6469201", "Ruatoria",
"6479008", "Rotorua",
"6439456", "Riverton",
"6465603", "Palmerston\ North",
"6474443", "Matamata",
"6468887", "Gisborne",
"6436637", "Twizel",
"643529", "Nelson",
"6495589", "Pukekohe",
"6445953", "Wellington",
"6472829", "Tauranga",
"6439279", "Christchurch",
"643965", "Christchurch",
"6439023", "Te\ Anau",
"647905", "Taupo",
"647466", "Tauranga",
"643966", "Christchurch",
"647906", "Taupo",
"646856", "Waipukurau",
"6439061", "Greymouth",
"6472810", "Tauranga",
"643336", "Christchurch",
"6497773", "Dargaville",
"649552", "Pukekohe",
"643522", "Nelson",
"646855", "Waipukurau",
"6462118", "Waipukurau",
"6432998", "Tokanui",
"643335", "Christchurch",
"647888", "Matamata",
"6466551", "New\ Plymouth",
"6436567", "Ranfurly",
"647847", "Hamilton",
"6475950", "Hamilton",
"6493943", "Helensville",
"6494705", "Whangarei",
"647304", "Whakatane",
"6499478", "Pukekohe",
"646321", "Marton",
"646863", "Gisborne",
"6435526", "Kurow",
"6468256", "Palmerston\ North",
"647349", "Rotorua",
"643688", "Timaru",
"6434996", "Roxburgh",
"6466523", "Palmerston\ North",
"64347", "Dunedin",
"6435553", "Wanaka",
"6477773", "Taupo",
"647552", "Tauranga",
"6435563", "Queenstown",
"644280", "Wellington",
"6466556", "Stratford",
"644887", "Wellington",
"6462223", "Palmerston\ North",
"649888", "Auckland",
"6472145", "Huntly",
"6432658", "Murchison",
"6434991", "Cromwell",
"6432668", "Blenheim",
"649905", "Auckland",
"6468261", "Masterton",
"6469713", "Stratford",
"6468251", "Wanganui",
"646308", "Featherston",
"6434260", "Oamaru",
"6496998", "Helensville",
"6432635", "Riverton",
"649349", "Auckland",
"643218", "Invercargill",
"6442429", "Paraparaumu",
"6468990", "Ruatoria",
"6447770", "Paraparaumu",
"6475619", "Hamilton",
"646762", "Stratford",
"64997", "Auckland",
"6439762", "Oamaru",
"6439752", "Cheviot",
"6463900", "Gisborne",
"649840", "Auckland",
"6496881", "Auckland",
"646769", "New\ Plymouth",
"6475620", "Tauranga",
"6439705", "Motueka",
"6439066", "Hokitika",
"649847", "Auckland",
"6437447", "Greymouth",
"6439004", "Gore",
"647923", "Whakatane",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6462121", "Palmerston\ North",
"6465624", "Featherston",
"643445", "Cromwell",
"643446", "Roxburgh",
"6437449", "Hokitika",
"6439451", "Invercargill",
"6469276", "Wanganui",
"6475617", "Whakatane",
"6478994", "Tauranga",
"6462153", "New\ Plymouth",
"649554", "Hibiscus\ Coast",
"643524", "Takaka",
"6449123", "Wellington",
"6462163", "New\ Plymouth",
"6463902", "Gisborne",
"6439750", "Kaikoura",
"6439760", "Twizel",
"643260", "Christchurch",
"6499008", "Pukekohe",
"6475622", "Tauranga",
"6436994", "Murchison",
"6439314", "Winton",
"647309", "Whakatane",
"6434262", "Alexandra",
"6472601", "Hamilton",
"6434353", "Twizel",
"6435546", "Greymouth",
"6434275", "Milton",
"6468992", "Wairoa",
"6439530", "Timaru",
"646865", "Gisborne",
"6433952", "Fairlie",
"6432995", "Winton",
"644525", "Wellington",
"649238", "Pukekohe",
"6479846", "Taumarunui",
"6462115", "Wairoa",
"6435993", "Mt\ Cook",
"644526", "Wellington",
"643955", "Dunedin",
"646328", "Palmerston\ North",
"6435951", "Christchurch",
"643681", "Timaru",
"6466996", "Stratford",
"643956", "Timaru",
"6439340", "Mt\ Cook",
"6469316", "Dannevirke",
"6468822", "Masterton",
"6474650", "Morrinsville",
"6499462", "Whangarei",
"6463913", "Hawera",
"6462817", "Napier",
"643270", "Christchurch",
"6499452", "Warkworth",
"6432811", "Fox\ Glacier",
"6499475", "Hibiscus\ Coast",
"6468817", "Stratford",
"6449740", "Paraparaumu",
"647315", "Opotiki",
"6436657", "Franz\ Josef",
"6435696", "Haast",
"6499818", "Great\ Barrier\ Island",
"647881", "Matamata",
"6473331", "Rotorua",
"646834", "Napier\/Hastings",
"647463", "Whakatane",
"643963", "Christchurch",
"6472116", "Thames",
"6437480", "Gore",
"643741", "Christchurch",
"6439274", "Queenstown",
"647903", "Hamilton",
"6499556", "Maungaturoto",
"6439266", "Dunedin",
"649650", "Auckland",
"6472128", "Waihi",
"643393", "Christchurch",
"6436634", "Mt\ Cook",
"6468884", "Palmerston\ North",
"6436659", "Haast",
"6468820", "Palmerston\ North",
"6435515", "Oamaru",
"6439342", "Geraldine",
"649912", "Auckland",
"6478128", "Huntly",
"6473843", "Taupo",
"6432758", "Otautau",
"6469006", "Gisborne",
"6462819", "Levin",
"6439532", "Timaru",
"644801", "Wellington",
"649583", "Auckland",
"6472198", "Opotiki",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6466008", "Ohakune",
"649475", "Auckland",
"649476", "Auckland",
"649919", "Auckland",
"6473931", "Whangamata",
"6468819", "Mokau",
"6469613", "Levin",
"6436564", "Milton",
"64456", "Wellington",
"644399", "Wellington",
"647220", "Tauranga",
"6436576", "Cromwell",
"6436506", "Darfield",
"647322", "Whakatane",
"6432735", "Mt\ Cook",
"6493936", "Maungaturoto",
"6437482", "Lumsden",
"647827", "Hamilton",
"643982", "Christchurch",
"6479853", "Putaruru",
"64933", "Auckland",
"6435685", "Tokanui",
"6499450", "Warkworth",
"644290", "Paraparaumu",
"644297", "Paraparaumu",
"649298", "Auckland",
"644392", "Wellington",
"6499460", "Whangarei",
"646341", "Wanganui",
"6474652", "Paeroa",
"646754", "New\ Plymouth",
"643989", "Nelson",
"6479005", "Tauranga",
"6478083", "Hamilton",
"644890", "Wellington",
"6462608", "Dannevirke",
"644897", "Wellington",
"6495539", "Auckland",
"6436687", "Nelson",
"6495564", "Whangarei",
"6462158", "Opunake",
"6439011", "Queenstown",
"6436522", "Greymouth",
"643331", "Christchurch",
"6469017", "Marton",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6462168", "Featherston",
"6437450", "Westport",
"6439286", "Cromwell",
"6434247", "Kaikoura",
"6439048", "Lawrence",
"6498018", "Whangarei",
"6479247", "Hamilton",
"643743", "Christchurch",
"643961", "Christchurch",
"6466010", "Taihape",
"647883", "Putaruru\/Tokoroa",
"6478136", "Te\ Awamutu",
"6436592", "Nelson",
"6435670", "Palmerston",
"6462425", "Masterton",
"649236", "Pukekohe",
"6439749", "Christchurch",
"644528", "Wellington",
"649235", "Pukekohe",
"6466548", "Ruatoria",
"6499872", "Whangarei",
"6499299", "Whangarei",
"646326", "Palmerston\ North",
"6462629", "Levin",
"644920", "Wellington",
"646325", "Palmerston\ North",
"6496515", "Dargaville",
"646868", "Gisborne",
"643683", "Timaru",
"6469893", "Ruatoria",
"6469309", "Mokau",
"6478592", "Hamilton",
"6469851", "Napier",
"6439529", "Palmerston",
"6449083", "Wellington",
"6439857", "Akaroa",
"6433982", "Kurow",
"6436517", "Motueka",
"6462610", "Napier",
"6432646", "Timaru",
"6469022", "Hawera",
"6499003", "Warkworth",
"6442821", "Wellington",
"6432653", "Wanaka",
"649295", "Auckland",
"6499044", "Hibiscus\ Coast",
"6435665", "Waimate",
"6432663", "Christchurch",
"643300", "Ashburton\/Akaroa\/Chatham\ Islands",
"6478091", "Matamata",
"649296", "Auckland",
"649941", "Auckland",
"6469307", "Stratford",
"643307", "Ashburton\/Akaroa\/Chatham\ Islands",
"6499424", "Auckland",
"6439869", "Blenheim",
"6436519", "Takaka",
"6432715", "Culverden",
"6436590", "Nelson",
"6435672", "Balclutha",
"647862", "Paeroa",
"6472614", "Otorohanga",
"6439295", "Nelson",
"6466012", "Pahiatua",
"6439527", "Kurow",
"6436584", "Winton",
"6477778", "Te\ Awamutu",
"6435558", "Waimate",
"6439747", "Wanaka",
"6437475", "Palmerston",
"6472805", "Morrinsville",
"6437452", "Akaroa",
"643437", "Oamaru",
"647869", "Thames",
"643430", "Mt\ Cook",
"646343", "Wanganui",
"6437462", "Geraldine",
"6436520", "Greymouth",
"6462627", "Wanganui",
"6462228", "Wanganui",
"6499297", "Hibiscus\ Coast",
"6432621", "Oamaru",
"6478590", "Hamilton",
"6475483", "Tauranga",
"6479249", "Huntly",
"6435535", "Invercargill",
"6434249", "Kaikoura",
"6436614", "Timaru",
"6469020", "Stratford",
"6473948", "Opotiki",
"6433980", "Milton",
"649478", "Auckland",
"6499870", "Whangarei",
"643669", "Christchurch",
"6496993", "Whangarei",
"6436689", "Christchurch",
"6468806", "New\ Plymouth",
"644203", "Wellington",
"6433994", "Winton",
"644803", "Wellington",
"649581", "Auckland",
"6469019", "Pahiatua",
"6462806", "Napier\/Hastings",
"6475606", "Matamata",
"6432753", "Winton",
"644245", "Wellington",
"6472193", "Whakatane",
"6436640", "Palmerston",
"647377", "Taupo",
"6479294", "Hamilton",
"6432615", "Amberley",
"647833", "Hamilton",
"6499728", "Dargaville",
"6466003", "Ruatoria",
"6434294", "Franz\ Josef",
"6463926", "Taihape",
"647872", "Te\ Awamutu",
"643421", "Christchurch",
"6434280", "Queenstown",
"6472123", "Morrinsville",
"643215", "Invercargill",
"6432804", "Riverton",
"647921", "Rotorua",
"647854", "Hamilton",
"646949", "Levin\ W100",
"643216", "Invercargill",
"649451", "Auckland",
"6463996", "Palmerston\ North",
"6433949", "Rangiora",
"6468245", "Wairoa",
"6432721", "Motueka",
"6434224", "Te\ Anau",
"6475827", "Hamilton",
"6437779", "Invercargill",
"6473925", "Putaruru\/Tokoroa",
"6477884", "Tauranga",
"6432420", "Christchurch",
"644900", "Wellington",
"644467", "Wellington",
"6465605", "Marton",
"644907", "Wellington",
"644460", "Wellington",
"6499010", "Kaitaia",
"649908", "Auckland",
"6469292", "Ruatoria",
"6492830", "Auckland",
"6467554", "New\ Plymouth",
"6462603", "Palmerston\ North",
"646306", "Featherston",
"6473995", "Putaruru\/Tokoroa",
"643654", "Timaru",
"6479858", "Whakatane",
"649886", "Auckland",
"6496017", "Great\ Barrier\ Island",
"6492808", "Great\ Barrier\ Island",
"6497775", "Helensville",
"643693", "Geraldine",
"6434282", "Queenstown",
"6435998", "Rangiora",
"647980", "Hamilton",
"6496019", "Auckland",
"643487", "Dunedin",
"6479711", "Whangamata",
"647987", "Tauranga",
"6462411", "New\ Plymouth",
"6479748", "Taumarunui",
"6436642", "Milton",
"6445955", "Wellington",
"6474445", "Hamilton",
"6437777", "Christchurch",
"6439871", "Queenstown",
"6475829", "Hamilton",
"6467771", "New\ Plymouth",
"6439724", "Blenheim",
"6472221", "Tauranga",
"6435881", "Dunedin",
"6439025", "Otautau",
"6439334", "Fox\ Glacier",
"6498690", "Kawakawa",
"6479049", "Te\ Kuiti",
"6474649", "Matamata",
"6469284", "Stratford",
"6492226", "Helensville",
"644931", "Wellington",
"6493206", "Pukekohe",
"6466525", "Marton",
"6433947", "Darfield",
"6463941", "Masterton",
"647893", "Taumarunui",
"6499716", "Helensville",
"6499101", "Pukekohe",
"647547", "Tauranga",
"6463918", "Wanganui",
"6492832", "Dargaville",
"6469290", "Napier\/Hastings",
"6499012", "Kawakawa",
"643448", "Alexandra",
"646278", "Hawera",
"6494703", "Whangarei",
"6432746", "Alexandra",
"6436684", "Dunedin",
"6499748", "Whangarei",
"6495567", "Kaitaia",
"6433999", "Otautau",
"644205", "Wellington",
"6433910", "Nelson",
"6435668", "Kurow",
"6469715", "Mokau",
"644805", "Wellington",
"6492221", "Auckland",
"6468301", "Napier",
"6439298", "Motueka",
"644806", "Wellington",
"6436620", "Kaikoura",
"6432718", "Rangiora",
"6469014", "Dannevirke",
"64635", "Palmerston\ North",
"6472808", "Putaruru\/Tokoroa",
"6437478", "Twizel",
"649588", "Auckland",
"6462100", "Levin",
"6435555", "Timaru",
"647350", "Rotorua",
"6477775", "Huntly",
"6434244", "Amberley",
"6432741", "Milton",
"644587", "Wellington",
"6479244", "Tauranga",
"6478143", "Opotiki",
"647357", "Rotorua",
"6435502", "Christchurch",
"6462225", "Levin",
"6472143", "Morrinsville",
"6436619", "Cheviot",
"649980", "Auckland",
"647852", "Hamilton",
"6479027", "Paeroa",
"6479716", "Waihi",
"6479101", "Rotorua",
"6432440", "Christchurch",
"6462416", "Waipukurau",
"6435538", "Lumsden",
"6436589", "Otautau",
"644666", "Wellington",
"6472620", "Tauranga",
"646345", "Wanganui",
"6473945", "Tauranga",
"649948", "Auckland",
"6439703", "Takaka",
"646346", "Wanganui",
"6432633", "Otautau",
"6469242", "Levin",
"6472226", "Te\ Kuiti",
"6499049", "Great\ Barrier\ Island",
"6435886", "Invercargill",
"6439864", "Takaka",
"6467776", "Levin",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6439876", "Roxburgh",
"6469304", "Wairoa",
"643685", "Fairlie",
"6462102", "Levin",
"643686", "Timaru",
"6499047", "Pukekohe",
"643951", "Dunedin",
"6439524", "Oamaru",
"6462165", "Stratford",
"643224", "Invercargill",
"6435500", "Christchurch",
"6462155", "Hawera",
"6439744", "Queenstown",
"6433912", "Motueka",
"6436587", "Gore",
"6439045", "Twizel",
"649233", "Pukekohe",
"6462624", "Opunake",
"646861", "Gisborne",
"6436622", "Cheviot",
"646323", "Palmerston\ North",
"6439081", "Ashburton",
"646858", "Waipukurau",
"643338", "Christchurch",
"6463921", "Palmerston\ North",
"6469240", "Gisborne",
"6475601", "Hamilton",
"6434273", "Lawrence",
"6496518", "Kawakawa",
"6479029", "Waihi",
"647885", "Putaruru\/Tokoroa",
"6436617", "Cromwell",
"647886", "Putaruru\/Tokoroa",
"6463991", "Masterton",
"646601", "Napier",
"6433997", "Gore",
"6495569", "Maungaturoto",
"6432726", "Franz\ Josef",
"6432442", "Christchurch",
"6462138", "Palmerston\ North",
"6472622", "Tauranga",
"643968", "Christchurch",
"6479010", "Thames",
"6435995", "Darfield",
"6442609", "Paraparaumu",
"6497778", "Pukekohe",
"6498852", "Warkworth",
"6432993", "Balclutha",
"649869", "Auckland",
"649930", "Auckland",
"6479297", "Tauranga",
"644938", "Wellington",
"6434297", "Westport",
"6439098", "Akaroa",
"6469289", "Taihape",
"6474448", "Taumarunui",
"6462801", "Palmerston\ North",
"643441", "Queenstown",
"6432807", "Tokanui",
"6434227", "Riverton",
"6439028", "Edendale",
"6468801", "Wanganui",
"647896", "Taumarunui",
"647895", "Taumarunui",
"6477887", "Te\ Awamutu",
"6475824", "Hamilton",
"6467557", "New\ Plymouth",
"6439729", "Fox\ Glacier",
"6432220", "Dunedin",
"6466528", "Dannevirke",
"6463915", "Opunake",
"643696", "Geraldine",
"6432626", "Kurow",
"6496014", "Dargaville",
"643978", "Christchurch",
"6439710", "Timaru",
"6499473", "Helensville",
"644219", "Wellington",
"647864", "Thames",
"649883", "Auckland",
"6469615", "Masterton",
"644819", "Wellington",
"6499725", "Hibiscus\ Coast",
"6432618", "Culverden",
"6437774", "Queenstown",
"6498850", "Great\ Barrier\ Island",
"6477889", "Whakatane",
"6432641", "Franz\ Josef",
"643249", "Te\ Anau",
"644212", "Wellington",
"6468248", "New\ Plymouth",
"6439337", "Wanaka",
"6467559", "New\ Plymouth",
"6439727", "Dunedin",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"644590", "Wellington",
"6432809", "Hokitika",
"6469040", "Wairoa",
"643213", "Invercargill",
"6473928", "Te\ Awamutu",
"6439016", "Alexandra",
"6435683", "Te\ Anau",
"6439281", "Christchurch",
"6469287", "Ohakune",
"6492426", "Whangarei",
"6433944", "Ashburton",
"6439712", "Fairlie",
"6478085", "Tauranga",
"6479003", "Thames",
"6479229", "Opotiki",
"6465608", "Dannevirke",
"6434229", "Winton",
"6478131", "Otorohanga",
"6432733", "Geraldine",
"6473998", "Taumarunui",
"6434299", "Haast",
"647928", "Tauranga",
"6432222", "Christchurch",
"6479855", "Taupo",
"6479299", "Rotorua",
"647836", "Hamilton",
"6472131", "Rotorua",
"649458", "Dargaville",
"6472420", "Hamilton",
"646365", "Palmerston\ North",
"649968", "Auckland",
"6436615", "Ashburton",
"649408", "Kaitaia",
"646366", "Levin",
"6432640", "Hokitika",
"6435534", "Takaka",
"6462616", "Ruatoria",
"6435559", "Haast",
"6477779", "Putaruru\/Tokoroa",
"6498851", "Pukekohe",
"6439868", "Blenheim",
"6468802", "New\ Plymouth",
"6436518", "Murchison",
"6498823", "Kaitaia",
"6439858", "Kaikoura",
"6433995", "Tokanui",
"6462802", "Palmerston\ North",
"643615", "Timaru",
"6439294", "Dunedin",
"6472615", "Te\ Kuiti",
"6462167", "Mokau",
"6472130", "Tauranga",
"646964", "Wanganui",
"6475613", "Te\ Awamutu",
"6499425", "Auckland",
"6432714", "Cheviot",
"6462157", "Stratford",
"6435676", "Kurow",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6499045", "Hibiscus\ Coast",
"6435664", "Timaru",
"6478130", "Morrinsville",
"644551", "Paraparaumu",
"6473949", "Taupo",
"6437456", "Culverden",
"6437474", "Oamaru",
"6439280", "Nelson",
"643921", "Blenheim",
"6472804", "Whangamata",
"647215", "Rotorua",
"6436585", "Tokanui",
"649951", "Auckland",
"6434248", "Cheviot",
"6437466", "Cromwell",
"647216", "Rotorua",
"6439047", "Alexandra",
"6498017", "Hibiscus\ Coast",
"644918", "Wellington",
"6496514", "Whangarei",
"6473947", "Whakatane",
"6499876", "Kaikohe",
"6468800", "Napier\/Hastings",
"6437443", "Nelson",
"649917", "Auckland",
"6498019", "Pukekohe",
"6439049", "Palmerston",
"6462800", "Palmerston\ North",
"649652", "Warkworth",
"6462159", "Mokau",
"6462169", "Featherston",
"643948", "Invercargill",
"6495538", "Auckland",
"6433986", "Queenstown",
"6446509", "Paraparaumu",
"6432642", "Fox\ Glacier",
"6439528", "Lawrence",
"643980", "Christchurch",
"6439711", "Geraldine",
"6436526", "Fox\ Glacier",
"644299", "Paraparaumu",
"6495565", "Dargaville",
"6469308", "Opunake",
"6439282", "Christchurch",
"643753", "Hokitika",
"6462227", "Napier",
"6499298", "Pukekohe",
"6462424", "Wanganui",
"6432221", "Nelson",
"644892", "Paraparaumu",
"6462628", "Wanganui",
"6472132", "Taupo",
"6434359", "Twizel",
"6479025", "Huntly",
"64983", "Auckland",
"647829", "Hamilton",
"6478132", "Paeroa",
"644390", "Wellington",
"6439748", "Dunedin",
"6477777", "Hamilton",
"6435557", "Geraldine",
"6436596", "Queenstown",
"6466549", "Ruatoria",
"644292", "Paraparaumu",
"6492222", "Auckland",
"6468302", "Napier",
"649428", "Hibiscus\ Coast",
"6466524", "Ohakune",
"647958", "Hamilton",
"646651", "Napier",
"646986", "Gisborne",
"647557", "Tauranga",
"6475828", "Hamilton",
"6469285", "Hawera",
"6496018", "Auckland",
"6435501", "Christchurch",
"6479857", "Opotiki",
"6493944", "Hibiscus\ Coast",
"644889", "Wellington",
"649813", "Auckland",
"649213", "Auckland",
"6499016", "Kaikohe",
"6492836", "Kaitaia",
"6492809", "Maungaturoto",
"6432742", "Twizel",
"6432426", "Blenheim",
"6435999", "Christchurch",
"649849", "Auckland",
"6434286", "Christchurch",
"6499727", "Whangarei",
"6479102", "Rotorua",
"6497774", "Warkworth",
"649635", "Auckland",
"649249", "Auckland",
"6463990", "Featherston",
"649636", "Auckland",
"6436646", "Roxburgh",
"6439024", "Lumsden",
"6439335", "Haast",
"6473847", "Taupo",
"6439725", "Christchurch",
"6475600", "Hamilton",
"6469241", "Napier",
"6463920", "Palmerston\ North",
"6474444", "Hamilton",
"6474648", "Huntly",
"649347", "Auckland",
"647961", "Hamilton",
"6439080", "Ashburton",
"6445954", "Wellington",
"646375", "Pahiatua",
"6433948", "Kaikoura",
"6467555", "New\ Plymouth",
"646376", "Pahiatua",
"647391", "Hamilton",
"6465604", "Ohakune",
"6473924", "Paeroa",
"6477885", "Tauranga",
"6432740", "Lawrence",
"6462101", "Levin",
"6469296", "Levin",
"6436653", "Edendale",
"6436621", "Culverden",
"6468813", "Taihape",
"6468300", "Napier",
"6492220", "Auckland",
"6463917", "Wanganui",
"6462813", "Wanganui",
"6433911", "Nelson",
"6494313", "Warkworth",
"6473994", "Rotorua",
"6475602", "Hamilton",
"646974", "Napier",
"6432614", "Akaroa",
"6479295", "Whakatane",
"6479859", "Tauranga",
"6434295", "Fox\ Glacier",
"6439082", "Culverden",
"6435997", "Amberley",
"6492807", "Helensville",
"6463922", "Palmerston\ North",
"647307", "Whakatane",
"6434225", "Edendale",
"6468244", "Waipukurau",
"643930", "Christchurch",
"6439883", "Hokitika",
"6472621", "Tauranga",
"6463992", "Levin",
"643538", "Nelson",
"646952", "Palmerston\ North\ W100",
"6437778", "Greymouth",
"6479747", "Te\ Kuiti",
"6432805", "Winton",
"6479100", "Rotorua",
"6432441", "Christchurch",
"6435880", "Dunedin",
"6472220", "Tauranga",
"6436993", "Kaikoura",
"6467770", "Gisborne",
"6439870", "Queenstown",
"6439313", "Te\ Anau",
"6435537", "Winton",
"6462410", "New\ Plymouth",
"6479710", "Putaruru\/Tokoroa",
"6432446", "Blenheim",
"6432722", "Murchison",
"649391", "Auckland",
"643756", "Hokitika",
"6472626", "Rotorua",
"643755", "Hokitika",
"6478993", "Waihi",
"6462139", "Palmerston\ North",
"6462106", "Pahiatua",
"6462154", "New\ Plymouth",
"6432717", "Kaikoura",
"6439297", "Takaka",
"6449124", "Wellington",
"6469291", "Gisborne",
"646382", "Taihape",
"6439525", "Milton",
"6462164", "New\ Plymouth",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6495568", "Kawakawa",
"6469305", "New\ Plymouth",
"6499100", "Pukekohe",
"6499747", "Dargaville",
"6496519", "Maungaturoto",
"6433916", "Hokitika",
"6463940", "Levin",
"6465623", "Opunake",
"6462625", "Hawera",
"6499295", "Kaikohe",
"6436626", "Akaroa",
"6439044", "Milton",
"6439745", "Greymouth",
"6472807", "Te\ Awamutu",
"6437477", "Roxburgh",
"6498691", "Maungaturoto",
"643941", "Christchurch",
"6473944", "Tauranga",
"6479712", "Te\ Awamutu",
"6436618", "Blenheim",
"6432720", "Nelson",
"644498", "Wellington",
"6462412", "Gisborne",
"6439003", "Ashburton",
"6496517", "Kaitaia",
"6439073", "Motueka",
"6472809", "Otorohanga",
"6437479", "Edendale",
"647213", "Hamilton",
"644619", "Wellington",
"6434281", "Queenstown",
"6439299", "Murchison",
"6469246", "Palmerston\ North",
"6472222", "Hamilton",
"6439855", "Rangiora",
"649958", "Helensville",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6435882", "Dunedin",
"6462137", "Palmerston\ North",
"6439865", "Murchison",
"643527", "Motueka",
"643236", "Winton",
"643520", "Blenheim",
"6436641", "Lawrence",
"643235", "Invercargill",
"6433998", "Lumsden",
"649550", "Auckland",
"6439872", "Alexandra",
"6435669", "Wanaka",
"6467772", "Hawera",
"649557", "Auckland",
"6499428", "Warkworth",
"6469714", "Hawera",
"6463942", "Masterton",
"643782", "Westport",
"6499048", "Pukekohe",
"6436685", "Nelson",
"649401", "Kaikohe",
"647347", "Rotorua",
"6492831", "Maungaturoto",
"647849", "Hamilton",
"646954", "Palmerston\ North\ W100",
"646363", "Levin",
"6499011", "Kaitaia",
"6462224", "Masterton",
"6434245", "Culverden",
"6477774", "Thames",
"6435554", "Cromwell",
"6435539", "Otautau",
"6479245", "Matamata",
"6436588", "Lumsden",
"6435506", "Amberley",
"643789", "Westport",
"6432620", "Palmerston",
"6478084", "Hamilton",
"6466527", "Taihape",
"6439012", "Queenstown",
"6436521", "Greymouth",
"6468249", "Opunake",
"6467558", "New\ Plymouth",
"6433945", "Cheviot",
"6439716", "Geraldine",
"6477888", "Taupo",
"6436591", "Nelson",
"6479854", "Rotorua",
"643417", "Milton",
"6432619", "Christchurch",
"6432226", "Timaru",
"6436563", "Lawrence",
"6478090", "Thames",
"644834", "Paraparaumu",
"6434298", "Hokitika",
"6439097", "Darfield",
"644571", "Wellington",
"6479298", "Taupo",
"649829", "Auckland",
"6469614", "Levin",
"6473999", "Taupo",
"6497777", "Auckland",
"6499871", "Whangarei",
"6469852", "Napier",
"646373", "Masterton",
"649822", "Auckland",
"6433981", "Twizel",
"644488", "Wellington",
"6465609", "Pahiatua",
"6434228", "Tokanui",
"6439027", "Winton",
"6432808", "Westport",
"649320", "Auckland",
"6473929", "Thames",
"6437775", "Wanaka",
"6468883", "Palmerston\ North",
"6478591", "Hamilton",
"6474447", "Te\ Kuiti",
"6436633", "Geraldine",
"646969", "New\ Plymouth",
"646837", "Wairoa",
"6439029", "Tokanui",
"6439273", "Blenheim",
"6465607", "Taihape",
"6435671", "Oamaru",
"6466011", "Marton",
"6475825", "Hamilton",
"6469288", "Waiouru",
"6474449", "Opotiki",
"6478092", "Huntly",
"6472823", "Whakatane",
"6473927", "Te\ Kuiti",
"6437451", "Blenheim",
"6492420", "Auckland",
"643468", "Dunedin",
"6437461", "Fairlie",
"6439010", "Queenstown",
"6496015", "Maungaturoto",
"6432622", "Balclutha",
"647968", "Hamilton",
"6439099", "Kaikoura",
"6442608", "Paraparaumu",
"6497779", "Great\ Barrier\ Island",
"649633", "Auckland",
"6473997", "Te\ Kuiti",
"6463914", "Stratford",
"6436546", "Fairlie",
"649816", "Auckland",
"6442820", "Wellington",
"6432617", "Cheviot",
"6462611", "Napier",
"649815", "Auckland",
"6498856", "Maungaturoto",
"6469850", "Napier",
"649215", "Auckland",
"647824", "Hamilton",
"649421", "Hibiscus\ Coast",
"649216", "Auckland",
"6435994", "Ashburton",
"643451", "Queenstown",
"646750", "Mokau",
"6439728", "Franz\ Josef",
"646757", "New\ Plymouth",
"6468247", "Mokau",
"6439338", "Queenstown",
"6466529", "Pahiatua",
"644894", "Wellington",
"643732", "Greymouth",
"6479045", "Taumarunui",
"643486", "Dunedin",
"6498858", "Kaikohe",
"647986", "Hamilton",
"6434285", "Cheviot",
"643485", "Lawrence",
"6497772", "Kaitaia",
"6436548", "Waimate",
"6439092", "Rangiora",
"6432629", "Roxburgh",
"6445952", "Wellington",
"6436645", "Ranfurly",
"6439336", "Cromwell",
"6449008", "Paraparaumu",
"6439726", "Timaru",
"6474442", "Morrinsville",
"6439851", "Culverden",
"643539", "Nelson",
"6439861", "Nelson",
"6432610", "Darfield",
"64438", "Wellington",
"6473990", "Te\ Awamutu",
"6436681", "Dunedin",
"649954", "Auckland",
"6442125", "Paraparaumu",
"6466522", "Palmerston\ North",
"6439017", "Cromwell",
"643924", "Christchurch",
"6492427", "Warkworth",
"6492224", "Auckland",
"6469286", "Dannevirke",
"6473920", "Huntly",
"6479241", "Whakatane",
"6432744", "Ranfurly",
"6434241", "Rangiora",
"6499015", "Dargaville",
"6492835", "Kaikohe",
"6493942", "Great\ Barrier\ Island",
"6432425", "Invercargill",
"647546", "Tauranga",
"6465600", "Palmerston\ North",
"644494", "Wellington",
"644572", "Wellington",
"6474440", "Paeroa",
"6463924", "Marton",
"6479296", "Tauranga",
"6434296", "Greymouth",
"6445950", "Wellington",
"6439084", "Amberley",
"6439020", "Gore",
"6432612", "Rangiora",
"644240", "Wellington",
"647376", "Taupo",
"649248", "Auckland",
"6475604", "Hamilton",
"6472813", "Waihi",
"6434226", "Lumsden",
"64497", "Wellington",
"6497770", "Whangarei",
"6495531", "Helensville",
"6463994", "Dannevirke",
"6492429", "Pukekohe",
"6439090", "Rangiora",
"6439019", "Roxburgh",
"64957", "Auckland",
"6468242", "Ruatoria",
"6432806", "Edendale",
"643217", "Invercargill",
"649429", "Great\ Barrier\ Island",
"644466", "Wellington",
"644906", "Paraparaumu",
"644465", "Wellington",
"647959", "Hamilton",
"646844", "Napier\/Hastings",
"6468691", "Gisborne",
"646307", "Featherston",
"6478097", "Whakatane",
"644905", "Paraparaumu",
"6473922", "Morrinsville",
"6469301", "Ruatoria",
"643731", "Greymouth",
"647974", "Hamilton",
"6469869", "Ruatoria",
"6465602", "Palmerston\ North",
"6477886", "Rotorua",
"6439521", "Dunedin",
"6469295", "Wanganui",
"6439718", "Mt\ Cook",
"644888", "Wellington",
"6473992", "Opotiki",
"643452", "Wanaka",
"649880", "Auckland",
"649422", "Warkworth",
"649887", "Auckland",
"6439741", "Christchurch",
"649280", "Auckland",
"6466520", "Palmerston\ North",
"6432627", "Alexandra",
"64336", "Christchurch",
"6432228", "Wanaka",
"6462621", "New\ Plymouth",
"6449030", "Paraparaumu",
"6478073", "Tokoroa\/Putaruru",
"6472616", "Taumarunui",
"6435662", "Geraldine",
"6475821", "Hamilton",
"649890", "Auckland",
"6467779", "Masterton",
"6499426", "Auckland",
"6462420", "Palmerston\ North",
"6435675", "Twizel",
"6432712", "Amberley",
"644298", "Paraparaumu",
"6435889", "Timaru",
"649392", "Auckland",
"643305", "Ashburton\/Akaroa\/Chatham\ Islands",
"6499046", "Pukekohe",
"649297", "Auckland",
"647366", "Rotorua",
"6439292", "Timaru",
"643306", "Ashburton\/Akaroa\/Chatham\ Islands",
"643436", "Kurow",
"6439733", "Te\ Anau",
"6472802", "Paeroa",
"647828", "Huntly",
"6437472", "Lawrence",
"6439323", "Cheviot",
"6437455", "Cheviot",
"6496011", "Kaikohe",
"649399", "Auckland",
"646654", "Gisborne",
"6435508", "Cheviot",
"6436586", "Edendale",
"6479719", "Te\ Kuiti",
"6469573", "Palmerston\ North",
"6437465", "Waimate",
"6462419", "Masterton",
"643942", "Christchurch",
"6436616", "Geraldine",
"649983", "Whangarei",
"6435532", "Motueka",
"6462615", "Gisborne",
"643464", "Dunedin",
"649801", "Auckland",
"6479018", "Putaruru\/Tokoroa",
"6465613", "Wairoa",
"6462804", "Palmerston\ North",
"643949", "Dunedin",
"647334", "Rotorua",
"6433996", "Edendale",
"6496510", "Whangarei",
"64337", "Christchurch",
"6479421", "Tauranga",
"644650", "Wellington",
"6468804", "Napier",
"6432727", "Fox\ Glacier",
"6439284", "Blenheim",
"6437470", "Balclutha",
"6472800", "Thames",
"6496100", "Pukekohe",
"6462108", "Ohakune",
"6436525", "Franz\ Josef",
"6432729", "Westport",
"6495566", "Kaikohe",
"64354", "Nelson",
"6433941", "Blenheim",
"6435650", "Greymouth",
"6435660", "Haast",
"6434233", "Rangiora",
"6479026", "Paeroa",
"6433918", "Fox\ Glacier",
"6478134", "Taumarunui",
"6439290", "Christchurch",
"6432710", "Christchurch",
"6436628", "Ashburton",
"6436595", "Mt\ Cook",
"6462422", "Napier\/Hastings",
"646327", "Marton",
"6499875", "Dargaville",
"649409", "Kaitaia",
"6498883", "Whangarei",
"649969", "Auckland",
"6479717", "Otorohanga",
"6462417", "Wanganui",
"649230", "Pukekohe",
"649237", "Pukekohe",
"6496512", "Whangarei",
"6432644", "Westport",
"6435530", "Nelson",
"649962", "Auckland",
"649402", "Kawakawa",
"6432448", "Dunedin",
"6499063", "Hibiscus\ Coast",
"6467777", "Napier",
"6437771", "Blenheim",
"6478595", "Hamilton",
"6433985", "Alexandra",
"6472424", "Tauranga",
"6472628", "Taupo",
"6435887", "Invercargill",
"6469025", "Mokau",
"6479107", "Whakatane",
"6439533", "Geraldine",
"649394", "Auckland",
"643738", "Greymouth",
"6435990", "Hokitika",
"644463", "Wellington",
"644281", "Wellington",
"6443331", "Wellington",
"644903", "Wellington",
"6473842", "Taupo",
"6448880", "Paraparaumu",
"6437776", "Cromwell",
"6469854", "Waipukurau",
"6439343", "Waimate",
"6495561", "Whangarei",
"6444887", "Paraparaumu",
"6474653", "Putaruru\/Tokoroa",
"64948", "Auckland",
"6433946", "Culverden",
"6463999", "Palmerston\ North",
"6439715", "Timaru",
"6469298", "Masterton",
"6492227", "Whangarei",
"6479091", "Taupo",
"643944", "Christchurch",
"64335", "Christchurch",
"6493207", "Hibiscus\ Coast",
"6478082", "Tauranga",
"647837", "Hamilton",
"643469", "Dunedin",
"6432747", "Queenstown",
"6479852", "Whangamata",
"6432225", "Greymouth",
"6437483", "Otautau",
"6499717", "Whangarei",
"6479021", "Te\ Awamutu",
"6475609", "Paeroa",
"644914", "Wellington",
"647332", "Rotorua",
"6432749", "Wanaka",
"6435992", "Fox\ Glacier",
"6434288", "Cromwell",
"6463927", "Dannevirke",
"6498855", "Kawakawa",
"649828", "Auckland",
"6468823", "Napier\/Hastings",
"647543", "Tauranga",
"6475607", "Morrinsville",
"6499719", "Whangarei",
"6436611", "Rangiora",
"6433991", "Invercargill",
"6463997", "Palmerston\ North",
"6436648", "Lumsden",
"6444889", "Paraparaumu",
"6493209", "Great\ Barrier\ Island",
"6433953", "Geraldine",
"6492229", "Hibiscus\ Coast",
"6468309", "Napier",
"646968", "New\ Plymouth\ W100",
"6469610", "Wanganui",
"6478094", "Tauranga",
"6499041", "Helensville",
"646951", "Palmerston\ North",
"6475826", "Hamilton",
"6472611", "Matamata",
"6442128", "Paraparaumu",
"6479850", "Tokoroa",
"6499421", "Hibiscus\ Coast",
"6499453", "Warkworth",
"6463912", "New\ Plymouth",
"6479109", "Opotiki",
"6499463", "Whangarei",
"6496016", "Warkworth",
"6469045", "Waipukurau",
"6436581", "Invercargill",
"647983", "Hamilton",
"643690", "Waimate",
"6432624", "Milton",
"6478080", "Hamilton",
"649964", "Auckland",
"643697", "Geraldine",
"6432428", "Queenstown",
"649404", "Kawakawa",
"6442198", "Paraparaumu",
"6492838", "Pukekohe",
"643576", "Nelson",
"6499018", "Maungaturoto",
"6462105", "Taihape",
"6477770", "Tauranga",
"6477881", "Hamilton",
"6435550", "Fox\ Glacier",
"6432649", "Waimate",
"6435560", "Mt\ Cook",
"6439526", "Twizel",
"6467551", "New\ Plymouth",
"6462162", "Masterton",
"6472429", "Whakatane",
"6449122", "Wellington",
"6462152", "New\ Plymouth",
"643687", "Timaru",
"6469306", "Hawera",
"6462220", "New\ Plymouth",
"643680", "Fairlie",
"64757", "Tauranga",
"6436528", "Westport",
"6433915", "Greymouth",
"647848", "Hamilton",
"6462626", "Mokau",
"6439042", "Oamaru",
"6499296", "Kaitaia",
"6436598", "Wanaka",
"6436625", "Rangiora",
"6469710", "New\ Plymouth",
"6439746", "Dunedin",
"643788", "Westport",
"6424", "Scott\ Base",
"649952", "Auckland",
"644499", "Wellington",
"6434263", "Lawrence",
"6499878", "Warkworth",
"647887", "Morrinsville",
"6478139", "Whangamata",
"647880", "Matamata",
"643922", "Nelson",
"6468993", "Taihape",
"643740", "Christchurch",
"6434291", "Westport",
"64930", "Auckland",
"6479291", "Hamilton",
"6478598", "Hamilton",
"6439289", "Akaroa",
"64943", "Whangarei",
"6432445", "Greymouth",
"6432801", "Lumsden",
"6463903", "Ruatoria",
"649959", "Hibiscus\ Coast",
"6462807", "Napier\/Hastings",
"6475623", "Tauranga",
"6434221", "Invercargill",
"6432724", "Greymouth",
"6468807", "Gisborne",
"6472625", "Opotiki",
"6433988", "Wanaka",
"6462809", "Napier\/Hastings",
"646213", "Wanganui",
"6439040", "Balclutha",
"6469016", "Ohakune",
"6469281", "Wairoa",
"6439287", "Oamaru",
"644439", "Wellington",
"6463944", "Featherston",
"6469712", "New\ Plymouth",
"6468809", "Masterton",
"6436686", "Invercargill",
"6435678", "Roxburgh",
"649986", "Whangarei",
"6435562", "Invercargill",
"646388", "Taihape",
"6478137", "Thames",
"649985", "Auckland",
"6435552", "Queenstown",
"6477772", "Rotorua",
"6437468", "Wanaka",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6462222", "Ohakune",
"6435505", "Akaroa",
"6462150", "New\ Plymouth",
"6479246", "Thames",
"644586", "Wellington",
"6449120", "Wellington",
"6437458", "Kaikoura",
"6462160", "Masterton",
"6439753", "Amberley",
"643433", "Oamaru",
"6439763", "Palmerston",
"646347", "Wanganui",
"6498900", "Pukekohe",
"6462414", "Napier",
"646842", "Napier\/Hastings",
"6479714", "Huntly",
"644891", "Wellington",
"6462618", "Masterton",
"6467774", "Dannevirke",
"6439874", "Cromwell",
"6439856", "Darfield",
"6493990", "Great\ Barrier\ Island",
"6432647", "Fairlie",
"6439331", "Greymouth",
"6435884", "Dunedin",
"643454", "Dunedin",
"643303", "Ashburton\/Akaroa\/Chatham\ Islands",
"6472427", "Rotorua",
"6472224", "Taupo",
"6434350", "Twizel",
"649424", "Hibiscus\ Coast",
"6439721", "Blenheim",
"646833", "Napier\/Hastings",
"647464", "Hamilton",
"6467552", "New\ Plymouth",
"6462161", "Masterton",
"6469294", "Palmerston\ North",
"6492428", "Hibiscus\ Coast",
"6449121", "Wellington",
"643964", "Christchurch",
"6462151", "New\ Plymouth",
"6439018", "Ranfurly",
"6473926", "Taumarunui",
"6477882", "Hamilton",
"643442", "Queenstown",
"6439453", "Te\ Anau",
"646272", "Hawera",
"6465606", "Waiouru",
"644975", "Paraparaumu",
"646377", "Masterton",
"646370", "Masterton",
"6473996", "Otorohanga",
"6469280", "Waipukurau",
"6462123", "Palmerston\ North",
"647949", "Hamilton",
"646279", "Hawera",
"643334", "Christchurch",
"643449", "Alexandra",
"6439720", "Blenheim",
"6434351", "Mt\ Cook",
"647305", "Whakatane",
"647589", "Hamilton",
"6475605", "Huntly",
"6434292", "Hokitika",
"6432229", "Dunedin",
"6472603", "Hamilton",
"647306", "Whakatane",
"6439330", "Westport",
"6479292", "Hamilton",
"6436547", "Geraldine",
"6432616", "Ashburton",
"6493991", "Pukekohe",
"643413", "Balclutha",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6463925", "Waiouru",
"6498857", "Dargaville",
"6434222", "Gore",
"644250", "Wellington",
"6498901", "Pukekohe",
"6439719", "Waimate",
"6463995", "Marton",
"6468246", "Hawera",
"6432802", "Gore",
"6468253", "Marton",
"6439717", "Fairlie",
"6469711", "New\ Plymouth",
"6492225", "Pukekohe",
"6468263", "Napier",
"6466526", "Waiouru",
"644211", "Wellington",
"6434993", "Alexandra",
"6469282", "Mokau",
"646753", "New\ Plymouth",
"649909", "Auckland",
"6432424", "Nelson",
"6432227", "Queenstown",
"6462221", "Gisborne",
"64332", "Christchurch",
"6432628", "Ranfurly",
"6499014", "Dargaville",
"64935", "Auckland",
"6467550", "New\ Plymouth",
"6492834", "Kawakawa",
"6498859", "Kaitaia",
"649902", "Warkworth",
"6435561", "Dunedin",
"6477880", "Hamilton",
"6435551", "Franz\ Josef",
"6477771", "Whakatane",
"6436549", "Mt\ Cook",
"6432745", "Roxburgh",
"649630", "Auckland",
"6434220", "Invercargill",
"6497776", "Hibiscus\ Coast",
"6496883", "Auckland",
"6434284", "Wanaka",
"6432800", "Te\ Anau",
"646766", "New\ Plymouth",
"646765", "Stratford",
"6439332", "Hokitika",
"6479290", "Hamilton",
"6445956", "Wellington",
"6434290", "Greymouth",
"6474446", "Otorohanga",
"6439722", "Blenheim",
"647878", "Te\ Kuiti",
"64941", "Auckland",
"6436644", "Alexandra",
"6439026", "Riverton",
"647851", "Hamilton",
"6473933", "Rotorua",
"6469611", "Wanganui",
"643767", "Greymouth",
"6436629", "Christchurch",
"6499874", "Kawakawa",
"649915", "Auckland",
"6433919", "Haast",
"649916", "Auckland",
"6496516", "Kaikohe",
"649479", "Auckland",
"6473841", "Taupo",
"6432728", "Haast",
"6436610", "Kaikoura",
"6433984", "Roxburgh",
"6469247", "Wanganui",
"6478594", "Hamilton",
"6432645", "Greymouth",
"6443332", "Wellington",
"6462109", "Waiouru",
"6472629", "Taupo",
"6436524", "Hokitika",
"647325", "Opotiki",
"6478081", "Rotorua",
"643651", "Nelson",
"6436580", "Invercargill",
"6495562", "Whangarei",
"6432449", "Queenstown",
"6439285", "Invercargill",
"6499420", "Pukekohe",
"6479851", "Waihi",
"64952", "Auckland",
"6435507", "Ashburton",
"6436594", "Waimate",
"6479022", "Morrinsville",
"6472610", "Morrinsville",
"6499040", "Helensville",
"647868", "Thames",
"6478135", "Te\ Kuiti",
"6462426", "Levin",
"6435953", "Christchurch",
"6462614", "Wairoa",
"6435536", "Invercargill",
"6435509", "Culverden",
"646862", "Gisborne",
"6436612", "Akaroa",
"644529", "Wellington",
"6479718", "Taumarunui",
"6462418", "Palmerston\ North",
"6443330", "Wellington",
"6435991", "Franz\ Josef",
"646367", "Levin",
"647343", "Rotorua",
"6435888", "Timaru",
"6468805", "Wanganui",
"6472627", "Rotorua",
"6433992", "Riverton",
"6467778", "Wairoa",
"6432447", "Timaru",
"6462805", "Napier\/Hastings",
"6435666", "Oamaru",
"6472612", "Te\ Awamutu",
"6479020", "Te\ Awamutu",
"6435674", "Milton",
"643523", "Murchison",
"6499422", "Helensville",
"6499746", "Kawakawa",
"6462107", "Dannevirke",
"6432716", "Darfield",
"6469249", "Masterton",
"6439296", "Invercargill",
"6499042", "Hibiscus\ Coast",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"647312", "Whakatane",
"644934", "Wellington",
"6437464", "Timaru",
"647210", "Hamilton",
"6479019", "Whangamata",
"6479090", "Taupo",
"6472806", "Matamata",
"647217", "Taupo",
"6437476", "Ranfurly",
"6437454", "Ashburton",
"6433917", "Franz\ Josef",
"6432813", "Geraldine",
"6463911", "New\ Plymouth",
"64447", "Wellington",
"6436582", "Riverton",
"6495560", "Whangarei",
"6432711", "Akaroa",
"6493208", "Helensville",
"64936", "Auckland",
"6492228", "Warkworth",
"6469297", "Masterton",
"6468308", "Napier",
"6439291", "Dunedin",
"6435693", "Nelson",
"6499553", "Kaikohe",
"6435661", "Fairlie",
"649452", "Auckland",
"6436649", "Gore",
"6444888", "Paraparaumu",
"647922", "Whakatane",
"6478095", "Taupo",
"6463916", "Mokau",
"6433940", "Westport",
"647871", "Te\ Awamutu",
"6432625", "Twizel",
"6496012", "Kawakawa",
"6499718", "Whangarei",
"6432748", "Cromwell",
"6434289", "Wanaka",
"6472801", "Huntly",
"6437471", "Kurow",
"649459", "Whangarei",
"646763", "Opunake",
"6435996", "Akaroa",
"6432429", "Timaru",
"6442199", "Paraparaumu",
"6492839", "Whangarei",
"6479843", "Morrinsville",
"6499019", "Maungaturoto",
"649210", "Auckland",
"64357", "Blenheim",
"6466993", "Waiouru",
"6437770", "Nelson",
"649817", "Auckland",
"6469313", "Marton",
"649810", "Auckland",
"6498854", "Hibiscus\ Coast",
"6479108", "Whakatane",
"644818", "Wellington",
"6435531", "Nelson",
"643248", "Lumsden",
"6479746", "Opotiki",
"6479422", "Tauranga",
"6442129", "Paraparaumu",
"646756", "New\ Plymouth",
"6439015", "Wanaka",
"6496010", "Kaitaia",
"6442127", "Paraparaumu",
"6439714", "Waimate",
"6433942", "Akaroa",
"6479753", "Taupo",
"646864", "Ruatoria",
"6478086", "Hamilton",
"6499017", "Kaikohe",
"6436503", "Ashburton",
"6492837", "Hibiscus\ Coast",
"6493933", "Kaikohe",
"6432427", "Greymouth",
"6432224", "Invercargill",
"6442197", "Paraparaumu",
"64334", "Christchurch",
"6462421", "New\ Plymouth",
"644524", "Wellington",
"643221", "Invercargill",
"643415", "Balclutha",
"6479856", "Tauranga",
"6475820", "Hamilton",
"643979", "Christchurch",
"644260", "Wellington",
"6479420", "Tauranga",
"6496511", "Whangarei",
"6475608", "Otorohanga",
"6469003", "Napier\/Hastings",
"6463928", "Pahiatua",
"6479040", "Otorohanga",
"6469616", "Featherston",
"644939", "Wellington",
"6434287", "Queenstown",
"6499726", "Kawakawa",
"646835", "Napier\/Hastings",
"6469299", "Napier\/Hastings",
"646836", "Napier\/Hastings",
"6436647", "Te\ Anau",
"6463998", "Palmerston\ North",
"6437772", "Timaru",
"6462415", "Levin",
"6437469", "Alexandra",
"643339", "Christchurch",
"6479715", "Paeroa",
"643444", "Ranfurly",
"646274", "Hawera",
"6439091", "Rangiora",
"6437459", "Rangiora",
"6479014", "Matamata",
"647462", "Taupo",
"6495530", "Great\ Barrier\ Island",
"643962", "Christchurch",
"6497771", "Kaikohe",
"6499877", "Maungaturoto",
"6473946", "Taupo",
"6439063", "Westport",
"6472225", "Rotorua",
"6439852", "Cheviot",
"643526", "Motueka",
"6433987", "Cromwell",
"649555", "Auckland",
"643230", "Invercargill",
"6439862", "Nelson",
"6468808", "Palmerston\ North",
"6435885", "Invercargill",
"643525", "Takaka",
"643332", "Christchurch",
"6435679", "Alexandra",
"6445951", "Wellington",
"6462808", "Napier\/Hastings",
"6467775", "Palmerston\ North",
"6474441", "Waihi",
"6478597", "Hamilton",
"6439875", "Ranfurly",
"643409", "Queenstown",
"6462620", "New\ Plymouth",
"6449031", "Paraparaumu",
"6436527", "Haast",
"6469012", "Waiouru",
"6466521", "Palmerston\ North",
"647345", "Rotorua",
"647346", "Rotorua",
"6439740", "Christchurch",
"6469716", "Opunake",
"6436682", "Dunedin",
"6439520", "Dunedin",
"6435556", "Fairlie",
"6477776", "Whangamata",
"6435504", "Christchurch",
"6436597", "Cromwell",
"6462619", "Featherston",
"6469300", "Gisborne",
"6462226", "Napier",
"6479242", "Rotorua",
"6434242", "Darfield",
"6468690", "Gisborne",
"6466553", "New\ Plymouth",
"6436599", "Blenheim",
"6462617", "Masterton",
"6439860", "Nelson",
"6432611", "Kaikoura",
"644393", "Paraparaumu",
"64937", "Auckland",
"6439850", "Ashburton",
"6435543", "Tokanui",
"649949", "Auckland",
"643750", "Haast",
"6472624", "Whakatane",
"6472428", "Taupo",
"6468241", "Gisborne",
"6436529", "Westport",
"6432725", "Hokitika",
"647323", "Whakatane",
"6432444", "Nelson",
"6432648", "Geraldine",
"6495532", "Warkworth",
"643983", "Christchurch",
"6469203", "New\ Plymouth",
"6465601", "Palmerston\ North",
"6435677", "Ranfurly",
"6469029", "Opunake",
"6469273", "New\ Plymouth",
"6439522", "Dunedin",
"649582", "Auckland",
"6433989", "Waimate",
"6478599", "Hamilton",
"6439288", "Ashburton",
"647858", "Hamilton",
"6499733", "Warkworth",
"6462166", "Opunake",
"6462104", "Marton",
"6434240", "Ashburton",
"6468692", "Gisborne",
"6462156", "Hawera",
"6479240", "Taupo",
"6473921", "Matamata",
"6469302", "Napier",
"649589", "Auckland",
"6437457", "Darfield",
"6436624", "Darfield",
"6437467", "Queenstown",
"6469010", "Taihape",
"6498016", "Hibiscus\ Coast",
"6439046", "Kurow",
"6436680", "Akaroa",
"6473991", "Whakatane",
"649913", "Auckland",
"6499879", "Warkworth",
"6433914", "Takaka",
"6478138", "Waihi",
"6439742", "Christchurch",
"6436508", "Rangiora",
"6493938", "Auckland",
"6436578", "Wanaka",
"6468812", "Waiouru",
"6499467", "Kaitaia",
"6499457", "Kaitaia",
"6494312", "Warkworth",
"6462125", "Taihape",
"6462812", "Napier\/Hastings",
"643689", "Waimate",
"647348", "Rotorua",
"6436652", "Winton",
"6462606", "Waiouru",
"6439455", "Otautau",
"6492007", "Warkworth",
"643528", "Motueka",
"644550", "Wellington",
"6439882", "Westport",
"6433957", "Palmerston",
"6472126", "Otorohanga",
"649558", "Auckland",
"643742", "Dunedin",
"643920", "Rangiora",
"647882", "Putaruru\/Tokoroa",
"6472814", "Putaruru\/Tokoroa",
"6474659", "Whangamata",
"649957", "Pukekohe",
"6463993", "Pahiatua",
"649950", "Auckland",
"6472196", "Taupo",
"643749", "Christchurch",
"6472605", "Thames",
"6468827", "New\ Plymouth",
"6475603", "Hamilton",
"6434271", "Balclutha",
"6432756", "Gore",
"6469008", "Palmerston\ North",
"6463923", "Ohakune",
"644497", "Wellington",
"6466006", "Opunake",
"6439083", "Cheviot",
"647889", "Morrinsville",
"6472141", "Te\ Kuiti",
"644202", "Wellington",
"6437487", "Winton",
"6478141", "Taupo",
"644802", "Wellington",
"6432743", "Kurow",
"6494706", "Whangarei",
"6436650", "Otautau",
"644209", "Wellington",
"6433959", "Balclutha",
"6468255", "Pahiatua",
"6468810", "Ohakune",
"6435698", "Hokitika",
"6492223", "Auckland",
"6492009", "Pukekohe",
"6468303", "Napier",
"6462810", "Gisborne",
"6434995", "Te\ Anau",
"647856", "Hamilton",
"6439268", "Dunedin",
"6499558", "Great\ Barrier\ Island",
"643214", "Invercargill",
"6472118", "Taumarunui",
"6474657", "Thames",
"644437", "Wellington",
"647855", "Hamilton",
"646847", "Napier\/Hastings",
"646304", "Featherston",
"6439347", "Christchurch",
"6465950", "Palmerston\ North",
"644391", "Wellington",
"646342", "Wanganui",
"647970", "Hamilton",
"6432631", "Gore",
"6439701", "Nelson",
"649884", "Auckland",
"6439880", "Greymouth",
"643981", "Christchurch",
"6479848", "Te\ Kuiti",
"643655", "Dunedin",
"6469318", "Levin",
"6499459", "Maungaturoto",
"6466998", "New\ Plymouth",
"646349", "Wanganui",
"647863", "Waihi",
"6499469", "Maungaturoto",
"6496008", "Hibiscus\ Coast",
"6435511", "Kaikoura",
"643246", "Tokanui",
"649294", "Auckland",
"6432643", "Haast",
"646758", "New\ Plymouth",
"6499006", "Whangarei",
"6499064", "Helensville",
"6437442", "Murchison",
"6498820", "Whangarei",
"6478451", "Hamilton",
"6479500", "Whakatane",
"6473935", "Rotorua",
"646657", "Masterton",
"6439767", "Alexandra",
"646650", "Napier",
"644815", "Wellington",
"6435548", "Westport",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"647551", "Tauranga",
"6467529", "Mokau",
"644816", "Wellington",
"6472133", "Taupo",
"6468999", "Napier",
"6475610", "Putaruru\/Tokoroa",
"6434269", "Twizel",
"6432731", "Timaru",
"647960", "Hamilton",
"6434234", "Darfield",
"6442420", "Wellington",
"643467", "Dunedin",
"647839", "Hamilton",
"6478133", "Putaruru\/Tokoroa",
"6469278", "Gisborne",
"6479001", "Hamilton",
"646761", "Opunake",
"647832", "Hamilton",
"6435681", "Invercargill",
"6439283", "Rangiora",
"647873", "Otorohanga",
"6432888", "Nelson",
"6475627", "Taupo",
"646838", "Wairoa",
"6498822", "Kaikohe",
"6496996", "Warkworth",
"6437440", "Nelson",
"6468803", "Gisborne",
"6463907", "Waipukurau",
"6462803", "Palmerston\ North",
"6465614", "Wanganui",
"6468997", "Napier",
"647390", "Hamilton",
"6435955", "Christchurch",
"6432991", "Milton",
"6439068", "Fox\ Glacier",
"6434267", "Ranfurly",
"647892", "Taumarunui",
"6499471", "Hibiscus\ Coast",
"6469574", "Taihape",
"646324", "Palmerston\ North",
"6439734", "Edendale",
"6439759", "Cromwell",
"6432815", "Fairlie",
"6439324", "Darfield",
"643418", "Balclutha",
"6439769", "Roxburgh",
"6466558", "Opunake",
"6475612", "Te\ Kuiti",
"6498817", "Hibiscus\ Coast",
"6432656", "Nelson",
"643692", "Geraldine",
"6478074", "Taumarunui",
"649292", "Auckland",
"6432623", "Lawrence",
"643206", "Edendale",
"649390", "Auckland",
"643653", "Blenheim",
"64423", "Wellington",
"6499454", "Whangarei",
"6499476", "Auckland",
"647866", "Thames",
"64483", "Wellington",
"647865", "Whangamata",
"649892", "Auckland",
"6499464", "Whangarei",
"6435695", "Fox\ Glacier",
"6468258", "Waiouru",
"6435528", "Ranfurly",
"6439272", "Timaru",
"6468268", "New\ Plymouth",
"649299", "Auckland",
"6436560", "Palmerston",
"6478093", "Rotorua",
"6432661", "Christchurch",
"6472822", "Rotorua",
"6472115", "Taumarunui",
"6499555", "Kawakawa",
"6432651", "Queenstown",
"6434998", "Dunedin",
"6433954", "Lawrence",
"643666", "Christchurch",
"6496509", "Pukekohe",
"6496991", "Kaikohe",
"6472817", "Taupo",
"647853", "Hamilton",
"6474637", "Opotiki",
"643940", "Christchurch",
"643947", "Invercargill",
"647834", "Hamilton",
"6468824", "Wanganui",
"6432996", "Riverton",
"6434401", "Cromwell",
"646903", "Palmerston\ North",
"649431", "Maungaturoto",
"6479845", "Paeroa",
"644917", "Wellington",
"6475481", "Tauranga",
"644910", "Wellington",
"6436630", "Takaka",
"6468880", "Napier\/Hastings",
"6466995", "Opunake",
"6469315", "Taihape",
"649918", "Auckland",
"6439270", "Greymouth",
"6437484", "Riverton",
"6432736", "Dunedin",
"6493935", "Kawakawa",
"6436505", "Culverden",
"643521", "Nelson",
"6462128", "Ohakune",
"6472820", "Hamilton",
"649551", "Auckland",
"6436562", "Balclutha",
"6435686", "Gore",
"6496507", "Helensville",
"647894", "Taumarunui",
"6439458", "Edendale",
"6474654", "Taumarunui",
"6479006", "Taupo",
"6472819", "Rotorua",
"6474639", "Opotiki",
"6499001", "Auckland",
"6449081", "Paraparaumu",
"6439344", "Timaru",
"6469853", "Wairoa",
"649232", "Pukekohe",
"6435516", "Balclutha",
"6468882", "Napier\/Hastings",
"6436632", "Murchison",
"6469891", "Gisborne",
"646322", "Marton",
"6469005", "Wanganui",
"649239", "Pukekohe",
"6472608", "Waihi",
"646329", "Palmerston\ North",
"6439534", "Mt\ Cook",
"649400", "Kaikohe",
"649967", "Auckland",
"649407", "Kaikohe",
"6435883", "Dunedin",
"643226", "Otautau",
"6432636", "Te\ Anau",
"6432609", "Mt\ Cook",
"643225", "Otautau",
"6472223", "Hamilton",
"6499067", "Pukekohe",
"643684", "Timaru",
"6467773", "Wanganui",
"6436990", "Cheviot",
"6439310", "Invercargill",
"6478079", "Hamilton",
"6439873", "Wanaka",
"6439002", "Rangiora",
"6479713", "Morrinsville",
"6469579", "Pahiatua",
"6462413", "Gisborne",
"647308", "Whakatane",
"6439754", "Darfield",
"6439739", "Invercargill",
"6439706", "Nelson",
"6439764", "Lawrence",
"6439055", "Fairlie",
"647884", "Morrinsville",
"6478990", "Thames",
"6494701", "Whangarei",
"6465619", "Masterton",
"6466555", "Hawera",
"6434237", "Culverden",
"6432818", "Christchurch",
"646831", "Napier\/Hastings",
"6472146", "Otorohanga",
"6463943", "Masterton",
"6465620", "New\ Plymouth",
"644570", "Wellington",
"644577", "Wellington",
"6473338", "Rotorua",
"6499811", "Hibiscus\ Coast",
"644804", "Wellington",
"6475624", "Rotorua",
"6432723", "Takaka",
"6439000", "Christchurch",
"649348", "Auckland",
"643219", "Invercargill",
"6439070", "Motueka",
"646946", "Masterton",
"647876", "Te\ Kuiti",
"6472121", "Te\ Kuiti",
"644204", "Wellington",
"6463904", "Napier",
"6468994", "Waipukurau",
"6465617", "Mokau",
"643212", "Invercargill",
"6466001", "Napier",
"6434264", "Kurow",
"646768", "New\ Plymouth",
"6472191", "Whakatane",
"6434276", "Palmerston",
"6435545", "Gore",
"6432751", "Riverton",
"6439312", "Riverton",
"6436992", "Greymouth",
"6434239", "Christchurch",
"646344", "Wanganui",
"646751", "New\ Plymouth",
"6469577", "Ohakune",
"643590", "Christchurch",
"644213", "Wellington",
"6465622", "Stratford",
"6439327", "Ashburton",
"6439737", "Tokanui",
"649889", "Auckland",
"6462601", "Palmerston\ North",
"6432607", "Dunedin",
"6478992", "Paeroa",
"6498814", "Pukekohe",
"649282", "Auckland",
"6469275", "Wanganui",
"649420", "Helensville",
"649427", "Hibiscus\ Coast",
"6478077", "Waihi",
"643457", "Dunedin",
"6499069", "Pukekohe",
"647957", "Hamilton",
"643450", "Queenstown",
"6439269", "Dunedin",
"6499559", "Whangarei",
"6432750", "Invercargill",
"6472119", "Thames",
"6436643", "Balclutha",
"6472190", "Whakatane",
"643960", "Christchurch",
"647460", "Rotorua",
"643967", "Christchurch",
"646374", "Dannevirke",
"643239", "Invercargill",
"6466000", "Napier",
"6433958", "Oamaru",
"6435699", "Amberley",
"6492008", "Hibiscus\ Coast",
"6434283", "Cromwell",
"6472120", "Putaruru\/Tokoroa",
"6469007", "Masterton",
"6439071", "Motueka",
"646857", "Waipukurau",
"643337", "Christchurch",
"6439001", "Christchurch",
"6496884", "Auckland",
"647846", "Hamilton",
"6469319", "Masterton",
"6499458", "Kawakawa",
"6466999", "New\ Plymouth",
"6499468", "Kawakawa",
"646975", "Napier",
"647245", "Hamilton",
"6494702", "Whangarei",
"6432423", "Dunedin",
"644370", "Wellington",
"6479849", "Thames",
"646976", "Napier",
"6436577", "Cromwell",
"6499013", "Kawakawa",
"6492833", "Warkworth",
"6436507", "Kaikoura",
"6462600", "Palmerston\ North",
"6493937", "Warkworth",
"64962", "Auckland",
"6434994", "Palmerston",
"6468254", "Ohakune",
"6468264", "Palmerston\ North",
"644893", "Wellington",
"6472122", "Te\ Awamutu",
"6472815", "Whakatane",
"6439886", "Haast",
"643431", "Oamaru",
"64927", "Auckland",
"644293", "Paraparaumu",
"647823", "Hamilton",
"6472192", "Whakatane",
"6466997", "New\ Plymouth",
"6432752", "Te\ Anau",
"6439311", "Invercargill",
"6436991", "Culverden",
"6469317", "Pahiatua",
"649940", "Auckland",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6493939", "Auckland",
"6479847", "Te\ Awamutu",
"6436579", "Wanaka",
"649666", "Auckland",
"6466002", "Napier",
"6472604", "Hamilton",
"643752", "Franz\ Josef",
"649988", "Whangarei",
"6499810", "Hibiscus\ Coast",
"6468816", "Hawera",
"649634", "Auckland",
"6462124", "Marton",
"646385", "Ohakune",
"649580", "Auckland",
"6462816", "Gisborne",
"6469009", "Palmerston\ North",
"646211", "Napier",
"6465621", "New\ Plymouth",
"6474658", "Waihi",
"6439454", "Lumsden",
"6499557", "Warkworth",
"6439267", "Dunedin",
"6469293", "New\ Plymouth",
"6462602", "Palmerston\ North",
"6436656", "Hokitika",
"6435697", "Westport",
"6478991", "Whangamata",
"643390", "Christchurch",
"6494700", "Whangarei",
"6432814", "Mt\ Cook",
"647920", "Rotorua",
"643420", "Christchurch",
"6439325", "Kaikoura",
"647927", "Tauranga",
"6439069", "Haast",
"6439735", "Lumsden",
"6437463", "Mt\ Cook",
"6469575", "Waiouru",
"6437453", "Amberley",
"64926", "Auckland",
"6475616", "Whangamata",
"6472821", "Hamilton",
"6432662", "Christchurch",
"6478075", "Te\ Kuiti",
"6432652", "Cromwell",
"6466013", "Featherston",
"6462149", "Ruatoria",
"6432889", "Blenheim",
"6439271", "Westport",
"6435673", "Lawrence",
"6469277", "Gisborne",
"649590", "Auckland",
"6496992", "Kawakawa",
"649812", "Auckland",
"6498826", "Warkworth",
"649212", "Auckland",
"6496007", "Helensville",
"6469890", "Gisborne",
"6439758", "Ashburton",
"6475482", "Tauranga",
"6435547", "Blenheim",
"6439768", "Ranfurly",
"6466559", "Mokau",
"6465615", "Wanganui",
"644461", "Wellington",
"6434402", "Alexandra",
"644901", "Wellington",
"6449080", "Paraparaumu",
"6435954", "Christchurch",
"6462613", "Waipukurau",
"643736", "Greymouth",
"6499000", "Auckland",
"6434235", "Akaroa",
"6432650", "Christchurch",
"6466557", "Stratford",
"6435549", "Hokitika",
"643977", "Christchurch",
"6432660", "Christchurch",
"6436561", "Oamaru",
"646364", "Levin",
"6436593", "Nelson",
"646953", "Palmerston\ North\ W100",
"643614", "Timaru",
"643481", "Dunedin",
"6496009", "Pukekohe",
"647981", "Hamilton",
"6436523", "Hokitika",
"6499065", "Helensville",
"6468881", "Napier\/Hastings",
"6478593", "Hamilton",
"6436631", "Motueka",
"6475480", "Tauranga",
"647541", "Tauranga",
"6463908", "Wairoa",
"6469892", "Gisborne",
"6469279", "Levin",
"6499002", "Auckland",
"6475628", "Tauranga",
"646965", "Wanganui\ W100",
"6432887", "Nelson",
"6449082", "Wellington",
"6433983", "Ranfurly",
"6434400", "Alexandra",
"6499873", "Kaitaia",
"6439067", "Franz\ Josef",
"6496990", "Kaitaia",
"6434268", "Roxburgh",
"6437446", "Franz\ Josef",
"649825", "Auckland",
"6439057", "Waimate",
"649826", "Auckland",
"6473934", "Rotorua",
"6468998", "Napier",
"6439459", "Tokanui",
"6472818", "Rotorua",
"6474638", "Opotiki",
"6432990", "Lumsden",
"647351", "Rotorua",
"6468886", "Wanganui",
"6436636", "Waimate",
"6439345", "Christchurch",
"6435512", "Rangiora",
"643762", "Greymouth",
"6462129", "Waiouru",
"649477", "Auckland",
"6439535", "Fairlie",
"643769", "Greymouth",
"6437441", "Motueka",
"6469004", "Napier\/Hastings",
"647825", "Hamilton",
"643438", "Kurow",
"649214", "Auckland",
"647826", "Huntly",
"6432732", "Fairlie",
"6493934", "Kaitaia",
"6436504", "Cheviot",
"6472609", "Whangamata",
"6432223", "Akaroa",
"649814", "Auckland",
"6436566", "Kurow",
"6437485", "Te\ Anau",
"6479754", "Tauranga",
"6434997", "Lawrence",
"644895", "Paraparaumu",
"6435682", "Riverton",
"6474655", "Te\ Kuiti",
"644896", "Wellington",
"6475958", "Taupo",
"644296", "Paraparaumu",
"6479002", "Matamata",
"6499470", "Hibiscus\ Coast",
"6439713", "Mt\ Cook",
"6435527", "Alexandra",
"6468257", "Taihape",
"643308", "Ashburton\/Akaroa\/Chatham\ Islands",
"646362", "Levin",
"6434999", "Dunedin",
"646867", "Gisborne",
"6479501", "Opotiki",
"6435529", "Roxburgh",
"6468259", "Levin",
"6478450", "Hamilton",
"647590", "Hamilton",
"6433955", "Mt\ Cook",
"6498821", "Dargaville",
"6468269", "New\ Plymouth",
"6466994", "Ohakune",
"6498853", "Whangarei",
"6469314", "Waiouru",
"6432992", "Gore",
"646369", "Levin",
"647843", "Hamilton",
"643950", "Dunedin",
"644928", "Wellington",
"643957", "Timaru",
"6472607", "Paeroa",
"6468825", "Gisborne",
"644527", "Wellington",
"6435510", "Darfield",
"64320", "Gore",
"643612", "Timaru",
"6479844", "Otorohanga",
"6499465", "Dargaville",
"6499455", "Dargaville",
"6435680", "Dunedin",
"6462127", "Dannevirke",
"6499472", "Great\ Barrier\ Island",
"6479000", "Hamilton",
"6499554", "Kaitaia",
"6432730", "Blenheim",
"647812", "Hamilton",
"6439457", "Winton",
"6439276", "Nelson",
"6472826", "Matamata",
"6496508", "Hibiscus\ Coast",
"6475611", "Taumarunui",
"6435694", "Franz\ Josef",
"646372", "Masterton",
"6467525", "Mokau",
"6433913", "Murchison",
"6465626", "Ruatoria",
"643447", "Alexandra",
"6432817", "Christchurch",
"6462811", "New\ Plymouth",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6468811", "Marton",
"6436623", "Amberley",
"6436651", "Riverton",
"6478996", "Huntly",
"643234", "Riverton",
"6462103", "Levin",
"646379", "Masterton",
"6478140", "Rotorua",
"6473337", "Rotorua",
"6498815", "Helensville",
"6469274", "New\ Plymouth",
"6472140", "Putaruru\/Tokoroa",
"6432443", "Christchurch",
"6463905", "Napier",
"6499068", "Pukekohe",
"643571", "Nelson",
"6472623", "Tauranga",
"6439881", "Greymouth",
"6475625", "Rotorua",
"6439700", "Nelson",
"643488", "Dunedin",
"6435544", "Winton",
"6432630", "Christchurch",
"647988", "Rotorua",
"6434265", "Milton",
"6468995", "Napier",
"6436996", "Takaka",
"6434272", "Alexandra",
"6439316", "Edendale",
"644886", "Wellington",
"6478142", "Whakatane",
"6439738", "Winton",
"6466554", "Hawera",
"6472142", "Te\ Awamutu",
"6469578", "Marton",
"6435503", "Christchurch",
"6478078", "Whangamata",
"6432608", "Dunedin",
"64925", "Auckland",
"6469243", "New\ Plymouth",
"6432632", "Lumsden",
"6434270", "Oamaru",
"6462144", "Ruatoria",
"649632", "Auckland",
"6473339", "Taupo",
"6439765", "Milton",
"6439006", "Nelson",
"649846", "Auckland",
"6432819", "Christchurch",
"6439755", "Rangiora",
"649845", "Auckland",
"6439702", "Nelson",
"647378", "Taupo",
"649639", "Auckland",
"6465618", "Masterton",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;