# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170053;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6439314", "Winton",
"6433948", "Kaikoura",
"6472819", "Rotorua",
"6439718", "Mt\ Cook",
"6439337", "Wanaka",
"6435504", "Christchurch",
"6469301", "Ruatoria",
"6435668", "Kurow",
"643908", "Ashburton",
"6462620", "New\ Plymouth",
"6439066", "Hokitika",
"647928", "Tauranga",
"6437469", "Alexandra",
"6462616", "Ruatoria",
"646844", "Napier\/Hastings",
"6472193", "Whakatane",
"6439722", "Blenheim",
"6498857", "Dargaville",
"6479008", "Rotorua",
"6469298", "Masterton",
"6478141", "Taupo",
"6475825", "Hamilton",
"64685", "Waipukurau",
"6475606", "Matamata",
"6443708", "Paraparaumu",
"6496513", "Whangarei",
"643920", "Rangiora",
"6468253", "Marton",
"6439299", "Murchison",
"644906", "Paraparaumu",
"6436637", "Twizel",
"643538", "Nelson",
"6463923", "Ohakune",
"6436614", "Timaru",
"6435686", "Gore",
"6435563", "Queenstown",
"6478994", "Tauranga",
"6435675", "Twizel",
"6493935", "Kawakawa",
"6439025", "Otautau",
"6493944", "Hibiscus\ Coast",
"649348", "Auckland",
"6474650", "Morrinsville",
"6499465", "Dargaville",
"6472221", "Tauranga",
"6432999", "Invercargill",
"6436526", "Fox\ Glacier",
"6499876", "Kaikohe",
"6436578", "Wanaka",
"6463997", "Palmerston\ North",
"6439528", "Lawrence",
"6495560", "Whangarei",
"6442429", "Paraparaumu",
"6432746", "Alexandra",
"6498822", "Kaikohe",
"64697", "Napier",
"6439705", "Motueka",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6462812", "Napier\/Hastings",
"6477777", "Hamilton",
"647820", "Hamilton\/Huntly",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6439282", "Christchurch",
"6433955", "Mt\ Cook",
"647871", "Te\ Awamutu",
"6434997", "Lawrence",
"6462410", "New\ Plymouth",
"643657", "Queenstown",
"649424", "Hibiscus\ Coast",
"647312", "Whakatane",
"6432635", "Riverton",
"6435882", "Dunedin",
"6432644", "Westport",
"6479712", "Te\ Awamutu",
"6462159", "Mokau",
"6479100", "Rotorua",
"644818", "Wellington",
"6434244", "Amberley",
"6439002", "Rangiora",
"6434235", "Akaroa",
"643215", "Invercargill",
"6496996", "Warkworth",
"6436565", "Twizel",
"6478139", "Whangamata",
"6466579", "Featherston",
"646964", "Wanganui",
"6472127", "Paeroa",
"6462426", "Levin",
"6499478", "Pukekohe",
"6468801", "Wanganui",
"6499479", "Pukekohe",
"6466526", "Waiouru",
"647829", "Hamilton",
"6434359", "Twizel",
"6478138", "Waihi",
"6433997", "Gore",
"6499746", "Kawakawa",
"6469576", "Dannevirke",
"6479230", "Opotiki",
"6462158", "Opunake",
"644555", "Wellington",
"6432812", "Haast",
"6436646", "Roxburgh",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"6469282", "Mokau",
"6477882", "Hamilton",
"6469247", "Wanganui",
"6463907", "Waipukurau",
"64795", "Hamilton",
"6435690", "Motueka",
"646657", "Masterton",
"6439092", "Rangiora",
"646952", "Palmerston\ North\ W100",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6472805", "Morrinsville",
"6432651", "Queenstown",
"6472626", "Rotorua",
"6466000", "Napier",
"6479292", "Hamilton",
"6469002", "Hawera",
"6479846", "Taumarunui",
"6472610", "Morrinsville",
"6439529", "Palmerston",
"6468814", "Dannevirke",
"6436579", "Wanaka",
"6435556", "Fairlie",
"6439346", "Christchurch",
"643335", "Christchurch",
"6465600", "Palmerston\ North",
"6432998", "Tokanui",
"6432426", "Blenheim",
"6435511", "Kaikoura",
"6469314", "Waiouru",
"647864", "Thames",
"64379", "South\ Island",
"6432620", "Palmerston",
"6437486", "Tokanui",
"643456", "Dunedin",
"6478092", "Huntly",
"643231", "Invercargill",
"6434220", "Invercargill",
"6437475", "Palmerston",
"6432616", "Ashburton",
"6439298", "Motueka",
"6472420", "Hamilton",
"6434272", "Alexandra",
"6443709", "Paraparaumu",
"646763", "Opunake",
"6469299", "Napier\/Hastings",
"6479009", "Hamilton",
"6437468", "Wanaka",
"6472822", "Rotorua",
"6469025", "Mokau",
"6435669", "Wanaka",
"6439881", "Greymouth",
"6432714", "Cheviot",
"6439719", "Waimate",
"643411", "Balclutha\/Milton",
"6472818", "Rotorua",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6433949", "Rangiora",
"6432737", "Palmerston",
"6493207", "Hibiscus\ Coast",
"643755", "Hokitika",
"6439041", "Ashburton",
"6435660", "Haast",
"6462628", "Wanganui",
"6436505", "Culverden",
"643445", "Cromwell",
"6432227", "Queenstown",
"6433940", "Westport",
"64630", "Featherston",
"6468887", "Gisborne",
"6439062", "Ashburton",
"6439710", "Timaru",
"6479000", "Hamilton",
"6469290", "Napier\/Hastings",
"6437771", "Blenheim",
"6479751", "Tauranga",
"6439726", "Timaru",
"6479241", "Whakatane",
"6442127", "Paraparaumu",
"6475602", "Hamilton",
"6434229", "Winton",
"647826", "Huntly",
"6433981", "Twizel",
"6472429", "Whakatane",
"6432643", "Haast",
"6439765", "Milton",
"64340", "South\ Island",
"6435682", "Riverton",
"643977", "Christchurch",
"6474658", "Waihi",
"6468307", "Napier\/Wairoa",
"6434243", "Akaroa",
"6432629", "Roxburgh",
"6499457", "Kaitaia",
"6439275", "Nelson",
"6495568", "Kawakawa",
"6439520", "Dunedin",
"6436522", "Greymouth",
"6492807", "Helensville",
"6466009", "Waiouru",
"6439313", "Te\ Anau",
"647877", "Te\ Kuiti",
"6465609", "Pahiatua",
"6432742", "Twizel",
"6435503", "Christchurch",
"6435699", "Amberley",
"6472194", "Whakatane",
"6498826", "Warkworth",
"6436518", "Murchison",
"646768", "New\ Plymouth",
"6462816", "Gisborne",
"6478080", "Hamilton",
"6475625", "Rotorua",
"6439286", "Cromwell",
"643926", "Christchurch",
"6468254", "Ohakune",
"6496514", "Whangarei",
"643459", "Dunedin\/Queenstown",
"6436613", "Wanaka",
"6463924", "Marton",
"6473946", "Taupo",
"6462418", "Palmerston\ North",
"643749", "Christchurch",
"6435886", "Invercargill",
"6479716", "Waihi",
"6439006", "Nelson",
"6493943", "Helensville",
"643651", "Nelson",
"6496992", "Kawakawa",
"6478993", "Waihi",
"6434350", "Twizel",
"6499470", "Hibiscus\ Coast",
"6479108", "Whakatane",
"6449008", "Paraparaumu",
"6499422", "Helensville",
"6462422", "Napier\/Hastings",
"646903", "Palmerston\ North",
"6439268", "Dunedin",
"6439269", "Dunedin",
"6466522", "Palmerston\ North",
"6439855", "Rangiora",
"6469275", "Wanganui",
"6492831", "Maungaturoto",
"6469313", "Marton",
"647884", "Morrinsville",
"6445", "Wellington\/Hutt\ Valley",
"6479109", "Opotiki",
"6499555", "Kawakawa",
"6478130", "Morrinsville",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"6469572", "Palmerston\ North",
"6436687", "Nelson",
"6462419", "Masterton",
"6432816", "Waimate",
"6436642", "Milton",
"6462150", "New\ Plymouth",
"6469286", "Dannevirke",
"6477886", "Rotorua",
"6499017", "Kaikohe",
"6468241", "Gisborne",
"647923", "Whakatane",
"6499045", "Hibiscus\ Coast",
"6439096", "Ashburton",
"6468262", "Napier",
"6436519", "Takaka",
"6472622", "Tauranga",
"6435698", "Hokitika",
"6432713", "Ashburton",
"6469006", "Gisborne",
"6479296", "Tauranga",
"646651", "Napier",
"643450", "Queenstown",
"6465608", "Dannevirke",
"6492006", "Helensville",
"643740", "Christchurch",
"6432990", "Lumsden",
"6479842", "Matamata",
"6497775", "Helensville",
"6466008", "Ohakune",
"6439342", "Geraldine",
"6435552", "Queenstown",
"644281", "Wellington",
"6442420", "Wellington",
"6495569", "Maungaturoto",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"643903", "Christchurch",
"649392", "Auckland",
"6473991", "Whakatane",
"6434285", "Cheviot",
"6462227", "Napier",
"6432628", "Ranfurly",
"6466557", "Stratford",
"643237", "Riverton\/Winton",
"6463940", "Levin",
"6469200", "Gisborne",
"6437447", "Greymouth",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"6474659", "Whangamata",
"643524", "Takaka",
"6469710", "New\ Plymouth",
"6437482", "Lumsden",
"6467771", "New\ Plymouth",
"6495532", "Warkworth",
"6439290", "Christchurch",
"64732", "Whakatane",
"6432612", "Rangiora",
"6472428", "Taupo",
"6434228", "Tokanui",
"6436595", "Mt\ Cook",
"6434276", "Palmerston",
"646322", "Marton",
"6439535", "Fairlie",
"6465615", "Wanganui",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6472605", "Thames",
"6472826", "Matamata",
"643417", "Milton",
"6466015", "Napier",
"6468813", "Taihape",
"6472810", "Tauranga",
"6462121", "Palmerston\ North",
"6462629", "Levin",
"6435527", "Alexandra",
"643984", "Blenheim",
"6463916", "Mokau",
"6436657", "Franz\ Josef",
"64941", "Auckland",
"646375", "Pahiatua",
"6499474", "Helensville",
"6435560", "Mt\ Cook",
"6474653", "Putaruru\/Tokoroa",
"6439876", "Roxburgh",
"6434248", "Cheviot",
"6468250", "Stratford",
"6439885", "Fox\ Glacier",
"643947", "Invercargill",
"6496510", "Whangarei",
"6432648", "Geraldine",
"6463920", "Palmerston\ North",
"643522", "Nelson",
"6472132", "Taupo",
"6479857", "Opotiki",
"6472190", "Whakatane",
"6462162", "Masterton",
"64372", "South\ Island",
"6435515", "Oamaru",
"6478084", "Hamilton",
"64923", "Pukekohe",
"643982", "Christchurch",
"6435547", "Blenheim",
"6437471", "Kurow",
"6439524", "Oamaru",
"6468819", "Mokau",
"6462623", "Stratford",
"6465627", "Levin",
"6498814", "Pukekohe",
"6436996", "Takaka",
"6499066", "Helensville",
"6469319", "Masterton",
"6436622", "Cheviot",
"6499718", "Whangarei",
"6432607", "Dunedin",
"6432655", "Nelson",
"6442198", "Paraparaumu",
"6462139", "Palmerston\ North",
"6499631", "Pukekohe",
"6472801", "Huntly",
"6478998", "Hamilton",
"6462413", "Gisborne",
"6439084", "Amberley",
"647981", "Hamilton",
"647882", "Putaruru\/Tokoroa",
"6479420", "Tauranga",
"643213", "Invercargill",
"6436618", "Blenheim",
"6462106", "Pahiatua",
"6437452", "Akaroa",
"6469294", "Palmerston\ North",
"6479004", "Te\ Awamutu",
"6444", "Wellington",
"6499299", "Whangarei",
"644219", "Wellington",
"6439322", "Culverden",
"643469", "Dunedin",
"6432442", "Christchurch",
"6467525", "Mokau",
"649394", "Auckland",
"6435664", "Timaru",
"6435508", "Cheviot",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6439737", "Tokanui",
"644576", "Wellington",
"6433944", "Ashburton",
"6444889", "Paraparaumu",
"6439318", "Lumsden",
"6439714", "Waimate",
"6495563", "Whangarei",
"6475617", "Whakatane",
"6443", "Wellington",
"6479501", "Opotiki",
"6472613", "Putaruru\/Tokoroa",
"6478077", "Waihi",
"6444888", "Paraparaumu",
"6466003", "Ruatoria",
"6439319", "Otautau",
"6472814", "Putaruru\/Tokoroa",
"6432631", "Gore",
"6465603", "Palmerston\ North",
"6462607", "Taihape",
"6434297", "Westport",
"6435509", "Culverden",
"6432718", "Rangiora",
"6437464", "Timaru",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6435693", "Nelson",
"6499298", "Pukekohe",
"6436587", "Gore",
"6434231", "Christchurch",
"64783", "Hamilton",
"643448", "Alexandra",
"646213", "Wanganui",
"646832", "Napier\/Wairoa",
"6468805", "Wanganui",
"6436561", "Oamaru",
"6432722", "Murchison",
"6435536", "Invercargill",
"6469616", "Featherston",
"6439294", "Dunedin",
"6499461", "Whangarei",
"6472225", "Rotorua",
"6436619", "Cheviot",
"644896", "Wellington",
"647216", "Rotorua",
"6478999", "Hamilton",
"6439050", "Geraldine",
"644210", "Wellington",
"6462138", "Palmerston\ North",
"6439701", "Nelson",
"6442199", "Paraparaumu",
"643460", "Dunedin\/Palmerston",
"6499719", "Whangarei",
"6433951", "Timaru",
"6469318", "Levin",
"6473926", "Taumarunui",
"6463944", "Featherston",
"6469714", "Hawera",
"649407", "Kaikohe",
"6433916", "Hokitika",
"646765", "Stratford",
"6432994", "Otautau",
"6439746", "Dunedin",
"6468818", "Opunake",
"6435671", "Oamaru",
"6439021", "Ashburton",
"6493931", "Whangarei",
"6473332", "Rotorua",
"6474447", "Te\ Kuiti",
"6432757", "Lumsden",
"64627", "Hawera",
"6468822", "Masterton",
"6468992", "Wairoa",
"6434223", "Otautau",
"64931", "Auckland\/Waiheke\ Island",
"6432649", "Waimate",
"6462154", "New\ Plymouth",
"6434402", "Alexandra",
"6469305", "New\ Plymouth",
"6492426", "Whangarei",
"6434249", "Kaikoura",
"6432623", "Lawrence",
"6439077", "Ashburton",
"6466996", "Stratford",
"6475821", "Hamilton",
"6478134", "Taumarunui",
"6463912", "New\ Plymouth",
"6434240", "Ashburton",
"644570", "Wellington",
"643941", "Christchurch",
"6439531", "Timaru",
"6465611", "Napier",
"6432807", "Tokanui",
"6466011", "Marton",
"644209", "Wellington",
"6439872", "Alexandra",
"6472601", "Hamilton",
"6463928", "Pahiatua",
"6474638", "Opotiki",
"6439083", "Cheviot",
"6462414", "Napier",
"647862", "Paeroa",
"6468258", "Waiouru",
"64686", "Gisborne",
"6496518", "Kawakawa",
"6462125", "Taihape",
"6432640", "Hokitika",
"6434281", "Queenstown",
"643443", "Wanaka",
"6473995", "Putaruru\/Tokoroa",
"649459", "Whangarei",
"643753", "Hokitika",
"6469045", "Waipukurau",
"6479003", "Thames",
"6469293", "New\ Plymouth",
"6462166", "Opunake",
"6434267", "Ranfurly",
"6472198", "Opotiki",
"643338", "Christchurch",
"6469017", "Marton",
"647463", "Whakatane",
"6467775", "Palmerston\ North",
"6496008", "Hibiscus\ Coast",
"6432667", "South\ Island",
"6435663", "Twizel",
"6436591", "Nelson",
"6439713", "Mt\ Cook",
"6495564", "Whangarei",
"6436992", "Greymouth",
"6433943", "Amberley",
"6499006", "Whangarei",
"647987", "Tauranga",
"6499062", "Hibiscus\ Coast",
"6499473", "Helensville",
"6468245", "Wairoa",
"6436626", "Akaroa",
"6478990", "Thames",
"6434353", "Twizel",
"6492227", "Whangarei",
"643937", "South\ Island",
"6499041", "Helensville",
"6474654", "Taumarunui",
"6499726", "Kawakawa",
"6462102", "Levin",
"6497771", "Kaikohe",
"6496100", "Pukekohe",
"6437456", "Culverden",
"6436610", "Kaikoura",
"6492835", "Kaikohe",
"643667", "Christchurch",
"6496015", "Maungaturoto",
"6439851", "Culverden",
"6469271", "Pahiatua",
"6498691", "Maungaturoto",
"6439326", "Rangiora",
"6478083", "Hamilton",
"6499551", "Whangarei",
"6432446", "Blenheim",
"6439457", "Winton",
"6439310", "Invercargill",
"64694", "Masterton\/Levin",
"6439523", "Balclutha",
"646954", "Palmerston\ North\ W100",
"6435500", "Christchurch",
"6462624", "Opunake",
"647925", "Tauranga",
"64368", "Timaru",
"6432993", "Balclutha",
"6435997", "Amberley",
"6432710", "Christchurch",
"64930", "Auckland",
"647391", "Hamilton",
"647974", "Hamilton",
"6436546", "Fairlie",
"6479027", "Paeroa",
"643905", "Ashburton",
"6432726", "Franz\ Josef",
"6469612", "Wanganui\/New\ Plymouth",
"6435532", "Motueka",
"6434224", "Te\ Anau",
"64796", "Hamilton",
"6472115", "Taumarunui",
"6439271", "Westport",
"6469851", "Napier",
"646962", "Wanganui\/New\ Plymouth",
"6462153", "New\ Plymouth",
"6472147", "Paeroa",
"6472424", "Tauranga",
"6479748", "Taumarunui",
"6469310", "Wanganui",
"64452", "Wellington",
"649422", "Warkworth",
"6478133", "Putaruru\/Tokoroa",
"6473922", "Morrinsville",
"643277", "South\ Island",
"643954", "Dunedin\/Timaru",
"6432624", "Milton",
"6475621", "Tauranga",
"6472813", "Waihi",
"6433912", "Motueka",
"6466004", "Waipukurau",
"6468810", "Ohakune",
"6472614", "Otorohanga",
"6449740", "Paraparaumu",
"646842", "Napier\/Hastings",
"6439742", "Christchurch",
"64784", "Hamilton",
"6462807", "Napier\/Hastings",
"643438", "Kurow",
"6439761", "Kurow",
"643466", "Dunedin",
"6496009", "Pukekohe",
"6433985", "Alexandra",
"6465604", "Ohakune",
"647210", "Hamilton",
"6435694", "Franz\ Josef",
"649401", "Kaikohe",
"6472199", "Opotiki",
"644890", "Wellington",
"643226", "Otautau",
"6437463", "Mt\ Cook",
"6468826", "Levin",
"644815", "Wellington",
"6436501", "Akaroa",
"643218", "Invercargill",
"6496519", "Maungaturoto",
"6468996", "Napier",
"6439045", "Twizel",
"6468259", "Levin",
"6439293", "Blenheim",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6474639", "Opotiki",
"6439017", "Cromwell",
"643392", "South\ Island",
"64483", "Wellington",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"6437775", "Wanaka",
"6469713", "Stratford",
"6463943", "Masterton",
"6469203", "New\ Plymouth",
"6479245", "Matamata",
"6466992", "Hawera",
"6499818", "Great\ Barrier\ Island",
"6478082", "Tauranga",
"6462818", "New\ Plymouth",
"6439099", "Kaikoura",
"6439288", "Ashburton",
"643743", "Christchurch",
"6479025", "Huntly",
"643453", "Dunedin",
"6462164", "New\ Plymouth",
"6495566", "Kaikohe",
"64687", "Napier\/Hastings",
"6499004", "Hibiscus\ Coast",
"6432740", "Lawrence",
"6435995", "Darfield",
"6436520", "Greymouth",
"6492009", "Pukekohe",
"6439522", "Dunedin",
"647920", "Rotorua",
"6479299", "Rotorua",
"647872", "Te\ Awamutu",
"6469009", "Palmerston\ North",
"646766", "New\ Plymouth",
"6499420", "Pukekohe",
"6439008", "Timaru",
"6462420", "Palmerston\ North",
"643951", "Dunedin",
"6496990", "Kaitaia",
"6499063", "Hibiscus\ Coast",
"6439266", "Dunedin",
"6499472", "Great\ Barrier\ Island",
"6477889", "Whakatane",
"644586", "Wellington",
"6469289", "Taihape",
"6472145", "Huntly",
"6462103", "Levin",
"6495588", "Hibiscus\ Coast",
"6473948", "Opotiki",
"6432819", "Christchurch",
"6479718", "Taumarunui",
"6462416", "Waipukurau",
"646864", "Ruatoria",
"6435888", "Timaru",
"6472829", "Tauranga",
"6439324", "Darfield",
"6499451", "Warkworth",
"6439728", "Franz\ Josef",
"6475600", "Hamilton",
"6432444", "Nelson",
"649404", "Kawakawa",
"646385", "Ohakune",
"644205", "Wellington",
"6479002", "Matamata",
"6469292", "Ruatoria",
"647215", "Rotorua",
"6447771", "Paraparaumu",
"644895", "Paraparaumu",
"6462610", "Napier",
"6433942", "Akaroa",
"64328", "South\ Island",
"647828", "Huntly",
"6436993", "Kaikoura",
"6462805", "Napier\/Hastings",
"6439712", "Fairlie",
"6439060", "Greymouth",
"6433987", "Cromwell",
"6462626", "Mokau",
"6435662", "Geraldine",
"6439873", "Wanaka",
"6479247", "Hamilton",
"6474656", "Te\ Awamutu",
"6437777", "Christchurch",
"643485", "Lawrence",
"6463913", "Hawera",
"6436624", "Darfield",
"6434279", "Twizel",
"6439015", "Wanaka",
"6468881", "Napier\/Hastings",
"6435680", "Dunedin",
"6437454", "Ashburton",
"6432221", "Nelson",
"6439082", "Culverden",
"644810", "Wellington",
"6439047", "Alexandra",
"6462127", "Dannevirke",
"6434226", "Lumsden",
"646327", "Marton",
"6439292", "Timaru",
"6495530", "Great\ Barrier\ Island",
"6432610", "Darfield",
"6434278", "Roxburgh",
"643232", "Riverton\/Winton",
"6466993", "Waiouru",
"6432805", "Winton",
"6469202", "Levin",
"6463942", "Masterton",
"64731", "Whakatane\/Opotiki",
"643944", "Christchurch",
"6437480", "Gore",
"6432626", "Kurow",
"6469712", "New\ Plymouth",
"64998", "Whangarei",
"644819", "Wellington",
"6473931", "Whangamata",
"6439743", "Christchurch",
"6433913", "Murchison",
"6472812", "Tauranga",
"6432665", "South\ Island",
"6467777", "Napier",
"6467556", "New\ Plymouth\/Mokau",
"643267", "South\ Island",
"6434265", "Milton",
"6432724", "Greymouth",
"6437441", "Motueka",
"6466551", "New\ Plymouth",
"643412", "Balclutha",
"6437462", "Geraldine",
"6462221", "Gisborne",
"6439729", "Fox\ Glacier",
"6472828", "Tauranga",
"6473997", "Te\ Kuiti",
"6435889", "Timaru",
"6462152", "New\ Plymouth",
"6479719", "Te\ Kuiti",
"6434404", "Alexandra",
"6432818", "Christchurch",
"6473949", "Taupo",
"6495589", "Pukekohe",
"6469288", "Waiouru",
"6468994", "Waipukurau",
"6436640", "Palmerston",
"6477888", "Taupo",
"6496507", "Helensville",
"644834", "Paraparaumu",
"6492225", "Pukekohe",
"6473923", "Otorohanga",
"6469570", "Palmerston\ North",
"6442820", "Wellington",
"6478132", "Paeroa",
"6466520", "Palmerston\ North",
"6439009", "Greymouth",
"6468247", "Mokau",
"6499011", "Kaitaia",
"6443333", "Paraparaumu",
"6435", "South\ Island",
"6479298", "Taupo",
"6435550", "Fox\ Glacier",
"6469008", "Palmerston\ North",
"6439340", "Mt\ Cook",
"6432420", "Christchurch",
"646376", "Pahiatua",
"6492008", "Hibiscus\ Coast",
"64785", "Hamilton",
"6465606", "Waiouru",
"6439455", "Otautau",
"649397", "Auckland\/Waiheke\ Island",
"646951", "Palmerston\ North",
"6466006", "Opunake",
"6472616", "Taumarunui",
"6436681", "Dunedin",
"649349", "Auckland",
"6432992", "Gore",
"6435533", "Murchison",
"6469613", "Levin",
"6472620", "Tauranga",
"647589", "Hamilton",
"6468824", "Wanganui",
"6439289", "Akaroa",
"6468260", "Featherston",
"6496017", "Great\ Barrier\ Island",
"643539", "Nelson",
"6439098", "Akaroa",
"6492837", "Hibiscus\ Coast",
"6462819", "Levin",
"6435696", "Haast",
"6499819", "Helensville",
"6468807", "Gisborne",
"6432443", "Christchurch",
"6468269", "New\ Plymouth",
"6439280", "Nelson",
"6478086", "Hamilton",
"6472121", "Te\ Kuiti",
"6472629", "Taupo",
"6439323", "Cheviot",
"644816", "Wellington",
"6498820", "Whangarei",
"646365", "Palmerston\ North",
"6499810", "Hibiscus\ Coast",
"6462810", "Gisborne",
"6436585", "Tokanui",
"6436528", "Westport",
"6462605", "Marton",
"6432429", "Timaru",
"6498816", "Great\ Barrier\ Island",
"6495562", "Whangarei",
"6436994", "Murchison",
"6436576", "Cromwell",
"6439349", "South\ Island",
"6435559", "Haast",
"6434295", "Fox\ Glacier",
"6499878", "Warkworth",
"6478075", "Te\ Kuiti",
"6439526", "Twizel",
"6479849", "Thames",
"6475615", "Waihi",
"6434991", "Cromwell",
"6432748", "Cromwell",
"6496998", "Helensville",
"6469579", "Pahiatua",
"6439874", "Cromwell",
"6477771", "Whakatane",
"6436623", "Amberley",
"6499428", "Warkworth",
"6463914", "Stratford",
"6479102", "Rotorua",
"64632", "Palmerston\ North",
"6439000", "Christchurch",
"643465", "Palmerston",
"6466529", "Pahiatua",
"6439751", "Culverden",
"6437453", "Amberley",
"643225", "Otautau",
"6479710", "Putaruru\/Tokoroa",
"6435880", "Dunedin",
"6463991", "Masterton",
"6436649", "Gore",
"643957", "Timaru",
"64423", "Wellington",
"6462412", "Gisborne",
"6432755", "Edendale",
"6474445", "Hamilton",
"6462618", "Masterton",
"6462163", "New\ Plymouth",
"6469296", "Levin",
"6439720", "Blenheim",
"6475608", "Otorohanga",
"6499003", "Warkworth",
"6433946", "Culverden",
"644908", "Paraparaumu",
"649439", "Dargaville",
"6439716", "Geraldine",
"6435666", "Oamaru",
"6436631", "Motueka",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6439068", "Fox\ Glacier",
"6439075", "Takaka",
"6437489", "South\ Island",
"647926", "Tauranga",
"6474652", "Paeroa",
"6498851", "Pukekohe",
"6499064", "Helensville",
"6472133", "Taupo",
"6462104", "Marton",
"6469307", "Stratford",
"6439331", "Greymouth",
"6432619", "Christchurch",
"6435688", "Queenstown",
"6432731", "Timaru",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6435689", "Otautau",
"6439861", "Nelson",
"6432618", "Culverden",
"646769", "New\ Plymouth",
"647903", "Hamilton",
"6434270", "Oamaru",
"6439296", "Invercargill",
"6434222", "Gore",
"6439887", "Christchurch\/Blenheim\/Nelson",
"6478090", "Thames",
"6468993", "Taihape",
"6473924", "Paeroa",
"6432622", "Balclutha",
"6469716", "Opunake",
"644589", "Wellington",
"6436655", "Westport",
"646321", "Marton",
"6437488", "South\ Island",
"643923", "Nelson",
"6465625", "Gisborne",
"6439069", "Haast",
"647533", "Tauranga",
"6472816", "Morrinsville",
"6468823", "Napier\/Hastings",
"6475609", "Paeroa",
"6435534", "Takaka",
"6472820", "Hamilton",
"6469614", "Levin",
"6435545", "Gore",
"644619", "Wellington",
"643458", "Dunedin\/Queenstown",
"6437466", "Cromwell",
"6462619", "Featherston",
"643421", "Christchurch",
"6479855", "Taupo",
"6435517", "Lawrence",
"6472457", "Rotorua",
"6462156", "Hawera",
"6469280", "Waipukurau",
"6436648", "Lumsden",
"6477880", "Hamilton",
"64367", "South\ Island",
"6449030", "Paraparaumu",
"6432810", "Franz\ Josef",
"6466528", "Dannevirke",
"6432657", "Motueka",
"6466994", "Ohakune",
"6478136", "Te\ Awamutu",
"6499748", "Whangarei",
"6469578", "Marton",
"6432749", "Wanaka",
"6469241", "Napier",
"6463901", "Gisborne",
"6498017", "Hibiscus\ Coast",
"6479848", "Te\ Kuiti",
"6465602", "Palmerston\ North",
"647823", "Hamilton",
"6499879", "Warkworth",
"6479290", "Hamilton",
"64332", "Christchurch",
"6469000", "New\ Plymouth",
"6439348", "South\ Island",
"6435558", "Waimate",
"6498900", "Pukekohe",
"6466002", "Napier",
"6433914", "Takaka",
"6472612", "Te\ Awamutu",
"6432428", "Queenstown",
"6432996", "Riverton",
"6439735", "Lumsden",
"6436529", "Westport",
"6439744", "Queenstown",
"64730", "Whakatane",
"6439090", "Rangiora",
"6432723", "Takaka",
"6494315", "Warkworth",
"6433991", "Invercargill",
"6472628", "Taupo",
"649391", "Auckland",
"6435692", "Takaka",
"6468268", "New\ Plymouth",
"6466548", "Ruatoria",
"6462100", "Levin",
"6499100", "Pukekohe",
"6436612", "Akaroa",
"64370", "South\ Island",
"6499728", "Dargaville",
"6436685", "Nelson",
"6439451", "Invercargill",
"6437458", "Kaikoura",
"6499557", "Warkworth",
"6462423", "Gisborne",
"64325", "South\ Island",
"6436628", "Ashburton",
"6499423", "Great\ Barrier\ Island",
"647982", "Hamilton",
"647881", "Matamata",
"6469277", "Gisborne",
"6499060", "Warkworth",
"6439857", "Akaroa",
"64698", "Gisborne",
"6496993", "Whangarei",
"6478992", "Paeroa",
"6493942", "Great\ Barrier\ Island",
"6435502", "Christchurch",
"646654", "Gisborne",
"6432743", "Kurow",
"6497777", "Auckland",
"643455", "Dunedin",
"6439312", "Riverton",
"6499873", "Kaitaia",
"6436523", "Hokitika",
"6432729", "Westport",
"6499047", "Pukekohe",
"6439328", "South\ Island",
"6499015", "Dargaville",
"6432448", "Dunedin",
"6436549", "Mt\ Cook",
"6439724", "Blenheim",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"647867", "Thames",
"6435683", "Te\ Anau",
"6473935", "Rotorua",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6463926", "Taihape",
"6473944", "Tauranga",
"6432642", "Fox\ Glacier",
"643449", "Alexandra",
"6435884", "Dunedin",
"6479714", "Huntly",
"6436597", "Cromwell",
"6468999", "Napier",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6432661", "Christchurch",
"6468256", "Palmerston\ North",
"6496516", "Kaikohe",
"6439870", "Queenstown",
"6437445", "Fox\ Glacier",
"6434261", "Balclutha",
"643521", "Nelson",
"6439004", "Gore",
"646750", "Mokau",
"6434242", "Darfield",
"643336", "Christchurch",
"6466555", "Hawera",
"6462225", "Levin",
"6434287", "Queenstown",
"644887", "Wellington",
"6439063", "Westport",
"6436990", "Cheviot",
"644893", "Wellington",
"6499008", "Pukekohe",
"644203", "Wellington",
"643981", "Christchurch",
"64683", "Napier\/Hastings",
"647213", "Hamilton",
"6475603", "Hamilton",
"6439284", "Blenheim",
"6472607", "Paeroa",
"6466017", "Napier",
"6432801", "Lumsden",
"6462168", "Featherston",
"6439537", "Dunedin\/Timaru",
"6465617", "Mokau",
"6498824", "Kawakawa",
"6472196", "Taupo",
"6462613", "Waipukurau",
"6473339", "Taupo",
"6462814", "Hawera",
"6473338", "Rotorua",
"6439094", "Ashburton",
"6442125", "Paraparaumu",
"6462169", "Featherston",
"647460", "Rotorua",
"647220", "Tauranga",
"6439011", "Queenstown",
"6468885", "New\ Plymouth",
"6495", "Auckland",
"646847", "Napier\/Hastings",
"643216", "Invercargill",
"6433910", "Nelson",
"6479294", "Hamilton",
"6469004", "Napier\/Hastings",
"643750", "Haast",
"6432225", "Greymouth",
"6439740", "Christchurch",
"6468812", "Waiouru",
"6436507", "Kaikoura",
"6437483", "Otautau",
"6466990", "Mokau",
"6499455", "Dargaville",
"643397", "South\ Island",
"6468305", "Napier\/Wairoa",
"6469284", "Stratford",
"6477884", "Tauranga",
"6439767", "Alexandra",
"6468998", "Napier",
"6462801", "Palmerston\ North",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"643468", "Dunedin",
"6432814", "Mt\ Cook",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"643436", "Kurow",
"6495533", "Whangarei",
"6472623", "Tauranga",
"6436548", "Waimate",
"6468263", "Napier",
"6475627", "Taupo",
"644905", "Paraparaumu",
"6432449", "Queenstown",
"6469610", "Wanganui",
"6435530", "Nelson",
"6439329", "South\ Island",
"6432728", "Haast",
"6432423", "Dunedin",
"6472141", "Te\ Kuiti",
"64793", "Tauranga",
"6439343", "Waimate",
"6435553", "Wanaka",
"6479843", "Morrinsville",
"6439277", "Invercargill",
"6432712", "Amberley",
"649427", "Hibiscus\ Coast",
"6473920", "Huntly",
"6469573", "Palmerston\ North",
"643654", "Timaru",
"64364", "South\ Island",
"6479021", "Te\ Awamutu",
"6469312", "Ohakune",
"6436629", "Christchurch",
"6466523", "Palmerston\ North",
"6437459", "Rangiora",
"6434274", "Kurow",
"6498881", "Hibiscus\ Coast",
"6436643", "Balclutha",
"6478094", "Tauranga",
"646967", "New\ Plymouth",
"6435991", "Franz\ Josef",
"6466549", "Ruatoria",
"6479746", "Opotiki",
"6479713", "Morrinsville",
"6432887", "Nelson",
"647887", "Morrinsville",
"6435883", "Dunedin",
"6437450", "Westport",
"6463905", "Napier",
"6436616", "Geraldine",
"6435684", "Winton",
"643463", "Palmerston",
"644550", "Wellington",
"6439731", "Gore",
"6462108", "Ohakune",
"644213", "Wellington",
"6479422", "Tauranga",
"6499068", "Pukekohe",
"6473929", "Thames",
"6499716", "Helensville",
"6436620", "Kaikoura",
"6478996", "Huntly",
"6433995", "Tokanui",
"6439003", "Ashburton",
"6435506", "Amberley",
"643576", "Nelson",
"6439064", "Ashburton",
"6439316", "Edendale",
"6472807", "Te\ Awamutu",
"6439320", "Akaroa",
"6469619", "Wanganui\/New\ Plymouth",
"6435539", "Otautau",
"643219", "Invercargill",
"6432440", "Christchurch",
"6439283", "Rangiora",
"6475604", "Hamilton",
"6462813", "Wanganui",
"6462614", "Wairoa",
"6498823", "Kaitaia",
"643234", "Riverton",
"6463922", "Palmerston\ North",
"6472130", "Tauranga",
"643942", "Christchurch",
"6432646", "Timaru",
"6465621", "New\ Plymouth",
"6468252", "Dannevirke",
"643527", "Motueka",
"6496512", "Whangarei",
"6437477", "Roxburgh",
"6463918", "Wanganui",
"6466999", "New\ Plymouth",
"6435541", "Te\ Anau",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"6462424", "Wanganui",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6439878", "Christchurch\/Blenheim\/Nelson",
"6496994", "Dargaville",
"6462115", "Wairoa",
"6492429", "Pukekohe",
"6435562", "Invercargill",
"6479851", "Waihi",
"6432744", "Ranfurly",
"6432735", "Mt\ Cook",
"64371", "South\ Island",
"6439865", "Murchison",
"643414", "Balclutha\/Milton",
"6436524", "Hokitika",
"6439749", "Christchurch",
"6499874", "Kawakawa",
"6436998", "Blenheim",
"6433919", "Haast",
"649957", "Pukekohe",
"643682", "Timaru\/Waimate\/Fairlie",
"6439723", "Blenheim",
"6472192", "Whakatane",
"649652", "Warkworth",
"6462160", "Masterton",
"6436651", "Riverton",
"6475827", "Hamilton",
"6472823", "Whakatane",
"6439071", "Motueka",
"6468264", "Palmerston\ North",
"6468820", "Palmerston\ North",
"6472624", "Whakatane",
"646841", "Napier\ City",
"6498855", "Kawakawa",
"6433918", "Fox\ Glacier",
"6436999", "Nelson",
"6439344", "Timaru",
"6435554", "Cromwell",
"6439335", "Haast",
"6439748", "Dunedin",
"643690", "Waimate",
"649402", "Kawakawa",
"6432424", "Nelson",
"64396", "Christchurch",
"6479844", "Otorohanga",
"6468816", "Hawera",
"6492428", "Hibiscus\ Coast",
"6432751", "Riverton",
"6474441", "Waihi",
"6469574", "Taihape",
"6439879", "Christchurch\/Blenheim\/Nelson",
"64932", "Auckland\/Waiheke\ Island",
"6466524", "Ohakune",
"6493937", "Warkworth",
"6439027", "Winton",
"6466998", "New\ Plymouth",
"6435677", "Ranfurly",
"6434273", "Lawrence",
"6493991", "Pukekohe",
"64363", "South\ Island",
"6434400", "Alexandra",
"643925", "Christchurch",
"6436635", "Fairlie",
"6478093", "Rotorua",
"6436644", "Alexandra",
"6468990", "Ruatoria",
"647825", "Hamilton",
"643430", "Mt\ Cook",
"6499296", "Kaitaia",
"6439093", "Ashburton",
"6432720", "Nelson",
"6433957", "Palmerston",
"6439707", "Takaka",
"6439755", "Rangiora",
"6477775", "Huntly",
"6469618", "Wanganui\/New\ Plymouth",
"6435538", "Lumsden",
"646837", "Wairoa",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"646388", "Taihape",
"6499467", "Kaitaia",
"647218", "Tauranga",
"6479045", "Taumarunui",
"6463995", "Marton",
"6469003", "Napier\/Hastings",
"6479293", "Hamilton",
"6432716", "Darfield",
"643446", "Roxburgh",
"64349", "South\ Island",
"6436567", "Ranfurly",
"6435650", "Greymouth",
"643756", "Hokitika",
"6472125", "Huntly",
"6437484", "Riverton",
"6473928", "Te\ Awamutu",
"6439052", "Mt\ Cook",
"6469316", "Dannevirke",
"6434237", "Culverden",
"6436581", "Invercargill",
"6499069", "Pukekohe",
"647466", "Tauranga",
"649470", "Whangarei",
"6477883", "Hamilton",
"6434291", "Westport",
"6462109", "Waiouru",
"649421", "Hibiscus\ Coast",
"6462601", "Palmerston\ North",
"649458", "Dargaville",
"643206", "Edendale",
"6469283", "Opunake",
"6432637", "Winton",
"6432813", "Geraldine",
"6434995", "Te\ Anau",
"6478071", "Otorohanga",
"643339", "Christchurch",
"6475611", "Taumarunui",
"6432614", "South\ Island",
"6469852", "Napier",
"6462608", "Dannevirke",
"6439739", "Invercargill",
"6436525", "Franz\ Josef",
"6435990", "Hokitika",
"6439272", "Timaru",
"643413", "Balclutha",
"6499466", "Kaikohe",
"6498880", "Helensville",
"6499875", "Dargaville",
"6434298", "Hokitika",
"6432717", "Kaikoura",
"6478078", "Whangamata",
"6475618", "Opotiki",
"6439864", "Takaka",
"6432745", "Roxburgh",
"6444887", "Paraparaumu",
"6432734", "Waimate",
"643956", "Timaru",
"6439706", "Nelson",
"6479020", "Te\ Awamutu",
"6499013", "Kawakawa",
"6475622", "Tauranga",
"646761", "Opunake",
"6473921", "Matamata",
"6433956", "Dunedin",
"6436588", "Lumsden",
"6499297", "Hibiscus\ Coast",
"6436683", "Rangiora",
"644817", "Wellington",
"643233", "Riverton\/Winton",
"6469893", "Ruatoria",
"6432636", "Te\ Anau",
"6472140", "Putaruru\/Tokoroa",
"6496995", "Maungaturoto",
"6469317", "Pahiatua",
"6434236", "Amberley",
"6462114", "Waipukurau",
"6435531", "Nelson",
"6469611", "Wanganui",
"643269", "South\ Island",
"6436566", "Kurow",
"6432609", "Mt\ Cook",
"6462137", "Palmerston\ North",
"6462425", "Masterton",
"6436502", "Amberley",
"6468817", "Stratford",
"647927", "Tauranga",
"6462800", "Palmerston\ North",
"64347", "Dunedin",
"6439065", "Ashburton",
"6432758", "Otautau",
"6474448", "Taumarunui",
"6479859", "Tauranga",
"6462615", "Gisborne",
"6466991", "Wanganui",
"6475826", "Hamilton",
"6435549", "Hokitika",
"644902", "Paraparaumu",
"6475605", "Huntly",
"6439741", "Christchurch",
"649399", "Auckland",
"643464", "Dunedin",
"649347", "Auckland",
"6433911", "Nelson",
"64637", "Masterton",
"6435685", "Tokanui",
"6439010", "Queenstown",
"64376", "Greymouth",
"6463904", "Napier",
"6473933", "Rotorua",
"6439762", "Oamaru",
"6439078", "Ashburton",
"6466553", "New\ Plymouth",
"6462223", "Palmerston\ North",
"6493936", "Maungaturoto",
"6433994", "Winton",
"6439026", "Riverton",
"6436659", "Haast",
"6435676", "Kurow",
"64943", "Whangarei",
"6437443", "Nelson",
"643224", "Invercargill",
"6434247", "Kaikoura",
"643935", "South\ Island",
"6434282", "Queenstown",
"6432800", "Te\ Anau",
"64362", "South\ Island",
"6499453", "Warkworth",
"6436658", "Fox\ Glacier",
"6437485", "Te\ Anau",
"6472124", "Matamata",
"6439079", "Murchison",
"64354", "Nelson",
"6434994", "Palmerston",
"64391", "South\ Island",
"6432615", "Amberley",
"6437476", "Ranfurly",
"64933", "Auckland",
"6436991", "Culverden",
"6432647", "Fairlie",
"64735", "Rotorua",
"6436592", "Nelson",
"6439754", "Darfield",
"6465612", "Waipukurau",
"6439532", "Timaru",
"647873", "Otorohanga",
"6435548", "Westport",
"6477774", "Thames",
"6463911", "New\ Plymouth",
"6434260", "Oamaru",
"6479858", "Whakatane",
"6472602", "Hamilton",
"64337", "Christchurch",
"6439871", "Queenstown",
"6474449", "Opotiki",
"6469010", "Taihape",
"6432759", "South\ Island",
"643742", "Dunedin",
"6432223", "Akaroa",
"6463994", "Dannevirke",
"643452", "Wanaka",
"6432660", "Christchurch",
"649390", "Auckland",
"6468883", "Palmerston\ North",
"643248", "Lumsden",
"6469272", "Featherston",
"6439852", "Cheviot",
"6499717", "Whangarei",
"6432608", "Dunedin",
"6442197", "Paraparaumu",
"6466525", "Marton",
"6478997", "Morrinsville",
"6499552", "Dargaville",
"649431", "Maungaturoto",
"6469575", "Waiouru",
"646956", "Palmerston\ North\/New\ Plymouth",
"6436634", "Mt\ Cook",
"6436645", "Ranfurly",
"646320", "Palmerston\ North\/Marton",
"6436617", "Cromwell",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6436589", "Otautau",
"643260", "Christchurch",
"6499061", "Hibiscus\ Coast",
"6498854", "Hibiscus\ Coast",
"6472806", "Matamata",
"64480", "Wellington",
"6499042", "Hibiscus\ Coast",
"6472625", "Opotiki",
"64429", "Paraparaumu",
"6439450", "Invercargill",
"6439317", "Gore",
"6479845", "Paeroa",
"6475619", "Hamilton",
"6496", "Auckland",
"6478079", "Hamilton",
"6439345", "Christchurch",
"6435555", "Timaru",
"6435507", "Ashburton",
"6434299", "Haast",
"6499101", "Pukekohe",
"6439334", "Fox\ Glacier",
"6497772", "Kaitaia",
"643420", "Christchurch",
"6432425", "Invercargill",
"6462101", "Levin",
"6462609", "Pahiatua",
"6439738", "Winton",
"6478070", "Morrinsville",
"6499462", "Whangarei",
"644894", "Wellington",
"6475610", "Putaruru\/Tokoroa",
"6439276", "Nelson",
"644204", "Wellington",
"6439459", "Tokanui",
"649405", "Kaikohe",
"6462600", "Palmerston\ North",
"6435998", "Rangiora",
"6434290", "Greymouth",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"647878", "Te\ Kuiti",
"6439702", "Nelson",
"6498825", "Maungaturoto",
"6462815", "Wairoa",
"6436580", "Invercargill",
"6439285", "Invercargill",
"6475626", "Taupo",
"649552", "Pukekohe",
"644587", "Wellington",
"6433952", "Fairlie",
"64944", "Auckland",
"6479747", "Te\ Kuiti",
"643922", "Nelson",
"6472148", "Waihi",
"6473934", "Rotorua",
"6469243", "New\ Plymouth",
"6463903", "Ruatoria",
"6473945", "Tauranga",
"64378", "Westport",
"6479715", "Paeroa",
"6435885", "Invercargill",
"6432632", "Lumsden",
"646590", "Palmerston\ North",
"6439057", "Waimate",
"6434232", "Ashburton",
"6439005", "Invercargill",
"6433993", "Te\ Anau",
"6462224", "Masterton",
"6466554", "Hawera",
"6437444", "Takaka",
"6432721", "Motueka",
"6436562", "Balclutha",
"6492229", "Hibiscus\ Coast",
"6432669", "Rangiora",
"6462808", "Napier\/Hastings",
"6468991", "Gisborne",
"6436506", "Darfield",
"6432733", "Geraldine",
"6493990", "Great\ Barrier\ Island",
"6439863", "Motueka",
"646653", "Wanganui",
"6434401", "Cromwell",
"6499014", "Dargaville",
"6439725", "Christchurch",
"6469019", "Pahiatua",
"6474440", "Paeroa",
"6432750", "Invercargill",
"647970", "Hamilton",
"647822", "Hamilton\/Huntly",
"647921", "Rotorua",
"6434269", "Twizel",
"6436684", "Dunedin",
"6439018", "Ranfurly",
"643978", "Christchurch",
"6439766", "Balclutha",
"643950", "Dunedin",
"644650", "Wellington",
"6473331", "Rotorua",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6439022", "Ashburton",
"6493932", "Dargaville",
"646959", "Palmerston\ North\/New\ Plymouth",
"6435672", "Balclutha",
"6439070", "Motueka",
"6479708", "Thames",
"6468821", "Featherston",
"6432809", "Hokitika",
"6432808", "Westport",
"6436650", "Otautau",
"6462161", "Masterton",
"6479709", "Matamata",
"6434286", "Christchurch",
"643653", "Blenheim",
"6499733", "Warkworth",
"644240", "Wellington",
"6478095", "Taupo",
"6468257", "Taihape",
"6436633", "Geraldine",
"6437472", "Lawrence",
"6496517", "Kaitaia",
"6439019", "Roxburgh",
"6463927", "Dannevirke",
"6474637", "Opotiki",
"6434275", "Milton",
"6436596", "Queenstown",
"643238", "Riverton\/Winton",
"6472197", "Tauranga",
"6498853", "Whangarei",
"6439536", "Waimate",
"6465616", "Hawera",
"6434268", "Roxburgh",
"6479850", "Tokoroa",
"6472606", "Huntly",
"646950", "Palmerston\ North\/New\ Plymouth",
"6466016", "Napier",
"6435540", "Edendale",
"6446509", "Paraparaumu",
"6469022", "Hawera",
"643959", "Dunedin\/Timaru",
"643418", "Balclutha",
"6465620", "New\ Plymouth",
"6472131", "Rotorua",
"6462809", "Napier\/Hastings",
"6439333", "Franz\ Josef",
"6496007", "Helensville",
"6432668", "Blenheim",
"6469276", "Wanganui",
"6439856", "Darfield",
"6492228", "Warkworth",
"649396", "Auckland\/Waiheke\ Island",
"64934", "Auckland\/Waiheke\ Island",
"6468304", "Napier\/Wairoa",
"647334", "Rotorua",
"6432441", "Christchurch",
"6499556", "Maungaturoto",
"6472123", "Morrinsville",
"6439321", "Amberley",
"6499454", "Whangarei",
"6434993", "Alexandra",
"6432815", "Fairlie",
"6472149", "Whangamata",
"6469285", "Hawera",
"6477885", "Tauranga",
"6477773", "Taupo",
"6436621", "Culverden",
"6479029", "Waihi",
"6439753", "Amberley",
"6472802", "Paeroa",
"6499046", "Pukekohe",
"643685", "Fairlie",
"6439095", "Ashburton",
"6498", "Auckland",
"6479295", "Whakatane",
"6469005", "Wanganui",
"6463993", "Pahiatua",
"643590", "Christchurch",
"6435999", "Christchurch",
"6432224", "Invercargill",
"6439730", "Invercargill",
"6437451", "Blenheim",
"6439458", "Edendale",
"6497776", "Hibiscus\ Coast",
"6468884", "Palmerston\ North",
"64456", "Wellington",
"6499065", "Helensville",
"644572", "Wellington",
"64947", "Auckland",
"6468242", "Ruatoria",
"6472129", "Whangamata",
"6472621", "Tauranga",
"6432656", "Nelson",
"6439074", "Ashburton",
"6468261", "Masterton",
"643235", "Invercargill",
"6478137", "Thames",
"6433998", "Lumsden",
"6479841", "Huntly",
"6436680", "Akaroa",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"644393", "Paraparaumu",
"6463908", "Wairoa",
"6434999", "Dunedin",
"646849", "Napier\ City",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"647332", "Rotorua",
"6462105", "Taihape",
"6462157", "Stratford",
"6472143", "Morrinsville",
"6439341", "Fairlie",
"649907", "Warkworth",
"6435551", "Franz\ Josef",
"6496012", "Kawakawa",
"6477779", "Putaruru\/Tokoroa",
"6499010", "Kaitaia",
"6492832", "Dargaville",
"6439759", "Cromwell",
"643415", "Balclutha",
"6466521", "Palmerston\ North",
"6469571", "Palmerston\ North",
"6442821", "Wellington",
"6432754", "Tokanui",
"6474444", "Hamilton",
"647886", "Putaruru\/Tokoroa",
"6498883", "Whangarei",
"6436641", "Lawrence",
"64343", "Oamaru",
"6479049", "Te\ Kuiti",
"6463999", "Palmerston\ North",
"6435993", "Mt\ Cook",
"6432997", "Edendale",
"647557", "Tauranga",
"6498016", "Hibiscus\ Coast",
"6463915", "Opunake",
"6466550", "New\ Plymouth",
"6462220", "New\ Plymouth",
"6439875", "Ranfurly",
"6437440", "Nelson",
"6469869", "Ruatoria",
"643948", "Invercargill",
"6462118", "Waipukurau",
"644551", "Paraparaumu",
"6436639", "Oamaru",
"6439297", "Takaka",
"6439886", "Christchurch\/Blenheim\/Nelson",
"649320", "Auckland",
"6439013", "Ashburton",
"6473930", "Waihi",
"6462122", "Palmerston\ North",
"643331", "Christchurch",
"6437467", "Queenstown",
"6498859", "Kaitaia",
"643526", "Motueka",
"64369", "Geraldine",
"6436584", "Winton",
"6473992", "Opotiki",
"6435516", "Balclutha",
"6437481", "Invercargill",
"649429", "Great\ Barrier\ Island",
"646211", "Napier",
"6475614", "Thames",
"6475958", "Taupo",
"646969", "New\ Plymouth",
"6432611", "Kaikoura",
"6478074", "Taumarunui",
"6432738", "Oamaru",
"6493208", "Helensville",
"6495531", "Helensville",
"6472817", "Taupo",
"6439868", "Blenheim",
"6467772", "Hawera",
"6462604", "Ohakune",
"6439339", "South\ Island",
"6434294", "Franz\ Josef",
"6436995", "Westport",
"6462803", "Palmerston\ North",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6433915", "Greymouth",
"6439338", "Queenstown",
"6432663", "Christchurch",
"6439734", "Edendale",
"6432220", "Dunedin",
"6439745", "Greymouth",
"6435681", "Invercargill",
"6433947", "Darfield",
"6468880", "Napier\/Hastings",
"6439869", "Blenheim",
"6493209", "Great\ Barrier\ Island",
"6432739", "Balclutha",
"6439717", "Fairlie",
"647824", "Hamilton",
"6433982", "Kurow",
"6494314", "Warkworth",
"6469297", "Masterton",
"6479007", "Whakatane",
"649408", "Kaitaia",
"6498858", "Kaikohe",
"6434263", "Lawrence",
"647949", "Hamilton",
"6439042", "Oamaru",
"646960", "Wanganui\/New\ Plymouth",
"6439061", "Greymouth",
"643211", "Invercargill",
"6469306", "Hawera",
"647983", "Hamilton",
"6436638", "Kurow",
"6462119", "Wairoa",
"649420", "Helensville",
"6479752", "Rotorua",
"6462611", "Napier",
"6437772", "Timaru",
"6447770", "Paraparaumu",
"6449", "Wellington",
"6475601", "Hamilton",
"6466995", "Opunake",
"6432803", "Otautau",
"6479242", "Rotorua",
"6499450", "Warkworth",
"646840", "Napier\ City",
"6439527", "Kurow",
"6439453", "Te\ Anau",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"647869", "Thames",
"6498817", "Hibiscus\ Coast",
"649554", "Hibiscus\ Coast",
"6465624", "Featherston",
"6436577", "Cromwell",
"6463998", "Palmerston\ North",
"643447", "Alexandra",
"6479854", "Rotorua",
"644892", "Paraparaumu",
"6496991", "Kaikohe",
"644202", "Wellington",
"646382", "Taihape",
"6468806", "New\ Plymouth",
"64738", "Taupo",
"6462421", "New\ Plymouth",
"6439758", "Ashburton",
"6435535", "Invercargill",
"6499421", "Hibiscus\ Coast",
"6469615", "Masterton",
"6477778", "Te\ Awamutu",
"6435544", "Winton",
"6472226", "Te\ Kuiti",
"64937", "Auckland",
"6436521", "Greymouth",
"6432741", "Milton",
"6434998", "Dunedin",
"6469249", "Masterton",
"644889", "Wellington",
"6433999", "Otautau",
"6436654", "Tokanui",
"6499477", "Pukekohe",
"643924", "Christchurch",
"643390", "Christchurch",
"6472128", "Waihi",
"6473925", "Putaruru\/Tokoroa",
"649452", "Auckland",
"6468246", "Hawera",
"6436625", "Rangiora",
"6433990", "South\ Island",
"6432652", "Cromwell",
"6439091", "Rangiora",
"6469001", "New\ Plymouth",
"6479291", "Hamilton",
"643938", "South\ Island",
"6498901", "Pukekohe",
"644666", "Wellington",
"647988", "Rotorua",
"643571", "Nelson",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6499725", "Hibiscus\ Coast",
"6437455", "Cheviot",
"6469240", "Gisborne",
"6463900", "Gisborne",
"643520", "Blenheim",
"6439014", "Ashburton",
"6496016", "Warkworth",
"6492836", "Kaitaia",
"6436583", "Te\ Anau",
"6435697", "Westport",
"643980", "Christchurch",
"6439325", "Kaikoura",
"6499018", "Maungaturoto",
"649403", "Kawakawa",
"647551", "Tauranga",
"6432445", "Greymouth",
"6449031", "Paraparaumu",
"644595", "Wellington",
"6492809", "Maungaturoto",
"6466007", "Stratford",
"6432811", "Fox\ Glacier",
"6478073", "Putaruru\/Tokoroa",
"6475613", "Te\ Awamutu",
"6462804", "Palmerston\ North",
"6477881", "Hamilton",
"6434293", "Haast",
"6462603", "Palmerston\ North",
"6469281", "Wairoa",
"6465607", "Taihape",
"6437448", "Haast",
"6499459", "Maungaturoto",
"64634", "Wanganui",
"6472821", "Hamilton",
"6432627", "Alexandra",
"6439073", "Motueka",
"6466558", "Opunake",
"644886", "Wellington",
"6462228", "Wanganui",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6434227", "Riverton",
"647880", "Matamata",
"6439882", "Westport",
"643552", "Dunedin",
"6472144", "Matamata",
"6472427", "Rotorua",
"6462126", "Pahiatua",
"6435512", "Rangiora",
"6473996", "Otorohanga",
"6462165", "Stratford",
"643454", "Dunedin",
"6442129", "Paraparaumu",
"6474443", "Matamata",
"6432753", "Winton",
"647866", "Thames",
"6432229", "Dunedin",
"6435994", "Ashburton",
"643337", "Christchurch",
"6478091", "Matamata",
"6467776", "Levin",
"6435528", "Ranfurly",
"6434271", "Balclutha",
"6475950", "Hamilton",
"64320", "Gore",
"6432730", "Blenheim",
"6468889", "Levin",
"6439860", "Nelson",
"6468888", "Masterton",
"6439454", "Lumsden",
"64334", "Christchurch",
"647889", "Morrinsville",
"643396", "South\ Island",
"6435529", "Roxburgh",
"6439330", "Westport",
"6465623", "Opunake",
"6432228", "Wanaka",
"644904", "Paraparaumu",
"6433986", "Queenstown",
"6462627", "Wanganui",
"6442128", "Paraparaumu",
"6498850", "Great\ Barrier\ Island",
"6479853", "Putaruru",
"64736", "Rotorua",
"6435543", "Tokanui",
"644777", "Wellington",
"646830", "Napier",
"6468825", "Gisborne",
"6439046", "Kurow",
"6468995", "Napier",
"6436630", "Takaka",
"64675", "New\ Plymouth",
"643655", "Dunedin",
"64357", "Blenheim",
"6469302", "Napier",
"6434405", "Alexandra",
"6439721", "Blenheim",
"6466559", "Mokau",
"643462", "Dunedin\/Palmerston",
"6437776", "Cromwell",
"6499458", "Kawakawa",
"644212", "Wellington",
"6436653", "Edendale",
"643217", "Invercargill",
"647325", "Opotiki",
"646846", "Napier\ City",
"6478142", "Whakatane",
"6437449", "Hokitika",
"6474657", "Thames",
"6479246", "Thames",
"6439733", "Te\ Anau",
"6432664", "Christchurch",
"6463990", "Featherston",
"6479040", "Otorohanga",
"643529", "Nelson",
"6479711", "Whangamata",
"6435881", "Dunedin",
"6495567", "Kaitaia",
"6492808", "Great\ Barrier\ Island",
"649426", "Hibiscus\ Coast",
"6439750", "Kaikoura",
"6499019", "Maungaturoto",
"6494313", "Warkworth",
"6477770", "Tauranga",
"646966", "Wanganui\/New\ Plymouth",
"6439001", "Christchurch",
"6468802", "New\ Plymouth",
"6436517", "Motueka",
"6434264", "Kurow",
"643441", "Queenstown",
"6469014", "Dannevirke",
"643751", "Fox\ Glacier",
"6432725", "Hokitika",
"6434990", "Queenstown",
"643278", "South\ Island",
"6436689", "Christchurch",
"643250", "Christchurch",
"6472222", "Hamilton",
"6472116", "Thames",
"6462417", "Wanganui",
"643989", "Nelson",
"6462811", "New\ Plymouth",
"6479107", "Whakatane",
"6439267", "Dunedin",
"6499811", "Hibiscus\ Coast",
"6498821", "Dargaville",
"649959", "Hibiscus\ Coast",
"6432804", "Riverton",
"6439281", "Christchurch",
"643943", "Christchurch",
"6472120", "Putaruru\/Tokoroa",
"6466019", "Napier",
"6432752", "Te\ Anau",
"6475820", "Hamilton",
"6474442", "Morrinsville",
"6468827", "New\ Plymouth",
"643409", "Queenstown",
"6472609", "Whangamata",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6496014", "Dargaville",
"647827", "Hamilton",
"6492834", "Kawakawa",
"6473337", "Rotorua",
"6439539", "Dunedin\/Timaru",
"6465619", "Masterton",
"6462806", "Napier\/Hastings",
"643249", "Te\ Anau",
"646953", "Palmerston\ North\ W100",
"6436508", "Rangiora",
"6462625", "Hawera",
"647812", "Hamilton",
"6439072", "Ashburton",
"6474655", "Te\ Kuiti",
"6466509", "Napier\/Waipukurau",
"6434289", "Wanaka",
"6468244", "Waipukurau",
"6435670", "Palmerston",
"6439020", "Gore",
"6493930", "Whangarei",
"6436599", "Blenheim",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6439016", "Alexandra",
"6439883", "Hokitika",
"6439768", "Ranfurly",
"6468997", "Napier",
"6478128", "Huntly",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6432727", "Fox\ Glacier",
"6499049", "Great\ Barrier\ Island",
"6475628", "Tauranga",
"6439700", "Nelson",
"643444", "Ranfurly",
"6436547", "Geraldine",
"64948", "Auckland",
"6436582", "Riverton",
"6479026", "Paeroa",
"6473994", "Rotorua",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6439278", "Invercargill",
"6495565", "Dargaville",
"6462602", "Palmerston\ North",
"6434292", "Hokitika",
"6497779", "Great\ Barrier\ Island",
"6479010", "Thames",
"6475612", "Te\ Kuiti",
"6499460", "Whangarei",
"647464", "Hamilton",
"646762", "Stratford",
"6478072", "Paeroa",
"6435996", "Akaroa",
"6467774", "Dannevirke",
"6436560", "Palmerston",
"64635", "Palmerston\ North",
"6432653", "Wanaka",
"6499559", "Whangarei",
"647876", "Te\ Kuiti",
"6434230", "Christchurch",
"6469279", "Levin",
"6439859", "Christchurch\/Blenheim\/Nelson",
"6462124", "Marton",
"6472146", "Otorohanga",
"6432630", "Christchurch",
"6474648", "Huntly",
"6479500", "Whakatane",
"6499727", "Whangarei",
"6474649", "Matamata",
"643525", "Takaka",
"6437457", "Darfield",
"6472223", "Hamilton",
"6439044", "Milton",
"6439858", "Kaikoura",
"6492226", "Helensville",
"64737", "Taupo",
"6469278", "Gisborne",
"6479244", "Tauranga",
"6499558", "Great\ Barrier\ Island",
"6479754", "Tauranga",
"6437774", "Queenstown",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6465605", "Marton",
"64335", "Christchurch",
"6433984", "Roxburgh",
"64360", "South\ Island",
"6479421", "Tauranga",
"6497778", "Pukekohe",
"6466005", "Mokau",
"644590", "Wellington",
"6439456", "Riverton",
"6439732", "Otautau",
"64938", "Auckland\/Waiheke\ Island",
"6472615", "Te\ Kuiti",
"6439279", "Christchurch",
"649398", "Auckland\/Waiheke\ Island",
"6499630", "Pukekohe",
"6472800", "Thames",
"6439327", "Ashburton",
"64754", "Tauranga",
"6432447", "Timaru",
"6468803", "Gisborne",
"6499048", "Pukekohe",
"6494312", "Warkworth",
"6435695", "Fox\ Glacier",
"6478129", "Matamata",
"643416", "Balclutha\/Milton",
"6439769", "Roxburgh",
"6469303", "Waipukurau",
"647885", "Putaruru\/Tokoroa",
"6434225", "Edendale",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"6437470", "Balclutha",
"6436598", "Wanaka",
"6432806", "Edendale",
"6478143", "Opotiki",
"6434288", "Cromwell",
"6466508", "Napier\/Wairoa",
"6432625", "Twizel",
"6436652", "Winton",
"6472191", "Whakatane",
"6465622", "Stratford",
"6463921", "Palmerston\ North",
"6499007", "Kaikohe",
"643236", "Winton",
"6496511", "Whangarei",
"643268", "South\ Island",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6432666", "South\ Island",
"6469020", "Stratford",
"6468251", "Wanganui",
"6434266", "Palmerston",
"6439538", "Dunedin\/Timaru",
"6465618", "Masterton",
"643741", "Christchurch",
"6435542", "Riverton",
"6469016", "Ohakune",
"646650", "Napier",
"643451", "Queenstown",
"6479852", "Whangamata",
"6472608", "Waihi",
"644280", "Wellington",
"6435561", "Dunedin",
"6462167", "Mokau",
"6466018", "Napier",
"6432756", "Gore",
"6474446", "Otorohanga",
"6469295", "Wanganui",
"6479005", "Tauranga",
"6473993", "Te\ Awamutu",
"6475828", "Hamilton",
"6462802", "Palmerston\ North",
"6433945", "Cheviot",
"6439715", "Timaru",
"6467773", "Wanganui",
"64373", "Greymouth",
"647870", "Te\ Awamutu",
"6469029", "Opunake",
"6435665", "Waimate",
"6433917", "Franz\ Josef",
"6436500", "Christchurch",
"6439747", "Wanaka",
"647821", "Hamilton\/Huntly",
"647922", "Whakatane",
"6462149", "Ruatoria",
"6432654", "Blenheim",
"6439076", "Ashburton",
"6435678", "Roxburgh",
"6493938", "Auckland",
"6466997", "New\ Plymouth",
"6439028", "Edendale",
"6492427", "Warkworth",
"649425", "Warkworth",
"646965", "Wanganui\ W100",
"6462123", "Palmerston\ North",
"6439760", "Twizel",
"6439012", "Queenstown",
"6449741", "Paraparaumu",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6468811", "Marton",
"6437479", "Edendale",
"643214", "Invercargill",
"6475620", "Tauranga",
"6478085", "Tauranga",
"6439708", "Murchison",
"6472809", "Otorohanga",
"6469617", "Wanganui\/New\ Plymouth",
"6435537", "Winton",
"6436586", "Edendale",
"6469311", "Palmerston\ North",
"643239", "Invercargill",
"6492833", "Warkworth",
"6433958", "Oamaru",
"6496013", "Whangarei",
"6435514", "Palmerston",
"6479022", "Morrinsville",
"6499468", "Kawakawa",
"6498815", "Helensville",
"6462606", "Waiouru",
"6434296", "Greymouth",
"6439525", "Milton",
"6439270", "Greymouth",
"6475616", "Whangamata",
"6469850", "Napier",
"646845", "Napier\/Hastings",
"6478076", "Te\ Awamutu",
"6435992", "Fox\ Glacier",
"6479018", "Putaruru\/Tokoroa",
"6498882", "Whangarei",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6473927", "Te\ Kuiti",
"6442609", "Paraparaumu",
"643958", "Dunedin\/Timaru",
"643419", "Balclutha",
"643921", "Blenheim",
"6436568", "Roxburgh",
"6468243", "Napier",
"6499475", "Hibiscus\ Coast",
"6432889", "Blenheim",
"6472142", "Te\ Awamutu",
"6432711", "Akaroa",
"6439884", "Franz\ Josef",
"6432638", "Tokanui",
"6462155", "Hawera",
"6462107", "Dannevirke",
"6432639", "Edendale",
"6469304", "Wairoa",
"6435501", "Christchurch",
"647865", "Whangamata",
"646656", "Levin",
"6432888", "Nelson",
"6439311", "Invercargill",
"6432606", "Dunedin",
"6478144", "Tauranga",
"6498690", "Kawakawa",
"643230", "Invercargill",
"6478135", "Te\ Kuiti",
"6436569", "Alexandra",
"6439850", "Ashburton",
"6499067", "Pukekohe",
"6469270", "Marton",
"6442608", "Paraparaumu",
"6434239", "Christchurch",
"6479019", "Whangamata",
"6497770", "Whangarei",
"6436611", "Rangiora",
"646958", "Palmerston\ North\/New\ Plymouth",
"643288", "Christchurch",
"6439452", "Gore",
"6432995", "Winton",
"6439736", "Riverton",
"6499", "Auckland",
"6499469", "Maungaturoto",
"6499040", "Helensville",
"6433959", "Balclutha",
"64329", "South\ Island",
"643246", "Tokanui",
"644260", "Wellington",
"6478991", "Whangamata",
"6472808", "Putaruru\/Tokoroa",
"643979", "Christchurch",
"643410", "Balclutha\/Milton",
"6439709", "Motueka",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6479229", "Opotiki",
"6437478", "Twizel",
"6436590", "Nelson",
"64361", "Timaru",
"647590", "Hamilton",
"6439295", "Nelson",
"64790", "Taupo",
"6439043", "Ashburton",
"6472224", "Taupo",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6432802", "Gore",
"6439877", "Christchurch\/Blenheim\/Nelson",
"6469715", "Mokau",
"6463917", "Wanganui",
"6493939", "Auckland",
"6436656", "Hokitika",
"6439029", "Tokanui",
"6437773", "Dunedin",
"6435679", "Alexandra",
"6434280", "Queenstown",
"6479753", "Taupo",
"6433983", "Ranfurly",
"643457", "Dunedin",
"6465626", "Ruatoria",
"6432641", "Franz\ Josef",
"6436997", "Motueka",
"64936", "Auckland",
"6432662", "Christchurch",
"6472815", "Whakatane",
"6434262", "Alexandra",
"6472600", "Hamilton",
"6468804", "Napier",
"643334", "Christchurch",
"6475829", "Hamilton",
"6435546", "Greymouth",
"6469012", "Waiouru",
"6466010", "Taihape",
"6479856", "Tauranga",
"6465610", "Napier",
"6437465", "Waimate",
"6439530", "Timaru",
"646214", "Gisborne",
"6434241", "Rangiora",
"6463925", "Waiouru",
"64348", "Dunedin",
"6434277", "Ranfurly",
"6439880", "Greymouth",
"6439049", "Palmerston",
"6468255", "Pahiatua",
"6478097", "Whakatane",
"644245", "Wellington",
"6496515", "Dargaville",
"6462128", "Ohakune",
"6437446", "Franz\ Josef",
"6479249", "Huntly",
"6435673", "Lawrence",
"647868", "Thames",
"6437779", "Invercargill",
"6439023", "Te\ Anau",
"6493933", "Kaikohe",
"6462226", "Napier",
"6466556", "Stratford",
"64638", "Taihape\/Ohakune\/Waiouru",
"6433989", "Waimate",
"643332", "Christchurch",
"6439862", "Nelson",
"6435526", "Kurow",
"6467778", "Wairoa",
"6432732", "Fairlie",
"6469854", "Waipukurau",
"6439274", "Queenstown",
"6434221", "Invercargill",
"646869", "Gisborne\/Ruatoria",
"6432621", "Oamaru",
"6475624", "Rotorua",
"6472827", "Tauranga",
"6473998", "Taumarunui",
"6475823", "Hamilton",
"646955", "Palmerston\ North\/New\ Plymouth",
"644888", "Wellington",
"6424", "Scott\ Base",
"6472195", "Rotorua",
"6435510", "Darfield",
"643940", "Christchurch",
"6469287", "Ohakune",
"6432633", "Otautau",
"6465601", "Palmerston\ North",
"644571", "Wellington",
"6477887", "Te\ Awamutu",
"6469242", "Levin",
"6463902", "Gisborne",
"6439764", "Lawrence",
"6436686", "Invercargill",
"6472119", "Thames",
"649409", "Kaitaia",
"6472611", "Matamata",
"6432817", "Christchurch",
"6466001", "Napier",
"643666", "Christchurch",
"6432650", "Christchurch",
"6436563", "Lawrence",
"6468248", "New\ Plymouth",
"6496508", "Hibiscus\ Coast",
"6435691", "Murchison",
"646949", "Levin\ W100",
"6434233", "Rangiora",
"6433992", "Riverton",
"6443990", "Paraparaumu",
"643936", "South\ Island",
"643595", "Christchurch",
"6479297", "Tauranga",
"6469007", "Masterton",
"6492007", "Warkworth",
"6499463", "Whangarei",
"647986", "Hamilton",
"6436504", "Cheviot",
"6439097", "Darfield",
"6433953", "Geraldine",
"6492838", "Pukekohe",
"643680", "Fairlie",
"6499016", "Kaikohe",
"6439703", "Takaka",
"6468800", "Napier\/Hastings",
"6439287", "Oamaru",
"6472604", "Hamilton",
"6466014", "Napier",
"6472803", "Waihi",
"6439534", "Mt\ Cook",
"6465614", "Wanganui",
"6439752", "Cheviot",
"6479101", "Rotorua",
"6492839", "Whangarei",
"6462817", "Napier",
"6477772", "Rotorua",
"644891", "Wellington",
"649400", "Kaikohe",
"643276", "South\ Island",
"647211", "Hamilton",
"643983", "Christchurch",
"6462411", "New\ Plymouth",
"643949", "Dunedin",
"6463992", "Levin",
"643523", "Murchison",
"646968", "New\ Plymouth\ W100",
"6496509", "Pukekohe",
"6472122", "Te\ Awamutu",
"6468249", "Opunake",
"643689", "Waimate",
"6439055", "Fairlie",
"6439007", "Dunedin",
"6434284", "Wanaka",
"6473947", "Whakatane",
"6495561", "Whangarei",
"6472118", "Taumarunui",
"6435887", "Invercargill",
"6436594", "Waimate",
"6479717", "Otorohanga",
"649428", "Hibiscus\ Coast",
"6434992", "Ranfurly",
"649451", "Auckland",
"644250", "Wellington",
"6472220", "Tauranga",
"6474651", "Otorohanga",
"6499044", "Hibiscus\ Coast",
"646848", "Napier\ City",
"6473999", "Taupo",
"6439727", "Dunedin",
"647390", "Hamilton",
"6498852", "Warkworth",
"6439332", "Hokitika",
"6497774", "Warkworth",
"6468886", "Wanganui",
"6467779", "Masterton",
"6433988", "Wanaka",
"6432226", "Timaru",
"64338", "Christchurch",
"6499554", "Kaitaia",
"6499456", "Kaikohe",
"643467", "Dunedin",
"6478140", "Rotorua",
"6437778", "Greymouth",
"64935", "Auckland",
"6469274", "New\ Plymouth",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"646860", "Gisborne\/Ruatoria",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"64733", "Rotorua\/Taupo",
"647883", "Putaruru\/Tokoroa",
"643212", "Invercargill",
"6468306", "Napier\/Wairoa",
"6462129", "Waiouru",
"6462621", "New\ Plymouth",
"643955", "Dunedin",
"6439048", "Lawrence",
"6469300", "Gisborne",
"6437473", "Milton",
"647315", "Opotiki",
"6436632", "Murchison",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6469309", "Mokau",
"6473932", "Rotorua",
"6439763", "Palmerston",
"6432634", "Invercargill",
"6462120", "Palmerston\ North",
"6432645", "Greymouth",
"6472811", "Tauranga",
"649423", "Warkworth",
"6432617", "Cheviot",
"6437442", "Murchison",
"647980", "Hamilton",
"6436564", "Milton",
"6448880", "Paraparaumu",
"643528", "Motueka",
"646963", "Wanganui\/New\ Plymouth",
"6437487", "Winton",
"6434245", "Culverden",
"6434234", "Darfield",
"6462222", "Ohakune",
"643930", "Christchurch",
"6437461", "Fairlie",
"6466552", "New\ Plymouth",
"649395", "Auckland\/Waiheke\ Island",
"6479014", "Matamata",
"6492", "Auckland",
"6439866", "Christchurch\/Blenheim\/Nelson",
"6493206", "Pukekohe",
"6432736", "Dunedin",
"6436503", "Ashburton",
"649958", "Helensville",
"6499464", "Whangarei",
"6467770", "Gisborne",
"6439291", "Dunedin",
"6469711", "New\ Plymouth",
"643279", "South\ Island",
"643660", "Christchurch",
"6435518", "Milton",
"6463941", "Masterton",
"6469201", "Ruatoria",
"6433954", "Lawrence",
"6439704", "Murchison",
"64399", "South\ Island",
"6473990", "Te\ Awamutu",
"6469040", "Wairoa",
"643946", "Invercargill",
"64789", "Taumarunui",
"6469246", "Palmerston\ North",
"6436615", "Ashburton",
"6463906", "Napier",
"6432991", "Milton",
"6472458", "Rotorua",
"6436682", "Dunedin",
"649902", "Warkworth",
"643393", "Christchurch",
"646374", "Dannevirke",
"6436647", "Te\ Anau",
"6499747", "Dargaville",
"644577", "Wellington",
"6469577", "Ohakune",
"6466527", "Taihape",
"6432658", "Murchison",
"647888", "Matamata",
"6439024", "Lumsden",
"6493934", "Kaitaia",
"6433996", "Edendale",
"6478995", "Matamata",
"6435674", "Milton",
"64636", "Levin",
"6435557", "Geraldine",
"6435505", "Akaroa",
"6439347", "Christchurch",
"6462151", "New\ Plymouth",
"6432427", "Greymouth",
"64377", "South\ Island",
"643425", "Dunedin",
"6498018", "Whangarei",
"6439315", "Tokanui",
"647245", "Hamilton",
"6439273", "Blenheim",
"6469853", "Waiouru",
"6479847", "Te\ Awamutu",
"647552", "Tauranga",
"6475824", "Hamilton",
"6478131", "Otorohanga",
"6475623", "Tauranga",
"6468809", "Masterton",
"6472627", "Rotorua",
"6499012", "Kawakawa",
"6496010", "Kaitaia",
"646843", "Napier\/Hastings",
"6467529", "Mokau",
"6465950", "Palmerston\ North",
"646387", "Waiouru",
"647217", "Taupo",
"644897", "Wellington",
"6499295", "Kaikohe",
"6499043", "Hibiscus\ Coast",
"6439756", "Akaroa",
"646764", "Stratford",
"647462", "Taupo",
"6499471", "Hibiscus\ Coast",
"6468808", "Palmerston\ North",
"6477776", "Whangamata",
"6434351", "Mt\ Cook",
"646838", "Wairoa",
"6432747", "Queenstown",
"6497773", "Dargaville",
"646866", "Gisborne\/Ruatoria",
"64757", "Tauranga",
"6498019", "Pukekohe",
"643442", "Queenstown",
"6436527", "Haast",
"6432715", "Culverden",
"6499877", "Maungaturoto",
"6463996", "Palmerston\ North",
"643752", "Franz\ Josef",
"644975", "Paraparaumu",
"64336", "South\ Island",
"6499553", "Kaikohe",
"6478081", "Rotorua",
"6472126", "Otorohanga",
"6462144", "Ruatoria",
"6432659", "Takaka",
"6469315", "Taihape",
"6496997", "Hibiscus\ Coast",
"647863", "Waihi",
"6439853", "Amberley",
"6469273", "New\ Plymouth",
"64734", "Rotorua",
"6472459", "Rotorua",
"6434996", "Roxburgh",
"6439521", "Dunedin",
"6437474", "Oamaru",
"6472804", "Whangamata",
"6466013", "Featherston",
"6472603", "Hamilton",
"6475607", "Morrinsville",
"643939", "South\ Island",
"647989", "Taupo",
"6435519", "Twizel",
"6462617", "Masterton",
"6498856", "Maungaturoto",
"6439533", "Geraldine",
"6465613", "Wairoa",
"6439336", "Cromwell",
"6468882", "Napier\/Hastings",
"6439067", "Franz\ Josef",
"6433980", "Milton",
"6469468", "Featherston",
"6468815", "Pahiatua",
"6432222", "Christchurch",
"6479240", "Taupo",
"6499452", "Warkworth",
"6434283", "Cromwell",
"643270", "Christchurch",
"6479750", "Tauranga",
"643669", "Christchurch",
"6469291", "Gisborne",
"6479001", "Hamilton",
"643221", "Invercargill",
"649406", "Kaitaia",
"6437770", "Nelson",
"6436593", "Nelson",
"643461", "Dunedin\/Palmerston",
"6439711", "Geraldine",
"644211", "Wellington",
"6433941", "Blenheim",
"6435687", "Lumsden",
"6436636", "Waimate",
"6435661", "Fairlie",
"6469308", "Opunake",
"646946", "Masterton",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6439040", "Balclutha",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;