#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Tone::Trapezium;

  use Moose;
  
  extends 'Narwhal::Tone';

  has 'rise' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  has 'fall' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  has 'drop' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );
  
  sub gencmd {
    my $self = shift;
    my $ret = sprintf("%s %s %s %s %s",$self->fm,$self->note,$self->rise,$self->fall,$self->drop);
    return($ret);
  }
}

1;
